/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

/**
 *
 * \file UH_I2CReg88PG870.h
 *
 * \brief Contians structures and prototypes to help control I2C
 * regulator
*
 *
 * \warning This will alter core voltages - be aware of it's power!!!
 *
 **/

#ifndef UH_I2CREG88PG870_H
#define UH_I2CREG88PG870_H

#include <stdint.h>
#include <stdbool.h>

/*------------------------------------------------------------------------
						Function Prototypes
------------------------------------------------------------------------*/

uint32_t	Enable_AVS_Patch_I2CReg88PG870(void);
uint32_t	Enable_AVS_Mode_I2CReg88PG870(void);
bool		board_has_88PG870_regulator(void);

#endif // UH_I2CREG88PG870_H

/* Used by vim and some versions of vi: set tabstop=4 shiftwidth=4: */
