/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

/**
 *
 * \file UH_AVS.h
 *
 * \brief Contians structures and prototypes to help control AVS
 *
 *
 * \warning This will alter core voltages - be aware of it's power!!!
 *
 **/


#ifndef UH_AVS_H
#define UH_AVS_H

#if 0
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>

#include "UTF_Struct.h"
#include "UTF.h"
#include "UTF_Serial.h"
#include "regAddrs.h"
#include "UTF_ErrorCodes.h"
#include "UTF_MessageHandler.h"
#include "UTF_Timers.h"

#include "MPMU_regheaders.h"
#include "BCM_regheaders.h"
#include "APB_Top_regheaders.h"
#else
#include "regAddrs.h"
#include "MPMU_regheaders.h"
#include "BCM_regheaders.h"
#include "apb_top_regheaders.h"
#include "cpu_api.h"
#include "minPrintf.h"
#include "ID_utils.h"

#define msg(x,y,...) minPrintf(__VA_ARGS__)
#define UTF_waitForMicroSecs(x) cpu_spin_delay(x)
#define UTF_FAIL 0
#endif

#define REG_VAL_DEFAULT		0x0C

#define EFUSE_BURNED        (1)


/*------------------------------------------------------------------------
                        Type Definition
------------------------------------------------------------------------*/

typedef enum
{
    AVS_VOLTS_747MV  =  747,
    AVS_VOLTS_758MV  =  758,
    AVS_VOLTS_770MV  =  770,
    AVS_VOLTS_782MV  =  782,
    AVS_VOLTS_793MV  =  793,
    AVS_VOLTS_805MV  =  805,
    AVS_VOLTS_817MV  =  817,
    AVS_VOLTS_828MV  =  828,
    AVS_VOLTS_840MV  =  840,
    AVS_VOLTS_852MV  =  852,
    AVS_VOLTS_863MV  =  863,
    AVS_VOLTS_875MV  =  875,
    AVS_VOLTS_887MV  =  887,
    AVS_VOLTS_898MV  =  898,
    AVS_VOLTS_910MV  =  910,
    AVS_VOLTS_922MV  =  922,
    AVS_VOLTS_933MV  =  933,
    AVS_VOLTS_945MV  =  945,
    AVS_VOLTS_957MV  =  957,
    AVS_VOLTS_968MV  =  968,
    AVS_VOLTS_980MV  =  980,
    AVS_VOLTS_992MV  =  992,
    AVS_VOLTS_1003MV = 1003,
    AVS_VOLTS_1015MV = 1015,
    AVS_VOLTS_1027MV = 1027,
    AVS_VOLTS_1038MV = 1038,
    AVS_VOLTS_1050MV = 1050,
    AVS_VOLTS_1062MV = 1062,
    AVS_VOLTS_1073MV = 1073,
    AVS_VOLTS_1085MV = 1085,
    AVS_VOLTS_1097MV = 1097,
    AVS_VOLTS_1108MV = 1108,
    AVS_VOLTS_1120MV = 1120,
    AVS_VOLTS_1132MV = 1132,
    AVS_VOLTS_1143MV = 1143,
    AVS_VOLTS_1155MV = 1155,
    AVS_VOLTS_1167MV = 1167,
    AVS_VOLTS_1178MV = 1178,
    AVS_VOLTS_1190MV = 1190,
    AVS_VOLTS_1202MV = 1202,
    AVS_VOLTS_1213MV = 1213,
    AVS_VOLTS_1225MV = 1225,
    AVS_VOLTS_1237MV = 1237,
    AVS_VOLTS_1248MV = 1248,
    AVS_VOLTS_1260MV = 1260,
    AVS_VOLTS_1272MV = 1272,
    AVS_VOLTS_1283MV = 1283,
    AVS_VOLTS_1295MV = 1295,
    AVS_VOLTS_1307MV = 1307,
    AVS_VOLTS_1318MV = 1318,
    AVS_VOLTS_1330MV = 1330,
    AVS_VOLTS_1342MV = 1342,
} AVS_VOLTAGE_OPTIONS;

#define AVS_PRINTF(...)  msg(MSG_STATUS, UTF_SOURCE_NAME, __VA_ARGS__)
#define AVS_DEBUG_PRINTF(...)  msg( MSG_DEBUG, UTF_SOURCE_NAME, __VA_ARGS__)

/*------------------------------------------------------------------------
                        Global Variable Definition
------------------------------------------------------------------------*/

/*------------------------------------------------------------------------
                        Function Prototypes
------------------------------------------------------------------------*/
uint32_t set_AVS_Voltage(AVS_VOLTAGE_OPTIONS voltage); // Change Voltage and enable
uint32_t set_AVS_FixedDRO(uint32_t targetDRO, AVS_VOLTAGE_OPTIONS lowLimit, AVS_VOLTAGE_OPTIONS highLimit); // Set AVS in DRO Mode
bool set_AVS_To_Efuse_Values(void);

void initAVS(void);
void reset_AVS(void);
void reset_min_max(void);
uint32_t get_AVS_enable_status(void);
void enable_AVS(void);
void disable_AVS(void);
uint32_t change_AVS_Voltage(AVS_VOLTAGE_OPTIONS voltage); // Change Voltage only
uint32_t readAVSLimitflags(void);

uint32_t readAVS_BG_Cal(void);
uint32_t readAVSFastTravel(void);
uint32_t readAVSAboveLimit(void);
uint32_t readAVSBelowLimit(void);
uint32_t readAVSDelta(void);
uint32_t readAVSMaxDelta(void);
uint32_t readAVSMinDelta(void);

uint32_t readCurrentDRO(void);
uint32_t readMinMaxDRO(void);
uint32_t readAVSstatus(void);
uint32_t DROParityCheck(uint32_t Efuse_DRO);
uint32_t readEfuseDRO(void);


#endif //UH_AVS_H





























