/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2007-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

//#include "bootCode.h"
#include "utils.h"
//#include "authentication.h"
#include "cpu_api.h"
#include "error_types.h"
//#include "io.h"

#define OVERRIDE_CHKPT_MASK 0x00000003  ///< The bits in the override address used for checkpoints.
#define OVERRIDE_LOBIT_MASK 0x3 ///< the mask for the low bits of the override address.

extern uint32_t xthal_get_ccount(void);
extern uint32_t lcm_buffer[];

/**
 * \brief busy wait for a specified number of microseconds.  
 * Delay is done by checking the processor cycle count.
 * \param delayInUs[in] The delay required in u secs.
 */
void Delay(uint32_t delayInUs)
{
    // break it down into 1 second segments
    while (delayInUs > SECOND)
    {
        cpu_spin_delay(SECOND);
        delayInUs -= SECOND;
    }
    cpu_spin_delay(delayInUs);
}


/**
// \brief poll a register until it has the requested value, or until time runs out
//
// \param[in] pollReg - address of the register to poll
// \param[in] mask - value to AND with the returned value from the register
// \param[in] result - value to compare against the masked register value
// \param[in] pollInterval - interval to wait before the next poll
// \param[in] count - how many times to poll
// \param[in] equals - if TRUE,  poll until result == masked register value
//          if FALSE, poll until result != masked register value
 * \retval STATUS_OK and FAIL
 */
error_type_t PollReg(volatile uint32_t *pollReg, uint32_t result, uint32_t mask, uint32_t pollInterval, uint32_t count, uint32_t equals)
{
   uint32_t i, regVal, found;
   error_type_t status;

   status = STATUS_OK;
   found = false;
   
   for (i=0;i<count;i++)
   {
      regVal = *pollReg;
      
      if (equals == EQUALS)
      {
         if ((regVal & mask) == result)
         {
            found = true;
            break;
         }
      }
      else
      {
         if ((regVal & mask) != result)
         {
            found = true;
            break;
         }
      }
      if (pollInterval != 0)
         Delay(pollInterval);
   }
   if (found == false)
   {
      status = FAIL;
   }
   return (status);
}



//
// poll a function until it returns the requested value, or until time runs out
//  **** Note that this only works for functions that take no parameters ****
// PollFunc - pointer to the function to execute and poll on return value
// mask - value to AND with the returned value from the function
// result - value to compare against the masked function return value
// pollInterval - interval to wait before the next poll
// count - how many times to poll
// equals - if TRUE (EQUALS),  poll until result == masked function return value
//          if FALSE (NOT_EQUAL), poll until result != masked function return value
error_type_t PollFunc(unsigned char pollFunc(), uint32_t result, uint32_t mask, uint32_t pollInterval, uint32_t count, uint32_t equals)
{
   uint32_t i, retVal, found;
   error_type_t status;

   status = STATUS_OK;
   found = false;
   
   for (i=0;i<count;i++)
   {
      retVal = pollFunc();
      
      if (equals == EQUALS)
      {
         if ((retVal & mask) == result)
         {
            found = true;
            break;
         }
      }
      else
      {
         if ((retVal & mask) != result)
         {
            found = true;
            break;
         }
      }
      if (pollInterval != 0)
         Delay(pollInterval);
   }
   if (found == false)
   {
      status = FAIL;
   }
   return (status);
}

int ffs(int int_val)
{
    int pos = 1;
    int tmp = 1;

    if (int_val == 0) return 0;

    while(0 == ( int_val & tmp))
    {
        tmp <<= 1;
        pos ++;
    }

    return pos;
}
