/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2008-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

#include "uart.h"
#include "regAddrs.h"
#include "board_types.h"
#include "ID_utils.h"

// Include the specific device this system will use that we are adapting to.
#include "dwApbUart.h"

#define FPGA_CLK_CONST      (130)   // equivalent to 13 mhz clock freq * 10
#define SI_CLK_CONST        (125)   // equivalent to 25 mhz clock div by 2

void dbg_uart_init( board_types_e board_type, int baudrate )
{
	dwApb_uart_init( DBG_UART, baudrate, (is_Si()?SI_CLK_CONST:FPGA_CLK_CONST) );
	dwApb_uart_init( 1, baudrate, (is_Si()?SI_CLK_CONST:FPGA_CLK_CONST) );
//	dwApb_uart_init( 2, baudrate, (is_Si()?SI_CLK_CONST:FPGA_CLK_CONST) );  /*  This is for engine debug serial  */
	dwApb_uart_init( 3, baudrate, (is_Si()?SI_CLK_CONST:FPGA_CLK_CONST) );
}

void dbg_uart_out( uint8_t c )
{
	dwApb_uart_out( DBG_UART, c);
}

void dbg_uart_puts( uint8_t *s )
{
	dwApb_uart_puts( DBG_UART, s);
}

uint8_t dbg_uart_in( void )
{
	return (dwApb_uart_in( DBG_UART ));
}

void dbg_uart_enable_rcvr_int( void )
{
	dwApb_uart_enable_rcvr_int( DBG_UART );
}

void dbg_uart_disable_rcvr_int( void )
{
	dwApb_uart_disable_rcvr_int( DBG_UART );
}

