/** 
 * ============================================================================
 * (C) Portions Copyright 2007-2014   Marvell International Ltd.
 * ============================================================================
 */

/*---------------------------------------------------*/
/* Public Domain version of printf                   */
/*                                                   */
/* Rud Merriam, Compsult, Inc. Houston, Tx.          */
/*                                                   */
/* For Embedded Systems Programming, 1991            */
/*                                                   */
/*---------------------------------------------------*/

#include <stdarg.h>
#include <stddef.h>
#include "bootCode.h"
#include "uart.h"

/*---------------------------------------------------*/
/* The purpose of this routine is to output data the */
/* same as the standard printf function without the  */
/* overhead most run-time libraries involve. Usually */
/* the printf brings in many kiolbytes of code and   */
/* that is unacceptable in most embedded systems.    */
/*---------------------------------------------------*/

/*---------------------------------------------------*/
/* Modifed   9/4/2003                    */
/*---------------------------------------------------*/

#define GETBOOTSTATUS(n) (0)

//void uart_out( char c );
//void minSprintf(char* buf, char* ctrl, ...);
void minVsprintf(char* buf, char* ctrl, va_list argp);

typedef void (*out_func_ptr)(char c);
//typedef char* charptr;

static out_func_ptr out_char    __attribute__ ((section (".lcm.minprintf")));
static int do_padding           __attribute__ ((section (".lcm.minprintf")));
static int left_flag            __attribute__ ((section (".lcm.minprintf")));
static int len                  __attribute__ ((section (".lcm.minprintf")));
static int num1                 __attribute__ ((section (".lcm.minprintf")));
static int num2                 __attribute__ ((section (".lcm.minprintf")));
static char pad_character       __attribute__ ((section (".lcm.minprintf")));

static char* g_BufPtr           __attribute__ ((section (".lcm.minprintf")));

static char Tolower(char c)
{
    int ci = (int) c;
    if ((ci >= 0x41) & (ci <= 0x60))
        c = (char) (ci + 0x20);
    return c;
}

static bool Isdigit(char c)
{
    int n = (int) c;
    return((n >= 0x30) & (n <= 0x39));
}

static bool IsCtrl(char c)
{
    int n = (int) c;
    return(n < 0x20);
}

static bool IsPrintable(char c)
{
    int n = (int) c;
    return((n >= 0x20) & (n < 0x7f));
}

static unsigned int Strlen(const char *str)
{
    const char *st;
    for (st = str; *st != '\0'; ++st)
        /* intentionally empty */ ;
    return (st - str);
}

static void buf_out(char c)
{

    *g_BufPtr++ = c; 
}

/*---------------------------------------------------*/
/*                                                   */
/* This routine puts pad characters into the output  */
/* buffer.                                           */
/*                                                   */
static void padding( const int l_flag)
{
   int i;

   if (do_padding && l_flag && (len < num1))
      for (i=len; i<num1; i++)
          out_char( pad_character);
   }

/*---------------------------------------------------*/
/*                                                   */
/* This routine move a string to the output buffer   */
/* as directed by the padding and positioning flags. */
/*                                                   */
static void outs( char* lp)
{
   /* pad on left if needed                          */
   len = Strlen( lp);
   padding( !left_flag);

   /* Move string to the buffer                      */
   while (*lp && num2--)
      out_char( *lp++);

   /* Pad on right if needed                         */
   len = Strlen( lp);
   padding( left_flag);
   }

/*---------------------------------------------------*/
/*                                                   */
/* This routine moves a number to the output buffer  */
/* as directed by the padding and positioning flags. */
/*                                                   */
static void outnum( long num, const long base)
{

   char* cp;
   int negative;
   char outbuf[32];
   char digits[16];

   unsigned long unum;

   /* Check if number is negative    
                   */
   for(negative = 0; negative < 10; negative++)
   {
       digits[negative] = (char) negative + 0x30;
   }
   for(negative = 0; negative < 6; negative++)
   {
       digits[negative + 10] = (char) negative + 0x41;
   }
   if(base != 16)
   {
       if (num < 0L ) 
       {
           negative = 1;
           num = -num;
       }
       else
           negative = 0;

       /* Build number (backwards) in outbuf             */
       cp = outbuf;
       do {
           *cp++ = digits[(int)(num % base)];
       } while ((num /= base) > 0);
       if (negative)
           *cp++ = '-';
       *cp-- = 0;
   }
   else     // treat all hex numbers as unsigned
   {
       unum = (unsigned long)num;
       /* Build number (backwards) in outbuf             */
       cp = outbuf;
       do {
           *cp++ = digits[(int)(unum % base)];
       } while ((unum /= base) > 0);
       *cp-- = 0;
   }

   /* Move the converted number to the buffer and    */
   /* add in the padding where needed.               */
   len = Strlen(outbuf);
   padding( !left_flag);
   while (cp >= outbuf)
      out_char( *cp--);
   padding( left_flag);
   }

/*---------------------------------------------------*/
/*                                                   */
/* This routine gets a number from the format        */
/* string.                                           */
/*                                                   */
static int getnum( char** linep)
{
   int n;
   char* cp;

   n = 0;
   cp = *linep;
   while (Isdigit(*cp))
      n = n*10 + ((*cp++) - '0');
   *linep = cp;
   return(n);
}

/*---------------------------------------------------*/
/*                                                   */
/* These routines operates just like a printf/sprintf  */
/* routine. It outputs a set of data under the       */
/* control of a formatting string. Not all of the    */
/* standard C format control are supported. The ones */
/* provided are primarily those needed for embedded  */
/* systems work. Primarily the floaing point         */
/* routines are omitted. Other formats could be      */
/* added easily by following the examples shown for  */
/* the supported formats.                            */
/*                                                   */

void minPrintf(char *pFormat, ...)
{
    if (GETBOOTSTATUS(eDisableSerial))
    {
        return;
    }
    va_list ap;

    //
    // Get the variable argument list and pass it to sprintf.
    va_start( ap, pFormat );
    // Need to use minSprintf to do actual format and print of string
    minVsprintf( NULL, pFormat, ap );
    va_end( ap );
}

void minSprintf(char* buf, char* ctrl, ...)
{
    va_list ap;

    //
    // Get the variable argument list and pass it to sprintf.
    va_start( ap, ctrl );
    // Need to use minSprintf to do actual format and print of string
    minVsprintf( buf, ctrl, ap );
    va_end( ap );
}

// NOTE THAT THIS ROUTINE IS NOT REENTRANT.  IF YOU NEED TO CALL IT FROM
// MULTIPLE THREADS YOU NEED TO SEMAPHORE PROTECT IT. 
void minVsprintf(char* buf, char* ctrl, va_list argp)
{

   int long_flag;
   int dot_flag;

   char ch;
//   va_list argp;

   if(buf == NULL)
   {
       out_char = (out_func_ptr)dbg_uart_out;
#if 0
       if (g_ProgramTable == PROGRAM_RUNNING_M3)
       {
           // VERY UNIQUE situation - m3 processor with different address map is running this code compiled for R4
           uint32_t addr = (uint32_t)out_char;
           addr |= 0x08000000 ; // set for NON CACHE ADDRESS 0xFF--
           addr &= ~(0x20000000) ; // set for 0xDF-- address
           out_char = (out_func_ptr)addr;
       }
#endif
   }
   else
   {
       out_char = buf_out;
       g_BufPtr = buf;
   }

//   va_start( argp, ctrl);
#if 0
   if (g_flags1 & 1)
   {
       UARTDirect('P');  // just note a print occurred.
       return;
   }
#endif
   for ( ; *ctrl; ctrl++) {

      /* move format string chars to buffer until a  */
      /* format control is found.                    */
      if ((*ctrl != '%') && IsPrintable(*ctrl)) {
         out_char(*ctrl);
         continue;
      }

      if (IsCtrl(*ctrl))
      {
          if (*ctrl == 0x0A)
          {
              out_char( 0x0A);
              out_char( 0x0D);
          }
          else 
          {
              out_char( *ctrl);
          }
          continue;
      }

      /* initialize all the flags for this format.   */
      dot_flag   =
      long_flag  =
      left_flag  =
      do_padding = 0;
      pad_character = ' ';
      num2=32767;

try_next:
      ch = *(++ctrl);

      if (Isdigit(ch)) {
         if (dot_flag)
            num2 = getnum(&ctrl);
         else {
            if (ch == '0')
               pad_character = '0';

            num1 = getnum(&ctrl);
            do_padding = 1;
         }
         ctrl--;
         goto try_next;
      }

      ch = Tolower(ch);
      if (ch == '%')
      {
          out_char( '%');
          continue;
      }
      else if (ch == '-')
      {
          left_flag = 1;
      }
      else if (ch == '.')
      {
          dot_flag = 1;
      }
      else if (ch == 'l')
      {
          long_flag = 1;
      }
      else if (ch == 'd')
      {
          if (long_flag || ch == 'D') {
             outnum( va_arg(argp, long), 10L);
             continue;
             }
          else {
             outnum( va_arg(argp, int), 10L);
             continue;
             }
      }
      else if (ch == 'x')
      {
          outnum( (long)va_arg(argp, int), 16L);
          continue;
      }
      else if (ch == '#')
      {
          out_char('0');
          out_char('x');
      }
      else if (ch == 's')
      {
          outs( va_arg( argp, char*));
          continue;
      }
      else if (ch == 'c')
      {
          out_char( va_arg( argp, int));
          continue;
      }
      else
      {
          continue;
      }

      goto try_next;
      }
//   va_end( argp);

   if(buf != NULL)
   {
       // if we're printing to a buffer, null terminate it
       buf_out('\0');
   }
}

/*---------------------------------------------------*/

