/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2007-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/
 
#include <string.h>

void* memcpy(void *dest, const void *src, size_t len)
{
	void *ret;
	ret	= dest;

/*	dst in r0, src in r1, len in r2 */

	asm volatile 
	(
/* If the size is small, or either SRC or DST is unaligned,
	then punt into the byte copy loop.  This should be rare.  */

"	mov	r10, r2				\n\t" // copy len to r10
"	orr	r3, r0, r1			\n\t"
"	and	r3, r3, #3			\n\t" // Check for word alignment
"	cmp	r3, #0				\n\t"
"	bne	_bytecopy			\n\t" 

"	cmp	r10, #31			\n\t" // Check len > 8 longs
"	bls	_4wordcopy			\n\t"
"	orr	r3, r0, r1			\n\t"
"	and	r3, r3, #7			\n\t" // Check for double word alignment
"	cmp	r3, #0				\n\t"
"	bne	_wordcopy	 		\n\t"

"	.global	_8wordcopy		\n\t"
"_8wordcopy:				\n\t"
"	cmp	r10, #31			\n\t" // Check len > 8 words
"	bls	_4wordcopy			\n\t"
"	ldmia	r1!, {r2-r9}	\n\t" // load 8 words
"	stmia	r0!, {r2-r9}	\n\t" // store 8 words
"	sub	r10, r10, #32		\n\t" // decr len by 32
"	b	_8wordcopy			\n\t" // jump back to top of loop

"	.global	_4wordcopy		\n\t"
"_4wordcopy:				\n\t"
"	cmp	r10, #0				\n\t"
"	beq	_done				\n\t"
"	cmp	r10, #15			\n\t" // Check len > 4 words
"	bls	_wordcopy			\n\t"
"	ldmia	r1!, {r2-r5}	\n\t" // load 4 words
"	stmia	r0!, {r2-r5}	\n\t" // store 4 words
"	sub	r10, r10, #16		\n\t" // decr len by 16
"	b	_4wordcopy			\n\t" // jump back to top of loop

"	.global	_wordcopy		\n\t"
"_wordcopy:					\n\t"
"	cmp	r10, #0				\n\t"
"	beq	_done				\n\t"
"	cmp	r10, #3				\n\t" // Check len > 1 words
"	bls	_bytecopy			\n\t"
"	ldr	r2, [r1]			\n\t" // load 1 words
"	str	r2, [r0]			\n\t" // store 1 words
"	add	r0, r0, #4			\n\t" // add 4 to dst
"	add	r1, r1, #4			\n\t" // add 4 to src
"	sub	r10, r10, #4		\n\t" // decr len by 4
"	b	_wordcopy			\n\t" // jump back to top of loop

"	.global	_bytecopy		\n\t"
"_bytecopy:					\n\t"
"	cmp	r10, #0				\n\t"
"	beq	_done				\n\t"
"	ldrb	r2, [r1]		\n\t"
"	strb	r2, [r0]		\n\t"
"	add	r0, r0, #1			\n\t"
"	add	r1, r1, #1			\n\t"
"	sub	r10, r10, #1		\n\t"
"	b	_bytecopy			\n\t"

"_done:						\n\t"

		::: "r4", "r5","r6","r7","r8","r9","r10","ip","lr"
	);
	return ret;
}
/* Used by vim and some versions of vi: set tabstop=4 shiftwidth=4: */
