/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2007-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/
 
#include <string.h>

int memcmp(const void *s1, const void *s2, size_t n)
{
    const unsigned char *cs1 = s1;
    const unsigned char *cs2 = s2;

    while (n--) {
        if (*cs1 > *cs2)
            return 1;
        else if (*cs1 < *cs2)
            return -1;

        ++cs1;
        ++cs2;
    };

    return 0;
}
/* Used by vim and some versions of vi: set tabstop=4 shiftwidth=4: */
