/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2007-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

#include <string.h>
#include "minPrintf.h"

#define isprint(c) (((c)>31) && ((c)<127))?1:0
void hex_dump( const void *start_addr, unsigned int size )
{
    static char hex_ascii[] =
    { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };
    int i;
    unsigned char line[80];
    unsigned char *ascii, *hex;
    unsigned char *ptr = (unsigned char*) start_addr;
    unsigned char *endptr;
    unsigned long offset=(unsigned long)ptr;

    endptr = ptr + size;
    memset( line, ' ', 80 );
    line[69] = 0;
    while( ptr != endptr ) {
        hex = &line[2];
        ascii = &line[52];
        for( i=0 ; i<16 ; i++ ) {
            if( isprint(*ptr) )
                *ascii++ = *ptr;
            else
                *ascii++ = '.';
            *hex++ = hex_ascii[ *ptr>>4 ];
            *hex++ = hex_ascii[ *ptr&0x0f ];
            *hex++ = ' ';
            ptr++;
            if( ptr == endptr ) {
                /* clean out whatever is left from the last line */
                memset( hex, ' ', (15-i)*3 );
                memset( ascii, ' ', 15-i );
                break;
            }
        }
        minPrintf("0x%08lx %s\n", offset, line );
        offset += 16;
    }
}
