/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2007-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the G
General Public License Version 2, and any use shall comply with the term
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOS
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details a
this warranty disclaimer.
*/

/*
int __aeabi_idiv(int numerator, int denominator);
unsigned __aeabi_uidiv( unsigned numerator, unsigned denominator);

typedef struct {
	int quot;
	int rem;
} idiv_return;

typedef struct {
	unsigned quot;
	unsigned rem;
} uidiv_return;

__value_in_regs idiv_return __aeabi_idivmod(int numerator, int denominator);
__value_in_regs uidiv_return __aeabi_uidivmod( unsigned numerator, unsigned denominator);
*/
   .macro GLOBAL label
   .global \label
   .type \label, %function
   .endm

GLOBAL __aeabi_uidiv
__aeabi_uidiv:
    	subs	r2, r1, #1
    	bxeq	lr
    	bcc	    6f
    	cmp     r0, r1
    	bls	    4f
    	tst     r1, r2
    	beq     5f
    	tst     r1, #0xe0000000
    	lsleq	r1, r1, #3
    	moveq	r3, #8
    	movne	r3, #1
1:  	cmp     r1, #0x10000000
    	cmpcc	r1, r0
    	lslcc	r1, r1, #4
    	lslcc	r3, r3, #4
    	bcc     1b // <__aeabi_uidiv+0x2c>
2:  	cmp	    r1, #0x80000000
    	cmpcc	r1, r0
    	lslcc	r1, r1, #1
    	lslcc	r3, r3, #1
    	bcc     2b // <__aeabi_uidiv+0x40>
    	mov     r2, #0
3:  	cmp     r0, r1
    	subcs	r0, r0, r1
    	orrcs	r2, r2, r3
    	cmp	r0, r1, lsr #1
    	subcs	r0, r0, r1, lsr #1
    	orrcs	r2, r2, r3, lsr #1
    	cmp	r0, r1, lsr #2
    	subcs	r0, r0, r1, lsr #2
    	orrcs	r2, r2, r3, lsr #2
    	cmp	r0, r1, lsr #3
    	subcs	r0, r0, r1, lsr #3
    	orrcs	r2, r2, r3, lsr #3
    	cmp     r0, #0
//    	lsrsne	r3, r3, #4  Don't know why, but the compiler won't do the 'S' bit.
        .word 0x11b03223 	
    	lsrne	r1, r1, #4
    	bne     3b  // <__aeabi_uidiv+0x58>
    	mov     r0, r2
    	bx	    lr
4:  	moveq	r0, #1
    	movne	r0, #0
    	bx	    lr
5:  	cmp     r1, #0x10000
    	lsrcs	r1, r1, #16
    	movcs	r2, #16
    	movcc	r2, #0
    	cmp     r1, #0x100
    	lsrcs	r1, r1, #8
    	addcs	r2, r2, #8
    	cmp     r1, #16
    	lsrcs	r1, r1, #4
    	addcs	r2, r2, #4
    	cmp     r1, #4
    	addhi	r2, r2, #3
    	addls	r2, r2, r1, lsr #1
    	lsr     r0, r0, r2
    	bx	    lr
6:  	cmp     r0, #0
    	mvnne	r0, #0
    	bx	    lr

// unsigned int __aeabi_uidivmod(unsigned int numerator, unsigned int denominator)
GLOBAL __aeabi_uidivmod
__aeabi_uidivmod:
    	cmp     r1, #0
    	beq     6b      // <__aeabi_uidiv+0xe8>
    	push	{r0, r1, lr}
    	bl	    __aeabi_uidiv
    	pop     {r1, r2, lr}
    	mul     r3, r2, r0
    	sub     r1, r1, r3
    	bx	    lr

// int __aeabi_idiv(int numerator, int denominator);
GLOBAL __aeabi_idiv
__aeabi_idiv:
    	cmp     r1, #0
    	beq     7f

__divsi3_skip_div0_test:
     	eor     ip, r0, r1
     	rsbmi	r1, r1, #0
     	subs	r2, r1, #1
     	beq     4f
     	movs	r3, r0
     	rsbmi	r3, r0, #0
     	cmp     r3, r1
     	bls     5f
     	tst     r1, r2
     	beq     6f
     	tst     r1, #0xe0000000
     	lsleq	r1, r1, #3
     	moveq	r2, #8
     	movne	r2, #1
 1:     cmp     r1, #0x10000000
     	cmpcc	r1, r3
     	lslcc	r1, r1, #4
     	lslcc	r2, r2, #4
     	bcc     1b
 2:     cmp     r1, #0x80000000
     	cmpcc	r1, r3
     	lslcc	r1, r1, #1
     	lslcc	r2, r2, #1
     	bcc     2b
     	mov     r0, #0
 3:     cmp     r3, r1
     	subcs	r3, r3, r1
     	orrcs	r0, r0, r2
     	cmp     r3, r1, lsr #1
     	subcs	r3, r3, r1, lsr #1
     	orrcs	r0, r0, r2, lsr #1
     	cmp     r3, r1, lsr #2
     	subcs	r3, r3, r1, lsr #2
     	orrcs	r0, r0, r2, lsr #2
     	cmp     r3, r1, lsr #3
     	subcs	r3, r3, r1, lsr #3
     	orrcs	r0, r0, r2, lsr #3
     	cmp     r3, #0
//    	lsrsne	r2, r2, #4  Don't know why, but the compiler won't do the 'S' bit.
        .word 0x11b02222 	
     	lsrne	r1, r1, #4
     	bne     3b
     	cmp     ip, #0
     	rsbmi	r0, r0, #0
     	bx	    lr
4:      teq     ip, r0
     	rsbmi	r0, r0, #0
     	bx	    lr
5:      movcc	r0, #0
     	asreq	r0, ip, #31
     	orreq	r0, r0, #1
     	bx	    lr
6:      cmp	    r1, #0x10000
     	lsrcs	r1, r1, #16
     	movcs	r2, #16
     	movcc	r2, #0
     	cmp	    r1, #0x100
     	lsrcs	r1, r1, #8
     	addcs	r2, r2, #8
     	cmp	    r1, #16
     	lsrcs	r1, r1, #4
     	addcs	r2, r2, #4
     	cmp	    r1, #4
     	addhi	r2, r2, #3
     	addls	r2, r2, r1, lsr #1
     	cmp	    ip, #0
     	lsr	    r0, r3, r2
     	rsbmi	r0, r0, #0
     	bx	    lr
7:      cmp     r0, #0
     	mvngt	r0, #0x80000000
     	movlt	r0, #0x80000000
     	bx      lr

// __value_in_regs idiv_return __aeabi_idivmod(int numerator, int denominator);
GLOBAL __aeabi_idivmod
__aeabi_idivmod:
        cmp     r1, #0
        beq	    7b
        push	{r0, r1, lr}
        bl	    __divsi3_skip_div0_test
        pop     {r1, r2, lr}
        mul     r3, r2, r0
        sub     r1, r1, r3
        bx	    lr
