/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2007, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/
 
#ifndef __DELAY_H
#define __DELAY_H

#include <stdint.h>
#include <stdbool.h>
#include "error_types.h"

extern void Delay( uint32_t delayInUs ); 
error_type_t PollReg(volatile uint32_t *pollReg, uint32_t result, uint32_t mask, uint32_t pollInterval, uint32_t count, uint32_t equals);
error_type_t PollFunc(unsigned char pollFunc( void ), uint32_t result, uint32_t mask, uint32_t pollInterval, uint32_t count, uint32_t equals);
void DoOverRideTable(uint8_t CheckPoint);

int ffs (int int_val);

#define MICROSEC	1
#define MILLISEC	1000
#define SECOND		1000000

// polling defines
#define USEC_1   1
#define USEC_2   2
#define USEC_3   3
#define USEC_4   4
#define USEC_10  10
#define USEC_100 100
#define MSEC_1   1000
#define MSEC_10  10000
#define MSEC_100 100000
#define EQUALS    true
#define NOT_EQUAL false


#endif //ifndef __DELAY_H
