#ifndef __TPM_H__
#define __TPM_H__

#define TPM_HEADER_LENGTH		10
#define TPM_BUFFER_LENGTH		1260
#define TPM_PCR_DIGEST_LENGTH		20	/* 160 bits */

/* 3.1. TPM_STRUCTURE_TAG */
#define TPM_TAG_CONTEXTBLOB		0x0001
#define TPM_TAG_CONTEXT_SENSITIVE	0x0002
#define TPM_TAG_CONTEXTPOINTER		0x0003
#define TPM_TAG_CONTEXTLIST		0x0004
#define TPM_TAG_SIGNINFO		0x0005
#define TPM_TAG_PCR_INFO_LONG		0x0006
#define TPM_TAG_PERSISTENT_FLAGS	0x0007
#define TPM_TAG_VOLATILE_FLAGS		0x0008
#define TPM_TAG_PERSISTENT_DATA		0x0009
#define TPM_TAG_VOLATILE_DATA		0x000A
#define TPM_TAG_SV_DATA			0x000B
#define TPM_TAG_EK_BLOB			0x000C
#define TPM_TAG_EK_BLOB_AUTH		0x000D
#define TPM_TAG_COUNTER_VALUE		0x000E
#define TPM_TAG_TRANSPORT_INTERNAL	0x000F
#define TPM_TAG_TRANSPORT_LOG_IN	0x0010
#define TPM_TAG_TRANSPORT_LOG_OUT	0x0011
#define TPM_TAG_AUDIT_EVENT_IN		0x0012
#define TPM_TAG_AUDIT_EVENT_OUT		0x0013
#define TPM_TAG_CURRENT_TICKS		0x0014
#define TPM_TAG_KEY			0x0015
#define TPM_TAG_STORED_DATA12		0x0016
#define TPM_TAG_NV_ATTRIBUTES		0x0017
#define TPM_TAG_NV_DATA_PUBLIC		0x0018
#define TPM_TAG_NV_DATA_SENSITIVE	0x0019
#define TPM_TAG_DELEGATIONS		0x001A
#define TPM_TAG_DELEGATE_PUBLIC		0x001B
#define TPM_TAG_DELEGATE_TABLE_ROW	0x001C
#define TPM_TAG_TRANSPORT_AUTH		0x001D
#define TPM_TAG_TRANSPORT_PUBLIC	0x001E
#define TPM_TAG_PERMANENT_FLAGS		0x001F
#define TPM_TAG_STCLEAR_FLAGS		0x0020
#define TPM_TAG_STANY_FLAGS		0x0021
#define TPM_TAG_PERMANENT_DATA		0x0022
#define TPM_TAG_STCLEAR_DATA		0x0023
#define TPM_TAG_STANY_DATA		0x0024
#define TPM_TAG_FAMILY_TABLE_ENTRY	0x0025
#define TPM_TAG_DELEGATE_SENSITIVE	0x0026
#define TPM_TAG_DELG_KEY_BLOB		0x0027
#define TPM_TAG_KEY12			0x0028
#define TPM_TAG_CERTIFY_INFO2		0x0029
#define TPM_TAG_DELEGATE_OWNER_BLOB	0x002A
#define TPM_TAG_EK_BLOB_ACTIVATE	0x002B
#define TPM_TAG_DAA_BLOB		0x002C
#define TPM_TAG_DAA_CONTEXT		0x002D
#define TPM_TAG_DAA_ENFORCE		0x002E
#define TPM_TAG_DAA_ISSUER		0x002F
#define TPM_TAG_CAP_VERSION_INFO	0x0030
#define TPM_TAG_DAA_SENSITIVE		0x0031
#define TPM_TAG_DAA_TPM			0x0032
#define TPM_TAG_CMK_MIGAUTH		0x0033
#define TPM_TAG_CMK_SIGTICKET		0x0034
#define TPM_TAG_CMK_MA_APPROVAL		0x0035
#define TPM_TAG_QUOTE_INFO2		0x0036
#define TPM_TAG_DA_INFO			0x0037
#define TPM_TAG_DA_INFO_LIMITED		0x0038
#define TPM_TAG_DA_ACTION_TYPE		0x0039


/* 4.5. TPM_STARTUP_TYPE */
#define TPM_ST_CLEAR			0x0001
#define TPM_ST_STATE			0x0002
#define TPM_ST_DEACTIVATED		0x0003

/* 4.9 TPM_PHYSICAL_PRESENCE */
#define TPM_PHYSICAL_PRESENCE_HW_DISABLE	0x0200
#define TPM_PHYSICAL_PRESENCE_CMD_DISABLE	0x0100
#define TPM_PHYSICAL_PRESENCE_LIFETIME_LOCK	0x0080
#define TPM_PHYSICAL_PRESENCE_HW_ENABLE		0x0040
#define TPM_PHYSICAL_PRESENCE_CMD_ENABLE	0x0020
#define TPM_PHYSICAL_PRESENCE_NOTPRESENT	0x0010
#define TPM_PHYSICAL_PRESENCE_PRESENT		0x0008
#define TPM_PHYSICAL_PRESENCE_LOCK		0x0004

/* 6. TPM_TAG (Command and Response) */
#define TPM_TAG_RQU_COMMAND		0x00c1
#define TPM_TAG_RQU_AUTH1_COMMAND	0x00c2
#define TPM_TAG_RQU_AUTH2_COMMAND	0x00c3
#define TPM_TAG_RSP_COMMAND		0x00c4
#define TPM_TAG_RSP_AUTH1_COMMAND	0x00c5
#define TPM_TAG_RSP_AUTH2_COMMAND	0x00c6

/* 17. Ordinals */
#define TPM_ORD_ActivateIdentity		0x0000007A
#define TPM_ORD_AuthorizeMigrationKey		0x0000002B
#define TPM_ORD_CertifyKey			0x00000032
#define TPM_ORD_CertifyKey2			0x00000033
#define TPM_ORD_CertifySelfTest			0x00000052
#define TPM_ORD_ChangeAuth			0x0000000C
#define TPM_ORD_ChangeAuthAsymFinish		0x0000000F
#define TPM_ORD_ChangeAuthAsymStart		0x0000000E
#define TPM_ORD_ChangeAuthOwner			0x00000010
#define TPM_ORD_CMK_ApproveMA			0x0000001D
#define TPM_ORD_CMK_ConvertMigration		0x00000024
#define TPM_ORD_CMK_CreateBlob			0x0000001B
#define TPM_ORD_CMK_CreateKey			0x00000013
#define TPM_ORD_CMK_CreateTicket		0x00000012
#define TPM_ORD_CMK_SetRestrictions		0x0000001C
#define TPM_ORD_ContinueSelfTest		0x00000053
#define TPM_ORD_ConvertMigrationBlob		0x0000002A
#define TPM_ORD_CreateCounter			0x000000DC
#define TPM_ORD_CreateEndorsementKeyPair	0x00000078
#define TPM_ORD_CreateMaintenanceArchive	0x0000002C
#define TPM_ORD_CreateMigrationBlob		0x00000028
#define TPM_ORD_CreateRevocableEK		0x0000007F
#define TPM_ORD_CreateWrapKey			0x0000001F
#define TPM_ORD_DAA_Join			0x00000029
#define TPM_ORD_DAA_Sign			0x00000031
#define TPM_ORD_Delegate_CreateKeyDelegation	0x000000D4
#define TPM_ORD_Delegate_CreateOwnerDelegation	0x000000D5
#define TPM_ORD_Delegate_LoadOwnerDelegation	0x000000D8
#define TPM_ORD_Delegate_Manage			0x000000D2
#define TPM_ORD_Delegate_ReadTable		0x000000DB
#define TPM_ORD_Delegate_UpdateVerification	0x000000D1
#define TPM_ORD_Delegate_VerifyDelegation	0x000000D6
#define TPM_ORD_DirRead				0x0000001A
#define TPM_ORD_DirWriteAuth			0x00000019
#define TPM_ORD_DisableForceClear		0x0000005E
#define TPM_ORD_DisableOwnerClear		0x0000005C
#define TPM_ORD_DisablePubekRead		0x0000007E
#define TPM_ORD_DSAP				0x00000011
#define TPM_ORD_EstablishTransport		0x000000E6
#define TPM_ORD_EvictKey			0x00000022
#define TPM_ORD_ExecuteTransport		0x000000E7
#define TPM_ORD_Extend				0x00000014
#define TPM_ORD_FieldUpgrade			0x000000AA
#define TPM_ORD_FlushSpecific			0x000000BA
#define TPM_ORD_ForceClear			0x0000005D
#define TPM_ORD_GetAuditDigest			0x00000085
#define TPM_ORD_GetAuditDigestSigned		0x00000086
#define TPM_ORD_GetAuditEvent			0x00000082
#define TPM_ORD_GetAuditEventSigned		0x00000083
#define TPM_ORD_GetCapability			0x00000065
#define TPM_ORD_GetCapabilityOwner		0x00000066
#define TPM_ORD_GetCapabilitySigned		0x00000064
#define TPM_ORD_GetOrdinalAuditStatus		0x0000008C
#define TPM_ORD_GetPubKey			0x00000021
#define TPM_ORD_GetRandom			0x00000046
#define TPM_ORD_GetTestResult			0x00000054
#define TPM_ORD_GetTicks			0x000000F1
#define TPM_ORD_IncrementCounter		0x000000DD
#define TPM_ORD_Init				0x00000097
#define TPM_ORD_KeyControlOwner			0x00000023
#define TPM_ORD_KillMaintenanceFeature		0x0000002E
#define TPM_ORD_LoadAuthContext			0x000000B7
#define TPM_ORD_LoadContext			0x000000B9
#define TPM_ORD_LoadKey				0x00000020
#define TPM_ORD_LoadKey2			0x00000041
#define TPM_ORD_LoadKeyContext			0x000000B5
#define TPM_ORD_LoadMaintenanceArchive		0x0000002D
#define TPM_ORD_LoadManuMaintPub		0x0000002F
#define TPM_ORD_MakeIdentity			0x00000079
#define TPM_ORD_MigrateKey			0x00000025
#define TPM_ORD_NV_DefineSpace			0x000000CC
#define TPM_ORD_NV_ReadValue			0x000000CF
#define TPM_ORD_NV_ReadValueAuth		0x000000D0
#define TPM_ORD_NV_WriteValue			0x000000CD
#define TPM_ORD_NV_WriteValueAuth		0x000000CE
#define TPM_ORD_OIAP				0x0000000A
#define TPM_ORD_OSAP				0x0000000B
#define TPM_ORD_OwnerClear			0x0000005B
#define TPM_ORD_OwnerReadInternalPub		0x00000081
#define TPM_ORD_OwnerReadPubek			0x0000007D
#define TPM_ORD_OwnerSetDisable			0x0000006E
#define TPM_ORD_PCR_Reset			0x000000C8
#define TPM_ORD_PCRRead				0x00000015
#define TPM_ORD_PhysicalDisable			0x00000070
#define TPM_ORD_PhysicalEnable			0x0000006F
#define TPM_ORD_PhysicalSetDeactivated		0x00000072
#define TPM_ORD_Quote				0x00000016
#define TPM_ORD_Quote2				0x0000003E
#define TPM_ORD_ReadCounter			0x000000DE
#define TPM_ORD_ReadManuMaintPub		0x00000030
#define TPM_ORD_ReadPubek			0x0000007C
#define TPM_ORD_ReleaseCounter			0x000000DF
#define TPM_ORD_ReleaseCounterOwner		0x000000E0
#define TPM_ORD_ReleaseTransportSigned		0x000000E8
#define TPM_ORD_Reset				0x0000005A
#define TPM_ORD_ResetLockValue			0x00000040
#define TPM_ORD_RevokeTrust			0x00000080
#define TPM_ORD_SaveAuthContext			0x000000B6
#define TPM_ORD_SaveContext			0x000000B8
#define TPM_ORD_SaveKeyContext			0x000000B4
#define TPM_ORD_SaveState			0x00000098
#define TPM_ORD_Seal				0x00000017
#define TPM_ORD_Sealx				0x0000003D
#define TPM_ORD_SelfTestFull			0x00000050
#define TPM_ORD_SetCapability			0x0000003F
#define TPM_ORD_SetOperatorAuth			0x00000074
#define TPM_ORD_SetOrdinalAuditStatus		0x0000008D
#define TPM_ORD_SetOwnerInstall			0x00000071
#define TPM_ORD_SetOwnerPointer			0x00000075
#define TPM_ORD_SetRedirection			0x0000009A
#define TPM_ORD_SetTempDeactivated		0x00000073
#define TPM_ORD_SHA1Complete			0x000000A2
#define TPM_ORD_SHA1CompleteExtend		0x000000A3
#define TPM_ORD_SHA1Start			0x000000A0
#define TPM_ORD_SHA1Update			0x000000A1
#define TPM_ORD_Sign				0x0000003C
#define TPM_ORD_Startup				0x00000099
#define TPM_ORD_StirRandom			0x00000047
#define TPM_ORD_TakeOwnership			0x0000000D
#define TPM_ORD_Terminate_Handle		0x00000096
#define TPM_ORD_TickStampBlob			0x000000F2
#define TPM_ORD_UnBind				0x0000001E
#define TPM_ORD_Unseal				0x00000018
/* 17.1. TSC Ordinals */
#define TSC_ORD_PhysicalPresence		0x4000000A
#define TSC_ORD_ResetEstablishmentBit		0x4000000B

/* 19.1. TPM_NV_INDEX values */
#define TPM_NV_INDEX_LOCK			0xFFFFFFFF
#define TPM_NV_INDEX0				0x00000000
#define TPM_NV_INDEX_DIR			0x10000001

/* 19.2. TPM_NV_ATTRIBUTES */
#define TPM_NV_PER_READ_STCLEAR			(0x00000001 << 31)
#define TPM_NV_PER_AUTHREAD			(0x00000001 << 18)
#define TPM_NV_PER_OWNERREAD			(0x00000001 << 17)
#define TPM_NV_PER_PPREAD			(0x00000001 << 16)
#define TPM_NV_PER_GLOBALLOCK			(0x00000001 << 15)
#define TPM_NV_PER_WRITE_STCLEAR		(0x00000001 << 14)
#define TPM_NV_PER_WRITEDEFINE			(0x00000001 << 13)
#define TPM_NV_PER_WRITEALL			(0x00000001 << 12)
#define TPM_NV_PER_AUTHWRITE			(0x00000001 << 2)
#define TPM_NV_PER_OWNERWRITE			(0x00000001 << 1)
#define TPM_NV_PER_PPWRITE			(0x00000001 << 0)

#endif /*__TPM_H__*/
