#ifndef __TPM_API_H__
#define __TPM_API_H__

typedef	unsigned char	u8;
typedef	unsigned short	u16;
typedef	unsigned int	u32;

struct tpm_device;

typedef enum {
	TPM_DEVICE_ANY = -1,
	TPM_DEVICE_I2C,
	TPM_DEVICE_SPI,
} tpm_device_type_t;

/* TPM device probe APIs */
extern void tpm_device_init(void);
extern struct tpm_device *tpm_alloc_device(tpm_device_type_t type,
	int bus, int cs);
extern void tpm_free_device(struct tpm_device *tpm, int keep_pmu);

/* TPM1.2 APIs */
extern int tpm_init(struct tpm_device *tpm);
extern int tpm_startup(struct tpm_device *tpm, u16 startup);
extern int tpm_resume(struct tpm_device *tpm);
extern int tpm_self_test_full(struct tpm_device *tpm);
extern int tpm_continue_self_test(struct tpm_device *tpm);
#ifdef CONFIG_TPM_PHYSICAL_INIT
extern int tpm_physical_enable(struct tpm_device *tpm);
extern int tpm_physical_set_deactivated(struct tpm_device *tpm, u8 state);
extern int tpm_tsc_physical_presence(struct tpm_device *tpm, u16 flags);
#endif /* CONFIG_TPM_PHYSICAL_INIT */
extern int tpm_get_capability(struct tpm_device *tpm,
		u32 cap_area, u32 sub_cap, void *cap, int count);
#ifdef CONFIG_TPM_SHA1_HARDWARE
extern int tpm_sha1_start(struct tpm_device *tpm);
extern int tpm_sha1_update(struct tpm_device *tpm, const void *data, int count);
extern int tpm_sha1_complete(struct tpm_device *tpm,
		const void *data, int count, void *hash, int size);
extern int tpm_sha1_digest(struct tpm_device *tpm, const void *mesg, int count,
		void *hash, int size);
#endif /* CONFIG_TPM_SHA1_HARDWARE */
extern int tpm_extend(struct tpm_device *tpm, u32 index,
		const void *in_digest, void *out_digest);
extern int tpm_pcr_read(struct tpm_device *tpm,
		u32 index, void *data, int count);
#ifdef CONFIG_TPM_NV_HARDWARE
extern int tpm_nv_define_space(struct tpm_device *tpm,
		u32 index, u32 perm, u32 size);
extern int tpm_nv_write_value(struct tpm_device *tpm,
		u32 index, const void *data, u32 length);
extern int tpm_nv_read_value(struct tpm_device *tpm,
		u32 index, void *data, u32 count);
extern int tpm_nv_set_locked(struct tpm_device *tpm);
extern int tpm_nv_set_global_lock(struct tpm_device *tpm);
#endif /* CONFIG_TPM_NV_HARDWARE */

#endif /*__TPM_API_H__*/
