#ifndef __SPI_API_H__
#define __SPI_API_H__

struct spi_device;

extern void spi_init(void);
extern struct spi_device *spi_alloc_slave(int bus, int cs, int maxhz, int mode);
extern void spi_free_slave(struct spi_device *spi);
extern int spi_claim_bus(struct spi_device *spi);
extern void spi_release_bus(struct spi_device *spi);
extern void spi_cs_activate(struct spi_device *spi);
extern void spi_cs_deactivate(struct spi_device *spi);
#define SPI_XFER_BEGIN	(1UL << 0)
#define SPI_XFER_END	(1UL << 1)
extern int spi_xfer(struct spi_device *spi,
	const void *txbuf, void *rxbuf, int bytes, unsigned long flags);

#endif /*__SPI_API_H__*/
