/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

#ifndef __PMU_API_H__
#define __PMU_API_H__

#include "error_types.h"
#include "board_types.h"

typedef enum
{
	ePMU_DEVICE_CORE0,
	ePMU_DEVICE_CORE1,
	ePMU_DEVICE_CORE2,
	ePMU_DEVICE_CORE3,
	ePMU_DEVICE_MC5,
	ePMU_DEVICE_SMMU,
	ePMU_DEVICE_I2C,
	ePMU_DEVICE_UARTS,
	ePMU_DEVICE_SPI1,
	ePMU_DEVICE_SPI2,
	ePMU_DEVICE_SPI3,
} pmu_unit_t;

error_type_t PMU_enable( pmu_unit_t PMU_unit );

error_type_t PMU_disable( pmu_unit_t PMU_unit );

error_type_t setupPMUDividers( board_types_e board_type );

#endif // ifndef __PMU_API_H__
