/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2007-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/
 
#ifndef __MINPRINTF_H__
#define __MINPRINTF_H__

#include <stddef.h>


///////////////////////////////////////////////////////////////////////////
// minPrintf.c - the GNU c-lib versions of printf/sprintf are HUGE.  
//               we implement our own minimal versions here

void minPrintf(char* ctrl, ...);
void minSprintf(char* buf, char* ctrl, ...);

#ifdef DEBUG
#define dbg_printf(...) minPrintf(__VA_ARGS__)
#define DPRINTF(x,y)    do { if (x) minPrintf y ;} while(0)
#define ENTRY()         minPrintf("Entering %s\n", __func__)
#define LEAVE()         minPrintf("Leaving %s\n", __func__)
#else
#define dbg_printf(...)
#define DPRINTF(x,y)
#define ENTRY()
#define LEAVE()
#endif

#endif //ifndef __MINPRINTF_H__
