/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

#ifndef __I2C_API_H__
#define __I2C_API_H__

#include "regAddrs.h"

#define I2C_ONE_BYTE_MODE	(1)
#define I2C_TWO_BYTE_MODE	(2)

#define I2C_SLAVE_ADDR              0x7E

#define I2C_IBMR_REG                0x0000  //
#define I2C_IDBR_REG                0x0008  // Data Byte Register
#define I2C_ICR_REG                 0x0010  // Control Register
#define I2C_ISR_REG                 0x0018  // Status Register
#define I2C_ISAR_REG                0x0020  // Slave Address Register

#define I2C_NUM_BLOCKS              (6)

#define TWSI1_BASE_REGS                         AP_AP_APB_I2C1_BASE     // generic i2c bus 1.
#define TWSI2_BASE_REGS                         AP_AP_APB_I2C2_BASE     // generic i2c bus 2.
#define TWSI3_BASE_REGS                         AP_AP_APB_I2C3_BASE     // generic i2c bus 3.
#define TWSI4_BASE_REGS                         AP_AP_APB_I2C4_BASE     // generic i2c bus 4
#define TWSI5_BASE_REGS                         AP_AP_APB_I2C5_BASE     // another generic i2c bus 5
#define TWSI6_BASE_REGS                         0xd4034000      // yet another generic i2c bus. don't they know this is a bus?

#define I2C_BASE_REGS               { TWSI1_BASE_REGS, TWSI2_BASE_REGS, TWSI3_BASE_REGS, TWSI4_BASE_REGS, TWSI5_BASE_REGS, TWSI6_BASE_REGS }


error_type_t initialize_I2C(uint32_t bus);

error_type_t I2C_read( uint8_t chip_address, uint16_t part_address, uint16_t part_addr_len, uint16_t size, void* buffer );

error_type_t I2C_write( uint8_t chip_address, uint16_t part_address, uint8_t part_addr_len, uint16_t write_buf_size, void* write_buffer );

#endif // ifndef __I2C_API_H__
