/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

#ifndef __ERROR_TYPES_H__
#define __ERROR_TYPES_H__

#include <stdint.h>

/**
 * \file
 * \brief Define the error types variable
 * ERROR_TYPES is a global error return variable.  All modules that use this 
 * all handled through the event reporting module so this type is a prototype for
 * doing subsystem errors. All modules that use error_type 
 * shall extend this with their own errors using the following guidelines.
 * -# use the defined returns of OK and FAIL 
 * -# reserve 0 through -10 for the system
 * -# Error numbers are locally defined.  Should not span subsystems
 * -# ERRORS are all negative numbers of < -10
 * -# Positive numbers may be used however the module decides
 * -# Subsystems should consider a consistent error numbering scheme.
 * -# Subsystems should put a unique prefix on their errors for easy identification.
*/

typedef int32_t         error_type_t;   ///< Error type define
#define ERROR_TYPE_t    error_type_t
#define ERROR_TYPE      error_type_t    ///< support for old error_type

#define STATUS_OK       (0)     ///< Unique in the system.
#define FAIL            (-1)    ///< Unique in the system

#endif //#ifndef __ERROR_TYPES_H__
