 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _M2M_REGSTRUCTS_H_
#define _M2M_REGSTRUCTS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: m2m (m2m)
/** \brief (rev M2M_CFG_REV.M2M_MAJ_REV.M2M_MID_REV.M2M_MIN_REV).*/
//
//====================================================================

typedef struct M2M_REGS_s
{
  volatile uint32_t desc_start;  ///< 0x0 [W]: Link List Index Register
  volatile uint32_t current_desc_addr;  ///< 0x4 [R]: Current Link List Address Register
  volatile uint32_t status;  ///< 0x8 [R]: Status register
  volatile uint32_t IEN;  ///< 0xc [R/W]: Interrupt Enable
  volatile uint32_t IPEND;  ///< 0x10 [R]: Interrupt Pending
  volatile uint32_t IACK;  ///< 0x14 [W]: Interrupt Acknowledge
  volatile uint32_t IFOR;  ///< 0x18 [R/W]: Interrupt Force
  volatile uint32_t control;  ///< 0x1c [R]: Descriptor control register
  volatile uint32_t src_addr;  ///< 0x20 [R]: Descriptor Current Source Address
  volatile uint32_t dest_addr;  ///< 0x24 [R]: Descriptor Current Destination Address
  volatile uint32_t pcie_outbound;  ///< 0x28 [R]: Descriptor PCIe outbound Translate Value
  volatile uint32_t list_addr;  ///< 0x2c [R]: Descriptor Linked List Address
  volatile uint32_t chan0_dest_addr;  ///< 0x30 [R]: Channel 0 Destination Address
  volatile uint32_t chan1_dest_addr;  ///< 0x34 [R]: Channel 1 Destination Address
  volatile uint32_t chan2_dest_addr;  ///< 0x38 [R]: Channel 2 Destination Address
  volatile uint32_t chan3_dest_addr;  ///< 0x3c [R]: Channel 3 Destination Address
  volatile uint32_t chan4_dest_addr;  ///< 0x40 [R]: Channel 4 Destination Address
  volatile uint32_t chan5_dest_addr;  ///< 0x44 [R]: Channel 5 Destination Address
  volatile uint32_t chan6_dest_addr;  ///< 0x48 [R]: Channel 6 Destination Address
  volatile uint32_t chan7_dest_addr;  ///< 0x4c [R]: Channel 7 Destination Address
  volatile uint32_t debug;  ///< 0x50 [R]: Debug register
  volatile uint32_t pcie_xlate_reg_addr;  ///< 0x54 [R/W]: PCIe Translation Register Address
  volatile uint32_t REV0;  ///< 0x58 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x5c [R]: IP Tagging Revision 1
} M2M_REGS_t;

#endif // M2M
 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _M2M_REGMASKS_H_
#define _M2M_REGMASKS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: m2m (m2m)
/** \brief (rev M2M_CFG_REV.M2M_MAJ_REV.M2M_MID_REV.M2M_MIN_REV).*/
//
//====================================================================

//====================================================================
//Register: Link List Index Register (desc_start)
/** \brief Writing this register loads the first descriptor at Start Index.*/
//====================================================================

#define  M2M_DESC_START_INDEX_MASK 0xfffffffc
#define  M2M_DESC_START_INDEX_SHIFT 2
#define  M2M_DESC_START_INDEX_MASK_SHIFT(reg) (((reg) & M2M_DESC_START_INDEX_MASK) >> M2M_DESC_START_INDEX_SHIFT)
#define  M2M_DESC_START_INDEX_REPLACE_VAL(reg,val) (((reg) & ~M2M_DESC_START_INDEX_MASK) | (((uint32_t)val) << M2M_DESC_START_INDEX_SHIFT))

#define  M2M_DESC_START_SOFT_RESET_MASK 0x2
#define  M2M_DESC_START_SOFT_RESET_SHIFT 1
#define  M2M_DESC_START_SOFT_RESET_MASK_SHIFT(reg) (((reg) & M2M_DESC_START_SOFT_RESET_MASK) >> M2M_DESC_START_SOFT_RESET_SHIFT)
#define  M2M_DESC_START_SOFT_RESET_REPLACE_VAL(reg,val) (((reg) & ~M2M_DESC_START_SOFT_RESET_MASK) | (((uint32_t)val) << M2M_DESC_START_SOFT_RESET_SHIFT))

#define  M2M_DESC_START_ID_CTL_MASK 0x1
#define  M2M_DESC_START_ID_CTL_SHIFT 0
#define  M2M_DESC_START_ID_CTL_MASK_SHIFT(reg) (((reg) & M2M_DESC_START_ID_CTL_MASK) >> M2M_DESC_START_ID_CTL_SHIFT)
#define  M2M_DESC_START_ID_CTL_REPLACE_VAL(reg,val) (((reg) & ~M2M_DESC_START_ID_CTL_MASK) | (((uint32_t)val) << M2M_DESC_START_ID_CTL_SHIFT))

//====================================================================
//Register: Current Link List Address Register (current_desc_addr)
/** \brief The current link list address that the DMA block working on.*/
//====================================================================

#define  M2M_CURRENT_DESC_ADDR_PTR_MASK 0xfffffffc
#define  M2M_CURRENT_DESC_ADDR_PTR_SHIFT 2
#define  M2M_CURRENT_DESC_ADDR_PTR_MASK_SHIFT(reg) (((reg) & M2M_CURRENT_DESC_ADDR_PTR_MASK) >> M2M_CURRENT_DESC_ADDR_PTR_SHIFT)
#define  M2M_CURRENT_DESC_ADDR_PTR_REPLACE_VAL(reg,val) (((reg) & ~M2M_CURRENT_DESC_ADDR_PTR_MASK) | (((uint32_t)val) << M2M_CURRENT_DESC_ADDR_PTR_SHIFT))

#define  M2M_CURRENT_DESC_ADDR_SOFT_RESET_MASK 0x2
#define  M2M_CURRENT_DESC_ADDR_SOFT_RESET_SHIFT 1
#define  M2M_CURRENT_DESC_ADDR_SOFT_RESET_MASK_SHIFT(reg) (((reg) & M2M_CURRENT_DESC_ADDR_SOFT_RESET_MASK) >> M2M_CURRENT_DESC_ADDR_SOFT_RESET_SHIFT)
#define  M2M_CURRENT_DESC_ADDR_SOFT_RESET_REPLACE_VAL(reg,val) (((reg) & ~M2M_CURRENT_DESC_ADDR_SOFT_RESET_MASK) | (((uint32_t)val) << M2M_CURRENT_DESC_ADDR_SOFT_RESET_SHIFT))

#define  M2M_CURRENT_DESC_ADDR_ID_CTL_MASK 0x1
#define  M2M_CURRENT_DESC_ADDR_ID_CTL_SHIFT 0
#define  M2M_CURRENT_DESC_ADDR_ID_CTL_MASK_SHIFT(reg) (((reg) & M2M_CURRENT_DESC_ADDR_ID_CTL_MASK) >> M2M_CURRENT_DESC_ADDR_ID_CTL_SHIFT)
#define  M2M_CURRENT_DESC_ADDR_ID_CTL_REPLACE_VAL(reg,val) (((reg) & ~M2M_CURRENT_DESC_ADDR_ID_CTL_MASK) | (((uint32_t)val) << M2M_CURRENT_DESC_ADDR_ID_CTL_SHIFT))

//====================================================================
//Register: Status register (status)
/** \brief Status register for the m2m unit.*/
//====================================================================

#define  M2M_STATUS_RESERVED1_MASK 0xfff00000
#define  M2M_STATUS_RESERVED1_SHIFT 20
#define  M2M_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & M2M_STATUS_RESERVED1_MASK) >> M2M_STATUS_RESERVED1_SHIFT)
#define  M2M_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~M2M_STATUS_RESERVED1_MASK) | (((uint32_t)val) << M2M_STATUS_RESERVED1_SHIFT))

#define  M2M_STATUS_FIFO_ERROR_MASK 0x80000
#define  M2M_STATUS_FIFO_ERROR_SHIFT 19
#define  M2M_STATUS_FIFO_ERROR_MASK_SHIFT(reg) (((reg) & M2M_STATUS_FIFO_ERROR_MASK) >> M2M_STATUS_FIFO_ERROR_SHIFT)
#define  M2M_STATUS_FIFO_ERROR_REPLACE_VAL(reg,val) (((reg) & ~M2M_STATUS_FIFO_ERROR_MASK) | (((uint32_t)val) << M2M_STATUS_FIFO_ERROR_SHIFT))

#define  M2M_STATUS_FIFO_ENABLE_MASK 0x40000
#define  M2M_STATUS_FIFO_ENABLE_SHIFT 18
#define  M2M_STATUS_FIFO_ENABLE_MASK_SHIFT(reg) (((reg) & M2M_STATUS_FIFO_ENABLE_MASK) >> M2M_STATUS_FIFO_ENABLE_SHIFT)
#define  M2M_STATUS_FIFO_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~M2M_STATUS_FIFO_ENABLE_MASK) | (((uint32_t)val) << M2M_STATUS_FIFO_ENABLE_SHIFT))

#define  M2M_STATUS_FIFO_FULL_MASK 0x20000
#define  M2M_STATUS_FIFO_FULL_SHIFT 17
#define  M2M_STATUS_FIFO_FULL_MASK_SHIFT(reg) (((reg) & M2M_STATUS_FIFO_FULL_MASK) >> M2M_STATUS_FIFO_FULL_SHIFT)
#define  M2M_STATUS_FIFO_FULL_REPLACE_VAL(reg,val) (((reg) & ~M2M_STATUS_FIFO_FULL_MASK) | (((uint32_t)val) << M2M_STATUS_FIFO_FULL_SHIFT))

#define  M2M_STATUS_FIFO_EMPTY_MASK 0x10000
#define  M2M_STATUS_FIFO_EMPTY_SHIFT 16
#define  M2M_STATUS_FIFO_EMPTY_MASK_SHIFT(reg) (((reg) & M2M_STATUS_FIFO_EMPTY_MASK) >> M2M_STATUS_FIFO_EMPTY_SHIFT)
#define  M2M_STATUS_FIFO_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~M2M_STATUS_FIFO_EMPTY_MASK) | (((uint32_t)val) << M2M_STATUS_FIFO_EMPTY_SHIFT))

#define  M2M_STATUS_IDLE_MASK 0x8000
#define  M2M_STATUS_IDLE_SHIFT 15
#define  M2M_STATUS_IDLE_MASK_SHIFT(reg) (((reg) & M2M_STATUS_IDLE_MASK) >> M2M_STATUS_IDLE_SHIFT)
#define  M2M_STATUS_IDLE_REPLACE_VAL(reg,val) (((reg) & ~M2M_STATUS_IDLE_MASK) | (((uint32_t)val) << M2M_STATUS_IDLE_SHIFT))

#define  M2M_STATUS_RESERVED2_MASK 0x7800
#define  M2M_STATUS_RESERVED2_SHIFT 11
#define  M2M_STATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & M2M_STATUS_RESERVED2_MASK) >> M2M_STATUS_RESERVED2_SHIFT)
#define  M2M_STATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~M2M_STATUS_RESERVED2_MASK) | (((uint32_t)val) << M2M_STATUS_RESERVED2_SHIFT))

#define  M2M_STATUS_BUFFER_ID_MASK 0x700
#define  M2M_STATUS_BUFFER_ID_SHIFT 8
#define  M2M_STATUS_BUFFER_ID_MASK_SHIFT(reg) (((reg) & M2M_STATUS_BUFFER_ID_MASK) >> M2M_STATUS_BUFFER_ID_SHIFT)
#define  M2M_STATUS_BUFFER_ID_REPLACE_VAL(reg,val) (((reg) & ~M2M_STATUS_BUFFER_ID_MASK) | (((uint32_t)val) << M2M_STATUS_BUFFER_ID_SHIFT))

#define  M2M_STATUS_BUFFER_LENGTH_MASK 0xff
#define  M2M_STATUS_BUFFER_LENGTH_SHIFT 0
#define  M2M_STATUS_BUFFER_LENGTH_MASK_SHIFT(reg) (((reg) & M2M_STATUS_BUFFER_LENGTH_MASK) >> M2M_STATUS_BUFFER_LENGTH_SHIFT)
#define  M2M_STATUS_BUFFER_LENGTH_REPLACE_VAL(reg,val) (((reg) & ~M2M_STATUS_BUFFER_LENGTH_MASK) | (((uint32_t)val) << M2M_STATUS_BUFFER_LENGTH_SHIFT))

//====================================================================
//Register: Interrupt Enable (IEN)
/** \brief Enable for various interrupt sources.*/
//====================================================================

#define  M2M_IEN_RESERVED1_MASK 0xfffffff0
#define  M2M_IEN_RESERVED1_SHIFT 4
#define  M2M_IEN_RESERVED1_MASK_SHIFT(reg) (((reg) & M2M_IEN_RESERVED1_MASK) >> M2M_IEN_RESERVED1_SHIFT)
#define  M2M_IEN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~M2M_IEN_RESERVED1_MASK) | (((uint32_t)val) << M2M_IEN_RESERVED1_SHIFT))

#define  M2M_IEN_CPU_OWNER_MASK 0x8
#define  M2M_IEN_CPU_OWNER_SHIFT 3
#define  M2M_IEN_CPU_OWNER_MASK_SHIFT(reg) (((reg) & M2M_IEN_CPU_OWNER_MASK) >> M2M_IEN_CPU_OWNER_SHIFT)
#define  M2M_IEN_CPU_OWNER_REPLACE_VAL(reg,val) (((reg) & ~M2M_IEN_CPU_OWNER_MASK) | (((uint32_t)val) << M2M_IEN_CPU_OWNER_SHIFT))

#define  M2M_IEN_CHAIN_DONE_MASK 0x4
#define  M2M_IEN_CHAIN_DONE_SHIFT 2
#define  M2M_IEN_CHAIN_DONE_MASK_SHIFT(reg) (((reg) & M2M_IEN_CHAIN_DONE_MASK) >> M2M_IEN_CHAIN_DONE_SHIFT)
#define  M2M_IEN_CHAIN_DONE_REPLACE_VAL(reg,val) (((reg) & ~M2M_IEN_CHAIN_DONE_MASK) | (((uint32_t)val) << M2M_IEN_CHAIN_DONE_SHIFT))

#define  M2M_IEN_OUT_OF_ORDER_MASK 0x2
#define  M2M_IEN_OUT_OF_ORDER_SHIFT 1
#define  M2M_IEN_OUT_OF_ORDER_MASK_SHIFT(reg) (((reg) & M2M_IEN_OUT_OF_ORDER_MASK) >> M2M_IEN_OUT_OF_ORDER_SHIFT)
#define  M2M_IEN_OUT_OF_ORDER_REPLACE_VAL(reg,val) (((reg) & ~M2M_IEN_OUT_OF_ORDER_MASK) | (((uint32_t)val) << M2M_IEN_OUT_OF_ORDER_SHIFT))

#define  M2M_IEN_TERM_CNT_MASK 0x1
#define  M2M_IEN_TERM_CNT_SHIFT 0
#define  M2M_IEN_TERM_CNT_MASK_SHIFT(reg) (((reg) & M2M_IEN_TERM_CNT_MASK) >> M2M_IEN_TERM_CNT_SHIFT)
#define  M2M_IEN_TERM_CNT_REPLACE_VAL(reg,val) (((reg) & ~M2M_IEN_TERM_CNT_MASK) | (((uint32_t)val) << M2M_IEN_TERM_CNT_SHIFT))

//====================================================================
//Register: Interrupt Pending (IPEND)
/** \brief Read-Only interrupt pending register.*/
//====================================================================

#define  M2M_IPEND_RESERVED1_MASK 0xfffffff0
#define  M2M_IPEND_RESERVED1_SHIFT 4
#define  M2M_IPEND_RESERVED1_MASK_SHIFT(reg) (((reg) & M2M_IPEND_RESERVED1_MASK) >> M2M_IPEND_RESERVED1_SHIFT)
#define  M2M_IPEND_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~M2M_IPEND_RESERVED1_MASK) | (((uint32_t)val) << M2M_IPEND_RESERVED1_SHIFT))

#define  M2M_IPEND_CPU_OWNER_PEND_MASK 0x8
#define  M2M_IPEND_CPU_OWNER_PEND_SHIFT 3
#define  M2M_IPEND_CPU_OWNER_PEND_MASK_SHIFT(reg) (((reg) & M2M_IPEND_CPU_OWNER_PEND_MASK) >> M2M_IPEND_CPU_OWNER_PEND_SHIFT)
#define  M2M_IPEND_CPU_OWNER_PEND_REPLACE_VAL(reg,val) (((reg) & ~M2M_IPEND_CPU_OWNER_PEND_MASK) | (((uint32_t)val) << M2M_IPEND_CPU_OWNER_PEND_SHIFT))

#define  M2M_IPEND_CHAIN_DONE_PEND_MASK 0x4
#define  M2M_IPEND_CHAIN_DONE_PEND_SHIFT 2
#define  M2M_IPEND_CHAIN_DONE_PEND_MASK_SHIFT(reg) (((reg) & M2M_IPEND_CHAIN_DONE_PEND_MASK) >> M2M_IPEND_CHAIN_DONE_PEND_SHIFT)
#define  M2M_IPEND_CHAIN_DONE_PEND_REPLACE_VAL(reg,val) (((reg) & ~M2M_IPEND_CHAIN_DONE_PEND_MASK) | (((uint32_t)val) << M2M_IPEND_CHAIN_DONE_PEND_SHIFT))

#define  M2M_IPEND_OUT_OF_ORDER_PEND_MASK 0x2
#define  M2M_IPEND_OUT_OF_ORDER_PEND_SHIFT 1
#define  M2M_IPEND_OUT_OF_ORDER_PEND_MASK_SHIFT(reg) (((reg) & M2M_IPEND_OUT_OF_ORDER_PEND_MASK) >> M2M_IPEND_OUT_OF_ORDER_PEND_SHIFT)
#define  M2M_IPEND_OUT_OF_ORDER_PEND_REPLACE_VAL(reg,val) (((reg) & ~M2M_IPEND_OUT_OF_ORDER_PEND_MASK) | (((uint32_t)val) << M2M_IPEND_OUT_OF_ORDER_PEND_SHIFT))

#define  M2M_IPEND_TERM_CNT_PEND_MASK 0x1
#define  M2M_IPEND_TERM_CNT_PEND_SHIFT 0
#define  M2M_IPEND_TERM_CNT_PEND_MASK_SHIFT(reg) (((reg) & M2M_IPEND_TERM_CNT_PEND_MASK) >> M2M_IPEND_TERM_CNT_PEND_SHIFT)
#define  M2M_IPEND_TERM_CNT_PEND_REPLACE_VAL(reg,val) (((reg) & ~M2M_IPEND_TERM_CNT_PEND_MASK) | (((uint32_t)val) << M2M_IPEND_TERM_CNT_PEND_SHIFT))

//====================================================================
//Register: Interrupt Acknowledge (IACK)
/** \brief Write-Only interrupt acknowledge register.*/
//====================================================================

#define  M2M_IACK_RESERVED1_MASK 0xfffffff0
#define  M2M_IACK_RESERVED1_SHIFT 4
#define  M2M_IACK_RESERVED1_MASK_SHIFT(reg) (((reg) & M2M_IACK_RESERVED1_MASK) >> M2M_IACK_RESERVED1_SHIFT)
#define  M2M_IACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~M2M_IACK_RESERVED1_MASK) | (((uint32_t)val) << M2M_IACK_RESERVED1_SHIFT))

#define  M2M_IACK_CPU_OWNER_ACK_MASK 0x8
#define  M2M_IACK_CPU_OWNER_ACK_SHIFT 3
#define  M2M_IACK_CPU_OWNER_ACK_MASK_SHIFT(reg) (((reg) & M2M_IACK_CPU_OWNER_ACK_MASK) >> M2M_IACK_CPU_OWNER_ACK_SHIFT)
#define  M2M_IACK_CPU_OWNER_ACK_REPLACE_VAL(reg,val) (((reg) & ~M2M_IACK_CPU_OWNER_ACK_MASK) | (((uint32_t)val) << M2M_IACK_CPU_OWNER_ACK_SHIFT))

#define  M2M_IACK_CHAIN_DONE_ACK_MASK 0x4
#define  M2M_IACK_CHAIN_DONE_ACK_SHIFT 2
#define  M2M_IACK_CHAIN_DONE_ACK_MASK_SHIFT(reg) (((reg) & M2M_IACK_CHAIN_DONE_ACK_MASK) >> M2M_IACK_CHAIN_DONE_ACK_SHIFT)
#define  M2M_IACK_CHAIN_DONE_ACK_REPLACE_VAL(reg,val) (((reg) & ~M2M_IACK_CHAIN_DONE_ACK_MASK) | (((uint32_t)val) << M2M_IACK_CHAIN_DONE_ACK_SHIFT))

#define  M2M_IACK_OUT_OF_ORDER_ACK_MASK 0x2
#define  M2M_IACK_OUT_OF_ORDER_ACK_SHIFT 1
#define  M2M_IACK_OUT_OF_ORDER_ACK_MASK_SHIFT(reg) (((reg) & M2M_IACK_OUT_OF_ORDER_ACK_MASK) >> M2M_IACK_OUT_OF_ORDER_ACK_SHIFT)
#define  M2M_IACK_OUT_OF_ORDER_ACK_REPLACE_VAL(reg,val) (((reg) & ~M2M_IACK_OUT_OF_ORDER_ACK_MASK) | (((uint32_t)val) << M2M_IACK_OUT_OF_ORDER_ACK_SHIFT))

#define  M2M_IACK_TERM_CNT_ACK_MASK 0x1
#define  M2M_IACK_TERM_CNT_ACK_SHIFT 0
#define  M2M_IACK_TERM_CNT_ACK_MASK_SHIFT(reg) (((reg) & M2M_IACK_TERM_CNT_ACK_MASK) >> M2M_IACK_TERM_CNT_ACK_SHIFT)
#define  M2M_IACK_TERM_CNT_ACK_REPLACE_VAL(reg,val) (((reg) & ~M2M_IACK_TERM_CNT_ACK_MASK) | (((uint32_t)val) << M2M_IACK_TERM_CNT_ACK_SHIFT))

//====================================================================
//Register: Interrupt Force (IFOR)
/** \brief Forcing interrupt sources register. Write a one to each bit will force
               the corresponding interrupt source to be asserted.*/
//====================================================================

#define  M2M_IFOR_RESERVED1_MASK 0xfffffff0
#define  M2M_IFOR_RESERVED1_SHIFT 4
#define  M2M_IFOR_RESERVED1_MASK_SHIFT(reg) (((reg) & M2M_IFOR_RESERVED1_MASK) >> M2M_IFOR_RESERVED1_SHIFT)
#define  M2M_IFOR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~M2M_IFOR_RESERVED1_MASK) | (((uint32_t)val) << M2M_IFOR_RESERVED1_SHIFT))

#define  M2M_IFOR_CPU_OWNER_FORCE_MASK 0x8
#define  M2M_IFOR_CPU_OWNER_FORCE_SHIFT 3
#define  M2M_IFOR_CPU_OWNER_FORCE_MASK_SHIFT(reg) (((reg) & M2M_IFOR_CPU_OWNER_FORCE_MASK) >> M2M_IFOR_CPU_OWNER_FORCE_SHIFT)
#define  M2M_IFOR_CPU_OWNER_FORCE_REPLACE_VAL(reg,val) (((reg) & ~M2M_IFOR_CPU_OWNER_FORCE_MASK) | (((uint32_t)val) << M2M_IFOR_CPU_OWNER_FORCE_SHIFT))

#define  M2M_IFOR_CHAIN_DONE_FORCE_MASK 0x4
#define  M2M_IFOR_CHAIN_DONE_FORCE_SHIFT 2
#define  M2M_IFOR_CHAIN_DONE_FORCE_MASK_SHIFT(reg) (((reg) & M2M_IFOR_CHAIN_DONE_FORCE_MASK) >> M2M_IFOR_CHAIN_DONE_FORCE_SHIFT)
#define  M2M_IFOR_CHAIN_DONE_FORCE_REPLACE_VAL(reg,val) (((reg) & ~M2M_IFOR_CHAIN_DONE_FORCE_MASK) | (((uint32_t)val) << M2M_IFOR_CHAIN_DONE_FORCE_SHIFT))

#define  M2M_IFOR_OUT_OF_ORDER_FORCE_MASK 0x2
#define  M2M_IFOR_OUT_OF_ORDER_FORCE_SHIFT 1
#define  M2M_IFOR_OUT_OF_ORDER_FORCE_MASK_SHIFT(reg) (((reg) & M2M_IFOR_OUT_OF_ORDER_FORCE_MASK) >> M2M_IFOR_OUT_OF_ORDER_FORCE_SHIFT)
#define  M2M_IFOR_OUT_OF_ORDER_FORCE_REPLACE_VAL(reg,val) (((reg) & ~M2M_IFOR_OUT_OF_ORDER_FORCE_MASK) | (((uint32_t)val) << M2M_IFOR_OUT_OF_ORDER_FORCE_SHIFT))

#define  M2M_IFOR_TERM_CNT_FORCE_MASK 0x1
#define  M2M_IFOR_TERM_CNT_FORCE_SHIFT 0
#define  M2M_IFOR_TERM_CNT_FORCE_MASK_SHIFT(reg) (((reg) & M2M_IFOR_TERM_CNT_FORCE_MASK) >> M2M_IFOR_TERM_CNT_FORCE_SHIFT)
#define  M2M_IFOR_TERM_CNT_FORCE_REPLACE_VAL(reg,val) (((reg) & ~M2M_IFOR_TERM_CNT_FORCE_MASK) | (((uint32_t)val) << M2M_IFOR_TERM_CNT_FORCE_SHIFT))

//====================================================================
//Register: Descriptor control register (control)
/** \brief Read the active Descriptor Control Register.*/
//====================================================================

#define  M2M_CONTROL_OWN_MASK 0x80000000
#define  M2M_CONTROL_OWN_SHIFT 31
#define  M2M_CONTROL_OWN_MASK_SHIFT(reg) (((reg) & M2M_CONTROL_OWN_MASK) >> M2M_CONTROL_OWN_SHIFT)
#define  M2M_CONTROL_OWN_REPLACE_VAL(reg,val) (((reg) & ~M2M_CONTROL_OWN_MASK) | (((uint32_t)val) << M2M_CONTROL_OWN_SHIFT))

#define  M2M_CONTROL_UPDATE_XLATE_MASK 0x40000000
#define  M2M_CONTROL_UPDATE_XLATE_SHIFT 30
#define  M2M_CONTROL_UPDATE_XLATE_MASK_SHIFT(reg) (((reg) & M2M_CONTROL_UPDATE_XLATE_MASK) >> M2M_CONTROL_UPDATE_XLATE_SHIFT)
#define  M2M_CONTROL_UPDATE_XLATE_REPLACE_VAL(reg,val) (((reg) & ~M2M_CONTROL_UPDATE_XLATE_MASK) | (((uint32_t)val) << M2M_CONTROL_UPDATE_XLATE_SHIFT))

#define  M2M_CONTROL_RESERVED1_MASK 0x3fff0000
#define  M2M_CONTROL_RESERVED1_SHIFT 16
#define  M2M_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & M2M_CONTROL_RESERVED1_MASK) >> M2M_CONTROL_RESERVED1_SHIFT)
#define  M2M_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~M2M_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << M2M_CONTROL_RESERVED1_SHIFT))

#define  M2M_CONTROL_SIZE_MASK 0xffff
#define  M2M_CONTROL_SIZE_SHIFT 0
#define  M2M_CONTROL_SIZE_MASK_SHIFT(reg) (((reg) & M2M_CONTROL_SIZE_MASK) >> M2M_CONTROL_SIZE_SHIFT)
#define  M2M_CONTROL_SIZE_REPLACE_VAL(reg,val) (((reg) & ~M2M_CONTROL_SIZE_MASK) | (((uint32_t)val) << M2M_CONTROL_SIZE_SHIFT))

//====================================================================
//Register: Descriptor Current Source Address (src_addr)
/** \brief Read the active Descriptor Source Address pointer.*/
//====================================================================

#define  M2M_SRC_ADDR_PTR_MASK 0xffffffff
#define  M2M_SRC_ADDR_PTR_SHIFT 0
#define  M2M_SRC_ADDR_PTR_MASK_SHIFT(reg) (((reg) & M2M_SRC_ADDR_PTR_MASK) >> M2M_SRC_ADDR_PTR_SHIFT)
#define  M2M_SRC_ADDR_PTR_REPLACE_VAL(reg,val) (((reg) & ~M2M_SRC_ADDR_PTR_MASK) | (((uint32_t)val) << M2M_SRC_ADDR_PTR_SHIFT))

//====================================================================
//Register: Descriptor Current Destination Address (dest_addr)
/** \brief Read the active Descriptor Destination Address pointer.*/
//====================================================================

#define  M2M_DEST_ADDR_PTR_MASK 0xffffffff
#define  M2M_DEST_ADDR_PTR_SHIFT 0
#define  M2M_DEST_ADDR_PTR_MASK_SHIFT(reg) (((reg) & M2M_DEST_ADDR_PTR_MASK) >> M2M_DEST_ADDR_PTR_SHIFT)
#define  M2M_DEST_ADDR_PTR_REPLACE_VAL(reg,val) (((reg) & ~M2M_DEST_ADDR_PTR_MASK) | (((uint32_t)val) << M2M_DEST_ADDR_PTR_SHIFT))

//====================================================================
//Register: Descriptor PCIe outbound Translate Value (pcie_outbound)
/** \brief Read the active PCIe outbound translate register value.*/
//====================================================================

#define  M2M_PCIE_OUTBOUND_XLATE_VALUE_MASK 0xffffffff
#define  M2M_PCIE_OUTBOUND_XLATE_VALUE_SHIFT 0
#define  M2M_PCIE_OUTBOUND_XLATE_VALUE_MASK_SHIFT(reg) (((reg) & M2M_PCIE_OUTBOUND_XLATE_VALUE_MASK) >> M2M_PCIE_OUTBOUND_XLATE_VALUE_SHIFT)
#define  M2M_PCIE_OUTBOUND_XLATE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~M2M_PCIE_OUTBOUND_XLATE_VALUE_MASK) | (((uint32_t)val) << M2M_PCIE_OUTBOUND_XLATE_VALUE_SHIFT))

//====================================================================
//Register: Descriptor Linked List Address (list_addr)
/** \brief Read the active Descriptor Linked List pointer (to the next descriptor).*/
//====================================================================

#define  M2M_LIST_ADDR_PTR_MASK 0xffffffff
#define  M2M_LIST_ADDR_PTR_SHIFT 0
#define  M2M_LIST_ADDR_PTR_MASK_SHIFT(reg) (((reg) & M2M_LIST_ADDR_PTR_MASK) >> M2M_LIST_ADDR_PTR_SHIFT)
#define  M2M_LIST_ADDR_PTR_REPLACE_VAL(reg,val) (((reg) & ~M2M_LIST_ADDR_PTR_MASK) | (((uint32_t)val) << M2M_LIST_ADDR_PTR_SHIFT))

//====================================================================
//Register: Channel 0 Destination Address (chan0_dest_addr)
/** \brief Read the active Channel Destination Address pointer.*/
//====================================================================

#define  M2M_CHAN0_DEST_ADDR_PTR_MASK 0xffffffff
#define  M2M_CHAN0_DEST_ADDR_PTR_SHIFT 0
#define  M2M_CHAN0_DEST_ADDR_PTR_MASK_SHIFT(reg) (((reg) & M2M_CHAN0_DEST_ADDR_PTR_MASK) >> M2M_CHAN0_DEST_ADDR_PTR_SHIFT)
#define  M2M_CHAN0_DEST_ADDR_PTR_REPLACE_VAL(reg,val) (((reg) & ~M2M_CHAN0_DEST_ADDR_PTR_MASK) | (((uint32_t)val) << M2M_CHAN0_DEST_ADDR_PTR_SHIFT))

//====================================================================
//Register: Channel 1 Destination Address (chan1_dest_addr)
/** \brief Read the active Channel Destination Address pointer.*/
//====================================================================

#define  M2M_CHAN1_DEST_ADDR_PTR_MASK 0xffffffff
#define  M2M_CHAN1_DEST_ADDR_PTR_SHIFT 0
#define  M2M_CHAN1_DEST_ADDR_PTR_MASK_SHIFT(reg) (((reg) & M2M_CHAN1_DEST_ADDR_PTR_MASK) >> M2M_CHAN1_DEST_ADDR_PTR_SHIFT)
#define  M2M_CHAN1_DEST_ADDR_PTR_REPLACE_VAL(reg,val) (((reg) & ~M2M_CHAN1_DEST_ADDR_PTR_MASK) | (((uint32_t)val) << M2M_CHAN1_DEST_ADDR_PTR_SHIFT))

//====================================================================
//Register: Channel 2 Destination Address (chan2_dest_addr)
/** \brief Read the active Channel Destination Address pointer.*/
//====================================================================

#define  M2M_CHAN2_DEST_ADDR_PTR_MASK 0xffffffff
#define  M2M_CHAN2_DEST_ADDR_PTR_SHIFT 0
#define  M2M_CHAN2_DEST_ADDR_PTR_MASK_SHIFT(reg) (((reg) & M2M_CHAN2_DEST_ADDR_PTR_MASK) >> M2M_CHAN2_DEST_ADDR_PTR_SHIFT)
#define  M2M_CHAN2_DEST_ADDR_PTR_REPLACE_VAL(reg,val) (((reg) & ~M2M_CHAN2_DEST_ADDR_PTR_MASK) | (((uint32_t)val) << M2M_CHAN2_DEST_ADDR_PTR_SHIFT))

//====================================================================
//Register: Channel 3 Destination Address (chan3_dest_addr)
/** \brief Read the active Channel Destination Address pointer.*/
//====================================================================

#define  M2M_CHAN3_DEST_ADDR_PTR_MASK 0xffffffff
#define  M2M_CHAN3_DEST_ADDR_PTR_SHIFT 0
#define  M2M_CHAN3_DEST_ADDR_PTR_MASK_SHIFT(reg) (((reg) & M2M_CHAN3_DEST_ADDR_PTR_MASK) >> M2M_CHAN3_DEST_ADDR_PTR_SHIFT)
#define  M2M_CHAN3_DEST_ADDR_PTR_REPLACE_VAL(reg,val) (((reg) & ~M2M_CHAN3_DEST_ADDR_PTR_MASK) | (((uint32_t)val) << M2M_CHAN3_DEST_ADDR_PTR_SHIFT))

//====================================================================
//Register: Channel 4 Destination Address (chan4_dest_addr)
/** \brief Read the active Channel Destination Address pointer.*/
//====================================================================

#define  M2M_CHAN4_DEST_ADDR_PTR_MASK 0xffffffff
#define  M2M_CHAN4_DEST_ADDR_PTR_SHIFT 0
#define  M2M_CHAN4_DEST_ADDR_PTR_MASK_SHIFT(reg) (((reg) & M2M_CHAN4_DEST_ADDR_PTR_MASK) >> M2M_CHAN4_DEST_ADDR_PTR_SHIFT)
#define  M2M_CHAN4_DEST_ADDR_PTR_REPLACE_VAL(reg,val) (((reg) & ~M2M_CHAN4_DEST_ADDR_PTR_MASK) | (((uint32_t)val) << M2M_CHAN4_DEST_ADDR_PTR_SHIFT))

//====================================================================
//Register: Channel 5 Destination Address (chan5_dest_addr)
/** \brief Read the active Channel Destination Address pointer.*/
//====================================================================

#define  M2M_CHAN5_DEST_ADDR_PTR_MASK 0xffffffff
#define  M2M_CHAN5_DEST_ADDR_PTR_SHIFT 0
#define  M2M_CHAN5_DEST_ADDR_PTR_MASK_SHIFT(reg) (((reg) & M2M_CHAN5_DEST_ADDR_PTR_MASK) >> M2M_CHAN5_DEST_ADDR_PTR_SHIFT)
#define  M2M_CHAN5_DEST_ADDR_PTR_REPLACE_VAL(reg,val) (((reg) & ~M2M_CHAN5_DEST_ADDR_PTR_MASK) | (((uint32_t)val) << M2M_CHAN5_DEST_ADDR_PTR_SHIFT))

//====================================================================
//Register: Channel 6 Destination Address (chan6_dest_addr)
/** \brief Read the active Channel Destination Address pointer.*/
//====================================================================

#define  M2M_CHAN6_DEST_ADDR_PTR_MASK 0xffffffff
#define  M2M_CHAN6_DEST_ADDR_PTR_SHIFT 0
#define  M2M_CHAN6_DEST_ADDR_PTR_MASK_SHIFT(reg) (((reg) & M2M_CHAN6_DEST_ADDR_PTR_MASK) >> M2M_CHAN6_DEST_ADDR_PTR_SHIFT)
#define  M2M_CHAN6_DEST_ADDR_PTR_REPLACE_VAL(reg,val) (((reg) & ~M2M_CHAN6_DEST_ADDR_PTR_MASK) | (((uint32_t)val) << M2M_CHAN6_DEST_ADDR_PTR_SHIFT))

//====================================================================
//Register: Channel 7 Destination Address (chan7_dest_addr)
/** \brief Read the active Channel Destination Address pointer.*/
//====================================================================

#define  M2M_CHAN7_DEST_ADDR_PTR_MASK 0xffffffff
#define  M2M_CHAN7_DEST_ADDR_PTR_SHIFT 0
#define  M2M_CHAN7_DEST_ADDR_PTR_MASK_SHIFT(reg) (((reg) & M2M_CHAN7_DEST_ADDR_PTR_MASK) >> M2M_CHAN7_DEST_ADDR_PTR_SHIFT)
#define  M2M_CHAN7_DEST_ADDR_PTR_REPLACE_VAL(reg,val) (((reg) & ~M2M_CHAN7_DEST_ADDR_PTR_MASK) | (((uint32_t)val) << M2M_CHAN7_DEST_ADDR_PTR_SHIFT))

//====================================================================
//Register: Debug register (debug)
/** \brief Debug register for the m2m unit.*/
//====================================================================

#define  M2M_DEBUG_RESERVED1_MASK 0xff000000
#define  M2M_DEBUG_RESERVED1_SHIFT 24
#define  M2M_DEBUG_RESERVED1_MASK_SHIFT(reg) (((reg) & M2M_DEBUG_RESERVED1_MASK) >> M2M_DEBUG_RESERVED1_SHIFT)
#define  M2M_DEBUG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~M2M_DEBUG_RESERVED1_MASK) | (((uint32_t)val) << M2M_DEBUG_RESERVED1_SHIFT))

#define  M2M_DEBUG_CHAN_BUSY_MASK 0xff0000
#define  M2M_DEBUG_CHAN_BUSY_SHIFT 16
#define  M2M_DEBUG_CHAN_BUSY_MASK_SHIFT(reg) (((reg) & M2M_DEBUG_CHAN_BUSY_MASK) >> M2M_DEBUG_CHAN_BUSY_SHIFT)
#define  M2M_DEBUG_CHAN_BUSY_REPLACE_VAL(reg,val) (((reg) & ~M2M_DEBUG_CHAN_BUSY_MASK) | (((uint32_t)val) << M2M_DEBUG_CHAN_BUSY_SHIFT))

#define  M2M_DEBUG_CHAN_STATE_MASK 0xffff
#define  M2M_DEBUG_CHAN_STATE_SHIFT 0
#define  M2M_DEBUG_CHAN_STATE_MASK_SHIFT(reg) (((reg) & M2M_DEBUG_CHAN_STATE_MASK) >> M2M_DEBUG_CHAN_STATE_SHIFT)
#define  M2M_DEBUG_CHAN_STATE_REPLACE_VAL(reg,val) (((reg) & ~M2M_DEBUG_CHAN_STATE_MASK) | (((uint32_t)val) << M2M_DEBUG_CHAN_STATE_SHIFT))

//====================================================================
//Register: PCIe Translation Register Address (pcie_xlate_reg_addr)
/** \brief Pointer to the PCIe controllers address translation register.*/
//====================================================================

#define  M2M_PCIE_XLATE_REG_ADDR_PTR_MASK 0xffffffff
#define  M2M_PCIE_XLATE_REG_ADDR_PTR_SHIFT 0
#define  M2M_PCIE_XLATE_REG_ADDR_PTR_MASK_SHIFT(reg) (((reg) & M2M_PCIE_XLATE_REG_ADDR_PTR_MASK) >> M2M_PCIE_XLATE_REG_ADDR_PTR_SHIFT)
#define  M2M_PCIE_XLATE_REG_ADDR_PTR_REPLACE_VAL(reg,val) (((reg) & ~M2M_PCIE_XLATE_REG_ADDR_PTR_MASK) | (((uint32_t)val) << M2M_PCIE_XLATE_REG_ADDR_PTR_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  M2M_REV0_MAJ_MASK 0xffff0000
#define  M2M_REV0_MAJ_SHIFT 16
#define  M2M_REV0_MAJ_MASK_SHIFT(reg) (((reg) & M2M_REV0_MAJ_MASK) >> M2M_REV0_MAJ_SHIFT)
#define  M2M_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~M2M_REV0_MAJ_MASK) | (((uint32_t)val) << M2M_REV0_MAJ_SHIFT))

#define  M2M_REV0_MID_MASK 0xffff
#define  M2M_REV0_MID_SHIFT 0
#define  M2M_REV0_MID_MASK_SHIFT(reg) (((reg) & M2M_REV0_MID_MASK) >> M2M_REV0_MID_SHIFT)
#define  M2M_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~M2M_REV0_MID_MASK) | (((uint32_t)val) << M2M_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  M2M_REV1_RESERVED1_MASK 0xffff0000
#define  M2M_REV1_RESERVED1_SHIFT 16
#define  M2M_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & M2M_REV1_RESERVED1_MASK) >> M2M_REV1_RESERVED1_SHIFT)
#define  M2M_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~M2M_REV1_RESERVED1_MASK) | (((uint32_t)val) << M2M_REV1_RESERVED1_SHIFT))

#define  M2M_REV1_CFG_MASK 0xffff
#define  M2M_REV1_CFG_SHIFT 0
#define  M2M_REV1_CFG_MASK_SHIFT(reg) (((reg) & M2M_REV1_CFG_MASK) >> M2M_REV1_CFG_SHIFT)
#define  M2M_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~M2M_REV1_CFG_MASK) | (((uint32_t)val) << M2M_REV1_CFG_SHIFT))

#endif // M2M
