 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _CIU_REGSTRUCTS_H_
#define _CIU_REGSTRUCTS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: CIU (CIU)
//
//====================================================================

typedef struct CIU_REGS_s
{
  volatile uint32_t CHIP_ID;  ///< 0x0 [R]: Chip ID Register
  volatile uint32_t REG_04;  ///< 0x4 [R/W]: REG_04
  volatile uint32_t A53_CORE_0_CFG_CTL;  ///< 0x8 [R/W]: Cortex A53 Core 0 Configuration Control Register
  volatile uint32_t REG_0C;  ///< 0xc [R]: REG_0C (spare)
  volatile uint32_t REG_10;  ///< 0x10 [R]: REG_10 (spare)
  volatile uint32_t REG_14;  ///< 0x14 [R]: REG_14 (spare)
  volatile uint32_t REG_18;  ///< 0x18 [R]: REG_18 (spare)
  volatile uint32_t REG_1C;  ///< 0x1c [R]: REG_1C (spare)
  volatile uint32_t SYS_BOOT_CNTRL;  ///< 0x20 [R]: System Boot Control Register
  volatile uint32_t SW_BRANCH_ADDR;  ///< 0x24 [R/W]: Software Branch Address Register
  volatile uint32_t REG_28;  ///< 0x28 [R]: REG_28 (spare)
  volatile uint32_t REG_2C;  ///< 0x2c [R]: REG_2C (spare)
  volatile uint32_t RVBARADDR0L;  ///< 0x30 [R/W]: RVBARADDR0 Lower Address
  volatile uint32_t RVBARADDR0H;  ///< 0x34 [R/W]: RVBARADDR0 Upper Address
  volatile uint32_t RVBARADDR1L;  ///< 0x38 [R/W]: RVBARADDR1 Lower Address
  volatile uint32_t RVBARADDR1H;  ///< 0x3c [R/W]: RVBARADDR1 Upper Address
  volatile uint32_t REG_40;  ///< 0x40 [R]: REG_40 (spare)
  volatile uint32_t REG_44;  ///< 0x44 [R]: REG_44 (spare)
  volatile uint32_t MC_CONF;  ///< 0x48 [R/W]: Memory Controller Configuration Register
  volatile uint32_t CORESIGHT_CONFIG;  ///< 0x4c [R/W]: Core Sight Core Configuration Register
  volatile uint32_t REG_50;  ///< 0x50 [R]: REG_50 (spare)
  volatile uint32_t REG_54;  ///< 0x54 [R]: REG_54 (spare)
  volatile uint32_t REG_58;  ///< 0x58 [R]: REG_58 (spare)
  volatile uint32_t MC_LOOPBACK_CNTRL;  ///< 0x5c [R/W]: MC Loopback Control Register
  volatile uint32_t RVBARADDR2L;  ///< 0x60 [R/W]: RVBARADDR2 Lower Address
  volatile uint32_t RVBARADDR2H;  ///< 0x64 [R/W]: RVBARADDR2 Upper Address
  volatile uint32_t RVBARADDR3L;  ///< 0x68 [R/W]: RVBARADDR3 Lower Address
  volatile uint32_t RVBARADDR3H;  ///< 0x6c [R/W]: RVBARADDR3 Upper Address
  volatile uint32_t REG_70;  ///< 0x70 [R]: REG_70 (spare)
  volatile uint32_t REG_74;  ///< 0x74 [R]: REG_74 (spare)
  volatile uint32_t CIU_CA53_RWTC_CFG_CTL1;  ///< 0x78 [R/W]: Cortex A53 Compiled Memory RTC WTC Configuration Register
  volatile uint32_t CIU_CA53_RWTC_CFG_CTL2;  ///< 0x7c [R/W]: Cortex A53 Compiled Memory RTC WTC Configuration 2 Register
  volatile uint32_t R4_Vector_Remap;  ///< 0x80 [R/W]: R4_Vector_Remap
  volatile uint32_t CIU_CPU_DBG_CNTRL;  ///< 0x84 [R/W]: Cortex CPU Debug Control Register
  volatile uint32_t A53_CORE_1_CFG_CTL;  ///< 0x88 [R/W]: Cortex A53 Core 1 Configuration Control Register
  volatile uint32_t REG_8C;  ///< 0x8c [R]: REG_8C (spare)
  volatile uint32_t REG_90;  ///< 0x90 [R]: REG_90 (spare)
  volatile uint32_t REG_94;  ///< 0x94 [R]: REG_94 (spare)
  volatile uint32_t REG_98;  ///< 0x98 [R]: REG_98 (spare)
  volatile uint32_t REG_9C;  ///< 0x9c [R]: REG_9C (spare)
  volatile uint32_t DDR_CONTROL;  ///< 0xa0 [R/W]: DDR Control
  volatile uint32_t REG_A4;  ///< 0xa4 [R]: REG_A4 (spare)
  volatile uint32_t REG_A8;  ///< 0xa8 [R]: REG_A8 (spare)
  volatile uint32_t REG_AC;  ///< 0xac [R]: REG_AC (spare)
  volatile uint32_t MC_PRIORITY;  ///< 0xb0 [R/W]: MC Port 0 Priority Threshold Register
  volatile uint32_t MC_PRIORITY2;  ///< 0xb4 [R/W]: MC Port 1-3 Priority Threshold Register
  volatile uint32_t MC_PRIORITY3;  ///< 0xb8 [R]: MC Priority 3 Register
  volatile uint32_t CIU_MFPR_EN;  ///< 0xbc [R/W]: MFPR Enable Register
  volatile uint32_t REG_C0;  ///< 0xc0 [R]: REG_C0 (spare)
  volatile uint32_t BOOT_CTRL;  ///< 0xc4 [R/W]: Boot Control register
  volatile uint32_t CIU_MISC_CFG_CTL;  ///< 0xc8 [R/W]: CIU Miscellaneous Configuration Control register.
  volatile uint32_t CIU_STATUS_REGISTER;  ///< 0xcc [R]: CIU STATUS REGISTER
  volatile uint32_t REG_D0;  ///< 0xd0 [R]: REG_D0 (spare)
  volatile uint32_t REG_D4;  ///< 0xd4 [R]: REG_D4 (spare)
  volatile uint32_t REG_D8;  ///< 0xd8 [R]: REG_D8 (spare)
  volatile uint32_t REG_DC;  ///< 0xdc [R]: REG_DC (spare)
  volatile uint32_t REG_E0;  ///< 0xe0 [R]: REG_E0 (spare)
  volatile uint32_t A53_CORE_2_CFG_CTL;  ///< 0xe4 [R/W]: Cortex A53 Core 2 Configuration Control Register
  volatile uint32_t A53_CORE_3_CFG_CTL;  ///< 0xe8 [R/W]: Cortex A53 Core 3 Configuration Control Register
} CIU_REGS_t;

#endif // CIU
 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _CIU_REGMASKS_H_
#define _CIU_REGMASKS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: CIU (CIU)
//
//====================================================================

//====================================================================
//Register: Chip ID Register (CHIP_ID)
//====================================================================

#define  CIU_CHIP_ID_RESERVED1_MASK 0xff000000
#define  CIU_CHIP_ID_RESERVED1_SHIFT 24
#define  CIU_CHIP_ID_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_CHIP_ID_RESERVED1_MASK) >> CIU_CHIP_ID_RESERVED1_SHIFT)
#define  CIU_CHIP_ID_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_CHIP_ID_RESERVED1_MASK) | (((uint32_t)val) << CIU_CHIP_ID_RESERVED1_SHIFT))

#define  CIU_CHIP_ID_REV_ID_MASK 0xff0000
#define  CIU_CHIP_ID_REV_ID_SHIFT 16
#define  CIU_CHIP_ID_REV_ID_MASK_SHIFT(reg) (((reg) & CIU_CHIP_ID_REV_ID_MASK) >> CIU_CHIP_ID_REV_ID_SHIFT)
#define  CIU_CHIP_ID_REV_ID_REPLACE_VAL(reg,val) (((reg) & ~CIU_CHIP_ID_REV_ID_MASK) | (((uint32_t)val) << CIU_CHIP_ID_REV_ID_SHIFT))

#define  CIU_CHIP_ID_CHIP_ID_MASK 0xffff
#define  CIU_CHIP_ID_CHIP_ID_SHIFT 0
#define  CIU_CHIP_ID_CHIP_ID_MASK_SHIFT(reg) (((reg) & CIU_CHIP_ID_CHIP_ID_MASK) >> CIU_CHIP_ID_CHIP_ID_SHIFT)
#define  CIU_CHIP_ID_CHIP_ID_REPLACE_VAL(reg,val) (((reg) & ~CIU_CHIP_ID_CHIP_ID_MASK) | (((uint32_t)val) << CIU_CHIP_ID_CHIP_ID_SHIFT))

//====================================================================
//Register: REG_04 (REG_04)
//====================================================================

#define  CIU_REG_04_RESERVED1_MASK 0xfffffffe
#define  CIU_REG_04_RESERVED1_SHIFT 1
#define  CIU_REG_04_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_04_RESERVED1_MASK) >> CIU_REG_04_RESERVED1_SHIFT)
#define  CIU_REG_04_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_04_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_04_RESERVED1_SHIFT))

#define  CIU_REG_04_RKEK_SW_READ_MMP2_MASK 0x1
#define  CIU_REG_04_RKEK_SW_READ_MMP2_SHIFT 0
#define  CIU_REG_04_RKEK_SW_READ_MMP2_MASK_SHIFT(reg) (((reg) & CIU_REG_04_RKEK_SW_READ_MMP2_MASK) >> CIU_REG_04_RKEK_SW_READ_MMP2_SHIFT)
#define  CIU_REG_04_RKEK_SW_READ_MMP2_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_04_RKEK_SW_READ_MMP2_MASK) | (((uint32_t)val) << CIU_REG_04_RKEK_SW_READ_MMP2_SHIFT))

//====================================================================
//Register: Cortex A53 Core 0 Configuration Control Register (A53_CORE_0_CFG_CTL)
/** \brief This register can be configured by WTM to be secure for read and write
access.
This is a read/write register. Ignore reads from reserved bits. Write 0b0
to reserved bits.*/
//====================================================================

#define  CIU_A53_CORE_0_CFG_CTL_RESERVED1_MASK 0xf0000000
#define  CIU_A53_CORE_0_CFG_CTL_RESERVED1_SHIFT 28
#define  CIU_A53_CORE_0_CFG_CTL_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_0_CFG_CTL_RESERVED1_MASK) >> CIU_A53_CORE_0_CFG_CTL_RESERVED1_SHIFT)
#define  CIU_A53_CORE_0_CFG_CTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_0_CFG_CTL_RESERVED1_MASK) | (((uint32_t)val) << CIU_A53_CORE_0_CFG_CTL_RESERVED1_SHIFT))

#define  CIU_A53_CORE_0_CFG_CTL_ARCH_MODE_MASK 0x8000000
#define  CIU_A53_CORE_0_CFG_CTL_ARCH_MODE_SHIFT 27
#define  CIU_A53_CORE_0_CFG_CTL_ARCH_MODE_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_0_CFG_CTL_ARCH_MODE_MASK) >> CIU_A53_CORE_0_CFG_CTL_ARCH_MODE_SHIFT)
#define  CIU_A53_CORE_0_CFG_CTL_ARCH_MODE_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_0_CFG_CTL_ARCH_MODE_MASK) | (((uint32_t)val) << CIU_A53_CORE_0_CFG_CTL_ARCH_MODE_SHIFT))

#define  CIU_A53_CORE_0_CFG_CTL_NIDEN_MASK 0x4000000
#define  CIU_A53_CORE_0_CFG_CTL_NIDEN_SHIFT 26
#define  CIU_A53_CORE_0_CFG_CTL_NIDEN_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_0_CFG_CTL_NIDEN_MASK) >> CIU_A53_CORE_0_CFG_CTL_NIDEN_SHIFT)
#define  CIU_A53_CORE_0_CFG_CTL_NIDEN_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_0_CFG_CTL_NIDEN_MASK) | (((uint32_t)val) << CIU_A53_CORE_0_CFG_CTL_NIDEN_SHIFT))

#define  CIU_A53_CORE_0_CFG_CTL_SPNIDEN_MASK 0x2000000
#define  CIU_A53_CORE_0_CFG_CTL_SPNIDEN_SHIFT 25
#define  CIU_A53_CORE_0_CFG_CTL_SPNIDEN_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_0_CFG_CTL_SPNIDEN_MASK) >> CIU_A53_CORE_0_CFG_CTL_SPNIDEN_SHIFT)
#define  CIU_A53_CORE_0_CFG_CTL_SPNIDEN_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_0_CFG_CTL_SPNIDEN_MASK) | (((uint32_t)val) << CIU_A53_CORE_0_CFG_CTL_SPNIDEN_SHIFT))

#define  CIU_A53_CORE_0_CFG_CTL_SPIDEN_MASK 0x1000000
#define  CIU_A53_CORE_0_CFG_CTL_SPIDEN_SHIFT 24
#define  CIU_A53_CORE_0_CFG_CTL_SPIDEN_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_0_CFG_CTL_SPIDEN_MASK) >> CIU_A53_CORE_0_CFG_CTL_SPIDEN_SHIFT)
#define  CIU_A53_CORE_0_CFG_CTL_SPIDEN_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_0_CFG_CTL_SPIDEN_MASK) | (((uint32_t)val) << CIU_A53_CORE_0_CFG_CTL_SPIDEN_SHIFT))

#define  CIU_A53_CORE_0_CFG_CTL_RESERVED2_MASK 0xfff800
#define  CIU_A53_CORE_0_CFG_CTL_RESERVED2_SHIFT 11
#define  CIU_A53_CORE_0_CFG_CTL_RESERVED2_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_0_CFG_CTL_RESERVED2_MASK) >> CIU_A53_CORE_0_CFG_CTL_RESERVED2_SHIFT)
#define  CIU_A53_CORE_0_CFG_CTL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_0_CFG_CTL_RESERVED2_MASK) | (((uint32_t)val) << CIU_A53_CORE_0_CFG_CTL_RESERVED2_SHIFT))

#define  CIU_A53_CORE_0_CFG_CTL_RESERVED3_MASK 0x600
#define  CIU_A53_CORE_0_CFG_CTL_RESERVED3_SHIFT 9
#define  CIU_A53_CORE_0_CFG_CTL_RESERVED3_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_0_CFG_CTL_RESERVED3_MASK) >> CIU_A53_CORE_0_CFG_CTL_RESERVED3_SHIFT)
#define  CIU_A53_CORE_0_CFG_CTL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_0_CFG_CTL_RESERVED3_MASK) | (((uint32_t)val) << CIU_A53_CORE_0_CFG_CTL_RESERVED3_SHIFT))

#define  CIU_A53_CORE_0_CFG_CTL_BIGENDINIT_MASK 0x100
#define  CIU_A53_CORE_0_CFG_CTL_BIGENDINIT_SHIFT 8
#define  CIU_A53_CORE_0_CFG_CTL_BIGENDINIT_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_0_CFG_CTL_BIGENDINIT_MASK) >> CIU_A53_CORE_0_CFG_CTL_BIGENDINIT_SHIFT)
#define  CIU_A53_CORE_0_CFG_CTL_BIGENDINIT_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_0_CFG_CTL_BIGENDINIT_MASK) | (((uint32_t)val) << CIU_A53_CORE_0_CFG_CTL_BIGENDINIT_SHIFT))

#define  CIU_A53_CORE_0_CFG_CTL_THUMB_EXCPT_INIT_MASK 0x80
#define  CIU_A53_CORE_0_CFG_CTL_THUMB_EXCPT_INIT_SHIFT 7
#define  CIU_A53_CORE_0_CFG_CTL_THUMB_EXCPT_INIT_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_0_CFG_CTL_THUMB_EXCPT_INIT_MASK) >> CIU_A53_CORE_0_CFG_CTL_THUMB_EXCPT_INIT_SHIFT)
#define  CIU_A53_CORE_0_CFG_CTL_THUMB_EXCPT_INIT_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_0_CFG_CTL_THUMB_EXCPT_INIT_MASK) | (((uint32_t)val) << CIU_A53_CORE_0_CFG_CTL_THUMB_EXCPT_INIT_SHIFT))

#define  CIU_A53_CORE_0_CFG_CTL_GLOBAL_CG_BYPASS_MASK 0x40
#define  CIU_A53_CORE_0_CFG_CTL_GLOBAL_CG_BYPASS_SHIFT 6
#define  CIU_A53_CORE_0_CFG_CTL_GLOBAL_CG_BYPASS_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_0_CFG_CTL_GLOBAL_CG_BYPASS_MASK) >> CIU_A53_CORE_0_CFG_CTL_GLOBAL_CG_BYPASS_SHIFT)
#define  CIU_A53_CORE_0_CFG_CTL_GLOBAL_CG_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_0_CFG_CTL_GLOBAL_CG_BYPASS_MASK) | (((uint32_t)val) << CIU_A53_CORE_0_CFG_CTL_GLOBAL_CG_BYPASS_SHIFT))

#define  CIU_A53_CORE_0_CFG_CTL_CP15SDISABLE_MASK 0x20
#define  CIU_A53_CORE_0_CFG_CTL_CP15SDISABLE_SHIFT 5
#define  CIU_A53_CORE_0_CFG_CTL_CP15SDISABLE_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_0_CFG_CTL_CP15SDISABLE_MASK) >> CIU_A53_CORE_0_CFG_CTL_CP15SDISABLE_SHIFT)
#define  CIU_A53_CORE_0_CFG_CTL_CP15SDISABLE_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_0_CFG_CTL_CP15SDISABLE_MASK) | (((uint32_t)val) << CIU_A53_CORE_0_CFG_CTL_CP15SDISABLE_SHIFT))

#define  CIU_A53_CORE_0_CFG_CTL_RESERVED4_MASK 0x1e
#define  CIU_A53_CORE_0_CFG_CTL_RESERVED4_SHIFT 1
#define  CIU_A53_CORE_0_CFG_CTL_RESERVED4_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_0_CFG_CTL_RESERVED4_MASK) >> CIU_A53_CORE_0_CFG_CTL_RESERVED4_SHIFT)
#define  CIU_A53_CORE_0_CFG_CTL_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_0_CFG_CTL_RESERVED4_MASK) | (((uint32_t)val) << CIU_A53_CORE_0_CFG_CTL_RESERVED4_SHIFT))

#define  CIU_A53_CORE_0_CFG_CTL_VINITHI_MASK 0x1
#define  CIU_A53_CORE_0_CFG_CTL_VINITHI_SHIFT 0
#define  CIU_A53_CORE_0_CFG_CTL_VINITHI_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_0_CFG_CTL_VINITHI_MASK) >> CIU_A53_CORE_0_CFG_CTL_VINITHI_SHIFT)
#define  CIU_A53_CORE_0_CFG_CTL_VINITHI_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_0_CFG_CTL_VINITHI_MASK) | (((uint32_t)val) << CIU_A53_CORE_0_CFG_CTL_VINITHI_SHIFT))

//====================================================================
//Register: REG_0C (spare) (REG_0C)
//====================================================================

#define  CIU_REG_0C_RESERVED1_MASK 0xffffffff
#define  CIU_REG_0C_RESERVED1_SHIFT 0
#define  CIU_REG_0C_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_0C_RESERVED1_MASK) >> CIU_REG_0C_RESERVED1_SHIFT)
#define  CIU_REG_0C_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_0C_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_0C_RESERVED1_SHIFT))

//====================================================================
//Register: REG_10 (spare) (REG_10)
//====================================================================

#define  CIU_REG_10_RESERVED1_MASK 0xffffffff
#define  CIU_REG_10_RESERVED1_SHIFT 0
#define  CIU_REG_10_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_10_RESERVED1_MASK) >> CIU_REG_10_RESERVED1_SHIFT)
#define  CIU_REG_10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_10_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_10_RESERVED1_SHIFT))

//====================================================================
//Register: REG_14 (spare) (REG_14)
//====================================================================

#define  CIU_REG_14_RESERVED1_MASK 0xffffffff
#define  CIU_REG_14_RESERVED1_SHIFT 0
#define  CIU_REG_14_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_14_RESERVED1_MASK) >> CIU_REG_14_RESERVED1_SHIFT)
#define  CIU_REG_14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_14_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_14_RESERVED1_SHIFT))

//====================================================================
//Register: REG_18 (spare) (REG_18)
//====================================================================

#define  CIU_REG_18_RESERVED1_MASK 0xffffffff
#define  CIU_REG_18_RESERVED1_SHIFT 0
#define  CIU_REG_18_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_18_RESERVED1_MASK) >> CIU_REG_18_RESERVED1_SHIFT)
#define  CIU_REG_18_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_18_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_18_RESERVED1_SHIFT))

//====================================================================
//Register: REG_1C (spare) (REG_1C)
//====================================================================

#define  CIU_REG_1C_RESERVED1_MASK 0xffffffff
#define  CIU_REG_1C_RESERVED1_SHIFT 0
#define  CIU_REG_1C_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_1C_RESERVED1_MASK) >> CIU_REG_1C_RESERVED1_SHIFT)
#define  CIU_REG_1C_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_1C_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_1C_RESERVED1_SHIFT))

//====================================================================
//Register: System Boot Control Register (SYS_BOOT_CNTRL)
/** \brief Most of the bits in this register are based on fuse inputs (noted with
"Fuse Input" in Description). Initial values reflect the value when the
fuse is not programmed. If the corresponding fuse bit is programmed to 1,
then the initial value should be inverted (the same is also true for
overriding).
This register can be configured by WTM to be secure for read and write
access.*/
//====================================================================

#define  CIU_SYS_BOOT_CNTRL_RESERVED1_MASK 0xf0000000
#define  CIU_SYS_BOOT_CNTRL_RESERVED1_SHIFT 28
#define  CIU_SYS_BOOT_CNTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_SYS_BOOT_CNTRL_RESERVED1_MASK) >> CIU_SYS_BOOT_CNTRL_RESERVED1_SHIFT)
#define  CIU_SYS_BOOT_CNTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_SYS_BOOT_CNTRL_RESERVED1_MASK) | (((uint32_t)val) << CIU_SYS_BOOT_CNTRL_RESERVED1_SHIFT))

#define  CIU_SYS_BOOT_CNTRL_BOOT_PLTFM_STATE_MASK 0xfc00000
#define  CIU_SYS_BOOT_CNTRL_BOOT_PLTFM_STATE_SHIFT 22
#define  CIU_SYS_BOOT_CNTRL_BOOT_PLTFM_STATE_MASK_SHIFT(reg) (((reg) & CIU_SYS_BOOT_CNTRL_BOOT_PLTFM_STATE_MASK) >> CIU_SYS_BOOT_CNTRL_BOOT_PLTFM_STATE_SHIFT)
#define  CIU_SYS_BOOT_CNTRL_BOOT_PLTFM_STATE_REPLACE_VAL(reg,val) (((reg) & ~CIU_SYS_BOOT_CNTRL_BOOT_PLTFM_STATE_MASK) | (((uint32_t)val) << CIU_SYS_BOOT_CNTRL_BOOT_PLTFM_STATE_SHIFT))

#define  CIU_SYS_BOOT_CNTRL_BOOT_ROM_RESERVED_STRAP_1_MASK 0x200000
#define  CIU_SYS_BOOT_CNTRL_BOOT_ROM_RESERVED_STRAP_1_SHIFT 21
#define  CIU_SYS_BOOT_CNTRL_BOOT_ROM_RESERVED_STRAP_1_MASK_SHIFT(reg) (((reg) & CIU_SYS_BOOT_CNTRL_BOOT_ROM_RESERVED_STRAP_1_MASK) >> CIU_SYS_BOOT_CNTRL_BOOT_ROM_RESERVED_STRAP_1_SHIFT)
#define  CIU_SYS_BOOT_CNTRL_BOOT_ROM_RESERVED_STRAP_1_REPLACE_VAL(reg,val) (((reg) & ~CIU_SYS_BOOT_CNTRL_BOOT_ROM_RESERVED_STRAP_1_MASK) | (((uint32_t)val) << CIU_SYS_BOOT_CNTRL_BOOT_ROM_RESERVED_STRAP_1_SHIFT))

#define  CIU_SYS_BOOT_CNTRL_BOOT_ROM_RESERVED_STRAP_0_MASK 0x100000
#define  CIU_SYS_BOOT_CNTRL_BOOT_ROM_RESERVED_STRAP_0_SHIFT 20
#define  CIU_SYS_BOOT_CNTRL_BOOT_ROM_RESERVED_STRAP_0_MASK_SHIFT(reg) (((reg) & CIU_SYS_BOOT_CNTRL_BOOT_ROM_RESERVED_STRAP_0_MASK) >> CIU_SYS_BOOT_CNTRL_BOOT_ROM_RESERVED_STRAP_0_SHIFT)
#define  CIU_SYS_BOOT_CNTRL_BOOT_ROM_RESERVED_STRAP_0_REPLACE_VAL(reg,val) (((reg) & ~CIU_SYS_BOOT_CNTRL_BOOT_ROM_RESERVED_STRAP_0_MASK) | (((uint32_t)val) << CIU_SYS_BOOT_CNTRL_BOOT_ROM_RESERVED_STRAP_0_SHIFT))

#define  CIU_SYS_BOOT_CNTRL_DOWNLOAD_DISABLE_MASK 0x80000
#define  CIU_SYS_BOOT_CNTRL_DOWNLOAD_DISABLE_SHIFT 19
#define  CIU_SYS_BOOT_CNTRL_DOWNLOAD_DISABLE_MASK_SHIFT(reg) (((reg) & CIU_SYS_BOOT_CNTRL_DOWNLOAD_DISABLE_MASK) >> CIU_SYS_BOOT_CNTRL_DOWNLOAD_DISABLE_SHIFT)
#define  CIU_SYS_BOOT_CNTRL_DOWNLOAD_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~CIU_SYS_BOOT_CNTRL_DOWNLOAD_DISABLE_MASK) | (((uint32_t)val) << CIU_SYS_BOOT_CNTRL_DOWNLOAD_DISABLE_SHIFT))

#define  CIU_SYS_BOOT_CNTRL_SKEY_ACCESS_DISABLE_MASK 0x40000
#define  CIU_SYS_BOOT_CNTRL_SKEY_ACCESS_DISABLE_SHIFT 18
#define  CIU_SYS_BOOT_CNTRL_SKEY_ACCESS_DISABLE_MASK_SHIFT(reg) (((reg) & CIU_SYS_BOOT_CNTRL_SKEY_ACCESS_DISABLE_MASK) >> CIU_SYS_BOOT_CNTRL_SKEY_ACCESS_DISABLE_SHIFT)
#define  CIU_SYS_BOOT_CNTRL_SKEY_ACCESS_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~CIU_SYS_BOOT_CNTRL_SKEY_ACCESS_DISABLE_MASK) | (((uint32_t)val) << CIU_SYS_BOOT_CNTRL_SKEY_ACCESS_DISABLE_SHIFT))

#define  CIU_SYS_BOOT_CNTRL_NO_NAND_DEVICE_MASK 0x20000
#define  CIU_SYS_BOOT_CNTRL_NO_NAND_DEVICE_SHIFT 17
#define  CIU_SYS_BOOT_CNTRL_NO_NAND_DEVICE_MASK_SHIFT(reg) (((reg) & CIU_SYS_BOOT_CNTRL_NO_NAND_DEVICE_MASK) >> CIU_SYS_BOOT_CNTRL_NO_NAND_DEVICE_SHIFT)
#define  CIU_SYS_BOOT_CNTRL_NO_NAND_DEVICE_REPLACE_VAL(reg,val) (((reg) & ~CIU_SYS_BOOT_CNTRL_NO_NAND_DEVICE_MASK) | (((uint32_t)val) << CIU_SYS_BOOT_CNTRL_NO_NAND_DEVICE_SHIFT))

#define  CIU_SYS_BOOT_CNTRL_RESERVED2_MASK 0x18000
#define  CIU_SYS_BOOT_CNTRL_RESERVED2_SHIFT 15
#define  CIU_SYS_BOOT_CNTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & CIU_SYS_BOOT_CNTRL_RESERVED2_MASK) >> CIU_SYS_BOOT_CNTRL_RESERVED2_SHIFT)
#define  CIU_SYS_BOOT_CNTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CIU_SYS_BOOT_CNTRL_RESERVED2_MASK) | (((uint32_t)val) << CIU_SYS_BOOT_CNTRL_RESERVED2_SHIFT))

#define  CIU_SYS_BOOT_CNTRL_RESUME_FROM_SLEEP_MASK 0x4000
#define  CIU_SYS_BOOT_CNTRL_RESUME_FROM_SLEEP_SHIFT 14
#define  CIU_SYS_BOOT_CNTRL_RESUME_FROM_SLEEP_MASK_SHIFT(reg) (((reg) & CIU_SYS_BOOT_CNTRL_RESUME_FROM_SLEEP_MASK) >> CIU_SYS_BOOT_CNTRL_RESUME_FROM_SLEEP_SHIFT)
#define  CIU_SYS_BOOT_CNTRL_RESUME_FROM_SLEEP_REPLACE_VAL(reg,val) (((reg) & ~CIU_SYS_BOOT_CNTRL_RESUME_FROM_SLEEP_MASK) | (((uint32_t)val) << CIU_SYS_BOOT_CNTRL_RESUME_FROM_SLEEP_SHIFT))

#define  CIU_SYS_BOOT_CNTRL_USB_PORT_D_MASK 0x2000
#define  CIU_SYS_BOOT_CNTRL_USB_PORT_D_SHIFT 13
#define  CIU_SYS_BOOT_CNTRL_USB_PORT_D_MASK_SHIFT(reg) (((reg) & CIU_SYS_BOOT_CNTRL_USB_PORT_D_MASK) >> CIU_SYS_BOOT_CNTRL_USB_PORT_D_SHIFT)
#define  CIU_SYS_BOOT_CNTRL_USB_PORT_D_REPLACE_VAL(reg,val) (((reg) & ~CIU_SYS_BOOT_CNTRL_USB_PORT_D_MASK) | (((uint32_t)val) << CIU_SYS_BOOT_CNTRL_USB_PORT_D_SHIFT))

#define  CIU_SYS_BOOT_CNTRL_UART_PORT_D_MASK 0x1000
#define  CIU_SYS_BOOT_CNTRL_UART_PORT_D_SHIFT 12
#define  CIU_SYS_BOOT_CNTRL_UART_PORT_D_MASK_SHIFT(reg) (((reg) & CIU_SYS_BOOT_CNTRL_UART_PORT_D_MASK) >> CIU_SYS_BOOT_CNTRL_UART_PORT_D_SHIFT)
#define  CIU_SYS_BOOT_CNTRL_UART_PORT_D_REPLACE_VAL(reg,val) (((reg) & ~CIU_SYS_BOOT_CNTRL_UART_PORT_D_MASK) | (((uint32_t)val) << CIU_SYS_BOOT_CNTRL_UART_PORT_D_SHIFT))

#define  CIU_SYS_BOOT_CNTRL_BROM_MASK 0xc00
#define  CIU_SYS_BOOT_CNTRL_BROM_SHIFT 10
#define  CIU_SYS_BOOT_CNTRL_BROM_MASK_SHIFT(reg) (((reg) & CIU_SYS_BOOT_CNTRL_BROM_MASK) >> CIU_SYS_BOOT_CNTRL_BROM_SHIFT)
#define  CIU_SYS_BOOT_CNTRL_BROM_REPLACE_VAL(reg,val) (((reg) & ~CIU_SYS_BOOT_CNTRL_BROM_MASK) | (((uint32_t)val) << CIU_SYS_BOOT_CNTRL_BROM_SHIFT))

#define  CIU_SYS_BOOT_CNTRL_RESERVED3_MASK 0x200
#define  CIU_SYS_BOOT_CNTRL_RESERVED3_SHIFT 9
#define  CIU_SYS_BOOT_CNTRL_RESERVED3_MASK_SHIFT(reg) (((reg) & CIU_SYS_BOOT_CNTRL_RESERVED3_MASK) >> CIU_SYS_BOOT_CNTRL_RESERVED3_SHIFT)
#define  CIU_SYS_BOOT_CNTRL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~CIU_SYS_BOOT_CNTRL_RESERVED3_MASK) | (((uint32_t)val) << CIU_SYS_BOOT_CNTRL_RESERVED3_SHIFT))

#define  CIU_SYS_BOOT_CNTRL_BOOT_ROM_RESERVED_STRAP_2_MASK 0x100
#define  CIU_SYS_BOOT_CNTRL_BOOT_ROM_RESERVED_STRAP_2_SHIFT 8
#define  CIU_SYS_BOOT_CNTRL_BOOT_ROM_RESERVED_STRAP_2_MASK_SHIFT(reg) (((reg) & CIU_SYS_BOOT_CNTRL_BOOT_ROM_RESERVED_STRAP_2_MASK) >> CIU_SYS_BOOT_CNTRL_BOOT_ROM_RESERVED_STRAP_2_SHIFT)
#define  CIU_SYS_BOOT_CNTRL_BOOT_ROM_RESERVED_STRAP_2_REPLACE_VAL(reg,val) (((reg) & ~CIU_SYS_BOOT_CNTRL_BOOT_ROM_RESERVED_STRAP_2_MASK) | (((uint32_t)val) << CIU_SYS_BOOT_CNTRL_BOOT_ROM_RESERVED_STRAP_2_SHIFT))

#define  CIU_SYS_BOOT_CNTRL_RESERVED4_MASK 0x80
#define  CIU_SYS_BOOT_CNTRL_RESERVED4_SHIFT 7
#define  CIU_SYS_BOOT_CNTRL_RESERVED4_MASK_SHIFT(reg) (((reg) & CIU_SYS_BOOT_CNTRL_RESERVED4_MASK) >> CIU_SYS_BOOT_CNTRL_RESERVED4_SHIFT)
#define  CIU_SYS_BOOT_CNTRL_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~CIU_SYS_BOOT_CNTRL_RESERVED4_MASK) | (((uint32_t)val) << CIU_SYS_BOOT_CNTRL_RESERVED4_SHIFT))

#define  CIU_SYS_BOOT_CNTRL_JTAG_DISABLE_MASK 0x40
#define  CIU_SYS_BOOT_CNTRL_JTAG_DISABLE_SHIFT 6
#define  CIU_SYS_BOOT_CNTRL_JTAG_DISABLE_MASK_SHIFT(reg) (((reg) & CIU_SYS_BOOT_CNTRL_JTAG_DISABLE_MASK) >> CIU_SYS_BOOT_CNTRL_JTAG_DISABLE_SHIFT)
#define  CIU_SYS_BOOT_CNTRL_JTAG_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~CIU_SYS_BOOT_CNTRL_JTAG_DISABLE_MASK) | (((uint32_t)val) << CIU_SYS_BOOT_CNTRL_JTAG_DISABLE_SHIFT))

#define  CIU_SYS_BOOT_CNTRL_RESERVED5_MASK 0x20
#define  CIU_SYS_BOOT_CNTRL_RESERVED5_SHIFT 5
#define  CIU_SYS_BOOT_CNTRL_RESERVED5_MASK_SHIFT(reg) (((reg) & CIU_SYS_BOOT_CNTRL_RESERVED5_MASK) >> CIU_SYS_BOOT_CNTRL_RESERVED5_SHIFT)
#define  CIU_SYS_BOOT_CNTRL_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~CIU_SYS_BOOT_CNTRL_RESERVED5_MASK) | (((uint32_t)val) << CIU_SYS_BOOT_CNTRL_RESERVED5_SHIFT))

#define  CIU_SYS_BOOT_CNTRL_NCSAH_MASK 0x1e
#define  CIU_SYS_BOOT_CNTRL_NCSAH_SHIFT 1
#define  CIU_SYS_BOOT_CNTRL_NCSAH_MASK_SHIFT(reg) (((reg) & CIU_SYS_BOOT_CNTRL_NCSAH_MASK) >> CIU_SYS_BOOT_CNTRL_NCSAH_SHIFT)
#define  CIU_SYS_BOOT_CNTRL_NCSAH_REPLACE_VAL(reg,val) (((reg) & ~CIU_SYS_BOOT_CNTRL_NCSAH_MASK) | (((uint32_t)val) << CIU_SYS_BOOT_CNTRL_NCSAH_SHIFT))

#define  CIU_SYS_BOOT_CNTRL_DEBUG_EN_MASK 0x1
#define  CIU_SYS_BOOT_CNTRL_DEBUG_EN_SHIFT 0
#define  CIU_SYS_BOOT_CNTRL_DEBUG_EN_MASK_SHIFT(reg) (((reg) & CIU_SYS_BOOT_CNTRL_DEBUG_EN_MASK) >> CIU_SYS_BOOT_CNTRL_DEBUG_EN_SHIFT)
#define  CIU_SYS_BOOT_CNTRL_DEBUG_EN_REPLACE_VAL(reg,val) (((reg) & ~CIU_SYS_BOOT_CNTRL_DEBUG_EN_MASK) | (((uint32_t)val) << CIU_SYS_BOOT_CNTRL_DEBUG_EN_SHIFT))

//====================================================================
//Register: Software Branch Address Register (SW_BRANCH_ADDR)
//====================================================================

#define  CIU_SW_BRANCH_ADDR_SW_BRANCH_ADDR_MASK 0xffffffff
#define  CIU_SW_BRANCH_ADDR_SW_BRANCH_ADDR_SHIFT 0
#define  CIU_SW_BRANCH_ADDR_SW_BRANCH_ADDR_MASK_SHIFT(reg) (((reg) & CIU_SW_BRANCH_ADDR_SW_BRANCH_ADDR_MASK) >> CIU_SW_BRANCH_ADDR_SW_BRANCH_ADDR_SHIFT)
#define  CIU_SW_BRANCH_ADDR_SW_BRANCH_ADDR_REPLACE_VAL(reg,val) (((reg) & ~CIU_SW_BRANCH_ADDR_SW_BRANCH_ADDR_MASK) | (((uint32_t)val) << CIU_SW_BRANCH_ADDR_SW_BRANCH_ADDR_SHIFT))

//====================================================================
//Register: REG_28 (spare) (REG_28)
//====================================================================

#define  CIU_REG_28_RESERVED1_MASK 0xffffffff
#define  CIU_REG_28_RESERVED1_SHIFT 0
#define  CIU_REG_28_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_28_RESERVED1_MASK) >> CIU_REG_28_RESERVED1_SHIFT)
#define  CIU_REG_28_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_28_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_28_RESERVED1_SHIFT))

//====================================================================
//Register: REG_2C (spare) (REG_2C)
//====================================================================

#define  CIU_REG_2C_RESERVED1_MASK 0xffffffff
#define  CIU_REG_2C_RESERVED1_SHIFT 0
#define  CIU_REG_2C_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_2C_RESERVED1_MASK) >> CIU_REG_2C_RESERVED1_SHIFT)
#define  CIU_REG_2C_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_2C_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_2C_RESERVED1_SHIFT))

//====================================================================
//Register: RVBARADDR0 Lower Address (RVBARADDR0L)
//====================================================================

#define  CIU_RVBARADDR0L_LOWER_ADDRESS_MASK 0xffffffff
#define  CIU_RVBARADDR0L_LOWER_ADDRESS_SHIFT 0
#define  CIU_RVBARADDR0L_LOWER_ADDRESS_MASK_SHIFT(reg) (((reg) & CIU_RVBARADDR0L_LOWER_ADDRESS_MASK) >> CIU_RVBARADDR0L_LOWER_ADDRESS_SHIFT)
#define  CIU_RVBARADDR0L_LOWER_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~CIU_RVBARADDR0L_LOWER_ADDRESS_MASK) | (((uint32_t)val) << CIU_RVBARADDR0L_LOWER_ADDRESS_SHIFT))

//====================================================================
//Register: RVBARADDR0 Upper Address (RVBARADDR0H)
//====================================================================

#define  CIU_RVBARADDR0H_RESERVED1_MASK 0xffffffc0
#define  CIU_RVBARADDR0H_RESERVED1_SHIFT 6
#define  CIU_RVBARADDR0H_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_RVBARADDR0H_RESERVED1_MASK) >> CIU_RVBARADDR0H_RESERVED1_SHIFT)
#define  CIU_RVBARADDR0H_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_RVBARADDR0H_RESERVED1_MASK) | (((uint32_t)val) << CIU_RVBARADDR0H_RESERVED1_SHIFT))

#define  CIU_RVBARADDR0H_UPPER_ADDRESS_MASK 0x3f
#define  CIU_RVBARADDR0H_UPPER_ADDRESS_SHIFT 0
#define  CIU_RVBARADDR0H_UPPER_ADDRESS_MASK_SHIFT(reg) (((reg) & CIU_RVBARADDR0H_UPPER_ADDRESS_MASK) >> CIU_RVBARADDR0H_UPPER_ADDRESS_SHIFT)
#define  CIU_RVBARADDR0H_UPPER_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~CIU_RVBARADDR0H_UPPER_ADDRESS_MASK) | (((uint32_t)val) << CIU_RVBARADDR0H_UPPER_ADDRESS_SHIFT))

//====================================================================
//Register: RVBARADDR1 Lower Address (RVBARADDR1L)
//====================================================================

#define  CIU_RVBARADDR1L_LOWER_ADDRESS_MASK 0xffffffff
#define  CIU_RVBARADDR1L_LOWER_ADDRESS_SHIFT 0
#define  CIU_RVBARADDR1L_LOWER_ADDRESS_MASK_SHIFT(reg) (((reg) & CIU_RVBARADDR1L_LOWER_ADDRESS_MASK) >> CIU_RVBARADDR1L_LOWER_ADDRESS_SHIFT)
#define  CIU_RVBARADDR1L_LOWER_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~CIU_RVBARADDR1L_LOWER_ADDRESS_MASK) | (((uint32_t)val) << CIU_RVBARADDR1L_LOWER_ADDRESS_SHIFT))

//====================================================================
//Register: RVBARADDR1 Upper Address (RVBARADDR1H)
//====================================================================

#define  CIU_RVBARADDR1H_RESERVED1_MASK 0xffffffc0
#define  CIU_RVBARADDR1H_RESERVED1_SHIFT 6
#define  CIU_RVBARADDR1H_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_RVBARADDR1H_RESERVED1_MASK) >> CIU_RVBARADDR1H_RESERVED1_SHIFT)
#define  CIU_RVBARADDR1H_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_RVBARADDR1H_RESERVED1_MASK) | (((uint32_t)val) << CIU_RVBARADDR1H_RESERVED1_SHIFT))

#define  CIU_RVBARADDR1H_UPPER_ADDRESS_MASK 0x3f
#define  CIU_RVBARADDR1H_UPPER_ADDRESS_SHIFT 0
#define  CIU_RVBARADDR1H_UPPER_ADDRESS_MASK_SHIFT(reg) (((reg) & CIU_RVBARADDR1H_UPPER_ADDRESS_MASK) >> CIU_RVBARADDR1H_UPPER_ADDRESS_SHIFT)
#define  CIU_RVBARADDR1H_UPPER_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~CIU_RVBARADDR1H_UPPER_ADDRESS_MASK) | (((uint32_t)val) << CIU_RVBARADDR1H_UPPER_ADDRESS_SHIFT))

//====================================================================
//Register: REG_40 (spare) (REG_40)
//====================================================================

#define  CIU_REG_40_RESERVED1_MASK 0xffffffff
#define  CIU_REG_40_RESERVED1_SHIFT 0
#define  CIU_REG_40_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_40_RESERVED1_MASK) >> CIU_REG_40_RESERVED1_SHIFT)
#define  CIU_REG_40_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_40_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_40_RESERVED1_SHIFT))

//====================================================================
//Register: REG_44 (spare) (REG_44)
//====================================================================

#define  CIU_REG_44_RESERVED1_MASK 0xffffffff
#define  CIU_REG_44_RESERVED1_SHIFT 0
#define  CIU_REG_44_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_44_RESERVED1_MASK) >> CIU_REG_44_RESERVED1_SHIFT)
#define  CIU_REG_44_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_44_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_44_RESERVED1_SHIFT))

//====================================================================
//Register: Memory Controller Configuration Register (MC_CONF)
//====================================================================

#define  CIU_MC_CONF_RESERVED1_MASK 0xfffffffc
#define  CIU_MC_CONF_RESERVED1_SHIFT 2
#define  CIU_MC_CONF_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_MC_CONF_RESERVED1_MASK) >> CIU_MC_CONF_RESERVED1_SHIFT)
#define  CIU_MC_CONF_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_MC_CONF_RESERVED1_MASK) | (((uint32_t)val) << CIU_MC_CONF_RESERVED1_SHIFT))

#define  CIU_MC_CONF_MC_PHY_DLL_DIS_MASK 0x2
#define  CIU_MC_CONF_MC_PHY_DLL_DIS_SHIFT 1
#define  CIU_MC_CONF_MC_PHY_DLL_DIS_MASK_SHIFT(reg) (((reg) & CIU_MC_CONF_MC_PHY_DLL_DIS_MASK) >> CIU_MC_CONF_MC_PHY_DLL_DIS_SHIFT)
#define  CIU_MC_CONF_MC_PHY_DLL_DIS_REPLACE_VAL(reg,val) (((reg) & ~CIU_MC_CONF_MC_PHY_DLL_DIS_MASK) | (((uint32_t)val) << CIU_MC_CONF_MC_PHY_DLL_DIS_SHIFT))

#define  CIU_MC_CONF_MC_PHY_PLL_DIS_MASK 0x1
#define  CIU_MC_CONF_MC_PHY_PLL_DIS_SHIFT 0
#define  CIU_MC_CONF_MC_PHY_PLL_DIS_MASK_SHIFT(reg) (((reg) & CIU_MC_CONF_MC_PHY_PLL_DIS_MASK) >> CIU_MC_CONF_MC_PHY_PLL_DIS_SHIFT)
#define  CIU_MC_CONF_MC_PHY_PLL_DIS_REPLACE_VAL(reg,val) (((reg) & ~CIU_MC_CONF_MC_PHY_PLL_DIS_MASK) | (((uint32_t)val) << CIU_MC_CONF_MC_PHY_PLL_DIS_SHIFT))

//====================================================================
//Register: Core Sight Core Configuration Register (CORESIGHT_CONFIG)
//====================================================================

#define  CIU_CORESIGHT_CONFIG_RESERVED1_MASK 0xffffffc0
#define  CIU_CORESIGHT_CONFIG_RESERVED1_SHIFT 6
#define  CIU_CORESIGHT_CONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_CORESIGHT_CONFIG_RESERVED1_MASK) >> CIU_CORESIGHT_CONFIG_RESERVED1_SHIFT)
#define  CIU_CORESIGHT_CONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_CORESIGHT_CONFIG_RESERVED1_MASK) | (((uint32_t)val) << CIU_CORESIGHT_CONFIG_RESERVED1_SHIFT))

#define  CIU_CORESIGHT_CONFIG_DBGNOPWRDWN_MASK 0x20
#define  CIU_CORESIGHT_CONFIG_DBGNOPWRDWN_SHIFT 5
#define  CIU_CORESIGHT_CONFIG_DBGNOPWRDWN_MASK_SHIFT(reg) (((reg) & CIU_CORESIGHT_CONFIG_DBGNOPWRDWN_MASK) >> CIU_CORESIGHT_CONFIG_DBGNOPWRDWN_SHIFT)
#define  CIU_CORESIGHT_CONFIG_DBGNOPWRDWN_REPLACE_VAL(reg,val) (((reg) & ~CIU_CORESIGHT_CONFIG_DBGNOPWRDWN_MASK) | (((uint32_t)val) << CIU_CORESIGHT_CONFIG_DBGNOPWRDWN_SHIFT))

#define  CIU_CORESIGHT_CONFIG_TPMAXDATASIZE_MASK 0x1f
#define  CIU_CORESIGHT_CONFIG_TPMAXDATASIZE_SHIFT 0
#define  CIU_CORESIGHT_CONFIG_TPMAXDATASIZE_MASK_SHIFT(reg) (((reg) & CIU_CORESIGHT_CONFIG_TPMAXDATASIZE_MASK) >> CIU_CORESIGHT_CONFIG_TPMAXDATASIZE_SHIFT)
#define  CIU_CORESIGHT_CONFIG_TPMAXDATASIZE_REPLACE_VAL(reg,val) (((reg) & ~CIU_CORESIGHT_CONFIG_TPMAXDATASIZE_MASK) | (((uint32_t)val) << CIU_CORESIGHT_CONFIG_TPMAXDATASIZE_SHIFT))

//====================================================================
//Register: REG_50 (spare) (REG_50)
//====================================================================

#define  CIU_REG_50_RESERVED1_MASK 0xffffffff
#define  CIU_REG_50_RESERVED1_SHIFT 0
#define  CIU_REG_50_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_50_RESERVED1_MASK) >> CIU_REG_50_RESERVED1_SHIFT)
#define  CIU_REG_50_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_50_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_50_RESERVED1_SHIFT))

//====================================================================
//Register: REG_54 (spare) (REG_54)
//====================================================================

#define  CIU_REG_54_RESERVED1_MASK 0xffffffff
#define  CIU_REG_54_RESERVED1_SHIFT 0
#define  CIU_REG_54_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_54_RESERVED1_MASK) >> CIU_REG_54_RESERVED1_SHIFT)
#define  CIU_REG_54_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_54_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_54_RESERVED1_SHIFT))

//====================================================================
//Register: REG_58 (spare) (REG_58)
//====================================================================

#define  CIU_REG_58_RESERVED1_MASK 0xffffffff
#define  CIU_REG_58_RESERVED1_SHIFT 0
#define  CIU_REG_58_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_58_RESERVED1_MASK) >> CIU_REG_58_RESERVED1_SHIFT)
#define  CIU_REG_58_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_58_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_58_RESERVED1_SHIFT))

//====================================================================
//Register: MC Loopback Control Register (MC_LOOPBACK_CNTRL)
//====================================================================

#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_STATUS_MASK 0xffff0000
#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_STATUS_SHIFT 16
#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_STATUS_MASK_SHIFT(reg) (((reg) & CIU_MC_LOOPBACK_CNTRL_MC_PRBS_STATUS_MASK) >> CIU_MC_LOOPBACK_CNTRL_MC_PRBS_STATUS_SHIFT)
#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_STATUS_REPLACE_VAL(reg,val) (((reg) & ~CIU_MC_LOOPBACK_CNTRL_MC_PRBS_STATUS_MASK) | (((uint32_t)val) << CIU_MC_LOOPBACK_CNTRL_MC_PRBS_STATUS_SHIFT))

#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_DONE_MASK 0x8000
#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_DONE_SHIFT 15
#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_DONE_MASK_SHIFT(reg) (((reg) & CIU_MC_LOOPBACK_CNTRL_MC_PRBS_DONE_MASK) >> CIU_MC_LOOPBACK_CNTRL_MC_PRBS_DONE_SHIFT)
#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_DONE_REPLACE_VAL(reg,val) (((reg) & ~CIU_MC_LOOPBACK_CNTRL_MC_PRBS_DONE_MASK) | (((uint32_t)val) << CIU_MC_LOOPBACK_CNTRL_MC_PRBS_DONE_SHIFT))

#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_FAIL_MASK 0x4000
#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_FAIL_SHIFT 14
#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_FAIL_MASK_SHIFT(reg) (((reg) & CIU_MC_LOOPBACK_CNTRL_MC_PRBS_FAIL_MASK) >> CIU_MC_LOOPBACK_CNTRL_MC_PRBS_FAIL_SHIFT)
#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_FAIL_REPLACE_VAL(reg,val) (((reg) & ~CIU_MC_LOOPBACK_CNTRL_MC_PRBS_FAIL_MASK) | (((uint32_t)val) << CIU_MC_LOOPBACK_CNTRL_MC_PRBS_FAIL_SHIFT))

#define  CIU_MC_LOOPBACK_CNTRL_RESERVED1_MASK 0x3000
#define  CIU_MC_LOOPBACK_CNTRL_RESERVED1_SHIFT 12
#define  CIU_MC_LOOPBACK_CNTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_MC_LOOPBACK_CNTRL_RESERVED1_MASK) >> CIU_MC_LOOPBACK_CNTRL_RESERVED1_SHIFT)
#define  CIU_MC_LOOPBACK_CNTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_MC_LOOPBACK_CNTRL_RESERVED1_MASK) | (((uint32_t)val) << CIU_MC_LOOPBACK_CNTRL_RESERVED1_SHIFT))

#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_SKIP_CMD_SUBPHY_MASK 0x800
#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_SKIP_CMD_SUBPHY_SHIFT 11
#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_SKIP_CMD_SUBPHY_MASK_SHIFT(reg) (((reg) & CIU_MC_LOOPBACK_CNTRL_MC_PRBS_SKIP_CMD_SUBPHY_MASK) >> CIU_MC_LOOPBACK_CNTRL_MC_PRBS_SKIP_CMD_SUBPHY_SHIFT)
#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_SKIP_CMD_SUBPHY_REPLACE_VAL(reg,val) (((reg) & ~CIU_MC_LOOPBACK_CNTRL_MC_PRBS_SKIP_CMD_SUBPHY_MASK) | (((uint32_t)val) << CIU_MC_LOOPBACK_CNTRL_MC_PRBS_SKIP_CMD_SUBPHY_SHIFT))

#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_ADC_DELAY_MASK 0x7c0
#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_ADC_DELAY_SHIFT 6
#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_ADC_DELAY_MASK_SHIFT(reg) (((reg) & CIU_MC_LOOPBACK_CNTRL_MC_PRBS_ADC_DELAY_MASK) >> CIU_MC_LOOPBACK_CNTRL_MC_PRBS_ADC_DELAY_SHIFT)
#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_ADC_DELAY_REPLACE_VAL(reg,val) (((reg) & ~CIU_MC_LOOPBACK_CNTRL_MC_PRBS_ADC_DELAY_MASK) | (((uint32_t)val) << CIU_MC_LOOPBACK_CNTRL_MC_PRBS_ADC_DELAY_SHIFT))

#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_DATA_DELAY_MASK 0x3e
#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_DATA_DELAY_SHIFT 1
#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_DATA_DELAY_MASK_SHIFT(reg) (((reg) & CIU_MC_LOOPBACK_CNTRL_MC_PRBS_DATA_DELAY_MASK) >> CIU_MC_LOOPBACK_CNTRL_MC_PRBS_DATA_DELAY_SHIFT)
#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_DATA_DELAY_REPLACE_VAL(reg,val) (((reg) & ~CIU_MC_LOOPBACK_CNTRL_MC_PRBS_DATA_DELAY_MASK) | (((uint32_t)val) << CIU_MC_LOOPBACK_CNTRL_MC_PRBS_DATA_DELAY_SHIFT))

#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_START_MASK 0x1
#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_START_SHIFT 0
#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_START_MASK_SHIFT(reg) (((reg) & CIU_MC_LOOPBACK_CNTRL_MC_PRBS_START_MASK) >> CIU_MC_LOOPBACK_CNTRL_MC_PRBS_START_SHIFT)
#define  CIU_MC_LOOPBACK_CNTRL_MC_PRBS_START_REPLACE_VAL(reg,val) (((reg) & ~CIU_MC_LOOPBACK_CNTRL_MC_PRBS_START_MASK) | (((uint32_t)val) << CIU_MC_LOOPBACK_CNTRL_MC_PRBS_START_SHIFT))

//====================================================================
//Register: RVBARADDR2 Lower Address (RVBARADDR2L)
//====================================================================

#define  CIU_RVBARADDR2L_LOWER_ADDRESS_MASK 0xffffffff
#define  CIU_RVBARADDR2L_LOWER_ADDRESS_SHIFT 0
#define  CIU_RVBARADDR2L_LOWER_ADDRESS_MASK_SHIFT(reg) (((reg) & CIU_RVBARADDR2L_LOWER_ADDRESS_MASK) >> CIU_RVBARADDR2L_LOWER_ADDRESS_SHIFT)
#define  CIU_RVBARADDR2L_LOWER_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~CIU_RVBARADDR2L_LOWER_ADDRESS_MASK) | (((uint32_t)val) << CIU_RVBARADDR2L_LOWER_ADDRESS_SHIFT))

//====================================================================
//Register: RVBARADDR2 Upper Address (RVBARADDR2H)
//====================================================================

#define  CIU_RVBARADDR2H_RESERVED1_MASK 0xffffffc0
#define  CIU_RVBARADDR2H_RESERVED1_SHIFT 6
#define  CIU_RVBARADDR2H_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_RVBARADDR2H_RESERVED1_MASK) >> CIU_RVBARADDR2H_RESERVED1_SHIFT)
#define  CIU_RVBARADDR2H_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_RVBARADDR2H_RESERVED1_MASK) | (((uint32_t)val) << CIU_RVBARADDR2H_RESERVED1_SHIFT))

#define  CIU_RVBARADDR2H_UPPER_ADDRESS_MASK 0x3f
#define  CIU_RVBARADDR2H_UPPER_ADDRESS_SHIFT 0
#define  CIU_RVBARADDR2H_UPPER_ADDRESS_MASK_SHIFT(reg) (((reg) & CIU_RVBARADDR2H_UPPER_ADDRESS_MASK) >> CIU_RVBARADDR2H_UPPER_ADDRESS_SHIFT)
#define  CIU_RVBARADDR2H_UPPER_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~CIU_RVBARADDR2H_UPPER_ADDRESS_MASK) | (((uint32_t)val) << CIU_RVBARADDR2H_UPPER_ADDRESS_SHIFT))

//====================================================================
//Register: RVBARADDR3 Lower Address (RVBARADDR3L)
//====================================================================

#define  CIU_RVBARADDR3L_LOWER_ADDRESS_MASK 0xffffffff
#define  CIU_RVBARADDR3L_LOWER_ADDRESS_SHIFT 0
#define  CIU_RVBARADDR3L_LOWER_ADDRESS_MASK_SHIFT(reg) (((reg) & CIU_RVBARADDR3L_LOWER_ADDRESS_MASK) >> CIU_RVBARADDR3L_LOWER_ADDRESS_SHIFT)
#define  CIU_RVBARADDR3L_LOWER_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~CIU_RVBARADDR3L_LOWER_ADDRESS_MASK) | (((uint32_t)val) << CIU_RVBARADDR3L_LOWER_ADDRESS_SHIFT))

//====================================================================
//Register: RVBARADDR3 Upper Address (RVBARADDR3H)
//====================================================================

#define  CIU_RVBARADDR3H_RESERVED1_MASK 0xffffffc0
#define  CIU_RVBARADDR3H_RESERVED1_SHIFT 6
#define  CIU_RVBARADDR3H_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_RVBARADDR3H_RESERVED1_MASK) >> CIU_RVBARADDR3H_RESERVED1_SHIFT)
#define  CIU_RVBARADDR3H_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_RVBARADDR3H_RESERVED1_MASK) | (((uint32_t)val) << CIU_RVBARADDR3H_RESERVED1_SHIFT))

#define  CIU_RVBARADDR3H_UPPER_ADDRESS_MASK 0x3f
#define  CIU_RVBARADDR3H_UPPER_ADDRESS_SHIFT 0
#define  CIU_RVBARADDR3H_UPPER_ADDRESS_MASK_SHIFT(reg) (((reg) & CIU_RVBARADDR3H_UPPER_ADDRESS_MASK) >> CIU_RVBARADDR3H_UPPER_ADDRESS_SHIFT)
#define  CIU_RVBARADDR3H_UPPER_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~CIU_RVBARADDR3H_UPPER_ADDRESS_MASK) | (((uint32_t)val) << CIU_RVBARADDR3H_UPPER_ADDRESS_SHIFT))

//====================================================================
//Register: REG_70 (spare) (REG_70)
//====================================================================

#define  CIU_REG_70_RESERVED1_MASK 0xffffffff
#define  CIU_REG_70_RESERVED1_SHIFT 0
#define  CIU_REG_70_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_70_RESERVED1_MASK) >> CIU_REG_70_RESERVED1_SHIFT)
#define  CIU_REG_70_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_70_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_70_RESERVED1_SHIFT))

//====================================================================
//Register: REG_74 (spare) (REG_74)
//====================================================================

#define  CIU_REG_74_RESERVED1_MASK 0xffffffff
#define  CIU_REG_74_RESERVED1_SHIFT 0
#define  CIU_REG_74_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_74_RESERVED1_MASK) >> CIU_REG_74_RESERVED1_SHIFT)
#define  CIU_REG_74_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_74_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_74_RESERVED1_SHIFT))

//====================================================================
//Register: Cortex A53 Compiled Memory RTC WTC Configuration Register (CIU_CA53_RWTC_CFG_CTL1)
/** \brief This is a read/write register. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  CIU_CIU_CA53_RWTC_CFG_CTL1_MPCORE_CORE_SRAM_WTC_RTC__MASK 0xffffffff
#define  CIU_CIU_CA53_RWTC_CFG_CTL1_MPCORE_CORE_SRAM_WTC_RTC__SHIFT 0
#define  CIU_CIU_CA53_RWTC_CFG_CTL1_MPCORE_CORE_SRAM_WTC_RTC__MASK_SHIFT(reg) (((reg) & CIU_CIU_CA53_RWTC_CFG_CTL1_MPCORE_CORE_SRAM_WTC_RTC__MASK) >> CIU_CIU_CA53_RWTC_CFG_CTL1_MPCORE_CORE_SRAM_WTC_RTC__SHIFT)
#define  CIU_CIU_CA53_RWTC_CFG_CTL1_MPCORE_CORE_SRAM_WTC_RTC__REPLACE_VAL(reg,val) (((reg) & ~CIU_CIU_CA53_RWTC_CFG_CTL1_MPCORE_CORE_SRAM_WTC_RTC__MASK) | (((uint32_t)val) << CIU_CIU_CA53_RWTC_CFG_CTL1_MPCORE_CORE_SRAM_WTC_RTC__SHIFT))

//====================================================================
//Register: Cortex A53 Compiled Memory RTC WTC Configuration 2 Register (CIU_CA53_RWTC_CFG_CTL2)
/** \brief This is a read/write register. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  CIU_CIU_CA53_RWTC_CFG_CTL2_RESERVED1_MASK 0xffff0000
#define  CIU_CIU_CA53_RWTC_CFG_CTL2_RESERVED1_SHIFT 16
#define  CIU_CIU_CA53_RWTC_CFG_CTL2_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_CIU_CA53_RWTC_CFG_CTL2_RESERVED1_MASK) >> CIU_CIU_CA53_RWTC_CFG_CTL2_RESERVED1_SHIFT)
#define  CIU_CIU_CA53_RWTC_CFG_CTL2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_CIU_CA53_RWTC_CFG_CTL2_RESERVED1_MASK) | (((uint32_t)val) << CIU_CIU_CA53_RWTC_CFG_CTL2_RESERVED1_SHIFT))

#define  CIU_CIU_CA53_RWTC_CFG_CTL2_MPCORE_NON_CPU_SRAM_WTC_RTC__MASK 0xffff
#define  CIU_CIU_CA53_RWTC_CFG_CTL2_MPCORE_NON_CPU_SRAM_WTC_RTC__SHIFT 0
#define  CIU_CIU_CA53_RWTC_CFG_CTL2_MPCORE_NON_CPU_SRAM_WTC_RTC__MASK_SHIFT(reg) (((reg) & CIU_CIU_CA53_RWTC_CFG_CTL2_MPCORE_NON_CPU_SRAM_WTC_RTC__MASK) >> CIU_CIU_CA53_RWTC_CFG_CTL2_MPCORE_NON_CPU_SRAM_WTC_RTC__SHIFT)
#define  CIU_CIU_CA53_RWTC_CFG_CTL2_MPCORE_NON_CPU_SRAM_WTC_RTC__REPLACE_VAL(reg,val) (((reg) & ~CIU_CIU_CA53_RWTC_CFG_CTL2_MPCORE_NON_CPU_SRAM_WTC_RTC__MASK) | (((uint32_t)val) << CIU_CIU_CA53_RWTC_CFG_CTL2_MPCORE_NON_CPU_SRAM_WTC_RTC__SHIFT))

//====================================================================
//Register: R4_Vector_Remap (R4_Vector_Remap)
//====================================================================

#define  CIU_R4_VECTOR_REMAP_RESERVED1_MASK 0xfffe0000
#define  CIU_R4_VECTOR_REMAP_RESERVED1_SHIFT 17
#define  CIU_R4_VECTOR_REMAP_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_R4_VECTOR_REMAP_RESERVED1_MASK) >> CIU_R4_VECTOR_REMAP_RESERVED1_SHIFT)
#define  CIU_R4_VECTOR_REMAP_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_R4_VECTOR_REMAP_RESERVED1_MASK) | (((uint32_t)val) << CIU_R4_VECTOR_REMAP_RESERVED1_SHIFT))

#define  CIU_R4_VECTOR_REMAP_R4_VECTOR_REMAP_ENABLE_MASK 0x10000
#define  CIU_R4_VECTOR_REMAP_R4_VECTOR_REMAP_ENABLE_SHIFT 16
#define  CIU_R4_VECTOR_REMAP_R4_VECTOR_REMAP_ENABLE_MASK_SHIFT(reg) (((reg) & CIU_R4_VECTOR_REMAP_R4_VECTOR_REMAP_ENABLE_MASK) >> CIU_R4_VECTOR_REMAP_R4_VECTOR_REMAP_ENABLE_SHIFT)
#define  CIU_R4_VECTOR_REMAP_R4_VECTOR_REMAP_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~CIU_R4_VECTOR_REMAP_R4_VECTOR_REMAP_ENABLE_MASK) | (((uint32_t)val) << CIU_R4_VECTOR_REMAP_R4_VECTOR_REMAP_ENABLE_SHIFT))

#define  CIU_R4_VECTOR_REMAP_R4_VECTOR_REMAP_ADDRESS_MASK 0xffff
#define  CIU_R4_VECTOR_REMAP_R4_VECTOR_REMAP_ADDRESS_SHIFT 0
#define  CIU_R4_VECTOR_REMAP_R4_VECTOR_REMAP_ADDRESS_MASK_SHIFT(reg) (((reg) & CIU_R4_VECTOR_REMAP_R4_VECTOR_REMAP_ADDRESS_MASK) >> CIU_R4_VECTOR_REMAP_R4_VECTOR_REMAP_ADDRESS_SHIFT)
#define  CIU_R4_VECTOR_REMAP_R4_VECTOR_REMAP_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~CIU_R4_VECTOR_REMAP_R4_VECTOR_REMAP_ADDRESS_MASK) | (((uint32_t)val) << CIU_R4_VECTOR_REMAP_R4_VECTOR_REMAP_ADDRESS_SHIFT))

//====================================================================
//Register: Cortex CPU Debug Control Register (CIU_CPU_DBG_CNTRL)
/** \brief This is a read/write register. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  CIU_CIU_CPU_DBG_CNTRL_RESERVED1_MASK 0xc0000000
#define  CIU_CIU_CPU_DBG_CNTRL_RESERVED1_SHIFT 30
#define  CIU_CIU_CPU_DBG_CNTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_CIU_CPU_DBG_CNTRL_RESERVED1_MASK) >> CIU_CIU_CPU_DBG_CNTRL_RESERVED1_SHIFT)
#define  CIU_CIU_CPU_DBG_CNTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_CIU_CPU_DBG_CNTRL_RESERVED1_MASK) | (((uint32_t)val) << CIU_CIU_CPU_DBG_CNTRL_RESERVED1_SHIFT))

#define  CIU_CIU_CPU_DBG_CNTRL_A53_DBGPDWNREQ_MASK 0x30000000
#define  CIU_CIU_CPU_DBG_CNTRL_A53_DBGPDWNREQ_SHIFT 28
#define  CIU_CIU_CPU_DBG_CNTRL_A53_DBGPDWNREQ_MASK_SHIFT(reg) (((reg) & CIU_CIU_CPU_DBG_CNTRL_A53_DBGPDWNREQ_MASK) >> CIU_CIU_CPU_DBG_CNTRL_A53_DBGPDWNREQ_SHIFT)
#define  CIU_CIU_CPU_DBG_CNTRL_A53_DBGPDWNREQ_REPLACE_VAL(reg,val) (((reg) & ~CIU_CIU_CPU_DBG_CNTRL_A53_DBGPDWNREQ_MASK) | (((uint32_t)val) << CIU_CIU_CPU_DBG_CNTRL_A53_DBGPDWNREQ_SHIFT))

#define  CIU_CIU_CPU_DBG_CNTRL_RESERVED2_MASK 0xc000000
#define  CIU_CIU_CPU_DBG_CNTRL_RESERVED2_SHIFT 26
#define  CIU_CIU_CPU_DBG_CNTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & CIU_CIU_CPU_DBG_CNTRL_RESERVED2_MASK) >> CIU_CIU_CPU_DBG_CNTRL_RESERVED2_SHIFT)
#define  CIU_CIU_CPU_DBG_CNTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CIU_CIU_CPU_DBG_CNTRL_RESERVED2_MASK) | (((uint32_t)val) << CIU_CIU_CPU_DBG_CNTRL_RESERVED2_SHIFT))

#define  CIU_CIU_CPU_DBG_CNTRL_DBGSWENABLE_MASK 0x2000000
#define  CIU_CIU_CPU_DBG_CNTRL_DBGSWENABLE_SHIFT 25
#define  CIU_CIU_CPU_DBG_CNTRL_DBGSWENABLE_MASK_SHIFT(reg) (((reg) & CIU_CIU_CPU_DBG_CNTRL_DBGSWENABLE_MASK) >> CIU_CIU_CPU_DBG_CNTRL_DBGSWENABLE_SHIFT)
#define  CIU_CIU_CPU_DBG_CNTRL_DBGSWENABLE_REPLACE_VAL(reg,val) (((reg) & ~CIU_CIU_CPU_DBG_CNTRL_DBGSWENABLE_MASK) | (((uint32_t)val) << CIU_CIU_CPU_DBG_CNTRL_DBGSWENABLE_SHIFT))

#define  CIU_CIU_CPU_DBG_CNTRL_DBGEN_MASK 0x1000000
#define  CIU_CIU_CPU_DBG_CNTRL_DBGEN_SHIFT 24
#define  CIU_CIU_CPU_DBG_CNTRL_DBGEN_MASK_SHIFT(reg) (((reg) & CIU_CIU_CPU_DBG_CNTRL_DBGEN_MASK) >> CIU_CIU_CPU_DBG_CNTRL_DBGEN_SHIFT)
#define  CIU_CIU_CPU_DBG_CNTRL_DBGEN_REPLACE_VAL(reg,val) (((reg) & ~CIU_CIU_CPU_DBG_CNTRL_DBGEN_MASK) | (((uint32_t)val) << CIU_CIU_CPU_DBG_CNTRL_DBGEN_SHIFT))

#define  CIU_CIU_CPU_DBG_CNTRL_RESERVED3_MASK 0xffffff
#define  CIU_CIU_CPU_DBG_CNTRL_RESERVED3_SHIFT 0
#define  CIU_CIU_CPU_DBG_CNTRL_RESERVED3_MASK_SHIFT(reg) (((reg) & CIU_CIU_CPU_DBG_CNTRL_RESERVED3_MASK) >> CIU_CIU_CPU_DBG_CNTRL_RESERVED3_SHIFT)
#define  CIU_CIU_CPU_DBG_CNTRL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~CIU_CIU_CPU_DBG_CNTRL_RESERVED3_MASK) | (((uint32_t)val) << CIU_CIU_CPU_DBG_CNTRL_RESERVED3_SHIFT))

//====================================================================
//Register: Cortex A53 Core 1 Configuration Control Register (A53_CORE_1_CFG_CTL)
/** \brief This is a read/write register. Ignore reads from reserved bits. Write 0b0
to reserved bits.*/
//====================================================================

#define  CIU_A53_CORE_1_CFG_CTL_RESERVED1_MASK 0xf0000000
#define  CIU_A53_CORE_1_CFG_CTL_RESERVED1_SHIFT 28
#define  CIU_A53_CORE_1_CFG_CTL_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_1_CFG_CTL_RESERVED1_MASK) >> CIU_A53_CORE_1_CFG_CTL_RESERVED1_SHIFT)
#define  CIU_A53_CORE_1_CFG_CTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_1_CFG_CTL_RESERVED1_MASK) | (((uint32_t)val) << CIU_A53_CORE_1_CFG_CTL_RESERVED1_SHIFT))

#define  CIU_A53_CORE_1_CFG_CTL_ARCH_MODE_MASK 0x8000000
#define  CIU_A53_CORE_1_CFG_CTL_ARCH_MODE_SHIFT 27
#define  CIU_A53_CORE_1_CFG_CTL_ARCH_MODE_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_1_CFG_CTL_ARCH_MODE_MASK) >> CIU_A53_CORE_1_CFG_CTL_ARCH_MODE_SHIFT)
#define  CIU_A53_CORE_1_CFG_CTL_ARCH_MODE_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_1_CFG_CTL_ARCH_MODE_MASK) | (((uint32_t)val) << CIU_A53_CORE_1_CFG_CTL_ARCH_MODE_SHIFT))

#define  CIU_A53_CORE_1_CFG_CTL_NIDEN_MASK 0x4000000
#define  CIU_A53_CORE_1_CFG_CTL_NIDEN_SHIFT 26
#define  CIU_A53_CORE_1_CFG_CTL_NIDEN_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_1_CFG_CTL_NIDEN_MASK) >> CIU_A53_CORE_1_CFG_CTL_NIDEN_SHIFT)
#define  CIU_A53_CORE_1_CFG_CTL_NIDEN_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_1_CFG_CTL_NIDEN_MASK) | (((uint32_t)val) << CIU_A53_CORE_1_CFG_CTL_NIDEN_SHIFT))

#define  CIU_A53_CORE_1_CFG_CTL_SPNIDEN_MASK 0x2000000
#define  CIU_A53_CORE_1_CFG_CTL_SPNIDEN_SHIFT 25
#define  CIU_A53_CORE_1_CFG_CTL_SPNIDEN_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_1_CFG_CTL_SPNIDEN_MASK) >> CIU_A53_CORE_1_CFG_CTL_SPNIDEN_SHIFT)
#define  CIU_A53_CORE_1_CFG_CTL_SPNIDEN_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_1_CFG_CTL_SPNIDEN_MASK) | (((uint32_t)val) << CIU_A53_CORE_1_CFG_CTL_SPNIDEN_SHIFT))

#define  CIU_A53_CORE_1_CFG_CTL_SPIDEN_MASK 0x1000000
#define  CIU_A53_CORE_1_CFG_CTL_SPIDEN_SHIFT 24
#define  CIU_A53_CORE_1_CFG_CTL_SPIDEN_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_1_CFG_CTL_SPIDEN_MASK) >> CIU_A53_CORE_1_CFG_CTL_SPIDEN_SHIFT)
#define  CIU_A53_CORE_1_CFG_CTL_SPIDEN_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_1_CFG_CTL_SPIDEN_MASK) | (((uint32_t)val) << CIU_A53_CORE_1_CFG_CTL_SPIDEN_SHIFT))

#define  CIU_A53_CORE_1_CFG_CTL_RESERVED2_MASK 0xff0000
#define  CIU_A53_CORE_1_CFG_CTL_RESERVED2_SHIFT 16
#define  CIU_A53_CORE_1_CFG_CTL_RESERVED2_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_1_CFG_CTL_RESERVED2_MASK) >> CIU_A53_CORE_1_CFG_CTL_RESERVED2_SHIFT)
#define  CIU_A53_CORE_1_CFG_CTL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_1_CFG_CTL_RESERVED2_MASK) | (((uint32_t)val) << CIU_A53_CORE_1_CFG_CTL_RESERVED2_SHIFT))

#define  CIU_A53_CORE_1_CFG_CTL_RESERVED3_MASK 0xfe00
#define  CIU_A53_CORE_1_CFG_CTL_RESERVED3_SHIFT 9
#define  CIU_A53_CORE_1_CFG_CTL_RESERVED3_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_1_CFG_CTL_RESERVED3_MASK) >> CIU_A53_CORE_1_CFG_CTL_RESERVED3_SHIFT)
#define  CIU_A53_CORE_1_CFG_CTL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_1_CFG_CTL_RESERVED3_MASK) | (((uint32_t)val) << CIU_A53_CORE_1_CFG_CTL_RESERVED3_SHIFT))

#define  CIU_A53_CORE_1_CFG_CTL_BIGENDINIT_MASK 0x100
#define  CIU_A53_CORE_1_CFG_CTL_BIGENDINIT_SHIFT 8
#define  CIU_A53_CORE_1_CFG_CTL_BIGENDINIT_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_1_CFG_CTL_BIGENDINIT_MASK) >> CIU_A53_CORE_1_CFG_CTL_BIGENDINIT_SHIFT)
#define  CIU_A53_CORE_1_CFG_CTL_BIGENDINIT_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_1_CFG_CTL_BIGENDINIT_MASK) | (((uint32_t)val) << CIU_A53_CORE_1_CFG_CTL_BIGENDINIT_SHIFT))

#define  CIU_A53_CORE_1_CFG_CTL_THUMB_EXCPT_INIT_MASK 0x80
#define  CIU_A53_CORE_1_CFG_CTL_THUMB_EXCPT_INIT_SHIFT 7
#define  CIU_A53_CORE_1_CFG_CTL_THUMB_EXCPT_INIT_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_1_CFG_CTL_THUMB_EXCPT_INIT_MASK) >> CIU_A53_CORE_1_CFG_CTL_THUMB_EXCPT_INIT_SHIFT)
#define  CIU_A53_CORE_1_CFG_CTL_THUMB_EXCPT_INIT_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_1_CFG_CTL_THUMB_EXCPT_INIT_MASK) | (((uint32_t)val) << CIU_A53_CORE_1_CFG_CTL_THUMB_EXCPT_INIT_SHIFT))

#define  CIU_A53_CORE_1_CFG_CTL_RESERVED4_MASK 0x40
#define  CIU_A53_CORE_1_CFG_CTL_RESERVED4_SHIFT 6
#define  CIU_A53_CORE_1_CFG_CTL_RESERVED4_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_1_CFG_CTL_RESERVED4_MASK) >> CIU_A53_CORE_1_CFG_CTL_RESERVED4_SHIFT)
#define  CIU_A53_CORE_1_CFG_CTL_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_1_CFG_CTL_RESERVED4_MASK) | (((uint32_t)val) << CIU_A53_CORE_1_CFG_CTL_RESERVED4_SHIFT))

#define  CIU_A53_CORE_1_CFG_CTL_CP15SDISABLE_MASK 0x20
#define  CIU_A53_CORE_1_CFG_CTL_CP15SDISABLE_SHIFT 5
#define  CIU_A53_CORE_1_CFG_CTL_CP15SDISABLE_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_1_CFG_CTL_CP15SDISABLE_MASK) >> CIU_A53_CORE_1_CFG_CTL_CP15SDISABLE_SHIFT)
#define  CIU_A53_CORE_1_CFG_CTL_CP15SDISABLE_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_1_CFG_CTL_CP15SDISABLE_MASK) | (((uint32_t)val) << CIU_A53_CORE_1_CFG_CTL_CP15SDISABLE_SHIFT))

#define  CIU_A53_CORE_1_CFG_CTL_RESERVED5_MASK 0x1e
#define  CIU_A53_CORE_1_CFG_CTL_RESERVED5_SHIFT 1
#define  CIU_A53_CORE_1_CFG_CTL_RESERVED5_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_1_CFG_CTL_RESERVED5_MASK) >> CIU_A53_CORE_1_CFG_CTL_RESERVED5_SHIFT)
#define  CIU_A53_CORE_1_CFG_CTL_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_1_CFG_CTL_RESERVED5_MASK) | (((uint32_t)val) << CIU_A53_CORE_1_CFG_CTL_RESERVED5_SHIFT))

#define  CIU_A53_CORE_1_CFG_CTL_VINITHI_MASK 0x1
#define  CIU_A53_CORE_1_CFG_CTL_VINITHI_SHIFT 0
#define  CIU_A53_CORE_1_CFG_CTL_VINITHI_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_1_CFG_CTL_VINITHI_MASK) >> CIU_A53_CORE_1_CFG_CTL_VINITHI_SHIFT)
#define  CIU_A53_CORE_1_CFG_CTL_VINITHI_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_1_CFG_CTL_VINITHI_MASK) | (((uint32_t)val) << CIU_A53_CORE_1_CFG_CTL_VINITHI_SHIFT))

//====================================================================
//Register: REG_8C (spare) (REG_8C)
//====================================================================

#define  CIU_REG_8C_RESERVED1_MASK 0xffffffff
#define  CIU_REG_8C_RESERVED1_SHIFT 0
#define  CIU_REG_8C_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_8C_RESERVED1_MASK) >> CIU_REG_8C_RESERVED1_SHIFT)
#define  CIU_REG_8C_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_8C_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_8C_RESERVED1_SHIFT))

//====================================================================
//Register: REG_90 (spare) (REG_90)
//====================================================================

#define  CIU_REG_90_RESERVED1_MASK 0xffffffff
#define  CIU_REG_90_RESERVED1_SHIFT 0
#define  CIU_REG_90_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_90_RESERVED1_MASK) >> CIU_REG_90_RESERVED1_SHIFT)
#define  CIU_REG_90_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_90_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_90_RESERVED1_SHIFT))

//====================================================================
//Register: REG_94 (spare) (REG_94)
//====================================================================

#define  CIU_REG_94_RESERVED1_MASK 0xffffffff
#define  CIU_REG_94_RESERVED1_SHIFT 0
#define  CIU_REG_94_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_94_RESERVED1_MASK) >> CIU_REG_94_RESERVED1_SHIFT)
#define  CIU_REG_94_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_94_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_94_RESERVED1_SHIFT))

//====================================================================
//Register: REG_98 (spare) (REG_98)
//====================================================================

#define  CIU_REG_98_RESERVED1_MASK 0xffffffff
#define  CIU_REG_98_RESERVED1_SHIFT 0
#define  CIU_REG_98_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_98_RESERVED1_MASK) >> CIU_REG_98_RESERVED1_SHIFT)
#define  CIU_REG_98_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_98_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_98_RESERVED1_SHIFT))

//====================================================================
//Register: REG_9C (spare) (REG_9C)
//====================================================================

#define  CIU_REG_9C_RESERVED1_MASK 0xffffffff
#define  CIU_REG_9C_RESERVED1_SHIFT 0
#define  CIU_REG_9C_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_9C_RESERVED1_MASK) >> CIU_REG_9C_RESERVED1_SHIFT)
#define  CIU_REG_9C_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_9C_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_9C_RESERVED1_SHIFT))

//====================================================================
//Register: DDR Control (DDR_CONTROL)
/** \brief This is a read/write register. Ignore reads from reserved bits. Write 0b0 to
bits.*/
//====================================================================

#define  CIU_DDR_CONTROL_EXTERNAL_DDR3_MASK 0x80000000
#define  CIU_DDR_CONTROL_EXTERNAL_DDR3_SHIFT 31
#define  CIU_DDR_CONTROL_EXTERNAL_DDR3_MASK_SHIFT(reg) (((reg) & CIU_DDR_CONTROL_EXTERNAL_DDR3_MASK) >> CIU_DDR_CONTROL_EXTERNAL_DDR3_SHIFT)
#define  CIU_DDR_CONTROL_EXTERNAL_DDR3_REPLACE_VAL(reg,val) (((reg) & ~CIU_DDR_CONTROL_EXTERNAL_DDR3_MASK) | (((uint32_t)val) << CIU_DDR_CONTROL_EXTERNAL_DDR3_SHIFT))

#define  CIU_DDR_CONTROL_DDR_SPARE_CTRL2_MASK 0x7fffe000
#define  CIU_DDR_CONTROL_DDR_SPARE_CTRL2_SHIFT 13
#define  CIU_DDR_CONTROL_DDR_SPARE_CTRL2_MASK_SHIFT(reg) (((reg) & CIU_DDR_CONTROL_DDR_SPARE_CTRL2_MASK) >> CIU_DDR_CONTROL_DDR_SPARE_CTRL2_SHIFT)
#define  CIU_DDR_CONTROL_DDR_SPARE_CTRL2_REPLACE_VAL(reg,val) (((reg) & ~CIU_DDR_CONTROL_DDR_SPARE_CTRL2_MASK) | (((uint32_t)val) << CIU_DDR_CONTROL_DDR_SPARE_CTRL2_SHIFT))

#define  CIU_DDR_CONTROL_ASL_FILTER_CPU_ACCESSES_MASK 0x1000
#define  CIU_DDR_CONTROL_ASL_FILTER_CPU_ACCESSES_SHIFT 12
#define  CIU_DDR_CONTROL_ASL_FILTER_CPU_ACCESSES_MASK_SHIFT(reg) (((reg) & CIU_DDR_CONTROL_ASL_FILTER_CPU_ACCESSES_MASK) >> CIU_DDR_CONTROL_ASL_FILTER_CPU_ACCESSES_SHIFT)
#define  CIU_DDR_CONTROL_ASL_FILTER_CPU_ACCESSES_REPLACE_VAL(reg,val) (((reg) & ~CIU_DDR_CONTROL_ASL_FILTER_CPU_ACCESSES_MASK) | (((uint32_t)val) << CIU_DDR_CONTROL_ASL_FILTER_CPU_ACCESSES_SHIFT))

#define  CIU_DDR_CONTROL_DDR_SPARE_CTRL1_MASK 0xe00
#define  CIU_DDR_CONTROL_DDR_SPARE_CTRL1_SHIFT 9
#define  CIU_DDR_CONTROL_DDR_SPARE_CTRL1_MASK_SHIFT(reg) (((reg) & CIU_DDR_CONTROL_DDR_SPARE_CTRL1_MASK) >> CIU_DDR_CONTROL_DDR_SPARE_CTRL1_SHIFT)
#define  CIU_DDR_CONTROL_DDR_SPARE_CTRL1_REPLACE_VAL(reg,val) (((reg) & ~CIU_DDR_CONTROL_DDR_SPARE_CTRL1_MASK) | (((uint32_t)val) << CIU_DDR_CONTROL_DDR_SPARE_CTRL1_SHIFT))

#define  CIU_DDR_CONTROL_MC_WATCHDOG_SOFT_RESET_MASK 0x100
#define  CIU_DDR_CONTROL_MC_WATCHDOG_SOFT_RESET_SHIFT 8
#define  CIU_DDR_CONTROL_MC_WATCHDOG_SOFT_RESET_MASK_SHIFT(reg) (((reg) & CIU_DDR_CONTROL_MC_WATCHDOG_SOFT_RESET_MASK) >> CIU_DDR_CONTROL_MC_WATCHDOG_SOFT_RESET_SHIFT)
#define  CIU_DDR_CONTROL_MC_WATCHDOG_SOFT_RESET_REPLACE_VAL(reg,val) (((reg) & ~CIU_DDR_CONTROL_MC_WATCHDOG_SOFT_RESET_MASK) | (((uint32_t)val) << CIU_DDR_CONTROL_MC_WATCHDOG_SOFT_RESET_SHIFT))

#define  CIU_DDR_CONTROL_DDR_SPARE_CTRL0_MASK 0x80
#define  CIU_DDR_CONTROL_DDR_SPARE_CTRL0_SHIFT 7
#define  CIU_DDR_CONTROL_DDR_SPARE_CTRL0_MASK_SHIFT(reg) (((reg) & CIU_DDR_CONTROL_DDR_SPARE_CTRL0_MASK) >> CIU_DDR_CONTROL_DDR_SPARE_CTRL0_SHIFT)
#define  CIU_DDR_CONTROL_DDR_SPARE_CTRL0_REPLACE_VAL(reg,val) (((reg) & ~CIU_DDR_CONTROL_DDR_SPARE_CTRL0_MASK) | (((uint32_t)val) << CIU_DDR_CONTROL_DDR_SPARE_CTRL0_SHIFT))

#define  CIU_DDR_CONTROL_DDR_INTERLEAVING_MASK 0x7f
#define  CIU_DDR_CONTROL_DDR_INTERLEAVING_SHIFT 0
#define  CIU_DDR_CONTROL_DDR_INTERLEAVING_MASK_SHIFT(reg) (((reg) & CIU_DDR_CONTROL_DDR_INTERLEAVING_MASK) >> CIU_DDR_CONTROL_DDR_INTERLEAVING_SHIFT)
#define  CIU_DDR_CONTROL_DDR_INTERLEAVING_REPLACE_VAL(reg,val) (((reg) & ~CIU_DDR_CONTROL_DDR_INTERLEAVING_MASK) | (((uint32_t)val) << CIU_DDR_CONTROL_DDR_INTERLEAVING_SHIFT))

//====================================================================
//Register: REG_A4 (spare) (REG_A4)
//====================================================================

#define  CIU_REG_A4_RESERVED1_MASK 0xfff00000
#define  CIU_REG_A4_RESERVED1_SHIFT 20
#define  CIU_REG_A4_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_A4_RESERVED1_MASK) >> CIU_REG_A4_RESERVED1_SHIFT)
#define  CIU_REG_A4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_A4_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_A4_RESERVED1_SHIFT))

#define  CIU_REG_A4_RESERVED2_MASK 0xfffff
#define  CIU_REG_A4_RESERVED2_SHIFT 0
#define  CIU_REG_A4_RESERVED2_MASK_SHIFT(reg) (((reg) & CIU_REG_A4_RESERVED2_MASK) >> CIU_REG_A4_RESERVED2_SHIFT)
#define  CIU_REG_A4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_A4_RESERVED2_MASK) | (((uint32_t)val) << CIU_REG_A4_RESERVED2_SHIFT))

//====================================================================
//Register: REG_A8 (spare) (REG_A8)
//====================================================================

#define  CIU_REG_A8_RESERVED1_MASK 0xfff00000
#define  CIU_REG_A8_RESERVED1_SHIFT 20
#define  CIU_REG_A8_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_A8_RESERVED1_MASK) >> CIU_REG_A8_RESERVED1_SHIFT)
#define  CIU_REG_A8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_A8_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_A8_RESERVED1_SHIFT))

#define  CIU_REG_A8_RESERVED2_MASK 0xfffff
#define  CIU_REG_A8_RESERVED2_SHIFT 0
#define  CIU_REG_A8_RESERVED2_MASK_SHIFT(reg) (((reg) & CIU_REG_A8_RESERVED2_MASK) >> CIU_REG_A8_RESERVED2_SHIFT)
#define  CIU_REG_A8_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_A8_RESERVED2_MASK) | (((uint32_t)val) << CIU_REG_A8_RESERVED2_SHIFT))

//====================================================================
//Register: REG_AC (spare) (REG_AC)
//====================================================================

#define  CIU_REG_AC_RESERVED1_MASK 0xfff00000
#define  CIU_REG_AC_RESERVED1_SHIFT 20
#define  CIU_REG_AC_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_AC_RESERVED1_MASK) >> CIU_REG_AC_RESERVED1_SHIFT)
#define  CIU_REG_AC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_AC_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_AC_RESERVED1_SHIFT))

#define  CIU_REG_AC_RESERVED2_MASK 0xfffff
#define  CIU_REG_AC_RESERVED2_SHIFT 0
#define  CIU_REG_AC_RESERVED2_MASK_SHIFT(reg) (((reg) & CIU_REG_AC_RESERVED2_MASK) >> CIU_REG_AC_RESERVED2_SHIFT)
#define  CIU_REG_AC_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_AC_RESERVED2_MASK) | (((uint32_t)val) << CIU_REG_AC_RESERVED2_SHIFT))

//====================================================================
//Register: MC Port 0 Priority Threshold Register (MC_PRIORITY)
/** \brief This register sets the QOS threshold for the MC port 0 - APCPU.
If neither threshold is exceeded by the QOS setting, the port is assigned MC priority LOW.*/
//====================================================================

#define  CIU_MC_PRIORITY_RESERVED1_MASK 0xffffff00
#define  CIU_MC_PRIORITY_RESERVED1_SHIFT 8
#define  CIU_MC_PRIORITY_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_MC_PRIORITY_RESERVED1_MASK) >> CIU_MC_PRIORITY_RESERVED1_SHIFT)
#define  CIU_MC_PRIORITY_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_MC_PRIORITY_RESERVED1_MASK) | (((uint32_t)val) << CIU_MC_PRIORITY_RESERVED1_SHIFT))

#define  CIU_MC_PRIORITY_CRITICAL_THRESHOLD_MASK 0xf0
#define  CIU_MC_PRIORITY_CRITICAL_THRESHOLD_SHIFT 4
#define  CIU_MC_PRIORITY_CRITICAL_THRESHOLD_MASK_SHIFT(reg) (((reg) & CIU_MC_PRIORITY_CRITICAL_THRESHOLD_MASK) >> CIU_MC_PRIORITY_CRITICAL_THRESHOLD_SHIFT)
#define  CIU_MC_PRIORITY_CRITICAL_THRESHOLD_REPLACE_VAL(reg,val) (((reg) & ~CIU_MC_PRIORITY_CRITICAL_THRESHOLD_MASK) | (((uint32_t)val) << CIU_MC_PRIORITY_CRITICAL_THRESHOLD_SHIFT))

#define  CIU_MC_PRIORITY_HI_THRESHOLD_MASK 0xf
#define  CIU_MC_PRIORITY_HI_THRESHOLD_SHIFT 0
#define  CIU_MC_PRIORITY_HI_THRESHOLD_MASK_SHIFT(reg) (((reg) & CIU_MC_PRIORITY_HI_THRESHOLD_MASK) >> CIU_MC_PRIORITY_HI_THRESHOLD_SHIFT)
#define  CIU_MC_PRIORITY_HI_THRESHOLD_REPLACE_VAL(reg,val) (((reg) & ~CIU_MC_PRIORITY_HI_THRESHOLD_MASK) | (((uint32_t)val) << CIU_MC_PRIORITY_HI_THRESHOLD_SHIFT))

//====================================================================
//Register: MC Port 1-3 Priority Threshold Register (MC_PRIORITY2)
/** \brief This register sets the QOS threshold for the MC port 1, 2 and 3.
If neither threshold is exceeded by the QOS setting, the port is assigned MC priority LOW.*/
//====================================================================

#define  CIU_MC_PRIORITY2_RESERVED1_MASK 0xffffff00
#define  CIU_MC_PRIORITY2_RESERVED1_SHIFT 8
#define  CIU_MC_PRIORITY2_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_MC_PRIORITY2_RESERVED1_MASK) >> CIU_MC_PRIORITY2_RESERVED1_SHIFT)
#define  CIU_MC_PRIORITY2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_MC_PRIORITY2_RESERVED1_MASK) | (((uint32_t)val) << CIU_MC_PRIORITY2_RESERVED1_SHIFT))

#define  CIU_MC_PRIORITY2_CRITICAL_THRESHOLD_MASK 0xf0
#define  CIU_MC_PRIORITY2_CRITICAL_THRESHOLD_SHIFT 4
#define  CIU_MC_PRIORITY2_CRITICAL_THRESHOLD_MASK_SHIFT(reg) (((reg) & CIU_MC_PRIORITY2_CRITICAL_THRESHOLD_MASK) >> CIU_MC_PRIORITY2_CRITICAL_THRESHOLD_SHIFT)
#define  CIU_MC_PRIORITY2_CRITICAL_THRESHOLD_REPLACE_VAL(reg,val) (((reg) & ~CIU_MC_PRIORITY2_CRITICAL_THRESHOLD_MASK) | (((uint32_t)val) << CIU_MC_PRIORITY2_CRITICAL_THRESHOLD_SHIFT))

#define  CIU_MC_PRIORITY2_HI_THRESHOLD_MASK 0xf
#define  CIU_MC_PRIORITY2_HI_THRESHOLD_SHIFT 0
#define  CIU_MC_PRIORITY2_HI_THRESHOLD_MASK_SHIFT(reg) (((reg) & CIU_MC_PRIORITY2_HI_THRESHOLD_MASK) >> CIU_MC_PRIORITY2_HI_THRESHOLD_SHIFT)
#define  CIU_MC_PRIORITY2_HI_THRESHOLD_REPLACE_VAL(reg,val) (((reg) & ~CIU_MC_PRIORITY2_HI_THRESHOLD_MASK) | (((uint32_t)val) << CIU_MC_PRIORITY2_HI_THRESHOLD_SHIFT))

//====================================================================
//Register: MC Priority 3 Register (MC_PRIORITY3)
/** \brief This is a read write register.Ignore reads from reserved bits.Write 0 to
reserved bits.*/
//====================================================================

#define  CIU_MC_PRIORITY3_RESERVED1_MASK 0xfffffffe
#define  CIU_MC_PRIORITY3_RESERVED1_SHIFT 1
#define  CIU_MC_PRIORITY3_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_MC_PRIORITY3_RESERVED1_MASK) >> CIU_MC_PRIORITY3_RESERVED1_SHIFT)
#define  CIU_MC_PRIORITY3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_MC_PRIORITY3_RESERVED1_MASK) | (((uint32_t)val) << CIU_MC_PRIORITY3_RESERVED1_SHIFT))

#define  CIU_MC_PRIORITY3_QS_GATE_CLR_MASK 0x1
#define  CIU_MC_PRIORITY3_QS_GATE_CLR_SHIFT 0
#define  CIU_MC_PRIORITY3_QS_GATE_CLR_MASK_SHIFT(reg) (((reg) & CIU_MC_PRIORITY3_QS_GATE_CLR_MASK) >> CIU_MC_PRIORITY3_QS_GATE_CLR_SHIFT)
#define  CIU_MC_PRIORITY3_QS_GATE_CLR_REPLACE_VAL(reg,val) (((reg) & ~CIU_MC_PRIORITY3_QS_GATE_CLR_MASK) | (((uint32_t)val) << CIU_MC_PRIORITY3_QS_GATE_CLR_SHIFT))

//====================================================================
//Register: MFPR Enable Register (CIU_MFPR_EN)
/** \brief This is a read write register.Ignore reads from reserved bits.Write 0 to
reserved bits.*/
//====================================================================

#define  CIU_CIU_MFPR_EN_RESERVED1_MASK 0xfffff800
#define  CIU_CIU_MFPR_EN_RESERVED1_SHIFT 11
#define  CIU_CIU_MFPR_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_CIU_MFPR_EN_RESERVED1_MASK) >> CIU_CIU_MFPR_EN_RESERVED1_SHIFT)
#define  CIU_CIU_MFPR_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_CIU_MFPR_EN_RESERVED1_MASK) | (((uint32_t)val) << CIU_CIU_MFPR_EN_RESERVED1_SHIFT))

#define  CIU_CIU_MFPR_EN_RESERVED2_MASK 0x400
#define  CIU_CIU_MFPR_EN_RESERVED2_SHIFT 10
#define  CIU_CIU_MFPR_EN_RESERVED2_MASK_SHIFT(reg) (((reg) & CIU_CIU_MFPR_EN_RESERVED2_MASK) >> CIU_CIU_MFPR_EN_RESERVED2_SHIFT)
#define  CIU_CIU_MFPR_EN_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CIU_CIU_MFPR_EN_RESERVED2_MASK) | (((uint32_t)val) << CIU_CIU_MFPR_EN_RESERVED2_SHIFT))

#define  CIU_CIU_MFPR_EN_MFPR_EN_MASK 0x200
#define  CIU_CIU_MFPR_EN_MFPR_EN_SHIFT 9
#define  CIU_CIU_MFPR_EN_MFPR_EN_MASK_SHIFT(reg) (((reg) & CIU_CIU_MFPR_EN_MFPR_EN_MASK) >> CIU_CIU_MFPR_EN_MFPR_EN_SHIFT)
#define  CIU_CIU_MFPR_EN_MFPR_EN_REPLACE_VAL(reg,val) (((reg) & ~CIU_CIU_MFPR_EN_MFPR_EN_MASK) | (((uint32_t)val) << CIU_CIU_MFPR_EN_MFPR_EN_SHIFT))

#define  CIU_CIU_MFPR_EN_RESERVED3_MASK 0x1ff
#define  CIU_CIU_MFPR_EN_RESERVED3_SHIFT 0
#define  CIU_CIU_MFPR_EN_RESERVED3_MASK_SHIFT(reg) (((reg) & CIU_CIU_MFPR_EN_RESERVED3_MASK) >> CIU_CIU_MFPR_EN_RESERVED3_SHIFT)
#define  CIU_CIU_MFPR_EN_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~CIU_CIU_MFPR_EN_RESERVED3_MASK) | (((uint32_t)val) << CIU_CIU_MFPR_EN_RESERVED3_SHIFT))

//====================================================================
//Register: REG_C0 (spare) (REG_C0)
//====================================================================

#define  CIU_REG_C0_RESERVED1_MASK 0xffffffff
#define  CIU_REG_C0_RESERVED1_SHIFT 0
#define  CIU_REG_C0_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_C0_RESERVED1_MASK) >> CIU_REG_C0_RESERVED1_SHIFT)
#define  CIU_REG_C0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_C0_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_C0_RESERVED1_SHIFT))

//====================================================================
//Register: Boot Control register (BOOT_CTRL)
/** \brief This is a read/write register. This is used to control booting of cores from
SRAM/DDR.*/
//====================================================================

#define  CIU_BOOT_CTRL_RESERVED1_MASK 0xffffff00
#define  CIU_BOOT_CTRL_RESERVED1_SHIFT 8
#define  CIU_BOOT_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_BOOT_CTRL_RESERVED1_MASK) >> CIU_BOOT_CTRL_RESERVED1_SHIFT)
#define  CIU_BOOT_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_BOOT_CTRL_RESERVED1_MASK) | (((uint32_t)val) << CIU_BOOT_CTRL_RESERVED1_SHIFT))

#define  CIU_BOOT_CTRL_CPU_BOOT_CTRL_7_MASK 0x80
#define  CIU_BOOT_CTRL_CPU_BOOT_CTRL_7_SHIFT 7
#define  CIU_BOOT_CTRL_CPU_BOOT_CTRL_7_MASK_SHIFT(reg) (((reg) & CIU_BOOT_CTRL_CPU_BOOT_CTRL_7_MASK) >> CIU_BOOT_CTRL_CPU_BOOT_CTRL_7_SHIFT)
#define  CIU_BOOT_CTRL_CPU_BOOT_CTRL_7_REPLACE_VAL(reg,val) (((reg) & ~CIU_BOOT_CTRL_CPU_BOOT_CTRL_7_MASK) | (((uint32_t)val) << CIU_BOOT_CTRL_CPU_BOOT_CTRL_7_SHIFT))

#define  CIU_BOOT_CTRL_DRAGONITE_BOOT_CTRL_MASK 0x40
#define  CIU_BOOT_CTRL_DRAGONITE_BOOT_CTRL_SHIFT 6
#define  CIU_BOOT_CTRL_DRAGONITE_BOOT_CTRL_MASK_SHIFT(reg) (((reg) & CIU_BOOT_CTRL_DRAGONITE_BOOT_CTRL_MASK) >> CIU_BOOT_CTRL_DRAGONITE_BOOT_CTRL_SHIFT)
#define  CIU_BOOT_CTRL_DRAGONITE_BOOT_CTRL_REPLACE_VAL(reg,val) (((reg) & ~CIU_BOOT_CTRL_DRAGONITE_BOOT_CTRL_MASK) | (((uint32_t)val) << CIU_BOOT_CTRL_DRAGONITE_BOOT_CTRL_SHIFT))

#define  CIU_BOOT_CTRL_CPU_BOOT_CTRL_MASK 0x3f
#define  CIU_BOOT_CTRL_CPU_BOOT_CTRL_SHIFT 0
#define  CIU_BOOT_CTRL_CPU_BOOT_CTRL_MASK_SHIFT(reg) (((reg) & CIU_BOOT_CTRL_CPU_BOOT_CTRL_MASK) >> CIU_BOOT_CTRL_CPU_BOOT_CTRL_SHIFT)
#define  CIU_BOOT_CTRL_CPU_BOOT_CTRL_REPLACE_VAL(reg,val) (((reg) & ~CIU_BOOT_CTRL_CPU_BOOT_CTRL_MASK) | (((uint32_t)val) << CIU_BOOT_CTRL_CPU_BOOT_CTRL_SHIFT))

//====================================================================
//Register: CIU Miscellaneous Configuration Control register. (CIU_MISC_CFG_CTL)
/** \brief This is a read write register.Ignore reads from reserved bits.Write 0 to
reserved bits.*/
//====================================================================

#define  CIU_CIU_MISC_CFG_CTL_RESERVED1_MASK 0xfffffe00
#define  CIU_CIU_MISC_CFG_CTL_RESERVED1_SHIFT 9
#define  CIU_CIU_MISC_CFG_CTL_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_CIU_MISC_CFG_CTL_RESERVED1_MASK) >> CIU_CIU_MISC_CFG_CTL_RESERVED1_SHIFT)
#define  CIU_CIU_MISC_CFG_CTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_CIU_MISC_CFG_CTL_RESERVED1_MASK) | (((uint32_t)val) << CIU_CIU_MISC_CFG_CTL_RESERVED1_SHIFT))

#define  CIU_CIU_MISC_CFG_CTL_CA53_PW_STR_MASK 0x100
#define  CIU_CIU_MISC_CFG_CTL_CA53_PW_STR_SHIFT 8
#define  CIU_CIU_MISC_CFG_CTL_CA53_PW_STR_MASK_SHIFT(reg) (((reg) & CIU_CIU_MISC_CFG_CTL_CA53_PW_STR_MASK) >> CIU_CIU_MISC_CFG_CTL_CA53_PW_STR_SHIFT)
#define  CIU_CIU_MISC_CFG_CTL_CA53_PW_STR_REPLACE_VAL(reg,val) (((reg) & ~CIU_CIU_MISC_CFG_CTL_CA53_PW_STR_MASK) | (((uint32_t)val) << CIU_CIU_MISC_CFG_CTL_CA53_PW_STR_SHIFT))

#define  CIU_CIU_MISC_CFG_CTL_CLK_DIV_VAL_MASK 0xe0
#define  CIU_CIU_MISC_CFG_CTL_CLK_DIV_VAL_SHIFT 5
#define  CIU_CIU_MISC_CFG_CTL_CLK_DIV_VAL_MASK_SHIFT(reg) (((reg) & CIU_CIU_MISC_CFG_CTL_CLK_DIV_VAL_MASK) >> CIU_CIU_MISC_CFG_CTL_CLK_DIV_VAL_SHIFT)
#define  CIU_CIU_MISC_CFG_CTL_CLK_DIV_VAL_REPLACE_VAL(reg,val) (((reg) & ~CIU_CIU_MISC_CFG_CTL_CLK_DIV_VAL_MASK) | (((uint32_t)val) << CIU_CIU_MISC_CFG_CTL_CLK_DIV_VAL_SHIFT))

#define  CIU_CIU_MISC_CFG_CTL_RESERVED2_MASK 0x1f
#define  CIU_CIU_MISC_CFG_CTL_RESERVED2_SHIFT 0
#define  CIU_CIU_MISC_CFG_CTL_RESERVED2_MASK_SHIFT(reg) (((reg) & CIU_CIU_MISC_CFG_CTL_RESERVED2_MASK) >> CIU_CIU_MISC_CFG_CTL_RESERVED2_SHIFT)
#define  CIU_CIU_MISC_CFG_CTL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CIU_CIU_MISC_CFG_CTL_RESERVED2_MASK) | (((uint32_t)val) << CIU_CIU_MISC_CFG_CTL_RESERVED2_SHIFT))

//====================================================================
//Register: CIU STATUS REGISTER (CIU_STATUS_REGISTER)
/** \brief This is a read only register.*/
//====================================================================

#define  CIU_CIU_STATUS_REGISTER_RESERVED1_MASK 0xffff0000
#define  CIU_CIU_STATUS_REGISTER_RESERVED1_SHIFT 16
#define  CIU_CIU_STATUS_REGISTER_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_CIU_STATUS_REGISTER_RESERVED1_MASK) >> CIU_CIU_STATUS_REGISTER_RESERVED1_SHIFT)
#define  CIU_CIU_STATUS_REGISTER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_CIU_STATUS_REGISTER_RESERVED1_MASK) | (((uint32_t)val) << CIU_CIU_STATUS_REGISTER_RESERVED1_SHIFT))

#define  CIU_CIU_STATUS_REGISTER_VDDMC_RESTORE_REQ_MASK 0xf000
#define  CIU_CIU_STATUS_REGISTER_VDDMC_RESTORE_REQ_SHIFT 12
#define  CIU_CIU_STATUS_REGISTER_VDDMC_RESTORE_REQ_MASK_SHIFT(reg) (((reg) & CIU_CIU_STATUS_REGISTER_VDDMC_RESTORE_REQ_MASK) >> CIU_CIU_STATUS_REGISTER_VDDMC_RESTORE_REQ_SHIFT)
#define  CIU_CIU_STATUS_REGISTER_VDDMC_RESTORE_REQ_REPLACE_VAL(reg,val) (((reg) & ~CIU_CIU_STATUS_REGISTER_VDDMC_RESTORE_REQ_MASK) | (((uint32_t)val) << CIU_CIU_STATUS_REGISTER_VDDMC_RESTORE_REQ_SHIFT))

#define  CIU_CIU_STATUS_REGISTER_RESERVED2_MASK 0xfff
#define  CIU_CIU_STATUS_REGISTER_RESERVED2_SHIFT 0
#define  CIU_CIU_STATUS_REGISTER_RESERVED2_MASK_SHIFT(reg) (((reg) & CIU_CIU_STATUS_REGISTER_RESERVED2_MASK) >> CIU_CIU_STATUS_REGISTER_RESERVED2_SHIFT)
#define  CIU_CIU_STATUS_REGISTER_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CIU_CIU_STATUS_REGISTER_RESERVED2_MASK) | (((uint32_t)val) << CIU_CIU_STATUS_REGISTER_RESERVED2_SHIFT))

//====================================================================
//Register: REG_D0 (spare) (REG_D0)
//====================================================================

#define  CIU_REG_D0_RESERVED1_MASK 0xffffffff
#define  CIU_REG_D0_RESERVED1_SHIFT 0
#define  CIU_REG_D0_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_D0_RESERVED1_MASK) >> CIU_REG_D0_RESERVED1_SHIFT)
#define  CIU_REG_D0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_D0_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_D0_RESERVED1_SHIFT))

//====================================================================
//Register: REG_D4 (spare) (REG_D4)
//====================================================================

#define  CIU_REG_D4_RESERVED1_MASK 0xffffffff
#define  CIU_REG_D4_RESERVED1_SHIFT 0
#define  CIU_REG_D4_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_D4_RESERVED1_MASK) >> CIU_REG_D4_RESERVED1_SHIFT)
#define  CIU_REG_D4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_D4_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_D4_RESERVED1_SHIFT))

//====================================================================
//Register: REG_D8 (spare) (REG_D8)
//====================================================================

#define  CIU_REG_D8_RESERVED1_MASK 0xffffffff
#define  CIU_REG_D8_RESERVED1_SHIFT 0
#define  CIU_REG_D8_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_D8_RESERVED1_MASK) >> CIU_REG_D8_RESERVED1_SHIFT)
#define  CIU_REG_D8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_D8_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_D8_RESERVED1_SHIFT))

//====================================================================
//Register: REG_DC (spare) (REG_DC)
//====================================================================

#define  CIU_REG_DC_RESERVED1_MASK 0xffffffff
#define  CIU_REG_DC_RESERVED1_SHIFT 0
#define  CIU_REG_DC_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_DC_RESERVED1_MASK) >> CIU_REG_DC_RESERVED1_SHIFT)
#define  CIU_REG_DC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_DC_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_DC_RESERVED1_SHIFT))

//====================================================================
//Register: REG_E0 (spare) (REG_E0)
//====================================================================

#define  CIU_REG_E0_RESERVED1_MASK 0xffffffff
#define  CIU_REG_E0_RESERVED1_SHIFT 0
#define  CIU_REG_E0_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_REG_E0_RESERVED1_MASK) >> CIU_REG_E0_RESERVED1_SHIFT)
#define  CIU_REG_E0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_REG_E0_RESERVED1_MASK) | (((uint32_t)val) << CIU_REG_E0_RESERVED1_SHIFT))

//====================================================================
//Register: Cortex A53 Core 2 Configuration Control Register (A53_CORE_2_CFG_CTL)
/** \brief This register can be configured by WTM to be secure for read and write
access.
This is a read/write register. Ignore reads from reserved bits. Write 0b0
to reserved bits.*/
//====================================================================

#define  CIU_A53_CORE_2_CFG_CTL_RESERVED1_MASK 0xe0000000
#define  CIU_A53_CORE_2_CFG_CTL_RESERVED1_SHIFT 29
#define  CIU_A53_CORE_2_CFG_CTL_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_2_CFG_CTL_RESERVED1_MASK) >> CIU_A53_CORE_2_CFG_CTL_RESERVED1_SHIFT)
#define  CIU_A53_CORE_2_CFG_CTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_2_CFG_CTL_RESERVED1_MASK) | (((uint32_t)val) << CIU_A53_CORE_2_CFG_CTL_RESERVED1_SHIFT))

#define  CIU_A53_CORE_2_CFG_CTL_ARCH_MODE_MASK 0x10000000
#define  CIU_A53_CORE_2_CFG_CTL_ARCH_MODE_SHIFT 28
#define  CIU_A53_CORE_2_CFG_CTL_ARCH_MODE_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_2_CFG_CTL_ARCH_MODE_MASK) >> CIU_A53_CORE_2_CFG_CTL_ARCH_MODE_SHIFT)
#define  CIU_A53_CORE_2_CFG_CTL_ARCH_MODE_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_2_CFG_CTL_ARCH_MODE_MASK) | (((uint32_t)val) << CIU_A53_CORE_2_CFG_CTL_ARCH_MODE_SHIFT))

#define  CIU_A53_CORE_2_CFG_CTL_NMFI_ENABLE_MASK 0x8000000
#define  CIU_A53_CORE_2_CFG_CTL_NMFI_ENABLE_SHIFT 27
#define  CIU_A53_CORE_2_CFG_CTL_NMFI_ENABLE_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_2_CFG_CTL_NMFI_ENABLE_MASK) >> CIU_A53_CORE_2_CFG_CTL_NMFI_ENABLE_SHIFT)
#define  CIU_A53_CORE_2_CFG_CTL_NMFI_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_2_CFG_CTL_NMFI_ENABLE_MASK) | (((uint32_t)val) << CIU_A53_CORE_2_CFG_CTL_NMFI_ENABLE_SHIFT))

#define  CIU_A53_CORE_2_CFG_CTL_NIDEN_MASK 0x4000000
#define  CIU_A53_CORE_2_CFG_CTL_NIDEN_SHIFT 26
#define  CIU_A53_CORE_2_CFG_CTL_NIDEN_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_2_CFG_CTL_NIDEN_MASK) >> CIU_A53_CORE_2_CFG_CTL_NIDEN_SHIFT)
#define  CIU_A53_CORE_2_CFG_CTL_NIDEN_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_2_CFG_CTL_NIDEN_MASK) | (((uint32_t)val) << CIU_A53_CORE_2_CFG_CTL_NIDEN_SHIFT))

#define  CIU_A53_CORE_2_CFG_CTL_SPNIDEN_MASK 0x2000000
#define  CIU_A53_CORE_2_CFG_CTL_SPNIDEN_SHIFT 25
#define  CIU_A53_CORE_2_CFG_CTL_SPNIDEN_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_2_CFG_CTL_SPNIDEN_MASK) >> CIU_A53_CORE_2_CFG_CTL_SPNIDEN_SHIFT)
#define  CIU_A53_CORE_2_CFG_CTL_SPNIDEN_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_2_CFG_CTL_SPNIDEN_MASK) | (((uint32_t)val) << CIU_A53_CORE_2_CFG_CTL_SPNIDEN_SHIFT))

#define  CIU_A53_CORE_2_CFG_CTL_SPIDEN_MASK 0x1000000
#define  CIU_A53_CORE_2_CFG_CTL_SPIDEN_SHIFT 24
#define  CIU_A53_CORE_2_CFG_CTL_SPIDEN_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_2_CFG_CTL_SPIDEN_MASK) >> CIU_A53_CORE_2_CFG_CTL_SPIDEN_SHIFT)
#define  CIU_A53_CORE_2_CFG_CTL_SPIDEN_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_2_CFG_CTL_SPIDEN_MASK) | (((uint32_t)val) << CIU_A53_CORE_2_CFG_CTL_SPIDEN_SHIFT))

#define  CIU_A53_CORE_2_CFG_CTL_RESERVED2_MASK 0xfffe00
#define  CIU_A53_CORE_2_CFG_CTL_RESERVED2_SHIFT 9
#define  CIU_A53_CORE_2_CFG_CTL_RESERVED2_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_2_CFG_CTL_RESERVED2_MASK) >> CIU_A53_CORE_2_CFG_CTL_RESERVED2_SHIFT)
#define  CIU_A53_CORE_2_CFG_CTL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_2_CFG_CTL_RESERVED2_MASK) | (((uint32_t)val) << CIU_A53_CORE_2_CFG_CTL_RESERVED2_SHIFT))

#define  CIU_A53_CORE_2_CFG_CTL_BIGENDINIT_MASK 0x100
#define  CIU_A53_CORE_2_CFG_CTL_BIGENDINIT_SHIFT 8
#define  CIU_A53_CORE_2_CFG_CTL_BIGENDINIT_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_2_CFG_CTL_BIGENDINIT_MASK) >> CIU_A53_CORE_2_CFG_CTL_BIGENDINIT_SHIFT)
#define  CIU_A53_CORE_2_CFG_CTL_BIGENDINIT_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_2_CFG_CTL_BIGENDINIT_MASK) | (((uint32_t)val) << CIU_A53_CORE_2_CFG_CTL_BIGENDINIT_SHIFT))

#define  CIU_A53_CORE_2_CFG_CTL_THUMB_EXCPT_INIT_MASK 0x80
#define  CIU_A53_CORE_2_CFG_CTL_THUMB_EXCPT_INIT_SHIFT 7
#define  CIU_A53_CORE_2_CFG_CTL_THUMB_EXCPT_INIT_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_2_CFG_CTL_THUMB_EXCPT_INIT_MASK) >> CIU_A53_CORE_2_CFG_CTL_THUMB_EXCPT_INIT_SHIFT)
#define  CIU_A53_CORE_2_CFG_CTL_THUMB_EXCPT_INIT_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_2_CFG_CTL_THUMB_EXCPT_INIT_MASK) | (((uint32_t)val) << CIU_A53_CORE_2_CFG_CTL_THUMB_EXCPT_INIT_SHIFT))

#define  CIU_A53_CORE_2_CFG_CTL_RESERVED3_MASK 0x40
#define  CIU_A53_CORE_2_CFG_CTL_RESERVED3_SHIFT 6
#define  CIU_A53_CORE_2_CFG_CTL_RESERVED3_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_2_CFG_CTL_RESERVED3_MASK) >> CIU_A53_CORE_2_CFG_CTL_RESERVED3_SHIFT)
#define  CIU_A53_CORE_2_CFG_CTL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_2_CFG_CTL_RESERVED3_MASK) | (((uint32_t)val) << CIU_A53_CORE_2_CFG_CTL_RESERVED3_SHIFT))

#define  CIU_A53_CORE_2_CFG_CTL_CP15SDISABLE_MASK 0x20
#define  CIU_A53_CORE_2_CFG_CTL_CP15SDISABLE_SHIFT 5
#define  CIU_A53_CORE_2_CFG_CTL_CP15SDISABLE_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_2_CFG_CTL_CP15SDISABLE_MASK) >> CIU_A53_CORE_2_CFG_CTL_CP15SDISABLE_SHIFT)
#define  CIU_A53_CORE_2_CFG_CTL_CP15SDISABLE_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_2_CFG_CTL_CP15SDISABLE_MASK) | (((uint32_t)val) << CIU_A53_CORE_2_CFG_CTL_CP15SDISABLE_SHIFT))

#define  CIU_A53_CORE_2_CFG_CTL_RESERVED4_MASK 0x1e
#define  CIU_A53_CORE_2_CFG_CTL_RESERVED4_SHIFT 1
#define  CIU_A53_CORE_2_CFG_CTL_RESERVED4_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_2_CFG_CTL_RESERVED4_MASK) >> CIU_A53_CORE_2_CFG_CTL_RESERVED4_SHIFT)
#define  CIU_A53_CORE_2_CFG_CTL_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_2_CFG_CTL_RESERVED4_MASK) | (((uint32_t)val) << CIU_A53_CORE_2_CFG_CTL_RESERVED4_SHIFT))

#define  CIU_A53_CORE_2_CFG_CTL_VINITHI_MASK 0x1
#define  CIU_A53_CORE_2_CFG_CTL_VINITHI_SHIFT 0
#define  CIU_A53_CORE_2_CFG_CTL_VINITHI_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_2_CFG_CTL_VINITHI_MASK) >> CIU_A53_CORE_2_CFG_CTL_VINITHI_SHIFT)
#define  CIU_A53_CORE_2_CFG_CTL_VINITHI_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_2_CFG_CTL_VINITHI_MASK) | (((uint32_t)val) << CIU_A53_CORE_2_CFG_CTL_VINITHI_SHIFT))

//====================================================================
//Register: Cortex A53 Core 3 Configuration Control Register (A53_CORE_3_CFG_CTL)
/** \brief This register can be configured by WTM to be secure for read and write
access.
This is a read/write register. Ignore reads from reserved bits. Write 0b0
to reserved bits.*/
//====================================================================

#define  CIU_A53_CORE_3_CFG_CTL_RESERVED1_MASK 0xe0000000
#define  CIU_A53_CORE_3_CFG_CTL_RESERVED1_SHIFT 29
#define  CIU_A53_CORE_3_CFG_CTL_RESERVED1_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_3_CFG_CTL_RESERVED1_MASK) >> CIU_A53_CORE_3_CFG_CTL_RESERVED1_SHIFT)
#define  CIU_A53_CORE_3_CFG_CTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_3_CFG_CTL_RESERVED1_MASK) | (((uint32_t)val) << CIU_A53_CORE_3_CFG_CTL_RESERVED1_SHIFT))

#define  CIU_A53_CORE_3_CFG_CTL_ARCH_MODE_MASK 0x10000000
#define  CIU_A53_CORE_3_CFG_CTL_ARCH_MODE_SHIFT 28
#define  CIU_A53_CORE_3_CFG_CTL_ARCH_MODE_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_3_CFG_CTL_ARCH_MODE_MASK) >> CIU_A53_CORE_3_CFG_CTL_ARCH_MODE_SHIFT)
#define  CIU_A53_CORE_3_CFG_CTL_ARCH_MODE_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_3_CFG_CTL_ARCH_MODE_MASK) | (((uint32_t)val) << CIU_A53_CORE_3_CFG_CTL_ARCH_MODE_SHIFT))

#define  CIU_A53_CORE_3_CFG_CTL_NMFI_ENABLE_MASK 0x8000000
#define  CIU_A53_CORE_3_CFG_CTL_NMFI_ENABLE_SHIFT 27
#define  CIU_A53_CORE_3_CFG_CTL_NMFI_ENABLE_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_3_CFG_CTL_NMFI_ENABLE_MASK) >> CIU_A53_CORE_3_CFG_CTL_NMFI_ENABLE_SHIFT)
#define  CIU_A53_CORE_3_CFG_CTL_NMFI_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_3_CFG_CTL_NMFI_ENABLE_MASK) | (((uint32_t)val) << CIU_A53_CORE_3_CFG_CTL_NMFI_ENABLE_SHIFT))

#define  CIU_A53_CORE_3_CFG_CTL_NIDEN_MASK 0x4000000
#define  CIU_A53_CORE_3_CFG_CTL_NIDEN_SHIFT 26
#define  CIU_A53_CORE_3_CFG_CTL_NIDEN_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_3_CFG_CTL_NIDEN_MASK) >> CIU_A53_CORE_3_CFG_CTL_NIDEN_SHIFT)
#define  CIU_A53_CORE_3_CFG_CTL_NIDEN_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_3_CFG_CTL_NIDEN_MASK) | (((uint32_t)val) << CIU_A53_CORE_3_CFG_CTL_NIDEN_SHIFT))

#define  CIU_A53_CORE_3_CFG_CTL_SPNIDEN_MASK 0x2000000
#define  CIU_A53_CORE_3_CFG_CTL_SPNIDEN_SHIFT 25
#define  CIU_A53_CORE_3_CFG_CTL_SPNIDEN_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_3_CFG_CTL_SPNIDEN_MASK) >> CIU_A53_CORE_3_CFG_CTL_SPNIDEN_SHIFT)
#define  CIU_A53_CORE_3_CFG_CTL_SPNIDEN_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_3_CFG_CTL_SPNIDEN_MASK) | (((uint32_t)val) << CIU_A53_CORE_3_CFG_CTL_SPNIDEN_SHIFT))

#define  CIU_A53_CORE_3_CFG_CTL_SPIDEN_MASK 0x1000000
#define  CIU_A53_CORE_3_CFG_CTL_SPIDEN_SHIFT 24
#define  CIU_A53_CORE_3_CFG_CTL_SPIDEN_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_3_CFG_CTL_SPIDEN_MASK) >> CIU_A53_CORE_3_CFG_CTL_SPIDEN_SHIFT)
#define  CIU_A53_CORE_3_CFG_CTL_SPIDEN_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_3_CFG_CTL_SPIDEN_MASK) | (((uint32_t)val) << CIU_A53_CORE_3_CFG_CTL_SPIDEN_SHIFT))

#define  CIU_A53_CORE_3_CFG_CTL_RESERVED2_MASK 0xfffe00
#define  CIU_A53_CORE_3_CFG_CTL_RESERVED2_SHIFT 9
#define  CIU_A53_CORE_3_CFG_CTL_RESERVED2_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_3_CFG_CTL_RESERVED2_MASK) >> CIU_A53_CORE_3_CFG_CTL_RESERVED2_SHIFT)
#define  CIU_A53_CORE_3_CFG_CTL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_3_CFG_CTL_RESERVED2_MASK) | (((uint32_t)val) << CIU_A53_CORE_3_CFG_CTL_RESERVED2_SHIFT))

#define  CIU_A53_CORE_3_CFG_CTL_BIGENDINIT_MASK 0x100
#define  CIU_A53_CORE_3_CFG_CTL_BIGENDINIT_SHIFT 8
#define  CIU_A53_CORE_3_CFG_CTL_BIGENDINIT_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_3_CFG_CTL_BIGENDINIT_MASK) >> CIU_A53_CORE_3_CFG_CTL_BIGENDINIT_SHIFT)
#define  CIU_A53_CORE_3_CFG_CTL_BIGENDINIT_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_3_CFG_CTL_BIGENDINIT_MASK) | (((uint32_t)val) << CIU_A53_CORE_3_CFG_CTL_BIGENDINIT_SHIFT))

#define  CIU_A53_CORE_3_CFG_CTL_THUMB_EXCPT_INIT_MASK 0x80
#define  CIU_A53_CORE_3_CFG_CTL_THUMB_EXCPT_INIT_SHIFT 7
#define  CIU_A53_CORE_3_CFG_CTL_THUMB_EXCPT_INIT_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_3_CFG_CTL_THUMB_EXCPT_INIT_MASK) >> CIU_A53_CORE_3_CFG_CTL_THUMB_EXCPT_INIT_SHIFT)
#define  CIU_A53_CORE_3_CFG_CTL_THUMB_EXCPT_INIT_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_3_CFG_CTL_THUMB_EXCPT_INIT_MASK) | (((uint32_t)val) << CIU_A53_CORE_3_CFG_CTL_THUMB_EXCPT_INIT_SHIFT))

#define  CIU_A53_CORE_3_CFG_CTL_RESERVED3_MASK 0x40
#define  CIU_A53_CORE_3_CFG_CTL_RESERVED3_SHIFT 6
#define  CIU_A53_CORE_3_CFG_CTL_RESERVED3_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_3_CFG_CTL_RESERVED3_MASK) >> CIU_A53_CORE_3_CFG_CTL_RESERVED3_SHIFT)
#define  CIU_A53_CORE_3_CFG_CTL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_3_CFG_CTL_RESERVED3_MASK) | (((uint32_t)val) << CIU_A53_CORE_3_CFG_CTL_RESERVED3_SHIFT))

#define  CIU_A53_CORE_3_CFG_CTL_CP15SDISABLE_MASK 0x20
#define  CIU_A53_CORE_3_CFG_CTL_CP15SDISABLE_SHIFT 5
#define  CIU_A53_CORE_3_CFG_CTL_CP15SDISABLE_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_3_CFG_CTL_CP15SDISABLE_MASK) >> CIU_A53_CORE_3_CFG_CTL_CP15SDISABLE_SHIFT)
#define  CIU_A53_CORE_3_CFG_CTL_CP15SDISABLE_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_3_CFG_CTL_CP15SDISABLE_MASK) | (((uint32_t)val) << CIU_A53_CORE_3_CFG_CTL_CP15SDISABLE_SHIFT))

#define  CIU_A53_CORE_3_CFG_CTL_RESERVED4_MASK 0x1e
#define  CIU_A53_CORE_3_CFG_CTL_RESERVED4_SHIFT 1
#define  CIU_A53_CORE_3_CFG_CTL_RESERVED4_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_3_CFG_CTL_RESERVED4_MASK) >> CIU_A53_CORE_3_CFG_CTL_RESERVED4_SHIFT)
#define  CIU_A53_CORE_3_CFG_CTL_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_3_CFG_CTL_RESERVED4_MASK) | (((uint32_t)val) << CIU_A53_CORE_3_CFG_CTL_RESERVED4_SHIFT))

#define  CIU_A53_CORE_3_CFG_CTL_VINITHI_MASK 0x1
#define  CIU_A53_CORE_3_CFG_CTL_VINITHI_SHIFT 0
#define  CIU_A53_CORE_3_CFG_CTL_VINITHI_MASK_SHIFT(reg) (((reg) & CIU_A53_CORE_3_CFG_CTL_VINITHI_MASK) >> CIU_A53_CORE_3_CFG_CTL_VINITHI_SHIFT)
#define  CIU_A53_CORE_3_CFG_CTL_VINITHI_REPLACE_VAL(reg,val) (((reg) & ~CIU_A53_CORE_3_CFG_CTL_VINITHI_MASK) | (((uint32_t)val) << CIU_A53_CORE_3_CFG_CTL_VINITHI_SHIFT))

#endif // CIU
