 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _AP_APB_REGSTRUCTS_H_
#define _AP_APB_REGSTRUCTS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: AP APB Top (AP_APB)
/** \brief Register Descriptions for AP APB superblock*/
//
//====================================================================

//====================================================================
//
//Register File: I2C1 Registers (I2C1)
//
//====================================================================

typedef struct I2C1_REGS_s
{
  volatile uint32_t TWSI_IBMR;  ///< 0x0 [R]: TWSI Bus Monitor Register
  volatile uint32_t reserved0;
  volatile uint32_t TWSI_IDBR;  ///< 0x8 [R/W]: TWSI Data Buffer Register
  volatile uint32_t reserved1;
  volatile uint32_t TWSI_ICR;  ///< 0x10 [R/W]: TWSI Control Register
  volatile uint32_t reserved2;
  volatile uint32_t TWSI_ISR;  ///< 0x18 [R/W]: TWSI Status Register
  volatile uint32_t reserved3;
  volatile uint32_t TWSI_ISAR;  ///< 0x20 [R/W]: TWSI Slave Address Register
  volatile uint32_t reserved4;
  volatile uint32_t TWSI_ILCR;  ///< 0x28 [R/W]: TWSI Load Count Register
  volatile uint32_t reserved5;
  volatile uint32_t TWSI_IWCR;  ///< 0x30 [R/W]: TWSI Wait Count Register
  volatile uint32_t reserved6[3];
  volatile uint32_t TWSI_WFIFO;  ///< 0x40 [W]: TWSI Write FIFO Register
  volatile uint32_t TWSI_WFIFO_WPTR;  ///< 0x44 [R/W]: TWSI Write FIFO Write Pointer Register
  volatile uint32_t TWSI_WFIFO_RPTR;  ///< 0x48 [R/W]: TWSI Write FIFO Read Pointer Register
  volatile uint32_t reserved7;
  volatile uint32_t TWSI_RFIFO;  ///< 0x50 [R]: TWSI Read FIFO Register
  volatile uint32_t TWSI_RFIFO_WPTR;  ///< 0x54 [R/W]: TWSI Read FIFO Write Pointer Register
  volatile uint32_t TWSI_RFIFO_RPTR;  ///< 0x58 [R/W]: TWSI Read FIFO Read Pointer Register
  volatile uint32_t reserved8;
  volatile uint32_t TWSI_FIFO_TSHLD;  ///< 0x60 [R/W]: TWSI FIFO Threshold Register
  volatile uint32_t reserved9[3];
  volatile uint32_t REV0;  ///< 0x70 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x74 [R]: IP Tagging Revision 1
} I2C1_REGS_t;

//====================================================================
//
//Register File: One Wire Registers (OWI)
/** \brief Registers for the 1-Wire Bus Master block*/
//
//====================================================================

typedef struct OWI_REGS_s
{
  volatile uint32_t W1CMDR;  ///< 0x0 [R/W]: OneWire Command Register
  volatile uint32_t W1TRR;  ///< 0x4 [R/W]: OneWire Transmit/Receive Buffer
  volatile uint32_t W1INTR;  ///< 0x8 [R]: OneWire Interrupt Register
  volatile uint32_t W1IER;  ///< 0xc [R/W]: OneWire Interrupt Enable Register
  volatile uint32_t reserved0;
  volatile uint32_t W1CTRL;  ///< 0x14 [R/W]: OneWire Control Register
} OWI_REGS_t;

//====================================================================
//
//Register File: JTAG SW Registers (JTAG_SW)
//
//====================================================================

typedef struct JTAG_SW_REGS_s
{
  volatile uint32_t JTAGSW_EN;  ///< 0x0 [W]: Enable Software JTAG Register
  volatile uint32_t JTAGSW_CTRL;  ///< 0x4 [W]: Software JTAG Control Register
  volatile uint32_t JTAGSW_DATA;  ///< 0x8 [R]: Software JTAG Serial Data Register
  volatile uint32_t reserved0;
  volatile uint32_t JTAGSW_REV0;  ///< 0x10 [R]: Software JTAG Revision 0 Register
  volatile uint32_t JTAGSW_REV1;  ///< 0x14 [R]: Software JTAG Revision 1 Register
} JTAG_SW_REGS_t;

//====================================================================
//
//Register File: TIMEBASE2 Registers (TIMEBASE2)
/** \brief TIMEBASE2 block is used to generate timing periods that are useful to other blocks in the system, such as the APB Timers/watchdog, AUXADC, Engine Control, DDAC Audio, and DC Motor. By using a common configurable timebase, each block is not burdened with programmable dividers. <BR>
   TIMEBASE2 is programmable to generate desired period timing given an input reference clock. The reference clock can be fixed to a stable time standard such as a 25MHz crystal oscillator clock. <BR>
   TIMEBASE2 provides an APB register interface and output timebases, both in the bus clk domain. There are six output timebases provided - 1us, 10us, 100us, 1ms, 10ms, 100ms. Each output timebase is a train of single clock cycle pulses, where the start of each pulse is separated by the timebase perioud (1us, 10us, etc).*/
//
//====================================================================

typedef struct TIMEBASE2_REGS_s
{
  volatile uint32_t TCR;  ///< 0x0 [R/W]: Timebase Configuration Register
  volatile uint32_t TTR;  ///< 0x4 [R/W]: Timebase Testing Register
  volatile uint32_t REV0;  ///< 0x8 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0xc [R]: IP Tagging Revision 1
} TIMEBASE2_REGS_t;

//====================================================================
//
//Register File: Timers Registers (Timers)
//
//====================================================================

typedef struct TIMERS_REGS_s
{
  volatile uint32_t TMR_CCR;  ///< 0x0 [R/W]: Timer Clock Control Register
  volatile uint32_t TMR_Tn_Mm0;  ///< 0x4 [R/W]: Timer Match Registers (Instance 1 of 9)
  volatile uint32_t TMR_Tn_Mm1;  ///< 0x8 [R/W]: Timer Match Registers (Instance 2 of 9)
  volatile uint32_t TMR_Tn_Mm2;  ///< 0xc [R/W]: Timer Match Registers (Instance 3 of 9)
  volatile uint32_t TMR_Tn_Mm3;  ///< 0x10 [R/W]: Timer Match Registers (Instance 4 of 9)
  volatile uint32_t TMR_Tn_Mm4;  ///< 0x14 [R/W]: Timer Match Registers (Instance 5 of 9)
  volatile uint32_t TMR_Tn_Mm5;  ///< 0x18 [R/W]: Timer Match Registers (Instance 6 of 9)
  volatile uint32_t TMR_Tn_Mm6;  ///< 0x1c [R/W]: Timer Match Registers (Instance 7 of 9)
  volatile uint32_t TMR_Tn_Mm7;  ///< 0x20 [R/W]: Timer Match Registers (Instance 8 of 9)
  volatile uint32_t TMR_Tn_Mm8;  ///< 0x24 [R/W]: Timer Match Registers (Instance 9 of 9)
  volatile uint32_t TMR_CRn0;  ///< 0x28 [R]: Timer Count Registers (Instance 1 of 3)
  volatile uint32_t TMR_CRn1;  ///< 0x2c [R]: Timer Count Registers (Instance 2 of 3)
  volatile uint32_t TMR_CRn2;  ///< 0x30 [R]: Timer Count Registers (Instance 3 of 3)
  volatile uint32_t TMR_SRn0;  ///< 0x34 [R]: Timer Status Registers (Instance 1 of 3)
  volatile uint32_t TMR_SRn1;  ///< 0x38 [R]: Timer Status Registers (Instance 2 of 3)
  volatile uint32_t TMR_SRn2;  ///< 0x3c [R]: Timer Status Registers (Instance 3 of 3)
  volatile uint32_t TMR_IERn0;  ///< 0x40 [R/W]: Timer Interrupt Enable Registers (Instance 1 of 3)
  volatile uint32_t TMR_IERn1;  ///< 0x44 [R/W]: Timer Interrupt Enable Registers (Instance 2 of 3)
  volatile uint32_t TMR_IERn2;  ///< 0x48 [R/W]: Timer Interrupt Enable Registers (Instance 3 of 3)
  volatile uint32_t TMR_PLVRn0;  ///< 0x4c [R/W]: Timer Preload Value Registers (Instance 1 of 3)
  volatile uint32_t TMR_PLVRn1;  ///< 0x50 [R/W]: Timer Preload Value Registers (Instance 2 of 3)
  volatile uint32_t TMR_PLVRn2;  ///< 0x54 [R/W]: Timer Preload Value Registers (Instance 3 of 3)
  volatile uint32_t TMR_PLCRn0;  ///< 0x58 [R/W]: Timer Preload Control Registers (Instance 1 of 3)
  volatile uint32_t TMR_PLCRn1;  ///< 0x5c [R/W]: Timer Preload Control Registers (Instance 2 of 3)
  volatile uint32_t TMR_PLCRn2;  ///< 0x60 [R/W]: Timer Preload Control Registers (Instance 3 of 3)
  volatile uint32_t TMR_WMER;  ///< 0x64 [R/W]: Timers Watchdog Match Enable Register
  volatile uint32_t TMR_WMR;  ///< 0x68 [R/W]: Timers Watchdog Match Register
  volatile uint32_t TMR_WVR;  ///< 0x6c [R]: Timers Watchdog Value Register
  volatile uint32_t TMR_WSR;  ///< 0x70 [R/W]: Timers Watchdog Status Register
  volatile uint32_t TMR_ICRn0;  ///< 0x74 [W]: Timer Interrupt Clear Registers (Instance 1 of 3)
  volatile uint32_t TMR_ICRn1;  ///< 0x78 [W]: Timer Interrupt Clear Registers (Instance 2 of 3)
  volatile uint32_t TMR_ICRn2;  ///< 0x7c [W]: Timer Interrupt Clear Registers (Instance 3 of 3)
  volatile uint32_t TMR_WICR;  ///< 0x80 [W]: Timers Watchdog Interrupt Clear Register
  volatile uint32_t TMR_CER;  ///< 0x84 [R/W]: Timers Count Enable Register
  volatile uint32_t TMR_CMR;  ///< 0x88 [R/W]: Timers Count Mode Register
  volatile uint32_t TMR_ILRn0;  ///< 0x8c [R/W]: Timer Interrupt Length Registers (Instance 1 of 3)
  volatile uint32_t TMR_ILRn1;  ///< 0x90 [R/W]: Timer Interrupt Length Registers (Instance 2 of 3)
  volatile uint32_t TMR_ILRn2;  ///< 0x94 [R/W]: Timer Interrupt Length Registers (Instance 3 of 3)
  volatile uint32_t TMR_WCR;  ///< 0x98 [W]: Timers Watchdog Counter Reset Register
  volatile uint32_t TMR_WFAR;  ///< 0x9c [W]: Timers Watchdog First Access Register
  volatile uint32_t TMR_WSAR;  ///< 0xa0 [W]: Timers Watchdog Second Access Register
  volatile uint32_t TMR_CVWRn0;  ///< 0xa4 [R/W]: Timer Counters Value Write for Read Request Register (Instance 1 of 3)
  volatile uint32_t TMR_CVWRn1;  ///< 0xa8 [R/W]: Timer Counters Value Write for Read Request Register (Instance 2 of 3)
  volatile uint32_t TMR_CVWRn2;  ///< 0xac [R/W]: Timer Counters Value Write for Read Request Register (Instance 3 of 3)
  volatile uint32_t TMR_CRSR;  ///< 0xb0 [R/W]: Timer Counters restart register
  volatile uint32_t TMR_OFCR;  ///< 0xb4 [R/W]: Timers On the Fly Configuration Register
  volatile uint32_t REV0;  ///< 0xb8 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0xbc [R]: IP Tagging Revision 1
} TIMERS_REGS_t;

//====================================================================
//
//Register File: AIB Access Registers (AIBAccess)
//
//====================================================================

typedef struct AIBACCESS_REGS_s
{
  volatile uint32_t APBC_ASFAR;  ///< 0x0 [R/W]: AIB Code Locked First Access Register
  volatile uint32_t APBC_ASSAR;  ///< 0x4 [R/W]: AIB Code Locked Second Access Register
} AIBACCESS_REGS_t;

//====================================================================
//
//Register File: UART4 Registers (UART4)
//
//====================================================================

typedef struct UART4_REGS_s
{
 union {
  volatile uint32_t UART_RBR;  ///< 0x0 [R]: Receive Buffer Register
  volatile uint32_t UART_THR;  ///< 0x0 [W]: Transmit Holding Register
  volatile uint32_t UART_DLL;  ///< 0x0 [R/W]: Divisor Latch Low Byte Register
 } union0;
 union {
  volatile uint32_t UART_IER;  ///< 0x4 [R/W]: Interrupt Enable Register
  volatile uint32_t UART_DLH;  ///< 0x4 [R/W]: Divisor Latch High Byte Register
 } union1;
 union {
  volatile uint32_t UART_IIR;  ///< 0x8 [R]: Interrupt Identification Register
  volatile uint32_t UART_FCR;  ///< 0x8 [W]: FIFO Control Register
 } union2;
  volatile uint32_t UART_LCR;  ///< 0xc [R/W]: Line Control Register
  volatile uint32_t UART_MCR;  ///< 0x10 [R/W]: Modem Control Register
  volatile uint32_t UART_LSR;  ///< 0x14 [R]: Line Status Register
  volatile uint32_t UART_MSR;  ///< 0x18 [R]: Modem Status Register
  volatile uint32_t UART_SCR;  ///< 0x1c [R/W]: Scratchpad Register
  volatile uint32_t UART_ISR;  ///< 0x20 [R/W]: Infrared Selection Register
  volatile uint32_t UART_FOR;  ///< 0x24 [R]: Receive FIFO Occupancy Register
  volatile uint32_t UART_ABR;  ///< 0x28 [R/W]: Auto-Baud Control Register
  volatile uint32_t UART_ACR;  ///< 0x2c [R]: Auto-Baud Count Register
  volatile uint32_t REV0;  ///< 0x30 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x34 [R]: IP Tagging Revision 1
} UART4_REGS_t;

//====================================================================
//
//Register File: UART2 Registers (UART2)
//
//====================================================================

typedef struct UART2_REGS_s
{
 union {
  volatile uint32_t UART_RBR;  ///< 0x0 [R]: Receive Buffer Register
  volatile uint32_t UART_THR;  ///< 0x0 [W]: Transmit Holding Register
  volatile uint32_t UART_DLL;  ///< 0x0 [R/W]: Divisor Latch Low Byte Register
 } union0;
 union {
  volatile uint32_t UART_IER;  ///< 0x4 [R/W]: Interrupt Enable Register
  volatile uint32_t UART_DLH;  ///< 0x4 [R/W]: Divisor Latch High Byte Register
 } union1;
 union {
  volatile uint32_t UART_IIR;  ///< 0x8 [R]: Interrupt Identification Register
  volatile uint32_t UART_FCR;  ///< 0x8 [W]: FIFO Control Register
 } union2;
  volatile uint32_t UART_LCR;  ///< 0xc [R/W]: Line Control Register
  volatile uint32_t UART_MCR;  ///< 0x10 [R/W]: Modem Control Register
  volatile uint32_t UART_LSR;  ///< 0x14 [R]: Line Status Register
  volatile uint32_t UART_MSR;  ///< 0x18 [R]: Modem Status Register
  volatile uint32_t UART_SCR;  ///< 0x1c [R/W]: Scratchpad Register
  volatile uint32_t UART_ISR;  ///< 0x20 [R/W]: Infrared Selection Register
  volatile uint32_t UART_FOR;  ///< 0x24 [R]: Receive FIFO Occupancy Register
  volatile uint32_t UART_ABR;  ///< 0x28 [R/W]: Auto-Baud Control Register
  volatile uint32_t UART_ACR;  ///< 0x2c [R]: Auto-Baud Count Register
  volatile uint32_t REV0;  ///< 0x30 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x34 [R]: IP Tagging Revision 1
} UART2_REGS_t;

//====================================================================
//
//Register File: UART3 Registers (UART3)
//
//====================================================================

typedef struct UART3_REGS_s
{
 union {
  volatile uint32_t UART_RBR;  ///< 0x0 [R]: Receive Buffer Register
  volatile uint32_t UART_THR;  ///< 0x0 [W]: Transmit Holding Register
  volatile uint32_t UART_DLL;  ///< 0x0 [R/W]: Divisor Latch Low Byte Register
 } union0;
 union {
  volatile uint32_t UART_IER;  ///< 0x4 [R/W]: Interrupt Enable Register
  volatile uint32_t UART_DLH;  ///< 0x4 [R/W]: Divisor Latch High Byte Register
 } union1;
 union {
  volatile uint32_t UART_IIR;  ///< 0x8 [R]: Interrupt Identification Register
  volatile uint32_t UART_FCR;  ///< 0x8 [W]: FIFO Control Register
 } union2;
  volatile uint32_t UART_LCR;  ///< 0xc [R/W]: Line Control Register
  volatile uint32_t UART_MCR;  ///< 0x10 [R/W]: Modem Control Register
  volatile uint32_t UART_LSR;  ///< 0x14 [R]: Line Status Register
  volatile uint32_t UART_MSR;  ///< 0x18 [R]: Modem Status Register
  volatile uint32_t UART_SCR;  ///< 0x1c [R/W]: Scratchpad Register
  volatile uint32_t UART_ISR;  ///< 0x20 [R/W]: Infrared Selection Register
  volatile uint32_t UART_FOR;  ///< 0x24 [R]: Receive FIFO Occupancy Register
  volatile uint32_t UART_ABR;  ///< 0x28 [R/W]: Auto-Baud Control Register
  volatile uint32_t UART_ACR;  ///< 0x2c [R]: Auto-Baud Count Register
  volatile uint32_t REV0;  ///< 0x30 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x34 [R]: IP Tagging Revision 1
} UART3_REGS_t;

//====================================================================
//
//Register File: GPIO Registers (GPIO)
/** \brief Register Descriptions for the GPIO banks*/
//
//====================================================================

//====================================================================
//
//Register File: Pad Edge Registers (PadEdge)
/** \brief (rev 0 . 1 . 0 . 0)
    Register Descriptions for the Pad Edge Detect banks*/
//
//====================================================================

typedef struct PADEDGE_REGS_s
{
  volatile uint32_t reserved0[8];
  volatile uint32_t REV0;  ///< 0x20 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x24 [R]: IP Tagging Revision 1
} PADEDGE_REGS_t;

//====================================================================
//
//Register File: IPC Registers (Instance 1 of 2) (IPC0)
/** \brief Register Descriptions for the IPC (rev 0 . 3 . 2 . 0)*/
//
//====================================================================

typedef struct IPC0_REGS_s
{
  volatile uint32_t IPC_ISRR;  ///< 0x0 [R]: IPC_ISRR
  volatile uint32_t IPC_WDR_0;  ///< 0x4 [W]: Write Data Register 0
  volatile uint32_t IPC_WDR_1;  ///< 0x8 [W]: Write Data Register 1
  volatile uint32_t IPC_ISRW;  ///< 0xc [W]: Interrupt Set Register Write
  volatile uint32_t IPC_ICR;  ///< 0x10 [W]: Interrupt Clear Register
  volatile uint32_t IPC_IIR;  ///< 0x14 [R]: Interrupt Identification Register
  volatile uint32_t IPC_RDR_0;  ///< 0x18 [R]: Read Data Register 0
  volatile uint32_t IPC_RDR_1;  ///< 0x1c [R]: Read Data Register 1
  volatile uint32_t IPC_MAJ_MID_REV;  ///< 0x20 [R]: Revision (Major and Mid) Register
  volatile uint32_t IPC_CFG_REV;  ///< 0x24 [R]: Revision (Configuration) Register
  volatile uint32_t IPC_DUMMY;  ///< 0x28 [W]: Dummy Register
} IPC0_REGS_t;

//====================================================================
//
//Register File: IPC Registers (Instance 2 of 2) (IPC1)
/** \brief Register Descriptions for the IPC (rev 0 . 3 . 2 . 0)*/
//
//====================================================================

typedef struct IPC1_REGS_s
{
  volatile uint32_t IPC_ISRR;  ///< 0x0 [R]: IPC_ISRR
  volatile uint32_t IPC_WDR_0;  ///< 0x4 [W]: Write Data Register 0
  volatile uint32_t IPC_WDR_1;  ///< 0x8 [W]: Write Data Register 1
  volatile uint32_t IPC_ISRW;  ///< 0xc [W]: Interrupt Set Register Write
  volatile uint32_t IPC_ICR;  ///< 0x10 [W]: Interrupt Clear Register
  volatile uint32_t IPC_IIR;  ///< 0x14 [R]: Interrupt Identification Register
  volatile uint32_t IPC_RDR_0;  ///< 0x18 [R]: Read Data Register 0
  volatile uint32_t IPC_RDR_1;  ///< 0x1c [R]: Read Data Register 1
  volatile uint32_t IPC_MAJ_MID_REV;  ///< 0x20 [R]: Revision (Major and Mid) Register
  volatile uint32_t IPC_CFG_REV;  ///< 0x24 [R]: Revision (Configuration) Register
  volatile uint32_t IPC_DUMMY;  ///< 0x28 [W]: Dummy Register
} IPC1_REGS_t;

//====================================================================
//
//Register File: APB Config Registers (apb_config)
//
//====================================================================

typedef struct APB_CONFIG_REGS_s
{
  volatile uint32_t DFTISLD_REV0;  ///< 0x0 [R]: DFT Island IP Tagging REV0
  volatile uint32_t DFTISLD_REV1;  ///< 0x4 [R]: DFT Island IP Tagging REV1
  volatile uint32_t NDSMC_REV0;  ///< 0x8 [R]: NDSMC IP Tagging REV0
  volatile uint32_t NDSMC_REV1;  ///< 0xc [R]: NDSMC IP Tagging REV1
  volatile uint32_t USB3DEV_REV0;  ///< 0x10 [R]: USB3DEV IP Tagging REV0
  volatile uint32_t USB3DEV_REV1;  ///< 0x14 [R]: USB3DEV IP Tagging REV1
  volatile uint32_t USB3HOST_REV0;  ///< 0x18 [R]: USB3HOST IP Tagging REV0
  volatile uint32_t USB3HOST_REV1;  ///< 0x1c [R]: USB3HOST IP Tagging REV1
  volatile uint32_t USB2HOST_REV0;  ///< 0x20 [R]: USB2HOST IP Tagging REV0
  volatile uint32_t USB2HOST_REV1;  ///< 0x24 [R]: USB2HOST IP Tagging REV1
  volatile uint32_t USB2DEVHOST_REV0;  ///< 0x28 [R]: USB2DEVHOST IP Tagging REV0
  volatile uint32_t USB2DEVHOST_REV1;  ///< 0x2c [R]: USB2DEVHOST IP Tagging REV1
  volatile uint32_t USB2TOP_REV0;  ///< 0x30 [R]: USB2TOP IP Tagging REV0
  volatile uint32_t USB2TOP_REV1;  ///< 0x34 [R]: USB2TOP IP Tagging REV1
  volatile uint32_t SATA_REV0;  ///< 0x38 [R]: SATA IP Tagging REV0
  volatile uint32_t SATA_REV1;  ///< 0x3c [R]: SATA IP Tagging REV1
  volatile uint32_t SQU_REV0;  ///< 0x40 [R]: SQU IP Tagging REV0
  volatile uint32_t SQU_REV1;  ///< 0x44 [R]: SQU IP Tagging REV1
  volatile uint32_t GC400_REV0;  ///< 0x48 [R]: GC400 IP Tagging REV0
  volatile uint32_t GC400_REV1;  ///< 0x4c [R]: GC400 IP Tagging REV1
  volatile uint32_t PDMA_REV0;  ///< 0x50 [R]: PDMA IP Tagging REV0
  volatile uint32_t PDMA_REV1;  ///< 0x54 [R]: PDMA IP Tagging REV1
  volatile uint32_t USB3HnD;  ///< 0x58 [R/W]: USB3_Host_Device
  volatile uint32_t strap_in;  ///< 0x5c [R]: Strap_in
  volatile uint32_t Fuse_Bank0_R0;  ///< 0x60 [R]: Fuse_Bank0_R0
  volatile uint32_t Fuse_Bank0_R1;  ///< 0x64 [R]: Fuse_Bank0_R1
  volatile uint32_t Fuse_Bank0_R2;  ///< 0x68 [R]: Fuse_Bank0_R2
  volatile uint32_t Fuse_Bank0_R3;  ///< 0x6c [R]: Fuse_Bank0_R3
  volatile uint32_t Fuse_Bank0_R4;  ///< 0x70 [R]: Fuse_Bank0_R4
  volatile uint32_t Fuse_Bank0_R5;  ///< 0x74 [R]: Fuse_Bank0_R5
  volatile uint32_t Fuse_Bank0_R6;  ///< 0x78 [R]: Fuse_Bank0_R6
  volatile uint32_t Fuse_Bank0_R7;  ///< 0x7c [R]: Fuse_Bank0_R7
  volatile uint32_t Fuse_Bank0_R8;  ///< 0x80 [R]: Fuse_Bank0_R8
  volatile uint32_t Fuse_Bank1_R0;  ///< 0x84 [R]: Fuse_Bank1_R0
  volatile uint32_t Fuse_Bank1_R1;  ///< 0x88 [R]: Fuse_Bank1_R1
  volatile uint32_t Fuse_Bank1_R2;  ///< 0x8c [R]: Fuse_Bank1_R2
  volatile uint32_t Fuse_Bank1_R3;  ///< 0x90 [R]: Fuse_Bank1_R3
  volatile uint32_t Fuse_Bank1_R4;  ///< 0x94 [R]: Fuse_Bank1_R4
  volatile uint32_t Fuse_Bank1_R5;  ///< 0x98 [R]: Fuse_Bank1_R5
  volatile uint32_t Fuse_Bank1_R6;  ///< 0x9c [R]: Fuse_Bank1_R6
  volatile uint32_t Fuse_Bank1_R7;  ///< 0xa0 [R]: Fuse_Bank1_R7
  volatile uint32_t Fuse_Bank1_R8;  ///< 0xa4 [R]: Fuse_Bank1_R8
  volatile uint32_t Fuse_Bank2_R0;  ///< 0xa8 [R]: Fuse_Bank2_R0
  volatile uint32_t Fuse_Bank2_R1;  ///< 0xac [R]: Fuse_Bank2_R1
  volatile uint32_t Fuse_Bank2_R2;  ///< 0xb0 [R]: Fuse_Bank2_R2
  volatile uint32_t Fuse_Bank2_R3;  ///< 0xb4 [R]: Fuse_Bank2_R3
  volatile uint32_t Fuse_Bank2_R4;  ///< 0xb8 [R]: Fuse_Bank2_R4
  volatile uint32_t Fuse_Bank2_R5;  ///< 0xbc [R]: Fuse_Bank2_R5
  volatile uint32_t Fuse_Bank2_R6;  ///< 0xc0 [R]: Fuse_Bank2_R6
  volatile uint32_t Fuse_Bank2_R7;  ///< 0xc4 [R]: Fuse_Bank2_R7
  volatile uint32_t Fuse_Bank2_R8;  ///< 0xc8 [R]: Fuse_Bank2_R8
  volatile uint32_t Fuse_Bank3_R0;  ///< 0xcc [R]: Fuse_Bank3_R0
  volatile uint32_t Fuse_Bank3_R1;  ///< 0xd0 [R]: Fuse_Bank3_R1
  volatile uint32_t Fuse_Bank3_R2;  ///< 0xd4 [R]: Fuse_Bank3_R2
  volatile uint32_t Fuse_Bank3_R3;  ///< 0xd8 [R]: Fuse_Bank3_R3
  volatile uint32_t Fuse_Bank3_R4;  ///< 0xdc [R]: Fuse_Bank3_R4
  volatile uint32_t Fuse_Bank3_R5;  ///< 0xe0 [R]: Fuse_Bank3_R5
  volatile uint32_t Fuse_Bank3_R6;  ///< 0xe4 [R]: Fuse_Bank3_R6
  volatile uint32_t Fuse_Bank3_R7;  ///< 0xe8 [R]: Fuse_Bank3_R7
  volatile uint32_t Fuse_Bank3_R8;  ///< 0xec [R]: Fuse_Bank3_R8
  volatile uint32_t Fuse_Bank4_R0;  ///< 0xf0 [R]: Fuse_Bank4_R0
  volatile uint32_t Fuse_Bank4_R1;  ///< 0xf4 [R]: Fuse_Bank4_R1
  volatile uint32_t Fuse_Bank4_R2;  ///< 0xf8 [R]: Fuse_Bank4_R2
  volatile uint32_t Fuse_Bank4_R3;  ///< 0xfc [R]: Fuse_Bank4_R3
  volatile uint32_t Fuse_Bank4_R4;  ///< 0x100 [R]: Fuse_Bank4_R4
  volatile uint32_t Fuse_Bank4_R5;  ///< 0x104 [R]: Fuse_Bank4_R5
  volatile uint32_t Fuse_Bank4_R6;  ///< 0x108 [R]: Fuse_Bank4_R6
  volatile uint32_t Fuse_Bank4_R7;  ///< 0x10c [R]: Fuse_Bank4_R7
  volatile uint32_t Fuse_Bank4_R8;  ///< 0x110 [R]: Fuse_Bank4_R8
  volatile uint32_t Fuse_Bank5_R0;  ///< 0x114 [R]: Fuse_Bank5_R0
  volatile uint32_t Fuse_Bank5_R1;  ///< 0x118 [R]: Fuse_Bank5_R1
  volatile uint32_t Fuse_Bank5_R2;  ///< 0x11c [R]: Fuse_Bank5_R2
  volatile uint32_t Fuse_Bank5_R3;  ///< 0x120 [R]: Fuse_Bank5_R3
  volatile uint32_t Fuse_Bank5_R4;  ///< 0x124 [R]: Fuse_Bank5_R4
  volatile uint32_t Fuse_Bank5_R5;  ///< 0x128 [R]: Fuse_Bank5_R5
  volatile uint32_t Fuse_Bank5_R6;  ///< 0x12c [R]: Fuse_Bank5_R6
  volatile uint32_t Fuse_Bank5_R7;  ///< 0x130 [R]: Fuse_Bank5_R7
  volatile uint32_t Fuse_Bank5_R8;  ///< 0x134 [R]: Fuse_Bank5_R8
  volatile uint32_t Fuse_Bank6_R0;  ///< 0x138 [R]: Fuse_Bank6_R0
  volatile uint32_t Fuse_Bank6_R1;  ///< 0x13c [R]: Fuse_Bank6_R1
  volatile uint32_t Fuse_Bank6_R2;  ///< 0x140 [R]: Fuse_Bank6_R2
  volatile uint32_t Fuse_Bank6_R3;  ///< 0x144 [R]: Fuse_Bank6_R3
  volatile uint32_t Fuse_Bank6_R4;  ///< 0x148 [R]: Fuse_Bank6_R4
  volatile uint32_t Fuse_Bank6_R5;  ///< 0x14c [R]: Fuse_Bank6_R5
  volatile uint32_t Fuse_Bank6_R6;  ///< 0x150 [R]: Fuse_Bank6_R6
  volatile uint32_t Fuse_Bank6_R7;  ///< 0x154 [R]: Fuse_Bank6_R7
  volatile uint32_t Fuse_Bank6_R8;  ///< 0x158 [R]: Fuse_Bank6_R8
  volatile uint32_t Fuse_Bank7_R0;  ///< 0x15c [R]: Fuse_Bank7_R0
  volatile uint32_t Fuse_Bank7_R1;  ///< 0x160 [R]: Fuse_Bank7_R1
  volatile uint32_t Fuse_Bank7_R2;  ///< 0x164 [R]: Fuse_Bank7_R2
  volatile uint32_t Fuse_Bank7_R3;  ///< 0x168 [R]: Fuse_Bank7_R3
  volatile uint32_t Fuse_Bank7_R4;  ///< 0x16c [R]: Fuse_Bank7_R4
  volatile uint32_t Fuse_Bank7_R5;  ///< 0x170 [R]: Fuse_Bank7_R5
  volatile uint32_t Fuse_Bank7_R6;  ///< 0x174 [R]: Fuse_Bank7_R6
  volatile uint32_t Fuse_Bank7_R7;  ///< 0x178 [R]: Fuse_Bank7_R7
  volatile uint32_t Fuse_Bank7_R8;  ///< 0x17c [R]: Fuse_Bank7_R8
  volatile uint32_t Fuse_Bank8_R0;  ///< 0x180 [R]: Fuse_Bank8_R0
  volatile uint32_t Fuse_Bank8_R1;  ///< 0x184 [R]: Fuse_Bank8_R1
  volatile uint32_t Fuse_Bank8_R2;  ///< 0x188 [R]: Fuse_Bank8_R2
  volatile uint32_t Fuse_Bank8_R3;  ///< 0x18c [R]: Fuse_Bank8_R3
  volatile uint32_t Fuse_Bank8_R4;  ///< 0x190 [R]: Fuse_Bank8_R4
  volatile uint32_t Fuse_Bank8_R5;  ///< 0x194 [R]: Fuse_Bank8_R5
  volatile uint32_t Fuse_Bank8_R6;  ///< 0x198 [R]: Fuse_Bank8_R6
  volatile uint32_t Fuse_Bank8_R7;  ///< 0x19c [R]: Fuse_Bank8_R7
  volatile uint32_t Fuse_Bank8_R8;  ///< 0x1a0 [R]: Fuse_Bank8_R8
  volatile uint32_t Fuse_Bank9_R0;  ///< 0x1a4 [R]: Fuse_Bank9_R0
  volatile uint32_t Fuse_Bank9_R1;  ///< 0x1a8 [R]: Fuse_Bank9_R1
  volatile uint32_t Fuse_Bank9_R2;  ///< 0x1ac [R]: Fuse_Bank9_R2
  volatile uint32_t Fuse_Bank9_R3;  ///< 0x1b0 [R]: Fuse_Bank9_R3
  volatile uint32_t Fuse_Bank9_R4;  ///< 0x1b4 [R]: Fuse_Bank9_R4
  volatile uint32_t Fuse_Bank9_R5;  ///< 0x1b8 [R]: Fuse_Bank9_R5
  volatile uint32_t Fuse_Bank9_R6;  ///< 0x1bc [R]: Fuse_Bank9_R6
  volatile uint32_t Fuse_Bank9_R7;  ///< 0x1c0 [R]: Fuse_Bank9_R7
  volatile uint32_t Fuse_Bank9_R8;  ///< 0x1c4 [R]: Fuse_Bank9_R8
  volatile uint32_t Fuse_Bank10_R0;  ///< 0x1c8 [R]: Fuse_Bank10_R0
  volatile uint32_t Fuse_Bank10_R1;  ///< 0x1cc [R]: Fuse_Bank10_R1
  volatile uint32_t Fuse_Bank10_R2;  ///< 0x1d0 [R]: Fuse_Bank10_R2
  volatile uint32_t Fuse_Bank10_R3;  ///< 0x1d4 [R]: Fuse_Bank10_R3
  volatile uint32_t Fuse_Bank10_R4;  ///< 0x1d8 [R]: Fuse_Bank10_R4
  volatile uint32_t Fuse_Bank10_R5;  ///< 0x1dc [R]: Fuse_Bank10_R5
  volatile uint32_t Fuse_Bank10_R6;  ///< 0x1e0 [R]: Fuse_Bank10_R6
  volatile uint32_t Fuse_Bank10_R7;  ///< 0x1e4 [R]: Fuse_Bank10_R7
  volatile uint32_t Fuse_Bank10_R8;  ///< 0x1e8 [R]: Fuse_Bank10_R8
  volatile uint32_t Fuse_Bank11_R0;  ///< 0x1ec [R]: Fuse_Bank11_R0
  volatile uint32_t Fuse_Bank11_R1;  ///< 0x1f0 [R]: Fuse_Bank11_R1
  volatile uint32_t Fuse_Bank11_R2;  ///< 0x1f4 [R]: Fuse_Bank11_R2
  volatile uint32_t Fuse_Bank11_R3;  ///< 0x1f8 [R]: Fuse_Bank11_R3
  volatile uint32_t Fuse_Bank11_R4;  ///< 0x1fc [R]: Fuse_Bank11_R4
  volatile uint32_t Fuse_Bank11_R5;  ///< 0x200 [R]: Fuse_Bank11_R5
  volatile uint32_t Fuse_Bank11_R6;  ///< 0x204 [R]: Fuse_Bank11_R6
  volatile uint32_t Fuse_Bank11_R7;  ///< 0x208 [R]: Fuse_Bank11_R7
  volatile uint32_t Fuse_Bank11_R8;  ///< 0x20c [R]: Fuse_Bank11_R8
  volatile uint32_t Fuse_Bank12_R0;  ///< 0x210 [R]: Fuse_Bank12_R0
  volatile uint32_t Fuse_Bank12_R1;  ///< 0x214 [R]: Fuse_Bank12_R1
  volatile uint32_t Fuse_Bank12_R2;  ///< 0x218 [R]: Fuse_Bank12_R2
  volatile uint32_t Fuse_Bank12_R3;  ///< 0x21c [R]: Fuse_Bank12_R3
  volatile uint32_t Fuse_Bank12_R4;  ///< 0x220 [R]: Fuse_Bank12_R4
  volatile uint32_t Fuse_Bank12_R5;  ///< 0x224 [R]: Fuse_Bank12_R5
  volatile uint32_t Fuse_Bank12_R6;  ///< 0x228 [R]: Fuse_Bank12_R6
  volatile uint32_t Fuse_Bank12_R7;  ///< 0x22c [R]: Fuse_Bank12_R7
  volatile uint32_t Fuse_Bank12_R8;  ///< 0x230 [R]: Fuse_Bank12_R8
  volatile uint32_t Fuse_Bank13_R0;  ///< 0x234 [R]: Fuse_Bank13_R0
  volatile uint32_t Fuse_Bank13_R1;  ///< 0x238 [R]: Fuse_Bank13_R1
  volatile uint32_t Fuse_Bank13_R2;  ///< 0x23c [R]: Fuse_Bank13_R2
  volatile uint32_t Fuse_Bank13_R3;  ///< 0x240 [R]: Fuse_Bank13_R3
  volatile uint32_t Fuse_Bank13_R4;  ///< 0x244 [R]: Fuse_Bank13_R4
  volatile uint32_t Fuse_Bank13_R5;  ///< 0x248 [R]: Fuse_Bank13_R5
  volatile uint32_t Fuse_Bank13_R6;  ///< 0x24c [R]: Fuse_Bank13_R6
  volatile uint32_t Fuse_Bank13_R7;  ///< 0x250 [R]: Fuse_Bank13_R7
  volatile uint32_t Fuse_Bank13_R8;  ///< 0x254 [R]: Fuse_Bank13_R8
  volatile uint32_t Fuse_Bank14_R0;  ///< 0x258 [R]: Fuse_Bank14_R0
  volatile uint32_t Fuse_Bank14_R1;  ///< 0x25c [R]: Fuse_Bank14_R1
  volatile uint32_t Fuse_Bank14_R2;  ///< 0x260 [R]: Fuse_Bank14_R2
  volatile uint32_t Fuse_Bank14_R3;  ///< 0x264 [R]: Fuse_Bank14_R3
  volatile uint32_t Fuse_Bank14_R4;  ///< 0x268 [R]: Fuse_Bank14_R4
  volatile uint32_t Fuse_Bank14_R5;  ///< 0x26c [R]: Fuse_Bank14_R5
  volatile uint32_t Fuse_Bank14_R6;  ///< 0x270 [R]: Fuse_Bank14_R6
  volatile uint32_t Fuse_Bank14_R7;  ///< 0x274 [R]: Fuse_Bank14_R7
  volatile uint32_t Fuse_Bank14_R8;  ///< 0x278 [R]: Fuse_Bank14_R8
  volatile uint32_t Fuse_Bank15_R0;  ///< 0x27c [R]: Fuse_Bank15_R0
  volatile uint32_t Fuse_Bank15_R1;  ///< 0x280 [R]: Fuse_Bank15_R1
  volatile uint32_t Fuse_Bank15_R2;  ///< 0x284 [R]: Fuse_Bank15_R2
  volatile uint32_t Fuse_Bank15_R3;  ///< 0x288 [R]: Fuse_Bank15_R3
  volatile uint32_t Fuse_Bank15_R4;  ///< 0x28c [R]: Fuse_Bank15_R4
  volatile uint32_t Fuse_Bank15_R5;  ///< 0x290 [R]: Fuse_Bank15_R5
  volatile uint32_t Fuse_Bank15_R6;  ///< 0x294 [R]: Fuse_Bank15_R6
  volatile uint32_t Fuse_Bank15_R7;  ///< 0x298 [R]: Fuse_Bank15_R7
  volatile uint32_t Fuse_Bank15_R8;  ///< 0x29c [R]: Fuse_Bank15_R8
} APB_CONFIG_REGS_t;

//====================================================================
//
//Register File: AIB Non Secure Registers - Padring (Padring)
/** \brief This register set includes all the registers for the padring I/O configuration*/
//
//====================================================================

//====================================================================
//
//Register File: AIB Non Secure Registers - AIB Extra Registers (AIB_Extra_Regs)
/** \brief This register set includes all the AIB registers for pad section control*/
//
//====================================================================

typedef struct AIB_EXTRA_REGS_REGS_s
{
  volatile uint32_t G3_ZPZN;  ///< 0x0 [R/W]: G3 Padsection ZP/ZN Register
  volatile uint32_t G4_ZPZN;  ///< 0x4 [R/W]: G4 Padsection ZP/ZN Register
  volatile uint32_t G6_ZPZN;  ///< 0x8 [R/W]: G6 Padsection ZP/ZN Register
  volatile uint32_t G7_ZPZN;  ///< 0xc [R/W]: G7 Padsection ZP/ZN Register
  volatile uint32_t G8_ZPZN;  ///< 0x10 [R/W]: G8 Padsection ZP/ZN Register
  volatile uint32_t G9_ZPZN;  ///< 0x14 [R/W]: G9 Padsection ZP/ZN Register
  volatile uint32_t G11_ZPZN;  ///< 0x18 [R/W]: G11 Padsection ZP/ZN Register
  volatile uint32_t V18EN;  ///< 0x1c [R/W]: V18EN control per pad section Register
  volatile uint32_t VSensor01;  ///< 0x20 [R/W]: VSensor01 Control Register
  volatile uint32_t VSensor02;  ///< 0x24 [R/W]: VSensor02 Control Register
  volatile uint32_t VSensor03;  ///< 0x28 [R/W]: VSensor03 Control Register
  volatile uint32_t VSensor04;  ///< 0x2c [R/W]: VSensor04 Control Register
  volatile uint32_t VSensor05;  ///< 0x30 [R/W]: VSensor05 Control Register
  volatile uint32_t CAL_EN;  ///< 0x34 [R/W]: Calibration Pad Enable Register
  volatile uint32_t CAL_ODR;  ///< 0x38 [R/W]: Calibration Pad On Die Resistor Control Register
  volatile uint32_t ZN;  ///< 0x3c [R/W]: ZN Calibration Value Register
  volatile uint32_t ZP;  ///< 0x40 [R/W]: ZP Calibration Value Register
  volatile uint32_t ZP_AFT_CAL;  ///< 0x44 [R/W]: ZP Calibration Setting After Cal. Register
  volatile uint32_t reserved0[234];
  volatile uint32_t SPARE0;  ///< 0x3f0 [R/W]: SPARE 0 Register
  volatile uint32_t SPARE1;  ///< 0x3f4 [R/W]: SPARE 1 Register
  volatile uint32_t SPARE2;  ///< 0x3f8 [R/W]: SPARE 2 Register
  volatile uint32_t SPARE3;  ///< 0x3fc [R/W]: SPARE 3 Register
} AIB_EXTRA_REGS_REGS_t;

//====================================================================
//
//Register File: AIB Secure Registers - Strap Override (Strap_Override)
//
//====================================================================

typedef struct STRAP_OVERRIDE_REGS_s
{
  volatile uint32_t SFO_FUSE_OVR_REG0;  ///< 0x0 [R/W]: Fuse Override Register 0
  volatile uint32_t SFO_FUSE_OVR_REG1;  ///< 0x4 [R/W]: Fuse Override Register 1
  volatile uint32_t SFO_FUSE_OVR_REG2;  ///< 0x8 [R/W]: Fuse Override Register 2
  volatile uint32_t SFO_FUSE_OVR_REG3;  ///< 0xc [R/W]: Fuse Override Register 3
  volatile uint32_t SFO_FUSE_OVR_REG4;  ///< 0x10 [R/W]: Fuse Override Register 4
  volatile uint32_t SFO_FUSE_OVR_REG5;  ///< 0x14 [R/W]: Fuse Override Register 5
  volatile uint32_t SFO_OVRD_CONF_REG0;  ///< 0x18 [R]: Overridden Configuration Register 0
  volatile uint32_t SFO_OVRD_CONF_REG1;  ///< 0x1c [R]: Overridden Configuration Register 1
  volatile uint32_t SFO_OVRD_CONF_REG2;  ///< 0x20 [R]: Overridden Configuration Register 2
  volatile uint32_t SFO_OVRD_CONF_REG3;  ///< 0x24 [R]: Overridden Configuration Register 3
  volatile uint32_t SFO_OVRD_CONF_REG4;  ///< 0x28 [R]: Overridden Configuration Register 4
  volatile uint32_t SFO_OVRD_CONF_REG5;  ///< 0x2c [R]: Overridden Configuration Register 5
} STRAP_OVERRIDE_REGS_t;

//====================================================================
//
//Register File: UART1 Registers (UART1)
//
//====================================================================

typedef struct UART1_REGS_s
{
 union {
  volatile uint32_t UART_RBR;  ///< 0x0 [R]: Receive Buffer Register
  volatile uint32_t UART_THR;  ///< 0x0 [W]: Transmit Holding Register
  volatile uint32_t UART_DLL;  ///< 0x0 [R/W]: Divisor Latch Low Byte Register
 } union0;
 union {
  volatile uint32_t UART_IER;  ///< 0x4 [R/W]: Interrupt Enable Register
  volatile uint32_t UART_DLH;  ///< 0x4 [R/W]: Divisor Latch High Byte Register
 } union1;
 union {
  volatile uint32_t UART_IIR;  ///< 0x8 [R]: Interrupt Identification Register
  volatile uint32_t UART_FCR;  ///< 0x8 [W]: FIFO Control Register
 } union2;
  volatile uint32_t UART_LCR;  ///< 0xc [R/W]: Line Control Register
  volatile uint32_t UART_MCR;  ///< 0x10 [R/W]: Modem Control Register
  volatile uint32_t UART_LSR;  ///< 0x14 [R]: Line Status Register
  volatile uint32_t UART_MSR;  ///< 0x18 [R]: Modem Status Register
  volatile uint32_t UART_SCR;  ///< 0x1c [R/W]: Scratchpad Register
  volatile uint32_t UART_ISR;  ///< 0x20 [R/W]: Infrared Selection Register
  volatile uint32_t UART_FOR;  ///< 0x24 [R]: Receive FIFO Occupancy Register
  volatile uint32_t UART_ABR;  ///< 0x28 [R/W]: Auto-Baud Control Register
  volatile uint32_t UART_ACR;  ///< 0x2c [R]: Auto-Baud Count Register
  volatile uint32_t REV0;  ///< 0x30 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x34 [R]: IP Tagging Revision 1
} UART1_REGS_t;

//====================================================================
//
//Register File: I2C2 Registers (I2C2)
//
//====================================================================

typedef struct I2C2_REGS_s
{
  volatile uint32_t TWSI_IBMR;  ///< 0x0 [R]: TWSI Bus Monitor Register
  volatile uint32_t reserved0;
  volatile uint32_t TWSI_IDBR;  ///< 0x8 [R/W]: TWSI Data Buffer Register
  volatile uint32_t reserved1;
  volatile uint32_t TWSI_ICR;  ///< 0x10 [R/W]: TWSI Control Register
  volatile uint32_t reserved2;
  volatile uint32_t TWSI_ISR;  ///< 0x18 [R/W]: TWSI Status Register
  volatile uint32_t reserved3;
  volatile uint32_t TWSI_ISAR;  ///< 0x20 [R/W]: TWSI Slave Address Register
  volatile uint32_t reserved4;
  volatile uint32_t TWSI_ILCR;  ///< 0x28 [R/W]: TWSI Load Count Register
  volatile uint32_t reserved5;
  volatile uint32_t TWSI_IWCR;  ///< 0x30 [R/W]: TWSI Wait Count Register
  volatile uint32_t reserved6[3];
  volatile uint32_t TWSI_WFIFO;  ///< 0x40 [W]: TWSI Write FIFO Register
  volatile uint32_t TWSI_WFIFO_WPTR;  ///< 0x44 [R/W]: TWSI Write FIFO Write Pointer Register
  volatile uint32_t TWSI_WFIFO_RPTR;  ///< 0x48 [R/W]: TWSI Write FIFO Read Pointer Register
  volatile uint32_t reserved7;
  volatile uint32_t TWSI_RFIFO;  ///< 0x50 [R]: TWSI Read FIFO Register
  volatile uint32_t TWSI_RFIFO_WPTR;  ///< 0x54 [R/W]: TWSI Read FIFO Write Pointer Register
  volatile uint32_t TWSI_RFIFO_RPTR;  ///< 0x58 [R/W]: TWSI Read FIFO Read Pointer Register
  volatile uint32_t reserved8;
  volatile uint32_t TWSI_FIFO_TSHLD;  ///< 0x60 [R/W]: TWSI FIFO Threshold Register
  volatile uint32_t reserved9[3];
  volatile uint32_t REV0;  ///< 0x70 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x74 [R]: IP Tagging Revision 1
} I2C2_REGS_t;

//====================================================================
//
//Register File: I2C3 Registers (I2C3)
//
//====================================================================

typedef struct I2C3_REGS_s
{
  volatile uint32_t TWSI_IBMR;  ///< 0x0 [R]: TWSI Bus Monitor Register
  volatile uint32_t reserved0;
  volatile uint32_t TWSI_IDBR;  ///< 0x8 [R/W]: TWSI Data Buffer Register
  volatile uint32_t reserved1;
  volatile uint32_t TWSI_ICR;  ///< 0x10 [R/W]: TWSI Control Register
  volatile uint32_t reserved2;
  volatile uint32_t TWSI_ISR;  ///< 0x18 [R/W]: TWSI Status Register
  volatile uint32_t reserved3;
  volatile uint32_t TWSI_ISAR;  ///< 0x20 [R/W]: TWSI Slave Address Register
  volatile uint32_t reserved4;
  volatile uint32_t TWSI_ILCR;  ///< 0x28 [R/W]: TWSI Load Count Register
  volatile uint32_t reserved5;
  volatile uint32_t TWSI_IWCR;  ///< 0x30 [R/W]: TWSI Wait Count Register
  volatile uint32_t reserved6[3];
  volatile uint32_t TWSI_WFIFO;  ///< 0x40 [W]: TWSI Write FIFO Register
  volatile uint32_t TWSI_WFIFO_WPTR;  ///< 0x44 [R/W]: TWSI Write FIFO Write Pointer Register
  volatile uint32_t TWSI_WFIFO_RPTR;  ///< 0x48 [R/W]: TWSI Write FIFO Read Pointer Register
  volatile uint32_t reserved7;
  volatile uint32_t TWSI_RFIFO;  ///< 0x50 [R]: TWSI Read FIFO Register
  volatile uint32_t TWSI_RFIFO_WPTR;  ///< 0x54 [R/W]: TWSI Read FIFO Write Pointer Register
  volatile uint32_t TWSI_RFIFO_RPTR;  ///< 0x58 [R/W]: TWSI Read FIFO Read Pointer Register
  volatile uint32_t reserved8;
  volatile uint32_t TWSI_FIFO_TSHLD;  ///< 0x60 [R/W]: TWSI FIFO Threshold Register
  volatile uint32_t reserved9[3];
  volatile uint32_t REV0;  ///< 0x70 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x74 [R]: IP Tagging Revision 1
} I2C3_REGS_t;

//====================================================================
//
//Register File: I2C4 Registers (I2C4)
//
//====================================================================

typedef struct I2C4_REGS_s
{
  volatile uint32_t TWSI_IBMR;  ///< 0x0 [R]: TWSI Bus Monitor Register
  volatile uint32_t reserved0;
  volatile uint32_t TWSI_IDBR;  ///< 0x8 [R/W]: TWSI Data Buffer Register
  volatile uint32_t reserved1;
  volatile uint32_t TWSI_ICR;  ///< 0x10 [R/W]: TWSI Control Register
  volatile uint32_t reserved2;
  volatile uint32_t TWSI_ISR;  ///< 0x18 [R/W]: TWSI Status Register
  volatile uint32_t reserved3;
  volatile uint32_t TWSI_ISAR;  ///< 0x20 [R/W]: TWSI Slave Address Register
  volatile uint32_t reserved4;
  volatile uint32_t TWSI_ILCR;  ///< 0x28 [R/W]: TWSI Load Count Register
  volatile uint32_t reserved5;
  volatile uint32_t TWSI_IWCR;  ///< 0x30 [R/W]: TWSI Wait Count Register
  volatile uint32_t reserved6[3];
  volatile uint32_t TWSI_WFIFO;  ///< 0x40 [W]: TWSI Write FIFO Register
  volatile uint32_t TWSI_WFIFO_WPTR;  ///< 0x44 [R/W]: TWSI Write FIFO Write Pointer Register
  volatile uint32_t TWSI_WFIFO_RPTR;  ///< 0x48 [R/W]: TWSI Write FIFO Read Pointer Register
  volatile uint32_t reserved7;
  volatile uint32_t TWSI_RFIFO;  ///< 0x50 [R]: TWSI Read FIFO Register
  volatile uint32_t TWSI_RFIFO_WPTR;  ///< 0x54 [R/W]: TWSI Read FIFO Write Pointer Register
  volatile uint32_t TWSI_RFIFO_RPTR;  ///< 0x58 [R/W]: TWSI Read FIFO Read Pointer Register
  volatile uint32_t reserved8;
  volatile uint32_t TWSI_FIFO_TSHLD;  ///< 0x60 [R/W]: TWSI FIFO Threshold Register
  volatile uint32_t reserved9[3];
  volatile uint32_t REV0;  ///< 0x70 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x74 [R]: IP Tagging Revision 1
} I2C4_REGS_t;

//====================================================================
//
//Register File: I2C5 Registers (I2C5)
//
//====================================================================

typedef struct I2C5_REGS_s
{
  volatile uint32_t TWSI_IBMR;  ///< 0x0 [R]: TWSI Bus Monitor Register
  volatile uint32_t reserved0;
  volatile uint32_t TWSI_IDBR;  ///< 0x8 [R/W]: TWSI Data Buffer Register
  volatile uint32_t reserved1;
  volatile uint32_t TWSI_ICR;  ///< 0x10 [R/W]: TWSI Control Register
  volatile uint32_t reserved2;
  volatile uint32_t TWSI_ISR;  ///< 0x18 [R/W]: TWSI Status Register
  volatile uint32_t reserved3;
  volatile uint32_t TWSI_ISAR;  ///< 0x20 [R/W]: TWSI Slave Address Register
  volatile uint32_t reserved4;
  volatile uint32_t TWSI_ILCR;  ///< 0x28 [R/W]: TWSI Load Count Register
  volatile uint32_t reserved5;
  volatile uint32_t TWSI_IWCR;  ///< 0x30 [R/W]: TWSI Wait Count Register
  volatile uint32_t reserved6[3];
  volatile uint32_t TWSI_WFIFO;  ///< 0x40 [W]: TWSI Write FIFO Register
  volatile uint32_t TWSI_WFIFO_WPTR;  ///< 0x44 [R/W]: TWSI Write FIFO Write Pointer Register
  volatile uint32_t TWSI_WFIFO_RPTR;  ///< 0x48 [R/W]: TWSI Write FIFO Read Pointer Register
  volatile uint32_t reserved7;
  volatile uint32_t TWSI_RFIFO;  ///< 0x50 [R]: TWSI Read FIFO Register
  volatile uint32_t TWSI_RFIFO_WPTR;  ///< 0x54 [R/W]: TWSI Read FIFO Write Pointer Register
  volatile uint32_t TWSI_RFIFO_RPTR;  ///< 0x58 [R/W]: TWSI Read FIFO Read Pointer Register
  volatile uint32_t reserved8;
  volatile uint32_t TWSI_FIFO_TSHLD;  ///< 0x60 [R/W]: TWSI FIFO Threshold Register
  volatile uint32_t reserved9[3];
  volatile uint32_t REV0;  ///< 0x70 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x74 [R]: IP Tagging Revision 1
} I2C5_REGS_t;

//====================================================================
//
//Register File: SSP Registers (Instance 1 of 3) (SSP0)
//
//====================================================================

typedef struct SSP0_REGS_s
{
  volatile uint32_t SSP_SSCR0;  ///< 0x0 [R/W]: SSP Control Register 0
  volatile uint32_t SSP_SSCR1;  ///< 0x4 [R/W]: SSP Control Register 1
  volatile uint32_t SSP_SSSR;  ///< 0x8 [R]: SSP Status Register
  volatile uint32_t SSP_SSITR;  ///< 0xc [R/W]: SSP Interrupt Test Register
  volatile uint32_t SSP_SSDR;  ///< 0x10 [R/W]: SSP Data Register
  volatile uint32_t reserved0[5];
  volatile uint32_t SSP_SSTO;  ///< 0x28 [R/W]: SSP Time Out Register
  volatile uint32_t SSP_SSPSP;  ///< 0x2c [R/W]: SSP Programmable Serial Protocol Register
  volatile uint32_t SSP_SSTSA;  ///< 0x30 [R/W]: SSP TX Time Slot Active Register
  volatile uint32_t SSP_SSRSA;  ///< 0x34 [R/W]: SSP RX Time Slot Active Register
  volatile uint32_t SSP_SSTSS;  ///< 0x38 [R]: SSP Time Slot Status Register
  volatile uint32_t reserved1[17];
  volatile uint32_t SSP_GPS_ID;  ///< 0x80 [R]: GPS Controller ID Register
  volatile uint32_t SSP_GPS_CSR;  ///< 0x84 [R/W]: GPS Control and Status Register
  volatile uint32_t SSP_GPS_TSCNT;  ///< 0x88 [R]: Time Sync Count Register
  volatile uint32_t SSP_GPS_TSCNT_ADJ;  ///< 0x8c [R]: Time Sync Count Adjust Register
  volatile uint32_t reserved2[12];
  volatile uint32_t SSP_SPI_MOD;  ///< 0xc0 [R/W]: Modified SPI Mode Register
  volatile uint32_t REV0;  ///< 0xc4 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0xc8 [R]: IP Tagging Revision 1
} SSP0_REGS_t;

//====================================================================
//
//Register File: SSP Registers (Instance 2 of 3) (SSP1)
//
//====================================================================

typedef struct SSP1_REGS_s
{
  volatile uint32_t SSP_SSCR0;  ///< 0x0 [R/W]: SSP Control Register 0
  volatile uint32_t SSP_SSCR1;  ///< 0x4 [R/W]: SSP Control Register 1
  volatile uint32_t SSP_SSSR;  ///< 0x8 [R]: SSP Status Register
  volatile uint32_t SSP_SSITR;  ///< 0xc [R/W]: SSP Interrupt Test Register
  volatile uint32_t SSP_SSDR;  ///< 0x10 [R/W]: SSP Data Register
  volatile uint32_t reserved0[5];
  volatile uint32_t SSP_SSTO;  ///< 0x28 [R/W]: SSP Time Out Register
  volatile uint32_t SSP_SSPSP;  ///< 0x2c [R/W]: SSP Programmable Serial Protocol Register
  volatile uint32_t SSP_SSTSA;  ///< 0x30 [R/W]: SSP TX Time Slot Active Register
  volatile uint32_t SSP_SSRSA;  ///< 0x34 [R/W]: SSP RX Time Slot Active Register
  volatile uint32_t SSP_SSTSS;  ///< 0x38 [R]: SSP Time Slot Status Register
  volatile uint32_t reserved1[17];
  volatile uint32_t SSP_GPS_ID;  ///< 0x80 [R]: GPS Controller ID Register
  volatile uint32_t SSP_GPS_CSR;  ///< 0x84 [R/W]: GPS Control and Status Register
  volatile uint32_t SSP_GPS_TSCNT;  ///< 0x88 [R]: Time Sync Count Register
  volatile uint32_t SSP_GPS_TSCNT_ADJ;  ///< 0x8c [R]: Time Sync Count Adjust Register
  volatile uint32_t reserved2[12];
  volatile uint32_t SSP_SPI_MOD;  ///< 0xc0 [R/W]: Modified SPI Mode Register
  volatile uint32_t REV0;  ///< 0xc4 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0xc8 [R]: IP Tagging Revision 1
} SSP1_REGS_t;

//====================================================================
//
//Register File: SSP Registers (Instance 3 of 3) (SSP2)
//
//====================================================================

typedef struct SSP2_REGS_s
{
  volatile uint32_t SSP_SSCR0;  ///< 0x0 [R/W]: SSP Control Register 0
  volatile uint32_t SSP_SSCR1;  ///< 0x4 [R/W]: SSP Control Register 1
  volatile uint32_t SSP_SSSR;  ///< 0x8 [R]: SSP Status Register
  volatile uint32_t SSP_SSITR;  ///< 0xc [R/W]: SSP Interrupt Test Register
  volatile uint32_t SSP_SSDR;  ///< 0x10 [R/W]: SSP Data Register
  volatile uint32_t reserved0[5];
  volatile uint32_t SSP_SSTO;  ///< 0x28 [R/W]: SSP Time Out Register
  volatile uint32_t SSP_SSPSP;  ///< 0x2c [R/W]: SSP Programmable Serial Protocol Register
  volatile uint32_t SSP_SSTSA;  ///< 0x30 [R/W]: SSP TX Time Slot Active Register
  volatile uint32_t SSP_SSRSA;  ///< 0x34 [R/W]: SSP RX Time Slot Active Register
  volatile uint32_t SSP_SSTSS;  ///< 0x38 [R]: SSP Time Slot Status Register
  volatile uint32_t reserved1[17];
  volatile uint32_t SSP_GPS_ID;  ///< 0x80 [R]: GPS Controller ID Register
  volatile uint32_t SSP_GPS_CSR;  ///< 0x84 [R/W]: GPS Control and Status Register
  volatile uint32_t SSP_GPS_TSCNT;  ///< 0x88 [R]: Time Sync Count Register
  volatile uint32_t SSP_GPS_TSCNT_ADJ;  ///< 0x8c [R]: Time Sync Count Adjust Register
  volatile uint32_t reserved2[12];
  volatile uint32_t SSP_SPI_MOD;  ///< 0xc0 [R/W]: Modified SPI Mode Register
  volatile uint32_t REV0;  ///< 0xc4 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0xc8 [R]: IP Tagging Revision 1
} SSP2_REGS_t;

//====================================================================
//
//Register File: RIPC Registers (RIPC)
/** \brief Register Descriptions for the RIPC (rev 0 . 1 . 1 . 1)*/
//
//====================================================================

typedef struct RIPC_REGS_s
{
  volatile uint32_t RIPCx_STATUS_REG;  ///< 0x0 [R/W]: RIPCx Status Register
  volatile uint32_t RIPCx_INT_REG0;  ///< 0x4 [R/W]: RIPCx Int Request Register (Instance 1 of 3)
  volatile uint32_t RIPCx_INT_REG1;  ///< 0x8 [R/W]: RIPCx Int Request Register (Instance 2 of 3)
  volatile uint32_t RIPCx_INT_REG2;  ///< 0xc [R/W]: RIPCx Int Request Register (Instance 3 of 3)
  volatile uint32_t RIPCx_INT_STAT_REG;  ///< 0x10 [R]: RIPCx Interrupt Status Register
  volatile uint32_t RIPCx_MAJ_MID_REV_REG;  ///< 0x14 [R]: Revision (Major and Mid) Register
  volatile uint32_t RIPCx_CFG_REV_REG;  ///< 0x18 [R]: Revision (Major and Mid) Register
} RIPC_REGS_t;

//====================================================================
//
//Register File: Gpio Bank 0 Registers (GPIO_Gpio0)
/** \brief (rev 1 . 1 . 3 . 0)
    The GPIO block registers provide the means to configure the characteristics of each GPIO pin,
    as well as the means for firmware to control/observe these pins.*/
//
//====================================================================

typedef struct GPIO_GPIO0_REGS_s
{
  volatile uint32_t PLR;  ///< 0x0 [R]: GPIO Pin Level Register
  volatile uint32_t PDR;  ///< 0x4 [R/W]: GPIO Pin Direction Register
  volatile uint32_t PSR;  ///< 0x8 [W]: GPIO Pin Output Set Register
  volatile uint32_t PCR;  ///< 0xc [W]: GPIO Pin Output Clear Register
  volatile uint32_t RER;  ///< 0x10 [R/W]: GPIO Rising-Edge Detect Enable Register
  volatile uint32_t FER;  ///< 0x14 [R/W]: GPIO Falling-Edge Detect Enable Register
  volatile uint32_t EDR;  ///< 0x18 [R/W]: GPIO Edge-detect Status Register
  volatile uint32_t SDR;  ///< 0x1c [W]: GPIO Output Direction Set Register
  volatile uint32_t CDR;  ///< 0x20 [W]: GPIO Output Direction Clear Register
  volatile uint32_t SRER;  ///< 0x24 [W]: GPIO Bit-wise Set of Rising-Edge Detect Enable Register
  volatile uint32_t CRER;  ///< 0x28 [W]: GPIO Bit-wise Clear of Rising-Edge Detect Enable Register
  volatile uint32_t SFER;  ///< 0x2c [W]: GPIO Bit-wise Set of Falling-Edge Detect Enable Register
  volatile uint32_t CFER;  ///< 0x30 [W]: GPIO Bit-wise Clear of Falling-Edge Detect Enable Register
  volatile uint32_t OLR;  ///< 0x34 [R/W]: Output Level Register
  volatile uint32_t OLDER;  ///< 0x38 [R/W]: Output Level Direct-write Enable Register
  volatile uint32_t reserved0;
  volatile uint32_t REV0;  ///< 0x40 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x44 [R]: IP Tagging Revision 1
  volatile uint32_t reserved1[2];
  volatile uint32_t ITER0;  ///< 0x50 [R/W]: Interrupt Target Enable Register (Instance 1 of 1)
} GPIO_GPIO0_REGS_t;

//====================================================================
//
//Register File: Gpio Bank 1 Registers (GPIO_Gpio1)
/** \brief (rev 1 . 1 . 3 . 0)
    The GPIO block registers provide the means to configure the characteristics of each GPIO pin,
    as well as the means for firmware to control/observe these pins.*/
//
//====================================================================

typedef struct GPIO_GPIO1_REGS_s
{
  volatile uint32_t PLR;  ///< 0x0 [R]: GPIO Pin Level Register
  volatile uint32_t PDR;  ///< 0x4 [R/W]: GPIO Pin Direction Register
  volatile uint32_t PSR;  ///< 0x8 [W]: GPIO Pin Output Set Register
  volatile uint32_t PCR;  ///< 0xc [W]: GPIO Pin Output Clear Register
  volatile uint32_t RER;  ///< 0x10 [R/W]: GPIO Rising-Edge Detect Enable Register
  volatile uint32_t FER;  ///< 0x14 [R/W]: GPIO Falling-Edge Detect Enable Register
  volatile uint32_t EDR;  ///< 0x18 [R/W]: GPIO Edge-detect Status Register
  volatile uint32_t SDR;  ///< 0x1c [W]: GPIO Output Direction Set Register
  volatile uint32_t CDR;  ///< 0x20 [W]: GPIO Output Direction Clear Register
  volatile uint32_t SRER;  ///< 0x24 [W]: GPIO Bit-wise Set of Rising-Edge Detect Enable Register
  volatile uint32_t CRER;  ///< 0x28 [W]: GPIO Bit-wise Clear of Rising-Edge Detect Enable Register
  volatile uint32_t SFER;  ///< 0x2c [W]: GPIO Bit-wise Set of Falling-Edge Detect Enable Register
  volatile uint32_t CFER;  ///< 0x30 [W]: GPIO Bit-wise Clear of Falling-Edge Detect Enable Register
  volatile uint32_t OLR;  ///< 0x34 [R/W]: Output Level Register
  volatile uint32_t OLDER;  ///< 0x38 [R/W]: Output Level Direct-write Enable Register
  volatile uint32_t reserved0;
  volatile uint32_t REV0;  ///< 0x40 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x44 [R]: IP Tagging Revision 1
  volatile uint32_t reserved1[2];
  volatile uint32_t ITER0;  ///< 0x50 [R/W]: Interrupt Target Enable Register (Instance 1 of 1)
} GPIO_GPIO1_REGS_t;

//====================================================================
//
//Register File: Gpio Bank 2 Registers (GPIO_Gpio2)
/** \brief (rev 1 . 1 . 3 . 0)
    The GPIO block registers provide the means to configure the characteristics of each GPIO pin,
    as well as the means for firmware to control/observe these pins.*/
//
//====================================================================

typedef struct GPIO_GPIO2_REGS_s
{
  volatile uint32_t PLR;  ///< 0x0 [R]: GPIO Pin Level Register
  volatile uint32_t PDR;  ///< 0x4 [R/W]: GPIO Pin Direction Register
  volatile uint32_t PSR;  ///< 0x8 [W]: GPIO Pin Output Set Register
  volatile uint32_t PCR;  ///< 0xc [W]: GPIO Pin Output Clear Register
  volatile uint32_t RER;  ///< 0x10 [R/W]: GPIO Rising-Edge Detect Enable Register
  volatile uint32_t FER;  ///< 0x14 [R/W]: GPIO Falling-Edge Detect Enable Register
  volatile uint32_t EDR;  ///< 0x18 [R/W]: GPIO Edge-detect Status Register
  volatile uint32_t SDR;  ///< 0x1c [W]: GPIO Output Direction Set Register
  volatile uint32_t CDR;  ///< 0x20 [W]: GPIO Output Direction Clear Register
  volatile uint32_t SRER;  ///< 0x24 [W]: GPIO Bit-wise Set of Rising-Edge Detect Enable Register
  volatile uint32_t CRER;  ///< 0x28 [W]: GPIO Bit-wise Clear of Rising-Edge Detect Enable Register
  volatile uint32_t SFER;  ///< 0x2c [W]: GPIO Bit-wise Set of Falling-Edge Detect Enable Register
  volatile uint32_t CFER;  ///< 0x30 [W]: GPIO Bit-wise Clear of Falling-Edge Detect Enable Register
  volatile uint32_t OLR;  ///< 0x34 [R/W]: Output Level Register
  volatile uint32_t OLDER;  ///< 0x38 [R/W]: Output Level Direct-write Enable Register
  volatile uint32_t reserved0;
  volatile uint32_t REV0;  ///< 0x40 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x44 [R]: IP Tagging Revision 1
  volatile uint32_t reserved1[2];
  volatile uint32_t ITER0;  ///< 0x50 [R/W]: Interrupt Target Enable Register (Instance 1 of 1)
} GPIO_GPIO2_REGS_t;

//====================================================================
//
//Register File: Gpio Bank 3 Registers (GPIO_Gpio3)
/** \brief (rev 1 . 1 . 3 . 0)
    The GPIO block registers provide the means to configure the characteristics of each GPIO pin,
    as well as the means for firmware to control/observe these pins.*/
//
//====================================================================

typedef struct GPIO_GPIO3_REGS_s
{
  volatile uint32_t PLR;  ///< 0x0 [R]: GPIO Pin Level Register
  volatile uint32_t PDR;  ///< 0x4 [R/W]: GPIO Pin Direction Register
  volatile uint32_t PSR;  ///< 0x8 [W]: GPIO Pin Output Set Register
  volatile uint32_t PCR;  ///< 0xc [W]: GPIO Pin Output Clear Register
  volatile uint32_t RER;  ///< 0x10 [R/W]: GPIO Rising-Edge Detect Enable Register
  volatile uint32_t FER;  ///< 0x14 [R/W]: GPIO Falling-Edge Detect Enable Register
  volatile uint32_t EDR;  ///< 0x18 [R/W]: GPIO Edge-detect Status Register
  volatile uint32_t SDR;  ///< 0x1c [W]: GPIO Output Direction Set Register
  volatile uint32_t CDR;  ///< 0x20 [W]: GPIO Output Direction Clear Register
  volatile uint32_t SRER;  ///< 0x24 [W]: GPIO Bit-wise Set of Rising-Edge Detect Enable Register
  volatile uint32_t CRER;  ///< 0x28 [W]: GPIO Bit-wise Clear of Rising-Edge Detect Enable Register
  volatile uint32_t SFER;  ///< 0x2c [W]: GPIO Bit-wise Set of Falling-Edge Detect Enable Register
  volatile uint32_t CFER;  ///< 0x30 [W]: GPIO Bit-wise Clear of Falling-Edge Detect Enable Register
  volatile uint32_t OLR;  ///< 0x34 [R/W]: Output Level Register
  volatile uint32_t OLDER;  ///< 0x38 [R/W]: Output Level Direct-write Enable Register
  volatile uint32_t reserved0;
  volatile uint32_t REV0;  ///< 0x40 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x44 [R]: IP Tagging Revision 1
  volatile uint32_t reserved1[2];
  volatile uint32_t ITER0;  ///< 0x50 [R/W]: Interrupt Target Enable Register (Instance 1 of 1)
} GPIO_GPIO3_REGS_t;

//====================================================================
//
//Register File: Gpio Bank 4 Registers (GPIO_Gpio4)
/** \brief (rev 1 . 1 . 3 . 0)
    The GPIO block registers provide the means to configure the characteristics of each GPIO pin,
    as well as the means for firmware to control/observe these pins.*/
//
//====================================================================

typedef struct GPIO_GPIO4_REGS_s
{
  volatile uint32_t PLR;  ///< 0x0 [R]: GPIO Pin Level Register
  volatile uint32_t PDR;  ///< 0x4 [R/W]: GPIO Pin Direction Register
  volatile uint32_t PSR;  ///< 0x8 [W]: GPIO Pin Output Set Register
  volatile uint32_t PCR;  ///< 0xc [W]: GPIO Pin Output Clear Register
  volatile uint32_t RER;  ///< 0x10 [R/W]: GPIO Rising-Edge Detect Enable Register
  volatile uint32_t FER;  ///< 0x14 [R/W]: GPIO Falling-Edge Detect Enable Register
  volatile uint32_t EDR;  ///< 0x18 [R/W]: GPIO Edge-detect Status Register
  volatile uint32_t SDR;  ///< 0x1c [W]: GPIO Output Direction Set Register
  volatile uint32_t CDR;  ///< 0x20 [W]: GPIO Output Direction Clear Register
  volatile uint32_t SRER;  ///< 0x24 [W]: GPIO Bit-wise Set of Rising-Edge Detect Enable Register
  volatile uint32_t CRER;  ///< 0x28 [W]: GPIO Bit-wise Clear of Rising-Edge Detect Enable Register
  volatile uint32_t SFER;  ///< 0x2c [W]: GPIO Bit-wise Set of Falling-Edge Detect Enable Register
  volatile uint32_t CFER;  ///< 0x30 [W]: GPIO Bit-wise Clear of Falling-Edge Detect Enable Register
  volatile uint32_t OLR;  ///< 0x34 [R/W]: Output Level Register
  volatile uint32_t OLDER;  ///< 0x38 [R/W]: Output Level Direct-write Enable Register
  volatile uint32_t reserved0;
  volatile uint32_t REV0;  ///< 0x40 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x44 [R]: IP Tagging Revision 1
  volatile uint32_t reserved1[2];
  volatile uint32_t ITER0;  ///< 0x50 [R/W]: Interrupt Target Enable Register (Instance 1 of 1)
} GPIO_GPIO4_REGS_t;

//====================================================================
//
//Register File: Gpio Bank 5 Registers (GPIO_Gpio5)
/** \brief (rev 1 . 1 . 3 . 0)
    The GPIO block registers provide the means to configure the characteristics of each GPIO pin,
    as well as the means for firmware to control/observe these pins.*/
//
//====================================================================

typedef struct GPIO_GPIO5_REGS_s
{
  volatile uint32_t PLR;  ///< 0x0 [R]: GPIO Pin Level Register
  volatile uint32_t PDR;  ///< 0x4 [R/W]: GPIO Pin Direction Register
  volatile uint32_t PSR;  ///< 0x8 [W]: GPIO Pin Output Set Register
  volatile uint32_t PCR;  ///< 0xc [W]: GPIO Pin Output Clear Register
  volatile uint32_t RER;  ///< 0x10 [R/W]: GPIO Rising-Edge Detect Enable Register
  volatile uint32_t FER;  ///< 0x14 [R/W]: GPIO Falling-Edge Detect Enable Register
  volatile uint32_t EDR;  ///< 0x18 [R/W]: GPIO Edge-detect Status Register
  volatile uint32_t SDR;  ///< 0x1c [W]: GPIO Output Direction Set Register
  volatile uint32_t CDR;  ///< 0x20 [W]: GPIO Output Direction Clear Register
  volatile uint32_t SRER;  ///< 0x24 [W]: GPIO Bit-wise Set of Rising-Edge Detect Enable Register
  volatile uint32_t CRER;  ///< 0x28 [W]: GPIO Bit-wise Clear of Rising-Edge Detect Enable Register
  volatile uint32_t SFER;  ///< 0x2c [W]: GPIO Bit-wise Set of Falling-Edge Detect Enable Register
  volatile uint32_t CFER;  ///< 0x30 [W]: GPIO Bit-wise Clear of Falling-Edge Detect Enable Register
  volatile uint32_t OLR;  ///< 0x34 [R/W]: Output Level Register
  volatile uint32_t OLDER;  ///< 0x38 [R/W]: Output Level Direct-write Enable Register
  volatile uint32_t reserved0;
  volatile uint32_t REV0;  ///< 0x40 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x44 [R]: IP Tagging Revision 1
  volatile uint32_t reserved1[2];
  volatile uint32_t ITER0;  ///< 0x50 [R/W]: Interrupt Target Enable Register (Instance 1 of 1)
} GPIO_GPIO5_REGS_t;

//====================================================================
//
//Register File: Gpio Bank 6 Registers (GPIO_Gpio6)
/** \brief (rev 1 . 1 . 3 . 0)
    The GPIO block registers provide the means to configure the characteristics of each GPIO pin,
    as well as the means for firmware to control/observe these pins.*/
//
//====================================================================

typedef struct GPIO_GPIO6_REGS_s
{
  volatile uint32_t PLR;  ///< 0x0 [R]: GPIO Pin Level Register
  volatile uint32_t PDR;  ///< 0x4 [R/W]: GPIO Pin Direction Register
  volatile uint32_t PSR;  ///< 0x8 [W]: GPIO Pin Output Set Register
  volatile uint32_t PCR;  ///< 0xc [W]: GPIO Pin Output Clear Register
  volatile uint32_t RER;  ///< 0x10 [R/W]: GPIO Rising-Edge Detect Enable Register
  volatile uint32_t FER;  ///< 0x14 [R/W]: GPIO Falling-Edge Detect Enable Register
  volatile uint32_t EDR;  ///< 0x18 [R/W]: GPIO Edge-detect Status Register
  volatile uint32_t SDR;  ///< 0x1c [W]: GPIO Output Direction Set Register
  volatile uint32_t CDR;  ///< 0x20 [W]: GPIO Output Direction Clear Register
  volatile uint32_t SRER;  ///< 0x24 [W]: GPIO Bit-wise Set of Rising-Edge Detect Enable Register
  volatile uint32_t CRER;  ///< 0x28 [W]: GPIO Bit-wise Clear of Rising-Edge Detect Enable Register
  volatile uint32_t SFER;  ///< 0x2c [W]: GPIO Bit-wise Set of Falling-Edge Detect Enable Register
  volatile uint32_t CFER;  ///< 0x30 [W]: GPIO Bit-wise Clear of Falling-Edge Detect Enable Register
  volatile uint32_t OLR;  ///< 0x34 [R/W]: Output Level Register
  volatile uint32_t OLDER;  ///< 0x38 [R/W]: Output Level Direct-write Enable Register
  volatile uint32_t reserved0;
  volatile uint32_t REV0;  ///< 0x40 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x44 [R]: IP Tagging Revision 1
  volatile uint32_t reserved1[2];
  volatile uint32_t ITER0;  ///< 0x50 [R/W]: Interrupt Target Enable Register (Instance 1 of 1)
} GPIO_GPIO6_REGS_t;

//====================================================================
//
//Register File: Gpio Bank 7 Registers (GPIO_Gpio7)
/** \brief (rev 1 . 1 . 3 . 0)
    The GPIO block registers provide the means to configure the characteristics of each GPIO pin,
    as well as the means for firmware to control/observe these pins.*/
//
//====================================================================

typedef struct GPIO_GPIO7_REGS_s
{
  volatile uint32_t PLR;  ///< 0x0 [R]: GPIO Pin Level Register
  volatile uint32_t PDR;  ///< 0x4 [R/W]: GPIO Pin Direction Register
  volatile uint32_t PSR;  ///< 0x8 [W]: GPIO Pin Output Set Register
  volatile uint32_t PCR;  ///< 0xc [W]: GPIO Pin Output Clear Register
  volatile uint32_t RER;  ///< 0x10 [R/W]: GPIO Rising-Edge Detect Enable Register
  volatile uint32_t FER;  ///< 0x14 [R/W]: GPIO Falling-Edge Detect Enable Register
  volatile uint32_t EDR;  ///< 0x18 [R/W]: GPIO Edge-detect Status Register
  volatile uint32_t SDR;  ///< 0x1c [W]: GPIO Output Direction Set Register
  volatile uint32_t CDR;  ///< 0x20 [W]: GPIO Output Direction Clear Register
  volatile uint32_t SRER;  ///< 0x24 [W]: GPIO Bit-wise Set of Rising-Edge Detect Enable Register
  volatile uint32_t CRER;  ///< 0x28 [W]: GPIO Bit-wise Clear of Rising-Edge Detect Enable Register
  volatile uint32_t SFER;  ///< 0x2c [W]: GPIO Bit-wise Set of Falling-Edge Detect Enable Register
  volatile uint32_t CFER;  ///< 0x30 [W]: GPIO Bit-wise Clear of Falling-Edge Detect Enable Register
  volatile uint32_t OLR;  ///< 0x34 [R/W]: Output Level Register
  volatile uint32_t OLDER;  ///< 0x38 [R/W]: Output Level Direct-write Enable Register
  volatile uint32_t reserved0;
  volatile uint32_t REV0;  ///< 0x40 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x44 [R]: IP Tagging Revision 1
  volatile uint32_t reserved1[2];
  volatile uint32_t ITER0;  ///< 0x50 [R/W]: Interrupt Target Enable Register (Instance 1 of 1)
} GPIO_GPIO7_REGS_t;

//====================================================================
//
//Register File: Edge Detect Bank 0 Register (PadEdge_EdgeDetect0)
//
//====================================================================

typedef struct PADEDGE_EDGEDETECT0_REGS_s
{
  volatile uint32_t EDGE;  ///< 0x0 [R]: Edge Detect
} PADEDGE_EDGEDETECT0_REGS_t;

//====================================================================
//
//Register File: Edge Detect Bank 1 Register (PadEdge_EdgeDetect1)
//
//====================================================================

typedef struct PADEDGE_EDGEDETECT1_REGS_s
{
  volatile uint32_t EDGE;  ///< 0x0 [R]: Edge Detect
} PADEDGE_EDGEDETECT1_REGS_t;

//====================================================================
//
//Register File: Edge Detect Bank 2 Register (PadEdge_EdgeDetect2)
//
//====================================================================

typedef struct PADEDGE_EDGEDETECT2_REGS_s
{
  volatile uint32_t EDGE;  ///< 0x0 [R]: Edge Detect
} PADEDGE_EDGEDETECT2_REGS_t;

//====================================================================
//
//Register File: Edge Detect Bank 3 Register (PadEdge_EdgeDetect3)
//
//====================================================================

typedef struct PADEDGE_EDGEDETECT3_REGS_s
{
  volatile uint32_t EDGE;  ///< 0x0 [R]: Edge Detect
} PADEDGE_EDGEDETECT3_REGS_t;

//====================================================================
//
//Register File: Edge Detect Bank 4 Register (PadEdge_EdgeDetect4)
//
//====================================================================

typedef struct PADEDGE_EDGEDETECT4_REGS_s
{
  volatile uint32_t EDGE;  ///< 0x0 [R]: Edge Detect
} PADEDGE_EDGEDETECT4_REGS_t;

//====================================================================
//
//Register File: Edge Detect Bank 5 Register (PadEdge_EdgeDetect5)
//
//====================================================================

typedef struct PADEDGE_EDGEDETECT5_REGS_s
{
  volatile uint32_t EDGE;  ///< 0x0 [R]: Edge Detect
} PADEDGE_EDGEDETECT5_REGS_t;

//====================================================================
//
//Register File: Edge Detect Bank 6 Register (PadEdge_EdgeDetect6)
//
//====================================================================

typedef struct PADEDGE_EDGEDETECT6_REGS_s
{
  volatile uint32_t EDGE;  ///< 0x0 [R]: Edge Detect
} PADEDGE_EDGEDETECT6_REGS_t;

//====================================================================
//
//Register File: Edge Detect Bank 7 Register (PadEdge_EdgeDetect7)
//
//====================================================================

typedef struct PADEDGE_EDGEDETECT7_REGS_s
{
  volatile uint32_t EDGE;  ///< 0x0 [R]: Edge Detect
} PADEDGE_EDGEDETECT7_REGS_t;

//====================================================================
//
//Register File: IO_PAD0 Configuration Registers (Padring_IO_PAD0)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD0_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD0 Configuration Register
} PADRING_IO_PAD0_REGS_t;

//====================================================================
//
//Register File: IO_PAD1 Configuration Registers (Padring_IO_PAD1)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD1_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD1 Configuration Register
} PADRING_IO_PAD1_REGS_t;

//====================================================================
//
//Register File: IO_PAD2 Configuration Registers (Padring_IO_PAD2)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD2_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD2 Configuration Register
} PADRING_IO_PAD2_REGS_t;

//====================================================================
//
//Register File: IO_PAD3 Configuration Registers (Padring_IO_PAD3)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD3_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD3 Configuration Register
} PADRING_IO_PAD3_REGS_t;

//====================================================================
//
//Register File: IO_PAD4 Configuration Registers (Padring_IO_PAD4)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD4_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD4 Configuration Register
} PADRING_IO_PAD4_REGS_t;

//====================================================================
//
//Register File: IO_PAD5 Configuration Registers (Padring_IO_PAD5)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD5_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD5 Configuration Register
} PADRING_IO_PAD5_REGS_t;

//====================================================================
//
//Register File: IO_PAD6 Configuration Registers (Padring_IO_PAD6)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD6_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD6 Configuration Register
} PADRING_IO_PAD6_REGS_t;

//====================================================================
//
//Register File: IO_PAD7 Configuration Registers (Padring_IO_PAD7)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD7_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD7 Configuration Register
} PADRING_IO_PAD7_REGS_t;

//====================================================================
//
//Register File: IO_PAD8 Configuration Registers (Padring_IO_PAD8)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD8_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD8 Configuration Register
} PADRING_IO_PAD8_REGS_t;

//====================================================================
//
//Register File: IO_PAD9 Configuration Registers (Padring_IO_PAD9)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD9_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD9 Configuration Register
} PADRING_IO_PAD9_REGS_t;

//====================================================================
//
//Register File: IO_PAD10 Configuration Registers (Padring_IO_PAD10)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD10_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD10 Configuration Register
} PADRING_IO_PAD10_REGS_t;

//====================================================================
//
//Register File: IO_PAD11 Configuration Registers (Padring_IO_PAD11)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD11_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD11 Configuration Register
} PADRING_IO_PAD11_REGS_t;

//====================================================================
//
//Register File: IO_PAD12 Configuration Registers (Padring_IO_PAD12)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD12_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD12 Configuration Register
} PADRING_IO_PAD12_REGS_t;

//====================================================================
//
//Register File: IO_PAD13 Configuration Registers (Padring_IO_PAD13)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD13_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD13 Configuration Register
} PADRING_IO_PAD13_REGS_t;

//====================================================================
//
//Register File: IO_PAD14 Configuration Registers (Padring_IO_PAD14)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD14_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD14 Configuration Register
} PADRING_IO_PAD14_REGS_t;

//====================================================================
//
//Register File: IO_PAD15 Configuration Registers (Padring_IO_PAD15)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD15_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD15 Configuration Register
} PADRING_IO_PAD15_REGS_t;

//====================================================================
//
//Register File: IO_PAD16 Configuration Registers (Padring_IO_PAD16)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD16_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD16 Configuration Register
} PADRING_IO_PAD16_REGS_t;

//====================================================================
//
//Register File: IO_PAD17 Configuration Registers (Padring_IO_PAD17)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD17_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD17 Configuration Register
} PADRING_IO_PAD17_REGS_t;

//====================================================================
//
//Register File: IO_PAD18 Configuration Registers (Padring_IO_PAD18)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD18_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD18 Configuration Register
} PADRING_IO_PAD18_REGS_t;

//====================================================================
//
//Register File: IO_PAD19 Configuration Registers (Padring_IO_PAD19)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD19_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD19 Configuration Register
} PADRING_IO_PAD19_REGS_t;

//====================================================================
//
//Register File: IO_PAD20 Configuration Registers (Padring_IO_PAD20)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD20_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD20 Configuration Register
} PADRING_IO_PAD20_REGS_t;

//====================================================================
//
//Register File: IO_PAD21 Configuration Registers (Padring_IO_PAD21)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD21_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD21 Configuration Register
} PADRING_IO_PAD21_REGS_t;

//====================================================================
//
//Register File: IO_PAD22 Configuration Registers (Padring_IO_PAD22)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD22_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD22 Configuration Register
} PADRING_IO_PAD22_REGS_t;

//====================================================================
//
//Register File: IO_PAD23 Configuration Registers (Padring_IO_PAD23)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD23_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD23 Configuration Register
} PADRING_IO_PAD23_REGS_t;

//====================================================================
//
//Register File: IO_PAD24 Configuration Registers (Padring_IO_PAD24)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD24_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD24 Configuration Register
} PADRING_IO_PAD24_REGS_t;

//====================================================================
//
//Register File: IO_PAD25 Configuration Registers (Padring_IO_PAD25)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD25_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD25 Configuration Register
} PADRING_IO_PAD25_REGS_t;

//====================================================================
//
//Register File: IO_PAD26 Configuration Registers (Padring_IO_PAD26)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD26_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD26 Configuration Register
} PADRING_IO_PAD26_REGS_t;

//====================================================================
//
//Register File: IO_PAD27 Configuration Registers (Padring_IO_PAD27)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD27_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD27 Configuration Register
} PADRING_IO_PAD27_REGS_t;

//====================================================================
//
//Register File: IO_PAD28 Configuration Registers (Padring_IO_PAD28)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD28_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD28 Configuration Register
} PADRING_IO_PAD28_REGS_t;

//====================================================================
//
//Register File: IO_PAD29 Configuration Registers (Padring_IO_PAD29)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD29_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD29 Configuration Register
} PADRING_IO_PAD29_REGS_t;

//====================================================================
//
//Register File: IO_PAD30 Configuration Registers (Padring_IO_PAD30)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD30_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD30 Configuration Register
} PADRING_IO_PAD30_REGS_t;

//====================================================================
//
//Register File: IO_PAD31 Configuration Registers (Padring_IO_PAD31)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD31_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD31 Configuration Register
} PADRING_IO_PAD31_REGS_t;

//====================================================================
//
//Register File: IO_PAD32 Configuration Registers (Padring_IO_PAD32)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD32_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD32 Configuration Register
} PADRING_IO_PAD32_REGS_t;

//====================================================================
//
//Register File: IO_PAD33 Configuration Registers (Padring_IO_PAD33)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD33_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD33 Configuration Register
} PADRING_IO_PAD33_REGS_t;

//====================================================================
//
//Register File: IO_PAD34 Configuration Registers (Padring_IO_PAD34)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD34_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD34 Configuration Register
} PADRING_IO_PAD34_REGS_t;

//====================================================================
//
//Register File: IO_PAD35 Configuration Registers (Padring_IO_PAD35)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD35_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD35 Configuration Register
} PADRING_IO_PAD35_REGS_t;

//====================================================================
//
//Register File: IO_PAD36 Configuration Registers (Padring_IO_PAD36)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD36_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD36 Configuration Register
} PADRING_IO_PAD36_REGS_t;

//====================================================================
//
//Register File: IO_PAD37 Configuration Registers (Padring_IO_PAD37)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD37_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD37 Configuration Register
} PADRING_IO_PAD37_REGS_t;

//====================================================================
//
//Register File: IO_PAD38 Configuration Registers (Padring_IO_PAD38)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD38_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD38 Configuration Register
} PADRING_IO_PAD38_REGS_t;

//====================================================================
//
//Register File: IO_PAD39 Configuration Registers (Padring_IO_PAD39)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD39_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD39 Configuration Register
} PADRING_IO_PAD39_REGS_t;

//====================================================================
//
//Register File: IO_PAD40 Configuration Registers (Padring_IO_PAD40)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD40_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD40 Configuration Register
} PADRING_IO_PAD40_REGS_t;

//====================================================================
//
//Register File: IO_PAD41 Configuration Registers (Padring_IO_PAD41)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD41_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD41 Configuration Register
} PADRING_IO_PAD41_REGS_t;

//====================================================================
//
//Register File: IO_PAD42 Configuration Registers (Padring_IO_PAD42)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD42_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD42 Configuration Register
} PADRING_IO_PAD42_REGS_t;

//====================================================================
//
//Register File: IO_PAD43 Configuration Registers (Padring_IO_PAD43)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD43_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD43 Configuration Register
} PADRING_IO_PAD43_REGS_t;

//====================================================================
//
//Register File: IO_PAD44 Configuration Registers (Padring_IO_PAD44)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD44_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD44 Configuration Register
} PADRING_IO_PAD44_REGS_t;

//====================================================================
//
//Register File: IO_PAD45 Configuration Registers (Padring_IO_PAD45)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD45_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD45 Configuration Register
} PADRING_IO_PAD45_REGS_t;

//====================================================================
//
//Register File: IO_PAD46 Configuration Registers (Padring_IO_PAD46)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD46_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD46 Configuration Register
} PADRING_IO_PAD46_REGS_t;

//====================================================================
//
//Register File: IO_PAD47 Configuration Registers (Padring_IO_PAD47)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD47_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD47 Configuration Register
} PADRING_IO_PAD47_REGS_t;

//====================================================================
//
//Register File: IO_PAD48 Configuration Registers (Padring_IO_PAD48)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD48_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD48 Configuration Register
} PADRING_IO_PAD48_REGS_t;

//====================================================================
//
//Register File: IO_PAD49 Configuration Registers (Padring_IO_PAD49)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD49_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD49 Configuration Register
} PADRING_IO_PAD49_REGS_t;

//====================================================================
//
//Register File: IO_PAD50 Configuration Registers (Padring_IO_PAD50)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD50_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD50 Configuration Register
} PADRING_IO_PAD50_REGS_t;

//====================================================================
//
//Register File: IO_PAD51 Configuration Registers (Padring_IO_PAD51)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD51_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD51 Configuration Register
} PADRING_IO_PAD51_REGS_t;

//====================================================================
//
//Register File: IO_PAD52 Configuration Registers (Padring_IO_PAD52)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD52_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD52 Configuration Register
} PADRING_IO_PAD52_REGS_t;

//====================================================================
//
//Register File: IO_PAD53 Configuration Registers (Padring_IO_PAD53)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD53_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD53 Configuration Register
} PADRING_IO_PAD53_REGS_t;

//====================================================================
//
//Register File: IO_PAD54 Configuration Registers (Padring_IO_PAD54)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD54_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD54 Configuration Register
} PADRING_IO_PAD54_REGS_t;

//====================================================================
//
//Register File: IO_PAD55 Configuration Registers (Padring_IO_PAD55)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD55_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD55 Configuration Register
} PADRING_IO_PAD55_REGS_t;

//====================================================================
//
//Register File: IO_PAD56 Configuration Registers (Padring_IO_PAD56)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD56_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD56 Configuration Register
} PADRING_IO_PAD56_REGS_t;

//====================================================================
//
//Register File: IO_PAD57 Configuration Registers (Padring_IO_PAD57)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD57_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD57 Configuration Register
} PADRING_IO_PAD57_REGS_t;

//====================================================================
//
//Register File: IO_PAD58 Configuration Registers (Padring_IO_PAD58)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD58_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD58 Configuration Register
} PADRING_IO_PAD58_REGS_t;

//====================================================================
//
//Register File: IO_PAD59 Configuration Registers (Padring_IO_PAD59)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD59_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD59 Configuration Register
} PADRING_IO_PAD59_REGS_t;

//====================================================================
//
//Register File: IO_PAD60 Configuration Registers (Padring_IO_PAD60)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD60_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD60 Configuration Register
} PADRING_IO_PAD60_REGS_t;

//====================================================================
//
//Register File: IO_PAD61 Configuration Registers (Padring_IO_PAD61)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD61_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD61 Configuration Register
} PADRING_IO_PAD61_REGS_t;

//====================================================================
//
//Register File: IO_PAD62 Configuration Registers (Padring_IO_PAD62)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD62_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD62 Configuration Register
} PADRING_IO_PAD62_REGS_t;

//====================================================================
//
//Register File: IO_PAD63 Configuration Registers (Padring_IO_PAD63)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD63_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD63 Configuration Register
} PADRING_IO_PAD63_REGS_t;

//====================================================================
//
//Register File: IO_PAD64 Configuration Registers (Padring_IO_PAD64)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD64_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD64 Configuration Register
} PADRING_IO_PAD64_REGS_t;

//====================================================================
//
//Register File: IO_PAD65 Configuration Registers (Padring_IO_PAD65)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD65_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD65 Configuration Register
} PADRING_IO_PAD65_REGS_t;

//====================================================================
//
//Register File: IO_PAD66 Configuration Registers (Padring_IO_PAD66)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD66_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD66 Configuration Register
} PADRING_IO_PAD66_REGS_t;

//====================================================================
//
//Register File: IO_PAD67 Configuration Registers (Padring_IO_PAD67)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD67_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD67 Configuration Register
} PADRING_IO_PAD67_REGS_t;

//====================================================================
//
//Register File: IO_PAD68 Configuration Registers (Padring_IO_PAD68)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD68_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD68 Configuration Register
} PADRING_IO_PAD68_REGS_t;

//====================================================================
//
//Register File: IO_PAD69 Configuration Registers (Padring_IO_PAD69)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD69_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD69 Configuration Register
} PADRING_IO_PAD69_REGS_t;

//====================================================================
//
//Register File: IO_PAD70 Configuration Registers (Padring_IO_PAD70)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD70_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD70 Configuration Register
} PADRING_IO_PAD70_REGS_t;

//====================================================================
//
//Register File: IO_PAD71 Configuration Registers (Padring_IO_PAD71)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD71_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD71 Configuration Register
} PADRING_IO_PAD71_REGS_t;

//====================================================================
//
//Register File: IO_PAD72 Configuration Registers (Padring_IO_PAD72)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD72_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD72 Configuration Register
} PADRING_IO_PAD72_REGS_t;

//====================================================================
//
//Register File: IO_PAD73 Configuration Registers (Padring_IO_PAD73)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD73_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD73 Configuration Register
} PADRING_IO_PAD73_REGS_t;

//====================================================================
//
//Register File: IO_PAD74 Configuration Registers (Padring_IO_PAD74)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD74_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD74 Configuration Register
} PADRING_IO_PAD74_REGS_t;

//====================================================================
//
//Register File: IO_PAD75 Configuration Registers (Padring_IO_PAD75)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD75_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD75 Configuration Register
} PADRING_IO_PAD75_REGS_t;

//====================================================================
//
//Register File: IO_PAD76 Configuration Registers (Padring_IO_PAD76)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD76_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD76 Configuration Register
} PADRING_IO_PAD76_REGS_t;

//====================================================================
//
//Register File: IO_PAD77 Configuration Registers (Padring_IO_PAD77)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD77_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD77 Configuration Register
} PADRING_IO_PAD77_REGS_t;

//====================================================================
//
//Register File: IO_PAD78 Configuration Registers (Padring_IO_PAD78)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD78_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD78 Configuration Register
} PADRING_IO_PAD78_REGS_t;

//====================================================================
//
//Register File: IO_PAD79 Configuration Registers (Padring_IO_PAD79)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD79_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD79 Configuration Register
} PADRING_IO_PAD79_REGS_t;

//====================================================================
//
//Register File: IO_PAD80 Configuration Registers (Padring_IO_PAD80)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD80_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD80 Configuration Register
} PADRING_IO_PAD80_REGS_t;

//====================================================================
//
//Register File: IO_PAD81 Configuration Registers (Padring_IO_PAD81)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD81_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD81 Configuration Register
} PADRING_IO_PAD81_REGS_t;

//====================================================================
//
//Register File: IO_PAD82 Configuration Registers (Padring_IO_PAD82)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD82_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD82 Configuration Register
} PADRING_IO_PAD82_REGS_t;

//====================================================================
//
//Register File: IO_PAD83 Configuration Registers (Padring_IO_PAD83)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD83_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD83 Configuration Register
} PADRING_IO_PAD83_REGS_t;

//====================================================================
//
//Register File: IO_PAD84 Configuration Registers (Padring_IO_PAD84)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD84_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD84 Configuration Register
} PADRING_IO_PAD84_REGS_t;

//====================================================================
//
//Register File: IO_PAD85 Configuration Registers (Padring_IO_PAD85)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD85_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD85 Configuration Register
} PADRING_IO_PAD85_REGS_t;

//====================================================================
//
//Register File: IO_PAD86 Configuration Registers (Padring_IO_PAD86)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD86_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD86 Configuration Register
} PADRING_IO_PAD86_REGS_t;

//====================================================================
//
//Register File: IO_PAD87 Configuration Registers (Padring_IO_PAD87)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD87_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD87 Configuration Register
} PADRING_IO_PAD87_REGS_t;

//====================================================================
//
//Register File: IO_PAD88 Configuration Registers (Padring_IO_PAD88)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD88_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD88 Configuration Register
} PADRING_IO_PAD88_REGS_t;

//====================================================================
//
//Register File: IO_PAD89 Configuration Registers (Padring_IO_PAD89)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD89_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD89 Configuration Register
} PADRING_IO_PAD89_REGS_t;

//====================================================================
//
//Register File: IO_PAD90 Configuration Registers (Padring_IO_PAD90)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD90_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD90 Configuration Register
} PADRING_IO_PAD90_REGS_t;

//====================================================================
//
//Register File: IO_PAD91 Configuration Registers (Padring_IO_PAD91)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD91_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD91 Configuration Register
} PADRING_IO_PAD91_REGS_t;

//====================================================================
//
//Register File: IO_PAD92 Configuration Registers (Padring_IO_PAD92)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD92_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD92 Configuration Register
} PADRING_IO_PAD92_REGS_t;

//====================================================================
//
//Register File: IO_PAD93 Configuration Registers (Padring_IO_PAD93)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD93_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD93 Configuration Register
} PADRING_IO_PAD93_REGS_t;

//====================================================================
//
//Register File: IO_PAD94 Configuration Registers (Padring_IO_PAD94)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD94_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD94 Configuration Register
} PADRING_IO_PAD94_REGS_t;

//====================================================================
//
//Register File: IO_PAD95 Configuration Registers (Padring_IO_PAD95)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD95_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD95 Configuration Register
} PADRING_IO_PAD95_REGS_t;

//====================================================================
//
//Register File: IO_PAD96 Configuration Registers (Padring_IO_PAD96)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD96_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD96 Configuration Register
} PADRING_IO_PAD96_REGS_t;

//====================================================================
//
//Register File: IO_PAD97 Configuration Registers (Padring_IO_PAD97)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD97_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD97 Configuration Register
} PADRING_IO_PAD97_REGS_t;

//====================================================================
//
//Register File: IO_PAD98 Configuration Registers (Padring_IO_PAD98)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD98_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD98 Configuration Register
} PADRING_IO_PAD98_REGS_t;

//====================================================================
//
//Register File: IO_PAD99 Configuration Registers (Padring_IO_PAD99)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD99_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD99 Configuration Register
} PADRING_IO_PAD99_REGS_t;

//====================================================================
//
//Register File: IO_PAD100 Configuration Registers (Padring_IO_PAD100)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD100_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD100 Configuration Register
} PADRING_IO_PAD100_REGS_t;

//====================================================================
//
//Register File: IO_PAD101 Configuration Registers (Padring_IO_PAD101)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD101_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD101 Configuration Register
} PADRING_IO_PAD101_REGS_t;

//====================================================================
//
//Register File: IO_PAD102 Configuration Registers (Padring_IO_PAD102)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD102_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD102 Configuration Register
} PADRING_IO_PAD102_REGS_t;

//====================================================================
//
//Register File: IO_PAD103 Configuration Registers (Padring_IO_PAD103)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD103_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD103 Configuration Register
} PADRING_IO_PAD103_REGS_t;

//====================================================================
//
//Register File: IO_PAD104 Configuration Registers (Padring_IO_PAD104)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD104_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD104 Configuration Register
} PADRING_IO_PAD104_REGS_t;

//====================================================================
//
//Register File: IO_PAD105 Configuration Registers (Padring_IO_PAD105)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD105_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD105 Configuration Register
} PADRING_IO_PAD105_REGS_t;

//====================================================================
//
//Register File: IO_PAD106 Configuration Registers (Padring_IO_PAD106)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD106_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD106 Configuration Register
} PADRING_IO_PAD106_REGS_t;

//====================================================================
//
//Register File: IO_PAD107 Configuration Registers (Padring_IO_PAD107)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD107_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD107 Configuration Register
} PADRING_IO_PAD107_REGS_t;

//====================================================================
//
//Register File: IO_PAD108 Configuration Registers (Padring_IO_PAD108)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD108_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD108 Configuration Register
} PADRING_IO_PAD108_REGS_t;

//====================================================================
//
//Register File: IO_PAD109 Configuration Registers (Padring_IO_PAD109)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD109_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD109 Configuration Register
} PADRING_IO_PAD109_REGS_t;

//====================================================================
//
//Register File: VID_LVDSo_D0 Configuration Registers (Padring_VID_LVDSo_D0)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_VID_LVDSO_D0_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: VID_LVDSo_D0 Configuration Register
} PADRING_VID_LVDSO_D0_REGS_t;

//====================================================================
//
//Register File: VID_LVDSo_D1 Configuration Registers (Padring_VID_LVDSo_D1)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_VID_LVDSO_D1_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: VID_LVDSo_D1 Configuration Register
} PADRING_VID_LVDSO_D1_REGS_t;

//====================================================================
//
//Register File: VID_LVDSo_D2 Configuration Registers (Padring_VID_LVDSo_D2)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_VID_LVDSO_D2_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: VID_LVDSo_D2 Configuration Register
} PADRING_VID_LVDSO_D2_REGS_t;

//====================================================================
//
//Register File: VID_LVDSo_D3 Configuration Registers (Padring_VID_LVDSo_D3)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_VID_LVDSO_D3_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: VID_LVDSo_D3 Configuration Register
} PADRING_VID_LVDSO_D3_REGS_t;

//====================================================================
//
//Register File: VID_LVDSo_D4 Configuration Registers (Padring_VID_LVDSo_D4)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_VID_LVDSO_D4_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: VID_LVDSo_D4 Configuration Register
} PADRING_VID_LVDSO_D4_REGS_t;

//====================================================================
//
//Register File: VID_LVDSo_D5 Configuration Registers (Padring_VID_LVDSo_D5)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_VID_LVDSO_D5_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: VID_LVDSo_D5 Configuration Register
} PADRING_VID_LVDSO_D5_REGS_t;

//====================================================================
//
//Register File: VID_LVDSo_D6 Configuration Registers (Padring_VID_LVDSo_D6)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_VID_LVDSO_D6_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: VID_LVDSo_D6 Configuration Register
} PADRING_VID_LVDSO_D6_REGS_t;

//====================================================================
//
//Register File: VID_LVDSo_D7 Configuration Registers (Padring_VID_LVDSo_D7)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_VID_LVDSO_D7_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: VID_LVDSo_D7 Configuration Register
} PADRING_VID_LVDSO_D7_REGS_t;

//====================================================================
//
//Register File: IO_PAD110 Configuration Registers (Padring_IO_PAD110)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD110_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD110 Configuration Register
} PADRING_IO_PAD110_REGS_t;

//====================================================================
//
//Register File: IO_PAD111 Configuration Registers (Padring_IO_PAD111)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD111_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD111 Configuration Register
} PADRING_IO_PAD111_REGS_t;

//====================================================================
//
//Register File: IO_PAD112 Configuration Registers (Padring_IO_PAD112)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD112_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD112 Configuration Register
} PADRING_IO_PAD112_REGS_t;

//====================================================================
//
//Register File: IO_PAD113 Configuration Registers (Padring_IO_PAD113)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD113_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD113 Configuration Register
} PADRING_IO_PAD113_REGS_t;

//====================================================================
//
//Register File: IO_PAD114 Configuration Registers (Padring_IO_PAD114)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD114_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD114 Configuration Register
} PADRING_IO_PAD114_REGS_t;

//====================================================================
//
//Register File: IO_PAD115 Configuration Registers (Padring_IO_PAD115)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD115_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD115 Configuration Register
} PADRING_IO_PAD115_REGS_t;

//====================================================================
//
//Register File: IO_PAD116 Configuration Registers (Padring_IO_PAD116)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD116_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD116 Configuration Register
} PADRING_IO_PAD116_REGS_t;

//====================================================================
//
//Register File: IO_PAD117 Configuration Registers (Padring_IO_PAD117)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD117_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD117 Configuration Register
} PADRING_IO_PAD117_REGS_t;

//====================================================================
//
//Register File: IO_PAD118 Configuration Registers (Padring_IO_PAD118)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD118_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD118 Configuration Register
} PADRING_IO_PAD118_REGS_t;

//====================================================================
//
//Register File: IO_PAD119 Configuration Registers (Padring_IO_PAD119)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD119_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD119 Configuration Register
} PADRING_IO_PAD119_REGS_t;

//====================================================================
//
//Register File: IO_PAD120 Configuration Registers (Padring_IO_PAD120)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD120_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD120 Configuration Register
} PADRING_IO_PAD120_REGS_t;

//====================================================================
//
//Register File: IO_PAD121 Configuration Registers (Padring_IO_PAD121)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD121_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD121 Configuration Register
} PADRING_IO_PAD121_REGS_t;

//====================================================================
//
//Register File: IO_PAD122 Configuration Registers (Padring_IO_PAD122)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD122_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD122 Configuration Register
} PADRING_IO_PAD122_REGS_t;

//====================================================================
//
//Register File: IO_PAD123 Configuration Registers (Padring_IO_PAD123)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD123_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD123 Configuration Register
} PADRING_IO_PAD123_REGS_t;

//====================================================================
//
//Register File: IO_PAD124 Configuration Registers (Padring_IO_PAD124)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD124_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD124 Configuration Register
} PADRING_IO_PAD124_REGS_t;

//====================================================================
//
//Register File: IO_PAD125 Configuration Registers (Padring_IO_PAD125)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD125_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD125 Configuration Register
} PADRING_IO_PAD125_REGS_t;

//====================================================================
//
//Register File: IO_PAD126 Configuration Registers (Padring_IO_PAD126)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD126_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD126 Configuration Register
} PADRING_IO_PAD126_REGS_t;

//====================================================================
//
//Register File: IO_PAD127 Configuration Registers (Padring_IO_PAD127)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD127_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD127 Configuration Register
} PADRING_IO_PAD127_REGS_t;

//====================================================================
//
//Register File: IO_PAD128 Configuration Registers (Padring_IO_PAD128)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD128_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD128 Configuration Register
} PADRING_IO_PAD128_REGS_t;

//====================================================================
//
//Register File: IO_PAD129 Configuration Registers (Padring_IO_PAD129)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD129_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD129 Configuration Register
} PADRING_IO_PAD129_REGS_t;

//====================================================================
//
//Register File: IO_PAD130 Configuration Registers (Padring_IO_PAD130)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD130_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD130 Configuration Register
} PADRING_IO_PAD130_REGS_t;

//====================================================================
//
//Register File: IO_PAD131 Configuration Registers (Padring_IO_PAD131)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD131_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD131 Configuration Register
} PADRING_IO_PAD131_REGS_t;

//====================================================================
//
//Register File: IO_PAD132 Configuration Registers (Padring_IO_PAD132)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD132_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD132 Configuration Register
} PADRING_IO_PAD132_REGS_t;

//====================================================================
//
//Register File: IO_PAD133 Configuration Registers (Padring_IO_PAD133)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD133_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD133 Configuration Register
} PADRING_IO_PAD133_REGS_t;

//====================================================================
//
//Register File: IO_PAD134 Configuration Registers (Padring_IO_PAD134)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD134_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD134 Configuration Register
} PADRING_IO_PAD134_REGS_t;

//====================================================================
//
//Register File: IO_PAD135 Configuration Registers (Padring_IO_PAD135)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD135_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD135 Configuration Register
} PADRING_IO_PAD135_REGS_t;

//====================================================================
//
//Register File: IO_PAD136 Configuration Registers (Padring_IO_PAD136)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD136_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD136 Configuration Register
} PADRING_IO_PAD136_REGS_t;

//====================================================================
//
//Register File: IO_PAD137 Configuration Registers (Padring_IO_PAD137)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD137_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD137 Configuration Register
} PADRING_IO_PAD137_REGS_t;

//====================================================================
//
//Register File: IO_PAD138 Configuration Registers (Padring_IO_PAD138)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD138_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD138 Configuration Register
} PADRING_IO_PAD138_REGS_t;

//====================================================================
//
//Register File: IO_PAD139 Configuration Registers (Padring_IO_PAD139)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD139_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD139 Configuration Register
} PADRING_IO_PAD139_REGS_t;

//====================================================================
//
//Register File: IO_PAD140 Configuration Registers (Padring_IO_PAD140)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD140_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD140 Configuration Register
} PADRING_IO_PAD140_REGS_t;

//====================================================================
//
//Register File: IO_PAD141 Configuration Registers (Padring_IO_PAD141)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD141_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD141 Configuration Register
} PADRING_IO_PAD141_REGS_t;

//====================================================================
//
//Register File: IO_PAD142 Configuration Registers (Padring_IO_PAD142)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD142_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD142 Configuration Register
} PADRING_IO_PAD142_REGS_t;

//====================================================================
//
//Register File: IO_PAD143 Configuration Registers (Padring_IO_PAD143)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD143_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD143 Configuration Register
} PADRING_IO_PAD143_REGS_t;

//====================================================================
//
//Register File: IO_PAD144 Configuration Registers (Padring_IO_PAD144)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD144_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD144 Configuration Register
} PADRING_IO_PAD144_REGS_t;

//====================================================================
//
//Register File: IO_PAD145 Configuration Registers (Padring_IO_PAD145)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD145_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD145 Configuration Register
} PADRING_IO_PAD145_REGS_t;

//====================================================================
//
//Register File: IO_PAD146 Configuration Registers (Padring_IO_PAD146)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD146_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD146 Configuration Register
} PADRING_IO_PAD146_REGS_t;

//====================================================================
//
//Register File: IO_PAD147 Configuration Registers (Padring_IO_PAD147)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD147_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD147 Configuration Register
} PADRING_IO_PAD147_REGS_t;

//====================================================================
//
//Register File: IO_PAD148 Configuration Registers (Padring_IO_PAD148)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD148_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD148 Configuration Register
} PADRING_IO_PAD148_REGS_t;

//====================================================================
//
//Register File: IO_PAD149 Configuration Registers (Padring_IO_PAD149)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD149_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD149 Configuration Register
} PADRING_IO_PAD149_REGS_t;

//====================================================================
//
//Register File: IO_PAD150 Configuration Registers (Padring_IO_PAD150)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD150_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD150 Configuration Register
} PADRING_IO_PAD150_REGS_t;

//====================================================================
//
//Register File: IO_PAD151 Configuration Registers (Padring_IO_PAD151)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD151_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD151 Configuration Register
} PADRING_IO_PAD151_REGS_t;

//====================================================================
//
//Register File: IO_PAD152 Configuration Registers (Padring_IO_PAD152)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD152_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD152 Configuration Register
} PADRING_IO_PAD152_REGS_t;

//====================================================================
//
//Register File: IO_PAD153 Configuration Registers (Padring_IO_PAD153)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD153_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD153 Configuration Register
} PADRING_IO_PAD153_REGS_t;

//====================================================================
//
//Register File: IO_PAD154 Configuration Registers (Padring_IO_PAD154)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD154_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD154 Configuration Register
} PADRING_IO_PAD154_REGS_t;

//====================================================================
//
//Register File: IO_PAD155 Configuration Registers (Padring_IO_PAD155)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD155_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD155 Configuration Register
} PADRING_IO_PAD155_REGS_t;

//====================================================================
//
//Register File: IO_PAD156 Configuration Registers (Padring_IO_PAD156)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD156_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD156 Configuration Register
} PADRING_IO_PAD156_REGS_t;

//====================================================================
//
//Register File: IO_PAD157 Configuration Registers (Padring_IO_PAD157)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD157_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD157 Configuration Register
} PADRING_IO_PAD157_REGS_t;

//====================================================================
//
//Register File: IO_PAD158 Configuration Registers (Padring_IO_PAD158)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD158_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD158 Configuration Register
} PADRING_IO_PAD158_REGS_t;

//====================================================================
//
//Register File: IO_PAD159 Configuration Registers (Padring_IO_PAD159)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD159_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD159 Configuration Register
} PADRING_IO_PAD159_REGS_t;

//====================================================================
//
//Register File: IO_PAD160 Configuration Registers (Padring_IO_PAD160)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD160_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD160 Configuration Register
} PADRING_IO_PAD160_REGS_t;

//====================================================================
//
//Register File: IO_PAD161 Configuration Registers (Padring_IO_PAD161)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD161_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD161 Configuration Register
} PADRING_IO_PAD161_REGS_t;

//====================================================================
//
//Register File: IO_PAD162 Configuration Registers (Padring_IO_PAD162)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD162_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD162 Configuration Register
} PADRING_IO_PAD162_REGS_t;

//====================================================================
//
//Register File: IO_PAD163 Configuration Registers (Padring_IO_PAD163)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD163_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD163 Configuration Register
} PADRING_IO_PAD163_REGS_t;

//====================================================================
//
//Register File: IO_PAD164 Configuration Registers (Padring_IO_PAD164)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD164_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD164 Configuration Register
} PADRING_IO_PAD164_REGS_t;

//====================================================================
//
//Register File: IO_PAD165 Configuration Registers (Padring_IO_PAD165)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD165_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD165 Configuration Register
} PADRING_IO_PAD165_REGS_t;

//====================================================================
//
//Register File: IO_PAD166 Configuration Registers (Padring_IO_PAD166)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD166_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD166 Configuration Register
} PADRING_IO_PAD166_REGS_t;

//====================================================================
//
//Register File: IO_PAD167 Configuration Registers (Padring_IO_PAD167)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD167_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD167 Configuration Register
} PADRING_IO_PAD167_REGS_t;

//====================================================================
//
//Register File: IO_PAD168 Configuration Registers (Padring_IO_PAD168)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD168_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD168 Configuration Register
} PADRING_IO_PAD168_REGS_t;

//====================================================================
//
//Register File: IO_PAD169 Configuration Registers (Padring_IO_PAD169)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD169_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD169 Configuration Register
} PADRING_IO_PAD169_REGS_t;

//====================================================================
//
//Register File: IO_PAD170 Configuration Registers (Padring_IO_PAD170)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD170_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD170 Configuration Register
} PADRING_IO_PAD170_REGS_t;

//====================================================================
//
//Register File: IO_PAD171 Configuration Registers (Padring_IO_PAD171)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD171_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD171 Configuration Register
} PADRING_IO_PAD171_REGS_t;

//====================================================================
//
//Register File: IO_PAD172 Configuration Registers (Padring_IO_PAD172)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD172_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD172 Configuration Register
} PADRING_IO_PAD172_REGS_t;

//====================================================================
//
//Register File: IO_PAD173 Configuration Registers (Padring_IO_PAD173)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD173_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD173 Configuration Register
} PADRING_IO_PAD173_REGS_t;

//====================================================================
//
//Register File: IO_PAD174 Configuration Registers (Padring_IO_PAD174)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD174_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD174 Configuration Register
} PADRING_IO_PAD174_REGS_t;

//====================================================================
//
//Register File: IO_PAD175 Configuration Registers (Padring_IO_PAD175)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD175_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD175 Configuration Register
} PADRING_IO_PAD175_REGS_t;

//====================================================================
//
//Register File: IO_PAD176 Configuration Registers (Padring_IO_PAD176)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD176_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD176 Configuration Register
} PADRING_IO_PAD176_REGS_t;

//====================================================================
//
//Register File: IO_PAD177 Configuration Registers (Padring_IO_PAD177)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD177_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD177 Configuration Register
} PADRING_IO_PAD177_REGS_t;

//====================================================================
//
//Register File: IO_PAD178 Configuration Registers (Padring_IO_PAD178)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD178_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD178 Configuration Register
} PADRING_IO_PAD178_REGS_t;

//====================================================================
//
//Register File: IO_PAD179 Configuration Registers (Padring_IO_PAD179)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD179_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD179 Configuration Register
} PADRING_IO_PAD179_REGS_t;

//====================================================================
//
//Register File: IO_PAD180 Configuration Registers (Padring_IO_PAD180)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD180_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD180 Configuration Register
} PADRING_IO_PAD180_REGS_t;

//====================================================================
//
//Register File: IO_PAD181 Configuration Registers (Padring_IO_PAD181)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD181_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD181 Configuration Register
} PADRING_IO_PAD181_REGS_t;

//====================================================================
//
//Register File: IO_PAD182 Configuration Registers (Padring_IO_PAD182)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD182_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD182 Configuration Register
} PADRING_IO_PAD182_REGS_t;

//====================================================================
//
//Register File: IO_PAD183 Configuration Registers (Padring_IO_PAD183)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD183_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD183 Configuration Register
} PADRING_IO_PAD183_REGS_t;

//====================================================================
//
//Register File: IO_PAD184 Configuration Registers (Padring_IO_PAD184)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD184_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD184 Configuration Register
} PADRING_IO_PAD184_REGS_t;

//====================================================================
//
//Register File: IO_PAD185 Configuration Registers (Padring_IO_PAD185)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD185_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD185 Configuration Register
} PADRING_IO_PAD185_REGS_t;

//====================================================================
//
//Register File: IO_PAD186 Configuration Registers (Padring_IO_PAD186)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD186_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD186 Configuration Register
} PADRING_IO_PAD186_REGS_t;

//====================================================================
//
//Register File: IO_PAD187 Configuration Registers (Padring_IO_PAD187)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD187_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD187 Configuration Register
} PADRING_IO_PAD187_REGS_t;

//====================================================================
//
//Register File: IO_PAD188 Configuration Registers (Padring_IO_PAD188)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD188_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD188 Configuration Register
} PADRING_IO_PAD188_REGS_t;

//====================================================================
//
//Register File: IO_PAD189 Configuration Registers (Padring_IO_PAD189)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD189_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD189 Configuration Register
} PADRING_IO_PAD189_REGS_t;

//====================================================================
//
//Register File: IO_PAD190 Configuration Registers (Padring_IO_PAD190)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD190_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD190 Configuration Register
} PADRING_IO_PAD190_REGS_t;

//====================================================================
//
//Register File: IO_PAD191 Configuration Registers (Padring_IO_PAD191)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD191_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD191 Configuration Register
} PADRING_IO_PAD191_REGS_t;

//====================================================================
//
//Register File: IO_PAD192 Configuration Registers (Padring_IO_PAD192)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD192_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD192 Configuration Register
} PADRING_IO_PAD192_REGS_t;

//====================================================================
//
//Register File: SCIF0_LVDSo_CLK Configuration Registers (Padring_SCIF0_LVDSo_CLK)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_SCIF0_LVDSO_CLK_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: SCIF0_LVDSo_CLK Configuration Register
} PADRING_SCIF0_LVDSO_CLK_REGS_t;

//====================================================================
//
//Register File: SCIF0_LVDSi_CLK Configuration Registers (Padring_SCIF0_LVDSi_CLK)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_SCIF0_LVDSI_CLK_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: SCIF0_LVDSi_CLK Configuration Register
} PADRING_SCIF0_LVDSI_CLK_REGS_t;

//====================================================================
//
//Register File: SCIF0_LVDSi_D0 Configuration Registers (Padring_SCIF0_LVDSi_D0)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_SCIF0_LVDSI_D0_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: SCIF0_LVDSi_D0 Configuration Register
} PADRING_SCIF0_LVDSI_D0_REGS_t;

//====================================================================
//
//Register File: SCIF0_LVDSi_D1 Configuration Registers (Padring_SCIF0_LVDSi_D1)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_SCIF0_LVDSI_D1_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: SCIF0_LVDSi_D1 Configuration Register
} PADRING_SCIF0_LVDSI_D1_REGS_t;

//====================================================================
//
//Register File: SCIF0_LVDSi_D2 Configuration Registers (Padring_SCIF0_LVDSi_D2)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_SCIF0_LVDSI_D2_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: SCIF0_LVDSi_D2 Configuration Register
} PADRING_SCIF0_LVDSI_D2_REGS_t;

//====================================================================
//
//Register File: SCIF1_LVDSo_CLK Configuration Registers (Padring_SCIF1_LVDSo_CLK)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_SCIF1_LVDSO_CLK_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: SCIF1_LVDSo_CLK Configuration Register
} PADRING_SCIF1_LVDSO_CLK_REGS_t;

//====================================================================
//
//Register File: SCIF1_LVDSi_CLK Configuration Registers (Padring_SCIF1_LVDSi_CLK)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_SCIF1_LVDSI_CLK_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: SCIF1_LVDSi_CLK Configuration Register
} PADRING_SCIF1_LVDSI_CLK_REGS_t;

//====================================================================
//
//Register File: SCIF1_LVDSi_D0 Configuration Registers (Padring_SCIF1_LVDSi_D0)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_SCIF1_LVDSI_D0_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: SCIF1_LVDSi_D0 Configuration Register
} PADRING_SCIF1_LVDSI_D0_REGS_t;

//====================================================================
//
//Register File: SCIF1_LVDSi_D1 Configuration Registers (Padring_SCIF1_LVDSi_D1)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_SCIF1_LVDSI_D1_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: SCIF1_LVDSi_D1 Configuration Register
} PADRING_SCIF1_LVDSI_D1_REGS_t;

//====================================================================
//
//Register File: SCIF1_LVDSi_D2 Configuration Registers (Padring_SCIF1_LVDSi_D2)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_SCIF1_LVDSI_D2_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: SCIF1_LVDSi_D2 Configuration Register
} PADRING_SCIF1_LVDSI_D2_REGS_t;

//====================================================================
//
//Register File: IO_PAD193 Configuration Registers (Padring_IO_PAD193)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD193_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD193 Configuration Register
} PADRING_IO_PAD193_REGS_t;

//====================================================================
//
//Register File: IO_PAD194 Configuration Registers (Padring_IO_PAD194)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD194_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD194 Configuration Register
} PADRING_IO_PAD194_REGS_t;

//====================================================================
//
//Register File: IO_PAD195 Configuration Registers (Padring_IO_PAD195)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD195_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD195 Configuration Register
} PADRING_IO_PAD195_REGS_t;

//====================================================================
//
//Register File: IO_PAD196 Configuration Registers (Padring_IO_PAD196)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD196_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD196 Configuration Register
} PADRING_IO_PAD196_REGS_t;

//====================================================================
//
//Register File: IO_PAD197 Configuration Registers (Padring_IO_PAD197)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD197_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD197 Configuration Register
} PADRING_IO_PAD197_REGS_t;

//====================================================================
//
//Register File: IO_PAD198 Configuration Registers (Padring_IO_PAD198)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD198_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD198 Configuration Register
} PADRING_IO_PAD198_REGS_t;

//====================================================================
//
//Register File: IO_PAD199 Configuration Registers (Padring_IO_PAD199)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD199_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD199 Configuration Register
} PADRING_IO_PAD199_REGS_t;

//====================================================================
//
//Register File: IO_PAD200 Configuration Registers (Padring_IO_PAD200)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD200_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD200 Configuration Register
} PADRING_IO_PAD200_REGS_t;

//====================================================================
//
//Register File: IO_PAD201 Configuration Registers (Padring_IO_PAD201)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD201_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD201 Configuration Register
} PADRING_IO_PAD201_REGS_t;

//====================================================================
//
//Register File: IO_PAD202 Configuration Registers (Padring_IO_PAD202)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD202_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD202 Configuration Register
} PADRING_IO_PAD202_REGS_t;

//====================================================================
//
//Register File: IO_PAD203 Configuration Registers (Padring_IO_PAD203)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD203_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD203 Configuration Register
} PADRING_IO_PAD203_REGS_t;

//====================================================================
//
//Register File: IO_PAD204 Configuration Registers (Padring_IO_PAD204)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD204_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD204 Configuration Register
} PADRING_IO_PAD204_REGS_t;

//====================================================================
//
//Register File: IO_PAD205 Configuration Registers (Padring_IO_PAD205)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD205_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD205 Configuration Register
} PADRING_IO_PAD205_REGS_t;

//====================================================================
//
//Register File: IO_PAD206 Configuration Registers (Padring_IO_PAD206)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD206_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD206 Configuration Register
} PADRING_IO_PAD206_REGS_t;

//====================================================================
//
//Register File: IO_PAD207 Configuration Registers (Padring_IO_PAD207)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD207_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD207 Configuration Register
} PADRING_IO_PAD207_REGS_t;

//====================================================================
//
//Register File: IO_PAD208 Configuration Registers (Padring_IO_PAD208)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD208_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD208 Configuration Register
} PADRING_IO_PAD208_REGS_t;

//====================================================================
//
//Register File: IO_PAD209 Configuration Registers (Padring_IO_PAD209)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD209_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD209 Configuration Register
} PADRING_IO_PAD209_REGS_t;

//====================================================================
//
//Register File: IO_PAD210 Configuration Registers (Padring_IO_PAD210)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD210_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD210 Configuration Register
} PADRING_IO_PAD210_REGS_t;

//====================================================================
//
//Register File: IO_PAD211 Configuration Registers (Padring_IO_PAD211)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD211_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD211 Configuration Register
} PADRING_IO_PAD211_REGS_t;

//====================================================================
//
//Register File: IO_PAD212 Configuration Registers (Padring_IO_PAD212)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD212_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD212 Configuration Register
} PADRING_IO_PAD212_REGS_t;

//====================================================================
//
//Register File: IO_PAD213 Configuration Registers (Padring_IO_PAD213)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD213_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD213 Configuration Register
} PADRING_IO_PAD213_REGS_t;

//====================================================================
//
//Register File: IO_PAD214 Configuration Registers (Padring_IO_PAD214)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD214_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD214 Configuration Register
} PADRING_IO_PAD214_REGS_t;

//====================================================================
//
//Register File: IO_PAD215 Configuration Registers (Padring_IO_PAD215)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD215_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD215 Configuration Register
} PADRING_IO_PAD215_REGS_t;

//====================================================================
//
//Register File: IO_PAD216 Configuration Registers (Padring_IO_PAD216)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD216_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD216 Configuration Register
} PADRING_IO_PAD216_REGS_t;

//====================================================================
//
//Register File: IO_PAD217 Configuration Registers (Padring_IO_PAD217)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD217_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD217 Configuration Register
} PADRING_IO_PAD217_REGS_t;

//====================================================================
//
//Register File: IO_PAD218 Configuration Registers (Padring_IO_PAD218)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD218_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD218 Configuration Register
} PADRING_IO_PAD218_REGS_t;

//====================================================================
//
//Register File: IO_PAD219 Configuration Registers (Padring_IO_PAD219)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD219_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD219 Configuration Register
} PADRING_IO_PAD219_REGS_t;

//====================================================================
//
//Register File: IO_PAD220 Configuration Registers (Padring_IO_PAD220)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD220_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD220 Configuration Register
} PADRING_IO_PAD220_REGS_t;

//====================================================================
//
//Register File: IO_PAD221 Configuration Registers (Padring_IO_PAD221)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD221_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD221 Configuration Register
} PADRING_IO_PAD221_REGS_t;

//====================================================================
//
//Register File: IO_PAD222 Configuration Registers (Padring_IO_PAD222)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD222_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD222 Configuration Register
} PADRING_IO_PAD222_REGS_t;

//====================================================================
//
//Register File: IO_PAD223 Configuration Registers (Padring_IO_PAD223)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD223_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD223 Configuration Register
} PADRING_IO_PAD223_REGS_t;

//====================================================================
//
//Register File: IO_PAD224 Configuration Registers (Padring_IO_PAD224)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD224_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD224 Configuration Register
} PADRING_IO_PAD224_REGS_t;

//====================================================================
//
//Register File: IO_PAD225 Configuration Registers (Padring_IO_PAD225)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD225_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD225 Configuration Register
} PADRING_IO_PAD225_REGS_t;

#endif // AP_APB
 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _AP_APB_REGMASKS_H_
#define _AP_APB_REGMASKS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: AP APB Top (AP_APB)
/** \brief Register Descriptions for AP APB superblock*/
//
//====================================================================

//====================================================================
//
//Register File: I2C1 Registers (I2C1)
//
//====================================================================

//====================================================================
//Register: TWSI Bus Monitor Register (TWSI_IBMR)
/** \brief The TWSI Bus Monitor register (IBMR) tracks the status of the SCL and SDA pins.
The values of these pins are recorded in this read-only IBMR, so software can
determine when the TWSI bus is hung and the TWSI unit must be reset.
This a read-only register. Ignore reads from reserved bits.*/
//====================================================================

#define  I2C1_TWSI_IBMR_RESERVED1_MASK 0xfffffffc
#define  I2C1_TWSI_IBMR_RESERVED1_SHIFT 2
#define  I2C1_TWSI_IBMR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_IBMR_RESERVED1_MASK) >> I2C1_TWSI_IBMR_RESERVED1_SHIFT)
#define  I2C1_TWSI_IBMR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_IBMR_RESERVED1_MASK) | (((uint32_t)val) << I2C1_TWSI_IBMR_RESERVED1_SHIFT))

#define  I2C1_TWSI_IBMR_SCL_MASK 0x2
#define  I2C1_TWSI_IBMR_SCL_SHIFT 1
#define  I2C1_TWSI_IBMR_SCL_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_IBMR_SCL_MASK) >> I2C1_TWSI_IBMR_SCL_SHIFT)
#define  I2C1_TWSI_IBMR_SCL_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_IBMR_SCL_MASK) | (((uint32_t)val) << I2C1_TWSI_IBMR_SCL_SHIFT))

#define  I2C1_TWSI_IBMR_SDA_MASK 0x1
#define  I2C1_TWSI_IBMR_SDA_SHIFT 0
#define  I2C1_TWSI_IBMR_SDA_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_IBMR_SDA_MASK) >> I2C1_TWSI_IBMR_SDA_SHIFT)
#define  I2C1_TWSI_IBMR_SDA_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_IBMR_SDA_MASK) | (((uint32_t)val) << I2C1_TWSI_IBMR_SDA_SHIFT))

//====================================================================
//Register: TWSI Data Buffer Register (TWSI_IDBR)
/** \brief The PXA2128 Application Processor use the TWSI Data Buffer register to transmit
and receive data from the TWSI bus. The IDBR is accessed by the program I/O on
one side and by the TWSI Shift register on the other. The IDBR receives data
coming into the TWSI unit after a full byte is received and acknowledged. The
PXA2128 Application Processor core writes data going out of the TWSI to the IDBR
and sends it to the serial bus.
When the TWSI is in transmit mode (master or slave), the PXA2128 Application
Processor writes data to the IDBR over the internal bus. The PXA2128 Application
Processor write data to the IDBR when a master transaction is initiated or when
the IDBR transmit-empty interrupt is signalled. Data moves from the IDBR to the
Shift register when the transfer byte bit is set. The IDBR transmit-empty
interrupt is signalled (if enabled) when a byte is transferred on the TWSI bus
and the acknowledge cycle is complete. If the IDBR is not written by the PXA2128
Application Processor, and a Stop condition is not in place before the TWSI bus
is ready to transfer the next byte packet, the TWSI unit inserts wait states
until the PXA2128 Application Processor writes the IDBR and sets the transfer
byte bit.
When the TWSI is in receive mode (master or slave), the PXA2128 Application
Processor reads IDBR data over the internal bus. The PXA2128 Application
Processor reads data from the IDBR when the IDBR receive-full interrupt is
signalled. The data moves from the Shift register to the IDBR when the
acknowledge cycle is complete. The TWSI inserts wait states until the IDBR is
read. See Section 12.4.6 for more information on the acknowledge pulse in
receive mode. After the software reads the IDBR, ICR[ACKNAK], and ICR[ACKNAK]
are written by the software, allowing the next byte transfer to proceed to the
TWSI bus.
These are read/write registers. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  I2C1_TWSI_IDBR_RESERVED1_MASK 0xffffff00
#define  I2C1_TWSI_IDBR_RESERVED1_SHIFT 8
#define  I2C1_TWSI_IDBR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_IDBR_RESERVED1_MASK) >> I2C1_TWSI_IDBR_RESERVED1_SHIFT)
#define  I2C1_TWSI_IDBR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_IDBR_RESERVED1_MASK) | (((uint32_t)val) << I2C1_TWSI_IDBR_RESERVED1_SHIFT))

#define  I2C1_TWSI_IDBR_DATA_BUFFER_MASK 0xff
#define  I2C1_TWSI_IDBR_DATA_BUFFER_SHIFT 0
#define  I2C1_TWSI_IDBR_DATA_BUFFER_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_IDBR_DATA_BUFFER_MASK) >> I2C1_TWSI_IDBR_DATA_BUFFER_SHIFT)
#define  I2C1_TWSI_IDBR_DATA_BUFFER_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_IDBR_DATA_BUFFER_MASK) | (((uint32_t)val) << I2C1_TWSI_IDBR_DATA_BUFFER_SHIFT))

//====================================================================
//Register: TWSI Control Register (TWSI_ICR)
/** \brief The PXA2128 Application Processor uses the bits in the TWSI Control register
(ICR) to control the TWSI unit.
These are read/write registers. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  I2C1_TWSI_ICR_RESERVED1_MASK 0x80000000
#define  I2C1_TWSI_ICR_RESERVED1_SHIFT 31
#define  I2C1_TWSI_ICR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_RESERVED1_MASK) >> I2C1_TWSI_ICR_RESERVED1_SHIFT)
#define  I2C1_TWSI_ICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_RESERVED1_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_RESERVED1_SHIFT))

#define  I2C1_TWSI_ICR_SDA_GFE_MASK 0x40000000
#define  I2C1_TWSI_ICR_SDA_GFE_SHIFT 30
#define  I2C1_TWSI_ICR_SDA_GFE_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_SDA_GFE_MASK) >> I2C1_TWSI_ICR_SDA_GFE_SHIFT)
#define  I2C1_TWSI_ICR_SDA_GFE_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_SDA_GFE_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_SDA_GFE_SHIFT))

#define  I2C1_TWSI_ICR_TXOV_IE_MASK 0x20000000
#define  I2C1_TWSI_ICR_TXOV_IE_SHIFT 29
#define  I2C1_TWSI_ICR_TXOV_IE_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_TXOV_IE_MASK) >> I2C1_TWSI_ICR_TXOV_IE_SHIFT)
#define  I2C1_TWSI_ICR_TXOV_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_TXOV_IE_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_TXOV_IE_SHIFT))

#define  I2C1_TWSI_ICR_RXUN_IE_MASK 0x10000000
#define  I2C1_TWSI_ICR_RXUN_IE_SHIFT 28
#define  I2C1_TWSI_ICR_RXUN_IE_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_RXUN_IE_MASK) >> I2C1_TWSI_ICR_RXUN_IE_SHIFT)
#define  I2C1_TWSI_ICR_RXUN_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_RXUN_IE_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_RXUN_IE_SHIFT))

#define  I2C1_TWSI_ICR_DMA_EN_MASK 0x8000000
#define  I2C1_TWSI_ICR_DMA_EN_SHIFT 27
#define  I2C1_TWSI_ICR_DMA_EN_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_DMA_EN_MASK) >> I2C1_TWSI_ICR_DMA_EN_SHIFT)
#define  I2C1_TWSI_ICR_DMA_EN_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_DMA_EN_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_DMA_EN_SHIFT))

#define  I2C1_TWSI_ICR_RXOV_IE_MASK 0x4000000
#define  I2C1_TWSI_ICR_RXOV_IE_SHIFT 26
#define  I2C1_TWSI_ICR_RXOV_IE_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_RXOV_IE_MASK) >> I2C1_TWSI_ICR_RXOV_IE_SHIFT)
#define  I2C1_TWSI_ICR_RXOV_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_RXOV_IE_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_RXOV_IE_SHIFT))

#define  I2C1_TWSI_ICR_RXF_IE_MASK 0x2000000
#define  I2C1_TWSI_ICR_RXF_IE_SHIFT 25
#define  I2C1_TWSI_ICR_RXF_IE_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_RXF_IE_MASK) >> I2C1_TWSI_ICR_RXF_IE_SHIFT)
#define  I2C1_TWSI_ICR_RXF_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_RXF_IE_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_RXF_IE_SHIFT))

#define  I2C1_TWSI_ICR_TXSR_IE_MASK 0x1000000
#define  I2C1_TWSI_ICR_TXSR_IE_SHIFT 24
#define  I2C1_TWSI_ICR_TXSR_IE_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_TXSR_IE_MASK) >> I2C1_TWSI_ICR_TXSR_IE_SHIFT)
#define  I2C1_TWSI_ICR_TXSR_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_TXSR_IE_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_TXSR_IE_SHIFT))

#define  I2C1_TWSI_ICR_RXSR_IE_MASK 0x800000
#define  I2C1_TWSI_ICR_RXSR_IE_SHIFT 23
#define  I2C1_TWSI_ICR_RXSR_IE_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_RXSR_IE_MASK) >> I2C1_TWSI_ICR_RXSR_IE_SHIFT)
#define  I2C1_TWSI_ICR_RXSR_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_RXSR_IE_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_RXSR_IE_SHIFT))

#define  I2C1_TWSI_ICR_TXDONE_IE_MASK 0x400000
#define  I2C1_TWSI_ICR_TXDONE_IE_SHIFT 22
#define  I2C1_TWSI_ICR_TXDONE_IE_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_TXDONE_IE_MASK) >> I2C1_TWSI_ICR_TXDONE_IE_SHIFT)
#define  I2C1_TWSI_ICR_TXDONE_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_TXDONE_IE_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_TXDONE_IE_SHIFT))

#define  I2C1_TWSI_ICR_TXBEGIN_MASK 0x200000
#define  I2C1_TWSI_ICR_TXBEGIN_SHIFT 21
#define  I2C1_TWSI_ICR_TXBEGIN_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_TXBEGIN_MASK) >> I2C1_TWSI_ICR_TXBEGIN_SHIFT)
#define  I2C1_TWSI_ICR_TXBEGIN_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_TXBEGIN_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_TXBEGIN_SHIFT))

#define  I2C1_TWSI_ICR_FIFOEN_MASK 0x100000
#define  I2C1_TWSI_ICR_FIFOEN_SHIFT 20
#define  I2C1_TWSI_ICR_FIFOEN_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_FIFOEN_MASK) >> I2C1_TWSI_ICR_FIFOEN_SHIFT)
#define  I2C1_TWSI_ICR_FIFOEN_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_FIFOEN_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_FIFOEN_SHIFT))

#define  I2C1_TWSI_ICR_GPIOEN_MASK 0x80000
#define  I2C1_TWSI_ICR_GPIOEN_SHIFT 19
#define  I2C1_TWSI_ICR_GPIOEN_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_GPIOEN_MASK) >> I2C1_TWSI_ICR_GPIOEN_SHIFT)
#define  I2C1_TWSI_ICR_GPIOEN_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_GPIOEN_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_GPIOEN_SHIFT))

#define  I2C1_TWSI_ICR_MSDE_MASK 0x40000
#define  I2C1_TWSI_ICR_MSDE_SHIFT 18
#define  I2C1_TWSI_ICR_MSDE_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_MSDE_MASK) >> I2C1_TWSI_ICR_MSDE_SHIFT)
#define  I2C1_TWSI_ICR_MSDE_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_MSDE_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_MSDE_SHIFT))

#define  I2C1_TWSI_ICR_MSDIE_MASK 0x20000
#define  I2C1_TWSI_ICR_MSDIE_SHIFT 17
#define  I2C1_TWSI_ICR_MSDIE_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_MSDIE_MASK) >> I2C1_TWSI_ICR_MSDIE_SHIFT)
#define  I2C1_TWSI_ICR_MSDIE_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_MSDIE_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_MSDIE_SHIFT))

#define  I2C1_TWSI_ICR_MODE_MASK 0x18000
#define  I2C1_TWSI_ICR_MODE_SHIFT 15
#define  I2C1_TWSI_ICR_MODE_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_MODE_MASK) >> I2C1_TWSI_ICR_MODE_SHIFT)
#define  I2C1_TWSI_ICR_MODE_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_MODE_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_MODE_SHIFT))

#define  I2C1_TWSI_ICR_UR_MASK 0x4000
#define  I2C1_TWSI_ICR_UR_SHIFT 14
#define  I2C1_TWSI_ICR_UR_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_UR_MASK) >> I2C1_TWSI_ICR_UR_SHIFT)
#define  I2C1_TWSI_ICR_UR_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_UR_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_UR_SHIFT))

#define  I2C1_TWSI_ICR_SADIE_MASK 0x2000
#define  I2C1_TWSI_ICR_SADIE_SHIFT 13
#define  I2C1_TWSI_ICR_SADIE_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_SADIE_MASK) >> I2C1_TWSI_ICR_SADIE_SHIFT)
#define  I2C1_TWSI_ICR_SADIE_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_SADIE_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_SADIE_SHIFT))

#define  I2C1_TWSI_ICR_ALDIE_MASK 0x1000
#define  I2C1_TWSI_ICR_ALDIE_SHIFT 12
#define  I2C1_TWSI_ICR_ALDIE_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_ALDIE_MASK) >> I2C1_TWSI_ICR_ALDIE_SHIFT)
#define  I2C1_TWSI_ICR_ALDIE_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_ALDIE_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_ALDIE_SHIFT))

#define  I2C1_TWSI_ICR_SSDIE_MASK 0x800
#define  I2C1_TWSI_ICR_SSDIE_SHIFT 11
#define  I2C1_TWSI_ICR_SSDIE_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_SSDIE_MASK) >> I2C1_TWSI_ICR_SSDIE_SHIFT)
#define  I2C1_TWSI_ICR_SSDIE_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_SSDIE_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_SSDIE_SHIFT))

#define  I2C1_TWSI_ICR_BEIE_MASK 0x400
#define  I2C1_TWSI_ICR_BEIE_SHIFT 10
#define  I2C1_TWSI_ICR_BEIE_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_BEIE_MASK) >> I2C1_TWSI_ICR_BEIE_SHIFT)
#define  I2C1_TWSI_ICR_BEIE_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_BEIE_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_BEIE_SHIFT))

#define  I2C1_TWSI_ICR_DRFIE_MASK 0x200
#define  I2C1_TWSI_ICR_DRFIE_SHIFT 9
#define  I2C1_TWSI_ICR_DRFIE_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_DRFIE_MASK) >> I2C1_TWSI_ICR_DRFIE_SHIFT)
#define  I2C1_TWSI_ICR_DRFIE_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_DRFIE_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_DRFIE_SHIFT))

#define  I2C1_TWSI_ICR_ITEIE_MASK 0x100
#define  I2C1_TWSI_ICR_ITEIE_SHIFT 8
#define  I2C1_TWSI_ICR_ITEIE_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_ITEIE_MASK) >> I2C1_TWSI_ICR_ITEIE_SHIFT)
#define  I2C1_TWSI_ICR_ITEIE_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_ITEIE_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_ITEIE_SHIFT))

#define  I2C1_TWSI_ICR_GCD_MASK 0x80
#define  I2C1_TWSI_ICR_GCD_SHIFT 7
#define  I2C1_TWSI_ICR_GCD_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_GCD_MASK) >> I2C1_TWSI_ICR_GCD_SHIFT)
#define  I2C1_TWSI_ICR_GCD_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_GCD_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_GCD_SHIFT))

#define  I2C1_TWSI_ICR_IUE_MASK 0x40
#define  I2C1_TWSI_ICR_IUE_SHIFT 6
#define  I2C1_TWSI_ICR_IUE_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_IUE_MASK) >> I2C1_TWSI_ICR_IUE_SHIFT)
#define  I2C1_TWSI_ICR_IUE_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_IUE_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_IUE_SHIFT))

#define  I2C1_TWSI_ICR_SCLE_MASK 0x20
#define  I2C1_TWSI_ICR_SCLE_SHIFT 5
#define  I2C1_TWSI_ICR_SCLE_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_SCLE_MASK) >> I2C1_TWSI_ICR_SCLE_SHIFT)
#define  I2C1_TWSI_ICR_SCLE_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_SCLE_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_SCLE_SHIFT))

#define  I2C1_TWSI_ICR_MA_MASK 0x10
#define  I2C1_TWSI_ICR_MA_SHIFT 4
#define  I2C1_TWSI_ICR_MA_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_MA_MASK) >> I2C1_TWSI_ICR_MA_SHIFT)
#define  I2C1_TWSI_ICR_MA_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_MA_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_MA_SHIFT))

#define  I2C1_TWSI_ICR_TB_MASK 0x8
#define  I2C1_TWSI_ICR_TB_SHIFT 3
#define  I2C1_TWSI_ICR_TB_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_TB_MASK) >> I2C1_TWSI_ICR_TB_SHIFT)
#define  I2C1_TWSI_ICR_TB_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_TB_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_TB_SHIFT))

#define  I2C1_TWSI_ICR_ACKNAK_MASK 0x4
#define  I2C1_TWSI_ICR_ACKNAK_SHIFT 2
#define  I2C1_TWSI_ICR_ACKNAK_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_ACKNAK_MASK) >> I2C1_TWSI_ICR_ACKNAK_SHIFT)
#define  I2C1_TWSI_ICR_ACKNAK_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_ACKNAK_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_ACKNAK_SHIFT))

#define  I2C1_TWSI_ICR_STOP_MASK 0x2
#define  I2C1_TWSI_ICR_STOP_SHIFT 1
#define  I2C1_TWSI_ICR_STOP_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_STOP_MASK) >> I2C1_TWSI_ICR_STOP_SHIFT)
#define  I2C1_TWSI_ICR_STOP_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_STOP_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_STOP_SHIFT))

#define  I2C1_TWSI_ICR_START_MASK 0x1
#define  I2C1_TWSI_ICR_START_SHIFT 0
#define  I2C1_TWSI_ICR_START_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ICR_START_MASK) >> I2C1_TWSI_ICR_START_SHIFT)
#define  I2C1_TWSI_ICR_START_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ICR_START_MASK) | (((uint32_t)val) << I2C1_TWSI_ICR_START_SHIFT))

//====================================================================
//Register: TWSI Status Register (TWSI_ISR)
/** \brief TWSI interrupts are signalled to the PXA2128 Application Processor interrupt
controller by the TWSI Interrupt Status register. Software uses the ISR bits to
check the status of the TWSI unit and bus. ISR bits (bits 9-5) are updated after
the ACK/NAK bit has completed on the TWSI bus.
The ISR is also used to clear interrupts signalled from the TWSI bus interface
unit, and include the following:
- IDBR receive full
- IDBR transmit empty
- Slave address detected
- Bus error detected
- Stop condition detect
- Arbitration lost
- The TWSI has transmitted a STOP signal when configured as a master
- Transaction is done
- Receive FIFO threshold reached
- Transmit FIFO threshold reached
- Receive FIFO is full
- Receive FIFO overrun happened
- Receive FIFO underrun happened
- Transmit FIFO overrun happened*/
//====================================================================

#define  I2C1_TWSI_ISR_RESERVED1_MASK 0xfff00000
#define  I2C1_TWSI_ISR_RESERVED1_SHIFT 20
#define  I2C1_TWSI_ISR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ISR_RESERVED1_MASK) >> I2C1_TWSI_ISR_RESERVED1_SHIFT)
#define  I2C1_TWSI_ISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ISR_RESERVED1_MASK) | (((uint32_t)val) << I2C1_TWSI_ISR_RESERVED1_SHIFT))

#define  I2C1_TWSI_ISR_TXOV_MASK 0x80000
#define  I2C1_TWSI_ISR_TXOV_SHIFT 19
#define  I2C1_TWSI_ISR_TXOV_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ISR_TXOV_MASK) >> I2C1_TWSI_ISR_TXOV_SHIFT)
#define  I2C1_TWSI_ISR_TXOV_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ISR_TXOV_MASK) | (((uint32_t)val) << I2C1_TWSI_ISR_TXOV_SHIFT))

#define  I2C1_TWSI_ISR_RXUN_MASK 0x40000
#define  I2C1_TWSI_ISR_RXUN_SHIFT 18
#define  I2C1_TWSI_ISR_RXUN_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ISR_RXUN_MASK) >> I2C1_TWSI_ISR_RXUN_SHIFT)
#define  I2C1_TWSI_ISR_RXUN_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ISR_RXUN_MASK) | (((uint32_t)val) << I2C1_TWSI_ISR_RXUN_SHIFT))

#define  I2C1_TWSI_ISR_RXOV_MASK 0x20000
#define  I2C1_TWSI_ISR_RXOV_SHIFT 17
#define  I2C1_TWSI_ISR_RXOV_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ISR_RXOV_MASK) >> I2C1_TWSI_ISR_RXOV_SHIFT)
#define  I2C1_TWSI_ISR_RXOV_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ISR_RXOV_MASK) | (((uint32_t)val) << I2C1_TWSI_ISR_RXOV_SHIFT))

#define  I2C1_TWSI_ISR_RXF_MASK 0x10000
#define  I2C1_TWSI_ISR_RXF_SHIFT 16
#define  I2C1_TWSI_ISR_RXF_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ISR_RXF_MASK) >> I2C1_TWSI_ISR_RXF_SHIFT)
#define  I2C1_TWSI_ISR_RXF_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ISR_RXF_MASK) | (((uint32_t)val) << I2C1_TWSI_ISR_RXF_SHIFT))

#define  I2C1_TWSI_ISR_TXSR_MASK 0x8000
#define  I2C1_TWSI_ISR_TXSR_SHIFT 15
#define  I2C1_TWSI_ISR_TXSR_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ISR_TXSR_MASK) >> I2C1_TWSI_ISR_TXSR_SHIFT)
#define  I2C1_TWSI_ISR_TXSR_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ISR_TXSR_MASK) | (((uint32_t)val) << I2C1_TWSI_ISR_TXSR_SHIFT))

#define  I2C1_TWSI_ISR_RXSR_MASK 0x4000
#define  I2C1_TWSI_ISR_RXSR_SHIFT 14
#define  I2C1_TWSI_ISR_RXSR_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ISR_RXSR_MASK) >> I2C1_TWSI_ISR_RXSR_SHIFT)
#define  I2C1_TWSI_ISR_RXSR_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ISR_RXSR_MASK) | (((uint32_t)val) << I2C1_TWSI_ISR_RXSR_SHIFT))

#define  I2C1_TWSI_ISR_TXDONE_MASK 0x2000
#define  I2C1_TWSI_ISR_TXDONE_SHIFT 13
#define  I2C1_TWSI_ISR_TXDONE_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ISR_TXDONE_MASK) >> I2C1_TWSI_ISR_TXDONE_SHIFT)
#define  I2C1_TWSI_ISR_TXDONE_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ISR_TXDONE_MASK) | (((uint32_t)val) << I2C1_TWSI_ISR_TXDONE_SHIFT))

#define  I2C1_TWSI_ISR_MSD_MASK 0x1000
#define  I2C1_TWSI_ISR_MSD_SHIFT 12
#define  I2C1_TWSI_ISR_MSD_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ISR_MSD_MASK) >> I2C1_TWSI_ISR_MSD_SHIFT)
#define  I2C1_TWSI_ISR_MSD_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ISR_MSD_MASK) | (((uint32_t)val) << I2C1_TWSI_ISR_MSD_SHIFT))

#define  I2C1_TWSI_ISR_EBB_MASK 0x800
#define  I2C1_TWSI_ISR_EBB_SHIFT 11
#define  I2C1_TWSI_ISR_EBB_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ISR_EBB_MASK) >> I2C1_TWSI_ISR_EBB_SHIFT)
#define  I2C1_TWSI_ISR_EBB_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ISR_EBB_MASK) | (((uint32_t)val) << I2C1_TWSI_ISR_EBB_SHIFT))

#define  I2C1_TWSI_ISR_BED_MASK 0x400
#define  I2C1_TWSI_ISR_BED_SHIFT 10
#define  I2C1_TWSI_ISR_BED_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ISR_BED_MASK) >> I2C1_TWSI_ISR_BED_SHIFT)
#define  I2C1_TWSI_ISR_BED_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ISR_BED_MASK) | (((uint32_t)val) << I2C1_TWSI_ISR_BED_SHIFT))

#define  I2C1_TWSI_ISR_SAD_MASK 0x200
#define  I2C1_TWSI_ISR_SAD_SHIFT 9
#define  I2C1_TWSI_ISR_SAD_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ISR_SAD_MASK) >> I2C1_TWSI_ISR_SAD_SHIFT)
#define  I2C1_TWSI_ISR_SAD_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ISR_SAD_MASK) | (((uint32_t)val) << I2C1_TWSI_ISR_SAD_SHIFT))

#define  I2C1_TWSI_ISR_GCAD_MASK 0x100
#define  I2C1_TWSI_ISR_GCAD_SHIFT 8
#define  I2C1_TWSI_ISR_GCAD_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ISR_GCAD_MASK) >> I2C1_TWSI_ISR_GCAD_SHIFT)
#define  I2C1_TWSI_ISR_GCAD_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ISR_GCAD_MASK) | (((uint32_t)val) << I2C1_TWSI_ISR_GCAD_SHIFT))

#define  I2C1_TWSI_ISR_IRF_MASK 0x80
#define  I2C1_TWSI_ISR_IRF_SHIFT 7
#define  I2C1_TWSI_ISR_IRF_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ISR_IRF_MASK) >> I2C1_TWSI_ISR_IRF_SHIFT)
#define  I2C1_TWSI_ISR_IRF_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ISR_IRF_MASK) | (((uint32_t)val) << I2C1_TWSI_ISR_IRF_SHIFT))

#define  I2C1_TWSI_ISR_ITE_MASK 0x40
#define  I2C1_TWSI_ISR_ITE_SHIFT 6
#define  I2C1_TWSI_ISR_ITE_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ISR_ITE_MASK) >> I2C1_TWSI_ISR_ITE_SHIFT)
#define  I2C1_TWSI_ISR_ITE_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ISR_ITE_MASK) | (((uint32_t)val) << I2C1_TWSI_ISR_ITE_SHIFT))

#define  I2C1_TWSI_ISR_ALD_MASK 0x20
#define  I2C1_TWSI_ISR_ALD_SHIFT 5
#define  I2C1_TWSI_ISR_ALD_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ISR_ALD_MASK) >> I2C1_TWSI_ISR_ALD_SHIFT)
#define  I2C1_TWSI_ISR_ALD_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ISR_ALD_MASK) | (((uint32_t)val) << I2C1_TWSI_ISR_ALD_SHIFT))

#define  I2C1_TWSI_ISR_SSD_MASK 0x10
#define  I2C1_TWSI_ISR_SSD_SHIFT 4
#define  I2C1_TWSI_ISR_SSD_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ISR_SSD_MASK) >> I2C1_TWSI_ISR_SSD_SHIFT)
#define  I2C1_TWSI_ISR_SSD_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ISR_SSD_MASK) | (((uint32_t)val) << I2C1_TWSI_ISR_SSD_SHIFT))

#define  I2C1_TWSI_ISR_IBB_MASK 0x8
#define  I2C1_TWSI_ISR_IBB_SHIFT 3
#define  I2C1_TWSI_ISR_IBB_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ISR_IBB_MASK) >> I2C1_TWSI_ISR_IBB_SHIFT)
#define  I2C1_TWSI_ISR_IBB_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ISR_IBB_MASK) | (((uint32_t)val) << I2C1_TWSI_ISR_IBB_SHIFT))

#define  I2C1_TWSI_ISR_UB_MASK 0x4
#define  I2C1_TWSI_ISR_UB_SHIFT 2
#define  I2C1_TWSI_ISR_UB_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ISR_UB_MASK) >> I2C1_TWSI_ISR_UB_SHIFT)
#define  I2C1_TWSI_ISR_UB_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ISR_UB_MASK) | (((uint32_t)val) << I2C1_TWSI_ISR_UB_SHIFT))

#define  I2C1_TWSI_ISR_ACKNAK_MASK 0x2
#define  I2C1_TWSI_ISR_ACKNAK_SHIFT 1
#define  I2C1_TWSI_ISR_ACKNAK_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ISR_ACKNAK_MASK) >> I2C1_TWSI_ISR_ACKNAK_SHIFT)
#define  I2C1_TWSI_ISR_ACKNAK_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ISR_ACKNAK_MASK) | (((uint32_t)val) << I2C1_TWSI_ISR_ACKNAK_SHIFT))

#define  I2C1_TWSI_ISR_RWM_MASK 0x1
#define  I2C1_TWSI_ISR_RWM_SHIFT 0
#define  I2C1_TWSI_ISR_RWM_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ISR_RWM_MASK) >> I2C1_TWSI_ISR_RWM_SHIFT)
#define  I2C1_TWSI_ISR_RWM_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ISR_RWM_MASK) | (((uint32_t)val) << I2C1_TWSI_ISR_RWM_SHIFT))

//====================================================================
//Register: TWSI Slave Address Register (TWSI_ISAR)
/** \brief The ISAR defines the TWSI' s seven-bit slave address. In slave-receive mode, the
PXA2128 Application Processor responds when the seven-bit address matches the
value in this register. The PXA2128 Application Processor writes this register
before it enables TWSI operations. The ISAR is fully programmable (no address is
assigned to the TWSI) so it can be set to a value other than those of hard-wired
TWSI slave peripherals in the system.
These are read/write registers. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  I2C1_TWSI_ISAR_RESERVED1_MASK 0xffffff80
#define  I2C1_TWSI_ISAR_RESERVED1_SHIFT 7
#define  I2C1_TWSI_ISAR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ISAR_RESERVED1_MASK) >> I2C1_TWSI_ISAR_RESERVED1_SHIFT)
#define  I2C1_TWSI_ISAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ISAR_RESERVED1_MASK) | (((uint32_t)val) << I2C1_TWSI_ISAR_RESERVED1_SHIFT))

#define  I2C1_TWSI_ISAR_SLAVE_ADDRESS_MASK 0x7f
#define  I2C1_TWSI_ISAR_SLAVE_ADDRESS_SHIFT 0
#define  I2C1_TWSI_ISAR_SLAVE_ADDRESS_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ISAR_SLAVE_ADDRESS_MASK) >> I2C1_TWSI_ISAR_SLAVE_ADDRESS_SHIFT)
#define  I2C1_TWSI_ISAR_SLAVE_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ISAR_SLAVE_ADDRESS_MASK) | (((uint32_t)val) << I2C1_TWSI_ISAR_SLAVE_ADDRESS_SHIFT))

//====================================================================
//Register: TWSI Load Count Register (TWSI_ILCR)
/** \brief The TWSI must generate the SCL in master mode and the Load Count Monitor
register (ILCR) allows minor adjustments to this clock. The reset value of this
register are determined based on a 32.8 MHz TWSI input clock which allows the
maximum frequency to be derived for Fast (up to 400 Kbps) and Normal mode (up
to 100 Kbps). However, due to frequency restrictions on the TWSI input clock,
the default values of ILCR only generate an SCL than can support up to 1.8 Mbps
for HS mode.
If the alternate 66 MHz TWSI input clock is selected (via writing CCU,
FUNC_CLK_SEL to 'b11 while the TWSI is not enabled), the recommended value of
ILCR to achieve the necessary Fast, Normal and High Speed SCL frequencies
is 32'h 082C_BB56. This register must also be written while the TWSI is not
enabled.
Increasing the load value decreases the SCL frequency, while decreasing the load
raises the frequency. The amount of decrease or increase is equal to one TWSI
clock period for each value.
Note: Reset values also allow the highest possible SCL frequency that still meet
the minimum requirements listed in the TWSI Bus Specification Version 2.1. This
register should be written prior to enabling the TWSI and should not be changed
during bus activity. Writing all zeros to any of the 4 individual Load Values
causes the TWSI to not generate an SCL for that particular mode when the TWSI is
configured as a master. Extreme caution must be exercised when writing this
register.*/
//====================================================================

#define  I2C1_TWSI_ILCR_HLVH_MASK 0xf8000000
#define  I2C1_TWSI_ILCR_HLVH_SHIFT 27
#define  I2C1_TWSI_ILCR_HLVH_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ILCR_HLVH_MASK) >> I2C1_TWSI_ILCR_HLVH_SHIFT)
#define  I2C1_TWSI_ILCR_HLVH_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ILCR_HLVH_MASK) | (((uint32_t)val) << I2C1_TWSI_ILCR_HLVH_SHIFT))

#define  I2C1_TWSI_ILCR_HLVL_MASK 0x7fc0000
#define  I2C1_TWSI_ILCR_HLVL_SHIFT 18
#define  I2C1_TWSI_ILCR_HLVL_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ILCR_HLVL_MASK) >> I2C1_TWSI_ILCR_HLVL_SHIFT)
#define  I2C1_TWSI_ILCR_HLVL_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ILCR_HLVL_MASK) | (((uint32_t)val) << I2C1_TWSI_ILCR_HLVL_SHIFT))

#define  I2C1_TWSI_ILCR_FLV_MASK 0x3fe00
#define  I2C1_TWSI_ILCR_FLV_SHIFT 9
#define  I2C1_TWSI_ILCR_FLV_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ILCR_FLV_MASK) >> I2C1_TWSI_ILCR_FLV_SHIFT)
#define  I2C1_TWSI_ILCR_FLV_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ILCR_FLV_MASK) | (((uint32_t)val) << I2C1_TWSI_ILCR_FLV_SHIFT))

#define  I2C1_TWSI_ILCR_SLV_MASK 0x1ff
#define  I2C1_TWSI_ILCR_SLV_SHIFT 0
#define  I2C1_TWSI_ILCR_SLV_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_ILCR_SLV_MASK) >> I2C1_TWSI_ILCR_SLV_SHIFT)
#define  I2C1_TWSI_ILCR_SLV_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_ILCR_SLV_MASK) | (((uint32_t)val) << I2C1_TWSI_ILCR_SLV_SHIFT))

//====================================================================
//Register: TWSI Wait Count Register (TWSI_IWCR)
/** \brief The TWSI Wait Count register controls the setup and hold times during standard,
fast, or high speed. This register together with the ILCR register control the
setup and hold times for all modes.*/
//====================================================================

#define  I2C1_TWSI_IWCR_RESERVED1_MASK 0xffff8000
#define  I2C1_TWSI_IWCR_RESERVED1_SHIFT 15
#define  I2C1_TWSI_IWCR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_IWCR_RESERVED1_MASK) >> I2C1_TWSI_IWCR_RESERVED1_SHIFT)
#define  I2C1_TWSI_IWCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_IWCR_RESERVED1_MASK) | (((uint32_t)val) << I2C1_TWSI_IWCR_RESERVED1_SHIFT))

#define  I2C1_TWSI_IWCR_HS_COUNT2_MASK 0x7c00
#define  I2C1_TWSI_IWCR_HS_COUNT2_SHIFT 10
#define  I2C1_TWSI_IWCR_HS_COUNT2_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_IWCR_HS_COUNT2_MASK) >> I2C1_TWSI_IWCR_HS_COUNT2_SHIFT)
#define  I2C1_TWSI_IWCR_HS_COUNT2_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_IWCR_HS_COUNT2_MASK) | (((uint32_t)val) << I2C1_TWSI_IWCR_HS_COUNT2_SHIFT))

#define  I2C1_TWSI_IWCR_HS_COUNT1_MASK 0x3e0
#define  I2C1_TWSI_IWCR_HS_COUNT1_SHIFT 5
#define  I2C1_TWSI_IWCR_HS_COUNT1_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_IWCR_HS_COUNT1_MASK) >> I2C1_TWSI_IWCR_HS_COUNT1_SHIFT)
#define  I2C1_TWSI_IWCR_HS_COUNT1_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_IWCR_HS_COUNT1_MASK) | (((uint32_t)val) << I2C1_TWSI_IWCR_HS_COUNT1_SHIFT))

#define  I2C1_TWSI_IWCR_COUNT_MASK 0x1f
#define  I2C1_TWSI_IWCR_COUNT_SHIFT 0
#define  I2C1_TWSI_IWCR_COUNT_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_IWCR_COUNT_MASK) >> I2C1_TWSI_IWCR_COUNT_SHIFT)
#define  I2C1_TWSI_IWCR_COUNT_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_IWCR_COUNT_MASK) | (((uint32_t)val) << I2C1_TWSI_IWCR_COUNT_SHIFT))

//====================================================================
//Register: TWSI Write FIFO Register (TWSI_WFIFO)
/** \brief The TWSI Write FIFO has 16 entries and each entry is 12-bit wide (4-bit control
+ 8-bit data). This FIFO can be filled up in PIO or DMA mode. Whenever this FIFO
threshold is reached, an interrupt or a dma request is generated.*/
//====================================================================

#define  I2C1_TWSI_WFIFO_RESERVED1_MASK 0xfffff000
#define  I2C1_TWSI_WFIFO_RESERVED1_SHIFT 12
#define  I2C1_TWSI_WFIFO_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_WFIFO_RESERVED1_MASK) >> I2C1_TWSI_WFIFO_RESERVED1_SHIFT)
#define  I2C1_TWSI_WFIFO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_WFIFO_RESERVED1_MASK) | (((uint32_t)val) << I2C1_TWSI_WFIFO_RESERVED1_SHIFT))

#define  I2C1_TWSI_WFIFO_CONTROL_MASK 0xf00
#define  I2C1_TWSI_WFIFO_CONTROL_SHIFT 8
#define  I2C1_TWSI_WFIFO_CONTROL_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_WFIFO_CONTROL_MASK) >> I2C1_TWSI_WFIFO_CONTROL_SHIFT)
#define  I2C1_TWSI_WFIFO_CONTROL_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_WFIFO_CONTROL_MASK) | (((uint32_t)val) << I2C1_TWSI_WFIFO_CONTROL_SHIFT))

#define  I2C1_TWSI_WFIFO_DATA_MASK 0xff
#define  I2C1_TWSI_WFIFO_DATA_SHIFT 0
#define  I2C1_TWSI_WFIFO_DATA_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_WFIFO_DATA_MASK) >> I2C1_TWSI_WFIFO_DATA_SHIFT)
#define  I2C1_TWSI_WFIFO_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_WFIFO_DATA_MASK) | (((uint32_t)val) << I2C1_TWSI_WFIFO_DATA_SHIFT))

//====================================================================
//Register: TWSI Write FIFO Write Pointer Register (TWSI_WFIFO_WPTR)
/** \brief The TWSI Write FIFO Pointer has the TX FIFO write entry location information.
This is a read/write register. Software can write 0 to it when it wishes to
flush the FIFO after interrupts like Bus error, Arbitration loss, etc.*/
//====================================================================

#define  I2C1_TWSI_WFIFO_WPTR_RESERVED1_MASK 0xffffffe0
#define  I2C1_TWSI_WFIFO_WPTR_RESERVED1_SHIFT 5
#define  I2C1_TWSI_WFIFO_WPTR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_WFIFO_WPTR_RESERVED1_MASK) >> I2C1_TWSI_WFIFO_WPTR_RESERVED1_SHIFT)
#define  I2C1_TWSI_WFIFO_WPTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_WFIFO_WPTR_RESERVED1_MASK) | (((uint32_t)val) << I2C1_TWSI_WFIFO_WPTR_RESERVED1_SHIFT))

#define  I2C1_TWSI_WFIFO_WPTR_DATA_MASK 0x1f
#define  I2C1_TWSI_WFIFO_WPTR_DATA_SHIFT 0
#define  I2C1_TWSI_WFIFO_WPTR_DATA_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_WFIFO_WPTR_DATA_MASK) >> I2C1_TWSI_WFIFO_WPTR_DATA_SHIFT)
#define  I2C1_TWSI_WFIFO_WPTR_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_WFIFO_WPTR_DATA_MASK) | (((uint32_t)val) << I2C1_TWSI_WFIFO_WPTR_DATA_SHIFT))

//====================================================================
//Register: TWSI Write FIFO Read Pointer Register (TWSI_WFIFO_RPTR)
/** \brief The TWSI Write FIFO Read Pointer has the TX FIFO read entry location
information. This is a read/write register. Software can write 0 to it when it
wishes to flush the FIFO after an interrupt.*/
//====================================================================

#define  I2C1_TWSI_WFIFO_RPTR_RESERVED1_MASK 0xffffffe0
#define  I2C1_TWSI_WFIFO_RPTR_RESERVED1_SHIFT 5
#define  I2C1_TWSI_WFIFO_RPTR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_WFIFO_RPTR_RESERVED1_MASK) >> I2C1_TWSI_WFIFO_RPTR_RESERVED1_SHIFT)
#define  I2C1_TWSI_WFIFO_RPTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_WFIFO_RPTR_RESERVED1_MASK) | (((uint32_t)val) << I2C1_TWSI_WFIFO_RPTR_RESERVED1_SHIFT))

#define  I2C1_TWSI_WFIFO_RPTR_DATA_MASK 0x1f
#define  I2C1_TWSI_WFIFO_RPTR_DATA_SHIFT 0
#define  I2C1_TWSI_WFIFO_RPTR_DATA_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_WFIFO_RPTR_DATA_MASK) >> I2C1_TWSI_WFIFO_RPTR_DATA_SHIFT)
#define  I2C1_TWSI_WFIFO_RPTR_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_WFIFO_RPTR_DATA_MASK) | (((uint32_t)val) << I2C1_TWSI_WFIFO_RPTR_DATA_SHIFT))

//====================================================================
//Register: TWSI Read FIFO Register (TWSI_RFIFO)
/** \brief The TWSI Read FIFO has 16 entries and each entry is 8-bit wide (8-bit data).
This FIFO can be emptied in PIO or DMA mode. Whenever this FIFO is half full, an
interrupt or a dma request is generated.*/
//====================================================================

#define  I2C1_TWSI_RFIFO_RESERVED1_MASK 0xffffff00
#define  I2C1_TWSI_RFIFO_RESERVED1_SHIFT 8
#define  I2C1_TWSI_RFIFO_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_RFIFO_RESERVED1_MASK) >> I2C1_TWSI_RFIFO_RESERVED1_SHIFT)
#define  I2C1_TWSI_RFIFO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_RFIFO_RESERVED1_MASK) | (((uint32_t)val) << I2C1_TWSI_RFIFO_RESERVED1_SHIFT))

#define  I2C1_TWSI_RFIFO_DATA_MASK 0xff
#define  I2C1_TWSI_RFIFO_DATA_SHIFT 0
#define  I2C1_TWSI_RFIFO_DATA_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_RFIFO_DATA_MASK) >> I2C1_TWSI_RFIFO_DATA_SHIFT)
#define  I2C1_TWSI_RFIFO_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_RFIFO_DATA_MASK) | (((uint32_t)val) << I2C1_TWSI_RFIFO_DATA_SHIFT))

//====================================================================
//Register: TWSI Read FIFO Write Pointer Register (TWSI_RFIFO_WPTR)
/** \brief The TWSI Read FIFO Write Pointer has the RX FIFO write entry location
information. This is a read/write register. Software can write 0 to it when it
wishes to flush the FIFO after interrupts like Bus error, Arbitration loss, etc.*/
//====================================================================

#define  I2C1_TWSI_RFIFO_WPTR_RESERVED1_MASK 0xffffffe0
#define  I2C1_TWSI_RFIFO_WPTR_RESERVED1_SHIFT 5
#define  I2C1_TWSI_RFIFO_WPTR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_RFIFO_WPTR_RESERVED1_MASK) >> I2C1_TWSI_RFIFO_WPTR_RESERVED1_SHIFT)
#define  I2C1_TWSI_RFIFO_WPTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_RFIFO_WPTR_RESERVED1_MASK) | (((uint32_t)val) << I2C1_TWSI_RFIFO_WPTR_RESERVED1_SHIFT))

#define  I2C1_TWSI_RFIFO_WPTR_DATA_MASK 0x1f
#define  I2C1_TWSI_RFIFO_WPTR_DATA_SHIFT 0
#define  I2C1_TWSI_RFIFO_WPTR_DATA_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_RFIFO_WPTR_DATA_MASK) >> I2C1_TWSI_RFIFO_WPTR_DATA_SHIFT)
#define  I2C1_TWSI_RFIFO_WPTR_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_RFIFO_WPTR_DATA_MASK) | (((uint32_t)val) << I2C1_TWSI_RFIFO_WPTR_DATA_SHIFT))

//====================================================================
//Register: TWSI Read FIFO Read Pointer Register (TWSI_RFIFO_RPTR)
/** \brief The TWSI Read FIFO Read Pointer has the RX FIFO read entry location information.
This is a read/write register. Software can write 0 to it when it wishes to
flush the FIFO after an interrupt.*/
//====================================================================

#define  I2C1_TWSI_RFIFO_RPTR_RESERVED1_MASK 0xffffffe0
#define  I2C1_TWSI_RFIFO_RPTR_RESERVED1_SHIFT 5
#define  I2C1_TWSI_RFIFO_RPTR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_RFIFO_RPTR_RESERVED1_MASK) >> I2C1_TWSI_RFIFO_RPTR_RESERVED1_SHIFT)
#define  I2C1_TWSI_RFIFO_RPTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_RFIFO_RPTR_RESERVED1_MASK) | (((uint32_t)val) << I2C1_TWSI_RFIFO_RPTR_RESERVED1_SHIFT))

#define  I2C1_TWSI_RFIFO_RPTR_DATA_MASK 0x1f
#define  I2C1_TWSI_RFIFO_RPTR_DATA_SHIFT 0
#define  I2C1_TWSI_RFIFO_RPTR_DATA_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_RFIFO_RPTR_DATA_MASK) >> I2C1_TWSI_RFIFO_RPTR_DATA_SHIFT)
#define  I2C1_TWSI_RFIFO_RPTR_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_RFIFO_RPTR_DATA_MASK) | (((uint32_t)val) << I2C1_TWSI_RFIFO_RPTR_DATA_SHIFT))

//====================================================================
//Register: TWSI FIFO Threshold Register (TWSI_FIFO_TSHLD)
/** \brief The FIFO threshold register had the threshold values for TXFIFO and RXFIFO. It
is a read/write register. The default values are 0(empty) for TXFIFO and 8(half
full) for RXFIFO.*/
//====================================================================

#define  I2C1_TWSI_FIFO_TSHLD_RESERVED1_MASK 0xffe00000
#define  I2C1_TWSI_FIFO_TSHLD_RESERVED1_SHIFT 21
#define  I2C1_TWSI_FIFO_TSHLD_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_FIFO_TSHLD_RESERVED1_MASK) >> I2C1_TWSI_FIFO_TSHLD_RESERVED1_SHIFT)
#define  I2C1_TWSI_FIFO_TSHLD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_FIFO_TSHLD_RESERVED1_MASK) | (((uint32_t)val) << I2C1_TWSI_FIFO_TSHLD_RESERVED1_SHIFT))

#define  I2C1_TWSI_FIFO_TSHLD_RX_MASK 0x1f0000
#define  I2C1_TWSI_FIFO_TSHLD_RX_SHIFT 16
#define  I2C1_TWSI_FIFO_TSHLD_RX_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_FIFO_TSHLD_RX_MASK) >> I2C1_TWSI_FIFO_TSHLD_RX_SHIFT)
#define  I2C1_TWSI_FIFO_TSHLD_RX_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_FIFO_TSHLD_RX_MASK) | (((uint32_t)val) << I2C1_TWSI_FIFO_TSHLD_RX_SHIFT))

#define  I2C1_TWSI_FIFO_TSHLD_RESERVED2_MASK 0xffe0
#define  I2C1_TWSI_FIFO_TSHLD_RESERVED2_SHIFT 5
#define  I2C1_TWSI_FIFO_TSHLD_RESERVED2_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_FIFO_TSHLD_RESERVED2_MASK) >> I2C1_TWSI_FIFO_TSHLD_RESERVED2_SHIFT)
#define  I2C1_TWSI_FIFO_TSHLD_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_FIFO_TSHLD_RESERVED2_MASK) | (((uint32_t)val) << I2C1_TWSI_FIFO_TSHLD_RESERVED2_SHIFT))

#define  I2C1_TWSI_FIFO_TSHLD_TX_MASK 0x1f
#define  I2C1_TWSI_FIFO_TSHLD_TX_SHIFT 0
#define  I2C1_TWSI_FIFO_TSHLD_TX_MASK_SHIFT(reg) (((reg) & I2C1_TWSI_FIFO_TSHLD_TX_MASK) >> I2C1_TWSI_FIFO_TSHLD_TX_SHIFT)
#define  I2C1_TWSI_FIFO_TSHLD_TX_REPLACE_VAL(reg,val) (((reg) & ~I2C1_TWSI_FIFO_TSHLD_TX_MASK) | (((uint32_t)val) << I2C1_TWSI_FIFO_TSHLD_TX_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  I2C1_REV0_MAJ_MASK 0xffff0000
#define  I2C1_REV0_MAJ_SHIFT 16
#define  I2C1_REV0_MAJ_MASK_SHIFT(reg) (((reg) & I2C1_REV0_MAJ_MASK) >> I2C1_REV0_MAJ_SHIFT)
#define  I2C1_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~I2C1_REV0_MAJ_MASK) | (((uint32_t)val) << I2C1_REV0_MAJ_SHIFT))

#define  I2C1_REV0_MID_MASK 0xffff
#define  I2C1_REV0_MID_SHIFT 0
#define  I2C1_REV0_MID_MASK_SHIFT(reg) (((reg) & I2C1_REV0_MID_MASK) >> I2C1_REV0_MID_SHIFT)
#define  I2C1_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~I2C1_REV0_MID_MASK) | (((uint32_t)val) << I2C1_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  I2C1_REV1_RESERVED1_MASK 0xffff0000
#define  I2C1_REV1_RESERVED1_SHIFT 16
#define  I2C1_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C1_REV1_RESERVED1_MASK) >> I2C1_REV1_RESERVED1_SHIFT)
#define  I2C1_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C1_REV1_RESERVED1_MASK) | (((uint32_t)val) << I2C1_REV1_RESERVED1_SHIFT))

#define  I2C1_REV1_CFG_MASK 0xffff
#define  I2C1_REV1_CFG_SHIFT 0
#define  I2C1_REV1_CFG_MASK_SHIFT(reg) (((reg) & I2C1_REV1_CFG_MASK) >> I2C1_REV1_CFG_SHIFT)
#define  I2C1_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~I2C1_REV1_CFG_MASK) | (((uint32_t)val) << I2C1_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: One Wire Registers (OWI)
/** \brief Registers for the 1-Wire Bus Master block*/
//
//====================================================================

//====================================================================
//Register: OneWire Command Register (W1CMDR)
/** \brief Using this this register, the 1-Wire Master can generate two special commands on the bus (1-Wire Reset and Seach ROM Accelerator) or firmware can directly drive the bus. Note that for normal Reading or Writing a byte on the bus, firmware should use the W1TRR Transmit/Receive Buffer Register.*/
//====================================================================

#define  OWI_W1CMDR_RESERVED1_MASK 0xfffffff0
#define  OWI_W1CMDR_RESERVED1_SHIFT 4
#define  OWI_W1CMDR_RESERVED1_MASK_SHIFT(reg) (((reg) & OWI_W1CMDR_RESERVED1_MASK) >> OWI_W1CMDR_RESERVED1_SHIFT)
#define  OWI_W1CMDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1CMDR_RESERVED1_MASK) | (((uint32_t)val) << OWI_W1CMDR_RESERVED1_SHIFT))

#define  OWI_W1CMDR_DQI_MASK 0x8
#define  OWI_W1CMDR_DQI_SHIFT 3
#define  OWI_W1CMDR_DQI_MASK_SHIFT(reg) (((reg) & OWI_W1CMDR_DQI_MASK) >> OWI_W1CMDR_DQI_SHIFT)
#define  OWI_W1CMDR_DQI_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1CMDR_DQI_MASK) | (((uint32_t)val) << OWI_W1CMDR_DQI_SHIFT))

#define  OWI_W1CMDR_DQO_MASK 0x4
#define  OWI_W1CMDR_DQO_SHIFT 2
#define  OWI_W1CMDR_DQO_MASK_SHIFT(reg) (((reg) & OWI_W1CMDR_DQO_MASK) >> OWI_W1CMDR_DQO_SHIFT)
#define  OWI_W1CMDR_DQO_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1CMDR_DQO_MASK) | (((uint32_t)val) << OWI_W1CMDR_DQO_SHIFT))

#define  OWI_W1CMDR_SRA_MASK 0x2
#define  OWI_W1CMDR_SRA_SHIFT 1
#define  OWI_W1CMDR_SRA_MASK_SHIFT(reg) (((reg) & OWI_W1CMDR_SRA_MASK) >> OWI_W1CMDR_SRA_SHIFT)
#define  OWI_W1CMDR_SRA_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1CMDR_SRA_MASK) | (((uint32_t)val) << OWI_W1CMDR_SRA_SHIFT))

#define  OWI_W1CMDR_BUSRESET_MASK 0x1
#define  OWI_W1CMDR_BUSRESET_SHIFT 0
#define  OWI_W1CMDR_BUSRESET_MASK_SHIFT(reg) (((reg) & OWI_W1CMDR_BUSRESET_MASK) >> OWI_W1CMDR_BUSRESET_SHIFT)
#define  OWI_W1CMDR_BUSRESET_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1CMDR_BUSRESET_MASK) | (((uint32_t)val) << OWI_W1CMDR_BUSRESET_SHIFT))

//====================================================================
//Register: OneWire Transmit/Receive Buffer (W1TRR)
/** \brief Data sent and received from the 1-Wire bus Master passes through this transmit/receive buffer location. The 1-Wire Master is double-buffered with separate transmit and receive buffers. Writing to this location connects the transmit buffer to the 1-Wire bus, while reading connects the receive buffer to the 1-Wire bus.*/
//====================================================================

#define  OWI_W1TRR_RESERVED1_MASK 0xffffff00
#define  OWI_W1TRR_RESERVED1_SHIFT 8
#define  OWI_W1TRR_RESERVED1_MASK_SHIFT(reg) (((reg) & OWI_W1TRR_RESERVED1_MASK) >> OWI_W1TRR_RESERVED1_SHIFT)
#define  OWI_W1TRR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1TRR_RESERVED1_MASK) | (((uint32_t)val) << OWI_W1TRR_RESERVED1_SHIFT))

#define  OWI_W1TRR_DATA_MASK 0xff
#define  OWI_W1TRR_DATA_SHIFT 0
#define  OWI_W1TRR_DATA_MASK_SHIFT(reg) (((reg) & OWI_W1TRR_DATA_MASK) >> OWI_W1TRR_DATA_SHIFT)
#define  OWI_W1TRR_DATA_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1TRR_DATA_MASK) | (((uint32_t)val) << OWI_W1TRR_DATA_SHIFT))

//====================================================================
//Register: OneWire Interrupt Register (W1INTR)
/** \brief This read-only register contains flags from transmit, receive, and 1-Wire reset operations.<BR>
            The Presence Detect (PD) flag, OW_LOW and OW_SHORT bits are self-cleared when the W1INTR Interrupt Register is read. The other flag bits are cleared automatically when the transmit and receive buffers are written to or read from.<BR>
            These flags can generate an interrupt if the corresponding enable bit is set in the W1IER Interrupt Enable register.<BR> <BR>
            IMPORTANT NOTE: Reading this register will always clear the [physical] interrupt output line of the 1-Wire Master, even if all flags are not cleared!*/
//====================================================================

#define  OWI_W1INTR_RESERVED1_MASK 0xffffff00
#define  OWI_W1INTR_RESERVED1_SHIFT 8
#define  OWI_W1INTR_RESERVED1_MASK_SHIFT(reg) (((reg) & OWI_W1INTR_RESERVED1_MASK) >> OWI_W1INTR_RESERVED1_SHIFT)
#define  OWI_W1INTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1INTR_RESERVED1_MASK) | (((uint32_t)val) << OWI_W1INTR_RESERVED1_SHIFT))

#define  OWI_W1INTR_OW_LOW_MASK 0x80
#define  OWI_W1INTR_OW_LOW_SHIFT 7
#define  OWI_W1INTR_OW_LOW_MASK_SHIFT(reg) (((reg) & OWI_W1INTR_OW_LOW_MASK) >> OWI_W1INTR_OW_LOW_SHIFT)
#define  OWI_W1INTR_OW_LOW_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1INTR_OW_LOW_MASK) | (((uint32_t)val) << OWI_W1INTR_OW_LOW_SHIFT))

#define  OWI_W1INTR_OW_SHORT_MASK 0x40
#define  OWI_W1INTR_OW_SHORT_SHIFT 6
#define  OWI_W1INTR_OW_SHORT_MASK_SHIFT(reg) (((reg) & OWI_W1INTR_OW_SHORT_MASK) >> OWI_W1INTR_OW_SHORT_SHIFT)
#define  OWI_W1INTR_OW_SHORT_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1INTR_OW_SHORT_MASK) | (((uint32_t)val) << OWI_W1INTR_OW_SHORT_SHIFT))

#define  OWI_W1INTR_RSRF_MASK 0x20
#define  OWI_W1INTR_RSRF_SHIFT 5
#define  OWI_W1INTR_RSRF_MASK_SHIFT(reg) (((reg) & OWI_W1INTR_RSRF_MASK) >> OWI_W1INTR_RSRF_SHIFT)
#define  OWI_W1INTR_RSRF_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1INTR_RSRF_MASK) | (((uint32_t)val) << OWI_W1INTR_RSRF_SHIFT))

#define  OWI_W1INTR_RBF_MASK 0x10
#define  OWI_W1INTR_RBF_SHIFT 4
#define  OWI_W1INTR_RBF_MASK_SHIFT(reg) (((reg) & OWI_W1INTR_RBF_MASK) >> OWI_W1INTR_RBF_SHIFT)
#define  OWI_W1INTR_RBF_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1INTR_RBF_MASK) | (((uint32_t)val) << OWI_W1INTR_RBF_SHIFT))

#define  OWI_W1INTR_TEMT_MASK 0x8
#define  OWI_W1INTR_TEMT_SHIFT 3
#define  OWI_W1INTR_TEMT_MASK_SHIFT(reg) (((reg) & OWI_W1INTR_TEMT_MASK) >> OWI_W1INTR_TEMT_SHIFT)
#define  OWI_W1INTR_TEMT_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1INTR_TEMT_MASK) | (((uint32_t)val) << OWI_W1INTR_TEMT_SHIFT))

#define  OWI_W1INTR_TBE_MASK 0x4
#define  OWI_W1INTR_TBE_SHIFT 2
#define  OWI_W1INTR_TBE_MASK_SHIFT(reg) (((reg) & OWI_W1INTR_TBE_MASK) >> OWI_W1INTR_TBE_SHIFT)
#define  OWI_W1INTR_TBE_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1INTR_TBE_MASK) | (((uint32_t)val) << OWI_W1INTR_TBE_SHIFT))

#define  OWI_W1INTR_PDR_MASK 0x2
#define  OWI_W1INTR_PDR_SHIFT 1
#define  OWI_W1INTR_PDR_MASK_SHIFT(reg) (((reg) & OWI_W1INTR_PDR_MASK) >> OWI_W1INTR_PDR_SHIFT)
#define  OWI_W1INTR_PDR_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1INTR_PDR_MASK) | (((uint32_t)val) << OWI_W1INTR_PDR_SHIFT))

#define  OWI_W1INTR_PD_MASK 0x1
#define  OWI_W1INTR_PD_SHIFT 0
#define  OWI_W1INTR_PD_MASK_SHIFT(reg) (((reg) & OWI_W1INTR_PD_MASK) >> OWI_W1INTR_PD_SHIFT)
#define  OWI_W1INTR_PD_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1INTR_PD_MASK) | (((uint32_t)val) << OWI_W1INTR_PD_SHIFT))

//====================================================================
//Register: OneWire Interrupt Enable Register (W1IER)
/** \brief This register allows system programmers to specify which of the interrupt sources causes an interrupt.*/
//====================================================================

#define  OWI_W1IER_RESERVED1_MASK 0xffffff00
#define  OWI_W1IER_RESERVED1_SHIFT 8
#define  OWI_W1IER_RESERVED1_MASK_SHIFT(reg) (((reg) & OWI_W1IER_RESERVED1_MASK) >> OWI_W1IER_RESERVED1_SHIFT)
#define  OWI_W1IER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1IER_RESERVED1_MASK) | (((uint32_t)val) << OWI_W1IER_RESERVED1_SHIFT))

#define  OWI_W1IER_EOWL_MASK 0x80
#define  OWI_W1IER_EOWL_SHIFT 7
#define  OWI_W1IER_EOWL_MASK_SHIFT(reg) (((reg) & OWI_W1IER_EOWL_MASK) >> OWI_W1IER_EOWL_SHIFT)
#define  OWI_W1IER_EOWL_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1IER_EOWL_MASK) | (((uint32_t)val) << OWI_W1IER_EOWL_SHIFT))

#define  OWI_W1IER_EOWSH_MASK 0x40
#define  OWI_W1IER_EOWSH_SHIFT 6
#define  OWI_W1IER_EOWSH_MASK_SHIFT(reg) (((reg) & OWI_W1IER_EOWSH_MASK) >> OWI_W1IER_EOWSH_SHIFT)
#define  OWI_W1IER_EOWSH_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1IER_EOWSH_MASK) | (((uint32_t)val) << OWI_W1IER_EOWSH_SHIFT))

#define  OWI_W1IER_ERSF_MASK 0x20
#define  OWI_W1IER_ERSF_SHIFT 5
#define  OWI_W1IER_ERSF_MASK_SHIFT(reg) (((reg) & OWI_W1IER_ERSF_MASK) >> OWI_W1IER_ERSF_SHIFT)
#define  OWI_W1IER_ERSF_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1IER_ERSF_MASK) | (((uint32_t)val) << OWI_W1IER_ERSF_SHIFT))

#define  OWI_W1IER_ERBF_MASK 0x10
#define  OWI_W1IER_ERBF_SHIFT 4
#define  OWI_W1IER_ERBF_MASK_SHIFT(reg) (((reg) & OWI_W1IER_ERBF_MASK) >> OWI_W1IER_ERBF_SHIFT)
#define  OWI_W1IER_ERBF_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1IER_ERBF_MASK) | (((uint32_t)val) << OWI_W1IER_ERBF_SHIFT))

#define  OWI_W1IER_ETMT_MASK 0x8
#define  OWI_W1IER_ETMT_SHIFT 3
#define  OWI_W1IER_ETMT_MASK_SHIFT(reg) (((reg) & OWI_W1IER_ETMT_MASK) >> OWI_W1IER_ETMT_SHIFT)
#define  OWI_W1IER_ETMT_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1IER_ETMT_MASK) | (((uint32_t)val) << OWI_W1IER_ETMT_SHIFT))

#define  OWI_W1IER_ETBE_MASK 0x4
#define  OWI_W1IER_ETBE_SHIFT 2
#define  OWI_W1IER_ETBE_MASK_SHIFT(reg) (((reg) & OWI_W1IER_ETBE_MASK) >> OWI_W1IER_ETBE_SHIFT)
#define  OWI_W1IER_ETBE_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1IER_ETBE_MASK) | (((uint32_t)val) << OWI_W1IER_ETBE_SHIFT))

#define  OWI_W1IER_RESERVED2_MASK 0x2
#define  OWI_W1IER_RESERVED2_SHIFT 1
#define  OWI_W1IER_RESERVED2_MASK_SHIFT(reg) (((reg) & OWI_W1IER_RESERVED2_MASK) >> OWI_W1IER_RESERVED2_SHIFT)
#define  OWI_W1IER_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1IER_RESERVED2_MASK) | (((uint32_t)val) << OWI_W1IER_RESERVED2_SHIFT))

#define  OWI_W1IER_EPD_MASK 0x1
#define  OWI_W1IER_EPD_SHIFT 0
#define  OWI_W1IER_EPD_MASK_SHIFT(reg) (((reg) & OWI_W1IER_EPD_MASK) >> OWI_W1IER_EPD_SHIFT)
#define  OWI_W1IER_EPD_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1IER_EPD_MASK) | (((uint32_t)val) << OWI_W1IER_EPD_SHIFT))

//====================================================================
//Register: OneWire Control Register (W1CTRL)
/** \brief This register controls the functionality of the 1-Wire bus master controller.*/
//====================================================================

#define  OWI_W1CTRL_RESERVED1_MASK 0xffffff80
#define  OWI_W1CTRL_RESERVED1_SHIFT 7
#define  OWI_W1CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & OWI_W1CTRL_RESERVED1_MASK) >> OWI_W1CTRL_RESERVED1_SHIFT)
#define  OWI_W1CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1CTRL_RESERVED1_MASK) | (((uint32_t)val) << OWI_W1CTRL_RESERVED1_SHIFT))

#define  OWI_W1CTRL_OD_MASK 0x40
#define  OWI_W1CTRL_OD_SHIFT 6
#define  OWI_W1CTRL_OD_MASK_SHIFT(reg) (((reg) & OWI_W1CTRL_OD_MASK) >> OWI_W1CTRL_OD_SHIFT)
#define  OWI_W1CTRL_OD_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1CTRL_OD_MASK) | (((uint32_t)val) << OWI_W1CTRL_OD_SHIFT))

#define  OWI_W1CTRL_BIT_CTL_MASK 0x20
#define  OWI_W1CTRL_BIT_CTL_SHIFT 5
#define  OWI_W1CTRL_BIT_CTL_MASK_SHIFT(reg) (((reg) & OWI_W1CTRL_BIT_CTL_MASK) >> OWI_W1CTRL_BIT_CTL_SHIFT)
#define  OWI_W1CTRL_BIT_CTL_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1CTRL_BIT_CTL_MASK) | (((uint32_t)val) << OWI_W1CTRL_BIT_CTL_SHIFT))

#define  OWI_W1CTRL_STP_SPLY_MASK 0x10
#define  OWI_W1CTRL_STP_SPLY_SHIFT 4
#define  OWI_W1CTRL_STP_SPLY_MASK_SHIFT(reg) (((reg) & OWI_W1CTRL_STP_SPLY_MASK) >> OWI_W1CTRL_STP_SPLY_SHIFT)
#define  OWI_W1CTRL_STP_SPLY_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1CTRL_STP_SPLY_MASK) | (((uint32_t)val) << OWI_W1CTRL_STP_SPLY_SHIFT))

#define  OWI_W1CTRL_STPEN_MASK 0x8
#define  OWI_W1CTRL_STPEN_SHIFT 3
#define  OWI_W1CTRL_STPEN_MASK_SHIFT(reg) (((reg) & OWI_W1CTRL_STPEN_MASK) >> OWI_W1CTRL_STPEN_SHIFT)
#define  OWI_W1CTRL_STPEN_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1CTRL_STPEN_MASK) | (((uint32_t)val) << OWI_W1CTRL_STPEN_SHIFT))

#define  OWI_W1CTRL_EN_FOW_MASK 0x4
#define  OWI_W1CTRL_EN_FOW_SHIFT 2
#define  OWI_W1CTRL_EN_FOW_MASK_SHIFT(reg) (((reg) & OWI_W1CTRL_EN_FOW_MASK) >> OWI_W1CTRL_EN_FOW_SHIFT)
#define  OWI_W1CTRL_EN_FOW_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1CTRL_EN_FOW_MASK) | (((uint32_t)val) << OWI_W1CTRL_EN_FOW_SHIFT))

#define  OWI_W1CTRL_PPM_MASK 0x2
#define  OWI_W1CTRL_PPM_SHIFT 1
#define  OWI_W1CTRL_PPM_MASK_SHIFT(reg) (((reg) & OWI_W1CTRL_PPM_MASK) >> OWI_W1CTRL_PPM_SHIFT)
#define  OWI_W1CTRL_PPM_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1CTRL_PPM_MASK) | (((uint32_t)val) << OWI_W1CTRL_PPM_SHIFT))

#define  OWI_W1CTRL_LLM_MASK 0x1
#define  OWI_W1CTRL_LLM_SHIFT 0
#define  OWI_W1CTRL_LLM_MASK_SHIFT(reg) (((reg) & OWI_W1CTRL_LLM_MASK) >> OWI_W1CTRL_LLM_SHIFT)
#define  OWI_W1CTRL_LLM_REPLACE_VAL(reg,val) (((reg) & ~OWI_W1CTRL_LLM_MASK) | (((uint32_t)val) << OWI_W1CTRL_LLM_SHIFT))

//====================================================================
//
//Register File: JTAG SW Registers (JTAG_SW)
//
//====================================================================

//====================================================================
//Register: Enable Software JTAG Register (JTAGSW_EN)
//====================================================================

#define  JTAG_SW_JTAGSW_EN_RESERVED1_MASK 0xfffffffe
#define  JTAG_SW_JTAGSW_EN_RESERVED1_SHIFT 1
#define  JTAG_SW_JTAGSW_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & JTAG_SW_JTAGSW_EN_RESERVED1_MASK) >> JTAG_SW_JTAGSW_EN_RESERVED1_SHIFT)
#define  JTAG_SW_JTAGSW_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JTAG_SW_JTAGSW_EN_RESERVED1_MASK) | (((uint32_t)val) << JTAG_SW_JTAGSW_EN_RESERVED1_SHIFT))

#define  JTAG_SW_JTAGSW_EN_EN_MUX_JTG_SOFT_MASK 0x1
#define  JTAG_SW_JTAGSW_EN_EN_MUX_JTG_SOFT_SHIFT 0
#define  JTAG_SW_JTAGSW_EN_EN_MUX_JTG_SOFT_MASK_SHIFT(reg) (((reg) & JTAG_SW_JTAGSW_EN_EN_MUX_JTG_SOFT_MASK) >> JTAG_SW_JTAGSW_EN_EN_MUX_JTG_SOFT_SHIFT)
#define  JTAG_SW_JTAGSW_EN_EN_MUX_JTG_SOFT_REPLACE_VAL(reg,val) (((reg) & ~JTAG_SW_JTAGSW_EN_EN_MUX_JTG_SOFT_MASK) | (((uint32_t)val) << JTAG_SW_JTAGSW_EN_EN_MUX_JTG_SOFT_SHIFT))

//====================================================================
//Register: Software JTAG Control Register (JTAGSW_CTRL)
//====================================================================

#define  JTAG_SW_JTAGSW_CTRL_RESERVED1_MASK 0xfffffff0
#define  JTAG_SW_JTAGSW_CTRL_RESERVED1_SHIFT 4
#define  JTAG_SW_JTAGSW_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & JTAG_SW_JTAGSW_CTRL_RESERVED1_MASK) >> JTAG_SW_JTAGSW_CTRL_RESERVED1_SHIFT)
#define  JTAG_SW_JTAGSW_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JTAG_SW_JTAGSW_CTRL_RESERVED1_MASK) | (((uint32_t)val) << JTAG_SW_JTAGSW_CTRL_RESERVED1_SHIFT))

#define  JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TCK_MASK 0x8
#define  JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TCK_SHIFT 3
#define  JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TCK_MASK_SHIFT(reg) (((reg) & JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TCK_MASK) >> JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TCK_SHIFT)
#define  JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TCK_REPLACE_VAL(reg,val) (((reg) & ~JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TCK_MASK) | (((uint32_t)val) << JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TCK_SHIFT))

#define  JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TMS_MASK 0x4
#define  JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TMS_SHIFT 2
#define  JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TMS_MASK_SHIFT(reg) (((reg) & JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TMS_MASK) >> JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TMS_SHIFT)
#define  JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TMS_REPLACE_VAL(reg,val) (((reg) & ~JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TMS_MASK) | (((uint32_t)val) << JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TMS_SHIFT))

#define  JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TRST_MASK 0x2
#define  JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TRST_SHIFT 1
#define  JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TRST_MASK_SHIFT(reg) (((reg) & JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TRST_MASK) >> JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TRST_SHIFT)
#define  JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TRST_REPLACE_VAL(reg,val) (((reg) & ~JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TRST_MASK) | (((uint32_t)val) << JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TRST_SHIFT))

#define  JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TDI_MASK 0x1
#define  JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TDI_SHIFT 0
#define  JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TDI_MASK_SHIFT(reg) (((reg) & JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TDI_MASK) >> JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TDI_SHIFT)
#define  JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TDI_REPLACE_VAL(reg,val) (((reg) & ~JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TDI_MASK) | (((uint32_t)val) << JTAG_SW_JTAGSW_CTRL_JTAG_SOFT_OUT_TDI_SHIFT))

//====================================================================
//Register: Software JTAG Serial Data Register (JTAGSW_DATA)
//====================================================================

#define  JTAG_SW_JTAGSW_DATA_RESERVED1_MASK 0xfffffffe
#define  JTAG_SW_JTAGSW_DATA_RESERVED1_SHIFT 1
#define  JTAG_SW_JTAGSW_DATA_RESERVED1_MASK_SHIFT(reg) (((reg) & JTAG_SW_JTAGSW_DATA_RESERVED1_MASK) >> JTAG_SW_JTAGSW_DATA_RESERVED1_SHIFT)
#define  JTAG_SW_JTAGSW_DATA_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JTAG_SW_JTAGSW_DATA_RESERVED1_MASK) | (((uint32_t)val) << JTAG_SW_JTAGSW_DATA_RESERVED1_SHIFT))

#define  JTAG_SW_JTAGSW_DATA_JTAG_SOFT_PREAD_DATA_MASK 0x1
#define  JTAG_SW_JTAGSW_DATA_JTAG_SOFT_PREAD_DATA_SHIFT 0
#define  JTAG_SW_JTAGSW_DATA_JTAG_SOFT_PREAD_DATA_MASK_SHIFT(reg) (((reg) & JTAG_SW_JTAGSW_DATA_JTAG_SOFT_PREAD_DATA_MASK) >> JTAG_SW_JTAGSW_DATA_JTAG_SOFT_PREAD_DATA_SHIFT)
#define  JTAG_SW_JTAGSW_DATA_JTAG_SOFT_PREAD_DATA_REPLACE_VAL(reg,val) (((reg) & ~JTAG_SW_JTAGSW_DATA_JTAG_SOFT_PREAD_DATA_MASK) | (((uint32_t)val) << JTAG_SW_JTAGSW_DATA_JTAG_SOFT_PREAD_DATA_SHIFT))

//====================================================================
//Register: Software JTAG Revision 0 Register (JTAGSW_REV0)
//====================================================================

#define  JTAG_SW_JTAGSW_REV0_JTAG_SW_MAJ_REV_MASK 0xffff0000
#define  JTAG_SW_JTAGSW_REV0_JTAG_SW_MAJ_REV_SHIFT 16
#define  JTAG_SW_JTAGSW_REV0_JTAG_SW_MAJ_REV_MASK_SHIFT(reg) (((reg) & JTAG_SW_JTAGSW_REV0_JTAG_SW_MAJ_REV_MASK) >> JTAG_SW_JTAGSW_REV0_JTAG_SW_MAJ_REV_SHIFT)
#define  JTAG_SW_JTAGSW_REV0_JTAG_SW_MAJ_REV_REPLACE_VAL(reg,val) (((reg) & ~JTAG_SW_JTAGSW_REV0_JTAG_SW_MAJ_REV_MASK) | (((uint32_t)val) << JTAG_SW_JTAGSW_REV0_JTAG_SW_MAJ_REV_SHIFT))

#define  JTAG_SW_JTAGSW_REV0_JTAG_SW_MID_REV_MASK 0xffff
#define  JTAG_SW_JTAGSW_REV0_JTAG_SW_MID_REV_SHIFT 0
#define  JTAG_SW_JTAGSW_REV0_JTAG_SW_MID_REV_MASK_SHIFT(reg) (((reg) & JTAG_SW_JTAGSW_REV0_JTAG_SW_MID_REV_MASK) >> JTAG_SW_JTAGSW_REV0_JTAG_SW_MID_REV_SHIFT)
#define  JTAG_SW_JTAGSW_REV0_JTAG_SW_MID_REV_REPLACE_VAL(reg,val) (((reg) & ~JTAG_SW_JTAGSW_REV0_JTAG_SW_MID_REV_MASK) | (((uint32_t)val) << JTAG_SW_JTAGSW_REV0_JTAG_SW_MID_REV_SHIFT))

//====================================================================
//Register: Software JTAG Revision 1 Register (JTAGSW_REV1)
//====================================================================

#define  JTAG_SW_JTAGSW_REV1_RESERVED1_MASK 0xffff0000
#define  JTAG_SW_JTAGSW_REV1_RESERVED1_SHIFT 16
#define  JTAG_SW_JTAGSW_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & JTAG_SW_JTAGSW_REV1_RESERVED1_MASK) >> JTAG_SW_JTAGSW_REV1_RESERVED1_SHIFT)
#define  JTAG_SW_JTAGSW_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JTAG_SW_JTAGSW_REV1_RESERVED1_MASK) | (((uint32_t)val) << JTAG_SW_JTAGSW_REV1_RESERVED1_SHIFT))

#define  JTAG_SW_JTAGSW_REV1_JTAG_SW_CFG_MASK 0xffff
#define  JTAG_SW_JTAGSW_REV1_JTAG_SW_CFG_SHIFT 0
#define  JTAG_SW_JTAGSW_REV1_JTAG_SW_CFG_MASK_SHIFT(reg) (((reg) & JTAG_SW_JTAGSW_REV1_JTAG_SW_CFG_MASK) >> JTAG_SW_JTAGSW_REV1_JTAG_SW_CFG_SHIFT)
#define  JTAG_SW_JTAGSW_REV1_JTAG_SW_CFG_REPLACE_VAL(reg,val) (((reg) & ~JTAG_SW_JTAGSW_REV1_JTAG_SW_CFG_MASK) | (((uint32_t)val) << JTAG_SW_JTAGSW_REV1_JTAG_SW_CFG_SHIFT))

//====================================================================
//
//Register File: TIMEBASE2 Registers (TIMEBASE2)
/** \brief TIMEBASE2 block is used to generate timing periods that are useful to other blocks in the system, such as the APB Timers/watchdog, AUXADC, Engine Control, DDAC Audio, and DC Motor. By using a common configurable timebase, each block is not burdened with programmable dividers. <BR>
   TIMEBASE2 is programmable to generate desired period timing given an input reference clock. The reference clock can be fixed to a stable time standard such as a 25MHz crystal oscillator clock. <BR>
   TIMEBASE2 provides an APB register interface and output timebases, both in the bus clk domain. There are six output timebases provided - 1us, 10us, 100us, 1ms, 10ms, 100ms. Each output timebase is a train of single clock cycle pulses, where the start of each pulse is separated by the timebase perioud (1us, 10us, etc).*/
//
//====================================================================

//====================================================================
//Register: Timebase Configuration Register (TCR)
/** \brief This register is set to indicate the reference frequency. This permits the timebase to generate correct timebase periods over a wide range of reference frequencies.<BR>
            This register should be programmed immediately following boot, and should be adjusted whenever the frequency changes (if using a programmable system PLL). Note that the default frequency is set to 25 MHz. When this register is written, the timebase counter restarts.<BR>
            This register may also be used to disable the timebase outputs (for testing or low-power purposes).*/
//====================================================================

#define  TIMEBASE2_TCR_RESERVED1_MASK 0xc0000000
#define  TIMEBASE2_TCR_RESERVED1_SHIFT 30
#define  TIMEBASE2_TCR_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMEBASE2_TCR_RESERVED1_MASK) >> TIMEBASE2_TCR_RESERVED1_SHIFT)
#define  TIMEBASE2_TCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_TCR_RESERVED1_MASK) | (((uint32_t)val) << TIMEBASE2_TCR_RESERVED1_SHIFT))

#define  TIMEBASE2_TCR_DISABLE100MS_MASK 0x20000000
#define  TIMEBASE2_TCR_DISABLE100MS_SHIFT 29
#define  TIMEBASE2_TCR_DISABLE100MS_MASK_SHIFT(reg) (((reg) & TIMEBASE2_TCR_DISABLE100MS_MASK) >> TIMEBASE2_TCR_DISABLE100MS_SHIFT)
#define  TIMEBASE2_TCR_DISABLE100MS_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_TCR_DISABLE100MS_MASK) | (((uint32_t)val) << TIMEBASE2_TCR_DISABLE100MS_SHIFT))

#define  TIMEBASE2_TCR_DISABLE10MS_MASK 0x10000000
#define  TIMEBASE2_TCR_DISABLE10MS_SHIFT 28
#define  TIMEBASE2_TCR_DISABLE10MS_MASK_SHIFT(reg) (((reg) & TIMEBASE2_TCR_DISABLE10MS_MASK) >> TIMEBASE2_TCR_DISABLE10MS_SHIFT)
#define  TIMEBASE2_TCR_DISABLE10MS_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_TCR_DISABLE10MS_MASK) | (((uint32_t)val) << TIMEBASE2_TCR_DISABLE10MS_SHIFT))

#define  TIMEBASE2_TCR_DISABLE1MS_MASK 0x8000000
#define  TIMEBASE2_TCR_DISABLE1MS_SHIFT 27
#define  TIMEBASE2_TCR_DISABLE1MS_MASK_SHIFT(reg) (((reg) & TIMEBASE2_TCR_DISABLE1MS_MASK) >> TIMEBASE2_TCR_DISABLE1MS_SHIFT)
#define  TIMEBASE2_TCR_DISABLE1MS_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_TCR_DISABLE1MS_MASK) | (((uint32_t)val) << TIMEBASE2_TCR_DISABLE1MS_SHIFT))

#define  TIMEBASE2_TCR_DISABLE100US_MASK 0x4000000
#define  TIMEBASE2_TCR_DISABLE100US_SHIFT 26
#define  TIMEBASE2_TCR_DISABLE100US_MASK_SHIFT(reg) (((reg) & TIMEBASE2_TCR_DISABLE100US_MASK) >> TIMEBASE2_TCR_DISABLE100US_SHIFT)
#define  TIMEBASE2_TCR_DISABLE100US_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_TCR_DISABLE100US_MASK) | (((uint32_t)val) << TIMEBASE2_TCR_DISABLE100US_SHIFT))

#define  TIMEBASE2_TCR_DISABLE10US_MASK 0x2000000
#define  TIMEBASE2_TCR_DISABLE10US_SHIFT 25
#define  TIMEBASE2_TCR_DISABLE10US_MASK_SHIFT(reg) (((reg) & TIMEBASE2_TCR_DISABLE10US_MASK) >> TIMEBASE2_TCR_DISABLE10US_SHIFT)
#define  TIMEBASE2_TCR_DISABLE10US_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_TCR_DISABLE10US_MASK) | (((uint32_t)val) << TIMEBASE2_TCR_DISABLE10US_SHIFT))

#define  TIMEBASE2_TCR_DISABLE1US_MASK 0x1000000
#define  TIMEBASE2_TCR_DISABLE1US_SHIFT 24
#define  TIMEBASE2_TCR_DISABLE1US_MASK_SHIFT(reg) (((reg) & TIMEBASE2_TCR_DISABLE1US_MASK) >> TIMEBASE2_TCR_DISABLE1US_SHIFT)
#define  TIMEBASE2_TCR_DISABLE1US_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_TCR_DISABLE1US_MASK) | (((uint32_t)val) << TIMEBASE2_TCR_DISABLE1US_SHIFT))

#define  TIMEBASE2_TCR_RESERVED2_MASK 0xffff00
#define  TIMEBASE2_TCR_RESERVED2_SHIFT 8
#define  TIMEBASE2_TCR_RESERVED2_MASK_SHIFT(reg) (((reg) & TIMEBASE2_TCR_RESERVED2_MASK) >> TIMEBASE2_TCR_RESERVED2_SHIFT)
#define  TIMEBASE2_TCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_TCR_RESERVED2_MASK) | (((uint32_t)val) << TIMEBASE2_TCR_RESERVED2_SHIFT))

#define  TIMEBASE2_TCR_SYSFREQ_MASK 0xff
#define  TIMEBASE2_TCR_SYSFREQ_SHIFT 0
#define  TIMEBASE2_TCR_SYSFREQ_MASK_SHIFT(reg) (((reg) & TIMEBASE2_TCR_SYSFREQ_MASK) >> TIMEBASE2_TCR_SYSFREQ_SHIFT)
#define  TIMEBASE2_TCR_SYSFREQ_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_TCR_SYSFREQ_MASK) | (((uint32_t)val) << TIMEBASE2_TCR_SYSFREQ_SHIFT))

//====================================================================
//Register: Timebase Testing Register (TTR)
/** \brief Writing to this register can force the respective timing outputs to be asserted for a single bus cycle, or will cause the respective timing outputs to pulse (one bus clock in width) continuously every other reference clock period. This is handy for writing ASIC test procedures to "speed up" the testing of slow real-time blocks, and to keep the test synchronized without having to explicitly count clock cycles.<BR>
     During testing, it is generally advisable to disable the normal tick outputs via the Timebase Configuration Register, and then force the desired timing sequence using this register. If the timebase is not disabled using the timebase configuration register, requesting a single tick will cause the count to increment by two.<BR>
     Requesting a single tick affects the count for higher timebases. Care should be taken when disabling the 1us timebase, because it can be required by other blocks. For example, DRAM or LCD refresh.*/
//====================================================================

#define  TIMEBASE2_TTR_RESERVED1_MASK 0xc0000000
#define  TIMEBASE2_TTR_RESERVED1_SHIFT 30
#define  TIMEBASE2_TTR_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMEBASE2_TTR_RESERVED1_MASK) >> TIMEBASE2_TTR_RESERVED1_SHIFT)
#define  TIMEBASE2_TTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_TTR_RESERVED1_MASK) | (((uint32_t)val) << TIMEBASE2_TTR_RESERVED1_SHIFT))

#define  TIMEBASE2_TTR_FORCE100MS_MASK 0x20000000
#define  TIMEBASE2_TTR_FORCE100MS_SHIFT 29
#define  TIMEBASE2_TTR_FORCE100MS_MASK_SHIFT(reg) (((reg) & TIMEBASE2_TTR_FORCE100MS_MASK) >> TIMEBASE2_TTR_FORCE100MS_SHIFT)
#define  TIMEBASE2_TTR_FORCE100MS_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_TTR_FORCE100MS_MASK) | (((uint32_t)val) << TIMEBASE2_TTR_FORCE100MS_SHIFT))

#define  TIMEBASE2_TTR_FORCE10MS_MASK 0x10000000
#define  TIMEBASE2_TTR_FORCE10MS_SHIFT 28
#define  TIMEBASE2_TTR_FORCE10MS_MASK_SHIFT(reg) (((reg) & TIMEBASE2_TTR_FORCE10MS_MASK) >> TIMEBASE2_TTR_FORCE10MS_SHIFT)
#define  TIMEBASE2_TTR_FORCE10MS_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_TTR_FORCE10MS_MASK) | (((uint32_t)val) << TIMEBASE2_TTR_FORCE10MS_SHIFT))

#define  TIMEBASE2_TTR_FORCE1MS_MASK 0x8000000
#define  TIMEBASE2_TTR_FORCE1MS_SHIFT 27
#define  TIMEBASE2_TTR_FORCE1MS_MASK_SHIFT(reg) (((reg) & TIMEBASE2_TTR_FORCE1MS_MASK) >> TIMEBASE2_TTR_FORCE1MS_SHIFT)
#define  TIMEBASE2_TTR_FORCE1MS_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_TTR_FORCE1MS_MASK) | (((uint32_t)val) << TIMEBASE2_TTR_FORCE1MS_SHIFT))

#define  TIMEBASE2_TTR_FORCE100US_MASK 0x4000000
#define  TIMEBASE2_TTR_FORCE100US_SHIFT 26
#define  TIMEBASE2_TTR_FORCE100US_MASK_SHIFT(reg) (((reg) & TIMEBASE2_TTR_FORCE100US_MASK) >> TIMEBASE2_TTR_FORCE100US_SHIFT)
#define  TIMEBASE2_TTR_FORCE100US_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_TTR_FORCE100US_MASK) | (((uint32_t)val) << TIMEBASE2_TTR_FORCE100US_SHIFT))

#define  TIMEBASE2_TTR_FORCE10US_MASK 0x2000000
#define  TIMEBASE2_TTR_FORCE10US_SHIFT 25
#define  TIMEBASE2_TTR_FORCE10US_MASK_SHIFT(reg) (((reg) & TIMEBASE2_TTR_FORCE10US_MASK) >> TIMEBASE2_TTR_FORCE10US_SHIFT)
#define  TIMEBASE2_TTR_FORCE10US_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_TTR_FORCE10US_MASK) | (((uint32_t)val) << TIMEBASE2_TTR_FORCE10US_SHIFT))

#define  TIMEBASE2_TTR_FORCE1US_MASK 0x1000000
#define  TIMEBASE2_TTR_FORCE1US_SHIFT 24
#define  TIMEBASE2_TTR_FORCE1US_MASK_SHIFT(reg) (((reg) & TIMEBASE2_TTR_FORCE1US_MASK) >> TIMEBASE2_TTR_FORCE1US_SHIFT)
#define  TIMEBASE2_TTR_FORCE1US_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_TTR_FORCE1US_MASK) | (((uint32_t)val) << TIMEBASE2_TTR_FORCE1US_SHIFT))

#define  TIMEBASE2_TTR_RESERVED2_MASK 0xc00000
#define  TIMEBASE2_TTR_RESERVED2_SHIFT 22
#define  TIMEBASE2_TTR_RESERVED2_MASK_SHIFT(reg) (((reg) & TIMEBASE2_TTR_RESERVED2_MASK) >> TIMEBASE2_TTR_RESERVED2_SHIFT)
#define  TIMEBASE2_TTR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_TTR_RESERVED2_MASK) | (((uint32_t)val) << TIMEBASE2_TTR_RESERVED2_SHIFT))

#define  TIMEBASE2_TTR_CONT100MS_MASK 0x200000
#define  TIMEBASE2_TTR_CONT100MS_SHIFT 21
#define  TIMEBASE2_TTR_CONT100MS_MASK_SHIFT(reg) (((reg) & TIMEBASE2_TTR_CONT100MS_MASK) >> TIMEBASE2_TTR_CONT100MS_SHIFT)
#define  TIMEBASE2_TTR_CONT100MS_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_TTR_CONT100MS_MASK) | (((uint32_t)val) << TIMEBASE2_TTR_CONT100MS_SHIFT))

#define  TIMEBASE2_TTR_CONT10MS_MASK 0x100000
#define  TIMEBASE2_TTR_CONT10MS_SHIFT 20
#define  TIMEBASE2_TTR_CONT10MS_MASK_SHIFT(reg) (((reg) & TIMEBASE2_TTR_CONT10MS_MASK) >> TIMEBASE2_TTR_CONT10MS_SHIFT)
#define  TIMEBASE2_TTR_CONT10MS_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_TTR_CONT10MS_MASK) | (((uint32_t)val) << TIMEBASE2_TTR_CONT10MS_SHIFT))

#define  TIMEBASE2_TTR_CONT1MS_MASK 0x80000
#define  TIMEBASE2_TTR_CONT1MS_SHIFT 19
#define  TIMEBASE2_TTR_CONT1MS_MASK_SHIFT(reg) (((reg) & TIMEBASE2_TTR_CONT1MS_MASK) >> TIMEBASE2_TTR_CONT1MS_SHIFT)
#define  TIMEBASE2_TTR_CONT1MS_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_TTR_CONT1MS_MASK) | (((uint32_t)val) << TIMEBASE2_TTR_CONT1MS_SHIFT))

#define  TIMEBASE2_TTR_CONT100US_MASK 0x40000
#define  TIMEBASE2_TTR_CONT100US_SHIFT 18
#define  TIMEBASE2_TTR_CONT100US_MASK_SHIFT(reg) (((reg) & TIMEBASE2_TTR_CONT100US_MASK) >> TIMEBASE2_TTR_CONT100US_SHIFT)
#define  TIMEBASE2_TTR_CONT100US_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_TTR_CONT100US_MASK) | (((uint32_t)val) << TIMEBASE2_TTR_CONT100US_SHIFT))

#define  TIMEBASE2_TTR_CONT10US_MASK 0x20000
#define  TIMEBASE2_TTR_CONT10US_SHIFT 17
#define  TIMEBASE2_TTR_CONT10US_MASK_SHIFT(reg) (((reg) & TIMEBASE2_TTR_CONT10US_MASK) >> TIMEBASE2_TTR_CONT10US_SHIFT)
#define  TIMEBASE2_TTR_CONT10US_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_TTR_CONT10US_MASK) | (((uint32_t)val) << TIMEBASE2_TTR_CONT10US_SHIFT))

#define  TIMEBASE2_TTR_CONT1US_MASK 0x10000
#define  TIMEBASE2_TTR_CONT1US_SHIFT 16
#define  TIMEBASE2_TTR_CONT1US_MASK_SHIFT(reg) (((reg) & TIMEBASE2_TTR_CONT1US_MASK) >> TIMEBASE2_TTR_CONT1US_SHIFT)
#define  TIMEBASE2_TTR_CONT1US_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_TTR_CONT1US_MASK) | (((uint32_t)val) << TIMEBASE2_TTR_CONT1US_SHIFT))

#define  TIMEBASE2_TTR_RESERVED3_MASK 0xffff
#define  TIMEBASE2_TTR_RESERVED3_SHIFT 0
#define  TIMEBASE2_TTR_RESERVED3_MASK_SHIFT(reg) (((reg) & TIMEBASE2_TTR_RESERVED3_MASK) >> TIMEBASE2_TTR_RESERVED3_SHIFT)
#define  TIMEBASE2_TTR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_TTR_RESERVED3_MASK) | (((uint32_t)val) << TIMEBASE2_TTR_RESERVED3_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  TIMEBASE2_REV0_MAJ_MASK 0xffff0000
#define  TIMEBASE2_REV0_MAJ_SHIFT 16
#define  TIMEBASE2_REV0_MAJ_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REV0_MAJ_MASK) >> TIMEBASE2_REV0_MAJ_SHIFT)
#define  TIMEBASE2_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REV0_MAJ_MASK) | (((uint32_t)val) << TIMEBASE2_REV0_MAJ_SHIFT))

#define  TIMEBASE2_REV0_MID_MASK 0xffff
#define  TIMEBASE2_REV0_MID_SHIFT 0
#define  TIMEBASE2_REV0_MID_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REV0_MID_MASK) >> TIMEBASE2_REV0_MID_SHIFT)
#define  TIMEBASE2_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REV0_MID_MASK) | (((uint32_t)val) << TIMEBASE2_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  TIMEBASE2_REV1_RESERVED1_MASK 0xffff0000
#define  TIMEBASE2_REV1_RESERVED1_SHIFT 16
#define  TIMEBASE2_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REV1_RESERVED1_MASK) >> TIMEBASE2_REV1_RESERVED1_SHIFT)
#define  TIMEBASE2_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REV1_RESERVED1_MASK) | (((uint32_t)val) << TIMEBASE2_REV1_RESERVED1_SHIFT))

#define  TIMEBASE2_REV1_CFG_MASK 0xffff
#define  TIMEBASE2_REV1_CFG_SHIFT 0
#define  TIMEBASE2_REV1_CFG_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REV1_CFG_MASK) >> TIMEBASE2_REV1_CFG_SHIFT)
#define  TIMEBASE2_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REV1_CFG_MASK) | (((uint32_t)val) << TIMEBASE2_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: Timers Registers (Timers)
//
//====================================================================

//====================================================================
//Register: Timer Clock Control Register (TMR_CCR)
/** \brief This register defines the source clock for the three timers. The watchdog timer
operates using only the 256 Hz clock.*/
//====================================================================

#define  TIMERS_TMR_CCR_RESERVED1_MASK 0xffffff80
#define  TIMERS_TMR_CCR_RESERVED1_SHIFT 7
#define  TIMERS_TMR_CCR_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_CCR_RESERVED1_MASK) >> TIMERS_TMR_CCR_RESERVED1_SHIFT)
#define  TIMERS_TMR_CCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_CCR_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_CCR_RESERVED1_SHIFT))

#define  TIMERS_TMR_CCR_CS_2_MASK 0x60
#define  TIMERS_TMR_CCR_CS_2_SHIFT 5
#define  TIMERS_TMR_CCR_CS_2_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_CCR_CS_2_MASK) >> TIMERS_TMR_CCR_CS_2_SHIFT)
#define  TIMERS_TMR_CCR_CS_2_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_CCR_CS_2_MASK) | (((uint32_t)val) << TIMERS_TMR_CCR_CS_2_SHIFT))

#define  TIMERS_TMR_CCR_RESERVED2_MASK 0x10
#define  TIMERS_TMR_CCR_RESERVED2_SHIFT 4
#define  TIMERS_TMR_CCR_RESERVED2_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_CCR_RESERVED2_MASK) >> TIMERS_TMR_CCR_RESERVED2_SHIFT)
#define  TIMERS_TMR_CCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_CCR_RESERVED2_MASK) | (((uint32_t)val) << TIMERS_TMR_CCR_RESERVED2_SHIFT))

#define  TIMERS_TMR_CCR_CS_1_MASK 0xc
#define  TIMERS_TMR_CCR_CS_1_SHIFT 2
#define  TIMERS_TMR_CCR_CS_1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_CCR_CS_1_MASK) >> TIMERS_TMR_CCR_CS_1_SHIFT)
#define  TIMERS_TMR_CCR_CS_1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_CCR_CS_1_MASK) | (((uint32_t)val) << TIMERS_TMR_CCR_CS_1_SHIFT))

#define  TIMERS_TMR_CCR_CS_0_MASK 0x3
#define  TIMERS_TMR_CCR_CS_0_SHIFT 0
#define  TIMERS_TMR_CCR_CS_0_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_CCR_CS_0_MASK) >> TIMERS_TMR_CCR_CS_0_SHIFT)
#define  TIMERS_TMR_CCR_CS_0_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_CCR_CS_0_MASK) | (((uint32_t)val) << TIMERS_TMR_CCR_CS_0_SHIFT))

//====================================================================
//Register: Timer Match Registers (Instance 1 of 9) (TMR_Tn_Mm0)
/** \brief  (Instance 1 of 9)*/
//====================================================================

#define  TIMERS_TMR_TN_MM0_TMR_TN_MM_MASK 0xffffffff
#define  TIMERS_TMR_TN_MM0_TMR_TN_MM_SHIFT 0
#define  TIMERS_TMR_TN_MM0_TMR_TN_MM_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_TN_MM0_TMR_TN_MM_MASK) >> TIMERS_TMR_TN_MM0_TMR_TN_MM_SHIFT)
#define  TIMERS_TMR_TN_MM0_TMR_TN_MM_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_TN_MM0_TMR_TN_MM_MASK) | (((uint32_t)val) << TIMERS_TMR_TN_MM0_TMR_TN_MM_SHIFT))

//====================================================================
//Register: Timer Match Registers (Instance 2 of 9) (TMR_Tn_Mm1)
/** \brief  (Instance 2 of 9)*/
//====================================================================

#define  TIMERS_TMR_TN_MM1_TMR_TN_MM_MASK 0xffffffff
#define  TIMERS_TMR_TN_MM1_TMR_TN_MM_SHIFT 0
#define  TIMERS_TMR_TN_MM1_TMR_TN_MM_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_TN_MM1_TMR_TN_MM_MASK) >> TIMERS_TMR_TN_MM1_TMR_TN_MM_SHIFT)
#define  TIMERS_TMR_TN_MM1_TMR_TN_MM_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_TN_MM1_TMR_TN_MM_MASK) | (((uint32_t)val) << TIMERS_TMR_TN_MM1_TMR_TN_MM_SHIFT))

//====================================================================
//Register: Timer Match Registers (Instance 3 of 9) (TMR_Tn_Mm2)
/** \brief  (Instance 3 of 9)*/
//====================================================================

#define  TIMERS_TMR_TN_MM2_TMR_TN_MM_MASK 0xffffffff
#define  TIMERS_TMR_TN_MM2_TMR_TN_MM_SHIFT 0
#define  TIMERS_TMR_TN_MM2_TMR_TN_MM_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_TN_MM2_TMR_TN_MM_MASK) >> TIMERS_TMR_TN_MM2_TMR_TN_MM_SHIFT)
#define  TIMERS_TMR_TN_MM2_TMR_TN_MM_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_TN_MM2_TMR_TN_MM_MASK) | (((uint32_t)val) << TIMERS_TMR_TN_MM2_TMR_TN_MM_SHIFT))

//====================================================================
//Register: Timer Match Registers (Instance 4 of 9) (TMR_Tn_Mm3)
/** \brief  (Instance 4 of 9)*/
//====================================================================

#define  TIMERS_TMR_TN_MM3_TMR_TN_MM_MASK 0xffffffff
#define  TIMERS_TMR_TN_MM3_TMR_TN_MM_SHIFT 0
#define  TIMERS_TMR_TN_MM3_TMR_TN_MM_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_TN_MM3_TMR_TN_MM_MASK) >> TIMERS_TMR_TN_MM3_TMR_TN_MM_SHIFT)
#define  TIMERS_TMR_TN_MM3_TMR_TN_MM_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_TN_MM3_TMR_TN_MM_MASK) | (((uint32_t)val) << TIMERS_TMR_TN_MM3_TMR_TN_MM_SHIFT))

//====================================================================
//Register: Timer Match Registers (Instance 5 of 9) (TMR_Tn_Mm4)
/** \brief  (Instance 5 of 9)*/
//====================================================================

#define  TIMERS_TMR_TN_MM4_TMR_TN_MM_MASK 0xffffffff
#define  TIMERS_TMR_TN_MM4_TMR_TN_MM_SHIFT 0
#define  TIMERS_TMR_TN_MM4_TMR_TN_MM_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_TN_MM4_TMR_TN_MM_MASK) >> TIMERS_TMR_TN_MM4_TMR_TN_MM_SHIFT)
#define  TIMERS_TMR_TN_MM4_TMR_TN_MM_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_TN_MM4_TMR_TN_MM_MASK) | (((uint32_t)val) << TIMERS_TMR_TN_MM4_TMR_TN_MM_SHIFT))

//====================================================================
//Register: Timer Match Registers (Instance 6 of 9) (TMR_Tn_Mm5)
/** \brief  (Instance 6 of 9)*/
//====================================================================

#define  TIMERS_TMR_TN_MM5_TMR_TN_MM_MASK 0xffffffff
#define  TIMERS_TMR_TN_MM5_TMR_TN_MM_SHIFT 0
#define  TIMERS_TMR_TN_MM5_TMR_TN_MM_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_TN_MM5_TMR_TN_MM_MASK) >> TIMERS_TMR_TN_MM5_TMR_TN_MM_SHIFT)
#define  TIMERS_TMR_TN_MM5_TMR_TN_MM_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_TN_MM5_TMR_TN_MM_MASK) | (((uint32_t)val) << TIMERS_TMR_TN_MM5_TMR_TN_MM_SHIFT))

//====================================================================
//Register: Timer Match Registers (Instance 7 of 9) (TMR_Tn_Mm6)
/** \brief  (Instance 7 of 9)*/
//====================================================================

#define  TIMERS_TMR_TN_MM6_TMR_TN_MM_MASK 0xffffffff
#define  TIMERS_TMR_TN_MM6_TMR_TN_MM_SHIFT 0
#define  TIMERS_TMR_TN_MM6_TMR_TN_MM_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_TN_MM6_TMR_TN_MM_MASK) >> TIMERS_TMR_TN_MM6_TMR_TN_MM_SHIFT)
#define  TIMERS_TMR_TN_MM6_TMR_TN_MM_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_TN_MM6_TMR_TN_MM_MASK) | (((uint32_t)val) << TIMERS_TMR_TN_MM6_TMR_TN_MM_SHIFT))

//====================================================================
//Register: Timer Match Registers (Instance 8 of 9) (TMR_Tn_Mm7)
/** \brief  (Instance 8 of 9)*/
//====================================================================

#define  TIMERS_TMR_TN_MM7_TMR_TN_MM_MASK 0xffffffff
#define  TIMERS_TMR_TN_MM7_TMR_TN_MM_SHIFT 0
#define  TIMERS_TMR_TN_MM7_TMR_TN_MM_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_TN_MM7_TMR_TN_MM_MASK) >> TIMERS_TMR_TN_MM7_TMR_TN_MM_SHIFT)
#define  TIMERS_TMR_TN_MM7_TMR_TN_MM_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_TN_MM7_TMR_TN_MM_MASK) | (((uint32_t)val) << TIMERS_TMR_TN_MM7_TMR_TN_MM_SHIFT))

//====================================================================
//Register: Timer Match Registers (Instance 9 of 9) (TMR_Tn_Mm8)
/** \brief  (Instance 9 of 9)*/
//====================================================================

#define  TIMERS_TMR_TN_MM8_TMR_TN_MM_MASK 0xffffffff
#define  TIMERS_TMR_TN_MM8_TMR_TN_MM_SHIFT 0
#define  TIMERS_TMR_TN_MM8_TMR_TN_MM_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_TN_MM8_TMR_TN_MM_MASK) >> TIMERS_TMR_TN_MM8_TMR_TN_MM_SHIFT)
#define  TIMERS_TMR_TN_MM8_TMR_TN_MM_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_TN_MM8_TMR_TN_MM_MASK) | (((uint32_t)val) << TIMERS_TMR_TN_MM8_TMR_TN_MM_SHIFT))

//====================================================================
//Register: Timer Count Registers (Instance 1 of 3) (TMR_CRn0)
/** \brief Three read-only Timer Count Registers (TCRn, where n = 0, 1, 2) are 32-bit
counters that increment at the rising edge of their selected clocks.
The timer values are read under risk of metastability. Therefore, reading each
one of the Timer Count Register values in the timer clock time base is
accomplished by either of the following:
- Double-read procedure and comparing the two read values to ensure that the
value is valid
- Using the Timer Counters Value Write for Read Request Register, especially
effective for fast clock timers
The counters are pre-loaded with a value from the Timer Preload Value Registers.
When enabled, counters start from pre-loaded values (corresponding Timer Preload
Control Register), and count up to a maximum or matched value.
Note: This request requires up to three timer clock cycles. If the selected
timer is working at slow clock, the request could take longer. (Instance 1 of 3)*/
//====================================================================

#define  TIMERS_TMR_CRN0_TCRN_MASK 0xffffffff
#define  TIMERS_TMR_CRN0_TCRN_SHIFT 0
#define  TIMERS_TMR_CRN0_TCRN_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_CRN0_TCRN_MASK) >> TIMERS_TMR_CRN0_TCRN_SHIFT)
#define  TIMERS_TMR_CRN0_TCRN_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_CRN0_TCRN_MASK) | (((uint32_t)val) << TIMERS_TMR_CRN0_TCRN_SHIFT))

//====================================================================
//Register: Timer Count Registers (Instance 2 of 3) (TMR_CRn1)
/** \brief Three read-only Timer Count Registers (TCRn, where n = 0, 1, 2) are 32-bit
counters that increment at the rising edge of their selected clocks.
The timer values are read under risk of metastability. Therefore, reading each
one of the Timer Count Register values in the timer clock time base is
accomplished by either of the following:
- Double-read procedure and comparing the two read values to ensure that the
value is valid
- Using the Timer Counters Value Write for Read Request Register, especially
effective for fast clock timers
The counters are pre-loaded with a value from the Timer Preload Value Registers.
When enabled, counters start from pre-loaded values (corresponding Timer Preload
Control Register), and count up to a maximum or matched value.
Note: This request requires up to three timer clock cycles. If the selected
timer is working at slow clock, the request could take longer. (Instance 2 of 3)*/
//====================================================================

#define  TIMERS_TMR_CRN1_TCRN_MASK 0xffffffff
#define  TIMERS_TMR_CRN1_TCRN_SHIFT 0
#define  TIMERS_TMR_CRN1_TCRN_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_CRN1_TCRN_MASK) >> TIMERS_TMR_CRN1_TCRN_SHIFT)
#define  TIMERS_TMR_CRN1_TCRN_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_CRN1_TCRN_MASK) | (((uint32_t)val) << TIMERS_TMR_CRN1_TCRN_SHIFT))

//====================================================================
//Register: Timer Count Registers (Instance 3 of 3) (TMR_CRn2)
/** \brief Three read-only Timer Count Registers (TCRn, where n = 0, 1, 2) are 32-bit
counters that increment at the rising edge of their selected clocks.
The timer values are read under risk of metastability. Therefore, reading each
one of the Timer Count Register values in the timer clock time base is
accomplished by either of the following:
- Double-read procedure and comparing the two read values to ensure that the
value is valid
- Using the Timer Counters Value Write for Read Request Register, especially
effective for fast clock timers
The counters are pre-loaded with a value from the Timer Preload Value Registers.
When enabled, counters start from pre-loaded values (corresponding Timer Preload
Control Register), and count up to a maximum or matched value.
Note: This request requires up to three timer clock cycles. If the selected
timer is working at slow clock, the request could take longer. (Instance 3 of 3)*/
//====================================================================

#define  TIMERS_TMR_CRN2_TCRN_MASK 0xffffffff
#define  TIMERS_TMR_CRN2_TCRN_SHIFT 0
#define  TIMERS_TMR_CRN2_TCRN_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_CRN2_TCRN_MASK) >> TIMERS_TMR_CRN2_TCRN_SHIFT)
#define  TIMERS_TMR_CRN2_TCRN_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_CRN2_TCRN_MASK) | (((uint32_t)val) << TIMERS_TMR_CRN2_TCRN_SHIFT))

//====================================================================
//Register: Timer Status Registers (Instance 1 of 3) (TMR_SRn0)
/** \brief These three status registers contain status bits indicating whether a match has
occurred on any of the three match registers of a given Timer Count Register.
These bits are set when the event occurs (the following rising edge of the
respective clock) and cleared by writing a logical one to the proper bit
position of TICLRn. This register reflects level-sensitive interrupt status
only, edge-sensitive interrupts are not captured in this register. (Instance 1 of 3)*/
//====================================================================

#define  TIMERS_TMR_SRN0_RESERVED1_MASK 0xfffffff8
#define  TIMERS_TMR_SRN0_RESERVED1_SHIFT 3
#define  TIMERS_TMR_SRN0_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_SRN0_RESERVED1_MASK) >> TIMERS_TMR_SRN0_RESERVED1_SHIFT)
#define  TIMERS_TMR_SRN0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_SRN0_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_SRN0_RESERVED1_SHIFT))

#define  TIMERS_TMR_SRN0_M2_MASK 0x4
#define  TIMERS_TMR_SRN0_M2_SHIFT 2
#define  TIMERS_TMR_SRN0_M2_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_SRN0_M2_MASK) >> TIMERS_TMR_SRN0_M2_SHIFT)
#define  TIMERS_TMR_SRN0_M2_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_SRN0_M2_MASK) | (((uint32_t)val) << TIMERS_TMR_SRN0_M2_SHIFT))

#define  TIMERS_TMR_SRN0_M1_MASK 0x2
#define  TIMERS_TMR_SRN0_M1_SHIFT 1
#define  TIMERS_TMR_SRN0_M1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_SRN0_M1_MASK) >> TIMERS_TMR_SRN0_M1_SHIFT)
#define  TIMERS_TMR_SRN0_M1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_SRN0_M1_MASK) | (((uint32_t)val) << TIMERS_TMR_SRN0_M1_SHIFT))

#define  TIMERS_TMR_SRN0_M0_MASK 0x1
#define  TIMERS_TMR_SRN0_M0_SHIFT 0
#define  TIMERS_TMR_SRN0_M0_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_SRN0_M0_MASK) >> TIMERS_TMR_SRN0_M0_SHIFT)
#define  TIMERS_TMR_SRN0_M0_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_SRN0_M0_MASK) | (((uint32_t)val) << TIMERS_TMR_SRN0_M0_SHIFT))

//====================================================================
//Register: Timer Status Registers (Instance 2 of 3) (TMR_SRn1)
/** \brief These three status registers contain status bits indicating whether a match has
occurred on any of the three match registers of a given Timer Count Register.
These bits are set when the event occurs (the following rising edge of the
respective clock) and cleared by writing a logical one to the proper bit
position of TICLRn. This register reflects level-sensitive interrupt status
only, edge-sensitive interrupts are not captured in this register. (Instance 2 of 3)*/
//====================================================================

#define  TIMERS_TMR_SRN1_RESERVED1_MASK 0xfffffff8
#define  TIMERS_TMR_SRN1_RESERVED1_SHIFT 3
#define  TIMERS_TMR_SRN1_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_SRN1_RESERVED1_MASK) >> TIMERS_TMR_SRN1_RESERVED1_SHIFT)
#define  TIMERS_TMR_SRN1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_SRN1_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_SRN1_RESERVED1_SHIFT))

#define  TIMERS_TMR_SRN1_M2_MASK 0x4
#define  TIMERS_TMR_SRN1_M2_SHIFT 2
#define  TIMERS_TMR_SRN1_M2_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_SRN1_M2_MASK) >> TIMERS_TMR_SRN1_M2_SHIFT)
#define  TIMERS_TMR_SRN1_M2_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_SRN1_M2_MASK) | (((uint32_t)val) << TIMERS_TMR_SRN1_M2_SHIFT))

#define  TIMERS_TMR_SRN1_M1_MASK 0x2
#define  TIMERS_TMR_SRN1_M1_SHIFT 1
#define  TIMERS_TMR_SRN1_M1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_SRN1_M1_MASK) >> TIMERS_TMR_SRN1_M1_SHIFT)
#define  TIMERS_TMR_SRN1_M1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_SRN1_M1_MASK) | (((uint32_t)val) << TIMERS_TMR_SRN1_M1_SHIFT))

#define  TIMERS_TMR_SRN1_M0_MASK 0x1
#define  TIMERS_TMR_SRN1_M0_SHIFT 0
#define  TIMERS_TMR_SRN1_M0_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_SRN1_M0_MASK) >> TIMERS_TMR_SRN1_M0_SHIFT)
#define  TIMERS_TMR_SRN1_M0_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_SRN1_M0_MASK) | (((uint32_t)val) << TIMERS_TMR_SRN1_M0_SHIFT))

//====================================================================
//Register: Timer Status Registers (Instance 3 of 3) (TMR_SRn2)
/** \brief These three status registers contain status bits indicating whether a match has
occurred on any of the three match registers of a given Timer Count Register.
These bits are set when the event occurs (the following rising edge of the
respective clock) and cleared by writing a logical one to the proper bit
position of TICLRn. This register reflects level-sensitive interrupt status
only, edge-sensitive interrupts are not captured in this register. (Instance 3 of 3)*/
//====================================================================

#define  TIMERS_TMR_SRN2_RESERVED1_MASK 0xfffffff8
#define  TIMERS_TMR_SRN2_RESERVED1_SHIFT 3
#define  TIMERS_TMR_SRN2_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_SRN2_RESERVED1_MASK) >> TIMERS_TMR_SRN2_RESERVED1_SHIFT)
#define  TIMERS_TMR_SRN2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_SRN2_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_SRN2_RESERVED1_SHIFT))

#define  TIMERS_TMR_SRN2_M2_MASK 0x4
#define  TIMERS_TMR_SRN2_M2_SHIFT 2
#define  TIMERS_TMR_SRN2_M2_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_SRN2_M2_MASK) >> TIMERS_TMR_SRN2_M2_SHIFT)
#define  TIMERS_TMR_SRN2_M2_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_SRN2_M2_MASK) | (((uint32_t)val) << TIMERS_TMR_SRN2_M2_SHIFT))

#define  TIMERS_TMR_SRN2_M1_MASK 0x2
#define  TIMERS_TMR_SRN2_M1_SHIFT 1
#define  TIMERS_TMR_SRN2_M1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_SRN2_M1_MASK) >> TIMERS_TMR_SRN2_M1_SHIFT)
#define  TIMERS_TMR_SRN2_M1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_SRN2_M1_MASK) | (((uint32_t)val) << TIMERS_TMR_SRN2_M1_SHIFT))

#define  TIMERS_TMR_SRN2_M0_MASK 0x1
#define  TIMERS_TMR_SRN2_M0_SHIFT 0
#define  TIMERS_TMR_SRN2_M0_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_SRN2_M0_MASK) >> TIMERS_TMR_SRN2_M0_SHIFT)
#define  TIMERS_TMR_SRN2_M0_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_SRN2_M0_MASK) | (((uint32_t)val) << TIMERS_TMR_SRN2_M0_SHIFT))

//====================================================================
//Register: Timer Interrupt Enable Registers (Instance 1 of 3) (TMR_IERn0)
/** \brief These three registers contain three enable bits each, indicating whether a match
between one of the match registers and the operating-system timer counter sets
a status bit in the Timer Status Registers and asserts the timer#_irq output.
Clearing an enable bit does not clear the corresponding interrupt status bit if
that bit is already set. (Instance 1 of 3)*/
//====================================================================

#define  TIMERS_TMR_IERN0_RESERVED1_MASK 0xfffffff8
#define  TIMERS_TMR_IERN0_RESERVED1_SHIFT 3
#define  TIMERS_TMR_IERN0_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_IERN0_RESERVED1_MASK) >> TIMERS_TMR_IERN0_RESERVED1_SHIFT)
#define  TIMERS_TMR_IERN0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_IERN0_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_IERN0_RESERVED1_SHIFT))

#define  TIMERS_TMR_IERN0_IE2_MASK 0x4
#define  TIMERS_TMR_IERN0_IE2_SHIFT 2
#define  TIMERS_TMR_IERN0_IE2_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_IERN0_IE2_MASK) >> TIMERS_TMR_IERN0_IE2_SHIFT)
#define  TIMERS_TMR_IERN0_IE2_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_IERN0_IE2_MASK) | (((uint32_t)val) << TIMERS_TMR_IERN0_IE2_SHIFT))

#define  TIMERS_TMR_IERN0_IE1_MASK 0x2
#define  TIMERS_TMR_IERN0_IE1_SHIFT 1
#define  TIMERS_TMR_IERN0_IE1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_IERN0_IE1_MASK) >> TIMERS_TMR_IERN0_IE1_SHIFT)
#define  TIMERS_TMR_IERN0_IE1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_IERN0_IE1_MASK) | (((uint32_t)val) << TIMERS_TMR_IERN0_IE1_SHIFT))

#define  TIMERS_TMR_IERN0_IE0_MASK 0x1
#define  TIMERS_TMR_IERN0_IE0_SHIFT 0
#define  TIMERS_TMR_IERN0_IE0_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_IERN0_IE0_MASK) >> TIMERS_TMR_IERN0_IE0_SHIFT)
#define  TIMERS_TMR_IERN0_IE0_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_IERN0_IE0_MASK) | (((uint32_t)val) << TIMERS_TMR_IERN0_IE0_SHIFT))

//====================================================================
//Register: Timer Interrupt Enable Registers (Instance 2 of 3) (TMR_IERn1)
/** \brief These three registers contain three enable bits each, indicating whether a match
between one of the match registers and the operating-system timer counter sets
a status bit in the Timer Status Registers and asserts the timer#_irq output.
Clearing an enable bit does not clear the corresponding interrupt status bit if
that bit is already set. (Instance 2 of 3)*/
//====================================================================

#define  TIMERS_TMR_IERN1_RESERVED1_MASK 0xfffffff8
#define  TIMERS_TMR_IERN1_RESERVED1_SHIFT 3
#define  TIMERS_TMR_IERN1_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_IERN1_RESERVED1_MASK) >> TIMERS_TMR_IERN1_RESERVED1_SHIFT)
#define  TIMERS_TMR_IERN1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_IERN1_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_IERN1_RESERVED1_SHIFT))

#define  TIMERS_TMR_IERN1_IE2_MASK 0x4
#define  TIMERS_TMR_IERN1_IE2_SHIFT 2
#define  TIMERS_TMR_IERN1_IE2_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_IERN1_IE2_MASK) >> TIMERS_TMR_IERN1_IE2_SHIFT)
#define  TIMERS_TMR_IERN1_IE2_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_IERN1_IE2_MASK) | (((uint32_t)val) << TIMERS_TMR_IERN1_IE2_SHIFT))

#define  TIMERS_TMR_IERN1_IE1_MASK 0x2
#define  TIMERS_TMR_IERN1_IE1_SHIFT 1
#define  TIMERS_TMR_IERN1_IE1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_IERN1_IE1_MASK) >> TIMERS_TMR_IERN1_IE1_SHIFT)
#define  TIMERS_TMR_IERN1_IE1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_IERN1_IE1_MASK) | (((uint32_t)val) << TIMERS_TMR_IERN1_IE1_SHIFT))

#define  TIMERS_TMR_IERN1_IE0_MASK 0x1
#define  TIMERS_TMR_IERN1_IE0_SHIFT 0
#define  TIMERS_TMR_IERN1_IE0_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_IERN1_IE0_MASK) >> TIMERS_TMR_IERN1_IE0_SHIFT)
#define  TIMERS_TMR_IERN1_IE0_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_IERN1_IE0_MASK) | (((uint32_t)val) << TIMERS_TMR_IERN1_IE0_SHIFT))

//====================================================================
//Register: Timer Interrupt Enable Registers (Instance 3 of 3) (TMR_IERn2)
/** \brief These three registers contain three enable bits each, indicating whether a match
between one of the match registers and the operating-system timer counter sets
a status bit in the Timer Status Registers and asserts the timer#_irq output.
Clearing an enable bit does not clear the corresponding interrupt status bit if
that bit is already set. (Instance 3 of 3)*/
//====================================================================

#define  TIMERS_TMR_IERN2_RESERVED1_MASK 0xfffffff8
#define  TIMERS_TMR_IERN2_RESERVED1_SHIFT 3
#define  TIMERS_TMR_IERN2_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_IERN2_RESERVED1_MASK) >> TIMERS_TMR_IERN2_RESERVED1_SHIFT)
#define  TIMERS_TMR_IERN2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_IERN2_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_IERN2_RESERVED1_SHIFT))

#define  TIMERS_TMR_IERN2_IE2_MASK 0x4
#define  TIMERS_TMR_IERN2_IE2_SHIFT 2
#define  TIMERS_TMR_IERN2_IE2_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_IERN2_IE2_MASK) >> TIMERS_TMR_IERN2_IE2_SHIFT)
#define  TIMERS_TMR_IERN2_IE2_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_IERN2_IE2_MASK) | (((uint32_t)val) << TIMERS_TMR_IERN2_IE2_SHIFT))

#define  TIMERS_TMR_IERN2_IE1_MASK 0x2
#define  TIMERS_TMR_IERN2_IE1_SHIFT 1
#define  TIMERS_TMR_IERN2_IE1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_IERN2_IE1_MASK) >> TIMERS_TMR_IERN2_IE1_SHIFT)
#define  TIMERS_TMR_IERN2_IE1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_IERN2_IE1_MASK) | (((uint32_t)val) << TIMERS_TMR_IERN2_IE1_SHIFT))

#define  TIMERS_TMR_IERN2_IE0_MASK 0x1
#define  TIMERS_TMR_IERN2_IE0_SHIFT 0
#define  TIMERS_TMR_IERN2_IE0_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_IERN2_IE0_MASK) >> TIMERS_TMR_IERN2_IE0_SHIFT)
#define  TIMERS_TMR_IERN2_IE0_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_IERN2_IE0_MASK) | (((uint32_t)val) << TIMERS_TMR_IERN2_IE0_SHIFT))

//====================================================================
//Register: Timer Preload Value Registers (Instance 1 of 3) (TMR_PLVRn0)
/** \brief Each Timer Count Register has a 32-bit-wide Timer Preload Value Register that
loads the Timer Count Register when a match occurs between TMR_Tn_Mm and the
Timer Count Register. The corresponding Timer Preload Control Register selects
the match comparator. (Instance 1 of 3)*/
//====================================================================

#define  TIMERS_TMR_PLVRN0_TPLVRN_MASK 0xffffffff
#define  TIMERS_TMR_PLVRN0_TPLVRN_SHIFT 0
#define  TIMERS_TMR_PLVRN0_TPLVRN_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_PLVRN0_TPLVRN_MASK) >> TIMERS_TMR_PLVRN0_TPLVRN_SHIFT)
#define  TIMERS_TMR_PLVRN0_TPLVRN_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_PLVRN0_TPLVRN_MASK) | (((uint32_t)val) << TIMERS_TMR_PLVRN0_TPLVRN_SHIFT))

//====================================================================
//Register: Timer Preload Value Registers (Instance 2 of 3) (TMR_PLVRn1)
/** \brief Each Timer Count Register has a 32-bit-wide Timer Preload Value Register that
loads the Timer Count Register when a match occurs between TMR_Tn_Mm and the
Timer Count Register. The corresponding Timer Preload Control Register selects
the match comparator. (Instance 2 of 3)*/
//====================================================================

#define  TIMERS_TMR_PLVRN1_TPLVRN_MASK 0xffffffff
#define  TIMERS_TMR_PLVRN1_TPLVRN_SHIFT 0
#define  TIMERS_TMR_PLVRN1_TPLVRN_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_PLVRN1_TPLVRN_MASK) >> TIMERS_TMR_PLVRN1_TPLVRN_SHIFT)
#define  TIMERS_TMR_PLVRN1_TPLVRN_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_PLVRN1_TPLVRN_MASK) | (((uint32_t)val) << TIMERS_TMR_PLVRN1_TPLVRN_SHIFT))

//====================================================================
//Register: Timer Preload Value Registers (Instance 3 of 3) (TMR_PLVRn2)
/** \brief Each Timer Count Register has a 32-bit-wide Timer Preload Value Register that
loads the Timer Count Register when a match occurs between TMR_Tn_Mm and the
Timer Count Register. The corresponding Timer Preload Control Register selects
the match comparator. (Instance 3 of 3)*/
//====================================================================

#define  TIMERS_TMR_PLVRN2_TPLVRN_MASK 0xffffffff
#define  TIMERS_TMR_PLVRN2_TPLVRN_SHIFT 0
#define  TIMERS_TMR_PLVRN2_TPLVRN_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_PLVRN2_TPLVRN_MASK) >> TIMERS_TMR_PLVRN2_TPLVRN_SHIFT)
#define  TIMERS_TMR_PLVRN2_TPLVRN_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_PLVRN2_TPLVRN_MASK) | (((uint32_t)val) << TIMERS_TMR_PLVRN2_TPLVRN_SHIFT))

//====================================================================
//Register: Timer Preload Control Registers (Instance 1 of 3) (TMR_PLCRn0)
/** \brief Each Timer Count Register has a Timer Preload Control Register. (Instance 1 of 3)*/
//====================================================================

#define  TIMERS_TMR_PLCRN0_RESERVED1_MASK 0xfffffffc
#define  TIMERS_TMR_PLCRN0_RESERVED1_SHIFT 2
#define  TIMERS_TMR_PLCRN0_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_PLCRN0_RESERVED1_MASK) >> TIMERS_TMR_PLCRN0_RESERVED1_SHIFT)
#define  TIMERS_TMR_PLCRN0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_PLCRN0_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_PLCRN0_RESERVED1_SHIFT))

#define  TIMERS_TMR_PLCRN0_MCS_MASK 0x3
#define  TIMERS_TMR_PLCRN0_MCS_SHIFT 0
#define  TIMERS_TMR_PLCRN0_MCS_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_PLCRN0_MCS_MASK) >> TIMERS_TMR_PLCRN0_MCS_SHIFT)
#define  TIMERS_TMR_PLCRN0_MCS_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_PLCRN0_MCS_MASK) | (((uint32_t)val) << TIMERS_TMR_PLCRN0_MCS_SHIFT))

//====================================================================
//Register: Timer Preload Control Registers (Instance 2 of 3) (TMR_PLCRn1)
/** \brief Each Timer Count Register has a Timer Preload Control Register. (Instance 2 of 3)*/
//====================================================================

#define  TIMERS_TMR_PLCRN1_RESERVED1_MASK 0xfffffffc
#define  TIMERS_TMR_PLCRN1_RESERVED1_SHIFT 2
#define  TIMERS_TMR_PLCRN1_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_PLCRN1_RESERVED1_MASK) >> TIMERS_TMR_PLCRN1_RESERVED1_SHIFT)
#define  TIMERS_TMR_PLCRN1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_PLCRN1_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_PLCRN1_RESERVED1_SHIFT))

#define  TIMERS_TMR_PLCRN1_MCS_MASK 0x3
#define  TIMERS_TMR_PLCRN1_MCS_SHIFT 0
#define  TIMERS_TMR_PLCRN1_MCS_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_PLCRN1_MCS_MASK) >> TIMERS_TMR_PLCRN1_MCS_SHIFT)
#define  TIMERS_TMR_PLCRN1_MCS_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_PLCRN1_MCS_MASK) | (((uint32_t)val) << TIMERS_TMR_PLCRN1_MCS_SHIFT))

//====================================================================
//Register: Timer Preload Control Registers (Instance 3 of 3) (TMR_PLCRn2)
/** \brief Each Timer Count Register has a Timer Preload Control Register. (Instance 3 of 3)*/
//====================================================================

#define  TIMERS_TMR_PLCRN2_RESERVED1_MASK 0xfffffffc
#define  TIMERS_TMR_PLCRN2_RESERVED1_SHIFT 2
#define  TIMERS_TMR_PLCRN2_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_PLCRN2_RESERVED1_MASK) >> TIMERS_TMR_PLCRN2_RESERVED1_SHIFT)
#define  TIMERS_TMR_PLCRN2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_PLCRN2_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_PLCRN2_RESERVED1_SHIFT))

#define  TIMERS_TMR_PLCRN2_MCS_MASK 0x3
#define  TIMERS_TMR_PLCRN2_MCS_SHIFT 0
#define  TIMERS_TMR_PLCRN2_MCS_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_PLCRN2_MCS_MASK) >> TIMERS_TMR_PLCRN2_MCS_SHIFT)
#define  TIMERS_TMR_PLCRN2_MCS_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_PLCRN2_MCS_MASK) | (((uint32_t)val) << TIMERS_TMR_PLCRN2_MCS_SHIFT))

//====================================================================
//Register: Timers Watchdog Match Enable Register (TMR_WMER)
/** \brief The Watchdog Enable register contains a WDT enable bit, which only the user
sets. The Timers Watchdog First Access and Timers Watchdog Second Access
Registers protect write access to this register.*/
//====================================================================

#define  TIMERS_TMR_WMER_RESERVED1_MASK 0xfffffffc
#define  TIMERS_TMR_WMER_RESERVED1_SHIFT 2
#define  TIMERS_TMR_WMER_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_WMER_RESERVED1_MASK) >> TIMERS_TMR_WMER_RESERVED1_SHIFT)
#define  TIMERS_TMR_WMER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_WMER_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_WMER_RESERVED1_SHIFT))

#define  TIMERS_TMR_WMER_WRIE_MASK 0x2
#define  TIMERS_TMR_WMER_WRIE_SHIFT 1
#define  TIMERS_TMR_WMER_WRIE_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_WMER_WRIE_MASK) >> TIMERS_TMR_WMER_WRIE_SHIFT)
#define  TIMERS_TMR_WMER_WRIE_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_WMER_WRIE_MASK) | (((uint32_t)val) << TIMERS_TMR_WMER_WRIE_SHIFT))

#define  TIMERS_TMR_WMER_WE_MASK 0x1
#define  TIMERS_TMR_WMER_WE_SHIFT 0
#define  TIMERS_TMR_WMER_WE_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_WMER_WE_MASK) >> TIMERS_TMR_WMER_WE_SHIFT)
#define  TIMERS_TMR_WMER_WE_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_WMER_WE_MASK) | (((uint32_t)val) << TIMERS_TMR_WMER_WE_SHIFT))

//====================================================================
//Register: Timers Watchdog Match Register (TMR_WMR)
/** \brief This Match register is compared to the watchdog timer. The watchdog timer resets
the processor when there is a match and the <Watchdog reset/interrupt
enable> field in the Timers Watchdog Match Enable Register is set.*/
//====================================================================

#define  TIMERS_TMR_WMR_RESERVED1_MASK 0xffff0000
#define  TIMERS_TMR_WMR_RESERVED1_SHIFT 16
#define  TIMERS_TMR_WMR_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_WMR_RESERVED1_MASK) >> TIMERS_TMR_WMR_RESERVED1_SHIFT)
#define  TIMERS_TMR_WMR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_WMR_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_WMR_RESERVED1_SHIFT))

#define  TIMERS_TMR_WMR_WTM_MASK 0xffff
#define  TIMERS_TMR_WMR_WTM_SHIFT 0
#define  TIMERS_TMR_WMR_WTM_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_WMR_WTM_MASK) >> TIMERS_TMR_WMR_WTM_SHIFT)
#define  TIMERS_TMR_WMR_WTM_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_WMR_WTM_MASK) | (((uint32_t)val) << TIMERS_TMR_WMR_WTM_SHIFT))

//====================================================================
//Register: Timers Watchdog Value Register (TMR_WVR)
//====================================================================

#define  TIMERS_TMR_WVR_RESERVED1_MASK 0xffff0000
#define  TIMERS_TMR_WVR_RESERVED1_SHIFT 16
#define  TIMERS_TMR_WVR_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_WVR_RESERVED1_MASK) >> TIMERS_TMR_WVR_RESERVED1_SHIFT)
#define  TIMERS_TMR_WVR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_WVR_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_WVR_RESERVED1_SHIFT))

#define  TIMERS_TMR_WVR_WTV_MASK 0xffff
#define  TIMERS_TMR_WVR_WTV_SHIFT 0
#define  TIMERS_TMR_WVR_WTV_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_WVR_WTV_MASK) >> TIMERS_TMR_WVR_WTV_SHIFT)
#define  TIMERS_TMR_WVR_WTV_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_WVR_WTV_MASK) | (((uint32_t)val) << TIMERS_TMR_WVR_WTV_SHIFT))

//====================================================================
//Register: Timers Watchdog Status Register (TMR_WSR)
/** \brief This register indicates whether a WDT reset has occurred and caused a system
reset. This bit is set when wdt_src_rst# is asserted and is cleared by writing
a logical 0 to this register. Clearing this bit is not required for the WDT to
be re-activated after a WDT reset event.*/
//====================================================================

#define  TIMERS_TMR_WSR_RESERVED1_MASK 0xfffffffe
#define  TIMERS_TMR_WSR_RESERVED1_SHIFT 1
#define  TIMERS_TMR_WSR_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_WSR_RESERVED1_MASK) >> TIMERS_TMR_WSR_RESERVED1_SHIFT)
#define  TIMERS_TMR_WSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_WSR_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_WSR_RESERVED1_SHIFT))

#define  TIMERS_TMR_WSR_WTS_MASK 0x1
#define  TIMERS_TMR_WSR_WTS_SHIFT 0
#define  TIMERS_TMR_WSR_WTS_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_WSR_WTS_MASK) >> TIMERS_TMR_WSR_WTS_SHIFT)
#define  TIMERS_TMR_WSR_WTS_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_WSR_WTS_MASK) | (((uint32_t)val) << TIMERS_TMR_WSR_WTS_SHIFT))

//====================================================================
//Register: Timer Interrupt Clear Registers (Instance 1 of 3) (TMR_ICRn0)
/** \brief These three registers contain three clear bits (one per corresponding interrupt
source) that reset the timers level-sensitive interrupt request to the interrupt
controller. Each Match register has a corresponding clear bit. The interrupt is
cleared by setting the respective bit position. The register is not used in case
of an edge-sensitive interrupt. (Instance 1 of 3)*/
//====================================================================

#define  TIMERS_TMR_ICRN0_RESERVED1_MASK 0xfffffff8
#define  TIMERS_TMR_ICRN0_RESERVED1_SHIFT 3
#define  TIMERS_TMR_ICRN0_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_ICRN0_RESERVED1_MASK) >> TIMERS_TMR_ICRN0_RESERVED1_SHIFT)
#define  TIMERS_TMR_ICRN0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_ICRN0_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_ICRN0_RESERVED1_SHIFT))

#define  TIMERS_TMR_ICRN0_TCLR2_MASK 0x4
#define  TIMERS_TMR_ICRN0_TCLR2_SHIFT 2
#define  TIMERS_TMR_ICRN0_TCLR2_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_ICRN0_TCLR2_MASK) >> TIMERS_TMR_ICRN0_TCLR2_SHIFT)
#define  TIMERS_TMR_ICRN0_TCLR2_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_ICRN0_TCLR2_MASK) | (((uint32_t)val) << TIMERS_TMR_ICRN0_TCLR2_SHIFT))

#define  TIMERS_TMR_ICRN0_TCLR1_MASK 0x2
#define  TIMERS_TMR_ICRN0_TCLR1_SHIFT 1
#define  TIMERS_TMR_ICRN0_TCLR1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_ICRN0_TCLR1_MASK) >> TIMERS_TMR_ICRN0_TCLR1_SHIFT)
#define  TIMERS_TMR_ICRN0_TCLR1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_ICRN0_TCLR1_MASK) | (((uint32_t)val) << TIMERS_TMR_ICRN0_TCLR1_SHIFT))

#define  TIMERS_TMR_ICRN0_TCLR0_MASK 0x1
#define  TIMERS_TMR_ICRN0_TCLR0_SHIFT 0
#define  TIMERS_TMR_ICRN0_TCLR0_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_ICRN0_TCLR0_MASK) >> TIMERS_TMR_ICRN0_TCLR0_SHIFT)
#define  TIMERS_TMR_ICRN0_TCLR0_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_ICRN0_TCLR0_MASK) | (((uint32_t)val) << TIMERS_TMR_ICRN0_TCLR0_SHIFT))

//====================================================================
//Register: Timer Interrupt Clear Registers (Instance 2 of 3) (TMR_ICRn1)
/** \brief These three registers contain three clear bits (one per corresponding interrupt
source) that reset the timers level-sensitive interrupt request to the interrupt
controller. Each Match register has a corresponding clear bit. The interrupt is
cleared by setting the respective bit position. The register is not used in case
of an edge-sensitive interrupt. (Instance 2 of 3)*/
//====================================================================

#define  TIMERS_TMR_ICRN1_RESERVED1_MASK 0xfffffff8
#define  TIMERS_TMR_ICRN1_RESERVED1_SHIFT 3
#define  TIMERS_TMR_ICRN1_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_ICRN1_RESERVED1_MASK) >> TIMERS_TMR_ICRN1_RESERVED1_SHIFT)
#define  TIMERS_TMR_ICRN1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_ICRN1_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_ICRN1_RESERVED1_SHIFT))

#define  TIMERS_TMR_ICRN1_TCLR2_MASK 0x4
#define  TIMERS_TMR_ICRN1_TCLR2_SHIFT 2
#define  TIMERS_TMR_ICRN1_TCLR2_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_ICRN1_TCLR2_MASK) >> TIMERS_TMR_ICRN1_TCLR2_SHIFT)
#define  TIMERS_TMR_ICRN1_TCLR2_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_ICRN1_TCLR2_MASK) | (((uint32_t)val) << TIMERS_TMR_ICRN1_TCLR2_SHIFT))

#define  TIMERS_TMR_ICRN1_TCLR1_MASK 0x2
#define  TIMERS_TMR_ICRN1_TCLR1_SHIFT 1
#define  TIMERS_TMR_ICRN1_TCLR1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_ICRN1_TCLR1_MASK) >> TIMERS_TMR_ICRN1_TCLR1_SHIFT)
#define  TIMERS_TMR_ICRN1_TCLR1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_ICRN1_TCLR1_MASK) | (((uint32_t)val) << TIMERS_TMR_ICRN1_TCLR1_SHIFT))

#define  TIMERS_TMR_ICRN1_TCLR0_MASK 0x1
#define  TIMERS_TMR_ICRN1_TCLR0_SHIFT 0
#define  TIMERS_TMR_ICRN1_TCLR0_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_ICRN1_TCLR0_MASK) >> TIMERS_TMR_ICRN1_TCLR0_SHIFT)
#define  TIMERS_TMR_ICRN1_TCLR0_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_ICRN1_TCLR0_MASK) | (((uint32_t)val) << TIMERS_TMR_ICRN1_TCLR0_SHIFT))

//====================================================================
//Register: Timer Interrupt Clear Registers (Instance 3 of 3) (TMR_ICRn2)
/** \brief These three registers contain three clear bits (one per corresponding interrupt
source) that reset the timers level-sensitive interrupt request to the interrupt
controller. Each Match register has a corresponding clear bit. The interrupt is
cleared by setting the respective bit position. The register is not used in case
of an edge-sensitive interrupt. (Instance 3 of 3)*/
//====================================================================

#define  TIMERS_TMR_ICRN2_RESERVED1_MASK 0xfffffff8
#define  TIMERS_TMR_ICRN2_RESERVED1_SHIFT 3
#define  TIMERS_TMR_ICRN2_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_ICRN2_RESERVED1_MASK) >> TIMERS_TMR_ICRN2_RESERVED1_SHIFT)
#define  TIMERS_TMR_ICRN2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_ICRN2_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_ICRN2_RESERVED1_SHIFT))

#define  TIMERS_TMR_ICRN2_TCLR2_MASK 0x4
#define  TIMERS_TMR_ICRN2_TCLR2_SHIFT 2
#define  TIMERS_TMR_ICRN2_TCLR2_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_ICRN2_TCLR2_MASK) >> TIMERS_TMR_ICRN2_TCLR2_SHIFT)
#define  TIMERS_TMR_ICRN2_TCLR2_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_ICRN2_TCLR2_MASK) | (((uint32_t)val) << TIMERS_TMR_ICRN2_TCLR2_SHIFT))

#define  TIMERS_TMR_ICRN2_TCLR1_MASK 0x2
#define  TIMERS_TMR_ICRN2_TCLR1_SHIFT 1
#define  TIMERS_TMR_ICRN2_TCLR1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_ICRN2_TCLR1_MASK) >> TIMERS_TMR_ICRN2_TCLR1_SHIFT)
#define  TIMERS_TMR_ICRN2_TCLR1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_ICRN2_TCLR1_MASK) | (((uint32_t)val) << TIMERS_TMR_ICRN2_TCLR1_SHIFT))

#define  TIMERS_TMR_ICRN2_TCLR0_MASK 0x1
#define  TIMERS_TMR_ICRN2_TCLR0_SHIFT 0
#define  TIMERS_TMR_ICRN2_TCLR0_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_ICRN2_TCLR0_MASK) >> TIMERS_TMR_ICRN2_TCLR0_SHIFT)
#define  TIMERS_TMR_ICRN2_TCLR0_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_ICRN2_TCLR0_MASK) | (((uint32_t)val) << TIMERS_TMR_ICRN2_TCLR0_SHIFT))

//====================================================================
//Register: Timers Watchdog Interrupt Clear Register (TMR_WICR)
/** \brief This register contains a clear bit that resets the WDT interrupt request to the
interrupt controller.*/
//====================================================================

#define  TIMERS_TMR_WICR_RESERVED1_MASK 0xfffffffe
#define  TIMERS_TMR_WICR_RESERVED1_SHIFT 1
#define  TIMERS_TMR_WICR_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_WICR_RESERVED1_MASK) >> TIMERS_TMR_WICR_RESERVED1_SHIFT)
#define  TIMERS_TMR_WICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_WICR_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_WICR_RESERVED1_SHIFT))

#define  TIMERS_TMR_WICR_WICLR_MASK 0x1
#define  TIMERS_TMR_WICR_WICLR_SHIFT 0
#define  TIMERS_TMR_WICR_WICLR_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_WICR_WICLR_MASK) >> TIMERS_TMR_WICR_WICLR_SHIFT)
#define  TIMERS_TMR_WICR_WICLR_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_WICR_WICLR_MASK) | (((uint32_t)val) << TIMERS_TMR_WICR_WICLR_SHIFT))

//====================================================================
//Register: Timers Count Enable Register (TMR_CER)
/** \brief This register contains a count enable bit for each timer. After being enabled,
the corresponding Timer Count Register restarts the count from the value
prescribed by the Timer Preload Value Register.*/
//====================================================================

#define  TIMERS_TMR_CER_RESERVED1_MASK 0xfffffff8
#define  TIMERS_TMR_CER_RESERVED1_SHIFT 3
#define  TIMERS_TMR_CER_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_CER_RESERVED1_MASK) >> TIMERS_TMR_CER_RESERVED1_SHIFT)
#define  TIMERS_TMR_CER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_CER_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_CER_RESERVED1_SHIFT))

#define  TIMERS_TMR_CER_T2EN_MASK 0x4
#define  TIMERS_TMR_CER_T2EN_SHIFT 2
#define  TIMERS_TMR_CER_T2EN_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_CER_T2EN_MASK) >> TIMERS_TMR_CER_T2EN_SHIFT)
#define  TIMERS_TMR_CER_T2EN_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_CER_T2EN_MASK) | (((uint32_t)val) << TIMERS_TMR_CER_T2EN_SHIFT))

#define  TIMERS_TMR_CER_T1EN_MASK 0x2
#define  TIMERS_TMR_CER_T1EN_SHIFT 1
#define  TIMERS_TMR_CER_T1EN_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_CER_T1EN_MASK) >> TIMERS_TMR_CER_T1EN_SHIFT)
#define  TIMERS_TMR_CER_T1EN_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_CER_T1EN_MASK) | (((uint32_t)val) << TIMERS_TMR_CER_T1EN_SHIFT))

#define  TIMERS_TMR_CER_T0EN_MASK 0x1
#define  TIMERS_TMR_CER_T0EN_SHIFT 0
#define  TIMERS_TMR_CER_T0EN_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_CER_T0EN_MASK) >> TIMERS_TMR_CER_T0EN_SHIFT)
#define  TIMERS_TMR_CER_T0EN_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_CER_T0EN_MASK) | (((uint32_t)val) << TIMERS_TMR_CER_T0EN_SHIFT))

//====================================================================
//Register: Timers Count Mode Register (TMR_CMR)
/** \brief This register contains a count mode bit for each timer. The processor Timer
Count Register operates only in periodic timer mode, it does not operate in
one-shot mode.*/
//====================================================================

#define  TIMERS_TMR_CMR_RESERVED1_MASK 0xfffffff8
#define  TIMERS_TMR_CMR_RESERVED1_SHIFT 3
#define  TIMERS_TMR_CMR_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_CMR_RESERVED1_MASK) >> TIMERS_TMR_CMR_RESERVED1_SHIFT)
#define  TIMERS_TMR_CMR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_CMR_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_CMR_RESERVED1_SHIFT))

#define  TIMERS_TMR_CMR_T2MODE_MASK 0x4
#define  TIMERS_TMR_CMR_T2MODE_SHIFT 2
#define  TIMERS_TMR_CMR_T2MODE_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_CMR_T2MODE_MASK) >> TIMERS_TMR_CMR_T2MODE_SHIFT)
#define  TIMERS_TMR_CMR_T2MODE_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_CMR_T2MODE_MASK) | (((uint32_t)val) << TIMERS_TMR_CMR_T2MODE_SHIFT))

#define  TIMERS_TMR_CMR_T1MODE_MASK 0x2
#define  TIMERS_TMR_CMR_T1MODE_SHIFT 1
#define  TIMERS_TMR_CMR_T1MODE_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_CMR_T1MODE_MASK) >> TIMERS_TMR_CMR_T1MODE_SHIFT)
#define  TIMERS_TMR_CMR_T1MODE_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_CMR_T1MODE_MASK) | (((uint32_t)val) << TIMERS_TMR_CMR_T1MODE_SHIFT))

#define  TIMERS_TMR_CMR_T0MODE_MASK 0x1
#define  TIMERS_TMR_CMR_T0MODE_SHIFT 0
#define  TIMERS_TMR_CMR_T0MODE_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_CMR_T0MODE_MASK) >> TIMERS_TMR_CMR_T0MODE_SHIFT)
#define  TIMERS_TMR_CMR_T0MODE_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_CMR_T0MODE_MASK) | (((uint32_t)val) << TIMERS_TMR_CMR_T0MODE_SHIFT))

//====================================================================
//Register: Timer Interrupt Length Registers (Instance 1 of 3) (TMR_ILRn0)
/** \brief These three registers contain three length bits each (one per corresponding
interrupt source).
Note: These registers must remain in default mode because the INTCs are working
as level-sensitive INTCs. (Instance 1 of 3)*/
//====================================================================

#define  TIMERS_TMR_ILRN0_RESERVED1_MASK 0xfffffff8
#define  TIMERS_TMR_ILRN0_RESERVED1_SHIFT 3
#define  TIMERS_TMR_ILRN0_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_ILRN0_RESERVED1_MASK) >> TIMERS_TMR_ILRN0_RESERVED1_SHIFT)
#define  TIMERS_TMR_ILRN0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_ILRN0_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_ILRN0_RESERVED1_SHIFT))

#define  TIMERS_TMR_ILRN0_TNIL2_MASK 0x4
#define  TIMERS_TMR_ILRN0_TNIL2_SHIFT 2
#define  TIMERS_TMR_ILRN0_TNIL2_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_ILRN0_TNIL2_MASK) >> TIMERS_TMR_ILRN0_TNIL2_SHIFT)
#define  TIMERS_TMR_ILRN0_TNIL2_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_ILRN0_TNIL2_MASK) | (((uint32_t)val) << TIMERS_TMR_ILRN0_TNIL2_SHIFT))

#define  TIMERS_TMR_ILRN0_TNIL1_MASK 0x2
#define  TIMERS_TMR_ILRN0_TNIL1_SHIFT 1
#define  TIMERS_TMR_ILRN0_TNIL1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_ILRN0_TNIL1_MASK) >> TIMERS_TMR_ILRN0_TNIL1_SHIFT)
#define  TIMERS_TMR_ILRN0_TNIL1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_ILRN0_TNIL1_MASK) | (((uint32_t)val) << TIMERS_TMR_ILRN0_TNIL1_SHIFT))

#define  TIMERS_TMR_ILRN0_TNIL0_MASK 0x1
#define  TIMERS_TMR_ILRN0_TNIL0_SHIFT 0
#define  TIMERS_TMR_ILRN0_TNIL0_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_ILRN0_TNIL0_MASK) >> TIMERS_TMR_ILRN0_TNIL0_SHIFT)
#define  TIMERS_TMR_ILRN0_TNIL0_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_ILRN0_TNIL0_MASK) | (((uint32_t)val) << TIMERS_TMR_ILRN0_TNIL0_SHIFT))

//====================================================================
//Register: Timer Interrupt Length Registers (Instance 2 of 3) (TMR_ILRn1)
/** \brief These three registers contain three length bits each (one per corresponding
interrupt source).
Note: These registers must remain in default mode because the INTCs are working
as level-sensitive INTCs. (Instance 2 of 3)*/
//====================================================================

#define  TIMERS_TMR_ILRN1_RESERVED1_MASK 0xfffffff8
#define  TIMERS_TMR_ILRN1_RESERVED1_SHIFT 3
#define  TIMERS_TMR_ILRN1_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_ILRN1_RESERVED1_MASK) >> TIMERS_TMR_ILRN1_RESERVED1_SHIFT)
#define  TIMERS_TMR_ILRN1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_ILRN1_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_ILRN1_RESERVED1_SHIFT))

#define  TIMERS_TMR_ILRN1_TNIL2_MASK 0x4
#define  TIMERS_TMR_ILRN1_TNIL2_SHIFT 2
#define  TIMERS_TMR_ILRN1_TNIL2_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_ILRN1_TNIL2_MASK) >> TIMERS_TMR_ILRN1_TNIL2_SHIFT)
#define  TIMERS_TMR_ILRN1_TNIL2_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_ILRN1_TNIL2_MASK) | (((uint32_t)val) << TIMERS_TMR_ILRN1_TNIL2_SHIFT))

#define  TIMERS_TMR_ILRN1_TNIL1_MASK 0x2
#define  TIMERS_TMR_ILRN1_TNIL1_SHIFT 1
#define  TIMERS_TMR_ILRN1_TNIL1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_ILRN1_TNIL1_MASK) >> TIMERS_TMR_ILRN1_TNIL1_SHIFT)
#define  TIMERS_TMR_ILRN1_TNIL1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_ILRN1_TNIL1_MASK) | (((uint32_t)val) << TIMERS_TMR_ILRN1_TNIL1_SHIFT))

#define  TIMERS_TMR_ILRN1_TNIL0_MASK 0x1
#define  TIMERS_TMR_ILRN1_TNIL0_SHIFT 0
#define  TIMERS_TMR_ILRN1_TNIL0_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_ILRN1_TNIL0_MASK) >> TIMERS_TMR_ILRN1_TNIL0_SHIFT)
#define  TIMERS_TMR_ILRN1_TNIL0_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_ILRN1_TNIL0_MASK) | (((uint32_t)val) << TIMERS_TMR_ILRN1_TNIL0_SHIFT))

//====================================================================
//Register: Timer Interrupt Length Registers (Instance 3 of 3) (TMR_ILRn2)
/** \brief These three registers contain three length bits each (one per corresponding
interrupt source).
Note: These registers must remain in default mode because the INTCs are working
as level-sensitive INTCs. (Instance 3 of 3)*/
//====================================================================

#define  TIMERS_TMR_ILRN2_RESERVED1_MASK 0xfffffff8
#define  TIMERS_TMR_ILRN2_RESERVED1_SHIFT 3
#define  TIMERS_TMR_ILRN2_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_ILRN2_RESERVED1_MASK) >> TIMERS_TMR_ILRN2_RESERVED1_SHIFT)
#define  TIMERS_TMR_ILRN2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_ILRN2_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_ILRN2_RESERVED1_SHIFT))

#define  TIMERS_TMR_ILRN2_TNIL2_MASK 0x4
#define  TIMERS_TMR_ILRN2_TNIL2_SHIFT 2
#define  TIMERS_TMR_ILRN2_TNIL2_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_ILRN2_TNIL2_MASK) >> TIMERS_TMR_ILRN2_TNIL2_SHIFT)
#define  TIMERS_TMR_ILRN2_TNIL2_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_ILRN2_TNIL2_MASK) | (((uint32_t)val) << TIMERS_TMR_ILRN2_TNIL2_SHIFT))

#define  TIMERS_TMR_ILRN2_TNIL1_MASK 0x2
#define  TIMERS_TMR_ILRN2_TNIL1_SHIFT 1
#define  TIMERS_TMR_ILRN2_TNIL1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_ILRN2_TNIL1_MASK) >> TIMERS_TMR_ILRN2_TNIL1_SHIFT)
#define  TIMERS_TMR_ILRN2_TNIL1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_ILRN2_TNIL1_MASK) | (((uint32_t)val) << TIMERS_TMR_ILRN2_TNIL1_SHIFT))

#define  TIMERS_TMR_ILRN2_TNIL0_MASK 0x1
#define  TIMERS_TMR_ILRN2_TNIL0_SHIFT 0
#define  TIMERS_TMR_ILRN2_TNIL0_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_ILRN2_TNIL0_MASK) >> TIMERS_TMR_ILRN2_TNIL0_SHIFT)
#define  TIMERS_TMR_ILRN2_TNIL0_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_ILRN2_TNIL0_MASK) | (((uint32_t)val) << TIMERS_TMR_ILRN2_TNIL0_SHIFT))

//====================================================================
//Register: Timers Watchdog Counter Reset Register (TMR_WCR)
/** \brief This register restarts the WDT counter.*/
//====================================================================

#define  TIMERS_TMR_WCR_RESERVED1_MASK 0xfffffffe
#define  TIMERS_TMR_WCR_RESERVED1_SHIFT 1
#define  TIMERS_TMR_WCR_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_WCR_RESERVED1_MASK) >> TIMERS_TMR_WCR_RESERVED1_SHIFT)
#define  TIMERS_TMR_WCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_WCR_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_WCR_RESERVED1_SHIFT))

#define  TIMERS_TMR_WCR_WCR_MASK 0x1
#define  TIMERS_TMR_WCR_WCR_SHIFT 0
#define  TIMERS_TMR_WCR_WCR_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_WCR_WCR_MASK) >> TIMERS_TMR_WCR_WCR_SHIFT)
#define  TIMERS_TMR_WCR_WCR_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_WCR_WCR_MASK) | (((uint32_t)val) << TIMERS_TMR_WCR_WCR_SHIFT))

//====================================================================
//Register: Timers Watchdog First Access Register (TMR_WFAR)
//====================================================================

#define  TIMERS_TMR_WFAR_RESERVED1_MASK 0xffff0000
#define  TIMERS_TMR_WFAR_RESERVED1_SHIFT 16
#define  TIMERS_TMR_WFAR_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_WFAR_RESERVED1_MASK) >> TIMERS_TMR_WFAR_RESERVED1_SHIFT)
#define  TIMERS_TMR_WFAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_WFAR_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_WFAR_RESERVED1_SHIFT))

#define  TIMERS_TMR_WFAR_KEY_MASK 0xffff
#define  TIMERS_TMR_WFAR_KEY_SHIFT 0
#define  TIMERS_TMR_WFAR_KEY_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_WFAR_KEY_MASK) >> TIMERS_TMR_WFAR_KEY_SHIFT)
#define  TIMERS_TMR_WFAR_KEY_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_WFAR_KEY_MASK) | (((uint32_t)val) << TIMERS_TMR_WFAR_KEY_SHIFT))

//====================================================================
//Register: Timers Watchdog Second Access Register (TMR_WSAR)
//====================================================================

#define  TIMERS_TMR_WSAR_RESERVED1_MASK 0xffff0000
#define  TIMERS_TMR_WSAR_RESERVED1_SHIFT 16
#define  TIMERS_TMR_WSAR_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_WSAR_RESERVED1_MASK) >> TIMERS_TMR_WSAR_RESERVED1_SHIFT)
#define  TIMERS_TMR_WSAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_WSAR_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_WSAR_RESERVED1_SHIFT))

#define  TIMERS_TMR_WSAR_KEY_MASK 0xffff
#define  TIMERS_TMR_WSAR_KEY_SHIFT 0
#define  TIMERS_TMR_WSAR_KEY_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_WSAR_KEY_MASK) >> TIMERS_TMR_WSAR_KEY_SHIFT)
#define  TIMERS_TMR_WSAR_KEY_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_WSAR_KEY_MASK) | (((uint32_t)val) << TIMERS_TMR_WSAR_KEY_SHIFT))

//====================================================================
//Register: Timer Counters Value Write for Read Request Register (Instance 1 of 3) (TMR_CVWRn0)
/** \brief  (Instance 1 of 3)*/
//====================================================================

#define  TIMERS_TMR_CVWRN0_TCVWR_MASK 0xffffffff
#define  TIMERS_TMR_CVWRN0_TCVWR_SHIFT 0
#define  TIMERS_TMR_CVWRN0_TCVWR_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_CVWRN0_TCVWR_MASK) >> TIMERS_TMR_CVWRN0_TCVWR_SHIFT)
#define  TIMERS_TMR_CVWRN0_TCVWR_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_CVWRN0_TCVWR_MASK) | (((uint32_t)val) << TIMERS_TMR_CVWRN0_TCVWR_SHIFT))

//====================================================================
//Register: Timer Counters Value Write for Read Request Register (Instance 2 of 3) (TMR_CVWRn1)
/** \brief  (Instance 2 of 3)*/
//====================================================================

#define  TIMERS_TMR_CVWRN1_TCVWR_MASK 0xffffffff
#define  TIMERS_TMR_CVWRN1_TCVWR_SHIFT 0
#define  TIMERS_TMR_CVWRN1_TCVWR_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_CVWRN1_TCVWR_MASK) >> TIMERS_TMR_CVWRN1_TCVWR_SHIFT)
#define  TIMERS_TMR_CVWRN1_TCVWR_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_CVWRN1_TCVWR_MASK) | (((uint32_t)val) << TIMERS_TMR_CVWRN1_TCVWR_SHIFT))

//====================================================================
//Register: Timer Counters Value Write for Read Request Register (Instance 3 of 3) (TMR_CVWRn2)
/** \brief  (Instance 3 of 3)*/
//====================================================================

#define  TIMERS_TMR_CVWRN2_TCVWR_MASK 0xffffffff
#define  TIMERS_TMR_CVWRN2_TCVWR_SHIFT 0
#define  TIMERS_TMR_CVWRN2_TCVWR_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_CVWRN2_TCVWR_MASK) >> TIMERS_TMR_CVWRN2_TCVWR_SHIFT)
#define  TIMERS_TMR_CVWRN2_TCVWR_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_CVWRN2_TCVWR_MASK) | (((uint32_t)val) << TIMERS_TMR_CVWRN2_TCVWR_SHIFT))

//====================================================================
//Register: Timer Counters restart register (TMR_CRSR)
//====================================================================

#define  TIMERS_TMR_CRSR_RESERVED1_MASK 0xfffffff8
#define  TIMERS_TMR_CRSR_RESERVED1_SHIFT 3
#define  TIMERS_TMR_CRSR_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_CRSR_RESERVED1_MASK) >> TIMERS_TMR_CRSR_RESERVED1_SHIFT)
#define  TIMERS_TMR_CRSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_CRSR_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_CRSR_RESERVED1_SHIFT))

#define  TIMERS_TMR_CRSR_T2RS_MASK 0x4
#define  TIMERS_TMR_CRSR_T2RS_SHIFT 2
#define  TIMERS_TMR_CRSR_T2RS_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_CRSR_T2RS_MASK) >> TIMERS_TMR_CRSR_T2RS_SHIFT)
#define  TIMERS_TMR_CRSR_T2RS_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_CRSR_T2RS_MASK) | (((uint32_t)val) << TIMERS_TMR_CRSR_T2RS_SHIFT))

#define  TIMERS_TMR_CRSR_T1RS_MASK 0x2
#define  TIMERS_TMR_CRSR_T1RS_SHIFT 1
#define  TIMERS_TMR_CRSR_T1RS_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_CRSR_T1RS_MASK) >> TIMERS_TMR_CRSR_T1RS_SHIFT)
#define  TIMERS_TMR_CRSR_T1RS_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_CRSR_T1RS_MASK) | (((uint32_t)val) << TIMERS_TMR_CRSR_T1RS_SHIFT))

#define  TIMERS_TMR_CRSR_T0RS_MASK 0x1
#define  TIMERS_TMR_CRSR_T0RS_SHIFT 0
#define  TIMERS_TMR_CRSR_T0RS_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_CRSR_T0RS_MASK) >> TIMERS_TMR_CRSR_T0RS_SHIFT)
#define  TIMERS_TMR_CRSR_T0RS_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_CRSR_T0RS_MASK) | (((uint32_t)val) << TIMERS_TMR_CRSR_T0RS_SHIFT))

//====================================================================
//Register: Timers On the Fly Configuration Register (TMR_OFCR)
//====================================================================

#define  TIMERS_TMR_OFCR_RESERVED1_MASK 0xfffffff8
#define  TIMERS_TMR_OFCR_RESERVED1_SHIFT 3
#define  TIMERS_TMR_OFCR_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_OFCR_RESERVED1_MASK) >> TIMERS_TMR_OFCR_RESERVED1_SHIFT)
#define  TIMERS_TMR_OFCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_OFCR_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_TMR_OFCR_RESERVED1_SHIFT))

#define  TIMERS_TMR_OFCR_T2OFC_MASK 0x4
#define  TIMERS_TMR_OFCR_T2OFC_SHIFT 2
#define  TIMERS_TMR_OFCR_T2OFC_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_OFCR_T2OFC_MASK) >> TIMERS_TMR_OFCR_T2OFC_SHIFT)
#define  TIMERS_TMR_OFCR_T2OFC_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_OFCR_T2OFC_MASK) | (((uint32_t)val) << TIMERS_TMR_OFCR_T2OFC_SHIFT))

#define  TIMERS_TMR_OFCR_T1OFC_MASK 0x2
#define  TIMERS_TMR_OFCR_T1OFC_SHIFT 1
#define  TIMERS_TMR_OFCR_T1OFC_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_OFCR_T1OFC_MASK) >> TIMERS_TMR_OFCR_T1OFC_SHIFT)
#define  TIMERS_TMR_OFCR_T1OFC_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_OFCR_T1OFC_MASK) | (((uint32_t)val) << TIMERS_TMR_OFCR_T1OFC_SHIFT))

#define  TIMERS_TMR_OFCR_T0OFC_MASK 0x1
#define  TIMERS_TMR_OFCR_T0OFC_SHIFT 0
#define  TIMERS_TMR_OFCR_T0OFC_MASK_SHIFT(reg) (((reg) & TIMERS_TMR_OFCR_T0OFC_MASK) >> TIMERS_TMR_OFCR_T0OFC_SHIFT)
#define  TIMERS_TMR_OFCR_T0OFC_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_TMR_OFCR_T0OFC_MASK) | (((uint32_t)val) << TIMERS_TMR_OFCR_T0OFC_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  TIMERS_REV0_MAJ_MASK 0xffff0000
#define  TIMERS_REV0_MAJ_SHIFT 16
#define  TIMERS_REV0_MAJ_MASK_SHIFT(reg) (((reg) & TIMERS_REV0_MAJ_MASK) >> TIMERS_REV0_MAJ_SHIFT)
#define  TIMERS_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_REV0_MAJ_MASK) | (((uint32_t)val) << TIMERS_REV0_MAJ_SHIFT))

#define  TIMERS_REV0_MID_MASK 0xffff
#define  TIMERS_REV0_MID_SHIFT 0
#define  TIMERS_REV0_MID_MASK_SHIFT(reg) (((reg) & TIMERS_REV0_MID_MASK) >> TIMERS_REV0_MID_SHIFT)
#define  TIMERS_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_REV0_MID_MASK) | (((uint32_t)val) << TIMERS_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  TIMERS_REV1_RESERVED1_MASK 0xffff0000
#define  TIMERS_REV1_RESERVED1_SHIFT 16
#define  TIMERS_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMERS_REV1_RESERVED1_MASK) >> TIMERS_REV1_RESERVED1_SHIFT)
#define  TIMERS_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_REV1_RESERVED1_MASK) | (((uint32_t)val) << TIMERS_REV1_RESERVED1_SHIFT))

#define  TIMERS_REV1_CFG_MASK 0xffff
#define  TIMERS_REV1_CFG_SHIFT 0
#define  TIMERS_REV1_CFG_MASK_SHIFT(reg) (((reg) & TIMERS_REV1_CFG_MASK) >> TIMERS_REV1_CFG_SHIFT)
#define  TIMERS_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~TIMERS_REV1_CFG_MASK) | (((uint32_t)val) << TIMERS_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: AIB Access Registers (AIBAccess)
//
//====================================================================

//====================================================================
//Register: AIB Code Locked First Access Register (APBC_ASFAR)
//====================================================================

#define  AIBACCESS_APBC_ASFAR_RESERVED1_MASK 0xffff0000
#define  AIBACCESS_APBC_ASFAR_RESERVED1_SHIFT 16
#define  AIBACCESS_APBC_ASFAR_RESERVED1_MASK_SHIFT(reg) (((reg) & AIBACCESS_APBC_ASFAR_RESERVED1_MASK) >> AIBACCESS_APBC_ASFAR_RESERVED1_SHIFT)
#define  AIBACCESS_APBC_ASFAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIBACCESS_APBC_ASFAR_RESERVED1_MASK) | (((uint32_t)val) << AIBACCESS_APBC_ASFAR_RESERVED1_SHIFT))

#define  AIBACCESS_APBC_ASFAR_ASFAR_MASK 0xffff
#define  AIBACCESS_APBC_ASFAR_ASFAR_SHIFT 0
#define  AIBACCESS_APBC_ASFAR_ASFAR_MASK_SHIFT(reg) (((reg) & AIBACCESS_APBC_ASFAR_ASFAR_MASK) >> AIBACCESS_APBC_ASFAR_ASFAR_SHIFT)
#define  AIBACCESS_APBC_ASFAR_ASFAR_REPLACE_VAL(reg,val) (((reg) & ~AIBACCESS_APBC_ASFAR_ASFAR_MASK) | (((uint32_t)val) << AIBACCESS_APBC_ASFAR_ASFAR_SHIFT))

//====================================================================
//Register: AIB Code Locked Second Access Register (APBC_ASSAR)
//====================================================================

#define  AIBACCESS_APBC_ASSAR_RESERVED1_MASK 0xffff0000
#define  AIBACCESS_APBC_ASSAR_RESERVED1_SHIFT 16
#define  AIBACCESS_APBC_ASSAR_RESERVED1_MASK_SHIFT(reg) (((reg) & AIBACCESS_APBC_ASSAR_RESERVED1_MASK) >> AIBACCESS_APBC_ASSAR_RESERVED1_SHIFT)
#define  AIBACCESS_APBC_ASSAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIBACCESS_APBC_ASSAR_RESERVED1_MASK) | (((uint32_t)val) << AIBACCESS_APBC_ASSAR_RESERVED1_SHIFT))

#define  AIBACCESS_APBC_ASSAR_ASSAR_MASK 0xffff
#define  AIBACCESS_APBC_ASSAR_ASSAR_SHIFT 0
#define  AIBACCESS_APBC_ASSAR_ASSAR_MASK_SHIFT(reg) (((reg) & AIBACCESS_APBC_ASSAR_ASSAR_MASK) >> AIBACCESS_APBC_ASSAR_ASSAR_SHIFT)
#define  AIBACCESS_APBC_ASSAR_ASSAR_REPLACE_VAL(reg,val) (((reg) & ~AIBACCESS_APBC_ASSAR_ASSAR_MASK) | (((uint32_t)val) << AIBACCESS_APBC_ASSAR_ASSAR_SHIFT))

//====================================================================
//
//Register File: UART4 Registers (UART4)
//
//====================================================================

//====================================================================
//Register: Receive Buffer Register (UART_RBR)
/** \brief In non-FIFO mode, this register holds the character(s) received by the UART
Receive Shift Register. If this register is configured to use fewer than eight
bits, the bits are right-justified and the most significant bits (MSbs) are
zeroed. Reading the register empties the register and clears the <Data
Ready> field in the Line Status Register.
This register latches the value of the data byte at the front of the FIFO in
FIFO mode.*/
//====================================================================

#define  UART4_UART_RBR_BYTE_3_MASK 0xff000000
#define  UART4_UART_RBR_BYTE_3_SHIFT 24
#define  UART4_UART_RBR_BYTE_3_MASK_SHIFT(reg) (((reg) & UART4_UART_RBR_BYTE_3_MASK) >> UART4_UART_RBR_BYTE_3_SHIFT)
#define  UART4_UART_RBR_BYTE_3_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_RBR_BYTE_3_MASK) | (((uint32_t)val) << UART4_UART_RBR_BYTE_3_SHIFT))

#define  UART4_UART_RBR_BYTE_2_MASK 0xff0000
#define  UART4_UART_RBR_BYTE_2_SHIFT 16
#define  UART4_UART_RBR_BYTE_2_MASK_SHIFT(reg) (((reg) & UART4_UART_RBR_BYTE_2_MASK) >> UART4_UART_RBR_BYTE_2_SHIFT)
#define  UART4_UART_RBR_BYTE_2_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_RBR_BYTE_2_MASK) | (((uint32_t)val) << UART4_UART_RBR_BYTE_2_SHIFT))

#define  UART4_UART_RBR_BYTE_1_MASK 0xff00
#define  UART4_UART_RBR_BYTE_1_SHIFT 8
#define  UART4_UART_RBR_BYTE_1_MASK_SHIFT(reg) (((reg) & UART4_UART_RBR_BYTE_1_MASK) >> UART4_UART_RBR_BYTE_1_SHIFT)
#define  UART4_UART_RBR_BYTE_1_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_RBR_BYTE_1_MASK) | (((uint32_t)val) << UART4_UART_RBR_BYTE_1_SHIFT))

#define  UART4_UART_RBR_BYTE_0_MASK 0xff
#define  UART4_UART_RBR_BYTE_0_SHIFT 0
#define  UART4_UART_RBR_BYTE_0_MASK_SHIFT(reg) (((reg) & UART4_UART_RBR_BYTE_0_MASK) >> UART4_UART_RBR_BYTE_0_SHIFT)
#define  UART4_UART_RBR_BYTE_0_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_RBR_BYTE_0_MASK) | (((uint32_t)val) << UART4_UART_RBR_BYTE_0_SHIFT))

//====================================================================
//Register: Transmit Holding Register (UART_THR)
/** \brief This register holds the data byte(s) to be transmitted next in non-FIFO mode.
When the Transmit Shift Register is emptied, the contents of this register are
loaded into the Transmit Shift Register and the <Transmit Data Request> field in
the Line Status Register is set.
A write to Transmit Holding Register puts data into the top of the FIFO in FIFO
mode. The data at the front of the FIFO is loaded into the Transmit Shift
Register when the Transmit Shift Register is empty.*/
//====================================================================

#define  UART4_UART_THR_BYTE_3_MASK 0xff000000
#define  UART4_UART_THR_BYTE_3_SHIFT 24
#define  UART4_UART_THR_BYTE_3_MASK_SHIFT(reg) (((reg) & UART4_UART_THR_BYTE_3_MASK) >> UART4_UART_THR_BYTE_3_SHIFT)
#define  UART4_UART_THR_BYTE_3_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_THR_BYTE_3_MASK) | (((uint32_t)val) << UART4_UART_THR_BYTE_3_SHIFT))

#define  UART4_UART_THR_BYTE_2_MASK 0xff0000
#define  UART4_UART_THR_BYTE_2_SHIFT 16
#define  UART4_UART_THR_BYTE_2_MASK_SHIFT(reg) (((reg) & UART4_UART_THR_BYTE_2_MASK) >> UART4_UART_THR_BYTE_2_SHIFT)
#define  UART4_UART_THR_BYTE_2_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_THR_BYTE_2_MASK) | (((uint32_t)val) << UART4_UART_THR_BYTE_2_SHIFT))

#define  UART4_UART_THR_BYTE_1_MASK 0xff00
#define  UART4_UART_THR_BYTE_1_SHIFT 8
#define  UART4_UART_THR_BYTE_1_MASK_SHIFT(reg) (((reg) & UART4_UART_THR_BYTE_1_MASK) >> UART4_UART_THR_BYTE_1_SHIFT)
#define  UART4_UART_THR_BYTE_1_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_THR_BYTE_1_MASK) | (((uint32_t)val) << UART4_UART_THR_BYTE_1_SHIFT))

#define  UART4_UART_THR_BYTE_0_MASK 0xff
#define  UART4_UART_THR_BYTE_0_SHIFT 0
#define  UART4_UART_THR_BYTE_0_MASK_SHIFT(reg) (((reg) & UART4_UART_THR_BYTE_0_MASK) >> UART4_UART_THR_BYTE_0_SHIFT)
#define  UART4_UART_THR_BYTE_0_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_THR_BYTE_0_MASK) | (((uint32_t)val) << UART4_UART_THR_BYTE_0_SHIFT))

//====================================================================
//Register: Divisor Latch Low Byte Register (UART_DLL)
//====================================================================

#define  UART4_UART_DLL_RESERVED1_MASK 0xffffff00
#define  UART4_UART_DLL_RESERVED1_SHIFT 8
#define  UART4_UART_DLL_RESERVED1_MASK_SHIFT(reg) (((reg) & UART4_UART_DLL_RESERVED1_MASK) >> UART4_UART_DLL_RESERVED1_SHIFT)
#define  UART4_UART_DLL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_DLL_RESERVED1_MASK) | (((uint32_t)val) << UART4_UART_DLL_RESERVED1_SHIFT))

#define  UART4_UART_DLL_DLL_MASK 0xff
#define  UART4_UART_DLL_DLL_SHIFT 0
#define  UART4_UART_DLL_DLL_MASK_SHIFT(reg) (((reg) & UART4_UART_DLL_DLL_MASK) >> UART4_UART_DLL_DLL_SHIFT)
#define  UART4_UART_DLL_DLL_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_DLL_DLL_MASK) | (((uint32_t)val) << UART4_UART_DLL_DLL_SHIFT))

//====================================================================
//Register: Interrupt Enable Register (UART_IER)
/** \brief This register enables the five types of interrupts that set a value in the
Interrupt Identification Register. Software must clear the appropriate bit in
this register to disable an interrupt. Software can enable some interrupts by
setting the appropriate bit.
The character timeout-indication interrupt is separated from the received
data-available interrupt to ensure that the PXA2128 Application Processor and
the DMA controller do not service the receive FIFO at the same time. When
a character-timeout-indication interrupt occurs, the PXA2128 Application
Processor must handle the data in the receive FIFO through programmed I/O.
An error interrupt is used when DMA requests are enabled. The interrupt is
generated when the <FIFO Error Status> field in the Line Status Register is set
because a receive DMA request is not generated when the receive FIFO has an
error. The error interrupt tells the PXA2128 Application Processor to handle the
data in the receive FIFO through programmed I/O. The error interrupt is enabled
when DMA requests are enabled, and it cannot be masked. Receiver line-status
interrupts occur when the error is at the front of the FIFO.
Note: When DMA requests are enabled and an interrupt occurs, software must first
read the Line Status Register to see if an error interrupt exists, then check
the Interrupt Identification Register for the source of the interrupt. Software
must read the Infrared Selected Register to determine the error condition if an
interrupt occurs and the <FIFO Error Status> field in the Line Status Register
is clear. DMA requests are automatically enabled when the last error byte is
read from the FIFO. Software is not required to check for the error interrupt if
DMA requests are disabled because an error interrupt occurs only when DMA
requests are enabled.
The <FIFO Error Status> field is used to enable DMA requests. This register also
contains the unit enable and NRZ coding enable control bits. Bits 7 through 4
are used differently from the standard 16550A register definition.
Note: Software must not set the <DMA Requests Enable> field while the <Transmit
Data Request Interrupt Enable> or <Receiver Data Available Interrupt
Enable> fields are set to ensure that the DMA controller and programmed I/O do
not access the same FIFO.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART4_UART_IER_RESERVED1_MASK 0xfffffe00
#define  UART4_UART_IER_RESERVED1_SHIFT 9
#define  UART4_UART_IER_RESERVED1_MASK_SHIFT(reg) (((reg) & UART4_UART_IER_RESERVED1_MASK) >> UART4_UART_IER_RESERVED1_SHIFT)
#define  UART4_UART_IER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_IER_RESERVED1_MASK) | (((uint32_t)val) << UART4_UART_IER_RESERVED1_SHIFT))

#define  UART4_UART_IER_FAST_MASK 0x100
#define  UART4_UART_IER_FAST_SHIFT 8
#define  UART4_UART_IER_FAST_MASK_SHIFT(reg) (((reg) & UART4_UART_IER_FAST_MASK) >> UART4_UART_IER_FAST_SHIFT)
#define  UART4_UART_IER_FAST_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_IER_FAST_MASK) | (((uint32_t)val) << UART4_UART_IER_FAST_SHIFT))

#define  UART4_UART_IER_DMAE_MASK 0x80
#define  UART4_UART_IER_DMAE_SHIFT 7
#define  UART4_UART_IER_DMAE_MASK_SHIFT(reg) (((reg) & UART4_UART_IER_DMAE_MASK) >> UART4_UART_IER_DMAE_SHIFT)
#define  UART4_UART_IER_DMAE_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_IER_DMAE_MASK) | (((uint32_t)val) << UART4_UART_IER_DMAE_SHIFT))

#define  UART4_UART_IER_UUE_MASK 0x40
#define  UART4_UART_IER_UUE_SHIFT 6
#define  UART4_UART_IER_UUE_MASK_SHIFT(reg) (((reg) & UART4_UART_IER_UUE_MASK) >> UART4_UART_IER_UUE_SHIFT)
#define  UART4_UART_IER_UUE_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_IER_UUE_MASK) | (((uint32_t)val) << UART4_UART_IER_UUE_SHIFT))

#define  UART4_UART_IER_NRZE_MASK 0x20
#define  UART4_UART_IER_NRZE_SHIFT 5
#define  UART4_UART_IER_NRZE_MASK_SHIFT(reg) (((reg) & UART4_UART_IER_NRZE_MASK) >> UART4_UART_IER_NRZE_SHIFT)
#define  UART4_UART_IER_NRZE_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_IER_NRZE_MASK) | (((uint32_t)val) << UART4_UART_IER_NRZE_SHIFT))

#define  UART4_UART_IER_RTOIE_MASK 0x10
#define  UART4_UART_IER_RTOIE_SHIFT 4
#define  UART4_UART_IER_RTOIE_MASK_SHIFT(reg) (((reg) & UART4_UART_IER_RTOIE_MASK) >> UART4_UART_IER_RTOIE_SHIFT)
#define  UART4_UART_IER_RTOIE_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_IER_RTOIE_MASK) | (((uint32_t)val) << UART4_UART_IER_RTOIE_SHIFT))

#define  UART4_UART_IER_MIE_MASK 0x8
#define  UART4_UART_IER_MIE_SHIFT 3
#define  UART4_UART_IER_MIE_MASK_SHIFT(reg) (((reg) & UART4_UART_IER_MIE_MASK) >> UART4_UART_IER_MIE_SHIFT)
#define  UART4_UART_IER_MIE_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_IER_MIE_MASK) | (((uint32_t)val) << UART4_UART_IER_MIE_SHIFT))

#define  UART4_UART_IER_RLSE_MASK 0x4
#define  UART4_UART_IER_RLSE_SHIFT 2
#define  UART4_UART_IER_RLSE_MASK_SHIFT(reg) (((reg) & UART4_UART_IER_RLSE_MASK) >> UART4_UART_IER_RLSE_SHIFT)
#define  UART4_UART_IER_RLSE_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_IER_RLSE_MASK) | (((uint32_t)val) << UART4_UART_IER_RLSE_SHIFT))

#define  UART4_UART_IER_TIE_MASK 0x2
#define  UART4_UART_IER_TIE_SHIFT 1
#define  UART4_UART_IER_TIE_MASK_SHIFT(reg) (((reg) & UART4_UART_IER_TIE_MASK) >> UART4_UART_IER_TIE_SHIFT)
#define  UART4_UART_IER_TIE_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_IER_TIE_MASK) | (((uint32_t)val) << UART4_UART_IER_TIE_SHIFT))

#define  UART4_UART_IER_RAVIE_MASK 0x1
#define  UART4_UART_IER_RAVIE_SHIFT 0
#define  UART4_UART_IER_RAVIE_MASK_SHIFT(reg) (((reg) & UART4_UART_IER_RAVIE_MASK) >> UART4_UART_IER_RAVIE_SHIFT)
#define  UART4_UART_IER_RAVIE_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_IER_RAVIE_MASK) | (((uint32_t)val) << UART4_UART_IER_RAVIE_SHIFT))

//====================================================================
//Register: Divisor Latch High Byte Register (UART_DLH)
//====================================================================

#define  UART4_UART_DLH_RESERVED1_MASK 0xffffff00
#define  UART4_UART_DLH_RESERVED1_SHIFT 8
#define  UART4_UART_DLH_RESERVED1_MASK_SHIFT(reg) (((reg) & UART4_UART_DLH_RESERVED1_MASK) >> UART4_UART_DLH_RESERVED1_SHIFT)
#define  UART4_UART_DLH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_DLH_RESERVED1_MASK) | (((uint32_t)val) << UART4_UART_DLH_RESERVED1_SHIFT))

#define  UART4_UART_DLH_DLH_MASK 0xff
#define  UART4_UART_DLH_DLH_SHIFT 0
#define  UART4_UART_DLH_DLH_MASK_SHIFT(reg) (((reg) & UART4_UART_DLH_DLH_MASK) >> UART4_UART_DLH_DLH_SHIFT)
#define  UART4_UART_DLH_DLH_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_DLH_DLH_MASK) | (((uint32_t)val) << UART4_UART_DLH_DLH_SHIFT))

//====================================================================
//Register: Interrupt Identification Register (UART_IIR)
//====================================================================

#define  UART4_UART_IIR_RESERVED1_MASK 0xffffff00
#define  UART4_UART_IIR_RESERVED1_SHIFT 8
#define  UART4_UART_IIR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART4_UART_IIR_RESERVED1_MASK) >> UART4_UART_IIR_RESERVED1_SHIFT)
#define  UART4_UART_IIR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_IIR_RESERVED1_MASK) | (((uint32_t)val) << UART4_UART_IIR_RESERVED1_SHIFT))

#define  UART4_UART_IIR_FIFOES10_MASK 0xc0
#define  UART4_UART_IIR_FIFOES10_SHIFT 6
#define  UART4_UART_IIR_FIFOES10_MASK_SHIFT(reg) (((reg) & UART4_UART_IIR_FIFOES10_MASK) >> UART4_UART_IIR_FIFOES10_SHIFT)
#define  UART4_UART_IIR_FIFOES10_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_IIR_FIFOES10_MASK) | (((uint32_t)val) << UART4_UART_IIR_FIFOES10_SHIFT))

#define  UART4_UART_IIR_EOC_MASK 0x20
#define  UART4_UART_IIR_EOC_SHIFT 5
#define  UART4_UART_IIR_EOC_MASK_SHIFT(reg) (((reg) & UART4_UART_IIR_EOC_MASK) >> UART4_UART_IIR_EOC_SHIFT)
#define  UART4_UART_IIR_EOC_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_IIR_EOC_MASK) | (((uint32_t)val) << UART4_UART_IIR_EOC_SHIFT))

#define  UART4_UART_IIR_ABL_MASK 0x10
#define  UART4_UART_IIR_ABL_SHIFT 4
#define  UART4_UART_IIR_ABL_MASK_SHIFT(reg) (((reg) & UART4_UART_IIR_ABL_MASK) >> UART4_UART_IIR_ABL_SHIFT)
#define  UART4_UART_IIR_ABL_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_IIR_ABL_MASK) | (((uint32_t)val) << UART4_UART_IIR_ABL_SHIFT))

#define  UART4_UART_IIR_TOD_MASK 0x8
#define  UART4_UART_IIR_TOD_SHIFT 3
#define  UART4_UART_IIR_TOD_MASK_SHIFT(reg) (((reg) & UART4_UART_IIR_TOD_MASK) >> UART4_UART_IIR_TOD_SHIFT)
#define  UART4_UART_IIR_TOD_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_IIR_TOD_MASK) | (((uint32_t)val) << UART4_UART_IIR_TOD_SHIFT))

#define  UART4_UART_IIR_IID10_MASK 0x6
#define  UART4_UART_IIR_IID10_SHIFT 1
#define  UART4_UART_IIR_IID10_MASK_SHIFT(reg) (((reg) & UART4_UART_IIR_IID10_MASK) >> UART4_UART_IIR_IID10_SHIFT)
#define  UART4_UART_IIR_IID10_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_IIR_IID10_MASK) | (((uint32_t)val) << UART4_UART_IIR_IID10_SHIFT))

#define  UART4_UART_IIR_NIP_MASK 0x1
#define  UART4_UART_IIR_NIP_SHIFT 0
#define  UART4_UART_IIR_NIP_MASK_SHIFT(reg) (((reg) & UART4_UART_IIR_NIP_MASK) >> UART4_UART_IIR_NIP_SHIFT)
#define  UART4_UART_IIR_NIP_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_IIR_NIP_MASK) | (((uint32_t)val) << UART4_UART_IIR_NIP_SHIFT))

//====================================================================
//Register: FIFO Control Register (UART_FCR)
/** \brief This is a write-only register that is located at the same address as the
Interrupt Identification Register, which is a read-only register. This register
enables/disables the transmit/receive FIFOs, clears the transmit/receive FIFOs,
and sets the receive FIFO trigger threshold.
Note: The trigger level must be equal to the DMA burst length programmed in the
DMA registers.
Interrupt Trigger Level - When the number of bytes in the receive FIFO equals
the interrupt trigger level programmed into this field and the
received-data-available interrupt is enabled (via the Interrupt Enable
Register), an interrupt is generated and the appropriate bits are set in the
Interrupt Identification Register. The receive DMA request is generated as well
when trigger level is reached. The trigger level must be greater than or equal
to the DMA burst size programmed in the DMA registers.
32-Bit Peripheral Bus - When clear, the UART ignores any information in the
upper three bytes of the 32-bit bus. A full- or partial-word read or write to
the UART with this field clear increments the FIFO counters by only one byte. If
this field is set, a full- or partial-word read or write increments the counter
by the number of valid bytes within the word.
Trailing Bytes - When clear, trailing bytes are handled by the PXA2128
Application Processor. When set, trailing bytes are handled automatically by the
DMA controller. See the DMA section for more information.
Transmit Interrupt Level - Setting this field causes transmitter interrupts and
DMA requests to occur when the transmit FIFO is empty. Clearing this field
causes transmitter interrupts and DMA requests to occur when the transmit FIFO
is half empty.
Reset Transmit FIFO - When this field is set, the transmit FIFO counter is reset
to clear all the bytes in the FIFO. The <Transmit Data Request> field in the
Line Status Register is set, generating a transmitter-requests-data interrupt
(<Interrupt Source Encoded> field in the Interrupt Identification Register) if
the <Transmit Data Request Interrupt Enable> field in the Interrupt Enable
Register is set. The Transmit Shift Register is not reset, it completes the
current transmission. Any DMA or transmit-FIFO-service-request interrupts are
cleared.
Note: The <Reset Transmit FIFO> field is reset to 0 automatically after the FIFO
is cleared.
Reset Receive FIFO - When this field is set, the receive FIFO counter is reset
to clear all the bytes in the FIFO. The <Data Ready> field in the Line Status
Register is cleared. All error bits in the FIFO and the <FIFO Error
Status> field in the Line Status Register are cleared. Any error bits (OE, PE,
FE, or BI) that had been set in the Line Status Register remain set. The Receive
Shift Register is not cleared. Any DMA or receive-FIFO-service-request
interrupts are cleared.
Note: The <Reset Receive FIFO> field is reset automatically to 0 after the FIFO
is cleared.
Transmit and Receive FIFO Enable - This field enables and disables the transmit
and receive FIFOs. When it is set, both FIFOs are enabled (FIFO mode). When it
is clear, the FIFOs are both disabled (non-FIFO mode). Writing 0x0 to this bit
clears all bytes in both FIFOs. When changing from FIFO mode to non-FIFO mode
and vice versa, data is cleared automatically from the FIFOs. Any DMA or
FIFO-service-request interrupts are cleared when this field is clear.
Note: This field must be 1 when other fields in this register are written, or
the other fields are not programmed.
This is a write-only register. Write 0x0 to reserved bits.*/
//====================================================================

#define  UART4_UART_FCR_RESERVED1_MASK 0xffffff00
#define  UART4_UART_FCR_RESERVED1_SHIFT 8
#define  UART4_UART_FCR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART4_UART_FCR_RESERVED1_MASK) >> UART4_UART_FCR_RESERVED1_SHIFT)
#define  UART4_UART_FCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_FCR_RESERVED1_MASK) | (((uint32_t)val) << UART4_UART_FCR_RESERVED1_SHIFT))

#define  UART4_UART_FCR_ITL_MASK 0xc0
#define  UART4_UART_FCR_ITL_SHIFT 6
#define  UART4_UART_FCR_ITL_MASK_SHIFT(reg) (((reg) & UART4_UART_FCR_ITL_MASK) >> UART4_UART_FCR_ITL_SHIFT)
#define  UART4_UART_FCR_ITL_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_FCR_ITL_MASK) | (((uint32_t)val) << UART4_UART_FCR_ITL_SHIFT))

#define  UART4_UART_FCR_BUS_MASK 0x20
#define  UART4_UART_FCR_BUS_SHIFT 5
#define  UART4_UART_FCR_BUS_MASK_SHIFT(reg) (((reg) & UART4_UART_FCR_BUS_MASK) >> UART4_UART_FCR_BUS_SHIFT)
#define  UART4_UART_FCR_BUS_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_FCR_BUS_MASK) | (((uint32_t)val) << UART4_UART_FCR_BUS_SHIFT))

#define  UART4_UART_FCR_TRAIL_MASK 0x10
#define  UART4_UART_FCR_TRAIL_SHIFT 4
#define  UART4_UART_FCR_TRAIL_MASK_SHIFT(reg) (((reg) & UART4_UART_FCR_TRAIL_MASK) >> UART4_UART_FCR_TRAIL_SHIFT)
#define  UART4_UART_FCR_TRAIL_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_FCR_TRAIL_MASK) | (((uint32_t)val) << UART4_UART_FCR_TRAIL_SHIFT))

#define  UART4_UART_FCR_TIL_MASK 0x8
#define  UART4_UART_FCR_TIL_SHIFT 3
#define  UART4_UART_FCR_TIL_MASK_SHIFT(reg) (((reg) & UART4_UART_FCR_TIL_MASK) >> UART4_UART_FCR_TIL_SHIFT)
#define  UART4_UART_FCR_TIL_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_FCR_TIL_MASK) | (((uint32_t)val) << UART4_UART_FCR_TIL_SHIFT))

#define  UART4_UART_FCR_RESETTF_MASK 0x4
#define  UART4_UART_FCR_RESETTF_SHIFT 2
#define  UART4_UART_FCR_RESETTF_MASK_SHIFT(reg) (((reg) & UART4_UART_FCR_RESETTF_MASK) >> UART4_UART_FCR_RESETTF_SHIFT)
#define  UART4_UART_FCR_RESETTF_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_FCR_RESETTF_MASK) | (((uint32_t)val) << UART4_UART_FCR_RESETTF_SHIFT))

#define  UART4_UART_FCR_RESETRF_MASK 0x2
#define  UART4_UART_FCR_RESETRF_SHIFT 1
#define  UART4_UART_FCR_RESETRF_MASK_SHIFT(reg) (((reg) & UART4_UART_FCR_RESETRF_MASK) >> UART4_UART_FCR_RESETRF_SHIFT)
#define  UART4_UART_FCR_RESETRF_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_FCR_RESETRF_MASK) | (((uint32_t)val) << UART4_UART_FCR_RESETRF_SHIFT))

#define  UART4_UART_FCR_TRFIFOE_MASK 0x1
#define  UART4_UART_FCR_TRFIFOE_SHIFT 0
#define  UART4_UART_FCR_TRFIFOE_MASK_SHIFT(reg) (((reg) & UART4_UART_FCR_TRFIFOE_MASK) >> UART4_UART_FCR_TRFIFOE_SHIFT)
#define  UART4_UART_FCR_TRFIFOE_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_FCR_TRFIFOE_MASK) | (((uint32_t)val) << UART4_UART_FCR_TRFIFOE_SHIFT))

//====================================================================
//Register: Line Control Register (UART_LCR)
/** \brief This register specifies the format for the asynchronous data-communications
exchange. The serial-data format consists of a start bit, 8 data bits, an
optional parity bit, and 1 stop bit. This register has bits that allow access to
the Divisor Latch registers and bits that can cause a break condition.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART4_UART_LCR_RESERVED1_MASK 0xffffff00
#define  UART4_UART_LCR_RESERVED1_SHIFT 8
#define  UART4_UART_LCR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART4_UART_LCR_RESERVED1_MASK) >> UART4_UART_LCR_RESERVED1_SHIFT)
#define  UART4_UART_LCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_LCR_RESERVED1_MASK) | (((uint32_t)val) << UART4_UART_LCR_RESERVED1_SHIFT))

#define  UART4_UART_LCR_DLAB_MASK 0x80
#define  UART4_UART_LCR_DLAB_SHIFT 7
#define  UART4_UART_LCR_DLAB_MASK_SHIFT(reg) (((reg) & UART4_UART_LCR_DLAB_MASK) >> UART4_UART_LCR_DLAB_SHIFT)
#define  UART4_UART_LCR_DLAB_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_LCR_DLAB_MASK) | (((uint32_t)val) << UART4_UART_LCR_DLAB_SHIFT))

#define  UART4_UART_LCR_SB_MASK 0x40
#define  UART4_UART_LCR_SB_SHIFT 6
#define  UART4_UART_LCR_SB_MASK_SHIFT(reg) (((reg) & UART4_UART_LCR_SB_MASK) >> UART4_UART_LCR_SB_SHIFT)
#define  UART4_UART_LCR_SB_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_LCR_SB_MASK) | (((uint32_t)val) << UART4_UART_LCR_SB_SHIFT))

#define  UART4_UART_LCR_STKYP_MASK 0x20
#define  UART4_UART_LCR_STKYP_SHIFT 5
#define  UART4_UART_LCR_STKYP_MASK_SHIFT(reg) (((reg) & UART4_UART_LCR_STKYP_MASK) >> UART4_UART_LCR_STKYP_SHIFT)
#define  UART4_UART_LCR_STKYP_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_LCR_STKYP_MASK) | (((uint32_t)val) << UART4_UART_LCR_STKYP_SHIFT))

#define  UART4_UART_LCR_EPS_MASK 0x10
#define  UART4_UART_LCR_EPS_SHIFT 4
#define  UART4_UART_LCR_EPS_MASK_SHIFT(reg) (((reg) & UART4_UART_LCR_EPS_MASK) >> UART4_UART_LCR_EPS_SHIFT)
#define  UART4_UART_LCR_EPS_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_LCR_EPS_MASK) | (((uint32_t)val) << UART4_UART_LCR_EPS_SHIFT))

#define  UART4_UART_LCR_PEN_MASK 0x8
#define  UART4_UART_LCR_PEN_SHIFT 3
#define  UART4_UART_LCR_PEN_MASK_SHIFT(reg) (((reg) & UART4_UART_LCR_PEN_MASK) >> UART4_UART_LCR_PEN_SHIFT)
#define  UART4_UART_LCR_PEN_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_LCR_PEN_MASK) | (((uint32_t)val) << UART4_UART_LCR_PEN_SHIFT))

#define  UART4_UART_LCR_STB_MASK 0x4
#define  UART4_UART_LCR_STB_SHIFT 2
#define  UART4_UART_LCR_STB_MASK_SHIFT(reg) (((reg) & UART4_UART_LCR_STB_MASK) >> UART4_UART_LCR_STB_SHIFT)
#define  UART4_UART_LCR_STB_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_LCR_STB_MASK) | (((uint32_t)val) << UART4_UART_LCR_STB_SHIFT))

#define  UART4_UART_LCR_WLS10_MASK 0x3
#define  UART4_UART_LCR_WLS10_SHIFT 0
#define  UART4_UART_LCR_WLS10_MASK_SHIFT(reg) (((reg) & UART4_UART_LCR_WLS10_MASK) >> UART4_UART_LCR_WLS10_SHIFT)
#define  UART4_UART_LCR_WLS10_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_LCR_WLS10_MASK) | (((uint32_t)val) << UART4_UART_LCR_WLS10_SHIFT))

//====================================================================
//Register: Modem Control Register (UART_MCR)
/** \brief This register uses the modem control pins RTSn and DTRn to control the interface
with a modem or data set. This register also controls the loopback mode.
Loopback mode must be enabled before the UART is enabled.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART4_UART_MCR_RESERVED1_MASK 0xffffffc0
#define  UART4_UART_MCR_RESERVED1_SHIFT 6
#define  UART4_UART_MCR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART4_UART_MCR_RESERVED1_MASK) >> UART4_UART_MCR_RESERVED1_SHIFT)
#define  UART4_UART_MCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_MCR_RESERVED1_MASK) | (((uint32_t)val) << UART4_UART_MCR_RESERVED1_SHIFT))

#define  UART4_UART_MCR_AFE_MASK 0x20
#define  UART4_UART_MCR_AFE_SHIFT 5
#define  UART4_UART_MCR_AFE_MASK_SHIFT(reg) (((reg) & UART4_UART_MCR_AFE_MASK) >> UART4_UART_MCR_AFE_SHIFT)
#define  UART4_UART_MCR_AFE_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_MCR_AFE_MASK) | (((uint32_t)val) << UART4_UART_MCR_AFE_SHIFT))

#define  UART4_UART_MCR_LOOP_MASK 0x10
#define  UART4_UART_MCR_LOOP_SHIFT 4
#define  UART4_UART_MCR_LOOP_MASK_SHIFT(reg) (((reg) & UART4_UART_MCR_LOOP_MASK) >> UART4_UART_MCR_LOOP_SHIFT)
#define  UART4_UART_MCR_LOOP_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_MCR_LOOP_MASK) | (((uint32_t)val) << UART4_UART_MCR_LOOP_SHIFT))

#define  UART4_UART_MCR_OUT2_MASK 0x8
#define  UART4_UART_MCR_OUT2_SHIFT 3
#define  UART4_UART_MCR_OUT2_MASK_SHIFT(reg) (((reg) & UART4_UART_MCR_OUT2_MASK) >> UART4_UART_MCR_OUT2_SHIFT)
#define  UART4_UART_MCR_OUT2_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_MCR_OUT2_MASK) | (((uint32_t)val) << UART4_UART_MCR_OUT2_SHIFT))

#define  UART4_UART_MCR_OUT1_MASK 0x4
#define  UART4_UART_MCR_OUT1_SHIFT 2
#define  UART4_UART_MCR_OUT1_MASK_SHIFT(reg) (((reg) & UART4_UART_MCR_OUT1_MASK) >> UART4_UART_MCR_OUT1_SHIFT)
#define  UART4_UART_MCR_OUT1_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_MCR_OUT1_MASK) | (((uint32_t)val) << UART4_UART_MCR_OUT1_SHIFT))

#define  UART4_UART_MCR_RTS_MASK 0x2
#define  UART4_UART_MCR_RTS_SHIFT 1
#define  UART4_UART_MCR_RTS_MASK_SHIFT(reg) (((reg) & UART4_UART_MCR_RTS_MASK) >> UART4_UART_MCR_RTS_SHIFT)
#define  UART4_UART_MCR_RTS_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_MCR_RTS_MASK) | (((uint32_t)val) << UART4_UART_MCR_RTS_SHIFT))

#define  UART4_UART_MCR_DTR_MASK 0x1
#define  UART4_UART_MCR_DTR_SHIFT 0
#define  UART4_UART_MCR_DTR_MASK_SHIFT(reg) (((reg) & UART4_UART_MCR_DTR_MASK) >> UART4_UART_MCR_DTR_SHIFT)
#define  UART4_UART_MCR_DTR_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_MCR_DTR_MASK) | (((uint32_t)val) << UART4_UART_MCR_DTR_SHIFT))

//====================================================================
//Register: Line Status Register (UART_LSR)
/** \brief This register provides data-transfer status information to the PXA2128
Application Processor. In non-FIFO mode, bits [4:2] show the error status of the
character that has just been received. In FIFO mode, bits [4:2] show the status
bits of the character that is currently at the front of the FIFO.
Bits [4:1] produce a receiver-line-status interrupt when the corresponding
conditions are detected and the interrupt is enabled. In FIFO mode, the
receiver-line-status interrupt occurs only when the erroneous character reaches
the front of the FIFO. If the erroneous character is not at the front of the
FIFO, a line-status interrupt is generated after the other characters are read,
and the erroneous character becomes the character at the front of the FIFO.
This register must be read before the erroneous character is read. Bits [4:1]
remain set until software reads this register.
See FIFO DMA Mode Operation section in the PXA2128 Application Processor
Datasheet for details on using the DMAC to receive data.
This is a read-only register. Ignore reads from reserved bits.*/
//====================================================================

#define  UART4_UART_LSR_RESERVED1_MASK 0xffffff00
#define  UART4_UART_LSR_RESERVED1_SHIFT 8
#define  UART4_UART_LSR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART4_UART_LSR_RESERVED1_MASK) >> UART4_UART_LSR_RESERVED1_SHIFT)
#define  UART4_UART_LSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_LSR_RESERVED1_MASK) | (((uint32_t)val) << UART4_UART_LSR_RESERVED1_SHIFT))

#define  UART4_UART_LSR_FIFOE_MASK 0x80
#define  UART4_UART_LSR_FIFOE_SHIFT 7
#define  UART4_UART_LSR_FIFOE_MASK_SHIFT(reg) (((reg) & UART4_UART_LSR_FIFOE_MASK) >> UART4_UART_LSR_FIFOE_SHIFT)
#define  UART4_UART_LSR_FIFOE_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_LSR_FIFOE_MASK) | (((uint32_t)val) << UART4_UART_LSR_FIFOE_SHIFT))

#define  UART4_UART_LSR_TEMT_MASK 0x40
#define  UART4_UART_LSR_TEMT_SHIFT 6
#define  UART4_UART_LSR_TEMT_MASK_SHIFT(reg) (((reg) & UART4_UART_LSR_TEMT_MASK) >> UART4_UART_LSR_TEMT_SHIFT)
#define  UART4_UART_LSR_TEMT_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_LSR_TEMT_MASK) | (((uint32_t)val) << UART4_UART_LSR_TEMT_SHIFT))

#define  UART4_UART_LSR_TDRQ_MASK 0x20
#define  UART4_UART_LSR_TDRQ_SHIFT 5
#define  UART4_UART_LSR_TDRQ_MASK_SHIFT(reg) (((reg) & UART4_UART_LSR_TDRQ_MASK) >> UART4_UART_LSR_TDRQ_SHIFT)
#define  UART4_UART_LSR_TDRQ_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_LSR_TDRQ_MASK) | (((uint32_t)val) << UART4_UART_LSR_TDRQ_SHIFT))

#define  UART4_UART_LSR_BI_MASK 0x10
#define  UART4_UART_LSR_BI_SHIFT 4
#define  UART4_UART_LSR_BI_MASK_SHIFT(reg) (((reg) & UART4_UART_LSR_BI_MASK) >> UART4_UART_LSR_BI_SHIFT)
#define  UART4_UART_LSR_BI_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_LSR_BI_MASK) | (((uint32_t)val) << UART4_UART_LSR_BI_SHIFT))

#define  UART4_UART_LSR_FE_MASK 0x8
#define  UART4_UART_LSR_FE_SHIFT 3
#define  UART4_UART_LSR_FE_MASK_SHIFT(reg) (((reg) & UART4_UART_LSR_FE_MASK) >> UART4_UART_LSR_FE_SHIFT)
#define  UART4_UART_LSR_FE_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_LSR_FE_MASK) | (((uint32_t)val) << UART4_UART_LSR_FE_SHIFT))

#define  UART4_UART_LSR_PE_MASK 0x4
#define  UART4_UART_LSR_PE_SHIFT 2
#define  UART4_UART_LSR_PE_MASK_SHIFT(reg) (((reg) & UART4_UART_LSR_PE_MASK) >> UART4_UART_LSR_PE_SHIFT)
#define  UART4_UART_LSR_PE_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_LSR_PE_MASK) | (((uint32_t)val) << UART4_UART_LSR_PE_SHIFT))

#define  UART4_UART_LSR_OE_MASK 0x2
#define  UART4_UART_LSR_OE_SHIFT 1
#define  UART4_UART_LSR_OE_MASK_SHIFT(reg) (((reg) & UART4_UART_LSR_OE_MASK) >> UART4_UART_LSR_OE_SHIFT)
#define  UART4_UART_LSR_OE_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_LSR_OE_MASK) | (((uint32_t)val) << UART4_UART_LSR_OE_SHIFT))

#define  UART4_UART_LSR_DR_MASK 0x1
#define  UART4_UART_LSR_DR_SHIFT 0
#define  UART4_UART_LSR_DR_MASK_SHIFT(reg) (((reg) & UART4_UART_LSR_DR_MASK) >> UART4_UART_LSR_DR_SHIFT)
#define  UART4_UART_LSR_DR_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_LSR_DR_MASK) | (((uint32_t)val) << UART4_UART_LSR_DR_SHIFT))

//====================================================================
//Register: Modem Status Register (UART_MSR)
/** \brief This register provides the current state of the control lines from the modem or
data set (or a peripheral device emulating a modem) to the PXA2128 Application
Processor. In addition to this current state information, four bits provide
change information. Bits [3:0] are set when a control input from the modem
changes state. They are cleared when the PXA2128 Application Processor reads
this register.
The status of the modem control lines does not affect the FIFOs. The <Modem
Interrupt Enable> field in the Interrupt Enable Register must be set to use
these lines for flow control. The interrupt service routine must disable the
UART when an interrupt occurs on one of the flow-control pins. The UART
continues transmission/reception of the current character and then stops. The
contents of the FIFOs are preserved. If the UART is re-enabled, transmission
continues where it stopped.
Note: When bit 0, 1, 2, or 3 is set, a modem-status interrupt is generated if
the <Modem Interrupt Enable> field is set.
This is a read-only register. Ignore reads from reserved bits.*/
//====================================================================

#define  UART4_UART_MSR_RESERVED1_MASK 0xffffff00
#define  UART4_UART_MSR_RESERVED1_SHIFT 8
#define  UART4_UART_MSR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART4_UART_MSR_RESERVED1_MASK) >> UART4_UART_MSR_RESERVED1_SHIFT)
#define  UART4_UART_MSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_MSR_RESERVED1_MASK) | (((uint32_t)val) << UART4_UART_MSR_RESERVED1_SHIFT))

#define  UART4_UART_MSR_DCD_MASK 0x80
#define  UART4_UART_MSR_DCD_SHIFT 7
#define  UART4_UART_MSR_DCD_MASK_SHIFT(reg) (((reg) & UART4_UART_MSR_DCD_MASK) >> UART4_UART_MSR_DCD_SHIFT)
#define  UART4_UART_MSR_DCD_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_MSR_DCD_MASK) | (((uint32_t)val) << UART4_UART_MSR_DCD_SHIFT))

#define  UART4_UART_MSR_RI_MASK 0x40
#define  UART4_UART_MSR_RI_SHIFT 6
#define  UART4_UART_MSR_RI_MASK_SHIFT(reg) (((reg) & UART4_UART_MSR_RI_MASK) >> UART4_UART_MSR_RI_SHIFT)
#define  UART4_UART_MSR_RI_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_MSR_RI_MASK) | (((uint32_t)val) << UART4_UART_MSR_RI_SHIFT))

#define  UART4_UART_MSR_DSR_MASK 0x20
#define  UART4_UART_MSR_DSR_SHIFT 5
#define  UART4_UART_MSR_DSR_MASK_SHIFT(reg) (((reg) & UART4_UART_MSR_DSR_MASK) >> UART4_UART_MSR_DSR_SHIFT)
#define  UART4_UART_MSR_DSR_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_MSR_DSR_MASK) | (((uint32_t)val) << UART4_UART_MSR_DSR_SHIFT))

#define  UART4_UART_MSR_CTS_MASK 0x10
#define  UART4_UART_MSR_CTS_SHIFT 4
#define  UART4_UART_MSR_CTS_MASK_SHIFT(reg) (((reg) & UART4_UART_MSR_CTS_MASK) >> UART4_UART_MSR_CTS_SHIFT)
#define  UART4_UART_MSR_CTS_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_MSR_CTS_MASK) | (((uint32_t)val) << UART4_UART_MSR_CTS_SHIFT))

#define  UART4_UART_MSR_DDCD_MASK 0x8
#define  UART4_UART_MSR_DDCD_SHIFT 3
#define  UART4_UART_MSR_DDCD_MASK_SHIFT(reg) (((reg) & UART4_UART_MSR_DDCD_MASK) >> UART4_UART_MSR_DDCD_SHIFT)
#define  UART4_UART_MSR_DDCD_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_MSR_DDCD_MASK) | (((uint32_t)val) << UART4_UART_MSR_DDCD_SHIFT))

#define  UART4_UART_MSR_TERI_MASK 0x4
#define  UART4_UART_MSR_TERI_SHIFT 2
#define  UART4_UART_MSR_TERI_MASK_SHIFT(reg) (((reg) & UART4_UART_MSR_TERI_MASK) >> UART4_UART_MSR_TERI_SHIFT)
#define  UART4_UART_MSR_TERI_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_MSR_TERI_MASK) | (((uint32_t)val) << UART4_UART_MSR_TERI_SHIFT))

#define  UART4_UART_MSR_DDSR_MASK 0x2
#define  UART4_UART_MSR_DDSR_SHIFT 1
#define  UART4_UART_MSR_DDSR_MASK_SHIFT(reg) (((reg) & UART4_UART_MSR_DDSR_MASK) >> UART4_UART_MSR_DDSR_SHIFT)
#define  UART4_UART_MSR_DDSR_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_MSR_DDSR_MASK) | (((uint32_t)val) << UART4_UART_MSR_DDSR_SHIFT))

#define  UART4_UART_MSR_DCTS_MASK 0x1
#define  UART4_UART_MSR_DCTS_SHIFT 0
#define  UART4_UART_MSR_DCTS_MASK_SHIFT(reg) (((reg) & UART4_UART_MSR_DCTS_MASK) >> UART4_UART_MSR_DCTS_SHIFT)
#define  UART4_UART_MSR_DCTS_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_MSR_DCTS_MASK) | (((uint32_t)val) << UART4_UART_MSR_DCTS_SHIFT))

//====================================================================
//Register: Scratchpad Register (UART_SCR)
/** \brief This register has no effect on the UART. It is intended as a scratchpad register
for use by programmers and is included for 16550A compatibility.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART4_UART_SCR_RESERVED1_MASK 0xffffff00
#define  UART4_UART_SCR_RESERVED1_SHIFT 8
#define  UART4_UART_SCR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART4_UART_SCR_RESERVED1_MASK) >> UART4_UART_SCR_RESERVED1_SHIFT)
#define  UART4_UART_SCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_SCR_RESERVED1_MASK) | (((uint32_t)val) << UART4_UART_SCR_RESERVED1_SHIFT))

#define  UART4_UART_SCR_SCRATCHPAD_MASK 0xff
#define  UART4_UART_SCR_SCRATCHPAD_SHIFT 0
#define  UART4_UART_SCR_SCRATCHPAD_MASK_SHIFT(reg) (((reg) & UART4_UART_SCR_SCRATCHPAD_MASK) >> UART4_UART_SCR_SCRATCHPAD_SHIFT)
#define  UART4_UART_SCR_SCRATCHPAD_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_SCR_SCRATCHPAD_MASK) | (((uint32_t)val) << UART4_UART_SCR_SCRATCHPAD_SHIFT))

//====================================================================
//Register: Infrared Selection Register (UART_ISR)
/** \brief Each UART can manage an IrDA module associated with it. This register controls
the IrDA functions (see Serial Infrared Asynchronous Interface in the PXA2128
Application Processor Datasheet).
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART4_UART_ISR_RESERVED1_MASK 0xffffffe0
#define  UART4_UART_ISR_RESERVED1_SHIFT 5
#define  UART4_UART_ISR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART4_UART_ISR_RESERVED1_MASK) >> UART4_UART_ISR_RESERVED1_SHIFT)
#define  UART4_UART_ISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_ISR_RESERVED1_MASK) | (((uint32_t)val) << UART4_UART_ISR_RESERVED1_SHIFT))

#define  UART4_UART_ISR_RXPL_MASK 0x10
#define  UART4_UART_ISR_RXPL_SHIFT 4
#define  UART4_UART_ISR_RXPL_MASK_SHIFT(reg) (((reg) & UART4_UART_ISR_RXPL_MASK) >> UART4_UART_ISR_RXPL_SHIFT)
#define  UART4_UART_ISR_RXPL_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_ISR_RXPL_MASK) | (((uint32_t)val) << UART4_UART_ISR_RXPL_SHIFT))

#define  UART4_UART_ISR_TXPL_MASK 0x8
#define  UART4_UART_ISR_TXPL_SHIFT 3
#define  UART4_UART_ISR_TXPL_MASK_SHIFT(reg) (((reg) & UART4_UART_ISR_TXPL_MASK) >> UART4_UART_ISR_TXPL_SHIFT)
#define  UART4_UART_ISR_TXPL_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_ISR_TXPL_MASK) | (((uint32_t)val) << UART4_UART_ISR_TXPL_SHIFT))

#define  UART4_UART_ISR_XMODE_MASK 0x4
#define  UART4_UART_ISR_XMODE_SHIFT 2
#define  UART4_UART_ISR_XMODE_MASK_SHIFT(reg) (((reg) & UART4_UART_ISR_XMODE_MASK) >> UART4_UART_ISR_XMODE_SHIFT)
#define  UART4_UART_ISR_XMODE_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_ISR_XMODE_MASK) | (((uint32_t)val) << UART4_UART_ISR_XMODE_SHIFT))

#define  UART4_UART_ISR_RCVEIR_MASK 0x2
#define  UART4_UART_ISR_RCVEIR_SHIFT 1
#define  UART4_UART_ISR_RCVEIR_MASK_SHIFT(reg) (((reg) & UART4_UART_ISR_RCVEIR_MASK) >> UART4_UART_ISR_RCVEIR_SHIFT)
#define  UART4_UART_ISR_RCVEIR_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_ISR_RCVEIR_MASK) | (((uint32_t)val) << UART4_UART_ISR_RCVEIR_SHIFT))

#define  UART4_UART_ISR_XMITIR_MASK 0x1
#define  UART4_UART_ISR_XMITIR_SHIFT 0
#define  UART4_UART_ISR_XMITIR_MASK_SHIFT(reg) (((reg) & UART4_UART_ISR_XMITIR_MASK) >> UART4_UART_ISR_XMITIR_SHIFT)
#define  UART4_UART_ISR_XMITIR_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_ISR_XMITIR_MASK) | (((uint32_t)val) << UART4_UART_ISR_XMITIR_SHIFT))

//====================================================================
//Register: Receive FIFO Occupancy Register (UART_FOR)
/** \brief This register shows the number of bytes currently remaining the receive FIFO.
This register can be used to determine the number of trailing bytes to remove in
the case when the DMA reaches the end of its descriptor chain or when
the <Trailing Bytes> field in the FIFO Control Register is clear, which
indicates that the PXA2128 Application Processor removes trailing bytes as
opposed to the DMA (see Removing Trailing Bytes in DMA Mode section in PXA2128
Application Processor Datasheet). This register is incremented once for each
byte of data written to the receive FIFO and decremented once for each byte
read.
This is a read/write register. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  UART4_UART_FOR_RESERVED1_MASK 0xffffffc0
#define  UART4_UART_FOR_RESERVED1_SHIFT 6
#define  UART4_UART_FOR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART4_UART_FOR_RESERVED1_MASK) >> UART4_UART_FOR_RESERVED1_SHIFT)
#define  UART4_UART_FOR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_FOR_RESERVED1_MASK) | (((uint32_t)val) << UART4_UART_FOR_RESERVED1_SHIFT))

#define  UART4_UART_FOR_BYTE_COUNT_MASK 0x3f
#define  UART4_UART_FOR_BYTE_COUNT_SHIFT 0
#define  UART4_UART_FOR_BYTE_COUNT_MASK_SHIFT(reg) (((reg) & UART4_UART_FOR_BYTE_COUNT_MASK) >> UART4_UART_FOR_BYTE_COUNT_SHIFT)
#define  UART4_UART_FOR_BYTE_COUNT_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_FOR_BYTE_COUNT_MASK) | (((uint32_t)val) << UART4_UART_FOR_BYTE_COUNT_SHIFT))

//====================================================================
//Register: Auto-Baud Control Register (UART_ABR)
/** \brief This register controls the functionality and options for auto-baud-rate
detection within the UART. Through this register, software can enable/disable
the auto-baud-lock interrupt, direct either the PXA2128 Application Processor or
the UART to program the final baud rate in the Divisor Latch registers, and
choose between two methods used to calculate the final baud rate.
The auto-baud circuitry counts the number of clocks in the start bit and writes
this count into the Auto-Baud Count register (ACR). It then interrupts the
PXA2128 Application Processor if the <Auto-baud Lock> field in the Interrupt
Identification Register is set. It also programs automatically the Divisor Latch
registers (DLL and DLH) if the <ABUP> field is set.
See Auto-Baud-Rate Detection section in PXA2128 Application Processor Datasheet
for more information on auto-baud rate.
Note: Auto-baud-rate detection is not supported in IrDA serial-infrared mode.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART4_UART_ABR_RESERVED1_MASK 0xfffffff0
#define  UART4_UART_ABR_RESERVED1_SHIFT 4
#define  UART4_UART_ABR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART4_UART_ABR_RESERVED1_MASK) >> UART4_UART_ABR_RESERVED1_SHIFT)
#define  UART4_UART_ABR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_ABR_RESERVED1_MASK) | (((uint32_t)val) << UART4_UART_ABR_RESERVED1_SHIFT))

#define  UART4_UART_ABR_ABT_MASK 0x8
#define  UART4_UART_ABR_ABT_SHIFT 3
#define  UART4_UART_ABR_ABT_MASK_SHIFT(reg) (((reg) & UART4_UART_ABR_ABT_MASK) >> UART4_UART_ABR_ABT_SHIFT)
#define  UART4_UART_ABR_ABT_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_ABR_ABT_MASK) | (((uint32_t)val) << UART4_UART_ABR_ABT_SHIFT))

#define  UART4_UART_ABR_ABUP_MASK 0x4
#define  UART4_UART_ABR_ABUP_SHIFT 2
#define  UART4_UART_ABR_ABUP_MASK_SHIFT(reg) (((reg) & UART4_UART_ABR_ABUP_MASK) >> UART4_UART_ABR_ABUP_SHIFT)
#define  UART4_UART_ABR_ABUP_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_ABR_ABUP_MASK) | (((uint32_t)val) << UART4_UART_ABR_ABUP_SHIFT))

#define  UART4_UART_ABR_ABLIE_MASK 0x2
#define  UART4_UART_ABR_ABLIE_SHIFT 1
#define  UART4_UART_ABR_ABLIE_MASK_SHIFT(reg) (((reg) & UART4_UART_ABR_ABLIE_MASK) >> UART4_UART_ABR_ABLIE_SHIFT)
#define  UART4_UART_ABR_ABLIE_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_ABR_ABLIE_MASK) | (((uint32_t)val) << UART4_UART_ABR_ABLIE_SHIFT))

#define  UART4_UART_ABR_ABE_MASK 0x1
#define  UART4_UART_ABR_ABE_SHIFT 0
#define  UART4_UART_ABR_ABE_MASK_SHIFT(reg) (((reg) & UART4_UART_ABR_ABE_MASK) >> UART4_UART_ABR_ABE_SHIFT)
#define  UART4_UART_ABR_ABE_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_ABR_ABE_MASK) | (((uint32_t)val) << UART4_UART_ABR_ABE_SHIFT))

//====================================================================
//Register: Auto-Baud Count Register (UART_ACR)
/** \brief This register stores the number of 14.857-MHz clock cycles within a start-bit
pulse. This value is then used by the PXA2128 Application Processor or the UART
to calculate the baud rate. If auto-baud mode (<ABE> field in Auto-Baud Control
Register) and auto-baud interrupts (<ABLIE> field in Auto-Baud Control Register)
are enabled, the UART interrupts the PXA2128 Application Processor with the
auto-baud-lock interrupt (IIR[ABL]) after it has written the count value into
ACR. The value is written regardless of the state of the auto-baud UART program
bit, (ABR[ABUP]).
This is a read-only register. Ignore reads from reserved bits.*/
//====================================================================

#define  UART4_UART_ACR_RESERVED1_MASK 0xffff0000
#define  UART4_UART_ACR_RESERVED1_SHIFT 16
#define  UART4_UART_ACR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART4_UART_ACR_RESERVED1_MASK) >> UART4_UART_ACR_RESERVED1_SHIFT)
#define  UART4_UART_ACR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_ACR_RESERVED1_MASK) | (((uint32_t)val) << UART4_UART_ACR_RESERVED1_SHIFT))

#define  UART4_UART_ACR_COUNT_VALUE_MASK 0xffff
#define  UART4_UART_ACR_COUNT_VALUE_SHIFT 0
#define  UART4_UART_ACR_COUNT_VALUE_MASK_SHIFT(reg) (((reg) & UART4_UART_ACR_COUNT_VALUE_MASK) >> UART4_UART_ACR_COUNT_VALUE_SHIFT)
#define  UART4_UART_ACR_COUNT_VALUE_REPLACE_VAL(reg,val) (((reg) & ~UART4_UART_ACR_COUNT_VALUE_MASK) | (((uint32_t)val) << UART4_UART_ACR_COUNT_VALUE_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  UART4_REV0_MAJ_MASK 0xffff0000
#define  UART4_REV0_MAJ_SHIFT 16
#define  UART4_REV0_MAJ_MASK_SHIFT(reg) (((reg) & UART4_REV0_MAJ_MASK) >> UART4_REV0_MAJ_SHIFT)
#define  UART4_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~UART4_REV0_MAJ_MASK) | (((uint32_t)val) << UART4_REV0_MAJ_SHIFT))

#define  UART4_REV0_MID_MASK 0xffff
#define  UART4_REV0_MID_SHIFT 0
#define  UART4_REV0_MID_MASK_SHIFT(reg) (((reg) & UART4_REV0_MID_MASK) >> UART4_REV0_MID_SHIFT)
#define  UART4_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~UART4_REV0_MID_MASK) | (((uint32_t)val) << UART4_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  UART4_REV1_RESERVED1_MASK 0xffff0000
#define  UART4_REV1_RESERVED1_SHIFT 16
#define  UART4_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & UART4_REV1_RESERVED1_MASK) >> UART4_REV1_RESERVED1_SHIFT)
#define  UART4_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART4_REV1_RESERVED1_MASK) | (((uint32_t)val) << UART4_REV1_RESERVED1_SHIFT))

#define  UART4_REV1_CFG_MASK 0xffff
#define  UART4_REV1_CFG_SHIFT 0
#define  UART4_REV1_CFG_MASK_SHIFT(reg) (((reg) & UART4_REV1_CFG_MASK) >> UART4_REV1_CFG_SHIFT)
#define  UART4_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~UART4_REV1_CFG_MASK) | (((uint32_t)val) << UART4_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: UART2 Registers (UART2)
//
//====================================================================

//====================================================================
//Register: Receive Buffer Register (UART_RBR)
/** \brief In non-FIFO mode, this register holds the character(s) received by the UART
Receive Shift Register. If this register is configured to use fewer than eight
bits, the bits are right-justified and the most significant bits (MSbs) are
zeroed. Reading the register empties the register and clears the <Data
Ready> field in the Line Status Register.
This register latches the value of the data byte at the front of the FIFO in
FIFO mode.*/
//====================================================================

#define  UART2_UART_RBR_BYTE_3_MASK 0xff000000
#define  UART2_UART_RBR_BYTE_3_SHIFT 24
#define  UART2_UART_RBR_BYTE_3_MASK_SHIFT(reg) (((reg) & UART2_UART_RBR_BYTE_3_MASK) >> UART2_UART_RBR_BYTE_3_SHIFT)
#define  UART2_UART_RBR_BYTE_3_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_RBR_BYTE_3_MASK) | (((uint32_t)val) << UART2_UART_RBR_BYTE_3_SHIFT))

#define  UART2_UART_RBR_BYTE_2_MASK 0xff0000
#define  UART2_UART_RBR_BYTE_2_SHIFT 16
#define  UART2_UART_RBR_BYTE_2_MASK_SHIFT(reg) (((reg) & UART2_UART_RBR_BYTE_2_MASK) >> UART2_UART_RBR_BYTE_2_SHIFT)
#define  UART2_UART_RBR_BYTE_2_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_RBR_BYTE_2_MASK) | (((uint32_t)val) << UART2_UART_RBR_BYTE_2_SHIFT))

#define  UART2_UART_RBR_BYTE_1_MASK 0xff00
#define  UART2_UART_RBR_BYTE_1_SHIFT 8
#define  UART2_UART_RBR_BYTE_1_MASK_SHIFT(reg) (((reg) & UART2_UART_RBR_BYTE_1_MASK) >> UART2_UART_RBR_BYTE_1_SHIFT)
#define  UART2_UART_RBR_BYTE_1_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_RBR_BYTE_1_MASK) | (((uint32_t)val) << UART2_UART_RBR_BYTE_1_SHIFT))

#define  UART2_UART_RBR_BYTE_0_MASK 0xff
#define  UART2_UART_RBR_BYTE_0_SHIFT 0
#define  UART2_UART_RBR_BYTE_0_MASK_SHIFT(reg) (((reg) & UART2_UART_RBR_BYTE_0_MASK) >> UART2_UART_RBR_BYTE_0_SHIFT)
#define  UART2_UART_RBR_BYTE_0_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_RBR_BYTE_0_MASK) | (((uint32_t)val) << UART2_UART_RBR_BYTE_0_SHIFT))

//====================================================================
//Register: Transmit Holding Register (UART_THR)
/** \brief This register holds the data byte(s) to be transmitted next in non-FIFO mode.
When the Transmit Shift Register is emptied, the contents of this register are
loaded into the Transmit Shift Register and the <Transmit Data Request> field in
the Line Status Register is set.
A write to Transmit Holding Register puts data into the top of the FIFO in FIFO
mode. The data at the front of the FIFO is loaded into the Transmit Shift
Register when the Transmit Shift Register is empty.*/
//====================================================================

#define  UART2_UART_THR_BYTE_3_MASK 0xff000000
#define  UART2_UART_THR_BYTE_3_SHIFT 24
#define  UART2_UART_THR_BYTE_3_MASK_SHIFT(reg) (((reg) & UART2_UART_THR_BYTE_3_MASK) >> UART2_UART_THR_BYTE_3_SHIFT)
#define  UART2_UART_THR_BYTE_3_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_THR_BYTE_3_MASK) | (((uint32_t)val) << UART2_UART_THR_BYTE_3_SHIFT))

#define  UART2_UART_THR_BYTE_2_MASK 0xff0000
#define  UART2_UART_THR_BYTE_2_SHIFT 16
#define  UART2_UART_THR_BYTE_2_MASK_SHIFT(reg) (((reg) & UART2_UART_THR_BYTE_2_MASK) >> UART2_UART_THR_BYTE_2_SHIFT)
#define  UART2_UART_THR_BYTE_2_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_THR_BYTE_2_MASK) | (((uint32_t)val) << UART2_UART_THR_BYTE_2_SHIFT))

#define  UART2_UART_THR_BYTE_1_MASK 0xff00
#define  UART2_UART_THR_BYTE_1_SHIFT 8
#define  UART2_UART_THR_BYTE_1_MASK_SHIFT(reg) (((reg) & UART2_UART_THR_BYTE_1_MASK) >> UART2_UART_THR_BYTE_1_SHIFT)
#define  UART2_UART_THR_BYTE_1_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_THR_BYTE_1_MASK) | (((uint32_t)val) << UART2_UART_THR_BYTE_1_SHIFT))

#define  UART2_UART_THR_BYTE_0_MASK 0xff
#define  UART2_UART_THR_BYTE_0_SHIFT 0
#define  UART2_UART_THR_BYTE_0_MASK_SHIFT(reg) (((reg) & UART2_UART_THR_BYTE_0_MASK) >> UART2_UART_THR_BYTE_0_SHIFT)
#define  UART2_UART_THR_BYTE_0_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_THR_BYTE_0_MASK) | (((uint32_t)val) << UART2_UART_THR_BYTE_0_SHIFT))

//====================================================================
//Register: Divisor Latch Low Byte Register (UART_DLL)
//====================================================================

#define  UART2_UART_DLL_RESERVED1_MASK 0xffffff00
#define  UART2_UART_DLL_RESERVED1_SHIFT 8
#define  UART2_UART_DLL_RESERVED1_MASK_SHIFT(reg) (((reg) & UART2_UART_DLL_RESERVED1_MASK) >> UART2_UART_DLL_RESERVED1_SHIFT)
#define  UART2_UART_DLL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_DLL_RESERVED1_MASK) | (((uint32_t)val) << UART2_UART_DLL_RESERVED1_SHIFT))

#define  UART2_UART_DLL_DLL_MASK 0xff
#define  UART2_UART_DLL_DLL_SHIFT 0
#define  UART2_UART_DLL_DLL_MASK_SHIFT(reg) (((reg) & UART2_UART_DLL_DLL_MASK) >> UART2_UART_DLL_DLL_SHIFT)
#define  UART2_UART_DLL_DLL_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_DLL_DLL_MASK) | (((uint32_t)val) << UART2_UART_DLL_DLL_SHIFT))

//====================================================================
//Register: Interrupt Enable Register (UART_IER)
/** \brief This register enables the five types of interrupts that set a value in the
Interrupt Identification Register. Software must clear the appropriate bit in
this register to disable an interrupt. Software can enable some interrupts by
setting the appropriate bit.
The character timeout-indication interrupt is separated from the received
data-available interrupt to ensure that the PXA2128 Application Processor and
the DMA controller do not service the receive FIFO at the same time. When
a character-timeout-indication interrupt occurs, the PXA2128 Application
Processor must handle the data in the receive FIFO through programmed I/O.
An error interrupt is used when DMA requests are enabled. The interrupt is
generated when the <FIFO Error Status> field in the Line Status Register is set
because a receive DMA request is not generated when the receive FIFO has an
error. The error interrupt tells the PXA2128 Application Processor to handle the
data in the receive FIFO through programmed I/O. The error interrupt is enabled
when DMA requests are enabled, and it cannot be masked. Receiver line-status
interrupts occur when the error is at the front of the FIFO.
Note: When DMA requests are enabled and an interrupt occurs, software must first
read the Line Status Register to see if an error interrupt exists, then check
the Interrupt Identification Register for the source of the interrupt. Software
must read the Infrared Selected Register to determine the error condition if an
interrupt occurs and the <FIFO Error Status> field in the Line Status Register
is clear. DMA requests are automatically enabled when the last error byte is
read from the FIFO. Software is not required to check for the error interrupt if
DMA requests are disabled because an error interrupt occurs only when DMA
requests are enabled.
The <FIFO Error Status> field is used to enable DMA requests. This register also
contains the unit enable and NRZ coding enable control bits. Bits 7 through 4
are used differently from the standard 16550A register definition.
Note: Software must not set the <DMA Requests Enable> field while the <Transmit
Data Request Interrupt Enable> or <Receiver Data Available Interrupt
Enable> fields are set to ensure that the DMA controller and programmed I/O do
not access the same FIFO.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART2_UART_IER_RESERVED1_MASK 0xfffffe00
#define  UART2_UART_IER_RESERVED1_SHIFT 9
#define  UART2_UART_IER_RESERVED1_MASK_SHIFT(reg) (((reg) & UART2_UART_IER_RESERVED1_MASK) >> UART2_UART_IER_RESERVED1_SHIFT)
#define  UART2_UART_IER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_IER_RESERVED1_MASK) | (((uint32_t)val) << UART2_UART_IER_RESERVED1_SHIFT))

#define  UART2_UART_IER_FAST_MASK 0x100
#define  UART2_UART_IER_FAST_SHIFT 8
#define  UART2_UART_IER_FAST_MASK_SHIFT(reg) (((reg) & UART2_UART_IER_FAST_MASK) >> UART2_UART_IER_FAST_SHIFT)
#define  UART2_UART_IER_FAST_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_IER_FAST_MASK) | (((uint32_t)val) << UART2_UART_IER_FAST_SHIFT))

#define  UART2_UART_IER_DMAE_MASK 0x80
#define  UART2_UART_IER_DMAE_SHIFT 7
#define  UART2_UART_IER_DMAE_MASK_SHIFT(reg) (((reg) & UART2_UART_IER_DMAE_MASK) >> UART2_UART_IER_DMAE_SHIFT)
#define  UART2_UART_IER_DMAE_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_IER_DMAE_MASK) | (((uint32_t)val) << UART2_UART_IER_DMAE_SHIFT))

#define  UART2_UART_IER_UUE_MASK 0x40
#define  UART2_UART_IER_UUE_SHIFT 6
#define  UART2_UART_IER_UUE_MASK_SHIFT(reg) (((reg) & UART2_UART_IER_UUE_MASK) >> UART2_UART_IER_UUE_SHIFT)
#define  UART2_UART_IER_UUE_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_IER_UUE_MASK) | (((uint32_t)val) << UART2_UART_IER_UUE_SHIFT))

#define  UART2_UART_IER_NRZE_MASK 0x20
#define  UART2_UART_IER_NRZE_SHIFT 5
#define  UART2_UART_IER_NRZE_MASK_SHIFT(reg) (((reg) & UART2_UART_IER_NRZE_MASK) >> UART2_UART_IER_NRZE_SHIFT)
#define  UART2_UART_IER_NRZE_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_IER_NRZE_MASK) | (((uint32_t)val) << UART2_UART_IER_NRZE_SHIFT))

#define  UART2_UART_IER_RTOIE_MASK 0x10
#define  UART2_UART_IER_RTOIE_SHIFT 4
#define  UART2_UART_IER_RTOIE_MASK_SHIFT(reg) (((reg) & UART2_UART_IER_RTOIE_MASK) >> UART2_UART_IER_RTOIE_SHIFT)
#define  UART2_UART_IER_RTOIE_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_IER_RTOIE_MASK) | (((uint32_t)val) << UART2_UART_IER_RTOIE_SHIFT))

#define  UART2_UART_IER_MIE_MASK 0x8
#define  UART2_UART_IER_MIE_SHIFT 3
#define  UART2_UART_IER_MIE_MASK_SHIFT(reg) (((reg) & UART2_UART_IER_MIE_MASK) >> UART2_UART_IER_MIE_SHIFT)
#define  UART2_UART_IER_MIE_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_IER_MIE_MASK) | (((uint32_t)val) << UART2_UART_IER_MIE_SHIFT))

#define  UART2_UART_IER_RLSE_MASK 0x4
#define  UART2_UART_IER_RLSE_SHIFT 2
#define  UART2_UART_IER_RLSE_MASK_SHIFT(reg) (((reg) & UART2_UART_IER_RLSE_MASK) >> UART2_UART_IER_RLSE_SHIFT)
#define  UART2_UART_IER_RLSE_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_IER_RLSE_MASK) | (((uint32_t)val) << UART2_UART_IER_RLSE_SHIFT))

#define  UART2_UART_IER_TIE_MASK 0x2
#define  UART2_UART_IER_TIE_SHIFT 1
#define  UART2_UART_IER_TIE_MASK_SHIFT(reg) (((reg) & UART2_UART_IER_TIE_MASK) >> UART2_UART_IER_TIE_SHIFT)
#define  UART2_UART_IER_TIE_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_IER_TIE_MASK) | (((uint32_t)val) << UART2_UART_IER_TIE_SHIFT))

#define  UART2_UART_IER_RAVIE_MASK 0x1
#define  UART2_UART_IER_RAVIE_SHIFT 0
#define  UART2_UART_IER_RAVIE_MASK_SHIFT(reg) (((reg) & UART2_UART_IER_RAVIE_MASK) >> UART2_UART_IER_RAVIE_SHIFT)
#define  UART2_UART_IER_RAVIE_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_IER_RAVIE_MASK) | (((uint32_t)val) << UART2_UART_IER_RAVIE_SHIFT))

//====================================================================
//Register: Divisor Latch High Byte Register (UART_DLH)
//====================================================================

#define  UART2_UART_DLH_RESERVED1_MASK 0xffffff00
#define  UART2_UART_DLH_RESERVED1_SHIFT 8
#define  UART2_UART_DLH_RESERVED1_MASK_SHIFT(reg) (((reg) & UART2_UART_DLH_RESERVED1_MASK) >> UART2_UART_DLH_RESERVED1_SHIFT)
#define  UART2_UART_DLH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_DLH_RESERVED1_MASK) | (((uint32_t)val) << UART2_UART_DLH_RESERVED1_SHIFT))

#define  UART2_UART_DLH_DLH_MASK 0xff
#define  UART2_UART_DLH_DLH_SHIFT 0
#define  UART2_UART_DLH_DLH_MASK_SHIFT(reg) (((reg) & UART2_UART_DLH_DLH_MASK) >> UART2_UART_DLH_DLH_SHIFT)
#define  UART2_UART_DLH_DLH_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_DLH_DLH_MASK) | (((uint32_t)val) << UART2_UART_DLH_DLH_SHIFT))

//====================================================================
//Register: Interrupt Identification Register (UART_IIR)
//====================================================================

#define  UART2_UART_IIR_RESERVED1_MASK 0xffffff00
#define  UART2_UART_IIR_RESERVED1_SHIFT 8
#define  UART2_UART_IIR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART2_UART_IIR_RESERVED1_MASK) >> UART2_UART_IIR_RESERVED1_SHIFT)
#define  UART2_UART_IIR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_IIR_RESERVED1_MASK) | (((uint32_t)val) << UART2_UART_IIR_RESERVED1_SHIFT))

#define  UART2_UART_IIR_FIFOES10_MASK 0xc0
#define  UART2_UART_IIR_FIFOES10_SHIFT 6
#define  UART2_UART_IIR_FIFOES10_MASK_SHIFT(reg) (((reg) & UART2_UART_IIR_FIFOES10_MASK) >> UART2_UART_IIR_FIFOES10_SHIFT)
#define  UART2_UART_IIR_FIFOES10_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_IIR_FIFOES10_MASK) | (((uint32_t)val) << UART2_UART_IIR_FIFOES10_SHIFT))

#define  UART2_UART_IIR_EOC_MASK 0x20
#define  UART2_UART_IIR_EOC_SHIFT 5
#define  UART2_UART_IIR_EOC_MASK_SHIFT(reg) (((reg) & UART2_UART_IIR_EOC_MASK) >> UART2_UART_IIR_EOC_SHIFT)
#define  UART2_UART_IIR_EOC_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_IIR_EOC_MASK) | (((uint32_t)val) << UART2_UART_IIR_EOC_SHIFT))

#define  UART2_UART_IIR_ABL_MASK 0x10
#define  UART2_UART_IIR_ABL_SHIFT 4
#define  UART2_UART_IIR_ABL_MASK_SHIFT(reg) (((reg) & UART2_UART_IIR_ABL_MASK) >> UART2_UART_IIR_ABL_SHIFT)
#define  UART2_UART_IIR_ABL_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_IIR_ABL_MASK) | (((uint32_t)val) << UART2_UART_IIR_ABL_SHIFT))

#define  UART2_UART_IIR_TOD_MASK 0x8
#define  UART2_UART_IIR_TOD_SHIFT 3
#define  UART2_UART_IIR_TOD_MASK_SHIFT(reg) (((reg) & UART2_UART_IIR_TOD_MASK) >> UART2_UART_IIR_TOD_SHIFT)
#define  UART2_UART_IIR_TOD_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_IIR_TOD_MASK) | (((uint32_t)val) << UART2_UART_IIR_TOD_SHIFT))

#define  UART2_UART_IIR_IID10_MASK 0x6
#define  UART2_UART_IIR_IID10_SHIFT 1
#define  UART2_UART_IIR_IID10_MASK_SHIFT(reg) (((reg) & UART2_UART_IIR_IID10_MASK) >> UART2_UART_IIR_IID10_SHIFT)
#define  UART2_UART_IIR_IID10_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_IIR_IID10_MASK) | (((uint32_t)val) << UART2_UART_IIR_IID10_SHIFT))

#define  UART2_UART_IIR_NIP_MASK 0x1
#define  UART2_UART_IIR_NIP_SHIFT 0
#define  UART2_UART_IIR_NIP_MASK_SHIFT(reg) (((reg) & UART2_UART_IIR_NIP_MASK) >> UART2_UART_IIR_NIP_SHIFT)
#define  UART2_UART_IIR_NIP_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_IIR_NIP_MASK) | (((uint32_t)val) << UART2_UART_IIR_NIP_SHIFT))

//====================================================================
//Register: FIFO Control Register (UART_FCR)
/** \brief This is a write-only register that is located at the same address as the
Interrupt Identification Register, which is a read-only register. This register
enables/disables the transmit/receive FIFOs, clears the transmit/receive FIFOs,
and sets the receive FIFO trigger threshold.
Note: The trigger level must be equal to the DMA burst length programmed in the
DMA registers.
Interrupt Trigger Level - When the number of bytes in the receive FIFO equals
the interrupt trigger level programmed into this field and the
received-data-available interrupt is enabled (via the Interrupt Enable
Register), an interrupt is generated and the appropriate bits are set in the
Interrupt Identification Register. The receive DMA request is generated as well
when trigger level is reached. The trigger level must be greater than or equal
to the DMA burst size programmed in the DMA registers.
32-Bit Peripheral Bus - When clear, the UART ignores any information in the
upper three bytes of the 32-bit bus. A full- or partial-word read or write to
the UART with this field clear increments the FIFO counters by only one byte. If
this field is set, a full- or partial-word read or write increments the counter
by the number of valid bytes within the word.
Trailing Bytes - When clear, trailing bytes are handled by the PXA2128
Application Processor. When set, trailing bytes are handled automatically by the
DMA controller. See the DMA section for more information.
Transmit Interrupt Level - Setting this field causes transmitter interrupts and
DMA requests to occur when the transmit FIFO is empty. Clearing this field
causes transmitter interrupts and DMA requests to occur when the transmit FIFO
is half empty.
Reset Transmit FIFO - When this field is set, the transmit FIFO counter is reset
to clear all the bytes in the FIFO. The <Transmit Data Request> field in the
Line Status Register is set, generating a transmitter-requests-data interrupt
(<Interrupt Source Encoded> field in the Interrupt Identification Register) if
the <Transmit Data Request Interrupt Enable> field in the Interrupt Enable
Register is set. The Transmit Shift Register is not reset, it completes the
current transmission. Any DMA or transmit-FIFO-service-request interrupts are
cleared.
Note: The <Reset Transmit FIFO> field is reset to 0 automatically after the FIFO
is cleared.
Reset Receive FIFO - When this field is set, the receive FIFO counter is reset
to clear all the bytes in the FIFO. The <Data Ready> field in the Line Status
Register is cleared. All error bits in the FIFO and the <FIFO Error
Status> field in the Line Status Register are cleared. Any error bits (OE, PE,
FE, or BI) that had been set in the Line Status Register remain set. The Receive
Shift Register is not cleared. Any DMA or receive-FIFO-service-request
interrupts are cleared.
Note: The <Reset Receive FIFO> field is reset automatically to 0 after the FIFO
is cleared.
Transmit and Receive FIFO Enable - This field enables and disables the transmit
and receive FIFOs. When it is set, both FIFOs are enabled (FIFO mode). When it
is clear, the FIFOs are both disabled (non-FIFO mode). Writing 0x0 to this bit
clears all bytes in both FIFOs. When changing from FIFO mode to non-FIFO mode
and vice versa, data is cleared automatically from the FIFOs. Any DMA or
FIFO-service-request interrupts are cleared when this field is clear.
Note: This field must be 1 when other fields in this register are written, or
the other fields are not programmed.
This is a write-only register. Write 0x0 to reserved bits.*/
//====================================================================

#define  UART2_UART_FCR_RESERVED1_MASK 0xffffff00
#define  UART2_UART_FCR_RESERVED1_SHIFT 8
#define  UART2_UART_FCR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART2_UART_FCR_RESERVED1_MASK) >> UART2_UART_FCR_RESERVED1_SHIFT)
#define  UART2_UART_FCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_FCR_RESERVED1_MASK) | (((uint32_t)val) << UART2_UART_FCR_RESERVED1_SHIFT))

#define  UART2_UART_FCR_ITL_MASK 0xc0
#define  UART2_UART_FCR_ITL_SHIFT 6
#define  UART2_UART_FCR_ITL_MASK_SHIFT(reg) (((reg) & UART2_UART_FCR_ITL_MASK) >> UART2_UART_FCR_ITL_SHIFT)
#define  UART2_UART_FCR_ITL_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_FCR_ITL_MASK) | (((uint32_t)val) << UART2_UART_FCR_ITL_SHIFT))

#define  UART2_UART_FCR_BUS_MASK 0x20
#define  UART2_UART_FCR_BUS_SHIFT 5
#define  UART2_UART_FCR_BUS_MASK_SHIFT(reg) (((reg) & UART2_UART_FCR_BUS_MASK) >> UART2_UART_FCR_BUS_SHIFT)
#define  UART2_UART_FCR_BUS_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_FCR_BUS_MASK) | (((uint32_t)val) << UART2_UART_FCR_BUS_SHIFT))

#define  UART2_UART_FCR_TRAIL_MASK 0x10
#define  UART2_UART_FCR_TRAIL_SHIFT 4
#define  UART2_UART_FCR_TRAIL_MASK_SHIFT(reg) (((reg) & UART2_UART_FCR_TRAIL_MASK) >> UART2_UART_FCR_TRAIL_SHIFT)
#define  UART2_UART_FCR_TRAIL_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_FCR_TRAIL_MASK) | (((uint32_t)val) << UART2_UART_FCR_TRAIL_SHIFT))

#define  UART2_UART_FCR_TIL_MASK 0x8
#define  UART2_UART_FCR_TIL_SHIFT 3
#define  UART2_UART_FCR_TIL_MASK_SHIFT(reg) (((reg) & UART2_UART_FCR_TIL_MASK) >> UART2_UART_FCR_TIL_SHIFT)
#define  UART2_UART_FCR_TIL_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_FCR_TIL_MASK) | (((uint32_t)val) << UART2_UART_FCR_TIL_SHIFT))

#define  UART2_UART_FCR_RESETTF_MASK 0x4
#define  UART2_UART_FCR_RESETTF_SHIFT 2
#define  UART2_UART_FCR_RESETTF_MASK_SHIFT(reg) (((reg) & UART2_UART_FCR_RESETTF_MASK) >> UART2_UART_FCR_RESETTF_SHIFT)
#define  UART2_UART_FCR_RESETTF_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_FCR_RESETTF_MASK) | (((uint32_t)val) << UART2_UART_FCR_RESETTF_SHIFT))

#define  UART2_UART_FCR_RESETRF_MASK 0x2
#define  UART2_UART_FCR_RESETRF_SHIFT 1
#define  UART2_UART_FCR_RESETRF_MASK_SHIFT(reg) (((reg) & UART2_UART_FCR_RESETRF_MASK) >> UART2_UART_FCR_RESETRF_SHIFT)
#define  UART2_UART_FCR_RESETRF_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_FCR_RESETRF_MASK) | (((uint32_t)val) << UART2_UART_FCR_RESETRF_SHIFT))

#define  UART2_UART_FCR_TRFIFOE_MASK 0x1
#define  UART2_UART_FCR_TRFIFOE_SHIFT 0
#define  UART2_UART_FCR_TRFIFOE_MASK_SHIFT(reg) (((reg) & UART2_UART_FCR_TRFIFOE_MASK) >> UART2_UART_FCR_TRFIFOE_SHIFT)
#define  UART2_UART_FCR_TRFIFOE_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_FCR_TRFIFOE_MASK) | (((uint32_t)val) << UART2_UART_FCR_TRFIFOE_SHIFT))

//====================================================================
//Register: Line Control Register (UART_LCR)
/** \brief This register specifies the format for the asynchronous data-communications
exchange. The serial-data format consists of a start bit, 8 data bits, an
optional parity bit, and 1 stop bit. This register has bits that allow access to
the Divisor Latch registers and bits that can cause a break condition.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART2_UART_LCR_RESERVED1_MASK 0xffffff00
#define  UART2_UART_LCR_RESERVED1_SHIFT 8
#define  UART2_UART_LCR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART2_UART_LCR_RESERVED1_MASK) >> UART2_UART_LCR_RESERVED1_SHIFT)
#define  UART2_UART_LCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_LCR_RESERVED1_MASK) | (((uint32_t)val) << UART2_UART_LCR_RESERVED1_SHIFT))

#define  UART2_UART_LCR_DLAB_MASK 0x80
#define  UART2_UART_LCR_DLAB_SHIFT 7
#define  UART2_UART_LCR_DLAB_MASK_SHIFT(reg) (((reg) & UART2_UART_LCR_DLAB_MASK) >> UART2_UART_LCR_DLAB_SHIFT)
#define  UART2_UART_LCR_DLAB_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_LCR_DLAB_MASK) | (((uint32_t)val) << UART2_UART_LCR_DLAB_SHIFT))

#define  UART2_UART_LCR_SB_MASK 0x40
#define  UART2_UART_LCR_SB_SHIFT 6
#define  UART2_UART_LCR_SB_MASK_SHIFT(reg) (((reg) & UART2_UART_LCR_SB_MASK) >> UART2_UART_LCR_SB_SHIFT)
#define  UART2_UART_LCR_SB_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_LCR_SB_MASK) | (((uint32_t)val) << UART2_UART_LCR_SB_SHIFT))

#define  UART2_UART_LCR_STKYP_MASK 0x20
#define  UART2_UART_LCR_STKYP_SHIFT 5
#define  UART2_UART_LCR_STKYP_MASK_SHIFT(reg) (((reg) & UART2_UART_LCR_STKYP_MASK) >> UART2_UART_LCR_STKYP_SHIFT)
#define  UART2_UART_LCR_STKYP_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_LCR_STKYP_MASK) | (((uint32_t)val) << UART2_UART_LCR_STKYP_SHIFT))

#define  UART2_UART_LCR_EPS_MASK 0x10
#define  UART2_UART_LCR_EPS_SHIFT 4
#define  UART2_UART_LCR_EPS_MASK_SHIFT(reg) (((reg) & UART2_UART_LCR_EPS_MASK) >> UART2_UART_LCR_EPS_SHIFT)
#define  UART2_UART_LCR_EPS_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_LCR_EPS_MASK) | (((uint32_t)val) << UART2_UART_LCR_EPS_SHIFT))

#define  UART2_UART_LCR_PEN_MASK 0x8
#define  UART2_UART_LCR_PEN_SHIFT 3
#define  UART2_UART_LCR_PEN_MASK_SHIFT(reg) (((reg) & UART2_UART_LCR_PEN_MASK) >> UART2_UART_LCR_PEN_SHIFT)
#define  UART2_UART_LCR_PEN_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_LCR_PEN_MASK) | (((uint32_t)val) << UART2_UART_LCR_PEN_SHIFT))

#define  UART2_UART_LCR_STB_MASK 0x4
#define  UART2_UART_LCR_STB_SHIFT 2
#define  UART2_UART_LCR_STB_MASK_SHIFT(reg) (((reg) & UART2_UART_LCR_STB_MASK) >> UART2_UART_LCR_STB_SHIFT)
#define  UART2_UART_LCR_STB_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_LCR_STB_MASK) | (((uint32_t)val) << UART2_UART_LCR_STB_SHIFT))

#define  UART2_UART_LCR_WLS10_MASK 0x3
#define  UART2_UART_LCR_WLS10_SHIFT 0
#define  UART2_UART_LCR_WLS10_MASK_SHIFT(reg) (((reg) & UART2_UART_LCR_WLS10_MASK) >> UART2_UART_LCR_WLS10_SHIFT)
#define  UART2_UART_LCR_WLS10_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_LCR_WLS10_MASK) | (((uint32_t)val) << UART2_UART_LCR_WLS10_SHIFT))

//====================================================================
//Register: Modem Control Register (UART_MCR)
/** \brief This register uses the modem control pins RTSn and DTRn to control the interface
with a modem or data set. This register also controls the loopback mode.
Loopback mode must be enabled before the UART is enabled.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART2_UART_MCR_RESERVED1_MASK 0xffffffc0
#define  UART2_UART_MCR_RESERVED1_SHIFT 6
#define  UART2_UART_MCR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART2_UART_MCR_RESERVED1_MASK) >> UART2_UART_MCR_RESERVED1_SHIFT)
#define  UART2_UART_MCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_MCR_RESERVED1_MASK) | (((uint32_t)val) << UART2_UART_MCR_RESERVED1_SHIFT))

#define  UART2_UART_MCR_AFE_MASK 0x20
#define  UART2_UART_MCR_AFE_SHIFT 5
#define  UART2_UART_MCR_AFE_MASK_SHIFT(reg) (((reg) & UART2_UART_MCR_AFE_MASK) >> UART2_UART_MCR_AFE_SHIFT)
#define  UART2_UART_MCR_AFE_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_MCR_AFE_MASK) | (((uint32_t)val) << UART2_UART_MCR_AFE_SHIFT))

#define  UART2_UART_MCR_LOOP_MASK 0x10
#define  UART2_UART_MCR_LOOP_SHIFT 4
#define  UART2_UART_MCR_LOOP_MASK_SHIFT(reg) (((reg) & UART2_UART_MCR_LOOP_MASK) >> UART2_UART_MCR_LOOP_SHIFT)
#define  UART2_UART_MCR_LOOP_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_MCR_LOOP_MASK) | (((uint32_t)val) << UART2_UART_MCR_LOOP_SHIFT))

#define  UART2_UART_MCR_OUT2_MASK 0x8
#define  UART2_UART_MCR_OUT2_SHIFT 3
#define  UART2_UART_MCR_OUT2_MASK_SHIFT(reg) (((reg) & UART2_UART_MCR_OUT2_MASK) >> UART2_UART_MCR_OUT2_SHIFT)
#define  UART2_UART_MCR_OUT2_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_MCR_OUT2_MASK) | (((uint32_t)val) << UART2_UART_MCR_OUT2_SHIFT))

#define  UART2_UART_MCR_OUT1_MASK 0x4
#define  UART2_UART_MCR_OUT1_SHIFT 2
#define  UART2_UART_MCR_OUT1_MASK_SHIFT(reg) (((reg) & UART2_UART_MCR_OUT1_MASK) >> UART2_UART_MCR_OUT1_SHIFT)
#define  UART2_UART_MCR_OUT1_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_MCR_OUT1_MASK) | (((uint32_t)val) << UART2_UART_MCR_OUT1_SHIFT))

#define  UART2_UART_MCR_RTS_MASK 0x2
#define  UART2_UART_MCR_RTS_SHIFT 1
#define  UART2_UART_MCR_RTS_MASK_SHIFT(reg) (((reg) & UART2_UART_MCR_RTS_MASK) >> UART2_UART_MCR_RTS_SHIFT)
#define  UART2_UART_MCR_RTS_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_MCR_RTS_MASK) | (((uint32_t)val) << UART2_UART_MCR_RTS_SHIFT))

#define  UART2_UART_MCR_DTR_MASK 0x1
#define  UART2_UART_MCR_DTR_SHIFT 0
#define  UART2_UART_MCR_DTR_MASK_SHIFT(reg) (((reg) & UART2_UART_MCR_DTR_MASK) >> UART2_UART_MCR_DTR_SHIFT)
#define  UART2_UART_MCR_DTR_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_MCR_DTR_MASK) | (((uint32_t)val) << UART2_UART_MCR_DTR_SHIFT))

//====================================================================
//Register: Line Status Register (UART_LSR)
/** \brief This register provides data-transfer status information to the PXA2128
Application Processor. In non-FIFO mode, bits [4:2] show the error status of the
character that has just been received. In FIFO mode, bits [4:2] show the status
bits of the character that is currently at the front of the FIFO.
Bits [4:1] produce a receiver-line-status interrupt when the corresponding
conditions are detected and the interrupt is enabled. In FIFO mode, the
receiver-line-status interrupt occurs only when the erroneous character reaches
the front of the FIFO. If the erroneous character is not at the front of the
FIFO, a line-status interrupt is generated after the other characters are read,
and the erroneous character becomes the character at the front of the FIFO.
This register must be read before the erroneous character is read. Bits [4:1]
remain set until software reads this register.
See FIFO DMA Mode Operation section in the PXA2128 Application Processor
Datasheet for details on using the DMAC to receive data.
This is a read-only register. Ignore reads from reserved bits.*/
//====================================================================

#define  UART2_UART_LSR_RESERVED1_MASK 0xffffff00
#define  UART2_UART_LSR_RESERVED1_SHIFT 8
#define  UART2_UART_LSR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART2_UART_LSR_RESERVED1_MASK) >> UART2_UART_LSR_RESERVED1_SHIFT)
#define  UART2_UART_LSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_LSR_RESERVED1_MASK) | (((uint32_t)val) << UART2_UART_LSR_RESERVED1_SHIFT))

#define  UART2_UART_LSR_FIFOE_MASK 0x80
#define  UART2_UART_LSR_FIFOE_SHIFT 7
#define  UART2_UART_LSR_FIFOE_MASK_SHIFT(reg) (((reg) & UART2_UART_LSR_FIFOE_MASK) >> UART2_UART_LSR_FIFOE_SHIFT)
#define  UART2_UART_LSR_FIFOE_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_LSR_FIFOE_MASK) | (((uint32_t)val) << UART2_UART_LSR_FIFOE_SHIFT))

#define  UART2_UART_LSR_TEMT_MASK 0x40
#define  UART2_UART_LSR_TEMT_SHIFT 6
#define  UART2_UART_LSR_TEMT_MASK_SHIFT(reg) (((reg) & UART2_UART_LSR_TEMT_MASK) >> UART2_UART_LSR_TEMT_SHIFT)
#define  UART2_UART_LSR_TEMT_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_LSR_TEMT_MASK) | (((uint32_t)val) << UART2_UART_LSR_TEMT_SHIFT))

#define  UART2_UART_LSR_TDRQ_MASK 0x20
#define  UART2_UART_LSR_TDRQ_SHIFT 5
#define  UART2_UART_LSR_TDRQ_MASK_SHIFT(reg) (((reg) & UART2_UART_LSR_TDRQ_MASK) >> UART2_UART_LSR_TDRQ_SHIFT)
#define  UART2_UART_LSR_TDRQ_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_LSR_TDRQ_MASK) | (((uint32_t)val) << UART2_UART_LSR_TDRQ_SHIFT))

#define  UART2_UART_LSR_BI_MASK 0x10
#define  UART2_UART_LSR_BI_SHIFT 4
#define  UART2_UART_LSR_BI_MASK_SHIFT(reg) (((reg) & UART2_UART_LSR_BI_MASK) >> UART2_UART_LSR_BI_SHIFT)
#define  UART2_UART_LSR_BI_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_LSR_BI_MASK) | (((uint32_t)val) << UART2_UART_LSR_BI_SHIFT))

#define  UART2_UART_LSR_FE_MASK 0x8
#define  UART2_UART_LSR_FE_SHIFT 3
#define  UART2_UART_LSR_FE_MASK_SHIFT(reg) (((reg) & UART2_UART_LSR_FE_MASK) >> UART2_UART_LSR_FE_SHIFT)
#define  UART2_UART_LSR_FE_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_LSR_FE_MASK) | (((uint32_t)val) << UART2_UART_LSR_FE_SHIFT))

#define  UART2_UART_LSR_PE_MASK 0x4
#define  UART2_UART_LSR_PE_SHIFT 2
#define  UART2_UART_LSR_PE_MASK_SHIFT(reg) (((reg) & UART2_UART_LSR_PE_MASK) >> UART2_UART_LSR_PE_SHIFT)
#define  UART2_UART_LSR_PE_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_LSR_PE_MASK) | (((uint32_t)val) << UART2_UART_LSR_PE_SHIFT))

#define  UART2_UART_LSR_OE_MASK 0x2
#define  UART2_UART_LSR_OE_SHIFT 1
#define  UART2_UART_LSR_OE_MASK_SHIFT(reg) (((reg) & UART2_UART_LSR_OE_MASK) >> UART2_UART_LSR_OE_SHIFT)
#define  UART2_UART_LSR_OE_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_LSR_OE_MASK) | (((uint32_t)val) << UART2_UART_LSR_OE_SHIFT))

#define  UART2_UART_LSR_DR_MASK 0x1
#define  UART2_UART_LSR_DR_SHIFT 0
#define  UART2_UART_LSR_DR_MASK_SHIFT(reg) (((reg) & UART2_UART_LSR_DR_MASK) >> UART2_UART_LSR_DR_SHIFT)
#define  UART2_UART_LSR_DR_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_LSR_DR_MASK) | (((uint32_t)val) << UART2_UART_LSR_DR_SHIFT))

//====================================================================
//Register: Modem Status Register (UART_MSR)
/** \brief This register provides the current state of the control lines from the modem or
data set (or a peripheral device emulating a modem) to the PXA2128 Application
Processor. In addition to this current state information, four bits provide
change information. Bits [3:0] are set when a control input from the modem
changes state. They are cleared when the PXA2128 Application Processor reads
this register.
The status of the modem control lines does not affect the FIFOs. The <Modem
Interrupt Enable> field in the Interrupt Enable Register must be set to use
these lines for flow control. The interrupt service routine must disable the
UART when an interrupt occurs on one of the flow-control pins. The UART
continues transmission/reception of the current character and then stops. The
contents of the FIFOs are preserved. If the UART is re-enabled, transmission
continues where it stopped.
Note: When bit 0, 1, 2, or 3 is set, a modem-status interrupt is generated if
the <Modem Interrupt Enable> field is set.
This is a read-only register. Ignore reads from reserved bits.*/
//====================================================================

#define  UART2_UART_MSR_RESERVED1_MASK 0xffffff00
#define  UART2_UART_MSR_RESERVED1_SHIFT 8
#define  UART2_UART_MSR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART2_UART_MSR_RESERVED1_MASK) >> UART2_UART_MSR_RESERVED1_SHIFT)
#define  UART2_UART_MSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_MSR_RESERVED1_MASK) | (((uint32_t)val) << UART2_UART_MSR_RESERVED1_SHIFT))

#define  UART2_UART_MSR_DCD_MASK 0x80
#define  UART2_UART_MSR_DCD_SHIFT 7
#define  UART2_UART_MSR_DCD_MASK_SHIFT(reg) (((reg) & UART2_UART_MSR_DCD_MASK) >> UART2_UART_MSR_DCD_SHIFT)
#define  UART2_UART_MSR_DCD_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_MSR_DCD_MASK) | (((uint32_t)val) << UART2_UART_MSR_DCD_SHIFT))

#define  UART2_UART_MSR_RI_MASK 0x40
#define  UART2_UART_MSR_RI_SHIFT 6
#define  UART2_UART_MSR_RI_MASK_SHIFT(reg) (((reg) & UART2_UART_MSR_RI_MASK) >> UART2_UART_MSR_RI_SHIFT)
#define  UART2_UART_MSR_RI_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_MSR_RI_MASK) | (((uint32_t)val) << UART2_UART_MSR_RI_SHIFT))

#define  UART2_UART_MSR_DSR_MASK 0x20
#define  UART2_UART_MSR_DSR_SHIFT 5
#define  UART2_UART_MSR_DSR_MASK_SHIFT(reg) (((reg) & UART2_UART_MSR_DSR_MASK) >> UART2_UART_MSR_DSR_SHIFT)
#define  UART2_UART_MSR_DSR_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_MSR_DSR_MASK) | (((uint32_t)val) << UART2_UART_MSR_DSR_SHIFT))

#define  UART2_UART_MSR_CTS_MASK 0x10
#define  UART2_UART_MSR_CTS_SHIFT 4
#define  UART2_UART_MSR_CTS_MASK_SHIFT(reg) (((reg) & UART2_UART_MSR_CTS_MASK) >> UART2_UART_MSR_CTS_SHIFT)
#define  UART2_UART_MSR_CTS_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_MSR_CTS_MASK) | (((uint32_t)val) << UART2_UART_MSR_CTS_SHIFT))

#define  UART2_UART_MSR_DDCD_MASK 0x8
#define  UART2_UART_MSR_DDCD_SHIFT 3
#define  UART2_UART_MSR_DDCD_MASK_SHIFT(reg) (((reg) & UART2_UART_MSR_DDCD_MASK) >> UART2_UART_MSR_DDCD_SHIFT)
#define  UART2_UART_MSR_DDCD_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_MSR_DDCD_MASK) | (((uint32_t)val) << UART2_UART_MSR_DDCD_SHIFT))

#define  UART2_UART_MSR_TERI_MASK 0x4
#define  UART2_UART_MSR_TERI_SHIFT 2
#define  UART2_UART_MSR_TERI_MASK_SHIFT(reg) (((reg) & UART2_UART_MSR_TERI_MASK) >> UART2_UART_MSR_TERI_SHIFT)
#define  UART2_UART_MSR_TERI_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_MSR_TERI_MASK) | (((uint32_t)val) << UART2_UART_MSR_TERI_SHIFT))

#define  UART2_UART_MSR_DDSR_MASK 0x2
#define  UART2_UART_MSR_DDSR_SHIFT 1
#define  UART2_UART_MSR_DDSR_MASK_SHIFT(reg) (((reg) & UART2_UART_MSR_DDSR_MASK) >> UART2_UART_MSR_DDSR_SHIFT)
#define  UART2_UART_MSR_DDSR_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_MSR_DDSR_MASK) | (((uint32_t)val) << UART2_UART_MSR_DDSR_SHIFT))

#define  UART2_UART_MSR_DCTS_MASK 0x1
#define  UART2_UART_MSR_DCTS_SHIFT 0
#define  UART2_UART_MSR_DCTS_MASK_SHIFT(reg) (((reg) & UART2_UART_MSR_DCTS_MASK) >> UART2_UART_MSR_DCTS_SHIFT)
#define  UART2_UART_MSR_DCTS_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_MSR_DCTS_MASK) | (((uint32_t)val) << UART2_UART_MSR_DCTS_SHIFT))

//====================================================================
//Register: Scratchpad Register (UART_SCR)
/** \brief This register has no effect on the UART. It is intended as a scratchpad register
for use by programmers and is included for 16550A compatibility.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART2_UART_SCR_RESERVED1_MASK 0xffffff00
#define  UART2_UART_SCR_RESERVED1_SHIFT 8
#define  UART2_UART_SCR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART2_UART_SCR_RESERVED1_MASK) >> UART2_UART_SCR_RESERVED1_SHIFT)
#define  UART2_UART_SCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_SCR_RESERVED1_MASK) | (((uint32_t)val) << UART2_UART_SCR_RESERVED1_SHIFT))

#define  UART2_UART_SCR_SCRATCHPAD_MASK 0xff
#define  UART2_UART_SCR_SCRATCHPAD_SHIFT 0
#define  UART2_UART_SCR_SCRATCHPAD_MASK_SHIFT(reg) (((reg) & UART2_UART_SCR_SCRATCHPAD_MASK) >> UART2_UART_SCR_SCRATCHPAD_SHIFT)
#define  UART2_UART_SCR_SCRATCHPAD_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_SCR_SCRATCHPAD_MASK) | (((uint32_t)val) << UART2_UART_SCR_SCRATCHPAD_SHIFT))

//====================================================================
//Register: Infrared Selection Register (UART_ISR)
/** \brief Each UART can manage an IrDA module associated with it. This register controls
the IrDA functions (see Serial Infrared Asynchronous Interface in the PXA2128
Application Processor Datasheet).
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART2_UART_ISR_RESERVED1_MASK 0xffffffe0
#define  UART2_UART_ISR_RESERVED1_SHIFT 5
#define  UART2_UART_ISR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART2_UART_ISR_RESERVED1_MASK) >> UART2_UART_ISR_RESERVED1_SHIFT)
#define  UART2_UART_ISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_ISR_RESERVED1_MASK) | (((uint32_t)val) << UART2_UART_ISR_RESERVED1_SHIFT))

#define  UART2_UART_ISR_RXPL_MASK 0x10
#define  UART2_UART_ISR_RXPL_SHIFT 4
#define  UART2_UART_ISR_RXPL_MASK_SHIFT(reg) (((reg) & UART2_UART_ISR_RXPL_MASK) >> UART2_UART_ISR_RXPL_SHIFT)
#define  UART2_UART_ISR_RXPL_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_ISR_RXPL_MASK) | (((uint32_t)val) << UART2_UART_ISR_RXPL_SHIFT))

#define  UART2_UART_ISR_TXPL_MASK 0x8
#define  UART2_UART_ISR_TXPL_SHIFT 3
#define  UART2_UART_ISR_TXPL_MASK_SHIFT(reg) (((reg) & UART2_UART_ISR_TXPL_MASK) >> UART2_UART_ISR_TXPL_SHIFT)
#define  UART2_UART_ISR_TXPL_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_ISR_TXPL_MASK) | (((uint32_t)val) << UART2_UART_ISR_TXPL_SHIFT))

#define  UART2_UART_ISR_XMODE_MASK 0x4
#define  UART2_UART_ISR_XMODE_SHIFT 2
#define  UART2_UART_ISR_XMODE_MASK_SHIFT(reg) (((reg) & UART2_UART_ISR_XMODE_MASK) >> UART2_UART_ISR_XMODE_SHIFT)
#define  UART2_UART_ISR_XMODE_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_ISR_XMODE_MASK) | (((uint32_t)val) << UART2_UART_ISR_XMODE_SHIFT))

#define  UART2_UART_ISR_RCVEIR_MASK 0x2
#define  UART2_UART_ISR_RCVEIR_SHIFT 1
#define  UART2_UART_ISR_RCVEIR_MASK_SHIFT(reg) (((reg) & UART2_UART_ISR_RCVEIR_MASK) >> UART2_UART_ISR_RCVEIR_SHIFT)
#define  UART2_UART_ISR_RCVEIR_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_ISR_RCVEIR_MASK) | (((uint32_t)val) << UART2_UART_ISR_RCVEIR_SHIFT))

#define  UART2_UART_ISR_XMITIR_MASK 0x1
#define  UART2_UART_ISR_XMITIR_SHIFT 0
#define  UART2_UART_ISR_XMITIR_MASK_SHIFT(reg) (((reg) & UART2_UART_ISR_XMITIR_MASK) >> UART2_UART_ISR_XMITIR_SHIFT)
#define  UART2_UART_ISR_XMITIR_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_ISR_XMITIR_MASK) | (((uint32_t)val) << UART2_UART_ISR_XMITIR_SHIFT))

//====================================================================
//Register: Receive FIFO Occupancy Register (UART_FOR)
/** \brief This register shows the number of bytes currently remaining the receive FIFO.
This register can be used to determine the number of trailing bytes to remove in
the case when the DMA reaches the end of its descriptor chain or when
the <Trailing Bytes> field in the FIFO Control Register is clear, which
indicates that the PXA2128 Application Processor removes trailing bytes as
opposed to the DMA (see Removing Trailing Bytes in DMA Mode section in PXA2128
Application Processor Datasheet). This register is incremented once for each
byte of data written to the receive FIFO and decremented once for each byte
read.
This is a read/write register. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  UART2_UART_FOR_RESERVED1_MASK 0xffffffc0
#define  UART2_UART_FOR_RESERVED1_SHIFT 6
#define  UART2_UART_FOR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART2_UART_FOR_RESERVED1_MASK) >> UART2_UART_FOR_RESERVED1_SHIFT)
#define  UART2_UART_FOR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_FOR_RESERVED1_MASK) | (((uint32_t)val) << UART2_UART_FOR_RESERVED1_SHIFT))

#define  UART2_UART_FOR_BYTE_COUNT_MASK 0x3f
#define  UART2_UART_FOR_BYTE_COUNT_SHIFT 0
#define  UART2_UART_FOR_BYTE_COUNT_MASK_SHIFT(reg) (((reg) & UART2_UART_FOR_BYTE_COUNT_MASK) >> UART2_UART_FOR_BYTE_COUNT_SHIFT)
#define  UART2_UART_FOR_BYTE_COUNT_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_FOR_BYTE_COUNT_MASK) | (((uint32_t)val) << UART2_UART_FOR_BYTE_COUNT_SHIFT))

//====================================================================
//Register: Auto-Baud Control Register (UART_ABR)
/** \brief This register controls the functionality and options for auto-baud-rate
detection within the UART. Through this register, software can enable/disable
the auto-baud-lock interrupt, direct either the PXA2128 Application Processor or
the UART to program the final baud rate in the Divisor Latch registers, and
choose between two methods used to calculate the final baud rate.
The auto-baud circuitry counts the number of clocks in the start bit and writes
this count into the Auto-Baud Count register (ACR). It then interrupts the
PXA2128 Application Processor if the <Auto-baud Lock> field in the Interrupt
Identification Register is set. It also programs automatically the Divisor Latch
registers (DLL and DLH) if the <ABUP> field is set.
See Auto-Baud-Rate Detection section in PXA2128 Application Processor Datasheet
for more information on auto-baud rate.
Note: Auto-baud-rate detection is not supported in IrDA serial-infrared mode.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART2_UART_ABR_RESERVED1_MASK 0xfffffff0
#define  UART2_UART_ABR_RESERVED1_SHIFT 4
#define  UART2_UART_ABR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART2_UART_ABR_RESERVED1_MASK) >> UART2_UART_ABR_RESERVED1_SHIFT)
#define  UART2_UART_ABR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_ABR_RESERVED1_MASK) | (((uint32_t)val) << UART2_UART_ABR_RESERVED1_SHIFT))

#define  UART2_UART_ABR_ABT_MASK 0x8
#define  UART2_UART_ABR_ABT_SHIFT 3
#define  UART2_UART_ABR_ABT_MASK_SHIFT(reg) (((reg) & UART2_UART_ABR_ABT_MASK) >> UART2_UART_ABR_ABT_SHIFT)
#define  UART2_UART_ABR_ABT_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_ABR_ABT_MASK) | (((uint32_t)val) << UART2_UART_ABR_ABT_SHIFT))

#define  UART2_UART_ABR_ABUP_MASK 0x4
#define  UART2_UART_ABR_ABUP_SHIFT 2
#define  UART2_UART_ABR_ABUP_MASK_SHIFT(reg) (((reg) & UART2_UART_ABR_ABUP_MASK) >> UART2_UART_ABR_ABUP_SHIFT)
#define  UART2_UART_ABR_ABUP_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_ABR_ABUP_MASK) | (((uint32_t)val) << UART2_UART_ABR_ABUP_SHIFT))

#define  UART2_UART_ABR_ABLIE_MASK 0x2
#define  UART2_UART_ABR_ABLIE_SHIFT 1
#define  UART2_UART_ABR_ABLIE_MASK_SHIFT(reg) (((reg) & UART2_UART_ABR_ABLIE_MASK) >> UART2_UART_ABR_ABLIE_SHIFT)
#define  UART2_UART_ABR_ABLIE_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_ABR_ABLIE_MASK) | (((uint32_t)val) << UART2_UART_ABR_ABLIE_SHIFT))

#define  UART2_UART_ABR_ABE_MASK 0x1
#define  UART2_UART_ABR_ABE_SHIFT 0
#define  UART2_UART_ABR_ABE_MASK_SHIFT(reg) (((reg) & UART2_UART_ABR_ABE_MASK) >> UART2_UART_ABR_ABE_SHIFT)
#define  UART2_UART_ABR_ABE_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_ABR_ABE_MASK) | (((uint32_t)val) << UART2_UART_ABR_ABE_SHIFT))

//====================================================================
//Register: Auto-Baud Count Register (UART_ACR)
/** \brief This register stores the number of 14.857-MHz clock cycles within a start-bit
pulse. This value is then used by the PXA2128 Application Processor or the UART
to calculate the baud rate. If auto-baud mode (<ABE> field in Auto-Baud Control
Register) and auto-baud interrupts (<ABLIE> field in Auto-Baud Control Register)
are enabled, the UART interrupts the PXA2128 Application Processor with the
auto-baud-lock interrupt (IIR[ABL]) after it has written the count value into
ACR. The value is written regardless of the state of the auto-baud UART program
bit, (ABR[ABUP]).
This is a read-only register. Ignore reads from reserved bits.*/
//====================================================================

#define  UART2_UART_ACR_RESERVED1_MASK 0xffff0000
#define  UART2_UART_ACR_RESERVED1_SHIFT 16
#define  UART2_UART_ACR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART2_UART_ACR_RESERVED1_MASK) >> UART2_UART_ACR_RESERVED1_SHIFT)
#define  UART2_UART_ACR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_ACR_RESERVED1_MASK) | (((uint32_t)val) << UART2_UART_ACR_RESERVED1_SHIFT))

#define  UART2_UART_ACR_COUNT_VALUE_MASK 0xffff
#define  UART2_UART_ACR_COUNT_VALUE_SHIFT 0
#define  UART2_UART_ACR_COUNT_VALUE_MASK_SHIFT(reg) (((reg) & UART2_UART_ACR_COUNT_VALUE_MASK) >> UART2_UART_ACR_COUNT_VALUE_SHIFT)
#define  UART2_UART_ACR_COUNT_VALUE_REPLACE_VAL(reg,val) (((reg) & ~UART2_UART_ACR_COUNT_VALUE_MASK) | (((uint32_t)val) << UART2_UART_ACR_COUNT_VALUE_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  UART2_REV0_MAJ_MASK 0xffff0000
#define  UART2_REV0_MAJ_SHIFT 16
#define  UART2_REV0_MAJ_MASK_SHIFT(reg) (((reg) & UART2_REV0_MAJ_MASK) >> UART2_REV0_MAJ_SHIFT)
#define  UART2_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~UART2_REV0_MAJ_MASK) | (((uint32_t)val) << UART2_REV0_MAJ_SHIFT))

#define  UART2_REV0_MID_MASK 0xffff
#define  UART2_REV0_MID_SHIFT 0
#define  UART2_REV0_MID_MASK_SHIFT(reg) (((reg) & UART2_REV0_MID_MASK) >> UART2_REV0_MID_SHIFT)
#define  UART2_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~UART2_REV0_MID_MASK) | (((uint32_t)val) << UART2_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  UART2_REV1_RESERVED1_MASK 0xffff0000
#define  UART2_REV1_RESERVED1_SHIFT 16
#define  UART2_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & UART2_REV1_RESERVED1_MASK) >> UART2_REV1_RESERVED1_SHIFT)
#define  UART2_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART2_REV1_RESERVED1_MASK) | (((uint32_t)val) << UART2_REV1_RESERVED1_SHIFT))

#define  UART2_REV1_CFG_MASK 0xffff
#define  UART2_REV1_CFG_SHIFT 0
#define  UART2_REV1_CFG_MASK_SHIFT(reg) (((reg) & UART2_REV1_CFG_MASK) >> UART2_REV1_CFG_SHIFT)
#define  UART2_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~UART2_REV1_CFG_MASK) | (((uint32_t)val) << UART2_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: UART3 Registers (UART3)
//
//====================================================================

//====================================================================
//Register: Receive Buffer Register (UART_RBR)
/** \brief In non-FIFO mode, this register holds the character(s) received by the UART
Receive Shift Register. If this register is configured to use fewer than eight
bits, the bits are right-justified and the most significant bits (MSbs) are
zeroed. Reading the register empties the register and clears the <Data
Ready> field in the Line Status Register.
This register latches the value of the data byte at the front of the FIFO in
FIFO mode.*/
//====================================================================

#define  UART3_UART_RBR_BYTE_3_MASK 0xff000000
#define  UART3_UART_RBR_BYTE_3_SHIFT 24
#define  UART3_UART_RBR_BYTE_3_MASK_SHIFT(reg) (((reg) & UART3_UART_RBR_BYTE_3_MASK) >> UART3_UART_RBR_BYTE_3_SHIFT)
#define  UART3_UART_RBR_BYTE_3_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_RBR_BYTE_3_MASK) | (((uint32_t)val) << UART3_UART_RBR_BYTE_3_SHIFT))

#define  UART3_UART_RBR_BYTE_2_MASK 0xff0000
#define  UART3_UART_RBR_BYTE_2_SHIFT 16
#define  UART3_UART_RBR_BYTE_2_MASK_SHIFT(reg) (((reg) & UART3_UART_RBR_BYTE_2_MASK) >> UART3_UART_RBR_BYTE_2_SHIFT)
#define  UART3_UART_RBR_BYTE_2_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_RBR_BYTE_2_MASK) | (((uint32_t)val) << UART3_UART_RBR_BYTE_2_SHIFT))

#define  UART3_UART_RBR_BYTE_1_MASK 0xff00
#define  UART3_UART_RBR_BYTE_1_SHIFT 8
#define  UART3_UART_RBR_BYTE_1_MASK_SHIFT(reg) (((reg) & UART3_UART_RBR_BYTE_1_MASK) >> UART3_UART_RBR_BYTE_1_SHIFT)
#define  UART3_UART_RBR_BYTE_1_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_RBR_BYTE_1_MASK) | (((uint32_t)val) << UART3_UART_RBR_BYTE_1_SHIFT))

#define  UART3_UART_RBR_BYTE_0_MASK 0xff
#define  UART3_UART_RBR_BYTE_0_SHIFT 0
#define  UART3_UART_RBR_BYTE_0_MASK_SHIFT(reg) (((reg) & UART3_UART_RBR_BYTE_0_MASK) >> UART3_UART_RBR_BYTE_0_SHIFT)
#define  UART3_UART_RBR_BYTE_0_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_RBR_BYTE_0_MASK) | (((uint32_t)val) << UART3_UART_RBR_BYTE_0_SHIFT))

//====================================================================
//Register: Transmit Holding Register (UART_THR)
/** \brief This register holds the data byte(s) to be transmitted next in non-FIFO mode.
When the Transmit Shift Register is emptied, the contents of this register are
loaded into the Transmit Shift Register and the <Transmit Data Request> field in
the Line Status Register is set.
A write to Transmit Holding Register puts data into the top of the FIFO in FIFO
mode. The data at the front of the FIFO is loaded into the Transmit Shift
Register when the Transmit Shift Register is empty.*/
//====================================================================

#define  UART3_UART_THR_BYTE_3_MASK 0xff000000
#define  UART3_UART_THR_BYTE_3_SHIFT 24
#define  UART3_UART_THR_BYTE_3_MASK_SHIFT(reg) (((reg) & UART3_UART_THR_BYTE_3_MASK) >> UART3_UART_THR_BYTE_3_SHIFT)
#define  UART3_UART_THR_BYTE_3_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_THR_BYTE_3_MASK) | (((uint32_t)val) << UART3_UART_THR_BYTE_3_SHIFT))

#define  UART3_UART_THR_BYTE_2_MASK 0xff0000
#define  UART3_UART_THR_BYTE_2_SHIFT 16
#define  UART3_UART_THR_BYTE_2_MASK_SHIFT(reg) (((reg) & UART3_UART_THR_BYTE_2_MASK) >> UART3_UART_THR_BYTE_2_SHIFT)
#define  UART3_UART_THR_BYTE_2_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_THR_BYTE_2_MASK) | (((uint32_t)val) << UART3_UART_THR_BYTE_2_SHIFT))

#define  UART3_UART_THR_BYTE_1_MASK 0xff00
#define  UART3_UART_THR_BYTE_1_SHIFT 8
#define  UART3_UART_THR_BYTE_1_MASK_SHIFT(reg) (((reg) & UART3_UART_THR_BYTE_1_MASK) >> UART3_UART_THR_BYTE_1_SHIFT)
#define  UART3_UART_THR_BYTE_1_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_THR_BYTE_1_MASK) | (((uint32_t)val) << UART3_UART_THR_BYTE_1_SHIFT))

#define  UART3_UART_THR_BYTE_0_MASK 0xff
#define  UART3_UART_THR_BYTE_0_SHIFT 0
#define  UART3_UART_THR_BYTE_0_MASK_SHIFT(reg) (((reg) & UART3_UART_THR_BYTE_0_MASK) >> UART3_UART_THR_BYTE_0_SHIFT)
#define  UART3_UART_THR_BYTE_0_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_THR_BYTE_0_MASK) | (((uint32_t)val) << UART3_UART_THR_BYTE_0_SHIFT))

//====================================================================
//Register: Divisor Latch Low Byte Register (UART_DLL)
//====================================================================

#define  UART3_UART_DLL_RESERVED1_MASK 0xffffff00
#define  UART3_UART_DLL_RESERVED1_SHIFT 8
#define  UART3_UART_DLL_RESERVED1_MASK_SHIFT(reg) (((reg) & UART3_UART_DLL_RESERVED1_MASK) >> UART3_UART_DLL_RESERVED1_SHIFT)
#define  UART3_UART_DLL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_DLL_RESERVED1_MASK) | (((uint32_t)val) << UART3_UART_DLL_RESERVED1_SHIFT))

#define  UART3_UART_DLL_DLL_MASK 0xff
#define  UART3_UART_DLL_DLL_SHIFT 0
#define  UART3_UART_DLL_DLL_MASK_SHIFT(reg) (((reg) & UART3_UART_DLL_DLL_MASK) >> UART3_UART_DLL_DLL_SHIFT)
#define  UART3_UART_DLL_DLL_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_DLL_DLL_MASK) | (((uint32_t)val) << UART3_UART_DLL_DLL_SHIFT))

//====================================================================
//Register: Interrupt Enable Register (UART_IER)
/** \brief This register enables the five types of interrupts that set a value in the
Interrupt Identification Register. Software must clear the appropriate bit in
this register to disable an interrupt. Software can enable some interrupts by
setting the appropriate bit.
The character timeout-indication interrupt is separated from the received
data-available interrupt to ensure that the PXA2128 Application Processor and
the DMA controller do not service the receive FIFO at the same time. When
a character-timeout-indication interrupt occurs, the PXA2128 Application
Processor must handle the data in the receive FIFO through programmed I/O.
An error interrupt is used when DMA requests are enabled. The interrupt is
generated when the <FIFO Error Status> field in the Line Status Register is set
because a receive DMA request is not generated when the receive FIFO has an
error. The error interrupt tells the PXA2128 Application Processor to handle the
data in the receive FIFO through programmed I/O. The error interrupt is enabled
when DMA requests are enabled, and it cannot be masked. Receiver line-status
interrupts occur when the error is at the front of the FIFO.
Note: When DMA requests are enabled and an interrupt occurs, software must first
read the Line Status Register to see if an error interrupt exists, then check
the Interrupt Identification Register for the source of the interrupt. Software
must read the Infrared Selected Register to determine the error condition if an
interrupt occurs and the <FIFO Error Status> field in the Line Status Register
is clear. DMA requests are automatically enabled when the last error byte is
read from the FIFO. Software is not required to check for the error interrupt if
DMA requests are disabled because an error interrupt occurs only when DMA
requests are enabled.
The <FIFO Error Status> field is used to enable DMA requests. This register also
contains the unit enable and NRZ coding enable control bits. Bits 7 through 4
are used differently from the standard 16550A register definition.
Note: Software must not set the <DMA Requests Enable> field while the <Transmit
Data Request Interrupt Enable> or <Receiver Data Available Interrupt
Enable> fields are set to ensure that the DMA controller and programmed I/O do
not access the same FIFO.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART3_UART_IER_RESERVED1_MASK 0xfffffe00
#define  UART3_UART_IER_RESERVED1_SHIFT 9
#define  UART3_UART_IER_RESERVED1_MASK_SHIFT(reg) (((reg) & UART3_UART_IER_RESERVED1_MASK) >> UART3_UART_IER_RESERVED1_SHIFT)
#define  UART3_UART_IER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_IER_RESERVED1_MASK) | (((uint32_t)val) << UART3_UART_IER_RESERVED1_SHIFT))

#define  UART3_UART_IER_FAST_MASK 0x100
#define  UART3_UART_IER_FAST_SHIFT 8
#define  UART3_UART_IER_FAST_MASK_SHIFT(reg) (((reg) & UART3_UART_IER_FAST_MASK) >> UART3_UART_IER_FAST_SHIFT)
#define  UART3_UART_IER_FAST_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_IER_FAST_MASK) | (((uint32_t)val) << UART3_UART_IER_FAST_SHIFT))

#define  UART3_UART_IER_DMAE_MASK 0x80
#define  UART3_UART_IER_DMAE_SHIFT 7
#define  UART3_UART_IER_DMAE_MASK_SHIFT(reg) (((reg) & UART3_UART_IER_DMAE_MASK) >> UART3_UART_IER_DMAE_SHIFT)
#define  UART3_UART_IER_DMAE_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_IER_DMAE_MASK) | (((uint32_t)val) << UART3_UART_IER_DMAE_SHIFT))

#define  UART3_UART_IER_UUE_MASK 0x40
#define  UART3_UART_IER_UUE_SHIFT 6
#define  UART3_UART_IER_UUE_MASK_SHIFT(reg) (((reg) & UART3_UART_IER_UUE_MASK) >> UART3_UART_IER_UUE_SHIFT)
#define  UART3_UART_IER_UUE_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_IER_UUE_MASK) | (((uint32_t)val) << UART3_UART_IER_UUE_SHIFT))

#define  UART3_UART_IER_NRZE_MASK 0x20
#define  UART3_UART_IER_NRZE_SHIFT 5
#define  UART3_UART_IER_NRZE_MASK_SHIFT(reg) (((reg) & UART3_UART_IER_NRZE_MASK) >> UART3_UART_IER_NRZE_SHIFT)
#define  UART3_UART_IER_NRZE_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_IER_NRZE_MASK) | (((uint32_t)val) << UART3_UART_IER_NRZE_SHIFT))

#define  UART3_UART_IER_RTOIE_MASK 0x10
#define  UART3_UART_IER_RTOIE_SHIFT 4
#define  UART3_UART_IER_RTOIE_MASK_SHIFT(reg) (((reg) & UART3_UART_IER_RTOIE_MASK) >> UART3_UART_IER_RTOIE_SHIFT)
#define  UART3_UART_IER_RTOIE_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_IER_RTOIE_MASK) | (((uint32_t)val) << UART3_UART_IER_RTOIE_SHIFT))

#define  UART3_UART_IER_MIE_MASK 0x8
#define  UART3_UART_IER_MIE_SHIFT 3
#define  UART3_UART_IER_MIE_MASK_SHIFT(reg) (((reg) & UART3_UART_IER_MIE_MASK) >> UART3_UART_IER_MIE_SHIFT)
#define  UART3_UART_IER_MIE_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_IER_MIE_MASK) | (((uint32_t)val) << UART3_UART_IER_MIE_SHIFT))

#define  UART3_UART_IER_RLSE_MASK 0x4
#define  UART3_UART_IER_RLSE_SHIFT 2
#define  UART3_UART_IER_RLSE_MASK_SHIFT(reg) (((reg) & UART3_UART_IER_RLSE_MASK) >> UART3_UART_IER_RLSE_SHIFT)
#define  UART3_UART_IER_RLSE_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_IER_RLSE_MASK) | (((uint32_t)val) << UART3_UART_IER_RLSE_SHIFT))

#define  UART3_UART_IER_TIE_MASK 0x2
#define  UART3_UART_IER_TIE_SHIFT 1
#define  UART3_UART_IER_TIE_MASK_SHIFT(reg) (((reg) & UART3_UART_IER_TIE_MASK) >> UART3_UART_IER_TIE_SHIFT)
#define  UART3_UART_IER_TIE_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_IER_TIE_MASK) | (((uint32_t)val) << UART3_UART_IER_TIE_SHIFT))

#define  UART3_UART_IER_RAVIE_MASK 0x1
#define  UART3_UART_IER_RAVIE_SHIFT 0
#define  UART3_UART_IER_RAVIE_MASK_SHIFT(reg) (((reg) & UART3_UART_IER_RAVIE_MASK) >> UART3_UART_IER_RAVIE_SHIFT)
#define  UART3_UART_IER_RAVIE_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_IER_RAVIE_MASK) | (((uint32_t)val) << UART3_UART_IER_RAVIE_SHIFT))

//====================================================================
//Register: Divisor Latch High Byte Register (UART_DLH)
//====================================================================

#define  UART3_UART_DLH_RESERVED1_MASK 0xffffff00
#define  UART3_UART_DLH_RESERVED1_SHIFT 8
#define  UART3_UART_DLH_RESERVED1_MASK_SHIFT(reg) (((reg) & UART3_UART_DLH_RESERVED1_MASK) >> UART3_UART_DLH_RESERVED1_SHIFT)
#define  UART3_UART_DLH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_DLH_RESERVED1_MASK) | (((uint32_t)val) << UART3_UART_DLH_RESERVED1_SHIFT))

#define  UART3_UART_DLH_DLH_MASK 0xff
#define  UART3_UART_DLH_DLH_SHIFT 0
#define  UART3_UART_DLH_DLH_MASK_SHIFT(reg) (((reg) & UART3_UART_DLH_DLH_MASK) >> UART3_UART_DLH_DLH_SHIFT)
#define  UART3_UART_DLH_DLH_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_DLH_DLH_MASK) | (((uint32_t)val) << UART3_UART_DLH_DLH_SHIFT))

//====================================================================
//Register: Interrupt Identification Register (UART_IIR)
//====================================================================

#define  UART3_UART_IIR_RESERVED1_MASK 0xffffff00
#define  UART3_UART_IIR_RESERVED1_SHIFT 8
#define  UART3_UART_IIR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART3_UART_IIR_RESERVED1_MASK) >> UART3_UART_IIR_RESERVED1_SHIFT)
#define  UART3_UART_IIR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_IIR_RESERVED1_MASK) | (((uint32_t)val) << UART3_UART_IIR_RESERVED1_SHIFT))

#define  UART3_UART_IIR_FIFOES10_MASK 0xc0
#define  UART3_UART_IIR_FIFOES10_SHIFT 6
#define  UART3_UART_IIR_FIFOES10_MASK_SHIFT(reg) (((reg) & UART3_UART_IIR_FIFOES10_MASK) >> UART3_UART_IIR_FIFOES10_SHIFT)
#define  UART3_UART_IIR_FIFOES10_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_IIR_FIFOES10_MASK) | (((uint32_t)val) << UART3_UART_IIR_FIFOES10_SHIFT))

#define  UART3_UART_IIR_EOC_MASK 0x20
#define  UART3_UART_IIR_EOC_SHIFT 5
#define  UART3_UART_IIR_EOC_MASK_SHIFT(reg) (((reg) & UART3_UART_IIR_EOC_MASK) >> UART3_UART_IIR_EOC_SHIFT)
#define  UART3_UART_IIR_EOC_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_IIR_EOC_MASK) | (((uint32_t)val) << UART3_UART_IIR_EOC_SHIFT))

#define  UART3_UART_IIR_ABL_MASK 0x10
#define  UART3_UART_IIR_ABL_SHIFT 4
#define  UART3_UART_IIR_ABL_MASK_SHIFT(reg) (((reg) & UART3_UART_IIR_ABL_MASK) >> UART3_UART_IIR_ABL_SHIFT)
#define  UART3_UART_IIR_ABL_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_IIR_ABL_MASK) | (((uint32_t)val) << UART3_UART_IIR_ABL_SHIFT))

#define  UART3_UART_IIR_TOD_MASK 0x8
#define  UART3_UART_IIR_TOD_SHIFT 3
#define  UART3_UART_IIR_TOD_MASK_SHIFT(reg) (((reg) & UART3_UART_IIR_TOD_MASK) >> UART3_UART_IIR_TOD_SHIFT)
#define  UART3_UART_IIR_TOD_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_IIR_TOD_MASK) | (((uint32_t)val) << UART3_UART_IIR_TOD_SHIFT))

#define  UART3_UART_IIR_IID10_MASK 0x6
#define  UART3_UART_IIR_IID10_SHIFT 1
#define  UART3_UART_IIR_IID10_MASK_SHIFT(reg) (((reg) & UART3_UART_IIR_IID10_MASK) >> UART3_UART_IIR_IID10_SHIFT)
#define  UART3_UART_IIR_IID10_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_IIR_IID10_MASK) | (((uint32_t)val) << UART3_UART_IIR_IID10_SHIFT))

#define  UART3_UART_IIR_NIP_MASK 0x1
#define  UART3_UART_IIR_NIP_SHIFT 0
#define  UART3_UART_IIR_NIP_MASK_SHIFT(reg) (((reg) & UART3_UART_IIR_NIP_MASK) >> UART3_UART_IIR_NIP_SHIFT)
#define  UART3_UART_IIR_NIP_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_IIR_NIP_MASK) | (((uint32_t)val) << UART3_UART_IIR_NIP_SHIFT))

//====================================================================
//Register: FIFO Control Register (UART_FCR)
/** \brief This is a write-only register that is located at the same address as the
Interrupt Identification Register, which is a read-only register. This register
enables/disables the transmit/receive FIFOs, clears the transmit/receive FIFOs,
and sets the receive FIFO trigger threshold.
Note: The trigger level must be equal to the DMA burst length programmed in the
DMA registers.
Interrupt Trigger Level - When the number of bytes in the receive FIFO equals
the interrupt trigger level programmed into this field and the
received-data-available interrupt is enabled (via the Interrupt Enable
Register), an interrupt is generated and the appropriate bits are set in the
Interrupt Identification Register. The receive DMA request is generated as well
when trigger level is reached. The trigger level must be greater than or equal
to the DMA burst size programmed in the DMA registers.
32-Bit Peripheral Bus - When clear, the UART ignores any information in the
upper three bytes of the 32-bit bus. A full- or partial-word read or write to
the UART with this field clear increments the FIFO counters by only one byte. If
this field is set, a full- or partial-word read or write increments the counter
by the number of valid bytes within the word.
Trailing Bytes - When clear, trailing bytes are handled by the PXA2128
Application Processor. When set, trailing bytes are handled automatically by the
DMA controller. See the DMA section for more information.
Transmit Interrupt Level - Setting this field causes transmitter interrupts and
DMA requests to occur when the transmit FIFO is empty. Clearing this field
causes transmitter interrupts and DMA requests to occur when the transmit FIFO
is half empty.
Reset Transmit FIFO - When this field is set, the transmit FIFO counter is reset
to clear all the bytes in the FIFO. The <Transmit Data Request> field in the
Line Status Register is set, generating a transmitter-requests-data interrupt
(<Interrupt Source Encoded> field in the Interrupt Identification Register) if
the <Transmit Data Request Interrupt Enable> field in the Interrupt Enable
Register is set. The Transmit Shift Register is not reset, it completes the
current transmission. Any DMA or transmit-FIFO-service-request interrupts are
cleared.
Note: The <Reset Transmit FIFO> field is reset to 0 automatically after the FIFO
is cleared.
Reset Receive FIFO - When this field is set, the receive FIFO counter is reset
to clear all the bytes in the FIFO. The <Data Ready> field in the Line Status
Register is cleared. All error bits in the FIFO and the <FIFO Error
Status> field in the Line Status Register are cleared. Any error bits (OE, PE,
FE, or BI) that had been set in the Line Status Register remain set. The Receive
Shift Register is not cleared. Any DMA or receive-FIFO-service-request
interrupts are cleared.
Note: The <Reset Receive FIFO> field is reset automatically to 0 after the FIFO
is cleared.
Transmit and Receive FIFO Enable - This field enables and disables the transmit
and receive FIFOs. When it is set, both FIFOs are enabled (FIFO mode). When it
is clear, the FIFOs are both disabled (non-FIFO mode). Writing 0x0 to this bit
clears all bytes in both FIFOs. When changing from FIFO mode to non-FIFO mode
and vice versa, data is cleared automatically from the FIFOs. Any DMA or
FIFO-service-request interrupts are cleared when this field is clear.
Note: This field must be 1 when other fields in this register are written, or
the other fields are not programmed.
This is a write-only register. Write 0x0 to reserved bits.*/
//====================================================================

#define  UART3_UART_FCR_RESERVED1_MASK 0xffffff00
#define  UART3_UART_FCR_RESERVED1_SHIFT 8
#define  UART3_UART_FCR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART3_UART_FCR_RESERVED1_MASK) >> UART3_UART_FCR_RESERVED1_SHIFT)
#define  UART3_UART_FCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_FCR_RESERVED1_MASK) | (((uint32_t)val) << UART3_UART_FCR_RESERVED1_SHIFT))

#define  UART3_UART_FCR_ITL_MASK 0xc0
#define  UART3_UART_FCR_ITL_SHIFT 6
#define  UART3_UART_FCR_ITL_MASK_SHIFT(reg) (((reg) & UART3_UART_FCR_ITL_MASK) >> UART3_UART_FCR_ITL_SHIFT)
#define  UART3_UART_FCR_ITL_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_FCR_ITL_MASK) | (((uint32_t)val) << UART3_UART_FCR_ITL_SHIFT))

#define  UART3_UART_FCR_BUS_MASK 0x20
#define  UART3_UART_FCR_BUS_SHIFT 5
#define  UART3_UART_FCR_BUS_MASK_SHIFT(reg) (((reg) & UART3_UART_FCR_BUS_MASK) >> UART3_UART_FCR_BUS_SHIFT)
#define  UART3_UART_FCR_BUS_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_FCR_BUS_MASK) | (((uint32_t)val) << UART3_UART_FCR_BUS_SHIFT))

#define  UART3_UART_FCR_TRAIL_MASK 0x10
#define  UART3_UART_FCR_TRAIL_SHIFT 4
#define  UART3_UART_FCR_TRAIL_MASK_SHIFT(reg) (((reg) & UART3_UART_FCR_TRAIL_MASK) >> UART3_UART_FCR_TRAIL_SHIFT)
#define  UART3_UART_FCR_TRAIL_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_FCR_TRAIL_MASK) | (((uint32_t)val) << UART3_UART_FCR_TRAIL_SHIFT))

#define  UART3_UART_FCR_TIL_MASK 0x8
#define  UART3_UART_FCR_TIL_SHIFT 3
#define  UART3_UART_FCR_TIL_MASK_SHIFT(reg) (((reg) & UART3_UART_FCR_TIL_MASK) >> UART3_UART_FCR_TIL_SHIFT)
#define  UART3_UART_FCR_TIL_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_FCR_TIL_MASK) | (((uint32_t)val) << UART3_UART_FCR_TIL_SHIFT))

#define  UART3_UART_FCR_RESETTF_MASK 0x4
#define  UART3_UART_FCR_RESETTF_SHIFT 2
#define  UART3_UART_FCR_RESETTF_MASK_SHIFT(reg) (((reg) & UART3_UART_FCR_RESETTF_MASK) >> UART3_UART_FCR_RESETTF_SHIFT)
#define  UART3_UART_FCR_RESETTF_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_FCR_RESETTF_MASK) | (((uint32_t)val) << UART3_UART_FCR_RESETTF_SHIFT))

#define  UART3_UART_FCR_RESETRF_MASK 0x2
#define  UART3_UART_FCR_RESETRF_SHIFT 1
#define  UART3_UART_FCR_RESETRF_MASK_SHIFT(reg) (((reg) & UART3_UART_FCR_RESETRF_MASK) >> UART3_UART_FCR_RESETRF_SHIFT)
#define  UART3_UART_FCR_RESETRF_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_FCR_RESETRF_MASK) | (((uint32_t)val) << UART3_UART_FCR_RESETRF_SHIFT))

#define  UART3_UART_FCR_TRFIFOE_MASK 0x1
#define  UART3_UART_FCR_TRFIFOE_SHIFT 0
#define  UART3_UART_FCR_TRFIFOE_MASK_SHIFT(reg) (((reg) & UART3_UART_FCR_TRFIFOE_MASK) >> UART3_UART_FCR_TRFIFOE_SHIFT)
#define  UART3_UART_FCR_TRFIFOE_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_FCR_TRFIFOE_MASK) | (((uint32_t)val) << UART3_UART_FCR_TRFIFOE_SHIFT))

//====================================================================
//Register: Line Control Register (UART_LCR)
/** \brief This register specifies the format for the asynchronous data-communications
exchange. The serial-data format consists of a start bit, 8 data bits, an
optional parity bit, and 1 stop bit. This register has bits that allow access to
the Divisor Latch registers and bits that can cause a break condition.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART3_UART_LCR_RESERVED1_MASK 0xffffff00
#define  UART3_UART_LCR_RESERVED1_SHIFT 8
#define  UART3_UART_LCR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART3_UART_LCR_RESERVED1_MASK) >> UART3_UART_LCR_RESERVED1_SHIFT)
#define  UART3_UART_LCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_LCR_RESERVED1_MASK) | (((uint32_t)val) << UART3_UART_LCR_RESERVED1_SHIFT))

#define  UART3_UART_LCR_DLAB_MASK 0x80
#define  UART3_UART_LCR_DLAB_SHIFT 7
#define  UART3_UART_LCR_DLAB_MASK_SHIFT(reg) (((reg) & UART3_UART_LCR_DLAB_MASK) >> UART3_UART_LCR_DLAB_SHIFT)
#define  UART3_UART_LCR_DLAB_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_LCR_DLAB_MASK) | (((uint32_t)val) << UART3_UART_LCR_DLAB_SHIFT))

#define  UART3_UART_LCR_SB_MASK 0x40
#define  UART3_UART_LCR_SB_SHIFT 6
#define  UART3_UART_LCR_SB_MASK_SHIFT(reg) (((reg) & UART3_UART_LCR_SB_MASK) >> UART3_UART_LCR_SB_SHIFT)
#define  UART3_UART_LCR_SB_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_LCR_SB_MASK) | (((uint32_t)val) << UART3_UART_LCR_SB_SHIFT))

#define  UART3_UART_LCR_STKYP_MASK 0x20
#define  UART3_UART_LCR_STKYP_SHIFT 5
#define  UART3_UART_LCR_STKYP_MASK_SHIFT(reg) (((reg) & UART3_UART_LCR_STKYP_MASK) >> UART3_UART_LCR_STKYP_SHIFT)
#define  UART3_UART_LCR_STKYP_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_LCR_STKYP_MASK) | (((uint32_t)val) << UART3_UART_LCR_STKYP_SHIFT))

#define  UART3_UART_LCR_EPS_MASK 0x10
#define  UART3_UART_LCR_EPS_SHIFT 4
#define  UART3_UART_LCR_EPS_MASK_SHIFT(reg) (((reg) & UART3_UART_LCR_EPS_MASK) >> UART3_UART_LCR_EPS_SHIFT)
#define  UART3_UART_LCR_EPS_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_LCR_EPS_MASK) | (((uint32_t)val) << UART3_UART_LCR_EPS_SHIFT))

#define  UART3_UART_LCR_PEN_MASK 0x8
#define  UART3_UART_LCR_PEN_SHIFT 3
#define  UART3_UART_LCR_PEN_MASK_SHIFT(reg) (((reg) & UART3_UART_LCR_PEN_MASK) >> UART3_UART_LCR_PEN_SHIFT)
#define  UART3_UART_LCR_PEN_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_LCR_PEN_MASK) | (((uint32_t)val) << UART3_UART_LCR_PEN_SHIFT))

#define  UART3_UART_LCR_STB_MASK 0x4
#define  UART3_UART_LCR_STB_SHIFT 2
#define  UART3_UART_LCR_STB_MASK_SHIFT(reg) (((reg) & UART3_UART_LCR_STB_MASK) >> UART3_UART_LCR_STB_SHIFT)
#define  UART3_UART_LCR_STB_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_LCR_STB_MASK) | (((uint32_t)val) << UART3_UART_LCR_STB_SHIFT))

#define  UART3_UART_LCR_WLS10_MASK 0x3
#define  UART3_UART_LCR_WLS10_SHIFT 0
#define  UART3_UART_LCR_WLS10_MASK_SHIFT(reg) (((reg) & UART3_UART_LCR_WLS10_MASK) >> UART3_UART_LCR_WLS10_SHIFT)
#define  UART3_UART_LCR_WLS10_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_LCR_WLS10_MASK) | (((uint32_t)val) << UART3_UART_LCR_WLS10_SHIFT))

//====================================================================
//Register: Modem Control Register (UART_MCR)
/** \brief This register uses the modem control pins RTSn and DTRn to control the interface
with a modem or data set. This register also controls the loopback mode.
Loopback mode must be enabled before the UART is enabled.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART3_UART_MCR_RESERVED1_MASK 0xffffffc0
#define  UART3_UART_MCR_RESERVED1_SHIFT 6
#define  UART3_UART_MCR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART3_UART_MCR_RESERVED1_MASK) >> UART3_UART_MCR_RESERVED1_SHIFT)
#define  UART3_UART_MCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_MCR_RESERVED1_MASK) | (((uint32_t)val) << UART3_UART_MCR_RESERVED1_SHIFT))

#define  UART3_UART_MCR_AFE_MASK 0x20
#define  UART3_UART_MCR_AFE_SHIFT 5
#define  UART3_UART_MCR_AFE_MASK_SHIFT(reg) (((reg) & UART3_UART_MCR_AFE_MASK) >> UART3_UART_MCR_AFE_SHIFT)
#define  UART3_UART_MCR_AFE_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_MCR_AFE_MASK) | (((uint32_t)val) << UART3_UART_MCR_AFE_SHIFT))

#define  UART3_UART_MCR_LOOP_MASK 0x10
#define  UART3_UART_MCR_LOOP_SHIFT 4
#define  UART3_UART_MCR_LOOP_MASK_SHIFT(reg) (((reg) & UART3_UART_MCR_LOOP_MASK) >> UART3_UART_MCR_LOOP_SHIFT)
#define  UART3_UART_MCR_LOOP_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_MCR_LOOP_MASK) | (((uint32_t)val) << UART3_UART_MCR_LOOP_SHIFT))

#define  UART3_UART_MCR_OUT2_MASK 0x8
#define  UART3_UART_MCR_OUT2_SHIFT 3
#define  UART3_UART_MCR_OUT2_MASK_SHIFT(reg) (((reg) & UART3_UART_MCR_OUT2_MASK) >> UART3_UART_MCR_OUT2_SHIFT)
#define  UART3_UART_MCR_OUT2_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_MCR_OUT2_MASK) | (((uint32_t)val) << UART3_UART_MCR_OUT2_SHIFT))

#define  UART3_UART_MCR_OUT1_MASK 0x4
#define  UART3_UART_MCR_OUT1_SHIFT 2
#define  UART3_UART_MCR_OUT1_MASK_SHIFT(reg) (((reg) & UART3_UART_MCR_OUT1_MASK) >> UART3_UART_MCR_OUT1_SHIFT)
#define  UART3_UART_MCR_OUT1_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_MCR_OUT1_MASK) | (((uint32_t)val) << UART3_UART_MCR_OUT1_SHIFT))

#define  UART3_UART_MCR_RTS_MASK 0x2
#define  UART3_UART_MCR_RTS_SHIFT 1
#define  UART3_UART_MCR_RTS_MASK_SHIFT(reg) (((reg) & UART3_UART_MCR_RTS_MASK) >> UART3_UART_MCR_RTS_SHIFT)
#define  UART3_UART_MCR_RTS_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_MCR_RTS_MASK) | (((uint32_t)val) << UART3_UART_MCR_RTS_SHIFT))

#define  UART3_UART_MCR_DTR_MASK 0x1
#define  UART3_UART_MCR_DTR_SHIFT 0
#define  UART3_UART_MCR_DTR_MASK_SHIFT(reg) (((reg) & UART3_UART_MCR_DTR_MASK) >> UART3_UART_MCR_DTR_SHIFT)
#define  UART3_UART_MCR_DTR_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_MCR_DTR_MASK) | (((uint32_t)val) << UART3_UART_MCR_DTR_SHIFT))

//====================================================================
//Register: Line Status Register (UART_LSR)
/** \brief This register provides data-transfer status information to the PXA2128
Application Processor. In non-FIFO mode, bits [4:2] show the error status of the
character that has just been received. In FIFO mode, bits [4:2] show the status
bits of the character that is currently at the front of the FIFO.
Bits [4:1] produce a receiver-line-status interrupt when the corresponding
conditions are detected and the interrupt is enabled. In FIFO mode, the
receiver-line-status interrupt occurs only when the erroneous character reaches
the front of the FIFO. If the erroneous character is not at the front of the
FIFO, a line-status interrupt is generated after the other characters are read,
and the erroneous character becomes the character at the front of the FIFO.
This register must be read before the erroneous character is read. Bits [4:1]
remain set until software reads this register.
See FIFO DMA Mode Operation section in the PXA2128 Application Processor
Datasheet for details on using the DMAC to receive data.
This is a read-only register. Ignore reads from reserved bits.*/
//====================================================================

#define  UART3_UART_LSR_RESERVED1_MASK 0xffffff00
#define  UART3_UART_LSR_RESERVED1_SHIFT 8
#define  UART3_UART_LSR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART3_UART_LSR_RESERVED1_MASK) >> UART3_UART_LSR_RESERVED1_SHIFT)
#define  UART3_UART_LSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_LSR_RESERVED1_MASK) | (((uint32_t)val) << UART3_UART_LSR_RESERVED1_SHIFT))

#define  UART3_UART_LSR_FIFOE_MASK 0x80
#define  UART3_UART_LSR_FIFOE_SHIFT 7
#define  UART3_UART_LSR_FIFOE_MASK_SHIFT(reg) (((reg) & UART3_UART_LSR_FIFOE_MASK) >> UART3_UART_LSR_FIFOE_SHIFT)
#define  UART3_UART_LSR_FIFOE_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_LSR_FIFOE_MASK) | (((uint32_t)val) << UART3_UART_LSR_FIFOE_SHIFT))

#define  UART3_UART_LSR_TEMT_MASK 0x40
#define  UART3_UART_LSR_TEMT_SHIFT 6
#define  UART3_UART_LSR_TEMT_MASK_SHIFT(reg) (((reg) & UART3_UART_LSR_TEMT_MASK) >> UART3_UART_LSR_TEMT_SHIFT)
#define  UART3_UART_LSR_TEMT_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_LSR_TEMT_MASK) | (((uint32_t)val) << UART3_UART_LSR_TEMT_SHIFT))

#define  UART3_UART_LSR_TDRQ_MASK 0x20
#define  UART3_UART_LSR_TDRQ_SHIFT 5
#define  UART3_UART_LSR_TDRQ_MASK_SHIFT(reg) (((reg) & UART3_UART_LSR_TDRQ_MASK) >> UART3_UART_LSR_TDRQ_SHIFT)
#define  UART3_UART_LSR_TDRQ_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_LSR_TDRQ_MASK) | (((uint32_t)val) << UART3_UART_LSR_TDRQ_SHIFT))

#define  UART3_UART_LSR_BI_MASK 0x10
#define  UART3_UART_LSR_BI_SHIFT 4
#define  UART3_UART_LSR_BI_MASK_SHIFT(reg) (((reg) & UART3_UART_LSR_BI_MASK) >> UART3_UART_LSR_BI_SHIFT)
#define  UART3_UART_LSR_BI_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_LSR_BI_MASK) | (((uint32_t)val) << UART3_UART_LSR_BI_SHIFT))

#define  UART3_UART_LSR_FE_MASK 0x8
#define  UART3_UART_LSR_FE_SHIFT 3
#define  UART3_UART_LSR_FE_MASK_SHIFT(reg) (((reg) & UART3_UART_LSR_FE_MASK) >> UART3_UART_LSR_FE_SHIFT)
#define  UART3_UART_LSR_FE_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_LSR_FE_MASK) | (((uint32_t)val) << UART3_UART_LSR_FE_SHIFT))

#define  UART3_UART_LSR_PE_MASK 0x4
#define  UART3_UART_LSR_PE_SHIFT 2
#define  UART3_UART_LSR_PE_MASK_SHIFT(reg) (((reg) & UART3_UART_LSR_PE_MASK) >> UART3_UART_LSR_PE_SHIFT)
#define  UART3_UART_LSR_PE_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_LSR_PE_MASK) | (((uint32_t)val) << UART3_UART_LSR_PE_SHIFT))

#define  UART3_UART_LSR_OE_MASK 0x2
#define  UART3_UART_LSR_OE_SHIFT 1
#define  UART3_UART_LSR_OE_MASK_SHIFT(reg) (((reg) & UART3_UART_LSR_OE_MASK) >> UART3_UART_LSR_OE_SHIFT)
#define  UART3_UART_LSR_OE_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_LSR_OE_MASK) | (((uint32_t)val) << UART3_UART_LSR_OE_SHIFT))

#define  UART3_UART_LSR_DR_MASK 0x1
#define  UART3_UART_LSR_DR_SHIFT 0
#define  UART3_UART_LSR_DR_MASK_SHIFT(reg) (((reg) & UART3_UART_LSR_DR_MASK) >> UART3_UART_LSR_DR_SHIFT)
#define  UART3_UART_LSR_DR_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_LSR_DR_MASK) | (((uint32_t)val) << UART3_UART_LSR_DR_SHIFT))

//====================================================================
//Register: Modem Status Register (UART_MSR)
/** \brief This register provides the current state of the control lines from the modem or
data set (or a peripheral device emulating a modem) to the PXA2128 Application
Processor. In addition to this current state information, four bits provide
change information. Bits [3:0] are set when a control input from the modem
changes state. They are cleared when the PXA2128 Application Processor reads
this register.
The status of the modem control lines does not affect the FIFOs. The <Modem
Interrupt Enable> field in the Interrupt Enable Register must be set to use
these lines for flow control. The interrupt service routine must disable the
UART when an interrupt occurs on one of the flow-control pins. The UART
continues transmission/reception of the current character and then stops. The
contents of the FIFOs are preserved. If the UART is re-enabled, transmission
continues where it stopped.
Note: When bit 0, 1, 2, or 3 is set, a modem-status interrupt is generated if
the <Modem Interrupt Enable> field is set.
This is a read-only register. Ignore reads from reserved bits.*/
//====================================================================

#define  UART3_UART_MSR_RESERVED1_MASK 0xffffff00
#define  UART3_UART_MSR_RESERVED1_SHIFT 8
#define  UART3_UART_MSR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART3_UART_MSR_RESERVED1_MASK) >> UART3_UART_MSR_RESERVED1_SHIFT)
#define  UART3_UART_MSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_MSR_RESERVED1_MASK) | (((uint32_t)val) << UART3_UART_MSR_RESERVED1_SHIFT))

#define  UART3_UART_MSR_DCD_MASK 0x80
#define  UART3_UART_MSR_DCD_SHIFT 7
#define  UART3_UART_MSR_DCD_MASK_SHIFT(reg) (((reg) & UART3_UART_MSR_DCD_MASK) >> UART3_UART_MSR_DCD_SHIFT)
#define  UART3_UART_MSR_DCD_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_MSR_DCD_MASK) | (((uint32_t)val) << UART3_UART_MSR_DCD_SHIFT))

#define  UART3_UART_MSR_RI_MASK 0x40
#define  UART3_UART_MSR_RI_SHIFT 6
#define  UART3_UART_MSR_RI_MASK_SHIFT(reg) (((reg) & UART3_UART_MSR_RI_MASK) >> UART3_UART_MSR_RI_SHIFT)
#define  UART3_UART_MSR_RI_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_MSR_RI_MASK) | (((uint32_t)val) << UART3_UART_MSR_RI_SHIFT))

#define  UART3_UART_MSR_DSR_MASK 0x20
#define  UART3_UART_MSR_DSR_SHIFT 5
#define  UART3_UART_MSR_DSR_MASK_SHIFT(reg) (((reg) & UART3_UART_MSR_DSR_MASK) >> UART3_UART_MSR_DSR_SHIFT)
#define  UART3_UART_MSR_DSR_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_MSR_DSR_MASK) | (((uint32_t)val) << UART3_UART_MSR_DSR_SHIFT))

#define  UART3_UART_MSR_CTS_MASK 0x10
#define  UART3_UART_MSR_CTS_SHIFT 4
#define  UART3_UART_MSR_CTS_MASK_SHIFT(reg) (((reg) & UART3_UART_MSR_CTS_MASK) >> UART3_UART_MSR_CTS_SHIFT)
#define  UART3_UART_MSR_CTS_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_MSR_CTS_MASK) | (((uint32_t)val) << UART3_UART_MSR_CTS_SHIFT))

#define  UART3_UART_MSR_DDCD_MASK 0x8
#define  UART3_UART_MSR_DDCD_SHIFT 3
#define  UART3_UART_MSR_DDCD_MASK_SHIFT(reg) (((reg) & UART3_UART_MSR_DDCD_MASK) >> UART3_UART_MSR_DDCD_SHIFT)
#define  UART3_UART_MSR_DDCD_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_MSR_DDCD_MASK) | (((uint32_t)val) << UART3_UART_MSR_DDCD_SHIFT))

#define  UART3_UART_MSR_TERI_MASK 0x4
#define  UART3_UART_MSR_TERI_SHIFT 2
#define  UART3_UART_MSR_TERI_MASK_SHIFT(reg) (((reg) & UART3_UART_MSR_TERI_MASK) >> UART3_UART_MSR_TERI_SHIFT)
#define  UART3_UART_MSR_TERI_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_MSR_TERI_MASK) | (((uint32_t)val) << UART3_UART_MSR_TERI_SHIFT))

#define  UART3_UART_MSR_DDSR_MASK 0x2
#define  UART3_UART_MSR_DDSR_SHIFT 1
#define  UART3_UART_MSR_DDSR_MASK_SHIFT(reg) (((reg) & UART3_UART_MSR_DDSR_MASK) >> UART3_UART_MSR_DDSR_SHIFT)
#define  UART3_UART_MSR_DDSR_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_MSR_DDSR_MASK) | (((uint32_t)val) << UART3_UART_MSR_DDSR_SHIFT))

#define  UART3_UART_MSR_DCTS_MASK 0x1
#define  UART3_UART_MSR_DCTS_SHIFT 0
#define  UART3_UART_MSR_DCTS_MASK_SHIFT(reg) (((reg) & UART3_UART_MSR_DCTS_MASK) >> UART3_UART_MSR_DCTS_SHIFT)
#define  UART3_UART_MSR_DCTS_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_MSR_DCTS_MASK) | (((uint32_t)val) << UART3_UART_MSR_DCTS_SHIFT))

//====================================================================
//Register: Scratchpad Register (UART_SCR)
/** \brief This register has no effect on the UART. It is intended as a scratchpad register
for use by programmers and is included for 16550A compatibility.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART3_UART_SCR_RESERVED1_MASK 0xffffff00
#define  UART3_UART_SCR_RESERVED1_SHIFT 8
#define  UART3_UART_SCR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART3_UART_SCR_RESERVED1_MASK) >> UART3_UART_SCR_RESERVED1_SHIFT)
#define  UART3_UART_SCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_SCR_RESERVED1_MASK) | (((uint32_t)val) << UART3_UART_SCR_RESERVED1_SHIFT))

#define  UART3_UART_SCR_SCRATCHPAD_MASK 0xff
#define  UART3_UART_SCR_SCRATCHPAD_SHIFT 0
#define  UART3_UART_SCR_SCRATCHPAD_MASK_SHIFT(reg) (((reg) & UART3_UART_SCR_SCRATCHPAD_MASK) >> UART3_UART_SCR_SCRATCHPAD_SHIFT)
#define  UART3_UART_SCR_SCRATCHPAD_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_SCR_SCRATCHPAD_MASK) | (((uint32_t)val) << UART3_UART_SCR_SCRATCHPAD_SHIFT))

//====================================================================
//Register: Infrared Selection Register (UART_ISR)
/** \brief Each UART can manage an IrDA module associated with it. This register controls
the IrDA functions (see Serial Infrared Asynchronous Interface in the PXA2128
Application Processor Datasheet).
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART3_UART_ISR_RESERVED1_MASK 0xffffffe0
#define  UART3_UART_ISR_RESERVED1_SHIFT 5
#define  UART3_UART_ISR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART3_UART_ISR_RESERVED1_MASK) >> UART3_UART_ISR_RESERVED1_SHIFT)
#define  UART3_UART_ISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_ISR_RESERVED1_MASK) | (((uint32_t)val) << UART3_UART_ISR_RESERVED1_SHIFT))

#define  UART3_UART_ISR_RXPL_MASK 0x10
#define  UART3_UART_ISR_RXPL_SHIFT 4
#define  UART3_UART_ISR_RXPL_MASK_SHIFT(reg) (((reg) & UART3_UART_ISR_RXPL_MASK) >> UART3_UART_ISR_RXPL_SHIFT)
#define  UART3_UART_ISR_RXPL_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_ISR_RXPL_MASK) | (((uint32_t)val) << UART3_UART_ISR_RXPL_SHIFT))

#define  UART3_UART_ISR_TXPL_MASK 0x8
#define  UART3_UART_ISR_TXPL_SHIFT 3
#define  UART3_UART_ISR_TXPL_MASK_SHIFT(reg) (((reg) & UART3_UART_ISR_TXPL_MASK) >> UART3_UART_ISR_TXPL_SHIFT)
#define  UART3_UART_ISR_TXPL_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_ISR_TXPL_MASK) | (((uint32_t)val) << UART3_UART_ISR_TXPL_SHIFT))

#define  UART3_UART_ISR_XMODE_MASK 0x4
#define  UART3_UART_ISR_XMODE_SHIFT 2
#define  UART3_UART_ISR_XMODE_MASK_SHIFT(reg) (((reg) & UART3_UART_ISR_XMODE_MASK) >> UART3_UART_ISR_XMODE_SHIFT)
#define  UART3_UART_ISR_XMODE_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_ISR_XMODE_MASK) | (((uint32_t)val) << UART3_UART_ISR_XMODE_SHIFT))

#define  UART3_UART_ISR_RCVEIR_MASK 0x2
#define  UART3_UART_ISR_RCVEIR_SHIFT 1
#define  UART3_UART_ISR_RCVEIR_MASK_SHIFT(reg) (((reg) & UART3_UART_ISR_RCVEIR_MASK) >> UART3_UART_ISR_RCVEIR_SHIFT)
#define  UART3_UART_ISR_RCVEIR_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_ISR_RCVEIR_MASK) | (((uint32_t)val) << UART3_UART_ISR_RCVEIR_SHIFT))

#define  UART3_UART_ISR_XMITIR_MASK 0x1
#define  UART3_UART_ISR_XMITIR_SHIFT 0
#define  UART3_UART_ISR_XMITIR_MASK_SHIFT(reg) (((reg) & UART3_UART_ISR_XMITIR_MASK) >> UART3_UART_ISR_XMITIR_SHIFT)
#define  UART3_UART_ISR_XMITIR_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_ISR_XMITIR_MASK) | (((uint32_t)val) << UART3_UART_ISR_XMITIR_SHIFT))

//====================================================================
//Register: Receive FIFO Occupancy Register (UART_FOR)
/** \brief This register shows the number of bytes currently remaining the receive FIFO.
This register can be used to determine the number of trailing bytes to remove in
the case when the DMA reaches the end of its descriptor chain or when
the <Trailing Bytes> field in the FIFO Control Register is clear, which
indicates that the PXA2128 Application Processor removes trailing bytes as
opposed to the DMA (see Removing Trailing Bytes in DMA Mode section in PXA2128
Application Processor Datasheet). This register is incremented once for each
byte of data written to the receive FIFO and decremented once for each byte
read.
This is a read/write register. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  UART3_UART_FOR_RESERVED1_MASK 0xffffffc0
#define  UART3_UART_FOR_RESERVED1_SHIFT 6
#define  UART3_UART_FOR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART3_UART_FOR_RESERVED1_MASK) >> UART3_UART_FOR_RESERVED1_SHIFT)
#define  UART3_UART_FOR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_FOR_RESERVED1_MASK) | (((uint32_t)val) << UART3_UART_FOR_RESERVED1_SHIFT))

#define  UART3_UART_FOR_BYTE_COUNT_MASK 0x3f
#define  UART3_UART_FOR_BYTE_COUNT_SHIFT 0
#define  UART3_UART_FOR_BYTE_COUNT_MASK_SHIFT(reg) (((reg) & UART3_UART_FOR_BYTE_COUNT_MASK) >> UART3_UART_FOR_BYTE_COUNT_SHIFT)
#define  UART3_UART_FOR_BYTE_COUNT_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_FOR_BYTE_COUNT_MASK) | (((uint32_t)val) << UART3_UART_FOR_BYTE_COUNT_SHIFT))

//====================================================================
//Register: Auto-Baud Control Register (UART_ABR)
/** \brief This register controls the functionality and options for auto-baud-rate
detection within the UART. Through this register, software can enable/disable
the auto-baud-lock interrupt, direct either the PXA2128 Application Processor or
the UART to program the final baud rate in the Divisor Latch registers, and
choose between two methods used to calculate the final baud rate.
The auto-baud circuitry counts the number of clocks in the start bit and writes
this count into the Auto-Baud Count register (ACR). It then interrupts the
PXA2128 Application Processor if the <Auto-baud Lock> field in the Interrupt
Identification Register is set. It also programs automatically the Divisor Latch
registers (DLL and DLH) if the <ABUP> field is set.
See Auto-Baud-Rate Detection section in PXA2128 Application Processor Datasheet
for more information on auto-baud rate.
Note: Auto-baud-rate detection is not supported in IrDA serial-infrared mode.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART3_UART_ABR_RESERVED1_MASK 0xfffffff0
#define  UART3_UART_ABR_RESERVED1_SHIFT 4
#define  UART3_UART_ABR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART3_UART_ABR_RESERVED1_MASK) >> UART3_UART_ABR_RESERVED1_SHIFT)
#define  UART3_UART_ABR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_ABR_RESERVED1_MASK) | (((uint32_t)val) << UART3_UART_ABR_RESERVED1_SHIFT))

#define  UART3_UART_ABR_ABT_MASK 0x8
#define  UART3_UART_ABR_ABT_SHIFT 3
#define  UART3_UART_ABR_ABT_MASK_SHIFT(reg) (((reg) & UART3_UART_ABR_ABT_MASK) >> UART3_UART_ABR_ABT_SHIFT)
#define  UART3_UART_ABR_ABT_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_ABR_ABT_MASK) | (((uint32_t)val) << UART3_UART_ABR_ABT_SHIFT))

#define  UART3_UART_ABR_ABUP_MASK 0x4
#define  UART3_UART_ABR_ABUP_SHIFT 2
#define  UART3_UART_ABR_ABUP_MASK_SHIFT(reg) (((reg) & UART3_UART_ABR_ABUP_MASK) >> UART3_UART_ABR_ABUP_SHIFT)
#define  UART3_UART_ABR_ABUP_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_ABR_ABUP_MASK) | (((uint32_t)val) << UART3_UART_ABR_ABUP_SHIFT))

#define  UART3_UART_ABR_ABLIE_MASK 0x2
#define  UART3_UART_ABR_ABLIE_SHIFT 1
#define  UART3_UART_ABR_ABLIE_MASK_SHIFT(reg) (((reg) & UART3_UART_ABR_ABLIE_MASK) >> UART3_UART_ABR_ABLIE_SHIFT)
#define  UART3_UART_ABR_ABLIE_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_ABR_ABLIE_MASK) | (((uint32_t)val) << UART3_UART_ABR_ABLIE_SHIFT))

#define  UART3_UART_ABR_ABE_MASK 0x1
#define  UART3_UART_ABR_ABE_SHIFT 0
#define  UART3_UART_ABR_ABE_MASK_SHIFT(reg) (((reg) & UART3_UART_ABR_ABE_MASK) >> UART3_UART_ABR_ABE_SHIFT)
#define  UART3_UART_ABR_ABE_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_ABR_ABE_MASK) | (((uint32_t)val) << UART3_UART_ABR_ABE_SHIFT))

//====================================================================
//Register: Auto-Baud Count Register (UART_ACR)
/** \brief This register stores the number of 14.857-MHz clock cycles within a start-bit
pulse. This value is then used by the PXA2128 Application Processor or the UART
to calculate the baud rate. If auto-baud mode (<ABE> field in Auto-Baud Control
Register) and auto-baud interrupts (<ABLIE> field in Auto-Baud Control Register)
are enabled, the UART interrupts the PXA2128 Application Processor with the
auto-baud-lock interrupt (IIR[ABL]) after it has written the count value into
ACR. The value is written regardless of the state of the auto-baud UART program
bit, (ABR[ABUP]).
This is a read-only register. Ignore reads from reserved bits.*/
//====================================================================

#define  UART3_UART_ACR_RESERVED1_MASK 0xffff0000
#define  UART3_UART_ACR_RESERVED1_SHIFT 16
#define  UART3_UART_ACR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART3_UART_ACR_RESERVED1_MASK) >> UART3_UART_ACR_RESERVED1_SHIFT)
#define  UART3_UART_ACR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_ACR_RESERVED1_MASK) | (((uint32_t)val) << UART3_UART_ACR_RESERVED1_SHIFT))

#define  UART3_UART_ACR_COUNT_VALUE_MASK 0xffff
#define  UART3_UART_ACR_COUNT_VALUE_SHIFT 0
#define  UART3_UART_ACR_COUNT_VALUE_MASK_SHIFT(reg) (((reg) & UART3_UART_ACR_COUNT_VALUE_MASK) >> UART3_UART_ACR_COUNT_VALUE_SHIFT)
#define  UART3_UART_ACR_COUNT_VALUE_REPLACE_VAL(reg,val) (((reg) & ~UART3_UART_ACR_COUNT_VALUE_MASK) | (((uint32_t)val) << UART3_UART_ACR_COUNT_VALUE_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  UART3_REV0_MAJ_MASK 0xffff0000
#define  UART3_REV0_MAJ_SHIFT 16
#define  UART3_REV0_MAJ_MASK_SHIFT(reg) (((reg) & UART3_REV0_MAJ_MASK) >> UART3_REV0_MAJ_SHIFT)
#define  UART3_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~UART3_REV0_MAJ_MASK) | (((uint32_t)val) << UART3_REV0_MAJ_SHIFT))

#define  UART3_REV0_MID_MASK 0xffff
#define  UART3_REV0_MID_SHIFT 0
#define  UART3_REV0_MID_MASK_SHIFT(reg) (((reg) & UART3_REV0_MID_MASK) >> UART3_REV0_MID_SHIFT)
#define  UART3_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~UART3_REV0_MID_MASK) | (((uint32_t)val) << UART3_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  UART3_REV1_RESERVED1_MASK 0xffff0000
#define  UART3_REV1_RESERVED1_SHIFT 16
#define  UART3_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & UART3_REV1_RESERVED1_MASK) >> UART3_REV1_RESERVED1_SHIFT)
#define  UART3_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART3_REV1_RESERVED1_MASK) | (((uint32_t)val) << UART3_REV1_RESERVED1_SHIFT))

#define  UART3_REV1_CFG_MASK 0xffff
#define  UART3_REV1_CFG_SHIFT 0
#define  UART3_REV1_CFG_MASK_SHIFT(reg) (((reg) & UART3_REV1_CFG_MASK) >> UART3_REV1_CFG_SHIFT)
#define  UART3_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~UART3_REV1_CFG_MASK) | (((uint32_t)val) << UART3_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: GPIO Registers (GPIO)
/** \brief Register Descriptions for the GPIO banks*/
//
//====================================================================

//====================================================================
//
//Register File: Pad Edge Registers (PadEdge)
/** \brief (rev 0 . 1 . 0 . 0)
    Register Descriptions for the Pad Edge Detect banks*/
//
//====================================================================

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  PADEDGE_REV0_MAJ_MASK 0xffff0000
#define  PADEDGE_REV0_MAJ_SHIFT 16
#define  PADEDGE_REV0_MAJ_MASK_SHIFT(reg) (((reg) & PADEDGE_REV0_MAJ_MASK) >> PADEDGE_REV0_MAJ_SHIFT)
#define  PADEDGE_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~PADEDGE_REV0_MAJ_MASK) | (((uint32_t)val) << PADEDGE_REV0_MAJ_SHIFT))

#define  PADEDGE_REV0_MID_MASK 0xffff
#define  PADEDGE_REV0_MID_SHIFT 0
#define  PADEDGE_REV0_MID_MASK_SHIFT(reg) (((reg) & PADEDGE_REV0_MID_MASK) >> PADEDGE_REV0_MID_SHIFT)
#define  PADEDGE_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~PADEDGE_REV0_MID_MASK) | (((uint32_t)val) << PADEDGE_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  PADEDGE_REV1_RESERVED1_MASK 0xffff0000
#define  PADEDGE_REV1_RESERVED1_SHIFT 16
#define  PADEDGE_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & PADEDGE_REV1_RESERVED1_MASK) >> PADEDGE_REV1_RESERVED1_SHIFT)
#define  PADEDGE_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PADEDGE_REV1_RESERVED1_MASK) | (((uint32_t)val) << PADEDGE_REV1_RESERVED1_SHIFT))

#define  PADEDGE_REV1_CFG_MASK 0xffff
#define  PADEDGE_REV1_CFG_SHIFT 0
#define  PADEDGE_REV1_CFG_MASK_SHIFT(reg) (((reg) & PADEDGE_REV1_CFG_MASK) >> PADEDGE_REV1_CFG_SHIFT)
#define  PADEDGE_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~PADEDGE_REV1_CFG_MASK) | (((uint32_t)val) << PADEDGE_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: IPC Registers (Instance 1 of 2) (IPC0)
/** \brief Register Descriptions for the IPC (rev 0 . 3 . 2 . 0)*/
//
//====================================================================

//====================================================================
//Register: IPC_ISRR (IPC_ISRR)
//====================================================================

#define  IPC0_IPC_ISRR_RESERVED1_MASK 0xfffff800
#define  IPC0_IPC_ISRR_RESERVED1_SHIFT 11
#define  IPC0_IPC_ISRR_RESERVED1_MASK_SHIFT(reg) (((reg) & IPC0_IPC_ISRR_RESERVED1_MASK) >> IPC0_IPC_ISRR_RESERVED1_SHIFT)
#define  IPC0_IPC_ISRR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPC0_IPC_ISRR_RESERVED1_MASK) | (((uint32_t)val) << IPC0_IPC_ISRR_RESERVED1_SHIFT))

#define  IPC0_IPC_ISRR_APB_IPC_ISRR_MASK 0x7ff
#define  IPC0_IPC_ISRR_APB_IPC_ISRR_SHIFT 0
#define  IPC0_IPC_ISRR_APB_IPC_ISRR_MASK_SHIFT(reg) (((reg) & IPC0_IPC_ISRR_APB_IPC_ISRR_MASK) >> IPC0_IPC_ISRR_APB_IPC_ISRR_SHIFT)
#define  IPC0_IPC_ISRR_APB_IPC_ISRR_REPLACE_VAL(reg,val) (((reg) & ~IPC0_IPC_ISRR_APB_IPC_ISRR_MASK) | (((uint32_t)val) << IPC0_IPC_ISRR_APB_IPC_ISRR_SHIFT))

//====================================================================
//Register: Write Data Register 0 (IPC_WDR_0)
//====================================================================

#define  IPC0_IPC_WDR_0_APB_IPC_WDR_0_MASK 0xffffffff
#define  IPC0_IPC_WDR_0_APB_IPC_WDR_0_SHIFT 0
#define  IPC0_IPC_WDR_0_APB_IPC_WDR_0_MASK_SHIFT(reg) (((reg) & IPC0_IPC_WDR_0_APB_IPC_WDR_0_MASK) >> IPC0_IPC_WDR_0_APB_IPC_WDR_0_SHIFT)
#define  IPC0_IPC_WDR_0_APB_IPC_WDR_0_REPLACE_VAL(reg,val) (((reg) & ~IPC0_IPC_WDR_0_APB_IPC_WDR_0_MASK) | (((uint32_t)val) << IPC0_IPC_WDR_0_APB_IPC_WDR_0_SHIFT))

//====================================================================
//Register: Write Data Register 1 (IPC_WDR_1)
//====================================================================

#define  IPC0_IPC_WDR_1_APB_IPC_WDR_1_MASK 0xffffffff
#define  IPC0_IPC_WDR_1_APB_IPC_WDR_1_SHIFT 0
#define  IPC0_IPC_WDR_1_APB_IPC_WDR_1_MASK_SHIFT(reg) (((reg) & IPC0_IPC_WDR_1_APB_IPC_WDR_1_MASK) >> IPC0_IPC_WDR_1_APB_IPC_WDR_1_SHIFT)
#define  IPC0_IPC_WDR_1_APB_IPC_WDR_1_REPLACE_VAL(reg,val) (((reg) & ~IPC0_IPC_WDR_1_APB_IPC_WDR_1_MASK) | (((uint32_t)val) << IPC0_IPC_WDR_1_APB_IPC_WDR_1_SHIFT))

//====================================================================
//Register: Interrupt Set Register Write (IPC_ISRW)
/** \brief IPCA base register generate interrupt IPC1 - IPC1 is logic OR of all the IPC
interrupts sets by this register
IPCB base register generate interrupt IPC2 - IPC2 is logic OR of all the IPC
interrupts sets by this register*/
//====================================================================

#define  IPC0_IPC_ISRW_RESERVED1_MASK 0xfffff800
#define  IPC0_IPC_ISRW_RESERVED1_SHIFT 11
#define  IPC0_IPC_ISRW_RESERVED1_MASK_SHIFT(reg) (((reg) & IPC0_IPC_ISRW_RESERVED1_MASK) >> IPC0_IPC_ISRW_RESERVED1_SHIFT)
#define  IPC0_IPC_ISRW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPC0_IPC_ISRW_RESERVED1_MASK) | (((uint32_t)val) << IPC0_IPC_ISRW_RESERVED1_SHIFT))

#define  IPC0_IPC_ISRW_APB_IPC_ISRW_MASK 0x7ff
#define  IPC0_IPC_ISRW_APB_IPC_ISRW_SHIFT 0
#define  IPC0_IPC_ISRW_APB_IPC_ISRW_MASK_SHIFT(reg) (((reg) & IPC0_IPC_ISRW_APB_IPC_ISRW_MASK) >> IPC0_IPC_ISRW_APB_IPC_ISRW_SHIFT)
#define  IPC0_IPC_ISRW_APB_IPC_ISRW_REPLACE_VAL(reg,val) (((reg) & ~IPC0_IPC_ISRW_APB_IPC_ISRW_MASK) | (((uint32_t)val) << IPC0_IPC_ISRW_APB_IPC_ISRW_SHIFT))

//====================================================================
//Register: Interrupt Clear Register (IPC_ICR)
//====================================================================

#define  IPC0_IPC_ICR_RESERVED1_MASK 0xfffff800
#define  IPC0_IPC_ICR_RESERVED1_SHIFT 11
#define  IPC0_IPC_ICR_RESERVED1_MASK_SHIFT(reg) (((reg) & IPC0_IPC_ICR_RESERVED1_MASK) >> IPC0_IPC_ICR_RESERVED1_SHIFT)
#define  IPC0_IPC_ICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPC0_IPC_ICR_RESERVED1_MASK) | (((uint32_t)val) << IPC0_IPC_ICR_RESERVED1_SHIFT))

#define  IPC0_IPC_ICR_APB_IPC_ICR_MASK 0x7ff
#define  IPC0_IPC_ICR_APB_IPC_ICR_SHIFT 0
#define  IPC0_IPC_ICR_APB_IPC_ICR_MASK_SHIFT(reg) (((reg) & IPC0_IPC_ICR_APB_IPC_ICR_MASK) >> IPC0_IPC_ICR_APB_IPC_ICR_SHIFT)
#define  IPC0_IPC_ICR_APB_IPC_ICR_REPLACE_VAL(reg,val) (((reg) & ~IPC0_IPC_ICR_APB_IPC_ICR_MASK) | (((uint32_t)val) << IPC0_IPC_ICR_APB_IPC_ICR_SHIFT))

//====================================================================
//Register: Interrupt Identification Register (IPC_IIR)
//====================================================================

#define  IPC0_IPC_IIR_RESERVED1_MASK 0xfffff800
#define  IPC0_IPC_IIR_RESERVED1_SHIFT 11
#define  IPC0_IPC_IIR_RESERVED1_MASK_SHIFT(reg) (((reg) & IPC0_IPC_IIR_RESERVED1_MASK) >> IPC0_IPC_IIR_RESERVED1_SHIFT)
#define  IPC0_IPC_IIR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPC0_IPC_IIR_RESERVED1_MASK) | (((uint32_t)val) << IPC0_IPC_IIR_RESERVED1_SHIFT))

#define  IPC0_IPC_IIR_APB_IPC_IIR_MASK 0x7ff
#define  IPC0_IPC_IIR_APB_IPC_IIR_SHIFT 0
#define  IPC0_IPC_IIR_APB_IPC_IIR_MASK_SHIFT(reg) (((reg) & IPC0_IPC_IIR_APB_IPC_IIR_MASK) >> IPC0_IPC_IIR_APB_IPC_IIR_SHIFT)
#define  IPC0_IPC_IIR_APB_IPC_IIR_REPLACE_VAL(reg,val) (((reg) & ~IPC0_IPC_IIR_APB_IPC_IIR_MASK) | (((uint32_t)val) << IPC0_IPC_IIR_APB_IPC_IIR_SHIFT))

//====================================================================
//Register: Read Data Register 0 (IPC_RDR_0)
//====================================================================

#define  IPC0_IPC_RDR_0_APB_IPC_RDR_0_MASK 0xffffffff
#define  IPC0_IPC_RDR_0_APB_IPC_RDR_0_SHIFT 0
#define  IPC0_IPC_RDR_0_APB_IPC_RDR_0_MASK_SHIFT(reg) (((reg) & IPC0_IPC_RDR_0_APB_IPC_RDR_0_MASK) >> IPC0_IPC_RDR_0_APB_IPC_RDR_0_SHIFT)
#define  IPC0_IPC_RDR_0_APB_IPC_RDR_0_REPLACE_VAL(reg,val) (((reg) & ~IPC0_IPC_RDR_0_APB_IPC_RDR_0_MASK) | (((uint32_t)val) << IPC0_IPC_RDR_0_APB_IPC_RDR_0_SHIFT))

//====================================================================
//Register: Read Data Register 1 (IPC_RDR_1)
//====================================================================

#define  IPC0_IPC_RDR_1_APB_IPC_RDR_1_MASK 0xffffffff
#define  IPC0_IPC_RDR_1_APB_IPC_RDR_1_SHIFT 0
#define  IPC0_IPC_RDR_1_APB_IPC_RDR_1_MASK_SHIFT(reg) (((reg) & IPC0_IPC_RDR_1_APB_IPC_RDR_1_MASK) >> IPC0_IPC_RDR_1_APB_IPC_RDR_1_SHIFT)
#define  IPC0_IPC_RDR_1_APB_IPC_RDR_1_REPLACE_VAL(reg,val) (((reg) & ~IPC0_IPC_RDR_1_APB_IPC_RDR_1_MASK) | (((uint32_t)val) << IPC0_IPC_RDR_1_APB_IPC_RDR_1_SHIFT))

//====================================================================
//Register: Revision (Major and Mid) Register (IPC_MAJ_MID_REV)
//====================================================================

#define  IPC0_IPC_MAJ_MID_REV_MAJ_REV_MASK 0xffff0000
#define  IPC0_IPC_MAJ_MID_REV_MAJ_REV_SHIFT 16
#define  IPC0_IPC_MAJ_MID_REV_MAJ_REV_MASK_SHIFT(reg) (((reg) & IPC0_IPC_MAJ_MID_REV_MAJ_REV_MASK) >> IPC0_IPC_MAJ_MID_REV_MAJ_REV_SHIFT)
#define  IPC0_IPC_MAJ_MID_REV_MAJ_REV_REPLACE_VAL(reg,val) (((reg) & ~IPC0_IPC_MAJ_MID_REV_MAJ_REV_MASK) | (((uint32_t)val) << IPC0_IPC_MAJ_MID_REV_MAJ_REV_SHIFT))

#define  IPC0_IPC_MAJ_MID_REV_MID_REV_MASK 0xffff
#define  IPC0_IPC_MAJ_MID_REV_MID_REV_SHIFT 0
#define  IPC0_IPC_MAJ_MID_REV_MID_REV_MASK_SHIFT(reg) (((reg) & IPC0_IPC_MAJ_MID_REV_MID_REV_MASK) >> IPC0_IPC_MAJ_MID_REV_MID_REV_SHIFT)
#define  IPC0_IPC_MAJ_MID_REV_MID_REV_REPLACE_VAL(reg,val) (((reg) & ~IPC0_IPC_MAJ_MID_REV_MID_REV_MASK) | (((uint32_t)val) << IPC0_IPC_MAJ_MID_REV_MID_REV_SHIFT))

//====================================================================
//Register: Revision (Configuration) Register (IPC_CFG_REV)
//====================================================================

#define  IPC0_IPC_CFG_REV_RESERVED1_MASK 0xffff0000
#define  IPC0_IPC_CFG_REV_RESERVED1_SHIFT 16
#define  IPC0_IPC_CFG_REV_RESERVED1_MASK_SHIFT(reg) (((reg) & IPC0_IPC_CFG_REV_RESERVED1_MASK) >> IPC0_IPC_CFG_REV_RESERVED1_SHIFT)
#define  IPC0_IPC_CFG_REV_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPC0_IPC_CFG_REV_RESERVED1_MASK) | (((uint32_t)val) << IPC0_IPC_CFG_REV_RESERVED1_SHIFT))

#define  IPC0_IPC_CFG_REV_CFG_REV_MASK 0xffff
#define  IPC0_IPC_CFG_REV_CFG_REV_SHIFT 0
#define  IPC0_IPC_CFG_REV_CFG_REV_MASK_SHIFT(reg) (((reg) & IPC0_IPC_CFG_REV_CFG_REV_MASK) >> IPC0_IPC_CFG_REV_CFG_REV_SHIFT)
#define  IPC0_IPC_CFG_REV_CFG_REV_REPLACE_VAL(reg,val) (((reg) & ~IPC0_IPC_CFG_REV_CFG_REV_MASK) | (((uint32_t)val) << IPC0_IPC_CFG_REV_CFG_REV_SHIFT))

//====================================================================
//Register: Dummy Register (IPC_DUMMY)
//====================================================================

#define  IPC0_IPC_DUMMY_APB_IPC_DUMMY_MASK 0xffffffff
#define  IPC0_IPC_DUMMY_APB_IPC_DUMMY_SHIFT 0
#define  IPC0_IPC_DUMMY_APB_IPC_DUMMY_MASK_SHIFT(reg) (((reg) & IPC0_IPC_DUMMY_APB_IPC_DUMMY_MASK) >> IPC0_IPC_DUMMY_APB_IPC_DUMMY_SHIFT)
#define  IPC0_IPC_DUMMY_APB_IPC_DUMMY_REPLACE_VAL(reg,val) (((reg) & ~IPC0_IPC_DUMMY_APB_IPC_DUMMY_MASK) | (((uint32_t)val) << IPC0_IPC_DUMMY_APB_IPC_DUMMY_SHIFT))

//====================================================================
//
//Register File: IPC Registers (Instance 2 of 2) (IPC1)
/** \brief Register Descriptions for the IPC (rev 0 . 3 . 2 . 0)*/
//
//====================================================================

//====================================================================
//Register: IPC_ISRR (IPC_ISRR)
//====================================================================

#define  IPC1_IPC_ISRR_RESERVED1_MASK 0xfffff800
#define  IPC1_IPC_ISRR_RESERVED1_SHIFT 11
#define  IPC1_IPC_ISRR_RESERVED1_MASK_SHIFT(reg) (((reg) & IPC1_IPC_ISRR_RESERVED1_MASK) >> IPC1_IPC_ISRR_RESERVED1_SHIFT)
#define  IPC1_IPC_ISRR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPC1_IPC_ISRR_RESERVED1_MASK) | (((uint32_t)val) << IPC1_IPC_ISRR_RESERVED1_SHIFT))

#define  IPC1_IPC_ISRR_APB_IPC_ISRR_MASK 0x7ff
#define  IPC1_IPC_ISRR_APB_IPC_ISRR_SHIFT 0
#define  IPC1_IPC_ISRR_APB_IPC_ISRR_MASK_SHIFT(reg) (((reg) & IPC1_IPC_ISRR_APB_IPC_ISRR_MASK) >> IPC1_IPC_ISRR_APB_IPC_ISRR_SHIFT)
#define  IPC1_IPC_ISRR_APB_IPC_ISRR_REPLACE_VAL(reg,val) (((reg) & ~IPC1_IPC_ISRR_APB_IPC_ISRR_MASK) | (((uint32_t)val) << IPC1_IPC_ISRR_APB_IPC_ISRR_SHIFT))

//====================================================================
//Register: Write Data Register 0 (IPC_WDR_0)
//====================================================================

#define  IPC1_IPC_WDR_0_APB_IPC_WDR_0_MASK 0xffffffff
#define  IPC1_IPC_WDR_0_APB_IPC_WDR_0_SHIFT 0
#define  IPC1_IPC_WDR_0_APB_IPC_WDR_0_MASK_SHIFT(reg) (((reg) & IPC1_IPC_WDR_0_APB_IPC_WDR_0_MASK) >> IPC1_IPC_WDR_0_APB_IPC_WDR_0_SHIFT)
#define  IPC1_IPC_WDR_0_APB_IPC_WDR_0_REPLACE_VAL(reg,val) (((reg) & ~IPC1_IPC_WDR_0_APB_IPC_WDR_0_MASK) | (((uint32_t)val) << IPC1_IPC_WDR_0_APB_IPC_WDR_0_SHIFT))

//====================================================================
//Register: Write Data Register 1 (IPC_WDR_1)
//====================================================================

#define  IPC1_IPC_WDR_1_APB_IPC_WDR_1_MASK 0xffffffff
#define  IPC1_IPC_WDR_1_APB_IPC_WDR_1_SHIFT 0
#define  IPC1_IPC_WDR_1_APB_IPC_WDR_1_MASK_SHIFT(reg) (((reg) & IPC1_IPC_WDR_1_APB_IPC_WDR_1_MASK) >> IPC1_IPC_WDR_1_APB_IPC_WDR_1_SHIFT)
#define  IPC1_IPC_WDR_1_APB_IPC_WDR_1_REPLACE_VAL(reg,val) (((reg) & ~IPC1_IPC_WDR_1_APB_IPC_WDR_1_MASK) | (((uint32_t)val) << IPC1_IPC_WDR_1_APB_IPC_WDR_1_SHIFT))

//====================================================================
//Register: Interrupt Set Register Write (IPC_ISRW)
/** \brief IPCA base register generate interrupt IPC1 - IPC1 is logic OR of all the IPC
interrupts sets by this register
IPCB base register generate interrupt IPC2 - IPC2 is logic OR of all the IPC
interrupts sets by this register*/
//====================================================================

#define  IPC1_IPC_ISRW_RESERVED1_MASK 0xfffff800
#define  IPC1_IPC_ISRW_RESERVED1_SHIFT 11
#define  IPC1_IPC_ISRW_RESERVED1_MASK_SHIFT(reg) (((reg) & IPC1_IPC_ISRW_RESERVED1_MASK) >> IPC1_IPC_ISRW_RESERVED1_SHIFT)
#define  IPC1_IPC_ISRW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPC1_IPC_ISRW_RESERVED1_MASK) | (((uint32_t)val) << IPC1_IPC_ISRW_RESERVED1_SHIFT))

#define  IPC1_IPC_ISRW_APB_IPC_ISRW_MASK 0x7ff
#define  IPC1_IPC_ISRW_APB_IPC_ISRW_SHIFT 0
#define  IPC1_IPC_ISRW_APB_IPC_ISRW_MASK_SHIFT(reg) (((reg) & IPC1_IPC_ISRW_APB_IPC_ISRW_MASK) >> IPC1_IPC_ISRW_APB_IPC_ISRW_SHIFT)
#define  IPC1_IPC_ISRW_APB_IPC_ISRW_REPLACE_VAL(reg,val) (((reg) & ~IPC1_IPC_ISRW_APB_IPC_ISRW_MASK) | (((uint32_t)val) << IPC1_IPC_ISRW_APB_IPC_ISRW_SHIFT))

//====================================================================
//Register: Interrupt Clear Register (IPC_ICR)
//====================================================================

#define  IPC1_IPC_ICR_RESERVED1_MASK 0xfffff800
#define  IPC1_IPC_ICR_RESERVED1_SHIFT 11
#define  IPC1_IPC_ICR_RESERVED1_MASK_SHIFT(reg) (((reg) & IPC1_IPC_ICR_RESERVED1_MASK) >> IPC1_IPC_ICR_RESERVED1_SHIFT)
#define  IPC1_IPC_ICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPC1_IPC_ICR_RESERVED1_MASK) | (((uint32_t)val) << IPC1_IPC_ICR_RESERVED1_SHIFT))

#define  IPC1_IPC_ICR_APB_IPC_ICR_MASK 0x7ff
#define  IPC1_IPC_ICR_APB_IPC_ICR_SHIFT 0
#define  IPC1_IPC_ICR_APB_IPC_ICR_MASK_SHIFT(reg) (((reg) & IPC1_IPC_ICR_APB_IPC_ICR_MASK) >> IPC1_IPC_ICR_APB_IPC_ICR_SHIFT)
#define  IPC1_IPC_ICR_APB_IPC_ICR_REPLACE_VAL(reg,val) (((reg) & ~IPC1_IPC_ICR_APB_IPC_ICR_MASK) | (((uint32_t)val) << IPC1_IPC_ICR_APB_IPC_ICR_SHIFT))

//====================================================================
//Register: Interrupt Identification Register (IPC_IIR)
//====================================================================

#define  IPC1_IPC_IIR_RESERVED1_MASK 0xfffff800
#define  IPC1_IPC_IIR_RESERVED1_SHIFT 11
#define  IPC1_IPC_IIR_RESERVED1_MASK_SHIFT(reg) (((reg) & IPC1_IPC_IIR_RESERVED1_MASK) >> IPC1_IPC_IIR_RESERVED1_SHIFT)
#define  IPC1_IPC_IIR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPC1_IPC_IIR_RESERVED1_MASK) | (((uint32_t)val) << IPC1_IPC_IIR_RESERVED1_SHIFT))

#define  IPC1_IPC_IIR_APB_IPC_IIR_MASK 0x7ff
#define  IPC1_IPC_IIR_APB_IPC_IIR_SHIFT 0
#define  IPC1_IPC_IIR_APB_IPC_IIR_MASK_SHIFT(reg) (((reg) & IPC1_IPC_IIR_APB_IPC_IIR_MASK) >> IPC1_IPC_IIR_APB_IPC_IIR_SHIFT)
#define  IPC1_IPC_IIR_APB_IPC_IIR_REPLACE_VAL(reg,val) (((reg) & ~IPC1_IPC_IIR_APB_IPC_IIR_MASK) | (((uint32_t)val) << IPC1_IPC_IIR_APB_IPC_IIR_SHIFT))

//====================================================================
//Register: Read Data Register 0 (IPC_RDR_0)
//====================================================================

#define  IPC1_IPC_RDR_0_APB_IPC_RDR_0_MASK 0xffffffff
#define  IPC1_IPC_RDR_0_APB_IPC_RDR_0_SHIFT 0
#define  IPC1_IPC_RDR_0_APB_IPC_RDR_0_MASK_SHIFT(reg) (((reg) & IPC1_IPC_RDR_0_APB_IPC_RDR_0_MASK) >> IPC1_IPC_RDR_0_APB_IPC_RDR_0_SHIFT)
#define  IPC1_IPC_RDR_0_APB_IPC_RDR_0_REPLACE_VAL(reg,val) (((reg) & ~IPC1_IPC_RDR_0_APB_IPC_RDR_0_MASK) | (((uint32_t)val) << IPC1_IPC_RDR_0_APB_IPC_RDR_0_SHIFT))

//====================================================================
//Register: Read Data Register 1 (IPC_RDR_1)
//====================================================================

#define  IPC1_IPC_RDR_1_APB_IPC_RDR_1_MASK 0xffffffff
#define  IPC1_IPC_RDR_1_APB_IPC_RDR_1_SHIFT 0
#define  IPC1_IPC_RDR_1_APB_IPC_RDR_1_MASK_SHIFT(reg) (((reg) & IPC1_IPC_RDR_1_APB_IPC_RDR_1_MASK) >> IPC1_IPC_RDR_1_APB_IPC_RDR_1_SHIFT)
#define  IPC1_IPC_RDR_1_APB_IPC_RDR_1_REPLACE_VAL(reg,val) (((reg) & ~IPC1_IPC_RDR_1_APB_IPC_RDR_1_MASK) | (((uint32_t)val) << IPC1_IPC_RDR_1_APB_IPC_RDR_1_SHIFT))

//====================================================================
//Register: Revision (Major and Mid) Register (IPC_MAJ_MID_REV)
//====================================================================

#define  IPC1_IPC_MAJ_MID_REV_MAJ_REV_MASK 0xffff0000
#define  IPC1_IPC_MAJ_MID_REV_MAJ_REV_SHIFT 16
#define  IPC1_IPC_MAJ_MID_REV_MAJ_REV_MASK_SHIFT(reg) (((reg) & IPC1_IPC_MAJ_MID_REV_MAJ_REV_MASK) >> IPC1_IPC_MAJ_MID_REV_MAJ_REV_SHIFT)
#define  IPC1_IPC_MAJ_MID_REV_MAJ_REV_REPLACE_VAL(reg,val) (((reg) & ~IPC1_IPC_MAJ_MID_REV_MAJ_REV_MASK) | (((uint32_t)val) << IPC1_IPC_MAJ_MID_REV_MAJ_REV_SHIFT))

#define  IPC1_IPC_MAJ_MID_REV_MID_REV_MASK 0xffff
#define  IPC1_IPC_MAJ_MID_REV_MID_REV_SHIFT 0
#define  IPC1_IPC_MAJ_MID_REV_MID_REV_MASK_SHIFT(reg) (((reg) & IPC1_IPC_MAJ_MID_REV_MID_REV_MASK) >> IPC1_IPC_MAJ_MID_REV_MID_REV_SHIFT)
#define  IPC1_IPC_MAJ_MID_REV_MID_REV_REPLACE_VAL(reg,val) (((reg) & ~IPC1_IPC_MAJ_MID_REV_MID_REV_MASK) | (((uint32_t)val) << IPC1_IPC_MAJ_MID_REV_MID_REV_SHIFT))

//====================================================================
//Register: Revision (Configuration) Register (IPC_CFG_REV)
//====================================================================

#define  IPC1_IPC_CFG_REV_RESERVED1_MASK 0xffff0000
#define  IPC1_IPC_CFG_REV_RESERVED1_SHIFT 16
#define  IPC1_IPC_CFG_REV_RESERVED1_MASK_SHIFT(reg) (((reg) & IPC1_IPC_CFG_REV_RESERVED1_MASK) >> IPC1_IPC_CFG_REV_RESERVED1_SHIFT)
#define  IPC1_IPC_CFG_REV_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPC1_IPC_CFG_REV_RESERVED1_MASK) | (((uint32_t)val) << IPC1_IPC_CFG_REV_RESERVED1_SHIFT))

#define  IPC1_IPC_CFG_REV_CFG_REV_MASK 0xffff
#define  IPC1_IPC_CFG_REV_CFG_REV_SHIFT 0
#define  IPC1_IPC_CFG_REV_CFG_REV_MASK_SHIFT(reg) (((reg) & IPC1_IPC_CFG_REV_CFG_REV_MASK) >> IPC1_IPC_CFG_REV_CFG_REV_SHIFT)
#define  IPC1_IPC_CFG_REV_CFG_REV_REPLACE_VAL(reg,val) (((reg) & ~IPC1_IPC_CFG_REV_CFG_REV_MASK) | (((uint32_t)val) << IPC1_IPC_CFG_REV_CFG_REV_SHIFT))

//====================================================================
//Register: Dummy Register (IPC_DUMMY)
//====================================================================

#define  IPC1_IPC_DUMMY_APB_IPC_DUMMY_MASK 0xffffffff
#define  IPC1_IPC_DUMMY_APB_IPC_DUMMY_SHIFT 0
#define  IPC1_IPC_DUMMY_APB_IPC_DUMMY_MASK_SHIFT(reg) (((reg) & IPC1_IPC_DUMMY_APB_IPC_DUMMY_MASK) >> IPC1_IPC_DUMMY_APB_IPC_DUMMY_SHIFT)
#define  IPC1_IPC_DUMMY_APB_IPC_DUMMY_REPLACE_VAL(reg,val) (((reg) & ~IPC1_IPC_DUMMY_APB_IPC_DUMMY_MASK) | (((uint32_t)val) << IPC1_IPC_DUMMY_APB_IPC_DUMMY_SHIFT))

//====================================================================
//
//Register File: APB Config Registers (apb_config)
//
//====================================================================

//====================================================================
//Register: DFT Island IP Tagging REV0 (DFTISLD_REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  APB_CONFIG_DFTISLD_REV0_MAJ_MASK 0xffff0000
#define  APB_CONFIG_DFTISLD_REV0_MAJ_SHIFT 16
#define  APB_CONFIG_DFTISLD_REV0_MAJ_MASK_SHIFT(reg) (((reg) & APB_CONFIG_DFTISLD_REV0_MAJ_MASK) >> APB_CONFIG_DFTISLD_REV0_MAJ_SHIFT)
#define  APB_CONFIG_DFTISLD_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_DFTISLD_REV0_MAJ_MASK) | (((uint32_t)val) << APB_CONFIG_DFTISLD_REV0_MAJ_SHIFT))

#define  APB_CONFIG_DFTISLD_REV0_MID_MASK 0xffff
#define  APB_CONFIG_DFTISLD_REV0_MID_SHIFT 0
#define  APB_CONFIG_DFTISLD_REV0_MID_MASK_SHIFT(reg) (((reg) & APB_CONFIG_DFTISLD_REV0_MID_MASK) >> APB_CONFIG_DFTISLD_REV0_MID_SHIFT)
#define  APB_CONFIG_DFTISLD_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_DFTISLD_REV0_MID_MASK) | (((uint32_t)val) << APB_CONFIG_DFTISLD_REV0_MID_SHIFT))

//====================================================================
//Register: DFT Island IP Tagging REV1 (DFTISLD_REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  APB_CONFIG_DFTISLD_REV1_RESERVED1_MASK 0xffff0000
#define  APB_CONFIG_DFTISLD_REV1_RESERVED1_SHIFT 16
#define  APB_CONFIG_DFTISLD_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_DFTISLD_REV1_RESERVED1_MASK) >> APB_CONFIG_DFTISLD_REV1_RESERVED1_SHIFT)
#define  APB_CONFIG_DFTISLD_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_DFTISLD_REV1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_DFTISLD_REV1_RESERVED1_SHIFT))

#define  APB_CONFIG_DFTISLD_REV1_CFG_MASK 0xffff
#define  APB_CONFIG_DFTISLD_REV1_CFG_SHIFT 0
#define  APB_CONFIG_DFTISLD_REV1_CFG_MASK_SHIFT(reg) (((reg) & APB_CONFIG_DFTISLD_REV1_CFG_MASK) >> APB_CONFIG_DFTISLD_REV1_CFG_SHIFT)
#define  APB_CONFIG_DFTISLD_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_DFTISLD_REV1_CFG_MASK) | (((uint32_t)val) << APB_CONFIG_DFTISLD_REV1_CFG_SHIFT))

//====================================================================
//Register: NDSMC IP Tagging REV0 (NDSMC_REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  APB_CONFIG_NDSMC_REV0_MAJ_MASK 0xffff0000
#define  APB_CONFIG_NDSMC_REV0_MAJ_SHIFT 16
#define  APB_CONFIG_NDSMC_REV0_MAJ_MASK_SHIFT(reg) (((reg) & APB_CONFIG_NDSMC_REV0_MAJ_MASK) >> APB_CONFIG_NDSMC_REV0_MAJ_SHIFT)
#define  APB_CONFIG_NDSMC_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_NDSMC_REV0_MAJ_MASK) | (((uint32_t)val) << APB_CONFIG_NDSMC_REV0_MAJ_SHIFT))

#define  APB_CONFIG_NDSMC_REV0_MID_MASK 0xffff
#define  APB_CONFIG_NDSMC_REV0_MID_SHIFT 0
#define  APB_CONFIG_NDSMC_REV0_MID_MASK_SHIFT(reg) (((reg) & APB_CONFIG_NDSMC_REV0_MID_MASK) >> APB_CONFIG_NDSMC_REV0_MID_SHIFT)
#define  APB_CONFIG_NDSMC_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_NDSMC_REV0_MID_MASK) | (((uint32_t)val) << APB_CONFIG_NDSMC_REV0_MID_SHIFT))

//====================================================================
//Register: NDSMC IP Tagging REV1 (NDSMC_REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  APB_CONFIG_NDSMC_REV1_RESERVED1_MASK 0xffff0000
#define  APB_CONFIG_NDSMC_REV1_RESERVED1_SHIFT 16
#define  APB_CONFIG_NDSMC_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_NDSMC_REV1_RESERVED1_MASK) >> APB_CONFIG_NDSMC_REV1_RESERVED1_SHIFT)
#define  APB_CONFIG_NDSMC_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_NDSMC_REV1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_NDSMC_REV1_RESERVED1_SHIFT))

#define  APB_CONFIG_NDSMC_REV1_CFG_MASK 0xffff
#define  APB_CONFIG_NDSMC_REV1_CFG_SHIFT 0
#define  APB_CONFIG_NDSMC_REV1_CFG_MASK_SHIFT(reg) (((reg) & APB_CONFIG_NDSMC_REV1_CFG_MASK) >> APB_CONFIG_NDSMC_REV1_CFG_SHIFT)
#define  APB_CONFIG_NDSMC_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_NDSMC_REV1_CFG_MASK) | (((uint32_t)val) << APB_CONFIG_NDSMC_REV1_CFG_SHIFT))

//====================================================================
//Register: USB3DEV IP Tagging REV0 (USB3DEV_REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  APB_CONFIG_USB3DEV_REV0_MAJ_MASK 0xffff0000
#define  APB_CONFIG_USB3DEV_REV0_MAJ_SHIFT 16
#define  APB_CONFIG_USB3DEV_REV0_MAJ_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB3DEV_REV0_MAJ_MASK) >> APB_CONFIG_USB3DEV_REV0_MAJ_SHIFT)
#define  APB_CONFIG_USB3DEV_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB3DEV_REV0_MAJ_MASK) | (((uint32_t)val) << APB_CONFIG_USB3DEV_REV0_MAJ_SHIFT))

#define  APB_CONFIG_USB3DEV_REV0_MID_MASK 0xffff
#define  APB_CONFIG_USB3DEV_REV0_MID_SHIFT 0
#define  APB_CONFIG_USB3DEV_REV0_MID_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB3DEV_REV0_MID_MASK) >> APB_CONFIG_USB3DEV_REV0_MID_SHIFT)
#define  APB_CONFIG_USB3DEV_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB3DEV_REV0_MID_MASK) | (((uint32_t)val) << APB_CONFIG_USB3DEV_REV0_MID_SHIFT))

//====================================================================
//Register: USB3DEV IP Tagging REV1 (USB3DEV_REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  APB_CONFIG_USB3DEV_REV1_RESERVED1_MASK 0xffff0000
#define  APB_CONFIG_USB3DEV_REV1_RESERVED1_SHIFT 16
#define  APB_CONFIG_USB3DEV_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB3DEV_REV1_RESERVED1_MASK) >> APB_CONFIG_USB3DEV_REV1_RESERVED1_SHIFT)
#define  APB_CONFIG_USB3DEV_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB3DEV_REV1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_USB3DEV_REV1_RESERVED1_SHIFT))

#define  APB_CONFIG_USB3DEV_REV1_CFG_MASK 0xffff
#define  APB_CONFIG_USB3DEV_REV1_CFG_SHIFT 0
#define  APB_CONFIG_USB3DEV_REV1_CFG_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB3DEV_REV1_CFG_MASK) >> APB_CONFIG_USB3DEV_REV1_CFG_SHIFT)
#define  APB_CONFIG_USB3DEV_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB3DEV_REV1_CFG_MASK) | (((uint32_t)val) << APB_CONFIG_USB3DEV_REV1_CFG_SHIFT))

//====================================================================
//Register: USB3HOST IP Tagging REV0 (USB3HOST_REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  APB_CONFIG_USB3HOST_REV0_MAJ_MASK 0xffff0000
#define  APB_CONFIG_USB3HOST_REV0_MAJ_SHIFT 16
#define  APB_CONFIG_USB3HOST_REV0_MAJ_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB3HOST_REV0_MAJ_MASK) >> APB_CONFIG_USB3HOST_REV0_MAJ_SHIFT)
#define  APB_CONFIG_USB3HOST_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB3HOST_REV0_MAJ_MASK) | (((uint32_t)val) << APB_CONFIG_USB3HOST_REV0_MAJ_SHIFT))

#define  APB_CONFIG_USB3HOST_REV0_MID_MASK 0xffff
#define  APB_CONFIG_USB3HOST_REV0_MID_SHIFT 0
#define  APB_CONFIG_USB3HOST_REV0_MID_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB3HOST_REV0_MID_MASK) >> APB_CONFIG_USB3HOST_REV0_MID_SHIFT)
#define  APB_CONFIG_USB3HOST_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB3HOST_REV0_MID_MASK) | (((uint32_t)val) << APB_CONFIG_USB3HOST_REV0_MID_SHIFT))

//====================================================================
//Register: USB3HOST IP Tagging REV1 (USB3HOST_REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  APB_CONFIG_USB3HOST_REV1_RESERVED1_MASK 0xffff0000
#define  APB_CONFIG_USB3HOST_REV1_RESERVED1_SHIFT 16
#define  APB_CONFIG_USB3HOST_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB3HOST_REV1_RESERVED1_MASK) >> APB_CONFIG_USB3HOST_REV1_RESERVED1_SHIFT)
#define  APB_CONFIG_USB3HOST_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB3HOST_REV1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_USB3HOST_REV1_RESERVED1_SHIFT))

#define  APB_CONFIG_USB3HOST_REV1_CFG_MASK 0xffff
#define  APB_CONFIG_USB3HOST_REV1_CFG_SHIFT 0
#define  APB_CONFIG_USB3HOST_REV1_CFG_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB3HOST_REV1_CFG_MASK) >> APB_CONFIG_USB3HOST_REV1_CFG_SHIFT)
#define  APB_CONFIG_USB3HOST_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB3HOST_REV1_CFG_MASK) | (((uint32_t)val) << APB_CONFIG_USB3HOST_REV1_CFG_SHIFT))

//====================================================================
//Register: USB2HOST IP Tagging REV0 (USB2HOST_REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  APB_CONFIG_USB2HOST_REV0_MAJ_MASK 0xffff0000
#define  APB_CONFIG_USB2HOST_REV0_MAJ_SHIFT 16
#define  APB_CONFIG_USB2HOST_REV0_MAJ_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB2HOST_REV0_MAJ_MASK) >> APB_CONFIG_USB2HOST_REV0_MAJ_SHIFT)
#define  APB_CONFIG_USB2HOST_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB2HOST_REV0_MAJ_MASK) | (((uint32_t)val) << APB_CONFIG_USB2HOST_REV0_MAJ_SHIFT))

#define  APB_CONFIG_USB2HOST_REV0_MID_MASK 0xffff
#define  APB_CONFIG_USB2HOST_REV0_MID_SHIFT 0
#define  APB_CONFIG_USB2HOST_REV0_MID_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB2HOST_REV0_MID_MASK) >> APB_CONFIG_USB2HOST_REV0_MID_SHIFT)
#define  APB_CONFIG_USB2HOST_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB2HOST_REV0_MID_MASK) | (((uint32_t)val) << APB_CONFIG_USB2HOST_REV0_MID_SHIFT))

//====================================================================
//Register: USB2HOST IP Tagging REV1 (USB2HOST_REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  APB_CONFIG_USB2HOST_REV1_RESERVED1_MASK 0xffff0000
#define  APB_CONFIG_USB2HOST_REV1_RESERVED1_SHIFT 16
#define  APB_CONFIG_USB2HOST_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB2HOST_REV1_RESERVED1_MASK) >> APB_CONFIG_USB2HOST_REV1_RESERVED1_SHIFT)
#define  APB_CONFIG_USB2HOST_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB2HOST_REV1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_USB2HOST_REV1_RESERVED1_SHIFT))

#define  APB_CONFIG_USB2HOST_REV1_CFG_MASK 0xffff
#define  APB_CONFIG_USB2HOST_REV1_CFG_SHIFT 0
#define  APB_CONFIG_USB2HOST_REV1_CFG_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB2HOST_REV1_CFG_MASK) >> APB_CONFIG_USB2HOST_REV1_CFG_SHIFT)
#define  APB_CONFIG_USB2HOST_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB2HOST_REV1_CFG_MASK) | (((uint32_t)val) << APB_CONFIG_USB2HOST_REV1_CFG_SHIFT))

//====================================================================
//Register: USB2DEVHOST IP Tagging REV0 (USB2DEVHOST_REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  APB_CONFIG_USB2DEVHOST_REV0_MAJ_MASK 0xffff0000
#define  APB_CONFIG_USB2DEVHOST_REV0_MAJ_SHIFT 16
#define  APB_CONFIG_USB2DEVHOST_REV0_MAJ_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB2DEVHOST_REV0_MAJ_MASK) >> APB_CONFIG_USB2DEVHOST_REV0_MAJ_SHIFT)
#define  APB_CONFIG_USB2DEVHOST_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB2DEVHOST_REV0_MAJ_MASK) | (((uint32_t)val) << APB_CONFIG_USB2DEVHOST_REV0_MAJ_SHIFT))

#define  APB_CONFIG_USB2DEVHOST_REV0_MID_MASK 0xffff
#define  APB_CONFIG_USB2DEVHOST_REV0_MID_SHIFT 0
#define  APB_CONFIG_USB2DEVHOST_REV0_MID_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB2DEVHOST_REV0_MID_MASK) >> APB_CONFIG_USB2DEVHOST_REV0_MID_SHIFT)
#define  APB_CONFIG_USB2DEVHOST_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB2DEVHOST_REV0_MID_MASK) | (((uint32_t)val) << APB_CONFIG_USB2DEVHOST_REV0_MID_SHIFT))

//====================================================================
//Register: USB2DEVHOST IP Tagging REV1 (USB2DEVHOST_REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  APB_CONFIG_USB2DEVHOST_REV1_RESERVED1_MASK 0xffff0000
#define  APB_CONFIG_USB2DEVHOST_REV1_RESERVED1_SHIFT 16
#define  APB_CONFIG_USB2DEVHOST_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB2DEVHOST_REV1_RESERVED1_MASK) >> APB_CONFIG_USB2DEVHOST_REV1_RESERVED1_SHIFT)
#define  APB_CONFIG_USB2DEVHOST_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB2DEVHOST_REV1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_USB2DEVHOST_REV1_RESERVED1_SHIFT))

#define  APB_CONFIG_USB2DEVHOST_REV1_CFG_MASK 0xffff
#define  APB_CONFIG_USB2DEVHOST_REV1_CFG_SHIFT 0
#define  APB_CONFIG_USB2DEVHOST_REV1_CFG_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB2DEVHOST_REV1_CFG_MASK) >> APB_CONFIG_USB2DEVHOST_REV1_CFG_SHIFT)
#define  APB_CONFIG_USB2DEVHOST_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB2DEVHOST_REV1_CFG_MASK) | (((uint32_t)val) << APB_CONFIG_USB2DEVHOST_REV1_CFG_SHIFT))

//====================================================================
//Register: USB2TOP IP Tagging REV0 (USB2TOP_REV0)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  APB_CONFIG_USB2TOP_REV0_MAJ_MASK 0xffff0000
#define  APB_CONFIG_USB2TOP_REV0_MAJ_SHIFT 16
#define  APB_CONFIG_USB2TOP_REV0_MAJ_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB2TOP_REV0_MAJ_MASK) >> APB_CONFIG_USB2TOP_REV0_MAJ_SHIFT)
#define  APB_CONFIG_USB2TOP_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB2TOP_REV0_MAJ_MASK) | (((uint32_t)val) << APB_CONFIG_USB2TOP_REV0_MAJ_SHIFT))

#define  APB_CONFIG_USB2TOP_REV0_MID_MASK 0xffff
#define  APB_CONFIG_USB2TOP_REV0_MID_SHIFT 0
#define  APB_CONFIG_USB2TOP_REV0_MID_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB2TOP_REV0_MID_MASK) >> APB_CONFIG_USB2TOP_REV0_MID_SHIFT)
#define  APB_CONFIG_USB2TOP_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB2TOP_REV0_MID_MASK) | (((uint32_t)val) << APB_CONFIG_USB2TOP_REV0_MID_SHIFT))

//====================================================================
//Register: USB2TOP IP Tagging REV1 (USB2TOP_REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  APB_CONFIG_USB2TOP_REV1_RESERVED1_MASK 0xffff0000
#define  APB_CONFIG_USB2TOP_REV1_RESERVED1_SHIFT 16
#define  APB_CONFIG_USB2TOP_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB2TOP_REV1_RESERVED1_MASK) >> APB_CONFIG_USB2TOP_REV1_RESERVED1_SHIFT)
#define  APB_CONFIG_USB2TOP_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB2TOP_REV1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_USB2TOP_REV1_RESERVED1_SHIFT))

#define  APB_CONFIG_USB2TOP_REV1_CFG_MASK 0xffff
#define  APB_CONFIG_USB2TOP_REV1_CFG_SHIFT 0
#define  APB_CONFIG_USB2TOP_REV1_CFG_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB2TOP_REV1_CFG_MASK) >> APB_CONFIG_USB2TOP_REV1_CFG_SHIFT)
#define  APB_CONFIG_USB2TOP_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB2TOP_REV1_CFG_MASK) | (((uint32_t)val) << APB_CONFIG_USB2TOP_REV1_CFG_SHIFT))

//====================================================================
//Register: SATA IP Tagging REV0 (SATA_REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  APB_CONFIG_SATA_REV0_MAJ_MASK 0xffff0000
#define  APB_CONFIG_SATA_REV0_MAJ_SHIFT 16
#define  APB_CONFIG_SATA_REV0_MAJ_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SATA_REV0_MAJ_MASK) >> APB_CONFIG_SATA_REV0_MAJ_SHIFT)
#define  APB_CONFIG_SATA_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SATA_REV0_MAJ_MASK) | (((uint32_t)val) << APB_CONFIG_SATA_REV0_MAJ_SHIFT))

#define  APB_CONFIG_SATA_REV0_MID_MASK 0xffff
#define  APB_CONFIG_SATA_REV0_MID_SHIFT 0
#define  APB_CONFIG_SATA_REV0_MID_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SATA_REV0_MID_MASK) >> APB_CONFIG_SATA_REV0_MID_SHIFT)
#define  APB_CONFIG_SATA_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SATA_REV0_MID_MASK) | (((uint32_t)val) << APB_CONFIG_SATA_REV0_MID_SHIFT))

//====================================================================
//Register: SATA IP Tagging REV1 (SATA_REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  APB_CONFIG_SATA_REV1_RESERVED1_MASK 0xffff0000
#define  APB_CONFIG_SATA_REV1_RESERVED1_SHIFT 16
#define  APB_CONFIG_SATA_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SATA_REV1_RESERVED1_MASK) >> APB_CONFIG_SATA_REV1_RESERVED1_SHIFT)
#define  APB_CONFIG_SATA_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SATA_REV1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_SATA_REV1_RESERVED1_SHIFT))

#define  APB_CONFIG_SATA_REV1_CFG_MASK 0xffff
#define  APB_CONFIG_SATA_REV1_CFG_SHIFT 0
#define  APB_CONFIG_SATA_REV1_CFG_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SATA_REV1_CFG_MASK) >> APB_CONFIG_SATA_REV1_CFG_SHIFT)
#define  APB_CONFIG_SATA_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SATA_REV1_CFG_MASK) | (((uint32_t)val) << APB_CONFIG_SATA_REV1_CFG_SHIFT))

//====================================================================
//Register: SQU IP Tagging REV0 (SQU_REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  APB_CONFIG_SQU_REV0_MAJ_MASK 0xffff0000
#define  APB_CONFIG_SQU_REV0_MAJ_SHIFT 16
#define  APB_CONFIG_SQU_REV0_MAJ_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SQU_REV0_MAJ_MASK) >> APB_CONFIG_SQU_REV0_MAJ_SHIFT)
#define  APB_CONFIG_SQU_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SQU_REV0_MAJ_MASK) | (((uint32_t)val) << APB_CONFIG_SQU_REV0_MAJ_SHIFT))

#define  APB_CONFIG_SQU_REV0_MID_MASK 0xffff
#define  APB_CONFIG_SQU_REV0_MID_SHIFT 0
#define  APB_CONFIG_SQU_REV0_MID_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SQU_REV0_MID_MASK) >> APB_CONFIG_SQU_REV0_MID_SHIFT)
#define  APB_CONFIG_SQU_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SQU_REV0_MID_MASK) | (((uint32_t)val) << APB_CONFIG_SQU_REV0_MID_SHIFT))

//====================================================================
//Register: SQU IP Tagging REV1 (SQU_REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  APB_CONFIG_SQU_REV1_RESERVED1_MASK 0xffff0000
#define  APB_CONFIG_SQU_REV1_RESERVED1_SHIFT 16
#define  APB_CONFIG_SQU_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SQU_REV1_RESERVED1_MASK) >> APB_CONFIG_SQU_REV1_RESERVED1_SHIFT)
#define  APB_CONFIG_SQU_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SQU_REV1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_SQU_REV1_RESERVED1_SHIFT))

#define  APB_CONFIG_SQU_REV1_CFG_MASK 0xffff
#define  APB_CONFIG_SQU_REV1_CFG_SHIFT 0
#define  APB_CONFIG_SQU_REV1_CFG_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SQU_REV1_CFG_MASK) >> APB_CONFIG_SQU_REV1_CFG_SHIFT)
#define  APB_CONFIG_SQU_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SQU_REV1_CFG_MASK) | (((uint32_t)val) << APB_CONFIG_SQU_REV1_CFG_SHIFT))

//====================================================================
//Register: GC400 IP Tagging REV0 (GC400_REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  APB_CONFIG_GC400_REV0_MAJ_MASK 0xffff0000
#define  APB_CONFIG_GC400_REV0_MAJ_SHIFT 16
#define  APB_CONFIG_GC400_REV0_MAJ_MASK_SHIFT(reg) (((reg) & APB_CONFIG_GC400_REV0_MAJ_MASK) >> APB_CONFIG_GC400_REV0_MAJ_SHIFT)
#define  APB_CONFIG_GC400_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_GC400_REV0_MAJ_MASK) | (((uint32_t)val) << APB_CONFIG_GC400_REV0_MAJ_SHIFT))

#define  APB_CONFIG_GC400_REV0_MID_MASK 0xffff
#define  APB_CONFIG_GC400_REV0_MID_SHIFT 0
#define  APB_CONFIG_GC400_REV0_MID_MASK_SHIFT(reg) (((reg) & APB_CONFIG_GC400_REV0_MID_MASK) >> APB_CONFIG_GC400_REV0_MID_SHIFT)
#define  APB_CONFIG_GC400_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_GC400_REV0_MID_MASK) | (((uint32_t)val) << APB_CONFIG_GC400_REV0_MID_SHIFT))

//====================================================================
//Register: GC400 IP Tagging REV1 (GC400_REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  APB_CONFIG_GC400_REV1_RESERVED1_MASK 0xffff0000
#define  APB_CONFIG_GC400_REV1_RESERVED1_SHIFT 16
#define  APB_CONFIG_GC400_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_GC400_REV1_RESERVED1_MASK) >> APB_CONFIG_GC400_REV1_RESERVED1_SHIFT)
#define  APB_CONFIG_GC400_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_GC400_REV1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_GC400_REV1_RESERVED1_SHIFT))

#define  APB_CONFIG_GC400_REV1_CFG_MASK 0xffff
#define  APB_CONFIG_GC400_REV1_CFG_SHIFT 0
#define  APB_CONFIG_GC400_REV1_CFG_MASK_SHIFT(reg) (((reg) & APB_CONFIG_GC400_REV1_CFG_MASK) >> APB_CONFIG_GC400_REV1_CFG_SHIFT)
#define  APB_CONFIG_GC400_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_GC400_REV1_CFG_MASK) | (((uint32_t)val) << APB_CONFIG_GC400_REV1_CFG_SHIFT))

//====================================================================
//Register: PDMA IP Tagging REV0 (PDMA_REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  APB_CONFIG_PDMA_REV0_MAJ_MASK 0xffff0000
#define  APB_CONFIG_PDMA_REV0_MAJ_SHIFT 16
#define  APB_CONFIG_PDMA_REV0_MAJ_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PDMA_REV0_MAJ_MASK) >> APB_CONFIG_PDMA_REV0_MAJ_SHIFT)
#define  APB_CONFIG_PDMA_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PDMA_REV0_MAJ_MASK) | (((uint32_t)val) << APB_CONFIG_PDMA_REV0_MAJ_SHIFT))

#define  APB_CONFIG_PDMA_REV0_MID_MASK 0xffff
#define  APB_CONFIG_PDMA_REV0_MID_SHIFT 0
#define  APB_CONFIG_PDMA_REV0_MID_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PDMA_REV0_MID_MASK) >> APB_CONFIG_PDMA_REV0_MID_SHIFT)
#define  APB_CONFIG_PDMA_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PDMA_REV0_MID_MASK) | (((uint32_t)val) << APB_CONFIG_PDMA_REV0_MID_SHIFT))

//====================================================================
//Register: PDMA IP Tagging REV1 (PDMA_REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  APB_CONFIG_PDMA_REV1_RESERVED1_MASK 0xffff0000
#define  APB_CONFIG_PDMA_REV1_RESERVED1_SHIFT 16
#define  APB_CONFIG_PDMA_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PDMA_REV1_RESERVED1_MASK) >> APB_CONFIG_PDMA_REV1_RESERVED1_SHIFT)
#define  APB_CONFIG_PDMA_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PDMA_REV1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_PDMA_REV1_RESERVED1_SHIFT))

#define  APB_CONFIG_PDMA_REV1_CFG_MASK 0xffff
#define  APB_CONFIG_PDMA_REV1_CFG_SHIFT 0
#define  APB_CONFIG_PDMA_REV1_CFG_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PDMA_REV1_CFG_MASK) >> APB_CONFIG_PDMA_REV1_CFG_SHIFT)
#define  APB_CONFIG_PDMA_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PDMA_REV1_CFG_MASK) | (((uint32_t)val) << APB_CONFIG_PDMA_REV1_CFG_SHIFT))

//====================================================================
//Register: USB3_Host_Device (USB3HnD)
/** \brief Provide means for firmware to read USB3HnD fuse bit reset value and program the register for downstream driver.*/
//====================================================================

#define  APB_CONFIG_USB3HND_RESERVED1_MASK 0xfffffffe
#define  APB_CONFIG_USB3HND_RESERVED1_SHIFT 1
#define  APB_CONFIG_USB3HND_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB3HND_RESERVED1_MASK) >> APB_CONFIG_USB3HND_RESERVED1_SHIFT)
#define  APB_CONFIG_USB3HND_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB3HND_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_USB3HND_RESERVED1_SHIFT))

#define  APB_CONFIG_USB3HND_USB3HND_MASK 0x1
#define  APB_CONFIG_USB3HND_USB3HND_SHIFT 0
#define  APB_CONFIG_USB3HND_USB3HND_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB3HND_USB3HND_MASK) >> APB_CONFIG_USB3HND_USB3HND_SHIFT)
#define  APB_CONFIG_USB3HND_USB3HND_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB3HND_USB3HND_MASK) | (((uint32_t)val) << APB_CONFIG_USB3HND_USB3HND_SHIFT))

//====================================================================
//Register: Strap_in (strap_in)
/** \brief Provide means for firmware to read the 8-bit strap_in value.*/
//====================================================================

#define  APB_CONFIG_STRAP_IN_RESERVED1_MASK 0xffffff00
#define  APB_CONFIG_STRAP_IN_RESERVED1_SHIFT 8
#define  APB_CONFIG_STRAP_IN_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_STRAP_IN_RESERVED1_MASK) >> APB_CONFIG_STRAP_IN_RESERVED1_SHIFT)
#define  APB_CONFIG_STRAP_IN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_STRAP_IN_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_STRAP_IN_RESERVED1_SHIFT))

#define  APB_CONFIG_STRAP_IN_STRAP_IN_MASK 0xff
#define  APB_CONFIG_STRAP_IN_STRAP_IN_SHIFT 0
#define  APB_CONFIG_STRAP_IN_STRAP_IN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_STRAP_IN_STRAP_IN_MASK) >> APB_CONFIG_STRAP_IN_STRAP_IN_SHIFT)
#define  APB_CONFIG_STRAP_IN_STRAP_IN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_STRAP_IN_STRAP_IN_MASK) | (((uint32_t)val) << APB_CONFIG_STRAP_IN_STRAP_IN_SHIFT))

//====================================================================
//Register: Fuse_Bank0_R0 (Fuse_Bank0_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank0 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK0_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK0_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK0_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK0_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK0_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK0_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK0_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK0_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank0_R1 (Fuse_Bank0_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank0 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK0_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK0_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK0_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK0_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK0_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK0_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK0_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK0_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank0_R2 (Fuse_Bank0_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank0 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK0_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK0_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK0_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK0_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK0_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK0_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK0_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK0_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank0_R3 (Fuse_Bank0_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank0 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK0_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK0_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK0_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK0_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK0_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK0_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK0_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK0_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank0_R4 (Fuse_Bank0_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank0 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK0_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK0_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK0_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK0_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK0_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK0_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK0_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK0_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank0_R5 (Fuse_Bank0_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank0 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK0_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK0_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK0_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK0_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK0_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK0_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK0_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK0_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank0_R6 (Fuse_Bank0_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank0 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK0_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK0_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK0_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK0_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK0_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK0_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK0_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK0_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank0_R7 (Fuse_Bank0_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank0 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK0_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK0_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK0_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK0_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK0_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK0_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK0_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK0_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank0_R8 (Fuse_Bank0_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank0 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK0_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK0_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK0_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK0_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK0_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK0_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK0_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK0_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK0_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK0_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK0_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK0_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK0_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK0_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK0_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK0_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank1_R0 (Fuse_Bank1_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank1 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK1_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK1_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK1_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK1_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK1_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK1_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK1_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK1_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank1_R1 (Fuse_Bank1_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank1 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK1_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK1_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK1_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK1_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK1_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK1_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK1_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK1_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank1_R2 (Fuse_Bank1_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank1 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK1_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK1_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK1_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK1_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK1_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK1_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK1_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK1_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank1_R3 (Fuse_Bank1_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank1 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK1_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK1_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK1_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK1_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK1_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK1_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK1_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK1_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank1_R4 (Fuse_Bank1_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank1 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK1_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK1_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK1_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK1_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK1_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK1_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK1_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK1_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank1_R5 (Fuse_Bank1_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank1 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK1_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK1_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK1_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK1_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK1_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK1_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK1_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK1_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank1_R6 (Fuse_Bank1_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank1 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK1_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK1_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK1_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK1_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK1_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK1_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK1_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK1_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank1_R7 (Fuse_Bank1_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank1 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK1_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK1_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK1_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK1_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK1_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK1_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK1_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK1_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank1_R8 (Fuse_Bank1_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank1 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK1_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK1_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK1_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK1_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK1_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK1_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK1_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK1_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK1_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK1_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK1_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK1_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK1_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK1_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK1_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK1_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank2_R0 (Fuse_Bank2_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank2 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK2_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK2_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK2_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK2_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK2_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK2_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK2_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK2_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank2_R1 (Fuse_Bank2_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank2 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK2_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK2_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK2_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK2_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK2_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK2_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK2_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK2_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank2_R2 (Fuse_Bank2_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank2 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK2_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK2_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK2_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK2_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK2_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK2_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK2_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK2_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank2_R3 (Fuse_Bank2_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank2 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK2_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK2_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK2_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK2_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK2_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK2_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK2_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK2_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank2_R4 (Fuse_Bank2_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank2 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK2_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK2_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK2_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK2_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK2_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK2_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK2_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK2_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank2_R5 (Fuse_Bank2_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank2 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK2_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK2_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK2_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK2_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK2_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK2_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK2_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK2_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank2_R6 (Fuse_Bank2_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank2 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK2_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK2_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK2_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK2_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK2_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK2_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK2_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK2_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank2_R7 (Fuse_Bank2_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank2 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK2_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK2_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK2_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK2_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK2_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK2_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK2_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK2_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank2_R8 (Fuse_Bank2_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank2 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK2_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK2_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK2_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK2_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK2_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK2_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK2_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK2_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK2_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK2_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK2_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK2_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK2_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK2_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK2_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK2_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank3_R0 (Fuse_Bank3_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank3 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK3_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK3_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK3_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK3_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK3_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK3_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK3_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK3_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank3_R1 (Fuse_Bank3_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank3 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK3_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK3_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK3_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK3_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK3_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK3_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK3_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK3_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank3_R2 (Fuse_Bank3_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank3 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK3_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK3_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK3_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK3_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK3_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK3_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK3_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK3_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank3_R3 (Fuse_Bank3_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank3 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK3_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK3_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK3_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK3_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK3_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK3_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK3_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK3_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank3_R4 (Fuse_Bank3_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank3 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK3_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK3_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK3_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK3_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK3_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK3_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK3_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK3_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank3_R5 (Fuse_Bank3_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank3 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK3_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK3_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK3_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK3_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK3_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK3_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK3_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK3_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank3_R6 (Fuse_Bank3_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank3 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK3_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK3_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK3_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK3_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK3_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK3_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK3_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK3_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank3_R7 (Fuse_Bank3_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank3 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK3_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK3_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK3_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK3_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK3_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK3_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK3_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK3_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank3_R8 (Fuse_Bank3_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank3 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK3_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK3_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK3_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK3_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK3_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK3_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK3_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK3_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK3_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK3_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK3_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK3_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK3_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK3_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK3_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK3_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank4_R0 (Fuse_Bank4_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank4 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK4_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK4_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK4_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK4_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK4_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK4_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK4_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK4_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank4_R1 (Fuse_Bank4_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank4 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK4_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK4_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK4_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK4_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK4_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK4_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK4_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK4_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank4_R2 (Fuse_Bank4_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank4 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK4_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK4_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK4_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK4_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK4_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK4_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK4_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK4_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank4_R3 (Fuse_Bank4_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank4 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK4_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK4_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK4_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK4_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK4_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK4_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK4_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK4_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank4_R4 (Fuse_Bank4_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank4 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK4_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK4_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK4_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK4_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK4_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK4_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK4_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK4_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank4_R5 (Fuse_Bank4_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank4 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK4_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK4_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK4_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK4_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK4_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK4_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK4_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK4_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank4_R6 (Fuse_Bank4_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank4 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK4_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK4_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK4_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK4_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK4_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK4_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK4_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK4_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank4_R7 (Fuse_Bank4_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank4 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK4_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK4_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK4_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK4_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK4_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK4_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK4_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK4_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank4_R8 (Fuse_Bank4_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank4 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK4_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK4_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK4_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK4_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK4_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK4_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK4_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK4_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK4_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK4_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK4_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK4_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK4_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK4_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK4_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK4_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank5_R0 (Fuse_Bank5_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank5 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK5_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK5_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK5_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK5_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK5_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK5_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK5_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK5_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank5_R1 (Fuse_Bank5_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank5 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK5_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK5_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK5_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK5_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK5_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK5_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK5_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK5_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank5_R2 (Fuse_Bank5_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank5 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK5_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK5_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK5_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK5_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK5_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK5_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK5_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK5_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank5_R3 (Fuse_Bank5_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank5 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK5_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK5_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK5_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK5_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK5_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK5_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK5_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK5_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank5_R4 (Fuse_Bank5_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank5 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK5_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK5_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK5_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK5_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK5_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK5_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK5_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK5_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank5_R5 (Fuse_Bank5_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank5 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK5_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK5_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK5_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK5_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK5_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK5_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK5_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK5_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank5_R6 (Fuse_Bank5_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank5 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK5_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK5_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK5_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK5_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK5_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK5_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK5_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK5_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank5_R7 (Fuse_Bank5_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank5 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK5_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK5_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK5_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK5_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK5_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK5_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK5_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK5_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank5_R8 (Fuse_Bank5_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank5 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK5_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK5_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK5_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK5_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK5_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK5_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK5_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK5_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK5_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK5_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK5_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK5_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK5_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK5_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK5_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK5_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank6_R0 (Fuse_Bank6_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank6 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK6_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK6_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK6_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK6_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK6_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK6_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK6_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK6_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank6_R1 (Fuse_Bank6_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank6 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK6_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK6_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK6_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK6_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK6_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK6_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK6_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK6_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank6_R2 (Fuse_Bank6_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank6 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK6_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK6_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK6_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK6_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK6_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK6_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK6_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK6_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank6_R3 (Fuse_Bank6_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank6 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK6_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK6_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK6_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK6_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK6_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK6_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK6_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK6_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank6_R4 (Fuse_Bank6_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank6 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK6_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK6_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK6_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK6_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK6_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK6_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK6_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK6_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank6_R5 (Fuse_Bank6_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank6 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK6_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK6_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK6_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK6_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK6_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK6_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK6_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK6_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank6_R6 (Fuse_Bank6_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank6 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK6_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK6_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK6_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK6_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK6_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK6_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK6_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK6_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank6_R7 (Fuse_Bank6_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank6 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK6_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK6_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK6_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK6_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK6_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK6_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK6_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK6_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank6_R8 (Fuse_Bank6_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank6 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK6_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK6_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK6_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK6_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK6_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK6_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK6_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK6_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK6_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK6_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK6_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK6_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK6_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK6_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK6_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK6_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank7_R0 (Fuse_Bank7_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank7 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK7_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK7_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK7_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK7_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK7_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK7_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK7_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK7_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank7_R1 (Fuse_Bank7_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank7 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK7_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK7_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK7_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK7_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK7_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK7_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK7_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK7_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank7_R2 (Fuse_Bank7_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank7 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK7_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK7_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK7_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK7_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK7_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK7_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK7_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK7_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank7_R3 (Fuse_Bank7_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank7 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK7_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK7_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK7_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK7_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK7_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK7_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK7_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK7_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank7_R4 (Fuse_Bank7_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank7 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK7_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK7_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK7_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK7_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK7_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK7_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK7_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK7_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank7_R5 (Fuse_Bank7_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank7 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK7_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK7_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK7_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK7_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK7_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK7_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK7_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK7_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank7_R6 (Fuse_Bank7_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank7 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK7_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK7_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK7_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK7_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK7_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK7_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK7_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK7_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank7_R7 (Fuse_Bank7_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank7 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK7_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK7_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK7_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK7_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK7_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK7_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK7_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK7_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank7_R8 (Fuse_Bank7_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank7 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK7_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK7_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK7_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK7_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK7_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK7_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK7_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK7_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK7_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK7_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK7_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK7_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK7_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK7_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK7_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK7_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank8_R0 (Fuse_Bank8_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank8 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK8_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK8_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK8_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK8_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK8_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK8_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK8_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK8_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank8_R1 (Fuse_Bank8_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank8 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK8_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK8_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK8_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK8_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK8_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK8_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK8_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK8_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank8_R2 (Fuse_Bank8_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank8 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK8_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK8_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK8_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK8_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK8_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK8_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK8_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK8_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank8_R3 (Fuse_Bank8_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank8 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK8_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK8_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK8_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK8_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK8_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK8_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK8_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK8_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank8_R4 (Fuse_Bank8_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank8 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK8_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK8_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK8_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK8_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK8_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK8_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK8_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK8_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank8_R5 (Fuse_Bank8_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank8 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK8_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK8_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK8_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK8_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK8_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK8_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK8_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK8_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank8_R6 (Fuse_Bank8_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank8 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK8_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK8_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK8_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK8_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK8_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK8_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK8_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK8_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank8_R7 (Fuse_Bank8_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank8 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK8_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK8_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK8_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK8_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK8_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK8_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK8_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK8_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank8_R8 (Fuse_Bank8_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank8 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK8_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK8_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK8_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK8_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK8_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK8_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK8_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK8_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK8_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK8_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK8_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK8_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK8_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK8_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK8_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK8_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank9_R0 (Fuse_Bank9_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank9 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK9_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK9_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK9_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK9_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK9_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK9_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK9_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK9_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank9_R1 (Fuse_Bank9_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank9 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK9_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK9_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK9_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK9_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK9_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK9_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK9_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK9_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank9_R2 (Fuse_Bank9_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank9 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK9_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK9_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK9_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK9_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK9_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK9_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK9_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK9_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank9_R3 (Fuse_Bank9_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank9 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK9_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK9_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK9_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK9_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK9_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK9_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK9_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK9_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank9_R4 (Fuse_Bank9_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank9 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK9_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK9_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK9_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK9_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK9_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK9_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK9_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK9_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank9_R5 (Fuse_Bank9_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank9 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK9_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK9_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK9_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK9_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK9_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK9_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK9_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK9_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank9_R6 (Fuse_Bank9_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank9 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK9_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK9_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK9_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK9_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK9_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK9_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK9_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK9_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank9_R7 (Fuse_Bank9_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank9 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK9_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK9_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK9_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK9_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK9_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK9_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK9_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK9_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank9_R8 (Fuse_Bank9_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank9 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK9_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK9_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK9_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK9_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK9_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK9_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK9_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK9_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK9_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK9_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK9_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK9_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK9_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK9_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK9_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK9_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank10_R0 (Fuse_Bank10_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank10 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK10_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK10_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK10_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK10_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK10_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK10_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK10_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK10_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank10_R1 (Fuse_Bank10_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank10 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK10_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK10_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK10_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK10_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK10_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK10_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK10_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK10_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank10_R2 (Fuse_Bank10_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank10 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK10_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK10_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK10_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK10_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK10_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK10_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK10_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK10_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank10_R3 (Fuse_Bank10_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank10 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK10_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK10_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK10_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK10_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK10_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK10_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK10_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK10_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank10_R4 (Fuse_Bank10_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank10 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK10_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK10_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK10_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK10_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK10_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK10_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK10_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK10_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank10_R5 (Fuse_Bank10_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank10 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK10_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK10_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK10_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK10_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK10_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK10_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK10_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK10_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank10_R6 (Fuse_Bank10_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank10 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK10_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK10_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK10_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK10_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK10_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK10_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK10_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK10_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank10_R7 (Fuse_Bank10_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank10 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK10_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK10_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK10_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK10_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK10_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK10_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK10_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK10_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank10_R8 (Fuse_Bank10_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank10 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK10_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK10_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK10_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK10_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK10_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK10_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK10_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK10_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK10_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK10_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK10_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK10_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK10_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK10_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK10_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK10_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank11_R0 (Fuse_Bank11_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank11 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK11_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK11_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK11_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK11_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK11_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK11_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK11_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK11_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank11_R1 (Fuse_Bank11_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank11 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK11_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK11_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK11_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK11_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK11_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK11_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK11_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK11_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank11_R2 (Fuse_Bank11_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank11 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK11_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK11_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK11_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK11_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK11_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK11_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK11_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK11_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank11_R3 (Fuse_Bank11_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank11 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK11_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK11_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK11_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK11_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK11_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK11_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK11_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK11_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank11_R4 (Fuse_Bank11_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank11 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK11_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK11_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK11_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK11_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK11_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK11_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK11_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK11_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank11_R5 (Fuse_Bank11_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank11 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK11_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK11_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK11_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK11_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK11_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK11_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK11_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK11_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank11_R6 (Fuse_Bank11_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank11 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK11_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK11_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK11_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK11_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK11_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK11_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK11_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK11_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank11_R7 (Fuse_Bank11_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank11 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK11_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK11_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK11_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK11_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK11_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK11_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK11_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK11_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank11_R8 (Fuse_Bank11_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank11 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK11_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK11_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK11_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK11_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK11_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK11_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK11_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK11_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK11_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK11_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK11_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK11_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK11_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK11_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK11_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK11_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank12_R0 (Fuse_Bank12_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank12 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK12_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK12_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK12_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK12_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK12_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK12_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK12_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK12_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank12_R1 (Fuse_Bank12_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank12 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK12_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK12_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK12_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK12_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK12_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK12_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK12_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK12_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank12_R2 (Fuse_Bank12_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank12 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK12_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK12_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK12_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK12_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK12_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK12_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK12_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK12_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank12_R3 (Fuse_Bank12_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank12 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK12_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK12_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK12_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK12_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK12_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK12_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK12_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK12_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank12_R4 (Fuse_Bank12_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank12 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK12_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK12_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK12_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK12_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK12_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK12_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK12_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK12_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank12_R5 (Fuse_Bank12_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank12 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK12_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK12_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK12_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK12_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK12_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK12_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK12_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK12_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank12_R6 (Fuse_Bank12_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank12 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK12_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK12_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK12_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK12_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK12_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK12_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK12_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK12_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank12_R7 (Fuse_Bank12_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank12 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK12_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK12_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK12_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK12_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK12_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK12_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK12_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK12_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank12_R8 (Fuse_Bank12_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank12 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK12_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK12_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK12_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK12_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK12_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK12_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK12_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK12_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK12_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK12_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK12_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK12_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK12_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK12_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK12_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK12_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank13_R0 (Fuse_Bank13_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank13 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK13_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK13_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK13_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK13_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK13_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK13_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK13_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK13_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank13_R1 (Fuse_Bank13_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank13 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK13_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK13_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK13_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK13_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK13_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK13_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK13_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK13_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank13_R2 (Fuse_Bank13_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank13 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK13_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK13_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK13_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK13_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK13_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK13_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK13_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK13_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank13_R3 (Fuse_Bank13_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank13 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK13_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK13_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK13_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK13_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK13_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK13_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK13_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK13_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank13_R4 (Fuse_Bank13_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank13 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK13_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK13_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK13_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK13_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK13_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK13_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK13_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK13_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank13_R5 (Fuse_Bank13_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank13 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK13_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK13_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK13_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK13_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK13_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK13_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK13_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK13_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank13_R6 (Fuse_Bank13_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank13 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK13_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK13_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK13_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK13_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK13_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK13_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK13_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK13_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank13_R7 (Fuse_Bank13_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank13 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK13_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK13_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK13_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK13_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK13_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK13_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK13_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK13_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank13_R8 (Fuse_Bank13_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank13 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK13_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK13_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK13_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK13_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK13_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK13_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK13_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK13_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK13_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK13_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK13_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK13_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK13_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK13_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK13_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK13_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank14_R0 (Fuse_Bank14_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank14 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK14_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK14_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK14_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK14_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK14_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK14_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK14_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK14_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank14_R1 (Fuse_Bank14_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank14 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK14_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK14_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK14_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK14_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK14_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK14_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK14_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK14_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank14_R2 (Fuse_Bank14_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank14 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK14_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK14_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK14_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK14_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK14_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK14_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK14_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK14_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank14_R3 (Fuse_Bank14_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank14 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK14_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK14_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK14_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK14_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK14_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK14_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK14_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK14_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank14_R4 (Fuse_Bank14_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank14 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK14_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK14_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK14_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK14_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK14_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK14_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK14_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK14_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank14_R5 (Fuse_Bank14_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank14 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK14_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK14_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK14_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK14_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK14_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK14_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK14_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK14_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank14_R6 (Fuse_Bank14_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank14 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK14_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK14_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK14_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK14_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK14_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK14_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK14_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK14_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank14_R7 (Fuse_Bank14_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank14 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK14_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK14_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK14_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK14_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK14_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK14_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK14_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK14_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank14_R8 (Fuse_Bank14_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank14 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK14_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK14_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK14_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK14_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK14_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK14_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK14_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK14_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK14_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK14_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK14_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK14_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK14_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK14_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK14_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK14_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank15_R0 (Fuse_Bank15_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank15 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK15_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK15_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK15_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK15_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK15_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK15_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK15_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK15_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank15_R1 (Fuse_Bank15_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank15 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK15_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK15_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK15_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK15_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK15_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK15_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK15_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK15_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank15_R2 (Fuse_Bank15_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank15 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK15_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK15_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK15_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK15_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK15_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK15_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK15_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK15_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank15_R3 (Fuse_Bank15_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank15 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK15_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK15_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK15_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK15_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK15_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK15_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK15_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK15_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank15_R4 (Fuse_Bank15_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank15 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK15_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK15_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK15_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK15_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK15_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK15_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK15_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK15_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank15_R5 (Fuse_Bank15_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank15 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK15_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK15_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK15_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK15_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK15_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK15_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK15_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK15_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank15_R6 (Fuse_Bank15_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank15 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK15_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK15_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK15_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK15_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK15_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK15_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK15_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK15_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank15_R7 (Fuse_Bank15_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank15 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK15_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK15_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK15_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK15_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK15_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK15_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK15_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK15_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank15_R8 (Fuse_Bank15_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank15 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK15_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK15_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK15_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK15_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK15_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK15_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK15_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK15_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK15_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK15_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK15_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK15_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK15_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK15_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK15_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK15_R8_FUSE_VALUE_SHIFT))

//====================================================================
//
//Register File: AIB Non Secure Registers - Padring (Padring)
/** \brief This register set includes all the registers for the padring I/O configuration*/
//
//====================================================================

//====================================================================
//
//Register File: AIB Non Secure Registers - AIB Extra Registers (AIB_Extra_Regs)
/** \brief This register set includes all the AIB registers for pad section control*/
//
//====================================================================

//====================================================================
//Register: G3 Padsection ZP/ZN Register (G3_ZPZN)
/** \brief This register is used to control the ZP/ZN settinings for pads in the G3 pad section.*/
//====================================================================

#define  AIB_EXTRA_REGS_G3_ZPZN_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_REGS_G3_ZPZN_RESERVED1_SHIFT 8
#define  AIB_EXTRA_REGS_G3_ZPZN_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_G3_ZPZN_RESERVED1_MASK) >> AIB_EXTRA_REGS_G3_ZPZN_RESERVED1_SHIFT)
#define  AIB_EXTRA_REGS_G3_ZPZN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_G3_ZPZN_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_G3_ZPZN_RESERVED1_SHIFT))

#define  AIB_EXTRA_REGS_G3_ZPZN_ZN_MASK 0xf0
#define  AIB_EXTRA_REGS_G3_ZPZN_ZN_SHIFT 4
#define  AIB_EXTRA_REGS_G3_ZPZN_ZN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_G3_ZPZN_ZN_MASK) >> AIB_EXTRA_REGS_G3_ZPZN_ZN_SHIFT)
#define  AIB_EXTRA_REGS_G3_ZPZN_ZN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_G3_ZPZN_ZN_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_G3_ZPZN_ZN_SHIFT))

#define  AIB_EXTRA_REGS_G3_ZPZN_ZP_MASK 0xf
#define  AIB_EXTRA_REGS_G3_ZPZN_ZP_SHIFT 0
#define  AIB_EXTRA_REGS_G3_ZPZN_ZP_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_G3_ZPZN_ZP_MASK) >> AIB_EXTRA_REGS_G3_ZPZN_ZP_SHIFT)
#define  AIB_EXTRA_REGS_G3_ZPZN_ZP_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_G3_ZPZN_ZP_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_G3_ZPZN_ZP_SHIFT))

//====================================================================
//Register: G4 Padsection ZP/ZN Register (G4_ZPZN)
/** \brief This register is used to control the ZP/ZN settinings for pads in the G4 pad section.*/
//====================================================================

#define  AIB_EXTRA_REGS_G4_ZPZN_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_REGS_G4_ZPZN_RESERVED1_SHIFT 8
#define  AIB_EXTRA_REGS_G4_ZPZN_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_G4_ZPZN_RESERVED1_MASK) >> AIB_EXTRA_REGS_G4_ZPZN_RESERVED1_SHIFT)
#define  AIB_EXTRA_REGS_G4_ZPZN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_G4_ZPZN_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_G4_ZPZN_RESERVED1_SHIFT))

#define  AIB_EXTRA_REGS_G4_ZPZN_ZN_MASK 0xf0
#define  AIB_EXTRA_REGS_G4_ZPZN_ZN_SHIFT 4
#define  AIB_EXTRA_REGS_G4_ZPZN_ZN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_G4_ZPZN_ZN_MASK) >> AIB_EXTRA_REGS_G4_ZPZN_ZN_SHIFT)
#define  AIB_EXTRA_REGS_G4_ZPZN_ZN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_G4_ZPZN_ZN_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_G4_ZPZN_ZN_SHIFT))

#define  AIB_EXTRA_REGS_G4_ZPZN_ZP_MASK 0xf
#define  AIB_EXTRA_REGS_G4_ZPZN_ZP_SHIFT 0
#define  AIB_EXTRA_REGS_G4_ZPZN_ZP_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_G4_ZPZN_ZP_MASK) >> AIB_EXTRA_REGS_G4_ZPZN_ZP_SHIFT)
#define  AIB_EXTRA_REGS_G4_ZPZN_ZP_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_G4_ZPZN_ZP_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_G4_ZPZN_ZP_SHIFT))

//====================================================================
//Register: G6 Padsection ZP/ZN Register (G6_ZPZN)
/** \brief This register is used to control the ZP/ZN settinings for pads in the G6 pad section.*/
//====================================================================

#define  AIB_EXTRA_REGS_G6_ZPZN_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_REGS_G6_ZPZN_RESERVED1_SHIFT 8
#define  AIB_EXTRA_REGS_G6_ZPZN_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_G6_ZPZN_RESERVED1_MASK) >> AIB_EXTRA_REGS_G6_ZPZN_RESERVED1_SHIFT)
#define  AIB_EXTRA_REGS_G6_ZPZN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_G6_ZPZN_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_G6_ZPZN_RESERVED1_SHIFT))

#define  AIB_EXTRA_REGS_G6_ZPZN_ZN_MASK 0xf0
#define  AIB_EXTRA_REGS_G6_ZPZN_ZN_SHIFT 4
#define  AIB_EXTRA_REGS_G6_ZPZN_ZN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_G6_ZPZN_ZN_MASK) >> AIB_EXTRA_REGS_G6_ZPZN_ZN_SHIFT)
#define  AIB_EXTRA_REGS_G6_ZPZN_ZN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_G6_ZPZN_ZN_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_G6_ZPZN_ZN_SHIFT))

#define  AIB_EXTRA_REGS_G6_ZPZN_ZP_MASK 0xf
#define  AIB_EXTRA_REGS_G6_ZPZN_ZP_SHIFT 0
#define  AIB_EXTRA_REGS_G6_ZPZN_ZP_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_G6_ZPZN_ZP_MASK) >> AIB_EXTRA_REGS_G6_ZPZN_ZP_SHIFT)
#define  AIB_EXTRA_REGS_G6_ZPZN_ZP_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_G6_ZPZN_ZP_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_G6_ZPZN_ZP_SHIFT))

//====================================================================
//Register: G7 Padsection ZP/ZN Register (G7_ZPZN)
/** \brief This register is used to control the ZP/ZN settinings for pads in the G7 pad section.*/
//====================================================================

#define  AIB_EXTRA_REGS_G7_ZPZN_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_REGS_G7_ZPZN_RESERVED1_SHIFT 8
#define  AIB_EXTRA_REGS_G7_ZPZN_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_G7_ZPZN_RESERVED1_MASK) >> AIB_EXTRA_REGS_G7_ZPZN_RESERVED1_SHIFT)
#define  AIB_EXTRA_REGS_G7_ZPZN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_G7_ZPZN_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_G7_ZPZN_RESERVED1_SHIFT))

#define  AIB_EXTRA_REGS_G7_ZPZN_ZN_MASK 0xf0
#define  AIB_EXTRA_REGS_G7_ZPZN_ZN_SHIFT 4
#define  AIB_EXTRA_REGS_G7_ZPZN_ZN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_G7_ZPZN_ZN_MASK) >> AIB_EXTRA_REGS_G7_ZPZN_ZN_SHIFT)
#define  AIB_EXTRA_REGS_G7_ZPZN_ZN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_G7_ZPZN_ZN_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_G7_ZPZN_ZN_SHIFT))

#define  AIB_EXTRA_REGS_G7_ZPZN_ZP_MASK 0xf
#define  AIB_EXTRA_REGS_G7_ZPZN_ZP_SHIFT 0
#define  AIB_EXTRA_REGS_G7_ZPZN_ZP_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_G7_ZPZN_ZP_MASK) >> AIB_EXTRA_REGS_G7_ZPZN_ZP_SHIFT)
#define  AIB_EXTRA_REGS_G7_ZPZN_ZP_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_G7_ZPZN_ZP_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_G7_ZPZN_ZP_SHIFT))

//====================================================================
//Register: G8 Padsection ZP/ZN Register (G8_ZPZN)
/** \brief This register is used to control the ZP/ZN settinings for pads in the G8 pad section.*/
//====================================================================

#define  AIB_EXTRA_REGS_G8_ZPZN_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_REGS_G8_ZPZN_RESERVED1_SHIFT 8
#define  AIB_EXTRA_REGS_G8_ZPZN_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_G8_ZPZN_RESERVED1_MASK) >> AIB_EXTRA_REGS_G8_ZPZN_RESERVED1_SHIFT)
#define  AIB_EXTRA_REGS_G8_ZPZN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_G8_ZPZN_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_G8_ZPZN_RESERVED1_SHIFT))

#define  AIB_EXTRA_REGS_G8_ZPZN_ZN_MASK 0xf0
#define  AIB_EXTRA_REGS_G8_ZPZN_ZN_SHIFT 4
#define  AIB_EXTRA_REGS_G8_ZPZN_ZN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_G8_ZPZN_ZN_MASK) >> AIB_EXTRA_REGS_G8_ZPZN_ZN_SHIFT)
#define  AIB_EXTRA_REGS_G8_ZPZN_ZN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_G8_ZPZN_ZN_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_G8_ZPZN_ZN_SHIFT))

#define  AIB_EXTRA_REGS_G8_ZPZN_ZP_MASK 0xf
#define  AIB_EXTRA_REGS_G8_ZPZN_ZP_SHIFT 0
#define  AIB_EXTRA_REGS_G8_ZPZN_ZP_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_G8_ZPZN_ZP_MASK) >> AIB_EXTRA_REGS_G8_ZPZN_ZP_SHIFT)
#define  AIB_EXTRA_REGS_G8_ZPZN_ZP_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_G8_ZPZN_ZP_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_G8_ZPZN_ZP_SHIFT))

//====================================================================
//Register: G9 Padsection ZP/ZN Register (G9_ZPZN)
/** \brief This register is used to control the ZP/ZN settinings for pads in the G9 pad section.*/
//====================================================================

#define  AIB_EXTRA_REGS_G9_ZPZN_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_REGS_G9_ZPZN_RESERVED1_SHIFT 8
#define  AIB_EXTRA_REGS_G9_ZPZN_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_G9_ZPZN_RESERVED1_MASK) >> AIB_EXTRA_REGS_G9_ZPZN_RESERVED1_SHIFT)
#define  AIB_EXTRA_REGS_G9_ZPZN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_G9_ZPZN_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_G9_ZPZN_RESERVED1_SHIFT))

#define  AIB_EXTRA_REGS_G9_ZPZN_ZN_MASK 0xf0
#define  AIB_EXTRA_REGS_G9_ZPZN_ZN_SHIFT 4
#define  AIB_EXTRA_REGS_G9_ZPZN_ZN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_G9_ZPZN_ZN_MASK) >> AIB_EXTRA_REGS_G9_ZPZN_ZN_SHIFT)
#define  AIB_EXTRA_REGS_G9_ZPZN_ZN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_G9_ZPZN_ZN_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_G9_ZPZN_ZN_SHIFT))

#define  AIB_EXTRA_REGS_G9_ZPZN_ZP_MASK 0xf
#define  AIB_EXTRA_REGS_G9_ZPZN_ZP_SHIFT 0
#define  AIB_EXTRA_REGS_G9_ZPZN_ZP_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_G9_ZPZN_ZP_MASK) >> AIB_EXTRA_REGS_G9_ZPZN_ZP_SHIFT)
#define  AIB_EXTRA_REGS_G9_ZPZN_ZP_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_G9_ZPZN_ZP_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_G9_ZPZN_ZP_SHIFT))

//====================================================================
//Register: G11 Padsection ZP/ZN Register (G11_ZPZN)
/** \brief This register is used to control the ZP/ZN settinings for pads in the G11 pad section.*/
//====================================================================

#define  AIB_EXTRA_REGS_G11_ZPZN_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_REGS_G11_ZPZN_RESERVED1_SHIFT 8
#define  AIB_EXTRA_REGS_G11_ZPZN_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_G11_ZPZN_RESERVED1_MASK) >> AIB_EXTRA_REGS_G11_ZPZN_RESERVED1_SHIFT)
#define  AIB_EXTRA_REGS_G11_ZPZN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_G11_ZPZN_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_G11_ZPZN_RESERVED1_SHIFT))

#define  AIB_EXTRA_REGS_G11_ZPZN_ZN_MASK 0xf0
#define  AIB_EXTRA_REGS_G11_ZPZN_ZN_SHIFT 4
#define  AIB_EXTRA_REGS_G11_ZPZN_ZN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_G11_ZPZN_ZN_MASK) >> AIB_EXTRA_REGS_G11_ZPZN_ZN_SHIFT)
#define  AIB_EXTRA_REGS_G11_ZPZN_ZN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_G11_ZPZN_ZN_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_G11_ZPZN_ZN_SHIFT))

#define  AIB_EXTRA_REGS_G11_ZPZN_ZP_MASK 0xf
#define  AIB_EXTRA_REGS_G11_ZPZN_ZP_SHIFT 0
#define  AIB_EXTRA_REGS_G11_ZPZN_ZP_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_G11_ZPZN_ZP_MASK) >> AIB_EXTRA_REGS_G11_ZPZN_ZP_SHIFT)
#define  AIB_EXTRA_REGS_G11_ZPZN_ZP_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_G11_ZPZN_ZP_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_G11_ZPZN_ZP_SHIFT))

//====================================================================
//Register: V18EN control per pad section Register (V18EN)
/** \brief This register is used to control the 1.8v enable for the various pad sections that can be switched from 3.3v to 1.8v.*/
//====================================================================

#define  AIB_EXTRA_REGS_V18EN_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_REGS_V18EN_RESERVED1_SHIFT 8
#define  AIB_EXTRA_REGS_V18EN_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_V18EN_RESERVED1_MASK) >> AIB_EXTRA_REGS_V18EN_RESERVED1_SHIFT)
#define  AIB_EXTRA_REGS_V18EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_V18EN_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_V18EN_RESERVED1_SHIFT))

#define  AIB_EXTRA_REGS_V18EN_NOTUSED_MASK 0xf0
#define  AIB_EXTRA_REGS_V18EN_NOTUSED_SHIFT 4
#define  AIB_EXTRA_REGS_V18EN_NOTUSED_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_V18EN_NOTUSED_MASK) >> AIB_EXTRA_REGS_V18EN_NOTUSED_SHIFT)
#define  AIB_EXTRA_REGS_V18EN_NOTUSED_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_V18EN_NOTUSED_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_V18EN_NOTUSED_SHIFT))

#define  AIB_EXTRA_REGS_V18EN_G11_V18EN_MASK 0x8
#define  AIB_EXTRA_REGS_V18EN_G11_V18EN_SHIFT 3
#define  AIB_EXTRA_REGS_V18EN_G11_V18EN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_V18EN_G11_V18EN_MASK) >> AIB_EXTRA_REGS_V18EN_G11_V18EN_SHIFT)
#define  AIB_EXTRA_REGS_V18EN_G11_V18EN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_V18EN_G11_V18EN_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_V18EN_G11_V18EN_SHIFT))

#define  AIB_EXTRA_REGS_V18EN_G10_V18EN_MASK 0x4
#define  AIB_EXTRA_REGS_V18EN_G10_V18EN_SHIFT 2
#define  AIB_EXTRA_REGS_V18EN_G10_V18EN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_V18EN_G10_V18EN_MASK) >> AIB_EXTRA_REGS_V18EN_G10_V18EN_SHIFT)
#define  AIB_EXTRA_REGS_V18EN_G10_V18EN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_V18EN_G10_V18EN_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_V18EN_G10_V18EN_SHIFT))

#define  AIB_EXTRA_REGS_V18EN_G5_V18EN_MASK 0x2
#define  AIB_EXTRA_REGS_V18EN_G5_V18EN_SHIFT 1
#define  AIB_EXTRA_REGS_V18EN_G5_V18EN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_V18EN_G5_V18EN_MASK) >> AIB_EXTRA_REGS_V18EN_G5_V18EN_SHIFT)
#define  AIB_EXTRA_REGS_V18EN_G5_V18EN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_V18EN_G5_V18EN_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_V18EN_G5_V18EN_SHIFT))

#define  AIB_EXTRA_REGS_V18EN_G4_V18EN_MASK 0x1
#define  AIB_EXTRA_REGS_V18EN_G4_V18EN_SHIFT 0
#define  AIB_EXTRA_REGS_V18EN_G4_V18EN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_V18EN_G4_V18EN_MASK) >> AIB_EXTRA_REGS_V18EN_G4_V18EN_SHIFT)
#define  AIB_EXTRA_REGS_V18EN_G4_V18EN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_V18EN_G4_V18EN_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_V18EN_G4_V18EN_SHIFT))

//====================================================================
//Register: VSensor01 Control Register (VSensor01)
/** \brief This register is used to control the Vsensor Pad in the G3 pad section. <br>
 VSENSOR Truth Table
 <table>
  <tr>
    <th>LOW_VDDB</th><th>BYPASS</th><th>DISABLE</th><th>VSENSOR</th><th>Vsensor LATCH output</th><th>V18EN_Ring</th>
  </tr>
  <tr>
   <td>0</td><td>X</td><td>X</td><td>Enabled and NOT bypassed</td><td>Driven by VSENSOR:<br/>0 if VDD gt 2.3v<br/>1 if VDD lt 2.3v</td><td>Follow Vsensor</td>
  </tr>
  <tr>
   <td>1</td><td>0</td><td>0</td><td>Enabled and NOT bypassed</td><td>Driven by VSENSOR:<br>0 if VDD gt 2.3v<br>1 if VDD lt 2.3v</td><td>Follow Vsensor</td>
  </tr>
  <tr>
   <td>1</td><td>1</td><td>0</td><td>Enabled but bypassed</td><td>Driven by VSENSOR:<br>0 if VDD gt 2.3v<br>1 if VDD lt 2.3v</td><td>Follow V18EN_IN</td>
  </tr>
  <tr>
   <td>1</td><td>1</td><td>1</td><td>Disabled<br>(1)</td><td>Maintain State<br>(2)</td><td>Follow V18EN_IN</td>
  </tr>
 </table>
 <br/>
(1) Vsensor is disabled because VDD is ready and DISABLE=1. Setting DISABLE back to 0 or powering off VDD will re-enable Vsensor. <br />
(2) For the existing Vsensor LATCH output to be correct, DISABLE must remains 0 for at least 100us after both 1.8V and VDD are powered up. <br />*/
//====================================================================

#define  AIB_EXTRA_REGS_VSENSOR01_RESERVED1_MASK 0xffff0000
#define  AIB_EXTRA_REGS_VSENSOR01_RESERVED1_SHIFT 16
#define  AIB_EXTRA_REGS_VSENSOR01_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR01_RESERVED1_MASK) >> AIB_EXTRA_REGS_VSENSOR01_RESERVED1_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR01_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR01_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR01_RESERVED1_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR01_V18EN_OUT_MASK 0x8000
#define  AIB_EXTRA_REGS_VSENSOR01_V18EN_OUT_SHIFT 15
#define  AIB_EXTRA_REGS_VSENSOR01_V18EN_OUT_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR01_V18EN_OUT_MASK) >> AIB_EXTRA_REGS_VSENSOR01_V18EN_OUT_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR01_V18EN_OUT_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR01_V18EN_OUT_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR01_V18EN_OUT_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR01_RESERVED2_MASK 0x7f00
#define  AIB_EXTRA_REGS_VSENSOR01_RESERVED2_SHIFT 8
#define  AIB_EXTRA_REGS_VSENSOR01_RESERVED2_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR01_RESERVED2_MASK) >> AIB_EXTRA_REGS_VSENSOR01_RESERVED2_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR01_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR01_RESERVED2_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR01_RESERVED2_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR01_TE_MASK 0x80
#define  AIB_EXTRA_REGS_VSENSOR01_TE_SHIFT 7
#define  AIB_EXTRA_REGS_VSENSOR01_TE_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR01_TE_MASK) >> AIB_EXTRA_REGS_VSENSOR01_TE_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR01_TE_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR01_TE_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR01_TE_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR01_TP_SEL_MASK 0x70
#define  AIB_EXTRA_REGS_VSENSOR01_TP_SEL_SHIFT 4
#define  AIB_EXTRA_REGS_VSENSOR01_TP_SEL_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR01_TP_SEL_MASK) >> AIB_EXTRA_REGS_VSENSOR01_TP_SEL_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR01_TP_SEL_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR01_TP_SEL_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR01_TP_SEL_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR01_DISABLE_MASK 0x8
#define  AIB_EXTRA_REGS_VSENSOR01_DISABLE_SHIFT 3
#define  AIB_EXTRA_REGS_VSENSOR01_DISABLE_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR01_DISABLE_MASK) >> AIB_EXTRA_REGS_VSENSOR01_DISABLE_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR01_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR01_DISABLE_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR01_DISABLE_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR01_VTHRESH_MASK 0x4
#define  AIB_EXTRA_REGS_VSENSOR01_VTHRESH_SHIFT 2
#define  AIB_EXTRA_REGS_VSENSOR01_VTHRESH_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR01_VTHRESH_MASK) >> AIB_EXTRA_REGS_VSENSOR01_VTHRESH_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR01_VTHRESH_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR01_VTHRESH_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR01_VTHRESH_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR01_BYPASS_MASK 0x2
#define  AIB_EXTRA_REGS_VSENSOR01_BYPASS_SHIFT 1
#define  AIB_EXTRA_REGS_VSENSOR01_BYPASS_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR01_BYPASS_MASK) >> AIB_EXTRA_REGS_VSENSOR01_BYPASS_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR01_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR01_BYPASS_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR01_BYPASS_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR01_V18EN_MASK 0x1
#define  AIB_EXTRA_REGS_VSENSOR01_V18EN_SHIFT 0
#define  AIB_EXTRA_REGS_VSENSOR01_V18EN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR01_V18EN_MASK) >> AIB_EXTRA_REGS_VSENSOR01_V18EN_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR01_V18EN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR01_V18EN_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR01_V18EN_SHIFT))

//====================================================================
//Register: VSensor02 Control Register (VSensor02)
/** \brief This register is used to control Vsensor Pad for the G6 pad section. <br />
 VSENSOR Truth Table
 <table>
  <tr>
    <th>LOW_VDDB</th><th>BYPASS</th><th>DISABLE</th><th>VSENSOR</th><th>Vsensor LATCH output</th><th>V18EN_Ring</th>
  </tr>
  <tr>
   <td>0</td><td>X</td><td>X</td><td>Enabled and NOT bypassed</td><td>Driven by VSENSOR:<br/>0 if VDD gt 2.3v<br/>1 if VDD lt 2.3v</td><td>Follow Vsensor</td>
  </tr>
  <tr>
   <td>1</td><td>0</td><td>0</td><td>Enabled and NOT bypassed</td><td>Driven by VSENSOR:<br>0 if VDD gt 2.3v<br>1 if VDD lt 2.3v</td><td>Follow Vsensor</td>
  </tr>
  <tr>
   <td>1</td><td>1</td><td>0</td><td>Enabled but bypassed</td><td>Driven by VSENSOR:<br>0 if VDD gt 2.3v<br>1 if VDD lt 2.3v</td><td>Follow V18EN_IN</td>
  </tr>
  <tr>
   <td>1</td><td>1</td><td>1</td><td>Disabled<br>(1)</td><td>Maintain State<br>(2)</td><td>Follow V18EN_IN</td>
  </tr>
 </table>
 <br/>
(1) Vsensor is disabled because VDD is ready and DISABLE=1. Setting DISABLE back to 0 or powering off VDD will re-enable Vsensor. <br />
(2) For the existing Vsensor LATCH output to be correct, DISABLE must remains 0 for at least 100us after both 1.8V and VDD are powered up. <br />*/
//====================================================================

#define  AIB_EXTRA_REGS_VSENSOR02_RESERVED1_MASK 0xffff0000
#define  AIB_EXTRA_REGS_VSENSOR02_RESERVED1_SHIFT 16
#define  AIB_EXTRA_REGS_VSENSOR02_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR02_RESERVED1_MASK) >> AIB_EXTRA_REGS_VSENSOR02_RESERVED1_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR02_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR02_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR02_RESERVED1_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR02_V18EN_OUT_MASK 0x8000
#define  AIB_EXTRA_REGS_VSENSOR02_V18EN_OUT_SHIFT 15
#define  AIB_EXTRA_REGS_VSENSOR02_V18EN_OUT_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR02_V18EN_OUT_MASK) >> AIB_EXTRA_REGS_VSENSOR02_V18EN_OUT_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR02_V18EN_OUT_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR02_V18EN_OUT_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR02_V18EN_OUT_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR02_RESERVED2_MASK 0x7f00
#define  AIB_EXTRA_REGS_VSENSOR02_RESERVED2_SHIFT 8
#define  AIB_EXTRA_REGS_VSENSOR02_RESERVED2_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR02_RESERVED2_MASK) >> AIB_EXTRA_REGS_VSENSOR02_RESERVED2_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR02_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR02_RESERVED2_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR02_RESERVED2_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR02_TE_MASK 0x80
#define  AIB_EXTRA_REGS_VSENSOR02_TE_SHIFT 7
#define  AIB_EXTRA_REGS_VSENSOR02_TE_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR02_TE_MASK) >> AIB_EXTRA_REGS_VSENSOR02_TE_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR02_TE_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR02_TE_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR02_TE_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR02_TP_SEL_MASK 0x70
#define  AIB_EXTRA_REGS_VSENSOR02_TP_SEL_SHIFT 4
#define  AIB_EXTRA_REGS_VSENSOR02_TP_SEL_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR02_TP_SEL_MASK) >> AIB_EXTRA_REGS_VSENSOR02_TP_SEL_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR02_TP_SEL_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR02_TP_SEL_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR02_TP_SEL_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR02_DISABLE_MASK 0x8
#define  AIB_EXTRA_REGS_VSENSOR02_DISABLE_SHIFT 3
#define  AIB_EXTRA_REGS_VSENSOR02_DISABLE_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR02_DISABLE_MASK) >> AIB_EXTRA_REGS_VSENSOR02_DISABLE_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR02_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR02_DISABLE_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR02_DISABLE_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR02_VTHRESH_MASK 0x4
#define  AIB_EXTRA_REGS_VSENSOR02_VTHRESH_SHIFT 2
#define  AIB_EXTRA_REGS_VSENSOR02_VTHRESH_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR02_VTHRESH_MASK) >> AIB_EXTRA_REGS_VSENSOR02_VTHRESH_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR02_VTHRESH_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR02_VTHRESH_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR02_VTHRESH_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR02_BYPASS_MASK 0x2
#define  AIB_EXTRA_REGS_VSENSOR02_BYPASS_SHIFT 1
#define  AIB_EXTRA_REGS_VSENSOR02_BYPASS_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR02_BYPASS_MASK) >> AIB_EXTRA_REGS_VSENSOR02_BYPASS_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR02_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR02_BYPASS_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR02_BYPASS_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR02_V18EN_MASK 0x1
#define  AIB_EXTRA_REGS_VSENSOR02_V18EN_SHIFT 0
#define  AIB_EXTRA_REGS_VSENSOR02_V18EN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR02_V18EN_MASK) >> AIB_EXTRA_REGS_VSENSOR02_V18EN_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR02_V18EN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR02_V18EN_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR02_V18EN_SHIFT))

//====================================================================
//Register: VSensor03 Control Register (VSensor03)
/** \brief This register is used to control Vsensor Pad for the G7 pad section. <br />
 VSENSOR Truth Table
 <table>
  <tr>
    <th>LOW_VDDB</th><th>BYPASS</th><th>DISABLE</th><th>VSENSOR</th><th>Vsensor LATCH output</th><th>V18EN_Ring</th>
  </tr>
  <tr>
   <td>0</td><td>X</td><td>X</td><td>Enabled and NOT bypassed</td><td>Driven by VSENSOR:<br/>0 if VDD gt 2.3v<br/>1 if VDD lt 2.3v</td><td>Follow Vsensor</td>
  </tr>
  <tr>
   <td>1</td><td>0</td><td>0</td><td>Enabled and NOT bypassed</td><td>Driven by VSENSOR:<br>0 if VDD gt 2.3v<br>1 if VDD lt 2.3v</td><td>Follow Vsensor</td>
  </tr>
  <tr>
   <td>1</td><td>1</td><td>0</td><td>Enabled but bypassed</td><td>Driven by VSENSOR:<br>0 if VDD gt 2.3v<br>1 if VDD lt 2.3v</td><td>Follow V18EN_IN</td>
  </tr>
  <tr>
   <td>1</td><td>1</td><td>1</td><td>Disabled<br>(1)</td><td>Maintain State<br>(2)</td><td>Follow V18EN_IN</td>
  </tr>
 </table>
 <br/>
(1) Vsensor is disabled because VDD is ready and DISABLE=1. Setting DISABLE back to 0 or powering off VDD will re-enable Vsensor. <br />
(2) For the existing Vsensor LATCH output to be correct, DISABLE must remains 0 for at least 100us after both 1.8V and VDD are powered up. <br />*/
//====================================================================

#define  AIB_EXTRA_REGS_VSENSOR03_RESERVED1_MASK 0xffff0000
#define  AIB_EXTRA_REGS_VSENSOR03_RESERVED1_SHIFT 16
#define  AIB_EXTRA_REGS_VSENSOR03_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR03_RESERVED1_MASK) >> AIB_EXTRA_REGS_VSENSOR03_RESERVED1_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR03_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR03_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR03_RESERVED1_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR03_V18EN_OUT_MASK 0x8000
#define  AIB_EXTRA_REGS_VSENSOR03_V18EN_OUT_SHIFT 15
#define  AIB_EXTRA_REGS_VSENSOR03_V18EN_OUT_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR03_V18EN_OUT_MASK) >> AIB_EXTRA_REGS_VSENSOR03_V18EN_OUT_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR03_V18EN_OUT_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR03_V18EN_OUT_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR03_V18EN_OUT_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR03_RESERVED2_MASK 0x7f00
#define  AIB_EXTRA_REGS_VSENSOR03_RESERVED2_SHIFT 8
#define  AIB_EXTRA_REGS_VSENSOR03_RESERVED2_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR03_RESERVED2_MASK) >> AIB_EXTRA_REGS_VSENSOR03_RESERVED2_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR03_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR03_RESERVED2_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR03_RESERVED2_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR03_TE_MASK 0x80
#define  AIB_EXTRA_REGS_VSENSOR03_TE_SHIFT 7
#define  AIB_EXTRA_REGS_VSENSOR03_TE_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR03_TE_MASK) >> AIB_EXTRA_REGS_VSENSOR03_TE_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR03_TE_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR03_TE_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR03_TE_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR03_TP_SEL_MASK 0x70
#define  AIB_EXTRA_REGS_VSENSOR03_TP_SEL_SHIFT 4
#define  AIB_EXTRA_REGS_VSENSOR03_TP_SEL_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR03_TP_SEL_MASK) >> AIB_EXTRA_REGS_VSENSOR03_TP_SEL_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR03_TP_SEL_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR03_TP_SEL_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR03_TP_SEL_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR03_DISABLE_MASK 0x8
#define  AIB_EXTRA_REGS_VSENSOR03_DISABLE_SHIFT 3
#define  AIB_EXTRA_REGS_VSENSOR03_DISABLE_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR03_DISABLE_MASK) >> AIB_EXTRA_REGS_VSENSOR03_DISABLE_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR03_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR03_DISABLE_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR03_DISABLE_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR03_VTHRESH_MASK 0x4
#define  AIB_EXTRA_REGS_VSENSOR03_VTHRESH_SHIFT 2
#define  AIB_EXTRA_REGS_VSENSOR03_VTHRESH_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR03_VTHRESH_MASK) >> AIB_EXTRA_REGS_VSENSOR03_VTHRESH_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR03_VTHRESH_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR03_VTHRESH_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR03_VTHRESH_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR03_BYPASS_MASK 0x2
#define  AIB_EXTRA_REGS_VSENSOR03_BYPASS_SHIFT 1
#define  AIB_EXTRA_REGS_VSENSOR03_BYPASS_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR03_BYPASS_MASK) >> AIB_EXTRA_REGS_VSENSOR03_BYPASS_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR03_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR03_BYPASS_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR03_BYPASS_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR03_V18EN_MASK 0x1
#define  AIB_EXTRA_REGS_VSENSOR03_V18EN_SHIFT 0
#define  AIB_EXTRA_REGS_VSENSOR03_V18EN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR03_V18EN_MASK) >> AIB_EXTRA_REGS_VSENSOR03_V18EN_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR03_V18EN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR03_V18EN_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR03_V18EN_SHIFT))

//====================================================================
//Register: VSensor04 Control Register (VSensor04)
/** \brief This register is used to control Vsensor Pad for the G8 pad section. <br />
 VSENSOR Truth Table
 <table>
  <tr>
    <th>LOW_VDDB</th><th>BYPASS</th><th>DISABLE</th><th>VSENSOR</th><th>Vsensor LATCH output</th><th>V18EN_Ring</th>
  </tr>
  <tr>
   <td>0</td><td>X</td><td>X</td><td>Enabled and NOT bypassed</td><td>Driven by VSENSOR:<br/>0 if VDD gt 2.3v<br/>1 if VDD lt 2.3v</td><td>Follow Vsensor</td>
  </tr>
  <tr>
   <td>1</td><td>0</td><td>0</td><td>Enabled and NOT bypassed</td><td>Driven by VSENSOR:<br>0 if VDD gt 2.3v<br>1 if VDD lt 2.3v</td><td>Follow Vsensor</td>
  </tr>
  <tr>
   <td>1</td><td>1</td><td>0</td><td>Enabled but bypassed</td><td>Driven by VSENSOR:<br>0 if VDD gt 2.3v<br>1 if VDD lt 2.3v</td><td>Follow V18EN_IN</td>
  </tr>
  <tr>
   <td>1</td><td>1</td><td>1</td><td>Disabled<br>(1)</td><td>Maintain State<br>(2)</td><td>Follow V18EN_IN</td>
  </tr>
 </table>
 <br/>
(1) Vsensor is disabled because VDD is ready and DISABLE=1. Setting DISABLE back to 0 or powering off VDD will re-enable Vsensor. <br />
(2) For the existing Vsensor LATCH output to be correct, DISABLE must remains 0 for at least 100us after both 1.8V and VDD are powered up. <br />*/
//====================================================================

#define  AIB_EXTRA_REGS_VSENSOR04_RESERVED1_MASK 0xffff0000
#define  AIB_EXTRA_REGS_VSENSOR04_RESERVED1_SHIFT 16
#define  AIB_EXTRA_REGS_VSENSOR04_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR04_RESERVED1_MASK) >> AIB_EXTRA_REGS_VSENSOR04_RESERVED1_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR04_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR04_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR04_RESERVED1_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR04_V18EN_OUT_MASK 0x8000
#define  AIB_EXTRA_REGS_VSENSOR04_V18EN_OUT_SHIFT 15
#define  AIB_EXTRA_REGS_VSENSOR04_V18EN_OUT_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR04_V18EN_OUT_MASK) >> AIB_EXTRA_REGS_VSENSOR04_V18EN_OUT_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR04_V18EN_OUT_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR04_V18EN_OUT_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR04_V18EN_OUT_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR04_RESERVED2_MASK 0x7f00
#define  AIB_EXTRA_REGS_VSENSOR04_RESERVED2_SHIFT 8
#define  AIB_EXTRA_REGS_VSENSOR04_RESERVED2_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR04_RESERVED2_MASK) >> AIB_EXTRA_REGS_VSENSOR04_RESERVED2_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR04_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR04_RESERVED2_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR04_RESERVED2_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR04_TE_MASK 0x80
#define  AIB_EXTRA_REGS_VSENSOR04_TE_SHIFT 7
#define  AIB_EXTRA_REGS_VSENSOR04_TE_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR04_TE_MASK) >> AIB_EXTRA_REGS_VSENSOR04_TE_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR04_TE_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR04_TE_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR04_TE_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR04_TP_SEL_MASK 0x70
#define  AIB_EXTRA_REGS_VSENSOR04_TP_SEL_SHIFT 4
#define  AIB_EXTRA_REGS_VSENSOR04_TP_SEL_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR04_TP_SEL_MASK) >> AIB_EXTRA_REGS_VSENSOR04_TP_SEL_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR04_TP_SEL_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR04_TP_SEL_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR04_TP_SEL_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR04_DISABLE_MASK 0x8
#define  AIB_EXTRA_REGS_VSENSOR04_DISABLE_SHIFT 3
#define  AIB_EXTRA_REGS_VSENSOR04_DISABLE_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR04_DISABLE_MASK) >> AIB_EXTRA_REGS_VSENSOR04_DISABLE_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR04_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR04_DISABLE_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR04_DISABLE_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR04_VTHRESH_MASK 0x4
#define  AIB_EXTRA_REGS_VSENSOR04_VTHRESH_SHIFT 2
#define  AIB_EXTRA_REGS_VSENSOR04_VTHRESH_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR04_VTHRESH_MASK) >> AIB_EXTRA_REGS_VSENSOR04_VTHRESH_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR04_VTHRESH_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR04_VTHRESH_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR04_VTHRESH_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR04_BYPASS_MASK 0x2
#define  AIB_EXTRA_REGS_VSENSOR04_BYPASS_SHIFT 1
#define  AIB_EXTRA_REGS_VSENSOR04_BYPASS_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR04_BYPASS_MASK) >> AIB_EXTRA_REGS_VSENSOR04_BYPASS_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR04_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR04_BYPASS_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR04_BYPASS_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR04_V18EN_MASK 0x1
#define  AIB_EXTRA_REGS_VSENSOR04_V18EN_SHIFT 0
#define  AIB_EXTRA_REGS_VSENSOR04_V18EN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR04_V18EN_MASK) >> AIB_EXTRA_REGS_VSENSOR04_V18EN_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR04_V18EN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR04_V18EN_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR04_V18EN_SHIFT))

//====================================================================
//Register: VSensor05 Control Register (VSensor05)
/** \brief This register is used to control Vsensor Pad for the G9 pad section. <br />
 VSENSOR Truth Table
 <table>
  <tr>
    <th>LOW_VDDB</th><th>BYPASS</th><th>DISABLE</th><th>VSENSOR</th><th>Vsensor LATCH output</th><th>V18EN_Ring</th>
  </tr>
  <tr>
   <td>0</td><td>X</td><td>X</td><td>Enabled and NOT bypassed</td><td>Driven by VSENSOR:<br/>0 if VDD gt 2.3v<br/>1 if VDD lt 2.3v</td><td>Follow Vsensor</td>
  </tr>
  <tr>
   <td>1</td><td>0</td><td>0</td><td>Enabled and NOT bypassed</td><td>Driven by VSENSOR:<br>0 if VDD gt 2.3v<br>1 if VDD lt 2.3v</td><td>Follow Vsensor</td>
  </tr>
  <tr>
   <td>1</td><td>1</td><td>0</td><td>Enabled but bypassed</td><td>Driven by VSENSOR:<br>0 if VDD gt 2.3v<br>1 if VDD lt 2.3v</td><td>Follow V18EN_IN</td>
  </tr>
  <tr>
   <td>1</td><td>1</td><td>1</td><td>Disabled<br>(1)</td><td>Maintain State<br>(2)</td><td>Follow V18EN_IN</td>
  </tr>
 </table>
 <br/>
(1) Vsensor is disabled because VDD is ready and DISABLE=1. Setting DISABLE back to 0 or powering off VDD will re-enable Vsensor. <br />
(2) For the existing Vsensor LATCH output to be correct, DISABLE must remains 0 for at least 100us after both 1.8V and VDD are powered up. <br />*/
//====================================================================

#define  AIB_EXTRA_REGS_VSENSOR05_RESERVED1_MASK 0xffff0000
#define  AIB_EXTRA_REGS_VSENSOR05_RESERVED1_SHIFT 16
#define  AIB_EXTRA_REGS_VSENSOR05_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR05_RESERVED1_MASK) >> AIB_EXTRA_REGS_VSENSOR05_RESERVED1_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR05_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR05_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR05_RESERVED1_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR05_V18EN_OUT_MASK 0x8000
#define  AIB_EXTRA_REGS_VSENSOR05_V18EN_OUT_SHIFT 15
#define  AIB_EXTRA_REGS_VSENSOR05_V18EN_OUT_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR05_V18EN_OUT_MASK) >> AIB_EXTRA_REGS_VSENSOR05_V18EN_OUT_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR05_V18EN_OUT_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR05_V18EN_OUT_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR05_V18EN_OUT_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR05_RESERVED2_MASK 0x7f00
#define  AIB_EXTRA_REGS_VSENSOR05_RESERVED2_SHIFT 8
#define  AIB_EXTRA_REGS_VSENSOR05_RESERVED2_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR05_RESERVED2_MASK) >> AIB_EXTRA_REGS_VSENSOR05_RESERVED2_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR05_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR05_RESERVED2_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR05_RESERVED2_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR05_TE_MASK 0x80
#define  AIB_EXTRA_REGS_VSENSOR05_TE_SHIFT 7
#define  AIB_EXTRA_REGS_VSENSOR05_TE_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR05_TE_MASK) >> AIB_EXTRA_REGS_VSENSOR05_TE_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR05_TE_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR05_TE_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR05_TE_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR05_TP_SEL_MASK 0x70
#define  AIB_EXTRA_REGS_VSENSOR05_TP_SEL_SHIFT 4
#define  AIB_EXTRA_REGS_VSENSOR05_TP_SEL_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR05_TP_SEL_MASK) >> AIB_EXTRA_REGS_VSENSOR05_TP_SEL_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR05_TP_SEL_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR05_TP_SEL_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR05_TP_SEL_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR05_DISABLE_MASK 0x8
#define  AIB_EXTRA_REGS_VSENSOR05_DISABLE_SHIFT 3
#define  AIB_EXTRA_REGS_VSENSOR05_DISABLE_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR05_DISABLE_MASK) >> AIB_EXTRA_REGS_VSENSOR05_DISABLE_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR05_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR05_DISABLE_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR05_DISABLE_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR05_VTHRESH_MASK 0x4
#define  AIB_EXTRA_REGS_VSENSOR05_VTHRESH_SHIFT 2
#define  AIB_EXTRA_REGS_VSENSOR05_VTHRESH_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR05_VTHRESH_MASK) >> AIB_EXTRA_REGS_VSENSOR05_VTHRESH_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR05_VTHRESH_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR05_VTHRESH_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR05_VTHRESH_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR05_BYPASS_MASK 0x2
#define  AIB_EXTRA_REGS_VSENSOR05_BYPASS_SHIFT 1
#define  AIB_EXTRA_REGS_VSENSOR05_BYPASS_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR05_BYPASS_MASK) >> AIB_EXTRA_REGS_VSENSOR05_BYPASS_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR05_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR05_BYPASS_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR05_BYPASS_SHIFT))

#define  AIB_EXTRA_REGS_VSENSOR05_V18EN_MASK 0x1
#define  AIB_EXTRA_REGS_VSENSOR05_V18EN_SHIFT 0
#define  AIB_EXTRA_REGS_VSENSOR05_V18EN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_VSENSOR05_V18EN_MASK) >> AIB_EXTRA_REGS_VSENSOR05_V18EN_SHIFT)
#define  AIB_EXTRA_REGS_VSENSOR05_V18EN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_VSENSOR05_V18EN_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_VSENSOR05_V18EN_SHIFT))

//====================================================================
//Register: Calibration Pad Enable Register (CAL_EN)
/** \brief Calibration pad enable and feed back register.*/
//====================================================================

#define  AIB_EXTRA_REGS_CAL_EN_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_REGS_CAL_EN_RESERVED1_SHIFT 8
#define  AIB_EXTRA_REGS_CAL_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_CAL_EN_RESERVED1_MASK) >> AIB_EXTRA_REGS_CAL_EN_RESERVED1_SHIFT)
#define  AIB_EXTRA_REGS_CAL_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_CAL_EN_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_CAL_EN_RESERVED1_SHIFT))

#define  AIB_EXTRA_REGS_CAL_EN_CAL_N_INC_MASK 0x80
#define  AIB_EXTRA_REGS_CAL_EN_CAL_N_INC_SHIFT 7
#define  AIB_EXTRA_REGS_CAL_EN_CAL_N_INC_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_CAL_EN_CAL_N_INC_MASK) >> AIB_EXTRA_REGS_CAL_EN_CAL_N_INC_SHIFT)
#define  AIB_EXTRA_REGS_CAL_EN_CAL_N_INC_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_CAL_EN_CAL_N_INC_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_CAL_EN_CAL_N_INC_SHIFT))

#define  AIB_EXTRA_REGS_CAL_EN_CAL_P_INC_MASK 0x40
#define  AIB_EXTRA_REGS_CAL_EN_CAL_P_INC_SHIFT 6
#define  AIB_EXTRA_REGS_CAL_EN_CAL_P_INC_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_CAL_EN_CAL_P_INC_MASK) >> AIB_EXTRA_REGS_CAL_EN_CAL_P_INC_SHIFT)
#define  AIB_EXTRA_REGS_CAL_EN_CAL_P_INC_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_CAL_EN_CAL_P_INC_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_CAL_EN_CAL_P_INC_SHIFT))

#define  AIB_EXTRA_REGS_CAL_EN_RESERVED2_MASK 0x3c
#define  AIB_EXTRA_REGS_CAL_EN_RESERVED2_SHIFT 2
#define  AIB_EXTRA_REGS_CAL_EN_RESERVED2_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_CAL_EN_RESERVED2_MASK) >> AIB_EXTRA_REGS_CAL_EN_RESERVED2_SHIFT)
#define  AIB_EXTRA_REGS_CAL_EN_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_CAL_EN_RESERVED2_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_CAL_EN_RESERVED2_SHIFT))

#define  AIB_EXTRA_REGS_CAL_EN_CAL_N_EN_MASK 0x2
#define  AIB_EXTRA_REGS_CAL_EN_CAL_N_EN_SHIFT 1
#define  AIB_EXTRA_REGS_CAL_EN_CAL_N_EN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_CAL_EN_CAL_N_EN_MASK) >> AIB_EXTRA_REGS_CAL_EN_CAL_N_EN_SHIFT)
#define  AIB_EXTRA_REGS_CAL_EN_CAL_N_EN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_CAL_EN_CAL_N_EN_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_CAL_EN_CAL_N_EN_SHIFT))

#define  AIB_EXTRA_REGS_CAL_EN_CAL_P_EN_MASK 0x1
#define  AIB_EXTRA_REGS_CAL_EN_CAL_P_EN_SHIFT 0
#define  AIB_EXTRA_REGS_CAL_EN_CAL_P_EN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_CAL_EN_CAL_P_EN_MASK) >> AIB_EXTRA_REGS_CAL_EN_CAL_P_EN_SHIFT)
#define  AIB_EXTRA_REGS_CAL_EN_CAL_P_EN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_CAL_EN_CAL_P_EN_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_CAL_EN_CAL_P_EN_SHIFT))

//====================================================================
//Register: Calibration Pad On Die Resistor Control Register (CAL_ODR)
/** \brief Calibration pad enable and feed back register.Register controls weather ODR is enabled and which value to use.*/
//====================================================================

#define  AIB_EXTRA_REGS_CAL_ODR_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_REGS_CAL_ODR_RESERVED1_SHIFT 8
#define  AIB_EXTRA_REGS_CAL_ODR_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_CAL_ODR_RESERVED1_MASK) >> AIB_EXTRA_REGS_CAL_ODR_RESERVED1_SHIFT)
#define  AIB_EXTRA_REGS_CAL_ODR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_CAL_ODR_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_CAL_ODR_RESERVED1_SHIFT))

#define  AIB_EXTRA_REGS_CAL_ODR_ODR_EN_MASK 0x80
#define  AIB_EXTRA_REGS_CAL_ODR_ODR_EN_SHIFT 7
#define  AIB_EXTRA_REGS_CAL_ODR_ODR_EN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_CAL_ODR_ODR_EN_MASK) >> AIB_EXTRA_REGS_CAL_ODR_ODR_EN_SHIFT)
#define  AIB_EXTRA_REGS_CAL_ODR_ODR_EN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_CAL_ODR_ODR_EN_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_CAL_ODR_ODR_EN_SHIFT))

#define  AIB_EXTRA_REGS_CAL_ODR_RESERVED2_MASK 0x78
#define  AIB_EXTRA_REGS_CAL_ODR_RESERVED2_SHIFT 3
#define  AIB_EXTRA_REGS_CAL_ODR_RESERVED2_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_CAL_ODR_RESERVED2_MASK) >> AIB_EXTRA_REGS_CAL_ODR_RESERVED2_SHIFT)
#define  AIB_EXTRA_REGS_CAL_ODR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_CAL_ODR_RESERVED2_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_CAL_ODR_RESERVED2_SHIFT))

#define  AIB_EXTRA_REGS_CAL_ODR_ODR_MASK 0x7
#define  AIB_EXTRA_REGS_CAL_ODR_ODR_SHIFT 0
#define  AIB_EXTRA_REGS_CAL_ODR_ODR_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_CAL_ODR_ODR_MASK) >> AIB_EXTRA_REGS_CAL_ODR_ODR_SHIFT)
#define  AIB_EXTRA_REGS_CAL_ODR_ODR_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_CAL_ODR_ODR_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_CAL_ODR_ODR_SHIFT))

//====================================================================
//Register: ZN Calibration Value Register (ZN)
/** \brief ZN ADJUSTvalue.*/
//====================================================================

#define  AIB_EXTRA_REGS_ZN_RESERVED1_MASK 0xfffffff0
#define  AIB_EXTRA_REGS_ZN_RESERVED1_SHIFT 4
#define  AIB_EXTRA_REGS_ZN_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_ZN_RESERVED1_MASK) >> AIB_EXTRA_REGS_ZN_RESERVED1_SHIFT)
#define  AIB_EXTRA_REGS_ZN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_ZN_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_ZN_RESERVED1_SHIFT))

#define  AIB_EXTRA_REGS_ZN_ZN_MASK 0xf
#define  AIB_EXTRA_REGS_ZN_ZN_SHIFT 0
#define  AIB_EXTRA_REGS_ZN_ZN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_ZN_ZN_MASK) >> AIB_EXTRA_REGS_ZN_ZN_SHIFT)
#define  AIB_EXTRA_REGS_ZN_ZN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_ZN_ZN_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_ZN_ZN_SHIFT))

//====================================================================
//Register: ZP Calibration Value Register (ZP)
/** \brief ZP ADJUST value.*/
//====================================================================

#define  AIB_EXTRA_REGS_ZP_RESERVED1_MASK 0xfffffff0
#define  AIB_EXTRA_REGS_ZP_RESERVED1_SHIFT 4
#define  AIB_EXTRA_REGS_ZP_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_ZP_RESERVED1_MASK) >> AIB_EXTRA_REGS_ZP_RESERVED1_SHIFT)
#define  AIB_EXTRA_REGS_ZP_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_ZP_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_ZP_RESERVED1_SHIFT))

#define  AIB_EXTRA_REGS_ZP_ZP_MASK 0xf
#define  AIB_EXTRA_REGS_ZP_ZP_SHIFT 0
#define  AIB_EXTRA_REGS_ZP_ZP_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_ZP_ZP_MASK) >> AIB_EXTRA_REGS_ZP_ZP_SHIFT)
#define  AIB_EXTRA_REGS_ZP_ZP_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_ZP_ZP_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_ZP_ZP_SHIFT))

//====================================================================
//Register: ZP Calibration Setting After Cal. Register (ZP_AFT_CAL)
/** \brief Calibrated ZP value.*/
//====================================================================

#define  AIB_EXTRA_REGS_ZP_AFT_CAL_RESERVED1_MASK 0xfffffff0
#define  AIB_EXTRA_REGS_ZP_AFT_CAL_RESERVED1_SHIFT 4
#define  AIB_EXTRA_REGS_ZP_AFT_CAL_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_ZP_AFT_CAL_RESERVED1_MASK) >> AIB_EXTRA_REGS_ZP_AFT_CAL_RESERVED1_SHIFT)
#define  AIB_EXTRA_REGS_ZP_AFT_CAL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_ZP_AFT_CAL_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_ZP_AFT_CAL_RESERVED1_SHIFT))

#define  AIB_EXTRA_REGS_ZP_AFT_CAL_ZP_AFT_CAL_MASK 0xf
#define  AIB_EXTRA_REGS_ZP_AFT_CAL_ZP_AFT_CAL_SHIFT 0
#define  AIB_EXTRA_REGS_ZP_AFT_CAL_ZP_AFT_CAL_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_ZP_AFT_CAL_ZP_AFT_CAL_MASK) >> AIB_EXTRA_REGS_ZP_AFT_CAL_ZP_AFT_CAL_SHIFT)
#define  AIB_EXTRA_REGS_ZP_AFT_CAL_ZP_AFT_CAL_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_ZP_AFT_CAL_ZP_AFT_CAL_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_ZP_AFT_CAL_ZP_AFT_CAL_SHIFT))

//====================================================================
//Register: SPARE 0 Register (SPARE0)
/** \brief This is an 8 bit spare register that F/W can use as scratchpad area*/
//====================================================================

#define  AIB_EXTRA_REGS_SPARE0_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_REGS_SPARE0_RESERVED1_SHIFT 8
#define  AIB_EXTRA_REGS_SPARE0_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_SPARE0_RESERVED1_MASK) >> AIB_EXTRA_REGS_SPARE0_RESERVED1_SHIFT)
#define  AIB_EXTRA_REGS_SPARE0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_SPARE0_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_SPARE0_RESERVED1_SHIFT))

#define  AIB_EXTRA_REGS_SPARE0_SPARE0_MASK 0xff
#define  AIB_EXTRA_REGS_SPARE0_SPARE0_SHIFT 0
#define  AIB_EXTRA_REGS_SPARE0_SPARE0_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_SPARE0_SPARE0_MASK) >> AIB_EXTRA_REGS_SPARE0_SPARE0_SHIFT)
#define  AIB_EXTRA_REGS_SPARE0_SPARE0_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_SPARE0_SPARE0_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_SPARE0_SPARE0_SHIFT))

//====================================================================
//Register: SPARE 1 Register (SPARE1)
/** \brief This is an 8 bit spare register that F/W can use as scratchpad area*/
//====================================================================

#define  AIB_EXTRA_REGS_SPARE1_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_REGS_SPARE1_RESERVED1_SHIFT 8
#define  AIB_EXTRA_REGS_SPARE1_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_SPARE1_RESERVED1_MASK) >> AIB_EXTRA_REGS_SPARE1_RESERVED1_SHIFT)
#define  AIB_EXTRA_REGS_SPARE1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_SPARE1_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_SPARE1_RESERVED1_SHIFT))

#define  AIB_EXTRA_REGS_SPARE1_SPARE1_MASK 0xff
#define  AIB_EXTRA_REGS_SPARE1_SPARE1_SHIFT 0
#define  AIB_EXTRA_REGS_SPARE1_SPARE1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_SPARE1_SPARE1_MASK) >> AIB_EXTRA_REGS_SPARE1_SPARE1_SHIFT)
#define  AIB_EXTRA_REGS_SPARE1_SPARE1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_SPARE1_SPARE1_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_SPARE1_SPARE1_SHIFT))

//====================================================================
//Register: SPARE 2 Register (SPARE2)
/** \brief This is an 8 bit spare register that F/W can use as scratchpad area*/
//====================================================================

#define  AIB_EXTRA_REGS_SPARE2_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_REGS_SPARE2_RESERVED1_SHIFT 8
#define  AIB_EXTRA_REGS_SPARE2_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_SPARE2_RESERVED1_MASK) >> AIB_EXTRA_REGS_SPARE2_RESERVED1_SHIFT)
#define  AIB_EXTRA_REGS_SPARE2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_SPARE2_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_SPARE2_RESERVED1_SHIFT))

#define  AIB_EXTRA_REGS_SPARE2_SPARE2_MASK 0xff
#define  AIB_EXTRA_REGS_SPARE2_SPARE2_SHIFT 0
#define  AIB_EXTRA_REGS_SPARE2_SPARE2_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_SPARE2_SPARE2_MASK) >> AIB_EXTRA_REGS_SPARE2_SPARE2_SHIFT)
#define  AIB_EXTRA_REGS_SPARE2_SPARE2_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_SPARE2_SPARE2_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_SPARE2_SPARE2_SHIFT))

//====================================================================
//Register: SPARE 3 Register (SPARE3)
/** \brief This is an 8 bit spare register that F/W can use as scratchpad area*/
//====================================================================

#define  AIB_EXTRA_REGS_SPARE3_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_REGS_SPARE3_RESERVED1_SHIFT 8
#define  AIB_EXTRA_REGS_SPARE3_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_SPARE3_RESERVED1_MASK) >> AIB_EXTRA_REGS_SPARE3_RESERVED1_SHIFT)
#define  AIB_EXTRA_REGS_SPARE3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_SPARE3_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_SPARE3_RESERVED1_SHIFT))

#define  AIB_EXTRA_REGS_SPARE3_SPARE3_MASK 0xff
#define  AIB_EXTRA_REGS_SPARE3_SPARE3_SHIFT 0
#define  AIB_EXTRA_REGS_SPARE3_SPARE3_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_REGS_SPARE3_SPARE3_MASK) >> AIB_EXTRA_REGS_SPARE3_SPARE3_SHIFT)
#define  AIB_EXTRA_REGS_SPARE3_SPARE3_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_REGS_SPARE3_SPARE3_MASK) | (((uint32_t)val) << AIB_EXTRA_REGS_SPARE3_SPARE3_SHIFT))

//====================================================================
//
//Register File: AIB Secure Registers - Strap Override (Strap_Override)
//
//====================================================================

//====================================================================
//Register: Fuse Override Register 0 (SFO_FUSE_OVR_REG0)
//====================================================================

#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG0_RESERVED1_MASK 0xffff0000
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG0_RESERVED1_SHIFT 16
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG0_RESERVED1_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_FUSE_OVR_REG0_RESERVED1_MASK) >> STRAP_OVERRIDE_SFO_FUSE_OVR_REG0_RESERVED1_SHIFT)
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_FUSE_OVR_REG0_RESERVED1_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_FUSE_OVR_REG0_RESERVED1_SHIFT))

#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG0_TOP_FUSE_OVR_MASK 0xffff
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG0_TOP_FUSE_OVR_SHIFT 0
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG0_TOP_FUSE_OVR_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_FUSE_OVR_REG0_TOP_FUSE_OVR_MASK) >> STRAP_OVERRIDE_SFO_FUSE_OVR_REG0_TOP_FUSE_OVR_SHIFT)
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG0_TOP_FUSE_OVR_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_FUSE_OVR_REG0_TOP_FUSE_OVR_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_FUSE_OVR_REG0_TOP_FUSE_OVR_SHIFT))

//====================================================================
//Register: Fuse Override Register 1 (SFO_FUSE_OVR_REG1)
//====================================================================

#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG1_RESERVED1_MASK 0xffff0000
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG1_RESERVED1_SHIFT 16
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG1_RESERVED1_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_FUSE_OVR_REG1_RESERVED1_MASK) >> STRAP_OVERRIDE_SFO_FUSE_OVR_REG1_RESERVED1_SHIFT)
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_FUSE_OVR_REG1_RESERVED1_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_FUSE_OVR_REG1_RESERVED1_SHIFT))

#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG1_APP_FUSE_OVR0_MASK 0xffff
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG1_APP_FUSE_OVR0_SHIFT 0
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG1_APP_FUSE_OVR0_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_FUSE_OVR_REG1_APP_FUSE_OVR0_MASK) >> STRAP_OVERRIDE_SFO_FUSE_OVR_REG1_APP_FUSE_OVR0_SHIFT)
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG1_APP_FUSE_OVR0_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_FUSE_OVR_REG1_APP_FUSE_OVR0_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_FUSE_OVR_REG1_APP_FUSE_OVR0_SHIFT))

//====================================================================
//Register: Fuse Override Register 2 (SFO_FUSE_OVR_REG2)
//====================================================================

#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG2_RESERVED1_MASK 0xffff0000
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG2_RESERVED1_SHIFT 16
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG2_RESERVED1_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_FUSE_OVR_REG2_RESERVED1_MASK) >> STRAP_OVERRIDE_SFO_FUSE_OVR_REG2_RESERVED1_SHIFT)
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_FUSE_OVR_REG2_RESERVED1_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_FUSE_OVR_REG2_RESERVED1_SHIFT))

#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG2_APP_FUSE_OVR1_MASK 0xffff
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG2_APP_FUSE_OVR1_SHIFT 0
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG2_APP_FUSE_OVR1_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_FUSE_OVR_REG2_APP_FUSE_OVR1_MASK) >> STRAP_OVERRIDE_SFO_FUSE_OVR_REG2_APP_FUSE_OVR1_SHIFT)
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG2_APP_FUSE_OVR1_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_FUSE_OVR_REG2_APP_FUSE_OVR1_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_FUSE_OVR_REG2_APP_FUSE_OVR1_SHIFT))

//====================================================================
//Register: Fuse Override Register 3 (SFO_FUSE_OVR_REG3)
//====================================================================

#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG3_RESERVED1_MASK 0xffff0000
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG3_RESERVED1_SHIFT 16
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG3_RESERVED1_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_FUSE_OVR_REG3_RESERVED1_MASK) >> STRAP_OVERRIDE_SFO_FUSE_OVR_REG3_RESERVED1_SHIFT)
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_FUSE_OVR_REG3_RESERVED1_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_FUSE_OVR_REG3_RESERVED1_SHIFT))

#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG3_APP_FUSE_OVR2_MASK 0xffff
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG3_APP_FUSE_OVR2_SHIFT 0
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG3_APP_FUSE_OVR2_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_FUSE_OVR_REG3_APP_FUSE_OVR2_MASK) >> STRAP_OVERRIDE_SFO_FUSE_OVR_REG3_APP_FUSE_OVR2_SHIFT)
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG3_APP_FUSE_OVR2_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_FUSE_OVR_REG3_APP_FUSE_OVR2_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_FUSE_OVR_REG3_APP_FUSE_OVR2_SHIFT))

//====================================================================
//Register: Fuse Override Register 4 (SFO_FUSE_OVR_REG4)
//====================================================================

#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG4_RESERVED1_MASK 0xffff0000
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG4_RESERVED1_SHIFT 16
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG4_RESERVED1_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_FUSE_OVR_REG4_RESERVED1_MASK) >> STRAP_OVERRIDE_SFO_FUSE_OVR_REG4_RESERVED1_SHIFT)
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_FUSE_OVR_REG4_RESERVED1_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_FUSE_OVR_REG4_RESERVED1_SHIFT))

#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG4_APP_FUSE_OVR3_MASK 0xffff
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG4_APP_FUSE_OVR3_SHIFT 0
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG4_APP_FUSE_OVR3_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_FUSE_OVR_REG4_APP_FUSE_OVR3_MASK) >> STRAP_OVERRIDE_SFO_FUSE_OVR_REG4_APP_FUSE_OVR3_SHIFT)
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG4_APP_FUSE_OVR3_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_FUSE_OVR_REG4_APP_FUSE_OVR3_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_FUSE_OVR_REG4_APP_FUSE_OVR3_SHIFT))

//====================================================================
//Register: Fuse Override Register 5 (SFO_FUSE_OVR_REG5)
//====================================================================

#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG5_RESERVED1_MASK 0xffff0000
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG5_RESERVED1_SHIFT 16
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG5_RESERVED1_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_FUSE_OVR_REG5_RESERVED1_MASK) >> STRAP_OVERRIDE_SFO_FUSE_OVR_REG5_RESERVED1_SHIFT)
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_FUSE_OVR_REG5_RESERVED1_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_FUSE_OVR_REG5_RESERVED1_SHIFT))

#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG5_AIB_FUSE_OVR_MASK 0x8000
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG5_AIB_FUSE_OVR_SHIFT 15
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG5_AIB_FUSE_OVR_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_FUSE_OVR_REG5_AIB_FUSE_OVR_MASK) >> STRAP_OVERRIDE_SFO_FUSE_OVR_REG5_AIB_FUSE_OVR_SHIFT)
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG5_AIB_FUSE_OVR_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_FUSE_OVR_REG5_AIB_FUSE_OVR_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_FUSE_OVR_REG5_AIB_FUSE_OVR_SHIFT))

#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG5_APP_FUSE_OVR4_MASK 0x7fff
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG5_APP_FUSE_OVR4_SHIFT 0
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG5_APP_FUSE_OVR4_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_FUSE_OVR_REG5_APP_FUSE_OVR4_MASK) >> STRAP_OVERRIDE_SFO_FUSE_OVR_REG5_APP_FUSE_OVR4_SHIFT)
#define  STRAP_OVERRIDE_SFO_FUSE_OVR_REG5_APP_FUSE_OVR4_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_FUSE_OVR_REG5_APP_FUSE_OVR4_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_FUSE_OVR_REG5_APP_FUSE_OVR4_SHIFT))

//====================================================================
//Register: Overridden Configuration Register 0 (SFO_OVRD_CONF_REG0)
//====================================================================

#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG0_RESERVED1_MASK 0xffff0000
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG0_RESERVED1_SHIFT 16
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG0_RESERVED1_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_OVRD_CONF_REG0_RESERVED1_MASK) >> STRAP_OVERRIDE_SFO_OVRD_CONF_REG0_RESERVED1_SHIFT)
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_OVRD_CONF_REG0_RESERVED1_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_OVRD_CONF_REG0_RESERVED1_SHIFT))

#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG0_TOP_OVRD_CONF_MASK 0xffff
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG0_TOP_OVRD_CONF_SHIFT 0
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG0_TOP_OVRD_CONF_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_OVRD_CONF_REG0_TOP_OVRD_CONF_MASK) >> STRAP_OVERRIDE_SFO_OVRD_CONF_REG0_TOP_OVRD_CONF_SHIFT)
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG0_TOP_OVRD_CONF_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_OVRD_CONF_REG0_TOP_OVRD_CONF_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_OVRD_CONF_REG0_TOP_OVRD_CONF_SHIFT))

//====================================================================
//Register: Overridden Configuration Register 1 (SFO_OVRD_CONF_REG1)
//====================================================================

#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG1_RESERVED1_MASK 0xffff0000
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG1_RESERVED1_SHIFT 16
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG1_RESERVED1_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_OVRD_CONF_REG1_RESERVED1_MASK) >> STRAP_OVERRIDE_SFO_OVRD_CONF_REG1_RESERVED1_SHIFT)
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_OVRD_CONF_REG1_RESERVED1_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_OVRD_CONF_REG1_RESERVED1_SHIFT))

#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG1_APP_OVRD_CONF0_MASK 0xffff
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG1_APP_OVRD_CONF0_SHIFT 0
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG1_APP_OVRD_CONF0_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_OVRD_CONF_REG1_APP_OVRD_CONF0_MASK) >> STRAP_OVERRIDE_SFO_OVRD_CONF_REG1_APP_OVRD_CONF0_SHIFT)
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG1_APP_OVRD_CONF0_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_OVRD_CONF_REG1_APP_OVRD_CONF0_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_OVRD_CONF_REG1_APP_OVRD_CONF0_SHIFT))

//====================================================================
//Register: Overridden Configuration Register 2 (SFO_OVRD_CONF_REG2)
//====================================================================

#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG2_RESERVED1_MASK 0xffff0000
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG2_RESERVED1_SHIFT 16
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG2_RESERVED1_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_OVRD_CONF_REG2_RESERVED1_MASK) >> STRAP_OVERRIDE_SFO_OVRD_CONF_REG2_RESERVED1_SHIFT)
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_OVRD_CONF_REG2_RESERVED1_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_OVRD_CONF_REG2_RESERVED1_SHIFT))

#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG2_APP_OVRD_CONF1_MASK 0xffff
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG2_APP_OVRD_CONF1_SHIFT 0
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG2_APP_OVRD_CONF1_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_OVRD_CONF_REG2_APP_OVRD_CONF1_MASK) >> STRAP_OVERRIDE_SFO_OVRD_CONF_REG2_APP_OVRD_CONF1_SHIFT)
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG2_APP_OVRD_CONF1_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_OVRD_CONF_REG2_APP_OVRD_CONF1_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_OVRD_CONF_REG2_APP_OVRD_CONF1_SHIFT))

//====================================================================
//Register: Overridden Configuration Register 3 (SFO_OVRD_CONF_REG3)
//====================================================================

#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG3_RESERVED1_MASK 0xffff0000
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG3_RESERVED1_SHIFT 16
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG3_RESERVED1_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_OVRD_CONF_REG3_RESERVED1_MASK) >> STRAP_OVERRIDE_SFO_OVRD_CONF_REG3_RESERVED1_SHIFT)
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_OVRD_CONF_REG3_RESERVED1_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_OVRD_CONF_REG3_RESERVED1_SHIFT))

#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG3_APP_OVRD_CONF2_MASK 0xffff
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG3_APP_OVRD_CONF2_SHIFT 0
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG3_APP_OVRD_CONF2_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_OVRD_CONF_REG3_APP_OVRD_CONF2_MASK) >> STRAP_OVERRIDE_SFO_OVRD_CONF_REG3_APP_OVRD_CONF2_SHIFT)
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG3_APP_OVRD_CONF2_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_OVRD_CONF_REG3_APP_OVRD_CONF2_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_OVRD_CONF_REG3_APP_OVRD_CONF2_SHIFT))

//====================================================================
//Register: Overridden Configuration Register 4 (SFO_OVRD_CONF_REG4)
//====================================================================

#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG4_RESERVED1_MASK 0xffff0000
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG4_RESERVED1_SHIFT 16
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG4_RESERVED1_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_OVRD_CONF_REG4_RESERVED1_MASK) >> STRAP_OVERRIDE_SFO_OVRD_CONF_REG4_RESERVED1_SHIFT)
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_OVRD_CONF_REG4_RESERVED1_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_OVRD_CONF_REG4_RESERVED1_SHIFT))

#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG4_APP_OVRD_CONF3_MASK 0xffff
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG4_APP_OVRD_CONF3_SHIFT 0
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG4_APP_OVRD_CONF3_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_OVRD_CONF_REG4_APP_OVRD_CONF3_MASK) >> STRAP_OVERRIDE_SFO_OVRD_CONF_REG4_APP_OVRD_CONF3_SHIFT)
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG4_APP_OVRD_CONF3_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_OVRD_CONF_REG4_APP_OVRD_CONF3_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_OVRD_CONF_REG4_APP_OVRD_CONF3_SHIFT))

//====================================================================
//Register: Overridden Configuration Register 5 (SFO_OVRD_CONF_REG5)
//====================================================================

#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_RESERVED1_MASK 0xffff0000
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_RESERVED1_SHIFT 16
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_RESERVED1_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_RESERVED1_MASK) >> STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_RESERVED1_SHIFT)
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_RESERVED1_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_RESERVED1_SHIFT))

#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_DISABLE_STRAP_OVR_MASK 0x8000
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_DISABLE_STRAP_OVR_SHIFT 15
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_DISABLE_STRAP_OVR_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_DISABLE_STRAP_OVR_MASK) >> STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_DISABLE_STRAP_OVR_SHIFT)
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_DISABLE_STRAP_OVR_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_DISABLE_STRAP_OVR_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_DISABLE_STRAP_OVR_SHIFT))

#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_DISABLE_AIB_OVR_MASK 0x4000
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_DISABLE_AIB_OVR_SHIFT 14
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_DISABLE_AIB_OVR_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_DISABLE_AIB_OVR_MASK) >> STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_DISABLE_AIB_OVR_SHIFT)
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_DISABLE_AIB_OVR_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_DISABLE_AIB_OVR_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_DISABLE_AIB_OVR_SHIFT))

#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_APP_OVRD_CONF4_MASK 0x3fff
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_APP_OVRD_CONF4_SHIFT 0
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_APP_OVRD_CONF4_MASK_SHIFT(reg) (((reg) & STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_APP_OVRD_CONF4_MASK) >> STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_APP_OVRD_CONF4_SHIFT)
#define  STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_APP_OVRD_CONF4_REPLACE_VAL(reg,val) (((reg) & ~STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_APP_OVRD_CONF4_MASK) | (((uint32_t)val) << STRAP_OVERRIDE_SFO_OVRD_CONF_REG5_APP_OVRD_CONF4_SHIFT))

//====================================================================
//
//Register File: UART1 Registers (UART1)
//
//====================================================================

//====================================================================
//Register: Receive Buffer Register (UART_RBR)
/** \brief In non-FIFO mode, this register holds the character(s) received by the UART
Receive Shift Register. If this register is configured to use fewer than eight
bits, the bits are right-justified and the most significant bits (MSbs) are
zeroed. Reading the register empties the register and clears the <Data
Ready> field in the Line Status Register.
This register latches the value of the data byte at the front of the FIFO in
FIFO mode.*/
//====================================================================

#define  UART1_UART_RBR_BYTE_3_MASK 0xff000000
#define  UART1_UART_RBR_BYTE_3_SHIFT 24
#define  UART1_UART_RBR_BYTE_3_MASK_SHIFT(reg) (((reg) & UART1_UART_RBR_BYTE_3_MASK) >> UART1_UART_RBR_BYTE_3_SHIFT)
#define  UART1_UART_RBR_BYTE_3_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_RBR_BYTE_3_MASK) | (((uint32_t)val) << UART1_UART_RBR_BYTE_3_SHIFT))

#define  UART1_UART_RBR_BYTE_2_MASK 0xff0000
#define  UART1_UART_RBR_BYTE_2_SHIFT 16
#define  UART1_UART_RBR_BYTE_2_MASK_SHIFT(reg) (((reg) & UART1_UART_RBR_BYTE_2_MASK) >> UART1_UART_RBR_BYTE_2_SHIFT)
#define  UART1_UART_RBR_BYTE_2_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_RBR_BYTE_2_MASK) | (((uint32_t)val) << UART1_UART_RBR_BYTE_2_SHIFT))

#define  UART1_UART_RBR_BYTE_1_MASK 0xff00
#define  UART1_UART_RBR_BYTE_1_SHIFT 8
#define  UART1_UART_RBR_BYTE_1_MASK_SHIFT(reg) (((reg) & UART1_UART_RBR_BYTE_1_MASK) >> UART1_UART_RBR_BYTE_1_SHIFT)
#define  UART1_UART_RBR_BYTE_1_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_RBR_BYTE_1_MASK) | (((uint32_t)val) << UART1_UART_RBR_BYTE_1_SHIFT))

#define  UART1_UART_RBR_BYTE_0_MASK 0xff
#define  UART1_UART_RBR_BYTE_0_SHIFT 0
#define  UART1_UART_RBR_BYTE_0_MASK_SHIFT(reg) (((reg) & UART1_UART_RBR_BYTE_0_MASK) >> UART1_UART_RBR_BYTE_0_SHIFT)
#define  UART1_UART_RBR_BYTE_0_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_RBR_BYTE_0_MASK) | (((uint32_t)val) << UART1_UART_RBR_BYTE_0_SHIFT))

//====================================================================
//Register: Transmit Holding Register (UART_THR)
/** \brief This register holds the data byte(s) to be transmitted next in non-FIFO mode.
When the Transmit Shift Register is emptied, the contents of this register are
loaded into the Transmit Shift Register and the <Transmit Data Request> field in
the Line Status Register is set.
A write to Transmit Holding Register puts data into the top of the FIFO in FIFO
mode. The data at the front of the FIFO is loaded into the Transmit Shift
Register when the Transmit Shift Register is empty.*/
//====================================================================

#define  UART1_UART_THR_BYTE_3_MASK 0xff000000
#define  UART1_UART_THR_BYTE_3_SHIFT 24
#define  UART1_UART_THR_BYTE_3_MASK_SHIFT(reg) (((reg) & UART1_UART_THR_BYTE_3_MASK) >> UART1_UART_THR_BYTE_3_SHIFT)
#define  UART1_UART_THR_BYTE_3_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_THR_BYTE_3_MASK) | (((uint32_t)val) << UART1_UART_THR_BYTE_3_SHIFT))

#define  UART1_UART_THR_BYTE_2_MASK 0xff0000
#define  UART1_UART_THR_BYTE_2_SHIFT 16
#define  UART1_UART_THR_BYTE_2_MASK_SHIFT(reg) (((reg) & UART1_UART_THR_BYTE_2_MASK) >> UART1_UART_THR_BYTE_2_SHIFT)
#define  UART1_UART_THR_BYTE_2_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_THR_BYTE_2_MASK) | (((uint32_t)val) << UART1_UART_THR_BYTE_2_SHIFT))

#define  UART1_UART_THR_BYTE_1_MASK 0xff00
#define  UART1_UART_THR_BYTE_1_SHIFT 8
#define  UART1_UART_THR_BYTE_1_MASK_SHIFT(reg) (((reg) & UART1_UART_THR_BYTE_1_MASK) >> UART1_UART_THR_BYTE_1_SHIFT)
#define  UART1_UART_THR_BYTE_1_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_THR_BYTE_1_MASK) | (((uint32_t)val) << UART1_UART_THR_BYTE_1_SHIFT))

#define  UART1_UART_THR_BYTE_0_MASK 0xff
#define  UART1_UART_THR_BYTE_0_SHIFT 0
#define  UART1_UART_THR_BYTE_0_MASK_SHIFT(reg) (((reg) & UART1_UART_THR_BYTE_0_MASK) >> UART1_UART_THR_BYTE_0_SHIFT)
#define  UART1_UART_THR_BYTE_0_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_THR_BYTE_0_MASK) | (((uint32_t)val) << UART1_UART_THR_BYTE_0_SHIFT))

//====================================================================
//Register: Divisor Latch Low Byte Register (UART_DLL)
//====================================================================

#define  UART1_UART_DLL_RESERVED1_MASK 0xffffff00
#define  UART1_UART_DLL_RESERVED1_SHIFT 8
#define  UART1_UART_DLL_RESERVED1_MASK_SHIFT(reg) (((reg) & UART1_UART_DLL_RESERVED1_MASK) >> UART1_UART_DLL_RESERVED1_SHIFT)
#define  UART1_UART_DLL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_DLL_RESERVED1_MASK) | (((uint32_t)val) << UART1_UART_DLL_RESERVED1_SHIFT))

#define  UART1_UART_DLL_DLL_MASK 0xff
#define  UART1_UART_DLL_DLL_SHIFT 0
#define  UART1_UART_DLL_DLL_MASK_SHIFT(reg) (((reg) & UART1_UART_DLL_DLL_MASK) >> UART1_UART_DLL_DLL_SHIFT)
#define  UART1_UART_DLL_DLL_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_DLL_DLL_MASK) | (((uint32_t)val) << UART1_UART_DLL_DLL_SHIFT))

//====================================================================
//Register: Interrupt Enable Register (UART_IER)
/** \brief This register enables the five types of interrupts that set a value in the
Interrupt Identification Register. Software must clear the appropriate bit in
this register to disable an interrupt. Software can enable some interrupts by
setting the appropriate bit.
The character timeout-indication interrupt is separated from the received
data-available interrupt to ensure that the PXA2128 Application Processor and
the DMA controller do not service the receive FIFO at the same time. When
a character-timeout-indication interrupt occurs, the PXA2128 Application
Processor must handle the data in the receive FIFO through programmed I/O.
An error interrupt is used when DMA requests are enabled. The interrupt is
generated when the <FIFO Error Status> field in the Line Status Register is set
because a receive DMA request is not generated when the receive FIFO has an
error. The error interrupt tells the PXA2128 Application Processor to handle the
data in the receive FIFO through programmed I/O. The error interrupt is enabled
when DMA requests are enabled, and it cannot be masked. Receiver line-status
interrupts occur when the error is at the front of the FIFO.
Note: When DMA requests are enabled and an interrupt occurs, software must first
read the Line Status Register to see if an error interrupt exists, then check
the Interrupt Identification Register for the source of the interrupt. Software
must read the Infrared Selected Register to determine the error condition if an
interrupt occurs and the <FIFO Error Status> field in the Line Status Register
is clear. DMA requests are automatically enabled when the last error byte is
read from the FIFO. Software is not required to check for the error interrupt if
DMA requests are disabled because an error interrupt occurs only when DMA
requests are enabled.
The <FIFO Error Status> field is used to enable DMA requests. This register also
contains the unit enable and NRZ coding enable control bits. Bits 7 through 4
are used differently from the standard 16550A register definition.
Note: Software must not set the <DMA Requests Enable> field while the <Transmit
Data Request Interrupt Enable> or <Receiver Data Available Interrupt
Enable> fields are set to ensure that the DMA controller and programmed I/O do
not access the same FIFO.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART1_UART_IER_RESERVED1_MASK 0xfffffe00
#define  UART1_UART_IER_RESERVED1_SHIFT 9
#define  UART1_UART_IER_RESERVED1_MASK_SHIFT(reg) (((reg) & UART1_UART_IER_RESERVED1_MASK) >> UART1_UART_IER_RESERVED1_SHIFT)
#define  UART1_UART_IER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_IER_RESERVED1_MASK) | (((uint32_t)val) << UART1_UART_IER_RESERVED1_SHIFT))

#define  UART1_UART_IER_FAST_MASK 0x100
#define  UART1_UART_IER_FAST_SHIFT 8
#define  UART1_UART_IER_FAST_MASK_SHIFT(reg) (((reg) & UART1_UART_IER_FAST_MASK) >> UART1_UART_IER_FAST_SHIFT)
#define  UART1_UART_IER_FAST_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_IER_FAST_MASK) | (((uint32_t)val) << UART1_UART_IER_FAST_SHIFT))

#define  UART1_UART_IER_DMAE_MASK 0x80
#define  UART1_UART_IER_DMAE_SHIFT 7
#define  UART1_UART_IER_DMAE_MASK_SHIFT(reg) (((reg) & UART1_UART_IER_DMAE_MASK) >> UART1_UART_IER_DMAE_SHIFT)
#define  UART1_UART_IER_DMAE_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_IER_DMAE_MASK) | (((uint32_t)val) << UART1_UART_IER_DMAE_SHIFT))

#define  UART1_UART_IER_UUE_MASK 0x40
#define  UART1_UART_IER_UUE_SHIFT 6
#define  UART1_UART_IER_UUE_MASK_SHIFT(reg) (((reg) & UART1_UART_IER_UUE_MASK) >> UART1_UART_IER_UUE_SHIFT)
#define  UART1_UART_IER_UUE_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_IER_UUE_MASK) | (((uint32_t)val) << UART1_UART_IER_UUE_SHIFT))

#define  UART1_UART_IER_NRZE_MASK 0x20
#define  UART1_UART_IER_NRZE_SHIFT 5
#define  UART1_UART_IER_NRZE_MASK_SHIFT(reg) (((reg) & UART1_UART_IER_NRZE_MASK) >> UART1_UART_IER_NRZE_SHIFT)
#define  UART1_UART_IER_NRZE_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_IER_NRZE_MASK) | (((uint32_t)val) << UART1_UART_IER_NRZE_SHIFT))

#define  UART1_UART_IER_RTOIE_MASK 0x10
#define  UART1_UART_IER_RTOIE_SHIFT 4
#define  UART1_UART_IER_RTOIE_MASK_SHIFT(reg) (((reg) & UART1_UART_IER_RTOIE_MASK) >> UART1_UART_IER_RTOIE_SHIFT)
#define  UART1_UART_IER_RTOIE_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_IER_RTOIE_MASK) | (((uint32_t)val) << UART1_UART_IER_RTOIE_SHIFT))

#define  UART1_UART_IER_MIE_MASK 0x8
#define  UART1_UART_IER_MIE_SHIFT 3
#define  UART1_UART_IER_MIE_MASK_SHIFT(reg) (((reg) & UART1_UART_IER_MIE_MASK) >> UART1_UART_IER_MIE_SHIFT)
#define  UART1_UART_IER_MIE_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_IER_MIE_MASK) | (((uint32_t)val) << UART1_UART_IER_MIE_SHIFT))

#define  UART1_UART_IER_RLSE_MASK 0x4
#define  UART1_UART_IER_RLSE_SHIFT 2
#define  UART1_UART_IER_RLSE_MASK_SHIFT(reg) (((reg) & UART1_UART_IER_RLSE_MASK) >> UART1_UART_IER_RLSE_SHIFT)
#define  UART1_UART_IER_RLSE_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_IER_RLSE_MASK) | (((uint32_t)val) << UART1_UART_IER_RLSE_SHIFT))

#define  UART1_UART_IER_TIE_MASK 0x2
#define  UART1_UART_IER_TIE_SHIFT 1
#define  UART1_UART_IER_TIE_MASK_SHIFT(reg) (((reg) & UART1_UART_IER_TIE_MASK) >> UART1_UART_IER_TIE_SHIFT)
#define  UART1_UART_IER_TIE_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_IER_TIE_MASK) | (((uint32_t)val) << UART1_UART_IER_TIE_SHIFT))

#define  UART1_UART_IER_RAVIE_MASK 0x1
#define  UART1_UART_IER_RAVIE_SHIFT 0
#define  UART1_UART_IER_RAVIE_MASK_SHIFT(reg) (((reg) & UART1_UART_IER_RAVIE_MASK) >> UART1_UART_IER_RAVIE_SHIFT)
#define  UART1_UART_IER_RAVIE_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_IER_RAVIE_MASK) | (((uint32_t)val) << UART1_UART_IER_RAVIE_SHIFT))

//====================================================================
//Register: Divisor Latch High Byte Register (UART_DLH)
//====================================================================

#define  UART1_UART_DLH_RESERVED1_MASK 0xffffff00
#define  UART1_UART_DLH_RESERVED1_SHIFT 8
#define  UART1_UART_DLH_RESERVED1_MASK_SHIFT(reg) (((reg) & UART1_UART_DLH_RESERVED1_MASK) >> UART1_UART_DLH_RESERVED1_SHIFT)
#define  UART1_UART_DLH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_DLH_RESERVED1_MASK) | (((uint32_t)val) << UART1_UART_DLH_RESERVED1_SHIFT))

#define  UART1_UART_DLH_DLH_MASK 0xff
#define  UART1_UART_DLH_DLH_SHIFT 0
#define  UART1_UART_DLH_DLH_MASK_SHIFT(reg) (((reg) & UART1_UART_DLH_DLH_MASK) >> UART1_UART_DLH_DLH_SHIFT)
#define  UART1_UART_DLH_DLH_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_DLH_DLH_MASK) | (((uint32_t)val) << UART1_UART_DLH_DLH_SHIFT))

//====================================================================
//Register: Interrupt Identification Register (UART_IIR)
//====================================================================

#define  UART1_UART_IIR_RESERVED1_MASK 0xffffff00
#define  UART1_UART_IIR_RESERVED1_SHIFT 8
#define  UART1_UART_IIR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART1_UART_IIR_RESERVED1_MASK) >> UART1_UART_IIR_RESERVED1_SHIFT)
#define  UART1_UART_IIR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_IIR_RESERVED1_MASK) | (((uint32_t)val) << UART1_UART_IIR_RESERVED1_SHIFT))

#define  UART1_UART_IIR_FIFOES10_MASK 0xc0
#define  UART1_UART_IIR_FIFOES10_SHIFT 6
#define  UART1_UART_IIR_FIFOES10_MASK_SHIFT(reg) (((reg) & UART1_UART_IIR_FIFOES10_MASK) >> UART1_UART_IIR_FIFOES10_SHIFT)
#define  UART1_UART_IIR_FIFOES10_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_IIR_FIFOES10_MASK) | (((uint32_t)val) << UART1_UART_IIR_FIFOES10_SHIFT))

#define  UART1_UART_IIR_EOC_MASK 0x20
#define  UART1_UART_IIR_EOC_SHIFT 5
#define  UART1_UART_IIR_EOC_MASK_SHIFT(reg) (((reg) & UART1_UART_IIR_EOC_MASK) >> UART1_UART_IIR_EOC_SHIFT)
#define  UART1_UART_IIR_EOC_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_IIR_EOC_MASK) | (((uint32_t)val) << UART1_UART_IIR_EOC_SHIFT))

#define  UART1_UART_IIR_ABL_MASK 0x10
#define  UART1_UART_IIR_ABL_SHIFT 4
#define  UART1_UART_IIR_ABL_MASK_SHIFT(reg) (((reg) & UART1_UART_IIR_ABL_MASK) >> UART1_UART_IIR_ABL_SHIFT)
#define  UART1_UART_IIR_ABL_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_IIR_ABL_MASK) | (((uint32_t)val) << UART1_UART_IIR_ABL_SHIFT))

#define  UART1_UART_IIR_TOD_MASK 0x8
#define  UART1_UART_IIR_TOD_SHIFT 3
#define  UART1_UART_IIR_TOD_MASK_SHIFT(reg) (((reg) & UART1_UART_IIR_TOD_MASK) >> UART1_UART_IIR_TOD_SHIFT)
#define  UART1_UART_IIR_TOD_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_IIR_TOD_MASK) | (((uint32_t)val) << UART1_UART_IIR_TOD_SHIFT))

#define  UART1_UART_IIR_IID10_MASK 0x6
#define  UART1_UART_IIR_IID10_SHIFT 1
#define  UART1_UART_IIR_IID10_MASK_SHIFT(reg) (((reg) & UART1_UART_IIR_IID10_MASK) >> UART1_UART_IIR_IID10_SHIFT)
#define  UART1_UART_IIR_IID10_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_IIR_IID10_MASK) | (((uint32_t)val) << UART1_UART_IIR_IID10_SHIFT))

#define  UART1_UART_IIR_NIP_MASK 0x1
#define  UART1_UART_IIR_NIP_SHIFT 0
#define  UART1_UART_IIR_NIP_MASK_SHIFT(reg) (((reg) & UART1_UART_IIR_NIP_MASK) >> UART1_UART_IIR_NIP_SHIFT)
#define  UART1_UART_IIR_NIP_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_IIR_NIP_MASK) | (((uint32_t)val) << UART1_UART_IIR_NIP_SHIFT))

//====================================================================
//Register: FIFO Control Register (UART_FCR)
/** \brief This is a write-only register that is located at the same address as the
Interrupt Identification Register, which is a read-only register. This register
enables/disables the transmit/receive FIFOs, clears the transmit/receive FIFOs,
and sets the receive FIFO trigger threshold.
Note: The trigger level must be equal to the DMA burst length programmed in the
DMA registers.
Interrupt Trigger Level - When the number of bytes in the receive FIFO equals
the interrupt trigger level programmed into this field and the
received-data-available interrupt is enabled (via the Interrupt Enable
Register), an interrupt is generated and the appropriate bits are set in the
Interrupt Identification Register. The receive DMA request is generated as well
when trigger level is reached. The trigger level must be greater than or equal
to the DMA burst size programmed in the DMA registers.
32-Bit Peripheral Bus - When clear, the UART ignores any information in the
upper three bytes of the 32-bit bus. A full- or partial-word read or write to
the UART with this field clear increments the FIFO counters by only one byte. If
this field is set, a full- or partial-word read or write increments the counter
by the number of valid bytes within the word.
Trailing Bytes - When clear, trailing bytes are handled by the PXA2128
Application Processor. When set, trailing bytes are handled automatically by the
DMA controller. See the DMA section for more information.
Transmit Interrupt Level - Setting this field causes transmitter interrupts and
DMA requests to occur when the transmit FIFO is empty. Clearing this field
causes transmitter interrupts and DMA requests to occur when the transmit FIFO
is half empty.
Reset Transmit FIFO - When this field is set, the transmit FIFO counter is reset
to clear all the bytes in the FIFO. The <Transmit Data Request> field in the
Line Status Register is set, generating a transmitter-requests-data interrupt
(<Interrupt Source Encoded> field in the Interrupt Identification Register) if
the <Transmit Data Request Interrupt Enable> field in the Interrupt Enable
Register is set. The Transmit Shift Register is not reset, it completes the
current transmission. Any DMA or transmit-FIFO-service-request interrupts are
cleared.
Note: The <Reset Transmit FIFO> field is reset to 0 automatically after the FIFO
is cleared.
Reset Receive FIFO - When this field is set, the receive FIFO counter is reset
to clear all the bytes in the FIFO. The <Data Ready> field in the Line Status
Register is cleared. All error bits in the FIFO and the <FIFO Error
Status> field in the Line Status Register are cleared. Any error bits (OE, PE,
FE, or BI) that had been set in the Line Status Register remain set. The Receive
Shift Register is not cleared. Any DMA or receive-FIFO-service-request
interrupts are cleared.
Note: The <Reset Receive FIFO> field is reset automatically to 0 after the FIFO
is cleared.
Transmit and Receive FIFO Enable - This field enables and disables the transmit
and receive FIFOs. When it is set, both FIFOs are enabled (FIFO mode). When it
is clear, the FIFOs are both disabled (non-FIFO mode). Writing 0x0 to this bit
clears all bytes in both FIFOs. When changing from FIFO mode to non-FIFO mode
and vice versa, data is cleared automatically from the FIFOs. Any DMA or
FIFO-service-request interrupts are cleared when this field is clear.
Note: This field must be 1 when other fields in this register are written, or
the other fields are not programmed.
This is a write-only register. Write 0x0 to reserved bits.*/
//====================================================================

#define  UART1_UART_FCR_RESERVED1_MASK 0xffffff00
#define  UART1_UART_FCR_RESERVED1_SHIFT 8
#define  UART1_UART_FCR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART1_UART_FCR_RESERVED1_MASK) >> UART1_UART_FCR_RESERVED1_SHIFT)
#define  UART1_UART_FCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_FCR_RESERVED1_MASK) | (((uint32_t)val) << UART1_UART_FCR_RESERVED1_SHIFT))

#define  UART1_UART_FCR_ITL_MASK 0xc0
#define  UART1_UART_FCR_ITL_SHIFT 6
#define  UART1_UART_FCR_ITL_MASK_SHIFT(reg) (((reg) & UART1_UART_FCR_ITL_MASK) >> UART1_UART_FCR_ITL_SHIFT)
#define  UART1_UART_FCR_ITL_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_FCR_ITL_MASK) | (((uint32_t)val) << UART1_UART_FCR_ITL_SHIFT))

#define  UART1_UART_FCR_BUS_MASK 0x20
#define  UART1_UART_FCR_BUS_SHIFT 5
#define  UART1_UART_FCR_BUS_MASK_SHIFT(reg) (((reg) & UART1_UART_FCR_BUS_MASK) >> UART1_UART_FCR_BUS_SHIFT)
#define  UART1_UART_FCR_BUS_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_FCR_BUS_MASK) | (((uint32_t)val) << UART1_UART_FCR_BUS_SHIFT))

#define  UART1_UART_FCR_TRAIL_MASK 0x10
#define  UART1_UART_FCR_TRAIL_SHIFT 4
#define  UART1_UART_FCR_TRAIL_MASK_SHIFT(reg) (((reg) & UART1_UART_FCR_TRAIL_MASK) >> UART1_UART_FCR_TRAIL_SHIFT)
#define  UART1_UART_FCR_TRAIL_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_FCR_TRAIL_MASK) | (((uint32_t)val) << UART1_UART_FCR_TRAIL_SHIFT))

#define  UART1_UART_FCR_TIL_MASK 0x8
#define  UART1_UART_FCR_TIL_SHIFT 3
#define  UART1_UART_FCR_TIL_MASK_SHIFT(reg) (((reg) & UART1_UART_FCR_TIL_MASK) >> UART1_UART_FCR_TIL_SHIFT)
#define  UART1_UART_FCR_TIL_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_FCR_TIL_MASK) | (((uint32_t)val) << UART1_UART_FCR_TIL_SHIFT))

#define  UART1_UART_FCR_RESETTF_MASK 0x4
#define  UART1_UART_FCR_RESETTF_SHIFT 2
#define  UART1_UART_FCR_RESETTF_MASK_SHIFT(reg) (((reg) & UART1_UART_FCR_RESETTF_MASK) >> UART1_UART_FCR_RESETTF_SHIFT)
#define  UART1_UART_FCR_RESETTF_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_FCR_RESETTF_MASK) | (((uint32_t)val) << UART1_UART_FCR_RESETTF_SHIFT))

#define  UART1_UART_FCR_RESETRF_MASK 0x2
#define  UART1_UART_FCR_RESETRF_SHIFT 1
#define  UART1_UART_FCR_RESETRF_MASK_SHIFT(reg) (((reg) & UART1_UART_FCR_RESETRF_MASK) >> UART1_UART_FCR_RESETRF_SHIFT)
#define  UART1_UART_FCR_RESETRF_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_FCR_RESETRF_MASK) | (((uint32_t)val) << UART1_UART_FCR_RESETRF_SHIFT))

#define  UART1_UART_FCR_TRFIFOE_MASK 0x1
#define  UART1_UART_FCR_TRFIFOE_SHIFT 0
#define  UART1_UART_FCR_TRFIFOE_MASK_SHIFT(reg) (((reg) & UART1_UART_FCR_TRFIFOE_MASK) >> UART1_UART_FCR_TRFIFOE_SHIFT)
#define  UART1_UART_FCR_TRFIFOE_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_FCR_TRFIFOE_MASK) | (((uint32_t)val) << UART1_UART_FCR_TRFIFOE_SHIFT))

//====================================================================
//Register: Line Control Register (UART_LCR)
/** \brief This register specifies the format for the asynchronous data-communications
exchange. The serial-data format consists of a start bit, 8 data bits, an
optional parity bit, and 1 stop bit. This register has bits that allow access to
the Divisor Latch registers and bits that can cause a break condition.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART1_UART_LCR_RESERVED1_MASK 0xffffff00
#define  UART1_UART_LCR_RESERVED1_SHIFT 8
#define  UART1_UART_LCR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART1_UART_LCR_RESERVED1_MASK) >> UART1_UART_LCR_RESERVED1_SHIFT)
#define  UART1_UART_LCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_LCR_RESERVED1_MASK) | (((uint32_t)val) << UART1_UART_LCR_RESERVED1_SHIFT))

#define  UART1_UART_LCR_DLAB_MASK 0x80
#define  UART1_UART_LCR_DLAB_SHIFT 7
#define  UART1_UART_LCR_DLAB_MASK_SHIFT(reg) (((reg) & UART1_UART_LCR_DLAB_MASK) >> UART1_UART_LCR_DLAB_SHIFT)
#define  UART1_UART_LCR_DLAB_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_LCR_DLAB_MASK) | (((uint32_t)val) << UART1_UART_LCR_DLAB_SHIFT))

#define  UART1_UART_LCR_SB_MASK 0x40
#define  UART1_UART_LCR_SB_SHIFT 6
#define  UART1_UART_LCR_SB_MASK_SHIFT(reg) (((reg) & UART1_UART_LCR_SB_MASK) >> UART1_UART_LCR_SB_SHIFT)
#define  UART1_UART_LCR_SB_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_LCR_SB_MASK) | (((uint32_t)val) << UART1_UART_LCR_SB_SHIFT))

#define  UART1_UART_LCR_STKYP_MASK 0x20
#define  UART1_UART_LCR_STKYP_SHIFT 5
#define  UART1_UART_LCR_STKYP_MASK_SHIFT(reg) (((reg) & UART1_UART_LCR_STKYP_MASK) >> UART1_UART_LCR_STKYP_SHIFT)
#define  UART1_UART_LCR_STKYP_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_LCR_STKYP_MASK) | (((uint32_t)val) << UART1_UART_LCR_STKYP_SHIFT))

#define  UART1_UART_LCR_EPS_MASK 0x10
#define  UART1_UART_LCR_EPS_SHIFT 4
#define  UART1_UART_LCR_EPS_MASK_SHIFT(reg) (((reg) & UART1_UART_LCR_EPS_MASK) >> UART1_UART_LCR_EPS_SHIFT)
#define  UART1_UART_LCR_EPS_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_LCR_EPS_MASK) | (((uint32_t)val) << UART1_UART_LCR_EPS_SHIFT))

#define  UART1_UART_LCR_PEN_MASK 0x8
#define  UART1_UART_LCR_PEN_SHIFT 3
#define  UART1_UART_LCR_PEN_MASK_SHIFT(reg) (((reg) & UART1_UART_LCR_PEN_MASK) >> UART1_UART_LCR_PEN_SHIFT)
#define  UART1_UART_LCR_PEN_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_LCR_PEN_MASK) | (((uint32_t)val) << UART1_UART_LCR_PEN_SHIFT))

#define  UART1_UART_LCR_STB_MASK 0x4
#define  UART1_UART_LCR_STB_SHIFT 2
#define  UART1_UART_LCR_STB_MASK_SHIFT(reg) (((reg) & UART1_UART_LCR_STB_MASK) >> UART1_UART_LCR_STB_SHIFT)
#define  UART1_UART_LCR_STB_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_LCR_STB_MASK) | (((uint32_t)val) << UART1_UART_LCR_STB_SHIFT))

#define  UART1_UART_LCR_WLS10_MASK 0x3
#define  UART1_UART_LCR_WLS10_SHIFT 0
#define  UART1_UART_LCR_WLS10_MASK_SHIFT(reg) (((reg) & UART1_UART_LCR_WLS10_MASK) >> UART1_UART_LCR_WLS10_SHIFT)
#define  UART1_UART_LCR_WLS10_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_LCR_WLS10_MASK) | (((uint32_t)val) << UART1_UART_LCR_WLS10_SHIFT))

//====================================================================
//Register: Modem Control Register (UART_MCR)
/** \brief This register uses the modem control pins RTSn and DTRn to control the interface
with a modem or data set. This register also controls the loopback mode.
Loopback mode must be enabled before the UART is enabled.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART1_UART_MCR_RESERVED1_MASK 0xffffffc0
#define  UART1_UART_MCR_RESERVED1_SHIFT 6
#define  UART1_UART_MCR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART1_UART_MCR_RESERVED1_MASK) >> UART1_UART_MCR_RESERVED1_SHIFT)
#define  UART1_UART_MCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_MCR_RESERVED1_MASK) | (((uint32_t)val) << UART1_UART_MCR_RESERVED1_SHIFT))

#define  UART1_UART_MCR_AFE_MASK 0x20
#define  UART1_UART_MCR_AFE_SHIFT 5
#define  UART1_UART_MCR_AFE_MASK_SHIFT(reg) (((reg) & UART1_UART_MCR_AFE_MASK) >> UART1_UART_MCR_AFE_SHIFT)
#define  UART1_UART_MCR_AFE_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_MCR_AFE_MASK) | (((uint32_t)val) << UART1_UART_MCR_AFE_SHIFT))

#define  UART1_UART_MCR_LOOP_MASK 0x10
#define  UART1_UART_MCR_LOOP_SHIFT 4
#define  UART1_UART_MCR_LOOP_MASK_SHIFT(reg) (((reg) & UART1_UART_MCR_LOOP_MASK) >> UART1_UART_MCR_LOOP_SHIFT)
#define  UART1_UART_MCR_LOOP_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_MCR_LOOP_MASK) | (((uint32_t)val) << UART1_UART_MCR_LOOP_SHIFT))

#define  UART1_UART_MCR_OUT2_MASK 0x8
#define  UART1_UART_MCR_OUT2_SHIFT 3
#define  UART1_UART_MCR_OUT2_MASK_SHIFT(reg) (((reg) & UART1_UART_MCR_OUT2_MASK) >> UART1_UART_MCR_OUT2_SHIFT)
#define  UART1_UART_MCR_OUT2_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_MCR_OUT2_MASK) | (((uint32_t)val) << UART1_UART_MCR_OUT2_SHIFT))

#define  UART1_UART_MCR_OUT1_MASK 0x4
#define  UART1_UART_MCR_OUT1_SHIFT 2
#define  UART1_UART_MCR_OUT1_MASK_SHIFT(reg) (((reg) & UART1_UART_MCR_OUT1_MASK) >> UART1_UART_MCR_OUT1_SHIFT)
#define  UART1_UART_MCR_OUT1_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_MCR_OUT1_MASK) | (((uint32_t)val) << UART1_UART_MCR_OUT1_SHIFT))

#define  UART1_UART_MCR_RTS_MASK 0x2
#define  UART1_UART_MCR_RTS_SHIFT 1
#define  UART1_UART_MCR_RTS_MASK_SHIFT(reg) (((reg) & UART1_UART_MCR_RTS_MASK) >> UART1_UART_MCR_RTS_SHIFT)
#define  UART1_UART_MCR_RTS_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_MCR_RTS_MASK) | (((uint32_t)val) << UART1_UART_MCR_RTS_SHIFT))

#define  UART1_UART_MCR_DTR_MASK 0x1
#define  UART1_UART_MCR_DTR_SHIFT 0
#define  UART1_UART_MCR_DTR_MASK_SHIFT(reg) (((reg) & UART1_UART_MCR_DTR_MASK) >> UART1_UART_MCR_DTR_SHIFT)
#define  UART1_UART_MCR_DTR_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_MCR_DTR_MASK) | (((uint32_t)val) << UART1_UART_MCR_DTR_SHIFT))

//====================================================================
//Register: Line Status Register (UART_LSR)
/** \brief This register provides data-transfer status information to the PXA2128
Application Processor. In non-FIFO mode, bits [4:2] show the error status of the
character that has just been received. In FIFO mode, bits [4:2] show the status
bits of the character that is currently at the front of the FIFO.
Bits [4:1] produce a receiver-line-status interrupt when the corresponding
conditions are detected and the interrupt is enabled. In FIFO mode, the
receiver-line-status interrupt occurs only when the erroneous character reaches
the front of the FIFO. If the erroneous character is not at the front of the
FIFO, a line-status interrupt is generated after the other characters are read,
and the erroneous character becomes the character at the front of the FIFO.
This register must be read before the erroneous character is read. Bits [4:1]
remain set until software reads this register.
See FIFO DMA Mode Operation section in the PXA2128 Application Processor
Datasheet for details on using the DMAC to receive data.
This is a read-only register. Ignore reads from reserved bits.*/
//====================================================================

#define  UART1_UART_LSR_RESERVED1_MASK 0xffffff00
#define  UART1_UART_LSR_RESERVED1_SHIFT 8
#define  UART1_UART_LSR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART1_UART_LSR_RESERVED1_MASK) >> UART1_UART_LSR_RESERVED1_SHIFT)
#define  UART1_UART_LSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_LSR_RESERVED1_MASK) | (((uint32_t)val) << UART1_UART_LSR_RESERVED1_SHIFT))

#define  UART1_UART_LSR_FIFOE_MASK 0x80
#define  UART1_UART_LSR_FIFOE_SHIFT 7
#define  UART1_UART_LSR_FIFOE_MASK_SHIFT(reg) (((reg) & UART1_UART_LSR_FIFOE_MASK) >> UART1_UART_LSR_FIFOE_SHIFT)
#define  UART1_UART_LSR_FIFOE_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_LSR_FIFOE_MASK) | (((uint32_t)val) << UART1_UART_LSR_FIFOE_SHIFT))

#define  UART1_UART_LSR_TEMT_MASK 0x40
#define  UART1_UART_LSR_TEMT_SHIFT 6
#define  UART1_UART_LSR_TEMT_MASK_SHIFT(reg) (((reg) & UART1_UART_LSR_TEMT_MASK) >> UART1_UART_LSR_TEMT_SHIFT)
#define  UART1_UART_LSR_TEMT_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_LSR_TEMT_MASK) | (((uint32_t)val) << UART1_UART_LSR_TEMT_SHIFT))

#define  UART1_UART_LSR_TDRQ_MASK 0x20
#define  UART1_UART_LSR_TDRQ_SHIFT 5
#define  UART1_UART_LSR_TDRQ_MASK_SHIFT(reg) (((reg) & UART1_UART_LSR_TDRQ_MASK) >> UART1_UART_LSR_TDRQ_SHIFT)
#define  UART1_UART_LSR_TDRQ_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_LSR_TDRQ_MASK) | (((uint32_t)val) << UART1_UART_LSR_TDRQ_SHIFT))

#define  UART1_UART_LSR_BI_MASK 0x10
#define  UART1_UART_LSR_BI_SHIFT 4
#define  UART1_UART_LSR_BI_MASK_SHIFT(reg) (((reg) & UART1_UART_LSR_BI_MASK) >> UART1_UART_LSR_BI_SHIFT)
#define  UART1_UART_LSR_BI_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_LSR_BI_MASK) | (((uint32_t)val) << UART1_UART_LSR_BI_SHIFT))

#define  UART1_UART_LSR_FE_MASK 0x8
#define  UART1_UART_LSR_FE_SHIFT 3
#define  UART1_UART_LSR_FE_MASK_SHIFT(reg) (((reg) & UART1_UART_LSR_FE_MASK) >> UART1_UART_LSR_FE_SHIFT)
#define  UART1_UART_LSR_FE_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_LSR_FE_MASK) | (((uint32_t)val) << UART1_UART_LSR_FE_SHIFT))

#define  UART1_UART_LSR_PE_MASK 0x4
#define  UART1_UART_LSR_PE_SHIFT 2
#define  UART1_UART_LSR_PE_MASK_SHIFT(reg) (((reg) & UART1_UART_LSR_PE_MASK) >> UART1_UART_LSR_PE_SHIFT)
#define  UART1_UART_LSR_PE_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_LSR_PE_MASK) | (((uint32_t)val) << UART1_UART_LSR_PE_SHIFT))

#define  UART1_UART_LSR_OE_MASK 0x2
#define  UART1_UART_LSR_OE_SHIFT 1
#define  UART1_UART_LSR_OE_MASK_SHIFT(reg) (((reg) & UART1_UART_LSR_OE_MASK) >> UART1_UART_LSR_OE_SHIFT)
#define  UART1_UART_LSR_OE_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_LSR_OE_MASK) | (((uint32_t)val) << UART1_UART_LSR_OE_SHIFT))

#define  UART1_UART_LSR_DR_MASK 0x1
#define  UART1_UART_LSR_DR_SHIFT 0
#define  UART1_UART_LSR_DR_MASK_SHIFT(reg) (((reg) & UART1_UART_LSR_DR_MASK) >> UART1_UART_LSR_DR_SHIFT)
#define  UART1_UART_LSR_DR_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_LSR_DR_MASK) | (((uint32_t)val) << UART1_UART_LSR_DR_SHIFT))

//====================================================================
//Register: Modem Status Register (UART_MSR)
/** \brief This register provides the current state of the control lines from the modem or
data set (or a peripheral device emulating a modem) to the PXA2128 Application
Processor. In addition to this current state information, four bits provide
change information. Bits [3:0] are set when a control input from the modem
changes state. They are cleared when the PXA2128 Application Processor reads
this register.
The status of the modem control lines does not affect the FIFOs. The <Modem
Interrupt Enable> field in the Interrupt Enable Register must be set to use
these lines for flow control. The interrupt service routine must disable the
UART when an interrupt occurs on one of the flow-control pins. The UART
continues transmission/reception of the current character and then stops. The
contents of the FIFOs are preserved. If the UART is re-enabled, transmission
continues where it stopped.
Note: When bit 0, 1, 2, or 3 is set, a modem-status interrupt is generated if
the <Modem Interrupt Enable> field is set.
This is a read-only register. Ignore reads from reserved bits.*/
//====================================================================

#define  UART1_UART_MSR_RESERVED1_MASK 0xffffff00
#define  UART1_UART_MSR_RESERVED1_SHIFT 8
#define  UART1_UART_MSR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART1_UART_MSR_RESERVED1_MASK) >> UART1_UART_MSR_RESERVED1_SHIFT)
#define  UART1_UART_MSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_MSR_RESERVED1_MASK) | (((uint32_t)val) << UART1_UART_MSR_RESERVED1_SHIFT))

#define  UART1_UART_MSR_DCD_MASK 0x80
#define  UART1_UART_MSR_DCD_SHIFT 7
#define  UART1_UART_MSR_DCD_MASK_SHIFT(reg) (((reg) & UART1_UART_MSR_DCD_MASK) >> UART1_UART_MSR_DCD_SHIFT)
#define  UART1_UART_MSR_DCD_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_MSR_DCD_MASK) | (((uint32_t)val) << UART1_UART_MSR_DCD_SHIFT))

#define  UART1_UART_MSR_RI_MASK 0x40
#define  UART1_UART_MSR_RI_SHIFT 6
#define  UART1_UART_MSR_RI_MASK_SHIFT(reg) (((reg) & UART1_UART_MSR_RI_MASK) >> UART1_UART_MSR_RI_SHIFT)
#define  UART1_UART_MSR_RI_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_MSR_RI_MASK) | (((uint32_t)val) << UART1_UART_MSR_RI_SHIFT))

#define  UART1_UART_MSR_DSR_MASK 0x20
#define  UART1_UART_MSR_DSR_SHIFT 5
#define  UART1_UART_MSR_DSR_MASK_SHIFT(reg) (((reg) & UART1_UART_MSR_DSR_MASK) >> UART1_UART_MSR_DSR_SHIFT)
#define  UART1_UART_MSR_DSR_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_MSR_DSR_MASK) | (((uint32_t)val) << UART1_UART_MSR_DSR_SHIFT))

#define  UART1_UART_MSR_CTS_MASK 0x10
#define  UART1_UART_MSR_CTS_SHIFT 4
#define  UART1_UART_MSR_CTS_MASK_SHIFT(reg) (((reg) & UART1_UART_MSR_CTS_MASK) >> UART1_UART_MSR_CTS_SHIFT)
#define  UART1_UART_MSR_CTS_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_MSR_CTS_MASK) | (((uint32_t)val) << UART1_UART_MSR_CTS_SHIFT))

#define  UART1_UART_MSR_DDCD_MASK 0x8
#define  UART1_UART_MSR_DDCD_SHIFT 3
#define  UART1_UART_MSR_DDCD_MASK_SHIFT(reg) (((reg) & UART1_UART_MSR_DDCD_MASK) >> UART1_UART_MSR_DDCD_SHIFT)
#define  UART1_UART_MSR_DDCD_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_MSR_DDCD_MASK) | (((uint32_t)val) << UART1_UART_MSR_DDCD_SHIFT))

#define  UART1_UART_MSR_TERI_MASK 0x4
#define  UART1_UART_MSR_TERI_SHIFT 2
#define  UART1_UART_MSR_TERI_MASK_SHIFT(reg) (((reg) & UART1_UART_MSR_TERI_MASK) >> UART1_UART_MSR_TERI_SHIFT)
#define  UART1_UART_MSR_TERI_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_MSR_TERI_MASK) | (((uint32_t)val) << UART1_UART_MSR_TERI_SHIFT))

#define  UART1_UART_MSR_DDSR_MASK 0x2
#define  UART1_UART_MSR_DDSR_SHIFT 1
#define  UART1_UART_MSR_DDSR_MASK_SHIFT(reg) (((reg) & UART1_UART_MSR_DDSR_MASK) >> UART1_UART_MSR_DDSR_SHIFT)
#define  UART1_UART_MSR_DDSR_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_MSR_DDSR_MASK) | (((uint32_t)val) << UART1_UART_MSR_DDSR_SHIFT))

#define  UART1_UART_MSR_DCTS_MASK 0x1
#define  UART1_UART_MSR_DCTS_SHIFT 0
#define  UART1_UART_MSR_DCTS_MASK_SHIFT(reg) (((reg) & UART1_UART_MSR_DCTS_MASK) >> UART1_UART_MSR_DCTS_SHIFT)
#define  UART1_UART_MSR_DCTS_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_MSR_DCTS_MASK) | (((uint32_t)val) << UART1_UART_MSR_DCTS_SHIFT))

//====================================================================
//Register: Scratchpad Register (UART_SCR)
/** \brief This register has no effect on the UART. It is intended as a scratchpad register
for use by programmers and is included for 16550A compatibility.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART1_UART_SCR_RESERVED1_MASK 0xffffff00
#define  UART1_UART_SCR_RESERVED1_SHIFT 8
#define  UART1_UART_SCR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART1_UART_SCR_RESERVED1_MASK) >> UART1_UART_SCR_RESERVED1_SHIFT)
#define  UART1_UART_SCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_SCR_RESERVED1_MASK) | (((uint32_t)val) << UART1_UART_SCR_RESERVED1_SHIFT))

#define  UART1_UART_SCR_SCRATCHPAD_MASK 0xff
#define  UART1_UART_SCR_SCRATCHPAD_SHIFT 0
#define  UART1_UART_SCR_SCRATCHPAD_MASK_SHIFT(reg) (((reg) & UART1_UART_SCR_SCRATCHPAD_MASK) >> UART1_UART_SCR_SCRATCHPAD_SHIFT)
#define  UART1_UART_SCR_SCRATCHPAD_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_SCR_SCRATCHPAD_MASK) | (((uint32_t)val) << UART1_UART_SCR_SCRATCHPAD_SHIFT))

//====================================================================
//Register: Infrared Selection Register (UART_ISR)
/** \brief Each UART can manage an IrDA module associated with it. This register controls
the IrDA functions (see Serial Infrared Asynchronous Interface in the PXA2128
Application Processor Datasheet).
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART1_UART_ISR_RESERVED1_MASK 0xffffffe0
#define  UART1_UART_ISR_RESERVED1_SHIFT 5
#define  UART1_UART_ISR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART1_UART_ISR_RESERVED1_MASK) >> UART1_UART_ISR_RESERVED1_SHIFT)
#define  UART1_UART_ISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_ISR_RESERVED1_MASK) | (((uint32_t)val) << UART1_UART_ISR_RESERVED1_SHIFT))

#define  UART1_UART_ISR_RXPL_MASK 0x10
#define  UART1_UART_ISR_RXPL_SHIFT 4
#define  UART1_UART_ISR_RXPL_MASK_SHIFT(reg) (((reg) & UART1_UART_ISR_RXPL_MASK) >> UART1_UART_ISR_RXPL_SHIFT)
#define  UART1_UART_ISR_RXPL_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_ISR_RXPL_MASK) | (((uint32_t)val) << UART1_UART_ISR_RXPL_SHIFT))

#define  UART1_UART_ISR_TXPL_MASK 0x8
#define  UART1_UART_ISR_TXPL_SHIFT 3
#define  UART1_UART_ISR_TXPL_MASK_SHIFT(reg) (((reg) & UART1_UART_ISR_TXPL_MASK) >> UART1_UART_ISR_TXPL_SHIFT)
#define  UART1_UART_ISR_TXPL_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_ISR_TXPL_MASK) | (((uint32_t)val) << UART1_UART_ISR_TXPL_SHIFT))

#define  UART1_UART_ISR_XMODE_MASK 0x4
#define  UART1_UART_ISR_XMODE_SHIFT 2
#define  UART1_UART_ISR_XMODE_MASK_SHIFT(reg) (((reg) & UART1_UART_ISR_XMODE_MASK) >> UART1_UART_ISR_XMODE_SHIFT)
#define  UART1_UART_ISR_XMODE_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_ISR_XMODE_MASK) | (((uint32_t)val) << UART1_UART_ISR_XMODE_SHIFT))

#define  UART1_UART_ISR_RCVEIR_MASK 0x2
#define  UART1_UART_ISR_RCVEIR_SHIFT 1
#define  UART1_UART_ISR_RCVEIR_MASK_SHIFT(reg) (((reg) & UART1_UART_ISR_RCVEIR_MASK) >> UART1_UART_ISR_RCVEIR_SHIFT)
#define  UART1_UART_ISR_RCVEIR_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_ISR_RCVEIR_MASK) | (((uint32_t)val) << UART1_UART_ISR_RCVEIR_SHIFT))

#define  UART1_UART_ISR_XMITIR_MASK 0x1
#define  UART1_UART_ISR_XMITIR_SHIFT 0
#define  UART1_UART_ISR_XMITIR_MASK_SHIFT(reg) (((reg) & UART1_UART_ISR_XMITIR_MASK) >> UART1_UART_ISR_XMITIR_SHIFT)
#define  UART1_UART_ISR_XMITIR_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_ISR_XMITIR_MASK) | (((uint32_t)val) << UART1_UART_ISR_XMITIR_SHIFT))

//====================================================================
//Register: Receive FIFO Occupancy Register (UART_FOR)
/** \brief This register shows the number of bytes currently remaining the receive FIFO.
This register can be used to determine the number of trailing bytes to remove in
the case when the DMA reaches the end of its descriptor chain or when
the <Trailing Bytes> field in the FIFO Control Register is clear, which
indicates that the PXA2128 Application Processor removes trailing bytes as
opposed to the DMA (see Removing Trailing Bytes in DMA Mode section in PXA2128
Application Processor Datasheet). This register is incremented once for each
byte of data written to the receive FIFO and decremented once for each byte
read.
This is a read/write register. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  UART1_UART_FOR_RESERVED1_MASK 0xffffffc0
#define  UART1_UART_FOR_RESERVED1_SHIFT 6
#define  UART1_UART_FOR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART1_UART_FOR_RESERVED1_MASK) >> UART1_UART_FOR_RESERVED1_SHIFT)
#define  UART1_UART_FOR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_FOR_RESERVED1_MASK) | (((uint32_t)val) << UART1_UART_FOR_RESERVED1_SHIFT))

#define  UART1_UART_FOR_BYTE_COUNT_MASK 0x3f
#define  UART1_UART_FOR_BYTE_COUNT_SHIFT 0
#define  UART1_UART_FOR_BYTE_COUNT_MASK_SHIFT(reg) (((reg) & UART1_UART_FOR_BYTE_COUNT_MASK) >> UART1_UART_FOR_BYTE_COUNT_SHIFT)
#define  UART1_UART_FOR_BYTE_COUNT_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_FOR_BYTE_COUNT_MASK) | (((uint32_t)val) << UART1_UART_FOR_BYTE_COUNT_SHIFT))

//====================================================================
//Register: Auto-Baud Control Register (UART_ABR)
/** \brief This register controls the functionality and options for auto-baud-rate
detection within the UART. Through this register, software can enable/disable
the auto-baud-lock interrupt, direct either the PXA2128 Application Processor or
the UART to program the final baud rate in the Divisor Latch registers, and
choose between two methods used to calculate the final baud rate.
The auto-baud circuitry counts the number of clocks in the start bit and writes
this count into the Auto-Baud Count register (ACR). It then interrupts the
PXA2128 Application Processor if the <Auto-baud Lock> field in the Interrupt
Identification Register is set. It also programs automatically the Divisor Latch
registers (DLL and DLH) if the <ABUP> field is set.
See Auto-Baud-Rate Detection section in PXA2128 Application Processor Datasheet
for more information on auto-baud rate.
Note: Auto-baud-rate detection is not supported in IrDA serial-infrared mode.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART1_UART_ABR_RESERVED1_MASK 0xfffffff0
#define  UART1_UART_ABR_RESERVED1_SHIFT 4
#define  UART1_UART_ABR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART1_UART_ABR_RESERVED1_MASK) >> UART1_UART_ABR_RESERVED1_SHIFT)
#define  UART1_UART_ABR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_ABR_RESERVED1_MASK) | (((uint32_t)val) << UART1_UART_ABR_RESERVED1_SHIFT))

#define  UART1_UART_ABR_ABT_MASK 0x8
#define  UART1_UART_ABR_ABT_SHIFT 3
#define  UART1_UART_ABR_ABT_MASK_SHIFT(reg) (((reg) & UART1_UART_ABR_ABT_MASK) >> UART1_UART_ABR_ABT_SHIFT)
#define  UART1_UART_ABR_ABT_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_ABR_ABT_MASK) | (((uint32_t)val) << UART1_UART_ABR_ABT_SHIFT))

#define  UART1_UART_ABR_ABUP_MASK 0x4
#define  UART1_UART_ABR_ABUP_SHIFT 2
#define  UART1_UART_ABR_ABUP_MASK_SHIFT(reg) (((reg) & UART1_UART_ABR_ABUP_MASK) >> UART1_UART_ABR_ABUP_SHIFT)
#define  UART1_UART_ABR_ABUP_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_ABR_ABUP_MASK) | (((uint32_t)val) << UART1_UART_ABR_ABUP_SHIFT))

#define  UART1_UART_ABR_ABLIE_MASK 0x2
#define  UART1_UART_ABR_ABLIE_SHIFT 1
#define  UART1_UART_ABR_ABLIE_MASK_SHIFT(reg) (((reg) & UART1_UART_ABR_ABLIE_MASK) >> UART1_UART_ABR_ABLIE_SHIFT)
#define  UART1_UART_ABR_ABLIE_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_ABR_ABLIE_MASK) | (((uint32_t)val) << UART1_UART_ABR_ABLIE_SHIFT))

#define  UART1_UART_ABR_ABE_MASK 0x1
#define  UART1_UART_ABR_ABE_SHIFT 0
#define  UART1_UART_ABR_ABE_MASK_SHIFT(reg) (((reg) & UART1_UART_ABR_ABE_MASK) >> UART1_UART_ABR_ABE_SHIFT)
#define  UART1_UART_ABR_ABE_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_ABR_ABE_MASK) | (((uint32_t)val) << UART1_UART_ABR_ABE_SHIFT))

//====================================================================
//Register: Auto-Baud Count Register (UART_ACR)
/** \brief This register stores the number of 14.857-MHz clock cycles within a start-bit
pulse. This value is then used by the PXA2128 Application Processor or the UART
to calculate the baud rate. If auto-baud mode (<ABE> field in Auto-Baud Control
Register) and auto-baud interrupts (<ABLIE> field in Auto-Baud Control Register)
are enabled, the UART interrupts the PXA2128 Application Processor with the
auto-baud-lock interrupt (IIR[ABL]) after it has written the count value into
ACR. The value is written regardless of the state of the auto-baud UART program
bit, (ABR[ABUP]).
This is a read-only register. Ignore reads from reserved bits.*/
//====================================================================

#define  UART1_UART_ACR_RESERVED1_MASK 0xffff0000
#define  UART1_UART_ACR_RESERVED1_SHIFT 16
#define  UART1_UART_ACR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART1_UART_ACR_RESERVED1_MASK) >> UART1_UART_ACR_RESERVED1_SHIFT)
#define  UART1_UART_ACR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_ACR_RESERVED1_MASK) | (((uint32_t)val) << UART1_UART_ACR_RESERVED1_SHIFT))

#define  UART1_UART_ACR_COUNT_VALUE_MASK 0xffff
#define  UART1_UART_ACR_COUNT_VALUE_SHIFT 0
#define  UART1_UART_ACR_COUNT_VALUE_MASK_SHIFT(reg) (((reg) & UART1_UART_ACR_COUNT_VALUE_MASK) >> UART1_UART_ACR_COUNT_VALUE_SHIFT)
#define  UART1_UART_ACR_COUNT_VALUE_REPLACE_VAL(reg,val) (((reg) & ~UART1_UART_ACR_COUNT_VALUE_MASK) | (((uint32_t)val) << UART1_UART_ACR_COUNT_VALUE_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  UART1_REV0_MAJ_MASK 0xffff0000
#define  UART1_REV0_MAJ_SHIFT 16
#define  UART1_REV0_MAJ_MASK_SHIFT(reg) (((reg) & UART1_REV0_MAJ_MASK) >> UART1_REV0_MAJ_SHIFT)
#define  UART1_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~UART1_REV0_MAJ_MASK) | (((uint32_t)val) << UART1_REV0_MAJ_SHIFT))

#define  UART1_REV0_MID_MASK 0xffff
#define  UART1_REV0_MID_SHIFT 0
#define  UART1_REV0_MID_MASK_SHIFT(reg) (((reg) & UART1_REV0_MID_MASK) >> UART1_REV0_MID_SHIFT)
#define  UART1_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~UART1_REV0_MID_MASK) | (((uint32_t)val) << UART1_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  UART1_REV1_RESERVED1_MASK 0xffff0000
#define  UART1_REV1_RESERVED1_SHIFT 16
#define  UART1_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & UART1_REV1_RESERVED1_MASK) >> UART1_REV1_RESERVED1_SHIFT)
#define  UART1_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART1_REV1_RESERVED1_MASK) | (((uint32_t)val) << UART1_REV1_RESERVED1_SHIFT))

#define  UART1_REV1_CFG_MASK 0xffff
#define  UART1_REV1_CFG_SHIFT 0
#define  UART1_REV1_CFG_MASK_SHIFT(reg) (((reg) & UART1_REV1_CFG_MASK) >> UART1_REV1_CFG_SHIFT)
#define  UART1_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~UART1_REV1_CFG_MASK) | (((uint32_t)val) << UART1_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: I2C2 Registers (I2C2)
//
//====================================================================

//====================================================================
//Register: TWSI Bus Monitor Register (TWSI_IBMR)
/** \brief The TWSI Bus Monitor register (IBMR) tracks the status of the SCL and SDA pins.
The values of these pins are recorded in this read-only IBMR, so software can
determine when the TWSI bus is hung and the TWSI unit must be reset.
This a read-only register. Ignore reads from reserved bits.*/
//====================================================================

#define  I2C2_TWSI_IBMR_RESERVED1_MASK 0xfffffffc
#define  I2C2_TWSI_IBMR_RESERVED1_SHIFT 2
#define  I2C2_TWSI_IBMR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_IBMR_RESERVED1_MASK) >> I2C2_TWSI_IBMR_RESERVED1_SHIFT)
#define  I2C2_TWSI_IBMR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_IBMR_RESERVED1_MASK) | (((uint32_t)val) << I2C2_TWSI_IBMR_RESERVED1_SHIFT))

#define  I2C2_TWSI_IBMR_SCL_MASK 0x2
#define  I2C2_TWSI_IBMR_SCL_SHIFT 1
#define  I2C2_TWSI_IBMR_SCL_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_IBMR_SCL_MASK) >> I2C2_TWSI_IBMR_SCL_SHIFT)
#define  I2C2_TWSI_IBMR_SCL_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_IBMR_SCL_MASK) | (((uint32_t)val) << I2C2_TWSI_IBMR_SCL_SHIFT))

#define  I2C2_TWSI_IBMR_SDA_MASK 0x1
#define  I2C2_TWSI_IBMR_SDA_SHIFT 0
#define  I2C2_TWSI_IBMR_SDA_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_IBMR_SDA_MASK) >> I2C2_TWSI_IBMR_SDA_SHIFT)
#define  I2C2_TWSI_IBMR_SDA_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_IBMR_SDA_MASK) | (((uint32_t)val) << I2C2_TWSI_IBMR_SDA_SHIFT))

//====================================================================
//Register: TWSI Data Buffer Register (TWSI_IDBR)
/** \brief The PXA2128 Application Processor use the TWSI Data Buffer register to transmit
and receive data from the TWSI bus. The IDBR is accessed by the program I/O on
one side and by the TWSI Shift register on the other. The IDBR receives data
coming into the TWSI unit after a full byte is received and acknowledged. The
PXA2128 Application Processor core writes data going out of the TWSI to the IDBR
and sends it to the serial bus.
When the TWSI is in transmit mode (master or slave), the PXA2128 Application
Processor writes data to the IDBR over the internal bus. The PXA2128 Application
Processor write data to the IDBR when a master transaction is initiated or when
the IDBR transmit-empty interrupt is signalled. Data moves from the IDBR to the
Shift register when the transfer byte bit is set. The IDBR transmit-empty
interrupt is signalled (if enabled) when a byte is transferred on the TWSI bus
and the acknowledge cycle is complete. If the IDBR is not written by the PXA2128
Application Processor, and a Stop condition is not in place before the TWSI bus
is ready to transfer the next byte packet, the TWSI unit inserts wait states
until the PXA2128 Application Processor writes the IDBR and sets the transfer
byte bit.
When the TWSI is in receive mode (master or slave), the PXA2128 Application
Processor reads IDBR data over the internal bus. The PXA2128 Application
Processor reads data from the IDBR when the IDBR receive-full interrupt is
signalled. The data moves from the Shift register to the IDBR when the
acknowledge cycle is complete. The TWSI inserts wait states until the IDBR is
read. See Section 12.4.6 for more information on the acknowledge pulse in
receive mode. After the software reads the IDBR, ICR[ACKNAK], and ICR[ACKNAK]
are written by the software, allowing the next byte transfer to proceed to the
TWSI bus.
These are read/write registers. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  I2C2_TWSI_IDBR_RESERVED1_MASK 0xffffff00
#define  I2C2_TWSI_IDBR_RESERVED1_SHIFT 8
#define  I2C2_TWSI_IDBR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_IDBR_RESERVED1_MASK) >> I2C2_TWSI_IDBR_RESERVED1_SHIFT)
#define  I2C2_TWSI_IDBR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_IDBR_RESERVED1_MASK) | (((uint32_t)val) << I2C2_TWSI_IDBR_RESERVED1_SHIFT))

#define  I2C2_TWSI_IDBR_DATA_BUFFER_MASK 0xff
#define  I2C2_TWSI_IDBR_DATA_BUFFER_SHIFT 0
#define  I2C2_TWSI_IDBR_DATA_BUFFER_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_IDBR_DATA_BUFFER_MASK) >> I2C2_TWSI_IDBR_DATA_BUFFER_SHIFT)
#define  I2C2_TWSI_IDBR_DATA_BUFFER_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_IDBR_DATA_BUFFER_MASK) | (((uint32_t)val) << I2C2_TWSI_IDBR_DATA_BUFFER_SHIFT))

//====================================================================
//Register: TWSI Control Register (TWSI_ICR)
/** \brief The PXA2128 Application Processor uses the bits in the TWSI Control register
(ICR) to control the TWSI unit.
These are read/write registers. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  I2C2_TWSI_ICR_RESERVED1_MASK 0x80000000
#define  I2C2_TWSI_ICR_RESERVED1_SHIFT 31
#define  I2C2_TWSI_ICR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_RESERVED1_MASK) >> I2C2_TWSI_ICR_RESERVED1_SHIFT)
#define  I2C2_TWSI_ICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_RESERVED1_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_RESERVED1_SHIFT))

#define  I2C2_TWSI_ICR_SDA_GFE_MASK 0x40000000
#define  I2C2_TWSI_ICR_SDA_GFE_SHIFT 30
#define  I2C2_TWSI_ICR_SDA_GFE_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_SDA_GFE_MASK) >> I2C2_TWSI_ICR_SDA_GFE_SHIFT)
#define  I2C2_TWSI_ICR_SDA_GFE_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_SDA_GFE_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_SDA_GFE_SHIFT))

#define  I2C2_TWSI_ICR_TXOV_IE_MASK 0x20000000
#define  I2C2_TWSI_ICR_TXOV_IE_SHIFT 29
#define  I2C2_TWSI_ICR_TXOV_IE_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_TXOV_IE_MASK) >> I2C2_TWSI_ICR_TXOV_IE_SHIFT)
#define  I2C2_TWSI_ICR_TXOV_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_TXOV_IE_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_TXOV_IE_SHIFT))

#define  I2C2_TWSI_ICR_RXUN_IE_MASK 0x10000000
#define  I2C2_TWSI_ICR_RXUN_IE_SHIFT 28
#define  I2C2_TWSI_ICR_RXUN_IE_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_RXUN_IE_MASK) >> I2C2_TWSI_ICR_RXUN_IE_SHIFT)
#define  I2C2_TWSI_ICR_RXUN_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_RXUN_IE_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_RXUN_IE_SHIFT))

#define  I2C2_TWSI_ICR_DMA_EN_MASK 0x8000000
#define  I2C2_TWSI_ICR_DMA_EN_SHIFT 27
#define  I2C2_TWSI_ICR_DMA_EN_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_DMA_EN_MASK) >> I2C2_TWSI_ICR_DMA_EN_SHIFT)
#define  I2C2_TWSI_ICR_DMA_EN_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_DMA_EN_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_DMA_EN_SHIFT))

#define  I2C2_TWSI_ICR_RXOV_IE_MASK 0x4000000
#define  I2C2_TWSI_ICR_RXOV_IE_SHIFT 26
#define  I2C2_TWSI_ICR_RXOV_IE_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_RXOV_IE_MASK) >> I2C2_TWSI_ICR_RXOV_IE_SHIFT)
#define  I2C2_TWSI_ICR_RXOV_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_RXOV_IE_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_RXOV_IE_SHIFT))

#define  I2C2_TWSI_ICR_RXF_IE_MASK 0x2000000
#define  I2C2_TWSI_ICR_RXF_IE_SHIFT 25
#define  I2C2_TWSI_ICR_RXF_IE_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_RXF_IE_MASK) >> I2C2_TWSI_ICR_RXF_IE_SHIFT)
#define  I2C2_TWSI_ICR_RXF_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_RXF_IE_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_RXF_IE_SHIFT))

#define  I2C2_TWSI_ICR_TXSR_IE_MASK 0x1000000
#define  I2C2_TWSI_ICR_TXSR_IE_SHIFT 24
#define  I2C2_TWSI_ICR_TXSR_IE_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_TXSR_IE_MASK) >> I2C2_TWSI_ICR_TXSR_IE_SHIFT)
#define  I2C2_TWSI_ICR_TXSR_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_TXSR_IE_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_TXSR_IE_SHIFT))

#define  I2C2_TWSI_ICR_RXSR_IE_MASK 0x800000
#define  I2C2_TWSI_ICR_RXSR_IE_SHIFT 23
#define  I2C2_TWSI_ICR_RXSR_IE_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_RXSR_IE_MASK) >> I2C2_TWSI_ICR_RXSR_IE_SHIFT)
#define  I2C2_TWSI_ICR_RXSR_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_RXSR_IE_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_RXSR_IE_SHIFT))

#define  I2C2_TWSI_ICR_TXDONE_IE_MASK 0x400000
#define  I2C2_TWSI_ICR_TXDONE_IE_SHIFT 22
#define  I2C2_TWSI_ICR_TXDONE_IE_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_TXDONE_IE_MASK) >> I2C2_TWSI_ICR_TXDONE_IE_SHIFT)
#define  I2C2_TWSI_ICR_TXDONE_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_TXDONE_IE_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_TXDONE_IE_SHIFT))

#define  I2C2_TWSI_ICR_TXBEGIN_MASK 0x200000
#define  I2C2_TWSI_ICR_TXBEGIN_SHIFT 21
#define  I2C2_TWSI_ICR_TXBEGIN_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_TXBEGIN_MASK) >> I2C2_TWSI_ICR_TXBEGIN_SHIFT)
#define  I2C2_TWSI_ICR_TXBEGIN_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_TXBEGIN_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_TXBEGIN_SHIFT))

#define  I2C2_TWSI_ICR_FIFOEN_MASK 0x100000
#define  I2C2_TWSI_ICR_FIFOEN_SHIFT 20
#define  I2C2_TWSI_ICR_FIFOEN_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_FIFOEN_MASK) >> I2C2_TWSI_ICR_FIFOEN_SHIFT)
#define  I2C2_TWSI_ICR_FIFOEN_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_FIFOEN_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_FIFOEN_SHIFT))

#define  I2C2_TWSI_ICR_GPIOEN_MASK 0x80000
#define  I2C2_TWSI_ICR_GPIOEN_SHIFT 19
#define  I2C2_TWSI_ICR_GPIOEN_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_GPIOEN_MASK) >> I2C2_TWSI_ICR_GPIOEN_SHIFT)
#define  I2C2_TWSI_ICR_GPIOEN_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_GPIOEN_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_GPIOEN_SHIFT))

#define  I2C2_TWSI_ICR_MSDE_MASK 0x40000
#define  I2C2_TWSI_ICR_MSDE_SHIFT 18
#define  I2C2_TWSI_ICR_MSDE_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_MSDE_MASK) >> I2C2_TWSI_ICR_MSDE_SHIFT)
#define  I2C2_TWSI_ICR_MSDE_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_MSDE_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_MSDE_SHIFT))

#define  I2C2_TWSI_ICR_MSDIE_MASK 0x20000
#define  I2C2_TWSI_ICR_MSDIE_SHIFT 17
#define  I2C2_TWSI_ICR_MSDIE_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_MSDIE_MASK) >> I2C2_TWSI_ICR_MSDIE_SHIFT)
#define  I2C2_TWSI_ICR_MSDIE_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_MSDIE_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_MSDIE_SHIFT))

#define  I2C2_TWSI_ICR_MODE_MASK 0x18000
#define  I2C2_TWSI_ICR_MODE_SHIFT 15
#define  I2C2_TWSI_ICR_MODE_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_MODE_MASK) >> I2C2_TWSI_ICR_MODE_SHIFT)
#define  I2C2_TWSI_ICR_MODE_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_MODE_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_MODE_SHIFT))

#define  I2C2_TWSI_ICR_UR_MASK 0x4000
#define  I2C2_TWSI_ICR_UR_SHIFT 14
#define  I2C2_TWSI_ICR_UR_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_UR_MASK) >> I2C2_TWSI_ICR_UR_SHIFT)
#define  I2C2_TWSI_ICR_UR_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_UR_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_UR_SHIFT))

#define  I2C2_TWSI_ICR_SADIE_MASK 0x2000
#define  I2C2_TWSI_ICR_SADIE_SHIFT 13
#define  I2C2_TWSI_ICR_SADIE_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_SADIE_MASK) >> I2C2_TWSI_ICR_SADIE_SHIFT)
#define  I2C2_TWSI_ICR_SADIE_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_SADIE_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_SADIE_SHIFT))

#define  I2C2_TWSI_ICR_ALDIE_MASK 0x1000
#define  I2C2_TWSI_ICR_ALDIE_SHIFT 12
#define  I2C2_TWSI_ICR_ALDIE_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_ALDIE_MASK) >> I2C2_TWSI_ICR_ALDIE_SHIFT)
#define  I2C2_TWSI_ICR_ALDIE_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_ALDIE_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_ALDIE_SHIFT))

#define  I2C2_TWSI_ICR_SSDIE_MASK 0x800
#define  I2C2_TWSI_ICR_SSDIE_SHIFT 11
#define  I2C2_TWSI_ICR_SSDIE_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_SSDIE_MASK) >> I2C2_TWSI_ICR_SSDIE_SHIFT)
#define  I2C2_TWSI_ICR_SSDIE_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_SSDIE_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_SSDIE_SHIFT))

#define  I2C2_TWSI_ICR_BEIE_MASK 0x400
#define  I2C2_TWSI_ICR_BEIE_SHIFT 10
#define  I2C2_TWSI_ICR_BEIE_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_BEIE_MASK) >> I2C2_TWSI_ICR_BEIE_SHIFT)
#define  I2C2_TWSI_ICR_BEIE_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_BEIE_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_BEIE_SHIFT))

#define  I2C2_TWSI_ICR_DRFIE_MASK 0x200
#define  I2C2_TWSI_ICR_DRFIE_SHIFT 9
#define  I2C2_TWSI_ICR_DRFIE_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_DRFIE_MASK) >> I2C2_TWSI_ICR_DRFIE_SHIFT)
#define  I2C2_TWSI_ICR_DRFIE_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_DRFIE_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_DRFIE_SHIFT))

#define  I2C2_TWSI_ICR_ITEIE_MASK 0x100
#define  I2C2_TWSI_ICR_ITEIE_SHIFT 8
#define  I2C2_TWSI_ICR_ITEIE_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_ITEIE_MASK) >> I2C2_TWSI_ICR_ITEIE_SHIFT)
#define  I2C2_TWSI_ICR_ITEIE_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_ITEIE_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_ITEIE_SHIFT))

#define  I2C2_TWSI_ICR_GCD_MASK 0x80
#define  I2C2_TWSI_ICR_GCD_SHIFT 7
#define  I2C2_TWSI_ICR_GCD_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_GCD_MASK) >> I2C2_TWSI_ICR_GCD_SHIFT)
#define  I2C2_TWSI_ICR_GCD_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_GCD_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_GCD_SHIFT))

#define  I2C2_TWSI_ICR_IUE_MASK 0x40
#define  I2C2_TWSI_ICR_IUE_SHIFT 6
#define  I2C2_TWSI_ICR_IUE_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_IUE_MASK) >> I2C2_TWSI_ICR_IUE_SHIFT)
#define  I2C2_TWSI_ICR_IUE_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_IUE_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_IUE_SHIFT))

#define  I2C2_TWSI_ICR_SCLE_MASK 0x20
#define  I2C2_TWSI_ICR_SCLE_SHIFT 5
#define  I2C2_TWSI_ICR_SCLE_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_SCLE_MASK) >> I2C2_TWSI_ICR_SCLE_SHIFT)
#define  I2C2_TWSI_ICR_SCLE_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_SCLE_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_SCLE_SHIFT))

#define  I2C2_TWSI_ICR_MA_MASK 0x10
#define  I2C2_TWSI_ICR_MA_SHIFT 4
#define  I2C2_TWSI_ICR_MA_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_MA_MASK) >> I2C2_TWSI_ICR_MA_SHIFT)
#define  I2C2_TWSI_ICR_MA_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_MA_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_MA_SHIFT))

#define  I2C2_TWSI_ICR_TB_MASK 0x8
#define  I2C2_TWSI_ICR_TB_SHIFT 3
#define  I2C2_TWSI_ICR_TB_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_TB_MASK) >> I2C2_TWSI_ICR_TB_SHIFT)
#define  I2C2_TWSI_ICR_TB_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_TB_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_TB_SHIFT))

#define  I2C2_TWSI_ICR_ACKNAK_MASK 0x4
#define  I2C2_TWSI_ICR_ACKNAK_SHIFT 2
#define  I2C2_TWSI_ICR_ACKNAK_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_ACKNAK_MASK) >> I2C2_TWSI_ICR_ACKNAK_SHIFT)
#define  I2C2_TWSI_ICR_ACKNAK_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_ACKNAK_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_ACKNAK_SHIFT))

#define  I2C2_TWSI_ICR_STOP_MASK 0x2
#define  I2C2_TWSI_ICR_STOP_SHIFT 1
#define  I2C2_TWSI_ICR_STOP_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_STOP_MASK) >> I2C2_TWSI_ICR_STOP_SHIFT)
#define  I2C2_TWSI_ICR_STOP_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_STOP_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_STOP_SHIFT))

#define  I2C2_TWSI_ICR_START_MASK 0x1
#define  I2C2_TWSI_ICR_START_SHIFT 0
#define  I2C2_TWSI_ICR_START_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ICR_START_MASK) >> I2C2_TWSI_ICR_START_SHIFT)
#define  I2C2_TWSI_ICR_START_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ICR_START_MASK) | (((uint32_t)val) << I2C2_TWSI_ICR_START_SHIFT))

//====================================================================
//Register: TWSI Status Register (TWSI_ISR)
/** \brief TWSI interrupts are signalled to the PXA2128 Application Processor interrupt
controller by the TWSI Interrupt Status register. Software uses the ISR bits to
check the status of the TWSI unit and bus. ISR bits (bits 9-5) are updated after
the ACK/NAK bit has completed on the TWSI bus.
The ISR is also used to clear interrupts signalled from the TWSI bus interface
unit, and include the following:
- IDBR receive full
- IDBR transmit empty
- Slave address detected
- Bus error detected
- Stop condition detect
- Arbitration lost
- The TWSI has transmitted a STOP signal when configured as a master
- Transaction is done
- Receive FIFO threshold reached
- Transmit FIFO threshold reached
- Receive FIFO is full
- Receive FIFO overrun happened
- Receive FIFO underrun happened
- Transmit FIFO overrun happened*/
//====================================================================

#define  I2C2_TWSI_ISR_RESERVED1_MASK 0xfff00000
#define  I2C2_TWSI_ISR_RESERVED1_SHIFT 20
#define  I2C2_TWSI_ISR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ISR_RESERVED1_MASK) >> I2C2_TWSI_ISR_RESERVED1_SHIFT)
#define  I2C2_TWSI_ISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ISR_RESERVED1_MASK) | (((uint32_t)val) << I2C2_TWSI_ISR_RESERVED1_SHIFT))

#define  I2C2_TWSI_ISR_TXOV_MASK 0x80000
#define  I2C2_TWSI_ISR_TXOV_SHIFT 19
#define  I2C2_TWSI_ISR_TXOV_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ISR_TXOV_MASK) >> I2C2_TWSI_ISR_TXOV_SHIFT)
#define  I2C2_TWSI_ISR_TXOV_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ISR_TXOV_MASK) | (((uint32_t)val) << I2C2_TWSI_ISR_TXOV_SHIFT))

#define  I2C2_TWSI_ISR_RXUN_MASK 0x40000
#define  I2C2_TWSI_ISR_RXUN_SHIFT 18
#define  I2C2_TWSI_ISR_RXUN_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ISR_RXUN_MASK) >> I2C2_TWSI_ISR_RXUN_SHIFT)
#define  I2C2_TWSI_ISR_RXUN_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ISR_RXUN_MASK) | (((uint32_t)val) << I2C2_TWSI_ISR_RXUN_SHIFT))

#define  I2C2_TWSI_ISR_RXOV_MASK 0x20000
#define  I2C2_TWSI_ISR_RXOV_SHIFT 17
#define  I2C2_TWSI_ISR_RXOV_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ISR_RXOV_MASK) >> I2C2_TWSI_ISR_RXOV_SHIFT)
#define  I2C2_TWSI_ISR_RXOV_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ISR_RXOV_MASK) | (((uint32_t)val) << I2C2_TWSI_ISR_RXOV_SHIFT))

#define  I2C2_TWSI_ISR_RXF_MASK 0x10000
#define  I2C2_TWSI_ISR_RXF_SHIFT 16
#define  I2C2_TWSI_ISR_RXF_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ISR_RXF_MASK) >> I2C2_TWSI_ISR_RXF_SHIFT)
#define  I2C2_TWSI_ISR_RXF_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ISR_RXF_MASK) | (((uint32_t)val) << I2C2_TWSI_ISR_RXF_SHIFT))

#define  I2C2_TWSI_ISR_TXSR_MASK 0x8000
#define  I2C2_TWSI_ISR_TXSR_SHIFT 15
#define  I2C2_TWSI_ISR_TXSR_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ISR_TXSR_MASK) >> I2C2_TWSI_ISR_TXSR_SHIFT)
#define  I2C2_TWSI_ISR_TXSR_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ISR_TXSR_MASK) | (((uint32_t)val) << I2C2_TWSI_ISR_TXSR_SHIFT))

#define  I2C2_TWSI_ISR_RXSR_MASK 0x4000
#define  I2C2_TWSI_ISR_RXSR_SHIFT 14
#define  I2C2_TWSI_ISR_RXSR_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ISR_RXSR_MASK) >> I2C2_TWSI_ISR_RXSR_SHIFT)
#define  I2C2_TWSI_ISR_RXSR_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ISR_RXSR_MASK) | (((uint32_t)val) << I2C2_TWSI_ISR_RXSR_SHIFT))

#define  I2C2_TWSI_ISR_TXDONE_MASK 0x2000
#define  I2C2_TWSI_ISR_TXDONE_SHIFT 13
#define  I2C2_TWSI_ISR_TXDONE_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ISR_TXDONE_MASK) >> I2C2_TWSI_ISR_TXDONE_SHIFT)
#define  I2C2_TWSI_ISR_TXDONE_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ISR_TXDONE_MASK) | (((uint32_t)val) << I2C2_TWSI_ISR_TXDONE_SHIFT))

#define  I2C2_TWSI_ISR_MSD_MASK 0x1000
#define  I2C2_TWSI_ISR_MSD_SHIFT 12
#define  I2C2_TWSI_ISR_MSD_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ISR_MSD_MASK) >> I2C2_TWSI_ISR_MSD_SHIFT)
#define  I2C2_TWSI_ISR_MSD_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ISR_MSD_MASK) | (((uint32_t)val) << I2C2_TWSI_ISR_MSD_SHIFT))

#define  I2C2_TWSI_ISR_EBB_MASK 0x800
#define  I2C2_TWSI_ISR_EBB_SHIFT 11
#define  I2C2_TWSI_ISR_EBB_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ISR_EBB_MASK) >> I2C2_TWSI_ISR_EBB_SHIFT)
#define  I2C2_TWSI_ISR_EBB_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ISR_EBB_MASK) | (((uint32_t)val) << I2C2_TWSI_ISR_EBB_SHIFT))

#define  I2C2_TWSI_ISR_BED_MASK 0x400
#define  I2C2_TWSI_ISR_BED_SHIFT 10
#define  I2C2_TWSI_ISR_BED_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ISR_BED_MASK) >> I2C2_TWSI_ISR_BED_SHIFT)
#define  I2C2_TWSI_ISR_BED_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ISR_BED_MASK) | (((uint32_t)val) << I2C2_TWSI_ISR_BED_SHIFT))

#define  I2C2_TWSI_ISR_SAD_MASK 0x200
#define  I2C2_TWSI_ISR_SAD_SHIFT 9
#define  I2C2_TWSI_ISR_SAD_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ISR_SAD_MASK) >> I2C2_TWSI_ISR_SAD_SHIFT)
#define  I2C2_TWSI_ISR_SAD_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ISR_SAD_MASK) | (((uint32_t)val) << I2C2_TWSI_ISR_SAD_SHIFT))

#define  I2C2_TWSI_ISR_GCAD_MASK 0x100
#define  I2C2_TWSI_ISR_GCAD_SHIFT 8
#define  I2C2_TWSI_ISR_GCAD_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ISR_GCAD_MASK) >> I2C2_TWSI_ISR_GCAD_SHIFT)
#define  I2C2_TWSI_ISR_GCAD_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ISR_GCAD_MASK) | (((uint32_t)val) << I2C2_TWSI_ISR_GCAD_SHIFT))

#define  I2C2_TWSI_ISR_IRF_MASK 0x80
#define  I2C2_TWSI_ISR_IRF_SHIFT 7
#define  I2C2_TWSI_ISR_IRF_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ISR_IRF_MASK) >> I2C2_TWSI_ISR_IRF_SHIFT)
#define  I2C2_TWSI_ISR_IRF_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ISR_IRF_MASK) | (((uint32_t)val) << I2C2_TWSI_ISR_IRF_SHIFT))

#define  I2C2_TWSI_ISR_ITE_MASK 0x40
#define  I2C2_TWSI_ISR_ITE_SHIFT 6
#define  I2C2_TWSI_ISR_ITE_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ISR_ITE_MASK) >> I2C2_TWSI_ISR_ITE_SHIFT)
#define  I2C2_TWSI_ISR_ITE_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ISR_ITE_MASK) | (((uint32_t)val) << I2C2_TWSI_ISR_ITE_SHIFT))

#define  I2C2_TWSI_ISR_ALD_MASK 0x20
#define  I2C2_TWSI_ISR_ALD_SHIFT 5
#define  I2C2_TWSI_ISR_ALD_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ISR_ALD_MASK) >> I2C2_TWSI_ISR_ALD_SHIFT)
#define  I2C2_TWSI_ISR_ALD_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ISR_ALD_MASK) | (((uint32_t)val) << I2C2_TWSI_ISR_ALD_SHIFT))

#define  I2C2_TWSI_ISR_SSD_MASK 0x10
#define  I2C2_TWSI_ISR_SSD_SHIFT 4
#define  I2C2_TWSI_ISR_SSD_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ISR_SSD_MASK) >> I2C2_TWSI_ISR_SSD_SHIFT)
#define  I2C2_TWSI_ISR_SSD_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ISR_SSD_MASK) | (((uint32_t)val) << I2C2_TWSI_ISR_SSD_SHIFT))

#define  I2C2_TWSI_ISR_IBB_MASK 0x8
#define  I2C2_TWSI_ISR_IBB_SHIFT 3
#define  I2C2_TWSI_ISR_IBB_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ISR_IBB_MASK) >> I2C2_TWSI_ISR_IBB_SHIFT)
#define  I2C2_TWSI_ISR_IBB_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ISR_IBB_MASK) | (((uint32_t)val) << I2C2_TWSI_ISR_IBB_SHIFT))

#define  I2C2_TWSI_ISR_UB_MASK 0x4
#define  I2C2_TWSI_ISR_UB_SHIFT 2
#define  I2C2_TWSI_ISR_UB_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ISR_UB_MASK) >> I2C2_TWSI_ISR_UB_SHIFT)
#define  I2C2_TWSI_ISR_UB_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ISR_UB_MASK) | (((uint32_t)val) << I2C2_TWSI_ISR_UB_SHIFT))

#define  I2C2_TWSI_ISR_ACKNAK_MASK 0x2
#define  I2C2_TWSI_ISR_ACKNAK_SHIFT 1
#define  I2C2_TWSI_ISR_ACKNAK_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ISR_ACKNAK_MASK) >> I2C2_TWSI_ISR_ACKNAK_SHIFT)
#define  I2C2_TWSI_ISR_ACKNAK_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ISR_ACKNAK_MASK) | (((uint32_t)val) << I2C2_TWSI_ISR_ACKNAK_SHIFT))

#define  I2C2_TWSI_ISR_RWM_MASK 0x1
#define  I2C2_TWSI_ISR_RWM_SHIFT 0
#define  I2C2_TWSI_ISR_RWM_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ISR_RWM_MASK) >> I2C2_TWSI_ISR_RWM_SHIFT)
#define  I2C2_TWSI_ISR_RWM_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ISR_RWM_MASK) | (((uint32_t)val) << I2C2_TWSI_ISR_RWM_SHIFT))

//====================================================================
//Register: TWSI Slave Address Register (TWSI_ISAR)
/** \brief The ISAR defines the TWSI' s seven-bit slave address. In slave-receive mode, the
PXA2128 Application Processor responds when the seven-bit address matches the
value in this register. The PXA2128 Application Processor writes this register
before it enables TWSI operations. The ISAR is fully programmable (no address is
assigned to the TWSI) so it can be set to a value other than those of hard-wired
TWSI slave peripherals in the system.
These are read/write registers. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  I2C2_TWSI_ISAR_RESERVED1_MASK 0xffffff80
#define  I2C2_TWSI_ISAR_RESERVED1_SHIFT 7
#define  I2C2_TWSI_ISAR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ISAR_RESERVED1_MASK) >> I2C2_TWSI_ISAR_RESERVED1_SHIFT)
#define  I2C2_TWSI_ISAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ISAR_RESERVED1_MASK) | (((uint32_t)val) << I2C2_TWSI_ISAR_RESERVED1_SHIFT))

#define  I2C2_TWSI_ISAR_SLAVE_ADDRESS_MASK 0x7f
#define  I2C2_TWSI_ISAR_SLAVE_ADDRESS_SHIFT 0
#define  I2C2_TWSI_ISAR_SLAVE_ADDRESS_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ISAR_SLAVE_ADDRESS_MASK) >> I2C2_TWSI_ISAR_SLAVE_ADDRESS_SHIFT)
#define  I2C2_TWSI_ISAR_SLAVE_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ISAR_SLAVE_ADDRESS_MASK) | (((uint32_t)val) << I2C2_TWSI_ISAR_SLAVE_ADDRESS_SHIFT))

//====================================================================
//Register: TWSI Load Count Register (TWSI_ILCR)
/** \brief The TWSI must generate the SCL in master mode and the Load Count Monitor
register (ILCR) allows minor adjustments to this clock. The reset value of this
register are determined based on a 32.8 MHz TWSI input clock which allows the
maximum frequency to be derived for Fast (up to 400 Kbps) and Normal mode (up
to 100 Kbps). However, due to frequency restrictions on the TWSI input clock,
the default values of ILCR only generate an SCL than can support up to 1.8 Mbps
for HS mode.
If the alternate 66 MHz TWSI input clock is selected (via writing CCU,
FUNC_CLK_SEL to 'b11 while the TWSI is not enabled), the recommended value of
ILCR to achieve the necessary Fast, Normal and High Speed SCL frequencies
is 32'h 082C_BB56. This register must also be written while the TWSI is not
enabled.
Increasing the load value decreases the SCL frequency, while decreasing the load
raises the frequency. The amount of decrease or increase is equal to one TWSI
clock period for each value.
Note: Reset values also allow the highest possible SCL frequency that still meet
the minimum requirements listed in the TWSI Bus Specification Version 2.1. This
register should be written prior to enabling the TWSI and should not be changed
during bus activity. Writing all zeros to any of the 4 individual Load Values
causes the TWSI to not generate an SCL for that particular mode when the TWSI is
configured as a master. Extreme caution must be exercised when writing this
register.*/
//====================================================================

#define  I2C2_TWSI_ILCR_HLVH_MASK 0xf8000000
#define  I2C2_TWSI_ILCR_HLVH_SHIFT 27
#define  I2C2_TWSI_ILCR_HLVH_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ILCR_HLVH_MASK) >> I2C2_TWSI_ILCR_HLVH_SHIFT)
#define  I2C2_TWSI_ILCR_HLVH_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ILCR_HLVH_MASK) | (((uint32_t)val) << I2C2_TWSI_ILCR_HLVH_SHIFT))

#define  I2C2_TWSI_ILCR_HLVL_MASK 0x7fc0000
#define  I2C2_TWSI_ILCR_HLVL_SHIFT 18
#define  I2C2_TWSI_ILCR_HLVL_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ILCR_HLVL_MASK) >> I2C2_TWSI_ILCR_HLVL_SHIFT)
#define  I2C2_TWSI_ILCR_HLVL_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ILCR_HLVL_MASK) | (((uint32_t)val) << I2C2_TWSI_ILCR_HLVL_SHIFT))

#define  I2C2_TWSI_ILCR_FLV_MASK 0x3fe00
#define  I2C2_TWSI_ILCR_FLV_SHIFT 9
#define  I2C2_TWSI_ILCR_FLV_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ILCR_FLV_MASK) >> I2C2_TWSI_ILCR_FLV_SHIFT)
#define  I2C2_TWSI_ILCR_FLV_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ILCR_FLV_MASK) | (((uint32_t)val) << I2C2_TWSI_ILCR_FLV_SHIFT))

#define  I2C2_TWSI_ILCR_SLV_MASK 0x1ff
#define  I2C2_TWSI_ILCR_SLV_SHIFT 0
#define  I2C2_TWSI_ILCR_SLV_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_ILCR_SLV_MASK) >> I2C2_TWSI_ILCR_SLV_SHIFT)
#define  I2C2_TWSI_ILCR_SLV_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_ILCR_SLV_MASK) | (((uint32_t)val) << I2C2_TWSI_ILCR_SLV_SHIFT))

//====================================================================
//Register: TWSI Wait Count Register (TWSI_IWCR)
/** \brief The TWSI Wait Count register controls the setup and hold times during standard,
fast, or high speed. This register together with the ILCR register control the
setup and hold times for all modes.*/
//====================================================================

#define  I2C2_TWSI_IWCR_RESERVED1_MASK 0xffff8000
#define  I2C2_TWSI_IWCR_RESERVED1_SHIFT 15
#define  I2C2_TWSI_IWCR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_IWCR_RESERVED1_MASK) >> I2C2_TWSI_IWCR_RESERVED1_SHIFT)
#define  I2C2_TWSI_IWCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_IWCR_RESERVED1_MASK) | (((uint32_t)val) << I2C2_TWSI_IWCR_RESERVED1_SHIFT))

#define  I2C2_TWSI_IWCR_HS_COUNT2_MASK 0x7c00
#define  I2C2_TWSI_IWCR_HS_COUNT2_SHIFT 10
#define  I2C2_TWSI_IWCR_HS_COUNT2_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_IWCR_HS_COUNT2_MASK) >> I2C2_TWSI_IWCR_HS_COUNT2_SHIFT)
#define  I2C2_TWSI_IWCR_HS_COUNT2_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_IWCR_HS_COUNT2_MASK) | (((uint32_t)val) << I2C2_TWSI_IWCR_HS_COUNT2_SHIFT))

#define  I2C2_TWSI_IWCR_HS_COUNT1_MASK 0x3e0
#define  I2C2_TWSI_IWCR_HS_COUNT1_SHIFT 5
#define  I2C2_TWSI_IWCR_HS_COUNT1_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_IWCR_HS_COUNT1_MASK) >> I2C2_TWSI_IWCR_HS_COUNT1_SHIFT)
#define  I2C2_TWSI_IWCR_HS_COUNT1_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_IWCR_HS_COUNT1_MASK) | (((uint32_t)val) << I2C2_TWSI_IWCR_HS_COUNT1_SHIFT))

#define  I2C2_TWSI_IWCR_COUNT_MASK 0x1f
#define  I2C2_TWSI_IWCR_COUNT_SHIFT 0
#define  I2C2_TWSI_IWCR_COUNT_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_IWCR_COUNT_MASK) >> I2C2_TWSI_IWCR_COUNT_SHIFT)
#define  I2C2_TWSI_IWCR_COUNT_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_IWCR_COUNT_MASK) | (((uint32_t)val) << I2C2_TWSI_IWCR_COUNT_SHIFT))

//====================================================================
//Register: TWSI Write FIFO Register (TWSI_WFIFO)
/** \brief The TWSI Write FIFO has 16 entries and each entry is 12-bit wide (4-bit control
+ 8-bit data). This FIFO can be filled up in PIO or DMA mode. Whenever this FIFO
threshold is reached, an interrupt or a dma request is generated.*/
//====================================================================

#define  I2C2_TWSI_WFIFO_RESERVED1_MASK 0xfffff000
#define  I2C2_TWSI_WFIFO_RESERVED1_SHIFT 12
#define  I2C2_TWSI_WFIFO_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_WFIFO_RESERVED1_MASK) >> I2C2_TWSI_WFIFO_RESERVED1_SHIFT)
#define  I2C2_TWSI_WFIFO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_WFIFO_RESERVED1_MASK) | (((uint32_t)val) << I2C2_TWSI_WFIFO_RESERVED1_SHIFT))

#define  I2C2_TWSI_WFIFO_CONTROL_MASK 0xf00
#define  I2C2_TWSI_WFIFO_CONTROL_SHIFT 8
#define  I2C2_TWSI_WFIFO_CONTROL_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_WFIFO_CONTROL_MASK) >> I2C2_TWSI_WFIFO_CONTROL_SHIFT)
#define  I2C2_TWSI_WFIFO_CONTROL_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_WFIFO_CONTROL_MASK) | (((uint32_t)val) << I2C2_TWSI_WFIFO_CONTROL_SHIFT))

#define  I2C2_TWSI_WFIFO_DATA_MASK 0xff
#define  I2C2_TWSI_WFIFO_DATA_SHIFT 0
#define  I2C2_TWSI_WFIFO_DATA_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_WFIFO_DATA_MASK) >> I2C2_TWSI_WFIFO_DATA_SHIFT)
#define  I2C2_TWSI_WFIFO_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_WFIFO_DATA_MASK) | (((uint32_t)val) << I2C2_TWSI_WFIFO_DATA_SHIFT))

//====================================================================
//Register: TWSI Write FIFO Write Pointer Register (TWSI_WFIFO_WPTR)
/** \brief The TWSI Write FIFO Pointer has the TX FIFO write entry location information.
This is a read/write register. Software can write 0 to it when it wishes to
flush the FIFO after interrupts like Bus error, Arbitration loss, etc.*/
//====================================================================

#define  I2C2_TWSI_WFIFO_WPTR_RESERVED1_MASK 0xffffffe0
#define  I2C2_TWSI_WFIFO_WPTR_RESERVED1_SHIFT 5
#define  I2C2_TWSI_WFIFO_WPTR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_WFIFO_WPTR_RESERVED1_MASK) >> I2C2_TWSI_WFIFO_WPTR_RESERVED1_SHIFT)
#define  I2C2_TWSI_WFIFO_WPTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_WFIFO_WPTR_RESERVED1_MASK) | (((uint32_t)val) << I2C2_TWSI_WFIFO_WPTR_RESERVED1_SHIFT))

#define  I2C2_TWSI_WFIFO_WPTR_DATA_MASK 0x1f
#define  I2C2_TWSI_WFIFO_WPTR_DATA_SHIFT 0
#define  I2C2_TWSI_WFIFO_WPTR_DATA_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_WFIFO_WPTR_DATA_MASK) >> I2C2_TWSI_WFIFO_WPTR_DATA_SHIFT)
#define  I2C2_TWSI_WFIFO_WPTR_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_WFIFO_WPTR_DATA_MASK) | (((uint32_t)val) << I2C2_TWSI_WFIFO_WPTR_DATA_SHIFT))

//====================================================================
//Register: TWSI Write FIFO Read Pointer Register (TWSI_WFIFO_RPTR)
/** \brief The TWSI Write FIFO Read Pointer has the TX FIFO read entry location
information. This is a read/write register. Software can write 0 to it when it
wishes to flush the FIFO after an interrupt.*/
//====================================================================

#define  I2C2_TWSI_WFIFO_RPTR_RESERVED1_MASK 0xffffffe0
#define  I2C2_TWSI_WFIFO_RPTR_RESERVED1_SHIFT 5
#define  I2C2_TWSI_WFIFO_RPTR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_WFIFO_RPTR_RESERVED1_MASK) >> I2C2_TWSI_WFIFO_RPTR_RESERVED1_SHIFT)
#define  I2C2_TWSI_WFIFO_RPTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_WFIFO_RPTR_RESERVED1_MASK) | (((uint32_t)val) << I2C2_TWSI_WFIFO_RPTR_RESERVED1_SHIFT))

#define  I2C2_TWSI_WFIFO_RPTR_DATA_MASK 0x1f
#define  I2C2_TWSI_WFIFO_RPTR_DATA_SHIFT 0
#define  I2C2_TWSI_WFIFO_RPTR_DATA_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_WFIFO_RPTR_DATA_MASK) >> I2C2_TWSI_WFIFO_RPTR_DATA_SHIFT)
#define  I2C2_TWSI_WFIFO_RPTR_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_WFIFO_RPTR_DATA_MASK) | (((uint32_t)val) << I2C2_TWSI_WFIFO_RPTR_DATA_SHIFT))

//====================================================================
//Register: TWSI Read FIFO Register (TWSI_RFIFO)
/** \brief The TWSI Read FIFO has 16 entries and each entry is 8-bit wide (8-bit data).
This FIFO can be emptied in PIO or DMA mode. Whenever this FIFO is half full, an
interrupt or a dma request is generated.*/
//====================================================================

#define  I2C2_TWSI_RFIFO_RESERVED1_MASK 0xffffff00
#define  I2C2_TWSI_RFIFO_RESERVED1_SHIFT 8
#define  I2C2_TWSI_RFIFO_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_RFIFO_RESERVED1_MASK) >> I2C2_TWSI_RFIFO_RESERVED1_SHIFT)
#define  I2C2_TWSI_RFIFO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_RFIFO_RESERVED1_MASK) | (((uint32_t)val) << I2C2_TWSI_RFIFO_RESERVED1_SHIFT))

#define  I2C2_TWSI_RFIFO_DATA_MASK 0xff
#define  I2C2_TWSI_RFIFO_DATA_SHIFT 0
#define  I2C2_TWSI_RFIFO_DATA_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_RFIFO_DATA_MASK) >> I2C2_TWSI_RFIFO_DATA_SHIFT)
#define  I2C2_TWSI_RFIFO_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_RFIFO_DATA_MASK) | (((uint32_t)val) << I2C2_TWSI_RFIFO_DATA_SHIFT))

//====================================================================
//Register: TWSI Read FIFO Write Pointer Register (TWSI_RFIFO_WPTR)
/** \brief The TWSI Read FIFO Write Pointer has the RX FIFO write entry location
information. This is a read/write register. Software can write 0 to it when it
wishes to flush the FIFO after interrupts like Bus error, Arbitration loss, etc.*/
//====================================================================

#define  I2C2_TWSI_RFIFO_WPTR_RESERVED1_MASK 0xffffffe0
#define  I2C2_TWSI_RFIFO_WPTR_RESERVED1_SHIFT 5
#define  I2C2_TWSI_RFIFO_WPTR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_RFIFO_WPTR_RESERVED1_MASK) >> I2C2_TWSI_RFIFO_WPTR_RESERVED1_SHIFT)
#define  I2C2_TWSI_RFIFO_WPTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_RFIFO_WPTR_RESERVED1_MASK) | (((uint32_t)val) << I2C2_TWSI_RFIFO_WPTR_RESERVED1_SHIFT))

#define  I2C2_TWSI_RFIFO_WPTR_DATA_MASK 0x1f
#define  I2C2_TWSI_RFIFO_WPTR_DATA_SHIFT 0
#define  I2C2_TWSI_RFIFO_WPTR_DATA_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_RFIFO_WPTR_DATA_MASK) >> I2C2_TWSI_RFIFO_WPTR_DATA_SHIFT)
#define  I2C2_TWSI_RFIFO_WPTR_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_RFIFO_WPTR_DATA_MASK) | (((uint32_t)val) << I2C2_TWSI_RFIFO_WPTR_DATA_SHIFT))

//====================================================================
//Register: TWSI Read FIFO Read Pointer Register (TWSI_RFIFO_RPTR)
/** \brief The TWSI Read FIFO Read Pointer has the RX FIFO read entry location information.
This is a read/write register. Software can write 0 to it when it wishes to
flush the FIFO after an interrupt.*/
//====================================================================

#define  I2C2_TWSI_RFIFO_RPTR_RESERVED1_MASK 0xffffffe0
#define  I2C2_TWSI_RFIFO_RPTR_RESERVED1_SHIFT 5
#define  I2C2_TWSI_RFIFO_RPTR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_RFIFO_RPTR_RESERVED1_MASK) >> I2C2_TWSI_RFIFO_RPTR_RESERVED1_SHIFT)
#define  I2C2_TWSI_RFIFO_RPTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_RFIFO_RPTR_RESERVED1_MASK) | (((uint32_t)val) << I2C2_TWSI_RFIFO_RPTR_RESERVED1_SHIFT))

#define  I2C2_TWSI_RFIFO_RPTR_DATA_MASK 0x1f
#define  I2C2_TWSI_RFIFO_RPTR_DATA_SHIFT 0
#define  I2C2_TWSI_RFIFO_RPTR_DATA_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_RFIFO_RPTR_DATA_MASK) >> I2C2_TWSI_RFIFO_RPTR_DATA_SHIFT)
#define  I2C2_TWSI_RFIFO_RPTR_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_RFIFO_RPTR_DATA_MASK) | (((uint32_t)val) << I2C2_TWSI_RFIFO_RPTR_DATA_SHIFT))

//====================================================================
//Register: TWSI FIFO Threshold Register (TWSI_FIFO_TSHLD)
/** \brief The FIFO threshold register had the threshold values for TXFIFO and RXFIFO. It
is a read/write register. The default values are 0(empty) for TXFIFO and 8(half
full) for RXFIFO.*/
//====================================================================

#define  I2C2_TWSI_FIFO_TSHLD_RESERVED1_MASK 0xffe00000
#define  I2C2_TWSI_FIFO_TSHLD_RESERVED1_SHIFT 21
#define  I2C2_TWSI_FIFO_TSHLD_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_FIFO_TSHLD_RESERVED1_MASK) >> I2C2_TWSI_FIFO_TSHLD_RESERVED1_SHIFT)
#define  I2C2_TWSI_FIFO_TSHLD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_FIFO_TSHLD_RESERVED1_MASK) | (((uint32_t)val) << I2C2_TWSI_FIFO_TSHLD_RESERVED1_SHIFT))

#define  I2C2_TWSI_FIFO_TSHLD_RX_MASK 0x1f0000
#define  I2C2_TWSI_FIFO_TSHLD_RX_SHIFT 16
#define  I2C2_TWSI_FIFO_TSHLD_RX_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_FIFO_TSHLD_RX_MASK) >> I2C2_TWSI_FIFO_TSHLD_RX_SHIFT)
#define  I2C2_TWSI_FIFO_TSHLD_RX_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_FIFO_TSHLD_RX_MASK) | (((uint32_t)val) << I2C2_TWSI_FIFO_TSHLD_RX_SHIFT))

#define  I2C2_TWSI_FIFO_TSHLD_RESERVED2_MASK 0xffe0
#define  I2C2_TWSI_FIFO_TSHLD_RESERVED2_SHIFT 5
#define  I2C2_TWSI_FIFO_TSHLD_RESERVED2_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_FIFO_TSHLD_RESERVED2_MASK) >> I2C2_TWSI_FIFO_TSHLD_RESERVED2_SHIFT)
#define  I2C2_TWSI_FIFO_TSHLD_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_FIFO_TSHLD_RESERVED2_MASK) | (((uint32_t)val) << I2C2_TWSI_FIFO_TSHLD_RESERVED2_SHIFT))

#define  I2C2_TWSI_FIFO_TSHLD_TX_MASK 0x1f
#define  I2C2_TWSI_FIFO_TSHLD_TX_SHIFT 0
#define  I2C2_TWSI_FIFO_TSHLD_TX_MASK_SHIFT(reg) (((reg) & I2C2_TWSI_FIFO_TSHLD_TX_MASK) >> I2C2_TWSI_FIFO_TSHLD_TX_SHIFT)
#define  I2C2_TWSI_FIFO_TSHLD_TX_REPLACE_VAL(reg,val) (((reg) & ~I2C2_TWSI_FIFO_TSHLD_TX_MASK) | (((uint32_t)val) << I2C2_TWSI_FIFO_TSHLD_TX_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  I2C2_REV0_MAJ_MASK 0xffff0000
#define  I2C2_REV0_MAJ_SHIFT 16
#define  I2C2_REV0_MAJ_MASK_SHIFT(reg) (((reg) & I2C2_REV0_MAJ_MASK) >> I2C2_REV0_MAJ_SHIFT)
#define  I2C2_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~I2C2_REV0_MAJ_MASK) | (((uint32_t)val) << I2C2_REV0_MAJ_SHIFT))

#define  I2C2_REV0_MID_MASK 0xffff
#define  I2C2_REV0_MID_SHIFT 0
#define  I2C2_REV0_MID_MASK_SHIFT(reg) (((reg) & I2C2_REV0_MID_MASK) >> I2C2_REV0_MID_SHIFT)
#define  I2C2_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~I2C2_REV0_MID_MASK) | (((uint32_t)val) << I2C2_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  I2C2_REV1_RESERVED1_MASK 0xffff0000
#define  I2C2_REV1_RESERVED1_SHIFT 16
#define  I2C2_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C2_REV1_RESERVED1_MASK) >> I2C2_REV1_RESERVED1_SHIFT)
#define  I2C2_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C2_REV1_RESERVED1_MASK) | (((uint32_t)val) << I2C2_REV1_RESERVED1_SHIFT))

#define  I2C2_REV1_CFG_MASK 0xffff
#define  I2C2_REV1_CFG_SHIFT 0
#define  I2C2_REV1_CFG_MASK_SHIFT(reg) (((reg) & I2C2_REV1_CFG_MASK) >> I2C2_REV1_CFG_SHIFT)
#define  I2C2_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~I2C2_REV1_CFG_MASK) | (((uint32_t)val) << I2C2_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: I2C3 Registers (I2C3)
//
//====================================================================

//====================================================================
//Register: TWSI Bus Monitor Register (TWSI_IBMR)
/** \brief The TWSI Bus Monitor register (IBMR) tracks the status of the SCL and SDA pins.
The values of these pins are recorded in this read-only IBMR, so software can
determine when the TWSI bus is hung and the TWSI unit must be reset.
This a read-only register. Ignore reads from reserved bits.*/
//====================================================================

#define  I2C3_TWSI_IBMR_RESERVED1_MASK 0xfffffffc
#define  I2C3_TWSI_IBMR_RESERVED1_SHIFT 2
#define  I2C3_TWSI_IBMR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_IBMR_RESERVED1_MASK) >> I2C3_TWSI_IBMR_RESERVED1_SHIFT)
#define  I2C3_TWSI_IBMR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_IBMR_RESERVED1_MASK) | (((uint32_t)val) << I2C3_TWSI_IBMR_RESERVED1_SHIFT))

#define  I2C3_TWSI_IBMR_SCL_MASK 0x2
#define  I2C3_TWSI_IBMR_SCL_SHIFT 1
#define  I2C3_TWSI_IBMR_SCL_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_IBMR_SCL_MASK) >> I2C3_TWSI_IBMR_SCL_SHIFT)
#define  I2C3_TWSI_IBMR_SCL_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_IBMR_SCL_MASK) | (((uint32_t)val) << I2C3_TWSI_IBMR_SCL_SHIFT))

#define  I2C3_TWSI_IBMR_SDA_MASK 0x1
#define  I2C3_TWSI_IBMR_SDA_SHIFT 0
#define  I2C3_TWSI_IBMR_SDA_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_IBMR_SDA_MASK) >> I2C3_TWSI_IBMR_SDA_SHIFT)
#define  I2C3_TWSI_IBMR_SDA_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_IBMR_SDA_MASK) | (((uint32_t)val) << I2C3_TWSI_IBMR_SDA_SHIFT))

//====================================================================
//Register: TWSI Data Buffer Register (TWSI_IDBR)
/** \brief The PXA2128 Application Processor use the TWSI Data Buffer register to transmit
and receive data from the TWSI bus. The IDBR is accessed by the program I/O on
one side and by the TWSI Shift register on the other. The IDBR receives data
coming into the TWSI unit after a full byte is received and acknowledged. The
PXA2128 Application Processor core writes data going out of the TWSI to the IDBR
and sends it to the serial bus.
When the TWSI is in transmit mode (master or slave), the PXA2128 Application
Processor writes data to the IDBR over the internal bus. The PXA2128 Application
Processor write data to the IDBR when a master transaction is initiated or when
the IDBR transmit-empty interrupt is signalled. Data moves from the IDBR to the
Shift register when the transfer byte bit is set. The IDBR transmit-empty
interrupt is signalled (if enabled) when a byte is transferred on the TWSI bus
and the acknowledge cycle is complete. If the IDBR is not written by the PXA2128
Application Processor, and a Stop condition is not in place before the TWSI bus
is ready to transfer the next byte packet, the TWSI unit inserts wait states
until the PXA2128 Application Processor writes the IDBR and sets the transfer
byte bit.
When the TWSI is in receive mode (master or slave), the PXA2128 Application
Processor reads IDBR data over the internal bus. The PXA2128 Application
Processor reads data from the IDBR when the IDBR receive-full interrupt is
signalled. The data moves from the Shift register to the IDBR when the
acknowledge cycle is complete. The TWSI inserts wait states until the IDBR is
read. See Section 12.4.6 for more information on the acknowledge pulse in
receive mode. After the software reads the IDBR, ICR[ACKNAK], and ICR[ACKNAK]
are written by the software, allowing the next byte transfer to proceed to the
TWSI bus.
These are read/write registers. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  I2C3_TWSI_IDBR_RESERVED1_MASK 0xffffff00
#define  I2C3_TWSI_IDBR_RESERVED1_SHIFT 8
#define  I2C3_TWSI_IDBR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_IDBR_RESERVED1_MASK) >> I2C3_TWSI_IDBR_RESERVED1_SHIFT)
#define  I2C3_TWSI_IDBR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_IDBR_RESERVED1_MASK) | (((uint32_t)val) << I2C3_TWSI_IDBR_RESERVED1_SHIFT))

#define  I2C3_TWSI_IDBR_DATA_BUFFER_MASK 0xff
#define  I2C3_TWSI_IDBR_DATA_BUFFER_SHIFT 0
#define  I2C3_TWSI_IDBR_DATA_BUFFER_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_IDBR_DATA_BUFFER_MASK) >> I2C3_TWSI_IDBR_DATA_BUFFER_SHIFT)
#define  I2C3_TWSI_IDBR_DATA_BUFFER_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_IDBR_DATA_BUFFER_MASK) | (((uint32_t)val) << I2C3_TWSI_IDBR_DATA_BUFFER_SHIFT))

//====================================================================
//Register: TWSI Control Register (TWSI_ICR)
/** \brief The PXA2128 Application Processor uses the bits in the TWSI Control register
(ICR) to control the TWSI unit.
These are read/write registers. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  I2C3_TWSI_ICR_RESERVED1_MASK 0x80000000
#define  I2C3_TWSI_ICR_RESERVED1_SHIFT 31
#define  I2C3_TWSI_ICR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_RESERVED1_MASK) >> I2C3_TWSI_ICR_RESERVED1_SHIFT)
#define  I2C3_TWSI_ICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_RESERVED1_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_RESERVED1_SHIFT))

#define  I2C3_TWSI_ICR_SDA_GFE_MASK 0x40000000
#define  I2C3_TWSI_ICR_SDA_GFE_SHIFT 30
#define  I2C3_TWSI_ICR_SDA_GFE_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_SDA_GFE_MASK) >> I2C3_TWSI_ICR_SDA_GFE_SHIFT)
#define  I2C3_TWSI_ICR_SDA_GFE_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_SDA_GFE_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_SDA_GFE_SHIFT))

#define  I2C3_TWSI_ICR_TXOV_IE_MASK 0x20000000
#define  I2C3_TWSI_ICR_TXOV_IE_SHIFT 29
#define  I2C3_TWSI_ICR_TXOV_IE_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_TXOV_IE_MASK) >> I2C3_TWSI_ICR_TXOV_IE_SHIFT)
#define  I2C3_TWSI_ICR_TXOV_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_TXOV_IE_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_TXOV_IE_SHIFT))

#define  I2C3_TWSI_ICR_RXUN_IE_MASK 0x10000000
#define  I2C3_TWSI_ICR_RXUN_IE_SHIFT 28
#define  I2C3_TWSI_ICR_RXUN_IE_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_RXUN_IE_MASK) >> I2C3_TWSI_ICR_RXUN_IE_SHIFT)
#define  I2C3_TWSI_ICR_RXUN_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_RXUN_IE_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_RXUN_IE_SHIFT))

#define  I2C3_TWSI_ICR_DMA_EN_MASK 0x8000000
#define  I2C3_TWSI_ICR_DMA_EN_SHIFT 27
#define  I2C3_TWSI_ICR_DMA_EN_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_DMA_EN_MASK) >> I2C3_TWSI_ICR_DMA_EN_SHIFT)
#define  I2C3_TWSI_ICR_DMA_EN_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_DMA_EN_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_DMA_EN_SHIFT))

#define  I2C3_TWSI_ICR_RXOV_IE_MASK 0x4000000
#define  I2C3_TWSI_ICR_RXOV_IE_SHIFT 26
#define  I2C3_TWSI_ICR_RXOV_IE_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_RXOV_IE_MASK) >> I2C3_TWSI_ICR_RXOV_IE_SHIFT)
#define  I2C3_TWSI_ICR_RXOV_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_RXOV_IE_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_RXOV_IE_SHIFT))

#define  I2C3_TWSI_ICR_RXF_IE_MASK 0x2000000
#define  I2C3_TWSI_ICR_RXF_IE_SHIFT 25
#define  I2C3_TWSI_ICR_RXF_IE_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_RXF_IE_MASK) >> I2C3_TWSI_ICR_RXF_IE_SHIFT)
#define  I2C3_TWSI_ICR_RXF_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_RXF_IE_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_RXF_IE_SHIFT))

#define  I2C3_TWSI_ICR_TXSR_IE_MASK 0x1000000
#define  I2C3_TWSI_ICR_TXSR_IE_SHIFT 24
#define  I2C3_TWSI_ICR_TXSR_IE_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_TXSR_IE_MASK) >> I2C3_TWSI_ICR_TXSR_IE_SHIFT)
#define  I2C3_TWSI_ICR_TXSR_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_TXSR_IE_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_TXSR_IE_SHIFT))

#define  I2C3_TWSI_ICR_RXSR_IE_MASK 0x800000
#define  I2C3_TWSI_ICR_RXSR_IE_SHIFT 23
#define  I2C3_TWSI_ICR_RXSR_IE_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_RXSR_IE_MASK) >> I2C3_TWSI_ICR_RXSR_IE_SHIFT)
#define  I2C3_TWSI_ICR_RXSR_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_RXSR_IE_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_RXSR_IE_SHIFT))

#define  I2C3_TWSI_ICR_TXDONE_IE_MASK 0x400000
#define  I2C3_TWSI_ICR_TXDONE_IE_SHIFT 22
#define  I2C3_TWSI_ICR_TXDONE_IE_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_TXDONE_IE_MASK) >> I2C3_TWSI_ICR_TXDONE_IE_SHIFT)
#define  I2C3_TWSI_ICR_TXDONE_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_TXDONE_IE_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_TXDONE_IE_SHIFT))

#define  I2C3_TWSI_ICR_TXBEGIN_MASK 0x200000
#define  I2C3_TWSI_ICR_TXBEGIN_SHIFT 21
#define  I2C3_TWSI_ICR_TXBEGIN_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_TXBEGIN_MASK) >> I2C3_TWSI_ICR_TXBEGIN_SHIFT)
#define  I2C3_TWSI_ICR_TXBEGIN_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_TXBEGIN_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_TXBEGIN_SHIFT))

#define  I2C3_TWSI_ICR_FIFOEN_MASK 0x100000
#define  I2C3_TWSI_ICR_FIFOEN_SHIFT 20
#define  I2C3_TWSI_ICR_FIFOEN_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_FIFOEN_MASK) >> I2C3_TWSI_ICR_FIFOEN_SHIFT)
#define  I2C3_TWSI_ICR_FIFOEN_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_FIFOEN_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_FIFOEN_SHIFT))

#define  I2C3_TWSI_ICR_GPIOEN_MASK 0x80000
#define  I2C3_TWSI_ICR_GPIOEN_SHIFT 19
#define  I2C3_TWSI_ICR_GPIOEN_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_GPIOEN_MASK) >> I2C3_TWSI_ICR_GPIOEN_SHIFT)
#define  I2C3_TWSI_ICR_GPIOEN_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_GPIOEN_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_GPIOEN_SHIFT))

#define  I2C3_TWSI_ICR_MSDE_MASK 0x40000
#define  I2C3_TWSI_ICR_MSDE_SHIFT 18
#define  I2C3_TWSI_ICR_MSDE_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_MSDE_MASK) >> I2C3_TWSI_ICR_MSDE_SHIFT)
#define  I2C3_TWSI_ICR_MSDE_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_MSDE_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_MSDE_SHIFT))

#define  I2C3_TWSI_ICR_MSDIE_MASK 0x20000
#define  I2C3_TWSI_ICR_MSDIE_SHIFT 17
#define  I2C3_TWSI_ICR_MSDIE_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_MSDIE_MASK) >> I2C3_TWSI_ICR_MSDIE_SHIFT)
#define  I2C3_TWSI_ICR_MSDIE_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_MSDIE_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_MSDIE_SHIFT))

#define  I2C3_TWSI_ICR_MODE_MASK 0x18000
#define  I2C3_TWSI_ICR_MODE_SHIFT 15
#define  I2C3_TWSI_ICR_MODE_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_MODE_MASK) >> I2C3_TWSI_ICR_MODE_SHIFT)
#define  I2C3_TWSI_ICR_MODE_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_MODE_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_MODE_SHIFT))

#define  I2C3_TWSI_ICR_UR_MASK 0x4000
#define  I2C3_TWSI_ICR_UR_SHIFT 14
#define  I2C3_TWSI_ICR_UR_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_UR_MASK) >> I2C3_TWSI_ICR_UR_SHIFT)
#define  I2C3_TWSI_ICR_UR_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_UR_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_UR_SHIFT))

#define  I2C3_TWSI_ICR_SADIE_MASK 0x2000
#define  I2C3_TWSI_ICR_SADIE_SHIFT 13
#define  I2C3_TWSI_ICR_SADIE_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_SADIE_MASK) >> I2C3_TWSI_ICR_SADIE_SHIFT)
#define  I2C3_TWSI_ICR_SADIE_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_SADIE_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_SADIE_SHIFT))

#define  I2C3_TWSI_ICR_ALDIE_MASK 0x1000
#define  I2C3_TWSI_ICR_ALDIE_SHIFT 12
#define  I2C3_TWSI_ICR_ALDIE_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_ALDIE_MASK) >> I2C3_TWSI_ICR_ALDIE_SHIFT)
#define  I2C3_TWSI_ICR_ALDIE_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_ALDIE_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_ALDIE_SHIFT))

#define  I2C3_TWSI_ICR_SSDIE_MASK 0x800
#define  I2C3_TWSI_ICR_SSDIE_SHIFT 11
#define  I2C3_TWSI_ICR_SSDIE_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_SSDIE_MASK) >> I2C3_TWSI_ICR_SSDIE_SHIFT)
#define  I2C3_TWSI_ICR_SSDIE_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_SSDIE_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_SSDIE_SHIFT))

#define  I2C3_TWSI_ICR_BEIE_MASK 0x400
#define  I2C3_TWSI_ICR_BEIE_SHIFT 10
#define  I2C3_TWSI_ICR_BEIE_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_BEIE_MASK) >> I2C3_TWSI_ICR_BEIE_SHIFT)
#define  I2C3_TWSI_ICR_BEIE_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_BEIE_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_BEIE_SHIFT))

#define  I2C3_TWSI_ICR_DRFIE_MASK 0x200
#define  I2C3_TWSI_ICR_DRFIE_SHIFT 9
#define  I2C3_TWSI_ICR_DRFIE_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_DRFIE_MASK) >> I2C3_TWSI_ICR_DRFIE_SHIFT)
#define  I2C3_TWSI_ICR_DRFIE_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_DRFIE_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_DRFIE_SHIFT))

#define  I2C3_TWSI_ICR_ITEIE_MASK 0x100
#define  I2C3_TWSI_ICR_ITEIE_SHIFT 8
#define  I2C3_TWSI_ICR_ITEIE_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_ITEIE_MASK) >> I2C3_TWSI_ICR_ITEIE_SHIFT)
#define  I2C3_TWSI_ICR_ITEIE_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_ITEIE_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_ITEIE_SHIFT))

#define  I2C3_TWSI_ICR_GCD_MASK 0x80
#define  I2C3_TWSI_ICR_GCD_SHIFT 7
#define  I2C3_TWSI_ICR_GCD_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_GCD_MASK) >> I2C3_TWSI_ICR_GCD_SHIFT)
#define  I2C3_TWSI_ICR_GCD_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_GCD_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_GCD_SHIFT))

#define  I2C3_TWSI_ICR_IUE_MASK 0x40
#define  I2C3_TWSI_ICR_IUE_SHIFT 6
#define  I2C3_TWSI_ICR_IUE_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_IUE_MASK) >> I2C3_TWSI_ICR_IUE_SHIFT)
#define  I2C3_TWSI_ICR_IUE_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_IUE_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_IUE_SHIFT))

#define  I2C3_TWSI_ICR_SCLE_MASK 0x20
#define  I2C3_TWSI_ICR_SCLE_SHIFT 5
#define  I2C3_TWSI_ICR_SCLE_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_SCLE_MASK) >> I2C3_TWSI_ICR_SCLE_SHIFT)
#define  I2C3_TWSI_ICR_SCLE_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_SCLE_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_SCLE_SHIFT))

#define  I2C3_TWSI_ICR_MA_MASK 0x10
#define  I2C3_TWSI_ICR_MA_SHIFT 4
#define  I2C3_TWSI_ICR_MA_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_MA_MASK) >> I2C3_TWSI_ICR_MA_SHIFT)
#define  I2C3_TWSI_ICR_MA_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_MA_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_MA_SHIFT))

#define  I2C3_TWSI_ICR_TB_MASK 0x8
#define  I2C3_TWSI_ICR_TB_SHIFT 3
#define  I2C3_TWSI_ICR_TB_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_TB_MASK) >> I2C3_TWSI_ICR_TB_SHIFT)
#define  I2C3_TWSI_ICR_TB_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_TB_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_TB_SHIFT))

#define  I2C3_TWSI_ICR_ACKNAK_MASK 0x4
#define  I2C3_TWSI_ICR_ACKNAK_SHIFT 2
#define  I2C3_TWSI_ICR_ACKNAK_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_ACKNAK_MASK) >> I2C3_TWSI_ICR_ACKNAK_SHIFT)
#define  I2C3_TWSI_ICR_ACKNAK_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_ACKNAK_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_ACKNAK_SHIFT))

#define  I2C3_TWSI_ICR_STOP_MASK 0x2
#define  I2C3_TWSI_ICR_STOP_SHIFT 1
#define  I2C3_TWSI_ICR_STOP_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_STOP_MASK) >> I2C3_TWSI_ICR_STOP_SHIFT)
#define  I2C3_TWSI_ICR_STOP_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_STOP_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_STOP_SHIFT))

#define  I2C3_TWSI_ICR_START_MASK 0x1
#define  I2C3_TWSI_ICR_START_SHIFT 0
#define  I2C3_TWSI_ICR_START_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ICR_START_MASK) >> I2C3_TWSI_ICR_START_SHIFT)
#define  I2C3_TWSI_ICR_START_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ICR_START_MASK) | (((uint32_t)val) << I2C3_TWSI_ICR_START_SHIFT))

//====================================================================
//Register: TWSI Status Register (TWSI_ISR)
/** \brief TWSI interrupts are signalled to the PXA2128 Application Processor interrupt
controller by the TWSI Interrupt Status register. Software uses the ISR bits to
check the status of the TWSI unit and bus. ISR bits (bits 9-5) are updated after
the ACK/NAK bit has completed on the TWSI bus.
The ISR is also used to clear interrupts signalled from the TWSI bus interface
unit, and include the following:
- IDBR receive full
- IDBR transmit empty
- Slave address detected
- Bus error detected
- Stop condition detect
- Arbitration lost
- The TWSI has transmitted a STOP signal when configured as a master
- Transaction is done
- Receive FIFO threshold reached
- Transmit FIFO threshold reached
- Receive FIFO is full
- Receive FIFO overrun happened
- Receive FIFO underrun happened
- Transmit FIFO overrun happened*/
//====================================================================

#define  I2C3_TWSI_ISR_RESERVED1_MASK 0xfff00000
#define  I2C3_TWSI_ISR_RESERVED1_SHIFT 20
#define  I2C3_TWSI_ISR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ISR_RESERVED1_MASK) >> I2C3_TWSI_ISR_RESERVED1_SHIFT)
#define  I2C3_TWSI_ISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ISR_RESERVED1_MASK) | (((uint32_t)val) << I2C3_TWSI_ISR_RESERVED1_SHIFT))

#define  I2C3_TWSI_ISR_TXOV_MASK 0x80000
#define  I2C3_TWSI_ISR_TXOV_SHIFT 19
#define  I2C3_TWSI_ISR_TXOV_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ISR_TXOV_MASK) >> I2C3_TWSI_ISR_TXOV_SHIFT)
#define  I2C3_TWSI_ISR_TXOV_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ISR_TXOV_MASK) | (((uint32_t)val) << I2C3_TWSI_ISR_TXOV_SHIFT))

#define  I2C3_TWSI_ISR_RXUN_MASK 0x40000
#define  I2C3_TWSI_ISR_RXUN_SHIFT 18
#define  I2C3_TWSI_ISR_RXUN_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ISR_RXUN_MASK) >> I2C3_TWSI_ISR_RXUN_SHIFT)
#define  I2C3_TWSI_ISR_RXUN_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ISR_RXUN_MASK) | (((uint32_t)val) << I2C3_TWSI_ISR_RXUN_SHIFT))

#define  I2C3_TWSI_ISR_RXOV_MASK 0x20000
#define  I2C3_TWSI_ISR_RXOV_SHIFT 17
#define  I2C3_TWSI_ISR_RXOV_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ISR_RXOV_MASK) >> I2C3_TWSI_ISR_RXOV_SHIFT)
#define  I2C3_TWSI_ISR_RXOV_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ISR_RXOV_MASK) | (((uint32_t)val) << I2C3_TWSI_ISR_RXOV_SHIFT))

#define  I2C3_TWSI_ISR_RXF_MASK 0x10000
#define  I2C3_TWSI_ISR_RXF_SHIFT 16
#define  I2C3_TWSI_ISR_RXF_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ISR_RXF_MASK) >> I2C3_TWSI_ISR_RXF_SHIFT)
#define  I2C3_TWSI_ISR_RXF_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ISR_RXF_MASK) | (((uint32_t)val) << I2C3_TWSI_ISR_RXF_SHIFT))

#define  I2C3_TWSI_ISR_TXSR_MASK 0x8000
#define  I2C3_TWSI_ISR_TXSR_SHIFT 15
#define  I2C3_TWSI_ISR_TXSR_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ISR_TXSR_MASK) >> I2C3_TWSI_ISR_TXSR_SHIFT)
#define  I2C3_TWSI_ISR_TXSR_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ISR_TXSR_MASK) | (((uint32_t)val) << I2C3_TWSI_ISR_TXSR_SHIFT))

#define  I2C3_TWSI_ISR_RXSR_MASK 0x4000
#define  I2C3_TWSI_ISR_RXSR_SHIFT 14
#define  I2C3_TWSI_ISR_RXSR_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ISR_RXSR_MASK) >> I2C3_TWSI_ISR_RXSR_SHIFT)
#define  I2C3_TWSI_ISR_RXSR_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ISR_RXSR_MASK) | (((uint32_t)val) << I2C3_TWSI_ISR_RXSR_SHIFT))

#define  I2C3_TWSI_ISR_TXDONE_MASK 0x2000
#define  I2C3_TWSI_ISR_TXDONE_SHIFT 13
#define  I2C3_TWSI_ISR_TXDONE_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ISR_TXDONE_MASK) >> I2C3_TWSI_ISR_TXDONE_SHIFT)
#define  I2C3_TWSI_ISR_TXDONE_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ISR_TXDONE_MASK) | (((uint32_t)val) << I2C3_TWSI_ISR_TXDONE_SHIFT))

#define  I2C3_TWSI_ISR_MSD_MASK 0x1000
#define  I2C3_TWSI_ISR_MSD_SHIFT 12
#define  I2C3_TWSI_ISR_MSD_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ISR_MSD_MASK) >> I2C3_TWSI_ISR_MSD_SHIFT)
#define  I2C3_TWSI_ISR_MSD_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ISR_MSD_MASK) | (((uint32_t)val) << I2C3_TWSI_ISR_MSD_SHIFT))

#define  I2C3_TWSI_ISR_EBB_MASK 0x800
#define  I2C3_TWSI_ISR_EBB_SHIFT 11
#define  I2C3_TWSI_ISR_EBB_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ISR_EBB_MASK) >> I2C3_TWSI_ISR_EBB_SHIFT)
#define  I2C3_TWSI_ISR_EBB_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ISR_EBB_MASK) | (((uint32_t)val) << I2C3_TWSI_ISR_EBB_SHIFT))

#define  I2C3_TWSI_ISR_BED_MASK 0x400
#define  I2C3_TWSI_ISR_BED_SHIFT 10
#define  I2C3_TWSI_ISR_BED_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ISR_BED_MASK) >> I2C3_TWSI_ISR_BED_SHIFT)
#define  I2C3_TWSI_ISR_BED_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ISR_BED_MASK) | (((uint32_t)val) << I2C3_TWSI_ISR_BED_SHIFT))

#define  I2C3_TWSI_ISR_SAD_MASK 0x200
#define  I2C3_TWSI_ISR_SAD_SHIFT 9
#define  I2C3_TWSI_ISR_SAD_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ISR_SAD_MASK) >> I2C3_TWSI_ISR_SAD_SHIFT)
#define  I2C3_TWSI_ISR_SAD_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ISR_SAD_MASK) | (((uint32_t)val) << I2C3_TWSI_ISR_SAD_SHIFT))

#define  I2C3_TWSI_ISR_GCAD_MASK 0x100
#define  I2C3_TWSI_ISR_GCAD_SHIFT 8
#define  I2C3_TWSI_ISR_GCAD_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ISR_GCAD_MASK) >> I2C3_TWSI_ISR_GCAD_SHIFT)
#define  I2C3_TWSI_ISR_GCAD_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ISR_GCAD_MASK) | (((uint32_t)val) << I2C3_TWSI_ISR_GCAD_SHIFT))

#define  I2C3_TWSI_ISR_IRF_MASK 0x80
#define  I2C3_TWSI_ISR_IRF_SHIFT 7
#define  I2C3_TWSI_ISR_IRF_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ISR_IRF_MASK) >> I2C3_TWSI_ISR_IRF_SHIFT)
#define  I2C3_TWSI_ISR_IRF_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ISR_IRF_MASK) | (((uint32_t)val) << I2C3_TWSI_ISR_IRF_SHIFT))

#define  I2C3_TWSI_ISR_ITE_MASK 0x40
#define  I2C3_TWSI_ISR_ITE_SHIFT 6
#define  I2C3_TWSI_ISR_ITE_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ISR_ITE_MASK) >> I2C3_TWSI_ISR_ITE_SHIFT)
#define  I2C3_TWSI_ISR_ITE_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ISR_ITE_MASK) | (((uint32_t)val) << I2C3_TWSI_ISR_ITE_SHIFT))

#define  I2C3_TWSI_ISR_ALD_MASK 0x20
#define  I2C3_TWSI_ISR_ALD_SHIFT 5
#define  I2C3_TWSI_ISR_ALD_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ISR_ALD_MASK) >> I2C3_TWSI_ISR_ALD_SHIFT)
#define  I2C3_TWSI_ISR_ALD_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ISR_ALD_MASK) | (((uint32_t)val) << I2C3_TWSI_ISR_ALD_SHIFT))

#define  I2C3_TWSI_ISR_SSD_MASK 0x10
#define  I2C3_TWSI_ISR_SSD_SHIFT 4
#define  I2C3_TWSI_ISR_SSD_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ISR_SSD_MASK) >> I2C3_TWSI_ISR_SSD_SHIFT)
#define  I2C3_TWSI_ISR_SSD_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ISR_SSD_MASK) | (((uint32_t)val) << I2C3_TWSI_ISR_SSD_SHIFT))

#define  I2C3_TWSI_ISR_IBB_MASK 0x8
#define  I2C3_TWSI_ISR_IBB_SHIFT 3
#define  I2C3_TWSI_ISR_IBB_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ISR_IBB_MASK) >> I2C3_TWSI_ISR_IBB_SHIFT)
#define  I2C3_TWSI_ISR_IBB_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ISR_IBB_MASK) | (((uint32_t)val) << I2C3_TWSI_ISR_IBB_SHIFT))

#define  I2C3_TWSI_ISR_UB_MASK 0x4
#define  I2C3_TWSI_ISR_UB_SHIFT 2
#define  I2C3_TWSI_ISR_UB_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ISR_UB_MASK) >> I2C3_TWSI_ISR_UB_SHIFT)
#define  I2C3_TWSI_ISR_UB_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ISR_UB_MASK) | (((uint32_t)val) << I2C3_TWSI_ISR_UB_SHIFT))

#define  I2C3_TWSI_ISR_ACKNAK_MASK 0x2
#define  I2C3_TWSI_ISR_ACKNAK_SHIFT 1
#define  I2C3_TWSI_ISR_ACKNAK_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ISR_ACKNAK_MASK) >> I2C3_TWSI_ISR_ACKNAK_SHIFT)
#define  I2C3_TWSI_ISR_ACKNAK_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ISR_ACKNAK_MASK) | (((uint32_t)val) << I2C3_TWSI_ISR_ACKNAK_SHIFT))

#define  I2C3_TWSI_ISR_RWM_MASK 0x1
#define  I2C3_TWSI_ISR_RWM_SHIFT 0
#define  I2C3_TWSI_ISR_RWM_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ISR_RWM_MASK) >> I2C3_TWSI_ISR_RWM_SHIFT)
#define  I2C3_TWSI_ISR_RWM_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ISR_RWM_MASK) | (((uint32_t)val) << I2C3_TWSI_ISR_RWM_SHIFT))

//====================================================================
//Register: TWSI Slave Address Register (TWSI_ISAR)
/** \brief The ISAR defines the TWSI' s seven-bit slave address. In slave-receive mode, the
PXA2128 Application Processor responds when the seven-bit address matches the
value in this register. The PXA2128 Application Processor writes this register
before it enables TWSI operations. The ISAR is fully programmable (no address is
assigned to the TWSI) so it can be set to a value other than those of hard-wired
TWSI slave peripherals in the system.
These are read/write registers. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  I2C3_TWSI_ISAR_RESERVED1_MASK 0xffffff80
#define  I2C3_TWSI_ISAR_RESERVED1_SHIFT 7
#define  I2C3_TWSI_ISAR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ISAR_RESERVED1_MASK) >> I2C3_TWSI_ISAR_RESERVED1_SHIFT)
#define  I2C3_TWSI_ISAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ISAR_RESERVED1_MASK) | (((uint32_t)val) << I2C3_TWSI_ISAR_RESERVED1_SHIFT))

#define  I2C3_TWSI_ISAR_SLAVE_ADDRESS_MASK 0x7f
#define  I2C3_TWSI_ISAR_SLAVE_ADDRESS_SHIFT 0
#define  I2C3_TWSI_ISAR_SLAVE_ADDRESS_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ISAR_SLAVE_ADDRESS_MASK) >> I2C3_TWSI_ISAR_SLAVE_ADDRESS_SHIFT)
#define  I2C3_TWSI_ISAR_SLAVE_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ISAR_SLAVE_ADDRESS_MASK) | (((uint32_t)val) << I2C3_TWSI_ISAR_SLAVE_ADDRESS_SHIFT))

//====================================================================
//Register: TWSI Load Count Register (TWSI_ILCR)
/** \brief The TWSI must generate the SCL in master mode and the Load Count Monitor
register (ILCR) allows minor adjustments to this clock. The reset value of this
register are determined based on a 32.8 MHz TWSI input clock which allows the
maximum frequency to be derived for Fast (up to 400 Kbps) and Normal mode (up
to 100 Kbps). However, due to frequency restrictions on the TWSI input clock,
the default values of ILCR only generate an SCL than can support up to 1.8 Mbps
for HS mode.
If the alternate 66 MHz TWSI input clock is selected (via writing CCU,
FUNC_CLK_SEL to 'b11 while the TWSI is not enabled), the recommended value of
ILCR to achieve the necessary Fast, Normal and High Speed SCL frequencies
is 32'h 082C_BB56. This register must also be written while the TWSI is not
enabled.
Increasing the load value decreases the SCL frequency, while decreasing the load
raises the frequency. The amount of decrease or increase is equal to one TWSI
clock period for each value.
Note: Reset values also allow the highest possible SCL frequency that still meet
the minimum requirements listed in the TWSI Bus Specification Version 2.1. This
register should be written prior to enabling the TWSI and should not be changed
during bus activity. Writing all zeros to any of the 4 individual Load Values
causes the TWSI to not generate an SCL for that particular mode when the TWSI is
configured as a master. Extreme caution must be exercised when writing this
register.*/
//====================================================================

#define  I2C3_TWSI_ILCR_HLVH_MASK 0xf8000000
#define  I2C3_TWSI_ILCR_HLVH_SHIFT 27
#define  I2C3_TWSI_ILCR_HLVH_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ILCR_HLVH_MASK) >> I2C3_TWSI_ILCR_HLVH_SHIFT)
#define  I2C3_TWSI_ILCR_HLVH_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ILCR_HLVH_MASK) | (((uint32_t)val) << I2C3_TWSI_ILCR_HLVH_SHIFT))

#define  I2C3_TWSI_ILCR_HLVL_MASK 0x7fc0000
#define  I2C3_TWSI_ILCR_HLVL_SHIFT 18
#define  I2C3_TWSI_ILCR_HLVL_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ILCR_HLVL_MASK) >> I2C3_TWSI_ILCR_HLVL_SHIFT)
#define  I2C3_TWSI_ILCR_HLVL_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ILCR_HLVL_MASK) | (((uint32_t)val) << I2C3_TWSI_ILCR_HLVL_SHIFT))

#define  I2C3_TWSI_ILCR_FLV_MASK 0x3fe00
#define  I2C3_TWSI_ILCR_FLV_SHIFT 9
#define  I2C3_TWSI_ILCR_FLV_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ILCR_FLV_MASK) >> I2C3_TWSI_ILCR_FLV_SHIFT)
#define  I2C3_TWSI_ILCR_FLV_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ILCR_FLV_MASK) | (((uint32_t)val) << I2C3_TWSI_ILCR_FLV_SHIFT))

#define  I2C3_TWSI_ILCR_SLV_MASK 0x1ff
#define  I2C3_TWSI_ILCR_SLV_SHIFT 0
#define  I2C3_TWSI_ILCR_SLV_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_ILCR_SLV_MASK) >> I2C3_TWSI_ILCR_SLV_SHIFT)
#define  I2C3_TWSI_ILCR_SLV_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_ILCR_SLV_MASK) | (((uint32_t)val) << I2C3_TWSI_ILCR_SLV_SHIFT))

//====================================================================
//Register: TWSI Wait Count Register (TWSI_IWCR)
/** \brief The TWSI Wait Count register controls the setup and hold times during standard,
fast, or high speed. This register together with the ILCR register control the
setup and hold times for all modes.*/
//====================================================================

#define  I2C3_TWSI_IWCR_RESERVED1_MASK 0xffff8000
#define  I2C3_TWSI_IWCR_RESERVED1_SHIFT 15
#define  I2C3_TWSI_IWCR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_IWCR_RESERVED1_MASK) >> I2C3_TWSI_IWCR_RESERVED1_SHIFT)
#define  I2C3_TWSI_IWCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_IWCR_RESERVED1_MASK) | (((uint32_t)val) << I2C3_TWSI_IWCR_RESERVED1_SHIFT))

#define  I2C3_TWSI_IWCR_HS_COUNT2_MASK 0x7c00
#define  I2C3_TWSI_IWCR_HS_COUNT2_SHIFT 10
#define  I2C3_TWSI_IWCR_HS_COUNT2_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_IWCR_HS_COUNT2_MASK) >> I2C3_TWSI_IWCR_HS_COUNT2_SHIFT)
#define  I2C3_TWSI_IWCR_HS_COUNT2_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_IWCR_HS_COUNT2_MASK) | (((uint32_t)val) << I2C3_TWSI_IWCR_HS_COUNT2_SHIFT))

#define  I2C3_TWSI_IWCR_HS_COUNT1_MASK 0x3e0
#define  I2C3_TWSI_IWCR_HS_COUNT1_SHIFT 5
#define  I2C3_TWSI_IWCR_HS_COUNT1_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_IWCR_HS_COUNT1_MASK) >> I2C3_TWSI_IWCR_HS_COUNT1_SHIFT)
#define  I2C3_TWSI_IWCR_HS_COUNT1_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_IWCR_HS_COUNT1_MASK) | (((uint32_t)val) << I2C3_TWSI_IWCR_HS_COUNT1_SHIFT))

#define  I2C3_TWSI_IWCR_COUNT_MASK 0x1f
#define  I2C3_TWSI_IWCR_COUNT_SHIFT 0
#define  I2C3_TWSI_IWCR_COUNT_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_IWCR_COUNT_MASK) >> I2C3_TWSI_IWCR_COUNT_SHIFT)
#define  I2C3_TWSI_IWCR_COUNT_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_IWCR_COUNT_MASK) | (((uint32_t)val) << I2C3_TWSI_IWCR_COUNT_SHIFT))

//====================================================================
//Register: TWSI Write FIFO Register (TWSI_WFIFO)
/** \brief The TWSI Write FIFO has 16 entries and each entry is 12-bit wide (4-bit control
+ 8-bit data). This FIFO can be filled up in PIO or DMA mode. Whenever this FIFO
threshold is reached, an interrupt or a dma request is generated.*/
//====================================================================

#define  I2C3_TWSI_WFIFO_RESERVED1_MASK 0xfffff000
#define  I2C3_TWSI_WFIFO_RESERVED1_SHIFT 12
#define  I2C3_TWSI_WFIFO_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_WFIFO_RESERVED1_MASK) >> I2C3_TWSI_WFIFO_RESERVED1_SHIFT)
#define  I2C3_TWSI_WFIFO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_WFIFO_RESERVED1_MASK) | (((uint32_t)val) << I2C3_TWSI_WFIFO_RESERVED1_SHIFT))

#define  I2C3_TWSI_WFIFO_CONTROL_MASK 0xf00
#define  I2C3_TWSI_WFIFO_CONTROL_SHIFT 8
#define  I2C3_TWSI_WFIFO_CONTROL_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_WFIFO_CONTROL_MASK) >> I2C3_TWSI_WFIFO_CONTROL_SHIFT)
#define  I2C3_TWSI_WFIFO_CONTROL_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_WFIFO_CONTROL_MASK) | (((uint32_t)val) << I2C3_TWSI_WFIFO_CONTROL_SHIFT))

#define  I2C3_TWSI_WFIFO_DATA_MASK 0xff
#define  I2C3_TWSI_WFIFO_DATA_SHIFT 0
#define  I2C3_TWSI_WFIFO_DATA_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_WFIFO_DATA_MASK) >> I2C3_TWSI_WFIFO_DATA_SHIFT)
#define  I2C3_TWSI_WFIFO_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_WFIFO_DATA_MASK) | (((uint32_t)val) << I2C3_TWSI_WFIFO_DATA_SHIFT))

//====================================================================
//Register: TWSI Write FIFO Write Pointer Register (TWSI_WFIFO_WPTR)
/** \brief The TWSI Write FIFO Pointer has the TX FIFO write entry location information.
This is a read/write register. Software can write 0 to it when it wishes to
flush the FIFO after interrupts like Bus error, Arbitration loss, etc.*/
//====================================================================

#define  I2C3_TWSI_WFIFO_WPTR_RESERVED1_MASK 0xffffffe0
#define  I2C3_TWSI_WFIFO_WPTR_RESERVED1_SHIFT 5
#define  I2C3_TWSI_WFIFO_WPTR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_WFIFO_WPTR_RESERVED1_MASK) >> I2C3_TWSI_WFIFO_WPTR_RESERVED1_SHIFT)
#define  I2C3_TWSI_WFIFO_WPTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_WFIFO_WPTR_RESERVED1_MASK) | (((uint32_t)val) << I2C3_TWSI_WFIFO_WPTR_RESERVED1_SHIFT))

#define  I2C3_TWSI_WFIFO_WPTR_DATA_MASK 0x1f
#define  I2C3_TWSI_WFIFO_WPTR_DATA_SHIFT 0
#define  I2C3_TWSI_WFIFO_WPTR_DATA_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_WFIFO_WPTR_DATA_MASK) >> I2C3_TWSI_WFIFO_WPTR_DATA_SHIFT)
#define  I2C3_TWSI_WFIFO_WPTR_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_WFIFO_WPTR_DATA_MASK) | (((uint32_t)val) << I2C3_TWSI_WFIFO_WPTR_DATA_SHIFT))

//====================================================================
//Register: TWSI Write FIFO Read Pointer Register (TWSI_WFIFO_RPTR)
/** \brief The TWSI Write FIFO Read Pointer has the TX FIFO read entry location
information. This is a read/write register. Software can write 0 to it when it
wishes to flush the FIFO after an interrupt.*/
//====================================================================

#define  I2C3_TWSI_WFIFO_RPTR_RESERVED1_MASK 0xffffffe0
#define  I2C3_TWSI_WFIFO_RPTR_RESERVED1_SHIFT 5
#define  I2C3_TWSI_WFIFO_RPTR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_WFIFO_RPTR_RESERVED1_MASK) >> I2C3_TWSI_WFIFO_RPTR_RESERVED1_SHIFT)
#define  I2C3_TWSI_WFIFO_RPTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_WFIFO_RPTR_RESERVED1_MASK) | (((uint32_t)val) << I2C3_TWSI_WFIFO_RPTR_RESERVED1_SHIFT))

#define  I2C3_TWSI_WFIFO_RPTR_DATA_MASK 0x1f
#define  I2C3_TWSI_WFIFO_RPTR_DATA_SHIFT 0
#define  I2C3_TWSI_WFIFO_RPTR_DATA_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_WFIFO_RPTR_DATA_MASK) >> I2C3_TWSI_WFIFO_RPTR_DATA_SHIFT)
#define  I2C3_TWSI_WFIFO_RPTR_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_WFIFO_RPTR_DATA_MASK) | (((uint32_t)val) << I2C3_TWSI_WFIFO_RPTR_DATA_SHIFT))

//====================================================================
//Register: TWSI Read FIFO Register (TWSI_RFIFO)
/** \brief The TWSI Read FIFO has 16 entries and each entry is 8-bit wide (8-bit data).
This FIFO can be emptied in PIO or DMA mode. Whenever this FIFO is half full, an
interrupt or a dma request is generated.*/
//====================================================================

#define  I2C3_TWSI_RFIFO_RESERVED1_MASK 0xffffff00
#define  I2C3_TWSI_RFIFO_RESERVED1_SHIFT 8
#define  I2C3_TWSI_RFIFO_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_RFIFO_RESERVED1_MASK) >> I2C3_TWSI_RFIFO_RESERVED1_SHIFT)
#define  I2C3_TWSI_RFIFO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_RFIFO_RESERVED1_MASK) | (((uint32_t)val) << I2C3_TWSI_RFIFO_RESERVED1_SHIFT))

#define  I2C3_TWSI_RFIFO_DATA_MASK 0xff
#define  I2C3_TWSI_RFIFO_DATA_SHIFT 0
#define  I2C3_TWSI_RFIFO_DATA_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_RFIFO_DATA_MASK) >> I2C3_TWSI_RFIFO_DATA_SHIFT)
#define  I2C3_TWSI_RFIFO_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_RFIFO_DATA_MASK) | (((uint32_t)val) << I2C3_TWSI_RFIFO_DATA_SHIFT))

//====================================================================
//Register: TWSI Read FIFO Write Pointer Register (TWSI_RFIFO_WPTR)
/** \brief The TWSI Read FIFO Write Pointer has the RX FIFO write entry location
information. This is a read/write register. Software can write 0 to it when it
wishes to flush the FIFO after interrupts like Bus error, Arbitration loss, etc.*/
//====================================================================

#define  I2C3_TWSI_RFIFO_WPTR_RESERVED1_MASK 0xffffffe0
#define  I2C3_TWSI_RFIFO_WPTR_RESERVED1_SHIFT 5
#define  I2C3_TWSI_RFIFO_WPTR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_RFIFO_WPTR_RESERVED1_MASK) >> I2C3_TWSI_RFIFO_WPTR_RESERVED1_SHIFT)
#define  I2C3_TWSI_RFIFO_WPTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_RFIFO_WPTR_RESERVED1_MASK) | (((uint32_t)val) << I2C3_TWSI_RFIFO_WPTR_RESERVED1_SHIFT))

#define  I2C3_TWSI_RFIFO_WPTR_DATA_MASK 0x1f
#define  I2C3_TWSI_RFIFO_WPTR_DATA_SHIFT 0
#define  I2C3_TWSI_RFIFO_WPTR_DATA_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_RFIFO_WPTR_DATA_MASK) >> I2C3_TWSI_RFIFO_WPTR_DATA_SHIFT)
#define  I2C3_TWSI_RFIFO_WPTR_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_RFIFO_WPTR_DATA_MASK) | (((uint32_t)val) << I2C3_TWSI_RFIFO_WPTR_DATA_SHIFT))

//====================================================================
//Register: TWSI Read FIFO Read Pointer Register (TWSI_RFIFO_RPTR)
/** \brief The TWSI Read FIFO Read Pointer has the RX FIFO read entry location information.
This is a read/write register. Software can write 0 to it when it wishes to
flush the FIFO after an interrupt.*/
//====================================================================

#define  I2C3_TWSI_RFIFO_RPTR_RESERVED1_MASK 0xffffffe0
#define  I2C3_TWSI_RFIFO_RPTR_RESERVED1_SHIFT 5
#define  I2C3_TWSI_RFIFO_RPTR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_RFIFO_RPTR_RESERVED1_MASK) >> I2C3_TWSI_RFIFO_RPTR_RESERVED1_SHIFT)
#define  I2C3_TWSI_RFIFO_RPTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_RFIFO_RPTR_RESERVED1_MASK) | (((uint32_t)val) << I2C3_TWSI_RFIFO_RPTR_RESERVED1_SHIFT))

#define  I2C3_TWSI_RFIFO_RPTR_DATA_MASK 0x1f
#define  I2C3_TWSI_RFIFO_RPTR_DATA_SHIFT 0
#define  I2C3_TWSI_RFIFO_RPTR_DATA_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_RFIFO_RPTR_DATA_MASK) >> I2C3_TWSI_RFIFO_RPTR_DATA_SHIFT)
#define  I2C3_TWSI_RFIFO_RPTR_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_RFIFO_RPTR_DATA_MASK) | (((uint32_t)val) << I2C3_TWSI_RFIFO_RPTR_DATA_SHIFT))

//====================================================================
//Register: TWSI FIFO Threshold Register (TWSI_FIFO_TSHLD)
/** \brief The FIFO threshold register had the threshold values for TXFIFO and RXFIFO. It
is a read/write register. The default values are 0(empty) for TXFIFO and 8(half
full) for RXFIFO.*/
//====================================================================

#define  I2C3_TWSI_FIFO_TSHLD_RESERVED1_MASK 0xffe00000
#define  I2C3_TWSI_FIFO_TSHLD_RESERVED1_SHIFT 21
#define  I2C3_TWSI_FIFO_TSHLD_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_FIFO_TSHLD_RESERVED1_MASK) >> I2C3_TWSI_FIFO_TSHLD_RESERVED1_SHIFT)
#define  I2C3_TWSI_FIFO_TSHLD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_FIFO_TSHLD_RESERVED1_MASK) | (((uint32_t)val) << I2C3_TWSI_FIFO_TSHLD_RESERVED1_SHIFT))

#define  I2C3_TWSI_FIFO_TSHLD_RX_MASK 0x1f0000
#define  I2C3_TWSI_FIFO_TSHLD_RX_SHIFT 16
#define  I2C3_TWSI_FIFO_TSHLD_RX_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_FIFO_TSHLD_RX_MASK) >> I2C3_TWSI_FIFO_TSHLD_RX_SHIFT)
#define  I2C3_TWSI_FIFO_TSHLD_RX_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_FIFO_TSHLD_RX_MASK) | (((uint32_t)val) << I2C3_TWSI_FIFO_TSHLD_RX_SHIFT))

#define  I2C3_TWSI_FIFO_TSHLD_RESERVED2_MASK 0xffe0
#define  I2C3_TWSI_FIFO_TSHLD_RESERVED2_SHIFT 5
#define  I2C3_TWSI_FIFO_TSHLD_RESERVED2_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_FIFO_TSHLD_RESERVED2_MASK) >> I2C3_TWSI_FIFO_TSHLD_RESERVED2_SHIFT)
#define  I2C3_TWSI_FIFO_TSHLD_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_FIFO_TSHLD_RESERVED2_MASK) | (((uint32_t)val) << I2C3_TWSI_FIFO_TSHLD_RESERVED2_SHIFT))

#define  I2C3_TWSI_FIFO_TSHLD_TX_MASK 0x1f
#define  I2C3_TWSI_FIFO_TSHLD_TX_SHIFT 0
#define  I2C3_TWSI_FIFO_TSHLD_TX_MASK_SHIFT(reg) (((reg) & I2C3_TWSI_FIFO_TSHLD_TX_MASK) >> I2C3_TWSI_FIFO_TSHLD_TX_SHIFT)
#define  I2C3_TWSI_FIFO_TSHLD_TX_REPLACE_VAL(reg,val) (((reg) & ~I2C3_TWSI_FIFO_TSHLD_TX_MASK) | (((uint32_t)val) << I2C3_TWSI_FIFO_TSHLD_TX_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  I2C3_REV0_MAJ_MASK 0xffff0000
#define  I2C3_REV0_MAJ_SHIFT 16
#define  I2C3_REV0_MAJ_MASK_SHIFT(reg) (((reg) & I2C3_REV0_MAJ_MASK) >> I2C3_REV0_MAJ_SHIFT)
#define  I2C3_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~I2C3_REV0_MAJ_MASK) | (((uint32_t)val) << I2C3_REV0_MAJ_SHIFT))

#define  I2C3_REV0_MID_MASK 0xffff
#define  I2C3_REV0_MID_SHIFT 0
#define  I2C3_REV0_MID_MASK_SHIFT(reg) (((reg) & I2C3_REV0_MID_MASK) >> I2C3_REV0_MID_SHIFT)
#define  I2C3_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~I2C3_REV0_MID_MASK) | (((uint32_t)val) << I2C3_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  I2C3_REV1_RESERVED1_MASK 0xffff0000
#define  I2C3_REV1_RESERVED1_SHIFT 16
#define  I2C3_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C3_REV1_RESERVED1_MASK) >> I2C3_REV1_RESERVED1_SHIFT)
#define  I2C3_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C3_REV1_RESERVED1_MASK) | (((uint32_t)val) << I2C3_REV1_RESERVED1_SHIFT))

#define  I2C3_REV1_CFG_MASK 0xffff
#define  I2C3_REV1_CFG_SHIFT 0
#define  I2C3_REV1_CFG_MASK_SHIFT(reg) (((reg) & I2C3_REV1_CFG_MASK) >> I2C3_REV1_CFG_SHIFT)
#define  I2C3_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~I2C3_REV1_CFG_MASK) | (((uint32_t)val) << I2C3_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: I2C4 Registers (I2C4)
//
//====================================================================

//====================================================================
//Register: TWSI Bus Monitor Register (TWSI_IBMR)
/** \brief The TWSI Bus Monitor register (IBMR) tracks the status of the SCL and SDA pins.
The values of these pins are recorded in this read-only IBMR, so software can
determine when the TWSI bus is hung and the TWSI unit must be reset.
This a read-only register. Ignore reads from reserved bits.*/
//====================================================================

#define  I2C4_TWSI_IBMR_RESERVED1_MASK 0xfffffffc
#define  I2C4_TWSI_IBMR_RESERVED1_SHIFT 2
#define  I2C4_TWSI_IBMR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_IBMR_RESERVED1_MASK) >> I2C4_TWSI_IBMR_RESERVED1_SHIFT)
#define  I2C4_TWSI_IBMR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_IBMR_RESERVED1_MASK) | (((uint32_t)val) << I2C4_TWSI_IBMR_RESERVED1_SHIFT))

#define  I2C4_TWSI_IBMR_SCL_MASK 0x2
#define  I2C4_TWSI_IBMR_SCL_SHIFT 1
#define  I2C4_TWSI_IBMR_SCL_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_IBMR_SCL_MASK) >> I2C4_TWSI_IBMR_SCL_SHIFT)
#define  I2C4_TWSI_IBMR_SCL_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_IBMR_SCL_MASK) | (((uint32_t)val) << I2C4_TWSI_IBMR_SCL_SHIFT))

#define  I2C4_TWSI_IBMR_SDA_MASK 0x1
#define  I2C4_TWSI_IBMR_SDA_SHIFT 0
#define  I2C4_TWSI_IBMR_SDA_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_IBMR_SDA_MASK) >> I2C4_TWSI_IBMR_SDA_SHIFT)
#define  I2C4_TWSI_IBMR_SDA_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_IBMR_SDA_MASK) | (((uint32_t)val) << I2C4_TWSI_IBMR_SDA_SHIFT))

//====================================================================
//Register: TWSI Data Buffer Register (TWSI_IDBR)
/** \brief The PXA2128 Application Processor use the TWSI Data Buffer register to transmit
and receive data from the TWSI bus. The IDBR is accessed by the program I/O on
one side and by the TWSI Shift register on the other. The IDBR receives data
coming into the TWSI unit after a full byte is received and acknowledged. The
PXA2128 Application Processor core writes data going out of the TWSI to the IDBR
and sends it to the serial bus.
When the TWSI is in transmit mode (master or slave), the PXA2128 Application
Processor writes data to the IDBR over the internal bus. The PXA2128 Application
Processor write data to the IDBR when a master transaction is initiated or when
the IDBR transmit-empty interrupt is signalled. Data moves from the IDBR to the
Shift register when the transfer byte bit is set. The IDBR transmit-empty
interrupt is signalled (if enabled) when a byte is transferred on the TWSI bus
and the acknowledge cycle is complete. If the IDBR is not written by the PXA2128
Application Processor, and a Stop condition is not in place before the TWSI bus
is ready to transfer the next byte packet, the TWSI unit inserts wait states
until the PXA2128 Application Processor writes the IDBR and sets the transfer
byte bit.
When the TWSI is in receive mode (master or slave), the PXA2128 Application
Processor reads IDBR data over the internal bus. The PXA2128 Application
Processor reads data from the IDBR when the IDBR receive-full interrupt is
signalled. The data moves from the Shift register to the IDBR when the
acknowledge cycle is complete. The TWSI inserts wait states until the IDBR is
read. See Section 12.4.6 for more information on the acknowledge pulse in
receive mode. After the software reads the IDBR, ICR[ACKNAK], and ICR[ACKNAK]
are written by the software, allowing the next byte transfer to proceed to the
TWSI bus.
These are read/write registers. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  I2C4_TWSI_IDBR_RESERVED1_MASK 0xffffff00
#define  I2C4_TWSI_IDBR_RESERVED1_SHIFT 8
#define  I2C4_TWSI_IDBR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_IDBR_RESERVED1_MASK) >> I2C4_TWSI_IDBR_RESERVED1_SHIFT)
#define  I2C4_TWSI_IDBR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_IDBR_RESERVED1_MASK) | (((uint32_t)val) << I2C4_TWSI_IDBR_RESERVED1_SHIFT))

#define  I2C4_TWSI_IDBR_DATA_BUFFER_MASK 0xff
#define  I2C4_TWSI_IDBR_DATA_BUFFER_SHIFT 0
#define  I2C4_TWSI_IDBR_DATA_BUFFER_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_IDBR_DATA_BUFFER_MASK) >> I2C4_TWSI_IDBR_DATA_BUFFER_SHIFT)
#define  I2C4_TWSI_IDBR_DATA_BUFFER_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_IDBR_DATA_BUFFER_MASK) | (((uint32_t)val) << I2C4_TWSI_IDBR_DATA_BUFFER_SHIFT))

//====================================================================
//Register: TWSI Control Register (TWSI_ICR)
/** \brief The PXA2128 Application Processor uses the bits in the TWSI Control register
(ICR) to control the TWSI unit.
These are read/write registers. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  I2C4_TWSI_ICR_RESERVED1_MASK 0x80000000
#define  I2C4_TWSI_ICR_RESERVED1_SHIFT 31
#define  I2C4_TWSI_ICR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_RESERVED1_MASK) >> I2C4_TWSI_ICR_RESERVED1_SHIFT)
#define  I2C4_TWSI_ICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_RESERVED1_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_RESERVED1_SHIFT))

#define  I2C4_TWSI_ICR_SDA_GFE_MASK 0x40000000
#define  I2C4_TWSI_ICR_SDA_GFE_SHIFT 30
#define  I2C4_TWSI_ICR_SDA_GFE_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_SDA_GFE_MASK) >> I2C4_TWSI_ICR_SDA_GFE_SHIFT)
#define  I2C4_TWSI_ICR_SDA_GFE_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_SDA_GFE_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_SDA_GFE_SHIFT))

#define  I2C4_TWSI_ICR_TXOV_IE_MASK 0x20000000
#define  I2C4_TWSI_ICR_TXOV_IE_SHIFT 29
#define  I2C4_TWSI_ICR_TXOV_IE_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_TXOV_IE_MASK) >> I2C4_TWSI_ICR_TXOV_IE_SHIFT)
#define  I2C4_TWSI_ICR_TXOV_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_TXOV_IE_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_TXOV_IE_SHIFT))

#define  I2C4_TWSI_ICR_RXUN_IE_MASK 0x10000000
#define  I2C4_TWSI_ICR_RXUN_IE_SHIFT 28
#define  I2C4_TWSI_ICR_RXUN_IE_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_RXUN_IE_MASK) >> I2C4_TWSI_ICR_RXUN_IE_SHIFT)
#define  I2C4_TWSI_ICR_RXUN_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_RXUN_IE_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_RXUN_IE_SHIFT))

#define  I2C4_TWSI_ICR_DMA_EN_MASK 0x8000000
#define  I2C4_TWSI_ICR_DMA_EN_SHIFT 27
#define  I2C4_TWSI_ICR_DMA_EN_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_DMA_EN_MASK) >> I2C4_TWSI_ICR_DMA_EN_SHIFT)
#define  I2C4_TWSI_ICR_DMA_EN_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_DMA_EN_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_DMA_EN_SHIFT))

#define  I2C4_TWSI_ICR_RXOV_IE_MASK 0x4000000
#define  I2C4_TWSI_ICR_RXOV_IE_SHIFT 26
#define  I2C4_TWSI_ICR_RXOV_IE_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_RXOV_IE_MASK) >> I2C4_TWSI_ICR_RXOV_IE_SHIFT)
#define  I2C4_TWSI_ICR_RXOV_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_RXOV_IE_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_RXOV_IE_SHIFT))

#define  I2C4_TWSI_ICR_RXF_IE_MASK 0x2000000
#define  I2C4_TWSI_ICR_RXF_IE_SHIFT 25
#define  I2C4_TWSI_ICR_RXF_IE_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_RXF_IE_MASK) >> I2C4_TWSI_ICR_RXF_IE_SHIFT)
#define  I2C4_TWSI_ICR_RXF_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_RXF_IE_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_RXF_IE_SHIFT))

#define  I2C4_TWSI_ICR_TXSR_IE_MASK 0x1000000
#define  I2C4_TWSI_ICR_TXSR_IE_SHIFT 24
#define  I2C4_TWSI_ICR_TXSR_IE_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_TXSR_IE_MASK) >> I2C4_TWSI_ICR_TXSR_IE_SHIFT)
#define  I2C4_TWSI_ICR_TXSR_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_TXSR_IE_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_TXSR_IE_SHIFT))

#define  I2C4_TWSI_ICR_RXSR_IE_MASK 0x800000
#define  I2C4_TWSI_ICR_RXSR_IE_SHIFT 23
#define  I2C4_TWSI_ICR_RXSR_IE_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_RXSR_IE_MASK) >> I2C4_TWSI_ICR_RXSR_IE_SHIFT)
#define  I2C4_TWSI_ICR_RXSR_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_RXSR_IE_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_RXSR_IE_SHIFT))

#define  I2C4_TWSI_ICR_TXDONE_IE_MASK 0x400000
#define  I2C4_TWSI_ICR_TXDONE_IE_SHIFT 22
#define  I2C4_TWSI_ICR_TXDONE_IE_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_TXDONE_IE_MASK) >> I2C4_TWSI_ICR_TXDONE_IE_SHIFT)
#define  I2C4_TWSI_ICR_TXDONE_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_TXDONE_IE_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_TXDONE_IE_SHIFT))

#define  I2C4_TWSI_ICR_TXBEGIN_MASK 0x200000
#define  I2C4_TWSI_ICR_TXBEGIN_SHIFT 21
#define  I2C4_TWSI_ICR_TXBEGIN_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_TXBEGIN_MASK) >> I2C4_TWSI_ICR_TXBEGIN_SHIFT)
#define  I2C4_TWSI_ICR_TXBEGIN_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_TXBEGIN_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_TXBEGIN_SHIFT))

#define  I2C4_TWSI_ICR_FIFOEN_MASK 0x100000
#define  I2C4_TWSI_ICR_FIFOEN_SHIFT 20
#define  I2C4_TWSI_ICR_FIFOEN_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_FIFOEN_MASK) >> I2C4_TWSI_ICR_FIFOEN_SHIFT)
#define  I2C4_TWSI_ICR_FIFOEN_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_FIFOEN_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_FIFOEN_SHIFT))

#define  I2C4_TWSI_ICR_GPIOEN_MASK 0x80000
#define  I2C4_TWSI_ICR_GPIOEN_SHIFT 19
#define  I2C4_TWSI_ICR_GPIOEN_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_GPIOEN_MASK) >> I2C4_TWSI_ICR_GPIOEN_SHIFT)
#define  I2C4_TWSI_ICR_GPIOEN_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_GPIOEN_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_GPIOEN_SHIFT))

#define  I2C4_TWSI_ICR_MSDE_MASK 0x40000
#define  I2C4_TWSI_ICR_MSDE_SHIFT 18
#define  I2C4_TWSI_ICR_MSDE_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_MSDE_MASK) >> I2C4_TWSI_ICR_MSDE_SHIFT)
#define  I2C4_TWSI_ICR_MSDE_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_MSDE_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_MSDE_SHIFT))

#define  I2C4_TWSI_ICR_MSDIE_MASK 0x20000
#define  I2C4_TWSI_ICR_MSDIE_SHIFT 17
#define  I2C4_TWSI_ICR_MSDIE_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_MSDIE_MASK) >> I2C4_TWSI_ICR_MSDIE_SHIFT)
#define  I2C4_TWSI_ICR_MSDIE_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_MSDIE_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_MSDIE_SHIFT))

#define  I2C4_TWSI_ICR_MODE_MASK 0x18000
#define  I2C4_TWSI_ICR_MODE_SHIFT 15
#define  I2C4_TWSI_ICR_MODE_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_MODE_MASK) >> I2C4_TWSI_ICR_MODE_SHIFT)
#define  I2C4_TWSI_ICR_MODE_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_MODE_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_MODE_SHIFT))

#define  I2C4_TWSI_ICR_UR_MASK 0x4000
#define  I2C4_TWSI_ICR_UR_SHIFT 14
#define  I2C4_TWSI_ICR_UR_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_UR_MASK) >> I2C4_TWSI_ICR_UR_SHIFT)
#define  I2C4_TWSI_ICR_UR_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_UR_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_UR_SHIFT))

#define  I2C4_TWSI_ICR_SADIE_MASK 0x2000
#define  I2C4_TWSI_ICR_SADIE_SHIFT 13
#define  I2C4_TWSI_ICR_SADIE_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_SADIE_MASK) >> I2C4_TWSI_ICR_SADIE_SHIFT)
#define  I2C4_TWSI_ICR_SADIE_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_SADIE_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_SADIE_SHIFT))

#define  I2C4_TWSI_ICR_ALDIE_MASK 0x1000
#define  I2C4_TWSI_ICR_ALDIE_SHIFT 12
#define  I2C4_TWSI_ICR_ALDIE_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_ALDIE_MASK) >> I2C4_TWSI_ICR_ALDIE_SHIFT)
#define  I2C4_TWSI_ICR_ALDIE_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_ALDIE_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_ALDIE_SHIFT))

#define  I2C4_TWSI_ICR_SSDIE_MASK 0x800
#define  I2C4_TWSI_ICR_SSDIE_SHIFT 11
#define  I2C4_TWSI_ICR_SSDIE_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_SSDIE_MASK) >> I2C4_TWSI_ICR_SSDIE_SHIFT)
#define  I2C4_TWSI_ICR_SSDIE_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_SSDIE_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_SSDIE_SHIFT))

#define  I2C4_TWSI_ICR_BEIE_MASK 0x400
#define  I2C4_TWSI_ICR_BEIE_SHIFT 10
#define  I2C4_TWSI_ICR_BEIE_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_BEIE_MASK) >> I2C4_TWSI_ICR_BEIE_SHIFT)
#define  I2C4_TWSI_ICR_BEIE_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_BEIE_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_BEIE_SHIFT))

#define  I2C4_TWSI_ICR_DRFIE_MASK 0x200
#define  I2C4_TWSI_ICR_DRFIE_SHIFT 9
#define  I2C4_TWSI_ICR_DRFIE_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_DRFIE_MASK) >> I2C4_TWSI_ICR_DRFIE_SHIFT)
#define  I2C4_TWSI_ICR_DRFIE_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_DRFIE_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_DRFIE_SHIFT))

#define  I2C4_TWSI_ICR_ITEIE_MASK 0x100
#define  I2C4_TWSI_ICR_ITEIE_SHIFT 8
#define  I2C4_TWSI_ICR_ITEIE_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_ITEIE_MASK) >> I2C4_TWSI_ICR_ITEIE_SHIFT)
#define  I2C4_TWSI_ICR_ITEIE_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_ITEIE_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_ITEIE_SHIFT))

#define  I2C4_TWSI_ICR_GCD_MASK 0x80
#define  I2C4_TWSI_ICR_GCD_SHIFT 7
#define  I2C4_TWSI_ICR_GCD_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_GCD_MASK) >> I2C4_TWSI_ICR_GCD_SHIFT)
#define  I2C4_TWSI_ICR_GCD_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_GCD_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_GCD_SHIFT))

#define  I2C4_TWSI_ICR_IUE_MASK 0x40
#define  I2C4_TWSI_ICR_IUE_SHIFT 6
#define  I2C4_TWSI_ICR_IUE_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_IUE_MASK) >> I2C4_TWSI_ICR_IUE_SHIFT)
#define  I2C4_TWSI_ICR_IUE_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_IUE_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_IUE_SHIFT))

#define  I2C4_TWSI_ICR_SCLE_MASK 0x20
#define  I2C4_TWSI_ICR_SCLE_SHIFT 5
#define  I2C4_TWSI_ICR_SCLE_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_SCLE_MASK) >> I2C4_TWSI_ICR_SCLE_SHIFT)
#define  I2C4_TWSI_ICR_SCLE_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_SCLE_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_SCLE_SHIFT))

#define  I2C4_TWSI_ICR_MA_MASK 0x10
#define  I2C4_TWSI_ICR_MA_SHIFT 4
#define  I2C4_TWSI_ICR_MA_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_MA_MASK) >> I2C4_TWSI_ICR_MA_SHIFT)
#define  I2C4_TWSI_ICR_MA_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_MA_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_MA_SHIFT))

#define  I2C4_TWSI_ICR_TB_MASK 0x8
#define  I2C4_TWSI_ICR_TB_SHIFT 3
#define  I2C4_TWSI_ICR_TB_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_TB_MASK) >> I2C4_TWSI_ICR_TB_SHIFT)
#define  I2C4_TWSI_ICR_TB_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_TB_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_TB_SHIFT))

#define  I2C4_TWSI_ICR_ACKNAK_MASK 0x4
#define  I2C4_TWSI_ICR_ACKNAK_SHIFT 2
#define  I2C4_TWSI_ICR_ACKNAK_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_ACKNAK_MASK) >> I2C4_TWSI_ICR_ACKNAK_SHIFT)
#define  I2C4_TWSI_ICR_ACKNAK_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_ACKNAK_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_ACKNAK_SHIFT))

#define  I2C4_TWSI_ICR_STOP_MASK 0x2
#define  I2C4_TWSI_ICR_STOP_SHIFT 1
#define  I2C4_TWSI_ICR_STOP_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_STOP_MASK) >> I2C4_TWSI_ICR_STOP_SHIFT)
#define  I2C4_TWSI_ICR_STOP_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_STOP_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_STOP_SHIFT))

#define  I2C4_TWSI_ICR_START_MASK 0x1
#define  I2C4_TWSI_ICR_START_SHIFT 0
#define  I2C4_TWSI_ICR_START_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ICR_START_MASK) >> I2C4_TWSI_ICR_START_SHIFT)
#define  I2C4_TWSI_ICR_START_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ICR_START_MASK) | (((uint32_t)val) << I2C4_TWSI_ICR_START_SHIFT))

//====================================================================
//Register: TWSI Status Register (TWSI_ISR)
/** \brief TWSI interrupts are signalled to the PXA2128 Application Processor interrupt
controller by the TWSI Interrupt Status register. Software uses the ISR bits to
check the status of the TWSI unit and bus. ISR bits (bits 9-5) are updated after
the ACK/NAK bit has completed on the TWSI bus.
The ISR is also used to clear interrupts signalled from the TWSI bus interface
unit, and include the following:
- IDBR receive full
- IDBR transmit empty
- Slave address detected
- Bus error detected
- Stop condition detect
- Arbitration lost
- The TWSI has transmitted a STOP signal when configured as a master
- Transaction is done
- Receive FIFO threshold reached
- Transmit FIFO threshold reached
- Receive FIFO is full
- Receive FIFO overrun happened
- Receive FIFO underrun happened
- Transmit FIFO overrun happened*/
//====================================================================

#define  I2C4_TWSI_ISR_RESERVED1_MASK 0xfff00000
#define  I2C4_TWSI_ISR_RESERVED1_SHIFT 20
#define  I2C4_TWSI_ISR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ISR_RESERVED1_MASK) >> I2C4_TWSI_ISR_RESERVED1_SHIFT)
#define  I2C4_TWSI_ISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ISR_RESERVED1_MASK) | (((uint32_t)val) << I2C4_TWSI_ISR_RESERVED1_SHIFT))

#define  I2C4_TWSI_ISR_TXOV_MASK 0x80000
#define  I2C4_TWSI_ISR_TXOV_SHIFT 19
#define  I2C4_TWSI_ISR_TXOV_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ISR_TXOV_MASK) >> I2C4_TWSI_ISR_TXOV_SHIFT)
#define  I2C4_TWSI_ISR_TXOV_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ISR_TXOV_MASK) | (((uint32_t)val) << I2C4_TWSI_ISR_TXOV_SHIFT))

#define  I2C4_TWSI_ISR_RXUN_MASK 0x40000
#define  I2C4_TWSI_ISR_RXUN_SHIFT 18
#define  I2C4_TWSI_ISR_RXUN_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ISR_RXUN_MASK) >> I2C4_TWSI_ISR_RXUN_SHIFT)
#define  I2C4_TWSI_ISR_RXUN_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ISR_RXUN_MASK) | (((uint32_t)val) << I2C4_TWSI_ISR_RXUN_SHIFT))

#define  I2C4_TWSI_ISR_RXOV_MASK 0x20000
#define  I2C4_TWSI_ISR_RXOV_SHIFT 17
#define  I2C4_TWSI_ISR_RXOV_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ISR_RXOV_MASK) >> I2C4_TWSI_ISR_RXOV_SHIFT)
#define  I2C4_TWSI_ISR_RXOV_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ISR_RXOV_MASK) | (((uint32_t)val) << I2C4_TWSI_ISR_RXOV_SHIFT))

#define  I2C4_TWSI_ISR_RXF_MASK 0x10000
#define  I2C4_TWSI_ISR_RXF_SHIFT 16
#define  I2C4_TWSI_ISR_RXF_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ISR_RXF_MASK) >> I2C4_TWSI_ISR_RXF_SHIFT)
#define  I2C4_TWSI_ISR_RXF_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ISR_RXF_MASK) | (((uint32_t)val) << I2C4_TWSI_ISR_RXF_SHIFT))

#define  I2C4_TWSI_ISR_TXSR_MASK 0x8000
#define  I2C4_TWSI_ISR_TXSR_SHIFT 15
#define  I2C4_TWSI_ISR_TXSR_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ISR_TXSR_MASK) >> I2C4_TWSI_ISR_TXSR_SHIFT)
#define  I2C4_TWSI_ISR_TXSR_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ISR_TXSR_MASK) | (((uint32_t)val) << I2C4_TWSI_ISR_TXSR_SHIFT))

#define  I2C4_TWSI_ISR_RXSR_MASK 0x4000
#define  I2C4_TWSI_ISR_RXSR_SHIFT 14
#define  I2C4_TWSI_ISR_RXSR_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ISR_RXSR_MASK) >> I2C4_TWSI_ISR_RXSR_SHIFT)
#define  I2C4_TWSI_ISR_RXSR_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ISR_RXSR_MASK) | (((uint32_t)val) << I2C4_TWSI_ISR_RXSR_SHIFT))

#define  I2C4_TWSI_ISR_TXDONE_MASK 0x2000
#define  I2C4_TWSI_ISR_TXDONE_SHIFT 13
#define  I2C4_TWSI_ISR_TXDONE_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ISR_TXDONE_MASK) >> I2C4_TWSI_ISR_TXDONE_SHIFT)
#define  I2C4_TWSI_ISR_TXDONE_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ISR_TXDONE_MASK) | (((uint32_t)val) << I2C4_TWSI_ISR_TXDONE_SHIFT))

#define  I2C4_TWSI_ISR_MSD_MASK 0x1000
#define  I2C4_TWSI_ISR_MSD_SHIFT 12
#define  I2C4_TWSI_ISR_MSD_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ISR_MSD_MASK) >> I2C4_TWSI_ISR_MSD_SHIFT)
#define  I2C4_TWSI_ISR_MSD_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ISR_MSD_MASK) | (((uint32_t)val) << I2C4_TWSI_ISR_MSD_SHIFT))

#define  I2C4_TWSI_ISR_EBB_MASK 0x800
#define  I2C4_TWSI_ISR_EBB_SHIFT 11
#define  I2C4_TWSI_ISR_EBB_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ISR_EBB_MASK) >> I2C4_TWSI_ISR_EBB_SHIFT)
#define  I2C4_TWSI_ISR_EBB_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ISR_EBB_MASK) | (((uint32_t)val) << I2C4_TWSI_ISR_EBB_SHIFT))

#define  I2C4_TWSI_ISR_BED_MASK 0x400
#define  I2C4_TWSI_ISR_BED_SHIFT 10
#define  I2C4_TWSI_ISR_BED_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ISR_BED_MASK) >> I2C4_TWSI_ISR_BED_SHIFT)
#define  I2C4_TWSI_ISR_BED_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ISR_BED_MASK) | (((uint32_t)val) << I2C4_TWSI_ISR_BED_SHIFT))

#define  I2C4_TWSI_ISR_SAD_MASK 0x200
#define  I2C4_TWSI_ISR_SAD_SHIFT 9
#define  I2C4_TWSI_ISR_SAD_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ISR_SAD_MASK) >> I2C4_TWSI_ISR_SAD_SHIFT)
#define  I2C4_TWSI_ISR_SAD_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ISR_SAD_MASK) | (((uint32_t)val) << I2C4_TWSI_ISR_SAD_SHIFT))

#define  I2C4_TWSI_ISR_GCAD_MASK 0x100
#define  I2C4_TWSI_ISR_GCAD_SHIFT 8
#define  I2C4_TWSI_ISR_GCAD_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ISR_GCAD_MASK) >> I2C4_TWSI_ISR_GCAD_SHIFT)
#define  I2C4_TWSI_ISR_GCAD_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ISR_GCAD_MASK) | (((uint32_t)val) << I2C4_TWSI_ISR_GCAD_SHIFT))

#define  I2C4_TWSI_ISR_IRF_MASK 0x80
#define  I2C4_TWSI_ISR_IRF_SHIFT 7
#define  I2C4_TWSI_ISR_IRF_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ISR_IRF_MASK) >> I2C4_TWSI_ISR_IRF_SHIFT)
#define  I2C4_TWSI_ISR_IRF_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ISR_IRF_MASK) | (((uint32_t)val) << I2C4_TWSI_ISR_IRF_SHIFT))

#define  I2C4_TWSI_ISR_ITE_MASK 0x40
#define  I2C4_TWSI_ISR_ITE_SHIFT 6
#define  I2C4_TWSI_ISR_ITE_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ISR_ITE_MASK) >> I2C4_TWSI_ISR_ITE_SHIFT)
#define  I2C4_TWSI_ISR_ITE_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ISR_ITE_MASK) | (((uint32_t)val) << I2C4_TWSI_ISR_ITE_SHIFT))

#define  I2C4_TWSI_ISR_ALD_MASK 0x20
#define  I2C4_TWSI_ISR_ALD_SHIFT 5
#define  I2C4_TWSI_ISR_ALD_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ISR_ALD_MASK) >> I2C4_TWSI_ISR_ALD_SHIFT)
#define  I2C4_TWSI_ISR_ALD_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ISR_ALD_MASK) | (((uint32_t)val) << I2C4_TWSI_ISR_ALD_SHIFT))

#define  I2C4_TWSI_ISR_SSD_MASK 0x10
#define  I2C4_TWSI_ISR_SSD_SHIFT 4
#define  I2C4_TWSI_ISR_SSD_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ISR_SSD_MASK) >> I2C4_TWSI_ISR_SSD_SHIFT)
#define  I2C4_TWSI_ISR_SSD_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ISR_SSD_MASK) | (((uint32_t)val) << I2C4_TWSI_ISR_SSD_SHIFT))

#define  I2C4_TWSI_ISR_IBB_MASK 0x8
#define  I2C4_TWSI_ISR_IBB_SHIFT 3
#define  I2C4_TWSI_ISR_IBB_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ISR_IBB_MASK) >> I2C4_TWSI_ISR_IBB_SHIFT)
#define  I2C4_TWSI_ISR_IBB_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ISR_IBB_MASK) | (((uint32_t)val) << I2C4_TWSI_ISR_IBB_SHIFT))

#define  I2C4_TWSI_ISR_UB_MASK 0x4
#define  I2C4_TWSI_ISR_UB_SHIFT 2
#define  I2C4_TWSI_ISR_UB_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ISR_UB_MASK) >> I2C4_TWSI_ISR_UB_SHIFT)
#define  I2C4_TWSI_ISR_UB_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ISR_UB_MASK) | (((uint32_t)val) << I2C4_TWSI_ISR_UB_SHIFT))

#define  I2C4_TWSI_ISR_ACKNAK_MASK 0x2
#define  I2C4_TWSI_ISR_ACKNAK_SHIFT 1
#define  I2C4_TWSI_ISR_ACKNAK_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ISR_ACKNAK_MASK) >> I2C4_TWSI_ISR_ACKNAK_SHIFT)
#define  I2C4_TWSI_ISR_ACKNAK_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ISR_ACKNAK_MASK) | (((uint32_t)val) << I2C4_TWSI_ISR_ACKNAK_SHIFT))

#define  I2C4_TWSI_ISR_RWM_MASK 0x1
#define  I2C4_TWSI_ISR_RWM_SHIFT 0
#define  I2C4_TWSI_ISR_RWM_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ISR_RWM_MASK) >> I2C4_TWSI_ISR_RWM_SHIFT)
#define  I2C4_TWSI_ISR_RWM_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ISR_RWM_MASK) | (((uint32_t)val) << I2C4_TWSI_ISR_RWM_SHIFT))

//====================================================================
//Register: TWSI Slave Address Register (TWSI_ISAR)
/** \brief The ISAR defines the TWSI' s seven-bit slave address. In slave-receive mode, the
PXA2128 Application Processor responds when the seven-bit address matches the
value in this register. The PXA2128 Application Processor writes this register
before it enables TWSI operations. The ISAR is fully programmable (no address is
assigned to the TWSI) so it can be set to a value other than those of hard-wired
TWSI slave peripherals in the system.
These are read/write registers. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  I2C4_TWSI_ISAR_RESERVED1_MASK 0xffffff80
#define  I2C4_TWSI_ISAR_RESERVED1_SHIFT 7
#define  I2C4_TWSI_ISAR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ISAR_RESERVED1_MASK) >> I2C4_TWSI_ISAR_RESERVED1_SHIFT)
#define  I2C4_TWSI_ISAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ISAR_RESERVED1_MASK) | (((uint32_t)val) << I2C4_TWSI_ISAR_RESERVED1_SHIFT))

#define  I2C4_TWSI_ISAR_SLAVE_ADDRESS_MASK 0x7f
#define  I2C4_TWSI_ISAR_SLAVE_ADDRESS_SHIFT 0
#define  I2C4_TWSI_ISAR_SLAVE_ADDRESS_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ISAR_SLAVE_ADDRESS_MASK) >> I2C4_TWSI_ISAR_SLAVE_ADDRESS_SHIFT)
#define  I2C4_TWSI_ISAR_SLAVE_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ISAR_SLAVE_ADDRESS_MASK) | (((uint32_t)val) << I2C4_TWSI_ISAR_SLAVE_ADDRESS_SHIFT))

//====================================================================
//Register: TWSI Load Count Register (TWSI_ILCR)
/** \brief The TWSI must generate the SCL in master mode and the Load Count Monitor
register (ILCR) allows minor adjustments to this clock. The reset value of this
register are determined based on a 32.8 MHz TWSI input clock which allows the
maximum frequency to be derived for Fast (up to 400 Kbps) and Normal mode (up
to 100 Kbps). However, due to frequency restrictions on the TWSI input clock,
the default values of ILCR only generate an SCL than can support up to 1.8 Mbps
for HS mode.
If the alternate 66 MHz TWSI input clock is selected (via writing CCU,
FUNC_CLK_SEL to 'b11 while the TWSI is not enabled), the recommended value of
ILCR to achieve the necessary Fast, Normal and High Speed SCL frequencies
is 32'h 082C_BB56. This register must also be written while the TWSI is not
enabled.
Increasing the load value decreases the SCL frequency, while decreasing the load
raises the frequency. The amount of decrease or increase is equal to one TWSI
clock period for each value.
Note: Reset values also allow the highest possible SCL frequency that still meet
the minimum requirements listed in the TWSI Bus Specification Version 2.1. This
register should be written prior to enabling the TWSI and should not be changed
during bus activity. Writing all zeros to any of the 4 individual Load Values
causes the TWSI to not generate an SCL for that particular mode when the TWSI is
configured as a master. Extreme caution must be exercised when writing this
register.*/
//====================================================================

#define  I2C4_TWSI_ILCR_HLVH_MASK 0xf8000000
#define  I2C4_TWSI_ILCR_HLVH_SHIFT 27
#define  I2C4_TWSI_ILCR_HLVH_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ILCR_HLVH_MASK) >> I2C4_TWSI_ILCR_HLVH_SHIFT)
#define  I2C4_TWSI_ILCR_HLVH_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ILCR_HLVH_MASK) | (((uint32_t)val) << I2C4_TWSI_ILCR_HLVH_SHIFT))

#define  I2C4_TWSI_ILCR_HLVL_MASK 0x7fc0000
#define  I2C4_TWSI_ILCR_HLVL_SHIFT 18
#define  I2C4_TWSI_ILCR_HLVL_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ILCR_HLVL_MASK) >> I2C4_TWSI_ILCR_HLVL_SHIFT)
#define  I2C4_TWSI_ILCR_HLVL_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ILCR_HLVL_MASK) | (((uint32_t)val) << I2C4_TWSI_ILCR_HLVL_SHIFT))

#define  I2C4_TWSI_ILCR_FLV_MASK 0x3fe00
#define  I2C4_TWSI_ILCR_FLV_SHIFT 9
#define  I2C4_TWSI_ILCR_FLV_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ILCR_FLV_MASK) >> I2C4_TWSI_ILCR_FLV_SHIFT)
#define  I2C4_TWSI_ILCR_FLV_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ILCR_FLV_MASK) | (((uint32_t)val) << I2C4_TWSI_ILCR_FLV_SHIFT))

#define  I2C4_TWSI_ILCR_SLV_MASK 0x1ff
#define  I2C4_TWSI_ILCR_SLV_SHIFT 0
#define  I2C4_TWSI_ILCR_SLV_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_ILCR_SLV_MASK) >> I2C4_TWSI_ILCR_SLV_SHIFT)
#define  I2C4_TWSI_ILCR_SLV_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_ILCR_SLV_MASK) | (((uint32_t)val) << I2C4_TWSI_ILCR_SLV_SHIFT))

//====================================================================
//Register: TWSI Wait Count Register (TWSI_IWCR)
/** \brief The TWSI Wait Count register controls the setup and hold times during standard,
fast, or high speed. This register together with the ILCR register control the
setup and hold times for all modes.*/
//====================================================================

#define  I2C4_TWSI_IWCR_RESERVED1_MASK 0xffff8000
#define  I2C4_TWSI_IWCR_RESERVED1_SHIFT 15
#define  I2C4_TWSI_IWCR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_IWCR_RESERVED1_MASK) >> I2C4_TWSI_IWCR_RESERVED1_SHIFT)
#define  I2C4_TWSI_IWCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_IWCR_RESERVED1_MASK) | (((uint32_t)val) << I2C4_TWSI_IWCR_RESERVED1_SHIFT))

#define  I2C4_TWSI_IWCR_HS_COUNT2_MASK 0x7c00
#define  I2C4_TWSI_IWCR_HS_COUNT2_SHIFT 10
#define  I2C4_TWSI_IWCR_HS_COUNT2_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_IWCR_HS_COUNT2_MASK) >> I2C4_TWSI_IWCR_HS_COUNT2_SHIFT)
#define  I2C4_TWSI_IWCR_HS_COUNT2_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_IWCR_HS_COUNT2_MASK) | (((uint32_t)val) << I2C4_TWSI_IWCR_HS_COUNT2_SHIFT))

#define  I2C4_TWSI_IWCR_HS_COUNT1_MASK 0x3e0
#define  I2C4_TWSI_IWCR_HS_COUNT1_SHIFT 5
#define  I2C4_TWSI_IWCR_HS_COUNT1_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_IWCR_HS_COUNT1_MASK) >> I2C4_TWSI_IWCR_HS_COUNT1_SHIFT)
#define  I2C4_TWSI_IWCR_HS_COUNT1_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_IWCR_HS_COUNT1_MASK) | (((uint32_t)val) << I2C4_TWSI_IWCR_HS_COUNT1_SHIFT))

#define  I2C4_TWSI_IWCR_COUNT_MASK 0x1f
#define  I2C4_TWSI_IWCR_COUNT_SHIFT 0
#define  I2C4_TWSI_IWCR_COUNT_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_IWCR_COUNT_MASK) >> I2C4_TWSI_IWCR_COUNT_SHIFT)
#define  I2C4_TWSI_IWCR_COUNT_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_IWCR_COUNT_MASK) | (((uint32_t)val) << I2C4_TWSI_IWCR_COUNT_SHIFT))

//====================================================================
//Register: TWSI Write FIFO Register (TWSI_WFIFO)
/** \brief The TWSI Write FIFO has 16 entries and each entry is 12-bit wide (4-bit control
+ 8-bit data). This FIFO can be filled up in PIO or DMA mode. Whenever this FIFO
threshold is reached, an interrupt or a dma request is generated.*/
//====================================================================

#define  I2C4_TWSI_WFIFO_RESERVED1_MASK 0xfffff000
#define  I2C4_TWSI_WFIFO_RESERVED1_SHIFT 12
#define  I2C4_TWSI_WFIFO_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_WFIFO_RESERVED1_MASK) >> I2C4_TWSI_WFIFO_RESERVED1_SHIFT)
#define  I2C4_TWSI_WFIFO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_WFIFO_RESERVED1_MASK) | (((uint32_t)val) << I2C4_TWSI_WFIFO_RESERVED1_SHIFT))

#define  I2C4_TWSI_WFIFO_CONTROL_MASK 0xf00
#define  I2C4_TWSI_WFIFO_CONTROL_SHIFT 8
#define  I2C4_TWSI_WFIFO_CONTROL_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_WFIFO_CONTROL_MASK) >> I2C4_TWSI_WFIFO_CONTROL_SHIFT)
#define  I2C4_TWSI_WFIFO_CONTROL_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_WFIFO_CONTROL_MASK) | (((uint32_t)val) << I2C4_TWSI_WFIFO_CONTROL_SHIFT))

#define  I2C4_TWSI_WFIFO_DATA_MASK 0xff
#define  I2C4_TWSI_WFIFO_DATA_SHIFT 0
#define  I2C4_TWSI_WFIFO_DATA_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_WFIFO_DATA_MASK) >> I2C4_TWSI_WFIFO_DATA_SHIFT)
#define  I2C4_TWSI_WFIFO_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_WFIFO_DATA_MASK) | (((uint32_t)val) << I2C4_TWSI_WFIFO_DATA_SHIFT))

//====================================================================
//Register: TWSI Write FIFO Write Pointer Register (TWSI_WFIFO_WPTR)
/** \brief The TWSI Write FIFO Pointer has the TX FIFO write entry location information.
This is a read/write register. Software can write 0 to it when it wishes to
flush the FIFO after interrupts like Bus error, Arbitration loss, etc.*/
//====================================================================

#define  I2C4_TWSI_WFIFO_WPTR_RESERVED1_MASK 0xffffffe0
#define  I2C4_TWSI_WFIFO_WPTR_RESERVED1_SHIFT 5
#define  I2C4_TWSI_WFIFO_WPTR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_WFIFO_WPTR_RESERVED1_MASK) >> I2C4_TWSI_WFIFO_WPTR_RESERVED1_SHIFT)
#define  I2C4_TWSI_WFIFO_WPTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_WFIFO_WPTR_RESERVED1_MASK) | (((uint32_t)val) << I2C4_TWSI_WFIFO_WPTR_RESERVED1_SHIFT))

#define  I2C4_TWSI_WFIFO_WPTR_DATA_MASK 0x1f
#define  I2C4_TWSI_WFIFO_WPTR_DATA_SHIFT 0
#define  I2C4_TWSI_WFIFO_WPTR_DATA_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_WFIFO_WPTR_DATA_MASK) >> I2C4_TWSI_WFIFO_WPTR_DATA_SHIFT)
#define  I2C4_TWSI_WFIFO_WPTR_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_WFIFO_WPTR_DATA_MASK) | (((uint32_t)val) << I2C4_TWSI_WFIFO_WPTR_DATA_SHIFT))

//====================================================================
//Register: TWSI Write FIFO Read Pointer Register (TWSI_WFIFO_RPTR)
/** \brief The TWSI Write FIFO Read Pointer has the TX FIFO read entry location
information. This is a read/write register. Software can write 0 to it when it
wishes to flush the FIFO after an interrupt.*/
//====================================================================

#define  I2C4_TWSI_WFIFO_RPTR_RESERVED1_MASK 0xffffffe0
#define  I2C4_TWSI_WFIFO_RPTR_RESERVED1_SHIFT 5
#define  I2C4_TWSI_WFIFO_RPTR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_WFIFO_RPTR_RESERVED1_MASK) >> I2C4_TWSI_WFIFO_RPTR_RESERVED1_SHIFT)
#define  I2C4_TWSI_WFIFO_RPTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_WFIFO_RPTR_RESERVED1_MASK) | (((uint32_t)val) << I2C4_TWSI_WFIFO_RPTR_RESERVED1_SHIFT))

#define  I2C4_TWSI_WFIFO_RPTR_DATA_MASK 0x1f
#define  I2C4_TWSI_WFIFO_RPTR_DATA_SHIFT 0
#define  I2C4_TWSI_WFIFO_RPTR_DATA_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_WFIFO_RPTR_DATA_MASK) >> I2C4_TWSI_WFIFO_RPTR_DATA_SHIFT)
#define  I2C4_TWSI_WFIFO_RPTR_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_WFIFO_RPTR_DATA_MASK) | (((uint32_t)val) << I2C4_TWSI_WFIFO_RPTR_DATA_SHIFT))

//====================================================================
//Register: TWSI Read FIFO Register (TWSI_RFIFO)
/** \brief The TWSI Read FIFO has 16 entries and each entry is 8-bit wide (8-bit data).
This FIFO can be emptied in PIO or DMA mode. Whenever this FIFO is half full, an
interrupt or a dma request is generated.*/
//====================================================================

#define  I2C4_TWSI_RFIFO_RESERVED1_MASK 0xffffff00
#define  I2C4_TWSI_RFIFO_RESERVED1_SHIFT 8
#define  I2C4_TWSI_RFIFO_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_RFIFO_RESERVED1_MASK) >> I2C4_TWSI_RFIFO_RESERVED1_SHIFT)
#define  I2C4_TWSI_RFIFO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_RFIFO_RESERVED1_MASK) | (((uint32_t)val) << I2C4_TWSI_RFIFO_RESERVED1_SHIFT))

#define  I2C4_TWSI_RFIFO_DATA_MASK 0xff
#define  I2C4_TWSI_RFIFO_DATA_SHIFT 0
#define  I2C4_TWSI_RFIFO_DATA_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_RFIFO_DATA_MASK) >> I2C4_TWSI_RFIFO_DATA_SHIFT)
#define  I2C4_TWSI_RFIFO_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_RFIFO_DATA_MASK) | (((uint32_t)val) << I2C4_TWSI_RFIFO_DATA_SHIFT))

//====================================================================
//Register: TWSI Read FIFO Write Pointer Register (TWSI_RFIFO_WPTR)
/** \brief The TWSI Read FIFO Write Pointer has the RX FIFO write entry location
information. This is a read/write register. Software can write 0 to it when it
wishes to flush the FIFO after interrupts like Bus error, Arbitration loss, etc.*/
//====================================================================

#define  I2C4_TWSI_RFIFO_WPTR_RESERVED1_MASK 0xffffffe0
#define  I2C4_TWSI_RFIFO_WPTR_RESERVED1_SHIFT 5
#define  I2C4_TWSI_RFIFO_WPTR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_RFIFO_WPTR_RESERVED1_MASK) >> I2C4_TWSI_RFIFO_WPTR_RESERVED1_SHIFT)
#define  I2C4_TWSI_RFIFO_WPTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_RFIFO_WPTR_RESERVED1_MASK) | (((uint32_t)val) << I2C4_TWSI_RFIFO_WPTR_RESERVED1_SHIFT))

#define  I2C4_TWSI_RFIFO_WPTR_DATA_MASK 0x1f
#define  I2C4_TWSI_RFIFO_WPTR_DATA_SHIFT 0
#define  I2C4_TWSI_RFIFO_WPTR_DATA_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_RFIFO_WPTR_DATA_MASK) >> I2C4_TWSI_RFIFO_WPTR_DATA_SHIFT)
#define  I2C4_TWSI_RFIFO_WPTR_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_RFIFO_WPTR_DATA_MASK) | (((uint32_t)val) << I2C4_TWSI_RFIFO_WPTR_DATA_SHIFT))

//====================================================================
//Register: TWSI Read FIFO Read Pointer Register (TWSI_RFIFO_RPTR)
/** \brief The TWSI Read FIFO Read Pointer has the RX FIFO read entry location information.
This is a read/write register. Software can write 0 to it when it wishes to
flush the FIFO after an interrupt.*/
//====================================================================

#define  I2C4_TWSI_RFIFO_RPTR_RESERVED1_MASK 0xffffffe0
#define  I2C4_TWSI_RFIFO_RPTR_RESERVED1_SHIFT 5
#define  I2C4_TWSI_RFIFO_RPTR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_RFIFO_RPTR_RESERVED1_MASK) >> I2C4_TWSI_RFIFO_RPTR_RESERVED1_SHIFT)
#define  I2C4_TWSI_RFIFO_RPTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_RFIFO_RPTR_RESERVED1_MASK) | (((uint32_t)val) << I2C4_TWSI_RFIFO_RPTR_RESERVED1_SHIFT))

#define  I2C4_TWSI_RFIFO_RPTR_DATA_MASK 0x1f
#define  I2C4_TWSI_RFIFO_RPTR_DATA_SHIFT 0
#define  I2C4_TWSI_RFIFO_RPTR_DATA_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_RFIFO_RPTR_DATA_MASK) >> I2C4_TWSI_RFIFO_RPTR_DATA_SHIFT)
#define  I2C4_TWSI_RFIFO_RPTR_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_RFIFO_RPTR_DATA_MASK) | (((uint32_t)val) << I2C4_TWSI_RFIFO_RPTR_DATA_SHIFT))

//====================================================================
//Register: TWSI FIFO Threshold Register (TWSI_FIFO_TSHLD)
/** \brief The FIFO threshold register had the threshold values for TXFIFO and RXFIFO. It
is a read/write register. The default values are 0(empty) for TXFIFO and 8(half
full) for RXFIFO.*/
//====================================================================

#define  I2C4_TWSI_FIFO_TSHLD_RESERVED1_MASK 0xffe00000
#define  I2C4_TWSI_FIFO_TSHLD_RESERVED1_SHIFT 21
#define  I2C4_TWSI_FIFO_TSHLD_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_FIFO_TSHLD_RESERVED1_MASK) >> I2C4_TWSI_FIFO_TSHLD_RESERVED1_SHIFT)
#define  I2C4_TWSI_FIFO_TSHLD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_FIFO_TSHLD_RESERVED1_MASK) | (((uint32_t)val) << I2C4_TWSI_FIFO_TSHLD_RESERVED1_SHIFT))

#define  I2C4_TWSI_FIFO_TSHLD_RX_MASK 0x1f0000
#define  I2C4_TWSI_FIFO_TSHLD_RX_SHIFT 16
#define  I2C4_TWSI_FIFO_TSHLD_RX_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_FIFO_TSHLD_RX_MASK) >> I2C4_TWSI_FIFO_TSHLD_RX_SHIFT)
#define  I2C4_TWSI_FIFO_TSHLD_RX_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_FIFO_TSHLD_RX_MASK) | (((uint32_t)val) << I2C4_TWSI_FIFO_TSHLD_RX_SHIFT))

#define  I2C4_TWSI_FIFO_TSHLD_RESERVED2_MASK 0xffe0
#define  I2C4_TWSI_FIFO_TSHLD_RESERVED2_SHIFT 5
#define  I2C4_TWSI_FIFO_TSHLD_RESERVED2_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_FIFO_TSHLD_RESERVED2_MASK) >> I2C4_TWSI_FIFO_TSHLD_RESERVED2_SHIFT)
#define  I2C4_TWSI_FIFO_TSHLD_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_FIFO_TSHLD_RESERVED2_MASK) | (((uint32_t)val) << I2C4_TWSI_FIFO_TSHLD_RESERVED2_SHIFT))

#define  I2C4_TWSI_FIFO_TSHLD_TX_MASK 0x1f
#define  I2C4_TWSI_FIFO_TSHLD_TX_SHIFT 0
#define  I2C4_TWSI_FIFO_TSHLD_TX_MASK_SHIFT(reg) (((reg) & I2C4_TWSI_FIFO_TSHLD_TX_MASK) >> I2C4_TWSI_FIFO_TSHLD_TX_SHIFT)
#define  I2C4_TWSI_FIFO_TSHLD_TX_REPLACE_VAL(reg,val) (((reg) & ~I2C4_TWSI_FIFO_TSHLD_TX_MASK) | (((uint32_t)val) << I2C4_TWSI_FIFO_TSHLD_TX_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  I2C4_REV0_MAJ_MASK 0xffff0000
#define  I2C4_REV0_MAJ_SHIFT 16
#define  I2C4_REV0_MAJ_MASK_SHIFT(reg) (((reg) & I2C4_REV0_MAJ_MASK) >> I2C4_REV0_MAJ_SHIFT)
#define  I2C4_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~I2C4_REV0_MAJ_MASK) | (((uint32_t)val) << I2C4_REV0_MAJ_SHIFT))

#define  I2C4_REV0_MID_MASK 0xffff
#define  I2C4_REV0_MID_SHIFT 0
#define  I2C4_REV0_MID_MASK_SHIFT(reg) (((reg) & I2C4_REV0_MID_MASK) >> I2C4_REV0_MID_SHIFT)
#define  I2C4_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~I2C4_REV0_MID_MASK) | (((uint32_t)val) << I2C4_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  I2C4_REV1_RESERVED1_MASK 0xffff0000
#define  I2C4_REV1_RESERVED1_SHIFT 16
#define  I2C4_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C4_REV1_RESERVED1_MASK) >> I2C4_REV1_RESERVED1_SHIFT)
#define  I2C4_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C4_REV1_RESERVED1_MASK) | (((uint32_t)val) << I2C4_REV1_RESERVED1_SHIFT))

#define  I2C4_REV1_CFG_MASK 0xffff
#define  I2C4_REV1_CFG_SHIFT 0
#define  I2C4_REV1_CFG_MASK_SHIFT(reg) (((reg) & I2C4_REV1_CFG_MASK) >> I2C4_REV1_CFG_SHIFT)
#define  I2C4_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~I2C4_REV1_CFG_MASK) | (((uint32_t)val) << I2C4_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: I2C5 Registers (I2C5)
//
//====================================================================

//====================================================================
//Register: TWSI Bus Monitor Register (TWSI_IBMR)
/** \brief The TWSI Bus Monitor register (IBMR) tracks the status of the SCL and SDA pins.
The values of these pins are recorded in this read-only IBMR, so software can
determine when the TWSI bus is hung and the TWSI unit must be reset.
This a read-only register. Ignore reads from reserved bits.*/
//====================================================================

#define  I2C5_TWSI_IBMR_RESERVED1_MASK 0xfffffffc
#define  I2C5_TWSI_IBMR_RESERVED1_SHIFT 2
#define  I2C5_TWSI_IBMR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_IBMR_RESERVED1_MASK) >> I2C5_TWSI_IBMR_RESERVED1_SHIFT)
#define  I2C5_TWSI_IBMR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_IBMR_RESERVED1_MASK) | (((uint32_t)val) << I2C5_TWSI_IBMR_RESERVED1_SHIFT))

#define  I2C5_TWSI_IBMR_SCL_MASK 0x2
#define  I2C5_TWSI_IBMR_SCL_SHIFT 1
#define  I2C5_TWSI_IBMR_SCL_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_IBMR_SCL_MASK) >> I2C5_TWSI_IBMR_SCL_SHIFT)
#define  I2C5_TWSI_IBMR_SCL_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_IBMR_SCL_MASK) | (((uint32_t)val) << I2C5_TWSI_IBMR_SCL_SHIFT))

#define  I2C5_TWSI_IBMR_SDA_MASK 0x1
#define  I2C5_TWSI_IBMR_SDA_SHIFT 0
#define  I2C5_TWSI_IBMR_SDA_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_IBMR_SDA_MASK) >> I2C5_TWSI_IBMR_SDA_SHIFT)
#define  I2C5_TWSI_IBMR_SDA_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_IBMR_SDA_MASK) | (((uint32_t)val) << I2C5_TWSI_IBMR_SDA_SHIFT))

//====================================================================
//Register: TWSI Data Buffer Register (TWSI_IDBR)
/** \brief The PXA2128 Application Processor use the TWSI Data Buffer register to transmit
and receive data from the TWSI bus. The IDBR is accessed by the program I/O on
one side and by the TWSI Shift register on the other. The IDBR receives data
coming into the TWSI unit after a full byte is received and acknowledged. The
PXA2128 Application Processor core writes data going out of the TWSI to the IDBR
and sends it to the serial bus.
When the TWSI is in transmit mode (master or slave), the PXA2128 Application
Processor writes data to the IDBR over the internal bus. The PXA2128 Application
Processor write data to the IDBR when a master transaction is initiated or when
the IDBR transmit-empty interrupt is signalled. Data moves from the IDBR to the
Shift register when the transfer byte bit is set. The IDBR transmit-empty
interrupt is signalled (if enabled) when a byte is transferred on the TWSI bus
and the acknowledge cycle is complete. If the IDBR is not written by the PXA2128
Application Processor, and a Stop condition is not in place before the TWSI bus
is ready to transfer the next byte packet, the TWSI unit inserts wait states
until the PXA2128 Application Processor writes the IDBR and sets the transfer
byte bit.
When the TWSI is in receive mode (master or slave), the PXA2128 Application
Processor reads IDBR data over the internal bus. The PXA2128 Application
Processor reads data from the IDBR when the IDBR receive-full interrupt is
signalled. The data moves from the Shift register to the IDBR when the
acknowledge cycle is complete. The TWSI inserts wait states until the IDBR is
read. See Section 12.4.6 for more information on the acknowledge pulse in
receive mode. After the software reads the IDBR, ICR[ACKNAK], and ICR[ACKNAK]
are written by the software, allowing the next byte transfer to proceed to the
TWSI bus.
These are read/write registers. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  I2C5_TWSI_IDBR_RESERVED1_MASK 0xffffff00
#define  I2C5_TWSI_IDBR_RESERVED1_SHIFT 8
#define  I2C5_TWSI_IDBR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_IDBR_RESERVED1_MASK) >> I2C5_TWSI_IDBR_RESERVED1_SHIFT)
#define  I2C5_TWSI_IDBR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_IDBR_RESERVED1_MASK) | (((uint32_t)val) << I2C5_TWSI_IDBR_RESERVED1_SHIFT))

#define  I2C5_TWSI_IDBR_DATA_BUFFER_MASK 0xff
#define  I2C5_TWSI_IDBR_DATA_BUFFER_SHIFT 0
#define  I2C5_TWSI_IDBR_DATA_BUFFER_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_IDBR_DATA_BUFFER_MASK) >> I2C5_TWSI_IDBR_DATA_BUFFER_SHIFT)
#define  I2C5_TWSI_IDBR_DATA_BUFFER_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_IDBR_DATA_BUFFER_MASK) | (((uint32_t)val) << I2C5_TWSI_IDBR_DATA_BUFFER_SHIFT))

//====================================================================
//Register: TWSI Control Register (TWSI_ICR)
/** \brief The PXA2128 Application Processor uses the bits in the TWSI Control register
(ICR) to control the TWSI unit.
These are read/write registers. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  I2C5_TWSI_ICR_RESERVED1_MASK 0x80000000
#define  I2C5_TWSI_ICR_RESERVED1_SHIFT 31
#define  I2C5_TWSI_ICR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_RESERVED1_MASK) >> I2C5_TWSI_ICR_RESERVED1_SHIFT)
#define  I2C5_TWSI_ICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_RESERVED1_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_RESERVED1_SHIFT))

#define  I2C5_TWSI_ICR_SDA_GFE_MASK 0x40000000
#define  I2C5_TWSI_ICR_SDA_GFE_SHIFT 30
#define  I2C5_TWSI_ICR_SDA_GFE_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_SDA_GFE_MASK) >> I2C5_TWSI_ICR_SDA_GFE_SHIFT)
#define  I2C5_TWSI_ICR_SDA_GFE_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_SDA_GFE_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_SDA_GFE_SHIFT))

#define  I2C5_TWSI_ICR_TXOV_IE_MASK 0x20000000
#define  I2C5_TWSI_ICR_TXOV_IE_SHIFT 29
#define  I2C5_TWSI_ICR_TXOV_IE_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_TXOV_IE_MASK) >> I2C5_TWSI_ICR_TXOV_IE_SHIFT)
#define  I2C5_TWSI_ICR_TXOV_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_TXOV_IE_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_TXOV_IE_SHIFT))

#define  I2C5_TWSI_ICR_RXUN_IE_MASK 0x10000000
#define  I2C5_TWSI_ICR_RXUN_IE_SHIFT 28
#define  I2C5_TWSI_ICR_RXUN_IE_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_RXUN_IE_MASK) >> I2C5_TWSI_ICR_RXUN_IE_SHIFT)
#define  I2C5_TWSI_ICR_RXUN_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_RXUN_IE_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_RXUN_IE_SHIFT))

#define  I2C5_TWSI_ICR_DMA_EN_MASK 0x8000000
#define  I2C5_TWSI_ICR_DMA_EN_SHIFT 27
#define  I2C5_TWSI_ICR_DMA_EN_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_DMA_EN_MASK) >> I2C5_TWSI_ICR_DMA_EN_SHIFT)
#define  I2C5_TWSI_ICR_DMA_EN_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_DMA_EN_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_DMA_EN_SHIFT))

#define  I2C5_TWSI_ICR_RXOV_IE_MASK 0x4000000
#define  I2C5_TWSI_ICR_RXOV_IE_SHIFT 26
#define  I2C5_TWSI_ICR_RXOV_IE_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_RXOV_IE_MASK) >> I2C5_TWSI_ICR_RXOV_IE_SHIFT)
#define  I2C5_TWSI_ICR_RXOV_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_RXOV_IE_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_RXOV_IE_SHIFT))

#define  I2C5_TWSI_ICR_RXF_IE_MASK 0x2000000
#define  I2C5_TWSI_ICR_RXF_IE_SHIFT 25
#define  I2C5_TWSI_ICR_RXF_IE_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_RXF_IE_MASK) >> I2C5_TWSI_ICR_RXF_IE_SHIFT)
#define  I2C5_TWSI_ICR_RXF_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_RXF_IE_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_RXF_IE_SHIFT))

#define  I2C5_TWSI_ICR_TXSR_IE_MASK 0x1000000
#define  I2C5_TWSI_ICR_TXSR_IE_SHIFT 24
#define  I2C5_TWSI_ICR_TXSR_IE_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_TXSR_IE_MASK) >> I2C5_TWSI_ICR_TXSR_IE_SHIFT)
#define  I2C5_TWSI_ICR_TXSR_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_TXSR_IE_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_TXSR_IE_SHIFT))

#define  I2C5_TWSI_ICR_RXSR_IE_MASK 0x800000
#define  I2C5_TWSI_ICR_RXSR_IE_SHIFT 23
#define  I2C5_TWSI_ICR_RXSR_IE_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_RXSR_IE_MASK) >> I2C5_TWSI_ICR_RXSR_IE_SHIFT)
#define  I2C5_TWSI_ICR_RXSR_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_RXSR_IE_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_RXSR_IE_SHIFT))

#define  I2C5_TWSI_ICR_TXDONE_IE_MASK 0x400000
#define  I2C5_TWSI_ICR_TXDONE_IE_SHIFT 22
#define  I2C5_TWSI_ICR_TXDONE_IE_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_TXDONE_IE_MASK) >> I2C5_TWSI_ICR_TXDONE_IE_SHIFT)
#define  I2C5_TWSI_ICR_TXDONE_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_TXDONE_IE_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_TXDONE_IE_SHIFT))

#define  I2C5_TWSI_ICR_TXBEGIN_MASK 0x200000
#define  I2C5_TWSI_ICR_TXBEGIN_SHIFT 21
#define  I2C5_TWSI_ICR_TXBEGIN_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_TXBEGIN_MASK) >> I2C5_TWSI_ICR_TXBEGIN_SHIFT)
#define  I2C5_TWSI_ICR_TXBEGIN_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_TXBEGIN_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_TXBEGIN_SHIFT))

#define  I2C5_TWSI_ICR_FIFOEN_MASK 0x100000
#define  I2C5_TWSI_ICR_FIFOEN_SHIFT 20
#define  I2C5_TWSI_ICR_FIFOEN_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_FIFOEN_MASK) >> I2C5_TWSI_ICR_FIFOEN_SHIFT)
#define  I2C5_TWSI_ICR_FIFOEN_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_FIFOEN_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_FIFOEN_SHIFT))

#define  I2C5_TWSI_ICR_GPIOEN_MASK 0x80000
#define  I2C5_TWSI_ICR_GPIOEN_SHIFT 19
#define  I2C5_TWSI_ICR_GPIOEN_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_GPIOEN_MASK) >> I2C5_TWSI_ICR_GPIOEN_SHIFT)
#define  I2C5_TWSI_ICR_GPIOEN_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_GPIOEN_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_GPIOEN_SHIFT))

#define  I2C5_TWSI_ICR_MSDE_MASK 0x40000
#define  I2C5_TWSI_ICR_MSDE_SHIFT 18
#define  I2C5_TWSI_ICR_MSDE_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_MSDE_MASK) >> I2C5_TWSI_ICR_MSDE_SHIFT)
#define  I2C5_TWSI_ICR_MSDE_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_MSDE_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_MSDE_SHIFT))

#define  I2C5_TWSI_ICR_MSDIE_MASK 0x20000
#define  I2C5_TWSI_ICR_MSDIE_SHIFT 17
#define  I2C5_TWSI_ICR_MSDIE_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_MSDIE_MASK) >> I2C5_TWSI_ICR_MSDIE_SHIFT)
#define  I2C5_TWSI_ICR_MSDIE_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_MSDIE_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_MSDIE_SHIFT))

#define  I2C5_TWSI_ICR_MODE_MASK 0x18000
#define  I2C5_TWSI_ICR_MODE_SHIFT 15
#define  I2C5_TWSI_ICR_MODE_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_MODE_MASK) >> I2C5_TWSI_ICR_MODE_SHIFT)
#define  I2C5_TWSI_ICR_MODE_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_MODE_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_MODE_SHIFT))

#define  I2C5_TWSI_ICR_UR_MASK 0x4000
#define  I2C5_TWSI_ICR_UR_SHIFT 14
#define  I2C5_TWSI_ICR_UR_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_UR_MASK) >> I2C5_TWSI_ICR_UR_SHIFT)
#define  I2C5_TWSI_ICR_UR_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_UR_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_UR_SHIFT))

#define  I2C5_TWSI_ICR_SADIE_MASK 0x2000
#define  I2C5_TWSI_ICR_SADIE_SHIFT 13
#define  I2C5_TWSI_ICR_SADIE_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_SADIE_MASK) >> I2C5_TWSI_ICR_SADIE_SHIFT)
#define  I2C5_TWSI_ICR_SADIE_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_SADIE_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_SADIE_SHIFT))

#define  I2C5_TWSI_ICR_ALDIE_MASK 0x1000
#define  I2C5_TWSI_ICR_ALDIE_SHIFT 12
#define  I2C5_TWSI_ICR_ALDIE_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_ALDIE_MASK) >> I2C5_TWSI_ICR_ALDIE_SHIFT)
#define  I2C5_TWSI_ICR_ALDIE_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_ALDIE_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_ALDIE_SHIFT))

#define  I2C5_TWSI_ICR_SSDIE_MASK 0x800
#define  I2C5_TWSI_ICR_SSDIE_SHIFT 11
#define  I2C5_TWSI_ICR_SSDIE_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_SSDIE_MASK) >> I2C5_TWSI_ICR_SSDIE_SHIFT)
#define  I2C5_TWSI_ICR_SSDIE_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_SSDIE_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_SSDIE_SHIFT))

#define  I2C5_TWSI_ICR_BEIE_MASK 0x400
#define  I2C5_TWSI_ICR_BEIE_SHIFT 10
#define  I2C5_TWSI_ICR_BEIE_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_BEIE_MASK) >> I2C5_TWSI_ICR_BEIE_SHIFT)
#define  I2C5_TWSI_ICR_BEIE_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_BEIE_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_BEIE_SHIFT))

#define  I2C5_TWSI_ICR_DRFIE_MASK 0x200
#define  I2C5_TWSI_ICR_DRFIE_SHIFT 9
#define  I2C5_TWSI_ICR_DRFIE_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_DRFIE_MASK) >> I2C5_TWSI_ICR_DRFIE_SHIFT)
#define  I2C5_TWSI_ICR_DRFIE_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_DRFIE_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_DRFIE_SHIFT))

#define  I2C5_TWSI_ICR_ITEIE_MASK 0x100
#define  I2C5_TWSI_ICR_ITEIE_SHIFT 8
#define  I2C5_TWSI_ICR_ITEIE_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_ITEIE_MASK) >> I2C5_TWSI_ICR_ITEIE_SHIFT)
#define  I2C5_TWSI_ICR_ITEIE_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_ITEIE_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_ITEIE_SHIFT))

#define  I2C5_TWSI_ICR_GCD_MASK 0x80
#define  I2C5_TWSI_ICR_GCD_SHIFT 7
#define  I2C5_TWSI_ICR_GCD_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_GCD_MASK) >> I2C5_TWSI_ICR_GCD_SHIFT)
#define  I2C5_TWSI_ICR_GCD_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_GCD_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_GCD_SHIFT))

#define  I2C5_TWSI_ICR_IUE_MASK 0x40
#define  I2C5_TWSI_ICR_IUE_SHIFT 6
#define  I2C5_TWSI_ICR_IUE_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_IUE_MASK) >> I2C5_TWSI_ICR_IUE_SHIFT)
#define  I2C5_TWSI_ICR_IUE_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_IUE_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_IUE_SHIFT))

#define  I2C5_TWSI_ICR_SCLE_MASK 0x20
#define  I2C5_TWSI_ICR_SCLE_SHIFT 5
#define  I2C5_TWSI_ICR_SCLE_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_SCLE_MASK) >> I2C5_TWSI_ICR_SCLE_SHIFT)
#define  I2C5_TWSI_ICR_SCLE_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_SCLE_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_SCLE_SHIFT))

#define  I2C5_TWSI_ICR_MA_MASK 0x10
#define  I2C5_TWSI_ICR_MA_SHIFT 4
#define  I2C5_TWSI_ICR_MA_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_MA_MASK) >> I2C5_TWSI_ICR_MA_SHIFT)
#define  I2C5_TWSI_ICR_MA_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_MA_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_MA_SHIFT))

#define  I2C5_TWSI_ICR_TB_MASK 0x8
#define  I2C5_TWSI_ICR_TB_SHIFT 3
#define  I2C5_TWSI_ICR_TB_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_TB_MASK) >> I2C5_TWSI_ICR_TB_SHIFT)
#define  I2C5_TWSI_ICR_TB_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_TB_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_TB_SHIFT))

#define  I2C5_TWSI_ICR_ACKNAK_MASK 0x4
#define  I2C5_TWSI_ICR_ACKNAK_SHIFT 2
#define  I2C5_TWSI_ICR_ACKNAK_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_ACKNAK_MASK) >> I2C5_TWSI_ICR_ACKNAK_SHIFT)
#define  I2C5_TWSI_ICR_ACKNAK_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_ACKNAK_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_ACKNAK_SHIFT))

#define  I2C5_TWSI_ICR_STOP_MASK 0x2
#define  I2C5_TWSI_ICR_STOP_SHIFT 1
#define  I2C5_TWSI_ICR_STOP_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_STOP_MASK) >> I2C5_TWSI_ICR_STOP_SHIFT)
#define  I2C5_TWSI_ICR_STOP_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_STOP_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_STOP_SHIFT))

#define  I2C5_TWSI_ICR_START_MASK 0x1
#define  I2C5_TWSI_ICR_START_SHIFT 0
#define  I2C5_TWSI_ICR_START_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ICR_START_MASK) >> I2C5_TWSI_ICR_START_SHIFT)
#define  I2C5_TWSI_ICR_START_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ICR_START_MASK) | (((uint32_t)val) << I2C5_TWSI_ICR_START_SHIFT))

//====================================================================
//Register: TWSI Status Register (TWSI_ISR)
/** \brief TWSI interrupts are signalled to the PXA2128 Application Processor interrupt
controller by the TWSI Interrupt Status register. Software uses the ISR bits to
check the status of the TWSI unit and bus. ISR bits (bits 9-5) are updated after
the ACK/NAK bit has completed on the TWSI bus.
The ISR is also used to clear interrupts signalled from the TWSI bus interface
unit, and include the following:
- IDBR receive full
- IDBR transmit empty
- Slave address detected
- Bus error detected
- Stop condition detect
- Arbitration lost
- The TWSI has transmitted a STOP signal when configured as a master
- Transaction is done
- Receive FIFO threshold reached
- Transmit FIFO threshold reached
- Receive FIFO is full
- Receive FIFO overrun happened
- Receive FIFO underrun happened
- Transmit FIFO overrun happened*/
//====================================================================

#define  I2C5_TWSI_ISR_RESERVED1_MASK 0xfff00000
#define  I2C5_TWSI_ISR_RESERVED1_SHIFT 20
#define  I2C5_TWSI_ISR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ISR_RESERVED1_MASK) >> I2C5_TWSI_ISR_RESERVED1_SHIFT)
#define  I2C5_TWSI_ISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ISR_RESERVED1_MASK) | (((uint32_t)val) << I2C5_TWSI_ISR_RESERVED1_SHIFT))

#define  I2C5_TWSI_ISR_TXOV_MASK 0x80000
#define  I2C5_TWSI_ISR_TXOV_SHIFT 19
#define  I2C5_TWSI_ISR_TXOV_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ISR_TXOV_MASK) >> I2C5_TWSI_ISR_TXOV_SHIFT)
#define  I2C5_TWSI_ISR_TXOV_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ISR_TXOV_MASK) | (((uint32_t)val) << I2C5_TWSI_ISR_TXOV_SHIFT))

#define  I2C5_TWSI_ISR_RXUN_MASK 0x40000
#define  I2C5_TWSI_ISR_RXUN_SHIFT 18
#define  I2C5_TWSI_ISR_RXUN_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ISR_RXUN_MASK) >> I2C5_TWSI_ISR_RXUN_SHIFT)
#define  I2C5_TWSI_ISR_RXUN_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ISR_RXUN_MASK) | (((uint32_t)val) << I2C5_TWSI_ISR_RXUN_SHIFT))

#define  I2C5_TWSI_ISR_RXOV_MASK 0x20000
#define  I2C5_TWSI_ISR_RXOV_SHIFT 17
#define  I2C5_TWSI_ISR_RXOV_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ISR_RXOV_MASK) >> I2C5_TWSI_ISR_RXOV_SHIFT)
#define  I2C5_TWSI_ISR_RXOV_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ISR_RXOV_MASK) | (((uint32_t)val) << I2C5_TWSI_ISR_RXOV_SHIFT))

#define  I2C5_TWSI_ISR_RXF_MASK 0x10000
#define  I2C5_TWSI_ISR_RXF_SHIFT 16
#define  I2C5_TWSI_ISR_RXF_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ISR_RXF_MASK) >> I2C5_TWSI_ISR_RXF_SHIFT)
#define  I2C5_TWSI_ISR_RXF_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ISR_RXF_MASK) | (((uint32_t)val) << I2C5_TWSI_ISR_RXF_SHIFT))

#define  I2C5_TWSI_ISR_TXSR_MASK 0x8000
#define  I2C5_TWSI_ISR_TXSR_SHIFT 15
#define  I2C5_TWSI_ISR_TXSR_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ISR_TXSR_MASK) >> I2C5_TWSI_ISR_TXSR_SHIFT)
#define  I2C5_TWSI_ISR_TXSR_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ISR_TXSR_MASK) | (((uint32_t)val) << I2C5_TWSI_ISR_TXSR_SHIFT))

#define  I2C5_TWSI_ISR_RXSR_MASK 0x4000
#define  I2C5_TWSI_ISR_RXSR_SHIFT 14
#define  I2C5_TWSI_ISR_RXSR_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ISR_RXSR_MASK) >> I2C5_TWSI_ISR_RXSR_SHIFT)
#define  I2C5_TWSI_ISR_RXSR_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ISR_RXSR_MASK) | (((uint32_t)val) << I2C5_TWSI_ISR_RXSR_SHIFT))

#define  I2C5_TWSI_ISR_TXDONE_MASK 0x2000
#define  I2C5_TWSI_ISR_TXDONE_SHIFT 13
#define  I2C5_TWSI_ISR_TXDONE_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ISR_TXDONE_MASK) >> I2C5_TWSI_ISR_TXDONE_SHIFT)
#define  I2C5_TWSI_ISR_TXDONE_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ISR_TXDONE_MASK) | (((uint32_t)val) << I2C5_TWSI_ISR_TXDONE_SHIFT))

#define  I2C5_TWSI_ISR_MSD_MASK 0x1000
#define  I2C5_TWSI_ISR_MSD_SHIFT 12
#define  I2C5_TWSI_ISR_MSD_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ISR_MSD_MASK) >> I2C5_TWSI_ISR_MSD_SHIFT)
#define  I2C5_TWSI_ISR_MSD_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ISR_MSD_MASK) | (((uint32_t)val) << I2C5_TWSI_ISR_MSD_SHIFT))

#define  I2C5_TWSI_ISR_EBB_MASK 0x800
#define  I2C5_TWSI_ISR_EBB_SHIFT 11
#define  I2C5_TWSI_ISR_EBB_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ISR_EBB_MASK) >> I2C5_TWSI_ISR_EBB_SHIFT)
#define  I2C5_TWSI_ISR_EBB_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ISR_EBB_MASK) | (((uint32_t)val) << I2C5_TWSI_ISR_EBB_SHIFT))

#define  I2C5_TWSI_ISR_BED_MASK 0x400
#define  I2C5_TWSI_ISR_BED_SHIFT 10
#define  I2C5_TWSI_ISR_BED_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ISR_BED_MASK) >> I2C5_TWSI_ISR_BED_SHIFT)
#define  I2C5_TWSI_ISR_BED_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ISR_BED_MASK) | (((uint32_t)val) << I2C5_TWSI_ISR_BED_SHIFT))

#define  I2C5_TWSI_ISR_SAD_MASK 0x200
#define  I2C5_TWSI_ISR_SAD_SHIFT 9
#define  I2C5_TWSI_ISR_SAD_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ISR_SAD_MASK) >> I2C5_TWSI_ISR_SAD_SHIFT)
#define  I2C5_TWSI_ISR_SAD_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ISR_SAD_MASK) | (((uint32_t)val) << I2C5_TWSI_ISR_SAD_SHIFT))

#define  I2C5_TWSI_ISR_GCAD_MASK 0x100
#define  I2C5_TWSI_ISR_GCAD_SHIFT 8
#define  I2C5_TWSI_ISR_GCAD_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ISR_GCAD_MASK) >> I2C5_TWSI_ISR_GCAD_SHIFT)
#define  I2C5_TWSI_ISR_GCAD_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ISR_GCAD_MASK) | (((uint32_t)val) << I2C5_TWSI_ISR_GCAD_SHIFT))

#define  I2C5_TWSI_ISR_IRF_MASK 0x80
#define  I2C5_TWSI_ISR_IRF_SHIFT 7
#define  I2C5_TWSI_ISR_IRF_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ISR_IRF_MASK) >> I2C5_TWSI_ISR_IRF_SHIFT)
#define  I2C5_TWSI_ISR_IRF_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ISR_IRF_MASK) | (((uint32_t)val) << I2C5_TWSI_ISR_IRF_SHIFT))

#define  I2C5_TWSI_ISR_ITE_MASK 0x40
#define  I2C5_TWSI_ISR_ITE_SHIFT 6
#define  I2C5_TWSI_ISR_ITE_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ISR_ITE_MASK) >> I2C5_TWSI_ISR_ITE_SHIFT)
#define  I2C5_TWSI_ISR_ITE_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ISR_ITE_MASK) | (((uint32_t)val) << I2C5_TWSI_ISR_ITE_SHIFT))

#define  I2C5_TWSI_ISR_ALD_MASK 0x20
#define  I2C5_TWSI_ISR_ALD_SHIFT 5
#define  I2C5_TWSI_ISR_ALD_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ISR_ALD_MASK) >> I2C5_TWSI_ISR_ALD_SHIFT)
#define  I2C5_TWSI_ISR_ALD_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ISR_ALD_MASK) | (((uint32_t)val) << I2C5_TWSI_ISR_ALD_SHIFT))

#define  I2C5_TWSI_ISR_SSD_MASK 0x10
#define  I2C5_TWSI_ISR_SSD_SHIFT 4
#define  I2C5_TWSI_ISR_SSD_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ISR_SSD_MASK) >> I2C5_TWSI_ISR_SSD_SHIFT)
#define  I2C5_TWSI_ISR_SSD_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ISR_SSD_MASK) | (((uint32_t)val) << I2C5_TWSI_ISR_SSD_SHIFT))

#define  I2C5_TWSI_ISR_IBB_MASK 0x8
#define  I2C5_TWSI_ISR_IBB_SHIFT 3
#define  I2C5_TWSI_ISR_IBB_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ISR_IBB_MASK) >> I2C5_TWSI_ISR_IBB_SHIFT)
#define  I2C5_TWSI_ISR_IBB_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ISR_IBB_MASK) | (((uint32_t)val) << I2C5_TWSI_ISR_IBB_SHIFT))

#define  I2C5_TWSI_ISR_UB_MASK 0x4
#define  I2C5_TWSI_ISR_UB_SHIFT 2
#define  I2C5_TWSI_ISR_UB_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ISR_UB_MASK) >> I2C5_TWSI_ISR_UB_SHIFT)
#define  I2C5_TWSI_ISR_UB_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ISR_UB_MASK) | (((uint32_t)val) << I2C5_TWSI_ISR_UB_SHIFT))

#define  I2C5_TWSI_ISR_ACKNAK_MASK 0x2
#define  I2C5_TWSI_ISR_ACKNAK_SHIFT 1
#define  I2C5_TWSI_ISR_ACKNAK_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ISR_ACKNAK_MASK) >> I2C5_TWSI_ISR_ACKNAK_SHIFT)
#define  I2C5_TWSI_ISR_ACKNAK_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ISR_ACKNAK_MASK) | (((uint32_t)val) << I2C5_TWSI_ISR_ACKNAK_SHIFT))

#define  I2C5_TWSI_ISR_RWM_MASK 0x1
#define  I2C5_TWSI_ISR_RWM_SHIFT 0
#define  I2C5_TWSI_ISR_RWM_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ISR_RWM_MASK) >> I2C5_TWSI_ISR_RWM_SHIFT)
#define  I2C5_TWSI_ISR_RWM_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ISR_RWM_MASK) | (((uint32_t)val) << I2C5_TWSI_ISR_RWM_SHIFT))

//====================================================================
//Register: TWSI Slave Address Register (TWSI_ISAR)
/** \brief The ISAR defines the TWSI' s seven-bit slave address. In slave-receive mode, the
PXA2128 Application Processor responds when the seven-bit address matches the
value in this register. The PXA2128 Application Processor writes this register
before it enables TWSI operations. The ISAR is fully programmable (no address is
assigned to the TWSI) so it can be set to a value other than those of hard-wired
TWSI slave peripherals in the system.
These are read/write registers. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  I2C5_TWSI_ISAR_RESERVED1_MASK 0xffffff80
#define  I2C5_TWSI_ISAR_RESERVED1_SHIFT 7
#define  I2C5_TWSI_ISAR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ISAR_RESERVED1_MASK) >> I2C5_TWSI_ISAR_RESERVED1_SHIFT)
#define  I2C5_TWSI_ISAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ISAR_RESERVED1_MASK) | (((uint32_t)val) << I2C5_TWSI_ISAR_RESERVED1_SHIFT))

#define  I2C5_TWSI_ISAR_SLAVE_ADDRESS_MASK 0x7f
#define  I2C5_TWSI_ISAR_SLAVE_ADDRESS_SHIFT 0
#define  I2C5_TWSI_ISAR_SLAVE_ADDRESS_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ISAR_SLAVE_ADDRESS_MASK) >> I2C5_TWSI_ISAR_SLAVE_ADDRESS_SHIFT)
#define  I2C5_TWSI_ISAR_SLAVE_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ISAR_SLAVE_ADDRESS_MASK) | (((uint32_t)val) << I2C5_TWSI_ISAR_SLAVE_ADDRESS_SHIFT))

//====================================================================
//Register: TWSI Load Count Register (TWSI_ILCR)
/** \brief The TWSI must generate the SCL in master mode and the Load Count Monitor
register (ILCR) allows minor adjustments to this clock. The reset value of this
register are determined based on a 32.8 MHz TWSI input clock which allows the
maximum frequency to be derived for Fast (up to 400 Kbps) and Normal mode (up
to 100 Kbps). However, due to frequency restrictions on the TWSI input clock,
the default values of ILCR only generate an SCL than can support up to 1.8 Mbps
for HS mode.
If the alternate 66 MHz TWSI input clock is selected (via writing CCU,
FUNC_CLK_SEL to 'b11 while the TWSI is not enabled), the recommended value of
ILCR to achieve the necessary Fast, Normal and High Speed SCL frequencies
is 32'h 082C_BB56. This register must also be written while the TWSI is not
enabled.
Increasing the load value decreases the SCL frequency, while decreasing the load
raises the frequency. The amount of decrease or increase is equal to one TWSI
clock period for each value.
Note: Reset values also allow the highest possible SCL frequency that still meet
the minimum requirements listed in the TWSI Bus Specification Version 2.1. This
register should be written prior to enabling the TWSI and should not be changed
during bus activity. Writing all zeros to any of the 4 individual Load Values
causes the TWSI to not generate an SCL for that particular mode when the TWSI is
configured as a master. Extreme caution must be exercised when writing this
register.*/
//====================================================================

#define  I2C5_TWSI_ILCR_HLVH_MASK 0xf8000000
#define  I2C5_TWSI_ILCR_HLVH_SHIFT 27
#define  I2C5_TWSI_ILCR_HLVH_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ILCR_HLVH_MASK) >> I2C5_TWSI_ILCR_HLVH_SHIFT)
#define  I2C5_TWSI_ILCR_HLVH_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ILCR_HLVH_MASK) | (((uint32_t)val) << I2C5_TWSI_ILCR_HLVH_SHIFT))

#define  I2C5_TWSI_ILCR_HLVL_MASK 0x7fc0000
#define  I2C5_TWSI_ILCR_HLVL_SHIFT 18
#define  I2C5_TWSI_ILCR_HLVL_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ILCR_HLVL_MASK) >> I2C5_TWSI_ILCR_HLVL_SHIFT)
#define  I2C5_TWSI_ILCR_HLVL_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ILCR_HLVL_MASK) | (((uint32_t)val) << I2C5_TWSI_ILCR_HLVL_SHIFT))

#define  I2C5_TWSI_ILCR_FLV_MASK 0x3fe00
#define  I2C5_TWSI_ILCR_FLV_SHIFT 9
#define  I2C5_TWSI_ILCR_FLV_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ILCR_FLV_MASK) >> I2C5_TWSI_ILCR_FLV_SHIFT)
#define  I2C5_TWSI_ILCR_FLV_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ILCR_FLV_MASK) | (((uint32_t)val) << I2C5_TWSI_ILCR_FLV_SHIFT))

#define  I2C5_TWSI_ILCR_SLV_MASK 0x1ff
#define  I2C5_TWSI_ILCR_SLV_SHIFT 0
#define  I2C5_TWSI_ILCR_SLV_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_ILCR_SLV_MASK) >> I2C5_TWSI_ILCR_SLV_SHIFT)
#define  I2C5_TWSI_ILCR_SLV_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_ILCR_SLV_MASK) | (((uint32_t)val) << I2C5_TWSI_ILCR_SLV_SHIFT))

//====================================================================
//Register: TWSI Wait Count Register (TWSI_IWCR)
/** \brief The TWSI Wait Count register controls the setup and hold times during standard,
fast, or high speed. This register together with the ILCR register control the
setup and hold times for all modes.*/
//====================================================================

#define  I2C5_TWSI_IWCR_RESERVED1_MASK 0xffff8000
#define  I2C5_TWSI_IWCR_RESERVED1_SHIFT 15
#define  I2C5_TWSI_IWCR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_IWCR_RESERVED1_MASK) >> I2C5_TWSI_IWCR_RESERVED1_SHIFT)
#define  I2C5_TWSI_IWCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_IWCR_RESERVED1_MASK) | (((uint32_t)val) << I2C5_TWSI_IWCR_RESERVED1_SHIFT))

#define  I2C5_TWSI_IWCR_HS_COUNT2_MASK 0x7c00
#define  I2C5_TWSI_IWCR_HS_COUNT2_SHIFT 10
#define  I2C5_TWSI_IWCR_HS_COUNT2_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_IWCR_HS_COUNT2_MASK) >> I2C5_TWSI_IWCR_HS_COUNT2_SHIFT)
#define  I2C5_TWSI_IWCR_HS_COUNT2_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_IWCR_HS_COUNT2_MASK) | (((uint32_t)val) << I2C5_TWSI_IWCR_HS_COUNT2_SHIFT))

#define  I2C5_TWSI_IWCR_HS_COUNT1_MASK 0x3e0
#define  I2C5_TWSI_IWCR_HS_COUNT1_SHIFT 5
#define  I2C5_TWSI_IWCR_HS_COUNT1_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_IWCR_HS_COUNT1_MASK) >> I2C5_TWSI_IWCR_HS_COUNT1_SHIFT)
#define  I2C5_TWSI_IWCR_HS_COUNT1_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_IWCR_HS_COUNT1_MASK) | (((uint32_t)val) << I2C5_TWSI_IWCR_HS_COUNT1_SHIFT))

#define  I2C5_TWSI_IWCR_COUNT_MASK 0x1f
#define  I2C5_TWSI_IWCR_COUNT_SHIFT 0
#define  I2C5_TWSI_IWCR_COUNT_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_IWCR_COUNT_MASK) >> I2C5_TWSI_IWCR_COUNT_SHIFT)
#define  I2C5_TWSI_IWCR_COUNT_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_IWCR_COUNT_MASK) | (((uint32_t)val) << I2C5_TWSI_IWCR_COUNT_SHIFT))

//====================================================================
//Register: TWSI Write FIFO Register (TWSI_WFIFO)
/** \brief The TWSI Write FIFO has 16 entries and each entry is 12-bit wide (4-bit control
+ 8-bit data). This FIFO can be filled up in PIO or DMA mode. Whenever this FIFO
threshold is reached, an interrupt or a dma request is generated.*/
//====================================================================

#define  I2C5_TWSI_WFIFO_RESERVED1_MASK 0xfffff000
#define  I2C5_TWSI_WFIFO_RESERVED1_SHIFT 12
#define  I2C5_TWSI_WFIFO_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_WFIFO_RESERVED1_MASK) >> I2C5_TWSI_WFIFO_RESERVED1_SHIFT)
#define  I2C5_TWSI_WFIFO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_WFIFO_RESERVED1_MASK) | (((uint32_t)val) << I2C5_TWSI_WFIFO_RESERVED1_SHIFT))

#define  I2C5_TWSI_WFIFO_CONTROL_MASK 0xf00
#define  I2C5_TWSI_WFIFO_CONTROL_SHIFT 8
#define  I2C5_TWSI_WFIFO_CONTROL_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_WFIFO_CONTROL_MASK) >> I2C5_TWSI_WFIFO_CONTROL_SHIFT)
#define  I2C5_TWSI_WFIFO_CONTROL_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_WFIFO_CONTROL_MASK) | (((uint32_t)val) << I2C5_TWSI_WFIFO_CONTROL_SHIFT))

#define  I2C5_TWSI_WFIFO_DATA_MASK 0xff
#define  I2C5_TWSI_WFIFO_DATA_SHIFT 0
#define  I2C5_TWSI_WFIFO_DATA_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_WFIFO_DATA_MASK) >> I2C5_TWSI_WFIFO_DATA_SHIFT)
#define  I2C5_TWSI_WFIFO_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_WFIFO_DATA_MASK) | (((uint32_t)val) << I2C5_TWSI_WFIFO_DATA_SHIFT))

//====================================================================
//Register: TWSI Write FIFO Write Pointer Register (TWSI_WFIFO_WPTR)
/** \brief The TWSI Write FIFO Pointer has the TX FIFO write entry location information.
This is a read/write register. Software can write 0 to it when it wishes to
flush the FIFO after interrupts like Bus error, Arbitration loss, etc.*/
//====================================================================

#define  I2C5_TWSI_WFIFO_WPTR_RESERVED1_MASK 0xffffffe0
#define  I2C5_TWSI_WFIFO_WPTR_RESERVED1_SHIFT 5
#define  I2C5_TWSI_WFIFO_WPTR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_WFIFO_WPTR_RESERVED1_MASK) >> I2C5_TWSI_WFIFO_WPTR_RESERVED1_SHIFT)
#define  I2C5_TWSI_WFIFO_WPTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_WFIFO_WPTR_RESERVED1_MASK) | (((uint32_t)val) << I2C5_TWSI_WFIFO_WPTR_RESERVED1_SHIFT))

#define  I2C5_TWSI_WFIFO_WPTR_DATA_MASK 0x1f
#define  I2C5_TWSI_WFIFO_WPTR_DATA_SHIFT 0
#define  I2C5_TWSI_WFIFO_WPTR_DATA_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_WFIFO_WPTR_DATA_MASK) >> I2C5_TWSI_WFIFO_WPTR_DATA_SHIFT)
#define  I2C5_TWSI_WFIFO_WPTR_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_WFIFO_WPTR_DATA_MASK) | (((uint32_t)val) << I2C5_TWSI_WFIFO_WPTR_DATA_SHIFT))

//====================================================================
//Register: TWSI Write FIFO Read Pointer Register (TWSI_WFIFO_RPTR)
/** \brief The TWSI Write FIFO Read Pointer has the TX FIFO read entry location
information. This is a read/write register. Software can write 0 to it when it
wishes to flush the FIFO after an interrupt.*/
//====================================================================

#define  I2C5_TWSI_WFIFO_RPTR_RESERVED1_MASK 0xffffffe0
#define  I2C5_TWSI_WFIFO_RPTR_RESERVED1_SHIFT 5
#define  I2C5_TWSI_WFIFO_RPTR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_WFIFO_RPTR_RESERVED1_MASK) >> I2C5_TWSI_WFIFO_RPTR_RESERVED1_SHIFT)
#define  I2C5_TWSI_WFIFO_RPTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_WFIFO_RPTR_RESERVED1_MASK) | (((uint32_t)val) << I2C5_TWSI_WFIFO_RPTR_RESERVED1_SHIFT))

#define  I2C5_TWSI_WFIFO_RPTR_DATA_MASK 0x1f
#define  I2C5_TWSI_WFIFO_RPTR_DATA_SHIFT 0
#define  I2C5_TWSI_WFIFO_RPTR_DATA_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_WFIFO_RPTR_DATA_MASK) >> I2C5_TWSI_WFIFO_RPTR_DATA_SHIFT)
#define  I2C5_TWSI_WFIFO_RPTR_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_WFIFO_RPTR_DATA_MASK) | (((uint32_t)val) << I2C5_TWSI_WFIFO_RPTR_DATA_SHIFT))

//====================================================================
//Register: TWSI Read FIFO Register (TWSI_RFIFO)
/** \brief The TWSI Read FIFO has 16 entries and each entry is 8-bit wide (8-bit data).
This FIFO can be emptied in PIO or DMA mode. Whenever this FIFO is half full, an
interrupt or a dma request is generated.*/
//====================================================================

#define  I2C5_TWSI_RFIFO_RESERVED1_MASK 0xffffff00
#define  I2C5_TWSI_RFIFO_RESERVED1_SHIFT 8
#define  I2C5_TWSI_RFIFO_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_RFIFO_RESERVED1_MASK) >> I2C5_TWSI_RFIFO_RESERVED1_SHIFT)
#define  I2C5_TWSI_RFIFO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_RFIFO_RESERVED1_MASK) | (((uint32_t)val) << I2C5_TWSI_RFIFO_RESERVED1_SHIFT))

#define  I2C5_TWSI_RFIFO_DATA_MASK 0xff
#define  I2C5_TWSI_RFIFO_DATA_SHIFT 0
#define  I2C5_TWSI_RFIFO_DATA_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_RFIFO_DATA_MASK) >> I2C5_TWSI_RFIFO_DATA_SHIFT)
#define  I2C5_TWSI_RFIFO_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_RFIFO_DATA_MASK) | (((uint32_t)val) << I2C5_TWSI_RFIFO_DATA_SHIFT))

//====================================================================
//Register: TWSI Read FIFO Write Pointer Register (TWSI_RFIFO_WPTR)
/** \brief The TWSI Read FIFO Write Pointer has the RX FIFO write entry location
information. This is a read/write register. Software can write 0 to it when it
wishes to flush the FIFO after interrupts like Bus error, Arbitration loss, etc.*/
//====================================================================

#define  I2C5_TWSI_RFIFO_WPTR_RESERVED1_MASK 0xffffffe0
#define  I2C5_TWSI_RFIFO_WPTR_RESERVED1_SHIFT 5
#define  I2C5_TWSI_RFIFO_WPTR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_RFIFO_WPTR_RESERVED1_MASK) >> I2C5_TWSI_RFIFO_WPTR_RESERVED1_SHIFT)
#define  I2C5_TWSI_RFIFO_WPTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_RFIFO_WPTR_RESERVED1_MASK) | (((uint32_t)val) << I2C5_TWSI_RFIFO_WPTR_RESERVED1_SHIFT))

#define  I2C5_TWSI_RFIFO_WPTR_DATA_MASK 0x1f
#define  I2C5_TWSI_RFIFO_WPTR_DATA_SHIFT 0
#define  I2C5_TWSI_RFIFO_WPTR_DATA_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_RFIFO_WPTR_DATA_MASK) >> I2C5_TWSI_RFIFO_WPTR_DATA_SHIFT)
#define  I2C5_TWSI_RFIFO_WPTR_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_RFIFO_WPTR_DATA_MASK) | (((uint32_t)val) << I2C5_TWSI_RFIFO_WPTR_DATA_SHIFT))

//====================================================================
//Register: TWSI Read FIFO Read Pointer Register (TWSI_RFIFO_RPTR)
/** \brief The TWSI Read FIFO Read Pointer has the RX FIFO read entry location information.
This is a read/write register. Software can write 0 to it when it wishes to
flush the FIFO after an interrupt.*/
//====================================================================

#define  I2C5_TWSI_RFIFO_RPTR_RESERVED1_MASK 0xffffffe0
#define  I2C5_TWSI_RFIFO_RPTR_RESERVED1_SHIFT 5
#define  I2C5_TWSI_RFIFO_RPTR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_RFIFO_RPTR_RESERVED1_MASK) >> I2C5_TWSI_RFIFO_RPTR_RESERVED1_SHIFT)
#define  I2C5_TWSI_RFIFO_RPTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_RFIFO_RPTR_RESERVED1_MASK) | (((uint32_t)val) << I2C5_TWSI_RFIFO_RPTR_RESERVED1_SHIFT))

#define  I2C5_TWSI_RFIFO_RPTR_DATA_MASK 0x1f
#define  I2C5_TWSI_RFIFO_RPTR_DATA_SHIFT 0
#define  I2C5_TWSI_RFIFO_RPTR_DATA_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_RFIFO_RPTR_DATA_MASK) >> I2C5_TWSI_RFIFO_RPTR_DATA_SHIFT)
#define  I2C5_TWSI_RFIFO_RPTR_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_RFIFO_RPTR_DATA_MASK) | (((uint32_t)val) << I2C5_TWSI_RFIFO_RPTR_DATA_SHIFT))

//====================================================================
//Register: TWSI FIFO Threshold Register (TWSI_FIFO_TSHLD)
/** \brief The FIFO threshold register had the threshold values for TXFIFO and RXFIFO. It
is a read/write register. The default values are 0(empty) for TXFIFO and 8(half
full) for RXFIFO.*/
//====================================================================

#define  I2C5_TWSI_FIFO_TSHLD_RESERVED1_MASK 0xffe00000
#define  I2C5_TWSI_FIFO_TSHLD_RESERVED1_SHIFT 21
#define  I2C5_TWSI_FIFO_TSHLD_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_FIFO_TSHLD_RESERVED1_MASK) >> I2C5_TWSI_FIFO_TSHLD_RESERVED1_SHIFT)
#define  I2C5_TWSI_FIFO_TSHLD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_FIFO_TSHLD_RESERVED1_MASK) | (((uint32_t)val) << I2C5_TWSI_FIFO_TSHLD_RESERVED1_SHIFT))

#define  I2C5_TWSI_FIFO_TSHLD_RX_MASK 0x1f0000
#define  I2C5_TWSI_FIFO_TSHLD_RX_SHIFT 16
#define  I2C5_TWSI_FIFO_TSHLD_RX_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_FIFO_TSHLD_RX_MASK) >> I2C5_TWSI_FIFO_TSHLD_RX_SHIFT)
#define  I2C5_TWSI_FIFO_TSHLD_RX_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_FIFO_TSHLD_RX_MASK) | (((uint32_t)val) << I2C5_TWSI_FIFO_TSHLD_RX_SHIFT))

#define  I2C5_TWSI_FIFO_TSHLD_RESERVED2_MASK 0xffe0
#define  I2C5_TWSI_FIFO_TSHLD_RESERVED2_SHIFT 5
#define  I2C5_TWSI_FIFO_TSHLD_RESERVED2_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_FIFO_TSHLD_RESERVED2_MASK) >> I2C5_TWSI_FIFO_TSHLD_RESERVED2_SHIFT)
#define  I2C5_TWSI_FIFO_TSHLD_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_FIFO_TSHLD_RESERVED2_MASK) | (((uint32_t)val) << I2C5_TWSI_FIFO_TSHLD_RESERVED2_SHIFT))

#define  I2C5_TWSI_FIFO_TSHLD_TX_MASK 0x1f
#define  I2C5_TWSI_FIFO_TSHLD_TX_SHIFT 0
#define  I2C5_TWSI_FIFO_TSHLD_TX_MASK_SHIFT(reg) (((reg) & I2C5_TWSI_FIFO_TSHLD_TX_MASK) >> I2C5_TWSI_FIFO_TSHLD_TX_SHIFT)
#define  I2C5_TWSI_FIFO_TSHLD_TX_REPLACE_VAL(reg,val) (((reg) & ~I2C5_TWSI_FIFO_TSHLD_TX_MASK) | (((uint32_t)val) << I2C5_TWSI_FIFO_TSHLD_TX_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  I2C5_REV0_MAJ_MASK 0xffff0000
#define  I2C5_REV0_MAJ_SHIFT 16
#define  I2C5_REV0_MAJ_MASK_SHIFT(reg) (((reg) & I2C5_REV0_MAJ_MASK) >> I2C5_REV0_MAJ_SHIFT)
#define  I2C5_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~I2C5_REV0_MAJ_MASK) | (((uint32_t)val) << I2C5_REV0_MAJ_SHIFT))

#define  I2C5_REV0_MID_MASK 0xffff
#define  I2C5_REV0_MID_SHIFT 0
#define  I2C5_REV0_MID_MASK_SHIFT(reg) (((reg) & I2C5_REV0_MID_MASK) >> I2C5_REV0_MID_SHIFT)
#define  I2C5_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~I2C5_REV0_MID_MASK) | (((uint32_t)val) << I2C5_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  I2C5_REV1_RESERVED1_MASK 0xffff0000
#define  I2C5_REV1_RESERVED1_SHIFT 16
#define  I2C5_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C5_REV1_RESERVED1_MASK) >> I2C5_REV1_RESERVED1_SHIFT)
#define  I2C5_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C5_REV1_RESERVED1_MASK) | (((uint32_t)val) << I2C5_REV1_RESERVED1_SHIFT))

#define  I2C5_REV1_CFG_MASK 0xffff
#define  I2C5_REV1_CFG_SHIFT 0
#define  I2C5_REV1_CFG_MASK_SHIFT(reg) (((reg) & I2C5_REV1_CFG_MASK) >> I2C5_REV1_CFG_SHIFT)
#define  I2C5_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~I2C5_REV1_CFG_MASK) | (((uint32_t)val) << I2C5_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: SSP Registers (Instance 1 of 3) (SSP0)
//
//====================================================================

//====================================================================
//Register: SSP Control Register 0 (SSP_SSCR0)
/** \brief These registers contain bit fields that control various functions within the SSP
port. The following table shows the bit locations corresponding to the different
control bit fields within the SSP Control 0 Register. The reset state of all
bits are as shown, but they must be programmed to their preferred values before
enabling the SSP port.
Writes to reserved bits must be 0x0, and read values of reserved bits are
undefined.*/
//====================================================================

#define  SSP0_SSP_SSCR0_MOD_MASK 0x80000000
#define  SSP0_SSP_SSCR0_MOD_SHIFT 31
#define  SSP0_SSP_SSCR0_MOD_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR0_MOD_MASK) >> SSP0_SSP_SSCR0_MOD_SHIFT)
#define  SSP0_SSP_SSCR0_MOD_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR0_MOD_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR0_MOD_SHIFT))

#define  SSP0_SSP_SSCR0_RESERVED1_MASK 0x40000000
#define  SSP0_SSP_SSCR0_RESERVED1_SHIFT 30
#define  SSP0_SSP_SSCR0_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR0_RESERVED1_MASK) >> SSP0_SSP_SSCR0_RESERVED1_SHIFT)
#define  SSP0_SSP_SSCR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR0_RESERVED1_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR0_RESERVED1_SHIFT))

#define  SSP0_SSP_SSCR0_FPCKE_MASK 0x20000000
#define  SSP0_SSP_SSCR0_FPCKE_SHIFT 29
#define  SSP0_SSP_SSCR0_FPCKE_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR0_FPCKE_MASK) >> SSP0_SSP_SSCR0_FPCKE_SHIFT)
#define  SSP0_SSP_SSCR0_FPCKE_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR0_FPCKE_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR0_FPCKE_SHIFT))

#define  SSP0_SSP_SSCR0_FCTRL_MASK 0x10000000
#define  SSP0_SSP_SSCR0_FCTRL_SHIFT 28
#define  SSP0_SSP_SSCR0_FCTRL_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR0_FCTRL_MASK) >> SSP0_SSP_SSCR0_FCTRL_SHIFT)
#define  SSP0_SSP_SSCR0_FCTRL_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR0_FCTRL_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR0_FCTRL_SHIFT))

#define  SSP0_SSP_SSCR0_RESERVED2_MASK 0x8000000
#define  SSP0_SSP_SSCR0_RESERVED2_SHIFT 27
#define  SSP0_SSP_SSCR0_RESERVED2_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR0_RESERVED2_MASK) >> SSP0_SSP_SSCR0_RESERVED2_SHIFT)
#define  SSP0_SSP_SSCR0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR0_RESERVED2_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR0_RESERVED2_SHIFT))

#define  SSP0_SSP_SSCR0_FRDC_MASK 0x7000000
#define  SSP0_SSP_SSCR0_FRDC_SHIFT 24
#define  SSP0_SSP_SSCR0_FRDC_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR0_FRDC_MASK) >> SSP0_SSP_SSCR0_FRDC_SHIFT)
#define  SSP0_SSP_SSCR0_FRDC_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR0_FRDC_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR0_FRDC_SHIFT))

#define  SSP0_SSP_SSCR0_TIM_MASK 0x800000
#define  SSP0_SSP_SSCR0_TIM_SHIFT 23
#define  SSP0_SSP_SSCR0_TIM_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR0_TIM_MASK) >> SSP0_SSP_SSCR0_TIM_SHIFT)
#define  SSP0_SSP_SSCR0_TIM_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR0_TIM_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR0_TIM_SHIFT))

#define  SSP0_SSP_SSCR0_RIM_MASK 0x400000
#define  SSP0_SSP_SSCR0_RIM_SHIFT 22
#define  SSP0_SSP_SSCR0_RIM_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR0_RIM_MASK) >> SSP0_SSP_SSCR0_RIM_SHIFT)
#define  SSP0_SSP_SSCR0_RIM_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR0_RIM_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR0_RIM_SHIFT))

#define  SSP0_SSP_SSCR0_RESERVED3_MASK 0x200000
#define  SSP0_SSP_SSCR0_RESERVED3_SHIFT 21
#define  SSP0_SSP_SSCR0_RESERVED3_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR0_RESERVED3_MASK) >> SSP0_SSP_SSCR0_RESERVED3_SHIFT)
#define  SSP0_SSP_SSCR0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR0_RESERVED3_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR0_RESERVED3_SHIFT))

#define  SSP0_SSP_SSCR0_EDSS_MASK 0x100000
#define  SSP0_SSP_SSCR0_EDSS_SHIFT 20
#define  SSP0_SSP_SSCR0_EDSS_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR0_EDSS_MASK) >> SSP0_SSP_SSCR0_EDSS_SHIFT)
#define  SSP0_SSP_SSCR0_EDSS_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR0_EDSS_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR0_EDSS_SHIFT))

#define  SSP0_SSP_SSCR0_RESERVED4_MASK 0xfff00
#define  SSP0_SSP_SSCR0_RESERVED4_SHIFT 8
#define  SSP0_SSP_SSCR0_RESERVED4_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR0_RESERVED4_MASK) >> SSP0_SSP_SSCR0_RESERVED4_SHIFT)
#define  SSP0_SSP_SSCR0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR0_RESERVED4_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR0_RESERVED4_SHIFT))

#define  SSP0_SSP_SSCR0_SSE_MASK 0x80
#define  SSP0_SSP_SSCR0_SSE_SHIFT 7
#define  SSP0_SSP_SSCR0_SSE_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR0_SSE_MASK) >> SSP0_SSP_SSCR0_SSE_SHIFT)
#define  SSP0_SSP_SSCR0_SSE_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR0_SSE_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR0_SSE_SHIFT))

#define  SSP0_SSP_SSCR0_RESERVED5_MASK 0x40
#define  SSP0_SSP_SSCR0_RESERVED5_SHIFT 6
#define  SSP0_SSP_SSCR0_RESERVED5_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR0_RESERVED5_MASK) >> SSP0_SSP_SSCR0_RESERVED5_SHIFT)
#define  SSP0_SSP_SSCR0_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR0_RESERVED5_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR0_RESERVED5_SHIFT))

#define  SSP0_SSP_SSCR0_FRF_MASK 0x30
#define  SSP0_SSP_SSCR0_FRF_SHIFT 4
#define  SSP0_SSP_SSCR0_FRF_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR0_FRF_MASK) >> SSP0_SSP_SSCR0_FRF_SHIFT)
#define  SSP0_SSP_SSCR0_FRF_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR0_FRF_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR0_FRF_SHIFT))

#define  SSP0_SSP_SSCR0_DSS_MASK 0xf
#define  SSP0_SSP_SSCR0_DSS_SHIFT 0
#define  SSP0_SSP_SSCR0_DSS_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR0_DSS_MASK) >> SSP0_SSP_SSCR0_DSS_SHIFT)
#define  SSP0_SSP_SSCR0_DSS_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR0_DSS_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR0_DSS_SHIFT))

//====================================================================
//Register: SSP Control Register 1 (SSP_SSCR1)
/** \brief These registers contain bit fields that control various SSP port functions. The
following table shows bit locations corresponding to control bit fields in
SSP_SSCR1. The reset state of all bits is shown, but must be set to the
preferred value before enabling the SSP port by setting the <Synchronous Serial
Port Enable> field in the SSP Control Register 0.
Write 0x0 to reserved bits, the read values of reserved bits are undetermined.*/
//====================================================================

#define  SSP0_SSP_SSCR1_TTELP_MASK 0x80000000
#define  SSP0_SSP_SSCR1_TTELP_SHIFT 31
#define  SSP0_SSP_SSCR1_TTELP_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_TTELP_MASK) >> SSP0_SSP_SSCR1_TTELP_SHIFT)
#define  SSP0_SSP_SSCR1_TTELP_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_TTELP_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_TTELP_SHIFT))

#define  SSP0_SSP_SSCR1_TTE_MASK 0x40000000
#define  SSP0_SSP_SSCR1_TTE_SHIFT 30
#define  SSP0_SSP_SSCR1_TTE_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_TTE_MASK) >> SSP0_SSP_SSCR1_TTE_SHIFT)
#define  SSP0_SSP_SSCR1_TTE_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_TTE_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_TTE_SHIFT))

#define  SSP0_SSP_SSCR1_EBCEI_MASK 0x20000000
#define  SSP0_SSP_SSCR1_EBCEI_SHIFT 29
#define  SSP0_SSP_SSCR1_EBCEI_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_EBCEI_MASK) >> SSP0_SSP_SSCR1_EBCEI_SHIFT)
#define  SSP0_SSP_SSCR1_EBCEI_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_EBCEI_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_EBCEI_SHIFT))

#define  SSP0_SSP_SSCR1_SCFR_MASK 0x10000000
#define  SSP0_SSP_SSCR1_SCFR_SHIFT 28
#define  SSP0_SSP_SSCR1_SCFR_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_SCFR_MASK) >> SSP0_SSP_SSCR1_SCFR_SHIFT)
#define  SSP0_SSP_SSCR1_SCFR_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_SCFR_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_SCFR_SHIFT))

#define  SSP0_SSP_SSCR1_ECRA_MASK 0x8000000
#define  SSP0_SSP_SSCR1_ECRA_SHIFT 27
#define  SSP0_SSP_SSCR1_ECRA_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_ECRA_MASK) >> SSP0_SSP_SSCR1_ECRA_SHIFT)
#define  SSP0_SSP_SSCR1_ECRA_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_ECRA_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_ECRA_SHIFT))

#define  SSP0_SSP_SSCR1_ECRB_MASK 0x4000000
#define  SSP0_SSP_SSCR1_ECRB_SHIFT 26
#define  SSP0_SSP_SSCR1_ECRB_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_ECRB_MASK) >> SSP0_SSP_SSCR1_ECRB_SHIFT)
#define  SSP0_SSP_SSCR1_ECRB_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_ECRB_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_ECRB_SHIFT))

#define  SSP0_SSP_SSCR1_SCLKDIR_MASK 0x2000000
#define  SSP0_SSP_SSCR1_SCLKDIR_SHIFT 25
#define  SSP0_SSP_SSCR1_SCLKDIR_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_SCLKDIR_MASK) >> SSP0_SSP_SSCR1_SCLKDIR_SHIFT)
#define  SSP0_SSP_SSCR1_SCLKDIR_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_SCLKDIR_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_SCLKDIR_SHIFT))

#define  SSP0_SSP_SSCR1_SFRMDIR_MASK 0x1000000
#define  SSP0_SSP_SSCR1_SFRMDIR_SHIFT 24
#define  SSP0_SSP_SSCR1_SFRMDIR_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_SFRMDIR_MASK) >> SSP0_SSP_SSCR1_SFRMDIR_SHIFT)
#define  SSP0_SSP_SSCR1_SFRMDIR_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_SFRMDIR_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_SFRMDIR_SHIFT))

#define  SSP0_SSP_SSCR1_RWOT_MASK 0x800000
#define  SSP0_SSP_SSCR1_RWOT_SHIFT 23
#define  SSP0_SSP_SSCR1_RWOT_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_RWOT_MASK) >> SSP0_SSP_SSCR1_RWOT_SHIFT)
#define  SSP0_SSP_SSCR1_RWOT_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_RWOT_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_RWOT_SHIFT))

#define  SSP0_SSP_SSCR1_TRAIL_MASK 0x400000
#define  SSP0_SSP_SSCR1_TRAIL_SHIFT 22
#define  SSP0_SSP_SSCR1_TRAIL_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_TRAIL_MASK) >> SSP0_SSP_SSCR1_TRAIL_SHIFT)
#define  SSP0_SSP_SSCR1_TRAIL_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_TRAIL_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_TRAIL_SHIFT))

#define  SSP0_SSP_SSCR1_TSRE_MASK 0x200000
#define  SSP0_SSP_SSCR1_TSRE_SHIFT 21
#define  SSP0_SSP_SSCR1_TSRE_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_TSRE_MASK) >> SSP0_SSP_SSCR1_TSRE_SHIFT)
#define  SSP0_SSP_SSCR1_TSRE_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_TSRE_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_TSRE_SHIFT))

#define  SSP0_SSP_SSCR1_RSRE_MASK 0x100000
#define  SSP0_SSP_SSCR1_RSRE_SHIFT 20
#define  SSP0_SSP_SSCR1_RSRE_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_RSRE_MASK) >> SSP0_SSP_SSCR1_RSRE_SHIFT)
#define  SSP0_SSP_SSCR1_RSRE_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_RSRE_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_RSRE_SHIFT))

#define  SSP0_SSP_SSCR1_TINTE_MASK 0x80000
#define  SSP0_SSP_SSCR1_TINTE_SHIFT 19
#define  SSP0_SSP_SSCR1_TINTE_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_TINTE_MASK) >> SSP0_SSP_SSCR1_TINTE_SHIFT)
#define  SSP0_SSP_SSCR1_TINTE_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_TINTE_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_TINTE_SHIFT))

#define  SSP0_SSP_SSCR1_PINTE_MASK 0x40000
#define  SSP0_SSP_SSCR1_PINTE_SHIFT 18
#define  SSP0_SSP_SSCR1_PINTE_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_PINTE_MASK) >> SSP0_SSP_SSCR1_PINTE_SHIFT)
#define  SSP0_SSP_SSCR1_PINTE_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_PINTE_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_PINTE_SHIFT))

#define  SSP0_SSP_SSCR1_FEN_MASK 0x20000
#define  SSP0_SSP_SSCR1_FEN_SHIFT 17
#define  SSP0_SSP_SSCR1_FEN_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_FEN_MASK) >> SSP0_SSP_SSCR1_FEN_SHIFT)
#define  SSP0_SSP_SSCR1_FEN_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_FEN_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_FEN_SHIFT))

#define  SSP0_SSP_SSCR1_IFS_MASK 0x10000
#define  SSP0_SSP_SSCR1_IFS_SHIFT 16
#define  SSP0_SSP_SSCR1_IFS_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_IFS_MASK) >> SSP0_SSP_SSCR1_IFS_SHIFT)
#define  SSP0_SSP_SSCR1_IFS_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_IFS_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_IFS_SHIFT))

#define  SSP0_SSP_SSCR1_STRF_MASK 0x8000
#define  SSP0_SSP_SSCR1_STRF_SHIFT 15
#define  SSP0_SSP_SSCR1_STRF_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_STRF_MASK) >> SSP0_SSP_SSCR1_STRF_SHIFT)
#define  SSP0_SSP_SSCR1_STRF_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_STRF_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_STRF_SHIFT))

#define  SSP0_SSP_SSCR1_EFWR_MASK 0x4000
#define  SSP0_SSP_SSCR1_EFWR_SHIFT 14
#define  SSP0_SSP_SSCR1_EFWR_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_EFWR_MASK) >> SSP0_SSP_SSCR1_EFWR_SHIFT)
#define  SSP0_SSP_SSCR1_EFWR_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_EFWR_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_EFWR_SHIFT))

#define  SSP0_SSP_SSCR1_RFT_MASK 0x3c00
#define  SSP0_SSP_SSCR1_RFT_SHIFT 10
#define  SSP0_SSP_SSCR1_RFT_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_RFT_MASK) >> SSP0_SSP_SSCR1_RFT_SHIFT)
#define  SSP0_SSP_SSCR1_RFT_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_RFT_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_RFT_SHIFT))

#define  SSP0_SSP_SSCR1_TFT_MASK 0x3c0
#define  SSP0_SSP_SSCR1_TFT_SHIFT 6
#define  SSP0_SSP_SSCR1_TFT_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_TFT_MASK) >> SSP0_SSP_SSCR1_TFT_SHIFT)
#define  SSP0_SSP_SSCR1_TFT_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_TFT_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_TFT_SHIFT))

#define  SSP0_SSP_SSCR1_MWDS_MASK 0x20
#define  SSP0_SSP_SSCR1_MWDS_SHIFT 5
#define  SSP0_SSP_SSCR1_MWDS_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_MWDS_MASK) >> SSP0_SSP_SSCR1_MWDS_SHIFT)
#define  SSP0_SSP_SSCR1_MWDS_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_MWDS_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_MWDS_SHIFT))

#define  SSP0_SSP_SSCR1_SPH_MASK 0x10
#define  SSP0_SSP_SSCR1_SPH_SHIFT 4
#define  SSP0_SSP_SSCR1_SPH_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_SPH_MASK) >> SSP0_SSP_SSCR1_SPH_SHIFT)
#define  SSP0_SSP_SSCR1_SPH_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_SPH_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_SPH_SHIFT))

#define  SSP0_SSP_SSCR1_SPO_MASK 0x8
#define  SSP0_SSP_SSCR1_SPO_SHIFT 3
#define  SSP0_SSP_SSCR1_SPO_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_SPO_MASK) >> SSP0_SSP_SSCR1_SPO_SHIFT)
#define  SSP0_SSP_SSCR1_SPO_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_SPO_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_SPO_SHIFT))

#define  SSP0_SSP_SSCR1_LBM_MASK 0x4
#define  SSP0_SSP_SSCR1_LBM_SHIFT 2
#define  SSP0_SSP_SSCR1_LBM_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_LBM_MASK) >> SSP0_SSP_SSCR1_LBM_SHIFT)
#define  SSP0_SSP_SSCR1_LBM_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_LBM_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_LBM_SHIFT))

#define  SSP0_SSP_SSCR1_TIE_MASK 0x2
#define  SSP0_SSP_SSCR1_TIE_SHIFT 1
#define  SSP0_SSP_SSCR1_TIE_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_TIE_MASK) >> SSP0_SSP_SSCR1_TIE_SHIFT)
#define  SSP0_SSP_SSCR1_TIE_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_TIE_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_TIE_SHIFT))

#define  SSP0_SSP_SSCR1_RIE_MASK 0x1
#define  SSP0_SSP_SSCR1_RIE_SHIFT 0
#define  SSP0_SSP_SSCR1_RIE_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSCR1_RIE_MASK) >> SSP0_SSP_SSCR1_RIE_SHIFT)
#define  SSP0_SSP_SSCR1_RIE_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSCR1_RIE_MASK) | (((uint32_t)val) << SSP0_SSP_SSCR1_RIE_SHIFT))

//====================================================================
//Register: SSP Status Register (SSP_SSSR)
/** \brief These registers contain bits that signal overrun errors as well as the TXFIFO
and RXFIFO service requests. Each of these hardware-detected events signals an
interrupt request to the interrupt controller, or a DMA request. The Status
register also contains flags that indicate if the SSPx port is actively
transmitting data, if the TXFIFO is not full, and if the RXFIFO is not empty.
A signal-interrupt signal is sent to the interrupt controller for each SSPx
port. These events can cause an interrupt request or a DMA request:
end-of-chain, receiver timeout, peripheral trailing byte, RXFIFO overrun, RXFIFO
service request, and TXFIFO service request.
Bits that cause an interrupt request remain set until they are cleared by
writing a 0x1 to each bit. Once a status bit is cleared, the interrupt is
cleared. Read-write bits are called status bits (status bits are referred to
as <q>sticky</q> and once set by hardware, they can only be cleared by writing
a 0x1 to each bit), read-only bits are called flags. Writing 0x1 to a sticky
status bit clears it, writing a 0x0 has no effect. Read-only flags are set
to 0x1 and are cleared automatically to 0x0 by hardware, and writes have no
effect. Some bits that cause interrupt requests have corresponding mask bits in
the control registers and are indicated in the following sections.
The following table shows the bit locations corresponding to the status and flag
bits within the SSP Port Status Register. All bits are read-only except
the <Receive FIFO Overrun>, <Peripheral Trailing Byte Interrupt>, <Transmit FIFO
Underrun>, <Bit Count Error>, <Receiver Time-out Interrupt>, and <End of Chain>,
which are all read-write. The reset state of read-write bits is 0x0 and all bits
return to their reset state when the <Synchronous Serial Port Enable> field in
the SSP Control Register 0 is cleared.
Write 0x0 to reserved bits, reads from reserved bits are undetermined.*/
//====================================================================

#define  SSP0_SSP_SSSR_OSS_MASK 0x80000000
#define  SSP0_SSP_SSSR_OSS_SHIFT 31
#define  SSP0_SSP_SSSR_OSS_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSSR_OSS_MASK) >> SSP0_SSP_SSSR_OSS_SHIFT)
#define  SSP0_SSP_SSSR_OSS_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSSR_OSS_MASK) | (((uint32_t)val) << SSP0_SSP_SSSR_OSS_SHIFT))

#define  SSP0_SSP_SSSR_TX_OSS_MASK 0x40000000
#define  SSP0_SSP_SSSR_TX_OSS_SHIFT 30
#define  SSP0_SSP_SSSR_TX_OSS_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSSR_TX_OSS_MASK) >> SSP0_SSP_SSSR_TX_OSS_SHIFT)
#define  SSP0_SSP_SSSR_TX_OSS_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSSR_TX_OSS_MASK) | (((uint32_t)val) << SSP0_SSP_SSSR_TX_OSS_SHIFT))

#define  SSP0_SSP_SSSR_RESERVED1_MASK 0x3f000000
#define  SSP0_SSP_SSSR_RESERVED1_SHIFT 24
#define  SSP0_SSP_SSSR_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSSR_RESERVED1_MASK) >> SSP0_SSP_SSSR_RESERVED1_SHIFT)
#define  SSP0_SSP_SSSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSSR_RESERVED1_MASK) | (((uint32_t)val) << SSP0_SSP_SSSR_RESERVED1_SHIFT))

#define  SSP0_SSP_SSSR_BCE_MASK 0x800000
#define  SSP0_SSP_SSSR_BCE_SHIFT 23
#define  SSP0_SSP_SSSR_BCE_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSSR_BCE_MASK) >> SSP0_SSP_SSSR_BCE_SHIFT)
#define  SSP0_SSP_SSSR_BCE_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSSR_BCE_MASK) | (((uint32_t)val) << SSP0_SSP_SSSR_BCE_SHIFT))

#define  SSP0_SSP_SSSR_CSS_MASK 0x400000
#define  SSP0_SSP_SSSR_CSS_SHIFT 22
#define  SSP0_SSP_SSSR_CSS_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSSR_CSS_MASK) >> SSP0_SSP_SSSR_CSS_SHIFT)
#define  SSP0_SSP_SSSR_CSS_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSSR_CSS_MASK) | (((uint32_t)val) << SSP0_SSP_SSSR_CSS_SHIFT))

#define  SSP0_SSP_SSSR_TUR_MASK 0x200000
#define  SSP0_SSP_SSSR_TUR_SHIFT 21
#define  SSP0_SSP_SSSR_TUR_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSSR_TUR_MASK) >> SSP0_SSP_SSSR_TUR_SHIFT)
#define  SSP0_SSP_SSSR_TUR_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSSR_TUR_MASK) | (((uint32_t)val) << SSP0_SSP_SSSR_TUR_SHIFT))

#define  SSP0_SSP_SSSR_EOC_MASK 0x100000
#define  SSP0_SSP_SSSR_EOC_SHIFT 20
#define  SSP0_SSP_SSSR_EOC_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSSR_EOC_MASK) >> SSP0_SSP_SSSR_EOC_SHIFT)
#define  SSP0_SSP_SSSR_EOC_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSSR_EOC_MASK) | (((uint32_t)val) << SSP0_SSP_SSSR_EOC_SHIFT))

#define  SSP0_SSP_SSSR_TINT_MASK 0x80000
#define  SSP0_SSP_SSSR_TINT_SHIFT 19
#define  SSP0_SSP_SSSR_TINT_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSSR_TINT_MASK) >> SSP0_SSP_SSSR_TINT_SHIFT)
#define  SSP0_SSP_SSSR_TINT_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSSR_TINT_MASK) | (((uint32_t)val) << SSP0_SSP_SSSR_TINT_SHIFT))

#define  SSP0_SSP_SSSR_PINT_MASK 0x40000
#define  SSP0_SSP_SSSR_PINT_SHIFT 18
#define  SSP0_SSP_SSSR_PINT_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSSR_PINT_MASK) >> SSP0_SSP_SSSR_PINT_SHIFT)
#define  SSP0_SSP_SSSR_PINT_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSSR_PINT_MASK) | (((uint32_t)val) << SSP0_SSP_SSSR_PINT_SHIFT))

#define  SSP0_SSP_SSSR_RESERVED2_MASK 0x30000
#define  SSP0_SSP_SSSR_RESERVED2_SHIFT 16
#define  SSP0_SSP_SSSR_RESERVED2_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSSR_RESERVED2_MASK) >> SSP0_SSP_SSSR_RESERVED2_SHIFT)
#define  SSP0_SSP_SSSR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSSR_RESERVED2_MASK) | (((uint32_t)val) << SSP0_SSP_SSSR_RESERVED2_SHIFT))

#define  SSP0_SSP_SSSR_RFL_MASK 0xf000
#define  SSP0_SSP_SSSR_RFL_SHIFT 12
#define  SSP0_SSP_SSSR_RFL_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSSR_RFL_MASK) >> SSP0_SSP_SSSR_RFL_SHIFT)
#define  SSP0_SSP_SSSR_RFL_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSSR_RFL_MASK) | (((uint32_t)val) << SSP0_SSP_SSSR_RFL_SHIFT))

#define  SSP0_SSP_SSSR_TFL_MASK 0xf00
#define  SSP0_SSP_SSSR_TFL_SHIFT 8
#define  SSP0_SSP_SSSR_TFL_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSSR_TFL_MASK) >> SSP0_SSP_SSSR_TFL_SHIFT)
#define  SSP0_SSP_SSSR_TFL_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSSR_TFL_MASK) | (((uint32_t)val) << SSP0_SSP_SSSR_TFL_SHIFT))

#define  SSP0_SSP_SSSR_ROR_MASK 0x80
#define  SSP0_SSP_SSSR_ROR_SHIFT 7
#define  SSP0_SSP_SSSR_ROR_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSSR_ROR_MASK) >> SSP0_SSP_SSSR_ROR_SHIFT)
#define  SSP0_SSP_SSSR_ROR_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSSR_ROR_MASK) | (((uint32_t)val) << SSP0_SSP_SSSR_ROR_SHIFT))

#define  SSP0_SSP_SSSR_RFS_MASK 0x40
#define  SSP0_SSP_SSSR_RFS_SHIFT 6
#define  SSP0_SSP_SSSR_RFS_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSSR_RFS_MASK) >> SSP0_SSP_SSSR_RFS_SHIFT)
#define  SSP0_SSP_SSSR_RFS_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSSR_RFS_MASK) | (((uint32_t)val) << SSP0_SSP_SSSR_RFS_SHIFT))

#define  SSP0_SSP_SSSR_TFS_MASK 0x20
#define  SSP0_SSP_SSSR_TFS_SHIFT 5
#define  SSP0_SSP_SSSR_TFS_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSSR_TFS_MASK) >> SSP0_SSP_SSSR_TFS_SHIFT)
#define  SSP0_SSP_SSSR_TFS_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSSR_TFS_MASK) | (((uint32_t)val) << SSP0_SSP_SSSR_TFS_SHIFT))

#define  SSP0_SSP_SSSR_BSY_MASK 0x10
#define  SSP0_SSP_SSSR_BSY_SHIFT 4
#define  SSP0_SSP_SSSR_BSY_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSSR_BSY_MASK) >> SSP0_SSP_SSSR_BSY_SHIFT)
#define  SSP0_SSP_SSSR_BSY_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSSR_BSY_MASK) | (((uint32_t)val) << SSP0_SSP_SSSR_BSY_SHIFT))

#define  SSP0_SSP_SSSR_RNE_MASK 0x8
#define  SSP0_SSP_SSSR_RNE_SHIFT 3
#define  SSP0_SSP_SSSR_RNE_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSSR_RNE_MASK) >> SSP0_SSP_SSSR_RNE_SHIFT)
#define  SSP0_SSP_SSSR_RNE_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSSR_RNE_MASK) | (((uint32_t)val) << SSP0_SSP_SSSR_RNE_SHIFT))

#define  SSP0_SSP_SSSR_TNF_MASK 0x4
#define  SSP0_SSP_SSSR_TNF_SHIFT 2
#define  SSP0_SSP_SSSR_TNF_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSSR_TNF_MASK) >> SSP0_SSP_SSSR_TNF_SHIFT)
#define  SSP0_SSP_SSSR_TNF_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSSR_TNF_MASK) | (((uint32_t)val) << SSP0_SSP_SSSR_TNF_SHIFT))

#define  SSP0_SSP_SSSR_RESERVED3_MASK 0x3
#define  SSP0_SSP_SSSR_RESERVED3_SHIFT 0
#define  SSP0_SSP_SSSR_RESERVED3_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSSR_RESERVED3_MASK) >> SSP0_SSP_SSSR_RESERVED3_SHIFT)
#define  SSP0_SSP_SSSR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSSR_RESERVED3_MASK) | (((uint32_t)val) << SSP0_SSP_SSSR_RESERVED3_SHIFT))

//====================================================================
//Register: SSP Interrupt Test Register (SSP_SSITR)
/** \brief Only use these read-write registers for testing purposes. The interrupt request
or DMA service request generated when one of these test bits is set remains
active until the test bit is cleared by writing 0x0. Setting any of these bits
to 0x1 also causes the corresponding status bit(s) to be set to 0x1 in the SSP
Status Register.
Write 0x0 to reserved bits, reads from reserved bits are undetermined.*/
//====================================================================

#define  SSP0_SSP_SSITR_RESERVED1_MASK 0xffffff00
#define  SSP0_SSP_SSITR_RESERVED1_SHIFT 8
#define  SSP0_SSP_SSITR_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSITR_RESERVED1_MASK) >> SSP0_SSP_SSITR_RESERVED1_SHIFT)
#define  SSP0_SSP_SSITR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSITR_RESERVED1_MASK) | (((uint32_t)val) << SSP0_SSP_SSITR_RESERVED1_SHIFT))

#define  SSP0_SSP_SSITR_TROR_MASK 0x80
#define  SSP0_SSP_SSITR_TROR_SHIFT 7
#define  SSP0_SSP_SSITR_TROR_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSITR_TROR_MASK) >> SSP0_SSP_SSITR_TROR_SHIFT)
#define  SSP0_SSP_SSITR_TROR_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSITR_TROR_MASK) | (((uint32_t)val) << SSP0_SSP_SSITR_TROR_SHIFT))

#define  SSP0_SSP_SSITR_TRFS_MASK 0x40
#define  SSP0_SSP_SSITR_TRFS_SHIFT 6
#define  SSP0_SSP_SSITR_TRFS_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSITR_TRFS_MASK) >> SSP0_SSP_SSITR_TRFS_SHIFT)
#define  SSP0_SSP_SSITR_TRFS_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSITR_TRFS_MASK) | (((uint32_t)val) << SSP0_SSP_SSITR_TRFS_SHIFT))

#define  SSP0_SSP_SSITR_TTFS_MASK 0x20
#define  SSP0_SSP_SSITR_TTFS_SHIFT 5
#define  SSP0_SSP_SSITR_TTFS_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSITR_TTFS_MASK) >> SSP0_SSP_SSITR_TTFS_SHIFT)
#define  SSP0_SSP_SSITR_TTFS_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSITR_TTFS_MASK) | (((uint32_t)val) << SSP0_SSP_SSITR_TTFS_SHIFT))

#define  SSP0_SSP_SSITR_RESERVED2_MASK 0x1f
#define  SSP0_SSP_SSITR_RESERVED2_SHIFT 0
#define  SSP0_SSP_SSITR_RESERVED2_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSITR_RESERVED2_MASK) >> SSP0_SSP_SSITR_RESERVED2_SHIFT)
#define  SSP0_SSP_SSITR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSITR_RESERVED2_MASK) | (((uint32_t)val) << SSP0_SSP_SSITR_RESERVED2_SHIFT))

//====================================================================
//Register: SSP Data Register (SSP_SSDR)
/** \brief These registers are each two physical registers that have a common address.
One SSDR_x is temporary storage for data that is transferred automatically
into the TXFIFO, the other SSDR_x is temporary storage for data that is
transferred automatically from the RXFIFO.
As programmed I/O or DMA access the SSDR_x, the TXFIFO or RXFIFO control
logic transfers data automatically between the SSDR_x and the FIFO as fast
as the system moves it. Data in the TXFIFO shifts up to accommodate new
data that is written to the SSDR_X, unless it is an attempted write to
a full TXFIFO. Data in the RXFIFO shifts down to accommodate data that is
read from the SSP Data Register. The <Transmit FIFO Level>, <Receive FIFO
Level>, <Receive FIFO Not Empty>, and <Transmit FIFO Not Full> fields in
the SSP Status Register show whether the FIFO is full, above/below
a programmable FIFO trigger threshold level, or empty.
When using programmed I/O, data can be written to the SSP Data Register
anytime the TXFIFO falls below its trigger threshold level.
When a data sample size of less than 32-bits or 16 bits for packed mode is
selected, software should right-justify the data that is written to the SSP
Data Register for automatic insertion into the TXFIFO. The transmit logic
left-justifies the data and ignores any unused bits. Received data of less
than 32 bits is right-justified automatically in the RXFIFO (thus, you
cannot perform a write in packed mode of less than 32 bits wide). The
TXFIFO and RXFIFO are cleared to 0x0 when the SSPx port is reset or
disabled (by writing a 0x0 to the <Synchronous Serial Port Enable> field in
the SSP Control Register 0).
The reset state of SSDR_x is undetermined. The following table shows the
location of the SSPx port SSDR_x.*/
//====================================================================

#define  SSP0_SSP_SSDR_DATA_MASK 0xffffffff
#define  SSP0_SSP_SSDR_DATA_SHIFT 0
#define  SSP0_SSP_SSDR_DATA_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSDR_DATA_MASK) >> SSP0_SSP_SSDR_DATA_SHIFT)
#define  SSP0_SSP_SSDR_DATA_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSDR_DATA_MASK) | (((uint32_t)val) << SSP0_SSP_SSDR_DATA_SHIFT))

//====================================================================
//Register: SSP Time Out Register (SSP_SSTO)
/** \brief These registers specify the timeout (TIMEOUT) value used to signal a period of
inactivity within the RXFIFO, see Timeout Section in the PXA2128 Datasheet. When
a timeout occurs, the <Receiver Time-out Interrupt> field in the SSP Status
Register is set. When the TIMEOUT value is set to 0x000000, no timeout occurs
and the <Receiver Time-out Interrupt> field is not set. The TIMEOUT interval is
given by the calculation in the TIMEOUT Interval Equation.
TIMEOUT Interval Equation
TimeOut Interval = <Timeout Value> / APB Clock Frequency
Note: APB Clock Frequency = 26 MHz
Write 0x0 to reserved bits, reads from reserved bits are undetermined.*/
//====================================================================

#define  SSP0_SSP_SSTO_RESERVED1_MASK 0xff000000
#define  SSP0_SSP_SSTO_RESERVED1_SHIFT 24
#define  SSP0_SSP_SSTO_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSTO_RESERVED1_MASK) >> SSP0_SSP_SSTO_RESERVED1_SHIFT)
#define  SSP0_SSP_SSTO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSTO_RESERVED1_MASK) | (((uint32_t)val) << SSP0_SSP_SSTO_RESERVED1_SHIFT))

#define  SSP0_SSP_SSTO_TIMEOUT_MASK 0xffffff
#define  SSP0_SSP_SSTO_TIMEOUT_SHIFT 0
#define  SSP0_SSP_SSTO_TIMEOUT_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSTO_TIMEOUT_MASK) >> SSP0_SSP_SSTO_TIMEOUT_SHIFT)
#define  SSP0_SSP_SSTO_TIMEOUT_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSTO_TIMEOUT_MASK) | (((uint32_t)val) << SSP0_SSP_SSTO_TIMEOUT_SHIFT))

//====================================================================
//Register: SSP Programmable Serial Protocol Register (SSP_SSPSP)
/** \brief These registers contain eight fields that program the various programmable
serial-protocol (PSP) parameters. When using Programmable Serial Protocol (PSP)
format in network mode, the parameters <Serial Frame Delay>, <Serial Frame
Delay>, <Start Delay>, <Dummy Stop>, <Extended Dummy Stop>, <Dummy Start>,
and <Extended Dummy Start> must be set to 0x0. The other parameters <Serial
Frame Polarity>, <Serial Bit-rate Clock Mode>, <Frame Sync Relative Timing Bit>,
and <Serial Frame Width> are programmable.
Writes 0b0 to reserved bits, reads from reserved bits are undetermined.*/
//====================================================================

#define  SSP0_SSP_SSPSP_RESERVED1_MASK 0x80000000
#define  SSP0_SSP_SSPSP_RESERVED1_SHIFT 31
#define  SSP0_SSP_SSPSP_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSPSP_RESERVED1_MASK) >> SSP0_SSP_SSPSP_RESERVED1_SHIFT)
#define  SSP0_SSP_SSPSP_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSPSP_RESERVED1_MASK) | (((uint32_t)val) << SSP0_SSP_SSPSP_RESERVED1_SHIFT))

#define  SSP0_SSP_SSPSP_EDMYSTOP_MASK 0x70000000
#define  SSP0_SSP_SSPSP_EDMYSTOP_SHIFT 28
#define  SSP0_SSP_SSPSP_EDMYSTOP_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSPSP_EDMYSTOP_MASK) >> SSP0_SSP_SSPSP_EDMYSTOP_SHIFT)
#define  SSP0_SSP_SSPSP_EDMYSTOP_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSPSP_EDMYSTOP_MASK) | (((uint32_t)val) << SSP0_SSP_SSPSP_EDMYSTOP_SHIFT))

#define  SSP0_SSP_SSPSP_EDMYSTRT_MASK 0xc000000
#define  SSP0_SSP_SSPSP_EDMYSTRT_SHIFT 26
#define  SSP0_SSP_SSPSP_EDMYSTRT_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSPSP_EDMYSTRT_MASK) >> SSP0_SSP_SSPSP_EDMYSTRT_SHIFT)
#define  SSP0_SSP_SSPSP_EDMYSTRT_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSPSP_EDMYSTRT_MASK) | (((uint32_t)val) << SSP0_SSP_SSPSP_EDMYSTRT_SHIFT))

#define  SSP0_SSP_SSPSP_FSRT_MASK 0x2000000
#define  SSP0_SSP_SSPSP_FSRT_SHIFT 25
#define  SSP0_SSP_SSPSP_FSRT_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSPSP_FSRT_MASK) >> SSP0_SSP_SSPSP_FSRT_SHIFT)
#define  SSP0_SSP_SSPSP_FSRT_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSPSP_FSRT_MASK) | (((uint32_t)val) << SSP0_SSP_SSPSP_FSRT_SHIFT))

#define  SSP0_SSP_SSPSP_DMYSTOP_MASK 0x1800000
#define  SSP0_SSP_SSPSP_DMYSTOP_SHIFT 23
#define  SSP0_SSP_SSPSP_DMYSTOP_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSPSP_DMYSTOP_MASK) >> SSP0_SSP_SSPSP_DMYSTOP_SHIFT)
#define  SSP0_SSP_SSPSP_DMYSTOP_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSPSP_DMYSTOP_MASK) | (((uint32_t)val) << SSP0_SSP_SSPSP_DMYSTOP_SHIFT))

#define  SSP0_SSP_SSPSP_RESERVED2_MASK 0x400000
#define  SSP0_SSP_SSPSP_RESERVED2_SHIFT 22
#define  SSP0_SSP_SSPSP_RESERVED2_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSPSP_RESERVED2_MASK) >> SSP0_SSP_SSPSP_RESERVED2_SHIFT)
#define  SSP0_SSP_SSPSP_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSPSP_RESERVED2_MASK) | (((uint32_t)val) << SSP0_SSP_SSPSP_RESERVED2_SHIFT))

#define  SSP0_SSP_SSPSP_SFRMWDTH_MASK 0x3f0000
#define  SSP0_SSP_SSPSP_SFRMWDTH_SHIFT 16
#define  SSP0_SSP_SSPSP_SFRMWDTH_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSPSP_SFRMWDTH_MASK) >> SSP0_SSP_SSPSP_SFRMWDTH_SHIFT)
#define  SSP0_SSP_SSPSP_SFRMWDTH_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSPSP_SFRMWDTH_MASK) | (((uint32_t)val) << SSP0_SSP_SSPSP_SFRMWDTH_SHIFT))

#define  SSP0_SSP_SSPSP_SFRMDLY_MASK 0xfe00
#define  SSP0_SSP_SSPSP_SFRMDLY_SHIFT 9
#define  SSP0_SSP_SSPSP_SFRMDLY_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSPSP_SFRMDLY_MASK) >> SSP0_SSP_SSPSP_SFRMDLY_SHIFT)
#define  SSP0_SSP_SSPSP_SFRMDLY_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSPSP_SFRMDLY_MASK) | (((uint32_t)val) << SSP0_SSP_SSPSP_SFRMDLY_SHIFT))

#define  SSP0_SSP_SSPSP_DMYSTRT_MASK 0x180
#define  SSP0_SSP_SSPSP_DMYSTRT_SHIFT 7
#define  SSP0_SSP_SSPSP_DMYSTRT_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSPSP_DMYSTRT_MASK) >> SSP0_SSP_SSPSP_DMYSTRT_SHIFT)
#define  SSP0_SSP_SSPSP_DMYSTRT_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSPSP_DMYSTRT_MASK) | (((uint32_t)val) << SSP0_SSP_SSPSP_DMYSTRT_SHIFT))

#define  SSP0_SSP_SSPSP_STRTDLY_MASK 0x70
#define  SSP0_SSP_SSPSP_STRTDLY_SHIFT 4
#define  SSP0_SSP_SSPSP_STRTDLY_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSPSP_STRTDLY_MASK) >> SSP0_SSP_SSPSP_STRTDLY_SHIFT)
#define  SSP0_SSP_SSPSP_STRTDLY_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSPSP_STRTDLY_MASK) | (((uint32_t)val) << SSP0_SSP_SSPSP_STRTDLY_SHIFT))

#define  SSP0_SSP_SSPSP_ETDS_MASK 0x8
#define  SSP0_SSP_SSPSP_ETDS_SHIFT 3
#define  SSP0_SSP_SSPSP_ETDS_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSPSP_ETDS_MASK) >> SSP0_SSP_SSPSP_ETDS_SHIFT)
#define  SSP0_SSP_SSPSP_ETDS_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSPSP_ETDS_MASK) | (((uint32_t)val) << SSP0_SSP_SSPSP_ETDS_SHIFT))

#define  SSP0_SSP_SSPSP_SFRMP_MASK 0x4
#define  SSP0_SSP_SSPSP_SFRMP_SHIFT 2
#define  SSP0_SSP_SSPSP_SFRMP_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSPSP_SFRMP_MASK) >> SSP0_SSP_SSPSP_SFRMP_SHIFT)
#define  SSP0_SSP_SSPSP_SFRMP_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSPSP_SFRMP_MASK) | (((uint32_t)val) << SSP0_SSP_SSPSP_SFRMP_SHIFT))

#define  SSP0_SSP_SSPSP_SCMODE_MASK 0x3
#define  SSP0_SSP_SSPSP_SCMODE_SHIFT 0
#define  SSP0_SSP_SSPSP_SCMODE_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSPSP_SCMODE_MASK) >> SSP0_SSP_SSPSP_SCMODE_SHIFT)
#define  SSP0_SSP_SSPSP_SCMODE_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSPSP_SCMODE_MASK) | (((uint32_t)val) << SSP0_SSP_SSPSP_SCMODE_SHIFT))

//====================================================================
//Register: SSP TX Time Slot Active Register (SSP_SSTSA)
/** \brief These read-write registers are only used in network mode (<Mode> in SSP Control
Register 0 set), and they specify in which time slot the SSPx port transmits
data. See Network Mode (Example Using 4 Time Slots) figure for an example of the
use of time slots when in network mode.
The 8-bit <TX Time Slot Active> field specifies in which time slots the SSPx
port transmits data and in which time slots the SSPx port does NOT transmit
data. Bits beyond the <Frame Rate Divider Control> field in the SSP Control
Register 0 value are ignored (for example, if <Frame Rate Divider
Control> = 0x3, specifying that four time slots are used, then <TX Time Slot
Active> bits [7:4] are ignored). If the <TXD Three-State Enable> field in the
SSP Control Register 1 is set, the SSPx port three-states the SSPTXDx interface
output signal line during time slots that have associated TTSA bits programmed
to 0x0.
Write 0x0 to reserved bits, reads from reserved bits are undetermined.*/
//====================================================================

#define  SSP0_SSP_SSTSA_RESERVED1_MASK 0xffffff00
#define  SSP0_SSP_SSTSA_RESERVED1_SHIFT 8
#define  SSP0_SSP_SSTSA_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSTSA_RESERVED1_MASK) >> SSP0_SSP_SSTSA_RESERVED1_SHIFT)
#define  SSP0_SSP_SSTSA_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSTSA_RESERVED1_MASK) | (((uint32_t)val) << SSP0_SSP_SSTSA_RESERVED1_SHIFT))

#define  SSP0_SSP_SSTSA_TTSA_MASK 0xff
#define  SSP0_SSP_SSTSA_TTSA_SHIFT 0
#define  SSP0_SSP_SSTSA_TTSA_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSTSA_TTSA_MASK) >> SSP0_SSP_SSTSA_TTSA_SHIFT)
#define  SSP0_SSP_SSTSA_TTSA_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSTSA_TTSA_MASK) | (((uint32_t)val) << SSP0_SSP_SSTSA_TTSA_SHIFT))

//====================================================================
//Register: SSP RX Time Slot Active Register (SSP_SSRSA)
/** \brief These read-write registers are only used in network mode (<Mode> in SSP Control
Register 0 set), and they specify in which time slot the SSPx port receives
data. See Network Mode (Example Using 4 Time Slots) figure for an example of the
use of time slots when in network mode.
The 8-bit <RX Time Slot Active> field specifies in which time slots the SSPx
port receives data and in which time slots the SSPx port does not receive data.
Bits beyond the <Frame Rate Divider Control> field in the SSP Control Register 0
value are ignored. For example, if <Frame Rate Divider Control> = 0x3,
specifying that four time slots are used, then <RX Time Slot Active> bits [7:4]
are ignored.
Write 0x0 to reserved bits, reads from reserved bits are undetermined.*/
//====================================================================

#define  SSP0_SSP_SSRSA_RESERVED1_MASK 0xffffff00
#define  SSP0_SSP_SSRSA_RESERVED1_SHIFT 8
#define  SSP0_SSP_SSRSA_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSRSA_RESERVED1_MASK) >> SSP0_SSP_SSRSA_RESERVED1_SHIFT)
#define  SSP0_SSP_SSRSA_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSRSA_RESERVED1_MASK) | (((uint32_t)val) << SSP0_SSP_SSRSA_RESERVED1_SHIFT))

#define  SSP0_SSP_SSRSA_RTSA_MASK 0xff
#define  SSP0_SSP_SSRSA_RTSA_SHIFT 0
#define  SSP0_SSP_SSRSA_RTSA_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSRSA_RTSA_MASK) >> SSP0_SSP_SSRSA_RTSA_SHIFT)
#define  SSP0_SSP_SSRSA_RTSA_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSRSA_RTSA_MASK) | (((uint32_t)val) << SSP0_SSP_SSRSA_RTSA_SHIFT))

//====================================================================
//Register: SSP Time Slot Status Register (SSP_SSTSS)
/** \brief These read-only registers are only available when in network mode (<Mode> in SSP
Control Register 0 set), and they identify the time slot in which the SSPx port
is operating.
Write 0x0 to reserved bits, reads from reserved bits are undetermined.*/
//====================================================================

#define  SSP0_SSP_SSTSS_NMBSY_MASK 0x80000000
#define  SSP0_SSP_SSTSS_NMBSY_SHIFT 31
#define  SSP0_SSP_SSTSS_NMBSY_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSTSS_NMBSY_MASK) >> SSP0_SSP_SSTSS_NMBSY_SHIFT)
#define  SSP0_SSP_SSTSS_NMBSY_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSTSS_NMBSY_MASK) | (((uint32_t)val) << SSP0_SSP_SSTSS_NMBSY_SHIFT))

#define  SSP0_SSP_SSTSS_RESERVED1_MASK 0x7ffffff8
#define  SSP0_SSP_SSTSS_RESERVED1_SHIFT 3
#define  SSP0_SSP_SSTSS_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSTSS_RESERVED1_MASK) >> SSP0_SSP_SSTSS_RESERVED1_SHIFT)
#define  SSP0_SSP_SSTSS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSTSS_RESERVED1_MASK) | (((uint32_t)val) << SSP0_SSP_SSTSS_RESERVED1_SHIFT))

#define  SSP0_SSP_SSTSS_TSS_MASK 0x7
#define  SSP0_SSP_SSTSS_TSS_SHIFT 0
#define  SSP0_SSP_SSTSS_TSS_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SSTSS_TSS_MASK) >> SSP0_SSP_SSTSS_TSS_SHIFT)
#define  SSP0_SSP_SSTSS_TSS_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SSTSS_TSS_MASK) | (((uint32_t)val) << SSP0_SSP_SSTSS_TSS_SHIFT))

//====================================================================
//Register: GPS Controller ID Register (SSP_GPS_ID)
//====================================================================

#define  SSP0_SSP_GPS_ID_GPS_ID_MASK 0xffffffff
#define  SSP0_SSP_GPS_ID_GPS_ID_SHIFT 0
#define  SSP0_SSP_GPS_ID_GPS_ID_MASK_SHIFT(reg) (((reg) & SSP0_SSP_GPS_ID_GPS_ID_MASK) >> SSP0_SSP_GPS_ID_GPS_ID_SHIFT)
#define  SSP0_SSP_GPS_ID_GPS_ID_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_GPS_ID_GPS_ID_MASK) | (((uint32_t)val) << SSP0_SSP_GPS_ID_GPS_ID_SHIFT))

//====================================================================
//Register: GPS Control and Status Register (SSP_GPS_CSR)
//====================================================================

#define  SSP0_SSP_GPS_CSR_RESERVED1_MASK 0xffffe000
#define  SSP0_SSP_GPS_CSR_RESERVED1_SHIFT 13
#define  SSP0_SSP_GPS_CSR_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP0_SSP_GPS_CSR_RESERVED1_MASK) >> SSP0_SSP_GPS_CSR_RESERVED1_SHIFT)
#define  SSP0_SSP_GPS_CSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_GPS_CSR_RESERVED1_MASK) | (((uint32_t)val) << SSP0_SSP_GPS_CSR_RESERVED1_SHIFT))

#define  SSP0_SSP_GPS_CSR_LSB_1ST_MASK 0x1000
#define  SSP0_SSP_GPS_CSR_LSB_1ST_SHIFT 12
#define  SSP0_SSP_GPS_CSR_LSB_1ST_MASK_SHIFT(reg) (((reg) & SSP0_SSP_GPS_CSR_LSB_1ST_MASK) >> SSP0_SSP_GPS_CSR_LSB_1ST_SHIFT)
#define  SSP0_SSP_GPS_CSR_LSB_1ST_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_GPS_CSR_LSB_1ST_MASK) | (((uint32_t)val) << SSP0_SSP_GPS_CSR_LSB_1ST_SHIFT))

#define  SSP0_SSP_GPS_CSR_SERCLK_FEDGE_MASK 0x800
#define  SSP0_SSP_GPS_CSR_SERCLK_FEDGE_SHIFT 11
#define  SSP0_SSP_GPS_CSR_SERCLK_FEDGE_MASK_SHIFT(reg) (((reg) & SSP0_SSP_GPS_CSR_SERCLK_FEDGE_MASK) >> SSP0_SSP_GPS_CSR_SERCLK_FEDGE_SHIFT)
#define  SSP0_SSP_GPS_CSR_SERCLK_FEDGE_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_GPS_CSR_SERCLK_FEDGE_MASK) | (((uint32_t)val) << SSP0_SSP_GPS_CSR_SERCLK_FEDGE_SHIFT))

#define  SSP0_SSP_GPS_CSR_FS_SEL1_0_MASK 0x600
#define  SSP0_SSP_GPS_CSR_FS_SEL1_0_SHIFT 9
#define  SSP0_SSP_GPS_CSR_FS_SEL1_0_MASK_SHIFT(reg) (((reg) & SSP0_SSP_GPS_CSR_FS_SEL1_0_MASK) >> SSP0_SSP_GPS_CSR_FS_SEL1_0_SHIFT)
#define  SSP0_SSP_GPS_CSR_FS_SEL1_0_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_GPS_CSR_FS_SEL1_0_MASK) | (((uint32_t)val) << SSP0_SSP_GPS_CSR_FS_SEL1_0_SHIFT))

#define  SSP0_SSP_GPS_CSR_MAX_STRMBITS_MASK 0x180
#define  SSP0_SSP_GPS_CSR_MAX_STRMBITS_SHIFT 7
#define  SSP0_SSP_GPS_CSR_MAX_STRMBITS_MASK_SHIFT(reg) (((reg) & SSP0_SSP_GPS_CSR_MAX_STRMBITS_MASK) >> SSP0_SSP_GPS_CSR_MAX_STRMBITS_SHIFT)
#define  SSP0_SSP_GPS_CSR_MAX_STRMBITS_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_GPS_CSR_MAX_STRMBITS_MASK) | (((uint32_t)val) << SSP0_SSP_GPS_CSR_MAX_STRMBITS_SHIFT))

#define  SSP0_SSP_GPS_CSR_GPS_TYPE_MASK 0x70
#define  SSP0_SSP_GPS_CSR_GPS_TYPE_SHIFT 4
#define  SSP0_SSP_GPS_CSR_GPS_TYPE_MASK_SHIFT(reg) (((reg) & SSP0_SSP_GPS_CSR_GPS_TYPE_MASK) >> SSP0_SSP_GPS_CSR_GPS_TYPE_SHIFT)
#define  SSP0_SSP_GPS_CSR_GPS_TYPE_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_GPS_CSR_GPS_TYPE_MASK) | (((uint32_t)val) << SSP0_SSP_GPS_CSR_GPS_TYPE_SHIFT))

#define  SSP0_SSP_GPS_CSR_TSYNC_COUNT_RST_MASK 0x8
#define  SSP0_SSP_GPS_CSR_TSYNC_COUNT_RST_SHIFT 3
#define  SSP0_SSP_GPS_CSR_TSYNC_COUNT_RST_MASK_SHIFT(reg) (((reg) & SSP0_SSP_GPS_CSR_TSYNC_COUNT_RST_MASK) >> SSP0_SSP_GPS_CSR_TSYNC_COUNT_RST_SHIFT)
#define  SSP0_SSP_GPS_CSR_TSYNC_COUNT_RST_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_GPS_CSR_TSYNC_COUNT_RST_MASK) | (((uint32_t)val) << SSP0_SSP_GPS_CSR_TSYNC_COUNT_RST_SHIFT))

#define  SSP0_SSP_GPS_CSR_SOFT_RESET_MASK 0x4
#define  SSP0_SSP_GPS_CSR_SOFT_RESET_SHIFT 2
#define  SSP0_SSP_GPS_CSR_SOFT_RESET_MASK_SHIFT(reg) (((reg) & SSP0_SSP_GPS_CSR_SOFT_RESET_MASK) >> SSP0_SSP_GPS_CSR_SOFT_RESET_SHIFT)
#define  SSP0_SSP_GPS_CSR_SOFT_RESET_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_GPS_CSR_SOFT_RESET_MASK) | (((uint32_t)val) << SSP0_SSP_GPS_CSR_SOFT_RESET_SHIFT))

#define  SSP0_SSP_GPS_CSR_GPS_ON_MASK 0x2
#define  SSP0_SSP_GPS_CSR_GPS_ON_SHIFT 1
#define  SSP0_SSP_GPS_CSR_GPS_ON_MASK_SHIFT(reg) (((reg) & SSP0_SSP_GPS_CSR_GPS_ON_MASK) >> SSP0_SSP_GPS_CSR_GPS_ON_SHIFT)
#define  SSP0_SSP_GPS_CSR_GPS_ON_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_GPS_CSR_GPS_ON_MASK) | (((uint32_t)val) << SSP0_SSP_GPS_CSR_GPS_ON_SHIFT))

#define  SSP0_SSP_GPS_CSR_GPS_MODE_MASK 0x1
#define  SSP0_SSP_GPS_CSR_GPS_MODE_SHIFT 0
#define  SSP0_SSP_GPS_CSR_GPS_MODE_MASK_SHIFT(reg) (((reg) & SSP0_SSP_GPS_CSR_GPS_MODE_MASK) >> SSP0_SSP_GPS_CSR_GPS_MODE_SHIFT)
#define  SSP0_SSP_GPS_CSR_GPS_MODE_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_GPS_CSR_GPS_MODE_MASK) | (((uint32_t)val) << SSP0_SSP_GPS_CSR_GPS_MODE_SHIFT))

//====================================================================
//Register: Time Sync Count Register (SSP_GPS_TSCNT)
/** \brief This is the counter that is used to increment at each TIME_SYNC rising edge of
MAX2769.*/
//====================================================================

#define  SSP0_SSP_GPS_TSCNT_GPS_TSCNT_MASK 0xffffffff
#define  SSP0_SSP_GPS_TSCNT_GPS_TSCNT_SHIFT 0
#define  SSP0_SSP_GPS_TSCNT_GPS_TSCNT_MASK_SHIFT(reg) (((reg) & SSP0_SSP_GPS_TSCNT_GPS_TSCNT_MASK) >> SSP0_SSP_GPS_TSCNT_GPS_TSCNT_SHIFT)
#define  SSP0_SSP_GPS_TSCNT_GPS_TSCNT_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_GPS_TSCNT_GPS_TSCNT_MASK) | (((uint32_t)val) << SSP0_SSP_GPS_TSCNT_GPS_TSCNT_SHIFT))

//====================================================================
//Register: Time Sync Count Adjust Register (SSP_GPS_TSCNT_ADJ)
/** \brief This register is updated with the contents of the Time Sync Count Register
whenever the Rx FIFO is read by the system. DMA access should read this
register. This register is adjusted to eliminate DMA delay.*/
//====================================================================

#define  SSP0_SSP_GPS_TSCNT_ADJ_GPS_TSCNT_ADJ_MASK 0xffffffff
#define  SSP0_SSP_GPS_TSCNT_ADJ_GPS_TSCNT_ADJ_SHIFT 0
#define  SSP0_SSP_GPS_TSCNT_ADJ_GPS_TSCNT_ADJ_MASK_SHIFT(reg) (((reg) & SSP0_SSP_GPS_TSCNT_ADJ_GPS_TSCNT_ADJ_MASK) >> SSP0_SSP_GPS_TSCNT_ADJ_GPS_TSCNT_ADJ_SHIFT)
#define  SSP0_SSP_GPS_TSCNT_ADJ_GPS_TSCNT_ADJ_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_GPS_TSCNT_ADJ_GPS_TSCNT_ADJ_MASK) | (((uint32_t)val) << SSP0_SSP_GPS_TSCNT_ADJ_GPS_TSCNT_ADJ_SHIFT))

//====================================================================
//Register: Modified SPI Mode Register (SSP_SPI_MOD)
/** \brief This is the register holding the enable bit for modified SPI.*/
//====================================================================

#define  SSP0_SSP_SPI_MOD_RESERVED1_MASK 0xfffffffe
#define  SSP0_SSP_SPI_MOD_RESERVED1_SHIFT 1
#define  SSP0_SSP_SPI_MOD_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SPI_MOD_RESERVED1_MASK) >> SSP0_SSP_SPI_MOD_RESERVED1_SHIFT)
#define  SSP0_SSP_SPI_MOD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SPI_MOD_RESERVED1_MASK) | (((uint32_t)val) << SSP0_SSP_SPI_MOD_RESERVED1_SHIFT))

#define  SSP0_SSP_SPI_MOD_SPI_MOD_MASK 0x1
#define  SSP0_SSP_SPI_MOD_SPI_MOD_SHIFT 0
#define  SSP0_SSP_SPI_MOD_SPI_MOD_MASK_SHIFT(reg) (((reg) & SSP0_SSP_SPI_MOD_SPI_MOD_MASK) >> SSP0_SSP_SPI_MOD_SPI_MOD_SHIFT)
#define  SSP0_SSP_SPI_MOD_SPI_MOD_REPLACE_VAL(reg,val) (((reg) & ~SSP0_SSP_SPI_MOD_SPI_MOD_MASK) | (((uint32_t)val) << SSP0_SSP_SPI_MOD_SPI_MOD_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  SSP0_REV0_MAJ_MASK 0xffff0000
#define  SSP0_REV0_MAJ_SHIFT 16
#define  SSP0_REV0_MAJ_MASK_SHIFT(reg) (((reg) & SSP0_REV0_MAJ_MASK) >> SSP0_REV0_MAJ_SHIFT)
#define  SSP0_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~SSP0_REV0_MAJ_MASK) | (((uint32_t)val) << SSP0_REV0_MAJ_SHIFT))

#define  SSP0_REV0_MID_MASK 0xffff
#define  SSP0_REV0_MID_SHIFT 0
#define  SSP0_REV0_MID_MASK_SHIFT(reg) (((reg) & SSP0_REV0_MID_MASK) >> SSP0_REV0_MID_SHIFT)
#define  SSP0_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~SSP0_REV0_MID_MASK) | (((uint32_t)val) << SSP0_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  SSP0_REV1_RESERVED1_MASK 0xffff0000
#define  SSP0_REV1_RESERVED1_SHIFT 16
#define  SSP0_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP0_REV1_RESERVED1_MASK) >> SSP0_REV1_RESERVED1_SHIFT)
#define  SSP0_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP0_REV1_RESERVED1_MASK) | (((uint32_t)val) << SSP0_REV1_RESERVED1_SHIFT))

#define  SSP0_REV1_CFG_MASK 0xffff
#define  SSP0_REV1_CFG_SHIFT 0
#define  SSP0_REV1_CFG_MASK_SHIFT(reg) (((reg) & SSP0_REV1_CFG_MASK) >> SSP0_REV1_CFG_SHIFT)
#define  SSP0_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~SSP0_REV1_CFG_MASK) | (((uint32_t)val) << SSP0_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: SSP Registers (Instance 2 of 3) (SSP1)
//
//====================================================================

//====================================================================
//Register: SSP Control Register 0 (SSP_SSCR0)
/** \brief These registers contain bit fields that control various functions within the SSP
port. The following table shows the bit locations corresponding to the different
control bit fields within the SSP Control 0 Register. The reset state of all
bits are as shown, but they must be programmed to their preferred values before
enabling the SSP port.
Writes to reserved bits must be 0x0, and read values of reserved bits are
undefined.*/
//====================================================================

#define  SSP1_SSP_SSCR0_MOD_MASK 0x80000000
#define  SSP1_SSP_SSCR0_MOD_SHIFT 31
#define  SSP1_SSP_SSCR0_MOD_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR0_MOD_MASK) >> SSP1_SSP_SSCR0_MOD_SHIFT)
#define  SSP1_SSP_SSCR0_MOD_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR0_MOD_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR0_MOD_SHIFT))

#define  SSP1_SSP_SSCR0_RESERVED1_MASK 0x40000000
#define  SSP1_SSP_SSCR0_RESERVED1_SHIFT 30
#define  SSP1_SSP_SSCR0_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR0_RESERVED1_MASK) >> SSP1_SSP_SSCR0_RESERVED1_SHIFT)
#define  SSP1_SSP_SSCR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR0_RESERVED1_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR0_RESERVED1_SHIFT))

#define  SSP1_SSP_SSCR0_FPCKE_MASK 0x20000000
#define  SSP1_SSP_SSCR0_FPCKE_SHIFT 29
#define  SSP1_SSP_SSCR0_FPCKE_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR0_FPCKE_MASK) >> SSP1_SSP_SSCR0_FPCKE_SHIFT)
#define  SSP1_SSP_SSCR0_FPCKE_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR0_FPCKE_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR0_FPCKE_SHIFT))

#define  SSP1_SSP_SSCR0_FCTRL_MASK 0x10000000
#define  SSP1_SSP_SSCR0_FCTRL_SHIFT 28
#define  SSP1_SSP_SSCR0_FCTRL_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR0_FCTRL_MASK) >> SSP1_SSP_SSCR0_FCTRL_SHIFT)
#define  SSP1_SSP_SSCR0_FCTRL_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR0_FCTRL_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR0_FCTRL_SHIFT))

#define  SSP1_SSP_SSCR0_RESERVED2_MASK 0x8000000
#define  SSP1_SSP_SSCR0_RESERVED2_SHIFT 27
#define  SSP1_SSP_SSCR0_RESERVED2_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR0_RESERVED2_MASK) >> SSP1_SSP_SSCR0_RESERVED2_SHIFT)
#define  SSP1_SSP_SSCR0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR0_RESERVED2_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR0_RESERVED2_SHIFT))

#define  SSP1_SSP_SSCR0_FRDC_MASK 0x7000000
#define  SSP1_SSP_SSCR0_FRDC_SHIFT 24
#define  SSP1_SSP_SSCR0_FRDC_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR0_FRDC_MASK) >> SSP1_SSP_SSCR0_FRDC_SHIFT)
#define  SSP1_SSP_SSCR0_FRDC_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR0_FRDC_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR0_FRDC_SHIFT))

#define  SSP1_SSP_SSCR0_TIM_MASK 0x800000
#define  SSP1_SSP_SSCR0_TIM_SHIFT 23
#define  SSP1_SSP_SSCR0_TIM_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR0_TIM_MASK) >> SSP1_SSP_SSCR0_TIM_SHIFT)
#define  SSP1_SSP_SSCR0_TIM_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR0_TIM_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR0_TIM_SHIFT))

#define  SSP1_SSP_SSCR0_RIM_MASK 0x400000
#define  SSP1_SSP_SSCR0_RIM_SHIFT 22
#define  SSP1_SSP_SSCR0_RIM_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR0_RIM_MASK) >> SSP1_SSP_SSCR0_RIM_SHIFT)
#define  SSP1_SSP_SSCR0_RIM_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR0_RIM_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR0_RIM_SHIFT))

#define  SSP1_SSP_SSCR0_RESERVED3_MASK 0x200000
#define  SSP1_SSP_SSCR0_RESERVED3_SHIFT 21
#define  SSP1_SSP_SSCR0_RESERVED3_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR0_RESERVED3_MASK) >> SSP1_SSP_SSCR0_RESERVED3_SHIFT)
#define  SSP1_SSP_SSCR0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR0_RESERVED3_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR0_RESERVED3_SHIFT))

#define  SSP1_SSP_SSCR0_EDSS_MASK 0x100000
#define  SSP1_SSP_SSCR0_EDSS_SHIFT 20
#define  SSP1_SSP_SSCR0_EDSS_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR0_EDSS_MASK) >> SSP1_SSP_SSCR0_EDSS_SHIFT)
#define  SSP1_SSP_SSCR0_EDSS_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR0_EDSS_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR0_EDSS_SHIFT))

#define  SSP1_SSP_SSCR0_RESERVED4_MASK 0xfff00
#define  SSP1_SSP_SSCR0_RESERVED4_SHIFT 8
#define  SSP1_SSP_SSCR0_RESERVED4_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR0_RESERVED4_MASK) >> SSP1_SSP_SSCR0_RESERVED4_SHIFT)
#define  SSP1_SSP_SSCR0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR0_RESERVED4_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR0_RESERVED4_SHIFT))

#define  SSP1_SSP_SSCR0_SSE_MASK 0x80
#define  SSP1_SSP_SSCR0_SSE_SHIFT 7
#define  SSP1_SSP_SSCR0_SSE_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR0_SSE_MASK) >> SSP1_SSP_SSCR0_SSE_SHIFT)
#define  SSP1_SSP_SSCR0_SSE_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR0_SSE_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR0_SSE_SHIFT))

#define  SSP1_SSP_SSCR0_RESERVED5_MASK 0x40
#define  SSP1_SSP_SSCR0_RESERVED5_SHIFT 6
#define  SSP1_SSP_SSCR0_RESERVED5_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR0_RESERVED5_MASK) >> SSP1_SSP_SSCR0_RESERVED5_SHIFT)
#define  SSP1_SSP_SSCR0_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR0_RESERVED5_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR0_RESERVED5_SHIFT))

#define  SSP1_SSP_SSCR0_FRF_MASK 0x30
#define  SSP1_SSP_SSCR0_FRF_SHIFT 4
#define  SSP1_SSP_SSCR0_FRF_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR0_FRF_MASK) >> SSP1_SSP_SSCR0_FRF_SHIFT)
#define  SSP1_SSP_SSCR0_FRF_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR0_FRF_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR0_FRF_SHIFT))

#define  SSP1_SSP_SSCR0_DSS_MASK 0xf
#define  SSP1_SSP_SSCR0_DSS_SHIFT 0
#define  SSP1_SSP_SSCR0_DSS_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR0_DSS_MASK) >> SSP1_SSP_SSCR0_DSS_SHIFT)
#define  SSP1_SSP_SSCR0_DSS_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR0_DSS_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR0_DSS_SHIFT))

//====================================================================
//Register: SSP Control Register 1 (SSP_SSCR1)
/** \brief These registers contain bit fields that control various SSP port functions. The
following table shows bit locations corresponding to control bit fields in
SSP_SSCR1. The reset state of all bits is shown, but must be set to the
preferred value before enabling the SSP port by setting the <Synchronous Serial
Port Enable> field in the SSP Control Register 0.
Write 0x0 to reserved bits, the read values of reserved bits are undetermined.*/
//====================================================================

#define  SSP1_SSP_SSCR1_TTELP_MASK 0x80000000
#define  SSP1_SSP_SSCR1_TTELP_SHIFT 31
#define  SSP1_SSP_SSCR1_TTELP_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_TTELP_MASK) >> SSP1_SSP_SSCR1_TTELP_SHIFT)
#define  SSP1_SSP_SSCR1_TTELP_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_TTELP_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_TTELP_SHIFT))

#define  SSP1_SSP_SSCR1_TTE_MASK 0x40000000
#define  SSP1_SSP_SSCR1_TTE_SHIFT 30
#define  SSP1_SSP_SSCR1_TTE_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_TTE_MASK) >> SSP1_SSP_SSCR1_TTE_SHIFT)
#define  SSP1_SSP_SSCR1_TTE_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_TTE_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_TTE_SHIFT))

#define  SSP1_SSP_SSCR1_EBCEI_MASK 0x20000000
#define  SSP1_SSP_SSCR1_EBCEI_SHIFT 29
#define  SSP1_SSP_SSCR1_EBCEI_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_EBCEI_MASK) >> SSP1_SSP_SSCR1_EBCEI_SHIFT)
#define  SSP1_SSP_SSCR1_EBCEI_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_EBCEI_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_EBCEI_SHIFT))

#define  SSP1_SSP_SSCR1_SCFR_MASK 0x10000000
#define  SSP1_SSP_SSCR1_SCFR_SHIFT 28
#define  SSP1_SSP_SSCR1_SCFR_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_SCFR_MASK) >> SSP1_SSP_SSCR1_SCFR_SHIFT)
#define  SSP1_SSP_SSCR1_SCFR_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_SCFR_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_SCFR_SHIFT))

#define  SSP1_SSP_SSCR1_ECRA_MASK 0x8000000
#define  SSP1_SSP_SSCR1_ECRA_SHIFT 27
#define  SSP1_SSP_SSCR1_ECRA_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_ECRA_MASK) >> SSP1_SSP_SSCR1_ECRA_SHIFT)
#define  SSP1_SSP_SSCR1_ECRA_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_ECRA_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_ECRA_SHIFT))

#define  SSP1_SSP_SSCR1_ECRB_MASK 0x4000000
#define  SSP1_SSP_SSCR1_ECRB_SHIFT 26
#define  SSP1_SSP_SSCR1_ECRB_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_ECRB_MASK) >> SSP1_SSP_SSCR1_ECRB_SHIFT)
#define  SSP1_SSP_SSCR1_ECRB_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_ECRB_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_ECRB_SHIFT))

#define  SSP1_SSP_SSCR1_SCLKDIR_MASK 0x2000000
#define  SSP1_SSP_SSCR1_SCLKDIR_SHIFT 25
#define  SSP1_SSP_SSCR1_SCLKDIR_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_SCLKDIR_MASK) >> SSP1_SSP_SSCR1_SCLKDIR_SHIFT)
#define  SSP1_SSP_SSCR1_SCLKDIR_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_SCLKDIR_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_SCLKDIR_SHIFT))

#define  SSP1_SSP_SSCR1_SFRMDIR_MASK 0x1000000
#define  SSP1_SSP_SSCR1_SFRMDIR_SHIFT 24
#define  SSP1_SSP_SSCR1_SFRMDIR_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_SFRMDIR_MASK) >> SSP1_SSP_SSCR1_SFRMDIR_SHIFT)
#define  SSP1_SSP_SSCR1_SFRMDIR_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_SFRMDIR_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_SFRMDIR_SHIFT))

#define  SSP1_SSP_SSCR1_RWOT_MASK 0x800000
#define  SSP1_SSP_SSCR1_RWOT_SHIFT 23
#define  SSP1_SSP_SSCR1_RWOT_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_RWOT_MASK) >> SSP1_SSP_SSCR1_RWOT_SHIFT)
#define  SSP1_SSP_SSCR1_RWOT_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_RWOT_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_RWOT_SHIFT))

#define  SSP1_SSP_SSCR1_TRAIL_MASK 0x400000
#define  SSP1_SSP_SSCR1_TRAIL_SHIFT 22
#define  SSP1_SSP_SSCR1_TRAIL_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_TRAIL_MASK) >> SSP1_SSP_SSCR1_TRAIL_SHIFT)
#define  SSP1_SSP_SSCR1_TRAIL_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_TRAIL_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_TRAIL_SHIFT))

#define  SSP1_SSP_SSCR1_TSRE_MASK 0x200000
#define  SSP1_SSP_SSCR1_TSRE_SHIFT 21
#define  SSP1_SSP_SSCR1_TSRE_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_TSRE_MASK) >> SSP1_SSP_SSCR1_TSRE_SHIFT)
#define  SSP1_SSP_SSCR1_TSRE_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_TSRE_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_TSRE_SHIFT))

#define  SSP1_SSP_SSCR1_RSRE_MASK 0x100000
#define  SSP1_SSP_SSCR1_RSRE_SHIFT 20
#define  SSP1_SSP_SSCR1_RSRE_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_RSRE_MASK) >> SSP1_SSP_SSCR1_RSRE_SHIFT)
#define  SSP1_SSP_SSCR1_RSRE_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_RSRE_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_RSRE_SHIFT))

#define  SSP1_SSP_SSCR1_TINTE_MASK 0x80000
#define  SSP1_SSP_SSCR1_TINTE_SHIFT 19
#define  SSP1_SSP_SSCR1_TINTE_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_TINTE_MASK) >> SSP1_SSP_SSCR1_TINTE_SHIFT)
#define  SSP1_SSP_SSCR1_TINTE_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_TINTE_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_TINTE_SHIFT))

#define  SSP1_SSP_SSCR1_PINTE_MASK 0x40000
#define  SSP1_SSP_SSCR1_PINTE_SHIFT 18
#define  SSP1_SSP_SSCR1_PINTE_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_PINTE_MASK) >> SSP1_SSP_SSCR1_PINTE_SHIFT)
#define  SSP1_SSP_SSCR1_PINTE_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_PINTE_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_PINTE_SHIFT))

#define  SSP1_SSP_SSCR1_FEN_MASK 0x20000
#define  SSP1_SSP_SSCR1_FEN_SHIFT 17
#define  SSP1_SSP_SSCR1_FEN_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_FEN_MASK) >> SSP1_SSP_SSCR1_FEN_SHIFT)
#define  SSP1_SSP_SSCR1_FEN_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_FEN_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_FEN_SHIFT))

#define  SSP1_SSP_SSCR1_IFS_MASK 0x10000
#define  SSP1_SSP_SSCR1_IFS_SHIFT 16
#define  SSP1_SSP_SSCR1_IFS_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_IFS_MASK) >> SSP1_SSP_SSCR1_IFS_SHIFT)
#define  SSP1_SSP_SSCR1_IFS_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_IFS_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_IFS_SHIFT))

#define  SSP1_SSP_SSCR1_STRF_MASK 0x8000
#define  SSP1_SSP_SSCR1_STRF_SHIFT 15
#define  SSP1_SSP_SSCR1_STRF_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_STRF_MASK) >> SSP1_SSP_SSCR1_STRF_SHIFT)
#define  SSP1_SSP_SSCR1_STRF_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_STRF_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_STRF_SHIFT))

#define  SSP1_SSP_SSCR1_EFWR_MASK 0x4000
#define  SSP1_SSP_SSCR1_EFWR_SHIFT 14
#define  SSP1_SSP_SSCR1_EFWR_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_EFWR_MASK) >> SSP1_SSP_SSCR1_EFWR_SHIFT)
#define  SSP1_SSP_SSCR1_EFWR_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_EFWR_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_EFWR_SHIFT))

#define  SSP1_SSP_SSCR1_RFT_MASK 0x3c00
#define  SSP1_SSP_SSCR1_RFT_SHIFT 10
#define  SSP1_SSP_SSCR1_RFT_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_RFT_MASK) >> SSP1_SSP_SSCR1_RFT_SHIFT)
#define  SSP1_SSP_SSCR1_RFT_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_RFT_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_RFT_SHIFT))

#define  SSP1_SSP_SSCR1_TFT_MASK 0x3c0
#define  SSP1_SSP_SSCR1_TFT_SHIFT 6
#define  SSP1_SSP_SSCR1_TFT_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_TFT_MASK) >> SSP1_SSP_SSCR1_TFT_SHIFT)
#define  SSP1_SSP_SSCR1_TFT_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_TFT_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_TFT_SHIFT))

#define  SSP1_SSP_SSCR1_MWDS_MASK 0x20
#define  SSP1_SSP_SSCR1_MWDS_SHIFT 5
#define  SSP1_SSP_SSCR1_MWDS_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_MWDS_MASK) >> SSP1_SSP_SSCR1_MWDS_SHIFT)
#define  SSP1_SSP_SSCR1_MWDS_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_MWDS_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_MWDS_SHIFT))

#define  SSP1_SSP_SSCR1_SPH_MASK 0x10
#define  SSP1_SSP_SSCR1_SPH_SHIFT 4
#define  SSP1_SSP_SSCR1_SPH_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_SPH_MASK) >> SSP1_SSP_SSCR1_SPH_SHIFT)
#define  SSP1_SSP_SSCR1_SPH_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_SPH_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_SPH_SHIFT))

#define  SSP1_SSP_SSCR1_SPO_MASK 0x8
#define  SSP1_SSP_SSCR1_SPO_SHIFT 3
#define  SSP1_SSP_SSCR1_SPO_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_SPO_MASK) >> SSP1_SSP_SSCR1_SPO_SHIFT)
#define  SSP1_SSP_SSCR1_SPO_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_SPO_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_SPO_SHIFT))

#define  SSP1_SSP_SSCR1_LBM_MASK 0x4
#define  SSP1_SSP_SSCR1_LBM_SHIFT 2
#define  SSP1_SSP_SSCR1_LBM_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_LBM_MASK) >> SSP1_SSP_SSCR1_LBM_SHIFT)
#define  SSP1_SSP_SSCR1_LBM_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_LBM_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_LBM_SHIFT))

#define  SSP1_SSP_SSCR1_TIE_MASK 0x2
#define  SSP1_SSP_SSCR1_TIE_SHIFT 1
#define  SSP1_SSP_SSCR1_TIE_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_TIE_MASK) >> SSP1_SSP_SSCR1_TIE_SHIFT)
#define  SSP1_SSP_SSCR1_TIE_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_TIE_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_TIE_SHIFT))

#define  SSP1_SSP_SSCR1_RIE_MASK 0x1
#define  SSP1_SSP_SSCR1_RIE_SHIFT 0
#define  SSP1_SSP_SSCR1_RIE_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSCR1_RIE_MASK) >> SSP1_SSP_SSCR1_RIE_SHIFT)
#define  SSP1_SSP_SSCR1_RIE_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSCR1_RIE_MASK) | (((uint32_t)val) << SSP1_SSP_SSCR1_RIE_SHIFT))

//====================================================================
//Register: SSP Status Register (SSP_SSSR)
/** \brief These registers contain bits that signal overrun errors as well as the TXFIFO
and RXFIFO service requests. Each of these hardware-detected events signals an
interrupt request to the interrupt controller, or a DMA request. The Status
register also contains flags that indicate if the SSPx port is actively
transmitting data, if the TXFIFO is not full, and if the RXFIFO is not empty.
A signal-interrupt signal is sent to the interrupt controller for each SSPx
port. These events can cause an interrupt request or a DMA request:
end-of-chain, receiver timeout, peripheral trailing byte, RXFIFO overrun, RXFIFO
service request, and TXFIFO service request.
Bits that cause an interrupt request remain set until they are cleared by
writing a 0x1 to each bit. Once a status bit is cleared, the interrupt is
cleared. Read-write bits are called status bits (status bits are referred to
as <q>sticky</q> and once set by hardware, they can only be cleared by writing
a 0x1 to each bit), read-only bits are called flags. Writing 0x1 to a sticky
status bit clears it, writing a 0x0 has no effect. Read-only flags are set
to 0x1 and are cleared automatically to 0x0 by hardware, and writes have no
effect. Some bits that cause interrupt requests have corresponding mask bits in
the control registers and are indicated in the following sections.
The following table shows the bit locations corresponding to the status and flag
bits within the SSP Port Status Register. All bits are read-only except
the <Receive FIFO Overrun>, <Peripheral Trailing Byte Interrupt>, <Transmit FIFO
Underrun>, <Bit Count Error>, <Receiver Time-out Interrupt>, and <End of Chain>,
which are all read-write. The reset state of read-write bits is 0x0 and all bits
return to their reset state when the <Synchronous Serial Port Enable> field in
the SSP Control Register 0 is cleared.
Write 0x0 to reserved bits, reads from reserved bits are undetermined.*/
//====================================================================

#define  SSP1_SSP_SSSR_OSS_MASK 0x80000000
#define  SSP1_SSP_SSSR_OSS_SHIFT 31
#define  SSP1_SSP_SSSR_OSS_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSSR_OSS_MASK) >> SSP1_SSP_SSSR_OSS_SHIFT)
#define  SSP1_SSP_SSSR_OSS_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSSR_OSS_MASK) | (((uint32_t)val) << SSP1_SSP_SSSR_OSS_SHIFT))

#define  SSP1_SSP_SSSR_TX_OSS_MASK 0x40000000
#define  SSP1_SSP_SSSR_TX_OSS_SHIFT 30
#define  SSP1_SSP_SSSR_TX_OSS_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSSR_TX_OSS_MASK) >> SSP1_SSP_SSSR_TX_OSS_SHIFT)
#define  SSP1_SSP_SSSR_TX_OSS_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSSR_TX_OSS_MASK) | (((uint32_t)val) << SSP1_SSP_SSSR_TX_OSS_SHIFT))

#define  SSP1_SSP_SSSR_RESERVED1_MASK 0x3f000000
#define  SSP1_SSP_SSSR_RESERVED1_SHIFT 24
#define  SSP1_SSP_SSSR_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSSR_RESERVED1_MASK) >> SSP1_SSP_SSSR_RESERVED1_SHIFT)
#define  SSP1_SSP_SSSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSSR_RESERVED1_MASK) | (((uint32_t)val) << SSP1_SSP_SSSR_RESERVED1_SHIFT))

#define  SSP1_SSP_SSSR_BCE_MASK 0x800000
#define  SSP1_SSP_SSSR_BCE_SHIFT 23
#define  SSP1_SSP_SSSR_BCE_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSSR_BCE_MASK) >> SSP1_SSP_SSSR_BCE_SHIFT)
#define  SSP1_SSP_SSSR_BCE_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSSR_BCE_MASK) | (((uint32_t)val) << SSP1_SSP_SSSR_BCE_SHIFT))

#define  SSP1_SSP_SSSR_CSS_MASK 0x400000
#define  SSP1_SSP_SSSR_CSS_SHIFT 22
#define  SSP1_SSP_SSSR_CSS_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSSR_CSS_MASK) >> SSP1_SSP_SSSR_CSS_SHIFT)
#define  SSP1_SSP_SSSR_CSS_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSSR_CSS_MASK) | (((uint32_t)val) << SSP1_SSP_SSSR_CSS_SHIFT))

#define  SSP1_SSP_SSSR_TUR_MASK 0x200000
#define  SSP1_SSP_SSSR_TUR_SHIFT 21
#define  SSP1_SSP_SSSR_TUR_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSSR_TUR_MASK) >> SSP1_SSP_SSSR_TUR_SHIFT)
#define  SSP1_SSP_SSSR_TUR_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSSR_TUR_MASK) | (((uint32_t)val) << SSP1_SSP_SSSR_TUR_SHIFT))

#define  SSP1_SSP_SSSR_EOC_MASK 0x100000
#define  SSP1_SSP_SSSR_EOC_SHIFT 20
#define  SSP1_SSP_SSSR_EOC_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSSR_EOC_MASK) >> SSP1_SSP_SSSR_EOC_SHIFT)
#define  SSP1_SSP_SSSR_EOC_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSSR_EOC_MASK) | (((uint32_t)val) << SSP1_SSP_SSSR_EOC_SHIFT))

#define  SSP1_SSP_SSSR_TINT_MASK 0x80000
#define  SSP1_SSP_SSSR_TINT_SHIFT 19
#define  SSP1_SSP_SSSR_TINT_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSSR_TINT_MASK) >> SSP1_SSP_SSSR_TINT_SHIFT)
#define  SSP1_SSP_SSSR_TINT_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSSR_TINT_MASK) | (((uint32_t)val) << SSP1_SSP_SSSR_TINT_SHIFT))

#define  SSP1_SSP_SSSR_PINT_MASK 0x40000
#define  SSP1_SSP_SSSR_PINT_SHIFT 18
#define  SSP1_SSP_SSSR_PINT_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSSR_PINT_MASK) >> SSP1_SSP_SSSR_PINT_SHIFT)
#define  SSP1_SSP_SSSR_PINT_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSSR_PINT_MASK) | (((uint32_t)val) << SSP1_SSP_SSSR_PINT_SHIFT))

#define  SSP1_SSP_SSSR_RESERVED2_MASK 0x30000
#define  SSP1_SSP_SSSR_RESERVED2_SHIFT 16
#define  SSP1_SSP_SSSR_RESERVED2_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSSR_RESERVED2_MASK) >> SSP1_SSP_SSSR_RESERVED2_SHIFT)
#define  SSP1_SSP_SSSR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSSR_RESERVED2_MASK) | (((uint32_t)val) << SSP1_SSP_SSSR_RESERVED2_SHIFT))

#define  SSP1_SSP_SSSR_RFL_MASK 0xf000
#define  SSP1_SSP_SSSR_RFL_SHIFT 12
#define  SSP1_SSP_SSSR_RFL_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSSR_RFL_MASK) >> SSP1_SSP_SSSR_RFL_SHIFT)
#define  SSP1_SSP_SSSR_RFL_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSSR_RFL_MASK) | (((uint32_t)val) << SSP1_SSP_SSSR_RFL_SHIFT))

#define  SSP1_SSP_SSSR_TFL_MASK 0xf00
#define  SSP1_SSP_SSSR_TFL_SHIFT 8
#define  SSP1_SSP_SSSR_TFL_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSSR_TFL_MASK) >> SSP1_SSP_SSSR_TFL_SHIFT)
#define  SSP1_SSP_SSSR_TFL_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSSR_TFL_MASK) | (((uint32_t)val) << SSP1_SSP_SSSR_TFL_SHIFT))

#define  SSP1_SSP_SSSR_ROR_MASK 0x80
#define  SSP1_SSP_SSSR_ROR_SHIFT 7
#define  SSP1_SSP_SSSR_ROR_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSSR_ROR_MASK) >> SSP1_SSP_SSSR_ROR_SHIFT)
#define  SSP1_SSP_SSSR_ROR_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSSR_ROR_MASK) | (((uint32_t)val) << SSP1_SSP_SSSR_ROR_SHIFT))

#define  SSP1_SSP_SSSR_RFS_MASK 0x40
#define  SSP1_SSP_SSSR_RFS_SHIFT 6
#define  SSP1_SSP_SSSR_RFS_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSSR_RFS_MASK) >> SSP1_SSP_SSSR_RFS_SHIFT)
#define  SSP1_SSP_SSSR_RFS_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSSR_RFS_MASK) | (((uint32_t)val) << SSP1_SSP_SSSR_RFS_SHIFT))

#define  SSP1_SSP_SSSR_TFS_MASK 0x20
#define  SSP1_SSP_SSSR_TFS_SHIFT 5
#define  SSP1_SSP_SSSR_TFS_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSSR_TFS_MASK) >> SSP1_SSP_SSSR_TFS_SHIFT)
#define  SSP1_SSP_SSSR_TFS_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSSR_TFS_MASK) | (((uint32_t)val) << SSP1_SSP_SSSR_TFS_SHIFT))

#define  SSP1_SSP_SSSR_BSY_MASK 0x10
#define  SSP1_SSP_SSSR_BSY_SHIFT 4
#define  SSP1_SSP_SSSR_BSY_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSSR_BSY_MASK) >> SSP1_SSP_SSSR_BSY_SHIFT)
#define  SSP1_SSP_SSSR_BSY_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSSR_BSY_MASK) | (((uint32_t)val) << SSP1_SSP_SSSR_BSY_SHIFT))

#define  SSP1_SSP_SSSR_RNE_MASK 0x8
#define  SSP1_SSP_SSSR_RNE_SHIFT 3
#define  SSP1_SSP_SSSR_RNE_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSSR_RNE_MASK) >> SSP1_SSP_SSSR_RNE_SHIFT)
#define  SSP1_SSP_SSSR_RNE_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSSR_RNE_MASK) | (((uint32_t)val) << SSP1_SSP_SSSR_RNE_SHIFT))

#define  SSP1_SSP_SSSR_TNF_MASK 0x4
#define  SSP1_SSP_SSSR_TNF_SHIFT 2
#define  SSP1_SSP_SSSR_TNF_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSSR_TNF_MASK) >> SSP1_SSP_SSSR_TNF_SHIFT)
#define  SSP1_SSP_SSSR_TNF_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSSR_TNF_MASK) | (((uint32_t)val) << SSP1_SSP_SSSR_TNF_SHIFT))

#define  SSP1_SSP_SSSR_RESERVED3_MASK 0x3
#define  SSP1_SSP_SSSR_RESERVED3_SHIFT 0
#define  SSP1_SSP_SSSR_RESERVED3_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSSR_RESERVED3_MASK) >> SSP1_SSP_SSSR_RESERVED3_SHIFT)
#define  SSP1_SSP_SSSR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSSR_RESERVED3_MASK) | (((uint32_t)val) << SSP1_SSP_SSSR_RESERVED3_SHIFT))

//====================================================================
//Register: SSP Interrupt Test Register (SSP_SSITR)
/** \brief Only use these read-write registers for testing purposes. The interrupt request
or DMA service request generated when one of these test bits is set remains
active until the test bit is cleared by writing 0x0. Setting any of these bits
to 0x1 also causes the corresponding status bit(s) to be set to 0x1 in the SSP
Status Register.
Write 0x0 to reserved bits, reads from reserved bits are undetermined.*/
//====================================================================

#define  SSP1_SSP_SSITR_RESERVED1_MASK 0xffffff00
#define  SSP1_SSP_SSITR_RESERVED1_SHIFT 8
#define  SSP1_SSP_SSITR_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSITR_RESERVED1_MASK) >> SSP1_SSP_SSITR_RESERVED1_SHIFT)
#define  SSP1_SSP_SSITR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSITR_RESERVED1_MASK) | (((uint32_t)val) << SSP1_SSP_SSITR_RESERVED1_SHIFT))

#define  SSP1_SSP_SSITR_TROR_MASK 0x80
#define  SSP1_SSP_SSITR_TROR_SHIFT 7
#define  SSP1_SSP_SSITR_TROR_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSITR_TROR_MASK) >> SSP1_SSP_SSITR_TROR_SHIFT)
#define  SSP1_SSP_SSITR_TROR_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSITR_TROR_MASK) | (((uint32_t)val) << SSP1_SSP_SSITR_TROR_SHIFT))

#define  SSP1_SSP_SSITR_TRFS_MASK 0x40
#define  SSP1_SSP_SSITR_TRFS_SHIFT 6
#define  SSP1_SSP_SSITR_TRFS_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSITR_TRFS_MASK) >> SSP1_SSP_SSITR_TRFS_SHIFT)
#define  SSP1_SSP_SSITR_TRFS_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSITR_TRFS_MASK) | (((uint32_t)val) << SSP1_SSP_SSITR_TRFS_SHIFT))

#define  SSP1_SSP_SSITR_TTFS_MASK 0x20
#define  SSP1_SSP_SSITR_TTFS_SHIFT 5
#define  SSP1_SSP_SSITR_TTFS_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSITR_TTFS_MASK) >> SSP1_SSP_SSITR_TTFS_SHIFT)
#define  SSP1_SSP_SSITR_TTFS_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSITR_TTFS_MASK) | (((uint32_t)val) << SSP1_SSP_SSITR_TTFS_SHIFT))

#define  SSP1_SSP_SSITR_RESERVED2_MASK 0x1f
#define  SSP1_SSP_SSITR_RESERVED2_SHIFT 0
#define  SSP1_SSP_SSITR_RESERVED2_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSITR_RESERVED2_MASK) >> SSP1_SSP_SSITR_RESERVED2_SHIFT)
#define  SSP1_SSP_SSITR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSITR_RESERVED2_MASK) | (((uint32_t)val) << SSP1_SSP_SSITR_RESERVED2_SHIFT))

//====================================================================
//Register: SSP Data Register (SSP_SSDR)
/** \brief These registers are each two physical registers that have a common address.
One SSDR_x is temporary storage for data that is transferred automatically
into the TXFIFO, the other SSDR_x is temporary storage for data that is
transferred automatically from the RXFIFO.
As programmed I/O or DMA access the SSDR_x, the TXFIFO or RXFIFO control
logic transfers data automatically between the SSDR_x and the FIFO as fast
as the system moves it. Data in the TXFIFO shifts up to accommodate new
data that is written to the SSDR_X, unless it is an attempted write to
a full TXFIFO. Data in the RXFIFO shifts down to accommodate data that is
read from the SSP Data Register. The <Transmit FIFO Level>, <Receive FIFO
Level>, <Receive FIFO Not Empty>, and <Transmit FIFO Not Full> fields in
the SSP Status Register show whether the FIFO is full, above/below
a programmable FIFO trigger threshold level, or empty.
When using programmed I/O, data can be written to the SSP Data Register
anytime the TXFIFO falls below its trigger threshold level.
When a data sample size of less than 32-bits or 16 bits for packed mode is
selected, software should right-justify the data that is written to the SSP
Data Register for automatic insertion into the TXFIFO. The transmit logic
left-justifies the data and ignores any unused bits. Received data of less
than 32 bits is right-justified automatically in the RXFIFO (thus, you
cannot perform a write in packed mode of less than 32 bits wide). The
TXFIFO and RXFIFO are cleared to 0x0 when the SSPx port is reset or
disabled (by writing a 0x0 to the <Synchronous Serial Port Enable> field in
the SSP Control Register 0).
The reset state of SSDR_x is undetermined. The following table shows the
location of the SSPx port SSDR_x.*/
//====================================================================

#define  SSP1_SSP_SSDR_DATA_MASK 0xffffffff
#define  SSP1_SSP_SSDR_DATA_SHIFT 0
#define  SSP1_SSP_SSDR_DATA_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSDR_DATA_MASK) >> SSP1_SSP_SSDR_DATA_SHIFT)
#define  SSP1_SSP_SSDR_DATA_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSDR_DATA_MASK) | (((uint32_t)val) << SSP1_SSP_SSDR_DATA_SHIFT))

//====================================================================
//Register: SSP Time Out Register (SSP_SSTO)
/** \brief These registers specify the timeout (TIMEOUT) value used to signal a period of
inactivity within the RXFIFO, see Timeout Section in the PXA2128 Datasheet. When
a timeout occurs, the <Receiver Time-out Interrupt> field in the SSP Status
Register is set. When the TIMEOUT value is set to 0x000000, no timeout occurs
and the <Receiver Time-out Interrupt> field is not set. The TIMEOUT interval is
given by the calculation in the TIMEOUT Interval Equation.
TIMEOUT Interval Equation
TimeOut Interval = <Timeout Value> / APB Clock Frequency
Note: APB Clock Frequency = 26 MHz
Write 0x0 to reserved bits, reads from reserved bits are undetermined.*/
//====================================================================

#define  SSP1_SSP_SSTO_RESERVED1_MASK 0xff000000
#define  SSP1_SSP_SSTO_RESERVED1_SHIFT 24
#define  SSP1_SSP_SSTO_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSTO_RESERVED1_MASK) >> SSP1_SSP_SSTO_RESERVED1_SHIFT)
#define  SSP1_SSP_SSTO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSTO_RESERVED1_MASK) | (((uint32_t)val) << SSP1_SSP_SSTO_RESERVED1_SHIFT))

#define  SSP1_SSP_SSTO_TIMEOUT_MASK 0xffffff
#define  SSP1_SSP_SSTO_TIMEOUT_SHIFT 0
#define  SSP1_SSP_SSTO_TIMEOUT_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSTO_TIMEOUT_MASK) >> SSP1_SSP_SSTO_TIMEOUT_SHIFT)
#define  SSP1_SSP_SSTO_TIMEOUT_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSTO_TIMEOUT_MASK) | (((uint32_t)val) << SSP1_SSP_SSTO_TIMEOUT_SHIFT))

//====================================================================
//Register: SSP Programmable Serial Protocol Register (SSP_SSPSP)
/** \brief These registers contain eight fields that program the various programmable
serial-protocol (PSP) parameters. When using Programmable Serial Protocol (PSP)
format in network mode, the parameters <Serial Frame Delay>, <Serial Frame
Delay>, <Start Delay>, <Dummy Stop>, <Extended Dummy Stop>, <Dummy Start>,
and <Extended Dummy Start> must be set to 0x0. The other parameters <Serial
Frame Polarity>, <Serial Bit-rate Clock Mode>, <Frame Sync Relative Timing Bit>,
and <Serial Frame Width> are programmable.
Writes 0b0 to reserved bits, reads from reserved bits are undetermined.*/
//====================================================================

#define  SSP1_SSP_SSPSP_RESERVED1_MASK 0x80000000
#define  SSP1_SSP_SSPSP_RESERVED1_SHIFT 31
#define  SSP1_SSP_SSPSP_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSPSP_RESERVED1_MASK) >> SSP1_SSP_SSPSP_RESERVED1_SHIFT)
#define  SSP1_SSP_SSPSP_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSPSP_RESERVED1_MASK) | (((uint32_t)val) << SSP1_SSP_SSPSP_RESERVED1_SHIFT))

#define  SSP1_SSP_SSPSP_EDMYSTOP_MASK 0x70000000
#define  SSP1_SSP_SSPSP_EDMYSTOP_SHIFT 28
#define  SSP1_SSP_SSPSP_EDMYSTOP_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSPSP_EDMYSTOP_MASK) >> SSP1_SSP_SSPSP_EDMYSTOP_SHIFT)
#define  SSP1_SSP_SSPSP_EDMYSTOP_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSPSP_EDMYSTOP_MASK) | (((uint32_t)val) << SSP1_SSP_SSPSP_EDMYSTOP_SHIFT))

#define  SSP1_SSP_SSPSP_EDMYSTRT_MASK 0xc000000
#define  SSP1_SSP_SSPSP_EDMYSTRT_SHIFT 26
#define  SSP1_SSP_SSPSP_EDMYSTRT_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSPSP_EDMYSTRT_MASK) >> SSP1_SSP_SSPSP_EDMYSTRT_SHIFT)
#define  SSP1_SSP_SSPSP_EDMYSTRT_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSPSP_EDMYSTRT_MASK) | (((uint32_t)val) << SSP1_SSP_SSPSP_EDMYSTRT_SHIFT))

#define  SSP1_SSP_SSPSP_FSRT_MASK 0x2000000
#define  SSP1_SSP_SSPSP_FSRT_SHIFT 25
#define  SSP1_SSP_SSPSP_FSRT_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSPSP_FSRT_MASK) >> SSP1_SSP_SSPSP_FSRT_SHIFT)
#define  SSP1_SSP_SSPSP_FSRT_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSPSP_FSRT_MASK) | (((uint32_t)val) << SSP1_SSP_SSPSP_FSRT_SHIFT))

#define  SSP1_SSP_SSPSP_DMYSTOP_MASK 0x1800000
#define  SSP1_SSP_SSPSP_DMYSTOP_SHIFT 23
#define  SSP1_SSP_SSPSP_DMYSTOP_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSPSP_DMYSTOP_MASK) >> SSP1_SSP_SSPSP_DMYSTOP_SHIFT)
#define  SSP1_SSP_SSPSP_DMYSTOP_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSPSP_DMYSTOP_MASK) | (((uint32_t)val) << SSP1_SSP_SSPSP_DMYSTOP_SHIFT))

#define  SSP1_SSP_SSPSP_RESERVED2_MASK 0x400000
#define  SSP1_SSP_SSPSP_RESERVED2_SHIFT 22
#define  SSP1_SSP_SSPSP_RESERVED2_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSPSP_RESERVED2_MASK) >> SSP1_SSP_SSPSP_RESERVED2_SHIFT)
#define  SSP1_SSP_SSPSP_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSPSP_RESERVED2_MASK) | (((uint32_t)val) << SSP1_SSP_SSPSP_RESERVED2_SHIFT))

#define  SSP1_SSP_SSPSP_SFRMWDTH_MASK 0x3f0000
#define  SSP1_SSP_SSPSP_SFRMWDTH_SHIFT 16
#define  SSP1_SSP_SSPSP_SFRMWDTH_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSPSP_SFRMWDTH_MASK) >> SSP1_SSP_SSPSP_SFRMWDTH_SHIFT)
#define  SSP1_SSP_SSPSP_SFRMWDTH_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSPSP_SFRMWDTH_MASK) | (((uint32_t)val) << SSP1_SSP_SSPSP_SFRMWDTH_SHIFT))

#define  SSP1_SSP_SSPSP_SFRMDLY_MASK 0xfe00
#define  SSP1_SSP_SSPSP_SFRMDLY_SHIFT 9
#define  SSP1_SSP_SSPSP_SFRMDLY_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSPSP_SFRMDLY_MASK) >> SSP1_SSP_SSPSP_SFRMDLY_SHIFT)
#define  SSP1_SSP_SSPSP_SFRMDLY_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSPSP_SFRMDLY_MASK) | (((uint32_t)val) << SSP1_SSP_SSPSP_SFRMDLY_SHIFT))

#define  SSP1_SSP_SSPSP_DMYSTRT_MASK 0x180
#define  SSP1_SSP_SSPSP_DMYSTRT_SHIFT 7
#define  SSP1_SSP_SSPSP_DMYSTRT_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSPSP_DMYSTRT_MASK) >> SSP1_SSP_SSPSP_DMYSTRT_SHIFT)
#define  SSP1_SSP_SSPSP_DMYSTRT_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSPSP_DMYSTRT_MASK) | (((uint32_t)val) << SSP1_SSP_SSPSP_DMYSTRT_SHIFT))

#define  SSP1_SSP_SSPSP_STRTDLY_MASK 0x70
#define  SSP1_SSP_SSPSP_STRTDLY_SHIFT 4
#define  SSP1_SSP_SSPSP_STRTDLY_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSPSP_STRTDLY_MASK) >> SSP1_SSP_SSPSP_STRTDLY_SHIFT)
#define  SSP1_SSP_SSPSP_STRTDLY_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSPSP_STRTDLY_MASK) | (((uint32_t)val) << SSP1_SSP_SSPSP_STRTDLY_SHIFT))

#define  SSP1_SSP_SSPSP_ETDS_MASK 0x8
#define  SSP1_SSP_SSPSP_ETDS_SHIFT 3
#define  SSP1_SSP_SSPSP_ETDS_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSPSP_ETDS_MASK) >> SSP1_SSP_SSPSP_ETDS_SHIFT)
#define  SSP1_SSP_SSPSP_ETDS_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSPSP_ETDS_MASK) | (((uint32_t)val) << SSP1_SSP_SSPSP_ETDS_SHIFT))

#define  SSP1_SSP_SSPSP_SFRMP_MASK 0x4
#define  SSP1_SSP_SSPSP_SFRMP_SHIFT 2
#define  SSP1_SSP_SSPSP_SFRMP_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSPSP_SFRMP_MASK) >> SSP1_SSP_SSPSP_SFRMP_SHIFT)
#define  SSP1_SSP_SSPSP_SFRMP_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSPSP_SFRMP_MASK) | (((uint32_t)val) << SSP1_SSP_SSPSP_SFRMP_SHIFT))

#define  SSP1_SSP_SSPSP_SCMODE_MASK 0x3
#define  SSP1_SSP_SSPSP_SCMODE_SHIFT 0
#define  SSP1_SSP_SSPSP_SCMODE_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSPSP_SCMODE_MASK) >> SSP1_SSP_SSPSP_SCMODE_SHIFT)
#define  SSP1_SSP_SSPSP_SCMODE_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSPSP_SCMODE_MASK) | (((uint32_t)val) << SSP1_SSP_SSPSP_SCMODE_SHIFT))

//====================================================================
//Register: SSP TX Time Slot Active Register (SSP_SSTSA)
/** \brief These read-write registers are only used in network mode (<Mode> in SSP Control
Register 0 set), and they specify in which time slot the SSPx port transmits
data. See Network Mode (Example Using 4 Time Slots) figure for an example of the
use of time slots when in network mode.
The 8-bit <TX Time Slot Active> field specifies in which time slots the SSPx
port transmits data and in which time slots the SSPx port does NOT transmit
data. Bits beyond the <Frame Rate Divider Control> field in the SSP Control
Register 0 value are ignored (for example, if <Frame Rate Divider
Control> = 0x3, specifying that four time slots are used, then <TX Time Slot
Active> bits [7:4] are ignored). If the <TXD Three-State Enable> field in the
SSP Control Register 1 is set, the SSPx port three-states the SSPTXDx interface
output signal line during time slots that have associated TTSA bits programmed
to 0x0.
Write 0x0 to reserved bits, reads from reserved bits are undetermined.*/
//====================================================================

#define  SSP1_SSP_SSTSA_RESERVED1_MASK 0xffffff00
#define  SSP1_SSP_SSTSA_RESERVED1_SHIFT 8
#define  SSP1_SSP_SSTSA_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSTSA_RESERVED1_MASK) >> SSP1_SSP_SSTSA_RESERVED1_SHIFT)
#define  SSP1_SSP_SSTSA_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSTSA_RESERVED1_MASK) | (((uint32_t)val) << SSP1_SSP_SSTSA_RESERVED1_SHIFT))

#define  SSP1_SSP_SSTSA_TTSA_MASK 0xff
#define  SSP1_SSP_SSTSA_TTSA_SHIFT 0
#define  SSP1_SSP_SSTSA_TTSA_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSTSA_TTSA_MASK) >> SSP1_SSP_SSTSA_TTSA_SHIFT)
#define  SSP1_SSP_SSTSA_TTSA_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSTSA_TTSA_MASK) | (((uint32_t)val) << SSP1_SSP_SSTSA_TTSA_SHIFT))

//====================================================================
//Register: SSP RX Time Slot Active Register (SSP_SSRSA)
/** \brief These read-write registers are only used in network mode (<Mode> in SSP Control
Register 0 set), and they specify in which time slot the SSPx port receives
data. See Network Mode (Example Using 4 Time Slots) figure for an example of the
use of time slots when in network mode.
The 8-bit <RX Time Slot Active> field specifies in which time slots the SSPx
port receives data and in which time slots the SSPx port does not receive data.
Bits beyond the <Frame Rate Divider Control> field in the SSP Control Register 0
value are ignored. For example, if <Frame Rate Divider Control> = 0x3,
specifying that four time slots are used, then <RX Time Slot Active> bits [7:4]
are ignored.
Write 0x0 to reserved bits, reads from reserved bits are undetermined.*/
//====================================================================

#define  SSP1_SSP_SSRSA_RESERVED1_MASK 0xffffff00
#define  SSP1_SSP_SSRSA_RESERVED1_SHIFT 8
#define  SSP1_SSP_SSRSA_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSRSA_RESERVED1_MASK) >> SSP1_SSP_SSRSA_RESERVED1_SHIFT)
#define  SSP1_SSP_SSRSA_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSRSA_RESERVED1_MASK) | (((uint32_t)val) << SSP1_SSP_SSRSA_RESERVED1_SHIFT))

#define  SSP1_SSP_SSRSA_RTSA_MASK 0xff
#define  SSP1_SSP_SSRSA_RTSA_SHIFT 0
#define  SSP1_SSP_SSRSA_RTSA_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSRSA_RTSA_MASK) >> SSP1_SSP_SSRSA_RTSA_SHIFT)
#define  SSP1_SSP_SSRSA_RTSA_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSRSA_RTSA_MASK) | (((uint32_t)val) << SSP1_SSP_SSRSA_RTSA_SHIFT))

//====================================================================
//Register: SSP Time Slot Status Register (SSP_SSTSS)
/** \brief These read-only registers are only available when in network mode (<Mode> in SSP
Control Register 0 set), and they identify the time slot in which the SSPx port
is operating.
Write 0x0 to reserved bits, reads from reserved bits are undetermined.*/
//====================================================================

#define  SSP1_SSP_SSTSS_NMBSY_MASK 0x80000000
#define  SSP1_SSP_SSTSS_NMBSY_SHIFT 31
#define  SSP1_SSP_SSTSS_NMBSY_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSTSS_NMBSY_MASK) >> SSP1_SSP_SSTSS_NMBSY_SHIFT)
#define  SSP1_SSP_SSTSS_NMBSY_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSTSS_NMBSY_MASK) | (((uint32_t)val) << SSP1_SSP_SSTSS_NMBSY_SHIFT))

#define  SSP1_SSP_SSTSS_RESERVED1_MASK 0x7ffffff8
#define  SSP1_SSP_SSTSS_RESERVED1_SHIFT 3
#define  SSP1_SSP_SSTSS_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSTSS_RESERVED1_MASK) >> SSP1_SSP_SSTSS_RESERVED1_SHIFT)
#define  SSP1_SSP_SSTSS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSTSS_RESERVED1_MASK) | (((uint32_t)val) << SSP1_SSP_SSTSS_RESERVED1_SHIFT))

#define  SSP1_SSP_SSTSS_TSS_MASK 0x7
#define  SSP1_SSP_SSTSS_TSS_SHIFT 0
#define  SSP1_SSP_SSTSS_TSS_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SSTSS_TSS_MASK) >> SSP1_SSP_SSTSS_TSS_SHIFT)
#define  SSP1_SSP_SSTSS_TSS_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SSTSS_TSS_MASK) | (((uint32_t)val) << SSP1_SSP_SSTSS_TSS_SHIFT))

//====================================================================
//Register: GPS Controller ID Register (SSP_GPS_ID)
//====================================================================

#define  SSP1_SSP_GPS_ID_GPS_ID_MASK 0xffffffff
#define  SSP1_SSP_GPS_ID_GPS_ID_SHIFT 0
#define  SSP1_SSP_GPS_ID_GPS_ID_MASK_SHIFT(reg) (((reg) & SSP1_SSP_GPS_ID_GPS_ID_MASK) >> SSP1_SSP_GPS_ID_GPS_ID_SHIFT)
#define  SSP1_SSP_GPS_ID_GPS_ID_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_GPS_ID_GPS_ID_MASK) | (((uint32_t)val) << SSP1_SSP_GPS_ID_GPS_ID_SHIFT))

//====================================================================
//Register: GPS Control and Status Register (SSP_GPS_CSR)
//====================================================================

#define  SSP1_SSP_GPS_CSR_RESERVED1_MASK 0xffffe000
#define  SSP1_SSP_GPS_CSR_RESERVED1_SHIFT 13
#define  SSP1_SSP_GPS_CSR_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP1_SSP_GPS_CSR_RESERVED1_MASK) >> SSP1_SSP_GPS_CSR_RESERVED1_SHIFT)
#define  SSP1_SSP_GPS_CSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_GPS_CSR_RESERVED1_MASK) | (((uint32_t)val) << SSP1_SSP_GPS_CSR_RESERVED1_SHIFT))

#define  SSP1_SSP_GPS_CSR_LSB_1ST_MASK 0x1000
#define  SSP1_SSP_GPS_CSR_LSB_1ST_SHIFT 12
#define  SSP1_SSP_GPS_CSR_LSB_1ST_MASK_SHIFT(reg) (((reg) & SSP1_SSP_GPS_CSR_LSB_1ST_MASK) >> SSP1_SSP_GPS_CSR_LSB_1ST_SHIFT)
#define  SSP1_SSP_GPS_CSR_LSB_1ST_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_GPS_CSR_LSB_1ST_MASK) | (((uint32_t)val) << SSP1_SSP_GPS_CSR_LSB_1ST_SHIFT))

#define  SSP1_SSP_GPS_CSR_SERCLK_FEDGE_MASK 0x800
#define  SSP1_SSP_GPS_CSR_SERCLK_FEDGE_SHIFT 11
#define  SSP1_SSP_GPS_CSR_SERCLK_FEDGE_MASK_SHIFT(reg) (((reg) & SSP1_SSP_GPS_CSR_SERCLK_FEDGE_MASK) >> SSP1_SSP_GPS_CSR_SERCLK_FEDGE_SHIFT)
#define  SSP1_SSP_GPS_CSR_SERCLK_FEDGE_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_GPS_CSR_SERCLK_FEDGE_MASK) | (((uint32_t)val) << SSP1_SSP_GPS_CSR_SERCLK_FEDGE_SHIFT))

#define  SSP1_SSP_GPS_CSR_FS_SEL1_0_MASK 0x600
#define  SSP1_SSP_GPS_CSR_FS_SEL1_0_SHIFT 9
#define  SSP1_SSP_GPS_CSR_FS_SEL1_0_MASK_SHIFT(reg) (((reg) & SSP1_SSP_GPS_CSR_FS_SEL1_0_MASK) >> SSP1_SSP_GPS_CSR_FS_SEL1_0_SHIFT)
#define  SSP1_SSP_GPS_CSR_FS_SEL1_0_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_GPS_CSR_FS_SEL1_0_MASK) | (((uint32_t)val) << SSP1_SSP_GPS_CSR_FS_SEL1_0_SHIFT))

#define  SSP1_SSP_GPS_CSR_MAX_STRMBITS_MASK 0x180
#define  SSP1_SSP_GPS_CSR_MAX_STRMBITS_SHIFT 7
#define  SSP1_SSP_GPS_CSR_MAX_STRMBITS_MASK_SHIFT(reg) (((reg) & SSP1_SSP_GPS_CSR_MAX_STRMBITS_MASK) >> SSP1_SSP_GPS_CSR_MAX_STRMBITS_SHIFT)
#define  SSP1_SSP_GPS_CSR_MAX_STRMBITS_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_GPS_CSR_MAX_STRMBITS_MASK) | (((uint32_t)val) << SSP1_SSP_GPS_CSR_MAX_STRMBITS_SHIFT))

#define  SSP1_SSP_GPS_CSR_GPS_TYPE_MASK 0x70
#define  SSP1_SSP_GPS_CSR_GPS_TYPE_SHIFT 4
#define  SSP1_SSP_GPS_CSR_GPS_TYPE_MASK_SHIFT(reg) (((reg) & SSP1_SSP_GPS_CSR_GPS_TYPE_MASK) >> SSP1_SSP_GPS_CSR_GPS_TYPE_SHIFT)
#define  SSP1_SSP_GPS_CSR_GPS_TYPE_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_GPS_CSR_GPS_TYPE_MASK) | (((uint32_t)val) << SSP1_SSP_GPS_CSR_GPS_TYPE_SHIFT))

#define  SSP1_SSP_GPS_CSR_TSYNC_COUNT_RST_MASK 0x8
#define  SSP1_SSP_GPS_CSR_TSYNC_COUNT_RST_SHIFT 3
#define  SSP1_SSP_GPS_CSR_TSYNC_COUNT_RST_MASK_SHIFT(reg) (((reg) & SSP1_SSP_GPS_CSR_TSYNC_COUNT_RST_MASK) >> SSP1_SSP_GPS_CSR_TSYNC_COUNT_RST_SHIFT)
#define  SSP1_SSP_GPS_CSR_TSYNC_COUNT_RST_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_GPS_CSR_TSYNC_COUNT_RST_MASK) | (((uint32_t)val) << SSP1_SSP_GPS_CSR_TSYNC_COUNT_RST_SHIFT))

#define  SSP1_SSP_GPS_CSR_SOFT_RESET_MASK 0x4
#define  SSP1_SSP_GPS_CSR_SOFT_RESET_SHIFT 2
#define  SSP1_SSP_GPS_CSR_SOFT_RESET_MASK_SHIFT(reg) (((reg) & SSP1_SSP_GPS_CSR_SOFT_RESET_MASK) >> SSP1_SSP_GPS_CSR_SOFT_RESET_SHIFT)
#define  SSP1_SSP_GPS_CSR_SOFT_RESET_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_GPS_CSR_SOFT_RESET_MASK) | (((uint32_t)val) << SSP1_SSP_GPS_CSR_SOFT_RESET_SHIFT))

#define  SSP1_SSP_GPS_CSR_GPS_ON_MASK 0x2
#define  SSP1_SSP_GPS_CSR_GPS_ON_SHIFT 1
#define  SSP1_SSP_GPS_CSR_GPS_ON_MASK_SHIFT(reg) (((reg) & SSP1_SSP_GPS_CSR_GPS_ON_MASK) >> SSP1_SSP_GPS_CSR_GPS_ON_SHIFT)
#define  SSP1_SSP_GPS_CSR_GPS_ON_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_GPS_CSR_GPS_ON_MASK) | (((uint32_t)val) << SSP1_SSP_GPS_CSR_GPS_ON_SHIFT))

#define  SSP1_SSP_GPS_CSR_GPS_MODE_MASK 0x1
#define  SSP1_SSP_GPS_CSR_GPS_MODE_SHIFT 0
#define  SSP1_SSP_GPS_CSR_GPS_MODE_MASK_SHIFT(reg) (((reg) & SSP1_SSP_GPS_CSR_GPS_MODE_MASK) >> SSP1_SSP_GPS_CSR_GPS_MODE_SHIFT)
#define  SSP1_SSP_GPS_CSR_GPS_MODE_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_GPS_CSR_GPS_MODE_MASK) | (((uint32_t)val) << SSP1_SSP_GPS_CSR_GPS_MODE_SHIFT))

//====================================================================
//Register: Time Sync Count Register (SSP_GPS_TSCNT)
/** \brief This is the counter that is used to increment at each TIME_SYNC rising edge of
MAX2769.*/
//====================================================================

#define  SSP1_SSP_GPS_TSCNT_GPS_TSCNT_MASK 0xffffffff
#define  SSP1_SSP_GPS_TSCNT_GPS_TSCNT_SHIFT 0
#define  SSP1_SSP_GPS_TSCNT_GPS_TSCNT_MASK_SHIFT(reg) (((reg) & SSP1_SSP_GPS_TSCNT_GPS_TSCNT_MASK) >> SSP1_SSP_GPS_TSCNT_GPS_TSCNT_SHIFT)
#define  SSP1_SSP_GPS_TSCNT_GPS_TSCNT_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_GPS_TSCNT_GPS_TSCNT_MASK) | (((uint32_t)val) << SSP1_SSP_GPS_TSCNT_GPS_TSCNT_SHIFT))

//====================================================================
//Register: Time Sync Count Adjust Register (SSP_GPS_TSCNT_ADJ)
/** \brief This register is updated with the contents of the Time Sync Count Register
whenever the Rx FIFO is read by the system. DMA access should read this
register. This register is adjusted to eliminate DMA delay.*/
//====================================================================

#define  SSP1_SSP_GPS_TSCNT_ADJ_GPS_TSCNT_ADJ_MASK 0xffffffff
#define  SSP1_SSP_GPS_TSCNT_ADJ_GPS_TSCNT_ADJ_SHIFT 0
#define  SSP1_SSP_GPS_TSCNT_ADJ_GPS_TSCNT_ADJ_MASK_SHIFT(reg) (((reg) & SSP1_SSP_GPS_TSCNT_ADJ_GPS_TSCNT_ADJ_MASK) >> SSP1_SSP_GPS_TSCNT_ADJ_GPS_TSCNT_ADJ_SHIFT)
#define  SSP1_SSP_GPS_TSCNT_ADJ_GPS_TSCNT_ADJ_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_GPS_TSCNT_ADJ_GPS_TSCNT_ADJ_MASK) | (((uint32_t)val) << SSP1_SSP_GPS_TSCNT_ADJ_GPS_TSCNT_ADJ_SHIFT))

//====================================================================
//Register: Modified SPI Mode Register (SSP_SPI_MOD)
/** \brief This is the register holding the enable bit for modified SPI.*/
//====================================================================

#define  SSP1_SSP_SPI_MOD_RESERVED1_MASK 0xfffffffe
#define  SSP1_SSP_SPI_MOD_RESERVED1_SHIFT 1
#define  SSP1_SSP_SPI_MOD_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SPI_MOD_RESERVED1_MASK) >> SSP1_SSP_SPI_MOD_RESERVED1_SHIFT)
#define  SSP1_SSP_SPI_MOD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SPI_MOD_RESERVED1_MASK) | (((uint32_t)val) << SSP1_SSP_SPI_MOD_RESERVED1_SHIFT))

#define  SSP1_SSP_SPI_MOD_SPI_MOD_MASK 0x1
#define  SSP1_SSP_SPI_MOD_SPI_MOD_SHIFT 0
#define  SSP1_SSP_SPI_MOD_SPI_MOD_MASK_SHIFT(reg) (((reg) & SSP1_SSP_SPI_MOD_SPI_MOD_MASK) >> SSP1_SSP_SPI_MOD_SPI_MOD_SHIFT)
#define  SSP1_SSP_SPI_MOD_SPI_MOD_REPLACE_VAL(reg,val) (((reg) & ~SSP1_SSP_SPI_MOD_SPI_MOD_MASK) | (((uint32_t)val) << SSP1_SSP_SPI_MOD_SPI_MOD_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  SSP1_REV0_MAJ_MASK 0xffff0000
#define  SSP1_REV0_MAJ_SHIFT 16
#define  SSP1_REV0_MAJ_MASK_SHIFT(reg) (((reg) & SSP1_REV0_MAJ_MASK) >> SSP1_REV0_MAJ_SHIFT)
#define  SSP1_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~SSP1_REV0_MAJ_MASK) | (((uint32_t)val) << SSP1_REV0_MAJ_SHIFT))

#define  SSP1_REV0_MID_MASK 0xffff
#define  SSP1_REV0_MID_SHIFT 0
#define  SSP1_REV0_MID_MASK_SHIFT(reg) (((reg) & SSP1_REV0_MID_MASK) >> SSP1_REV0_MID_SHIFT)
#define  SSP1_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~SSP1_REV0_MID_MASK) | (((uint32_t)val) << SSP1_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  SSP1_REV1_RESERVED1_MASK 0xffff0000
#define  SSP1_REV1_RESERVED1_SHIFT 16
#define  SSP1_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP1_REV1_RESERVED1_MASK) >> SSP1_REV1_RESERVED1_SHIFT)
#define  SSP1_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP1_REV1_RESERVED1_MASK) | (((uint32_t)val) << SSP1_REV1_RESERVED1_SHIFT))

#define  SSP1_REV1_CFG_MASK 0xffff
#define  SSP1_REV1_CFG_SHIFT 0
#define  SSP1_REV1_CFG_MASK_SHIFT(reg) (((reg) & SSP1_REV1_CFG_MASK) >> SSP1_REV1_CFG_SHIFT)
#define  SSP1_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~SSP1_REV1_CFG_MASK) | (((uint32_t)val) << SSP1_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: SSP Registers (Instance 3 of 3) (SSP2)
//
//====================================================================

//====================================================================
//Register: SSP Control Register 0 (SSP_SSCR0)
/** \brief These registers contain bit fields that control various functions within the SSP
port. The following table shows the bit locations corresponding to the different
control bit fields within the SSP Control 0 Register. The reset state of all
bits are as shown, but they must be programmed to their preferred values before
enabling the SSP port.
Writes to reserved bits must be 0x0, and read values of reserved bits are
undefined.*/
//====================================================================

#define  SSP2_SSP_SSCR0_MOD_MASK 0x80000000
#define  SSP2_SSP_SSCR0_MOD_SHIFT 31
#define  SSP2_SSP_SSCR0_MOD_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR0_MOD_MASK) >> SSP2_SSP_SSCR0_MOD_SHIFT)
#define  SSP2_SSP_SSCR0_MOD_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR0_MOD_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR0_MOD_SHIFT))

#define  SSP2_SSP_SSCR0_RESERVED1_MASK 0x40000000
#define  SSP2_SSP_SSCR0_RESERVED1_SHIFT 30
#define  SSP2_SSP_SSCR0_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR0_RESERVED1_MASK) >> SSP2_SSP_SSCR0_RESERVED1_SHIFT)
#define  SSP2_SSP_SSCR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR0_RESERVED1_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR0_RESERVED1_SHIFT))

#define  SSP2_SSP_SSCR0_FPCKE_MASK 0x20000000
#define  SSP2_SSP_SSCR0_FPCKE_SHIFT 29
#define  SSP2_SSP_SSCR0_FPCKE_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR0_FPCKE_MASK) >> SSP2_SSP_SSCR0_FPCKE_SHIFT)
#define  SSP2_SSP_SSCR0_FPCKE_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR0_FPCKE_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR0_FPCKE_SHIFT))

#define  SSP2_SSP_SSCR0_FCTRL_MASK 0x10000000
#define  SSP2_SSP_SSCR0_FCTRL_SHIFT 28
#define  SSP2_SSP_SSCR0_FCTRL_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR0_FCTRL_MASK) >> SSP2_SSP_SSCR0_FCTRL_SHIFT)
#define  SSP2_SSP_SSCR0_FCTRL_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR0_FCTRL_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR0_FCTRL_SHIFT))

#define  SSP2_SSP_SSCR0_RESERVED2_MASK 0x8000000
#define  SSP2_SSP_SSCR0_RESERVED2_SHIFT 27
#define  SSP2_SSP_SSCR0_RESERVED2_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR0_RESERVED2_MASK) >> SSP2_SSP_SSCR0_RESERVED2_SHIFT)
#define  SSP2_SSP_SSCR0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR0_RESERVED2_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR0_RESERVED2_SHIFT))

#define  SSP2_SSP_SSCR0_FRDC_MASK 0x7000000
#define  SSP2_SSP_SSCR0_FRDC_SHIFT 24
#define  SSP2_SSP_SSCR0_FRDC_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR0_FRDC_MASK) >> SSP2_SSP_SSCR0_FRDC_SHIFT)
#define  SSP2_SSP_SSCR0_FRDC_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR0_FRDC_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR0_FRDC_SHIFT))

#define  SSP2_SSP_SSCR0_TIM_MASK 0x800000
#define  SSP2_SSP_SSCR0_TIM_SHIFT 23
#define  SSP2_SSP_SSCR0_TIM_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR0_TIM_MASK) >> SSP2_SSP_SSCR0_TIM_SHIFT)
#define  SSP2_SSP_SSCR0_TIM_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR0_TIM_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR0_TIM_SHIFT))

#define  SSP2_SSP_SSCR0_RIM_MASK 0x400000
#define  SSP2_SSP_SSCR0_RIM_SHIFT 22
#define  SSP2_SSP_SSCR0_RIM_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR0_RIM_MASK) >> SSP2_SSP_SSCR0_RIM_SHIFT)
#define  SSP2_SSP_SSCR0_RIM_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR0_RIM_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR0_RIM_SHIFT))

#define  SSP2_SSP_SSCR0_RESERVED3_MASK 0x200000
#define  SSP2_SSP_SSCR0_RESERVED3_SHIFT 21
#define  SSP2_SSP_SSCR0_RESERVED3_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR0_RESERVED3_MASK) >> SSP2_SSP_SSCR0_RESERVED3_SHIFT)
#define  SSP2_SSP_SSCR0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR0_RESERVED3_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR0_RESERVED3_SHIFT))

#define  SSP2_SSP_SSCR0_EDSS_MASK 0x100000
#define  SSP2_SSP_SSCR0_EDSS_SHIFT 20
#define  SSP2_SSP_SSCR0_EDSS_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR0_EDSS_MASK) >> SSP2_SSP_SSCR0_EDSS_SHIFT)
#define  SSP2_SSP_SSCR0_EDSS_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR0_EDSS_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR0_EDSS_SHIFT))

#define  SSP2_SSP_SSCR0_RESERVED4_MASK 0xfff00
#define  SSP2_SSP_SSCR0_RESERVED4_SHIFT 8
#define  SSP2_SSP_SSCR0_RESERVED4_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR0_RESERVED4_MASK) >> SSP2_SSP_SSCR0_RESERVED4_SHIFT)
#define  SSP2_SSP_SSCR0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR0_RESERVED4_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR0_RESERVED4_SHIFT))

#define  SSP2_SSP_SSCR0_SSE_MASK 0x80
#define  SSP2_SSP_SSCR0_SSE_SHIFT 7
#define  SSP2_SSP_SSCR0_SSE_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR0_SSE_MASK) >> SSP2_SSP_SSCR0_SSE_SHIFT)
#define  SSP2_SSP_SSCR0_SSE_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR0_SSE_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR0_SSE_SHIFT))

#define  SSP2_SSP_SSCR0_RESERVED5_MASK 0x40
#define  SSP2_SSP_SSCR0_RESERVED5_SHIFT 6
#define  SSP2_SSP_SSCR0_RESERVED5_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR0_RESERVED5_MASK) >> SSP2_SSP_SSCR0_RESERVED5_SHIFT)
#define  SSP2_SSP_SSCR0_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR0_RESERVED5_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR0_RESERVED5_SHIFT))

#define  SSP2_SSP_SSCR0_FRF_MASK 0x30
#define  SSP2_SSP_SSCR0_FRF_SHIFT 4
#define  SSP2_SSP_SSCR0_FRF_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR0_FRF_MASK) >> SSP2_SSP_SSCR0_FRF_SHIFT)
#define  SSP2_SSP_SSCR0_FRF_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR0_FRF_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR0_FRF_SHIFT))

#define  SSP2_SSP_SSCR0_DSS_MASK 0xf
#define  SSP2_SSP_SSCR0_DSS_SHIFT 0
#define  SSP2_SSP_SSCR0_DSS_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR0_DSS_MASK) >> SSP2_SSP_SSCR0_DSS_SHIFT)
#define  SSP2_SSP_SSCR0_DSS_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR0_DSS_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR0_DSS_SHIFT))

//====================================================================
//Register: SSP Control Register 1 (SSP_SSCR1)
/** \brief These registers contain bit fields that control various SSP port functions. The
following table shows bit locations corresponding to control bit fields in
SSP_SSCR1. The reset state of all bits is shown, but must be set to the
preferred value before enabling the SSP port by setting the <Synchronous Serial
Port Enable> field in the SSP Control Register 0.
Write 0x0 to reserved bits, the read values of reserved bits are undetermined.*/
//====================================================================

#define  SSP2_SSP_SSCR1_TTELP_MASK 0x80000000
#define  SSP2_SSP_SSCR1_TTELP_SHIFT 31
#define  SSP2_SSP_SSCR1_TTELP_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_TTELP_MASK) >> SSP2_SSP_SSCR1_TTELP_SHIFT)
#define  SSP2_SSP_SSCR1_TTELP_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_TTELP_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_TTELP_SHIFT))

#define  SSP2_SSP_SSCR1_TTE_MASK 0x40000000
#define  SSP2_SSP_SSCR1_TTE_SHIFT 30
#define  SSP2_SSP_SSCR1_TTE_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_TTE_MASK) >> SSP2_SSP_SSCR1_TTE_SHIFT)
#define  SSP2_SSP_SSCR1_TTE_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_TTE_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_TTE_SHIFT))

#define  SSP2_SSP_SSCR1_EBCEI_MASK 0x20000000
#define  SSP2_SSP_SSCR1_EBCEI_SHIFT 29
#define  SSP2_SSP_SSCR1_EBCEI_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_EBCEI_MASK) >> SSP2_SSP_SSCR1_EBCEI_SHIFT)
#define  SSP2_SSP_SSCR1_EBCEI_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_EBCEI_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_EBCEI_SHIFT))

#define  SSP2_SSP_SSCR1_SCFR_MASK 0x10000000
#define  SSP2_SSP_SSCR1_SCFR_SHIFT 28
#define  SSP2_SSP_SSCR1_SCFR_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_SCFR_MASK) >> SSP2_SSP_SSCR1_SCFR_SHIFT)
#define  SSP2_SSP_SSCR1_SCFR_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_SCFR_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_SCFR_SHIFT))

#define  SSP2_SSP_SSCR1_ECRA_MASK 0x8000000
#define  SSP2_SSP_SSCR1_ECRA_SHIFT 27
#define  SSP2_SSP_SSCR1_ECRA_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_ECRA_MASK) >> SSP2_SSP_SSCR1_ECRA_SHIFT)
#define  SSP2_SSP_SSCR1_ECRA_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_ECRA_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_ECRA_SHIFT))

#define  SSP2_SSP_SSCR1_ECRB_MASK 0x4000000
#define  SSP2_SSP_SSCR1_ECRB_SHIFT 26
#define  SSP2_SSP_SSCR1_ECRB_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_ECRB_MASK) >> SSP2_SSP_SSCR1_ECRB_SHIFT)
#define  SSP2_SSP_SSCR1_ECRB_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_ECRB_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_ECRB_SHIFT))

#define  SSP2_SSP_SSCR1_SCLKDIR_MASK 0x2000000
#define  SSP2_SSP_SSCR1_SCLKDIR_SHIFT 25
#define  SSP2_SSP_SSCR1_SCLKDIR_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_SCLKDIR_MASK) >> SSP2_SSP_SSCR1_SCLKDIR_SHIFT)
#define  SSP2_SSP_SSCR1_SCLKDIR_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_SCLKDIR_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_SCLKDIR_SHIFT))

#define  SSP2_SSP_SSCR1_SFRMDIR_MASK 0x1000000
#define  SSP2_SSP_SSCR1_SFRMDIR_SHIFT 24
#define  SSP2_SSP_SSCR1_SFRMDIR_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_SFRMDIR_MASK) >> SSP2_SSP_SSCR1_SFRMDIR_SHIFT)
#define  SSP2_SSP_SSCR1_SFRMDIR_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_SFRMDIR_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_SFRMDIR_SHIFT))

#define  SSP2_SSP_SSCR1_RWOT_MASK 0x800000
#define  SSP2_SSP_SSCR1_RWOT_SHIFT 23
#define  SSP2_SSP_SSCR1_RWOT_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_RWOT_MASK) >> SSP2_SSP_SSCR1_RWOT_SHIFT)
#define  SSP2_SSP_SSCR1_RWOT_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_RWOT_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_RWOT_SHIFT))

#define  SSP2_SSP_SSCR1_TRAIL_MASK 0x400000
#define  SSP2_SSP_SSCR1_TRAIL_SHIFT 22
#define  SSP2_SSP_SSCR1_TRAIL_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_TRAIL_MASK) >> SSP2_SSP_SSCR1_TRAIL_SHIFT)
#define  SSP2_SSP_SSCR1_TRAIL_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_TRAIL_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_TRAIL_SHIFT))

#define  SSP2_SSP_SSCR1_TSRE_MASK 0x200000
#define  SSP2_SSP_SSCR1_TSRE_SHIFT 21
#define  SSP2_SSP_SSCR1_TSRE_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_TSRE_MASK) >> SSP2_SSP_SSCR1_TSRE_SHIFT)
#define  SSP2_SSP_SSCR1_TSRE_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_TSRE_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_TSRE_SHIFT))

#define  SSP2_SSP_SSCR1_RSRE_MASK 0x100000
#define  SSP2_SSP_SSCR1_RSRE_SHIFT 20
#define  SSP2_SSP_SSCR1_RSRE_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_RSRE_MASK) >> SSP2_SSP_SSCR1_RSRE_SHIFT)
#define  SSP2_SSP_SSCR1_RSRE_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_RSRE_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_RSRE_SHIFT))

#define  SSP2_SSP_SSCR1_TINTE_MASK 0x80000
#define  SSP2_SSP_SSCR1_TINTE_SHIFT 19
#define  SSP2_SSP_SSCR1_TINTE_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_TINTE_MASK) >> SSP2_SSP_SSCR1_TINTE_SHIFT)
#define  SSP2_SSP_SSCR1_TINTE_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_TINTE_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_TINTE_SHIFT))

#define  SSP2_SSP_SSCR1_PINTE_MASK 0x40000
#define  SSP2_SSP_SSCR1_PINTE_SHIFT 18
#define  SSP2_SSP_SSCR1_PINTE_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_PINTE_MASK) >> SSP2_SSP_SSCR1_PINTE_SHIFT)
#define  SSP2_SSP_SSCR1_PINTE_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_PINTE_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_PINTE_SHIFT))

#define  SSP2_SSP_SSCR1_FEN_MASK 0x20000
#define  SSP2_SSP_SSCR1_FEN_SHIFT 17
#define  SSP2_SSP_SSCR1_FEN_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_FEN_MASK) >> SSP2_SSP_SSCR1_FEN_SHIFT)
#define  SSP2_SSP_SSCR1_FEN_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_FEN_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_FEN_SHIFT))

#define  SSP2_SSP_SSCR1_IFS_MASK 0x10000
#define  SSP2_SSP_SSCR1_IFS_SHIFT 16
#define  SSP2_SSP_SSCR1_IFS_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_IFS_MASK) >> SSP2_SSP_SSCR1_IFS_SHIFT)
#define  SSP2_SSP_SSCR1_IFS_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_IFS_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_IFS_SHIFT))

#define  SSP2_SSP_SSCR1_STRF_MASK 0x8000
#define  SSP2_SSP_SSCR1_STRF_SHIFT 15
#define  SSP2_SSP_SSCR1_STRF_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_STRF_MASK) >> SSP2_SSP_SSCR1_STRF_SHIFT)
#define  SSP2_SSP_SSCR1_STRF_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_STRF_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_STRF_SHIFT))

#define  SSP2_SSP_SSCR1_EFWR_MASK 0x4000
#define  SSP2_SSP_SSCR1_EFWR_SHIFT 14
#define  SSP2_SSP_SSCR1_EFWR_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_EFWR_MASK) >> SSP2_SSP_SSCR1_EFWR_SHIFT)
#define  SSP2_SSP_SSCR1_EFWR_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_EFWR_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_EFWR_SHIFT))

#define  SSP2_SSP_SSCR1_RFT_MASK 0x3c00
#define  SSP2_SSP_SSCR1_RFT_SHIFT 10
#define  SSP2_SSP_SSCR1_RFT_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_RFT_MASK) >> SSP2_SSP_SSCR1_RFT_SHIFT)
#define  SSP2_SSP_SSCR1_RFT_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_RFT_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_RFT_SHIFT))

#define  SSP2_SSP_SSCR1_TFT_MASK 0x3c0
#define  SSP2_SSP_SSCR1_TFT_SHIFT 6
#define  SSP2_SSP_SSCR1_TFT_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_TFT_MASK) >> SSP2_SSP_SSCR1_TFT_SHIFT)
#define  SSP2_SSP_SSCR1_TFT_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_TFT_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_TFT_SHIFT))

#define  SSP2_SSP_SSCR1_MWDS_MASK 0x20
#define  SSP2_SSP_SSCR1_MWDS_SHIFT 5
#define  SSP2_SSP_SSCR1_MWDS_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_MWDS_MASK) >> SSP2_SSP_SSCR1_MWDS_SHIFT)
#define  SSP2_SSP_SSCR1_MWDS_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_MWDS_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_MWDS_SHIFT))

#define  SSP2_SSP_SSCR1_SPH_MASK 0x10
#define  SSP2_SSP_SSCR1_SPH_SHIFT 4
#define  SSP2_SSP_SSCR1_SPH_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_SPH_MASK) >> SSP2_SSP_SSCR1_SPH_SHIFT)
#define  SSP2_SSP_SSCR1_SPH_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_SPH_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_SPH_SHIFT))

#define  SSP2_SSP_SSCR1_SPO_MASK 0x8
#define  SSP2_SSP_SSCR1_SPO_SHIFT 3
#define  SSP2_SSP_SSCR1_SPO_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_SPO_MASK) >> SSP2_SSP_SSCR1_SPO_SHIFT)
#define  SSP2_SSP_SSCR1_SPO_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_SPO_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_SPO_SHIFT))

#define  SSP2_SSP_SSCR1_LBM_MASK 0x4
#define  SSP2_SSP_SSCR1_LBM_SHIFT 2
#define  SSP2_SSP_SSCR1_LBM_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_LBM_MASK) >> SSP2_SSP_SSCR1_LBM_SHIFT)
#define  SSP2_SSP_SSCR1_LBM_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_LBM_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_LBM_SHIFT))

#define  SSP2_SSP_SSCR1_TIE_MASK 0x2
#define  SSP2_SSP_SSCR1_TIE_SHIFT 1
#define  SSP2_SSP_SSCR1_TIE_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_TIE_MASK) >> SSP2_SSP_SSCR1_TIE_SHIFT)
#define  SSP2_SSP_SSCR1_TIE_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_TIE_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_TIE_SHIFT))

#define  SSP2_SSP_SSCR1_RIE_MASK 0x1
#define  SSP2_SSP_SSCR1_RIE_SHIFT 0
#define  SSP2_SSP_SSCR1_RIE_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSCR1_RIE_MASK) >> SSP2_SSP_SSCR1_RIE_SHIFT)
#define  SSP2_SSP_SSCR1_RIE_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSCR1_RIE_MASK) | (((uint32_t)val) << SSP2_SSP_SSCR1_RIE_SHIFT))

//====================================================================
//Register: SSP Status Register (SSP_SSSR)
/** \brief These registers contain bits that signal overrun errors as well as the TXFIFO
and RXFIFO service requests. Each of these hardware-detected events signals an
interrupt request to the interrupt controller, or a DMA request. The Status
register also contains flags that indicate if the SSPx port is actively
transmitting data, if the TXFIFO is not full, and if the RXFIFO is not empty.
A signal-interrupt signal is sent to the interrupt controller for each SSPx
port. These events can cause an interrupt request or a DMA request:
end-of-chain, receiver timeout, peripheral trailing byte, RXFIFO overrun, RXFIFO
service request, and TXFIFO service request.
Bits that cause an interrupt request remain set until they are cleared by
writing a 0x1 to each bit. Once a status bit is cleared, the interrupt is
cleared. Read-write bits are called status bits (status bits are referred to
as <q>sticky</q> and once set by hardware, they can only be cleared by writing
a 0x1 to each bit), read-only bits are called flags. Writing 0x1 to a sticky
status bit clears it, writing a 0x0 has no effect. Read-only flags are set
to 0x1 and are cleared automatically to 0x0 by hardware, and writes have no
effect. Some bits that cause interrupt requests have corresponding mask bits in
the control registers and are indicated in the following sections.
The following table shows the bit locations corresponding to the status and flag
bits within the SSP Port Status Register. All bits are read-only except
the <Receive FIFO Overrun>, <Peripheral Trailing Byte Interrupt>, <Transmit FIFO
Underrun>, <Bit Count Error>, <Receiver Time-out Interrupt>, and <End of Chain>,
which are all read-write. The reset state of read-write bits is 0x0 and all bits
return to their reset state when the <Synchronous Serial Port Enable> field in
the SSP Control Register 0 is cleared.
Write 0x0 to reserved bits, reads from reserved bits are undetermined.*/
//====================================================================

#define  SSP2_SSP_SSSR_OSS_MASK 0x80000000
#define  SSP2_SSP_SSSR_OSS_SHIFT 31
#define  SSP2_SSP_SSSR_OSS_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSSR_OSS_MASK) >> SSP2_SSP_SSSR_OSS_SHIFT)
#define  SSP2_SSP_SSSR_OSS_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSSR_OSS_MASK) | (((uint32_t)val) << SSP2_SSP_SSSR_OSS_SHIFT))

#define  SSP2_SSP_SSSR_TX_OSS_MASK 0x40000000
#define  SSP2_SSP_SSSR_TX_OSS_SHIFT 30
#define  SSP2_SSP_SSSR_TX_OSS_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSSR_TX_OSS_MASK) >> SSP2_SSP_SSSR_TX_OSS_SHIFT)
#define  SSP2_SSP_SSSR_TX_OSS_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSSR_TX_OSS_MASK) | (((uint32_t)val) << SSP2_SSP_SSSR_TX_OSS_SHIFT))

#define  SSP2_SSP_SSSR_RESERVED1_MASK 0x3f000000
#define  SSP2_SSP_SSSR_RESERVED1_SHIFT 24
#define  SSP2_SSP_SSSR_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSSR_RESERVED1_MASK) >> SSP2_SSP_SSSR_RESERVED1_SHIFT)
#define  SSP2_SSP_SSSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSSR_RESERVED1_MASK) | (((uint32_t)val) << SSP2_SSP_SSSR_RESERVED1_SHIFT))

#define  SSP2_SSP_SSSR_BCE_MASK 0x800000
#define  SSP2_SSP_SSSR_BCE_SHIFT 23
#define  SSP2_SSP_SSSR_BCE_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSSR_BCE_MASK) >> SSP2_SSP_SSSR_BCE_SHIFT)
#define  SSP2_SSP_SSSR_BCE_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSSR_BCE_MASK) | (((uint32_t)val) << SSP2_SSP_SSSR_BCE_SHIFT))

#define  SSP2_SSP_SSSR_CSS_MASK 0x400000
#define  SSP2_SSP_SSSR_CSS_SHIFT 22
#define  SSP2_SSP_SSSR_CSS_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSSR_CSS_MASK) >> SSP2_SSP_SSSR_CSS_SHIFT)
#define  SSP2_SSP_SSSR_CSS_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSSR_CSS_MASK) | (((uint32_t)val) << SSP2_SSP_SSSR_CSS_SHIFT))

#define  SSP2_SSP_SSSR_TUR_MASK 0x200000
#define  SSP2_SSP_SSSR_TUR_SHIFT 21
#define  SSP2_SSP_SSSR_TUR_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSSR_TUR_MASK) >> SSP2_SSP_SSSR_TUR_SHIFT)
#define  SSP2_SSP_SSSR_TUR_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSSR_TUR_MASK) | (((uint32_t)val) << SSP2_SSP_SSSR_TUR_SHIFT))

#define  SSP2_SSP_SSSR_EOC_MASK 0x100000
#define  SSP2_SSP_SSSR_EOC_SHIFT 20
#define  SSP2_SSP_SSSR_EOC_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSSR_EOC_MASK) >> SSP2_SSP_SSSR_EOC_SHIFT)
#define  SSP2_SSP_SSSR_EOC_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSSR_EOC_MASK) | (((uint32_t)val) << SSP2_SSP_SSSR_EOC_SHIFT))

#define  SSP2_SSP_SSSR_TINT_MASK 0x80000
#define  SSP2_SSP_SSSR_TINT_SHIFT 19
#define  SSP2_SSP_SSSR_TINT_MASK_SHIFT(reg) (((reg) & SSP2_SSP_SSSR_TINT_MASK) >> SSP2_SSP_SSSR_TINT_SHIFT)
#define  SSP2_SSP_SSSR_TINT_REPLACE_VAL(reg,val) (((reg) & ~SSP2_SSP_SSSR_TINT_MASK) | (((uint32_t)val) << SSP