 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _SSPLL3P0G_REGSTRUCTS_H_
#define _SSPLL3P0G_REGSTRUCTS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: System Spread Spectrum PLL Registers (SSPLL3P0G)
//
//====================================================================

typedef struct SSPLL3P0G_REGS_s
{
  volatile uint32_t rst_prediv;  ///< 0x0 [R/W]: PLL reset & Pre-divider Register
  volatile uint32_t mult_postdiv;  ///< 0x4 [R/W]: PLL feedback multiplier
  volatile uint32_t kvco;  ///< 0x8 [R/W]: PLL gain control
  volatile uint32_t misc;  ///< 0xc [R/W]: PLL misc control
  volatile uint32_t feedback_mode_deskew;  ///< 0x10 [R/W]: PLL PFD (Phase Frequency Detector) input select, and de-skew application control
  volatile uint32_t offset_mode;  ///< 0x14 [R/W]: PLL offset frequency control
  volatile uint32_t fixed_mode_ssc_mode;  ///< 0x18 [R/W]: PLL enable
  volatile uint32_t ssc_freq_ssc_range;  ///< 0x1c [R/W]: PLL Modulation Frequency
  volatile uint32_t clk_ctrl_marvell_test;  ///< 0x20 [R/W]: PLL Output Clock Control
  volatile uint32_t lock_status;  ///< 0x24 [R]: PLL Lock Status
  volatile uint32_t reserve_out;  ///< 0x28 [R]: PLL RESERVE_OUT output
} SSPLL3P0G_REGS_t;

#endif // SSPLL3P0G
 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _SSPLL3P0G_REGMASKS_H_
#define _SSPLL3P0G_REGMASKS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: System Spread Spectrum PLL Registers (SSPLL3P0G)
//
//====================================================================

//====================================================================
//Register: PLL reset & Pre-divider Register (rst_prediv)
/** \brief RESET, 1 = PLL in reset
           0 = PLL in normal mode
    RESET_SSC, 1 = SSC and Freq Offset in reset
               0 = SSC and Freq Offset operating mode
    RESET_PI, 1 = External Interpolator in reset
               0 = operating mode*/
//====================================================================

#define  SSPLL3P0G_RST_PREDIV_RESERVED1_MASK 0xfff80000
#define  SSPLL3P0G_RST_PREDIV_RESERVED1_SHIFT 19
#define  SSPLL3P0G_RST_PREDIV_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_RST_PREDIV_RESERVED1_MASK) >> SSPLL3P0G_RST_PREDIV_RESERVED1_SHIFT)
#define  SSPLL3P0G_RST_PREDIV_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_RST_PREDIV_RESERVED1_MASK) | (((uint32_t)val) << SSPLL3P0G_RST_PREDIV_RESERVED1_SHIFT))

#define  SSPLL3P0G_RST_PREDIV_RESET_PI_MASK 0x40000
#define  SSPLL3P0G_RST_PREDIV_RESET_PI_SHIFT 18
#define  SSPLL3P0G_RST_PREDIV_RESET_PI_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_RST_PREDIV_RESET_PI_MASK) >> SSPLL3P0G_RST_PREDIV_RESET_PI_SHIFT)
#define  SSPLL3P0G_RST_PREDIV_RESET_PI_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_RST_PREDIV_RESET_PI_MASK) | (((uint32_t)val) << SSPLL3P0G_RST_PREDIV_RESET_PI_SHIFT))

#define  SSPLL3P0G_RST_PREDIV_RESET_SSC_MASK 0x20000
#define  SSPLL3P0G_RST_PREDIV_RESET_SSC_SHIFT 17
#define  SSPLL3P0G_RST_PREDIV_RESET_SSC_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_RST_PREDIV_RESET_SSC_MASK) >> SSPLL3P0G_RST_PREDIV_RESET_SSC_SHIFT)
#define  SSPLL3P0G_RST_PREDIV_RESET_SSC_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_RST_PREDIV_RESET_SSC_MASK) | (((uint32_t)val) << SSPLL3P0G_RST_PREDIV_RESET_SSC_SHIFT))

#define  SSPLL3P0G_RST_PREDIV_RESET_MASK 0x10000
#define  SSPLL3P0G_RST_PREDIV_RESET_SHIFT 16
#define  SSPLL3P0G_RST_PREDIV_RESET_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_RST_PREDIV_RESET_MASK) >> SSPLL3P0G_RST_PREDIV_RESET_SHIFT)
#define  SSPLL3P0G_RST_PREDIV_RESET_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_RST_PREDIV_RESET_MASK) | (((uint32_t)val) << SSPLL3P0G_RST_PREDIV_RESET_SHIFT))

#define  SSPLL3P0G_RST_PREDIV_RESERVED2_MASK 0xfe00
#define  SSPLL3P0G_RST_PREDIV_RESERVED2_SHIFT 9
#define  SSPLL3P0G_RST_PREDIV_RESERVED2_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_RST_PREDIV_RESERVED2_MASK) >> SSPLL3P0G_RST_PREDIV_RESERVED2_SHIFT)
#define  SSPLL3P0G_RST_PREDIV_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_RST_PREDIV_RESERVED2_MASK) | (((uint32_t)val) << SSPLL3P0G_RST_PREDIV_RESERVED2_SHIFT))

#define  SSPLL3P0G_RST_PREDIV_REFDIV_MASK 0x1ff
#define  SSPLL3P0G_RST_PREDIV_REFDIV_SHIFT 0
#define  SSPLL3P0G_RST_PREDIV_REFDIV_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_RST_PREDIV_REFDIV_MASK) >> SSPLL3P0G_RST_PREDIV_REFDIV_SHIFT)
#define  SSPLL3P0G_RST_PREDIV_REFDIV_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_RST_PREDIV_REFDIV_MASK) | (((uint32_t)val) << SSPLL3P0G_RST_PREDIV_REFDIV_SHIFT))

//====================================================================
//Register: PLL feedback multiplier (mult_postdiv)
/** \brief PLL multiplication factor after pre-divide.*/
//====================================================================

#define  SSPLL3P0G_MULT_POSTDIV_RESERVED1_MASK 0xfe000000
#define  SSPLL3P0G_MULT_POSTDIV_RESERVED1_SHIFT 25
#define  SSPLL3P0G_MULT_POSTDIV_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_MULT_POSTDIV_RESERVED1_MASK) >> SSPLL3P0G_MULT_POSTDIV_RESERVED1_SHIFT)
#define  SSPLL3P0G_MULT_POSTDIV_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_MULT_POSTDIV_RESERVED1_MASK) | (((uint32_t)val) << SSPLL3P0G_MULT_POSTDIV_RESERVED1_SHIFT))

#define  SSPLL3P0G_MULT_POSTDIV_FBDIV_MASK 0x1ff0000
#define  SSPLL3P0G_MULT_POSTDIV_FBDIV_SHIFT 16
#define  SSPLL3P0G_MULT_POSTDIV_FBDIV_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_MULT_POSTDIV_FBDIV_MASK) >> SSPLL3P0G_MULT_POSTDIV_FBDIV_SHIFT)
#define  SSPLL3P0G_MULT_POSTDIV_FBDIV_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_MULT_POSTDIV_FBDIV_MASK) | (((uint32_t)val) << SSPLL3P0G_MULT_POSTDIV_FBDIV_SHIFT))

#define  SSPLL3P0G_MULT_POSTDIV_RESERVED2_MASK 0xf800
#define  SSPLL3P0G_MULT_POSTDIV_RESERVED2_SHIFT 11
#define  SSPLL3P0G_MULT_POSTDIV_RESERVED2_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_MULT_POSTDIV_RESERVED2_MASK) >> SSPLL3P0G_MULT_POSTDIV_RESERVED2_SHIFT)
#define  SSPLL3P0G_MULT_POSTDIV_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_MULT_POSTDIV_RESERVED2_MASK) | (((uint32_t)val) << SSPLL3P0G_MULT_POSTDIV_RESERVED2_SHIFT))

#define  SSPLL3P0G_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK 0x700
#define  SSPLL3P0G_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_SHIFT 8
#define  SSPLL3P0G_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK) >> SSPLL3P0G_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_SHIFT)
#define  SSPLL3P0G_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK) | (((uint32_t)val) << SSPLL3P0G_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_SHIFT))

#define  SSPLL3P0G_MULT_POSTDIV_RESERVED3_MASK 0xf8
#define  SSPLL3P0G_MULT_POSTDIV_RESERVED3_SHIFT 3
#define  SSPLL3P0G_MULT_POSTDIV_RESERVED3_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_MULT_POSTDIV_RESERVED3_MASK) >> SSPLL3P0G_MULT_POSTDIV_RESERVED3_SHIFT)
#define  SSPLL3P0G_MULT_POSTDIV_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_MULT_POSTDIV_RESERVED3_MASK) | (((uint32_t)val) << SSPLL3P0G_MULT_POSTDIV_RESERVED3_SHIFT))

#define  SSPLL3P0G_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK 0x7
#define  SSPLL3P0G_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_SHIFT 0
#define  SSPLL3P0G_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK) >> SSPLL3P0G_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_SHIFT)
#define  SSPLL3P0G_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK) | (((uint32_t)val) << SSPLL3P0G_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_SHIFT))

//====================================================================
//Register: PLL gain control (kvco)
/** \brief PLL gain control.*/
//====================================================================

#define  SSPLL3P0G_KVCO_RESERVED1_MASK 0xfffffff0
#define  SSPLL3P0G_KVCO_RESERVED1_SHIFT 4
#define  SSPLL3P0G_KVCO_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_KVCO_RESERVED1_MASK) >> SSPLL3P0G_KVCO_RESERVED1_SHIFT)
#define  SSPLL3P0G_KVCO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_KVCO_RESERVED1_MASK) | (((uint32_t)val) << SSPLL3P0G_KVCO_RESERVED1_SHIFT))

#define  SSPLL3P0G_KVCO_KVCO_MASK 0xf
#define  SSPLL3P0G_KVCO_KVCO_SHIFT 0
#define  SSPLL3P0G_KVCO_KVCO_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_KVCO_KVCO_MASK) >> SSPLL3P0G_KVCO_KVCO_SHIFT)
#define  SSPLL3P0G_KVCO_KVCO_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_KVCO_KVCO_MASK) | (((uint32_t)val) << SSPLL3P0G_KVCO_KVCO_SHIFT))

//====================================================================
//Register: PLL misc control (misc)
/** \brief PLL misc control.*/
//====================================================================

#define  SSPLL3P0G_MISC_RESERVED1_MASK 0xffff0000
#define  SSPLL3P0G_MISC_RESERVED1_SHIFT 16
#define  SSPLL3P0G_MISC_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_MISC_RESERVED1_MASK) >> SSPLL3P0G_MISC_RESERVED1_SHIFT)
#define  SSPLL3P0G_MISC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_MISC_RESERVED1_MASK) | (((uint32_t)val) << SSPLL3P0G_MISC_RESERVED1_SHIFT))

#define  SSPLL3P0G_MISC_PLL_BW_SEL_MASK 0x8000
#define  SSPLL3P0G_MISC_PLL_BW_SEL_SHIFT 15
#define  SSPLL3P0G_MISC_PLL_BW_SEL_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_MISC_PLL_BW_SEL_MASK) >> SSPLL3P0G_MISC_PLL_BW_SEL_SHIFT)
#define  SSPLL3P0G_MISC_PLL_BW_SEL_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_MISC_PLL_BW_SEL_MASK) | (((uint32_t)val) << SSPLL3P0G_MISC_PLL_BW_SEL_SHIFT))

#define  SSPLL3P0G_MISC_CTUNE_MASK 0x6000
#define  SSPLL3P0G_MISC_CTUNE_SHIFT 13
#define  SSPLL3P0G_MISC_CTUNE_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_MISC_CTUNE_MASK) >> SSPLL3P0G_MISC_CTUNE_SHIFT)
#define  SSPLL3P0G_MISC_CTUNE_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_MISC_CTUNE_MASK) | (((uint32_t)val) << SSPLL3P0G_MISC_CTUNE_SHIFT))

#define  SSPLL3P0G_MISC_INTPI_MASK 0x1e00
#define  SSPLL3P0G_MISC_INTPI_SHIFT 9
#define  SSPLL3P0G_MISC_INTPI_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_MISC_INTPI_MASK) >> SSPLL3P0G_MISC_INTPI_SHIFT)
#define  SSPLL3P0G_MISC_INTPI_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_MISC_INTPI_MASK) | (((uint32_t)val) << SSPLL3P0G_MISC_INTPI_SHIFT))

#define  SSPLL3P0G_MISC_ICP_MASK 0x1e0
#define  SSPLL3P0G_MISC_ICP_SHIFT 5
#define  SSPLL3P0G_MISC_ICP_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_MISC_ICP_MASK) >> SSPLL3P0G_MISC_ICP_SHIFT)
#define  SSPLL3P0G_MISC_ICP_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_MISC_ICP_MASK) | (((uint32_t)val) << SSPLL3P0G_MISC_ICP_SHIFT))

#define  SSPLL3P0G_MISC_VDDM_MASK 0x18
#define  SSPLL3P0G_MISC_VDDM_SHIFT 3
#define  SSPLL3P0G_MISC_VDDM_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_MISC_VDDM_MASK) >> SSPLL3P0G_MISC_VDDM_SHIFT)
#define  SSPLL3P0G_MISC_VDDM_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_MISC_VDDM_MASK) | (((uint32_t)val) << SSPLL3P0G_MISC_VDDM_SHIFT))

#define  SSPLL3P0G_MISC_VDDL_MASK 0x7
#define  SSPLL3P0G_MISC_VDDL_SHIFT 0
#define  SSPLL3P0G_MISC_VDDL_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_MISC_VDDL_MASK) >> SSPLL3P0G_MISC_VDDL_SHIFT)
#define  SSPLL3P0G_MISC_VDDL_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_MISC_VDDL_MASK) | (((uint32_t)val) << SSPLL3P0G_MISC_VDDL_SHIFT))

//====================================================================
//Register: PLL PFD (Phase Frequency Detector) input select, and de-skew application control (feedback_mode_deskew)
/** \brief PLL feedback mode control.*/
//====================================================================

#define  SSPLL3P0G_FEEDBACK_MODE_DESKEW_RESERVED1_MASK 0xff800000
#define  SSPLL3P0G_FEEDBACK_MODE_DESKEW_RESERVED1_SHIFT 23
#define  SSPLL3P0G_FEEDBACK_MODE_DESKEW_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_FEEDBACK_MODE_DESKEW_RESERVED1_MASK) >> SSPLL3P0G_FEEDBACK_MODE_DESKEW_RESERVED1_SHIFT)
#define  SSPLL3P0G_FEEDBACK_MODE_DESKEW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_FEEDBACK_MODE_DESKEW_RESERVED1_MASK) | (((uint32_t)val) << SSPLL3P0G_FEEDBACK_MODE_DESKEW_RESERVED1_SHIFT))

#define  SSPLL3P0G_FEEDBACK_MODE_DESKEW_FBCDLY_MASK 0x7e0000
#define  SSPLL3P0G_FEEDBACK_MODE_DESKEW_FBCDLY_SHIFT 17
#define  SSPLL3P0G_FEEDBACK_MODE_DESKEW_FBCDLY_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_FEEDBACK_MODE_DESKEW_FBCDLY_MASK) >> SSPLL3P0G_FEEDBACK_MODE_DESKEW_FBCDLY_SHIFT)
#define  SSPLL3P0G_FEEDBACK_MODE_DESKEW_FBCDLY_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_FEEDBACK_MODE_DESKEW_FBCDLY_MASK) | (((uint32_t)val) << SSPLL3P0G_FEEDBACK_MODE_DESKEW_FBCDLY_SHIFT))

#define  SSPLL3P0G_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK 0x10000
#define  SSPLL3P0G_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_SHIFT 16
#define  SSPLL3P0G_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK) >> SSPLL3P0G_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_SHIFT)
#define  SSPLL3P0G_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK) | (((uint32_t)val) << SSPLL3P0G_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_SHIFT))

#define  SSPLL3P0G_FEEDBACK_MODE_DESKEW_RESERVED2_MASK 0xffff
#define  SSPLL3P0G_FEEDBACK_MODE_DESKEW_RESERVED2_SHIFT 0
#define  SSPLL3P0G_FEEDBACK_MODE_DESKEW_RESERVED2_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_FEEDBACK_MODE_DESKEW_RESERVED2_MASK) >> SSPLL3P0G_FEEDBACK_MODE_DESKEW_RESERVED2_SHIFT)
#define  SSPLL3P0G_FEEDBACK_MODE_DESKEW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_FEEDBACK_MODE_DESKEW_RESERVED2_MASK) | (((uint32_t)val) << SSPLL3P0G_FEEDBACK_MODE_DESKEW_RESERVED2_SHIFT))

//====================================================================
//Register: PLL offset frequency control (offset_mode)
/** \brief PLL offset frequency control.*/
//====================================================================

#define  SSPLL3P0G_OFFSET_MODE_RESERVED1_MASK 0xf8000000
#define  SSPLL3P0G_OFFSET_MODE_RESERVED1_SHIFT 27
#define  SSPLL3P0G_OFFSET_MODE_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_OFFSET_MODE_RESERVED1_MASK) >> SSPLL3P0G_OFFSET_MODE_RESERVED1_SHIFT)
#define  SSPLL3P0G_OFFSET_MODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_OFFSET_MODE_RESERVED1_MASK) | (((uint32_t)val) << SSPLL3P0G_OFFSET_MODE_RESERVED1_SHIFT))

#define  SSPLL3P0G_OFFSET_MODE_INTPR_MASK 0x7000000
#define  SSPLL3P0G_OFFSET_MODE_INTPR_SHIFT 24
#define  SSPLL3P0G_OFFSET_MODE_INTPR_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_OFFSET_MODE_INTPR_MASK) >> SSPLL3P0G_OFFSET_MODE_INTPR_SHIFT)
#define  SSPLL3P0G_OFFSET_MODE_INTPR_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_OFFSET_MODE_INTPR_MASK) | (((uint32_t)val) << SSPLL3P0G_OFFSET_MODE_INTPR_SHIFT))

#define  SSPLL3P0G_OFFSET_MODE_FD_MASK 0xe00000
#define  SSPLL3P0G_OFFSET_MODE_FD_SHIFT 21
#define  SSPLL3P0G_OFFSET_MODE_FD_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_OFFSET_MODE_FD_MASK) >> SSPLL3P0G_OFFSET_MODE_FD_SHIFT)
#define  SSPLL3P0G_OFFSET_MODE_FD_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_OFFSET_MODE_FD_MASK) | (((uint32_t)val) << SSPLL3P0G_OFFSET_MODE_FD_SHIFT))

#define  SSPLL3P0G_OFFSET_MODE_PI_LOOP_MODE_MASK 0x100000
#define  SSPLL3P0G_OFFSET_MODE_PI_LOOP_MODE_SHIFT 20
#define  SSPLL3P0G_OFFSET_MODE_PI_LOOP_MODE_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_OFFSET_MODE_PI_LOOP_MODE_MASK) >> SSPLL3P0G_OFFSET_MODE_PI_LOOP_MODE_SHIFT)
#define  SSPLL3P0G_OFFSET_MODE_PI_LOOP_MODE_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_OFFSET_MODE_PI_LOOP_MODE_MASK) | (((uint32_t)val) << SSPLL3P0G_OFFSET_MODE_PI_LOOP_MODE_SHIFT))

#define  SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_MASK 0xffff8
#define  SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_SHIFT 3
#define  SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_MASK) >> SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_SHIFT)
#define  SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_MASK) | (((uint32_t)val) << SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_SHIFT))

#define  SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK 0x4
#define  SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_SHIFT 2
#define  SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK) >> SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_SHIFT)
#define  SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK) | (((uint32_t)val) << SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_SHIFT))

#define  SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_VALID_MASK 0x2
#define  SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_VALID_SHIFT 1
#define  SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_VALID_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_VALID_MASK) >> SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_VALID_SHIFT)
#define  SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_VALID_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_VALID_MASK) | (((uint32_t)val) << SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_VALID_SHIFT))

#define  SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_EN_MASK 0x1
#define  SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_EN_SHIFT 0
#define  SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_EN_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_EN_MASK) >> SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_EN_SHIFT)
#define  SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_EN_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_EN_MASK) | (((uint32_t)val) << SSPLL3P0G_OFFSET_MODE_FREQ_OFFSET_EN_SHIFT))

//====================================================================
//Register: PLL enable (fixed_mode_ssc_mode)
/** \brief PLL enable*/
//====================================================================

#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_RESERVED1_MASK 0xfff00000
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_RESERVED1_SHIFT 20
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_FIXED_MODE_SSC_MODE_RESERVED1_MASK) >> SSPLL3P0G_FIXED_MODE_SSC_MODE_RESERVED1_SHIFT)
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_FIXED_MODE_SSC_MODE_RESERVED1_MASK) | (((uint32_t)val) << SSPLL3P0G_FIXED_MODE_SSC_MODE_RESERVED1_SHIFT))

#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK 0x80000
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_AVDD1815_SEL_SHIFT 19
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK) >> SSPLL3P0G_FIXED_MODE_SSC_MODE_AVDD1815_SEL_SHIFT)
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_AVDD1815_SEL_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK) | (((uint32_t)val) << SSPLL3P0G_FIXED_MODE_SSC_MODE_AVDD1815_SEL_SHIFT))

#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK 0x40000
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_SHIFT 18
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK) >> SSPLL3P0G_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_SHIFT)
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK) | (((uint32_t)val) << SSPLL3P0G_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_SHIFT))

#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_PU_MASK 0x20000
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_PU_SHIFT 17
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_PU_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_FIXED_MODE_SSC_MODE_PU_MASK) >> SSPLL3P0G_FIXED_MODE_SSC_MODE_PU_SHIFT)
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_PU_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_FIXED_MODE_SSC_MODE_PU_MASK) | (((uint32_t)val) << SSPLL3P0G_FIXED_MODE_SSC_MODE_PU_SHIFT))

#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK 0x10000
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_BYPASS_EN_SHIFT 16
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK) >> SSPLL3P0G_FIXED_MODE_SSC_MODE_BYPASS_EN_SHIFT)
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_BYPASS_EN_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK) | (((uint32_t)val) << SSPLL3P0G_FIXED_MODE_SSC_MODE_BYPASS_EN_SHIFT))

#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_RESERVED2_MASK 0xfff0
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_RESERVED2_SHIFT 4
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_RESERVED2_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_FIXED_MODE_SSC_MODE_RESERVED2_MASK) >> SSPLL3P0G_FIXED_MODE_SSC_MODE_RESERVED2_SHIFT)
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_FIXED_MODE_SSC_MODE_RESERVED2_MASK) | (((uint32_t)val) << SSPLL3P0G_FIXED_MODE_SSC_MODE_RESERVED2_SHIFT))

#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_SSC_MODE_MASK 0x8
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_SSC_MODE_SHIFT 3
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_SSC_MODE_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_FIXED_MODE_SSC_MODE_SSC_MODE_MASK) >> SSPLL3P0G_FIXED_MODE_SSC_MODE_SSC_MODE_SHIFT)
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_SSC_MODE_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_FIXED_MODE_SSC_MODE_SSC_MODE_MASK) | (((uint32_t)val) << SSPLL3P0G_FIXED_MODE_SSC_MODE_SSC_MODE_SHIFT))

#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK 0x4
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_CLK_DET_EN_SHIFT 2
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK) >> SSPLL3P0G_FIXED_MODE_SSC_MODE_CLK_DET_EN_SHIFT)
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_CLK_DET_EN_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK) | (((uint32_t)val) << SSPLL3P0G_FIXED_MODE_SSC_MODE_CLK_DET_EN_SHIFT))

#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_PI_EN_MASK 0x2
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_PI_EN_SHIFT 1
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_PI_EN_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_FIXED_MODE_SSC_MODE_PI_EN_MASK) >> SSPLL3P0G_FIXED_MODE_SSC_MODE_PI_EN_SHIFT)
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_PI_EN_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_FIXED_MODE_SSC_MODE_PI_EN_MASK) | (((uint32_t)val) << SSPLL3P0G_FIXED_MODE_SSC_MODE_PI_EN_SHIFT))

#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK 0x1
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_SSC_CLK_EN_SHIFT 0
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK) >> SSPLL3P0G_FIXED_MODE_SSC_MODE_SSC_CLK_EN_SHIFT)
#define  SSPLL3P0G_FIXED_MODE_SSC_MODE_SSC_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK) | (((uint32_t)val) << SSPLL3P0G_FIXED_MODE_SSC_MODE_SSC_CLK_EN_SHIFT))

//====================================================================
//Register: PLL Modulation Frequency (ssc_freq_ssc_range)
/** \brief PLL Modulation Frequency Control*/
//====================================================================

#define  SSPLL3P0G_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK 0xffff0000
#define  SSPLL3P0G_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_SHIFT 16
#define  SSPLL3P0G_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK) >> SSPLL3P0G_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_SHIFT)
#define  SSPLL3P0G_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK) | (((uint32_t)val) << SSPLL3P0G_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_SHIFT))

#define  SSPLL3P0G_SSC_FREQ_SSC_RANGE_RESERVED1_MASK 0xf800
#define  SSPLL3P0G_SSC_FREQ_SSC_RANGE_RESERVED1_SHIFT 11
#define  SSPLL3P0G_SSC_FREQ_SSC_RANGE_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_SSC_FREQ_SSC_RANGE_RESERVED1_MASK) >> SSPLL3P0G_SSC_FREQ_SSC_RANGE_RESERVED1_SHIFT)
#define  SSPLL3P0G_SSC_FREQ_SSC_RANGE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_SSC_FREQ_SSC_RANGE_RESERVED1_MASK) | (((uint32_t)val) << SSPLL3P0G_SSC_FREQ_SSC_RANGE_RESERVED1_SHIFT))

#define  SSPLL3P0G_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK 0x7ff
#define  SSPLL3P0G_SSC_FREQ_SSC_RANGE_SSC_RNGE_SHIFT 0
#define  SSPLL3P0G_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK) >> SSPLL3P0G_SSC_FREQ_SSC_RANGE_SSC_RNGE_SHIFT)
#define  SSPLL3P0G_SSC_FREQ_SSC_RANGE_SSC_RNGE_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK) | (((uint32_t)val) << SSPLL3P0G_SSC_FREQ_SSC_RANGE_SSC_RNGE_SHIFT))

//====================================================================
//Register: PLL Output Clock Control (clk_ctrl_marvell_test)
/** \brief PLL Output Clock Control*/
//====================================================================

#define  SSPLL3P0G_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK 0xfffc0000
#define  SSPLL3P0G_CLK_CTRL_MARVELL_TEST_RESERVED1_SHIFT 18
#define  SSPLL3P0G_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK) >> SSPLL3P0G_CLK_CTRL_MARVELL_TEST_RESERVED1_SHIFT)
#define  SSPLL3P0G_CLK_CTRL_MARVELL_TEST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK) | (((uint32_t)val) << SSPLL3P0G_CLK_CTRL_MARVELL_TEST_RESERVED1_SHIFT))

#define  SSPLL3P0G_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK 0x20000
#define  SSPLL3P0G_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_SHIFT 17
#define  SSPLL3P0G_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK) >> SSPLL3P0G_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_SHIFT)
#define  SSPLL3P0G_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK) | (((uint32_t)val) << SSPLL3P0G_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_SHIFT))

#define  SSPLL3P0G_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK 0x10000
#define  SSPLL3P0G_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_SHIFT 16
#define  SSPLL3P0G_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK) >> SSPLL3P0G_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_SHIFT)
#define  SSPLL3P0G_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK) | (((uint32_t)val) << SSPLL3P0G_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_SHIFT))

#define  SSPLL3P0G_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK 0xf000
#define  SSPLL3P0G_CLK_CTRL_MARVELL_TEST_RESERVED2_SHIFT 12
#define  SSPLL3P0G_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK) >> SSPLL3P0G_CLK_CTRL_MARVELL_TEST_RESERVED2_SHIFT)
#define  SSPLL3P0G_CLK_CTRL_MARVELL_TEST_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK) | (((uint32_t)val) << SSPLL3P0G_CLK_CTRL_MARVELL_TEST_RESERVED2_SHIFT))

#define  SSPLL3P0G_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK 0xff0
#define  SSPLL3P0G_CLK_CTRL_MARVELL_TEST_RESERVE_IN_SHIFT 4
#define  SSPLL3P0G_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK) >> SSPLL3P0G_CLK_CTRL_MARVELL_TEST_RESERVE_IN_SHIFT)
#define  SSPLL3P0G_CLK_CTRL_MARVELL_TEST_RESERVE_IN_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK) | (((uint32_t)val) << SSPLL3P0G_CLK_CTRL_MARVELL_TEST_RESERVE_IN_SHIFT))

#define  SSPLL3P0G_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK 0xf
#define  SSPLL3P0G_CLK_CTRL_MARVELL_TEST_TEST_ANA_SHIFT 0
#define  SSPLL3P0G_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK) >> SSPLL3P0G_CLK_CTRL_MARVELL_TEST_TEST_ANA_SHIFT)
#define  SSPLL3P0G_CLK_CTRL_MARVELL_TEST_TEST_ANA_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK) | (((uint32_t)val) << SSPLL3P0G_CLK_CTRL_MARVELL_TEST_TEST_ANA_SHIFT))

//====================================================================
//Register: PLL Lock Status (lock_status)
/** \brief PLL Lock Output*/
//====================================================================

#define  SSPLL3P0G_LOCK_STATUS_RESERVED1_MASK 0xfffffffe
#define  SSPLL3P0G_LOCK_STATUS_RESERVED1_SHIFT 1
#define  SSPLL3P0G_LOCK_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_LOCK_STATUS_RESERVED1_MASK) >> SSPLL3P0G_LOCK_STATUS_RESERVED1_SHIFT)
#define  SSPLL3P0G_LOCK_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_LOCK_STATUS_RESERVED1_MASK) | (((uint32_t)val) << SSPLL3P0G_LOCK_STATUS_RESERVED1_SHIFT))

#define  SSPLL3P0G_LOCK_STATUS_PLL_LOCK_MASK 0x1
#define  SSPLL3P0G_LOCK_STATUS_PLL_LOCK_SHIFT 0
#define  SSPLL3P0G_LOCK_STATUS_PLL_LOCK_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_LOCK_STATUS_PLL_LOCK_MASK) >> SSPLL3P0G_LOCK_STATUS_PLL_LOCK_SHIFT)
#define  SSPLL3P0G_LOCK_STATUS_PLL_LOCK_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_LOCK_STATUS_PLL_LOCK_MASK) | (((uint32_t)val) << SSPLL3P0G_LOCK_STATUS_PLL_LOCK_SHIFT))

//====================================================================
//Register: PLL RESERVE_OUT output (reserve_out)
//====================================================================

#define  SSPLL3P0G_RESERVE_OUT_RESERVED1_MASK 0xfffe0000
#define  SSPLL3P0G_RESERVE_OUT_RESERVED1_SHIFT 17
#define  SSPLL3P0G_RESERVE_OUT_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_RESERVE_OUT_RESERVED1_MASK) >> SSPLL3P0G_RESERVE_OUT_RESERVED1_SHIFT)
#define  SSPLL3P0G_RESERVE_OUT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_RESERVE_OUT_RESERVED1_MASK) | (((uint32_t)val) << SSPLL3P0G_RESERVE_OUT_RESERVED1_SHIFT))

#define  SSPLL3P0G_RESERVE_OUT_PU18_REG_MASK 0x10000
#define  SSPLL3P0G_RESERVE_OUT_PU18_REG_SHIFT 16
#define  SSPLL3P0G_RESERVE_OUT_PU18_REG_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_RESERVE_OUT_PU18_REG_MASK) >> SSPLL3P0G_RESERVE_OUT_PU18_REG_SHIFT)
#define  SSPLL3P0G_RESERVE_OUT_PU18_REG_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_RESERVE_OUT_PU18_REG_MASK) | (((uint32_t)val) << SSPLL3P0G_RESERVE_OUT_PU18_REG_SHIFT))

#define  SSPLL3P0G_RESERVE_OUT_RESERVED2_MASK 0xff00
#define  SSPLL3P0G_RESERVE_OUT_RESERVED2_SHIFT 8
#define  SSPLL3P0G_RESERVE_OUT_RESERVED2_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_RESERVE_OUT_RESERVED2_MASK) >> SSPLL3P0G_RESERVE_OUT_RESERVED2_SHIFT)
#define  SSPLL3P0G_RESERVE_OUT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_RESERVE_OUT_RESERVED2_MASK) | (((uint32_t)val) << SSPLL3P0G_RESERVE_OUT_RESERVED2_SHIFT))

#define  SSPLL3P0G_RESERVE_OUT_RESERVE_OUT_MASK 0xff
#define  SSPLL3P0G_RESERVE_OUT_RESERVE_OUT_SHIFT 0
#define  SSPLL3P0G_RESERVE_OUT_RESERVE_OUT_MASK_SHIFT(reg) (((reg) & SSPLL3P0G_RESERVE_OUT_RESERVE_OUT_MASK) >> SSPLL3P0G_RESERVE_OUT_RESERVE_OUT_SHIFT)
#define  SSPLL3P0G_RESERVE_OUT_RESERVE_OUT_REPLACE_VAL(reg,val) (((reg) & ~SSPLL3P0G_RESERVE_OUT_RESERVE_OUT_MASK) | (((uint32_t)val) << SSPLL3P0G_RESERVE_OUT_RESERVE_OUT_SHIFT))

#endif // SSPLL3P0G
