 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _SDMMC3_2P_REGSTRUCTS_H_
#define _SDMMC3_2P_REGSTRUCTS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: SDMMC3 Card Interface (SDMMC3_2p)
/** \brief Top-level register file for SDMMC3 Host Interface Block*/
//
//====================================================================

typedef struct SDMMC3_2P_REGS_s
{
  volatile uint16_t SD_SYS_ADDR_LOW0;  ///< 0x0 [R/W]: SDMA System Address / Argument 2 (Low) Register (Instance 1 of 2)
  volatile uint16_t SD_SYS_ADDR_HIGH0;  ///< 0x2 [R/W]: System Address High Register (Instance 1 of 2)
  volatile uint16_t SD_BLOCK_SIZE0;  ///< 0x4 [R/W]: Block Size Register (Instance 1 of 2)
  volatile uint16_t SD_BLOCK_COUNT0;  ///< 0x6 [R/W]: Block Count Register (Instance 1 of 2)
  volatile uint16_t SD_ARG_LOW0;  ///< 0x8 [R/W]: Argument Low Register (Instance 1 of 2)
  volatile uint16_t SD_ARG_HIGH0;  ///< 0xA [R/W]: Argument High Register (Instance 1 of 2)
  volatile uint16_t SD_TRANSFER_MODE0;  ///< 0xC [R/W]: Transfer Mode Register (Instance 1 of 2)
  volatile uint16_t SD_CMD0;  ///< 0xE [R/W]: Command Register (Instance 1 of 2)
  volatile uint16_t SD_RESP_00;  ///< 0x10 [R]: Response Register 0 (Instance 1 of 2)
  volatile uint16_t SD_RESP_10;  ///< 0x12 [R]: Response Register 1 (Instance 1 of 2)
  volatile uint16_t SD_RESP_20;  ///< 0x14 [R]: Response Register 2 (Instance 1 of 2)
  volatile uint16_t SD_RESP_30;  ///< 0x16 [R]: Response Register 3 (Instance 1 of 2)
  volatile uint16_t SD_RESP_40;  ///< 0x18 [R]: Response Register 4 (Instance 1 of 2)
  volatile uint16_t SD_RESP_50;  ///< 0x1A [R]: Response Register 5 (Instance 1 of 2)
  volatile uint16_t SD_RESP_60;  ///< 0x1C [R]: Response Register 6 (Instance 1 of 2)
  volatile uint16_t SD_RESP_70;  ///< 0x1E [R]: Response Register 7 (Instance 1 of 2)
  volatile uint16_t SD_BUFFER_DATA_PORT_00;  ///< 0x20 [R/W]: Buffer Data Port 0 Register (Instance 1 of 2)
  volatile uint16_t SD_BUFFER_DATA_PORT_10;  ///< 0x22 [R/W]: Buffer Data Port 1 Register (Instance 1 of 2)
  volatile uint16_t SD_PRESENT_STATE_00;  ///< 0x24 [R/W]: Present State Register 0 (Instance 1 of 2)
  volatile uint16_t SD_PRESENT_STATE_10;  ///< 0x26 [R]: Present State Register 1 (Instance 1 of 2)
  volatile uint16_t SD_HOST_CTRL0;  ///< 0x28 [R/W]: Host Control Register (Instance 1 of 2)
  volatile uint16_t SD_BLOCK_GAP_CTRL0;  ///< 0x2A [R/W]: Block Gap Control Register (Instance 1 of 2)
  volatile uint16_t SD_CLOCK_CTRL0;  ///< 0x2C [R/W]: Clock Control Register (Instance 1 of 2)
  volatile uint16_t SD_TIMEOUT_CTRL_SW_RESET0;  ///< 0x2E [R/W]: Timeout Control/Software Reset Register (Instance 1 of 2)
  volatile uint16_t SD_NORMAL_INT_STATUS0;  ///< 0x30 [R/W]: Normal Interrupt Status Register (Instance 1 of 2)
  volatile uint16_t SD_ERROR_INT_STATUS0;  ///< 0x32 [R/W]: Error Interrupt Status Register (Instance 1 of 2)
  volatile uint16_t SD_NORMAL_INT_STATUS_EN0;  ///< 0x34 [R/W]: Normal Interrupt Status Enable Register (Instance 1 of 2)
  volatile uint16_t SD_ERROR_INT_STATUS_EN0;  ///< 0x36 [R/W]: Error Interrupt Status Enable Register (Instance 1 of 2)
  volatile uint16_t SD_NORMAL_INT_STATUS_INT_EN0;  ///< 0x38 [R/W]: Normal Interrupt Signal Enable Register (Instance 1 of 2)
  volatile uint16_t SD_ERROR_INT_STATUS_INT_EN0;  ///< 0x3A [R/W]: Error Interrupt Signal Enable Register (Instance 1 of 2)
  volatile uint16_t SD_AUTO_CMD12_ERROR_STATUS0;  ///< 0x3C [R/W]: Auto CMD12 Error Status Register (Instance 1 of 2)
  volatile uint16_t SD_HOST_CTRL20;  ///< 0x3E [R/W]: Host Control Register 2 (Instance 1 of 2)
  volatile uint16_t SD_CAPABILITIES_00;  ///< 0x40 [R]: Capabilities Register 0 (Instance 1 of 2)
  volatile uint16_t SD_CAPABILITIES_10;  ///< 0x42 [R]: Capabilities Register 1 (Instance 1 of 2)
  volatile uint16_t SD_CAPABILITIES_20;  ///< 0x44 [R]: Capabilities Register 2 (Instance 1 of 2)
  volatile uint16_t SD_CAPABILITIES_30;  ///< 0x46 [R]: Capabilities Register 3 (Instance 1 of 2)
  volatile uint16_t SD_MAX_CURRENT_00;  ///< 0x48 [R]: Maximum Current Register 0 (Instance 1 of 2)
  volatile uint16_t SD_MAX_CURRENT_10;  ///< 0x4A [R]: Maximum Current Register 1 (Instance 1 of 2)
  volatile uint16_t SD_MAX_CURRENT_20;  ///< 0x4C [R]: Maximum Current Register 2 (Instance 1 of 2)
  volatile uint16_t SD_MAX_CURRENT_30;  ///< 0x4E [R]: Maximum Current Register 3 (Instance 1 of 2)
  volatile uint16_t SD_FORCE_EVENT_AUTO_CMD12_ERROR0;  ///< 0x50 [W]: Force Event Auto cmd12 Error Register (Instance 1 of 2)
  volatile uint16_t SD_FORCE_EVENT_FOR_ERROR_STATUS0;  ///< 0x52 [W]: Force Event for Error Status Register (Instance 1 of 2)
  volatile uint16_t SD_ADMA_ERROR_STATUS0;  ///< 0x54 [R/W]: ADMA Error Status Register (Instance 1 of 2)
  volatile uint16_t reserved0;
  volatile uint16_t SD_ADMA_SYS_ADDR_00;  ///< 0x58 [R/W]: ADMA System Address Register 0 (Instance 1 of 2)
  volatile uint16_t SD_ADMA_SYS_ADDR_10;  ///< 0x5A [R/W]: ADMA System Address Register 1 (Instance 1 of 2)
  volatile uint16_t SD_ADMA_SYS_ADDR_20;  ///< 0x5C [R/W]: ADMA System Address Register 2 (Instance 1 of 2)
  volatile uint16_t SD_ADMA_SYS_ADDR_30;  ///< 0x5E [R/W]: ADMA System Address Register 3 (Instance 1 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_INIT0;  ///< 0x60 [R]: Preset Value Regiser for Initialization (Instance 1 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_DS0;  ///< 0x62 [R]: Preset Value Regiser for Default Speed (Instance 1 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_HS0;  ///< 0x64 [R]: Preset Value Regiser for High Speed (Instance 1 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_SDR120;  ///< 0x66 [R]: Preset Value Regiser for SDR12 (Instance 1 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_SDR250;  ///< 0x68 [R]: Preset Value Regiser for SDR25 (Instance 1 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_SDR500;  ///< 0x6A [R]: Preset Value Regiser for SDR50 (Instance 1 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_SDR1040;  ///< 0x6C [R]: Preset Value Regiser for SDR104 (Instance 1 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_DDR500;  ///< 0x6E [R]: Preset Value Regiser for DDR50 (Instance 1 of 2)
  volatile uint16_t reserved1[56];
  volatile uint16_t SD_SHARED_BUS_CTRL_LOW0;  ///< 0xE0 [R/W]: Shared Bus Control Register (Low) (Instance 1 of 2)
  volatile uint16_t SD_SHARED_BUS_CTRL_HIGH0;  ///< 0xE2 [R/W]: Shared Bus Control Register (High) (Instance 1 of 2)
  volatile uint16_t reserved2[12];
  volatile uint16_t SD_SLOT_INT_STATUS0;  ///< 0xFC [R]: Slot Interrupt Status Register (Instance 1 of 2)
  volatile uint16_t SD_HOST_CTRL_VER0;  ///< 0xFE [R]: Host Control Version Register (Instance 1 of 2)
  volatile uint16_t SD_CFG_FIFO_PARAM_00;  ///< 0x100 [R/W]: SD Extra parameters Register (Low) (Instance 1 of 2)
  volatile uint16_t SD_CFG_FIFO_PARAM_10;  ///< 0x102 [R/W]: SD Extra parameters Register (High) (Instance 1 of 2)
  volatile uint16_t SD_FIFO_PARAM_00;  ///< 0x104 [R/W]: FIFO Parameters Register (LOW) (Instance 1 of 2)
  volatile uint16_t SD_FIFO_PARAM_10;  ///< 0x106 [R/W]: FIFO Parameters Register (High) (Instance 1 of 2)
  volatile uint16_t SD_SPI_MODE0;  ///< 0x108 [R/W]: SPI Mode Register (Instance 1 of 2)
  volatile uint16_t SD_CLOCK_AND_BURST_SIZE_SETUP0;  ///< 0x10A [R/W]: Clock and Burst Size Setup Register (Instance 1 of 2)
  volatile uint16_t SD_CE_ATA_10;  ///< 0x10C [R/W]: CE-ATA Register 0 (Instance 1 of 2)
  volatile uint16_t SD_CE_ATA_20;  ///< 0x10E [R/W]: CE-ATA Register 1 (Instance 1 of 2)
  volatile uint16_t SD_PAD_IO_SETUP00;  ///< 0x110 [R/W]: PAD I/O Setup Register lower (Instance 1 of 2)
  volatile uint16_t SD_PAD_IO_SETUP10;  ///< 0x112 [R/W]: PAD I/O Setup Register upper (Instance 1 of 2)
  volatile uint16_t SD_RX_CFG_00;  ///< 0x114 [R/W]: RX Configuration Register (Low) (Instance 1 of 2)
  volatile uint16_t SD_RX_CFG_10;  ///< 0x116 [R/W]: RX Configuration Register (High) (Instance 1 of 2)
  volatile uint16_t SD_TX_CFG_00;  ///< 0x118 [R/W]: TX Configuration Register (Low) (Instance 1 of 2)
  volatile uint16_t SD_TX_CFG_10;  ///< 0x11A [R/W]: TX Configuration Register (HIGH) (Instance 1 of 2)
  volatile uint16_t TUNING_CFG_REG_00;  ///< 0x11C [R/W]: Tuning Configuration Register (Low) (Instance 1 of 2)
  volatile uint16_t TUNING_CFG_REG_10;  ///< 0x11E [R/W]: Tuning Configuration Register (HIGH) (Instance 1 of 2)
  volatile uint16_t SD_DBG_000;  ///< 0x120 [R/W]: Debug Register 0 (Low) (Instance 1 of 2)
  volatile uint16_t SD_DBG_010;  ///< 0x122 [R/W]: Debug Register 0 (High) (Instance 1 of 2)
  volatile uint16_t SD_DBG_100;  ///< 0x124 [R/W]: Debug Register 1 (Low) (Instance 1 of 2)
  volatile uint16_t SD_DBG_110;  ///< 0x126 [R/W]: Debug Register 1 (High) (Instance 1 of 2)
  volatile uint16_t SD_DBG_200;  ///< 0x128 [R/W]: Debug Register 2 (Low) (Instance 1 of 2)
  volatile uint16_t SD_DBG_210;  ///< 0x12A [R/W]: Debug Register 2 (High) (Instance 1 of 2)
  volatile uint16_t SD_DBG_300;  ///< 0x12C [R/W]: Debug Register 3 (Low) (Instance 1 of 2)
  volatile uint16_t SD_DBG_310;  ///< 0x12E [R/W]: Debug Register 3 (High) (Instance 1 of 2)
  volatile uint16_t SD_DBG_400;  ///< 0x130 [R/W]: Debug Register 4 (Low) (Instance 1 of 2)
  volatile uint16_t SD_DBG_410;  ///< 0x132 [R/W]: Debug Register 4 (High) (Instance 1 of 2)
  volatile uint16_t SD_DBG_500;  ///< 0x134 [R/W]: Debug Register 5 (Low) (Instance 1 of 2)
  volatile uint16_t SD_DBG_510;  ///< 0x136 [R/W]: Debug Register 5 (High) (Instance 1 of 2)
  volatile uint16_t SD_DBG_600;  ///< 0x138 [R/W]: Debug Register 6 (Low) (Instance 1 of 2)
  volatile uint16_t SD_DBG_610;  ///< 0x13A [R/W]: Debug Register 6 (High) (Instance 1 of 2)
  volatile uint16_t SD_DBG_700;  ///< 0x13C [R/W]: Debug Register 7 (Low) (Instance 1 of 2)
  volatile uint16_t SD_DBG_710;  ///< 0x13E [R/W]: Debug Register 7 (High) (Instance 1 of 2)
  volatile uint16_t reserved3[92];
  volatile uint16_t INT_VER_000;  ///< 0x1F8 [R]: Internal Version Register 0 (Low) (Instance 1 of 2)
  volatile uint16_t INT_VER_010;  ///< 0x1FA [R]: Internal Version Register 0 (High) (Instance 1 of 2)
  volatile uint16_t INT_VER_100;  ///< 0x1FC [R]: Internal Version Register 1 (Low) (Instance 1 of 2)
  volatile uint16_t INT_VER_110;  ///< 0x1FE [R]: Internal Version Register 1 (High) (Instance 1 of 2)
  volatile uint16_t reserved4[768];
  volatile uint16_t SD_SYS_ADDR_LOW1;  ///< 0x1000 [R/W]: SDMA System Address / Argument 2 (Low) Register (Instance 2 of 2)
  volatile uint16_t SD_SYS_ADDR_HIGH1;  ///< 0x1002 [R/W]: System Address High Register (Instance 2 of 2)
  volatile uint16_t SD_BLOCK_SIZE1;  ///< 0x1004 [R/W]: Block Size Register (Instance 2 of 2)
  volatile uint16_t SD_BLOCK_COUNT1;  ///< 0x1006 [R/W]: Block Count Register (Instance 2 of 2)
  volatile uint16_t SD_ARG_LOW1;  ///< 0x1008 [R/W]: Argument Low Register (Instance 2 of 2)
  volatile uint16_t SD_ARG_HIGH1;  ///< 0x100A [R/W]: Argument High Register (Instance 2 of 2)
  volatile uint16_t SD_TRANSFER_MODE1;  ///< 0x100C [R/W]: Transfer Mode Register (Instance 2 of 2)
  volatile uint16_t SD_CMD1;  ///< 0x100E [R/W]: Command Register (Instance 2 of 2)
  volatile uint16_t SD_RESP_01;  ///< 0x1010 [R]: Response Register 0 (Instance 2 of 2)
  volatile uint16_t SD_RESP_11;  ///< 0x1012 [R]: Response Register 1 (Instance 2 of 2)
  volatile uint16_t SD_RESP_21;  ///< 0x1014 [R]: Response Register 2 (Instance 2 of 2)
  volatile uint16_t SD_RESP_31;  ///< 0x1016 [R]: Response Register 3 (Instance 2 of 2)
  volatile uint16_t SD_RESP_41;  ///< 0x1018 [R]: Response Register 4 (Instance 2 of 2)
  volatile uint16_t SD_RESP_51;  ///< 0x101A [R]: Response Register 5 (Instance 2 of 2)
  volatile uint16_t SD_RESP_61;  ///< 0x101C [R]: Response Register 6 (Instance 2 of 2)
  volatile uint16_t SD_RESP_71;  ///< 0x101E [R]: Response Register 7 (Instance 2 of 2)
  volatile uint16_t SD_BUFFER_DATA_PORT_01;  ///< 0x1020 [R/W]: Buffer Data Port 0 Register (Instance 2 of 2)
  volatile uint16_t SD_BUFFER_DATA_PORT_11;  ///< 0x1022 [R/W]: Buffer Data Port 1 Register (Instance 2 of 2)
  volatile uint16_t SD_PRESENT_STATE_01;  ///< 0x1024 [R/W]: Present State Register 0 (Instance 2 of 2)
  volatile uint16_t SD_PRESENT_STATE_11;  ///< 0x1026 [R]: Present State Register 1 (Instance 2 of 2)
  volatile uint16_t SD_HOST_CTRL1;  ///< 0x1028 [R/W]: Host Control Register (Instance 2 of 2)
  volatile uint16_t SD_BLOCK_GAP_CTRL1;  ///< 0x102A [R/W]: Block Gap Control Register (Instance 2 of 2)
  volatile uint16_t SD_CLOCK_CTRL1;  ///< 0x102C [R/W]: Clock Control Register (Instance 2 of 2)
  volatile uint16_t SD_TIMEOUT_CTRL_SW_RESET1;  ///< 0x102E [R/W]: Timeout Control/Software Reset Register (Instance 2 of 2)
  volatile uint16_t SD_NORMAL_INT_STATUS1;  ///< 0x1030 [R/W]: Normal Interrupt Status Register (Instance 2 of 2)
  volatile uint16_t SD_ERROR_INT_STATUS1;  ///< 0x1032 [R/W]: Error Interrupt Status Register (Instance 2 of 2)
  volatile uint16_t SD_NORMAL_INT_STATUS_EN1;  ///< 0x1034 [R/W]: Normal Interrupt Status Enable Register (Instance 2 of 2)
  volatile uint16_t SD_ERROR_INT_STATUS_EN1;  ///< 0x1036 [R/W]: Error Interrupt Status Enable Register (Instance 2 of 2)
  volatile uint16_t SD_NORMAL_INT_STATUS_INT_EN1;  ///< 0x1038 [R/W]: Normal Interrupt Signal Enable Register (Instance 2 of 2)
  volatile uint16_t SD_ERROR_INT_STATUS_INT_EN1;  ///< 0x103A [R/W]: Error Interrupt Signal Enable Register (Instance 2 of 2)
  volatile uint16_t SD_AUTO_CMD12_ERROR_STATUS1;  ///< 0x103C [R/W]: Auto CMD12 Error Status Register (Instance 2 of 2)
  volatile uint16_t SD_HOST_CTRL21;  ///< 0x103E [R/W]: Host Control Register 2 (Instance 2 of 2)
  volatile uint16_t SD_CAPABILITIES_01;  ///< 0x1040 [R]: Capabilities Register 0 (Instance 2 of 2)
  volatile uint16_t SD_CAPABILITIES_11;  ///< 0x1042 [R]: Capabilities Register 1 (Instance 2 of 2)
  volatile uint16_t SD_CAPABILITIES_21;  ///< 0x1044 [R]: Capabilities Register 2 (Instance 2 of 2)
  volatile uint16_t SD_CAPABILITIES_31;  ///< 0x1046 [R]: Capabilities Register 3 (Instance 2 of 2)
  volatile uint16_t SD_MAX_CURRENT_01;  ///< 0x1048 [R]: Maximum Current Register 0 (Instance 2 of 2)
  volatile uint16_t SD_MAX_CURRENT_11;  ///< 0x104A [R]: Maximum Current Register 1 (Instance 2 of 2)
  volatile uint16_t SD_MAX_CURRENT_21;  ///< 0x104C [R]: Maximum Current Register 2 (Instance 2 of 2)
  volatile uint16_t SD_MAX_CURRENT_31;  ///< 0x104E [R]: Maximum Current Register 3 (Instance 2 of 2)
  volatile uint16_t SD_FORCE_EVENT_AUTO_CMD12_ERROR1;  ///< 0x1050 [W]: Force Event Auto cmd12 Error Register (Instance 2 of 2)
  volatile uint16_t SD_FORCE_EVENT_FOR_ERROR_STATUS1;  ///< 0x1052 [W]: Force Event for Error Status Register (Instance 2 of 2)
  volatile uint16_t SD_ADMA_ERROR_STATUS1;  ///< 0x1054 [R/W]: ADMA Error Status Register (Instance 2 of 2)
  volatile uint16_t reserved5;
  volatile uint16_t SD_ADMA_SYS_ADDR_01;  ///< 0x1058 [R/W]: ADMA System Address Register 0 (Instance 2 of 2)
  volatile uint16_t SD_ADMA_SYS_ADDR_11;  ///< 0x105A [R/W]: ADMA System Address Register 1 (Instance 2 of 2)
  volatile uint16_t SD_ADMA_SYS_ADDR_21;  ///< 0x105C [R/W]: ADMA System Address Register 2 (Instance 2 of 2)
  volatile uint16_t SD_ADMA_SYS_ADDR_31;  ///< 0x105E [R/W]: ADMA System Address Register 3 (Instance 2 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_INIT1;  ///< 0x1060 [R]: Preset Value Regiser for Initialization (Instance 2 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_DS1;  ///< 0x1062 [R]: Preset Value Regiser for Default Speed (Instance 2 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_HS1;  ///< 0x1064 [R]: Preset Value Regiser for High Speed (Instance 2 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_SDR121;  ///< 0x1066 [R]: Preset Value Regiser for SDR12 (Instance 2 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_SDR251;  ///< 0x1068 [R]: Preset Value Regiser for SDR25 (Instance 2 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_SDR501;  ///< 0x106A [R]: Preset Value Regiser for SDR50 (Instance 2 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_SDR1041;  ///< 0x106C [R]: Preset Value Regiser for SDR104 (Instance 2 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_DDR501;  ///< 0x106E [R]: Preset Value Regiser for DDR50 (Instance 2 of 2)
  volatile uint16_t reserved6[56];
  volatile uint16_t SD_SHARED_BUS_CTRL_LOW1;  ///< 0x10E0 [R/W]: Shared Bus Control Register (Low) (Instance 2 of 2)
  volatile uint16_t SD_SHARED_BUS_CTRL_HIGH1;  ///< 0x10E2 [R/W]: Shared Bus Control Register (High) (Instance 2 of 2)
  volatile uint16_t reserved7[12];
  volatile uint16_t SD_SLOT_INT_STATUS1;  ///< 0x10FC [R]: Slot Interrupt Status Register (Instance 2 of 2)
  volatile uint16_t SD_HOST_CTRL_VER1;  ///< 0x10FE [R]: Host Control Version Register (Instance 2 of 2)
  volatile uint16_t SD_CFG_FIFO_PARAM_01;  ///< 0x1100 [R/W]: SD Extra parameters Register (Low) (Instance 2 of 2)
  volatile uint16_t SD_CFG_FIFO_PARAM_11;  ///< 0x1102 [R/W]: SD Extra parameters Register (High) (Instance 2 of 2)
  volatile uint16_t SD_FIFO_PARAM_01;  ///< 0x1104 [R/W]: FIFO Parameters Register (LOW) (Instance 2 of 2)
  volatile uint16_t SD_FIFO_PARAM_11;  ///< 0x1106 [R/W]: FIFO Parameters Register (High) (Instance 2 of 2)
  volatile uint16_t SD_SPI_MODE1;  ///< 0x1108 [R/W]: SPI Mode Register (Instance 2 of 2)
  volatile uint16_t SD_CLOCK_AND_BURST_SIZE_SETUP1;  ///< 0x110A [R/W]: Clock and Burst Size Setup Register (Instance 2 of 2)
  volatile uint16_t SD_CE_ATA_11;  ///< 0x110C [R/W]: CE-ATA Register 0 (Instance 2 of 2)
  volatile uint16_t SD_CE_ATA_21;  ///< 0x110E [R/W]: CE-ATA Register 1 (Instance 2 of 2)
  volatile uint16_t SD_PAD_IO_SETUP01;  ///< 0x1110 [R/W]: PAD I/O Setup Register lower (Instance 2 of 2)
  volatile uint16_t SD_PAD_IO_SETUP11;  ///< 0x1112 [R/W]: PAD I/O Setup Register upper (Instance 2 of 2)
  volatile uint16_t SD_RX_CFG_01;  ///< 0x1114 [R/W]: RX Configuration Register (Low) (Instance 2 of 2)
  volatile uint16_t SD_RX_CFG_11;  ///< 0x1116 [R/W]: RX Configuration Register (High) (Instance 2 of 2)
  volatile uint16_t SD_TX_CFG_01;  ///< 0x1118 [R/W]: TX Configuration Register (Low) (Instance 2 of 2)
  volatile uint16_t SD_TX_CFG_11;  ///< 0x111A [R/W]: TX Configuration Register (HIGH) (Instance 2 of 2)
  volatile uint16_t TUNING_CFG_REG_01;  ///< 0x111C [R/W]: Tuning Configuration Register (Low) (Instance 2 of 2)
  volatile uint16_t TUNING_CFG_REG_11;  ///< 0x111E [R/W]: Tuning Configuration Register (HIGH) (Instance 2 of 2)
  volatile uint16_t SD_DBG_001;  ///< 0x1120 [R/W]: Debug Register 0 (Low) (Instance 2 of 2)
  volatile uint16_t SD_DBG_011;  ///< 0x1122 [R/W]: Debug Register 0 (High) (Instance 2 of 2)
  volatile uint16_t SD_DBG_101;  ///< 0x1124 [R/W]: Debug Register 1 (Low) (Instance 2 of 2)
  volatile uint16_t SD_DBG_111;  ///< 0x1126 [R/W]: Debug Register 1 (High) (Instance 2 of 2)
  volatile uint16_t SD_DBG_201;  ///< 0x1128 [R/W]: Debug Register 2 (Low) (Instance 2 of 2)
  volatile uint16_t SD_DBG_211;  ///< 0x112A [R/W]: Debug Register 2 (High) (Instance 2 of 2)
  volatile uint16_t SD_DBG_301;  ///< 0x112C [R/W]: Debug Register 3 (Low) (Instance 2 of 2)
  volatile uint16_t SD_DBG_311;  ///< 0x112E [R/W]: Debug Register 3 (High) (Instance 2 of 2)
  volatile uint16_t SD_DBG_401;  ///< 0x1130 [R/W]: Debug Register 4 (Low) (Instance 2 of 2)
  volatile uint16_t SD_DBG_411;  ///< 0x1132 [R/W]: Debug Register 4 (High) (Instance 2 of 2)
  volatile uint16_t SD_DBG_501;  ///< 0x1134 [R/W]: Debug Register 5 (Low) (Instance 2 of 2)
  volatile uint16_t SD_DBG_511;  ///< 0x1136 [R/W]: Debug Register 5 (High) (Instance 2 of 2)
  volatile uint16_t SD_DBG_601;  ///< 0x1138 [R/W]: Debug Register 6 (Low) (Instance 2 of 2)
  volatile uint16_t SD_DBG_611;  ///< 0x113A [R/W]: Debug Register 6 (High) (Instance 2 of 2)
  volatile uint16_t SD_DBG_701;  ///< 0x113C [R/W]: Debug Register 7 (Low) (Instance 2 of 2)
  volatile uint16_t SD_DBG_711;  ///< 0x113E [R/W]: Debug Register 7 (High) (Instance 2 of 2)
  volatile uint16_t reserved8[92];
  volatile uint16_t INT_VER_001;  ///< 0x11F8 [R]: Internal Version Register 0 (Low) (Instance 2 of 2)
  volatile uint16_t INT_VER_011;  ///< 0x11FA [R]: Internal Version Register 0 (High) (Instance 2 of 2)
  volatile uint16_t INT_VER_101;  ///< 0x11FC [R]: Internal Version Register 1 (Low) (Instance 2 of 2)
  volatile uint16_t INT_VER_111;  ///< 0x11FE [R]: Internal Version Register 1 (High) (Instance 2 of 2)
} SDMMC3_2P_REGS_t;

#endif // SDMMC3_2P
 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _SDMMC3_2P_REGMASKS_H_
#define _SDMMC3_2P_REGMASKS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: SDMMC3 Card Interface (SDMMC3_2p)
/** \brief Top-level register file for SDMMC3 Host Interface Block*/
//
//====================================================================

//====================================================================
//Register: SDMA System Address / Argument 2 (Low) Register (Instance 1 of 2) (SD_SYS_ADDR_LOW0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_SYS_ADDR_LOW0_DMA_ADDR_L_MASK 0xffff
#define  SDMMC3_2P_SD_SYS_ADDR_LOW0_DMA_ADDR_L_SHIFT 0
#define  SDMMC3_2P_SD_SYS_ADDR_LOW0_DMA_ADDR_L_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SYS_ADDR_LOW0_DMA_ADDR_L_MASK) >> SDMMC3_2P_SD_SYS_ADDR_LOW0_DMA_ADDR_L_SHIFT)
#define  SDMMC3_2P_SD_SYS_ADDR_LOW0_DMA_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SYS_ADDR_LOW0_DMA_ADDR_L_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SYS_ADDR_LOW0_DMA_ADDR_L_SHIFT))

//====================================================================
//Register: SDMA System Address / Argument 2 (Low) Register (Instance 2 of 2) (SD_SYS_ADDR_LOW1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_SYS_ADDR_LOW1_DMA_ADDR_L_MASK 0xffff
#define  SDMMC3_2P_SD_SYS_ADDR_LOW1_DMA_ADDR_L_SHIFT 0
#define  SDMMC3_2P_SD_SYS_ADDR_LOW1_DMA_ADDR_L_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SYS_ADDR_LOW1_DMA_ADDR_L_MASK) >> SDMMC3_2P_SD_SYS_ADDR_LOW1_DMA_ADDR_L_SHIFT)
#define  SDMMC3_2P_SD_SYS_ADDR_LOW1_DMA_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SYS_ADDR_LOW1_DMA_ADDR_L_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SYS_ADDR_LOW1_DMA_ADDR_L_SHIFT))

//====================================================================
//Register: System Address High Register (Instance 1 of 2) (SD_SYS_ADDR_HIGH0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_SYS_ADDR_HIGH0_DMA_ADDR_H_MASK 0xffff
#define  SDMMC3_2P_SD_SYS_ADDR_HIGH0_DMA_ADDR_H_SHIFT 0
#define  SDMMC3_2P_SD_SYS_ADDR_HIGH0_DMA_ADDR_H_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SYS_ADDR_HIGH0_DMA_ADDR_H_MASK) >> SDMMC3_2P_SD_SYS_ADDR_HIGH0_DMA_ADDR_H_SHIFT)
#define  SDMMC3_2P_SD_SYS_ADDR_HIGH0_DMA_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SYS_ADDR_HIGH0_DMA_ADDR_H_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SYS_ADDR_HIGH0_DMA_ADDR_H_SHIFT))

//====================================================================
//Register: System Address High Register (Instance 2 of 2) (SD_SYS_ADDR_HIGH1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_SYS_ADDR_HIGH1_DMA_ADDR_H_MASK 0xffff
#define  SDMMC3_2P_SD_SYS_ADDR_HIGH1_DMA_ADDR_H_SHIFT 0
#define  SDMMC3_2P_SD_SYS_ADDR_HIGH1_DMA_ADDR_H_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SYS_ADDR_HIGH1_DMA_ADDR_H_MASK) >> SDMMC3_2P_SD_SYS_ADDR_HIGH1_DMA_ADDR_H_SHIFT)
#define  SDMMC3_2P_SD_SYS_ADDR_HIGH1_DMA_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SYS_ADDR_HIGH1_DMA_ADDR_H_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SYS_ADDR_HIGH1_DMA_ADDR_H_SHIFT))

//====================================================================
//Register: Block Size Register (Instance 1 of 2) (SD_BLOCK_SIZE0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_BLOCK_SIZE0_RESERVED2_MASK 0x8000
#define  SDMMC3_2P_SD_BLOCK_SIZE0_RESERVED2_SHIFT 15
#define  SDMMC3_2P_SD_BLOCK_SIZE0_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_SIZE0_RESERVED2_MASK) >> SDMMC3_2P_SD_BLOCK_SIZE0_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_SIZE0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_SIZE0_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_SIZE0_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_BLOCK_SIZE0_HOST_DMA_BDRY_MASK 0x7000
#define  SDMMC3_2P_SD_BLOCK_SIZE0_HOST_DMA_BDRY_SHIFT 12
#define  SDMMC3_2P_SD_BLOCK_SIZE0_HOST_DMA_BDRY_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_SIZE0_HOST_DMA_BDRY_MASK) >> SDMMC3_2P_SD_BLOCK_SIZE0_HOST_DMA_BDRY_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_SIZE0_HOST_DMA_BDRY_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_SIZE0_HOST_DMA_BDRY_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_SIZE0_HOST_DMA_BDRY_SHIFT))

#define  SDMMC3_2P_SD_BLOCK_SIZE0_BLOCK_SIZE_MASK 0xfff
#define  SDMMC3_2P_SD_BLOCK_SIZE0_BLOCK_SIZE_SHIFT 0
#define  SDMMC3_2P_SD_BLOCK_SIZE0_BLOCK_SIZE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_SIZE0_BLOCK_SIZE_MASK) >> SDMMC3_2P_SD_BLOCK_SIZE0_BLOCK_SIZE_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_SIZE0_BLOCK_SIZE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_SIZE0_BLOCK_SIZE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_SIZE0_BLOCK_SIZE_SHIFT))

//====================================================================
//Register: Block Size Register (Instance 2 of 2) (SD_BLOCK_SIZE1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_BLOCK_SIZE1_RESERVED2_MASK 0x8000
#define  SDMMC3_2P_SD_BLOCK_SIZE1_RESERVED2_SHIFT 15
#define  SDMMC3_2P_SD_BLOCK_SIZE1_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_SIZE1_RESERVED2_MASK) >> SDMMC3_2P_SD_BLOCK_SIZE1_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_SIZE1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_SIZE1_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_SIZE1_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_BLOCK_SIZE1_HOST_DMA_BDRY_MASK 0x7000
#define  SDMMC3_2P_SD_BLOCK_SIZE1_HOST_DMA_BDRY_SHIFT 12
#define  SDMMC3_2P_SD_BLOCK_SIZE1_HOST_DMA_BDRY_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_SIZE1_HOST_DMA_BDRY_MASK) >> SDMMC3_2P_SD_BLOCK_SIZE1_HOST_DMA_BDRY_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_SIZE1_HOST_DMA_BDRY_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_SIZE1_HOST_DMA_BDRY_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_SIZE1_HOST_DMA_BDRY_SHIFT))

#define  SDMMC3_2P_SD_BLOCK_SIZE1_BLOCK_SIZE_MASK 0xfff
#define  SDMMC3_2P_SD_BLOCK_SIZE1_BLOCK_SIZE_SHIFT 0
#define  SDMMC3_2P_SD_BLOCK_SIZE1_BLOCK_SIZE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_SIZE1_BLOCK_SIZE_MASK) >> SDMMC3_2P_SD_BLOCK_SIZE1_BLOCK_SIZE_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_SIZE1_BLOCK_SIZE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_SIZE1_BLOCK_SIZE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_SIZE1_BLOCK_SIZE_SHIFT))

//====================================================================
//Register: Block Count Register (Instance 1 of 2) (SD_BLOCK_COUNT0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_BLOCK_COUNT0_BLOCK_COUNT_MASK 0xffff
#define  SDMMC3_2P_SD_BLOCK_COUNT0_BLOCK_COUNT_SHIFT 0
#define  SDMMC3_2P_SD_BLOCK_COUNT0_BLOCK_COUNT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_COUNT0_BLOCK_COUNT_MASK) >> SDMMC3_2P_SD_BLOCK_COUNT0_BLOCK_COUNT_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_COUNT0_BLOCK_COUNT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_COUNT0_BLOCK_COUNT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_COUNT0_BLOCK_COUNT_SHIFT))

//====================================================================
//Register: Block Count Register (Instance 2 of 2) (SD_BLOCK_COUNT1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_BLOCK_COUNT1_BLOCK_COUNT_MASK 0xffff
#define  SDMMC3_2P_SD_BLOCK_COUNT1_BLOCK_COUNT_SHIFT 0
#define  SDMMC3_2P_SD_BLOCK_COUNT1_BLOCK_COUNT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_COUNT1_BLOCK_COUNT_MASK) >> SDMMC3_2P_SD_BLOCK_COUNT1_BLOCK_COUNT_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_COUNT1_BLOCK_COUNT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_COUNT1_BLOCK_COUNT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_COUNT1_BLOCK_COUNT_SHIFT))

//====================================================================
//Register: Argument Low Register (Instance 1 of 2) (SD_ARG_LOW0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_ARG_LOW0_ARG_L_MASK 0xffff
#define  SDMMC3_2P_SD_ARG_LOW0_ARG_L_SHIFT 0
#define  SDMMC3_2P_SD_ARG_LOW0_ARG_L_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ARG_LOW0_ARG_L_MASK) >> SDMMC3_2P_SD_ARG_LOW0_ARG_L_SHIFT)
#define  SDMMC3_2P_SD_ARG_LOW0_ARG_L_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ARG_LOW0_ARG_L_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ARG_LOW0_ARG_L_SHIFT))

//====================================================================
//Register: Argument Low Register (Instance 2 of 2) (SD_ARG_LOW1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_ARG_LOW1_ARG_L_MASK 0xffff
#define  SDMMC3_2P_SD_ARG_LOW1_ARG_L_SHIFT 0
#define  SDMMC3_2P_SD_ARG_LOW1_ARG_L_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ARG_LOW1_ARG_L_MASK) >> SDMMC3_2P_SD_ARG_LOW1_ARG_L_SHIFT)
#define  SDMMC3_2P_SD_ARG_LOW1_ARG_L_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ARG_LOW1_ARG_L_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ARG_LOW1_ARG_L_SHIFT))

//====================================================================
//Register: Argument High Register (Instance 1 of 2) (SD_ARG_HIGH0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_ARG_HIGH0_ARG_H_MASK 0xffff
#define  SDMMC3_2P_SD_ARG_HIGH0_ARG_H_SHIFT 0
#define  SDMMC3_2P_SD_ARG_HIGH0_ARG_H_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ARG_HIGH0_ARG_H_MASK) >> SDMMC3_2P_SD_ARG_HIGH0_ARG_H_SHIFT)
#define  SDMMC3_2P_SD_ARG_HIGH0_ARG_H_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ARG_HIGH0_ARG_H_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ARG_HIGH0_ARG_H_SHIFT))

//====================================================================
//Register: Argument High Register (Instance 2 of 2) (SD_ARG_HIGH1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_ARG_HIGH1_ARG_H_MASK 0xffff
#define  SDMMC3_2P_SD_ARG_HIGH1_ARG_H_SHIFT 0
#define  SDMMC3_2P_SD_ARG_HIGH1_ARG_H_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ARG_HIGH1_ARG_H_MASK) >> SDMMC3_2P_SD_ARG_HIGH1_ARG_H_SHIFT)
#define  SDMMC3_2P_SD_ARG_HIGH1_ARG_H_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ARG_HIGH1_ARG_H_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ARG_HIGH1_ARG_H_SHIFT))

//====================================================================
//Register: Transfer Mode Register (Instance 1 of 2) (SD_TRANSFER_MODE0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_TRANSFER_MODE0_RESERVED2_MASK 0xffc0
#define  SDMMC3_2P_SD_TRANSFER_MODE0_RESERVED2_SHIFT 6
#define  SDMMC3_2P_SD_TRANSFER_MODE0_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TRANSFER_MODE0_RESERVED2_MASK) >> SDMMC3_2P_SD_TRANSFER_MODE0_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_TRANSFER_MODE0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TRANSFER_MODE0_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TRANSFER_MODE0_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_TRANSFER_MODE0_MULTI_BLK_SEL_MASK 0x20
#define  SDMMC3_2P_SD_TRANSFER_MODE0_MULTI_BLK_SEL_SHIFT 5
#define  SDMMC3_2P_SD_TRANSFER_MODE0_MULTI_BLK_SEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TRANSFER_MODE0_MULTI_BLK_SEL_MASK) >> SDMMC3_2P_SD_TRANSFER_MODE0_MULTI_BLK_SEL_SHIFT)
#define  SDMMC3_2P_SD_TRANSFER_MODE0_MULTI_BLK_SEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TRANSFER_MODE0_MULTI_BLK_SEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TRANSFER_MODE0_MULTI_BLK_SEL_SHIFT))

#define  SDMMC3_2P_SD_TRANSFER_MODE0_TO_HOST_DIR_MASK 0x10
#define  SDMMC3_2P_SD_TRANSFER_MODE0_TO_HOST_DIR_SHIFT 4
#define  SDMMC3_2P_SD_TRANSFER_MODE0_TO_HOST_DIR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TRANSFER_MODE0_TO_HOST_DIR_MASK) >> SDMMC3_2P_SD_TRANSFER_MODE0_TO_HOST_DIR_SHIFT)
#define  SDMMC3_2P_SD_TRANSFER_MODE0_TO_HOST_DIR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TRANSFER_MODE0_TO_HOST_DIR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TRANSFER_MODE0_TO_HOST_DIR_SHIFT))

#define  SDMMC3_2P_SD_TRANSFER_MODE0_RESERVED3_MASK 0x8
#define  SDMMC3_2P_SD_TRANSFER_MODE0_RESERVED3_SHIFT 3
#define  SDMMC3_2P_SD_TRANSFER_MODE0_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TRANSFER_MODE0_RESERVED3_MASK) >> SDMMC3_2P_SD_TRANSFER_MODE0_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_TRANSFER_MODE0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TRANSFER_MODE0_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TRANSFER_MODE0_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_TRANSFER_MODE0_AUTO_CMD12_EN_MASK 0x4
#define  SDMMC3_2P_SD_TRANSFER_MODE0_AUTO_CMD12_EN_SHIFT 2
#define  SDMMC3_2P_SD_TRANSFER_MODE0_AUTO_CMD12_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TRANSFER_MODE0_AUTO_CMD12_EN_MASK) >> SDMMC3_2P_SD_TRANSFER_MODE0_AUTO_CMD12_EN_SHIFT)
#define  SDMMC3_2P_SD_TRANSFER_MODE0_AUTO_CMD12_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TRANSFER_MODE0_AUTO_CMD12_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TRANSFER_MODE0_AUTO_CMD12_EN_SHIFT))

#define  SDMMC3_2P_SD_TRANSFER_MODE0_BLK_CNT_EN_MASK 0x2
#define  SDMMC3_2P_SD_TRANSFER_MODE0_BLK_CNT_EN_SHIFT 1
#define  SDMMC3_2P_SD_TRANSFER_MODE0_BLK_CNT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TRANSFER_MODE0_BLK_CNT_EN_MASK) >> SDMMC3_2P_SD_TRANSFER_MODE0_BLK_CNT_EN_SHIFT)
#define  SDMMC3_2P_SD_TRANSFER_MODE0_BLK_CNT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TRANSFER_MODE0_BLK_CNT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TRANSFER_MODE0_BLK_CNT_EN_SHIFT))

#define  SDMMC3_2P_SD_TRANSFER_MODE0_DMA_EN_MASK 0x1
#define  SDMMC3_2P_SD_TRANSFER_MODE0_DMA_EN_SHIFT 0
#define  SDMMC3_2P_SD_TRANSFER_MODE0_DMA_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TRANSFER_MODE0_DMA_EN_MASK) >> SDMMC3_2P_SD_TRANSFER_MODE0_DMA_EN_SHIFT)
#define  SDMMC3_2P_SD_TRANSFER_MODE0_DMA_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TRANSFER_MODE0_DMA_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TRANSFER_MODE0_DMA_EN_SHIFT))

//====================================================================
//Register: Transfer Mode Register (Instance 2 of 2) (SD_TRANSFER_MODE1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_TRANSFER_MODE1_RESERVED2_MASK 0xffc0
#define  SDMMC3_2P_SD_TRANSFER_MODE1_RESERVED2_SHIFT 6
#define  SDMMC3_2P_SD_TRANSFER_MODE1_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TRANSFER_MODE1_RESERVED2_MASK) >> SDMMC3_2P_SD_TRANSFER_MODE1_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_TRANSFER_MODE1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TRANSFER_MODE1_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TRANSFER_MODE1_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_TRANSFER_MODE1_MULTI_BLK_SEL_MASK 0x20
#define  SDMMC3_2P_SD_TRANSFER_MODE1_MULTI_BLK_SEL_SHIFT 5
#define  SDMMC3_2P_SD_TRANSFER_MODE1_MULTI_BLK_SEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TRANSFER_MODE1_MULTI_BLK_SEL_MASK) >> SDMMC3_2P_SD_TRANSFER_MODE1_MULTI_BLK_SEL_SHIFT)
#define  SDMMC3_2P_SD_TRANSFER_MODE1_MULTI_BLK_SEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TRANSFER_MODE1_MULTI_BLK_SEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TRANSFER_MODE1_MULTI_BLK_SEL_SHIFT))

#define  SDMMC3_2P_SD_TRANSFER_MODE1_TO_HOST_DIR_MASK 0x10
#define  SDMMC3_2P_SD_TRANSFER_MODE1_TO_HOST_DIR_SHIFT 4
#define  SDMMC3_2P_SD_TRANSFER_MODE1_TO_HOST_DIR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TRANSFER_MODE1_TO_HOST_DIR_MASK) >> SDMMC3_2P_SD_TRANSFER_MODE1_TO_HOST_DIR_SHIFT)
#define  SDMMC3_2P_SD_TRANSFER_MODE1_TO_HOST_DIR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TRANSFER_MODE1_TO_HOST_DIR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TRANSFER_MODE1_TO_HOST_DIR_SHIFT))

#define  SDMMC3_2P_SD_TRANSFER_MODE1_RESERVED3_MASK 0x8
#define  SDMMC3_2P_SD_TRANSFER_MODE1_RESERVED3_SHIFT 3
#define  SDMMC3_2P_SD_TRANSFER_MODE1_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TRANSFER_MODE1_RESERVED3_MASK) >> SDMMC3_2P_SD_TRANSFER_MODE1_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_TRANSFER_MODE1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TRANSFER_MODE1_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TRANSFER_MODE1_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_TRANSFER_MODE1_AUTO_CMD12_EN_MASK 0x4
#define  SDMMC3_2P_SD_TRANSFER_MODE1_AUTO_CMD12_EN_SHIFT 2
#define  SDMMC3_2P_SD_TRANSFER_MODE1_AUTO_CMD12_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TRANSFER_MODE1_AUTO_CMD12_EN_MASK) >> SDMMC3_2P_SD_TRANSFER_MODE1_AUTO_CMD12_EN_SHIFT)
#define  SDMMC3_2P_SD_TRANSFER_MODE1_AUTO_CMD12_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TRANSFER_MODE1_AUTO_CMD12_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TRANSFER_MODE1_AUTO_CMD12_EN_SHIFT))

#define  SDMMC3_2P_SD_TRANSFER_MODE1_BLK_CNT_EN_MASK 0x2
#define  SDMMC3_2P_SD_TRANSFER_MODE1_BLK_CNT_EN_SHIFT 1
#define  SDMMC3_2P_SD_TRANSFER_MODE1_BLK_CNT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TRANSFER_MODE1_BLK_CNT_EN_MASK) >> SDMMC3_2P_SD_TRANSFER_MODE1_BLK_CNT_EN_SHIFT)
#define  SDMMC3_2P_SD_TRANSFER_MODE1_BLK_CNT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TRANSFER_MODE1_BLK_CNT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TRANSFER_MODE1_BLK_CNT_EN_SHIFT))

#define  SDMMC3_2P_SD_TRANSFER_MODE1_DMA_EN_MASK 0x1
#define  SDMMC3_2P_SD_TRANSFER_MODE1_DMA_EN_SHIFT 0
#define  SDMMC3_2P_SD_TRANSFER_MODE1_DMA_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TRANSFER_MODE1_DMA_EN_MASK) >> SDMMC3_2P_SD_TRANSFER_MODE1_DMA_EN_SHIFT)
#define  SDMMC3_2P_SD_TRANSFER_MODE1_DMA_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TRANSFER_MODE1_DMA_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TRANSFER_MODE1_DMA_EN_SHIFT))

//====================================================================
//Register: Command Register (Instance 1 of 2) (SD_CMD0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_CMD0_RESERVED2_MASK 0xc000
#define  SDMMC3_2P_SD_CMD0_RESERVED2_SHIFT 14
#define  SDMMC3_2P_SD_CMD0_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CMD0_RESERVED2_MASK) >> SDMMC3_2P_SD_CMD0_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_CMD0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CMD0_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CMD0_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_CMD0_CMD_INDEX_MASK 0x3f00
#define  SDMMC3_2P_SD_CMD0_CMD_INDEX_SHIFT 8
#define  SDMMC3_2P_SD_CMD0_CMD_INDEX_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CMD0_CMD_INDEX_MASK) >> SDMMC3_2P_SD_CMD0_CMD_INDEX_SHIFT)
#define  SDMMC3_2P_SD_CMD0_CMD_INDEX_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CMD0_CMD_INDEX_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CMD0_CMD_INDEX_SHIFT))

#define  SDMMC3_2P_SD_CMD0_CMD_TYPE_MASK 0xc0
#define  SDMMC3_2P_SD_CMD0_CMD_TYPE_SHIFT 6
#define  SDMMC3_2P_SD_CMD0_CMD_TYPE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CMD0_CMD_TYPE_MASK) >> SDMMC3_2P_SD_CMD0_CMD_TYPE_SHIFT)
#define  SDMMC3_2P_SD_CMD0_CMD_TYPE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CMD0_CMD_TYPE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CMD0_CMD_TYPE_SHIFT))

#define  SDMMC3_2P_SD_CMD0_DATA_PRESENT_MASK 0x20
#define  SDMMC3_2P_SD_CMD0_DATA_PRESENT_SHIFT 5
#define  SDMMC3_2P_SD_CMD0_DATA_PRESENT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CMD0_DATA_PRESENT_MASK) >> SDMMC3_2P_SD_CMD0_DATA_PRESENT_SHIFT)
#define  SDMMC3_2P_SD_CMD0_DATA_PRESENT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CMD0_DATA_PRESENT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CMD0_DATA_PRESENT_SHIFT))

#define  SDMMC3_2P_SD_CMD0_CMD_INDEX_CHK_EN_MASK 0x10
#define  SDMMC3_2P_SD_CMD0_CMD_INDEX_CHK_EN_SHIFT 4
#define  SDMMC3_2P_SD_CMD0_CMD_INDEX_CHK_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CMD0_CMD_INDEX_CHK_EN_MASK) >> SDMMC3_2P_SD_CMD0_CMD_INDEX_CHK_EN_SHIFT)
#define  SDMMC3_2P_SD_CMD0_CMD_INDEX_CHK_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CMD0_CMD_INDEX_CHK_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CMD0_CMD_INDEX_CHK_EN_SHIFT))

#define  SDMMC3_2P_SD_CMD0_CMD_CRC_CHK_EN_MASK 0x8
#define  SDMMC3_2P_SD_CMD0_CMD_CRC_CHK_EN_SHIFT 3
#define  SDMMC3_2P_SD_CMD0_CMD_CRC_CHK_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CMD0_CMD_CRC_CHK_EN_MASK) >> SDMMC3_2P_SD_CMD0_CMD_CRC_CHK_EN_SHIFT)
#define  SDMMC3_2P_SD_CMD0_CMD_CRC_CHK_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CMD0_CMD_CRC_CHK_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CMD0_CMD_CRC_CHK_EN_SHIFT))

#define  SDMMC3_2P_SD_CMD0_RESERVED3_MASK 0x4
#define  SDMMC3_2P_SD_CMD0_RESERVED3_SHIFT 2
#define  SDMMC3_2P_SD_CMD0_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CMD0_RESERVED3_MASK) >> SDMMC3_2P_SD_CMD0_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_CMD0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CMD0_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CMD0_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_CMD0_RESP_TYPE_MASK 0x3
#define  SDMMC3_2P_SD_CMD0_RESP_TYPE_SHIFT 0
#define  SDMMC3_2P_SD_CMD0_RESP_TYPE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CMD0_RESP_TYPE_MASK) >> SDMMC3_2P_SD_CMD0_RESP_TYPE_SHIFT)
#define  SDMMC3_2P_SD_CMD0_RESP_TYPE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CMD0_RESP_TYPE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CMD0_RESP_TYPE_SHIFT))

//====================================================================
//Register: Command Register (Instance 2 of 2) (SD_CMD1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_CMD1_RESERVED2_MASK 0xc000
#define  SDMMC3_2P_SD_CMD1_RESERVED2_SHIFT 14
#define  SDMMC3_2P_SD_CMD1_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CMD1_RESERVED2_MASK) >> SDMMC3_2P_SD_CMD1_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_CMD1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CMD1_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CMD1_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_CMD1_CMD_INDEX_MASK 0x3f00
#define  SDMMC3_2P_SD_CMD1_CMD_INDEX_SHIFT 8
#define  SDMMC3_2P_SD_CMD1_CMD_INDEX_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CMD1_CMD_INDEX_MASK) >> SDMMC3_2P_SD_CMD1_CMD_INDEX_SHIFT)
#define  SDMMC3_2P_SD_CMD1_CMD_INDEX_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CMD1_CMD_INDEX_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CMD1_CMD_INDEX_SHIFT))

#define  SDMMC3_2P_SD_CMD1_CMD_TYPE_MASK 0xc0
#define  SDMMC3_2P_SD_CMD1_CMD_TYPE_SHIFT 6
#define  SDMMC3_2P_SD_CMD1_CMD_TYPE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CMD1_CMD_TYPE_MASK) >> SDMMC3_2P_SD_CMD1_CMD_TYPE_SHIFT)
#define  SDMMC3_2P_SD_CMD1_CMD_TYPE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CMD1_CMD_TYPE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CMD1_CMD_TYPE_SHIFT))

#define  SDMMC3_2P_SD_CMD1_DATA_PRESENT_MASK 0x20
#define  SDMMC3_2P_SD_CMD1_DATA_PRESENT_SHIFT 5
#define  SDMMC3_2P_SD_CMD1_DATA_PRESENT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CMD1_DATA_PRESENT_MASK) >> SDMMC3_2P_SD_CMD1_DATA_PRESENT_SHIFT)
#define  SDMMC3_2P_SD_CMD1_DATA_PRESENT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CMD1_DATA_PRESENT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CMD1_DATA_PRESENT_SHIFT))

#define  SDMMC3_2P_SD_CMD1_CMD_INDEX_CHK_EN_MASK 0x10
#define  SDMMC3_2P_SD_CMD1_CMD_INDEX_CHK_EN_SHIFT 4
#define  SDMMC3_2P_SD_CMD1_CMD_INDEX_CHK_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CMD1_CMD_INDEX_CHK_EN_MASK) >> SDMMC3_2P_SD_CMD1_CMD_INDEX_CHK_EN_SHIFT)
#define  SDMMC3_2P_SD_CMD1_CMD_INDEX_CHK_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CMD1_CMD_INDEX_CHK_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CMD1_CMD_INDEX_CHK_EN_SHIFT))

#define  SDMMC3_2P_SD_CMD1_CMD_CRC_CHK_EN_MASK 0x8
#define  SDMMC3_2P_SD_CMD1_CMD_CRC_CHK_EN_SHIFT 3
#define  SDMMC3_2P_SD_CMD1_CMD_CRC_CHK_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CMD1_CMD_CRC_CHK_EN_MASK) >> SDMMC3_2P_SD_CMD1_CMD_CRC_CHK_EN_SHIFT)
#define  SDMMC3_2P_SD_CMD1_CMD_CRC_CHK_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CMD1_CMD_CRC_CHK_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CMD1_CMD_CRC_CHK_EN_SHIFT))

#define  SDMMC3_2P_SD_CMD1_RESERVED3_MASK 0x4
#define  SDMMC3_2P_SD_CMD1_RESERVED3_SHIFT 2
#define  SDMMC3_2P_SD_CMD1_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CMD1_RESERVED3_MASK) >> SDMMC3_2P_SD_CMD1_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_CMD1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CMD1_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CMD1_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_CMD1_RESP_TYPE_MASK 0x3
#define  SDMMC3_2P_SD_CMD1_RESP_TYPE_SHIFT 0
#define  SDMMC3_2P_SD_CMD1_RESP_TYPE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CMD1_RESP_TYPE_MASK) >> SDMMC3_2P_SD_CMD1_RESP_TYPE_SHIFT)
#define  SDMMC3_2P_SD_CMD1_RESP_TYPE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CMD1_RESP_TYPE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CMD1_RESP_TYPE_SHIFT))

//====================================================================
//Register: Response Register 0 (Instance 1 of 2) (SD_RESP_00)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_RESP_00_RESP0_MASK 0xffff
#define  SDMMC3_2P_SD_RESP_00_RESP0_SHIFT 0
#define  SDMMC3_2P_SD_RESP_00_RESP0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RESP_00_RESP0_MASK) >> SDMMC3_2P_SD_RESP_00_RESP0_SHIFT)
#define  SDMMC3_2P_SD_RESP_00_RESP0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RESP_00_RESP0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RESP_00_RESP0_SHIFT))

//====================================================================
//Register: Response Register 0 (Instance 2 of 2) (SD_RESP_01)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_RESP_01_RESP0_MASK 0xffff
#define  SDMMC3_2P_SD_RESP_01_RESP0_SHIFT 0
#define  SDMMC3_2P_SD_RESP_01_RESP0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RESP_01_RESP0_MASK) >> SDMMC3_2P_SD_RESP_01_RESP0_SHIFT)
#define  SDMMC3_2P_SD_RESP_01_RESP0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RESP_01_RESP0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RESP_01_RESP0_SHIFT))

//====================================================================
//Register: Response Register 1 (Instance 1 of 2) (SD_RESP_10)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_RESP_10_RESP1_MASK 0xffff
#define  SDMMC3_2P_SD_RESP_10_RESP1_SHIFT 0
#define  SDMMC3_2P_SD_RESP_10_RESP1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RESP_10_RESP1_MASK) >> SDMMC3_2P_SD_RESP_10_RESP1_SHIFT)
#define  SDMMC3_2P_SD_RESP_10_RESP1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RESP_10_RESP1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RESP_10_RESP1_SHIFT))

//====================================================================
//Register: Response Register 1 (Instance 2 of 2) (SD_RESP_11)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_RESP_11_RESP1_MASK 0xffff
#define  SDMMC3_2P_SD_RESP_11_RESP1_SHIFT 0
#define  SDMMC3_2P_SD_RESP_11_RESP1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RESP_11_RESP1_MASK) >> SDMMC3_2P_SD_RESP_11_RESP1_SHIFT)
#define  SDMMC3_2P_SD_RESP_11_RESP1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RESP_11_RESP1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RESP_11_RESP1_SHIFT))

//====================================================================
//Register: Response Register 2 (Instance 1 of 2) (SD_RESP_20)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_RESP_20_RESP2_MASK 0xffff
#define  SDMMC3_2P_SD_RESP_20_RESP2_SHIFT 0
#define  SDMMC3_2P_SD_RESP_20_RESP2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RESP_20_RESP2_MASK) >> SDMMC3_2P_SD_RESP_20_RESP2_SHIFT)
#define  SDMMC3_2P_SD_RESP_20_RESP2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RESP_20_RESP2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RESP_20_RESP2_SHIFT))

//====================================================================
//Register: Response Register 2 (Instance 2 of 2) (SD_RESP_21)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_RESP_21_RESP2_MASK 0xffff
#define  SDMMC3_2P_SD_RESP_21_RESP2_SHIFT 0
#define  SDMMC3_2P_SD_RESP_21_RESP2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RESP_21_RESP2_MASK) >> SDMMC3_2P_SD_RESP_21_RESP2_SHIFT)
#define  SDMMC3_2P_SD_RESP_21_RESP2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RESP_21_RESP2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RESP_21_RESP2_SHIFT))

//====================================================================
//Register: Response Register 3 (Instance 1 of 2) (SD_RESP_30)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_RESP_30_RESP3_MASK 0xffff
#define  SDMMC3_2P_SD_RESP_30_RESP3_SHIFT 0
#define  SDMMC3_2P_SD_RESP_30_RESP3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RESP_30_RESP3_MASK) >> SDMMC3_2P_SD_RESP_30_RESP3_SHIFT)
#define  SDMMC3_2P_SD_RESP_30_RESP3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RESP_30_RESP3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RESP_30_RESP3_SHIFT))

//====================================================================
//Register: Response Register 3 (Instance 2 of 2) (SD_RESP_31)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_RESP_31_RESP3_MASK 0xffff
#define  SDMMC3_2P_SD_RESP_31_RESP3_SHIFT 0
#define  SDMMC3_2P_SD_RESP_31_RESP3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RESP_31_RESP3_MASK) >> SDMMC3_2P_SD_RESP_31_RESP3_SHIFT)
#define  SDMMC3_2P_SD_RESP_31_RESP3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RESP_31_RESP3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RESP_31_RESP3_SHIFT))

//====================================================================
//Register: Response Register 4 (Instance 1 of 2) (SD_RESP_40)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_RESP_40_RESP4_MASK 0xffff
#define  SDMMC3_2P_SD_RESP_40_RESP4_SHIFT 0
#define  SDMMC3_2P_SD_RESP_40_RESP4_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RESP_40_RESP4_MASK) >> SDMMC3_2P_SD_RESP_40_RESP4_SHIFT)
#define  SDMMC3_2P_SD_RESP_40_RESP4_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RESP_40_RESP4_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RESP_40_RESP4_SHIFT))

//====================================================================
//Register: Response Register 4 (Instance 2 of 2) (SD_RESP_41)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_RESP_41_RESP4_MASK 0xffff
#define  SDMMC3_2P_SD_RESP_41_RESP4_SHIFT 0
#define  SDMMC3_2P_SD_RESP_41_RESP4_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RESP_41_RESP4_MASK) >> SDMMC3_2P_SD_RESP_41_RESP4_SHIFT)
#define  SDMMC3_2P_SD_RESP_41_RESP4_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RESP_41_RESP4_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RESP_41_RESP4_SHIFT))

//====================================================================
//Register: Response Register 5 (Instance 1 of 2) (SD_RESP_50)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_RESP_50_RESP5_MASK 0xffff
#define  SDMMC3_2P_SD_RESP_50_RESP5_SHIFT 0
#define  SDMMC3_2P_SD_RESP_50_RESP5_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RESP_50_RESP5_MASK) >> SDMMC3_2P_SD_RESP_50_RESP5_SHIFT)
#define  SDMMC3_2P_SD_RESP_50_RESP5_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RESP_50_RESP5_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RESP_50_RESP5_SHIFT))

//====================================================================
//Register: Response Register 5 (Instance 2 of 2) (SD_RESP_51)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_RESP_51_RESP5_MASK 0xffff
#define  SDMMC3_2P_SD_RESP_51_RESP5_SHIFT 0
#define  SDMMC3_2P_SD_RESP_51_RESP5_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RESP_51_RESP5_MASK) >> SDMMC3_2P_SD_RESP_51_RESP5_SHIFT)
#define  SDMMC3_2P_SD_RESP_51_RESP5_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RESP_51_RESP5_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RESP_51_RESP5_SHIFT))

//====================================================================
//Register: Response Register 6 (Instance 1 of 2) (SD_RESP_60)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_RESP_60_RESP6_MASK 0xffff
#define  SDMMC3_2P_SD_RESP_60_RESP6_SHIFT 0
#define  SDMMC3_2P_SD_RESP_60_RESP6_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RESP_60_RESP6_MASK) >> SDMMC3_2P_SD_RESP_60_RESP6_SHIFT)
#define  SDMMC3_2P_SD_RESP_60_RESP6_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RESP_60_RESP6_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RESP_60_RESP6_SHIFT))

//====================================================================
//Register: Response Register 6 (Instance 2 of 2) (SD_RESP_61)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_RESP_61_RESP6_MASK 0xffff
#define  SDMMC3_2P_SD_RESP_61_RESP6_SHIFT 0
#define  SDMMC3_2P_SD_RESP_61_RESP6_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RESP_61_RESP6_MASK) >> SDMMC3_2P_SD_RESP_61_RESP6_SHIFT)
#define  SDMMC3_2P_SD_RESP_61_RESP6_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RESP_61_RESP6_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RESP_61_RESP6_SHIFT))

//====================================================================
//Register: Response Register 7 (Instance 1 of 2) (SD_RESP_70)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_RESP_70_RESP7_MASK 0xffff
#define  SDMMC3_2P_SD_RESP_70_RESP7_SHIFT 0
#define  SDMMC3_2P_SD_RESP_70_RESP7_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RESP_70_RESP7_MASK) >> SDMMC3_2P_SD_RESP_70_RESP7_SHIFT)
#define  SDMMC3_2P_SD_RESP_70_RESP7_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RESP_70_RESP7_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RESP_70_RESP7_SHIFT))

//====================================================================
//Register: Response Register 7 (Instance 2 of 2) (SD_RESP_71)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_RESP_71_RESP7_MASK 0xffff
#define  SDMMC3_2P_SD_RESP_71_RESP7_SHIFT 0
#define  SDMMC3_2P_SD_RESP_71_RESP7_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RESP_71_RESP7_MASK) >> SDMMC3_2P_SD_RESP_71_RESP7_SHIFT)
#define  SDMMC3_2P_SD_RESP_71_RESP7_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RESP_71_RESP7_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RESP_71_RESP7_SHIFT))

//====================================================================
//Register: Buffer Data Port 0 Register (Instance 1 of 2) (SD_BUFFER_DATA_PORT_00)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_BUFFER_DATA_PORT_00_CPU_DATA0_MASK 0xffff
#define  SDMMC3_2P_SD_BUFFER_DATA_PORT_00_CPU_DATA0_SHIFT 0
#define  SDMMC3_2P_SD_BUFFER_DATA_PORT_00_CPU_DATA0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BUFFER_DATA_PORT_00_CPU_DATA0_MASK) >> SDMMC3_2P_SD_BUFFER_DATA_PORT_00_CPU_DATA0_SHIFT)
#define  SDMMC3_2P_SD_BUFFER_DATA_PORT_00_CPU_DATA0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BUFFER_DATA_PORT_00_CPU_DATA0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BUFFER_DATA_PORT_00_CPU_DATA0_SHIFT))

//====================================================================
//Register: Buffer Data Port 0 Register (Instance 2 of 2) (SD_BUFFER_DATA_PORT_01)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_BUFFER_DATA_PORT_01_CPU_DATA0_MASK 0xffff
#define  SDMMC3_2P_SD_BUFFER_DATA_PORT_01_CPU_DATA0_SHIFT 0
#define  SDMMC3_2P_SD_BUFFER_DATA_PORT_01_CPU_DATA0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BUFFER_DATA_PORT_01_CPU_DATA0_MASK) >> SDMMC3_2P_SD_BUFFER_DATA_PORT_01_CPU_DATA0_SHIFT)
#define  SDMMC3_2P_SD_BUFFER_DATA_PORT_01_CPU_DATA0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BUFFER_DATA_PORT_01_CPU_DATA0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BUFFER_DATA_PORT_01_CPU_DATA0_SHIFT))

//====================================================================
//Register: Buffer Data Port 1 Register (Instance 1 of 2) (SD_BUFFER_DATA_PORT_10)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_BUFFER_DATA_PORT_10_CPU_DATA1_MASK 0xffff
#define  SDMMC3_2P_SD_BUFFER_DATA_PORT_10_CPU_DATA1_SHIFT 0
#define  SDMMC3_2P_SD_BUFFER_DATA_PORT_10_CPU_DATA1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BUFFER_DATA_PORT_10_CPU_DATA1_MASK) >> SDMMC3_2P_SD_BUFFER_DATA_PORT_10_CPU_DATA1_SHIFT)
#define  SDMMC3_2P_SD_BUFFER_DATA_PORT_10_CPU_DATA1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BUFFER_DATA_PORT_10_CPU_DATA1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BUFFER_DATA_PORT_10_CPU_DATA1_SHIFT))

//====================================================================
//Register: Buffer Data Port 1 Register (Instance 2 of 2) (SD_BUFFER_DATA_PORT_11)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_BUFFER_DATA_PORT_11_CPU_DATA1_MASK 0xffff
#define  SDMMC3_2P_SD_BUFFER_DATA_PORT_11_CPU_DATA1_SHIFT 0
#define  SDMMC3_2P_SD_BUFFER_DATA_PORT_11_CPU_DATA1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BUFFER_DATA_PORT_11_CPU_DATA1_MASK) >> SDMMC3_2P_SD_BUFFER_DATA_PORT_11_CPU_DATA1_SHIFT)
#define  SDMMC3_2P_SD_BUFFER_DATA_PORT_11_CPU_DATA1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BUFFER_DATA_PORT_11_CPU_DATA1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BUFFER_DATA_PORT_11_CPU_DATA1_SHIFT))

//====================================================================
//Register: Present State Register 0 (Instance 1 of 2) (SD_PRESENT_STATE_00)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_PRESENT_STATE_00_RESERVED2_MASK 0xf000
#define  SDMMC3_2P_SD_PRESENT_STATE_00_RESERVED2_SHIFT 12
#define  SDMMC3_2P_SD_PRESENT_STATE_00_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_00_RESERVED2_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_00_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_00_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_00_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_00_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_00_BUFFER_RD_EN_MASK 0x800
#define  SDMMC3_2P_SD_PRESENT_STATE_00_BUFFER_RD_EN_SHIFT 11
#define  SDMMC3_2P_SD_PRESENT_STATE_00_BUFFER_RD_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_00_BUFFER_RD_EN_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_00_BUFFER_RD_EN_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_00_BUFFER_RD_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_00_BUFFER_RD_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_00_BUFFER_RD_EN_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_00_BUFFER_WR_EN_MASK 0x400
#define  SDMMC3_2P_SD_PRESENT_STATE_00_BUFFER_WR_EN_SHIFT 10
#define  SDMMC3_2P_SD_PRESENT_STATE_00_BUFFER_WR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_00_BUFFER_WR_EN_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_00_BUFFER_WR_EN_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_00_BUFFER_WR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_00_BUFFER_WR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_00_BUFFER_WR_EN_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_00_RX_ACTIVE_MASK 0x200
#define  SDMMC3_2P_SD_PRESENT_STATE_00_RX_ACTIVE_SHIFT 9
#define  SDMMC3_2P_SD_PRESENT_STATE_00_RX_ACTIVE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_00_RX_ACTIVE_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_00_RX_ACTIVE_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_00_RX_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_00_RX_ACTIVE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_00_RX_ACTIVE_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_00_TX_ACTIVE_MASK 0x100
#define  SDMMC3_2P_SD_PRESENT_STATE_00_TX_ACTIVE_SHIFT 8
#define  SDMMC3_2P_SD_PRESENT_STATE_00_TX_ACTIVE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_00_TX_ACTIVE_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_00_TX_ACTIVE_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_00_TX_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_00_TX_ACTIVE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_00_TX_ACTIVE_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_00_RESERVED3_MASK 0xf0
#define  SDMMC3_2P_SD_PRESENT_STATE_00_RESERVED3_SHIFT 4
#define  SDMMC3_2P_SD_PRESENT_STATE_00_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_00_RESERVED3_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_00_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_00_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_00_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_00_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_00_RETUNING_REQ_MASK 0x8
#define  SDMMC3_2P_SD_PRESENT_STATE_00_RETUNING_REQ_SHIFT 3
#define  SDMMC3_2P_SD_PRESENT_STATE_00_RETUNING_REQ_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_00_RETUNING_REQ_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_00_RETUNING_REQ_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_00_RETUNING_REQ_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_00_RETUNING_REQ_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_00_RETUNING_REQ_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_00_DAT_ACTIVE_MASK 0x4
#define  SDMMC3_2P_SD_PRESENT_STATE_00_DAT_ACTIVE_SHIFT 2
#define  SDMMC3_2P_SD_PRESENT_STATE_00_DAT_ACTIVE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_00_DAT_ACTIVE_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_00_DAT_ACTIVE_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_00_DAT_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_00_DAT_ACTIVE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_00_DAT_ACTIVE_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_00_CMD_INHIBIT_DAT_MASK 0x2
#define  SDMMC3_2P_SD_PRESENT_STATE_00_CMD_INHIBIT_DAT_SHIFT 1
#define  SDMMC3_2P_SD_PRESENT_STATE_00_CMD_INHIBIT_DAT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_00_CMD_INHIBIT_DAT_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_00_CMD_INHIBIT_DAT_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_00_CMD_INHIBIT_DAT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_00_CMD_INHIBIT_DAT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_00_CMD_INHIBIT_DAT_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_00_CMD_INHIBIT_CMD_MASK 0x1
#define  SDMMC3_2P_SD_PRESENT_STATE_00_CMD_INHIBIT_CMD_SHIFT 0
#define  SDMMC3_2P_SD_PRESENT_STATE_00_CMD_INHIBIT_CMD_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_00_CMD_INHIBIT_CMD_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_00_CMD_INHIBIT_CMD_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_00_CMD_INHIBIT_CMD_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_00_CMD_INHIBIT_CMD_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_00_CMD_INHIBIT_CMD_SHIFT))

//====================================================================
//Register: Present State Register 0 (Instance 2 of 2) (SD_PRESENT_STATE_01)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_PRESENT_STATE_01_RESERVED2_MASK 0xf000
#define  SDMMC3_2P_SD_PRESENT_STATE_01_RESERVED2_SHIFT 12
#define  SDMMC3_2P_SD_PRESENT_STATE_01_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_01_RESERVED2_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_01_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_01_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_01_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_01_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_01_BUFFER_RD_EN_MASK 0x800
#define  SDMMC3_2P_SD_PRESENT_STATE_01_BUFFER_RD_EN_SHIFT 11
#define  SDMMC3_2P_SD_PRESENT_STATE_01_BUFFER_RD_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_01_BUFFER_RD_EN_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_01_BUFFER_RD_EN_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_01_BUFFER_RD_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_01_BUFFER_RD_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_01_BUFFER_RD_EN_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_01_BUFFER_WR_EN_MASK 0x400
#define  SDMMC3_2P_SD_PRESENT_STATE_01_BUFFER_WR_EN_SHIFT 10
#define  SDMMC3_2P_SD_PRESENT_STATE_01_BUFFER_WR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_01_BUFFER_WR_EN_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_01_BUFFER_WR_EN_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_01_BUFFER_WR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_01_BUFFER_WR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_01_BUFFER_WR_EN_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_01_RX_ACTIVE_MASK 0x200
#define  SDMMC3_2P_SD_PRESENT_STATE_01_RX_ACTIVE_SHIFT 9
#define  SDMMC3_2P_SD_PRESENT_STATE_01_RX_ACTIVE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_01_RX_ACTIVE_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_01_RX_ACTIVE_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_01_RX_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_01_RX_ACTIVE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_01_RX_ACTIVE_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_01_TX_ACTIVE_MASK 0x100
#define  SDMMC3_2P_SD_PRESENT_STATE_01_TX_ACTIVE_SHIFT 8
#define  SDMMC3_2P_SD_PRESENT_STATE_01_TX_ACTIVE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_01_TX_ACTIVE_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_01_TX_ACTIVE_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_01_TX_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_01_TX_ACTIVE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_01_TX_ACTIVE_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_01_RESERVED3_MASK 0xf0
#define  SDMMC3_2P_SD_PRESENT_STATE_01_RESERVED3_SHIFT 4
#define  SDMMC3_2P_SD_PRESENT_STATE_01_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_01_RESERVED3_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_01_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_01_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_01_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_01_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_01_RETUNING_REQ_MASK 0x8
#define  SDMMC3_2P_SD_PRESENT_STATE_01_RETUNING_REQ_SHIFT 3
#define  SDMMC3_2P_SD_PRESENT_STATE_01_RETUNING_REQ_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_01_RETUNING_REQ_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_01_RETUNING_REQ_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_01_RETUNING_REQ_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_01_RETUNING_REQ_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_01_RETUNING_REQ_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_01_DAT_ACTIVE_MASK 0x4
#define  SDMMC3_2P_SD_PRESENT_STATE_01_DAT_ACTIVE_SHIFT 2
#define  SDMMC3_2P_SD_PRESENT_STATE_01_DAT_ACTIVE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_01_DAT_ACTIVE_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_01_DAT_ACTIVE_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_01_DAT_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_01_DAT_ACTIVE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_01_DAT_ACTIVE_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_01_CMD_INHIBIT_DAT_MASK 0x2
#define  SDMMC3_2P_SD_PRESENT_STATE_01_CMD_INHIBIT_DAT_SHIFT 1
#define  SDMMC3_2P_SD_PRESENT_STATE_01_CMD_INHIBIT_DAT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_01_CMD_INHIBIT_DAT_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_01_CMD_INHIBIT_DAT_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_01_CMD_INHIBIT_DAT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_01_CMD_INHIBIT_DAT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_01_CMD_INHIBIT_DAT_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_01_CMD_INHIBIT_CMD_MASK 0x1
#define  SDMMC3_2P_SD_PRESENT_STATE_01_CMD_INHIBIT_CMD_SHIFT 0
#define  SDMMC3_2P_SD_PRESENT_STATE_01_CMD_INHIBIT_CMD_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_01_CMD_INHIBIT_CMD_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_01_CMD_INHIBIT_CMD_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_01_CMD_INHIBIT_CMD_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_01_CMD_INHIBIT_CMD_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_01_CMD_INHIBIT_CMD_SHIFT))

//====================================================================
//Register: Present State Register 1 (Instance 1 of 2) (SD_PRESENT_STATE_10)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_PRESENT_STATE_10_RESERVED2_MASK 0xfe00
#define  SDMMC3_2P_SD_PRESENT_STATE_10_RESERVED2_SHIFT 9
#define  SDMMC3_2P_SD_PRESENT_STATE_10_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_10_RESERVED2_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_10_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_10_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_10_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_10_CMD_LEVEL_MASK 0x100
#define  SDMMC3_2P_SD_PRESENT_STATE_10_CMD_LEVEL_SHIFT 8
#define  SDMMC3_2P_SD_PRESENT_STATE_10_CMD_LEVEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_10_CMD_LEVEL_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_10_CMD_LEVEL_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_10_CMD_LEVEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_10_CMD_LEVEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_10_CMD_LEVEL_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_10_DAT_LEVEL_MASK 0xf0
#define  SDMMC3_2P_SD_PRESENT_STATE_10_DAT_LEVEL_SHIFT 4
#define  SDMMC3_2P_SD_PRESENT_STATE_10_DAT_LEVEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_10_DAT_LEVEL_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_10_DAT_LEVEL_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_10_DAT_LEVEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_10_DAT_LEVEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_10_DAT_LEVEL_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_10_WRITE_PROT_MASK 0x8
#define  SDMMC3_2P_SD_PRESENT_STATE_10_WRITE_PROT_SHIFT 3
#define  SDMMC3_2P_SD_PRESENT_STATE_10_WRITE_PROT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_10_WRITE_PROT_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_10_WRITE_PROT_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_10_WRITE_PROT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_10_WRITE_PROT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_10_WRITE_PROT_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_10_CARD_DET_MASK 0x4
#define  SDMMC3_2P_SD_PRESENT_STATE_10_CARD_DET_SHIFT 2
#define  SDMMC3_2P_SD_PRESENT_STATE_10_CARD_DET_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_10_CARD_DET_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_10_CARD_DET_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_10_CARD_DET_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_10_CARD_DET_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_10_CARD_DET_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_10_CARD_STABLE_MASK 0x2
#define  SDMMC3_2P_SD_PRESENT_STATE_10_CARD_STABLE_SHIFT 1
#define  SDMMC3_2P_SD_PRESENT_STATE_10_CARD_STABLE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_10_CARD_STABLE_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_10_CARD_STABLE_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_10_CARD_STABLE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_10_CARD_STABLE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_10_CARD_STABLE_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_10_CARD_INSERTED_MASK 0x1
#define  SDMMC3_2P_SD_PRESENT_STATE_10_CARD_INSERTED_SHIFT 0
#define  SDMMC3_2P_SD_PRESENT_STATE_10_CARD_INSERTED_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_10_CARD_INSERTED_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_10_CARD_INSERTED_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_10_CARD_INSERTED_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_10_CARD_INSERTED_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_10_CARD_INSERTED_SHIFT))

//====================================================================
//Register: Present State Register 1 (Instance 2 of 2) (SD_PRESENT_STATE_11)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_PRESENT_STATE_11_RESERVED2_MASK 0xfe00
#define  SDMMC3_2P_SD_PRESENT_STATE_11_RESERVED2_SHIFT 9
#define  SDMMC3_2P_SD_PRESENT_STATE_11_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_11_RESERVED2_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_11_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_11_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_11_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_11_CMD_LEVEL_MASK 0x100
#define  SDMMC3_2P_SD_PRESENT_STATE_11_CMD_LEVEL_SHIFT 8
#define  SDMMC3_2P_SD_PRESENT_STATE_11_CMD_LEVEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_11_CMD_LEVEL_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_11_CMD_LEVEL_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_11_CMD_LEVEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_11_CMD_LEVEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_11_CMD_LEVEL_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_11_DAT_LEVEL_MASK 0xf0
#define  SDMMC3_2P_SD_PRESENT_STATE_11_DAT_LEVEL_SHIFT 4
#define  SDMMC3_2P_SD_PRESENT_STATE_11_DAT_LEVEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_11_DAT_LEVEL_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_11_DAT_LEVEL_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_11_DAT_LEVEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_11_DAT_LEVEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_11_DAT_LEVEL_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_11_WRITE_PROT_MASK 0x8
#define  SDMMC3_2P_SD_PRESENT_STATE_11_WRITE_PROT_SHIFT 3
#define  SDMMC3_2P_SD_PRESENT_STATE_11_WRITE_PROT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_11_WRITE_PROT_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_11_WRITE_PROT_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_11_WRITE_PROT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_11_WRITE_PROT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_11_WRITE_PROT_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_11_CARD_DET_MASK 0x4
#define  SDMMC3_2P_SD_PRESENT_STATE_11_CARD_DET_SHIFT 2
#define  SDMMC3_2P_SD_PRESENT_STATE_11_CARD_DET_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_11_CARD_DET_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_11_CARD_DET_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_11_CARD_DET_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_11_CARD_DET_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_11_CARD_DET_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_11_CARD_STABLE_MASK 0x2
#define  SDMMC3_2P_SD_PRESENT_STATE_11_CARD_STABLE_SHIFT 1
#define  SDMMC3_2P_SD_PRESENT_STATE_11_CARD_STABLE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_11_CARD_STABLE_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_11_CARD_STABLE_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_11_CARD_STABLE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_11_CARD_STABLE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_11_CARD_STABLE_SHIFT))

#define  SDMMC3_2P_SD_PRESENT_STATE_11_CARD_INSERTED_MASK 0x1
#define  SDMMC3_2P_SD_PRESENT_STATE_11_CARD_INSERTED_SHIFT 0
#define  SDMMC3_2P_SD_PRESENT_STATE_11_CARD_INSERTED_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESENT_STATE_11_CARD_INSERTED_MASK) >> SDMMC3_2P_SD_PRESENT_STATE_11_CARD_INSERTED_SHIFT)
#define  SDMMC3_2P_SD_PRESENT_STATE_11_CARD_INSERTED_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESENT_STATE_11_CARD_INSERTED_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESENT_STATE_11_CARD_INSERTED_SHIFT))

//====================================================================
//Register: Host Control Register (Instance 1 of 2) (SD_HOST_CTRL0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_HOST_CTRL0_RESERVED2_MASK 0xf000
#define  SDMMC3_2P_SD_HOST_CTRL0_RESERVED2_SHIFT 12
#define  SDMMC3_2P_SD_HOST_CTRL0_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL0_RESERVED2_MASK) >> SDMMC3_2P_SD_HOST_CTRL0_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL0_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL0_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL0_SD_BUS_VLT_MASK 0xe00
#define  SDMMC3_2P_SD_HOST_CTRL0_SD_BUS_VLT_SHIFT 9
#define  SDMMC3_2P_SD_HOST_CTRL0_SD_BUS_VLT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL0_SD_BUS_VLT_MASK) >> SDMMC3_2P_SD_HOST_CTRL0_SD_BUS_VLT_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL0_SD_BUS_VLT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL0_SD_BUS_VLT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL0_SD_BUS_VLT_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL0_SD_BUS_POWER_MASK 0x100
#define  SDMMC3_2P_SD_HOST_CTRL0_SD_BUS_POWER_SHIFT 8
#define  SDMMC3_2P_SD_HOST_CTRL0_SD_BUS_POWER_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL0_SD_BUS_POWER_MASK) >> SDMMC3_2P_SD_HOST_CTRL0_SD_BUS_POWER_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL0_SD_BUS_POWER_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL0_SD_BUS_POWER_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL0_SD_BUS_POWER_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL0_CARD_DET_S_MASK 0x80
#define  SDMMC3_2P_SD_HOST_CTRL0_CARD_DET_S_SHIFT 7
#define  SDMMC3_2P_SD_HOST_CTRL0_CARD_DET_S_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL0_CARD_DET_S_MASK) >> SDMMC3_2P_SD_HOST_CTRL0_CARD_DET_S_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL0_CARD_DET_S_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL0_CARD_DET_S_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL0_CARD_DET_S_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL0_CARD_DET_L_MASK 0x40
#define  SDMMC3_2P_SD_HOST_CTRL0_CARD_DET_L_SHIFT 6
#define  SDMMC3_2P_SD_HOST_CTRL0_CARD_DET_L_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL0_CARD_DET_L_MASK) >> SDMMC3_2P_SD_HOST_CTRL0_CARD_DET_L_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL0_CARD_DET_L_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL0_CARD_DET_L_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL0_CARD_DET_L_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL0_EX_DATA_WIDTH_MASK 0x20
#define  SDMMC3_2P_SD_HOST_CTRL0_EX_DATA_WIDTH_SHIFT 5
#define  SDMMC3_2P_SD_HOST_CTRL0_EX_DATA_WIDTH_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL0_EX_DATA_WIDTH_MASK) >> SDMMC3_2P_SD_HOST_CTRL0_EX_DATA_WIDTH_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL0_EX_DATA_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL0_EX_DATA_WIDTH_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL0_EX_DATA_WIDTH_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL0_DMA_SEL_MASK 0x18
#define  SDMMC3_2P_SD_HOST_CTRL0_DMA_SEL_SHIFT 3
#define  SDMMC3_2P_SD_HOST_CTRL0_DMA_SEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL0_DMA_SEL_MASK) >> SDMMC3_2P_SD_HOST_CTRL0_DMA_SEL_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL0_DMA_SEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL0_DMA_SEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL0_DMA_SEL_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL0_HI_SPEED_EN_MASK 0x4
#define  SDMMC3_2P_SD_HOST_CTRL0_HI_SPEED_EN_SHIFT 2
#define  SDMMC3_2P_SD_HOST_CTRL0_HI_SPEED_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL0_HI_SPEED_EN_MASK) >> SDMMC3_2P_SD_HOST_CTRL0_HI_SPEED_EN_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL0_HI_SPEED_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL0_HI_SPEED_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL0_HI_SPEED_EN_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL0_DATA_WIDTH_MASK 0x2
#define  SDMMC3_2P_SD_HOST_CTRL0_DATA_WIDTH_SHIFT 1
#define  SDMMC3_2P_SD_HOST_CTRL0_DATA_WIDTH_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL0_DATA_WIDTH_MASK) >> SDMMC3_2P_SD_HOST_CTRL0_DATA_WIDTH_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL0_DATA_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL0_DATA_WIDTH_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL0_DATA_WIDTH_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL0_LED_CTRL_MASK 0x1
#define  SDMMC3_2P_SD_HOST_CTRL0_LED_CTRL_SHIFT 0
#define  SDMMC3_2P_SD_HOST_CTRL0_LED_CTRL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL0_LED_CTRL_MASK) >> SDMMC3_2P_SD_HOST_CTRL0_LED_CTRL_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL0_LED_CTRL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL0_LED_CTRL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL0_LED_CTRL_SHIFT))

//====================================================================
//Register: Host Control Register (Instance 2 of 2) (SD_HOST_CTRL1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_HOST_CTRL1_RESERVED2_MASK 0xf000
#define  SDMMC3_2P_SD_HOST_CTRL1_RESERVED2_SHIFT 12
#define  SDMMC3_2P_SD_HOST_CTRL1_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL1_RESERVED2_MASK) >> SDMMC3_2P_SD_HOST_CTRL1_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL1_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL1_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL1_SD_BUS_VLT_MASK 0xe00
#define  SDMMC3_2P_SD_HOST_CTRL1_SD_BUS_VLT_SHIFT 9
#define  SDMMC3_2P_SD_HOST_CTRL1_SD_BUS_VLT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL1_SD_BUS_VLT_MASK) >> SDMMC3_2P_SD_HOST_CTRL1_SD_BUS_VLT_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL1_SD_BUS_VLT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL1_SD_BUS_VLT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL1_SD_BUS_VLT_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL1_SD_BUS_POWER_MASK 0x100
#define  SDMMC3_2P_SD_HOST_CTRL1_SD_BUS_POWER_SHIFT 8
#define  SDMMC3_2P_SD_HOST_CTRL1_SD_BUS_POWER_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL1_SD_BUS_POWER_MASK) >> SDMMC3_2P_SD_HOST_CTRL1_SD_BUS_POWER_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL1_SD_BUS_POWER_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL1_SD_BUS_POWER_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL1_SD_BUS_POWER_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL1_CARD_DET_S_MASK 0x80
#define  SDMMC3_2P_SD_HOST_CTRL1_CARD_DET_S_SHIFT 7
#define  SDMMC3_2P_SD_HOST_CTRL1_CARD_DET_S_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL1_CARD_DET_S_MASK) >> SDMMC3_2P_SD_HOST_CTRL1_CARD_DET_S_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL1_CARD_DET_S_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL1_CARD_DET_S_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL1_CARD_DET_S_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL1_CARD_DET_L_MASK 0x40
#define  SDMMC3_2P_SD_HOST_CTRL1_CARD_DET_L_SHIFT 6
#define  SDMMC3_2P_SD_HOST_CTRL1_CARD_DET_L_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL1_CARD_DET_L_MASK) >> SDMMC3_2P_SD_HOST_CTRL1_CARD_DET_L_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL1_CARD_DET_L_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL1_CARD_DET_L_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL1_CARD_DET_L_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL1_EX_DATA_WIDTH_MASK 0x20
#define  SDMMC3_2P_SD_HOST_CTRL1_EX_DATA_WIDTH_SHIFT 5
#define  SDMMC3_2P_SD_HOST_CTRL1_EX_DATA_WIDTH_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL1_EX_DATA_WIDTH_MASK) >> SDMMC3_2P_SD_HOST_CTRL1_EX_DATA_WIDTH_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL1_EX_DATA_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL1_EX_DATA_WIDTH_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL1_EX_DATA_WIDTH_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL1_DMA_SEL_MASK 0x18
#define  SDMMC3_2P_SD_HOST_CTRL1_DMA_SEL_SHIFT 3
#define  SDMMC3_2P_SD_HOST_CTRL1_DMA_SEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL1_DMA_SEL_MASK) >> SDMMC3_2P_SD_HOST_CTRL1_DMA_SEL_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL1_DMA_SEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL1_DMA_SEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL1_DMA_SEL_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL1_HI_SPEED_EN_MASK 0x4
#define  SDMMC3_2P_SD_HOST_CTRL1_HI_SPEED_EN_SHIFT 2
#define  SDMMC3_2P_SD_HOST_CTRL1_HI_SPEED_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL1_HI_SPEED_EN_MASK) >> SDMMC3_2P_SD_HOST_CTRL1_HI_SPEED_EN_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL1_HI_SPEED_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL1_HI_SPEED_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL1_HI_SPEED_EN_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL1_DATA_WIDTH_MASK 0x2
#define  SDMMC3_2P_SD_HOST_CTRL1_DATA_WIDTH_SHIFT 1
#define  SDMMC3_2P_SD_HOST_CTRL1_DATA_WIDTH_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL1_DATA_WIDTH_MASK) >> SDMMC3_2P_SD_HOST_CTRL1_DATA_WIDTH_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL1_DATA_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL1_DATA_WIDTH_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL1_DATA_WIDTH_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL1_LED_CTRL_MASK 0x1
#define  SDMMC3_2P_SD_HOST_CTRL1_LED_CTRL_SHIFT 0
#define  SDMMC3_2P_SD_HOST_CTRL1_LED_CTRL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL1_LED_CTRL_MASK) >> SDMMC3_2P_SD_HOST_CTRL1_LED_CTRL_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL1_LED_CTRL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL1_LED_CTRL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL1_LED_CTRL_SHIFT))

//====================================================================
//Register: Block Gap Control Register (Instance 1 of 2) (SD_BLOCK_GAP_CTRL0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_RESERVED2_MASK 0xf800
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_GAP_CTRL0_RESERVED2_MASK) >> SDMMC3_2P_SD_BLOCK_GAP_CTRL0_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_GAP_CTRL0_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_GAP_CTRL0_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_W_REMOVAL_MASK 0x400
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_W_REMOVAL_SHIFT 10
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_W_REMOVAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_GAP_CTRL0_W_REMOVAL_MASK) >> SDMMC3_2P_SD_BLOCK_GAP_CTRL0_W_REMOVAL_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_W_REMOVAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_GAP_CTRL0_W_REMOVAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_GAP_CTRL0_W_REMOVAL_SHIFT))

#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_W_INSERTION_MASK 0x200
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_W_INSERTION_SHIFT 9
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_W_INSERTION_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_GAP_CTRL0_W_INSERTION_MASK) >> SDMMC3_2P_SD_BLOCK_GAP_CTRL0_W_INSERTION_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_W_INSERTION_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_GAP_CTRL0_W_INSERTION_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_GAP_CTRL0_W_INSERTION_SHIFT))

#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_W_CARD_INT_MASK 0x100
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_W_CARD_INT_SHIFT 8
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_W_CARD_INT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_GAP_CTRL0_W_CARD_INT_MASK) >> SDMMC3_2P_SD_BLOCK_GAP_CTRL0_W_CARD_INT_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_W_CARD_INT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_GAP_CTRL0_W_CARD_INT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_GAP_CTRL0_W_CARD_INT_SHIFT))

#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_RESERVED3_MASK 0xf0
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_RESERVED3_SHIFT 4
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_GAP_CTRL0_RESERVED3_MASK) >> SDMMC3_2P_SD_BLOCK_GAP_CTRL0_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_GAP_CTRL0_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_GAP_CTRL0_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_INT_BLK_GAP_MASK 0x8
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_INT_BLK_GAP_SHIFT 3
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_INT_BLK_GAP_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_GAP_CTRL0_INT_BLK_GAP_MASK) >> SDMMC3_2P_SD_BLOCK_GAP_CTRL0_INT_BLK_GAP_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_INT_BLK_GAP_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_GAP_CTRL0_INT_BLK_GAP_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_GAP_CTRL0_INT_BLK_GAP_SHIFT))

#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_RD_WAIT_CTL_MASK 0x4
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_RD_WAIT_CTL_SHIFT 2
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_RD_WAIT_CTL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_GAP_CTRL0_RD_WAIT_CTL_MASK) >> SDMMC3_2P_SD_BLOCK_GAP_CTRL0_RD_WAIT_CTL_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_RD_WAIT_CTL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_GAP_CTRL0_RD_WAIT_CTL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_GAP_CTRL0_RD_WAIT_CTL_SHIFT))

#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_CONT_REQ_MASK 0x2
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_CONT_REQ_SHIFT 1
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_CONT_REQ_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_GAP_CTRL0_CONT_REQ_MASK) >> SDMMC3_2P_SD_BLOCK_GAP_CTRL0_CONT_REQ_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_CONT_REQ_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_GAP_CTRL0_CONT_REQ_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_GAP_CTRL0_CONT_REQ_SHIFT))

#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_STOP_AT_BLOCK_GAP_REQ_MASK 0x1
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_STOP_AT_BLOCK_GAP_REQ_SHIFT 0
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_STOP_AT_BLOCK_GAP_REQ_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_GAP_CTRL0_STOP_AT_BLOCK_GAP_REQ_MASK) >> SDMMC3_2P_SD_BLOCK_GAP_CTRL0_STOP_AT_BLOCK_GAP_REQ_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL0_STOP_AT_BLOCK_GAP_REQ_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_GAP_CTRL0_STOP_AT_BLOCK_GAP_REQ_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_GAP_CTRL0_STOP_AT_BLOCK_GAP_REQ_SHIFT))

//====================================================================
//Register: Block Gap Control Register (Instance 2 of 2) (SD_BLOCK_GAP_CTRL1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_RESERVED2_MASK 0xf800
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_GAP_CTRL1_RESERVED2_MASK) >> SDMMC3_2P_SD_BLOCK_GAP_CTRL1_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_GAP_CTRL1_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_GAP_CTRL1_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_W_REMOVAL_MASK 0x400
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_W_REMOVAL_SHIFT 10
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_W_REMOVAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_GAP_CTRL1_W_REMOVAL_MASK) >> SDMMC3_2P_SD_BLOCK_GAP_CTRL1_W_REMOVAL_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_W_REMOVAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_GAP_CTRL1_W_REMOVAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_GAP_CTRL1_W_REMOVAL_SHIFT))

#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_W_INSERTION_MASK 0x200
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_W_INSERTION_SHIFT 9
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_W_INSERTION_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_GAP_CTRL1_W_INSERTION_MASK) >> SDMMC3_2P_SD_BLOCK_GAP_CTRL1_W_INSERTION_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_W_INSERTION_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_GAP_CTRL1_W_INSERTION_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_GAP_CTRL1_W_INSERTION_SHIFT))

#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_W_CARD_INT_MASK 0x100
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_W_CARD_INT_SHIFT 8
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_W_CARD_INT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_GAP_CTRL1_W_CARD_INT_MASK) >> SDMMC3_2P_SD_BLOCK_GAP_CTRL1_W_CARD_INT_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_W_CARD_INT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_GAP_CTRL1_W_CARD_INT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_GAP_CTRL1_W_CARD_INT_SHIFT))

#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_RESERVED3_MASK 0xf0
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_RESERVED3_SHIFT 4
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_GAP_CTRL1_RESERVED3_MASK) >> SDMMC3_2P_SD_BLOCK_GAP_CTRL1_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_GAP_CTRL1_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_GAP_CTRL1_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_INT_BLK_GAP_MASK 0x8
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_INT_BLK_GAP_SHIFT 3
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_INT_BLK_GAP_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_GAP_CTRL1_INT_BLK_GAP_MASK) >> SDMMC3_2P_SD_BLOCK_GAP_CTRL1_INT_BLK_GAP_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_INT_BLK_GAP_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_GAP_CTRL1_INT_BLK_GAP_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_GAP_CTRL1_INT_BLK_GAP_SHIFT))

#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_RD_WAIT_CTL_MASK 0x4
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_RD_WAIT_CTL_SHIFT 2
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_RD_WAIT_CTL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_GAP_CTRL1_RD_WAIT_CTL_MASK) >> SDMMC3_2P_SD_BLOCK_GAP_CTRL1_RD_WAIT_CTL_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_RD_WAIT_CTL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_GAP_CTRL1_RD_WAIT_CTL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_GAP_CTRL1_RD_WAIT_CTL_SHIFT))

#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_CONT_REQ_MASK 0x2
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_CONT_REQ_SHIFT 1
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_CONT_REQ_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_GAP_CTRL1_CONT_REQ_MASK) >> SDMMC3_2P_SD_BLOCK_GAP_CTRL1_CONT_REQ_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_CONT_REQ_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_GAP_CTRL1_CONT_REQ_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_GAP_CTRL1_CONT_REQ_SHIFT))

#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_STOP_AT_BLOCK_GAP_REQ_MASK 0x1
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_STOP_AT_BLOCK_GAP_REQ_SHIFT 0
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_STOP_AT_BLOCK_GAP_REQ_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_BLOCK_GAP_CTRL1_STOP_AT_BLOCK_GAP_REQ_MASK) >> SDMMC3_2P_SD_BLOCK_GAP_CTRL1_STOP_AT_BLOCK_GAP_REQ_SHIFT)
#define  SDMMC3_2P_SD_BLOCK_GAP_CTRL1_STOP_AT_BLOCK_GAP_REQ_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_BLOCK_GAP_CTRL1_STOP_AT_BLOCK_GAP_REQ_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_BLOCK_GAP_CTRL1_STOP_AT_BLOCK_GAP_REQ_SHIFT))

//====================================================================
//Register: Clock Control Register (Instance 1 of 2) (SD_CLOCK_CTRL0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_CLOCK_CTRL0_SD_FREQ_SEL0_MASK 0xff00
#define  SDMMC3_2P_SD_CLOCK_CTRL0_SD_FREQ_SEL0_SHIFT 8
#define  SDMMC3_2P_SD_CLOCK_CTRL0_SD_FREQ_SEL0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_CTRL0_SD_FREQ_SEL0_MASK) >> SDMMC3_2P_SD_CLOCK_CTRL0_SD_FREQ_SEL0_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_CTRL0_SD_FREQ_SEL0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_CTRL0_SD_FREQ_SEL0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_CTRL0_SD_FREQ_SEL0_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_CTRL0_SD_FREQ_SEL1_MASK 0xc0
#define  SDMMC3_2P_SD_CLOCK_CTRL0_SD_FREQ_SEL1_SHIFT 6
#define  SDMMC3_2P_SD_CLOCK_CTRL0_SD_FREQ_SEL1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_CTRL0_SD_FREQ_SEL1_MASK) >> SDMMC3_2P_SD_CLOCK_CTRL0_SD_FREQ_SEL1_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_CTRL0_SD_FREQ_SEL1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_CTRL0_SD_FREQ_SEL1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_CTRL0_SD_FREQ_SEL1_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_CTRL0_CLK_GEN_SEL_MASK 0x20
#define  SDMMC3_2P_SD_CLOCK_CTRL0_CLK_GEN_SEL_SHIFT 5
#define  SDMMC3_2P_SD_CLOCK_CTRL0_CLK_GEN_SEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_CTRL0_CLK_GEN_SEL_MASK) >> SDMMC3_2P_SD_CLOCK_CTRL0_CLK_GEN_SEL_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_CTRL0_CLK_GEN_SEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_CTRL0_CLK_GEN_SEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_CTRL0_CLK_GEN_SEL_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_CTRL0_RESERVED2_MASK 0x18
#define  SDMMC3_2P_SD_CLOCK_CTRL0_RESERVED2_SHIFT 3
#define  SDMMC3_2P_SD_CLOCK_CTRL0_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_CTRL0_RESERVED2_MASK) >> SDMMC3_2P_SD_CLOCK_CTRL0_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_CTRL0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_CTRL0_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_CTRL0_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_CTRL0_SD_CLK_EN_MASK 0x4
#define  SDMMC3_2P_SD_CLOCK_CTRL0_SD_CLK_EN_SHIFT 2
#define  SDMMC3_2P_SD_CLOCK_CTRL0_SD_CLK_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_CTRL0_SD_CLK_EN_MASK) >> SDMMC3_2P_SD_CLOCK_CTRL0_SD_CLK_EN_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_CTRL0_SD_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_CTRL0_SD_CLK_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_CTRL0_SD_CLK_EN_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_CTRL0_INT_CLK_STABLE_MASK 0x2
#define  SDMMC3_2P_SD_CLOCK_CTRL0_INT_CLK_STABLE_SHIFT 1
#define  SDMMC3_2P_SD_CLOCK_CTRL0_INT_CLK_STABLE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_CTRL0_INT_CLK_STABLE_MASK) >> SDMMC3_2P_SD_CLOCK_CTRL0_INT_CLK_STABLE_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_CTRL0_INT_CLK_STABLE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_CTRL0_INT_CLK_STABLE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_CTRL0_INT_CLK_STABLE_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_CTRL0_INT_CLK_EN_MASK 0x1
#define  SDMMC3_2P_SD_CLOCK_CTRL0_INT_CLK_EN_SHIFT 0
#define  SDMMC3_2P_SD_CLOCK_CTRL0_INT_CLK_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_CTRL0_INT_CLK_EN_MASK) >> SDMMC3_2P_SD_CLOCK_CTRL0_INT_CLK_EN_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_CTRL0_INT_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_CTRL0_INT_CLK_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_CTRL0_INT_CLK_EN_SHIFT))

//====================================================================
//Register: Clock Control Register (Instance 2 of 2) (SD_CLOCK_CTRL1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_CLOCK_CTRL1_SD_FREQ_SEL0_MASK 0xff00
#define  SDMMC3_2P_SD_CLOCK_CTRL1_SD_FREQ_SEL0_SHIFT 8
#define  SDMMC3_2P_SD_CLOCK_CTRL1_SD_FREQ_SEL0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_CTRL1_SD_FREQ_SEL0_MASK) >> SDMMC3_2P_SD_CLOCK_CTRL1_SD_FREQ_SEL0_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_CTRL1_SD_FREQ_SEL0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_CTRL1_SD_FREQ_SEL0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_CTRL1_SD_FREQ_SEL0_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_CTRL1_SD_FREQ_SEL1_MASK 0xc0
#define  SDMMC3_2P_SD_CLOCK_CTRL1_SD_FREQ_SEL1_SHIFT 6
#define  SDMMC3_2P_SD_CLOCK_CTRL1_SD_FREQ_SEL1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_CTRL1_SD_FREQ_SEL1_MASK) >> SDMMC3_2P_SD_CLOCK_CTRL1_SD_FREQ_SEL1_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_CTRL1_SD_FREQ_SEL1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_CTRL1_SD_FREQ_SEL1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_CTRL1_SD_FREQ_SEL1_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_CTRL1_CLK_GEN_SEL_MASK 0x20
#define  SDMMC3_2P_SD_CLOCK_CTRL1_CLK_GEN_SEL_SHIFT 5
#define  SDMMC3_2P_SD_CLOCK_CTRL1_CLK_GEN_SEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_CTRL1_CLK_GEN_SEL_MASK) >> SDMMC3_2P_SD_CLOCK_CTRL1_CLK_GEN_SEL_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_CTRL1_CLK_GEN_SEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_CTRL1_CLK_GEN_SEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_CTRL1_CLK_GEN_SEL_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_CTRL1_RESERVED2_MASK 0x18
#define  SDMMC3_2P_SD_CLOCK_CTRL1_RESERVED2_SHIFT 3
#define  SDMMC3_2P_SD_CLOCK_CTRL1_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_CTRL1_RESERVED2_MASK) >> SDMMC3_2P_SD_CLOCK_CTRL1_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_CTRL1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_CTRL1_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_CTRL1_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_CTRL1_SD_CLK_EN_MASK 0x4
#define  SDMMC3_2P_SD_CLOCK_CTRL1_SD_CLK_EN_SHIFT 2
#define  SDMMC3_2P_SD_CLOCK_CTRL1_SD_CLK_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_CTRL1_SD_CLK_EN_MASK) >> SDMMC3_2P_SD_CLOCK_CTRL1_SD_CLK_EN_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_CTRL1_SD_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_CTRL1_SD_CLK_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_CTRL1_SD_CLK_EN_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_CTRL1_INT_CLK_STABLE_MASK 0x2
#define  SDMMC3_2P_SD_CLOCK_CTRL1_INT_CLK_STABLE_SHIFT 1
#define  SDMMC3_2P_SD_CLOCK_CTRL1_INT_CLK_STABLE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_CTRL1_INT_CLK_STABLE_MASK) >> SDMMC3_2P_SD_CLOCK_CTRL1_INT_CLK_STABLE_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_CTRL1_INT_CLK_STABLE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_CTRL1_INT_CLK_STABLE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_CTRL1_INT_CLK_STABLE_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_CTRL1_INT_CLK_EN_MASK 0x1
#define  SDMMC3_2P_SD_CLOCK_CTRL1_INT_CLK_EN_SHIFT 0
#define  SDMMC3_2P_SD_CLOCK_CTRL1_INT_CLK_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_CTRL1_INT_CLK_EN_MASK) >> SDMMC3_2P_SD_CLOCK_CTRL1_INT_CLK_EN_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_CTRL1_INT_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_CTRL1_INT_CLK_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_CTRL1_INT_CLK_EN_SHIFT))

//====================================================================
//Register: Timeout Control/Software Reset Register (Instance 1 of 2) (SD_TIMEOUT_CTRL_SW_RESET0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_RESERVED2_MASK 0xf800
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_RESERVED2_MASK) >> SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_SW_RST_DAT_MASK 0x400
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_SW_RST_DAT_SHIFT 10
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_SW_RST_DAT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_SW_RST_DAT_MASK) >> SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_SW_RST_DAT_SHIFT)
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_SW_RST_DAT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_SW_RST_DAT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_SW_RST_DAT_SHIFT))

#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_SW_RST_CMD_MASK 0x200
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_SW_RST_CMD_SHIFT 9
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_SW_RST_CMD_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_SW_RST_CMD_MASK) >> SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_SW_RST_CMD_SHIFT)
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_SW_RST_CMD_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_SW_RST_CMD_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_SW_RST_CMD_SHIFT))

#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_SW_RST_ALL_MASK 0x100
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_SW_RST_ALL_SHIFT 8
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_SW_RST_ALL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_SW_RST_ALL_MASK) >> SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_SW_RST_ALL_SHIFT)
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_SW_RST_ALL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_SW_RST_ALL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_SW_RST_ALL_SHIFT))

#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_RESERVED3_MASK 0xf0
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_RESERVED3_SHIFT 4
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_RESERVED3_MASK) >> SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_TIMEOUT_VALUE_MASK 0xf
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_TIMEOUT_VALUE_SHIFT 0
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_TIMEOUT_VALUE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_TIMEOUT_VALUE_MASK) >> SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_TIMEOUT_VALUE_SHIFT)
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_TIMEOUT_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_TIMEOUT_VALUE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET0_TIMEOUT_VALUE_SHIFT))

//====================================================================
//Register: Timeout Control/Software Reset Register (Instance 2 of 2) (SD_TIMEOUT_CTRL_SW_RESET1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_RESERVED2_MASK 0xf800
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_RESERVED2_MASK) >> SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_SW_RST_DAT_MASK 0x400
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_SW_RST_DAT_SHIFT 10
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_SW_RST_DAT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_SW_RST_DAT_MASK) >> SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_SW_RST_DAT_SHIFT)
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_SW_RST_DAT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_SW_RST_DAT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_SW_RST_DAT_SHIFT))

#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_SW_RST_CMD_MASK 0x200
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_SW_RST_CMD_SHIFT 9
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_SW_RST_CMD_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_SW_RST_CMD_MASK) >> SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_SW_RST_CMD_SHIFT)
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_SW_RST_CMD_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_SW_RST_CMD_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_SW_RST_CMD_SHIFT))

#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_SW_RST_ALL_MASK 0x100
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_SW_RST_ALL_SHIFT 8
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_SW_RST_ALL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_SW_RST_ALL_MASK) >> SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_SW_RST_ALL_SHIFT)
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_SW_RST_ALL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_SW_RST_ALL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_SW_RST_ALL_SHIFT))

#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_RESERVED3_MASK 0xf0
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_RESERVED3_SHIFT 4
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_RESERVED3_MASK) >> SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_TIMEOUT_VALUE_MASK 0xf
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_TIMEOUT_VALUE_SHIFT 0
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_TIMEOUT_VALUE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_TIMEOUT_VALUE_MASK) >> SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_TIMEOUT_VALUE_SHIFT)
#define  SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_TIMEOUT_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_TIMEOUT_VALUE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TIMEOUT_CTRL_SW_RESET1_TIMEOUT_VALUE_SHIFT))

//====================================================================
//Register: Normal Interrupt Status Register (Instance 1 of 2) (SD_NORMAL_INT_STATUS0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_ERR_INT_MASK 0x8000
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_ERR_INT_SHIFT 15
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_ERR_INT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS0_ERR_INT_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS0_ERR_INT_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_ERR_INT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS0_ERR_INT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS0_ERR_INT_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_RESERVED2_MASK 0x6000
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_RESERVED2_SHIFT 13
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS0_RESERVED2_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS0_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS0_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS0_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_RETUNING_INT_MASK 0x1000
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_RETUNING_INT_SHIFT 12
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_RETUNING_INT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS0_RETUNING_INT_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS0_RETUNING_INT_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_RETUNING_INT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS0_RETUNING_INT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS0_RETUNING_INT_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_INT_C_MASK 0x800
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_INT_C_SHIFT 11
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_INT_C_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS0_INT_C_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS0_INT_C_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_INT_C_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS0_INT_C_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS0_INT_C_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_INT_B_MASK 0x400
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_INT_B_SHIFT 10
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_INT_B_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS0_INT_B_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS0_INT_B_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_INT_B_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS0_INT_B_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS0_INT_B_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_INT_A_MASK 0x200
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_INT_A_SHIFT 9
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_INT_A_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS0_INT_A_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS0_INT_A_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_INT_A_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS0_INT_A_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS0_INT_A_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_CARD_INT_MASK 0x100
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_CARD_INT_SHIFT 8
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_CARD_INT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS0_CARD_INT_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS0_CARD_INT_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_CARD_INT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS0_CARD_INT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS0_CARD_INT_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_CARD_REM_INT_MASK 0x80
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_CARD_REM_INT_SHIFT 7
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_CARD_REM_INT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS0_CARD_REM_INT_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS0_CARD_REM_INT_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_CARD_REM_INT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS0_CARD_REM_INT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS0_CARD_REM_INT_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_CARD_INS_INT_MASK 0x40
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_CARD_INS_INT_SHIFT 6
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_CARD_INS_INT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS0_CARD_INS_INT_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS0_CARD_INS_INT_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_CARD_INS_INT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS0_CARD_INS_INT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS0_CARD_INS_INT_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_RX_RDY_MASK 0x20
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_RX_RDY_SHIFT 5
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_RX_RDY_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS0_RX_RDY_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS0_RX_RDY_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_RX_RDY_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS0_RX_RDY_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS0_RX_RDY_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_TX_RDY_MASK 0x10
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_TX_RDY_SHIFT 4
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_TX_RDY_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS0_TX_RDY_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS0_TX_RDY_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_TX_RDY_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS0_TX_RDY_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS0_TX_RDY_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_DMA_INT_MASK 0x8
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_DMA_INT_SHIFT 3
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_DMA_INT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS0_DMA_INT_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS0_DMA_INT_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_DMA_INT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS0_DMA_INT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS0_DMA_INT_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_BLOCK_GAP_EVT_MASK 0x4
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_BLOCK_GAP_EVT_SHIFT 2
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_BLOCK_GAP_EVT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS0_BLOCK_GAP_EVT_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS0_BLOCK_GAP_EVT_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_BLOCK_GAP_EVT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS0_BLOCK_GAP_EVT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS0_BLOCK_GAP_EVT_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_XFER_COMPLETE_MASK 0x2
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_XFER_COMPLETE_SHIFT 1
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_XFER_COMPLETE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS0_XFER_COMPLETE_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS0_XFER_COMPLETE_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_XFER_COMPLETE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS0_XFER_COMPLETE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS0_XFER_COMPLETE_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_CMD_COMPLETE_MASK 0x1
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_CMD_COMPLETE_SHIFT 0
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_CMD_COMPLETE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS0_CMD_COMPLETE_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS0_CMD_COMPLETE_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS0_CMD_COMPLETE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS0_CMD_COMPLETE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS0_CMD_COMPLETE_SHIFT))

//====================================================================
//Register: Normal Interrupt Status Register (Instance 2 of 2) (SD_NORMAL_INT_STATUS1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_ERR_INT_MASK 0x8000
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_ERR_INT_SHIFT 15
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_ERR_INT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS1_ERR_INT_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS1_ERR_INT_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_ERR_INT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS1_ERR_INT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS1_ERR_INT_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_RESERVED2_MASK 0x6000
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_RESERVED2_SHIFT 13
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS1_RESERVED2_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS1_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS1_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS1_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_RETUNING_INT_MASK 0x1000
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_RETUNING_INT_SHIFT 12
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_RETUNING_INT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS1_RETUNING_INT_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS1_RETUNING_INT_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_RETUNING_INT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS1_RETUNING_INT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS1_RETUNING_INT_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_INT_C_MASK 0x800
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_INT_C_SHIFT 11
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_INT_C_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS1_INT_C_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS1_INT_C_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_INT_C_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS1_INT_C_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS1_INT_C_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_INT_B_MASK 0x400
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_INT_B_SHIFT 10
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_INT_B_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS1_INT_B_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS1_INT_B_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_INT_B_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS1_INT_B_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS1_INT_B_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_INT_A_MASK 0x200
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_INT_A_SHIFT 9
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_INT_A_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS1_INT_A_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS1_INT_A_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_INT_A_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS1_INT_A_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS1_INT_A_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_CARD_INT_MASK 0x100
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_CARD_INT_SHIFT 8
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_CARD_INT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS1_CARD_INT_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS1_CARD_INT_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_CARD_INT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS1_CARD_INT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS1_CARD_INT_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_CARD_REM_INT_MASK 0x80
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_CARD_REM_INT_SHIFT 7
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_CARD_REM_INT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS1_CARD_REM_INT_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS1_CARD_REM_INT_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_CARD_REM_INT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS1_CARD_REM_INT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS1_CARD_REM_INT_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_CARD_INS_INT_MASK 0x40
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_CARD_INS_INT_SHIFT 6
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_CARD_INS_INT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS1_CARD_INS_INT_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS1_CARD_INS_INT_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_CARD_INS_INT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS1_CARD_INS_INT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS1_CARD_INS_INT_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_RX_RDY_MASK 0x20
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_RX_RDY_SHIFT 5
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_RX_RDY_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS1_RX_RDY_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS1_RX_RDY_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_RX_RDY_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS1_RX_RDY_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS1_RX_RDY_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_TX_RDY_MASK 0x10
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_TX_RDY_SHIFT 4
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_TX_RDY_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS1_TX_RDY_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS1_TX_RDY_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_TX_RDY_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS1_TX_RDY_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS1_TX_RDY_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_DMA_INT_MASK 0x8
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_DMA_INT_SHIFT 3
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_DMA_INT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS1_DMA_INT_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS1_DMA_INT_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_DMA_INT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS1_DMA_INT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS1_DMA_INT_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_BLOCK_GAP_EVT_MASK 0x4
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_BLOCK_GAP_EVT_SHIFT 2
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_BLOCK_GAP_EVT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS1_BLOCK_GAP_EVT_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS1_BLOCK_GAP_EVT_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_BLOCK_GAP_EVT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS1_BLOCK_GAP_EVT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS1_BLOCK_GAP_EVT_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_XFER_COMPLETE_MASK 0x2
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_XFER_COMPLETE_SHIFT 1
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_XFER_COMPLETE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS1_XFER_COMPLETE_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS1_XFER_COMPLETE_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_XFER_COMPLETE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS1_XFER_COMPLETE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS1_XFER_COMPLETE_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_CMD_COMPLETE_MASK 0x1
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_CMD_COMPLETE_SHIFT 0
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_CMD_COMPLETE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS1_CMD_COMPLETE_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS1_CMD_COMPLETE_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS1_CMD_COMPLETE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS1_CMD_COMPLETE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS1_CMD_COMPLETE_SHIFT))

//====================================================================
//Register: Error Interrupt Status Register (Instance 1 of 2) (SD_ERROR_INT_STATUS0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CRC_STATUS_ERR_MASK 0x8000
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CRC_STATUS_ERR_SHIFT 15
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CRC_STATUS_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS0_CRC_STATUS_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS0_CRC_STATUS_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CRC_STATUS_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS0_CRC_STATUS_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS0_CRC_STATUS_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CPL_TIMEOUT_ERR_MASK 0x4000
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CPL_TIMEOUT_ERR_SHIFT 14
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CPL_TIMEOUT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS0_CPL_TIMEOUT_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS0_CPL_TIMEOUT_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CPL_TIMEOUT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS0_CPL_TIMEOUT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS0_CPL_TIMEOUT_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_AXI_RESP_ERR_MASK 0x2000
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_AXI_RESP_ERR_SHIFT 13
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_AXI_RESP_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS0_AXI_RESP_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS0_AXI_RESP_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_AXI_RESP_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS0_AXI_RESP_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS0_AXI_RESP_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_SPI_ERR_MASK 0x1000
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_SPI_ERR_SHIFT 12
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_SPI_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS0_SPI_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS0_SPI_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_SPI_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS0_SPI_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS0_SPI_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_RESERVED2_MASK 0x800
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS0_RESERVED2_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS0_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS0_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS0_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_TUNE_ERR_MASK 0x400
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_TUNE_ERR_SHIFT 10
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_TUNE_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS0_TUNE_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS0_TUNE_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_TUNE_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS0_TUNE_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS0_TUNE_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_ADMA_ERR_MASK 0x200
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_ADMA_ERR_SHIFT 9
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_ADMA_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS0_ADMA_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS0_ADMA_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_ADMA_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS0_ADMA_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS0_ADMA_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_AUTO_CMD12_ERR_MASK 0x100
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_AUTO_CMD12_ERR_SHIFT 8
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_AUTO_CMD12_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS0_AUTO_CMD12_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS0_AUTO_CMD12_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_AUTO_CMD12_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS0_AUTO_CMD12_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS0_AUTO_CMD12_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CUR_LIMIT_ERR_MASK 0x80
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CUR_LIMIT_ERR_SHIFT 7
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CUR_LIMIT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS0_CUR_LIMIT_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS0_CUR_LIMIT_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CUR_LIMIT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS0_CUR_LIMIT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS0_CUR_LIMIT_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_RD_DATA_END_BIT_ERR_MASK 0x40
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_RD_DATA_END_BIT_ERR_SHIFT 6
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_RD_DATA_END_BIT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS0_RD_DATA_END_BIT_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS0_RD_DATA_END_BIT_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_RD_DATA_END_BIT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS0_RD_DATA_END_BIT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS0_RD_DATA_END_BIT_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_RD_DATA_CRC_ERR_MASK 0x20
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_RD_DATA_CRC_ERR_SHIFT 5
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_RD_DATA_CRC_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS0_RD_DATA_CRC_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS0_RD_DATA_CRC_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_RD_DATA_CRC_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS0_RD_DATA_CRC_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS0_RD_DATA_CRC_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_DATA_TIMEOUT_ERR_MASK 0x10
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_DATA_TIMEOUT_ERR_SHIFT 4
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_DATA_TIMEOUT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS0_DATA_TIMEOUT_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS0_DATA_TIMEOUT_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_DATA_TIMEOUT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS0_DATA_TIMEOUT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS0_DATA_TIMEOUT_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_INDEX_ERR_MASK 0x8
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_INDEX_ERR_SHIFT 3
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_INDEX_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_INDEX_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_INDEX_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_INDEX_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_INDEX_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_INDEX_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_END_BIT_ERR_MASK 0x4
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_END_BIT_ERR_SHIFT 2
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_END_BIT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_END_BIT_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_END_BIT_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_END_BIT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_END_BIT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_END_BIT_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_CRC_ERR_MASK 0x2
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_CRC_ERR_SHIFT 1
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_CRC_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_CRC_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_CRC_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_CRC_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_CRC_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_CRC_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_TIMEOUT_ERR_MASK 0x1
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_TIMEOUT_ERR_SHIFT 0
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_TIMEOUT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_TIMEOUT_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_TIMEOUT_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_TIMEOUT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_TIMEOUT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS0_CMD_TIMEOUT_ERR_SHIFT))

//====================================================================
//Register: Error Interrupt Status Register (Instance 2 of 2) (SD_ERROR_INT_STATUS1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CRC_STATUS_ERR_MASK 0x8000
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CRC_STATUS_ERR_SHIFT 15
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CRC_STATUS_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS1_CRC_STATUS_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS1_CRC_STATUS_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CRC_STATUS_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS1_CRC_STATUS_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS1_CRC_STATUS_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CPL_TIMEOUT_ERR_MASK 0x4000
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CPL_TIMEOUT_ERR_SHIFT 14
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CPL_TIMEOUT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS1_CPL_TIMEOUT_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS1_CPL_TIMEOUT_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CPL_TIMEOUT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS1_CPL_TIMEOUT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS1_CPL_TIMEOUT_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_AXI_RESP_ERR_MASK 0x2000
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_AXI_RESP_ERR_SHIFT 13
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_AXI_RESP_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS1_AXI_RESP_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS1_AXI_RESP_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_AXI_RESP_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS1_AXI_RESP_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS1_AXI_RESP_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_SPI_ERR_MASK 0x1000
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_SPI_ERR_SHIFT 12
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_SPI_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS1_SPI_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS1_SPI_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_SPI_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS1_SPI_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS1_SPI_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_RESERVED2_MASK 0x800
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS1_RESERVED2_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS1_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS1_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS1_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_TUNE_ERR_MASK 0x400
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_TUNE_ERR_SHIFT 10
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_TUNE_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS1_TUNE_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS1_TUNE_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_TUNE_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS1_TUNE_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS1_TUNE_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_ADMA_ERR_MASK 0x200
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_ADMA_ERR_SHIFT 9
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_ADMA_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS1_ADMA_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS1_ADMA_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_ADMA_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS1_ADMA_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS1_ADMA_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_AUTO_CMD12_ERR_MASK 0x100
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_AUTO_CMD12_ERR_SHIFT 8
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_AUTO_CMD12_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS1_AUTO_CMD12_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS1_AUTO_CMD12_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_AUTO_CMD12_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS1_AUTO_CMD12_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS1_AUTO_CMD12_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CUR_LIMIT_ERR_MASK 0x80
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CUR_LIMIT_ERR_SHIFT 7
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CUR_LIMIT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS1_CUR_LIMIT_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS1_CUR_LIMIT_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CUR_LIMIT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS1_CUR_LIMIT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS1_CUR_LIMIT_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_RD_DATA_END_BIT_ERR_MASK 0x40
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_RD_DATA_END_BIT_ERR_SHIFT 6
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_RD_DATA_END_BIT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS1_RD_DATA_END_BIT_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS1_RD_DATA_END_BIT_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_RD_DATA_END_BIT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS1_RD_DATA_END_BIT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS1_RD_DATA_END_BIT_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_RD_DATA_CRC_ERR_MASK 0x20
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_RD_DATA_CRC_ERR_SHIFT 5
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_RD_DATA_CRC_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS1_RD_DATA_CRC_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS1_RD_DATA_CRC_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_RD_DATA_CRC_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS1_RD_DATA_CRC_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS1_RD_DATA_CRC_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_DATA_TIMEOUT_ERR_MASK 0x10
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_DATA_TIMEOUT_ERR_SHIFT 4
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_DATA_TIMEOUT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS1_DATA_TIMEOUT_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS1_DATA_TIMEOUT_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_DATA_TIMEOUT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS1_DATA_TIMEOUT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS1_DATA_TIMEOUT_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_INDEX_ERR_MASK 0x8
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_INDEX_ERR_SHIFT 3
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_INDEX_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_INDEX_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_INDEX_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_INDEX_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_INDEX_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_INDEX_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_END_BIT_ERR_MASK 0x4
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_END_BIT_ERR_SHIFT 2
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_END_BIT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_END_BIT_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_END_BIT_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_END_BIT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_END_BIT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_END_BIT_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_CRC_ERR_MASK 0x2
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_CRC_ERR_SHIFT 1
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_CRC_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_CRC_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_CRC_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_CRC_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_CRC_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_CRC_ERR_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_TIMEOUT_ERR_MASK 0x1
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_TIMEOUT_ERR_SHIFT 0
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_TIMEOUT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_TIMEOUT_ERR_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_TIMEOUT_ERR_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_TIMEOUT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_TIMEOUT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS1_CMD_TIMEOUT_ERR_SHIFT))

//====================================================================
//Register: Normal Interrupt Status Enable Register (Instance 1 of 2) (SD_NORMAL_INT_STATUS_EN0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_FIXED_TO_0_MASK 0x8000
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_FIXED_TO_0_SHIFT 15
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_FIXED_TO_0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_FIXED_TO_0_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_FIXED_TO_0_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_FIXED_TO_0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_FIXED_TO_0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_FIXED_TO_0_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_RESERVED2_MASK 0x6000
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_RESERVED2_SHIFT 13
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_RESERVED2_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_RETUNE_INT_EN_MASK 0x1000
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_RETUNE_INT_EN_SHIFT 12
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_RETUNE_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_RETUNE_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_RETUNE_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_RETUNE_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_RETUNE_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_RETUNE_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_INT_C_INT_EN_MASK 0x800
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_INT_C_INT_EN_SHIFT 11
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_INT_C_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_INT_C_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_INT_C_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_INT_C_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_INT_C_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_INT_C_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_INT_B_INT_EN_MASK 0x400
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_INT_B_INT_EN_SHIFT 10
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_INT_B_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_INT_B_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_INT_B_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_INT_B_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_INT_B_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_INT_B_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_INT_A_INT_EN_MASK 0x200
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_INT_A_INT_EN_SHIFT 9
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_INT_A_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_INT_A_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_INT_A_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_INT_A_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_INT_A_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_INT_A_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CARD_INT_EN_MASK 0x100
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CARD_INT_EN_SHIFT 8
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CARD_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CARD_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CARD_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CARD_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CARD_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CARD_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CARD_REM_EN_MASK 0x80
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CARD_REM_EN_SHIFT 7
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CARD_REM_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CARD_REM_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CARD_REM_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CARD_REM_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CARD_REM_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CARD_REM_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CARD_INS_EN_MASK 0x40
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CARD_INS_EN_SHIFT 6
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CARD_INS_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CARD_INS_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CARD_INS_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CARD_INS_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CARD_INS_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CARD_INS_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_RD_RDY_EN_MASK 0x20
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_RD_RDY_EN_SHIFT 5
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_RD_RDY_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_RD_RDY_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_RD_RDY_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_RD_RDY_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_RD_RDY_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_RD_RDY_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_TX_RDY_EN_MASK 0x10
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_TX_RDY_EN_SHIFT 4
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_TX_RDY_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_TX_RDY_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_TX_RDY_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_TX_RDY_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_TX_RDY_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_TX_RDY_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_DMA_INT_EN_MASK 0x8
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_DMA_INT_EN_SHIFT 3
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_DMA_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_DMA_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_DMA_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_DMA_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_DMA_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_DMA_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_BLOCK_GAP_EVT_EN_MASK 0x4
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_BLOCK_GAP_EVT_EN_SHIFT 2
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_BLOCK_GAP_EVT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_BLOCK_GAP_EVT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_BLOCK_GAP_EVT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_BLOCK_GAP_EVT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_BLOCK_GAP_EVT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_BLOCK_GAP_EVT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_XFER_COMPLETE_EN_MASK 0x2
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_XFER_COMPLETE_EN_SHIFT 1
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_XFER_COMPLETE_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_XFER_COMPLETE_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_XFER_COMPLETE_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_XFER_COMPLETE_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_XFER_COMPLETE_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_XFER_COMPLETE_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CMD_COMPLETE_EN_MASK 0x1
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CMD_COMPLETE_EN_SHIFT 0
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CMD_COMPLETE_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CMD_COMPLETE_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CMD_COMPLETE_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CMD_COMPLETE_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CMD_COMPLETE_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN0_CMD_COMPLETE_EN_SHIFT))

//====================================================================
//Register: Normal Interrupt Status Enable Register (Instance 2 of 2) (SD_NORMAL_INT_STATUS_EN1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_FIXED_TO_0_MASK 0x8000
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_FIXED_TO_0_SHIFT 15
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_FIXED_TO_0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_FIXED_TO_0_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_FIXED_TO_0_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_FIXED_TO_0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_FIXED_TO_0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_FIXED_TO_0_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_RESERVED2_MASK 0x6000
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_RESERVED2_SHIFT 13
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_RESERVED2_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_RETUNE_INT_EN_MASK 0x1000
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_RETUNE_INT_EN_SHIFT 12
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_RETUNE_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_RETUNE_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_RETUNE_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_RETUNE_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_RETUNE_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_RETUNE_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_INT_C_INT_EN_MASK 0x800
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_INT_C_INT_EN_SHIFT 11
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_INT_C_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_INT_C_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_INT_C_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_INT_C_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_INT_C_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_INT_C_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_INT_B_INT_EN_MASK 0x400
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_INT_B_INT_EN_SHIFT 10
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_INT_B_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_INT_B_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_INT_B_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_INT_B_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_INT_B_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_INT_B_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_INT_A_INT_EN_MASK 0x200
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_INT_A_INT_EN_SHIFT 9
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_INT_A_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_INT_A_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_INT_A_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_INT_A_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_INT_A_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_INT_A_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CARD_INT_EN_MASK 0x100
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CARD_INT_EN_SHIFT 8
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CARD_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CARD_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CARD_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CARD_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CARD_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CARD_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CARD_REM_EN_MASK 0x80
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CARD_REM_EN_SHIFT 7
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CARD_REM_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CARD_REM_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CARD_REM_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CARD_REM_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CARD_REM_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CARD_REM_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CARD_INS_EN_MASK 0x40
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CARD_INS_EN_SHIFT 6
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CARD_INS_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CARD_INS_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CARD_INS_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CARD_INS_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CARD_INS_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CARD_INS_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_RD_RDY_EN_MASK 0x20
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_RD_RDY_EN_SHIFT 5
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_RD_RDY_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_RD_RDY_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_RD_RDY_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_RD_RDY_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_RD_RDY_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_RD_RDY_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_TX_RDY_EN_MASK 0x10
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_TX_RDY_EN_SHIFT 4
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_TX_RDY_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_TX_RDY_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_TX_RDY_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_TX_RDY_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_TX_RDY_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_TX_RDY_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_DMA_INT_EN_MASK 0x8
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_DMA_INT_EN_SHIFT 3
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_DMA_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_DMA_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_DMA_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_DMA_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_DMA_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_DMA_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_BLOCK_GAP_EVT_EN_MASK 0x4
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_BLOCK_GAP_EVT_EN_SHIFT 2
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_BLOCK_GAP_EVT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_BLOCK_GAP_EVT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_BLOCK_GAP_EVT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_BLOCK_GAP_EVT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_BLOCK_GAP_EVT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_BLOCK_GAP_EVT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_XFER_COMPLETE_EN_MASK 0x2
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_XFER_COMPLETE_EN_SHIFT 1
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_XFER_COMPLETE_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_XFER_COMPLETE_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_XFER_COMPLETE_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_XFER_COMPLETE_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_XFER_COMPLETE_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_XFER_COMPLETE_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CMD_COMPLETE_EN_MASK 0x1
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CMD_COMPLETE_EN_SHIFT 0
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CMD_COMPLETE_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CMD_COMPLETE_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CMD_COMPLETE_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CMD_COMPLETE_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CMD_COMPLETE_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_EN1_CMD_COMPLETE_EN_SHIFT))

//====================================================================
//Register: Error Interrupt Status Enable Register (Instance 1 of 2) (SD_ERROR_INT_STATUS_EN0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CRC_STATUS_ERR_EN_MASK 0x8000
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CRC_STATUS_ERR_EN_SHIFT 15
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CRC_STATUS_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CRC_STATUS_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CRC_STATUS_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CRC_STATUS_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CRC_STATUS_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CRC_STATUS_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CPL_TIMEOUT_ERR_EN_MASK 0x4000
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CPL_TIMEOUT_ERR_EN_SHIFT 14
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CPL_TIMEOUT_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CPL_TIMEOUT_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CPL_TIMEOUT_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CPL_TIMEOUT_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CPL_TIMEOUT_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CPL_TIMEOUT_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_AXI_RESP_ERR_EN_MASK 0x2000
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_AXI_RESP_ERR_EN_SHIFT 13
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_AXI_RESP_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_AXI_RESP_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_AXI_RESP_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_AXI_RESP_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_AXI_RESP_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_AXI_RESP_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_SPI_ERR_EN_MASK 0x1000
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_SPI_ERR_EN_SHIFT 12
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_SPI_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_SPI_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_SPI_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_SPI_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_SPI_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_SPI_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_RESERVED2_MASK 0x800
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_RESERVED2_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_TUNING_ERR_EN_MASK 0x400
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_TUNING_ERR_EN_SHIFT 10
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_TUNING_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_TUNING_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_TUNING_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_TUNING_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_TUNING_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_TUNING_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_ADMA_ERR_EN_MASK 0x200
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_ADMA_ERR_EN_SHIFT 9
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_ADMA_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_ADMA_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_ADMA_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_ADMA_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_ADMA_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_ADMA_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_AUTO_CMD12_ERR_EN_MASK 0x100
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_AUTO_CMD12_ERR_EN_SHIFT 8
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_AUTO_CMD12_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_AUTO_CMD12_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_AUTO_CMD12_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_AUTO_CMD12_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_AUTO_CMD12_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_AUTO_CMD12_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CUR_LIM_ERR_EN_MASK 0x80
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CUR_LIM_ERR_EN_SHIFT 7
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CUR_LIM_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CUR_LIM_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CUR_LIM_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CUR_LIM_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CUR_LIM_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CUR_LIM_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_RD_DATA_END_BIT_ERR_EN_MASK 0x40
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_RD_DATA_END_BIT_ERR_EN_SHIFT 6
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_RD_DATA_END_BIT_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_RD_DATA_END_BIT_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_RD_DATA_END_BIT_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_RD_DATA_END_BIT_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_RD_DATA_END_BIT_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_RD_DATA_END_BIT_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_RD_DATA_CRC_ERR_EN_MASK 0x20
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_RD_DATA_CRC_ERR_EN_SHIFT 5
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_RD_DATA_CRC_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_RD_DATA_CRC_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_RD_DATA_CRC_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_RD_DATA_CRC_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_RD_DATA_CRC_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_RD_DATA_CRC_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_DATA_TIMEOUT_ERR_EN_MASK 0x10
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_DATA_TIMEOUT_ERR_EN_SHIFT 4
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_DATA_TIMEOUT_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_DATA_TIMEOUT_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_DATA_TIMEOUT_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_DATA_TIMEOUT_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_DATA_TIMEOUT_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_DATA_TIMEOUT_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_INDEX_ERR_EN_MASK 0x8
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_INDEX_ERR_EN_SHIFT 3
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_INDEX_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_INDEX_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_INDEX_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_INDEX_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_INDEX_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_INDEX_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_END_BIT_ERR_EN_MASK 0x4
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_END_BIT_ERR_EN_SHIFT 2
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_END_BIT_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_END_BIT_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_END_BIT_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_END_BIT_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_END_BIT_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_END_BIT_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_CRC_ERR_EN_MASK 0x2
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_CRC_ERR_EN_SHIFT 1
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_CRC_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_CRC_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_CRC_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_CRC_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_CRC_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_CRC_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_TIMEOUT_ERR_EN_MASK 0x1
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_TIMEOUT_ERR_EN_SHIFT 0
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_TIMEOUT_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_TIMEOUT_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_TIMEOUT_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_TIMEOUT_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_TIMEOUT_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN0_CMD_TIMEOUT_ERR_EN_SHIFT))

//====================================================================
//Register: Error Interrupt Status Enable Register (Instance 2 of 2) (SD_ERROR_INT_STATUS_EN1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CRC_STATUS_ERR_EN_MASK 0x8000
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CRC_STATUS_ERR_EN_SHIFT 15
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CRC_STATUS_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CRC_STATUS_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CRC_STATUS_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CRC_STATUS_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CRC_STATUS_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CRC_STATUS_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CPL_TIMEOUT_ERR_EN_MASK 0x4000
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CPL_TIMEOUT_ERR_EN_SHIFT 14
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CPL_TIMEOUT_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CPL_TIMEOUT_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CPL_TIMEOUT_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CPL_TIMEOUT_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CPL_TIMEOUT_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CPL_TIMEOUT_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_AXI_RESP_ERR_EN_MASK 0x2000
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_AXI_RESP_ERR_EN_SHIFT 13
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_AXI_RESP_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_AXI_RESP_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_AXI_RESP_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_AXI_RESP_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_AXI_RESP_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_AXI_RESP_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_SPI_ERR_EN_MASK 0x1000
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_SPI_ERR_EN_SHIFT 12
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_SPI_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_SPI_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_SPI_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_SPI_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_SPI_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_SPI_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_RESERVED2_MASK 0x800
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_RESERVED2_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_TUNING_ERR_EN_MASK 0x400
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_TUNING_ERR_EN_SHIFT 10
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_TUNING_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_TUNING_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_TUNING_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_TUNING_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_TUNING_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_TUNING_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_ADMA_ERR_EN_MASK 0x200
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_ADMA_ERR_EN_SHIFT 9
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_ADMA_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_ADMA_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_ADMA_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_ADMA_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_ADMA_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_ADMA_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_AUTO_CMD12_ERR_EN_MASK 0x100
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_AUTO_CMD12_ERR_EN_SHIFT 8
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_AUTO_CMD12_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_AUTO_CMD12_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_AUTO_CMD12_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_AUTO_CMD12_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_AUTO_CMD12_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_AUTO_CMD12_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CUR_LIM_ERR_EN_MASK 0x80
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CUR_LIM_ERR_EN_SHIFT 7
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CUR_LIM_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CUR_LIM_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CUR_LIM_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CUR_LIM_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CUR_LIM_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CUR_LIM_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_RD_DATA_END_BIT_ERR_EN_MASK 0x40
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_RD_DATA_END_BIT_ERR_EN_SHIFT 6
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_RD_DATA_END_BIT_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_RD_DATA_END_BIT_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_RD_DATA_END_BIT_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_RD_DATA_END_BIT_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_RD_DATA_END_BIT_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_RD_DATA_END_BIT_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_RD_DATA_CRC_ERR_EN_MASK 0x20
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_RD_DATA_CRC_ERR_EN_SHIFT 5
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_RD_DATA_CRC_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_RD_DATA_CRC_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_RD_DATA_CRC_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_RD_DATA_CRC_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_RD_DATA_CRC_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_RD_DATA_CRC_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_DATA_TIMEOUT_ERR_EN_MASK 0x10
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_DATA_TIMEOUT_ERR_EN_SHIFT 4
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_DATA_TIMEOUT_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_DATA_TIMEOUT_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_DATA_TIMEOUT_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_DATA_TIMEOUT_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_DATA_TIMEOUT_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_DATA_TIMEOUT_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_INDEX_ERR_EN_MASK 0x8
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_INDEX_ERR_EN_SHIFT 3
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_INDEX_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_INDEX_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_INDEX_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_INDEX_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_INDEX_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_INDEX_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_END_BIT_ERR_EN_MASK 0x4
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_END_BIT_ERR_EN_SHIFT 2
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_END_BIT_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_END_BIT_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_END_BIT_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_END_BIT_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_END_BIT_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_END_BIT_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_CRC_ERR_EN_MASK 0x2
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_CRC_ERR_EN_SHIFT 1
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_CRC_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_CRC_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_CRC_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_CRC_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_CRC_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_CRC_ERR_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_TIMEOUT_ERR_EN_MASK 0x1
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_TIMEOUT_ERR_EN_SHIFT 0
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_TIMEOUT_ERR_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_TIMEOUT_ERR_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_TIMEOUT_ERR_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_TIMEOUT_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_TIMEOUT_ERR_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_EN1_CMD_TIMEOUT_ERR_EN_SHIFT))

//====================================================================
//Register: Normal Interrupt Signal Enable Register (Instance 1 of 2) (SD_NORMAL_INT_STATUS_INT_EN0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_RESERVED2_MASK 0xe000
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_RESERVED2_SHIFT 13
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_RESERVED2_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_RETUNE_EVT_EN_MASK 0x1000
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_RETUNE_EVT_EN_SHIFT 12
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_RETUNE_EVT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_RETUNE_EVT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_RETUNE_EVT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_RETUNE_EVT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_RETUNE_EVT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_RETUNE_EVT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_INT_C_EN_MASK 0x800
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_INT_C_EN_SHIFT 11
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_INT_C_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_INT_C_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_INT_C_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_INT_C_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_INT_C_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_INT_C_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_INT_B_EN_MASK 0x400
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_INT_B_EN_SHIFT 10
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_INT_B_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_INT_B_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_INT_B_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_INT_B_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_INT_B_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_INT_B_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_INT_A_EN_MASK 0x200
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_INT_A_EN_SHIFT 9
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_INT_A_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_INT_A_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_INT_A_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_INT_A_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_INT_A_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_INT_A_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CARD_INT_INT_EN_MASK 0x100
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CARD_INT_INT_EN_SHIFT 8
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CARD_INT_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CARD_INT_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CARD_INT_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CARD_INT_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CARD_INT_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CARD_INT_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CARD_REM_INT_EN_MASK 0x80
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CARD_REM_INT_EN_SHIFT 7
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CARD_REM_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CARD_REM_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CARD_REM_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CARD_REM_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CARD_REM_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CARD_REM_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CARD_INS_INT_EN_MASK 0x40
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CARD_INS_INT_EN_SHIFT 6
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CARD_INS_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CARD_INS_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CARD_INS_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CARD_INS_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CARD_INS_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CARD_INS_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_RX_RDY_INT_EN_MASK 0x20
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_RX_RDY_INT_EN_SHIFT 5
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_RX_RDY_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_RX_RDY_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_RX_RDY_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_RX_RDY_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_RX_RDY_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_RX_RDY_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_TX_RDY_INT_EN_MASK 0x10
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_TX_RDY_INT_EN_SHIFT 4
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_TX_RDY_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_TX_RDY_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_TX_RDY_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_TX_RDY_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_TX_RDY_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_TX_RDY_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_DMA_INT_INT_EN_MASK 0x8
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_DMA_INT_INT_EN_SHIFT 3
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_DMA_INT_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_DMA_INT_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_DMA_INT_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_DMA_INT_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_DMA_INT_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_DMA_INT_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_BLOCK_GAP_EVT_INT_EN_MASK 0x4
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_BLOCK_GAP_EVT_INT_EN_SHIFT 2
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_BLOCK_GAP_EVT_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_BLOCK_GAP_EVT_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_BLOCK_GAP_EVT_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_BLOCK_GAP_EVT_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_BLOCK_GAP_EVT_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_BLOCK_GAP_EVT_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_XFER_COMPLETE_INT_EN_MASK 0x2
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_XFER_COMPLETE_INT_EN_SHIFT 1
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_XFER_COMPLETE_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_XFER_COMPLETE_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_XFER_COMPLETE_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_XFER_COMPLETE_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_XFER_COMPLETE_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_XFER_COMPLETE_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CMD_COMPLETE_INT_EN_MASK 0x1
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CMD_COMPLETE_INT_EN_SHIFT 0
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CMD_COMPLETE_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CMD_COMPLETE_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CMD_COMPLETE_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CMD_COMPLETE_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CMD_COMPLETE_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN0_CMD_COMPLETE_INT_EN_SHIFT))

//====================================================================
//Register: Normal Interrupt Signal Enable Register (Instance 2 of 2) (SD_NORMAL_INT_STATUS_INT_EN1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_RESERVED2_MASK 0xe000
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_RESERVED2_SHIFT 13
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_RESERVED2_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_RETUNE_EVT_EN_MASK 0x1000
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_RETUNE_EVT_EN_SHIFT 12
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_RETUNE_EVT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_RETUNE_EVT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_RETUNE_EVT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_RETUNE_EVT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_RETUNE_EVT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_RETUNE_EVT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_INT_C_EN_MASK 0x800
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_INT_C_EN_SHIFT 11
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_INT_C_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_INT_C_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_INT_C_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_INT_C_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_INT_C_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_INT_C_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_INT_B_EN_MASK 0x400
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_INT_B_EN_SHIFT 10
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_INT_B_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_INT_B_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_INT_B_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_INT_B_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_INT_B_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_INT_B_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_INT_A_EN_MASK 0x200
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_INT_A_EN_SHIFT 9
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_INT_A_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_INT_A_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_INT_A_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_INT_A_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_INT_A_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_INT_A_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CARD_INT_INT_EN_MASK 0x100
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CARD_INT_INT_EN_SHIFT 8
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CARD_INT_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CARD_INT_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CARD_INT_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CARD_INT_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CARD_INT_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CARD_INT_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CARD_REM_INT_EN_MASK 0x80
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CARD_REM_INT_EN_SHIFT 7
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CARD_REM_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CARD_REM_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CARD_REM_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CARD_REM_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CARD_REM_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CARD_REM_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CARD_INS_INT_EN_MASK 0x40
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CARD_INS_INT_EN_SHIFT 6
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CARD_INS_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CARD_INS_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CARD_INS_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CARD_INS_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CARD_INS_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CARD_INS_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_RX_RDY_INT_EN_MASK 0x20
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_RX_RDY_INT_EN_SHIFT 5
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_RX_RDY_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_RX_RDY_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_RX_RDY_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_RX_RDY_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_RX_RDY_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_RX_RDY_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_TX_RDY_INT_EN_MASK 0x10
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_TX_RDY_INT_EN_SHIFT 4
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_TX_RDY_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_TX_RDY_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_TX_RDY_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_TX_RDY_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_TX_RDY_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_TX_RDY_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_DMA_INT_INT_EN_MASK 0x8
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_DMA_INT_INT_EN_SHIFT 3
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_DMA_INT_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_DMA_INT_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_DMA_INT_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_DMA_INT_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_DMA_INT_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_DMA_INT_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_BLOCK_GAP_EVT_INT_EN_MASK 0x4
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_BLOCK_GAP_EVT_INT_EN_SHIFT 2
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_BLOCK_GAP_EVT_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_BLOCK_GAP_EVT_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_BLOCK_GAP_EVT_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_BLOCK_GAP_EVT_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_BLOCK_GAP_EVT_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_BLOCK_GAP_EVT_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_XFER_COMPLETE_INT_EN_MASK 0x2
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_XFER_COMPLETE_INT_EN_SHIFT 1
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_XFER_COMPLETE_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_XFER_COMPLETE_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_XFER_COMPLETE_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_XFER_COMPLETE_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_XFER_COMPLETE_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_XFER_COMPLETE_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CMD_COMPLETE_INT_EN_MASK 0x1
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CMD_COMPLETE_INT_EN_SHIFT 0
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CMD_COMPLETE_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CMD_COMPLETE_INT_EN_MASK) >> SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CMD_COMPLETE_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CMD_COMPLETE_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CMD_COMPLETE_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_NORMAL_INT_STATUS_INT_EN1_CMD_COMPLETE_INT_EN_SHIFT))

//====================================================================
//Register: Error Interrupt Signal Enable Register (Instance 1 of 2) (SD_ERROR_INT_STATUS_INT_EN0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CRC_STATUS_ERR_INT_EN_MASK 0x8000
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CRC_STATUS_ERR_INT_EN_SHIFT 15
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CRC_STATUS_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CRC_STATUS_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CRC_STATUS_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CRC_STATUS_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CRC_STATUS_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CRC_STATUS_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CPL_TIMEOUT_ERR_INT_EN_MASK 0x4000
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CPL_TIMEOUT_ERR_INT_EN_SHIFT 14
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CPL_TIMEOUT_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CPL_TIMEOUT_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CPL_TIMEOUT_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CPL_TIMEOUT_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CPL_TIMEOUT_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CPL_TIMEOUT_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_AXI_RESP_ERR_INT_EN_MASK 0x2000
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_AXI_RESP_ERR_INT_EN_SHIFT 13
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_AXI_RESP_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_AXI_RESP_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_AXI_RESP_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_AXI_RESP_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_AXI_RESP_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_AXI_RESP_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_SPI_ERR_INT_EN_MASK 0x1000
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_SPI_ERR_INT_EN_SHIFT 12
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_SPI_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_SPI_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_SPI_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_SPI_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_SPI_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_SPI_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_RESERVED2_MASK 0x800
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_RESERVED2_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_TUNE_ERROR_INT_EN_MASK 0x400
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_TUNE_ERROR_INT_EN_SHIFT 10
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_TUNE_ERROR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_TUNE_ERROR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_TUNE_ERROR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_TUNE_ERROR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_TUNE_ERROR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_TUNE_ERROR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_ADMA_ERR_INT_EN_MASK 0x200
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_ADMA_ERR_INT_EN_SHIFT 9
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_ADMA_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_ADMA_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_ADMA_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_ADMA_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_ADMA_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_ADMA_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_AUTO_CMD12_ERR_INT_EN_MASK 0x100
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_AUTO_CMD12_ERR_INT_EN_SHIFT 8
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_AUTO_CMD12_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_AUTO_CMD12_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_AUTO_CMD12_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_AUTO_CMD12_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_AUTO_CMD12_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_AUTO_CMD12_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CUR_LIM_ERR_INT_EN_MASK 0x80
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CUR_LIM_ERR_INT_EN_SHIFT 7
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CUR_LIM_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CUR_LIM_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CUR_LIM_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CUR_LIM_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CUR_LIM_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CUR_LIM_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_RD_DATA_END_BIT_ERR_INT_EN_MASK 0x40
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_RD_DATA_END_BIT_ERR_INT_EN_SHIFT 6
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_RD_DATA_END_BIT_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_RD_DATA_END_BIT_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_RD_DATA_END_BIT_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_RD_DATA_END_BIT_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_RD_DATA_END_BIT_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_RD_DATA_END_BIT_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_RD_DATA_CRC_ERR_INT_EN_MASK 0x20
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_RD_DATA_CRC_ERR_INT_EN_SHIFT 5
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_RD_DATA_CRC_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_RD_DATA_CRC_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_RD_DATA_CRC_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_RD_DATA_CRC_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_RD_DATA_CRC_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_RD_DATA_CRC_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_DATA_TIMEOUT_ERR_INT_EN_MASK 0x10
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_DATA_TIMEOUT_ERR_INT_EN_SHIFT 4
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_DATA_TIMEOUT_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_DATA_TIMEOUT_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_DATA_TIMEOUT_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_DATA_TIMEOUT_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_DATA_TIMEOUT_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_DATA_TIMEOUT_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_INDEX_ERR_INT_EN_MASK 0x8
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_INDEX_ERR_INT_EN_SHIFT 3
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_INDEX_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_INDEX_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_INDEX_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_INDEX_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_INDEX_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_INDEX_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_END_BIT_ERR_INT_EN_MASK 0x4
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_END_BIT_ERR_INT_EN_SHIFT 2
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_END_BIT_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_END_BIT_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_END_BIT_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_END_BIT_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_END_BIT_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_END_BIT_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_CRC_ERR_INT_EN_MASK 0x2
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_CRC_ERR_INT_EN_SHIFT 1
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_CRC_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_CRC_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_CRC_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_CRC_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_CRC_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_CRC_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_TIMEOUT_ERR_INT_EN_MASK 0x1
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_TIMEOUT_ERR_INT_EN_SHIFT 0
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_TIMEOUT_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_TIMEOUT_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_TIMEOUT_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_TIMEOUT_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_TIMEOUT_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN0_CMD_TIMEOUT_ERR_INT_EN_SHIFT))

//====================================================================
//Register: Error Interrupt Signal Enable Register (Instance 2 of 2) (SD_ERROR_INT_STATUS_INT_EN1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CRC_STATUS_ERR_INT_EN_MASK 0x8000
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CRC_STATUS_ERR_INT_EN_SHIFT 15
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CRC_STATUS_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CRC_STATUS_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CRC_STATUS_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CRC_STATUS_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CRC_STATUS_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CRC_STATUS_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CPL_TIMEOUT_ERR_INT_EN_MASK 0x4000
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CPL_TIMEOUT_ERR_INT_EN_SHIFT 14
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CPL_TIMEOUT_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CPL_TIMEOUT_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CPL_TIMEOUT_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CPL_TIMEOUT_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CPL_TIMEOUT_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CPL_TIMEOUT_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_AXI_RESP_ERR_INT_EN_MASK 0x2000
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_AXI_RESP_ERR_INT_EN_SHIFT 13
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_AXI_RESP_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_AXI_RESP_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_AXI_RESP_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_AXI_RESP_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_AXI_RESP_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_AXI_RESP_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_SPI_ERR_INT_EN_MASK 0x1000
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_SPI_ERR_INT_EN_SHIFT 12
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_SPI_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_SPI_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_SPI_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_SPI_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_SPI_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_SPI_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_RESERVED2_MASK 0x800
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_RESERVED2_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_TUNE_ERROR_INT_EN_MASK 0x400
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_TUNE_ERROR_INT_EN_SHIFT 10
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_TUNE_ERROR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_TUNE_ERROR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_TUNE_ERROR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_TUNE_ERROR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_TUNE_ERROR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_TUNE_ERROR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_ADMA_ERR_INT_EN_MASK 0x200
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_ADMA_ERR_INT_EN_SHIFT 9
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_ADMA_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_ADMA_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_ADMA_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_ADMA_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_ADMA_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_ADMA_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_AUTO_CMD12_ERR_INT_EN_MASK 0x100
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_AUTO_CMD12_ERR_INT_EN_SHIFT 8
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_AUTO_CMD12_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_AUTO_CMD12_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_AUTO_CMD12_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_AUTO_CMD12_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_AUTO_CMD12_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_AUTO_CMD12_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CUR_LIM_ERR_INT_EN_MASK 0x80
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CUR_LIM_ERR_INT_EN_SHIFT 7
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CUR_LIM_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CUR_LIM_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CUR_LIM_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CUR_LIM_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CUR_LIM_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CUR_LIM_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_RD_DATA_END_BIT_ERR_INT_EN_MASK 0x40
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_RD_DATA_END_BIT_ERR_INT_EN_SHIFT 6
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_RD_DATA_END_BIT_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_RD_DATA_END_BIT_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_RD_DATA_END_BIT_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_RD_DATA_END_BIT_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_RD_DATA_END_BIT_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_RD_DATA_END_BIT_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_RD_DATA_CRC_ERR_INT_EN_MASK 0x20
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_RD_DATA_CRC_ERR_INT_EN_SHIFT 5
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_RD_DATA_CRC_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_RD_DATA_CRC_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_RD_DATA_CRC_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_RD_DATA_CRC_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_RD_DATA_CRC_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_RD_DATA_CRC_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_DATA_TIMEOUT_ERR_INT_EN_MASK 0x10
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_DATA_TIMEOUT_ERR_INT_EN_SHIFT 4
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_DATA_TIMEOUT_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_DATA_TIMEOUT_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_DATA_TIMEOUT_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_DATA_TIMEOUT_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_DATA_TIMEOUT_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_DATA_TIMEOUT_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_INDEX_ERR_INT_EN_MASK 0x8
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_INDEX_ERR_INT_EN_SHIFT 3
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_INDEX_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_INDEX_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_INDEX_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_INDEX_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_INDEX_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_INDEX_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_END_BIT_ERR_INT_EN_MASK 0x4
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_END_BIT_ERR_INT_EN_SHIFT 2
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_END_BIT_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_END_BIT_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_END_BIT_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_END_BIT_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_END_BIT_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_END_BIT_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_CRC_ERR_INT_EN_MASK 0x2
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_CRC_ERR_INT_EN_SHIFT 1
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_CRC_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_CRC_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_CRC_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_CRC_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_CRC_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_CRC_ERR_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_TIMEOUT_ERR_INT_EN_MASK 0x1
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_TIMEOUT_ERR_INT_EN_SHIFT 0
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_TIMEOUT_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_TIMEOUT_ERR_INT_EN_MASK) >> SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_TIMEOUT_ERR_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_TIMEOUT_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_TIMEOUT_ERR_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ERROR_INT_STATUS_INT_EN1_CMD_TIMEOUT_ERR_INT_EN_SHIFT))

//====================================================================
//Register: Auto CMD12 Error Status Register (Instance 1 of 2) (SD_AUTO_CMD12_ERROR_STATUS0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_RESERVED2_MASK 0xff00
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_RESERVED2_SHIFT 8
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_RESERVED2_MASK) >> SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_CMD_NOT_ISSUED_MASK 0x80
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_CMD_NOT_ISSUED_SHIFT 7
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_CMD_NOT_ISSUED_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_CMD_NOT_ISSUED_MASK) >> SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_CMD_NOT_ISSUED_SHIFT)
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_CMD_NOT_ISSUED_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_CMD_NOT_ISSUED_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_CMD_NOT_ISSUED_SHIFT))

#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_RESERVED3_MASK 0x60
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_RESERVED3_SHIFT 5
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_RESERVED3_MASK) >> SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_INDEX_ERR_MASK 0x10
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_INDEX_ERR_SHIFT 4
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_INDEX_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_INDEX_ERR_MASK) >> SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_INDEX_ERR_SHIFT)
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_INDEX_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_INDEX_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_INDEX_ERR_SHIFT))

#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_END_BIT_ERR_MASK 0x8
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_END_BIT_ERR_SHIFT 3
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_END_BIT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_END_BIT_ERR_MASK) >> SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_END_BIT_ERR_SHIFT)
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_END_BIT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_END_BIT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_END_BIT_ERR_SHIFT))

#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_CRC_ERR_MASK 0x4
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_CRC_ERR_SHIFT 2
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_CRC_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_CRC_ERR_MASK) >> SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_CRC_ERR_SHIFT)
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_CRC_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_CRC_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_CRC_ERR_SHIFT))

#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_TIMEOUT_ERR_MASK 0x2
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_TIMEOUT_ERR_SHIFT 1
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_TIMEOUT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_TIMEOUT_ERR_MASK) >> SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_TIMEOUT_ERR_SHIFT)
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_TIMEOUT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_TIMEOUT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_TIMEOUT_ERR_SHIFT))

#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_NOT_EXE_MASK 0x1
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_NOT_EXE_SHIFT 0
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_NOT_EXE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_NOT_EXE_MASK) >> SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_NOT_EXE_SHIFT)
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_NOT_EXE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_NOT_EXE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS0_AUTO_CMD12_NOT_EXE_SHIFT))

//====================================================================
//Register: Auto CMD12 Error Status Register (Instance 2 of 2) (SD_AUTO_CMD12_ERROR_STATUS1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_RESERVED2_MASK 0xff00
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_RESERVED2_SHIFT 8
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_RESERVED2_MASK) >> SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_CMD_NOT_ISSUED_MASK 0x80
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_CMD_NOT_ISSUED_SHIFT 7
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_CMD_NOT_ISSUED_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_CMD_NOT_ISSUED_MASK) >> SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_CMD_NOT_ISSUED_SHIFT)
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_CMD_NOT_ISSUED_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_CMD_NOT_ISSUED_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_CMD_NOT_ISSUED_SHIFT))

#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_RESERVED3_MASK 0x60
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_RESERVED3_SHIFT 5
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_RESERVED3_MASK) >> SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_INDEX_ERR_MASK 0x10
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_INDEX_ERR_SHIFT 4
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_INDEX_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_INDEX_ERR_MASK) >> SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_INDEX_ERR_SHIFT)
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_INDEX_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_INDEX_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_INDEX_ERR_SHIFT))

#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_END_BIT_ERR_MASK 0x8
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_END_BIT_ERR_SHIFT 3
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_END_BIT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_END_BIT_ERR_MASK) >> SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_END_BIT_ERR_SHIFT)
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_END_BIT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_END_BIT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_END_BIT_ERR_SHIFT))

#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_CRC_ERR_MASK 0x4
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_CRC_ERR_SHIFT 2
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_CRC_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_CRC_ERR_MASK) >> SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_CRC_ERR_SHIFT)
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_CRC_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_CRC_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_CRC_ERR_SHIFT))

#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_TIMEOUT_ERR_MASK 0x2
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_TIMEOUT_ERR_SHIFT 1
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_TIMEOUT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_TIMEOUT_ERR_MASK) >> SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_TIMEOUT_ERR_SHIFT)
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_TIMEOUT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_TIMEOUT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_TIMEOUT_ERR_SHIFT))

#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_NOT_EXE_MASK 0x1
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_NOT_EXE_SHIFT 0
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_NOT_EXE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_NOT_EXE_MASK) >> SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_NOT_EXE_SHIFT)
#define  SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_NOT_EXE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_NOT_EXE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_AUTO_CMD12_ERROR_STATUS1_AUTO_CMD12_NOT_EXE_SHIFT))

//====================================================================
//Register: Host Control Register 2 (Instance 1 of 2) (SD_HOST_CTRL20)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_HOST_CTRL20_PRESET_VAL_EN_MASK 0x8000
#define  SDMMC3_2P_SD_HOST_CTRL20_PRESET_VAL_EN_SHIFT 15
#define  SDMMC3_2P_SD_HOST_CTRL20_PRESET_VAL_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL20_PRESET_VAL_EN_MASK) >> SDMMC3_2P_SD_HOST_CTRL20_PRESET_VAL_EN_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL20_PRESET_VAL_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL20_PRESET_VAL_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL20_PRESET_VAL_EN_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL20_ASYNC_INT_EN_MASK 0x4000
#define  SDMMC3_2P_SD_HOST_CTRL20_ASYNC_INT_EN_SHIFT 14
#define  SDMMC3_2P_SD_HOST_CTRL20_ASYNC_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL20_ASYNC_INT_EN_MASK) >> SDMMC3_2P_SD_HOST_CTRL20_ASYNC_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL20_ASYNC_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL20_ASYNC_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL20_ASYNC_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL20_RESERVED2_MASK 0x3f00
#define  SDMMC3_2P_SD_HOST_CTRL20_RESERVED2_SHIFT 8
#define  SDMMC3_2P_SD_HOST_CTRL20_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL20_RESERVED2_MASK) >> SDMMC3_2P_SD_HOST_CTRL20_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL20_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL20_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL20_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL20_SAMPLE_CLK_SEL_MASK 0x80
#define  SDMMC3_2P_SD_HOST_CTRL20_SAMPLE_CLK_SEL_SHIFT 7
#define  SDMMC3_2P_SD_HOST_CTRL20_SAMPLE_CLK_SEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL20_SAMPLE_CLK_SEL_MASK) >> SDMMC3_2P_SD_HOST_CTRL20_SAMPLE_CLK_SEL_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL20_SAMPLE_CLK_SEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL20_SAMPLE_CLK_SEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL20_SAMPLE_CLK_SEL_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL20_EXE_TUNE_MASK 0x40
#define  SDMMC3_2P_SD_HOST_CTRL20_EXE_TUNE_SHIFT 6
#define  SDMMC3_2P_SD_HOST_CTRL20_EXE_TUNE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL20_EXE_TUNE_MASK) >> SDMMC3_2P_SD_HOST_CTRL20_EXE_TUNE_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL20_EXE_TUNE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL20_EXE_TUNE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL20_EXE_TUNE_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL20_DRV_STRENGTH_SEL_MASK 0x30
#define  SDMMC3_2P_SD_HOST_CTRL20_DRV_STRENGTH_SEL_SHIFT 4
#define  SDMMC3_2P_SD_HOST_CTRL20_DRV_STRENGTH_SEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL20_DRV_STRENGTH_SEL_MASK) >> SDMMC3_2P_SD_HOST_CTRL20_DRV_STRENGTH_SEL_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL20_DRV_STRENGTH_SEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL20_DRV_STRENGTH_SEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL20_DRV_STRENGTH_SEL_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL20_V18_ENABLE_MASK 0x8
#define  SDMMC3_2P_SD_HOST_CTRL20_V18_ENABLE_SHIFT 3
#define  SDMMC3_2P_SD_HOST_CTRL20_V18_ENABLE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL20_V18_ENABLE_MASK) >> SDMMC3_2P_SD_HOST_CTRL20_V18_ENABLE_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL20_V18_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL20_V18_ENABLE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL20_V18_ENABLE_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL20_UHS_MODE_SEL_MASK 0x7
#define  SDMMC3_2P_SD_HOST_CTRL20_UHS_MODE_SEL_SHIFT 0
#define  SDMMC3_2P_SD_HOST_CTRL20_UHS_MODE_SEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL20_UHS_MODE_SEL_MASK) >> SDMMC3_2P_SD_HOST_CTRL20_UHS_MODE_SEL_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL20_UHS_MODE_SEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL20_UHS_MODE_SEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL20_UHS_MODE_SEL_SHIFT))

//====================================================================
//Register: Host Control Register 2 (Instance 2 of 2) (SD_HOST_CTRL21)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_HOST_CTRL21_PRESET_VAL_EN_MASK 0x8000
#define  SDMMC3_2P_SD_HOST_CTRL21_PRESET_VAL_EN_SHIFT 15
#define  SDMMC3_2P_SD_HOST_CTRL21_PRESET_VAL_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL21_PRESET_VAL_EN_MASK) >> SDMMC3_2P_SD_HOST_CTRL21_PRESET_VAL_EN_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL21_PRESET_VAL_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL21_PRESET_VAL_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL21_PRESET_VAL_EN_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL21_ASYNC_INT_EN_MASK 0x4000
#define  SDMMC3_2P_SD_HOST_CTRL21_ASYNC_INT_EN_SHIFT 14
#define  SDMMC3_2P_SD_HOST_CTRL21_ASYNC_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL21_ASYNC_INT_EN_MASK) >> SDMMC3_2P_SD_HOST_CTRL21_ASYNC_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL21_ASYNC_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL21_ASYNC_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL21_ASYNC_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL21_RESERVED2_MASK 0x3f00
#define  SDMMC3_2P_SD_HOST_CTRL21_RESERVED2_SHIFT 8
#define  SDMMC3_2P_SD_HOST_CTRL21_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL21_RESERVED2_MASK) >> SDMMC3_2P_SD_HOST_CTRL21_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL21_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL21_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL21_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL21_SAMPLE_CLK_SEL_MASK 0x80
#define  SDMMC3_2P_SD_HOST_CTRL21_SAMPLE_CLK_SEL_SHIFT 7
#define  SDMMC3_2P_SD_HOST_CTRL21_SAMPLE_CLK_SEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL21_SAMPLE_CLK_SEL_MASK) >> SDMMC3_2P_SD_HOST_CTRL21_SAMPLE_CLK_SEL_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL21_SAMPLE_CLK_SEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL21_SAMPLE_CLK_SEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL21_SAMPLE_CLK_SEL_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL21_EXE_TUNE_MASK 0x40
#define  SDMMC3_2P_SD_HOST_CTRL21_EXE_TUNE_SHIFT 6
#define  SDMMC3_2P_SD_HOST_CTRL21_EXE_TUNE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL21_EXE_TUNE_MASK) >> SDMMC3_2P_SD_HOST_CTRL21_EXE_TUNE_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL21_EXE_TUNE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL21_EXE_TUNE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL21_EXE_TUNE_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL21_DRV_STRENGTH_SEL_MASK 0x30
#define  SDMMC3_2P_SD_HOST_CTRL21_DRV_STRENGTH_SEL_SHIFT 4
#define  SDMMC3_2P_SD_HOST_CTRL21_DRV_STRENGTH_SEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL21_DRV_STRENGTH_SEL_MASK) >> SDMMC3_2P_SD_HOST_CTRL21_DRV_STRENGTH_SEL_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL21_DRV_STRENGTH_SEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL21_DRV_STRENGTH_SEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL21_DRV_STRENGTH_SEL_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL21_V18_ENABLE_MASK 0x8
#define  SDMMC3_2P_SD_HOST_CTRL21_V18_ENABLE_SHIFT 3
#define  SDMMC3_2P_SD_HOST_CTRL21_V18_ENABLE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL21_V18_ENABLE_MASK) >> SDMMC3_2P_SD_HOST_CTRL21_V18_ENABLE_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL21_V18_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL21_V18_ENABLE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL21_V18_ENABLE_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL21_UHS_MODE_SEL_MASK 0x7
#define  SDMMC3_2P_SD_HOST_CTRL21_UHS_MODE_SEL_SHIFT 0
#define  SDMMC3_2P_SD_HOST_CTRL21_UHS_MODE_SEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL21_UHS_MODE_SEL_MASK) >> SDMMC3_2P_SD_HOST_CTRL21_UHS_MODE_SEL_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL21_UHS_MODE_SEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL21_UHS_MODE_SEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL21_UHS_MODE_SEL_SHIFT))

//====================================================================
//Register: Capabilities Register 0 (Instance 1 of 2) (SD_CAPABILITIES_00)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_CAPABILITIES_00_BASE_FREQ_MASK 0xff00
#define  SDMMC3_2P_SD_CAPABILITIES_00_BASE_FREQ_SHIFT 8
#define  SDMMC3_2P_SD_CAPABILITIES_00_BASE_FREQ_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_00_BASE_FREQ_MASK) >> SDMMC3_2P_SD_CAPABILITIES_00_BASE_FREQ_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_00_BASE_FREQ_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_00_BASE_FREQ_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_00_BASE_FREQ_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_00_TIMEOUT_UNIT_MASK 0x80
#define  SDMMC3_2P_SD_CAPABILITIES_00_TIMEOUT_UNIT_SHIFT 7
#define  SDMMC3_2P_SD_CAPABILITIES_00_TIMEOUT_UNIT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_00_TIMEOUT_UNIT_MASK) >> SDMMC3_2P_SD_CAPABILITIES_00_TIMEOUT_UNIT_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_00_TIMEOUT_UNIT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_00_TIMEOUT_UNIT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_00_TIMEOUT_UNIT_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_00_RESERVED2_MASK 0x40
#define  SDMMC3_2P_SD_CAPABILITIES_00_RESERVED2_SHIFT 6
#define  SDMMC3_2P_SD_CAPABILITIES_00_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_00_RESERVED2_MASK) >> SDMMC3_2P_SD_CAPABILITIES_00_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_00_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_00_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_00_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_00_TIMEOUT_FREQ_MASK 0x3f
#define  SDMMC3_2P_SD_CAPABILITIES_00_TIMEOUT_FREQ_SHIFT 0
#define  SDMMC3_2P_SD_CAPABILITIES_00_TIMEOUT_FREQ_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_00_TIMEOUT_FREQ_MASK) >> SDMMC3_2P_SD_CAPABILITIES_00_TIMEOUT_FREQ_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_00_TIMEOUT_FREQ_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_00_TIMEOUT_FREQ_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_00_TIMEOUT_FREQ_SHIFT))

//====================================================================
//Register: Capabilities Register 0 (Instance 2 of 2) (SD_CAPABILITIES_01)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_CAPABILITIES_01_BASE_FREQ_MASK 0xff00
#define  SDMMC3_2P_SD_CAPABILITIES_01_BASE_FREQ_SHIFT 8
#define  SDMMC3_2P_SD_CAPABILITIES_01_BASE_FREQ_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_01_BASE_FREQ_MASK) >> SDMMC3_2P_SD_CAPABILITIES_01_BASE_FREQ_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_01_BASE_FREQ_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_01_BASE_FREQ_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_01_BASE_FREQ_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_01_TIMEOUT_UNIT_MASK 0x80
#define  SDMMC3_2P_SD_CAPABILITIES_01_TIMEOUT_UNIT_SHIFT 7
#define  SDMMC3_2P_SD_CAPABILITIES_01_TIMEOUT_UNIT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_01_TIMEOUT_UNIT_MASK) >> SDMMC3_2P_SD_CAPABILITIES_01_TIMEOUT_UNIT_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_01_TIMEOUT_UNIT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_01_TIMEOUT_UNIT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_01_TIMEOUT_UNIT_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_01_RESERVED2_MASK 0x40
#define  SDMMC3_2P_SD_CAPABILITIES_01_RESERVED2_SHIFT 6
#define  SDMMC3_2P_SD_CAPABILITIES_01_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_01_RESERVED2_MASK) >> SDMMC3_2P_SD_CAPABILITIES_01_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_01_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_01_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_01_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_01_TIMEOUT_FREQ_MASK 0x3f
#define  SDMMC3_2P_SD_CAPABILITIES_01_TIMEOUT_FREQ_SHIFT 0
#define  SDMMC3_2P_SD_CAPABILITIES_01_TIMEOUT_FREQ_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_01_TIMEOUT_FREQ_MASK) >> SDMMC3_2P_SD_CAPABILITIES_01_TIMEOUT_FREQ_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_01_TIMEOUT_FREQ_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_01_TIMEOUT_FREQ_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_01_TIMEOUT_FREQ_SHIFT))

//====================================================================
//Register: Capabilities Register 1 (Instance 1 of 2) (SD_CAPABILITIES_10)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_CAPABILITIES_10_SLOT_TYPE_MASK 0xc000
#define  SDMMC3_2P_SD_CAPABILITIES_10_SLOT_TYPE_SHIFT 14
#define  SDMMC3_2P_SD_CAPABILITIES_10_SLOT_TYPE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_10_SLOT_TYPE_MASK) >> SDMMC3_2P_SD_CAPABILITIES_10_SLOT_TYPE_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_10_SLOT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_10_SLOT_TYPE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_10_SLOT_TYPE_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_10_ASYNC_INT_SUP_MASK 0x2000
#define  SDMMC3_2P_SD_CAPABILITIES_10_ASYNC_INT_SUP_SHIFT 13
#define  SDMMC3_2P_SD_CAPABILITIES_10_ASYNC_INT_SUP_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_10_ASYNC_INT_SUP_MASK) >> SDMMC3_2P_SD_CAPABILITIES_10_ASYNC_INT_SUP_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_10_ASYNC_INT_SUP_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_10_ASYNC_INT_SUP_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_10_ASYNC_INT_SUP_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_10_BUS_64_SUP_MASK 0x1000
#define  SDMMC3_2P_SD_CAPABILITIES_10_BUS_64_SUP_SHIFT 12
#define  SDMMC3_2P_SD_CAPABILITIES_10_BUS_64_SUP_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_10_BUS_64_SUP_MASK) >> SDMMC3_2P_SD_CAPABILITIES_10_BUS_64_SUP_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_10_BUS_64_SUP_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_10_BUS_64_SUP_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_10_BUS_64_SUP_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_10_RESERVED2_MASK 0x800
#define  SDMMC3_2P_SD_CAPABILITIES_10_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_CAPABILITIES_10_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_10_RESERVED2_MASK) >> SDMMC3_2P_SD_CAPABILITIES_10_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_10_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_10_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_10_VLT_18_SUPPORT_MASK 0x400
#define  SDMMC3_2P_SD_CAPABILITIES_10_VLT_18_SUPPORT_SHIFT 10
#define  SDMMC3_2P_SD_CAPABILITIES_10_VLT_18_SUPPORT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_10_VLT_18_SUPPORT_MASK) >> SDMMC3_2P_SD_CAPABILITIES_10_VLT_18_SUPPORT_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_10_VLT_18_SUPPORT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_10_VLT_18_SUPPORT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_10_VLT_18_SUPPORT_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_10_VLT_30_SUPPORT_MASK 0x200
#define  SDMMC3_2P_SD_CAPABILITIES_10_VLT_30_SUPPORT_SHIFT 9
#define  SDMMC3_2P_SD_CAPABILITIES_10_VLT_30_SUPPORT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_10_VLT_30_SUPPORT_MASK) >> SDMMC3_2P_SD_CAPABILITIES_10_VLT_30_SUPPORT_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_10_VLT_30_SUPPORT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_10_VLT_30_SUPPORT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_10_VLT_30_SUPPORT_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_10_VLT_33_SUPPORT_MASK 0x100
#define  SDMMC3_2P_SD_CAPABILITIES_10_VLT_33_SUPPORT_SHIFT 8
#define  SDMMC3_2P_SD_CAPABILITIES_10_VLT_33_SUPPORT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_10_VLT_33_SUPPORT_MASK) >> SDMMC3_2P_SD_CAPABILITIES_10_VLT_33_SUPPORT_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_10_VLT_33_SUPPORT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_10_VLT_33_SUPPORT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_10_VLT_33_SUPPORT_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_10_SUSPEND_RESUME_SUPPORT_MASK 0x80
#define  SDMMC3_2P_SD_CAPABILITIES_10_SUSPEND_RESUME_SUPPORT_SHIFT 7
#define  SDMMC3_2P_SD_CAPABILITIES_10_SUSPEND_RESUME_SUPPORT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_10_SUSPEND_RESUME_SUPPORT_MASK) >> SDMMC3_2P_SD_CAPABILITIES_10_SUSPEND_RESUME_SUPPORT_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_10_SUSPEND_RESUME_SUPPORT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_10_SUSPEND_RESUME_SUPPORT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_10_SUSPEND_RESUME_SUPPORT_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_10_DMA_SUPORT_MASK 0x40
#define  SDMMC3_2P_SD_CAPABILITIES_10_DMA_SUPORT_SHIFT 6
#define  SDMMC3_2P_SD_CAPABILITIES_10_DMA_SUPORT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_10_DMA_SUPORT_MASK) >> SDMMC3_2P_SD_CAPABILITIES_10_DMA_SUPORT_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_10_DMA_SUPORT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_10_DMA_SUPORT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_10_DMA_SUPORT_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_10_HI_SPEED_SUPPORT_MASK 0x20
#define  SDMMC3_2P_SD_CAPABILITIES_10_HI_SPEED_SUPPORT_SHIFT 5
#define  SDMMC3_2P_SD_CAPABILITIES_10_HI_SPEED_SUPPORT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_10_HI_SPEED_SUPPORT_MASK) >> SDMMC3_2P_SD_CAPABILITIES_10_HI_SPEED_SUPPORT_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_10_HI_SPEED_SUPPORT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_10_HI_SPEED_SUPPORT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_10_HI_SPEED_SUPPORT_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_10_ADMA1_SUPPORT_MASK 0x10
#define  SDMMC3_2P_SD_CAPABILITIES_10_ADMA1_SUPPORT_SHIFT 4
#define  SDMMC3_2P_SD_CAPABILITIES_10_ADMA1_SUPPORT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_10_ADMA1_SUPPORT_MASK) >> SDMMC3_2P_SD_CAPABILITIES_10_ADMA1_SUPPORT_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_10_ADMA1_SUPPORT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_10_ADMA1_SUPPORT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_10_ADMA1_SUPPORT_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_10_ADMA2_SUPPORT_MASK 0x8
#define  SDMMC3_2P_SD_CAPABILITIES_10_ADMA2_SUPPORT_SHIFT 3
#define  SDMMC3_2P_SD_CAPABILITIES_10_ADMA2_SUPPORT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_10_ADMA2_SUPPORT_MASK) >> SDMMC3_2P_SD_CAPABILITIES_10_ADMA2_SUPPORT_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_10_ADMA2_SUPPORT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_10_ADMA2_SUPPORT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_10_ADMA2_SUPPORT_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_10_EIGHT_BIT_SUP_MASK 0x4
#define  SDMMC3_2P_SD_CAPABILITIES_10_EIGHT_BIT_SUP_SHIFT 2
#define  SDMMC3_2P_SD_CAPABILITIES_10_EIGHT_BIT_SUP_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_10_EIGHT_BIT_SUP_MASK) >> SDMMC3_2P_SD_CAPABILITIES_10_EIGHT_BIT_SUP_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_10_EIGHT_BIT_SUP_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_10_EIGHT_BIT_SUP_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_10_EIGHT_BIT_SUP_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_10_MAX_BLK_LEN_MASK 0x3
#define  SDMMC3_2P_SD_CAPABILITIES_10_MAX_BLK_LEN_SHIFT 0
#define  SDMMC3_2P_SD_CAPABILITIES_10_MAX_BLK_LEN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_10_MAX_BLK_LEN_MASK) >> SDMMC3_2P_SD_CAPABILITIES_10_MAX_BLK_LEN_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_10_MAX_BLK_LEN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_10_MAX_BLK_LEN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_10_MAX_BLK_LEN_SHIFT))

//====================================================================
//Register: Capabilities Register 1 (Instance 2 of 2) (SD_CAPABILITIES_11)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_CAPABILITIES_11_SLOT_TYPE_MASK 0xc000
#define  SDMMC3_2P_SD_CAPABILITIES_11_SLOT_TYPE_SHIFT 14
#define  SDMMC3_2P_SD_CAPABILITIES_11_SLOT_TYPE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_11_SLOT_TYPE_MASK) >> SDMMC3_2P_SD_CAPABILITIES_11_SLOT_TYPE_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_11_SLOT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_11_SLOT_TYPE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_11_SLOT_TYPE_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_11_ASYNC_INT_SUP_MASK 0x2000
#define  SDMMC3_2P_SD_CAPABILITIES_11_ASYNC_INT_SUP_SHIFT 13
#define  SDMMC3_2P_SD_CAPABILITIES_11_ASYNC_INT_SUP_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_11_ASYNC_INT_SUP_MASK) >> SDMMC3_2P_SD_CAPABILITIES_11_ASYNC_INT_SUP_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_11_ASYNC_INT_SUP_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_11_ASYNC_INT_SUP_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_11_ASYNC_INT_SUP_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_11_BUS_64_SUP_MASK 0x1000
#define  SDMMC3_2P_SD_CAPABILITIES_11_BUS_64_SUP_SHIFT 12
#define  SDMMC3_2P_SD_CAPABILITIES_11_BUS_64_SUP_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_11_BUS_64_SUP_MASK) >> SDMMC3_2P_SD_CAPABILITIES_11_BUS_64_SUP_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_11_BUS_64_SUP_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_11_BUS_64_SUP_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_11_BUS_64_SUP_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_11_RESERVED2_MASK 0x800
#define  SDMMC3_2P_SD_CAPABILITIES_11_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_CAPABILITIES_11_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_11_RESERVED2_MASK) >> SDMMC3_2P_SD_CAPABILITIES_11_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_11_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_11_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_11_VLT_18_SUPPORT_MASK 0x400
#define  SDMMC3_2P_SD_CAPABILITIES_11_VLT_18_SUPPORT_SHIFT 10
#define  SDMMC3_2P_SD_CAPABILITIES_11_VLT_18_SUPPORT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_11_VLT_18_SUPPORT_MASK) >> SDMMC3_2P_SD_CAPABILITIES_11_VLT_18_SUPPORT_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_11_VLT_18_SUPPORT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_11_VLT_18_SUPPORT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_11_VLT_18_SUPPORT_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_11_VLT_30_SUPPORT_MASK 0x200
#define  SDMMC3_2P_SD_CAPABILITIES_11_VLT_30_SUPPORT_SHIFT 9
#define  SDMMC3_2P_SD_CAPABILITIES_11_VLT_30_SUPPORT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_11_VLT_30_SUPPORT_MASK) >> SDMMC3_2P_SD_CAPABILITIES_11_VLT_30_SUPPORT_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_11_VLT_30_SUPPORT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_11_VLT_30_SUPPORT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_11_VLT_30_SUPPORT_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_11_VLT_33_SUPPORT_MASK 0x100
#define  SDMMC3_2P_SD_CAPABILITIES_11_VLT_33_SUPPORT_SHIFT 8
#define  SDMMC3_2P_SD_CAPABILITIES_11_VLT_33_SUPPORT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_11_VLT_33_SUPPORT_MASK) >> SDMMC3_2P_SD_CAPABILITIES_11_VLT_33_SUPPORT_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_11_VLT_33_SUPPORT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_11_VLT_33_SUPPORT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_11_VLT_33_SUPPORT_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_11_SUSPEND_RESUME_SUPPORT_MASK 0x80
#define  SDMMC3_2P_SD_CAPABILITIES_11_SUSPEND_RESUME_SUPPORT_SHIFT 7
#define  SDMMC3_2P_SD_CAPABILITIES_11_SUSPEND_RESUME_SUPPORT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_11_SUSPEND_RESUME_SUPPORT_MASK) >> SDMMC3_2P_SD_CAPABILITIES_11_SUSPEND_RESUME_SUPPORT_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_11_SUSPEND_RESUME_SUPPORT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_11_SUSPEND_RESUME_SUPPORT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_11_SUSPEND_RESUME_SUPPORT_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_11_DMA_SUPORT_MASK 0x40
#define  SDMMC3_2P_SD_CAPABILITIES_11_DMA_SUPORT_SHIFT 6
#define  SDMMC3_2P_SD_CAPABILITIES_11_DMA_SUPORT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_11_DMA_SUPORT_MASK) >> SDMMC3_2P_SD_CAPABILITIES_11_DMA_SUPORT_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_11_DMA_SUPORT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_11_DMA_SUPORT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_11_DMA_SUPORT_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_11_HI_SPEED_SUPPORT_MASK 0x20
#define  SDMMC3_2P_SD_CAPABILITIES_11_HI_SPEED_SUPPORT_SHIFT 5
#define  SDMMC3_2P_SD_CAPABILITIES_11_HI_SPEED_SUPPORT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_11_HI_SPEED_SUPPORT_MASK) >> SDMMC3_2P_SD_CAPABILITIES_11_HI_SPEED_SUPPORT_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_11_HI_SPEED_SUPPORT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_11_HI_SPEED_SUPPORT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_11_HI_SPEED_SUPPORT_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_11_ADMA1_SUPPORT_MASK 0x10
#define  SDMMC3_2P_SD_CAPABILITIES_11_ADMA1_SUPPORT_SHIFT 4
#define  SDMMC3_2P_SD_CAPABILITIES_11_ADMA1_SUPPORT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_11_ADMA1_SUPPORT_MASK) >> SDMMC3_2P_SD_CAPABILITIES_11_ADMA1_SUPPORT_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_11_ADMA1_SUPPORT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_11_ADMA1_SUPPORT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_11_ADMA1_SUPPORT_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_11_ADMA2_SUPPORT_MASK 0x8
#define  SDMMC3_2P_SD_CAPABILITIES_11_ADMA2_SUPPORT_SHIFT 3
#define  SDMMC3_2P_SD_CAPABILITIES_11_ADMA2_SUPPORT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_11_ADMA2_SUPPORT_MASK) >> SDMMC3_2P_SD_CAPABILITIES_11_ADMA2_SUPPORT_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_11_ADMA2_SUPPORT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_11_ADMA2_SUPPORT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_11_ADMA2_SUPPORT_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_11_EIGHT_BIT_SUP_MASK 0x4
#define  SDMMC3_2P_SD_CAPABILITIES_11_EIGHT_BIT_SUP_SHIFT 2
#define  SDMMC3_2P_SD_CAPABILITIES_11_EIGHT_BIT_SUP_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_11_EIGHT_BIT_SUP_MASK) >> SDMMC3_2P_SD_CAPABILITIES_11_EIGHT_BIT_SUP_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_11_EIGHT_BIT_SUP_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_11_EIGHT_BIT_SUP_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_11_EIGHT_BIT_SUP_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_11_MAX_BLK_LEN_MASK 0x3
#define  SDMMC3_2P_SD_CAPABILITIES_11_MAX_BLK_LEN_SHIFT 0
#define  SDMMC3_2P_SD_CAPABILITIES_11_MAX_BLK_LEN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_11_MAX_BLK_LEN_MASK) >> SDMMC3_2P_SD_CAPABILITIES_11_MAX_BLK_LEN_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_11_MAX_BLK_LEN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_11_MAX_BLK_LEN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_11_MAX_BLK_LEN_SHIFT))

//====================================================================
//Register: Capabilities Register 2 (Instance 1 of 2) (SD_CAPABILITIES_20)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_CAPABILITIES_20_RETUNING_MODE_MASK 0xc000
#define  SDMMC3_2P_SD_CAPABILITIES_20_RETUNING_MODE_SHIFT 14
#define  SDMMC3_2P_SD_CAPABILITIES_20_RETUNING_MODE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_20_RETUNING_MODE_MASK) >> SDMMC3_2P_SD_CAPABILITIES_20_RETUNING_MODE_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_20_RETUNING_MODE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_20_RETUNING_MODE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_20_RETUNING_MODE_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_20_SDR50_TUNING_MASK 0x2000
#define  SDMMC3_2P_SD_CAPABILITIES_20_SDR50_TUNING_SHIFT 13
#define  SDMMC3_2P_SD_CAPABILITIES_20_SDR50_TUNING_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_20_SDR50_TUNING_MASK) >> SDMMC3_2P_SD_CAPABILITIES_20_SDR50_TUNING_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_20_SDR50_TUNING_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_20_SDR50_TUNING_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_20_SDR50_TUNING_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_20_RESERVED2_MASK 0x1000
#define  SDMMC3_2P_SD_CAPABILITIES_20_RESERVED2_SHIFT 12
#define  SDMMC3_2P_SD_CAPABILITIES_20_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_20_RESERVED2_MASK) >> SDMMC3_2P_SD_CAPABILITIES_20_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_20_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_20_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_20_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_20_RETUNE_TIMER_MASK 0xf00
#define  SDMMC3_2P_SD_CAPABILITIES_20_RETUNE_TIMER_SHIFT 8
#define  SDMMC3_2P_SD_CAPABILITIES_20_RETUNE_TIMER_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_20_RETUNE_TIMER_MASK) >> SDMMC3_2P_SD_CAPABILITIES_20_RETUNE_TIMER_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_20_RETUNE_TIMER_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_20_RETUNE_TIMER_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_20_RETUNE_TIMER_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_20_RESERVED3_MASK 0x80
#define  SDMMC3_2P_SD_CAPABILITIES_20_RESERVED3_SHIFT 7
#define  SDMMC3_2P_SD_CAPABILITIES_20_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_20_RESERVED3_MASK) >> SDMMC3_2P_SD_CAPABILITIES_20_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_20_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_20_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_20_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_20_DRV_TYPE_D_MASK 0x40
#define  SDMMC3_2P_SD_CAPABILITIES_20_DRV_TYPE_D_SHIFT 6
#define  SDMMC3_2P_SD_CAPABILITIES_20_DRV_TYPE_D_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_20_DRV_TYPE_D_MASK) >> SDMMC3_2P_SD_CAPABILITIES_20_DRV_TYPE_D_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_20_DRV_TYPE_D_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_20_DRV_TYPE_D_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_20_DRV_TYPE_D_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_20_DRV_TYPE_C_MASK 0x20
#define  SDMMC3_2P_SD_CAPABILITIES_20_DRV_TYPE_C_SHIFT 5
#define  SDMMC3_2P_SD_CAPABILITIES_20_DRV_TYPE_C_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_20_DRV_TYPE_C_MASK) >> SDMMC3_2P_SD_CAPABILITIES_20_DRV_TYPE_C_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_20_DRV_TYPE_C_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_20_DRV_TYPE_C_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_20_DRV_TYPE_C_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_20_DRV_TYPE_A_MASK 0x10
#define  SDMMC3_2P_SD_CAPABILITIES_20_DRV_TYPE_A_SHIFT 4
#define  SDMMC3_2P_SD_CAPABILITIES_20_DRV_TYPE_A_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_20_DRV_TYPE_A_MASK) >> SDMMC3_2P_SD_CAPABILITIES_20_DRV_TYPE_A_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_20_DRV_TYPE_A_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_20_DRV_TYPE_A_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_20_DRV_TYPE_A_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_20_RESERVED4_MASK 0x8
#define  SDMMC3_2P_SD_CAPABILITIES_20_RESERVED4_SHIFT 3
#define  SDMMC3_2P_SD_CAPABILITIES_20_RESERVED4_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_20_RESERVED4_MASK) >> SDMMC3_2P_SD_CAPABILITIES_20_RESERVED4_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_20_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_20_RESERVED4_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_20_RESERVED4_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_20_DDR50_MASK 0x4
#define  SDMMC3_2P_SD_CAPABILITIES_20_DDR50_SHIFT 2
#define  SDMMC3_2P_SD_CAPABILITIES_20_DDR50_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_20_DDR50_MASK) >> SDMMC3_2P_SD_CAPABILITIES_20_DDR50_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_20_DDR50_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_20_DDR50_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_20_DDR50_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_20_SDR104_MASK 0x2
#define  SDMMC3_2P_SD_CAPABILITIES_20_SDR104_SHIFT 1
#define  SDMMC3_2P_SD_CAPABILITIES_20_SDR104_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_20_SDR104_MASK) >> SDMMC3_2P_SD_CAPABILITIES_20_SDR104_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_20_SDR104_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_20_SDR104_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_20_SDR104_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_20_SDR50_MASK 0x1
#define  SDMMC3_2P_SD_CAPABILITIES_20_SDR50_SHIFT 0
#define  SDMMC3_2P_SD_CAPABILITIES_20_SDR50_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_20_SDR50_MASK) >> SDMMC3_2P_SD_CAPABILITIES_20_SDR50_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_20_SDR50_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_20_SDR50_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_20_SDR50_SHIFT))

//====================================================================
//Register: Capabilities Register 2 (Instance 2 of 2) (SD_CAPABILITIES_21)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_CAPABILITIES_21_RETUNING_MODE_MASK 0xc000
#define  SDMMC3_2P_SD_CAPABILITIES_21_RETUNING_MODE_SHIFT 14
#define  SDMMC3_2P_SD_CAPABILITIES_21_RETUNING_MODE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_21_RETUNING_MODE_MASK) >> SDMMC3_2P_SD_CAPABILITIES_21_RETUNING_MODE_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_21_RETUNING_MODE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_21_RETUNING_MODE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_21_RETUNING_MODE_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_21_SDR50_TUNING_MASK 0x2000
#define  SDMMC3_2P_SD_CAPABILITIES_21_SDR50_TUNING_SHIFT 13
#define  SDMMC3_2P_SD_CAPABILITIES_21_SDR50_TUNING_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_21_SDR50_TUNING_MASK) >> SDMMC3_2P_SD_CAPABILITIES_21_SDR50_TUNING_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_21_SDR50_TUNING_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_21_SDR50_TUNING_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_21_SDR50_TUNING_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_21_RESERVED2_MASK 0x1000
#define  SDMMC3_2P_SD_CAPABILITIES_21_RESERVED2_SHIFT 12
#define  SDMMC3_2P_SD_CAPABILITIES_21_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_21_RESERVED2_MASK) >> SDMMC3_2P_SD_CAPABILITIES_21_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_21_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_21_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_21_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_21_RETUNE_TIMER_MASK 0xf00
#define  SDMMC3_2P_SD_CAPABILITIES_21_RETUNE_TIMER_SHIFT 8
#define  SDMMC3_2P_SD_CAPABILITIES_21_RETUNE_TIMER_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_21_RETUNE_TIMER_MASK) >> SDMMC3_2P_SD_CAPABILITIES_21_RETUNE_TIMER_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_21_RETUNE_TIMER_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_21_RETUNE_TIMER_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_21_RETUNE_TIMER_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_21_RESERVED3_MASK 0x80
#define  SDMMC3_2P_SD_CAPABILITIES_21_RESERVED3_SHIFT 7
#define  SDMMC3_2P_SD_CAPABILITIES_21_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_21_RESERVED3_MASK) >> SDMMC3_2P_SD_CAPABILITIES_21_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_21_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_21_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_21_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_21_DRV_TYPE_D_MASK 0x40
#define  SDMMC3_2P_SD_CAPABILITIES_21_DRV_TYPE_D_SHIFT 6
#define  SDMMC3_2P_SD_CAPABILITIES_21_DRV_TYPE_D_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_21_DRV_TYPE_D_MASK) >> SDMMC3_2P_SD_CAPABILITIES_21_DRV_TYPE_D_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_21_DRV_TYPE_D_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_21_DRV_TYPE_D_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_21_DRV_TYPE_D_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_21_DRV_TYPE_C_MASK 0x20
#define  SDMMC3_2P_SD_CAPABILITIES_21_DRV_TYPE_C_SHIFT 5
#define  SDMMC3_2P_SD_CAPABILITIES_21_DRV_TYPE_C_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_21_DRV_TYPE_C_MASK) >> SDMMC3_2P_SD_CAPABILITIES_21_DRV_TYPE_C_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_21_DRV_TYPE_C_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_21_DRV_TYPE_C_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_21_DRV_TYPE_C_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_21_DRV_TYPE_A_MASK 0x10
#define  SDMMC3_2P_SD_CAPABILITIES_21_DRV_TYPE_A_SHIFT 4
#define  SDMMC3_2P_SD_CAPABILITIES_21_DRV_TYPE_A_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_21_DRV_TYPE_A_MASK) >> SDMMC3_2P_SD_CAPABILITIES_21_DRV_TYPE_A_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_21_DRV_TYPE_A_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_21_DRV_TYPE_A_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_21_DRV_TYPE_A_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_21_RESERVED4_MASK 0x8
#define  SDMMC3_2P_SD_CAPABILITIES_21_RESERVED4_SHIFT 3
#define  SDMMC3_2P_SD_CAPABILITIES_21_RESERVED4_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_21_RESERVED4_MASK) >> SDMMC3_2P_SD_CAPABILITIES_21_RESERVED4_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_21_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_21_RESERVED4_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_21_RESERVED4_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_21_DDR50_MASK 0x4
#define  SDMMC3_2P_SD_CAPABILITIES_21_DDR50_SHIFT 2
#define  SDMMC3_2P_SD_CAPABILITIES_21_DDR50_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_21_DDR50_MASK) >> SDMMC3_2P_SD_CAPABILITIES_21_DDR50_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_21_DDR50_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_21_DDR50_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_21_DDR50_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_21_SDR104_MASK 0x2
#define  SDMMC3_2P_SD_CAPABILITIES_21_SDR104_SHIFT 1
#define  SDMMC3_2P_SD_CAPABILITIES_21_SDR104_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_21_SDR104_MASK) >> SDMMC3_2P_SD_CAPABILITIES_21_SDR104_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_21_SDR104_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_21_SDR104_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_21_SDR104_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_21_SDR50_MASK 0x1
#define  SDMMC3_2P_SD_CAPABILITIES_21_SDR50_SHIFT 0
#define  SDMMC3_2P_SD_CAPABILITIES_21_SDR50_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_21_SDR50_MASK) >> SDMMC3_2P_SD_CAPABILITIES_21_SDR50_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_21_SDR50_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_21_SDR50_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_21_SDR50_SHIFT))

//====================================================================
//Register: Capabilities Register 3 (Instance 1 of 2) (SD_CAPABILITIES_30)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_CAPABILITIES_30_RESERVED2_MASK 0xff00
#define  SDMMC3_2P_SD_CAPABILITIES_30_RESERVED2_SHIFT 8
#define  SDMMC3_2P_SD_CAPABILITIES_30_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_30_RESERVED2_MASK) >> SDMMC3_2P_SD_CAPABILITIES_30_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_30_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_30_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_30_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_30_CLK_MULT_MASK 0xff
#define  SDMMC3_2P_SD_CAPABILITIES_30_CLK_MULT_SHIFT 0
#define  SDMMC3_2P_SD_CAPABILITIES_30_CLK_MULT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_30_CLK_MULT_MASK) >> SDMMC3_2P_SD_CAPABILITIES_30_CLK_MULT_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_30_CLK_MULT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_30_CLK_MULT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_30_CLK_MULT_SHIFT))

//====================================================================
//Register: Capabilities Register 3 (Instance 2 of 2) (SD_CAPABILITIES_31)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_CAPABILITIES_31_RESERVED2_MASK 0xff00
#define  SDMMC3_2P_SD_CAPABILITIES_31_RESERVED2_SHIFT 8
#define  SDMMC3_2P_SD_CAPABILITIES_31_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_31_RESERVED2_MASK) >> SDMMC3_2P_SD_CAPABILITIES_31_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_31_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_31_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_31_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_CAPABILITIES_31_CLK_MULT_MASK 0xff
#define  SDMMC3_2P_SD_CAPABILITIES_31_CLK_MULT_SHIFT 0
#define  SDMMC3_2P_SD_CAPABILITIES_31_CLK_MULT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CAPABILITIES_31_CLK_MULT_MASK) >> SDMMC3_2P_SD_CAPABILITIES_31_CLK_MULT_SHIFT)
#define  SDMMC3_2P_SD_CAPABILITIES_31_CLK_MULT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CAPABILITIES_31_CLK_MULT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CAPABILITIES_31_CLK_MULT_SHIFT))

//====================================================================
//Register: Maximum Current Register 0 (Instance 1 of 2) (SD_MAX_CURRENT_00)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_MAX_CURRENT_00_MAX_CUR_30_MASK 0xff00
#define  SDMMC3_2P_SD_MAX_CURRENT_00_MAX_CUR_30_SHIFT 8
#define  SDMMC3_2P_SD_MAX_CURRENT_00_MAX_CUR_30_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_MAX_CURRENT_00_MAX_CUR_30_MASK) >> SDMMC3_2P_SD_MAX_CURRENT_00_MAX_CUR_30_SHIFT)
#define  SDMMC3_2P_SD_MAX_CURRENT_00_MAX_CUR_30_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_MAX_CURRENT_00_MAX_CUR_30_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_MAX_CURRENT_00_MAX_CUR_30_SHIFT))

#define  SDMMC3_2P_SD_MAX_CURRENT_00_MAX_CUR_33_MASK 0xff
#define  SDMMC3_2P_SD_MAX_CURRENT_00_MAX_CUR_33_SHIFT 0
#define  SDMMC3_2P_SD_MAX_CURRENT_00_MAX_CUR_33_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_MAX_CURRENT_00_MAX_CUR_33_MASK) >> SDMMC3_2P_SD_MAX_CURRENT_00_MAX_CUR_33_SHIFT)
#define  SDMMC3_2P_SD_MAX_CURRENT_00_MAX_CUR_33_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_MAX_CURRENT_00_MAX_CUR_33_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_MAX_CURRENT_00_MAX_CUR_33_SHIFT))

//====================================================================
//Register: Maximum Current Register 0 (Instance 2 of 2) (SD_MAX_CURRENT_01)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_MAX_CURRENT_01_MAX_CUR_30_MASK 0xff00
#define  SDMMC3_2P_SD_MAX_CURRENT_01_MAX_CUR_30_SHIFT 8
#define  SDMMC3_2P_SD_MAX_CURRENT_01_MAX_CUR_30_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_MAX_CURRENT_01_MAX_CUR_30_MASK) >> SDMMC3_2P_SD_MAX_CURRENT_01_MAX_CUR_30_SHIFT)
#define  SDMMC3_2P_SD_MAX_CURRENT_01_MAX_CUR_30_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_MAX_CURRENT_01_MAX_CUR_30_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_MAX_CURRENT_01_MAX_CUR_30_SHIFT))

#define  SDMMC3_2P_SD_MAX_CURRENT_01_MAX_CUR_33_MASK 0xff
#define  SDMMC3_2P_SD_MAX_CURRENT_01_MAX_CUR_33_SHIFT 0
#define  SDMMC3_2P_SD_MAX_CURRENT_01_MAX_CUR_33_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_MAX_CURRENT_01_MAX_CUR_33_MASK) >> SDMMC3_2P_SD_MAX_CURRENT_01_MAX_CUR_33_SHIFT)
#define  SDMMC3_2P_SD_MAX_CURRENT_01_MAX_CUR_33_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_MAX_CURRENT_01_MAX_CUR_33_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_MAX_CURRENT_01_MAX_CUR_33_SHIFT))

//====================================================================
//Register: Maximum Current Register 1 (Instance 1 of 2) (SD_MAX_CURRENT_10)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_MAX_CURRENT_10_RESERVED2_MASK 0xff00
#define  SDMMC3_2P_SD_MAX_CURRENT_10_RESERVED2_SHIFT 8
#define  SDMMC3_2P_SD_MAX_CURRENT_10_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_MAX_CURRENT_10_RESERVED2_MASK) >> SDMMC3_2P_SD_MAX_CURRENT_10_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_MAX_CURRENT_10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_MAX_CURRENT_10_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_MAX_CURRENT_10_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_MAX_CURRENT_10_MAX_CUR_18_MASK 0xff
#define  SDMMC3_2P_SD_MAX_CURRENT_10_MAX_CUR_18_SHIFT 0
#define  SDMMC3_2P_SD_MAX_CURRENT_10_MAX_CUR_18_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_MAX_CURRENT_10_MAX_CUR_18_MASK) >> SDMMC3_2P_SD_MAX_CURRENT_10_MAX_CUR_18_SHIFT)
#define  SDMMC3_2P_SD_MAX_CURRENT_10_MAX_CUR_18_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_MAX_CURRENT_10_MAX_CUR_18_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_MAX_CURRENT_10_MAX_CUR_18_SHIFT))

//====================================================================
//Register: Maximum Current Register 1 (Instance 2 of 2) (SD_MAX_CURRENT_11)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_MAX_CURRENT_11_RESERVED2_MASK 0xff00
#define  SDMMC3_2P_SD_MAX_CURRENT_11_RESERVED2_SHIFT 8
#define  SDMMC3_2P_SD_MAX_CURRENT_11_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_MAX_CURRENT_11_RESERVED2_MASK) >> SDMMC3_2P_SD_MAX_CURRENT_11_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_MAX_CURRENT_11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_MAX_CURRENT_11_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_MAX_CURRENT_11_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_MAX_CURRENT_11_MAX_CUR_18_MASK 0xff
#define  SDMMC3_2P_SD_MAX_CURRENT_11_MAX_CUR_18_SHIFT 0
#define  SDMMC3_2P_SD_MAX_CURRENT_11_MAX_CUR_18_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_MAX_CURRENT_11_MAX_CUR_18_MASK) >> SDMMC3_2P_SD_MAX_CURRENT_11_MAX_CUR_18_SHIFT)
#define  SDMMC3_2P_SD_MAX_CURRENT_11_MAX_CUR_18_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_MAX_CURRENT_11_MAX_CUR_18_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_MAX_CURRENT_11_MAX_CUR_18_SHIFT))

//====================================================================
//Register: Maximum Current Register 2 (Instance 1 of 2) (SD_MAX_CURRENT_20)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_MAX_CURRENT_20_RESERVED2_MASK 0xffff
#define  SDMMC3_2P_SD_MAX_CURRENT_20_RESERVED2_SHIFT 0
#define  SDMMC3_2P_SD_MAX_CURRENT_20_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_MAX_CURRENT_20_RESERVED2_MASK) >> SDMMC3_2P_SD_MAX_CURRENT_20_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_MAX_CURRENT_20_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_MAX_CURRENT_20_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_MAX_CURRENT_20_RESERVED2_SHIFT))

//====================================================================
//Register: Maximum Current Register 2 (Instance 2 of 2) (SD_MAX_CURRENT_21)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_MAX_CURRENT_21_RESERVED2_MASK 0xffff
#define  SDMMC3_2P_SD_MAX_CURRENT_21_RESERVED2_SHIFT 0
#define  SDMMC3_2P_SD_MAX_CURRENT_21_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_MAX_CURRENT_21_RESERVED2_MASK) >> SDMMC3_2P_SD_MAX_CURRENT_21_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_MAX_CURRENT_21_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_MAX_CURRENT_21_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_MAX_CURRENT_21_RESERVED2_SHIFT))

//====================================================================
//Register: Maximum Current Register 3 (Instance 1 of 2) (SD_MAX_CURRENT_30)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_MAX_CURRENT_30_RESERVED2_MASK 0xffff
#define  SDMMC3_2P_SD_MAX_CURRENT_30_RESERVED2_SHIFT 0
#define  SDMMC3_2P_SD_MAX_CURRENT_30_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_MAX_CURRENT_30_RESERVED2_MASK) >> SDMMC3_2P_SD_MAX_CURRENT_30_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_MAX_CURRENT_30_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_MAX_CURRENT_30_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_MAX_CURRENT_30_RESERVED2_SHIFT))

//====================================================================
//Register: Maximum Current Register 3 (Instance 2 of 2) (SD_MAX_CURRENT_31)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_MAX_CURRENT_31_RESERVED2_MASK 0xffff
#define  SDMMC3_2P_SD_MAX_CURRENT_31_RESERVED2_SHIFT 0
#define  SDMMC3_2P_SD_MAX_CURRENT_31_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_MAX_CURRENT_31_RESERVED2_MASK) >> SDMMC3_2P_SD_MAX_CURRENT_31_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_MAX_CURRENT_31_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_MAX_CURRENT_31_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_MAX_CURRENT_31_RESERVED2_SHIFT))

//====================================================================
//Register: Force Event Auto cmd12 Error Register (Instance 1 of 2) (SD_FORCE_EVENT_AUTO_CMD12_ERROR0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_RESERVED2_MASK 0xff00
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_RESERVED2_SHIFT 8
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_RESERVED2_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_ISSUE_ERR_MASK 0x80
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_ISSUE_ERR_SHIFT 7
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_ISSUE_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_ISSUE_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_ISSUE_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_ISSUE_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_ISSUE_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_ISSUE_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_RESERVED3_MASK 0x60
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_RESERVED3_SHIFT 5
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_RESERVED3_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_INDEX_ERR_MASK 0x10
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_INDEX_ERR_SHIFT 4
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_INDEX_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_INDEX_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_INDEX_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_INDEX_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_INDEX_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_INDEX_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_EBIT_ERR_MASK 0x8
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_EBIT_ERR_SHIFT 3
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_EBIT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_EBIT_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_EBIT_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_EBIT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_EBIT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_EBIT_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_CRC_ERR_MASK 0x4
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_CRC_ERR_SHIFT 2
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_CRC_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_CRC_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_CRC_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_CRC_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_CRC_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_CRC_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_TO_ERR_MASK 0x2
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_TO_ERR_SHIFT 1
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_TO_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_TO_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_TO_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_TO_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_TO_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_TO_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_NEXE_ERR_MASK 0x1
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_NEXE_ERR_SHIFT 0
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_NEXE_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_NEXE_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_NEXE_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_NEXE_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_NEXE_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR0_F_ACMD12_NEXE_ERR_SHIFT))

//====================================================================
//Register: Force Event Auto cmd12 Error Register (Instance 2 of 2) (SD_FORCE_EVENT_AUTO_CMD12_ERROR1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_RESERVED2_MASK 0xff00
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_RESERVED2_SHIFT 8
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_RESERVED2_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_ISSUE_ERR_MASK 0x80
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_ISSUE_ERR_SHIFT 7
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_ISSUE_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_ISSUE_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_ISSUE_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_ISSUE_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_ISSUE_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_ISSUE_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_RESERVED3_MASK 0x60
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_RESERVED3_SHIFT 5
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_RESERVED3_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_INDEX_ERR_MASK 0x10
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_INDEX_ERR_SHIFT 4
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_INDEX_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_INDEX_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_INDEX_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_INDEX_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_INDEX_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_INDEX_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_EBIT_ERR_MASK 0x8
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_EBIT_ERR_SHIFT 3
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_EBIT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_EBIT_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_EBIT_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_EBIT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_EBIT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_EBIT_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_CRC_ERR_MASK 0x4
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_CRC_ERR_SHIFT 2
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_CRC_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_CRC_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_CRC_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_CRC_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_CRC_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_CRC_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_TO_ERR_MASK 0x2
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_TO_ERR_SHIFT 1
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_TO_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_TO_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_TO_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_TO_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_TO_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_TO_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_NEXE_ERR_MASK 0x1
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_NEXE_ERR_SHIFT 0
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_NEXE_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_NEXE_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_NEXE_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_NEXE_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_NEXE_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_AUTO_CMD12_ERROR1_F_ACMD12_NEXE_ERR_SHIFT))

//====================================================================
//Register: Force Event for Error Status Register (Instance 1 of 2) (SD_FORCE_EVENT_FOR_ERROR_STATUS0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CRC_STATUS_ERR_MASK 0x8000
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CRC_STATUS_ERR_SHIFT 15
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CRC_STATUS_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CRC_STATUS_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CRC_STATUS_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CRC_STATUS_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CRC_STATUS_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CRC_STATUS_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CPL_TIMEOUT_ERR_MASK 0x4000
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CPL_TIMEOUT_ERR_SHIFT 14
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CPL_TIMEOUT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CPL_TIMEOUT_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CPL_TIMEOUT_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CPL_TIMEOUT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CPL_TIMEOUT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CPL_TIMEOUT_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_AXI_RESP_ERR_MASK 0x2000
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_AXI_RESP_ERR_SHIFT 13
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_AXI_RESP_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_AXI_RESP_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_AXI_RESP_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_AXI_RESP_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_AXI_RESP_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_AXI_RESP_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_SPI_ERR_MASK 0x1000
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_SPI_ERR_SHIFT 12
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_SPI_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_SPI_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_SPI_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_SPI_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_SPI_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_SPI_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_RESERVED2_MASK 0xc00
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_RESERVED2_SHIFT 10
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_RESERVED2_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_ADMA_ERR_MASK 0x200
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_ADMA_ERR_SHIFT 9
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_ADMA_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_ADMA_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_ADMA_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_ADMA_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_ADMA_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_ADMA_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_ACMD12_ERR_MASK 0x100
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_ACMD12_ERR_SHIFT 8
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_ACMD12_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_ACMD12_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_ACMD12_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_ACMD12_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_ACMD12_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_ACMD12_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CURRENT_ERR_MASK 0x80
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CURRENT_ERR_SHIFT 7
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CURRENT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CURRENT_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CURRENT_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CURRENT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CURRENT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CURRENT_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_DAT_END_BIT_ERR_MASK 0x40
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_DAT_END_BIT_ERR_SHIFT 6
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_DAT_END_BIT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_DAT_END_BIT_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_DAT_END_BIT_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_DAT_END_BIT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_DAT_END_BIT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_DAT_END_BIT_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_DAT_CRC_ERR_MASK 0x20
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_DAT_CRC_ERR_SHIFT 5
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_DAT_CRC_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_DAT_CRC_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_DAT_CRC_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_DAT_CRC_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_DAT_CRC_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_DAT_CRC_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_DAT_TO_ERR_MASK 0x10
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_DAT_TO_ERR_SHIFT 4
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_DAT_TO_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_DAT_TO_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_DAT_TO_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_DAT_TO_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_DAT_TO_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_DAT_TO_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_INDEX_ERR_MASK 0x8
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_INDEX_ERR_SHIFT 3
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_INDEX_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_INDEX_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_INDEX_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_INDEX_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_INDEX_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_INDEX_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_END_BIT_ERR_MASK 0x4
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_END_BIT_ERR_SHIFT 2
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_END_BIT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_END_BIT_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_END_BIT_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_END_BIT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_END_BIT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_END_BIT_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_CRC_ERR_MASK 0x2
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_CRC_ERR_SHIFT 1
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_CRC_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_CRC_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_CRC_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_CRC_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_CRC_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_CRC_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_TO_ERR_MASK 0x1
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_TO_ERR_SHIFT 0
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_TO_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_TO_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_TO_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_TO_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_TO_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS0_F_CMD_TO_ERR_SHIFT))

//====================================================================
//Register: Force Event for Error Status Register (Instance 2 of 2) (SD_FORCE_EVENT_FOR_ERROR_STATUS1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CRC_STATUS_ERR_MASK 0x8000
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CRC_STATUS_ERR_SHIFT 15
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CRC_STATUS_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CRC_STATUS_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CRC_STATUS_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CRC_STATUS_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CRC_STATUS_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CRC_STATUS_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CPL_TIMEOUT_ERR_MASK 0x4000
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CPL_TIMEOUT_ERR_SHIFT 14
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CPL_TIMEOUT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CPL_TIMEOUT_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CPL_TIMEOUT_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CPL_TIMEOUT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CPL_TIMEOUT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CPL_TIMEOUT_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_AXI_RESP_ERR_MASK 0x2000
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_AXI_RESP_ERR_SHIFT 13
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_AXI_RESP_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_AXI_RESP_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_AXI_RESP_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_AXI_RESP_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_AXI_RESP_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_AXI_RESP_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_SPI_ERR_MASK 0x1000
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_SPI_ERR_SHIFT 12
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_SPI_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_SPI_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_SPI_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_SPI_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_SPI_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_SPI_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_RESERVED2_MASK 0xc00
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_RESERVED2_SHIFT 10
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_RESERVED2_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_ADMA_ERR_MASK 0x200
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_ADMA_ERR_SHIFT 9
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_ADMA_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_ADMA_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_ADMA_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_ADMA_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_ADMA_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_ADMA_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_ACMD12_ERR_MASK 0x100
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_ACMD12_ERR_SHIFT 8
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_ACMD12_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_ACMD12_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_ACMD12_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_ACMD12_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_ACMD12_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_ACMD12_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CURRENT_ERR_MASK 0x80
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CURRENT_ERR_SHIFT 7
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CURRENT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CURRENT_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CURRENT_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CURRENT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CURRENT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CURRENT_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_DAT_END_BIT_ERR_MASK 0x40
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_DAT_END_BIT_ERR_SHIFT 6
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_DAT_END_BIT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_DAT_END_BIT_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_DAT_END_BIT_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_DAT_END_BIT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_DAT_END_BIT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_DAT_END_BIT_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_DAT_CRC_ERR_MASK 0x20
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_DAT_CRC_ERR_SHIFT 5
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_DAT_CRC_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_DAT_CRC_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_DAT_CRC_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_DAT_CRC_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_DAT_CRC_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_DAT_CRC_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_DAT_TO_ERR_MASK 0x10
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_DAT_TO_ERR_SHIFT 4
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_DAT_TO_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_DAT_TO_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_DAT_TO_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_DAT_TO_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_DAT_TO_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_DAT_TO_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_INDEX_ERR_MASK 0x8
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_INDEX_ERR_SHIFT 3
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_INDEX_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_INDEX_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_INDEX_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_INDEX_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_INDEX_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_INDEX_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_END_BIT_ERR_MASK 0x4
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_END_BIT_ERR_SHIFT 2
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_END_BIT_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_END_BIT_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_END_BIT_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_END_BIT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_END_BIT_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_END_BIT_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_CRC_ERR_MASK 0x2
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_CRC_ERR_SHIFT 1
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_CRC_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_CRC_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_CRC_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_CRC_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_CRC_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_CRC_ERR_SHIFT))

#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_TO_ERR_MASK 0x1
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_TO_ERR_SHIFT 0
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_TO_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_TO_ERR_MASK) >> SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_TO_ERR_SHIFT)
#define  SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_TO_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_TO_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FORCE_EVENT_FOR_ERROR_STATUS1_F_CMD_TO_ERR_SHIFT))

//====================================================================
//Register: ADMA Error Status Register (Instance 1 of 2) (SD_ADMA_ERROR_STATUS0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_ADMA_ERROR_STATUS0_RESERVED2_MASK 0xfff8
#define  SDMMC3_2P_SD_ADMA_ERROR_STATUS0_RESERVED2_SHIFT 3
#define  SDMMC3_2P_SD_ADMA_ERROR_STATUS0_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ADMA_ERROR_STATUS0_RESERVED2_MASK) >> SDMMC3_2P_SD_ADMA_ERROR_STATUS0_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_ADMA_ERROR_STATUS0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ADMA_ERROR_STATUS0_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ADMA_ERROR_STATUS0_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_ADMA_ERROR_STATUS0_ADMA_LEN_ERR_MASK 0x4
#define  SDMMC3_2P_SD_ADMA_ERROR_STATUS0_ADMA_LEN_ERR_SHIFT 2
#define  SDMMC3_2P_SD_ADMA_ERROR_STATUS0_ADMA_LEN_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ADMA_ERROR_STATUS0_ADMA_LEN_ERR_MASK) >> SDMMC3_2P_SD_ADMA_ERROR_STATUS0_ADMA_LEN_ERR_SHIFT)
#define  SDMMC3_2P_SD_ADMA_ERROR_STATUS0_ADMA_LEN_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ADMA_ERROR_STATUS0_ADMA_LEN_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ADMA_ERROR_STATUS0_ADMA_LEN_ERR_SHIFT))

#define  SDMMC3_2P_SD_ADMA_ERROR_STATUS0_ADMA_STATE_MASK 0x3
#define  SDMMC3_2P_SD_ADMA_ERROR_STATUS0_ADMA_STATE_SHIFT 0
#define  SDMMC3_2P_SD_ADMA_ERROR_STATUS0_ADMA_STATE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ADMA_ERROR_STATUS0_ADMA_STATE_MASK) >> SDMMC3_2P_SD_ADMA_ERROR_STATUS0_ADMA_STATE_SHIFT)
#define  SDMMC3_2P_SD_ADMA_ERROR_STATUS0_ADMA_STATE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ADMA_ERROR_STATUS0_ADMA_STATE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ADMA_ERROR_STATUS0_ADMA_STATE_SHIFT))

//====================================================================
//Register: ADMA Error Status Register (Instance 2 of 2) (SD_ADMA_ERROR_STATUS1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_ADMA_ERROR_STATUS1_RESERVED2_MASK 0xfff8
#define  SDMMC3_2P_SD_ADMA_ERROR_STATUS1_RESERVED2_SHIFT 3
#define  SDMMC3_2P_SD_ADMA_ERROR_STATUS1_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ADMA_ERROR_STATUS1_RESERVED2_MASK) >> SDMMC3_2P_SD_ADMA_ERROR_STATUS1_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_ADMA_ERROR_STATUS1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ADMA_ERROR_STATUS1_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ADMA_ERROR_STATUS1_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_ADMA_ERROR_STATUS1_ADMA_LEN_ERR_MASK 0x4
#define  SDMMC3_2P_SD_ADMA_ERROR_STATUS1_ADMA_LEN_ERR_SHIFT 2
#define  SDMMC3_2P_SD_ADMA_ERROR_STATUS1_ADMA_LEN_ERR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ADMA_ERROR_STATUS1_ADMA_LEN_ERR_MASK) >> SDMMC3_2P_SD_ADMA_ERROR_STATUS1_ADMA_LEN_ERR_SHIFT)
#define  SDMMC3_2P_SD_ADMA_ERROR_STATUS1_ADMA_LEN_ERR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ADMA_ERROR_STATUS1_ADMA_LEN_ERR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ADMA_ERROR_STATUS1_ADMA_LEN_ERR_SHIFT))

#define  SDMMC3_2P_SD_ADMA_ERROR_STATUS1_ADMA_STATE_MASK 0x3
#define  SDMMC3_2P_SD_ADMA_ERROR_STATUS1_ADMA_STATE_SHIFT 0
#define  SDMMC3_2P_SD_ADMA_ERROR_STATUS1_ADMA_STATE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ADMA_ERROR_STATUS1_ADMA_STATE_MASK) >> SDMMC3_2P_SD_ADMA_ERROR_STATUS1_ADMA_STATE_SHIFT)
#define  SDMMC3_2P_SD_ADMA_ERROR_STATUS1_ADMA_STATE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ADMA_ERROR_STATUS1_ADMA_STATE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ADMA_ERROR_STATUS1_ADMA_STATE_SHIFT))

//====================================================================
//Register: ADMA System Address Register 0 (Instance 1 of 2) (SD_ADMA_SYS_ADDR_00)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_00_ADMA_SYS_ADDR_MASK 0xffff
#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_00_ADMA_SYS_ADDR_SHIFT 0
#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_00_ADMA_SYS_ADDR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ADMA_SYS_ADDR_00_ADMA_SYS_ADDR_MASK) >> SDMMC3_2P_SD_ADMA_SYS_ADDR_00_ADMA_SYS_ADDR_SHIFT)
#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_00_ADMA_SYS_ADDR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ADMA_SYS_ADDR_00_ADMA_SYS_ADDR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ADMA_SYS_ADDR_00_ADMA_SYS_ADDR_SHIFT))

//====================================================================
//Register: ADMA System Address Register 0 (Instance 2 of 2) (SD_ADMA_SYS_ADDR_01)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_01_ADMA_SYS_ADDR_MASK 0xffff
#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_01_ADMA_SYS_ADDR_SHIFT 0
#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_01_ADMA_SYS_ADDR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ADMA_SYS_ADDR_01_ADMA_SYS_ADDR_MASK) >> SDMMC3_2P_SD_ADMA_SYS_ADDR_01_ADMA_SYS_ADDR_SHIFT)
#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_01_ADMA_SYS_ADDR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ADMA_SYS_ADDR_01_ADMA_SYS_ADDR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ADMA_SYS_ADDR_01_ADMA_SYS_ADDR_SHIFT))

//====================================================================
//Register: ADMA System Address Register 1 (Instance 1 of 2) (SD_ADMA_SYS_ADDR_10)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_10_ADMA_SYS_ADDR_MASK 0xffff
#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_10_ADMA_SYS_ADDR_SHIFT 0
#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_10_ADMA_SYS_ADDR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ADMA_SYS_ADDR_10_ADMA_SYS_ADDR_MASK) >> SDMMC3_2P_SD_ADMA_SYS_ADDR_10_ADMA_SYS_ADDR_SHIFT)
#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_10_ADMA_SYS_ADDR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ADMA_SYS_ADDR_10_ADMA_SYS_ADDR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ADMA_SYS_ADDR_10_ADMA_SYS_ADDR_SHIFT))

//====================================================================
//Register: ADMA System Address Register 1 (Instance 2 of 2) (SD_ADMA_SYS_ADDR_11)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_11_ADMA_SYS_ADDR_MASK 0xffff
#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_11_ADMA_SYS_ADDR_SHIFT 0
#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_11_ADMA_SYS_ADDR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ADMA_SYS_ADDR_11_ADMA_SYS_ADDR_MASK) >> SDMMC3_2P_SD_ADMA_SYS_ADDR_11_ADMA_SYS_ADDR_SHIFT)
#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_11_ADMA_SYS_ADDR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ADMA_SYS_ADDR_11_ADMA_SYS_ADDR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ADMA_SYS_ADDR_11_ADMA_SYS_ADDR_SHIFT))

//====================================================================
//Register: ADMA System Address Register 2 (Instance 1 of 2) (SD_ADMA_SYS_ADDR_20)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_20_ADMA_SYS_ADDR_MASK 0xffff
#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_20_ADMA_SYS_ADDR_SHIFT 0
#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_20_ADMA_SYS_ADDR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ADMA_SYS_ADDR_20_ADMA_SYS_ADDR_MASK) >> SDMMC3_2P_SD_ADMA_SYS_ADDR_20_ADMA_SYS_ADDR_SHIFT)
#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_20_ADMA_SYS_ADDR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ADMA_SYS_ADDR_20_ADMA_SYS_ADDR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ADMA_SYS_ADDR_20_ADMA_SYS_ADDR_SHIFT))

//====================================================================
//Register: ADMA System Address Register 2 (Instance 2 of 2) (SD_ADMA_SYS_ADDR_21)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_21_ADMA_SYS_ADDR_MASK 0xffff
#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_21_ADMA_SYS_ADDR_SHIFT 0
#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_21_ADMA_SYS_ADDR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ADMA_SYS_ADDR_21_ADMA_SYS_ADDR_MASK) >> SDMMC3_2P_SD_ADMA_SYS_ADDR_21_ADMA_SYS_ADDR_SHIFT)
#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_21_ADMA_SYS_ADDR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ADMA_SYS_ADDR_21_ADMA_SYS_ADDR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ADMA_SYS_ADDR_21_ADMA_SYS_ADDR_SHIFT))

//====================================================================
//Register: ADMA System Address Register 3 (Instance 1 of 2) (SD_ADMA_SYS_ADDR_30)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_30_ADMA_SYS_ADDR_MASK 0xffff
#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_30_ADMA_SYS_ADDR_SHIFT 0
#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_30_ADMA_SYS_ADDR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ADMA_SYS_ADDR_30_ADMA_SYS_ADDR_MASK) >> SDMMC3_2P_SD_ADMA_SYS_ADDR_30_ADMA_SYS_ADDR_SHIFT)
#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_30_ADMA_SYS_ADDR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ADMA_SYS_ADDR_30_ADMA_SYS_ADDR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ADMA_SYS_ADDR_30_ADMA_SYS_ADDR_SHIFT))

//====================================================================
//Register: ADMA System Address Register 3 (Instance 2 of 2) (SD_ADMA_SYS_ADDR_31)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_31_ADMA_SYS_ADDR_MASK 0xffff
#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_31_ADMA_SYS_ADDR_SHIFT 0
#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_31_ADMA_SYS_ADDR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_ADMA_SYS_ADDR_31_ADMA_SYS_ADDR_MASK) >> SDMMC3_2P_SD_ADMA_SYS_ADDR_31_ADMA_SYS_ADDR_SHIFT)
#define  SDMMC3_2P_SD_ADMA_SYS_ADDR_31_ADMA_SYS_ADDR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_ADMA_SYS_ADDR_31_ADMA_SYS_ADDR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_ADMA_SYS_ADDR_31_ADMA_SYS_ADDR_SHIFT))

//====================================================================
//Register: Preset Value Regiser for Initialization (Instance 1 of 2) (SD_PRESET_VALUE_FOR_INIT0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_DRV_STRENGTH_VAL_MASK 0xc000
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_DRV_STRENGTH_VAL_SHIFT 14
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_DRV_STRENGTH_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_DRV_STRENGTH_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_DRV_STRENGTH_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_DRV_STRENGTH_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_DRV_STRENGTH_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_DRV_STRENGTH_VAL_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_RESERVED2_MASK 0x3800
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_RESERVED2_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_CLKGEN_SEL_VALUE_MASK 0x400
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_CLKGEN_SEL_VALUE_SHIFT 10
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_CLKGEN_SEL_VALUE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_CLKGEN_SEL_VALUE_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_CLKGEN_SEL_VALUE_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_CLKGEN_SEL_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_CLKGEN_SEL_VALUE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_CLKGEN_SEL_VALUE_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_SDCLK_FREQ_SEL_VAL_MASK 0x3ff
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_SDCLK_FREQ_SEL_VAL_SHIFT 0
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_SDCLK_FREQ_SEL_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_SDCLK_FREQ_SEL_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_SDCLK_FREQ_SEL_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_SDCLK_FREQ_SEL_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_SDCLK_FREQ_SEL_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT0_SDCLK_FREQ_SEL_VAL_SHIFT))

//====================================================================
//Register: Preset Value Regiser for Initialization (Instance 2 of 2) (SD_PRESET_VALUE_FOR_INIT1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_DRV_STRENGTH_VAL_MASK 0xc000
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_DRV_STRENGTH_VAL_SHIFT 14
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_DRV_STRENGTH_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_DRV_STRENGTH_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_DRV_STRENGTH_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_DRV_STRENGTH_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_DRV_STRENGTH_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_DRV_STRENGTH_VAL_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_RESERVED2_MASK 0x3800
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_RESERVED2_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_CLKGEN_SEL_VALUE_MASK 0x400
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_CLKGEN_SEL_VALUE_SHIFT 10
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_CLKGEN_SEL_VALUE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_CLKGEN_SEL_VALUE_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_CLKGEN_SEL_VALUE_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_CLKGEN_SEL_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_CLKGEN_SEL_VALUE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_CLKGEN_SEL_VALUE_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_SDCLK_FREQ_SEL_VAL_MASK 0x3ff
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_SDCLK_FREQ_SEL_VAL_SHIFT 0
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_SDCLK_FREQ_SEL_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_SDCLK_FREQ_SEL_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_SDCLK_FREQ_SEL_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_SDCLK_FREQ_SEL_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_SDCLK_FREQ_SEL_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_INIT1_SDCLK_FREQ_SEL_VAL_SHIFT))

//====================================================================
//Register: Preset Value Regiser for Default Speed (Instance 1 of 2) (SD_PRESET_VALUE_FOR_DS0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_DRV_STRENGTH_VAL_MASK 0xc000
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_DRV_STRENGTH_VAL_SHIFT 14
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_DRV_STRENGTH_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_DRV_STRENGTH_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_DRV_STRENGTH_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_DRV_STRENGTH_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_DRV_STRENGTH_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_DRV_STRENGTH_VAL_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_RESERVED2_MASK 0x3800
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_RESERVED2_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_CLKGEN_SEL_VALUE_MASK 0x400
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_CLKGEN_SEL_VALUE_SHIFT 10
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_CLKGEN_SEL_VALUE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_CLKGEN_SEL_VALUE_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_CLKGEN_SEL_VALUE_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_CLKGEN_SEL_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_CLKGEN_SEL_VALUE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_CLKGEN_SEL_VALUE_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_SDCLK_FREQ_SEL_VAL_MASK 0x3ff
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_SDCLK_FREQ_SEL_VAL_SHIFT 0
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_SDCLK_FREQ_SEL_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_SDCLK_FREQ_SEL_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_SDCLK_FREQ_SEL_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_SDCLK_FREQ_SEL_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_SDCLK_FREQ_SEL_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_DS0_SDCLK_FREQ_SEL_VAL_SHIFT))

//====================================================================
//Register: Preset Value Regiser for Default Speed (Instance 2 of 2) (SD_PRESET_VALUE_FOR_DS1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_DRV_STRENGTH_VAL_MASK 0xc000
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_DRV_STRENGTH_VAL_SHIFT 14
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_DRV_STRENGTH_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_DRV_STRENGTH_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_DRV_STRENGTH_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_DRV_STRENGTH_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_DRV_STRENGTH_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_DRV_STRENGTH_VAL_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_RESERVED2_MASK 0x3800
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_RESERVED2_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_CLKGEN_SEL_VALUE_MASK 0x400
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_CLKGEN_SEL_VALUE_SHIFT 10
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_CLKGEN_SEL_VALUE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_CLKGEN_SEL_VALUE_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_CLKGEN_SEL_VALUE_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_CLKGEN_SEL_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_CLKGEN_SEL_VALUE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_CLKGEN_SEL_VALUE_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_SDCLK_FREQ_SEL_VAL_MASK 0x3ff
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_SDCLK_FREQ_SEL_VAL_SHIFT 0
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_SDCLK_FREQ_SEL_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_SDCLK_FREQ_SEL_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_SDCLK_FREQ_SEL_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_SDCLK_FREQ_SEL_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_SDCLK_FREQ_SEL_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_DS1_SDCLK_FREQ_SEL_VAL_SHIFT))

//====================================================================
//Register: Preset Value Regiser for High Speed (Instance 1 of 2) (SD_PRESET_VALUE_FOR_HS0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_DRV_STRENGTH_VAL_MASK 0xc000
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_DRV_STRENGTH_VAL_SHIFT 14
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_DRV_STRENGTH_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_DRV_STRENGTH_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_DRV_STRENGTH_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_DRV_STRENGTH_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_DRV_STRENGTH_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_DRV_STRENGTH_VAL_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_RESERVED2_MASK 0x3800
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_RESERVED2_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_CLKGEN_SEL_VALUE_MASK 0x400
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_CLKGEN_SEL_VALUE_SHIFT 10
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_CLKGEN_SEL_VALUE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_CLKGEN_SEL_VALUE_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_CLKGEN_SEL_VALUE_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_CLKGEN_SEL_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_CLKGEN_SEL_VALUE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_CLKGEN_SEL_VALUE_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_SDCLK_FREQ_SEL_VAL_MASK 0x3ff
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_SDCLK_FREQ_SEL_VAL_SHIFT 0
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_SDCLK_FREQ_SEL_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_SDCLK_FREQ_SEL_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_SDCLK_FREQ_SEL_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_SDCLK_FREQ_SEL_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_SDCLK_FREQ_SEL_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_HS0_SDCLK_FREQ_SEL_VAL_SHIFT))

//====================================================================
//Register: Preset Value Regiser for High Speed (Instance 2 of 2) (SD_PRESET_VALUE_FOR_HS1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_DRV_STRENGTH_VAL_MASK 0xc000
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_DRV_STRENGTH_VAL_SHIFT 14
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_DRV_STRENGTH_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_DRV_STRENGTH_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_DRV_STRENGTH_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_DRV_STRENGTH_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_DRV_STRENGTH_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_DRV_STRENGTH_VAL_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_RESERVED2_MASK 0x3800
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_RESERVED2_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_CLKGEN_SEL_VALUE_MASK 0x400
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_CLKGEN_SEL_VALUE_SHIFT 10
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_CLKGEN_SEL_VALUE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_CLKGEN_SEL_VALUE_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_CLKGEN_SEL_VALUE_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_CLKGEN_SEL_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_CLKGEN_SEL_VALUE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_CLKGEN_SEL_VALUE_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_SDCLK_FREQ_SEL_VAL_MASK 0x3ff
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_SDCLK_FREQ_SEL_VAL_SHIFT 0
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_SDCLK_FREQ_SEL_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_SDCLK_FREQ_SEL_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_SDCLK_FREQ_SEL_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_SDCLK_FREQ_SEL_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_SDCLK_FREQ_SEL_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_HS1_SDCLK_FREQ_SEL_VAL_SHIFT))

//====================================================================
//Register: Preset Value Regiser for SDR12 (Instance 1 of 2) (SD_PRESET_VALUE_FOR_SDR120)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_DRV_STRENGTH_VAL_MASK 0xc000
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_DRV_STRENGTH_VAL_SHIFT 14
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_DRV_STRENGTH_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_DRV_STRENGTH_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_DRV_STRENGTH_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_DRV_STRENGTH_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_DRV_STRENGTH_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_DRV_STRENGTH_VAL_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_RESERVED2_MASK 0x3800
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_RESERVED2_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_CLKGEN_SEL_VALUE_MASK 0x400
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_CLKGEN_SEL_VALUE_SHIFT 10
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_CLKGEN_SEL_VALUE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_CLKGEN_SEL_VALUE_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_CLKGEN_SEL_VALUE_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_CLKGEN_SEL_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_CLKGEN_SEL_VALUE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_CLKGEN_SEL_VALUE_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_SDCLK_FREQ_SEL_VAL_MASK 0x3ff
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_SDCLK_FREQ_SEL_VAL_SHIFT 0
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_SDCLK_FREQ_SEL_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_SDCLK_FREQ_SEL_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_SDCLK_FREQ_SEL_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_SDCLK_FREQ_SEL_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_SDCLK_FREQ_SEL_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR120_SDCLK_FREQ_SEL_VAL_SHIFT))

//====================================================================
//Register: Preset Value Regiser for SDR12 (Instance 2 of 2) (SD_PRESET_VALUE_FOR_SDR121)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_DRV_STRENGTH_VAL_MASK 0xc000
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_DRV_STRENGTH_VAL_SHIFT 14
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_DRV_STRENGTH_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_DRV_STRENGTH_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_DRV_STRENGTH_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_DRV_STRENGTH_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_DRV_STRENGTH_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_DRV_STRENGTH_VAL_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_RESERVED2_MASK 0x3800
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_RESERVED2_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_CLKGEN_SEL_VALUE_MASK 0x400
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_CLKGEN_SEL_VALUE_SHIFT 10
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_CLKGEN_SEL_VALUE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_CLKGEN_SEL_VALUE_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_CLKGEN_SEL_VALUE_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_CLKGEN_SEL_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_CLKGEN_SEL_VALUE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_CLKGEN_SEL_VALUE_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_SDCLK_FREQ_SEL_VAL_MASK 0x3ff
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_SDCLK_FREQ_SEL_VAL_SHIFT 0
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_SDCLK_FREQ_SEL_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_SDCLK_FREQ_SEL_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_SDCLK_FREQ_SEL_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_SDCLK_FREQ_SEL_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_SDCLK_FREQ_SEL_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR121_SDCLK_FREQ_SEL_VAL_SHIFT))

//====================================================================
//Register: Preset Value Regiser for SDR25 (Instance 1 of 2) (SD_PRESET_VALUE_FOR_SDR250)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_DRV_STRENGTH_VAL_MASK 0xc000
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_DRV_STRENGTH_VAL_SHIFT 14
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_DRV_STRENGTH_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_DRV_STRENGTH_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_DRV_STRENGTH_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_DRV_STRENGTH_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_DRV_STRENGTH_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_DRV_STRENGTH_VAL_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_RESERVED2_MASK 0x3800
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_RESERVED2_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_CLKGEN_SEL_VALUE_MASK 0x400
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_CLKGEN_SEL_VALUE_SHIFT 10
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_CLKGEN_SEL_VALUE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_CLKGEN_SEL_VALUE_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_CLKGEN_SEL_VALUE_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_CLKGEN_SEL_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_CLKGEN_SEL_VALUE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_CLKGEN_SEL_VALUE_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_SDCLK_FREQ_SEL_VAL_MASK 0x3ff
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_SDCLK_FREQ_SEL_VAL_SHIFT 0
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_SDCLK_FREQ_SEL_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_SDCLK_FREQ_SEL_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_SDCLK_FREQ_SEL_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_SDCLK_FREQ_SEL_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_SDCLK_FREQ_SEL_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR250_SDCLK_FREQ_SEL_VAL_SHIFT))

//====================================================================
//Register: Preset Value Regiser for SDR25 (Instance 2 of 2) (SD_PRESET_VALUE_FOR_SDR251)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_DRV_STRENGTH_VAL_MASK 0xc000
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_DRV_STRENGTH_VAL_SHIFT 14
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_DRV_STRENGTH_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_DRV_STRENGTH_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_DRV_STRENGTH_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_DRV_STRENGTH_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_DRV_STRENGTH_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_DRV_STRENGTH_VAL_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_RESERVED2_MASK 0x3800
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_RESERVED2_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_CLKGEN_SEL_VALUE_MASK 0x400
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_CLKGEN_SEL_VALUE_SHIFT 10
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_CLKGEN_SEL_VALUE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_CLKGEN_SEL_VALUE_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_CLKGEN_SEL_VALUE_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_CLKGEN_SEL_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_CLKGEN_SEL_VALUE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_CLKGEN_SEL_VALUE_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_SDCLK_FREQ_SEL_VAL_MASK 0x3ff
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_SDCLK_FREQ_SEL_VAL_SHIFT 0
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_SDCLK_FREQ_SEL_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_SDCLK_FREQ_SEL_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_SDCLK_FREQ_SEL_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_SDCLK_FREQ_SEL_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_SDCLK_FREQ_SEL_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR251_SDCLK_FREQ_SEL_VAL_SHIFT))

//====================================================================
//Register: Preset Value Regiser for SDR50 (Instance 1 of 2) (SD_PRESET_VALUE_FOR_SDR500)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_DRV_STRENGTH_VAL_MASK 0xc000
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_DRV_STRENGTH_VAL_SHIFT 14
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_DRV_STRENGTH_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_DRV_STRENGTH_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_DRV_STRENGTH_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_DRV_STRENGTH_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_DRV_STRENGTH_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_DRV_STRENGTH_VAL_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_RESERVED2_MASK 0x3800
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_RESERVED2_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_CLKGEN_SEL_VALUE_MASK 0x400
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_CLKGEN_SEL_VALUE_SHIFT 10
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_CLKGEN_SEL_VALUE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_CLKGEN_SEL_VALUE_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_CLKGEN_SEL_VALUE_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_CLKGEN_SEL_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_CLKGEN_SEL_VALUE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_CLKGEN_SEL_VALUE_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_SDCLK_FREQ_SEL_VAL_MASK 0x3ff
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_SDCLK_FREQ_SEL_VAL_SHIFT 0
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_SDCLK_FREQ_SEL_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_SDCLK_FREQ_SEL_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_SDCLK_FREQ_SEL_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_SDCLK_FREQ_SEL_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_SDCLK_FREQ_SEL_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR500_SDCLK_FREQ_SEL_VAL_SHIFT))

//====================================================================
//Register: Preset Value Regiser for SDR50 (Instance 2 of 2) (SD_PRESET_VALUE_FOR_SDR501)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_DRV_STRENGTH_VAL_MASK 0xc000
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_DRV_STRENGTH_VAL_SHIFT 14
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_DRV_STRENGTH_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_DRV_STRENGTH_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_DRV_STRENGTH_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_DRV_STRENGTH_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_DRV_STRENGTH_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_DRV_STRENGTH_VAL_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_RESERVED2_MASK 0x3800
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_RESERVED2_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_CLKGEN_SEL_VALUE_MASK 0x400
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_CLKGEN_SEL_VALUE_SHIFT 10
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_CLKGEN_SEL_VALUE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_CLKGEN_SEL_VALUE_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_CLKGEN_SEL_VALUE_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_CLKGEN_SEL_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_CLKGEN_SEL_VALUE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_CLKGEN_SEL_VALUE_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_SDCLK_FREQ_SEL_VAL_MASK 0x3ff
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_SDCLK_FREQ_SEL_VAL_SHIFT 0
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_SDCLK_FREQ_SEL_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_SDCLK_FREQ_SEL_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_SDCLK_FREQ_SEL_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_SDCLK_FREQ_SEL_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_SDCLK_FREQ_SEL_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR501_SDCLK_FREQ_SEL_VAL_SHIFT))

//====================================================================
//Register: Preset Value Regiser for SDR104 (Instance 1 of 2) (SD_PRESET_VALUE_FOR_SDR1040)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_DRV_STRENGTH_VAL_MASK 0xc000
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_DRV_STRENGTH_VAL_SHIFT 14
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_DRV_STRENGTH_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_DRV_STRENGTH_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_DRV_STRENGTH_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_DRV_STRENGTH_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_DRV_STRENGTH_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_DRV_STRENGTH_VAL_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_RESERVED2_MASK 0x3800
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_RESERVED2_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_CLKGEN_SEL_VALUE_MASK 0x400
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_CLKGEN_SEL_VALUE_SHIFT 10
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_CLKGEN_SEL_VALUE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_CLKGEN_SEL_VALUE_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_CLKGEN_SEL_VALUE_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_CLKGEN_SEL_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_CLKGEN_SEL_VALUE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_CLKGEN_SEL_VALUE_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_SDCLK_FREQ_SEL_VAL_MASK 0x3ff
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_SDCLK_FREQ_SEL_VAL_SHIFT 0
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_SDCLK_FREQ_SEL_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_SDCLK_FREQ_SEL_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_SDCLK_FREQ_SEL_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_SDCLK_FREQ_SEL_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_SDCLK_FREQ_SEL_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1040_SDCLK_FREQ_SEL_VAL_SHIFT))

//====================================================================
//Register: Preset Value Regiser for SDR104 (Instance 2 of 2) (SD_PRESET_VALUE_FOR_SDR1041)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_DRV_STRENGTH_VAL_MASK 0xc000
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_DRV_STRENGTH_VAL_SHIFT 14
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_DRV_STRENGTH_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_DRV_STRENGTH_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_DRV_STRENGTH_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_DRV_STRENGTH_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_DRV_STRENGTH_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_DRV_STRENGTH_VAL_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_RESERVED2_MASK 0x3800
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_RESERVED2_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_CLKGEN_SEL_VALUE_MASK 0x400
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_CLKGEN_SEL_VALUE_SHIFT 10
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_CLKGEN_SEL_VALUE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_CLKGEN_SEL_VALUE_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_CLKGEN_SEL_VALUE_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_CLKGEN_SEL_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_CLKGEN_SEL_VALUE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_CLKGEN_SEL_VALUE_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_SDCLK_FREQ_SEL_VAL_MASK 0x3ff
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_SDCLK_FREQ_SEL_VAL_SHIFT 0
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_SDCLK_FREQ_SEL_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_SDCLK_FREQ_SEL_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_SDCLK_FREQ_SEL_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_SDCLK_FREQ_SEL_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_SDCLK_FREQ_SEL_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_SDR1041_SDCLK_FREQ_SEL_VAL_SHIFT))

//====================================================================
//Register: Preset Value Regiser for DDR50 (Instance 1 of 2) (SD_PRESET_VALUE_FOR_DDR500)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_DRV_STRENGTH_VAL_MASK 0xc000
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_DRV_STRENGTH_VAL_SHIFT 14
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_DRV_STRENGTH_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_DRV_STRENGTH_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_DRV_STRENGTH_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_DRV_STRENGTH_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_DRV_STRENGTH_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_DRV_STRENGTH_VAL_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_RESERVED2_MASK 0x3800
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_RESERVED2_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_CLKGEN_SEL_VALUE_MASK 0x400
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_CLKGEN_SEL_VALUE_SHIFT 10
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_CLKGEN_SEL_VALUE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_CLKGEN_SEL_VALUE_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_CLKGEN_SEL_VALUE_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_CLKGEN_SEL_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_CLKGEN_SEL_VALUE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_CLKGEN_SEL_VALUE_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_SDCLK_FREQ_SEL_VAL_MASK 0x3ff
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_SDCLK_FREQ_SEL_VAL_SHIFT 0
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_SDCLK_FREQ_SEL_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_SDCLK_FREQ_SEL_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_SDCLK_FREQ_SEL_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_SDCLK_FREQ_SEL_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_SDCLK_FREQ_SEL_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR500_SDCLK_FREQ_SEL_VAL_SHIFT))

//====================================================================
//Register: Preset Value Regiser for DDR50 (Instance 2 of 2) (SD_PRESET_VALUE_FOR_DDR501)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_DRV_STRENGTH_VAL_MASK 0xc000
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_DRV_STRENGTH_VAL_SHIFT 14
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_DRV_STRENGTH_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_DRV_STRENGTH_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_DRV_STRENGTH_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_DRV_STRENGTH_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_DRV_STRENGTH_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_DRV_STRENGTH_VAL_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_RESERVED2_MASK 0x3800
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_RESERVED2_SHIFT 11
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_RESERVED2_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_CLKGEN_SEL_VALUE_MASK 0x400
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_CLKGEN_SEL_VALUE_SHIFT 10
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_CLKGEN_SEL_VALUE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_CLKGEN_SEL_VALUE_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_CLKGEN_SEL_VALUE_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_CLKGEN_SEL_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_CLKGEN_SEL_VALUE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_CLKGEN_SEL_VALUE_SHIFT))

#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_SDCLK_FREQ_SEL_VAL_MASK 0x3ff
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_SDCLK_FREQ_SEL_VAL_SHIFT 0
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_SDCLK_FREQ_SEL_VAL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_SDCLK_FREQ_SEL_VAL_MASK) >> SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_SDCLK_FREQ_SEL_VAL_SHIFT)
#define  SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_SDCLK_FREQ_SEL_VAL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_SDCLK_FREQ_SEL_VAL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PRESET_VALUE_FOR_DDR501_SDCLK_FREQ_SEL_VAL_SHIFT))

//====================================================================
//Register: Shared Bus Control Register (Low) (Instance 1 of 2) (SD_SHARED_BUS_CTRL_LOW0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_RESERVED2_MASK 0x8000
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_RESERVED2_SHIFT 15
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_RESERVED2_MASK) >> SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_BUS_WIDTH_PRESET_MASK 0x7f00
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_BUS_WIDTH_PRESET_SHIFT 8
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_BUS_WIDTH_PRESET_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_BUS_WIDTH_PRESET_MASK) >> SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_BUS_WIDTH_PRESET_SHIFT)
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_BUS_WIDTH_PRESET_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_BUS_WIDTH_PRESET_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_BUS_WIDTH_PRESET_SHIFT))

#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_RESERVED3_MASK 0xc0
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_RESERVED3_SHIFT 6
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_RESERVED3_MASK) >> SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_NUM_INT_PINS_MASK 0x30
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_NUM_INT_PINS_SHIFT 4
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_NUM_INT_PINS_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_NUM_INT_PINS_MASK) >> SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_NUM_INT_PINS_SHIFT)
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_NUM_INT_PINS_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_NUM_INT_PINS_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_NUM_INT_PINS_SHIFT))

#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_RESERVED4_MASK 0x8
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_RESERVED4_SHIFT 3
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_RESERVED4_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_RESERVED4_MASK) >> SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_RESERVED4_SHIFT)
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_RESERVED4_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_RESERVED4_SHIFT))

#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_NUM_CLK_PINS_MASK 0x7
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_NUM_CLK_PINS_SHIFT 0
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_NUM_CLK_PINS_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_NUM_CLK_PINS_MASK) >> SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_NUM_CLK_PINS_SHIFT)
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_NUM_CLK_PINS_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_NUM_CLK_PINS_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW0_NUM_CLK_PINS_SHIFT))

//====================================================================
//Register: Shared Bus Control Register (Low) (Instance 2 of 2) (SD_SHARED_BUS_CTRL_LOW1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_RESERVED2_MASK 0x8000
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_RESERVED2_SHIFT 15
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_RESERVED2_MASK) >> SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_BUS_WIDTH_PRESET_MASK 0x7f00
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_BUS_WIDTH_PRESET_SHIFT 8
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_BUS_WIDTH_PRESET_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_BUS_WIDTH_PRESET_MASK) >> SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_BUS_WIDTH_PRESET_SHIFT)
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_BUS_WIDTH_PRESET_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_BUS_WIDTH_PRESET_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_BUS_WIDTH_PRESET_SHIFT))

#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_RESERVED3_MASK 0xc0
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_RESERVED3_SHIFT 6
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_RESERVED3_MASK) >> SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_NUM_INT_PINS_MASK 0x30
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_NUM_INT_PINS_SHIFT 4
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_NUM_INT_PINS_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_NUM_INT_PINS_MASK) >> SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_NUM_INT_PINS_SHIFT)
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_NUM_INT_PINS_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_NUM_INT_PINS_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_NUM_INT_PINS_SHIFT))

#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_RESERVED4_MASK 0x8
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_RESERVED4_SHIFT 3
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_RESERVED4_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_RESERVED4_MASK) >> SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_RESERVED4_SHIFT)
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_RESERVED4_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_RESERVED4_SHIFT))

#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_NUM_CLK_PINS_MASK 0x7
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_NUM_CLK_PINS_SHIFT 0
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_NUM_CLK_PINS_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_NUM_CLK_PINS_MASK) >> SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_NUM_CLK_PINS_SHIFT)
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_NUM_CLK_PINS_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_NUM_CLK_PINS_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SHARED_BUS_CTRL_LOW1_NUM_CLK_PINS_SHIFT))

//====================================================================
//Register: Shared Bus Control Register (High) (Instance 1 of 2) (SD_SHARED_BUS_CTRL_HIGH0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_RESERVED2_MASK 0x8000
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_RESERVED2_SHIFT 15
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_RESERVED2_MASK) >> SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_BEND_PWR_CTRL_MASK 0x7f00
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_BEND_PWR_CTRL_SHIFT 8
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_BEND_PWR_CTRL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_BEND_PWR_CTRL_MASK) >> SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_BEND_PWR_CTRL_SHIFT)
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_BEND_PWR_CTRL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_BEND_PWR_CTRL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_BEND_PWR_CTRL_SHIFT))

#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_RESERVED3_MASK 0x80
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_RESERVED3_SHIFT 7
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_RESERVED3_MASK) >> SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_INT_PIN_SEL_MASK 0x70
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_INT_PIN_SEL_SHIFT 4
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_INT_PIN_SEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_INT_PIN_SEL_MASK) >> SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_INT_PIN_SEL_SHIFT)
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_INT_PIN_SEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_INT_PIN_SEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_INT_PIN_SEL_SHIFT))

#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_RESERVED4_MASK 0x8
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_RESERVED4_SHIFT 3
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_RESERVED4_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_RESERVED4_MASK) >> SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_RESERVED4_SHIFT)
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_RESERVED4_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_RESERVED4_SHIFT))

#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_CLK_PIN_SEL_MASK 0x7
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_CLK_PIN_SEL_SHIFT 0
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_CLK_PIN_SEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_CLK_PIN_SEL_MASK) >> SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_CLK_PIN_SEL_SHIFT)
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_CLK_PIN_SEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_CLK_PIN_SEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH0_CLK_PIN_SEL_SHIFT))

//====================================================================
//Register: Shared Bus Control Register (High) (Instance 2 of 2) (SD_SHARED_BUS_CTRL_HIGH1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_RESERVED2_MASK 0x8000
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_RESERVED2_SHIFT 15
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_RESERVED2_MASK) >> SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_BEND_PWR_CTRL_MASK 0x7f00
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_BEND_PWR_CTRL_SHIFT 8
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_BEND_PWR_CTRL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_BEND_PWR_CTRL_MASK) >> SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_BEND_PWR_CTRL_SHIFT)
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_BEND_PWR_CTRL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_BEND_PWR_CTRL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_BEND_PWR_CTRL_SHIFT))

#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_RESERVED3_MASK 0x80
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_RESERVED3_SHIFT 7
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_RESERVED3_MASK) >> SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_INT_PIN_SEL_MASK 0x70
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_INT_PIN_SEL_SHIFT 4
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_INT_PIN_SEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_INT_PIN_SEL_MASK) >> SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_INT_PIN_SEL_SHIFT)
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_INT_PIN_SEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_INT_PIN_SEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_INT_PIN_SEL_SHIFT))

#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_RESERVED4_MASK 0x8
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_RESERVED4_SHIFT 3
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_RESERVED4_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_RESERVED4_MASK) >> SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_RESERVED4_SHIFT)
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_RESERVED4_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_RESERVED4_SHIFT))

#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_CLK_PIN_SEL_MASK 0x7
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_CLK_PIN_SEL_SHIFT 0
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_CLK_PIN_SEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_CLK_PIN_SEL_MASK) >> SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_CLK_PIN_SEL_SHIFT)
#define  SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_CLK_PIN_SEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_CLK_PIN_SEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SHARED_BUS_CTRL_HIGH1_CLK_PIN_SEL_SHIFT))

//====================================================================
//Register: Slot Interrupt Status Register (Instance 1 of 2) (SD_SLOT_INT_STATUS0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_SLOT_INT_STATUS0_RESERVED2_MASK 0xfffc
#define  SDMMC3_2P_SD_SLOT_INT_STATUS0_RESERVED2_SHIFT 2
#define  SDMMC3_2P_SD_SLOT_INT_STATUS0_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SLOT_INT_STATUS0_RESERVED2_MASK) >> SDMMC3_2P_SD_SLOT_INT_STATUS0_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_SLOT_INT_STATUS0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SLOT_INT_STATUS0_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SLOT_INT_STATUS0_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_SLOT_INT_STATUS0_SLOT_INT1_MASK 0x2
#define  SDMMC3_2P_SD_SLOT_INT_STATUS0_SLOT_INT1_SHIFT 1
#define  SDMMC3_2P_SD_SLOT_INT_STATUS0_SLOT_INT1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SLOT_INT_STATUS0_SLOT_INT1_MASK) >> SDMMC3_2P_SD_SLOT_INT_STATUS0_SLOT_INT1_SHIFT)
#define  SDMMC3_2P_SD_SLOT_INT_STATUS0_SLOT_INT1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SLOT_INT_STATUS0_SLOT_INT1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SLOT_INT_STATUS0_SLOT_INT1_SHIFT))

#define  SDMMC3_2P_SD_SLOT_INT_STATUS0_SLOT_INT0_MASK 0x1
#define  SDMMC3_2P_SD_SLOT_INT_STATUS0_SLOT_INT0_SHIFT 0
#define  SDMMC3_2P_SD_SLOT_INT_STATUS0_SLOT_INT0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SLOT_INT_STATUS0_SLOT_INT0_MASK) >> SDMMC3_2P_SD_SLOT_INT_STATUS0_SLOT_INT0_SHIFT)
#define  SDMMC3_2P_SD_SLOT_INT_STATUS0_SLOT_INT0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SLOT_INT_STATUS0_SLOT_INT0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SLOT_INT_STATUS0_SLOT_INT0_SHIFT))

//====================================================================
//Register: Slot Interrupt Status Register (Instance 2 of 2) (SD_SLOT_INT_STATUS1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_SLOT_INT_STATUS1_RESERVED2_MASK 0xfffc
#define  SDMMC3_2P_SD_SLOT_INT_STATUS1_RESERVED2_SHIFT 2
#define  SDMMC3_2P_SD_SLOT_INT_STATUS1_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SLOT_INT_STATUS1_RESERVED2_MASK) >> SDMMC3_2P_SD_SLOT_INT_STATUS1_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_SLOT_INT_STATUS1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SLOT_INT_STATUS1_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SLOT_INT_STATUS1_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_SLOT_INT_STATUS1_SLOT_INT1_MASK 0x2
#define  SDMMC3_2P_SD_SLOT_INT_STATUS1_SLOT_INT1_SHIFT 1
#define  SDMMC3_2P_SD_SLOT_INT_STATUS1_SLOT_INT1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SLOT_INT_STATUS1_SLOT_INT1_MASK) >> SDMMC3_2P_SD_SLOT_INT_STATUS1_SLOT_INT1_SHIFT)
#define  SDMMC3_2P_SD_SLOT_INT_STATUS1_SLOT_INT1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SLOT_INT_STATUS1_SLOT_INT1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SLOT_INT_STATUS1_SLOT_INT1_SHIFT))

#define  SDMMC3_2P_SD_SLOT_INT_STATUS1_SLOT_INT0_MASK 0x1
#define  SDMMC3_2P_SD_SLOT_INT_STATUS1_SLOT_INT0_SHIFT 0
#define  SDMMC3_2P_SD_SLOT_INT_STATUS1_SLOT_INT0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SLOT_INT_STATUS1_SLOT_INT0_MASK) >> SDMMC3_2P_SD_SLOT_INT_STATUS1_SLOT_INT0_SHIFT)
#define  SDMMC3_2P_SD_SLOT_INT_STATUS1_SLOT_INT0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SLOT_INT_STATUS1_SLOT_INT0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SLOT_INT_STATUS1_SLOT_INT0_SHIFT))

//====================================================================
//Register: Host Control Version Register (Instance 1 of 2) (SD_HOST_CTRL_VER0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_HOST_CTRL_VER0_VENDOR_VER_MASK 0xff00
#define  SDMMC3_2P_SD_HOST_CTRL_VER0_VENDOR_VER_SHIFT 8
#define  SDMMC3_2P_SD_HOST_CTRL_VER0_VENDOR_VER_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL_VER0_VENDOR_VER_MASK) >> SDMMC3_2P_SD_HOST_CTRL_VER0_VENDOR_VER_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL_VER0_VENDOR_VER_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL_VER0_VENDOR_VER_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL_VER0_VENDOR_VER_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL_VER0_SD_VER_MASK 0xff
#define  SDMMC3_2P_SD_HOST_CTRL_VER0_SD_VER_SHIFT 0
#define  SDMMC3_2P_SD_HOST_CTRL_VER0_SD_VER_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL_VER0_SD_VER_MASK) >> SDMMC3_2P_SD_HOST_CTRL_VER0_SD_VER_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL_VER0_SD_VER_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL_VER0_SD_VER_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL_VER0_SD_VER_SHIFT))

//====================================================================
//Register: Host Control Version Register (Instance 2 of 2) (SD_HOST_CTRL_VER1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_HOST_CTRL_VER1_VENDOR_VER_MASK 0xff00
#define  SDMMC3_2P_SD_HOST_CTRL_VER1_VENDOR_VER_SHIFT 8
#define  SDMMC3_2P_SD_HOST_CTRL_VER1_VENDOR_VER_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL_VER1_VENDOR_VER_MASK) >> SDMMC3_2P_SD_HOST_CTRL_VER1_VENDOR_VER_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL_VER1_VENDOR_VER_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL_VER1_VENDOR_VER_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL_VER1_VENDOR_VER_SHIFT))

#define  SDMMC3_2P_SD_HOST_CTRL_VER1_SD_VER_MASK 0xff
#define  SDMMC3_2P_SD_HOST_CTRL_VER1_SD_VER_SHIFT 0
#define  SDMMC3_2P_SD_HOST_CTRL_VER1_SD_VER_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_HOST_CTRL_VER1_SD_VER_MASK) >> SDMMC3_2P_SD_HOST_CTRL_VER1_SD_VER_SHIFT)
#define  SDMMC3_2P_SD_HOST_CTRL_VER1_SD_VER_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_HOST_CTRL_VER1_SD_VER_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_HOST_CTRL_VER1_SD_VER_SHIFT))

//====================================================================
//Register: SD Extra parameters Register (Low) (Instance 1 of 2) (SD_CFG_FIFO_PARAM_00)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_RESERVED2_MASK 0xff80
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_RESERVED2_SHIFT 7
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CFG_FIFO_PARAM_00_RESERVED2_MASK) >> SDMMC3_2P_SD_CFG_FIFO_PARAM_00_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CFG_FIFO_PARAM_00_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CFG_FIFO_PARAM_00_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_GEN_PAD_CLK_ON_MASK 0x40
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_GEN_PAD_CLK_ON_SHIFT 6
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_GEN_PAD_CLK_ON_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CFG_FIFO_PARAM_00_GEN_PAD_CLK_ON_MASK) >> SDMMC3_2P_SD_CFG_FIFO_PARAM_00_GEN_PAD_CLK_ON_SHIFT)
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_GEN_PAD_CLK_ON_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CFG_FIFO_PARAM_00_GEN_PAD_CLK_ON_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CFG_FIFO_PARAM_00_GEN_PAD_CLK_ON_SHIFT))

#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_SQU_FULL_CHK_MASK 0x20
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_SQU_FULL_CHK_SHIFT 5
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_SQU_FULL_CHK_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CFG_FIFO_PARAM_00_SQU_FULL_CHK_MASK) >> SDMMC3_2P_SD_CFG_FIFO_PARAM_00_SQU_FULL_CHK_SHIFT)
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_SQU_FULL_CHK_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CFG_FIFO_PARAM_00_SQU_FULL_CHK_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CFG_FIFO_PARAM_00_SQU_FULL_CHK_SHIFT))

#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_SQU_EMPTY_CHK_MASK 0x10
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_SQU_EMPTY_CHK_SHIFT 4
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_SQU_EMPTY_CHK_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CFG_FIFO_PARAM_00_SQU_EMPTY_CHK_MASK) >> SDMMC3_2P_SD_CFG_FIFO_PARAM_00_SQU_EMPTY_CHK_SHIFT)
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_SQU_EMPTY_CHK_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CFG_FIFO_PARAM_00_SQU_EMPTY_CHK_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CFG_FIFO_PARAM_00_SQU_EMPTY_CHK_SHIFT))

#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_BOOT_ACK_MASK 0x8
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_BOOT_ACK_SHIFT 3
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_BOOT_ACK_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CFG_FIFO_PARAM_00_BOOT_ACK_MASK) >> SDMMC3_2P_SD_CFG_FIFO_PARAM_00_BOOT_ACK_SHIFT)
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_BOOT_ACK_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CFG_FIFO_PARAM_00_BOOT_ACK_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CFG_FIFO_PARAM_00_BOOT_ACK_SHIFT))

#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_RESERVED3_MASK 0x6
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_RESERVED3_SHIFT 1
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CFG_FIFO_PARAM_00_RESERVED3_MASK) >> SDMMC3_2P_SD_CFG_FIFO_PARAM_00_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CFG_FIFO_PARAM_00_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CFG_FIFO_PARAM_00_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_PIO_RDFC_MASK 0x1
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_PIO_RDFC_SHIFT 0
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_PIO_RDFC_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CFG_FIFO_PARAM_00_PIO_RDFC_MASK) >> SDMMC3_2P_SD_CFG_FIFO_PARAM_00_PIO_RDFC_SHIFT)
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_00_PIO_RDFC_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CFG_FIFO_PARAM_00_PIO_RDFC_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CFG_FIFO_PARAM_00_PIO_RDFC_SHIFT))

//====================================================================
//Register: SD Extra parameters Register (Low) (Instance 2 of 2) (SD_CFG_FIFO_PARAM_01)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_RESERVED2_MASK 0xff80
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_RESERVED2_SHIFT 7
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CFG_FIFO_PARAM_01_RESERVED2_MASK) >> SDMMC3_2P_SD_CFG_FIFO_PARAM_01_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CFG_FIFO_PARAM_01_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CFG_FIFO_PARAM_01_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_GEN_PAD_CLK_ON_MASK 0x40
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_GEN_PAD_CLK_ON_SHIFT 6
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_GEN_PAD_CLK_ON_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CFG_FIFO_PARAM_01_GEN_PAD_CLK_ON_MASK) >> SDMMC3_2P_SD_CFG_FIFO_PARAM_01_GEN_PAD_CLK_ON_SHIFT)
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_GEN_PAD_CLK_ON_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CFG_FIFO_PARAM_01_GEN_PAD_CLK_ON_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CFG_FIFO_PARAM_01_GEN_PAD_CLK_ON_SHIFT))

#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_SQU_FULL_CHK_MASK 0x20
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_SQU_FULL_CHK_SHIFT 5
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_SQU_FULL_CHK_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CFG_FIFO_PARAM_01_SQU_FULL_CHK_MASK) >> SDMMC3_2P_SD_CFG_FIFO_PARAM_01_SQU_FULL_CHK_SHIFT)
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_SQU_FULL_CHK_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CFG_FIFO_PARAM_01_SQU_FULL_CHK_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CFG_FIFO_PARAM_01_SQU_FULL_CHK_SHIFT))

#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_SQU_EMPTY_CHK_MASK 0x10
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_SQU_EMPTY_CHK_SHIFT 4
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_SQU_EMPTY_CHK_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CFG_FIFO_PARAM_01_SQU_EMPTY_CHK_MASK) >> SDMMC3_2P_SD_CFG_FIFO_PARAM_01_SQU_EMPTY_CHK_SHIFT)
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_SQU_EMPTY_CHK_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CFG_FIFO_PARAM_01_SQU_EMPTY_CHK_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CFG_FIFO_PARAM_01_SQU_EMPTY_CHK_SHIFT))

#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_BOOT_ACK_MASK 0x8
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_BOOT_ACK_SHIFT 3
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_BOOT_ACK_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CFG_FIFO_PARAM_01_BOOT_ACK_MASK) >> SDMMC3_2P_SD_CFG_FIFO_PARAM_01_BOOT_ACK_SHIFT)
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_BOOT_ACK_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CFG_FIFO_PARAM_01_BOOT_ACK_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CFG_FIFO_PARAM_01_BOOT_ACK_SHIFT))

#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_RESERVED3_MASK 0x6
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_RESERVED3_SHIFT 1
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CFG_FIFO_PARAM_01_RESERVED3_MASK) >> SDMMC3_2P_SD_CFG_FIFO_PARAM_01_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CFG_FIFO_PARAM_01_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CFG_FIFO_PARAM_01_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_PIO_RDFC_MASK 0x1
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_PIO_RDFC_SHIFT 0
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_PIO_RDFC_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CFG_FIFO_PARAM_01_PIO_RDFC_MASK) >> SDMMC3_2P_SD_CFG_FIFO_PARAM_01_PIO_RDFC_SHIFT)
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_01_PIO_RDFC_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CFG_FIFO_PARAM_01_PIO_RDFC_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CFG_FIFO_PARAM_01_PIO_RDFC_SHIFT))

//====================================================================
//Register: SD Extra parameters Register (High) (Instance 1 of 2) (SD_CFG_FIFO_PARAM_10)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_10_GEN_PAD_CLK_CNT_MASK 0xff00
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_10_GEN_PAD_CLK_CNT_SHIFT 8
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_10_GEN_PAD_CLK_CNT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CFG_FIFO_PARAM_10_GEN_PAD_CLK_CNT_MASK) >> SDMMC3_2P_SD_CFG_FIFO_PARAM_10_GEN_PAD_CLK_CNT_SHIFT)
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_10_GEN_PAD_CLK_CNT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CFG_FIFO_PARAM_10_GEN_PAD_CLK_CNT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CFG_FIFO_PARAM_10_GEN_PAD_CLK_CNT_SHIFT))

#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_10_RESERVED2_MASK 0xff
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_10_RESERVED2_SHIFT 0
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_10_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CFG_FIFO_PARAM_10_RESERVED2_MASK) >> SDMMC3_2P_SD_CFG_FIFO_PARAM_10_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CFG_FIFO_PARAM_10_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CFG_FIFO_PARAM_10_RESERVED2_SHIFT))

//====================================================================
//Register: SD Extra parameters Register (High) (Instance 2 of 2) (SD_CFG_FIFO_PARAM_11)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_11_GEN_PAD_CLK_CNT_MASK 0xff00
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_11_GEN_PAD_CLK_CNT_SHIFT 8
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_11_GEN_PAD_CLK_CNT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CFG_FIFO_PARAM_11_GEN_PAD_CLK_CNT_MASK) >> SDMMC3_2P_SD_CFG_FIFO_PARAM_11_GEN_PAD_CLK_CNT_SHIFT)
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_11_GEN_PAD_CLK_CNT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CFG_FIFO_PARAM_11_GEN_PAD_CLK_CNT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CFG_FIFO_PARAM_11_GEN_PAD_CLK_CNT_SHIFT))

#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_11_RESERVED2_MASK 0xff
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_11_RESERVED2_SHIFT 0
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_11_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CFG_FIFO_PARAM_11_RESERVED2_MASK) >> SDMMC3_2P_SD_CFG_FIFO_PARAM_11_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_CFG_FIFO_PARAM_11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CFG_FIFO_PARAM_11_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CFG_FIFO_PARAM_11_RESERVED2_SHIFT))

//====================================================================
//Register: FIFO Parameters Register (LOW) (Instance 1 of 2) (SD_FIFO_PARAM_00)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_FIFO_PARAM_00_RESERVED2_MASK 0x8000
#define  SDMMC3_2P_SD_FIFO_PARAM_00_RESERVED2_SHIFT 15
#define  SDMMC3_2P_SD_FIFO_PARAM_00_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_00_RESERVED2_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_00_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_00_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_00_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_00_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_00_PDLVMC_MASK 0x4000
#define  SDMMC3_2P_SD_FIFO_PARAM_00_PDLVMC_SHIFT 14
#define  SDMMC3_2P_SD_FIFO_PARAM_00_PDLVMC_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_00_PDLVMC_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_00_PDLVMC_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_00_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_00_PDLVMC_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_00_PDLVMC_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_00_PDFVSSM_MASK 0x2000
#define  SDMMC3_2P_SD_FIFO_PARAM_00_PDFVSSM_SHIFT 13
#define  SDMMC3_2P_SD_FIFO_PARAM_00_PDFVSSM_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_00_PDFVSSM_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_00_PDFVSSM_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_00_PDFVSSM_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_00_PDFVSSM_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_00_PDFVSSM_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_00_FORCE_CLK_ON_MASK 0x1000
#define  SDMMC3_2P_SD_FIFO_PARAM_00_FORCE_CLK_ON_SHIFT 12
#define  SDMMC3_2P_SD_FIFO_PARAM_00_FORCE_CLK_ON_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_00_FORCE_CLK_ON_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_00_FORCE_CLK_ON_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_00_FORCE_CLK_ON_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_00_FORCE_CLK_ON_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_00_FORCE_CLK_ON_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_00_OVRRD_CLK_OEN_MASK 0x800
#define  SDMMC3_2P_SD_FIFO_PARAM_00_OVRRD_CLK_OEN_SHIFT 11
#define  SDMMC3_2P_SD_FIFO_PARAM_00_OVRRD_CLK_OEN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_00_OVRRD_CLK_OEN_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_00_OVRRD_CLK_OEN_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_00_OVRRD_CLK_OEN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_00_OVRRD_CLK_OEN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_00_OVRRD_CLK_OEN_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_00_RESERVED3_MASK 0x400
#define  SDMMC3_2P_SD_FIFO_PARAM_00_RESERVED3_SHIFT 10
#define  SDMMC3_2P_SD_FIFO_PARAM_00_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_00_RESERVED3_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_00_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_00_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_00_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_00_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_00_CLK_GATE_ON_MASK 0x200
#define  SDMMC3_2P_SD_FIFO_PARAM_00_CLK_GATE_ON_SHIFT 9
#define  SDMMC3_2P_SD_FIFO_PARAM_00_CLK_GATE_ON_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_00_CLK_GATE_ON_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_00_CLK_GATE_ON_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_00_CLK_GATE_ON_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_00_CLK_GATE_ON_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_00_CLK_GATE_ON_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_00_CLK_GATE_CTL_MASK 0x100
#define  SDMMC3_2P_SD_FIFO_PARAM_00_CLK_GATE_CTL_SHIFT 8
#define  SDMMC3_2P_SD_FIFO_PARAM_00_CLK_GATE_CTL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_00_CLK_GATE_CTL_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_00_CLK_GATE_CTL_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_00_CLK_GATE_CTL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_00_CLK_GATE_CTL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_00_CLK_GATE_CTL_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_00_USE_DAT3_MASK 0x80
#define  SDMMC3_2P_SD_FIFO_PARAM_00_USE_DAT3_SHIFT 7
#define  SDMMC3_2P_SD_FIFO_PARAM_00_USE_DAT3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_00_USE_DAT3_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_00_USE_DAT3_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_00_USE_DAT3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_00_USE_DAT3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_00_USE_DAT3_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_00_PDWN_MASK 0x40
#define  SDMMC3_2P_SD_FIFO_PARAM_00_PDWN_SHIFT 6
#define  SDMMC3_2P_SD_FIFO_PARAM_00_PDWN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_00_PDWN_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_00_PDWN_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_00_PDWN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_00_PDWN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_00_PDWN_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_00_FIFO_CS_MASK 0x20
#define  SDMMC3_2P_SD_FIFO_PARAM_00_FIFO_CS_SHIFT 5
#define  SDMMC3_2P_SD_FIFO_PARAM_00_FIFO_CS_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_00_FIFO_CS_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_00_FIFO_CS_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_00_FIFO_CS_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_00_FIFO_CS_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_00_FIFO_CS_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_00_FIFO_CLK_MASK 0x10
#define  SDMMC3_2P_SD_FIFO_PARAM_00_FIFO_CLK_SHIFT 4
#define  SDMMC3_2P_SD_FIFO_PARAM_00_FIFO_CLK_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_00_FIFO_CLK_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_00_FIFO_CLK_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_00_FIFO_CLK_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_00_FIFO_CLK_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_00_FIFO_CLK_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_00_WTC_MASK 0xc
#define  SDMMC3_2P_SD_FIFO_PARAM_00_WTC_SHIFT 2
#define  SDMMC3_2P_SD_FIFO_PARAM_00_WTC_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_00_WTC_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_00_WTC_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_00_WTC_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_00_WTC_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_00_WTC_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_00_RTC_MASK 0x3
#define  SDMMC3_2P_SD_FIFO_PARAM_00_RTC_SHIFT 0
#define  SDMMC3_2P_SD_FIFO_PARAM_00_RTC_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_00_RTC_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_00_RTC_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_00_RTC_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_00_RTC_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_00_RTC_SHIFT))

//====================================================================
//Register: FIFO Parameters Register (LOW) (Instance 2 of 2) (SD_FIFO_PARAM_01)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_FIFO_PARAM_01_RESERVED2_MASK 0x8000
#define  SDMMC3_2P_SD_FIFO_PARAM_01_RESERVED2_SHIFT 15
#define  SDMMC3_2P_SD_FIFO_PARAM_01_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_01_RESERVED2_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_01_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_01_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_01_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_01_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_01_PDLVMC_MASK 0x4000
#define  SDMMC3_2P_SD_FIFO_PARAM_01_PDLVMC_SHIFT 14
#define  SDMMC3_2P_SD_FIFO_PARAM_01_PDLVMC_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_01_PDLVMC_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_01_PDLVMC_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_01_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_01_PDLVMC_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_01_PDLVMC_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_01_PDFVSSM_MASK 0x2000
#define  SDMMC3_2P_SD_FIFO_PARAM_01_PDFVSSM_SHIFT 13
#define  SDMMC3_2P_SD_FIFO_PARAM_01_PDFVSSM_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_01_PDFVSSM_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_01_PDFVSSM_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_01_PDFVSSM_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_01_PDFVSSM_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_01_PDFVSSM_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_01_FORCE_CLK_ON_MASK 0x1000
#define  SDMMC3_2P_SD_FIFO_PARAM_01_FORCE_CLK_ON_SHIFT 12
#define  SDMMC3_2P_SD_FIFO_PARAM_01_FORCE_CLK_ON_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_01_FORCE_CLK_ON_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_01_FORCE_CLK_ON_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_01_FORCE_CLK_ON_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_01_FORCE_CLK_ON_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_01_FORCE_CLK_ON_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_01_OVRRD_CLK_OEN_MASK 0x800
#define  SDMMC3_2P_SD_FIFO_PARAM_01_OVRRD_CLK_OEN_SHIFT 11
#define  SDMMC3_2P_SD_FIFO_PARAM_01_OVRRD_CLK_OEN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_01_OVRRD_CLK_OEN_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_01_OVRRD_CLK_OEN_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_01_OVRRD_CLK_OEN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_01_OVRRD_CLK_OEN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_01_OVRRD_CLK_OEN_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_01_RESERVED3_MASK 0x400
#define  SDMMC3_2P_SD_FIFO_PARAM_01_RESERVED3_SHIFT 10
#define  SDMMC3_2P_SD_FIFO_PARAM_01_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_01_RESERVED3_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_01_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_01_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_01_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_01_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_01_CLK_GATE_ON_MASK 0x200
#define  SDMMC3_2P_SD_FIFO_PARAM_01_CLK_GATE_ON_SHIFT 9
#define  SDMMC3_2P_SD_FIFO_PARAM_01_CLK_GATE_ON_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_01_CLK_GATE_ON_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_01_CLK_GATE_ON_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_01_CLK_GATE_ON_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_01_CLK_GATE_ON_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_01_CLK_GATE_ON_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_01_CLK_GATE_CTL_MASK 0x100
#define  SDMMC3_2P_SD_FIFO_PARAM_01_CLK_GATE_CTL_SHIFT 8
#define  SDMMC3_2P_SD_FIFO_PARAM_01_CLK_GATE_CTL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_01_CLK_GATE_CTL_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_01_CLK_GATE_CTL_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_01_CLK_GATE_CTL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_01_CLK_GATE_CTL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_01_CLK_GATE_CTL_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_01_USE_DAT3_MASK 0x80
#define  SDMMC3_2P_SD_FIFO_PARAM_01_USE_DAT3_SHIFT 7
#define  SDMMC3_2P_SD_FIFO_PARAM_01_USE_DAT3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_01_USE_DAT3_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_01_USE_DAT3_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_01_USE_DAT3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_01_USE_DAT3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_01_USE_DAT3_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_01_PDWN_MASK 0x40
#define  SDMMC3_2P_SD_FIFO_PARAM_01_PDWN_SHIFT 6
#define  SDMMC3_2P_SD_FIFO_PARAM_01_PDWN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_01_PDWN_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_01_PDWN_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_01_PDWN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_01_PDWN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_01_PDWN_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_01_FIFO_CS_MASK 0x20
#define  SDMMC3_2P_SD_FIFO_PARAM_01_FIFO_CS_SHIFT 5
#define  SDMMC3_2P_SD_FIFO_PARAM_01_FIFO_CS_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_01_FIFO_CS_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_01_FIFO_CS_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_01_FIFO_CS_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_01_FIFO_CS_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_01_FIFO_CS_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_01_FIFO_CLK_MASK 0x10
#define  SDMMC3_2P_SD_FIFO_PARAM_01_FIFO_CLK_SHIFT 4
#define  SDMMC3_2P_SD_FIFO_PARAM_01_FIFO_CLK_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_01_FIFO_CLK_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_01_FIFO_CLK_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_01_FIFO_CLK_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_01_FIFO_CLK_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_01_FIFO_CLK_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_01_WTC_MASK 0xc
#define  SDMMC3_2P_SD_FIFO_PARAM_01_WTC_SHIFT 2
#define  SDMMC3_2P_SD_FIFO_PARAM_01_WTC_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_01_WTC_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_01_WTC_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_01_WTC_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_01_WTC_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_01_WTC_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_01_RTC_MASK 0x3
#define  SDMMC3_2P_SD_FIFO_PARAM_01_RTC_SHIFT 0
#define  SDMMC3_2P_SD_FIFO_PARAM_01_RTC_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_01_RTC_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_01_RTC_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_01_RTC_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_01_RTC_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_01_RTC_SHIFT))

//====================================================================
//Register: FIFO Parameters Register (High) (Instance 1 of 2) (SD_FIFO_PARAM_10)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_FIFO_PARAM_10_RESERVED2_MASK 0xfff0
#define  SDMMC3_2P_SD_FIFO_PARAM_10_RESERVED2_SHIFT 4
#define  SDMMC3_2P_SD_FIFO_PARAM_10_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_10_RESERVED2_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_10_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_10_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_10_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_10_PRE_GATE_CLK_CNT_MASK 0xf
#define  SDMMC3_2P_SD_FIFO_PARAM_10_PRE_GATE_CLK_CNT_SHIFT 0
#define  SDMMC3_2P_SD_FIFO_PARAM_10_PRE_GATE_CLK_CNT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_10_PRE_GATE_CLK_CNT_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_10_PRE_GATE_CLK_CNT_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_10_PRE_GATE_CLK_CNT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_10_PRE_GATE_CLK_CNT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_10_PRE_GATE_CLK_CNT_SHIFT))

//====================================================================
//Register: FIFO Parameters Register (High) (Instance 2 of 2) (SD_FIFO_PARAM_11)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_FIFO_PARAM_11_RESERVED2_MASK 0xfff0
#define  SDMMC3_2P_SD_FIFO_PARAM_11_RESERVED2_SHIFT 4
#define  SDMMC3_2P_SD_FIFO_PARAM_11_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_11_RESERVED2_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_11_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_11_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_11_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_FIFO_PARAM_11_PRE_GATE_CLK_CNT_MASK 0xf
#define  SDMMC3_2P_SD_FIFO_PARAM_11_PRE_GATE_CLK_CNT_SHIFT 0
#define  SDMMC3_2P_SD_FIFO_PARAM_11_PRE_GATE_CLK_CNT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_FIFO_PARAM_11_PRE_GATE_CLK_CNT_MASK) >> SDMMC3_2P_SD_FIFO_PARAM_11_PRE_GATE_CLK_CNT_SHIFT)
#define  SDMMC3_2P_SD_FIFO_PARAM_11_PRE_GATE_CLK_CNT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_FIFO_PARAM_11_PRE_GATE_CLK_CNT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_FIFO_PARAM_11_PRE_GATE_CLK_CNT_SHIFT))

//====================================================================
//Register: SPI Mode Register (Instance 1 of 2) (SD_SPI_MODE0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_SPI_MODE0_RESERVED2_MASK 0xe000
#define  SDMMC3_2P_SD_SPI_MODE0_RESERVED2_SHIFT 13
#define  SDMMC3_2P_SD_SPI_MODE0_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SPI_MODE0_RESERVED2_MASK) >> SDMMC3_2P_SD_SPI_MODE0_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_SPI_MODE0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SPI_MODE0_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SPI_MODE0_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_SPI_MODE0_SPI_ERR_TOKEN_MASK 0x1f00
#define  SDMMC3_2P_SD_SPI_MODE0_SPI_ERR_TOKEN_SHIFT 8
#define  SDMMC3_2P_SD_SPI_MODE0_SPI_ERR_TOKEN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SPI_MODE0_SPI_ERR_TOKEN_MASK) >> SDMMC3_2P_SD_SPI_MODE0_SPI_ERR_TOKEN_SHIFT)
#define  SDMMC3_2P_SD_SPI_MODE0_SPI_ERR_TOKEN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SPI_MODE0_SPI_ERR_TOKEN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SPI_MODE0_SPI_ERR_TOKEN_SHIFT))

#define  SDMMC3_2P_SD_SPI_MODE0_RESERVED3_MASK 0xfe
#define  SDMMC3_2P_SD_SPI_MODE0_RESERVED3_SHIFT 1
#define  SDMMC3_2P_SD_SPI_MODE0_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SPI_MODE0_RESERVED3_MASK) >> SDMMC3_2P_SD_SPI_MODE0_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_SPI_MODE0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SPI_MODE0_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SPI_MODE0_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_SPI_MODE0_SPI_EN_MASK 0x1
#define  SDMMC3_2P_SD_SPI_MODE0_SPI_EN_SHIFT 0
#define  SDMMC3_2P_SD_SPI_MODE0_SPI_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SPI_MODE0_SPI_EN_MASK) >> SDMMC3_2P_SD_SPI_MODE0_SPI_EN_SHIFT)
#define  SDMMC3_2P_SD_SPI_MODE0_SPI_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SPI_MODE0_SPI_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SPI_MODE0_SPI_EN_SHIFT))

//====================================================================
//Register: SPI Mode Register (Instance 2 of 2) (SD_SPI_MODE1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_SPI_MODE1_RESERVED2_MASK 0xe000
#define  SDMMC3_2P_SD_SPI_MODE1_RESERVED2_SHIFT 13
#define  SDMMC3_2P_SD_SPI_MODE1_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SPI_MODE1_RESERVED2_MASK) >> SDMMC3_2P_SD_SPI_MODE1_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_SPI_MODE1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SPI_MODE1_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SPI_MODE1_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_SPI_MODE1_SPI_ERR_TOKEN_MASK 0x1f00
#define  SDMMC3_2P_SD_SPI_MODE1_SPI_ERR_TOKEN_SHIFT 8
#define  SDMMC3_2P_SD_SPI_MODE1_SPI_ERR_TOKEN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SPI_MODE1_SPI_ERR_TOKEN_MASK) >> SDMMC3_2P_SD_SPI_MODE1_SPI_ERR_TOKEN_SHIFT)
#define  SDMMC3_2P_SD_SPI_MODE1_SPI_ERR_TOKEN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SPI_MODE1_SPI_ERR_TOKEN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SPI_MODE1_SPI_ERR_TOKEN_SHIFT))

#define  SDMMC3_2P_SD_SPI_MODE1_RESERVED3_MASK 0xfe
#define  SDMMC3_2P_SD_SPI_MODE1_RESERVED3_SHIFT 1
#define  SDMMC3_2P_SD_SPI_MODE1_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SPI_MODE1_RESERVED3_MASK) >> SDMMC3_2P_SD_SPI_MODE1_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_SPI_MODE1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SPI_MODE1_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SPI_MODE1_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_SPI_MODE1_SPI_EN_MASK 0x1
#define  SDMMC3_2P_SD_SPI_MODE1_SPI_EN_SHIFT 0
#define  SDMMC3_2P_SD_SPI_MODE1_SPI_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_SPI_MODE1_SPI_EN_MASK) >> SDMMC3_2P_SD_SPI_MODE1_SPI_EN_SHIFT)
#define  SDMMC3_2P_SD_SPI_MODE1_SPI_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_SPI_MODE1_SPI_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_SPI_MODE1_SPI_EN_SHIFT))

//====================================================================
//Register: Clock and Burst Size Setup Register (Instance 1 of 2) (SD_CLOCK_AND_BURST_SIZE_SETUP0)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_WR_OSTDG_MASK 0x8000
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_WR_OSTDG_SHIFT 15
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_WR_OSTDG_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_WR_OSTDG_MASK) >> SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_WR_OSTDG_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_WR_OSTDG_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_WR_OSTDG_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_WR_OSTDG_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_RD_OSTDG_MASK 0x4000
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_RD_OSTDG_SHIFT 14
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_RD_OSTDG_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_RD_OSTDG_MASK) >> SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_RD_OSTDG_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_RD_OSTDG_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_RD_OSTDG_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_RD_OSTDG_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_RESERVED2_MASK 0x3f00
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_RESERVED2_SHIFT 8
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_RESERVED2_MASK) >> SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_WR_ENDIAN_MASK 0x80
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_WR_ENDIAN_SHIFT 7
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_WR_ENDIAN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_WR_ENDIAN_MASK) >> SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_WR_ENDIAN_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_WR_ENDIAN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_WR_ENDIAN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_WR_ENDIAN_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_RD_ENDIAN_MASK 0x40
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_RD_ENDIAN_SHIFT 6
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_RD_ENDIAN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_RD_ENDIAN_MASK) >> SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_RD_ENDIAN_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_RD_ENDIAN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_RD_ENDIAN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_RD_ENDIAN_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_AXI_NON_POST_WR_MASK 0x20
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_AXI_NON_POST_WR_SHIFT 5
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_AXI_NON_POST_WR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_AXI_NON_POST_WR_MASK) >> SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_AXI_NON_POST_WR_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_AXI_NON_POST_WR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_AXI_NON_POST_WR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_AXI_NON_POST_WR_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_AXI_PRIORITY_MASK 0x10
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_AXI_PRIORITY_SHIFT 4
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_AXI_PRIORITY_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_AXI_PRIORITY_MASK) >> SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_AXI_PRIORITY_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_AXI_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_AXI_PRIORITY_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_AXI_PRIORITY_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_DMA_SIZE_MASK 0xc
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_DMA_SIZE_SHIFT 2
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_DMA_SIZE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_DMA_SIZE_MASK) >> SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_DMA_SIZE_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_DMA_SIZE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_DMA_SIZE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_DMA_SIZE_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_BRST_SIZE_MASK 0x3
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_BRST_SIZE_SHIFT 0
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_BRST_SIZE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_BRST_SIZE_MASK) >> SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_BRST_SIZE_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_BRST_SIZE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_BRST_SIZE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP0_BRST_SIZE_SHIFT))

//====================================================================
//Register: Clock and Burst Size Setup Register (Instance 2 of 2) (SD_CLOCK_AND_BURST_SIZE_SETUP1)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_WR_OSTDG_MASK 0x8000
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_WR_OSTDG_SHIFT 15
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_WR_OSTDG_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_WR_OSTDG_MASK) >> SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_WR_OSTDG_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_WR_OSTDG_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_WR_OSTDG_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_WR_OSTDG_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_RD_OSTDG_MASK 0x4000
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_RD_OSTDG_SHIFT 14
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_RD_OSTDG_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_RD_OSTDG_MASK) >> SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_RD_OSTDG_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_RD_OSTDG_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_RD_OSTDG_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_RD_OSTDG_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_RESERVED2_MASK 0x3f00
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_RESERVED2_SHIFT 8
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_RESERVED2_MASK) >> SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_WR_ENDIAN_MASK 0x80
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_WR_ENDIAN_SHIFT 7
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_WR_ENDIAN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_WR_ENDIAN_MASK) >> SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_WR_ENDIAN_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_WR_ENDIAN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_WR_ENDIAN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_WR_ENDIAN_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_RD_ENDIAN_MASK 0x40
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_RD_ENDIAN_SHIFT 6
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_RD_ENDIAN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_RD_ENDIAN_MASK) >> SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_RD_ENDIAN_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_RD_ENDIAN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_RD_ENDIAN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_RD_ENDIAN_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_AXI_NON_POST_WR_MASK 0x20
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_AXI_NON_POST_WR_SHIFT 5
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_AXI_NON_POST_WR_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_AXI_NON_POST_WR_MASK) >> SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_AXI_NON_POST_WR_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_AXI_NON_POST_WR_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_AXI_NON_POST_WR_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_AXI_NON_POST_WR_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_AXI_PRIORITY_MASK 0x10
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_AXI_PRIORITY_SHIFT 4
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_AXI_PRIORITY_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_AXI_PRIORITY_MASK) >> SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_AXI_PRIORITY_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_AXI_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_AXI_PRIORITY_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_AXI_PRIORITY_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_DMA_SIZE_MASK 0xc
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_DMA_SIZE_SHIFT 2
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_DMA_SIZE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_DMA_SIZE_MASK) >> SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_DMA_SIZE_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_DMA_SIZE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_DMA_SIZE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_DMA_SIZE_SHIFT))

#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_BRST_SIZE_MASK 0x3
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_BRST_SIZE_SHIFT 0
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_BRST_SIZE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_BRST_SIZE_MASK) >> SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_BRST_SIZE_SHIFT)
#define  SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_BRST_SIZE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_BRST_SIZE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CLOCK_AND_BURST_SIZE_SETUP1_BRST_SIZE_SHIFT))

//====================================================================
//Register: CE-ATA Register 0 (Instance 1 of 2) (SD_CE_ATA_10)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_CE_ATA_10_RESERVED2_MASK 0xc000
#define  SDMMC3_2P_SD_CE_ATA_10_RESERVED2_SHIFT 14
#define  SDMMC3_2P_SD_CE_ATA_10_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_10_RESERVED2_MASK) >> SDMMC3_2P_SD_CE_ATA_10_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_10_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_10_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_10_CPL_TIMEOUT_MASK 0x3fff
#define  SDMMC3_2P_SD_CE_ATA_10_CPL_TIMEOUT_SHIFT 0
#define  SDMMC3_2P_SD_CE_ATA_10_CPL_TIMEOUT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_10_CPL_TIMEOUT_MASK) >> SDMMC3_2P_SD_CE_ATA_10_CPL_TIMEOUT_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_10_CPL_TIMEOUT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_10_CPL_TIMEOUT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_10_CPL_TIMEOUT_SHIFT))

//====================================================================
//Register: CE-ATA Register 0 (Instance 2 of 2) (SD_CE_ATA_11)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_CE_ATA_11_RESERVED2_MASK 0xc000
#define  SDMMC3_2P_SD_CE_ATA_11_RESERVED2_SHIFT 14
#define  SDMMC3_2P_SD_CE_ATA_11_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_11_RESERVED2_MASK) >> SDMMC3_2P_SD_CE_ATA_11_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_11_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_11_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_11_CPL_TIMEOUT_MASK 0x3fff
#define  SDMMC3_2P_SD_CE_ATA_11_CPL_TIMEOUT_SHIFT 0
#define  SDMMC3_2P_SD_CE_ATA_11_CPL_TIMEOUT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_11_CPL_TIMEOUT_MASK) >> SDMMC3_2P_SD_CE_ATA_11_CPL_TIMEOUT_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_11_CPL_TIMEOUT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_11_CPL_TIMEOUT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_11_CPL_TIMEOUT_SHIFT))

//====================================================================
//Register: CE-ATA Register 1 (Instance 1 of 2) (SD_CE_ATA_20)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_CE_ATA_20_CHK_CPL_MASK 0x8000
#define  SDMMC3_2P_SD_CE_ATA_20_CHK_CPL_SHIFT 15
#define  SDMMC3_2P_SD_CE_ATA_20_CHK_CPL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_20_CHK_CPL_MASK) >> SDMMC3_2P_SD_CE_ATA_20_CHK_CPL_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_20_CHK_CPL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_20_CHK_CPL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_20_CHK_CPL_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_20_SND_CPL_MASK 0x4000
#define  SDMMC3_2P_SD_CE_ATA_20_SND_CPL_SHIFT 14
#define  SDMMC3_2P_SD_CE_ATA_20_SND_CPL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_20_SND_CPL_MASK) >> SDMMC3_2P_SD_CE_ATA_20_SND_CPL_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_20_SND_CPL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_20_SND_CPL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_20_SND_CPL_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_20_CEATA_CARD_MASK 0x2000
#define  SDMMC3_2P_SD_CE_ATA_20_CEATA_CARD_SHIFT 13
#define  SDMMC3_2P_SD_CE_ATA_20_CEATA_CARD_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_20_CEATA_CARD_MASK) >> SDMMC3_2P_SD_CE_ATA_20_CEATA_CARD_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_20_CEATA_CARD_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_20_CEATA_CARD_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_20_CEATA_CARD_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_20_MMC_CARD_MASK 0x1000
#define  SDMMC3_2P_SD_CE_ATA_20_MMC_CARD_SHIFT 12
#define  SDMMC3_2P_SD_CE_ATA_20_MMC_CARD_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_20_MMC_CARD_MASK) >> SDMMC3_2P_SD_CE_ATA_20_MMC_CARD_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_20_MMC_CARD_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_20_MMC_CARD_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_20_MMC_CARD_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_20_MMC_RESETN_MASK 0x800
#define  SDMMC3_2P_SD_CE_ATA_20_MMC_RESETN_SHIFT 11
#define  SDMMC3_2P_SD_CE_ATA_20_MMC_RESETN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_20_MMC_RESETN_MASK) >> SDMMC3_2P_SD_CE_ATA_20_MMC_RESETN_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_20_MMC_RESETN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_20_MMC_RESETN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_20_MMC_RESETN_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_20_RESERVED2_MASK 0x780
#define  SDMMC3_2P_SD_CE_ATA_20_RESERVED2_SHIFT 7
#define  SDMMC3_2P_SD_CE_ATA_20_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_20_RESERVED2_MASK) >> SDMMC3_2P_SD_CE_ATA_20_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_20_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_20_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_20_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_20_CPL_COMPLETE_MASK 0x40
#define  SDMMC3_2P_SD_CE_ATA_20_CPL_COMPLETE_SHIFT 6
#define  SDMMC3_2P_SD_CE_ATA_20_CPL_COMPLETE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_20_CPL_COMPLETE_MASK) >> SDMMC3_2P_SD_CE_ATA_20_CPL_COMPLETE_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_20_CPL_COMPLETE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_20_CPL_COMPLETE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_20_CPL_COMPLETE_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_20_CPL_COMPLETE_EN_MASK 0x20
#define  SDMMC3_2P_SD_CE_ATA_20_CPL_COMPLETE_EN_SHIFT 5
#define  SDMMC3_2P_SD_CE_ATA_20_CPL_COMPLETE_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_20_CPL_COMPLETE_EN_MASK) >> SDMMC3_2P_SD_CE_ATA_20_CPL_COMPLETE_EN_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_20_CPL_COMPLETE_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_20_CPL_COMPLETE_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_20_CPL_COMPLETE_EN_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_20_CPL_COMPLETE_INT_EN_MASK 0x10
#define  SDMMC3_2P_SD_CE_ATA_20_CPL_COMPLETE_INT_EN_SHIFT 4
#define  SDMMC3_2P_SD_CE_ATA_20_CPL_COMPLETE_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_20_CPL_COMPLETE_INT_EN_MASK) >> SDMMC3_2P_SD_CE_ATA_20_CPL_COMPLETE_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_20_CPL_COMPLETE_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_20_CPL_COMPLETE_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_20_CPL_COMPLETE_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_20_RESERVED3_MASK 0x8
#define  SDMMC3_2P_SD_CE_ATA_20_RESERVED3_SHIFT 3
#define  SDMMC3_2P_SD_CE_ATA_20_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_20_RESERVED3_MASK) >> SDMMC3_2P_SD_CE_ATA_20_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_20_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_20_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_20_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_20_MISC_INT_MASK 0x4
#define  SDMMC3_2P_SD_CE_ATA_20_MISC_INT_SHIFT 2
#define  SDMMC3_2P_SD_CE_ATA_20_MISC_INT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_20_MISC_INT_MASK) >> SDMMC3_2P_SD_CE_ATA_20_MISC_INT_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_20_MISC_INT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_20_MISC_INT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_20_MISC_INT_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_20_MISC_INT_EN_MASK 0x2
#define  SDMMC3_2P_SD_CE_ATA_20_MISC_INT_EN_SHIFT 1
#define  SDMMC3_2P_SD_CE_ATA_20_MISC_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_20_MISC_INT_EN_MASK) >> SDMMC3_2P_SD_CE_ATA_20_MISC_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_20_MISC_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_20_MISC_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_20_MISC_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_20_MISC_INT_INT_EN_MASK 0x1
#define  SDMMC3_2P_SD_CE_ATA_20_MISC_INT_INT_EN_SHIFT 0
#define  SDMMC3_2P_SD_CE_ATA_20_MISC_INT_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_20_MISC_INT_INT_EN_MASK) >> SDMMC3_2P_SD_CE_ATA_20_MISC_INT_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_20_MISC_INT_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_20_MISC_INT_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_20_MISC_INT_INT_EN_SHIFT))

//====================================================================
//Register: CE-ATA Register 1 (Instance 2 of 2) (SD_CE_ATA_21)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_CE_ATA_21_CHK_CPL_MASK 0x8000
#define  SDMMC3_2P_SD_CE_ATA_21_CHK_CPL_SHIFT 15
#define  SDMMC3_2P_SD_CE_ATA_21_CHK_CPL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_21_CHK_CPL_MASK) >> SDMMC3_2P_SD_CE_ATA_21_CHK_CPL_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_21_CHK_CPL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_21_CHK_CPL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_21_CHK_CPL_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_21_SND_CPL_MASK 0x4000
#define  SDMMC3_2P_SD_CE_ATA_21_SND_CPL_SHIFT 14
#define  SDMMC3_2P_SD_CE_ATA_21_SND_CPL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_21_SND_CPL_MASK) >> SDMMC3_2P_SD_CE_ATA_21_SND_CPL_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_21_SND_CPL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_21_SND_CPL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_21_SND_CPL_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_21_CEATA_CARD_MASK 0x2000
#define  SDMMC3_2P_SD_CE_ATA_21_CEATA_CARD_SHIFT 13
#define  SDMMC3_2P_SD_CE_ATA_21_CEATA_CARD_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_21_CEATA_CARD_MASK) >> SDMMC3_2P_SD_CE_ATA_21_CEATA_CARD_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_21_CEATA_CARD_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_21_CEATA_CARD_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_21_CEATA_CARD_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_21_MMC_CARD_MASK 0x1000
#define  SDMMC3_2P_SD_CE_ATA_21_MMC_CARD_SHIFT 12
#define  SDMMC3_2P_SD_CE_ATA_21_MMC_CARD_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_21_MMC_CARD_MASK) >> SDMMC3_2P_SD_CE_ATA_21_MMC_CARD_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_21_MMC_CARD_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_21_MMC_CARD_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_21_MMC_CARD_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_21_MMC_RESETN_MASK 0x800
#define  SDMMC3_2P_SD_CE_ATA_21_MMC_RESETN_SHIFT 11
#define  SDMMC3_2P_SD_CE_ATA_21_MMC_RESETN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_21_MMC_RESETN_MASK) >> SDMMC3_2P_SD_CE_ATA_21_MMC_RESETN_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_21_MMC_RESETN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_21_MMC_RESETN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_21_MMC_RESETN_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_21_RESERVED2_MASK 0x780
#define  SDMMC3_2P_SD_CE_ATA_21_RESERVED2_SHIFT 7
#define  SDMMC3_2P_SD_CE_ATA_21_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_21_RESERVED2_MASK) >> SDMMC3_2P_SD_CE_ATA_21_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_21_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_21_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_21_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_21_CPL_COMPLETE_MASK 0x40
#define  SDMMC3_2P_SD_CE_ATA_21_CPL_COMPLETE_SHIFT 6
#define  SDMMC3_2P_SD_CE_ATA_21_CPL_COMPLETE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_21_CPL_COMPLETE_MASK) >> SDMMC3_2P_SD_CE_ATA_21_CPL_COMPLETE_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_21_CPL_COMPLETE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_21_CPL_COMPLETE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_21_CPL_COMPLETE_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_21_CPL_COMPLETE_EN_MASK 0x20
#define  SDMMC3_2P_SD_CE_ATA_21_CPL_COMPLETE_EN_SHIFT 5
#define  SDMMC3_2P_SD_CE_ATA_21_CPL_COMPLETE_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_21_CPL_COMPLETE_EN_MASK) >> SDMMC3_2P_SD_CE_ATA_21_CPL_COMPLETE_EN_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_21_CPL_COMPLETE_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_21_CPL_COMPLETE_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_21_CPL_COMPLETE_EN_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_21_CPL_COMPLETE_INT_EN_MASK 0x10
#define  SDMMC3_2P_SD_CE_ATA_21_CPL_COMPLETE_INT_EN_SHIFT 4
#define  SDMMC3_2P_SD_CE_ATA_21_CPL_COMPLETE_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_21_CPL_COMPLETE_INT_EN_MASK) >> SDMMC3_2P_SD_CE_ATA_21_CPL_COMPLETE_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_21_CPL_COMPLETE_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_21_CPL_COMPLETE_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_21_CPL_COMPLETE_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_21_RESERVED3_MASK 0x8
#define  SDMMC3_2P_SD_CE_ATA_21_RESERVED3_SHIFT 3
#define  SDMMC3_2P_SD_CE_ATA_21_RESERVED3_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_21_RESERVED3_MASK) >> SDMMC3_2P_SD_CE_ATA_21_RESERVED3_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_21_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_21_RESERVED3_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_21_RESERVED3_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_21_MISC_INT_MASK 0x4
#define  SDMMC3_2P_SD_CE_ATA_21_MISC_INT_SHIFT 2
#define  SDMMC3_2P_SD_CE_ATA_21_MISC_INT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_21_MISC_INT_MASK) >> SDMMC3_2P_SD_CE_ATA_21_MISC_INT_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_21_MISC_INT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_21_MISC_INT_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_21_MISC_INT_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_21_MISC_INT_EN_MASK 0x2
#define  SDMMC3_2P_SD_CE_ATA_21_MISC_INT_EN_SHIFT 1
#define  SDMMC3_2P_SD_CE_ATA_21_MISC_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_21_MISC_INT_EN_MASK) >> SDMMC3_2P_SD_CE_ATA_21_MISC_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_21_MISC_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_21_MISC_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_21_MISC_INT_EN_SHIFT))

#define  SDMMC3_2P_SD_CE_ATA_21_MISC_INT_INT_EN_MASK 0x1
#define  SDMMC3_2P_SD_CE_ATA_21_MISC_INT_INT_EN_SHIFT 0
#define  SDMMC3_2P_SD_CE_ATA_21_MISC_INT_INT_EN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_CE_ATA_21_MISC_INT_INT_EN_MASK) >> SDMMC3_2P_SD_CE_ATA_21_MISC_INT_INT_EN_SHIFT)
#define  SDMMC3_2P_SD_CE_ATA_21_MISC_INT_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_CE_ATA_21_MISC_INT_INT_EN_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_CE_ATA_21_MISC_INT_INT_EN_SHIFT))

//====================================================================
//Register: PAD I/O Setup Register lower (Instance 1 of 2) (SD_PAD_IO_SETUP00)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_PAD_IO_SETUP00_RESERVED2_MASK 0xfffc
#define  SDMMC3_2P_SD_PAD_IO_SETUP00_RESERVED2_SHIFT 2
#define  SDMMC3_2P_SD_PAD_IO_SETUP00_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PAD_IO_SETUP00_RESERVED2_MASK) >> SDMMC3_2P_SD_PAD_IO_SETUP00_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_PAD_IO_SETUP00_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PAD_IO_SETUP00_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PAD_IO_SETUP00_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_PAD_IO_SETUP00_INAND_SEL_MASK 0x2
#define  SDMMC3_2P_SD_PAD_IO_SETUP00_INAND_SEL_SHIFT 1
#define  SDMMC3_2P_SD_PAD_IO_SETUP00_INAND_SEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PAD_IO_SETUP00_INAND_SEL_MASK) >> SDMMC3_2P_SD_PAD_IO_SETUP00_INAND_SEL_SHIFT)
#define  SDMMC3_2P_SD_PAD_IO_SETUP00_INAND_SEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PAD_IO_SETUP00_INAND_SEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PAD_IO_SETUP00_INAND_SEL_SHIFT))

#define  SDMMC3_2P_SD_PAD_IO_SETUP00_ASYNC_IO_MODE_MASK 0x1
#define  SDMMC3_2P_SD_PAD_IO_SETUP00_ASYNC_IO_MODE_SHIFT 0
#define  SDMMC3_2P_SD_PAD_IO_SETUP00_ASYNC_IO_MODE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PAD_IO_SETUP00_ASYNC_IO_MODE_MASK) >> SDMMC3_2P_SD_PAD_IO_SETUP00_ASYNC_IO_MODE_SHIFT)
#define  SDMMC3_2P_SD_PAD_IO_SETUP00_ASYNC_IO_MODE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PAD_IO_SETUP00_ASYNC_IO_MODE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PAD_IO_SETUP00_ASYNC_IO_MODE_SHIFT))

//====================================================================
//Register: PAD I/O Setup Register lower (Instance 2 of 2) (SD_PAD_IO_SETUP01)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_PAD_IO_SETUP01_RESERVED2_MASK 0xfffc
#define  SDMMC3_2P_SD_PAD_IO_SETUP01_RESERVED2_SHIFT 2
#define  SDMMC3_2P_SD_PAD_IO_SETUP01_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PAD_IO_SETUP01_RESERVED2_MASK) >> SDMMC3_2P_SD_PAD_IO_SETUP01_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_PAD_IO_SETUP01_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PAD_IO_SETUP01_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PAD_IO_SETUP01_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_PAD_IO_SETUP01_INAND_SEL_MASK 0x2
#define  SDMMC3_2P_SD_PAD_IO_SETUP01_INAND_SEL_SHIFT 1
#define  SDMMC3_2P_SD_PAD_IO_SETUP01_INAND_SEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PAD_IO_SETUP01_INAND_SEL_MASK) >> SDMMC3_2P_SD_PAD_IO_SETUP01_INAND_SEL_SHIFT)
#define  SDMMC3_2P_SD_PAD_IO_SETUP01_INAND_SEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PAD_IO_SETUP01_INAND_SEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PAD_IO_SETUP01_INAND_SEL_SHIFT))

#define  SDMMC3_2P_SD_PAD_IO_SETUP01_ASYNC_IO_MODE_MASK 0x1
#define  SDMMC3_2P_SD_PAD_IO_SETUP01_ASYNC_IO_MODE_SHIFT 0
#define  SDMMC3_2P_SD_PAD_IO_SETUP01_ASYNC_IO_MODE_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PAD_IO_SETUP01_ASYNC_IO_MODE_MASK) >> SDMMC3_2P_SD_PAD_IO_SETUP01_ASYNC_IO_MODE_SHIFT)
#define  SDMMC3_2P_SD_PAD_IO_SETUP01_ASYNC_IO_MODE_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PAD_IO_SETUP01_ASYNC_IO_MODE_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PAD_IO_SETUP01_ASYNC_IO_MODE_SHIFT))

//====================================================================
//Register: PAD I/O Setup Register upper (Instance 1 of 2) (SD_PAD_IO_SETUP10)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_PAD_IO_SETUP10_RESERVED2_MASK 0xff00
#define  SDMMC3_2P_SD_PAD_IO_SETUP10_RESERVED2_SHIFT 8
#define  SDMMC3_2P_SD_PAD_IO_SETUP10_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PAD_IO_SETUP10_RESERVED2_MASK) >> SDMMC3_2P_SD_PAD_IO_SETUP10_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_PAD_IO_SETUP10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PAD_IO_SETUP10_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PAD_IO_SETUP10_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_PAD_IO_SETUP10_ECO_REG_MASK 0xff
#define  SDMMC3_2P_SD_PAD_IO_SETUP10_ECO_REG_SHIFT 0
#define  SDMMC3_2P_SD_PAD_IO_SETUP10_ECO_REG_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PAD_IO_SETUP10_ECO_REG_MASK) >> SDMMC3_2P_SD_PAD_IO_SETUP10_ECO_REG_SHIFT)
#define  SDMMC3_2P_SD_PAD_IO_SETUP10_ECO_REG_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PAD_IO_SETUP10_ECO_REG_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PAD_IO_SETUP10_ECO_REG_SHIFT))

//====================================================================
//Register: PAD I/O Setup Register upper (Instance 2 of 2) (SD_PAD_IO_SETUP11)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_PAD_IO_SETUP11_RESERVED2_MASK 0xff00
#define  SDMMC3_2P_SD_PAD_IO_SETUP11_RESERVED2_SHIFT 8
#define  SDMMC3_2P_SD_PAD_IO_SETUP11_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PAD_IO_SETUP11_RESERVED2_MASK) >> SDMMC3_2P_SD_PAD_IO_SETUP11_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_PAD_IO_SETUP11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PAD_IO_SETUP11_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PAD_IO_SETUP11_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_PAD_IO_SETUP11_ECO_REG_MASK 0xff
#define  SDMMC3_2P_SD_PAD_IO_SETUP11_ECO_REG_SHIFT 0
#define  SDMMC3_2P_SD_PAD_IO_SETUP11_ECO_REG_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_PAD_IO_SETUP11_ECO_REG_MASK) >> SDMMC3_2P_SD_PAD_IO_SETUP11_ECO_REG_SHIFT)
#define  SDMMC3_2P_SD_PAD_IO_SETUP11_ECO_REG_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_PAD_IO_SETUP11_ECO_REG_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_PAD_IO_SETUP11_ECO_REG_SHIFT))

//====================================================================
//Register: RX Configuration Register (Low) (Instance 1 of 2) (SD_RX_CFG_00)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_RX_CFG_00_SDCLK_DELAY_0_MASK 0xff00
#define  SDMMC3_2P_SD_RX_CFG_00_SDCLK_DELAY_0_SHIFT 8
#define  SDMMC3_2P_SD_RX_CFG_00_SDCLK_DELAY_0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RX_CFG_00_SDCLK_DELAY_0_MASK) >> SDMMC3_2P_SD_RX_CFG_00_SDCLK_DELAY_0_SHIFT)
#define  SDMMC3_2P_SD_RX_CFG_00_SDCLK_DELAY_0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RX_CFG_00_SDCLK_DELAY_0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RX_CFG_00_SDCLK_DELAY_0_SHIFT))

#define  SDMMC3_2P_SD_RX_CFG_00_RESERVED2_MASK 0xf0
#define  SDMMC3_2P_SD_RX_CFG_00_RESERVED2_SHIFT 4
#define  SDMMC3_2P_SD_RX_CFG_00_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RX_CFG_00_RESERVED2_MASK) >> SDMMC3_2P_SD_RX_CFG_00_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_RX_CFG_00_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RX_CFG_00_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RX_CFG_00_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_RX_CFG_00_SDCLK_SEL_1_MASK 0xc
#define  SDMMC3_2P_SD_RX_CFG_00_SDCLK_SEL_1_SHIFT 2
#define  SDMMC3_2P_SD_RX_CFG_00_SDCLK_SEL_1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RX_CFG_00_SDCLK_SEL_1_MASK) >> SDMMC3_2P_SD_RX_CFG_00_SDCLK_SEL_1_SHIFT)
#define  SDMMC3_2P_SD_RX_CFG_00_SDCLK_SEL_1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RX_CFG_00_SDCLK_SEL_1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RX_CFG_00_SDCLK_SEL_1_SHIFT))

#define  SDMMC3_2P_SD_RX_CFG_00_SDCLK_SEL_0_MASK 0x3
#define  SDMMC3_2P_SD_RX_CFG_00_SDCLK_SEL_0_SHIFT 0
#define  SDMMC3_2P_SD_RX_CFG_00_SDCLK_SEL_0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RX_CFG_00_SDCLK_SEL_0_MASK) >> SDMMC3_2P_SD_RX_CFG_00_SDCLK_SEL_0_SHIFT)
#define  SDMMC3_2P_SD_RX_CFG_00_SDCLK_SEL_0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RX_CFG_00_SDCLK_SEL_0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RX_CFG_00_SDCLK_SEL_0_SHIFT))

//====================================================================
//Register: RX Configuration Register (Low) (Instance 2 of 2) (SD_RX_CFG_01)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_RX_CFG_01_SDCLK_DELAY_0_MASK 0xff00
#define  SDMMC3_2P_SD_RX_CFG_01_SDCLK_DELAY_0_SHIFT 8
#define  SDMMC3_2P_SD_RX_CFG_01_SDCLK_DELAY_0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RX_CFG_01_SDCLK_DELAY_0_MASK) >> SDMMC3_2P_SD_RX_CFG_01_SDCLK_DELAY_0_SHIFT)
#define  SDMMC3_2P_SD_RX_CFG_01_SDCLK_DELAY_0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RX_CFG_01_SDCLK_DELAY_0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RX_CFG_01_SDCLK_DELAY_0_SHIFT))

#define  SDMMC3_2P_SD_RX_CFG_01_RESERVED2_MASK 0xf0
#define  SDMMC3_2P_SD_RX_CFG_01_RESERVED2_SHIFT 4
#define  SDMMC3_2P_SD_RX_CFG_01_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RX_CFG_01_RESERVED2_MASK) >> SDMMC3_2P_SD_RX_CFG_01_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_RX_CFG_01_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RX_CFG_01_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RX_CFG_01_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_RX_CFG_01_SDCLK_SEL_1_MASK 0xc
#define  SDMMC3_2P_SD_RX_CFG_01_SDCLK_SEL_1_SHIFT 2
#define  SDMMC3_2P_SD_RX_CFG_01_SDCLK_SEL_1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RX_CFG_01_SDCLK_SEL_1_MASK) >> SDMMC3_2P_SD_RX_CFG_01_SDCLK_SEL_1_SHIFT)
#define  SDMMC3_2P_SD_RX_CFG_01_SDCLK_SEL_1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RX_CFG_01_SDCLK_SEL_1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RX_CFG_01_SDCLK_SEL_1_SHIFT))

#define  SDMMC3_2P_SD_RX_CFG_01_SDCLK_SEL_0_MASK 0x3
#define  SDMMC3_2P_SD_RX_CFG_01_SDCLK_SEL_0_SHIFT 0
#define  SDMMC3_2P_SD_RX_CFG_01_SDCLK_SEL_0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RX_CFG_01_SDCLK_SEL_0_MASK) >> SDMMC3_2P_SD_RX_CFG_01_SDCLK_SEL_0_SHIFT)
#define  SDMMC3_2P_SD_RX_CFG_01_SDCLK_SEL_0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RX_CFG_01_SDCLK_SEL_0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RX_CFG_01_SDCLK_SEL_0_SHIFT))

//====================================================================
//Register: RX Configuration Register (High) (Instance 1 of 2) (SD_RX_CFG_10)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_RX_CFG_10_RESERVED2_MASK 0xfc00
#define  SDMMC3_2P_SD_RX_CFG_10_RESERVED2_SHIFT 10
#define  SDMMC3_2P_SD_RX_CFG_10_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RX_CFG_10_RESERVED2_MASK) >> SDMMC3_2P_SD_RX_CFG_10_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_RX_CFG_10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RX_CFG_10_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RX_CFG_10_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_RX_CFG_10_TUNING_DLY_INC_MASK 0x3fe
#define  SDMMC3_2P_SD_RX_CFG_10_TUNING_DLY_INC_SHIFT 1
#define  SDMMC3_2P_SD_RX_CFG_10_TUNING_DLY_INC_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RX_CFG_10_TUNING_DLY_INC_MASK) >> SDMMC3_2P_SD_RX_CFG_10_TUNING_DLY_INC_SHIFT)
#define  SDMMC3_2P_SD_RX_CFG_10_TUNING_DLY_INC_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RX_CFG_10_TUNING_DLY_INC_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RX_CFG_10_TUNING_DLY_INC_SHIFT))

#define  SDMMC3_2P_SD_RX_CFG_10_SDCLK_DELAY_1_MASK 0x1
#define  SDMMC3_2P_SD_RX_CFG_10_SDCLK_DELAY_1_SHIFT 0
#define  SDMMC3_2P_SD_RX_CFG_10_SDCLK_DELAY_1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RX_CFG_10_SDCLK_DELAY_1_MASK) >> SDMMC3_2P_SD_RX_CFG_10_SDCLK_DELAY_1_SHIFT)
#define  SDMMC3_2P_SD_RX_CFG_10_SDCLK_DELAY_1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RX_CFG_10_SDCLK_DELAY_1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RX_CFG_10_SDCLK_DELAY_1_SHIFT))

//====================================================================
//Register: RX Configuration Register (High) (Instance 2 of 2) (SD_RX_CFG_11)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_RX_CFG_11_RESERVED2_MASK 0xfc00
#define  SDMMC3_2P_SD_RX_CFG_11_RESERVED2_SHIFT 10
#define  SDMMC3_2P_SD_RX_CFG_11_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RX_CFG_11_RESERVED2_MASK) >> SDMMC3_2P_SD_RX_CFG_11_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_RX_CFG_11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RX_CFG_11_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RX_CFG_11_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_RX_CFG_11_TUNING_DLY_INC_MASK 0x3fe
#define  SDMMC3_2P_SD_RX_CFG_11_TUNING_DLY_INC_SHIFT 1
#define  SDMMC3_2P_SD_RX_CFG_11_TUNING_DLY_INC_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RX_CFG_11_TUNING_DLY_INC_MASK) >> SDMMC3_2P_SD_RX_CFG_11_TUNING_DLY_INC_SHIFT)
#define  SDMMC3_2P_SD_RX_CFG_11_TUNING_DLY_INC_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RX_CFG_11_TUNING_DLY_INC_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RX_CFG_11_TUNING_DLY_INC_SHIFT))

#define  SDMMC3_2P_SD_RX_CFG_11_SDCLK_DELAY_1_MASK 0x1
#define  SDMMC3_2P_SD_RX_CFG_11_SDCLK_DELAY_1_SHIFT 0
#define  SDMMC3_2P_SD_RX_CFG_11_SDCLK_DELAY_1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_RX_CFG_11_SDCLK_DELAY_1_MASK) >> SDMMC3_2P_SD_RX_CFG_11_SDCLK_DELAY_1_SHIFT)
#define  SDMMC3_2P_SD_RX_CFG_11_SDCLK_DELAY_1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_RX_CFG_11_SDCLK_DELAY_1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_RX_CFG_11_SDCLK_DELAY_1_SHIFT))

//====================================================================
//Register: TX Configuration Register (Low) (Instance 1 of 2) (SD_TX_CFG_00)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_TX_CFG_00_RESERVED2_MASK 0xfe00
#define  SDMMC3_2P_SD_TX_CFG_00_RESERVED2_SHIFT 9
#define  SDMMC3_2P_SD_TX_CFG_00_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TX_CFG_00_RESERVED2_MASK) >> SDMMC3_2P_SD_TX_CFG_00_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_TX_CFG_00_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TX_CFG_00_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TX_CFG_00_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_TX_CFG_00_TX_HOLD_DELAY0_MASK 0x1ff
#define  SDMMC3_2P_SD_TX_CFG_00_TX_HOLD_DELAY0_SHIFT 0
#define  SDMMC3_2P_SD_TX_CFG_00_TX_HOLD_DELAY0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TX_CFG_00_TX_HOLD_DELAY0_MASK) >> SDMMC3_2P_SD_TX_CFG_00_TX_HOLD_DELAY0_SHIFT)
#define  SDMMC3_2P_SD_TX_CFG_00_TX_HOLD_DELAY0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TX_CFG_00_TX_HOLD_DELAY0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TX_CFG_00_TX_HOLD_DELAY0_SHIFT))

//====================================================================
//Register: TX Configuration Register (Low) (Instance 2 of 2) (SD_TX_CFG_01)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_TX_CFG_01_RESERVED2_MASK 0xfe00
#define  SDMMC3_2P_SD_TX_CFG_01_RESERVED2_SHIFT 9
#define  SDMMC3_2P_SD_TX_CFG_01_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TX_CFG_01_RESERVED2_MASK) >> SDMMC3_2P_SD_TX_CFG_01_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_TX_CFG_01_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TX_CFG_01_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TX_CFG_01_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_TX_CFG_01_TX_HOLD_DELAY0_MASK 0x1ff
#define  SDMMC3_2P_SD_TX_CFG_01_TX_HOLD_DELAY0_SHIFT 0
#define  SDMMC3_2P_SD_TX_CFG_01_TX_HOLD_DELAY0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TX_CFG_01_TX_HOLD_DELAY0_MASK) >> SDMMC3_2P_SD_TX_CFG_01_TX_HOLD_DELAY0_SHIFT)
#define  SDMMC3_2P_SD_TX_CFG_01_TX_HOLD_DELAY0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TX_CFG_01_TX_HOLD_DELAY0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TX_CFG_01_TX_HOLD_DELAY0_SHIFT))

//====================================================================
//Register: TX Configuration Register (HIGH) (Instance 1 of 2) (SD_TX_CFG_10)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_TX_CFG_10_TX_MUX_SEL_MASK 0x8000
#define  SDMMC3_2P_SD_TX_CFG_10_TX_MUX_SEL_SHIFT 15
#define  SDMMC3_2P_SD_TX_CFG_10_TX_MUX_SEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TX_CFG_10_TX_MUX_SEL_MASK) >> SDMMC3_2P_SD_TX_CFG_10_TX_MUX_SEL_SHIFT)
#define  SDMMC3_2P_SD_TX_CFG_10_TX_MUX_SEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TX_CFG_10_TX_MUX_SEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TX_CFG_10_TX_MUX_SEL_SHIFT))

#define  SDMMC3_2P_SD_TX_CFG_10_TX_INT_CLK_SEL_MASK 0x4000
#define  SDMMC3_2P_SD_TX_CFG_10_TX_INT_CLK_SEL_SHIFT 14
#define  SDMMC3_2P_SD_TX_CFG_10_TX_INT_CLK_SEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TX_CFG_10_TX_INT_CLK_SEL_MASK) >> SDMMC3_2P_SD_TX_CFG_10_TX_INT_CLK_SEL_SHIFT)
#define  SDMMC3_2P_SD_TX_CFG_10_TX_INT_CLK_SEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TX_CFG_10_TX_INT_CLK_SEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TX_CFG_10_TX_INT_CLK_SEL_SHIFT))

#define  SDMMC3_2P_SD_TX_CFG_10_RESERVED2_MASK 0x3e00
#define  SDMMC3_2P_SD_TX_CFG_10_RESERVED2_SHIFT 9
#define  SDMMC3_2P_SD_TX_CFG_10_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TX_CFG_10_RESERVED2_MASK) >> SDMMC3_2P_SD_TX_CFG_10_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_TX_CFG_10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TX_CFG_10_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TX_CFG_10_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_TX_CFG_10_TX_HOLD_DELAY1_MASK 0x1ff
#define  SDMMC3_2P_SD_TX_CFG_10_TX_HOLD_DELAY1_SHIFT 0
#define  SDMMC3_2P_SD_TX_CFG_10_TX_HOLD_DELAY1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TX_CFG_10_TX_HOLD_DELAY1_MASK) >> SDMMC3_2P_SD_TX_CFG_10_TX_HOLD_DELAY1_SHIFT)
#define  SDMMC3_2P_SD_TX_CFG_10_TX_HOLD_DELAY1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TX_CFG_10_TX_HOLD_DELAY1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TX_CFG_10_TX_HOLD_DELAY1_SHIFT))

//====================================================================
//Register: TX Configuration Register (HIGH) (Instance 2 of 2) (SD_TX_CFG_11)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_TX_CFG_11_TX_MUX_SEL_MASK 0x8000
#define  SDMMC3_2P_SD_TX_CFG_11_TX_MUX_SEL_SHIFT 15
#define  SDMMC3_2P_SD_TX_CFG_11_TX_MUX_SEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TX_CFG_11_TX_MUX_SEL_MASK) >> SDMMC3_2P_SD_TX_CFG_11_TX_MUX_SEL_SHIFT)
#define  SDMMC3_2P_SD_TX_CFG_11_TX_MUX_SEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TX_CFG_11_TX_MUX_SEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TX_CFG_11_TX_MUX_SEL_SHIFT))

#define  SDMMC3_2P_SD_TX_CFG_11_TX_INT_CLK_SEL_MASK 0x4000
#define  SDMMC3_2P_SD_TX_CFG_11_TX_INT_CLK_SEL_SHIFT 14
#define  SDMMC3_2P_SD_TX_CFG_11_TX_INT_CLK_SEL_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TX_CFG_11_TX_INT_CLK_SEL_MASK) >> SDMMC3_2P_SD_TX_CFG_11_TX_INT_CLK_SEL_SHIFT)
#define  SDMMC3_2P_SD_TX_CFG_11_TX_INT_CLK_SEL_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TX_CFG_11_TX_INT_CLK_SEL_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TX_CFG_11_TX_INT_CLK_SEL_SHIFT))

#define  SDMMC3_2P_SD_TX_CFG_11_RESERVED2_MASK 0x3e00
#define  SDMMC3_2P_SD_TX_CFG_11_RESERVED2_SHIFT 9
#define  SDMMC3_2P_SD_TX_CFG_11_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TX_CFG_11_RESERVED2_MASK) >> SDMMC3_2P_SD_TX_CFG_11_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_TX_CFG_11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TX_CFG_11_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TX_CFG_11_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_TX_CFG_11_TX_HOLD_DELAY1_MASK 0x1ff
#define  SDMMC3_2P_SD_TX_CFG_11_TX_HOLD_DELAY1_SHIFT 0
#define  SDMMC3_2P_SD_TX_CFG_11_TX_HOLD_DELAY1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_TX_CFG_11_TX_HOLD_DELAY1_MASK) >> SDMMC3_2P_SD_TX_CFG_11_TX_HOLD_DELAY1_SHIFT)
#define  SDMMC3_2P_SD_TX_CFG_11_TX_HOLD_DELAY1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_TX_CFG_11_TX_HOLD_DELAY1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_TX_CFG_11_TX_HOLD_DELAY1_SHIFT))

//====================================================================
//Register: Tuning Configuration Register (Low) (Instance 1 of 2) (TUNING_CFG_REG_00)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_TUNING_CFG_REG_00_TUNING_CLK_DLY0_MASK 0xc000
#define  SDMMC3_2P_TUNING_CFG_REG_00_TUNING_CLK_DLY0_SHIFT 14
#define  SDMMC3_2P_TUNING_CFG_REG_00_TUNING_CLK_DLY0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_TUNING_CFG_REG_00_TUNING_CLK_DLY0_MASK) >> SDMMC3_2P_TUNING_CFG_REG_00_TUNING_CLK_DLY0_SHIFT)
#define  SDMMC3_2P_TUNING_CFG_REG_00_TUNING_CLK_DLY0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_TUNING_CFG_REG_00_TUNING_CLK_DLY0_MASK) | (((uint16_t)val) << SDMMC3_2P_TUNING_CFG_REG_00_TUNING_CLK_DLY0_SHIFT))

#define  SDMMC3_2P_TUNING_CFG_REG_00_TUNING_WD_CNT_MASK 0x3f00
#define  SDMMC3_2P_TUNING_CFG_REG_00_TUNING_WD_CNT_SHIFT 8
#define  SDMMC3_2P_TUNING_CFG_REG_00_TUNING_WD_CNT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_TUNING_CFG_REG_00_TUNING_WD_CNT_MASK) >> SDMMC3_2P_TUNING_CFG_REG_00_TUNING_WD_CNT_SHIFT)
#define  SDMMC3_2P_TUNING_CFG_REG_00_TUNING_WD_CNT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_TUNING_CFG_REG_00_TUNING_WD_CNT_MASK) | (((uint16_t)val) << SDMMC3_2P_TUNING_CFG_REG_00_TUNING_WD_CNT_SHIFT))

#define  SDMMC3_2P_TUNING_CFG_REG_00_TUNING_TT_CNT_MASK 0xff
#define  SDMMC3_2P_TUNING_CFG_REG_00_TUNING_TT_CNT_SHIFT 0
#define  SDMMC3_2P_TUNING_CFG_REG_00_TUNING_TT_CNT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_TUNING_CFG_REG_00_TUNING_TT_CNT_MASK) >> SDMMC3_2P_TUNING_CFG_REG_00_TUNING_TT_CNT_SHIFT)
#define  SDMMC3_2P_TUNING_CFG_REG_00_TUNING_TT_CNT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_TUNING_CFG_REG_00_TUNING_TT_CNT_MASK) | (((uint16_t)val) << SDMMC3_2P_TUNING_CFG_REG_00_TUNING_TT_CNT_SHIFT))

//====================================================================
//Register: Tuning Configuration Register (Low) (Instance 2 of 2) (TUNING_CFG_REG_01)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_TUNING_CFG_REG_01_TUNING_CLK_DLY0_MASK 0xc000
#define  SDMMC3_2P_TUNING_CFG_REG_01_TUNING_CLK_DLY0_SHIFT 14
#define  SDMMC3_2P_TUNING_CFG_REG_01_TUNING_CLK_DLY0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_TUNING_CFG_REG_01_TUNING_CLK_DLY0_MASK) >> SDMMC3_2P_TUNING_CFG_REG_01_TUNING_CLK_DLY0_SHIFT)
#define  SDMMC3_2P_TUNING_CFG_REG_01_TUNING_CLK_DLY0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_TUNING_CFG_REG_01_TUNING_CLK_DLY0_MASK) | (((uint16_t)val) << SDMMC3_2P_TUNING_CFG_REG_01_TUNING_CLK_DLY0_SHIFT))

#define  SDMMC3_2P_TUNING_CFG_REG_01_TUNING_WD_CNT_MASK 0x3f00
#define  SDMMC3_2P_TUNING_CFG_REG_01_TUNING_WD_CNT_SHIFT 8
#define  SDMMC3_2P_TUNING_CFG_REG_01_TUNING_WD_CNT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_TUNING_CFG_REG_01_TUNING_WD_CNT_MASK) >> SDMMC3_2P_TUNING_CFG_REG_01_TUNING_WD_CNT_SHIFT)
#define  SDMMC3_2P_TUNING_CFG_REG_01_TUNING_WD_CNT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_TUNING_CFG_REG_01_TUNING_WD_CNT_MASK) | (((uint16_t)val) << SDMMC3_2P_TUNING_CFG_REG_01_TUNING_WD_CNT_SHIFT))

#define  SDMMC3_2P_TUNING_CFG_REG_01_TUNING_TT_CNT_MASK 0xff
#define  SDMMC3_2P_TUNING_CFG_REG_01_TUNING_TT_CNT_SHIFT 0
#define  SDMMC3_2P_TUNING_CFG_REG_01_TUNING_TT_CNT_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_TUNING_CFG_REG_01_TUNING_TT_CNT_MASK) >> SDMMC3_2P_TUNING_CFG_REG_01_TUNING_TT_CNT_SHIFT)
#define  SDMMC3_2P_TUNING_CFG_REG_01_TUNING_TT_CNT_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_TUNING_CFG_REG_01_TUNING_TT_CNT_MASK) | (((uint16_t)val) << SDMMC3_2P_TUNING_CFG_REG_01_TUNING_TT_CNT_SHIFT))

//====================================================================
//Register: Tuning Configuration Register (HIGH) (Instance 1 of 2) (TUNING_CFG_REG_10)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_TUNING_CFG_REG_10_RESERVED2_MASK 0xc000
#define  SDMMC3_2P_TUNING_CFG_REG_10_RESERVED2_SHIFT 14
#define  SDMMC3_2P_TUNING_CFG_REG_10_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_TUNING_CFG_REG_10_RESERVED2_MASK) >> SDMMC3_2P_TUNING_CFG_REG_10_RESERVED2_SHIFT)
#define  SDMMC3_2P_TUNING_CFG_REG_10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_TUNING_CFG_REG_10_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_TUNING_CFG_REG_10_RESERVED2_SHIFT))

#define  SDMMC3_2P_TUNING_CFG_REG_10_TUNING_SUCCESS_CN_MASK 0x3f00
#define  SDMMC3_2P_TUNING_CFG_REG_10_TUNING_SUCCESS_CN_SHIFT 8
#define  SDMMC3_2P_TUNING_CFG_REG_10_TUNING_SUCCESS_CN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_TUNING_CFG_REG_10_TUNING_SUCCESS_CN_MASK) >> SDMMC3_2P_TUNING_CFG_REG_10_TUNING_SUCCESS_CN_SHIFT)
#define  SDMMC3_2P_TUNING_CFG_REG_10_TUNING_SUCCESS_CN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_TUNING_CFG_REG_10_TUNING_SUCCESS_CN_MASK) | (((uint16_t)val) << SDMMC3_2P_TUNING_CFG_REG_10_TUNING_SUCCESS_CN_SHIFT))

#define  SDMMC3_2P_TUNING_CFG_REG_10_TUNING_CLK_DLY1_MASK 0xff
#define  SDMMC3_2P_TUNING_CFG_REG_10_TUNING_CLK_DLY1_SHIFT 0
#define  SDMMC3_2P_TUNING_CFG_REG_10_TUNING_CLK_DLY1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_TUNING_CFG_REG_10_TUNING_CLK_DLY1_MASK) >> SDMMC3_2P_TUNING_CFG_REG_10_TUNING_CLK_DLY1_SHIFT)
#define  SDMMC3_2P_TUNING_CFG_REG_10_TUNING_CLK_DLY1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_TUNING_CFG_REG_10_TUNING_CLK_DLY1_MASK) | (((uint16_t)val) << SDMMC3_2P_TUNING_CFG_REG_10_TUNING_CLK_DLY1_SHIFT))

//====================================================================
//Register: Tuning Configuration Register (HIGH) (Instance 2 of 2) (TUNING_CFG_REG_11)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_TUNING_CFG_REG_11_RESERVED2_MASK 0xc000
#define  SDMMC3_2P_TUNING_CFG_REG_11_RESERVED2_SHIFT 14
#define  SDMMC3_2P_TUNING_CFG_REG_11_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_TUNING_CFG_REG_11_RESERVED2_MASK) >> SDMMC3_2P_TUNING_CFG_REG_11_RESERVED2_SHIFT)
#define  SDMMC3_2P_TUNING_CFG_REG_11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_TUNING_CFG_REG_11_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_TUNING_CFG_REG_11_RESERVED2_SHIFT))

#define  SDMMC3_2P_TUNING_CFG_REG_11_TUNING_SUCCESS_CN_MASK 0x3f00
#define  SDMMC3_2P_TUNING_CFG_REG_11_TUNING_SUCCESS_CN_SHIFT 8
#define  SDMMC3_2P_TUNING_CFG_REG_11_TUNING_SUCCESS_CN_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_TUNING_CFG_REG_11_TUNING_SUCCESS_CN_MASK) >> SDMMC3_2P_TUNING_CFG_REG_11_TUNING_SUCCESS_CN_SHIFT)
#define  SDMMC3_2P_TUNING_CFG_REG_11_TUNING_SUCCESS_CN_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_TUNING_CFG_REG_11_TUNING_SUCCESS_CN_MASK) | (((uint16_t)val) << SDMMC3_2P_TUNING_CFG_REG_11_TUNING_SUCCESS_CN_SHIFT))

#define  SDMMC3_2P_TUNING_CFG_REG_11_TUNING_CLK_DLY1_MASK 0xff
#define  SDMMC3_2P_TUNING_CFG_REG_11_TUNING_CLK_DLY1_SHIFT 0
#define  SDMMC3_2P_TUNING_CFG_REG_11_TUNING_CLK_DLY1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_TUNING_CFG_REG_11_TUNING_CLK_DLY1_MASK) >> SDMMC3_2P_TUNING_CFG_REG_11_TUNING_CLK_DLY1_SHIFT)
#define  SDMMC3_2P_TUNING_CFG_REG_11_TUNING_CLK_DLY1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_TUNING_CFG_REG_11_TUNING_CLK_DLY1_MASK) | (((uint16_t)val) << SDMMC3_2P_TUNING_CFG_REG_11_TUNING_CLK_DLY1_SHIFT))

//====================================================================
//Register: Debug Register 0 (Low) (Instance 1 of 2) (SD_DBG_000)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_000_TIMESTAMP0_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_000_TIMESTAMP0_SHIFT 0
#define  SDMMC3_2P_SD_DBG_000_TIMESTAMP0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_000_TIMESTAMP0_MASK) >> SDMMC3_2P_SD_DBG_000_TIMESTAMP0_SHIFT)
#define  SDMMC3_2P_SD_DBG_000_TIMESTAMP0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_000_TIMESTAMP0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_000_TIMESTAMP0_SHIFT))

//====================================================================
//Register: Debug Register 0 (Low) (Instance 2 of 2) (SD_DBG_001)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_001_TIMESTAMP0_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_001_TIMESTAMP0_SHIFT 0
#define  SDMMC3_2P_SD_DBG_001_TIMESTAMP0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_001_TIMESTAMP0_MASK) >> SDMMC3_2P_SD_DBG_001_TIMESTAMP0_SHIFT)
#define  SDMMC3_2P_SD_DBG_001_TIMESTAMP0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_001_TIMESTAMP0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_001_TIMESTAMP0_SHIFT))

//====================================================================
//Register: Debug Register 0 (High) (Instance 1 of 2) (SD_DBG_010)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_010_TIMESTAMP1_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_010_TIMESTAMP1_SHIFT 0
#define  SDMMC3_2P_SD_DBG_010_TIMESTAMP1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_010_TIMESTAMP1_MASK) >> SDMMC3_2P_SD_DBG_010_TIMESTAMP1_SHIFT)
#define  SDMMC3_2P_SD_DBG_010_TIMESTAMP1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_010_TIMESTAMP1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_010_TIMESTAMP1_SHIFT))

//====================================================================
//Register: Debug Register 0 (High) (Instance 2 of 2) (SD_DBG_011)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_011_TIMESTAMP1_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_011_TIMESTAMP1_SHIFT 0
#define  SDMMC3_2P_SD_DBG_011_TIMESTAMP1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_011_TIMESTAMP1_MASK) >> SDMMC3_2P_SD_DBG_011_TIMESTAMP1_SHIFT)
#define  SDMMC3_2P_SD_DBG_011_TIMESTAMP1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_011_TIMESTAMP1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_011_TIMESTAMP1_SHIFT))

//====================================================================
//Register: Debug Register 1 (Low) (Instance 1 of 2) (SD_DBG_100)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_100_DEBUG1_0_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_100_DEBUG1_0_SHIFT 0
#define  SDMMC3_2P_SD_DBG_100_DEBUG1_0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_100_DEBUG1_0_MASK) >> SDMMC3_2P_SD_DBG_100_DEBUG1_0_SHIFT)
#define  SDMMC3_2P_SD_DBG_100_DEBUG1_0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_100_DEBUG1_0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_100_DEBUG1_0_SHIFT))

//====================================================================
//Register: Debug Register 1 (Low) (Instance 2 of 2) (SD_DBG_101)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_101_DEBUG1_0_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_101_DEBUG1_0_SHIFT 0
#define  SDMMC3_2P_SD_DBG_101_DEBUG1_0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_101_DEBUG1_0_MASK) >> SDMMC3_2P_SD_DBG_101_DEBUG1_0_SHIFT)
#define  SDMMC3_2P_SD_DBG_101_DEBUG1_0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_101_DEBUG1_0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_101_DEBUG1_0_SHIFT))

//====================================================================
//Register: Debug Register 1 (High) (Instance 1 of 2) (SD_DBG_110)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_110_DEBUG1_1_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_110_DEBUG1_1_SHIFT 0
#define  SDMMC3_2P_SD_DBG_110_DEBUG1_1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_110_DEBUG1_1_MASK) >> SDMMC3_2P_SD_DBG_110_DEBUG1_1_SHIFT)
#define  SDMMC3_2P_SD_DBG_110_DEBUG1_1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_110_DEBUG1_1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_110_DEBUG1_1_SHIFT))

//====================================================================
//Register: Debug Register 1 (High) (Instance 2 of 2) (SD_DBG_111)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_111_DEBUG1_1_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_111_DEBUG1_1_SHIFT 0
#define  SDMMC3_2P_SD_DBG_111_DEBUG1_1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_111_DEBUG1_1_MASK) >> SDMMC3_2P_SD_DBG_111_DEBUG1_1_SHIFT)
#define  SDMMC3_2P_SD_DBG_111_DEBUG1_1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_111_DEBUG1_1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_111_DEBUG1_1_SHIFT))

//====================================================================
//Register: Debug Register 2 (Low) (Instance 1 of 2) (SD_DBG_200)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_200_TIMESTAMP0_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_200_TIMESTAMP0_SHIFT 0
#define  SDMMC3_2P_SD_DBG_200_TIMESTAMP0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_200_TIMESTAMP0_MASK) >> SDMMC3_2P_SD_DBG_200_TIMESTAMP0_SHIFT)
#define  SDMMC3_2P_SD_DBG_200_TIMESTAMP0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_200_TIMESTAMP0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_200_TIMESTAMP0_SHIFT))

//====================================================================
//Register: Debug Register 2 (Low) (Instance 2 of 2) (SD_DBG_201)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_201_TIMESTAMP0_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_201_TIMESTAMP0_SHIFT 0
#define  SDMMC3_2P_SD_DBG_201_TIMESTAMP0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_201_TIMESTAMP0_MASK) >> SDMMC3_2P_SD_DBG_201_TIMESTAMP0_SHIFT)
#define  SDMMC3_2P_SD_DBG_201_TIMESTAMP0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_201_TIMESTAMP0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_201_TIMESTAMP0_SHIFT))

//====================================================================
//Register: Debug Register 2 (High) (Instance 1 of 2) (SD_DBG_210)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_210_TIMESTAMP1_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_210_TIMESTAMP1_SHIFT 0
#define  SDMMC3_2P_SD_DBG_210_TIMESTAMP1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_210_TIMESTAMP1_MASK) >> SDMMC3_2P_SD_DBG_210_TIMESTAMP1_SHIFT)
#define  SDMMC3_2P_SD_DBG_210_TIMESTAMP1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_210_TIMESTAMP1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_210_TIMESTAMP1_SHIFT))

//====================================================================
//Register: Debug Register 2 (High) (Instance 2 of 2) (SD_DBG_211)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_211_TIMESTAMP1_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_211_TIMESTAMP1_SHIFT 0
#define  SDMMC3_2P_SD_DBG_211_TIMESTAMP1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_211_TIMESTAMP1_MASK) >> SDMMC3_2P_SD_DBG_211_TIMESTAMP1_SHIFT)
#define  SDMMC3_2P_SD_DBG_211_TIMESTAMP1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_211_TIMESTAMP1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_211_TIMESTAMP1_SHIFT))

//====================================================================
//Register: Debug Register 3 (Low) (Instance 1 of 2) (SD_DBG_300)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_300_DEBUG3_0_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_300_DEBUG3_0_SHIFT 0
#define  SDMMC3_2P_SD_DBG_300_DEBUG3_0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_300_DEBUG3_0_MASK) >> SDMMC3_2P_SD_DBG_300_DEBUG3_0_SHIFT)
#define  SDMMC3_2P_SD_DBG_300_DEBUG3_0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_300_DEBUG3_0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_300_DEBUG3_0_SHIFT))

//====================================================================
//Register: Debug Register 3 (Low) (Instance 2 of 2) (SD_DBG_301)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_301_DEBUG3_0_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_301_DEBUG3_0_SHIFT 0
#define  SDMMC3_2P_SD_DBG_301_DEBUG3_0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_301_DEBUG3_0_MASK) >> SDMMC3_2P_SD_DBG_301_DEBUG3_0_SHIFT)
#define  SDMMC3_2P_SD_DBG_301_DEBUG3_0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_301_DEBUG3_0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_301_DEBUG3_0_SHIFT))

//====================================================================
//Register: Debug Register 3 (High) (Instance 1 of 2) (SD_DBG_310)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_310_RESERVED2_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_310_RESERVED2_SHIFT 0
#define  SDMMC3_2P_SD_DBG_310_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_310_RESERVED2_MASK) >> SDMMC3_2P_SD_DBG_310_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_DBG_310_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_310_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_310_RESERVED2_SHIFT))

//====================================================================
//Register: Debug Register 3 (High) (Instance 2 of 2) (SD_DBG_311)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_311_RESERVED2_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_311_RESERVED2_SHIFT 0
#define  SDMMC3_2P_SD_DBG_311_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_311_RESERVED2_MASK) >> SDMMC3_2P_SD_DBG_311_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_DBG_311_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_311_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_311_RESERVED2_SHIFT))

//====================================================================
//Register: Debug Register 4 (Low) (Instance 1 of 2) (SD_DBG_400)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_400_TIMESTAMP0_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_400_TIMESTAMP0_SHIFT 0
#define  SDMMC3_2P_SD_DBG_400_TIMESTAMP0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_400_TIMESTAMP0_MASK) >> SDMMC3_2P_SD_DBG_400_TIMESTAMP0_SHIFT)
#define  SDMMC3_2P_SD_DBG_400_TIMESTAMP0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_400_TIMESTAMP0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_400_TIMESTAMP0_SHIFT))

//====================================================================
//Register: Debug Register 4 (Low) (Instance 2 of 2) (SD_DBG_401)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_401_TIMESTAMP0_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_401_TIMESTAMP0_SHIFT 0
#define  SDMMC3_2P_SD_DBG_401_TIMESTAMP0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_401_TIMESTAMP0_MASK) >> SDMMC3_2P_SD_DBG_401_TIMESTAMP0_SHIFT)
#define  SDMMC3_2P_SD_DBG_401_TIMESTAMP0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_401_TIMESTAMP0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_401_TIMESTAMP0_SHIFT))

//====================================================================
//Register: Debug Register 4 (High) (Instance 1 of 2) (SD_DBG_410)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_410_TIMESTAMP1_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_410_TIMESTAMP1_SHIFT 0
#define  SDMMC3_2P_SD_DBG_410_TIMESTAMP1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_410_TIMESTAMP1_MASK) >> SDMMC3_2P_SD_DBG_410_TIMESTAMP1_SHIFT)
#define  SDMMC3_2P_SD_DBG_410_TIMESTAMP1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_410_TIMESTAMP1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_410_TIMESTAMP1_SHIFT))

//====================================================================
//Register: Debug Register 4 (High) (Instance 2 of 2) (SD_DBG_411)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_411_TIMESTAMP1_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_411_TIMESTAMP1_SHIFT 0
#define  SDMMC3_2P_SD_DBG_411_TIMESTAMP1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_411_TIMESTAMP1_MASK) >> SDMMC3_2P_SD_DBG_411_TIMESTAMP1_SHIFT)
#define  SDMMC3_2P_SD_DBG_411_TIMESTAMP1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_411_TIMESTAMP1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_411_TIMESTAMP1_SHIFT))

//====================================================================
//Register: Debug Register 5 (Low) (Instance 1 of 2) (SD_DBG_500)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_500_RESERVED2_MASK 0xfc00
#define  SDMMC3_2P_SD_DBG_500_RESERVED2_SHIFT 10
#define  SDMMC3_2P_SD_DBG_500_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_500_RESERVED2_MASK) >> SDMMC3_2P_SD_DBG_500_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_DBG_500_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_500_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_500_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_DBG_500_DEBUG_5_0_MASK 0x3ff
#define  SDMMC3_2P_SD_DBG_500_DEBUG_5_0_SHIFT 0
#define  SDMMC3_2P_SD_DBG_500_DEBUG_5_0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_500_DEBUG_5_0_MASK) >> SDMMC3_2P_SD_DBG_500_DEBUG_5_0_SHIFT)
#define  SDMMC3_2P_SD_DBG_500_DEBUG_5_0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_500_DEBUG_5_0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_500_DEBUG_5_0_SHIFT))

//====================================================================
//Register: Debug Register 5 (Low) (Instance 2 of 2) (SD_DBG_501)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_501_RESERVED2_MASK 0xfc00
#define  SDMMC3_2P_SD_DBG_501_RESERVED2_SHIFT 10
#define  SDMMC3_2P_SD_DBG_501_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_501_RESERVED2_MASK) >> SDMMC3_2P_SD_DBG_501_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_DBG_501_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_501_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_501_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_DBG_501_DEBUG_5_0_MASK 0x3ff
#define  SDMMC3_2P_SD_DBG_501_DEBUG_5_0_SHIFT 0
#define  SDMMC3_2P_SD_DBG_501_DEBUG_5_0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_501_DEBUG_5_0_MASK) >> SDMMC3_2P_SD_DBG_501_DEBUG_5_0_SHIFT)
#define  SDMMC3_2P_SD_DBG_501_DEBUG_5_0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_501_DEBUG_5_0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_501_DEBUG_5_0_SHIFT))

//====================================================================
//Register: Debug Register 5 (High) (Instance 1 of 2) (SD_DBG_510)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_510_RESERVED2_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_510_RESERVED2_SHIFT 0
#define  SDMMC3_2P_SD_DBG_510_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_510_RESERVED2_MASK) >> SDMMC3_2P_SD_DBG_510_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_DBG_510_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_510_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_510_RESERVED2_SHIFT))

//====================================================================
//Register: Debug Register 5 (High) (Instance 2 of 2) (SD_DBG_511)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_511_RESERVED2_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_511_RESERVED2_SHIFT 0
#define  SDMMC3_2P_SD_DBG_511_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_511_RESERVED2_MASK) >> SDMMC3_2P_SD_DBG_511_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_DBG_511_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_511_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_511_RESERVED2_SHIFT))

//====================================================================
//Register: Debug Register 6 (Low) (Instance 1 of 2) (SD_DBG_600)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_600_DEBUG6_0_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_600_DEBUG6_0_SHIFT 0
#define  SDMMC3_2P_SD_DBG_600_DEBUG6_0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_600_DEBUG6_0_MASK) >> SDMMC3_2P_SD_DBG_600_DEBUG6_0_SHIFT)
#define  SDMMC3_2P_SD_DBG_600_DEBUG6_0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_600_DEBUG6_0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_600_DEBUG6_0_SHIFT))

//====================================================================
//Register: Debug Register 6 (Low) (Instance 2 of 2) (SD_DBG_601)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_601_DEBUG6_0_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_601_DEBUG6_0_SHIFT 0
#define  SDMMC3_2P_SD_DBG_601_DEBUG6_0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_601_DEBUG6_0_MASK) >> SDMMC3_2P_SD_DBG_601_DEBUG6_0_SHIFT)
#define  SDMMC3_2P_SD_DBG_601_DEBUG6_0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_601_DEBUG6_0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_601_DEBUG6_0_SHIFT))

//====================================================================
//Register: Debug Register 6 (High) (Instance 1 of 2) (SD_DBG_610)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_610_DEBUG6_1_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_610_DEBUG6_1_SHIFT 0
#define  SDMMC3_2P_SD_DBG_610_DEBUG6_1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_610_DEBUG6_1_MASK) >> SDMMC3_2P_SD_DBG_610_DEBUG6_1_SHIFT)
#define  SDMMC3_2P_SD_DBG_610_DEBUG6_1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_610_DEBUG6_1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_610_DEBUG6_1_SHIFT))

//====================================================================
//Register: Debug Register 6 (High) (Instance 2 of 2) (SD_DBG_611)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_611_DEBUG6_1_MASK 0xffff
#define  SDMMC3_2P_SD_DBG_611_DEBUG6_1_SHIFT 0
#define  SDMMC3_2P_SD_DBG_611_DEBUG6_1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_611_DEBUG6_1_MASK) >> SDMMC3_2P_SD_DBG_611_DEBUG6_1_SHIFT)
#define  SDMMC3_2P_SD_DBG_611_DEBUG6_1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_611_DEBUG6_1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_611_DEBUG6_1_SHIFT))

//====================================================================
//Register: Debug Register 7 (Low) (Instance 1 of 2) (SD_DBG_700)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_700_TUNING_CLK_DLY_MASK 0xff00
#define  SDMMC3_2P_SD_DBG_700_TUNING_CLK_DLY_SHIFT 8
#define  SDMMC3_2P_SD_DBG_700_TUNING_CLK_DLY_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_700_TUNING_CLK_DLY_MASK) >> SDMMC3_2P_SD_DBG_700_TUNING_CLK_DLY_SHIFT)
#define  SDMMC3_2P_SD_DBG_700_TUNING_CLK_DLY_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_700_TUNING_CLK_DLY_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_700_TUNING_CLK_DLY_SHIFT))

#define  SDMMC3_2P_SD_DBG_700_RESERVED2_MASK 0xf0
#define  SDMMC3_2P_SD_DBG_700_RESERVED2_SHIFT 4
#define  SDMMC3_2P_SD_DBG_700_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_700_RESERVED2_MASK) >> SDMMC3_2P_SD_DBG_700_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_DBG_700_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_700_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_700_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_DBG_700_TUNING_CLK_SEL1_MASK 0xc
#define  SDMMC3_2P_SD_DBG_700_TUNING_CLK_SEL1_SHIFT 2
#define  SDMMC3_2P_SD_DBG_700_TUNING_CLK_SEL1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_700_TUNING_CLK_SEL1_MASK) >> SDMMC3_2P_SD_DBG_700_TUNING_CLK_SEL1_SHIFT)
#define  SDMMC3_2P_SD_DBG_700_TUNING_CLK_SEL1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_700_TUNING_CLK_SEL1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_700_TUNING_CLK_SEL1_SHIFT))

#define  SDMMC3_2P_SD_DBG_700_TUNING_CLK_SEL0_MASK 0x3
#define  SDMMC3_2P_SD_DBG_700_TUNING_CLK_SEL0_SHIFT 0
#define  SDMMC3_2P_SD_DBG_700_TUNING_CLK_SEL0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_700_TUNING_CLK_SEL0_MASK) >> SDMMC3_2P_SD_DBG_700_TUNING_CLK_SEL0_SHIFT)
#define  SDMMC3_2P_SD_DBG_700_TUNING_CLK_SEL0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_700_TUNING_CLK_SEL0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_700_TUNING_CLK_SEL0_SHIFT))

//====================================================================
//Register: Debug Register 7 (Low) (Instance 2 of 2) (SD_DBG_701)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_701_TUNING_CLK_DLY_MASK 0xff00
#define  SDMMC3_2P_SD_DBG_701_TUNING_CLK_DLY_SHIFT 8
#define  SDMMC3_2P_SD_DBG_701_TUNING_CLK_DLY_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_701_TUNING_CLK_DLY_MASK) >> SDMMC3_2P_SD_DBG_701_TUNING_CLK_DLY_SHIFT)
#define  SDMMC3_2P_SD_DBG_701_TUNING_CLK_DLY_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_701_TUNING_CLK_DLY_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_701_TUNING_CLK_DLY_SHIFT))

#define  SDMMC3_2P_SD_DBG_701_RESERVED2_MASK 0xf0
#define  SDMMC3_2P_SD_DBG_701_RESERVED2_SHIFT 4
#define  SDMMC3_2P_SD_DBG_701_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_701_RESERVED2_MASK) >> SDMMC3_2P_SD_DBG_701_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_DBG_701_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_701_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_701_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_DBG_701_TUNING_CLK_SEL1_MASK 0xc
#define  SDMMC3_2P_SD_DBG_701_TUNING_CLK_SEL1_SHIFT 2
#define  SDMMC3_2P_SD_DBG_701_TUNING_CLK_SEL1_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_701_TUNING_CLK_SEL1_MASK) >> SDMMC3_2P_SD_DBG_701_TUNING_CLK_SEL1_SHIFT)
#define  SDMMC3_2P_SD_DBG_701_TUNING_CLK_SEL1_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_701_TUNING_CLK_SEL1_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_701_TUNING_CLK_SEL1_SHIFT))

#define  SDMMC3_2P_SD_DBG_701_TUNING_CLK_SEL0_MASK 0x3
#define  SDMMC3_2P_SD_DBG_701_TUNING_CLK_SEL0_SHIFT 0
#define  SDMMC3_2P_SD_DBG_701_TUNING_CLK_SEL0_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_701_TUNING_CLK_SEL0_MASK) >> SDMMC3_2P_SD_DBG_701_TUNING_CLK_SEL0_SHIFT)
#define  SDMMC3_2P_SD_DBG_701_TUNING_CLK_SEL0_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_701_TUNING_CLK_SEL0_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_701_TUNING_CLK_SEL0_SHIFT))

//====================================================================
//Register: Debug Register 7 (High) (Instance 1 of 2) (SD_DBG_710)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_710_RESERVED2_MASK 0xfffe
#define  SDMMC3_2P_SD_DBG_710_RESERVED2_SHIFT 1
#define  SDMMC3_2P_SD_DBG_710_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_710_RESERVED2_MASK) >> SDMMC3_2P_SD_DBG_710_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_DBG_710_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_710_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_710_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_DBG_710_TUNING_CLK_DLY_MASK 0x1
#define  SDMMC3_2P_SD_DBG_710_TUNING_CLK_DLY_SHIFT 0
#define  SDMMC3_2P_SD_DBG_710_TUNING_CLK_DLY_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_710_TUNING_CLK_DLY_MASK) >> SDMMC3_2P_SD_DBG_710_TUNING_CLK_DLY_SHIFT)
#define  SDMMC3_2P_SD_DBG_710_TUNING_CLK_DLY_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_710_TUNING_CLK_DLY_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_710_TUNING_CLK_DLY_SHIFT))

//====================================================================
//Register: Debug Register 7 (High) (Instance 2 of 2) (SD_DBG_711)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_SD_DBG_711_RESERVED2_MASK 0xfffe
#define  SDMMC3_2P_SD_DBG_711_RESERVED2_SHIFT 1
#define  SDMMC3_2P_SD_DBG_711_RESERVED2_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_711_RESERVED2_MASK) >> SDMMC3_2P_SD_DBG_711_RESERVED2_SHIFT)
#define  SDMMC3_2P_SD_DBG_711_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_711_RESERVED2_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_711_RESERVED2_SHIFT))

#define  SDMMC3_2P_SD_DBG_711_TUNING_CLK_DLY_MASK 0x1
#define  SDMMC3_2P_SD_DBG_711_TUNING_CLK_DLY_SHIFT 0
#define  SDMMC3_2P_SD_DBG_711_TUNING_CLK_DLY_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_SD_DBG_711_TUNING_CLK_DLY_MASK) >> SDMMC3_2P_SD_DBG_711_TUNING_CLK_DLY_SHIFT)
#define  SDMMC3_2P_SD_DBG_711_TUNING_CLK_DLY_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_SD_DBG_711_TUNING_CLK_DLY_MASK) | (((uint16_t)val) << SDMMC3_2P_SD_DBG_711_TUNING_CLK_DLY_SHIFT))

//====================================================================
//Register: Internal Version Register 0 (Low) (Instance 1 of 2) (INT_VER_000)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_INT_VER_000_MMC_VER_MASK 0xff00
#define  SDMMC3_2P_INT_VER_000_MMC_VER_SHIFT 8
#define  SDMMC3_2P_INT_VER_000_MMC_VER_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_INT_VER_000_MMC_VER_MASK) >> SDMMC3_2P_INT_VER_000_MMC_VER_SHIFT)
#define  SDMMC3_2P_INT_VER_000_MMC_VER_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_INT_VER_000_MMC_VER_MASK) | (((uint16_t)val) << SDMMC3_2P_INT_VER_000_MMC_VER_SHIFT))

#define  SDMMC3_2P_INT_VER_000_MID_MASK 0xff
#define  SDMMC3_2P_INT_VER_000_MID_SHIFT 0
#define  SDMMC3_2P_INT_VER_000_MID_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_INT_VER_000_MID_MASK) >> SDMMC3_2P_INT_VER_000_MID_SHIFT)
#define  SDMMC3_2P_INT_VER_000_MID_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_INT_VER_000_MID_MASK) | (((uint16_t)val) << SDMMC3_2P_INT_VER_000_MID_SHIFT))

//====================================================================
//Register: Internal Version Register 0 (Low) (Instance 2 of 2) (INT_VER_001)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_INT_VER_001_MMC_VER_MASK 0xff00
#define  SDMMC3_2P_INT_VER_001_MMC_VER_SHIFT 8
#define  SDMMC3_2P_INT_VER_001_MMC_VER_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_INT_VER_001_MMC_VER_MASK) >> SDMMC3_2P_INT_VER_001_MMC_VER_SHIFT)
#define  SDMMC3_2P_INT_VER_001_MMC_VER_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_INT_VER_001_MMC_VER_MASK) | (((uint16_t)val) << SDMMC3_2P_INT_VER_001_MMC_VER_SHIFT))

#define  SDMMC3_2P_INT_VER_001_MID_MASK 0xff
#define  SDMMC3_2P_INT_VER_001_MID_SHIFT 0
#define  SDMMC3_2P_INT_VER_001_MID_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_INT_VER_001_MID_MASK) >> SDMMC3_2P_INT_VER_001_MID_SHIFT)
#define  SDMMC3_2P_INT_VER_001_MID_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_INT_VER_001_MID_MASK) | (((uint16_t)val) << SDMMC3_2P_INT_VER_001_MID_SHIFT))

//====================================================================
//Register: Internal Version Register 0 (High) (Instance 1 of 2) (INT_VER_010)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_INT_VER_010_SD_VER_MASK 0xff00
#define  SDMMC3_2P_INT_VER_010_SD_VER_SHIFT 8
#define  SDMMC3_2P_INT_VER_010_SD_VER_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_INT_VER_010_SD_VER_MASK) >> SDMMC3_2P_INT_VER_010_SD_VER_SHIFT)
#define  SDMMC3_2P_INT_VER_010_SD_VER_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_INT_VER_010_SD_VER_MASK) | (((uint16_t)val) << SDMMC3_2P_INT_VER_010_SD_VER_SHIFT))

#define  SDMMC3_2P_INT_VER_010_MAJ_MASK 0xff
#define  SDMMC3_2P_INT_VER_010_MAJ_SHIFT 0
#define  SDMMC3_2P_INT_VER_010_MAJ_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_INT_VER_010_MAJ_MASK) >> SDMMC3_2P_INT_VER_010_MAJ_SHIFT)
#define  SDMMC3_2P_INT_VER_010_MAJ_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_INT_VER_010_MAJ_MASK) | (((uint16_t)val) << SDMMC3_2P_INT_VER_010_MAJ_SHIFT))

//====================================================================
//Register: Internal Version Register 0 (High) (Instance 2 of 2) (INT_VER_011)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_INT_VER_011_SD_VER_MASK 0xff00
#define  SDMMC3_2P_INT_VER_011_SD_VER_SHIFT 8
#define  SDMMC3_2P_INT_VER_011_SD_VER_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_INT_VER_011_SD_VER_MASK) >> SDMMC3_2P_INT_VER_011_SD_VER_SHIFT)
#define  SDMMC3_2P_INT_VER_011_SD_VER_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_INT_VER_011_SD_VER_MASK) | (((uint16_t)val) << SDMMC3_2P_INT_VER_011_SD_VER_SHIFT))

#define  SDMMC3_2P_INT_VER_011_MAJ_MASK 0xff
#define  SDMMC3_2P_INT_VER_011_MAJ_SHIFT 0
#define  SDMMC3_2P_INT_VER_011_MAJ_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_INT_VER_011_MAJ_MASK) >> SDMMC3_2P_INT_VER_011_MAJ_SHIFT)
#define  SDMMC3_2P_INT_VER_011_MAJ_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_INT_VER_011_MAJ_MASK) | (((uint16_t)val) << SDMMC3_2P_INT_VER_011_MAJ_SHIFT))

//====================================================================
//Register: Internal Version Register 1 (Low) (Instance 1 of 2) (INT_VER_100)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_INT_VER_100_CHIPID_MASK 0xffff
#define  SDMMC3_2P_INT_VER_100_CHIPID_SHIFT 0
#define  SDMMC3_2P_INT_VER_100_CHIPID_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_INT_VER_100_CHIPID_MASK) >> SDMMC3_2P_INT_VER_100_CHIPID_SHIFT)
#define  SDMMC3_2P_INT_VER_100_CHIPID_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_INT_VER_100_CHIPID_MASK) | (((uint16_t)val) << SDMMC3_2P_INT_VER_100_CHIPID_SHIFT))

//====================================================================
//Register: Internal Version Register 1 (Low) (Instance 2 of 2) (INT_VER_101)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_INT_VER_101_CHIPID_MASK 0xffff
#define  SDMMC3_2P_INT_VER_101_CHIPID_SHIFT 0
#define  SDMMC3_2P_INT_VER_101_CHIPID_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_INT_VER_101_CHIPID_MASK) >> SDMMC3_2P_INT_VER_101_CHIPID_SHIFT)
#define  SDMMC3_2P_INT_VER_101_CHIPID_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_INT_VER_101_CHIPID_MASK) | (((uint16_t)val) << SDMMC3_2P_INT_VER_101_CHIPID_SHIFT))

//====================================================================
//Register: Internal Version Register 1 (High) (Instance 1 of 2) (INT_VER_110)
/** \brief  (Instance 1 of 2)*/
//====================================================================

#define  SDMMC3_2P_INT_VER_110_SDIO_VER_MASK 0xff00
#define  SDMMC3_2P_INT_VER_110_SDIO_VER_SHIFT 8
#define  SDMMC3_2P_INT_VER_110_SDIO_VER_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_INT_VER_110_SDIO_VER_MASK) >> SDMMC3_2P_INT_VER_110_SDIO_VER_SHIFT)
#define  SDMMC3_2P_INT_VER_110_SDIO_VER_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_INT_VER_110_SDIO_VER_MASK) | (((uint16_t)val) << SDMMC3_2P_INT_VER_110_SDIO_VER_SHIFT))

#define  SDMMC3_2P_INT_VER_110_TS_MASK 0xff
#define  SDMMC3_2P_INT_VER_110_TS_SHIFT 0
#define  SDMMC3_2P_INT_VER_110_TS_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_INT_VER_110_TS_MASK) >> SDMMC3_2P_INT_VER_110_TS_SHIFT)
#define  SDMMC3_2P_INT_VER_110_TS_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_INT_VER_110_TS_MASK) | (((uint16_t)val) << SDMMC3_2P_INT_VER_110_TS_SHIFT))

//====================================================================
//Register: Internal Version Register 1 (High) (Instance 2 of 2) (INT_VER_111)
/** \brief  (Instance 2 of 2)*/
//====================================================================

#define  SDMMC3_2P_INT_VER_111_SDIO_VER_MASK 0xff00
#define  SDMMC3_2P_INT_VER_111_SDIO_VER_SHIFT 8
#define  SDMMC3_2P_INT_VER_111_SDIO_VER_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_INT_VER_111_SDIO_VER_MASK) >> SDMMC3_2P_INT_VER_111_SDIO_VER_SHIFT)
#define  SDMMC3_2P_INT_VER_111_SDIO_VER_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_INT_VER_111_SDIO_VER_MASK) | (((uint16_t)val) << SDMMC3_2P_INT_VER_111_SDIO_VER_SHIFT))

#define  SDMMC3_2P_INT_VER_111_TS_MASK 0xff
#define  SDMMC3_2P_INT_VER_111_TS_SHIFT 0
#define  SDMMC3_2P_INT_VER_111_TS_MASK_SHIFT(reg) (((reg) & SDMMC3_2P_INT_VER_111_TS_MASK) >> SDMMC3_2P_INT_VER_111_TS_SHIFT)
#define  SDMMC3_2P_INT_VER_111_TS_REPLACE_VAL(reg,val) (((reg) & ~SDMMC3_2P_INT_VER_111_TS_MASK) | (((uint16_t)val) << SDMMC3_2P_INT_VER_111_TS_SHIFT))

#endif // SDMMC3_2P
