 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _MPMU_TOP_REGSTRUCTS_H_
#define _MPMU_TOP_REGSTRUCTS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: Main PMU Register Set (MPMU_top)
/** \brief The Main PMU register set provides for control of the ANA_GRP oscillator module, the
    PLLs and associated spread spectrum control modules, the AVS module, the watchdog timer
    module, the real time clock module, and miscellaneous other power control related registers.*/
//
//====================================================================

//====================================================================
//
//Register File: Analog Group Oscillator Controls (ANA_GRP)
//
//====================================================================

typedef struct ANA_GRP_REGS_s
{
  volatile uint32_t pu_sel_test;  ///< 0x0 [R/W]: Reset, Power Up, Analog Test Point Control 
  volatile uint32_t divsel_misc;  ///< 0x4 [R/W]: Adjust, Gain, VREG select
  volatile uint32_t status;  ///< 0x8 [R]: PLL Status Output (observe only)
} ANA_GRP_REGS_t;

//====================================================================
//
//Register File: DDR PLL Controls (DDR_PLL)
//
//====================================================================

typedef struct DDR_PLL_REGS_s
{
  volatile uint32_t rst_prediv;  ///< 0x0 [R/W]: PLL reset & Pre-divider Register
  volatile uint32_t mult_postdiv;  ///< 0x4 [R/W]: PLL feedback multiplier
  volatile uint32_t kvco;  ///< 0x8 [R/W]: PLL gain control
  volatile uint32_t misc;  ///< 0xc [R/W]: PLL misc control
  volatile uint32_t feedback_mode_deskew;  ///< 0x10 [R/W]: PLL PFD (Phase Frequency Detector) input select, and de-skew application control
  volatile uint32_t offset_mode;  ///< 0x14 [R/W]: PLL offset frequency control
  volatile uint32_t fixed_mode_ssc_mode;  ///< 0x18 [R/W]: PLL enable
  volatile uint32_t ssc_freq_ssc_range;  ///< 0x1c [R/W]: PLL Modulation Frequency
  volatile uint32_t clk_ctrl_marvell_test;  ///< 0x20 [R/W]: PLL Output Clock Control
  volatile uint32_t lock_status;  ///< 0x24 [R]: PLL Lock Status
  volatile uint32_t reserve_out;  ///< 0x28 [R]: PLL RESERVE_OUT output
} DDR_PLL_REGS_t;

//====================================================================
//
//Register File: DDR PLL Spread Spectrum Controls (DDR_PLL_CSSCG)
/** \brief Top-level register file for the CSSCG block*/
//
//====================================================================

typedef struct DDR_PLL_CSSCG_REGS_s
{
  volatile uint32_t IRQ_EN;  ///< 0x0 [R/W]: Interrupt Enable Register
  volatile uint32_t IRQ_PEND;  ///< 0x4 [R]: Interrupt Pending Register
  volatile uint32_t IRQ_ACK;  ///< 0x8 [W]: Interrupt Acknowledge Register
  volatile uint32_t IRQ_FORCE;  ///< 0xc [W]: Interrupt Force Register
  volatile uint32_t MODE_CONFIG;  ///< 0x10 [R/W]: CSSCG Mode Configuration Register
  volatile uint32_t HALT_CONFIG;  ///< 0x14 [R/W]: CSSCG Halt Configuration Register
  volatile uint32_t SB_OVER;  ///< 0x18 [R/W]: CSSCG Sign Bit Override Register
  volatile uint32_t CONTROL;  ///< 0x1c [R/W]: CSSCG Control Register
  volatile uint32_t STATUS_MST_SYNC;  ///< 0x20 [R]: CSSCG Master Sync Status Register
  volatile uint32_t STATUS_SLV_SYNC_0;  ///< 0x24 [R]: CSSCG Slave Sync Status Register 0
  volatile uint32_t reserved0;
  volatile uint32_t STATUS_CODE;  ///< 0x2c [R]: CSSCG Code Status
  volatile uint32_t SLV_N_FULL_A;  ///< 0x30 [R/W]: CSSCG Config A Slave Mode Full Cycle Count Config
  volatile uint32_t SLV_END_CONFIG_A;  ///< 0x34 [R/W]: CSSCG Config A Slave Mode End Configuration Register
  volatile uint32_t SLV_RTZ_A;  ///< 0x38 [R/W]: CSSCG Config A Slave Mode Return-to-Zero Register
  volatile uint32_t reserved1;
  volatile uint32_t SLV_N_FULL_B;  ///< 0x40 [R/W]: CSSCG Config B Slave Mode Full Cycle Count Config
  volatile uint32_t SLV_END_CONFIG_B;  ///< 0x44 [R/W]: CSSCG Config B Slave Mode End Configuration Register
  volatile uint32_t SLV_RTZ_B;  ///< 0x48 [R/W]: CSSCG Config B Slave Mode Return-to-Zero Register
  volatile uint32_t reserved2;
  volatile uint32_t SLV_TRIG_SEL;  ///< 0x50 [R/W]: CSSCG Slave Mode Trigger Select Register
  volatile uint32_t SLV_TIMEOUT;  ///< 0x54 [R/W]: CSSCG Slave Mode Timeout Register
  volatile uint32_t SLV_DEBUG_0;  ///< 0x58 [R/W]: CSSCG Slave Mode Debug 0 Register
  volatile uint32_t SLV_DEBUG_1;  ///< 0x5c [W]: CSSCG Slave Mode Debug 1 Register
  volatile uint32_t TRIG_DEBUG_0;  ///< 0x60 [R/W]: CSSCG Trigger Debug 0 Register
  volatile uint32_t TRIG_DEBUG_1;  ///< 0x64 [R]: CSSCG Trigger Debug 1 Register
  volatile uint32_t TRIG_DEBUG_2;  ///< 0x68 [R]: CSSCG Trigger Debug 2 Register
  volatile uint32_t TRIG_DEBUG_3;  ///< 0x6c [R]: CSSCG Trigger Debug 3 Register
  volatile uint32_t reserved3[2];
  volatile uint32_t REV0;  ///< 0x78 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x7c [R]: IP Tagging Revision 1
  volatile uint32_t reserved4[224];
  volatile uint32_t CSSCG_RAM[64];  ///< 0x400 [R/W]: CSSCG RAM Access Register
} DDR_PLL_CSSCG_REGS_t;

//====================================================================
//
//Register File: SYS PLL Controls (SYS_PLL)
//
//====================================================================

typedef struct SYS_PLL_REGS_s
{
  volatile uint32_t rst_prediv;  ///< 0x0 [R/W]: PLL reset & Pre-divider Register
  volatile uint32_t mult_postdiv;  ///< 0x4 [R/W]: PLL feedback multiplier
  volatile uint32_t kvco;  ///< 0x8 [R/W]: PLL gain control
  volatile uint32_t misc;  ///< 0xc [R/W]: PLL misc control
  volatile uint32_t feedback_mode_deskew;  ///< 0x10 [R/W]: PLL PFD (Phase Frequency Detector) input select, and de-skew application control
  volatile uint32_t offset_mode;  ///< 0x14 [R/W]: PLL offset frequency control
  volatile uint32_t fixed_mode_ssc_mode;  ///< 0x18 [R/W]: PLL enable
  volatile uint32_t ssc_freq_ssc_range;  ///< 0x1c [R/W]: PLL Modulation Frequency
  volatile uint32_t clk_ctrl_marvell_test;  ///< 0x20 [R/W]: PLL Output Clock Control
  volatile uint32_t lock_status;  ///< 0x24 [R]: PLL Lock Status
  volatile uint32_t reserve_out;  ///< 0x28 [R]: PLL RESERVE_OUT output
} SYS_PLL_REGS_t;

//====================================================================
//
//Register File: CORE PLL Controls (CORE_PLL)
//
//====================================================================

typedef struct CORE_PLL_REGS_s
{
  volatile uint32_t rst_prediv;  ///< 0x0 [R/W]: PLL reset & Pre-divider Register
  volatile uint32_t mult_postdiv;  ///< 0x4 [R/W]: PLL feedback multiplier
  volatile uint32_t kvco;  ///< 0x8 [R/W]: PLL gain control
  volatile uint32_t misc;  ///< 0xc [R/W]: PLL misc control
  volatile uint32_t feedback_mode_deskew;  ///< 0x10 [R/W]: PLL PFD (Phase Frequency Detector) input select, and de-skew application control
  volatile uint32_t offset_mode;  ///< 0x14 [R/W]: PLL offset frequency control
  volatile uint32_t fixed_mode_ssc_mode;  ///< 0x18 [R/W]: PLL enable
  volatile uint32_t ssc_freq_ssc_range;  ///< 0x1c [R/W]: PLL Modulation Frequency
  volatile uint32_t clk_ctrl_marvell_test;  ///< 0x20 [R/W]: PLL Output Clock Control
  volatile uint32_t lock_status;  ///< 0x24 [R]: PLL Lock Status
  volatile uint32_t reserve_out;  ///< 0x28 [R]: PLL RESERVE_OUT output
} CORE_PLL_REGS_t;

//====================================================================
//
//Register File: CORE PLL Spread Spectrum Controls (CORE_PLL_CSSCG)
/** \brief Top-level register file for the CSSCG block*/
//
//====================================================================

typedef struct CORE_PLL_CSSCG_REGS_s
{
  volatile uint32_t IRQ_EN;  ///< 0x0 [R/W]: Interrupt Enable Register
  volatile uint32_t IRQ_PEND;  ///< 0x4 [R]: Interrupt Pending Register
  volatile uint32_t IRQ_ACK;  ///< 0x8 [W]: Interrupt Acknowledge Register
  volatile uint32_t IRQ_FORCE;  ///< 0xc [W]: Interrupt Force Register
  volatile uint32_t MODE_CONFIG;  ///< 0x10 [R/W]: CSSCG Mode Configuration Register
  volatile uint32_t HALT_CONFIG;  ///< 0x14 [R/W]: CSSCG Halt Configuration Register
  volatile uint32_t SB_OVER;  ///< 0x18 [R/W]: CSSCG Sign Bit Override Register
  volatile uint32_t CONTROL;  ///< 0x1c [R/W]: CSSCG Control Register
  volatile uint32_t STATUS_MST_SYNC;  ///< 0x20 [R]: CSSCG Master Sync Status Register
  volatile uint32_t STATUS_SLV_SYNC_0;  ///< 0x24 [R]: CSSCG Slave Sync Status Register 0
  volatile uint32_t reserved0;
  volatile uint32_t STATUS_CODE;  ///< 0x2c [R]: CSSCG Code Status
  volatile uint32_t SLV_N_FULL_A;  ///< 0x30 [R/W]: CSSCG Config A Slave Mode Full Cycle Count Config
  volatile uint32_t SLV_END_CONFIG_A;  ///< 0x34 [R/W]: CSSCG Config A Slave Mode End Configuration Register
  volatile uint32_t SLV_RTZ_A;  ///< 0x38 [R/W]: CSSCG Config A Slave Mode Return-to-Zero Register
  volatile uint32_t reserved1;
  volatile uint32_t SLV_N_FULL_B;  ///< 0x40 [R/W]: CSSCG Config B Slave Mode Full Cycle Count Config
  volatile uint32_t SLV_END_CONFIG_B;  ///< 0x44 [R/W]: CSSCG Config B Slave Mode End Configuration Register
  volatile uint32_t SLV_RTZ_B;  ///< 0x48 [R/W]: CSSCG Config B Slave Mode Return-to-Zero Register
  volatile uint32_t reserved2;
  volatile uint32_t SLV_TRIG_SEL;  ///< 0x50 [R/W]: CSSCG Slave Mode Trigger Select Register
  volatile uint32_t SLV_TIMEOUT;  ///< 0x54 [R/W]: CSSCG Slave Mode Timeout Register
  volatile uint32_t SLV_DEBUG_0;  ///< 0x58 [R/W]: CSSCG Slave Mode Debug 0 Register
  volatile uint32_t SLV_DEBUG_1;  ///< 0x5c [W]: CSSCG Slave Mode Debug 1 Register
  volatile uint32_t TRIG_DEBUG_0;  ///< 0x60 [R/W]: CSSCG Trigger Debug 0 Register
  volatile uint32_t TRIG_DEBUG_1;  ///< 0x64 [R]: CSSCG Trigger Debug 1 Register
  volatile uint32_t TRIG_DEBUG_2;  ///< 0x68 [R]: CSSCG Trigger Debug 2 Register
  volatile uint32_t TRIG_DEBUG_3;  ///< 0x6c [R]: CSSCG Trigger Debug 3 Register
  volatile uint32_t reserved3[2];
  volatile uint32_t REV0;  ///< 0x78 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x7c [R]: IP Tagging Revision 1
  volatile uint32_t reserved4[224];
  volatile uint32_t CSSCG_RAM[64];  ///< 0x400 [R/W]: CSSCG RAM Access Register
} CORE_PLL_CSSCG_REGS_t;

//====================================================================
//
//Register File: SCAN PLL Controls (SCAN_PLL)
//
//====================================================================

typedef struct SCAN_PLL_REGS_s
{
  volatile uint32_t rst_prediv;  ///< 0x0 [R/W]: PLL reset & Pre-divider Register
  volatile uint32_t mult_postdiv;  ///< 0x4 [R/W]: PLL feedback multiplier
  volatile uint32_t kvco;  ///< 0x8 [R/W]: PLL gain control
  volatile uint32_t misc;  ///< 0xc [R/W]: PLL misc control
  volatile uint32_t feedback_mode_deskew;  ///< 0x10 [R/W]: PLL PFD (Phase Frequency Detector) input select, and de-skew application control
  volatile uint32_t offset_mode;  ///< 0x14 [R/W]: PLL offset frequency control
  volatile uint32_t fixed_mode_ssc_mode;  ///< 0x18 [R/W]: PLL enable
  volatile uint32_t ssc_freq_ssc_range;  ///< 0x1c [R/W]: PLL Modulation Frequency
  volatile uint32_t clk_ctrl_marvell_test;  ///< 0x20 [R/W]: PLL Output Clock Control
  volatile uint32_t lock_status;  ///< 0x24 [R]: PLL Lock Status
  volatile uint32_t reserve_out;  ///< 0x28 [R]: PLL RESERVE_OUT output
} SCAN_PLL_REGS_t;

//====================================================================
//
//Register File: SCAN PLL Spread Spectrum Controls (SCAN_PLL_CSSCG)
/** \brief Top-level register file for the CSSCG block*/
//
//====================================================================

typedef struct SCAN_PLL_CSSCG_REGS_s
{
  volatile uint32_t IRQ_EN;  ///< 0x0 [R/W]: Interrupt Enable Register
  volatile uint32_t IRQ_PEND;  ///< 0x4 [R]: Interrupt Pending Register
  volatile uint32_t IRQ_ACK;  ///< 0x8 [W]: Interrupt Acknowledge Register
  volatile uint32_t IRQ_FORCE;  ///< 0xc [W]: Interrupt Force Register
  volatile uint32_t MODE_CONFIG;  ///< 0x10 [R/W]: CSSCG Mode Configuration Register
  volatile uint32_t HALT_CONFIG;  ///< 0x14 [R/W]: CSSCG Halt Configuration Register
  volatile uint32_t SB_OVER;  ///< 0x18 [R/W]: CSSCG Sign Bit Override Register
  volatile uint32_t CONTROL;  ///< 0x1c [R/W]: CSSCG Control Register
  volatile uint32_t STATUS_MST_SYNC;  ///< 0x20 [R]: CSSCG Master Sync Status Register
  volatile uint32_t STATUS_SLV_SYNC_0;  ///< 0x24 [R]: CSSCG Slave Sync Status Register 0
  volatile uint32_t reserved0;
  volatile uint32_t STATUS_CODE;  ///< 0x2c [R]: CSSCG Code Status
  volatile uint32_t SLV_N_FULL_A;  ///< 0x30 [R/W]: CSSCG Config A Slave Mode Full Cycle Count Config
  volatile uint32_t SLV_END_CONFIG_A;  ///< 0x34 [R/W]: CSSCG Config A Slave Mode End Configuration Register
  volatile uint32_t SLV_RTZ_A;  ///< 0x38 [R/W]: CSSCG Config A Slave Mode Return-to-Zero Register
  volatile uint32_t reserved1;
  volatile uint32_t SLV_N_FULL_B;  ///< 0x40 [R/W]: CSSCG Config B Slave Mode Full Cycle Count Config
  volatile uint32_t SLV_END_CONFIG_B;  ///< 0x44 [R/W]: CSSCG Config B Slave Mode End Configuration Register
  volatile uint32_t SLV_RTZ_B;  ///< 0x48 [R/W]: CSSCG Config B Slave Mode Return-to-Zero Register
  volatile uint32_t reserved2;
  volatile uint32_t SLV_TRIG_SEL;  ///< 0x50 [R/W]: CSSCG Slave Mode Trigger Select Register
  volatile uint32_t SLV_TIMEOUT;  ///< 0x54 [R/W]: CSSCG Slave Mode Timeout Register
  volatile uint32_t SLV_DEBUG_0;  ///< 0x58 [R/W]: CSSCG Slave Mode Debug 0 Register
  volatile uint32_t SLV_DEBUG_1;  ///< 0x5c [W]: CSSCG Slave Mode Debug 1 Register
  volatile uint32_t TRIG_DEBUG_0;  ///< 0x60 [R/W]: CSSCG Trigger Debug 0 Register
  volatile uint32_t TRIG_DEBUG_1;  ///< 0x64 [R]: CSSCG Trigger Debug 1 Register
  volatile uint32_t TRIG_DEBUG_2;  ///< 0x68 [R]: CSSCG Trigger Debug 2 Register
  volatile uint32_t TRIG_DEBUG_3;  ///< 0x6c [R]: CSSCG Trigger Debug 3 Register
  volatile uint32_t reserved3[2];
  volatile uint32_t REV0;  ///< 0x78 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x7c [R]: IP Tagging Revision 1
  volatile uint32_t reserved4[224];
  volatile uint32_t CSSCG_RAM[64];  ///< 0x400 [R/W]: CSSCG RAM Access Register
} SCAN_PLL_CSSCG_REGS_t;

//====================================================================
//
//Register File: LVDSAFE PLL0 Controls (LVDSAFE_PLL0)
//
//====================================================================

typedef struct LVDSAFE_PLL0_REGS_s
{
  volatile uint32_t rst_prediv;  ///< 0x0 [R/W]: PLL reset & Pre-divider Register
  volatile uint32_t mult_postdiv;  ///< 0x4 [R/W]: PLL feedback multiplier
  volatile uint32_t kvco;  ///< 0x8 [R/W]: PLL gain control
  volatile uint32_t misc;  ///< 0xc [R/W]: PLL misc control
  volatile uint32_t feedback_mode_deskew;  ///< 0x10 [R/W]: PLL PFD (Phase Frequency Detector) input select, and de-skew application control
  volatile uint32_t offset_mode;  ///< 0x14 [R/W]: PLL offset frequency control
  volatile uint32_t fixed_mode_ssc_mode;  ///< 0x18 [R/W]: PLL enable
  volatile uint32_t ssc_freq_ssc_range;  ///< 0x1c [R/W]: PLL Modulation Frequency
  volatile uint32_t clk_ctrl_marvell_test;  ///< 0x20 [R/W]: PLL Output Clock Control
  volatile uint32_t lock_status;  ///< 0x24 [R]: PLL Lock Status
  volatile uint32_t reserve_out;  ///< 0x28 [R]: PLL RESERVE_OUT output
} LVDSAFE_PLL0_REGS_t;

//====================================================================
//
//Register File: LVDSAFE PLL1 Controls (LVDSAFE_PLL1)
//
//====================================================================

typedef struct LVDSAFE_PLL1_REGS_s
{
  volatile uint32_t rst_prediv;  ///< 0x0 [R/W]: PLL reset & Pre-divider Register
  volatile uint32_t mult_postdiv;  ///< 0x4 [R/W]: PLL feedback multiplier
  volatile uint32_t kvco;  ///< 0x8 [R/W]: PLL gain control
  volatile uint32_t misc;  ///< 0xc [R/W]: PLL misc control
  volatile uint32_t feedback_mode_deskew;  ///< 0x10 [R/W]: PLL PFD (Phase Frequency Detector) input select, and de-skew application control
  volatile uint32_t offset_mode;  ///< 0x14 [R/W]: PLL offset frequency control
  volatile uint32_t fixed_mode_ssc_mode;  ///< 0x18 [R/W]: PLL enable
  volatile uint32_t ssc_freq_ssc_range;  ///< 0x1c [R/W]: PLL Modulation Frequency
  volatile uint32_t clk_ctrl_marvell_test;  ///< 0x20 [R/W]: PLL Output Clock Control
  volatile uint32_t lock_status;  ///< 0x24 [R]: PLL Lock Status
  volatile uint32_t reserve_out;  ///< 0x28 [R]: PLL RESERVE_OUT output
} LVDSAFE_PLL1_REGS_t;

//====================================================================
//
//Register File: MPMU Clock/Reset Gen Controls (MPMU_ClkRstGen)
/** \brief These registers provide control/status for the clocks/resets for all of the clock domains
    in the Application Processing section of the chip.*/
//
//====================================================================

typedef struct MPMU_CLKRSTGEN_REGS_s
{
  volatile uint32_t MFPIDeglitchClkConfig_ClkGenConfig;  ///< 0x0 [R/W]: MFPIDeglitchClk ClkGen Configuration Register
  volatile uint32_t MFPIDeglitchClkConfig_ClkGenStatus;  ///< 0x4 [R]: MFPIDeglitchClk ClkGen Status Register
  volatile uint32_t CLK32KConfig_ClkGenConfig;  ///< 0x8 [R/W]: CLK32k ClkGen Configuration Register
  volatile uint32_t CLK32KConfig_ClkGenStatus;  ///< 0xc [R]: CLK32k ClkGen Status Register
  volatile uint32_t HipsClkConfig;  ///< 0x10 [R/W]: Hips Clock Configuration Register
  volatile uint32_t HipsClkStatus;  ///< 0x14 [R]: Hips Clock Status Register
  volatile uint32_t HiPWMClkConfig;  ///< 0x18 [R/W]: HiPWM Clock Configuration Register
  volatile uint32_t HiPWMClkStatus;  ///< 0x1c [R]: HiPWM Clock Status Register
  volatile uint32_t ResetCtl;  ///< 0x20 [R/W]: Reset Control Register
} MPMU_CLKRSTGEN_REGS_t;

//====================================================================
//
//Register File: MPMU Timer Control Registers (MPMU_timers)
/** \brief The APB TIMERS block provides programmable interval timers and watchdog. <BR>
The interval timers can be used to generate a repetitive period timer (for the RTO/S periodic tick interrupt), to time intervals (for switch presses, LED flashing, or fan speed), or for a watchdog reset. <BR>
Four identical programmable timers (Timer0, Timer1, Timer2, Timer3) are provided in the APB subsystem. Each timer generates a level interrupt when it reaches the final event, which can be programmed to be either a terminal count or an input pulse (on an external signal). When the final event is reached, the counter can restart at zero (continuous mode) or halt, depending on how it is configured. <BR>
Timer0 provides the watchdog function, and when enabled, the system will be reset if the watchdog timer reaches the final event. <BR>
The timer count is incremented on a selected input timebase. There are 8 choices of input timebases to select from: 1us, 10us, 100us, 1ms, 10ms and 100ms, the bus clock, and external input signal pulses. <BR>
To facilitate interval timing, the counter may be disabled to lock the count value that can then be read via the Timer Status Register. The counter is reset to zero and begins to increment when the Timer is re-enabled. <BR>
To assist system level functions, each timer can generate a signal that toggles when the final count is reached. The toggling signal is a periodic waveform that can be used within the SoC or be connected to the pins for further use by the system. <BR>*/
//
//====================================================================

typedef struct MPMU_TIMERS_REGS_s
{
  volatile uint32_t TWR0;  ///< 0x0 [R/W]: Timer0 Watchdog Register
  volatile uint32_t TTCR0;  ///< 0x4 [R/W]: Timer0 Terminal Count Register
  volatile uint32_t TCR0;  ///< 0x8 [R/W]: Timer0 Control Register
  volatile uint32_t TSR0;  ///< 0xc [R]: Timer0 Status Register
  volatile uint32_t TISR;  ///< 0x10 [R]: Timers Interrupt Status Register
  volatile uint32_t TTCR1;  ///< 0x14 [R/W]: Timer1 Terminal Count Register
  volatile uint32_t TCR1;  ///< 0x18 [R/W]: Timer1 Control Register
  volatile uint32_t TSR1;  ///< 0x1c [R]: Timer1 Status Register
  volatile uint32_t TIAR;  ///< 0x20 [W]: Timers Interrupt Acknowledge Register
  volatile uint32_t TTCR2;  ///< 0x24 [R/W]: Timer2 Terminal Count Register
  volatile uint32_t TCR2;  ///< 0x28 [R/W]: Timer2 Control Register
  volatile uint32_t TSR2;  ///< 0x2c [R]: Timer2 Status Register
  volatile uint32_t reserved0;
  volatile uint32_t TTCR3;  ///< 0x34 [R/W]: Timer3 Terminal Count Register
  volatile uint32_t TCR3;  ///< 0x38 [R/W]: Timer3 Control Register
  volatile uint32_t TSR3;  ///< 0x3c [R]: Timer3 Status Register
  volatile uint32_t REV0;  ///< 0x40 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x44 [R]: IP Tagging Revision 1
} MPMU_TIMERS_REGS_t;

//====================================================================
//
//Register File: Automatic Voltage Sense Control Registers (AVS)
/** \brief Registers for firmware configuration and status of MISL_0028LP_AVS hardmacro.
    <BR>
    <BR>
    The names of register fields are identical to the port names of the hardmacro model.
    See MISL_0028LP_AVS specification/datasheet document for usage of the register bits.*/
//
//====================================================================

typedef struct AVS_REGS_s
{
  volatile uint32_t Control;  ///< 0x0 [R/W]: AVS Control and Configuration register
  volatile uint32_t DeltaVoltage;  ///< 0x4 [R/W]: AVS Delta Voltage register
  volatile uint32_t VddLimit;  ///< 0x8 [R/W]: AVS VDD Limits register
  volatile uint32_t Calibration;  ///< 0xc [R/W]: AVS Internal Voltage and Bandgap Calibration register
  volatile uint32_t DroMode1;  ///< 0x10 [R/W]: DRO Mode 1 register
  volatile uint32_t DroMode2;  ///< 0x14 [R/W]: DRO Mode 2 register
  volatile uint32_t FastTravel;  ///< 0x18 [R/W]:  AVS Fast Travel Control and Configuration register
  volatile uint32_t Test;  ///< 0x1c [R/W]: AVS Test Configuration register
  volatile uint32_t reserved0;
  volatile uint32_t Status;  ///< 0x24 [R]: AVS Status register
  volatile uint32_t DeltaStatus;  ///< 0x28 [R]: AVS Delta Status register
  volatile uint32_t DroStatus1;  ///< 0x2c [R]: AVS DRO Status 1 register
  volatile uint32_t DroStatus2;  ///< 0x30 [R]: AVS DRO Status 2 register
  volatile uint32_t reserved1;
  volatile uint32_t REV0;  ///< 0x38 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x3c [R]: IP Tagging Revision 1
} AVS_REGS_t;

//====================================================================
//
//Register File: Real Time Clock Control Registers (RTC)
/** \brief (rev 0 . 1 . 1 . 1)
    Register Descriptions for the Swiss RTC.
    Since the interface to the RTC hard macro is only 8-bits wide,
    firmware MUST read each register twice. The first read updates a
    32-bit shadow in the RTC wrapper and the second read reads
    the 32-bit shadow.*/
//
//====================================================================

typedef struct RTC_REGS_s
{
  volatile uint32_t Status;  ///< 0x0 [R/W]: RTC Status Register
  volatile uint32_t Interrupt1;  ///< 0x4 [R/W]: RTC Interrupt 1 Register
  volatile uint32_t Interrupt2;  ///< 0x8 [R/W]: RTC Interrupt 2 Register
  volatile uint32_t Time;  ///< 0xc [R/W]: RTC Time Register
  volatile uint32_t Alarm1;  ///< 0x10 [R/W]: RTC Alarm 1 Register
  volatile uint32_t Alarm2;  ///< 0x14 [R/W]: RTC Alarm 2 Register
  volatile uint32_t ClockCorrect;  ///< 0x18 [R/W]: Clock Correction Register
  volatile uint32_t TestConfig;  ///< 0x1c [R/W]: RTC Test Configuration Register
  volatile uint32_t Timing;  ///< 0x20 [R/W]: RTC Timing Register
  volatile uint32_t REV0;  ///< 0x24 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x28 [R]: IP Tagging Revision 1
  volatile uint32_t RTC_ATEST;  ///< 0x2c [R/W]: RTC Analog Test Pin Config
} RTC_REGS_t;

//====================================================================
//
//Register File: MPMU Miscellaneous Controls (MPMU_misc)
/** \brief These registers provide control/status for various MPMU functions, including interrupts.*/
//
//====================================================================

typedef struct MPMU_MISC_REGS_s
{
  volatile uint32_t IntEnReg;  ///< 0x0 [R/W]: Interrupt Enable Register
  volatile uint32_t IntPendReg;  ///< 0x4 [R]: Interrupt Pending Register
  volatile uint32_t IntAckReg;  ///< 0x8 [W]: Interrupt Acknowledge Register
  volatile uint32_t IntForceReg;  ///< 0xc [W]: Interrupt Force Register
  volatile uint32_t LVDSAFE_PLL0_CLK_CFG;  ///< 0x10 [R/W]: LVDSAFE PLL0 Clock Delay Configuration
  volatile uint32_t LVDSAFE_PLL1_CLK_CFG;  ///< 0x14 [R/W]: LVDSAFE PLL1 Clock Delay Configuration
  volatile uint32_t SYSPLL_Enable;  ///< 0x18 [R/W]: System PLL Enable register
  volatile uint32_t reserved0;
  volatile uint32_t REV0;  ///< 0x20 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x24 [R]: IP Tagging Revision 1
} MPMU_MISC_REGS_t;

#endif // MPMU_TOP
 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _MPMU_TOP_REGMASKS_H_
#define _MPMU_TOP_REGMASKS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: Main PMU Register Set (MPMU_top)
/** \brief The Main PMU register set provides for control of the ANA_GRP oscillator module, the
    PLLs and associated spread spectrum control modules, the AVS module, the watchdog timer
    module, the real time clock module, and miscellaneous other power control related registers.*/
//
//====================================================================

//====================================================================
//
//Register File: Analog Group Oscillator Controls (ANA_GRP)
//
//====================================================================

//====================================================================
//Register: Reset, Power Up, Analog Test Point Control  (pu_sel_test)
//====================================================================

#define  ANA_GRP_PU_SEL_TEST_RESERVED1_MASK 0xfc000000
#define  ANA_GRP_PU_SEL_TEST_RESERVED1_SHIFT 26
#define  ANA_GRP_PU_SEL_TEST_RESERVED1_MASK_SHIFT(reg) (((reg) & ANA_GRP_PU_SEL_TEST_RESERVED1_MASK) >> ANA_GRP_PU_SEL_TEST_RESERVED1_SHIFT)
#define  ANA_GRP_PU_SEL_TEST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_PU_SEL_TEST_RESERVED1_MASK) | (((uint32_t)val) << ANA_GRP_PU_SEL_TEST_RESERVED1_SHIFT))

#define  ANA_GRP_PU_SEL_TEST_RESERVE_IN_MASK 0x3ff0000
#define  ANA_GRP_PU_SEL_TEST_RESERVE_IN_SHIFT 16
#define  ANA_GRP_PU_SEL_TEST_RESERVE_IN_MASK_SHIFT(reg) (((reg) & ANA_GRP_PU_SEL_TEST_RESERVE_IN_MASK) >> ANA_GRP_PU_SEL_TEST_RESERVE_IN_SHIFT)
#define  ANA_GRP_PU_SEL_TEST_RESERVE_IN_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_PU_SEL_TEST_RESERVE_IN_MASK) | (((uint32_t)val) << ANA_GRP_PU_SEL_TEST_RESERVE_IN_SHIFT))

#define  ANA_GRP_PU_SEL_TEST_TEST_ANA_MASK 0xf000
#define  ANA_GRP_PU_SEL_TEST_TEST_ANA_SHIFT 12
#define  ANA_GRP_PU_SEL_TEST_TEST_ANA_MASK_SHIFT(reg) (((reg) & ANA_GRP_PU_SEL_TEST_TEST_ANA_MASK) >> ANA_GRP_PU_SEL_TEST_TEST_ANA_SHIFT)
#define  ANA_GRP_PU_SEL_TEST_TEST_ANA_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_PU_SEL_TEST_TEST_ANA_MASK) | (((uint32_t)val) << ANA_GRP_PU_SEL_TEST_TEST_ANA_SHIFT))

#define  ANA_GRP_PU_SEL_TEST_ICC10U_IN_SEL_MASK 0x800
#define  ANA_GRP_PU_SEL_TEST_ICC10U_IN_SEL_SHIFT 11
#define  ANA_GRP_PU_SEL_TEST_ICC10U_IN_SEL_MASK_SHIFT(reg) (((reg) & ANA_GRP_PU_SEL_TEST_ICC10U_IN_SEL_MASK) >> ANA_GRP_PU_SEL_TEST_ICC10U_IN_SEL_SHIFT)
#define  ANA_GRP_PU_SEL_TEST_ICC10U_IN_SEL_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_PU_SEL_TEST_ICC10U_IN_SEL_MASK) | (((uint32_t)val) << ANA_GRP_PU_SEL_TEST_ICC10U_IN_SEL_SHIFT))

#define  ANA_GRP_PU_SEL_TEST_SPEED_OSC_MASK 0x600
#define  ANA_GRP_PU_SEL_TEST_SPEED_OSC_SHIFT 9
#define  ANA_GRP_PU_SEL_TEST_SPEED_OSC_MASK_SHIFT(reg) (((reg) & ANA_GRP_PU_SEL_TEST_SPEED_OSC_MASK) >> ANA_GRP_PU_SEL_TEST_SPEED_OSC_SHIFT)
#define  ANA_GRP_PU_SEL_TEST_SPEED_OSC_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_PU_SEL_TEST_SPEED_OSC_MASK) | (((uint32_t)val) << ANA_GRP_PU_SEL_TEST_SPEED_OSC_SHIFT))

#define  ANA_GRP_PU_SEL_TEST_PU_OSC_MASK 0x100
#define  ANA_GRP_PU_SEL_TEST_PU_OSC_SHIFT 8
#define  ANA_GRP_PU_SEL_TEST_PU_OSC_MASK_SHIFT(reg) (((reg) & ANA_GRP_PU_SEL_TEST_PU_OSC_MASK) >> ANA_GRP_PU_SEL_TEST_PU_OSC_SHIFT)
#define  ANA_GRP_PU_SEL_TEST_PU_OSC_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_PU_SEL_TEST_PU_OSC_MASK) | (((uint32_t)val) << ANA_GRP_PU_SEL_TEST_PU_OSC_SHIFT))

#define  ANA_GRP_PU_SEL_TEST_RESERVED2_MASK 0xfe
#define  ANA_GRP_PU_SEL_TEST_RESERVED2_SHIFT 1
#define  ANA_GRP_PU_SEL_TEST_RESERVED2_MASK_SHIFT(reg) (((reg) & ANA_GRP_PU_SEL_TEST_RESERVED2_MASK) >> ANA_GRP_PU_SEL_TEST_RESERVED2_SHIFT)
#define  ANA_GRP_PU_SEL_TEST_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_PU_SEL_TEST_RESERVED2_MASK) | (((uint32_t)val) << ANA_GRP_PU_SEL_TEST_RESERVED2_SHIFT))

#define  ANA_GRP_PU_SEL_TEST_PU_MASK 0x1
#define  ANA_GRP_PU_SEL_TEST_PU_SHIFT 0
#define  ANA_GRP_PU_SEL_TEST_PU_MASK_SHIFT(reg) (((reg) & ANA_GRP_PU_SEL_TEST_PU_MASK) >> ANA_GRP_PU_SEL_TEST_PU_SHIFT)
#define  ANA_GRP_PU_SEL_TEST_PU_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_PU_SEL_TEST_PU_MASK) | (((uint32_t)val) << ANA_GRP_PU_SEL_TEST_PU_SHIFT))

//====================================================================
//Register: Adjust, Gain, VREG select (divsel_misc)
//====================================================================

#define  ANA_GRP_DIVSEL_MISC_RESERVED1_MASK 0xf0000000
#define  ANA_GRP_DIVSEL_MISC_RESERVED1_SHIFT 28
#define  ANA_GRP_DIVSEL_MISC_RESERVED1_MASK_SHIFT(reg) (((reg) & ANA_GRP_DIVSEL_MISC_RESERVED1_MASK) >> ANA_GRP_DIVSEL_MISC_RESERVED1_SHIFT)
#define  ANA_GRP_DIVSEL_MISC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_DIVSEL_MISC_RESERVED1_MASK) | (((uint32_t)val) << ANA_GRP_DIVSEL_MISC_RESERVED1_SHIFT))

#define  ANA_GRP_DIVSEL_MISC_VREG_1P05V_SEL_XTL_MASK 0xe000000
#define  ANA_GRP_DIVSEL_MISC_VREG_1P05V_SEL_XTL_SHIFT 25
#define  ANA_GRP_DIVSEL_MISC_VREG_1P05V_SEL_XTL_MASK_SHIFT(reg) (((reg) & ANA_GRP_DIVSEL_MISC_VREG_1P05V_SEL_XTL_MASK) >> ANA_GRP_DIVSEL_MISC_VREG_1P05V_SEL_XTL_SHIFT)
#define  ANA_GRP_DIVSEL_MISC_VREG_1P05V_SEL_XTL_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_DIVSEL_MISC_VREG_1P05V_SEL_XTL_MASK) | (((uint32_t)val) << ANA_GRP_DIVSEL_MISC_VREG_1P05V_SEL_XTL_SHIFT))

#define  ANA_GRP_DIVSEL_MISC_IXTAL_MASK 0x1800000
#define  ANA_GRP_DIVSEL_MISC_IXTAL_SHIFT 23
#define  ANA_GRP_DIVSEL_MISC_IXTAL_MASK_SHIFT(reg) (((reg) & ANA_GRP_DIVSEL_MISC_IXTAL_MASK) >> ANA_GRP_DIVSEL_MISC_IXTAL_SHIFT)
#define  ANA_GRP_DIVSEL_MISC_IXTAL_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_DIVSEL_MISC_IXTAL_MASK) | (((uint32_t)val) << ANA_GRP_DIVSEL_MISC_IXTAL_SHIFT))

#define  ANA_GRP_DIVSEL_MISC_GAINX2_MASK 0x400000
#define  ANA_GRP_DIVSEL_MISC_GAINX2_SHIFT 22
#define  ANA_GRP_DIVSEL_MISC_GAINX2_MASK_SHIFT(reg) (((reg) & ANA_GRP_DIVSEL_MISC_GAINX2_MASK) >> ANA_GRP_DIVSEL_MISC_GAINX2_SHIFT)
#define  ANA_GRP_DIVSEL_MISC_GAINX2_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_DIVSEL_MISC_GAINX2_MASK) | (((uint32_t)val) << ANA_GRP_DIVSEL_MISC_GAINX2_SHIFT))

#define  ANA_GRP_DIVSEL_MISC_RESERVED2_MASK 0x200000
#define  ANA_GRP_DIVSEL_MISC_RESERVED2_SHIFT 21
#define  ANA_GRP_DIVSEL_MISC_RESERVED2_MASK_SHIFT(reg) (((reg) & ANA_GRP_DIVSEL_MISC_RESERVED2_MASK) >> ANA_GRP_DIVSEL_MISC_RESERVED2_SHIFT)
#define  ANA_GRP_DIVSEL_MISC_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_DIVSEL_MISC_RESERVED2_MASK) | (((uint32_t)val) << ANA_GRP_DIVSEL_MISC_RESERVED2_SHIFT))

#define  ANA_GRP_DIVSEL_MISC_PU_XTL_MASK 0x100000
#define  ANA_GRP_DIVSEL_MISC_PU_XTL_SHIFT 20
#define  ANA_GRP_DIVSEL_MISC_PU_XTL_MASK_SHIFT(reg) (((reg) & ANA_GRP_DIVSEL_MISC_PU_XTL_MASK) >> ANA_GRP_DIVSEL_MISC_PU_XTL_SHIFT)
#define  ANA_GRP_DIVSEL_MISC_PU_XTL_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_DIVSEL_MISC_PU_XTL_MASK) | (((uint32_t)val) << ANA_GRP_DIVSEL_MISC_PU_XTL_SHIFT))

#define  ANA_GRP_DIVSEL_MISC_CLKOUT_DIG3_DIV_SEL_MASK 0xc0000
#define  ANA_GRP_DIVSEL_MISC_CLKOUT_DIG3_DIV_SEL_SHIFT 18
#define  ANA_GRP_DIVSEL_MISC_CLKOUT_DIG3_DIV_SEL_MASK_SHIFT(reg) (((reg) & ANA_GRP_DIVSEL_MISC_CLKOUT_DIG3_DIV_SEL_MASK) >> ANA_GRP_DIVSEL_MISC_CLKOUT_DIG3_DIV_SEL_SHIFT)
#define  ANA_GRP_DIVSEL_MISC_CLKOUT_DIG3_DIV_SEL_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_DIVSEL_MISC_CLKOUT_DIG3_DIV_SEL_MASK) | (((uint32_t)val) << ANA_GRP_DIVSEL_MISC_CLKOUT_DIG3_DIV_SEL_SHIFT))

#define  ANA_GRP_DIVSEL_MISC_CLKOUT_DIG2_DIV_SEL_MASK 0x30000
#define  ANA_GRP_DIVSEL_MISC_CLKOUT_DIG2_DIV_SEL_SHIFT 16
#define  ANA_GRP_DIVSEL_MISC_CLKOUT_DIG2_DIV_SEL_MASK_SHIFT(reg) (((reg) & ANA_GRP_DIVSEL_MISC_CLKOUT_DIG2_DIV_SEL_MASK) >> ANA_GRP_DIVSEL_MISC_CLKOUT_DIG2_DIV_SEL_SHIFT)
#define  ANA_GRP_DIVSEL_MISC_CLKOUT_DIG2_DIV_SEL_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_DIVSEL_MISC_CLKOUT_DIG2_DIV_SEL_MASK) | (((uint32_t)val) << ANA_GRP_DIVSEL_MISC_CLKOUT_DIG2_DIV_SEL_SHIFT))

#define  ANA_GRP_DIVSEL_MISC_CLKOUT_DIG1_DIV_SEL_MASK 0xc000
#define  ANA_GRP_DIVSEL_MISC_CLKOUT_DIG1_DIV_SEL_SHIFT 14
#define  ANA_GRP_DIVSEL_MISC_CLKOUT_DIG1_DIV_SEL_MASK_SHIFT(reg) (((reg) & ANA_GRP_DIVSEL_MISC_CLKOUT_DIG1_DIV_SEL_MASK) >> ANA_GRP_DIVSEL_MISC_CLKOUT_DIG1_DIV_SEL_SHIFT)
#define  ANA_GRP_DIVSEL_MISC_CLKOUT_DIG1_DIV_SEL_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_DIVSEL_MISC_CLKOUT_DIG1_DIV_SEL_MASK) | (((uint32_t)val) << ANA_GRP_DIVSEL_MISC_CLKOUT_DIG1_DIV_SEL_SHIFT))

#define  ANA_GRP_DIVSEL_MISC_CLKOUT_DIG0_DIV_SEL_MASK 0x3000
#define  ANA_GRP_DIVSEL_MISC_CLKOUT_DIG0_DIV_SEL_SHIFT 12
#define  ANA_GRP_DIVSEL_MISC_CLKOUT_DIG0_DIV_SEL_MASK_SHIFT(reg) (((reg) & ANA_GRP_DIVSEL_MISC_CLKOUT_DIG0_DIV_SEL_MASK) >> ANA_GRP_DIVSEL_MISC_CLKOUT_DIG0_DIV_SEL_SHIFT)
#define  ANA_GRP_DIVSEL_MISC_CLKOUT_DIG0_DIV_SEL_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_DIVSEL_MISC_CLKOUT_DIG0_DIV_SEL_MASK) | (((uint32_t)val) << ANA_GRP_DIVSEL_MISC_CLKOUT_DIG0_DIV_SEL_SHIFT))

#define  ANA_GRP_DIVSEL_MISC_ICC_ADJ_MASK 0xc00
#define  ANA_GRP_DIVSEL_MISC_ICC_ADJ_SHIFT 10
#define  ANA_GRP_DIVSEL_MISC_ICC_ADJ_MASK_SHIFT(reg) (((reg) & ANA_GRP_DIVSEL_MISC_ICC_ADJ_MASK) >> ANA_GRP_DIVSEL_MISC_ICC_ADJ_SHIFT)
#define  ANA_GRP_DIVSEL_MISC_ICC_ADJ_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_DIVSEL_MISC_ICC_ADJ_MASK) | (((uint32_t)val) << ANA_GRP_DIVSEL_MISC_ICC_ADJ_SHIFT))

#define  ANA_GRP_DIVSEL_MISC_IPP_ADJ_MASK 0x300
#define  ANA_GRP_DIVSEL_MISC_IPP_ADJ_SHIFT 8
#define  ANA_GRP_DIVSEL_MISC_IPP_ADJ_MASK_SHIFT(reg) (((reg) & ANA_GRP_DIVSEL_MISC_IPP_ADJ_MASK) >> ANA_GRP_DIVSEL_MISC_IPP_ADJ_SHIFT)
#define  ANA_GRP_DIVSEL_MISC_IPP_ADJ_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_DIVSEL_MISC_IPP_ADJ_MASK) | (((uint32_t)val) << ANA_GRP_DIVSEL_MISC_IPP_ADJ_SHIFT))

#define  ANA_GRP_DIVSEL_MISC_TERM_MASK 0x80
#define  ANA_GRP_DIVSEL_MISC_TERM_SHIFT 7
#define  ANA_GRP_DIVSEL_MISC_TERM_MASK_SHIFT(reg) (((reg) & ANA_GRP_DIVSEL_MISC_TERM_MASK) >> ANA_GRP_DIVSEL_MISC_TERM_SHIFT)
#define  ANA_GRP_DIVSEL_MISC_TERM_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_DIVSEL_MISC_TERM_MASK) | (((uint32_t)val) << ANA_GRP_DIVSEL_MISC_TERM_SHIFT))

#define  ANA_GRP_DIVSEL_MISC_VREG_1P05V_SEL_PECL_MASK 0x70
#define  ANA_GRP_DIVSEL_MISC_VREG_1P05V_SEL_PECL_SHIFT 4
#define  ANA_GRP_DIVSEL_MISC_VREG_1P05V_SEL_PECL_MASK_SHIFT(reg) (((reg) & ANA_GRP_DIVSEL_MISC_VREG_1P05V_SEL_PECL_MASK) >> ANA_GRP_DIVSEL_MISC_VREG_1P05V_SEL_PECL_SHIFT)
#define  ANA_GRP_DIVSEL_MISC_VREG_1P05V_SEL_PECL_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_DIVSEL_MISC_VREG_1P05V_SEL_PECL_MASK) | (((uint32_t)val) << ANA_GRP_DIVSEL_MISC_VREG_1P05V_SEL_PECL_SHIFT))

#define  ANA_GRP_DIVSEL_MISC_VREG_1P2V_SEL_MASK 0xc
#define  ANA_GRP_DIVSEL_MISC_VREG_1P2V_SEL_SHIFT 2
#define  ANA_GRP_DIVSEL_MISC_VREG_1P2V_SEL_MASK_SHIFT(reg) (((reg) & ANA_GRP_DIVSEL_MISC_VREG_1P2V_SEL_MASK) >> ANA_GRP_DIVSEL_MISC_VREG_1P2V_SEL_SHIFT)
#define  ANA_GRP_DIVSEL_MISC_VREG_1P2V_SEL_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_DIVSEL_MISC_VREG_1P2V_SEL_MASK) | (((uint32_t)val) << ANA_GRP_DIVSEL_MISC_VREG_1P2V_SEL_SHIFT))

#define  ANA_GRP_DIVSEL_MISC_PU_PECL_MASK 0x2
#define  ANA_GRP_DIVSEL_MISC_PU_PECL_SHIFT 1
#define  ANA_GRP_DIVSEL_MISC_PU_PECL_MASK_SHIFT(reg) (((reg) & ANA_GRP_DIVSEL_MISC_PU_PECL_MASK) >> ANA_GRP_DIVSEL_MISC_PU_PECL_SHIFT)
#define  ANA_GRP_DIVSEL_MISC_PU_PECL_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_DIVSEL_MISC_PU_PECL_MASK) | (((uint32_t)val) << ANA_GRP_DIVSEL_MISC_PU_PECL_SHIFT))

#define  ANA_GRP_DIVSEL_MISC_PECL_EN_MASK 0x1
#define  ANA_GRP_DIVSEL_MISC_PECL_EN_SHIFT 0
#define  ANA_GRP_DIVSEL_MISC_PECL_EN_MASK_SHIFT(reg) (((reg) & ANA_GRP_DIVSEL_MISC_PECL_EN_MASK) >> ANA_GRP_DIVSEL_MISC_PECL_EN_SHIFT)
#define  ANA_GRP_DIVSEL_MISC_PECL_EN_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_DIVSEL_MISC_PECL_EN_MASK) | (((uint32_t)val) << ANA_GRP_DIVSEL_MISC_PECL_EN_SHIFT))

//====================================================================
//Register: PLL Status Output (observe only) (status)
//====================================================================

#define  ANA_GRP_STATUS_RESERVE_MASK 0xffffff80
#define  ANA_GRP_STATUS_RESERVE_SHIFT 7
#define  ANA_GRP_STATUS_RESERVE_MASK_SHIFT(reg) (((reg) & ANA_GRP_STATUS_RESERVE_MASK) >> ANA_GRP_STATUS_RESERVE_SHIFT)
#define  ANA_GRP_STATUS_RESERVE_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_STATUS_RESERVE_MASK) | (((uint32_t)val) << ANA_GRP_STATUS_RESERVE_SHIFT))

#define  ANA_GRP_STATUS_RESERVE_OUT_MASK 0x7e
#define  ANA_GRP_STATUS_RESERVE_OUT_SHIFT 1
#define  ANA_GRP_STATUS_RESERVE_OUT_MASK_SHIFT(reg) (((reg) & ANA_GRP_STATUS_RESERVE_OUT_MASK) >> ANA_GRP_STATUS_RESERVE_OUT_SHIFT)
#define  ANA_GRP_STATUS_RESERVE_OUT_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_STATUS_RESERVE_OUT_MASK) | (((uint32_t)val) << ANA_GRP_STATUS_RESERVE_OUT_SHIFT))

#define  ANA_GRP_STATUS_BG_RDY_MASK 0x1
#define  ANA_GRP_STATUS_BG_RDY_SHIFT 0
#define  ANA_GRP_STATUS_BG_RDY_MASK_SHIFT(reg) (((reg) & ANA_GRP_STATUS_BG_RDY_MASK) >> ANA_GRP_STATUS_BG_RDY_SHIFT)
#define  ANA_GRP_STATUS_BG_RDY_REPLACE_VAL(reg,val) (((reg) & ~ANA_GRP_STATUS_BG_RDY_MASK) | (((uint32_t)val) << ANA_GRP_STATUS_BG_RDY_SHIFT))

//====================================================================
//
//Register File: DDR PLL Controls (DDR_PLL)
//
//====================================================================

//====================================================================
//Register: PLL reset & Pre-divider Register (rst_prediv)
/** \brief RESET, 1 = PLL in reset
           0 = PLL in normal mode
    RESET_SSC, 1 = SSC and Freq Offset in reset
               0 = SSC and Freq Offset operating mode
    RESET_PI, 1 = External Interpolator in reset
               0 = operating mode*/
//====================================================================

#define  DDR_PLL_RST_PREDIV_RESERVED1_MASK 0xfff80000
#define  DDR_PLL_RST_PREDIV_RESERVED1_SHIFT 19
#define  DDR_PLL_RST_PREDIV_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_RST_PREDIV_RESERVED1_MASK) >> DDR_PLL_RST_PREDIV_RESERVED1_SHIFT)
#define  DDR_PLL_RST_PREDIV_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_RST_PREDIV_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_RST_PREDIV_RESERVED1_SHIFT))

#define  DDR_PLL_RST_PREDIV_RESET_PI_MASK 0x40000
#define  DDR_PLL_RST_PREDIV_RESET_PI_SHIFT 18
#define  DDR_PLL_RST_PREDIV_RESET_PI_MASK_SHIFT(reg) (((reg) & DDR_PLL_RST_PREDIV_RESET_PI_MASK) >> DDR_PLL_RST_PREDIV_RESET_PI_SHIFT)
#define  DDR_PLL_RST_PREDIV_RESET_PI_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_RST_PREDIV_RESET_PI_MASK) | (((uint32_t)val) << DDR_PLL_RST_PREDIV_RESET_PI_SHIFT))

#define  DDR_PLL_RST_PREDIV_RESET_SSC_MASK 0x20000
#define  DDR_PLL_RST_PREDIV_RESET_SSC_SHIFT 17
#define  DDR_PLL_RST_PREDIV_RESET_SSC_MASK_SHIFT(reg) (((reg) & DDR_PLL_RST_PREDIV_RESET_SSC_MASK) >> DDR_PLL_RST_PREDIV_RESET_SSC_SHIFT)
#define  DDR_PLL_RST_PREDIV_RESET_SSC_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_RST_PREDIV_RESET_SSC_MASK) | (((uint32_t)val) << DDR_PLL_RST_PREDIV_RESET_SSC_SHIFT))

#define  DDR_PLL_RST_PREDIV_RESET_MASK 0x10000
#define  DDR_PLL_RST_PREDIV_RESET_SHIFT 16
#define  DDR_PLL_RST_PREDIV_RESET_MASK_SHIFT(reg) (((reg) & DDR_PLL_RST_PREDIV_RESET_MASK) >> DDR_PLL_RST_PREDIV_RESET_SHIFT)
#define  DDR_PLL_RST_PREDIV_RESET_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_RST_PREDIV_RESET_MASK) | (((uint32_t)val) << DDR_PLL_RST_PREDIV_RESET_SHIFT))

#define  DDR_PLL_RST_PREDIV_RESERVED2_MASK 0xfe00
#define  DDR_PLL_RST_PREDIV_RESERVED2_SHIFT 9
#define  DDR_PLL_RST_PREDIV_RESERVED2_MASK_SHIFT(reg) (((reg) & DDR_PLL_RST_PREDIV_RESERVED2_MASK) >> DDR_PLL_RST_PREDIV_RESERVED2_SHIFT)
#define  DDR_PLL_RST_PREDIV_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_RST_PREDIV_RESERVED2_MASK) | (((uint32_t)val) << DDR_PLL_RST_PREDIV_RESERVED2_SHIFT))

#define  DDR_PLL_RST_PREDIV_REFDIV_MASK 0x1ff
#define  DDR_PLL_RST_PREDIV_REFDIV_SHIFT 0
#define  DDR_PLL_RST_PREDIV_REFDIV_MASK_SHIFT(reg) (((reg) & DDR_PLL_RST_PREDIV_REFDIV_MASK) >> DDR_PLL_RST_PREDIV_REFDIV_SHIFT)
#define  DDR_PLL_RST_PREDIV_REFDIV_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_RST_PREDIV_REFDIV_MASK) | (((uint32_t)val) << DDR_PLL_RST_PREDIV_REFDIV_SHIFT))

//====================================================================
//Register: PLL feedback multiplier (mult_postdiv)
/** \brief PLL multiplication factor after pre-divide.*/
//====================================================================

#define  DDR_PLL_MULT_POSTDIV_RESERVED1_MASK 0xfe000000
#define  DDR_PLL_MULT_POSTDIV_RESERVED1_SHIFT 25
#define  DDR_PLL_MULT_POSTDIV_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_MULT_POSTDIV_RESERVED1_MASK) >> DDR_PLL_MULT_POSTDIV_RESERVED1_SHIFT)
#define  DDR_PLL_MULT_POSTDIV_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_MULT_POSTDIV_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_MULT_POSTDIV_RESERVED1_SHIFT))

#define  DDR_PLL_MULT_POSTDIV_FBDIV_MASK 0x1ff0000
#define  DDR_PLL_MULT_POSTDIV_FBDIV_SHIFT 16
#define  DDR_PLL_MULT_POSTDIV_FBDIV_MASK_SHIFT(reg) (((reg) & DDR_PLL_MULT_POSTDIV_FBDIV_MASK) >> DDR_PLL_MULT_POSTDIV_FBDIV_SHIFT)
#define  DDR_PLL_MULT_POSTDIV_FBDIV_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_MULT_POSTDIV_FBDIV_MASK) | (((uint32_t)val) << DDR_PLL_MULT_POSTDIV_FBDIV_SHIFT))

#define  DDR_PLL_MULT_POSTDIV_RESERVED2_MASK 0xf800
#define  DDR_PLL_MULT_POSTDIV_RESERVED2_SHIFT 11
#define  DDR_PLL_MULT_POSTDIV_RESERVED2_MASK_SHIFT(reg) (((reg) & DDR_PLL_MULT_POSTDIV_RESERVED2_MASK) >> DDR_PLL_MULT_POSTDIV_RESERVED2_SHIFT)
#define  DDR_PLL_MULT_POSTDIV_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_MULT_POSTDIV_RESERVED2_MASK) | (((uint32_t)val) << DDR_PLL_MULT_POSTDIV_RESERVED2_SHIFT))

#define  DDR_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK 0x700
#define  DDR_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_SHIFT 8
#define  DDR_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK_SHIFT(reg) (((reg) & DDR_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK) >> DDR_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_SHIFT)
#define  DDR_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK) | (((uint32_t)val) << DDR_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_SHIFT))

#define  DDR_PLL_MULT_POSTDIV_RESERVED3_MASK 0xf8
#define  DDR_PLL_MULT_POSTDIV_RESERVED3_SHIFT 3
#define  DDR_PLL_MULT_POSTDIV_RESERVED3_MASK_SHIFT(reg) (((reg) & DDR_PLL_MULT_POSTDIV_RESERVED3_MASK) >> DDR_PLL_MULT_POSTDIV_RESERVED3_SHIFT)
#define  DDR_PLL_MULT_POSTDIV_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_MULT_POSTDIV_RESERVED3_MASK) | (((uint32_t)val) << DDR_PLL_MULT_POSTDIV_RESERVED3_SHIFT))

#define  DDR_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK 0x7
#define  DDR_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_SHIFT 0
#define  DDR_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK_SHIFT(reg) (((reg) & DDR_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK) >> DDR_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_SHIFT)
#define  DDR_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK) | (((uint32_t)val) << DDR_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_SHIFT))

//====================================================================
//Register: PLL gain control (kvco)
/** \brief PLL gain control.*/
//====================================================================

#define  DDR_PLL_KVCO_RESERVED1_MASK 0xfffffff0
#define  DDR_PLL_KVCO_RESERVED1_SHIFT 4
#define  DDR_PLL_KVCO_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_KVCO_RESERVED1_MASK) >> DDR_PLL_KVCO_RESERVED1_SHIFT)
#define  DDR_PLL_KVCO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_KVCO_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_KVCO_RESERVED1_SHIFT))

#define  DDR_PLL_KVCO_KVCO_MASK 0xf
#define  DDR_PLL_KVCO_KVCO_SHIFT 0
#define  DDR_PLL_KVCO_KVCO_MASK_SHIFT(reg) (((reg) & DDR_PLL_KVCO_KVCO_MASK) >> DDR_PLL_KVCO_KVCO_SHIFT)
#define  DDR_PLL_KVCO_KVCO_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_KVCO_KVCO_MASK) | (((uint32_t)val) << DDR_PLL_KVCO_KVCO_SHIFT))

//====================================================================
//Register: PLL misc control (misc)
/** \brief PLL misc control.*/
//====================================================================

#define  DDR_PLL_MISC_RESERVED1_MASK 0xffff0000
#define  DDR_PLL_MISC_RESERVED1_SHIFT 16
#define  DDR_PLL_MISC_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_MISC_RESERVED1_MASK) >> DDR_PLL_MISC_RESERVED1_SHIFT)
#define  DDR_PLL_MISC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_MISC_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_MISC_RESERVED1_SHIFT))

#define  DDR_PLL_MISC_PLL_BW_SEL_MASK 0x8000
#define  DDR_PLL_MISC_PLL_BW_SEL_SHIFT 15
#define  DDR_PLL_MISC_PLL_BW_SEL_MASK_SHIFT(reg) (((reg) & DDR_PLL_MISC_PLL_BW_SEL_MASK) >> DDR_PLL_MISC_PLL_BW_SEL_SHIFT)
#define  DDR_PLL_MISC_PLL_BW_SEL_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_MISC_PLL_BW_SEL_MASK) | (((uint32_t)val) << DDR_PLL_MISC_PLL_BW_SEL_SHIFT))

#define  DDR_PLL_MISC_CTUNE_MASK 0x6000
#define  DDR_PLL_MISC_CTUNE_SHIFT 13
#define  DDR_PLL_MISC_CTUNE_MASK_SHIFT(reg) (((reg) & DDR_PLL_MISC_CTUNE_MASK) >> DDR_PLL_MISC_CTUNE_SHIFT)
#define  DDR_PLL_MISC_CTUNE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_MISC_CTUNE_MASK) | (((uint32_t)val) << DDR_PLL_MISC_CTUNE_SHIFT))

#define  DDR_PLL_MISC_INTPI_MASK 0x1e00
#define  DDR_PLL_MISC_INTPI_SHIFT 9
#define  DDR_PLL_MISC_INTPI_MASK_SHIFT(reg) (((reg) & DDR_PLL_MISC_INTPI_MASK) >> DDR_PLL_MISC_INTPI_SHIFT)
#define  DDR_PLL_MISC_INTPI_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_MISC_INTPI_MASK) | (((uint32_t)val) << DDR_PLL_MISC_INTPI_SHIFT))

#define  DDR_PLL_MISC_ICP_MASK 0x1e0
#define  DDR_PLL_MISC_ICP_SHIFT 5
#define  DDR_PLL_MISC_ICP_MASK_SHIFT(reg) (((reg) & DDR_PLL_MISC_ICP_MASK) >> DDR_PLL_MISC_ICP_SHIFT)
#define  DDR_PLL_MISC_ICP_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_MISC_ICP_MASK) | (((uint32_t)val) << DDR_PLL_MISC_ICP_SHIFT))

#define  DDR_PLL_MISC_VDDM_MASK 0x18
#define  DDR_PLL_MISC_VDDM_SHIFT 3
#define  DDR_PLL_MISC_VDDM_MASK_SHIFT(reg) (((reg) & DDR_PLL_MISC_VDDM_MASK) >> DDR_PLL_MISC_VDDM_SHIFT)
#define  DDR_PLL_MISC_VDDM_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_MISC_VDDM_MASK) | (((uint32_t)val) << DDR_PLL_MISC_VDDM_SHIFT))

#define  DDR_PLL_MISC_VDDL_MASK 0x7
#define  DDR_PLL_MISC_VDDL_SHIFT 0
#define  DDR_PLL_MISC_VDDL_MASK_SHIFT(reg) (((reg) & DDR_PLL_MISC_VDDL_MASK) >> DDR_PLL_MISC_VDDL_SHIFT)
#define  DDR_PLL_MISC_VDDL_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_MISC_VDDL_MASK) | (((uint32_t)val) << DDR_PLL_MISC_VDDL_SHIFT))

//====================================================================
//Register: PLL PFD (Phase Frequency Detector) input select, and de-skew application control (feedback_mode_deskew)
/** \brief PLL feedback mode control.*/
//====================================================================

#define  DDR_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_MASK 0xff800000
#define  DDR_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_SHIFT 23
#define  DDR_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_MASK) >> DDR_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_SHIFT)
#define  DDR_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_SHIFT))

#define  DDR_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_MASK 0x7e0000
#define  DDR_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_SHIFT 17
#define  DDR_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_MASK_SHIFT(reg) (((reg) & DDR_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_MASK) >> DDR_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_SHIFT)
#define  DDR_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_MASK) | (((uint32_t)val) << DDR_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_SHIFT))

#define  DDR_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK 0x10000
#define  DDR_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_SHIFT 16
#define  DDR_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK_SHIFT(reg) (((reg) & DDR_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK) >> DDR_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_SHIFT)
#define  DDR_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK) | (((uint32_t)val) << DDR_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_SHIFT))

#define  DDR_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_MASK 0xffff
#define  DDR_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_SHIFT 0
#define  DDR_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_MASK_SHIFT(reg) (((reg) & DDR_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_MASK) >> DDR_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_SHIFT)
#define  DDR_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_MASK) | (((uint32_t)val) << DDR_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_SHIFT))

//====================================================================
//Register: PLL offset frequency control (offset_mode)
/** \brief PLL offset frequency control.*/
//====================================================================

#define  DDR_PLL_OFFSET_MODE_RESERVED1_MASK 0xf8000000
#define  DDR_PLL_OFFSET_MODE_RESERVED1_SHIFT 27
#define  DDR_PLL_OFFSET_MODE_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_OFFSET_MODE_RESERVED1_MASK) >> DDR_PLL_OFFSET_MODE_RESERVED1_SHIFT)
#define  DDR_PLL_OFFSET_MODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_OFFSET_MODE_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_OFFSET_MODE_RESERVED1_SHIFT))

#define  DDR_PLL_OFFSET_MODE_INTPR_MASK 0x7000000
#define  DDR_PLL_OFFSET_MODE_INTPR_SHIFT 24
#define  DDR_PLL_OFFSET_MODE_INTPR_MASK_SHIFT(reg) (((reg) & DDR_PLL_OFFSET_MODE_INTPR_MASK) >> DDR_PLL_OFFSET_MODE_INTPR_SHIFT)
#define  DDR_PLL_OFFSET_MODE_INTPR_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_OFFSET_MODE_INTPR_MASK) | (((uint32_t)val) << DDR_PLL_OFFSET_MODE_INTPR_SHIFT))

#define  DDR_PLL_OFFSET_MODE_FD_MASK 0xe00000
#define  DDR_PLL_OFFSET_MODE_FD_SHIFT 21
#define  DDR_PLL_OFFSET_MODE_FD_MASK_SHIFT(reg) (((reg) & DDR_PLL_OFFSET_MODE_FD_MASK) >> DDR_PLL_OFFSET_MODE_FD_SHIFT)
#define  DDR_PLL_OFFSET_MODE_FD_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_OFFSET_MODE_FD_MASK) | (((uint32_t)val) << DDR_PLL_OFFSET_MODE_FD_SHIFT))

#define  DDR_PLL_OFFSET_MODE_PI_LOOP_MODE_MASK 0x100000
#define  DDR_PLL_OFFSET_MODE_PI_LOOP_MODE_SHIFT 20
#define  DDR_PLL_OFFSET_MODE_PI_LOOP_MODE_MASK_SHIFT(reg) (((reg) & DDR_PLL_OFFSET_MODE_PI_LOOP_MODE_MASK) >> DDR_PLL_OFFSET_MODE_PI_LOOP_MODE_SHIFT)
#define  DDR_PLL_OFFSET_MODE_PI_LOOP_MODE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_OFFSET_MODE_PI_LOOP_MODE_MASK) | (((uint32_t)val) << DDR_PLL_OFFSET_MODE_PI_LOOP_MODE_SHIFT))

#define  DDR_PLL_OFFSET_MODE_FREQ_OFFSET_MASK 0xffff8
#define  DDR_PLL_OFFSET_MODE_FREQ_OFFSET_SHIFT 3
#define  DDR_PLL_OFFSET_MODE_FREQ_OFFSET_MASK_SHIFT(reg) (((reg) & DDR_PLL_OFFSET_MODE_FREQ_OFFSET_MASK) >> DDR_PLL_OFFSET_MODE_FREQ_OFFSET_SHIFT)
#define  DDR_PLL_OFFSET_MODE_FREQ_OFFSET_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_OFFSET_MODE_FREQ_OFFSET_MASK) | (((uint32_t)val) << DDR_PLL_OFFSET_MODE_FREQ_OFFSET_SHIFT))

#define  DDR_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK 0x4
#define  DDR_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_SHIFT 2
#define  DDR_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK_SHIFT(reg) (((reg) & DDR_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK) >> DDR_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_SHIFT)
#define  DDR_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK) | (((uint32_t)val) << DDR_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_SHIFT))

#define  DDR_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_MASK 0x2
#define  DDR_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_SHIFT 1
#define  DDR_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_MASK_SHIFT(reg) (((reg) & DDR_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_MASK) >> DDR_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_SHIFT)
#define  DDR_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_MASK) | (((uint32_t)val) << DDR_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_SHIFT))

#define  DDR_PLL_OFFSET_MODE_FREQ_OFFSET_EN_MASK 0x1
#define  DDR_PLL_OFFSET_MODE_FREQ_OFFSET_EN_SHIFT 0
#define  DDR_PLL_OFFSET_MODE_FREQ_OFFSET_EN_MASK_SHIFT(reg) (((reg) & DDR_PLL_OFFSET_MODE_FREQ_OFFSET_EN_MASK) >> DDR_PLL_OFFSET_MODE_FREQ_OFFSET_EN_SHIFT)
#define  DDR_PLL_OFFSET_MODE_FREQ_OFFSET_EN_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_OFFSET_MODE_FREQ_OFFSET_EN_MASK) | (((uint32_t)val) << DDR_PLL_OFFSET_MODE_FREQ_OFFSET_EN_SHIFT))

//====================================================================
//Register: PLL enable (fixed_mode_ssc_mode)
/** \brief PLL enable*/
//====================================================================

#define  DDR_PLL_FIXED_MODE_SSC_MODE_RESERVED1_MASK 0xfff00000
#define  DDR_PLL_FIXED_MODE_SSC_MODE_RESERVED1_SHIFT 20
#define  DDR_PLL_FIXED_MODE_SSC_MODE_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_FIXED_MODE_SSC_MODE_RESERVED1_MASK) >> DDR_PLL_FIXED_MODE_SSC_MODE_RESERVED1_SHIFT)
#define  DDR_PLL_FIXED_MODE_SSC_MODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_FIXED_MODE_SSC_MODE_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_FIXED_MODE_SSC_MODE_RESERVED1_SHIFT))

#define  DDR_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK 0x80000
#define  DDR_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_SHIFT 19
#define  DDR_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK_SHIFT(reg) (((reg) & DDR_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK) >> DDR_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_SHIFT)
#define  DDR_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK) | (((uint32_t)val) << DDR_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_SHIFT))

#define  DDR_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK 0x40000
#define  DDR_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_SHIFT 18
#define  DDR_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK_SHIFT(reg) (((reg) & DDR_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK) >> DDR_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_SHIFT)
#define  DDR_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK) | (((uint32_t)val) << DDR_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_SHIFT))

#define  DDR_PLL_FIXED_MODE_SSC_MODE_PU_MASK 0x20000
#define  DDR_PLL_FIXED_MODE_SSC_MODE_PU_SHIFT 17
#define  DDR_PLL_FIXED_MODE_SSC_MODE_PU_MASK_SHIFT(reg) (((reg) & DDR_PLL_FIXED_MODE_SSC_MODE_PU_MASK) >> DDR_PLL_FIXED_MODE_SSC_MODE_PU_SHIFT)
#define  DDR_PLL_FIXED_MODE_SSC_MODE_PU_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_FIXED_MODE_SSC_MODE_PU_MASK) | (((uint32_t)val) << DDR_PLL_FIXED_MODE_SSC_MODE_PU_SHIFT))

#define  DDR_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK 0x10000
#define  DDR_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_SHIFT 16
#define  DDR_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK_SHIFT(reg) (((reg) & DDR_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK) >> DDR_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_SHIFT)
#define  DDR_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK) | (((uint32_t)val) << DDR_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_SHIFT))

#define  DDR_PLL_FIXED_MODE_SSC_MODE_RESERVED2_MASK 0xfff0
#define  DDR_PLL_FIXED_MODE_SSC_MODE_RESERVED2_SHIFT 4
#define  DDR_PLL_FIXED_MODE_SSC_MODE_RESERVED2_MASK_SHIFT(reg) (((reg) & DDR_PLL_FIXED_MODE_SSC_MODE_RESERVED2_MASK) >> DDR_PLL_FIXED_MODE_SSC_MODE_RESERVED2_SHIFT)
#define  DDR_PLL_FIXED_MODE_SSC_MODE_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_FIXED_MODE_SSC_MODE_RESERVED2_MASK) | (((uint32_t)val) << DDR_PLL_FIXED_MODE_SSC_MODE_RESERVED2_SHIFT))

#define  DDR_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_MASK 0x8
#define  DDR_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_SHIFT 3
#define  DDR_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_MASK_SHIFT(reg) (((reg) & DDR_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_MASK) >> DDR_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_SHIFT)
#define  DDR_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_MASK) | (((uint32_t)val) << DDR_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_SHIFT))

#define  DDR_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK 0x4
#define  DDR_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_SHIFT 2
#define  DDR_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK_SHIFT(reg) (((reg) & DDR_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK) >> DDR_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_SHIFT)
#define  DDR_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK) | (((uint32_t)val) << DDR_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_SHIFT))

#define  DDR_PLL_FIXED_MODE_SSC_MODE_PI_EN_MASK 0x2
#define  DDR_PLL_FIXED_MODE_SSC_MODE_PI_EN_SHIFT 1
#define  DDR_PLL_FIXED_MODE_SSC_MODE_PI_EN_MASK_SHIFT(reg) (((reg) & DDR_PLL_FIXED_MODE_SSC_MODE_PI_EN_MASK) >> DDR_PLL_FIXED_MODE_SSC_MODE_PI_EN_SHIFT)
#define  DDR_PLL_FIXED_MODE_SSC_MODE_PI_EN_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_FIXED_MODE_SSC_MODE_PI_EN_MASK) | (((uint32_t)val) << DDR_PLL_FIXED_MODE_SSC_MODE_PI_EN_SHIFT))

#define  DDR_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK 0x1
#define  DDR_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_SHIFT 0
#define  DDR_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK_SHIFT(reg) (((reg) & DDR_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK) >> DDR_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_SHIFT)
#define  DDR_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK) | (((uint32_t)val) << DDR_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_SHIFT))

//====================================================================
//Register: PLL Modulation Frequency (ssc_freq_ssc_range)
/** \brief PLL Modulation Frequency Control*/
//====================================================================

#define  DDR_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK 0xffff0000
#define  DDR_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_SHIFT 16
#define  DDR_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK_SHIFT(reg) (((reg) & DDR_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK) >> DDR_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_SHIFT)
#define  DDR_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK) | (((uint32_t)val) << DDR_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_SHIFT))

#define  DDR_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_MASK 0xf800
#define  DDR_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_SHIFT 11
#define  DDR_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_MASK) >> DDR_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_SHIFT)
#define  DDR_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_SHIFT))

#define  DDR_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK 0x7ff
#define  DDR_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_SHIFT 0
#define  DDR_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK_SHIFT(reg) (((reg) & DDR_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK) >> DDR_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_SHIFT)
#define  DDR_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK) | (((uint32_t)val) << DDR_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_SHIFT))

//====================================================================
//Register: PLL Output Clock Control (clk_ctrl_marvell_test)
/** \brief PLL Output Clock Control*/
//====================================================================

#define  DDR_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK 0xfffc0000
#define  DDR_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_SHIFT 18
#define  DDR_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK) >> DDR_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_SHIFT)
#define  DDR_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_SHIFT))

#define  DDR_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK 0x20000
#define  DDR_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_SHIFT 17
#define  DDR_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK_SHIFT(reg) (((reg) & DDR_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK) >> DDR_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_SHIFT)
#define  DDR_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK) | (((uint32_t)val) << DDR_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_SHIFT))

#define  DDR_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK 0x10000
#define  DDR_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_SHIFT 16
#define  DDR_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK_SHIFT(reg) (((reg) & DDR_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK) >> DDR_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_SHIFT)
#define  DDR_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK) | (((uint32_t)val) << DDR_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_SHIFT))

#define  DDR_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK 0xf000
#define  DDR_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_SHIFT 12
#define  DDR_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK_SHIFT(reg) (((reg) & DDR_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK) >> DDR_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_SHIFT)
#define  DDR_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK) | (((uint32_t)val) << DDR_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_SHIFT))

#define  DDR_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK 0xff0
#define  DDR_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_SHIFT 4
#define  DDR_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK_SHIFT(reg) (((reg) & DDR_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK) >> DDR_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_SHIFT)
#define  DDR_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK) | (((uint32_t)val) << DDR_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_SHIFT))

#define  DDR_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK 0xf
#define  DDR_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_SHIFT 0
#define  DDR_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK_SHIFT(reg) (((reg) & DDR_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK) >> DDR_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_SHIFT)
#define  DDR_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK) | (((uint32_t)val) << DDR_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_SHIFT))

//====================================================================
//Register: PLL Lock Status (lock_status)
/** \brief PLL Lock Output*/
//====================================================================

#define  DDR_PLL_LOCK_STATUS_RESERVED1_MASK 0xfffffffe
#define  DDR_PLL_LOCK_STATUS_RESERVED1_SHIFT 1
#define  DDR_PLL_LOCK_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_LOCK_STATUS_RESERVED1_MASK) >> DDR_PLL_LOCK_STATUS_RESERVED1_SHIFT)
#define  DDR_PLL_LOCK_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_LOCK_STATUS_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_LOCK_STATUS_RESERVED1_SHIFT))

#define  DDR_PLL_LOCK_STATUS_PLL_LOCK_MASK 0x1
#define  DDR_PLL_LOCK_STATUS_PLL_LOCK_SHIFT 0
#define  DDR_PLL_LOCK_STATUS_PLL_LOCK_MASK_SHIFT(reg) (((reg) & DDR_PLL_LOCK_STATUS_PLL_LOCK_MASK) >> DDR_PLL_LOCK_STATUS_PLL_LOCK_SHIFT)
#define  DDR_PLL_LOCK_STATUS_PLL_LOCK_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_LOCK_STATUS_PLL_LOCK_MASK) | (((uint32_t)val) << DDR_PLL_LOCK_STATUS_PLL_LOCK_SHIFT))

//====================================================================
//Register: PLL RESERVE_OUT output (reserve_out)
//====================================================================

#define  DDR_PLL_RESERVE_OUT_RESERVED1_MASK 0xfffe0000
#define  DDR_PLL_RESERVE_OUT_RESERVED1_SHIFT 17
#define  DDR_PLL_RESERVE_OUT_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_RESERVE_OUT_RESERVED1_MASK) >> DDR_PLL_RESERVE_OUT_RESERVED1_SHIFT)
#define  DDR_PLL_RESERVE_OUT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_RESERVE_OUT_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_RESERVE_OUT_RESERVED1_SHIFT))

#define  DDR_PLL_RESERVE_OUT_PU18_REG_MASK 0x10000
#define  DDR_PLL_RESERVE_OUT_PU18_REG_SHIFT 16
#define  DDR_PLL_RESERVE_OUT_PU18_REG_MASK_SHIFT(reg) (((reg) & DDR_PLL_RESERVE_OUT_PU18_REG_MASK) >> DDR_PLL_RESERVE_OUT_PU18_REG_SHIFT)
#define  DDR_PLL_RESERVE_OUT_PU18_REG_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_RESERVE_OUT_PU18_REG_MASK) | (((uint32_t)val) << DDR_PLL_RESERVE_OUT_PU18_REG_SHIFT))

#define  DDR_PLL_RESERVE_OUT_RESERVED2_MASK 0xff00
#define  DDR_PLL_RESERVE_OUT_RESERVED2_SHIFT 8
#define  DDR_PLL_RESERVE_OUT_RESERVED2_MASK_SHIFT(reg) (((reg) & DDR_PLL_RESERVE_OUT_RESERVED2_MASK) >> DDR_PLL_RESERVE_OUT_RESERVED2_SHIFT)
#define  DDR_PLL_RESERVE_OUT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_RESERVE_OUT_RESERVED2_MASK) | (((uint32_t)val) << DDR_PLL_RESERVE_OUT_RESERVED2_SHIFT))

#define  DDR_PLL_RESERVE_OUT_RESERVE_OUT_MASK 0xff
#define  DDR_PLL_RESERVE_OUT_RESERVE_OUT_SHIFT 0
#define  DDR_PLL_RESERVE_OUT_RESERVE_OUT_MASK_SHIFT(reg) (((reg) & DDR_PLL_RESERVE_OUT_RESERVE_OUT_MASK) >> DDR_PLL_RESERVE_OUT_RESERVE_OUT_SHIFT)
#define  DDR_PLL_RESERVE_OUT_RESERVE_OUT_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_RESERVE_OUT_RESERVE_OUT_MASK) | (((uint32_t)val) << DDR_PLL_RESERVE_OUT_RESERVE_OUT_SHIFT))

//====================================================================
//
//Register File: DDR PLL Spread Spectrum Controls (DDR_PLL_CSSCG)
/** \brief Top-level register file for the CSSCG block*/
//
//====================================================================

//====================================================================
//Register: Interrupt Enable Register (IRQ_EN)
/** \brief Used to enable interrupts for the block.*/
//====================================================================

#define  DDR_PLL_CSSCG_IRQ_EN_RESERVED1_MASK 0xfffffe00
#define  DDR_PLL_CSSCG_IRQ_EN_RESERVED1_SHIFT 9
#define  DDR_PLL_CSSCG_IRQ_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_EN_RESERVED1_MASK) >> DDR_PLL_CSSCG_IRQ_EN_RESERVED1_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_EN_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_EN_RESERVED1_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_EN_SLV_ARMED_IRQ_EN_MASK 0x100
#define  DDR_PLL_CSSCG_IRQ_EN_SLV_ARMED_IRQ_EN_SHIFT 8
#define  DDR_PLL_CSSCG_IRQ_EN_SLV_ARMED_IRQ_EN_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_EN_SLV_ARMED_IRQ_EN_MASK) >> DDR_PLL_CSSCG_IRQ_EN_SLV_ARMED_IRQ_EN_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_EN_SLV_ARMED_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_EN_SLV_ARMED_IRQ_EN_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_EN_SLV_ARMED_IRQ_EN_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_EN_SLV_FULL_IRQ_EN_MASK 0x80
#define  DDR_PLL_CSSCG_IRQ_EN_SLV_FULL_IRQ_EN_SHIFT 7
#define  DDR_PLL_CSSCG_IRQ_EN_SLV_FULL_IRQ_EN_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_EN_SLV_FULL_IRQ_EN_MASK) >> DDR_PLL_CSSCG_IRQ_EN_SLV_FULL_IRQ_EN_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_EN_SLV_FULL_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_EN_SLV_FULL_IRQ_EN_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_EN_SLV_FULL_IRQ_EN_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_EN_SLV_INIT_IRQ_EN_MASK 0x40
#define  DDR_PLL_CSSCG_IRQ_EN_SLV_INIT_IRQ_EN_SHIFT 6
#define  DDR_PLL_CSSCG_IRQ_EN_SLV_INIT_IRQ_EN_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_EN_SLV_INIT_IRQ_EN_MASK) >> DDR_PLL_CSSCG_IRQ_EN_SLV_INIT_IRQ_EN_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_EN_SLV_INIT_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_EN_SLV_INIT_IRQ_EN_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_EN_SLV_INIT_IRQ_EN_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_EN_SLV_TIMEOUT_IRQ_EN_MASK 0x20
#define  DDR_PLL_CSSCG_IRQ_EN_SLV_TIMEOUT_IRQ_EN_SHIFT 5
#define  DDR_PLL_CSSCG_IRQ_EN_SLV_TIMEOUT_IRQ_EN_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_EN_SLV_TIMEOUT_IRQ_EN_MASK) >> DDR_PLL_CSSCG_IRQ_EN_SLV_TIMEOUT_IRQ_EN_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_EN_SLV_TIMEOUT_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_EN_SLV_TIMEOUT_IRQ_EN_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_EN_SLV_TIMEOUT_IRQ_EN_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_EN_SLV_TRIG_ERR_IRQ_EN_MASK 0x10
#define  DDR_PLL_CSSCG_IRQ_EN_SLV_TRIG_ERR_IRQ_EN_SHIFT 4
#define  DDR_PLL_CSSCG_IRQ_EN_SLV_TRIG_ERR_IRQ_EN_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_EN_SLV_TRIG_ERR_IRQ_EN_MASK) >> DDR_PLL_CSSCG_IRQ_EN_SLV_TRIG_ERR_IRQ_EN_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_EN_SLV_TRIG_ERR_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_EN_SLV_TRIG_ERR_IRQ_EN_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_EN_SLV_TRIG_ERR_IRQ_EN_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_EN_SLV_TRIG_IRQ_EN_MASK 0x8
#define  DDR_PLL_CSSCG_IRQ_EN_SLV_TRIG_IRQ_EN_SHIFT 3
#define  DDR_PLL_CSSCG_IRQ_EN_SLV_TRIG_IRQ_EN_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_EN_SLV_TRIG_IRQ_EN_MASK) >> DDR_PLL_CSSCG_IRQ_EN_SLV_TRIG_IRQ_EN_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_EN_SLV_TRIG_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_EN_SLV_TRIG_IRQ_EN_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_EN_SLV_TRIG_IRQ_EN_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_EN_HALT_COMPLETE_IRQ_EN_MASK 0x4
#define  DDR_PLL_CSSCG_IRQ_EN_HALT_COMPLETE_IRQ_EN_SHIFT 2
#define  DDR_PLL_CSSCG_IRQ_EN_HALT_COMPLETE_IRQ_EN_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_EN_HALT_COMPLETE_IRQ_EN_MASK) >> DDR_PLL_CSSCG_IRQ_EN_HALT_COMPLETE_IRQ_EN_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_EN_HALT_COMPLETE_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_EN_HALT_COMPLETE_IRQ_EN_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_EN_HALT_COMPLETE_IRQ_EN_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_EN_DISABLE_COMPLETE_IRQ_EN_MASK 0x2
#define  DDR_PLL_CSSCG_IRQ_EN_DISABLE_COMPLETE_IRQ_EN_SHIFT 1
#define  DDR_PLL_CSSCG_IRQ_EN_DISABLE_COMPLETE_IRQ_EN_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_EN_DISABLE_COMPLETE_IRQ_EN_MASK) >> DDR_PLL_CSSCG_IRQ_EN_DISABLE_COMPLETE_IRQ_EN_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_EN_DISABLE_COMPLETE_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_EN_DISABLE_COMPLETE_IRQ_EN_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_EN_DISABLE_COMPLETE_IRQ_EN_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_EN_CYCLE_START_IRQ_EN_MASK 0x1
#define  DDR_PLL_CSSCG_IRQ_EN_CYCLE_START_IRQ_EN_SHIFT 0
#define  DDR_PLL_CSSCG_IRQ_EN_CYCLE_START_IRQ_EN_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_EN_CYCLE_START_IRQ_EN_MASK) >> DDR_PLL_CSSCG_IRQ_EN_CYCLE_START_IRQ_EN_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_EN_CYCLE_START_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_EN_CYCLE_START_IRQ_EN_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_EN_CYCLE_START_IRQ_EN_SHIFT))

//====================================================================
//Register: Interrupt Pending Register (IRQ_PEND)
/** \brief Used to read the status of the block's interrupts.*/
//====================================================================

#define  DDR_PLL_CSSCG_IRQ_PEND_RESERVED1_MASK 0xfffffe00
#define  DDR_PLL_CSSCG_IRQ_PEND_RESERVED1_SHIFT 9
#define  DDR_PLL_CSSCG_IRQ_PEND_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_PEND_RESERVED1_MASK) >> DDR_PLL_CSSCG_IRQ_PEND_RESERVED1_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_PEND_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_PEND_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_PEND_RESERVED1_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_PEND_SLV_ARMED_IRQ_PEND_MASK 0x100
#define  DDR_PLL_CSSCG_IRQ_PEND_SLV_ARMED_IRQ_PEND_SHIFT 8
#define  DDR_PLL_CSSCG_IRQ_PEND_SLV_ARMED_IRQ_PEND_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_PEND_SLV_ARMED_IRQ_PEND_MASK) >> DDR_PLL_CSSCG_IRQ_PEND_SLV_ARMED_IRQ_PEND_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_PEND_SLV_ARMED_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_PEND_SLV_ARMED_IRQ_PEND_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_PEND_SLV_ARMED_IRQ_PEND_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_PEND_SLV_FULL_IRQ_PEND_MASK 0x80
#define  DDR_PLL_CSSCG_IRQ_PEND_SLV_FULL_IRQ_PEND_SHIFT 7
#define  DDR_PLL_CSSCG_IRQ_PEND_SLV_FULL_IRQ_PEND_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_PEND_SLV_FULL_IRQ_PEND_MASK) >> DDR_PLL_CSSCG_IRQ_PEND_SLV_FULL_IRQ_PEND_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_PEND_SLV_FULL_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_PEND_SLV_FULL_IRQ_PEND_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_PEND_SLV_FULL_IRQ_PEND_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_PEND_SLV_INIT_IRQ_PEND_MASK 0x40
#define  DDR_PLL_CSSCG_IRQ_PEND_SLV_INIT_IRQ_PEND_SHIFT 6
#define  DDR_PLL_CSSCG_IRQ_PEND_SLV_INIT_IRQ_PEND_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_PEND_SLV_INIT_IRQ_PEND_MASK) >> DDR_PLL_CSSCG_IRQ_PEND_SLV_INIT_IRQ_PEND_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_PEND_SLV_INIT_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_PEND_SLV_INIT_IRQ_PEND_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_PEND_SLV_INIT_IRQ_PEND_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_PEND_SLV_TIMEOUT_IRQ_PEND_MASK 0x20
#define  DDR_PLL_CSSCG_IRQ_PEND_SLV_TIMEOUT_IRQ_PEND_SHIFT 5
#define  DDR_PLL_CSSCG_IRQ_PEND_SLV_TIMEOUT_IRQ_PEND_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_PEND_SLV_TIMEOUT_IRQ_PEND_MASK) >> DDR_PLL_CSSCG_IRQ_PEND_SLV_TIMEOUT_IRQ_PEND_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_PEND_SLV_TIMEOUT_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_PEND_SLV_TIMEOUT_IRQ_PEND_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_PEND_SLV_TIMEOUT_IRQ_PEND_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_PEND_SLV_TRIG_ERR_IRQ_PEND_MASK 0x10
#define  DDR_PLL_CSSCG_IRQ_PEND_SLV_TRIG_ERR_IRQ_PEND_SHIFT 4
#define  DDR_PLL_CSSCG_IRQ_PEND_SLV_TRIG_ERR_IRQ_PEND_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_PEND_SLV_TRIG_ERR_IRQ_PEND_MASK) >> DDR_PLL_CSSCG_IRQ_PEND_SLV_TRIG_ERR_IRQ_PEND_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_PEND_SLV_TRIG_ERR_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_PEND_SLV_TRIG_ERR_IRQ_PEND_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_PEND_SLV_TRIG_ERR_IRQ_PEND_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_PEND_SLV_TRIG_IRQ_PEND_MASK 0x8
#define  DDR_PLL_CSSCG_IRQ_PEND_SLV_TRIG_IRQ_PEND_SHIFT 3
#define  DDR_PLL_CSSCG_IRQ_PEND_SLV_TRIG_IRQ_PEND_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_PEND_SLV_TRIG_IRQ_PEND_MASK) >> DDR_PLL_CSSCG_IRQ_PEND_SLV_TRIG_IRQ_PEND_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_PEND_SLV_TRIG_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_PEND_SLV_TRIG_IRQ_PEND_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_PEND_SLV_TRIG_IRQ_PEND_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_PEND_HALT_COMPLETE_IRQ_PEND_MASK 0x4
#define  DDR_PLL_CSSCG_IRQ_PEND_HALT_COMPLETE_IRQ_PEND_SHIFT 2
#define  DDR_PLL_CSSCG_IRQ_PEND_HALT_COMPLETE_IRQ_PEND_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_PEND_HALT_COMPLETE_IRQ_PEND_MASK) >> DDR_PLL_CSSCG_IRQ_PEND_HALT_COMPLETE_IRQ_PEND_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_PEND_HALT_COMPLETE_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_PEND_HALT_COMPLETE_IRQ_PEND_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_PEND_HALT_COMPLETE_IRQ_PEND_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_PEND_DISABLE_COMPLETE_IRQ_PEND_MASK 0x2
#define  DDR_PLL_CSSCG_IRQ_PEND_DISABLE_COMPLETE_IRQ_PEND_SHIFT 1
#define  DDR_PLL_CSSCG_IRQ_PEND_DISABLE_COMPLETE_IRQ_PEND_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_PEND_DISABLE_COMPLETE_IRQ_PEND_MASK) >> DDR_PLL_CSSCG_IRQ_PEND_DISABLE_COMPLETE_IRQ_PEND_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_PEND_DISABLE_COMPLETE_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_PEND_DISABLE_COMPLETE_IRQ_PEND_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_PEND_DISABLE_COMPLETE_IRQ_PEND_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_PEND_CYCLE_START_IRQ_PEND_MASK 0x1
#define  DDR_PLL_CSSCG_IRQ_PEND_CYCLE_START_IRQ_PEND_SHIFT 0
#define  DDR_PLL_CSSCG_IRQ_PEND_CYCLE_START_IRQ_PEND_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_PEND_CYCLE_START_IRQ_PEND_MASK) >> DDR_PLL_CSSCG_IRQ_PEND_CYCLE_START_IRQ_PEND_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_PEND_CYCLE_START_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_PEND_CYCLE_START_IRQ_PEND_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_PEND_CYCLE_START_IRQ_PEND_SHIFT))

//====================================================================
//Register: Interrupt Acknowledge Register (IRQ_ACK)
/** \brief Write a 1 to the bit to clear the appropriate interrupt. <br/> The Input and Output DMA interrupts must be cleared via their respective registers.*/
//====================================================================

#define  DDR_PLL_CSSCG_IRQ_ACK_RESERVED1_MASK 0xfffffe00
#define  DDR_PLL_CSSCG_IRQ_ACK_RESERVED1_SHIFT 9
#define  DDR_PLL_CSSCG_IRQ_ACK_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_ACK_RESERVED1_MASK) >> DDR_PLL_CSSCG_IRQ_ACK_RESERVED1_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_ACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_ACK_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_ACK_RESERVED1_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_ACK_SLV_ARMED_IRQ_ACK_MASK 0x100
#define  DDR_PLL_CSSCG_IRQ_ACK_SLV_ARMED_IRQ_ACK_SHIFT 8
#define  DDR_PLL_CSSCG_IRQ_ACK_SLV_ARMED_IRQ_ACK_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_ACK_SLV_ARMED_IRQ_ACK_MASK) >> DDR_PLL_CSSCG_IRQ_ACK_SLV_ARMED_IRQ_ACK_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_ACK_SLV_ARMED_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_ACK_SLV_ARMED_IRQ_ACK_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_ACK_SLV_ARMED_IRQ_ACK_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_ACK_SLV_FULL_IRQ_ACK_MASK 0x80
#define  DDR_PLL_CSSCG_IRQ_ACK_SLV_FULL_IRQ_ACK_SHIFT 7
#define  DDR_PLL_CSSCG_IRQ_ACK_SLV_FULL_IRQ_ACK_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_ACK_SLV_FULL_IRQ_ACK_MASK) >> DDR_PLL_CSSCG_IRQ_ACK_SLV_FULL_IRQ_ACK_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_ACK_SLV_FULL_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_ACK_SLV_FULL_IRQ_ACK_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_ACK_SLV_FULL_IRQ_ACK_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_ACK_SLV_INIT_IRQ_ACK_MASK 0x40
#define  DDR_PLL_CSSCG_IRQ_ACK_SLV_INIT_IRQ_ACK_SHIFT 6
#define  DDR_PLL_CSSCG_IRQ_ACK_SLV_INIT_IRQ_ACK_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_ACK_SLV_INIT_IRQ_ACK_MASK) >> DDR_PLL_CSSCG_IRQ_ACK_SLV_INIT_IRQ_ACK_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_ACK_SLV_INIT_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_ACK_SLV_INIT_IRQ_ACK_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_ACK_SLV_INIT_IRQ_ACK_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_ACK_SLV_TIMEOUT_IRQ_ACK_MASK 0x20
#define  DDR_PLL_CSSCG_IRQ_ACK_SLV_TIMEOUT_IRQ_ACK_SHIFT 5
#define  DDR_PLL_CSSCG_IRQ_ACK_SLV_TIMEOUT_IRQ_ACK_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_ACK_SLV_TIMEOUT_IRQ_ACK_MASK) >> DDR_PLL_CSSCG_IRQ_ACK_SLV_TIMEOUT_IRQ_ACK_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_ACK_SLV_TIMEOUT_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_ACK_SLV_TIMEOUT_IRQ_ACK_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_ACK_SLV_TIMEOUT_IRQ_ACK_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_ACK_SLV_TRIG_ERR_IRQ_ACK_MASK 0x10
#define  DDR_PLL_CSSCG_IRQ_ACK_SLV_TRIG_ERR_IRQ_ACK_SHIFT 4
#define  DDR_PLL_CSSCG_IRQ_ACK_SLV_TRIG_ERR_IRQ_ACK_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_ACK_SLV_TRIG_ERR_IRQ_ACK_MASK) >> DDR_PLL_CSSCG_IRQ_ACK_SLV_TRIG_ERR_IRQ_ACK_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_ACK_SLV_TRIG_ERR_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_ACK_SLV_TRIG_ERR_IRQ_ACK_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_ACK_SLV_TRIG_ERR_IRQ_ACK_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_ACK_SLV_TRIG_IRQ_ACK_MASK 0x8
#define  DDR_PLL_CSSCG_IRQ_ACK_SLV_TRIG_IRQ_ACK_SHIFT 3
#define  DDR_PLL_CSSCG_IRQ_ACK_SLV_TRIG_IRQ_ACK_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_ACK_SLV_TRIG_IRQ_ACK_MASK) >> DDR_PLL_CSSCG_IRQ_ACK_SLV_TRIG_IRQ_ACK_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_ACK_SLV_TRIG_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_ACK_SLV_TRIG_IRQ_ACK_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_ACK_SLV_TRIG_IRQ_ACK_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_ACK_HALT_COMPLETE_IRQ_ACK_MASK 0x4
#define  DDR_PLL_CSSCG_IRQ_ACK_HALT_COMPLETE_IRQ_ACK_SHIFT 2
#define  DDR_PLL_CSSCG_IRQ_ACK_HALT_COMPLETE_IRQ_ACK_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_ACK_HALT_COMPLETE_IRQ_ACK_MASK) >> DDR_PLL_CSSCG_IRQ_ACK_HALT_COMPLETE_IRQ_ACK_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_ACK_HALT_COMPLETE_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_ACK_HALT_COMPLETE_IRQ_ACK_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_ACK_HALT_COMPLETE_IRQ_ACK_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_ACK_DISABLE_COMPLETE_IRQ_ACK_MASK 0x2
#define  DDR_PLL_CSSCG_IRQ_ACK_DISABLE_COMPLETE_IRQ_ACK_SHIFT 1
#define  DDR_PLL_CSSCG_IRQ_ACK_DISABLE_COMPLETE_IRQ_ACK_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_ACK_DISABLE_COMPLETE_IRQ_ACK_MASK) >> DDR_PLL_CSSCG_IRQ_ACK_DISABLE_COMPLETE_IRQ_ACK_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_ACK_DISABLE_COMPLETE_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_ACK_DISABLE_COMPLETE_IRQ_ACK_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_ACK_DISABLE_COMPLETE_IRQ_ACK_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_ACK_CYCLE_START_IRQ_ACK_MASK 0x1
#define  DDR_PLL_CSSCG_IRQ_ACK_CYCLE_START_IRQ_ACK_SHIFT 0
#define  DDR_PLL_CSSCG_IRQ_ACK_CYCLE_START_IRQ_ACK_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_ACK_CYCLE_START_IRQ_ACK_MASK) >> DDR_PLL_CSSCG_IRQ_ACK_CYCLE_START_IRQ_ACK_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_ACK_CYCLE_START_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_ACK_CYCLE_START_IRQ_ACK_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_ACK_CYCLE_START_IRQ_ACK_SHIFT))

//====================================================================
//Register: Interrupt Force Register (IRQ_FORCE)
/** \brief Write a 1 to the bit to force the interrupt for testing purposes. <br/>*/
//====================================================================

#define  DDR_PLL_CSSCG_IRQ_FORCE_RESERVED1_MASK 0xfffffe00
#define  DDR_PLL_CSSCG_IRQ_FORCE_RESERVED1_SHIFT 9
#define  DDR_PLL_CSSCG_IRQ_FORCE_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_FORCE_RESERVED1_MASK) >> DDR_PLL_CSSCG_IRQ_FORCE_RESERVED1_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_FORCE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_FORCE_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_FORCE_RESERVED1_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_FORCE_SLV_ARMED_IRQ_FORCE_MASK 0x100
#define  DDR_PLL_CSSCG_IRQ_FORCE_SLV_ARMED_IRQ_FORCE_SHIFT 8
#define  DDR_PLL_CSSCG_IRQ_FORCE_SLV_ARMED_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_FORCE_SLV_ARMED_IRQ_FORCE_MASK) >> DDR_PLL_CSSCG_IRQ_FORCE_SLV_ARMED_IRQ_FORCE_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_FORCE_SLV_ARMED_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_FORCE_SLV_ARMED_IRQ_FORCE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_FORCE_SLV_ARMED_IRQ_FORCE_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_FORCE_SLV_FULL_IRQ_FORCE_MASK 0x80
#define  DDR_PLL_CSSCG_IRQ_FORCE_SLV_FULL_IRQ_FORCE_SHIFT 7
#define  DDR_PLL_CSSCG_IRQ_FORCE_SLV_FULL_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_FORCE_SLV_FULL_IRQ_FORCE_MASK) >> DDR_PLL_CSSCG_IRQ_FORCE_SLV_FULL_IRQ_FORCE_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_FORCE_SLV_FULL_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_FORCE_SLV_FULL_IRQ_FORCE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_FORCE_SLV_FULL_IRQ_FORCE_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_FORCE_SLV_INIT_IRQ_FORCE_MASK 0x40
#define  DDR_PLL_CSSCG_IRQ_FORCE_SLV_INIT_IRQ_FORCE_SHIFT 6
#define  DDR_PLL_CSSCG_IRQ_FORCE_SLV_INIT_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_FORCE_SLV_INIT_IRQ_FORCE_MASK) >> DDR_PLL_CSSCG_IRQ_FORCE_SLV_INIT_IRQ_FORCE_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_FORCE_SLV_INIT_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_FORCE_SLV_INIT_IRQ_FORCE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_FORCE_SLV_INIT_IRQ_FORCE_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_FORCE_SLV_TIMEOUT_IRQ_FORCE_MASK 0x20
#define  DDR_PLL_CSSCG_IRQ_FORCE_SLV_TIMEOUT_IRQ_FORCE_SHIFT 5
#define  DDR_PLL_CSSCG_IRQ_FORCE_SLV_TIMEOUT_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_FORCE_SLV_TIMEOUT_IRQ_FORCE_MASK) >> DDR_PLL_CSSCG_IRQ_FORCE_SLV_TIMEOUT_IRQ_FORCE_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_FORCE_SLV_TIMEOUT_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_FORCE_SLV_TIMEOUT_IRQ_FORCE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_FORCE_SLV_TIMEOUT_IRQ_FORCE_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_ERR_IRQ_FORCE_MASK 0x10
#define  DDR_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_ERR_IRQ_FORCE_SHIFT 4
#define  DDR_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_ERR_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_ERR_IRQ_FORCE_MASK) >> DDR_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_ERR_IRQ_FORCE_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_ERR_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_ERR_IRQ_FORCE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_ERR_IRQ_FORCE_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_IRQ_FORCE_MASK 0x8
#define  DDR_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_IRQ_FORCE_SHIFT 3
#define  DDR_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_IRQ_FORCE_MASK) >> DDR_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_IRQ_FORCE_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_IRQ_FORCE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_IRQ_FORCE_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_FORCE_HALT_COMPLETE_IRQ_FORCE_MASK 0x4
#define  DDR_PLL_CSSCG_IRQ_FORCE_HALT_COMPLETE_IRQ_FORCE_SHIFT 2
#define  DDR_PLL_CSSCG_IRQ_FORCE_HALT_COMPLETE_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_FORCE_HALT_COMPLETE_IRQ_FORCE_MASK) >> DDR_PLL_CSSCG_IRQ_FORCE_HALT_COMPLETE_IRQ_FORCE_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_FORCE_HALT_COMPLETE_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_FORCE_HALT_COMPLETE_IRQ_FORCE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_FORCE_HALT_COMPLETE_IRQ_FORCE_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_FORCE_DISABLE_COMPLETE_IRQ_FORCE_MASK 0x2
#define  DDR_PLL_CSSCG_IRQ_FORCE_DISABLE_COMPLETE_IRQ_FORCE_SHIFT 1
#define  DDR_PLL_CSSCG_IRQ_FORCE_DISABLE_COMPLETE_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_FORCE_DISABLE_COMPLETE_IRQ_FORCE_MASK) >> DDR_PLL_CSSCG_IRQ_FORCE_DISABLE_COMPLETE_IRQ_FORCE_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_FORCE_DISABLE_COMPLETE_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_FORCE_DISABLE_COMPLETE_IRQ_FORCE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_FORCE_DISABLE_COMPLETE_IRQ_FORCE_SHIFT))

#define  DDR_PLL_CSSCG_IRQ_FORCE_CYCLE_START_IRQ_FORCE_MASK 0x1
#define  DDR_PLL_CSSCG_IRQ_FORCE_CYCLE_START_IRQ_FORCE_SHIFT 0
#define  DDR_PLL_CSSCG_IRQ_FORCE_CYCLE_START_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_IRQ_FORCE_CYCLE_START_IRQ_FORCE_MASK) >> DDR_PLL_CSSCG_IRQ_FORCE_CYCLE_START_IRQ_FORCE_SHIFT)
#define  DDR_PLL_CSSCG_IRQ_FORCE_CYCLE_START_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_IRQ_FORCE_CYCLE_START_IRQ_FORCE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_IRQ_FORCE_CYCLE_START_IRQ_FORCE_SHIFT))

//====================================================================
//Register: CSSCG Mode Configuration Register (MODE_CONFIG)
/** \brief This register configures the CSSCG modes of operation.*/
//====================================================================

#define  DDR_PLL_CSSCG_MODE_CONFIG_SOFT_RESET_MASK 0x80000000
#define  DDR_PLL_CSSCG_MODE_CONFIG_SOFT_RESET_SHIFT 31
#define  DDR_PLL_CSSCG_MODE_CONFIG_SOFT_RESET_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_MODE_CONFIG_SOFT_RESET_MASK) >> DDR_PLL_CSSCG_MODE_CONFIG_SOFT_RESET_SHIFT)
#define  DDR_PLL_CSSCG_MODE_CONFIG_SOFT_RESET_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_MODE_CONFIG_SOFT_RESET_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_MODE_CONFIG_SOFT_RESET_SHIFT))

#define  DDR_PLL_CSSCG_MODE_CONFIG_RESERVED1_MASK 0x40000000
#define  DDR_PLL_CSSCG_MODE_CONFIG_RESERVED1_SHIFT 30
#define  DDR_PLL_CSSCG_MODE_CONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_MODE_CONFIG_RESERVED1_MASK) >> DDR_PLL_CSSCG_MODE_CONFIG_RESERVED1_SHIFT)
#define  DDR_PLL_CSSCG_MODE_CONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_MODE_CONFIG_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_MODE_CONFIG_RESERVED1_SHIFT))

#define  DDR_PLL_CSSCG_MODE_CONFIG_MAX_ADDR_MASK 0x3f000000
#define  DDR_PLL_CSSCG_MODE_CONFIG_MAX_ADDR_SHIFT 24
#define  DDR_PLL_CSSCG_MODE_CONFIG_MAX_ADDR_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_MODE_CONFIG_MAX_ADDR_MASK) >> DDR_PLL_CSSCG_MODE_CONFIG_MAX_ADDR_SHIFT)
#define  DDR_PLL_CSSCG_MODE_CONFIG_MAX_ADDR_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_MODE_CONFIG_MAX_ADDR_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_MODE_CONFIG_MAX_ADDR_SHIFT))

#define  DDR_PLL_CSSCG_MODE_CONFIG_RESERVED2_MASK 0xc00000
#define  DDR_PLL_CSSCG_MODE_CONFIG_RESERVED2_SHIFT 22
#define  DDR_PLL_CSSCG_MODE_CONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_MODE_CONFIG_RESERVED2_MASK) >> DDR_PLL_CSSCG_MODE_CONFIG_RESERVED2_SHIFT)
#define  DDR_PLL_CSSCG_MODE_CONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_MODE_CONFIG_RESERVED2_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_MODE_CONFIG_RESERVED2_SHIFT))

#define  DDR_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_TYPE_MASK 0x200000
#define  DDR_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_TYPE_SHIFT 21
#define  DDR_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_TYPE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_TYPE_MASK) >> DDR_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_TYPE_SHIFT)
#define  DDR_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_TYPE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_TYPE_SHIFT))

#define  DDR_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_EN_MASK 0x100000
#define  DDR_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_EN_SHIFT 20
#define  DDR_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_EN_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_EN_MASK) >> DDR_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_EN_SHIFT)
#define  DDR_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_EN_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_EN_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_EN_SHIFT))

#define  DDR_PLL_CSSCG_MODE_CONFIG_INTERP_POINTS_MASK 0xff000
#define  DDR_PLL_CSSCG_MODE_CONFIG_INTERP_POINTS_SHIFT 12
#define  DDR_PLL_CSSCG_MODE_CONFIG_INTERP_POINTS_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_MODE_CONFIG_INTERP_POINTS_MASK) >> DDR_PLL_CSSCG_MODE_CONFIG_INTERP_POINTS_SHIFT)
#define  DDR_PLL_CSSCG_MODE_CONFIG_INTERP_POINTS_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_MODE_CONFIG_INTERP_POINTS_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_MODE_CONFIG_INTERP_POINTS_SHIFT))

#define  DDR_PLL_CSSCG_MODE_CONFIG_RESERVED3_MASK 0xe00
#define  DDR_PLL_CSSCG_MODE_CONFIG_RESERVED3_SHIFT 9
#define  DDR_PLL_CSSCG_MODE_CONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_MODE_CONFIG_RESERVED3_MASK) >> DDR_PLL_CSSCG_MODE_CONFIG_RESERVED3_SHIFT)
#define  DDR_PLL_CSSCG_MODE_CONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_MODE_CONFIG_RESERVED3_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_MODE_CONFIG_RESERVED3_SHIFT))

#define  DDR_PLL_CSSCG_MODE_CONFIG_RATE_DIV_M1_MASK 0x1f0
#define  DDR_PLL_CSSCG_MODE_CONFIG_RATE_DIV_M1_SHIFT 4
#define  DDR_PLL_CSSCG_MODE_CONFIG_RATE_DIV_M1_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_MODE_CONFIG_RATE_DIV_M1_MASK) >> DDR_PLL_CSSCG_MODE_CONFIG_RATE_DIV_M1_SHIFT)
#define  DDR_PLL_CSSCG_MODE_CONFIG_RATE_DIV_M1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_MODE_CONFIG_RATE_DIV_M1_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_MODE_CONFIG_RATE_DIV_M1_SHIFT))

#define  DDR_PLL_CSSCG_MODE_CONFIG_RESERVED4_MASK 0x8
#define  DDR_PLL_CSSCG_MODE_CONFIG_RESERVED4_SHIFT 3
#define  DDR_PLL_CSSCG_MODE_CONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_MODE_CONFIG_RESERVED4_MASK) >> DDR_PLL_CSSCG_MODE_CONFIG_RESERVED4_SHIFT)
#define  DDR_PLL_CSSCG_MODE_CONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_MODE_CONFIG_RESERVED4_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_MODE_CONFIG_RESERVED4_SHIFT))

#define  DDR_PLL_CSSCG_MODE_CONFIG_SLV_SYNC_MODE_MASK 0x4
#define  DDR_PLL_CSSCG_MODE_CONFIG_SLV_SYNC_MODE_SHIFT 2
#define  DDR_PLL_CSSCG_MODE_CONFIG_SLV_SYNC_MODE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_MODE_CONFIG_SLV_SYNC_MODE_MASK) >> DDR_PLL_CSSCG_MODE_CONFIG_SLV_SYNC_MODE_SHIFT)
#define  DDR_PLL_CSSCG_MODE_CONFIG_SLV_SYNC_MODE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_MODE_CONFIG_SLV_SYNC_MODE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_MODE_CONFIG_SLV_SYNC_MODE_SHIFT))

#define  DDR_PLL_CSSCG_MODE_CONFIG_APPLY_CORRECTION_MASK 0x2
#define  DDR_PLL_CSSCG_MODE_CONFIG_APPLY_CORRECTION_SHIFT 1
#define  DDR_PLL_CSSCG_MODE_CONFIG_APPLY_CORRECTION_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_MODE_CONFIG_APPLY_CORRECTION_MASK) >> DDR_PLL_CSSCG_MODE_CONFIG_APPLY_CORRECTION_SHIFT)
#define  DDR_PLL_CSSCG_MODE_CONFIG_APPLY_CORRECTION_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_MODE_CONFIG_APPLY_CORRECTION_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_MODE_CONFIG_APPLY_CORRECTION_SHIFT))

#define  DDR_PLL_CSSCG_MODE_CONFIG_DOWN_SPREAD_MASK 0x1
#define  DDR_PLL_CSSCG_MODE_CONFIG_DOWN_SPREAD_SHIFT 0
#define  DDR_PLL_CSSCG_MODE_CONFIG_DOWN_SPREAD_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_MODE_CONFIG_DOWN_SPREAD_MASK) >> DDR_PLL_CSSCG_MODE_CONFIG_DOWN_SPREAD_SHIFT)
#define  DDR_PLL_CSSCG_MODE_CONFIG_DOWN_SPREAD_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_MODE_CONFIG_DOWN_SPREAD_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_MODE_CONFIG_DOWN_SPREAD_SHIFT))

//====================================================================
//Register: CSSCG Halt Configuration Register (HALT_CONFIG)
/** \brief This register defines the place on the dither curve where the block will stop upon a halt request. Note that the block will continue to send offset codes to the PLL*/
//====================================================================

#define  DDR_PLL_CSSCG_HALT_CONFIG_RESERVED1_MASK 0xfffc0000
#define  DDR_PLL_CSSCG_HALT_CONFIG_RESERVED1_SHIFT 18
#define  DDR_PLL_CSSCG_HALT_CONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_HALT_CONFIG_RESERVED1_MASK) >> DDR_PLL_CSSCG_HALT_CONFIG_RESERVED1_SHIFT)
#define  DDR_PLL_CSSCG_HALT_CONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_HALT_CONFIG_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_HALT_CONFIG_RESERVED1_SHIFT))

#define  DDR_PLL_CSSCG_HALT_CONFIG_HALT_PHASE_MASK 0x30000
#define  DDR_PLL_CSSCG_HALT_CONFIG_HALT_PHASE_SHIFT 16
#define  DDR_PLL_CSSCG_HALT_CONFIG_HALT_PHASE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_HALT_CONFIG_HALT_PHASE_MASK) >> DDR_PLL_CSSCG_HALT_CONFIG_HALT_PHASE_SHIFT)
#define  DDR_PLL_CSSCG_HALT_CONFIG_HALT_PHASE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_HALT_CONFIG_HALT_PHASE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_HALT_CONFIG_HALT_PHASE_SHIFT))

#define  DDR_PLL_CSSCG_HALT_CONFIG_RESERVED2_MASK 0xffc0
#define  DDR_PLL_CSSCG_HALT_CONFIG_RESERVED2_SHIFT 6
#define  DDR_PLL_CSSCG_HALT_CONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_HALT_CONFIG_RESERVED2_MASK) >> DDR_PLL_CSSCG_HALT_CONFIG_RESERVED2_SHIFT)
#define  DDR_PLL_CSSCG_HALT_CONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_HALT_CONFIG_RESERVED2_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_HALT_CONFIG_RESERVED2_SHIFT))

#define  DDR_PLL_CSSCG_HALT_CONFIG_HALT_ADDR_MASK 0x3f
#define  DDR_PLL_CSSCG_HALT_CONFIG_HALT_ADDR_SHIFT 0
#define  DDR_PLL_CSSCG_HALT_CONFIG_HALT_ADDR_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_HALT_CONFIG_HALT_ADDR_MASK) >> DDR_PLL_CSSCG_HALT_CONFIG_HALT_ADDR_SHIFT)
#define  DDR_PLL_CSSCG_HALT_CONFIG_HALT_ADDR_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_HALT_CONFIG_HALT_ADDR_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_HALT_CONFIG_HALT_ADDR_SHIFT))

//====================================================================
//Register: CSSCG Sign Bit Override Register (SB_OVER)
/** \brief This register is used to override the sign bit to the PLL.*/
//====================================================================

#define  DDR_PLL_CSSCG_SB_OVER_RESERVED1_MASK 0xfffffffe
#define  DDR_PLL_CSSCG_SB_OVER_RESERVED1_SHIFT 1
#define  DDR_PLL_CSSCG_SB_OVER_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_SB_OVER_RESERVED1_MASK) >> DDR_PLL_CSSCG_SB_OVER_RESERVED1_SHIFT)
#define  DDR_PLL_CSSCG_SB_OVER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_SB_OVER_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_SB_OVER_RESERVED1_SHIFT))

#define  DDR_PLL_CSSCG_SB_OVER_SB_OVERRIDE_MASK 0x1
#define  DDR_PLL_CSSCG_SB_OVER_SB_OVERRIDE_SHIFT 0
#define  DDR_PLL_CSSCG_SB_OVER_SB_OVERRIDE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_SB_OVER_SB_OVERRIDE_MASK) >> DDR_PLL_CSSCG_SB_OVER_SB_OVERRIDE_SHIFT)
#define  DDR_PLL_CSSCG_SB_OVER_SB_OVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_SB_OVER_SB_OVERRIDE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_SB_OVER_SB_OVERRIDE_SHIFT))

//====================================================================
//Register: CSSCG Control Register (CONTROL)
/** \brief This register is used to start/stop the CSSCG block.*/
//====================================================================

#define  DDR_PLL_CSSCG_CONTROL_RESERVED1_MASK 0xfffffff8
#define  DDR_PLL_CSSCG_CONTROL_RESERVED1_SHIFT 3
#define  DDR_PLL_CSSCG_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_CONTROL_RESERVED1_MASK) >> DDR_PLL_CSSCG_CONTROL_RESERVED1_SHIFT)
#define  DDR_PLL_CSSCG_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_CONTROL_RESERVED1_SHIFT))

#define  DDR_PLL_CSSCG_CONTROL_CSSCG_EXTERNAL_MUX_SEL_MASK 0x4
#define  DDR_PLL_CSSCG_CONTROL_CSSCG_EXTERNAL_MUX_SEL_SHIFT 2
#define  DDR_PLL_CSSCG_CONTROL_CSSCG_EXTERNAL_MUX_SEL_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_CONTROL_CSSCG_EXTERNAL_MUX_SEL_MASK) >> DDR_PLL_CSSCG_CONTROL_CSSCG_EXTERNAL_MUX_SEL_SHIFT)
#define  DDR_PLL_CSSCG_CONTROL_CSSCG_EXTERNAL_MUX_SEL_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_CONTROL_CSSCG_EXTERNAL_MUX_SEL_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_CONTROL_CSSCG_EXTERNAL_MUX_SEL_SHIFT))

#define  DDR_PLL_CSSCG_CONTROL_HALT_EN_MASK 0x2
#define  DDR_PLL_CSSCG_CONTROL_HALT_EN_SHIFT 1
#define  DDR_PLL_CSSCG_CONTROL_HALT_EN_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_CONTROL_HALT_EN_MASK) >> DDR_PLL_CSSCG_CONTROL_HALT_EN_SHIFT)
#define  DDR_PLL_CSSCG_CONTROL_HALT_EN_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_CONTROL_HALT_EN_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_CONTROL_HALT_EN_SHIFT))

#define  DDR_PLL_CSSCG_CONTROL_CSSCG_ENABLE_MASK 0x1
#define  DDR_PLL_CSSCG_CONTROL_CSSCG_ENABLE_SHIFT 0
#define  DDR_PLL_CSSCG_CONTROL_CSSCG_ENABLE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_CONTROL_CSSCG_ENABLE_MASK) >> DDR_PLL_CSSCG_CONTROL_CSSCG_ENABLE_SHIFT)
#define  DDR_PLL_CSSCG_CONTROL_CSSCG_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_CONTROL_CSSCG_ENABLE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_CONTROL_CSSCG_ENABLE_SHIFT))

//====================================================================
//Register: CSSCG Master Sync Status Register (STATUS_MST_SYNC)
/** \brief This register provides the internal status of the block when in Master Sync Mode. It can be used to determine when a halt has completed. It can also be used for debug purposes.*/
//====================================================================

#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_RESERVED1_MASK 0x80000000
#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_RESERVED1_SHIFT 31
#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_STATUS_MST_SYNC_RESERVED1_MASK) >> DDR_PLL_CSSCG_STATUS_MST_SYNC_RESERVED1_SHIFT)
#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_STATUS_MST_SYNC_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_STATUS_MST_SYNC_RESERVED1_SHIFT))

#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_MST_STATE_MASK 0x70000000
#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_MST_STATE_SHIFT 28
#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_MST_STATE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_STATUS_MST_SYNC_MST_STATE_MASK) >> DDR_PLL_CSSCG_STATUS_MST_SYNC_MST_STATE_SHIFT)
#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_MST_STATE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_STATUS_MST_SYNC_MST_STATE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_STATUS_MST_SYNC_MST_STATE_SHIFT))

#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_RESERVED2_MASK 0xffffc00
#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_RESERVED2_SHIFT 10
#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_RESERVED2_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_STATUS_MST_SYNC_RESERVED2_MASK) >> DDR_PLL_CSSCG_STATUS_MST_SYNC_RESERVED2_SHIFT)
#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_STATUS_MST_SYNC_RESERVED2_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_STATUS_MST_SYNC_RESERVED2_SHIFT))

#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_CURRENT_ADDR_MASK 0x3f0
#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_CURRENT_ADDR_SHIFT 4
#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_CURRENT_ADDR_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_STATUS_MST_SYNC_CURRENT_ADDR_MASK) >> DDR_PLL_CSSCG_STATUS_MST_SYNC_CURRENT_ADDR_SHIFT)
#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_CURRENT_ADDR_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_STATUS_MST_SYNC_CURRENT_ADDR_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_STATUS_MST_SYNC_CURRENT_ADDR_SHIFT))

#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_RESERVED3_MASK 0xc
#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_RESERVED3_SHIFT 2
#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_RESERVED3_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_STATUS_MST_SYNC_RESERVED3_MASK) >> DDR_PLL_CSSCG_STATUS_MST_SYNC_RESERVED3_SHIFT)
#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_STATUS_MST_SYNC_RESERVED3_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_STATUS_MST_SYNC_RESERVED3_SHIFT))

#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_HALTED_MASK 0x2
#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_HALTED_SHIFT 1
#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_HALTED_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_STATUS_MST_SYNC_HALTED_MASK) >> DDR_PLL_CSSCG_STATUS_MST_SYNC_HALTED_SHIFT)
#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_HALTED_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_STATUS_MST_SYNC_HALTED_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_STATUS_MST_SYNC_HALTED_SHIFT))

#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_ACTIVE_MASK 0x1
#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_ACTIVE_SHIFT 0
#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_ACTIVE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_STATUS_MST_SYNC_ACTIVE_MASK) >> DDR_PLL_CSSCG_STATUS_MST_SYNC_ACTIVE_SHIFT)
#define  DDR_PLL_CSSCG_STATUS_MST_SYNC_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_STATUS_MST_SYNC_ACTIVE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_STATUS_MST_SYNC_ACTIVE_SHIFT))

//====================================================================
//Register: CSSCG Slave Sync Status Register 0 (STATUS_SLV_SYNC_0)
/** \brief This register provides the internal status of the block when in Slave Sync Mode. It can be used to determine when a halt has completed. It can also be used for debug purposes.*/
//====================================================================

#define  DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED1_MASK 0xfffc0000
#define  DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED1_SHIFT 18
#define  DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED1_MASK) >> DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED1_SHIFT)
#define  DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED1_SHIFT))

#define  DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_CURRENT_ADDR_MASK 0x3f000
#define  DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_CURRENT_ADDR_SHIFT 12
#define  DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_CURRENT_ADDR_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_CURRENT_ADDR_MASK) >> DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_CURRENT_ADDR_SHIFT)
#define  DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_CURRENT_ADDR_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_CURRENT_ADDR_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_CURRENT_ADDR_SHIFT))

#define  DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED2_MASK 0xf80
#define  DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED2_SHIFT 7
#define  DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED2_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED2_MASK) >> DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED2_SHIFT)
#define  DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED2_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED2_SHIFT))

#define  DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_SLV_STATE_MASK 0x7c
#define  DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_SLV_STATE_SHIFT 2
#define  DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_SLV_STATE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_SLV_STATE_MASK) >> DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_SLV_STATE_SHIFT)
#define  DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_SLV_STATE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_SLV_STATE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_SLV_STATE_SHIFT))

#define  DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_HALTED_MASK 0x2
#define  DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_HALTED_SHIFT 1
#define  DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_HALTED_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_HALTED_MASK) >> DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_HALTED_SHIFT)
#define  DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_HALTED_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_HALTED_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_HALTED_SHIFT))

#define  DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_ACTIVE_MASK 0x1
#define  DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_ACTIVE_SHIFT 0
#define  DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_ACTIVE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_ACTIVE_MASK) >> DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_ACTIVE_SHIFT)
#define  DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_ACTIVE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_STATUS_SLV_SYNC_0_ACTIVE_SHIFT))

//====================================================================
//Register: CSSCG Code Status (STATUS_CODE)
/** \brief This register provides the status of current code being sent to the PLL. Used in both master and slave sync mode debug.*/
//====================================================================

#define  DDR_PLL_CSSCG_STATUS_CODE_NEWCODE_UPDATE_MASK 0x80000000
#define  DDR_PLL_CSSCG_STATUS_CODE_NEWCODE_UPDATE_SHIFT 31
#define  DDR_PLL_CSSCG_STATUS_CODE_NEWCODE_UPDATE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_STATUS_CODE_NEWCODE_UPDATE_MASK) >> DDR_PLL_CSSCG_STATUS_CODE_NEWCODE_UPDATE_SHIFT)
#define  DDR_PLL_CSSCG_STATUS_CODE_NEWCODE_UPDATE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_STATUS_CODE_NEWCODE_UPDATE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_STATUS_CODE_NEWCODE_UPDATE_SHIFT))

#define  DDR_PLL_CSSCG_STATUS_CODE_RESERVED1_MASK 0x7ffe0000
#define  DDR_PLL_CSSCG_STATUS_CODE_RESERVED1_SHIFT 17
#define  DDR_PLL_CSSCG_STATUS_CODE_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_STATUS_CODE_RESERVED1_MASK) >> DDR_PLL_CSSCG_STATUS_CODE_RESERVED1_SHIFT)
#define  DDR_PLL_CSSCG_STATUS_CODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_STATUS_CODE_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_STATUS_CODE_RESERVED1_SHIFT))

#define  DDR_PLL_CSSCG_STATUS_CODE_NEWCODE_MASK 0x1ffff
#define  DDR_PLL_CSSCG_STATUS_CODE_NEWCODE_SHIFT 0
#define  DDR_PLL_CSSCG_STATUS_CODE_NEWCODE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_STATUS_CODE_NEWCODE_MASK) >> DDR_PLL_CSSCG_STATUS_CODE_NEWCODE_SHIFT)
#define  DDR_PLL_CSSCG_STATUS_CODE_NEWCODE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_STATUS_CODE_NEWCODE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_STATUS_CODE_NEWCODE_SHIFT))

//====================================================================
//Register: CSSCG Config A Slave Mode Full Cycle Count Config (SLV_N_FULL_A)
/** \brief This register defines how many full cycles the CSSCG will perform in slave sync mode for configuration A.*/
//====================================================================

#define  DDR_PLL_CSSCG_SLV_N_FULL_A_SLV_N_FULL_MASK 0xffffffff
#define  DDR_PLL_CSSCG_SLV_N_FULL_A_SLV_N_FULL_SHIFT 0
#define  DDR_PLL_CSSCG_SLV_N_FULL_A_SLV_N_FULL_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_SLV_N_FULL_A_SLV_N_FULL_MASK) >> DDR_PLL_CSSCG_SLV_N_FULL_A_SLV_N_FULL_SHIFT)
#define  DDR_PLL_CSSCG_SLV_N_FULL_A_SLV_N_FULL_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_SLV_N_FULL_A_SLV_N_FULL_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_SLV_N_FULL_A_SLV_N_FULL_SHIFT))

//====================================================================
//Register: CSSCG Config A Slave Mode End Configuration Register (SLV_END_CONFIG_A)
/** \brief This register defines the phase and table entry upon which it will halt the "partial phase"
      after all of the full phases for configuration A.*/
//====================================================================

#define  DDR_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED1_MASK 0xfffc0000
#define  DDR_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED1_SHIFT 18
#define  DDR_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED1_MASK) >> DDR_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED1_SHIFT)
#define  DDR_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED1_SHIFT))

#define  DDR_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_PHASE_MASK 0x30000
#define  DDR_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_PHASE_SHIFT 16
#define  DDR_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_PHASE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_PHASE_MASK) >> DDR_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_PHASE_SHIFT)
#define  DDR_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_PHASE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_PHASE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_PHASE_SHIFT))

#define  DDR_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED2_MASK 0xffc0
#define  DDR_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED2_SHIFT 6
#define  DDR_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED2_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED2_MASK) >> DDR_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED2_SHIFT)
#define  DDR_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED2_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED2_SHIFT))

#define  DDR_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_ADDR_MASK 0x3f
#define  DDR_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_ADDR_SHIFT 0
#define  DDR_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_ADDR_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_ADDR_MASK) >> DDR_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_ADDR_SHIFT)
#define  DDR_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_ADDR_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_ADDR_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_ADDR_SHIFT))

//====================================================================
//Register: CSSCG Config A Slave Mode Return-to-Zero Register (SLV_RTZ_A)
/** \brief This register controls how the block will linearly return-to-zero
      after the partial phase for configuration A.*/
//====================================================================

#define  DDR_PLL_CSSCG_SLV_RTZ_A_RESERVED1_MASK 0xffff0000
#define  DDR_PLL_CSSCG_SLV_RTZ_A_RESERVED1_SHIFT 16
#define  DDR_PLL_CSSCG_SLV_RTZ_A_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_SLV_RTZ_A_RESERVED1_MASK) >> DDR_PLL_CSSCG_SLV_RTZ_A_RESERVED1_SHIFT)
#define  DDR_PLL_CSSCG_SLV_RTZ_A_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_SLV_RTZ_A_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_SLV_RTZ_A_RESERVED1_SHIFT))

#define  DDR_PLL_CSSCG_SLV_RTZ_A_RTZ_STEP_SIZE_MASK 0xffff
#define  DDR_PLL_CSSCG_SLV_RTZ_A_RTZ_STEP_SIZE_SHIFT 0
#define  DDR_PLL_CSSCG_SLV_RTZ_A_RTZ_STEP_SIZE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_SLV_RTZ_A_RTZ_STEP_SIZE_MASK) >> DDR_PLL_CSSCG_SLV_RTZ_A_RTZ_STEP_SIZE_SHIFT)
#define  DDR_PLL_CSSCG_SLV_RTZ_A_RTZ_STEP_SIZE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_SLV_RTZ_A_RTZ_STEP_SIZE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_SLV_RTZ_A_RTZ_STEP_SIZE_SHIFT))

//====================================================================
//Register: CSSCG Config B Slave Mode Full Cycle Count Config (SLV_N_FULL_B)
/** \brief This register defines how many full cycles the CSSCG will perform in slave sync mode for configuration B.*/
//====================================================================

#define  DDR_PLL_CSSCG_SLV_N_FULL_B_SLV_N_FULL_MASK 0xffffffff
#define  DDR_PLL_CSSCG_SLV_N_FULL_B_SLV_N_FULL_SHIFT 0
#define  DDR_PLL_CSSCG_SLV_N_FULL_B_SLV_N_FULL_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_SLV_N_FULL_B_SLV_N_FULL_MASK) >> DDR_PLL_CSSCG_SLV_N_FULL_B_SLV_N_FULL_SHIFT)
#define  DDR_PLL_CSSCG_SLV_N_FULL_B_SLV_N_FULL_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_SLV_N_FULL_B_SLV_N_FULL_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_SLV_N_FULL_B_SLV_N_FULL_SHIFT))

//====================================================================
//Register: CSSCG Config B Slave Mode End Configuration Register (SLV_END_CONFIG_B)
/** \brief This register defines the phase and table entry upon which it will halt the "partial phase"
      after all of the full phases for configuration B.*/
//====================================================================

#define  DDR_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED1_MASK 0xfffc0000
#define  DDR_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED1_SHIFT 18
#define  DDR_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED1_MASK) >> DDR_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED1_SHIFT)
#define  DDR_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED1_SHIFT))

#define  DDR_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_PHASE_MASK 0x30000
#define  DDR_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_PHASE_SHIFT 16
#define  DDR_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_PHASE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_PHASE_MASK) >> DDR_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_PHASE_SHIFT)
#define  DDR_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_PHASE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_PHASE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_PHASE_SHIFT))

#define  DDR_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED2_MASK 0xffc0
#define  DDR_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED2_SHIFT 6
#define  DDR_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED2_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED2_MASK) >> DDR_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED2_SHIFT)
#define  DDR_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED2_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED2_SHIFT))

#define  DDR_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_ADDR_MASK 0x3f
#define  DDR_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_ADDR_SHIFT 0
#define  DDR_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_ADDR_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_ADDR_MASK) >> DDR_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_ADDR_SHIFT)
#define  DDR_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_ADDR_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_ADDR_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_ADDR_SHIFT))

//====================================================================
//Register: CSSCG Config B Slave Mode Return-to-Zero Register (SLV_RTZ_B)
/** \brief This register controls how the block will linearly return-to-zero
      after the partial phase for configuration B.*/
//====================================================================

#define  DDR_PLL_CSSCG_SLV_RTZ_B_RESERVED1_MASK 0xffff0000
#define  DDR_PLL_CSSCG_SLV_RTZ_B_RESERVED1_SHIFT 16
#define  DDR_PLL_CSSCG_SLV_RTZ_B_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_SLV_RTZ_B_RESERVED1_MASK) >> DDR_PLL_CSSCG_SLV_RTZ_B_RESERVED1_SHIFT)
#define  DDR_PLL_CSSCG_SLV_RTZ_B_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_SLV_RTZ_B_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_SLV_RTZ_B_RESERVED1_SHIFT))

#define  DDR_PLL_CSSCG_SLV_RTZ_B_RTZ_STEP_SIZE_MASK 0xffff
#define  DDR_PLL_CSSCG_SLV_RTZ_B_RTZ_STEP_SIZE_SHIFT 0
#define  DDR_PLL_CSSCG_SLV_RTZ_B_RTZ_STEP_SIZE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_SLV_RTZ_B_RTZ_STEP_SIZE_MASK) >> DDR_PLL_CSSCG_SLV_RTZ_B_RTZ_STEP_SIZE_SHIFT)
#define  DDR_PLL_CSSCG_SLV_RTZ_B_RTZ_STEP_SIZE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_SLV_RTZ_B_RTZ_STEP_SIZE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_SLV_RTZ_B_RTZ_STEP_SIZE_SHIFT))

//====================================================================
//Register: CSSCG Slave Mode Trigger Select Register (SLV_TRIG_SEL)
/** \brief This register selects and optionally inverts the input trigger.*/
//====================================================================

#define  DDR_PLL_CSSCG_SLV_TRIG_SEL_TRIG_INV_MASK 0xffff0000
#define  DDR_PLL_CSSCG_SLV_TRIG_SEL_TRIG_INV_SHIFT 16
#define  DDR_PLL_CSSCG_SLV_TRIG_SEL_TRIG_INV_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_SLV_TRIG_SEL_TRIG_INV_MASK) >> DDR_PLL_CSSCG_SLV_TRIG_SEL_TRIG_INV_SHIFT)
#define  DDR_PLL_CSSCG_SLV_TRIG_SEL_TRIG_INV_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_SLV_TRIG_SEL_TRIG_INV_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_SLV_TRIG_SEL_TRIG_INV_SHIFT))

#define  DDR_PLL_CSSCG_SLV_TRIG_SEL_TRIG_MASK_MASK 0xffff
#define  DDR_PLL_CSSCG_SLV_TRIG_SEL_TRIG_MASK_SHIFT 0
#define  DDR_PLL_CSSCG_SLV_TRIG_SEL_TRIG_MASK_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_SLV_TRIG_SEL_TRIG_MASK_MASK) >> DDR_PLL_CSSCG_SLV_TRIG_SEL_TRIG_MASK_SHIFT)
#define  DDR_PLL_CSSCG_SLV_TRIG_SEL_TRIG_MASK_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_SLV_TRIG_SEL_TRIG_MASK_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_SLV_TRIG_SEL_TRIG_MASK_SHIFT))

//====================================================================
//Register: CSSCG Slave Mode Timeout Register (SLV_TIMEOUT)
/** \brief This register controls how long the block will wait after a standard line prior to going into initial sync phase again. Note: These clock ticks are defined as the number divided-down VCO_DIV_CLK clocks (where the divide is programmed by rate_div_m1).*/
//====================================================================

#define  DDR_PLL_CSSCG_SLV_TIMEOUT_TIMEOUT_MASK 0xffffffff
#define  DDR_PLL_CSSCG_SLV_TIMEOUT_TIMEOUT_SHIFT 0
#define  DDR_PLL_CSSCG_SLV_TIMEOUT_TIMEOUT_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_SLV_TIMEOUT_TIMEOUT_MASK) >> DDR_PLL_CSSCG_SLV_TIMEOUT_TIMEOUT_SHIFT)
#define  DDR_PLL_CSSCG_SLV_TIMEOUT_TIMEOUT_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_SLV_TIMEOUT_TIMEOUT_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_SLV_TIMEOUT_TIMEOUT_SHIFT))

//====================================================================
//Register: CSSCG Slave Mode Debug 0 Register (SLV_DEBUG_0)
/** \brief This register is used to help debug Slave Sync mode.*/
//====================================================================

#define  DDR_PLL_CSSCG_SLV_DEBUG_0_RESERVED1_MASK 0xfffffffc
#define  DDR_PLL_CSSCG_SLV_DEBUG_0_RESERVED1_SHIFT 2
#define  DDR_PLL_CSSCG_SLV_DEBUG_0_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_SLV_DEBUG_0_RESERVED1_MASK) >> DDR_PLL_CSSCG_SLV_DEBUG_0_RESERVED1_SHIFT)
#define  DDR_PLL_CSSCG_SLV_DEBUG_0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_SLV_DEBUG_0_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_SLV_DEBUG_0_RESERVED1_SHIFT))

#define  DDR_PLL_CSSCG_SLV_DEBUG_0_SLV_SYNC_DEBUG_MODE_MASK 0x3
#define  DDR_PLL_CSSCG_SLV_DEBUG_0_SLV_SYNC_DEBUG_MODE_SHIFT 0
#define  DDR_PLL_CSSCG_SLV_DEBUG_0_SLV_SYNC_DEBUG_MODE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_SLV_DEBUG_0_SLV_SYNC_DEBUG_MODE_MASK) >> DDR_PLL_CSSCG_SLV_DEBUG_0_SLV_SYNC_DEBUG_MODE_SHIFT)
#define  DDR_PLL_CSSCG_SLV_DEBUG_0_SLV_SYNC_DEBUG_MODE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_SLV_DEBUG_0_SLV_SYNC_DEBUG_MODE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_SLV_DEBUG_0_SLV_SYNC_DEBUG_MODE_SHIFT))

//====================================================================
//Register: CSSCG Slave Mode Debug 1 Register (SLV_DEBUG_1)
/** \brief This register is used to help debug Slave Sync mode.*/
//====================================================================

#define  DDR_PLL_CSSCG_SLV_DEBUG_1_RESERVED1_MASK 0xfffffffe
#define  DDR_PLL_CSSCG_SLV_DEBUG_1_RESERVED1_SHIFT 1
#define  DDR_PLL_CSSCG_SLV_DEBUG_1_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_SLV_DEBUG_1_RESERVED1_MASK) >> DDR_PLL_CSSCG_SLV_DEBUG_1_RESERVED1_SHIFT)
#define  DDR_PLL_CSSCG_SLV_DEBUG_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_SLV_DEBUG_1_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_SLV_DEBUG_1_RESERVED1_SHIFT))

#define  DDR_PLL_CSSCG_SLV_DEBUG_1_TRIG_FORCE_MASK 0x1
#define  DDR_PLL_CSSCG_SLV_DEBUG_1_TRIG_FORCE_SHIFT 0
#define  DDR_PLL_CSSCG_SLV_DEBUG_1_TRIG_FORCE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_SLV_DEBUG_1_TRIG_FORCE_MASK) >> DDR_PLL_CSSCG_SLV_DEBUG_1_TRIG_FORCE_SHIFT)
#define  DDR_PLL_CSSCG_SLV_DEBUG_1_TRIG_FORCE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_SLV_DEBUG_1_TRIG_FORCE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_SLV_DEBUG_1_TRIG_FORCE_SHIFT))

//====================================================================
//Register: CSSCG Trigger Debug 0 Register (TRIG_DEBUG_0)
/** \brief This register is used to help debug Slave Sync mode trigger timing. Use this register to clear the other Trigger Debug registers.*/
//====================================================================

#define  DDR_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_RESET_MASK 0x80000000
#define  DDR_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_RESET_SHIFT 31
#define  DDR_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_RESET_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_RESET_MASK) >> DDR_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_RESET_SHIFT)
#define  DDR_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_RESET_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_RESET_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_RESET_SHIFT))

#define  DDR_PLL_CSSCG_TRIG_DEBUG_0_RESERVED1_MASK 0x7ffffffc
#define  DDR_PLL_CSSCG_TRIG_DEBUG_0_RESERVED1_SHIFT 2
#define  DDR_PLL_CSSCG_TRIG_DEBUG_0_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_TRIG_DEBUG_0_RESERVED1_MASK) >> DDR_PLL_CSSCG_TRIG_DEBUG_0_RESERVED1_SHIFT)
#define  DDR_PLL_CSSCG_TRIG_DEBUG_0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_TRIG_DEBUG_0_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_TRIG_DEBUG_0_RESERVED1_SHIFT))

#define  DDR_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_FREERUN_MASK 0x2
#define  DDR_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_FREERUN_SHIFT 1
#define  DDR_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_FREERUN_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_FREERUN_MASK) >> DDR_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_FREERUN_SHIFT)
#define  DDR_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_FREERUN_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_FREERUN_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_FREERUN_SHIFT))

#define  DDR_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_ENABLE_MASK 0x1
#define  DDR_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_ENABLE_SHIFT 0
#define  DDR_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_ENABLE_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_ENABLE_MASK) >> DDR_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_ENABLE_SHIFT)
#define  DDR_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_ENABLE_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_ENABLE_SHIFT))

//====================================================================
//Register: CSSCG Trigger Debug 1 Register (TRIG_DEBUG_1)
/** \brief This register is used to help debug Slave Sync mode trigger timing. Specifically, this register provides the minimum time seen between triggers (in VCO_DIV_CLK clocks).*/
//====================================================================

#define  DDR_PLL_CSSCG_TRIG_DEBUG_1_TRIG_MIN_PERIOD_MASK 0xffffffff
#define  DDR_PLL_CSSCG_TRIG_DEBUG_1_TRIG_MIN_PERIOD_SHIFT 0
#define  DDR_PLL_CSSCG_TRIG_DEBUG_1_TRIG_MIN_PERIOD_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_TRIG_DEBUG_1_TRIG_MIN_PERIOD_MASK) >> DDR_PLL_CSSCG_TRIG_DEBUG_1_TRIG_MIN_PERIOD_SHIFT)
#define  DDR_PLL_CSSCG_TRIG_DEBUG_1_TRIG_MIN_PERIOD_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_TRIG_DEBUG_1_TRIG_MIN_PERIOD_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_TRIG_DEBUG_1_TRIG_MIN_PERIOD_SHIFT))

//====================================================================
//Register: CSSCG Trigger Debug 2 Register (TRIG_DEBUG_2)
/** \brief This register is used to help debug Slave Sync mode trigger timing. Specifically, this register provides the maximum time seen between triggers (in VCO_DIV_CLK clocks).*/
//====================================================================

#define  DDR_PLL_CSSCG_TRIG_DEBUG_2_TRIG_MAX_PERIOD_MASK 0xffffffff
#define  DDR_PLL_CSSCG_TRIG_DEBUG_2_TRIG_MAX_PERIOD_SHIFT 0
#define  DDR_PLL_CSSCG_TRIG_DEBUG_2_TRIG_MAX_PERIOD_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_TRIG_DEBUG_2_TRIG_MAX_PERIOD_MASK) >> DDR_PLL_CSSCG_TRIG_DEBUG_2_TRIG_MAX_PERIOD_SHIFT)
#define  DDR_PLL_CSSCG_TRIG_DEBUG_2_TRIG_MAX_PERIOD_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_TRIG_DEBUG_2_TRIG_MAX_PERIOD_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_TRIG_DEBUG_2_TRIG_MAX_PERIOD_SHIFT))

//====================================================================
//Register: CSSCG Trigger Debug 3 Register (TRIG_DEBUG_3)
/** \brief This register is used to help debug Slave Sync mode trigger timing. Specifically, this register provides the number of triggers seen (including the first used to synchronize).*/
//====================================================================

#define  DDR_PLL_CSSCG_TRIG_DEBUG_3_TRIG_COUNT_MASK 0xffffffff
#define  DDR_PLL_CSSCG_TRIG_DEBUG_3_TRIG_COUNT_SHIFT 0
#define  DDR_PLL_CSSCG_TRIG_DEBUG_3_TRIG_COUNT_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_TRIG_DEBUG_3_TRIG_COUNT_MASK) >> DDR_PLL_CSSCG_TRIG_DEBUG_3_TRIG_COUNT_SHIFT)
#define  DDR_PLL_CSSCG_TRIG_DEBUG_3_TRIG_COUNT_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_TRIG_DEBUG_3_TRIG_COUNT_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_TRIG_DEBUG_3_TRIG_COUNT_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  DDR_PLL_CSSCG_REV0_MAJ_MASK 0xffff0000
#define  DDR_PLL_CSSCG_REV0_MAJ_SHIFT 16
#define  DDR_PLL_CSSCG_REV0_MAJ_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_REV0_MAJ_MASK) >> DDR_PLL_CSSCG_REV0_MAJ_SHIFT)
#define  DDR_PLL_CSSCG_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_REV0_MAJ_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_REV0_MAJ_SHIFT))

#define  DDR_PLL_CSSCG_REV0_MID_MASK 0xffff
#define  DDR_PLL_CSSCG_REV0_MID_SHIFT 0
#define  DDR_PLL_CSSCG_REV0_MID_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_REV0_MID_MASK) >> DDR_PLL_CSSCG_REV0_MID_SHIFT)
#define  DDR_PLL_CSSCG_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_REV0_MID_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  DDR_PLL_CSSCG_REV1_RESERVED1_MASK 0xffff0000
#define  DDR_PLL_CSSCG_REV1_RESERVED1_SHIFT 16
#define  DDR_PLL_CSSCG_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_REV1_RESERVED1_MASK) >> DDR_PLL_CSSCG_REV1_RESERVED1_SHIFT)
#define  DDR_PLL_CSSCG_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_REV1_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_REV1_RESERVED1_SHIFT))

#define  DDR_PLL_CSSCG_REV1_CFG_MASK 0xffff
#define  DDR_PLL_CSSCG_REV1_CFG_SHIFT 0
#define  DDR_PLL_CSSCG_REV1_CFG_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_REV1_CFG_MASK) >> DDR_PLL_CSSCG_REV1_CFG_SHIFT)
#define  DDR_PLL_CSSCG_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_REV1_CFG_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_REV1_CFG_SHIFT))

//====================================================================
//Register: CSSCG RAM Access Register (CSSCG_RAM)
/** \brief The table used to define the dither shape. The values are unsigned "deltas." Therefore, the curve must be monotonic.*/
//====================================================================

#define  DDR_PLL_CSSCG_CSSCG_RAM_RESERVED1_MASK 0xffff0000
#define  DDR_PLL_CSSCG_CSSCG_RAM_RESERVED1_SHIFT 16
#define  DDR_PLL_CSSCG_CSSCG_RAM_RESERVED1_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_CSSCG_RAM_RESERVED1_MASK) >> DDR_PLL_CSSCG_CSSCG_RAM_RESERVED1_SHIFT)
#define  DDR_PLL_CSSCG_CSSCG_RAM_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_CSSCG_RAM_RESERVED1_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_CSSCG_RAM_RESERVED1_SHIFT))

#define  DDR_PLL_CSSCG_CSSCG_RAM_VAL_MASK 0xffff
#define  DDR_PLL_CSSCG_CSSCG_RAM_VAL_SHIFT 0
#define  DDR_PLL_CSSCG_CSSCG_RAM_VAL_MASK_SHIFT(reg) (((reg) & DDR_PLL_CSSCG_CSSCG_RAM_VAL_MASK) >> DDR_PLL_CSSCG_CSSCG_RAM_VAL_SHIFT)
#define  DDR_PLL_CSSCG_CSSCG_RAM_VAL_REPLACE_VAL(reg,val) (((reg) & ~DDR_PLL_CSSCG_CSSCG_RAM_VAL_MASK) | (((uint32_t)val) << DDR_PLL_CSSCG_CSSCG_RAM_VAL_SHIFT))

//====================================================================
//
//Register File: SYS PLL Controls (SYS_PLL)
//
//====================================================================

//====================================================================
//Register: PLL reset & Pre-divider Register (rst_prediv)
/** \brief RESET, 1 = PLL in reset
           0 = PLL in normal mode
    RESET_SSC, 1 = SSC and Freq Offset in reset
               0 = SSC and Freq Offset operating mode
    RESET_PI, 1 = External Interpolator in reset
               0 = operating mode*/
//====================================================================

#define  SYS_PLL_RST_PREDIV_RESERVED1_MASK 0xfff80000
#define  SYS_PLL_RST_PREDIV_RESERVED1_SHIFT 19
#define  SYS_PLL_RST_PREDIV_RESERVED1_MASK_SHIFT(reg) (((reg) & SYS_PLL_RST_PREDIV_RESERVED1_MASK) >> SYS_PLL_RST_PREDIV_RESERVED1_SHIFT)
#define  SYS_PLL_RST_PREDIV_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_RST_PREDIV_RESERVED1_MASK) | (((uint32_t)val) << SYS_PLL_RST_PREDIV_RESERVED1_SHIFT))

#define  SYS_PLL_RST_PREDIV_RESET_PI_MASK 0x40000
#define  SYS_PLL_RST_PREDIV_RESET_PI_SHIFT 18
#define  SYS_PLL_RST_PREDIV_RESET_PI_MASK_SHIFT(reg) (((reg) & SYS_PLL_RST_PREDIV_RESET_PI_MASK) >> SYS_PLL_RST_PREDIV_RESET_PI_SHIFT)
#define  SYS_PLL_RST_PREDIV_RESET_PI_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_RST_PREDIV_RESET_PI_MASK) | (((uint32_t)val) << SYS_PLL_RST_PREDIV_RESET_PI_SHIFT))

#define  SYS_PLL_RST_PREDIV_RESET_SSC_MASK 0x20000
#define  SYS_PLL_RST_PREDIV_RESET_SSC_SHIFT 17
#define  SYS_PLL_RST_PREDIV_RESET_SSC_MASK_SHIFT(reg) (((reg) & SYS_PLL_RST_PREDIV_RESET_SSC_MASK) >> SYS_PLL_RST_PREDIV_RESET_SSC_SHIFT)
#define  SYS_PLL_RST_PREDIV_RESET_SSC_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_RST_PREDIV_RESET_SSC_MASK) | (((uint32_t)val) << SYS_PLL_RST_PREDIV_RESET_SSC_SHIFT))

#define  SYS_PLL_RST_PREDIV_RESET_MASK 0x10000
#define  SYS_PLL_RST_PREDIV_RESET_SHIFT 16
#define  SYS_PLL_RST_PREDIV_RESET_MASK_SHIFT(reg) (((reg) & SYS_PLL_RST_PREDIV_RESET_MASK) >> SYS_PLL_RST_PREDIV_RESET_SHIFT)
#define  SYS_PLL_RST_PREDIV_RESET_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_RST_PREDIV_RESET_MASK) | (((uint32_t)val) << SYS_PLL_RST_PREDIV_RESET_SHIFT))

#define  SYS_PLL_RST_PREDIV_RESERVED2_MASK 0xfe00
#define  SYS_PLL_RST_PREDIV_RESERVED2_SHIFT 9
#define  SYS_PLL_RST_PREDIV_RESERVED2_MASK_SHIFT(reg) (((reg) & SYS_PLL_RST_PREDIV_RESERVED2_MASK) >> SYS_PLL_RST_PREDIV_RESERVED2_SHIFT)
#define  SYS_PLL_RST_PREDIV_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_RST_PREDIV_RESERVED2_MASK) | (((uint32_t)val) << SYS_PLL_RST_PREDIV_RESERVED2_SHIFT))

#define  SYS_PLL_RST_PREDIV_REFDIV_MASK 0x1ff
#define  SYS_PLL_RST_PREDIV_REFDIV_SHIFT 0
#define  SYS_PLL_RST_PREDIV_REFDIV_MASK_SHIFT(reg) (((reg) & SYS_PLL_RST_PREDIV_REFDIV_MASK) >> SYS_PLL_RST_PREDIV_REFDIV_SHIFT)
#define  SYS_PLL_RST_PREDIV_REFDIV_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_RST_PREDIV_REFDIV_MASK) | (((uint32_t)val) << SYS_PLL_RST_PREDIV_REFDIV_SHIFT))

//====================================================================
//Register: PLL feedback multiplier (mult_postdiv)
/** \brief PLL multiplication factor after pre-divide.*/
//====================================================================

#define  SYS_PLL_MULT_POSTDIV_RESERVED1_MASK 0xfe000000
#define  SYS_PLL_MULT_POSTDIV_RESERVED1_SHIFT 25
#define  SYS_PLL_MULT_POSTDIV_RESERVED1_MASK_SHIFT(reg) (((reg) & SYS_PLL_MULT_POSTDIV_RESERVED1_MASK) >> SYS_PLL_MULT_POSTDIV_RESERVED1_SHIFT)
#define  SYS_PLL_MULT_POSTDIV_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_MULT_POSTDIV_RESERVED1_MASK) | (((uint32_t)val) << SYS_PLL_MULT_POSTDIV_RESERVED1_SHIFT))

#define  SYS_PLL_MULT_POSTDIV_FBDIV_MASK 0x1ff0000
#define  SYS_PLL_MULT_POSTDIV_FBDIV_SHIFT 16
#define  SYS_PLL_MULT_POSTDIV_FBDIV_MASK_SHIFT(reg) (((reg) & SYS_PLL_MULT_POSTDIV_FBDIV_MASK) >> SYS_PLL_MULT_POSTDIV_FBDIV_SHIFT)
#define  SYS_PLL_MULT_POSTDIV_FBDIV_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_MULT_POSTDIV_FBDIV_MASK) | (((uint32_t)val) << SYS_PLL_MULT_POSTDIV_FBDIV_SHIFT))

#define  SYS_PLL_MULT_POSTDIV_RESERVED2_MASK 0xf800
#define  SYS_PLL_MULT_POSTDIV_RESERVED2_SHIFT 11
#define  SYS_PLL_MULT_POSTDIV_RESERVED2_MASK_SHIFT(reg) (((reg) & SYS_PLL_MULT_POSTDIV_RESERVED2_MASK) >> SYS_PLL_MULT_POSTDIV_RESERVED2_SHIFT)
#define  SYS_PLL_MULT_POSTDIV_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_MULT_POSTDIV_RESERVED2_MASK) | (((uint32_t)val) << SYS_PLL_MULT_POSTDIV_RESERVED2_SHIFT))

#define  SYS_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK 0x700
#define  SYS_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_SHIFT 8
#define  SYS_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK_SHIFT(reg) (((reg) & SYS_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK) >> SYS_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_SHIFT)
#define  SYS_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK) | (((uint32_t)val) << SYS_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_SHIFT))

#define  SYS_PLL_MULT_POSTDIV_RESERVED3_MASK 0xf8
#define  SYS_PLL_MULT_POSTDIV_RESERVED3_SHIFT 3
#define  SYS_PLL_MULT_POSTDIV_RESERVED3_MASK_SHIFT(reg) (((reg) & SYS_PLL_MULT_POSTDIV_RESERVED3_MASK) >> SYS_PLL_MULT_POSTDIV_RESERVED3_SHIFT)
#define  SYS_PLL_MULT_POSTDIV_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_MULT_POSTDIV_RESERVED3_MASK) | (((uint32_t)val) << SYS_PLL_MULT_POSTDIV_RESERVED3_SHIFT))

#define  SYS_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK 0x7
#define  SYS_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_SHIFT 0
#define  SYS_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK_SHIFT(reg) (((reg) & SYS_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK) >> SYS_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_SHIFT)
#define  SYS_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK) | (((uint32_t)val) << SYS_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_SHIFT))

//====================================================================
//Register: PLL gain control (kvco)
/** \brief PLL gain control.*/
//====================================================================

#define  SYS_PLL_KVCO_RESERVED1_MASK 0xfffffff0
#define  SYS_PLL_KVCO_RESERVED1_SHIFT 4
#define  SYS_PLL_KVCO_RESERVED1_MASK_SHIFT(reg) (((reg) & SYS_PLL_KVCO_RESERVED1_MASK) >> SYS_PLL_KVCO_RESERVED1_SHIFT)
#define  SYS_PLL_KVCO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_KVCO_RESERVED1_MASK) | (((uint32_t)val) << SYS_PLL_KVCO_RESERVED1_SHIFT))

#define  SYS_PLL_KVCO_KVCO_MASK 0xf
#define  SYS_PLL_KVCO_KVCO_SHIFT 0
#define  SYS_PLL_KVCO_KVCO_MASK_SHIFT(reg) (((reg) & SYS_PLL_KVCO_KVCO_MASK) >> SYS_PLL_KVCO_KVCO_SHIFT)
#define  SYS_PLL_KVCO_KVCO_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_KVCO_KVCO_MASK) | (((uint32_t)val) << SYS_PLL_KVCO_KVCO_SHIFT))

//====================================================================
//Register: PLL misc control (misc)
/** \brief PLL misc control.*/
//====================================================================

#define  SYS_PLL_MISC_RESERVED1_MASK 0xffff0000
#define  SYS_PLL_MISC_RESERVED1_SHIFT 16
#define  SYS_PLL_MISC_RESERVED1_MASK_SHIFT(reg) (((reg) & SYS_PLL_MISC_RESERVED1_MASK) >> SYS_PLL_MISC_RESERVED1_SHIFT)
#define  SYS_PLL_MISC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_MISC_RESERVED1_MASK) | (((uint32_t)val) << SYS_PLL_MISC_RESERVED1_SHIFT))

#define  SYS_PLL_MISC_PLL_BW_SEL_MASK 0x8000
#define  SYS_PLL_MISC_PLL_BW_SEL_SHIFT 15
#define  SYS_PLL_MISC_PLL_BW_SEL_MASK_SHIFT(reg) (((reg) & SYS_PLL_MISC_PLL_BW_SEL_MASK) >> SYS_PLL_MISC_PLL_BW_SEL_SHIFT)
#define  SYS_PLL_MISC_PLL_BW_SEL_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_MISC_PLL_BW_SEL_MASK) | (((uint32_t)val) << SYS_PLL_MISC_PLL_BW_SEL_SHIFT))

#define  SYS_PLL_MISC_CTUNE_MASK 0x6000
#define  SYS_PLL_MISC_CTUNE_SHIFT 13
#define  SYS_PLL_MISC_CTUNE_MASK_SHIFT(reg) (((reg) & SYS_PLL_MISC_CTUNE_MASK) >> SYS_PLL_MISC_CTUNE_SHIFT)
#define  SYS_PLL_MISC_CTUNE_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_MISC_CTUNE_MASK) | (((uint32_t)val) << SYS_PLL_MISC_CTUNE_SHIFT))

#define  SYS_PLL_MISC_INTPI_MASK 0x1e00
#define  SYS_PLL_MISC_INTPI_SHIFT 9
#define  SYS_PLL_MISC_INTPI_MASK_SHIFT(reg) (((reg) & SYS_PLL_MISC_INTPI_MASK) >> SYS_PLL_MISC_INTPI_SHIFT)
#define  SYS_PLL_MISC_INTPI_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_MISC_INTPI_MASK) | (((uint32_t)val) << SYS_PLL_MISC_INTPI_SHIFT))

#define  SYS_PLL_MISC_ICP_MASK 0x1e0
#define  SYS_PLL_MISC_ICP_SHIFT 5
#define  SYS_PLL_MISC_ICP_MASK_SHIFT(reg) (((reg) & SYS_PLL_MISC_ICP_MASK) >> SYS_PLL_MISC_ICP_SHIFT)
#define  SYS_PLL_MISC_ICP_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_MISC_ICP_MASK) | (((uint32_t)val) << SYS_PLL_MISC_ICP_SHIFT))

#define  SYS_PLL_MISC_VDDM_MASK 0x18
#define  SYS_PLL_MISC_VDDM_SHIFT 3
#define  SYS_PLL_MISC_VDDM_MASK_SHIFT(reg) (((reg) & SYS_PLL_MISC_VDDM_MASK) >> SYS_PLL_MISC_VDDM_SHIFT)
#define  SYS_PLL_MISC_VDDM_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_MISC_VDDM_MASK) | (((uint32_t)val) << SYS_PLL_MISC_VDDM_SHIFT))

#define  SYS_PLL_MISC_VDDL_MASK 0x7
#define  SYS_PLL_MISC_VDDL_SHIFT 0
#define  SYS_PLL_MISC_VDDL_MASK_SHIFT(reg) (((reg) & SYS_PLL_MISC_VDDL_MASK) >> SYS_PLL_MISC_VDDL_SHIFT)
#define  SYS_PLL_MISC_VDDL_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_MISC_VDDL_MASK) | (((uint32_t)val) << SYS_PLL_MISC_VDDL_SHIFT))

//====================================================================
//Register: PLL PFD (Phase Frequency Detector) input select, and de-skew application control (feedback_mode_deskew)
/** \brief PLL feedback mode control.*/
//====================================================================

#define  SYS_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_MASK 0xff800000
#define  SYS_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_SHIFT 23
#define  SYS_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_MASK_SHIFT(reg) (((reg) & SYS_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_MASK) >> SYS_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_SHIFT)
#define  SYS_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_MASK) | (((uint32_t)val) << SYS_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_SHIFT))

#define  SYS_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_MASK 0x7e0000
#define  SYS_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_SHIFT 17
#define  SYS_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_MASK_SHIFT(reg) (((reg) & SYS_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_MASK) >> SYS_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_SHIFT)
#define  SYS_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_MASK) | (((uint32_t)val) << SYS_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_SHIFT))

#define  SYS_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK 0x10000
#define  SYS_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_SHIFT 16
#define  SYS_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK_SHIFT(reg) (((reg) & SYS_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK) >> SYS_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_SHIFT)
#define  SYS_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK) | (((uint32_t)val) << SYS_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_SHIFT))

#define  SYS_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_MASK 0xffff
#define  SYS_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_SHIFT 0
#define  SYS_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_MASK_SHIFT(reg) (((reg) & SYS_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_MASK) >> SYS_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_SHIFT)
#define  SYS_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_MASK) | (((uint32_t)val) << SYS_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_SHIFT))

//====================================================================
//Register: PLL offset frequency control (offset_mode)
/** \brief PLL offset frequency control.*/
//====================================================================

#define  SYS_PLL_OFFSET_MODE_RESERVED1_MASK 0xf8000000
#define  SYS_PLL_OFFSET_MODE_RESERVED1_SHIFT 27
#define  SYS_PLL_OFFSET_MODE_RESERVED1_MASK_SHIFT(reg) (((reg) & SYS_PLL_OFFSET_MODE_RESERVED1_MASK) >> SYS_PLL_OFFSET_MODE_RESERVED1_SHIFT)
#define  SYS_PLL_OFFSET_MODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_OFFSET_MODE_RESERVED1_MASK) | (((uint32_t)val) << SYS_PLL_OFFSET_MODE_RESERVED1_SHIFT))

#define  SYS_PLL_OFFSET_MODE_INTPR_MASK 0x7000000
#define  SYS_PLL_OFFSET_MODE_INTPR_SHIFT 24
#define  SYS_PLL_OFFSET_MODE_INTPR_MASK_SHIFT(reg) (((reg) & SYS_PLL_OFFSET_MODE_INTPR_MASK) >> SYS_PLL_OFFSET_MODE_INTPR_SHIFT)
#define  SYS_PLL_OFFSET_MODE_INTPR_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_OFFSET_MODE_INTPR_MASK) | (((uint32_t)val) << SYS_PLL_OFFSET_MODE_INTPR_SHIFT))

#define  SYS_PLL_OFFSET_MODE_FD_MASK 0xe00000
#define  SYS_PLL_OFFSET_MODE_FD_SHIFT 21
#define  SYS_PLL_OFFSET_MODE_FD_MASK_SHIFT(reg) (((reg) & SYS_PLL_OFFSET_MODE_FD_MASK) >> SYS_PLL_OFFSET_MODE_FD_SHIFT)
#define  SYS_PLL_OFFSET_MODE_FD_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_OFFSET_MODE_FD_MASK) | (((uint32_t)val) << SYS_PLL_OFFSET_MODE_FD_SHIFT))

#define  SYS_PLL_OFFSET_MODE_PI_LOOP_MODE_MASK 0x100000
#define  SYS_PLL_OFFSET_MODE_PI_LOOP_MODE_SHIFT 20
#define  SYS_PLL_OFFSET_MODE_PI_LOOP_MODE_MASK_SHIFT(reg) (((reg) & SYS_PLL_OFFSET_MODE_PI_LOOP_MODE_MASK) >> SYS_PLL_OFFSET_MODE_PI_LOOP_MODE_SHIFT)
#define  SYS_PLL_OFFSET_MODE_PI_LOOP_MODE_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_OFFSET_MODE_PI_LOOP_MODE_MASK) | (((uint32_t)val) << SYS_PLL_OFFSET_MODE_PI_LOOP_MODE_SHIFT))

#define  SYS_PLL_OFFSET_MODE_FREQ_OFFSET_MASK 0xffff8
#define  SYS_PLL_OFFSET_MODE_FREQ_OFFSET_SHIFT 3
#define  SYS_PLL_OFFSET_MODE_FREQ_OFFSET_MASK_SHIFT(reg) (((reg) & SYS_PLL_OFFSET_MODE_FREQ_OFFSET_MASK) >> SYS_PLL_OFFSET_MODE_FREQ_OFFSET_SHIFT)
#define  SYS_PLL_OFFSET_MODE_FREQ_OFFSET_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_OFFSET_MODE_FREQ_OFFSET_MASK) | (((uint32_t)val) << SYS_PLL_OFFSET_MODE_FREQ_OFFSET_SHIFT))

#define  SYS_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK 0x4
#define  SYS_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_SHIFT 2
#define  SYS_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK_SHIFT(reg) (((reg) & SYS_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK) >> SYS_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_SHIFT)
#define  SYS_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK) | (((uint32_t)val) << SYS_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_SHIFT))

#define  SYS_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_MASK 0x2
#define  SYS_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_SHIFT 1
#define  SYS_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_MASK_SHIFT(reg) (((reg) & SYS_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_MASK) >> SYS_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_SHIFT)
#define  SYS_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_MASK) | (((uint32_t)val) << SYS_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_SHIFT))

#define  SYS_PLL_OFFSET_MODE_FREQ_OFFSET_EN_MASK 0x1
#define  SYS_PLL_OFFSET_MODE_FREQ_OFFSET_EN_SHIFT 0
#define  SYS_PLL_OFFSET_MODE_FREQ_OFFSET_EN_MASK_SHIFT(reg) (((reg) & SYS_PLL_OFFSET_MODE_FREQ_OFFSET_EN_MASK) >> SYS_PLL_OFFSET_MODE_FREQ_OFFSET_EN_SHIFT)
#define  SYS_PLL_OFFSET_MODE_FREQ_OFFSET_EN_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_OFFSET_MODE_FREQ_OFFSET_EN_MASK) | (((uint32_t)val) << SYS_PLL_OFFSET_MODE_FREQ_OFFSET_EN_SHIFT))

//====================================================================
//Register: PLL enable (fixed_mode_ssc_mode)
/** \brief PLL enable*/
//====================================================================

#define  SYS_PLL_FIXED_MODE_SSC_MODE_RESERVED1_MASK 0xfff00000
#define  SYS_PLL_FIXED_MODE_SSC_MODE_RESERVED1_SHIFT 20
#define  SYS_PLL_FIXED_MODE_SSC_MODE_RESERVED1_MASK_SHIFT(reg) (((reg) & SYS_PLL_FIXED_MODE_SSC_MODE_RESERVED1_MASK) >> SYS_PLL_FIXED_MODE_SSC_MODE_RESERVED1_SHIFT)
#define  SYS_PLL_FIXED_MODE_SSC_MODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_FIXED_MODE_SSC_MODE_RESERVED1_MASK) | (((uint32_t)val) << SYS_PLL_FIXED_MODE_SSC_MODE_RESERVED1_SHIFT))

#define  SYS_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK 0x80000
#define  SYS_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_SHIFT 19
#define  SYS_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK_SHIFT(reg) (((reg) & SYS_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK) >> SYS_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_SHIFT)
#define  SYS_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK) | (((uint32_t)val) << SYS_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_SHIFT))

#define  SYS_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK 0x40000
#define  SYS_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_SHIFT 18
#define  SYS_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK_SHIFT(reg) (((reg) & SYS_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK) >> SYS_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_SHIFT)
#define  SYS_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK) | (((uint32_t)val) << SYS_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_SHIFT))

#define  SYS_PLL_FIXED_MODE_SSC_MODE_PU_MASK 0x20000
#define  SYS_PLL_FIXED_MODE_SSC_MODE_PU_SHIFT 17
#define  SYS_PLL_FIXED_MODE_SSC_MODE_PU_MASK_SHIFT(reg) (((reg) & SYS_PLL_FIXED_MODE_SSC_MODE_PU_MASK) >> SYS_PLL_FIXED_MODE_SSC_MODE_PU_SHIFT)
#define  SYS_PLL_FIXED_MODE_SSC_MODE_PU_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_FIXED_MODE_SSC_MODE_PU_MASK) | (((uint32_t)val) << SYS_PLL_FIXED_MODE_SSC_MODE_PU_SHIFT))

#define  SYS_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK 0x10000
#define  SYS_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_SHIFT 16
#define  SYS_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK_SHIFT(reg) (((reg) & SYS_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK) >> SYS_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_SHIFT)
#define  SYS_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK) | (((uint32_t)val) << SYS_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_SHIFT))

#define  SYS_PLL_FIXED_MODE_SSC_MODE_RESERVED2_MASK 0xfff0
#define  SYS_PLL_FIXED_MODE_SSC_MODE_RESERVED2_SHIFT 4
#define  SYS_PLL_FIXED_MODE_SSC_MODE_RESERVED2_MASK_SHIFT(reg) (((reg) & SYS_PLL_FIXED_MODE_SSC_MODE_RESERVED2_MASK) >> SYS_PLL_FIXED_MODE_SSC_MODE_RESERVED2_SHIFT)
#define  SYS_PLL_FIXED_MODE_SSC_MODE_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_FIXED_MODE_SSC_MODE_RESERVED2_MASK) | (((uint32_t)val) << SYS_PLL_FIXED_MODE_SSC_MODE_RESERVED2_SHIFT))

#define  SYS_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_MASK 0x8
#define  SYS_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_SHIFT 3
#define  SYS_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_MASK_SHIFT(reg) (((reg) & SYS_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_MASK) >> SYS_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_SHIFT)
#define  SYS_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_MASK) | (((uint32_t)val) << SYS_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_SHIFT))

#define  SYS_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK 0x4
#define  SYS_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_SHIFT 2
#define  SYS_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK_SHIFT(reg) (((reg) & SYS_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK) >> SYS_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_SHIFT)
#define  SYS_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK) | (((uint32_t)val) << SYS_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_SHIFT))

#define  SYS_PLL_FIXED_MODE_SSC_MODE_PI_EN_MASK 0x2
#define  SYS_PLL_FIXED_MODE_SSC_MODE_PI_EN_SHIFT 1
#define  SYS_PLL_FIXED_MODE_SSC_MODE_PI_EN_MASK_SHIFT(reg) (((reg) & SYS_PLL_FIXED_MODE_SSC_MODE_PI_EN_MASK) >> SYS_PLL_FIXED_MODE_SSC_MODE_PI_EN_SHIFT)
#define  SYS_PLL_FIXED_MODE_SSC_MODE_PI_EN_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_FIXED_MODE_SSC_MODE_PI_EN_MASK) | (((uint32_t)val) << SYS_PLL_FIXED_MODE_SSC_MODE_PI_EN_SHIFT))

#define  SYS_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK 0x1
#define  SYS_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_SHIFT 0
#define  SYS_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK_SHIFT(reg) (((reg) & SYS_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK) >> SYS_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_SHIFT)
#define  SYS_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK) | (((uint32_t)val) << SYS_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_SHIFT))

//====================================================================
//Register: PLL Modulation Frequency (ssc_freq_ssc_range)
/** \brief PLL Modulation Frequency Control*/
//====================================================================

#define  SYS_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK 0xffff0000
#define  SYS_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_SHIFT 16
#define  SYS_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK_SHIFT(reg) (((reg) & SYS_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK) >> SYS_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_SHIFT)
#define  SYS_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK) | (((uint32_t)val) << SYS_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_SHIFT))

#define  SYS_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_MASK 0xf800
#define  SYS_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_SHIFT 11
#define  SYS_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_MASK_SHIFT(reg) (((reg) & SYS_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_MASK) >> SYS_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_SHIFT)
#define  SYS_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_MASK) | (((uint32_t)val) << SYS_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_SHIFT))

#define  SYS_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK 0x7ff
#define  SYS_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_SHIFT 0
#define  SYS_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK_SHIFT(reg) (((reg) & SYS_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK) >> SYS_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_SHIFT)
#define  SYS_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK) | (((uint32_t)val) << SYS_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_SHIFT))

//====================================================================
//Register: PLL Output Clock Control (clk_ctrl_marvell_test)
/** \brief PLL Output Clock Control*/
//====================================================================

#define  SYS_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK 0xfffc0000
#define  SYS_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_SHIFT 18
#define  SYS_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK_SHIFT(reg) (((reg) & SYS_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK) >> SYS_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_SHIFT)
#define  SYS_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK) | (((uint32_t)val) << SYS_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_SHIFT))

#define  SYS_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK 0x20000
#define  SYS_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_SHIFT 17
#define  SYS_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK_SHIFT(reg) (((reg) & SYS_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK) >> SYS_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_SHIFT)
#define  SYS_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK) | (((uint32_t)val) << SYS_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_SHIFT))

#define  SYS_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK 0x10000
#define  SYS_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_SHIFT 16
#define  SYS_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK_SHIFT(reg) (((reg) & SYS_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK) >> SYS_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_SHIFT)
#define  SYS_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK) | (((uint32_t)val) << SYS_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_SHIFT))

#define  SYS_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK 0xf000
#define  SYS_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_SHIFT 12
#define  SYS_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK_SHIFT(reg) (((reg) & SYS_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK) >> SYS_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_SHIFT)
#define  SYS_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK) | (((uint32_t)val) << SYS_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_SHIFT))

#define  SYS_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK 0xff0
#define  SYS_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_SHIFT 4
#define  SYS_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK_SHIFT(reg) (((reg) & SYS_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK) >> SYS_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_SHIFT)
#define  SYS_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK) | (((uint32_t)val) << SYS_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_SHIFT))

#define  SYS_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK 0xf
#define  SYS_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_SHIFT 0
#define  SYS_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK_SHIFT(reg) (((reg) & SYS_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK) >> SYS_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_SHIFT)
#define  SYS_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK) | (((uint32_t)val) << SYS_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_SHIFT))

//====================================================================
//Register: PLL Lock Status (lock_status)
/** \brief PLL Lock Output*/
//====================================================================

#define  SYS_PLL_LOCK_STATUS_RESERVED1_MASK 0xfffffffe
#define  SYS_PLL_LOCK_STATUS_RESERVED1_SHIFT 1
#define  SYS_PLL_LOCK_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & SYS_PLL_LOCK_STATUS_RESERVED1_MASK) >> SYS_PLL_LOCK_STATUS_RESERVED1_SHIFT)
#define  SYS_PLL_LOCK_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_LOCK_STATUS_RESERVED1_MASK) | (((uint32_t)val) << SYS_PLL_LOCK_STATUS_RESERVED1_SHIFT))

#define  SYS_PLL_LOCK_STATUS_PLL_LOCK_MASK 0x1
#define  SYS_PLL_LOCK_STATUS_PLL_LOCK_SHIFT 0
#define  SYS_PLL_LOCK_STATUS_PLL_LOCK_MASK_SHIFT(reg) (((reg) & SYS_PLL_LOCK_STATUS_PLL_LOCK_MASK) >> SYS_PLL_LOCK_STATUS_PLL_LOCK_SHIFT)
#define  SYS_PLL_LOCK_STATUS_PLL_LOCK_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_LOCK_STATUS_PLL_LOCK_MASK) | (((uint32_t)val) << SYS_PLL_LOCK_STATUS_PLL_LOCK_SHIFT))

//====================================================================
//Register: PLL RESERVE_OUT output (reserve_out)
//====================================================================

#define  SYS_PLL_RESERVE_OUT_RESERVED1_MASK 0xfffe0000
#define  SYS_PLL_RESERVE_OUT_RESERVED1_SHIFT 17
#define  SYS_PLL_RESERVE_OUT_RESERVED1_MASK_SHIFT(reg) (((reg) & SYS_PLL_RESERVE_OUT_RESERVED1_MASK) >> SYS_PLL_RESERVE_OUT_RESERVED1_SHIFT)
#define  SYS_PLL_RESERVE_OUT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_RESERVE_OUT_RESERVED1_MASK) | (((uint32_t)val) << SYS_PLL_RESERVE_OUT_RESERVED1_SHIFT))

#define  SYS_PLL_RESERVE_OUT_PU18_REG_MASK 0x10000
#define  SYS_PLL_RESERVE_OUT_PU18_REG_SHIFT 16
#define  SYS_PLL_RESERVE_OUT_PU18_REG_MASK_SHIFT(reg) (((reg) & SYS_PLL_RESERVE_OUT_PU18_REG_MASK) >> SYS_PLL_RESERVE_OUT_PU18_REG_SHIFT)
#define  SYS_PLL_RESERVE_OUT_PU18_REG_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_RESERVE_OUT_PU18_REG_MASK) | (((uint32_t)val) << SYS_PLL_RESERVE_OUT_PU18_REG_SHIFT))

#define  SYS_PLL_RESERVE_OUT_RESERVED2_MASK 0xff00
#define  SYS_PLL_RESERVE_OUT_RESERVED2_SHIFT 8
#define  SYS_PLL_RESERVE_OUT_RESERVED2_MASK_SHIFT(reg) (((reg) & SYS_PLL_RESERVE_OUT_RESERVED2_MASK) >> SYS_PLL_RESERVE_OUT_RESERVED2_SHIFT)
#define  SYS_PLL_RESERVE_OUT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_RESERVE_OUT_RESERVED2_MASK) | (((uint32_t)val) << SYS_PLL_RESERVE_OUT_RESERVED2_SHIFT))

#define  SYS_PLL_RESERVE_OUT_RESERVE_OUT_MASK 0xff
#define  SYS_PLL_RESERVE_OUT_RESERVE_OUT_SHIFT 0
#define  SYS_PLL_RESERVE_OUT_RESERVE_OUT_MASK_SHIFT(reg) (((reg) & SYS_PLL_RESERVE_OUT_RESERVE_OUT_MASK) >> SYS_PLL_RESERVE_OUT_RESERVE_OUT_SHIFT)
#define  SYS_PLL_RESERVE_OUT_RESERVE_OUT_REPLACE_VAL(reg,val) (((reg) & ~SYS_PLL_RESERVE_OUT_RESERVE_OUT_MASK) | (((uint32_t)val) << SYS_PLL_RESERVE_OUT_RESERVE_OUT_SHIFT))

//====================================================================
//
//Register File: CORE PLL Controls (CORE_PLL)
//
//====================================================================

//====================================================================
//Register: PLL reset & Pre-divider Register (rst_prediv)
/** \brief RESET, 1 = PLL in reset
           0 = PLL in normal mode
    RESET_SSC, 1 = SSC and Freq Offset in reset
               0 = SSC and Freq Offset operating mode
    RESET_PI, 1 = External Interpolator in reset
               0 = operating mode*/
//====================================================================

#define  CORE_PLL_RST_PREDIV_RESERVED1_MASK 0xfff80000
#define  CORE_PLL_RST_PREDIV_RESERVED1_SHIFT 19
#define  CORE_PLL_RST_PREDIV_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_RST_PREDIV_RESERVED1_MASK) >> CORE_PLL_RST_PREDIV_RESERVED1_SHIFT)
#define  CORE_PLL_RST_PREDIV_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_RST_PREDIV_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_RST_PREDIV_RESERVED1_SHIFT))

#define  CORE_PLL_RST_PREDIV_RESET_PI_MASK 0x40000
#define  CORE_PLL_RST_PREDIV_RESET_PI_SHIFT 18
#define  CORE_PLL_RST_PREDIV_RESET_PI_MASK_SHIFT(reg) (((reg) & CORE_PLL_RST_PREDIV_RESET_PI_MASK) >> CORE_PLL_RST_PREDIV_RESET_PI_SHIFT)
#define  CORE_PLL_RST_PREDIV_RESET_PI_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_RST_PREDIV_RESET_PI_MASK) | (((uint32_t)val) << CORE_PLL_RST_PREDIV_RESET_PI_SHIFT))

#define  CORE_PLL_RST_PREDIV_RESET_SSC_MASK 0x20000
#define  CORE_PLL_RST_PREDIV_RESET_SSC_SHIFT 17
#define  CORE_PLL_RST_PREDIV_RESET_SSC_MASK_SHIFT(reg) (((reg) & CORE_PLL_RST_PREDIV_RESET_SSC_MASK) >> CORE_PLL_RST_PREDIV_RESET_SSC_SHIFT)
#define  CORE_PLL_RST_PREDIV_RESET_SSC_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_RST_PREDIV_RESET_SSC_MASK) | (((uint32_t)val) << CORE_PLL_RST_PREDIV_RESET_SSC_SHIFT))

#define  CORE_PLL_RST_PREDIV_RESET_MASK 0x10000
#define  CORE_PLL_RST_PREDIV_RESET_SHIFT 16
#define  CORE_PLL_RST_PREDIV_RESET_MASK_SHIFT(reg) (((reg) & CORE_PLL_RST_PREDIV_RESET_MASK) >> CORE_PLL_RST_PREDIV_RESET_SHIFT)
#define  CORE_PLL_RST_PREDIV_RESET_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_RST_PREDIV_RESET_MASK) | (((uint32_t)val) << CORE_PLL_RST_PREDIV_RESET_SHIFT))

#define  CORE_PLL_RST_PREDIV_RESERVED2_MASK 0xfe00
#define  CORE_PLL_RST_PREDIV_RESERVED2_SHIFT 9
#define  CORE_PLL_RST_PREDIV_RESERVED2_MASK_SHIFT(reg) (((reg) & CORE_PLL_RST_PREDIV_RESERVED2_MASK) >> CORE_PLL_RST_PREDIV_RESERVED2_SHIFT)
#define  CORE_PLL_RST_PREDIV_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_RST_PREDIV_RESERVED2_MASK) | (((uint32_t)val) << CORE_PLL_RST_PREDIV_RESERVED2_SHIFT))

#define  CORE_PLL_RST_PREDIV_REFDIV_MASK 0x1ff
#define  CORE_PLL_RST_PREDIV_REFDIV_SHIFT 0
#define  CORE_PLL_RST_PREDIV_REFDIV_MASK_SHIFT(reg) (((reg) & CORE_PLL_RST_PREDIV_REFDIV_MASK) >> CORE_PLL_RST_PREDIV_REFDIV_SHIFT)
#define  CORE_PLL_RST_PREDIV_REFDIV_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_RST_PREDIV_REFDIV_MASK) | (((uint32_t)val) << CORE_PLL_RST_PREDIV_REFDIV_SHIFT))

//====================================================================
//Register: PLL feedback multiplier (mult_postdiv)
/** \brief PLL multiplication factor after pre-divide.*/
//====================================================================

#define  CORE_PLL_MULT_POSTDIV_RESERVED1_MASK 0xfe000000
#define  CORE_PLL_MULT_POSTDIV_RESERVED1_SHIFT 25
#define  CORE_PLL_MULT_POSTDIV_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_MULT_POSTDIV_RESERVED1_MASK) >> CORE_PLL_MULT_POSTDIV_RESERVED1_SHIFT)
#define  CORE_PLL_MULT_POSTDIV_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_MULT_POSTDIV_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_MULT_POSTDIV_RESERVED1_SHIFT))

#define  CORE_PLL_MULT_POSTDIV_FBDIV_MASK 0x1ff0000
#define  CORE_PLL_MULT_POSTDIV_FBDIV_SHIFT 16
#define  CORE_PLL_MULT_POSTDIV_FBDIV_MASK_SHIFT(reg) (((reg) & CORE_PLL_MULT_POSTDIV_FBDIV_MASK) >> CORE_PLL_MULT_POSTDIV_FBDIV_SHIFT)
#define  CORE_PLL_MULT_POSTDIV_FBDIV_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_MULT_POSTDIV_FBDIV_MASK) | (((uint32_t)val) << CORE_PLL_MULT_POSTDIV_FBDIV_SHIFT))

#define  CORE_PLL_MULT_POSTDIV_RESERVED2_MASK 0xf800
#define  CORE_PLL_MULT_POSTDIV_RESERVED2_SHIFT 11
#define  CORE_PLL_MULT_POSTDIV_RESERVED2_MASK_SHIFT(reg) (((reg) & CORE_PLL_MULT_POSTDIV_RESERVED2_MASK) >> CORE_PLL_MULT_POSTDIV_RESERVED2_SHIFT)
#define  CORE_PLL_MULT_POSTDIV_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_MULT_POSTDIV_RESERVED2_MASK) | (((uint32_t)val) << CORE_PLL_MULT_POSTDIV_RESERVED2_SHIFT))

#define  CORE_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK 0x700
#define  CORE_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_SHIFT 8
#define  CORE_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK_SHIFT(reg) (((reg) & CORE_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK) >> CORE_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_SHIFT)
#define  CORE_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK) | (((uint32_t)val) << CORE_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_SHIFT))

#define  CORE_PLL_MULT_POSTDIV_RESERVED3_MASK 0xf8
#define  CORE_PLL_MULT_POSTDIV_RESERVED3_SHIFT 3
#define  CORE_PLL_MULT_POSTDIV_RESERVED3_MASK_SHIFT(reg) (((reg) & CORE_PLL_MULT_POSTDIV_RESERVED3_MASK) >> CORE_PLL_MULT_POSTDIV_RESERVED3_SHIFT)
#define  CORE_PLL_MULT_POSTDIV_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_MULT_POSTDIV_RESERVED3_MASK) | (((uint32_t)val) << CORE_PLL_MULT_POSTDIV_RESERVED3_SHIFT))

#define  CORE_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK 0x7
#define  CORE_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_SHIFT 0
#define  CORE_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK_SHIFT(reg) (((reg) & CORE_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK) >> CORE_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_SHIFT)
#define  CORE_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK) | (((uint32_t)val) << CORE_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_SHIFT))

//====================================================================
//Register: PLL gain control (kvco)
/** \brief PLL gain control.*/
//====================================================================

#define  CORE_PLL_KVCO_RESERVED1_MASK 0xfffffff0
#define  CORE_PLL_KVCO_RESERVED1_SHIFT 4
#define  CORE_PLL_KVCO_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_KVCO_RESERVED1_MASK) >> CORE_PLL_KVCO_RESERVED1_SHIFT)
#define  CORE_PLL_KVCO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_KVCO_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_KVCO_RESERVED1_SHIFT))

#define  CORE_PLL_KVCO_KVCO_MASK 0xf
#define  CORE_PLL_KVCO_KVCO_SHIFT 0
#define  CORE_PLL_KVCO_KVCO_MASK_SHIFT(reg) (((reg) & CORE_PLL_KVCO_KVCO_MASK) >> CORE_PLL_KVCO_KVCO_SHIFT)
#define  CORE_PLL_KVCO_KVCO_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_KVCO_KVCO_MASK) | (((uint32_t)val) << CORE_PLL_KVCO_KVCO_SHIFT))

//====================================================================
//Register: PLL misc control (misc)
/** \brief PLL misc control.*/
//====================================================================

#define  CORE_PLL_MISC_RESERVED1_MASK 0xffff0000
#define  CORE_PLL_MISC_RESERVED1_SHIFT 16
#define  CORE_PLL_MISC_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_MISC_RESERVED1_MASK) >> CORE_PLL_MISC_RESERVED1_SHIFT)
#define  CORE_PLL_MISC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_MISC_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_MISC_RESERVED1_SHIFT))

#define  CORE_PLL_MISC_PLL_BW_SEL_MASK 0x8000
#define  CORE_PLL_MISC_PLL_BW_SEL_SHIFT 15
#define  CORE_PLL_MISC_PLL_BW_SEL_MASK_SHIFT(reg) (((reg) & CORE_PLL_MISC_PLL_BW_SEL_MASK) >> CORE_PLL_MISC_PLL_BW_SEL_SHIFT)
#define  CORE_PLL_MISC_PLL_BW_SEL_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_MISC_PLL_BW_SEL_MASK) | (((uint32_t)val) << CORE_PLL_MISC_PLL_BW_SEL_SHIFT))

#define  CORE_PLL_MISC_CTUNE_MASK 0x6000
#define  CORE_PLL_MISC_CTUNE_SHIFT 13
#define  CORE_PLL_MISC_CTUNE_MASK_SHIFT(reg) (((reg) & CORE_PLL_MISC_CTUNE_MASK) >> CORE_PLL_MISC_CTUNE_SHIFT)
#define  CORE_PLL_MISC_CTUNE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_MISC_CTUNE_MASK) | (((uint32_t)val) << CORE_PLL_MISC_CTUNE_SHIFT))

#define  CORE_PLL_MISC_INTPI_MASK 0x1e00
#define  CORE_PLL_MISC_INTPI_SHIFT 9
#define  CORE_PLL_MISC_INTPI_MASK_SHIFT(reg) (((reg) & CORE_PLL_MISC_INTPI_MASK) >> CORE_PLL_MISC_INTPI_SHIFT)
#define  CORE_PLL_MISC_INTPI_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_MISC_INTPI_MASK) | (((uint32_t)val) << CORE_PLL_MISC_INTPI_SHIFT))

#define  CORE_PLL_MISC_ICP_MASK 0x1e0
#define  CORE_PLL_MISC_ICP_SHIFT 5
#define  CORE_PLL_MISC_ICP_MASK_SHIFT(reg) (((reg) & CORE_PLL_MISC_ICP_MASK) >> CORE_PLL_MISC_ICP_SHIFT)
#define  CORE_PLL_MISC_ICP_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_MISC_ICP_MASK) | (((uint32_t)val) << CORE_PLL_MISC_ICP_SHIFT))

#define  CORE_PLL_MISC_VDDM_MASK 0x18
#define  CORE_PLL_MISC_VDDM_SHIFT 3
#define  CORE_PLL_MISC_VDDM_MASK_SHIFT(reg) (((reg) & CORE_PLL_MISC_VDDM_MASK) >> CORE_PLL_MISC_VDDM_SHIFT)
#define  CORE_PLL_MISC_VDDM_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_MISC_VDDM_MASK) | (((uint32_t)val) << CORE_PLL_MISC_VDDM_SHIFT))

#define  CORE_PLL_MISC_VDDL_MASK 0x7
#define  CORE_PLL_MISC_VDDL_SHIFT 0
#define  CORE_PLL_MISC_VDDL_MASK_SHIFT(reg) (((reg) & CORE_PLL_MISC_VDDL_MASK) >> CORE_PLL_MISC_VDDL_SHIFT)
#define  CORE_PLL_MISC_VDDL_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_MISC_VDDL_MASK) | (((uint32_t)val) << CORE_PLL_MISC_VDDL_SHIFT))

//====================================================================
//Register: PLL PFD (Phase Frequency Detector) input select, and de-skew application control (feedback_mode_deskew)
/** \brief PLL feedback mode control.*/
//====================================================================

#define  CORE_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_MASK 0xff800000
#define  CORE_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_SHIFT 23
#define  CORE_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_MASK) >> CORE_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_SHIFT)
#define  CORE_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_SHIFT))

#define  CORE_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_MASK 0x7e0000
#define  CORE_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_SHIFT 17
#define  CORE_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_MASK_SHIFT(reg) (((reg) & CORE_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_MASK) >> CORE_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_SHIFT)
#define  CORE_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_MASK) | (((uint32_t)val) << CORE_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_SHIFT))

#define  CORE_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK 0x10000
#define  CORE_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_SHIFT 16
#define  CORE_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK_SHIFT(reg) (((reg) & CORE_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK) >> CORE_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_SHIFT)
#define  CORE_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK) | (((uint32_t)val) << CORE_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_SHIFT))

#define  CORE_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_MASK 0xffff
#define  CORE_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_SHIFT 0
#define  CORE_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_MASK_SHIFT(reg) (((reg) & CORE_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_MASK) >> CORE_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_SHIFT)
#define  CORE_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_MASK) | (((uint32_t)val) << CORE_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_SHIFT))

//====================================================================
//Register: PLL offset frequency control (offset_mode)
/** \brief PLL offset frequency control.*/
//====================================================================

#define  CORE_PLL_OFFSET_MODE_RESERVED1_MASK 0xf8000000
#define  CORE_PLL_OFFSET_MODE_RESERVED1_SHIFT 27
#define  CORE_PLL_OFFSET_MODE_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_OFFSET_MODE_RESERVED1_MASK) >> CORE_PLL_OFFSET_MODE_RESERVED1_SHIFT)
#define  CORE_PLL_OFFSET_MODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_OFFSET_MODE_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_OFFSET_MODE_RESERVED1_SHIFT))

#define  CORE_PLL_OFFSET_MODE_INTPR_MASK 0x7000000
#define  CORE_PLL_OFFSET_MODE_INTPR_SHIFT 24
#define  CORE_PLL_OFFSET_MODE_INTPR_MASK_SHIFT(reg) (((reg) & CORE_PLL_OFFSET_MODE_INTPR_MASK) >> CORE_PLL_OFFSET_MODE_INTPR_SHIFT)
#define  CORE_PLL_OFFSET_MODE_INTPR_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_OFFSET_MODE_INTPR_MASK) | (((uint32_t)val) << CORE_PLL_OFFSET_MODE_INTPR_SHIFT))

#define  CORE_PLL_OFFSET_MODE_FD_MASK 0xe00000
#define  CORE_PLL_OFFSET_MODE_FD_SHIFT 21
#define  CORE_PLL_OFFSET_MODE_FD_MASK_SHIFT(reg) (((reg) & CORE_PLL_OFFSET_MODE_FD_MASK) >> CORE_PLL_OFFSET_MODE_FD_SHIFT)
#define  CORE_PLL_OFFSET_MODE_FD_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_OFFSET_MODE_FD_MASK) | (((uint32_t)val) << CORE_PLL_OFFSET_MODE_FD_SHIFT))

#define  CORE_PLL_OFFSET_MODE_PI_LOOP_MODE_MASK 0x100000
#define  CORE_PLL_OFFSET_MODE_PI_LOOP_MODE_SHIFT 20
#define  CORE_PLL_OFFSET_MODE_PI_LOOP_MODE_MASK_SHIFT(reg) (((reg) & CORE_PLL_OFFSET_MODE_PI_LOOP_MODE_MASK) >> CORE_PLL_OFFSET_MODE_PI_LOOP_MODE_SHIFT)
#define  CORE_PLL_OFFSET_MODE_PI_LOOP_MODE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_OFFSET_MODE_PI_LOOP_MODE_MASK) | (((uint32_t)val) << CORE_PLL_OFFSET_MODE_PI_LOOP_MODE_SHIFT))

#define  CORE_PLL_OFFSET_MODE_FREQ_OFFSET_MASK 0xffff8
#define  CORE_PLL_OFFSET_MODE_FREQ_OFFSET_SHIFT 3
#define  CORE_PLL_OFFSET_MODE_FREQ_OFFSET_MASK_SHIFT(reg) (((reg) & CORE_PLL_OFFSET_MODE_FREQ_OFFSET_MASK) >> CORE_PLL_OFFSET_MODE_FREQ_OFFSET_SHIFT)
#define  CORE_PLL_OFFSET_MODE_FREQ_OFFSET_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_OFFSET_MODE_FREQ_OFFSET_MASK) | (((uint32_t)val) << CORE_PLL_OFFSET_MODE_FREQ_OFFSET_SHIFT))

#define  CORE_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK 0x4
#define  CORE_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_SHIFT 2
#define  CORE_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK_SHIFT(reg) (((reg) & CORE_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK) >> CORE_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_SHIFT)
#define  CORE_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK) | (((uint32_t)val) << CORE_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_SHIFT))

#define  CORE_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_MASK 0x2
#define  CORE_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_SHIFT 1
#define  CORE_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_MASK_SHIFT(reg) (((reg) & CORE_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_MASK) >> CORE_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_SHIFT)
#define  CORE_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_MASK) | (((uint32_t)val) << CORE_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_SHIFT))

#define  CORE_PLL_OFFSET_MODE_FREQ_OFFSET_EN_MASK 0x1
#define  CORE_PLL_OFFSET_MODE_FREQ_OFFSET_EN_SHIFT 0
#define  CORE_PLL_OFFSET_MODE_FREQ_OFFSET_EN_MASK_SHIFT(reg) (((reg) & CORE_PLL_OFFSET_MODE_FREQ_OFFSET_EN_MASK) >> CORE_PLL_OFFSET_MODE_FREQ_OFFSET_EN_SHIFT)
#define  CORE_PLL_OFFSET_MODE_FREQ_OFFSET_EN_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_OFFSET_MODE_FREQ_OFFSET_EN_MASK) | (((uint32_t)val) << CORE_PLL_OFFSET_MODE_FREQ_OFFSET_EN_SHIFT))

//====================================================================
//Register: PLL enable (fixed_mode_ssc_mode)
/** \brief PLL enable*/
//====================================================================

#define  CORE_PLL_FIXED_MODE_SSC_MODE_RESERVED1_MASK 0xfff00000
#define  CORE_PLL_FIXED_MODE_SSC_MODE_RESERVED1_SHIFT 20
#define  CORE_PLL_FIXED_MODE_SSC_MODE_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_FIXED_MODE_SSC_MODE_RESERVED1_MASK) >> CORE_PLL_FIXED_MODE_SSC_MODE_RESERVED1_SHIFT)
#define  CORE_PLL_FIXED_MODE_SSC_MODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_FIXED_MODE_SSC_MODE_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_FIXED_MODE_SSC_MODE_RESERVED1_SHIFT))

#define  CORE_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK 0x80000
#define  CORE_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_SHIFT 19
#define  CORE_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK_SHIFT(reg) (((reg) & CORE_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK) >> CORE_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_SHIFT)
#define  CORE_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK) | (((uint32_t)val) << CORE_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_SHIFT))

#define  CORE_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK 0x40000
#define  CORE_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_SHIFT 18
#define  CORE_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK_SHIFT(reg) (((reg) & CORE_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK) >> CORE_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_SHIFT)
#define  CORE_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK) | (((uint32_t)val) << CORE_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_SHIFT))

#define  CORE_PLL_FIXED_MODE_SSC_MODE_PU_MASK 0x20000
#define  CORE_PLL_FIXED_MODE_SSC_MODE_PU_SHIFT 17
#define  CORE_PLL_FIXED_MODE_SSC_MODE_PU_MASK_SHIFT(reg) (((reg) & CORE_PLL_FIXED_MODE_SSC_MODE_PU_MASK) >> CORE_PLL_FIXED_MODE_SSC_MODE_PU_SHIFT)
#define  CORE_PLL_FIXED_MODE_SSC_MODE_PU_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_FIXED_MODE_SSC_MODE_PU_MASK) | (((uint32_t)val) << CORE_PLL_FIXED_MODE_SSC_MODE_PU_SHIFT))

#define  CORE_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK 0x10000
#define  CORE_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_SHIFT 16
#define  CORE_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK_SHIFT(reg) (((reg) & CORE_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK) >> CORE_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_SHIFT)
#define  CORE_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK) | (((uint32_t)val) << CORE_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_SHIFT))

#define  CORE_PLL_FIXED_MODE_SSC_MODE_RESERVED2_MASK 0xfff0
#define  CORE_PLL_FIXED_MODE_SSC_MODE_RESERVED2_SHIFT 4
#define  CORE_PLL_FIXED_MODE_SSC_MODE_RESERVED2_MASK_SHIFT(reg) (((reg) & CORE_PLL_FIXED_MODE_SSC_MODE_RESERVED2_MASK) >> CORE_PLL_FIXED_MODE_SSC_MODE_RESERVED2_SHIFT)
#define  CORE_PLL_FIXED_MODE_SSC_MODE_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_FIXED_MODE_SSC_MODE_RESERVED2_MASK) | (((uint32_t)val) << CORE_PLL_FIXED_MODE_SSC_MODE_RESERVED2_SHIFT))

#define  CORE_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_MASK 0x8
#define  CORE_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_SHIFT 3
#define  CORE_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_MASK_SHIFT(reg) (((reg) & CORE_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_MASK) >> CORE_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_SHIFT)
#define  CORE_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_MASK) | (((uint32_t)val) << CORE_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_SHIFT))

#define  CORE_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK 0x4
#define  CORE_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_SHIFT 2
#define  CORE_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK_SHIFT(reg) (((reg) & CORE_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK) >> CORE_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_SHIFT)
#define  CORE_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK) | (((uint32_t)val) << CORE_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_SHIFT))

#define  CORE_PLL_FIXED_MODE_SSC_MODE_PI_EN_MASK 0x2
#define  CORE_PLL_FIXED_MODE_SSC_MODE_PI_EN_SHIFT 1
#define  CORE_PLL_FIXED_MODE_SSC_MODE_PI_EN_MASK_SHIFT(reg) (((reg) & CORE_PLL_FIXED_MODE_SSC_MODE_PI_EN_MASK) >> CORE_PLL_FIXED_MODE_SSC_MODE_PI_EN_SHIFT)
#define  CORE_PLL_FIXED_MODE_SSC_MODE_PI_EN_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_FIXED_MODE_SSC_MODE_PI_EN_MASK) | (((uint32_t)val) << CORE_PLL_FIXED_MODE_SSC_MODE_PI_EN_SHIFT))

#define  CORE_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK 0x1
#define  CORE_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_SHIFT 0
#define  CORE_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK_SHIFT(reg) (((reg) & CORE_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK) >> CORE_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_SHIFT)
#define  CORE_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK) | (((uint32_t)val) << CORE_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_SHIFT))

//====================================================================
//Register: PLL Modulation Frequency (ssc_freq_ssc_range)
/** \brief PLL Modulation Frequency Control*/
//====================================================================

#define  CORE_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK 0xffff0000
#define  CORE_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_SHIFT 16
#define  CORE_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK_SHIFT(reg) (((reg) & CORE_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK) >> CORE_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_SHIFT)
#define  CORE_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK) | (((uint32_t)val) << CORE_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_SHIFT))

#define  CORE_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_MASK 0xf800
#define  CORE_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_SHIFT 11
#define  CORE_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_MASK) >> CORE_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_SHIFT)
#define  CORE_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_SHIFT))

#define  CORE_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK 0x7ff
#define  CORE_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_SHIFT 0
#define  CORE_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK_SHIFT(reg) (((reg) & CORE_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK) >> CORE_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_SHIFT)
#define  CORE_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK) | (((uint32_t)val) << CORE_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_SHIFT))

//====================================================================
//Register: PLL Output Clock Control (clk_ctrl_marvell_test)
/** \brief PLL Output Clock Control*/
//====================================================================

#define  CORE_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK 0xfffc0000
#define  CORE_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_SHIFT 18
#define  CORE_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK) >> CORE_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_SHIFT)
#define  CORE_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_SHIFT))

#define  CORE_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK 0x20000
#define  CORE_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_SHIFT 17
#define  CORE_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK_SHIFT(reg) (((reg) & CORE_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK) >> CORE_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_SHIFT)
#define  CORE_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK) | (((uint32_t)val) << CORE_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_SHIFT))

#define  CORE_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK 0x10000
#define  CORE_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_SHIFT 16
#define  CORE_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK_SHIFT(reg) (((reg) & CORE_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK) >> CORE_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_SHIFT)
#define  CORE_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK) | (((uint32_t)val) << CORE_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_SHIFT))

#define  CORE_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK 0xf000
#define  CORE_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_SHIFT 12
#define  CORE_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK_SHIFT(reg) (((reg) & CORE_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK) >> CORE_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_SHIFT)
#define  CORE_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK) | (((uint32_t)val) << CORE_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_SHIFT))

#define  CORE_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK 0xff0
#define  CORE_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_SHIFT 4
#define  CORE_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK_SHIFT(reg) (((reg) & CORE_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK) >> CORE_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_SHIFT)
#define  CORE_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK) | (((uint32_t)val) << CORE_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_SHIFT))

#define  CORE_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK 0xf
#define  CORE_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_SHIFT 0
#define  CORE_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK_SHIFT(reg) (((reg) & CORE_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK) >> CORE_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_SHIFT)
#define  CORE_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK) | (((uint32_t)val) << CORE_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_SHIFT))

//====================================================================
//Register: PLL Lock Status (lock_status)
/** \brief PLL Lock Output*/
//====================================================================

#define  CORE_PLL_LOCK_STATUS_RESERVED1_MASK 0xfffffffe
#define  CORE_PLL_LOCK_STATUS_RESERVED1_SHIFT 1
#define  CORE_PLL_LOCK_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_LOCK_STATUS_RESERVED1_MASK) >> CORE_PLL_LOCK_STATUS_RESERVED1_SHIFT)
#define  CORE_PLL_LOCK_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_LOCK_STATUS_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_LOCK_STATUS_RESERVED1_SHIFT))

#define  CORE_PLL_LOCK_STATUS_PLL_LOCK_MASK 0x1
#define  CORE_PLL_LOCK_STATUS_PLL_LOCK_SHIFT 0
#define  CORE_PLL_LOCK_STATUS_PLL_LOCK_MASK_SHIFT(reg) (((reg) & CORE_PLL_LOCK_STATUS_PLL_LOCK_MASK) >> CORE_PLL_LOCK_STATUS_PLL_LOCK_SHIFT)
#define  CORE_PLL_LOCK_STATUS_PLL_LOCK_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_LOCK_STATUS_PLL_LOCK_MASK) | (((uint32_t)val) << CORE_PLL_LOCK_STATUS_PLL_LOCK_SHIFT))

//====================================================================
//Register: PLL RESERVE_OUT output (reserve_out)
//====================================================================

#define  CORE_PLL_RESERVE_OUT_RESERVED1_MASK 0xfffe0000
#define  CORE_PLL_RESERVE_OUT_RESERVED1_SHIFT 17
#define  CORE_PLL_RESERVE_OUT_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_RESERVE_OUT_RESERVED1_MASK) >> CORE_PLL_RESERVE_OUT_RESERVED1_SHIFT)
#define  CORE_PLL_RESERVE_OUT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_RESERVE_OUT_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_RESERVE_OUT_RESERVED1_SHIFT))

#define  CORE_PLL_RESERVE_OUT_PU18_REG_MASK 0x10000
#define  CORE_PLL_RESERVE_OUT_PU18_REG_SHIFT 16
#define  CORE_PLL_RESERVE_OUT_PU18_REG_MASK_SHIFT(reg) (((reg) & CORE_PLL_RESERVE_OUT_PU18_REG_MASK) >> CORE_PLL_RESERVE_OUT_PU18_REG_SHIFT)
#define  CORE_PLL_RESERVE_OUT_PU18_REG_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_RESERVE_OUT_PU18_REG_MASK) | (((uint32_t)val) << CORE_PLL_RESERVE_OUT_PU18_REG_SHIFT))

#define  CORE_PLL_RESERVE_OUT_RESERVED2_MASK 0xff00
#define  CORE_PLL_RESERVE_OUT_RESERVED2_SHIFT 8
#define  CORE_PLL_RESERVE_OUT_RESERVED2_MASK_SHIFT(reg) (((reg) & CORE_PLL_RESERVE_OUT_RESERVED2_MASK) >> CORE_PLL_RESERVE_OUT_RESERVED2_SHIFT)
#define  CORE_PLL_RESERVE_OUT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_RESERVE_OUT_RESERVED2_MASK) | (((uint32_t)val) << CORE_PLL_RESERVE_OUT_RESERVED2_SHIFT))

#define  CORE_PLL_RESERVE_OUT_RESERVE_OUT_MASK 0xff
#define  CORE_PLL_RESERVE_OUT_RESERVE_OUT_SHIFT 0
#define  CORE_PLL_RESERVE_OUT_RESERVE_OUT_MASK_SHIFT(reg) (((reg) & CORE_PLL_RESERVE_OUT_RESERVE_OUT_MASK) >> CORE_PLL_RESERVE_OUT_RESERVE_OUT_SHIFT)
#define  CORE_PLL_RESERVE_OUT_RESERVE_OUT_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_RESERVE_OUT_RESERVE_OUT_MASK) | (((uint32_t)val) << CORE_PLL_RESERVE_OUT_RESERVE_OUT_SHIFT))

//====================================================================
//
//Register File: CORE PLL Spread Spectrum Controls (CORE_PLL_CSSCG)
/** \brief Top-level register file for the CSSCG block*/
//
//====================================================================

//====================================================================
//Register: Interrupt Enable Register (IRQ_EN)
/** \brief Used to enable interrupts for the block.*/
//====================================================================

#define  CORE_PLL_CSSCG_IRQ_EN_RESERVED1_MASK 0xfffffe00
#define  CORE_PLL_CSSCG_IRQ_EN_RESERVED1_SHIFT 9
#define  CORE_PLL_CSSCG_IRQ_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_EN_RESERVED1_MASK) >> CORE_PLL_CSSCG_IRQ_EN_RESERVED1_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_EN_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_EN_RESERVED1_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_EN_SLV_ARMED_IRQ_EN_MASK 0x100
#define  CORE_PLL_CSSCG_IRQ_EN_SLV_ARMED_IRQ_EN_SHIFT 8
#define  CORE_PLL_CSSCG_IRQ_EN_SLV_ARMED_IRQ_EN_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_EN_SLV_ARMED_IRQ_EN_MASK) >> CORE_PLL_CSSCG_IRQ_EN_SLV_ARMED_IRQ_EN_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_EN_SLV_ARMED_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_EN_SLV_ARMED_IRQ_EN_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_EN_SLV_ARMED_IRQ_EN_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_EN_SLV_FULL_IRQ_EN_MASK 0x80
#define  CORE_PLL_CSSCG_IRQ_EN_SLV_FULL_IRQ_EN_SHIFT 7
#define  CORE_PLL_CSSCG_IRQ_EN_SLV_FULL_IRQ_EN_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_EN_SLV_FULL_IRQ_EN_MASK) >> CORE_PLL_CSSCG_IRQ_EN_SLV_FULL_IRQ_EN_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_EN_SLV_FULL_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_EN_SLV_FULL_IRQ_EN_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_EN_SLV_FULL_IRQ_EN_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_EN_SLV_INIT_IRQ_EN_MASK 0x40
#define  CORE_PLL_CSSCG_IRQ_EN_SLV_INIT_IRQ_EN_SHIFT 6
#define  CORE_PLL_CSSCG_IRQ_EN_SLV_INIT_IRQ_EN_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_EN_SLV_INIT_IRQ_EN_MASK) >> CORE_PLL_CSSCG_IRQ_EN_SLV_INIT_IRQ_EN_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_EN_SLV_INIT_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_EN_SLV_INIT_IRQ_EN_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_EN_SLV_INIT_IRQ_EN_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_EN_SLV_TIMEOUT_IRQ_EN_MASK 0x20
#define  CORE_PLL_CSSCG_IRQ_EN_SLV_TIMEOUT_IRQ_EN_SHIFT 5
#define  CORE_PLL_CSSCG_IRQ_EN_SLV_TIMEOUT_IRQ_EN_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_EN_SLV_TIMEOUT_IRQ_EN_MASK) >> CORE_PLL_CSSCG_IRQ_EN_SLV_TIMEOUT_IRQ_EN_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_EN_SLV_TIMEOUT_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_EN_SLV_TIMEOUT_IRQ_EN_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_EN_SLV_TIMEOUT_IRQ_EN_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_EN_SLV_TRIG_ERR_IRQ_EN_MASK 0x10
#define  CORE_PLL_CSSCG_IRQ_EN_SLV_TRIG_ERR_IRQ_EN_SHIFT 4
#define  CORE_PLL_CSSCG_IRQ_EN_SLV_TRIG_ERR_IRQ_EN_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_EN_SLV_TRIG_ERR_IRQ_EN_MASK) >> CORE_PLL_CSSCG_IRQ_EN_SLV_TRIG_ERR_IRQ_EN_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_EN_SLV_TRIG_ERR_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_EN_SLV_TRIG_ERR_IRQ_EN_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_EN_SLV_TRIG_ERR_IRQ_EN_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_EN_SLV_TRIG_IRQ_EN_MASK 0x8
#define  CORE_PLL_CSSCG_IRQ_EN_SLV_TRIG_IRQ_EN_SHIFT 3
#define  CORE_PLL_CSSCG_IRQ_EN_SLV_TRIG_IRQ_EN_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_EN_SLV_TRIG_IRQ_EN_MASK) >> CORE_PLL_CSSCG_IRQ_EN_SLV_TRIG_IRQ_EN_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_EN_SLV_TRIG_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_EN_SLV_TRIG_IRQ_EN_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_EN_SLV_TRIG_IRQ_EN_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_EN_HALT_COMPLETE_IRQ_EN_MASK 0x4
#define  CORE_PLL_CSSCG_IRQ_EN_HALT_COMPLETE_IRQ_EN_SHIFT 2
#define  CORE_PLL_CSSCG_IRQ_EN_HALT_COMPLETE_IRQ_EN_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_EN_HALT_COMPLETE_IRQ_EN_MASK) >> CORE_PLL_CSSCG_IRQ_EN_HALT_COMPLETE_IRQ_EN_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_EN_HALT_COMPLETE_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_EN_HALT_COMPLETE_IRQ_EN_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_EN_HALT_COMPLETE_IRQ_EN_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_EN_DISABLE_COMPLETE_IRQ_EN_MASK 0x2
#define  CORE_PLL_CSSCG_IRQ_EN_DISABLE_COMPLETE_IRQ_EN_SHIFT 1
#define  CORE_PLL_CSSCG_IRQ_EN_DISABLE_COMPLETE_IRQ_EN_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_EN_DISABLE_COMPLETE_IRQ_EN_MASK) >> CORE_PLL_CSSCG_IRQ_EN_DISABLE_COMPLETE_IRQ_EN_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_EN_DISABLE_COMPLETE_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_EN_DISABLE_COMPLETE_IRQ_EN_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_EN_DISABLE_COMPLETE_IRQ_EN_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_EN_CYCLE_START_IRQ_EN_MASK 0x1
#define  CORE_PLL_CSSCG_IRQ_EN_CYCLE_START_IRQ_EN_SHIFT 0
#define  CORE_PLL_CSSCG_IRQ_EN_CYCLE_START_IRQ_EN_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_EN_CYCLE_START_IRQ_EN_MASK) >> CORE_PLL_CSSCG_IRQ_EN_CYCLE_START_IRQ_EN_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_EN_CYCLE_START_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_EN_CYCLE_START_IRQ_EN_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_EN_CYCLE_START_IRQ_EN_SHIFT))

//====================================================================
//Register: Interrupt Pending Register (IRQ_PEND)
/** \brief Used to read the status of the block's interrupts.*/
//====================================================================

#define  CORE_PLL_CSSCG_IRQ_PEND_RESERVED1_MASK 0xfffffe00
#define  CORE_PLL_CSSCG_IRQ_PEND_RESERVED1_SHIFT 9
#define  CORE_PLL_CSSCG_IRQ_PEND_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_PEND_RESERVED1_MASK) >> CORE_PLL_CSSCG_IRQ_PEND_RESERVED1_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_PEND_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_PEND_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_PEND_RESERVED1_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_PEND_SLV_ARMED_IRQ_PEND_MASK 0x100
#define  CORE_PLL_CSSCG_IRQ_PEND_SLV_ARMED_IRQ_PEND_SHIFT 8
#define  CORE_PLL_CSSCG_IRQ_PEND_SLV_ARMED_IRQ_PEND_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_PEND_SLV_ARMED_IRQ_PEND_MASK) >> CORE_PLL_CSSCG_IRQ_PEND_SLV_ARMED_IRQ_PEND_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_PEND_SLV_ARMED_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_PEND_SLV_ARMED_IRQ_PEND_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_PEND_SLV_ARMED_IRQ_PEND_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_PEND_SLV_FULL_IRQ_PEND_MASK 0x80
#define  CORE_PLL_CSSCG_IRQ_PEND_SLV_FULL_IRQ_PEND_SHIFT 7
#define  CORE_PLL_CSSCG_IRQ_PEND_SLV_FULL_IRQ_PEND_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_PEND_SLV_FULL_IRQ_PEND_MASK) >> CORE_PLL_CSSCG_IRQ_PEND_SLV_FULL_IRQ_PEND_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_PEND_SLV_FULL_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_PEND_SLV_FULL_IRQ_PEND_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_PEND_SLV_FULL_IRQ_PEND_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_PEND_SLV_INIT_IRQ_PEND_MASK 0x40
#define  CORE_PLL_CSSCG_IRQ_PEND_SLV_INIT_IRQ_PEND_SHIFT 6
#define  CORE_PLL_CSSCG_IRQ_PEND_SLV_INIT_IRQ_PEND_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_PEND_SLV_INIT_IRQ_PEND_MASK) >> CORE_PLL_CSSCG_IRQ_PEND_SLV_INIT_IRQ_PEND_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_PEND_SLV_INIT_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_PEND_SLV_INIT_IRQ_PEND_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_PEND_SLV_INIT_IRQ_PEND_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_PEND_SLV_TIMEOUT_IRQ_PEND_MASK 0x20
#define  CORE_PLL_CSSCG_IRQ_PEND_SLV_TIMEOUT_IRQ_PEND_SHIFT 5
#define  CORE_PLL_CSSCG_IRQ_PEND_SLV_TIMEOUT_IRQ_PEND_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_PEND_SLV_TIMEOUT_IRQ_PEND_MASK) >> CORE_PLL_CSSCG_IRQ_PEND_SLV_TIMEOUT_IRQ_PEND_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_PEND_SLV_TIMEOUT_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_PEND_SLV_TIMEOUT_IRQ_PEND_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_PEND_SLV_TIMEOUT_IRQ_PEND_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_PEND_SLV_TRIG_ERR_IRQ_PEND_MASK 0x10
#define  CORE_PLL_CSSCG_IRQ_PEND_SLV_TRIG_ERR_IRQ_PEND_SHIFT 4
#define  CORE_PLL_CSSCG_IRQ_PEND_SLV_TRIG_ERR_IRQ_PEND_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_PEND_SLV_TRIG_ERR_IRQ_PEND_MASK) >> CORE_PLL_CSSCG_IRQ_PEND_SLV_TRIG_ERR_IRQ_PEND_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_PEND_SLV_TRIG_ERR_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_PEND_SLV_TRIG_ERR_IRQ_PEND_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_PEND_SLV_TRIG_ERR_IRQ_PEND_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_PEND_SLV_TRIG_IRQ_PEND_MASK 0x8
#define  CORE_PLL_CSSCG_IRQ_PEND_SLV_TRIG_IRQ_PEND_SHIFT 3
#define  CORE_PLL_CSSCG_IRQ_PEND_SLV_TRIG_IRQ_PEND_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_PEND_SLV_TRIG_IRQ_PEND_MASK) >> CORE_PLL_CSSCG_IRQ_PEND_SLV_TRIG_IRQ_PEND_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_PEND_SLV_TRIG_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_PEND_SLV_TRIG_IRQ_PEND_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_PEND_SLV_TRIG_IRQ_PEND_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_PEND_HALT_COMPLETE_IRQ_PEND_MASK 0x4
#define  CORE_PLL_CSSCG_IRQ_PEND_HALT_COMPLETE_IRQ_PEND_SHIFT 2
#define  CORE_PLL_CSSCG_IRQ_PEND_HALT_COMPLETE_IRQ_PEND_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_PEND_HALT_COMPLETE_IRQ_PEND_MASK) >> CORE_PLL_CSSCG_IRQ_PEND_HALT_COMPLETE_IRQ_PEND_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_PEND_HALT_COMPLETE_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_PEND_HALT_COMPLETE_IRQ_PEND_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_PEND_HALT_COMPLETE_IRQ_PEND_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_PEND_DISABLE_COMPLETE_IRQ_PEND_MASK 0x2
#define  CORE_PLL_CSSCG_IRQ_PEND_DISABLE_COMPLETE_IRQ_PEND_SHIFT 1
#define  CORE_PLL_CSSCG_IRQ_PEND_DISABLE_COMPLETE_IRQ_PEND_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_PEND_DISABLE_COMPLETE_IRQ_PEND_MASK) >> CORE_PLL_CSSCG_IRQ_PEND_DISABLE_COMPLETE_IRQ_PEND_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_PEND_DISABLE_COMPLETE_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_PEND_DISABLE_COMPLETE_IRQ_PEND_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_PEND_DISABLE_COMPLETE_IRQ_PEND_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_PEND_CYCLE_START_IRQ_PEND_MASK 0x1
#define  CORE_PLL_CSSCG_IRQ_PEND_CYCLE_START_IRQ_PEND_SHIFT 0
#define  CORE_PLL_CSSCG_IRQ_PEND_CYCLE_START_IRQ_PEND_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_PEND_CYCLE_START_IRQ_PEND_MASK) >> CORE_PLL_CSSCG_IRQ_PEND_CYCLE_START_IRQ_PEND_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_PEND_CYCLE_START_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_PEND_CYCLE_START_IRQ_PEND_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_PEND_CYCLE_START_IRQ_PEND_SHIFT))

//====================================================================
//Register: Interrupt Acknowledge Register (IRQ_ACK)
/** \brief Write a 1 to the bit to clear the appropriate interrupt. <br/> The Input and Output DMA interrupts must be cleared via their respective registers.*/
//====================================================================

#define  CORE_PLL_CSSCG_IRQ_ACK_RESERVED1_MASK 0xfffffe00
#define  CORE_PLL_CSSCG_IRQ_ACK_RESERVED1_SHIFT 9
#define  CORE_PLL_CSSCG_IRQ_ACK_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_ACK_RESERVED1_MASK) >> CORE_PLL_CSSCG_IRQ_ACK_RESERVED1_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_ACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_ACK_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_ACK_RESERVED1_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_ACK_SLV_ARMED_IRQ_ACK_MASK 0x100
#define  CORE_PLL_CSSCG_IRQ_ACK_SLV_ARMED_IRQ_ACK_SHIFT 8
#define  CORE_PLL_CSSCG_IRQ_ACK_SLV_ARMED_IRQ_ACK_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_ACK_SLV_ARMED_IRQ_ACK_MASK) >> CORE_PLL_CSSCG_IRQ_ACK_SLV_ARMED_IRQ_ACK_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_ACK_SLV_ARMED_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_ACK_SLV_ARMED_IRQ_ACK_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_ACK_SLV_ARMED_IRQ_ACK_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_ACK_SLV_FULL_IRQ_ACK_MASK 0x80
#define  CORE_PLL_CSSCG_IRQ_ACK_SLV_FULL_IRQ_ACK_SHIFT 7
#define  CORE_PLL_CSSCG_IRQ_ACK_SLV_FULL_IRQ_ACK_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_ACK_SLV_FULL_IRQ_ACK_MASK) >> CORE_PLL_CSSCG_IRQ_ACK_SLV_FULL_IRQ_ACK_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_ACK_SLV_FULL_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_ACK_SLV_FULL_IRQ_ACK_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_ACK_SLV_FULL_IRQ_ACK_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_ACK_SLV_INIT_IRQ_ACK_MASK 0x40
#define  CORE_PLL_CSSCG_IRQ_ACK_SLV_INIT_IRQ_ACK_SHIFT 6
#define  CORE_PLL_CSSCG_IRQ_ACK_SLV_INIT_IRQ_ACK_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_ACK_SLV_INIT_IRQ_ACK_MASK) >> CORE_PLL_CSSCG_IRQ_ACK_SLV_INIT_IRQ_ACK_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_ACK_SLV_INIT_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_ACK_SLV_INIT_IRQ_ACK_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_ACK_SLV_INIT_IRQ_ACK_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_ACK_SLV_TIMEOUT_IRQ_ACK_MASK 0x20
#define  CORE_PLL_CSSCG_IRQ_ACK_SLV_TIMEOUT_IRQ_ACK_SHIFT 5
#define  CORE_PLL_CSSCG_IRQ_ACK_SLV_TIMEOUT_IRQ_ACK_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_ACK_SLV_TIMEOUT_IRQ_ACK_MASK) >> CORE_PLL_CSSCG_IRQ_ACK_SLV_TIMEOUT_IRQ_ACK_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_ACK_SLV_TIMEOUT_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_ACK_SLV_TIMEOUT_IRQ_ACK_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_ACK_SLV_TIMEOUT_IRQ_ACK_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_ACK_SLV_TRIG_ERR_IRQ_ACK_MASK 0x10
#define  CORE_PLL_CSSCG_IRQ_ACK_SLV_TRIG_ERR_IRQ_ACK_SHIFT 4
#define  CORE_PLL_CSSCG_IRQ_ACK_SLV_TRIG_ERR_IRQ_ACK_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_ACK_SLV_TRIG_ERR_IRQ_ACK_MASK) >> CORE_PLL_CSSCG_IRQ_ACK_SLV_TRIG_ERR_IRQ_ACK_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_ACK_SLV_TRIG_ERR_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_ACK_SLV_TRIG_ERR_IRQ_ACK_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_ACK_SLV_TRIG_ERR_IRQ_ACK_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_ACK_SLV_TRIG_IRQ_ACK_MASK 0x8
#define  CORE_PLL_CSSCG_IRQ_ACK_SLV_TRIG_IRQ_ACK_SHIFT 3
#define  CORE_PLL_CSSCG_IRQ_ACK_SLV_TRIG_IRQ_ACK_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_ACK_SLV_TRIG_IRQ_ACK_MASK) >> CORE_PLL_CSSCG_IRQ_ACK_SLV_TRIG_IRQ_ACK_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_ACK_SLV_TRIG_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_ACK_SLV_TRIG_IRQ_ACK_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_ACK_SLV_TRIG_IRQ_ACK_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_ACK_HALT_COMPLETE_IRQ_ACK_MASK 0x4
#define  CORE_PLL_CSSCG_IRQ_ACK_HALT_COMPLETE_IRQ_ACK_SHIFT 2
#define  CORE_PLL_CSSCG_IRQ_ACK_HALT_COMPLETE_IRQ_ACK_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_ACK_HALT_COMPLETE_IRQ_ACK_MASK) >> CORE_PLL_CSSCG_IRQ_ACK_HALT_COMPLETE_IRQ_ACK_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_ACK_HALT_COMPLETE_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_ACK_HALT_COMPLETE_IRQ_ACK_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_ACK_HALT_COMPLETE_IRQ_ACK_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_ACK_DISABLE_COMPLETE_IRQ_ACK_MASK 0x2
#define  CORE_PLL_CSSCG_IRQ_ACK_DISABLE_COMPLETE_IRQ_ACK_SHIFT 1
#define  CORE_PLL_CSSCG_IRQ_ACK_DISABLE_COMPLETE_IRQ_ACK_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_ACK_DISABLE_COMPLETE_IRQ_ACK_MASK) >> CORE_PLL_CSSCG_IRQ_ACK_DISABLE_COMPLETE_IRQ_ACK_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_ACK_DISABLE_COMPLETE_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_ACK_DISABLE_COMPLETE_IRQ_ACK_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_ACK_DISABLE_COMPLETE_IRQ_ACK_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_ACK_CYCLE_START_IRQ_ACK_MASK 0x1
#define  CORE_PLL_CSSCG_IRQ_ACK_CYCLE_START_IRQ_ACK_SHIFT 0
#define  CORE_PLL_CSSCG_IRQ_ACK_CYCLE_START_IRQ_ACK_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_ACK_CYCLE_START_IRQ_ACK_MASK) >> CORE_PLL_CSSCG_IRQ_ACK_CYCLE_START_IRQ_ACK_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_ACK_CYCLE_START_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_ACK_CYCLE_START_IRQ_ACK_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_ACK_CYCLE_START_IRQ_ACK_SHIFT))

//====================================================================
//Register: Interrupt Force Register (IRQ_FORCE)
/** \brief Write a 1 to the bit to force the interrupt for testing purposes. <br/>*/
//====================================================================

#define  CORE_PLL_CSSCG_IRQ_FORCE_RESERVED1_MASK 0xfffffe00
#define  CORE_PLL_CSSCG_IRQ_FORCE_RESERVED1_SHIFT 9
#define  CORE_PLL_CSSCG_IRQ_FORCE_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_FORCE_RESERVED1_MASK) >> CORE_PLL_CSSCG_IRQ_FORCE_RESERVED1_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_FORCE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_FORCE_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_FORCE_RESERVED1_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_FORCE_SLV_ARMED_IRQ_FORCE_MASK 0x100
#define  CORE_PLL_CSSCG_IRQ_FORCE_SLV_ARMED_IRQ_FORCE_SHIFT 8
#define  CORE_PLL_CSSCG_IRQ_FORCE_SLV_ARMED_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_FORCE_SLV_ARMED_IRQ_FORCE_MASK) >> CORE_PLL_CSSCG_IRQ_FORCE_SLV_ARMED_IRQ_FORCE_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_FORCE_SLV_ARMED_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_FORCE_SLV_ARMED_IRQ_FORCE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_FORCE_SLV_ARMED_IRQ_FORCE_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_FORCE_SLV_FULL_IRQ_FORCE_MASK 0x80
#define  CORE_PLL_CSSCG_IRQ_FORCE_SLV_FULL_IRQ_FORCE_SHIFT 7
#define  CORE_PLL_CSSCG_IRQ_FORCE_SLV_FULL_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_FORCE_SLV_FULL_IRQ_FORCE_MASK) >> CORE_PLL_CSSCG_IRQ_FORCE_SLV_FULL_IRQ_FORCE_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_FORCE_SLV_FULL_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_FORCE_SLV_FULL_IRQ_FORCE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_FORCE_SLV_FULL_IRQ_FORCE_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_FORCE_SLV_INIT_IRQ_FORCE_MASK 0x40
#define  CORE_PLL_CSSCG_IRQ_FORCE_SLV_INIT_IRQ_FORCE_SHIFT 6
#define  CORE_PLL_CSSCG_IRQ_FORCE_SLV_INIT_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_FORCE_SLV_INIT_IRQ_FORCE_MASK) >> CORE_PLL_CSSCG_IRQ_FORCE_SLV_INIT_IRQ_FORCE_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_FORCE_SLV_INIT_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_FORCE_SLV_INIT_IRQ_FORCE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_FORCE_SLV_INIT_IRQ_FORCE_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_FORCE_SLV_TIMEOUT_IRQ_FORCE_MASK 0x20
#define  CORE_PLL_CSSCG_IRQ_FORCE_SLV_TIMEOUT_IRQ_FORCE_SHIFT 5
#define  CORE_PLL_CSSCG_IRQ_FORCE_SLV_TIMEOUT_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_FORCE_SLV_TIMEOUT_IRQ_FORCE_MASK) >> CORE_PLL_CSSCG_IRQ_FORCE_SLV_TIMEOUT_IRQ_FORCE_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_FORCE_SLV_TIMEOUT_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_FORCE_SLV_TIMEOUT_IRQ_FORCE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_FORCE_SLV_TIMEOUT_IRQ_FORCE_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_ERR_IRQ_FORCE_MASK 0x10
#define  CORE_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_ERR_IRQ_FORCE_SHIFT 4
#define  CORE_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_ERR_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_ERR_IRQ_FORCE_MASK) >> CORE_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_ERR_IRQ_FORCE_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_ERR_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_ERR_IRQ_FORCE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_ERR_IRQ_FORCE_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_IRQ_FORCE_MASK 0x8
#define  CORE_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_IRQ_FORCE_SHIFT 3
#define  CORE_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_IRQ_FORCE_MASK) >> CORE_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_IRQ_FORCE_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_IRQ_FORCE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_IRQ_FORCE_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_FORCE_HALT_COMPLETE_IRQ_FORCE_MASK 0x4
#define  CORE_PLL_CSSCG_IRQ_FORCE_HALT_COMPLETE_IRQ_FORCE_SHIFT 2
#define  CORE_PLL_CSSCG_IRQ_FORCE_HALT_COMPLETE_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_FORCE_HALT_COMPLETE_IRQ_FORCE_MASK) >> CORE_PLL_CSSCG_IRQ_FORCE_HALT_COMPLETE_IRQ_FORCE_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_FORCE_HALT_COMPLETE_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_FORCE_HALT_COMPLETE_IRQ_FORCE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_FORCE_HALT_COMPLETE_IRQ_FORCE_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_FORCE_DISABLE_COMPLETE_IRQ_FORCE_MASK 0x2
#define  CORE_PLL_CSSCG_IRQ_FORCE_DISABLE_COMPLETE_IRQ_FORCE_SHIFT 1
#define  CORE_PLL_CSSCG_IRQ_FORCE_DISABLE_COMPLETE_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_FORCE_DISABLE_COMPLETE_IRQ_FORCE_MASK) >> CORE_PLL_CSSCG_IRQ_FORCE_DISABLE_COMPLETE_IRQ_FORCE_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_FORCE_DISABLE_COMPLETE_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_FORCE_DISABLE_COMPLETE_IRQ_FORCE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_FORCE_DISABLE_COMPLETE_IRQ_FORCE_SHIFT))

#define  CORE_PLL_CSSCG_IRQ_FORCE_CYCLE_START_IRQ_FORCE_MASK 0x1
#define  CORE_PLL_CSSCG_IRQ_FORCE_CYCLE_START_IRQ_FORCE_SHIFT 0
#define  CORE_PLL_CSSCG_IRQ_FORCE_CYCLE_START_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_IRQ_FORCE_CYCLE_START_IRQ_FORCE_MASK) >> CORE_PLL_CSSCG_IRQ_FORCE_CYCLE_START_IRQ_FORCE_SHIFT)
#define  CORE_PLL_CSSCG_IRQ_FORCE_CYCLE_START_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_IRQ_FORCE_CYCLE_START_IRQ_FORCE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_IRQ_FORCE_CYCLE_START_IRQ_FORCE_SHIFT))

//====================================================================
//Register: CSSCG Mode Configuration Register (MODE_CONFIG)
/** \brief This register configures the CSSCG modes of operation.*/
//====================================================================

#define  CORE_PLL_CSSCG_MODE_CONFIG_SOFT_RESET_MASK 0x80000000
#define  CORE_PLL_CSSCG_MODE_CONFIG_SOFT_RESET_SHIFT 31
#define  CORE_PLL_CSSCG_MODE_CONFIG_SOFT_RESET_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_MODE_CONFIG_SOFT_RESET_MASK) >> CORE_PLL_CSSCG_MODE_CONFIG_SOFT_RESET_SHIFT)
#define  CORE_PLL_CSSCG_MODE_CONFIG_SOFT_RESET_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_MODE_CONFIG_SOFT_RESET_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_MODE_CONFIG_SOFT_RESET_SHIFT))

#define  CORE_PLL_CSSCG_MODE_CONFIG_RESERVED1_MASK 0x40000000
#define  CORE_PLL_CSSCG_MODE_CONFIG_RESERVED1_SHIFT 30
#define  CORE_PLL_CSSCG_MODE_CONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_MODE_CONFIG_RESERVED1_MASK) >> CORE_PLL_CSSCG_MODE_CONFIG_RESERVED1_SHIFT)
#define  CORE_PLL_CSSCG_MODE_CONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_MODE_CONFIG_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_MODE_CONFIG_RESERVED1_SHIFT))

#define  CORE_PLL_CSSCG_MODE_CONFIG_MAX_ADDR_MASK 0x3f000000
#define  CORE_PLL_CSSCG_MODE_CONFIG_MAX_ADDR_SHIFT 24
#define  CORE_PLL_CSSCG_MODE_CONFIG_MAX_ADDR_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_MODE_CONFIG_MAX_ADDR_MASK) >> CORE_PLL_CSSCG_MODE_CONFIG_MAX_ADDR_SHIFT)
#define  CORE_PLL_CSSCG_MODE_CONFIG_MAX_ADDR_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_MODE_CONFIG_MAX_ADDR_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_MODE_CONFIG_MAX_ADDR_SHIFT))

#define  CORE_PLL_CSSCG_MODE_CONFIG_RESERVED2_MASK 0xc00000
#define  CORE_PLL_CSSCG_MODE_CONFIG_RESERVED2_SHIFT 22
#define  CORE_PLL_CSSCG_MODE_CONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_MODE_CONFIG_RESERVED2_MASK) >> CORE_PLL_CSSCG_MODE_CONFIG_RESERVED2_SHIFT)
#define  CORE_PLL_CSSCG_MODE_CONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_MODE_CONFIG_RESERVED2_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_MODE_CONFIG_RESERVED2_SHIFT))

#define  CORE_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_TYPE_MASK 0x200000
#define  CORE_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_TYPE_SHIFT 21
#define  CORE_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_TYPE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_TYPE_MASK) >> CORE_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_TYPE_SHIFT)
#define  CORE_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_TYPE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_TYPE_SHIFT))

#define  CORE_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_EN_MASK 0x100000
#define  CORE_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_EN_SHIFT 20
#define  CORE_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_EN_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_EN_MASK) >> CORE_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_EN_SHIFT)
#define  CORE_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_EN_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_EN_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_EN_SHIFT))

#define  CORE_PLL_CSSCG_MODE_CONFIG_INTERP_POINTS_MASK 0xff000
#define  CORE_PLL_CSSCG_MODE_CONFIG_INTERP_POINTS_SHIFT 12
#define  CORE_PLL_CSSCG_MODE_CONFIG_INTERP_POINTS_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_MODE_CONFIG_INTERP_POINTS_MASK) >> CORE_PLL_CSSCG_MODE_CONFIG_INTERP_POINTS_SHIFT)
#define  CORE_PLL_CSSCG_MODE_CONFIG_INTERP_POINTS_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_MODE_CONFIG_INTERP_POINTS_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_MODE_CONFIG_INTERP_POINTS_SHIFT))

#define  CORE_PLL_CSSCG_MODE_CONFIG_RESERVED3_MASK 0xe00
#define  CORE_PLL_CSSCG_MODE_CONFIG_RESERVED3_SHIFT 9
#define  CORE_PLL_CSSCG_MODE_CONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_MODE_CONFIG_RESERVED3_MASK) >> CORE_PLL_CSSCG_MODE_CONFIG_RESERVED3_SHIFT)
#define  CORE_PLL_CSSCG_MODE_CONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_MODE_CONFIG_RESERVED3_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_MODE_CONFIG_RESERVED3_SHIFT))

#define  CORE_PLL_CSSCG_MODE_CONFIG_RATE_DIV_M1_MASK 0x1f0
#define  CORE_PLL_CSSCG_MODE_CONFIG_RATE_DIV_M1_SHIFT 4
#define  CORE_PLL_CSSCG_MODE_CONFIG_RATE_DIV_M1_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_MODE_CONFIG_RATE_DIV_M1_MASK) >> CORE_PLL_CSSCG_MODE_CONFIG_RATE_DIV_M1_SHIFT)
#define  CORE_PLL_CSSCG_MODE_CONFIG_RATE_DIV_M1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_MODE_CONFIG_RATE_DIV_M1_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_MODE_CONFIG_RATE_DIV_M1_SHIFT))

#define  CORE_PLL_CSSCG_MODE_CONFIG_RESERVED4_MASK 0x8
#define  CORE_PLL_CSSCG_MODE_CONFIG_RESERVED4_SHIFT 3
#define  CORE_PLL_CSSCG_MODE_CONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_MODE_CONFIG_RESERVED4_MASK) >> CORE_PLL_CSSCG_MODE_CONFIG_RESERVED4_SHIFT)
#define  CORE_PLL_CSSCG_MODE_CONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_MODE_CONFIG_RESERVED4_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_MODE_CONFIG_RESERVED4_SHIFT))

#define  CORE_PLL_CSSCG_MODE_CONFIG_SLV_SYNC_MODE_MASK 0x4
#define  CORE_PLL_CSSCG_MODE_CONFIG_SLV_SYNC_MODE_SHIFT 2
#define  CORE_PLL_CSSCG_MODE_CONFIG_SLV_SYNC_MODE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_MODE_CONFIG_SLV_SYNC_MODE_MASK) >> CORE_PLL_CSSCG_MODE_CONFIG_SLV_SYNC_MODE_SHIFT)
#define  CORE_PLL_CSSCG_MODE_CONFIG_SLV_SYNC_MODE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_MODE_CONFIG_SLV_SYNC_MODE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_MODE_CONFIG_SLV_SYNC_MODE_SHIFT))

#define  CORE_PLL_CSSCG_MODE_CONFIG_APPLY_CORRECTION_MASK 0x2
#define  CORE_PLL_CSSCG_MODE_CONFIG_APPLY_CORRECTION_SHIFT 1
#define  CORE_PLL_CSSCG_MODE_CONFIG_APPLY_CORRECTION_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_MODE_CONFIG_APPLY_CORRECTION_MASK) >> CORE_PLL_CSSCG_MODE_CONFIG_APPLY_CORRECTION_SHIFT)
#define  CORE_PLL_CSSCG_MODE_CONFIG_APPLY_CORRECTION_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_MODE_CONFIG_APPLY_CORRECTION_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_MODE_CONFIG_APPLY_CORRECTION_SHIFT))

#define  CORE_PLL_CSSCG_MODE_CONFIG_DOWN_SPREAD_MASK 0x1
#define  CORE_PLL_CSSCG_MODE_CONFIG_DOWN_SPREAD_SHIFT 0
#define  CORE_PLL_CSSCG_MODE_CONFIG_DOWN_SPREAD_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_MODE_CONFIG_DOWN_SPREAD_MASK) >> CORE_PLL_CSSCG_MODE_CONFIG_DOWN_SPREAD_SHIFT)
#define  CORE_PLL_CSSCG_MODE_CONFIG_DOWN_SPREAD_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_MODE_CONFIG_DOWN_SPREAD_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_MODE_CONFIG_DOWN_SPREAD_SHIFT))

//====================================================================
//Register: CSSCG Halt Configuration Register (HALT_CONFIG)
/** \brief This register defines the place on the dither curve where the block will stop upon a halt request. Note that the block will continue to send offset codes to the PLL*/
//====================================================================

#define  CORE_PLL_CSSCG_HALT_CONFIG_RESERVED1_MASK 0xfffc0000
#define  CORE_PLL_CSSCG_HALT_CONFIG_RESERVED1_SHIFT 18
#define  CORE_PLL_CSSCG_HALT_CONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_HALT_CONFIG_RESERVED1_MASK) >> CORE_PLL_CSSCG_HALT_CONFIG_RESERVED1_SHIFT)
#define  CORE_PLL_CSSCG_HALT_CONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_HALT_CONFIG_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_HALT_CONFIG_RESERVED1_SHIFT))

#define  CORE_PLL_CSSCG_HALT_CONFIG_HALT_PHASE_MASK 0x30000
#define  CORE_PLL_CSSCG_HALT_CONFIG_HALT_PHASE_SHIFT 16
#define  CORE_PLL_CSSCG_HALT_CONFIG_HALT_PHASE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_HALT_CONFIG_HALT_PHASE_MASK) >> CORE_PLL_CSSCG_HALT_CONFIG_HALT_PHASE_SHIFT)
#define  CORE_PLL_CSSCG_HALT_CONFIG_HALT_PHASE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_HALT_CONFIG_HALT_PHASE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_HALT_CONFIG_HALT_PHASE_SHIFT))

#define  CORE_PLL_CSSCG_HALT_CONFIG_RESERVED2_MASK 0xffc0
#define  CORE_PLL_CSSCG_HALT_CONFIG_RESERVED2_SHIFT 6
#define  CORE_PLL_CSSCG_HALT_CONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_HALT_CONFIG_RESERVED2_MASK) >> CORE_PLL_CSSCG_HALT_CONFIG_RESERVED2_SHIFT)
#define  CORE_PLL_CSSCG_HALT_CONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_HALT_CONFIG_RESERVED2_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_HALT_CONFIG_RESERVED2_SHIFT))

#define  CORE_PLL_CSSCG_HALT_CONFIG_HALT_ADDR_MASK 0x3f
#define  CORE_PLL_CSSCG_HALT_CONFIG_HALT_ADDR_SHIFT 0
#define  CORE_PLL_CSSCG_HALT_CONFIG_HALT_ADDR_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_HALT_CONFIG_HALT_ADDR_MASK) >> CORE_PLL_CSSCG_HALT_CONFIG_HALT_ADDR_SHIFT)
#define  CORE_PLL_CSSCG_HALT_CONFIG_HALT_ADDR_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_HALT_CONFIG_HALT_ADDR_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_HALT_CONFIG_HALT_ADDR_SHIFT))

//====================================================================
//Register: CSSCG Sign Bit Override Register (SB_OVER)
/** \brief This register is used to override the sign bit to the PLL.*/
//====================================================================

#define  CORE_PLL_CSSCG_SB_OVER_RESERVED1_MASK 0xfffffffe
#define  CORE_PLL_CSSCG_SB_OVER_RESERVED1_SHIFT 1
#define  CORE_PLL_CSSCG_SB_OVER_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_SB_OVER_RESERVED1_MASK) >> CORE_PLL_CSSCG_SB_OVER_RESERVED1_SHIFT)
#define  CORE_PLL_CSSCG_SB_OVER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_SB_OVER_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_SB_OVER_RESERVED1_SHIFT))

#define  CORE_PLL_CSSCG_SB_OVER_SB_OVERRIDE_MASK 0x1
#define  CORE_PLL_CSSCG_SB_OVER_SB_OVERRIDE_SHIFT 0
#define  CORE_PLL_CSSCG_SB_OVER_SB_OVERRIDE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_SB_OVER_SB_OVERRIDE_MASK) >> CORE_PLL_CSSCG_SB_OVER_SB_OVERRIDE_SHIFT)
#define  CORE_PLL_CSSCG_SB_OVER_SB_OVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_SB_OVER_SB_OVERRIDE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_SB_OVER_SB_OVERRIDE_SHIFT))

//====================================================================
//Register: CSSCG Control Register (CONTROL)
/** \brief This register is used to start/stop the CSSCG block.*/
//====================================================================

#define  CORE_PLL_CSSCG_CONTROL_RESERVED1_MASK 0xfffffff8
#define  CORE_PLL_CSSCG_CONTROL_RESERVED1_SHIFT 3
#define  CORE_PLL_CSSCG_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_CONTROL_RESERVED1_MASK) >> CORE_PLL_CSSCG_CONTROL_RESERVED1_SHIFT)
#define  CORE_PLL_CSSCG_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_CONTROL_RESERVED1_SHIFT))

#define  CORE_PLL_CSSCG_CONTROL_CSSCG_EXTERNAL_MUX_SEL_MASK 0x4
#define  CORE_PLL_CSSCG_CONTROL_CSSCG_EXTERNAL_MUX_SEL_SHIFT 2
#define  CORE_PLL_CSSCG_CONTROL_CSSCG_EXTERNAL_MUX_SEL_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_CONTROL_CSSCG_EXTERNAL_MUX_SEL_MASK) >> CORE_PLL_CSSCG_CONTROL_CSSCG_EXTERNAL_MUX_SEL_SHIFT)
#define  CORE_PLL_CSSCG_CONTROL_CSSCG_EXTERNAL_MUX_SEL_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_CONTROL_CSSCG_EXTERNAL_MUX_SEL_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_CONTROL_CSSCG_EXTERNAL_MUX_SEL_SHIFT))

#define  CORE_PLL_CSSCG_CONTROL_HALT_EN_MASK 0x2
#define  CORE_PLL_CSSCG_CONTROL_HALT_EN_SHIFT 1
#define  CORE_PLL_CSSCG_CONTROL_HALT_EN_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_CONTROL_HALT_EN_MASK) >> CORE_PLL_CSSCG_CONTROL_HALT_EN_SHIFT)
#define  CORE_PLL_CSSCG_CONTROL_HALT_EN_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_CONTROL_HALT_EN_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_CONTROL_HALT_EN_SHIFT))

#define  CORE_PLL_CSSCG_CONTROL_CSSCG_ENABLE_MASK 0x1
#define  CORE_PLL_CSSCG_CONTROL_CSSCG_ENABLE_SHIFT 0
#define  CORE_PLL_CSSCG_CONTROL_CSSCG_ENABLE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_CONTROL_CSSCG_ENABLE_MASK) >> CORE_PLL_CSSCG_CONTROL_CSSCG_ENABLE_SHIFT)
#define  CORE_PLL_CSSCG_CONTROL_CSSCG_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_CONTROL_CSSCG_ENABLE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_CONTROL_CSSCG_ENABLE_SHIFT))

//====================================================================
//Register: CSSCG Master Sync Status Register (STATUS_MST_SYNC)
/** \brief This register provides the internal status of the block when in Master Sync Mode. It can be used to determine when a halt has completed. It can also be used for debug purposes.*/
//====================================================================

#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_RESERVED1_MASK 0x80000000
#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_RESERVED1_SHIFT 31
#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_STATUS_MST_SYNC_RESERVED1_MASK) >> CORE_PLL_CSSCG_STATUS_MST_SYNC_RESERVED1_SHIFT)
#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_STATUS_MST_SYNC_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_STATUS_MST_SYNC_RESERVED1_SHIFT))

#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_MST_STATE_MASK 0x70000000
#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_MST_STATE_SHIFT 28
#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_MST_STATE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_STATUS_MST_SYNC_MST_STATE_MASK) >> CORE_PLL_CSSCG_STATUS_MST_SYNC_MST_STATE_SHIFT)
#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_MST_STATE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_STATUS_MST_SYNC_MST_STATE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_STATUS_MST_SYNC_MST_STATE_SHIFT))

#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_RESERVED2_MASK 0xffffc00
#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_RESERVED2_SHIFT 10
#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_RESERVED2_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_STATUS_MST_SYNC_RESERVED2_MASK) >> CORE_PLL_CSSCG_STATUS_MST_SYNC_RESERVED2_SHIFT)
#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_STATUS_MST_SYNC_RESERVED2_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_STATUS_MST_SYNC_RESERVED2_SHIFT))

#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_CURRENT_ADDR_MASK 0x3f0
#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_CURRENT_ADDR_SHIFT 4
#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_CURRENT_ADDR_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_STATUS_MST_SYNC_CURRENT_ADDR_MASK) >> CORE_PLL_CSSCG_STATUS_MST_SYNC_CURRENT_ADDR_SHIFT)
#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_CURRENT_ADDR_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_STATUS_MST_SYNC_CURRENT_ADDR_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_STATUS_MST_SYNC_CURRENT_ADDR_SHIFT))

#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_RESERVED3_MASK 0xc
#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_RESERVED3_SHIFT 2
#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_RESERVED3_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_STATUS_MST_SYNC_RESERVED3_MASK) >> CORE_PLL_CSSCG_STATUS_MST_SYNC_RESERVED3_SHIFT)
#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_STATUS_MST_SYNC_RESERVED3_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_STATUS_MST_SYNC_RESERVED3_SHIFT))

#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_HALTED_MASK 0x2
#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_HALTED_SHIFT 1
#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_HALTED_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_STATUS_MST_SYNC_HALTED_MASK) >> CORE_PLL_CSSCG_STATUS_MST_SYNC_HALTED_SHIFT)
#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_HALTED_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_STATUS_MST_SYNC_HALTED_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_STATUS_MST_SYNC_HALTED_SHIFT))

#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_ACTIVE_MASK 0x1
#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_ACTIVE_SHIFT 0
#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_ACTIVE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_STATUS_MST_SYNC_ACTIVE_MASK) >> CORE_PLL_CSSCG_STATUS_MST_SYNC_ACTIVE_SHIFT)
#define  CORE_PLL_CSSCG_STATUS_MST_SYNC_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_STATUS_MST_SYNC_ACTIVE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_STATUS_MST_SYNC_ACTIVE_SHIFT))

//====================================================================
//Register: CSSCG Slave Sync Status Register 0 (STATUS_SLV_SYNC_0)
/** \brief This register provides the internal status of the block when in Slave Sync Mode. It can be used to determine when a halt has completed. It can also be used for debug purposes.*/
//====================================================================

#define  CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED1_MASK 0xfffc0000
#define  CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED1_SHIFT 18
#define  CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED1_MASK) >> CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED1_SHIFT)
#define  CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED1_SHIFT))

#define  CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_CURRENT_ADDR_MASK 0x3f000
#define  CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_CURRENT_ADDR_SHIFT 12
#define  CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_CURRENT_ADDR_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_CURRENT_ADDR_MASK) >> CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_CURRENT_ADDR_SHIFT)
#define  CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_CURRENT_ADDR_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_CURRENT_ADDR_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_CURRENT_ADDR_SHIFT))

#define  CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED2_MASK 0xf80
#define  CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED2_SHIFT 7
#define  CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED2_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED2_MASK) >> CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED2_SHIFT)
#define  CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED2_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED2_SHIFT))

#define  CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_SLV_STATE_MASK 0x7c
#define  CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_SLV_STATE_SHIFT 2
#define  CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_SLV_STATE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_SLV_STATE_MASK) >> CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_SLV_STATE_SHIFT)
#define  CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_SLV_STATE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_SLV_STATE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_SLV_STATE_SHIFT))

#define  CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_HALTED_MASK 0x2
#define  CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_HALTED_SHIFT 1
#define  CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_HALTED_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_HALTED_MASK) >> CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_HALTED_SHIFT)
#define  CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_HALTED_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_HALTED_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_HALTED_SHIFT))

#define  CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_ACTIVE_MASK 0x1
#define  CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_ACTIVE_SHIFT 0
#define  CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_ACTIVE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_ACTIVE_MASK) >> CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_ACTIVE_SHIFT)
#define  CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_ACTIVE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_STATUS_SLV_SYNC_0_ACTIVE_SHIFT))

//====================================================================
//Register: CSSCG Code Status (STATUS_CODE)
/** \brief This register provides the status of current code being sent to the PLL. Used in both master and slave sync mode debug.*/
//====================================================================

#define  CORE_PLL_CSSCG_STATUS_CODE_NEWCODE_UPDATE_MASK 0x80000000
#define  CORE_PLL_CSSCG_STATUS_CODE_NEWCODE_UPDATE_SHIFT 31
#define  CORE_PLL_CSSCG_STATUS_CODE_NEWCODE_UPDATE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_STATUS_CODE_NEWCODE_UPDATE_MASK) >> CORE_PLL_CSSCG_STATUS_CODE_NEWCODE_UPDATE_SHIFT)
#define  CORE_PLL_CSSCG_STATUS_CODE_NEWCODE_UPDATE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_STATUS_CODE_NEWCODE_UPDATE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_STATUS_CODE_NEWCODE_UPDATE_SHIFT))

#define  CORE_PLL_CSSCG_STATUS_CODE_RESERVED1_MASK 0x7ffe0000
#define  CORE_PLL_CSSCG_STATUS_CODE_RESERVED1_SHIFT 17
#define  CORE_PLL_CSSCG_STATUS_CODE_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_STATUS_CODE_RESERVED1_MASK) >> CORE_PLL_CSSCG_STATUS_CODE_RESERVED1_SHIFT)
#define  CORE_PLL_CSSCG_STATUS_CODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_STATUS_CODE_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_STATUS_CODE_RESERVED1_SHIFT))

#define  CORE_PLL_CSSCG_STATUS_CODE_NEWCODE_MASK 0x1ffff
#define  CORE_PLL_CSSCG_STATUS_CODE_NEWCODE_SHIFT 0
#define  CORE_PLL_CSSCG_STATUS_CODE_NEWCODE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_STATUS_CODE_NEWCODE_MASK) >> CORE_PLL_CSSCG_STATUS_CODE_NEWCODE_SHIFT)
#define  CORE_PLL_CSSCG_STATUS_CODE_NEWCODE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_STATUS_CODE_NEWCODE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_STATUS_CODE_NEWCODE_SHIFT))

//====================================================================
//Register: CSSCG Config A Slave Mode Full Cycle Count Config (SLV_N_FULL_A)
/** \brief This register defines how many full cycles the CSSCG will perform in slave sync mode for configuration A.*/
//====================================================================

#define  CORE_PLL_CSSCG_SLV_N_FULL_A_SLV_N_FULL_MASK 0xffffffff
#define  CORE_PLL_CSSCG_SLV_N_FULL_A_SLV_N_FULL_SHIFT 0
#define  CORE_PLL_CSSCG_SLV_N_FULL_A_SLV_N_FULL_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_SLV_N_FULL_A_SLV_N_FULL_MASK) >> CORE_PLL_CSSCG_SLV_N_FULL_A_SLV_N_FULL_SHIFT)
#define  CORE_PLL_CSSCG_SLV_N_FULL_A_SLV_N_FULL_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_SLV_N_FULL_A_SLV_N_FULL_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_SLV_N_FULL_A_SLV_N_FULL_SHIFT))

//====================================================================
//Register: CSSCG Config A Slave Mode End Configuration Register (SLV_END_CONFIG_A)
/** \brief This register defines the phase and table entry upon which it will halt the "partial phase"
      after all of the full phases for configuration A.*/
//====================================================================

#define  CORE_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED1_MASK 0xfffc0000
#define  CORE_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED1_SHIFT 18
#define  CORE_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED1_MASK) >> CORE_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED1_SHIFT)
#define  CORE_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED1_SHIFT))

#define  CORE_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_PHASE_MASK 0x30000
#define  CORE_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_PHASE_SHIFT 16
#define  CORE_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_PHASE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_PHASE_MASK) >> CORE_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_PHASE_SHIFT)
#define  CORE_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_PHASE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_PHASE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_PHASE_SHIFT))

#define  CORE_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED2_MASK 0xffc0
#define  CORE_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED2_SHIFT 6
#define  CORE_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED2_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED2_MASK) >> CORE_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED2_SHIFT)
#define  CORE_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED2_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED2_SHIFT))

#define  CORE_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_ADDR_MASK 0x3f
#define  CORE_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_ADDR_SHIFT 0
#define  CORE_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_ADDR_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_ADDR_MASK) >> CORE_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_ADDR_SHIFT)
#define  CORE_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_ADDR_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_ADDR_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_ADDR_SHIFT))

//====================================================================
//Register: CSSCG Config A Slave Mode Return-to-Zero Register (SLV_RTZ_A)
/** \brief This register controls how the block will linearly return-to-zero
      after the partial phase for configuration A.*/
//====================================================================

#define  CORE_PLL_CSSCG_SLV_RTZ_A_RESERVED1_MASK 0xffff0000
#define  CORE_PLL_CSSCG_SLV_RTZ_A_RESERVED1_SHIFT 16
#define  CORE_PLL_CSSCG_SLV_RTZ_A_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_SLV_RTZ_A_RESERVED1_MASK) >> CORE_PLL_CSSCG_SLV_RTZ_A_RESERVED1_SHIFT)
#define  CORE_PLL_CSSCG_SLV_RTZ_A_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_SLV_RTZ_A_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_SLV_RTZ_A_RESERVED1_SHIFT))

#define  CORE_PLL_CSSCG_SLV_RTZ_A_RTZ_STEP_SIZE_MASK 0xffff
#define  CORE_PLL_CSSCG_SLV_RTZ_A_RTZ_STEP_SIZE_SHIFT 0
#define  CORE_PLL_CSSCG_SLV_RTZ_A_RTZ_STEP_SIZE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_SLV_RTZ_A_RTZ_STEP_SIZE_MASK) >> CORE_PLL_CSSCG_SLV_RTZ_A_RTZ_STEP_SIZE_SHIFT)
#define  CORE_PLL_CSSCG_SLV_RTZ_A_RTZ_STEP_SIZE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_SLV_RTZ_A_RTZ_STEP_SIZE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_SLV_RTZ_A_RTZ_STEP_SIZE_SHIFT))

//====================================================================
//Register: CSSCG Config B Slave Mode Full Cycle Count Config (SLV_N_FULL_B)
/** \brief This register defines how many full cycles the CSSCG will perform in slave sync mode for configuration B.*/
//====================================================================

#define  CORE_PLL_CSSCG_SLV_N_FULL_B_SLV_N_FULL_MASK 0xffffffff
#define  CORE_PLL_CSSCG_SLV_N_FULL_B_SLV_N_FULL_SHIFT 0
#define  CORE_PLL_CSSCG_SLV_N_FULL_B_SLV_N_FULL_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_SLV_N_FULL_B_SLV_N_FULL_MASK) >> CORE_PLL_CSSCG_SLV_N_FULL_B_SLV_N_FULL_SHIFT)
#define  CORE_PLL_CSSCG_SLV_N_FULL_B_SLV_N_FULL_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_SLV_N_FULL_B_SLV_N_FULL_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_SLV_N_FULL_B_SLV_N_FULL_SHIFT))

//====================================================================
//Register: CSSCG Config B Slave Mode End Configuration Register (SLV_END_CONFIG_B)
/** \brief This register defines the phase and table entry upon which it will halt the "partial phase"
      after all of the full phases for configuration B.*/
//====================================================================

#define  CORE_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED1_MASK 0xfffc0000
#define  CORE_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED1_SHIFT 18
#define  CORE_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED1_MASK) >> CORE_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED1_SHIFT)
#define  CORE_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED1_SHIFT))

#define  CORE_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_PHASE_MASK 0x30000
#define  CORE_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_PHASE_SHIFT 16
#define  CORE_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_PHASE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_PHASE_MASK) >> CORE_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_PHASE_SHIFT)
#define  CORE_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_PHASE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_PHASE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_PHASE_SHIFT))

#define  CORE_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED2_MASK 0xffc0
#define  CORE_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED2_SHIFT 6
#define  CORE_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED2_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED2_MASK) >> CORE_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED2_SHIFT)
#define  CORE_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED2_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED2_SHIFT))

#define  CORE_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_ADDR_MASK 0x3f
#define  CORE_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_ADDR_SHIFT 0
#define  CORE_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_ADDR_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_ADDR_MASK) >> CORE_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_ADDR_SHIFT)
#define  CORE_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_ADDR_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_ADDR_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_ADDR_SHIFT))

//====================================================================
//Register: CSSCG Config B Slave Mode Return-to-Zero Register (SLV_RTZ_B)
/** \brief This register controls how the block will linearly return-to-zero
      after the partial phase for configuration B.*/
//====================================================================

#define  CORE_PLL_CSSCG_SLV_RTZ_B_RESERVED1_MASK 0xffff0000
#define  CORE_PLL_CSSCG_SLV_RTZ_B_RESERVED1_SHIFT 16
#define  CORE_PLL_CSSCG_SLV_RTZ_B_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_SLV_RTZ_B_RESERVED1_MASK) >> CORE_PLL_CSSCG_SLV_RTZ_B_RESERVED1_SHIFT)
#define  CORE_PLL_CSSCG_SLV_RTZ_B_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_SLV_RTZ_B_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_SLV_RTZ_B_RESERVED1_SHIFT))

#define  CORE_PLL_CSSCG_SLV_RTZ_B_RTZ_STEP_SIZE_MASK 0xffff
#define  CORE_PLL_CSSCG_SLV_RTZ_B_RTZ_STEP_SIZE_SHIFT 0
#define  CORE_PLL_CSSCG_SLV_RTZ_B_RTZ_STEP_SIZE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_SLV_RTZ_B_RTZ_STEP_SIZE_MASK) >> CORE_PLL_CSSCG_SLV_RTZ_B_RTZ_STEP_SIZE_SHIFT)
#define  CORE_PLL_CSSCG_SLV_RTZ_B_RTZ_STEP_SIZE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_SLV_RTZ_B_RTZ_STEP_SIZE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_SLV_RTZ_B_RTZ_STEP_SIZE_SHIFT))

//====================================================================
//Register: CSSCG Slave Mode Trigger Select Register (SLV_TRIG_SEL)
/** \brief This register selects and optionally inverts the input trigger.*/
//====================================================================

#define  CORE_PLL_CSSCG_SLV_TRIG_SEL_TRIG_INV_MASK 0xffff0000
#define  CORE_PLL_CSSCG_SLV_TRIG_SEL_TRIG_INV_SHIFT 16
#define  CORE_PLL_CSSCG_SLV_TRIG_SEL_TRIG_INV_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_SLV_TRIG_SEL_TRIG_INV_MASK) >> CORE_PLL_CSSCG_SLV_TRIG_SEL_TRIG_INV_SHIFT)
#define  CORE_PLL_CSSCG_SLV_TRIG_SEL_TRIG_INV_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_SLV_TRIG_SEL_TRIG_INV_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_SLV_TRIG_SEL_TRIG_INV_SHIFT))

#define  CORE_PLL_CSSCG_SLV_TRIG_SEL_TRIG_MASK_MASK 0xffff
#define  CORE_PLL_CSSCG_SLV_TRIG_SEL_TRIG_MASK_SHIFT 0
#define  CORE_PLL_CSSCG_SLV_TRIG_SEL_TRIG_MASK_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_SLV_TRIG_SEL_TRIG_MASK_MASK) >> CORE_PLL_CSSCG_SLV_TRIG_SEL_TRIG_MASK_SHIFT)
#define  CORE_PLL_CSSCG_SLV_TRIG_SEL_TRIG_MASK_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_SLV_TRIG_SEL_TRIG_MASK_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_SLV_TRIG_SEL_TRIG_MASK_SHIFT))

//====================================================================
//Register: CSSCG Slave Mode Timeout Register (SLV_TIMEOUT)
/** \brief This register controls how long the block will wait after a standard line prior to going into initial sync phase again. Note: These clock ticks are defined as the number divided-down VCO_DIV_CLK clocks (where the divide is programmed by rate_div_m1).*/
//====================================================================

#define  CORE_PLL_CSSCG_SLV_TIMEOUT_TIMEOUT_MASK 0xffffffff
#define  CORE_PLL_CSSCG_SLV_TIMEOUT_TIMEOUT_SHIFT 0
#define  CORE_PLL_CSSCG_SLV_TIMEOUT_TIMEOUT_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_SLV_TIMEOUT_TIMEOUT_MASK) >> CORE_PLL_CSSCG_SLV_TIMEOUT_TIMEOUT_SHIFT)
#define  CORE_PLL_CSSCG_SLV_TIMEOUT_TIMEOUT_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_SLV_TIMEOUT_TIMEOUT_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_SLV_TIMEOUT_TIMEOUT_SHIFT))

//====================================================================
//Register: CSSCG Slave Mode Debug 0 Register (SLV_DEBUG_0)
/** \brief This register is used to help debug Slave Sync mode.*/
//====================================================================

#define  CORE_PLL_CSSCG_SLV_DEBUG_0_RESERVED1_MASK 0xfffffffc
#define  CORE_PLL_CSSCG_SLV_DEBUG_0_RESERVED1_SHIFT 2
#define  CORE_PLL_CSSCG_SLV_DEBUG_0_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_SLV_DEBUG_0_RESERVED1_MASK) >> CORE_PLL_CSSCG_SLV_DEBUG_0_RESERVED1_SHIFT)
#define  CORE_PLL_CSSCG_SLV_DEBUG_0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_SLV_DEBUG_0_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_SLV_DEBUG_0_RESERVED1_SHIFT))

#define  CORE_PLL_CSSCG_SLV_DEBUG_0_SLV_SYNC_DEBUG_MODE_MASK 0x3
#define  CORE_PLL_CSSCG_SLV_DEBUG_0_SLV_SYNC_DEBUG_MODE_SHIFT 0
#define  CORE_PLL_CSSCG_SLV_DEBUG_0_SLV_SYNC_DEBUG_MODE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_SLV_DEBUG_0_SLV_SYNC_DEBUG_MODE_MASK) >> CORE_PLL_CSSCG_SLV_DEBUG_0_SLV_SYNC_DEBUG_MODE_SHIFT)
#define  CORE_PLL_CSSCG_SLV_DEBUG_0_SLV_SYNC_DEBUG_MODE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_SLV_DEBUG_0_SLV_SYNC_DEBUG_MODE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_SLV_DEBUG_0_SLV_SYNC_DEBUG_MODE_SHIFT))

//====================================================================
//Register: CSSCG Slave Mode Debug 1 Register (SLV_DEBUG_1)
/** \brief This register is used to help debug Slave Sync mode.*/
//====================================================================

#define  CORE_PLL_CSSCG_SLV_DEBUG_1_RESERVED1_MASK 0xfffffffe
#define  CORE_PLL_CSSCG_SLV_DEBUG_1_RESERVED1_SHIFT 1
#define  CORE_PLL_CSSCG_SLV_DEBUG_1_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_SLV_DEBUG_1_RESERVED1_MASK) >> CORE_PLL_CSSCG_SLV_DEBUG_1_RESERVED1_SHIFT)
#define  CORE_PLL_CSSCG_SLV_DEBUG_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_SLV_DEBUG_1_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_SLV_DEBUG_1_RESERVED1_SHIFT))

#define  CORE_PLL_CSSCG_SLV_DEBUG_1_TRIG_FORCE_MASK 0x1
#define  CORE_PLL_CSSCG_SLV_DEBUG_1_TRIG_FORCE_SHIFT 0
#define  CORE_PLL_CSSCG_SLV_DEBUG_1_TRIG_FORCE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_SLV_DEBUG_1_TRIG_FORCE_MASK) >> CORE_PLL_CSSCG_SLV_DEBUG_1_TRIG_FORCE_SHIFT)
#define  CORE_PLL_CSSCG_SLV_DEBUG_1_TRIG_FORCE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_SLV_DEBUG_1_TRIG_FORCE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_SLV_DEBUG_1_TRIG_FORCE_SHIFT))

//====================================================================
//Register: CSSCG Trigger Debug 0 Register (TRIG_DEBUG_0)
/** \brief This register is used to help debug Slave Sync mode trigger timing. Use this register to clear the other Trigger Debug registers.*/
//====================================================================

#define  CORE_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_RESET_MASK 0x80000000
#define  CORE_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_RESET_SHIFT 31
#define  CORE_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_RESET_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_RESET_MASK) >> CORE_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_RESET_SHIFT)
#define  CORE_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_RESET_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_RESET_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_RESET_SHIFT))

#define  CORE_PLL_CSSCG_TRIG_DEBUG_0_RESERVED1_MASK 0x7ffffffc
#define  CORE_PLL_CSSCG_TRIG_DEBUG_0_RESERVED1_SHIFT 2
#define  CORE_PLL_CSSCG_TRIG_DEBUG_0_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_TRIG_DEBUG_0_RESERVED1_MASK) >> CORE_PLL_CSSCG_TRIG_DEBUG_0_RESERVED1_SHIFT)
#define  CORE_PLL_CSSCG_TRIG_DEBUG_0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_TRIG_DEBUG_0_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_TRIG_DEBUG_0_RESERVED1_SHIFT))

#define  CORE_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_FREERUN_MASK 0x2
#define  CORE_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_FREERUN_SHIFT 1
#define  CORE_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_FREERUN_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_FREERUN_MASK) >> CORE_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_FREERUN_SHIFT)
#define  CORE_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_FREERUN_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_FREERUN_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_FREERUN_SHIFT))

#define  CORE_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_ENABLE_MASK 0x1
#define  CORE_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_ENABLE_SHIFT 0
#define  CORE_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_ENABLE_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_ENABLE_MASK) >> CORE_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_ENABLE_SHIFT)
#define  CORE_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_ENABLE_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_ENABLE_SHIFT))

//====================================================================
//Register: CSSCG Trigger Debug 1 Register (TRIG_DEBUG_1)
/** \brief This register is used to help debug Slave Sync mode trigger timing. Specifically, this register provides the minimum time seen between triggers (in VCO_DIV_CLK clocks).*/
//====================================================================

#define  CORE_PLL_CSSCG_TRIG_DEBUG_1_TRIG_MIN_PERIOD_MASK 0xffffffff
#define  CORE_PLL_CSSCG_TRIG_DEBUG_1_TRIG_MIN_PERIOD_SHIFT 0
#define  CORE_PLL_CSSCG_TRIG_DEBUG_1_TRIG_MIN_PERIOD_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_TRIG_DEBUG_1_TRIG_MIN_PERIOD_MASK) >> CORE_PLL_CSSCG_TRIG_DEBUG_1_TRIG_MIN_PERIOD_SHIFT)
#define  CORE_PLL_CSSCG_TRIG_DEBUG_1_TRIG_MIN_PERIOD_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_TRIG_DEBUG_1_TRIG_MIN_PERIOD_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_TRIG_DEBUG_1_TRIG_MIN_PERIOD_SHIFT))

//====================================================================
//Register: CSSCG Trigger Debug 2 Register (TRIG_DEBUG_2)
/** \brief This register is used to help debug Slave Sync mode trigger timing. Specifically, this register provides the maximum time seen between triggers (in VCO_DIV_CLK clocks).*/
//====================================================================

#define  CORE_PLL_CSSCG_TRIG_DEBUG_2_TRIG_MAX_PERIOD_MASK 0xffffffff
#define  CORE_PLL_CSSCG_TRIG_DEBUG_2_TRIG_MAX_PERIOD_SHIFT 0
#define  CORE_PLL_CSSCG_TRIG_DEBUG_2_TRIG_MAX_PERIOD_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_TRIG_DEBUG_2_TRIG_MAX_PERIOD_MASK) >> CORE_PLL_CSSCG_TRIG_DEBUG_2_TRIG_MAX_PERIOD_SHIFT)
#define  CORE_PLL_CSSCG_TRIG_DEBUG_2_TRIG_MAX_PERIOD_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_TRIG_DEBUG_2_TRIG_MAX_PERIOD_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_TRIG_DEBUG_2_TRIG_MAX_PERIOD_SHIFT))

//====================================================================
//Register: CSSCG Trigger Debug 3 Register (TRIG_DEBUG_3)
/** \brief This register is used to help debug Slave Sync mode trigger timing. Specifically, this register provides the number of triggers seen (including the first used to synchronize).*/
//====================================================================

#define  CORE_PLL_CSSCG_TRIG_DEBUG_3_TRIG_COUNT_MASK 0xffffffff
#define  CORE_PLL_CSSCG_TRIG_DEBUG_3_TRIG_COUNT_SHIFT 0
#define  CORE_PLL_CSSCG_TRIG_DEBUG_3_TRIG_COUNT_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_TRIG_DEBUG_3_TRIG_COUNT_MASK) >> CORE_PLL_CSSCG_TRIG_DEBUG_3_TRIG_COUNT_SHIFT)
#define  CORE_PLL_CSSCG_TRIG_DEBUG_3_TRIG_COUNT_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_TRIG_DEBUG_3_TRIG_COUNT_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_TRIG_DEBUG_3_TRIG_COUNT_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  CORE_PLL_CSSCG_REV0_MAJ_MASK 0xffff0000
#define  CORE_PLL_CSSCG_REV0_MAJ_SHIFT 16
#define  CORE_PLL_CSSCG_REV0_MAJ_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_REV0_MAJ_MASK) >> CORE_PLL_CSSCG_REV0_MAJ_SHIFT)
#define  CORE_PLL_CSSCG_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_REV0_MAJ_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_REV0_MAJ_SHIFT))

#define  CORE_PLL_CSSCG_REV0_MID_MASK 0xffff
#define  CORE_PLL_CSSCG_REV0_MID_SHIFT 0
#define  CORE_PLL_CSSCG_REV0_MID_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_REV0_MID_MASK) >> CORE_PLL_CSSCG_REV0_MID_SHIFT)
#define  CORE_PLL_CSSCG_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_REV0_MID_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  CORE_PLL_CSSCG_REV1_RESERVED1_MASK 0xffff0000
#define  CORE_PLL_CSSCG_REV1_RESERVED1_SHIFT 16
#define  CORE_PLL_CSSCG_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_REV1_RESERVED1_MASK) >> CORE_PLL_CSSCG_REV1_RESERVED1_SHIFT)
#define  CORE_PLL_CSSCG_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_REV1_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_REV1_RESERVED1_SHIFT))

#define  CORE_PLL_CSSCG_REV1_CFG_MASK 0xffff
#define  CORE_PLL_CSSCG_REV1_CFG_SHIFT 0
#define  CORE_PLL_CSSCG_REV1_CFG_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_REV1_CFG_MASK) >> CORE_PLL_CSSCG_REV1_CFG_SHIFT)
#define  CORE_PLL_CSSCG_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_REV1_CFG_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_REV1_CFG_SHIFT))

//====================================================================
//Register: CSSCG RAM Access Register (CSSCG_RAM)
/** \brief The table used to define the dither shape. The values are unsigned "deltas." Therefore, the curve must be monotonic.*/
//====================================================================

#define  CORE_PLL_CSSCG_CSSCG_RAM_RESERVED1_MASK 0xffff0000
#define  CORE_PLL_CSSCG_CSSCG_RAM_RESERVED1_SHIFT 16
#define  CORE_PLL_CSSCG_CSSCG_RAM_RESERVED1_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_CSSCG_RAM_RESERVED1_MASK) >> CORE_PLL_CSSCG_CSSCG_RAM_RESERVED1_SHIFT)
#define  CORE_PLL_CSSCG_CSSCG_RAM_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_CSSCG_RAM_RESERVED1_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_CSSCG_RAM_RESERVED1_SHIFT))

#define  CORE_PLL_CSSCG_CSSCG_RAM_VAL_MASK 0xffff
#define  CORE_PLL_CSSCG_CSSCG_RAM_VAL_SHIFT 0
#define  CORE_PLL_CSSCG_CSSCG_RAM_VAL_MASK_SHIFT(reg) (((reg) & CORE_PLL_CSSCG_CSSCG_RAM_VAL_MASK) >> CORE_PLL_CSSCG_CSSCG_RAM_VAL_SHIFT)
#define  CORE_PLL_CSSCG_CSSCG_RAM_VAL_REPLACE_VAL(reg,val) (((reg) & ~CORE_PLL_CSSCG_CSSCG_RAM_VAL_MASK) | (((uint32_t)val) << CORE_PLL_CSSCG_CSSCG_RAM_VAL_SHIFT))

//====================================================================
//
//Register File: SCAN PLL Controls (SCAN_PLL)
//
//====================================================================

//====================================================================
//Register: PLL reset & Pre-divider Register (rst_prediv)
/** \brief RESET, 1 = PLL in reset
           0 = PLL in normal mode
    RESET_SSC, 1 = SSC and Freq Offset in reset
               0 = SSC and Freq Offset operating mode
    RESET_PI, 1 = External Interpolator in reset
               0 = operating mode*/
//====================================================================

#define  SCAN_PLL_RST_PREDIV_RESERVED1_MASK 0xfff80000
#define  SCAN_PLL_RST_PREDIV_RESERVED1_SHIFT 19
#define  SCAN_PLL_RST_PREDIV_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_RST_PREDIV_RESERVED1_MASK) >> SCAN_PLL_RST_PREDIV_RESERVED1_SHIFT)
#define  SCAN_PLL_RST_PREDIV_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_RST_PREDIV_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_RST_PREDIV_RESERVED1_SHIFT))

#define  SCAN_PLL_RST_PREDIV_RESET_PI_MASK 0x40000
#define  SCAN_PLL_RST_PREDIV_RESET_PI_SHIFT 18
#define  SCAN_PLL_RST_PREDIV_RESET_PI_MASK_SHIFT(reg) (((reg) & SCAN_PLL_RST_PREDIV_RESET_PI_MASK) >> SCAN_PLL_RST_PREDIV_RESET_PI_SHIFT)
#define  SCAN_PLL_RST_PREDIV_RESET_PI_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_RST_PREDIV_RESET_PI_MASK) | (((uint32_t)val) << SCAN_PLL_RST_PREDIV_RESET_PI_SHIFT))

#define  SCAN_PLL_RST_PREDIV_RESET_SSC_MASK 0x20000
#define  SCAN_PLL_RST_PREDIV_RESET_SSC_SHIFT 17
#define  SCAN_PLL_RST_PREDIV_RESET_SSC_MASK_SHIFT(reg) (((reg) & SCAN_PLL_RST_PREDIV_RESET_SSC_MASK) >> SCAN_PLL_RST_PREDIV_RESET_SSC_SHIFT)
#define  SCAN_PLL_RST_PREDIV_RESET_SSC_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_RST_PREDIV_RESET_SSC_MASK) | (((uint32_t)val) << SCAN_PLL_RST_PREDIV_RESET_SSC_SHIFT))

#define  SCAN_PLL_RST_PREDIV_RESET_MASK 0x10000
#define  SCAN_PLL_RST_PREDIV_RESET_SHIFT 16
#define  SCAN_PLL_RST_PREDIV_RESET_MASK_SHIFT(reg) (((reg) & SCAN_PLL_RST_PREDIV_RESET_MASK) >> SCAN_PLL_RST_PREDIV_RESET_SHIFT)
#define  SCAN_PLL_RST_PREDIV_RESET_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_RST_PREDIV_RESET_MASK) | (((uint32_t)val) << SCAN_PLL_RST_PREDIV_RESET_SHIFT))

#define  SCAN_PLL_RST_PREDIV_RESERVED2_MASK 0xfe00
#define  SCAN_PLL_RST_PREDIV_RESERVED2_SHIFT 9
#define  SCAN_PLL_RST_PREDIV_RESERVED2_MASK_SHIFT(reg) (((reg) & SCAN_PLL_RST_PREDIV_RESERVED2_MASK) >> SCAN_PLL_RST_PREDIV_RESERVED2_SHIFT)
#define  SCAN_PLL_RST_PREDIV_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_RST_PREDIV_RESERVED2_MASK) | (((uint32_t)val) << SCAN_PLL_RST_PREDIV_RESERVED2_SHIFT))

#define  SCAN_PLL_RST_PREDIV_REFDIV_MASK 0x1ff
#define  SCAN_PLL_RST_PREDIV_REFDIV_SHIFT 0
#define  SCAN_PLL_RST_PREDIV_REFDIV_MASK_SHIFT(reg) (((reg) & SCAN_PLL_RST_PREDIV_REFDIV_MASK) >> SCAN_PLL_RST_PREDIV_REFDIV_SHIFT)
#define  SCAN_PLL_RST_PREDIV_REFDIV_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_RST_PREDIV_REFDIV_MASK) | (((uint32_t)val) << SCAN_PLL_RST_PREDIV_REFDIV_SHIFT))

//====================================================================
//Register: PLL feedback multiplier (mult_postdiv)
/** \brief PLL multiplication factor after pre-divide.*/
//====================================================================

#define  SCAN_PLL_MULT_POSTDIV_RESERVED1_MASK 0xfe000000
#define  SCAN_PLL_MULT_POSTDIV_RESERVED1_SHIFT 25
#define  SCAN_PLL_MULT_POSTDIV_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_MULT_POSTDIV_RESERVED1_MASK) >> SCAN_PLL_MULT_POSTDIV_RESERVED1_SHIFT)
#define  SCAN_PLL_MULT_POSTDIV_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_MULT_POSTDIV_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_MULT_POSTDIV_RESERVED1_SHIFT))

#define  SCAN_PLL_MULT_POSTDIV_FBDIV_MASK 0x1ff0000
#define  SCAN_PLL_MULT_POSTDIV_FBDIV_SHIFT 16
#define  SCAN_PLL_MULT_POSTDIV_FBDIV_MASK_SHIFT(reg) (((reg) & SCAN_PLL_MULT_POSTDIV_FBDIV_MASK) >> SCAN_PLL_MULT_POSTDIV_FBDIV_SHIFT)
#define  SCAN_PLL_MULT_POSTDIV_FBDIV_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_MULT_POSTDIV_FBDIV_MASK) | (((uint32_t)val) << SCAN_PLL_MULT_POSTDIV_FBDIV_SHIFT))

#define  SCAN_PLL_MULT_POSTDIV_RESERVED2_MASK 0xf800
#define  SCAN_PLL_MULT_POSTDIV_RESERVED2_SHIFT 11
#define  SCAN_PLL_MULT_POSTDIV_RESERVED2_MASK_SHIFT(reg) (((reg) & SCAN_PLL_MULT_POSTDIV_RESERVED2_MASK) >> SCAN_PLL_MULT_POSTDIV_RESERVED2_SHIFT)
#define  SCAN_PLL_MULT_POSTDIV_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_MULT_POSTDIV_RESERVED2_MASK) | (((uint32_t)val) << SCAN_PLL_MULT_POSTDIV_RESERVED2_SHIFT))

#define  SCAN_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK 0x700
#define  SCAN_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_SHIFT 8
#define  SCAN_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK_SHIFT(reg) (((reg) & SCAN_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK) >> SCAN_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_SHIFT)
#define  SCAN_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK) | (((uint32_t)val) << SCAN_PLL_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_SHIFT))

#define  SCAN_PLL_MULT_POSTDIV_RESERVED3_MASK 0xf8
#define  SCAN_PLL_MULT_POSTDIV_RESERVED3_SHIFT 3
#define  SCAN_PLL_MULT_POSTDIV_RESERVED3_MASK_SHIFT(reg) (((reg) & SCAN_PLL_MULT_POSTDIV_RESERVED3_MASK) >> SCAN_PLL_MULT_POSTDIV_RESERVED3_SHIFT)
#define  SCAN_PLL_MULT_POSTDIV_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_MULT_POSTDIV_RESERVED3_MASK) | (((uint32_t)val) << SCAN_PLL_MULT_POSTDIV_RESERVED3_SHIFT))

#define  SCAN_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK 0x7
#define  SCAN_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_SHIFT 0
#define  SCAN_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK_SHIFT(reg) (((reg) & SCAN_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK) >> SCAN_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_SHIFT)
#define  SCAN_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK) | (((uint32_t)val) << SCAN_PLL_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_SHIFT))

//====================================================================
//Register: PLL gain control (kvco)
/** \brief PLL gain control.*/
//====================================================================

#define  SCAN_PLL_KVCO_RESERVED1_MASK 0xfffffff0
#define  SCAN_PLL_KVCO_RESERVED1_SHIFT 4
#define  SCAN_PLL_KVCO_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_KVCO_RESERVED1_MASK) >> SCAN_PLL_KVCO_RESERVED1_SHIFT)
#define  SCAN_PLL_KVCO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_KVCO_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_KVCO_RESERVED1_SHIFT))

#define  SCAN_PLL_KVCO_KVCO_MASK 0xf
#define  SCAN_PLL_KVCO_KVCO_SHIFT 0
#define  SCAN_PLL_KVCO_KVCO_MASK_SHIFT(reg) (((reg) & SCAN_PLL_KVCO_KVCO_MASK) >> SCAN_PLL_KVCO_KVCO_SHIFT)
#define  SCAN_PLL_KVCO_KVCO_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_KVCO_KVCO_MASK) | (((uint32_t)val) << SCAN_PLL_KVCO_KVCO_SHIFT))

//====================================================================
//Register: PLL misc control (misc)
/** \brief PLL misc control.*/
//====================================================================

#define  SCAN_PLL_MISC_RESERVED1_MASK 0xffff0000
#define  SCAN_PLL_MISC_RESERVED1_SHIFT 16
#define  SCAN_PLL_MISC_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_MISC_RESERVED1_MASK) >> SCAN_PLL_MISC_RESERVED1_SHIFT)
#define  SCAN_PLL_MISC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_MISC_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_MISC_RESERVED1_SHIFT))

#define  SCAN_PLL_MISC_PLL_BW_SEL_MASK 0x8000
#define  SCAN_PLL_MISC_PLL_BW_SEL_SHIFT 15
#define  SCAN_PLL_MISC_PLL_BW_SEL_MASK_SHIFT(reg) (((reg) & SCAN_PLL_MISC_PLL_BW_SEL_MASK) >> SCAN_PLL_MISC_PLL_BW_SEL_SHIFT)
#define  SCAN_PLL_MISC_PLL_BW_SEL_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_MISC_PLL_BW_SEL_MASK) | (((uint32_t)val) << SCAN_PLL_MISC_PLL_BW_SEL_SHIFT))

#define  SCAN_PLL_MISC_CTUNE_MASK 0x6000
#define  SCAN_PLL_MISC_CTUNE_SHIFT 13
#define  SCAN_PLL_MISC_CTUNE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_MISC_CTUNE_MASK) >> SCAN_PLL_MISC_CTUNE_SHIFT)
#define  SCAN_PLL_MISC_CTUNE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_MISC_CTUNE_MASK) | (((uint32_t)val) << SCAN_PLL_MISC_CTUNE_SHIFT))

#define  SCAN_PLL_MISC_INTPI_MASK 0x1e00
#define  SCAN_PLL_MISC_INTPI_SHIFT 9
#define  SCAN_PLL_MISC_INTPI_MASK_SHIFT(reg) (((reg) & SCAN_PLL_MISC_INTPI_MASK) >> SCAN_PLL_MISC_INTPI_SHIFT)
#define  SCAN_PLL_MISC_INTPI_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_MISC_INTPI_MASK) | (((uint32_t)val) << SCAN_PLL_MISC_INTPI_SHIFT))

#define  SCAN_PLL_MISC_ICP_MASK 0x1e0
#define  SCAN_PLL_MISC_ICP_SHIFT 5
#define  SCAN_PLL_MISC_ICP_MASK_SHIFT(reg) (((reg) & SCAN_PLL_MISC_ICP_MASK) >> SCAN_PLL_MISC_ICP_SHIFT)
#define  SCAN_PLL_MISC_ICP_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_MISC_ICP_MASK) | (((uint32_t)val) << SCAN_PLL_MISC_ICP_SHIFT))

#define  SCAN_PLL_MISC_VDDM_MASK 0x18
#define  SCAN_PLL_MISC_VDDM_SHIFT 3
#define  SCAN_PLL_MISC_VDDM_MASK_SHIFT(reg) (((reg) & SCAN_PLL_MISC_VDDM_MASK) >> SCAN_PLL_MISC_VDDM_SHIFT)
#define  SCAN_PLL_MISC_VDDM_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_MISC_VDDM_MASK) | (((uint32_t)val) << SCAN_PLL_MISC_VDDM_SHIFT))

#define  SCAN_PLL_MISC_VDDL_MASK 0x7
#define  SCAN_PLL_MISC_VDDL_SHIFT 0
#define  SCAN_PLL_MISC_VDDL_MASK_SHIFT(reg) (((reg) & SCAN_PLL_MISC_VDDL_MASK) >> SCAN_PLL_MISC_VDDL_SHIFT)
#define  SCAN_PLL_MISC_VDDL_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_MISC_VDDL_MASK) | (((uint32_t)val) << SCAN_PLL_MISC_VDDL_SHIFT))

//====================================================================
//Register: PLL PFD (Phase Frequency Detector) input select, and de-skew application control (feedback_mode_deskew)
/** \brief PLL feedback mode control.*/
//====================================================================

#define  SCAN_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_MASK 0xff800000
#define  SCAN_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_SHIFT 23
#define  SCAN_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_MASK) >> SCAN_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_SHIFT)
#define  SCAN_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_FEEDBACK_MODE_DESKEW_RESERVED1_SHIFT))

#define  SCAN_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_MASK 0x7e0000
#define  SCAN_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_SHIFT 17
#define  SCAN_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_MASK_SHIFT(reg) (((reg) & SCAN_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_MASK) >> SCAN_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_SHIFT)
#define  SCAN_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_MASK) | (((uint32_t)val) << SCAN_PLL_FEEDBACK_MODE_DESKEW_FBCDLY_SHIFT))

#define  SCAN_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK 0x10000
#define  SCAN_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_SHIFT 16
#define  SCAN_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK_SHIFT(reg) (((reg) & SCAN_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK) >> SCAN_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_SHIFT)
#define  SCAN_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK) | (((uint32_t)val) << SCAN_PLL_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_SHIFT))

#define  SCAN_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_MASK 0xffff
#define  SCAN_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_SHIFT 0
#define  SCAN_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_MASK_SHIFT(reg) (((reg) & SCAN_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_MASK) >> SCAN_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_SHIFT)
#define  SCAN_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_MASK) | (((uint32_t)val) << SCAN_PLL_FEEDBACK_MODE_DESKEW_RESERVED2_SHIFT))

//====================================================================
//Register: PLL offset frequency control (offset_mode)
/** \brief PLL offset frequency control.*/
//====================================================================

#define  SCAN_PLL_OFFSET_MODE_RESERVED1_MASK 0xf8000000
#define  SCAN_PLL_OFFSET_MODE_RESERVED1_SHIFT 27
#define  SCAN_PLL_OFFSET_MODE_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_OFFSET_MODE_RESERVED1_MASK) >> SCAN_PLL_OFFSET_MODE_RESERVED1_SHIFT)
#define  SCAN_PLL_OFFSET_MODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_OFFSET_MODE_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_OFFSET_MODE_RESERVED1_SHIFT))

#define  SCAN_PLL_OFFSET_MODE_INTPR_MASK 0x7000000
#define  SCAN_PLL_OFFSET_MODE_INTPR_SHIFT 24
#define  SCAN_PLL_OFFSET_MODE_INTPR_MASK_SHIFT(reg) (((reg) & SCAN_PLL_OFFSET_MODE_INTPR_MASK) >> SCAN_PLL_OFFSET_MODE_INTPR_SHIFT)
#define  SCAN_PLL_OFFSET_MODE_INTPR_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_OFFSET_MODE_INTPR_MASK) | (((uint32_t)val) << SCAN_PLL_OFFSET_MODE_INTPR_SHIFT))

#define  SCAN_PLL_OFFSET_MODE_FD_MASK 0xe00000
#define  SCAN_PLL_OFFSET_MODE_FD_SHIFT 21
#define  SCAN_PLL_OFFSET_MODE_FD_MASK_SHIFT(reg) (((reg) & SCAN_PLL_OFFSET_MODE_FD_MASK) >> SCAN_PLL_OFFSET_MODE_FD_SHIFT)
#define  SCAN_PLL_OFFSET_MODE_FD_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_OFFSET_MODE_FD_MASK) | (((uint32_t)val) << SCAN_PLL_OFFSET_MODE_FD_SHIFT))

#define  SCAN_PLL_OFFSET_MODE_PI_LOOP_MODE_MASK 0x100000
#define  SCAN_PLL_OFFSET_MODE_PI_LOOP_MODE_SHIFT 20
#define  SCAN_PLL_OFFSET_MODE_PI_LOOP_MODE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_OFFSET_MODE_PI_LOOP_MODE_MASK) >> SCAN_PLL_OFFSET_MODE_PI_LOOP_MODE_SHIFT)
#define  SCAN_PLL_OFFSET_MODE_PI_LOOP_MODE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_OFFSET_MODE_PI_LOOP_MODE_MASK) | (((uint32_t)val) << SCAN_PLL_OFFSET_MODE_PI_LOOP_MODE_SHIFT))

#define  SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_MASK 0xffff8
#define  SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_SHIFT 3
#define  SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_MASK_SHIFT(reg) (((reg) & SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_MASK) >> SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_SHIFT)
#define  SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_MASK) | (((uint32_t)val) << SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_SHIFT))

#define  SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK 0x4
#define  SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_SHIFT 2
#define  SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK_SHIFT(reg) (((reg) & SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK) >> SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_SHIFT)
#define  SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK) | (((uint32_t)val) << SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_SHIFT))

#define  SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_MASK 0x2
#define  SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_SHIFT 1
#define  SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_MASK_SHIFT(reg) (((reg) & SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_MASK) >> SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_SHIFT)
#define  SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_MASK) | (((uint32_t)val) << SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_VALID_SHIFT))

#define  SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_EN_MASK 0x1
#define  SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_EN_SHIFT 0
#define  SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_EN_MASK_SHIFT(reg) (((reg) & SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_EN_MASK) >> SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_EN_SHIFT)
#define  SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_EN_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_EN_MASK) | (((uint32_t)val) << SCAN_PLL_OFFSET_MODE_FREQ_OFFSET_EN_SHIFT))

//====================================================================
//Register: PLL enable (fixed_mode_ssc_mode)
/** \brief PLL enable*/
//====================================================================

#define  SCAN_PLL_FIXED_MODE_SSC_MODE_RESERVED1_MASK 0xfff00000
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_RESERVED1_SHIFT 20
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_FIXED_MODE_SSC_MODE_RESERVED1_MASK) >> SCAN_PLL_FIXED_MODE_SSC_MODE_RESERVED1_SHIFT)
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_FIXED_MODE_SSC_MODE_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_FIXED_MODE_SSC_MODE_RESERVED1_SHIFT))

#define  SCAN_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK 0x80000
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_SHIFT 19
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK_SHIFT(reg) (((reg) & SCAN_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK) >> SCAN_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_SHIFT)
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK) | (((uint32_t)val) << SCAN_PLL_FIXED_MODE_SSC_MODE_AVDD1815_SEL_SHIFT))

#define  SCAN_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK 0x40000
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_SHIFT 18
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK_SHIFT(reg) (((reg) & SCAN_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK) >> SCAN_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_SHIFT)
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK) | (((uint32_t)val) << SCAN_PLL_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_SHIFT))

#define  SCAN_PLL_FIXED_MODE_SSC_MODE_PU_MASK 0x20000
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_PU_SHIFT 17
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_PU_MASK_SHIFT(reg) (((reg) & SCAN_PLL_FIXED_MODE_SSC_MODE_PU_MASK) >> SCAN_PLL_FIXED_MODE_SSC_MODE_PU_SHIFT)
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_PU_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_FIXED_MODE_SSC_MODE_PU_MASK) | (((uint32_t)val) << SCAN_PLL_FIXED_MODE_SSC_MODE_PU_SHIFT))

#define  SCAN_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK 0x10000
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_SHIFT 16
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK_SHIFT(reg) (((reg) & SCAN_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK) >> SCAN_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_SHIFT)
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK) | (((uint32_t)val) << SCAN_PLL_FIXED_MODE_SSC_MODE_BYPASS_EN_SHIFT))

#define  SCAN_PLL_FIXED_MODE_SSC_MODE_RESERVED2_MASK 0xfff0
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_RESERVED2_SHIFT 4
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_RESERVED2_MASK_SHIFT(reg) (((reg) & SCAN_PLL_FIXED_MODE_SSC_MODE_RESERVED2_MASK) >> SCAN_PLL_FIXED_MODE_SSC_MODE_RESERVED2_SHIFT)
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_FIXED_MODE_SSC_MODE_RESERVED2_MASK) | (((uint32_t)val) << SCAN_PLL_FIXED_MODE_SSC_MODE_RESERVED2_SHIFT))

#define  SCAN_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_MASK 0x8
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_SHIFT 3
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_MASK) >> SCAN_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_SHIFT)
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_MASK) | (((uint32_t)val) << SCAN_PLL_FIXED_MODE_SSC_MODE_SSC_MODE_SHIFT))

#define  SCAN_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK 0x4
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_SHIFT 2
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK_SHIFT(reg) (((reg) & SCAN_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK) >> SCAN_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_SHIFT)
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK) | (((uint32_t)val) << SCAN_PLL_FIXED_MODE_SSC_MODE_CLK_DET_EN_SHIFT))

#define  SCAN_PLL_FIXED_MODE_SSC_MODE_PI_EN_MASK 0x2
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_PI_EN_SHIFT 1
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_PI_EN_MASK_SHIFT(reg) (((reg) & SCAN_PLL_FIXED_MODE_SSC_MODE_PI_EN_MASK) >> SCAN_PLL_FIXED_MODE_SSC_MODE_PI_EN_SHIFT)
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_PI_EN_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_FIXED_MODE_SSC_MODE_PI_EN_MASK) | (((uint32_t)val) << SCAN_PLL_FIXED_MODE_SSC_MODE_PI_EN_SHIFT))

#define  SCAN_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK 0x1
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_SHIFT 0
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK_SHIFT(reg) (((reg) & SCAN_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK) >> SCAN_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_SHIFT)
#define  SCAN_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK) | (((uint32_t)val) << SCAN_PLL_FIXED_MODE_SSC_MODE_SSC_CLK_EN_SHIFT))

//====================================================================
//Register: PLL Modulation Frequency (ssc_freq_ssc_range)
/** \brief PLL Modulation Frequency Control*/
//====================================================================

#define  SCAN_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK 0xffff0000
#define  SCAN_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_SHIFT 16
#define  SCAN_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK_SHIFT(reg) (((reg) & SCAN_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK) >> SCAN_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_SHIFT)
#define  SCAN_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK) | (((uint32_t)val) << SCAN_PLL_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_SHIFT))

#define  SCAN_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_MASK 0xf800
#define  SCAN_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_SHIFT 11
#define  SCAN_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_MASK) >> SCAN_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_SHIFT)
#define  SCAN_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_SSC_FREQ_SSC_RANGE_RESERVED1_SHIFT))

#define  SCAN_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK 0x7ff
#define  SCAN_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_SHIFT 0
#define  SCAN_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK) >> SCAN_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_SHIFT)
#define  SCAN_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK) | (((uint32_t)val) << SCAN_PLL_SSC_FREQ_SSC_RANGE_SSC_RNGE_SHIFT))

//====================================================================
//Register: PLL Output Clock Control (clk_ctrl_marvell_test)
/** \brief PLL Output Clock Control*/
//====================================================================

#define  SCAN_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK 0xfffc0000
#define  SCAN_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_SHIFT 18
#define  SCAN_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK) >> SCAN_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_SHIFT)
#define  SCAN_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_CLK_CTRL_MARVELL_TEST_RESERVED1_SHIFT))

#define  SCAN_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK 0x20000
#define  SCAN_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_SHIFT 17
#define  SCAN_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK) >> SCAN_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_SHIFT)
#define  SCAN_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK) | (((uint32_t)val) << SCAN_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_SHIFT))

#define  SCAN_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK 0x10000
#define  SCAN_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_SHIFT 16
#define  SCAN_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK) >> SCAN_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_SHIFT)
#define  SCAN_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK) | (((uint32_t)val) << SCAN_PLL_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_SHIFT))

#define  SCAN_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK 0xf000
#define  SCAN_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_SHIFT 12
#define  SCAN_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK) >> SCAN_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_SHIFT)
#define  SCAN_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK) | (((uint32_t)val) << SCAN_PLL_CLK_CTRL_MARVELL_TEST_RESERVED2_SHIFT))

#define  SCAN_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK 0xff0
#define  SCAN_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_SHIFT 4
#define  SCAN_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK) >> SCAN_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_SHIFT)
#define  SCAN_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK) | (((uint32_t)val) << SCAN_PLL_CLK_CTRL_MARVELL_TEST_RESERVE_IN_SHIFT))

#define  SCAN_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK 0xf
#define  SCAN_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_SHIFT 0
#define  SCAN_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK) >> SCAN_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_SHIFT)
#define  SCAN_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK) | (((uint32_t)val) << SCAN_PLL_CLK_CTRL_MARVELL_TEST_TEST_ANA_SHIFT))

//====================================================================
//Register: PLL Lock Status (lock_status)
/** \brief PLL Lock Output*/
//====================================================================

#define  SCAN_PLL_LOCK_STATUS_RESERVED1_MASK 0xfffffffe
#define  SCAN_PLL_LOCK_STATUS_RESERVED1_SHIFT 1
#define  SCAN_PLL_LOCK_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_LOCK_STATUS_RESERVED1_MASK) >> SCAN_PLL_LOCK_STATUS_RESERVED1_SHIFT)
#define  SCAN_PLL_LOCK_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_LOCK_STATUS_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_LOCK_STATUS_RESERVED1_SHIFT))

#define  SCAN_PLL_LOCK_STATUS_PLL_LOCK_MASK 0x1
#define  SCAN_PLL_LOCK_STATUS_PLL_LOCK_SHIFT 0
#define  SCAN_PLL_LOCK_STATUS_PLL_LOCK_MASK_SHIFT(reg) (((reg) & SCAN_PLL_LOCK_STATUS_PLL_LOCK_MASK) >> SCAN_PLL_LOCK_STATUS_PLL_LOCK_SHIFT)
#define  SCAN_PLL_LOCK_STATUS_PLL_LOCK_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_LOCK_STATUS_PLL_LOCK_MASK) | (((uint32_t)val) << SCAN_PLL_LOCK_STATUS_PLL_LOCK_SHIFT))

//====================================================================
//Register: PLL RESERVE_OUT output (reserve_out)
//====================================================================

#define  SCAN_PLL_RESERVE_OUT_RESERVED1_MASK 0xfffe0000
#define  SCAN_PLL_RESERVE_OUT_RESERVED1_SHIFT 17
#define  SCAN_PLL_RESERVE_OUT_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_RESERVE_OUT_RESERVED1_MASK) >> SCAN_PLL_RESERVE_OUT_RESERVED1_SHIFT)
#define  SCAN_PLL_RESERVE_OUT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_RESERVE_OUT_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_RESERVE_OUT_RESERVED1_SHIFT))

#define  SCAN_PLL_RESERVE_OUT_PU18_REG_MASK 0x10000
#define  SCAN_PLL_RESERVE_OUT_PU18_REG_SHIFT 16
#define  SCAN_PLL_RESERVE_OUT_PU18_REG_MASK_SHIFT(reg) (((reg) & SCAN_PLL_RESERVE_OUT_PU18_REG_MASK) >> SCAN_PLL_RESERVE_OUT_PU18_REG_SHIFT)
#define  SCAN_PLL_RESERVE_OUT_PU18_REG_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_RESERVE_OUT_PU18_REG_MASK) | (((uint32_t)val) << SCAN_PLL_RESERVE_OUT_PU18_REG_SHIFT))

#define  SCAN_PLL_RESERVE_OUT_RESERVED2_MASK 0xff00
#define  SCAN_PLL_RESERVE_OUT_RESERVED2_SHIFT 8
#define  SCAN_PLL_RESERVE_OUT_RESERVED2_MASK_SHIFT(reg) (((reg) & SCAN_PLL_RESERVE_OUT_RESERVED2_MASK) >> SCAN_PLL_RESERVE_OUT_RESERVED2_SHIFT)
#define  SCAN_PLL_RESERVE_OUT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_RESERVE_OUT_RESERVED2_MASK) | (((uint32_t)val) << SCAN_PLL_RESERVE_OUT_RESERVED2_SHIFT))

#define  SCAN_PLL_RESERVE_OUT_RESERVE_OUT_MASK 0xff
#define  SCAN_PLL_RESERVE_OUT_RESERVE_OUT_SHIFT 0
#define  SCAN_PLL_RESERVE_OUT_RESERVE_OUT_MASK_SHIFT(reg) (((reg) & SCAN_PLL_RESERVE_OUT_RESERVE_OUT_MASK) >> SCAN_PLL_RESERVE_OUT_RESERVE_OUT_SHIFT)
#define  SCAN_PLL_RESERVE_OUT_RESERVE_OUT_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_RESERVE_OUT_RESERVE_OUT_MASK) | (((uint32_t)val) << SCAN_PLL_RESERVE_OUT_RESERVE_OUT_SHIFT))

//====================================================================
//
//Register File: SCAN PLL Spread Spectrum Controls (SCAN_PLL_CSSCG)
/** \brief Top-level register file for the CSSCG block*/
//
//====================================================================

//====================================================================
//Register: Interrupt Enable Register (IRQ_EN)
/** \brief Used to enable interrupts for the block.*/
//====================================================================

#define  SCAN_PLL_CSSCG_IRQ_EN_RESERVED1_MASK 0xfffffe00
#define  SCAN_PLL_CSSCG_IRQ_EN_RESERVED1_SHIFT 9
#define  SCAN_PLL_CSSCG_IRQ_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_EN_RESERVED1_MASK) >> SCAN_PLL_CSSCG_IRQ_EN_RESERVED1_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_EN_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_EN_RESERVED1_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_EN_SLV_ARMED_IRQ_EN_MASK 0x100
#define  SCAN_PLL_CSSCG_IRQ_EN_SLV_ARMED_IRQ_EN_SHIFT 8
#define  SCAN_PLL_CSSCG_IRQ_EN_SLV_ARMED_IRQ_EN_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_EN_SLV_ARMED_IRQ_EN_MASK) >> SCAN_PLL_CSSCG_IRQ_EN_SLV_ARMED_IRQ_EN_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_EN_SLV_ARMED_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_EN_SLV_ARMED_IRQ_EN_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_EN_SLV_ARMED_IRQ_EN_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_EN_SLV_FULL_IRQ_EN_MASK 0x80
#define  SCAN_PLL_CSSCG_IRQ_EN_SLV_FULL_IRQ_EN_SHIFT 7
#define  SCAN_PLL_CSSCG_IRQ_EN_SLV_FULL_IRQ_EN_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_EN_SLV_FULL_IRQ_EN_MASK) >> SCAN_PLL_CSSCG_IRQ_EN_SLV_FULL_IRQ_EN_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_EN_SLV_FULL_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_EN_SLV_FULL_IRQ_EN_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_EN_SLV_FULL_IRQ_EN_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_EN_SLV_INIT_IRQ_EN_MASK 0x40
#define  SCAN_PLL_CSSCG_IRQ_EN_SLV_INIT_IRQ_EN_SHIFT 6
#define  SCAN_PLL_CSSCG_IRQ_EN_SLV_INIT_IRQ_EN_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_EN_SLV_INIT_IRQ_EN_MASK) >> SCAN_PLL_CSSCG_IRQ_EN_SLV_INIT_IRQ_EN_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_EN_SLV_INIT_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_EN_SLV_INIT_IRQ_EN_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_EN_SLV_INIT_IRQ_EN_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_EN_SLV_TIMEOUT_IRQ_EN_MASK 0x20
#define  SCAN_PLL_CSSCG_IRQ_EN_SLV_TIMEOUT_IRQ_EN_SHIFT 5
#define  SCAN_PLL_CSSCG_IRQ_EN_SLV_TIMEOUT_IRQ_EN_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_EN_SLV_TIMEOUT_IRQ_EN_MASK) >> SCAN_PLL_CSSCG_IRQ_EN_SLV_TIMEOUT_IRQ_EN_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_EN_SLV_TIMEOUT_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_EN_SLV_TIMEOUT_IRQ_EN_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_EN_SLV_TIMEOUT_IRQ_EN_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_EN_SLV_TRIG_ERR_IRQ_EN_MASK 0x10
#define  SCAN_PLL_CSSCG_IRQ_EN_SLV_TRIG_ERR_IRQ_EN_SHIFT 4
#define  SCAN_PLL_CSSCG_IRQ_EN_SLV_TRIG_ERR_IRQ_EN_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_EN_SLV_TRIG_ERR_IRQ_EN_MASK) >> SCAN_PLL_CSSCG_IRQ_EN_SLV_TRIG_ERR_IRQ_EN_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_EN_SLV_TRIG_ERR_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_EN_SLV_TRIG_ERR_IRQ_EN_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_EN_SLV_TRIG_ERR_IRQ_EN_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_EN_SLV_TRIG_IRQ_EN_MASK 0x8
#define  SCAN_PLL_CSSCG_IRQ_EN_SLV_TRIG_IRQ_EN_SHIFT 3
#define  SCAN_PLL_CSSCG_IRQ_EN_SLV_TRIG_IRQ_EN_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_EN_SLV_TRIG_IRQ_EN_MASK) >> SCAN_PLL_CSSCG_IRQ_EN_SLV_TRIG_IRQ_EN_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_EN_SLV_TRIG_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_EN_SLV_TRIG_IRQ_EN_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_EN_SLV_TRIG_IRQ_EN_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_EN_HALT_COMPLETE_IRQ_EN_MASK 0x4
#define  SCAN_PLL_CSSCG_IRQ_EN_HALT_COMPLETE_IRQ_EN_SHIFT 2
#define  SCAN_PLL_CSSCG_IRQ_EN_HALT_COMPLETE_IRQ_EN_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_EN_HALT_COMPLETE_IRQ_EN_MASK) >> SCAN_PLL_CSSCG_IRQ_EN_HALT_COMPLETE_IRQ_EN_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_EN_HALT_COMPLETE_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_EN_HALT_COMPLETE_IRQ_EN_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_EN_HALT_COMPLETE_IRQ_EN_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_EN_DISABLE_COMPLETE_IRQ_EN_MASK 0x2
#define  SCAN_PLL_CSSCG_IRQ_EN_DISABLE_COMPLETE_IRQ_EN_SHIFT 1
#define  SCAN_PLL_CSSCG_IRQ_EN_DISABLE_COMPLETE_IRQ_EN_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_EN_DISABLE_COMPLETE_IRQ_EN_MASK) >> SCAN_PLL_CSSCG_IRQ_EN_DISABLE_COMPLETE_IRQ_EN_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_EN_DISABLE_COMPLETE_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_EN_DISABLE_COMPLETE_IRQ_EN_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_EN_DISABLE_COMPLETE_IRQ_EN_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_EN_CYCLE_START_IRQ_EN_MASK 0x1
#define  SCAN_PLL_CSSCG_IRQ_EN_CYCLE_START_IRQ_EN_SHIFT 0
#define  SCAN_PLL_CSSCG_IRQ_EN_CYCLE_START_IRQ_EN_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_EN_CYCLE_START_IRQ_EN_MASK) >> SCAN_PLL_CSSCG_IRQ_EN_CYCLE_START_IRQ_EN_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_EN_CYCLE_START_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_EN_CYCLE_START_IRQ_EN_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_EN_CYCLE_START_IRQ_EN_SHIFT))

//====================================================================
//Register: Interrupt Pending Register (IRQ_PEND)
/** \brief Used to read the status of the block's interrupts.*/
//====================================================================

#define  SCAN_PLL_CSSCG_IRQ_PEND_RESERVED1_MASK 0xfffffe00
#define  SCAN_PLL_CSSCG_IRQ_PEND_RESERVED1_SHIFT 9
#define  SCAN_PLL_CSSCG_IRQ_PEND_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_PEND_RESERVED1_MASK) >> SCAN_PLL_CSSCG_IRQ_PEND_RESERVED1_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_PEND_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_PEND_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_PEND_RESERVED1_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_PEND_SLV_ARMED_IRQ_PEND_MASK 0x100
#define  SCAN_PLL_CSSCG_IRQ_PEND_SLV_ARMED_IRQ_PEND_SHIFT 8
#define  SCAN_PLL_CSSCG_IRQ_PEND_SLV_ARMED_IRQ_PEND_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_PEND_SLV_ARMED_IRQ_PEND_MASK) >> SCAN_PLL_CSSCG_IRQ_PEND_SLV_ARMED_IRQ_PEND_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_PEND_SLV_ARMED_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_PEND_SLV_ARMED_IRQ_PEND_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_PEND_SLV_ARMED_IRQ_PEND_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_PEND_SLV_FULL_IRQ_PEND_MASK 0x80
#define  SCAN_PLL_CSSCG_IRQ_PEND_SLV_FULL_IRQ_PEND_SHIFT 7
#define  SCAN_PLL_CSSCG_IRQ_PEND_SLV_FULL_IRQ_PEND_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_PEND_SLV_FULL_IRQ_PEND_MASK) >> SCAN_PLL_CSSCG_IRQ_PEND_SLV_FULL_IRQ_PEND_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_PEND_SLV_FULL_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_PEND_SLV_FULL_IRQ_PEND_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_PEND_SLV_FULL_IRQ_PEND_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_PEND_SLV_INIT_IRQ_PEND_MASK 0x40
#define  SCAN_PLL_CSSCG_IRQ_PEND_SLV_INIT_IRQ_PEND_SHIFT 6
#define  SCAN_PLL_CSSCG_IRQ_PEND_SLV_INIT_IRQ_PEND_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_PEND_SLV_INIT_IRQ_PEND_MASK) >> SCAN_PLL_CSSCG_IRQ_PEND_SLV_INIT_IRQ_PEND_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_PEND_SLV_INIT_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_PEND_SLV_INIT_IRQ_PEND_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_PEND_SLV_INIT_IRQ_PEND_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_PEND_SLV_TIMEOUT_IRQ_PEND_MASK 0x20
#define  SCAN_PLL_CSSCG_IRQ_PEND_SLV_TIMEOUT_IRQ_PEND_SHIFT 5
#define  SCAN_PLL_CSSCG_IRQ_PEND_SLV_TIMEOUT_IRQ_PEND_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_PEND_SLV_TIMEOUT_IRQ_PEND_MASK) >> SCAN_PLL_CSSCG_IRQ_PEND_SLV_TIMEOUT_IRQ_PEND_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_PEND_SLV_TIMEOUT_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_PEND_SLV_TIMEOUT_IRQ_PEND_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_PEND_SLV_TIMEOUT_IRQ_PEND_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_PEND_SLV_TRIG_ERR_IRQ_PEND_MASK 0x10
#define  SCAN_PLL_CSSCG_IRQ_PEND_SLV_TRIG_ERR_IRQ_PEND_SHIFT 4
#define  SCAN_PLL_CSSCG_IRQ_PEND_SLV_TRIG_ERR_IRQ_PEND_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_PEND_SLV_TRIG_ERR_IRQ_PEND_MASK) >> SCAN_PLL_CSSCG_IRQ_PEND_SLV_TRIG_ERR_IRQ_PEND_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_PEND_SLV_TRIG_ERR_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_PEND_SLV_TRIG_ERR_IRQ_PEND_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_PEND_SLV_TRIG_ERR_IRQ_PEND_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_PEND_SLV_TRIG_IRQ_PEND_MASK 0x8
#define  SCAN_PLL_CSSCG_IRQ_PEND_SLV_TRIG_IRQ_PEND_SHIFT 3
#define  SCAN_PLL_CSSCG_IRQ_PEND_SLV_TRIG_IRQ_PEND_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_PEND_SLV_TRIG_IRQ_PEND_MASK) >> SCAN_PLL_CSSCG_IRQ_PEND_SLV_TRIG_IRQ_PEND_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_PEND_SLV_TRIG_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_PEND_SLV_TRIG_IRQ_PEND_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_PEND_SLV_TRIG_IRQ_PEND_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_PEND_HALT_COMPLETE_IRQ_PEND_MASK 0x4
#define  SCAN_PLL_CSSCG_IRQ_PEND_HALT_COMPLETE_IRQ_PEND_SHIFT 2
#define  SCAN_PLL_CSSCG_IRQ_PEND_HALT_COMPLETE_IRQ_PEND_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_PEND_HALT_COMPLETE_IRQ_PEND_MASK) >> SCAN_PLL_CSSCG_IRQ_PEND_HALT_COMPLETE_IRQ_PEND_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_PEND_HALT_COMPLETE_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_PEND_HALT_COMPLETE_IRQ_PEND_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_PEND_HALT_COMPLETE_IRQ_PEND_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_PEND_DISABLE_COMPLETE_IRQ_PEND_MASK 0x2
#define  SCAN_PLL_CSSCG_IRQ_PEND_DISABLE_COMPLETE_IRQ_PEND_SHIFT 1
#define  SCAN_PLL_CSSCG_IRQ_PEND_DISABLE_COMPLETE_IRQ_PEND_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_PEND_DISABLE_COMPLETE_IRQ_PEND_MASK) >> SCAN_PLL_CSSCG_IRQ_PEND_DISABLE_COMPLETE_IRQ_PEND_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_PEND_DISABLE_COMPLETE_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_PEND_DISABLE_COMPLETE_IRQ_PEND_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_PEND_DISABLE_COMPLETE_IRQ_PEND_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_PEND_CYCLE_START_IRQ_PEND_MASK 0x1
#define  SCAN_PLL_CSSCG_IRQ_PEND_CYCLE_START_IRQ_PEND_SHIFT 0
#define  SCAN_PLL_CSSCG_IRQ_PEND_CYCLE_START_IRQ_PEND_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_PEND_CYCLE_START_IRQ_PEND_MASK) >> SCAN_PLL_CSSCG_IRQ_PEND_CYCLE_START_IRQ_PEND_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_PEND_CYCLE_START_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_PEND_CYCLE_START_IRQ_PEND_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_PEND_CYCLE_START_IRQ_PEND_SHIFT))

//====================================================================
//Register: Interrupt Acknowledge Register (IRQ_ACK)
/** \brief Write a 1 to the bit to clear the appropriate interrupt. <br/> The Input and Output DMA interrupts must be cleared via their respective registers.*/
//====================================================================

#define  SCAN_PLL_CSSCG_IRQ_ACK_RESERVED1_MASK 0xfffffe00
#define  SCAN_PLL_CSSCG_IRQ_ACK_RESERVED1_SHIFT 9
#define  SCAN_PLL_CSSCG_IRQ_ACK_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_ACK_RESERVED1_MASK) >> SCAN_PLL_CSSCG_IRQ_ACK_RESERVED1_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_ACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_ACK_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_ACK_RESERVED1_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_ACK_SLV_ARMED_IRQ_ACK_MASK 0x100
#define  SCAN_PLL_CSSCG_IRQ_ACK_SLV_ARMED_IRQ_ACK_SHIFT 8
#define  SCAN_PLL_CSSCG_IRQ_ACK_SLV_ARMED_IRQ_ACK_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_ACK_SLV_ARMED_IRQ_ACK_MASK) >> SCAN_PLL_CSSCG_IRQ_ACK_SLV_ARMED_IRQ_ACK_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_ACK_SLV_ARMED_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_ACK_SLV_ARMED_IRQ_ACK_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_ACK_SLV_ARMED_IRQ_ACK_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_ACK_SLV_FULL_IRQ_ACK_MASK 0x80
#define  SCAN_PLL_CSSCG_IRQ_ACK_SLV_FULL_IRQ_ACK_SHIFT 7
#define  SCAN_PLL_CSSCG_IRQ_ACK_SLV_FULL_IRQ_ACK_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_ACK_SLV_FULL_IRQ_ACK_MASK) >> SCAN_PLL_CSSCG_IRQ_ACK_SLV_FULL_IRQ_ACK_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_ACK_SLV_FULL_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_ACK_SLV_FULL_IRQ_ACK_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_ACK_SLV_FULL_IRQ_ACK_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_ACK_SLV_INIT_IRQ_ACK_MASK 0x40
#define  SCAN_PLL_CSSCG_IRQ_ACK_SLV_INIT_IRQ_ACK_SHIFT 6
#define  SCAN_PLL_CSSCG_IRQ_ACK_SLV_INIT_IRQ_ACK_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_ACK_SLV_INIT_IRQ_ACK_MASK) >> SCAN_PLL_CSSCG_IRQ_ACK_SLV_INIT_IRQ_ACK_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_ACK_SLV_INIT_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_ACK_SLV_INIT_IRQ_ACK_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_ACK_SLV_INIT_IRQ_ACK_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_ACK_SLV_TIMEOUT_IRQ_ACK_MASK 0x20
#define  SCAN_PLL_CSSCG_IRQ_ACK_SLV_TIMEOUT_IRQ_ACK_SHIFT 5
#define  SCAN_PLL_CSSCG_IRQ_ACK_SLV_TIMEOUT_IRQ_ACK_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_ACK_SLV_TIMEOUT_IRQ_ACK_MASK) >> SCAN_PLL_CSSCG_IRQ_ACK_SLV_TIMEOUT_IRQ_ACK_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_ACK_SLV_TIMEOUT_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_ACK_SLV_TIMEOUT_IRQ_ACK_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_ACK_SLV_TIMEOUT_IRQ_ACK_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_ACK_SLV_TRIG_ERR_IRQ_ACK_MASK 0x10
#define  SCAN_PLL_CSSCG_IRQ_ACK_SLV_TRIG_ERR_IRQ_ACK_SHIFT 4
#define  SCAN_PLL_CSSCG_IRQ_ACK_SLV_TRIG_ERR_IRQ_ACK_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_ACK_SLV_TRIG_ERR_IRQ_ACK_MASK) >> SCAN_PLL_CSSCG_IRQ_ACK_SLV_TRIG_ERR_IRQ_ACK_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_ACK_SLV_TRIG_ERR_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_ACK_SLV_TRIG_ERR_IRQ_ACK_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_ACK_SLV_TRIG_ERR_IRQ_ACK_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_ACK_SLV_TRIG_IRQ_ACK_MASK 0x8
#define  SCAN_PLL_CSSCG_IRQ_ACK_SLV_TRIG_IRQ_ACK_SHIFT 3
#define  SCAN_PLL_CSSCG_IRQ_ACK_SLV_TRIG_IRQ_ACK_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_ACK_SLV_TRIG_IRQ_ACK_MASK) >> SCAN_PLL_CSSCG_IRQ_ACK_SLV_TRIG_IRQ_ACK_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_ACK_SLV_TRIG_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_ACK_SLV_TRIG_IRQ_ACK_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_ACK_SLV_TRIG_IRQ_ACK_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_ACK_HALT_COMPLETE_IRQ_ACK_MASK 0x4
#define  SCAN_PLL_CSSCG_IRQ_ACK_HALT_COMPLETE_IRQ_ACK_SHIFT 2
#define  SCAN_PLL_CSSCG_IRQ_ACK_HALT_COMPLETE_IRQ_ACK_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_ACK_HALT_COMPLETE_IRQ_ACK_MASK) >> SCAN_PLL_CSSCG_IRQ_ACK_HALT_COMPLETE_IRQ_ACK_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_ACK_HALT_COMPLETE_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_ACK_HALT_COMPLETE_IRQ_ACK_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_ACK_HALT_COMPLETE_IRQ_ACK_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_ACK_DISABLE_COMPLETE_IRQ_ACK_MASK 0x2
#define  SCAN_PLL_CSSCG_IRQ_ACK_DISABLE_COMPLETE_IRQ_ACK_SHIFT 1
#define  SCAN_PLL_CSSCG_IRQ_ACK_DISABLE_COMPLETE_IRQ_ACK_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_ACK_DISABLE_COMPLETE_IRQ_ACK_MASK) >> SCAN_PLL_CSSCG_IRQ_ACK_DISABLE_COMPLETE_IRQ_ACK_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_ACK_DISABLE_COMPLETE_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_ACK_DISABLE_COMPLETE_IRQ_ACK_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_ACK_DISABLE_COMPLETE_IRQ_ACK_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_ACK_CYCLE_START_IRQ_ACK_MASK 0x1
#define  SCAN_PLL_CSSCG_IRQ_ACK_CYCLE_START_IRQ_ACK_SHIFT 0
#define  SCAN_PLL_CSSCG_IRQ_ACK_CYCLE_START_IRQ_ACK_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_ACK_CYCLE_START_IRQ_ACK_MASK) >> SCAN_PLL_CSSCG_IRQ_ACK_CYCLE_START_IRQ_ACK_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_ACK_CYCLE_START_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_ACK_CYCLE_START_IRQ_ACK_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_ACK_CYCLE_START_IRQ_ACK_SHIFT))

//====================================================================
//Register: Interrupt Force Register (IRQ_FORCE)
/** \brief Write a 1 to the bit to force the interrupt for testing purposes. <br/>*/
//====================================================================

#define  SCAN_PLL_CSSCG_IRQ_FORCE_RESERVED1_MASK 0xfffffe00
#define  SCAN_PLL_CSSCG_IRQ_FORCE_RESERVED1_SHIFT 9
#define  SCAN_PLL_CSSCG_IRQ_FORCE_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_FORCE_RESERVED1_MASK) >> SCAN_PLL_CSSCG_IRQ_FORCE_RESERVED1_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_FORCE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_FORCE_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_FORCE_RESERVED1_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_FORCE_SLV_ARMED_IRQ_FORCE_MASK 0x100
#define  SCAN_PLL_CSSCG_IRQ_FORCE_SLV_ARMED_IRQ_FORCE_SHIFT 8
#define  SCAN_PLL_CSSCG_IRQ_FORCE_SLV_ARMED_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_FORCE_SLV_ARMED_IRQ_FORCE_MASK) >> SCAN_PLL_CSSCG_IRQ_FORCE_SLV_ARMED_IRQ_FORCE_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_FORCE_SLV_ARMED_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_FORCE_SLV_ARMED_IRQ_FORCE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_FORCE_SLV_ARMED_IRQ_FORCE_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_FORCE_SLV_FULL_IRQ_FORCE_MASK 0x80
#define  SCAN_PLL_CSSCG_IRQ_FORCE_SLV_FULL_IRQ_FORCE_SHIFT 7
#define  SCAN_PLL_CSSCG_IRQ_FORCE_SLV_FULL_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_FORCE_SLV_FULL_IRQ_FORCE_MASK) >> SCAN_PLL_CSSCG_IRQ_FORCE_SLV_FULL_IRQ_FORCE_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_FORCE_SLV_FULL_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_FORCE_SLV_FULL_IRQ_FORCE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_FORCE_SLV_FULL_IRQ_FORCE_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_FORCE_SLV_INIT_IRQ_FORCE_MASK 0x40
#define  SCAN_PLL_CSSCG_IRQ_FORCE_SLV_INIT_IRQ_FORCE_SHIFT 6
#define  SCAN_PLL_CSSCG_IRQ_FORCE_SLV_INIT_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_FORCE_SLV_INIT_IRQ_FORCE_MASK) >> SCAN_PLL_CSSCG_IRQ_FORCE_SLV_INIT_IRQ_FORCE_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_FORCE_SLV_INIT_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_FORCE_SLV_INIT_IRQ_FORCE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_FORCE_SLV_INIT_IRQ_FORCE_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_FORCE_SLV_TIMEOUT_IRQ_FORCE_MASK 0x20
#define  SCAN_PLL_CSSCG_IRQ_FORCE_SLV_TIMEOUT_IRQ_FORCE_SHIFT 5
#define  SCAN_PLL_CSSCG_IRQ_FORCE_SLV_TIMEOUT_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_FORCE_SLV_TIMEOUT_IRQ_FORCE_MASK) >> SCAN_PLL_CSSCG_IRQ_FORCE_SLV_TIMEOUT_IRQ_FORCE_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_FORCE_SLV_TIMEOUT_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_FORCE_SLV_TIMEOUT_IRQ_FORCE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_FORCE_SLV_TIMEOUT_IRQ_FORCE_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_ERR_IRQ_FORCE_MASK 0x10
#define  SCAN_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_ERR_IRQ_FORCE_SHIFT 4
#define  SCAN_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_ERR_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_ERR_IRQ_FORCE_MASK) >> SCAN_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_ERR_IRQ_FORCE_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_ERR_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_ERR_IRQ_FORCE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_ERR_IRQ_FORCE_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_IRQ_FORCE_MASK 0x8
#define  SCAN_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_IRQ_FORCE_SHIFT 3
#define  SCAN_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_IRQ_FORCE_MASK) >> SCAN_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_IRQ_FORCE_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_IRQ_FORCE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_FORCE_SLV_TRIG_IRQ_FORCE_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_FORCE_HALT_COMPLETE_IRQ_FORCE_MASK 0x4
#define  SCAN_PLL_CSSCG_IRQ_FORCE_HALT_COMPLETE_IRQ_FORCE_SHIFT 2
#define  SCAN_PLL_CSSCG_IRQ_FORCE_HALT_COMPLETE_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_FORCE_HALT_COMPLETE_IRQ_FORCE_MASK) >> SCAN_PLL_CSSCG_IRQ_FORCE_HALT_COMPLETE_IRQ_FORCE_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_FORCE_HALT_COMPLETE_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_FORCE_HALT_COMPLETE_IRQ_FORCE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_FORCE_HALT_COMPLETE_IRQ_FORCE_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_FORCE_DISABLE_COMPLETE_IRQ_FORCE_MASK 0x2
#define  SCAN_PLL_CSSCG_IRQ_FORCE_DISABLE_COMPLETE_IRQ_FORCE_SHIFT 1
#define  SCAN_PLL_CSSCG_IRQ_FORCE_DISABLE_COMPLETE_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_FORCE_DISABLE_COMPLETE_IRQ_FORCE_MASK) >> SCAN_PLL_CSSCG_IRQ_FORCE_DISABLE_COMPLETE_IRQ_FORCE_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_FORCE_DISABLE_COMPLETE_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_FORCE_DISABLE_COMPLETE_IRQ_FORCE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_FORCE_DISABLE_COMPLETE_IRQ_FORCE_SHIFT))

#define  SCAN_PLL_CSSCG_IRQ_FORCE_CYCLE_START_IRQ_FORCE_MASK 0x1
#define  SCAN_PLL_CSSCG_IRQ_FORCE_CYCLE_START_IRQ_FORCE_SHIFT 0
#define  SCAN_PLL_CSSCG_IRQ_FORCE_CYCLE_START_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_IRQ_FORCE_CYCLE_START_IRQ_FORCE_MASK) >> SCAN_PLL_CSSCG_IRQ_FORCE_CYCLE_START_IRQ_FORCE_SHIFT)
#define  SCAN_PLL_CSSCG_IRQ_FORCE_CYCLE_START_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_IRQ_FORCE_CYCLE_START_IRQ_FORCE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_IRQ_FORCE_CYCLE_START_IRQ_FORCE_SHIFT))

//====================================================================
//Register: CSSCG Mode Configuration Register (MODE_CONFIG)
/** \brief This register configures the CSSCG modes of operation.*/
//====================================================================

#define  SCAN_PLL_CSSCG_MODE_CONFIG_SOFT_RESET_MASK 0x80000000
#define  SCAN_PLL_CSSCG_MODE_CONFIG_SOFT_RESET_SHIFT 31
#define  SCAN_PLL_CSSCG_MODE_CONFIG_SOFT_RESET_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_MODE_CONFIG_SOFT_RESET_MASK) >> SCAN_PLL_CSSCG_MODE_CONFIG_SOFT_RESET_SHIFT)
#define  SCAN_PLL_CSSCG_MODE_CONFIG_SOFT_RESET_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_MODE_CONFIG_SOFT_RESET_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_MODE_CONFIG_SOFT_RESET_SHIFT))

#define  SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED1_MASK 0x40000000
#define  SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED1_SHIFT 30
#define  SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED1_MASK) >> SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED1_SHIFT)
#define  SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED1_SHIFT))

#define  SCAN_PLL_CSSCG_MODE_CONFIG_MAX_ADDR_MASK 0x3f000000
#define  SCAN_PLL_CSSCG_MODE_CONFIG_MAX_ADDR_SHIFT 24
#define  SCAN_PLL_CSSCG_MODE_CONFIG_MAX_ADDR_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_MODE_CONFIG_MAX_ADDR_MASK) >> SCAN_PLL_CSSCG_MODE_CONFIG_MAX_ADDR_SHIFT)
#define  SCAN_PLL_CSSCG_MODE_CONFIG_MAX_ADDR_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_MODE_CONFIG_MAX_ADDR_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_MODE_CONFIG_MAX_ADDR_SHIFT))

#define  SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED2_MASK 0xc00000
#define  SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED2_SHIFT 22
#define  SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED2_MASK) >> SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED2_SHIFT)
#define  SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED2_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED2_SHIFT))

#define  SCAN_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_TYPE_MASK 0x200000
#define  SCAN_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_TYPE_SHIFT 21
#define  SCAN_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_TYPE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_TYPE_MASK) >> SCAN_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_TYPE_SHIFT)
#define  SCAN_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_TYPE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_TYPE_SHIFT))

#define  SCAN_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_EN_MASK 0x100000
#define  SCAN_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_EN_SHIFT 20
#define  SCAN_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_EN_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_EN_MASK) >> SCAN_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_EN_SHIFT)
#define  SCAN_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_EN_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_EN_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_MODE_CONFIG_TRIG_OUT_EN_SHIFT))

#define  SCAN_PLL_CSSCG_MODE_CONFIG_INTERP_POINTS_MASK 0xff000
#define  SCAN_PLL_CSSCG_MODE_CONFIG_INTERP_POINTS_SHIFT 12
#define  SCAN_PLL_CSSCG_MODE_CONFIG_INTERP_POINTS_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_MODE_CONFIG_INTERP_POINTS_MASK) >> SCAN_PLL_CSSCG_MODE_CONFIG_INTERP_POINTS_SHIFT)
#define  SCAN_PLL_CSSCG_MODE_CONFIG_INTERP_POINTS_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_MODE_CONFIG_INTERP_POINTS_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_MODE_CONFIG_INTERP_POINTS_SHIFT))

#define  SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED3_MASK 0xe00
#define  SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED3_SHIFT 9
#define  SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED3_MASK) >> SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED3_SHIFT)
#define  SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED3_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED3_SHIFT))

#define  SCAN_PLL_CSSCG_MODE_CONFIG_RATE_DIV_M1_MASK 0x1f0
#define  SCAN_PLL_CSSCG_MODE_CONFIG_RATE_DIV_M1_SHIFT 4
#define  SCAN_PLL_CSSCG_MODE_CONFIG_RATE_DIV_M1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_MODE_CONFIG_RATE_DIV_M1_MASK) >> SCAN_PLL_CSSCG_MODE_CONFIG_RATE_DIV_M1_SHIFT)
#define  SCAN_PLL_CSSCG_MODE_CONFIG_RATE_DIV_M1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_MODE_CONFIG_RATE_DIV_M1_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_MODE_CONFIG_RATE_DIV_M1_SHIFT))

#define  SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED4_MASK 0x8
#define  SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED4_SHIFT 3
#define  SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED4_MASK) >> SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED4_SHIFT)
#define  SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED4_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_MODE_CONFIG_RESERVED4_SHIFT))

#define  SCAN_PLL_CSSCG_MODE_CONFIG_SLV_SYNC_MODE_MASK 0x4
#define  SCAN_PLL_CSSCG_MODE_CONFIG_SLV_SYNC_MODE_SHIFT 2
#define  SCAN_PLL_CSSCG_MODE_CONFIG_SLV_SYNC_MODE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_MODE_CONFIG_SLV_SYNC_MODE_MASK) >> SCAN_PLL_CSSCG_MODE_CONFIG_SLV_SYNC_MODE_SHIFT)
#define  SCAN_PLL_CSSCG_MODE_CONFIG_SLV_SYNC_MODE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_MODE_CONFIG_SLV_SYNC_MODE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_MODE_CONFIG_SLV_SYNC_MODE_SHIFT))

#define  SCAN_PLL_CSSCG_MODE_CONFIG_APPLY_CORRECTION_MASK 0x2
#define  SCAN_PLL_CSSCG_MODE_CONFIG_APPLY_CORRECTION_SHIFT 1
#define  SCAN_PLL_CSSCG_MODE_CONFIG_APPLY_CORRECTION_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_MODE_CONFIG_APPLY_CORRECTION_MASK) >> SCAN_PLL_CSSCG_MODE_CONFIG_APPLY_CORRECTION_SHIFT)
#define  SCAN_PLL_CSSCG_MODE_CONFIG_APPLY_CORRECTION_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_MODE_CONFIG_APPLY_CORRECTION_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_MODE_CONFIG_APPLY_CORRECTION_SHIFT))

#define  SCAN_PLL_CSSCG_MODE_CONFIG_DOWN_SPREAD_MASK 0x1
#define  SCAN_PLL_CSSCG_MODE_CONFIG_DOWN_SPREAD_SHIFT 0
#define  SCAN_PLL_CSSCG_MODE_CONFIG_DOWN_SPREAD_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_MODE_CONFIG_DOWN_SPREAD_MASK) >> SCAN_PLL_CSSCG_MODE_CONFIG_DOWN_SPREAD_SHIFT)
#define  SCAN_PLL_CSSCG_MODE_CONFIG_DOWN_SPREAD_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_MODE_CONFIG_DOWN_SPREAD_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_MODE_CONFIG_DOWN_SPREAD_SHIFT))

//====================================================================
//Register: CSSCG Halt Configuration Register (HALT_CONFIG)
/** \brief This register defines the place on the dither curve where the block will stop upon a halt request. Note that the block will continue to send offset codes to the PLL*/
//====================================================================

#define  SCAN_PLL_CSSCG_HALT_CONFIG_RESERVED1_MASK 0xfffc0000
#define  SCAN_PLL_CSSCG_HALT_CONFIG_RESERVED1_SHIFT 18
#define  SCAN_PLL_CSSCG_HALT_CONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_HALT_CONFIG_RESERVED1_MASK) >> SCAN_PLL_CSSCG_HALT_CONFIG_RESERVED1_SHIFT)
#define  SCAN_PLL_CSSCG_HALT_CONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_HALT_CONFIG_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_HALT_CONFIG_RESERVED1_SHIFT))

#define  SCAN_PLL_CSSCG_HALT_CONFIG_HALT_PHASE_MASK 0x30000
#define  SCAN_PLL_CSSCG_HALT_CONFIG_HALT_PHASE_SHIFT 16
#define  SCAN_PLL_CSSCG_HALT_CONFIG_HALT_PHASE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_HALT_CONFIG_HALT_PHASE_MASK) >> SCAN_PLL_CSSCG_HALT_CONFIG_HALT_PHASE_SHIFT)
#define  SCAN_PLL_CSSCG_HALT_CONFIG_HALT_PHASE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_HALT_CONFIG_HALT_PHASE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_HALT_CONFIG_HALT_PHASE_SHIFT))

#define  SCAN_PLL_CSSCG_HALT_CONFIG_RESERVED2_MASK 0xffc0
#define  SCAN_PLL_CSSCG_HALT_CONFIG_RESERVED2_SHIFT 6
#define  SCAN_PLL_CSSCG_HALT_CONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_HALT_CONFIG_RESERVED2_MASK) >> SCAN_PLL_CSSCG_HALT_CONFIG_RESERVED2_SHIFT)
#define  SCAN_PLL_CSSCG_HALT_CONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_HALT_CONFIG_RESERVED2_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_HALT_CONFIG_RESERVED2_SHIFT))

#define  SCAN_PLL_CSSCG_HALT_CONFIG_HALT_ADDR_MASK 0x3f
#define  SCAN_PLL_CSSCG_HALT_CONFIG_HALT_ADDR_SHIFT 0
#define  SCAN_PLL_CSSCG_HALT_CONFIG_HALT_ADDR_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_HALT_CONFIG_HALT_ADDR_MASK) >> SCAN_PLL_CSSCG_HALT_CONFIG_HALT_ADDR_SHIFT)
#define  SCAN_PLL_CSSCG_HALT_CONFIG_HALT_ADDR_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_HALT_CONFIG_HALT_ADDR_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_HALT_CONFIG_HALT_ADDR_SHIFT))

//====================================================================
//Register: CSSCG Sign Bit Override Register (SB_OVER)
/** \brief This register is used to override the sign bit to the PLL.*/
//====================================================================

#define  SCAN_PLL_CSSCG_SB_OVER_RESERVED1_MASK 0xfffffffe
#define  SCAN_PLL_CSSCG_SB_OVER_RESERVED1_SHIFT 1
#define  SCAN_PLL_CSSCG_SB_OVER_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_SB_OVER_RESERVED1_MASK) >> SCAN_PLL_CSSCG_SB_OVER_RESERVED1_SHIFT)
#define  SCAN_PLL_CSSCG_SB_OVER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_SB_OVER_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_SB_OVER_RESERVED1_SHIFT))

#define  SCAN_PLL_CSSCG_SB_OVER_SB_OVERRIDE_MASK 0x1
#define  SCAN_PLL_CSSCG_SB_OVER_SB_OVERRIDE_SHIFT 0
#define  SCAN_PLL_CSSCG_SB_OVER_SB_OVERRIDE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_SB_OVER_SB_OVERRIDE_MASK) >> SCAN_PLL_CSSCG_SB_OVER_SB_OVERRIDE_SHIFT)
#define  SCAN_PLL_CSSCG_SB_OVER_SB_OVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_SB_OVER_SB_OVERRIDE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_SB_OVER_SB_OVERRIDE_SHIFT))

//====================================================================
//Register: CSSCG Control Register (CONTROL)
/** \brief This register is used to start/stop the CSSCG block.*/
//====================================================================

#define  SCAN_PLL_CSSCG_CONTROL_RESERVED1_MASK 0xfffffff8
#define  SCAN_PLL_CSSCG_CONTROL_RESERVED1_SHIFT 3
#define  SCAN_PLL_CSSCG_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_CONTROL_RESERVED1_MASK) >> SCAN_PLL_CSSCG_CONTROL_RESERVED1_SHIFT)
#define  SCAN_PLL_CSSCG_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_CONTROL_RESERVED1_SHIFT))

#define  SCAN_PLL_CSSCG_CONTROL_CSSCG_EXTERNAL_MUX_SEL_MASK 0x4
#define  SCAN_PLL_CSSCG_CONTROL_CSSCG_EXTERNAL_MUX_SEL_SHIFT 2
#define  SCAN_PLL_CSSCG_CONTROL_CSSCG_EXTERNAL_MUX_SEL_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_CONTROL_CSSCG_EXTERNAL_MUX_SEL_MASK) >> SCAN_PLL_CSSCG_CONTROL_CSSCG_EXTERNAL_MUX_SEL_SHIFT)
#define  SCAN_PLL_CSSCG_CONTROL_CSSCG_EXTERNAL_MUX_SEL_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_CONTROL_CSSCG_EXTERNAL_MUX_SEL_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_CONTROL_CSSCG_EXTERNAL_MUX_SEL_SHIFT))

#define  SCAN_PLL_CSSCG_CONTROL_HALT_EN_MASK 0x2
#define  SCAN_PLL_CSSCG_CONTROL_HALT_EN_SHIFT 1
#define  SCAN_PLL_CSSCG_CONTROL_HALT_EN_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_CONTROL_HALT_EN_MASK) >> SCAN_PLL_CSSCG_CONTROL_HALT_EN_SHIFT)
#define  SCAN_PLL_CSSCG_CONTROL_HALT_EN_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_CONTROL_HALT_EN_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_CONTROL_HALT_EN_SHIFT))

#define  SCAN_PLL_CSSCG_CONTROL_CSSCG_ENABLE_MASK 0x1
#define  SCAN_PLL_CSSCG_CONTROL_CSSCG_ENABLE_SHIFT 0
#define  SCAN_PLL_CSSCG_CONTROL_CSSCG_ENABLE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_CONTROL_CSSCG_ENABLE_MASK) >> SCAN_PLL_CSSCG_CONTROL_CSSCG_ENABLE_SHIFT)
#define  SCAN_PLL_CSSCG_CONTROL_CSSCG_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_CONTROL_CSSCG_ENABLE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_CONTROL_CSSCG_ENABLE_SHIFT))

//====================================================================
//Register: CSSCG Master Sync Status Register (STATUS_MST_SYNC)
/** \brief This register provides the internal status of the block when in Master Sync Mode. It can be used to determine when a halt has completed. It can also be used for debug purposes.*/
//====================================================================

#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_RESERVED1_MASK 0x80000000
#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_RESERVED1_SHIFT 31
#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_STATUS_MST_SYNC_RESERVED1_MASK) >> SCAN_PLL_CSSCG_STATUS_MST_SYNC_RESERVED1_SHIFT)
#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_STATUS_MST_SYNC_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_STATUS_MST_SYNC_RESERVED1_SHIFT))

#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_MST_STATE_MASK 0x70000000
#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_MST_STATE_SHIFT 28
#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_MST_STATE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_STATUS_MST_SYNC_MST_STATE_MASK) >> SCAN_PLL_CSSCG_STATUS_MST_SYNC_MST_STATE_SHIFT)
#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_MST_STATE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_STATUS_MST_SYNC_MST_STATE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_STATUS_MST_SYNC_MST_STATE_SHIFT))

#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_RESERVED2_MASK 0xffffc00
#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_RESERVED2_SHIFT 10
#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_RESERVED2_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_STATUS_MST_SYNC_RESERVED2_MASK) >> SCAN_PLL_CSSCG_STATUS_MST_SYNC_RESERVED2_SHIFT)
#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_STATUS_MST_SYNC_RESERVED2_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_STATUS_MST_SYNC_RESERVED2_SHIFT))

#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_CURRENT_ADDR_MASK 0x3f0
#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_CURRENT_ADDR_SHIFT 4
#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_CURRENT_ADDR_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_STATUS_MST_SYNC_CURRENT_ADDR_MASK) >> SCAN_PLL_CSSCG_STATUS_MST_SYNC_CURRENT_ADDR_SHIFT)
#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_CURRENT_ADDR_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_STATUS_MST_SYNC_CURRENT_ADDR_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_STATUS_MST_SYNC_CURRENT_ADDR_SHIFT))

#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_RESERVED3_MASK 0xc
#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_RESERVED3_SHIFT 2
#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_RESERVED3_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_STATUS_MST_SYNC_RESERVED3_MASK) >> SCAN_PLL_CSSCG_STATUS_MST_SYNC_RESERVED3_SHIFT)
#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_STATUS_MST_SYNC_RESERVED3_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_STATUS_MST_SYNC_RESERVED3_SHIFT))

#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_HALTED_MASK 0x2
#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_HALTED_SHIFT 1
#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_HALTED_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_STATUS_MST_SYNC_HALTED_MASK) >> SCAN_PLL_CSSCG_STATUS_MST_SYNC_HALTED_SHIFT)
#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_HALTED_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_STATUS_MST_SYNC_HALTED_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_STATUS_MST_SYNC_HALTED_SHIFT))

#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_ACTIVE_MASK 0x1
#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_ACTIVE_SHIFT 0
#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_ACTIVE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_STATUS_MST_SYNC_ACTIVE_MASK) >> SCAN_PLL_CSSCG_STATUS_MST_SYNC_ACTIVE_SHIFT)
#define  SCAN_PLL_CSSCG_STATUS_MST_SYNC_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_STATUS_MST_SYNC_ACTIVE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_STATUS_MST_SYNC_ACTIVE_SHIFT))

//====================================================================
//Register: CSSCG Slave Sync Status Register 0 (STATUS_SLV_SYNC_0)
/** \brief This register provides the internal status of the block when in Slave Sync Mode. It can be used to determine when a halt has completed. It can also be used for debug purposes.*/
//====================================================================

#define  SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED1_MASK 0xfffc0000
#define  SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED1_SHIFT 18
#define  SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED1_MASK) >> SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED1_SHIFT)
#define  SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED1_SHIFT))

#define  SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_CURRENT_ADDR_MASK 0x3f000
#define  SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_CURRENT_ADDR_SHIFT 12
#define  SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_CURRENT_ADDR_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_CURRENT_ADDR_MASK) >> SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_CURRENT_ADDR_SHIFT)
#define  SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_CURRENT_ADDR_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_CURRENT_ADDR_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_CURRENT_ADDR_SHIFT))

#define  SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED2_MASK 0xf80
#define  SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED2_SHIFT 7
#define  SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED2_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED2_MASK) >> SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED2_SHIFT)
#define  SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED2_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_RESERVED2_SHIFT))

#define  SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_SLV_STATE_MASK 0x7c
#define  SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_SLV_STATE_SHIFT 2
#define  SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_SLV_STATE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_SLV_STATE_MASK) >> SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_SLV_STATE_SHIFT)
#define  SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_SLV_STATE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_SLV_STATE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_SLV_STATE_SHIFT))

#define  SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_HALTED_MASK 0x2
#define  SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_HALTED_SHIFT 1
#define  SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_HALTED_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_HALTED_MASK) >> SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_HALTED_SHIFT)
#define  SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_HALTED_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_HALTED_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_HALTED_SHIFT))

#define  SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_ACTIVE_MASK 0x1
#define  SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_ACTIVE_SHIFT 0
#define  SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_ACTIVE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_ACTIVE_MASK) >> SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_ACTIVE_SHIFT)
#define  SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_ACTIVE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_STATUS_SLV_SYNC_0_ACTIVE_SHIFT))

//====================================================================
//Register: CSSCG Code Status (STATUS_CODE)
/** \brief This register provides the status of current code being sent to the PLL. Used in both master and slave sync mode debug.*/
//====================================================================

#define  SCAN_PLL_CSSCG_STATUS_CODE_NEWCODE_UPDATE_MASK 0x80000000
#define  SCAN_PLL_CSSCG_STATUS_CODE_NEWCODE_UPDATE_SHIFT 31
#define  SCAN_PLL_CSSCG_STATUS_CODE_NEWCODE_UPDATE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_STATUS_CODE_NEWCODE_UPDATE_MASK) >> SCAN_PLL_CSSCG_STATUS_CODE_NEWCODE_UPDATE_SHIFT)
#define  SCAN_PLL_CSSCG_STATUS_CODE_NEWCODE_UPDATE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_STATUS_CODE_NEWCODE_UPDATE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_STATUS_CODE_NEWCODE_UPDATE_SHIFT))

#define  SCAN_PLL_CSSCG_STATUS_CODE_RESERVED1_MASK 0x7ffe0000
#define  SCAN_PLL_CSSCG_STATUS_CODE_RESERVED1_SHIFT 17
#define  SCAN_PLL_CSSCG_STATUS_CODE_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_STATUS_CODE_RESERVED1_MASK) >> SCAN_PLL_CSSCG_STATUS_CODE_RESERVED1_SHIFT)
#define  SCAN_PLL_CSSCG_STATUS_CODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_STATUS_CODE_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_STATUS_CODE_RESERVED1_SHIFT))

#define  SCAN_PLL_CSSCG_STATUS_CODE_NEWCODE_MASK 0x1ffff
#define  SCAN_PLL_CSSCG_STATUS_CODE_NEWCODE_SHIFT 0
#define  SCAN_PLL_CSSCG_STATUS_CODE_NEWCODE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_STATUS_CODE_NEWCODE_MASK) >> SCAN_PLL_CSSCG_STATUS_CODE_NEWCODE_SHIFT)
#define  SCAN_PLL_CSSCG_STATUS_CODE_NEWCODE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_STATUS_CODE_NEWCODE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_STATUS_CODE_NEWCODE_SHIFT))

//====================================================================
//Register: CSSCG Config A Slave Mode Full Cycle Count Config (SLV_N_FULL_A)
/** \brief This register defines how many full cycles the CSSCG will perform in slave sync mode for configuration A.*/
//====================================================================

#define  SCAN_PLL_CSSCG_SLV_N_FULL_A_SLV_N_FULL_MASK 0xffffffff
#define  SCAN_PLL_CSSCG_SLV_N_FULL_A_SLV_N_FULL_SHIFT 0
#define  SCAN_PLL_CSSCG_SLV_N_FULL_A_SLV_N_FULL_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_SLV_N_FULL_A_SLV_N_FULL_MASK) >> SCAN_PLL_CSSCG_SLV_N_FULL_A_SLV_N_FULL_SHIFT)
#define  SCAN_PLL_CSSCG_SLV_N_FULL_A_SLV_N_FULL_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_SLV_N_FULL_A_SLV_N_FULL_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_SLV_N_FULL_A_SLV_N_FULL_SHIFT))

//====================================================================
//Register: CSSCG Config A Slave Mode End Configuration Register (SLV_END_CONFIG_A)
/** \brief This register defines the phase and table entry upon which it will halt the "partial phase"
      after all of the full phases for configuration A.*/
//====================================================================

#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED1_MASK 0xfffc0000
#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED1_SHIFT 18
#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED1_MASK) >> SCAN_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED1_SHIFT)
#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED1_SHIFT))

#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_PHASE_MASK 0x30000
#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_PHASE_SHIFT 16
#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_PHASE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_PHASE_MASK) >> SCAN_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_PHASE_SHIFT)
#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_PHASE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_PHASE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_PHASE_SHIFT))

#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED2_MASK 0xffc0
#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED2_SHIFT 6
#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED2_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED2_MASK) >> SCAN_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED2_SHIFT)
#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED2_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_SLV_END_CONFIG_A_RESERVED2_SHIFT))

#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_ADDR_MASK 0x3f
#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_ADDR_SHIFT 0
#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_ADDR_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_ADDR_MASK) >> SCAN_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_ADDR_SHIFT)
#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_ADDR_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_ADDR_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_SLV_END_CONFIG_A_SLV_END_ADDR_SHIFT))

//====================================================================
//Register: CSSCG Config A Slave Mode Return-to-Zero Register (SLV_RTZ_A)
/** \brief This register controls how the block will linearly return-to-zero
      after the partial phase for configuration A.*/
//====================================================================

#define  SCAN_PLL_CSSCG_SLV_RTZ_A_RESERVED1_MASK 0xffff0000
#define  SCAN_PLL_CSSCG_SLV_RTZ_A_RESERVED1_SHIFT 16
#define  SCAN_PLL_CSSCG_SLV_RTZ_A_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_SLV_RTZ_A_RESERVED1_MASK) >> SCAN_PLL_CSSCG_SLV_RTZ_A_RESERVED1_SHIFT)
#define  SCAN_PLL_CSSCG_SLV_RTZ_A_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_SLV_RTZ_A_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_SLV_RTZ_A_RESERVED1_SHIFT))

#define  SCAN_PLL_CSSCG_SLV_RTZ_A_RTZ_STEP_SIZE_MASK 0xffff
#define  SCAN_PLL_CSSCG_SLV_RTZ_A_RTZ_STEP_SIZE_SHIFT 0
#define  SCAN_PLL_CSSCG_SLV_RTZ_A_RTZ_STEP_SIZE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_SLV_RTZ_A_RTZ_STEP_SIZE_MASK) >> SCAN_PLL_CSSCG_SLV_RTZ_A_RTZ_STEP_SIZE_SHIFT)
#define  SCAN_PLL_CSSCG_SLV_RTZ_A_RTZ_STEP_SIZE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_SLV_RTZ_A_RTZ_STEP_SIZE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_SLV_RTZ_A_RTZ_STEP_SIZE_SHIFT))

//====================================================================
//Register: CSSCG Config B Slave Mode Full Cycle Count Config (SLV_N_FULL_B)
/** \brief This register defines how many full cycles the CSSCG will perform in slave sync mode for configuration B.*/
//====================================================================

#define  SCAN_PLL_CSSCG_SLV_N_FULL_B_SLV_N_FULL_MASK 0xffffffff
#define  SCAN_PLL_CSSCG_SLV_N_FULL_B_SLV_N_FULL_SHIFT 0
#define  SCAN_PLL_CSSCG_SLV_N_FULL_B_SLV_N_FULL_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_SLV_N_FULL_B_SLV_N_FULL_MASK) >> SCAN_PLL_CSSCG_SLV_N_FULL_B_SLV_N_FULL_SHIFT)
#define  SCAN_PLL_CSSCG_SLV_N_FULL_B_SLV_N_FULL_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_SLV_N_FULL_B_SLV_N_FULL_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_SLV_N_FULL_B_SLV_N_FULL_SHIFT))

//====================================================================
//Register: CSSCG Config B Slave Mode End Configuration Register (SLV_END_CONFIG_B)
/** \brief This register defines the phase and table entry upon which it will halt the "partial phase"
      after all of the full phases for configuration B.*/
//====================================================================

#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED1_MASK 0xfffc0000
#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED1_SHIFT 18
#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED1_MASK) >> SCAN_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED1_SHIFT)
#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED1_SHIFT))

#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_PHASE_MASK 0x30000
#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_PHASE_SHIFT 16
#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_PHASE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_PHASE_MASK) >> SCAN_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_PHASE_SHIFT)
#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_PHASE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_PHASE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_PHASE_SHIFT))

#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED2_MASK 0xffc0
#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED2_SHIFT 6
#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED2_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED2_MASK) >> SCAN_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED2_SHIFT)
#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED2_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_SLV_END_CONFIG_B_RESERVED2_SHIFT))

#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_ADDR_MASK 0x3f
#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_ADDR_SHIFT 0
#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_ADDR_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_ADDR_MASK) >> SCAN_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_ADDR_SHIFT)
#define  SCAN_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_ADDR_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_ADDR_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_SLV_END_CONFIG_B_SLV_END_ADDR_SHIFT))

//====================================================================
//Register: CSSCG Config B Slave Mode Return-to-Zero Register (SLV_RTZ_B)
/** \brief This register controls how the block will linearly return-to-zero
      after the partial phase for configuration B.*/
//====================================================================

#define  SCAN_PLL_CSSCG_SLV_RTZ_B_RESERVED1_MASK 0xffff0000
#define  SCAN_PLL_CSSCG_SLV_RTZ_B_RESERVED1_SHIFT 16
#define  SCAN_PLL_CSSCG_SLV_RTZ_B_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_SLV_RTZ_B_RESERVED1_MASK) >> SCAN_PLL_CSSCG_SLV_RTZ_B_RESERVED1_SHIFT)
#define  SCAN_PLL_CSSCG_SLV_RTZ_B_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_SLV_RTZ_B_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_SLV_RTZ_B_RESERVED1_SHIFT))

#define  SCAN_PLL_CSSCG_SLV_RTZ_B_RTZ_STEP_SIZE_MASK 0xffff
#define  SCAN_PLL_CSSCG_SLV_RTZ_B_RTZ_STEP_SIZE_SHIFT 0
#define  SCAN_PLL_CSSCG_SLV_RTZ_B_RTZ_STEP_SIZE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_SLV_RTZ_B_RTZ_STEP_SIZE_MASK) >> SCAN_PLL_CSSCG_SLV_RTZ_B_RTZ_STEP_SIZE_SHIFT)
#define  SCAN_PLL_CSSCG_SLV_RTZ_B_RTZ_STEP_SIZE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_SLV_RTZ_B_RTZ_STEP_SIZE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_SLV_RTZ_B_RTZ_STEP_SIZE_SHIFT))

//====================================================================
//Register: CSSCG Slave Mode Trigger Select Register (SLV_TRIG_SEL)
/** \brief This register selects and optionally inverts the input trigger.*/
//====================================================================

#define  SCAN_PLL_CSSCG_SLV_TRIG_SEL_TRIG_INV_MASK 0xffff0000
#define  SCAN_PLL_CSSCG_SLV_TRIG_SEL_TRIG_INV_SHIFT 16
#define  SCAN_PLL_CSSCG_SLV_TRIG_SEL_TRIG_INV_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_SLV_TRIG_SEL_TRIG_INV_MASK) >> SCAN_PLL_CSSCG_SLV_TRIG_SEL_TRIG_INV_SHIFT)
#define  SCAN_PLL_CSSCG_SLV_TRIG_SEL_TRIG_INV_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_SLV_TRIG_SEL_TRIG_INV_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_SLV_TRIG_SEL_TRIG_INV_SHIFT))

#define  SCAN_PLL_CSSCG_SLV_TRIG_SEL_TRIG_MASK_MASK 0xffff
#define  SCAN_PLL_CSSCG_SLV_TRIG_SEL_TRIG_MASK_SHIFT 0
#define  SCAN_PLL_CSSCG_SLV_TRIG_SEL_TRIG_MASK_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_SLV_TRIG_SEL_TRIG_MASK_MASK) >> SCAN_PLL_CSSCG_SLV_TRIG_SEL_TRIG_MASK_SHIFT)
#define  SCAN_PLL_CSSCG_SLV_TRIG_SEL_TRIG_MASK_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_SLV_TRIG_SEL_TRIG_MASK_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_SLV_TRIG_SEL_TRIG_MASK_SHIFT))

//====================================================================
//Register: CSSCG Slave Mode Timeout Register (SLV_TIMEOUT)
/** \brief This register controls how long the block will wait after a standard line prior to going into initial sync phase again. Note: These clock ticks are defined as the number divided-down VCO_DIV_CLK clocks (where the divide is programmed by rate_div_m1).*/
//====================================================================

#define  SCAN_PLL_CSSCG_SLV_TIMEOUT_TIMEOUT_MASK 0xffffffff
#define  SCAN_PLL_CSSCG_SLV_TIMEOUT_TIMEOUT_SHIFT 0
#define  SCAN_PLL_CSSCG_SLV_TIMEOUT_TIMEOUT_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_SLV_TIMEOUT_TIMEOUT_MASK) >> SCAN_PLL_CSSCG_SLV_TIMEOUT_TIMEOUT_SHIFT)
#define  SCAN_PLL_CSSCG_SLV_TIMEOUT_TIMEOUT_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_SLV_TIMEOUT_TIMEOUT_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_SLV_TIMEOUT_TIMEOUT_SHIFT))

//====================================================================
//Register: CSSCG Slave Mode Debug 0 Register (SLV_DEBUG_0)
/** \brief This register is used to help debug Slave Sync mode.*/
//====================================================================

#define  SCAN_PLL_CSSCG_SLV_DEBUG_0_RESERVED1_MASK 0xfffffffc
#define  SCAN_PLL_CSSCG_SLV_DEBUG_0_RESERVED1_SHIFT 2
#define  SCAN_PLL_CSSCG_SLV_DEBUG_0_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_SLV_DEBUG_0_RESERVED1_MASK) >> SCAN_PLL_CSSCG_SLV_DEBUG_0_RESERVED1_SHIFT)
#define  SCAN_PLL_CSSCG_SLV_DEBUG_0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_SLV_DEBUG_0_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_SLV_DEBUG_0_RESERVED1_SHIFT))

#define  SCAN_PLL_CSSCG_SLV_DEBUG_0_SLV_SYNC_DEBUG_MODE_MASK 0x3
#define  SCAN_PLL_CSSCG_SLV_DEBUG_0_SLV_SYNC_DEBUG_MODE_SHIFT 0
#define  SCAN_PLL_CSSCG_SLV_DEBUG_0_SLV_SYNC_DEBUG_MODE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_SLV_DEBUG_0_SLV_SYNC_DEBUG_MODE_MASK) >> SCAN_PLL_CSSCG_SLV_DEBUG_0_SLV_SYNC_DEBUG_MODE_SHIFT)
#define  SCAN_PLL_CSSCG_SLV_DEBUG_0_SLV_SYNC_DEBUG_MODE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_SLV_DEBUG_0_SLV_SYNC_DEBUG_MODE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_SLV_DEBUG_0_SLV_SYNC_DEBUG_MODE_SHIFT))

//====================================================================
//Register: CSSCG Slave Mode Debug 1 Register (SLV_DEBUG_1)
/** \brief This register is used to help debug Slave Sync mode.*/
//====================================================================

#define  SCAN_PLL_CSSCG_SLV_DEBUG_1_RESERVED1_MASK 0xfffffffe
#define  SCAN_PLL_CSSCG_SLV_DEBUG_1_RESERVED1_SHIFT 1
#define  SCAN_PLL_CSSCG_SLV_DEBUG_1_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_SLV_DEBUG_1_RESERVED1_MASK) >> SCAN_PLL_CSSCG_SLV_DEBUG_1_RESERVED1_SHIFT)
#define  SCAN_PLL_CSSCG_SLV_DEBUG_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_SLV_DEBUG_1_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_SLV_DEBUG_1_RESERVED1_SHIFT))

#define  SCAN_PLL_CSSCG_SLV_DEBUG_1_TRIG_FORCE_MASK 0x1
#define  SCAN_PLL_CSSCG_SLV_DEBUG_1_TRIG_FORCE_SHIFT 0
#define  SCAN_PLL_CSSCG_SLV_DEBUG_1_TRIG_FORCE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_SLV_DEBUG_1_TRIG_FORCE_MASK) >> SCAN_PLL_CSSCG_SLV_DEBUG_1_TRIG_FORCE_SHIFT)
#define  SCAN_PLL_CSSCG_SLV_DEBUG_1_TRIG_FORCE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_SLV_DEBUG_1_TRIG_FORCE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_SLV_DEBUG_1_TRIG_FORCE_SHIFT))

//====================================================================
//Register: CSSCG Trigger Debug 0 Register (TRIG_DEBUG_0)
/** \brief This register is used to help debug Slave Sync mode trigger timing. Use this register to clear the other Trigger Debug registers.*/
//====================================================================

#define  SCAN_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_RESET_MASK 0x80000000
#define  SCAN_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_RESET_SHIFT 31
#define  SCAN_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_RESET_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_RESET_MASK) >> SCAN_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_RESET_SHIFT)
#define  SCAN_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_RESET_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_RESET_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_RESET_SHIFT))

#define  SCAN_PLL_CSSCG_TRIG_DEBUG_0_RESERVED1_MASK 0x7ffffffc
#define  SCAN_PLL_CSSCG_TRIG_DEBUG_0_RESERVED1_SHIFT 2
#define  SCAN_PLL_CSSCG_TRIG_DEBUG_0_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_TRIG_DEBUG_0_RESERVED1_MASK) >> SCAN_PLL_CSSCG_TRIG_DEBUG_0_RESERVED1_SHIFT)
#define  SCAN_PLL_CSSCG_TRIG_DEBUG_0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_TRIG_DEBUG_0_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_TRIG_DEBUG_0_RESERVED1_SHIFT))

#define  SCAN_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_FREERUN_MASK 0x2
#define  SCAN_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_FREERUN_SHIFT 1
#define  SCAN_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_FREERUN_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_FREERUN_MASK) >> SCAN_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_FREERUN_SHIFT)
#define  SCAN_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_FREERUN_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_FREERUN_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_FREERUN_SHIFT))

#define  SCAN_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_ENABLE_MASK 0x1
#define  SCAN_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_ENABLE_SHIFT 0
#define  SCAN_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_ENABLE_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_ENABLE_MASK) >> SCAN_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_ENABLE_SHIFT)
#define  SCAN_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_ENABLE_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_TRIG_DEBUG_0_TRIG_DEBUG_ENABLE_SHIFT))

//====================================================================
//Register: CSSCG Trigger Debug 1 Register (TRIG_DEBUG_1)
/** \brief This register is used to help debug Slave Sync mode trigger timing. Specifically, this register provides the minimum time seen between triggers (in VCO_DIV_CLK clocks).*/
//====================================================================

#define  SCAN_PLL_CSSCG_TRIG_DEBUG_1_TRIG_MIN_PERIOD_MASK 0xffffffff
#define  SCAN_PLL_CSSCG_TRIG_DEBUG_1_TRIG_MIN_PERIOD_SHIFT 0
#define  SCAN_PLL_CSSCG_TRIG_DEBUG_1_TRIG_MIN_PERIOD_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_TRIG_DEBUG_1_TRIG_MIN_PERIOD_MASK) >> SCAN_PLL_CSSCG_TRIG_DEBUG_1_TRIG_MIN_PERIOD_SHIFT)
#define  SCAN_PLL_CSSCG_TRIG_DEBUG_1_TRIG_MIN_PERIOD_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_TRIG_DEBUG_1_TRIG_MIN_PERIOD_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_TRIG_DEBUG_1_TRIG_MIN_PERIOD_SHIFT))

//====================================================================
//Register: CSSCG Trigger Debug 2 Register (TRIG_DEBUG_2)
/** \brief This register is used to help debug Slave Sync mode trigger timing. Specifically, this register provides the maximum time seen between triggers (in VCO_DIV_CLK clocks).*/
//====================================================================

#define  SCAN_PLL_CSSCG_TRIG_DEBUG_2_TRIG_MAX_PERIOD_MASK 0xffffffff
#define  SCAN_PLL_CSSCG_TRIG_DEBUG_2_TRIG_MAX_PERIOD_SHIFT 0
#define  SCAN_PLL_CSSCG_TRIG_DEBUG_2_TRIG_MAX_PERIOD_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_TRIG_DEBUG_2_TRIG_MAX_PERIOD_MASK) >> SCAN_PLL_CSSCG_TRIG_DEBUG_2_TRIG_MAX_PERIOD_SHIFT)
#define  SCAN_PLL_CSSCG_TRIG_DEBUG_2_TRIG_MAX_PERIOD_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_TRIG_DEBUG_2_TRIG_MAX_PERIOD_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_TRIG_DEBUG_2_TRIG_MAX_PERIOD_SHIFT))

//====================================================================
//Register: CSSCG Trigger Debug 3 Register (TRIG_DEBUG_3)
/** \brief This register is used to help debug Slave Sync mode trigger timing. Specifically, this register provides the number of triggers seen (including the first used to synchronize).*/
//====================================================================

#define  SCAN_PLL_CSSCG_TRIG_DEBUG_3_TRIG_COUNT_MASK 0xffffffff
#define  SCAN_PLL_CSSCG_TRIG_DEBUG_3_TRIG_COUNT_SHIFT 0
#define  SCAN_PLL_CSSCG_TRIG_DEBUG_3_TRIG_COUNT_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_TRIG_DEBUG_3_TRIG_COUNT_MASK) >> SCAN_PLL_CSSCG_TRIG_DEBUG_3_TRIG_COUNT_SHIFT)
#define  SCAN_PLL_CSSCG_TRIG_DEBUG_3_TRIG_COUNT_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_TRIG_DEBUG_3_TRIG_COUNT_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_TRIG_DEBUG_3_TRIG_COUNT_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  SCAN_PLL_CSSCG_REV0_MAJ_MASK 0xffff0000
#define  SCAN_PLL_CSSCG_REV0_MAJ_SHIFT 16
#define  SCAN_PLL_CSSCG_REV0_MAJ_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_REV0_MAJ_MASK) >> SCAN_PLL_CSSCG_REV0_MAJ_SHIFT)
#define  SCAN_PLL_CSSCG_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_REV0_MAJ_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_REV0_MAJ_SHIFT))

#define  SCAN_PLL_CSSCG_REV0_MID_MASK 0xffff
#define  SCAN_PLL_CSSCG_REV0_MID_SHIFT 0
#define  SCAN_PLL_CSSCG_REV0_MID_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_REV0_MID_MASK) >> SCAN_PLL_CSSCG_REV0_MID_SHIFT)
#define  SCAN_PLL_CSSCG_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_REV0_MID_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  SCAN_PLL_CSSCG_REV1_RESERVED1_MASK 0xffff0000
#define  SCAN_PLL_CSSCG_REV1_RESERVED1_SHIFT 16
#define  SCAN_PLL_CSSCG_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_REV1_RESERVED1_MASK) >> SCAN_PLL_CSSCG_REV1_RESERVED1_SHIFT)
#define  SCAN_PLL_CSSCG_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_REV1_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_REV1_RESERVED1_SHIFT))

#define  SCAN_PLL_CSSCG_REV1_CFG_MASK 0xffff
#define  SCAN_PLL_CSSCG_REV1_CFG_SHIFT 0
#define  SCAN_PLL_CSSCG_REV1_CFG_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_REV1_CFG_MASK) >> SCAN_PLL_CSSCG_REV1_CFG_SHIFT)
#define  SCAN_PLL_CSSCG_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_REV1_CFG_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_REV1_CFG_SHIFT))

//====================================================================
//Register: CSSCG RAM Access Register (CSSCG_RAM)
/** \brief The table used to define the dither shape. The values are unsigned "deltas." Therefore, the curve must be monotonic.*/
//====================================================================

#define  SCAN_PLL_CSSCG_CSSCG_RAM_RESERVED1_MASK 0xffff0000
#define  SCAN_PLL_CSSCG_CSSCG_RAM_RESERVED1_SHIFT 16
#define  SCAN_PLL_CSSCG_CSSCG_RAM_RESERVED1_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_CSSCG_RAM_RESERVED1_MASK) >> SCAN_PLL_CSSCG_CSSCG_RAM_RESERVED1_SHIFT)
#define  SCAN_PLL_CSSCG_CSSCG_RAM_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_CSSCG_RAM_RESERVED1_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_CSSCG_RAM_RESERVED1_SHIFT))

#define  SCAN_PLL_CSSCG_CSSCG_RAM_VAL_MASK 0xffff
#define  SCAN_PLL_CSSCG_CSSCG_RAM_VAL_SHIFT 0
#define  SCAN_PLL_CSSCG_CSSCG_RAM_VAL_MASK_SHIFT(reg) (((reg) & SCAN_PLL_CSSCG_CSSCG_RAM_VAL_MASK) >> SCAN_PLL_CSSCG_CSSCG_RAM_VAL_SHIFT)
#define  SCAN_PLL_CSSCG_CSSCG_RAM_VAL_REPLACE_VAL(reg,val) (((reg) & ~SCAN_PLL_CSSCG_CSSCG_RAM_VAL_MASK) | (((uint32_t)val) << SCAN_PLL_CSSCG_CSSCG_RAM_VAL_SHIFT))

//====================================================================
//
//Register File: LVDSAFE PLL0 Controls (LVDSAFE_PLL0)
//
//====================================================================

//====================================================================
//Register: PLL reset & Pre-divider Register (rst_prediv)
/** \brief RESET, 1 = PLL in reset
           0 = PLL in normal mode
    RESET_SSC, 1 = SSC and Freq Offset in reset
               0 = SSC and Freq Offset operating mode
    RESET_PI, 1 = External Interpolator in reset
               0 = operating mode*/
//====================================================================

#define  LVDSAFE_PLL0_RST_PREDIV_RESERVED1_MASK 0xfff80000
#define  LVDSAFE_PLL0_RST_PREDIV_RESERVED1_SHIFT 19
#define  LVDSAFE_PLL0_RST_PREDIV_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_RST_PREDIV_RESERVED1_MASK) >> LVDSAFE_PLL0_RST_PREDIV_RESERVED1_SHIFT)
#define  LVDSAFE_PLL0_RST_PREDIV_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_RST_PREDIV_RESERVED1_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_RST_PREDIV_RESERVED1_SHIFT))

#define  LVDSAFE_PLL0_RST_PREDIV_RESET_PI_MASK 0x40000
#define  LVDSAFE_PLL0_RST_PREDIV_RESET_PI_SHIFT 18
#define  LVDSAFE_PLL0_RST_PREDIV_RESET_PI_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_RST_PREDIV_RESET_PI_MASK) >> LVDSAFE_PLL0_RST_PREDIV_RESET_PI_SHIFT)
#define  LVDSAFE_PLL0_RST_PREDIV_RESET_PI_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_RST_PREDIV_RESET_PI_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_RST_PREDIV_RESET_PI_SHIFT))

#define  LVDSAFE_PLL0_RST_PREDIV_RESET_SSC_MASK 0x20000
#define  LVDSAFE_PLL0_RST_PREDIV_RESET_SSC_SHIFT 17
#define  LVDSAFE_PLL0_RST_PREDIV_RESET_SSC_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_RST_PREDIV_RESET_SSC_MASK) >> LVDSAFE_PLL0_RST_PREDIV_RESET_SSC_SHIFT)
#define  LVDSAFE_PLL0_RST_PREDIV_RESET_SSC_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_RST_PREDIV_RESET_SSC_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_RST_PREDIV_RESET_SSC_SHIFT))

#define  LVDSAFE_PLL0_RST_PREDIV_RESET_MASK 0x10000
#define  LVDSAFE_PLL0_RST_PREDIV_RESET_SHIFT 16
#define  LVDSAFE_PLL0_RST_PREDIV_RESET_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_RST_PREDIV_RESET_MASK) >> LVDSAFE_PLL0_RST_PREDIV_RESET_SHIFT)
#define  LVDSAFE_PLL0_RST_PREDIV_RESET_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_RST_PREDIV_RESET_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_RST_PREDIV_RESET_SHIFT))

#define  LVDSAFE_PLL0_RST_PREDIV_RESERVED2_MASK 0xfe00
#define  LVDSAFE_PLL0_RST_PREDIV_RESERVED2_SHIFT 9
#define  LVDSAFE_PLL0_RST_PREDIV_RESERVED2_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_RST_PREDIV_RESERVED2_MASK) >> LVDSAFE_PLL0_RST_PREDIV_RESERVED2_SHIFT)
#define  LVDSAFE_PLL0_RST_PREDIV_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_RST_PREDIV_RESERVED2_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_RST_PREDIV_RESERVED2_SHIFT))

#define  LVDSAFE_PLL0_RST_PREDIV_REFDIV_MASK 0x1ff
#define  LVDSAFE_PLL0_RST_PREDIV_REFDIV_SHIFT 0
#define  LVDSAFE_PLL0_RST_PREDIV_REFDIV_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_RST_PREDIV_REFDIV_MASK) >> LVDSAFE_PLL0_RST_PREDIV_REFDIV_SHIFT)
#define  LVDSAFE_PLL0_RST_PREDIV_REFDIV_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_RST_PREDIV_REFDIV_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_RST_PREDIV_REFDIV_SHIFT))

//====================================================================
//Register: PLL feedback multiplier (mult_postdiv)
/** \brief PLL multiplication factor after pre-divide.*/
//====================================================================

#define  LVDSAFE_PLL0_MULT_POSTDIV_RESERVED1_MASK 0xfe000000
#define  LVDSAFE_PLL0_MULT_POSTDIV_RESERVED1_SHIFT 25
#define  LVDSAFE_PLL0_MULT_POSTDIV_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_MULT_POSTDIV_RESERVED1_MASK) >> LVDSAFE_PLL0_MULT_POSTDIV_RESERVED1_SHIFT)
#define  LVDSAFE_PLL0_MULT_POSTDIV_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_MULT_POSTDIV_RESERVED1_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_MULT_POSTDIV_RESERVED1_SHIFT))

#define  LVDSAFE_PLL0_MULT_POSTDIV_FBDIV_MASK 0x1ff0000
#define  LVDSAFE_PLL0_MULT_POSTDIV_FBDIV_SHIFT 16
#define  LVDSAFE_PLL0_MULT_POSTDIV_FBDIV_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_MULT_POSTDIV_FBDIV_MASK) >> LVDSAFE_PLL0_MULT_POSTDIV_FBDIV_SHIFT)
#define  LVDSAFE_PLL0_MULT_POSTDIV_FBDIV_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_MULT_POSTDIV_FBDIV_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_MULT_POSTDIV_FBDIV_SHIFT))

#define  LVDSAFE_PLL0_MULT_POSTDIV_RESERVED2_MASK 0xf800
#define  LVDSAFE_PLL0_MULT_POSTDIV_RESERVED2_SHIFT 11
#define  LVDSAFE_PLL0_MULT_POSTDIV_RESERVED2_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_MULT_POSTDIV_RESERVED2_MASK) >> LVDSAFE_PLL0_MULT_POSTDIV_RESERVED2_SHIFT)
#define  LVDSAFE_PLL0_MULT_POSTDIV_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_MULT_POSTDIV_RESERVED2_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_MULT_POSTDIV_RESERVED2_SHIFT))

#define  LVDSAFE_PLL0_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK 0x700
#define  LVDSAFE_PLL0_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_SHIFT 8
#define  LVDSAFE_PLL0_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK) >> LVDSAFE_PLL0_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_SHIFT)
#define  LVDSAFE_PLL0_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_SHIFT))

#define  LVDSAFE_PLL0_MULT_POSTDIV_RESERVED3_MASK 0xf8
#define  LVDSAFE_PLL0_MULT_POSTDIV_RESERVED3_SHIFT 3
#define  LVDSAFE_PLL0_MULT_POSTDIV_RESERVED3_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_MULT_POSTDIV_RESERVED3_MASK) >> LVDSAFE_PLL0_MULT_POSTDIV_RESERVED3_SHIFT)
#define  LVDSAFE_PLL0_MULT_POSTDIV_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_MULT_POSTDIV_RESERVED3_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_MULT_POSTDIV_RESERVED3_SHIFT))

#define  LVDSAFE_PLL0_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK 0x7
#define  LVDSAFE_PLL0_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_SHIFT 0
#define  LVDSAFE_PLL0_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK) >> LVDSAFE_PLL0_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_SHIFT)
#define  LVDSAFE_PLL0_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_SHIFT))

//====================================================================
//Register: PLL gain control (kvco)
/** \brief PLL gain control.*/
//====================================================================

#define  LVDSAFE_PLL0_KVCO_RESERVED1_MASK 0xfffffff0
#define  LVDSAFE_PLL0_KVCO_RESERVED1_SHIFT 4
#define  LVDSAFE_PLL0_KVCO_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_KVCO_RESERVED1_MASK) >> LVDSAFE_PLL0_KVCO_RESERVED1_SHIFT)
#define  LVDSAFE_PLL0_KVCO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_KVCO_RESERVED1_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_KVCO_RESERVED1_SHIFT))

#define  LVDSAFE_PLL0_KVCO_KVCO_MASK 0xf
#define  LVDSAFE_PLL0_KVCO_KVCO_SHIFT 0
#define  LVDSAFE_PLL0_KVCO_KVCO_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_KVCO_KVCO_MASK) >> LVDSAFE_PLL0_KVCO_KVCO_SHIFT)
#define  LVDSAFE_PLL0_KVCO_KVCO_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_KVCO_KVCO_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_KVCO_KVCO_SHIFT))

//====================================================================
//Register: PLL misc control (misc)
/** \brief PLL misc control.*/
//====================================================================

#define  LVDSAFE_PLL0_MISC_RESERVED1_MASK 0xffff0000
#define  LVDSAFE_PLL0_MISC_RESERVED1_SHIFT 16
#define  LVDSAFE_PLL0_MISC_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_MISC_RESERVED1_MASK) >> LVDSAFE_PLL0_MISC_RESERVED1_SHIFT)
#define  LVDSAFE_PLL0_MISC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_MISC_RESERVED1_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_MISC_RESERVED1_SHIFT))

#define  LVDSAFE_PLL0_MISC_PLL_BW_SEL_MASK 0x8000
#define  LVDSAFE_PLL0_MISC_PLL_BW_SEL_SHIFT 15
#define  LVDSAFE_PLL0_MISC_PLL_BW_SEL_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_MISC_PLL_BW_SEL_MASK) >> LVDSAFE_PLL0_MISC_PLL_BW_SEL_SHIFT)
#define  LVDSAFE_PLL0_MISC_PLL_BW_SEL_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_MISC_PLL_BW_SEL_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_MISC_PLL_BW_SEL_SHIFT))

#define  LVDSAFE_PLL0_MISC_CTUNE_MASK 0x6000
#define  LVDSAFE_PLL0_MISC_CTUNE_SHIFT 13
#define  LVDSAFE_PLL0_MISC_CTUNE_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_MISC_CTUNE_MASK) >> LVDSAFE_PLL0_MISC_CTUNE_SHIFT)
#define  LVDSAFE_PLL0_MISC_CTUNE_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_MISC_CTUNE_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_MISC_CTUNE_SHIFT))

#define  LVDSAFE_PLL0_MISC_INTPI_MASK 0x1e00
#define  LVDSAFE_PLL0_MISC_INTPI_SHIFT 9
#define  LVDSAFE_PLL0_MISC_INTPI_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_MISC_INTPI_MASK) >> LVDSAFE_PLL0_MISC_INTPI_SHIFT)
#define  LVDSAFE_PLL0_MISC_INTPI_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_MISC_INTPI_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_MISC_INTPI_SHIFT))

#define  LVDSAFE_PLL0_MISC_ICP_MASK 0x1e0
#define  LVDSAFE_PLL0_MISC_ICP_SHIFT 5
#define  LVDSAFE_PLL0_MISC_ICP_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_MISC_ICP_MASK) >> LVDSAFE_PLL0_MISC_ICP_SHIFT)
#define  LVDSAFE_PLL0_MISC_ICP_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_MISC_ICP_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_MISC_ICP_SHIFT))

#define  LVDSAFE_PLL0_MISC_VDDM_MASK 0x18
#define  LVDSAFE_PLL0_MISC_VDDM_SHIFT 3
#define  LVDSAFE_PLL0_MISC_VDDM_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_MISC_VDDM_MASK) >> LVDSAFE_PLL0_MISC_VDDM_SHIFT)
#define  LVDSAFE_PLL0_MISC_VDDM_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_MISC_VDDM_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_MISC_VDDM_SHIFT))

#define  LVDSAFE_PLL0_MISC_VDDL_MASK 0x7
#define  LVDSAFE_PLL0_MISC_VDDL_SHIFT 0
#define  LVDSAFE_PLL0_MISC_VDDL_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_MISC_VDDL_MASK) >> LVDSAFE_PLL0_MISC_VDDL_SHIFT)
#define  LVDSAFE_PLL0_MISC_VDDL_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_MISC_VDDL_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_MISC_VDDL_SHIFT))

//====================================================================
//Register: PLL PFD (Phase Frequency Detector) input select, and de-skew application control (feedback_mode_deskew)
/** \brief PLL feedback mode control.*/
//====================================================================

#define  LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_RESERVED1_MASK 0xff800000
#define  LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_RESERVED1_SHIFT 23
#define  LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_RESERVED1_MASK) >> LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_RESERVED1_SHIFT)
#define  LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_RESERVED1_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_RESERVED1_SHIFT))

#define  LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_FBCDLY_MASK 0x7e0000
#define  LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_FBCDLY_SHIFT 17
#define  LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_FBCDLY_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_FBCDLY_MASK) >> LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_FBCDLY_SHIFT)
#define  LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_FBCDLY_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_FBCDLY_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_FBCDLY_SHIFT))

#define  LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK 0x10000
#define  LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_SHIFT 16
#define  LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK) >> LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_SHIFT)
#define  LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_SHIFT))

#define  LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_RESERVED2_MASK 0xffff
#define  LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_RESERVED2_SHIFT 0
#define  LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_RESERVED2_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_RESERVED2_MASK) >> LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_RESERVED2_SHIFT)
#define  LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_RESERVED2_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_FEEDBACK_MODE_DESKEW_RESERVED2_SHIFT))

//====================================================================
//Register: PLL offset frequency control (offset_mode)
/** \brief PLL offset frequency control.*/
//====================================================================

#define  LVDSAFE_PLL0_OFFSET_MODE_RESERVED1_MASK 0xf8000000
#define  LVDSAFE_PLL0_OFFSET_MODE_RESERVED1_SHIFT 27
#define  LVDSAFE_PLL0_OFFSET_MODE_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_OFFSET_MODE_RESERVED1_MASK) >> LVDSAFE_PLL0_OFFSET_MODE_RESERVED1_SHIFT)
#define  LVDSAFE_PLL0_OFFSET_MODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_OFFSET_MODE_RESERVED1_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_OFFSET_MODE_RESERVED1_SHIFT))

#define  LVDSAFE_PLL0_OFFSET_MODE_INTPR_MASK 0x7000000
#define  LVDSAFE_PLL0_OFFSET_MODE_INTPR_SHIFT 24
#define  LVDSAFE_PLL0_OFFSET_MODE_INTPR_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_OFFSET_MODE_INTPR_MASK) >> LVDSAFE_PLL0_OFFSET_MODE_INTPR_SHIFT)
#define  LVDSAFE_PLL0_OFFSET_MODE_INTPR_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_OFFSET_MODE_INTPR_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_OFFSET_MODE_INTPR_SHIFT))

#define  LVDSAFE_PLL0_OFFSET_MODE_FD_MASK 0xe00000
#define  LVDSAFE_PLL0_OFFSET_MODE_FD_SHIFT 21
#define  LVDSAFE_PLL0_OFFSET_MODE_FD_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_OFFSET_MODE_FD_MASK) >> LVDSAFE_PLL0_OFFSET_MODE_FD_SHIFT)
#define  LVDSAFE_PLL0_OFFSET_MODE_FD_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_OFFSET_MODE_FD_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_OFFSET_MODE_FD_SHIFT))

#define  LVDSAFE_PLL0_OFFSET_MODE_PI_LOOP_MODE_MASK 0x100000
#define  LVDSAFE_PLL0_OFFSET_MODE_PI_LOOP_MODE_SHIFT 20
#define  LVDSAFE_PLL0_OFFSET_MODE_PI_LOOP_MODE_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_OFFSET_MODE_PI_LOOP_MODE_MASK) >> LVDSAFE_PLL0_OFFSET_MODE_PI_LOOP_MODE_SHIFT)
#define  LVDSAFE_PLL0_OFFSET_MODE_PI_LOOP_MODE_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_OFFSET_MODE_PI_LOOP_MODE_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_OFFSET_MODE_PI_LOOP_MODE_SHIFT))

#define  LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_MASK 0xffff8
#define  LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_SHIFT 3
#define  LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_MASK) >> LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_SHIFT)
#define  LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_SHIFT))

#define  LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK 0x4
#define  LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_SHIFT 2
#define  LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK) >> LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_SHIFT)
#define  LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_SHIFT))

#define  LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_VALID_MASK 0x2
#define  LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_VALID_SHIFT 1
#define  LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_VALID_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_VALID_MASK) >> LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_VALID_SHIFT)
#define  LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_VALID_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_VALID_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_VALID_SHIFT))

#define  LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_EN_MASK 0x1
#define  LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_EN_SHIFT 0
#define  LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_EN_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_EN_MASK) >> LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_EN_SHIFT)
#define  LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_EN_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_EN_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_OFFSET_MODE_FREQ_OFFSET_EN_SHIFT))

//====================================================================
//Register: PLL enable (fixed_mode_ssc_mode)
/** \brief PLL enable*/
//====================================================================

#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_RESERVED1_MASK 0xfff00000
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_RESERVED1_SHIFT 20
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_RESERVED1_MASK) >> LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_RESERVED1_SHIFT)
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_RESERVED1_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_RESERVED1_SHIFT))

#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK 0x80000
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_AVDD1815_SEL_SHIFT 19
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK) >> LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_AVDD1815_SEL_SHIFT)
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_AVDD1815_SEL_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_AVDD1815_SEL_SHIFT))

#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK 0x40000
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_SHIFT 18
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK) >> LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_SHIFT)
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_SHIFT))

#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_PU_MASK 0x20000
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_PU_SHIFT 17
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_PU_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_PU_MASK) >> LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_PU_SHIFT)
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_PU_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_PU_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_PU_SHIFT))

#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK 0x10000
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_BYPASS_EN_SHIFT 16
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK) >> LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_BYPASS_EN_SHIFT)
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_BYPASS_EN_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_BYPASS_EN_SHIFT))

#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_RESERVED2_MASK 0xfff0
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_RESERVED2_SHIFT 4
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_RESERVED2_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_RESERVED2_MASK) >> LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_RESERVED2_SHIFT)
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_RESERVED2_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_RESERVED2_SHIFT))

#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_SSC_MODE_MASK 0x8
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_SSC_MODE_SHIFT 3
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_SSC_MODE_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_SSC_MODE_MASK) >> LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_SSC_MODE_SHIFT)
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_SSC_MODE_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_SSC_MODE_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_SSC_MODE_SHIFT))

#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK 0x4
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_CLK_DET_EN_SHIFT 2
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK) >> LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_CLK_DET_EN_SHIFT)
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_CLK_DET_EN_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_CLK_DET_EN_SHIFT))

#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_PI_EN_MASK 0x2
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_PI_EN_SHIFT 1
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_PI_EN_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_PI_EN_MASK) >> LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_PI_EN_SHIFT)
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_PI_EN_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_PI_EN_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_PI_EN_SHIFT))

#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK 0x1
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_SSC_CLK_EN_SHIFT 0
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK) >> LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_SSC_CLK_EN_SHIFT)
#define  LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_SSC_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_FIXED_MODE_SSC_MODE_SSC_CLK_EN_SHIFT))

//====================================================================
//Register: PLL Modulation Frequency (ssc_freq_ssc_range)
/** \brief PLL Modulation Frequency Control*/
//====================================================================

#define  LVDSAFE_PLL0_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK 0xffff0000
#define  LVDSAFE_PLL0_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_SHIFT 16
#define  LVDSAFE_PLL0_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK) >> LVDSAFE_PLL0_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_SHIFT)
#define  LVDSAFE_PLL0_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_SHIFT))

#define  LVDSAFE_PLL0_SSC_FREQ_SSC_RANGE_RESERVED1_MASK 0xf800
#define  LVDSAFE_PLL0_SSC_FREQ_SSC_RANGE_RESERVED1_SHIFT 11
#define  LVDSAFE_PLL0_SSC_FREQ_SSC_RANGE_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_SSC_FREQ_SSC_RANGE_RESERVED1_MASK) >> LVDSAFE_PLL0_SSC_FREQ_SSC_RANGE_RESERVED1_SHIFT)
#define  LVDSAFE_PLL0_SSC_FREQ_SSC_RANGE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_SSC_FREQ_SSC_RANGE_RESERVED1_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_SSC_FREQ_SSC_RANGE_RESERVED1_SHIFT))

#define  LVDSAFE_PLL0_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK 0x7ff
#define  LVDSAFE_PLL0_SSC_FREQ_SSC_RANGE_SSC_RNGE_SHIFT 0
#define  LVDSAFE_PLL0_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK) >> LVDSAFE_PLL0_SSC_FREQ_SSC_RANGE_SSC_RNGE_SHIFT)
#define  LVDSAFE_PLL0_SSC_FREQ_SSC_RANGE_SSC_RNGE_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_SSC_FREQ_SSC_RANGE_SSC_RNGE_SHIFT))

//====================================================================
//Register: PLL Output Clock Control (clk_ctrl_marvell_test)
/** \brief PLL Output Clock Control*/
//====================================================================

#define  LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK 0xfffc0000
#define  LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_RESERVED1_SHIFT 18
#define  LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK) >> LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_RESERVED1_SHIFT)
#define  LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_RESERVED1_SHIFT))

#define  LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK 0x20000
#define  LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_SHIFT 17
#define  LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK) >> LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_SHIFT)
#define  LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_SHIFT))

#define  LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK 0x10000
#define  LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_SHIFT 16
#define  LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK) >> LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_SHIFT)
#define  LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_SHIFT))

#define  LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK 0xf000
#define  LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_RESERVED2_SHIFT 12
#define  LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK) >> LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_RESERVED2_SHIFT)
#define  LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_RESERVED2_SHIFT))

#define  LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK 0xff0
#define  LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_RESERVE_IN_SHIFT 4
#define  LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK) >> LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_RESERVE_IN_SHIFT)
#define  LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_RESERVE_IN_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_RESERVE_IN_SHIFT))

#define  LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK 0xf
#define  LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_TEST_ANA_SHIFT 0
#define  LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK) >> LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_TEST_ANA_SHIFT)
#define  LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_TEST_ANA_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_CLK_CTRL_MARVELL_TEST_TEST_ANA_SHIFT))

//====================================================================
//Register: PLL Lock Status (lock_status)
/** \brief PLL Lock Output*/
//====================================================================

#define  LVDSAFE_PLL0_LOCK_STATUS_RESERVED1_MASK 0xfffffffe
#define  LVDSAFE_PLL0_LOCK_STATUS_RESERVED1_SHIFT 1
#define  LVDSAFE_PLL0_LOCK_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_LOCK_STATUS_RESERVED1_MASK) >> LVDSAFE_PLL0_LOCK_STATUS_RESERVED1_SHIFT)
#define  LVDSAFE_PLL0_LOCK_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_LOCK_STATUS_RESERVED1_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_LOCK_STATUS_RESERVED1_SHIFT))

#define  LVDSAFE_PLL0_LOCK_STATUS_PLL_LOCK_MASK 0x1
#define  LVDSAFE_PLL0_LOCK_STATUS_PLL_LOCK_SHIFT 0
#define  LVDSAFE_PLL0_LOCK_STATUS_PLL_LOCK_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_LOCK_STATUS_PLL_LOCK_MASK) >> LVDSAFE_PLL0_LOCK_STATUS_PLL_LOCK_SHIFT)
#define  LVDSAFE_PLL0_LOCK_STATUS_PLL_LOCK_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_LOCK_STATUS_PLL_LOCK_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_LOCK_STATUS_PLL_LOCK_SHIFT))

//====================================================================
//Register: PLL RESERVE_OUT output (reserve_out)
//====================================================================

#define  LVDSAFE_PLL0_RESERVE_OUT_RESERVED1_MASK 0xfffe0000
#define  LVDSAFE_PLL0_RESERVE_OUT_RESERVED1_SHIFT 17
#define  LVDSAFE_PLL0_RESERVE_OUT_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_RESERVE_OUT_RESERVED1_MASK) >> LVDSAFE_PLL0_RESERVE_OUT_RESERVED1_SHIFT)
#define  LVDSAFE_PLL0_RESERVE_OUT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_RESERVE_OUT_RESERVED1_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_RESERVE_OUT_RESERVED1_SHIFT))

#define  LVDSAFE_PLL0_RESERVE_OUT_PU18_REG_MASK 0x10000
#define  LVDSAFE_PLL0_RESERVE_OUT_PU18_REG_SHIFT 16
#define  LVDSAFE_PLL0_RESERVE_OUT_PU18_REG_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_RESERVE_OUT_PU18_REG_MASK) >> LVDSAFE_PLL0_RESERVE_OUT_PU18_REG_SHIFT)
#define  LVDSAFE_PLL0_RESERVE_OUT_PU18_REG_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_RESERVE_OUT_PU18_REG_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_RESERVE_OUT_PU18_REG_SHIFT))

#define  LVDSAFE_PLL0_RESERVE_OUT_RESERVED2_MASK 0xff00
#define  LVDSAFE_PLL0_RESERVE_OUT_RESERVED2_SHIFT 8
#define  LVDSAFE_PLL0_RESERVE_OUT_RESERVED2_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_RESERVE_OUT_RESERVED2_MASK) >> LVDSAFE_PLL0_RESERVE_OUT_RESERVED2_SHIFT)
#define  LVDSAFE_PLL0_RESERVE_OUT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_RESERVE_OUT_RESERVED2_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_RESERVE_OUT_RESERVED2_SHIFT))

#define  LVDSAFE_PLL0_RESERVE_OUT_RESERVE_OUT_MASK 0xff
#define  LVDSAFE_PLL0_RESERVE_OUT_RESERVE_OUT_SHIFT 0
#define  LVDSAFE_PLL0_RESERVE_OUT_RESERVE_OUT_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL0_RESERVE_OUT_RESERVE_OUT_MASK) >> LVDSAFE_PLL0_RESERVE_OUT_RESERVE_OUT_SHIFT)
#define  LVDSAFE_PLL0_RESERVE_OUT_RESERVE_OUT_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL0_RESERVE_OUT_RESERVE_OUT_MASK) | (((uint32_t)val) << LVDSAFE_PLL0_RESERVE_OUT_RESERVE_OUT_SHIFT))

//====================================================================
//
//Register File: LVDSAFE PLL1 Controls (LVDSAFE_PLL1)
//
//====================================================================

//====================================================================
//Register: PLL reset & Pre-divider Register (rst_prediv)
/** \brief RESET, 1 = PLL in reset
           0 = PLL in normal mode
    RESET_SSC, 1 = SSC and Freq Offset in reset
               0 = SSC and Freq Offset operating mode
    RESET_PI, 1 = External Interpolator in reset
               0 = operating mode*/
//====================================================================

#define  LVDSAFE_PLL1_RST_PREDIV_RESERVED1_MASK 0xfff80000
#define  LVDSAFE_PLL1_RST_PREDIV_RESERVED1_SHIFT 19
#define  LVDSAFE_PLL1_RST_PREDIV_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_RST_PREDIV_RESERVED1_MASK) >> LVDSAFE_PLL1_RST_PREDIV_RESERVED1_SHIFT)
#define  LVDSAFE_PLL1_RST_PREDIV_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_RST_PREDIV_RESERVED1_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_RST_PREDIV_RESERVED1_SHIFT))

#define  LVDSAFE_PLL1_RST_PREDIV_RESET_PI_MASK 0x40000
#define  LVDSAFE_PLL1_RST_PREDIV_RESET_PI_SHIFT 18
#define  LVDSAFE_PLL1_RST_PREDIV_RESET_PI_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_RST_PREDIV_RESET_PI_MASK) >> LVDSAFE_PLL1_RST_PREDIV_RESET_PI_SHIFT)
#define  LVDSAFE_PLL1_RST_PREDIV_RESET_PI_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_RST_PREDIV_RESET_PI_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_RST_PREDIV_RESET_PI_SHIFT))

#define  LVDSAFE_PLL1_RST_PREDIV_RESET_SSC_MASK 0x20000
#define  LVDSAFE_PLL1_RST_PREDIV_RESET_SSC_SHIFT 17
#define  LVDSAFE_PLL1_RST_PREDIV_RESET_SSC_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_RST_PREDIV_RESET_SSC_MASK) >> LVDSAFE_PLL1_RST_PREDIV_RESET_SSC_SHIFT)
#define  LVDSAFE_PLL1_RST_PREDIV_RESET_SSC_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_RST_PREDIV_RESET_SSC_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_RST_PREDIV_RESET_SSC_SHIFT))

#define  LVDSAFE_PLL1_RST_PREDIV_RESET_MASK 0x10000
#define  LVDSAFE_PLL1_RST_PREDIV_RESET_SHIFT 16
#define  LVDSAFE_PLL1_RST_PREDIV_RESET_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_RST_PREDIV_RESET_MASK) >> LVDSAFE_PLL1_RST_PREDIV_RESET_SHIFT)
#define  LVDSAFE_PLL1_RST_PREDIV_RESET_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_RST_PREDIV_RESET_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_RST_PREDIV_RESET_SHIFT))

#define  LVDSAFE_PLL1_RST_PREDIV_RESERVED2_MASK 0xfe00
#define  LVDSAFE_PLL1_RST_PREDIV_RESERVED2_SHIFT 9
#define  LVDSAFE_PLL1_RST_PREDIV_RESERVED2_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_RST_PREDIV_RESERVED2_MASK) >> LVDSAFE_PLL1_RST_PREDIV_RESERVED2_SHIFT)
#define  LVDSAFE_PLL1_RST_PREDIV_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_RST_PREDIV_RESERVED2_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_RST_PREDIV_RESERVED2_SHIFT))

#define  LVDSAFE_PLL1_RST_PREDIV_REFDIV_MASK 0x1ff
#define  LVDSAFE_PLL1_RST_PREDIV_REFDIV_SHIFT 0
#define  LVDSAFE_PLL1_RST_PREDIV_REFDIV_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_RST_PREDIV_REFDIV_MASK) >> LVDSAFE_PLL1_RST_PREDIV_REFDIV_SHIFT)
#define  LVDSAFE_PLL1_RST_PREDIV_REFDIV_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_RST_PREDIV_REFDIV_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_RST_PREDIV_REFDIV_SHIFT))

//====================================================================
//Register: PLL feedback multiplier (mult_postdiv)
/** \brief PLL multiplication factor after pre-divide.*/
//====================================================================

#define  LVDSAFE_PLL1_MULT_POSTDIV_RESERVED1_MASK 0xfe000000
#define  LVDSAFE_PLL1_MULT_POSTDIV_RESERVED1_SHIFT 25
#define  LVDSAFE_PLL1_MULT_POSTDIV_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_MULT_POSTDIV_RESERVED1_MASK) >> LVDSAFE_PLL1_MULT_POSTDIV_RESERVED1_SHIFT)
#define  LVDSAFE_PLL1_MULT_POSTDIV_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_MULT_POSTDIV_RESERVED1_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_MULT_POSTDIV_RESERVED1_SHIFT))

#define  LVDSAFE_PLL1_MULT_POSTDIV_FBDIV_MASK 0x1ff0000
#define  LVDSAFE_PLL1_MULT_POSTDIV_FBDIV_SHIFT 16
#define  LVDSAFE_PLL1_MULT_POSTDIV_FBDIV_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_MULT_POSTDIV_FBDIV_MASK) >> LVDSAFE_PLL1_MULT_POSTDIV_FBDIV_SHIFT)
#define  LVDSAFE_PLL1_MULT_POSTDIV_FBDIV_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_MULT_POSTDIV_FBDIV_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_MULT_POSTDIV_FBDIV_SHIFT))

#define  LVDSAFE_PLL1_MULT_POSTDIV_RESERVED2_MASK 0xf800
#define  LVDSAFE_PLL1_MULT_POSTDIV_RESERVED2_SHIFT 11
#define  LVDSAFE_PLL1_MULT_POSTDIV_RESERVED2_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_MULT_POSTDIV_RESERVED2_MASK) >> LVDSAFE_PLL1_MULT_POSTDIV_RESERVED2_SHIFT)
#define  LVDSAFE_PLL1_MULT_POSTDIV_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_MULT_POSTDIV_RESERVED2_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_MULT_POSTDIV_RESERVED2_SHIFT))

#define  LVDSAFE_PLL1_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK 0x700
#define  LVDSAFE_PLL1_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_SHIFT 8
#define  LVDSAFE_PLL1_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK) >> LVDSAFE_PLL1_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_SHIFT)
#define  LVDSAFE_PLL1_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_MULT_POSTDIV_CLKOUT_DIFF_DIV_SEL_SHIFT))

#define  LVDSAFE_PLL1_MULT_POSTDIV_RESERVED3_MASK 0xf8
#define  LVDSAFE_PLL1_MULT_POSTDIV_RESERVED3_SHIFT 3
#define  LVDSAFE_PLL1_MULT_POSTDIV_RESERVED3_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_MULT_POSTDIV_RESERVED3_MASK) >> LVDSAFE_PLL1_MULT_POSTDIV_RESERVED3_SHIFT)
#define  LVDSAFE_PLL1_MULT_POSTDIV_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_MULT_POSTDIV_RESERVED3_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_MULT_POSTDIV_RESERVED3_SHIFT))

#define  LVDSAFE_PLL1_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK 0x7
#define  LVDSAFE_PLL1_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_SHIFT 0
#define  LVDSAFE_PLL1_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK) >> LVDSAFE_PLL1_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_SHIFT)
#define  LVDSAFE_PLL1_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_MULT_POSTDIV_CLKOUT_SE_DIV_SEL_SHIFT))

//====================================================================
//Register: PLL gain control (kvco)
/** \brief PLL gain control.*/
//====================================================================

#define  LVDSAFE_PLL1_KVCO_RESERVED1_MASK 0xfffffff0
#define  LVDSAFE_PLL1_KVCO_RESERVED1_SHIFT 4
#define  LVDSAFE_PLL1_KVCO_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_KVCO_RESERVED1_MASK) >> LVDSAFE_PLL1_KVCO_RESERVED1_SHIFT)
#define  LVDSAFE_PLL1_KVCO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_KVCO_RESERVED1_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_KVCO_RESERVED1_SHIFT))

#define  LVDSAFE_PLL1_KVCO_KVCO_MASK 0xf
#define  LVDSAFE_PLL1_KVCO_KVCO_SHIFT 0
#define  LVDSAFE_PLL1_KVCO_KVCO_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_KVCO_KVCO_MASK) >> LVDSAFE_PLL1_KVCO_KVCO_SHIFT)
#define  LVDSAFE_PLL1_KVCO_KVCO_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_KVCO_KVCO_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_KVCO_KVCO_SHIFT))

//====================================================================
//Register: PLL misc control (misc)
/** \brief PLL misc control.*/
//====================================================================

#define  LVDSAFE_PLL1_MISC_RESERVED1_MASK 0xffff0000
#define  LVDSAFE_PLL1_MISC_RESERVED1_SHIFT 16
#define  LVDSAFE_PLL1_MISC_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_MISC_RESERVED1_MASK) >> LVDSAFE_PLL1_MISC_RESERVED1_SHIFT)
#define  LVDSAFE_PLL1_MISC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_MISC_RESERVED1_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_MISC_RESERVED1_SHIFT))

#define  LVDSAFE_PLL1_MISC_PLL_BW_SEL_MASK 0x8000
#define  LVDSAFE_PLL1_MISC_PLL_BW_SEL_SHIFT 15
#define  LVDSAFE_PLL1_MISC_PLL_BW_SEL_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_MISC_PLL_BW_SEL_MASK) >> LVDSAFE_PLL1_MISC_PLL_BW_SEL_SHIFT)
#define  LVDSAFE_PLL1_MISC_PLL_BW_SEL_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_MISC_PLL_BW_SEL_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_MISC_PLL_BW_SEL_SHIFT))

#define  LVDSAFE_PLL1_MISC_CTUNE_MASK 0x6000
#define  LVDSAFE_PLL1_MISC_CTUNE_SHIFT 13
#define  LVDSAFE_PLL1_MISC_CTUNE_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_MISC_CTUNE_MASK) >> LVDSAFE_PLL1_MISC_CTUNE_SHIFT)
#define  LVDSAFE_PLL1_MISC_CTUNE_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_MISC_CTUNE_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_MISC_CTUNE_SHIFT))

#define  LVDSAFE_PLL1_MISC_INTPI_MASK 0x1e00
#define  LVDSAFE_PLL1_MISC_INTPI_SHIFT 9
#define  LVDSAFE_PLL1_MISC_INTPI_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_MISC_INTPI_MASK) >> LVDSAFE_PLL1_MISC_INTPI_SHIFT)
#define  LVDSAFE_PLL1_MISC_INTPI_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_MISC_INTPI_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_MISC_INTPI_SHIFT))

#define  LVDSAFE_PLL1_MISC_ICP_MASK 0x1e0
#define  LVDSAFE_PLL1_MISC_ICP_SHIFT 5
#define  LVDSAFE_PLL1_MISC_ICP_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_MISC_ICP_MASK) >> LVDSAFE_PLL1_MISC_ICP_SHIFT)
#define  LVDSAFE_PLL1_MISC_ICP_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_MISC_ICP_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_MISC_ICP_SHIFT))

#define  LVDSAFE_PLL1_MISC_VDDM_MASK 0x18
#define  LVDSAFE_PLL1_MISC_VDDM_SHIFT 3
#define  LVDSAFE_PLL1_MISC_VDDM_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_MISC_VDDM_MASK) >> LVDSAFE_PLL1_MISC_VDDM_SHIFT)
#define  LVDSAFE_PLL1_MISC_VDDM_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_MISC_VDDM_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_MISC_VDDM_SHIFT))

#define  LVDSAFE_PLL1_MISC_VDDL_MASK 0x7
#define  LVDSAFE_PLL1_MISC_VDDL_SHIFT 0
#define  LVDSAFE_PLL1_MISC_VDDL_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_MISC_VDDL_MASK) >> LVDSAFE_PLL1_MISC_VDDL_SHIFT)
#define  LVDSAFE_PLL1_MISC_VDDL_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_MISC_VDDL_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_MISC_VDDL_SHIFT))

//====================================================================
//Register: PLL PFD (Phase Frequency Detector) input select, and de-skew application control (feedback_mode_deskew)
/** \brief PLL feedback mode control.*/
//====================================================================

#define  LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_RESERVED1_MASK 0xff800000
#define  LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_RESERVED1_SHIFT 23
#define  LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_RESERVED1_MASK) >> LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_RESERVED1_SHIFT)
#define  LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_RESERVED1_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_RESERVED1_SHIFT))

#define  LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_FBCDLY_MASK 0x7e0000
#define  LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_FBCDLY_SHIFT 17
#define  LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_FBCDLY_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_FBCDLY_MASK) >> LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_FBCDLY_SHIFT)
#define  LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_FBCDLY_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_FBCDLY_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_FBCDLY_SHIFT))

#define  LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK 0x10000
#define  LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_SHIFT 16
#define  LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK) >> LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_SHIFT)
#define  LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_FBCLK_EXT_SEL_SHIFT))

#define  LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_RESERVED2_MASK 0xffff
#define  LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_RESERVED2_SHIFT 0
#define  LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_RESERVED2_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_RESERVED2_MASK) >> LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_RESERVED2_SHIFT)
#define  LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_RESERVED2_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_FEEDBACK_MODE_DESKEW_RESERVED2_SHIFT))

//====================================================================
//Register: PLL offset frequency control (offset_mode)
/** \brief PLL offset frequency control.*/
//====================================================================

#define  LVDSAFE_PLL1_OFFSET_MODE_RESERVED1_MASK 0xf8000000
#define  LVDSAFE_PLL1_OFFSET_MODE_RESERVED1_SHIFT 27
#define  LVDSAFE_PLL1_OFFSET_MODE_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_OFFSET_MODE_RESERVED1_MASK) >> LVDSAFE_PLL1_OFFSET_MODE_RESERVED1_SHIFT)
#define  LVDSAFE_PLL1_OFFSET_MODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_OFFSET_MODE_RESERVED1_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_OFFSET_MODE_RESERVED1_SHIFT))

#define  LVDSAFE_PLL1_OFFSET_MODE_INTPR_MASK 0x7000000
#define  LVDSAFE_PLL1_OFFSET_MODE_INTPR_SHIFT 24
#define  LVDSAFE_PLL1_OFFSET_MODE_INTPR_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_OFFSET_MODE_INTPR_MASK) >> LVDSAFE_PLL1_OFFSET_MODE_INTPR_SHIFT)
#define  LVDSAFE_PLL1_OFFSET_MODE_INTPR_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_OFFSET_MODE_INTPR_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_OFFSET_MODE_INTPR_SHIFT))

#define  LVDSAFE_PLL1_OFFSET_MODE_FD_MASK 0xe00000
#define  LVDSAFE_PLL1_OFFSET_MODE_FD_SHIFT 21
#define  LVDSAFE_PLL1_OFFSET_MODE_FD_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_OFFSET_MODE_FD_MASK) >> LVDSAFE_PLL1_OFFSET_MODE_FD_SHIFT)
#define  LVDSAFE_PLL1_OFFSET_MODE_FD_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_OFFSET_MODE_FD_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_OFFSET_MODE_FD_SHIFT))

#define  LVDSAFE_PLL1_OFFSET_MODE_PI_LOOP_MODE_MASK 0x100000
#define  LVDSAFE_PLL1_OFFSET_MODE_PI_LOOP_MODE_SHIFT 20
#define  LVDSAFE_PLL1_OFFSET_MODE_PI_LOOP_MODE_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_OFFSET_MODE_PI_LOOP_MODE_MASK) >> LVDSAFE_PLL1_OFFSET_MODE_PI_LOOP_MODE_SHIFT)
#define  LVDSAFE_PLL1_OFFSET_MODE_PI_LOOP_MODE_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_OFFSET_MODE_PI_LOOP_MODE_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_OFFSET_MODE_PI_LOOP_MODE_SHIFT))

#define  LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_MASK 0xffff8
#define  LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_SHIFT 3
#define  LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_MASK) >> LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_SHIFT)
#define  LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_SHIFT))

#define  LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK 0x4
#define  LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_SHIFT 2
#define  LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK) >> LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_SHIFT)
#define  LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_MODE_SELECTION_SHIFT))

#define  LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_VALID_MASK 0x2
#define  LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_VALID_SHIFT 1
#define  LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_VALID_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_VALID_MASK) >> LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_VALID_SHIFT)
#define  LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_VALID_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_VALID_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_VALID_SHIFT))

#define  LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_EN_MASK 0x1
#define  LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_EN_SHIFT 0
#define  LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_EN_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_EN_MASK) >> LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_EN_SHIFT)
#define  LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_EN_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_EN_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_OFFSET_MODE_FREQ_OFFSET_EN_SHIFT))

//====================================================================
//Register: PLL enable (fixed_mode_ssc_mode)
/** \brief PLL enable*/
//====================================================================

#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_RESERVED1_MASK 0xfff00000
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_RESERVED1_SHIFT 20
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_RESERVED1_MASK) >> LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_RESERVED1_SHIFT)
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_RESERVED1_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_RESERVED1_SHIFT))

#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK 0x80000
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_AVDD1815_SEL_SHIFT 19
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK) >> LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_AVDD1815_SEL_SHIFT)
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_AVDD1815_SEL_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_AVDD1815_SEL_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_AVDD1815_SEL_SHIFT))

#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK 0x40000
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_SHIFT 18
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK) >> LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_SHIFT)
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_CLKOUT_SE_GATING_EN_SHIFT))

#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_PU_MASK 0x20000
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_PU_SHIFT 17
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_PU_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_PU_MASK) >> LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_PU_SHIFT)
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_PU_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_PU_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_PU_SHIFT))

#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK 0x10000
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_BYPASS_EN_SHIFT 16
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK) >> LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_BYPASS_EN_SHIFT)
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_BYPASS_EN_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_BYPASS_EN_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_BYPASS_EN_SHIFT))

#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_RESERVED2_MASK 0xfff0
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_RESERVED2_SHIFT 4
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_RESERVED2_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_RESERVED2_MASK) >> LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_RESERVED2_SHIFT)
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_RESERVED2_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_RESERVED2_SHIFT))

#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_SSC_MODE_MASK 0x8
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_SSC_MODE_SHIFT 3
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_SSC_MODE_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_SSC_MODE_MASK) >> LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_SSC_MODE_SHIFT)
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_SSC_MODE_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_SSC_MODE_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_SSC_MODE_SHIFT))

#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK 0x4
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_CLK_DET_EN_SHIFT 2
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK) >> LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_CLK_DET_EN_SHIFT)
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_CLK_DET_EN_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_CLK_DET_EN_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_CLK_DET_EN_SHIFT))

#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_PI_EN_MASK 0x2
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_PI_EN_SHIFT 1
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_PI_EN_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_PI_EN_MASK) >> LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_PI_EN_SHIFT)
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_PI_EN_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_PI_EN_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_PI_EN_SHIFT))

#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK 0x1
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_SSC_CLK_EN_SHIFT 0
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK) >> LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_SSC_CLK_EN_SHIFT)
#define  LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_SSC_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_SSC_CLK_EN_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_FIXED_MODE_SSC_MODE_SSC_CLK_EN_SHIFT))

//====================================================================
//Register: PLL Modulation Frequency (ssc_freq_ssc_range)
/** \brief PLL Modulation Frequency Control*/
//====================================================================

#define  LVDSAFE_PLL1_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK 0xffff0000
#define  LVDSAFE_PLL1_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_SHIFT 16
#define  LVDSAFE_PLL1_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK) >> LVDSAFE_PLL1_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_SHIFT)
#define  LVDSAFE_PLL1_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_SSC_FREQ_SSC_RANGE_SSC_FREQ_DIV_SHIFT))

#define  LVDSAFE_PLL1_SSC_FREQ_SSC_RANGE_RESERVED1_MASK 0xf800
#define  LVDSAFE_PLL1_SSC_FREQ_SSC_RANGE_RESERVED1_SHIFT 11
#define  LVDSAFE_PLL1_SSC_FREQ_SSC_RANGE_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_SSC_FREQ_SSC_RANGE_RESERVED1_MASK) >> LVDSAFE_PLL1_SSC_FREQ_SSC_RANGE_RESERVED1_SHIFT)
#define  LVDSAFE_PLL1_SSC_FREQ_SSC_RANGE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_SSC_FREQ_SSC_RANGE_RESERVED1_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_SSC_FREQ_SSC_RANGE_RESERVED1_SHIFT))

#define  LVDSAFE_PLL1_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK 0x7ff
#define  LVDSAFE_PLL1_SSC_FREQ_SSC_RANGE_SSC_RNGE_SHIFT 0
#define  LVDSAFE_PLL1_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK) >> LVDSAFE_PLL1_SSC_FREQ_SSC_RANGE_SSC_RNGE_SHIFT)
#define  LVDSAFE_PLL1_SSC_FREQ_SSC_RANGE_SSC_RNGE_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_SSC_FREQ_SSC_RANGE_SSC_RNGE_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_SSC_FREQ_SSC_RANGE_SSC_RNGE_SHIFT))

//====================================================================
//Register: PLL Output Clock Control (clk_ctrl_marvell_test)
/** \brief PLL Output Clock Control*/
//====================================================================

#define  LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK 0xfffc0000
#define  LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_RESERVED1_SHIFT 18
#define  LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK) >> LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_RESERVED1_SHIFT)
#define  LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_RESERVED1_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_RESERVED1_SHIFT))

#define  LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK 0x20000
#define  LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_SHIFT 17
#define  LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK) >> LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_SHIFT)
#define  LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_CLKOUT_DIFF_EN_SHIFT))

#define  LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK 0x10000
#define  LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_SHIFT 16
#define  LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK) >> LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_SHIFT)
#define  LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_CLKOUT_SOURCE_SEL_SHIFT))

#define  LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK 0xf000
#define  LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_RESERVED2_SHIFT 12
#define  LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK) >> LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_RESERVED2_SHIFT)
#define  LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_RESERVED2_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_RESERVED2_SHIFT))

#define  LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK 0xff0
#define  LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_RESERVE_IN_SHIFT 4
#define  LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK) >> LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_RESERVE_IN_SHIFT)
#define  LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_RESERVE_IN_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_RESERVE_IN_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_RESERVE_IN_SHIFT))

#define  LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK 0xf
#define  LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_TEST_ANA_SHIFT 0
#define  LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK) >> LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_TEST_ANA_SHIFT)
#define  LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_TEST_ANA_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_TEST_ANA_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_CLK_CTRL_MARVELL_TEST_TEST_ANA_SHIFT))

//====================================================================
//Register: PLL Lock Status (lock_status)
/** \brief PLL Lock Output*/
//====================================================================

#define  LVDSAFE_PLL1_LOCK_STATUS_RESERVED1_MASK 0xfffffffe
#define  LVDSAFE_PLL1_LOCK_STATUS_RESERVED1_SHIFT 1
#define  LVDSAFE_PLL1_LOCK_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_LOCK_STATUS_RESERVED1_MASK) >> LVDSAFE_PLL1_LOCK_STATUS_RESERVED1_SHIFT)
#define  LVDSAFE_PLL1_LOCK_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_LOCK_STATUS_RESERVED1_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_LOCK_STATUS_RESERVED1_SHIFT))

#define  LVDSAFE_PLL1_LOCK_STATUS_PLL_LOCK_MASK 0x1
#define  LVDSAFE_PLL1_LOCK_STATUS_PLL_LOCK_SHIFT 0
#define  LVDSAFE_PLL1_LOCK_STATUS_PLL_LOCK_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_LOCK_STATUS_PLL_LOCK_MASK) >> LVDSAFE_PLL1_LOCK_STATUS_PLL_LOCK_SHIFT)
#define  LVDSAFE_PLL1_LOCK_STATUS_PLL_LOCK_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_LOCK_STATUS_PLL_LOCK_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_LOCK_STATUS_PLL_LOCK_SHIFT))

//====================================================================
//Register: PLL RESERVE_OUT output (reserve_out)
//====================================================================

#define  LVDSAFE_PLL1_RESERVE_OUT_RESERVED1_MASK 0xfffe0000
#define  LVDSAFE_PLL1_RESERVE_OUT_RESERVED1_SHIFT 17
#define  LVDSAFE_PLL1_RESERVE_OUT_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_RESERVE_OUT_RESERVED1_MASK) >> LVDSAFE_PLL1_RESERVE_OUT_RESERVED1_SHIFT)
#define  LVDSAFE_PLL1_RESERVE_OUT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_RESERVE_OUT_RESERVED1_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_RESERVE_OUT_RESERVED1_SHIFT))

#define  LVDSAFE_PLL1_RESERVE_OUT_PU18_REG_MASK 0x10000
#define  LVDSAFE_PLL1_RESERVE_OUT_PU18_REG_SHIFT 16
#define  LVDSAFE_PLL1_RESERVE_OUT_PU18_REG_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_RESERVE_OUT_PU18_REG_MASK) >> LVDSAFE_PLL1_RESERVE_OUT_PU18_REG_SHIFT)
#define  LVDSAFE_PLL1_RESERVE_OUT_PU18_REG_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_RESERVE_OUT_PU18_REG_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_RESERVE_OUT_PU18_REG_SHIFT))

#define  LVDSAFE_PLL1_RESERVE_OUT_RESERVED2_MASK 0xff00
#define  LVDSAFE_PLL1_RESERVE_OUT_RESERVED2_SHIFT 8
#define  LVDSAFE_PLL1_RESERVE_OUT_RESERVED2_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_RESERVE_OUT_RESERVED2_MASK) >> LVDSAFE_PLL1_RESERVE_OUT_RESERVED2_SHIFT)
#define  LVDSAFE_PLL1_RESERVE_OUT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_RESERVE_OUT_RESERVED2_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_RESERVE_OUT_RESERVED2_SHIFT))

#define  LVDSAFE_PLL1_RESERVE_OUT_RESERVE_OUT_MASK 0xff
#define  LVDSAFE_PLL1_RESERVE_OUT_RESERVE_OUT_SHIFT 0
#define  LVDSAFE_PLL1_RESERVE_OUT_RESERVE_OUT_MASK_SHIFT(reg) (((reg) & LVDSAFE_PLL1_RESERVE_OUT_RESERVE_OUT_MASK) >> LVDSAFE_PLL1_RESERVE_OUT_RESERVE_OUT_SHIFT)
#define  LVDSAFE_PLL1_RESERVE_OUT_RESERVE_OUT_REPLACE_VAL(reg,val) (((reg) & ~LVDSAFE_PLL1_RESERVE_OUT_RESERVE_OUT_MASK) | (((uint32_t)val) << LVDSAFE_PLL1_RESERVE_OUT_RESERVE_OUT_SHIFT))

//====================================================================
//
//Register File: MPMU Clock/Reset Gen Controls (MPMU_ClkRstGen)
/** \brief These registers provide control/status for the clocks/resets for all of the clock domains
    in the Application Processing section of the chip.*/
//
//====================================================================

//====================================================================
//Register: MFPIDeglitchClk ClkGen Configuration Register (MFPIDeglitchClkConfig_ClkGenConfig)
/** \brief MFPIDeglitchClk clock generator Configuration Register.
          The maximum frequency for this clock is MAXFREQ. It is important to ensure that the
          configuration settings for this clock result in an output frequency less than this value.*/
//====================================================================

#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0xf8000000
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x6000000
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 25
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK 0x1000000
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT 24
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) >> MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT)
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT))

#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0xf00000
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 20
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_HIDIV_MASK 0xf0000
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) >> MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0xf000
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 12
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_LODIV_MASK 0xf00
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_LODIV_MASK) >> MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0xf8
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 3
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK 0x4
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT 2
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) >> MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT)
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT))

#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK 0x2
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT 1
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK) >> MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT)
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT))

#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED8_MASK 0x1
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED8_SHIFT 0
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED8_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED8_MASK) >> MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED8_SHIFT)
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED8_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED8_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENCONFIG_RESERVED8_SHIFT))

//====================================================================
//Register: MFPIDeglitchClk ClkGen Status Register (MFPIDeglitchClkConfig_ClkGenStatus)
/** \brief MFPIDeglitchClk clock generator Status Register.*/
//====================================================================

#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xf00000
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 20
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0xf0000
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xf000
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 12
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_LODIV_MASK 0xf00
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK 0xf8
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 3
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x4
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 2
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED7_MASK 0x2
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED7_SHIFT 1
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED7_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED7_MASK) >> MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED7_SHIFT)
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED7_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED7_SHIFT))

#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED8_MASK 0x1
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED8_SHIFT 0
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED8_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED8_MASK) >> MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED8_SHIFT)
#define  MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED8_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED8_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_MFPIDEGLITCHCLKCONFIG_CLKGENSTATUS_RESERVED8_SHIFT))

//====================================================================
//Register: CLK32k ClkGen Configuration Register (CLK32KConfig_ClkGenConfig)
/** \brief CLK32k clock generator Configuration Register.
          The maximum frequency for this clock is MAXFREQ. It is important to ensure that the
          configuration settings for this clock result in an output frequency less than this value.*/
//====================================================================

#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED1_MASK 0xf8000000
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x6000000
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 25
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_SRCSEL_MASK 0x1000000
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_SRCSEL_SHIFT 24
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_SRCSEL_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_SRCSEL_MASK) >> MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_SRCSEL_SHIFT)
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_SRCSEL_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_SRCSEL_SHIFT))

#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED3_MASK 0x800000
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 23
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_HIDIV_MASK 0x7f0000
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_HIDIV_MASK) >> MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED4_MASK 0x8000
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 15
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_LODIV_MASK 0x7f00
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_LODIV_MASK) >> MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED5_MASK 0xf8
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 3
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_PREDIVEN_MASK 0x4
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT 2
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_PREDIVEN_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_PREDIVEN_MASK) >> MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT)
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_PREDIVEN_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT))

#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED6_MASK 0x2
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED6_SHIFT 1
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED6_MASK) >> MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED6_SHIFT)
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED6_SHIFT))

#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED7_MASK 0x1
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED7_SHIFT 0
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED7_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED7_MASK) >> MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED7_SHIFT)
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED7_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENCONFIG_RESERVED7_SHIFT))

//====================================================================
//Register: CLK32k ClkGen Status Register (CLK32KConfig_ClkGenStatus)
/** \brief CLK32k clock generator Status Register.*/
//====================================================================

#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_PREDIV_MASK 0xf8000000
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_PREDIV_SHIFT 27
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_PREDIV_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_PREDIV_MASK) >> MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_PREDIV_SHIFT)
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_PREDIV_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_PREDIV_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_PREDIV_SHIFT))

#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED1_MASK 0x6000000
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 25
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x800000
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 23
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_HIDIV_MASK 0x7f0000
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_HIDIV_MASK) >> MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED3_MASK 0x8000
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 15
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_LODIV_MASK 0x7f00
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_LODIV_MASK) >> MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xf8
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 3
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_PREDIVEN_MASK 0x4
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT 2
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_PREDIVEN_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_PREDIVEN_MASK) >> MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT)
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_PREDIVEN_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT))

#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x2
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 1
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_CLK32KCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: Hips Clock Configuration Register (HipsClkConfig)
/** \brief Hips Clock Configuration Register*/
//====================================================================

#define  MPMU_CLKRSTGEN_HIPSCLKCONFIG_RESERVED1_MASK 0xfffffffc
#define  MPMU_CLKRSTGEN_HIPSCLKCONFIG_RESERVED1_SHIFT 2
#define  MPMU_CLKRSTGEN_HIPSCLKCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPSCLKCONFIG_RESERVED1_MASK) >> MPMU_CLKRSTGEN_HIPSCLKCONFIG_RESERVED1_SHIFT)
#define  MPMU_CLKRSTGEN_HIPSCLKCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPSCLKCONFIG_RESERVED1_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPSCLKCONFIG_RESERVED1_SHIFT))

#define  MPMU_CLKRSTGEN_HIPSCLKCONFIG_CLKEN_MASK 0x2
#define  MPMU_CLKRSTGEN_HIPSCLKCONFIG_CLKEN_SHIFT 1
#define  MPMU_CLKRSTGEN_HIPSCLKCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPSCLKCONFIG_CLKEN_MASK) >> MPMU_CLKRSTGEN_HIPSCLKCONFIG_CLKEN_SHIFT)
#define  MPMU_CLKRSTGEN_HIPSCLKCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPSCLKCONFIG_CLKEN_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPSCLKCONFIG_CLKEN_SHIFT))

#define  MPMU_CLKRSTGEN_HIPSCLKCONFIG_RESERVED2_MASK 0x1
#define  MPMU_CLKRSTGEN_HIPSCLKCONFIG_RESERVED2_SHIFT 0
#define  MPMU_CLKRSTGEN_HIPSCLKCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPSCLKCONFIG_RESERVED2_MASK) >> MPMU_CLKRSTGEN_HIPSCLKCONFIG_RESERVED2_SHIFT)
#define  MPMU_CLKRSTGEN_HIPSCLKCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPSCLKCONFIG_RESERVED2_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPSCLKCONFIG_RESERVED2_SHIFT))

//====================================================================
//Register: Hips Clock Status Register (HipsClkStatus)
/** \brief Hips Clock Status Register*/
//====================================================================

#define  MPMU_CLKRSTGEN_HIPSCLKSTATUS_RESERVED1_MASK 0xfffffffc
#define  MPMU_CLKRSTGEN_HIPSCLKSTATUS_RESERVED1_SHIFT 2
#define  MPMU_CLKRSTGEN_HIPSCLKSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPSCLKSTATUS_RESERVED1_MASK) >> MPMU_CLKRSTGEN_HIPSCLKSTATUS_RESERVED1_SHIFT)
#define  MPMU_CLKRSTGEN_HIPSCLKSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPSCLKSTATUS_RESERVED1_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPSCLKSTATUS_RESERVED1_SHIFT))

#define  MPMU_CLKRSTGEN_HIPSCLKSTATUS_CLKEN_MASK 0x2
#define  MPMU_CLKRSTGEN_HIPSCLKSTATUS_CLKEN_SHIFT 1
#define  MPMU_CLKRSTGEN_HIPSCLKSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPSCLKSTATUS_CLKEN_MASK) >> MPMU_CLKRSTGEN_HIPSCLKSTATUS_CLKEN_SHIFT)
#define  MPMU_CLKRSTGEN_HIPSCLKSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPSCLKSTATUS_CLKEN_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPSCLKSTATUS_CLKEN_SHIFT))

#define  MPMU_CLKRSTGEN_HIPSCLKSTATUS_RESERVED2_MASK 0x1
#define  MPMU_CLKRSTGEN_HIPSCLKSTATUS_RESERVED2_SHIFT 0
#define  MPMU_CLKRSTGEN_HIPSCLKSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPSCLKSTATUS_RESERVED2_MASK) >> MPMU_CLKRSTGEN_HIPSCLKSTATUS_RESERVED2_SHIFT)
#define  MPMU_CLKRSTGEN_HIPSCLKSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPSCLKSTATUS_RESERVED2_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPSCLKSTATUS_RESERVED2_SHIFT))

//====================================================================
//Register: HiPWM Clock Configuration Register (HiPWMClkConfig)
/** \brief HiPWM Clock Configuration Register*/
//====================================================================

#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_ACKOVERRIDE_SHIFT 31
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKCONFIG_ACKOVERRIDE_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKCONFIG_ACKOVERRIDE_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKCONFIG_ACKOVERRIDE_SHIFT))

#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKCONFIG_ACTIVEOVERRIDE_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED1_MASK 0x3e000000
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED1_SHIFT 25
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED1_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED1_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED1_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED1_SHIFT))

#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_SRCSEL_MASK 0x1000000
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_SRCSEL_SHIFT 24
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_SRCSEL_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKCONFIG_SRCSEL_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKCONFIG_SRCSEL_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKCONFIG_SRCSEL_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKCONFIG_SRCSEL_SHIFT))

#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED2_MASK 0xffff80
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED2_SHIFT 7
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED2_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED2_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED2_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED2_SHIFT))

#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_CLKONREQIRQEN_MASK 0x40
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_CLKONREQIRQEN_SHIFT 6
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKCONFIG_CLKONREQIRQEN_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKCONFIG_CLKONREQIRQEN_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKCONFIG_CLKONREQIRQEN_SHIFT))

#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKCONFIG_CLKOFFREQIRQEN_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKCONFIG_LPREQDENIEDIRQEN_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKCONFIG_LPREQSUCCESSIRQEN_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED3_MASK 0x4
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED3_SHIFT 2
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED3_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED3_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED3_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED3_SHIFT))

#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_CLKEN_MASK 0x2
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_CLKEN_SHIFT 1
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKCONFIG_CLKEN_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKCONFIG_CLKEN_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKCONFIG_CLKEN_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKCONFIG_CLKEN_SHIFT))

#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED4_MASK 0x1
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED4_SHIFT 0
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED4_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED4_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED4_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKCONFIG_RESERVED4_SHIFT))

//====================================================================
//Register: HiPWM Clock Status Register (HiPWMClkStatus)
/** \brief HiPWM Clock Status Register*/
//====================================================================

#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_PREDIV_MASK 0xf8000000
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_PREDIV_SHIFT 27
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_PREDIV_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKSTATUS_PREDIV_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKSTATUS_PREDIV_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_PREDIV_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKSTATUS_PREDIV_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKSTATUS_PREDIV_SHIFT))

#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED1_MASK 0x6000000
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED1_SHIFT 25
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED1_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED1_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED1_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED1_SHIFT))

#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_SRCSEL_MASK 0x1000000
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_SRCSEL_SHIFT 24
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKSTATUS_SRCSEL_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKSTATUS_SRCSEL_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKSTATUS_SRCSEL_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKSTATUS_SRCSEL_SHIFT))

#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED2_MASK 0xf80000
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED2_SHIFT 19
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED2_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED2_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED2_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED2_SHIFT))

#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_HIDIV_MASK 0x70000
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_HIDIV_SHIFT 16
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKSTATUS_HIDIV_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKSTATUS_HIDIV_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKSTATUS_HIDIV_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKSTATUS_HIDIV_SHIFT))

#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED3_MASK 0xf800
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED3_SHIFT 11
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED3_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED3_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED3_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED3_SHIFT))

#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_LODIV_MASK 0x700
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_LODIV_SHIFT 8
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKSTATUS_LODIV_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKSTATUS_LODIV_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKSTATUS_LODIV_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKSTATUS_LODIV_SHIFT))

#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKGATED_MASK 0x80
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKGATED_SHIFT 7
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKGATED_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKGATED_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKGATED_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKGATED_SHIFT))

#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKONREQIRQ_MASK 0x40
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKONREQIRQ_SHIFT 6
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKONREQIRQ_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKONREQIRQ_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKONREQIRQ_SHIFT))

#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKOFFREQIRQ_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKOFFREQIRQ_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKOFFREQIRQ_SHIFT))

#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKSTATUS_LPREQDENIEDIRQ_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKSTATUS_LPREQSUCCESSIRQ_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_PREDIVEN_MASK 0x4
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_PREDIVEN_SHIFT 2
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_PREDIVEN_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKSTATUS_PREDIVEN_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKSTATUS_PREDIVEN_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKSTATUS_PREDIVEN_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKSTATUS_PREDIVEN_SHIFT))

#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKEN_MASK 0x2
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKEN_SHIFT 1
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKEN_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKEN_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKEN_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKSTATUS_CLKEN_SHIFT))

#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED4_MASK 0x1
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED4_SHIFT 0
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED4_MASK) >> MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED4_SHIFT)
#define  MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED4_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_HIPWMCLKSTATUS_RESERVED4_SHIFT))

//====================================================================
//Register: Reset Control Register (ResetCtl)
/** \brief This register contains fields to control various aspects of the chip resets.*/
//====================================================================

#define  MPMU_CLKRSTGEN_RESETCTL_RESERVED1_MASK 0xfffffffe
#define  MPMU_CLKRSTGEN_RESETCTL_RESERVED1_SHIFT 1
#define  MPMU_CLKRSTGEN_RESETCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_RESETCTL_RESERVED1_MASK) >> MPMU_CLKRSTGEN_RESETCTL_RESERVED1_SHIFT)
#define  MPMU_CLKRSTGEN_RESETCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_RESETCTL_RESERVED1_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_RESETCTL_RESERVED1_SHIFT))

#define  MPMU_CLKRSTGEN_RESETCTL_WATCHDOGRESET_SYSNCHIP_MASK 0x1
#define  MPMU_CLKRSTGEN_RESETCTL_WATCHDOGRESET_SYSNCHIP_SHIFT 0
#define  MPMU_CLKRSTGEN_RESETCTL_WATCHDOGRESET_SYSNCHIP_MASK_SHIFT(reg) (((reg) & MPMU_CLKRSTGEN_RESETCTL_WATCHDOGRESET_SYSNCHIP_MASK) >> MPMU_CLKRSTGEN_RESETCTL_WATCHDOGRESET_SYSNCHIP_SHIFT)
#define  MPMU_CLKRSTGEN_RESETCTL_WATCHDOGRESET_SYSNCHIP_REPLACE_VAL(reg,val) (((reg) & ~MPMU_CLKRSTGEN_RESETCTL_WATCHDOGRESET_SYSNCHIP_MASK) | (((uint32_t)val) << MPMU_CLKRSTGEN_RESETCTL_WATCHDOGRESET_SYSNCHIP_SHIFT))

//====================================================================
//
//Register File: MPMU Timer Control Registers (MPMU_timers)
/** \brief The APB TIMERS block provides programmable interval timers and watchdog. <BR>
The interval timers can be used to generate a repetitive period timer (for the RTO/S periodic tick interrupt), to time intervals (for switch presses, LED flashing, or fan speed), or for a watchdog reset. <BR>
Four identical programmable timers (Timer0, Timer1, Timer2, Timer3) are provided in the APB subsystem. Each timer generates a level interrupt when it reaches the final event, which can be programmed to be either a terminal count or an input pulse (on an external signal). When the final event is reached, the counter can restart at zero (continuous mode) or halt, depending on how it is configured. <BR>
Timer0 provides the watchdog function, and when enabled, the system will be reset if the watchdog timer reaches the final event. <BR>
The timer count is incremented on a selected input timebase. There are 8 choices of input timebases to select from: 1us, 10us, 100us, 1ms, 10ms and 100ms, the bus clock, and external input signal pulses. <BR>
To facilitate interval timing, the counter may be disabled to lock the count value that can then be read via the Timer Status Register. The counter is reset to zero and begins to increment when the Timer is re-enabled. <BR>
To assist system level functions, each timer can generate a signal that toggles when the final count is reached. The toggling signal is a periodic waveform that can be used within the SoC or be connected to the pins for further use by the system. <BR>*/
//
//====================================================================

//====================================================================
//Register: Timer0 Watchdog Register (TWR0)
/** \brief When Watchdog Mode is enabled, this register must be serviced properly or the system will reset. This is useful to automatically reboot a malfunctioning system. This register must be correctly serviced before timer0 reaches the terminal event (see Control register bit[2]), which can be a terminal count (see Terminal Count register) or pulse. Also, if improperly serviced, the system will also immediately reset (if Watchdog Mode is enabled). In addition, when you write this register to disable the watchdog (Enable bit zero), it must be correctly serviced or a system reset will be generated (this is to prevent a malfunctioning system from accidentally disabling the watchdog).<BR>
            The correct method of servicing the watchdog is to read the register value, then write back the value with the lower four bits inverted (XOR with 0x0000000f). The register read value cycles in a pseudo-random pattern.<BR>
            Attention: the Timer0 Control Register must be placed in Continuous mode (TCR0.Mode=1) for the watchdog timeout and reset to properly function. When Timer0 is placed in non-continuous mode, the watchdog reset function is de-activated even if the watchdog mode is enabled (TWR0.Enable=1).*/
//====================================================================

#define  MPMU_TIMERS_TWR0_ENABLE_MASK 0x80000000
#define  MPMU_TIMERS_TWR0_ENABLE_SHIFT 31
#define  MPMU_TIMERS_TWR0_ENABLE_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TWR0_ENABLE_MASK) >> MPMU_TIMERS_TWR0_ENABLE_SHIFT)
#define  MPMU_TIMERS_TWR0_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TWR0_ENABLE_MASK) | (((uint32_t)val) << MPMU_TIMERS_TWR0_ENABLE_SHIFT))

#define  MPMU_TIMERS_TWR0_RESERVED1_MASK 0x7ffffff0
#define  MPMU_TIMERS_TWR0_RESERVED1_SHIFT 4
#define  MPMU_TIMERS_TWR0_RESERVED1_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TWR0_RESERVED1_MASK) >> MPMU_TIMERS_TWR0_RESERVED1_SHIFT)
#define  MPMU_TIMERS_TWR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TWR0_RESERVED1_MASK) | (((uint32_t)val) << MPMU_TIMERS_TWR0_RESERVED1_SHIFT))

#define  MPMU_TIMERS_TWR0_SERVICE_MASK 0xf
#define  MPMU_TIMERS_TWR0_SERVICE_SHIFT 0
#define  MPMU_TIMERS_TWR0_SERVICE_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TWR0_SERVICE_MASK) >> MPMU_TIMERS_TWR0_SERVICE_SHIFT)
#define  MPMU_TIMERS_TWR0_SERVICE_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TWR0_SERVICE_MASK) | (((uint32_t)val) << MPMU_TIMERS_TWR0_SERVICE_SHIFT))

//====================================================================
//Register: Timers Interrupt Status Register (TISR)
/** \brief This register provides the raw interrupt status. The TimerIRQ[3:0] interrupt request lines are passed to an Interrupt Controller. The TimerIRQ lines are individually maskable using the Interrupt Controller's Interrupt Enable Register.*/
//====================================================================

#define  MPMU_TIMERS_TISR_RESERVED1_MASK 0xfffffff0
#define  MPMU_TIMERS_TISR_RESERVED1_SHIFT 4
#define  MPMU_TIMERS_TISR_RESERVED1_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TISR_RESERVED1_MASK) >> MPMU_TIMERS_TISR_RESERVED1_SHIFT)
#define  MPMU_TIMERS_TISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TISR_RESERVED1_MASK) | (((uint32_t)val) << MPMU_TIMERS_TISR_RESERVED1_SHIFT))

#define  MPMU_TIMERS_TISR_STATUS3_MASK 0x8
#define  MPMU_TIMERS_TISR_STATUS3_SHIFT 3
#define  MPMU_TIMERS_TISR_STATUS3_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TISR_STATUS3_MASK) >> MPMU_TIMERS_TISR_STATUS3_SHIFT)
#define  MPMU_TIMERS_TISR_STATUS3_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TISR_STATUS3_MASK) | (((uint32_t)val) << MPMU_TIMERS_TISR_STATUS3_SHIFT))

#define  MPMU_TIMERS_TISR_STATUS2_MASK 0x4
#define  MPMU_TIMERS_TISR_STATUS2_SHIFT 2
#define  MPMU_TIMERS_TISR_STATUS2_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TISR_STATUS2_MASK) >> MPMU_TIMERS_TISR_STATUS2_SHIFT)
#define  MPMU_TIMERS_TISR_STATUS2_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TISR_STATUS2_MASK) | (((uint32_t)val) << MPMU_TIMERS_TISR_STATUS2_SHIFT))

#define  MPMU_TIMERS_TISR_STATUS1_MASK 0x2
#define  MPMU_TIMERS_TISR_STATUS1_SHIFT 1
#define  MPMU_TIMERS_TISR_STATUS1_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TISR_STATUS1_MASK) >> MPMU_TIMERS_TISR_STATUS1_SHIFT)
#define  MPMU_TIMERS_TISR_STATUS1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TISR_STATUS1_MASK) | (((uint32_t)val) << MPMU_TIMERS_TISR_STATUS1_SHIFT))

#define  MPMU_TIMERS_TISR_STATUS0_MASK 0x1
#define  MPMU_TIMERS_TISR_STATUS0_SHIFT 0
#define  MPMU_TIMERS_TISR_STATUS0_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TISR_STATUS0_MASK) >> MPMU_TIMERS_TISR_STATUS0_SHIFT)
#define  MPMU_TIMERS_TISR_STATUS0_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TISR_STATUS0_MASK) | (((uint32_t)val) << MPMU_TIMERS_TISR_STATUS0_SHIFT))

//====================================================================
//Register: Timers Interrupt Acknowledge Register (TIAR)
/** \brief This register is written to acknowledge and clear the TimerIRQs.*/
//====================================================================

#define  MPMU_TIMERS_TIAR_RESERVED1_MASK 0xfffffff0
#define  MPMU_TIMERS_TIAR_RESERVED1_SHIFT 4
#define  MPMU_TIMERS_TIAR_RESERVED1_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TIAR_RESERVED1_MASK) >> MPMU_TIMERS_TIAR_RESERVED1_SHIFT)
#define  MPMU_TIMERS_TIAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TIAR_RESERVED1_MASK) | (((uint32_t)val) << MPMU_TIMERS_TIAR_RESERVED1_SHIFT))

#define  MPMU_TIMERS_TIAR_ACK3_MASK 0x8
#define  MPMU_TIMERS_TIAR_ACK3_SHIFT 3
#define  MPMU_TIMERS_TIAR_ACK3_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TIAR_ACK3_MASK) >> MPMU_TIMERS_TIAR_ACK3_SHIFT)
#define  MPMU_TIMERS_TIAR_ACK3_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TIAR_ACK3_MASK) | (((uint32_t)val) << MPMU_TIMERS_TIAR_ACK3_SHIFT))

#define  MPMU_TIMERS_TIAR_ACK2_MASK 0x4
#define  MPMU_TIMERS_TIAR_ACK2_SHIFT 2
#define  MPMU_TIMERS_TIAR_ACK2_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TIAR_ACK2_MASK) >> MPMU_TIMERS_TIAR_ACK2_SHIFT)
#define  MPMU_TIMERS_TIAR_ACK2_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TIAR_ACK2_MASK) | (((uint32_t)val) << MPMU_TIMERS_TIAR_ACK2_SHIFT))

#define  MPMU_TIMERS_TIAR_ACK1_MASK 0x2
#define  MPMU_TIMERS_TIAR_ACK1_SHIFT 1
#define  MPMU_TIMERS_TIAR_ACK1_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TIAR_ACK1_MASK) >> MPMU_TIMERS_TIAR_ACK1_SHIFT)
#define  MPMU_TIMERS_TIAR_ACK1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TIAR_ACK1_MASK) | (((uint32_t)val) << MPMU_TIMERS_TIAR_ACK1_SHIFT))

#define  MPMU_TIMERS_TIAR_ACK0_MASK 0x1
#define  MPMU_TIMERS_TIAR_ACK0_SHIFT 0
#define  MPMU_TIMERS_TIAR_ACK0_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TIAR_ACK0_MASK) >> MPMU_TIMERS_TIAR_ACK0_SHIFT)
#define  MPMU_TIMERS_TIAR_ACK0_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TIAR_ACK0_MASK) | (((uint32_t)val) << MPMU_TIMERS_TIAR_ACK0_SHIFT))

//====================================================================
//Register: Timer0 Terminal Count Register (TTCR0)
/** \brief This register sets the final count where the interrupt is generated. For Continuous mode the counter will reset to zero on the next timebase period; otherwise, the counter will stop at the terminal count (programmed in this register) in terminal count mode (Control register bit[2]=0) or at the current count in terminal pulse mode (Control bit[2]=1).*/
//====================================================================

#define  MPMU_TIMERS_TTCR0_TERMINALCOUNT_MASK 0xffffffff
#define  MPMU_TIMERS_TTCR0_TERMINALCOUNT_SHIFT 0
#define  MPMU_TIMERS_TTCR0_TERMINALCOUNT_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TTCR0_TERMINALCOUNT_MASK) >> MPMU_TIMERS_TTCR0_TERMINALCOUNT_SHIFT)
#define  MPMU_TIMERS_TTCR0_TERMINALCOUNT_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TTCR0_TERMINALCOUNT_MASK) | (((uint32_t)val) << MPMU_TIMERS_TTCR0_TERMINALCOUNT_SHIFT))

//====================================================================
//Register: Timer0 Control Register (TCR0)
/** \brief The control register is used to configure the operation of the timer. The timer count is reset when the counter is enabled (Enable bit changes from 0 to 1). When in continuous mode (see bit[1]), the counter will reset and continue after reaching the terminal event, otherwise the timer stops when reaching the terminal event. The Terminal event (see bit[2]) can be a pulse on the external input signal or a pre-programmed count. <BR>
            The timer counter may be disabled (write Enable bit to 0 after it was originally enabled) to lock the count value. The resulting count value can be read from the Timer Status Register.*/
//====================================================================

#define  MPMU_TIMERS_TCR0_RESERVED1_MASK 0xffffff80
#define  MPMU_TIMERS_TCR0_RESERVED1_SHIFT 7
#define  MPMU_TIMERS_TCR0_RESERVED1_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TCR0_RESERVED1_MASK) >> MPMU_TIMERS_TCR0_RESERVED1_SHIFT)
#define  MPMU_TIMERS_TCR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TCR0_RESERVED1_MASK) | (((uint32_t)val) << MPMU_TIMERS_TCR0_RESERVED1_SHIFT))

#define  MPMU_TIMERS_TCR0_TIMEBASESEL_MASK 0x70
#define  MPMU_TIMERS_TCR0_TIMEBASESEL_SHIFT 4
#define  MPMU_TIMERS_TCR0_TIMEBASESEL_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TCR0_TIMEBASESEL_MASK) >> MPMU_TIMERS_TCR0_TIMEBASESEL_SHIFT)
#define  MPMU_TIMERS_TCR0_TIMEBASESEL_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TCR0_TIMEBASESEL_MASK) | (((uint32_t)val) << MPMU_TIMERS_TCR0_TIMEBASESEL_SHIFT))

#define  MPMU_TIMERS_TCR0_POLARITY_MASK 0x8
#define  MPMU_TIMERS_TCR0_POLARITY_SHIFT 3
#define  MPMU_TIMERS_TCR0_POLARITY_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TCR0_POLARITY_MASK) >> MPMU_TIMERS_TCR0_POLARITY_SHIFT)
#define  MPMU_TIMERS_TCR0_POLARITY_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TCR0_POLARITY_MASK) | (((uint32_t)val) << MPMU_TIMERS_TCR0_POLARITY_SHIFT))

#define  MPMU_TIMERS_TCR0_TERMINALMODE_MASK 0x4
#define  MPMU_TIMERS_TCR0_TERMINALMODE_SHIFT 2
#define  MPMU_TIMERS_TCR0_TERMINALMODE_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TCR0_TERMINALMODE_MASK) >> MPMU_TIMERS_TCR0_TERMINALMODE_SHIFT)
#define  MPMU_TIMERS_TCR0_TERMINALMODE_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TCR0_TERMINALMODE_MASK) | (((uint32_t)val) << MPMU_TIMERS_TCR0_TERMINALMODE_SHIFT))

#define  MPMU_TIMERS_TCR0_CONTMODE_MASK 0x2
#define  MPMU_TIMERS_TCR0_CONTMODE_SHIFT 1
#define  MPMU_TIMERS_TCR0_CONTMODE_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TCR0_CONTMODE_MASK) >> MPMU_TIMERS_TCR0_CONTMODE_SHIFT)
#define  MPMU_TIMERS_TCR0_CONTMODE_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TCR0_CONTMODE_MASK) | (((uint32_t)val) << MPMU_TIMERS_TCR0_CONTMODE_SHIFT))

#define  MPMU_TIMERS_TCR0_ENABLE_MASK 0x1
#define  MPMU_TIMERS_TCR0_ENABLE_SHIFT 0
#define  MPMU_TIMERS_TCR0_ENABLE_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TCR0_ENABLE_MASK) >> MPMU_TIMERS_TCR0_ENABLE_SHIFT)
#define  MPMU_TIMERS_TCR0_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TCR0_ENABLE_MASK) | (((uint32_t)val) << MPMU_TIMERS_TCR0_ENABLE_SHIFT))

//====================================================================
//Register: Timer0 Status Register (TSR0)
/** \brief The Status register returns the current timer count value, which updates on each timebase tick (selected by Control Timebase Input Select bits), as long the timer is enabled (Control.Enable=1).<BR>
            When the timer has been enabled and is counting, the timer counter may be disabled (write Control.Enable bit to 0) and the counter locks the current value, so that firmware can read the current count. NOTE - when the timer is re-enabled (write Enable bit to 1), the count value is reset to zero.<BR>
            If firmware wishes to obtain a reliable count value without having to disable the timer, firmware can rely on the TimerIRQ to indicate that the final count is reached. Alternatively, firmware can do two consecutive reads of the Status register, and two identical consecutive readings means that the count value is valid because it has not updated since the last timebase tick. For these two methods to work, be sure to set the Control.Enable bit to 1, and the Control.ContinuousMode bit to 0 (stop when reach terminal event).<BR>
            When the timer is configured to stop counting when reaching a terminal pulse event (Control.ContMode bit is 0, and Control.TerminalMode bit is 1), this registers returns the elapsed time between two consecutive pulses. The TimerIRQ interrupt indicates when the final count is ready to read from this register. This functional mode is useful, for example, for measuring the external fan speed. The count is directly related to the fan rpm's.*/
//====================================================================

#define  MPMU_TIMERS_TSR0_COUNT_MASK 0xffffffff
#define  MPMU_TIMERS_TSR0_COUNT_SHIFT 0
#define  MPMU_TIMERS_TSR0_COUNT_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TSR0_COUNT_MASK) >> MPMU_TIMERS_TSR0_COUNT_SHIFT)
#define  MPMU_TIMERS_TSR0_COUNT_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TSR0_COUNT_MASK) | (((uint32_t)val) << MPMU_TIMERS_TSR0_COUNT_SHIFT))

//====================================================================
//Register: Timer1 Terminal Count Register (TTCR1)
/** \brief See description for Timer0 Terminal Count Register.*/
//====================================================================

#define  MPMU_TIMERS_TTCR1_TERMINALCOUNT_MASK 0xffffffff
#define  MPMU_TIMERS_TTCR1_TERMINALCOUNT_SHIFT 0
#define  MPMU_TIMERS_TTCR1_TERMINALCOUNT_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TTCR1_TERMINALCOUNT_MASK) >> MPMU_TIMERS_TTCR1_TERMINALCOUNT_SHIFT)
#define  MPMU_TIMERS_TTCR1_TERMINALCOUNT_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TTCR1_TERMINALCOUNT_MASK) | (((uint32_t)val) << MPMU_TIMERS_TTCR1_TERMINALCOUNT_SHIFT))

//====================================================================
//Register: Timer1 Control Register (TCR1)
/** \brief See description for Timer0 Control Register.*/
//====================================================================

#define  MPMU_TIMERS_TCR1_RESERVED1_MASK 0xffffff80
#define  MPMU_TIMERS_TCR1_RESERVED1_SHIFT 7
#define  MPMU_TIMERS_TCR1_RESERVED1_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TCR1_RESERVED1_MASK) >> MPMU_TIMERS_TCR1_RESERVED1_SHIFT)
#define  MPMU_TIMERS_TCR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TCR1_RESERVED1_MASK) | (((uint32_t)val) << MPMU_TIMERS_TCR1_RESERVED1_SHIFT))

#define  MPMU_TIMERS_TCR1_TIMEBASESEL_MASK 0x70
#define  MPMU_TIMERS_TCR1_TIMEBASESEL_SHIFT 4
#define  MPMU_TIMERS_TCR1_TIMEBASESEL_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TCR1_TIMEBASESEL_MASK) >> MPMU_TIMERS_TCR1_TIMEBASESEL_SHIFT)
#define  MPMU_TIMERS_TCR1_TIMEBASESEL_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TCR1_TIMEBASESEL_MASK) | (((uint32_t)val) << MPMU_TIMERS_TCR1_TIMEBASESEL_SHIFT))

#define  MPMU_TIMERS_TCR1_POLARITY_MASK 0x8
#define  MPMU_TIMERS_TCR1_POLARITY_SHIFT 3
#define  MPMU_TIMERS_TCR1_POLARITY_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TCR1_POLARITY_MASK) >> MPMU_TIMERS_TCR1_POLARITY_SHIFT)
#define  MPMU_TIMERS_TCR1_POLARITY_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TCR1_POLARITY_MASK) | (((uint32_t)val) << MPMU_TIMERS_TCR1_POLARITY_SHIFT))

#define  MPMU_TIMERS_TCR1_TERMINALMODE_MASK 0x4
#define  MPMU_TIMERS_TCR1_TERMINALMODE_SHIFT 2
#define  MPMU_TIMERS_TCR1_TERMINALMODE_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TCR1_TERMINALMODE_MASK) >> MPMU_TIMERS_TCR1_TERMINALMODE_SHIFT)
#define  MPMU_TIMERS_TCR1_TERMINALMODE_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TCR1_TERMINALMODE_MASK) | (((uint32_t)val) << MPMU_TIMERS_TCR1_TERMINALMODE_SHIFT))

#define  MPMU_TIMERS_TCR1_CONTMODE_MASK 0x2
#define  MPMU_TIMERS_TCR1_CONTMODE_SHIFT 1
#define  MPMU_TIMERS_TCR1_CONTMODE_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TCR1_CONTMODE_MASK) >> MPMU_TIMERS_TCR1_CONTMODE_SHIFT)
#define  MPMU_TIMERS_TCR1_CONTMODE_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TCR1_CONTMODE_MASK) | (((uint32_t)val) << MPMU_TIMERS_TCR1_CONTMODE_SHIFT))

#define  MPMU_TIMERS_TCR1_ENABLE_MASK 0x1
#define  MPMU_TIMERS_TCR1_ENABLE_SHIFT 0
#define  MPMU_TIMERS_TCR1_ENABLE_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TCR1_ENABLE_MASK) >> MPMU_TIMERS_TCR1_ENABLE_SHIFT)
#define  MPMU_TIMERS_TCR1_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TCR1_ENABLE_MASK) | (((uint32_t)val) << MPMU_TIMERS_TCR1_ENABLE_SHIFT))

//====================================================================
//Register: Timer1 Status Register (TSR1)
/** \brief See description for Timer0 Status Register.*/
//====================================================================

#define  MPMU_TIMERS_TSR1_COUNT_MASK 0xffffffff
#define  MPMU_TIMERS_TSR1_COUNT_SHIFT 0
#define  MPMU_TIMERS_TSR1_COUNT_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TSR1_COUNT_MASK) >> MPMU_TIMERS_TSR1_COUNT_SHIFT)
#define  MPMU_TIMERS_TSR1_COUNT_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TSR1_COUNT_MASK) | (((uint32_t)val) << MPMU_TIMERS_TSR1_COUNT_SHIFT))

//====================================================================
//Register: Timer2 Terminal Count Register (TTCR2)
/** \brief See description for Timer0 Terminal Count Register.*/
//====================================================================

#define  MPMU_TIMERS_TTCR2_TERMINALCOUNT_MASK 0xffffffff
#define  MPMU_TIMERS_TTCR2_TERMINALCOUNT_SHIFT 0
#define  MPMU_TIMERS_TTCR2_TERMINALCOUNT_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TTCR2_TERMINALCOUNT_MASK) >> MPMU_TIMERS_TTCR2_TERMINALCOUNT_SHIFT)
#define  MPMU_TIMERS_TTCR2_TERMINALCOUNT_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TTCR2_TERMINALCOUNT_MASK) | (((uint32_t)val) << MPMU_TIMERS_TTCR2_TERMINALCOUNT_SHIFT))

//====================================================================
//Register: Timer2 Control Register (TCR2)
/** \brief See description for Timer0 Control Register.*/
//====================================================================

#define  MPMU_TIMERS_TCR2_RESERVED1_MASK 0xffffff80
#define  MPMU_TIMERS_TCR2_RESERVED1_SHIFT 7
#define  MPMU_TIMERS_TCR2_RESERVED1_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TCR2_RESERVED1_MASK) >> MPMU_TIMERS_TCR2_RESERVED1_SHIFT)
#define  MPMU_TIMERS_TCR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TCR2_RESERVED1_MASK) | (((uint32_t)val) << MPMU_TIMERS_TCR2_RESERVED1_SHIFT))

#define  MPMU_TIMERS_TCR2_TIMEBASESEL_MASK 0x70
#define  MPMU_TIMERS_TCR2_TIMEBASESEL_SHIFT 4
#define  MPMU_TIMERS_TCR2_TIMEBASESEL_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TCR2_TIMEBASESEL_MASK) >> MPMU_TIMERS_TCR2_TIMEBASESEL_SHIFT)
#define  MPMU_TIMERS_TCR2_TIMEBASESEL_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TCR2_TIMEBASESEL_MASK) | (((uint32_t)val) << MPMU_TIMERS_TCR2_TIMEBASESEL_SHIFT))

#define  MPMU_TIMERS_TCR2_POLARITY_MASK 0x8
#define  MPMU_TIMERS_TCR2_POLARITY_SHIFT 3
#define  MPMU_TIMERS_TCR2_POLARITY_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TCR2_POLARITY_MASK) >> MPMU_TIMERS_TCR2_POLARITY_SHIFT)
#define  MPMU_TIMERS_TCR2_POLARITY_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TCR2_POLARITY_MASK) | (((uint32_t)val) << MPMU_TIMERS_TCR2_POLARITY_SHIFT))

#define  MPMU_TIMERS_TCR2_TERMINALMODE_MASK 0x4
#define  MPMU_TIMERS_TCR2_TERMINALMODE_SHIFT 2
#define  MPMU_TIMERS_TCR2_TERMINALMODE_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TCR2_TERMINALMODE_MASK) >> MPMU_TIMERS_TCR2_TERMINALMODE_SHIFT)
#define  MPMU_TIMERS_TCR2_TERMINALMODE_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TCR2_TERMINALMODE_MASK) | (((uint32_t)val) << MPMU_TIMERS_TCR2_TERMINALMODE_SHIFT))

#define  MPMU_TIMERS_TCR2_CONTMODE_MASK 0x2
#define  MPMU_TIMERS_TCR2_CONTMODE_SHIFT 1
#define  MPMU_TIMERS_TCR2_CONTMODE_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TCR2_CONTMODE_MASK) >> MPMU_TIMERS_TCR2_CONTMODE_SHIFT)
#define  MPMU_TIMERS_TCR2_CONTMODE_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TCR2_CONTMODE_MASK) | (((uint32_t)val) << MPMU_TIMERS_TCR2_CONTMODE_SHIFT))

#define  MPMU_TIMERS_TCR2_ENABLE_MASK 0x1
#define  MPMU_TIMERS_TCR2_ENABLE_SHIFT 0
#define  MPMU_TIMERS_TCR2_ENABLE_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TCR2_ENABLE_MASK) >> MPMU_TIMERS_TCR2_ENABLE_SHIFT)
#define  MPMU_TIMERS_TCR2_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TCR2_ENABLE_MASK) | (((uint32_t)val) << MPMU_TIMERS_TCR2_ENABLE_SHIFT))

//====================================================================
//Register: Timer2 Status Register (TSR2)
/** \brief See description for Timer0 Status Register.*/
//====================================================================

#define  MPMU_TIMERS_TSR2_COUNT_MASK 0xffffffff
#define  MPMU_TIMERS_TSR2_COUNT_SHIFT 0
#define  MPMU_TIMERS_TSR2_COUNT_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TSR2_COUNT_MASK) >> MPMU_TIMERS_TSR2_COUNT_SHIFT)
#define  MPMU_TIMERS_TSR2_COUNT_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TSR2_COUNT_MASK) | (((uint32_t)val) << MPMU_TIMERS_TSR2_COUNT_SHIFT))

//====================================================================
//Register: Timer3 Terminal Count Register (TTCR3)
/** \brief See description for Timer0 Terminal Count Register.*/
//====================================================================

#define  MPMU_TIMERS_TTCR3_TERMINALCOUNT_MASK 0xffffffff
#define  MPMU_TIMERS_TTCR3_TERMINALCOUNT_SHIFT 0
#define  MPMU_TIMERS_TTCR3_TERMINALCOUNT_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TTCR3_TERMINALCOUNT_MASK) >> MPMU_TIMERS_TTCR3_TERMINALCOUNT_SHIFT)
#define  MPMU_TIMERS_TTCR3_TERMINALCOUNT_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TTCR3_TERMINALCOUNT_MASK) | (((uint32_t)val) << MPMU_TIMERS_TTCR3_TERMINALCOUNT_SHIFT))

//====================================================================
//Register: Timer3 Control Register (TCR3)
/** \brief See description for Timer0 Control Register.*/
//====================================================================

#define  MPMU_TIMERS_TCR3_RESERVED1_MASK 0xffffff80
#define  MPMU_TIMERS_TCR3_RESERVED1_SHIFT 7
#define  MPMU_TIMERS_TCR3_RESERVED1_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TCR3_RESERVED1_MASK) >> MPMU_TIMERS_TCR3_RESERVED1_SHIFT)
#define  MPMU_TIMERS_TCR3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TCR3_RESERVED1_MASK) | (((uint32_t)val) << MPMU_TIMERS_TCR3_RESERVED1_SHIFT))

#define  MPMU_TIMERS_TCR3_TIMEBASESEL_MASK 0x70
#define  MPMU_TIMERS_TCR3_TIMEBASESEL_SHIFT 4
#define  MPMU_TIMERS_TCR3_TIMEBASESEL_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TCR3_TIMEBASESEL_MASK) >> MPMU_TIMERS_TCR3_TIMEBASESEL_SHIFT)
#define  MPMU_TIMERS_TCR3_TIMEBASESEL_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TCR3_TIMEBASESEL_MASK) | (((uint32_t)val) << MPMU_TIMERS_TCR3_TIMEBASESEL_SHIFT))

#define  MPMU_TIMERS_TCR3_POLARITY_MASK 0x8
#define  MPMU_TIMERS_TCR3_POLARITY_SHIFT 3
#define  MPMU_TIMERS_TCR3_POLARITY_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TCR3_POLARITY_MASK) >> MPMU_TIMERS_TCR3_POLARITY_SHIFT)
#define  MPMU_TIMERS_TCR3_POLARITY_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TCR3_POLARITY_MASK) | (((uint32_t)val) << MPMU_TIMERS_TCR3_POLARITY_SHIFT))

#define  MPMU_TIMERS_TCR3_TERMINALMODE_MASK 0x4
#define  MPMU_TIMERS_TCR3_TERMINALMODE_SHIFT 2
#define  MPMU_TIMERS_TCR3_TERMINALMODE_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TCR3_TERMINALMODE_MASK) >> MPMU_TIMERS_TCR3_TERMINALMODE_SHIFT)
#define  MPMU_TIMERS_TCR3_TERMINALMODE_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TCR3_TERMINALMODE_MASK) | (((uint32_t)val) << MPMU_TIMERS_TCR3_TERMINALMODE_SHIFT))

#define  MPMU_TIMERS_TCR3_CONTMODE_MASK 0x2
#define  MPMU_TIMERS_TCR3_CONTMODE_SHIFT 1
#define  MPMU_TIMERS_TCR3_CONTMODE_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TCR3_CONTMODE_MASK) >> MPMU_TIMERS_TCR3_CONTMODE_SHIFT)
#define  MPMU_TIMERS_TCR3_CONTMODE_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TCR3_CONTMODE_MASK) | (((uint32_t)val) << MPMU_TIMERS_TCR3_CONTMODE_SHIFT))

#define  MPMU_TIMERS_TCR3_ENABLE_MASK 0x1
#define  MPMU_TIMERS_TCR3_ENABLE_SHIFT 0
#define  MPMU_TIMERS_TCR3_ENABLE_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TCR3_ENABLE_MASK) >> MPMU_TIMERS_TCR3_ENABLE_SHIFT)
#define  MPMU_TIMERS_TCR3_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TCR3_ENABLE_MASK) | (((uint32_t)val) << MPMU_TIMERS_TCR3_ENABLE_SHIFT))

//====================================================================
//Register: Timer3 Status Register (TSR3)
/** \brief See description for Timer0 Status Register.*/
//====================================================================

#define  MPMU_TIMERS_TSR3_COUNT_MASK 0xffffffff
#define  MPMU_TIMERS_TSR3_COUNT_SHIFT 0
#define  MPMU_TIMERS_TSR3_COUNT_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_TSR3_COUNT_MASK) >> MPMU_TIMERS_TSR3_COUNT_SHIFT)
#define  MPMU_TIMERS_TSR3_COUNT_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_TSR3_COUNT_MASK) | (((uint32_t)val) << MPMU_TIMERS_TSR3_COUNT_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  MPMU_TIMERS_REV0_MAJ_MASK 0xffff0000
#define  MPMU_TIMERS_REV0_MAJ_SHIFT 16
#define  MPMU_TIMERS_REV0_MAJ_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_REV0_MAJ_MASK) >> MPMU_TIMERS_REV0_MAJ_SHIFT)
#define  MPMU_TIMERS_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_REV0_MAJ_MASK) | (((uint32_t)val) << MPMU_TIMERS_REV0_MAJ_SHIFT))

#define  MPMU_TIMERS_REV0_MID_MASK 0xffff
#define  MPMU_TIMERS_REV0_MID_SHIFT 0
#define  MPMU_TIMERS_REV0_MID_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_REV0_MID_MASK) >> MPMU_TIMERS_REV0_MID_SHIFT)
#define  MPMU_TIMERS_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_REV0_MID_MASK) | (((uint32_t)val) << MPMU_TIMERS_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  MPMU_TIMERS_REV1_RESERVED1_MASK 0xffff0000
#define  MPMU_TIMERS_REV1_RESERVED1_SHIFT 16
#define  MPMU_TIMERS_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_REV1_RESERVED1_MASK) >> MPMU_TIMERS_REV1_RESERVED1_SHIFT)
#define  MPMU_TIMERS_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_REV1_RESERVED1_MASK) | (((uint32_t)val) << MPMU_TIMERS_REV1_RESERVED1_SHIFT))

#define  MPMU_TIMERS_REV1_CFG_MASK 0xffff
#define  MPMU_TIMERS_REV1_CFG_SHIFT 0
#define  MPMU_TIMERS_REV1_CFG_MASK_SHIFT(reg) (((reg) & MPMU_TIMERS_REV1_CFG_MASK) >> MPMU_TIMERS_REV1_CFG_SHIFT)
#define  MPMU_TIMERS_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~MPMU_TIMERS_REV1_CFG_MASK) | (((uint32_t)val) << MPMU_TIMERS_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: Automatic Voltage Sense Control Registers (AVS)
/** \brief Registers for firmware configuration and status of MISL_0028LP_AVS hardmacro.
    <BR>
    <BR>
    The names of register fields are identical to the port names of the hardmacro model.
    See MISL_0028LP_AVS specification/datasheet document for usage of the register bits.*/
//
//====================================================================

//====================================================================
//Register: AVS Control and Configuration register (Control)
/** \brief This register controls/configures the AVS hardmacro. <BR>*/
//====================================================================

#define  AVS_CONTROL_RESERVED1_MASK 0xffff0000
#define  AVS_CONTROL_RESERVED1_SHIFT 16
#define  AVS_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & AVS_CONTROL_RESERVED1_MASK) >> AVS_CONTROL_RESERVED1_SHIFT)
#define  AVS_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AVS_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << AVS_CONTROL_RESERVED1_SHIFT))

#define  AVS_CONTROL_DRIVER_BIAS_CFG_MASK 0xf000
#define  AVS_CONTROL_DRIVER_BIAS_CFG_SHIFT 12
#define  AVS_CONTROL_DRIVER_BIAS_CFG_MASK_SHIFT(reg) (((reg) & AVS_CONTROL_DRIVER_BIAS_CFG_MASK) >> AVS_CONTROL_DRIVER_BIAS_CFG_SHIFT)
#define  AVS_CONTROL_DRIVER_BIAS_CFG_REPLACE_VAL(reg,val) (((reg) & ~AVS_CONTROL_DRIVER_BIAS_CFG_MASK) | (((uint32_t)val) << AVS_CONTROL_DRIVER_BIAS_CFG_SHIFT))

#define  AVS_CONTROL_OFFSET_DISCHARGE_RATE_MASK 0xf00
#define  AVS_CONTROL_OFFSET_DISCHARGE_RATE_SHIFT 8
#define  AVS_CONTROL_OFFSET_DISCHARGE_RATE_MASK_SHIFT(reg) (((reg) & AVS_CONTROL_OFFSET_DISCHARGE_RATE_MASK) >> AVS_CONTROL_OFFSET_DISCHARGE_RATE_SHIFT)
#define  AVS_CONTROL_OFFSET_DISCHARGE_RATE_REPLACE_VAL(reg,val) (((reg) & ~AVS_CONTROL_OFFSET_DISCHARGE_RATE_MASK) | (((uint32_t)val) << AVS_CONTROL_OFFSET_DISCHARGE_RATE_SHIFT))

#define  AVS_CONTROL_RESERVED2_MASK 0x80
#define  AVS_CONTROL_RESERVED2_SHIFT 7
#define  AVS_CONTROL_RESERVED2_MASK_SHIFT(reg) (((reg) & AVS_CONTROL_RESERVED2_MASK) >> AVS_CONTROL_RESERVED2_SHIFT)
#define  AVS_CONTROL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~AVS_CONTROL_RESERVED2_MASK) | (((uint32_t)val) << AVS_CONTROL_RESERVED2_SHIFT))

#define  AVS_CONTROL_INC_OFFSET_RANGE_MASK 0x40
#define  AVS_CONTROL_INC_OFFSET_RANGE_SHIFT 6
#define  AVS_CONTROL_INC_OFFSET_RANGE_MASK_SHIFT(reg) (((reg) & AVS_CONTROL_INC_OFFSET_RANGE_MASK) >> AVS_CONTROL_INC_OFFSET_RANGE_SHIFT)
#define  AVS_CONTROL_INC_OFFSET_RANGE_REPLACE_VAL(reg,val) (((reg) & ~AVS_CONTROL_INC_OFFSET_RANGE_MASK) | (((uint32_t)val) << AVS_CONTROL_INC_OFFSET_RANGE_SHIFT))

#define  AVS_CONTROL_MIN_MAX_VAL_RST_MASK 0x20
#define  AVS_CONTROL_MIN_MAX_VAL_RST_SHIFT 5
#define  AVS_CONTROL_MIN_MAX_VAL_RST_MASK_SHIFT(reg) (((reg) & AVS_CONTROL_MIN_MAX_VAL_RST_MASK) >> AVS_CONTROL_MIN_MAX_VAL_RST_SHIFT)
#define  AVS_CONTROL_MIN_MAX_VAL_RST_REPLACE_VAL(reg,val) (((reg) & ~AVS_CONTROL_MIN_MAX_VAL_RST_MASK) | (((uint32_t)val) << AVS_CONTROL_MIN_MAX_VAL_RST_SHIFT))

#define  AVS_CONTROL_AVS_PAUSE_MASK 0x10
#define  AVS_CONTROL_AVS_PAUSE_SHIFT 4
#define  AVS_CONTROL_AVS_PAUSE_MASK_SHIFT(reg) (((reg) & AVS_CONTROL_AVS_PAUSE_MASK) >> AVS_CONTROL_AVS_PAUSE_SHIFT)
#define  AVS_CONTROL_AVS_PAUSE_REPLACE_VAL(reg,val) (((reg) & ~AVS_CONTROL_AVS_PAUSE_MASK) | (((uint32_t)val) << AVS_CONTROL_AVS_PAUSE_SHIFT))

#define  AVS_CONTROL_SELECT_VSENSE0_MASK 0x8
#define  AVS_CONTROL_SELECT_VSENSE0_SHIFT 3
#define  AVS_CONTROL_SELECT_VSENSE0_MASK_SHIFT(reg) (((reg) & AVS_CONTROL_SELECT_VSENSE0_MASK) >> AVS_CONTROL_SELECT_VSENSE0_SHIFT)
#define  AVS_CONTROL_SELECT_VSENSE0_REPLACE_VAL(reg,val) (((reg) & ~AVS_CONTROL_SELECT_VSENSE0_MASK) | (((uint32_t)val) << AVS_CONTROL_SELECT_VSENSE0_SHIFT))

#define  AVS_CONTROL_EN_AVDD_DET_MASK 0x4
#define  AVS_CONTROL_EN_AVDD_DET_SHIFT 2
#define  AVS_CONTROL_EN_AVDD_DET_MASK_SHIFT(reg) (((reg) & AVS_CONTROL_EN_AVDD_DET_MASK) >> AVS_CONTROL_EN_AVDD_DET_SHIFT)
#define  AVS_CONTROL_EN_AVDD_DET_REPLACE_VAL(reg,val) (((reg) & ~AVS_CONTROL_EN_AVDD_DET_MASK) | (((uint32_t)val) << AVS_CONTROL_EN_AVDD_DET_SHIFT))

#define  AVS_CONTROL_ENABLE_MASK 0x2
#define  AVS_CONTROL_ENABLE_SHIFT 1
#define  AVS_CONTROL_ENABLE_MASK_SHIFT(reg) (((reg) & AVS_CONTROL_ENABLE_MASK) >> AVS_CONTROL_ENABLE_SHIFT)
#define  AVS_CONTROL_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~AVS_CONTROL_ENABLE_MASK) | (((uint32_t)val) << AVS_CONTROL_ENABLE_SHIFT))

#define  AVS_CONTROL_RST_B_MASK 0x1
#define  AVS_CONTROL_RST_B_SHIFT 0
#define  AVS_CONTROL_RST_B_MASK_SHIFT(reg) (((reg) & AVS_CONTROL_RST_B_MASK) >> AVS_CONTROL_RST_B_SHIFT)
#define  AVS_CONTROL_RST_B_REPLACE_VAL(reg,val) (((reg) & ~AVS_CONTROL_RST_B_MASK) | (((uint32_t)val) << AVS_CONTROL_RST_B_SHIFT))

//====================================================================
//Register: AVS Delta Voltage register (DeltaVoltage)
/** \brief Configure AVS delta voltage control. <BR>*/
//====================================================================

#define  AVS_DELTAVOLTAGE_RESERVED1_MASK 0xffff0000
#define  AVS_DELTAVOLTAGE_RESERVED1_SHIFT 16
#define  AVS_DELTAVOLTAGE_RESERVED1_MASK_SHIFT(reg) (((reg) & AVS_DELTAVOLTAGE_RESERVED1_MASK) >> AVS_DELTAVOLTAGE_RESERVED1_SHIFT)
#define  AVS_DELTAVOLTAGE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AVS_DELTAVOLTAGE_RESERVED1_MASK) | (((uint32_t)val) << AVS_DELTAVOLTAGE_RESERVED1_SHIFT))

#define  AVS_DELTAVOLTAGE_MANUAL_DELTA_MASK 0xff00
#define  AVS_DELTAVOLTAGE_MANUAL_DELTA_SHIFT 8
#define  AVS_DELTAVOLTAGE_MANUAL_DELTA_MASK_SHIFT(reg) (((reg) & AVS_DELTAVOLTAGE_MANUAL_DELTA_MASK) >> AVS_DELTAVOLTAGE_MANUAL_DELTA_SHIFT)
#define  AVS_DELTAVOLTAGE_MANUAL_DELTA_REPLACE_VAL(reg,val) (((reg) & ~AVS_DELTAVOLTAGE_MANUAL_DELTA_MASK) | (((uint32_t)val) << AVS_DELTAVOLTAGE_MANUAL_DELTA_SHIFT))

#define  AVS_DELTAVOLTAGE_RESERVED2_MASK 0xfe
#define  AVS_DELTAVOLTAGE_RESERVED2_SHIFT 1
#define  AVS_DELTAVOLTAGE_RESERVED2_MASK_SHIFT(reg) (((reg) & AVS_DELTAVOLTAGE_RESERVED2_MASK) >> AVS_DELTAVOLTAGE_RESERVED2_SHIFT)
#define  AVS_DELTAVOLTAGE_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~AVS_DELTAVOLTAGE_RESERVED2_MASK) | (((uint32_t)val) << AVS_DELTAVOLTAGE_RESERVED2_SHIFT))

#define  AVS_DELTAVOLTAGE_MANUAL_MASK 0x1
#define  AVS_DELTAVOLTAGE_MANUAL_SHIFT 0
#define  AVS_DELTAVOLTAGE_MANUAL_MASK_SHIFT(reg) (((reg) & AVS_DELTAVOLTAGE_MANUAL_MASK) >> AVS_DELTAVOLTAGE_MANUAL_SHIFT)
#define  AVS_DELTAVOLTAGE_MANUAL_REPLACE_VAL(reg,val) (((reg) & ~AVS_DELTAVOLTAGE_MANUAL_MASK) | (((uint32_t)val) << AVS_DELTAVOLTAGE_MANUAL_SHIFT))

//====================================================================
//Register: AVS VDD Limits register (VddLimit)
/** \brief Configure AVS VDD limits, used for Fixed Voltage mode of control. <BR>*/
//====================================================================

#define  AVS_VDDLIMIT_RESERVED1_MASK 0xffffc000
#define  AVS_VDDLIMIT_RESERVED1_SHIFT 14
#define  AVS_VDDLIMIT_RESERVED1_MASK_SHIFT(reg) (((reg) & AVS_VDDLIMIT_RESERVED1_MASK) >> AVS_VDDLIMIT_RESERVED1_SHIFT)
#define  AVS_VDDLIMIT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AVS_VDDLIMIT_RESERVED1_MASK) | (((uint32_t)val) << AVS_VDDLIMIT_RESERVED1_SHIFT))

#define  AVS_VDDLIMIT_HIGH_VDD_LIMIT_MASK 0x3f00
#define  AVS_VDDLIMIT_HIGH_VDD_LIMIT_SHIFT 8
#define  AVS_VDDLIMIT_HIGH_VDD_LIMIT_MASK_SHIFT(reg) (((reg) & AVS_VDDLIMIT_HIGH_VDD_LIMIT_MASK) >> AVS_VDDLIMIT_HIGH_VDD_LIMIT_SHIFT)
#define  AVS_VDDLIMIT_HIGH_VDD_LIMIT_REPLACE_VAL(reg,val) (((reg) & ~AVS_VDDLIMIT_HIGH_VDD_LIMIT_MASK) | (((uint32_t)val) << AVS_VDDLIMIT_HIGH_VDD_LIMIT_SHIFT))

#define  AVS_VDDLIMIT_RESERVED2_MASK 0xc0
#define  AVS_VDDLIMIT_RESERVED2_SHIFT 6
#define  AVS_VDDLIMIT_RESERVED2_MASK_SHIFT(reg) (((reg) & AVS_VDDLIMIT_RESERVED2_MASK) >> AVS_VDDLIMIT_RESERVED2_SHIFT)
#define  AVS_VDDLIMIT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~AVS_VDDLIMIT_RESERVED2_MASK) | (((uint32_t)val) << AVS_VDDLIMIT_RESERVED2_SHIFT))

#define  AVS_VDDLIMIT_LOW_VDD_LIMIT_MASK 0x3f
#define  AVS_VDDLIMIT_LOW_VDD_LIMIT_SHIFT 0
#define  AVS_VDDLIMIT_LOW_VDD_LIMIT_MASK_SHIFT(reg) (((reg) & AVS_VDDLIMIT_LOW_VDD_LIMIT_MASK) >> AVS_VDDLIMIT_LOW_VDD_LIMIT_SHIFT)
#define  AVS_VDDLIMIT_LOW_VDD_LIMIT_REPLACE_VAL(reg,val) (((reg) & ~AVS_VDDLIMIT_LOW_VDD_LIMIT_MASK) | (((uint32_t)val) << AVS_VDDLIMIT_LOW_VDD_LIMIT_SHIFT))

//====================================================================
//Register: AVS Internal Voltage and Bandgap Calibration register (Calibration)
//====================================================================

#define  AVS_CALIBRATION_RESERVED1_MASK 0xffff8000
#define  AVS_CALIBRATION_RESERVED1_SHIFT 15
#define  AVS_CALIBRATION_RESERVED1_MASK_SHIFT(reg) (((reg) & AVS_CALIBRATION_RESERVED1_MASK) >> AVS_CALIBRATION_RESERVED1_SHIFT)
#define  AVS_CALIBRATION_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AVS_CALIBRATION_RESERVED1_MASK) | (((uint32_t)val) << AVS_CALIBRATION_RESERVED1_SHIFT))

#define  AVS_CALIBRATION_BG_CAL_MAN_MASK 0x4000
#define  AVS_CALIBRATION_BG_CAL_MAN_SHIFT 14
#define  AVS_CALIBRATION_BG_CAL_MAN_MASK_SHIFT(reg) (((reg) & AVS_CALIBRATION_BG_CAL_MAN_MASK) >> AVS_CALIBRATION_BG_CAL_MAN_SHIFT)
#define  AVS_CALIBRATION_BG_CAL_MAN_REPLACE_VAL(reg,val) (((reg) & ~AVS_CALIBRATION_BG_CAL_MAN_MASK) | (((uint32_t)val) << AVS_CALIBRATION_BG_CAL_MAN_SHIFT))

#define  AVS_CALIBRATION_BG_CAL_EXT_MASK 0x3f00
#define  AVS_CALIBRATION_BG_CAL_EXT_SHIFT 8
#define  AVS_CALIBRATION_BG_CAL_EXT_MASK_SHIFT(reg) (((reg) & AVS_CALIBRATION_BG_CAL_EXT_MASK) >> AVS_CALIBRATION_BG_CAL_EXT_SHIFT)
#define  AVS_CALIBRATION_BG_CAL_EXT_REPLACE_VAL(reg,val) (((reg) & ~AVS_CALIBRATION_BG_CAL_EXT_MASK) | (((uint32_t)val) << AVS_CALIBRATION_BG_CAL_EXT_SHIFT))

#define  AVS_CALIBRATION_BG_CFG_MASK 0xe0
#define  AVS_CALIBRATION_BG_CFG_SHIFT 5
#define  AVS_CALIBRATION_BG_CFG_MASK_SHIFT(reg) (((reg) & AVS_CALIBRATION_BG_CFG_MASK) >> AVS_CALIBRATION_BG_CFG_SHIFT)
#define  AVS_CALIBRATION_BG_CFG_REPLACE_VAL(reg,val) (((reg) & ~AVS_CALIBRATION_BG_CFG_MASK) | (((uint32_t)val) << AVS_CALIBRATION_BG_CFG_SHIFT))

#define  AVS_CALIBRATION_BG_TRIM_MASK 0x18
#define  AVS_CALIBRATION_BG_TRIM_SHIFT 3
#define  AVS_CALIBRATION_BG_TRIM_MASK_SHIFT(reg) (((reg) & AVS_CALIBRATION_BG_TRIM_MASK) >> AVS_CALIBRATION_BG_TRIM_SHIFT)
#define  AVS_CALIBRATION_BG_TRIM_REPLACE_VAL(reg,val) (((reg) & ~AVS_CALIBRATION_BG_TRIM_MASK) | (((uint32_t)val) << AVS_CALIBRATION_BG_TRIM_SHIFT))

#define  AVS_CALIBRATION_DIV_CAL_MASK 0x7
#define  AVS_CALIBRATION_DIV_CAL_SHIFT 0
#define  AVS_CALIBRATION_DIV_CAL_MASK_SHIFT(reg) (((reg) & AVS_CALIBRATION_DIV_CAL_MASK) >> AVS_CALIBRATION_DIV_CAL_SHIFT)
#define  AVS_CALIBRATION_DIV_CAL_REPLACE_VAL(reg,val) (((reg) & ~AVS_CALIBRATION_DIV_CAL_MASK) | (((uint32_t)val) << AVS_CALIBRATION_DIV_CAL_SHIFT))

//====================================================================
//Register: DRO Mode 1 register (DroMode1)
/** \brief This register provides settings for DRO mode of voltage control (vs. Fixed Voltage mode). <BR>*/
//====================================================================

#define  AVS_DROMODE1_DRO_COUNT_INTERVAL_MASK 0xffff0000
#define  AVS_DROMODE1_DRO_COUNT_INTERVAL_SHIFT 16
#define  AVS_DROMODE1_DRO_COUNT_INTERVAL_MASK_SHIFT(reg) (((reg) & AVS_DROMODE1_DRO_COUNT_INTERVAL_MASK) >> AVS_DROMODE1_DRO_COUNT_INTERVAL_SHIFT)
#define  AVS_DROMODE1_DRO_COUNT_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~AVS_DROMODE1_DRO_COUNT_INTERVAL_MASK) | (((uint32_t)val) << AVS_DROMODE1_DRO_COUNT_INTERVAL_SHIFT))

#define  AVS_DROMODE1_SPEED_TARGET_MASK 0xffff
#define  AVS_DROMODE1_SPEED_TARGET_SHIFT 0
#define  AVS_DROMODE1_SPEED_TARGET_MASK_SHIFT(reg) (((reg) & AVS_DROMODE1_SPEED_TARGET_MASK) >> AVS_DROMODE1_SPEED_TARGET_SHIFT)
#define  AVS_DROMODE1_SPEED_TARGET_REPLACE_VAL(reg,val) (((reg) & ~AVS_DROMODE1_SPEED_TARGET_MASK) | (((uint32_t)val) << AVS_DROMODE1_SPEED_TARGET_SHIFT))

//====================================================================
//Register: DRO Mode 2 register (DroMode2)
/** \brief This register provides settings for DRO mode of voltage control (vs. Fixed Voltage mode). <BR>*/
//====================================================================

#define  AVS_DROMODE2_RESERVED1_MASK 0xfffffff8
#define  AVS_DROMODE2_RESERVED1_SHIFT 3
#define  AVS_DROMODE2_RESERVED1_MASK_SHIFT(reg) (((reg) & AVS_DROMODE2_RESERVED1_MASK) >> AVS_DROMODE2_RESERVED1_SHIFT)
#define  AVS_DROMODE2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AVS_DROMODE2_RESERVED1_MASK) | (((uint32_t)val) << AVS_DROMODE2_RESERVED1_SHIFT))

#define  AVS_DROMODE2_AVG_MASK 0x7
#define  AVS_DROMODE2_AVG_SHIFT 0
#define  AVS_DROMODE2_AVG_MASK_SHIFT(reg) (((reg) & AVS_DROMODE2_AVG_MASK) >> AVS_DROMODE2_AVG_SHIFT)
#define  AVS_DROMODE2_AVG_REPLACE_VAL(reg,val) (((reg) & ~AVS_DROMODE2_AVG_MASK) | (((uint32_t)val) << AVS_DROMODE2_AVG_SHIFT))

//====================================================================
//Register:  AVS Fast Travel Control and Configuration register (FastTravel)
//====================================================================

#define  AVS_FASTTRAVEL_RESERVED1_MASK 0xfff80000
#define  AVS_FASTTRAVEL_RESERVED1_SHIFT 19
#define  AVS_FASTTRAVEL_RESERVED1_MASK_SHIFT(reg) (((reg) & AVS_FASTTRAVEL_RESERVED1_MASK) >> AVS_FASTTRAVEL_RESERVED1_SHIFT)
#define  AVS_FASTTRAVEL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AVS_FASTTRAVEL_RESERVED1_MASK) | (((uint32_t)val) << AVS_FASTTRAVEL_RESERVED1_SHIFT))

#define  AVS_FASTTRAVEL_FAST_VOLTAGE_CHANGE_TRIGGER_MASK 0x40000
#define  AVS_FASTTRAVEL_FAST_VOLTAGE_CHANGE_TRIGGER_SHIFT 18
#define  AVS_FASTTRAVEL_FAST_VOLTAGE_CHANGE_TRIGGER_MASK_SHIFT(reg) (((reg) & AVS_FASTTRAVEL_FAST_VOLTAGE_CHANGE_TRIGGER_MASK) >> AVS_FASTTRAVEL_FAST_VOLTAGE_CHANGE_TRIGGER_SHIFT)
#define  AVS_FASTTRAVEL_FAST_VOLTAGE_CHANGE_TRIGGER_REPLACE_VAL(reg,val) (((reg) & ~AVS_FASTTRAVEL_FAST_VOLTAGE_CHANGE_TRIGGER_MASK) | (((uint32_t)val) << AVS_FASTTRAVEL_FAST_VOLTAGE_CHANGE_TRIGGER_SHIFT))

#define  AVS_FASTTRAVEL_VOLTAGE_CHANGE_RATE_MASK 0x3ff00
#define  AVS_FASTTRAVEL_VOLTAGE_CHANGE_RATE_SHIFT 8
#define  AVS_FASTTRAVEL_VOLTAGE_CHANGE_RATE_MASK_SHIFT(reg) (((reg) & AVS_FASTTRAVEL_VOLTAGE_CHANGE_RATE_MASK) >> AVS_FASTTRAVEL_VOLTAGE_CHANGE_RATE_SHIFT)
#define  AVS_FASTTRAVEL_VOLTAGE_CHANGE_RATE_REPLACE_VAL(reg,val) (((reg) & ~AVS_FASTTRAVEL_VOLTAGE_CHANGE_RATE_MASK) | (((uint32_t)val) << AVS_FASTTRAVEL_VOLTAGE_CHANGE_RATE_SHIFT))

#define  AVS_FASTTRAVEL_TARGET_DELTA_MASK 0xff
#define  AVS_FASTTRAVEL_TARGET_DELTA_SHIFT 0
#define  AVS_FASTTRAVEL_TARGET_DELTA_MASK_SHIFT(reg) (((reg) & AVS_FASTTRAVEL_TARGET_DELTA_MASK) >> AVS_FASTTRAVEL_TARGET_DELTA_SHIFT)
#define  AVS_FASTTRAVEL_TARGET_DELTA_REPLACE_VAL(reg,val) (((reg) & ~AVS_FASTTRAVEL_TARGET_DELTA_MASK) | (((uint32_t)val) << AVS_FASTTRAVEL_TARGET_DELTA_SHIFT))

//====================================================================
//Register: AVS Test Configuration register (Test)
//====================================================================

#define  AVS_TEST_RESERVED1_MASK 0xfffffff0
#define  AVS_TEST_RESERVED1_SHIFT 4
#define  AVS_TEST_RESERVED1_MASK_SHIFT(reg) (((reg) & AVS_TEST_RESERVED1_MASK) >> AVS_TEST_RESERVED1_SHIFT)
#define  AVS_TEST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AVS_TEST_RESERVED1_MASK) | (((uint32_t)val) << AVS_TEST_RESERVED1_SHIFT))

#define  AVS_TEST_TP_CFG_MASK 0xf
#define  AVS_TEST_TP_CFG_SHIFT 0
#define  AVS_TEST_TP_CFG_MASK_SHIFT(reg) (((reg) & AVS_TEST_TP_CFG_MASK) >> AVS_TEST_TP_CFG_SHIFT)
#define  AVS_TEST_TP_CFG_REPLACE_VAL(reg,val) (((reg) & ~AVS_TEST_TP_CFG_MASK) | (((uint32_t)val) << AVS_TEST_TP_CFG_SHIFT))

//====================================================================
//Register: AVS Status register (Status)
/** \brief This register provides various AVS hardmacro states. <BR>*/
//====================================================================

#define  AVS_STATUS_RESERVED1_MASK 0xffffc000
#define  AVS_STATUS_RESERVED1_SHIFT 14
#define  AVS_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & AVS_STATUS_RESERVED1_MASK) >> AVS_STATUS_RESERVED1_SHIFT)
#define  AVS_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AVS_STATUS_RESERVED1_MASK) | (((uint32_t)val) << AVS_STATUS_RESERVED1_SHIFT))

#define  AVS_STATUS_BG_CAL_VALUE_MASK 0x3f00
#define  AVS_STATUS_BG_CAL_VALUE_SHIFT 8
#define  AVS_STATUS_BG_CAL_VALUE_MASK_SHIFT(reg) (((reg) & AVS_STATUS_BG_CAL_VALUE_MASK) >> AVS_STATUS_BG_CAL_VALUE_SHIFT)
#define  AVS_STATUS_BG_CAL_VALUE_REPLACE_VAL(reg,val) (((reg) & ~AVS_STATUS_BG_CAL_VALUE_MASK) | (((uint32_t)val) << AVS_STATUS_BG_CAL_VALUE_SHIFT))

#define  AVS_STATUS_RESERVED2_MASK 0xc0
#define  AVS_STATUS_RESERVED2_SHIFT 6
#define  AVS_STATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & AVS_STATUS_RESERVED2_MASK) >> AVS_STATUS_RESERVED2_SHIFT)
#define  AVS_STATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~AVS_STATUS_RESERVED2_MASK) | (((uint32_t)val) << AVS_STATUS_RESERVED2_SHIFT))

#define  AVS_STATUS_OUT_SLAVE_AVS_VOLTAGE_UP_MASK 0x20
#define  AVS_STATUS_OUT_SLAVE_AVS_VOLTAGE_UP_SHIFT 5
#define  AVS_STATUS_OUT_SLAVE_AVS_VOLTAGE_UP_MASK_SHIFT(reg) (((reg) & AVS_STATUS_OUT_SLAVE_AVS_VOLTAGE_UP_MASK) >> AVS_STATUS_OUT_SLAVE_AVS_VOLTAGE_UP_SHIFT)
#define  AVS_STATUS_OUT_SLAVE_AVS_VOLTAGE_UP_REPLACE_VAL(reg,val) (((reg) & ~AVS_STATUS_OUT_SLAVE_AVS_VOLTAGE_UP_MASK) | (((uint32_t)val) << AVS_STATUS_OUT_SLAVE_AVS_VOLTAGE_UP_SHIFT))

#define  AVS_STATUS_FAST_TRAVEL_INDICATION_MASK 0x10
#define  AVS_STATUS_FAST_TRAVEL_INDICATION_SHIFT 4
#define  AVS_STATUS_FAST_TRAVEL_INDICATION_MASK_SHIFT(reg) (((reg) & AVS_STATUS_FAST_TRAVEL_INDICATION_MASK) >> AVS_STATUS_FAST_TRAVEL_INDICATION_SHIFT)
#define  AVS_STATUS_FAST_TRAVEL_INDICATION_REPLACE_VAL(reg,val) (((reg) & ~AVS_STATUS_FAST_TRAVEL_INDICATION_MASK) | (((uint32_t)val) << AVS_STATUS_FAST_TRAVEL_INDICATION_SHIFT))

#define  AVS_STATUS_ABOVE_LIMIT_STICKY_MASK 0x8
#define  AVS_STATUS_ABOVE_LIMIT_STICKY_SHIFT 3
#define  AVS_STATUS_ABOVE_LIMIT_STICKY_MASK_SHIFT(reg) (((reg) & AVS_STATUS_ABOVE_LIMIT_STICKY_MASK) >> AVS_STATUS_ABOVE_LIMIT_STICKY_SHIFT)
#define  AVS_STATUS_ABOVE_LIMIT_STICKY_REPLACE_VAL(reg,val) (((reg) & ~AVS_STATUS_ABOVE_LIMIT_STICKY_MASK) | (((uint32_t)val) << AVS_STATUS_ABOVE_LIMIT_STICKY_SHIFT))

#define  AVS_STATUS_BELOW_LIMIT_STICKY_MASK 0x4
#define  AVS_STATUS_BELOW_LIMIT_STICKY_SHIFT 2
#define  AVS_STATUS_BELOW_LIMIT_STICKY_MASK_SHIFT(reg) (((reg) & AVS_STATUS_BELOW_LIMIT_STICKY_MASK) >> AVS_STATUS_BELOW_LIMIT_STICKY_SHIFT)
#define  AVS_STATUS_BELOW_LIMIT_STICKY_REPLACE_VAL(reg,val) (((reg) & ~AVS_STATUS_BELOW_LIMIT_STICKY_MASK) | (((uint32_t)val) << AVS_STATUS_BELOW_LIMIT_STICKY_SHIFT))

#define  AVS_STATUS_ABOVE_LIMIT_MASK 0x2
#define  AVS_STATUS_ABOVE_LIMIT_SHIFT 1
#define  AVS_STATUS_ABOVE_LIMIT_MASK_SHIFT(reg) (((reg) & AVS_STATUS_ABOVE_LIMIT_MASK) >> AVS_STATUS_ABOVE_LIMIT_SHIFT)
#define  AVS_STATUS_ABOVE_LIMIT_REPLACE_VAL(reg,val) (((reg) & ~AVS_STATUS_ABOVE_LIMIT_MASK) | (((uint32_t)val) << AVS_STATUS_ABOVE_LIMIT_SHIFT))

#define  AVS_STATUS_BELOW_LIMIT_MASK 0x1
#define  AVS_STATUS_BELOW_LIMIT_SHIFT 0
#define  AVS_STATUS_BELOW_LIMIT_MASK_SHIFT(reg) (((reg) & AVS_STATUS_BELOW_LIMIT_MASK) >> AVS_STATUS_BELOW_LIMIT_SHIFT)
#define  AVS_STATUS_BELOW_LIMIT_REPLACE_VAL(reg,val) (((reg) & ~AVS_STATUS_BELOW_LIMIT_MASK) | (((uint32_t)val) << AVS_STATUS_BELOW_LIMIT_SHIFT))

//====================================================================
//Register: AVS Delta Status register (DeltaStatus)
//====================================================================

#define  AVS_DELTASTATUS_RESERVED1_MASK 0xff000000
#define  AVS_DELTASTATUS_RESERVED1_SHIFT 24
#define  AVS_DELTASTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & AVS_DELTASTATUS_RESERVED1_MASK) >> AVS_DELTASTATUS_RESERVED1_SHIFT)
#define  AVS_DELTASTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AVS_DELTASTATUS_RESERVED1_MASK) | (((uint32_t)val) << AVS_DELTASTATUS_RESERVED1_SHIFT))

#define  AVS_DELTASTATUS_AVS_DELTA_MASK 0xff0000
#define  AVS_DELTASTATUS_AVS_DELTA_SHIFT 16
#define  AVS_DELTASTATUS_AVS_DELTA_MASK_SHIFT(reg) (((reg) & AVS_DELTASTATUS_AVS_DELTA_MASK) >> AVS_DELTASTATUS_AVS_DELTA_SHIFT)
#define  AVS_DELTASTATUS_AVS_DELTA_REPLACE_VAL(reg,val) (((reg) & ~AVS_DELTASTATUS_AVS_DELTA_MASK) | (((uint32_t)val) << AVS_DELTASTATUS_AVS_DELTA_SHIFT))

#define  AVS_DELTASTATUS_MAX_AVS_DELTA_MASK 0xff00
#define  AVS_DELTASTATUS_MAX_AVS_DELTA_SHIFT 8
#define  AVS_DELTASTATUS_MAX_AVS_DELTA_MASK_SHIFT(reg) (((reg) & AVS_DELTASTATUS_MAX_AVS_DELTA_MASK) >> AVS_DELTASTATUS_MAX_AVS_DELTA_SHIFT)
#define  AVS_DELTASTATUS_MAX_AVS_DELTA_REPLACE_VAL(reg,val) (((reg) & ~AVS_DELTASTATUS_MAX_AVS_DELTA_MASK) | (((uint32_t)val) << AVS_DELTASTATUS_MAX_AVS_DELTA_SHIFT))

#define  AVS_DELTASTATUS_MIN_AVS_DELTA_MASK 0xff
#define  AVS_DELTASTATUS_MIN_AVS_DELTA_SHIFT 0
#define  AVS_DELTASTATUS_MIN_AVS_DELTA_MASK_SHIFT(reg) (((reg) & AVS_DELTASTATUS_MIN_AVS_DELTA_MASK) >> AVS_DELTASTATUS_MIN_AVS_DELTA_SHIFT)
#define  AVS_DELTASTATUS_MIN_AVS_DELTA_REPLACE_VAL(reg,val) (((reg) & ~AVS_DELTASTATUS_MIN_AVS_DELTA_MASK) | (((uint32_t)val) << AVS_DELTASTATUS_MIN_AVS_DELTA_SHIFT))

//====================================================================
//Register: AVS DRO Status 1 register (DroStatus1)
//====================================================================

#define  AVS_DROSTATUS1_RESERVED1_MASK 0xffff0000
#define  AVS_DROSTATUS1_RESERVED1_SHIFT 16
#define  AVS_DROSTATUS1_RESERVED1_MASK_SHIFT(reg) (((reg) & AVS_DROSTATUS1_RESERVED1_MASK) >> AVS_DROSTATUS1_RESERVED1_SHIFT)
#define  AVS_DROSTATUS1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AVS_DROSTATUS1_RESERVED1_MASK) | (((uint32_t)val) << AVS_DROSTATUS1_RESERVED1_SHIFT))

#define  AVS_DROSTATUS1_INTER_DRO_COUNT_MASK 0xffff
#define  AVS_DROSTATUS1_INTER_DRO_COUNT_SHIFT 0
#define  AVS_DROSTATUS1_INTER_DRO_COUNT_MASK_SHIFT(reg) (((reg) & AVS_DROSTATUS1_INTER_DRO_COUNT_MASK) >> AVS_DROSTATUS1_INTER_DRO_COUNT_SHIFT)
#define  AVS_DROSTATUS1_INTER_DRO_COUNT_REPLACE_VAL(reg,val) (((reg) & ~AVS_DROSTATUS1_INTER_DRO_COUNT_MASK) | (((uint32_t)val) << AVS_DROSTATUS1_INTER_DRO_COUNT_SHIFT))

//====================================================================
//Register: AVS DRO Status 2 register (DroStatus2)
//====================================================================

#define  AVS_DROSTATUS2_MAX_DRO_COUNT_MASK 0xffff0000
#define  AVS_DROSTATUS2_MAX_DRO_COUNT_SHIFT 16
#define  AVS_DROSTATUS2_MAX_DRO_COUNT_MASK_SHIFT(reg) (((reg) & AVS_DROSTATUS2_MAX_DRO_COUNT_MASK) >> AVS_DROSTATUS2_MAX_DRO_COUNT_SHIFT)
#define  AVS_DROSTATUS2_MAX_DRO_COUNT_REPLACE_VAL(reg,val) (((reg) & ~AVS_DROSTATUS2_MAX_DRO_COUNT_MASK) | (((uint32_t)val) << AVS_DROSTATUS2_MAX_DRO_COUNT_SHIFT))

#define  AVS_DROSTATUS2_MIN_DRO_COUNT_MASK 0xffff
#define  AVS_DROSTATUS2_MIN_DRO_COUNT_SHIFT 0
#define  AVS_DROSTATUS2_MIN_DRO_COUNT_MASK_SHIFT(reg) (((reg) & AVS_DROSTATUS2_MIN_DRO_COUNT_MASK) >> AVS_DROSTATUS2_MIN_DRO_COUNT_SHIFT)
#define  AVS_DROSTATUS2_MIN_DRO_COUNT_REPLACE_VAL(reg,val) (((reg) & ~AVS_DROSTATUS2_MIN_DRO_COUNT_MASK) | (((uint32_t)val) << AVS_DROSTATUS2_MIN_DRO_COUNT_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  AVS_REV0_MAJ_MASK 0xffff0000
#define  AVS_REV0_MAJ_SHIFT 16
#define  AVS_REV0_MAJ_MASK_SHIFT(reg) (((reg) & AVS_REV0_MAJ_MASK) >> AVS_REV0_MAJ_SHIFT)
#define  AVS_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~AVS_REV0_MAJ_MASK) | (((uint32_t)val) << AVS_REV0_MAJ_SHIFT))

#define  AVS_REV0_MID_MASK 0xffff
#define  AVS_REV0_MID_SHIFT 0
#define  AVS_REV0_MID_MASK_SHIFT(reg) (((reg) & AVS_REV0_MID_MASK) >> AVS_REV0_MID_SHIFT)
#define  AVS_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~AVS_REV0_MID_MASK) | (((uint32_t)val) << AVS_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  AVS_REV1_RESERVED1_MASK 0xffff0000
#define  AVS_REV1_RESERVED1_SHIFT 16
#define  AVS_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & AVS_REV1_RESERVED1_MASK) >> AVS_REV1_RESERVED1_SHIFT)
#define  AVS_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AVS_REV1_RESERVED1_MASK) | (((uint32_t)val) << AVS_REV1_RESERVED1_SHIFT))

#define  AVS_REV1_CFG_MASK 0xffff
#define  AVS_REV1_CFG_SHIFT 0
#define  AVS_REV1_CFG_MASK_SHIFT(reg) (((reg) & AVS_REV1_CFG_MASK) >> AVS_REV1_CFG_SHIFT)
#define  AVS_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~AVS_REV1_CFG_MASK) | (((uint32_t)val) << AVS_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: Real Time Clock Control Registers (RTC)
/** \brief (rev 0 . 1 . 1 . 1)
    Register Descriptions for the Swiss RTC.
    Since the interface to the RTC hard macro is only 8-bits wide,
    firmware MUST read each register twice. The first read updates a
    32-bit shadow in the RTC wrapper and the second read reads
    the 32-bit shadow.*/
//
//====================================================================

//====================================================================
//Register: RTC Status Register (Status)
/** \brief This register contains the alarm flags from the RTC.*/
//====================================================================

#define  RTC_STATUS_RESERVED1_MASK 0xfffffffc
#define  RTC_STATUS_RESERVED1_SHIFT 2
#define  RTC_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & RTC_STATUS_RESERVED1_MASK) >> RTC_STATUS_RESERVED1_SHIFT)
#define  RTC_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~RTC_STATUS_RESERVED1_MASK) | (((uint32_t)val) << RTC_STATUS_RESERVED1_SHIFT))

#define  RTC_STATUS_ALARM2_MASK 0x2
#define  RTC_STATUS_ALARM2_SHIFT 1
#define  RTC_STATUS_ALARM2_MASK_SHIFT(reg) (((reg) & RTC_STATUS_ALARM2_MASK) >> RTC_STATUS_ALARM2_SHIFT)
#define  RTC_STATUS_ALARM2_REPLACE_VAL(reg,val) (((reg) & ~RTC_STATUS_ALARM2_MASK) | (((uint32_t)val) << RTC_STATUS_ALARM2_SHIFT))

#define  RTC_STATUS_ALARM1_MASK 0x1
#define  RTC_STATUS_ALARM1_SHIFT 0
#define  RTC_STATUS_ALARM1_MASK_SHIFT(reg) (((reg) & RTC_STATUS_ALARM1_MASK) >> RTC_STATUS_ALARM1_SHIFT)
#define  RTC_STATUS_ALARM1_REPLACE_VAL(reg,val) (((reg) & ~RTC_STATUS_ALARM1_MASK) | (((uint32_t)val) << RTC_STATUS_ALARM1_SHIFT))

//====================================================================
//Register: RTC Interrupt 1 Register (Interrupt1)
/** \brief This register controls Interrupt 1*/
//====================================================================

#define  RTC_INTERRUPT1_RESERVED1_MASK 0xffffffc0
#define  RTC_INTERRUPT1_RESERVED1_SHIFT 6
#define  RTC_INTERRUPT1_RESERVED1_MASK_SHIFT(reg) (((reg) & RTC_INTERRUPT1_RESERVED1_MASK) >> RTC_INTERRUPT1_RESERVED1_SHIFT)
#define  RTC_INTERRUPT1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~RTC_INTERRUPT1_RESERVED1_MASK) | (((uint32_t)val) << RTC_INTERRUPT1_RESERVED1_SHIFT))

#define  RTC_INTERRUPT1_INT1FREQ_MASK 0x3c
#define  RTC_INTERRUPT1_INT1FREQ_SHIFT 2
#define  RTC_INTERRUPT1_INT1FREQ_MASK_SHIFT(reg) (((reg) & RTC_INTERRUPT1_INT1FREQ_MASK) >> RTC_INTERRUPT1_INT1FREQ_SHIFT)
#define  RTC_INTERRUPT1_INT1FREQ_REPLACE_VAL(reg,val) (((reg) & ~RTC_INTERRUPT1_INT1FREQ_MASK) | (((uint32_t)val) << RTC_INTERRUPT1_INT1FREQ_SHIFT))

#define  RTC_INTERRUPT1_INT1FE_MASK 0x2
#define  RTC_INTERRUPT1_INT1FE_SHIFT 1
#define  RTC_INTERRUPT1_INT1FE_MASK_SHIFT(reg) (((reg) & RTC_INTERRUPT1_INT1FE_MASK) >> RTC_INTERRUPT1_INT1FE_SHIFT)
#define  RTC_INTERRUPT1_INT1FE_REPLACE_VAL(reg,val) (((reg) & ~RTC_INTERRUPT1_INT1FE_MASK) | (((uint32_t)val) << RTC_INTERRUPT1_INT1FE_SHIFT))

#define  RTC_INTERRUPT1_INT1AE_MASK 0x1
#define  RTC_INTERRUPT1_INT1AE_SHIFT 0
#define  RTC_INTERRUPT1_INT1AE_MASK_SHIFT(reg) (((reg) & RTC_INTERRUPT1_INT1AE_MASK) >> RTC_INTERRUPT1_INT1AE_SHIFT)
#define  RTC_INTERRUPT1_INT1AE_REPLACE_VAL(reg,val) (((reg) & ~RTC_INTERRUPT1_INT1AE_MASK) | (((uint32_t)val) << RTC_INTERRUPT1_INT1AE_SHIFT))

//====================================================================
//Register: RTC Interrupt 2 Register (Interrupt2)
/** \brief This register controls Interrupt 2*/
//====================================================================

#define  RTC_INTERRUPT2_RESERVED1_MASK 0xffffffc0
#define  RTC_INTERRUPT2_RESERVED1_SHIFT 6
#define  RTC_INTERRUPT2_RESERVED1_MASK_SHIFT(reg) (((reg) & RTC_INTERRUPT2_RESERVED1_MASK) >> RTC_INTERRUPT2_RESERVED1_SHIFT)
#define  RTC_INTERRUPT2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~RTC_INTERRUPT2_RESERVED1_MASK) | (((uint32_t)val) << RTC_INTERRUPT2_RESERVED1_SHIFT))

#define  RTC_INTERRUPT2_INT2FREQ_MASK 0x3c
#define  RTC_INTERRUPT2_INT2FREQ_SHIFT 2
#define  RTC_INTERRUPT2_INT2FREQ_MASK_SHIFT(reg) (((reg) & RTC_INTERRUPT2_INT2FREQ_MASK) >> RTC_INTERRUPT2_INT2FREQ_SHIFT)
#define  RTC_INTERRUPT2_INT2FREQ_REPLACE_VAL(reg,val) (((reg) & ~RTC_INTERRUPT2_INT2FREQ_MASK) | (((uint32_t)val) << RTC_INTERRUPT2_INT2FREQ_SHIFT))

#define  RTC_INTERRUPT2_INT2FE_MASK 0x2
#define  RTC_INTERRUPT2_INT2FE_SHIFT 1
#define  RTC_INTERRUPT2_INT2FE_MASK_SHIFT(reg) (((reg) & RTC_INTERRUPT2_INT2FE_MASK) >> RTC_INTERRUPT2_INT2FE_SHIFT)
#define  RTC_INTERRUPT2_INT2FE_REPLACE_VAL(reg,val) (((reg) & ~RTC_INTERRUPT2_INT2FE_MASK) | (((uint32_t)val) << RTC_INTERRUPT2_INT2FE_SHIFT))

#define  RTC_INTERRUPT2_INT2AE_MASK 0x1
#define  RTC_INTERRUPT2_INT2AE_SHIFT 0
#define  RTC_INTERRUPT2_INT2AE_MASK_SHIFT(reg) (((reg) & RTC_INTERRUPT2_INT2AE_MASK) >> RTC_INTERRUPT2_INT2AE_SHIFT)
#define  RTC_INTERRUPT2_INT2AE_REPLACE_VAL(reg,val) (((reg) & ~RTC_INTERRUPT2_INT2AE_MASK) | (((uint32_t)val) << RTC_INTERRUPT2_INT2AE_SHIFT))

//====================================================================
//Register: RTC Time Register (Time)
/** \brief This register accesses the RTC Timer. This register MUST be written
      twice in order to initialize a new time value (e.g. set the clock).*/
//====================================================================

#define  RTC_TIME_TIME_MASK 0xffffffff
#define  RTC_TIME_TIME_SHIFT 0
#define  RTC_TIME_TIME_MASK_SHIFT(reg) (((reg) & RTC_TIME_TIME_MASK) >> RTC_TIME_TIME_SHIFT)
#define  RTC_TIME_TIME_REPLACE_VAL(reg,val) (((reg) & ~RTC_TIME_TIME_MASK) | (((uint32_t)val) << RTC_TIME_TIME_SHIFT))

//====================================================================
//Register: RTC Alarm 1 Register (Alarm1)
/** \brief This register contains the alarm time. When RTC time matches the
      alarm time and the alarm interrupt is enabled, the alarm port goes
      high for 1 second and the alarm flag is set.*/
//====================================================================

#define  RTC_ALARM1_TIME_MASK 0xffffffff
#define  RTC_ALARM1_TIME_SHIFT 0
#define  RTC_ALARM1_TIME_MASK_SHIFT(reg) (((reg) & RTC_ALARM1_TIME_MASK) >> RTC_ALARM1_TIME_SHIFT)
#define  RTC_ALARM1_TIME_REPLACE_VAL(reg,val) (((reg) & ~RTC_ALARM1_TIME_MASK) | (((uint32_t)val) << RTC_ALARM1_TIME_SHIFT))

//====================================================================
//Register: RTC Alarm 2 Register (Alarm2)
/** \brief This register contains the alarm time. When RTC time matches the
      alarm time and the alarm interrupt is enabled, the alarm port goes
      high for 1 second and the alarm flag is set.*/
//====================================================================

#define  RTC_ALARM2_TIME_MASK 0xffffffff
#define  RTC_ALARM2_TIME_SHIFT 0
#define  RTC_ALARM2_TIME_MASK_SHIFT(reg) (((reg) & RTC_ALARM2_TIME_MASK) >> RTC_ALARM2_TIME_SHIFT)
#define  RTC_ALARM2_TIME_REPLACE_VAL(reg,val) (((reg) & ~RTC_ALARM2_TIME_MASK) | (((uint32_t)val) << RTC_ALARM2_TIME_SHIFT))

//====================================================================
//Register: Clock Correction Register (ClockCorrect)
/** \brief This register sets the clock correction values.*/
//====================================================================

#define  RTC_CLOCKCORRECT_RESERVED1_MASK 0xffff0000
#define  RTC_CLOCKCORRECT_RESERVED1_SHIFT 16
#define  RTC_CLOCKCORRECT_RESERVED1_MASK_SHIFT(reg) (((reg) & RTC_CLOCKCORRECT_RESERVED1_MASK) >> RTC_CLOCKCORRECT_RESERVED1_SHIFT)
#define  RTC_CLOCKCORRECT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~RTC_CLOCKCORRECT_RESERVED1_MASK) | (((uint32_t)val) << RTC_CLOCKCORRECT_RESERVED1_SHIFT))

#define  RTC_CLOCKCORRECT_CMODE_MASK 0x8000
#define  RTC_CLOCKCORRECT_CMODE_SHIFT 15
#define  RTC_CLOCKCORRECT_CMODE_MASK_SHIFT(reg) (((reg) & RTC_CLOCKCORRECT_CMODE_MASK) >> RTC_CLOCKCORRECT_CMODE_SHIFT)
#define  RTC_CLOCKCORRECT_CMODE_REPLACE_VAL(reg,val) (((reg) & ~RTC_CLOCKCORRECT_CMODE_MASK) | (((uint32_t)val) << RTC_CLOCKCORRECT_CMODE_SHIFT))

#define  RTC_CLOCKCORRECT_CVAL_EXT_MASK 0x7f00
#define  RTC_CLOCKCORRECT_CVAL_EXT_SHIFT 8
#define  RTC_CLOCKCORRECT_CVAL_EXT_MASK_SHIFT(reg) (((reg) & RTC_CLOCKCORRECT_CVAL_EXT_MASK) >> RTC_CLOCKCORRECT_CVAL_EXT_SHIFT)
#define  RTC_CLOCKCORRECT_CVAL_EXT_REPLACE_VAL(reg,val) (((reg) & ~RTC_CLOCKCORRECT_CVAL_EXT_MASK) | (((uint32_t)val) << RTC_CLOCKCORRECT_CVAL_EXT_SHIFT))

#define  RTC_CLOCKCORRECT_CVALUE_MASK 0xff
#define  RTC_CLOCKCORRECT_CVALUE_SHIFT 0
#define  RTC_CLOCKCORRECT_CVALUE_MASK_SHIFT(reg) (((reg) & RTC_CLOCKCORRECT_CVALUE_MASK) >> RTC_CLOCKCORRECT_CVALUE_SHIFT)
#define  RTC_CLOCKCORRECT_CVALUE_REPLACE_VAL(reg,val) (((reg) & ~RTC_CLOCKCORRECT_CVALUE_MASK) | (((uint32_t)val) << RTC_CLOCKCORRECT_CVALUE_SHIFT))

//====================================================================
//Register: RTC Test Configuration Register (TestConfig)
/** \brief This register sets test control bits.*/
//====================================================================

#define  RTC_TESTCONFIG_RESERVED1_MASK 0xffffffe0
#define  RTC_TESTCONFIG_RESERVED1_SHIFT 5
#define  RTC_TESTCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & RTC_TESTCONFIG_RESERVED1_MASK) >> RTC_TESTCONFIG_RESERVED1_SHIFT)
#define  RTC_TESTCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~RTC_TESTCONFIG_RESERVED1_MASK) | (((uint32_t)val) << RTC_TESTCONFIG_RESERVED1_SHIFT))

#define  RTC_TESTCONFIG_FUNCTEST_MASK 0x10
#define  RTC_TESTCONFIG_FUNCTEST_SHIFT 4
#define  RTC_TESTCONFIG_FUNCTEST_MASK_SHIFT(reg) (((reg) & RTC_TESTCONFIG_FUNCTEST_MASK) >> RTC_TESTCONFIG_FUNCTEST_SHIFT)
#define  RTC_TESTCONFIG_FUNCTEST_REPLACE_VAL(reg,val) (((reg) & ~RTC_TESTCONFIG_FUNCTEST_MASK) | (((uint32_t)val) << RTC_TESTCONFIG_FUNCTEST_SHIFT))

#define  RTC_TESTCONFIG_TMODE_MASK 0xf
#define  RTC_TESTCONFIG_TMODE_SHIFT 0
#define  RTC_TESTCONFIG_TMODE_MASK_SHIFT(reg) (((reg) & RTC_TESTCONFIG_TMODE_MASK) >> RTC_TESTCONFIG_TMODE_SHIFT)
#define  RTC_TESTCONFIG_TMODE_REPLACE_VAL(reg,val) (((reg) & ~RTC_TESTCONFIG_TMODE_MASK) | (((uint32_t)val) << RTC_TESTCONFIG_TMODE_SHIFT))

//====================================================================
//Register: RTC Timing Register (Timing)
/** \brief This register controls timing of accesses to the RTC core.*/
//====================================================================

#define  RTC_TIMING_THOLD_MASK 0xff000000
#define  RTC_TIMING_THOLD_SHIFT 24
#define  RTC_TIMING_THOLD_MASK_SHIFT(reg) (((reg) & RTC_TIMING_THOLD_MASK) >> RTC_TIMING_THOLD_SHIFT)
#define  RTC_TIMING_THOLD_REPLACE_VAL(reg,val) (((reg) & ~RTC_TIMING_THOLD_MASK) | (((uint32_t)val) << RTC_TIMING_THOLD_SHIFT))

#define  RTC_TIMING_TDELAY_MASK 0xff0000
#define  RTC_TIMING_TDELAY_SHIFT 16
#define  RTC_TIMING_TDELAY_MASK_SHIFT(reg) (((reg) & RTC_TIMING_TDELAY_MASK) >> RTC_TIMING_TDELAY_SHIFT)
#define  RTC_TIMING_TDELAY_REPLACE_VAL(reg,val) (((reg) & ~RTC_TIMING_TDELAY_MASK) | (((uint32_t)val) << RTC_TIMING_TDELAY_SHIFT))

#define  RTC_TIMING_TCLK_MASK 0xff00
#define  RTC_TIMING_TCLK_SHIFT 8
#define  RTC_TIMING_TCLK_MASK_SHIFT(reg) (((reg) & RTC_TIMING_TCLK_MASK) >> RTC_TIMING_TCLK_SHIFT)
#define  RTC_TIMING_TCLK_REPLACE_VAL(reg,val) (((reg) & ~RTC_TIMING_TCLK_MASK) | (((uint32_t)val) << RTC_TIMING_TCLK_SHIFT))

#define  RTC_TIMING_TSETUP_MASK 0xff
#define  RTC_TIMING_TSETUP_SHIFT 0
#define  RTC_TIMING_TSETUP_MASK_SHIFT(reg) (((reg) & RTC_TIMING_TSETUP_MASK) >> RTC_TIMING_TSETUP_SHIFT)
#define  RTC_TIMING_TSETUP_REPLACE_VAL(reg,val) (((reg) & ~RTC_TIMING_TSETUP_MASK) | (((uint32_t)val) << RTC_TIMING_TSETUP_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  RTC_REV0_MAJ_MASK 0xffff0000
#define  RTC_REV0_MAJ_SHIFT 16
#define  RTC_REV0_MAJ_MASK_SHIFT(reg) (((reg) & RTC_REV0_MAJ_MASK) >> RTC_REV0_MAJ_SHIFT)
#define  RTC_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~RTC_REV0_MAJ_MASK) | (((uint32_t)val) << RTC_REV0_MAJ_SHIFT))

#define  RTC_REV0_MID_MASK 0xffff
#define  RTC_REV0_MID_SHIFT 0
#define  RTC_REV0_MID_MASK_SHIFT(reg) (((reg) & RTC_REV0_MID_MASK) >> RTC_REV0_MID_SHIFT)
#define  RTC_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~RTC_REV0_MID_MASK) | (((uint32_t)val) << RTC_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  RTC_REV1_RESERVED1_MASK 0xffff0000
#define  RTC_REV1_RESERVED1_SHIFT 16
#define  RTC_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & RTC_REV1_RESERVED1_MASK) >> RTC_REV1_RESERVED1_SHIFT)
#define  RTC_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~RTC_REV1_RESERVED1_MASK) | (((uint32_t)val) << RTC_REV1_RESERVED1_SHIFT))

#define  RTC_REV1_CFG_MASK 0xffff
#define  RTC_REV1_CFG_SHIFT 0
#define  RTC_REV1_CFG_MASK_SHIFT(reg) (((reg) & RTC_REV1_CFG_MASK) >> RTC_REV1_CFG_SHIFT)
#define  RTC_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~RTC_REV1_CFG_MASK) | (((uint32_t)val) << RTC_REV1_CFG_SHIFT))

//====================================================================
//Register: RTC Analog Test Pin Config (RTC_ATEST)
/** \brief Controls the enabling and muxing of the analog test signal from the RTC module.*/
//====================================================================

#define  RTC_RTC_ATEST_RESERVED1_MASK 0xfffffffc
#define  RTC_RTC_ATEST_RESERVED1_SHIFT 2
#define  RTC_RTC_ATEST_RESERVED1_MASK_SHIFT(reg) (((reg) & RTC_RTC_ATEST_RESERVED1_MASK) >> RTC_RTC_ATEST_RESERVED1_SHIFT)
#define  RTC_RTC_ATEST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~RTC_RTC_ATEST_RESERVED1_MASK) | (((uint32_t)val) << RTC_RTC_ATEST_RESERVED1_SHIFT))

#define  RTC_RTC_ATEST_TE_MASK 0x2
#define  RTC_RTC_ATEST_TE_SHIFT 1
#define  RTC_RTC_ATEST_TE_MASK_SHIFT(reg) (((reg) & RTC_RTC_ATEST_TE_MASK) >> RTC_RTC_ATEST_TE_SHIFT)
#define  RTC_RTC_ATEST_TE_REPLACE_VAL(reg,val) (((reg) & ~RTC_RTC_ATEST_TE_MASK) | (((uint32_t)val) << RTC_RTC_ATEST_TE_SHIFT))

#define  RTC_RTC_ATEST_TS_MASK 0x1
#define  RTC_RTC_ATEST_TS_SHIFT 0
#define  RTC_RTC_ATEST_TS_MASK_SHIFT(reg) (((reg) & RTC_RTC_ATEST_TS_MASK) >> RTC_RTC_ATEST_TS_SHIFT)
#define  RTC_RTC_ATEST_TS_REPLACE_VAL(reg,val) (((reg) & ~RTC_RTC_ATEST_TS_MASK) | (((uint32_t)val) << RTC_RTC_ATEST_TS_SHIFT))

//====================================================================
//
//Register File: MPMU Miscellaneous Controls (MPMU_misc)
/** \brief These registers provide control/status for various MPMU functions, including interrupts.*/
//
//====================================================================

//====================================================================
//Register: Interrupt Enable Register (IntEnReg)
/** \brief Bit order (high to low): RTC_Alarm2, RTC_Alarm1, Timer3, Timer2, Timer1, Timer0.*/
//====================================================================

#define  MPMU_MISC_INTENREG_RESERVED1_MASK 0xffffffc0
#define  MPMU_MISC_INTENREG_RESERVED1_SHIFT 6
#define  MPMU_MISC_INTENREG_RESERVED1_MASK_SHIFT(reg) (((reg) & MPMU_MISC_INTENREG_RESERVED1_MASK) >> MPMU_MISC_INTENREG_RESERVED1_SHIFT)
#define  MPMU_MISC_INTENREG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_MISC_INTENREG_RESERVED1_MASK) | (((uint32_t)val) << MPMU_MISC_INTENREG_RESERVED1_SHIFT))

#define  MPMU_MISC_INTENREG_INTENABLE_MASK 0x3f
#define  MPMU_MISC_INTENREG_INTENABLE_SHIFT 0
#define  MPMU_MISC_INTENREG_INTENABLE_MASK_SHIFT(reg) (((reg) & MPMU_MISC_INTENREG_INTENABLE_MASK) >> MPMU_MISC_INTENREG_INTENABLE_SHIFT)
#define  MPMU_MISC_INTENREG_INTENABLE_REPLACE_VAL(reg,val) (((reg) & ~MPMU_MISC_INTENREG_INTENABLE_MASK) | (((uint32_t)val) << MPMU_MISC_INTENREG_INTENABLE_SHIFT))

//====================================================================
//Register: Interrupt Pending Register (IntPendReg)
/** \brief See IntEnReg description for bit mapping.*/
//====================================================================

#define  MPMU_MISC_INTPENDREG_RESERVED1_MASK 0xffffffc0
#define  MPMU_MISC_INTPENDREG_RESERVED1_SHIFT 6
#define  MPMU_MISC_INTPENDREG_RESERVED1_MASK_SHIFT(reg) (((reg) & MPMU_MISC_INTPENDREG_RESERVED1_MASK) >> MPMU_MISC_INTPENDREG_RESERVED1_SHIFT)
#define  MPMU_MISC_INTPENDREG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_MISC_INTPENDREG_RESERVED1_MASK) | (((uint32_t)val) << MPMU_MISC_INTPENDREG_RESERVED1_SHIFT))

#define  MPMU_MISC_INTPENDREG_INTPEND_MASK 0x3f
#define  MPMU_MISC_INTPENDREG_INTPEND_SHIFT 0
#define  MPMU_MISC_INTPENDREG_INTPEND_MASK_SHIFT(reg) (((reg) & MPMU_MISC_INTPENDREG_INTPEND_MASK) >> MPMU_MISC_INTPENDREG_INTPEND_SHIFT)
#define  MPMU_MISC_INTPENDREG_INTPEND_REPLACE_VAL(reg,val) (((reg) & ~MPMU_MISC_INTPENDREG_INTPEND_MASK) | (((uint32_t)val) << MPMU_MISC_INTPENDREG_INTPEND_SHIFT))

//====================================================================
//Register: Interrupt Acknowledge Register (IntAckReg)
/** \brief See IntEnReg description for bit mapping.*/
//====================================================================

#define  MPMU_MISC_INTACKREG_RESERVED1_MASK 0xffffffc0
#define  MPMU_MISC_INTACKREG_RESERVED1_SHIFT 6
#define  MPMU_MISC_INTACKREG_RESERVED1_MASK_SHIFT(reg) (((reg) & MPMU_MISC_INTACKREG_RESERVED1_MASK) >> MPMU_MISC_INTACKREG_RESERVED1_SHIFT)
#define  MPMU_MISC_INTACKREG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_MISC_INTACKREG_RESERVED1_MASK) | (((uint32_t)val) << MPMU_MISC_INTACKREG_RESERVED1_SHIFT))

#define  MPMU_MISC_INTACKREG_INTACK_MASK 0x3f
#define  MPMU_MISC_INTACKREG_INTACK_SHIFT 0
#define  MPMU_MISC_INTACKREG_INTACK_MASK_SHIFT(reg) (((reg) & MPMU_MISC_INTACKREG_INTACK_MASK) >> MPMU_MISC_INTACKREG_INTACK_SHIFT)
#define  MPMU_MISC_INTACKREG_INTACK_REPLACE_VAL(reg,val) (((reg) & ~MPMU_MISC_INTACKREG_INTACK_MASK) | (((uint32_t)val) << MPMU_MISC_INTACKREG_INTACK_SHIFT))

//====================================================================
//Register: Interrupt Force Register (IntForceReg)
/** \brief See IntEnReg description for bit mapping.*/
//====================================================================

#define  MPMU_MISC_INTFORCEREG_RESERVED1_MASK 0xffffffc0
#define  MPMU_MISC_INTFORCEREG_RESERVED1_SHIFT 6
#define  MPMU_MISC_INTFORCEREG_RESERVED1_MASK_SHIFT(reg) (((reg) & MPMU_MISC_INTFORCEREG_RESERVED1_MASK) >> MPMU_MISC_INTFORCEREG_RESERVED1_SHIFT)
#define  MPMU_MISC_INTFORCEREG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_MISC_INTFORCEREG_RESERVED1_MASK) | (((uint32_t)val) << MPMU_MISC_INTFORCEREG_RESERVED1_SHIFT))

#define  MPMU_MISC_INTFORCEREG_INTFORCE_MASK 0x3f
#define  MPMU_MISC_INTFORCEREG_INTFORCE_SHIFT 0
#define  MPMU_MISC_INTFORCEREG_INTFORCE_MASK_SHIFT(reg) (((reg) & MPMU_MISC_INTFORCEREG_INTFORCE_MASK) >> MPMU_MISC_INTFORCEREG_INTFORCE_SHIFT)
#define  MPMU_MISC_INTFORCEREG_INTFORCE_REPLACE_VAL(reg,val) (((reg) & ~MPMU_MISC_INTFORCEREG_INTFORCE_MASK) | (((uint32_t)val) << MPMU_MISC_INTFORCEREG_INTFORCE_SHIFT))

//====================================================================
//Register: LVDSAFE PLL0 Clock Delay Configuration (LVDSAFE_PLL0_CLK_CFG)
/** \brief This register provides tuning values for the LVDSAFE0 clock's delay.*/
//====================================================================

#define  MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_RESERVED1_MASK 0xfffffe00
#define  MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_RESERVED1_SHIFT 9
#define  MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_RESERVED1_MASK) >> MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_RESERVED1_SHIFT)
#define  MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_RESERVED1_MASK) | (((uint32_t)val) << MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_RESERVED1_SHIFT))

#define  MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_PHASESEL_MASK 0x100
#define  MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_PHASESEL_SHIFT 8
#define  MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_PHASESEL_MASK_SHIFT(reg) (((reg) & MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_PHASESEL_MASK) >> MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_PHASESEL_SHIFT)
#define  MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_PHASESEL_REPLACE_VAL(reg,val) (((reg) & ~MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_PHASESEL_MASK) | (((uint32_t)val) << MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_PHASESEL_SHIFT))

#define  MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_RESERVED2_MASK 0x80
#define  MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_RESERVED2_SHIFT 7
#define  MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_RESERVED2_MASK) >> MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_RESERVED2_SHIFT)
#define  MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_RESERVED2_MASK) | (((uint32_t)val) << MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_RESERVED2_SHIFT))

#define  MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_DELAYSEL_MASK 0x7f
#define  MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_DELAYSEL_SHIFT 0
#define  MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_DELAYSEL_MASK_SHIFT(reg) (((reg) & MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_DELAYSEL_MASK) >> MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_DELAYSEL_SHIFT)
#define  MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_DELAYSEL_REPLACE_VAL(reg,val) (((reg) & ~MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_DELAYSEL_MASK) | (((uint32_t)val) << MPMU_MISC_LVDSAFE_PLL0_CLK_CFG_DELAYSEL_SHIFT))

//====================================================================
//Register: LVDSAFE PLL1 Clock Delay Configuration (LVDSAFE_PLL1_CLK_CFG)
/** \brief This register provides tuning values for the LVDSAFE1 clock's delay.*/
//====================================================================

#define  MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_RESERVED1_MASK 0xfffffe00
#define  MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_RESERVED1_SHIFT 9
#define  MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_RESERVED1_MASK) >> MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_RESERVED1_SHIFT)
#define  MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_RESERVED1_MASK) | (((uint32_t)val) << MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_RESERVED1_SHIFT))

#define  MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_PHASESEL_MASK 0x100
#define  MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_PHASESEL_SHIFT 8
#define  MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_PHASESEL_MASK_SHIFT(reg) (((reg) & MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_PHASESEL_MASK) >> MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_PHASESEL_SHIFT)
#define  MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_PHASESEL_REPLACE_VAL(reg,val) (((reg) & ~MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_PHASESEL_MASK) | (((uint32_t)val) << MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_PHASESEL_SHIFT))

#define  MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_RESERVED2_MASK 0x80
#define  MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_RESERVED2_SHIFT 7
#define  MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_RESERVED2_MASK) >> MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_RESERVED2_SHIFT)
#define  MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_RESERVED2_MASK) | (((uint32_t)val) << MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_RESERVED2_SHIFT))

#define  MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_DELAYSEL_MASK 0x7f
#define  MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_DELAYSEL_SHIFT 0
#define  MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_DELAYSEL_MASK_SHIFT(reg) (((reg) & MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_DELAYSEL_MASK) >> MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_DELAYSEL_SHIFT)
#define  MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_DELAYSEL_REPLACE_VAL(reg,val) (((reg) & ~MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_DELAYSEL_MASK) | (((uint32_t)val) << MPMU_MISC_LVDSAFE_PLL1_CLK_CFG_DELAYSEL_SHIFT))

//====================================================================
//Register: System PLL Enable register (SYSPLL_Enable)
/** \brief This register allows for gating off the System PLL while changing its frequency. Since
      the normal PLL frequency for this PLL is above the limit for the glitchless bypass mux
      internal to the PLL, it is necessary to gate the clock off when changing into or out of
      the 2.5Ghz frequency for the System PLL.*/
//====================================================================

#define  MPMU_MISC_SYSPLL_ENABLE_RESERVED1_MASK 0xfffffffc
#define  MPMU_MISC_SYSPLL_ENABLE_RESERVED1_SHIFT 2
#define  MPMU_MISC_SYSPLL_ENABLE_RESERVED1_MASK_SHIFT(reg) (((reg) & MPMU_MISC_SYSPLL_ENABLE_RESERVED1_MASK) >> MPMU_MISC_SYSPLL_ENABLE_RESERVED1_SHIFT)
#define  MPMU_MISC_SYSPLL_ENABLE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_MISC_SYSPLL_ENABLE_RESERVED1_MASK) | (((uint32_t)val) << MPMU_MISC_SYSPLL_ENABLE_RESERVED1_SHIFT))

#define  MPMU_MISC_SYSPLL_ENABLE_CLKEN_MASK 0x2
#define  MPMU_MISC_SYSPLL_ENABLE_CLKEN_SHIFT 1
#define  MPMU_MISC_SYSPLL_ENABLE_CLKEN_MASK_SHIFT(reg) (((reg) & MPMU_MISC_SYSPLL_ENABLE_CLKEN_MASK) >> MPMU_MISC_SYSPLL_ENABLE_CLKEN_SHIFT)
#define  MPMU_MISC_SYSPLL_ENABLE_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~MPMU_MISC_SYSPLL_ENABLE_CLKEN_MASK) | (((uint32_t)val) << MPMU_MISC_SYSPLL_ENABLE_CLKEN_SHIFT))

#define  MPMU_MISC_SYSPLL_ENABLE_RESERVED2_MASK 0x1
#define  MPMU_MISC_SYSPLL_ENABLE_RESERVED2_SHIFT 0
#define  MPMU_MISC_SYSPLL_ENABLE_RESERVED2_MASK_SHIFT(reg) (((reg) & MPMU_MISC_SYSPLL_ENABLE_RESERVED2_MASK) >> MPMU_MISC_SYSPLL_ENABLE_RESERVED2_SHIFT)
#define  MPMU_MISC_SYSPLL_ENABLE_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MPMU_MISC_SYSPLL_ENABLE_RESERVED2_MASK) | (((uint32_t)val) << MPMU_MISC_SYSPLL_ENABLE_RESERVED2_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  MPMU_MISC_REV0_MAJ_MASK 0xffff0000
#define  MPMU_MISC_REV0_MAJ_SHIFT 16
#define  MPMU_MISC_REV0_MAJ_MASK_SHIFT(reg) (((reg) & MPMU_MISC_REV0_MAJ_MASK) >> MPMU_MISC_REV0_MAJ_SHIFT)
#define  MPMU_MISC_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~MPMU_MISC_REV0_MAJ_MASK) | (((uint32_t)val) << MPMU_MISC_REV0_MAJ_SHIFT))

#define  MPMU_MISC_REV0_MID_MASK 0xffff
#define  MPMU_MISC_REV0_MID_SHIFT 0
#define  MPMU_MISC_REV0_MID_MASK_SHIFT(reg) (((reg) & MPMU_MISC_REV0_MID_MASK) >> MPMU_MISC_REV0_MID_SHIFT)
#define  MPMU_MISC_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~MPMU_MISC_REV0_MID_MASK) | (((uint32_t)val) << MPMU_MISC_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  MPMU_MISC_REV1_RESERVED1_MASK 0xffff0000
#define  MPMU_MISC_REV1_RESERVED1_SHIFT 16
#define  MPMU_MISC_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & MPMU_MISC_REV1_RESERVED1_MASK) >> MPMU_MISC_REV1_RESERVED1_SHIFT)
#define  MPMU_MISC_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MPMU_MISC_REV1_RESERVED1_MASK) | (((uint32_t)val) << MPMU_MISC_REV1_RESERVED1_SHIFT))

#define  MPMU_MISC_REV1_CFG_MASK 0xffff
#define  MPMU_MISC_REV1_CFG_SHIFT 0
#define  MPMU_MISC_REV1_CFG_MASK_SHIFT(reg) (((reg) & MPMU_MISC_REV1_CFG_MASK) >> MPMU_MISC_REV1_CFG_SHIFT)
#define  MPMU_MISC_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~MPMU_MISC_REV1_CFG_MASK) | (((uint32_t)val) << MPMU_MISC_REV1_CFG_SHIFT))

#endif // MPMU_TOP
