 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _IPMU_TOP_REGSTRUCTS_H_
#define _IPMU_TOP_REGSTRUCTS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: Registers for IPS PMU (IPMU_top)
/** \brief The IPMU provides various registers to control Power Management functions related to the
    Imaging and Printing Subsystem of the SoC.*/
//
//====================================================================

//====================================================================
//
//Register File: IPMU SRAM, Power Island control and miscellaneous registers (IPMU_misc_reg)
/** \brief (rev 0 . 1 . 2 . 6)
    These registers provide control/status for the power islands, SRAMs, and other miscellaneous
    power related functions in the Imaging/Printing section of the chip.*/
//
//====================================================================

typedef struct IPMU_MISC_REG_REGS_s
{
  volatile uint32_t UPCPwrIsland_PICR;  ///< 0x0 [R/W]: UPC Power Island Configuration Register
  volatile uint32_t UPCPwrIsland_PISR;  ///< 0x4 [R]: UPC Power Island Status Register
  volatile uint32_t ImgPwrIsland_PICR;  ///< 0x8 [R/W]: Imaging Power Island Configuration Register
  volatile uint32_t ImgPwrIsland_PISR;  ///< 0xc [R]: Imaging Power Island Status Register
  volatile uint32_t UPCSRAMPdwn_SPCTL;  ///< 0x10 [R/W]: UPC SRAM Powerdown Control Register
  volatile uint32_t UPCSRAMSpeedCtl_SRAMCTL;  ///< 0x14 [R/W]: UPC SRAM Speed Control Register
  volatile uint32_t PIPSRAMPdwn_SPCTL;  ///< 0x18 [R/W]: PIP SRAM Powerdown Control Register
  volatile uint32_t PIPSRAMSpeedCtl_SRAMCTL;  ///< 0x1c [R/W]: PIP SRAM Speed Control Register
  volatile uint32_t PIPSRAMSpeedCtl_SRAMCTL1;  ///< 0x20 [R/W]: PIP SRAM Speed Control Register 1
  volatile uint32_t PIPSRAMSpeedCtl_SRAMCTL2;  ///< 0x24 [R/W]: PIP SRAM Speed Control Register 2
  volatile uint32_t JBIGSRAMPdwn_SPCTL;  ///< 0x28 [R/W]: JBIG SRAM Powerdown Control Register
  volatile uint32_t JBIGSRAMSpeedCtl_SRAMCTL;  ///< 0x2c [R/W]: JBIG SRAM Speed Control Register
  volatile uint32_t JPEGSRAMPdwn_SPCTL;  ///< 0x30 [R/W]: JPEG SRAM Powerdown Control Register
  volatile uint32_t JPEGSRAMSpeedCtl_SRAMCTL;  ///< 0x34 [R/W]: JPEG SRAM Speed Control Register
  volatile uint32_t ICESRAMPdwn_SPCTL;  ///< 0x38 [R/W]: ICE SRAM Powerdown Control Register
  volatile uint32_t ICESRAMSpeedCtl_SRAMCTL;  ///< 0x3c [R/W]: ICE SRAM Speed Control Register
  volatile uint32_t ICESRAMSpeedCtl_SRAMCTL1;  ///< 0x40 [R/W]: ICE SRAM Speed Control Register 1
  volatile uint32_t ICESRAMSpeedCtl_RF2PSRAMCTL;  ///< 0x44 [R/W]: ICE RF2P SRAMSpeed Control Register
  volatile uint32_t ANSRAMPdwn_SPCTL;  ///< 0x48 [R/W]: AN SRAM Powerdown Control Register
  volatile uint32_t ANSRAMSpeedCtl_SRAMCTL;  ///< 0x4c [R/W]: AN SRAM Speed Control Register
  volatile uint32_t ANSRAMSpeedCtl_RF2PSRAMCTL;  ///< 0x50 [R/W]: AN RF2P SRAMSpeed Control Register
  volatile uint32_t ROTSRAMPdwn_SPCTL;  ///< 0x54 [R/W]: Rotate SRAM Powerdown Control Register
  volatile uint32_t ROTSRAMSpeedCtl_SRAMCTL;  ///< 0x58 [R/W]: Rotate SRAM Speed Control Register
  volatile uint32_t LCMSRAMPdwn_SPCTL;  ///< 0x5c [R/W]: LCM SRAM Powerdown Control Register
  volatile uint32_t LCMSRAMSpeedCtl_SRAMCTL;  ///< 0x60 [R/W]: LCM SRAM Speed Control Register
  volatile uint32_t IPSSRAMPdwn_SPCTL;  ///< 0x64 [R/W]: IPS Other SRAM Powerdown Control Register
  volatile uint32_t IPSSRAMSpeedCtl_SRAMCTL;  ///< 0x68 [R/W]: IPS Other SRAM Speed Control Register
  volatile uint32_t IPSSRAMSpeedCtl_RF2PSRAMCTL;  ///< 0x6c [R/W]: IPS Other RF2P SRAMSpeed Control Register
  volatile uint32_t IPSSMMUSRAMPdwn_SPCTL;  ///< 0x70 [R/W]: IPS SMMU SRAM Powerdown Control Register
  volatile uint32_t IPSSMMUSRAMSpeedCtl_SRAMCTL;  ///< 0x74 [R/W]: IPS SMMU SRAM Speed Control Register
  volatile uint32_t VCF_ROMCtl_RCTL;  ///< 0x78 [R/W]: VCF ROM Powerdown/Read Timing Control Register
  volatile uint32_t RepairDone;  ///< 0x7c [R]: Redundancy Repair Done Status Register
  volatile uint32_t IntEnReg;  ///< 0x80 [R/W]: Clock Domain Interrupt Enable Register
  volatile uint32_t IntPendReg;  ///< 0x84 [R]: Clock Domain Interrupt Pending Register
  volatile uint32_t IntAckReg;  ///< 0x88 [W]: Clock Domain Interrupt Acknowledge Register
  volatile uint32_t IntForceReg;  ///< 0x8c [W]: Clock Domain Interrupt Force Register
  volatile uint32_t REV0;  ///< 0x90 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x94 [R]: IP Tagging Revision 1
} IPMU_MISC_REG_REGS_t;

//====================================================================
//
//Register File: IPMU Clock and Reset Control Registers (IPMU_ClkRstGen)
/** \brief These registers provide control/status for the clocks/resets for all of the clock domains
    in the Imaging/Printing section of the chip.*/
//
//====================================================================

typedef struct IPMU_CLKRSTGEN_REGS_s
{
  volatile uint32_t AudioClkPreConfig_ClkGenConfig;  ///< 0x0 [R/W]: AudioClk Pre-divider ClkGen Configuration Register
  volatile uint32_t AudioClkPreConfig_ClkGenStatus;  ///< 0x4 [R]: AudioClk Pre-divider ClkGen Status Register
  volatile uint32_t AudioClkConfig_ClkGenConfig;  ///< 0x8 [R/W]: AudioClk ClkGen Configuration Register
  volatile uint32_t AudioClkConfig_ClkGenStatus;  ///< 0xc [R]: AudioClk ClkGen Status Register
  volatile uint32_t AdcTsenClkConfig_ClkGenConfig;  ///< 0x10 [R/W]: AdcTsenClk ClkGen Configuration Register
  volatile uint32_t AdcTsenClkConfig_ClkGenStatus;  ///< 0x14 [R]: AdcTsenClk ClkGen Status Register
  volatile uint32_t FastNSSClkConfig_ClkGenConfig;  ///< 0x18 [R/W]: FastNssClk ClkGen Configuration Register
  volatile uint32_t FastNSSClkConfig_ClkGenStatus;  ///< 0x1c [R]: FastNssClk ClkGen Status Register
  volatile uint32_t NSSClkConfig_ClkGenConfig;  ///< 0x20 [R/W]: NSSClk ClkGen Configuration Register
  volatile uint32_t NSSClkConfig_ClkGenStatus;  ///< 0x24 [R]: NSSClk ClkGen Status Register
  volatile uint32_t NSSClk_imagingConfig_ClkGenConfig;  ///< 0x28 [R/W]: NSSClk_imaging ClkGen Configuration Register
  volatile uint32_t NSSClk_imagingConfig_ClkGenStatus;  ///< 0x2c [R]: NSSClk_imaging ClkGen Status Register
  volatile uint32_t LVDSAFERefClkConfig_ClkGenConfig;  ///< 0x30 [R/W]: LVDSAFERefClk ClkGen Configuration Register
  volatile uint32_t LVDSAFERefClkConfig_ClkGenStatus;  ///< 0x34 [R]: LVDSAFERefClk ClkGen Status Register
  volatile uint32_t ScanClkConfig_ClkGenConfig;  ///< 0x38 [R/W]: ScanClk ClkGen Configuration Register
  volatile uint32_t ScanClkConfig_ClkGenStatus;  ///< 0x3c [R]: ScanClk ClkGen Status Register
  volatile uint32_t XCPUClkConfig_ClkGenConfig;  ///< 0x40 [R/W]: XCPUClk ClkGen Configuration Register
  volatile uint32_t XCPUClkConfig_ClkGenStatus;  ///< 0x44 [R]: XCPUClk ClkGen Status Register
  volatile uint32_t XIOClkConfig_ClkGenConfig;  ///< 0x48 [R/W]: XIOClk ClkGen Configuration Register
  volatile uint32_t XIOClkConfig_ClkGenStatus;  ///< 0x4c [R]: XIOClk ClkGen Status Register
  volatile uint32_t IPSBusClkConfig_ClkGenConfig;  ///< 0x50 [R/W]: IPSBusClk ClkGen Configuration Register
  volatile uint32_t IPSBusClkConfig_ClkGenStatus;  ///< 0x54 [R]: IPSBusClk ClkGen Status Register
  volatile uint32_t IPSBusClkDiv2Config_ClkGenConfig;  ///< 0x58 [R/W]: IPSBusClkDiv2 ClkGen Configuration Register
  volatile uint32_t IPSBusClkDiv2Config_ClkGenStatus;  ///< 0x5c [R]: IPSBusClkDiv2 ClkGen Status Register
  volatile uint32_t IPSBusClk_ImagingConfig_ClkGenConfig;  ///< 0x60 [R/W]: IPSBusClk_Imaging ClkGen Configuration Register
  volatile uint32_t IPSBusClk_ImagingConfig_ClkGenStatus;  ///< 0x64 [R]: IPSBusClk_Imaging ClkGen Status Register
  volatile uint32_t IPSBusClk_MVDOConfig_ClkGenConfig;  ///< 0x68 [R/W]: IPSBusClk_MVDO ClkGen Configuration Register
  volatile uint32_t IPSBusClk_MVDOConfig_ClkGenStatus;  ///< 0x6c [R]: IPSBusClk_MVDO ClkGen Status Register
  volatile uint32_t IPSBusClk_UPCConfig_ClkGenConfig;  ///< 0x70 [R/W]: IPSBusClk_UPC ClkGen Configuration Register
  volatile uint32_t IPSBusClk_UPCConfig_ClkGenStatus;  ///< 0x74 [R]: IPSBusClk_UPC ClkGen Status Register
  volatile uint32_t IPSBusClk_CDMAConfig_ClkGenConfig;  ///< 0x78 [R/W]: IPSBusClk_CDMA ClkGen Configuration Register
  volatile uint32_t IPSBusClk_CDMAConfig_ClkGenStatus;  ///< 0x7c [R]: IPSBusClk_CDMA ClkGen Status Register
  volatile uint32_t IPSBusClk_APBConfig_ClkGenConfig;  ///< 0x80 [R/W]: IPSBusClk_APB ClkGen Configuration Register
  volatile uint32_t IPSBusClk_APBConfig_ClkGenStatus;  ///< 0x84 [R]: IPSBusClk_APB ClkGen Status Register
  volatile uint32_t IPSBusClk_DECConfig_ClkGenConfig;  ///< 0x88 [R/W]: IPSBusClk_DEC ClkGen Configuration Register
  volatile uint32_t IPSBusClk_DECConfig_ClkGenStatus;  ///< 0x8c [R]: IPSBusClk_DEC ClkGen Status Register
  volatile uint32_t IPSBusClk_AgateConfig_ClkGenConfig;  ///< 0x90 [R/W]: IPSBusClk_Agate ClkGen Configuration Register
  volatile uint32_t IPSBusClk_AgateConfig_ClkGenStatus;  ///< 0x94 [R]: IPSBusClk_Agate ClkGen Status Register
  volatile uint32_t IPSBusClk_DebugConfig_ClkGenConfig;  ///< 0x98 [R/W]: IPSBusClk_Debug ClkGen Configuration Register
  volatile uint32_t IPSBusClk_DebugConfig_ClkGenStatus;  ///< 0x9c [R]: IPSBusClk_Debug ClkGen Status Register
  volatile uint32_t ScifClk_FWReset;  ///< 0xa0 [R/W]: Scif Clock firwmare reset control
} IPMU_CLKRSTGEN_REGS_t;

#endif // IPMU_TOP
 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _IPMU_TOP_REGMASKS_H_
#define _IPMU_TOP_REGMASKS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: Registers for IPS PMU (IPMU_top)
/** \brief The IPMU provides various registers to control Power Management functions related to the
    Imaging and Printing Subsystem of the SoC.*/
//
//====================================================================

//====================================================================
//
//Register File: IPMU SRAM, Power Island control and miscellaneous registers (IPMU_misc_reg)
/** \brief (rev 0 . 1 . 2 . 6)
    These registers provide control/status for the power islands, SRAMs, and other miscellaneous
    power related functions in the Imaging/Printing section of the chip.*/
//
//====================================================================

//====================================================================
//Register: UPC Power Island Configuration Register (UPCPwrIsland_PICR)
/** \brief <p>The UPC Power Island Configuration Register (PICR) and Power Island Status Register (PISR) contain fields used to control and monitor the UPC Power Island. When power to this island is switched off the blocks in it are inactive and consume zero power. When the power is switched back on, the blocks get a complete hardware reset to return them to their default power-on state. </p>
        To switch off this island:<br/>
        <ul>
        <li>Disable clocks that go to the island using the corresponding ClkConfig registers.</li>
        <li>Clear the ISOB field to isolate the interface to the island.</li>
        <li>Clear both bits of the BULKPWRUP field.</li>
        <li>Wait at least 200 us (no maximum).</li>
        <li>Read the PISR and verify that the BULKSTATUS field is 00.</li>
        </ul>
        <br />
        To switch this island back on:
        <ul>
        <li>Assert resets for all clock domains in the island via the ClkGenConfig
        register(s).</li>
        <li>Set the BULKPWRUP field to 01.</li>
        <li>Wait at least 200 us (no maximum).</li>
        <li>Read the PISR until the BULKSTATUS field is 01.</li>
        <li>Set the BULKPWRUP field to 11.</li>
        <li>Wait at least 200 us (no maximum).</li>
        <li>Read the PISR until the BULKSTATUS field is 11.</li>
        <li>Enable the clock(s) to the island in the ClkGenConfig register(s) for
        all clock domains on the island. This will propogate the asserted reset signal.</li>
        <li>Disable the clock(s) to the island in the ClkGenConfig register(s).</li>
        <li>Deassert the resets for all clock domains in the ClkGenConfig register(s).
        </li>
        <li>Set the ISOB field to 1 to de-isolate the island.</li>
        <li>Enable the clock(s) for the island in the ClkGenConfig register(s).</li>
        </ul>
        Only switch one island at a time to avoid high surge currents which could cause a malfunction.*/
//====================================================================

#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED1_MASK 0xfffffc00
#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED1_SHIFT 10
#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED1_MASK) >> IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED2_MASK 0x200
#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED2_SHIFT 9
#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED2_MASK) >> IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED2_SHIFT)
#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED2_SHIFT))

#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED3_MASK 0x100
#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED3_SHIFT 8
#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED3_MASK) >> IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED3_SHIFT)
#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED3_MASK) | (((uint32_t)val) << IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED3_SHIFT))

#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED4_MASK 0xc0
#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED4_SHIFT 6
#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED4_MASK) >> IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED4_SHIFT)
#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED4_MASK) | (((uint32_t)val) << IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED4_SHIFT))

#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_BULKPWRUP_MASK 0x30
#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_BULKPWRUP_SHIFT 4
#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_BULKPWRUP_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_UPCPWRISLAND_PICR_BULKPWRUP_MASK) >> IPMU_MISC_REG_UPCPWRISLAND_PICR_BULKPWRUP_SHIFT)
#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_BULKPWRUP_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_UPCPWRISLAND_PICR_BULKPWRUP_MASK) | (((uint32_t)val) << IPMU_MISC_REG_UPCPWRISLAND_PICR_BULKPWRUP_SHIFT))

#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED5_MASK 0xe
#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED5_SHIFT 1
#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED5_MASK) >> IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED5_SHIFT)
#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED5_MASK) | (((uint32_t)val) << IPMU_MISC_REG_UPCPWRISLAND_PICR_RESERVED5_SHIFT))

#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_ISOB_MASK 0x1
#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_ISOB_SHIFT 0
#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_ISOB_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_UPCPWRISLAND_PICR_ISOB_MASK) >> IPMU_MISC_REG_UPCPWRISLAND_PICR_ISOB_SHIFT)
#define  IPMU_MISC_REG_UPCPWRISLAND_PICR_ISOB_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_UPCPWRISLAND_PICR_ISOB_MASK) | (((uint32_t)val) << IPMU_MISC_REG_UPCPWRISLAND_PICR_ISOB_SHIFT))

//====================================================================
//Register: UPC Power Island Status Register (UPCPwrIsland_PISR)
/** \brief The Power Island Status Register contains the current state of the power island controls.
      It is identical to the contents of the PICR except when the state is changing.*/
//====================================================================

#define  IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED1_MASK 0xfffffe00
#define  IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED1_SHIFT 9
#define  IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED1_MASK) >> IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED2_MASK 0x100
#define  IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED2_SHIFT 8
#define  IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED2_MASK) >> IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED2_SHIFT)
#define  IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED2_SHIFT))

#define  IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED3_MASK 0xc0
#define  IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED3_SHIFT 6
#define  IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED3_MASK) >> IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED3_SHIFT)
#define  IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED3_MASK) | (((uint32_t)val) << IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED3_SHIFT))

#define  IPMU_MISC_REG_UPCPWRISLAND_PISR_BULKSTATUS_MASK 0x30
#define  IPMU_MISC_REG_UPCPWRISLAND_PISR_BULKSTATUS_SHIFT 4
#define  IPMU_MISC_REG_UPCPWRISLAND_PISR_BULKSTATUS_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_UPCPWRISLAND_PISR_BULKSTATUS_MASK) >> IPMU_MISC_REG_UPCPWRISLAND_PISR_BULKSTATUS_SHIFT)
#define  IPMU_MISC_REG_UPCPWRISLAND_PISR_BULKSTATUS_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_UPCPWRISLAND_PISR_BULKSTATUS_MASK) | (((uint32_t)val) << IPMU_MISC_REG_UPCPWRISLAND_PISR_BULKSTATUS_SHIFT))

#define  IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED4_MASK 0xe
#define  IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED4_SHIFT 1
#define  IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED4_MASK) >> IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED4_SHIFT)
#define  IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED4_MASK) | (((uint32_t)val) << IPMU_MISC_REG_UPCPWRISLAND_PISR_RESERVED4_SHIFT))

#define  IPMU_MISC_REG_UPCPWRISLAND_PISR_ISOB_MASK 0x1
#define  IPMU_MISC_REG_UPCPWRISLAND_PISR_ISOB_SHIFT 0
#define  IPMU_MISC_REG_UPCPWRISLAND_PISR_ISOB_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_UPCPWRISLAND_PISR_ISOB_MASK) >> IPMU_MISC_REG_UPCPWRISLAND_PISR_ISOB_SHIFT)
#define  IPMU_MISC_REG_UPCPWRISLAND_PISR_ISOB_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_UPCPWRISLAND_PISR_ISOB_MASK) | (((uint32_t)val) << IPMU_MISC_REG_UPCPWRISLAND_PISR_ISOB_SHIFT))

//====================================================================
//Register: Imaging Power Island Configuration Register (ImgPwrIsland_PICR)
/** \brief <p>The Imaging Power Island Configuration Register (PICR) and Power Island Status Register (PISR) contain fields used to control and monitor the Imaging Power Island. When power to this island is switched off the blocks in it are inactive and consume zero power. When the power is switched back on, the blocks get a complete hardware reset to return them to their default power-on state. </p>
        To switch off this island:<br/>
        <ul>
        <li>Disable clocks that go to the island using the corresponding ClkConfig registers.</li>
        <li>Clear the ISOB field to isolate the interface to the island.</li>
        <li>Clear both bits of the BULKPWRUP field.</li>
        <li>Wait at least 200 us (no maximum).</li>
        <li>Read the PISR and verify that the BULKSTATUS field is 00.</li>
        </ul>
        <br />
        To switch this island back on:
        <ul>
        <li>Assert resets for all clock domains in the island via the ClkGenConfig
        register(s).</li>
        <li>Set the BULKPWRUP field to 01.</li>
        <li>Wait at least 200 us (no maximum).</li>
        <li>Read the PISR until the BULKSTATUS field is 01.</li>
        <li>Set the BULKPWRUP field to 11.</li>
        <li>Wait at least 200 us (no maximum).</li>
        <li>Read the PISR until the BULKSTATUS field is 11.</li>
        <li>Enable the clock(s) to the island in the ClkGenConfig register(s) for
        all clock domains on the island. This will propogate the asserted reset signal.</li>
        <li>Disable the clock(s) to the island in the ClkGenConfig register(s).</li>
        <li>Deassert the resets for all clock domains in the ClkGenConfig register(s).
        </li>
        <li>Set the ISOB field to 1 to de-isolate the island.</li>
        <li>Enable the clock(s) for the island in the ClkGenConfig register(s).</li>
        </ul>
        Only switch one island at a time to avoid high surge currents which could cause a malfunction.*/
//====================================================================

#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED1_MASK 0xfffffc00
#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED1_SHIFT 10
#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED1_MASK) >> IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED2_MASK 0x200
#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED2_SHIFT 9
#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED2_MASK) >> IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED2_SHIFT)
#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED2_SHIFT))

#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED3_MASK 0x100
#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED3_SHIFT 8
#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED3_MASK) >> IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED3_SHIFT)
#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED3_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED3_SHIFT))

#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED4_MASK 0xc0
#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED4_SHIFT 6
#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED4_MASK) >> IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED4_SHIFT)
#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED4_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED4_SHIFT))

#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_BULKPWRUP_MASK 0x30
#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_BULKPWRUP_SHIFT 4
#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_BULKPWRUP_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IMGPWRISLAND_PICR_BULKPWRUP_MASK) >> IPMU_MISC_REG_IMGPWRISLAND_PICR_BULKPWRUP_SHIFT)
#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_BULKPWRUP_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IMGPWRISLAND_PICR_BULKPWRUP_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IMGPWRISLAND_PICR_BULKPWRUP_SHIFT))

#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED5_MASK 0xe
#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED5_SHIFT 1
#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED5_MASK) >> IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED5_SHIFT)
#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED5_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IMGPWRISLAND_PICR_RESERVED5_SHIFT))

#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_ISOB_MASK 0x1
#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_ISOB_SHIFT 0
#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_ISOB_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IMGPWRISLAND_PICR_ISOB_MASK) >> IPMU_MISC_REG_IMGPWRISLAND_PICR_ISOB_SHIFT)
#define  IPMU_MISC_REG_IMGPWRISLAND_PICR_ISOB_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IMGPWRISLAND_PICR_ISOB_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IMGPWRISLAND_PICR_ISOB_SHIFT))

//====================================================================
//Register: Imaging Power Island Status Register (ImgPwrIsland_PISR)
/** \brief The Power Island Status Register contains the current state of the power island controls.
      It is identical to the contents of the PICR except when the state is changing.*/
//====================================================================

#define  IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED1_MASK 0xfffffe00
#define  IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED1_SHIFT 9
#define  IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED1_MASK) >> IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED2_MASK 0x100
#define  IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED2_SHIFT 8
#define  IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED2_MASK) >> IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED2_SHIFT)
#define  IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED2_SHIFT))

#define  IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED3_MASK 0xc0
#define  IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED3_SHIFT 6
#define  IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED3_MASK) >> IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED3_SHIFT)
#define  IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED3_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED3_SHIFT))

#define  IPMU_MISC_REG_IMGPWRISLAND_PISR_BULKSTATUS_MASK 0x30
#define  IPMU_MISC_REG_IMGPWRISLAND_PISR_BULKSTATUS_SHIFT 4
#define  IPMU_MISC_REG_IMGPWRISLAND_PISR_BULKSTATUS_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IMGPWRISLAND_PISR_BULKSTATUS_MASK) >> IPMU_MISC_REG_IMGPWRISLAND_PISR_BULKSTATUS_SHIFT)
#define  IPMU_MISC_REG_IMGPWRISLAND_PISR_BULKSTATUS_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IMGPWRISLAND_PISR_BULKSTATUS_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IMGPWRISLAND_PISR_BULKSTATUS_SHIFT))

#define  IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED4_MASK 0xe
#define  IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED4_SHIFT 1
#define  IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED4_MASK) >> IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED4_SHIFT)
#define  IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED4_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IMGPWRISLAND_PISR_RESERVED4_SHIFT))

#define  IPMU_MISC_REG_IMGPWRISLAND_PISR_ISOB_MASK 0x1
#define  IPMU_MISC_REG_IMGPWRISLAND_PISR_ISOB_SHIFT 0
#define  IPMU_MISC_REG_IMGPWRISLAND_PISR_ISOB_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IMGPWRISLAND_PISR_ISOB_MASK) >> IPMU_MISC_REG_IMGPWRISLAND_PISR_ISOB_SHIFT)
#define  IPMU_MISC_REG_IMGPWRISLAND_PISR_ISOB_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IMGPWRISLAND_PISR_ISOB_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IMGPWRISLAND_PISR_ISOB_SHIFT))

//====================================================================
//Register: UPC SRAM Powerdown Control Register (UPCSRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals for the UPC
      block's SRAMs.*/
//====================================================================

#define  IPMU_MISC_REG_UPCSRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  IPMU_MISC_REG_UPCSRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  IPMU_MISC_REG_UPCSRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_UPCSRAMPDWN_SPCTL_RESERVED1_MASK) >> IPMU_MISC_REG_UPCSRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_UPCSRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_UPCSRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_UPCSRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_UPCSRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  IPMU_MISC_REG_UPCSRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  IPMU_MISC_REG_UPCSRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_UPCSRAMPDWN_SPCTL_PDLVMC_MASK) >> IPMU_MISC_REG_UPCSRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  IPMU_MISC_REG_UPCSRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_UPCSRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << IPMU_MISC_REG_UPCSRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  IPMU_MISC_REG_UPCSRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  IPMU_MISC_REG_UPCSRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  IPMU_MISC_REG_UPCSRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_UPCSRAMPDWN_SPCTL_PDWN_MASK) >> IPMU_MISC_REG_UPCSRAMPDWN_SPCTL_PDWN_SHIFT)
#define  IPMU_MISC_REG_UPCSRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_UPCSRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << IPMU_MISC_REG_UPCSRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: UPC SRAM Speed Control Register (UPCSRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS
          used in the UPC block
        (least significant fields to most significant fields):
        ITCM, DTCM, Prefetch*/
//====================================================================

#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK 0xfffff000
#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT 12
#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) >> IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RTC2_MASK 0xc00
#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT 10
#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RTC2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RTC2_MASK) >> IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT)
#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RTC2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RTC2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT))

#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_WTC2_MASK 0x300
#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT 8
#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_WTC2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_WTC2_MASK) >> IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT)
#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_WTC2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_WTC2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT))

#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RTC1_MASK 0xc0
#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT 6
#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RTC1_MASK) >> IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT)
#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT))

#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_WTC1_MASK 0x30
#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT 4
#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_WTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_WTC1_MASK) >> IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT)
#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_WTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_WTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT))

#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_UPCSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: PIP SRAM Powerdown Control Register (PIPSRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals for the PIP
      block's SRAMs.*/
//====================================================================

#define  IPMU_MISC_REG_PIPSRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  IPMU_MISC_REG_PIPSRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  IPMU_MISC_REG_PIPSRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMPDWN_SPCTL_RESERVED1_MASK) >> IPMU_MISC_REG_PIPSRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  IPMU_MISC_REG_PIPSRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  IPMU_MISC_REG_PIPSRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMPDWN_SPCTL_PDLVMC_MASK) >> IPMU_MISC_REG_PIPSRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  IPMU_MISC_REG_PIPSRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  IPMU_MISC_REG_PIPSRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMPDWN_SPCTL_PDWN_MASK) >> IPMU_MISC_REG_PIPSRAMPDWN_SPCTL_PDWN_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: PIP SRAM Speed Control Register (PIPSRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS
          used in the PIP block
        (least significant fields to most significant fields):
        SRAM1, SRAM2, SRAM3, SRAM4, SRAM5, AMLUT, SCCSCLUT, SCCSC Cache*/
//====================================================================

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC7_MASK 0xc0000000
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC7_SHIFT 30
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC7_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC7_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC7_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC7_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC7_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC7_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC7_MASK 0x30000000
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC7_SHIFT 28
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC7_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC7_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC7_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC7_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC7_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC7_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC6_MASK 0xc000000
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC6_SHIFT 26
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC6_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC6_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC6_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC6_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC6_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC6_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC6_MASK 0x3000000
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC6_SHIFT 24
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC6_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC6_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC6_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC6_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC6_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC6_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC5_MASK 0xc00000
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC5_SHIFT 22
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC5_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC5_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC5_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC5_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC5_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC5_MASK 0x300000
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC5_SHIFT 20
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC5_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC5_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC5_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC5_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC5_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC4_MASK 0xc0000
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC4_SHIFT 18
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC4_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC4_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC4_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC4_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC4_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC4_MASK 0x30000
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC4_SHIFT 16
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC4_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC4_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC4_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC4_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC4_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC3_MASK 0xc000
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT 14
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC3_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC3_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC3_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC3_MASK 0x3000
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT 12
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC3_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC3_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC3_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC2_MASK 0xc00
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT 10
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC2_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC2_MASK 0x300
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT 8
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC2_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC1_MASK 0xc0
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT 6
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC1_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC1_MASK 0x30
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT 4
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC1_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: PIP SRAM Speed Control Register 1 (PIPSRAMSpeedCtl_SRAMCTL1)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS
          used in the PIP block
        (least significant fields to most significant fields):
        NGAdjust, Pre ScCSC 1_D LUTs, HTH uCell, HTH InLUT, TH AltLUT, UED Signed Bias, HT TD Error Weight, AccessDMA*/
//====================================================================

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC7_MASK 0xc0000000
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC7_SHIFT 30
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC7_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC7_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC7_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC7_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC7_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC7_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC7_MASK 0x30000000
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC7_SHIFT 28
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC7_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC7_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC7_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC7_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC7_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC7_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC6_MASK 0xc000000
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC6_SHIFT 26
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC6_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC6_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC6_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC6_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC6_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC6_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC6_MASK 0x3000000
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC6_SHIFT 24
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC6_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC6_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC6_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC6_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC6_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC6_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC5_MASK 0xc00000
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC5_SHIFT 22
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC5_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC5_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC5_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC5_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC5_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC5_MASK 0x300000
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC5_SHIFT 20
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC5_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC5_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC5_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC5_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC5_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC4_MASK 0xc0000
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC4_SHIFT 18
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC4_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC4_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC4_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC4_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC4_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC4_MASK 0x30000
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC4_SHIFT 16
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC4_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC4_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC4_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC4_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC4_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC3_MASK 0xc000
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC3_SHIFT 14
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC3_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC3_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC3_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC3_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC3_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC3_MASK 0x3000
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC3_SHIFT 12
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC3_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC3_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC3_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC3_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC3_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC2_MASK 0xc00
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC2_SHIFT 10
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC2_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC2_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC2_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC2_MASK 0x300
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC2_SHIFT 8
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC2_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC2_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC2_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC1_MASK 0xc0
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC1_SHIFT 6
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC1_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC1_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC1_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC1_MASK 0x30
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC1_SHIFT 4
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC1_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC1_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC1_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC0_MASK 0xc
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC0_SHIFT 2
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC0_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC0_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_RTC0_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC0_MASK 0x3
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC0_SHIFT 0
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC0_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC0_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL1_WTC0_SHIFT))

//====================================================================
//Register: PIP SRAM Speed Control Register 2 (PIPSRAMSpeedCtl_SRAMCTL2)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS
          used in the PIP block
        (least significant fields to most significant fields):
        LPC Fractional Path, LPC Mix LUT*/
//====================================================================

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_RESERVED1_MASK 0xffffff00
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_RESERVED1_SHIFT 8
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_RESERVED1_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_RTC1_MASK 0xc0
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_RTC1_SHIFT 6
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_RTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_RTC1_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_RTC1_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_RTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_RTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_RTC1_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_WTC1_MASK 0x30
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_WTC1_SHIFT 4
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_WTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_WTC1_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_WTC1_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_WTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_WTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_WTC1_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_RTC0_MASK 0xc
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_RTC0_SHIFT 2
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_RTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_RTC0_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_RTC0_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_RTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_RTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_RTC0_SHIFT))

#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_WTC0_MASK 0x3
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_WTC0_SHIFT 0
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_WTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_WTC0_MASK) >> IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_WTC0_SHIFT)
#define  IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_WTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_WTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_PIPSRAMSPEEDCTL_SRAMCTL2_WTC0_SHIFT))

//====================================================================
//Register: JBIG SRAM Powerdown Control Register (JBIGSRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals for the JBIG
      block's SRAMs.*/
//====================================================================

#define  IPMU_MISC_REG_JBIGSRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  IPMU_MISC_REG_JBIGSRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  IPMU_MISC_REG_JBIGSRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JBIGSRAMPDWN_SPCTL_RESERVED1_MASK) >> IPMU_MISC_REG_JBIGSRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_JBIGSRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JBIGSRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JBIGSRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_JBIGSRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  IPMU_MISC_REG_JBIGSRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  IPMU_MISC_REG_JBIGSRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JBIGSRAMPDWN_SPCTL_PDLVMC_MASK) >> IPMU_MISC_REG_JBIGSRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  IPMU_MISC_REG_JBIGSRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JBIGSRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JBIGSRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  IPMU_MISC_REG_JBIGSRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  IPMU_MISC_REG_JBIGSRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  IPMU_MISC_REG_JBIGSRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JBIGSRAMPDWN_SPCTL_PDWN_MASK) >> IPMU_MISC_REG_JBIGSRAMPDWN_SPCTL_PDWN_SHIFT)
#define  IPMU_MISC_REG_JBIGSRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JBIGSRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JBIGSRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: JBIG SRAM Speed Control Register (JBIGSRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS
          used in the JBIG block
        (least significant fields to most significant fields):
        Context, Codec Line, Fax Codec Line, Decode Line*/
//====================================================================

#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK 0xffff0000
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT 16
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) >> IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC3_MASK 0xc000
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT 14
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC3_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC3_MASK) >> IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT)
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC3_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT))

#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC3_MASK 0x3000
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT 12
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC3_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC3_MASK) >> IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT)
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC3_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT))

#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC2_MASK 0xc00
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT 10
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC2_MASK) >> IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT)
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT))

#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC2_MASK 0x300
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT 8
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC2_MASK) >> IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT)
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT))

#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC1_MASK 0xc0
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT 6
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC1_MASK) >> IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT)
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT))

#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC1_MASK 0x30
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT 4
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC1_MASK) >> IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT)
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT))

#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JBIGSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: JPEG SRAM Powerdown Control Register (JPEGSRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals for the JPEG
      block's SRAMs.*/
//====================================================================

#define  IPMU_MISC_REG_JPEGSRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  IPMU_MISC_REG_JPEGSRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  IPMU_MISC_REG_JPEGSRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JPEGSRAMPDWN_SPCTL_RESERVED1_MASK) >> IPMU_MISC_REG_JPEGSRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_JPEGSRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JPEGSRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JPEGSRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_JPEGSRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  IPMU_MISC_REG_JPEGSRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  IPMU_MISC_REG_JPEGSRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JPEGSRAMPDWN_SPCTL_PDLVMC_MASK) >> IPMU_MISC_REG_JPEGSRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  IPMU_MISC_REG_JPEGSRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JPEGSRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JPEGSRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  IPMU_MISC_REG_JPEGSRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  IPMU_MISC_REG_JPEGSRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  IPMU_MISC_REG_JPEGSRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JPEGSRAMPDWN_SPCTL_PDWN_MASK) >> IPMU_MISC_REG_JPEGSRAMPDWN_SPCTL_PDWN_SHIFT)
#define  IPMU_MISC_REG_JPEGSRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JPEGSRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JPEGSRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: JPEG SRAM Speed Control Register (JPEGSRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS
          used in the JPEG block
        (least significant fields to most significant fields):
        Dequantization, Code, IDCT, MCU2Pix, HuffEncode, Pogo*/
//====================================================================

#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK 0xff000000
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT 24
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) >> IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC5_MASK 0xc00000
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC5_SHIFT 22
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC5_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC5_MASK) >> IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC5_SHIFT)
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC5_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC5_SHIFT))

#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC5_MASK 0x300000
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC5_SHIFT 20
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC5_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC5_MASK) >> IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC5_SHIFT)
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC5_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC5_SHIFT))

#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC4_MASK 0xc0000
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC4_SHIFT 18
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC4_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC4_MASK) >> IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC4_SHIFT)
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC4_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC4_SHIFT))

#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC4_MASK 0x30000
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC4_SHIFT 16
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC4_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC4_MASK) >> IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC4_SHIFT)
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC4_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC4_SHIFT))

#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC3_MASK 0xc000
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT 14
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC3_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC3_MASK) >> IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT)
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC3_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT))

#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC3_MASK 0x3000
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT 12
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC3_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC3_MASK) >> IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT)
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC3_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT))

#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC2_MASK 0xc00
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT 10
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC2_MASK) >> IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT)
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT))

#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC2_MASK 0x300
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT 8
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC2_MASK) >> IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT)
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT))

#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC1_MASK 0xc0
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT 6
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC1_MASK) >> IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT)
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT))

#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC1_MASK 0x30
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT 4
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC1_MASK) >> IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT)
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT))

#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_JPEGSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: ICE SRAM Powerdown Control Register (ICESRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals for the ICE
      block's SRAMs.*/
//====================================================================

#define  IPMU_MISC_REG_ICESRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  IPMU_MISC_REG_ICESRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  IPMU_MISC_REG_ICESRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMPDWN_SPCTL_RESERVED1_MASK) >> IPMU_MISC_REG_ICESRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_ICESRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_ICESRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  IPMU_MISC_REG_ICESRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  IPMU_MISC_REG_ICESRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMPDWN_SPCTL_PDLVMC_MASK) >> IPMU_MISC_REG_ICESRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  IPMU_MISC_REG_ICESRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  IPMU_MISC_REG_ICESRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  IPMU_MISC_REG_ICESRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  IPMU_MISC_REG_ICESRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMPDWN_SPCTL_PDWN_MASK) >> IPMU_MISC_REG_ICESRAMPDWN_SPCTL_PDWN_SHIFT)
#define  IPMU_MISC_REG_ICESRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: ICE SRAM Speed Control Register (ICESRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS
          used in the ICE block
        (least significant fields to most significant fields):
        Bit Depth Reduction, Skew Detect, Antiflare Linear, PIE RDMA, Distort Data, RGB2esRGB CSC, ScCSC, NGAdjust*/
//====================================================================

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC7_MASK 0xc0000000
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC7_SHIFT 30
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC7_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC7_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC7_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC7_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC7_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC7_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC7_MASK 0x30000000
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC7_SHIFT 28
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC7_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC7_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC7_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC7_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC7_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC7_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC6_MASK 0xc000000
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC6_SHIFT 26
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC6_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC6_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC6_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC6_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC6_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC6_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC6_MASK 0x3000000
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC6_SHIFT 24
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC6_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC6_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC6_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC6_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC6_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC6_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC5_MASK 0xc00000
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC5_SHIFT 22
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC5_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC5_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC5_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC5_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC5_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC5_MASK 0x300000
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC5_SHIFT 20
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC5_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC5_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC5_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC5_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC5_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC4_MASK 0xc0000
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC4_SHIFT 18
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC4_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC4_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC4_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC4_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC4_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC4_MASK 0x30000
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC4_SHIFT 16
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC4_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC4_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC4_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC4_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC4_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC3_MASK 0xc000
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT 14
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC3_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC3_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC3_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC3_MASK 0x3000
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT 12
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC3_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC3_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC3_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC2_MASK 0xc00
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT 10
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC2_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC2_MASK 0x300
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT 8
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC2_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC1_MASK 0xc0
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT 6
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC1_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC1_MASK 0x30
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT 4
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC1_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: ICE SRAM Speed Control Register 1 (ICESRAMSpeedCtl_SRAMCTL1)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS
          used in the ICE block
        (least significant fields to most significant fields):
        ToneContrast, PIE WDMA, PIE Obj WDMA, PIE WDMA*/
//====================================================================

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RESERVED1_MASK 0xffff0000
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RESERVED1_SHIFT 16
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RESERVED1_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC3_MASK 0xc000
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC3_SHIFT 14
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC3_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC3_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC3_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC3_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC3_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC3_MASK 0x3000
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC3_SHIFT 12
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC3_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC3_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC3_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC3_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC3_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC2_MASK 0xc00
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC2_SHIFT 10
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC2_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC2_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC2_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC2_MASK 0x300
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC2_SHIFT 8
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC2_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC2_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC2_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC1_MASK 0xc0
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC1_SHIFT 6
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC1_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC1_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC1_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC1_MASK 0x30
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC1_SHIFT 4
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC1_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC1_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC1_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC0_MASK 0xc
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC0_SHIFT 2
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC0_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC0_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_RTC0_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC0_MASK 0x3
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC0_SHIFT 0
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC0_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC0_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_SRAMCTL1_WTC0_SHIFT))

//====================================================================
//Register: ICE RF2P SRAMSpeed Control Register (ICESRAMSpeedCtl_RF2PSRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS
          used in the ICE block
        (least significant fields to most significant fields):
        Distort Map, Bit Depth Enhance, CStats*/
//====================================================================

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK 0xfffff000
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT 12
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RTC2_MASK 0xc00
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RTC2_SHIFT 10
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RTC2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RTC2_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RTC2_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RTC2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RTC2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RTC2_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_WTC2_MASK 0x300
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_WTC2_SHIFT 8
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_WTC2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_WTC2_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_WTC2_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_WTC2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_WTC2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_WTC2_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK 0xc0
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RTC1_SHIFT 6
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RTC1_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RTC1_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK 0x30
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_WTC1_SHIFT 4
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_WTC1_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_WTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_WTC1_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK 0xc
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT 2
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT))

#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK 0x3
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT 0
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) >> IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT)
#define  IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ICESRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: AN SRAM Powerdown Control Register (ANSRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals for the AN
      block's SRAMs.*/
//====================================================================

#define  IPMU_MISC_REG_ANSRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  IPMU_MISC_REG_ANSRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  IPMU_MISC_REG_ANSRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMPDWN_SPCTL_RESERVED1_MASK) >> IPMU_MISC_REG_ANSRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_ANSRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_ANSRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  IPMU_MISC_REG_ANSRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  IPMU_MISC_REG_ANSRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMPDWN_SPCTL_PDLVMC_MASK) >> IPMU_MISC_REG_ANSRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  IPMU_MISC_REG_ANSRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  IPMU_MISC_REG_ANSRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  IPMU_MISC_REG_ANSRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  IPMU_MISC_REG_ANSRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMPDWN_SPCTL_PDWN_MASK) >> IPMU_MISC_REG_ANSRAMPDWN_SPCTL_PDWN_SHIFT)
#define  IPMU_MISC_REG_ANSRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: AN SRAM Speed Control Register (ANSRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS
          used in the AN block
        (least significant fields to most significant fields):
        FFT2D 2DBuff, DLS Mag, Demod Buffer, Demod Decode, Decode Boost Queue*/
//====================================================================

#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK 0xfff00000
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT 20
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) >> IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC4_MASK 0xc0000
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC4_SHIFT 18
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC4_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC4_MASK) >> IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC4_SHIFT)
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC4_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC4_SHIFT))

#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC4_MASK 0x30000
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC4_SHIFT 16
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC4_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC4_MASK) >> IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC4_SHIFT)
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC4_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC4_SHIFT))

#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC3_MASK 0xc000
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT 14
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC3_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC3_MASK) >> IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT)
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC3_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT))

#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC3_MASK 0x3000
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT 12
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC3_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC3_MASK) >> IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT)
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC3_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT))

#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC2_MASK 0xc00
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT 10
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC2_MASK) >> IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT)
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT))

#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC2_MASK 0x300
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT 8
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC2_MASK) >> IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT)
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT))

#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC1_MASK 0xc0
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT 6
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC1_MASK) >> IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT)
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT))

#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC1_MASK 0x30
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT 4
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC1_MASK) >> IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT)
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT))

#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: AN RF2P SRAMSpeed Control Register (ANSRAMSpeedCtl_RF2PSRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS
          used in the AN block
        (least significant fields to most significant fields):
        OctAxis RAM x16, FFT2D 1DBuff, Filter FMag x16, PD2D FH2x1, Demod Last Status Buffer, IOC Dual FIFO*/
//====================================================================

#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK 0xff000000
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT 24
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) >> IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC5_MASK 0xc00000
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC5_SHIFT 22
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC5_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC5_MASK) >> IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC5_SHIFT)
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC5_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC5_SHIFT))

#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC5_MASK 0x300000
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC5_SHIFT 20
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC5_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC5_MASK) >> IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC5_SHIFT)
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC5_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC5_SHIFT))

#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC4_MASK 0xc0000
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC4_SHIFT 18
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC4_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC4_MASK) >> IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC4_SHIFT)
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC4_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC4_SHIFT))

#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC4_MASK 0x30000
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC4_SHIFT 16
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC4_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC4_MASK) >> IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC4_SHIFT)
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC4_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC4_SHIFT))

#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC3_MASK 0xc000
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC3_SHIFT 14
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC3_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC3_MASK) >> IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC3_SHIFT)
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC3_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC3_SHIFT))

#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC3_MASK 0x3000
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC3_SHIFT 12
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC3_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC3_MASK) >> IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC3_SHIFT)
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC3_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC3_SHIFT))

#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC2_MASK 0xc00
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC2_SHIFT 10
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC2_MASK) >> IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC2_SHIFT)
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC2_SHIFT))

#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC2_MASK 0x300
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC2_SHIFT 8
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC2_MASK) >> IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC2_SHIFT)
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC2_SHIFT))

#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK 0xc0
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC1_SHIFT 6
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK) >> IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC1_SHIFT)
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC1_SHIFT))

#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK 0x30
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC1_SHIFT 4
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK) >> IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC1_SHIFT)
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC1_SHIFT))

#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK 0xc
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT 2
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) >> IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT)
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT))

#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK 0x3
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT 0
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) >> IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT)
#define  IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ANSRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: Rotate SRAM Powerdown Control Register (ROTSRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals for the Rotate
      block's SRAMs.*/
//====================================================================

#define  IPMU_MISC_REG_ROTSRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  IPMU_MISC_REG_ROTSRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  IPMU_MISC_REG_ROTSRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ROTSRAMPDWN_SPCTL_RESERVED1_MASK) >> IPMU_MISC_REG_ROTSRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_ROTSRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ROTSRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ROTSRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_ROTSRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  IPMU_MISC_REG_ROTSRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  IPMU_MISC_REG_ROTSRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ROTSRAMPDWN_SPCTL_PDLVMC_MASK) >> IPMU_MISC_REG_ROTSRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  IPMU_MISC_REG_ROTSRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ROTSRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ROTSRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  IPMU_MISC_REG_ROTSRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  IPMU_MISC_REG_ROTSRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  IPMU_MISC_REG_ROTSRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ROTSRAMPDWN_SPCTL_PDWN_MASK) >> IPMU_MISC_REG_ROTSRAMPDWN_SPCTL_PDWN_SHIFT)
#define  IPMU_MISC_REG_ROTSRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ROTSRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ROTSRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: Rotate SRAM Speed Control Register (ROTSRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS
          used in the Rotate block
        (least significant fields to most significant fields):
        Rotate, Rotate Out Pipe*/
//====================================================================

#define  IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK 0xffffff00
#define  IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT 8
#define  IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) >> IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_RTC1_MASK 0xc0
#define  IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT 6
#define  IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_RTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_RTC1_MASK) >> IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT)
#define  IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_RTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_RTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT))

#define  IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_WTC1_MASK 0x30
#define  IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT 4
#define  IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_WTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_WTC1_MASK) >> IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT)
#define  IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_WTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_WTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT))

#define  IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_ROTSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: LCM SRAM Powerdown Control Register (LCMSRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals for the LCM
      block's SRAMs.*/
//====================================================================

#define  IPMU_MISC_REG_LCMSRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  IPMU_MISC_REG_LCMSRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  IPMU_MISC_REG_LCMSRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_LCMSRAMPDWN_SPCTL_RESERVED1_MASK) >> IPMU_MISC_REG_LCMSRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_LCMSRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_LCMSRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_LCMSRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_LCMSRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  IPMU_MISC_REG_LCMSRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  IPMU_MISC_REG_LCMSRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_LCMSRAMPDWN_SPCTL_PDLVMC_MASK) >> IPMU_MISC_REG_LCMSRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  IPMU_MISC_REG_LCMSRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_LCMSRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << IPMU_MISC_REG_LCMSRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  IPMU_MISC_REG_LCMSRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  IPMU_MISC_REG_LCMSRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  IPMU_MISC_REG_LCMSRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_LCMSRAMPDWN_SPCTL_PDWN_MASK) >> IPMU_MISC_REG_LCMSRAMPDWN_SPCTL_PDWN_SHIFT)
#define  IPMU_MISC_REG_LCMSRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_LCMSRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << IPMU_MISC_REG_LCMSRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: LCM SRAM Speed Control Register (LCMSRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the LCM block's SRAMs.*/
//====================================================================

#define  IPMU_MISC_REG_LCMSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK 0xfffffff0
#define  IPMU_MISC_REG_LCMSRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT 4
#define  IPMU_MISC_REG_LCMSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_LCMSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) >> IPMU_MISC_REG_LCMSRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_LCMSRAMSPEEDCTL_SRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_LCMSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_LCMSRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_LCMSRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  IPMU_MISC_REG_LCMSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  IPMU_MISC_REG_LCMSRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_LCMSRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> IPMU_MISC_REG_LCMSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  IPMU_MISC_REG_LCMSRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_LCMSRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_LCMSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  IPMU_MISC_REG_LCMSRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  IPMU_MISC_REG_LCMSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  IPMU_MISC_REG_LCMSRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_LCMSRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> IPMU_MISC_REG_LCMSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  IPMU_MISC_REG_LCMSRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_LCMSRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_LCMSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: IPS Other SRAM Powerdown Control Register (IPSSRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals for the IPS Other
      block's SRAMs.*/
//====================================================================

#define  IPMU_MISC_REG_IPSSRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  IPMU_MISC_REG_IPSSRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  IPMU_MISC_REG_IPSSRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IPSSRAMPDWN_SPCTL_RESERVED1_MASK) >> IPMU_MISC_REG_IPSSRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_IPSSRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IPSSRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IPSSRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_IPSSRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  IPMU_MISC_REG_IPSSRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  IPMU_MISC_REG_IPSSRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IPSSRAMPDWN_SPCTL_PDLVMC_MASK) >> IPMU_MISC_REG_IPSSRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  IPMU_MISC_REG_IPSSRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IPSSRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IPSSRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  IPMU_MISC_REG_IPSSRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  IPMU_MISC_REG_IPSSRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  IPMU_MISC_REG_IPSSRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IPSSRAMPDWN_SPCTL_PDWN_MASK) >> IPMU_MISC_REG_IPSSRAMPDWN_SPCTL_PDWN_SHIFT)
#define  IPMU_MISC_REG_IPSSRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IPSSRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IPSSRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: IPS Other SRAM Speed Control Register (IPSSRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS
          used in the IPS Other block
        (least significant fields to most significant fields):
        Engine Interface, SCCP-Lite, EI*/
//====================================================================

#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK 0xfffff000
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT 12
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) >> IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RTC2_MASK 0xc00
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT 10
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RTC2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RTC2_MASK) >> IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT)
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RTC2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RTC2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT))

#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_WTC2_MASK 0x300
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT 8
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_WTC2_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_WTC2_MASK) >> IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT)
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_WTC2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_WTC2_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT))

#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RTC1_MASK 0xc0
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT 6
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RTC1_MASK) >> IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT)
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT))

#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_WTC1_MASK 0x30
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT 4
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_WTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_WTC1_MASK) >> IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT)
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_WTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_WTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT))

#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IPSSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: IPS Other RF2P SRAMSpeed Control Register (IPSSRAMSpeedCtl_RF2PSRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS
          used in the IPS Other block
        (least significant fields to most significant fields):
        SSPA, ASL*/
//====================================================================

#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK 0xffffff00
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT 8
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) >> IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK 0xc0
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_RTC1_SHIFT 6
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK) >> IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_RTC1_SHIFT)
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_RTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_RTC1_SHIFT))

#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK 0x30
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_WTC1_SHIFT 4
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK) >> IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_WTC1_SHIFT)
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_WTC1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_WTC1_SHIFT))

#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK 0xc
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT 2
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) >> IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT)
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT))

#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK 0x3
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT 0
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) >> IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT)
#define  IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IPSSRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: IPS SMMU SRAM Powerdown Control Register (IPSSMMUSRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals for the IPS SMMU
      block's SRAMs.*/
//====================================================================

#define  IPMU_MISC_REG_IPSSMMUSRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  IPMU_MISC_REG_IPSSMMUSRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  IPMU_MISC_REG_IPSSMMUSRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IPSSMMUSRAMPDWN_SPCTL_RESERVED1_MASK) >> IPMU_MISC_REG_IPSSMMUSRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_IPSSMMUSRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IPSSMMUSRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IPSSMMUSRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_IPSSMMUSRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  IPMU_MISC_REG_IPSSMMUSRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  IPMU_MISC_REG_IPSSMMUSRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IPSSMMUSRAMPDWN_SPCTL_PDLVMC_MASK) >> IPMU_MISC_REG_IPSSMMUSRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  IPMU_MISC_REG_IPSSMMUSRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IPSSMMUSRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IPSSMMUSRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  IPMU_MISC_REG_IPSSMMUSRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  IPMU_MISC_REG_IPSSMMUSRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  IPMU_MISC_REG_IPSSMMUSRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IPSSMMUSRAMPDWN_SPCTL_PDWN_MASK) >> IPMU_MISC_REG_IPSSMMUSRAMPDWN_SPCTL_PDWN_SHIFT)
#define  IPMU_MISC_REG_IPSSMMUSRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IPSSMMUSRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IPSSMMUSRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: IPS SMMU SRAM Speed Control Register (IPSSMMUSRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the IPS SMMU block's SRAMs.*/
//====================================================================

#define  IPMU_MISC_REG_IPSSMMUSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK 0xfffffff0
#define  IPMU_MISC_REG_IPSSMMUSRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT 4
#define  IPMU_MISC_REG_IPSSMMUSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IPSSMMUSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) >> IPMU_MISC_REG_IPSSMMUSRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_IPSSMMUSRAMSPEEDCTL_SRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IPSSMMUSRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IPSSMMUSRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_IPSSMMUSRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  IPMU_MISC_REG_IPSSMMUSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  IPMU_MISC_REG_IPSSMMUSRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IPSSMMUSRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> IPMU_MISC_REG_IPSSMMUSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  IPMU_MISC_REG_IPSSMMUSRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IPSSMMUSRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IPSSMMUSRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  IPMU_MISC_REG_IPSSMMUSRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  IPMU_MISC_REG_IPSSMMUSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  IPMU_MISC_REG_IPSSMMUSRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_IPSSMMUSRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> IPMU_MISC_REG_IPSSMMUSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  IPMU_MISC_REG_IPSSMMUSRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_IPSSMMUSRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << IPMU_MISC_REG_IPSSMMUSRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: VCF ROM Powerdown/Read Timing Control Register (VCF_ROMCtl_RCTL)
/** \brief The fields of this register drive the low leakage power control signals and the
      read timing controls for the VCF ROM.*/
//====================================================================

#define  IPMU_MISC_REG_VCF_ROMCTL_RCTL_RESERVED1_MASK 0xffffffc0
#define  IPMU_MISC_REG_VCF_ROMCTL_RCTL_RESERVED1_SHIFT 6
#define  IPMU_MISC_REG_VCF_ROMCTL_RCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_VCF_ROMCTL_RCTL_RESERVED1_MASK) >> IPMU_MISC_REG_VCF_ROMCTL_RCTL_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_VCF_ROMCTL_RCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_VCF_ROMCTL_RCTL_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_VCF_ROMCTL_RCTL_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_VCF_ROMCTL_RCTL_RTC_REF_MASK 0x30
#define  IPMU_MISC_REG_VCF_ROMCTL_RCTL_RTC_REF_SHIFT 4
#define  IPMU_MISC_REG_VCF_ROMCTL_RCTL_RTC_REF_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_VCF_ROMCTL_RCTL_RTC_REF_MASK) >> IPMU_MISC_REG_VCF_ROMCTL_RCTL_RTC_REF_SHIFT)
#define  IPMU_MISC_REG_VCF_ROMCTL_RCTL_RTC_REF_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_VCF_ROMCTL_RCTL_RTC_REF_MASK) | (((uint32_t)val) << IPMU_MISC_REG_VCF_ROMCTL_RCTL_RTC_REF_SHIFT))

#define  IPMU_MISC_REG_VCF_ROMCTL_RCTL_RTC_MASK 0xe
#define  IPMU_MISC_REG_VCF_ROMCTL_RCTL_RTC_SHIFT 1
#define  IPMU_MISC_REG_VCF_ROMCTL_RCTL_RTC_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_VCF_ROMCTL_RCTL_RTC_MASK) >> IPMU_MISC_REG_VCF_ROMCTL_RCTL_RTC_SHIFT)
#define  IPMU_MISC_REG_VCF_ROMCTL_RCTL_RTC_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_VCF_ROMCTL_RCTL_RTC_MASK) | (((uint32_t)val) << IPMU_MISC_REG_VCF_ROMCTL_RCTL_RTC_SHIFT))

#define  IPMU_MISC_REG_VCF_ROMCTL_RCTL_PDWN_MASK 0x1
#define  IPMU_MISC_REG_VCF_ROMCTL_RCTL_PDWN_SHIFT 0
#define  IPMU_MISC_REG_VCF_ROMCTL_RCTL_PDWN_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_VCF_ROMCTL_RCTL_PDWN_MASK) >> IPMU_MISC_REG_VCF_ROMCTL_RCTL_PDWN_SHIFT)
#define  IPMU_MISC_REG_VCF_ROMCTL_RCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_VCF_ROMCTL_RCTL_PDWN_MASK) | (((uint32_t)val) << IPMU_MISC_REG_VCF_ROMCTL_RCTL_PDWN_SHIFT))

//====================================================================
//Register: Redundancy Repair Done Status Register (RepairDone)
/** \brief After reset, SRAMs with redundancy must go through a repair process. This register contains
      status bits for each SRAM with redundancy in the IPS. Firmware should ensure that the
      corresponding RepairDone status bit is set before doing anything that would access those
      SRAMs.*/
//====================================================================

#define  IPMU_MISC_REG_REPAIRDONE_RESERVED1_MASK 0xfffffff8
#define  IPMU_MISC_REG_REPAIRDONE_RESERVED1_SHIFT 3
#define  IPMU_MISC_REG_REPAIRDONE_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_REPAIRDONE_RESERVED1_MASK) >> IPMU_MISC_REG_REPAIRDONE_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_REPAIRDONE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_REPAIRDONE_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_REPAIRDONE_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_REPAIRDONE_LCM_SRBIST_REPAIRDONE_MASK 0x4
#define  IPMU_MISC_REG_REPAIRDONE_LCM_SRBIST_REPAIRDONE_SHIFT 2
#define  IPMU_MISC_REG_REPAIRDONE_LCM_SRBIST_REPAIRDONE_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_REPAIRDONE_LCM_SRBIST_REPAIRDONE_MASK) >> IPMU_MISC_REG_REPAIRDONE_LCM_SRBIST_REPAIRDONE_SHIFT)
#define  IPMU_MISC_REG_REPAIRDONE_LCM_SRBIST_REPAIRDONE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_REPAIRDONE_LCM_SRBIST_REPAIRDONE_MASK) | (((uint32_t)val) << IPMU_MISC_REG_REPAIRDONE_LCM_SRBIST_REPAIRDONE_SHIFT))

#define  IPMU_MISC_REG_REPAIRDONE_IMG_ISLAND_SRBIST_REPAIRDONE_MASK 0x2
#define  IPMU_MISC_REG_REPAIRDONE_IMG_ISLAND_SRBIST_REPAIRDONE_SHIFT 1
#define  IPMU_MISC_REG_REPAIRDONE_IMG_ISLAND_SRBIST_REPAIRDONE_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_REPAIRDONE_IMG_ISLAND_SRBIST_REPAIRDONE_MASK) >> IPMU_MISC_REG_REPAIRDONE_IMG_ISLAND_SRBIST_REPAIRDONE_SHIFT)
#define  IPMU_MISC_REG_REPAIRDONE_IMG_ISLAND_SRBIST_REPAIRDONE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_REPAIRDONE_IMG_ISLAND_SRBIST_REPAIRDONE_MASK) | (((uint32_t)val) << IPMU_MISC_REG_REPAIRDONE_IMG_ISLAND_SRBIST_REPAIRDONE_SHIFT))

#define  IPMU_MISC_REG_REPAIRDONE_UPC_SRBIST_REPAIRDONE_MASK 0x1
#define  IPMU_MISC_REG_REPAIRDONE_UPC_SRBIST_REPAIRDONE_SHIFT 0
#define  IPMU_MISC_REG_REPAIRDONE_UPC_SRBIST_REPAIRDONE_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_REPAIRDONE_UPC_SRBIST_REPAIRDONE_MASK) >> IPMU_MISC_REG_REPAIRDONE_UPC_SRBIST_REPAIRDONE_SHIFT)
#define  IPMU_MISC_REG_REPAIRDONE_UPC_SRBIST_REPAIRDONE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_REPAIRDONE_UPC_SRBIST_REPAIRDONE_MASK) | (((uint32_t)val) << IPMU_MISC_REG_REPAIRDONE_UPC_SRBIST_REPAIRDONE_SHIFT))

//====================================================================
//Register: Clock Domain Interrupt Enable Register (IntEnReg)
/** \brief This register allows firmware to enable or mask off the clock domain interrupts generated
      by the clkgate modules in the IPMU.
      Bit order (high to low): IPSBusClkDiv2, IPSBusClk_debug, IPSBusClk_Agate, IPSBusClk_DEC,
      IPSBusClk_APB, IPSBusClk_CDMA, IPSBusClk_UPC, IPSBusClk_MVDO, IPSBusClk_Imaging,
      XIOClk, XCPUClk, ScanClk, LVDSAFERefClk, NSSClk_imaging, NSSClk,
      FastNSSClk, ADCTSENClk, AudioClk.*/
//====================================================================

#define  IPMU_MISC_REG_INTENREG_RESERVED1_MASK 0xfffc0000
#define  IPMU_MISC_REG_INTENREG_RESERVED1_SHIFT 18
#define  IPMU_MISC_REG_INTENREG_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_INTENREG_RESERVED1_MASK) >> IPMU_MISC_REG_INTENREG_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_INTENREG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_INTENREG_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_INTENREG_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_INTENREG_INTENABLE_MASK 0x3ffff
#define  IPMU_MISC_REG_INTENREG_INTENABLE_SHIFT 0
#define  IPMU_MISC_REG_INTENREG_INTENABLE_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_INTENREG_INTENABLE_MASK) >> IPMU_MISC_REG_INTENREG_INTENABLE_SHIFT)
#define  IPMU_MISC_REG_INTENREG_INTENABLE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_INTENREG_INTENABLE_MASK) | (((uint32_t)val) << IPMU_MISC_REG_INTENREG_INTENABLE_SHIFT))

//====================================================================
//Register: Clock Domain Interrupt Pending Register (IntPendReg)
/** \brief This register indicates the pending status of the various clock domain interrupts.
      See IntEnReg description for bit mapping.*/
//====================================================================

#define  IPMU_MISC_REG_INTPENDREG_RESERVED1_MASK 0xfffc0000
#define  IPMU_MISC_REG_INTPENDREG_RESERVED1_SHIFT 18
#define  IPMU_MISC_REG_INTPENDREG_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_INTPENDREG_RESERVED1_MASK) >> IPMU_MISC_REG_INTPENDREG_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_INTPENDREG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_INTPENDREG_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_INTPENDREG_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_INTPENDREG_INTPEND_MASK 0x3ffff
#define  IPMU_MISC_REG_INTPENDREG_INTPEND_SHIFT 0
#define  IPMU_MISC_REG_INTPENDREG_INTPEND_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_INTPENDREG_INTPEND_MASK) >> IPMU_MISC_REG_INTPENDREG_INTPEND_SHIFT)
#define  IPMU_MISC_REG_INTPENDREG_INTPEND_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_INTPENDREG_INTPEND_MASK) | (((uint32_t)val) << IPMU_MISC_REG_INTPENDREG_INTPEND_SHIFT))

//====================================================================
//Register: Clock Domain Interrupt Acknowledge Register (IntAckReg)
/** \brief Writing a '1' to a bit in this register acknowledges (clears) the corresponding interrupt.
      See IntEnReg description for bit mapping.*/
//====================================================================

#define  IPMU_MISC_REG_INTACKREG_RESERVED1_MASK 0xfffc0000
#define  IPMU_MISC_REG_INTACKREG_RESERVED1_SHIFT 18
#define  IPMU_MISC_REG_INTACKREG_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_INTACKREG_RESERVED1_MASK) >> IPMU_MISC_REG_INTACKREG_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_INTACKREG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_INTACKREG_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_INTACKREG_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_INTACKREG_INTACK_MASK 0x3ffff
#define  IPMU_MISC_REG_INTACKREG_INTACK_SHIFT 0
#define  IPMU_MISC_REG_INTACKREG_INTACK_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_INTACKREG_INTACK_MASK) >> IPMU_MISC_REG_INTACKREG_INTACK_SHIFT)
#define  IPMU_MISC_REG_INTACKREG_INTACK_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_INTACKREG_INTACK_MASK) | (((uint32_t)val) << IPMU_MISC_REG_INTACKREG_INTACK_SHIFT))

//====================================================================
//Register: Clock Domain Interrupt Force Register (IntForceReg)
/** \brief This register allows firmware to generate an interrupt for a particular clock domain.
      See IntEnReg description for bit mapping.*/
//====================================================================

#define  IPMU_MISC_REG_INTFORCEREG_RESERVED1_MASK 0xfffc0000
#define  IPMU_MISC_REG_INTFORCEREG_RESERVED1_SHIFT 18
#define  IPMU_MISC_REG_INTFORCEREG_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_INTFORCEREG_RESERVED1_MASK) >> IPMU_MISC_REG_INTFORCEREG_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_INTFORCEREG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_INTFORCEREG_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_INTFORCEREG_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_INTFORCEREG_INTFORCE_MASK 0x3ffff
#define  IPMU_MISC_REG_INTFORCEREG_INTFORCE_SHIFT 0
#define  IPMU_MISC_REG_INTFORCEREG_INTFORCE_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_INTFORCEREG_INTFORCE_MASK) >> IPMU_MISC_REG_INTFORCEREG_INTFORCE_SHIFT)
#define  IPMU_MISC_REG_INTFORCEREG_INTFORCE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_INTFORCEREG_INTFORCE_MASK) | (((uint32_t)val) << IPMU_MISC_REG_INTFORCEREG_INTFORCE_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  IPMU_MISC_REG_REV0_MAJ_MASK 0xffff0000
#define  IPMU_MISC_REG_REV0_MAJ_SHIFT 16
#define  IPMU_MISC_REG_REV0_MAJ_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_REV0_MAJ_MASK) >> IPMU_MISC_REG_REV0_MAJ_SHIFT)
#define  IPMU_MISC_REG_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_REV0_MAJ_MASK) | (((uint32_t)val) << IPMU_MISC_REG_REV0_MAJ_SHIFT))

#define  IPMU_MISC_REG_REV0_MID_MASK 0xffff
#define  IPMU_MISC_REG_REV0_MID_SHIFT 0
#define  IPMU_MISC_REG_REV0_MID_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_REV0_MID_MASK) >> IPMU_MISC_REG_REV0_MID_SHIFT)
#define  IPMU_MISC_REG_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_REV0_MID_MASK) | (((uint32_t)val) << IPMU_MISC_REG_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  IPMU_MISC_REG_REV1_RESERVED1_MASK 0xffff0000
#define  IPMU_MISC_REG_REV1_RESERVED1_SHIFT 16
#define  IPMU_MISC_REG_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_REV1_RESERVED1_MASK) >> IPMU_MISC_REG_REV1_RESERVED1_SHIFT)
#define  IPMU_MISC_REG_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_REV1_RESERVED1_MASK) | (((uint32_t)val) << IPMU_MISC_REG_REV1_RESERVED1_SHIFT))

#define  IPMU_MISC_REG_REV1_CFG_MASK 0xffff
#define  IPMU_MISC_REG_REV1_CFG_SHIFT 0
#define  IPMU_MISC_REG_REV1_CFG_MASK_SHIFT(reg) (((reg) & IPMU_MISC_REG_REV1_CFG_MASK) >> IPMU_MISC_REG_REV1_CFG_SHIFT)
#define  IPMU_MISC_REG_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~IPMU_MISC_REG_REV1_CFG_MASK) | (((uint32_t)val) << IPMU_MISC_REG_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: IPMU Clock and Reset Control Registers (IPMU_ClkRstGen)
/** \brief These registers provide control/status for the clocks/resets for all of the clock domains
    in the Imaging/Printing section of the chip.*/
//
//====================================================================

//====================================================================
//Register: AudioClk Pre-divider ClkGen Configuration Register (AudioClkPreConfig_ClkGenConfig)
/** \brief AudioClk Pre-divider clock generator Configuration Register.
          The maximum frequency for this clock is 625 MHz. It is important to ensure that the
          configuration settings for this clock result in an output frequency less than this value.*/
//====================================================================

#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED1_MASK 0xf8000000
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED1_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED2_MASK 0x6000000
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED2_SHIFT 25
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED2_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_SRCSEL_MASK 0x1000000
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_SRCSEL_SHIFT 24
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_SRCSEL_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_SRCSEL_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_SRCSEL_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_SRCSEL_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_SRCSEL_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED3_MASK 0xf00000
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED3_SHIFT 20
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED3_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_HIDIV_MASK 0xf0000
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_HIDIV_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED4_MASK 0xf000
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED4_SHIFT 12
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED4_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_LODIV_MASK 0xf00
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_LODIV_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED5_MASK 0xf8
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED5_SHIFT 3
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED5_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_PREDIVEN_MASK 0x4
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_PREDIVEN_SHIFT 2
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_PREDIVEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_PREDIVEN_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_PREDIVEN_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_PREDIVEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_PREDIVEN_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED6_MASK 0x2
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED6_SHIFT 1
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED6_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED6_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED6_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED7_MASK 0x1
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED7_SHIFT 0
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED7_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED7_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED7_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED7_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENCONFIG_RESERVED7_SHIFT))

//====================================================================
//Register: AudioClk Pre-divider ClkGen Status Register (AudioClkPreConfig_ClkGenStatus)
/** \brief AudioClk Pre-divider clock generator Status Register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_PREDIV_MASK 0xf8000000
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_PREDIV_SHIFT 27
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_PREDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_PREDIV_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_PREDIV_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_PREDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_PREDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_PREDIV_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED1_MASK 0x6000000
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED1_SHIFT 25
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED1_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_SRCSEL_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED2_MASK 0xf00000
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED2_SHIFT 20
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED2_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_HIDIV_MASK 0xf0000
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_HIDIV_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED3_MASK 0xf000
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED3_SHIFT 12
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED3_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_LODIV_MASK 0xf00
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_LODIV_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED4_MASK 0xf8
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED4_SHIFT 3
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED4_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_PREDIVEN_MASK 0x4
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_PREDIVEN_SHIFT 2
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_PREDIVEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_PREDIVEN_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_PREDIVEN_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_PREDIVEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_PREDIVEN_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED5_MASK 0x2
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED5_SHIFT 1
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED5_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED6_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKPRECONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: AudioClk ClkGen Configuration Register (AudioClkConfig_ClkGenConfig)
/** \brief AudioClk clock generator Configuration Register.
            The source of this clock generator is the Audio Clock Pre-divider.
          The maximum frequency for this clock is 6.25 MHz. It is important to ensure that the
          configuration settings for this clock result in an output frequency less than this value.*/
//====================================================================

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7000000
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 24
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_HIDIV_MASK 0xff0000
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_LODIV_MASK 0xff00
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_LODIV_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x1
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 0
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

//====================================================================
//Register: AudioClk ClkGen Status Register (AudioClkConfig_ClkGenStatus)
/** \brief AudioClk clock generator Status Register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x7000000
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 24
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0xff0000
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_LODIV_MASK 0xff00
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0x4
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 2
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK 0x1
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 0
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_AUDIOCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

//====================================================================
//Register: AdcTsenClk ClkGen Configuration Register (AdcTsenClkConfig_ClkGenConfig)
/** \brief AdcTsenClk clock generator Configuration Register.
            The source of this clock generator is the System PLL Clock.
          The maximum frequency for this clock is 125 MHz. It is important to ensure that the
          configuration settings for this clock result in an output frequency less than this value.*/
//====================================================================

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7000000
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 24
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0xe00000
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 21
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_HIDIV_MASK 0x1f0000
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0xe000
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 13
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_LODIV_MASK 0x1f00
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_LODIV_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x80
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 7
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK 0x4
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT 2
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK 0x1
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT 0
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT))

//====================================================================
//Register: AdcTsenClk ClkGen Status Register (AdcTsenClkConfig_ClkGenStatus)
/** \brief AdcTsenClk clock generator Status Register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x7000000
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 24
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_ADCTSENCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: FastNssClk ClkGen Configuration Register (FastNSSClkConfig_ClkGenConfig)
/** \brief FastNssClk clock generator Configuration Register.
            The source of this clock generator is the System PLL Clock.
          The maximum frequency for this clock is 833.33 MHz. It is important to ensure that the
          configuration settings for this clock result in an output frequency less than this value.*/
//====================================================================

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7000000
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 24
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0xf80000
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 19
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_HIDIV_MASK 0x70000
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0xf800
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 11
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_LODIV_MASK 0x700
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_LODIV_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x80
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 7
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK 0x4
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT 2
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK 0x1
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT 0
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT))

//====================================================================
//Register: FastNssClk ClkGen Status Register (FastNSSClkConfig_ClkGenStatus)
/** \brief FastNssClk clock generator Status Register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x7000000
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 24
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xf80000
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 19
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0x70000
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xf800
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 11
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_LODIV_MASK 0x700
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_FASTNSSCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: NSSClk ClkGen Configuration Register (NSSClkConfig_ClkGenConfig)
/** \brief NSSClk clock generator Configuration Register.
            The source of this clock generator is the System PLL Clock.
          The maximum frequency for this clock is 250 MHz. It is important to ensure that the
          configuration settings for this clock result in an output frequency less than this value.*/
//====================================================================

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7000000
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 24
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0xf00000
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 20
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_HIDIV_MASK 0xf0000
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0xf000
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 12
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_LODIV_MASK 0xf00
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_LODIV_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x80
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 7
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK 0x4
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT 2
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK 0x1
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT 0
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT))

//====================================================================
//Register: NSSClk ClkGen Status Register (NSSClkConfig_ClkGenStatus)
/** \brief NSSClk clock generator Status Register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x7000000
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 24
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xf00000
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 20
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0xf0000
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xf000
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 12
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_LODIV_MASK 0xf00
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: NSSClk_imaging ClkGen Configuration Register (NSSClk_imagingConfig_ClkGenConfig)
/** \brief NSSClk_imaging clock generator Configuration Register.
            This clock domain shares its frequency configuration, and is aligned, with the
            NSSClk clock domain. Changes to this clock's frequency can be accomplished by
            writes to the NSSClk ClkGenConfig register. The values in this clock domain's
            ClkGenStatus register will reflect the values in the NSSClk ClkGenConfig register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKEN_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RSTN_MASK 0x1
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RSTN_SHIFT 0
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RSTN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RSTN_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RSTN_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RSTN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RSTN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENCONFIG_RSTN_SHIFT))

//====================================================================
//Register: NSSClk_imaging ClkGen Status Register (NSSClk_imagingConfig_ClkGenStatus)
/** \brief NSSClk_imaging clock generator Status Register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x7000000
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 24
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xf00000
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 20
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_HIDIV_MASK 0xf0000
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_HIDIV_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xf000
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 12
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_LODIV_MASK 0xf00
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_LODIV_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKEN_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RSTN_MASK 0x1
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RSTN_SHIFT 0
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RSTN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RSTN_MASK) >> IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RSTN_SHIFT)
#define  IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RSTN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RSTN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_NSSCLK_IMAGINGCONFIG_CLKGENSTATUS_RSTN_SHIFT))

//====================================================================
//Register: LVDSAFERefClk ClkGen Configuration Register (LVDSAFERefClkConfig_ClkGenConfig)
/** \brief LVDSAFERefClk clock generator Configuration Register.
            The source of this clock generator is the Scan PLL Clock.
          The maximum frequency for this clock is 750 MHz. It is important to ensure that the
          configuration settings for this clock result in an output frequency less than this value.*/
//====================================================================

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7000000
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 24
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0xfe0000
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 17
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_HIDIV_MASK 0x10000
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0xfe00
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 9
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_LODIV_MASK 0x100
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_LODIV_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x80
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 7
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK 0x4
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT 2
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RSTN_MASK 0x1
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RSTN_SHIFT 0
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RSTN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RSTN_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RSTN_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RSTN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RSTN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENCONFIG_RSTN_SHIFT))

//====================================================================
//Register: LVDSAFERefClk ClkGen Status Register (LVDSAFERefClkConfig_ClkGenStatus)
/** \brief LVDSAFERefClk clock generator Status Register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x7000000
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 24
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xfe0000
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 17
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0x10000
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xfe00
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 9
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_LODIV_MASK 0x100
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RSTN_MASK 0x1
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RSTN_SHIFT 0
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RSTN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RSTN_MASK) >> IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RSTN_SHIFT)
#define  IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RSTN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RSTN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_LVDSAFEREFCLKCONFIG_CLKGENSTATUS_RSTN_SHIFT))

//====================================================================
//Register: ScanClk ClkGen Configuration Register (ScanClkConfig_ClkGenConfig)
/** \brief ScanClk clock generator Configuration Register.
          The maximum frequency for this clock is 250 MHz. It is important to ensure that the
          configuration settings for this clock result in an output frequency less than this value.*/
//====================================================================

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x4000000
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 26
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK 0x3000000
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT 24
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0xf00000
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 20
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_HIDIV_MASK 0xf0000
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0xf000
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 12
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_LODIV_MASK 0xf00
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_LODIV_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x80
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 7
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK 0x4
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT 2
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RSTN_MASK 0x1
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RSTN_SHIFT 0
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RSTN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RSTN_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RSTN_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RSTN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RSTN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENCONFIG_RSTN_SHIFT))

//====================================================================
//Register: ScanClk ClkGen Status Register (ScanClkConfig_ClkGenStatus)
/** \brief ScanClk clock generator Status Register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_PREDIV_MASK 0xf8000000
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT 27
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_PREDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_PREDIV_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_PREDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_PREDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0x4000000
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 26
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x3000000
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0xf00000
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 20
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0xf0000
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xf000
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 12
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_LODIV_MASK 0xf00
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK 0x4
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT 2
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RSTN_MASK 0x1
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RSTN_SHIFT 0
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RSTN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RSTN_MASK) >> IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RSTN_SHIFT)
#define  IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RSTN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RSTN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCANCLKCONFIG_CLKGENSTATUS_RSTN_SHIFT))

//====================================================================
//Register: XCPUClk ClkGen Configuration Register (XCPUClkConfig_ClkGenConfig)
/** \brief XCPUClk clock generator Configuration Register.
          The maximum frequency for this clock is 533.33 MHz. It is important to ensure that the
          configuration settings for this clock result in an output frequency less than this value.*/
//====================================================================

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x6000000
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 25
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK 0x1000000
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT 24
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0xe00000
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 21
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_HIDIV_MASK 0x1f0000
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0xe000
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 13
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_LODIV_MASK 0x1f00
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_LODIV_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x80
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 7
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK 0x4
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT 2
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RSTN_MASK 0x1
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RSTN_SHIFT 0
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RSTN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RSTN_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RSTN_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RSTN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RSTN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENCONFIG_RSTN_SHIFT))

//====================================================================
//Register: XCPUClk ClkGen Status Register (XCPUClkConfig_ClkGenStatus)
/** \brief XCPUClk clock generator Status Register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RSTN_MASK 0x1
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RSTN_SHIFT 0
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RSTN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RSTN_MASK) >> IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RSTN_SHIFT)
#define  IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RSTN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RSTN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XCPUCLKCONFIG_CLKGENSTATUS_RSTN_SHIFT))

//====================================================================
//Register: XIOClk ClkGen Configuration Register (XIOClkConfig_ClkGenConfig)
/** \brief XIOClk clock generator Configuration Register.
          The maximum frequency for this clock is 400 MHz. It is important to ensure that the
          configuration settings for this clock result in an output frequency less than this value.*/
//====================================================================

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x6000000
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 25
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK 0x1000000
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT 24
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0xe00000
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 21
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_HIDIV_MASK 0x1f0000
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0xe000
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 13
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_LODIV_MASK 0x1f00
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_LODIV_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x80
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 7
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK 0x4
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT 2
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RSTN_MASK 0x1
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RSTN_SHIFT 0
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RSTN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RSTN_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RSTN_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RSTN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RSTN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENCONFIG_RSTN_SHIFT))

//====================================================================
//Register: XIOClk ClkGen Status Register (XIOClkConfig_ClkGenStatus)
/** \brief XIOClk clock generator Status Register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RSTN_MASK 0x1
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RSTN_SHIFT 0
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RSTN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RSTN_MASK) >> IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RSTN_SHIFT)
#define  IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RSTN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RSTN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_XIOCLKCONFIG_CLKGENSTATUS_RSTN_SHIFT))

//====================================================================
//Register: IPSBusClk ClkGen Configuration Register (IPSBusClkConfig_ClkGenConfig)
/** \brief IPSBusClk clock generator Configuration Register.
          The maximum frequency for this clock is 200 MHz. It is important to ensure that the
          configuration settings for this clock result in an output frequency less than this value.*/
//====================================================================

#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0xf8000000
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x6000000
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 25
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK 0x1000000
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT 24
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0xe00000
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 21
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_HIDIV_MASK 0x1f0000
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0xe000
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 13
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_LODIV_MASK 0x1f00
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_LODIV_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0xf8
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 3
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK 0x4
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT 2
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK 0x2
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT 1
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED8_MASK 0x1
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED8_SHIFT 0
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED8_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED8_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED8_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED8_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED8_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENCONFIG_RESERVED8_SHIFT))

//====================================================================
//Register: IPSBusClk ClkGen Status Register (IPSBusClkConfig_ClkGenStatus)
/** \brief IPSBusClk clock generator Status Register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK 0xf8
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 3
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x4
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 2
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED7_MASK 0x2
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED7_SHIFT 1
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED7_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED7_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED7_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED7_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED7_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED8_MASK 0x1
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED8_SHIFT 0
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED8_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED8_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED8_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED8_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED8_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKCONFIG_CLKGENSTATUS_RESERVED8_SHIFT))

//====================================================================
//Register: IPSBusClkDiv2 ClkGen Configuration Register (IPSBusClkDiv2Config_ClkGenConfig)
/** \brief IPSBusClkDiv2 clock generator Configuration Register.
            This clock domain shares its frequency configuration, and is aligned, with the
            IPSBusClk clock domain. This clock will always be a fixed divide by 2 of
            the IPSBusClk. Changes to this clock's frequency can be accomplished by
            writes to the IPSBusClk ClkGenConfig register. The values in this clock domain's
            ClkGenStatus register will reflect the values in the IPSBusClk ClkGenConfig register.
            The PreDiv field is set to 2, and the PreDivEn field is always '1' to indicate
            the fixed divide from the IPSBusClk.*/
//====================================================================

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED1_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED2_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED3_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED4_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED5_MASK 0x1
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED5_SHIFT 0
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED5_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

//====================================================================
//Register: IPSBusClkDiv2 ClkGen Status Register (IPSBusClkDiv2Config_ClkGenStatus)
/** \brief IPSBusClkDiv2 clock generator Status Register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIV_MASK 0xf8000000
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIV_SHIFT 27
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIV_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIV_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIV_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED1_MASK 0x6000000
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED1_SHIFT 25
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED1_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_SRCSEL_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED2_MASK 0xe00000
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED2_SHIFT 21
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED2_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_HIDIV_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe000
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED3_SHIFT 13
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED3_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_LODIV_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKGATED_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIVEN_MASK 0x4
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIVEN_SHIFT 2
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIVEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIVEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIVEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIVEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIVEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED4_MASK 0x1
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED4_SHIFT 0
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED4_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

//====================================================================
//Register: IPSBusClk_Imaging ClkGen Configuration Register (IPSBusClk_ImagingConfig_ClkGenConfig)
/** \brief IPSBusClk_Imaging clock generator Configuration Register.
            This clock domain shares its frequency configuration, and is aligned, with the
            IPSBusClk clock domain. Changes to this clock's frequency can be accomplished by
            writes to the IPSBusClk ClkGenConfig register. The values in this clock domain's
            ClkGenStatus register will reflect the values in the IPSBusClk ClkGenConfig register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RSTN_MASK 0x1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RSTN_SHIFT 0
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RSTN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RSTN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RSTN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RSTN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RSTN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENCONFIG_RSTN_SHIFT))

//====================================================================
//Register: IPSBusClk_Imaging ClkGen Status Register (IPSBusClk_ImagingConfig_ClkGenStatus)
/** \brief IPSBusClk_Imaging clock generator Status Register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_HIDIV_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_LODIV_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RSTN_MASK 0x1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RSTN_SHIFT 0
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RSTN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RSTN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RSTN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RSTN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RSTN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_IMAGINGCONFIG_CLKGENSTATUS_RSTN_SHIFT))

//====================================================================
//Register: IPSBusClk_MVDO ClkGen Configuration Register (IPSBusClk_MVDOConfig_ClkGenConfig)
/** \brief IPSBusClk_MVDO clock generator Configuration Register.
            This clock domain shares its frequency configuration, and is aligned, with the
            IPSBusClk clock domain. Changes to this clock's frequency can be accomplished by
            writes to the IPSBusClk ClkGenConfig register. The values in this clock domain's
            ClkGenStatus register will reflect the values in the IPSBusClk ClkGenConfig register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_CLKEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 0
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

//====================================================================
//Register: IPSBusClk_MVDO ClkGen Status Register (IPSBusClk_MVDOConfig_ClkGenStatus)
/** \brief IPSBusClk_MVDO clock generator Status Register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_HIDIV_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_LODIV_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_MVDOCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: IPSBusClk_UPC ClkGen Configuration Register (IPSBusClk_UPCConfig_ClkGenConfig)
/** \brief IPSBusClk_UPC clock generator Configuration Register.
            This clock domain shares its frequency configuration, and is aligned, with the
            IPSBusClk clock domain. Changes to this clock's frequency can be accomplished by
            writes to the IPSBusClk ClkGenConfig register. The values in this clock domain's
            ClkGenStatus register will reflect the values in the IPSBusClk ClkGenConfig register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_CLKEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RSTN_MASK 0x1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RSTN_SHIFT 0
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RSTN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RSTN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RSTN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RSTN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RSTN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENCONFIG_RSTN_SHIFT))

//====================================================================
//Register: IPSBusClk_UPC ClkGen Status Register (IPSBusClk_UPCConfig_ClkGenStatus)
/** \brief IPSBusClk_UPC clock generator Status Register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_HIDIV_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_LODIV_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RSTN_MASK 0x1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RSTN_SHIFT 0
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RSTN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RSTN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RSTN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RSTN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RSTN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_UPCCONFIG_CLKGENSTATUS_RSTN_SHIFT))

//====================================================================
//Register: IPSBusClk_CDMA ClkGen Configuration Register (IPSBusClk_CDMAConfig_ClkGenConfig)
/** \brief IPSBusClk_CDMA clock generator Configuration Register.
            This clock domain shares its frequency configuration, and is aligned, with the
            IPSBusClk clock domain. Changes to this clock's frequency can be accomplished by
            writes to the IPSBusClk ClkGenConfig register. The values in this clock domain's
            ClkGenStatus register will reflect the values in the IPSBusClk ClkGenConfig register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED1_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED2_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED3_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED4_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED5_MASK 0x1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED5_SHIFT 0
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED5_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

//====================================================================
//Register: IPSBusClk_CDMA ClkGen Status Register (IPSBusClk_CDMAConfig_ClkGenStatus)
/** \brief IPSBusClk_CDMA clock generator Status Register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED1_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED2_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_SRCSEL_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED3_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_HIDIV_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED4_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_LODIV_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKGATED_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED5_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED6_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: IPSBusClk_APB ClkGen Configuration Register (IPSBusClk_APBConfig_ClkGenConfig)
/** \brief IPSBusClk_APB clock generator Configuration Register.
            This clock domain shares its frequency configuration, and is aligned, with the
            IPSBusClk clock domain. Changes to this clock's frequency can be accomplished by
            writes to the IPSBusClk ClkGenConfig register. The values in this clock domain's
            ClkGenStatus register will reflect the values in the IPSBusClk ClkGenConfig register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_CLKEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 0
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

//====================================================================
//Register: IPSBusClk_APB ClkGen Status Register (IPSBusClk_APBConfig_ClkGenStatus)
/** \brief IPSBusClk_APB clock generator Status Register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_HIDIV_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_LODIV_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: IPSBusClk_DEC ClkGen Configuration Register (IPSBusClk_DECConfig_ClkGenConfig)
/** \brief IPSBusClk_DEC clock generator Configuration Register.
            This clock domain shares its frequency configuration, and is aligned, with the
            IPSBusClk clock domain. Changes to this clock's frequency can be accomplished by
            writes to the IPSBusClk ClkGenConfig register. The values in this clock domain's
            ClkGenStatus register will reflect the values in the IPSBusClk ClkGenConfig register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_CLKEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 0
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

//====================================================================
//Register: IPSBusClk_DEC ClkGen Status Register (IPSBusClk_DECConfig_ClkGenStatus)
/** \brief IPSBusClk_DEC clock generator Status Register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_HIDIV_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_LODIV_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DECCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: IPSBusClk_Agate ClkGen Configuration Register (IPSBusClk_AgateConfig_ClkGenConfig)
/** \brief IPSBusClk_Agate clock generator Configuration Register.
            This clock domain shares its frequency configuration, and is aligned, with the
            IPSBusClk clock domain. Changes to this clock's frequency can be accomplished by
            writes to the IPSBusClk ClkGenConfig register. The values in this clock domain's
            ClkGenStatus register will reflect the values in the IPSBusClk ClkGenConfig register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED1_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED2_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED3_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED4_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_CLKEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED5_MASK 0x1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED5_SHIFT 0
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED5_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

//====================================================================
//Register: IPSBusClk_Agate ClkGen Status Register (IPSBusClk_AgateConfig_ClkGenStatus)
/** \brief IPSBusClk_Agate clock generator Status Register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED1_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED2_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_SRCSEL_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED3_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_HIDIV_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED4_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_LODIV_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKGATED_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED5_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED6_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_AGATECONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: IPSBusClk_Debug ClkGen Configuration Register (IPSBusClk_DebugConfig_ClkGenConfig)
/** \brief IPSBusClk_Debug clock generator Configuration Register.
            This clock domain shares its frequency configuration, and is aligned, with the
            IPSBusClk clock domain. Changes to this clock's frequency can be accomplished by
            writes to the IPSBusClk ClkGenConfig register. The values in this clock domain's
            ClkGenStatus register will reflect the values in the IPSBusClk ClkGenConfig register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_CLKEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 0
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

//====================================================================
//Register: IPSBusClk_Debug ClkGen Status Register (IPSBusClk_DebugConfig_ClkGenStatus)
/** \brief IPSBusClk_Debug clock generator Status Register.*/
//====================================================================

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_HIDIV_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_LODIV_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKEN_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_IPSBUSCLK_DEBUGCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: Scif Clock firwmare reset control (ScifClk_FWReset)
/** \brief Soft Reset control for the scifclk clock domain.*/
//====================================================================

#define  IPMU_CLKRSTGEN_SCIFCLK_FWRESET_RESERVED1_MASK 0xfffffffe
#define  IPMU_CLKRSTGEN_SCIFCLK_FWRESET_RESERVED1_SHIFT 1
#define  IPMU_CLKRSTGEN_SCIFCLK_FWRESET_RESERVED1_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCIFCLK_FWRESET_RESERVED1_MASK) >> IPMU_CLKRSTGEN_SCIFCLK_FWRESET_RESERVED1_SHIFT)
#define  IPMU_CLKRSTGEN_SCIFCLK_FWRESET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCIFCLK_FWRESET_RESERVED1_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCIFCLK_FWRESET_RESERVED1_SHIFT))

#define  IPMU_CLKRSTGEN_SCIFCLK_FWRESET_RSTN_MASK 0x1
#define  IPMU_CLKRSTGEN_SCIFCLK_FWRESET_RSTN_SHIFT 0
#define  IPMU_CLKRSTGEN_SCIFCLK_FWRESET_RSTN_MASK_SHIFT(reg) (((reg) & IPMU_CLKRSTGEN_SCIFCLK_FWRESET_RSTN_MASK) >> IPMU_CLKRSTGEN_SCIFCLK_FWRESET_RSTN_SHIFT)
#define  IPMU_CLKRSTGEN_SCIFCLK_FWRESET_RSTN_REPLACE_VAL(reg,val) (((reg) & ~IPMU_CLKRSTGEN_SCIFCLK_FWRESET_RSTN_MASK) | (((uint32_t)val) << IPMU_CLKRSTGEN_SCIFCLK_FWRESET_RSTN_SHIFT))

#endif // IPMU_TOP
