/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2007-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/
 
#ifndef __BOOTCODE_H__
#define __BOOTCODE_H__

#include <stdbool.h>
#include <stdint.h>
#include <stddef.h>
#include <assert.h>

#define ASSERT assert
#define XASSERT(x,y) assert(x)

extern uint32_t __SRAM_SCRATCH__;     // last defined location in LCM.  stack, .bss, .data, usb, < openLCM
extern uint32_t __datavars_end__;     // defined location in LCM. (check .MAP and .LD file)

extern uint32_t hwGetProcSpeed(void);
extern uint32_t hwGetSDMMCBusSpeed(void);

typedef uint32_t (*BOOT_ENTRY_FUNC)(void); 
typedef uint32_t (*IMAGE_ENTRY_FUNC)(void);

#ifdef USE_UPC
    #define DOWNLOAD_START_ADDR UPC_RAM_BASE
    #define DOWNLOAD_AREA_SIZE UPC_RAM_SIZE
    #define DOWNLOAD_AREA_SIZE_USB DOWNLOAD_AREA_SIZE // buffer is shared.
#elif defined(USE_L2)
    #define DOWNLOAD_START_ADDR get_l2_address()
    #define DOWNLOAD_AREA_SIZE get_l2_size()
    #define DOWNLOAD_AREA_SIZE_USB get_l2_size()
#else
    #define DOWNLOAD_START_ADDR 0x30000
    #define DOWNLOAD_AREA_SIZE  0x80000
    #define DOWNLOAD_AREA_SIZE_USB DOWNLOAD_AREA_SIZE // since this buffer is shared.
#endif

#define SETEXTDERROR(n)
#define CHECKSUM_LENGTH         4  // the length of the checksum

/**
 * Define the values that will be set in the b0 and b1 bits for booting.
 */
#define NVOPT_SPI 0
#define NVOPT_NAND 1
#define NVOPT_SD   2
#define NVOPT_IGNORE 3
#define NVOPT_SDA   4
#define NVOPT_SD1   5
#define NVOPT_SDB   6
#define NVOPT_IGNORE1 7

// return the values of bootsource bo and b1 as a char with b0 in 0 and b1 in 1
uint8_t get_boot_nv_options(void);

//
// This is the code table defines for flash code tables.
// 
#define MAGIC_WORD 0xc0deed0c
#define CONFIG_SECTOR 1
#define CODE_SECTOR 2
#define DATA_SECTOR 3
#define SPARE_SECTOR 4  ///< this is for the nand spare table.


#endif //ifndef __BOOTCODE_H__

