/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2007-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/


;# * Description:
;# * 
;# * Compatibility/abstraction macros to allow Assembly code to be
;# * written compatible between RVDS and GNU assemblers.
;# * 
;# *
 
#ifndef __asmCmptLayer_h__
#define __asmCmptLayer_h__
 

#ifdef __GNUC__
#define IMPORT(x)
#define EXPORT .global    
#define LABEL(x) x:
#define END 
#define MEND .endm
#define EQUDEF(x,y) .equ x, y
#define DEFW .word
#include "armR4_gnu_macros.h"
#else
#define IMPORT(x) IMPORT x
#define LABEL(x) x
#define EQUDEF(x,y) x EQU y
#define DEFW DCD
xxx not supported yet
#include "armR4_macros.h"
#endif

;# #ifndef __asmCmptLayer_h__
#endif 
