/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2007-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

//#define ARM_MPU 1  MPU is being handled in cpu driver - it has special requirements.

/* ANSI concatenation macros.  */
#define CONCAT(a, b) CONCAT2(a, b)
#define CONCAT2(a, b) a ## b

#ifdef __USER_LABEL_PREFIX__
#define FUNCTION( name ) CONCAT (__USER_LABEL_PREFIX__, name)
#else
#error __USER_LABEL_PREFIX is not defined
#endif

#*******************************************************************************
# Initialize Register - friendly to simulations...
#                                mInitRegisters
#*******************************************************************************
        .macro mInitRegisters
        mov     r0,#0
        mov     r1,#0
        mov     r2,#0
        mov     r3,#0
        mov     r4,#0
        mov     r5,#0
        mov     r6,#0
        mov     r7,#0
        mov     r8,#0
        mov     r9,#0
        mov     r10,#0
        mov     r11,#0
        mov     r12,#0
        .endm
#*******************************************************************************


#*******************************************************************************
# Mask processor FIQ interrupt - will return cpsr pre-value in r0 to use with
#                                mRestoreFIQ
#*******************************************************************************
        .macro mDisableFIQ
        mrs     r0,cpsr
        orr     r1,r0,#0x40     ;# set the FIQ disable bit
        msr     cpsr_c,r1
        .endm
#*******************************************************************************

#*******************************************************************************
# Restore processor FIQ interrupt - pass previous value in r0 on entry
#*******************************************************************************
        .macro mRestoreFIQ
        msr     cpsr_c,r0
        .endm
#*******************************************************************************


#*******************************************************************************
# Enable processor FIQ interrupt (trashes r0)
#*******************************************************************************
        .macro mEnableFIQ
        mrs     r0,cpsr
        bic     r0,r0,#0x40     ;# clear the FIQ disable bit
        msr     cpsr_c,r0
        .endm
#*******************************************************************************



#*******************************************************************************
# Mask processor IRQ interrupt - will return cpsr pre-value in r0 to use with
#                                mRestoreIRQ
#*******************************************************************************
        .macro mDisableIRQ
        mrs     r0,cpsr
        orr     r1,r0,#0x80     ;# set the IRQ disable bit
        msr     cpsr_c,r1
        .endm
#*******************************************************************************


#*******************************************************************************
# Restore processor IRQ interrupt  - pass previous value in r0 on entry
#*******************************************************************************
        .macro mRestoreIRQ
        msr     cpsr_c,r0
        .endm
#*******************************************************************************

#*******************************************************************************
# Enable processor IRQ interrupt (trashes r0)
#*******************************************************************************
        .macro mEnableIRQ
        mrs     r0,cpsr
        bic     r0,r0,#0x80     ;# clear the IRQ disable bit
        msr     cpsr_c,r0
        .endm
#*******************************************************************************


#*******************************************************************************
# Set processor Mode to SVC (trashes r0)
#*******************************************************************************
        .macro mSetSVCMode
        mrs     r0,cpsr
        bic     r0,r0,#0x1f     ;# clear the Mode bits
        orr     r0,r0,#0x13     ;# clear the Mode bits
        msr     cpsr_c,r0
        .endm
#*******************************************************************************


#******************************************************************************
# stop the processor
#******************************************************************************
        .macro mHalt
1001:   nop
        b      1001b
        .endm
#******************************************************************************


#******************************************************************************
# Write an ASCII string to the UART TTY
#******************************************************************************

#define UART1_BASE AP_AP_APB_UART1_BASE
.equ __UART_RBR, UART1_BASE + 0x00             ;# Physical UART1 Addresses
.equ __UART_THR, UART1_BASE + 0x00
.equ __UART_IER, UART1_BASE + 0x04
.equ __UART_IIR, UART1_BASE + 0x08
.equ __UART_FCR, UART1_BASE + 0x08
.equ __UART_LCR, UART1_BASE + 0x0C
.equ __UART_MCR, UART1_BASE + 0x10
.equ __UART_LSR, UART1_BASE + 0x14
.equ __UART_MSR, UART1_BASE + 0x18
.equ __UART_SCR, UART1_BASE + 0x1C
.equ __UART_DLL, UART1_BASE + 0x00
.equ __UART_DLH, UART1_BASE + 0x04

#******************************************************************************
# initialize UART (registers trashes r0,r1)
#******************************************************************************
        .macro mInitUart
		mWr		__UART_IER, 0
		mWr		__UART_LCR, 0x00000083    ;# 8bit,1stop,noparity,DLAB=1
		mWr		__UART_DLL, 0x00000015    ;# 38400 KBaud
		mWr		__UART_DLH, 0
		mWr		__UART_LCR, 0x00000003    ;# 8bit,1stop,noparity,DLAB=0
		mWr		__UART_IER, 0x00000040    ;#
		mWr		__UART_MCR, 0x00000023    ;# autoRTS, DTR, RTS
		mWr		__UART_FCR, 0x000000B7    ;# clearFIFO, enableFIFO, threshold=half
        .endm
#******************************************************************************


#******************************************************************************
# Transfer the character to the UART Transmitter (trashes r0,r1,CharRegister)
#******************************************************************************
        .macro mDispUartChar CharRegister
	    mMov32	r1, __UART_LSR
1000:   ldr     r0, [r1]
        and     r0,r0,#0x20
        cmp		r0,#0
        beq		1000b                 ;# wait for THRE=1
        and     \CharRegister,\CharRegister,#0x000000FF
        mMov32  r1,__UART_THR
        str     \CharRegister,[r1]    ;# write to UART command register
        .endm

		.macro mPutC Char
		mov		r3, #\Char
		mDispUartChar r3
		.endm

#******************************************************************************


#******************************************************************************
# Write an ASCII string to the UART TTY
#******************************************************************************
        .macro mDispUart String
       B       1002f
1001:   .string     "\String"
        .balign 16
1002:   nop                      ;# fix for ADS assembler bug
        mMov32  r2,1001b         ;# put string address in r2
1003:	ldrb    r3,[r2]          ;# get next character
        cmp     r3,#0
        beq     1004f            ;# end of ASCIIZ string?
        mDispUartChar r3         ;# write character to UART
        add     r2,r2,#1
        b      1003b
1004:	nop
        .endm
#******************************************************************************


#******************************************************************************
# Write an ASCII string pointed to by Ptr into the UART TTY
#******************************************************************************
        .macro mDispUartPtr Ptr
        mov		r2,\Ptr			;# put string address in r2
1003:	ldrb    r3,[r2]			;# get next character
        cmp     r3,#0
        beq     1004f           ;# end of ASCIIZ string?
        mDispUartChar r3        ;# write character to UART
        add     r2,r2,#1
        b       1003b
1004:	nop
        .endm
#******************************************************************************


#******************************************************************************
# display 32-bit number in hex to the UART TTY
#******************************************************************************
        .macro mDispUart32 DataRegister
        mov     r4,\DataRegister         ;# make a local copy
        mov     r3,#8                    ;# loop for 8 hex characters
1001:   mov     r2,r4,lsr #28            ;# get the MSB character
        cmp     r2,#0x0A
        blt     1002f                    ;# alpha or numeric digit?
        add     r2,r2,#0x07              ;# add offset to alpha characters
1002:   add     r2,r2,#0x30              ;# convert to ASCII digit
        mDispUartChar r2
        mov     r4,r4,lsl #4             ;# move on to the next character
        sub     r3,r3,#1                 ;# decrement character loop counter
        cmp     r3,#0
        bne     1001b
        .endm
#******************************************************************************


#******************************************************************************
# display 8-bit number in hex to the UART TTY
#******************************************************************************
        .macro mDispUart8 DataRegister
        mov     r4,\DataRegister,lsl #24 ;# make a local copy in high r4
        mov     r3,#2                    ;# loop for 2 hex characters
1001:   mov     r2,r4,lsr #28            ;# get the MSB character
        cmp     r2,#0x0A
        blt     1002f                    ;# alpha or numeric digit?
        add     r2,r2,#0x07              ;# add offset to alpha characters
1002:   add     r2,r2,#0x30              ;# convert to ASCII HEX digit
        mDispUartChar r2
        mov     r4,r4,lsl #4             ;# move on to the next character
        sub     r3,r3,#1                 ;# decrement character loop counter
        cmp     r3,#0
        bne     1001b
        .endm
#******************************************************************************


#******************************************************************************
# Enable the Arm Instruction cache
#******************************************************************************
        .macro mEnableICache                             ;# trashes r0 & r1
        MRC p15, 0, R1, c1, c0, 0 ;# Read System Control Register configuration data
        ORR R1, R1, #0x1 <<12 ;# instruction cache enable
        MOV R0, #0
        MCR p15, 0, r0, c7, c5, 0 ;# Invalidate entire instruction cache
        MCR p15, 0, R1, c1, c0, 0 ;# enabled instruction cache
        ISB
        .endm
#******************************************************************************


#******************************************************************************
# Disable the Arm Instruction cache
#******************************************************************************
        .macro mDisableICache                           ;# trashes r0
        MRC p15, 0, R0, c1, c0, 0 ;# Read System Control Register configuration data
        BIC R0, R0, #0x1 <<12 ;# instruction cache enable
        MCR p15, 0, R0, c1, c0, 0 ;# disabled instruction cache
        ISB
        .endm
#******************************************************************************


#******************************************************************************
# Enable the Arm Data cache
#******************************************************************************
        .macro mEnableDCache                            ;# trashes r0 & R1
        MRC p15, 0, R1, c1, c0, 0 ;# Read System Control Register configuration data
        ORR R1, R1, #0x1 <<2
        MOV R0, #0
        DSB
        MCR p15, 0, r0, c15, c5, 0 ;# Invalidate entire data cache
        MCR p15, 0, R1, c1, c0, 0 ;# enabled data cache
        .endm
#******************************************************************************


#******************************************************************************
# Disable the Arm Data cache
#******************************************************************************
        .macro mDisableDCache                            ;# trashes r0
        MRC p15, 0, R0, c1, c0, 0 ;# Read System Control Register configuration data
        BIC R0, R0, #0x1 <<2
        DSB
        MCR p15, 0, R0, c1, c0, 0 ;# disabled data cache
        .endm
#******************************************************************************

#******************************************************************************
# Invalidate the Arm Data cache
#******************************************************************************
        .macro mInvalidateDCache                            ;# trashes r0
         DSB ;
         mov r0,#0
         mcr p15,0,r0,c15,c5,0 ;
        .endm
#******************************************************************************

#if ARM_BPU
#******************************************************************************
# Disable the Arm Branch Prediction Unit
#******************************************************************************
        .macro mDisableBPU                           ;# trashes r0
        mrc    p15, 0, r0, c1, c0, 0
        bic    r0, r0, #0x0800                           ;# turn off BPU
        mcr    p15, 0, r0, c1, c0, 0
        .endm
#******************************************************************************
#endif
#if 1 //ARM_MPU
#******************************************************************************
# Enable the Arm MPU
#******************************************************************************
        .macro mEnableMPU                               ;# trashes r0
        MRC p15, 0, R0, c1, c0, 0 ;# read CP15 register 1
        ORR R0, R0, #0x1
        DSB
        MCR p15, 0, R0, c1, c0, 0 ;# enable MPU
        ISB
        .endm
#******************************************************************************
#endif
#if 1
#******************************************************************************
# Disable the Arm MPU
#******************************************************************************
        .macro mDisableMPU                              ;# trashes r0
        MRC p15, 0, R0, c1, c0, 0 ;# read CP15 register 1
        BIC R0, R0, #0x1
        DSB
        MCR p15, 0, R0, c1, c0, 0 ;# disable MPU
        ISB
        .endm
#******************************************************************************

#endif

#******************************************************************************
# Move Vectors to 0x0
#******************************************************************************
        .macro mVectorSwitch0                              ;# trashes r0
        MRC     p15, 0, r0, c1, c0, 0   ;# Load CP15,r1 into r0
        BIC     r0, r0, #0x2000         ;# clear the bit to move vector to 0x0
        MCR     p15, 0, r0, c1, c0, 0   ;# Write CP15,r1 back
        .endm
#******************************************************************************

#******************************************************************************
# Move Vectors to 0xFFFF0000
#******************************************************************************
        .macro mVectorSwitchF                              ;# trashes r0
        MRC     p15, 0, r0, c1, c0, 0   ;# Load CP15,r1 into r0
        ORR     r0, r0, #0x2000           ;# set the bit for vectors at 0xFFFF0000
        MCR     p15, 0, r0, c1, c0, 0   ;# Write CP15,r1 back
        .endm
#******************************************************************************

#******************************************************************************
# Move Vectors to 0xFFFF0000 or 0x00000000 depending on Compile flag
#******************************************************************************
        .macro mVectorSwitch                              ;# trashes r0
#if defined(BUILDRAM) || defined(BUILDLCM)
      mVectorSwitch0
#else
      mVectorSwitchF
#endif
        .endm
#******************************************************************************

#******************************************************************************
# Hold AP CPU0 in reset
#******************************************************************************
#define FPGA_BASE FPGAD_CONFIG_BASE
.equ __DUALA53_0, FPGA_BASE + 0x60       ;# FPGAD::Config::DualA53_0 Addresses

        .macro mAP_CPU0_ResetHold                         ;# trashes r0
        LDR         r0,=__DUALA53_0
        BIC         r0,#1
        ORR         r0,r0,#2
        STR         r0,=__DUALA53_0
        .endm

#******************************************************************************

;#******************************************************************************
;#******************************************************************************
    .macro mWarmBoot                              ;# trashes r0 & r1
#if 1
;# read warm boot = Power Island Boot Register
;# test cases
;# VVLT- Power Island Boot Register - repeated cases removed
;# 0000 - no warm
;# 0001 - warm lcm jump addr(pfWarmBootEntry)
;# 0010 - no warm
;# 0011 - warm vector 0
;# 0101 - warm lcm jump addr(pfWarmBootEntry)
;# 0111 - warm v1
;# 1011 - warm v2
;# 1111 - warm v3
;# if set, if jump addr, ??if watchdog??,
;# r0 = PIBR
;# r1 = *PIBR
;# r2 = tmp
;# r3 = *pfWarmBootPatch
;# get jump addr, NULL jump addr (this keep from infinite loop), jump
    ldr r0,=PIBR
    ldr r1,[r0]
    ANDS r2,r1,#0x01
    BEQ warmBootExit

;# some type of warm boot exits, but first check for patched handler
    LDR r2,=pfWarmBootPatch
    LDR r3,[r2]
    CMP r3,#0
    BEQ noWarmPatch

;# jump to patch handler, but first erase handler (this keeps from infinite loop)
    MOV r4,#0
    STR r4,[r2]
    mov pc,r3

noWarmPatch:
warmBootWait:
;# CPU is up running, but need to wait for GREEN LIGHT message from m3: 0=WAIT; 1=OK
    ldr r1,[r0]
    ANDS r2,r1,#0xf0
    BEQ warmBootWait

;# we now can clear warm boot bit, had to wait for other CPU to finish..
    BIC r1,r1,#0x01
    STR r1,[r0]

    CMP r2,#0x10
    BNE warmBootExit

warmBootReady:
;# determine if vectored or normal
    ANDS r2,r1,#0x02
    BNE warmVector

;# warm boot normal, use our jump address stored in pfWarmBootEntry
    LDR r0,=pfWarmBootEntry
    LDR r0,[r0]
;# jump
    mov pc,r0

warmVector:
;# which vector
    AND r1,r1,#0x0c
;# load vector
    ldr r0,=PIVR
    LDR r1,[r0,r1]
;# jump
    mov pc,r1

warmBootExit:

#endif
    .endm
;#******************************************************************************

;#******************************************************************************
;#******************************************************************************
    .macro mbSPIInitialize                              ;# trashes r0 & r1
#if defined(BUILDSPI) || defined(BUILDROM)
#include "regAddrs.h"
#ifdef SERENITY
#define BSPI_BSCR_INITVAL_FLASH 0x0207D002
#elif defined(DESTINY)
#define BSPI_BSCR_INITVAL_FLASH 0x00000000
#define BOOTSPI_BASE			AP_IO_WRAP_BOOTSPI_BASE+0x24
#else
#define BSPI_BSCR_INITVAL_FLASH 0x0101D002
#endif
;# setup bootspi configuration register
    ldr r0,=BOOTSPI_BASE
    ldr r1,=BSPI_BSCR_INITVAL_FLASH
    str r1, [r0]
#endif
    .endm
;#******************************************************************************

;#******************************************************************************
;#******************************************************************************
    .macro mHaltboot                              ;# trashes r0 & r1
#if 0
;# sometimes doing tricky code, it is handy to stop boot process
;# we are whacking the vectors
   ldr r0,=0xEAFFFFFE             ;# pc = pc - 8
   ldr r1,=0xf7000000
   str r0,[r1],#4
   str r0,[r1],#4
#endif
    .endm
;#******************************************************************************

;#******************************************************************************
;#******************************************************************************
    .macro mCacheReadInfo
#if 0
;# read current icache size - first select icache, then read
;# serenity 12/11/2010 = f00fe019 16k, x7f sets, 8words line.
    mov r0,#1
    mcr p15, 2, r0, c0, c0, 0 ;
    mrc p15, 1, r0, c0, c0, 0 ;
;# read current dcache size - first select dcache, then read
;# serenity 12/11/2010 = f007e019 8k, x3f sets, 8words line.
    mov r0,#0
    mcr p15, 2, r0, c0, c0, 0 ;
    mrc p15, 1, r0, c0, c0, 0 ;
#endif
    .endm
;#******************************************************************************

;#******************************************************************************
;# test LCM/TCM and exit with filled 0xFFFFFFFF
;# fill with 0
;# test 0, backfilling w/ addr
;# test addr, backfill w/ EOR addr
;# test EOR addr, backfill w/ 0xFF
;# R7 start address
;# R8 size
;# LR return address
;#******************************************************************************
    .macro mDeclareMemoryTestAndFill
#if 1
MemoryTestandFill:
;# SIMPLE memory test
    mDispUart "\n\rSIMPLE memory test - Fill/Verify 0s"
;# fill with 0
    mov   r0,r7
    mov   r1,#0
    mov   r2,r8
    ADD  R3, R0, R2       ;#Calculate Final Address + 1
xMemsetLoop:
    STR  R1, [R0], #4      ;#Store a word at offset
    CMP  R0, R3           ;#See if we are done copying
    BNE  xMemsetLoop

;# verify addr reads 0
;# store *(addr) = addr
    mov   r0,r7
    mov   r2,r8
    ADD  R3, R0, R2       ;#Calculate Final Address + 1
aMemsetLoop:
    LDR  R1, [R0]
    CMP  R1, #0
    BNE  ZeroError
    STR  R0, [R0], #4      ;#Store a word at offset
    CMP  R0, R3           ;#See if we are done copying
    BNE  aMemsetLoop

;# verify *(addr) == addr
    mDispUart "\n\rSIMPLE memory test - verify *(addr) == addr"
;# store *(addr) = EOR(addr)
    mov   r0,r7
    mov   r2,r8
    ldr   r4,=0xffffffff
    ADD  R3, R0, R2       ;#Calculate Final Address + 1
bMemsetLoop:
    LDR  R1, [R0]
    CMP  R1, R0
    BNE  IncAddrError
    EOR  R1, R1, R4
    STR  R1, [R0], #4      ;#Store a word at offset
    CMP  R0, R3           ;#See if we are done copying
    BNE  bMemsetLoop

;# verify *(addr) == EOR(addr)
    mDispUart "\n\rSIMPLE memory test - verify *(addr) == EOR(addr)"
;# store *(addr) = 0xffffffff
    mov   r0,r7
    mov   r2,r8
    ldr   r4,=0xffffffff
    ADD  R3, R0, R2       ;#Calculate Final Address + 1
cMemsetLoop:
    LDR  R1, [R0]
    EOR  r2, r0, r4
    CMP  R1, R2
    BNE  EORIncAddrError
    EOR  R1, R1, R4
    STR  R4, [R0], #4      ;#Store a word at offset
    CMP  R0, R3           ;#See if we are done copying
    BNE  cMemsetLoop

    BX   LR

EORIncAddrError:
IncAddrError:
ZeroError:
    b ZeroError

#endif
    .endm
;#******************************************************************************

;#******************************************************************************
;# test LCM and exit with filled 0xFFFFFFFF
;# R7 start address
;# R8 size
;#******************************************************************************
    .macro mMemoryTestAndFill	startAddr, size
    ldr   r7,=\startAddr
    ldr   r8,=\size
    BL    MemoryTestandFill
    .endm
;#******************************************************************************

#*******************************************************************************
# Allocate space for constants
#*******************************************************************************
        .macro mLTORG
        b       1001f
        LTORG
1001:
        .endm
#*******************************************************************************


#*******************************************************************************
# Move a 32-bit immediate value into a register
#*******************************************************************************
        .macro mMov32  register,immed32
        ldr     \register,=\immed32
        .endm
#*******************************************************************************


#*******************************************************************************
# Write immediate data to a memory location  (trashes r0,r1)
#*******************************************************************************
        .macro mWr  Address,Data
        LDR     r0,=\Data
        LDR     r1,=\Address
        STR     r0,[r1]
        .endm
#*******************************************************************************


#*******************************************************************************
# Read to register from a memory location
#*******************************************************************************
        .macro mRd     Address,ResultRegister
        mMov32  \ResultRegister,\Address
        ldr     \ResultRegister,[\ResultRegister]
        .endm
#*******************************************************************************


#*******************************************************************************
# Display checkpoint on CPU debug LEDs (trashes r0,r1)
#*******************************************************************************
       .macro mDispCPULED  Data
       LDR     r0,=\Data
       EOR     r0,r0,#0x000000FF
       AND     r0,r0,#0x000000FF
#      LDR     r1,=__BBGDR
       LDR     r1,=__CLR
       STR     r0,[r1]
       .endm
#*******************************************************************************


#*******************************************************************************
# Copy a block of memory
#*******************************************************************************
        .macro mCopyMem  source,destination,numbytes     ;# numbytes is multiple of 32
        ldr     r9, =\destination                    ;#-Load address of dest
        ldr     r10, =\source                        ;#-Load address of source
        add     r11, r10, #\numbytes                 ;#-Load address of last word
1001:
        ldmia   r10!, {r0-r7}                        ;#-Load 8 words from source
        stmia   r9!, {r0-r7}                         ;#-Store 8 words to dest
        cmp     r10, r11                             ;#-Repeat until dest full
        blo     1001b
        .endm
#*******************************************************************************

#*******************************************************************************
# Copy a block of memory from registers
# r9 destination
# r10 source
# r11 numbytes
#*******************************************************************************
        .macro mCopyMemR                            ;# numbytes is multiple of 32
        add     r11, r10, r11                        ;#-Load address of last word
1001:
        ldmia   r10!, {r0-r7}                        ;#-Load 8 words from source
        stmia   r9!, {r0-r7}                         ;#-Store 8 words to dest
        cmp     r10, r11                             ;#-Repeat until dest full
        blo     1001b
        .endm
#*******************************************************************************

#*******************************************************************************
# Swap32  R0-in/out;
#*******************************************************************************
        .macro mSwap32_r0      ;# R0 swap32
        mov   r10, r0         ;# store R0
        and   r0, r0, #255    ;# 0xff
        mov   r11, r0, lsl #24
        mov   r0, r10
        and   r0, r0, #65280  ;# 0xff00
        mov   r0, r0, lsl #8
        orr   r11, r11, r0
        mov   r0, r10
        and   r0, r0, #16711680 ;# 0xff0000
        mov   r0, r0, lsr #8
        orr   r11, r11, r0
        mov   r0, r10
        mov   r0, r0, lsr #24
        and   r0, r0, #255    ;# 0xff
        orr   r0, r11, r0
        .endm
#*******************************************************************************


