/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/
#ifndef __ID_UTILS_H__
#define __ID_UTILS_H__

#include <stdint.h>
#include <stdbool.h>
#include "rom_types.h"
#include "board_types.h"

extern bool ddr4_memory;
#define CHIP_REVA           (0)
#define CHIP_REVB           (0x10)
#define CHIP_REVB1          (0x11)
#define CHIP_REVC           (0x20)
#define CHIP_REVD           (0x30)
#define CHIP_GR2            (0x6270)
#define CHIP_GE2            (0x6220)
#define CHIP_GE2_REVB       (0x01)

#define is_RevA()           (CHIP_REVA == get_chip_rev())
#define is_RevB1()          (CHIP_REVB1 == get_chip_rev())
#define is_RevB()           ((CHIP_REVB == get_chip_rev()) || (CHIP_REVB1 == get_chip_rev()))
#define is_RevC()           (CHIP_REVC == get_chip_rev())
#define is_Gr2()            (CHIP_GR2 == get_chip_id())
#define is_Ge2()            (CHIP_GE2 == get_chip_id())
#define is_Ge2_RevB()       (CHIP_GE2_REVB == get_chip_rev())
#define is_NOT_Gr2_RevA()   (!(is_Gr2() && is_RevA()))
#define is_ddr4()	    (ddr4_memory)

void* get_CIU_base(void);
uint16_t get_chip_id(void);
uint8_t get_chip_rev(void);
inline bool is_FPGA(void);
inline bool is_Si(void);
bool is_Gr2_RevC1(void);
rom_types_e check_rom_type(void);
board_types_e check_board_type(void);

#endif //#ifndef __ID_UTILS_H__

