/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2020 Fuzhou Rockchip Electronics Co., Ltd
 */

#ifndef _DT_BINDINGS_DRAM_ROCKCHIP_RV1126_H
#define _DT_BINDINGS_DRAM_ROCKCHIP_RV1126_H

#define DDR2_DS_FULL			(0)
#define DDR2_DS_REDUCE			(1)

#define DDR2_ODT_DIS			(0)
#define DDR2_ODT_50ohm			(50)	/* optional */
#define DDR2_ODT_75ohm			(75)
#define DDR2_ODT_150ohm			(150)

#define DDR3_DS_34ohm			(34)
#define DDR3_DS_40ohm			(40)

#define DDR3_ODT_DIS			(0)
#define DDR3_ODT_40ohm			(40)
#define DDR3_ODT_60ohm			(60)
#define DDR3_ODT_120ohm			(120)

#define LP2_DS_34ohm			(34)
#define LP2_DS_40ohm			(40)
#define LP2_DS_48ohm			(48)
#define LP2_DS_60ohm			(60)
#define LP2_DS_68_6ohm			(68)	/* optional */
#define LP2_DS_80ohm			(80)
#define LP2_DS_120ohm			(120)	/* optional */

#define LP3_DS_34ohm			(34)
#define LP3_DS_40ohm			(40)
#define LP3_DS_48ohm			(48)
#define LP3_DS_60ohm			(60)
#define LP3_DS_80ohm			(80)
#define LP3_DS_34D_40U			(3440)
#define LP3_DS_40D_48U			(4048)
#define LP3_DS_34D_48U			(3448)

#define LP3_ODT_DIS			(0)
#define LP3_ODT_60ohm			(60)
#define LP3_ODT_120ohm			(120)
#define LP3_ODT_240ohm			(240)

#define LP4_PDDS_40ohm			(40)
#define LP4_PDDS_48ohm			(48)
#define LP4_PDDS_60ohm			(60)
#define LP4_PDDS_80ohm			(80)
#define LP4_PDDS_120ohm			(120)
#define LP4_PDDS_240ohm			(240)

#define LP4_DQ_ODT_40ohm		(40)
#define LP4_DQ_ODT_48ohm		(48)
#define LP4_DQ_ODT_60ohm		(60)
#define LP4_DQ_ODT_80ohm		(80)
#define LP4_DQ_ODT_120ohm		(120)
#define LP4_DQ_ODT_240ohm		(240)
#define LP4_DQ_ODT_DIS			(0)

#define LP4_CA_ODT_40ohm		(40)
#define LP4_CA_ODT_48ohm		(48)
#define LP4_CA_ODT_60ohm		(60)
#define LP4_CA_ODT_80ohm		(80)
#define LP4_CA_ODT_120ohm		(120)
#define LP4_CA_ODT_240ohm		(240)
#define LP4_CA_ODT_DIS			(0)

#define DDR4_DS_34ohm			(34)
#define DDR4_DS_48ohm			(48)
#define DDR4_RTT_NOM_DIS		(0)
#define DDR4_RTT_NOM_60ohm		(60)
#define DDR4_RTT_NOM_120ohm		(120)
#define DDR4_RTT_NOM_40ohm		(40)
#define DDR4_RTT_NOM_240ohm		(240)
#define DDR4_RTT_NOM_48ohm		(48)
#define DDR4_RTT_NOM_80ohm		(80)
#define DDR4_RTT_NOM_34ohm		(34)

#define PHY_DDR3_RON_DISABLE		(0)
#define PHY_DDR3_RON_506ohm		(1)
#define PHY_DDR3_RON_253ohm		(2)
#define PHY_DDR3_RON_169hm		(3)
#define PHY_DDR3_RON_127ohm		(4)
#define PHY_DDR3_RON_101ohm		(5)
#define PHY_DDR3_RON_84ohm		(6)
#define PHY_DDR3_RON_72ohm		(7)
#define PHY_DDR3_RON_63ohm		(16)
#define PHY_DDR3_RON_56ohm		(17)
#define PHY_DDR3_RON_51ohm		(18)
#define PHY_DDR3_RON_46ohm		(19)
#define PHY_DDR3_RON_42ohm		(20)
#define PHY_DDR3_RON_39ohm		(21)
#define PHY_DDR3_RON_36ohm		(22)
#define PHY_DDR3_RON_34ohm		(23)
#define PHY_DDR3_RON_32ohm		(24)
#define PHY_DDR3_RON_30ohm		(25)
#define PHY_DDR3_RON_28ohm		(26)
#define PHY_DDR3_RON_27ohm		(27)
#define PHY_DDR3_RON_25ohm		(28)
#define PHY_DDR3_RON_24ohm		(29)
#define PHY_DDR3_RON_23ohm		(30)
#define PHY_DDR3_RON_22ohm		(31)

#define PHY_DDR3_RTT_DISABLE		(0)
#define PHY_DDR3_RTT_953ohm		(1)
#define PHY_DDR3_RTT_483ohm		(2)
#define PHY_DDR3_RTT_320ohm		(3)
#define PHY_DDR3_RTT_241ohm		(4)
#define PHY_DDR3_RTT_193ohm		(5)
#define PHY_DDR3_RTT_161ohm		(6)
#define PHY_DDR3_RTT_138ohm		(7)
#define PHY_DDR3_RTT_121ohm		(16)
#define PHY_DDR3_RTT_107ohm		(17)
#define PHY_DDR3_RTT_97ohm		(18)
#define PHY_DDR3_RTT_88ohm		(19)
#define PHY_DDR3_RTT_80ohm		(20)
#define PHY_DDR3_RTT_74ohm		(21)
#define PHY_DDR3_RTT_69ohm		(22)
#define PHY_DDR3_RTT_64ohm		(23)
#define PHY_DDR3_RTT_60ohm		(24)
#define PHY_DDR3_RTT_57ohm		(25)
#define PHY_DDR3_RTT_54ohm		(26)
#define PHY_DDR3_RTT_51ohm		(27)
#define PHY_DDR3_RTT_48ohm		(28)
#define PHY_DDR3_RTT_46ohm		(29)
#define PHY_DDR3_RTT_44ohm		(30)
#define PHY_DDR3_RTT_42ohm		(31)

#define PHY_DDR4_LPDDR3_RON_DISABLE	(0)
#define PHY_DDR4_LPDDR3_RON_570ohm	(1)
#define PHY_DDR4_LPDDR3_RON_285ohm	(2)
#define PHY_DDR4_LPDDR3_RON_190ohm	(3)
#define PHY_DDR4_LPDDR3_RON_142ohm	(4)
#define PHY_DDR4_LPDDR3_RON_114ohm	(5)
#define PHY_DDR4_LPDDR3_RON_95ohm	(6)
#define PHY_DDR4_LPDDR3_RON_81ohm	(7)
#define PHY_DDR4_LPDDR3_RON_71ohm	(16)
#define PHY_DDR4_LPDDR3_RON_63ohm	(17)
#define PHY_DDR4_LPDDR3_RON_57ohm	(18)
#define PHY_DDR4_LPDDR3_RON_52ohm	(19)
#define PHY_DDR4_LPDDR3_RON_47ohm	(20)
#define PHY_DDR4_LPDDR3_RON_44ohm	(21)
#define PHY_DDR4_LPDDR3_RON_41ohm	(22)
#define PHY_DDR4_LPDDR3_RON_38ohm	(23)
#define PHY_DDR4_LPDDR3_RON_36ohm	(24)
#define PHY_DDR4_LPDDR3_RON_34ohm	(25)
#define PHY_DDR4_LPDDR3_RON_32ohm	(26)
#define PHY_DDR4_LPDDR3_RON_30ohm	(27)
#define PHY_DDR4_LPDDR3_RON_28ohm	(28)
#define PHY_DDR4_LPDDR3_RON_27ohm	(29)
#define PHY_DDR4_LPDDR3_RON_26ohm	(30)
#define PHY_DDR4_LPDDR3_RON_25ohm	(31)

#define PHY_DDR4_LPDDR3_RTT_DISABLE	(0)
#define PHY_DDR4_LPDDR3_RTT_973ohm	(1)
#define PHY_DDR4_LPDDR3_RTT_493ohm	(2)
#define PHY_DDR4_LPDDR3_RTT_327ohm	(3)
#define PHY_DDR4_LPDDR3_RTT_247ohm	(4)
#define PHY_DDR4_LPDDR3_RTT_197ohm	(5)
#define PHY_DDR4_LPDDR3_RTT_164ohm	(6)
#define PHY_DDR4_LPDDR3_RTT_141ohm	(7)
#define PHY_DDR4_LPDDR3_RTT_123ohm	(16)
#define PHY_DDR4_LPDDR3_RTT_109ohm	(17)
#define PHY_DDR4_LPDDR3_RTT_99ohm	(18)
#define PHY_DDR4_LPDDR3_RTT_90ohm	(19)
#define PHY_DDR4_LPDDR3_RTT_82ohm	(20)
#define PHY_DDR4_LPDDR3_RTT_76ohm	(21)
#define PHY_DDR4_LPDDR3_RTT_70ohm	(22)
#define PHY_DDR4_LPDDR3_RTT_66ohm	(23)
#define PHY_DDR4_LPDDR3_RTT_62ohm	(24)
#define PHY_DDR4_LPDDR3_RTT_58ohm	(25)
#define PHY_DDR4_LPDDR3_RTT_55ohm	(26)
#define PHY_DDR4_LPDDR3_RTT_52ohm	(27)
#define PHY_DDR4_LPDDR3_RTT_49ohm	(28)
#define PHY_DDR4_LPDDR3_RTT_47ohm	(29)
#define PHY_DDR4_LPDDR3_RTT_45ohm	(30)
#define PHY_DDR4_LPDDR3_RTT_43ohm	(31)

#define PHY_LPDDR4_RON_DISABLE		(0)
#define PHY_LPDDR4_RON_606ohm		(1)
#define PHY_LPDDR4_RON_303ohm		(2)
#define PHY_LPDDR4_RON_202ohm		(3)
#define PHY_LPDDR4_RON_152ohm		(4)
#define PHY_LPDDR4_RON_121ohm		(5)
#define PHY_LPDDR4_RON_101ohm		(6)
#define PHY_LPDDR4_RON_87ohm		(7)
#define PHY_LPDDR4_RON_76ohm		(16)
#define PHY_LPDDR4_RON_67ohm		(17)
#define PHY_LPDDR4_RON_61ohm		(18)
#define PHY_LPDDR4_RON_55ohm		(19)
#define PHY_LPDDR4_RON_51ohm		(20)
#define PHY_LPDDR4_RON_47ohm		(21)
#define PHY_LPDDR4_RON_43ohm		(22)
#define PHY_LPDDR4_RON_40ohm		(23)
#define PHY_LPDDR4_RON_38ohm		(24)
#define PHY_LPDDR4_RON_36ohm		(25)
#define PHY_LPDDR4_RON_34ohm		(26)
#define PHY_LPDDR4_RON_32ohm		(27)
#define PHY_LPDDR4_RON_30ohm		(28)
#define PHY_LPDDR4_RON_29ohm		(29)
#define PHY_LPDDR4_RON_28ohm		(30)
#define PHY_LPDDR4_RON_26ohm		(31)

#define PHY_LPDDR4_RTT_DISABLE		(0)
#define PHY_LPDDR4_RTT_998ohm		(1)
#define PHY_LPDDR4_RTT_506ohm		(2)
#define PHY_LPDDR4_RTT_336ohm		(3)
#define PHY_LPDDR4_RTT_253ohm		(4)
#define PHY_LPDDR4_RTT_202ohm		(5)
#define PHY_LPDDR4_RTT_169ohm		(6)
#define PHY_LPDDR4_RTT_144ohm		(7)
#define PHY_LPDDR4_RTT_127ohm		(16)
#define PHY_LPDDR4_RTT_112ohm		(17)
#define PHY_LPDDR4_RTT_101ohm		(18)
#define PHY_LPDDR4_RTT_92ohm		(19)
#define PHY_LPDDR4_RTT_84ohm		(20)
#define PHY_LPDDR4_RTT_78ohm		(21)
#define PHY_LPDDR4_RTT_72ohm		(22)
#define PHY_LPDDR4_RTT_67ohm		(23)
#define PHY_LPDDR4_RTT_63ohm		(24)
#define PHY_LPDDR4_RTT_60ohm		(25)
#define PHY_LPDDR4_RTT_56ohm		(26)
#define PHY_LPDDR4_RTT_53ohm		(27)
#define PHY_LPDDR4_RTT_51ohm		(28)
#define PHY_LPDDR4_RTT_48ohm		(29)
#define PHY_LPDDR4_RTT_46ohm		(30)
#define PHY_LPDDR4_RTT_44ohm		(31)

#endif /*_DT_BINDINGS_DRAM_ROCKCHIP_RV1126_H*/
