/*
 * (C) Copyright 2020 Rockchip Electronics Co., Ltd.
 *
 * SPDX-License-Identifier:     GPL-2.0+
 */
#ifndef _ASM_ARCH_GRF_RK3568_H
#define _ASM_ARCH_GRF_RK3568_H

#include <common.h>

struct rk3568_grf {
	unsigned int gpio1a_iomux_l;
	unsigned int gpio1a_iomux_h;
	unsigned int gpio1b_iomux_l;
	unsigned int gpio1b_iomux_h;
	unsigned int gpio1c_iomux_l;
	unsigned int gpio1c_iomux_h;
	unsigned int gpio1d_iomux_l;
	unsigned int gpio1d_iomux_h;
	unsigned int gpio2a_iomux_l;
	unsigned int gpio2a_iomux_h;
	unsigned int gpio2b_iomux_l;
	unsigned int gpio2b_iomux_h;
	unsigned int gpio2c_iomux_l;
	unsigned int gpio2c_iomux_h;
	unsigned int gpio2d_iomux_l;
	unsigned int gpio2d_iomux_h;
	unsigned int gpio3a_iomux_l;
	unsigned int gpio3a_iomux_h;
	unsigned int gpio3b_iomux_l;
	unsigned int gpio3b_iomux_h;
	unsigned int gpio3c_iomux_l;
	unsigned int gpio3c_iomux_h;
	unsigned int gpio3d_iomux_l;
	unsigned int gpio3d_iomux_h;
	unsigned int gpio4a_iomux_l;
	unsigned int gpio4a_iomux_h;
	unsigned int gpio4b_iomux_l;
	unsigned int gpio4b_iomux_h;
	unsigned int gpio4c_iomux_l;
	unsigned int gpio4c_iomux_h;
	unsigned int gpio4d_iomux_l;
	unsigned int reserved0[(0x0080 - 0x0078) / 4 - 1];
	unsigned int gpio1a_p;
	unsigned int gpio1b_p;
	unsigned int gpio1c_p;
	unsigned int gpio1d_p;
	unsigned int gpio2a_p;
	unsigned int gpio2b_p;
	unsigned int gpio2c_p;
	unsigned int gpio2d_p;
	unsigned int gpio3a_p;
	unsigned int gpio3b_p;
	unsigned int gpio3c_p;
	unsigned int gpio3d_p;
	unsigned int gpio4a_p;
	unsigned int gpio4b_p;
	unsigned int gpio4c_p;
	unsigned int gpio4d_p;
	unsigned int gpio1a_ie;
	unsigned int gpio1b_ie;
	unsigned int gpio1c_ie;
	unsigned int gpio1d_ie;
	unsigned int gpio2a_ie;
	unsigned int gpio2b_ie;
	unsigned int gpio2c_ie;
	unsigned int gpio2d_ie;
	unsigned int gpio3a_ie;
	unsigned int gpio3b_ie;
	unsigned int gpio3c_ie;
	unsigned int gpio3d_ie;
	unsigned int gpio4a_ie;
	unsigned int gpio4b_ie;
	unsigned int gpio4c_ie;
	unsigned int gpio4d_ie;
	unsigned int gpio1a_opd;
	unsigned int gpio1b_opd;
	unsigned int gpio1c_opd;
	unsigned int gpio1d_opd;
	unsigned int gpio2a_opd;
	unsigned int gpio2b_opd;
	unsigned int gpio2c_opd;
	unsigned int gpio2d_opd;
	unsigned int gpio3a_opd;
	unsigned int gpio3b_opd;
	unsigned int gpio3c_opd;
	unsigned int gpio3d_opd;
	unsigned int gpio4a_opd;
	unsigned int gpio4b_opd;
	unsigned int gpio4c_opd;
	unsigned int gpio4d_opd;
	unsigned int gpio1a_sus;
	unsigned int gpio1b_sus;
	unsigned int gpio1c_sus;
	unsigned int gpio1d_sus;
	unsigned int gpio2a_sus;
	unsigned int gpio2b_sus;
	unsigned int gpio2c_sus;
	unsigned int gpio2d_sus;
	unsigned int gpio3a_sus;
	unsigned int gpio3b_sus;
	unsigned int gpio3c_sus;
	unsigned int gpio3d_sus;
	unsigned int gpio4a_sus;
	unsigned int gpio4b_sus;
	unsigned int gpio4c_sus;
	unsigned int gpio4d_sus;
	unsigned int gpio1a_sl;
	unsigned int gpio1b_sl;
	unsigned int gpio1c_sl;
	unsigned int gpio1d_sl;
	unsigned int gpio2a_sl;
	unsigned int gpio2b_sl;
	unsigned int gpio2c_sl;
	unsigned int gpio2d_sl;
	unsigned int gpio3a_sl;
	unsigned int gpio3b_sl;
	unsigned int gpio3c_sl;
	unsigned int gpio3d_sl;
	unsigned int gpio4a_sl;
	unsigned int gpio4b_sl;
	unsigned int gpio4c_sl;
	unsigned int gpio4d_sl;
	unsigned int reserved1[(0x0200 - 0x01bc) / 4 - 1];
	unsigned int gpio1a_ds_0;
	unsigned int gpio1a_ds_1;
	unsigned int gpio1a_ds_2;
	unsigned int gpio1a_ds_3;
	unsigned int gpio1b_ds_0;
	unsigned int gpio1b_ds_1;
	unsigned int gpio1b_ds_2;
	unsigned int gpio1b_ds_3;
	unsigned int gpio1c_ds_0;
	unsigned int gpio1c_ds_1;
	unsigned int gpio1c_ds_2;
	unsigned int gpio1c_ds_3;
	unsigned int gpio1d_ds_0;
	unsigned int gpio1d_ds_1;
	unsigned int gpio1d_ds_2;
	unsigned int gpio1d_ds_3;
	unsigned int gpio2a_ds_0;
	unsigned int gpio2a_ds_1;
	unsigned int gpio2a_ds_2;
	unsigned int gpio2a_ds_3;
	unsigned int gpio2b_ds_0;
	unsigned int gpio2b_ds_1;
	unsigned int gpio2b_ds_2;
	unsigned int gpio2b_ds_3;
	unsigned int gpio2c_ds_0;
	unsigned int gpio2c_ds_1;
	unsigned int gpio2c_ds_2;
	unsigned int gpio2c_ds_3;
	unsigned int gpio2d_ds_0;
	unsigned int gpio2d_ds_1;
	unsigned int gpio2d_ds_2;
	unsigned int gpio2d_ds_3;
	unsigned int gpio3a_ds_0;
	unsigned int gpio3a_ds_1;
	unsigned int gpio3a_ds_2;
	unsigned int gpio3a_ds_3;
	unsigned int gpio3b_ds_0;
	unsigned int gpio3b_ds_1;
	unsigned int gpio3b_ds_2;
	unsigned int gpio3b_ds_3;
	unsigned int gpio3c_ds_0;
	unsigned int gpio3c_ds_1;
	unsigned int gpio3c_ds_2;
	unsigned int gpio3c_ds_3;
	unsigned int gpio3d_ds_0;
	unsigned int gpio3d_ds_1;
	unsigned int gpio3d_ds_2;
	unsigned int gpio3d_ds_3;
	unsigned int gpio4a_ds_0;
	unsigned int gpio4a_ds_1;
	unsigned int gpio4a_ds_2;
	unsigned int gpio4a_ds_3;
	unsigned int gpio4b_ds_0;
	unsigned int gpio4b_ds_1;
	unsigned int gpio4b_ds_2;
	unsigned int gpio4b_ds_3;
	unsigned int gpio4c_ds_0;
	unsigned int gpio4c_ds_1;
	unsigned int gpio4c_ds_2;
	unsigned int gpio4c_ds_3;
	unsigned int gpio4d_ds_0;
	unsigned int gpio4d_ds_1;
	unsigned int gpio4d_ds_2;
	unsigned int gpio4d_ds_3;
	unsigned int iofunc_sel0;
	unsigned int iofunc_sel1;
	unsigned int iofunc_sel2;
	unsigned int iofunc_sel3;
	unsigned int iofunc_sel4;
	unsigned int iofunc_sel5;
	unsigned int reserved2[(0x0340 - 0x0314) / 4 - 1];
	unsigned int vi_con0;
	unsigned int vi_con1;
	unsigned int vi_status0;
	unsigned int reserved3[(0x0360 - 0x0348) / 4 - 1];
	unsigned int vo_con0;
	unsigned int vo_con1;
	unsigned int vo_con2;
	unsigned int vo_con3;
	unsigned int reserved4[(0x0380 - 0x036c) / 4 - 1];
	unsigned int mac0_con0;
	unsigned int mac0_con1;
	unsigned int mac1_con0;
	unsigned int mac1_con1;
	unsigned int reserved5[(0x03a0 - 0x038c) / 4 - 1];
	unsigned int biu_con0;
	unsigned int biu_con1;
	unsigned int biu_con2;
	unsigned int reserved6[(0x03c0 - 0x03a8) / 4 - 1];
	unsigned int gic_con0;
	unsigned int gic_con1;
	unsigned int gic_con2;
	unsigned int reserved7[(0x03f0 - 0x03c8) / 4 - 1];
	unsigned int gpu_con0;
	unsigned int gpu_con1;
	unsigned int reserved8[(0x0400 - 0x03f4) / 4 - 1];
	unsigned int cpu_con0;
	unsigned int reserved9[(0x0420 - 0x0400) / 4 - 1];
	unsigned int cpu_status0;
	unsigned int reserved10[(0x0500 - 0x0420) / 4 - 1];
	unsigned int soc_con0;
	unsigned int soc_con1;
	unsigned int soc_con2;
	unsigned int soc_con3;
	unsigned int reserved11[(0x0514 - 0x050c) / 4 - 1];
	unsigned int soc_con5;
	unsigned int soc_con6;
	unsigned int reserved12[(0x0580 - 0x0518) / 4 - 1];
	unsigned int soc_status0;
	unsigned int reserved13[(0x05c0 - 0x0580) / 4 - 1];
	unsigned int ram_con;
	unsigned int core_ram_con;
	unsigned int reserved14[(0x0600 - 0x05c4) / 4 - 1];
	unsigned int tsadc_con;
	unsigned int reserved15[(0x0610 - 0x0600) / 4 - 1];
	unsigned int saradc_con;
	unsigned int reserved16[(0x0700 - 0x0610) / 4 - 1];
	unsigned int gpupvtpll_con0;
	unsigned int gpupvtpll_con1;
	unsigned int gpupvtpll_con2;
	unsigned int gpupvtpll_con3;
	unsigned int reserved17[(0x0740 - 0x070c) / 4 - 1];
	unsigned int npupvtpll_con0;
	unsigned int npupvtpll_con1;
	unsigned int npupvtpll_con2;
	unsigned int npupvtpll_con3;
	unsigned int reserved18[(0x0800 - 0x074c) / 4 - 1];
	unsigned int chip_id;
	unsigned int reserved19[(0x0840 - 0x0800) / 4 - 1];
	unsigned int gpio1c5_ds;
	unsigned int gpio2a2_ds;
	unsigned int gpio2b0_ds;
	unsigned int gpio3a0_ds;
	unsigned int gpio3a6_ds;
	unsigned int gpio4a0_ds;
	unsigned int reserved20[(0x0900 - 0x0854) / 4 - 1];
	unsigned int dmac0_con0;
	unsigned int dmac0_con1;
	unsigned int dmac0_con2;
	unsigned int dmac0_con3;
	unsigned int dmac0_con4;
	unsigned int dmac0_con5;
	unsigned int dmac0_con6;
	unsigned int dmac0_con7;
	unsigned int dmac0_con8;
	unsigned int dmac0_con9;
	unsigned int reserved21[(0x0940 - 0x0924) / 4 - 1];
	unsigned int dmac1_con0;
	unsigned int dmac1_con1;
	unsigned int dmac1_con2;
	unsigned int dmac1_con3;
	unsigned int dmac1_con4;
	unsigned int dmac1_con5;
	unsigned int dmac1_con6;
	unsigned int dmac1_con7;
	unsigned int dmac1_con8;
	unsigned int dmac1_con9;
};

check_member(rk3568_grf, dmac1_con9, 0x0964);

struct rk3568_pmugrf {
	unsigned int pmu_gpio0a_iomux_l;
	unsigned int pmu_gpio0a_iomux_h;
	unsigned int pmu_gpio0b_iomux_l;
	unsigned int pmu_gpio0b_iomux_h;
	unsigned int pmu_gpio0c_iomux_l;
	unsigned int pmu_gpio0c_iomux_h;
	unsigned int pmu_gpio0d_iomux_l;
	unsigned int reserved0[(0x0020 - 0x0018) / 4 - 1];
	unsigned int pmu_gpio0a_p;
	unsigned int pmu_gpio0b_p;
	unsigned int pmu_gpio0c_p;
	unsigned int pmu_gpio0d_p;
	unsigned int pmu_gpio0a_ie;
	unsigned int pmu_gpio0b_ie;
	unsigned int pmu_gpio0c_ie;
	unsigned int pmu_gpio0d_ie;
	unsigned int pmu_gpio0a_opd;
	unsigned int pmu_gpio0b_opd;
	unsigned int pmu_gpio0c_opd;
	unsigned int pmu_gpio0d_opd;
	unsigned int pmu_gpio0a_sus;
	unsigned int pmu_gpio0b_sus;
	unsigned int pmu_gpio0c_sus;
	unsigned int pmu_gpio0d_sus;
	unsigned int pmu_gpio0a_sl;
	unsigned int pmu_gpio0b_sl;
	unsigned int pmu_gpio0c_sl;
	unsigned int pmu_gpio0d_sl;
	unsigned int pmu_gpio0a_ds_0;
	unsigned int pmu_gpio0a_ds_1;
	unsigned int pmu_gpio0a_ds_2;
	unsigned int pmu_gpio0a_ds_3;
	unsigned int pmu_gpio0b_ds_0;
	unsigned int pmu_gpio0b_ds_1;
	unsigned int pmu_gpio0b_ds_2;
	unsigned int pmu_gpio0b_ds_3;
	unsigned int pmu_gpio0c_ds_0;
	unsigned int pmu_gpio0c_ds_1;
	unsigned int pmu_gpio0c_ds_2;
	unsigned int pmu_gpio0c_ds_3;
	unsigned int pmu_gpio0d_ds_0;
	unsigned int pmu_gpio0d_ds_1;
	unsigned int pmu_gpio0d_ds_2;
	unsigned int pmu_gpio0d_ds_3;
	unsigned int reserved1[(0x0100 - 0x00ac) / 4 - 1];
	unsigned int pmu_soc_con0;
	unsigned int pmu_soc_con1;
	unsigned int pmu_soc_con2;
	unsigned int pmu_soc_con3;
	unsigned int pmu_soc_con4;
	unsigned int pmu_soc_con5;
	unsigned int reserved2[(0x0124 - 0x0114) / 4 - 1];
	unsigned int pmu_io_vsel0;
	unsigned int pmu_io_vsel1;
	unsigned int pmu_io_vsel2;
	unsigned int reserved3[(0x0180 - 0x012c) / 4 - 1];
	unsigned int pmu_dll_con0;
	unsigned int reserved4[(0x0200 - 0x0180) / 4 - 1];
	unsigned int pmu_os_reg0;
	unsigned int pmu_os_reg1;
	unsigned int pmu_os_reg2;
	unsigned int pmu_os_reg3;
	unsigned int pmu_os_reg4;
	unsigned int pmu_os_reg5;
	unsigned int pmu_os_reg6;
	unsigned int pmu_os_reg7;
	unsigned int pmu_os_reg8;
	unsigned int pmu_os_reg9;
	unsigned int pmu_os_reg10;
	unsigned int pmu_os_reg11;
	unsigned int pmu_reset_function_status;
	unsigned int pmu_reset_function_clr;
	unsigned int reserved5[(0x0380 - 0x0234) / 4 - 1];
	unsigned int pmu_sig_detect_con;
	unsigned int reserved6[(0x0390 - 0x0380) / 4 - 1];
	unsigned int pmu_sig_detect_status;
	unsigned int reserved7[(0x03a0 - 0x0390) / 4 - 1];
	unsigned int pmu_sig_detect_status_clear;
	unsigned int reserved8[(0x03b0 - 0x03a0) / 4 - 1];
	unsigned int pmu_sdmmc_det_counter;
};

check_member(rk3568_pmugrf, pmu_sdmmc_det_counter, 0x03b0);

struct rk3568_ddrgrf {
	unsigned int ddr_con0;
	unsigned int ddr_con1;
	unsigned int ddr_con2;
	unsigned int ddr_con3;
	unsigned int ddr_con4;
	unsigned int ddr_split_con;
	unsigned int reserved0[(0x0020 - 0x0014) / 4 - 1];
	unsigned int ddr_lp_con;
	unsigned int reserved1[(0x0100 - 0x0020) / 4 - 1];
	unsigned int ddr_status0;
	unsigned int ddr_status1;
	unsigned int ddr_status2;
	unsigned int ddr_status3;
	unsigned int ddr_status4;
	unsigned int ddr_status5;
	unsigned int ddr_status6;
	unsigned int ddr_status7;
	unsigned int ddr_status8;
	unsigned int ddr_status9;
	unsigned int reserved2[(0x0130 - 0x0124) / 4 - 1];
	unsigned int ddr_status10;
	unsigned int ddr_status11;
	unsigned int ddr_status12;
};

check_member(rk3568_ddrgrf, ddr_status12, 0x0138);

#endif
