/*
 * Copyright (c) 2017 Paweł Jarosz <paweljarosz3691@gmail.com>
 *
 * SPDX-License-Identifier:	GPL-2.0
 */

#ifndef _ASM_ARCH_GRF_RK3066_H
#define _ASM_ARCH_GRF_RK3066_H

struct rk3066_grf_gpio_lh {
	u32 l;
	u32 h;
};

struct rk3066_grf {
	struct rk3066_grf_gpio_lh gpio_dir[7];
	struct rk3066_grf_gpio_lh gpio_do[7];
	struct rk3066_grf_gpio_lh gpio_en[7];

	u32 gpio0a_iomux;
	u32 gpio0b_iomux;
	u32 gpio0c_iomux;
	u32 gpio0d_iomux;

	u32 gpio1a_iomux;
	u32 gpio1b_iomux;
	u32 gpio1c_iomux;
	u32 gpio1d_iomux;

	u32 gpio2a_iomux;
	u32 gpio2b_iomux;
	u32 gpio2c_iomux;
	u32 gpio2d_iomux;

	u32 gpio3a_iomux;
	u32 gpio3b_iomux;
	u32 gpio3c_iomux;
	u32 gpio3d_iomux;

	u32 gpio4a_iomux;
	u32 gpio4b_iomux;
	u32 gpio4c_iomux;
	u32 gpio4d_iomux;

	u32 reserved0[5];

	u32 gpio6b_iomux;

	u32 reserved1[2];

	struct rk3066_grf_gpio_lh gpio_pull[7];

	u32 soc_con0;
	u32 soc_con1;
	u32 soc_con2;

	u32 soc_status0;

	u32 dmac1_con[3];
	u32 dmac2_con[4];

	u32 uoc0_con[3];
	u32 uoc1_con[4];
	u32 ddrc_con;
	u32 ddrc_stat;

	u32 reserved2[10];

	u32 os_reg[4];
};
check_member(rk3066_grf, os_reg[3], 0x01d4);

/* GRF_GPIO0A_IOMUX */
enum {
	GPIO0A6_SHIFT		= 12,
	GPIO0A6_MASK		= 1 << GPIO0A6_SHIFT,
	GPIO0A6_GPIO		= 0,
	GPIO0A6_HOST_DRV_VBUS,

	GPIO0A5_SHIFT		= 10,
	GPIO0A5_MASK		= 1 << GPIO0A5_SHIFT,
	GPIO0A5_GPIO		= 0,
	GPIO0A5_OTG_DRV_VBUS,

	GPIO0A4_SHIFT		= 8,
	GPIO0A4_MASK		= 1 << GPIO0A4_SHIFT,
	GPIO0A4_GPIO		= 0,
	GPIO0A4_PWM1,

	GPIO0A3_SHIFT		= 6,
	GPIO0A3_MASK		= 1 << GPIO0A3_SHIFT,
	GPIO0A3_GPIO		= 0,
	GPIO0A3_PWM0
};

/* GRF_GPIO0D_IOMUX */
enum {
	GPIO0D7_SHIFT		= 14,
	GPIO0D7_MASK		= 1 << GPIO0D7_SHIFT,
	GPIO0D7_GPIO		= 0,
	GPIO0D7_PWM3,

	GPIO0D6_SHIFT		= 12,
	GPIO0D6_MASK		= 1 << GPIO0D6_SHIFT,
	GPIO0D6_GPIO		= 0,
	GPIO0D6_PWM2
};

/* GRF_GPIO1A_IOMUX */
enum {
	GPIO1A7_SHIFT		= 14,
	GPIO1A7_MASK		= 3 << GPIO1A7_SHIFT,
	GPIO1A7_GPIO		= 0,
	GPIO1A7_UART1_RTS_N,
	GPIO1A7_SPI0_TXD,

	GPIO1A6_SHIFT		= 12,
	GPIO1A6_MASK		= 3 << GPIO1A6_SHIFT,
	GPIO1A6_GPIO		= 0,
	GPIO1A6_UART1_CTS_N,
	GPIO1A6_SPI0_RXD,

	GPIO1A5_SHIFT		= 10,
	GPIO1A5_MASK		= 3 << GPIO1A5_SHIFT,
	GPIO1A5_GPIO		= 0,
	GPIO1A5_UART1_SOUT,
	GPIO1A5_SPI0_CLK,

	GPIO1A4_SHIFT		= 8,
	GPIO1A4_MASK		= 3 << GPIO1A4_SHIFT,
	GPIO1A4_GPIO		= 0,
	GPIO1A4_UART1_SIN,
	GPIO1A4_SPI0_CSN0,

	GPIO1A3_SHIFT		= 6,
	GPIO1A3_MASK		= 1 << GPIO1A3_SHIFT,
	GPIO1A3_GPIO		= 0,
	GPIO1A3_UART0_RTS_N,

	GPIO1A2_SHIFT		= 4,
	GPIO1A2_MASK		= 1 << GPIO1A2_SHIFT,
	GPIO1A2_GPIO		= 0,
	GPIO1A2_UART0_CTS_N,

	GPIO1A1_SHIFT		= 2,
	GPIO1A1_MASK		= 1 << GPIO1A1_SHIFT,
	GPIO1A1_GPIO		= 0,
	GPIO1A1_UART0_SOUT,

	GPIO1A0_SHIFT		= 0,
	GPIO1A0_MASK		= 1 << GPIO1A0_SHIFT,
	GPIO1A0_GPIO		= 0,
	GPIO1A0_UART0_SIN
};

/* GRF_GPIO1B_IOMUX */
enum {
	GPIO1B1_SHIFT		= 2,
	GPIO1B1_MASK		= 1 << GPIO1B1_SHIFT,
	GPIO1B1_GPIO		= 0,
	GPIO1B1_UART2_SOUT,

	GPIO1B0_SHIFT		= 0,
	GPIO1B0_MASK		= 1 << GPIO1B0_SHIFT,
	GPIO1B0_GPIO		= 0,
	GPIO1B0_UART2_SIN
};

/* GRF_GPIO2C_IOMUX */
enum {
	GPIO2C7_SHIFT		= 14,
	GPIO2C7_MASK		= 3 << GPIO2C7_SHIFT,
	GPIO2C7_GPIO		= 0,
	GPIO2C7_LCDC1_DATA23,
	GPIO2C7_SPI1_CSN1,
	GPIO2C7_HSADC_DATA4,

	GPIO2C6_SHIFT		= 12,
	GPIO2C6_MASK		= 3 << GPIO2C6_SHIFT,
	GPIO2C6_GPIO		= 0,
	GPIO2C6_LCDC1_DATA22,
	GPIO2C6_SPI1_RXD,
	GPIO2C6_HSADC_DATA3,

	GPIO2C5_SHIFT		= 10,
	GPIO2C5_MASK		= 3 << GPIO2C5_SHIFT,
	GPIO2C5_GPIO		= 0,
	GPIO2C5_LCDC1_DATA21,
	GPIO2C5_SPI1_TXD,
	GPIO2C5_HSADC_DATA2,

	GPIO2C4_SHIFT		= 8,
	GPIO2C4_MASK		= 3 << GPIO2C4_SHIFT,
	GPIO2C4_GPIO		= 0,
	GPIO2C4_LCDC1_DATA20,
	GPIO2C4_SPI1_CSN0,
	GPIO2C4_HSADC_DATA1,

	GPIO2C3_SHIFT		= 6,
	GPIO2C3_MASK		= 3 << GPIO2C3_SHIFT,
	GPIO2C3_GPIO		= 0,
	GPIO2C3_LCDC1_DATA19,
	GPIO2C3_SPI1_CLK,
	GPIO2C3_HSADC_DATA0
};

/* GRF_GPIO2D_IOMUX */
enum {
	GPIO2D7_SHIFT		= 14,
	GPIO2D7_MASK		= 1 << GPIO2D7_SHIFT,
	GPIO2D7_GPIO		= 0,
	GPIO2D7_I2C1_SCL,

	GPIO2D6_SHIFT		= 12,
	GPIO2D6_MASK		= 1 << GPIO2D6_SHIFT,
	GPIO2D6_GPIO		= 0,
	GPIO2D6_I2C1_SDA,

	GPIO2D5_SHIFT		= 10,
	GPIO2D5_MASK		= 1 << GPIO2D5_SHIFT,
	GPIO2D5_GPIO		= 0,
	GPIO2D5_I2C0_SCL,

	GPIO2D4_SHIFT		= 8,
	GPIO2D4_MASK		= 1 << GPIO2D4_SHIFT,
	GPIO2D4_GPIO		= 0,
	GPIO2D4_I2C0_SDA

};

/* GRF_GPIO3A_IOMUX */
enum {
	GPIO3A7_SHIFT		= 14,
	GPIO3A7_MASK		= 1 << GPIO3A7_SHIFT,
	GPIO3A7_GPIO		= 0,
	GPIO3A7_SDMMC0_WRITE_PRT,

	GPIO3A6_SHIFT		= 12,
	GPIO3A6_MASK		= 1 << GPIO3A6_SHIFT,
	GPIO3A6_GPIO		= 0,
	GPIO3A6_SDMMC0_RSTN_OUT,

	GPIO3A5_SHIFT		= 10,
	GPIO3A5_MASK		= 1 << GPIO3A5_SHIFT,
	GPIO3A5_GPIO		= 0,
	GPIO3A5_I2C4_SCL,

	GPIO3A4_SHIFT		= 8,
	GPIO3A4_MASK		= 1 << GPIO3A4_SHIFT,
	GPIO3A4_GPIO		= 0,
	GPIO3A4_I2C4_SDA,

	GPIO3A3_SHIFT		= 6,
	GPIO3A3_MASK		= 1 << GPIO3A3_SHIFT,
	GPIO3A3_GPIO		= 0,
	GPIO3A3_I2C3_SCL,

	GPIO3A2_SHIFT		= 4,
	GPIO3A2_MASK		= 1 << GPIO3A2_SHIFT,
	GPIO3A2_GPIO		= 0,
	GPIO3A2_I2C3_SDA,

	GPIO3A1_SHIFT		= 2,
	GPIO3A1_MASK		= 1 << GPIO3A1_SHIFT,
	GPIO3A1_GPIO		= 0,
	GPIO3A1_I2C2_SCL,

	GPIO3A0_SHIFT		= 0,
	GPIO3A0_MASK		= 1 << GPIO3A0_SHIFT,
	GPIO3A0_GPIO		= 0,
	GPIO3A0_I2C2_SDA,
};

/* GRF_GPIO3B_IOMUX */
enum {
	GPIO3B7_SHIFT		= 14,
	GPIO3B7_MASK		= 1 << GPIO3B7_SHIFT,
	GPIO3B7_GPIO		= 0,
	GPIO3B7_SDMMC0_WRITE_PRT,

	GPIO3B6_SHIFT		= 12,
	GPIO3B6_MASK		= 1 << GPIO3B6_SHIFT,
	GPIO3B6_GPIO		= 0,
	GPIO3B6_SDMMC0_DETECT_N,

	GPIO3B5_SHIFT		= 10,
	GPIO3B5_MASK		= 1 << GPIO3B5_SHIFT,
	GPIO3B5_GPIO		= 0,
	GPIO3B5_SDMMC0_DATA3,

	GPIO3B4_SHIFT		= 8,
	GPIO3B4_MASK		= 1 << GPIO3B4_SHIFT,
	GPIO3B4_GPIO		= 0,
	GPIO3B4_SDMMC0_DATA2,

	GPIO3B3_SHIFT		= 6,
	GPIO3B3_MASK		= 1 << GPIO3B3_SHIFT,
	GPIO3B3_GPIO		= 0,
	GPIO3B3_SDMMC0_DATA1,

	GPIO3B2_SHIFT		= 4,
	GPIO3B2_MASK		= 1 << GPIO3B2_SHIFT,
	GPIO3B2_GPIO		= 0,
	GPIO3B2_SDMMC0_DATA0,

	GPIO3B1_SHIFT		= 2,
	GPIO3B1_MASK		= 1 << GPIO3B1_SHIFT,
	GPIO3B1_GPIO		= 0,
	GPIO3B1_SDMMC0_CMD,

	GPIO3B0_SHIFT		= 0,
	GPIO3B0_MASK		= 1 << GPIO3B0_SHIFT,
	GPIO3B0_GPIO		= 0,
	GPIO3B0_SDMMC0_CLKOUT

};

/* GRF_GPIO3C_IOMUX */
enum {
	GPIO3C7_SHIFT		= 14,
	GPIO3C7_MASK		= 1 << GPIO3C7_SHIFT,
	GPIO3C7_GPIO		= 0,
	GPIO3C7_SDMMC1_WRITE_PRT,

	GPIO3C6_SHIFT		= 12,
	GPIO3C6_MASK		= 1 << GPIO3C6_SHIFT,
	GPIO3C6_GPIO		= 0,
	GPIO3C6_SDMMC1_DETECT_N,

	GPIO3C5_SHIFT		= 10,
	GPIO3C5_MASK		= 1 << GPIO3C5_SHIFT,
	GPIO3C5_GPIO		= 0,
	GPIO3C5_SDMMC1_CLKOUT,

	GPIO3C4_SHIFT		= 8,
	GPIO3C4_MASK		= 1 << GPIO3C4_SHIFT,
	GPIO3C4_GPIO		= 0,
	GPIO3C4_SDMMC1_DATA3,

	GPIO3C3_SHIFT		= 6,
	GPIO3C3_MASK		= 1 << GPIO3C3_SHIFT,
	GPIO3C3_GPIO		= 0,
	GPIO3C3_SDMMC1_DATA2,

	GPIO3C2_SHIFT		= 4,
	GPIO3C2_MASK		= 1 << GPIO3C2_SHIFT,
	GPIO3C2_GPIO		= 0,
	GPIO3C2_SDMMC1_DATA1,

	GPIO3C1_SHIFT		= 2,
	GPIO3C1_MASK		= 1 << GPIO3C1_SHIFT,
	GPIO3C1_GPIO		= 0,
	GPIO3C1_SDMMC1_DATA0,

	GPIO3C0_SHIFT		= 0,
	GPIO3C0_MASK		= 1 << GPIO3C0_SHIFT,
	GPIO3C0_GPIO		= 0,
	GPIO3C0_SMMC1_CMD
};

/* GRF_GPIO3D_IOMUX */
enum {
	GPIO3D7_SHIFT		= 14,
	GPIO3D7_MASK		= 3 << GPIO3D7_SHIFT,
	GPIO3D7_GPIO		= 0,
	GPIO3D7_FLASH_DQS,
	GPIO3D7_EMMC_CLKOUT,

	GPIO3D6_SHIFT		= 12,
	GPIO3D6_MASK		= 1 << GPIO3D6_SHIFT,
	GPIO3D6_GPIO		= 0,
	GPIO3D6_UART3_RTS_N,

	GPIO3D5_SHIFT		= 10,
	GPIO3D5_MASK		= 1 << GPIO3D5_SHIFT,
	GPIO3D5_GPIO		= 0,
	GPIO3D5_UART3_CTS_N,

	GPIO3D4_SHIFT		= 8,
	GPIO3D4_MASK		= 1 << GPIO3D4_SHIFT,
	GPIO3D4_GPIO		= 0,
	GPIO3D4_UART3_SOUT,

	GPIO3D3_SHIFT		= 6,
	GPIO3D3_MASK		= 1 << GPIO3D3_SHIFT,
	GPIO3D3_GPIO		= 0,
	GPIO3D3_UART3_SIN,

	GPIO3D2_SHIFT		= 4,
	GPIO3D2_MASK		= 1 << GPIO3D2_SHIFT,
	GPIO3D2_GPIO		= 0,
	GPIO3D2_SDMMC1_INT_N,

	GPIO3D1_SHIFT		= 2,
	GPIO3D1_MASK		= 1 << GPIO3D1_SHIFT,
	GPIO3D1_GPIO		= 0,
	GPIO3D1_SDMMC1_BACKEND_PWR,

	GPIO3D0_SHIFT		= 0,
	GPIO3D0_MASK		= 1 << GPIO3D0_SHIFT,
	GPIO3D0_GPIO		= 0,
	GPIO3D0_SDMMC1_PWR_EN

};

/* GRF_GPIO4A_IOMUX */
enum {
	GPIO4A7_SHIFT		= 14,
	GPIO4A7_MASK		= 1 << GPIO4A7_SHIFT,
	GPIO4A7_GPIO		= 0,
	GPIO4A7_FLASH_DATA15,

	GPIO4A6_SHIFT		= 12,
	GPIO4A6_MASK		= 1 << GPIO4A6_SHIFT,
	GPIO4A6_GPIO		= 0,
	GPIO4A6_FLASH_DATA14,

	GPIO4A5_SHIFT		= 10,
	GPIO4A5_MASK		= 1 << GPIO4A5_SHIFT,
	GPIO4A5_GPIO		= 0,
	GPIO4A5_FLASH_DATA13,

	GPIO4A4_SHIFT		= 8,
	GPIO4A4_MASK		= 1 << GPIO4A4_SHIFT,
	GPIO4A4_GPIO		= 0,
	GPIO4A4_FLASH_DATA12,

	GPIO4A3_SHIFT		= 6,
	GPIO4A3_MASK		= 1 << GPIO4A3_SHIFT,
	GPIO4A3_GPIO		= 0,
	GPIO4A3_FLASH_DATA11,

	GPIO4A2_SHIFT		= 4,
	GPIO4A2_MASK		= 1 << GPIO4A2_SHIFT,
	GPIO4A2_GPIO		= 0,
	GPIO4A2_FLASH_DATA10,

	GPIO4A1_SHIFT		= 2,
	GPIO4A1_MASK		= 1 << GPIO4A1_SHIFT,
	GPIO4A1_GPIO		= 0,
	GPIO4A1_FLASH_DATA9,

	GPIO4A0_SHIFT		= 0,
	GPIO4A0_MASK		= 1 << GPIO4A0_SHIFT,
	GPIO4A0_GPIO		= 0,
	GPIO4A0_FLASH_DATA8

};

/* GRF_GPIO4B_IOMUX */
enum {
	GPIO4B7_SHIFT		= 14,
	GPIO4B7_MASK		= 1 << GPIO4B7_SHIFT,
	GPIO4B7_GPIO		= 0,
	GPIO4B7_SPI0_CSN1,

	GPIO4B6_SHIFT		= 12,
	GPIO4B6_MASK		= 1 << GPIO4B6_SHIFT,
	GPIO4B6_GPIO		= 0,
	GPIO4B6_FLASH_CSN7,

	GPIO4B5_SHIFT		= 10,
	GPIO4B5_MASK		= 1 << GPIO4B5_SHIFT,
	GPIO4B5_GPIO		= 0,
	GPIO4B5_FLASH_CSN6,

	GPIO4B4_SHIFT		= 8,
	GPIO4B4_MASK		= 1 << GPIO4B4_SHIFT,
	GPIO4B4_GPIO		= 0,
	GPIO4B4_FLASH_CSN5,

	GPIO4B3_SHIFT		= 6,
	GPIO4B3_MASK		= 1 << GPIO4B3_SHIFT,
	GPIO4B3_GPIO		= 0,
	GPIO4B3_FLASH_CSN4,

	GPIO4B2_SHIFT		= 4,
	GPIO4B2_MASK		= 3 << GPIO4B2_SHIFT,
	GPIO4B2_GPIO		= 0,
	GPIO4B2_FLASH_CSN3,
	GPIO4B2_EMMC_RSTN_OUT,

	GPIO4B1_SHIFT		= 2,
	GPIO4B1_MASK		= 3 << GPIO4B1_SHIFT,
	GPIO4B1_GPIO		= 0,
	GPIO4B1_FLASH_CSN2,
	GPIO4B1_EMMC_CMD,

	GPIO4B0_SHIFT		= 0,
	GPIO4B0_MASK		= 1 << GPIO4B0_SHIFT,
	GPIO4B0_GPIO		= 0,
	GPIO4B0_FLASH_CSN1
};

/* GRF_SOC_CON0 */
enum {
	SMC_MUX_CON_SHIFT	= 13,
	SMC_MUX_CON_MASK	= 1 << SMC_MUX_CON_SHIFT,

	NOC_REMAP_SHIFT		= 12,
	NOC_REMAP_MASK		= 1 << NOC_REMAP_SHIFT,

	EMMC_FLASH_SEL_SHIFT	= 11,
	EMMC_FLASH_SEL_MASK	= 1 << EMMC_FLASH_SEL_SHIFT,

	TZPC_REVISION_SHIFT	= 7,
	TZPC_REVISION_MASK	= 0xf << TZPC_REVISION_SHIFT,

	L2CACHE_ACC_SHIFT	= 5,
	L2CACHE_ACC_MASK	= 3 << L2CACHE_ACC_SHIFT,

	L2RD_WAIT_SHIFT		= 3,
	L2RD_WAIT_MASK		= 3 << L2RD_WAIT_SHIFT,

	IMEMRD_WAIT_SHIFT	= 1,
	IMEMRD_WAIT_MASK	= 3 << IMEMRD_WAIT_SHIFT,
	
	SOC_REMAP_SHIFT		= 0,
	SOC_REMAP_MASK		= 1 << SOC_REMAP_SHIFT,
};

/* GRF_SOC_CON1 */
enum {
	RKI2C4_SEL_SHIFT	= 15,
	RKI2C4_SEL_MASK		= 1 << RKI2C4_SEL_SHIFT,

	RKI2C3_SEL_SHIFT	= 14,
	RKI2C3_SEL_MASK		= 1 << RKI2C3_SEL_SHIFT,

	RKI2C2_SEL_SHIFT	= 13,
	RKI2C2_SEL_MASK		= 1 << RKI2C2_SEL_SHIFT,

	RKI2C1_SEL_SHIFT	= 12,
	RKI2C1_SEL_MASK		= 1 << RKI2C1_SEL_SHIFT,

	RKI2C0_SEL_SHIFT	= 11,
	RKI2C0_SEL_MASK		= 1 << RKI2C0_SEL_SHIFT,

	VCODEC_SEL_SHIFT	= 10,
	VCODEC_SEL_MASK		= 1 << VCODEC_SEL_SHIFT,

	PERI_EMEM_PAUSE_SHIFT	= 9,
	PERI_EMEM_PAUSE_MASK	= 1 << PERI_EMEM_PAUSE_SHIFT,

	PERI_USB_PAUSE_SHIFT	= 8,
	PERI_USB_PAUSE_MASK	= 1 << PERI_USB_PAUSE_SHIFT,

	SMC_MUX_MODE_0_SHIFT	= 6,
	SMC_MUX_MODE_0_MASK	= 1 << SMC_MUX_MODE_0_SHIFT,

	SMC_SRAM_MW_0_SHIFT	= 4,
	SMC_SRAM_MW_0_MASK	= 3 << SMC_SRAM_MW_0_SHIFT,

	SMC_REMAP_0_SHIFT	= 3,
	SMC_REMAP_0_MASK	= 1 << SMC_REMAP_0_SHIFT,

	SMC_A_GT_M0_SYNC_SHIFT	= 2,
	SMC_A_GT_M0_SYNC_MASK	= 1 << SMC_A_GT_M0_SYNC_SHIFT,

	EMAC_SPEED_SHIFT	= 1,
	EMAC_SPEEC_MASK		= 1 << EMAC_SPEED_SHIFT,

	EMAC_MODE_SHIFT		= 0,
	EMAC_MODE_MASK		= 1 << EMAC_MODE_SHIFT,
};

/* GRF_SOC_CON2 */
enum {

	MSCH4_MAINDDR3_SHIFT	= 7,
	MSCH4_MAINDDR3_MASK	= 1 << MSCH4_MAINDDR3_SHIFT,
	MSCH4_MAINDDR3_DDR3	= 1,

	EMAC_NEWRCV_EN_SHIFT	= 6,
	EMAC_NEWRCV_EN_MASK	= 1 << EMAC_NEWRCV_EN_SHIFT,

	SW_ADDR15_EN_SHIFT	= 5,
	SW_ADDR15_EN_MASK	= 1 << SW_ADDR15_EN_SHIFT,

	SW_ADDR16_EN_SHIFT	= 4,
	SW_ADDR16_EN_MASK	= 1 << SW_ADDR16_EN_SHIFT,

	SW_ADDR17_EN_SHIFT	= 3,
	SW_ADDR17_EN_MASK	= 1 << SW_ADDR17_EN_SHIFT,

	BANK2_TO_RANK_EN_SHIFT	= 2,
	BANK2_TO_RANK_EN_MASK	= 1 << BANK2_TO_RANK_EN_SHIFT,

	RANK_TO_ROW15_EN_SHIFT	= 1,
	RANK_TO_ROW15_EN_MASK	= 1 << RANK_TO_ROW15_EN_SHIFT,

	UPCTL_C_ACTIVE_IN_SHIFT = 0,
	UPCTL_C_ACTIVE_IN_MASK	= 1 << UPCTL_C_ACTIVE_IN_SHIFT,
	UPCTL_C_ACTIVE_IN_MAY	= 0,
	UPCTL_C_ACTIVE_IN_WILL,
};

/* GRF_DDRC_CON0 */
enum {
	DTO_LB_SHIFT		= 11,
	DTO_LB_MASK		= 3 << DTO_LB_SHIFT,

	DTO_TE_SHIFT		= 9,
	DTO_TE_MASK		= 3 << DTO_TE_SHIFT,

	DTO_PDR_SHIFT		= 7,
	DTO_PDR_MASK		= 3 << DTO_PDR_SHIFT,

	DTO_PDD_SHIFT		= 5,
	DTO_PDD_MASK		= 3 << DTO_PDD_SHIFT,

	DTO_IOM_SHIFT		= 3,
	DTO_IOM_MASK		= 3 << DTO_IOM_SHIFT,

	DTO_OE_SHIFT		= 1,
	DTO_OE_MASK		= 3 << DTO_OE_SHIFT,

	ATO_AE_SHIFT		= 0,
	ATO_AE_MASK		= 1 << ATO_AE_SHIFT,
};
#endif
