/*
 * (C) Copyright 2018 Rockchip Electronics Co., Ltd.
 *
 * SPDX-License-Identifier:     GPL-2.0+
 */
#ifndef _ASM_ARCH_CRU_RK3308_H
#define _ASM_ARCH_CRU_RK3308_H

#include <common.h>

#define MHz		1000000
#define OSC_HZ		(24 * MHz)

#define APLL_HZ		(816 * MHz)

#define CORE_ACLK_HZ	408000000
#define CORE_DBG_HZ	204000000

#define BUS_ACLK_HZ	200000000
#define BUS_HCLK_HZ	100000000
#define BUS_PCLK_HZ	100000000

#define PERI_ACLK_HZ	200000000
#define PERI_HCLK_HZ	100000000
#define PERI_PCLK_HZ	100000000

#define AUDIO_HCLK_HZ	100000000
#define AUDIO_PCLK_HZ	100000000

#define RK3308_PLL_CON(x)	((x) * 0x4)
#define RK3308_MODE_CON		0xa0

/* RK3308 pll id */
enum rk3308_pll_id {
	APLL,
	DPLL,
	VPLL0,
	VPLL1,
	PLL_COUNT,
};

struct rk3308_clk_info {
	unsigned long id;
	char *name;
};

/* Private data for the clock driver - used by rockchip_get_cru() */
struct rk3308_clk_priv {
	struct rk3308_cru *cru;
	ulong armclk_hz;
	ulong dpll_hz;
	ulong vpll0_hz;
	ulong vpll1_hz;
	ulong armclk_enter_hz;
	ulong armclk_init_hz;
	bool sync_kernel;
	bool set_armclk_rate;
};

struct rk3308_cru {
	struct rk3308_pll {
		unsigned int con0;
		unsigned int con1;
		unsigned int con2;
		unsigned int con3;
		unsigned int con4;
		unsigned int reserved0[3];
	} pll[4];
	unsigned int reserved1[8];
	unsigned int mode;
	unsigned int misc;
	unsigned int reserved2[2];
	unsigned int glb_cnt_th;
	unsigned int glb_rst_st;
	unsigned int glb_srst_fst;
	unsigned int glb_srst_snd;
	unsigned int glb_rst_con;
	unsigned int pll_lock;
	unsigned int reserved3[6];
	unsigned int hwffc_con0;
	unsigned int reserved4;
	unsigned int hwffc_th;
	unsigned int hwffc_intst;
	unsigned int apll_con0_s;
	unsigned int apll_con1_s;
	unsigned int clksel_con0_s;
	unsigned int reserved5;
	unsigned int clksel_con[74];
	unsigned int reserved6[54];
	unsigned int clkgate_con[15];
	unsigned int reserved7[(0x380 - 0x338) / 4 - 1];
	unsigned int ssgtbl[32];
	unsigned int softrst_con[10];
	unsigned int reserved8[(0x480 - 0x424) / 4 - 1];
	unsigned int sdmmc_con[2];
	unsigned int sdio_con[2];
	unsigned int emmc_con[2];
};

enum {
	/* PLLCON0*/
	PLL_BP_SHIFT		= 15,
	PLL_POSTDIV1_SHIFT	= 12,
	PLL_POSTDIV1_MASK	= 7 << PLL_POSTDIV1_SHIFT,
	PLL_FBDIV_SHIFT		= 0,
	PLL_FBDIV_MASK		= 0xfff,

	/* PLLCON1 */
	PLL_PDSEL_SHIFT		= 15,
	PLL_PD1_SHIFT		= 14,
	PLL_PD_SHIFT		= 13,
	PLL_PD_MASK		= 1 << PLL_PD_SHIFT,
	PLLPD0_POWER_DOWN	= 1,
	PLLPD0_NO_POWER_DOWN	= 0,
	PLL_DSMPD_SHIFT		= 12,
	PLL_DSMPD_MASK		= 1 << PLL_DSMPD_SHIFT,
	PLL_LOCK_STATUS_SHIFT	= 10,
	PLL_LOCK_STATUS_MASK	= 1 << PLL_LOCK_STATUS_SHIFT,
	PLL_POSTDIV2_SHIFT	= 6,
	PLL_POSTDIV2_MASK	= 7 << PLL_POSTDIV2_SHIFT,
	PLL_REFDIV_SHIFT	= 0,
	PLL_REFDIV_MASK		= 0x3f,

	/* PLLCON2 */
	PLL_FOUT4PHASEPD_SHIFT	= 27,
	PLL_FOUTVCOPD_SHIFT	= 26,
	PLL_FOUTPOSTDIVPD_SHIFT	= 25,
	PLL_DACPD_SHIFT		= 24,
	PLL_FRAC_DIV	= 0xffffff,

	/* CRU_MODE */
	PLLMUX_FROM_XIN24M	= 0,
	PLLMUX_FROM_PLL,
	PLLMUX_FROM_RTC32K,
	USBPHY480M_MODE_SHIFT	= 8,
	USBPHY480M_MODE_MASK	= 3 << USBPHY480M_MODE_SHIFT,
	VPLL1_MODE_SHIFT		= 6,
	VPLL1_MODE_MASK		= 3 << VPLL1_MODE_SHIFT,
	VPLL0_MODE_SHIFT		= 4,
	VPLL0_MODE_MASK		= 3 << VPLL0_MODE_SHIFT,
	DPLL_MODE_SHIFT		= 2,
	DPLL_MODE_MASK		= 3 << DPLL_MODE_SHIFT,
	APLL_MODE_SHIFT		= 0,
	APLL_MODE_MASK		= 3 << APLL_MODE_SHIFT,

	/* CRU_CLK_SEL0_CON */
	CORE_ACLK_DIV_SHIFT	= 12,
	CORE_ACLK_DIV_MASK	= 0x7 << CORE_ACLK_DIV_SHIFT,
	CORE_DBG_DIV_SHIFT	= 8,
	CORE_DBG_DIV_MASK	= 0xf << CORE_DBG_DIV_SHIFT,
	CORE_CLK_PLL_SEL_SHIFT	= 6,
	CORE_CLK_PLL_SEL_MASK	= 0x3 << CORE_CLK_PLL_SEL_SHIFT,
	CORE_CLK_PLL_SEL_APLL	= 0,
	CORE_CLK_PLL_SEL_VPLL0,
	CORE_CLK_PLL_SEL_VPLL1,
	CORE_DIV_CON_SHIFT	= 0,
	CORE_DIV_CON_MASK	= 0x0f << CORE_DIV_CON_SHIFT,

	/* CRU_CLK_SEL2_CON */
	CLK_RTC32K_SEL_SHIFT	= 8,
	CLK_RTC32K_SEL_MASK	= 3 << CLK_RTC32K_SEL_SHIFT,
	CLK_RTC32K_IO		= 0,
	CLK_RTC32K_PVTM,
	CLK_RTC32K_FRAC_DIV,
	CLK_RTC32K_DIV,

	/* CRU_CLK_SEL3_CON */
	CLK_RTC32K_FRAC_NUMERATOR_SHIFT		= 16,
	CLK_RTC32K_FRAC_NUMERATOR_MASK		= 0xffff << 16,
	CLK_RTC32K_FRAC_DENOMINATOR_SHIFT	= 0,
	CLK_RTC32K_FRAC_DENOMINATOR_MASK	= 0xffff,

	/* CRU_CLK_SEL5_CON */
	BUS_PLL_SEL_SHIFT	= 6,
	BUS_PLL_SEL_MASK	= 0x3 << BUS_PLL_SEL_SHIFT,
	BUS_PLL_SEL_DPLL	= 0,
	BUS_PLL_SEL_VPLL0,
	BUS_PLL_SEL_VPLL1,
	BUS_ACLK_DIV_SHIFT	= 0,
	BUS_ACLK_DIV_MASK	= 0x1f << BUS_ACLK_DIV_SHIFT,

	/* CRU_CLK_SEL6_CON */
	BUS_PCLK_DIV_SHIFT	= 8,
	BUS_PCLK_DIV_MASK	= 0x1f << BUS_PCLK_DIV_SHIFT,
	BUS_HCLK_DIV_SHIFT	= 0,
	BUS_HCLK_DIV_MASK	= 0x1f << BUS_HCLK_DIV_SHIFT,

	/* CRU_CLK_SEL7_CON */
	CRYPTO_APK_SEL_SHIFT	= 14,
	CRYPTO_APK_PLL_SEL_MASK	= 3 << CRYPTO_APK_SEL_SHIFT,
	CRYPTO_PLL_SEL_DPLL	= 0,
	CRYPTO_PLL_SEL_VPLL0,
	CRYPTO_PLL_SEL_VPLL1	= 0,
	CRYPTO_APK_DIV_SHIFT	= 8,
	CRYPTO_APK_DIV_MASK	= 0x1f << CRYPTO_APK_DIV_SHIFT,
	CRYPTO_PLL_SEL_SHIFT	= 6,
	CRYPTO_PLL_SEL_MASK	= 3 << CRYPTO_PLL_SEL_SHIFT,
	CRYPTO_DIV_SHIFT	= 0,
	CRYPTO_DIV_MASK		= 0x1f << CRYPTO_DIV_SHIFT,

	/* CRU_CLK_SEL8_CON */
	DCLK_VOP_SEL_SHIFT	= 14,
	DCLK_VOP_SEL_MASK	= 0x3 << DCLK_VOP_SEL_SHIFT,
	DCLK_VOP_SEL_DIVOUT	= 0,
	DCLK_VOP_SEL_FRACOUT,
	DCLK_VOP_SEL_24M,
	DCLK_VOP_PLL_SEL_SHIFT	= 10,
	DCLK_VOP_PLL_SEL_MASK	= 0x3 << DCLK_VOP_PLL_SEL_SHIFT,
	DCLK_VOP_PLL_SEL_DPLL	= 0,
	DCLK_VOP_PLL_SEL_VPLL0,
	DCLK_VOP_PLL_SEL_VPLL1,
	DCLK_VOP_DIV_SHIFT	= 0,
	DCLK_VOP_DIV_MASK	= 0xff,

	/* CRU_CLK_SEL25_CON */
	/* CRU_CLK_SEL26_CON */
	/* CRU_CLK_SEL27_CON */
	/* CRU_CLK_SEL28_CON */
	CLK_I2C_PLL_SEL_SHIFT		= 14,
	CLK_I2C_PLL_SEL_MASK		= 0x3 << CLK_I2C_PLL_SEL_SHIFT,
	CLK_I2C_PLL_SEL_DPLL		= 0,
	CLK_I2C_PLL_SEL_VPLL0,
	CLK_I2C_PLL_SEL_24M,
	CLK_I2C_DIV_CON_SHIFT		= 0,
	CLK_I2C_DIV_CON_MASK		= 0x7f << CLK_I2C_DIV_CON_SHIFT,

	/* CRU_CLK_SEL29_CON */
	CLK_PWM_PLL_SEL_SHIFT		= 14,
	CLK_PWM_PLL_SEL_MASK		= 0x3 << CLK_PWM_PLL_SEL_SHIFT,
	CLK_PWM_PLL_SEL_DPLL		= 0,
	CLK_PWM_PLL_SEL_VPLL0,
	CLK_PWM_PLL_SEL_24M,
	CLK_PWM_DIV_CON_SHIFT		= 0,
	CLK_PWM_DIV_CON_MASK		= 0x7f << CLK_PWM_DIV_CON_SHIFT,

	/* CRU_CLK_SEL30_CON */
	/* CRU_CLK_SEL31_CON */
	/* CRU_CLK_SEL32_CON */
	CLK_SPI_PLL_SEL_SHIFT		= 14,
	CLK_SPI_PLL_SEL_MASK		= 0x3 << CLK_SPI_PLL_SEL_SHIFT,
	CLK_SPI_PLL_SEL_DPLL		= 0,
	CLK_SPI_PLL_SEL_VPLL0,
	CLK_SPI_PLL_SEL_24M,
	CLK_SPI_DIV_CON_SHIFT		= 0,
	CLK_SPI_DIV_CON_MASK		= 0x7f << CLK_SPI_DIV_CON_SHIFT,

	/* CRU_CLK_SEL34_CON */
	CLK_SARADC_DIV_CON_SHIFT	= 0,
	CLK_SARADC_DIV_CON_MASK		= 0x7ff << CLK_SARADC_DIV_CON_SHIFT,

	/* CRU_CLK_SEL36_CON */
	PERI_PLL_SEL_SHIFT	= 6,
	PERI_PLL_SEL_MASK	= 0x3 << PERI_PLL_SEL_SHIFT,
	PERI_PLL_DPLL		= 0,
	PERI_PLL_VPLL0,
	PERI_PLL_VPLL1,
	PERI_ACLK_DIV_SHIFT	= 0,
	PERI_ACLK_DIV_MASK	= 0x1f << PERI_ACLK_DIV_SHIFT,

	/* CRU_CLK_SEL37_CON */
	PERI_PCLK_DIV_SHIFT	= 8,
	PERI_PCLK_DIV_MASK	= 0x1f << PERI_PCLK_DIV_SHIFT,
	PERI_HCLK_DIV_SHIFT	= 0,
	PERI_HCLK_DIV_MASK	= 0x1f << PERI_HCLK_DIV_SHIFT,

	/* CRU_CLKSEL41_CON */
	EMMC_CLK_SEL_SHIFT	= 15,
	EMMC_CLK_SEL_MASK	= 1 << EMMC_CLK_SEL_SHIFT,
	EMMC_CLK_SEL_EMMC	= 0,
	EMMC_CLK_SEL_EMMC_DIV50,
	EMMC_PLL_SHIFT		= 8,
	EMMC_PLL_MASK		= 0x3 << EMMC_PLL_SHIFT,
	EMMC_SEL_DPLL		= 0,
	EMMC_SEL_VPLL0,
	EMMC_SEL_VPLL1,
	EMMC_SEL_24M,
	EMMC_DIV_SHIFT		= 0,
	EMMC_DIV_MASK		= 0xff << EMMC_DIV_SHIFT,

	/* CRU_CLKSEL42_CON */
	SCLK_SFC_SEL_SHIFT	= 14,
	SCLK_SFC_SEL_MASK	= 0x3 << SCLK_SFC_SEL_SHIFT,
	SCLK_SFC_SEL_DPLL	= 0,
	SCLK_SFC_SEL_VPLL0,
	SCLK_SFC_SEL_VPLL1,
	SCLK_SFC_DIV_SHIFT	= 0,
	SCLK_SFC_DIV_MASK	= 0x7f << SCLK_SFC_DIV_SHIFT,

	/* CRU_CLKSEL43_CON */
	MAC_CLK_SPEED_SEL_SHIFT = 15,
	MAC_CLK_SPEED_SEL_MASK = 1 << MAC_CLK_SPEED_SEL_SHIFT,
	MAC_CLK_SPEED_SEL_10M = 0,
	MAC_CLK_SPEED_SEL_100M,
	MAC_CLK_SOURCE_SEL_SHIFT = 14,
	MAC_CLK_SOURCE_SEL_MASK = 1 << MAC_CLK_SOURCE_SEL_SHIFT,
	MAC_CLK_SOURCE_SEL_INTERNAL	= 0,
	MAC_CLK_SOURCE_SEL_EXTERNAL,
	MAC_PLL_SHIFT		= 6,
	MAC_PLL_MASK		= 0x3 << MAC_PLL_SHIFT,
	MAC_SEL_DPLL		= 0,
	MAC_SEL_VPLL0,
	MAC_SEL_VPLL1,
	MAC_DIV_SHIFT		= 0,
	MAC_DIV_MASK		= 0x1f << MAC_DIV_SHIFT,

	/* CRU_CLK_SEL45_CON */
	AUDIO_PCLK_DIV_SHIFT	= 8,
	AUDIO_PCLK_DIV_MASK	= 0x1f << AUDIO_PCLK_DIV_SHIFT,
	AUDIO_PLL_SEL_SHIFT	= 6,
	AUDIO_PLL_SEL_MASK	= 0x3 << AUDIO_PLL_SEL_SHIFT,
	AUDIO_PLL_VPLL0		= 0,
	AUDIO_PLL_VPLL1,
	AUDIO_PLL_24M,
	AUDIO_HCLK_DIV_SHIFT	= 0,
	AUDIO_HCLK_DIV_MASK	= 0x1f << AUDIO_HCLK_DIV_SHIFT,
};

check_member(rk3308_cru, emmc_con[1], 0x494);

enum {	/* DPLL_CON0, VPLL0_CON0, VPLL1_CON0 */
	POSTDIV1_SHIFT			= 12,
	POSTDIV1_MASK			= 0x7 << POSTDIV1_SHIFT,
	FBDIV_SHIFT			= 0,
	FBDIV_MASK			= 0xfff << FBDIV_SHIFT,

	/* DPLL_CON1, VPLL0_CON1, VPLL1_CON1 */
	PLLPD0_SHIFT			= 13,
	PLLPD0_MASK			= 1 << PLLPD0_SHIFT,
	DSMPD_SHIFT			= 12,
	DSMPD_MASK			= 1 << DSMPD_SHIFT,
	INTEGER_MODE			= 1,
	FRACTIONAL_MODE			= 0,
	PLL_LOCK_SHIFT			= 10,
	PLL_LOCK_MASK			= 0x1 << PLL_LOCK_SHIFT,
	POSTDIV2_SHIFT			= 6,
	POSTDIV2_MASK			= 0x7 << POSTDIV2_SHIFT,
	REFDIV_SHIFT			= 0,
	REFDIV_MASK			= 0x3f << REFDIV_SHIFT,

	/* VPLL0_CON2, VPLL1_CON2 */
	FRACDIV_SHIFT			= 0,
	FRACDIV_MASK			= 0xffffff << FRACDIV_SHIFT,

	/* CRU_MODE */
	VPLL1_CLK_SEL_SHIFT		= 13,
	VPLL1_CLK_SEL_MASK		= 0x1 << VPLL1_CLK_SEL_SHIFT,
	VPLL1_CLK_SEL_WITHOUT_LVL_SHIFT	= 1,

	VPLL0_CLK_SEL_SHIFT		= 12,
	VPLL0_CLK_SEL_MASK		= 0x1 << VPLL0_CLK_SEL_SHIFT,
	VPLL0_CLK_SEL_WITHOUT_LVL_SHIFT	= 1,

	DPLL_CLK_SEL_SHIFT		= 11,
	DPLL_CLK_SEL_MASK		= 0x1 << DPLL_CLK_SEL_SHIFT,
	DPLL_CLK_SEL_WITHOUT_LVL_SHIFT	= 1,

	APLL_CLK_SEL_SHIFT		= 10,
	APLL_CLK_SEL_MASK		= 0x1 << APLL_CLK_SEL_SHIFT,
	APLL_CLK_SEL_WITHOUT_LVL_SHIFT	= 1,

	VPLL1_WORK_MODE_SHIFT		= 6,
	VPLL1_WORK_MODE_MASK		= 0x3 << VPLL1_WORK_MODE_SHIFT,
	VPLL1_WORK_MODE_XIN_OSC0	= 0,
	VPLL1_WORK_MODE_PLL		= 1,
	VPLL1_WORK_MODE_32K		= 2,

	VPLL0_WORK_MODE_SHIFT		= 4,
	VPLL0_WORK_MODE_MASK		= 0x3 << VPLL0_WORK_MODE_SHIFT,
	VPLL0_WORK_MODE_XIN_OSC0	= 0,
	VPLL0_WORK_MODE_PLL		= 1,
	VPLL0_WORK_MODE_32K		= 2,

	DPLL_WORK_MODE_SHIFT		= 2,
	DPLL_WORK_MODE_MASK		= 0x3 << DPLL_WORK_MODE_SHIFT,
	DPLL_WORK_MODE_XIN_OSC0		= 0,
	DPLL_WORK_MODE_PLL		= 1,
	DPLL_WORK_MODE_32K		= 2,

	APLL_WORK_MODE_SHIFT		= 0,
	APLL_WORK_MODE_MASK		= 0x3 << APLL_WORK_MODE_SHIFT,
	APLL_WORK_MODE_XIN_OSC0		= 0,
	APLL_WORK_MODE_PLL		= 1,

	/* GLB_RST_CON */
	WDT_GLB_SRST_CTRL_SHIFT		= 1,
	WDT_GLB_SRST_CTRL		= 1,
	TSADC_GLB_SRST_CTRL_SHIFT	= 0,
	TSADC_GLB_SRST_CTRL		= 1,

	/* CLKSEL_CON1 */
	DDRPHY4X_PLL_CLK_SEL_SHIFT	= 6,
	DDRPHY4X_PLL_CLK_SEL_MASK	= 0x3 << DDRPHY4X_PLL_CLK_SEL_SHIFT,
	DDRPHY4X_PLL_CLK_SEL_DPLL	= 0,
	DDRPHY4X_DIV_CON_SIHFT		= 0,
	DDRPHY4X_DIV_CON_MASK		= 0x7 << DDRPHY4X_DIV_CON_SIHFT,
	DDRPHY4X_DIV_CON		= 0,

	/* CLKSEL_CON5 */
	A_H_PCLK_BUS_PLL_SEL_SHIFT	= 6,
	A_H_PCLK_BUS_PLL_SEL_MASK	= 0x3 << A_H_PCLK_BUS_PLL_SEL_SHIFT,
	A_H_PCLK_BUS_PLL_SEL_DPLL	= 0,
	A_H_PCLK_BUS_PLL_SEL_VPLL0	= 1,
	A_H_PCLK_BUS_PLL_SEL_VPLL1	= 2,
	ACLK_BUS_DIV_CON_SHIFT		= 0,
	ACLK_BUS_DIV_CON_MASK		= 0x1f << ACLK_BUS_DIV_CON_SHIFT,
	ACLK_BUS_DIV_CON_7		= 7,
	ACLK_BUS_DIV_CON_5		= 5,
	ACLK_BUS_DIV_CON_3		= 3,

	/* CLKSEL_CON6 */
	PCLK_BUS_DIV_CON_SHIFT		= 8,
	PCLK_BUS_DIV_CON_MASK		= 0x1f << PCLK_BUS_DIV_CON_SHIFT,
	PCLK_BUS_DIV_CON_31		= 31,
	PCLK_BUS_DIV_CON_25		= 25,
	PCLK_BUS_DIV_CON_15		= 15,
	HCLK_BUS_DIV_CON_SHIFT		= 0,
	HCLK_BUS_DIV_CON_MASK		= 0x1f << HCLK_BUS_DIV_CON_SHIFT,
	HCLK_BUS_DIV_CON_15		= 15,
	HCLK_BUS_DIV_CON_13		= 13,
	HCLK_BUS_DIV_CON_11		= 11,
	HCLK_BUS_DIV_CON_7		= 7,

	/* CLKSEL_CON7 */
	CLK_CRYPTO_APK_SEL_SHIFT	= 14,
	CLK_CRYPTO_APK_SEL_MASK		= 0x3 << CLK_CRYPTO_APK_SEL_SHIFT,
	CLK_CRYPTO_APK_SEL_DPLL		= 0,
	CLK_CRYPTO_APK_DIV_SHIFT	= 8,
	CLK_CRYPTO_APK_DIV_MASK		= 0x1f << CLK_CRYPTO_APK_DIV_SHIFT,
	CLK_CRYPTO_APK_DIV_15		= 15,
	CLK_CRYPTO_APK_DIV_13		= 13,
	CLK_CRYPTO_APK_DIV_11		= 11,
	CLK_CRYPTO_APK_DIV_7		= 7,
	CLK_CRYPTO_PLL_SEL_SHIFT	= 6,
	CLK_CRYPTO_PLL_SEL_MASK		= 0x3 << CLK_CRYPTO_PLL_SEL_SHIFT,
	CLK_CRYPTO_PLL_SEL_DPLL		= 0,
	CLK_CRYPTO_DIV_CON_SHIFT	= 0,
	CLK_CRYPTO_DIV_CON_MASK		= 0x1f << CLK_CRYPTO_DIV_CON_SHIFT,
	CLK_CRYPTO_DIV_CON_15		= 15,
	CLK_CRYPTO_DIV_CON_13		= 13,
	CLK_CRYPTO_DIV_CON_11		= 11,
	CLK_CRYPTO_DIV_CON_7		= 7,

	/* CLKSEL_CON8 */
	DCLK_VOP_SEL_DCLK_VOP		= 0,
	DCLK_VOP_DIV_CON_SHIFT		= 0,
	DCLK_VOP_DIV_CON_MASK		= 0xff << DCLK_VOP_DIV_CON_SHIFT,
	DCLK_VOP_DIV_CON_15		= 15,
	DCLK_VOP_DIV_CON_11		= 11,

	/* CLKSEL_CON10 */
	CLK_UART0_PLL_SEL_SHIFT		= 13,
	CLK_UART0_PLL_SEL_MASK		= 0x7 << CLK_UART0_PLL_SEL_SHIFT,
	CLK_UART0_PLL_SEL_XIN_OSC0	= 4,
	CLK_UART0_DIV_CON_SHIFT		= 0,
	CLK_UART0_DIV_CON_MASK		= 0x1f << CLK_UART0_DIV_CON_SHIFT,
	CLK_UART0_DIV_CON		= 0,
	CLK_UART0_DIV_CON_15		= 15,

	/* CLKSEL_CON13 */
	CLK_UART1_PLL_SEL_SHIFT		= 13,
	CLK_UART1_PLL_SEL_MASK		= 0x7 << CLK_UART1_PLL_SEL_SHIFT,
	CLK_UART1_PLL_SEL_XIN_OSC0	= 4,
	CLK_UART1_DIV_CON_SHIFT		= 0,
	CLK_UART1_DIV_CON_MASK		= 0x1f << CLK_UART1_DIV_CON_SHIFT,
	CLK_UART1_DIV_CON		= 0,
	CLK_UART1_DIV_CON_15		= 15,

	/* CLKSEL_CON16 */
	CLK_UART2_PLL_SEL_SHIFT		= 13,
	CLK_UART2_PLL_SEL_MASK		= 0x7 << CLK_UART2_PLL_SEL_SHIFT,
	CLK_UART2_PLL_SEL_XIN_OSC0	= 4,
	CLK_UART2_DIV_CON_SHIFT		= 0,
	CLK_UART2_DIV_CON_MASK		= 0x1f << CLK_UART2_DIV_CON_SHIFT,
	CLK_UART2_DIV_CON		= 0,
	CLK_UART2_DIV_CON_15		= 15,

	/* CLKSEL_CON19 */
	CLK_UART3_PLL_SEL_SHIFT		= 13,
	CLK_UART3_PLL_SEL_MASK		= 0x7 << CLK_UART3_PLL_SEL_SHIFT,
	CLK_UART3_PLL_SEL_XIN_OSC0	= 4,
	CLK_UART3_DIV_CON_SHIFT		= 0,
	CLK_UART3_DIV_CON_MASK		= 0x1f << CLK_UART3_DIV_CON_SHIFT,
	CLK_UART3_DIV_CON		= 0,
	CLK_UART3_DIV_CON_15		= 15,

	/* CLKSEL_CON22 */
	CLK_UART4_PLL_SEL_SHIFT		= 13,
	CLK_UART4_PLL_SEL_MASK		= 0x7 << CLK_UART4_PLL_SEL_SHIFT,
	CLK_UART4_PLL_SEL_XIN_OSC0	= 4,
	CLK_UART4_DIV_CON_SHIFT		= 0,
	CLK_UART4_DIV_CON_MASK		= 0x1f << CLK_UART4_DIV_CON_SHIFT,
	CLK_UART4_DIV_CON		= 0,
	CLK_UART4_DIV_CON_15		= 15,

	/* CLKSEL_CON25 */
	CLK_I2C0_PLL_SEL_SHIFT		= 14,
	CLK_I2C0_PLL_SEL_MASK		= 0x3 << CLK_I2C0_PLL_SEL_SHIFT,
	CLK_I2C0_PLL_SEL_DPLL		= 0,
	CLK_I2C0_DIV_CON_SHIFT		= 0,
	CLK_I2C0_DIV_CON_MASK		= 0x7f << CLK_I2C0_DIV_CON_SHIFT,
	CLK_I2C0_DIV_CON_7		= 7,
	CLK_I2C0_DIV_CON_5		= 5,
	CLK_I2C0_DIV_CON_3		= 3,

	/* CLKSEL_CON26 */
	CLK_I2C1_PLL_SEL_SHIFT		= 14,
	CLK_I2C1_PLL_SEL_MASK		= 0x3 << CLK_I2C1_PLL_SEL_SHIFT,
	CLK_I2C1_PLL_SEL_DPLL		= 0,
	CLK_I2C1_DIV_CON_SHIFT		= 0,
	CLK_I2C1_DIV_CON_MASK		= 0x7f << CLK_I2C1_DIV_CON_SHIFT,
	CLK_I2C1_DIV_CON_7		= 7,
	CLK_I2C1_DIV_CON_5		= 5,
	CLK_I2C1_DIV_CON_3		= 3,

	/* CLKSEL_CON27 */
	CLK_I2C2_PLL_SEL_SHIFT		= 14,
	CLK_I2C2_PLL_SEL_MASK		= 0x3 << CLK_I2C2_PLL_SEL_SHIFT,
	CLK_I2C2_PLL_SEL_DPLL		= 0,
	CLK_I2C2_DIV_CON_SHIFT		= 0,
	CLK_I2C2_DIV_CON_MASK		= 0x7f << CLK_I2C2_DIV_CON_SHIFT,
	CLK_I2C2_DIV_CON_7		= 7,
	CLK_I2C2_DIV_CON_5		= 5,
	CLK_I2C2_DIV_CON_3		= 3,

	/* CLKSEL_CON28 */
	CLK_I2C3_PLL_SEL_SHIFT		= 14,
	CLK_I2C3_PLL_SEL_MASK		= 0x3 << CLK_I2C3_PLL_SEL_SHIFT,
	CLK_I2C3_PLL_SEL_DPLL		= 0,
	CLK_I2C3_DIV_CON_SHIFT		= 0,
	CLK_I2C3_DIV_CON_MASK		= 0x7f << CLK_I2C3_DIV_CON_SHIFT,
	CLK_I2C3_DIV_CON_7		= 7,
	CLK_I2C3_DIV_CON_5		= 5,
	CLK_I2C3_DIV_CON_3		= 3,

	/* CLKSEL_CON29 */
	CLK_PWM_DIV_CON_15		= 15,
	CLK_PWM_DIV_CON_11		= 11,
	CLK_PWM_DIV_CON_7		= 7,

	/* CLKSEL_CON30 */
	CLK_SPI0_PLL_SEL_SHIFT		= 14,
	CLK_SPI0_PLL_SEL_MASK		= 0x3 << CLK_SPI0_PLL_SEL_SHIFT,
	CLK_SPI0_PLL_SEL_DPLL		= 0,
	CLK_SPI0_DIV_CON_SHIFT		= 0,
	CLK_SPI0_DIV_CON_MASK		= 0x7f << CLK_SPI0_DIV_CON_SHIFT,
	CLK_SPI0_DIV_CON_15		= 15,
	CLK_SPI0_DIV_CON_11		= 11,
	CLK_SPI0_DIV_CON_7		= 7,

	/* CLKSEL_CON31 */
	CLK_SPI1_PLL_SEL_SHIFT		= 14,
	CLK_SPI1_PLL_SEL_MASK		= 0x3 << CLK_SPI1_PLL_SEL_SHIFT,
	CLK_SPI1_PLL_SEL_DPLL		= 0,
	CLK_SPI1_DIV_CON_SHIFT		= 0,
	CLK_SPI1_DIV_CON_MASK		= 0x7f << CLK_SPI1_DIV_CON_SHIFT,
	CLK_SPI1_DIV_CON_15		= 15,
	CLK_SPI1_DIV_CON_11		= 11,
	CLK_SPI1_DIV_CON_7		= 7,

	/* CLKSEL_CON32 */
	CLK_SPI2_PLL_SEL_SHIFT		= 14,
	CLK_SPI2_PLL_SEL_MASK		= 0x3 << CLK_SPI2_PLL_SEL_SHIFT,
	CLK_SPI2_PLL_SEL_DPLL		= 0,
	CLK_SPI2_DIV_CON_SHIFT		= 0,
	CLK_SPI2_DIV_CON_MASK		= 0x7f << CLK_SPI2_DIV_CON_SHIFT,
	CLK_SPI2_DIV_CON_15		= 15,
	CLK_SPI2_DIV_CON_11		= 11,
	CLK_SPI2_DIV_CON_7		= 7,

	/* CLKSEL_CON36 */
	A_H_P_PERI_PLL_SEL_SHIFT	= 6,
	A_H_P_PERI_PLL_SEL_MASK		= 0x3 << A_H_P_PERI_PLL_SEL_SHIFT,
	A_H_P_PERI_PLL_SEL_DPLL		= 0,
	ACLK_PERI_DIV_CON_SHIFT		= 0,
	ACLK_PERI_DIV_CON_MASK		= 0x1f << ACLK_PERI_DIV_CON_SHIFT,
	ACLK_PERI_DIV_CON_7		= 7,
	ACLK_PERI_DIV_CON_5		= 5,
	ACLK_PERI_DIV_CON_3		= 3,

	/* CLKSEL_CON37 */
	PCLK_PERI_DIV_CON_SHIFT		= 8,
	PCLK_PERI_DIV_CON_MASK		= 0x1f << PCLK_PERI_DIV_CON_SHIFT,
	PCLK_PERI_DIV_CON_31		= 31,
	PCLK_PERI_DIV_CON_27		= 27,
	PCLK_PERI_DIV_CON_23		= 23,
	PCLK_PERI_DIV_CON_15		= 15,
	HCLK_PERI_DIV_CON_SHIFT		= 0,
	HCLK_PERI_DIV_CON_MASK		= 0x1f << HCLK_PERI_DIV_CON_SHIFT,
	HCLK_PERI_DIV_CON_15		= 15,
	HCLK_PERI_DIV_CON_13		= 13,
	HCLK_PERI_DIV_CON_11		= 11,
	HCLK_PERI_DIV_CON_7		= 7,

	/* CLKSEL_CON38 */
	CLK_NANDC_SEL50_SHIFT		= 15,
	CLK_NANDC_SEL50_MASK		= 0x1 << CLK_NANDC_SEL50_SHIFT,
	CLK_NANDC_SEL50_EVEN		= 0,
	CLK_NANDC_SEL50_ALWAYS		= 1,
	CLK_NANDC_PLL_SEL_SHIFT		= 6,
	CLK_NANDC_PLL_SEL_MASK		= 0x3 << CLK_NANDC_PLL_SEL_SHIFT,
	CLK_NANDC_PLL_SEL_DPLL		= 0,
	CLK_NANDC_DIV_CON_SHIFT		= 0,
	CLK_NANDC_DIV_CON_MASK		= 0x1f << CLK_NANDC_DIV_CON_SHIFT,
	CLK_NANDC_DIV_CON_15		= 15,
	CLK_NANDC_DIV_CON_13		= 13,
	CLK_NANDC_DIV_CON_11		= 11,
	CLK_NANDC_DIV_CON_7		= 7,

	/* CLKSEL_CON39 */
	CLK_SDMMC_SEL50_SHIFT		= 15,
	CLK_SDMMC_SEL50_MASK		= 0x1 << CLK_SDMMC_SEL50_SHIFT,
	CLK_SDMMC_SEL50_EVEN		= 0,
	CLK_SDMMC_SEL50_ALWAYS		= 1,
	CLK_SDMMC_PLL_SEL_SHIFT		= 8,
	CLK_SDMMC_PLL_SEL_MASK		= 0x3 << CLK_SDMMC_PLL_SEL_SHIFT,
	CLK_SDMMC_PLL_SEL_DPLL		= 0,
	CLK_SDMMC_DIV_CON_SHIFT		= 0,
	CLK_SDMMC_DIV_CON_MASK		= 0xff << CLK_SDMMC_DIV_CON_SHIFT,
	CLK_SDMMC_DIV_CON_31		= 31,
	CLK_SDMMC_DIV_CON_27		= 27,
	CLK_SDMMC_DIV_CON_23		= 23,
	CLK_SDMMC_DIV_CON_15		= 15,

	/* CLKSEL_CON40 */
	CLK_SDIO_SEL50_SHIFT		= 15,
	CLK_SDIO_SEL50_MASK		= 0x1 << CLK_SDIO_SEL50_SHIFT,
	CLK_SDIO_SEL50_EVEN		= 0,
	CLK_SDIO_SEL50_ALWAYS		= 1,
	CLK_SDIO_PLL_SEL_SHIFT		= 8,
	CLK_SDIO_PLL_SEL_MASK		= 0x3 << CLK_SDIO_PLL_SEL_SHIFT,
	CLK_SDIO_PLL_SEL_DPLL		= 0,
	CLK_SDIO_DIV_CON_SHIFT		= 0,
	CLK_SDIO_DIV_CON_MASK		= 0xff << CLK_SDIO_DIV_CON_SHIFT,
	CLK_SDIO_DIV_CON_4		= 4,
	CLK_SDIO_DIV_CON_3		= 3,
	CLK_SDIO_DIV_CON_2		= 2,

	/* CLKSEL_CON41 */
	CLK_EMMC_SEL50_SHIFT		= 15,
	CLK_EMMC_SEL50_MASK		= 0x1 << CLK_EMMC_SEL50_SHIFT,
	CLK_EMMC_SEL50_EVEN		= 0,
	CLK_EMMC_SEL50_ALWAYS		= 1,
	CLK_EMMC_PLL_SEL_SHIFT		= 8,
	CLK_EMMC_PLL_SEL_MASK		= 0x3 << CLK_EMMC_PLL_SEL_SHIFT,
	CLK_EMMC_PLL_SEL_DPLL		= 0,
	CLK_EMMC_DIV_CON_SHIFT		= 0,
	CLK_EMMC_DIV_CON_MASK		= 0xff << CLK_EMMC_DIV_CON_SHIFT,
	CLK_EMMC_DIV_CON_31		= 31,
	CLK_EMMC_DIV_CON_27		= 27,
	CLK_EMMC_DIV_CON_23		= 23,
	CLK_EMMC_DIV_CON_15		= 15,

	/* CLKSEL_CON42 */
	CLK_SFC_PLL_SEL_SHIFT		= 14,
	CLK_SFC_PLL_SEL_MASK		= 0x3 << CLK_SFC_PLL_SEL_SHIFT,
	CLK_SFC_PLL_SEL_DPLL		= 0,
	CLK_SFC_DIV_CON_SHIFT		= 0,
	CLK_SFC_DIV_CON_MASK		= 0x7f << CLK_SFC_DIV_CON_SHIFT,
	CLK_SFC_DIV_CON_65		= 65,
	CLK_SFC_DIV_CON_53		= 53,
	CLK_SFC_DIV_CON_49		= 49,
	CLK_SFC_DIV_CON_31		= 31,

	/* CLKSEL_CON43 */
	RMII_CLK_SEL_SHIFT		= 15,
	RMII_CLK_SEL_MASK		= 0x1 << RMII_CLK_SEL_SHIFT,
	RMII_CLK_SEL_100M		= 1,
	RMII_CLK_SEL_10M		= 0,
	RMII_EXTCLKSRC_SEL_SHIFT	= 14,
	RMII_EXTCLKSRC_SEL_MASK		= 0x1 << RMII_EXTCLKSRC_SEL_SHIFT,
	RMII_EXTCLKSRC_SEL_CLK_MAC	= 0,
	CLK_MAC_PLL_SEL_SHIFT		= 6,
	CLK_MAC_PLL_SEL_MASK		= 0x3 << CLK_MAC_PLL_SEL_SHIFT,
	CLK_MAC_PLL_SEL_DPLL		= 0,
	CLK_MAC_DIV_CON_SHIFT		= 0,
	CLK_MAC_DIV_CON_MASK		= 0x1f << CLK_MAC_DIV_CON_SHIFT,
	CLK_MAC_DIV_CON_31		= 31,
	CLK_MAC_DIV_CON_23		= 23,
	CLK_MAC_DIV_CON_25		= 25,

	/* CLKSEL_CON44 */
	CLK_WIFI_SEL_SHIFT		= 7,
	CLK_WIFI_SEL_MASK		= 0x1 << CLK_WIFI_SEL_SHIFT,
	CLK_WIFI_SEL_CLK_WIFI		= 1,
	CLK_WIFI_PLL_SEL_SHIFT		= 6,
	CLK_WIFI_PLL_SEL_MASK		= 0x1 << CLK_WIFI_PLL_SEL_SHIFT,
	CLK_WIFI_PLL_SEL_DPLL		= 0,
	CLK_WIFI_DIV_CON_SHIFT		= 0,
	CLK_WIFI_DIV_CON_MASK		= 0x3f << CLK_WIFI_DIV_CON_SHIFT,
	CLK_WIFI_DIV_CON_39		= 39,
	CLK_WIFI_DIV_CON_29		= 29,
	CLK_WIFI_DIV_CON_49		= 49,
	CLK_WIFI_DIV_CON_19		= 19,

	/* CLKSEL_CON45 */
	PCLK_AUDIO_DIV_CON_SHIFT	= 8,
	PCLK_AUDIO_DIV_CON_MASK		= 0x1f << PCLK_AUDIO_DIV_CON_SHIFT,
	PCLK_AUDIO_DIV_CON_9		= 9,
	H_PCLK_AUDIO_PLL_SEL_SHIFT	= 6,
	H_PCLK_AUDIO_PLL_SEL_MASK	= 0x3 << H_PCLK_AUDIO_PLL_SEL_SHIFT,
	H_PCLK_AUDIO_PLL_SEL_VPLL0	= 0,
	HCLK_AUDIO_DIV_CON_SHIFT	= 0,
	HCLK_AUDIO_DIV_CON_MASK		= 0x1f << HCLK_AUDIO_DIV_CON_SHIFT,
	HCLK_AUDIO_DIV_CON_9		= 9,

	/* CLKSEL_CON46 */
	CLK_PDM_SEL_SHIFT		= 15,
	CLK_PDM_SEL_MASK		= 0x1 << CLK_PDM_SEL_SHIFT,
	CLK_PDM_SEL_CLK_PDM		= 0,
	CLK_PDM_PLL_SEL_SHIFT		= 8,
	CLK_PDM_PLL_SEL_MASK		= 0x3 << CLK_PDM_PLL_SEL_SHIFT,
	CLK_PDM_PLL_SEL_VPLL0		= 0,
	CLK_PDM_DIV_CON_SHIFT		= 0,
	CLK_PDM_DIV_CON_MASK		= 0x7f << CLK_PDM_DIV_CON_SHIFT,
	CLK_PDM_DIV_CON_15		= 15,

	/* CLKSEL_CON48 */
	CLK_SPDIFTX_DIV_CON_SHIFT	= 0,
	CLK_SPDIFTX_DIV_CON_MASK	= 0x7f << CLK_SPDIFTX_DIV_CON_SHIFT,
	CLK_SPDIFTX_DIV_CON_15		= 15,

	/* CLKSEL_CON52,CLKSEL_CON56,CLKSEL_CON60,CLKSEL_CON64 */
	I2S_8CH_OUT_SEL_SHIFT		= 15,
	I2S_8CH_OUT_SEL_MASK		= 0x1 << I2S_8CH_OUT_SEL_SHIFT,
	I2S_8CH_OUT_SEL_TX_RX		= 0,
	I2S_8CH_TX_RX_SEL_SHIFT		= 12,
	I2S_8CH_TX_RX_SEL_MASK		= 0x1 << I2S_8CH_TX_RX_SEL_SHIFT,
	I2S_8CH_TX_RX_SEL_TX		= 0,
	I2S_8CH_TX_SEL_SHIFT		= 10,
	I2S_8CH_TX_SEL_MASK		= 0x3 << I2S_8CH_TX_SEL_SHIFT,
	I2S_8CH_TX_SEL_TX		= 0,
	I2S_8CH_TX_PLL_SEL_SHIFT	= 8,
	I2S_8CH_TX_PLL_SEL_MASK		= 0x3 << I2S_8CH_TX_PLL_SEL_SHIFT,
	I2S_8CH_TX_PLL_SEL_VPLL1	= 1,
	I2S_8CH_TX_DIV_CON_SHIFT	= 0,
	I2S_8CH_TX_DIV_CON_MASK		= 0x7f << I2S_8CH_TX_DIV_CON_SHIFT,
	I2S_8CH_TX_DIV_CON_17		= 17,

	/* CLKSEL_CON54,CLKSEL_CON58,CLKSEL_CON62,CLKSEL_CON66 */
	I2S_8CH_RX_TX_SEL_SHIFT		= 12,
	I2S_8CH_RX_TX_SEL_MASK		= 0x1 << I2S_8CH_RX_TX_SEL_SHIFT,
	I2S_8CH_RX_TX_SEL_RX		= 0,
	I2S_8CH_RX_SEL_SHIFT		= 10,
	I2S_8CH_RX_SEL_MASK		= 0x3 << I2S_8CH_RX_SEL_SHIFT,
	I2S_8CH_RX_SEL_RX		= 0,
	I2S_8CH_RX_PLL_SEL_SHIFT	= 8,
	I2S_8CH_RX_PLL_SEL_MASK		= 0x3 << I2S_8CH_RX_PLL_SEL_SHIFT,
	I2S_8CH_RX_PLL_SEL_VPLL0	= 0,
	I2S_8CH_RX_DIV_CON_SHIFT	= 0,
	I2S_8CH_RX_DIV_CON_MASK		= 0x7f << I2S_8CH_RX_DIV_CON_SHIFT,
	I2S_8CH_RX_DIV_CON_19		= 19,

	/* SOFTRST_CON1 */
	PRESETN_DDRPHY_REQ_SHIFT	= 14,
	PRESETN_DDRPHY_REQ_MASK		= 0x1 << PRESETN_DDRPHY_REQ_SHIFT,
	PRESETN_DDRPHY_REQ_EN		= 1,
	PRESETN_DDRPHY_REQ_DIS		= 0,

	RESETN_DDRPHYDIV_REQ_SHIFT	= 13,
	RESETN_DDRPHYDIV_REQ_MASK	= 0x1 << RESETN_DDRPHYDIV_REQ_SHIFT,
	RESETN_DDRPHYDIV_REQ_EN		= 1,
	RESETN_DDRPHYDIV_REQ_DIS	= 0,

	RESETN_DDRPHY_REQ_SHIFT		= 12,
	RESETN_DDRPHY_REQ_MASK		= 0x1 << RESETN_DDRPHY_REQ_SHIFT,
	RESETN_DDRPHY_REQ_EN		= 1,
	RESETN_DDRPHY_REQ_DIS		= 0,

	PRESETN_DDRUPCTL_REQ_SHIFT	= 6,
	PRESETN_DDRUPCTL_REQ_MASK	= 0x1 << PRESETN_DDRUPCTL_REQ_SHIFT,
	PRESETN_DDRUPCTL_REQ_EN		= 1,
	PRESETN_DDRUPCTL_REQ_DIS	= 0,

	RESETN_DDRUPCTL_REQ_SHIFT	= 4,
	RESETN_DDRUPCTL_REQ_MASK	= 0x1 << RESETN_DDRUPCTL_REQ_SHIFT,
	RESETN_DDRUPCTL_REQ_EN		= 1,
	RESETN_DDRUPCTL_REQ_DIS		= 0,

	/* CLKGATE_CON4 */
	CLK_PMU_PVTM_CLK_EN_SHIFT	= 4,
	CLK_PMU_PVTM_CLK_EN_MASK	= 0x1 << CLK_PMU_PVTM_CLK_EN_SHIFT,
	CLK_PMU_PVTM_CLK_EN		= 0,

	/* SOFTRST_CON5 */
	RESETN_PMU_PVTM_REQ_SHIFT	= 1,
	RESETN_PMU_PVTM_REQ_MASK	= 0x1 << RESETN_PMU_PVTM_REQ_SHIFT,
	RESETN_PMU_PVTM_REQ_ACT		= 1,
	RESETN_PMU_PVTM_REQ_DIS		= 0,
};

#endif
