/*
 * FM1288 Voice Processor Codec driver
 *
 * Copyright (C) 2017 Rockchip Electronics Co., Ltd.
 * Author: Yeevan <showy.zhang@rock-chips.com>
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <linux/pm.h>
#include <linux/i2c.h>
#include <linux/slab.h>
#include <linux/gpio.h>
#include <linux/of_gpio.h>

static int fm1288_i2c_probe(struct i2c_client *i2c_client,
			    const struct i2c_device_id *id)
{
	int ret = -1;
	struct gpio_desc *fm1288_ctl_gpio;

	const unsigned char reg[] = {
		0xFC, 0xF3, 0x68, 0x64, 0x00,
		0xFC, 0xF3, 0x0D, 0x3F, 0x80, 0x90, 0x94, 0x3E,
		0xFC, 0xF3, 0x0D, 0x3F, 0x81, 0x93, 0x83, 0xDE,
		0xFC, 0xF3, 0x0D, 0x3F, 0x82, 0x19, 0x2A, 0xBF,
		0xFC, 0xF3, 0x0D, 0x3F, 0x83, 0x40, 0x05, 0x08,
		0xFC, 0xF3, 0x0D, 0x3F, 0x84, 0x19, 0x3E, 0x7F,
		0xFC, 0xF3, 0x0D, 0x3F, 0x85, 0x80, 0x95, 0x2A,
		0xFC, 0xF3, 0x0D, 0x3F, 0x86, 0x2A, 0x7A, 0xAA,
		0xFC, 0xF3, 0x0D, 0x3F, 0x87, 0x19, 0x28, 0x4F,
		0xFC, 0xF3, 0x0D, 0x3F, 0x88, 0x80, 0x94, 0x3A,
		0xFC, 0xF3, 0x0D, 0x3F, 0x89, 0x82, 0x32, 0xD1,
		0xFC, 0xF3, 0x0D, 0x3F, 0x8A, 0x26, 0x79, 0x0F,
		0xFC, 0xF3, 0x0D, 0x3F, 0x8B, 0x19, 0x2A, 0x80,
		0xFC, 0xF3, 0x0D, 0x3F, 0x8C, 0x80, 0x95, 0xBA,
		0xFC, 0xF3, 0x0D, 0x3F, 0x8D, 0x68, 0x00, 0xA1,
		0xFC, 0xF3, 0x0D, 0x3F, 0x8E, 0x94, 0x96, 0xD0,
		0xFC, 0xF3, 0x0D, 0x3F, 0x8F, 0x90, 0x95, 0xBE,
		0xFC, 0xF3, 0x0D, 0x3F, 0x90, 0x19, 0x2A, 0xBF,
		0xFC, 0xF3, 0x0D, 0x3F, 0x91, 0x40, 0xFA, 0x0A,
		0xFC, 0xF3, 0x0D, 0x3F, 0x92, 0x41, 0x77, 0x0C,
		0xFC, 0xF3, 0x0D, 0x3F, 0x93, 0x41, 0xF4, 0x0B,
		0xFC, 0xF3, 0x0D, 0x3F, 0x94, 0x42, 0xB1, 0x1F,
		0xFC, 0xF3, 0x0D, 0x3F, 0x95, 0x42, 0xEE, 0x0E,
		0xFC, 0xF3, 0x0D, 0x3F, 0x96, 0x82, 0x30, 0x11,
		0xFC, 0xF3, 0x0D, 0x3F, 0x97, 0x27, 0x91, 0x1F,
		0xFC, 0xF3, 0x0D, 0x3F, 0x98, 0x22, 0x7C, 0x01,
		0xFC, 0xF3, 0x0D, 0x3F, 0x99, 0x27, 0x91, 0x5F,
		0xFC, 0xF3, 0x0D, 0x3F, 0x9A, 0x22, 0x7B, 0x01,
		0xFC, 0xF3, 0x0D, 0x3F, 0x9B, 0x27, 0x91, 0x9F,
		0xFC, 0xF3, 0x0D, 0x3F, 0x9C, 0x22, 0x7F, 0x01,
		0xFC, 0xF3, 0x0D, 0x3F, 0x9D, 0x27, 0x91, 0xDF,
		0xFC, 0xF3, 0x0D, 0x3F, 0x9E, 0x22, 0x7E, 0x01,
		0xFC, 0xF3, 0x0D, 0x3F, 0x9F, 0x18, 0x34, 0xBF,
		0xFC, 0xF3, 0x0D, 0x3F, 0xA0, 0x22, 0x7F, 0x9F,
		0xFC, 0xF3, 0x0D, 0x3F, 0xA1, 0x19, 0xB0, 0x5F,
		0xFC, 0xF3, 0x0D, 0x3F, 0xA2, 0x41, 0x00, 0x0A,
		0xFC, 0xF3, 0x0D, 0x3F, 0xA3, 0x90, 0x96, 0xDA,
		0xFC, 0xF3, 0x0D, 0x3F, 0xA4, 0x82, 0x2C, 0x4A,
		0xFC, 0xF3, 0x0D, 0x3F, 0xA5, 0x23, 0xA2, 0x5F,
		0xFC, 0xF3, 0x0D, 0x3F, 0xA6, 0x92, 0x2C, 0x4A,
		0xFC, 0xF3, 0x0D, 0x3F, 0xA7, 0x82, 0x32, 0x5A,
		0xFC, 0xF3, 0x0D, 0x3F, 0xA8, 0x19, 0x76, 0x4F,
		0xFC, 0xF3, 0x0D, 0x3F, 0xA9, 0x82, 0x2F, 0x2A,
		0xFC, 0xF3, 0x0D, 0x3F, 0xAA, 0x40, 0x03, 0x85,
		0xFC, 0xF3, 0x0D, 0x3F, 0xAB, 0x26, 0xEA, 0x0F,
		0xFC, 0xF3, 0x0D, 0x3F, 0xAC, 0x22, 0x08, 0x02,
		0xFC, 0xF3, 0x0D, 0x3F, 0xAD, 0x92, 0x2F, 0x2A,
		0xFC, 0xF3, 0x0D, 0x3F, 0xAE, 0x18, 0x28, 0x3F,
		0xFC, 0xF3, 0x68, 0x64, 0x00,
		0xFC, 0xF3, 0x3B, 0x3F, 0xA0, 0x92, 0xAA,
		0xFC, 0xF3, 0x3B, 0x3F, 0xB0, 0x3F, 0x80,
		0xFC, 0xF3, 0x3B, 0x3F, 0xA1, 0x93, 0xE6,
		0xFC, 0xF3, 0x3B, 0x3F, 0xB1, 0x3F, 0x83,
		0xFC, 0xF3, 0x3B, 0x3F, 0xA2, 0x92, 0x82,
		0xFC, 0xF3, 0x3B, 0x3F, 0xB2, 0x3F, 0x85,
		0xFC, 0xF3, 0x3B, 0x3F, 0xA3, 0x92, 0xA7,
		0xFC, 0xF3, 0x3B, 0x3F, 0xB3, 0x3F, 0x88,
		0xFC, 0xF3, 0x3B, 0x3F, 0xA4, 0x83, 0x49,
		0xFC, 0xF3, 0x3B, 0x3F, 0xB4, 0x3F, 0x91,
		0xFC, 0xF3, 0x3B, 0x3F, 0xA5, 0x9B, 0x04,
		0xFC, 0xF3, 0x3B, 0x3F, 0xB5, 0x3F, 0xA0,
		0xFC, 0xF3, 0x3B, 0x3F, 0xA6, 0x97, 0x63,
		0xFC, 0xF3, 0x3B, 0x3F, 0xB6, 0x3F, 0xA2,
		0xFC, 0xF3, 0x3B, 0x3F, 0xA7, 0x82, 0x82,
		0xFC, 0xF3, 0x3B, 0x3F, 0xB7, 0x3F, 0xA9,
		0xFC, 0xF3, 0x3B, 0x23, 0xF7, 0x8A, 0x64,
		0xFC, 0xF3, 0x3B, 0x23, 0xF8, 0x75, 0xA1,
		0xFC, 0xF3, 0x3B, 0x23, 0xF9, 0x82, 0x2B,
		0xFC, 0xF3, 0x3B, 0x23, 0xFA, 0x7C, 0x22,
		0xFC, 0xF3, 0x3B, 0x23, 0xFB, 0x7F, 0xFF,
		0xFC, 0xF3, 0x3B, 0x22, 0xF2, 0x00, 0x34,
		0xFC, 0xF3, 0x3B, 0x23, 0xFC, 0x80, 0x0C,
		0xFC, 0xF3, 0x3B, 0x23, 0x09, 0x00, 0x00,
		0xFC, 0xF3, 0x3B, 0x23, 0x01, 0x00, 0x02,
		0xFC, 0xF3, 0x3B, 0x22, 0xFA, 0x00, 0x3D,
		0xFC, 0xF3, 0x3B, 0x23, 0x02, 0x00, 0x01,
		0xFC, 0xF3, 0x3B, 0x22, 0xC8, 0x00, 0x29,
		0xFC, 0xF3, 0x3B, 0x23, 0x03, 0x09, 0x89,
		0xFC, 0xF3, 0x3B, 0x22, 0xF9, 0x00, 0x7F,
		0xFC, 0xF3, 0x3B, 0x23, 0x82, 0x02, 0x00,
		0xFC, 0xF3, 0x3B, 0x22, 0xE5, 0x02, 0x55,
		0xFC, 0xF3, 0x3B, 0x23, 0x83, 0x03, 0x00,
		0xFC, 0xF3, 0x3B, 0x23, 0xEE, 0x40, 0x00,
		0xFC, 0xF3, 0x3B, 0x22, 0xC7, 0x00, 0x0C,
		0xFC, 0xF3, 0x3B, 0x23, 0xFD, 0x7F, 0xFF,
		0xFC, 0xF3, 0x3B, 0x23, 0x07, 0x00, 0x00,
		0xFC, 0xF3, 0x3B, 0x23, 0xB4, 0x00, 0x01,
		0xFC, 0xF3, 0x3B, 0x23, 0x86, 0x10, 0x00,
		0xFC, 0xF3, 0x3B, 0x23, 0xB8, 0x00, 0x01,
		0xFC, 0xF3, 0x3B, 0x23, 0x48, 0x08, 0x00,
		0xFC, 0xF3, 0x3B, 0x23, 0xB3, 0x00, 0x04,
		0xFC, 0xF3, 0x3B, 0x23, 0x49, 0x10, 0x00,
		0xFC, 0xF3, 0x3B, 0x22, 0xC6, 0x00, 0x0C,
		0xFC, 0xF3, 0x3B, 0x23, 0xB7, 0x00, 0x00,
		0xFC, 0xF3, 0x3B, 0x23, 0x04, 0x03, 0xCF,
		0xFC, 0xF3, 0x3B, 0x23, 0x0C, 0x04, 0x00,
		0xFC, 0xF3, 0x3B, 0x23, 0xBE, 0x00, 0xE0,
		0xFC, 0xF3, 0x3B, 0x23, 0x0D, 0x01, 0x00,
		0xFC, 0xF3, 0x3B, 0x23, 0x2D, 0x00, 0x01,
		0xFC, 0xF3, 0x3B, 0x23, 0x85, 0x0E, 0x00,
		0xFC, 0xF3, 0x3B, 0x23, 0xBF, 0x00, 0x54,
		0xFC, 0xF3, 0x3B, 0x23, 0x6F, 0x05, 0x00,
		0xFC, 0xF3, 0x3B, 0x23, 0x2F, 0x01, 0x00,
		0xFC, 0xF3, 0x3B, 0x23, 0x10, 0x12, 0x0C,
		0xFC, 0xF3, 0x3B, 0x23, 0xED, 0x04, 0x00,
		0xFC, 0xF3, 0x3B, 0x23, 0x39, 0x00, 0x20,
		0xFC, 0xF3, 0x3B, 0x23, 0x70, 0x03, 0x00,
		0xFC, 0xF3, 0x3B, 0x23, 0x90, 0x44, 0x44,
		0xFC, 0xF3, 0x3B, 0x23, 0x6E, 0x20, 0x00,
		0xFC, 0xF3, 0x3B, 0x23, 0x91, 0x44, 0x44,
		0xFC, 0xF3, 0x3B, 0x23, 0x05, 0x00, 0x01,
		0xFC, 0xF3, 0x3B, 0x23, 0xB5, 0x30, 0x00,
		0xFC, 0xF3, 0x3B, 0x23, 0xF1, 0x3C, 0x9B,
		0xFC, 0xF3, 0x3B, 0x23, 0x93, 0x44, 0x44,
		0xFC, 0xF3, 0x3B, 0x23, 0xF2, 0xC3, 0x65,
		0xFC, 0xF3, 0x3B, 0x23, 0x94, 0x44, 0x44,
		0xFC, 0xF3, 0x3B, 0x23, 0xF3, 0x3C, 0x9B,
		0xFC, 0xF3, 0x3B, 0x23, 0x95, 0x44, 0x44,
		0xFC, 0xF3, 0x3B, 0x23, 0xF4, 0x8A, 0x69,
		0xFC, 0xF3, 0x3B, 0x22, 0xC4, 0x06, 0x22,
		0xFC, 0xF3, 0x3B, 0x23, 0xF5, 0x6C, 0xB1,
		0xFC, 0xF3, 0x3B, 0x23, 0xFF, 0x7F, 0x34,
		0xFC, 0xF3, 0x3B, 0x23, 0xF6, 0x75, 0xA1,
		0xFC, 0xF3, 0x3B, 0x23, 0xFE, 0x80, 0x8B,
		0xFC, 0xF3, 0x3B, 0x23, 0x84, 0x0A, 0x00,
		0xFC, 0xF3, 0x3B, 0x23, 0xBB, 0x20, 0x00,
		0xFC, 0xF3, 0x3B, 0x22, 0xFB, 0x00, 0x00
	};

	fm1288_ctl_gpio = devm_gpiod_get(&i2c_client->dev, "pwd", GPIOD_OUT_HIGH);
	if (IS_ERR(fm1288_ctl_gpio)) {
		dev_err(&i2c_client->dev, "%s Can not read property fm1288 pwd-gpios\n", __func__);
		return PTR_ERR(fm1288_ctl_gpio);
	}
	gpiod_direction_output(fm1288_ctl_gpio, 1);
	/*
	 * To ensure power up completely before i2c trigger,
	 * increase the delay of a period of time if necessary
	 */
	ret = i2c_master_send(i2c_client, reg, ARRAY_SIZE(reg));
	if (ret != ARRAY_SIZE(reg)) {
		dev_err(&i2c_client->dev, "fm1288 probe error\n");
		return ret;
	}
	return 0;
}

static const struct i2c_device_id fm1288_i2c_id[] = {
	{"fm1288", 0},
	{ }
};
MODULE_DEVICE_TABLE(i2c, fm1288_i2c_id);

static struct i2c_driver fm1288_i2c_driver = {
	.driver = {
		.name = "fm1288",
	},
	.probe = fm1288_i2c_probe,
	.id_table = fm1288_i2c_id,
};

module_i2c_driver(fm1288_i2c_driver);

MODULE_DESCRIPTION("Voice Processor fm1288 driver");
MODULE_AUTHOR("Yeevan <showy.zhang@rock-chips.com>");
MODULE_LICENSE("GPL");

