// SPDX-License-Identifier: GPL-2.0
/*
 * ov2718 driver
 *
 * Copyright (C) 2018 Fuzhou Rockchip Electronics Co., Ltd.
 *
 * V0.0X01.0X01 add poweron function.
 * V0.0X01.0X02 fix mclk issue when probe multiple camera.
 * V0.0X01.0X03 add enum_frame_interval function.
 * V0.0X01.0X04 update a new version
 *	1.update the new get regulator method
 *	2.correct initialization sequence
 *	3.fix the level setting of reset gpio
 *	4.support raw12bit linear/hdr mode
 *	5.implement RKMODULE_SET/GET_HDR_CFG
 * V0.0X01.0X05 group hold launch immediately when set hdr ae.
 * V0.0X01.0X06 add quick stream on/off
 */

#include <linux/clk.h>
#include <linux/device.h>
#include <linux/delay.h>
#include <linux/gpio/consumer.h>
#include <linux/i2c.h>
#include <linux/module.h>
#include <linux/pm_runtime.h>
#include <linux/regulator/consumer.h>
#include <linux/sysfs.h>
#include <linux/slab.h>
#include <linux/version.h>
#include <linux/rk-camera-module.h>
#include <media/media-entity.h>
#include <media/v4l2-async.h>
#include <media/v4l2-ctrls.h>
#include <media/v4l2-subdev.h>
#include <media/v4l2-fwnode.h>
#include <linux/pinctrl/consumer.h>
#include <linux/of.h>
#include <linux/of_device.h>
#include <linux/of_graph.h>
#include <linux/of_platform.h>
#include <linux/of_gpio.h>
#include <linux/mfd/syscon.h>
#include <linux/rk-preisp.h>

#define DRIVER_VERSION			KERNEL_VERSION(0, 0x01, 0x06)

#ifndef V4L2_CID_DIGITAL_GAIN
#define V4L2_CID_DIGITAL_GAIN		V4L2_CID_GAIN
#endif

#define OV2718_LINK_FREQ_480MHZ		480000000
/* pixel rate = link frequency * 2 * lanes / BITS_PER_SAMPLE */
#define OV2718_PIXEL_RATE_12BIT		(OV2718_LINK_FREQ_480MHZ * 2 * 2 / 12)
#define OV2718_PIXEL_RATE_10BIT		(OV2718_LINK_FREQ_480MHZ * 2 * 2 / 10)
#define OV2718_XVCLK_FREQ		24000000

#define CHIP_ID				0x2770
#define OV2718_REG_CHIP_ID		0x300a

#define OV2718_REG_CTRL_MODE		0x3012
#define OV2718_MODE_SW_STANDBY		0x0
#define OV2718_MODE_STREAMING		BIT(0)

#define OV2718_REG_EXPOSURE_H		0x30B6
#define OV2718_REG_EXPOSURE_L		0x30B7
#define	OV2718_EXPOSURE_MIN		1
#define	OV2718_EXPOSURE_STEP		1
#define OV2718_VTS_MAX			0xffff

#define OV2718_READ_MODE		0x30c0
#define OV2718_FLIP			BIT(3)
#define OV2718_MIRROR			BIT(2)

#define OV2718_REG_GAIN			0x30bb
#define OV2718_GAIN_MIN			0x0300
#define OV2718_GAIN_MAX			0x20000
#define OV2718_GAIN_STEP		1
#define OV2718_GAIN_DEFAULT		0x0300

#define OV2718_REG_DIG_GAIN_HCG_H	0x315a
#define OV2718_REG_DIG_GAIN_HCG_L	0x315b

#define OV2718_REG_DIG_GAIN_LCG_H	0x315c
#define OV2718_REG_DIG_GAIN_LCG_L	0x315d

#define OV2718_REG_TEST_PATTERN		0x303a
#define OV2718_TEST_PATTERN_ENABLE	0x20
#define OV2718_TEST_PATTERN_DISABLE	0x0

#define OV2718_REG_VTS_H		0x30b2
#define OV2718_REG_VTS_L		0x30b3

#define OV2718_REG_GROUP_CTL		0x3464
#define OV2718_REG_OPERATE_CTL		0x3467
#define OV2718_REG_GROUP_BIT		0x8000

#define REG_DELAY			0xFFFE
#define REG_NULL			0xFFFF

#define OV2718_REG_VALUE_08BIT		1
#define OV2718_REG_VALUE_16BIT		2
#define OV2718_REG_VALUE_24BIT		3

#define OV2718_LANES			2
#define OV2718_BITS_PER_SAMPLE		10

#define OF_CAMERA_PINCTRL_STATE_DEFAULT	"rockchip,camera_default"
#define OF_CAMERA_PINCTRL_STATE_SLEEP	"rockchip,camera_sleep"

#define OV2718_NAME			"ov2718"

enum ov2718_max_pad {
	PAD0, /* link to isp */
	PAD1, /* link to csi wr0 | hdr x2:L x3:M */
	PAD2, /* link to csi wr1 | hdr      x3:L */
	PAD3, /* link to csi wr2 | hdr x2:M x3:S */
	PAD_MAX,
};

struct ov2718_gpio {
	int pltfrm_gpio;
	const char *label;
	enum of_gpio_flags active_low;
};

static const char * const ov2718_supply_names[] = {
	"avdd",			/* Analog power */
	"dovdd",		/* Digital I/O power */
	"dvdd",			/* Digital core power */
};

#define OV2718_NUM_SUPPLIES ARRAY_SIZE(ov2718_supply_names)

struct regval {
	u16 addr;
	u8 val;
};

struct ov2718_mode {
	u32 bus_fmt;
	u32 width;
	u32 height;
	struct v4l2_fract max_fps;
	u32 hts_def;
	u32 vts_def;
	u32 exp_def;
	u32 hdr_mode;
	u32 vc[PAD_MAX];
	const struct regval *reg_list;
};

struct ov2718 {
	struct i2c_client	*client;
	struct clk		*xvclk;
	struct gpio_desc	*rst_gpio;
	struct gpio_desc	*pd_gpio;
	struct gpio_desc	*pwd_gpio;
	struct regulator_bulk_data supplies[OV2718_NUM_SUPPLIES];
	struct pinctrl		*pinctrl;
	struct pinctrl_state	*pins_default;
	struct pinctrl_state	*pins_sleep;
	struct preisp_hdrae_exp_s init_hdrae_exp;

	struct v4l2_subdev	subdev;
	struct media_pad	pad;
	struct v4l2_ctrl_handler ctrl_handler;
	struct v4l2_ctrl	*exposure;
	struct v4l2_ctrl	*anal_gain;
	struct v4l2_ctrl	*digi_gain;
	struct v4l2_ctrl	*hblank;
	struct v4l2_ctrl	*vblank;
	struct v4l2_ctrl	*test_pattern;
	struct v4l2_ctrl	*pixel_rate;
	struct v4l2_ctrl	*h_flip;
	struct v4l2_ctrl	*v_flip;
	struct mutex		mutex;
	bool			has_init_exp;
	bool			streaming;
	bool			power_on;
	const struct ov2718_mode *cur_mode;
	const struct ov2718_mode *support_modes;
	u32			support_modes_num;
	u32			module_index;
	u32			flip;
	const char		*module_facing;
	const char		*module_name;
	const char		*len_name;
};

#define to_ov2718(sd) container_of(sd, struct ov2718, subdev)

/* two lanes,raw 10bit */
static const struct regval ov2718_linear10bit_init_tab_1920_1080[] = {
	{0x3013, 0x01},
	{REG_DELAY, 0x10},
	{0x3000, 0x02},
	{0x3001, 0x28},
	{0x3002, 0x03},
	{0x3003, 0x01},
	{0x3004, 0x02},
	{0x3005, 0x26},
	{0x3006, 0x00},
	{0x3007, 0x07},
	{0x3008, 0x01},
	{0x3009, 0x00},
	{0x300c, 0x6c},
	{0x300e, 0x80},
	{0x300f, 0x00},
	{0x3012, 0x00},
	{0x3013, 0x00},
	{0x3014, 0xc4},
	{0x3015, 0x00},
	{0x3017, 0x00},
	{0x3018, 0x00},
	{0x3019, 0x00},
	{0x301a, 0x00},
	{0x301b, 0x01},
	{0x301e, 0x17},
	{0x301f, 0xe1},
	{0x3030, 0x02},
	{0x3031, 0x72},
	{0x3032, 0xf0},
	{0x3033, 0x30},
	{0x3034, 0x3f},
	{0x3035, 0x5f},
	{0x3036, 0x02},
	{0x3037, 0x9f},
	{0x3038, 0x04},
	{0x3039, 0xb7},
	{0x303a, 0x04},
	{0x303b, 0x07},
	{0x303c, 0xf0},
	{0x303d, 0x00},
	{0x303e, 0x0b},
	{0x303f, 0xe3},
	{0x3040, 0xf3},
	{0x3041, 0x29},
	{0x3042, 0xf6},
	{0x3043, 0x65},
	{0x3044, 0x06},
	{0x3045, 0x0f},
	{0x3046, 0x59},
	{0x3047, 0x07},
	{0x3048, 0x82},
	{0x3049, 0xcf},
	{0x304a, 0x12},
	{0x304b, 0x40},
	{0x304c, 0x33},
	{0x304d, 0xa4},
	{0x304e, 0x0b},
	{0x304f, 0x3d},
	{0x3050, 0x10},
	{0x3060, 0x00},
	{0x3061, 0x64},
	{0x3062, 0x00},
	{0x3063, 0xe4},
	{0x3066, 0x80},
	{0x3080, 0x00},
	{0x3081, 0x00},
	{0x3082, 0x01},
	{0x3083, 0xe3},
	{0x3084, 0x06},
	{0x3085, 0x00},
	{0x3086, 0x10},
	{0x3087, 0x10},
	{0x3089, 0x00},
	{0x308a, 0x01},
	{0x3093, 0x00},
	{0x30a0, 0x00},
	{0x30a1, 0x00},
	{0x30a2, 0x00},
	{0x30a3, 0x00},
	{0x30a4, 0x07},
	{0x30a5, 0x8f},
	{0x30a6, 0x04},
	{0x30a7, 0x47},
	{0x30a8, 0x00},
	{0x30a9, 0x00},
	{0x30aa, 0x00},
	{0x30ab, 0x00},
	{0x30ac, 0x07},
	{0x30ad, 0x90},
	{0x30ae, 0x04},
	{0x30af, 0x48},
	{0x30b0, 0x04},
	{0x30b1, 0x7e},
	{0x30b2, 0x04},
	{0x30b3, 0x65},
	{0x30b4, 0x00},
	{0x30b5, 0x00},
	{0x30b6, 0x00},
	{0x30b7, 0x10},
	{0x30b8, 0x00},
	{0x30b9, 0x02},
	{0x30ba, 0x10},
	{0x30bb, 0x00},
	{0x30bc, 0x00},
	{0x30bd, 0x03},
	{0x30be, 0x5c},
	{0x30bf, 0x00},
	{0x30c0, 0x01},
	{0x30c1, 0x00},
	{0x30c2, 0x20},
	{0x30c3, 0x00},
	{0x30c4, 0x4a},
	{0x30c5, 0x00},
	{0x30c7, 0x00},
	{0x30c8, 0x00},
	{0x30d1, 0x00},
	{0x30d2, 0x00},
	{0x30d3, 0x80},
	{0x30d4, 0x00},
	{0x30d9, 0x09},
	{0x30da, 0x64},
	{0x30dd, 0x00},
	{0x30de, 0x16},
	{0x30df, 0x00},
	{0x30e0, 0x17},
	{0x30e1, 0x00},
	{0x30e2, 0x18},
	{0x30e3, 0x10},
	{0x30e4, 0x04},
	{0x30e5, 0x00},
	{0x30e6, 0x00},
	{0x30e7, 0x00},
	{0x30e8, 0x00},
	{0x30e9, 0x00},
	{0x30ea, 0x00},
	{0x30eb, 0x00},
	{0x30ec, 0x00},
	{0x30ed, 0x00},
	{0x3101, 0x00},
	{0x3102, 0x00},
	{0x3103, 0x00},
	{0x3104, 0x00},
	{0x3105, 0x8c},
	{0x3106, 0x87},
	{0x3107, 0xc0},
	{0x3108, 0x9d},
	{0x3109, 0x8d},
	{0x310a, 0x8d},
	{0x310b, 0x6a},
	{0x310c, 0x3a},
	{0x310d, 0x5a},
	{0x310e, 0x00},
	{0x3120, 0x00},
	{0x3121, 0x00},
	{0x3122, 0x00},
	{0x3123, 0xf0},
	{0x3124, 0x00},
	{0x3125, 0x70},
	{0x3126, 0x1f},
	{0x3127, 0x0f},
	{0x3128, 0x00},
	{0x3129, 0x3a},
	{0x312a, 0x02},
	{0x312b, 0x0f},
	{0x312c, 0x00},
	{0x312d, 0x0f},
	{0x312e, 0x1d},
	{0x312f, 0x00},
	{0x3130, 0x00},
	{0x3131, 0x00},
	{0x3132, 0x00},
	{0x3140, 0x0a},
	{0x3141, 0x03},
	{0x3142, 0x00},
	{0x3143, 0x00},
	{0x3144, 0x00},
	{0x3145, 0x00},
	{0x3146, 0x00},
	{0x3147, 0x00},
	{0x3148, 0x00},
	{0x3149, 0x00},
	{0x314a, 0x00},
	{0x314b, 0x00},
	{0x314c, 0x00},
	{0x314d, 0x00},
	{0x314e, 0x1c},
	{0x314f, 0xff},
	{0x3150, 0xff},
	{0x3151, 0xff},
	{0x3152, 0x10},
	{0x3153, 0x10},
	{0x3154, 0x10},
	{0x3155, 0x00},
	{0x3156, 0x03},
	{0x3157, 0x00},
	{0x3158, 0x0f},
	{0x3159, 0xff},
	{0x315a, 0x01},
	{0x315b, 0x00},
	{0x315c, 0x01},
	{0x315d, 0x00},
	{0x315e, 0x01},
	{0x315f, 0x00},
	{0x3160, 0x00},
	{0x3161, 0x40},
	{0x3162, 0x00},
	{0x3163, 0x40},
	{0x3164, 0x00},
	{0x3165, 0x40},
	{0x3190, 0x38},
	{0x3191, 0x99},
	{0x3193, 0x08},
	{0x3194, 0x13},
	{0x3195, 0x33},
	{0x3196, 0x00},
	{0x3197, 0x10},
	{0x3198, 0x00},
	{0x3199, 0x7f},
	{0x319a, 0x80},
	{0x319b, 0xff},
	{0x319c, 0x80},
	{0x319d, 0xbf},
	{0x319e, 0xc0},
	{0x319f, 0xff},
	{0x31a0, 0x24},
	{0x31a1, 0x55},
	{0x31a2, 0x00},
	{0x31a3, 0x00},
	{0x31a6, 0x00},
	{0x31a7, 0x00},
	{0x31b0, 0x00},
	{0x31b1, 0x00},
	{0x31b2, 0x02},
	{0x31b3, 0x00},
	{0x31b4, 0x00},
	{0x31b5, 0x01},
	{0x31b6, 0x00},
	{0x31b7, 0x00},
	{0x31b8, 0x00},
	{0x31b9, 0x00},
	{0x31ba, 0x00},
	{0x31d0, 0x3c},
	{0x31d1, 0x34},
	{0x31d2, 0x3c},
	{0x31d3, 0x00},
	{0x31d4, 0x2d},
	{0x31d5, 0x00},
	{0x31d6, 0x01},
	{0x31d7, 0x06},
	{0x31d8, 0x00},
	{0x31d9, 0x64},
	{0x31da, 0x00},
	{0x31db, 0x30},
	{0x31dc, 0x04},
	{0x31dd, 0x69},
	{0x31de, 0x0a},
	{0x31df, 0x3c},
	{0x31e0, 0x04},
	{0x31e1, 0x32},
	{0x31e2, 0x00},
	{0x31e3, 0x00},
	{0x31e4, 0x08},
	{0x31e5, 0x80},
	{0x31e6, 0x00},
	{0x31e7, 0x2b},
	{0x31e8, 0x6b},
	{0x31e9, 0xab},
	{0x31ea, 0xeb},
	{0x31eb, 0x3f},
	{0x31ec, 0x0f},
	{0x31ed, 0x20},
	{0x31ee, 0x04},
	{0x31ef, 0x48},
	{0x31f0, 0x07},
	{0x31f1, 0x90},
	{0x31f2, 0x04},
	{0x31f3, 0x48},
	{0x31f4, 0x07},
	{0x31f5, 0x90},
	{0x31f6, 0x04},
	{0x31f7, 0x48},
	{0x31f8, 0x07},
	{0x31f9, 0x90},
	{0x31fa, 0x04},
	{0x31fb, 0x48},
	{0x31fd, 0xcb},
	{0x31fe, 0x03},
	{0x31ff, 0x03},
	{0x3200, 0x00},
	{0x3201, 0xff},
	{0x3202, 0x00},
	{0x3203, 0xff},
	{0x3204, 0xff},
	{0x3205, 0xff},
	{0x3206, 0xff},
	{0x3207, 0xff},
	{0x3208, 0xff},
	{0x3209, 0xff},
	{0x320a, 0xff},
	{0x320b, 0x1b},
	{0x320c, 0x1f},
	{0x320d, 0x1e},
	{0x320e, 0x30},
	{0x320f, 0x2d},
	{0x3210, 0x2c},
	{0x3211, 0x2b},
	{0x3212, 0x2a},
	{0x3213, 0x24},
	{0x3214, 0x22},
	{0x3215, 0x00},
	{0x3216, 0x04},
	{0x3217, 0x2b},
	{0x3218, 0x6b},
	{0x3219, 0xab},
	{0x321a, 0xec},
	{0x321b, 0x00},
	{0x3230, 0x3a},
	{0x3231, 0x00},
	{0x3232, 0x80},
	{0x3233, 0x00},
	{0x3234, 0x10},
	{0x3235, 0xaa},
	{0x3236, 0x55},
	{0x3237, 0x99},
	{0x3238, 0x66},
	{0x3239, 0x08},
	{0x323a, 0x88},
	{0x323b, 0x00},
	{0x323c, 0x00},
	{0x323d, 0x03},
	{0x3250, 0x33},
	{0x3251, 0x00},
	{0x3252, 0x20},
	{0x3253, 0x00},
	{0x3254, 0x00},
	{0x3255, 0x01},
	{0x3256, 0x00},
	{0x3257, 0x00},
	{0x3258, 0x00},
	{0x3270, 0x01},
	{0x3271, 0x60},
	{0x3272, 0xc0},
	{0x3273, 0x00},
	{0x3274, 0x80},
	{0x3275, 0x40},
	{0x3276, 0x02},
	{0x3277, 0x08},
	{0x3278, 0x10},
	{0x3279, 0x04},
	{0x327a, 0x00},
	{0x327b, 0x03},
	{0x327c, 0x10},
	{0x327d, 0x60},
	{0x327e, 0xc0},
	{0x327f, 0x06},
	{0x3288, 0x10},
	{0x3289, 0x00},
	{0x328a, 0x08},
	{0x328b, 0x00},
	{0x328c, 0x04},
	{0x328d, 0x00},
	{0x328e, 0x02},
	{0x328f, 0x00},
	{0x3290, 0x20},
	{0x3291, 0x00},
	{0x3292, 0x10},
	{0x3293, 0x00},
	{0x3294, 0x08},
	{0x3295, 0x00},
	{0x3296, 0x04},
	{0x3297, 0x00},
	{0x3298, 0x40},
	{0x3299, 0x00},
	{0x329a, 0x20},
	{0x329b, 0x00},
	{0x329c, 0x10},
	{0x329d, 0x00},
	{0x329e, 0x08},
	{0x329f, 0x00},
	{0x32a0, 0x7f},
	{0x32a1, 0xff},
	{0x32a2, 0x40},
	{0x32a3, 0x00},
	{0x32a4, 0x20},
	{0x32a5, 0x00},
	{0x32a6, 0x10},
	{0x32a7, 0x00},
	{0x32a8, 0x00},
	{0x32a9, 0x00},
	{0x32aa, 0x00},
	{0x32ab, 0x00},
	{0x32ac, 0x00},
	{0x32ad, 0x00},
	{0x32ae, 0x00},
	{0x32af, 0x00},
	{0x32b0, 0x00},
	{0x32b1, 0x00},
	{0x32b2, 0x00},
	{0x32b3, 0x00},
	{0x32b4, 0x00},
	{0x32b5, 0x00},
	{0x32b6, 0x00},
	{0x32b7, 0x00},
	{0x32b8, 0x00},
	{0x32b9, 0x00},
	{0x32ba, 0x00},
	{0x32bb, 0x00},
	{0x32bc, 0x00},
	{0x32bd, 0x00},
	{0x32be, 0x00},
	{0x32bf, 0x00},
	{0x32c0, 0x00},
	{0x32c1, 0x00},
	{0x32c2, 0x00},
	{0x32c3, 0x00},
	{0x32c4, 0x00},
	{0x32c5, 0x00},
	{0x32c6, 0x00},
	{0x32c7, 0x00},
	{0x32c8, 0x87},
	{0x32c9, 0x00},
	{0x3330, 0x03},
	{0x3331, 0xc8},
	{0x3332, 0x02},
	{0x3333, 0x24},
	{0x3334, 0x00},
	{0x3335, 0x00},
	{0x3336, 0x00},
	{0x3337, 0x00},
	{0x3338, 0x03},
	{0x3339, 0xc8},
	{0x333a, 0x02},
	{0x333b, 0x24},
	{0x333c, 0x00},
	{0x333d, 0x00},
	{0x333e, 0x00},
	{0x333f, 0x00},
	{0x3340, 0x03},
	{0x3341, 0xc8},
	{0x3342, 0x02},
	{0x3343, 0x24},
	{0x3344, 0x00},
	{0x3345, 0x00},
	{0x3346, 0x00},
	{0x3347, 0x00},
	{0x3348, 0x40},
	{0x3349, 0x00},
	{0x334a, 0x00},
	{0x334b, 0x00},
	{0x334c, 0x00},
	{0x334d, 0x00},
	{0x334e, 0x80},
	{0x3360, 0x01},
	{0x3361, 0x00},
	{0x3362, 0x01},
	{0x3363, 0x00},
	{0x3364, 0x01},
	{0x3365, 0x00},
	{0x3366, 0x01},
	{0x3367, 0x00},
	{0x3368, 0x01},
	{0x3369, 0x00},
	{0x336a, 0x01},
	{0x336b, 0x00},
	{0x336c, 0x01},
	{0x336d, 0x00},
	{0x336e, 0x01},
	{0x336f, 0x00},
	{0x3370, 0x01},
	{0x3371, 0x00},
	{0x3372, 0x01},
	{0x3373, 0x00},
	{0x3374, 0x01},
	{0x3375, 0x00},
	{0x3376, 0x01},
	{0x3377, 0x00},
	{0x3378, 0x00},
	{0x3379, 0x00},
	{0x337a, 0x00},
	{0x337b, 0x00},
	{0x337c, 0x00},
	{0x337d, 0x00},
	{0x337e, 0x00},
	{0x337f, 0x00},
	{0x3380, 0x00},
	{0x3381, 0x00},
	{0x3382, 0x00},
	{0x3383, 0x00},
	{0x3384, 0x00},
	{0x3385, 0x00},
	{0x3386, 0x00},
	{0x3387, 0x00},
	{0x3388, 0x00},
	{0x3389, 0x00},
	{0x338a, 0x00},
	{0x338b, 0x00},
	{0x338c, 0x00},
	{0x338d, 0x00},
	{0x338e, 0x00},
	{0x338f, 0x00},
	{0x3390, 0x00},
	{0x3391, 0x00},
	{0x3392, 0x00},
	{0x3393, 0x00},
	{0x3394, 0x00},
	{0x3395, 0x00},
	{0x3396, 0x00},
	{0x3397, 0x00},
	{0x3398, 0x00},
	{0x3399, 0x00},
	{0x339a, 0x00},
	{0x339b, 0x00},
	{0x33b0, 0x00},
	{0x33b1, 0x50},
	{0x33b2, 0x01},
	{0x33b3, 0xff},
	{0x33b4, 0xe0},
	{0x33b5, 0x6b},
	{0x33b6, 0x00},
	{0x33b7, 0x00},
	{0x33b8, 0x00},
	{0x33b9, 0x00},
	{0x33ba, 0x00},
	{0x33bb, 0x1f},
	{0x33bc, 0x01},
	{0x33bd, 0x01},
	{0x33be, 0x01},
	{0x33bf, 0x01},
	{0x33c0, 0x00},
	{0x33c1, 0x00},
	{0x33c2, 0x00},
	{0x33c3, 0x00},
	{0x33e0, 0x14},
	{0x33e1, 0x0f},
	{0x33e2, 0x02},
	{0x33e3, 0x01},
	{0x33e4, 0x01},
	{0x33e5, 0x01},
	{0x33e6, 0x00},
	{0x33e7, 0x04},
	{0x33e8, 0x0c},
	{0x33e9, 0x02},
	{0x33ea, 0x02},
	{0x33eb, 0x02},
	{0x33ec, 0x03},
	{0x33ed, 0x01},
	{0x33ee, 0x02},
	{0x33ef, 0x08},
	{0x33f0, 0x08},
	{0x33f1, 0x04},
	{0x33f2, 0x04},
	{0x33f3, 0x00},
	{0x33f4, 0x03},
	{0x33f5, 0x14},
	{0x33f6, 0x0f},
	{0x33f7, 0x02},
	{0x33f8, 0x01},
	{0x33f9, 0x01},
	{0x33fa, 0x01},
	{0x33fb, 0x00},
	{0x33fc, 0x04},
	{0x33fd, 0x0c},
	{0x33fe, 0x02},
	{0x33ff, 0x02},
	{0x3400, 0x02},
	{0x3401, 0x03},
	{0x3402, 0x01},
	{0x3403, 0x02},
	{0x3404, 0x08},
	{0x3405, 0x08},
	{0x3406, 0x04},
	{0x3407, 0x04},
	{0x3408, 0x00},
	{0x3409, 0x03},
	{0x340a, 0x14},
	{0x340b, 0x0f},
	{0x340c, 0x04},
	{0x340d, 0x02},
	{0x340e, 0x01},
	{0x340f, 0x01},
	{0x3410, 0x00},
	{0x3411, 0x04},
	{0x3412, 0x0c},
	{0x3413, 0x00},
	{0x3414, 0x01},
	{0x3415, 0x02},
	{0x3416, 0x03},
	{0x3417, 0x02},
	{0x3418, 0x05},
	{0x3419, 0x0a},
	{0x341a, 0x08},
	{0x341b, 0x04},
	{0x341c, 0x04},
	{0x341d, 0x00},
	{0x341e, 0x03},
	{0x3440, 0x00},
	{0x3441, 0x00},
	{0x3442, 0x00},
	{0x3443, 0x00},
	{0x3444, 0x02},
	{0x3445, 0xf0},
	{0x3446, 0x02},
	{0x3447, 0x08},
	{0x3448, 0x00},
	{0x3460, 0x40},
	{0x3461, 0x40},
	{0x3462, 0x40},
	{0x3463, 0x40},
	{0x3464, 0x03},
	{0x3465, 0x01},
	{0x3466, 0x01},
	{0x3467, 0x02},
	{0x3468, 0x30},
	{0x3469, 0x00},
	{0x346a, 0x33},
	{0x346b, 0xbf},
	{0x3480, 0x40},
	{0x3481, 0x00},
	{0x3482, 0x00},
	{0x3483, 0x00},
	{0x3484, 0x0d},
	{0x3485, 0x00},
	{0x3486, 0x00},
	{0x3487, 0x00},
	{0x3488, 0x00},
	{0x3489, 0x00},
	{0x348a, 0x00},
	{0x348b, 0x04},
	{0x348c, 0x00},
	{0x348d, 0x01},
	{0x348f, 0x01},
	{0x3030, 0x0a},
	{0x3030, 0x02},
	{0x7000, 0x58},
	{0x7001, 0x7a},
	{0x7002, 0x1a},
	{0x7003, 0xc1},
	{0x7004, 0x03},
	{0x7005, 0xda},
	{0x7006, 0xbd},
	{0x7007, 0x03},
	{0x7008, 0xbd},
	{0x7009, 0x06},
	{0x700a, 0xe6},
	{0x700b, 0xec},
	{0x700c, 0xbc},
	{0x700d, 0xff},
	{0x700e, 0xbc},
	{0x700f, 0x73},
	{0x7010, 0xda},
	{0x7011, 0x72},
	{0x7012, 0x76},
	{0x7013, 0xb6},
	{0x7014, 0xee},
	{0x7015, 0xcf},
	{0x7016, 0xac},
	{0x7017, 0xd0},
	{0x7018, 0xac},
	{0x7019, 0xd1},
	{0x701a, 0x50},
	{0x701b, 0xac},
	{0x701c, 0xd2},
	{0x701d, 0xbc},
	{0x701e, 0x2e},
	{0x701f, 0xb4},
	{0x7020, 0x00},
	{0x7021, 0xdc},
	{0x7022, 0xdf},
	{0x7023, 0xb0},
	{0x7024, 0x6e},
	{0x7025, 0xbd},
	{0x7026, 0x01},
	{0x7027, 0xd7},
	{0x7028, 0xed},
	{0x7029, 0xe1},
	{0x702a, 0x36},
	{0x702b, 0x30},
	{0x702c, 0xd3},
	{0x702d, 0x2e},
	{0x702e, 0x54},
	{0x702f, 0x46},
	{0x7030, 0xbc},
	{0x7031, 0x22},
	{0x7032, 0x66},
	{0x7033, 0xbc},
	{0x7034, 0x24},
	{0x7035, 0x2c},
	{0x7036, 0x28},
	{0x7037, 0xbc},
	{0x7038, 0x3c},
	{0x7039, 0xa1},
	{0x703a, 0xac},
	{0x703b, 0xd8},
	{0x703c, 0xd6},
	{0x703d, 0xb4},
	{0x703e, 0x04},
	{0x703f, 0x46},
	{0x7040, 0xb7},
	{0x7041, 0x04},
	{0x7042, 0xbe},
	{0x7043, 0x08},
	{0x7044, 0xc3},
	{0x7045, 0xd9},
	{0x7046, 0xad},
	{0x7047, 0xc3},
	{0x7048, 0xbc},
	{0x7049, 0x19},
	{0x704a, 0xc1},
	{0x704b, 0x27},
	{0x704c, 0xe7},
	{0x704d, 0x00},
	{0x704e, 0x50},
	{0x704f, 0x20},
	{0x7050, 0xb8},
	{0x7051, 0x02},
	{0x7052, 0xbc},
	{0x7053, 0x17},
	{0x7054, 0xdb},
	{0x7055, 0xc7},
	{0x7056, 0xb8},
	{0x7057, 0x00},
	{0x7058, 0x28},
	{0x7059, 0x54},
	{0x705a, 0xb4},
	{0x705b, 0x14},
	{0x705c, 0xab},
	{0x705d, 0xbe},
	{0x705e, 0x06},
	{0x705f, 0xd8},
	{0x7060, 0xd6},
	{0x7061, 0x00},
	{0x7062, 0xb4},
	{0x7063, 0xc7},
	{0x7064, 0x07},
	{0x7065, 0xb9},
	{0x7066, 0x05},
	{0x7067, 0xee},
	{0x7068, 0xe6},
	{0x7069, 0xad},
	{0x706a, 0xb4},
	{0x706b, 0x26},
	{0x706c, 0x19},
	{0x706d, 0xc1},
	{0x706e, 0x3a},
	{0x706f, 0xc3},
	{0x7070, 0xaf},
	{0x7071, 0x00},
	{0x7072, 0xc0},
	{0x7073, 0x3c},
	{0x7074, 0xc3},
	{0x7075, 0xbe},
	{0x7076, 0xe7},
	{0x7077, 0x00},
	{0x7078, 0x15},
	{0x7079, 0xc2},
	{0x707a, 0x40},
	{0x707b, 0xc3},
	{0x707c, 0xa4},
	{0x707d, 0xc0},
	{0x707e, 0x3c},
	{0x707f, 0x00},
	{0x7080, 0xb9},
	{0x7081, 0x64},
	{0x7082, 0x29},
	{0x7083, 0x00},
	{0x7084, 0xb8},
	{0x7085, 0x12},
	{0x7086, 0xbe},
	{0x7087, 0x01},
	{0x7088, 0xd0},
	{0x7089, 0xbc},
	{0x708a, 0x01},
	{0x708b, 0xac},
	{0x708c, 0x37},
	{0x708d, 0xd2},
	{0x708e, 0xac},
	{0x708f, 0x45},
	{0x7090, 0xad},
	{0x7091, 0x28},
	{0x7092, 0x00},
	{0x7093, 0xb8},
	{0x7094, 0x00},
	{0x7095, 0xbc},
	{0x7096, 0x01},
	{0x7097, 0x36},
	{0x7098, 0xd3},
	{0x7099, 0x30},
	{0x709a, 0x04},
	{0x709b, 0xe0},
	{0x709c, 0xd8},
	{0x709d, 0xb4},
	{0x709e, 0xe9},
	{0x709f, 0x00},
	{0x70a0, 0xbe},
	{0x70a1, 0x05},
	{0x70a2, 0x62},
	{0x70a3, 0x07},
	{0x70a4, 0xb9},
	{0x70a5, 0x05},
	{0x70a6, 0xad},
	{0x70a7, 0xc3},
	{0x70a8, 0xcf},
	{0x70a9, 0x00},
	{0x70aa, 0x15},
	{0x70ab, 0xc2},
	{0x70ac, 0x59},
	{0x70ad, 0xc3},
	{0x70ae, 0xc9},
	{0x70af, 0xc0},
	{0x70b0, 0x55},
	{0x70b1, 0x00},
	{0x70b2, 0x46},
	{0x70b3, 0xa1},
	{0x70b4, 0xb9},
	{0x70b5, 0x64},
	{0x70b6, 0x29},
	{0x70b7, 0x00},
	{0x70b8, 0xb8},
	{0x70b9, 0x02},
	{0x70ba, 0xbe},
	{0x70bb, 0x02},
	{0x70bc, 0xd0},
	{0x70bd, 0xdc},
	{0x70be, 0xac},
	{0x70bf, 0xbc},
	{0x70c0, 0x01},
	{0x70c1, 0x37},
	{0x70c2, 0xac},
	{0x70c3, 0xd2},
	{0x70c4, 0x45},
	{0x70c5, 0xad},
	{0x70c6, 0x28},
	{0x70c7, 0x00},
	{0x70c8, 0xb8},
	{0x70c9, 0x00},
	{0x70ca, 0xbc},
	{0x70cb, 0x01},
	{0x70cc, 0x36},
	{0x70cd, 0x30},
	{0x70ce, 0xe0},
	{0x70cf, 0xd8},
	{0x70d0, 0xb5},
	{0x70d1, 0x0b},
	{0x70d2, 0xd6},
	{0x70d3, 0xbe},
	{0x70d4, 0x07},
	{0x70d5, 0x00},
	{0x70d6, 0x62},
	{0x70d7, 0x07},
	{0x70d8, 0xb9},
	{0x70d9, 0x05},
	{0x70da, 0xad},
	{0x70db, 0xc3},
	{0x70dc, 0xcf},
	{0x70dd, 0x46},
	{0x70de, 0xcd},
	{0x70df, 0x07},
	{0x70e0, 0xcd},
	{0x70e1, 0x00},
	{0x70e2, 0xe3},
	{0x70e3, 0x18},
	{0x70e4, 0xc2},
	{0x70e5, 0xa2},
	{0x70e6, 0xb9},
	{0x70e7, 0x64},
	{0x70e8, 0xd1},
	{0x70e9, 0xdd},
	{0x70ea, 0xac},
	{0x70eb, 0xcf},
	{0x70ec, 0xdf},
	{0x70ed, 0xb5},
	{0x70ee, 0x19},
	{0x70ef, 0x46},
	{0x70f0, 0x50},
	{0x70f1, 0xb6},
	{0x70f2, 0xee},
	{0x70f3, 0xe8},
	{0x70f4, 0xe6},
	{0x70f5, 0xbc},
	{0x70f6, 0x31},
	{0x70f7, 0xe1},
	{0x70f8, 0x36},
	{0x70f9, 0x30},
	{0x70fa, 0xd3},
	{0x70fb, 0x2e},
	{0x70fc, 0x54},
	{0x70fd, 0xbd},
	{0x70fe, 0x03},
	{0x70ff, 0xec},
	{0x7100, 0x2c},
	{0x7101, 0x50},
	{0x7102, 0x20},
	{0x7103, 0x04},
	{0x7104, 0xb8},
	{0x7105, 0x02},
	{0x7106, 0xbc},
	{0x7107, 0x18},
	{0x7108, 0xc7},
	{0x7109, 0xb8},
	{0x710a, 0x00},
	{0x710b, 0x28},
	{0x710c, 0x54},
	{0x710d, 0xbc},
	{0x710e, 0x02},
	{0x710f, 0xb4},
	{0x7110, 0xda},
	{0x7111, 0xbe},
	{0x7112, 0x04},
	{0x7113, 0xd6},
	{0x7114, 0xd8},
	{0x7115, 0xab},
	{0x7116, 0x00},
	{0x7117, 0x62},
	{0x7118, 0x07},
	{0x7119, 0xb9},
	{0x711a, 0x05},
	{0x711b, 0xad},
	{0x711c, 0xc3},
	{0x711d, 0xbc},
	{0x711e, 0xe7},
	{0x711f, 0xb9},
	{0x7120, 0x64},
	{0x7121, 0x29},
	{0x7122, 0x00},
	{0x7123, 0xb8},
	{0x7124, 0x02},
	{0x7125, 0xbe},
	{0x7126, 0x00},
	{0x7127, 0x45},
	{0x7128, 0xad},
	{0x7129, 0xe2},
	{0x712a, 0x28},
	{0x712b, 0x00},
	{0x712c, 0xb8},
	{0x712d, 0x00},
	{0x712e, 0xe0},
	{0x712f, 0xd8},
	{0x7130, 0xb4},
	{0x7131, 0xe9},
	{0x7132, 0xbe},
	{0x7133, 0x03},
	{0x7134, 0x00},
	{0x7135, 0x30},
	{0x7136, 0x62},
	{0x7137, 0x07},
	{0x7138, 0xb9},
	{0x7139, 0x05},
	{0x713a, 0xad},
	{0x713b, 0xc3},
	{0x713c, 0xcf},
	{0x713d, 0x42},
	{0x713e, 0xe4},
	{0x713f, 0xcd},
	{0x7140, 0x07},
	{0x7141, 0xcd},
	{0x7142, 0x00},
	{0x7143, 0x00},
	{0x7144, 0x17},
	{0x7145, 0xc2},
	{0x7146, 0xbb},
	{0x7147, 0xde},
	{0x7148, 0xcf},
	{0x7149, 0xdf},
	{0x714a, 0xac},
	{0x714b, 0xd1},
	{0x714c, 0x44},
	{0x714d, 0xac},
	{0x714e, 0xb9},
	{0x714f, 0x76},
	{0x7150, 0xb8},
	{0x7151, 0x08},
	{0x7152, 0xb6},
	{0x7153, 0xfe},
	{0x7154, 0xb4},
	{0x7155, 0xca},
	{0x7156, 0xd6},
	{0x7157, 0xd8},
	{0x7158, 0xab},
	{0x7159, 0x00},
	{0x715a, 0xe1},
	{0x715b, 0x36},
	{0x715c, 0x30},
	{0x715d, 0xd3},
	{0x715e, 0xbc},
	{0x715f, 0x29},
	{0x7160, 0xb4},
	{0x7161, 0x1f},
	{0x7162, 0xaa},
	{0x7163, 0xbd},
	{0x7164, 0x01},
	{0x7165, 0xb8},
	{0x7166, 0x0c},
	{0x7167, 0x45},
	{0x7168, 0xa4},
	{0x7169, 0xbd},
	{0x716a, 0x03},
	{0x716b, 0xec},
	{0x716c, 0xbc},
	{0x716d, 0x3d},
	{0x716e, 0xc3},
	{0x716f, 0xcf},
	{0x7170, 0x42},
	{0x7171, 0xb8},
	{0x7172, 0x00},
	{0x7173, 0xe4},
	{0x7174, 0xd5},
	{0x7175, 0x00},
	{0x7176, 0xb6},
	{0x7177, 0x00},
	{0x7178, 0x74},
	{0x7179, 0xbd},
	{0x717a, 0x03},
	{0x717b, 0x40},
	{0x717c, 0xb5},
	{0x717d, 0x39},
	{0x717e, 0x58},
	{0x717f, 0xdd},
	{0x7180, 0x19},
	{0x7181, 0xc1},
	{0x7182, 0xc8},
	{0x7183, 0xbd},
	{0x7184, 0x06},
	{0x7185, 0x17},
	{0x7186, 0xc1},
	{0x7187, 0xc6},
	{0x7188, 0xe8},
	{0x7189, 0x00},
	{0x718a, 0xc0},
	{0x718b, 0xc8},
	{0x718c, 0xe6},
	{0x718d, 0x95},
	{0x718e, 0x15},
	{0x718f, 0x00},
	{0x7190, 0xbc},
	{0x7191, 0x19},
	{0x7192, 0xb9},
	{0x7193, 0xf6},
	{0x7194, 0x14},
	{0x7195, 0xc1},
	{0x7196, 0xd0},
	{0x7197, 0xd1},
	{0x7198, 0xac},
	{0x7199, 0x37},
	{0x719a, 0xbc},
	{0x719b, 0x35},
	{0x719c, 0x36},
	{0x719d, 0x30},
	{0x719e, 0xe1},
	{0x719f, 0xd3},
	{0x71a0, 0x7a},
	{0x71a1, 0xb6},
	{0x71a2, 0x0c},
	{0x71a3, 0xff},
	{0x71a4, 0xb4},
	{0x71a5, 0xc7},
	{0x71a6, 0xd9},
	{0x71a7, 0x00},
	{0x71a8, 0xbd},
	{0x71a9, 0x01},
	{0x71aa, 0x56},
	{0x71ab, 0xc0},
	{0x71ac, 0xda},
	{0x71ad, 0xb4},
	{0x71ae, 0x1f},
	{0x71af, 0x56},
	{0x71b0, 0xaa},
	{0x71b1, 0xbc},
	{0x71b2, 0x08},
	{0x71b3, 0x00},
	{0x71b4, 0x57},
	{0x71b5, 0xe8},
	{0x71b6, 0xb5},
	{0x71b7, 0x36},
	{0x71b8, 0x00},
	{0x71b9, 0x54},
	{0x71ba, 0xe7},
	{0x71bb, 0xc8},
	{0x71bc, 0xb4},
	{0x71bd, 0x1f},
	{0x71be, 0x56},
	{0x71bf, 0xaa},
	{0x71c0, 0xbc},
	{0x71c1, 0x08},
	{0x71c2, 0x57},
	{0x71c3, 0x00},
	{0x71c4, 0xb5},
	{0x71c5, 0x36},
	{0x71c6, 0x00},
	{0x71c7, 0x54},
	{0x71c8, 0xc8},
	{0x71c9, 0xb5},
	{0x71ca, 0x18},
	{0x71cb, 0xd9},
	{0x71cc, 0x00},
	{0x71cd, 0xbd},
	{0x71ce, 0x01},
	{0x71cf, 0x56},
	{0x71d0, 0x08},
	{0x71d1, 0x57},
	{0x71d2, 0xe8},
	{0x71d3, 0xb4},
	{0x71d4, 0x42},
	{0x71d5, 0x00},
	{0x71d6, 0x54},
	{0x71d7, 0xe7},
	{0x71d8, 0xc8},
	{0x71d9, 0xab},
	{0x71da, 0x00},
	{0x71db, 0x66},
	{0x71dc, 0x62},
	{0x71dd, 0x06},
	{0x71de, 0x74},
	{0x71df, 0xb9},
	{0x71e0, 0x05},
	{0x71e1, 0xb7},
	{0x71e2, 0x14},
	{0x71e3, 0x0e},
	{0x71e4, 0xb7},
	{0x71e5, 0x04},
	{0x71e6, 0xc8},
	{0x7600, 0x04},
	{0x7601, 0x80},
	{0x7602, 0x07},
	{0x7603, 0x44},
	{0x7604, 0x05},
	{0x7605, 0x33},
	{0x7606, 0x0f},
	{0x7607, 0x00},
	{0x7608, 0x07},
	{0x7609, 0x40},
	{0x760a, 0x04},
	{0x760b, 0xe5},
	{0x760c, 0x06},
	{0x760d, 0x50},
	{0x760e, 0x04},
	{0x760f, 0xe4},
	{0x7610, 0x00},
	{0x7611, 0x00},
	{0x7612, 0x06},
	{0x7613, 0x5c},
	{0x7614, 0x00},
	{0x7615, 0x0f},
	{0x7616, 0x06},
	{0x7617, 0x1c},
	{0x7618, 0x00},
	{0x7619, 0x02},
	{0x761a, 0x06},
	{0x761b, 0xa2},
	{0x761c, 0x00},
	{0x761d, 0x01},
	{0x761e, 0x06},
	{0x761f, 0xae},
	{0x7620, 0x00},
	{0x7621, 0x0e},
	{0x7622, 0x05},
	{0x7623, 0x30},
	{0x7624, 0x07},
	{0x7625, 0x00},
	{0x7626, 0x0f},
	{0x7627, 0x00},
	{0x7628, 0x04},
	{0x7629, 0xe5},
	{0x762a, 0x05},
	{0x762b, 0x33},
	{0x762c, 0x06},
	{0x762d, 0x12},
	{0x762e, 0x00},
	{0x762f, 0x01},
	{0x7630, 0x06},
	{0x7631, 0x52},
	{0x7632, 0x00},
	{0x7633, 0x01},
	{0x7634, 0x06},
	{0x7635, 0x5e},
	{0x7636, 0x04},
	{0x7637, 0xe4},
	{0x7638, 0x00},
	{0x7639, 0x01},
	{0x763a, 0x05},
	{0x763b, 0x30},
	{0x763c, 0x0f},
	{0x763d, 0x00},
	{0x763e, 0x06},
	{0x763f, 0xa6},
	{0x7640, 0x00},
	{0x7641, 0x02},
	{0x7642, 0x06},
	{0x7643, 0x26},
	{0x7644, 0x00},
	{0x7645, 0x02},
	{0x7646, 0x05},
	{0x7647, 0x33},
	{0x7648, 0x06},
	{0x7649, 0x20},
	{0x764a, 0x0f},
	{0x764b, 0x00},
	{0x764c, 0x06},
	{0x764d, 0x56},
	{0x764e, 0x00},
	{0x764f, 0x02},
	{0x7650, 0x06},
	{0x7651, 0x16},
	{0x7652, 0x05},
	{0x7653, 0x33},
	{0x7654, 0x06},
	{0x7655, 0x10},
	{0x7656, 0x0f},
	{0x7657, 0x00},
	{0x7658, 0x06},
	{0x7659, 0x10},
	{0x765a, 0x0f},
	{0x765b, 0x00},
	{0x765c, 0x06},
	{0x765d, 0x20},
	{0x765e, 0x0f},
	{0x765f, 0x00},
	{0x7660, 0x00},
	{0x7661, 0x00},
	{0x7662, 0x00},
	{0x7663, 0x02},
	{0x7664, 0x04},
	{0x7665, 0xe5},
	{0x7666, 0x04},
	{0x7667, 0xe4},
	{0x7668, 0x0f},
	{0x7669, 0x00},
	{0x766a, 0x00},
	{0x766b, 0x00},
	{0x766c, 0x00},
	{0x766d, 0x01},
	{0x766e, 0x04},
	{0x766f, 0xe5},
	{0x7670, 0x04},
	{0x7671, 0xe4},
	{0x7672, 0x0f},
	{0x7673, 0x00},
	{0x7674, 0x00},
	{0x7675, 0x02},
	{0x7676, 0x04},
	{0x7677, 0xe4},
	{0x7678, 0x00},
	{0x7679, 0x02},
	{0x767a, 0x04},
	{0x767b, 0xc4},
	{0x767c, 0x00},
	{0x767d, 0x02},
	{0x767e, 0x04},
	{0x767f, 0xc4},
	{0x7680, 0x05},
	{0x7681, 0x83},
	{0x7682, 0x0f},
	{0x7683, 0x00},
	{0x7684, 0x00},
	{0x7685, 0x02},
	{0x7686, 0x04},
	{0x7687, 0xe4},
	{0x7688, 0x00},
	{0x7689, 0x02},
	{0x768a, 0x04},
	{0x768b, 0xc4},
	{0x768c, 0x00},
	{0x768d, 0x02},
	{0x768e, 0x04},
	{0x768f, 0xc4},
	{0x7690, 0x05},
	{0x7691, 0x83},
	{0x7692, 0x03},
	{0x7693, 0x0b},
	{0x7694, 0x05},
	{0x7695, 0x83},
	{0x7696, 0x00},
	{0x7697, 0x07},
	{0x7698, 0x05},
	{0x7699, 0x03},
	{0x769a, 0x00},
	{0x769b, 0x05},
	{0x769c, 0x05},
	{0x769d, 0x32},
	{0x769e, 0x05},
	{0x769f, 0x30},
	{0x76a0, 0x00},
	{0x76a1, 0x02},
	{0x76a2, 0x05},
	{0x76a3, 0x78},
	{0x76a4, 0x00},
	{0x76a5, 0x01},
	{0x76a6, 0x05},
	{0x76a7, 0x7c},
	{0x76a8, 0x03},
	{0x76a9, 0x9a},
	{0x76aa, 0x05},
	{0x76ab, 0x83},
	{0x76ac, 0x00},
	{0x76ad, 0x04},
	{0x76ae, 0x05},
	{0x76af, 0x03},
	{0x76b0, 0x00},
	{0x76b1, 0x03},
	{0x76b2, 0x05},
	{0x76b3, 0x32},
	{0x76b4, 0x05},
	{0x76b5, 0x30},
	{0x76b6, 0x00},
	{0x76b7, 0x02},
	{0x76b8, 0x05},
	{0x76b9, 0x78},
	{0x76ba, 0x00},
	{0x76bb, 0x01},
	{0x76bc, 0x05},
	{0x76bd, 0x7c},
	{0x76be, 0x03},
	{0x76bf, 0x99},
	{0x76c0, 0x05},
	{0x76c1, 0x83},
	{0x76c2, 0x00},
	{0x76c3, 0x03},
	{0x76c4, 0x05},
	{0x76c5, 0x03},
	{0x76c6, 0x00},
	{0x76c7, 0x01},
	{0x76c8, 0x05},
	{0x76c9, 0x32},
	{0x76ca, 0x05},
	{0x76cb, 0x30},
	{0x76cc, 0x00},
	{0x76cd, 0x02},
	{0x76ce, 0x05},
	{0x76cf, 0x78},
	{0x76d0, 0x00},
	{0x76d1, 0x01},
	{0x76d2, 0x05},
	{0x76d3, 0x7c},
	{0x76d4, 0x03},
	{0x76d5, 0x98},
	{0x76d6, 0x05},
	{0x76d7, 0x83},
	{0x76d8, 0x00},
	{0x76d9, 0x00},
	{0x76da, 0x05},
	{0x76db, 0x03},
	{0x76dc, 0x00},
	{0x76dd, 0x01},
	{0x76de, 0x05},
	{0x76df, 0x32},
	{0x76e0, 0x05},
	{0x76e1, 0x30},
	{0x76e2, 0x00},
	{0x76e3, 0x02},
	{0x76e4, 0x05},
	{0x76e5, 0x78},
	{0x76e6, 0x00},
	{0x76e7, 0x01},
	{0x76e8, 0x05},
	{0x76e9, 0x7c},
	{0x76ea, 0x03},
	{0x76eb, 0x97},
	{0x76ec, 0x05},
	{0x76ed, 0x83},
	{0x76ee, 0x00},
	{0x76ef, 0x00},
	{0x76f0, 0x05},
	{0x76f1, 0x03},
	{0x76f2, 0x05},
	{0x76f3, 0x32},
	{0x76f4, 0x05},
	{0x76f5, 0x30},
	{0x76f6, 0x00},
	{0x76f7, 0x02},
	{0x76f8, 0x05},
	{0x76f9, 0x78},
	{0x76fa, 0x00},
	{0x76fb, 0x01},
	{0x76fc, 0x05},
	{0x76fd, 0x7c},
	{0x76fe, 0x03},
	{0x76ff, 0x96},
	{0x7700, 0x05},
	{0x7701, 0x83},
	{0x7702, 0x05},
	{0x7703, 0x03},
	{0x7704, 0x05},
	{0x7705, 0x32},
	{0x7706, 0x05},
	{0x7707, 0x30},
	{0x7708, 0x00},
	{0x7709, 0x02},
	{0x770a, 0x05},
	{0x770b, 0x78},
	{0x770c, 0x00},
	{0x770d, 0x01},
	{0x770e, 0x05},
	{0x770f, 0x7c},
	{0x7710, 0x03},
	{0x7711, 0x95},
	{0x7712, 0x05},
	{0x7713, 0x83},
	{0x7714, 0x05},
	{0x7715, 0x03},
	{0x7716, 0x05},
	{0x7717, 0x32},
	{0x7718, 0x05},
	{0x7719, 0x30},
	{0x771a, 0x00},
	{0x771b, 0x02},
	{0x771c, 0x05},
	{0x771d, 0x78},
	{0x771e, 0x00},
	{0x771f, 0x01},
	{0x7720, 0x05},
	{0x7721, 0x7c},
	{0x7722, 0x03},
	{0x7723, 0x94},
	{0x7724, 0x05},
	{0x7725, 0x83},
	{0x7726, 0x00},
	{0x7727, 0x01},
	{0x7728, 0x05},
	{0x7729, 0x03},
	{0x772a, 0x00},
	{0x772b, 0x01},
	{0x772c, 0x05},
	{0x772d, 0x32},
	{0x772e, 0x05},
	{0x772f, 0x30},
	{0x7730, 0x00},
	{0x7731, 0x02},
	{0x7732, 0x05},
	{0x7733, 0x78},
	{0x7734, 0x00},
	{0x7735, 0x01},
	{0x7736, 0x05},
	{0x7737, 0x7c},
	{0x7738, 0x03},
	{0x7739, 0x93},
	{0x773a, 0x05},
	{0x773b, 0x83},
	{0x773c, 0x00},
	{0x773d, 0x00},
	{0x773e, 0x05},
	{0x773f, 0x03},
	{0x7740, 0x00},
	{0x7741, 0x00},
	{0x7742, 0x05},
	{0x7743, 0x32},
	{0x7744, 0x05},
	{0x7745, 0x30},
	{0x7746, 0x00},
	{0x7747, 0x02},
	{0x7748, 0x05},
	{0x7749, 0x78},
	{0x774a, 0x00},
	{0x774b, 0x01},
	{0x774c, 0x05},
	{0x774d, 0x7c},
	{0x774e, 0x03},
	{0x774f, 0x92},
	{0x7750, 0x05},
	{0x7751, 0x83},
	{0x7752, 0x05},
	{0x7753, 0x03},
	{0x7754, 0x00},
	{0x7755, 0x00},
	{0x7756, 0x05},
	{0x7757, 0x32},
	{0x7758, 0x05},
	{0x7759, 0x30},
	{0x775a, 0x00},
	{0x775b, 0x02},
	{0x775c, 0x05},
	{0x775d, 0x78},
	{0x775e, 0x00},
	{0x775f, 0x01},
	{0x7760, 0x05},
	{0x7761, 0x7c},
	{0x7762, 0x03},
	{0x7763, 0x91},
	{0x7764, 0x05},
	{0x7765, 0x83},
	{0x7766, 0x05},
	{0x7767, 0x03},
	{0x7768, 0x05},
	{0x7769, 0x32},
	{0x776a, 0x05},
	{0x776b, 0x30},
	{0x776c, 0x00},
	{0x776d, 0x02},
	{0x776e, 0x05},
	{0x776f, 0x78},
	{0x7770, 0x00},
	{0x7771, 0x01},
	{0x7772, 0x05},
	{0x7773, 0x7c},
	{0x7774, 0x03},
	{0x7775, 0x90},
	{0x7776, 0x05},
	{0x7777, 0x83},
	{0x7778, 0x05},
	{0x7779, 0x03},
	{0x777a, 0x05},
	{0x777b, 0x32},
	{0x777c, 0x05},
	{0x777d, 0x30},
	{0x777e, 0x00},
	{0x777f, 0x02},
	{0x7780, 0x05},
	{0x7781, 0x78},
	{0x7782, 0x00},
	{0x7783, 0x01},
	{0x7784, 0x05},
	{0x7785, 0x7c},
	{0x7786, 0x02},
	{0x7787, 0x90},
	{0x7788, 0x05},
	{0x7789, 0x03},
	{0x778a, 0x07},
	{0x778b, 0x00},
	{0x778c, 0x0f},
	{0x778d, 0x00},
	{0x778e, 0x08},
	{0x778f, 0x30},
	{0x7790, 0x08},
	{0x7791, 0xee},
	{0x7792, 0x0f},
	{0x7793, 0x00},
	{0x7794, 0x05},
	{0x7795, 0x33},
	{0x7796, 0x04},
	{0x7797, 0xe5},
	{0x7798, 0x06},
	{0x7799, 0x52},
	{0x779a, 0x04},
	{0x779b, 0xe4},
	{0x779c, 0x00},
	{0x779d, 0x00},
	{0x779e, 0x06},
	{0x779f, 0x5e},
	{0x77a0, 0x00},
	{0x77a1, 0x0f},
	{0x77a2, 0x06},
	{0x77a3, 0x1e},
	{0x77a4, 0x00},
	{0x77a5, 0x02},
	{0x77a6, 0x06},
	{0x77a7, 0xa2},
	{0x77a8, 0x00},
	{0x77a9, 0x01},
	{0x77aa, 0x06},
	{0x77ab, 0xae},
	{0x77ac, 0x00},
	{0x77ad, 0x03},
	{0x77ae, 0x05},
	{0x77af, 0x30},
	{0x77b0, 0x09},
	{0x77b1, 0x19},
	{0x77b2, 0x0f},
	{0x77b3, 0x00},
	{0x77b4, 0x05},
	{0x77b5, 0x33},
	{0x77b6, 0x04},
	{0x77b7, 0xe5},
	{0x77b8, 0x06},
	{0x77b9, 0x52},
	{0x77ba, 0x04},
	{0x77bb, 0xe4},
	{0x77bc, 0x00},
	{0x77bd, 0x00},
	{0x77be, 0x06},
	{0x77bf, 0x5e},
	{0x77c0, 0x00},
	{0x77c1, 0x0f},
	{0x77c2, 0x06},
	{0x77c3, 0x1e},
	{0x77c4, 0x00},
	{0x77c5, 0x02},
	{0x77c6, 0x06},
	{0x77c7, 0xa2},
	{0x77c8, 0x00},
	{0x77c9, 0x01},
	{0x77ca, 0x06},
	{0x77cb, 0xae},
	{0x77cc, 0x00},
	{0x77cd, 0x03},
	{0x77ce, 0x05},
	{0x77cf, 0x30},
	{0x77d0, 0x0f},
	{0x77d1, 0x00},
	{0x77d2, 0x00},
	{0x77d3, 0x00},
	{0x77d4, 0x00},
	{0x77d5, 0x02},
	{0x77d6, 0x04},
	{0x77d7, 0xe5},
	{0x77d8, 0x04},
	{0x77d9, 0xe4},
	{0x77da, 0x05},
	{0x77db, 0x33},
	{0x77dc, 0x07},
	{0x77dd, 0x10},
	{0x77de, 0x00},
	{0x77df, 0x00},
	{0x77e0, 0x01},
	{0x77e1, 0xbb},
	{0x77e2, 0x00},
	{0x77e3, 0x00},
	{0x77e4, 0x01},
	{0x77e5, 0xaa},
	{0x77e6, 0x00},
	{0x77e7, 0x00},
	{0x77e8, 0x01},
	{0x77e9, 0x99},
	{0x77ea, 0x00},
	{0x77eb, 0x00},
	{0x77ec, 0x01},
	{0x77ed, 0x88},
	{0x77ee, 0x00},
	{0x77ef, 0x00},
	{0x77f0, 0x01},
	{0x77f1, 0x77},
	{0x77f2, 0x00},
	{0x77f3, 0x00},
	{0x77f4, 0x01},
	{0x77f5, 0x66},
	{0x77f6, 0x00},
	{0x77f7, 0x00},
	{0x77f8, 0x01},
	{0x77f9, 0x55},
	{0x77fa, 0x00},
	{0x77fb, 0x00},
	{0x77fc, 0x01},
	{0x77fd, 0x44},
	{0x77fe, 0x00},
	{0x77ff, 0x00},
	{0x7800, 0x01},
	{0x7801, 0x33},
	{0x7802, 0x00},
	{0x7803, 0x00},
	{0x7804, 0x01},
	{0x7805, 0x22},
	{0x7806, 0x00},
	{0x7807, 0x00},
	{0x7808, 0x01},
	{0x7809, 0x11},
	{0x780a, 0x00},
	{0x780b, 0x00},
	{0x780c, 0x01},
	{0x780d, 0x00},
	{0x780e, 0x01},
	{0x780f, 0xff},
	{0x7810, 0x07},
	{0x7811, 0x00},
	{0x7812, 0x02},
	{0x7813, 0xa0},
	{0x7814, 0x0f},
	{0x7815, 0x00},
	{0x7816, 0x08},
	{0x7817, 0x35},
	{0x7818, 0x06},
	{0x7819, 0x52},
	{0x781a, 0x04},
	{0x781b, 0xe4},
	{0x781c, 0x00},
	{0x781d, 0x00},
	{0x781e, 0x06},
	{0x781f, 0x5e},
	{0x7820, 0x05},
	{0x7821, 0x33},
	{0x7822, 0x09},
	{0x7823, 0x19},
	{0x7824, 0x06},
	{0x7825, 0x1e},
	{0x7826, 0x05},
	{0x7827, 0x33},
	{0x7828, 0x00},
	{0x7829, 0x01},
	{0x782a, 0x06},
	{0x782b, 0x24},
	{0x782c, 0x06},
	{0x782d, 0x20},
	{0x782e, 0x0f},
	{0x782f, 0x00},
	{0x7830, 0x08},
	{0x7831, 0x35},
	{0x7832, 0x07},
	{0x7833, 0x10},
	{0x7834, 0x00},
	{0x7835, 0x00},
	{0x7836, 0x01},
	{0x7837, 0xbb},
	{0x7838, 0x00},
	{0x7839, 0x00},
	{0x783a, 0x01},
	{0x783b, 0xaa},
	{0x783c, 0x00},
	{0x783d, 0x00},
	{0x783e, 0x01},
	{0x783f, 0x99},
	{0x7840, 0x00},
	{0x7841, 0x00},
	{0x7842, 0x01},
	{0x7843, 0x88},
	{0x7844, 0x00},
	{0x7845, 0x00},
	{0x7846, 0x01},
	{0x7847, 0x77},
	{0x7848, 0x00},
	{0x7849, 0x00},
	{0x784a, 0x01},
	{0x784b, 0x66},
	{0x784c, 0x00},
	{0x784d, 0x00},
	{0x784e, 0x01},
	{0x784f, 0x55},
	{0x7850, 0x00},
	{0x7851, 0x00},
	{0x7852, 0x01},
	{0x7853, 0x44},
	{0x7854, 0x00},
	{0x7855, 0x00},
	{0x7856, 0x01},
	{0x7857, 0x33},
	{0x7858, 0x00},
	{0x7859, 0x00},
	{0x785a, 0x01},
	{0x785b, 0x22},
	{0x785c, 0x00},
	{0x785d, 0x00},
	{0x785e, 0x01},
	{0x785f, 0x11},
	{0x7860, 0x00},
	{0x7861, 0x00},
	{0x7862, 0x01},
	{0x7863, 0x00},
	{0x7864, 0x07},
	{0x7865, 0x00},
	{0x7866, 0x01},
	{0x7867, 0xff},
	{0x7868, 0x02},
	{0x7869, 0xa0},
	{0x786a, 0x0f},
	{0x786b, 0x00},
	{0x786c, 0x08},
	{0x786d, 0x3a},
	{0x786e, 0x08},
	{0x786f, 0x6a},
	{0x7870, 0x0f},
	{0x7871, 0x00},
	{0x7872, 0x04},
	{0x7873, 0xc0},
	{0x7874, 0x09},
	{0x7875, 0x19},
	{0x7876, 0x04},
	{0x7877, 0x99},
	{0x7878, 0x07},
	{0x7879, 0x14},
	{0x787a, 0x00},
	{0x787b, 0x01},
	{0x787c, 0x04},
	{0x787d, 0xa4},
	{0x787e, 0x00},
	{0x787f, 0x0f},
	{0x7880, 0x00},
	{0x7881, 0x0f},
	{0x7882, 0x04},
	{0x7883, 0xa6},
	{0x7884, 0x00},
	{0x7885, 0x00},
	{0x7886, 0x04},
	{0x7887, 0xa0},
	{0x7888, 0x04},
	{0x7889, 0x80},
	{0x788a, 0x04},
	{0x788b, 0x00},
	{0x788c, 0x05},
	{0x788d, 0x03},
	{0x788e, 0x06},
	{0x788f, 0x00},
	{0x7890, 0x0f},
	{0x7891, 0x00},
	{0x7892, 0x0f},
	{0x7893, 0x00},
	{0x7894, 0x0f},
	{0x7895, 0x00},
	{0x30a0, 0x00},
	{0x30a1, 0x00},
	{0x30a2, 0x00},
	{0x30a3, 0x00},
	{0x30a4, 0x07},
	{0x30a5, 0x8f},
	{0x30a6, 0x04},
	{0x30a7, 0x47},
	{0x30a8, 0x00},
	{0x30a9, 0x04},
	{0x30aa, 0x00},
	{0x30ab, 0x04},
	{0x30ac, 0x07},
	{0x30ad, 0x88},
	{0x30ae, 0x04},
	{0x30af, 0x40},
	{0x30a0, 0x00},
	{0x30a1, 0x04},
	{0x30a2, 0x00},
	{0x30a3, 0x04},
	{0x30a4, 0x07},
	{0x30a5, 0x8B},
	{0x30a6, 0x04},
	{0x30a7, 0x43},
	{0x30a8, 0x00},
	{0x30a9, 0x04},
	{0x30aa, 0x00},
	{0x30ab, 0x04},
	{0x30ac, 0x07},
	{0x30ad, 0x80},
	{0x30ae, 0x04},
	{0x30af, 0x38},
	{0x3195, 0x26},
	{0x3196, 0x00},
	{0x3197, 0x0A},
	{0x3191, 0xC9},
	{0x31a0, 0x00},
	{0x31e3, 0x01},
	{0x31e4, 0x08},
	{0x31fe, 0x03},
	{0x31a3, 0x08},
	{0x30b0, 0x0d},
	{0x30b1, 0xde},
	{0x30b2, 0x04},
	{0x30b3, 0x66},
	{0x3196, 0x00},
	{0x3197, 0x0a},
	{0x3195, 0x29},
	{0x315a, 0x02},
	{0x315b, 0x00},
	{0x30bb, 0x40},
	{0x3250, 0xf7},
	{REG_NULL, 0x00}
};

/* two lanes,raw 10bit hdr */
static const struct regval ov2718_hdr10bit_init_tab_1920_1080[] = {
	{0x3013, 0x01},
	{REG_DELAY, 0x10},
	{0x0100, 0x43},
	{0x0101, 0x01},
	{0x1000, 0x0f},
	{0x0102, 0x81},
	{0x0001, 0xad},
	{0x0002, 0xad},
	{0x1002, 0x10},
	{0x1007, 0x07},
	{0x1002, 0x18},
	{0x1008, 0x11},
	{0x3000, 0x02},
	{0x3001, 0x28},
	{0x3002, 0x03},
	{0x3003, 0x01},
	{0x3004, 0x02},
	{0x3005, 0x26},
	{0x3006, 0x00},
	{0x3007, 0x07},
	{0x3008, 0x01},
	{0x3009, 0x00},
	{0x300c, 0x6c},
	{0x300e, 0x80},
	{0x300f, 0x00},
	{0x3012, 0x00},
	{0x3013, 0x00},
	{0x3014, 0xc4},
	{0x3015, 0x00},
	{0x3017, 0x00},
	{0x3018, 0x00},
	{0x3019, 0x00},
	{0x301a, 0x00},
	{0x301b, 0x01},
	{0x301e, 0x17},
	{0x301f, 0xe1},
	{0x3030, 0x02},
	{0x3031, 0x72},
	{0x3032, 0xf0},
	{0x3033, 0x30},
	{0x3034, 0x3f},
	{0x3035, 0x5f},
	{0x3036, 0x02},
	{0x3037, 0x9f},
	{0x3038, 0x04},
	{0x3039, 0xb7},
	{0x303a, 0x04},
	{0x303b, 0x07},
	{0x303c, 0xf0},
	{0x303d, 0x00},
	{0x303e, 0x0b},
	{0x303f, 0xe3},
	{0x3040, 0xf3},
	{0x3041, 0x29},
	{0x3042, 0xf6},
	{0x3043, 0x65},
	{0x3044, 0x06},
	{0x3045, 0x0f},
	{0x3046, 0x59},
	{0x3047, 0x07},
	{0x3048, 0x82},
	{0x3049, 0xcf},
	{0x304a, 0x12},
	{0x304b, 0x40},
	{0x304c, 0x33},
	{0x304d, 0xa4},
	{0x304e, 0x0b},
	{0x304f, 0x3d},
	{0x3050, 0x10},
	{0x3060, 0x00},
	{0x3061, 0x64},
	{0x3062, 0x00},
	{0x3063, 0xe4},
	{0x3066, 0x80},
	{0x3080, 0x00},
	{0x3081, 0x00},
	{0x3082, 0x01},
	{0x3083, 0xe3},
	{0x3084, 0x06},
	{0x3085, 0x00},
	{0x3086, 0x10},
	{0x3087, 0x10},
	{0x3089, 0x00},
	{0x308a, 0x01},
	{0x3093, 0x00},
	{0x30a0, 0x00},
	{0x30a1, 0x00},
	{0x30a2, 0x00},
	{0x30a3, 0x00},
	{0x30a4, 0x07},
	{0x30a5, 0x8f},
	{0x30a6, 0x04},
	{0x30a7, 0x47},
	{0x30a8, 0x00},
	{0x30a9, 0x00},
	{0x30aa, 0x00},
	{0x30ab, 0x00},
	{0x30ac, 0x07},
	{0x30ad, 0x90},
	{0x30ae, 0x04},
	{0x30af, 0x48},
	{0x30b0, 0x08},
	{0x30b1, 0xae},
	{0x30b2, 0x04},
	{0x30b3, 0x65},
	{0x30b4, 0x00},
	{0x30b5, 0x00},
	{0x30b6, 0x00},
	{0x30b7, 0x10},
	{0x30b8, 0x00},
	{0x30b9, 0x02},
	{0x30ba, 0x10},
	{0x30bb, 0x00},
	{0x30bc, 0x00},
	{0x30bd, 0x03},
	{0x30be, 0x5c},
	{0x30bf, 0x00},
	{0x30c0, 0x01},
	{0x30c1, 0x00},
	{0x30c2, 0x20},
	{0x30c3, 0x00},
	{0x30c4, 0x4a},
	{0x30c5, 0x00},
	{0x30c7, 0x00},
	{0x30c8, 0x00},
	{0x30d1, 0x00},
	{0x30d2, 0x00},
	{0x30d3, 0x80},
	{0x30d4, 0x00},
	{0x30d9, 0x09},
	{0x30da, 0x64},
	{0x30dd, 0x00},
	{0x30de, 0x16},
	{0x30df, 0x00},
	{0x30e0, 0x17},
	{0x30e1, 0x00},
	{0x30e2, 0x18},
	{0x30e3, 0x10},
	{0x30e4, 0x04},
	{0x30e5, 0x00},
	{0x30e6, 0x00},
	{0x30e7, 0x00},
	{0x30e8, 0x00},
	{0x30e9, 0x00},
	{0x30ea, 0x00},
	{0x30eb, 0x00},
	{0x30ec, 0x00},
	{0x30ed, 0x00},
	{0x3101, 0x00},
	{0x3102, 0x00},
	{0x3103, 0x00},
	{0x3104, 0x00},
	{0x3105, 0x8c},
	{0x3106, 0x87},
	{0x3107, 0xc0},
	{0x3108, 0x9d},
	{0x3109, 0x8d},
	{0x310a, 0x8d},
	{0x310b, 0x6a},
	{0x310c, 0x3a},
	{0x310d, 0x5a},
	{0x310e, 0x00},
	{0x3120, 0x00},
	{0x3121, 0x00},
	{0x3122, 0x00},
	{0x3123, 0x00},
	{0x3124, 0x00},
	{0x3125, 0x70},
	{0x3126, 0x1f},
	{0x3127, 0x0f},
	{0x3128, 0x00},
	{0x3129, 0x3a},
	{0x312a, 0x02},
	{0x312b, 0x0f},
	{0x312c, 0x00},
	{0x312d, 0x0f},
	{0x312e, 0x1d},
	{0x312f, 0x00},
	{0x3130, 0x00},
	{0x3131, 0x00},
	{0x3132, 0x00},
	{0x3140, 0x0a},
	{0x3141, 0x03},
	{0x3142, 0x00},
	{0x3143, 0x00},
	{0x3144, 0x00},
	{0x3145, 0x00},
	{0x3146, 0x00},
	{0x3147, 0x00},
	{0x3148, 0x00},
	{0x3149, 0x00},
	{0x314a, 0x00},
	{0x314b, 0x00},
	{0x314c, 0x00},
	{0x314d, 0x00},
	{0x314e, 0x1c},
	{0x314f, 0xff},
	{0x3150, 0xff},
	{0x3151, 0xff},
	{0x3152, 0x10},
	{0x3153, 0x10},
	{0x3154, 0x10},
	{0x3155, 0x00},
	{0x3156, 0x03},
	{0x3157, 0x00},
	{0x3158, 0x0f},
	{0x3159, 0xff},
	{0x315a, 0x01},
	{0x315b, 0x00},
	{0x315c, 0x01},
	{0x315d, 0x00},
	{0x315e, 0x01},
	{0x315f, 0x00},
	{0x3160, 0x00},
	{0x3161, 0x40},
	{0x3162, 0x00},
	{0x3163, 0x40},
	{0x3164, 0x00},
	{0x3165, 0x40},
	{0x3190, 0x31},
	{0x3191, 0x99},
	{0x3193, 0x08},
	{0x3194, 0x13},
	{0x3195, 0x33},
	{0x3196, 0x00},
	{0x3197, 0x10},
	{0x3198, 0x00},
	{0x3199, 0x3f},
	{0x319a, 0x40},
	{0x319b, 0x7f},
	{0x319c, 0x80},
	{0x319d, 0xbf},
	{0x319e, 0xc0},
	{0x319f, 0xff},
	{0x31a0, 0x24},
	{0x31a1, 0x55},
	{0x31a2, 0x00},
	{0x31a3, 0x08},
	{0x31a6, 0x00},
	{0x31a7, 0x00},
	{0x31b0, 0x00},
	{0x31b1, 0x00},
	{0x31b2, 0x02},
	{0x31b3, 0x00},
	{0x31b4, 0x00},
	{0x31b5, 0x01},
	{0x31b6, 0x00},
	{0x31b7, 0x00},
	{0x31b8, 0x00},
	{0x31b9, 0x00},
	{0x31ba, 0x00},
	{0x31d0, 0x3c},
	{0x31d1, 0x34},
	{0x31d2, 0x3c},
	{0x31d3, 0x00},
	{0x31d4, 0x2d},
	{0x31d5, 0x00},
	{0x31d6, 0x01},
	{0x31d7, 0x06},
	{0x31d8, 0x00},
	{0x31d9, 0x64},
	{0x31da, 0x00},
	{0x31db, 0x30},
	{0x31dc, 0x04},
	{0x31dd, 0x69},
	{0x31de, 0x0a},
	{0x31df, 0x3c},
	{0x31e0, 0x04},
	{0x31e1, 0x32},
	{0x31e2, 0x00},
	{0x31e3, 0x00},
	{0x31e4, 0x08},
	{0x31e5, 0x80},
	{0x31e6, 0x00},
	{0x31e7, 0x2b},
	{0x31e8, 0x6b},
	{0x31e9, 0xab},
	{0x31ea, 0xeb},
	{0x31eb, 0x3f},
	{0x31ec, 0x0f},
	{0x31ed, 0x20},
	{0x31ee, 0x04},
	{0x31ef, 0x48},
	{0x31f0, 0x07},
	{0x31f1, 0x90},
	{0x31f2, 0x04},
	{0x31f3, 0x48},
	{0x31f4, 0x07},
	{0x31f5, 0x90},
	{0x31f6, 0x04},
	{0x31f7, 0x48},
	{0x31f8, 0x07},
	{0x31f9, 0x90},
	{0x31fa, 0x04},
	{0x31fb, 0x48},
	{0x31fd, 0xcb},
	{0x31fe, 0x03},
	{0x31ff, 0x03},
	{0x3200, 0x00},
	{0x3201, 0xff},
	{0x3202, 0x00},
	{0x3203, 0xff},
	{0x3204, 0xff},
	{0x3205, 0xff},
	{0x3206, 0xff},
	{0x3207, 0xff},
	{0x3208, 0xff},
	{0x3209, 0xff},
	{0x320a, 0xff},
	{0x320b, 0x1b},
	{0x320c, 0x1f},
	{0x320d, 0x1e},
	{0x320e, 0x30},
	{0x320f, 0x2d},
	{0x3210, 0x2c},
	{0x3211, 0x2b},
	{0x3212, 0x2a},
	{0x3213, 0x24},
	{0x3214, 0x22},
	{0x3215, 0x00},
	{0x3216, 0x04},
	{0x3217, 0x2b},
	{0x3218, 0x6b},
	{0x3219, 0xab},
	{0x321a, 0xeb},
	{0x321b, 0x00},
	{0x3230, 0x3a},
	{0x3231, 0x00},
	{0x3232, 0x80},
	{0x3233, 0x00},
	{0x3234, 0x10},
	{0x3235, 0xaa},
	{0x3236, 0x55},
	{0x3237, 0x99},
	{0x3238, 0x66},
	{0x3239, 0x08},
	{0x323a, 0x88},
	{0x323b, 0x00},
	{0x323c, 0x00},
	{0x323d, 0x03},
	{0x3250, 0x33},
	{0x3251, 0x00},
	{0x3252, 0x20},
	{0x3253, 0x00},
	{0x3254, 0x11},
	{0x3255, 0x01},
	{0x3256, 0x00},
	{0x3257, 0x00},
	{0x3258, 0x00},
	{0x3270, 0x01},
	{0x3271, 0x60},
	{0x3272, 0xc0},
	{0x3273, 0x00},
	{0x3274, 0x80},
	{0x3275, 0x40},
	{0x3276, 0x02},
	{0x3277, 0x08},
	{0x3278, 0x10},
	{0x3279, 0x04},
	{0x327a, 0x00},
	{0x327b, 0x03},
	{0x327c, 0x10},
	{0x327d, 0x60},
	{0x327e, 0xc0},
	{0x327f, 0x06},
	{0x3288, 0x10},
	{0x3289, 0x00},
	{0x328a, 0x08},
	{0x328b, 0x00},
	{0x328c, 0x04},
	{0x328d, 0x00},
	{0x328e, 0x02},
	{0x328f, 0x00},
	{0x3290, 0x20},
	{0x3291, 0x00},
	{0x3292, 0x10},
	{0x3293, 0x00},
	{0x3294, 0x08},
	{0x3295, 0x00},
	{0x3296, 0x04},
	{0x3297, 0x00},
	{0x3298, 0x40},
	{0x3299, 0x00},
	{0x329a, 0x20},
	{0x329b, 0x00},
	{0x329c, 0x10},
	{0x329d, 0x00},
	{0x329e, 0x08},
	{0x329f, 0x00},
	{0x32a0, 0x7f},
	{0x32a1, 0xff},
	{0x32a2, 0x40},
	{0x32a3, 0x00},
	{0x32a4, 0x20},
	{0x32a5, 0x00},
	{0x32a6, 0x10},
	{0x32a7, 0x00},
	{0x32a8, 0x00},
	{0x32a9, 0x00},
	{0x32aa, 0x00},
	{0x32ab, 0x00},
	{0x32ac, 0x00},
	{0x32ad, 0x00},
	{0x32ae, 0x00},
	{0x32af, 0x00},
	{0x32b0, 0x00},
	{0x32b1, 0x00},
	{0x32b2, 0x00},
	{0x32b3, 0x00},
	{0x32b4, 0x00},
	{0x32b5, 0x00},
	{0x32b6, 0x00},
	{0x32b7, 0x00},
	{0x32b8, 0x00},
	{0x32b9, 0x00},
	{0x32ba, 0x00},
	{0x32bb, 0x00},
	{0x32bc, 0x00},
	{0x32bd, 0x00},
	{0x32be, 0x00},
	{0x32bf, 0x00},
	{0x32c0, 0x00},
	{0x32c1, 0x00},
	{0x32c2, 0x00},
	{0x32c3, 0x00},
	{0x32c4, 0x00},
	{0x32c5, 0x00},
	{0x32c6, 0x00},
	{0x32c7, 0x00},
	{0x32c8, 0x87},
	{0x32c9, 0x00},
	{0x3330, 0x03},
	{0x3331, 0xc8},
	{0x3332, 0x02},
	{0x3333, 0x24},
	{0x3334, 0x00},
	{0x3335, 0x00},
	{0x3336, 0x00},
	{0x3337, 0x00},
	{0x3338, 0x03},
	{0x3339, 0xc8},
	{0x333a, 0x02},
	{0x333b, 0x24},
	{0x333c, 0x00},
	{0x333d, 0x00},
	{0x333e, 0x00},
	{0x333f, 0x00},
	{0x3340, 0x03},
	{0x3341, 0xc8},
	{0x3342, 0x02},
	{0x3343, 0x24},
	{0x3344, 0x00},
	{0x3345, 0x00},
	{0x3346, 0x00},
	{0x3347, 0x00},
	{0x3348, 0x40},
	{0x3349, 0x00},
	{0x334a, 0x00},
	{0x334b, 0x00},
	{0x334c, 0x00},
	{0x334d, 0x00},
	{0x334e, 0x80},
	{0x3360, 0x01},
	{0x3361, 0x00},
	{0x3362, 0x01},
	{0x3363, 0x00},
	{0x3364, 0x01},
	{0x3365, 0x00},
	{0x3366, 0x01},
	{0x3367, 0x00},
	{0x3368, 0x01},
	{0x3369, 0x00},
	{0x336a, 0x01},
	{0x336b, 0x00},
	{0x336c, 0x01},
	{0x336d, 0x00},
	{0x336e, 0x01},
	{0x336f, 0x00},
	{0x3370, 0x01},
	{0x3371, 0x00},
	{0x3372, 0x01},
	{0x3373, 0x00},
	{0x3374, 0x01},
	{0x3375, 0x00},
	{0x3376, 0x01},
	{0x3377, 0x00},
	{0x3378, 0x00},
	{0x3379, 0x00},
	{0x337a, 0x00},
	{0x337b, 0x00},
	{0x337c, 0x00},
	{0x337d, 0x00},
	{0x337e, 0x00},
	{0x337f, 0x00},
	{0x3380, 0x00},
	{0x3381, 0x00},
	{0x3382, 0x00},
	{0x3383, 0x00},
	{0x3384, 0x00},
	{0x3385, 0x00},
	{0x3386, 0x00},
	{0x3387, 0x00},
	{0x3388, 0x00},
	{0x3389, 0x00},
	{0x338a, 0x00},
	{0x338b, 0x00},
	{0x338c, 0x00},
	{0x338d, 0x00},
	{0x338e, 0x00},
	{0x338f, 0x00},
	{0x3390, 0x00},
	{0x3391, 0x00},
	{0x3392, 0x00},
	{0x3393, 0x00},
	{0x3394, 0x00},
	{0x3395, 0x00},
	{0x3396, 0x00},
	{0x3397, 0x00},
	{0x3398, 0x00},
	{0x3399, 0x00},
	{0x339a, 0x00},
	{0x339b, 0x00},
	{0x33b0, 0x00},
	{0x33b1, 0x50},
	{0x33b2, 0x01},
	{0x33b3, 0xff},
	{0x33b4, 0xe0},
	{0x33b5, 0x6b},
	{0x33b6, 0x00},
	{0x33b7, 0x00},
	{0x33b8, 0x00},
	{0x33b9, 0x00},
	{0x33ba, 0x00},
	{0x33bb, 0x1f},
	{0x33bc, 0x01},
	{0x33bd, 0x01},
	{0x33be, 0x01},
	{0x33bf, 0x01},
	{0x33c0, 0x00},
	{0x33c1, 0x00},
	{0x33c2, 0x00},
	{0x33c3, 0x00},
	{0x33e0, 0x14},
	{0x33e1, 0x0f},
	{0x33e2, 0x04},
	{0x33e3, 0x02},
	{0x33e4, 0x01},
	{0x33e5, 0x01},
	{0x33e6, 0x00},
	{0x33e7, 0x04},
	{0x33e8, 0x0c},
	{0x33e9, 0x00},
	{0x33ea, 0x01},
	{0x33eb, 0x02},
	{0x33ec, 0x03},
	{0x33ed, 0x02},
	{0x33ee, 0x05},
	{0x33ef, 0x0a},
	{0x33f0, 0x08},
	{0x33f1, 0x04},
	{0x33f2, 0x04},
	{0x33f3, 0x00},
	{0x33f4, 0x03},
	{0x33f5, 0x14},
	{0x33f6, 0x0f},
	{0x33f7, 0x02},
	{0x33f8, 0x01},
	{0x33f9, 0x01},
	{0x33fa, 0x01},
	{0x33fb, 0x00},
	{0x33fc, 0x04},
	{0x33fd, 0x0c},
	{0x33fe, 0x00},
	{0x33ff, 0x01},
	{0x3400, 0x02},
	{0x3401, 0x03},
	{0x3402, 0x01},
	{0x3403, 0x02},
	{0x3404, 0x08},
	{0x3405, 0x08},
	{0x3406, 0x04},
	{0x3407, 0x04},
	{0x3408, 0x00},
	{0x3409, 0x03},
	{0x340a, 0x14},
	{0x340b, 0x0f},
	{0x340c, 0x04},
	{0x340d, 0x02},
	{0x340e, 0x01},
	{0x340f, 0x01},
	{0x3410, 0x00},
	{0x3411, 0x04},
	{0x3412, 0x0c},
	{0x3413, 0x00},
	{0x3414, 0x01},
	{0x3415, 0x02},
	{0x3416, 0x03},
	{0x3417, 0x02},
	{0x3418, 0x05},
	{0x3419, 0x0a},
	{0x341a, 0x08},
	{0x341b, 0x04},
	{0x341c, 0x04},
	{0x341d, 0x00},
	{0x341e, 0x03},
	{0x3440, 0x00},
	{0x3441, 0x00},
	{0x3442, 0x00},
	{0x3443, 0x00},
	{0x3444, 0x02},
	{0x3445, 0xf0},
	{0x3446, 0x02},
	{0x3447, 0x08},
	{0x3448, 0x00},
	{0x3460, 0x40},
	{0x3461, 0x40},
	{0x3462, 0x40},
	{0x3463, 0x40},
	{0x3464, 0x03},
	{0x3465, 0x01},
	{0x3466, 0x01},
	{0x3467, 0x02},
	{0x3468, 0x30},
	{0x3469, 0x00},
	{0x346a, 0x35},
	{0x346b, 0x00},
	{0x3480, 0x40},
	{0x3481, 0x00},
	{0x3482, 0x00},
	{0x3483, 0x00},
	{0x3484, 0x0d},
	{0x3485, 0x00},
	{0x3486, 0x00},
	{0x3487, 0x00},
	{0x3488, 0x00},
	{0x3489, 0x00},
	{0x348a, 0x00},
	{0x348b, 0x04},
	{0x348c, 0x00},
	{0x348d, 0x01},
	{0x348f, 0x01},
	{0x3030, 0x0a},
	{0x3030, 0x02},
	{0x7000, 0x58},
	{0x7001, 0x7a},
	{0x7002, 0x1a},
	{0x7003, 0xc1},
	{0x7004, 0x03},
	{0x7005, 0xda},
	{0x7006, 0xbd},
	{0x7007, 0x03},
	{0x7008, 0xbd},
	{0x7009, 0x06},
	{0x700a, 0xe6},
	{0x700b, 0xec},
	{0x700c, 0xbc},
	{0x700d, 0xff},
	{0x700e, 0xbc},
	{0x700f, 0x73},
	{0x7010, 0xda},
	{0x7011, 0x72},
	{0x7012, 0x76},
	{0x7013, 0xb6},
	{0x7014, 0xee},
	{0x7015, 0xcf},
	{0x7016, 0xac},
	{0x7017, 0xd0},
	{0x7018, 0xac},
	{0x7019, 0xd1},
	{0x701a, 0x50},
	{0x701b, 0xac},
	{0x701c, 0xd2},
	{0x701d, 0xbc},
	{0x701e, 0x2e},
	{0x701f, 0xb4},
	{0x7020, 0x00},
	{0x7021, 0xdc},
	{0x7022, 0xdf},
	{0x7023, 0xb0},
	{0x7024, 0x6e},
	{0x7025, 0xbd},
	{0x7026, 0x01},
	{0x7027, 0xd7},
	{0x7028, 0xed},
	{0x7029, 0xe1},
	{0x702a, 0x36},
	{0x702b, 0x30},
	{0x702c, 0xd3},
	{0x702d, 0x2e},
	{0x702e, 0x54},
	{0x702f, 0x46},
	{0x7030, 0xbc},
	{0x7031, 0x22},
	{0x7032, 0x66},
	{0x7033, 0xbc},
	{0x7034, 0x24},
	{0x7035, 0x2c},
	{0x7036, 0x28},
	{0x7037, 0xbc},
	{0x7038, 0x3c},
	{0x7039, 0xa1},
	{0x703a, 0xac},
	{0x703b, 0xd8},
	{0x703c, 0xd6},
	{0x703d, 0xb4},
	{0x703e, 0x04},
	{0x703f, 0x46},
	{0x7040, 0xb7},
	{0x7041, 0x04},
	{0x7042, 0xbe},
	{0x7043, 0x08},
	{0x7044, 0xc3},
	{0x7045, 0xd9},
	{0x7046, 0xad},
	{0x7047, 0xc3},
	{0x7048, 0xbc},
	{0x7049, 0x19},
	{0x704a, 0xc1},
	{0x704b, 0x27},
	{0x704c, 0xe7},
	{0x704d, 0x00},
	{0x704e, 0x50},
	{0x704f, 0x20},
	{0x7050, 0xb8},
	{0x7051, 0x02},
	{0x7052, 0xbc},
	{0x7053, 0x17},
	{0x7054, 0xdb},
	{0x7055, 0xc7},
	{0x7056, 0xb8},
	{0x7057, 0x00},
	{0x7058, 0x28},
	{0x7059, 0x54},
	{0x705a, 0xb4},
	{0x705b, 0x14},
	{0x705c, 0xab},
	{0x705d, 0xbe},
	{0x705e, 0x06},
	{0x705f, 0xd8},
	{0x7060, 0xd6},
	{0x7061, 0x00},
	{0x7062, 0xb4},
	{0x7063, 0xc7},
	{0x7064, 0x07},
	{0x7065, 0xb9},
	{0x7066, 0x05},
	{0x7067, 0xee},
	{0x7068, 0xe6},
	{0x7069, 0xad},
	{0x706a, 0xb4},
	{0x706b, 0x26},
	{0x706c, 0x19},
	{0x706d, 0xc1},
	{0x706e, 0x3a},
	{0x706f, 0xc3},
	{0x7070, 0xaf},
	{0x7071, 0x00},
	{0x7072, 0xc0},
	{0x7073, 0x3c},
	{0x7074, 0xc3},
	{0x7075, 0xbe},
	{0x7076, 0xe7},
	{0x7077, 0x00},
	{0x7078, 0x15},
	{0x7079, 0xc2},
	{0x707a, 0x40},
	{0x707b, 0xc3},
	{0x707c, 0xa4},
	{0x707d, 0xc0},
	{0x707e, 0x3c},
	{0x707f, 0x00},
	{0x7080, 0xb9},
	{0x7081, 0x64},
	{0x7082, 0x29},
	{0x7083, 0x00},
	{0x7084, 0xb8},
	{0x7085, 0x12},
	{0x7086, 0xbe},
	{0x7087, 0x01},
	{0x7088, 0xd0},
	{0x7089, 0xbc},
	{0x708a, 0x01},
	{0x708b, 0xac},
	{0x708c, 0x37},
	{0x708d, 0xd2},
	{0x708e, 0xac},
	{0x708f, 0x45},
	{0x7090, 0xad},
	{0x7091, 0x28},
	{0x7092, 0x00},
	{0x7093, 0xb8},
	{0x7094, 0x00},
	{0x7095, 0xbc},
	{0x7096, 0x01},
	{0x7097, 0x36},
	{0x7098, 0xd3},
	{0x7099, 0x30},
	{0x709a, 0x04},
	{0x709b, 0xe0},
	{0x709c, 0xd8},
	{0x709d, 0xb4},
	{0x709e, 0xe9},
	{0x709f, 0x00},
	{0x70a0, 0xbe},
	{0x70a1, 0x05},
	{0x70a2, 0x62},
	{0x70a3, 0x07},
	{0x70a4, 0xb9},
	{0x70a5, 0x05},
	{0x70a6, 0xad},
	{0x70a7, 0xc3},
	{0x70a8, 0xcf},
	{0x70a9, 0x00},
	{0x70aa, 0x15},
	{0x70ab, 0xc2},
	{0x70ac, 0x59},
	{0x70ad, 0xc3},
	{0x70ae, 0xc9},
	{0x70af, 0xc0},
	{0x70b0, 0x55},
	{0x70b1, 0x00},
	{0x70b2, 0x46},
	{0x70b3, 0xa1},
	{0x70b4, 0xb9},
	{0x70b5, 0x64},
	{0x70b6, 0x29},
	{0x70b7, 0x00},
	{0x70b8, 0xb8},
	{0x70b9, 0x02},
	{0x70ba, 0xbe},
	{0x70bb, 0x02},
	{0x70bc, 0xd0},
	{0x70bd, 0xdc},
	{0x70be, 0xac},
	{0x70bf, 0xbc},
	{0x70c0, 0x01},
	{0x70c1, 0x37},
	{0x70c2, 0xac},
	{0x70c3, 0xd2},
	{0x70c4, 0x45},
	{0x70c5, 0xad},
	{0x70c6, 0x28},
	{0x70c7, 0x00},
	{0x70c8, 0xb8},
	{0x70c9, 0x00},
	{0x70ca, 0xbc},
	{0x70cb, 0x01},
	{0x70cc, 0x36},
	{0x70cd, 0x30},
	{0x70ce, 0xe0},
	{0x70cf, 0xd8},
	{0x70d0, 0xb5},
	{0x70d1, 0x0b},
	{0x70d2, 0xd6},
	{0x70d3, 0xbe},
	{0x70d4, 0x07},
	{0x70d5, 0x00},
	{0x70d6, 0x62},
	{0x70d7, 0x07},
	{0x70d8, 0xb9},
	{0x70d9, 0x05},
	{0x70da, 0xad},
	{0x70db, 0xc3},
	{0x70dc, 0xcf},
	{0x70dd, 0x46},
	{0x70de, 0xcd},
	{0x70df, 0x07},
	{0x70e0, 0xcd},
	{0x70e1, 0x00},
	{0x70e2, 0xe3},
	{0x70e3, 0x18},
	{0x70e4, 0xc2},
	{0x70e5, 0xa2},
	{0x70e6, 0xb9},
	{0x70e7, 0x64},
	{0x70e8, 0xd1},
	{0x70e9, 0xdd},
	{0x70ea, 0xac},
	{0x70eb, 0xcf},
	{0x70ec, 0xdf},
	{0x70ed, 0xb5},
	{0x70ee, 0x19},
	{0x70ef, 0x46},
	{0x70f0, 0x50},
	{0x70f1, 0xb6},
	{0x70f2, 0xee},
	{0x70f3, 0xe8},
	{0x70f4, 0xe6},
	{0x70f5, 0xbc},
	{0x70f6, 0x31},
	{0x70f7, 0xe1},
	{0x70f8, 0x36},
	{0x70f9, 0x30},
	{0x70fa, 0xd3},
	{0x70fb, 0x2e},
	{0x70fc, 0x54},
	{0x70fd, 0xbd},
	{0x70fe, 0x03},
	{0x70ff, 0xec},
	{0x7100, 0x2c},
	{0x7101, 0x50},
	{0x7102, 0x20},
	{0x7103, 0x04},
	{0x7104, 0xb8},
	{0x7105, 0x02},
	{0x7106, 0xbc},
	{0x7107, 0x18},
	{0x7108, 0xc7},
	{0x7109, 0xb8},
	{0x710a, 0x00},
	{0x710b, 0x28},
	{0x710c, 0x54},
	{0x710d, 0xbc},
	{0x710e, 0x02},
	{0x710f, 0xb4},
	{0x7110, 0xda},
	{0x7111, 0xbe},
	{0x7112, 0x04},
	{0x7113, 0xd6},
	{0x7114, 0xd8},
	{0x7115, 0xab},
	{0x7116, 0x00},
	{0x7117, 0x62},
	{0x7118, 0x07},
	{0x7119, 0xb9},
	{0x711a, 0x05},
	{0x711b, 0xad},
	{0x711c, 0xc3},
	{0x711d, 0xbc},
	{0x711e, 0xe7},
	{0x711f, 0xb9},
	{0x7120, 0x64},
	{0x7121, 0x29},
	{0x7122, 0x00},
	{0x7123, 0xb8},
	{0x7124, 0x02},
	{0x7125, 0xbe},
	{0x7126, 0x00},
	{0x7127, 0x45},
	{0x7128, 0xad},
	{0x7129, 0xe2},
	{0x712a, 0x28},
	{0x712b, 0x00},
	{0x712c, 0xb8},
	{0x712d, 0x00},
	{0x712e, 0xe0},
	{0x712f, 0xd8},
	{0x7130, 0xb4},
	{0x7131, 0xe9},
	{0x7132, 0xbe},
	{0x7133, 0x03},
	{0x7134, 0x00},
	{0x7135, 0x30},
	{0x7136, 0x62},
	{0x7137, 0x07},
	{0x7138, 0xb9},
	{0x7139, 0x05},
	{0x713a, 0xad},
	{0x713b, 0xc3},
	{0x713c, 0xcf},
	{0x713d, 0x42},
	{0x713e, 0xe4},
	{0x713f, 0xcd},
	{0x7140, 0x07},
	{0x7141, 0xcd},
	{0x7142, 0x00},
	{0x7143, 0x00},
	{0x7144, 0x17},
	{0x7145, 0xc2},
	{0x7146, 0xbb},
	{0x7147, 0xde},
	{0x7148, 0xcf},
	{0x7149, 0xdf},
	{0x714a, 0xac},
	{0x714b, 0xd1},
	{0x714c, 0x44},
	{0x714d, 0xac},
	{0x714e, 0xb9},
	{0x714f, 0x76},
	{0x7150, 0xb8},
	{0x7151, 0x08},
	{0x7152, 0xb6},
	{0x7153, 0xfe},
	{0x7154, 0xb4},
	{0x7155, 0xca},
	{0x7156, 0xd6},
	{0x7157, 0xd8},
	{0x7158, 0xab},
	{0x7159, 0x00},
	{0x715a, 0xe1},
	{0x715b, 0x36},
	{0x715c, 0x30},
	{0x715d, 0xd3},
	{0x715e, 0xbc},
	{0x715f, 0x29},
	{0x7160, 0xb4},
	{0x7161, 0x1f},
	{0x7162, 0xaa},
	{0x7163, 0xbd},
	{0x7164, 0x01},
	{0x7165, 0xb8},
	{0x7166, 0x0c},
	{0x7167, 0x45},
	{0x7168, 0xa4},
	{0x7169, 0xbd},
	{0x716a, 0x03},
	{0x716b, 0xec},
	{0x716c, 0xbc},
	{0x716d, 0x3d},
	{0x716e, 0xc3},
	{0x716f, 0xcf},
	{0x7170, 0x42},
	{0x7171, 0xb8},
	{0x7172, 0x00},
	{0x7173, 0xe4},
	{0x7174, 0xd5},
	{0x7175, 0x00},
	{0x7176, 0xb6},
	{0x7177, 0x00},
	{0x7178, 0x74},
	{0x7179, 0xbd},
	{0x717a, 0x03},
	{0x717b, 0x40},
	{0x717c, 0xb5},
	{0x717d, 0x39},
	{0x717e, 0x58},
	{0x717f, 0xdd},
	{0x7180, 0x19},
	{0x7181, 0xc1},
	{0x7182, 0xc8},
	{0x7183, 0xbd},
	{0x7184, 0x06},
	{0x7185, 0x17},
	{0x7186, 0xc1},
	{0x7187, 0xc6},
	{0x7188, 0xe8},
	{0x7189, 0x00},
	{0x718a, 0xc0},
	{0x718b, 0xc8},
	{0x718c, 0xe6},
	{0x718d, 0x95},
	{0x718e, 0x15},
	{0x718f, 0x00},
	{0x7190, 0xbc},
	{0x7191, 0x19},
	{0x7192, 0xb9},
	{0x7193, 0xf6},
	{0x7194, 0x14},
	{0x7195, 0xc1},
	{0x7196, 0xd0},
	{0x7197, 0xd1},
	{0x7198, 0xac},
	{0x7199, 0x37},
	{0x719a, 0xbc},
	{0x719b, 0x35},
	{0x719c, 0x36},
	{0x719d, 0x30},
	{0x719e, 0xe1},
	{0x719f, 0xd3},
	{0x71a0, 0x7a},
	{0x71a1, 0xb6},
	{0x71a2, 0x0c},
	{0x71a3, 0xff},
	{0x71a4, 0xb4},
	{0x71a5, 0xc7},
	{0x71a6, 0xd9},
	{0x71a7, 0x00},
	{0x71a8, 0xbd},
	{0x71a9, 0x01},
	{0x71aa, 0x56},
	{0x71ab, 0xc0},
	{0x71ac, 0xda},
	{0x71ad, 0xb4},
	{0x71ae, 0x1f},
	{0x71af, 0x56},
	{0x71b0, 0xaa},
	{0x71b1, 0xbc},
	{0x71b2, 0x08},
	{0x71b3, 0x00},
	{0x71b4, 0x57},
	{0x71b5, 0xe8},
	{0x71b6, 0xb5},
	{0x71b7, 0x36},
	{0x71b8, 0x00},
	{0x71b9, 0x54},
	{0x71ba, 0xe7},
	{0x71bb, 0xc8},
	{0x71bc, 0xb4},
	{0x71bd, 0x1f},
	{0x71be, 0x56},
	{0x71bf, 0xaa},
	{0x71c0, 0xbc},
	{0x71c1, 0x08},
	{0x71c2, 0x57},
	{0x71c3, 0x00},
	{0x71c4, 0xb5},
	{0x71c5, 0x36},
	{0x71c6, 0x00},
	{0x71c7, 0x54},
	{0x71c8, 0xc8},
	{0x71c9, 0xb5},
	{0x71ca, 0x18},
	{0x71cb, 0xd9},
	{0x71cc, 0x00},
	{0x71cd, 0xbd},
	{0x71ce, 0x01},
	{0x71cf, 0x56},
	{0x71d0, 0x08},
	{0x71d1, 0x57},
	{0x71d2, 0xe8},
	{0x71d3, 0xb4},
	{0x71d4, 0x42},
	{0x71d5, 0x00},
	{0x71d6, 0x54},
	{0x71d7, 0xe7},
	{0x71d8, 0xc8},
	{0x71d9, 0xab},
	{0x71da, 0x00},
	{0x71db, 0x66},
	{0x71dc, 0x62},
	{0x71dd, 0x06},
	{0x71de, 0x74},
	{0x71df, 0xb9},
	{0x71e0, 0x05},
	{0x71e1, 0xb7},
	{0x71e2, 0x14},
	{0x71e3, 0x0e},
	{0x71e4, 0xb7},
	{0x71e5, 0x04},
	{0x71e6, 0xc8},
	{0x7600, 0x04},
	{0x7601, 0x80},
	{0x7602, 0x07},
	{0x7603, 0x44},
	{0x7604, 0x05},
	{0x7605, 0x33},
	{0x7606, 0x0f},
	{0x7607, 0x00},
	{0x7608, 0x07},
	{0x7609, 0x40},
	{0x760a, 0x04},
	{0x760b, 0xe5},
	{0x760c, 0x06},
	{0x760d, 0x50},
	{0x760e, 0x04},
	{0x760f, 0xe4},
	{0x7610, 0x00},
	{0x7611, 0x00},
	{0x7612, 0x06},
	{0x7613, 0x5c},
	{0x7614, 0x00},
	{0x7615, 0x0f},
	{0x7616, 0x06},
	{0x7617, 0x1c},
	{0x7618, 0x00},
	{0x7619, 0x02},
	{0x761a, 0x06},
	{0x761b, 0xa2},
	{0x761c, 0x00},
	{0x761d, 0x01},
	{0x761e, 0x06},
	{0x761f, 0xae},
	{0x7620, 0x00},
	{0x7621, 0x0e},
	{0x7622, 0x05},
	{0x7623, 0x30},
	{0x7624, 0x07},
	{0x7625, 0x00},
	{0x7626, 0x0f},
	{0x7627, 0x00},
	{0x7628, 0x04},
	{0x7629, 0xe5},
	{0x762a, 0x05},
	{0x762b, 0x33},
	{0x762c, 0x06},
	{0x762d, 0x12},
	{0x762e, 0x00},
	{0x762f, 0x01},
	{0x7630, 0x06},
	{0x7631, 0x52},
	{0x7632, 0x00},
	{0x7633, 0x01},
	{0x7634, 0x06},
	{0x7635, 0x5e},
	{0x7636, 0x04},
	{0x7637, 0xe4},
	{0x7638, 0x00},
	{0x7639, 0x01},
	{0x763a, 0x05},
	{0x763b, 0x30},
	{0x763c, 0x0f},
	{0x763d, 0x00},
	{0x763e, 0x06},
	{0x763f, 0xa6},
	{0x7640, 0x00},
	{0x7641, 0x02},
	{0x7642, 0x06},
	{0x7643, 0x26},
	{0x7644, 0x00},
	{0x7645, 0x02},
	{0x7646, 0x05},
	{0x7647, 0x33},
	{0x7648, 0x06},
	{0x7649, 0x20},
	{0x764a, 0x0f},
	{0x764b, 0x00},
	{0x764c, 0x06},
	{0x764d, 0x56},
	{0x764e, 0x00},
	{0x764f, 0x02},
	{0x7650, 0x06},
	{0x7651, 0x16},
	{0x7652, 0x05},
	{0x7653, 0x33},
	{0x7654, 0x06},
	{0x7655, 0x10},
	{0x7656, 0x0f},
	{0x7657, 0x00},
	{0x7658, 0x06},
	{0x7659, 0x10},
	{0x765a, 0x0f},
	{0x765b, 0x00},
	{0x765c, 0x06},
	{0x765d, 0x20},
	{0x765e, 0x0f},
	{0x765f, 0x00},
	{0x7660, 0x00},
	{0x7661, 0x00},
	{0x7662, 0x00},
	{0x7663, 0x02},
	{0x7664, 0x04},
	{0x7665, 0xe5},
	{0x7666, 0x04},
	{0x7667, 0xe4},
	{0x7668, 0x0f},
	{0x7669, 0x00},
	{0x766a, 0x00},
	{0x766b, 0x00},
	{0x766c, 0x00},
	{0x766d, 0x01},
	{0x766e, 0x04},
	{0x766f, 0xe5},
	{0x7670, 0x04},
	{0x7671, 0xe4},
	{0x7672, 0x0f},
	{0x7673, 0x00},
	{0x7674, 0x00},
	{0x7675, 0x02},
	{0x7676, 0x04},
	{0x7677, 0xe4},
	{0x7678, 0x00},
	{0x7679, 0x02},
	{0x767a, 0x04},
	{0x767b, 0xc4},
	{0x767c, 0x00},
	{0x767d, 0x02},
	{0x767e, 0x04},
	{0x767f, 0xc4},
	{0x7680, 0x05},
	{0x7681, 0x83},
	{0x7682, 0x0f},
	{0x7683, 0x00},
	{0x7684, 0x00},
	{0x7685, 0x02},
	{0x7686, 0x04},
	{0x7687, 0xe4},
	{0x7688, 0x00},
	{0x7689, 0x02},
	{0x768a, 0x04},
	{0x768b, 0xc4},
	{0x768c, 0x00},
	{0x768d, 0x02},
	{0x768e, 0x04},
	{0x768f, 0xc4},
	{0x7690, 0x05},
	{0x7691, 0x83},
	{0x7692, 0x03},
	{0x7693, 0x0b},
	{0x7694, 0x05},
	{0x7695, 0x83},
	{0x7696, 0x00},
	{0x7697, 0x07},
	{0x7698, 0x05},
	{0x7699, 0x03},
	{0x769a, 0x00},
	{0x769b, 0x05},
	{0x769c, 0x05},
	{0x769d, 0x32},
	{0x769e, 0x05},
	{0x769f, 0x30},
	{0x76a0, 0x00},
	{0x76a1, 0x02},
	{0x76a2, 0x05},
	{0x76a3, 0x78},
	{0x76a4, 0x00},
	{0x76a5, 0x01},
	{0x76a6, 0x05},
	{0x76a7, 0x7c},
	{0x76a8, 0x03},
	{0x76a9, 0x9a},
	{0x76aa, 0x05},
	{0x76ab, 0x83},
	{0x76ac, 0x00},
	{0x76ad, 0x04},
	{0x76ae, 0x05},
	{0x76af, 0x03},
	{0x76b0, 0x00},
	{0x76b1, 0x03},
	{0x76b2, 0x05},
	{0x76b3, 0x32},
	{0x76b4, 0x05},
	{0x76b5, 0x30},
	{0x76b6, 0x00},
	{0x76b7, 0x02},
	{0x76b8, 0x05},
	{0x76b9, 0x78},
	{0x76ba, 0x00},
	{0x76bb, 0x01},
	{0x76bc, 0x05},
	{0x76bd, 0x7c},
	{0x76be, 0x03},
	{0x76bf, 0x99},
	{0x76c0, 0x05},
	{0x76c1, 0x83},
	{0x76c2, 0x00},
	{0x76c3, 0x03},
	{0x76c4, 0x05},
	{0x76c5, 0x03},
	{0x76c6, 0x00},
	{0x76c7, 0x01},
	{0x76c8, 0x05},
	{0x76c9, 0x32},
	{0x76ca, 0x05},
	{0x76cb, 0x30},
	{0x76cc, 0x00},
	{0x76cd, 0x02},
	{0x76ce, 0x05},
	{0x76cf, 0x78},
	{0x76d0, 0x00},
	{0x76d1, 0x01},
	{0x76d2, 0x05},
	{0x76d3, 0x7c},
	{0x76d4, 0x03},
	{0x76d5, 0x98},
	{0x76d6, 0x05},
	{0x76d7, 0x83},
	{0x76d8, 0x00},
	{0x76d9, 0x00},
	{0x76da, 0x05},
	{0x76db, 0x03},
	{0x76dc, 0x00},
	{0x76dd, 0x01},
	{0x76de, 0x05},
	{0x76df, 0x32},
	{0x76e0, 0x05},
	{0x76e1, 0x30},
	{0x76e2, 0x00},
	{0x76e3, 0x02},
	{0x76e4, 0x05},
	{0x76e5, 0x78},
	{0x76e6, 0x00},
	{0x76e7, 0x01},
	{0x76e8, 0x05},
	{0x76e9, 0x7c},
	{0x76ea, 0x03},
	{0x76eb, 0x97},
	{0x76ec, 0x05},
	{0x76ed, 0x83},
	{0x76ee, 0x00},
	{0x76ef, 0x00},
	{0x76f0, 0x05},
	{0x76f1, 0x03},
	{0x76f2, 0x05},
	{0x76f3, 0x32},
	{0x76f4, 0x05},
	{0x76f5, 0x30},
	{0x76f6, 0x00},
	{0x76f7, 0x02},
	{0x76f8, 0x05},
	{0x76f9, 0x78},
	{0x76fa, 0x00},
	{0x76fb, 0x01},
	{0x76fc, 0x05},
	{0x76fd, 0x7c},
	{0x76fe, 0x03},
	{0x76ff, 0x96},
	{0x7700, 0x05},
	{0x7701, 0x83},
	{0x7702, 0x05},
	{0x7703, 0x03},
	{0x7704, 0x05},
	{0x7705, 0x32},
	{0x7706, 0x05},
	{0x7707, 0x30},
	{0x7708, 0x00},
	{0x7709, 0x02},
	{0x770a, 0x05},
	{0x770b, 0x78},
	{0x770c, 0x00},
	{0x770d, 0x01},
	{0x770e, 0x05},
	{0x770f, 0x7c},
	{0x7710, 0x03},
	{0x7711, 0x95},
	{0x7712, 0x05},
	{0x7713, 0x83},
	{0x7714, 0x05},
	{0x7715, 0x03},
	{0x7716, 0x05},
	{0x7717, 0x32},
	{0x7718, 0x05},
	{0x7719, 0x30},
	{0x771a, 0x00},
	{0x771b, 0x02},
	{0x771c, 0x05},
	{0x771d, 0x78},
	{0x771e, 0x00},
	{0x771f, 0x01},
	{0x7720, 0x05},
	{0x7721, 0x7c},
	{0x7722, 0x03},
	{0x7723, 0x94},
	{0x7724, 0x05},
	{0x7725, 0x83},
	{0x7726, 0x00},
	{0x7727, 0x01},
	{0x7728, 0x05},
	{0x7729, 0x03},
	{0x772a, 0x00},
	{0x772b, 0x01},
	{0x772c, 0x05},
	{0x772d, 0x32},
	{0x772e, 0x05},
	{0x772f, 0x30},
	{0x7730, 0x00},
	{0x7731, 0x02},
	{0x7732, 0x05},
	{0x7733, 0x78},
	{0x7734, 0x00},
	{0x7735, 0x01},
	{0x7736, 0x05},
	{0x7737, 0x7c},
	{0x7738, 0x03},
	{0x7739, 0x93},
	{0x773a, 0x05},
	{0x773b, 0x83},
	{0x773c, 0x00},
	{0x773d, 0x00},
	{0x773e, 0x05},
	{0x773f, 0x03},
	{0x7740, 0x00},
	{0x7741, 0x00},
	{0x7742, 0x05},
	{0x7743, 0x32},
	{0x7744, 0x05},
	{0x7745, 0x30},
	{0x7746, 0x00},
	{0x7747, 0x02},
	{0x7748, 0x05},
	{0x7749, 0x78},
	{0x774a, 0x00},
	{0x774b, 0x01},
	{0x774c, 0x05},
	{0x774d, 0x7c},
	{0x774e, 0x03},
	{0x774f, 0x92},
	{0x7750, 0x05},
	{0x7751, 0x83},
	{0x7752, 0x05},
	{0x7753, 0x03},
	{0x7754, 0x00},
	{0x7755, 0x00},
	{0x7756, 0x05},
	{0x7757, 0x32},
	{0x7758, 0x05},
	{0x7759, 0x30},
	{0x775a, 0x00},
	{0x775b, 0x02},
	{0x775c, 0x05},
	{0x775d, 0x78},
	{0x775e, 0x00},
	{0x775f, 0x01},
	{0x7760, 0x05},
	{0x7761, 0x7c},
	{0x7762, 0x03},
	{0x7763, 0x91},
	{0x7764, 0x05},
	{0x7765, 0x83},
	{0x7766, 0x05},
	{0x7767, 0x03},
	{0x7768, 0x05},
	{0x7769, 0x32},
	{0x776a, 0x05},
	{0x776b, 0x30},
	{0x776c, 0x00},
	{0x776d, 0x02},
	{0x776e, 0x05},
	{0x776f, 0x78},
	{0x7770, 0x00},
	{0x7771, 0x01},
	{0x7772, 0x05},
	{0x7773, 0x7c},
	{0x7774, 0x03},
	{0x7775, 0x90},
	{0x7776, 0x05},
	{0x7777, 0x83},
	{0x7778, 0x05},
	{0x7779, 0x03},
	{0x777a, 0x05},
	{0x777b, 0x32},
	{0x777c, 0x05},
	{0x777d, 0x30},
	{0x777e, 0x00},
	{0x777f, 0x02},
	{0x7780, 0x05},
	{0x7781, 0x78},
	{0x7782, 0x00},
	{0x7783, 0x01},
	{0x7784, 0x05},
	{0x7785, 0x7c},
	{0x7786, 0x02},
	{0x7787, 0x90},
	{0x7788, 0x05},
	{0x7789, 0x03},
	{0x778a, 0x07},
	{0x778b, 0x00},
	{0x778c, 0x0f},
	{0x778d, 0x00},
	{0x778e, 0x08},
	{0x778f, 0x30},
	{0x7790, 0x08},
	{0x7791, 0xee},
	{0x7792, 0x0f},
	{0x7793, 0x00},
	{0x7794, 0x05},
	{0x7795, 0x33},
	{0x7796, 0x04},
	{0x7797, 0xe5},
	{0x7798, 0x06},
	{0x7799, 0x52},
	{0x779a, 0x04},
	{0x779b, 0xe4},
	{0x779c, 0x00},
	{0x779d, 0x00},
	{0x779e, 0x06},
	{0x779f, 0x5e},
	{0x77a0, 0x00},
	{0x77a1, 0x0f},
	{0x77a2, 0x06},
	{0x77a3, 0x1e},
	{0x77a4, 0x00},
	{0x77a5, 0x02},
	{0x77a6, 0x06},
	{0x77a7, 0xa2},
	{0x77a8, 0x00},
	{0x77a9, 0x01},
	{0x77aa, 0x06},
	{0x77ab, 0xae},
	{0x77ac, 0x00},
	{0x77ad, 0x03},
	{0x77ae, 0x05},
	{0x77af, 0x30},
	{0x77b0, 0x09},
	{0x77b1, 0x19},
	{0x77b2, 0x0f},
	{0x77b3, 0x00},
	{0x77b4, 0x05},
	{0x77b5, 0x33},
	{0x77b6, 0x04},
	{0x77b7, 0xe5},
	{0x77b8, 0x06},
	{0x77b9, 0x52},
	{0x77ba, 0x04},
	{0x77bb, 0xe4},
	{0x77bc, 0x00},
	{0x77bd, 0x00},
	{0x77be, 0x06},
	{0x77bf, 0x5e},
	{0x77c0, 0x00},
	{0x77c1, 0x0f},
	{0x77c2, 0x06},
	{0x77c3, 0x1e},
	{0x77c4, 0x00},
	{0x77c5, 0x02},
	{0x77c6, 0x06},
	{0x77c7, 0xa2},
	{0x77c8, 0x00},
	{0x77c9, 0x01},
	{0x77ca, 0x06},
	{0x77cb, 0xae},
	{0x77cc, 0x00},
	{0x77cd, 0x03},
	{0x77ce, 0x05},
	{0x77cf, 0x30},
	{0x77d0, 0x0f},
	{0x77d1, 0x00},
	{0x77d2, 0x00},
	{0x77d3, 0x00},
	{0x77d4, 0x00},
	{0x77d5, 0x02},
	{0x77d6, 0x04},
	{0x77d7, 0xe5},
	{0x77d8, 0x04},
	{0x77d9, 0xe4},
	{0x77da, 0x05},
	{0x77db, 0x33},
	{0x77dc, 0x07},
	{0x77dd, 0x10},
	{0x77de, 0x00},
	{0x77df, 0x00},
	{0x77e0, 0x01},
	{0x77e1, 0xbb},
	{0x77e2, 0x00},
	{0x77e3, 0x00},
	{0x77e4, 0x01},
	{0x77e5, 0xaa},
	{0x77e6, 0x00},
	{0x77e7, 0x00},
	{0x77e8, 0x01},
	{0x77e9, 0x99},
	{0x77ea, 0x00},
	{0x77eb, 0x00},
	{0x77ec, 0x01},
	{0x77ed, 0x88},
	{0x77ee, 0x00},
	{0x77ef, 0x00},
	{0x77f0, 0x01},
	{0x77f1, 0x77},
	{0x77f2, 0x00},
	{0x77f3, 0x00},
	{0x77f4, 0x01},
	{0x77f5, 0x66},
	{0x77f6, 0x00},
	{0x77f7, 0x00},
	{0x77f8, 0x01},
	{0x77f9, 0x55},
	{0x77fa, 0x00},
	{0x77fb, 0x00},
	{0x77fc, 0x01},
	{0x77fd, 0x44},
	{0x77fe, 0x00},
	{0x77ff, 0x00},
	{0x7800, 0x01},
	{0x7801, 0x33},
	{0x7802, 0x00},
	{0x7803, 0x00},
	{0x7804, 0x01},
	{0x7805, 0x22},
	{0x7806, 0x00},
	{0x7807, 0x00},
	{0x7808, 0x01},
	{0x7809, 0x11},
	{0x780a, 0x00},
	{0x780b, 0x00},
	{0x780c, 0x01},
	{0x780d, 0x00},
	{0x780e, 0x01},
	{0x780f, 0xff},
	{0x7810, 0x07},
	{0x7811, 0x00},
	{0x7812, 0x02},
	{0x7813, 0xa0},
	{0x7814, 0x0f},
	{0x7815, 0x00},
	{0x7816, 0x08},
	{0x7817, 0x35},
	{0x7818, 0x06},
	{0x7819, 0x52},
	{0x781a, 0x04},
	{0x781b, 0xe4},
	{0x781c, 0x00},
	{0x781d, 0x00},
	{0x781e, 0x06},
	{0x781f, 0x5e},
	{0x7820, 0x05},
	{0x7821, 0x33},
	{0x7822, 0x09},
	{0x7823, 0x19},
	{0x7824, 0x06},
	{0x7825, 0x1e},
	{0x7826, 0x05},
	{0x7827, 0x33},
	{0x7828, 0x00},
	{0x7829, 0x01},
	{0x782a, 0x06},
	{0x782b, 0x24},
	{0x782c, 0x06},
	{0x782d, 0x20},
	{0x782e, 0x0f},
	{0x782f, 0x00},
	{0x7830, 0x08},
	{0x7831, 0x35},
	{0x7832, 0x07},
	{0x7833, 0x10},
	{0x7834, 0x00},
	{0x7835, 0x00},
	{0x7836, 0x01},
	{0x7837, 0xbb},
	{0x7838, 0x00},
	{0x7839, 0x00},
	{0x783a, 0x01},
	{0x783b, 0xaa},
	{0x783c, 0x00},
	{0x783d, 0x00},
	{0x783e, 0x01},
	{0x783f, 0x99},
	{0x7840, 0x00},
	{0x7841, 0x00},
	{0x7842, 0x01},
	{0x7843, 0x88},
	{0x7844, 0x00},
	{0x7845, 0x00},
	{0x7846, 0x01},
	{0x7847, 0x77},
	{0x7848, 0x00},
	{0x7849, 0x00},
	{0x784a, 0x01},
	{0x784b, 0x66},
	{0x784c, 0x00},
	{0x784d, 0x00},
	{0x784e, 0x01},
	{0x784f, 0x55},
	{0x7850, 0x00},
	{0x7851, 0x00},
	{0x7852, 0x01},
	{0x7853, 0x44},
	{0x7854, 0x00},
	{0x7855, 0x00},
	{0x7856, 0x01},
	{0x7857, 0x33},
	{0x7858, 0x00},
	{0x7859, 0x00},
	{0x785a, 0x01},
	{0x785b, 0x22},
	{0x785c, 0x00},
	{0x785d, 0x00},
	{0x785e, 0x01},
	{0x785f, 0x11},
	{0x7860, 0x00},
	{0x7861, 0x00},
	{0x7862, 0x01},
	{0x7863, 0x00},
	{0x7864, 0x07},
	{0x7865, 0x00},
	{0x7866, 0x01},
	{0x7867, 0xff},
	{0x7868, 0x02},
	{0x7869, 0xa0},
	{0x786a, 0x0f},
	{0x786b, 0x00},
	{0x786c, 0x08},
	{0x786d, 0x3a},
	{0x786e, 0x08},
	{0x786f, 0x6a},
	{0x7870, 0x0f},
	{0x7871, 0x00},
	{0x7872, 0x04},
	{0x7873, 0xc0},
	{0x7874, 0x09},
	{0x7875, 0x19},
	{0x7876, 0x04},
	{0x7877, 0x99},
	{0x7878, 0x07},
	{0x7879, 0x14},
	{0x787a, 0x00},
	{0x787b, 0x01},
	{0x787c, 0x04},
	{0x787d, 0xa4},
	{0x787e, 0x00},
	{0x787f, 0x0f},
	{0x7880, 0x00},
	{0x7881, 0x0f},
	{0x7882, 0x04},
	{0x7883, 0xa6},
	{0x7884, 0x00},
	{0x7885, 0x00},
	{0x7886, 0x04},
	{0x7887, 0xa0},
	{0x7888, 0x04},
	{0x7889, 0x80},
	{0x788a, 0x04},
	{0x788b, 0x00},
	{0x788c, 0x05},
	{0x788d, 0x03},
	{0x788e, 0x06},
	{0x788f, 0x00},
	{0x7890, 0x0f},
	{0x7891, 0x00},
	{0x7892, 0x0f},
	{0x7893, 0x00},
	{0x7894, 0x0f},
	{0x7895, 0x00},
	{0x30a0, 0x00},
	{0x30a1, 0x00},
	{0x30a2, 0x00},
	{0x30a3, 0x00},
	{0x30a4, 0x07},
	{0x30a5, 0x8f},
	{0x30a6, 0x04},
	{0x30a7, 0x47},
	{0x30a8, 0x00},
	{0x30a9, 0x04},
	{0x30aa, 0x00},
	{0x30ab, 0x04},
	{0x30ac, 0x07},
	{0x30ad, 0x88},
	{0x30ae, 0x04},
	{0x30af, 0x40},
	{0x30a0, 0x00},
	{0x30a1, 0x04},
	{0x30a2, 0x00},
	{0x30a3, 0x04},
	{0x30a4, 0x07},
	{0x30a5, 0x8B},
	{0x30a6, 0x04},
	{0x30a7, 0x43},
	{0x30a8, 0x00},
	{0x30a9, 0x04},
	{0x30aa, 0x00},
	{0x30ab, 0x04},
	{0x30ac, 0x07},
	{0x30ad, 0x80},
	{0x30ae, 0x04},
	{0x30af, 0x38},
	{0x3195, 0x26},
	{0x3196, 0x00},
	{0x3197, 0x0A},
	{0x3191, 0x99},
	{0x31a0, 0x24},
	{0x31e3, 0x01},
	{0x31e4, 0x08},
	{0x31fe, 0x03},
	{0x31a3, 0x08},
	{0x30b0, 0x08},
	{0x30b1, 0x98},
	{0x30b2, 0x07},
	{0x30b3, 0x1A},
	{0x3250, 0xF7},
	{0x30b0, 0x0d},
	{0x30b1, 0xde},
	{0x30b2, 0x04},
	{0x30b3, 0x66},
	{0x3196, 0x00},
	{0x3197, 0x0a},
	{0x3195, 0x29},
	{0x30bb, 0x14},
	{0x315a, 0x02},
	{0x315b, 0x00},
	{0x315c, 0x01},
	{0x315d, 0x80},
	{0x315e, 0x01},
	{0x315f, 0x80},
	{0x3250, 0xf7},
	{REG_NULL, 0x00},
};

/* two lanes,raw 12bit */
static const struct regval ov2718_linear12bit_init_tab_1920_1080[] = {
	{0x3013, 0x01},
	{REG_DELAY, 0x10},
	{0x3000, 0x02},
	{0x3001, 0x28},
	{0x3002, 0x03},
	{0x3003, 0x01},
	{0x3004, 0x02},
	{0x3005, 0x26},
	{0x3006, 0x00},
	{0x3007, 0x07},
	{0x3008, 0x01},
	{0x3009, 0x00},
	{0x300c, 0x6c},
	{0x300e, 0x80},
	{0x300f, 0x00},
	{0x3012, 0x00},
	{0x3013, 0x00},
	{0x3014, 0xc4},
	{0x3015, 0x00},
	{0x3017, 0x00},
	{0x3018, 0x00},
	{0x3019, 0x00},
	{0x301a, 0x00},
	{0x301b, 0x01},
	{0x301e, 0x17},
	{0x301f, 0xe1},
	{0x3030, 0x02},
	{0x3031, 0x72},
	{0x3032, 0xf0},
	{0x3033, 0x30},
	{0x3034, 0x3f},
	{0x3035, 0x5f},
	{0x3036, 0x02},
	{0x3037, 0x9f},
	{0x3038, 0x04},
	{0x3039, 0xb7},
	{0x303a, 0x04},
	{0x303b, 0x07},
	{0x303c, 0xf0},
	{0x303d, 0x00},
	{0x303e, 0x0b},
	{0x303f, 0xe3},
	{0x3040, 0xf3},
	{0x3041, 0x29},
	{0x3042, 0xf6},
	{0x3043, 0x65},
	{0x3044, 0x06},
	{0x3045, 0x0f},
	{0x3046, 0x59},
	{0x3047, 0x07},
	{0x3048, 0x82},
	{0x3049, 0xcf},
	{0x304a, 0x12},
	{0x304b, 0x40},
	{0x304c, 0x33},
	{0x304d, 0xa4},
	{0x304e, 0x0b},
	{0x304f, 0x3d},
	{0x3050, 0x10},
	{0x3060, 0x00},
	{0x3061, 0x64},
	{0x3062, 0x00},
	{0x3063, 0xe4},
	{0x3066, 0x80},
	{0x3080, 0x00},
	{0x3081, 0x00},
	{0x3082, 0x01},
	{0x3083, 0xe3},
	{0x3084, 0x06},
	{0x3085, 0x00},
	{0x3086, 0x10},
	{0x3087, 0x10},
	{0x3089, 0x00},
	{0x308a, 0x01},
	{0x3093, 0x00},
	{0x30a0, 0x00},
	{0x30a1, 0x00},
	{0x30a2, 0x00},
	{0x30a3, 0x00},
	{0x30a4, 0x07},
	{0x30a5, 0x8f},
	{0x30a6, 0x04},
	{0x30a7, 0x47},
	{0x30a8, 0x00},
	{0x30a9, 0x00},
	{0x30aa, 0x00},
	{0x30ab, 0x00},
	{0x30ac, 0x07},
	{0x30ad, 0x90},
	{0x30ae, 0x04},
	{0x30af, 0x48},
	{0x30b0, 0x04},
	{0x30b1, 0x7e},
	{0x30b2, 0x04},
	{0x30b3, 0x65},
	{0x30b4, 0x00},
	{0x30b5, 0x00},
	{0x30b6, 0x00},
	{0x30b7, 0x10},
	{0x30b8, 0x00},
	{0x30b9, 0x02},
	{0x30ba, 0x10},
	{0x30bb, 0x00},
	{0x30bc, 0x00},
	{0x30bd, 0x03},
	{0x30be, 0x5c},
	{0x30bf, 0x00},
	{0x30c0, 0x01},
	{0x30c1, 0x00},
	{0x30c2, 0x20},
	{0x30c3, 0x00},
	{0x30c4, 0x4a},
	{0x30c5, 0x00},
	{0x30c7, 0x00},
	{0x30c8, 0x00},
	{0x30d1, 0x00},
	{0x30d2, 0x00},
	{0x30d3, 0x80},
	{0x30d4, 0x00},
	{0x30d9, 0x09},
	{0x30da, 0x64},
	{0x30dd, 0x00},
	{0x30de, 0x16},
	{0x30df, 0x00},
	{0x30e0, 0x17},
	{0x30e1, 0x00},
	{0x30e2, 0x18},
	{0x30e3, 0x10},
	{0x30e4, 0x04},
	{0x30e5, 0x00},
	{0x30e6, 0x00},
	{0x30e7, 0x00},
	{0x30e8, 0x00},
	{0x30e9, 0x00},
	{0x30ea, 0x00},
	{0x30eb, 0x00},
	{0x30ec, 0x00},
	{0x30ed, 0x00},
	{0x3101, 0x00},
	{0x3102, 0x00},
	{0x3103, 0x00},
	{0x3104, 0x00},
	{0x3105, 0x8c},
	{0x3106, 0x87},
	{0x3107, 0xc0},
	{0x3108, 0x9d},
	{0x3109, 0x8d},
	{0x310a, 0x8d},
	{0x310b, 0x6a},
	{0x310c, 0x3a},
	{0x310d, 0x5a},
	{0x310e, 0x00},
	{0x3120, 0x00},
	{0x3121, 0x00},
	{0x3122, 0x00},
	{0x3123, 0xf0},
	{0x3124, 0x00},
	{0x3125, 0x70},
	{0x3126, 0x1f},
	{0x3127, 0x0f},
	{0x3128, 0x00},
	{0x3129, 0x3a},
	{0x312a, 0x02},
	{0x312b, 0x0f},
	{0x312c, 0x00},
	{0x312d, 0x0f},
	{0x312e, 0x1d},
	{0x312f, 0x00},
	{0x3130, 0x00},
	{0x3131, 0x00},
	{0x3132, 0x00},
	{0x3140, 0x0a},
	{0x3141, 0x03},
	{0x3142, 0x00},
	{0x3143, 0x00},
	{0x3144, 0x00},
	{0x3145, 0x00},
	{0x3146, 0x00},
	{0x3147, 0x00},
	{0x3148, 0x00},
	{0x3149, 0x00},
	{0x314a, 0x00},
	{0x314b, 0x00},
	{0x314c, 0x00},
	{0x314d, 0x00},
	{0x314e, 0x1c},
	{0x314f, 0xff},
	{0x3150, 0xff},
	{0x3151, 0xff},
	{0x3152, 0x10},
	{0x3153, 0x10},
	{0x3154, 0x10},
	{0x3155, 0x00},
	{0x3156, 0x03},
	{0x3157, 0x00},
	{0x3158, 0x0f},
	{0x3159, 0xff},
	{0x315a, 0x01},
	{0x315b, 0x00},
	{0x315c, 0x01},
	{0x315d, 0x00},
	{0x315e, 0x01},
	{0x315f, 0x00},
	{0x3160, 0x00},
	{0x3161, 0x40},
	{0x3162, 0x00},
	{0x3163, 0x40},
	{0x3164, 0x00},
	{0x3165, 0x40},
	{0x3190, 0x08},
	{0x3191, 0x99},
	{0x3193, 0x08},
	{0x3194, 0x13},
	{0x3195, 0x33},
	{0x3196, 0x00},
	{0x3197, 0x10},
	{0x3198, 0x00},
	{0x3199, 0x7f},
	{0x319a, 0x80},
	{0x319b, 0xff},
	{0x319c, 0x80},
	{0x319d, 0xbf},
	{0x319e, 0xc0},
	{0x319f, 0xff},
	{0x31a0, 0x24},
	{0x31a1, 0x55},
	{0x31a2, 0x00},
	{0x31a3, 0x00},
	{0x31a6, 0x00},
	{0x31a7, 0x00},
	{0x31b0, 0x00},
	{0x31b1, 0x00},
	{0x31b2, 0x02},
	{0x31b3, 0x00},
	{0x31b4, 0x00},
	{0x31b5, 0x01},
	{0x31b6, 0x00},
	{0x31b7, 0x00},
	{0x31b8, 0x00},
	{0x31b9, 0x00},
	{0x31ba, 0x00},
	{0x31d0, 0x3c},
	{0x31d1, 0x34},
	{0x31d2, 0x3c},
	{0x31d3, 0x00},
	{0x31d4, 0x2d},
	{0x31d5, 0x00},
	{0x31d6, 0x01},
	{0x31d7, 0x06},
	{0x31d8, 0x00},
	{0x31d9, 0x64},
	{0x31da, 0x00},
	{0x31db, 0x30},
	{0x31dc, 0x04},
	{0x31dd, 0x69},
	{0x31de, 0x0a},
	{0x31df, 0x3c},
	{0x31e0, 0x04},
	{0x31e1, 0x32},
	{0x31e2, 0x00},
	{0x31e3, 0x00},
	{0x31e4, 0x08},
	{0x31e5, 0x80},
	{0x31e6, 0x00},
	{0x31e7, 0x2c},
	{0x31e8, 0x6c},
	{0x31e9, 0xac},
	{0x31ea, 0xec},
	{0x31eb, 0x3f},
	{0x31ec, 0x0f},
	{0x31ed, 0x20},
	{0x31ee, 0x04},
	{0x31ef, 0x48},
	{0x31f0, 0x07},
	{0x31f1, 0x90},
	{0x31f2, 0x04},
	{0x31f3, 0x48},
	{0x31f4, 0x07},
	{0x31f5, 0x90},
	{0x31f6, 0x04},
	{0x31f7, 0x48},
	{0x31f8, 0x07},
	{0x31f9, 0x90},
	{0x31fa, 0x04},
	{0x31fb, 0x48},
	{0x31fd, 0xcb},
	{0x31fe, 0x03},
	{0x31ff, 0x03},
	{0x3200, 0x00},
	{0x3201, 0xff},
	{0x3202, 0x00},
	{0x3203, 0xff},
	{0x3204, 0xff},
	{0x3205, 0xff},
	{0x3206, 0xff},
	{0x3207, 0xff},
	{0x3208, 0xff},
	{0x3209, 0xff},
	{0x320a, 0xff},
	{0x320b, 0x1b},
	{0x320c, 0x1f},
	{0x320d, 0x1e},
	{0x320e, 0x30},
	{0x320f, 0x2d},
	{0x3210, 0x2c},
	{0x3211, 0x2b},
	{0x3212, 0x2a},
	{0x3213, 0x24},
	{0x3214, 0x22},
	{0x3215, 0x00},
	{0x3216, 0x04},
	{0x3217, 0x2c},
	{0x3218, 0x6c},
	{0x3219, 0xac},
	{0x321a, 0xec},
	{0x321b, 0x00},
	{0x3230, 0x3a},
	{0x3231, 0x00},
	{0x3232, 0x80},
	{0x3233, 0x00},
	{0x3234, 0x10},
	{0x3235, 0xaa},
	{0x3236, 0x55},
	{0x3237, 0x99},
	{0x3238, 0x66},
	{0x3239, 0x08},
	{0x323a, 0x88},
	{0x323b, 0x00},
	{0x323c, 0x00},
	{0x323d, 0x03},
	{0x3250, 0x33},
	{0x3251, 0x00},
	{0x3252, 0x20},
	{0x3253, 0x00},
	{0x3254, 0x00},
	{0x3255, 0x01},
	{0x3256, 0x00},
	{0x3257, 0x00},
	{0x3258, 0x00},
	{0x3270, 0x01},
	{0x3271, 0x60},
	{0x3272, 0xc0},
	{0x3273, 0x00},
	{0x3274, 0x80},
	{0x3275, 0x40},
	{0x3276, 0x02},
	{0x3277, 0x08},
	{0x3278, 0x10},
	{0x3279, 0x04},
	{0x327a, 0x00},
	{0x327b, 0x03},
	{0x327c, 0x10},
	{0x327d, 0x60},
	{0x327e, 0xc0},
	{0x327f, 0x06},
	{0x3288, 0x10},
	{0x3289, 0x00},
	{0x328a, 0x08},
	{0x328b, 0x00},
	{0x328c, 0x04},
	{0x328d, 0x00},
	{0x328e, 0x02},
	{0x328f, 0x00},
	{0x3290, 0x20},
	{0x3291, 0x00},
	{0x3292, 0x10},
	{0x3293, 0x00},
	{0x3294, 0x08},
	{0x3295, 0x00},
	{0x3296, 0x04},
	{0x3297, 0x00},
	{0x3298, 0x40},
	{0x3299, 0x00},
	{0x329a, 0x20},
	{0x329b, 0x00},
	{0x329c, 0x10},
	{0x329d, 0x00},
	{0x329e, 0x08},
	{0x329f, 0x00},
	{0x32a0, 0x7f},
	{0x32a1, 0xff},
	{0x32a2, 0x40},
	{0x32a3, 0x00},
	{0x32a4, 0x20},
	{0x32a5, 0x00},
	{0x32a6, 0x10},
	{0x32a7, 0x00},
	{0x32a8, 0x00},
	{0x32a9, 0x00},
	{0x32aa, 0x00},
	{0x32ab, 0x00},
	{0x32ac, 0x00},
	{0x32ad, 0x00},
	{0x32ae, 0x00},
	{0x32af, 0x00},
	{0x32b0, 0x00},
	{0x32b1, 0x00},
	{0x32b2, 0x00},
	{0x32b3, 0x00},
	{0x32b4, 0x00},
	{0x32b5, 0x00},
	{0x32b6, 0x00},
	{0x32b7, 0x00},
	{0x32b8, 0x00},
	{0x32b9, 0x00},
	{0x32ba, 0x00},
	{0x32bb, 0x00},
	{0x32bc, 0x00},
	{0x32bd, 0x00},
	{0x32be, 0x00},
	{0x32bf, 0x00},
	{0x32c0, 0x00},
	{0x32c1, 0x00},
	{0x32c2, 0x00},
	{0x32c3, 0x00},
	{0x32c4, 0x00},
	{0x32c5, 0x00},
	{0x32c6, 0x00},
	{0x32c7, 0x00},
	{0x32c8, 0x87},
	{0x32c9, 0x00},
	{0x3330, 0x03},
	{0x3331, 0xc8},
	{0x3332, 0x02},
	{0x3333, 0x24},
	{0x3334, 0x00},
	{0x3335, 0x00},
	{0x3336, 0x00},
	{0x3337, 0x00},
	{0x3338, 0x03},
	{0x3339, 0xc8},
	{0x333a, 0x02},
	{0x333b, 0x24},
	{0x333c, 0x00},
	{0x333d, 0x00},
	{0x333e, 0x00},
	{0x333f, 0x00},
	{0x3340, 0x03},
	{0x3341, 0xc8},
	{0x3342, 0x02},
	{0x3343, 0x24},
	{0x3344, 0x00},
	{0x3345, 0x00},
	{0x3346, 0x00},
	{0x3347, 0x00},
	{0x3348, 0x40},
	{0x3349, 0x00},
	{0x334a, 0x00},
	{0x334b, 0x00},
	{0x334c, 0x00},
	{0x334d, 0x00},
	{0x334e, 0x80},
	{0x3360, 0x01},
	{0x3361, 0x00},
	{0x3362, 0x01},
	{0x3363, 0x00},
	{0x3364, 0x01},
	{0x3365, 0x00},
	{0x3366, 0x01},
	{0x3367, 0x00},
	{0x3368, 0x01},
	{0x3369, 0x00},
	{0x336a, 0x01},
	{0x336b, 0x00},
	{0x336c, 0x01},
	{0x336d, 0x00},
	{0x336e, 0x01},
	{0x336f, 0x00},
	{0x3370, 0x01},
	{0x3371, 0x00},
	{0x3372, 0x01},
	{0x3373, 0x00},
	{0x3374, 0x01},
	{0x3375, 0x00},
	{0x3376, 0x01},
	{0x3377, 0x00},
	{0x3378, 0x00},
	{0x3379, 0x00},
	{0x337a, 0x00},
	{0x337b, 0x00},
	{0x337c, 0x00},
	{0x337d, 0x00},
	{0x337e, 0x00},
	{0x337f, 0x00},
	{0x3380, 0x00},
	{0x3381, 0x00},
	{0x3382, 0x00},
	{0x3383, 0x00},
	{0x3384, 0x00},
	{0x3385, 0x00},
	{0x3386, 0x00},
	{0x3387, 0x00},
	{0x3388, 0x00},
	{0x3389, 0x00},
	{0x338a, 0x00},
	{0x338b, 0x00},
	{0x338c, 0x00},
	{0x338d, 0x00},
	{0x338e, 0x00},
	{0x338f, 0x00},
	{0x3390, 0x00},
	{0x3391, 0x00},
	{0x3392, 0x00},
	{0x3393, 0x00},
	{0x3394, 0x00},
	{0x3395, 0x00},
	{0x3396, 0x00},
	{0x3397, 0x00},
	{0x3398, 0x00},
	{0x3399, 0x00},
	{0x339a, 0x00},
	{0x339b, 0x00},
	{0x33b0, 0x00},
	{0x33b1, 0x50},
	{0x33b2, 0x01},
	{0x33b3, 0xff},
	{0x33b4, 0xe0},
	{0x33b5, 0x6b},
	{0x33b6, 0x00},
	{0x33b7, 0x00},
	{0x33b8, 0x00},
	{0x33b9, 0x00},
	{0x33ba, 0x00},
	{0x33bb, 0x1f},
	{0x33bc, 0x01},
	{0x33bd, 0x01},
	{0x33be, 0x01},
	{0x33bf, 0x01},
	{0x33c0, 0x00},
	{0x33c1, 0x00},
	{0x33c2, 0x00},
	{0x33c3, 0x00},
	{0x33e0, 0x14},
	{0x33e1, 0x0f},
	{0x33e2, 0x02},
	{0x33e3, 0x01},
	{0x33e4, 0x01},
	{0x33e5, 0x01},
	{0x33e6, 0x00},
	{0x33e7, 0x04},
	{0x33e8, 0x0c},
	{0x33e9, 0x02},
	{0x33ea, 0x02},
	{0x33eb, 0x02},
	{0x33ec, 0x03},
	{0x33ed, 0x01},
	{0x33ee, 0x02},
	{0x33ef, 0x08},
	{0x33f0, 0x08},
	{0x33f1, 0x04},
	{0x33f2, 0x04},
	{0x33f3, 0x00},
	{0x33f4, 0x03},
	{0x33f5, 0x14},
	{0x33f6, 0x0f},
	{0x33f7, 0x02},
	{0x33f8, 0x01},
	{0x33f9, 0x01},
	{0x33fa, 0x01},
	{0x33fb, 0x00},
	{0x33fc, 0x04},
	{0x33fd, 0x0c},
	{0x33fe, 0x02},
	{0x33ff, 0x02},
	{0x3400, 0x02},
	{0x3401, 0x03},
	{0x3402, 0x01},
	{0x3403, 0x02},
	{0x3404, 0x08},
	{0x3405, 0x08},
	{0x3406, 0x04},
	{0x3407, 0x04},
	{0x3408, 0x00},
	{0x3409, 0x03},
	{0x340a, 0x14},
	{0x340b, 0x0f},
	{0x340c, 0x04},
	{0x340d, 0x02},
	{0x340e, 0x01},
	{0x340f, 0x01},
	{0x3410, 0x00},
	{0x3411, 0x04},
	{0x3412, 0x0c},
	{0x3413, 0x00},
	{0x3414, 0x01},
	{0x3415, 0x02},
	{0x3416, 0x03},
	{0x3417, 0x02},
	{0x3418, 0x05},
	{0x3419, 0x0a},
	{0x341a, 0x08},
	{0x341b, 0x04},
	{0x341c, 0x04},
	{0x341d, 0x00},
	{0x341e, 0x03},
	{0x3440, 0x00},
	{0x3441, 0x00},
	{0x3442, 0x00},
	{0x3443, 0x00},
	{0x3444, 0x02},
	{0x3445, 0xf0},
	{0x3446, 0x02},
	{0x3447, 0x08},
	{0x3448, 0x00},
	{0x3460, 0x40},
	{0x3461, 0x40},
	{0x3462, 0x40},
	{0x3463, 0x40},
	{0x3464, 0x03},
	{0x3465, 0x01},
	{0x3466, 0x01},
	{0x3467, 0x02},
	{0x3468, 0x30},
	{0x3469, 0x00},
	{0x346a, 0x33},
	{0x346b, 0xbf},
	{0x3480, 0x40},
	{0x3481, 0x00},
	{0x3482, 0x00},
	{0x3483, 0x00},
	{0x3484, 0x0d},
	{0x3485, 0x00},
	{0x3486, 0x00},
	{0x3487, 0x00},
	{0x3488, 0x00},
	{0x3489, 0x00},
	{0x348a, 0x00},
	{0x348b, 0x04},
	{0x348c, 0x00},
	{0x348d, 0x01},
	{0x348f, 0x01},
	{0x3030, 0x0a},
	{0x3030, 0x02},
	{0x7000, 0x58},
	{0x7001, 0x7a},
	{0x7002, 0x1a},
	{0x7003, 0xc1},
	{0x7004, 0x03},
	{0x7005, 0xda},
	{0x7006, 0xbd},
	{0x7007, 0x03},
	{0x7008, 0xbd},
	{0x7009, 0x06},
	{0x700a, 0xe6},
	{0x700b, 0xec},
	{0x700c, 0xbc},
	{0x700d, 0xff},
	{0x700e, 0xbc},
	{0x700f, 0x73},
	{0x7010, 0xda},
	{0x7011, 0x72},
	{0x7012, 0x76},
	{0x7013, 0xb6},
	{0x7014, 0xee},
	{0x7015, 0xcf},
	{0x7016, 0xac},
	{0x7017, 0xd0},
	{0x7018, 0xac},
	{0x7019, 0xd1},
	{0x701a, 0x50},
	{0x701b, 0xac},
	{0x701c, 0xd2},
	{0x701d, 0xbc},
	{0x701e, 0x2e},
	{0x701f, 0xb4},
	{0x7020, 0x00},
	{0x7021, 0xdc},
	{0x7022, 0xdf},
	{0x7023, 0xb0},
	{0x7024, 0x6e},
	{0x7025, 0xbd},
	{0x7026, 0x01},
	{0x7027, 0xd7},
	{0x7028, 0xed},
	{0x7029, 0xe1},
	{0x702a, 0x36},
	{0x702b, 0x30},
	{0x702c, 0xd3},
	{0x702d, 0x2e},
	{0x702e, 0x54},
	{0x702f, 0x46},
	{0x7030, 0xbc},
	{0x7031, 0x22},
	{0x7032, 0x66},
	{0x7033, 0xbc},
	{0x7034, 0x24},
	{0x7035, 0x2c},
	{0x7036, 0x28},
	{0x7037, 0xbc},
	{0x7038, 0x3c},
	{0x7039, 0xa1},
	{0x703a, 0xac},
	{0x703b, 0xd8},
	{0x703c, 0xd6},
	{0x703d, 0xb4},
	{0x703e, 0x04},
	{0x703f, 0x46},
	{0x7040, 0xb7},
	{0x7041, 0x04},
	{0x7042, 0xbe},
	{0x7043, 0x08},
	{0x7044, 0xc3},
	{0x7045, 0xd9},
	{0x7046, 0xad},
	{0x7047, 0xc3},
	{0x7048, 0xbc},
	{0x7049, 0x19},
	{0x704a, 0xc1},
	{0x704b, 0x27},
	{0x704c, 0xe7},
	{0x704d, 0x00},
	{0x704e, 0x50},
	{0x704f, 0x20},
	{0x7050, 0xb8},
	{0x7051, 0x02},
	{0x7052, 0xbc},
	{0x7053, 0x17},
	{0x7054, 0xdb},
	{0x7055, 0xc7},
	{0x7056, 0xb8},
	{0x7057, 0x00},
	{0x7058, 0x28},
	{0x7059, 0x54},
	{0x705a, 0xb4},
	{0x705b, 0x14},
	{0x705c, 0xab},
	{0x705d, 0xbe},
	{0x705e, 0x06},
	{0x705f, 0xd8},
	{0x7060, 0xd6},
	{0x7061, 0x00},
	{0x7062, 0xb4},
	{0x7063, 0xc7},
	{0x7064, 0x07},
	{0x7065, 0xb9},
	{0x7066, 0x05},
	{0x7067, 0xee},
	{0x7068, 0xe6},
	{0x7069, 0xad},
	{0x706a, 0xb4},
	{0x706b, 0x26},
	{0x706c, 0x19},
	{0x706d, 0xc1},
	{0x706e, 0x3a},
	{0x706f, 0xc3},
	{0x7070, 0xaf},
	{0x7071, 0x00},
	{0x7072, 0xc0},
	{0x7073, 0x3c},
	{0x7074, 0xc3},
	{0x7075, 0xbe},
	{0x7076, 0xe7},
	{0x7077, 0x00},
	{0x7078, 0x15},
	{0x7079, 0xc2},
	{0x707a, 0x40},
	{0x707b, 0xc3},
	{0x707c, 0xa4},
	{0x707d, 0xc0},
	{0x707e, 0x3c},
	{0x707f, 0x00},
	{0x7080, 0xb9},
	{0x7081, 0x64},
	{0x7082, 0x29},
	{0x7083, 0x00},
	{0x7084, 0xb8},
	{0x7085, 0x12},
	{0x7086, 0xbe},
	{0x7087, 0x01},
	{0x7088, 0xd0},
	{0x7089, 0xbc},
	{0x708a, 0x01},
	{0x708b, 0xac},
	{0x708c, 0x37},
	{0x708d, 0xd2},
	{0x708e, 0xac},
	{0x708f, 0x45},
	{0x7090, 0xad},
	{0x7091, 0x28},
	{0x7092, 0x00},
	{0x7093, 0xb8},
	{0x7094, 0x00},
	{0x7095, 0xbc},
	{0x7096, 0x01},
	{0x7097, 0x36},
	{0x7098, 0xd3},
	{0x7099, 0x30},
	{0x709a, 0x04},
	{0x709b, 0xe0},
	{0x709c, 0xd8},
	{0x709d, 0xb4},
	{0x709e, 0xe9},
	{0x709f, 0x00},
	{0x70a0, 0xbe},
	{0x70a1, 0x05},
	{0x70a2, 0x62},
	{0x70a3, 0x07},
	{0x70a4, 0xb9},
	{0x70a5, 0x05},
	{0x70a6, 0xad},
	{0x70a7, 0xc3},
	{0x70a8, 0xcf},
	{0x70a9, 0x00},
	{0x70aa, 0x15},
	{0x70ab, 0xc2},
	{0x70ac, 0x59},
	{0x70ad, 0xc3},
	{0x70ae, 0xc9},
	{0x70af, 0xc0},
	{0x70b0, 0x55},
	{0x70b1, 0x00},
	{0x70b2, 0x46},
	{0x70b3, 0xa1},
	{0x70b4, 0xb9},
	{0x70b5, 0x64},
	{0x70b6, 0x29},
	{0x70b7, 0x00},
	{0x70b8, 0xb8},
	{0x70b9, 0x02},
	{0x70ba, 0xbe},
	{0x70bb, 0x02},
	{0x70bc, 0xd0},
	{0x70bd, 0xdc},
	{0x70be, 0xac},
	{0x70bf, 0xbc},
	{0x70c0, 0x01},
	{0x70c1, 0x37},
	{0x70c2, 0xac},
	{0x70c3, 0xd2},
	{0x70c4, 0x45},
	{0x70c5, 0xad},
	{0x70c6, 0x28},
	{0x70c7, 0x00},
	{0x70c8, 0xb8},
	{0x70c9, 0x00},
	{0x70ca, 0xbc},
	{0x70cb, 0x01},
	{0x70cc, 0x36},
	{0x70cd, 0x30},
	{0x70ce, 0xe0},
	{0x70cf, 0xd8},
	{0x70d0, 0xb5},
	{0x70d1, 0x0b},
	{0x70d2, 0xd6},
	{0x70d3, 0xbe},
	{0x70d4, 0x07},
	{0x70d5, 0x00},
	{0x70d6, 0x62},
	{0x70d7, 0x07},
	{0x70d8, 0xb9},
	{0x70d9, 0x05},
	{0x70da, 0xad},
	{0x70db, 0xc3},
	{0x70dc, 0xcf},
	{0x70dd, 0x46},
	{0x70de, 0xcd},
	{0x70df, 0x07},
	{0x70e0, 0xcd},
	{0x70e1, 0x00},
	{0x70e2, 0xe3},
	{0x70e3, 0x18},
	{0x70e4, 0xc2},
	{0x70e5, 0xa2},
	{0x70e6, 0xb9},
	{0x70e7, 0x64},
	{0x70e8, 0xd1},
	{0x70e9, 0xdd},
	{0x70ea, 0xac},
	{0x70eb, 0xcf},
	{0x70ec, 0xdf},
	{0x70ed, 0xb5},
	{0x70ee, 0x19},
	{0x70ef, 0x46},
	{0x70f0, 0x50},
	{0x70f1, 0xb6},
	{0x70f2, 0xee},
	{0x70f3, 0xe8},
	{0x70f4, 0xe6},
	{0x70f5, 0xbc},
	{0x70f6, 0x31},
	{0x70f7, 0xe1},
	{0x70f8, 0x36},
	{0x70f9, 0x30},
	{0x70fa, 0xd3},
	{0x70fb, 0x2e},
	{0x70fc, 0x54},
	{0x70fd, 0xbd},
	{0x70fe, 0x03},
	{0x70ff, 0xec},
	{0x7100, 0x2c},
	{0x7101, 0x50},
	{0x7102, 0x20},
	{0x7103, 0x04},
	{0x7104, 0xb8},
	{0x7105, 0x02},
	{0x7106, 0xbc},
	{0x7107, 0x18},
	{0x7108, 0xc7},
	{0x7109, 0xb8},
	{0x710a, 0x00},
	{0x710b, 0x28},
	{0x710c, 0x54},
	{0x710d, 0xbc},
	{0x710e, 0x02},
	{0x710f, 0xb4},
	{0x7110, 0xda},
	{0x7111, 0xbe},
	{0x7112, 0x04},
	{0x7113, 0xd6},
	{0x7114, 0xd8},
	{0x7115, 0xab},
	{0x7116, 0x00},
	{0x7117, 0x62},
	{0x7118, 0x07},
	{0x7119, 0xb9},
	{0x711a, 0x05},
	{0x711b, 0xad},
	{0x711c, 0xc3},
	{0x711d, 0xbc},
	{0x711e, 0xe7},
	{0x711f, 0xb9},
	{0x7120, 0x64},
	{0x7121, 0x29},
	{0x7122, 0x00},
	{0x7123, 0xb8},
	{0x7124, 0x02},
	{0x7125, 0xbe},
	{0x7126, 0x00},
	{0x7127, 0x45},
	{0x7128, 0xad},
	{0x7129, 0xe2},
	{0x712a, 0x28},
	{0x712b, 0x00},
	{0x712c, 0xb8},
	{0x712d, 0x00},
	{0x712e, 0xe0},
	{0x712f, 0xd8},
	{0x7130, 0xb4},
	{0x7131, 0xe9},
	{0x7132, 0xbe},
	{0x7133, 0x03},
	{0x7134, 0x00},
	{0x7135, 0x30},
	{0x7136, 0x62},
	{0x7137, 0x07},
	{0x7138, 0xb9},
	{0x7139, 0x05},
	{0x713a, 0xad},
	{0x713b, 0xc3},
	{0x713c, 0xcf},
	{0x713d, 0x42},
	{0x713e, 0xe4},
	{0x713f, 0xcd},
	{0x7140, 0x07},
	{0x7141, 0xcd},
	{0x7142, 0x00},
	{0x7143, 0x00},
	{0x7144, 0x17},
	{0x7145, 0xc2},
	{0x7146, 0xbb},
	{0x7147, 0xde},
	{0x7148, 0xcf},
	{0x7149, 0xdf},
	{0x714a, 0xac},
	{0x714b, 0xd1},
	{0x714c, 0x44},
	{0x714d, 0xac},
	{0x714e, 0xb9},
	{0x714f, 0x76},
	{0x7150, 0xb8},
	{0x7151, 0x08},
	{0x7152, 0xb6},
	{0x7153, 0xfe},
	{0x7154, 0xb4},
	{0x7155, 0xca},
	{0x7156, 0xd6},
	{0x7157, 0xd8},
	{0x7158, 0xab},
	{0x7159, 0x00},
	{0x715a, 0xe1},
	{0x715b, 0x36},
	{0x715c, 0x30},
	{0x715d, 0xd3},
	{0x715e, 0xbc},
	{0x715f, 0x29},
	{0x7160, 0xb4},
	{0x7161, 0x1f},
	{0x7162, 0xaa},
	{0x7163, 0xbd},
	{0x7164, 0x01},
	{0x7165, 0xb8},
	{0x7166, 0x0c},
	{0x7167, 0x45},
	{0x7168, 0xa4},
	{0x7169, 0xbd},
	{0x716a, 0x03},
	{0x716b, 0xec},
	{0x716c, 0xbc},
	{0x716d, 0x3d},
	{0x716e, 0xc3},
	{0x716f, 0xcf},
	{0x7170, 0x42},
	{0x7171, 0xb8},
	{0x7172, 0x00},
	{0x7173, 0xe4},
	{0x7174, 0xd5},
	{0x7175, 0x00},
	{0x7176, 0xb6},
	{0x7177, 0x00},
	{0x7178, 0x74},
	{0x7179, 0xbd},
	{0x717a, 0x03},
	{0x717b, 0x40},
	{0x717c, 0xb5},
	{0x717d, 0x39},
	{0x717e, 0x58},
	{0x717f, 0xdd},
	{0x7180, 0x19},
	{0x7181, 0xc1},
	{0x7182, 0xc8},
	{0x7183, 0xbd},
	{0x7184, 0x06},
	{0x7185, 0x17},
	{0x7186, 0xc1},
	{0x7187, 0xc6},
	{0x7188, 0xe8},
	{0x7189, 0x00},
	{0x718a, 0xc0},
	{0x718b, 0xc8},
	{0x718c, 0xe6},
	{0x718d, 0x95},
	{0x718e, 0x15},
	{0x718f, 0x00},
	{0x7190, 0xbc},
	{0x7191, 0x19},
	{0x7192, 0xb9},
	{0x7193, 0xf6},
	{0x7194, 0x14},
	{0x7195, 0xc1},
	{0x7196, 0xd0},
	{0x7197, 0xd1},
	{0x7198, 0xac},
	{0x7199, 0x37},
	{0x719a, 0xbc},
	{0x719b, 0x35},
	{0x719c, 0x36},
	{0x719d, 0x30},
	{0x719e, 0xe1},
	{0x719f, 0xd3},
	{0x71a0, 0x7a},
	{0x71a1, 0xb6},
	{0x71a2, 0x0c},
	{0x71a3, 0xff},
	{0x71a4, 0xb4},
	{0x71a5, 0xc7},
	{0x71a6, 0xd9},
	{0x71a7, 0x00},
	{0x71a8, 0xbd},
	{0x71a9, 0x01},
	{0x71aa, 0x56},
	{0x71ab, 0xc0},
	{0x71ac, 0xda},
	{0x71ad, 0xb4},
	{0x71ae, 0x1f},
	{0x71af, 0x56},
	{0x71b0, 0xaa},
	{0x71b1, 0xbc},
	{0x71b2, 0x08},
	{0x71b3, 0x00},
	{0x71b4, 0x57},
	{0x71b5, 0xe8},
	{0x71b6, 0xb5},
	{0x71b7, 0x36},
	{0x71b8, 0x00},
	{0x71b9, 0x54},
	{0x71ba, 0xe7},
	{0x71bb, 0xc8},
	{0x71bc, 0xb4},
	{0x71bd, 0x1f},
	{0x71be, 0x56},
	{0x71bf, 0xaa},
	{0x71c0, 0xbc},
	{0x71c1, 0x08},
	{0x71c2, 0x57},
	{0x71c3, 0x00},
	{0x71c4, 0xb5},
	{0x71c5, 0x36},
	{0x71c6, 0x00},
	{0x71c7, 0x54},
	{0x71c8, 0xc8},
	{0x71c9, 0xb5},
	{0x71ca, 0x18},
	{0x71cb, 0xd9},
	{0x71cc, 0x00},
	{0x71cd, 0xbd},
	{0x71ce, 0x01},
	{0x71cf, 0x56},
	{0x71d0, 0x08},
	{0x71d1, 0x57},
	{0x71d2, 0xe8},
	{0x71d3, 0xb4},
	{0x71d4, 0x42},
	{0x71d5, 0x00},
	{0x71d6, 0x54},
	{0x71d7, 0xe7},
	{0x71d8, 0xc8},
	{0x71d9, 0xab},
	{0x71da, 0x00},
	{0x71db, 0x66},
	{0x71dc, 0x62},
	{0x71dd, 0x06},
	{0x71de, 0x74},
	{0x71df, 0xb9},
	{0x71e0, 0x05},
	{0x71e1, 0xb7},
	{0x71e2, 0x14},
	{0x71e3, 0x0e},
	{0x71e4, 0xb7},
	{0x71e5, 0x04},
	{0x71e6, 0xc8},
	{0x7600, 0x04},
	{0x7601, 0x80},
	{0x7602, 0x07},
	{0x7603, 0x44},
	{0x7604, 0x05},
	{0x7605, 0x33},
	{0x7606, 0x0f},
	{0x7607, 0x00},
	{0x7608, 0x07},
	{0x7609, 0x40},
	{0x760a, 0x04},
	{0x760b, 0xe5},
	{0x760c, 0x06},
	{0x760d, 0x50},
	{0x760e, 0x04},
	{0x760f, 0xe4},
	{0x7610, 0x00},
	{0x7611, 0x00},
	{0x7612, 0x06},
	{0x7613, 0x5c},
	{0x7614, 0x00},
	{0x7615, 0x0f},
	{0x7616, 0x06},
	{0x7617, 0x1c},
	{0x7618, 0x00},
	{0x7619, 0x02},
	{0x761a, 0x06},
	{0x761b, 0xa2},
	{0x761c, 0x00},
	{0x761d, 0x01},
	{0x761e, 0x06},
	{0x761f, 0xae},
	{0x7620, 0x00},
	{0x7621, 0x0e},
	{0x7622, 0x05},
	{0x7623, 0x30},
	{0x7624, 0x07},
	{0x7625, 0x00},
	{0x7626, 0x0f},
	{0x7627, 0x00},
	{0x7628, 0x04},
	{0x7629, 0xe5},
	{0x762a, 0x05},
	{0x762b, 0x33},
	{0x762c, 0x06},
	{0x762d, 0x12},
	{0x762e, 0x00},
	{0x762f, 0x01},
	{0x7630, 0x06},
	{0x7631, 0x52},
	{0x7632, 0x00},
	{0x7633, 0x01},
	{0x7634, 0x06},
	{0x7635, 0x5e},
	{0x7636, 0x04},
	{0x7637, 0xe4},
	{0x7638, 0x00},
	{0x7639, 0x01},
	{0x763a, 0x05},
	{0x763b, 0x30},
	{0x763c, 0x0f},
	{0x763d, 0x00},
	{0x763e, 0x06},
	{0x763f, 0xa6},
	{0x7640, 0x00},
	{0x7641, 0x02},
	{0x7642, 0x06},
	{0x7643, 0x26},
	{0x7644, 0x00},
	{0x7645, 0x02},
	{0x7646, 0x05},
	{0x7647, 0x33},
	{0x7648, 0x06},
	{0x7649, 0x20},
	{0x764a, 0x0f},
	{0x764b, 0x00},
	{0x764c, 0x06},
	{0x764d, 0x56},
	{0x764e, 0x00},
	{0x764f, 0x02},
	{0x7650, 0x06},
	{0x7651, 0x16},
	{0x7652, 0x05},
	{0x7653, 0x33},
	{0x7654, 0x06},
	{0x7655, 0x10},
	{0x7656, 0x0f},
	{0x7657, 0x00},
	{0x7658, 0x06},
	{0x7659, 0x10},
	{0x765a, 0x0f},
	{0x765b, 0x00},
	{0x765c, 0x06},
	{0x765d, 0x20},
	{0x765e, 0x0f},
	{0x765f, 0x00},
	{0x7660, 0x00},
	{0x7661, 0x00},
	{0x7662, 0x00},
	{0x7663, 0x02},
	{0x7664, 0x04},
	{0x7665, 0xe5},
	{0x7666, 0x04},
	{0x7667, 0xe4},
	{0x7668, 0x0f},
	{0x7669, 0x00},
	{0x766a, 0x00},
	{0x766b, 0x00},
	{0x766c, 0x00},
	{0x766d, 0x01},
	{0x766e, 0x04},
	{0x766f, 0xe5},
	{0x7670, 0x04},
	{0x7671, 0xe4},
	{0x7672, 0x0f},
	{0x7673, 0x00},
	{0x7674, 0x00},
	{0x7675, 0x02},
	{0x7676, 0x04},
	{0x7677, 0xe4},
	{0x7678, 0x00},
	{0x7679, 0x02},
	{0x767a, 0x04},
	{0x767b, 0xc4},
	{0x767c, 0x00},
	{0x767d, 0x02},
	{0x767e, 0x04},
	{0x767f, 0xc4},
	{0x7680, 0x05},
	{0x7681, 0x83},
	{0x7682, 0x0f},
	{0x7683, 0x00},
	{0x7684, 0x00},
	{0x7685, 0x02},
	{0x7686, 0x04},
	{0x7687, 0xe4},
	{0x7688, 0x00},
	{0x7689, 0x02},
	{0x768a, 0x04},
	{0x768b, 0xc4},
	{0x768c, 0x00},
	{0x768d, 0x02},
	{0x768e, 0x04},
	{0x768f, 0xc4},
	{0x7690, 0x05},
	{0x7691, 0x83},
	{0x7692, 0x03},
	{0x7693, 0x0b},
	{0x7694, 0x05},
	{0x7695, 0x83},
	{0x7696, 0x00},
	{0x7697, 0x07},
	{0x7698, 0x05},
	{0x7699, 0x03},
	{0x769a, 0x00},
	{0x769b, 0x05},
	{0x769c, 0x05},
	{0x769d, 0x32},
	{0x769e, 0x05},
	{0x769f, 0x30},
	{0x76a0, 0x00},
	{0x76a1, 0x02},
	{0x76a2, 0x05},
	{0x76a3, 0x78},
	{0x76a4, 0x00},
	{0x76a5, 0x01},
	{0x76a6, 0x05},
	{0x76a7, 0x7c},
	{0x76a8, 0x03},
	{0x76a9, 0x9a},
	{0x76aa, 0x05},
	{0x76ab, 0x83},
	{0x76ac, 0x00},
	{0x76ad, 0x04},
	{0x76ae, 0x05},
	{0x76af, 0x03},
	{0x76b0, 0x00},
	{0x76b1, 0x03},
	{0x76b2, 0x05},
	{0x76b3, 0x32},
	{0x76b4, 0x05},
	{0x76b5, 0x30},
	{0x76b6, 0x00},
	{0x76b7, 0x02},
	{0x76b8, 0x05},
	{0x76b9, 0x78},
	{0x76ba, 0x00},
	{0x76bb, 0x01},
	{0x76bc, 0x05},
	{0x76bd, 0x7c},
	{0x76be, 0x03},
	{0x76bf, 0x99},
	{0x76c0, 0x05},
	{0x76c1, 0x83},
	{0x76c2, 0x00},
	{0x76c3, 0x03},
	{0x76c4, 0x05},
	{0x76c5, 0x03},
	{0x76c6, 0x00},
	{0x76c7, 0x01},
	{0x76c8, 0x05},
	{0x76c9, 0x32},
	{0x76ca, 0x05},
	{0x76cb, 0x30},
	{0x76cc, 0x00},
	{0x76cd, 0x02},
	{0x76ce, 0x05},
	{0x76cf, 0x78},
	{0x76d0, 0x00},
	{0x76d1, 0x01},
	{0x76d2, 0x05},
	{0x76d3, 0x7c},
	{0x76d4, 0x03},
	{0x76d5, 0x98},
	{0x76d6, 0x05},
	{0x76d7, 0x83},
	{0x76d8, 0x00},
	{0x76d9, 0x00},
	{0x76da, 0x05},
	{0x76db, 0x03},
	{0x76dc, 0x00},
	{0x76dd, 0x01},
	{0x76de, 0x05},
	{0x76df, 0x32},
	{0x76e0, 0x05},
	{0x76e1, 0x30},
	{0x76e2, 0x00},
	{0x76e3, 0x02},
	{0x76e4, 0x05},
	{0x76e5, 0x78},
	{0x76e6, 0x00},
	{0x76e7, 0x01},
	{0x76e8, 0x05},
	{0x76e9, 0x7c},
	{0x76ea, 0x03},
	{0x76eb, 0x97},
	{0x76ec, 0x05},
	{0x76ed, 0x83},
	{0x76ee, 0x00},
	{0x76ef, 0x00},
	{0x76f0, 0x05},
	{0x76f1, 0x03},
	{0x76f2, 0x05},
	{0x76f3, 0x32},
	{0x76f4, 0x05},
	{0x76f5, 0x30},
	{0x76f6, 0x00},
	{0x76f7, 0x02},
	{0x76f8, 0x05},
	{0x76f9, 0x78},
	{0x76fa, 0x00},
	{0x76fb, 0x01},
	{0x76fc, 0x05},
	{0x76fd, 0x7c},
	{0x76fe, 0x03},
	{0x76ff, 0x96},
	{0x7700, 0x05},
	{0x7701, 0x83},
	{0x7702, 0x05},
	{0x7703, 0x03},
	{0x7704, 0x05},
	{0x7705, 0x32},
	{0x7706, 0x05},
	{0x7707, 0x30},
	{0x7708, 0x00},
	{0x7709, 0x02},
	{0x770a, 0x05},
	{0x770b, 0x78},
	{0x770c, 0x00},
	{0x770d, 0x01},
	{0x770e, 0x05},
	{0x770f, 0x7c},
	{0x7710, 0x03},
	{0x7711, 0x95},
	{0x7712, 0x05},
	{0x7713, 0x83},
	{0x7714, 0x05},
	{0x7715, 0x03},
	{0x7716, 0x05},
	{0x7717, 0x32},
	{0x7718, 0x05},
	{0x7719, 0x30},
	{0x771a, 0x00},
	{0x771b, 0x02},
	{0x771c, 0x05},
	{0x771d, 0x78},
	{0x771e, 0x00},
	{0x771f, 0x01},
	{0x7720, 0x05},
	{0x7721, 0x7c},
	{0x7722, 0x03},
	{0x7723, 0x94},
	{0x7724, 0x05},
	{0x7725, 0x83},
	{0x7726, 0x00},
	{0x7727, 0x01},
	{0x7728, 0x05},
	{0x7729, 0x03},
	{0x772a, 0x00},
	{0x772b, 0x01},
	{0x772c, 0x05},
	{0x772d, 0x32},
	{0x772e, 0x05},
	{0x772f, 0x30},
	{0x7730, 0x00},
	{0x7731, 0x02},
	{0x7732, 0x05},
	{0x7733, 0x78},
	{0x7734, 0x00},
	{0x7735, 0x01},
	{0x7736, 0x05},
	{0x7737, 0x7c},
	{0x7738, 0x03},
	{0x7739, 0x93},
	{0x773a, 0x05},
	{0x773b, 0x83},
	{0x773c, 0x00},
	{0x773d, 0x00},
	{0x773e, 0x05},
	{0x773f, 0x03},
	{0x7740, 0x00},
	{0x7741, 0x00},
	{0x7742, 0x05},
	{0x7743, 0x32},
	{0x7744, 0x05},
	{0x7745, 0x30},
	{0x7746, 0x00},
	{0x7747, 0x02},
	{0x7748, 0x05},
	{0x7749, 0x78},
	{0x774a, 0x00},
	{0x774b, 0x01},
	{0x774c, 0x05},
	{0x774d, 0x7c},
	{0x774e, 0x03},
	{0x774f, 0x92},
	{0x7750, 0x05},
	{0x7751, 0x83},
	{0x7752, 0x05},
	{0x7753, 0x03},
	{0x7754, 0x00},
	{0x7755, 0x00},
	{0x7756, 0x05},
	{0x7757, 0x32},
	{0x7758, 0x05},
	{0x7759, 0x30},
	{0x775a, 0x00},
	{0x775b, 0x02},
	{0x775c, 0x05},
	{0x775d, 0x78},
	{0x775e, 0x00},
	{0x775f, 0x01},
	{0x7760, 0x05},
	{0x7761, 0x7c},
	{0x7762, 0x03},
	{0x7763, 0x91},
	{0x7764, 0x05},
	{0x7765, 0x83},
	{0x7766, 0x05},
	{0x7767, 0x03},
	{0x7768, 0x05},
	{0x7769, 0x32},
	{0x776a, 0x05},
	{0x776b, 0x30},
	{0x776c, 0x00},
	{0x776d, 0x02},
	{0x776e, 0x05},
	{0x776f, 0x78},
	{0x7770, 0x00},
	{0x7771, 0x01},
	{0x7772, 0x05},
	{0x7773, 0x7c},
	{0x7774, 0x03},
	{0x7775, 0x90},
	{0x7776, 0x05},
	{0x7777, 0x83},
	{0x7778, 0x05},
	{0x7779, 0x03},
	{0x777a, 0x05},
	{0x777b, 0x32},
	{0x777c, 0x05},
	{0x777d, 0x30},
	{0x777e, 0x00},
	{0x777f, 0x02},
	{0x7780, 0x05},
	{0x7781, 0x78},
	{0x7782, 0x00},
	{0x7783, 0x01},
	{0x7784, 0x05},
	{0x7785, 0x7c},
	{0x7786, 0x02},
	{0x7787, 0x90},
	{0x7788, 0x05},
	{0x7789, 0x03},
	{0x778a, 0x07},
	{0x778b, 0x00},
	{0x778c, 0x0f},
	{0x778d, 0x00},
	{0x778e, 0x08},
	{0x778f, 0x30},
	{0x7790, 0x08},
	{0x7791, 0xee},
	{0x7792, 0x0f},
	{0x7793, 0x00},
	{0x7794, 0x05},
	{0x7795, 0x33},
	{0x7796, 0x04},
	{0x7797, 0xe5},
	{0x7798, 0x06},
	{0x7799, 0x52},
	{0x779a, 0x04},
	{0x779b, 0xe4},
	{0x779c, 0x00},
	{0x779d, 0x00},
	{0x779e, 0x06},
	{0x779f, 0x5e},
	{0x77a0, 0x00},
	{0x77a1, 0x0f},
	{0x77a2, 0x06},
	{0x77a3, 0x1e},
	{0x77a4, 0x00},
	{0x77a5, 0x02},
	{0x77a6, 0x06},
	{0x77a7, 0xa2},
	{0x77a8, 0x00},
	{0x77a9, 0x01},
	{0x77aa, 0x06},
	{0x77ab, 0xae},
	{0x77ac, 0x00},
	{0x77ad, 0x03},
	{0x77ae, 0x05},
	{0x77af, 0x30},
	{0x77b0, 0x09},
	{0x77b1, 0x19},
	{0x77b2, 0x0f},
	{0x77b3, 0x00},
	{0x77b4, 0x05},
	{0x77b5, 0x33},
	{0x77b6, 0x04},
	{0x77b7, 0xe5},
	{0x77b8, 0x06},
	{0x77b9, 0x52},
	{0x77ba, 0x04},
	{0x77bb, 0xe4},
	{0x77bc, 0x00},
	{0x77bd, 0x00},
	{0x77be, 0x06},
	{0x77bf, 0x5e},
	{0x77c0, 0x00},
	{0x77c1, 0x0f},
	{0x77c2, 0x06},
	{0x77c3, 0x1e},
	{0x77c4, 0x00},
	{0x77c5, 0x02},
	{0x77c6, 0x06},
	{0x77c7, 0xa2},
	{0x77c8, 0x00},
	{0x77c9, 0x01},
	{0x77ca, 0x06},
	{0x77cb, 0xae},
	{0x77cc, 0x00},
	{0x77cd, 0x03},
	{0x77ce, 0x05},
	{0x77cf, 0x30},
	{0x77d0, 0x0f},
	{0x77d1, 0x00},
	{0x77d2, 0x00},
	{0x77d3, 0x00},
	{0x77d4, 0x00},
	{0x77d5, 0x02},
	{0x77d6, 0x04},
	{0x77d7, 0xe5},
	{0x77d8, 0x04},
	{0x77d9, 0xe4},
	{0x77da, 0x05},
	{0x77db, 0x33},
	{0x77dc, 0x07},
	{0x77dd, 0x10},
	{0x77de, 0x00},
	{0x77df, 0x00},
	{0x77e0, 0x01},
	{0x77e1, 0xbb},
	{0x77e2, 0x00},
	{0x77e3, 0x00},
	{0x77e4, 0x01},
	{0x77e5, 0xaa},
	{0x77e6, 0x00},
	{0x77e7, 0x00},
	{0x77e8, 0x01},
	{0x77e9, 0x99},
	{0x77ea, 0x00},
	{0x77eb, 0x00},
	{0x77ec, 0x01},
	{0x77ed, 0x88},
	{0x77ee, 0x00},
	{0x77ef, 0x00},
	{0x77f0, 0x01},
	{0x77f1, 0x77},
	{0x77f2, 0x00},
	{0x77f3, 0x00},
	{0x77f4, 0x01},
	{0x77f5, 0x66},
	{0x77f6, 0x00},
	{0x77f7, 0x00},
	{0x77f8, 0x01},
	{0x77f9, 0x55},
	{0x77fa, 0x00},
	{0x77fb, 0x00},
	{0x77fc, 0x01},
	{0x77fd, 0x44},
	{0x77fe, 0x00},
	{0x77ff, 0x00},
	{0x7800, 0x01},
	{0x7801, 0x33},
	{0x7802, 0x00},
	{0x7803, 0x00},
	{0x7804, 0x01},
	{0x7805, 0x22},
	{0x7806, 0x00},
	{0x7807, 0x00},
	{0x7808, 0x01},
	{0x7809, 0x11},
	{0x780a, 0x00},
	{0x780b, 0x00},
	{0x780c, 0x01},
	{0x780d, 0x00},
	{0x780e, 0x01},
	{0x780f, 0xff},
	{0x7810, 0x07},
	{0x7811, 0x00},
	{0x7812, 0x02},
	{0x7813, 0xa0},
	{0x7814, 0x0f},
	{0x7815, 0x00},
	{0x7816, 0x08},
	{0x7817, 0x35},
	{0x7818, 0x06},
	{0x7819, 0x52},
	{0x781a, 0x04},
	{0x781b, 0xe4},
	{0x781c, 0x00},
	{0x781d, 0x00},
	{0x781e, 0x06},
	{0x781f, 0x5e},
	{0x7820, 0x05},
	{0x7821, 0x33},
	{0x7822, 0x09},
	{0x7823, 0x19},
	{0x7824, 0x06},
	{0x7825, 0x1e},
	{0x7826, 0x05},
	{0x7827, 0x33},
	{0x7828, 0x00},
	{0x7829, 0x01},
	{0x782a, 0x06},
	{0x782b, 0x24},
	{0x782c, 0x06},
	{0x782d, 0x20},
	{0x782e, 0x0f},
	{0x782f, 0x00},
	{0x7830, 0x08},
	{0x7831, 0x35},
	{0x7832, 0x07},
	{0x7833, 0x10},
	{0x7834, 0x00},
	{0x7835, 0x00},
	{0x7836, 0x01},
	{0x7837, 0xbb},
	{0x7838, 0x00},
	{0x7839, 0x00},
	{0x783a, 0x01},
	{0x783b, 0xaa},
	{0x783c, 0x00},
	{0x783d, 0x00},
	{0x783e, 0x01},
	{0x783f, 0x99},
	{0x7840, 0x00},
	{0x7841, 0x00},
	{0x7842, 0x01},
	{0x7843, 0x88},
	{0x7844, 0x00},
	{0x7845, 0x00},
	{0x7846, 0x01},
	{0x7847, 0x77},
	{0x7848, 0x00},
	{0x7849, 0x00},
	{0x784a, 0x01},
	{0x784b, 0x66},
	{0x784c, 0x00},
	{0x784d, 0x00},
	{0x784e, 0x01},
	{0x784f, 0x55},
	{0x7850, 0x00},
	{0x7851, 0x00},
	{0x7852, 0x01},
	{0x7853, 0x44},
	{0x7854, 0x00},
	{0x7855, 0x00},
	{0x7856, 0x01},
	{0x7857, 0x33},
	{0x7858, 0x00},
	{0x7859, 0x00},
	{0x785a, 0x01},
	{0x785b, 0x22},
	{0x785c, 0x00},
	{0x785d, 0x00},
	{0x785e, 0x01},
	{0x785f, 0x11},
	{0x7860, 0x00},
	{0x7861, 0x00},
	{0x7862, 0x01},
	{0x7863, 0x00},
	{0x7864, 0x07},
	{0x7865, 0x00},
	{0x7866, 0x01},
	{0x7867, 0xff},
	{0x7868, 0x02},
	{0x7869, 0xa0},
	{0x786a, 0x0f},
	{0x786b, 0x00},
	{0x786c, 0x08},
	{0x786d, 0x3a},
	{0x786e, 0x08},
	{0x786f, 0x6a},
	{0x7870, 0x0f},
	{0x7871, 0x00},
	{0x7872, 0x04},
	{0x7873, 0xc0},
	{0x7874, 0x09},
	{0x7875, 0x19},
	{0x7876, 0x04},
	{0x7877, 0x99},
	{0x7878, 0x07},
	{0x7879, 0x14},
	{0x787a, 0x00},
	{0x787b, 0x01},
	{0x787c, 0x04},
	{0x787d, 0xa4},
	{0x787e, 0x00},
	{0x787f, 0x0f},
	{0x7880, 0x00},
	{0x7881, 0x0f},
	{0x7882, 0x04},
	{0x7883, 0xa6},
	{0x7884, 0x00},
	{0x7885, 0x00},
	{0x7886, 0x04},
	{0x7887, 0xa0},
	{0x7888, 0x04},
	{0x7889, 0x80},
	{0x788a, 0x04},
	{0x788b, 0x00},
	{0x788c, 0x05},
	{0x788d, 0x03},
	{0x788e, 0x06},
	{0x788f, 0x00},
	{0x7890, 0x0f},
	{0x7891, 0x00},
	{0x7892, 0x0f},
	{0x7893, 0x00},
	{0x7894, 0x0f},
	{0x7895, 0x00},
	{0x30a0, 0x00},
	{0x30a1, 0x00},
	{0x30a2, 0x00},
	{0x30a3, 0x00},
	{0x30a4, 0x07},
	{0x30a5, 0x8f},
	{0x30a6, 0x04},
	{0x30a7, 0x47},
	{0x30a8, 0x00},
	{0x30a9, 0x04},
	{0x30aa, 0x00},
	{0x30ab, 0x04},
	{0x30ac, 0x07},
	{0x30ad, 0x88},
	{0x30ae, 0x04},
	{0x30af, 0x40},
	{0x30a0, 0x00},
	{0x30a1, 0x04},
	{0x30a2, 0x00},
	{0x30a3, 0x04},
	{0x30a4, 0x07},
	{0x30a5, 0x8B},
	{0x30a6, 0x04},
	{0x30a7, 0x43},
	{0x30a8, 0x00},
	{0x30a9, 0x04},
	{0x30aa, 0x00},
	{0x30ab, 0x04},
	{0x30ac, 0x07},
	{0x30ad, 0x80},
	{0x30ae, 0x04},
	{0x30af, 0x38},
	{0x3195, 0x26},
	{0x3196, 0x00},
	{0x3197, 0x0A},
	{0x3191, 0x99},
	{0x31a0, 0x00},
	{0x31e3, 0x01},
	{0x31e4, 0x08},
	{0x31fe, 0x03},
	{0x31a3, 0x08},
	{0x30b0, 0x0d},
	{0x30b1, 0xde},
	{0x30b2, 0x04},
	{0x30b3, 0x66},
	{0x3196, 0x00},
	{0x3197, 0x0a},
	{0x3195, 0x29},
	{0x315a, 0x02},
	{0x315b, 0x00},
	{0x30bb, 0x40},
	{0x3250, 0xf7},
	{REG_NULL, 0x00}
};

/* two lanes,raw 12bit hdr */
static const struct regval ov2718_hdr12bit_init_tab_1920_1080[] = {
	{0x3013, 0x01},
	{REG_DELAY, 0x10},
	{0x0100, 0x43},
	{0x0101, 0x01},
	{0x1000, 0x0f},
	{0x0102, 0x81},
	{0x0001, 0xad},
	{0x0002, 0xad},
	{0x1002, 0x10},
	{0x1007, 0x07},
	{0x1002, 0x18},
	{0x1008, 0x11},
	{0x3000, 0x02},
	{0x3001, 0x28},
	{0x3002, 0x03},
	{0x3003, 0x01},
	{0x3004, 0x02},
	{0x3005, 0x26},
	{0x3006, 0x00},
	{0x3007, 0x07},
	{0x3008, 0x01},
	{0x3009, 0x00},
	{0x300c, 0x6c},
	{0x300e, 0x80},
	{0x300f, 0x00},
	{0x3012, 0x00},
	{0x3013, 0x00},
	{0x3014, 0xc4},
	{0x3015, 0x00},
	{0x3017, 0x00},
	{0x3018, 0x00},
	{0x3019, 0x00},
	{0x301a, 0x00},
	{0x301b, 0x01},
	{0x301e, 0x17},
	{0x301f, 0xe1},
	{0x3030, 0x02},
	{0x3031, 0x72},
	{0x3032, 0xf0},
	{0x3033, 0x30},
	{0x3034, 0x3f},
	{0x3035, 0x5f},
	{0x3036, 0x02},
	{0x3037, 0x9f},
	{0x3038, 0x04},
	{0x3039, 0xb7},
	{0x303a, 0x04},
	{0x303b, 0x07},
	{0x303c, 0xf0},
	{0x303d, 0x00},
	{0x303e, 0x0b},
	{0x303f, 0xe3},
	{0x3040, 0xf3},
	{0x3041, 0x29},
	{0x3042, 0xf6},
	{0x3043, 0x65},
	{0x3044, 0x06},
	{0x3045, 0x0f},
	{0x3046, 0x59},
	{0x3047, 0x07},
	{0x3048, 0x82},
	{0x3049, 0xcf},
	{0x304a, 0x12},
	{0x304b, 0x40},
	{0x304c, 0x33},
	{0x304d, 0xa4},
	{0x304e, 0x0b},
	{0x304f, 0x3d},
	{0x3050, 0x10},
	{0x3060, 0x00},
	{0x3061, 0x64},
	{0x3062, 0x00},
	{0x3063, 0xe4},
	{0x3066, 0x80},
	{0x3080, 0x00},
	{0x3081, 0x00},
	{0x3082, 0x01},
	{0x3083, 0xe3},
	{0x3084, 0x06},
	{0x3085, 0x00},
	{0x3086, 0x10},
	{0x3087, 0x10},
	{0x3089, 0x00},
	{0x308a, 0x01},
	{0x3093, 0x00},
	{0x30a0, 0x00},
	{0x30a1, 0x00},
	{0x30a2, 0x00},
	{0x30a3, 0x00},
	{0x30a4, 0x07},
	{0x30a5, 0x8f},
	{0x30a6, 0x04},
	{0x30a7, 0x47},
	{0x30a8, 0x00},
	{0x30a9, 0x00},
	{0x30aa, 0x00},
	{0x30ab, 0x00},
	{0x30ac, 0x07},
	{0x30ad, 0x90},
	{0x30ae, 0x04},
	{0x30af, 0x48},
	{0x30b0, 0x08},
	{0x30b1, 0xae},
	{0x30b2, 0x04},
	{0x30b3, 0x65},
	{0x30b4, 0x00},
	{0x30b5, 0x00},
	{0x30b6, 0x00},
	{0x30b7, 0x10},
	{0x30b8, 0x00},
	{0x30b9, 0x02},
	{0x30ba, 0x10},
	{0x30bb, 0x00},
	{0x30bc, 0x00},
	{0x30bd, 0x03},
	{0x30be, 0x5c},
	{0x30bf, 0x00},
	{0x30c0, 0x01},
	{0x30c1, 0x00},
	{0x30c2, 0x20},
	{0x30c3, 0x00},
	{0x30c4, 0x4a},
	{0x30c5, 0x00},
	{0x30c7, 0x00},
	{0x30c8, 0x00},
	{0x30d1, 0x00},
	{0x30d2, 0x00},
	{0x30d3, 0x80},
	{0x30d4, 0x00},
	{0x30d9, 0x09},
	{0x30da, 0x64},
	{0x30dd, 0x00},
	{0x30de, 0x16},
	{0x30df, 0x00},
	{0x30e0, 0x17},
	{0x30e1, 0x00},
	{0x30e2, 0x18},
	{0x30e3, 0x10},
	{0x30e4, 0x04},
	{0x30e5, 0x00},
	{0x30e6, 0x00},
	{0x30e7, 0x00},
	{0x30e8, 0x00},
	{0x30e9, 0x00},
	{0x30ea, 0x00},
	{0x30eb, 0x00},
	{0x30ec, 0x00},
	{0x30ed, 0x00},
	{0x3101, 0x00},
	{0x3102, 0x00},
	{0x3103, 0x00},
	{0x3104, 0x00},
	{0x3105, 0x8c},
	{0x3106, 0x87},
	{0x3107, 0xc0},
	{0x3108, 0x9d},
	{0x3109, 0x8d},
	{0x310a, 0x8d},
	{0x310b, 0x6a},
	{0x310c, 0x3a},
	{0x310d, 0x5a},
	{0x310e, 0x00},
	{0x3120, 0x00},
	{0x3121, 0x00},
	{0x3122, 0x00},
	{0x3123, 0x00},
	{0x3124, 0x00},
	{0x3125, 0x70},
	{0x3126, 0x1f},
	{0x3127, 0x0f},
	{0x3128, 0x00},
	{0x3129, 0x3a},
	{0x312a, 0x02},
	{0x312b, 0x0f},
	{0x312c, 0x00},
	{0x312d, 0x0f},
	{0x312e, 0x1d},
	{0x312f, 0x00},
	{0x3130, 0x00},
	{0x3131, 0x00},
	{0x3132, 0x00},
	{0x3140, 0x0a},
	{0x3141, 0x03},
	{0x3142, 0x00},
	{0x3143, 0x00},
	{0x3144, 0x00},
	{0x3145, 0x00},
	{0x3146, 0x00},
	{0x3147, 0x00},
	{0x3148, 0x00},
	{0x3149, 0x00},
	{0x314a, 0x00},
	{0x314b, 0x00},
	{0x314c, 0x00},
	{0x314d, 0x00},
	{0x314e, 0x1c},
	{0x314f, 0xff},
	{0x3150, 0xff},
	{0x3151, 0xff},
	{0x3152, 0x10},
	{0x3153, 0x10},
	{0x3154, 0x10},
	{0x3155, 0x00},
	{0x3156, 0x03},
	{0x3157, 0x00},
	{0x3158, 0x0f},
	{0x3159, 0xff},
	{0x315a, 0x01},
	{0x315b, 0x00},
	{0x315c, 0x01},
	{0x315d, 0x00},
	{0x315e, 0x01},
	{0x315f, 0x00},
	{0x3160, 0x00},
	{0x3161, 0x40},
	{0x3162, 0x00},
	{0x3163, 0x40},
	{0x3164, 0x00},
	{0x3165, 0x40},
	{0x3190, 0x01},
	{0x3191, 0x99},
	{0x3193, 0x08},
	{0x3194, 0x13},
	{0x3195, 0x33},
	{0x3196, 0x00},
	{0x3197, 0x10},
	{0x3198, 0x00},
	{0x3199, 0x3f},
	{0x319a, 0x40},
	{0x319b, 0x7f},
	{0x319c, 0x80},
	{0x319d, 0xbf},
	{0x319e, 0xc0},
	{0x319f, 0xff},
	{0x31a0, 0x24},
	{0x31a1, 0x55},
	{0x31a2, 0x00},
	{0x31a3, 0x08},
	{0x31a6, 0x00},
	{0x31a7, 0x00},
	{0x31b0, 0x00},
	{0x31b1, 0x00},
	{0x31b2, 0x02},
	{0x31b3, 0x00},
	{0x31b4, 0x00},
	{0x31b5, 0x01},
	{0x31b6, 0x00},
	{0x31b7, 0x00},
	{0x31b8, 0x00},
	{0x31b9, 0x00},
	{0x31ba, 0x00},
	{0x31d0, 0x3c},
	{0x31d1, 0x34},
	{0x31d2, 0x3c},
	{0x31d3, 0x00},
	{0x31d4, 0x2d},
	{0x31d5, 0x00},
	{0x31d6, 0x01},
	{0x31d7, 0x06},
	{0x31d8, 0x00},
	{0x31d9, 0x64},
	{0x31da, 0x00},
	{0x31db, 0x30},
	{0x31dc, 0x04},
	{0x31dd, 0x69},
	{0x31de, 0x0a},
	{0x31df, 0x3c},
	{0x31e0, 0x04},
	{0x31e1, 0x32},
	{0x31e2, 0x00},
	{0x31e3, 0x00},
	{0x31e4, 0x08},
	{0x31e5, 0x80},
	{0x31e6, 0x00},
	{0x31e7, 0x2c},
	{0x31e8, 0x6c},
	{0x31e9, 0xac},
	{0x31ea, 0xec},
	{0x31eb, 0x3f},
	{0x31ec, 0x0f},
	{0x31ed, 0x20},
	{0x31ee, 0x04},
	{0x31ef, 0x48},
	{0x31f0, 0x07},
	{0x31f1, 0x90},
	{0x31f2, 0x04},
	{0x31f3, 0x48},
	{0x31f4, 0x07},
	{0x31f5, 0x90},
	{0x31f6, 0x04},
	{0x31f7, 0x48},
	{0x31f8, 0x07},
	{0x31f9, 0x90},
	{0x31fa, 0x04},
	{0x31fb, 0x48},
	{0x31fd, 0xcb},
	{0x31fe, 0x03},
	{0x31ff, 0x03},
	{0x3200, 0x00},
	{0x3201, 0xff},
	{0x3202, 0x00},
	{0x3203, 0xff},
	{0x3204, 0xff},
	{0x3205, 0xff},
	{0x3206, 0xff},
	{0x3207, 0xff},
	{0x3208, 0xff},
	{0x3209, 0xff},
	{0x320a, 0xff},
	{0x320b, 0x1b},
	{0x320c, 0x1f},
	{0x320d, 0x1e},
	{0x320e, 0x30},
	{0x320f, 0x2d},
	{0x3210, 0x2c},
	{0x3211, 0x2b},
	{0x3212, 0x2a},
	{0x3213, 0x24},
	{0x3214, 0x22},
	{0x3215, 0x00},
	{0x3216, 0x04},
	{0x3217, 0x2c},
	{0x3218, 0x6c},
	{0x3219, 0xac},
	{0x321a, 0xec},
	{0x321b, 0x00},
	{0x3230, 0x3a},
	{0x3231, 0x00},
	{0x3232, 0x80},
	{0x3233, 0x00},
	{0x3234, 0x10},
	{0x3235, 0xaa},
	{0x3236, 0x55},
	{0x3237, 0x99},
	{0x3238, 0x66},
	{0x3239, 0x08},
	{0x323a, 0x88},
	{0x323b, 0x00},
	{0x323c, 0x00},
	{0x323d, 0x03},
	{0x3250, 0x33},
	{0x3251, 0x00},
	{0x3252, 0x20},
	{0x3253, 0x00},
	{0x3254, 0x11},
	{0x3255, 0x01},
	{0x3256, 0x00},
	{0x3257, 0x00},
	{0x3258, 0x00},
	{0x3270, 0x01},
	{0x3271, 0x60},
	{0x3272, 0xc0},
	{0x3273, 0x00},
	{0x3274, 0x80},
	{0x3275, 0x40},
	{0x3276, 0x02},
	{0x3277, 0x08},
	{0x3278, 0x10},
	{0x3279, 0x04},
	{0x327a, 0x00},
	{0x327b, 0x03},
	{0x327c, 0x10},
	{0x327d, 0x60},
	{0x327e, 0xc0},
	{0x327f, 0x06},
	{0x3288, 0x10},
	{0x3289, 0x00},
	{0x328a, 0x08},
	{0x328b, 0x00},
	{0x328c, 0x04},
	{0x328d, 0x00},
	{0x328e, 0x02},
	{0x328f, 0x00},
	{0x3290, 0x20},
	{0x3291, 0x00},
	{0x3292, 0x10},
	{0x3293, 0x00},
	{0x3294, 0x08},
	{0x3295, 0x00},
	{0x3296, 0x04},
	{0x3297, 0x00},
	{0x3298, 0x40},
	{0x3299, 0x00},
	{0x329a, 0x20},
	{0x329b, 0x00},
	{0x329c, 0x10},
	{0x329d, 0x00},
	{0x329e, 0x08},
	{0x329f, 0x00},
	{0x32a0, 0x7f},
	{0x32a1, 0xff},
	{0x32a2, 0x40},
	{0x32a3, 0x00},
	{0x32a4, 0x20},
	{0x32a5, 0x00},
	{0x32a6, 0x10},
	{0x32a7, 0x00},
	{0x32a8, 0x00},
	{0x32a9, 0x00},
	{0x32aa, 0x00},
	{0x32ab, 0x00},
	{0x32ac, 0x00},
	{0x32ad, 0x00},
	{0x32ae, 0x00},
	{0x32af, 0x00},
	{0x32b0, 0x00},
	{0x32b1, 0x00},
	{0x32b2, 0x00},
	{0x32b3, 0x00},
	{0x32b4, 0x00},
	{0x32b5, 0x00},
	{0x32b6, 0x00},
	{0x32b7, 0x00},
	{0x32b8, 0x00},
	{0x32b9, 0x00},
	{0x32ba, 0x00},
	{0x32bb, 0x00},
	{0x32bc, 0x00},
	{0x32bd, 0x00},
	{0x32be, 0x00},
	{0x32bf, 0x00},
	{0x32c0, 0x00},
	{0x32c1, 0x00},
	{0x32c2, 0x00},
	{0x32c3, 0x00},
	{0x32c4, 0x00},
	{0x32c5, 0x00},
	{0x32c6, 0x00},
	{0x32c7, 0x00},
	{0x32c8, 0x87},
	{0x32c9, 0x00},
	{0x3330, 0x03},
	{0x3331, 0xc8},
	{0x3332, 0x02},
	{0x3333, 0x24},
	{0x3334, 0x00},
	{0x3335, 0x00},
	{0x3336, 0x00},
	{0x3337, 0x00},
	{0x3338, 0x03},
	{0x3339, 0xc8},
	{0x333a, 0x02},
	{0x333b, 0x24},
	{0x333c, 0x00},
	{0x333d, 0x00},
	{0x333e, 0x00},
	{0x333f, 0x00},
	{0x3340, 0x03},
	{0x3341, 0xc8},
	{0x3342, 0x02},
	{0x3343, 0x24},
	{0x3344, 0x00},
	{0x3345, 0x00},
	{0x3346, 0x00},
	{0x3347, 0x00},
	{0x3348, 0x40},
	{0x3349, 0x00},
	{0x334a, 0x00},
	{0x334b, 0x00},
	{0x334c, 0x00},
	{0x334d, 0x00},
	{0x334e, 0x80},
	{0x3360, 0x01},
	{0x3361, 0x00},
	{0x3362, 0x01},
	{0x3363, 0x00},
	{0x3364, 0x01},
	{0x3365, 0x00},
	{0x3366, 0x01},
	{0x3367, 0x00},
	{0x3368, 0x01},
	{0x3369, 0x00},
	{0x336a, 0x01},
	{0x336b, 0x00},
	{0x336c, 0x01},
	{0x336d, 0x00},
	{0x336e, 0x01},
	{0x336f, 0x00},
	{0x3370, 0x01},
	{0x3371, 0x00},
	{0x3372, 0x01},
	{0x3373, 0x00},
	{0x3374, 0x01},
	{0x3375, 0x00},
	{0x3376, 0x01},
	{0x3377, 0x00},
	{0x3378, 0x00},
	{0x3379, 0x00},
	{0x337a, 0x00},
	{0x337b, 0x00},
	{0x337c, 0x00},
	{0x337d, 0x00},
	{0x337e, 0x00},
	{0x337f, 0x00},
	{0x3380, 0x00},
	{0x3381, 0x00},
	{0x3382, 0x00},
	{0x3383, 0x00},
	{0x3384, 0x00},
	{0x3385, 0x00},
	{0x3386, 0x00},
	{0x3387, 0x00},
	{0x3388, 0x00},
	{0x3389, 0x00},
	{0x338a, 0x00},
	{0x338b, 0x00},
	{0x338c, 0x00},
	{0x338d, 0x00},
	{0x338e, 0x00},
	{0x338f, 0x00},
	{0x3390, 0x00},
	{0x3391, 0x00},
	{0x3392, 0x00},
	{0x3393, 0x00},
	{0x3394, 0x00},
	{0x3395, 0x00},
	{0x3396, 0x00},
	{0x3397, 0x00},
	{0x3398, 0x00},
	{0x3399, 0x00},
	{0x339a, 0x00},
	{0x339b, 0x00},
	{0x33b0, 0x00},
	{0x33b1, 0x50},
	{0x33b2, 0x01},
	{0x33b3, 0xff},
	{0x33b4, 0xe0},
	{0x33b5, 0x6b},
	{0x33b6, 0x00},
	{0x33b7, 0x00},
	{0x33b8, 0x00},
	{0x33b9, 0x00},
	{0x33ba, 0x00},
	{0x33bb, 0x1f},
	{0x33bc, 0x01},
	{0x33bd, 0x01},
	{0x33be, 0x01},
	{0x33bf, 0x01},
	{0x33c0, 0x00},
	{0x33c1, 0x00},
	{0x33c2, 0x00},
	{0x33c3, 0x00},
	{0x33e0, 0x14},
	{0x33e1, 0x0f},
	{0x33e2, 0x04},
	{0x33e3, 0x02},
	{0x33e4, 0x01},
	{0x33e5, 0x01},
	{0x33e6, 0x00},
	{0x33e7, 0x04},
	{0x33e8, 0x0c},
	{0x33e9, 0x00},
	{0x33ea, 0x01},
	{0x33eb, 0x02},
	{0x33ec, 0x03},
	{0x33ed, 0x02},
	{0x33ee, 0x05},
	{0x33ef, 0x0a},
	{0x33f0, 0x08},
	{0x33f1, 0x04},
	{0x33f2, 0x04},
	{0x33f3, 0x00},
	{0x33f4, 0x03},
	{0x33f5, 0x14},
	{0x33f6, 0x0f},
	{0x33f7, 0x02},
	{0x33f8, 0x01},
	{0x33f9, 0x01},
	{0x33fa, 0x01},
	{0x33fb, 0x00},
	{0x33fc, 0x04},
	{0x33fd, 0x0c},
	{0x33fe, 0x00},
	{0x33ff, 0x01},
	{0x3400, 0x02},
	{0x3401, 0x03},
	{0x3402, 0x01},
	{0x3403, 0x02},
	{0x3404, 0x08},
	{0x3405, 0x08},
	{0x3406, 0x04},
	{0x3407, 0x04},
	{0x3408, 0x00},
	{0x3409, 0x03},
	{0x340a, 0x14},
	{0x340b, 0x0f},
	{0x340c, 0x04},
	{0x340d, 0x02},
	{0x340e, 0x01},
	{0x340f, 0x01},
	{0x3410, 0x00},
	{0x3411, 0x04},
	{0x3412, 0x0c},
	{0x3413, 0x00},
	{0x3414, 0x01},
	{0x3415, 0x02},
	{0x3416, 0x03},
	{0x3417, 0x02},
	{0x3418, 0x05},
	{0x3419, 0x0a},
	{0x341a, 0x08},
	{0x341b, 0x04},
	{0x341c, 0x04},
	{0x341d, 0x00},
	{0x341e, 0x03},
	{0x3440, 0x00},
	{0x3441, 0x00},
	{0x3442, 0x00},
	{0x3443, 0x00},
	{0x3444, 0x02},
	{0x3445, 0xf0},
	{0x3446, 0x02},
	{0x3447, 0x08},
	{0x3448, 0x00},
	{0x3460, 0x40},
	{0x3461, 0x40},
	{0x3462, 0x40},
	{0x3463, 0x40},
	{0x3464, 0x03},
	{0x3465, 0x01},
	{0x3466, 0x01},
	{0x3467, 0x02},
	{0x3468, 0x30},
	{0x3469, 0x00},
	{0x346a, 0x35},
	{0x346b, 0x00},
	{0x3480, 0x40},
	{0x3481, 0x00},
	{0x3482, 0x00},
	{0x3483, 0x00},
	{0x3484, 0x0d},
	{0x3485, 0x00},
	{0x3486, 0x00},
	{0x3487, 0x00},
	{0x3488, 0x00},
	{0x3489, 0x00},
	{0x348a, 0x00},
	{0x348b, 0x04},
	{0x348c, 0x00},
	{0x348d, 0x01},
	{0x348f, 0x01},
	{0x3030, 0x0a},
	{0x3030, 0x02},
	{0x7000, 0x58},
	{0x7001, 0x7a},
	{0x7002, 0x1a},
	{0x7003, 0xc1},
	{0x7004, 0x03},
	{0x7005, 0xda},
	{0x7006, 0xbd},
	{0x7007, 0x03},
	{0x7008, 0xbd},
	{0x7009, 0x06},
	{0x700a, 0xe6},
	{0x700b, 0xec},
	{0x700c, 0xbc},
	{0x700d, 0xff},
	{0x700e, 0xbc},
	{0x700f, 0x73},
	{0x7010, 0xda},
	{0x7011, 0x72},
	{0x7012, 0x76},
	{0x7013, 0xb6},
	{0x7014, 0xee},
	{0x7015, 0xcf},
	{0x7016, 0xac},
	{0x7017, 0xd0},
	{0x7018, 0xac},
	{0x7019, 0xd1},
	{0x701a, 0x50},
	{0x701b, 0xac},
	{0x701c, 0xd2},
	{0x701d, 0xbc},
	{0x701e, 0x2e},
	{0x701f, 0xb4},
	{0x7020, 0x00},
	{0x7021, 0xdc},
	{0x7022, 0xdf},
	{0x7023, 0xb0},
	{0x7024, 0x6e},
	{0x7025, 0xbd},
	{0x7026, 0x01},
	{0x7027, 0xd7},
	{0x7028, 0xed},
	{0x7029, 0xe1},
	{0x702a, 0x36},
	{0x702b, 0x30},
	{0x702c, 0xd3},
	{0x702d, 0x2e},
	{0x702e, 0x54},
	{0x702f, 0x46},
	{0x7030, 0xbc},
	{0x7031, 0x22},
	{0x7032, 0x66},
	{0x7033, 0xbc},
	{0x7034, 0x24},
	{0x7035, 0x2c},
	{0x7036, 0x28},
	{0x7037, 0xbc},
	{0x7038, 0x3c},
	{0x7039, 0xa1},
	{0x703a, 0xac},
	{0x703b, 0xd8},
	{0x703c, 0xd6},
	{0x703d, 0xb4},
	{0x703e, 0x04},
	{0x703f, 0x46},
	{0x7040, 0xb7},
	{0x7041, 0x04},
	{0x7042, 0xbe},
	{0x7043, 0x08},
	{0x7044, 0xc3},
	{0x7045, 0xd9},
	{0x7046, 0xad},
	{0x7047, 0xc3},
	{0x7048, 0xbc},
	{0x7049, 0x19},
	{0x704a, 0xc1},
	{0x704b, 0x27},
	{0x704c, 0xe7},
	{0x704d, 0x00},
	{0x704e, 0x50},
	{0x704f, 0x20},
	{0x7050, 0xb8},
	{0x7051, 0x02},
	{0x7052, 0xbc},
	{0x7053, 0x17},
	{0x7054, 0xdb},
	{0x7055, 0xc7},
	{0x7056, 0xb8},
	{0x7057, 0x00},
	{0x7058, 0x28},
	{0x7059, 0x54},
	{0x705a, 0xb4},
	{0x705b, 0x14},
	{0x705c, 0xab},
	{0x705d, 0xbe},
	{0x705e, 0x06},
	{0x705f, 0xd8},
	{0x7060, 0xd6},
	{0x7061, 0x00},
	{0x7062, 0xb4},
	{0x7063, 0xc7},
	{0x7064, 0x07},
	{0x7065, 0xb9},
	{0x7066, 0x05},
	{0x7067, 0xee},
	{0x7068, 0xe6},
	{0x7069, 0xad},
	{0x706a, 0xb4},
	{0x706b, 0x26},
	{0x706c, 0x19},
	{0x706d, 0xc1},
	{0x706e, 0x3a},
	{0x706f, 0xc3},
	{0x7070, 0xaf},
	{0x7071, 0x00},
	{0x7072, 0xc0},
	{0x7073, 0x3c},
	{0x7074, 0xc3},
	{0x7075, 0xbe},
	{0x7076, 0xe7},
	{0x7077, 0x00},
	{0x7078, 0x15},
	{0x7079, 0xc2},
	{0x707a, 0x40},
	{0x707b, 0xc3},
	{0x707c, 0xa4},
	{0x707d, 0xc0},
	{0x707e, 0x3c},
	{0x707f, 0x00},
	{0x7080, 0xb9},
	{0x7081, 0x64},
	{0x7082, 0x29},
	{0x7083, 0x00},
	{0x7084, 0xb8},
	{0x7085, 0x12},
	{0x7086, 0xbe},
	{0x7087, 0x01},
	{0x7088, 0xd0},
	{0x7089, 0xbc},
	{0x708a, 0x01},
	{0x708b, 0xac},
	{0x708c, 0x37},
	{0x708d, 0xd2},
	{0x708e, 0xac},
	{0x708f, 0x45},
	{0x7090, 0xad},
	{0x7091, 0x28},
	{0x7092, 0x00},
	{0x7093, 0xb8},
	{0x7094, 0x00},
	{0x7095, 0xbc},
	{0x7096, 0x01},
	{0x7097, 0x36},
	{0x7098, 0xd3},
	{0x7099, 0x30},
	{0x709a, 0x04},
	{0x709b, 0xe0},
	{0x709c, 0xd8},
	{0x709d, 0xb4},
	{0x709e, 0xe9},
	{0x709f, 0x00},
	{0x70a0, 0xbe},
	{0x70a1, 0x05},
	{0x70a2, 0x62},
	{0x70a3, 0x07},
	{0x70a4, 0xb9},
	{0x70a5, 0x05},
	{0x70a6, 0xad},
	{0x70a7, 0xc3},
	{0x70a8, 0xcf},
	{0x70a9, 0x00},
	{0x70aa, 0x15},
	{0x70ab, 0xc2},
	{0x70ac, 0x59},
	{0x70ad, 0xc3},
	{0x70ae, 0xc9},
	{0x70af, 0xc0},
	{0x70b0, 0x55},
	{0x70b1, 0x00},
	{0x70b2, 0x46},
	{0x70b3, 0xa1},
	{0x70b4, 0xb9},
	{0x70b5, 0x64},
	{0x70b6, 0x29},
	{0x70b7, 0x00},
	{0x70b8, 0xb8},
	{0x70b9, 0x02},
	{0x70ba, 0xbe},
	{0x70bb, 0x02},
	{0x70bc, 0xd0},
	{0x70bd, 0xdc},
	{0x70be, 0xac},
	{0x70bf, 0xbc},
	{0x70c0, 0x01},
	{0x70c1, 0x37},
	{0x70c2, 0xac},
	{0x70c3, 0xd2},
	{0x70c4, 0x45},
	{0x70c5, 0xad},
	{0x70c6, 0x28},
	{0x70c7, 0x00},
	{0x70c8, 0xb8},
	{0x70c9, 0x00},
	{0x70ca, 0xbc},
	{0x70cb, 0x01},
	{0x70cc, 0x36},
	{0x70cd, 0x30},
	{0x70ce, 0xe0},
	{0x70cf, 0xd8},
	{0x70d0, 0xb5},
	{0x70d1, 0x0b},
	{0x70d2, 0xd6},
	{0x70d3, 0xbe},
	{0x70d4, 0x07},
	{0x70d5, 0x00},
	{0x70d6, 0x62},
	{0x70d7, 0x07},
	{0x70d8, 0xb9},
	{0x70d9, 0x05},
	{0x70da, 0xad},
	{0x70db, 0xc3},
	{0x70dc, 0xcf},
	{0x70dd, 0x46},
	{0x70de, 0xcd},
	{0x70df, 0x07},
	{0x70e0, 0xcd},
	{0x70e1, 0x00},
	{0x70e2, 0xe3},
	{0x70e3, 0x18},
	{0x70e4, 0xc2},
	{0x70e5, 0xa2},
	{0x70e6, 0xb9},
	{0x70e7, 0x64},
	{0x70e8, 0xd1},
	{0x70e9, 0xdd},
	{0x70ea, 0xac},
	{0x70eb, 0xcf},
	{0x70ec, 0xdf},
	{0x70ed, 0xb5},
	{0x70ee, 0x19},
	{0x70ef, 0x46},
	{0x70f0, 0x50},
	{0x70f1, 0xb6},
	{0x70f2, 0xee},
	{0x70f3, 0xe8},
	{0x70f4, 0xe6},
	{0x70f5, 0xbc},
	{0x70f6, 0x31},
	{0x70f7, 0xe1},
	{0x70f8, 0x36},
	{0x70f9, 0x30},
	{0x70fa, 0xd3},
	{0x70fb, 0x2e},
	{0x70fc, 0x54},
	{0x70fd, 0xbd},
	{0x70fe, 0x03},
	{0x70ff, 0xec},
	{0x7100, 0x2c},
	{0x7101, 0x50},
	{0x7102, 0x20},
	{0x7103, 0x04},
	{0x7104, 0xb8},
	{0x7105, 0x02},
	{0x7106, 0xbc},
	{0x7107, 0x18},
	{0x7108, 0xc7},
	{0x7109, 0xb8},
	{0x710a, 0x00},
	{0x710b, 0x28},
	{0x710c, 0x54},
	{0x710d, 0xbc},
	{0x710e, 0x02},
	{0x710f, 0xb4},
	{0x7110, 0xda},
	{0x7111, 0xbe},
	{0x7112, 0x04},
	{0x7113, 0xd6},
	{0x7114, 0xd8},
	{0x7115, 0xab},
	{0x7116, 0x00},
	{0x7117, 0x62},
	{0x7118, 0x07},
	{0x7119, 0xb9},
	{0x711a, 0x05},
	{0x711b, 0xad},
	{0x711c, 0xc3},
	{0x711d, 0xbc},
	{0x711e, 0xe7},
	{0x711f, 0xb9},
	{0x7120, 0x64},
	{0x7121, 0x29},
	{0x7122, 0x00},
	{0x7123, 0xb8},
	{0x7124, 0x02},
	{0x7125, 0xbe},
	{0x7126, 0x00},
	{0x7127, 0x45},
	{0x7128, 0xad},
	{0x7129, 0xe2},
	{0x712a, 0x28},
	{0x712b, 0x00},
	{0x712c, 0xb8},
	{0x712d, 0x00},
	{0x712e, 0xe0},
	{0x712f, 0xd8},
	{0x7130, 0xb4},
	{0x7131, 0xe9},
	{0x7132, 0xbe},
	{0x7133, 0x03},
	{0x7134, 0x00},
	{0x7135, 0x30},
	{0x7136, 0x62},
	{0x7137, 0x07},
	{0x7138, 0xb9},
	{0x7139, 0x05},
	{0x713a, 0xad},
	{0x713b, 0xc3},
	{0x713c, 0xcf},
	{0x713d, 0x42},
	{0x713e, 0xe4},
	{0x713f, 0xcd},
	{0x7140, 0x07},
	{0x7141, 0xcd},
	{0x7142, 0x00},
	{0x7143, 0x00},
	{0x7144, 0x17},
	{0x7145, 0xc2},
	{0x7146, 0xbb},
	{0x7147, 0xde},
	{0x7148, 0xcf},
	{0x7149, 0xdf},
	{0x714a, 0xac},
	{0x714b, 0xd1},
	{0x714c, 0x44},
	{0x714d, 0xac},
	{0x714e, 0xb9},
	{0x714f, 0x76},
	{0x7150, 0xb8},
	{0x7151, 0x08},
	{0x7152, 0xb6},
	{0x7153, 0xfe},
	{0x7154, 0xb4},
	{0x7155, 0xca},
	{0x7156, 0xd6},
	{0x7157, 0xd8},
	{0x7158, 0xab},
	{0x7159, 0x00},
	{0x715a, 0xe1},
	{0x715b, 0x36},
	{0x715c, 0x30},
	{0x715d, 0xd3},
	{0x715e, 0xbc},
	{0x715f, 0x29},
	{0x7160, 0xb4},
	{0x7161, 0x1f},
	{0x7162, 0xaa},
	{0x7163, 0xbd},
	{0x7164, 0x01},
	{0x7165, 0xb8},
	{0x7166, 0x0c},
	{0x7167, 0x45},
	{0x7168, 0xa4},
	{0x7169, 0xbd},
	{0x716a, 0x03},
	{0x716b, 0xec},
	{0x716c, 0xbc},
	{0x716d, 0x3d},
	{0x716e, 0xc3},
	{0x716f, 0xcf},
	{0x7170, 0x42},
	{0x7171, 0xb8},
	{0x7172, 0x00},
	{0x7173, 0xe4},
	{0x7174, 0xd5},
	{0x7175, 0x00},
	{0x7176, 0xb6},
	{0x7177, 0x00},
	{0x7178, 0x74},
	{0x7179, 0xbd},
	{0x717a, 0x03},
	{0x717b, 0x40},
	{0x717c, 0xb5},
	{0x717d, 0x39},
	{0x717e, 0x58},
	{0x717f, 0xdd},
	{0x7180, 0x19},
	{0x7181, 0xc1},
	{0x7182, 0xc8},
	{0x7183, 0xbd},
	{0x7184, 0x06},
	{0x7185, 0x17},
	{0x7186, 0xc1},
	{0x7187, 0xc6},
	{0x7188, 0xe8},
	{0x7189, 0x00},
	{0x718a, 0xc0},
	{0x718b, 0xc8},
	{0x718c, 0xe6},
	{0x718d, 0x95},
	{0x718e, 0x15},
	{0x718f, 0x00},
	{0x7190, 0xbc},
	{0x7191, 0x19},
	{0x7192, 0xb9},
	{0x7193, 0xf6},
	{0x7194, 0x14},
	{0x7195, 0xc1},
	{0x7196, 0xd0},
	{0x7197, 0xd1},
	{0x7198, 0xac},
	{0x7199, 0x37},
	{0x719a, 0xbc},
	{0x719b, 0x35},
	{0x719c, 0x36},
	{0x719d, 0x30},
	{0x719e, 0xe1},
	{0x719f, 0xd3},
	{0x71a0, 0x7a},
	{0x71a1, 0xb6},
	{0x71a2, 0x0c},
	{0x71a3, 0xff},
	{0x71a4, 0xb4},
	{0x71a5, 0xc7},
	{0x71a6, 0xd9},
	{0x71a7, 0x00},
	{0x71a8, 0xbd},
	{0x71a9, 0x01},
	{0x71aa, 0x56},
	{0x71ab, 0xc0},
	{0x71ac, 0xda},
	{0x71ad, 0xb4},
	{0x71ae, 0x1f},
	{0x71af, 0x56},
	{0x71b0, 0xaa},
	{0x71b1, 0xbc},
	{0x71b2, 0x08},
	{0x71b3, 0x00},
	{0x71b4, 0x57},
	{0x71b5, 0xe8},
	{0x71b6, 0xb5},
	{0x71b7, 0x36},
	{0x71b8, 0x00},
	{0x71b9, 0x54},
	{0x71ba, 0xe7},
	{0x71bb, 0xc8},
	{0x71bc, 0xb4},
	{0x71bd, 0x1f},
	{0x71be, 0x56},
	{0x71bf, 0xaa},
	{0x71c0, 0xbc},
	{0x71c1, 0x08},
	{0x71c2, 0x57},
	{0x71c3, 0x00},
	{0x71c4, 0xb5},
	{0x71c5, 0x36},
	{0x71c6, 0x00},
	{0x71c7, 0x54},
	{0x71c8, 0xc8},
	{0x71c9, 0xb5},
	{0x71ca, 0x18},
	{0x71cb, 0xd9},
	{0x71cc, 0x00},
	{0x71cd, 0xbd},
	{0x71ce, 0x01},
	{0x71cf, 0x56},
	{0x71d0, 0x08},
	{0x71d1, 0x57},
	{0x71d2, 0xe8},
	{0x71d3, 0xb4},
	{0x71d4, 0x42},
	{0x71d5, 0x00},
	{0x71d6, 0x54},
	{0x71d7, 0xe7},
	{0x71d8, 0xc8},
	{0x71d9, 0xab},
	{0x71da, 0x00},
	{0x71db, 0x66},
	{0x71dc, 0x62},
	{0x71dd, 0x06},
	{0x71de, 0x74},
	{0x71df, 0xb9},
	{0x71e0, 0x05},
	{0x71e1, 0xb7},
	{0x71e2, 0x14},
	{0x71e3, 0x0e},
	{0x71e4, 0xb7},
	{0x71e5, 0x04},
	{0x71e6, 0xc8},
	{0x7600, 0x04},
	{0x7601, 0x80},
	{0x7602, 0x07},
	{0x7603, 0x44},
	{0x7604, 0x05},
	{0x7605, 0x33},
	{0x7606, 0x0f},
	{0x7607, 0x00},
	{0x7608, 0x07},
	{0x7609, 0x40},
	{0x760a, 0x04},
	{0x760b, 0xe5},
	{0x760c, 0x06},
	{0x760d, 0x50},
	{0x760e, 0x04},
	{0x760f, 0xe4},
	{0x7610, 0x00},
	{0x7611, 0x00},
	{0x7612, 0x06},
	{0x7613, 0x5c},
	{0x7614, 0x00},
	{0x7615, 0x0f},
	{0x7616, 0x06},
	{0x7617, 0x1c},
	{0x7618, 0x00},
	{0x7619, 0x02},
	{0x761a, 0x06},
	{0x761b, 0xa2},
	{0x761c, 0x00},
	{0x761d, 0x01},
	{0x761e, 0x06},
	{0x761f, 0xae},
	{0x7620, 0x00},
	{0x7621, 0x0e},
	{0x7622, 0x05},
	{0x7623, 0x30},
	{0x7624, 0x07},
	{0x7625, 0x00},
	{0x7626, 0x0f},
	{0x7627, 0x00},
	{0x7628, 0x04},
	{0x7629, 0xe5},
	{0x762a, 0x05},
	{0x762b, 0x33},
	{0x762c, 0x06},
	{0x762d, 0x12},
	{0x762e, 0x00},
	{0x762f, 0x01},
	{0x7630, 0x06},
	{0x7631, 0x52},
	{0x7632, 0x00},
	{0x7633, 0x01},
	{0x7634, 0x06},
	{0x7635, 0x5e},
	{0x7636, 0x04},
	{0x7637, 0xe4},
	{0x7638, 0x00},
	{0x7639, 0x01},
	{0x763a, 0x05},
	{0x763b, 0x30},
	{0x763c, 0x0f},
	{0x763d, 0x00},
	{0x763e, 0x06},
	{0x763f, 0xa6},
	{0x7640, 0x00},
	{0x7641, 0x02},
	{0x7642, 0x06},
	{0x7643, 0x26},
	{0x7644, 0x00},
	{0x7645, 0x02},
	{0x7646, 0x05},
	{0x7647, 0x33},
	{0x7648, 0x06},
	{0x7649, 0x20},
	{0x764a, 0x0f},
	{0x764b, 0x00},
	{0x764c, 0x06},
	{0x764d, 0x56},
	{0x764e, 0x00},
	{0x764f, 0x02},
	{0x7650, 0x06},
	{0x7651, 0x16},
	{0x7652, 0x05},
	{0x7653, 0x33},
	{0x7654, 0x06},
	{0x7655, 0x10},
	{0x7656, 0x0f},
	{0x7657, 0x00},
	{0x7658, 0x06},
	{0x7659, 0x10},
	{0x765a, 0x0f},
	{0x765b, 0x00},
	{0x765c, 0x06},
	{0x765d, 0x20},
	{0x765e, 0x0f},
	{0x765f, 0x00},
	{0x7660, 0x00},
	{0x7661, 0x00},
	{0x7662, 0x00},
	{0x7663, 0x02},
	{0x7664, 0x04},
	{0x7665, 0xe5},
	{0x7666, 0x04},
	{0x7667, 0xe4},
	{0x7668, 0x0f},
	{0x7669, 0x00},
	{0x766a, 0x00},
	{0x766b, 0x00},
	{0x766c, 0x00},
	{0x766d, 0x01},
	{0x766e, 0x04},
	{0x766f, 0xe5},
	{0x7670, 0x04},
	{0x7671, 0xe4},
	{0x7672, 0x0f},
	{0x7673, 0x00},
	{0x7674, 0x00},
	{0x7675, 0x02},
	{0x7676, 0x04},
	{0x7677, 0xe4},
	{0x7678, 0x00},
	{0x7679, 0x02},
	{0x767a, 0x04},
	{0x767b, 0xc4},
	{0x767c, 0x00},
	{0x767d, 0x02},
	{0x767e, 0x04},
	{0x767f, 0xc4},
	{0x7680, 0x05},
	{0x7681, 0x83},
	{0x7682, 0x0f},
	{0x7683, 0x00},
	{0x7684, 0x00},
	{0x7685, 0x02},
	{0x7686, 0x04},
	{0x7687, 0xe4},
	{0x7688, 0x00},
	{0x7689, 0x02},
	{0x768a, 0x04},
	{0x768b, 0xc4},
	{0x768c, 0x00},
	{0x768d, 0x02},
	{0x768e, 0x04},
	{0x768f, 0xc4},
	{0x7690, 0x05},
	{0x7691, 0x83},
	{0x7692, 0x03},
	{0x7693, 0x0b},
	{0x7694, 0x05},
	{0x7695, 0x83},
	{0x7696, 0x00},
	{0x7697, 0x07},
	{0x7698, 0x05},
	{0x7699, 0x03},
	{0x769a, 0x00},
	{0x769b, 0x05},
	{0x769c, 0x05},
	{0x769d, 0x32},
	{0x769e, 0x05},
	{0x769f, 0x30},
	{0x76a0, 0x00},
	{0x76a1, 0x02},
	{0x76a2, 0x05},
	{0x76a3, 0x78},
	{0x76a4, 0x00},
	{0x76a5, 0x01},
	{0x76a6, 0x05},
	{0x76a7, 0x7c},
	{0x76a8, 0x03},
	{0x76a9, 0x9a},
	{0x76aa, 0x05},
	{0x76ab, 0x83},
	{0x76ac, 0x00},
	{0x76ad, 0x04},
	{0x76ae, 0x05},
	{0x76af, 0x03},
	{0x76b0, 0x00},
	{0x76b1, 0x03},
	{0x76b2, 0x05},
	{0x76b3, 0x32},
	{0x76b4, 0x05},
	{0x76b5, 0x30},
	{0x76b6, 0x00},
	{0x76b7, 0x02},
	{0x76b8, 0x05},
	{0x76b9, 0x78},
	{0x76ba, 0x00},
	{0x76bb, 0x01},
	{0x76bc, 0x05},
	{0x76bd, 0x7c},
	{0x76be, 0x03},
	{0x76bf, 0x99},
	{0x76c0, 0x05},
	{0x76c1, 0x83},
	{0x76c2, 0x00},
	{0x76c3, 0x03},
	{0x76c4, 0x05},
	{0x76c5, 0x03},
	{0x76c6, 0x00},
	{0x76c7, 0x01},
	{0x76c8, 0x05},
	{0x76c9, 0x32},
	{0x76ca, 0x05},
	{0x76cb, 0x30},
	{0x76cc, 0x00},
	{0x76cd, 0x02},
	{0x76ce, 0x05},
	{0x76cf, 0x78},
	{0x76d0, 0x00},
	{0x76d1, 0x01},
	{0x76d2, 0x05},
	{0x76d3, 0x7c},
	{0x76d4, 0x03},
	{0x76d5, 0x98},
	{0x76d6, 0x05},
	{0x76d7, 0x83},
	{0x76d8, 0x00},
	{0x76d9, 0x00},
	{0x76da, 0x05},
	{0x76db, 0x03},
	{0x76dc, 0x00},
	{0x76dd, 0x01},
	{0x76de, 0x05},
	{0x76df, 0x32},
	{0x76e0, 0x05},
	{0x76e1, 0x30},
	{0x76e2, 0x00},
	{0x76e3, 0x02},
	{0x76e4, 0x05},
	{0x76e5, 0x78},
	{0x76e6, 0x00},
	{0x76e7, 0x01},
	{0x76e8, 0x05},
	{0x76e9, 0x7c},
	{0x76ea, 0x03},
	{0x76eb, 0x97},
	{0x76ec, 0x05},
	{0x76ed, 0x83},
	{0x76ee, 0x00},
	{0x76ef, 0x00},
	{0x76f0, 0x05},
	{0x76f1, 0x03},
	{0x76f2, 0x05},
	{0x76f3, 0x32},
	{0x76f4, 0x05},
	{0x76f5, 0x30},
	{0x76f6, 0x00},
	{0x76f7, 0x02},
	{0x76f8, 0x05},
	{0x76f9, 0x78},
	{0x76fa, 0x00},
	{0x76fb, 0x01},
	{0x76fc, 0x05},
	{0x76fd, 0x7c},
	{0x76fe, 0x03},
	{0x76ff, 0x96},
	{0x7700, 0x05},
	{0x7701, 0x83},
	{0x7702, 0x05},
	{0x7703, 0x03},
	{0x7704, 0x05},
	{0x7705, 0x32},
	{0x7706, 0x05},
	{0x7707, 0x30},
	{0x7708, 0x00},
	{0x7709, 0x02},
	{0x770a, 0x05},
	{0x770b, 0x78},
	{0x770c, 0x00},
	{0x770d, 0x01},
	{0x770e, 0x05},
	{0x770f, 0x7c},
	{0x7710, 0x03},
	{0x7711, 0x95},
	{0x7712, 0x05},
	{0x7713, 0x83},
	{0x7714, 0x05},
	{0x7715, 0x03},
	{0x7716, 0x05},
	{0x7717, 0x32},
	{0x7718, 0x05},
	{0x7719, 0x30},
	{0x771a, 0x00},
	{0x771b, 0x02},
	{0x771c, 0x05},
	{0x771d, 0x78},
	{0x771e, 0x00},
	{0x771f, 0x01},
	{0x7720, 0x05},
	{0x7721, 0x7c},
	{0x7722, 0x03},
	{0x7723, 0x94},
	{0x7724, 0x05},
	{0x7725, 0x83},
	{0x7726, 0x00},
	{0x7727, 0x01},
	{0x7728, 0x05},
	{0x7729, 0x03},
	{0x772a, 0x00},
	{0x772b, 0x01},
	{0x772c, 0x05},
	{0x772d, 0x32},
	{0x772e, 0x05},
	{0x772f, 0x30},
	{0x7730, 0x00},
	{0x7731, 0x02},
	{0x7732, 0x05},
	{0x7733, 0x78},
	{0x7734, 0x00},
	{0x7735, 0x01},
	{0x7736, 0x05},
	{0x7737, 0x7c},
	{0x7738, 0x03},
	{0x7739, 0x93},
	{0x773a, 0x05},
	{0x773b, 0x83},
	{0x773c, 0x00},
	{0x773d, 0x00},
	{0x773e, 0x05},
	{0x773f, 0x03},
	{0x7740, 0x00},
	{0x7741, 0x00},
	{0x7742, 0x05},
	{0x7743, 0x32},
	{0x7744, 0x05},
	{0x7745, 0x30},
	{0x7746, 0x00},
	{0x7747, 0x02},
	{0x7748, 0x05},
	{0x7749, 0x78},
	{0x774a, 0x00},
	{0x774b, 0x01},
	{0x774c, 0x05},
	{0x774d, 0x7c},
	{0x774e, 0x03},
	{0x774f, 0x92},
	{0x7750, 0x05},
	{0x7751, 0x83},
	{0x7752, 0x05},
	{0x7753, 0x03},
	{0x7754, 0x00},
	{0x7755, 0x00},
	{0x7756, 0x05},
	{0x7757, 0x32},
	{0x7758, 0x05},
	{0x7759, 0x30},
	{0x775a, 0x00},
	{0x775b, 0x02},
	{0x775c, 0x05},
	{0x775d, 0x78},
	{0x775e, 0x00},
	{0x775f, 0x01},
	{0x7760, 0x05},
	{0x7761, 0x7c},
	{0x7762, 0x03},
	{0x7763, 0x91},
	{0x7764, 0x05},
	{0x7765, 0x83},
	{0x7766, 0x05},
	{0x7767, 0x03},
	{0x7768, 0x05},
	{0x7769, 0x32},
	{0x776a, 0x05},
	{0x776b, 0x30},
	{0x776c, 0x00},
	{0x776d, 0x02},
	{0x776e, 0x05},
	{0x776f, 0x78},
	{0x7770, 0x00},
	{0x7771, 0x01},
	{0x7772, 0x05},
	{0x7773, 0x7c},
	{0x7774, 0x03},
	{0x7775, 0x90},
	{0x7776, 0x05},
	{0x7777, 0x83},
	{0x7778, 0x05},
	{0x7779, 0x03},
	{0x777a, 0x05},
	{0x777b, 0x32},
	{0x777c, 0x05},
	{0x777d, 0x30},
	{0x777e, 0x00},
	{0x777f, 0x02},
	{0x7780, 0x05},
	{0x7781, 0x78},
	{0x7782, 0x00},
	{0x7783, 0x01},
	{0x7784, 0x05},
	{0x7785, 0x7c},
	{0x7786, 0x02},
	{0x7787, 0x90},
	{0x7788, 0x05},
	{0x7789, 0x03},
	{0x778a, 0x07},
	{0x778b, 0x00},
	{0x778c, 0x0f},
	{0x778d, 0x00},
	{0x778e, 0x08},
	{0x778f, 0x30},
	{0x7790, 0x08},
	{0x7791, 0xee},
	{0x7792, 0x0f},
	{0x7793, 0x00},
	{0x7794, 0x05},
	{0x7795, 0x33},
	{0x7796, 0x04},
	{0x7797, 0xe5},
	{0x7798, 0x06},
	{0x7799, 0x52},
	{0x779a, 0x04},
	{0x779b, 0xe4},
	{0x779c, 0x00},
	{0x779d, 0x00},
	{0x779e, 0x06},
	{0x779f, 0x5e},
	{0x77a0, 0x00},
	{0x77a1, 0x0f},
	{0x77a2, 0x06},
	{0x77a3, 0x1e},
	{0x77a4, 0x00},
	{0x77a5, 0x02},
	{0x77a6, 0x06},
	{0x77a7, 0xa2},
	{0x77a8, 0x00},
	{0x77a9, 0x01},
	{0x77aa, 0x06},
	{0x77ab, 0xae},
	{0x77ac, 0x00},
	{0x77ad, 0x03},
	{0x77ae, 0x05},
	{0x77af, 0x30},
	{0x77b0, 0x09},
	{0x77b1, 0x19},
	{0x77b2, 0x0f},
	{0x77b3, 0x00},
	{0x77b4, 0x05},
	{0x77b5, 0x33},
	{0x77b6, 0x04},
	{0x77b7, 0xe5},
	{0x77b8, 0x06},
	{0x77b9, 0x52},
	{0x77ba, 0x04},
	{0x77bb, 0xe4},
	{0x77bc, 0x00},
	{0x77bd, 0x00},
	{0x77be, 0x06},
	{0x77bf, 0x5e},
	{0x77c0, 0x00},
	{0x77c1, 0x0f},
	{0x77c2, 0x06},
	{0x77c3, 0x1e},
	{0x77c4, 0x00},
	{0x77c5, 0x02},
	{0x77c6, 0x06},
	{0x77c7, 0xa2},
	{0x77c8, 0x00},
	{0x77c9, 0x01},
	{0x77ca, 0x06},
	{0x77cb, 0xae},
	{0x77cc, 0x00},
	{0x77cd, 0x03},
	{0x77ce, 0x05},
	{0x77cf, 0x30},
	{0x77d0, 0x0f},
	{0x77d1, 0x00},
	{0x77d2, 0x00},
	{0x77d3, 0x00},
	{0x77d4, 0x00},
	{0x77d5, 0x02},
	{0x77d6, 0x04},
	{0x77d7, 0xe5},
	{0x77d8, 0x04},
	{0x77d9, 0xe4},
	{0x77da, 0x05},
	{0x77db, 0x33},
	{0x77dc, 0x07},
	{0x77dd, 0x10},
	{0x77de, 0x00},
	{0x77df, 0x00},
	{0x77e0, 0x01},
	{0x77e1, 0xbb},
	{0x77e2, 0x00},
	{0x77e3, 0x00},
	{0x77e4, 0x01},
	{0x77e5, 0xaa},
	{0x77e6, 0x00},
	{0x77e7, 0x00},
	{0x77e8, 0x01},
	{0x77e9, 0x99},
	{0x77ea, 0x00},
	{0x77eb, 0x00},
	{0x77ec, 0x01},
	{0x77ed, 0x88},
	{0x77ee, 0x00},
	{0x77ef, 0x00},
	{0x77f0, 0x01},
	{0x77f1, 0x77},
	{0x77f2, 0x00},
	{0x77f3, 0x00},
	{0x77f4, 0x01},
	{0x77f5, 0x66},
	{0x77f6, 0x00},
	{0x77f7, 0x00},
	{0x77f8, 0x01},
	{0x77f9, 0x55},
	{0x77fa, 0x00},
	{0x77fb, 0x00},
	{0x77fc, 0x01},
	{0x77fd, 0x44},
	{0x77fe, 0x00},
	{0x77ff, 0x00},
	{0x7800, 0x01},
	{0x7801, 0x33},
	{0x7802, 0x00},
	{0x7803, 0x00},
	{0x7804, 0x01},
	{0x7805, 0x22},
	{0x7806, 0x00},
	{0x7807, 0x00},
	{0x7808, 0x01},
	{0x7809, 0x11},
	{0x780a, 0x00},
	{0x780b, 0x00},
	{0x780c, 0x01},
	{0x780d, 0x00},
	{0x780e, 0x01},
	{0x780f, 0xff},
	{0x7810, 0x07},
	{0x7811, 0x00},
	{0x7812, 0x02},
	{0x7813, 0xa0},
	{0x7814, 0x0f},
	{0x7815, 0x00},
	{0x7816, 0x08},
	{0x7817, 0x35},
	{0x7818, 0x06},
	{0x7819, 0x52},
	{0x781a, 0x04},
	{0x781b, 0xe4},
	{0x781c, 0x00},
	{0x781d, 0x00},
	{0x781e, 0x06},
	{0x781f, 0x5e},
	{0x7820, 0x05},
	{0x7821, 0x33},
	{0x7822, 0x09},
	{0x7823, 0x19},
	{0x7824, 0x06},
	{0x7825, 0x1e},
	{0x7826, 0x05},
	{0x7827, 0x33},
	{0x7828, 0x00},
	{0x7829, 0x01},
	{0x782a, 0x06},
	{0x782b, 0x24},
	{0x782c, 0x06},
	{0x782d, 0x20},
	{0x782e, 0x0f},
	{0x782f, 0x00},
	{0x7830, 0x08},
	{0x7831, 0x35},
	{0x7832, 0x07},
	{0x7833, 0x10},
	{0x7834, 0x00},
	{0x7835, 0x00},
	{0x7836, 0x01},
	{0x7837, 0xbb},
	{0x7838, 0x00},
	{0x7839, 0x00},
	{0x783a, 0x01},
	{0x783b, 0xaa},
	{0x783c, 0x00},
	{0x783d, 0x00},
	{0x783e, 0x01},
	{0x783f, 0x99},
	{0x7840, 0x00},
	{0x7841, 0x00},
	{0x7842, 0x01},
	{0x7843, 0x88},
	{0x7844, 0x00},
	{0x7845, 0x00},
	{0x7846, 0x01},
	{0x7847, 0x77},
	{0x7848, 0x00},
	{0x7849, 0x00},
	{0x784a, 0x01},
	{0x784b, 0x66},
	{0x784c, 0x00},
	{0x784d, 0x00},
	{0x784e, 0x01},
	{0x784f, 0x55},
	{0x7850, 0x00},
	{0x7851, 0x00},
	{0x7852, 0x01},
	{0x7853, 0x44},
	{0x7854, 0x00},
	{0x7855, 0x00},
	{0x7856, 0x01},
	{0x7857, 0x33},
	{0x7858, 0x00},
	{0x7859, 0x00},
	{0x785a, 0x01},
	{0x785b, 0x22},
	{0x785c, 0x00},
	{0x785d, 0x00},
	{0x785e, 0x01},
	{0x785f, 0x11},
	{0x7860, 0x00},
	{0x7861, 0x00},
	{0x7862, 0x01},
	{0x7863, 0x00},
	{0x7864, 0x07},
	{0x7865, 0x00},
	{0x7866, 0x01},
	{0x7867, 0xff},
	{0x7868, 0x02},
	{0x7869, 0xa0},
	{0x786a, 0x0f},
	{0x786b, 0x00},
	{0x786c, 0x08},
	{0x786d, 0x3a},
	{0x786e, 0x08},
	{0x786f, 0x6a},
	{0x7870, 0x0f},
	{0x7871, 0x00},
	{0x7872, 0x04},
	{0x7873, 0xc0},
	{0x7874, 0x09},
	{0x7875, 0x19},
	{0x7876, 0x04},
	{0x7877, 0x99},
	{0x7878, 0x07},
	{0x7879, 0x14},
	{0x787a, 0x00},
	{0x787b, 0x01},
	{0x787c, 0x04},
	{0x787d, 0xa4},
	{0x787e, 0x00},
	{0x787f, 0x0f},
	{0x7880, 0x00},
	{0x7881, 0x0f},
	{0x7882, 0x04},
	{0x7883, 0xa6},
	{0x7884, 0x00},
	{0x7885, 0x00},
	{0x7886, 0x04},
	{0x7887, 0xa0},
	{0x7888, 0x04},
	{0x7889, 0x80},
	{0x788a, 0x04},
	{0x788b, 0x00},
	{0x788c, 0x05},
	{0x788d, 0x03},
	{0x788e, 0x06},
	{0x788f, 0x00},
	{0x7890, 0x0f},
	{0x7891, 0x00},
	{0x7892, 0x0f},
	{0x7893, 0x00},
	{0x7894, 0x0f},
	{0x7895, 0x00},
	{0x30a0, 0x00},
	{0x30a1, 0x00},
	{0x30a2, 0x00},
	{0x30a3, 0x00},
	{0x30a4, 0x07},
	{0x30a5, 0x8f},
	{0x30a6, 0x04},
	{0x30a7, 0x47},
	{0x30a8, 0x00},
	{0x30a9, 0x04},
	{0x30aa, 0x00},
	{0x30ab, 0x04},
	{0x30ac, 0x07},
	{0x30ad, 0x88},
	{0x30ae, 0x04},
	{0x30af, 0x40},
	{0x30a0, 0x00},
	{0x30a1, 0x04},
	{0x30a2, 0x00},
	{0x30a3, 0x04},
	{0x30a4, 0x07},
	{0x30a5, 0x8B},
	{0x30a6, 0x04},
	{0x30a7, 0x43},
	{0x30a8, 0x00},
	{0x30a9, 0x04},
	{0x30aa, 0x00},
	{0x30ab, 0x04},
	{0x30ac, 0x07},
	{0x30ad, 0x80},
	{0x30ae, 0x04},
	{0x30af, 0x38},
	{0x3195, 0x26},
	{0x3196, 0x00},
	{0x3197, 0x0A},
	{0x3191, 0x99},
	{0x31a0, 0x24},
	{0x31e3, 0x01},
	{0x31e4, 0x08},
	{0x31fe, 0x03},
	{0x31a3, 0x08},
	{0x30b0, 0x08},
	{0x30b1, 0x98},
	{0x30b2, 0x07},
	{0x30b3, 0x1A},
	{0x3250, 0xF7},
	{0x30b0, 0x0d},
	{0x30b1, 0xde},
	{0x30b2, 0x04},
	{0x30b3, 0x66},
	{0x3196, 0x00},
	{0x3197, 0x0a},
	{0x3195, 0x29},
	{0x30bb, 0x14},
	{0x315a, 0x02},
	{0x315b, 0x00},
	{0x315c, 0x01},
	{0x315d, 0x80},
	{0x315e, 0x01},
	{0x315f, 0x80},
	{0x3250, 0xf7},
	{REG_NULL, 0x00},
};

static const struct ov2718_mode supported_modes[] = {
	{
		.bus_fmt = MEDIA_BUS_FMT_SBGGR12_1X12,
		.width = 1920,
		.height = 1080,
		.max_fps = {
			.numerator = 10000,
			.denominator = 300000,
		},
		.exp_def = 0x0010,
		.hts_def = 0x0dde,
		.vts_def = 0x0466,
		.hdr_mode = NO_HDR,
		.reg_list = ov2718_linear12bit_init_tab_1920_1080,
		.vc[PAD0] = V4L2_MBUS_CSI2_CHANNEL_0,
	},
	{
		.bus_fmt = MEDIA_BUS_FMT_SBGGR12_1X12,
		.width = 1920,
		.height = 1080,
		.max_fps = {
			.numerator = 10000,
			.denominator = 300000,
		},
		.exp_def = 0x0010,
		.hts_def = 0x0dde,
		.vts_def = 0x0466,
		.hdr_mode = HDR_X2,
		.reg_list = ov2718_hdr12bit_init_tab_1920_1080,
		.vc[PAD0] = V4L2_MBUS_CSI2_CHANNEL_1,
		.vc[PAD1] = V4L2_MBUS_CSI2_CHANNEL_0,
		.vc[PAD2] = V4L2_MBUS_CSI2_CHANNEL_1,
		.vc[PAD3] = V4L2_MBUS_CSI2_CHANNEL_1,
	},
	{
		.bus_fmt = MEDIA_BUS_FMT_SBGGR10_1X10,
		.width = 1920,
		.height = 1080,
		.max_fps = {
			.numerator = 10000,
			.denominator = 300000,
		},
		.exp_def = 0x0010,
		.hts_def = 0x0dde,
		.vts_def = 0x0466,
		.hdr_mode = NO_HDR,
		.reg_list = ov2718_linear10bit_init_tab_1920_1080,
		.vc[PAD0] = V4L2_MBUS_CSI2_CHANNEL_0,
	},
	{
		.bus_fmt = MEDIA_BUS_FMT_SBGGR10_1X10,
		.width = 1920,
		.height = 1080,
		.max_fps = {
			.numerator = 10000,
			.denominator = 300000,
		},
		.exp_def = 0x0010,
		.hts_def = 0x0dde,
		.vts_def = 0x0466,
		.hdr_mode = HDR_X2,
		.reg_list = ov2718_hdr10bit_init_tab_1920_1080,
		.vc[PAD0] = V4L2_MBUS_CSI2_CHANNEL_1,
		.vc[PAD1] = V4L2_MBUS_CSI2_CHANNEL_0,
		.vc[PAD2] = V4L2_MBUS_CSI2_CHANNEL_1,
		.vc[PAD3] = V4L2_MBUS_CSI2_CHANNEL_1,
	}
};

static const s64 link_freq_menu_items[] = {
	OV2718_LINK_FREQ_480MHZ
};

static const char * const ov2718_test_pattern_menu[] = {
	"Disabled",
	"Vertical Color Bar Type 1",
	"Vertical Color Bar Type 2",
	"Vertical Color Bar Type 3",
	"Vertical Color Bar Type 4"
};

static int ov2718_write_reg(struct i2c_client *client, u16 reg,
			    u32 len, u32 val)
{
	int ret = -1;
	struct i2c_msg msg[1];
	unsigned char data[5];
	int retries;

	for (retries = 0; retries < 5; retries++) {
		msg->addr = client->addr;
		msg->flags = 0;
		msg->len = 3;
		msg->buf = data;

		/* high byte goes out first */
		data[0] = (u8)(reg >> 8);
		data[1] = (u8)(reg & 0xff);

		switch (len) {
		case OV2718_REG_VALUE_08BIT:
			data[2] = val;
			break;
		case OV2718_REG_VALUE_16BIT:
			data[2] = (u8)(val >> 8);
			data[3] = (u8)(val & 0xff);
			break;
		case OV2718_REG_VALUE_24BIT:
			data[2] = (u8)(val >> 16);
			data[3] = (u8)(val >> 8);
			data[3] = (u8)(val & 0xff);
			break;
		}

		ret = i2c_transfer(client->adapter, msg, 1);
		if (ret == 1)
			return 0;

		set_current_state(TASK_UNINTERRUPTIBLE);
		schedule_timeout(msecs_to_jiffies(20));
	}

	return ret;
}

static int ov2718_write_array(struct i2c_client *client,
			      const struct regval *regs)
{
	u32 i;
	int ret = 0;

	for (i = 0; ret == 0 && regs[i].addr != REG_NULL; i++) {
		if (unlikely(regs[i].addr == REG_DELAY))
			usleep_range(regs[i].val, regs[i].val * 2);
		else
			ret = ov2718_write_reg(client, regs[i].addr,
					       OV2718_REG_VALUE_08BIT,
					       regs[i].val);
	}

	return ret;
}

static int ov2718_read_reg(struct i2c_client *client, u16 reg,
			   u32 len, u32 *val)
{
	int ret = 0;
	struct i2c_msg msg[1];
	unsigned char data[4] = { 0, 0, 0, 0 };

	msg->addr = client->addr;
	msg->flags = 0;
	msg->buf = data;

	/* High byte goes out first */
	data[0] = (u8)(reg >> 8);
	data[1] = (u8)(reg & 0xff);
	msg->len = 2;
	ret = i2c_transfer(client->adapter, msg, 1);
	if (ret >= 0) {
		usleep_range(3000, 4000);
		msg->flags = I2C_M_RD;
		msg->len = len;
		i2c_transfer(client->adapter, msg, 1);
	}
	if (ret >= 0) {
		*val = 0;
		/* High byte comes first */
		if (len == 1)
			*val = data[0];
		else if (len == 2)
			*val = data[1] + (data[0] << 8);
		else
			*val = data[3] + (data[2] << 8) +
			    (data[1] << 16) + (data[0] << 24);
		return 0;
	}

	return ret;
}

static int ov2718_get_reso_dist(const struct ov2718_mode *mode,
				struct v4l2_mbus_framefmt *framefmt)
{
	return abs(mode->width - framefmt->width) +
	       abs(mode->height - framefmt->height);
}

static const struct ov2718_mode *
ov2718_find_best_fit(struct v4l2_subdev *sd,
		     struct v4l2_subdev_format *fmt)
{
	struct ov2718 *ov2718 = to_ov2718(sd);
	struct v4l2_mbus_framefmt *framefmt = &fmt->format;
	int dist;
	int cur_best_fit = 0;
	int cur_best_fit_dist = -1;
	unsigned int i;

	for (i = 0; i < ov2718->support_modes_num; i++) {
		dist = ov2718_get_reso_dist(&ov2718->support_modes[i],
					    framefmt);
		if (cur_best_fit_dist == -1 || dist < cur_best_fit_dist) {
			cur_best_fit_dist = dist;
			cur_best_fit = i;
		}
	}

	return &ov2718->support_modes[cur_best_fit];
}

static int ov2718_set_fmt(struct v4l2_subdev *sd,
			  struct v4l2_subdev_pad_config *cfg,
			  struct v4l2_subdev_format *fmt)
{
	struct ov2718 *ov2718 = to_ov2718(sd);
	const struct ov2718_mode *mode;
	s64 h_blank, vblank_def;

	mutex_lock(&ov2718->mutex);

	mode = ov2718_find_best_fit(sd, fmt);
	fmt->format.code = mode->bus_fmt;
	fmt->format.width = mode->width;
	fmt->format.height = mode->height;
	fmt->format.field = V4L2_FIELD_NONE;
	if (fmt->which == V4L2_SUBDEV_FORMAT_TRY) {
#ifdef CONFIG_VIDEO_V4L2_SUBDEV_API
		*v4l2_subdev_get_try_format(sd, cfg, fmt->pad) = fmt->format;
#else
		mutex_unlock(&ov2718->mutex);
		return -ENOTTY;
#endif
	} else {
		ov2718->cur_mode = mode;
		h_blank = mode->hts_def - mode->width;
		__v4l2_ctrl_modify_range(ov2718->hblank, h_blank,
					 h_blank, 1, h_blank);
		vblank_def = mode->vts_def - mode->height;
		__v4l2_ctrl_modify_range(ov2718->vblank, vblank_def,
					 OV2718_VTS_MAX - mode->height,
					 1, vblank_def);

		if (mode->bus_fmt == MEDIA_BUS_FMT_SBGGR10_1X10)
			__v4l2_ctrl_s_ctrl_int64(ov2718->pixel_rate, OV2718_PIXEL_RATE_10BIT);
		else
			__v4l2_ctrl_s_ctrl_int64(ov2718->pixel_rate, OV2718_PIXEL_RATE_12BIT);

	}

	mutex_unlock(&ov2718->mutex);

	return 0;
}

static int ov2718_get_fmt(struct v4l2_subdev *sd,
			  struct v4l2_subdev_pad_config *cfg,
			  struct v4l2_subdev_format *fmt)
{
	struct ov2718 *ov2718 = to_ov2718(sd);
	const struct ov2718_mode *mode = ov2718->cur_mode;

	mutex_lock(&ov2718->mutex);
	if (fmt->which == V4L2_SUBDEV_FORMAT_TRY) {
#ifdef CONFIG_VIDEO_V4L2_SUBDEV_API
		fmt->format = *v4l2_subdev_get_try_format(sd, cfg, fmt->pad);
#else
		mutex_unlock(&ov2718->mutex);
		return -ENOTTY;
#endif
	} else {
		fmt->format.width = mode->width;
		fmt->format.height = mode->height;
		fmt->format.code = mode->bus_fmt;
		fmt->format.field = V4L2_FIELD_NONE;
		if (fmt->pad < PAD_MAX && mode->hdr_mode != NO_HDR)
			fmt->reserved[0] = mode->vc[fmt->pad];
		else
			fmt->reserved[0] = mode->vc[PAD0];
	}
	mutex_unlock(&ov2718->mutex);

	return 0;
}

static int ov2718_enum_mbus_code(struct v4l2_subdev *sd,
				 struct v4l2_subdev_pad_config *cfg,
				 struct v4l2_subdev_mbus_code_enum *code)
{
	struct ov2718 *ov2718 = to_ov2718(sd);

	if (code->index != 0)
		return -EINVAL;
	code->code = ov2718->support_modes[0].bus_fmt;

	return 0;
}

static int ov2718_enum_frame_sizes(struct v4l2_subdev *sd,
				   struct v4l2_subdev_pad_config *cfg,
				   struct v4l2_subdev_frame_size_enum *fse)
{
	struct ov2718 *ov2718 = to_ov2718(sd);

	if (fse->index >= ov2718->support_modes_num)
		return -EINVAL;

	if (fse->code != ov2718->support_modes[0].bus_fmt)
		return -EINVAL;

	fse->min_width  = ov2718->support_modes[fse->index].width;
	fse->max_width  = ov2718->support_modes[fse->index].width;
	fse->max_height = ov2718->support_modes[fse->index].height;
	fse->min_height = ov2718->support_modes[fse->index].height;

	return 0;
}

static int ov2718_enable_test_pattern(struct ov2718 *ov2718, u32 pattern)
{
	u32 val;

	if (pattern)
		val = (pattern - 1) | OV2718_TEST_PATTERN_ENABLE;
	else
		val = OV2718_TEST_PATTERN_DISABLE;

	return ov2718_write_reg(ov2718->client, OV2718_REG_TEST_PATTERN,
				OV2718_REG_VALUE_08BIT, val);
}

static int ov2718_g_frame_interval(struct v4l2_subdev *sd,
				   struct v4l2_subdev_frame_interval *fi)
{
	struct ov2718 *ov2718 = to_ov2718(sd);
	const struct ov2718_mode *mode = ov2718->cur_mode;

	mutex_lock(&ov2718->mutex);
	fi->interval = mode->max_fps;
	mutex_unlock(&ov2718->mutex);

	return 0;
}

static void ov2718_get_lcg_reg(u32 gain, u32 *again_reg, u32 *dgain_reg)
{
	u32 again;
	u32 dgain;

	/* LCG,min A_gain is 2x,min D_gain is 1.09375x,min T_Gain is 3x */
	if (gain < 0x300) {
		/* T_Gain < 3, error */
		*again_reg = 0x01;
		*dgain_reg = 0x118;
	} else if (gain < 0x460) {
		/* A_gain is 2x */
		again = 0x200;
		*again_reg = 0x01;
	} else if (gain < 0x8c0) {
		/* T_Gain >= 4.375x, A_gain is 4x */
		again = 0x400;
		*again_reg = 0x02;
	} else {
		/* T_Gain >= 8.75x, A_gain is 8x */
		again = 0x800;
		*again_reg = 0x03;
	}

	if (gain >= 0x300) {
		dgain = (gain * 0x100 + 0x80) / again;
		if (dgain < 0x118)
			dgain = 0x118;

		*dgain_reg = dgain;
	}
}

static void ov2718_get_hcg_reg(u32 gain, u32 *again_reg, u32 *dgain_reg)
{
	u32 again;
	u32 dgain;

	/* HCG,T_Gain >= 22x,min A_gain is 1x,min D_gain is 2.0x */
	if (gain < 0x200) {
		/* T_Gain < 22, error */
		*again_reg = 0x00;
		*dgain_reg = 0x200;
	} else if (gain < 0x400) {
		/* T_Gain >= 22x, A_gain is 1x */
		again = 0x100;
		*again_reg = 0x00;
	} else if (gain < 0x800) {
		/* T_Gain >= 44x, A_gain is 2x */
		again = 0x200;
		*again_reg = 0x01;
	} else if (gain < 0x1000) {
		/* T_Gain >= 88x, A_gain is 4x */
		again = 0x400;
		*again_reg = 0x02;
	} else {
		/* T_Gain >= 176x, A_gain is 8x */
		again = 0x800;
		*again_reg = 0x03;
	}

	if (gain >= 0x200) {
		dgain = (gain * 0x100 + 0x80) / again;
		if (dgain < 0x200)
			dgain = 0x200;

		*dgain_reg = dgain;
	}
}

static int ov2718_g_mbus_config(struct v4l2_subdev *sd,
				struct v4l2_mbus_config *config)
{
	struct ov2718 *ov2718 = to_ov2718(sd);
	const struct ov2718_mode *mode = ov2718->cur_mode;
	u32 val = 0;

	if (mode->hdr_mode == NO_HDR)
		val = 1 << (OV2718_LANES - 1) |
		V4L2_MBUS_CSI2_CHANNEL_0 |
		V4L2_MBUS_CSI2_CONTINUOUS_CLOCK;
	if (mode->hdr_mode == HDR_X2)
		val = 1 << (OV2718_LANES - 1) |
		V4L2_MBUS_CSI2_CHANNEL_0 |
		V4L2_MBUS_CSI2_CONTINUOUS_CLOCK |
		V4L2_MBUS_CSI2_CHANNEL_1;

	config->type = V4L2_MBUS_CSI2;
	config->flags = val;

	return 0;
}

static void ov2718_get_module_inf(struct ov2718 *ov2718,
				  struct rkmodule_inf *inf)
{
	memset(inf, 0, sizeof(*inf));
	strlcpy(inf->base.sensor, OV2718_NAME, sizeof(inf->base.sensor));
	strlcpy(inf->base.module, ov2718->module_name,
		sizeof(inf->base.module));
	strlcpy(inf->base.lens, ov2718->len_name, sizeof(inf->base.lens));
}

static long ov2718_ioctl(struct v4l2_subdev *sd, unsigned int cmd, void *arg)
{
	struct ov2718 *ov2718 = to_ov2718(sd);
	struct i2c_client *client = ov2718->client;
	struct preisp_hdrae_exp_s *hdrae_exp = arg;
	struct rkmodule_hdr_cfg *hdr_cfg;
	u32 s_again, s_dgain, l_again, l_dgain;
	u32 again, i, h, w;
	long ret = 0;
	u32 stream = 0;

	switch (cmd) {
	case PREISP_CMD_SET_HDRAE_EXP:
		if (!ov2718->has_init_exp && !ov2718->streaming) {
			ov2718->init_hdrae_exp = *hdrae_exp;
			ov2718->has_init_exp = true;
			dev_info(&client->dev, "ov2718 don't streaming, record exp for hdr!\n");
			break;
		}
		dev_dbg(&client->dev,
			"rev exp req: L_exp: 0x%x, 0x%x, S_exp: 0x%x, 0x%x\n",
			hdrae_exp->middle_exp_reg,
			hdrae_exp->middle_gain_reg,
			hdrae_exp->short_exp_reg,
			hdrae_exp->short_gain_reg);

		ov2718_get_hcg_reg(hdrae_exp->middle_gain_reg,
				   &l_again,
				   &l_dgain);
		ov2718_get_lcg_reg(hdrae_exp->short_gain_reg,
				   &s_again,
				   &s_dgain);

		again = s_again << 2 | l_again;

		ret = ov2718_write_reg(ov2718->client,
				       OV2718_REG_OPERATE_CTL,
				       OV2718_REG_VALUE_08BIT,
				       0x00);

		/* group 0 */
		ret |= ov2718_write_reg(ov2718->client,
					OV2718_REG_GROUP_CTL,
					OV2718_REG_VALUE_08BIT,
					0x00);

		ret |= ov2718_write_reg(ov2718->client,
					OV2718_REG_EXPOSURE_H |
					OV2718_REG_GROUP_BIT,
					OV2718_REG_VALUE_08BIT,
					(hdrae_exp->middle_exp_reg >> 8) & 0xFF);

		ret |= ov2718_write_reg(ov2718->client,
					OV2718_REG_EXPOSURE_L |
					OV2718_REG_GROUP_BIT,
					OV2718_REG_VALUE_08BIT,
					hdrae_exp->middle_exp_reg & 0xFF);

		ret |= ov2718_write_reg(ov2718->client,
					OV2718_REG_GAIN |
					OV2718_REG_GROUP_BIT,
					OV2718_REG_VALUE_08BIT,
					again);

		ret |= ov2718_write_reg(ov2718->client,
					OV2718_REG_DIG_GAIN_HCG_H |
					OV2718_REG_GROUP_BIT,
					OV2718_REG_VALUE_08BIT,
					(l_dgain >> 8) & 0xFF);

		ret |= ov2718_write_reg(ov2718->client,
					OV2718_REG_DIG_GAIN_HCG_L |
					OV2718_REG_GROUP_BIT,
					OV2718_REG_VALUE_08BIT,
					l_dgain & 0xFF);

		ret |= ov2718_write_reg(ov2718->client,
					OV2718_REG_DIG_GAIN_LCG_H |
					OV2718_REG_GROUP_BIT,
					OV2718_REG_VALUE_08BIT,
					(s_dgain >> 8) & 0xFF);

		ret |= ov2718_write_reg(ov2718->client,
					OV2718_REG_DIG_GAIN_LCG_L |
					OV2718_REG_GROUP_BIT,
					OV2718_REG_VALUE_08BIT,
					s_dgain & 0xFF);

		/* launch immediately */
		ret |= ov2718_write_reg(ov2718->client,
					OV2718_REG_GROUP_CTL,
					OV2718_REG_VALUE_08BIT,
					0x40);

		/* single start */
		ret |= ov2718_write_reg(ov2718->client,
					OV2718_REG_OPERATE_CTL,
					OV2718_REG_VALUE_08BIT,
					0x01);

		dev_dbg(&client->dev, "set to reg, exp: 0x%02x, again: 0x%02x, l_dgain: 0x%02x, s_dgain: 0x%02x\n",
			hdrae_exp->middle_exp_reg,
			again,
			l_dgain,
			s_dgain);
		break;
	case RKMODULE_GET_HDR_CFG:
		hdr_cfg = (struct rkmodule_hdr_cfg *)arg;
		hdr_cfg->esp.mode = HDR_NORMAL_VC;
		hdr_cfg->hdr_mode = ov2718->cur_mode->hdr_mode;
		break;
	case RKMODULE_GET_MODULE_INFO:
		ov2718_get_module_inf(ov2718, (struct rkmodule_inf *)arg);
		break;
	case RKMODULE_SET_HDR_CFG:
		hdr_cfg = (struct rkmodule_hdr_cfg *)arg;
		w = ov2718->cur_mode->width;
		h = ov2718->cur_mode->height;
		for (i = 0; i < ov2718->support_modes_num; i++) {
			if (w == supported_modes[i].width &&
			h == supported_modes[i].height &&
			supported_modes[i].hdr_mode == hdr_cfg->hdr_mode) {
				ov2718->cur_mode = &supported_modes[i];
				break;
			}
		}
		if (i == ov2718->support_modes_num) {
			dev_err(&client->dev,
				"not find hdr mode:%d %dx%d config\n",
				hdr_cfg->hdr_mode, w, h);
			ret = -EINVAL;
		} else {
			w = ov2718->cur_mode->hts_def - ov2718->cur_mode->width;
			h = ov2718->cur_mode->vts_def - ov2718->cur_mode->height;
			__v4l2_ctrl_modify_range(ov2718->hblank, w, w, 1, w);
			__v4l2_ctrl_modify_range(ov2718->vblank, h,
				OV2718_VTS_MAX - ov2718->cur_mode->height,
				1, h);
			dev_info(&client->dev,
				"sensor hdr mode: %d, supported_modes[%d]\n",
				ov2718->cur_mode->hdr_mode, i);
		}
		break;
	case RKMODULE_SET_QUICK_STREAM:

		stream = *((u32 *)arg);

		if (stream)
			ret = ov2718_write_reg(ov2718->client, OV2718_REG_CTRL_MODE,
				OV2718_REG_VALUE_08BIT, OV2718_MODE_STREAMING);
		else
			ret = ov2718_write_reg(ov2718->client, OV2718_REG_CTRL_MODE,
				OV2718_REG_VALUE_08BIT, OV2718_MODE_SW_STANDBY);
		break;
	default:
		return -ENOIOCTLCMD;
	}

	return ret;
}

#ifdef CONFIG_COMPAT
static long ov2718_compat_ioctl32(struct v4l2_subdev *sd,
				  unsigned int cmd, unsigned long arg)
{
	void __user *up = compat_ptr(arg);
	struct rkmodule_inf *inf;
	struct rkmodule_awb_cfg *cfg;
	struct rkmodule_hdr_cfg *hdr;
	struct preisp_hdrae_exp_s *hdrae;
	long ret;
	u32 stream = 0;

	switch (cmd) {
	case RKMODULE_GET_MODULE_INFO:
		inf = kzalloc(sizeof(*inf), GFP_KERNEL);
		if (!inf) {
			ret = -ENOMEM;
			return ret;
		}

		ret = ov2718_ioctl(sd, cmd, inf);
		if (!ret)
			ret = copy_to_user(up, inf, sizeof(*inf));
		kfree(inf);
		break;
	case RKMODULE_GET_HDR_CFG:
		hdr = kzalloc(sizeof(*hdr), GFP_KERNEL);
		if (!hdr) {
			ret = -ENOMEM;
			return ret;
		}

		ret = ov2718_ioctl(sd, cmd, hdr);
		if (!ret)
			ret = copy_to_user(up, hdr, sizeof(*hdr));
		kfree(hdr);
		break;
	case RKMODULE_SET_HDR_CFG:
		hdr = kzalloc(sizeof(*hdr), GFP_KERNEL);
		if (!hdr) {
			ret = -ENOMEM;
			return ret;
		}

		ret = copy_from_user(hdr, up, sizeof(*hdr));
		if (!ret)
			ret = ov2718_ioctl(sd, cmd, hdr);
		kfree(hdr);
		break;
	case RKMODULE_AWB_CFG:
		cfg = kzalloc(sizeof(*cfg), GFP_KERNEL);
		if (!cfg) {
			ret = -ENOMEM;
			return ret;
		}

		ret = copy_from_user(cfg, up, sizeof(*cfg));
		if (!ret)
			ret = ov2718_ioctl(sd, cmd, cfg);
		kfree(cfg);
		break;
	case PREISP_CMD_SET_HDRAE_EXP:
		hdrae = kzalloc(sizeof(*hdrae), GFP_KERNEL);
		if (!hdrae) {
			ret = -ENOMEM;
			return ret;
		}

		ret = copy_from_user(hdrae, up, sizeof(*hdrae));
		if (!ret)
			ret = ov2718_ioctl(sd, cmd, hdrae);
		kfree(hdrae);
		break;
	case RKMODULE_SET_QUICK_STREAM:
		ret = copy_from_user(&stream, up, sizeof(u32));
		if (!ret)
			ret = ov2718_ioctl(sd, cmd, &stream);
		break;
	default:
		ret = -ENOIOCTLCMD;
		break;
	}

	return ret;
}
#endif

static int ov2718_set_flip(struct ov2718 *ov2718, u32 flip)
{
	u32 mode = 0;
	int ret = 0;

	ret = ov2718_read_reg(ov2718->client, OV2718_READ_MODE,
			      OV2718_REG_VALUE_08BIT, &mode);

	mode &= ~(OV2718_MIRROR | OV2718_FLIP);
	mode |= flip;

	if (flip & OV2718_MIRROR) {
		ov2718_write_reg(ov2718->client, 0x30a9,
				 OV2718_REG_VALUE_08BIT, 0x3);
		ov2718_write_reg(ov2718->client, 0x3252,
				 OV2718_REG_VALUE_08BIT, 0x21);
	}

	ret |= ov2718_write_reg(ov2718->client, OV2718_READ_MODE,
				OV2718_REG_VALUE_08BIT, mode);

	return ret;
}

static int __ov2718_start_stream(struct ov2718 *ov2718)
{
	int ret;

	ret = ov2718_write_array(ov2718->client,
				 ov2718->cur_mode->reg_list);
	if (ret)
		return ret;

	/* In case these controls are set before streaming */
	if (ov2718->has_init_exp && ov2718->cur_mode->hdr_mode != NO_HDR) {
		ret = ov2718_ioctl(&ov2718->subdev, PREISP_CMD_SET_HDRAE_EXP,
				   &ov2718->init_hdrae_exp);
		if (ret) {
			dev_err(&ov2718->client->dev,
				"init exp fail in hdr mode\n");
			return ret;
		}
	} else {
		mutex_unlock(&ov2718->mutex);
		ret = v4l2_ctrl_handler_setup(&ov2718->ctrl_handler);
		mutex_lock(&ov2718->mutex);
		if (ret)
			return ret;
	}

	if (ov2718->flip)
		ov2718_set_flip(ov2718, ov2718->flip);

	return ov2718_write_reg(ov2718->client, OV2718_REG_CTRL_MODE,
				OV2718_REG_VALUE_08BIT, OV2718_MODE_STREAMING);
}

static int __ov2718_stop_stream(struct ov2718 *ov2718)
{
	ov2718->has_init_exp = false;
	return ov2718_write_reg(ov2718->client, OV2718_REG_CTRL_MODE,
				OV2718_REG_VALUE_08BIT, OV2718_MODE_SW_STANDBY);
}

static int ov2718_s_stream(struct v4l2_subdev *sd, int on)
{
	struct ov2718 *ov2718 = to_ov2718(sd);
	struct i2c_client *client = ov2718->client;
	int ret = 0;

	mutex_lock(&ov2718->mutex);
	on = !!on;
	if (on == ov2718->streaming)
		goto unlock_and_return;

	if (on) {
		ret = pm_runtime_get_sync(&client->dev);
		if (ret < 0) {
			pm_runtime_put_noidle(&client->dev);
			goto unlock_and_return;
		}

		ret = __ov2718_start_stream(ov2718);
		if (ret) {
			v4l2_err(sd, "start stream failed while write regs\n");
			pm_runtime_put(&client->dev);
			goto unlock_and_return;
		}
	} else {
		__ov2718_stop_stream(ov2718);
		pm_runtime_put(&client->dev);
	}

	ov2718->streaming = on;

unlock_and_return:
	mutex_unlock(&ov2718->mutex);

	return ret;
}

static int ov2718_s_power(struct v4l2_subdev *sd, int on)
{
	struct ov2718 *ov2718 = to_ov2718(sd);
	struct i2c_client *client = ov2718->client;
	int ret = 0;

	mutex_lock(&ov2718->mutex);

	/* If the power state is not modified - no work to do. */
	if (ov2718->power_on == !!on)
		goto unlock_and_return;

	if (on) {
		ret = pm_runtime_get_sync(&client->dev);
		if (ret < 0) {
			pm_runtime_put_noidle(&client->dev);
			goto unlock_and_return;
		}

		ov2718->power_on = true;
	} else {
		pm_runtime_put(&client->dev);
		ov2718->power_on = false;
	}

unlock_and_return:
	mutex_unlock(&ov2718->mutex);

	return ret;
}

/* Calculate the delay in us by clock rate and clock cycles */
static inline u32 ov2718_cal_delay(u32 cycles)
{
	return DIV_ROUND_UP(cycles, OV2718_XVCLK_FREQ / 1000 / 1000);
}

static int __ov2718_power_on(struct ov2718 *ov2718)
{
	int ret;
	u32 delay_us;
	struct device *dev = &ov2718->client->dev;

	if (!IS_ERR_OR_NULL(ov2718->pins_default)) {
		ret = pinctrl_select_state(ov2718->pinctrl,
					   ov2718->pins_default);
		if (ret < 0)
			dev_err(dev, "could not set pins\n");
	}
	ret = clk_set_rate(ov2718->xvclk, OV2718_XVCLK_FREQ);
	if (ret < 0)
		dev_warn(dev, "Failed to set xvclk rate (24MHz)\n");
	if (clk_get_rate(ov2718->xvclk) != OV2718_XVCLK_FREQ)
		dev_warn(dev, "xvclk mismatched, modes are based on 24MHz\n");
	ret = clk_prepare_enable(ov2718->xvclk);
	if (ret < 0) {
		dev_err(dev, "Failed to enable xvclk\n");
		return ret;
	}
	ret = regulator_bulk_enable(OV2718_NUM_SUPPLIES, ov2718->supplies);
	if (ret < 0) {
		dev_err(dev, "Failed to enable regulators\n");
		goto disable_clk;
	}

	if (!IS_ERR(ov2718->pwd_gpio)) {
		gpiod_direction_output(ov2718->pwd_gpio, 1);
		usleep_range(3000, 5000);
	}

	if (!IS_ERR(ov2718->pd_gpio)) {
		gpiod_direction_output(ov2718->pd_gpio, 1);
		usleep_range(1500, 2000);
	}

	if (!IS_ERR(ov2718->rst_gpio)) {
		gpiod_direction_output(ov2718->rst_gpio, 1);
		usleep_range(1500, 2000);
		gpiod_direction_output(ov2718->rst_gpio, 0);
	}
	/* 8192 cycles prior to first SCCB transaction */
	delay_us = ov2718_cal_delay(8192);
	usleep_range(delay_us * 2, delay_us * 4);

	return 0;

disable_clk:
	clk_disable_unprepare(ov2718->xvclk);

	return ret;
}

static void __ov2718_power_off(struct ov2718 *ov2718)
{
	int ret;
	struct device *dev = &ov2718->client->dev;

	if (!IS_ERR(ov2718->pd_gpio))
		gpiod_direction_output(ov2718->pd_gpio, 0);

	clk_disable_unprepare(ov2718->xvclk);

	if (!IS_ERR(ov2718->rst_gpio))
		gpiod_direction_output(ov2718->rst_gpio, 0);

	if (!IS_ERR(ov2718->pwd_gpio))
		gpiod_direction_output(ov2718->pwd_gpio, 0);

	if (!IS_ERR_OR_NULL(ov2718->pins_sleep)) {
		ret = pinctrl_select_state(ov2718->pinctrl,
					   ov2718->pins_sleep);
		if (ret < 0)
			dev_err(dev, "could not set pins\n");
	}

	regulator_bulk_disable(OV2718_NUM_SUPPLIES, ov2718->supplies);
}

static int ov2718_runtime_resume(struct device *dev)
{
	struct i2c_client *client = to_i2c_client(dev);
	struct v4l2_subdev *sd = i2c_get_clientdata(client);
	struct ov2718 *ov2718 = to_ov2718(sd);

	return __ov2718_power_on(ov2718);
}

static int ov2718_runtime_suspend(struct device *dev)
{
	struct i2c_client *client = to_i2c_client(dev);
	struct v4l2_subdev *sd = i2c_get_clientdata(client);
	struct ov2718 *ov2718 = to_ov2718(sd);

	__ov2718_power_off(ov2718);

	return 0;
}

#ifdef CONFIG_VIDEO_V4L2_SUBDEV_API
static int ov2718_open(struct v4l2_subdev *sd, struct v4l2_subdev_fh *fh)
{
	struct ov2718 *ov2718 = to_ov2718(sd);
	struct v4l2_mbus_framefmt *try_fmt =
			v4l2_subdev_get_try_format(sd, fh->pad, 0);
	const struct ov2718_mode *def_mode = &ov2718->support_modes[0];

	mutex_lock(&ov2718->mutex);
	/* Initialize try_fmt */
	try_fmt->width = def_mode->width;
	try_fmt->height = def_mode->height;
	try_fmt->code = def_mode->bus_fmt;
	try_fmt->field = V4L2_FIELD_NONE;

	mutex_unlock(&ov2718->mutex);
	/* No crop or compose */

	return 0;
}
#endif

static int ov2718_enum_frame_interval(struct v4l2_subdev *sd,
				       struct v4l2_subdev_pad_config *cfg,
				       struct v4l2_subdev_frame_interval_enum *fie)
{
	struct ov2718 *ov2718 = to_ov2718(sd);

	if (fie->index >= ov2718->support_modes_num)
		return -EINVAL;

	fie->code = supported_modes[fie->index].bus_fmt;
	fie->width = ov2718->support_modes[fie->index].width;
	fie->height = ov2718->support_modes[fie->index].height;
	fie->interval = ov2718->support_modes[fie->index].max_fps;
	fie->reserved[0] = supported_modes[fie->index].hdr_mode;

	return 0;
}

static const struct dev_pm_ops ov2718_pm_ops = {
	SET_RUNTIME_PM_OPS(ov2718_runtime_suspend,
			   ov2718_runtime_resume, NULL)
};

#ifdef CONFIG_VIDEO_V4L2_SUBDEV_API
static const struct v4l2_subdev_internal_ops ov2718_internal_ops = {
	.open = ov2718_open,
};
#endif

static const struct v4l2_subdev_video_ops ov2718_video_ops = {
	.s_stream = ov2718_s_stream,
	.g_frame_interval = ov2718_g_frame_interval,
	.g_mbus_config = ov2718_g_mbus_config,
};

static const struct v4l2_subdev_pad_ops ov2718_pad_ops = {
	.enum_mbus_code = ov2718_enum_mbus_code,
	.enum_frame_size = ov2718_enum_frame_sizes,
	.enum_frame_interval = ov2718_enum_frame_interval,
	.get_fmt = ov2718_get_fmt,
	.set_fmt = ov2718_set_fmt,
};

static const struct v4l2_subdev_core_ops ov2718_core_ops = {
	.s_power = ov2718_s_power,
	.ioctl = ov2718_ioctl,
#ifdef CONFIG_COMPAT
	.compat_ioctl32 = ov2718_compat_ioctl32,
#endif
};

static const struct v4l2_subdev_ops ov2718_subdev_ops = {
	.core = &ov2718_core_ops,
	.video = &ov2718_video_ops,
	.pad = &ov2718_pad_ops,
};

static void ov2718_get_linear_reg(u32 gain, u32 *gain_a, u32 *gain_d)
{
	if (gain < 0x300) {
		/* min T_Gain is 3x */
		*gain_a = 0x01;
		gain = 0x180;
	} else if (gain >= 0x300 && gain < 0x460) {
		/* 3X----4.375X, LCG 2*A gain */
		*gain_a = 0x01;
		gain = gain / 2;
	} else if (gain >= 0x460 && gain < 0x8c0) {
		/* 4.375X----8.750X, LCG 4*A gain */
		*gain_a = 0x02;
		gain = gain / 4;
	} else if (gain >= 0x8c0 && gain < 0x1600) {
		/* 8.750X----22X, LCG 8*A gain */
		*gain_a = 0x03;
		gain = gain / 8;
	} else if (gain >= 0x1600 && gain < 0x2c00) {
		/* 22X----44X, HCG 1*A gain */
		*gain_a = 0x40;
		gain = gain / 11;
	} else if (gain >= 0x2c00 && gain < 0x5800) {
		/* 44X----88X, HCG 2*A gain */
		*gain_a = 0x41;
		gain = gain / (11 * 2);
	} else if (gain >= 0x5800 && gain < 0xb000) {
		/* 88X----176X, HCG 4*A gain */
		*gain_a = 0x42;
		gain = gain / (11 * 4);
	} else {
		/* >=176X, HCG 8*A gain */
		*gain_a = 0x43;
		gain = gain / (11 * 8);
	}

	*gain_d = gain;
}

static int ov2718_set_ctrl(struct v4l2_ctrl *ctrl)
{
	struct ov2718 *ov2718 = container_of(ctrl->handler,
					     struct ov2718, ctrl_handler);
	struct i2c_client *client = ov2718->client;
	s64 max;
	u32 gain_a, gain_d, val;
	int ret = 0;

	/* Propagate change of current control to all related controls */
	switch (ctrl->id) {
	case V4L2_CID_VBLANK:
		/* Update max exposure while meeting expected vblanking */
		max = ov2718->cur_mode->height + ctrl->val - 4;
		__v4l2_ctrl_modify_range(ov2718->exposure,
					 ov2718->exposure->minimum, max,
					 ov2718->exposure->step,
					 ov2718->exposure->default_value);
		break;
	}

	if (!pm_runtime_get_if_in_use(&client->dev))
		return 0;

	switch (ctrl->id) {
	case V4L2_CID_EXPOSURE:
		ret = ov2718_write_reg(ov2718->client,
				       OV2718_REG_EXPOSURE_H,
				       OV2718_REG_VALUE_08BIT,
				       (ctrl->val >> 8) & 0xFF);

		ret |= ov2718_write_reg(ov2718->client,
					OV2718_REG_EXPOSURE_L,
					OV2718_REG_VALUE_08BIT,
					ctrl->val & 0xFF);
		dev_info(&client->dev,
			"set exp: 0x%x\n", ctrl->val);
		break;
	case V4L2_CID_ANALOGUE_GAIN:
		ov2718_get_linear_reg(ctrl->val, &gain_a, &gain_d);
		ret = ov2718_write_reg(ov2718->client,
				       OV2718_REG_GAIN,
				       OV2718_REG_VALUE_08BIT,
				       gain_a);

		ret |= ov2718_write_reg(ov2718->client,
					OV2718_REG_DIG_GAIN_HCG_H,
					OV2718_REG_VALUE_08BIT,
					(gain_d >> 8) & 0xFF);

		ret |= ov2718_write_reg(ov2718->client,
					OV2718_REG_DIG_GAIN_HCG_L,
					OV2718_REG_VALUE_08BIT,
					gain_d & 0xFF);
		dev_info(&client->dev,
			"set gain: 0x%x, again: 0x%x, dgain: 0x%x\n",
			ctrl->val, gain_a, gain_d);
		break;
	case V4L2_CID_VBLANK:
		val = ctrl->val + ov2718->cur_mode->height;
		ret = ov2718_write_reg(ov2718->client,
				       OV2718_REG_VTS_H,
				       OV2718_REG_VALUE_08BIT,
				       (val >> 8) & 0xFF);

		ret |= ov2718_write_reg(ov2718->client,
					OV2718_REG_VTS_L,
					OV2718_REG_VALUE_08BIT,
					val & 0xFF);
		dev_dbg(&client->dev,
			"set vts: 0x%x, 0x%x\n", ctrl->val, val);
		break;
	case V4L2_CID_TEST_PATTERN:
		ret = ov2718_enable_test_pattern(ov2718, ctrl->val);
		break;
	case V4L2_CID_HFLIP:
		if (ctrl->val)
			ov2718->flip |= OV2718_MIRROR;
		else
			ov2718->flip &= ~OV2718_MIRROR;
		break;
	case V4L2_CID_VFLIP:
		if (ctrl->val)
			ov2718->flip |= OV2718_FLIP;
		else
			ov2718->flip &= ~OV2718_FLIP;
		break;
	default:
		dev_warn(&client->dev, "%s Unhandled id:0x%x, val:0x%x\n",
			 __func__, ctrl->id, ctrl->val);
		break;
	}

	pm_runtime_put(&client->dev);

	return ret;
}

static const struct v4l2_ctrl_ops ov2718_ctrl_ops = {
	.s_ctrl = ov2718_set_ctrl,
};

static int ov2718_initialize_controls(struct ov2718 *ov2718)
{
	const struct ov2718_mode *mode;
	struct v4l2_ctrl_handler *handler;
	struct v4l2_ctrl *ctrl;
	s64 exposure_max, vblank_def;
	u32 h_blank;
	int ret;

	handler = &ov2718->ctrl_handler;
	mode = ov2718->cur_mode;
	ret = v4l2_ctrl_handler_init(handler, 9);
	if (ret)
		return ret;
	handler->lock = &ov2718->mutex;

	ctrl = v4l2_ctrl_new_int_menu(handler, NULL, V4L2_CID_LINK_FREQ,
				      0, 0, link_freq_menu_items);
	if (ctrl)
		ctrl->flags |= V4L2_CTRL_FLAG_READ_ONLY;

	if (mode->bus_fmt == MEDIA_BUS_FMT_SBGGR10_1X10)
		ov2718->pixel_rate = v4l2_ctrl_new_std(handler, NULL,
				     V4L2_CID_PIXEL_RATE, 0, OV2718_PIXEL_RATE_10BIT,
				     1, OV2718_PIXEL_RATE_10BIT);
	else
		ov2718->pixel_rate = v4l2_ctrl_new_std(handler, NULL,
				     V4L2_CID_PIXEL_RATE, 0, OV2718_PIXEL_RATE_10BIT,
				     1, OV2718_PIXEL_RATE_12BIT);

	h_blank = mode->hts_def - mode->width;
	ov2718->hblank = v4l2_ctrl_new_std(handler, NULL, V4L2_CID_HBLANK,
				h_blank, h_blank, 1, h_blank);
	if (ov2718->hblank)
		ov2718->hblank->flags |= V4L2_CTRL_FLAG_READ_ONLY;

	vblank_def = mode->vts_def - mode->height;
	ov2718->vblank = v4l2_ctrl_new_std(handler, &ov2718_ctrl_ops,
					   V4L2_CID_VBLANK, vblank_def,
					   OV2718_VTS_MAX - mode->height,
					   1, vblank_def);

	exposure_max = mode->vts_def - 4;
	ov2718->exposure = v4l2_ctrl_new_std(handler, &ov2718_ctrl_ops,
					     V4L2_CID_EXPOSURE,
					     OV2718_EXPOSURE_MIN,
					     exposure_max,
					     OV2718_EXPOSURE_STEP,
					     mode->exp_def);

	ov2718->anal_gain = v4l2_ctrl_new_std(handler, &ov2718_ctrl_ops,
					      V4L2_CID_ANALOGUE_GAIN,
					      OV2718_GAIN_MIN,
					      OV2718_GAIN_MAX,
					      OV2718_GAIN_STEP,
					      OV2718_GAIN_DEFAULT);

	ov2718->test_pattern =
		v4l2_ctrl_new_std_menu_items(handler,
					     &ov2718_ctrl_ops,
					     V4L2_CID_TEST_PATTERN,
					     ARRAY_SIZE(ov2718_test_pattern_menu) - 1,
					     0, 0, ov2718_test_pattern_menu);

	ov2718->h_flip = v4l2_ctrl_new_std(handler, &ov2718_ctrl_ops,
					   V4L2_CID_HFLIP, 0, 1, 1, 0);

	ov2718->v_flip = v4l2_ctrl_new_std(handler, &ov2718_ctrl_ops,
					   V4L2_CID_VFLIP, 0, 1, 1, 0);
	ov2718->flip = 0;

	if (handler->error) {
		ret = handler->error;
		dev_err(&ov2718->client->dev,
			"Failed to init controls(%d)\n", ret);
		goto err_free_handler;
	}

	ov2718->subdev.ctrl_handler = handler;
	ov2718->has_init_exp = false;

	return 0;

err_free_handler:
	v4l2_ctrl_handler_free(handler);

	return ret;
}

static int ov2718_check_sensor_id(struct ov2718 *ov2718,
				  struct i2c_client *client)
{
	struct device *dev = &ov2718->client->dev;
	u32 id = 0;
	int i, ret;

	for (i = 0; i < 5; i++) {
		ret = ov2718_read_reg(client, OV2718_REG_CHIP_ID,
				      OV2718_REG_VALUE_16BIT, &id);
		if (id == CHIP_ID)
			break;

		dev_err(dev, "Unexpected sensor id(%06x), ret(%d)\n",
			id, ret);
		usleep_range(1000, 2000);
		continue;
	}

	if (id != CHIP_ID)
		return -ENODEV;

	dev_info(dev, "Detected OV%06x sensor\n", CHIP_ID);

	return 0;
}

static int ov2718_get_regulators(struct ov2718 *ov2718)
{
	unsigned int i;

	for (i = 0; i < OV2718_NUM_SUPPLIES; i++)
		ov2718->supplies[i].supply = ov2718_supply_names[i];

	return devm_regulator_bulk_get(&ov2718->client->dev,
				       OV2718_NUM_SUPPLIES,
				       ov2718->supplies);
}

static int ov2718_analyze_dts(struct ov2718 *ov2718)
{
	struct device *dev = &ov2718->client->dev;

	ov2718->xvclk = devm_clk_get(dev, "xvclk");
	if (IS_ERR(ov2718->xvclk)) {
		dev_err(dev, "Failed to get xvclk\n");
		return -EINVAL;
	}

	ov2718->pinctrl = devm_pinctrl_get(dev);
	if (!IS_ERR(ov2718->pinctrl)) {
		ov2718->pins_default =
			pinctrl_lookup_state(ov2718->pinctrl,
					     OF_CAMERA_PINCTRL_STATE_DEFAULT);
		if (IS_ERR(ov2718->pins_default))
			dev_err(dev, "could not get default pinstate\n");

		ov2718->pins_sleep =
			pinctrl_lookup_state(ov2718->pinctrl,
					     OF_CAMERA_PINCTRL_STATE_SLEEP);
		if (IS_ERR(ov2718->pins_sleep))
			dev_err(dev, "could not get sleep pinstate\n");
	} else {
		dev_err(dev, "no pinctrl\n");
	}

	ov2718->pd_gpio = devm_gpiod_get(dev, "pd", GPIOD_OUT_LOW);
	if (IS_ERR(ov2718->pd_gpio))
		dev_warn(dev, "can not find pd-gpios, error %ld\n",
			 PTR_ERR(ov2718->pd_gpio));

	ov2718->rst_gpio = devm_gpiod_get(dev, "reset", GPIOD_OUT_LOW);
	if (IS_ERR(ov2718->rst_gpio))
		dev_warn(dev, "can not find rst-gpios, error %ld\n",
			 PTR_ERR(ov2718->rst_gpio));

	ov2718->pwd_gpio = devm_gpiod_get(dev, "pwd", GPIOD_OUT_HIGH);
	if (IS_ERR(ov2718->pwd_gpio))
		dev_warn(dev, "can not find pwd-gpios, error %ld\n",
			 PTR_ERR(ov2718->pwd_gpio));

	return ov2718_get_regulators(ov2718);
}

static int ov2718_probe(struct i2c_client *client,
			const struct i2c_device_id *id)
{
	struct device *dev = &client->dev;
	struct device_node *node = dev->of_node;
	struct ov2718 *ov2718;
	struct v4l2_subdev *sd;
	char facing[2];
	int ret;

	dev_info(dev, "driver version: %02x.%02x.%02x",
		DRIVER_VERSION >> 16,
		(DRIVER_VERSION & 0xff00) >> 8,
		DRIVER_VERSION & 0x00ff);

	ov2718 = devm_kzalloc(dev, sizeof(*ov2718), GFP_KERNEL);
	if (!ov2718)
		return -ENOMEM;

	ret = of_property_read_u32(node, RKMODULE_CAMERA_MODULE_INDEX,
				   &ov2718->module_index);
	ret |= of_property_read_string(node, RKMODULE_CAMERA_MODULE_FACING,
				       &ov2718->module_facing);
	ret |= of_property_read_string(node, RKMODULE_CAMERA_MODULE_NAME,
				       &ov2718->module_name);
	ret |= of_property_read_string(node, RKMODULE_CAMERA_LENS_NAME,
				       &ov2718->len_name);
	if (ret) {
		dev_err(dev, "could not get module information!\n");
		return -EINVAL;
	}

	ov2718->client = client;

	ret = ov2718_analyze_dts(ov2718);
	if (ret) {
		dev_err(dev, "Failed to analyze dts\n");
		return ret;
	}

	mutex_init(&ov2718->mutex);

	sd = &ov2718->subdev;
	v4l2_i2c_subdev_init(sd, client, &ov2718_subdev_ops);

	ov2718->support_modes = supported_modes;
	ov2718->support_modes_num = ARRAY_SIZE(supported_modes);
	ov2718->cur_mode = &ov2718->support_modes[0];

	ret = ov2718_initialize_controls(ov2718);
	if (ret)
		goto err_destroy_mutex;

	ret = __ov2718_power_on(ov2718);
	if (ret)
		goto err_free_handler;

	ret = ov2718_check_sensor_id(ov2718, client);
	if (ret)
		goto err_power_off;

#ifdef CONFIG_VIDEO_V4L2_SUBDEV_API
	sd->internal_ops = &ov2718_internal_ops;
	sd->flags |= V4L2_SUBDEV_FL_HAS_DEVNODE | V4L2_SUBDEV_FL_HAS_EVENTS;
#endif
#if defined(CONFIG_MEDIA_CONTROLLER)
	ov2718->pad.flags = MEDIA_PAD_FL_SOURCE;
	sd->entity.function = MEDIA_ENT_F_CAM_SENSOR;
	ret = media_entity_pads_init(&sd->entity, 1, &ov2718->pad);
	if (ret < 0)
		goto err_power_off;
#endif

	memset(facing, 0, sizeof(facing));
	if (strcmp(ov2718->module_facing, "back") == 0)
		facing[0] = 'b';
	else
		facing[0] = 'f';

	snprintf(sd->name, sizeof(sd->name), "m%02d_%s_%s %s",
		 ov2718->module_index, facing,
		 OV2718_NAME, dev_name(sd->dev));
	ret = v4l2_async_register_subdev_sensor_common(sd);
	if (ret) {
		dev_err(dev, "v4l2 async register subdev failed\n");
		goto err_clean_entity;
	}

	pm_runtime_set_active(dev);
	pm_runtime_enable(dev);
	pm_runtime_idle(dev);

	return 0;

err_clean_entity:
#if defined(CONFIG_MEDIA_CONTROLLER)
	media_entity_cleanup(&sd->entity);
#endif
err_power_off:
	__ov2718_power_off(ov2718);
err_free_handler:
	v4l2_ctrl_handler_free(&ov2718->ctrl_handler);
err_destroy_mutex:
	mutex_destroy(&ov2718->mutex);

	return ret;
}

static int ov2718_remove(struct i2c_client *client)
{
	struct v4l2_subdev *sd = i2c_get_clientdata(client);
	struct ov2718 *ov2718 = to_ov2718(sd);

	v4l2_async_unregister_subdev(sd);
#if defined(CONFIG_MEDIA_CONTROLLER)
	media_entity_cleanup(&sd->entity);
#endif
	v4l2_ctrl_handler_free(&ov2718->ctrl_handler);
	mutex_destroy(&ov2718->mutex);

	pm_runtime_disable(&client->dev);
	if (!pm_runtime_status_suspended(&client->dev))
		__ov2718_power_off(ov2718);
	pm_runtime_set_suspended(&client->dev);

	return 0;
}

#if IS_ENABLED(CONFIG_OF)
static const struct of_device_id ov2718_of_match[] = {
	{ .compatible = "ovti,ov2718" },
	{},
};
MODULE_DEVICE_TABLE(of, ov2718_of_match);
#endif

static const struct i2c_device_id ov2718_match_id[] = {
	{ "ovti,ov2718", 0 },
	{ },
};

static struct i2c_driver ov2718_i2c_driver = {
	.driver = {
		.name = OV2718_NAME,
		.pm = &ov2718_pm_ops,
		.of_match_table = of_match_ptr(ov2718_of_match),
	},
	.probe		= &ov2718_probe,
	.remove		= &ov2718_remove,
	.id_table	= ov2718_match_id,
};

static int __init sensor_mod_init(void)
{
	return i2c_add_driver(&ov2718_i2c_driver);
}

static void __exit sensor_mod_exit(void)
{
	i2c_del_driver(&ov2718_i2c_driver);
}

device_initcall_sync(sensor_mod_init);
module_exit(sensor_mod_exit);

MODULE_DESCRIPTION("OmniVision ov2718 sensor driver");
MODULE_LICENSE("GPL v2");
