﻿// SPDX-License-Identifier: GPL-2.0
/********************************************************************************
*
*  Copyright (C) 2017 	NEXTCHIP Inc. All rights reserved.
*  Module		: Raptor3 Device Driver
*  Description	: coax_table.h
*  Author		:
*  Date         :
*  Version		: Version 1.0
*
********************************************************************************
*  History      :
*
*
********************************************************************************/
#ifndef _RAPTOR3_COAX_TABLE_
#define _RAPTOR3_COAX_TABLE_


#include "nvp6158_coax_protocol.h"

#define EOD (-1)

#define CHANGEDRIVER 1

/*=============================================================
 * Coaxial UP/Down stream initialize structure
 ==============================================================*/
typedef struct NC_VD_COAX_Init_STR{
	 char *name;
	 unsigned char ch;
	 unsigned char rx_src;             //B5/6/7/8 0x7C
	 unsigned char rx_slice_lev;       //B5/6/7/8 0x7D
	 unsigned char tx_bank;
	 unsigned char tx_cmd_addr;
	 unsigned char tx_shot_addr;
	 unsigned char tx_baud[6];            //B3/4 0x00/80
	 unsigned char tx_pel_baud[6];        //B3/4 0x02/82
	 unsigned char tx_line_pos0[6];       //B3/4 0x03/83
	 unsigned char tx_line_pos1[6];       //B3/4 0x04/84
	 unsigned char tx_pel_line_pos0[6];   //B3/4 0x07/87
	 unsigned char tx_pel_line_pos1[6];   //B3/4 0x08/88
	 unsigned char tx_line_count;         //B3/4 0x05/85
	 unsigned char tx_line_count_max;     //B3/4 0x0A/8A
	 unsigned char tx_mode;               //B3/4 0x0B/8B
	 unsigned char tx_sync_pos0[6];       //B3/4 0x0D/8D
	 unsigned char tx_sync_pos1[6];       //B3/4 0x0E/8E
	 unsigned char tx_even;            //B3/4 0x2F/AF
	 unsigned char tx_zero_length;     //B3/4 0x0C/

	 unsigned char rx_comm_on;         //
	 unsigned char rx_area;            //
	 unsigned char rx_signal_enhance;  //
	 unsigned char rx_manual_duty;     //
	 unsigned char rx_head_matching;   //
	 unsigned char rx_data_rz;         //
	 unsigned char rx_sz;              //

	 int shot_delay;
	 int reset_delay;
}NC_VD_COAX_Init_STR;

/*=============================================================
 * Coaxial UP/Down stream command structure
 ==============================================================*/
typedef struct NC_VD_ACP_CMDDEF_STR{
	char *name;
	int ahd_16bit[16];
	int ahd_8bit[16];
	int ahd_4_5m[32];
	int cvi_cmd[32];
	int cvi_new_cmd[32];
	int cvi_checksum[16];
	int tvi_v1_0[16];
	int tvi_v2_0[16];
	int sd[16];
	int autostop;
}NC_VD_ACP_CMDDEF_STR;

static NC_VD_COAX_Init_STR nvp6158_coax_acp_16bit_init_lists[]=
{
	[ AHD20_720P_30P ] = {
		.name = "AHD20_720P_30P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x20,
		.tx_shot_addr      = 0x0c,
		.tx_baud 		   = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
		.tx_pel_baud 	   = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
		.tx_line_pos0 	   = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x03,
		.tx_pel_line_pos0  = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x07,
		.tx_mode 		   = 0x06,
		.tx_sync_pos0 	   = { 0xD2, 0xD2, 0xD2, 0xD2, 0xD2, 0xD2 },
		.tx_sync_pos1 	   = { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 30,
		.reset_delay = 30,
	},

	[ AHD20_720P_25P ] = {
		.name = "AHD20_720P_25P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x20,
		.tx_shot_addr      = 0x0c,
		.tx_baud 		   = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
		.tx_pel_baud 	   = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
		.tx_line_pos0 	   = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x03,
		.tx_pel_line_pos0  = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x07,
		.tx_mode 		   = 0x06,
		.tx_sync_pos0 	   = { 0xD2, 0xD2, 0xD2, 0xD2, 0xD2, 0xD2 },
		.tx_sync_pos1 	   = { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 30,
		.reset_delay = 30,
	},

	[ AHD20_720P_30P_EX ] = {
		.name = "AHD20_720P_30P_EX",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x20,
		.tx_shot_addr      = 0x0c,
		.tx_baud 		   = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
		.tx_pel_baud 	   = { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
		.tx_line_pos0 	   = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x03,
		.tx_pel_line_pos0  = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x07,
		.tx_mode 		   = 0x06,
		.tx_sync_pos0 	   = { 0xD2, 0xD2, 0xD2, 0xD2, 0xD2, 0xD2 },
		.tx_sync_pos1 	   = { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 30,
		.reset_delay = 30,
	},

	[ AHD20_720P_25P_EX ] = {
		.name = "AHD20_720P_25P_EX",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x20,
		.tx_shot_addr      = 0x0c,
		.tx_baud 		   = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
		.tx_pel_baud 	   = { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
		.tx_line_pos0 	   = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x03,
		.tx_pel_line_pos0  = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x07,
		.tx_mode 		   = 0x06,
		.tx_sync_pos0 	   = { 0xD2, 0xD2, 0xD2, 0xD2, 0xD2, 0xD2 },
		.tx_sync_pos1 	   = { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 30,
		.reset_delay = 30,
	},

	[ AHD20_720P_30P_EX_Btype ] = {
		.name = "AHD20_720P_30P_EX_Btype",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x20,
		.tx_shot_addr      = 0x0c,
		.tx_baud 		   = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
		.tx_pel_baud 	   = { 0x26, 0x26, 0x26, 0x26, 0x26, 0x26 },
		.tx_line_pos0 	   = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x03,
		.tx_pel_line_pos0  = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x07,
		.tx_mode 		   = 0x06,
		.tx_sync_pos0 	   = { 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0 },
		.tx_sync_pos1 	   = { 0x03, 0x03, 0x03, 0x03, 0x03, 0x03 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 30,
		.reset_delay = 30,
	},

	[ AHD20_720P_25P_EX_Btype ] = {
		.name = "AHD20_720P_25P_EX_Btype",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x20,
		.tx_shot_addr      = 0x0c,
		.tx_baud 		   = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
		.tx_pel_baud 	   = { 0x26, 0x26, 0x26, 0x26, 0x26, 0x26 },
		.tx_line_pos0 	   = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x03,
		.tx_pel_line_pos0  = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x07,
		.tx_mode 		   = 0x06,
		.tx_sync_pos0 	   = { 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0 },
		.tx_sync_pos1 	   = { 0x03, 0x03, 0x03, 0x03, 0x03, 0x03 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 30,
		.reset_delay = 30,
	},

		[ CVI_4M_25P ] = {
			.name = "CVI_4M_25P",
			.ch 			   = 0,
			.rx_src 		   = 0x01,
			.rx_slice_lev 	   = 0x80,
			.tx_bank           = 0x0C,
			.tx_cmd_addr       = 0x00,
			.tx_shot_addr      = 0x09,
			.tx_baud 		   = { 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_line_pos0 	   = { 0x16, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_line_count 	   = 0x04,
			.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_line_count_max = 0x09,
			.tx_mode 		   = 0x60,
			.tx_sync_pos0 	   = { 0xdf, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_sync_pos1 	   = { 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_even 		   = 0x00,
			.tx_zero_length    = 0x10,

			.rx_comm_on        = 0x01,
			.rx_area           = 0x05,
			.rx_signal_enhance = 0x01,
			.rx_manual_duty    = 0x64,
			.rx_head_matching  = 0xAB,
			.rx_data_rz        = 0x85,
			.rx_sz             = 0x60,

			.shot_delay = 25,
			.reset_delay = 25,
		},

		[ CVI_4M_30P ] = {
			.name = "CVI_4M_30P",
			.ch 			   = 0,
			.rx_src 		   = 0x01,
			.rx_slice_lev 	   = 0x80,
			.tx_bank           = 0x0C,
			.tx_cmd_addr       = 0x00,
			.tx_shot_addr      = 0x09,
			.tx_baud 	  	   = { 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_line_pos0 	   = { 0x16, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_line_count 	   = 0x04,
			.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_line_count_max = 0x09,
			.tx_mode 		   = 0x60,
			.tx_sync_pos0 	   = { 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_sync_pos1 	   = { 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_even 		   = 0x00,
			.tx_zero_length    = 0x10,

			.rx_comm_on        = 0x01,
			.rx_area           = 0x05,
			.rx_signal_enhance = 0x01,
			.rx_manual_duty    = 0x64,
			.rx_head_matching  = 0xAB,
			.rx_data_rz        = 0x85,
			.rx_sz             = 0x60,

			.shot_delay = 25,
			.reset_delay = 25,
		},
		[ CVI_5M_20P ] = {
			.name = "CVI_5M_20P",
			.ch 			   = 0,
			.rx_src 		   = 0x01,
			.rx_slice_lev	   = 0x80,
			.tx_bank		   = 0x0C,
			.tx_cmd_addr	   = 0x00,
			.tx_shot_addr	   = 0x09,
			.tx_baud		   = { 0x16, 0x00, 0x00, 0x2b, 0x00, 0x00 },
			.tx_pel_baud	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_line_pos0	   = { 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_line_pos1	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_line_count	   = 0x05,
			.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_line_count_max = 0x0c,
			.tx_mode		   = 0x60,
			.tx_sync_pos0	   = { 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_sync_pos1	   = { 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_even		   = 0x00,
			.tx_zero_length    = 0x10,
		
			.rx_comm_on 	   = 0x01,
			.rx_area		   = 0x05,
			.rx_signal_enhance = 0x01,
			.rx_manual_duty    = 0x64,
			.rx_head_matching  = 0xAB,
			.rx_data_rz 	   = 0x85,
			.rx_sz			   = 0x60,
		
			.shot_delay = 25,
			.reset_delay = 25,
		},

		[ CVI_8M_15P ] = {
			.name = "CVI_8M_15P",
			.ch 			   = 0,
			.rx_src 		   = 0x01,
			.rx_slice_lev 	   = 0x80,
			.tx_bank           = 0x0C,
			.tx_cmd_addr       = 0x00,
			.tx_shot_addr      = 0x09,
			.tx_baud 		   = { 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_line_pos0 	   = { 0x16, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_line_count 	   = 0x04,
			.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_line_count_max = 0x09,
			.tx_mode 		   = 0x60,
			.tx_sync_pos0 	   = { 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_sync_pos1 	   = { 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_even 		   = 0x00,
			.tx_zero_length    = 0x10,

			.rx_comm_on        = 0x01,
			.rx_area           = 0x05,
			.rx_signal_enhance = 0x01,
			.rx_manual_duty    = 0x64,
			.rx_head_matching  = 0xAB,
			.rx_data_rz        = 0x85,
			.rx_sz             = 0x60,

			.shot_delay = 25,
			.reset_delay = 25,
		},

		[ CVI_8M_12_5P ] = {
			.name = "CVI_8M_12_5P",
			.ch 			   = 0,
			.rx_src 		   = 0x01,
			.rx_slice_lev 	   = 0x80,
			.tx_bank           = 0x0C,
			.tx_cmd_addr       = 0x00,
			.tx_shot_addr      = 0x09,
			.tx_baud 		   = { 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_line_pos0 	   = { 0x16, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_line_count     = 0x04,
			.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_line_count_max = 0x09,
			.tx_mode 		   = 0x60,
			.tx_sync_pos0 	   = { 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_sync_pos1 	   = { 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },
			.tx_even 		   = 0x00,
			.tx_zero_length    = 0x10,

			.rx_comm_on        = 0x01,
			.rx_area           = 0x05,
			.rx_signal_enhance = 0x01,
			.rx_manual_duty    = 0x64,
			.rx_head_matching  = 0xAB,
			.rx_data_rz        = 0x85,
			.rx_sz             = 0x60,

			.shot_delay = 25,
			.reset_delay = 25,
		},

};

static NC_VD_COAX_Init_STR nvp6158_coax_init_lists[]=
{
	[ AHD20_SD_H960_2EX_Btype_NT ] = {
		.name = "AHD20_SD_H960_2EX_Btype_NT",
		.ch                = 0,
		.rx_src            = 0x01,
		.rx_slice_lev      = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x20,
		.tx_shot_addr      = 0x0c, // 0x0C
		.tx_baud           = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud       = { 0x48, 0x48, 0x48, 0x48, 0x48, 0x48 },
		.tx_line_pos0      = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1      = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count     = 0x01,
		.tx_pel_line_pos0  = { 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x01,
		.tx_mode           = 0x06,
		.tx_sync_pos0      = { 0x60, 0x60, 0x60, 0x60, 0x60, 0x60 },
		.tx_sync_pos1      = { 0x02, 0x02, 0x02, 0x02, 0x02, 0x02 },
		.tx_even           = 0x01,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay  = 25,
		.reset_delay = 25,
	},

	[ AHD20_SD_H960_2EX_Btype_PAL ] = {
		.name = "AHD20_SD_H960_2EX_Btype_PAL",
		.ch                = 0,
		.rx_src            = 0x01,
		.rx_slice_lev      = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x20,
		.tx_shot_addr      = 0x0c,
		.tx_baud           = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud       = { 0x48, 0x48, 0x48, 0x48, 0x48, 0x48 },
		.tx_line_pos0      = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1      = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count     = 0x01,
		.tx_pel_line_pos0  = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x01,
		.tx_mode           = 0x06,
		.tx_sync_pos0      = { 0x60, 0x60, 0x60, 0x60, 0x60, 0x60 },
		.tx_sync_pos1      = { 0x02, 0x02, 0x02, 0x02, 0x02, 0x02 },
		.tx_even           = 0x01,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay  = 25,
		.reset_delay = 25,
	},

	[ AHD20_SD_H960_NT ] = {
		.name = "AHD20_SD_H960_NT",
		.ch                = 0,
		.rx_src            = 0x01,
		.rx_slice_lev      = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x20,
		.tx_shot_addr      = 0x0c,
		.tx_baud           = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud       = { 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b },
		.tx_line_pos0      = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1      = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count     = 0x01,
		.tx_pel_line_pos0  = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x01,
		.tx_mode           = 0x06,
		.tx_sync_pos0      = { 0x70, 0x70, 0x70, 0x70, 0x70, 0x70 },
		.tx_sync_pos1      = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even           = 0x01,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 30,
		.reset_delay = 30,
	},

	[ AHD20_SD_H960_PAL ] = {
		.name = "AHD20_SD_H960_PAL",
		.ch                = 0,
		.rx_src            = 0x01,
		.rx_slice_lev      = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x20,
		.tx_shot_addr      = 0x0c,
		.tx_baud 		   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud       = { 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b },
		.tx_line_pos0      = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1      = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count     = 0x01,
		.tx_pel_line_pos0  = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x01,
		.tx_mode           = 0x06,
		.tx_sync_pos0      = { 0x70, 0x70, 0x70, 0x70, 0x70, 0x70 },
		.tx_sync_pos1      = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even           = 0x01,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 30,
		.reset_delay = 30,
	},

	[ AHD20_SD_H1280_NT ] = {
		.name = "AHD20_SD_H1280_NT",
		.ch                = 0,
		.rx_src            = 0x01,
		.rx_slice_lev      = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x20,
		.tx_shot_addr      = 0x0c,
		.tx_baud           = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud       = { 0x48, 0x48, 0x48, 0x48, 0x48, 0x48 },
		.tx_line_pos0      = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1      = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count     = 0x01,
		.tx_pel_line_pos0  = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x01,
		.tx_mode           = 0x06,
		.tx_sync_pos0      = { 0x60, 0x60, 0x60, 0x60, 0x60, 0x60 },
		.tx_sync_pos1      = { 0x02, 0x02, 0x02, 0x02, 0x02, 0x02 },
		.tx_even           = 0x01,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 35,
		.reset_delay = 35,
	},

	[ AHD20_SD_H1280_PAL ] = {
		.name = "AHD20_SD_H1280_PAL",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x20,
		.tx_shot_addr      = 0x0c,
		.tx_baud 		   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x48, 0x48, 0x48, 0x48, 0x48, 0x48 },
		.tx_line_pos0 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1      = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count     = 0x01,
		.tx_pel_line_pos0  = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x01,
		.tx_mode 		   = 0x06,
		.tx_sync_pos0 	   = { 0x60, 0x60, 0x60, 0x60, 0x60, 0x60 },
		.tx_sync_pos1      = { 0x02, 0x02, 0x02, 0x02, 0x02, 0x02 },
		.tx_even 		   = 0x01,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 35,
		.reset_delay = 35,
	},

	[ AHD20_SD_H1440_NT ] = {
		.name = "AHD20_SD_H1440_NT",
		.ch                = 0,
		.rx_src            = 0x01,
		.rx_slice_lev      = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x20,
		.tx_shot_addr      = 0x0c,
		.tx_baud           = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud       = { 0x48, 0x48, 0x48, 0x48, 0x48, 0x48 },
		.tx_line_pos0      = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1      = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count     = 0x01,
		.tx_pel_line_pos0  = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x01,
		.tx_mode           = 0x06,
		.tx_sync_pos0      = { 0x60, 0x60, 0x60, 0x60, 0x60, 0x60 },
		.tx_sync_pos1      = { 0x02, 0x02, 0x02, 0x02, 0x02, 0x02 },
		.tx_even           = 0x01,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 30,
		.reset_delay = 30,
	},

	[ AHD20_SD_H1440_PAL ] = {
		.name = "AHD20_SD_H1440_PAL",
		.ch                = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x20,
		.tx_shot_addr      = 0x0c,
		.tx_baud 		   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x48, 0x48, 0x48, 0x48, 0x48, 0x48 },
		.tx_line_pos0 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1      = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count     = 0x01,
		.tx_pel_line_pos0  = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x01,
		.tx_mode 		   = 0x06,
		.tx_sync_pos0 	   = { 0x60, 0x60, 0x60, 0x60, 0x60, 0x60 },
		.tx_sync_pos1 	   = { 0x02, 0x02, 0x02, 0x02, 0x02, 0x02 },
		.tx_even           = 0x01,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 30,
		.reset_delay = 30,
	},

	[ AHD20_SD_H960_EX_NT ] = {
		.name = "AHD20_SD_H960_EX_NT",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev      = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x20,
		.tx_shot_addr      = 0x0c,
		.tx_baud 		   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud       = { 0x19, 0x19, 0x19, 0x19, 0x19, 0x19 },
		.tx_line_pos0      = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1      = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count     = 0x01,
		.tx_pel_line_pos0  = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x01,
		.tx_mode 		   = 0x06,
		.tx_sync_pos0 	   = { 0xb0, 0xb0, 0xb0, 0xb0, 0xb0, 0xb0 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x01,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 30,
		.reset_delay = 30,
	},

	[ AHD20_SD_H960_EX_PAL ] = {
		.name = "AHD20_SD_H960_EX_PAL",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x20,
		.tx_shot_addr      = 0x0c,
		.tx_baud 		   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud       = { 0x19, 0x19, 0x19, 0x19, 0x19, 0x19 },
		.tx_line_pos0      = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1      = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count     = 0x01,
		.tx_pel_line_pos0  = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x01,
		.tx_mode 		   = 0x06,
		.tx_sync_pos0 	   = { 0xb0, 0xb0, 0xb0, 0xb0, 0xb0, 0xb0 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x01,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 30,
		.reset_delay = 30,
	},

	[ AHD20_SD_H960_2EX_NT ] = {
		.name = "AHD20_SD_H960_2EX_NT",
		.ch                = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x20,
		.tx_shot_addr      = 0x0c,
		.tx_baud 		   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x50, 0x50, 0x50, 0x50, 0x50, 0x50 },
		.tx_line_pos0 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x01,
		.tx_pel_line_pos0  = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x01,
		.tx_mode 		   = 0x06,
		.tx_sync_pos0 	   = { 0x60, 0x60, 0x60, 0x60, 0x60, 0x60 },
		.tx_sync_pos1      = { 0x02, 0x02, 0x02, 0x02, 0x02, 0x02 },
		.tx_even    	   = 0x01,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 30,
		.reset_delay = 30,
	},

	[ AHD20_SD_H960_2EX_PAL ] = {
		.name = "AHD20_SD_H960_2EX_PAL",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x20,
		.tx_shot_addr      = 0x0c,
		.tx_baud 	       = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x48, 0x48, 0x48, 0x48, 0x48, 0x48 },
		.tx_line_pos0 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x01,
		.tx_pel_line_pos0  = { 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x01,
		.tx_mode 		   = 0x06,
		.tx_sync_pos0 	   = { 0x60, 0x60, 0x60, 0x60, 0x60, 0x60 },
		.tx_sync_pos1 	   = { 0x02, 0x02, 0x02, 0x02, 0x02, 0x02 },
		.tx_even 		   = 0x01,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 30,
		.reset_delay = 30,
	},

	[ AHD20_1080P_60P ] = {
		.name = "AHD20_1080P_60P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x31, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x03,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x08,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0 	   = { 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x70,

		.shot_delay = 25,
		.reset_delay = 25,
	},

	[ AHD20_1080P_50P ] = {
		.name = "AHD20_1080P_50P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 	       = { 0x31, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count     = 0x03,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x08,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0      = { 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x70,

		.shot_delay = 25,
		.reset_delay = 25,
	},

	[ AHD20_1080P_30P ] = {
		.name = "AHD20_1080P_30P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		//.tx_baud 		   = { 0x2D, 0x2D, 0x2D, 0x28, 0x28, 0x28 },
		.tx_baud 		   = { 0x26, 0x26, 0x26, 0x26, 0x26, 0x26 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x03,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x08,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0 	   = { 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0 },
		.tx_sync_pos1 	   = { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x80,

		.shot_delay = 25,
		.reset_delay = 25,
	},

	[ AHD20_1080P_25P ] = {
		.name = "AHD20_1080P_25P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		//.tx_baud 		   = { 0x2D, 0x2D, 0x2D, 0x28, 0x28, 0x28 },
		.tx_baud 		   = { 0x26, 0x26, 0x26, 0x26, 0x26, 0x26 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count     = 0x03,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x08,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0 	   = { 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0 },
		.tx_sync_pos1      = { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x05,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x80,

		.shot_delay = 25,
		.reset_delay = 25,
	},
	[ AHD20_1080P_15P_EX ] = {
		.name = "AHD20_1080P_15P_EX",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		//.tx_baud 		   = { 0x2D, 0x2D, 0x2D, 0x28, 0x28, 0x28 },
		.tx_baud 		   = { 0x26, 0x26, 0x26, 0x26, 0x26, 0x26 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x03,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x08,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0 	   = { 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0 },
		.tx_sync_pos1 	   = { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x80,

		.shot_delay = 25,
		.reset_delay = 25,
	},

	[ AHD20_1080P_12_5P_EX ] = {
		.name = "AHD20_1080P_12_5P_EX",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		//.tx_baud 		   = { 0x2D, 0x2D, 0x2D, 0x28, 0x28, 0x28 },
		.tx_baud 		   = { 0x26, 0x26, 0x26, 0x26, 0x26, 0x26 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count     = 0x03,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x08,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0 	   = { 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0 },
		.tx_sync_pos1      = { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x05,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x80,

		.shot_delay = 25,
		.reset_delay = 25,
	},
	[ AHD20_960P_30P ] = {
		.name = "AHD20_960P_30P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		//.tx_baud 		   = { 0x2D, 0x2D, 0x2D, 0x28, 0x28, 0x28 },
		.tx_baud 		   = { 0x26, 0x26, 0x26, 0x26, 0x26, 0x26 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x03,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x08,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0 	   = { 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0 },
		.tx_sync_pos1 	   = { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x80,

		.shot_delay = 25,
		.reset_delay = 25,
	},

	[ AHD20_960P_25P ] = {
		.name = "AHD20_960P_25P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		//.tx_baud 		   = { 0x2D, 0x2D, 0x2D, 0x28, 0x28, 0x28 },
		.tx_baud 		   = { 0x26, 0x26, 0x26, 0x26, 0x26, 0x26 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count     = 0x03,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x08,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0 	   = { 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0 },
		.tx_sync_pos1      = { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x05,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x80,

		.shot_delay = 25,
		.reset_delay = 25,
	},

	[ AHD20_720P_60P ] = {
		.name = "AHD20_720P_60P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev      = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count     = 0x03,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x03,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0 	   = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 25,
		.reset_delay = 25,
	},

	[ AHD20_720P_50P ] = {
		.name = "AHD20_720P_50P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count     = 0x03,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x03,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0      = { 0x16, 0x16, 0x16, 0x16, 0x16, 0x16 },
		.tx_sync_pos1      = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 25,
		.reset_delay = 25,
	},

	[ AHD20_720P_30P ] = {
		.name = "AHD20_720P_30P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x15, 0x15, 0x15, 0x15, 0x15, 0x15 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count     = 0x03,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x03,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0 	   = { 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x05,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 30,
		.reset_delay = 30,
	},

	[ AHD20_720P_25P ] = {
		.name = "AHD20_720P_25P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x15, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x03,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x03,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0 	   = { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x05,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 30,
		.reset_delay = 30,
	},

	[ AHD20_720P_30P_EX ] = {
		.name = "AHD20_720P_30P_EX",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count     = 0x03,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x07,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0      = { 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1      = { 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 30,
		.reset_delay = 30,
	},

	[ AHD20_720P_25P_EX ] = {
		.name = "AHD20_720P_25P_EX",
		.ch 			   = 0,
		.rx_src 		   = 0x11,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 	       = { 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count     = 0x03,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x07,
		.tx_mode 	       = 0x10,
		.tx_sync_pos0 	   = { 0x35, 0x35, 0x35, 0x35, 0x35, 0x35 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 30,
		.reset_delay = 30,
	},

	[ AHD20_720P_30P_EX_Btype ] = {
		.name = "AHD20_720P_30P_EX_Btype",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 	       = { 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },
		.tx_pel_baud 	   = { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
		.tx_line_pos0 	   = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x03,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x07,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0 	   = { 0xb0, 0xb0, 0xb0, 0xb0, 0xb0, 0xb0 },
		.tx_sync_pos1 	   = { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 30,
		.reset_delay = 30,
	},

	[ AHD20_720P_25P_EX_Btype ] = {
		.name = "AHD20_720P_25P_EX_Btype",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
		.tx_pel_baud 	   = { 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c },
		.tx_line_pos0 	   = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x03,
		.tx_pel_line_pos0  = { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x07,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0 	   = { 0xD2, 0xD2, 0xD2, 0xD2, 0xD2, 0xD2 },
		.tx_sync_pos1 	   = { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 30,
		.reset_delay = 30,
	},

	[ AHD30_4M_30P ] = {
		.name = "AHD30_4M_30P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x07,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x07,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0 	   = { 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x70,

		.shot_delay = 25,
		.reset_delay = 25,
	},

	[ AHD30_4M_25P ] = {
		.name = "AHD30_4M_25P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 	       = { 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x07,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x07,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0      = { 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x70,

		.shot_delay = 25,
		.reset_delay = 25,
	},

	[ AHD30_4M_15P ] = {
		.name = "AHD30_4M_15P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x07,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x07,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0 	   = { 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 	       = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x70,

		.shot_delay = 70,
		.reset_delay = 0,
	},

	[ AHD30_3M_30P ] = {
		.name = "AHD30_3M_30P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x33, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count     = 0x03,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x07,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0 	   = { 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 25,
		.reset_delay = 25,
	},

	[ AHD30_3M_25P ] = {
		.name = "AHD30_3M_25P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x33, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x03,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x07,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0 	   = { 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 25,
		.reset_delay = 25,
	},

	[ AHD30_3M_18P ] = {
		.name = "AHD30_3M_18P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 	       = { 0x33, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count     = 0x03,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x07,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0 	   = { 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x60,

		.shot_delay = 55,
		.reset_delay = 0,
	},

	[ AHD30_5M_12_5P ] = {
		.name = "AHD30_5M_12_5P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev      = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x07,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x07,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0 	   = { 0x80, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x70,

		.shot_delay = 90,
		.reset_delay = 0,
	},

	[ AHD30_5M_20P ] = {
		.name = "AHD30_5M_20P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x07,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x07,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0 	   = { 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x70,

		.shot_delay = 55,
		.reset_delay = 0,
	},

	[ AHD30_5_3M_20P ] = {
		.name = "AHD30_5_3M_20P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x38, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x07,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x07,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0 	   = { 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 	       = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x70,

		.shot_delay = 55,
		.reset_delay = 0,
	},

	[ AHD30_8M_X_30P ] = {
		.name = "AHD30_8M_X_30P",
		.ch 			   = 0,
		.rx_src 		   = 0x11,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0      = { 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count     = 0x07,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x07,
		.tx_mode 	       = 0x10,
		.tx_sync_pos0 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x70,

		.shot_delay = 90,
		.reset_delay = 0,
	},

	[ AHD30_8M_X_25P ] = {
		.name = "AHD30_8M_X_25P",
		.ch                = 0,
		.rx_src 		   = 0x11,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x07,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x07,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x70,

		.shot_delay = 90,
		.reset_delay = 0,
	},

	[ AHD30_8M_7_5P ] = {
		.name = "AHD30_8M_7_5P",
		.ch 			   = 0,
		.rx_src 		   = 0x11,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 	       = { 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x07,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x07,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0      = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x70,

		.shot_delay = 90,
		.reset_delay = 0,
	},

	[ AHD30_8M_12_5P ] = {
		.name = "AHD30_8M_12_5P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev      = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1      = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x07,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x07,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0 	   = { 0x60, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x70,

		.shot_delay = 90,
		.reset_delay = 0,
	},

	[ AHD30_8M_15P ] = {
		.name = "AHD30_8M_15P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev      = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00 },  //0x34
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x07,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x07,
		.tx_mode 		   = 0x10,
		.tx_sync_pos0 	   = { 0x60, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 	       = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x81,
		.rx_manual_duty    = 0x2D,
		.rx_head_matching  = 0x55,
		.rx_data_rz        = 0x00,
		.rx_sz             = 0x70,

		.shot_delay = 70,
		.reset_delay = 25,
	},

	[ TVI_FHD_30P ] = {
		.name = "TVI_FHD_30P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x34, 0x34, 0x34, 0x34, 0x34, 0x34 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0B, 0x00, 0x00, 0x00, 0x00, 0x0A },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x01,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x02,
		.tx_mode 		   = 0x08,
		.tx_sync_pos0 	   = { 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x20 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x3E,
		.rx_head_matching  = 0xAD,
		.rx_data_rz        = 0x0F,
		.rx_sz             = 0x60,

		.shot_delay = 30,
		.reset_delay = 30,
	},

	[ TVI_FHD_25P ] = {
		.name = "TVI_FHD_25P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x34, 0x34, 0x34, 0x34, 0x34, 0x34 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0	   = { 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x01,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x02,
		.tx_mode 		   = 0x08,
		.tx_sync_pos0 	   = { 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x3E,
		.rx_head_matching  = 0xAD,
		.rx_data_rz        = 0x0F,
		.rx_sz             = 0x60,

		.shot_delay = 40,
		.reset_delay = 40,
	},

	[ TVI_HD_60P ] = {
		.name = "TVI_HD_60P",
		.ch  			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x34, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x01,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x02,
		.tx_mode 	       = 0x08,
		.tx_sync_pos0 	   = { 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x3E,
		.rx_head_matching  = 0xAD,
		.rx_data_rz        = 0x8F,
		.rx_sz             = 0x60,

		.shot_delay = 20,
		.reset_delay = 20,
	},

	[ TVI_HD_50P ] = {
		.name = "TVI_HD_50P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x34, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x01,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x02,
		.tx_mode 		   = 0x08,
		.tx_sync_pos0 	   = { 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x3E,
		.rx_head_matching  = 0xAD,
		.rx_data_rz        = 0x8F,
		.rx_sz             = 0x60,

		.shot_delay = 20,
		.reset_delay = 20,
	},

	[ TVI_HD_30P ] = {
		.name = "TVI_HD_30P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x34, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x01,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x02,
		.tx_mode 		   = 0x08,
		.tx_sync_pos0 	   = { 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 	       = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x3E,
		.rx_head_matching  = 0xAD,
		.rx_data_rz        = 0x8F,
		.rx_sz             = 0x60,

		.shot_delay = 25,
		.reset_delay = 25,
	},

	[ TVI_HD_25P ] = {
		.name = "TVI_HD_25P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x34, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x01,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x02,
		.tx_mode 	       = 0x08,
		.tx_sync_pos0 	   = { 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x3E,
		.rx_head_matching  = 0xAD,
		.rx_data_rz        = 0x8F,
		.rx_sz             = 0x60,

		.shot_delay = 25,
		.reset_delay = 25,
	},

	[ TVI_HD_30P_EX ] = {
		.name = "TVI_HD_30P_EX",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 	       = { 0x34, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x01,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x02,
		.tx_mode 		   = 0x08,
		.tx_sync_pos0 	   = { 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even           = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x3E,
		.rx_head_matching  = 0xAD,
		.rx_data_rz        = 0x8F,
		.rx_sz             = 0x60,

		.shot_delay = 25,
		.reset_delay = 25,
	},

	[ TVI_HD_25P_EX ] = {
		.name = "TVI_HD_25P_EX",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 	       = { 0x34, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x01,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x02,
		.tx_mode 		   = 0x08,
		.tx_sync_pos0 	   = { 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x3E,
		.rx_head_matching  = 0xAD,
		.rx_data_rz        = 0x8F,
		.rx_sz             = 0x60,

		.shot_delay = 25,
		.reset_delay = 25,
	},

	[ TVI_HD_B_30P ] = {
		.name = "TVI_HD_B_30P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x34, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x01,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x02,
		.tx_mode 		   = 0x08,
		.tx_sync_pos0 	   = { 0x52, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x3E,
		.rx_head_matching  = 0xAD,
		.rx_data_rz        = 0x8F,
		.rx_sz             = 0x60,

		.shot_delay = 40,
		.reset_delay = 40,
	},

	[ TVI_HD_B_25P ] = {
		.name = "TVI_HD_B_25P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 	 	   = { 0x34, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x01,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x02,
		.tx_mode 		   = 0x08,
		.tx_sync_pos0 	   = { 0x52, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x3E,
		.rx_head_matching  = 0xAD,
		.rx_data_rz        = 0x8F,
		.rx_sz             = 0x60,

		.shot_delay = 25,
		.reset_delay = 25,
	},

	[ TVI_HD_B_30P_EX ] = {
		.name = "TVI_HD_B_30P_EX",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x34, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x01,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x02,
		.tx_mode 		   = 0x08,
		.tx_sync_pos0 	   = { 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x3E,
		.rx_head_matching  = 0xAD,
		.rx_data_rz        = 0x8F,
		.rx_sz             = 0x60,

		.shot_delay = 35,
		.reset_delay = 35,
	},

	[ TVI_HD_B_25P_EX ] = {
		.name = "TVI_HD_B_25P_EX",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x34, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x01,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x02,
		.tx_mode 		   = 0x08,
		.tx_sync_pos0 	   = { 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 	  	   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x3E,
		.rx_head_matching  = 0xAD,
		.rx_data_rz        = 0x8F,
		.rx_sz             = 0x60,

		.shot_delay = 40,
		.reset_delay = 40,
	},

	[ TVI_3M_18P ] = {
		.name = "TVI_3M_18P",
		.ch 			   = 0,
		.rx_src 	       = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x34, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count     = 0x01,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x02,
		.tx_mode 		   = 0x08,
		.tx_sync_pos0 	   = { 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x3E,
		.rx_head_matching  = 0xAD,
		.rx_data_rz        = 0x8F,
		.rx_sz             = 0x60,

		.shot_delay = 55,
		.reset_delay = 55,
	},

	[ TVI_5M_12_5P ] = {
		.name = "TVI_5M_12_5P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x34, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x01,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x02,
		.tx_mode 		   = 0x08,
		.tx_sync_pos0 	   = { 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x3E,
		.rx_head_matching  = 0xAD,
		.rx_data_rz        = 0x8F,
		.rx_sz             = 0x60,

		.shot_delay = 80,
		.reset_delay = 80,
	},

	[ TVI_5M_20P ] = {
		.name = "TVI_5M_20P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x34, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x01,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x02,
		.tx_mode 		   = 0x08,
		.tx_sync_pos0 	   = { 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x3E,
		.rx_head_matching  = 0xAD,
		.rx_data_rz        = 0x8F,
		.rx_sz             = 0x60,

		.shot_delay = 80,
		.reset_delay = 80,
	},

	[ TVI_4M_30P ] = {
		.name = "TVI_4M_30P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x34, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x01,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x02,
		.tx_mode 		   = 0x08,
		.tx_sync_pos0 	   = { 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x3E,
		.rx_head_matching  = 0xAD,
		.rx_data_rz        = 0x8F,
		.rx_sz             = 0x60,

		.shot_delay = 30,
		.reset_delay = 30,
	},

	[ TVI_4M_25P ] = {
		.name = "TVI_4M_25P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x34, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x01,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x02,
		.tx_mode 		   = 0x08,
		.tx_sync_pos0 	   = { 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x3E,
		.rx_head_matching  = 0xAD,
		.rx_data_rz        = 0x8F,
		.rx_sz             = 0x60,

		.shot_delay = 30,
		.reset_delay = 30,
	},

	[ TVI_4M_15P ] = {
		.name = "TVI_4M_15P",
		.ch 			   = 0,
		.rx_src 	       = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x34, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count     = 0x01,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x02,
		.tx_mode 		   = 0x08,
		.tx_sync_pos0 	   = { 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x3E,
		.rx_head_matching  = 0xAD,
		.rx_data_rz        = 0x8F,
		.rx_sz             = 0x60,

		.shot_delay = 55,
		.reset_delay = 55,
	},
	[ TVI_8M_15P ] = {
		.name = "TVI_8M_15P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x34, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x01,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x02,
		.tx_mode 		   = 0x08,
		.tx_sync_pos0 	   = { 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x3E,
		.rx_head_matching  = 0xAD,
		.rx_data_rz        = 0x8F,
		.rx_sz             = 0x60,

		.shot_delay = 30,
		.reset_delay = 30,
	},
	[ TVI_8M_12_5P ] = {
		.name = "TVI_8M_12_5P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x03,
		.tx_cmd_addr       = 0x10,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x34, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x01,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x02,
		.tx_mode 		   = 0x08,
		.tx_sync_pos0 	   = { 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x06,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x3E,
		.rx_head_matching  = 0xAD,
		.rx_data_rz        = 0x8F,
		.rx_sz             = 0x60,

		.shot_delay = 30,
		.reset_delay = 30,
	},
	[ CVI_HD_60P ] = {
		.name = "CVI_HD_60P",
		.ch = 0,
		.rx_src 		   = 0x01,   // 1
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x0C,
		.tx_cmd_addr       = 0x00,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x16, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x05,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x0c,
		.tx_mode 		   = 0x60,
		.tx_sync_pos0 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1	   = { 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x05,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x64,
		.rx_head_matching  = 0xAB,
		.rx_data_rz        = 0x8D,
		.rx_sz             = 0x60,

		.shot_delay = 20,
		.reset_delay = 20,
	},

	[ CVI_HD_50P ] = {
		.name = "CVI_HD_50P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x0C,
		.tx_cmd_addr       = 0x00,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x16, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x05,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x0c,
		.tx_mode 		   = 0x60,
		.tx_sync_pos0 	   ={  0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x05,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x64,
		.rx_head_matching  = 0xAB,
		.rx_data_rz        = 0x8D,
		.rx_sz             = 0x60,

		.shot_delay = 20,
		.reset_delay = 20,
	},

	[ CVI_HD_30P ] = {
		.name = "CVI_HD_30P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x0C,
		.tx_cmd_addr       = 0x00,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x05,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x0c,
		.tx_mode 		   = 0x60,
		.tx_sync_pos0 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x05,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x32,
		.rx_head_matching  = 0xAB,
		.rx_data_rz        = 0x8D,
		.rx_sz             = 0x60,

		.shot_delay = 35,
		.reset_delay = 35,
	},

	[ CVI_HD_25P ] = {
		.name = "CVI_HD_25P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x0C,
		.tx_cmd_addr       = 0x00,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x05,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x0c,
		.tx_mode 		   = 0x60,
		.tx_sync_pos0 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x05,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x32,
		.rx_head_matching  = 0xAB,
		.rx_data_rz        = 0x8D,
		.rx_sz             = 0x60,

		.shot_delay = 40,
		.reset_delay = 40,
	},

	[ CVI_HD_30P_EX ] = {
		.name = "CVI_HD_30P_EX",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x0C,
		.tx_cmd_addr       = 0x00,
		.tx_shot_addr      = 0x09,
		.tx_baud 	       = { 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x05,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x0c,
		.tx_mode 		   = 0x60,
		.tx_sync_pos0 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x05,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x32,
		.rx_head_matching  = 0xAB,
		.rx_data_rz        = 0x8D,
		.rx_sz             = 0x60,

		.shot_delay = 35,
		.reset_delay = 33,
	},

	[ CVI_HD_25P_EX ] = {
		.name = "CVI_HD_25P_EX",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev  	   = 0x80,
		.tx_bank           = 0x0C,
		.tx_cmd_addr       = 0x00,
		.tx_shot_addr      = 0x09,
		.tx_baud 	 	   = { 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x05,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x0c,
		.tx_mode 		   = 0x60,
		.tx_sync_pos0 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x05,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x32,
		.rx_head_matching  = 0xAB,
		.rx_data_rz        = 0x8D,
		.rx_sz             = 0x60,

		.shot_delay = 25,
		.reset_delay = 25,
	},

	[ CVI_FHD_30P ] = {
		.name = "CVI_FHD_30P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x0C,
		.tx_cmd_addr       = 0x00,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x16, 0x16, 0x16, 0x16, 0x16, 0x16 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x05,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x0c,
		.tx_mode 		   = 0x60,
		.tx_sync_pos0 	   = { 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },
		.tx_sync_pos1 	   = { 0x06, 0x06, 0x06, 0x06, 0x06, 0x06 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x05,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x64,
		.rx_head_matching  = 0xAB,
		.rx_data_rz        = 0x8D,
		.rx_sz             = 0x60,

		.shot_delay = 35,
		.reset_delay = 35,
	},

	[ CVI_FHD_25P ] = {
		.name = "CVI_FHD_25P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x0C,
		.tx_cmd_addr       = 0x00,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x16, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x05,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x0c,
		.tx_mode 		   = 0x60,
		.tx_sync_pos0 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x00,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x05,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x64,
		.rx_head_matching  = 0xAB,
		.rx_data_rz        = 0x8D,
		.rx_sz             = 0x60,

		.shot_delay = 40,
		.reset_delay = 40,
	},

	[ CVI_4M_25P ] = {
		.name = "CVI_4M_25P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x0C,
		.tx_cmd_addr       = 0x00,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x16, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x0f,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x01,
		.tx_mode 		   = 0x60,
		.tx_sync_pos0 	   = { 0xdf, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x10,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x05,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x64,
		.rx_head_matching  = 0xAB,
		.rx_data_rz        = 0x85,
		.rx_sz             = 0x60,

		.shot_delay = 25,
		.reset_delay = 25,
	},

	[ CVI_4M_30P ] = {
		.name = "CVI_4M_30P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x0C,
		.tx_cmd_addr       = 0x00,
		.tx_shot_addr      = 0x09,
		.tx_baud 	  	   = { 0x2b, 0x00, 0x00, 0x2b, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x16, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x0f,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x1e,
		.tx_mode 		   = 0x60,
		.tx_sync_pos0 	   = { 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x10,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x05,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x64,
		.rx_head_matching  = 0xAB,
		.rx_data_rz        = 0x85,
		.rx_sz             = 0x60,

		.shot_delay = 25,
		.reset_delay = 25,
	},

	[ CVI_5M_20P ] = {
		.name = "CVI_5M_20P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x0C,
		.tx_cmd_addr       = 0x00,
		.tx_shot_addr      = 0x09,
		.tx_baud 	  	   = { 0x16, 0x00, 0x00, 0x2b, 0x00, 0x00 },
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x05,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x0c,
		.tx_mode 		   = 0x60,
		.tx_sync_pos0 	   = { 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x10,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x05,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x64,
		.rx_head_matching  = 0xAB,
		.rx_data_rz        = 0x85,
		.rx_sz             = 0x60,

		.shot_delay = 25,
		.reset_delay = 25,
	},

	[ CVI_8M_15P ] = {
		.name = "CVI_8M_15P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x0C,
		.tx_cmd_addr       = 0x00,
		.tx_shot_addr      = 0x09,
		.tx_baud 		   = { 0x36, 0x00, 0x00, 0x00, 0x00, 0x00 },  //[0x35->0x37]
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0 	   = { 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count 	   = 0x0f,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x01,
		.tx_mode 		   = 0x60,
		.tx_sync_pos0 	   = { 0x90, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1 	   = { 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x10,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x05,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x58,  //[0x54~0x5D]
		.rx_head_matching  = 0xAB,
		.rx_data_rz        = 0x85,
		.rx_sz             = 0x60,

		.shot_delay = 25,
		.reset_delay = 25,
	},

	[ CVI_8M_12_5P ] = {
		.name = "CVI_8M_12_5P",
		.ch 			   = 0,
		.rx_src 		   = 0x01,
		.rx_slice_lev 	   = 0x80,
		.tx_bank           = 0x0C,
		.tx_cmd_addr       = 0x00,
		.tx_shot_addr      = 0x09,
		.tx_baud 	   	   = { 0x36, 0x00, 0x00, 0x00, 0x00, 0x00 },  //[0x35->0x39]
		.tx_pel_baud 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos0      = { 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_pos1 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count     = 0x0f,
		.tx_pel_line_pos0  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_pel_line_pos1  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_line_count_max = 0x1e,
		.tx_mode 		   = 0x60,
		.tx_sync_pos0      = { 0x90, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_sync_pos1      = { 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 },
		.tx_even 		   = 0x00,
		.tx_zero_length    = 0x10,

		.rx_comm_on        = 0x01,
		.rx_area           = 0x05,
		.rx_signal_enhance = 0x01,
		.rx_manual_duty    = 0x61,  //[0x5E~0x64]
		.rx_head_matching  = 0xAB,
		.rx_data_rz        = 0x85,
		.rx_sz             = 0x60,

		.shot_delay = 25,
		.reset_delay = 25,
	},
};


NC_VD_ACP_CMDDEF_STR nvp6158_coax_cmd_lists[]=
{
	[ COAX_CMD_IRIS_INC ] = {
			.name 		= "COAX_CMD_IRIS_INC",
			.ahd_16bit    	= { 0x40, 0x00, 0x00, 0x00, EOD },
			.ahd_8bit     	= { 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, EOD },
			.ahd_4_5m     = { 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, EOD },
			.cvi_cmd      	= { 0xa5, 0x80, 0x0A, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, EOD },
			.cvi_new_cmd = { 0xa5, 0x80, 0x0A, 0x00, 0x00,  0x00, 0x6f, 0xff, 0xff, 0xff, EOD },
			.cvi_checksum	= { 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, EOD },
			.tvi_v1_0     	= { 0xb5, 0x00, 0x0f, 0x00, 0x80, 0x00, 0x00, 0x00, 0xc4, 0x80, EOD },
			.tvi_v2_0     	= { 0xb5, 0x01, 0x0f, 0x00, 0x80, 0x00, 0x00, 0x00, 0xc5, 0x80, EOD },
			.sd           	= { 0x40, 0x00, 0x00, 0x00, EOD },
			.autostop  = 0,
	},

	[ COAX_CMD_IRIS_DEC ] = {
			.name         	= "COAX_CMD_IRIS_DEC",
			.ahd_16bit    	= { 0x20, 0x00, 0x00, 0x00, EOD },
			.ahd_8bit     	= { 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, EOD },
			.ahd_4_5m     = { 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, EOD },
			.cvi_cmd      	= { 0xa5, 0x80, 0x06, 0x00, 0x00, 0x00, 0x60, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, EOD },
			.cvi_new_cmd = { 0xa5, 0x80, 0x06, 0x00, 0x00,  0x00, 0x60, 0xff, 0xff, 0xff, EOD },
			.cvi_checksum	= { 0x60, 0xff, 0xff, 0xff, 0xff, 0xff, EOD },
			.tvi_v1_0     	= { 0xb5, 0x00, 0x0e, 0x00, 0x80, 0x00, 0x00, 0x00, 0xc3, 0x80, EOD },
			.tvi_v2_0     	= { 0xb5, 0x01, 0x0e, 0x00, 0x80, 0x00, 0x00, 0x00, 0xc4, 0x80, EOD },
			.sd           	= { 0x20, 0x00, 0x00, 0x00, EOD },
			.autostop  = 0,
	},

	[ COAX_CMD_FOCUS_INC ] = {
			.name         	= "COAX_CMD_FOCUS_INC",
			.ahd_16bit    	= { 0x80, 0x00, 0x00, 0x00, EOD },
			.ahd_8bit     	= { 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, EOD },
			.ahd_4_5m     = { 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, EOD },
			.cvi_cmd      	= { 0xa5, 0x80, 0x22, 0x00, 0x0A, 0x00, 0x5C, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, EOD },
			.cvi_new_cmd = { 0xa5, 0x80, 0x22, 0x00, 0x0A, 0x00, 0x5C, 0xff, 0xff, 0xff, EOD },
			.cvi_checksum	= { 0x77, 0xff, 0xff, 0xff, 0xff, 0xff, EOD },
			.tvi_v1_0 	= { 0xb5, 0x00, 0x11, 0x00, 0x80, 0x00, 0x00, 0x00, 0xc6, 0x80, EOD },
			.tvi_v2_0     	= { 0xb5, 0x01, 0x11, 0x00, 0x80, 0x00, 0x00, 0x00, 0xc7, 0x80, EOD },
			.sd           	= { 0x80, 0x00, 0x00, 0x00, EOD },
			.autostop  = 0,
	},

	[ COAX_CMD_FOCUS_DEC ] = {
			.name 		= "COAX_CMD_FOCUS_DEC",
			.ahd_16bit   	= { 0x00, 0x01, 0x01, 0x00, EOD },
			.ahd_8bit     	= { 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, EOD },
			.ahd_4_5m 	= { 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, EOD },
			.cvi_cmd      	= { 0xa5, 0x80, 0x12, 0x00, 0x0A, 0x00, 0x7C, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, EOD },
			.cvi_new_cmd = { 0xa5, 0x80, 0x12, 0x00, 0x0A, 0x00, 0x7C, 0xff, 0xff, 0xff, EOD },
			.cvi_checksum	= { 0x57, 0xff, 0xff, 0xff, 0xff, 0xff, EOD },
			.tvi_v1_0     	= { 0xb5, 0x00, 0x10, 0x00, 0x80, 0x00, 0x00, 0x00, 0xc5, 0x80, EOD },
			.tvi_v2_0     	= { 0xb5, 0x01, 0x10, 0x00, 0x80, 0x00, 0x00, 0x00, 0xc6, 0x80, EOD },
			.sd  		  	= { 0x00, 0x01, 0x00, 0x00, EOD },
			.autostop  = 0,
	},

	[ COAX_CMD_ZOOM_INC ] = {
			.name 		= "COAX_CMD_ZOOM_INC",
			.ahd_16bit    	= { 0x00, 0x02, 0x02, 0x00, EOD },
			.ahd_8bit 	= { 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, EOD },
			.ahd_4_5m     = { 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, EOD },
			.cvi_cmd      	= { 0xa5, 0x80, 0x82, 0x00, 0x00, 0x00, 0xE7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, EOD },
			.cvi_new_cmd = { 0xa5, 0x80, 0x82, 0x00, 0x00, 0x00, 0xE7, 0xff, 0xff, 0xff, EOD },
			.cvi_checksum	= { 0x17, 0xff, 0xff, 0xff, 0xff, 0xff, EOD },
			.tvi_v1_0 	= { 0xb5, 0x00, 0x13, 0x00, 0x80, 0x00, 0x00, 0x00, 0xc8, 0x80, EOD },
			.tvi_v2_0     	= { 0xb5, 0x01, 0x13, 0x00, 0x80, 0x00, 0x00, 0x00, 0xc9, 0x80, EOD },
			.sd  		  	= { 0x00, 0x02, 0x00, 0x00, EOD },
			.autostop  = 0,
	},

	[ COAX_CMD_ZOOM_DEC ] = {
			.name 		= "COAX_CMD_ZOOM_DEC",
			.ahd_16bit    	= { 0x00, 0x04, 0x04, 0x00, EOD },
			.ahd_8bit 	= { 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, EOD },
			.ahd_4_5m 	= { 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, EOD },
			.cvi_cmd      	= { 0xa5, 0x80, 0x42, 0x00, 0x00, 0x00, 0x17, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, EOD },
			.cvi_new_cmd = { 0xa5, 0x80, 0x42, 0x00, 0x00, 0x00, 0x17, 0xff, 0xff, 0xff, EOD },
			.cvi_checksum	= { 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, EOD },
			.tvi_v1_0 	= { 0xb5, 0x00, 0x12, 0x00, 0x80, 0x00, 0x00, 0x00, 0xc7, 0x80, EOD },
			.tvi_v2_0     	= { 0xb5, 0x01, 0x12, 0x00, 0x80, 0x00, 0x00, 0x00, 0xc8, 0x80, EOD },
			.sd  		  	= { 0x00, 0x04, 0x00, 0x00, EOD },
			.autostop  = 0,
	},

	[ COAX_CMD_OSD_ON ] = {
			.name 		= "COAX_CMD_OSD_ON",
			.ahd_16bit    	= { 0x00, 0xc0, 0xc0, 0xfa, EOD },
			.ahd_8bit 	= { 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x5F, EOD },
			.ahd_4_5m 	= { 0x00, 0x03, 0x00, 0x5F, 0x00, 0x00, 0x00, 0x00, EOD },
			.cvi_cmd      	= { 0xa5, 0x80, 0x91, 0x80, 0x00, 0x00, 0x0C, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, EOD },
			.cvi_new_cmd = { 0xa5, 0x80, 0x91, 0x10, 0x00, 0x00, 0xEC, 0xff, 0xff, 0xff, EOD },
			.cvi_checksum	= { 0x0C, 0xff, 0xff, 0xff, 0xff, 0xff, EOD },
			.tvi_v1_0 	= { 0xb5, 0x00, 0x0f, 0x00, 0x80, 0x00, 0x00, 0x00, 0xc4, 0x80, EOD },
			.tvi_v2_0     	= { 0xb5, 0x01, 0x0f, 0x00, 0x80, 0x00, 0x00, 0x00, 0xc5, 0x80, EOD },
			.sd  		  	= { 0x00, 0xC0, 0x00, 0xFA, EOD },
			.autostop  = 1,
	},

	[ COAX_CMD_PTZ_UP ] = {
			.name 		= "COAX_CMD_PTZ_UP",
			.ahd_16bit    	= { 0x00, 0x10, 0x10, 0x4c, EOD },
			.ahd_8bit 	= { 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, EOD },
			.ahd_4_5m 	= { 0x00, 0x08, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00, EOD },
			.cvi_cmd      	= { 0xa5, 0x80, 0x10, 0x00, 0xf9, 0x00, 0xb2, 0xff, 0xff, 0xff, 0xff, 0xff,  0xff, 0xff, 0xff, 0xff, EOD },
			.cvi_new_cmd = { 0xa5, 0x80, 0x91, 0x20, 0x00, 0x00, 0xCC, 0xff, 0xff, 0xff, EOD },
			.cvi_checksum	= { 0xb2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, EOD },
			.tvi_v1_0 	= { 0xb5, 0x00, 0x06, 0x24, 0x80, 0x00, 0x00, 0x00, 0xdf, 0x80, EOD },
			.tvi_v2_0     	= { 0xb5, 0x01, 0x06, 0xff, 0x80, 0x00, 0x00, 0x00, 0xbb, 0x80, EOD },
			.sd  		  	= { 0x00, 0x10, 0x00, 0x00, EOD },
			.autostop  = 0,
	},

	[ COAX_CMD_PTZ_DOWN ] = {
			.name 		= "COAX_CMD_PTZ_DOWN",
			.ahd_16bit    	= { 0x00, 0x08, 0x08, 0x4c, EOD },
			.ahd_8bit 	= { 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x32, EOD },
			.ahd_4_5m 	= { 0x00, 0x10, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00, EOD },
			.cvi_cmd      	= { 0xa5, 0x80, 0x20, 0x00, 0xf9, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff,  0xff, 0xff, 0xff, 0xff, EOD },
			.cvi_new_cmd = { 0xa5, 0x80, 0x91, 0xA0, 0x00,  0x00, 0x2C, 0xff, 0xff, 0xff, EOD },
			.cvi_checksum	= { 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, EOD },
			.tvi_v1_0 	= { 0xb5, 0x00, 0x07, 0x24, 0x80, 0x00, 0x00, 0x00, 0xe0, 0x80, EOD },
			.tvi_v2_0     	= { 0xb5, 0x01, 0x07, 0xff, 0x80, 0x00, 0x00, 0x00, 0xbc, 0x80, EOD },
			.sd  		  	= { 0x00, 0x08, 0x00, 0x00, EOD },
			.autostop  = 0,
	},

	[ COAX_CMD_PTZ_LEFT ] = {
			.name 		= "COAX_CMD_PTZ_LEFT",
			.ahd_16bit	= { 0x00, 0x20, 0x20, 0x00, EOD },
			.ahd_8bit 	= { 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x32, 0x00, EOD },
			.ahd_4_5m 	= { 0x00, 0x04, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, EOD },
			.cvi_cmd      	= { 0xa5, 0x80, 0x40, 0xf9, 0x00, 0x00, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff,  0xff, 0xff, 0xff, 0xff, EOD },
			.cvi_new_cmd = { 0xa5, 0x80, 0x91, 0x60, 0x00, 0x00, 0xAC, 0xff, 0xff, 0xff, EOD },
			.cvi_checksum	= { 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, EOD },
			.tvi_v1_0 	= { 0xb5, 0x00, 0x09, 0x00, 0x80, 0x24, 0x00, 0x00, 0xe2, 0x80, EOD },
			.tvi_v2_0     	= { 0xb5, 0x01, 0x09, 0x00, 0x80, 0xff, 0x00, 0x00, 0xbe, 0x80, EOD },
			.sd  		  	= { 0x00, 0x20, 0x4C, 0x00, EOD },
			.autostop  = 0,
	},

	[ COAX_CMD_PTZ_RIGHT ] = {
			.name 		= "COAX_CMD_PTZ_RIGHT",
			.ahd_16bit    	= { 0x00, 0x40, 0x40, 0x00, EOD },
			.ahd_8bit 	= { 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x32, 0x00, EOD },
			.ahd_4_5m 	= { 0x00, 0x02, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, EOD },
			.cvi_cmd      	= { 0xa5, 0x80, 0x80, 0xf9, 0x00, 0x00, 0x62, 0xff, 0xff, 0xff, 0xff, 0xff,  0xff, 0xff, 0xff, 0xff, EOD },
			.cvi_new_cmd = { 0xa5, 0x80, 0x91, 0xE0, 0x00,  0x00, 0x6C, 0xff, 0xff, 0xff, EOD },
			.cvi_checksum	= { 0x62, 0xff, 0xff, 0xff, 0xff, 0xff, EOD },
			.tvi_v1_0 	= { 0xb5, 0x00, 0x08, 0x00, 0x80, 0x24, 0x00, 0x00, 0xe1, 0x80, EOD },
			.tvi_v2_0     	= { 0xb5, 0x01, 0x08, 0x00, 0x80, 0xff, 0x00, 0x00, 0xbd, 0x80, EOD },
			.sd  		  	= { 0x00, 0x40, 0x4C, 0x00, EOD },
			.autostop  = 0,
	},

	[ COAX_CMD_OSD_ENTER ] = {
			.name 		= "COAX_CMD_OSD_ENTER",
			.ahd_16bit    	= { 0x40, 0x00, 0x00, 0x00, EOD },
			.ahd_8bit 	= { 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, EOD },
			.ahd_4_5m 	= { 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, EOD },
			.cvi_cmd      	= { 0xa5, 0x80, 0x91, 0x10, 0x00, 0x00, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff,  0xff, 0xff, 0xff, 0xff, EOD },
			.cvi_new_cmd = { 0xa5, 0x80, 0x91, 0x10, 0x00,  0x00, 0xEC, 0xff, 0xff, 0xff, EOD },
			.cvi_checksum	= { 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, EOD },
			.tvi_v1_0 	= { 0xb5, 0x00, 0x17, 0x5f, 0x80, 0x00, 0x00, 0x00, 0x2b, 0x80, EOD },
			.tvi_v2_0     	= { 0xb5, 0x01, 0x17, 0x5f, 0x80, 0x00, 0x00, 0x00, 0x2c, 0x80, EOD },
			.sd  		  	= { 0x40, 0x00, 0x00, 0x00, EOD },
			.autostop  = 1,
	},

	[ COAX_CMD_SPECIAL_FW ] = {
			.name 		= "COAX_CMD_SPECIAL_FW",
			.ahd_16bit    	= { 0xAA, 0xAB, 0xAA, 0xAB, EOD },
			.ahd_8bit 	= { 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, EOD },
			.ahd_4_5m 	= { 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, EOD },
			.cvi_cmd      	= { 0xa5, 0x80, 0xAA, 0xAB, 0xAC, 0x00, 0x0A, 0xff, 0xff, 0xff, 0xff, 0xff,  0xff, 0xff, 0xff, 0xff, EOD },
			.cvi_new_cmd = { 0xa5, 0x80, 0xAA, 0xAB, 0xAC,  0x00, 0x0A, 0xff, 0xff, 0xff, EOD },
			.cvi_checksum	= { 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, EOD },
			.tvi_v1_0 	   = { 0xb5, 0xAA, 0xAB, 0xAC, 0x80, 0x00, 0x00, 0x00, 0xD5, 0x80, EOD },
			.tvi_v2_0     	= { 0xb5, 0xAA, 0xAB, 0xAC, 0x80, 0x00, 0x00, 0x00, 0xD5, 0x80, EOD },
			.sd  		  	= { 0xAA, 0xAB, 0xAA, 0xAB, EOD },
			.autostop  = 1,
	},

	[ COAX_CMD_SPECIAL_CAMEQ ] = {
			.name 		  = "COAX_CMD_SPECIAL_CAMEQ",
			.ahd_16bit    = { 0x00, 0x00, 0x00, 0x00, EOD },
			.ahd_8bit 	  = { 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, EOD },
			.ahd_4_5m 	  = { 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, EOD },
			.cvi_cmd      = { 0x00, 0x03, 0x40, EOD },
			.cvi_new_cmd  = { 0xa5, 0x80, 0x0A, 0x00, 0x00,  0x00, 0x6f, 0xff, 0xff, 0xff, EOD },
			.cvi_checksum = { 0x81, 0x92, 0xc1, 0xff, 0xc1, 0xff, 0xc1, 0xff, 0xc1, 0xff, 0xc1, 0xff, EOD },
			.tvi_v1_0 	  = { 0x00, EOD },
			.tvi_v2_0     = { 0x00, EOD },
			.sd  		  = { 0x00, EOD },
			.autostop  = 1,
	},

	[ COAX_CMD_SPECIAL_FPS ] = {
			.name 		  = "COAX_CMD_SPECIAL_FPS",
			.ahd_16bit    = { 0x00, 0x00, 0x00, 0x00, EOD },
			.ahd_8bit 	  = { 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, EOD },
			.ahd_4_5m 	  = { 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, EOD },
			.cvi_cmd      = { 0x00, 0x03, 0x40, EOD},
			.cvi_new_cmd  = { 0xa5, 0x80, 0x0A, 0x00, 0x00,  0x00, 0x6f, 0xff, 0xff, 0xff, EOD },
			.cvi_checksum = { 0x81, 0x92, 0xc1, 0xff, 0xc1, 0xff, 0xc1, 0xff, 0xc1, 0xff, 0xc1, 0xff, EOD },
			.tvi_v1_0 	  = { 0x00, EOD },
			.tvi_v2_0     = { 0x00, EOD },
			.sd  		  = { 0x00, EOD },
			.autostop  = 1,
	},

	[ COAX_CMD_SPECIAL_MOTION ] = {
			.name 		  = "COAX_CMD_SPECIAL_MOTION",
			.ahd_16bit    = { 0x00, 0x00, 0x00, 0x00, EOD },
			.ahd_8bit     = { 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, EOD },
			.ahd_4_5m 	  = { 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, EOD },
			.cvi_cmd 	  = { 0x00, 0x03, 0x40, EOD },
			.cvi_new_cmd  = { 0xa5, 0x80, 0x0A, 0x00, 0x00,  0x00, 0x6f, 0xff, 0xff, 0xff, EOD },
			.cvi_checksum = { 0x81, 0x92, 0xc1, 0xff, 0xc1, 0xff, 0xc1, 0xff, 0xc1, 0xff, 0xc1, 0xff, EOD },
			.tvi_v1_0 	  = { 0x00, EOD },
			.tvi_v2_0     = { 0x00, EOD },
			.sd  		  = { 0x00, EOD },
			.autostop  = 1,
	},

	[ COAX_CMD_SPECIAL_3DNR_REQUEST ] = {
			.name 		  = "COAX_CMD_SPECIAL_3DNR_REQUEST",
			.ahd_16bit    = { 0x00, EOD },
			.ahd_8bit     = { 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, EOD },
			.ahd_4_5m 	  = { 0x60, 0xB0, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,  0x60, 0xB0, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, EOD },

			.cvi_cmd 	  = { 0x00, EOD },
			.cvi_new_cmd  = { 0x00, EOD },
			.cvi_checksum = { 0x00, EOD },

			.tvi_v1_0 	  = { 0x00, EOD },
			.tvi_v2_0     = { 0x00, EOD },

			.sd  		  = { 0x00, EOD },
	},

	[ COAX_CMD_TVI_DOWNSTREAM_REQUEST ] = {
			.name 		  = "COAX_CMD_SPECIAL_MOTION",
			.ahd_16bit    = { 0x00, EOD },
			.ahd_8bit     = { 0x00, EOD },
			.ahd_4_5m 	  = { 0x00, EOD },
			.cvi_cmd 	  = { 0x00, EOD },
			.cvi_new_cmd  = { 0x00, EOD },
			.cvi_checksum = { 0x00, EOD },
			.tvi_v1_0     = { 0xb5, 0x00, 0x87, 0x00, 0x80, 0x00, 0x00, 0x00, 0x3c, 0x80, EOD },
			.tvi_v2_0     = { 0xb5, 0x01, 0x87, 0x00, 0x80, 0x00, 0x00, 0x00, 0x3d, 0x80, EOD },
			.sd  		  = { 0x00, EOD },
			.autostop  = 1,
	},

	[ COAX_CMD_OSD_UP ] = {
			.name 		= "COAX_CMD_OSD_UP",
			.ahd_16bit    	= { 0x00, 0x10, 0x10, 0x4c, EOD },
			.ahd_8bit 	  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, EOD },
			.ahd_4_5m 	  = { 0x00, 0x08, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00, EOD },
			.cvi_cmd      = { 0xa5, 0x80, 0x10, 0x00, 0xf9, 0x00, 0xb2, 0xff, 0xff, 0xff, 0xff, 0xff,  0xff, 0xff, 0xff, 0xff, EOD },
			.cvi_new_cmd  = { 0xa5, 0x80, 0x91, 0x20, 0x00, 0x00, 0xCC, 0xff, 0xff, 0xff, EOD },
			.cvi_checksum = { 0xb2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, EOD },
			.tvi_v1_0 	  = { 0xb5, 0x00, 0x06, 0x24, 0x80, 0x00, 0x00, 0x00, 0xdf, 0x80, EOD },
			.tvi_v2_0     = { 0xb5, 0x01, 0x06, 0xff, 0x80, 0x00, 0x00, 0x00, 0xbb, 0x80, EOD },
			.sd  		  = { 0x00, 0x10, 0x00, 0x00, EOD },
			.autostop  = 1,
	},

	[ COAX_CMD_OSD_DOWN ] = {
			.name 		  = "COAX_CMD_OSD_DOWN",
			.ahd_16bit    = { 0x00, 0x08, 0x08, 0x4c, EOD },
			.ahd_8bit 	  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x32, EOD },
			.ahd_4_5m 	  = { 0x00, 0x10, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00, EOD },
			.cvi_cmd      = { 0xa5, 0x80, 0x20, 0x00, 0xf9, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff,  0xff, 0xff, 0xff, 0xff, EOD },
			.cvi_new_cmd  = { 0xa5, 0x80, 0x91, 0xA0, 0x00,  0x00, 0x2C, 0xff, 0xff, 0xff, EOD },
			.cvi_checksum = { 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, EOD },
			.tvi_v1_0 	  = { 0xb5, 0x00, 0x07, 0x24, 0x80, 0x00, 0x00, 0x00, 0xe0, 0x80, EOD },
			.tvi_v2_0     = { 0xb5, 0x01, 0x07, 0xff, 0x80, 0x00, 0x00, 0x00, 0xbc, 0x80, EOD },
			.sd  		  = { 0x00, 0x08, 0x00, 0x00, EOD },
			.autostop  = 1,
	},

	[ COAX_CMD_OSD_LEFT ] = {
			.name 		  = "COAX_CMD_OSD_LEFT",
			.ahd_16bit    = { 0x00, 0x20, 0x20, 0x00, EOD },
			.ahd_8bit 	  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x32, 0x00, EOD },
			.ahd_4_5m 	  = { 0x00, 0x04, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, EOD },
			.cvi_cmd      = { 0xa5, 0x80, 0x40, 0xf9, 0x00, 0x00, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff,  0xff, 0xff, 0xff, 0xff, EOD },
			.cvi_new_cmd  = { 0xa5, 0x80, 0x91, 0x60, 0x00,  0x00, 0xAC, 0xff, 0xff, 0xff, EOD },
			.cvi_checksum = { 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, EOD },
			.tvi_v1_0 	  = { 0xb5, 0x00, 0x09, 0x00, 0x80, 0x24, 0x00, 0x00, 0xe2, 0x80, EOD },
			.tvi_v2_0     = { 0xb5, 0x01, 0x09, 0x00, 0x80, 0xff, 0x00, 0x00, 0xbe, 0x80, EOD },
			.sd  		  = { 0x00, 0x20, 0x4C, 0x00, EOD },
			.autostop  = 1,
	},

	[ COAX_CMD_OSD_RIGHT ] = {
			.name 		  = "COAX_CMD_OSD_RIGHT",
			.ahd_16bit    = { 0x00, 0x40, 0x40, 0x00, EOD },
			.ahd_8bit 	  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x32, 0x00, EOD },
			.ahd_4_5m 	  = { 0x00, 0x02, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, EOD },
			.cvi_cmd      = { 0xa5, 0x80, 0x80, 0xf9, 0x00, 0x00, 0x62, 0xff, 0xff, 0xff, 0xff, 0xff,  0xff, 0xff, 0xff, 0xff, EOD },
			.cvi_new_cmd  = { 0xa5, 0x80, 0x91, 0xE0, 0x00,  0x00, 0x6C, 0xff, 0xff, 0xff, EOD },
			.cvi_checksum = { 0x62, 0xff, 0xff, 0xff, 0xff, 0xff, EOD },
			.tvi_v1_0 	  = { 0xb5, 0x00, 0x08, 0x00, 0x80, 0x24, 0x00, 0x00, 0xe1, 0x80, EOD },
			.tvi_v2_0     = { 0xb5, 0x01, 0x08, 0x00, 0x80, 0xff, 0x00, 0x00, 0xbd, 0x80, EOD },
			.sd  		  = { 0x00, 0x40, 0x4C, 0x00, EOD },
			.autostop  = 1,
	},

	[ COAX_CMD_STOP ] = {
			.name 		  = "COAX_CMD_STOP",
			.ahd_16bit    = { 0x00, 0x00, 0x00, 0x00, EOD },
			.ahd_8bit 	  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, EOD },
			.ahd_4_5m 	  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, EOD },
			.cvi_cmd      = { 0xa5, 0x80, 0x02, 0x00, 0x00, 0x00, 0x67, 0xff, 0xff, 0xff, 0xff, 0xff,  0xff, 0xff, 0xff, 0xff, EOD },
			.cvi_new_cmd  = { 0xa5, 0x80, 0x02, 0x00, 0x00, 0x00, 0x67, 0xff, 0xff, 0xff, EOD },
			.cvi_checksum = { 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, EOD },
			.tvi_v1_0 	  = { 0xb5, 0x00, 0x14, 0x00, 0x80, 0x00, 0x00, 0x00, 0xc9, 0x80, EOD },
			.tvi_v2_0     = { 0xb5, 0x01, 0x14, 0x00, 0x80, 0x00, 0x00, 0x00, 0xca, 0x80, EOD },
			.sd  		  = { 0x40, 0x00, 0x00, 0x00, EOD },
			.autostop  = 1,
	},
};




/********************************************************************
 *  End of file
 ********************************************************************/

#endif
