//*****************************************************************************
//*****************************************************************************
//  FILENAME: Driver.h
//  TrueTouch Host Emulator Version Information: 3.10, b205
//  TrueTouch Firmware Version Information: 3.0.886412
//
//  DESCRIPTION: This file contains configuration values.
//-----------------------------------------------------------------------------
//  Copyright (c) Cypress Semiconductor 2009 - 2015. All Rights Reserved.
//*****************************************************************************
//*****************************************************************************
//-----------------------------------------------------------------------------
/* Touchscreen Version Information */
static u8 ttconfig_fw_ver_pid01[] = {
	0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x86, 0x8C, 0x16, 0x00, 0x11, 0xA6, 0x00, 0x25
};

/* Touchscreen Parameters Endianess (Endianess: 0:Little; 1:Big)*/
static const uint8_t cyttsp4_param_regs_pid01_endianess = 0;

/* Touchscreen Parameters */
static const uint8_t cyttsp4_param_regs_pid01[] = {
/*	Value	Name	*/
	0xFC, 0x04,  /* CONFIG_DATA_SIZE */
	0xFC, 0x04,  /* CONFIG_DATA_MAX_SIZE */
	0x00, 0x03,  /* CROSS_NUM */
	0x20,  /* TX_NUM */
	0x18,  /* RX_NUM */
	0x38,  /* SENS_NUM */
	0x00,  /* BUTTON_NUM */
	0x01,  /* SLOTS_MUT */
	0x01,  /* SLOTS_SELF_RX */
	0x01,  /* SLOTS_SELF_TX */
	0x02,  /* SLOTS_SELF */
	0x01,  /* SENSOR_ASSIGNMENT */
	0x03,  /* SCANNING_MODE_BUTTON */
	0x01,  /* SELF_Z_MODE */
	0x00,  /* CHARGER_ARMOR_ENABLE */
	0x01,  /* WATER_REJ_ENABLE */
	0x01,  /* WF_ENABLE */
	0xE8, 0x03,  /* WF_DETECT_PEAK_THR */
	0x64, 0x00,  /* WF_DETECT_PEAK_Z9_THR */
	0x02,  /* WF_DETECT_PEAK_Z9_SCALE */
	0x0C,  /* WF_DETECT_PEAK_Z8_SCALE */
	0x03,  /* WF_DETECT_PEAK_DEBOUNCE */
	0x02,  /* WF_DETECT_PEAK_COUNT */
	0xE8, 0x03, 0x00, 0x00,  /* CA_REVERT_TIME_MS */
	0x88, 0x13, 0x00, 0x00,  /* CA_TOUCH_REVERT_TIME_MS */
	0x00, 0x00, 0x00, 0x00,  /* CA_MAX_XY_MOVEMENT_REVERT */
	0x00,  /* CA_HOST_CTRL */
	0x00,  /* CHARGER_STATUS */
	0x03,  /* CA_TRIG_SRC */
	0x01,  /* WB_CMF_ENABLE */
	0x0F,  /* WB_REVERT_THRESH */
	0x02,  /* AFH_HOP_CYCLES_COUNT */
	0x06,  /* NMI_SCAN_CNT */
	0x00,  /* Reserved47 */
	0x0A, 0x00, 0x0A, 0x00,  /* CA_NMF_LIMIT */
	0xB4, 0x00,  /* NMI_TCH_MAGNITUDE */
	0x5A, 0x00,  /* NMI_TOUCH_THRESH */
	0x0F, 0x00,  /* NMI_THRESH */
	0x0F, 0x00,  /* WB_THRESH */
	0x00, 0x80,  /* SC_TRIG_THRESH */
	0x32, 0x00,  /* CA_DYN_CAL_SAFE_RAW_RANGE */
	0x4B,  /* CA_DYN_CAL_NUM_SENSOR_THLD_PERCENT */
	0x00,  /* Reserved65 */
	0x64, 0x00,  /* MAX_MUTUAL_SCAN_INTERVAL */
	0x64, 0x00,  /* MAX_SELF_SCAN_INTERVAL */
	0x00,  /* CMF_DELTA_TEMPCO_INC */
	0x00,  /* BUTTON_LAYOUT */
	0x00, 0x00, 0xFE, 0xFF, 
	0xFF, 0x01, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0xF0, 0xFF, 0xFF, 
	0xFF, 0x0F, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0xFE, 0xFF, 
	0xFF, 0xF1, 0xFF, 0xFF, 
	0xFF, 0x0F, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00,  /* CDC_SENSOR_MASKS */
	0x28, 0x27, 0x26, 0x25, 
	0x24, 0x23, 0x22, 0x21, 
	0x20, 0x1F, 0x1E, 0x1D, 
	0x1C, 0x1B, 0x1A, 0x19, 
	0x18, 0x17, 0x16, 0x15, 
	0x14, 0x13, 0x12, 0x11, 
	0x2C, 0x2D, 0x2E, 0x2F, 
	0x30, 0x31, 0x32, 0x33, 
	0x34, 0x35, 0x36, 0x37, 
	0x38, 0x39, 0x3A, 0x3B, 
	0x4B, 0x4A, 0x49, 0x48, 
	0x47, 0x46, 0x45, 0x44, 
	0x43, 0x42, 0x41, 0x40, 
	0x3F, 0x3E, 0x3D, 0x3C, 
	0x52, 0x07, 0x50, 0x05, 
	0x4E, 0x03, 0x4C, 0x01, 
	0x4A, 0x57, 0x48, 0x55, 
	0x00, 0x53, 0x02, 0x51, 
	0x04, 0x4F, 0x06, 0x4D, 
	0x08, 0x4B, 0x0A, 0x49, 
	0x0C, 0x47, 0x0E, 0x44, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00,  /* CDC_PIN_INDEX_TABLE */
	0x28, 0x27, 0x26, 0x25, 
	0x24, 0x23, 0x22, 0x21, 
	0x20, 0x1F, 0x1E, 0x1D, 
	0x1C, 0x1B, 0x1A, 0x19, 
	0x18, 0x17, 0x16, 0x15, 
	0x14, 0x13, 0x12, 0x11, 
	0x2C, 0x2D, 0x2E, 0x2F, 
	0x30, 0x31, 0x32, 0x33, 
	0x34, 0x35, 0x36, 0x37, 
	0x38, 0x39, 0x3A, 0x3B, 
	0x4B, 0x4A, 0x49, 0x48, 
	0x47, 0x46, 0x45, 0x44, 
	0x43, 0x42, 0x41, 0x40, 
	0x3F, 0x3E, 0x3D, 0x3C, 
	0x52, 0x07, 0x50, 0x05, 
	0x4E, 0x03, 0x4C, 0x01, 
	0x4A, 0x57, 0x48, 0x55, 
	0x00, 0x53, 0x02, 0x51, 
	0x04, 0x4F, 0x06, 0x4D, 
	0x08, 0x4B, 0x0A, 0x49, 
	0x0C, 0x47, 0x0E, 0x44, 
	0x00, 0x00, 0x00, 0x00, 
	0x01, 0x00, 0x00, 0x00, 
	0x00,  /* CDC_REAL_PIN_INDEX_TABLE */
	0x00, 0x00, 0x00,  /* Reserved305 */
	0x2F, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00,  /* CDC_MTX_PHASE_VECTOR */
	0xAB, 0x0A, 0x00, 0x20, 
	0xAB, 0x0A, 0xAB, 0x0A, 
	0x55, 0xF5, 0x00, 0x20, 
	0x55, 0xF5, 0x55, 0xF5, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00,  /* CDC_MTX_DECONV_COEF */
	0x00, 0x00,  /* Reserved354 */
	0x00, 0x00, 0xFE, 0xFF, 
	0xFF, 0x01, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0xFF, 0xFF, 0xFF, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x11, 0x18, 0x17, 0x16, 
	0x15, 0x14, 0x13, 0x12, 
	0x11, 0x10, 0x0F, 0x0E, 
	0x0D, 0x0C, 0x0B, 0x0A, 
	0x09, 0x08, 0x07, 0x06, 
	0x05, 0x04, 0x03, 0x02, 
	0x01, 0x00, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0xF0, 0xFF, 0xFF, 
	0xFF, 0x0F, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0xF0, 
	0xFF, 0xFF, 0x3F, 0x00, 
	0xFF, 0x20, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x2C, 0x2B, 0x2A, 
	0x29, 0x28, 0x1D, 0x1E, 
	0x1F, 0x20, 0x21, 0x22, 
	0x23, 0x24, 0x25, 0x26, 
	0x27, 0x37, 0x36, 0x35, 
	0x34, 0x33, 0x32, 0x31, 
	0x30, 0x2F, 0x2E, 0x2D, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0xFF, 0x00, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0xFF, 0x00, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF,  /* CDC_SLOT_TABLE */
	0x00,  /* Reserved676 */
	0x00,  /* Reserved677 */
	0x00, 0x00,  /* Reserved678 */
	0x00, 0x00,  /* Reserved680 */
	0x03,  /* MC_RAW_FILTER_MASK */
	0x01,  /* MC_RAW_IIR_COEF */
	0xC8, 0x00,  /* MC_RAW_IIR_THRESH */
	0xE8, 0x03,  /* MC_RAW_CMF_THRESH */
	0x03,  /* SC_RAW_FILTER_MASK */
	0x01,  /* SC_RAW_IIR_COEF */
	0xC8, 0x00,  /* SC_RAW_IIR_THRESH */
	0x20, 0x03,  /* SC_RAW_CMF_THRESH */
	0x03,  /* BTN_MC_RAW_FILTER_MASK */
	0x01,  /* BTN_MC_RAW_IIR_COEF */
	0x64, 0x00,  /* BTN_MC_RAW_IIR_THRESH */
	0xC8, 0x00,  /* BTN_MC_RAW_CMF_THRESH */
	0x03,  /* BTN_SC_RAW_FILTER_MASK */
	0x01,  /* BTN_SC_RAW_IIR_COEF */
	0x64, 0x00,  /* BTN_SC_RAW_IIR_THRESH */
	0xC8, 0x00,  /* BTN_SC_RAW_CMF_THRESH */
	0x03,  /* CA_MC_RAW_FILTER_MASK */
	0x01,  /* CA_MC_RAW_IIR_COEF */
	0x64, 0x00,  /* CA_MC_RAW_IIR_THRESH */
	0xC8, 0x00,  /* CA_MC_RAW_CMF_THRESH */
	0x03,  /* CA_BTN_MC_RAW_FILTER_MASK */
	0x01,  /* CA_BTN_MC_RAW_IIR_COEFF_BUT */
	0x64, 0x00,  /* CA_BTN_MC_RAW_IIR_THRESH */
	0xC8, 0x00,  /* CA_BTN_MC_RAW_CMF_THRESH */
	0x03,  /* GLOVE_MC_RAW_FILTER_MASK */
	0x01,  /* GLOVE_MC_RAW_IIR_COEF */
	0x64, 0x00,  /* GLOVE_MC_RAW_IIR_THRESH */
	0xC8, 0x00,  /* GLOVE_MC_RAW_CMF_THRESH */
	0x03,  /* GLOVE_SC_RAW_FILTER_MASK */
	0x01,  /* GLOVE_SC_RAW_IIR_COEF */
	0x64, 0x00,  /* GLOVE_SC_RAW_IIR_THRESH */
	0xC8, 0x00,  /* GLOVE_SC_RAW_CMF_THRESH */
	0x03,  /* BTN_GLOVE_MC_RAW_FILTER_MASK */
	0x01,  /* BTN_GLOVE_MC_RAW_IIR_COEF */
	0x64, 0x00,  /* BTN_GLOVE_MC_RAW_IIR_THRESH */
	0xC8, 0x00,  /* BTN_GLOVE_MC_RAW_CMF_THRESH */
	0x03,  /* BTN_GLOVE_SC_RAW_FILTER_MASK */
	0x01,  /* BTN_GLOVE_SC_RAW_IIR_COEF */
	0x64, 0x00,  /* BTN_GLOVE_SC_RAW_IIR_THRESH */
	0xC8, 0x00,  /* BTN_GLOVE_SC_RAW_CMF_THRESH */
	0x03,  /* STYLUS_MC_RAW_FILTER_MASK */
	0x01,  /* STYLUS_MC_RAW_IIR_COEF */
	0x64, 0x00,  /* STYLUS_MC_RAW_IIR_THRESH */
	0xC8, 0x00,  /* STYLUS_MC_RAW_CMF_THRESH */
	0x03,  /* STYLUS_SC_RAW_FILTER_MASK */
	0x01,  /* STYLUS_SC_RAW_IIR_COEF */
	0x64, 0x00,  /* STYLUS_SC_RAW_IIR_THRESH */
	0xC8, 0x00,  /* STYLUS_SC_RAW_CMF_THRESH */
	0x00, 0x00,  /* WF_RAW_CALC_THRESH */
	0xF4, 0x01,  /* WF_RAW_BASELINE_THRESH */
	0xC8, 0x00,  /* WF_DIFF_CALC_THRESH */
	0xDC, 0x05,  /* WF_RAW_VAR_THRESH */
	0xF4, 0x01,  /* WF_DIFF_VAR_THRESH */
	0xAC, 0x0D,  /* WF_LEVEL_THRESH */
	0x0A,  /* WF_ENTER_DEBOUNCE */
	0x0A,  /* WF_EXIT_DEBOUNCE */
	0x00,  /* SD_CORR_ENABLE */
	0x00,  /* Reserved769 */
	0xF4, 0x01,  /* SD_CORR_MIN_COEF */
	0xB8, 0x0B,  /* SD_CORR_MC_TARGET */
	0x96, 0x00,  /* SD_CORR_SC_THRESH */
	0x20, 0x03,  /* SD_CORR_MC_SUM_THRESH */
	0x01,  /* FINGER_BL_SNS_WIDTH */
	0x01,  /* FINGER_BL_UPDATE_SPEED */
	0x96, 0x00,  /* FINGER_BL_THRESH_MC */
	0xC8, 0x00,  /* FINGER_BL_THRESH_SC */
	0x01,  /* GLOVE_BL_SNS_WIDTH */
	0x01,  /* GLOVE_BL_UPDATE_SPEED */
	0x64, 0x00,  /* GLOVE_BL_THRESH_MC */
	0xC8, 0x00,  /* GLOVE_BL_THRESH_SC */
	0x01,  /* STYLUS_BL_SNS_WIDTH */
	0x01,  /* STYLUS_BL_UPDATE_SPEED */
	0x64, 0x00,  /* STYLUS_BL_THRESH_MC */
	0xC8, 0x00,  /* STYLUS_BL_THRESH_SC */
	0x01,  /* Reserved796 */
	0x01,  /* BL_UPDATE_SPEED_BTN */
	0x64, 0x00,  /* BL_THRESH_BTN_MC */
	0xC8, 0x00,  /* BL_THRESH_BTN_SC */
	0x00, 0x00,  /* Reserved802 */
	0x00, 0x00, 0x00, 0x00,  /* PQ_CTRL */
	0x00, 0x00, 0x00, 0x00,  /* PQ_CTRL2 */
	0x00, 0x00, 0x00, 0x00,  /* PQ_CTRL3 */
	0x00, 0x50, 0x25, 0xA0,  /* REFGEN_CTL */
	0x00, 0x00, 0x20, 0x00,  /* RX_CTRL */
	0x00, 0x20, 0x00, 0x00,  /* INFRA_CTRL */
	0x64,  /* STARTUP_DELAY */
	0x00,  /* FORCE_SINGLE_TX */
	0xFA, 0x00,  /* SCALE_FACT_MC */
	0x0E, 0x01,  /* SCALE_FACT_SC */
	0xC8, 0x00,  /* SCALE_FACT_BTN_MC */
	0xC8, 0x00,  /* SCALE_FACT_BTN_SC */
	0x03,  /* TX_PUMP_VOLTAGE */
	0x0E,  /* DRV_WEAK_MC */
	0x0E,  /* DRV_STRONG_MC */
	0x0E,  /* DRV_WEAK_SC */
	0x0E,  /* DRV_STRONG_SC */
	0x0A,  /* SHIELD_EN_SC */
	0x00,  /* SHIELD_RES_SEL_SC */
	0x1E,  /* DISCARD_TIME */
	0x00,  /* VDDA_MODE */
	0x00,  /* Reserved847 */
	0x08,  /* MTX_ORDER */
	0x00,  /* EXT_SYNC */
	0x02,  /* TX_FREQ_METHOD_MC */
	0x02,  /* TX_FREQ_METHOD_SC */
	0x44, 0x00,  /* NM_WB_TX_PERIOD */
	0x01,  /* NM_WB_TX_PERIOD_DITHER */
	0x18,  /* NM_WB_IDAC */
	0x20,  /* SAFE_RAW_RANGE_PERCENT_MC */
	0x40,  /* SAFE_RAW_RANGE_PERCENT_SC */
	0x40,  /* SAFE_RAW_RANGE_PERCENT_MC_BTN */
	0x40,  /* SAFE_RAW_RANGE_PERCENT_SC_BTN */
	0xFA, 0x00,  /* INT_VOLTAGE_MC */
	0xFA, 0x00,  /* INT_VOLTAGE_SC */
	0xFA, 0x00,  /* INT_VOLTAGE_MC_BTN */
	0xFA, 0x00,  /* INT_VOLTAGE_SC_BTN */
	0x26,  /* BAL_TARGET_MC */
	0x40,  /* BAL_TARGET_SC */
	0x26,  /* BAL_TARGET_MC_BTN */
	0x26,  /* BAL_TARGET_SC_BTN */
	0x14, 0x05,  /* ILEAK_MAX */
	0xF0, 0x0A,  /* VDDA_LEVEL */
	0xE8, 0x03,  /* PUMP_DELAY_US */
	0x73,  /* MC_PWC_LIMIT_PERCENT */
	0x40,  /* SC_PWC_LIMIT_PERCENT */
	0x01,  /* HW_BL_GIDAC_LSB_CONFIG */
	0x00,  /* Reserved881 */
	0x04, 0x01,  /* TX_PERIOD_MC */
	0x44, 0x00,  /* CA_HOP0_TX_PERIOD_MC */
	0x44, 0x00,  /* CA_HOP1_TX_PERIOD_MC */
	0x44, 0x00,  /* CA_HOP2_TX_PERIOD_MC */
	0x40, 0x01,  /* TX_PERIOD_SC */
	0x44, 0x00,  /* TX_PERIOD_BTN_MC */
	0xA0, 0x00,  /* TX_PERIOD_BTN_SC */
	0x20, 0x00,  /* TX_PULSES_MC */
	0x7F, 0x00,  /* CA_MC_BASE_TX_PULSES_NUM */
	0x7F, 0x00,  /* CA_HOP0_TX_PULSES_MC */
	0x7F, 0x00,  /* CA_HOP1_TX_PULSES_MC */
	0x7F, 0x00,  /* CA_HOP2_TX_PULSES_MC */
	0x40, 0x00,  /* TX_PULSES_SC */
	0x40, 0x00,  /* TX_PULSES_BTN_MC */
	0x20, 0x00,  /* TX_PULSES_BTN_SC */
	0x40, 0x00,  /* TX_PULSES_GLOVE_MC */
	0x40, 0x00,  /* TX_PULSES_GLOVE_SC */
	0x40, 0x00,  /* TX_PULSES_BTN_GLOVE_MC */
	0x20, 0x00,  /* TX_PULSES_BTN_GLOVE_SC */
	0x40, 0x00,  /* STYL_TX_PULSES_MC */
	0x40, 0x00,  /* STYL_TX_PULSES_SC */
	0x00,  /* RX_ATTEN_RES_BYPASS */
	0x00, 0x00, 0x00,  /* Reserved925 */
	0x50,  /* BTN_LS_ON_THRSH_MUT_0 */
	0x50,  /* BTN_LS_ON_THRSH_MUT_1 */
	0x50,  /* BTN_LS_ON_THRSH_MUT_2 */
	0x50,  /* BTN_LS_ON_THRSH_MUT_3 */
	0x46,  /* BTN_LS_OFF_THRSH_MUT_0 */
	0x46,  /* BTN_LS_OFF_THRSH_MUT_1 */
	0x46,  /* BTN_LS_OFF_THRSH_MUT_2 */
	0x46,  /* BTN_LS_OFF_THRSH_MUT_3 */
	0x41,  /* BTN_LS_ON_THRSH_SELF_0 */
	0x41,  /* BTN_LS_ON_THRSH_SELF_1 */
	0x41,  /* BTN_LS_ON_THRSH_SELF_2 */
	0x41,  /* BTN_LS_ON_THRSH_SELF_3 */
	0x28,  /* BTN_LS_OFF_THRSH_SELF_0 */
	0x28,  /* BTN_LS_OFF_THRSH_SELF_1 */
	0x28,  /* BTN_LS_OFF_THRSH_SELF_2 */
	0x28,  /* BTN_LS_OFF_THRSH_SELF_3 */
	0x00,  /* BTN_LS_TD_DEBOUNCE */
	0x00,  /* Reserved945 */
	0x00, 0x00,  /* Reserved946 */
	0x14,  /* BTN_HS_ON_THRSH_MUT_0 */
	0x14,  /* BTN_HS_ON_THRSH_MUT_1 */
	0x14,  /* BTN_HS_ON_THRSH_MUT_2 */
	0x14,  /* BTN_HS_ON_THRSH_MUT_3 */
	0x0A,  /* BTN_HS_OFF_THRSH_MUT_0 */
	0x0A,  /* BTN_HS_OFF_THRSH_MUT_1 */
	0x0A,  /* BTN_HS_OFF_THRSH_MUT_2 */
	0x0A,  /* BTN_HS_OFF_THRSH_MUT_3 */
	0x1E,  /* BTN_HS_ON_THRSH_SELF_0 */
	0x1E,  /* BTN_HS_ON_THRSH_SELF_1 */
	0x1E,  /* BTN_HS_ON_THRSH_SELF_2 */
	0x1E,  /* BTN_HS_ON_THRSH_SELF_3 */
	0x0A,  /* BTN_HS_OFF_THRSH_SELF_0 */
	0x0A,  /* BTN_HS_OFF_THRSH_SELF_1 */
	0x0A,  /* BTN_HS_OFF_THRSH_SELF_2 */
	0x0A,  /* BTN_HS_OFF_THRSH_SELF_3 */
	0x01,  /* BTN_HS_TOUCHDOWN_DEBOUNCE */
	0x00,  /* Reserved965 */
	0x00, 0x00,  /* Reserved966 */
	0x28, 0x00,  /* BTN_HIGHSEN_MODE_THRSH_MUT */
	0x28, 0x00,  /* BTN_HIGHSEN_MODE_THRSH_SELF */
	0xC8, 0x00,  /* BTN_LOWSEN_MODE_THRSH_MUT */
	0x5E, 0x01,  /* BTN_LOWSEN_MODE_THRSH_SELF */
	0x0A,  /* GLOVE_BTN_FORBID_DEBOUNCE */
	0x01,  /* GLOVE_BTN_MODE_SWITCH_DEBOUNCE */
	0x00,  /* BTN_PROCESS_IF_TOUCH_DETECTED */
	0x00,  /* Reserved979 */
	0xF4, 0x01,  /* FINGER_THRESH_MUT_HI */
	0xC2, 0x01,  /* FINGER_THRESH_MUT_LO */
	0xE6, 0x00,  /* FINGER_THRESH_SELF */
	0x00,  /* FINGER_Z9_FILT_SCALE */
	0x00,  /* FINGER_Z8_FILT_SCALE */
	0x0A,  /* MIN_FAT_FINGER_SIZE */
	0x01,  /* MIN_FAT_FINGER_SIZE_HYST */
	0x18,  /* MAX_FAT_FINGER_SIZE */
	0x08,  /* MAX_FAT_FINGER_SIZE_HYST */
	0x40,  /* FINGER_SIG_THRESH_MULT */
	0x03,  /* FINGER_OBJECT_FEATURES */
	0x20, 0x00,  /* FINGER_Z_SCALE */
	0x08,  /* FINGER_INNER_EDGE_GAIN */
	0x64,  /* FINGER_OUTER_EDGE_GAIN */
	0x00,  /* FINGER_POS_CALC_METHOD */
	0x00,  /* Reserved999 */
	0x2C, 0x01,  /* CA_FINGER_THRESH_MUT_HI */
	0x2C, 0x01,  /* CA_FINGER_THRESH_MUT_LO */
	0x03,  /* FINGER_MT_DEBOUNCE */
	0x02,  /* CA_FINGER_MT_DEBOUNCE */
	0x00,  /* CA_FINGER_FT_DEBOUNCE */
	0x04,  /* CA_FINGER_Z9_FILT_SCALE */
	0x0F,  /* CA_MIN_FAT_FINGER_SIZE */
	0x28,  /* CA_MAX_FAT_FINGER_SIZE */
	0x40,  /* WF_THRESH_MUT_COEF */
	0x05,  /* WF_MT_DEBOUNCE */
	0x14,  /* TOUCHMODE_FRAME_NUM_TO_CONFIRM_FINGER_MODE */
	0x00, 0x00, 0x00,  /* Reserved1013 */
	0x3C, 0x00,  /* GLOVES_THRESH_MUT_HI */
	0x32, 0x00,  /* GLOVES_THRESH_MUT_LO */
	0x1E, 0x00,  /* GLOVES_THRESH_SELF */
	0x04,  /* GLOVES_Z9_FILT_SCALE */
	0x01,  /* GLOVES_Z8_FILT_SCALE */
	0x0A,  /* GLOVES_MIN_FAT_SIZE */
	0x01,  /* GLOVES_MIN_FAT_SIZE_HYST */
	0x28,  /* GLOVES_MAX_FAT_SIZE */
	0x04,  /* GLOVES_MAX_FAT_SIZE_HYST */
	0x40,  /* GLOVES_SIG_THRESH_MULT */
	0x00,  /* GLOVES_OBJECT_FEATURES */
	0x40, 0x00,  /* GLOVES_Z_SCALE */
	0x08,  /* GLOVES_INNER_EDGE_GAIN */
	0x78,  /* GLOVES_OUTER_EDGE_GAIN */
	0x00,  /* GLOVES_POS_CALC_METHOD */
	0x00,  /* Reserved1035 */
	0x2C, 0x01,  /* TOUCHMODE_GLOVE_HTI */
	0xDC, 0x05,  /* TOUCHMODE_GLOVE_MAX_SIG_SUM */
	0x02,  /* GLOVES_FT_DEBOUNCE */
	0x00,  /* GLOVES_FT_DEBOUNCE_EDGE_MASK */
	0x00,  /* GLOVES_MT_DEBOUNCE */
	0x20,  /* GLOVES_GRIP_FILT_SCALE */
	0x64,  /* TOUCHMODE_FRAME_NUM_TO_CONFIRM_GLOVE_MODE */
	0x00,  /* GLOVES_MAX_ACCEPTABLE_NOISE_LEVEL */
	0x00, 0x00,  /* Reserved1046 */
	0x3C, 0x00,  /* STYLUS_THRESH_MUT_HI */
	0x32, 0x00,  /* STYLUS_THRESH_MUT_LO */
	0x1E, 0x00,  /* STYLUS_THRESH_SELF */
	0x01,  /* STYLUS_Z9_FILT_SCALE */
	0x01,  /* STYLUS_Z8_FILT_SCALE */
	0x40, 0x00,  /* STYLUS_Z_SCALE */
	0x08,  /* STYLUS_INNER_EDGE_GAIN */
	0x78,  /* STYLUS_OUTER_EDGE_GAIN */
	0x01,  /* STYLUS_POS_CALC_METHOD */
	0x00,  /* Reserved1061 */
	0x90, 0x01,  /* TOUCHMODE_STYLUS_HTI */
	0x20, 0x03,  /* TOUCHMODE_STYLUS_MAX_SIG_SUM */
	0x90, 0x01,  /* STYLUS_HOVER_COEF */
	0x96, 0x00,  /* STYLUS_CM_EDGE */
	0x90, 0x01,  /* STYLUS_CONST_MASS */
	0x40,  /* STYLUS_CM_GAIN */
	0x01,  /* STYLUS_CM_COEF */
	0x08,  /* STYLUS_PERIODIC_ERROR_AMPLITUDE */
	0x05,  /* STYLUS_PALM_CLEARANCE */
	0x64,  /* TOUCHMODE_FRAME_NUM_TO_CONFIRM_STYLUS_MODE */
	0x00,  /* STYLUS_MAX_ACCEPTABLE_NOISE_LEVEL */
	0x00, 0x00,  /* Reserved1078 */
	0x00, 0x00,  /* TOUCHMODE_FINGER_SWITCH_DEBOUNCE */
	0xC8, 0x00,  /* TOUCHMODE_FINGER_EXIT_DELAY */
	0x14, 0x00,  /* TOUCHMODE_GLOVE_SWITCH_DEBOUNCE */
	0x2C, 0x01,  /* TOUCHMODE_GLOVE_EXIT_DELAY */
	0x00, 0x00,  /* TOUCHMODE_GLOVE_FINGER_SWITCH_DEBOUNCE */
	0xE8, 0x03,  /* TOUCHMODE_FINGER_GLOVE_SWITCH_DEBOUNCE */
	0x14, 0x00,  /* TOUCHMODE_STYLUS_SWITCH_DEBOUNCE */
	0xB8, 0x0B,  /* TOUCHMODE_STYLUS_EXIT_DELAY */
	0x64, 0x00,  /* TOUCHMODE_FINGER_STYLUS_SWITCH_DEBOUNCE */
	0x00, 0x00,  /* Reserved1098 */
	0x04, 0x01,  /* ACT_DIST0_SQR */
	0x00, 0x00,  /* ACT_DIST2_SQR */
	0x00, 0x00,  /* ACT_DIST_TOUCHDOWN_SQR */
	0x00, 0x00,  /* ACT_DIST_LIFTOFF_SQR */
	0xFF,  /* ACT_DIST_Z_THRESHOLD */
	0x01,  /* LARGE_OBJ_CFG */
	0x00, 0x00,  /* Reserved1110 */
	0xF0,  /* XY_FILTER_MASK */
	0x10,  /* XY_FILT_IIR_COEF_SLOW */
	0x10,  /* XY_FILT_IIR_COEF_FAST */
	0xFF,  /* XY_FILT_XY_THR_SLOW */
	0xFF,  /* XY_FILT_XY_THR_FAST */
	0x01,  /* XY_FILT_Z_IIR_COEFF */
	0x00,  /* XY_FILT_PREDICTION_COEF */
	0x00,  /* Reserved1119 */
	0xF0,  /* XY_FILTER_MASK_CA */
	0x08,  /* XY_FILT_IIR_COEF_SLOW_CA */
	0x08,  /* XY_FILT_IIR_COEF_FAST_CA */
	0xFF,  /* XY_FILT_XY_THR_SLOW_CA */
	0xFF,  /* XY_FILT_XY_THR_FAST_CA */
	0x01,  /* XY_FILT_Z_IIR_COEFF_CA */
	0x00,  /* XY_FILT_PREDICTION_COEF_CA */
	0x00,  /* Reserved1127 */
	0x00,  /* XY_FILT_AXIS_IIR_COEF */
	0x01,  /* XY_FILT_AXIS_HYST */
	0x00,  /* XY_FILT_ANGLE_IIR_COEF */
	0x01,  /* XY_FILT_ANGLE_HYST */
	0x28, 0xE6, 0x1E, 0x00,  /* MAX_VELOCITY_SQR */
	0x50, 0xC3, 0x00, 0x00,  /* FINGER_ID_MAX_FINGER_ACCELERATION2 */
	0x00, 0x00,  /* GRIP_XEDG_A */
	0x00, 0x00,  /* GRIP_XEDG_B */
	0x00, 0x00,  /* GRIP_XEXC_A */
	0x00, 0x00,  /* GRIP_XEXC_B */
	0x00, 0x00,  /* GRIP_YEDG_A */
	0x00, 0x00,  /* GRIP_YEDG_B */
	0x00, 0x00,  /* GRIP_YEXC_A */
	0x00, 0x00,  /* GRIP_YEXC_B */
	0x01,  /* GRIP_FIRST_EXC */
	0x00,  /* GRIP_EXC_EDGE_ORIGIN */
	0x00,  /* GRIP_ENABLE */
	0x03,  /* FINGER_LIFTOFF_DEBOUNCE */
	0x05,  /* GLOVE_LIFTOFF_DEBOUNCE */
	0x05,  /* STYLUS_LIFTOFF_DEBOUNCE */
	0x00, 0x00,  /* Reserved1162 */
	0x07,  /* WATER_REJ_SNS_WIDTH */
	0x00,  /* SLIM_POSITION_OFFSET_ALONG_TX */
	0x00,  /* SLIM_POSITION_OFFSET_ALONG_RX */
	0x05,  /* WET_FINGER_Z8_MULT */
	0xA8, 0x16, 0x00, 0x00,  /* MIN_FF_Z9 */
	0x30, 0x43, 0x00, 0x00,  /* MAX_MF_Z9 */
	0x90, 0x1A, 0x00, 0x00,  /* MIN_FF_SIG_SUM_EDGE */
	0x30,  /* MF_CENTERSIG_RATIO */
	0x05,  /* SD_SIZE_THRESH */
	0xCE, 0x01,  /* SD_SIG_THRESH_ON */
	0xDB, 0x03,  /* SD_SIG_THRESH_OFF */
	0xFA, 0x00,  /* VP_DLT_RST_THRESH */
	0x88, 0x13,  /* VP_DLT_THRESH */
	0x05,  /* FAT_AXIS_LENGTH_THRESH */
	0x00,  /* PEAK_IGNORE_COEF */
	0x02,  /* AXIS_ORIENTATION_ENABLE */
	0x00, 0x00, 0x00,  /* Reserved1193 */
	0x0A,  /* CLIPPING_X_LOW */
	0x00,  /* CLIPPING_X_HIGH */
	0x00,  /* CLIPPING_Y_LOW */
	0x00,  /* CLIPPING_Y_HIGH */
	0x23, 0x00,  /* CALC_THRESH */
	0x37, 0x00,  /* OFFSET_S1 */
	0x19, 0x00,  /* OFFSET_S2 */
	0xD0, 0x07,  /* Z_SUM_8MM */
	0x84, 0x03,  /* Z_SUM_4MM */
	0x12, 0x02,  /* Z_SUM_3MM */
	0x82, 0x00,  /* Z_SUM_1MM */
	0x90, 0x01,  /* LOW_PIVOT */
	0xA3, 0x02,  /* HIGH_PIVOT */
	0x78, 0x00,  /* LOW_PIVOT2 */
	0xB4, 0x00,  /* HIGH_PIVOT2 */
	0x7A, 0x03,  /* EDGE_DEBOUNCE_THRESH */
	0xBC, 0x02,  /* CENTER_MAGNITUDE_SCALE */
	0xC0, 0x00,  /* CENTROID_CORNER_GAIN */
	0x03,  /* EDGE_DEBOUNCE_COUNT */
	0x00,  /* BR2_ALWAYS_ON_FLAG */
	0x06,  /* PREFERRED_TOUCH_SIZE */
	0x00,  /* TOUCH_SIZE_METHOD */
	0x01,  /* RXLINE_FILT_ENABLE */
	0x02,  /* RXLINE_FILT_DEBOUNCE */
	0x58,  /* RXLINE_FILT_THRESH */
	0x00,  /* Reserved1235 */
	0x64, 0x00,  /* TOUCHMODE_LFT_SELF_THRSH */
	0x00, 0x80,  /* TOUCHMODE_LFT_NEG_SC_THRESH */
	0x00, 0x80,  /* TOUCHMODE_LFT_NEG_MC_THRESH */
	0x50, 0x07,  /* X_RESOLUTION */
	0x7C, 0x05,  /* Y_RESOLUTION */
	0xD5, 0x2D,  /* X_LENGTH_100xMM */
	0xC8, 0x19,  /* Y_LENGTH_100xMM */
	0x42,  /* X_PITCH_10xMM */
	0x42,  /* Y_PITCH_10xMM */
	0x00,  /* Reserved1252 */
	0x01,  /* ACT_LFT_EN */
	0x01,  /* TOUCHMODE_CONFIG */
	0x02,  /* LRG_OBJ_CFG */
	0x02,  /* MAX_REPORTED_TOUCH_NUM */
	0x08,  /* REPORT_CFG */
	0x00,  /* TOUCHMODE_STYLUS_HIGH_PRIORITY */
	0x00,  /* Reserved1259 */
	0x01,  /* LOW_POWER_ENABLE */
	0x08,  /* ACT_INTRVL0 */
	0x03, 0x00,  /* ACT_LFT_INTRVL0 */
	0x32, 0x00,  /* LP_INTRVL0 */
	0xE8, 0x03,  /* TCH_TMOUT0 */
	0x00,  /* POST_CFG */
	0x00,  /* Reserved1269 */
	0x25, 0x00,  /* CONFIG_VER */
	0x00,  /* SEND_REPORT_AFTER_ACTIVE_INTERVAL_CFG */
	0x00,  /* PIP_REPORTING_DISABLE */
	0x00, 0x00,  /* INTERRUPT_PIN_OVERRIDE */
	0x8F, 0x73,  /* CONFIG_CRC */
};

/* Touchscreen Parameters Field Sizes (Writable: 0:Readonly; 1:Writable) */
static const uint16_t cyttsp4_param_size_pid01[] = {
/*	Size	Name	*/
	2, /* CONFIG_DATA_SIZE */
	2, /* CONFIG_DATA_MAX_SIZE */
	2, /* CROSS_NUM */
	1, /* TX_NUM */
	1, /* RX_NUM */
	1, /* SENS_NUM */
	1, /* BUTTON_NUM */
	1, /* SLOTS_MUT */
	1, /* SLOTS_SELF_RX */
	1, /* SLOTS_SELF_TX */
	1, /* SLOTS_SELF */
	1, /* SENSOR_ASSIGNMENT */
	1, /* SCANNING_MODE_BUTTON */
	1, /* SELF_Z_MODE */
	1, /* CHARGER_ARMOR_ENABLE */
	1, /* WATER_REJ_ENABLE */
	1, /* WF_ENABLE */
	2, /* WF_DETECT_PEAK_THR */
	2, /* WF_DETECT_PEAK_Z9_THR */
	1, /* WF_DETECT_PEAK_Z9_SCALE */
	1, /* WF_DETECT_PEAK_Z8_SCALE */
	1, /* WF_DETECT_PEAK_DEBOUNCE */
	1, /* WF_DETECT_PEAK_COUNT */
	4, /* CA_REVERT_TIME_MS */
	4, /* CA_TOUCH_REVERT_TIME_MS */
	4, /* CA_MAX_XY_MOVEMENT_REVERT */
	1, /* CA_HOST_CTRL */
	1, /* CHARGER_STATUS */
	1, /* CA_TRIG_SRC */
	1, /* WB_CMF_ENABLE */
	1, /* WB_REVERT_THRESH */
	1, /* AFH_HOP_CYCLES_COUNT */
	1, /* NMI_SCAN_CNT */
	1, /* Reserved47 */
	4, /* CA_NMF_LIMIT */
	2, /* NMI_TCH_MAGNITUDE */
	2, /* NMI_TOUCH_THRESH */
	2, /* NMI_THRESH */
	2, /* WB_THRESH */
	2, /* SC_TRIG_THRESH */
	2, /* CA_DYN_CAL_SAFE_RAW_RANGE */
	1, /* CA_DYN_CAL_NUM_SENSOR_THLD_PERCENT */
	1, /* Reserved65 */
	2, /* MAX_MUTUAL_SCAN_INTERVAL */
	2, /* MAX_SELF_SCAN_INTERVAL */
	1, /* CMF_DELTA_TEMPCO_INC */
	1, /* BUTTON_LAYOUT */
	48, /* CDC_SENSOR_MASKS */
	92, /* CDC_PIN_INDEX_TABLE */
	93, /* CDC_REAL_PIN_INDEX_TABLE */
	3, /* Reserved305 */
	8, /* CDC_MTX_PHASE_VECTOR */
	38, /* CDC_MTX_DECONV_COEF */
	2, /* Reserved354 */
	320, /* CDC_SLOT_TABLE */
	1, /* Reserved676 */
	1, /* Reserved677 */
	2, /* Reserved678 */
	2, /* Reserved680 */
	1, /* MC_RAW_FILTER_MASK */
	1, /* MC_RAW_IIR_COEF */
	2, /* MC_RAW_IIR_THRESH */
	2, /* MC_RAW_CMF_THRESH */
	1, /* SC_RAW_FILTER_MASK */
	1, /* SC_RAW_IIR_COEF */
	2, /* SC_RAW_IIR_THRESH */
	2, /* SC_RAW_CMF_THRESH */
	1, /* BTN_MC_RAW_FILTER_MASK */
	1, /* BTN_MC_RAW_IIR_COEF */
	2, /* BTN_MC_RAW_IIR_THRESH */
	2, /* BTN_MC_RAW_CMF_THRESH */
	1, /* BTN_SC_RAW_FILTER_MASK */
	1, /* BTN_SC_RAW_IIR_COEF */
	2, /* BTN_SC_RAW_IIR_THRESH */
	2, /* BTN_SC_RAW_CMF_THRESH */
	1, /* CA_MC_RAW_FILTER_MASK */
	1, /* CA_MC_RAW_IIR_COEF */
	2, /* CA_MC_RAW_IIR_THRESH */
	2, /* CA_MC_RAW_CMF_THRESH */
	1, /* CA_BTN_MC_RAW_FILTER_MASK */
	1, /* CA_BTN_MC_RAW_IIR_COEFF_BUT */
	2, /* CA_BTN_MC_RAW_IIR_THRESH */
	2, /* CA_BTN_MC_RAW_CMF_THRESH */
	1, /* GLOVE_MC_RAW_FILTER_MASK */
	1, /* GLOVE_MC_RAW_IIR_COEF */
	2, /* GLOVE_MC_RAW_IIR_THRESH */
	2, /* GLOVE_MC_RAW_CMF_THRESH */
	1, /* GLOVE_SC_RAW_FILTER_MASK */
	1, /* GLOVE_SC_RAW_IIR_COEF */
	2, /* GLOVE_SC_RAW_IIR_THRESH */
	2, /* GLOVE_SC_RAW_CMF_THRESH */
	1, /* BTN_GLOVE_MC_RAW_FILTER_MASK */
	1, /* BTN_GLOVE_MC_RAW_IIR_COEF */
	2, /* BTN_GLOVE_MC_RAW_IIR_THRESH */
	2, /* BTN_GLOVE_MC_RAW_CMF_THRESH */
	1, /* BTN_GLOVE_SC_RAW_FILTER_MASK */
	1, /* BTN_GLOVE_SC_RAW_IIR_COEF */
	2, /* BTN_GLOVE_SC_RAW_IIR_THRESH */
	2, /* BTN_GLOVE_SC_RAW_CMF_THRESH */
	1, /* STYLUS_MC_RAW_FILTER_MASK */
	1, /* STYLUS_MC_RAW_IIR_COEF */
	2, /* STYLUS_MC_RAW_IIR_THRESH */
	2, /* STYLUS_MC_RAW_CMF_THRESH */
	1, /* STYLUS_SC_RAW_FILTER_MASK */
	1, /* STYLUS_SC_RAW_IIR_COEF */
	2, /* STYLUS_SC_RAW_IIR_THRESH */
	2, /* STYLUS_SC_RAW_CMF_THRESH */
	2, /* WF_RAW_CALC_THRESH */
	2, /* WF_RAW_BASELINE_THRESH */
	2, /* WF_DIFF_CALC_THRESH */
	2, /* WF_RAW_VAR_THRESH */
	2, /* WF_DIFF_VAR_THRESH */
	2, /* WF_LEVEL_THRESH */
	1, /* WF_ENTER_DEBOUNCE */
	1, /* WF_EXIT_DEBOUNCE */
	1, /* SD_CORR_ENABLE */
	1, /* Reserved769 */
	2, /* SD_CORR_MIN_COEF */
	2, /* SD_CORR_MC_TARGET */
	2, /* SD_CORR_SC_THRESH */
	2, /* SD_CORR_MC_SUM_THRESH */
	1, /* FINGER_BL_SNS_WIDTH */
	1, /* FINGER_BL_UPDATE_SPEED */
	2, /* FINGER_BL_THRESH_MC */
	2, /* FINGER_BL_THRESH_SC */
	1, /* GLOVE_BL_SNS_WIDTH */
	1, /* GLOVE_BL_UPDATE_SPEED */
	2, /* GLOVE_BL_THRESH_MC */
	2, /* GLOVE_BL_THRESH_SC */
	1, /* STYLUS_BL_SNS_WIDTH */
	1, /* STYLUS_BL_UPDATE_SPEED */
	2, /* STYLUS_BL_THRESH_MC */
	2, /* STYLUS_BL_THRESH_SC */
	1, /* Reserved796 */
	1, /* BL_UPDATE_SPEED_BTN */
	2, /* BL_THRESH_BTN_MC */
	2, /* BL_THRESH_BTN_SC */
	2, /* Reserved802 */
	4, /* PQ_CTRL */
	4, /* PQ_CTRL2 */
	4, /* PQ_CTRL3 */
	4, /* REFGEN_CTL */
	4, /* RX_CTRL */
	4, /* INFRA_CTRL */
	1, /* STARTUP_DELAY */
	1, /* FORCE_SINGLE_TX */
	2, /* SCALE_FACT_MC */
	2, /* SCALE_FACT_SC */
	2, /* SCALE_FACT_BTN_MC */
	2, /* SCALE_FACT_BTN_SC */
	1, /* TX_PUMP_VOLTAGE */
	1, /* DRV_WEAK_MC */
	1, /* DRV_STRONG_MC */
	1, /* DRV_WEAK_SC */
	1, /* DRV_STRONG_SC */
	1, /* SHIELD_EN_SC */
	1, /* SHIELD_RES_SEL_SC */
	1, /* DISCARD_TIME */
	1, /* VDDA_MODE */
	1, /* Reserved847 */
	1, /* MTX_ORDER */
	1, /* EXT_SYNC */
	1, /* TX_FREQ_METHOD_MC */
	1, /* TX_FREQ_METHOD_SC */
	2, /* NM_WB_TX_PERIOD */
	1, /* NM_WB_TX_PERIOD_DITHER */
	1, /* NM_WB_IDAC */
	1, /* SAFE_RAW_RANGE_PERCENT_MC */
	1, /* SAFE_RAW_RANGE_PERCENT_SC */
	1, /* SAFE_RAW_RANGE_PERCENT_MC_BTN */
	1, /* SAFE_RAW_RANGE_PERCENT_SC_BTN */
	2, /* INT_VOLTAGE_MC */
	2, /* INT_VOLTAGE_SC */
	2, /* INT_VOLTAGE_MC_BTN */
	2, /* INT_VOLTAGE_SC_BTN */
	1, /* BAL_TARGET_MC */
	1, /* BAL_TARGET_SC */
	1, /* BAL_TARGET_MC_BTN */
	1, /* BAL_TARGET_SC_BTN */
	2, /* ILEAK_MAX */
	2, /* VDDA_LEVEL */
	2, /* PUMP_DELAY_US */
	1, /* MC_PWC_LIMIT_PERCENT */
	1, /* SC_PWC_LIMIT_PERCENT */
	1, /* HW_BL_GIDAC_LSB_CONFIG */
	1, /* Reserved881 */
	2, /* TX_PERIOD_MC */
	2, /* CA_HOP0_TX_PERIOD_MC */
	2, /* CA_HOP1_TX_PERIOD_MC */
	2, /* CA_HOP2_TX_PERIOD_MC */
	2, /* TX_PERIOD_SC */
	2, /* TX_PERIOD_BTN_MC */
	2, /* TX_PERIOD_BTN_SC */
	2, /* TX_PULSES_MC */
	2, /* CA_MC_BASE_TX_PULSES_NUM */
	2, /* CA_HOP0_TX_PULSES_MC */
	2, /* CA_HOP1_TX_PULSES_MC */
	2, /* CA_HOP2_TX_PULSES_MC */
	2, /* TX_PULSES_SC */
	2, /* TX_PULSES_BTN_MC */
	2, /* TX_PULSES_BTN_SC */
	2, /* TX_PULSES_GLOVE_MC */
	2, /* TX_PULSES_GLOVE_SC */
	2, /* TX_PULSES_BTN_GLOVE_MC */
	2, /* TX_PULSES_BTN_GLOVE_SC */
	2, /* STYL_TX_PULSES_MC */
	2, /* STYL_TX_PULSES_SC */
	1, /* RX_ATTEN_RES_BYPASS */
	3, /* Reserved925 */
	1, /* BTN_LS_ON_THRSH_MUT_0 */
	1, /* BTN_LS_ON_THRSH_MUT_1 */
	1, /* BTN_LS_ON_THRSH_MUT_2 */
	1, /* BTN_LS_ON_THRSH_MUT_3 */
	1, /* BTN_LS_OFF_THRSH_MUT_0 */
	1, /* BTN_LS_OFF_THRSH_MUT_1 */
	1, /* BTN_LS_OFF_THRSH_MUT_2 */
	1, /* BTN_LS_OFF_THRSH_MUT_3 */
	1, /* BTN_LS_ON_THRSH_SELF_0 */
	1, /* BTN_LS_ON_THRSH_SELF_1 */
	1, /* BTN_LS_ON_THRSH_SELF_2 */
	1, /* BTN_LS_ON_THRSH_SELF_3 */
	1, /* BTN_LS_OFF_THRSH_SELF_0 */
	1, /* BTN_LS_OFF_THRSH_SELF_1 */
	1, /* BTN_LS_OFF_THRSH_SELF_2 */
	1, /* BTN_LS_OFF_THRSH_SELF_3 */
	1, /* BTN_LS_TD_DEBOUNCE */
	1, /* Reserved945 */
	2, /* Reserved946 */
	1, /* BTN_HS_ON_THRSH_MUT_0 */
	1, /* BTN_HS_ON_THRSH_MUT_1 */
	1, /* BTN_HS_ON_THRSH_MUT_2 */
	1, /* BTN_HS_ON_THRSH_MUT_3 */
	1, /* BTN_HS_OFF_THRSH_MUT_0 */
	1, /* BTN_HS_OFF_THRSH_MUT_1 */
	1, /* BTN_HS_OFF_THRSH_MUT_2 */
	1, /* BTN_HS_OFF_THRSH_MUT_3 */
	1, /* BTN_HS_ON_THRSH_SELF_0 */
	1, /* BTN_HS_ON_THRSH_SELF_1 */
	1, /* BTN_HS_ON_THRSH_SELF_2 */
	1, /* BTN_HS_ON_THRSH_SELF_3 */
	1, /* BTN_HS_OFF_THRSH_SELF_0 */
	1, /* BTN_HS_OFF_THRSH_SELF_1 */
	1, /* BTN_HS_OFF_THRSH_SELF_2 */
	1, /* BTN_HS_OFF_THRSH_SELF_3 */
	1, /* BTN_HS_TOUCHDOWN_DEBOUNCE */
	1, /* Reserved965 */
	2, /* Reserved966 */
	2, /* BTN_HIGHSEN_MODE_THRSH_MUT */
	2, /* BTN_HIGHSEN_MODE_THRSH_SELF */
	2, /* BTN_LOWSEN_MODE_THRSH_MUT */
	2, /* BTN_LOWSEN_MODE_THRSH_SELF */
	1, /* GLOVE_BTN_FORBID_DEBOUNCE */
	1, /* GLOVE_BTN_MODE_SWITCH_DEBOUNCE */
	1, /* BTN_PROCESS_IF_TOUCH_DETECTED */
	1, /* Reserved979 */
	2, /* FINGER_THRESH_MUT_HI */
	2, /* FINGER_THRESH_MUT_LO */
	2, /* FINGER_THRESH_SELF */
	1, /* FINGER_Z9_FILT_SCALE */
	1, /* FINGER_Z8_FILT_SCALE */
	1, /* MIN_FAT_FINGER_SIZE */
	1, /* MIN_FAT_FINGER_SIZE_HYST */
	1, /* MAX_FAT_FINGER_SIZE */
	1, /* MAX_FAT_FINGER_SIZE_HYST */
	1, /* FINGER_SIG_THRESH_MULT */
	1, /* FINGER_OBJECT_FEATURES */
	2, /* FINGER_Z_SCALE */
	1, /* FINGER_INNER_EDGE_GAIN */
	1, /* FINGER_OUTER_EDGE_GAIN */
	1, /* FINGER_POS_CALC_METHOD */
	1, /* Reserved999 */
	2, /* CA_FINGER_THRESH_MUT_HI */
	2, /* CA_FINGER_THRESH_MUT_LO */
	1, /* FINGER_MT_DEBOUNCE */
	1, /* CA_FINGER_MT_DEBOUNCE */
	1, /* CA_FINGER_FT_DEBOUNCE */
	1, /* CA_FINGER_Z9_FILT_SCALE */
	1, /* CA_MIN_FAT_FINGER_SIZE */
	1, /* CA_MAX_FAT_FINGER_SIZE */
	1, /* WF_THRESH_MUT_COEF */
	1, /* WF_MT_DEBOUNCE */
	1, /* TOUCHMODE_FRAME_NUM_TO_CONFIRM_FINGER_MODE */
	3, /* Reserved1013 */
	2, /* GLOVES_THRESH_MUT_HI */
	2, /* GLOVES_THRESH_MUT_LO */
	2, /* GLOVES_THRESH_SELF */
	1, /* GLOVES_Z9_FILT_SCALE */
	1, /* GLOVES_Z8_FILT_SCALE */
	1, /* GLOVES_MIN_FAT_SIZE */
	1, /* GLOVES_MIN_FAT_SIZE_HYST */
	1, /* GLOVES_MAX_FAT_SIZE */
	1, /* GLOVES_MAX_FAT_SIZE_HYST */
	1, /* GLOVES_SIG_THRESH_MULT */
	1, /* GLOVES_OBJECT_FEATURES */
	2, /* GLOVES_Z_SCALE */
	1, /* GLOVES_INNER_EDGE_GAIN */
	1, /* GLOVES_OUTER_EDGE_GAIN */
	1, /* GLOVES_POS_CALC_METHOD */
	1, /* Reserved1035 */
	2, /* TOUCHMODE_GLOVE_HTI */
	2, /* TOUCHMODE_GLOVE_MAX_SIG_SUM */
	1, /* GLOVES_FT_DEBOUNCE */
	1, /* GLOVES_FT_DEBOUNCE_EDGE_MASK */
	1, /* GLOVES_MT_DEBOUNCE */
	1, /* GLOVES_GRIP_FILT_SCALE */
	1, /* TOUCHMODE_FRAME_NUM_TO_CONFIRM_GLOVE_MODE */
	1, /* GLOVES_MAX_ACCEPTABLE_NOISE_LEVEL */
	2, /* Reserved1046 */
	2, /* STYLUS_THRESH_MUT_HI */
	2, /* STYLUS_THRESH_MUT_LO */
	2, /* STYLUS_THRESH_SELF */
	1, /* STYLUS_Z9_FILT_SCALE */
	1, /* STYLUS_Z8_FILT_SCALE */
	2, /* STYLUS_Z_SCALE */
	1, /* STYLUS_INNER_EDGE_GAIN */
	1, /* STYLUS_OUTER_EDGE_GAIN */
	1, /* STYLUS_POS_CALC_METHOD */
	1, /* Reserved1061 */
	2, /* TOUCHMODE_STYLUS_HTI */
	2, /* TOUCHMODE_STYLUS_MAX_SIG_SUM */
	2, /* STYLUS_HOVER_COEF */
	2, /* STYLUS_CM_EDGE */
	2, /* STYLUS_CONST_MASS */
	1, /* STYLUS_CM_GAIN */
	1, /* STYLUS_CM_COEF */
	1, /* STYLUS_PERIODIC_ERROR_AMPLITUDE */
	1, /* STYLUS_PALM_CLEARANCE */
	1, /* TOUCHMODE_FRAME_NUM_TO_CONFIRM_STYLUS_MODE */
	1, /* STYLUS_MAX_ACCEPTABLE_NOISE_LEVEL */
	2, /* Reserved1078 */
	2, /* TOUCHMODE_FINGER_SWITCH_DEBOUNCE */
	2, /* TOUCHMODE_FINGER_EXIT_DELAY */
	2, /* TOUCHMODE_GLOVE_SWITCH_DEBOUNCE */
	2, /* TOUCHMODE_GLOVE_EXIT_DELAY */
	2, /* TOUCHMODE_GLOVE_FINGER_SWITCH_DEBOUNCE */
	2, /* TOUCHMODE_FINGER_GLOVE_SWITCH_DEBOUNCE */
	2, /* TOUCHMODE_STYLUS_SWITCH_DEBOUNCE */
	2, /* TOUCHMODE_STYLUS_EXIT_DELAY */
	2, /* TOUCHMODE_FINGER_STYLUS_SWITCH_DEBOUNCE */
	2, /* Reserved1098 */
	2, /* ACT_DIST0_SQR */
	2, /* ACT_DIST2_SQR */
	2, /* ACT_DIST_TOUCHDOWN_SQR */
	2, /* ACT_DIST_LIFTOFF_SQR */
	1, /* ACT_DIST_Z_THRESHOLD */
	1, /* LARGE_OBJ_CFG */
	2, /* Reserved1110 */
	1, /* XY_FILTER_MASK */
	1, /* XY_FILT_IIR_COEF_SLOW */
	1, /* XY_FILT_IIR_COEF_FAST */
	1, /* XY_FILT_XY_THR_SLOW */
	1, /* XY_FILT_XY_THR_FAST */
	1, /* XY_FILT_Z_IIR_COEFF */
	1, /* XY_FILT_PREDICTION_COEF */
	1, /* Reserved1119 */
	1, /* XY_FILTER_MASK_CA */
	1, /* XY_FILT_IIR_COEF_SLOW_CA */
	1, /* XY_FILT_IIR_COEF_FAST_CA */
	1, /* XY_FILT_XY_THR_SLOW_CA */
	1, /* XY_FILT_XY_THR_FAST_CA */
	1, /* XY_FILT_Z_IIR_COEFF_CA */
	1, /* XY_FILT_PREDICTION_COEF_CA */
	1, /* Reserved1127 */
	1, /* XY_FILT_AXIS_IIR_COEF */
	1, /* XY_FILT_AXIS_HYST */
	1, /* XY_FILT_ANGLE_IIR_COEF */
	1, /* XY_FILT_ANGLE_HYST */
	4, /* MAX_VELOCITY_SQR */
	4, /* FINGER_ID_MAX_FINGER_ACCELERATION2 */
	2, /* GRIP_XEDG_A */
	2, /* GRIP_XEDG_B */
	2, /* GRIP_XEXC_A */
	2, /* GRIP_XEXC_B */
	2, /* GRIP_YEDG_A */
	2, /* GRIP_YEDG_B */
	2, /* GRIP_YEXC_A */
	2, /* GRIP_YEXC_B */
	1, /* GRIP_FIRST_EXC */
	1, /* GRIP_EXC_EDGE_ORIGIN */
	1, /* GRIP_ENABLE */
	1, /* FINGER_LIFTOFF_DEBOUNCE */
	1, /* GLOVE_LIFTOFF_DEBOUNCE */
	1, /* STYLUS_LIFTOFF_DEBOUNCE */
	2, /* Reserved1162 */
	1, /* WATER_REJ_SNS_WIDTH */
	1, /* SLIM_POSITION_OFFSET_ALONG_TX */
	1, /* SLIM_POSITION_OFFSET_ALONG_RX */
	1, /* WET_FINGER_Z8_MULT */
	4, /* MIN_FF_Z9 */
	4, /* MAX_MF_Z9 */
	4, /* MIN_FF_SIG_SUM_EDGE */
	1, /* MF_CENTERSIG_RATIO */
	1, /* SD_SIZE_THRESH */
	2, /* SD_SIG_THRESH_ON */
	2, /* SD_SIG_THRESH_OFF */
	2, /* VP_DLT_RST_THRESH */
	2, /* VP_DLT_THRESH */
	1, /* FAT_AXIS_LENGTH_THRESH */
	1, /* PEAK_IGNORE_COEF */
	1, /* AXIS_ORIENTATION_ENABLE */
	3, /* Reserved1193 */
	1, /* CLIPPING_X_LOW */
	1, /* CLIPPING_X_HIGH */
	1, /* CLIPPING_Y_LOW */
	1, /* CLIPPING_Y_HIGH */
	2, /* CALC_THRESH */
	2, /* OFFSET_S1 */
	2, /* OFFSET_S2 */
	2, /* Z_SUM_8MM */
	2, /* Z_SUM_4MM */
	2, /* Z_SUM_3MM */
	2, /* Z_SUM_1MM */
	2, /* LOW_PIVOT */
	2, /* HIGH_PIVOT */
	2, /* LOW_PIVOT2 */
	2, /* HIGH_PIVOT2 */
	2, /* EDGE_DEBOUNCE_THRESH */
	2, /* CENTER_MAGNITUDE_SCALE */
	2, /* CENTROID_CORNER_GAIN */
	1, /* EDGE_DEBOUNCE_COUNT */
	1, /* BR2_ALWAYS_ON_FLAG */
	1, /* PREFERRED_TOUCH_SIZE */
	1, /* TOUCH_SIZE_METHOD */
	1, /* RXLINE_FILT_ENABLE */
	1, /* RXLINE_FILT_DEBOUNCE */
	1, /* RXLINE_FILT_THRESH */
	1, /* Reserved1235 */
	2, /* TOUCHMODE_LFT_SELF_THRSH */
	2, /* TOUCHMODE_LFT_NEG_SC_THRESH */
	2, /* TOUCHMODE_LFT_NEG_MC_THRESH */
	2, /* X_RESOLUTION */
	2, /* Y_RESOLUTION */
	2, /* X_LENGTH_100xMM */
	2, /* Y_LENGTH_100xMM */
	1, /* X_PITCH_10xMM */
	1, /* Y_PITCH_10xMM */
	1, /* Reserved1252 */
	1, /* ACT_LFT_EN */
	1, /* TOUCHMODE_CONFIG */
	1, /* LRG_OBJ_CFG */
	1, /* MAX_REPORTED_TOUCH_NUM */
	1, /* REPORT_CFG */
	1, /* TOUCHMODE_STYLUS_HIGH_PRIORITY */
	1, /* Reserved1259 */
	1, /* LOW_POWER_ENABLE */
	1, /* ACT_INTRVL0 */
	2, /* ACT_LFT_INTRVL0 */
	2, /* LP_INTRVL0 */
	2, /* TCH_TMOUT0 */
	1, /* POST_CFG */
	1, /* Reserved1269 */
	2, /* CONFIG_VER */
	1, /* SEND_REPORT_AFTER_ACTIVE_INTERVAL_CFG */
	1, /* PIP_REPORTING_DISABLE */
	2, /* INTERRUPT_PIN_OVERRIDE */
	2, /* CONFIG_CRC */
};

/* Touchscreen Parameters Field Address*/
static const uint8_t cyttsp4_param_addr_pid01[] = {
/*	Address	Name	*/
	0xE1, 0x00, /* CONFIG_DATA_SIZE */
	0xE1, 0x02, /* CONFIG_DATA_MAX_SIZE */
	0xE1, 0x04, /* CROSS_NUM */
	0xE1, 0x06, /* TX_NUM */
	0xE1, 0x07, /* RX_NUM */
	0xE1, 0x08, /* SENS_NUM */
	0xE1, 0x09, /* BUTTON_NUM */
	0xE1, 0x0A, /* SLOTS_MUT */
	0xE1, 0x0B, /* SLOTS_SELF_RX */
	0xE1, 0x0C, /* SLOTS_SELF_TX */
	0xE1, 0x0D, /* SLOTS_SELF */
	0xE1, 0x0E, /* SENSOR_ASSIGNMENT */
	0xE1, 0x0F, /* SCANNING_MODE_BUTTON */
	0xE1, 0x10, /* SELF_Z_MODE */
	0xE1, 0x11, /* CHARGER_ARMOR_ENABLE */
	0xE1, 0x12, /* WATER_REJ_ENABLE */
	0xE1, 0x13, /* WF_ENABLE */
	0xE1, 0x14, /* WF_DETECT_PEAK_THR */
	0xE1, 0x16, /* WF_DETECT_PEAK_Z9_THR */
	0xE1, 0x18, /* WF_DETECT_PEAK_Z9_SCALE */
	0xE1, 0x19, /* WF_DETECT_PEAK_Z8_SCALE */
	0xE1, 0x1A, /* WF_DETECT_PEAK_DEBOUNCE */
	0xE1, 0x1B, /* WF_DETECT_PEAK_COUNT */
	0xE1, 0x1C, /* CA_REVERT_TIME_MS */
	0xE1, 0x20, /* CA_TOUCH_REVERT_TIME_MS */
	0xE1, 0x24, /* CA_MAX_XY_MOVEMENT_REVERT */
	0xE1, 0x28, /* CA_HOST_CTRL */
	0xE1, 0x29, /* CHARGER_STATUS */
	0xE1, 0x2A, /* CA_TRIG_SRC */
	0xE1, 0x2B, /* WB_CMF_ENABLE */
	0xE1, 0x2C, /* WB_REVERT_THRESH */
	0xE1, 0x2D, /* AFH_HOP_CYCLES_COUNT */
	0xE1, 0x2E, /* NMI_SCAN_CNT */
	0xE1, 0x2F, /* Reserved47 */
	0xE1, 0x30, /* CA_NMF_LIMIT */
	0xE1, 0x34, /* NMI_TCH_MAGNITUDE */
	0xE1, 0x36, /* NMI_TOUCH_THRESH */
	0xE1, 0x38, /* NMI_THRESH */
	0xE1, 0x3A, /* WB_THRESH */
	0xE1, 0x3C, /* SC_TRIG_THRESH */
	0xE1, 0x3E, /* CA_DYN_CAL_SAFE_RAW_RANGE */
	0xE1, 0x40, /* CA_DYN_CAL_NUM_SENSOR_THLD_PERCENT */
	0xE1, 0x41, /* Reserved65 */
	0xE1, 0x42, /* MAX_MUTUAL_SCAN_INTERVAL */
	0xE1, 0x44, /* MAX_SELF_SCAN_INTERVAL */
	0xE1, 0x46, /* CMF_DELTA_TEMPCO_INC */
	0xE1, 0x47, /* BUTTON_LAYOUT */
	0xE1, 0x48, /* CDC_SENSOR_MASKS */
	0xE1, 0x78, /* CDC_PIN_INDEX_TABLE */
	0xE1, 0xD4, /* CDC_REAL_PIN_INDEX_TABLE */
	0xE2, 0x31, /* Reserved305 */
	0xE2, 0x34, /* CDC_MTX_PHASE_VECTOR */
	0xE2, 0x3C, /* CDC_MTX_DECONV_COEF */
	0xE2, 0x62, /* Reserved354 */
	0xE2, 0x64, /* CDC_SLOT_TABLE */
	0xE3, 0xA4, /* Reserved676 */
	0xE3, 0xA5, /* Reserved677 */
	0xE3, 0xA6, /* Reserved678 */
	0xE3, 0xA8, /* Reserved680 */
	0xE3, 0xAA, /* MC_RAW_FILTER_MASK */
	0xE3, 0xAB, /* MC_RAW_IIR_COEF */
	0xE3, 0xAC, /* MC_RAW_IIR_THRESH */
	0xE3, 0xAE, /* MC_RAW_CMF_THRESH */
	0xE3, 0xB0, /* SC_RAW_FILTER_MASK */
	0xE3, 0xB1, /* SC_RAW_IIR_COEF */
	0xE3, 0xB2, /* SC_RAW_IIR_THRESH */
	0xE3, 0xB4, /* SC_RAW_CMF_THRESH */
	0xE3, 0xB6, /* BTN_MC_RAW_FILTER_MASK */
	0xE3, 0xB7, /* BTN_MC_RAW_IIR_COEF */
	0xE3, 0xB8, /* BTN_MC_RAW_IIR_THRESH */
	0xE3, 0xBA, /* BTN_MC_RAW_CMF_THRESH */
	0xE3, 0xBC, /* BTN_SC_RAW_FILTER_MASK */
	0xE3, 0xBD, /* BTN_SC_RAW_IIR_COEF */
	0xE3, 0xBE, /* BTN_SC_RAW_IIR_THRESH */
	0xE3, 0xC0, /* BTN_SC_RAW_CMF_THRESH */
	0xE3, 0xC2, /* CA_MC_RAW_FILTER_MASK */
	0xE3, 0xC3, /* CA_MC_RAW_IIR_COEF */
	0xE3, 0xC4, /* CA_MC_RAW_IIR_THRESH */
	0xE3, 0xC6, /* CA_MC_RAW_CMF_THRESH */
	0xE3, 0xC8, /* CA_BTN_MC_RAW_FILTER_MASK */
	0xE3, 0xC9, /* CA_BTN_MC_RAW_IIR_COEFF_BUT */
	0xE3, 0xCA, /* CA_BTN_MC_RAW_IIR_THRESH */
	0xE3, 0xCC, /* CA_BTN_MC_RAW_CMF_THRESH */
	0xE3, 0xCE, /* GLOVE_MC_RAW_FILTER_MASK */
	0xE3, 0xCF, /* GLOVE_MC_RAW_IIR_COEF */
	0xE3, 0xD0, /* GLOVE_MC_RAW_IIR_THRESH */
	0xE3, 0xD2, /* GLOVE_MC_RAW_CMF_THRESH */
	0xE3, 0xD4, /* GLOVE_SC_RAW_FILTER_MASK */
	0xE3, 0xD5, /* GLOVE_SC_RAW_IIR_COEF */
	0xE3, 0xD6, /* GLOVE_SC_RAW_IIR_THRESH */
	0xE3, 0xD8, /* GLOVE_SC_RAW_CMF_THRESH */
	0xE3, 0xDA, /* BTN_GLOVE_MC_RAW_FILTER_MASK */
	0xE3, 0xDB, /* BTN_GLOVE_MC_RAW_IIR_COEF */
	0xE3, 0xDC, /* BTN_GLOVE_MC_RAW_IIR_THRESH */
	0xE3, 0xDE, /* BTN_GLOVE_MC_RAW_CMF_THRESH */
	0xE3, 0xE0, /* BTN_GLOVE_SC_RAW_FILTER_MASK */
	0xE3, 0xE1, /* BTN_GLOVE_SC_RAW_IIR_COEF */
	0xE3, 0xE2, /* BTN_GLOVE_SC_RAW_IIR_THRESH */
	0xE3, 0xE4, /* BTN_GLOVE_SC_RAW_CMF_THRESH */
	0xE3, 0xE6, /* STYLUS_MC_RAW_FILTER_MASK */
	0xE3, 0xE7, /* STYLUS_MC_RAW_IIR_COEF */
	0xE3, 0xE8, /* STYLUS_MC_RAW_IIR_THRESH */
	0xE3, 0xEA, /* STYLUS_MC_RAW_CMF_THRESH */
	0xE3, 0xEC, /* STYLUS_SC_RAW_FILTER_MASK */
	0xE3, 0xED, /* STYLUS_SC_RAW_IIR_COEF */
	0xE3, 0xEE, /* STYLUS_SC_RAW_IIR_THRESH */
	0xE3, 0xF0, /* STYLUS_SC_RAW_CMF_THRESH */
	0xE3, 0xF2, /* WF_RAW_CALC_THRESH */
	0xE3, 0xF4, /* WF_RAW_BASELINE_THRESH */
	0xE3, 0xF6, /* WF_DIFF_CALC_THRESH */
	0xE3, 0xF8, /* WF_RAW_VAR_THRESH */
	0xE3, 0xFA, /* WF_DIFF_VAR_THRESH */
	0xE3, 0xFC, /* WF_LEVEL_THRESH */
	0xE3, 0xFE, /* WF_ENTER_DEBOUNCE */
	0xE3, 0xFF, /* WF_EXIT_DEBOUNCE */
	0xE4, 0x00, /* SD_CORR_ENABLE */
	0xE4, 0x01, /* Reserved769 */
	0xE4, 0x02, /* SD_CORR_MIN_COEF */
	0xE4, 0x04, /* SD_CORR_MC_TARGET */
	0xE4, 0x06, /* SD_CORR_SC_THRESH */
	0xE4, 0x08, /* SD_CORR_MC_SUM_THRESH */
	0xE4, 0x0A, /* FINGER_BL_SNS_WIDTH */
	0xE4, 0x0B, /* FINGER_BL_UPDATE_SPEED */
	0xE4, 0x0C, /* FINGER_BL_THRESH_MC */
	0xE4, 0x0E, /* FINGER_BL_THRESH_SC */
	0xE4, 0x10, /* GLOVE_BL_SNS_WIDTH */
	0xE4, 0x11, /* GLOVE_BL_UPDATE_SPEED */
	0xE4, 0x12, /* GLOVE_BL_THRESH_MC */
	0xE4, 0x14, /* GLOVE_BL_THRESH_SC */
	0xE4, 0x16, /* STYLUS_BL_SNS_WIDTH */
	0xE4, 0x17, /* STYLUS_BL_UPDATE_SPEED */
	0xE4, 0x18, /* STYLUS_BL_THRESH_MC */
	0xE4, 0x1A, /* STYLUS_BL_THRESH_SC */
	0xE4, 0x1C, /* Reserved796 */
	0xE4, 0x1D, /* BL_UPDATE_SPEED_BTN */
	0xE4, 0x1E, /* BL_THRESH_BTN_MC */
	0xE4, 0x20, /* BL_THRESH_BTN_SC */
	0xE4, 0x22, /* Reserved802 */
	0xE4, 0x24, /* PQ_CTRL */
	0xE4, 0x28, /* PQ_CTRL2 */
	0xE4, 0x2C, /* PQ_CTRL3 */
	0xE4, 0x30, /* REFGEN_CTL */
	0xE4, 0x34, /* RX_CTRL */
	0xE4, 0x38, /* INFRA_CTRL */
	0xE4, 0x3C, /* STARTUP_DELAY */
	0xE4, 0x3D, /* FORCE_SINGLE_TX */
	0xE4, 0x3E, /* SCALE_FACT_MC */
	0xE4, 0x40, /* SCALE_FACT_SC */
	0xE4, 0x42, /* SCALE_FACT_BTN_MC */
	0xE4, 0x44, /* SCALE_FACT_BTN_SC */
	0xE4, 0x46, /* TX_PUMP_VOLTAGE */
	0xE4, 0x47, /* DRV_WEAK_MC */
	0xE4, 0x48, /* DRV_STRONG_MC */
	0xE4, 0x49, /* DRV_WEAK_SC */
	0xE4, 0x4A, /* DRV_STRONG_SC */
	0xE4, 0x4B, /* SHIELD_EN_SC */
	0xE4, 0x4C, /* SHIELD_RES_SEL_SC */
	0xE4, 0x4D, /* DISCARD_TIME */
	0xE4, 0x4E, /* VDDA_MODE */
	0xE4, 0x4F, /* Reserved847 */
	0xE4, 0x50, /* MTX_ORDER */
	0xE4, 0x51, /* EXT_SYNC */
	0xE4, 0x52, /* TX_FREQ_METHOD_MC */
	0xE4, 0x53, /* TX_FREQ_METHOD_SC */
	0xE4, 0x54, /* NM_WB_TX_PERIOD */
	0xE4, 0x56, /* NM_WB_TX_PERIOD_DITHER */
	0xE4, 0x57, /* NM_WB_IDAC */
	0xE4, 0x58, /* SAFE_RAW_RANGE_PERCENT_MC */
	0xE4, 0x59, /* SAFE_RAW_RANGE_PERCENT_SC */
	0xE4, 0x5A, /* SAFE_RAW_RANGE_PERCENT_MC_BTN */
	0xE4, 0x5B, /* SAFE_RAW_RANGE_PERCENT_SC_BTN */
	0xE4, 0x5C, /* INT_VOLTAGE_MC */
	0xE4, 0x5E, /* INT_VOLTAGE_SC */
	0xE4, 0x60, /* INT_VOLTAGE_MC_BTN */
	0xE4, 0x62, /* INT_VOLTAGE_SC_BTN */
	0xE4, 0x64, /* BAL_TARGET_MC */
	0xE4, 0x65, /* BAL_TARGET_SC */
	0xE4, 0x66, /* BAL_TARGET_MC_BTN */
	0xE4, 0x67, /* BAL_TARGET_SC_BTN */
	0xE4, 0x68, /* ILEAK_MAX */
	0xE4, 0x6A, /* VDDA_LEVEL */
	0xE4, 0x6C, /* PUMP_DELAY_US */
	0xE4, 0x6E, /* MC_PWC_LIMIT_PERCENT */
	0xE4, 0x6F, /* SC_PWC_LIMIT_PERCENT */
	0xE4, 0x70, /* HW_BL_GIDAC_LSB_CONFIG */
	0xE4, 0x71, /* Reserved881 */
	0xE4, 0x72, /* TX_PERIOD_MC */
	0xE4, 0x74, /* CA_HOP0_TX_PERIOD_MC */
	0xE4, 0x76, /* CA_HOP1_TX_PERIOD_MC */
	0xE4, 0x78, /* CA_HOP2_TX_PERIOD_MC */
	0xE4, 0x7A, /* TX_PERIOD_SC */
	0xE4, 0x7C, /* TX_PERIOD_BTN_MC */
	0xE4, 0x7E, /* TX_PERIOD_BTN_SC */
	0xE4, 0x80, /* TX_PULSES_MC */
	0xE4, 0x82, /* CA_MC_BASE_TX_PULSES_NUM */
	0xE4, 0x84, /* CA_HOP0_TX_PULSES_MC */
	0xE4, 0x86, /* CA_HOP1_TX_PULSES_MC */
	0xE4, 0x88, /* CA_HOP2_TX_PULSES_MC */
	0xE4, 0x8A, /* TX_PULSES_SC */
	0xE4, 0x8C, /* TX_PULSES_BTN_MC */
	0xE4, 0x8E, /* TX_PULSES_BTN_SC */
	0xE4, 0x90, /* TX_PULSES_GLOVE_MC */
	0xE4, 0x92, /* TX_PULSES_GLOVE_SC */
	0xE4, 0x94, /* TX_PULSES_BTN_GLOVE_MC */
	0xE4, 0x96, /* TX_PULSES_BTN_GLOVE_SC */
	0xE4, 0x98, /* STYL_TX_PULSES_MC */
	0xE4, 0x9A, /* STYL_TX_PULSES_SC */
	0xE4, 0x9C, /* RX_ATTEN_RES_BYPASS */
	0xE4, 0x9D, /* Reserved925 */
	0xE4, 0xA0, /* BTN_LS_ON_THRSH_MUT_0 */
	0xE4, 0xA1, /* BTN_LS_ON_THRSH_MUT_1 */
	0xE4, 0xA2, /* BTN_LS_ON_THRSH_MUT_2 */
	0xE4, 0xA3, /* BTN_LS_ON_THRSH_MUT_3 */
	0xE4, 0xA4, /* BTN_LS_OFF_THRSH_MUT_0 */
	0xE4, 0xA5, /* BTN_LS_OFF_THRSH_MUT_1 */
	0xE4, 0xA6, /* BTN_LS_OFF_THRSH_MUT_2 */
	0xE4, 0xA7, /* BTN_LS_OFF_THRSH_MUT_3 */
	0xE4, 0xA8, /* BTN_LS_ON_THRSH_SELF_0 */
	0xE4, 0xA9, /* BTN_LS_ON_THRSH_SELF_1 */
	0xE4, 0xAA, /* BTN_LS_ON_THRSH_SELF_2 */
	0xE4, 0xAB, /* BTN_LS_ON_THRSH_SELF_3 */
	0xE4, 0xAC, /* BTN_LS_OFF_THRSH_SELF_0 */
	0xE4, 0xAD, /* BTN_LS_OFF_THRSH_SELF_1 */
	0xE4, 0xAE, /* BTN_LS_OFF_THRSH_SELF_2 */
	0xE4, 0xAF, /* BTN_LS_OFF_THRSH_SELF_3 */
	0xE4, 0xB0, /* BTN_LS_TD_DEBOUNCE */
	0xE4, 0xB1, /* Reserved945 */
	0xE4, 0xB2, /* Reserved946 */
	0xE4, 0xB4, /* BTN_HS_ON_THRSH_MUT_0 */
	0xE4, 0xB5, /* BTN_HS_ON_THRSH_MUT_1 */
	0xE4, 0xB6, /* BTN_HS_ON_THRSH_MUT_2 */
	0xE4, 0xB7, /* BTN_HS_ON_THRSH_MUT_3 */
	0xE4, 0xB8, /* BTN_HS_OFF_THRSH_MUT_0 */
	0xE4, 0xB9, /* BTN_HS_OFF_THRSH_MUT_1 */
	0xE4, 0xBA, /* BTN_HS_OFF_THRSH_MUT_2 */
	0xE4, 0xBB, /* BTN_HS_OFF_THRSH_MUT_3 */
	0xE4, 0xBC, /* BTN_HS_ON_THRSH_SELF_0 */
	0xE4, 0xBD, /* BTN_HS_ON_THRSH_SELF_1 */
	0xE4, 0xBE, /* BTN_HS_ON_THRSH_SELF_2 */
	0xE4, 0xBF, /* BTN_HS_ON_THRSH_SELF_3 */
	0xE4, 0xC0, /* BTN_HS_OFF_THRSH_SELF_0 */
	0xE4, 0xC1, /* BTN_HS_OFF_THRSH_SELF_1 */
	0xE4, 0xC2, /* BTN_HS_OFF_THRSH_SELF_2 */
	0xE4, 0xC3, /* BTN_HS_OFF_THRSH_SELF_3 */
	0xE4, 0xC4, /* BTN_HS_TOUCHDOWN_DEBOUNCE */
	0xE4, 0xC5, /* Reserved965 */
	0xE4, 0xC6, /* Reserved966 */
	0xE4, 0xC8, /* BTN_HIGHSEN_MODE_THRSH_MUT */
	0xE4, 0xCA, /* BTN_HIGHSEN_MODE_THRSH_SELF */
	0xE4, 0xCC, /* BTN_LOWSEN_MODE_THRSH_MUT */
	0xE4, 0xCE, /* BTN_LOWSEN_MODE_THRSH_SELF */
	0xE4, 0xD0, /* GLOVE_BTN_FORBID_DEBOUNCE */
	0xE4, 0xD1, /* GLOVE_BTN_MODE_SWITCH_DEBOUNCE */
	0xE4, 0xD2, /* BTN_PROCESS_IF_TOUCH_DETECTED */
	0xE4, 0xD3, /* Reserved979 */
	0xE4, 0xD4, /* FINGER_THRESH_MUT_HI */
	0xE4, 0xD6, /* FINGER_THRESH_MUT_LO */
	0xE4, 0xD8, /* FINGER_THRESH_SELF */
	0xE4, 0xDA, /* FINGER_Z9_FILT_SCALE */
	0xE4, 0xDB, /* FINGER_Z8_FILT_SCALE */
	0xE4, 0xDC, /* MIN_FAT_FINGER_SIZE */
	0xE4, 0xDD, /* MIN_FAT_FINGER_SIZE_HYST */
	0xE4, 0xDE, /* MAX_FAT_FINGER_SIZE */
	0xE4, 0xDF, /* MAX_FAT_FINGER_SIZE_HYST */
	0xE4, 0xE0, /* FINGER_SIG_THRESH_MULT */
	0xE4, 0xE1, /* FINGER_OBJECT_FEATURES */
	0xE4, 0xE2, /* FINGER_Z_SCALE */
	0xE4, 0xE4, /* FINGER_INNER_EDGE_GAIN */
	0xE4, 0xE5, /* FINGER_OUTER_EDGE_GAIN */
	0xE4, 0xE6, /* FINGER_POS_CALC_METHOD */
	0xE4, 0xE7, /* Reserved999 */
	0xE4, 0xE8, /* CA_FINGER_THRESH_MUT_HI */
	0xE4, 0xEA, /* CA_FINGER_THRESH_MUT_LO */
	0xE4, 0xEC, /* FINGER_MT_DEBOUNCE */
	0xE4, 0xED, /* CA_FINGER_MT_DEBOUNCE */
	0xE4, 0xEE, /* CA_FINGER_FT_DEBOUNCE */
	0xE4, 0xEF, /* CA_FINGER_Z9_FILT_SCALE */
	0xE4, 0xF0, /* CA_MIN_FAT_FINGER_SIZE */
	0xE4, 0xF1, /* CA_MAX_FAT_FINGER_SIZE */
	0xE4, 0xF2, /* WF_THRESH_MUT_COEF */
	0xE4, 0xF3, /* WF_MT_DEBOUNCE */
	0xE4, 0xF4, /* TOUCHMODE_FRAME_NUM_TO_CONFIRM_FINGER_MODE */
	0xE4, 0xF5, /* Reserved1013 */
	0xE4, 0xF8, /* GLOVES_THRESH_MUT_HI */
	0xE4, 0xFA, /* GLOVES_THRESH_MUT_LO */
	0xE4, 0xFC, /* GLOVES_THRESH_SELF */
	0xE4, 0xFE, /* GLOVES_Z9_FILT_SCALE */
	0xE4, 0xFF, /* GLOVES_Z8_FILT_SCALE */
	0xE5, 0x00, /* GLOVES_MIN_FAT_SIZE */
	0xE5, 0x01, /* GLOVES_MIN_FAT_SIZE_HYST */
	0xE5, 0x02, /* GLOVES_MAX_FAT_SIZE */
	0xE5, 0x03, /* GLOVES_MAX_FAT_SIZE_HYST */
	0xE5, 0x04, /* GLOVES_SIG_THRESH_MULT */
	0xE5, 0x05, /* GLOVES_OBJECT_FEATURES */
	0xE5, 0x06, /* GLOVES_Z_SCALE */
	0xE5, 0x08, /* GLOVES_INNER_EDGE_GAIN */
	0xE5, 0x09, /* GLOVES_OUTER_EDGE_GAIN */
	0xE5, 0x0A, /* GLOVES_POS_CALC_METHOD */
	0xE5, 0x0B, /* Reserved1035 */
	0xE5, 0x0C, /* TOUCHMODE_GLOVE_HTI */
	0xE5, 0x0E, /* TOUCHMODE_GLOVE_MAX_SIG_SUM */
	0xE5, 0x10, /* GLOVES_FT_DEBOUNCE */
	0xE5, 0x11, /* GLOVES_FT_DEBOUNCE_EDGE_MASK */
	0xE5, 0x12, /* GLOVES_MT_DEBOUNCE */
	0xE5, 0x13, /* GLOVES_GRIP_FILT_SCALE */
	0xE5, 0x14, /* TOUCHMODE_FRAME_NUM_TO_CONFIRM_GLOVE_MODE */
	0xE5, 0x15, /* GLOVES_MAX_ACCEPTABLE_NOISE_LEVEL */
	0xE5, 0x16, /* Reserved1046 */
	0xE5, 0x18, /* STYLUS_THRESH_MUT_HI */
	0xE5, 0x1A, /* STYLUS_THRESH_MUT_LO */
	0xE5, 0x1C, /* STYLUS_THRESH_SELF */
	0xE5, 0x1E, /* STYLUS_Z9_FILT_SCALE */
	0xE5, 0x1F, /* STYLUS_Z8_FILT_SCALE */
	0xE5, 0x20, /* STYLUS_Z_SCALE */
	0xE5, 0x22, /* STYLUS_INNER_EDGE_GAIN */
	0xE5, 0x23, /* STYLUS_OUTER_EDGE_GAIN */
	0xE5, 0x24, /* STYLUS_POS_CALC_METHOD */
	0xE5, 0x25, /* Reserved1061 */
	0xE5, 0x26, /* TOUCHMODE_STYLUS_HTI */
	0xE5, 0x28, /* TOUCHMODE_STYLUS_MAX_SIG_SUM */
	0xE5, 0x2A, /* STYLUS_HOVER_COEF */
	0xE5, 0x2C, /* STYLUS_CM_EDGE */
	0xE5, 0x2E, /* STYLUS_CONST_MASS */
	0xE5, 0x30, /* STYLUS_CM_GAIN */
	0xE5, 0x31, /* STYLUS_CM_COEF */
	0xE5, 0x32, /* STYLUS_PERIODIC_ERROR_AMPLITUDE */
	0xE5, 0x33, /* STYLUS_PALM_CLEARANCE */
	0xE5, 0x34, /* TOUCHMODE_FRAME_NUM_TO_CONFIRM_STYLUS_MODE */
	0xE5, 0x35, /* STYLUS_MAX_ACCEPTABLE_NOISE_LEVEL */
	0xE5, 0x36, /* Reserved1078 */
	0xE5, 0x38, /* TOUCHMODE_FINGER_SWITCH_DEBOUNCE */
	0xE5, 0x3A, /* TOUCHMODE_FINGER_EXIT_DELAY */
	0xE5, 0x3C, /* TOUCHMODE_GLOVE_SWITCH_DEBOUNCE */
	0xE5, 0x3E, /* TOUCHMODE_GLOVE_EXIT_DELAY */
	0xE5, 0x40, /* TOUCHMODE_GLOVE_FINGER_SWITCH_DEBOUNCE */
	0xE5, 0x42, /* TOUCHMODE_FINGER_GLOVE_SWITCH_DEBOUNCE */
	0xE5, 0x44, /* TOUCHMODE_STYLUS_SWITCH_DEBOUNCE */
	0xE5, 0x46, /* TOUCHMODE_STYLUS_EXIT_DELAY */
	0xE5, 0x48, /* TOUCHMODE_FINGER_STYLUS_SWITCH_DEBOUNCE */
	0xE5, 0x4A, /* Reserved1098 */
	0xE5, 0x4C, /* ACT_DIST0_SQR */
	0xE5, 0x4E, /* ACT_DIST2_SQR */
	0xE5, 0x50, /* ACT_DIST_TOUCHDOWN_SQR */
	0xE5, 0x52, /* ACT_DIST_LIFTOFF_SQR */
	0xE5, 0x54, /* ACT_DIST_Z_THRESHOLD */
	0xE5, 0x55, /* LARGE_OBJ_CFG */
	0xE5, 0x56, /* Reserved1110 */
	0xE5, 0x58, /* XY_FILTER_MASK */
	0xE5, 0x59, /* XY_FILT_IIR_COEF_SLOW */
	0xE5, 0x5A, /* XY_FILT_IIR_COEF_FAST */
	0xE5, 0x5B, /* XY_FILT_XY_THR_SLOW */
	0xE5, 0x5C, /* XY_FILT_XY_THR_FAST */
	0xE5, 0x5D, /* XY_FILT_Z_IIR_COEFF */
	0xE5, 0x5E, /* XY_FILT_PREDICTION_COEF */
	0xE5, 0x5F, /* Reserved1119 */
	0xE5, 0x60, /* XY_FILTER_MASK_CA */
	0xE5, 0x61, /* XY_FILT_IIR_COEF_SLOW_CA */
	0xE5, 0x62, /* XY_FILT_IIR_COEF_FAST_CA */
	0xE5, 0x63, /* XY_FILT_XY_THR_SLOW_CA */
	0xE5, 0x64, /* XY_FILT_XY_THR_FAST_CA */
	0xE5, 0x65, /* XY_FILT_Z_IIR_COEFF_CA */
	0xE5, 0x66, /* XY_FILT_PREDICTION_COEF_CA */
	0xE5, 0x67, /* Reserved1127 */
	0xE5, 0x68, /* XY_FILT_AXIS_IIR_COEF */
	0xE5, 0x69, /* XY_FILT_AXIS_HYST */
	0xE5, 0x6A, /* XY_FILT_ANGLE_IIR_COEF */
	0xE5, 0x6B, /* XY_FILT_ANGLE_HYST */
	0xE5, 0x6C, /* MAX_VELOCITY_SQR */
	0xE5, 0x70, /* FINGER_ID_MAX_FINGER_ACCELERATION2 */
	0xE5, 0x74, /* GRIP_XEDG_A */
	0xE5, 0x76, /* GRIP_XEDG_B */
	0xE5, 0x78, /* GRIP_XEXC_A */
	0xE5, 0x7A, /* GRIP_XEXC_B */
	0xE5, 0x7C, /* GRIP_YEDG_A */
	0xE5, 0x7E, /* GRIP_YEDG_B */
	0xE5, 0x80, /* GRIP_YEXC_A */
	0xE5, 0x82, /* GRIP_YEXC_B */
	0xE5, 0x84, /* GRIP_FIRST_EXC */
	0xE5, 0x85, /* GRIP_EXC_EDGE_ORIGIN */
	0xE5, 0x86, /* GRIP_ENABLE */
	0xE5, 0x87, /* FINGER_LIFTOFF_DEBOUNCE */
	0xE5, 0x88, /* GLOVE_LIFTOFF_DEBOUNCE */
	0xE5, 0x89, /* STYLUS_LIFTOFF_DEBOUNCE */
	0xE5, 0x8A, /* Reserved1162 */
	0xE5, 0x8C, /* WATER_REJ_SNS_WIDTH */
	0xE5, 0x8D, /* SLIM_POSITION_OFFSET_ALONG_TX */
	0xE5, 0x8E, /* SLIM_POSITION_OFFSET_ALONG_RX */
	0xE5, 0x8F, /* WET_FINGER_Z8_MULT */
	0xE5, 0x90, /* MIN_FF_Z9 */
	0xE5, 0x94, /* MAX_MF_Z9 */
	0xE5, 0x98, /* MIN_FF_SIG_SUM_EDGE */
	0xE5, 0x9C, /* MF_CENTERSIG_RATIO */
	0xE5, 0x9D, /* SD_SIZE_THRESH */
	0xE5, 0x9E, /* SD_SIG_THRESH_ON */
	0xE5, 0xA0, /* SD_SIG_THRESH_OFF */
	0xE5, 0xA2, /* VP_DLT_RST_THRESH */
	0xE5, 0xA4, /* VP_DLT_THRESH */
	0xE5, 0xA6, /* FAT_AXIS_LENGTH_THRESH */
	0xE5, 0xA7, /* PEAK_IGNORE_COEF */
	0xE5, 0xA8, /* AXIS_ORIENTATION_ENABLE */
	0xE5, 0xA9, /* Reserved1193 */
	0xE5, 0xAC, /* CLIPPING_X_LOW */
	0xE5, 0xAD, /* CLIPPING_X_HIGH */
	0xE5, 0xAE, /* CLIPPING_Y_LOW */
	0xE5, 0xAF, /* CLIPPING_Y_HIGH */
	0xE5, 0xB0, /* CALC_THRESH */
	0xE5, 0xB2, /* OFFSET_S1 */
	0xE5, 0xB4, /* OFFSET_S2 */
	0xE5, 0xB6, /* Z_SUM_8MM */
	0xE5, 0xB8, /* Z_SUM_4MM */
	0xE5, 0xBA, /* Z_SUM_3MM */
	0xE5, 0xBC, /* Z_SUM_1MM */
	0xE5, 0xBE, /* LOW_PIVOT */
	0xE5, 0xC0, /* HIGH_PIVOT */
	0xE5, 0xC2, /* LOW_PIVOT2 */
	0xE5, 0xC4, /* HIGH_PIVOT2 */
	0xE5, 0xC6, /* EDGE_DEBOUNCE_THRESH */
	0xE5, 0xC8, /* CENTER_MAGNITUDE_SCALE */
	0xE5, 0xCA, /* CENTROID_CORNER_GAIN */
	0xE5, 0xCC, /* EDGE_DEBOUNCE_COUNT */
	0xE5, 0xCD, /* BR2_ALWAYS_ON_FLAG */
	0xE5, 0xCE, /* PREFERRED_TOUCH_SIZE */
	0xE5, 0xCF, /* TOUCH_SIZE_METHOD */
	0xE5, 0xD0, /* RXLINE_FILT_ENABLE */
	0xE5, 0xD1, /* RXLINE_FILT_DEBOUNCE */
	0xE5, 0xD2, /* RXLINE_FILT_THRESH */
	0xE5, 0xD3, /* Reserved1235 */
	0xE5, 0xD4, /* TOUCHMODE_LFT_SELF_THRSH */
	0xE5, 0xD6, /* TOUCHMODE_LFT_NEG_SC_THRESH */
	0xE5, 0xD8, /* TOUCHMODE_LFT_NEG_MC_THRESH */
	0xE5, 0xDA, /* X_RESOLUTION */
	0xE5, 0xDC, /* Y_RESOLUTION */
	0xE5, 0xDE, /* X_LENGTH_100xMM */
	0xE5, 0xE0, /* Y_LENGTH_100xMM */
	0xE5, 0xE2, /* X_PITCH_10xMM */
	0xE5, 0xE3, /* Y_PITCH_10xMM */
	0xE5, 0xE4, /* Reserved1252 */
	0xE5, 0xE5, /* ACT_LFT_EN */
	0xE5, 0xE6, /* TOUCHMODE_CONFIG */
	0xE5, 0xE7, /* LRG_OBJ_CFG */
	0xE5, 0xE8, /* MAX_REPORTED_TOUCH_NUM */
	0xE5, 0xE9, /* REPORT_CFG */
	0xE5, 0xEA, /* TOUCHMODE_STYLUS_HIGH_PRIORITY */
	0xE5, 0xEB, /* Reserved1259 */
	0xE5, 0xEC, /* LOW_POWER_ENABLE */
	0xE5, 0xED, /* ACT_INTRVL0 */
	0xE5, 0xEE, /* ACT_LFT_INTRVL0 */
	0xE5, 0xF0, /* LP_INTRVL0 */
	0xE5, 0xF2, /* TCH_TMOUT0 */
	0xE5, 0xF4, /* POST_CFG */
	0xE5, 0xF5, /* Reserved1269 */
	0xE5, 0xF6, /* CONFIG_VER */
	0xE5, 0xF8, /* SEND_REPORT_AFTER_ACTIVE_INTERVAL_CFG */
	0xE5, 0xF9, /* PIP_REPORTING_DISABLE */
	0xE5, 0xFA, /* INTERRUPT_PIN_OVERRIDE */
	0xE5, 0xFC, /* CONFIG_CRC */
};

