/*
 * Driver for OV5642 CMOS Image Sensor from OmniVision
 *
 * Copyright (C) 2008, Guennadi Liakhovetski <kernel@pengutronix.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#define VCM_DRIVER_A3907   0
#define VCM_DRIVER_AD5820  1
#define VCM_DRIVER_DW9710  2
#define VCM_DRIVER         VCM_DRIVER_AD5820


#if (VCM_DRIVER == VCM_DRIVER_AD5820)
static struct reginfo sensor_af_firmware[ ]=
{
	{0x308c,0x00},
	{0x3104,0x02},
	{0x3105,0xff},
	{0x3106,0x00},
	{0x3107,0xff},
	{0x8000,0x02},
	{0x8001,0x00},
	{0x8002,0x06},
	{0x8003,0x02},
	{0x8004,0x07},
	{0x8005,0xa9},
	{0x8006,0x78},
	{0x8007,0x7f},
	{0x8008,0xe4},
	{0x8009,0xf6},
	{0x800a,0xd8},
	{0x800b,0xfd},
	{0x800c,0x75},
	{0x800d,0x81},
	{0x800e,0x45},
	{0x800f,0x02},
	{0x8010,0x0a},
	{0x8011,0xdf},
	{0x8012,0x32},
	{0x8013,0x02},
	{0x8014,0x00},
	{0x8015,0x12},
	{0x8016,0xe8},
	{0x8017,0x8f},
	{0x8018,0xf0},
	{0x8019,0xa4},
	{0x801a,0xcc},
	{0x801b,0x8b},
	{0x801c,0xf0},
	{0x801d,0xa4},
	{0x801e,0x2c},
	{0x801f,0xfc},
	{0x8020,0xe9},
	{0x8021,0x8e},
	{0x8022,0xf0},
	{0x8023,0xa4},
	{0x8024,0x2c},
	{0x8025,0xfc},
	{0x8026,0x8a},
	{0x8027,0xf0},
	{0x8028,0xed},
	{0x8029,0xa4},
	{0x802a,0x2c},
	{0x802b,0xfc},
	{0x802c,0xea},
	{0x802d,0x8e},
	{0x802e,0xf0},
	{0x802f,0xa4},
	{0x8030,0xcd},
	{0x8031,0xa8},
	{0x8032,0xf0},
	{0x8033,0x8b},
	{0x8034,0xf0},
	{0x8035,0xa4},
	{0x8036,0x2d},
	{0x8037,0xcc},
	{0x8038,0x38},
	{0x8039,0x25},
	{0x803a,0xf0},
	{0x803b,0xfd},
	{0x803c,0xe9},
	{0x803d,0x8f},
	{0x803e,0xf0},
	{0x803f,0xa4},
	{0x8040,0x2c},
	{0x8041,0xcd},
	{0x8042,0x35},
	{0x8043,0xf0},
	{0x8044,0xfc},
	{0x8045,0xeb},
	{0x8046,0x8e},
	{0x8047,0xf0},
	{0x8048,0xa4},
	{0x8049,0xfe},
	{0x804a,0xa9},
	{0x804b,0xf0},
	{0x804c,0xeb},
	{0x804d,0x8f},
	{0x804e,0xf0},
	{0x804f,0xa4},
	{0x8050,0xcf},
	{0x8051,0xc5},
	{0x8052,0xf0},
	{0x8053,0x2e},
	{0x8054,0xcd},
	{0x8055,0x39},
	{0x8056,0xfe},
	{0x8057,0xe4},
	{0x8058,0x3c},
	{0x8059,0xfc},
	{0x805a,0xea},
	{0x805b,0xa4},
	{0x805c,0x2d},
	{0x805d,0xce},
	{0x805e,0x35},
	{0x805f,0xf0},
	{0x8060,0xfd},
	{0x8061,0xe4},
	{0x8062,0x3c},
	{0x8063,0xfc},
	{0x8064,0x22},
	{0x8065,0x75},
	{0x8066,0xf0},
	{0x8067,0x08},
	{0x8068,0x75},
	{0x8069,0x82},
	{0x806a,0x00},
	{0x806b,0xef},
	{0x806c,0x2f},
	{0x806d,0xff},
	{0x806e,0xee},
	{0x806f,0x33},
	{0x8070,0xfe},
	{0x8071,0xcd},
	{0x8072,0x33},
	{0x8073,0xcd},
	{0x8074,0xcc},
	{0x8075,0x33},
	{0x8076,0xcc},
	{0x8077,0xc5},
	{0x8078,0x82},
	{0x8079,0x33},
	{0x807a,0xc5},
	{0x807b,0x82},
	{0x807c,0x9b},
	{0x807d,0xed},
	{0x807e,0x9a},
	{0x807f,0xec},
	{0x8080,0x99},
	{0x8081,0xe5},
	{0x8082,0x82},
	{0x8083,0x98},
	{0x8084,0x40},
	{0x8085,0x0c},
	{0x8086,0xf5},
	{0x8087,0x82},
	{0x8088,0xee},
	{0x8089,0x9b},
	{0x808a,0xfe},
	{0x808b,0xed},
	{0x808c,0x9a},
	{0x808d,0xfd},
	{0x808e,0xec},
	{0x808f,0x99},
	{0x8090,0xfc},
	{0x8091,0x0f},
	{0x8092,0xd5},
	{0x8093,0xf0},
	{0x8094,0xd6},
	{0x8095,0xe4},
	{0x8096,0xce},
	{0x8097,0xfb},
	{0x8098,0xe4},
	{0x8099,0xcd},
	{0x809a,0xfa},
	{0x809b,0xe4},
	{0x809c,0xcc},
	{0x809d,0xf9},
	{0x809e,0xa8},
	{0x809f,0x82},
	{0x80a0,0x22},
	{0x80a1,0xb8},
	{0x80a2,0x00},
	{0x80a3,0xc1},
	{0x80a4,0xb9},
	{0x80a5,0x00},
	{0x80a6,0x59},
	{0x80a7,0xba},
	{0x80a8,0x00},
	{0x80a9,0x2d},
	{0x80aa,0xec},
	{0x80ab,0x8b},
	{0x80ac,0xf0},
	{0x80ad,0x84},
	{0x80ae,0xcf},
	{0x80af,0xce},
	{0x80b0,0xcd},
	{0x80b1,0xfc},
	{0x80b2,0xe5},
	{0x80b3,0xf0},
	{0x80b4,0xcb},
	{0x80b5,0xf9},
	{0x80b6,0x78},
	{0x80b7,0x18},
	{0x80b8,0xef},
	{0x80b9,0x2f},
	{0x80ba,0xff},
	{0x80bb,0xee},
	{0x80bc,0x33},
	{0x80bd,0xfe},
	{0x80be,0xed},
	{0x80bf,0x33},
	{0x80c0,0xfd},
	{0x80c1,0xec},
	{0x80c2,0x33},
	{0x80c3,0xfc},
	{0x80c4,0xeb},
	{0x80c5,0x33},
	{0x80c6,0xfb},
	{0x80c7,0x10},
	{0x80c8,0xd7},
	{0x80c9,0x03},
	{0x80ca,0x99},
	{0x80cb,0x40},
	{0x80cc,0x04},
	{0x80cd,0xeb},
	{0x80ce,0x99},
	{0x80cf,0xfb},
	{0x80d0,0x0f},
	{0x80d1,0xd8},
	{0x80d2,0xe5},
	{0x80d3,0xe4},
	{0x80d4,0xf9},
	{0x80d5,0xfa},
	{0x80d6,0x22},
	{0x80d7,0x78},
	{0x80d8,0x18},
	{0x80d9,0xef},
	{0x80da,0x2f},
	{0x80db,0xff},
	{0x80dc,0xee},
	{0x80dd,0x33},
	{0x80de,0xfe},
	{0x80df,0xed},
	{0x80e0,0x33},
	{0x80e1,0xfd},
	{0x80e2,0xec},
	{0x80e3,0x33},
	{0x80e4,0xfc},
	{0x80e5,0xc9},
	{0x80e6,0x33},
	{0x80e7,0xc9},
	{0x80e8,0x10},
	{0x80e9,0xd7},
	{0x80ea,0x05},
	{0x80eb,0x9b},
	{0x80ec,0xe9},
	{0x80ed,0x9a},
	{0x80ee,0x40},
	{0x80ef,0x07},
	{0x80f0,0xec},
	{0x80f1,0x9b},
	{0x80f2,0xfc},
	{0x80f3,0xe9},
	{0x80f4,0x9a},
	{0x80f5,0xf9},
	{0x80f6,0x0f},
	{0x80f7,0xd8},
	{0x80f8,0xe0},
	{0x80f9,0xe4},
	{0x80fa,0xc9},
	{0x80fb,0xfa},
	{0x80fc,0xe4},
	{0x80fd,0xcc},
	{0x80fe,0xfb},
	{0x80ff,0x22},
	{0x8100,0x75},
	{0x8101,0xf0},
	{0x8102,0x10},
	{0x8103,0xef},
	{0x8104,0x2f},
	{0x8105,0xff},
	{0x8106,0xee},
	{0x8107,0x33},
	{0x8108,0xfe},
	{0x8109,0xed},
	{0x810a,0x33},
	{0x810b,0xfd},
	{0x810c,0xcc},
	{0x810d,0x33},
	{0x810e,0xcc},
	{0x810f,0xc8},
	{0x8110,0x33},
	{0x8111,0xc8},
	{0x8112,0x10},
	{0x8113,0xd7},
	{0x8114,0x07},
	{0x8115,0x9b},
	{0x8116,0xec},
	{0x8117,0x9a},
	{0x8118,0xe8},
	{0x8119,0x99},
	{0x811a,0x40},
	{0x811b,0x0a},
	{0x811c,0xed},
	{0x811d,0x9b},
	{0x811e,0xfd},
	{0x811f,0xec},
	{0x8120,0x9a},
	{0x8121,0xfc},
	{0x8122,0xe8},
	{0x8123,0x99},
	{0x8124,0xf8},
	{0x8125,0x0f},
	{0x8126,0xd5},
	{0x8127,0xf0},
	{0x8128,0xda},
	{0x8129,0xe4},
	{0x812a,0xcd},
	{0x812b,0xfb},
	{0x812c,0xe4},
	{0x812d,0xcc},
	{0x812e,0xfa},
	{0x812f,0xe4},
	{0x8130,0xc8},
	{0x8131,0xf9},
	{0x8132,0x22},
	{0x8133,0xe8},
	{0x8134,0x60},
	{0x8135,0x0f},
	{0x8136,0xef},
	{0x8137,0xc3},
	{0x8138,0x33},
	{0x8139,0xff},
	{0x813a,0xee},
	{0x813b,0x33},
	{0x813c,0xfe},
	{0x813d,0xed},
	{0x813e,0x33},
	{0x813f,0xfd},
	{0x8140,0xec},
	{0x8141,0x33},
	{0x8142,0xfc},
	{0x8143,0xd8},
	{0x8144,0xf1},
	{0x8145,0x22},
	{0x8146,0xa4},
	{0x8147,0x25},
	{0x8148,0x82},
	{0x8149,0xf5},
	{0x814a,0x82},
	{0x814b,0xe5},
	{0x814c,0xf0},
	{0x814d,0x35},
	{0x814e,0x83},
	{0x814f,0xf5},
	{0x8150,0x83},
	{0x8151,0x22},
	{0x8152,0xd0},
	{0x8153,0x83},
	{0x8154,0xd0},
	{0x8155,0x82},
	{0x8156,0xf8},
	{0x8157,0xe4},
	{0x8158,0x93},
	{0x8159,0x70},
	{0x815a,0x12},
	{0x815b,0x74},
	{0x815c,0x01},
	{0x815d,0x93},
	{0x815e,0x70},
	{0x815f,0x0d},
	{0x8160,0xa3},
	{0x8161,0xa3},
	{0x8162,0x93},
	{0x8163,0xf8},
	{0x8164,0x74},
	{0x8165,0x01},
	{0x8166,0x93},
	{0x8167,0xf5},
	{0x8168,0x82},
	{0x8169,0x88},
	{0x816a,0x83},
	{0x816b,0xe4},
	{0x816c,0x73},
	{0x816d,0x74},
	{0x816e,0x02},
	{0x816f,0x93},
	{0x8170,0x68},
	{0x8171,0x60},
	{0x8172,0xef},
	{0x8173,0xa3},
	{0x8174,0xa3},
	{0x8175,0xa3},
	{0x8176,0x80},
	{0x8177,0xdf},
	{0x8178,0x75},
	{0x8179,0x0c},
	{0x817a,0x0a},
	{0x817b,0xa2},
	{0x817c,0xaf},
	{0x817d,0x92},
	{0x817e,0x22},
	{0x817f,0xc2},
	{0x8180,0xaf},
	{0x8181,0xc2},
	{0x8182,0x23},
	{0x8183,0x12},
	{0x8184,0x04},
	{0x8185,0x07},
	{0x8186,0x12},
	{0x8187,0x04},
	{0x8188,0x4d},
	{0x8189,0x12},
	{0x818a,0x04},
	{0x818b,0x07},
	{0x818c,0x75},
	{0x818d,0x32},
	{0x818e,0x05},
	{0x818f,0xaf},
	{0x8190,0x32},
	{0x8191,0x15},
	{0x8192,0x32},
	{0x8193,0xef},
	{0x8194,0x70},
	{0x8195,0xf9},
	{0x8196,0xd2},
	{0x8197,0x18},
	{0x8198,0x12},
	{0x8199,0x04},
	{0x819a,0x09},
	{0x819b,0x75},
	{0x819c,0x32},
	{0x819d,0x0a},
	{0x819e,0xaf},
	{0x819f,0x32},
	{0x81a0,0x15},
	{0x81a1,0x32},
	{0x81a2,0xef},
	{0x81a3,0x70},
	{0x81a4,0xf9},
	{0x81a5,0xc2},
	{0x81a6,0x19},
	{0x81a7,0x12},
	{0x81a8,0x04},
	{0x81a9,0x09},
	{0x81aa,0x75},
	{0x81ab,0x32},
	{0x81ac,0x05},
	{0x81ad,0xaf},
	{0x81ae,0x32},
	{0x81af,0x15},
	{0x81b0,0x32},
	{0x81b1,0xef},
	{0x81b2,0x70},
	{0x81b3,0xf9},
	{0x81b4,0xc2},
	{0x81b5,0x18},
	{0x81b6,0x12},
	{0x81b7,0x04},
	{0x81b8,0x09},
	{0x81b9,0x75},
	{0x81ba,0x32},
	{0x81bb,0x05},
	{0x81bc,0xaf},
	{0x81bd,0x32},
	{0x81be,0x15},
	{0x81bf,0x32},
	{0x81c0,0xef},
	{0x81c1,0x70},
	{0x81c2,0xf9},
	{0x81c3,0x75},
	{0x81c4,0x0d},
	{0x81c5,0x18},
	{0x81c6,0x12},
	{0x81c7,0x02},
	{0x81c8,0xb8},
	{0x81c9,0x75},
	{0x81ca,0x32},
	{0x81cb,0x0a},
	{0x81cc,0xaf},
	{0x81cd,0x32},
	{0x81ce,0x15},
	{0x81cf,0x32},
	{0x81d0,0xef},
	{0x81d1,0x70},
	{0x81d2,0xf9},
	{0x81d3,0xd2},
	{0x81d4,0x18},
	{0x81d5,0x12},
	{0x81d6,0x04},
	{0x81d7,0x09},
	{0x81d8,0x12},
	{0x81d9,0x04},
	{0x81da,0x97},
	{0x81db,0xaf},
	{0x81dc,0x32},
	{0x81dd,0x15},
	{0x81de,0x32},
	{0x81df,0xef},
	{0x81e0,0x70},
	{0x81e1,0xf9},
	{0x81e2,0xc2},
	{0x81e3,0x18},
	{0x81e4,0x12},
	{0x81e5,0x04},
	{0x81e6,0x09},
	{0x81e7,0x75},
	{0x81e8,0x32},
	{0x81e9,0x0a},
	{0x81ea,0xaf},
	{0x81eb,0x32},
	{0x81ec,0x15},
	{0x81ed,0x32},
	{0x81ee,0xef},
	{0x81ef,0x70},
	{0x81f0,0xf9},
	{0x81f1,0x30},
	{0x81f2,0x11},
	{0x81f3,0x03},
	{0x81f4,0x02},
	{0x81f5,0x02},
	{0x81f6,0x6f},
	{0x81f7,0x12},
	{0x81f8,0x04},
	{0x81f9,0x07},
	{0x81fa,0x12},
	{0x81fb,0x04},
	{0x81fc,0x4d},
	{0x81fd,0xe5},
	{0x81fe,0x0a},
	{0x81ff,0xf5},
	{0x8200,0x0d},
	{0x8201,0x12},
	{0x8202,0x02},
	{0x8203,0xb8},
	{0x8204,0x75},
	{0x8205,0x32},
	{0x8206,0x0a},
	{0x8207,0xaf},
	{0x8208,0x32},
	{0x8209,0x15},
	{0x820a,0x32},
	{0x820b,0xef},
	{0x820c,0x70},
	{0x820d,0xf9},
	{0x820e,0xd2},
	{0x820f,0x18},
	{0x8210,0x12},
	{0x8211,0x04},
	{0x8212,0x09},
	{0x8213,0x12},
	{0x8214,0x04},
	{0x8215,0x97},
	{0x8216,0xaf},
	{0x8217,0x32},
	{0x8218,0x15},
	{0x8219,0x32},
	{0x821a,0xef},
	{0x821b,0x70},
	{0x821c,0xf9},
	{0x821d,0xc2},
	{0x821e,0x18},
	{0x821f,0x12},
	{0x8220,0x04},
	{0x8221,0x09},
	{0x8222,0x75},
	{0x8223,0x32},
	{0x8224,0x0a},
	{0x8225,0xaf},
	{0x8226,0x32},
	{0x8227,0x15},
	{0x8228,0x32},
	{0x8229,0xef},
	{0x822a,0x70},
	{0x822b,0xf9},
	{0x822c,0x30},
	{0x822d,0x11},
	{0x822e,0x04},
	{0x822f,0x15},
	{0x8230,0x0c},
	{0x8231,0x80},
	{0x8232,0x45},
	{0x8233,0x12},
	{0x8234,0x04},
	{0x8235,0x07},
	{0x8236,0x12},
	{0x8237,0x04},
	{0x8238,0x4d},
	{0x8239,0x85},
	{0x823a,0x0b},
	{0x823b,0x0d},
	{0x823c,0x12},
	{0x823d,0x0a},
	{0x823e,0x9b},
	{0x823f,0xc2},
	{0x8240,0x0f},
	{0x8241,0x12},
	{0x8242,0x04},
	{0x8243,0x4f},
	{0x8244,0x75},
	{0x8245,0x32},
	{0x8246,0x0a},
	{0x8247,0xaf},
	{0x8248,0x32},
	{0x8249,0x15},
	{0x824a,0x32},
	{0x824b,0xef},
	{0x824c,0x70},
	{0x824d,0xf9},
	{0x824e,0xd2},
	{0x824f,0x18},
	{0x8250,0x12},
	{0x8251,0x04},
	{0x8252,0x09},
	{0x8253,0x12},
	{0x8254,0x04},
	{0x8255,0x97},
	{0x8256,0xaf},
	{0x8257,0x32},
	{0x8258,0x15},
	{0x8259,0x32},
	{0x825a,0xef},
	{0x825b,0x70},
	{0x825c,0xf9},
	{0x825d,0xc2},
	{0x825e,0x18},
	{0x825f,0x12},
	{0x8260,0x04},
	{0x8261,0x09},
	{0x8262,0x75},
	{0x8263,0x32},
	{0x8264,0x0a},
	{0x8265,0xaf},
	{0x8266,0x32},
	{0x8267,0x15},
	{0x8268,0x32},
	{0x8269,0xef},
	{0x826a,0x70},
	{0x826b,0xf9},
	{0x826c,0x30},
	{0x826d,0x11},
	{0x826e,0x06},
	{0x826f,0x15},
	{0x8270,0x0c},
	{0x8271,0xd2},
	{0x8272,0x23},
	{0x8273,0x80},
	{0x8274,0x03},
	{0x8275,0xe4},
	{0x8276,0xf5},
	{0x8277,0x0c},
	{0x8278,0x12},
	{0x8279,0x04},
	{0x827a,0x07},
	{0x827b,0x12},
	{0x827c,0x04},
	{0x827d,0x4d},
	{0x827e,0xc2},
	{0x827f,0x19},
	{0x8280,0x12},
	{0x8281,0x04},
	{0x8282,0x09},
	{0x8283,0x75},
	{0x8284,0x32},
	{0x8285,0x05},
	{0x8286,0xaf},
	{0x8287,0x32},
	{0x8288,0x15},
	{0x8289,0x32},
	{0x828a,0xef},
	{0x828b,0x70},
	{0x828c,0xf9},
	{0x828d,0xd2},
	{0x828e,0x18},
	{0x828f,0x12},
	{0x8290,0x04},
	{0x8291,0x09},
	{0x8292,0x75},
	{0x8293,0x32},
	{0x8294,0x05},
	{0x8295,0xaf},
	{0x8296,0x32},
	{0x8297,0x15},
	{0x8298,0x32},
	{0x8299,0xef},
	{0x829a,0x70},
	{0x829b,0xf9},
	{0x829c,0x12},
	{0x829d,0x04},
	{0x829e,0x07},
	{0x829f,0x75},
	{0x82a0,0x32},
	{0x82a1,0x05},
	{0x82a2,0xaf},
	{0x82a3,0x32},
	{0x82a4,0x15},
	{0x82a5,0x32},
	{0x82a6,0xef},
	{0x82a7,0x70},
	{0x82a8,0xf9},
	{0x82a9,0xa2},
	{0x82aa,0x22},
	{0x82ab,0x92},
	{0x82ac,0xaf},
	{0x82ad,0xe5},
	{0x82ae,0x0c},
	{0x82af,0xd3},
	{0x82b0,0x94},
	{0x82b1,0x00},
	{0x82b2,0x40},
	{0x82b3,0x03},
	{0x82b4,0x02},
	{0x82b5,0x01},
	{0x82b6,0x7f},
	{0x82b7,0x22},
	{0x82b8,0x12},
	{0x82b9,0x0a},
	{0x82ba,0x9b},
	{0x82bb,0xc2},
	{0x82bc,0x0f},
	{0x82bd,0x90},
	{0x82be,0x30},
	{0x82bf,0xb1},
	{0x82c0,0xe5},
	{0x82c1,0x21},
	{0x82c2,0xf0},
	{0x82c3,0x22},
	{0x82c4,0x90},
	{0x82c5,0x33},
	{0x82c6,0x5f},
	{0x82c7,0xe0},
	{0x82c8,0x54},
	{0x82c9,0x0f},
	{0x82ca,0xfe},
	{0x82cb,0xa3},
	{0x82cc,0xe0},
	{0x82cd,0xfd},
	{0x82ce,0xed},
	{0x82cf,0xff},
	{0x82d0,0xee},
	{0x82d1,0x54},
	{0x82d2,0x0f},
	{0x82d3,0xf5},
	{0x82d4,0x0d},
	{0x82d5,0x8f},
	{0x82d6,0x0e},
	{0x82d7,0x90},
	{0x82d8,0x33},
	{0x82d9,0x5f},
	{0x82da,0xe0},
	{0x82db,0x54},
	{0x82dc,0x70},
	{0x82dd,0x75},
	{0x82de,0xf0},
	{0x82df,0x10},
	{0x82e0,0xa4},
	{0x82e1,0xff},
	{0x82e2,0x90},
	{0x82e3,0x33},
	{0x82e4,0x61},
	{0x82e5,0xe0},
	{0x82e6,0xfd},
	{0x82e7,0xef},
	{0x82e8,0x4d},
	{0x82e9,0xff},
	{0x82ea,0xe5},
	{0x82eb,0xf0},
	{0x82ec,0x54},
	{0x82ed,0x07},
	{0x82ee,0xf5},
	{0x82ef,0x0f},
	{0x82f0,0x8f},
	{0x82f1,0x10},
	{0x82f2,0xe5},
	{0x82f3,0x0e},
	{0x82f4,0xae},
	{0x82f5,0x0d},
	{0x82f6,0x78},
	{0x82f7,0x05},
	{0x82f8,0xce},
	{0x82f9,0xc3},
	{0x82fa,0x13},
	{0x82fb,0xce},
	{0x82fc,0x13},
	{0x82fd,0xd8},
	{0x82fe,0xf9},
	{0x82ff,0xf5},
	{0x8300,0x0e},
	{0x8301,0x8e},
	{0x8302,0x0d},
	{0x8303,0xe5},
	{0x8304,0x10},
	{0x8305,0xae},
	{0x8306,0x0f},
	{0x8307,0x78},
	{0x8308,0x03},
	{0x8309,0xce},
	{0x830a,0xc3},
	{0x830b,0x13},
	{0x830c,0xce},
	{0x830d,0x13},
	{0x830e,0xd8},
	{0x830f,0xf9},
	{0x8310,0xf5},
	{0x8311,0x10},
	{0x8312,0x8e},
	{0x8313,0x0f},
	{0x8314,0x85},
	{0x8315,0x2a},
	{0x8316,0x11},
	{0x8317,0x85},
	{0x8318,0x2b},
	{0x8319,0x13},
	{0x831a,0x85},
	{0x831b,0x2c},
	{0x831c,0x12},
	{0x831d,0x85},
	{0x831e,0x2d},
	{0x831f,0x14},
	{0x8320,0x12},
	{0x8321,0x04},
	{0x8322,0xab},
	{0x8323,0xaf},
	{0x8324,0x11},
	{0x8325,0x12},
	{0x8326,0x03},
	{0x8327,0xdf},
	{0x8328,0x8f},
	{0x8329,0x11},
	{0x832a,0x12},
	{0x832b,0x04},
	{0x832c,0xab},
	{0x832d,0xaf},
	{0x832e,0x12},
	{0x832f,0x12},
	{0x8330,0x03},
	{0x8331,0xdf},
	{0x8332,0x8f},
	{0x8333,0x12},
	{0x8334,0x12},
	{0x8335,0x04},
	{0x8336,0x56},
	{0x8337,0xaf},
	{0x8338,0x13},
	{0x8339,0xfc},
	{0x833a,0xfd},
	{0x833b,0xfe},
	{0x833c,0x12},
	{0x833d,0x00},
	{0x833e,0x16},
	{0x833f,0x12},
	{0x8340,0x03},
	{0x8341,0xfe},
	{0x8342,0x7b},
	{0x8343,0x1e},
	{0x8344,0x12},
	{0x8345,0x03},
	{0x8346,0xf7},
	{0x8347,0x8f},
	{0x8348,0x13},
	{0x8349,0x12},
	{0x834a,0x04},
	{0x834b,0x56},
	{0x834c,0xaf},
	{0x834d,0x14},
	{0x834e,0xfc},
	{0x834f,0xfd},
	{0x8350,0xfe},
	{0x8351,0x12},
	{0x8352,0x00},
	{0x8353,0x16},
	{0x8354,0x12},
	{0x8355,0x03},
	{0x8356,0xfe},
	{0x8357,0xe4},
	{0x8358,0x7b},
	{0x8359,0x1e},
	{0x835a,0x12},
	{0x835b,0x03},
	{0x835c,0xf8},
	{0x835d,0x8f},
	{0x835e,0x14},
	{0x835f,0xc3},
	{0x8360,0xe5},
	{0x8361,0x12},
	{0x8362,0x95},
	{0x8363,0x11},
	{0x8364,0xff},
	{0x8365,0x0f},
	{0x8366,0xef},
	{0x8367,0xc3},
	{0x8368,0x13},
	{0x8369,0xff},
	{0x836a,0xc3},
	{0x836b,0x94},
	{0x836c,0x02},
	{0x836d,0x50},
	{0x836e,0x27},
	{0x836f,0xe5},
	{0x8370,0x11},
	{0x8371,0x9f},
	{0x8372,0x40},
	{0x8373,0x06},
	{0x8374,0xe5},
	{0x8375,0x11},
	{0x8376,0x9f},
	{0x8377,0xfe},
	{0x8378,0x80},
	{0x8379,0x02},
	{0x837a,0x7e},
	{0x837b,0x00},
	{0x837c,0x8e},
	{0x837d,0x11},
	{0x837e,0xef},
	{0x837f,0xfd},
	{0x8380,0xe5},
	{0x8381,0x12},
	{0x8382,0x2d},
	{0x8383,0xfd},
	{0x8384,0xe4},
	{0x8385,0x33},
	{0x8386,0xfc},
	{0x8387,0xc3},
	{0x8388,0xed},
	{0x8389,0x95},
	{0x838a,0x0e},
	{0x838b,0xec},
	{0x838c,0x95},
	{0x838d,0x0d},
	{0x838e,0x50},
	{0x838f,0x02},
	{0x8390,0x80},
	{0x8391,0x02},
	{0x8392,0xad},
	{0x8393,0x0e},
	{0x8394,0x8d},
	{0x8395,0x12},
	{0x8396,0xc3},
	{0x8397,0xe5},
	{0x8398,0x14},
	{0x8399,0x95},
	{0x839a,0x13},
	{0x839b,0xff},
	{0x839c,0xc3},
	{0x839d,0x94},
	{0x839e,0x08},
	{0x839f,0x50},
	{0x83a0,0x29},
	{0x83a1,0xe5},
	{0x83a2,0x13},
	{0x83a3,0x9f},
	{0x83a4,0x40},
	{0x83a5,0x06},
	{0x83a6,0xe5},
	{0x83a7,0x13},
	{0x83a8,0x9f},
	{0x83a9,0xfe},
	{0x83aa,0x80},
	{0x83ab,0x02},
	{0x83ac,0x7e},
	{0x83ad,0x00},
	{0x83ae,0x8e},
	{0x83af,0x13},
	{0x83b0,0xef},
	{0x83b1,0xfd},
	{0x83b2,0xe5},
	{0x83b3,0x14},
	{0x83b4,0x2d},
	{0x83b5,0xfd},
	{0x83b6,0xe4},
	{0x83b7,0x33},
	{0x83b8,0xfc},
	{0x83b9,0xc3},
	{0x83ba,0xed},
	{0x83bb,0x95},
	{0x83bc,0x10},
	{0x83bd,0xec},
	{0x83be,0x95},
	{0x83bf,0x0f},
	{0x83c0,0x50},
	{0x83c1,0x04},
	{0x83c2,0xaf},
	{0x83c3,0x05},
	{0x83c4,0x80},
	{0x83c5,0x02},
	{0x83c6,0xaf},
	{0x83c7,0x10},
	{0x83c8,0x8f},
	{0x83c9,0x14},
	{0x83ca,0x90},
	{0x83cb,0x39},
	{0x83cc,0x0a},
	{0x83cd,0xe5},
	{0x83ce,0x11},
	{0x83cf,0xf0},
	{0x83d0,0xa3},
	{0x83d1,0xe5},
	{0x83d2,0x13},
	{0x83d3,0xf0},
	{0x83d4,0xa3},
	{0x83d5,0xe5},
	{0x83d6,0x12},
	{0x83d7,0xf0},
	{0x83d8,0xa3},
	{0x83d9,0xe5},
	{0x83da,0x14},
	{0x83db,0xf0},
	{0x83dc,0xc2},
	{0x83dd,0x20},
	{0x83de,0x22},
	{0x83df,0xab},
	{0x83e0,0x0c},
	{0x83e1,0xaa},
	{0x83e2,0x0b},
	{0x83e3,0xa9},
	{0x83e4,0x0a},
	{0x83e5,0xa8},
	{0x83e6,0x09},
	{0x83e7,0xfc},
	{0x83e8,0xfd},
	{0x83e9,0xfe},
	{0x83ea,0x12},
	{0x83eb,0x00},
	{0x83ec,0x16},
	{0x83ed,0x8f},
	{0x83ee,0x0c},
	{0x83ef,0x8e},
	{0x83f0,0x0b},
	{0x83f1,0x8d},
	{0x83f2,0x0a},
	{0x83f3,0x8c},
	{0x83f4,0x09},
	{0x83f5,0x7b},
	{0x83f6,0x28},
	{0x83f7,0xe4},
	{0x83f8,0xfa},
	{0x83f9,0xf9},
	{0x83fa,0xf8},
	{0x83fb,0x12},
	{0x83fc,0x00},
	{0x83fd,0xa1},
	{0x83fe,0x8f},
	{0x83ff,0x0c},
	{0x8400,0x8e},
	{0x8401,0x0b},
	{0x8402,0x8d},
	{0x8403,0x0a},
	{0x8404,0x8c},
	{0x8405,0x09},
	{0x8406,0x22},
	{0x8407,0xd2},
	{0x8408,0x19},
	{0x8409,0x90},
	{0x840a,0x30},
	{0x840b,0xb4},
	{0x840c,0xe5},
	{0x840d,0x23},
	{0x840e,0xf0},
	{0x840f,0x22},
	{0x8410,0x85},
	{0x8411,0x2f},
	{0x8412,0x82},
	{0x8413,0x85},
	{0x8414,0x2e},
	{0x8415,0x83},
	{0x8416,0xe5},
	{0x8417,0x43},
	{0x8418,0x75},
	{0x8419,0xf0},
	{0x841a,0x02},
	{0x841b,0x12},
	{0x841c,0x01},
	{0x841d,0x46},
	{0x841e,0xe4},
	{0x841f,0x93},
	{0x8420,0xfe},
	{0x8421,0x74},
	{0x8422,0x01},
	{0x8423,0x93},
	{0x8424,0xff},
	{0x8425,0x85},
	{0x8426,0x2f},
	{0x8427,0x82},
	{0x8428,0x85},
	{0x8429,0x2e},
	{0x842a,0x83},
	{0x842b,0xe4},
	{0x842c,0x93},
	{0x842d,0xfc},
	{0x842e,0x74},
	{0x842f,0x01},
	{0x8430,0x93},
	{0x8431,0xfd},
	{0x8432,0xc3},
	{0x8433,0xef},
	{0x8434,0x9d},
	{0x8435,0xff},
	{0x8436,0xee},
	{0x8437,0x9c},
	{0x8438,0x22},
	{0x8439,0x12},
	{0x843a,0x00},
	{0x843b,0x16},
	{0x843c,0x8f},
	{0x843d,0x3c},
	{0x843e,0x8e},
	{0x843f,0x3b},
	{0x8440,0x8d},
	{0x8441,0x3a},
	{0x8442,0x8c},
	{0x8443,0x39},
	{0x8444,0xaf},
	{0x8445,0x3c},
	{0x8446,0xae},
	{0x8447,0x3b},
	{0x8448,0xad},
	{0x8449,0x3a},
	{0x844a,0xac},
	{0x844b,0x39},
	{0x844c,0x22},
	{0x844d,0xd2},
	{0x844e,0x0f},
	{0x844f,0x90},
	{0x8450,0x30},
	{0x8451,0xb1},
	{0x8452,0xe5},
	{0x8453,0x21},
	{0x8454,0xf0},
	{0x8455,0x22},
	{0x8456,0xe4},
	{0x8457,0x85},
	{0x8458,0x10},
	{0x8459,0x0c},
	{0x845a,0x85},
	{0x845b,0x0f},
	{0x845c,0x0b},
	{0x845d,0xf5},
	{0x845e,0x0a},
	{0x845f,0xf5},
	{0x8460,0x09},
	{0x8461,0xab},
	{0x8462,0x0c},
	{0x8463,0xaa},
	{0x8464,0x0b},
	{0x8465,0xa9},
	{0x8466,0x0a},
	{0x8467,0xa8},
	{0x8468,0x09},
	{0x8469,0x22},
	{0x846a,0x85},
	{0x846b,0x2f},
	{0x846c,0x82},
	{0x846d,0x85},
	{0x846e,0x2e},
	{0x846f,0x83},
	{0x8470,0x22},
	{0x8471,0xff},
	{0x8472,0xe4},
	{0x8473,0x94},
	{0x8474,0x00},
	{0x8475,0xfe},
	{0x8476,0xe4},
	{0x8477,0xfc},
	{0x8478,0xfd},
	{0x8479,0x02},
	{0x847a,0x01},
	{0x847b,0x33},
	{0x847c,0xc2},
	{0x847d,0x07},
	{0x847e,0xc2},
	{0x847f,0x06},
	{0x8480,0xc2},
	{0x8481,0x02},
	{0x8482,0xc2},
	{0x8483,0x01},
	{0x8484,0xc2},
	{0x8485,0x00},
	{0x8486,0xc2},
	{0x8487,0x03},
	{0x8488,0xd2},
	{0x8489,0x04},
	{0x848a,0x22},
	{0x848b,0x90},
	{0x848c,0x33},
	{0x848d,0xb3},
	{0x848e,0xe4},
	{0x848f,0xf0},
	{0x8490,0xa3},
	{0x8491,0xf0},
	{0x8492,0xa3},
	{0x8493,0xf0},
	{0x8494,0xa3},
	{0x8495,0xf0},
	{0x8496,0x22},
	{0x8497,0xa3},
	{0x8498,0xe0},
	{0x8499,0xf5},
	{0x849a,0x22},
	{0x849b,0x75},
	{0x849c,0x32},
	{0x849d,0x0a},
	{0x849e,0x22},
	{0x849f,0x12},
	{0x84a0,0x00},
	{0x84a1,0xa1},
	{0x84a2,0x8f},
	{0x84a3,0x3c},
	{0x84a4,0x8e},
	{0x84a5,0x3b},
	{0x84a6,0x8d},
	{0x84a7,0x3a},
	{0x84a8,0x8c},
	{0x84a9,0x39},
	{0x84aa,0x22},
	{0x84ab,0xe4},
	{0x84ac,0x85},
	{0x84ad,0x0e},
	{0x84ae,0x0c},
	{0x84af,0x85},
	{0x84b0,0x0d},
	{0x84b1,0x0b},
	{0x84b2,0xf5},
	{0x84b3,0x0a},
	{0x84b4,0xf5},
	{0x84b5,0x09},
	{0x84b6,0x22},
	{0x84b7,0xe4},
	{0x84b8,0xfc},
	{0x84b9,0xfd},
	{0x84ba,0xfe},
	{0x84bb,0x02},
	{0x84bc,0x01},
	{0x84bd,0x33},
	{0x84be,0x90},
	{0x84bf,0x0b},
	{0x84c0,0x4c},
	{0x84c1,0xe4},
	{0x84c2,0x93},
	{0x84c3,0xff},
	{0x84c4,0x90},
	{0x84c5,0x30},
	{0x84c6,0x0a},
	{0x84c7,0xe0},
	{0x84c8,0x22},
	{0x84c9,0xc2},
	{0x84ca,0x02},
	{0x84cb,0xc2},
	{0x84cc,0x01},
	{0x84cd,0xd2},
	{0x84ce,0x00},
	{0x84cf,0xc2},
	{0x84d0,0x03},
	{0x84d1,0xc2},
	{0x84d2,0x04},
	{0x84d3,0x22},
	{0x84d4,0x75},
	{0x84d5,0xf0},
	{0x84d6,0x02},
	{0x84d7,0x02},
	{0x84d8,0x01},
	{0x84d9,0x46},
	{0x84da,0xe4},
	{0x84db,0x93},
	{0x84dc,0xf5},
	{0x84dd,0x43},
	{0x84de,0xa3},
	{0x84df,0xe4},
	{0x84e0,0x93},
	{0x84e1,0xf5},
	{0x84e2,0x28},
	{0x84e3,0x22},
	{0x84e4,0xd2},
	{0x84e5,0x02},
	{0x84e6,0xd2},
	{0x84e7,0x01},
	{0x84e8,0xc2},
	{0x84e9,0x00},
	{0x84ea,0x22},
	{0x84eb,0xd3},
	{0x84ec,0xe5},
	{0x84ed,0x3c},
	{0x84ee,0x94},
	{0x84ef,0xff},
	{0x84f0,0xe5},
	{0x84f1,0x3b},
	{0x84f2,0x94},
	{0x84f3,0x03},
	{0x84f4,0x22},
	{0x84f5,0x30},
	{0x84f6,0x04},
	{0x84f7,0x03},
	{0x84f8,0x02},
	{0x84f9,0x05},
	{0x84fa,0xd5},
	{0x84fb,0xd2},
	{0x84fc,0x04},
	{0x84fd,0xe5},
	{0x84fe,0x45},
	{0x84ff,0xb4},
	{0x8500,0x01},
	{0x8501,0x06},
	{0x8502,0x12},
	{0x8503,0x0c},
	{0x8504,0xfe},
	{0x8505,0x02},
	{0x8506,0x05},
	{0x8507,0xce},
	{0x8508,0xe5},
	{0x8509,0x45},
	{0x850a,0xb4},
	{0x850b,0x02},
	{0x850c,0x06},
	{0x850d,0x12},
	{0x850e,0x0d},
	{0x850f,0x0f},
	{0x8510,0x02},
	{0x8511,0x05},
	{0x8512,0xce},
	{0x8513,0xe5},
	{0x8514,0x45},
	{0x8515,0xb4},
	{0x8516,0x03},
	{0x8517,0x05},
	{0x8518,0xe4},
	{0x8519,0xf5},
	{0x851a,0x09},
	{0x851b,0x80},
	{0x851c,0x08},
	{0x851d,0xe5},
	{0x851e,0x45},
	{0x851f,0xb4},
	{0x8520,0x04},
	{0x8521,0x09},
	{0x8522,0x85},
	{0x8523,0x43},
	{0x8524,0x09},
	{0x8525,0x12},
	{0x8526,0x09},
	{0x8527,0xee},
	{0x8528,0x02},
	{0x8529,0x05},
	{0x852a,0xce},
	{0x852b,0xe5},
	{0x852c,0x45},
	{0x852d,0x64},
	{0x852e,0x0f},
	{0x852f,0x70},
	{0x8530,0x15},
	{0x8531,0x12},
	{0x8532,0x04},
	{0x8533,0xeb},
	{0x8534,0x40},
	{0x8535,0x06},
	{0x8536,0x7e},
	{0x8537,0x03},
	{0x8538,0x7f},
	{0x8539,0xff},
	{0x853a,0x80},
	{0x853b,0x04},
	{0x853c,0xae},
	{0x853d,0x3b},
	{0x853e,0xaf},
	{0x853f,0x3c},
	{0x8540,0x12},
	{0x8541,0x05},
	{0x8542,0xd6},
	{0x8543,0x02},
	{0x8544,0x05},
	{0x8545,0xce},
	{0x8546,0xe5},
	{0x8547,0x45},
	{0x8548,0x64},
	{0x8549,0x10},
	{0x854a,0x60},
	{0x854b,0x03},
	{0x854c,0x02},
	{0x854d,0x05},
	{0x854e,0xce},
	{0x854f,0xf5},
	{0x8550,0x39},
	{0x8551,0xf5},
	{0x8552,0x3a},
	{0x8553,0xf5},
	{0x8554,0x3b},
	{0x8555,0xab},
	{0x8556,0x3c},
	{0x8557,0xaa},
	{0x8558,0x3b},
	{0x8559,0xa9},
	{0x855a,0x3a},
	{0x855b,0xa8},
	{0x855c,0x39},
	{0x855d,0x12},
	{0x855e,0x04},
	{0x855f,0x10},
	{0x8560,0xfe},
	{0x8561,0xe4},
	{0x8562,0xfc},
	{0x8563,0xfd},
	{0x8564,0x12},
	{0x8565,0x04},
	{0x8566,0x39},
	{0x8567,0xe4},
	{0x8568,0x7b},
	{0x8569,0xff},
	{0x856a,0xfa},
	{0x856b,0xf9},
	{0x856c,0xf8},
	{0x856d,0x12},
	{0x856e,0x04},
	{0x856f,0x9f},
	{0x8570,0x12},
	{0x8571,0x04},
	{0x8572,0x6a},
	{0x8573,0xe4},
	{0x8574,0x93},
	{0x8575,0xfe},
	{0x8576,0x74},
	{0x8577,0x01},
	{0x8578,0x93},
	{0x8579,0xff},
	{0x857a,0xe4},
	{0x857b,0xfc},
	{0x857c,0xfd},
	{0x857d,0xe5},
	{0x857e,0x3c},
	{0x857f,0x2f},
	{0x8580,0xf5},
	{0x8581,0x3c},
	{0x8582,0xe5},
	{0x8583,0x3b},
	{0x8584,0x3e},
	{0x8585,0xf5},
	{0x8586,0x3b},
	{0x8587,0xed},
	{0x8588,0x35},
	{0x8589,0x3a},
	{0x858a,0xf5},
	{0x858b,0x3a},
	{0x858c,0xec},
	{0x858d,0x35},
	{0x858e,0x39},
	{0x858f,0xf5},
	{0x8590,0x39},
	{0x8591,0x12},
	{0x8592,0x04},
	{0x8593,0xeb},
	{0x8594,0x40},
	{0x8595,0x06},
	{0x8596,0x7e},
	{0x8597,0x03},
	{0x8598,0x7f},
	{0x8599,0xff},
	{0x859a,0x80},
	{0x859b,0x04},
	{0x859c,0xae},
	{0x859d,0x3b},
	{0x859e,0xaf},
	{0x859f,0x3c},
	{0x85a0,0x12},
	{0x85a1,0x05},
	{0x85a2,0xd6},
	{0x85a3,0xe4},
	{0x85a4,0xf5},
	{0x85a5,0x3a},
	{0x85a6,0xf5},
	{0x85a7,0x3a},
	{0x85a8,0xe5},
	{0x85a9,0x3a},
	{0x85aa,0xd3},
	{0x85ab,0x95},
	{0x85ac,0x43},
	{0x85ad,0x50},
	{0x85ae,0x1c},
	{0x85af,0x12},
	{0x85b0,0x04},
	{0x85b1,0x6a},
	{0x85b2,0xaf},
	{0x85b3,0x3a},
	{0x85b4,0x75},
	{0x85b5,0xf0},
	{0x85b6,0x02},
	{0x85b7,0xef},
	{0x85b8,0x12},
	{0x85b9,0x01},
	{0x85ba,0x46},
	{0x85bb,0xc3},
	{0x85bc,0x74},
	{0x85bd,0x01},
	{0x85be,0x93},
	{0x85bf,0x95},
	{0x85c0,0x3c},
	{0x85c1,0xe4},
	{0x85c2,0x93},
	{0x85c3,0x95},
	{0x85c4,0x3b},
	{0x85c5,0x50},
	{0x85c6,0x04},
	{0x85c7,0x05},
	{0x85c8,0x3a},
	{0x85c9,0x80},
	{0x85ca,0xdd},
	{0x85cb,0x85},
	{0x85cc,0x3a},
	{0x85cd,0x44},
	{0x85ce,0x90},
	{0x85cf,0x3f},
	{0x85d0,0x01},
	{0x85d1,0xe4},
	{0x85d2,0xf0},
	{0x85d3,0xd2},
	{0x85d4,0x25},
	{0x85d5,0x22},
	{0x85d6,0x8e},
	{0x85d7,0x3b},
	{0x85d8,0x8f},
	{0x85d9,0x3c},
	{0x85da,0x85},
	{0x85db,0x3b},
	{0x85dc,0x37},
	{0x85dd,0x85},
	{0x85de,0x3c},
	{0x85df,0x38},
	{0x85e0,0xe5},
	{0x85e1,0x3c},
	{0x85e2,0xc4},
	{0x85e3,0xf8},
	{0x85e4,0x54},
	{0x85e5,0x0f},
	{0x85e6,0xc8},
	{0x85e7,0x68},
	{0x85e8,0xf5},
	{0x85e9,0x3c},
	{0x85ea,0xe5},
	{0x85eb,0x3b},
	{0x85ec,0xc4},
	{0x85ed,0x54},
	{0x85ee,0xf0},
	{0x85ef,0x48},
	{0x85f0,0xf5},
	{0x85f1,0x3b},
	{0x85f2,0x85},
	{0x85f3,0x3b},
	{0x85f4,0x0a},
	{0x85f5,0x85},
	{0x85f6,0x3c},
	{0x85f7,0x0b},
	{0x85f8,0x12},
	{0x85f9,0x01},
	{0x85fa,0x78},
	{0x85fb,0x22},
	{0x85fc,0xe5},
	{0x85fd,0x29},
	{0x85fe,0x70},
	{0x85ff,0x03},
	{0x8600,0x02},
	{0x8601,0x06},
	{0x8602,0xd4},
	{0x8603,0xc2},
	{0x8604,0xaf},
	{0x8605,0xaf},
	{0x8606,0x29},
	{0x8607,0xe4},
	{0x8608,0xf5},
	{0x8609,0x29},
	{0x860a,0xd2},
	{0x860b,0xaf},
	{0x860c,0x90},
	{0x860d,0x3f},
	{0x860e,0x01},
	{0x860f,0xe0},
	{0x8610,0xf5},
	{0x8611,0x45},
	{0x8612,0xa3},
	{0x8613,0xe0},
	{0x8614,0xf5},
	{0x8615,0x39},
	{0x8616,0xa3},
	{0x8617,0xe0},
	{0x8618,0xf5},
	{0x8619,0x3a},
	{0x861a,0xa3},
	{0x861b,0xe0},
	{0x861c,0xf5},
	{0x861d,0x3b},
	{0x861e,0xa3},
	{0x861f,0xe0},
	{0x8620,0xf5},
	{0x8621,0x3c},
	{0x8622,0xef},
	{0x8623,0x12},
	{0x8624,0x01},
	{0x8625,0x52},
	{0x8626,0x06},
	{0x8627,0x4b},
	{0x8628,0x03},
	{0x8629,0x06},
	{0x862a,0x5a},
	{0x862b,0x05},
	{0x862c,0x06},
	{0x862d,0x81},
	{0x862e,0x06},
	{0x862f,0x06},
	{0x8630,0x6f},
	{0x8631,0x08},
	{0x8632,0x06},
	{0x8633,0xa2},
	{0x8634,0x09},
	{0x8635,0x06},
	{0x8636,0x8e},
	{0x8637,0x10},
	{0x8638,0x06},
	{0x8639,0xa2},
	{0x863a,0x12},
	{0x863b,0x06},
	{0x863c,0xa7},
	{0x863d,0x20},
	{0x863e,0x06},
	{0x863f,0xb5},
	{0x8640,0x21},
	{0x8641,0x06},
	{0x8642,0xba},
	{0x8643,0x30},
	{0x8644,0x06},
	{0x8645,0xc5},
	{0x8646,0xd0},
	{0x8647,0x00},
	{0x8648,0x00},
	{0x8649,0x06},
	{0x864a,0xc9},
	{0x864b,0x30},
	{0x864c,0x05},
	{0x864d,0x7b},
	{0x864e,0x20},
	{0x864f,0x00},
	{0x8650,0x78},
	{0x8651,0xd2},
	{0x8652,0x07},
	{0x8653,0xc2},
	{0x8654,0x06},
	{0x8655,0x12},
	{0x8656,0x04},
	{0x8657,0xc9},
	{0x8658,0x80},
	{0x8659,0x21},
	{0x865a,0x30},
	{0x865b,0x05},
	{0x865c,0x6c},
	{0x865d,0x20},
	{0x865e,0x00},
	{0x865f,0x69},
	{0x8660,0xc2},
	{0x8661,0x07},
	{0x8662,0xd2},
	{0x8663,0x06},
	{0x8664,0xc2},
	{0x8665,0x03},
	{0x8666,0x12},
	{0x8667,0x04},
	{0x8668,0xe4},
	{0x8669,0xc2},
	{0x866a,0x04},
	{0x866b,0xc2},
	{0x866c,0x21},
	{0x866d,0x80},
	{0x866e,0x5a},
	{0x866f,0x12},
	{0x8670,0x04},
	{0x8671,0x7c},
	{0x8672,0x30},
	{0x8673,0x05},
	{0x8674,0x06},
	{0x8675,0xe4},
	{0x8676,0xf5},
	{0x8677,0x09},
	{0x8678,0x12},
	{0x8679,0x09},
	{0x867a,0xee},
	{0x867b,0xc2},
	{0x867c,0x21},
	{0x867d,0xd2},
	{0x867e,0x25},
	{0x867f,0x80},
	{0x8680,0x48},
	{0x8681,0x30},
	{0x8682,0x07},
	{0x8683,0x45},
	{0x8684,0x30},
	{0x8685,0x06},
	{0x8686,0x42},
	{0x8687,0x12},
	{0x8688,0x04},
	{0x8689,0xc9},
	{0x868a,0xd2},
	{0x868b,0x21},
	{0x868c,0x80},
	{0x868d,0x3b},
	{0x868e,0x20},
	{0x868f,0x07},
	{0x8690,0x03},
	{0x8691,0x30},
	{0x8692,0x06},
	{0x8693,0x09},
	{0x8694,0xe5},
	{0x8695,0x45},
	{0x8696,0x64},
	{0x8697,0x0e},
	{0x8698,0x70},
	{0x8699,0x2f},
	{0x869a,0x20},
	{0x869b,0x00},
	{0x869c,0x2c},
	{0x869d,0x12},
	{0x869e,0x06},
	{0x869f,0xd5},
	{0x86a0,0x80},
	{0x86a1,0x27},
	{0x86a2,0x12},
	{0x86a3,0x02},
	{0x86a4,0xc4},
	{0x86a5,0x80},
	{0x86a6,0x22},
	{0x86a7,0x30},
	{0x86a8,0x05},
	{0x86a9,0x1f},
	{0x86aa,0x20},
	{0x86ab,0x07},
	{0x86ac,0x1c},
	{0x86ad,0x20},
	{0x86ae,0x06},
	{0x86af,0x19},
	{0x86b0,0x12},
	{0x86b1,0x0c},
	{0x86b2,0xa6},
	{0x86b3,0x80},
	{0x86b4,0x14},
	{0x86b5,0x12},
	{0x86b6,0x09},
	{0x86b7,0x85},
	{0x86b8,0x80},
	{0x86b9,0x0f},
	{0x86ba,0x20},
	{0x86bb,0x07},
	{0x86bc,0x0c},
	{0x86bd,0x20},
	{0x86be,0x06},
	{0x86bf,0x09},
	{0x86c0,0x12},
	{0x86c1,0x0d},
	{0x86c2,0x3c},
	{0x86c3,0x80},
	{0x86c4,0x04},
	{0x86c5,0xd2},
	{0x86c6,0x26},
	{0x86c7,0xc2},
	{0x86c8,0x26},
	{0x86c9,0x20},
	{0x86ca,0x07},
	{0x86cb,0x03},
	{0x86cc,0x20},
	{0x86cd,0x06},
	{0x86ce,0x05},
	{0x86cf,0x90},
	{0x86d0,0x3f},
	{0x86d1,0x01},
	{0x86d2,0xe4},
	{0x86d3,0xf0},
	{0x86d4,0x22},
	{0x86d5,0xe5},
	{0x86d6,0x45},
	{0x86d7,0x24},
	{0x86d8,0xfe},
	{0x86d9,0x60},
	{0x86da,0x19},
	{0x86db,0x14},
	{0x86dc,0x60},
	{0x86dd,0x2c},
	{0x86de,0x24},
	{0x86df,0x02},
	{0x86e0,0x60},
	{0x86e1,0x03},
	{0x86e2,0x02},
	{0x86e3,0x07},
	{0x86e4,0xa8},
	{0x86e5,0xe5},
	{0x86e6,0x3c},
	{0x86e7,0xd3},
	{0x86e8,0x94},
	{0x86e9,0x03},
	{0x86ea,0x40},
	{0x86eb,0x03},
	{0x86ec,0x75},
	{0x86ed,0x3c},
	{0x86ee,0x03},
	{0x86ef,0xe4},
	{0x86f0,0xf5},
	{0x86f1,0x09},
	{0x86f2,0x80},
	{0x86f3,0x0d},
	{0x86f4,0xe5},
	{0x86f5,0x3c},
	{0x86f6,0xd3},
	{0x86f7,0x94},
	{0x86f8,0x05},
	{0x86f9,0x40},
	{0x86fa,0x03},
	{0x86fb,0x75},
	{0x86fc,0x3c},
	{0x86fd,0x05},
	{0x86fe,0x75},
	{0x86ff,0x09},
	{0x8700,0x01},
	{0x8701,0x85},
	{0x8702,0x3c},
	{0x8703,0x0a},
	{0x8704,0x12},
	{0x8705,0x08},
	{0x8706,0xfa},
	{0x8707,0xd2},
	{0x8708,0x20},
	{0x8709,0x22},
	{0x870a,0xe5},
	{0x870b,0x39},
	{0x870c,0xd3},
	{0x870d,0x94},
	{0x870e,0x28},
	{0x870f,0x40},
	{0x8710,0x04},
	{0x8711,0x7f},
	{0x8712,0x28},
	{0x8713,0x80},
	{0x8714,0x02},
	{0x8715,0xaf},
	{0x8716,0x39},
	{0x8717,0x8f},
	{0x8718,0x39},
	{0x8719,0xe5},
	{0x871a,0x3a},
	{0x871b,0xd3},
	{0x871c,0x94},
	{0x871d,0x1e},
	{0x871e,0x40},
	{0x871f,0x04},
	{0x8720,0x7f},
	{0x8721,0x1e},
	{0x8722,0x80},
	{0x8723,0x02},
	{0x8724,0xaf},
	{0x8725,0x3a},
	{0x8726,0x8f},
	{0x8727,0x3a},
	{0x8728,0xe5},
	{0x8729,0x3b},
	{0x872a,0xd3},
	{0x872b,0x94},
	{0x872c,0x28},
	{0x872d,0x40},
	{0x872e,0x04},
	{0x872f,0x7f},
	{0x8730,0x28},
	{0x8731,0x80},
	{0x8732,0x02},
	{0x8733,0xaf},
	{0x8734,0x3b},
	{0x8735,0x8f},
	{0x8736,0x3b},
	{0x8737,0xe5},
	{0x8738,0x3c},
	{0x8739,0xd3},
	{0x873a,0x94},
	{0x873b,0x1e},
	{0x873c,0x40},
	{0x873d,0x04},
	{0x873e,0x7f},
	{0x873f,0x1e},
	{0x8740,0x80},
	{0x8741,0x02},
	{0x8742,0xaf},
	{0x8743,0x3c},
	{0x8744,0x8f},
	{0x8745,0x3c},
	{0x8746,0xaf},
	{0x8747,0x3a},
	{0x8748,0x78},
	{0x8749,0x10},
	{0x874a,0x12},
	{0x874b,0x04},
	{0x874c,0xb7},
	{0x874d,0xc0},
	{0x874e,0x04},
	{0x874f,0xc0},
	{0x8750,0x05},
	{0x8751,0xc0},
	{0x8752,0x06},
	{0x8753,0xc0},
	{0x8754,0x07},
	{0x8755,0xaf},
	{0x8756,0x39},
	{0x8757,0x78},
	{0x8758,0x18},
	{0x8759,0x12},
	{0x875a,0x04},
	{0x875b,0xb7},
	{0x875c,0xd0},
	{0x875d,0x03},
	{0x875e,0xd0},
	{0x875f,0x02},
	{0x8760,0xd0},
	{0x8761,0x01},
	{0x8762,0xd0},
	{0x8763,0x00},
	{0x8764,0xef},
	{0x8765,0x4b},
	{0x8766,0xff},
	{0x8767,0xee},
	{0x8768,0x4a},
	{0x8769,0xfe},
	{0x876a,0xed},
	{0x876b,0x49},
	{0x876c,0xfd},
	{0x876d,0xec},
	{0x876e,0x48},
	{0x876f,0xfc},
	{0x8770,0xc0},
	{0x8771,0x04},
	{0x8772,0xc0},
	{0x8773,0x05},
	{0x8774,0xc0},
	{0x8775,0x06},
	{0x8776,0xc0},
	{0x8777,0x07},
	{0x8778,0xaf},
	{0x8779,0x3b},
	{0x877a,0xe4},
	{0x877b,0xfc},
	{0x877c,0xfd},
	{0x877d,0xfe},
	{0x877e,0x78},
	{0x877f,0x08},
	{0x8780,0x12},
	{0x8781,0x01},
	{0x8782,0x33},
	{0x8783,0xd0},
	{0x8784,0x03},
	{0x8785,0xd0},
	{0x8786,0x02},
	{0x8787,0xd0},
	{0x8788,0x01},
	{0x8789,0xd0},
	{0x878a,0x00},
	{0x878b,0xef},
	{0x878c,0x4b},
	{0x878d,0xfb},
	{0x878e,0xee},
	{0x878f,0x4a},
	{0x8790,0xfa},
	{0x8791,0xed},
	{0x8792,0x49},
	{0x8793,0xf9},
	{0x8794,0xec},
	{0x8795,0x48},
	{0x8796,0xf8},
	{0x8797,0xaf},
	{0x8798,0x3c},
	{0x8799,0xeb},
	{0x879a,0x4f},
	{0x879b,0xf5},
	{0x879c,0x2d},
	{0x879d,0xea},
	{0x879e,0xf5},
	{0x879f,0x2c},
	{0x87a0,0xe9},
	{0x87a1,0xf5},
	{0x87a2,0x2b},
	{0x87a3,0xe8},
	{0x87a4,0xf5},
	{0x87a5,0x2a},
	{0x87a6,0xd2},
	{0x87a7,0x20},
	{0x87a8,0x22},
	{0x87a9,0xc0},
	{0x87aa,0xe0},
	{0x87ab,0xc0},
	{0x87ac,0x83},
	{0x87ad,0xc0},
	{0x87ae,0x82},
	{0x87af,0xc0},
	{0x87b0,0xd0},
	{0x87b1,0x75},
	{0x87b2,0xd0},
	{0x87b3,0x00},
	{0x87b4,0xc0},
	{0x87b5,0x00},
	{0x87b6,0xc0},
	{0x87b7,0x06},
	{0x87b8,0xc0},
	{0x87b9,0x07},
	{0x87ba,0x90},
	{0x87bb,0x37},
	{0x87bc,0x08},
	{0x87bd,0xe0},
	{0x87be,0xf5},
	{0x87bf,0x08},
	{0x87c0,0xe5},
	{0x87c1,0x08},
	{0x87c2,0x30},
	{0x87c3,0xe3},
	{0x87c4,0x23},
	{0x87c5,0x20},
	{0x87c6,0x26},
	{0x87c7,0x20},
	{0x87c8,0x90},
	{0x87c9,0x3a},
	{0x87ca,0x00},
	{0x87cb,0x74},
	{0x87cc,0x81},
	{0x87cd,0xf0},
	{0x87ce,0x90},
	{0x87cf,0x3a},
	{0x87d0,0x03},
	{0x87d1,0xe0},
	{0x87d2,0xf5},
	{0x87d3,0x3e},
	{0x87d4,0xe0},
	{0x87d5,0xf5},
	{0x87d6,0x3d},
	{0x87d7,0x90},
	{0x87d8,0x3a},
	{0x87d9,0x00},
	{0x87da,0x74},
	{0x87db,0x85},
	{0x87dc,0xf0},
	{0x87dd,0x90},
	{0x87de,0x3a},
	{0x87df,0x03},
	{0x87e0,0xe0},
	{0x87e1,0xf5},
	{0x87e2,0x40},
	{0x87e3,0xe0},
	{0x87e4,0xf5},
	{0x87e5,0x3f},
	{0x87e6,0xd2},
	{0x87e7,0x2f},
	{0x87e8,0xe5},
	{0x87e9,0x08},
	{0x87ea,0x30},
	{0x87eb,0xe5},
	{0x87ec,0x56},
	{0x87ed,0x90},
	{0x87ee,0x30},
	{0x87ef,0x1b},
	{0x87f0,0xe0},
	{0x87f1,0xf5},
	{0x87f2,0x42},
	{0x87f3,0xe5},
	{0x87f4,0x41},
	{0x87f5,0x24},
	{0x87f6,0x02},
	{0x87f7,0xff},
	{0x87f8,0xe4},
	{0x87f9,0x33},
	{0x87fa,0xfe},
	{0x87fb,0xc3},
	{0x87fc,0xef},
	{0x87fd,0x95},
	{0x87fe,0x42},
	{0x87ff,0x74},
	{0x8800,0x80},
	{0x8801,0xf8},
	{0x8802,0x6e},
	{0x8803,0x98},
	{0x8804,0x50},
	{0x8805,0x02},
	{0x8806,0x80},
	{0x8807,0x01},
	{0x8808,0xc3},
	{0x8809,0x92},
	{0x880a,0x24},
	{0x880b,0xe5},
	{0x880c,0x42},
	{0x880d,0x24},
	{0x880e,0x02},
	{0x880f,0xff},
	{0x8810,0xe4},
	{0x8811,0x33},
	{0x8812,0xfe},
	{0x8813,0xc3},
	{0x8814,0xef},
	{0x8815,0x95},
	{0x8816,0x41},
	{0x8817,0x74},
	{0x8818,0x80},
	{0x8819,0xf8},
	{0x881a,0x6e},
	{0x881b,0x98},
	{0x881c,0x50},
	{0x881d,0x02},
	{0x881e,0x80},
	{0x881f,0x02},
	{0x8820,0xa2},
	{0x8821,0x24},
	{0x8822,0x92},
	{0x8823,0x24},
	{0x8824,0x30},
	{0x8825,0x24},
	{0x8826,0x04},
	{0x8827,0xaf},
	{0x8828,0x42},
	{0x8829,0x80},
	{0x882a,0x02},
	{0x882b,0xaf},
	{0x882c,0x41},
	{0x882d,0x8f},
	{0x882e,0x41},
	{0x882f,0x30},
	{0x8830,0x27},
	{0x8831,0x11},
	{0x8832,0x90},
	{0x8833,0x33},
	{0x8834,0x00},
	{0x8835,0xe0},
	{0x8836,0x30},
	{0x8837,0x29},
	{0x8838,0x05},
	{0x8839,0x44},
	{0x883a,0x40},
	{0x883b,0xf0},
	{0x883c,0x80},
	{0x883d,0x03},
	{0x883e,0x54},
	{0x883f,0xbf},
	{0x8840,0xf0},
	{0x8841,0xc2},
	{0x8842,0x27},
	{0x8843,0xe5},
	{0x8844,0x08},
	{0x8845,0x30},
	{0x8846,0xe1},
	{0x8847,0x08},
	{0x8848,0x90},
	{0x8849,0x3f},
	{0x884a,0x00},
	{0x884b,0xe0},
	{0x884c,0xf5},
	{0x884d,0x29},
	{0x884e,0xe4},
	{0x884f,0xf0},
	{0x8850,0x90},
	{0x8851,0x37},
	{0x8852,0x08},
	{0x8853,0xe5},
	{0x8854,0x08},
	{0x8855,0xf0},
	{0x8856,0xd0},
	{0x8857,0x07},
	{0x8858,0xd0},
	{0x8859,0x06},
	{0x885a,0xd0},
	{0x885b,0x00},
	{0x885c,0xd0},
	{0x885d,0xd0},
	{0x885e,0xd0},
	{0x885f,0x82},
	{0x8860,0xd0},
	{0x8861,0x83},
	{0x8862,0xd0},
	{0x8863,0xe0},
	{0x8864,0x32},
	{0x8865,0x12},
	{0x8866,0x04},
	{0x8867,0xbe},
	{0x8868,0xb5},
	{0x8869,0x07},
	{0x886a,0x03},
	{0x886b,0xd3},
	{0x886c,0x80},
	{0x886d,0x01},
	{0x886e,0xc3},
	{0x886f,0x40},
	{0x8870,0x03},
	{0x8871,0x02},
	{0x8872,0x08},
	{0x8873,0xf9},
	{0x8874,0x90},
	{0x8875,0x31},
	{0x8876,0x00},
	{0x8877,0xe0},
	{0x8878,0x54},
	{0x8879,0xfe},
	{0x887a,0xf0},
	{0x887b,0xe0},
	{0x887c,0x54},
	{0x887d,0xfd},
	{0x887e,0xf0},
	{0x887f,0xa3},
	{0x8880,0xe4},
	{0x8881,0xf0},
	{0x8882,0x90},
	{0x8883,0x33},
	{0x8884,0x00},
	{0x8885,0xe0},
	{0x8886,0x54},
	{0x8887,0xbf},
	{0x8888,0xf0},
	{0x8889,0x12},
	{0x888a,0x04},
	{0x888b,0x8b},
	{0x888c,0x90},
	{0x888d,0x33},
	{0x888e,0xb0},
	{0x888f,0xf0},
	{0x8890,0xa3},
	{0x8891,0xf0},
	{0x8892,0xa3},
	{0x8893,0xf0},
	{0x8894,0x90},
	{0x8895,0x30},
	{0x8896,0xb2},
	{0x8897,0xe0},
	{0x8898,0x44},
	{0x8899,0x08},
	{0x889a,0xf0},
	{0x889b,0x90},
	{0x889c,0x30},
	{0x889d,0xb0},
	{0x889e,0xe0},
	{0x889f,0x44},
	{0x88a0,0x01},
	{0x88a1,0xf0},
	{0x88a2,0xa3},
	{0x88a3,0xe0},
	{0x88a4,0x44},
	{0x88a5,0x0c},
	{0x88a6,0xf0},
	{0x88a7,0x90},
	{0x88a8,0x30},
	{0x88a9,0xb4},
	{0x88aa,0xe0},
	{0x88ab,0x44},
	{0x88ac,0x07},
	{0x88ad,0xf0},
	{0x88ae,0xe0},
	{0x88af,0xf5},
	{0x88b0,0x23},
	{0x88b1,0x90},
	{0x88b2,0x30},
	{0x88b3,0xb1},
	{0x88b4,0xe0},
	{0x88b5,0xf5},
	{0x88b6,0x21},
	{0x88b7,0x90},
	{0x88b8,0x39},
	{0x88b9,0x01},
	{0x88ba,0x74},
	{0x88bb,0x35},
	{0x88bc,0xf0},
	{0x88bd,0x90},
	{0x88be,0x39},
	{0x88bf,0x00},
	{0x88c0,0x74},
	{0x88c1,0x20},
	{0x88c2,0xf0},
	{0x88c3,0x90},
	{0x88c4,0x37},
	{0x88c5,0x00},
	{0x88c6,0x74},
	{0x88c7,0xff},
	{0x88c8,0xf0},
	{0x88c9,0xa3},
	{0x88ca,0xf0},
	{0x88cb,0x90},
	{0x88cc,0x37},
	{0x88cd,0x00},
	{0x88ce,0xe0},
	{0x88cf,0x54},
	{0x88d0,0xf7},
	{0x88d1,0xf0},
	{0x88d2,0xe0},
	{0x88d3,0x54},
	{0x88d4,0xdf},
	{0x88d5,0xf0},
	{0x88d6,0x90},
	{0x88d7,0x31},
	{0x88d8,0x0f},
	{0x88d9,0x74},
	{0x88da,0x3f},
	{0x88db,0xf0},
	{0x88dc,0xa3},
	{0x88dd,0xe4},
	{0x88de,0xf0},
	{0x88df,0xa3},
	{0x88e0,0x74},
	{0x88e1,0x3f},
	{0x88e2,0xf0},
	{0x88e3,0xa3},
	{0x88e4,0x74},
	{0x88e5,0x01},
	{0x88e6,0xf0},
	{0x88e7,0x90},
	{0x88e8,0x37},
	{0x88e9,0x00},
	{0x88ea,0xe0},
	{0x88eb,0x54},
	{0x88ec,0xfd},
	{0x88ed,0xf0},
	{0x88ee,0x90},
	{0x88ef,0x37},
	{0x88f0,0x08},
	{0x88f1,0x74},
	{0x88f2,0xff},
	{0x88f3,0xf0},
	{0x88f4,0xa3},
	{0x88f5,0xf0},
	{0x88f6,0x75},
	{0x88f7,0xa8},
	{0x88f8,0x01},
	{0x88f9,0x22},
	{0x88fa,0xe5},
	{0x88fb,0x0a},
	{0x88fc,0x25},
	{0x88fd,0xe0},
	{0x88fe,0x25},
	{0x88ff,0xe0},
	{0x8900,0xf5},
	{0x8901,0x0b},
	{0x8902,0xe5},
	{0x8903,0x09},
	{0x8904,0x60},
	{0x8905,0x09},
	{0x8906,0xe5},
	{0x8907,0x0a},
	{0x8908,0x75},
	{0x8909,0xf0},
	{0x890a,0x03},
	{0x890b,0xa4},
	{0x890c,0xff},
	{0x890d,0x80},
	{0x890e,0x02},
	{0x890f,0xaf},
	{0x8910,0x0b},
	{0x8911,0x8f},
	{0x8912,0x0c},
	{0x8913,0xc3},
	{0x8914,0x74},
	{0x8915,0x0f},
	{0x8916,0x9f},
	{0x8917,0x78},
	{0x8918,0x10},
	{0x8919,0x12},
	{0x891a,0x04},
	{0x891b,0x71},
	{0x891c,0xc0},
	{0x891d,0x04},
	{0x891e,0xc0},
	{0x891f,0x05},
	{0x8920,0xc0},
	{0x8921,0x06},
	{0x8922,0xc0},
	{0x8923,0x07},
	{0x8924,0xc3},
	{0x8925,0x74},
	{0x8926,0x14},
	{0x8927,0x95},
	{0x8928,0x0b},
	{0x8929,0x78},
	{0x892a,0x18},
	{0x892b,0x12},
	{0x892c,0x04},
	{0x892d,0x71},
	{0x892e,0xd0},
	{0x892f,0x03},
	{0x8930,0xd0},
	{0x8931,0x02},
	{0x8932,0xd0},
	{0x8933,0x01},
	{0x8934,0xd0},
	{0x8935,0x00},
	{0x8936,0xef},
	{0x8937,0x4b},
	{0x8938,0xff},
	{0x8939,0xee},
	{0x893a,0x4a},
	{0x893b,0xfe},
	{0x893c,0xed},
	{0x893d,0x49},
	{0x893e,0xfd},
	{0x893f,0xec},
	{0x8940,0x48},
	{0x8941,0xfc},
	{0x8942,0xc0},
	{0x8943,0x04},
	{0x8944,0xc0},
	{0x8945,0x05},
	{0x8946,0xc0},
	{0x8947,0x06},
	{0x8948,0xc0},
	{0x8949,0x07},
	{0x894a,0xe5},
	{0x894b,0x0b},
	{0x894c,0x24},
	{0x894d,0x14},
	{0x894e,0xff},
	{0x894f,0xe4},
	{0x8950,0x33},
	{0x8951,0xfe},
	{0x8952,0xe4},
	{0x8953,0xfc},
	{0x8954,0xfd},
	{0x8955,0x78},
	{0x8956,0x08},
	{0x8957,0x12},
	{0x8958,0x01},
	{0x8959,0x33},
	{0x895a,0xd0},
	{0x895b,0x03},
	{0x895c,0xd0},
	{0x895d,0x02},
	{0x895e,0xd0},
	{0x895f,0x01},
	{0x8960,0xd0},
	{0x8961,0x00},
	{0x8962,0xef},
	{0x8963,0x4b},
	{0x8964,0xfb},
	{0x8965,0xee},
	{0x8966,0x4a},
	{0x8967,0xfa},
	{0x8968,0xed},
	{0x8969,0x49},
	{0x896a,0xf9},
	{0x896b,0xec},
	{0x896c,0x48},
	{0x896d,0xf8},
	{0x896e,0xe5},
	{0x896f,0x0c},
	{0x8970,0x24},
	{0x8971,0x0f},
	{0x8972,0xff},
	{0x8973,0xe4},
	{0x8974,0x33},
	{0x8975,0xfe},
	{0x8976,0xeb},
	{0x8977,0x4f},
	{0x8978,0xf5},
	{0x8979,0x2d},
	{0x897a,0xea},
	{0x897b,0x4e},
	{0x897c,0xf5},
	{0x897d,0x2c},
	{0x897e,0xe9},
	{0x897f,0xf5},
	{0x8980,0x2b},
	{0x8981,0xe8},
	{0x8982,0xf5},
	{0x8983,0x2a},
	{0x8984,0x22},
	{0x8985,0xe5},
	{0x8986,0x45},
	{0x8987,0x64},
	{0x8988,0x01},
	{0x8989,0x70},
	{0x898a,0x50},
	{0x898b,0x12},
	{0x898c,0x04},
	{0x898d,0x6a},
	{0x898e,0xe5},
	{0x898f,0x44},
	{0x8990,0x12},
	{0x8991,0x04},
	{0x8992,0x18},
	{0x8993,0xfe},
	{0x8994,0xe4},
	{0x8995,0x8f},
	{0x8996,0x3c},
	{0x8997,0x8e},
	{0x8998,0x3b},
	{0x8999,0xf5},
	{0x899a,0x3a},
	{0x899b,0xf5},
	{0x899c,0x39},
	{0x899d,0x12},
	{0x899e,0x04},
	{0x899f,0x44},
	{0x89a0,0x7b},
	{0x89a1,0xff},
	{0x89a2,0xfa},
	{0x89a3,0xf9},
	{0x89a4,0xf8},
	{0x89a5,0x12},
	{0x89a6,0x04},
	{0x89a7,0x39},
	{0x89a8,0xc0},
	{0x89a9,0x04},
	{0x89aa,0xc0},
	{0x89ab,0x05},
	{0x89ac,0xc0},
	{0x89ad,0x06},
	{0x89ae,0xc0},
	{0x89af,0x07},
	{0x89b0,0x12},
	{0x89b1,0x04},
	{0x89b2,0x10},
	{0x89b3,0xab},
	{0x89b4,0x07},
	{0x89b5,0xfa},
	{0x89b6,0xe4},
	{0x89b7,0xf9},
	{0x89b8,0xf8},
	{0x89b9,0xd0},
	{0x89ba,0x07},
	{0x89bb,0xd0},
	{0x89bc,0x06},
	{0x89bd,0xd0},
	{0x89be,0x05},
	{0x89bf,0xd0},
	{0x89c0,0x04},
	{0x89c1,0x12},
	{0x89c2,0x04},
	{0x89c3,0x9f},
	{0x89c4,0x85},
	{0x89c5,0x3c},
	{0x89c6,0x39},
	{0x89c7,0x85},
	{0x89c8,0x44},
	{0x89c9,0x3a},
	{0x89ca,0x12},
	{0x89cb,0x04},
	{0x89cc,0x6a},
	{0x89cd,0xe5},
	{0x89ce,0x44},
	{0x89cf,0x12},
	{0x89d0,0x04},
	{0x89d1,0xd4},
	{0x89d2,0xe4},
	{0x89d3,0x93},
	{0x89d4,0xf5},
	{0x89d5,0x3b},
	{0x89d6,0x74},
	{0x89d7,0x01},
	{0x89d8,0x93},
	{0x89d9,0xf5},
	{0x89da,0x3c},
	{0x89db,0x90},
	{0x89dc,0x3f},
	{0x89dd,0x02},
	{0x89de,0xe5},
	{0x89df,0x39},
	{0x89e0,0xf0},
	{0x89e1,0xa3},
	{0x89e2,0xe5},
	{0x89e3,0x3a},
	{0x89e4,0xf0},
	{0x89e5,0xa3},
	{0x89e6,0xe5},
	{0x89e7,0x3b},
	{0x89e8,0xf0},
	{0x89e9,0xa3},
	{0x89ea,0xe5},
	{0x89eb,0x3c},
	{0x89ec,0xf0},
	{0x89ed,0x22},
	{0x89ee,0xe5},
	{0x89ef,0x09},
	{0x89f0,0xd3},
	{0x89f1,0x95},
	{0x89f2,0x43},
	{0x89f3,0x40},
	{0x89f4,0x01},
	{0x89f5,0x22},
	{0x89f6,0x12},
	{0x89f7,0x04},
	{0x89f8,0x6a},
	{0x89f9,0xe5},
	{0x89fa,0x09},
	{0x89fb,0x12},
	{0x89fc,0x04},
	{0x89fd,0xd4},
	{0x89fe,0xe4},
	{0x89ff,0x93},
	{0x8a00,0xfe},
	{0x8a01,0x74},
	{0x8a02,0x01},
	{0x8a03,0x93},
	{0x8a04,0xff},
	{0x8a05,0x4e},
	{0x8a06,0x60},
	{0x8a07,0x21},
	{0x8a08,0x8e},
	{0x8a09,0x37},
	{0x8a0a,0x8f},
	{0x8a0b,0x38},
	{0x8a0c,0xef},
	{0x8a0d,0xc4},
	{0x8a0e,0xf8},
	{0x8a0f,0x54},
	{0x8a10,0x0f},
	{0x8a11,0xc8},
	{0x8a12,0x68},
	{0x8a13,0xff},
	{0x8a14,0xee},
	{0x8a15,0xc4},
	{0x8a16,0x54},
	{0x8a17,0xf0},
	{0x8a18,0x48},
	{0x8a19,0xfe},
	{0x8a1a,0x43},
	{0x8a1b,0x07},
	{0x8a1c,0x0d},
	{0x8a1d,0x8e},
	{0x8a1e,0x0a},
	{0x8a1f,0x8f},
	{0x8a20,0x0b},
	{0x8a21,0x12},
	{0x8a22,0x01},
	{0x8a23,0x78},
	{0x8a24,0x30},
	{0x8a25,0x23},
	{0x8a26,0x22},
	{0x8a27,0xc3},
	{0x8a28,0x22},
	{0x8a29,0x75},
	{0x8a2a,0x0a},
	{0x8a2b,0x00},
	{0x8a2c,0x75},
	{0x8a2d,0x0b},
	{0x8a2e,0x0d},
	{0x8a2f,0x12},
	{0x8a30,0x01},
	{0x8a31,0x78},
	{0x8a32,0x30},
	{0x8a33,0x23},
	{0x8a34,0x02},
	{0x8a35,0xc3},
	{0x8a36,0x22},
	{0x8a37,0x75},
	{0x8a38,0x0a},
	{0x8a39,0x00},
	{0x8a3a,0x75},
	{0x8a3b,0x0b},
	{0x8a3c,0x64},
	{0x8a3d,0x12},
	{0x8a3e,0x0c},
	{0x8a3f,0x67},
	{0x8a40,0x75},
	{0x8a41,0x0a},
	{0x8a42,0x80},
	{0x8a43,0x75},
	{0x8a44,0x0b},
	{0x8a45,0x00},
	{0x8a46,0x12},
	{0x8a47,0x01},
	{0x8a48,0x78},
	{0x8a49,0x85},
	{0x8a4a,0x09},
	{0x8a4b,0x44},
	{0x8a4c,0xd3},
	{0x8a4d,0x22},
	{0x8a4e,0xc2},
	{0x8a4f,0x25},
	{0x8a50,0x20},
	{0x8a51,0x05},
	{0x8a52,0x05},
	{0x8a53,0x75},
	{0x8a54,0x09},
	{0x8a55,0xee},
	{0x8a56,0x80},
	{0x8a57,0x36},
	{0x8a58,0x20},
	{0x8a59,0x07},
	{0x8a5a,0x08},
	{0x8a5b,0x20},
	{0x8a5c,0x06},
	{0x8a5d,0x05},
	{0x8a5e,0xe4},
	{0x8a5f,0xf5},
	{0x8a60,0x09},
	{0x8a61,0x80},
	{0x8a62,0x2b},
	{0x8a63,0x20},
	{0x8a64,0x07},
	{0x8a65,0x08},
	{0x8a66,0x30},
	{0x8a67,0x06},
	{0x8a68,0x05},
	{0x8a69,0x75},
	{0x8a6a,0x09},
	{0x8a6b,0x20},
	{0x8a6c,0x80},
	{0x8a6d,0x20},
	{0x8a6e,0x30},
	{0x8a6f,0x00},
	{0x8a70,0x05},
	{0x8a71,0x75},
	{0x8a72,0x09},
	{0x8a73,0x01},
	{0x8a74,0x80},
	{0x8a75,0x18},
	{0x8a76,0xe5},
	{0x8a77,0x20},
	{0x8a78,0x54},
	{0x8a79,0x07},
	{0x8a7a,0xff},
	{0x8a7b,0xbf},
	{0x8a7c,0x06},
	{0x8a7d,0x0d},
	{0x8a7e,0x30},
	{0x8a7f,0x21},
	{0x8a80,0x04},
	{0x8a81,0x7f},
	{0x8a82,0x12},
	{0x8a83,0x80},
	{0x8a84,0x02},
	{0x8a85,0x7f},
	{0x8a86,0x02},
	{0x8a87,0x8f},
	{0x8a88,0x09},
	{0x8a89,0x80},
	{0x8a8a,0x03},
	{0x8a8b,0x75},
	{0x8a8c,0x09},
	{0x8a8d,0xfe},
	{0x8a8e,0x90},
	{0x8a8f,0x3f},
	{0x8a90,0x07},
	{0x8a91,0xe5},
	{0x8a92,0x09},
	{0x8a93,0xf0},
	{0x8a94,0x90},
	{0x8a95,0x3f},
	{0x8a96,0x06},
	{0x8a97,0xe5},
	{0x8a98,0x44},
	{0x8a99,0xf0},
	{0x8a9a,0x22},
	{0x8a9b,0x85},
	{0x8a9c,0x0d},
	{0x8a9d,0x0e},
	{0x8a9e,0x7f},
	{0x8a9f,0x08},
	{0x8aa0,0xe5},
	{0x8aa1,0x0e},
	{0x8aa2,0x30},
	{0x8aa3,0xe7},
	{0x8aa4,0x04},
	{0x8aa5,0xd2},
	{0x8aa6,0x19},
	{0x8aa7,0x80},
	{0x8aa8,0x02},
	{0x8aa9,0xc2},
	{0x8aaa,0x19},
	{0x8aab,0x12},
	{0x8aac,0x04},
	{0x8aad,0x09},
	{0x8aae,0x75},
	{0x8aaf,0x32},
	{0x8ab0,0x0a},
	{0x8ab1,0xae},
	{0x8ab2,0x32},
	{0x8ab3,0x15},
	{0x8ab4,0x32},
	{0x8ab5,0xee},
	{0x8ab6,0x70},
	{0x8ab7,0xf9},
	{0x8ab8,0xe5},
	{0x8ab9,0x0e},
	{0x8aba,0x25},
	{0x8abb,0xe0},
	{0x8abc,0xf5},
	{0x8abd,0x0e},
	{0x8abe,0xd2},
	{0x8abf,0x18},
	{0x8ac0,0x12},
	{0x8ac1,0x04},
	{0x8ac2,0x09},
	{0x8ac3,0x75},
	{0x8ac4,0x32},
	{0x8ac5,0x0a},
	{0x8ac6,0xae},
	{0x8ac7,0x32},
	{0x8ac8,0x15},
	{0x8ac9,0x32},
	{0x8aca,0xee},
	{0x8acb,0x70},
	{0x8acc,0xf9},
	{0x8acd,0xc2},
	{0x8ace,0x18},
	{0x8acf,0x12},
	{0x8ad0,0x04},
	{0x8ad1,0x09},
	{0x8ad2,0x75},
	{0x8ad3,0x32},
	{0x8ad4,0x05},
	{0x8ad5,0xae},
	{0x8ad6,0x32},
	{0x8ad7,0x15},
	{0x8ad8,0x32},
	{0x8ad9,0xee},
	{0x8ada,0x70},
	{0x8adb,0xf9},
	{0x8adc,0xdf},
	{0x8add,0xc2},
	{0x8ade,0x22},
	{0x8adf,0x90},
	{0x8ae0,0x3f},
	{0x8ae1,0x07},
	{0x8ae2,0x74},
	{0x8ae3,0xfa},
	{0x8ae4,0xf0},
	{0x8ae5,0x12},
	{0x8ae6,0x08},
	{0x8ae7,0x65},
	{0x8ae8,0x12},
	{0x8ae9,0x0b},
	{0x8aea,0xfb},
	{0x8aeb,0xe4},
	{0x8aec,0xf5},
	{0x8aed,0x29},
	{0x8aee,0xd2},
	{0x8aef,0xaf},
	{0x8af0,0x12},
	{0x8af1,0x05},
	{0x8af2,0xfc},
	{0x8af3,0x30},
	{0x8af4,0x20},
	{0x8af5,0x03},
	{0x8af6,0x12},
	{0x8af7,0x02},
	{0x8af8,0xc4},
	{0x8af9,0x30},
	{0x8afa,0x25},
	{0x8afb,0x03},
	{0x8afc,0x12},
	{0x8afd,0x0a},
	{0x8afe,0x4e},
	{0x8aff,0x30},
	{0x8b00,0x2f},
	{0x8b01,0xee},
	{0x8b02,0xc2},
	{0x8b03,0x2f},
	{0x8b04,0xd2},
	{0x8b05,0x26},
	{0x8b06,0x30},
	{0x8b07,0x00},
	{0x8b08,0x05},
	{0x8b09,0x12},
	{0x8b0a,0x0b},
	{0x8b0b,0x7b},
	{0x8b0c,0x80},
	{0x8b0d,0x09},
	{0x8b0e,0x20},
	{0x8b0f,0x07},
	{0x8b10,0x06},
	{0x8b11,0x30},
	{0x8b12,0x06},
	{0x8b13,0x03},
	{0x8b14,0x12},
	{0x8b15,0x04},
	{0x8b16,0xf5},
	{0x8b17,0xc2},
	{0x8b18,0x26},
	{0x8b19,0x80},
	{0x8b1a,0xd5},
	{0x8b1b,0xe5},
	{0x8b1c,0x44},
	{0x8b1d,0x70},
	{0x8b1e,0x19},
	{0x8b1f,0x12},
	{0x8b20,0x0d},
	{0x8b21,0x4b},
	{0x8b22,0xc2},
	{0x8b23,0x30},
	{0x8b24,0x12},
	{0x8b25,0x0b},
	{0x8b26,0xd2},
	{0x8b27,0xc2},
	{0x8b28,0x30},
	{0x8b29,0x12},
	{0x8b2a,0x0c},
	{0x8b2b,0x89},
	{0x8b2c,0xc2},
	{0x8b2d,0x03},
	{0x8b2e,0x12},
	{0x8b2f,0x0c},
	{0x8b30,0xfe},
	{0x8b31,0xd2},
	{0x8b32,0x02},
	{0x8b33,0xd2},
	{0x8b34,0x01},
	{0x8b35,0xd2},
	{0x8b36,0x00},
	{0x8b37,0x22},
	{0x8b38,0x30},
	{0x8b39,0x03},
	{0x8b3a,0x08},
	{0x8b3b,0xc2},
	{0x8b3c,0x03},
	{0x8b3d,0xc2},
	{0x8b3e,0x04},
	{0x8b3f,0x12},
	{0x8b40,0x04},
	{0x8b41,0xe4},
	{0x8b42,0x22},
	{0x8b43,0xe4},
	{0x8b44,0xf5},
	{0x8b45,0x09},
	{0x8b46,0x12},
	{0x8b47,0x09},
	{0x8b48,0xee},
	{0x8b49,0xd2},
	{0x8b4a,0x03},
	{0x8b4b,0x22},
	{0x8b4c,0x36},
	{0x8b4d,0x0c},
	{0x8b4e,0x04},
	{0x8b4f,0x00},
	{0x8b50,0x00},
	{0x8b51,0x00},
	{0x8b52,0xc8},
	{0x8b53,0x01},
	{0x8b54,0x2c},
	{0x8b55,0x01},
	{0x8b56,0x5e},
	{0x8b57,0x01},
	{0x8b58,0x8b},
	{0x8b59,0x01},
	{0x8b5a,0xb8},
	{0x8b5b,0x01},
	{0x8b5c,0xe5},
	{0x8b5d,0x02},
	{0x8b5e,0x12},
	{0x8b5f,0x02},
	{0x8b60,0x3f},
	{0x8b61,0x02},
	{0x8b62,0x6c},
	{0x8b63,0x02},
	{0x8b64,0x99},
	{0x8b65,0x02},
	{0x8b66,0xc6},
	{0x8b67,0x02},
	{0x8b68,0xf3},
	{0x8b69,0x07},
	{0x8b6a,0x00},
	{0x8b6b,0x02},
	{0x8b6c,0x4e},
	{0x8b6d,0x02},
	{0x8b6e,0x6c},
	{0x8b6f,0x02},
	{0x8b70,0x8a},
	{0x8b71,0x02},
	{0x8b72,0xa8},
	{0x8b73,0x02},
	{0x8b74,0xc6},
	{0x8b75,0x02},
	{0x8b76,0xe4},
	{0x8b77,0x03},
	{0x8b78,0x02},
	{0x8b79,0x03},
	{0x8b7a,0x20},
	{0x8b7b,0xe5},
	{0x8b7c,0x20},
	{0x8b7d,0x54},
	{0x8b7e,0x07},
	{0x8b7f,0xff},
	{0x8b80,0xbf},
	{0x8b81,0x01},
	{0x8b82,0x03},
	{0x8b83,0x02},
	{0x8b84,0x0b},
	{0x8b85,0x1b},
	{0x8b86,0xe5},
	{0x8b87,0x20},
	{0x8b88,0x54},
	{0x8b89,0x07},
	{0x8b8a,0xff},
	{0x8b8b,0xbf},
	{0x8b8c,0x07},
	{0x8b8d,0x03},
	{0x8b8e,0x02},
	{0x8b8f,0x0c},
	{0x8b90,0x44},
	{0x8b91,0xe5},
	{0x8b92,0x20},
	{0x8b93,0x54},
	{0x8b94,0x07},
	{0x8b95,0xff},
	{0x8b96,0xbf},
	{0x8b97,0x03},
	{0x8b98,0x03},
	{0x8b99,0x02},
	{0x8b9a,0x0b},
	{0x8b9b,0xa8},
	{0x8b9c,0xe5},
	{0x8b9d,0x20},
	{0x8b9e,0x54},
	{0x8b9f,0x07},
	{0x8ba0,0xff},
	{0x8ba1,0xbf},
	{0x8ba2,0x05},
	{0x8ba3,0x03},
	{0x8ba4,0x12},
	{0x8ba5,0x0d},
	{0x8ba6,0x59},
	{0x8ba7,0x22},
	{0x8ba8,0x12},
	{0x8ba9,0x0c},
	{0x8baa,0x21},
	{0x8bab,0xd2},
	{0x8bac,0x30},
	{0x8bad,0x12},
	{0x8bae,0x0b},
	{0x8baf,0xd2},
	{0x8bb0,0xd2},
	{0x8bb1,0x30},
	{0x8bb2,0x12},
	{0x8bb3,0x0c},
	{0x8bb4,0x89},
	{0x8bb5,0xe5},
	{0x8bb6,0x43},
	{0x8bb7,0xd3},
	{0x8bb8,0x95},
	{0x8bb9,0x44},
	{0x8bba,0x40},
	{0x8bbb,0x03},
	{0x8bbc,0xd3},
	{0x8bbd,0x80},
	{0x8bbe,0x01},
	{0x8bbf,0xc3},
	{0x8bc0,0x50},
	{0x8bc1,0x0c},
	{0x8bc2,0x20},
	{0x8bc3,0x28},
	{0x8bc4,0x06},
	{0x8bc5,0x30},
	{0x8bc6,0x2d},
	{0x8bc7,0x03},
	{0x8bc8,0x20},
	{0x8bc9,0x2e},
	{0x8bca,0x03},
	{0x8bcb,0x02},
	{0x8bcc,0x0c},
	{0x8bcd,0xfe},
	{0x8bce,0x12},
	{0x8bcf,0x0c},
	{0x8bd0,0xbf},
	{0x8bd1,0x22},
	{0x8bd2,0x30},
	{0x8bd3,0x30},
	{0x8bd4,0x09},
	{0x8bd5,0x30},
	{0x8bd6,0x2d},
	{0x8bd7,0x06},
	{0x8bd8,0xae},
	{0x8bd9,0x33},
	{0x8bda,0xaf},
	{0x8bdb,0x34},
	{0x8bdc,0x80},
	{0x8bdd,0x04},
	{0x8bde,0xae},
	{0x8bdf,0x3d},
	{0x8be0,0xaf},
	{0x8be1,0x3e},
	{0x8be2,0x8e},
	{0x8be3,0x33},
	{0x8be4,0x8f},
	{0x8be5,0x34},
	{0x8be6,0x30},
	{0x8be7,0x30},
	{0x8be8,0x09},
	{0x8be9,0x30},
	{0x8bea,0x2e},
	{0x8beb,0x06},
	{0x8bec,0xae},
	{0x8bed,0x35},
	{0x8bee,0xaf},
	{0x8bef,0x36},
	{0x8bf0,0x80},
	{0x8bf1,0x04},
	{0x8bf2,0xae},
	{0x8bf3,0x3f},
	{0x8bf4,0xaf},
	{0x8bf5,0x40},
	{0x8bf6,0x8e},
	{0x8bf7,0x35},
	{0x8bf8,0x8f},
	{0x8bf9,0x36},
	{0x8bfa,0x22},
	{0x8bfb,0x12},
	{0x8bfc,0x0c},
	{0x8bfd,0xec},
	{0x8bfe,0x12},
	{0x8bff,0x0d},
	{0x8c00,0x67},
	{0x8c01,0x50},
	{0x8c02,0x04},
	{0x8c03,0xd2},
	{0x8c04,0x05},
	{0x8c05,0x80},
	{0x8c06,0x02},
	{0x8c07,0xc2},
	{0x8c08,0x05},
	{0x8c09,0x12},
	{0x8c0a,0x04},
	{0x8c0b,0x7c},
	{0x8c0c,0xc2},
	{0x8c0d,0x28},
	{0x8c0e,0xc2},
	{0x8c0f,0x21},
	{0x8c10,0xd2},
	{0x8c11,0x25},
	{0x8c12,0x12},
	{0x8c13,0x04},
	{0x8c14,0xbe},
	{0x8c15,0xb5},
	{0x8c16,0x07},
	{0x8c17,0x03},
	{0x8c18,0xd3},
	{0x8c19,0x80},
	{0x8c1a,0x01},
	{0x8c1b,0xc3},
	{0x8c1c,0x40},
	{0x8c1d,0x02},
	{0x8c1e,0xc2},
	{0x8c1f,0x05},
	{0x8c20,0x22},
	{0x8c21,0xd3},
	{0x8c22,0xe5},
	{0x8c23,0x34},
	{0x8c24,0x95},
	{0x8c25,0x3e},
	{0x8c26,0xe5},
	{0x8c27,0x33},
	{0x8c28,0x95},
	{0x8c29,0x3d},
	{0x8c2a,0x40},
	{0x8c2b,0x03},
	{0x8c2c,0xd3},
	{0x8c2d,0x80},
	{0x8c2e,0x01},
	{0x8c2f,0xc3},
	{0x8c30,0x92},
	{0x8c31,0x2d},
	{0x8c32,0xd3},
	{0x8c33,0xe5},
	{0x8c34,0x36},
	{0x8c35,0x95},
	{0x8c36,0x40},
	{0x8c37,0xe5},
	{0x8c38,0x35},
	{0x8c39,0x95},
	{0x8c3a,0x3f},
	{0x8c3b,0x40},
	{0x8c3c,0x03},
	{0x8c3d,0xd3},
	{0x8c3e,0x80},
	{0x8c3f,0x01},
	{0x8c40,0xc3},
	{0x8c41,0x92},
	{0x8c42,0x2e},
	{0x8c43,0x22},
	{0x8c44,0x12},
	{0x8c45,0x0c},
	{0x8c46,0x21},
	{0x8c47,0xd2},
	{0x8c48,0x30},
	{0x8c49,0x12},
	{0x8c4a,0x0b},
	{0x8c4b,0xd2},
	{0x8c4c,0xd2},
	{0x8c4d,0x30},
	{0x8c4e,0x12},
	{0x8c4f,0x0c},
	{0x8c50,0x89},
	{0x8c51,0x12},
	{0x8c52,0x0c},
	{0x8c53,0xfe},
	{0x8c54,0xe5},
	{0x8c55,0x28},
	{0x8c56,0xd3},
	{0x8c57,0x95},
	{0x8c58,0x44},
	{0x8c59,0x40},
	{0x8c5a,0x05},
	{0x8c5b,0xe4},
	{0x8c5c,0x95},
	{0x8c5d,0x44},
	{0x8c5e,0x40},
	{0x8c5f,0x06},
	{0x8c60,0xc2},
	{0x8c61,0x02},
	{0x8c62,0xd2},
	{0x8c63,0x01},
	{0x8c64,0xd2},
	{0x8c65,0x00},
	{0x8c66,0x22},
	{0x8c67,0xe4},
	{0x8c68,0xff},
	{0x8c69,0xfe},
	{0x8c6a,0xc3},
	{0x8c6b,0xef},
	{0x8c6c,0x95},
	{0x8c6d,0x0b},
	{0x8c6e,0xee},
	{0x8c6f,0x95},
	{0x8c70,0x0a},
	{0x8c71,0x50},
	{0x8c72,0x15},
	{0x8c73,0x7d},
	{0x8c74,0x8a},
	{0x8c75,0x7c},
	{0x8c76,0x02},
	{0x8c77,0xed},
	{0x8c78,0x1d},
	{0x8c79,0xaa},
	{0x8c7a,0x04},
	{0x8c7b,0x70},
	{0x8c7c,0x01},
	{0x8c7d,0x1c},
	{0x8c7e,0x4a},
	{0x8c7f,0x70},
	{0x8c80,0xf6},
	{0x8c81,0x0f},
	{0x8c82,0xbf},
	{0x8c83,0x00},
	{0x8c84,0x01},
	{0x8c85,0x0e},
	{0x8c86,0x80},
	{0x8c87,0xe2},
	{0x8c88,0x22},
	{0x8c89,0x30},
	{0x8c8a,0x30},
	{0x8c8b,0x07},
	{0x8c8c,0x30},
	{0x8c8d,0x2d},
	{0x8c8e,0x04},
	{0x8c8f,0xaf},
	{0x8c90,0x30},
	{0x8c91,0x80},
	{0x8c92,0x02},
	{0x8c93,0xaf},
	{0x8c94,0x44},
	{0x8c95,0x8f},
	{0x8c96,0x30},
	{0x8c97,0x30},
	{0x8c98,0x30},
	{0x8c99,0x07},
	{0x8c9a,0x30},
	{0x8c9b,0x2e},
	{0x8c9c,0x04},
	{0x8c9d,0xaf},
	{0x8c9e,0x31},
	{0x8c9f,0x80},
	{0x8ca0,0x02},
	{0x8ca1,0xaf},
	{0x8ca2,0x44},
	{0x8ca3,0x8f},
	{0x8ca4,0x31},
	{0x8ca5,0x22},
	{0x8ca6,0xe5},
	{0x8ca7,0x45},
	{0x8ca8,0xb4},
	{0x8ca9,0x01},
	{0x8caa,0x05},
	{0x8cab,0x12},
	{0x8cac,0x0d},
	{0x8cad,0x1e},
	{0x8cae,0x80},
	{0x8caf,0x08},
	{0x8cb0,0xe5},
	{0x8cb1,0x45},
	{0x8cb2,0xb4},
	{0x8cb3,0x02},
	{0x8cb4,0x09},
	{0x8cb5,0x12},
	{0x8cb6,0x0d},
	{0x8cb7,0x2d},
	{0x8cb8,0xe4},
	{0x8cb9,0xf5},
	{0x8cba,0x09},
	{0x8cbb,0x12},
	{0x8cbc,0x09},
	{0x8cbd,0xee},
	{0x8cbe,0x22},
	{0x8cbf,0xaf},
	{0x8cc0,0x31},
	{0x8cc1,0xe5},
	{0x8cc2,0x44},
	{0x8cc3,0xb5},
	{0x8cc4,0x07},
	{0x8cc5,0x03},
	{0x8cc6,0x02},
	{0x8cc7,0x0c},
	{0x8cc8,0xd8},
	{0x8cc9,0x8f},
	{0x8cca,0x09},
	{0x8ccb,0x12},
	{0x8ccc,0x09},
	{0x8ccd,0xee},
	{0x8cce,0xd2},
	{0x8ccf,0x02},
	{0x8cd0,0xc2},
	{0x8cd1,0x01},
	{0x8cd2,0xd2},
	{0x8cd3,0x00},
	{0x8cd4,0x75},
	{0x8cd5,0x27},
	{0x8cd6,0x03},
	{0x8cd7,0x22},
	{0x8cd8,0xc2},
	{0x8cd9,0x03},
	{0x8cda,0xd2},
	{0x8cdb,0x04},
	{0x8cdc,0x12},
	{0x8cdd,0x04},
	{0x8cde,0xe4},
	{0x8cdf,0xc2},
	{0x8ce0,0x30},
	{0x8ce1,0x12},
	{0x8ce2,0x0b},
	{0x8ce3,0xd2},
	{0x8ce4,0xc2},
	{0x8ce5,0x30},
	{0x8ce6,0x12},
	{0x8ce7,0x0c},
	{0x8ce8,0x89},
	{0x8ce9,0xd2},
	{0x8cea,0x25},
	{0x8ceb,0x22},
	{0x8cec,0x12},
	{0x8ced,0x04},
	{0x8cee,0x8b},
	{0x8cef,0xf5},
	{0x8cf0,0x09},
	{0x8cf1,0x75},
	{0x8cf2,0x0a},
	{0x8cf3,0x01},
	{0x8cf4,0x12},
	{0x8cf5,0x08},
	{0x8cf6,0xfa},
	{0x8cf7,0xd2},
	{0x8cf8,0x20},
	{0x8cf9,0xc2},
	{0x8cfa,0x26},
	{0x8cfb,0xc2},
	{0x8cfc,0x2f},
	{0x8cfd,0x22},
	{0x8cfe,0xe5},
	{0x8cff,0x44},
	{0x8d00,0xc3},
	{0x8d01,0x95},
	{0x8d02,0x43},
	{0x8d03,0x40},
	{0x8d04,0x01},
	{0x8d05,0x22},
	{0x8d06,0xe5},
	{0x8d07,0x44},
	{0x8d08,0x04},
	{0x8d09,0xf5},
	{0x8d0a,0x09},
	{0x8d0b,0x12},
	{0x8d0c,0x09},
	{0x8d0d,0xee},
	{0x8d0e,0x22},
	{0x8d0f,0xe5},
	{0x8d10,0x44},
	{0x8d11,0x70},
	{0x8d12,0x02},
	{0x8d13,0xc3},
	{0x8d14,0x22},
	{0x8d15,0xe5},
	{0x8d16,0x44},
	{0x8d17,0x14},
	{0x8d18,0xf5},
	{0x8d19,0x09},
	{0x8d1a,0x12},
	{0x8d1b,0x09},
	{0x8d1c,0xee},
	{0x8d1d,0x22},
	{0x8d1e,0x75},
	{0x8d1f,0x2e},
	{0x8d20,0x0b},
	{0x8d21,0x75},
	{0x8d22,0x2f},
	{0x8d23,0x4f},
	{0x8d24,0x90},
	{0x8d25,0x0b},
	{0x8d26,0x4d},
	{0x8d27,0x12},
	{0x8d28,0x04},
	{0x8d29,0xda},
	{0x8d2a,0xc2},
	{0x8d2b,0x2c},
	{0x8d2c,0x22},
	{0x8d2d,0x75},
	{0x8d2e,0x2e},
	{0x8d2f,0x0b},
	{0x8d30,0x75},
	{0x8d31,0x2f},
	{0x8d32,0x6b},
	{0x8d33,0x90},
	{0x8d34,0x0b},
	{0x8d35,0x69},
	{0x8d36,0x12},
	{0x8d37,0x04},
	{0x8d38,0xda},
	{0x8d39,0xd2},
	{0x8d3a,0x2c},
	{0x8d3b,0x22},
	{0x8d3c,0xe5},
	{0x8d3d,0x45},
	{0x8d3e,0x24},
	{0x8d3f,0xfe},
	{0x8d40,0x60},
	{0x8d41,0x06},
	{0x8d42,0x04},
	{0x8d43,0x70},
	{0x8d44,0x05},
	{0x8d45,0xd2},
	{0x8d46,0x28},
	{0x8d47,0x22},
	{0x8d48,0xc2},
	{0x8d49,0x28},
	{0x8d4a,0x22},
	{0x8d4b,0xe4},
	{0x8d4c,0xf5},
	{0x8d4d,0x33},
	{0x8d4e,0xf5},
	{0x8d4f,0x34},
	{0x8d50,0xf5},
	{0x8d51,0x35},
	{0x8d52,0xf5},
	{0x8d53,0x36},
	{0x8d54,0xc2},
	{0x8d55,0x2d},
	{0x8d56,0xc2},
	{0x8d57,0x2e},
	{0x8d58,0x22},
	{0x8d59,0xe5},
	{0x8d5a,0x27},
	{0x8d5b,0xd3},
	{0x8d5c,0x94},
	{0x8d5d,0x00},
	{0x8d5e,0x40},
	{0x8d5f,0x03},
	{0x8d60,0x15},
	{0x8d61,0x27},
	{0x8d62,0x22},
	{0x8d63,0x12},
	{0x8d64,0x0c},
	{0x8d65,0xd8},
	{0x8d66,0x22},
	{0x8d67,0x12},
	{0x8d68,0x0d},
	{0x8d69,0x1e},
	{0x8d6a,0xe4},
	{0x8d6b,0xf5},
	{0x8d6c,0x09},
	{0x8d6d,0x12},
	{0x8d6e,0x09},
	{0x8d6f,0xee},
	{0x8d70,0x22},
	{0x3F00,0x00},
	{0x3F01,0x00},
	{0x3F02,0x00},
	{0x3F03,0x00},
	{0x3F04,0x00},
	{0x3F05,0x00},
	{0x3F06,0x00},
	{0x3F07,0xFF},
	{0x3104,0x00},
	{0x0000,0x00}
};
#endif	