/*
 * Driver for OV5642 CMOS Image Sensor from OmniVision
 *
 * Copyright (C) 2008, Guennadi Liakhovetski <kernel@pengutronix.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/videodev2.h>
#include <linux/slab.h>
#include <linux/i2c.h>
#include <linux/log2.h>
#include <linux/platform_device.h>
#include <linux/delay.h>
#include <linux/circ_buf.h>
#include <linux/hardirq.h>
#include <linux/miscdevice.h>
#include <media/v4l2-common.h>
#include <media/v4l2-chip-ident.h>
#include <media/soc_camera.h>
#include <plat/rk_camera.h>
#include "mt9t111.h"

static int debug;
module_param(debug, int, S_IRUGO|S_IWUSR);

#define dprintk(level, fmt, arg...) do {			\
	if (debug >= level) 					\
	printk(KERN_WARNING fmt , ## arg); } while (0)

#define SENSOR_TR(format, ...) printk(KERN_ERR format, ## __VA_ARGS__)
#define SENSOR_DG(format, ...) dprintk(1, format, ## __VA_ARGS__)

#define _CONS(a,b) a##b
#define CONS(a,b) _CONS(a,b)

#define __STR(x) #x
#define _STR(x) __STR(x)
#define STR(x) _STR(x)

#define MIN(x,y)   ((x<y) ? x: y)
#define MAX(x,y)    ((x>y) ? x: y)

/* Sensor Driver Configuration */
#define SENSOR_NAME RK29_CAM_SENSOR_MT9T111
#define SENSOR_V4L2_IDENT V4L2_IDENT_MT9T111
#define SENSOR_ID SEQUENCE_END
#define SENSOR_ID_REG SEQUENCE_END
#define SENSOR_RESET_REG 0x001a
#define SENSOR_RESET_VAL 0x0018
#define SENSOR_RESET_REG_LEN  WORD_LEN
#define SENSOR_MIN_WIDTH    176
#define SENSOR_MIN_HEIGHT   144
#define SENSOR_MAX_WIDTH    2048
#define SENSOR_MAX_HEIGHT   1536
#define SENSOR_INIT_WIDTH	640			/* Sensor pixel size for sensor_init_data array */
#define SENSOR_INIT_HEIGHT  480
#define SENSOR_INIT_WINSEQADR sensor_vga
#define SENSOR_INIT_PIXFMT V4L2_MBUS_FMT_UYVY8_2X8

#define CONFIG_SENSOR_WhiteBalance	1
#define CONFIG_SENSOR_Brightness	0
#define CONFIG_SENSOR_Contrast      0
#define CONFIG_SENSOR_Saturation    0
#define CONFIG_SENSOR_Effect        1
#define CONFIG_SENSOR_Scene         1
#define CONFIG_SENSOR_DigitalZoom   0
#define CONFIG_SENSOR_Exposure      1
#define CONFIG_SENSOR_Flash         1
#define CONFIG_SENSOR_Mirror        0
#define CONFIG_SENSOR_Flip          1
#define CONFIG_SENSOR_Focus         1

/*Sensor write registers at a time*/
#define CONFIG_SENSOR_WRITE_REGS  1


#define CONFIG_SENSOR_I2C_SPEED     350000       /* Hz */
/* Sensor write register continues by preempt_disable/preempt_enable for current process not be scheduled */
#define CONFIG_SENSOR_I2C_NOSCHED   0
#define CONFIG_SENSOR_I2C_RDWRCHK   0


#define SENSOR_BUS_PARAM                     (V4L2_MBUS_MASTER |\
																 V4L2_MBUS_PCLK_SAMPLE_RISING|V4L2_MBUS_HSYNC_ACTIVE_HIGH| V4L2_MBUS_VSYNC_ACTIVE_HIGH|\
																 V4L2_MBUS_DATA_ACTIVE_HIGH | SOCAM_DATAWIDTH_8  |SOCAM_MCLK_24MHZ)

#define COLOR_TEMPERATURE_CLOUDY_DN    6500
#define COLOR_TEMPERATURE_CLOUDY_UP    8000
#define COLOR_TEMPERATURE_CLEARDAY_DN  5000
#define COLOR_TEMPERATURE_CLEARDAY_UP    6500
#define COLOR_TEMPERATURE_OFFICE_DN     3500
#define COLOR_TEMPERATURE_OFFICE_UP     5000
#define COLOR_TEMPERATURE_HOME_DN       2500
#define COLOR_TEMPERATURE_HOME_UP       3500

#define SENSOR_NAME_STRING(a) STR(CONS(SENSOR_NAME, a))
#define SENSOR_NAME_VARFUN(a) CONS(SENSOR_NAME, a)

#define SENSOR_AF_IS_ERR    (0x00<<0)
#define SENSOR_AF_IS_OK		(0x01<<0)
#define SENSOR_INIT_IS_ERR   (0x00<<28)
#define SENSOR_INIT_IS_OK    (0x01<<28)

#if CONFIG_SENSOR_Focus
#define SENSOR_AF_MODE_INFINITY    0
#define SENSOR_AF_MODE_MACRO       1
#define SENSOR_AF_MODE_FIXED       2
#define SENSOR_AF_MODE_AUTO        3
#define SENSOR_AF_MODE_CONTINUOUS  4
#define SENSOR_AF_MODE_CLOSE       5
#endif

//flash off in fixed time to prevent from too hot , zyc
struct  flash_timer{
    struct soc_camera_device *icd;
	struct hrtimer timer;
};
static enum hrtimer_restart flash_off_func(struct hrtimer *timer);

static struct  flash_timer flash_off_timer;
//for user defined if user want to customize the series , zyc
#ifdef CONFIG_MT9T111_USER_DEFINED_SERIES
#include "mt9t111_user_series.c"
#else

/* init 640X480 VGA */
static struct reginfo sensor_init_data[] =
{
//[Step2-PLL_Timing]
//for 24MHz input, VCO=MAX PCLK=76.8MHz
#if 0
{ 0x001A, 0x0019, WORD_LEN, 0 }, 	// RESET_AND_MISC_CONTROL
{ 0x001A, 0x0018, WORD_LEN, 0 }, 	// RESET_AND_MISC_CONTROL
{ 0x0014, 0x2425, WORD_LEN, 0 }, 	// PLL_CONTROL
{ 0x0014, 0x2425, WORD_LEN, 0 }, 	// PLL_CONTROL
{ 0x0014, 0x2145, WORD_LEN, 0 }, 	// PLL_CONTROL
{ 0x0010, 0x0110, WORD_LEN, 0 }, 	// PLL_DIVIDERS
{ 0x0012, 0x0070, WORD_LEN, 0 }, 	// PLL_P_DIVIDERS
{ 0x002A, 0x77CC, WORD_LEN, 0 }, 	// PLL_P4_P5_P6_DIVIDERS
{ 0x001A, 0x0218, WORD_LEN, 0 }, 	// RESET_AND_MISC_CONTROL
{ 0x0014, 0x2545, WORD_LEN, 0 }, 	// PLL_CONTROL
{ 0x0014, 0x2547, WORD_LEN, 0 }, 	// PLL_CONTROL
{ 0x0014, 0x2447, WORD_LEN, 0 }, 	// PLL_CONTROL
{ 0x0014, 0x2047, WORD_LEN, 0 }, 	// PLL_CONTROL 
	
{ SEQUENCE_WAIT_MS,10, WORD_LEN, 0},

{ 0x0014, 0x2046, WORD_LEN, 0 }, 	// PLL_CONTROL
{ 0x0022, 0x01E0, WORD_LEN, 0 }, 	// VDD_DIS_COUNTER
{ 0x001E, 0x0777, WORD_LEN, 0 }, 	// PAD_SLEW_PAD_CONFIG
{ 0x0016, 0x0400, WORD_LEN, 0 }, 	// CLOCKS_CONTROL
{ 0x3B84, 0x0127, WORD_LEN, 0 }, 	// I2C_MASTER_FREQUENCY_DIVIDER
{ 0x001E, 0x0777, WORD_LEN, 0 }, 	// PAD_SLEW_PAD_CONFIG
{ 0x0018, 0x402D, WORD_LEN, 0 }, 	// STANDBY_CONTROL_AND_STATUS
{ 0x0018, 0x402C, WORD_LEN, 0 }, 	// STANDBY_CONTROL_AND_STATUS
	
{ SEQUENCE_WAIT_MS,50, WORD_LEN, 0},

{ 0x098E, 0x6800, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0280, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x6802, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x01E0, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xE88E, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0000, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x68A0, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x082D, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4802, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0000, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4804, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0000, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4806, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x060D, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4808, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x080D, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x480A, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0111, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x480C, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x046C, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x480F, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x00CC, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4811, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0381, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4813, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x024F, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x481D, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x03EA, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x481F, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x05D0, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4825, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x07AC, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x482B, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0408, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x482D, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0308, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x6C00, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0800, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x6C02, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0600, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xEC8E, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0000, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x6CA0, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x082D, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x484A, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0004, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x484C, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0004, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x484E, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x060B, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4850, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x080B, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4852, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0111, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4854, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0024, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4857, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x008C, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4859, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x01F1, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x485B, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x00FF, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4865, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0857, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4867, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0378, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x486D, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0ACE, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4873, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0808, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4875, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0608, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC8A5, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x001E, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC8A6, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0021, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC8A7, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0024, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC8A8, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0027, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC844, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0096, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC92F, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0000, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC845, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x007D, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC92D, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0000, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC88C, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x006B, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC930, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0000, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC88D, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0059, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC92E, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0000, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xA002, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0010, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xA009, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0002, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xA00A, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0003, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xA00C, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x000A, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4846, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0014, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x68AA, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x02EE, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x6815, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0007, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x6817, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0008, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x682D, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0007, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x488E, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0014, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x6CAA, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x01A2, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x8400, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0006, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x8400, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0005, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x3C20, 0x0000, WORD_LEN, 0 }, 	// TX_SS_CONTROL

//[LensShading	TL84]
{ 0x364A, 0x00F0, WORD_LEN, 0 },	// P_R_P0Q0
{ 0x364C, 0x1B2D, WORD_LEN, 0 },	// P_R_P0Q1
{ 0x364E, 0x6491, WORD_LEN, 0 },	// P_R_P0Q2
{ 0x3650, 0x2210, WORD_LEN, 0 },	// P_R_P0Q3
{ 0x3652, 0xCD30, WORD_LEN, 0 },	// P_R_P0Q4
{ 0x368A, 0x368B, WORD_LEN, 0 },	// P_R_P1Q0
{ 0x368C, 0x3A6E, WORD_LEN, 0 },	// P_R_P1Q1
{ 0x368E, 0x0B8F, WORD_LEN, 0 },	// P_R_P1Q2
{ 0x3690, 0x974F, WORD_LEN, 0 },	// P_R_P1Q3
{ 0x3692, 0xD5B0, WORD_LEN, 0 },	// P_R_P1Q4
{ 0x36CA, 0x0C32, WORD_LEN, 0 },	// P_R_P2Q0
{ 0x36CC, 0x33B0, WORD_LEN, 0 },	// P_R_P2Q1
{ 0x36CE, 0x6413, WORD_LEN, 0 },	// P_R_P2Q2
{ 0x36D0, 0xF130, WORD_LEN, 0 },	// P_R_P2Q3
{ 0x36D2, 0x8EF6, WORD_LEN, 0 },	// P_R_P2Q4
{ 0x370A, 0x50CA, WORD_LEN, 0 },	// P_R_P3Q0
{ 0x370C, 0x2570, WORD_LEN, 0 },	// P_R_P3Q1
{ 0x370E, 0xFDEE, WORD_LEN, 0 },	// P_R_P3Q2
{ 0x3710, 0xEDB1, WORD_LEN, 0 },	// P_R_P3Q3
{ 0x3712, 0x68EF, WORD_LEN, 0 },	// P_R_P3Q4
{ 0x374A, 0x1E50, WORD_LEN, 0 },	// P_R_P4Q0
{ 0x374C, 0xB9D0, WORD_LEN, 0 },	// P_R_P4Q1
{ 0x374E, 0x82B7, WORD_LEN, 0 },	// P_R_P4Q2
{ 0x3750, 0x550E, WORD_LEN, 0 },	// P_R_P4Q3
{ 0x3752, 0x1FF9, WORD_LEN, 0 },	// P_R_P4Q4
{ 0x3640, 0x0750, WORD_LEN, 0 },	// P_G1_P0Q0
{ 0x3642, 0x36CD, WORD_LEN, 0 },	// P_G1_P0Q1
{ 0x3644, 0x5DB1, WORD_LEN, 0 },	// P_G1_P0Q2
{ 0x3646, 0x23F0, WORD_LEN, 0 },	// P_G1_P0Q3
{ 0x3648, 0xB9F1, WORD_LEN, 0 },	// P_G1_P0Q4
{ 0x3680, 0x5C8B, WORD_LEN, 0 },	// P_G1_P1Q0
{ 0x3682, 0x8F6F, WORD_LEN, 0 },	// P_G1_P1Q1
{ 0x3684, 0x53AA, WORD_LEN, 0 },	// P_G1_P1Q2
{ 0x3686, 0x2B6C, WORD_LEN, 0 },	// P_G1_P1Q3
{ 0x3688, 0x9D70, WORD_LEN, 0 },	// P_G1_P1Q4
{ 0x36C0, 0x2D12, WORD_LEN, 0 },	// P_G1_P2Q0
{ 0x36C2, 0x0D11, WORD_LEN, 0 },	// P_G1_P2Q1
{ 0x36C4, 0xAD4D, WORD_LEN, 0 },	// P_G1_P2Q2
{ 0x36C6, 0x9872, WORD_LEN, 0 },	// P_G1_P2Q3
{ 0x36C8, 0xC9B4, WORD_LEN, 0 },	// P_G1_P2Q4
{ 0x3700, 0x920F, WORD_LEN, 0 },	// P_G1_P3Q0
{ 0x3702, 0x8A4E, WORD_LEN, 0 },	// P_G1_P3Q1
{ 0x3704, 0x502F, WORD_LEN, 0 },	// P_G1_P3Q2
{ 0x3706, 0x7951, WORD_LEN, 0 },	// P_G1_P3Q3
{ 0x3708, 0x0013, WORD_LEN, 0 },	// P_G1_P3Q4
{ 0x3740, 0xDC12, WORD_LEN, 0 },	// P_G1_P4Q0
{ 0x3742, 0xEA52, WORD_LEN, 0 },	// P_G1_P4Q1
{ 0x3744, 0xC735, WORD_LEN, 0 },	// P_G1_P4Q2
{ 0x3746, 0x2F94, WORD_LEN, 0 },	// P_G1_P4Q3
{ 0x3748, 0x6C18, WORD_LEN, 0 },	// P_G1_P4Q4
{ 0x3654, 0x0210, WORD_LEN, 0 },	// P_B_P0Q0
{ 0x3656, 0x384D, WORD_LEN, 0 },	// P_B_P0Q1
{ 0x3658, 0x27D1, WORD_LEN, 0 },	// P_B_P0Q2
{ 0x365A, 0x02F0, WORD_LEN, 0 },	// P_B_P0Q3
{ 0x365C, 0xC530, WORD_LEN, 0 },	// P_B_P0Q4
{ 0x3694, 0x70AA, WORD_LEN, 0 },	// P_B_P1Q0
{ 0x3696, 0x964D, WORD_LEN, 0 },	// P_B_P1Q1
{ 0x3698, 0xA58B, WORD_LEN, 0 },	// P_B_P1Q2
{ 0x369A, 0xA88F, WORD_LEN, 0 },	// P_B_P1Q3
{ 0x369C, 0xA90F, WORD_LEN, 0 },	// P_B_P1Q4
{ 0x36D4, 0x07D2, WORD_LEN, 0 },	// P_B_P2Q0
{ 0x36D6, 0x10F0, WORD_LEN, 0 },	// P_B_P2Q1
{ 0x36D8, 0xDDA7, WORD_LEN, 0 },	// P_B_P2Q2
{ 0x36DA, 0xE9B1, WORD_LEN, 0 },	// P_B_P2Q3
{ 0x36DC, 0x9AF4, WORD_LEN, 0 },	// P_B_P2Q4
{ 0x3714, 0x02EE, WORD_LEN, 0 },	// P_B_P3Q0
{ 0x3716, 0xB250, WORD_LEN, 0 },	// P_B_P3Q1
{ 0x3718, 0x770B, WORD_LEN, 0 },	// P_B_P3Q2
{ 0x371A, 0x6BB2, WORD_LEN, 0 },	// P_B_P3Q3
{ 0x371C, 0x57F0, WORD_LEN, 0 },	// P_B_P3Q4
{ 0x3754, 0xCEB2, WORD_LEN, 0 },	// P_B_P4Q0
{ 0x3756, 0xC730, WORD_LEN, 0 },	// P_B_P4Q1
{ 0x3758, 0xBC34, WORD_LEN, 0 },	// P_B_P4Q2
{ 0x375A, 0x0C14, WORD_LEN, 0 },	// P_B_P4Q3
{ 0x375C, 0x2F18, WORD_LEN, 0 },	// P_B_P4Q4
{ 0x365E, 0x0130, WORD_LEN, 0 },	// P_G2_P0Q0
{ 0x3660, 0x1C2D, WORD_LEN, 0 },	// P_G2_P0Q1
{ 0x3662, 0x5031, WORD_LEN, 0 },	// P_G2_P0Q2
{ 0x3664, 0x1670, WORD_LEN, 0 },	// P_G2_P0Q3
{ 0x3666, 0x9B71, WORD_LEN, 0 },	// P_G2_P0Q4
{ 0x369E, 0x5BAB, WORD_LEN, 0 },	// P_G2_P1Q0
{ 0x36A0, 0x054F, WORD_LEN, 0 },	// P_G2_P1Q1
{ 0x36A2, 0x2589, WORD_LEN, 0 },	// P_G2_P1Q2
{ 0x36A4, 0xF54F, WORD_LEN, 0 },	// P_G2_P1Q3
{ 0x36A6, 0xCFAE, WORD_LEN, 0 },	// P_G2_P1Q4
{ 0x36DE, 0x2A92, WORD_LEN, 0 },	// P_G2_P2Q0
{ 0x36E0, 0x0311, WORD_LEN, 0 },	// P_G2_P2Q1
{ 0x36E2, 0x832F, WORD_LEN, 0 },	// P_G2_P2Q2
{ 0x36E4, 0xA232, WORD_LEN, 0 },	// P_G2_P2Q3
{ 0x36E6, 0xCB34, WORD_LEN, 0 },	// P_G2_P2Q4
{ 0x371E, 0xFA6E, WORD_LEN, 0 },	// P_G2_P3Q0
{ 0x3720, 0x712F, WORD_LEN, 0 },	// P_G2_P3Q1
{ 0x3722, 0x5A31, WORD_LEN, 0 },	// P_G2_P3Q2
{ 0x3724, 0xAC52, WORD_LEN, 0 },	// P_G2_P3Q3
{ 0x3726, 0xB751, WORD_LEN, 0 },	// P_G2_P3Q4
{ 0x375E, 0xDFF2, WORD_LEN, 0 },	// P_G2_P4Q0
{ 0x3760, 0xEE32, WORD_LEN, 0 },	// P_G2_P4Q1
{ 0x3762, 0x9FF5, WORD_LEN, 0 },	// P_G2_P4Q2
{ 0x3764, 0x7154, WORD_LEN, 0 },	// P_G2_P4Q3
{ 0x3766, 0x50D8, WORD_LEN, 0 },	// P_G2_P4Q4
{ 0x3784, 0x0400, WORD_LEN, 0 },	// CENTER_COLUMN
{ 0x3782, 0x0300, WORD_LEN, 0 },	// CENTER_ROW
{ 0x3210, 0x01B8, WORD_LEN, 0 },	// COLOR_PIPELINE_CONTROL
{ 0x098E, 0xC913, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_STAT_BRIGHTNESS_METRIC_PREDIVIDER]
{ 0x0990, 0x000A, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x686B, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_A_CONFIG_LL_START_BRIGHTNESS]
{ 0x0990, 0x05DC, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x686D, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_A_CONFIG_LL_STOP_BRIGHTNESS]
{ 0x0990, 0x0BB8, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x6C6B, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_B_CONFIG_LL_START_BRIGHTNESS]
{ 0x0990, 0x05DC, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x6C6D, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_B_CONFIG_LL_STOP_BRIGHTNESS]
{ 0x0990, 0x0BB8, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x3439, WORD_LEN, 0 }, 	// MCU_ADDRESS [AS_ASSTART_BRIGHTNESS]
{ 0x0990, 0x05DC, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x343B, WORD_LEN, 0 }, 	// MCU_ADDRESS [AS_ASSTOP_BRIGHTNESS]
{ 0x0990, 0x0BB8, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4926, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_START_GAMMA_BM]
{ 0x0990, 0x0001, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4928, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_MID_GAMMA_BM]
{ 0x0990, 0x0002, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x492A, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_STOP_GAMMA_BM]
{ 0x0990, 0x0656, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4D26, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM2_LL_START_GAMMA_BM]
{ 0x0990, 0x0001, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4D28, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM2_LL_MID_GAMMA_BM]
{ 0x0990, 0x0002, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4D2A, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM2_LL_STOP_GAMMA_BM]
{ 0x0990, 0x0656, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x33F4, 0x040B, WORD_LEN, 0 }, 	// KERNEL_CONFIG
{ 0x098E, 0xC916, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_LL_START_0]
{ 0x0990, 0x0014, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC919, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_LL_STOP_0]
{ 0x0990, 0x0028, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC917, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_LL_START_1]
{ 0x0990, 0x0004, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC918, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_LL_START_2]
{ 0x0990, 0x0000, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC91A, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_LL_STOP_1]
{ 0x0990, 0x0001, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC91B, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_LL_STOP_2]
{ 0x0990, 0x0009, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x326C, 0x0C00, WORD_LEN, 0 }, 	// APERTURE_PARAMETERS_2D
{ 0x098E, 0x494B, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_EXT_START_GAIN_METRIC]
{ 0x0990, 0x0042, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x494D, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_EXT_STOP_GAIN_METRIC]
{ 0x0990, 0x012C, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC91E, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_NR_START_0]
{ 0x0990, 0x0012, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC91F, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_NR_START_1]
{ 0x0990, 0x000A, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC920, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_NR_START_2]
{ 0x0990, 0x0012, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC921, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_NR_START_3]
{ 0x0990, 0x000A, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC922, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_NR_STOP_0]
{ 0x0990, 0x0026, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC923, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_NR_STOP_1]
{ 0x0990, 0x001E, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC924, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_NR_STOP_2]
{ 0x0990, 0x0026, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC925, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_NR_STOP_3]
{ 0x0990, 0x0026, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC02, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_MODE]
{ 0x0990, 0x0003, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC05, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_CLUSTER_DC_TH]
{ 0x0990, 0x000E, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x316C, 0x350F, WORD_LEN, 0 }, 	// DAC_TXLO
{ 0x098E, 0xC950, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_START_1]
{ 0x0990, 0x0064, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC94F, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_START_0]
{ 0x0990, 0x0038, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC952, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_START_3]
{ 0x0990, 0x0064, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC951, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_START_2]
{ 0x0990, 0x0051, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC954, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_START_5]
{ 0x0990, 0x0010, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC953, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_START_4]
{ 0x0990, 0x0020, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC956, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_START_7]
{ 0x0990, 0x0010, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC955, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_START_6]
{ 0x0990, 0x0020, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC958, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_STOP_1]
{ 0x0990, 0x0020, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC957, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_STOP_0]
{ 0x0990, 0x0014, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC95A, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_STOP_3]
{ 0x0990, 0x001D, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC959, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_STOP_2]
{ 0x0990, 0x0020, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC95C, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_STOP_5]
{ 0x0990, 0x000C, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC95B, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_STOP_4]
{ 0x0990, 0x0008, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC95E, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_STOP_7]
{ 0x0990, 0x000C, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC95D, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_STOP_6]
{ 0x0990, 0x0008, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC95F, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_EXT_GRB_WINDOW_PERCENT]
{ 0x0990, 0x0064, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48DC, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_LL_CCM_0]
{ 0x0990, 0x004D, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48DE, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_LL_CCM_1]
{ 0x0990, 0x0096, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48E0, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_LL_CCM_2]
{ 0x0990, 0x001D, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48E2, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_LL_CCM_3]
{ 0x0990, 0x004D, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48E4, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_LL_CCM_4]
{ 0x0990, 0x0096, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48E6, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_LL_CCM_5]
{ 0x0990, 0x001D, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48E8, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_LL_CCM_6]
{ 0x0990, 0x004D, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48EA, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_LL_CCM_7]
{ 0x0990, 0x0096, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48EC, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_LL_CCM_8]
{ 0x0990, 0x001D, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xDC2A, WORD_LEN, 0 }, 	// MCU_ADDRESS [SYS_DELTA_GAIN]
{ 0x0990, 0x000B, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xDC2B, WORD_LEN, 0 }, 	// MCU_ADDRESS [SYS_DELTA_THRESH]
{ 0x0990, 0x0017, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC0B, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_0]
{ 0x0990, 0x0000, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC0C, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_1]
{ 0x0990, 0x001B, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC0D, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_2]
{ 0x0990, 0x002A, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC0E, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_3]
{ 0x0990, 0x003E, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC0F, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_4]
{ 0x0990, 0x005A, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC10, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_5]
{ 0x0990, 0x0070, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC11, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_6]
{ 0x0990, 0x0081, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC12, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_7]
{ 0x0990, 0x0090, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC13, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_8]
{ 0x0990, 0x009E, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC14, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_9]
{ 0x0990, 0x00AB, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC15, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_10]
{ 0x0990, 0x00B6, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC16, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_11]
{ 0x0990, 0x00C1, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC17, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_12]
{ 0x0990, 0x00CB, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC18, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_13]
{ 0x0990, 0x00D5, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC19, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_14]
{ 0x0990, 0x00DE, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC1A, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_15]
{ 0x0990, 0x00E7, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC1B, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_16]
{ 0x0990, 0x00EF, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC1C, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_17]
{ 0x0990, 0x00F7, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC1D, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_18]
{ 0x0990, 0x00FF, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC1E, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_0]
{ 0x0990, 0x0000, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC1F, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_1]
{ 0x0990, 0x001B, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC20, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_2]
{ 0x0990, 0x002A, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC21, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_3]
{ 0x0990, 0x003E, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC22, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_4]
{ 0x0990, 0x005A, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC23, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_5]
{ 0x0990, 0x0070, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC24, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_6]
{ 0x0990, 0x0081, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC25, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_7]
{ 0x0990, 0x0090, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC26, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_8]
{ 0x0990, 0x009E, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC27, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_9]
{ 0x0990, 0x00AB, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC28, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_10]
{ 0x0990, 0x00B6, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC29, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_11]
{ 0x0990, 0x00C1, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC2A, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_12]
{ 0x0990, 0x00CB, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC2B, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_13]
{ 0x0990, 0x00D5, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC2C, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_14]
{ 0x0990, 0x00DE, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC2D, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_15]
{ 0x0990, 0x00E7, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC2E, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_16]
{ 0x0990, 0x00EF, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC2F, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_17]
{ 0x0990, 0x00F7, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC30, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_18]
{ 0x0990, 0x00FF, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC31, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_0]
{ 0x0990, 0x0000, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC32, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_1]
{ 0x0990, 0x000D, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC33, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_2]
{ 0x0990, 0x0019, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC34, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_3]
{ 0x0990, 0x0030, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC35, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_4]
{ 0x0990, 0x0056, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC36, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_5]
{ 0x0990, 0x0070, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC37, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_6]
{ 0x0990, 0x0081, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC38, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_7]
{ 0x0990, 0x0090, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC39, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_8]
{ 0x0990, 0x009E, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC3A, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_9]
{ 0x0990, 0x00AB, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC3B, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_10]
{ 0x0990, 0x00B6, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC3C, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_11]
{ 0x0990, 0x00C1, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC3D, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_12]
{ 0x0990, 0x00CB, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC3E, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_13]
{ 0x0990, 0x00D5, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC3F, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_14]
{ 0x0990, 0x00DE, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC40, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_15]
{ 0x0990, 0x00E7, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC41, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_16]
{ 0x0990, 0x00EF, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC42, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_17]
{ 0x0990, 0x00F7, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC43, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_18]
{ 0x0990, 0x00FF, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x6865, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_A_CONFIG_LL_ALGO_ENTER]
{ 0x0990, 0x00E0, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x6867, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_A_CONFIG_LL_ALGO_RUN]
{ 0x0990, 0x00F4, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x8400, WORD_LEN, 0 }, 	// MCU_ADDRESS [SEQ_CMD]
{ 0x0990, 0x0006, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC4A, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_TONAL_CURVE_HIGH]
{ 0x0990, 0x007F, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC4B, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_TONAL_CURVE_MED]
{ 0x0990, 0x007F, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xBC4C, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_TONAL_CURVE_LOW]
{ 0x0990, 0x007F, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x3542, 0x0010, WORD_LEN, 0 }, 	// TONAL_X0
{ 0x3544, 0x0030, WORD_LEN, 0 }, 	// TONAL_X1
{ 0x3546, 0x0040, WORD_LEN, 0 }, 	// TONAL_X2
{ 0x3548, 0x0080, WORD_LEN, 0 }, 	// TONAL_X3
{ 0x354A, 0x0100, WORD_LEN, 0 }, 	// TONAL_X4
{ 0x354C, 0x0200, WORD_LEN, 0 }, 	// TONAL_X5
{ 0x354E, 0x0300, WORD_LEN, 0 }, 	// TONAL_X6
{ 0x3550, 0x0010, WORD_LEN, 0 }, 	// TONAL_Y0
{ 0x3552, 0x0030, WORD_LEN, 0 }, 	// TONAL_Y1
{ 0x3554, 0x0040, WORD_LEN, 0 }, 	// TONAL_Y2
{ 0x3556, 0x0080, WORD_LEN, 0 }, 	// TONAL_Y3
{ 0x3558, 0x012C, WORD_LEN, 0 }, 	// TONAL_Y4
{ 0x355A, 0x0320, WORD_LEN, 0 }, 	// TONAL_Y5
{ 0x355C, 0x03E8, WORD_LEN, 0 }, 	// TONAL_Y6
{ 0x3560, 0x0040, WORD_LEN, 0 }, 	// RECIPROCAL_OF_X0_MINUS_ZERO
{ 0x3562, 0x0020, WORD_LEN, 0 }, 	// RECIPROCAL_OF_X1_MINUS_X0
{ 0x3564, 0x0040, WORD_LEN, 0 }, 	// RECIPROCAL_OF_X2_MINUS_X1
{ 0x3566, 0x0010, WORD_LEN, 0 }, 	// RECIPROCAL_OF_X3_MINUS_X2
{ 0x3568, 0x0008, WORD_LEN, 0 }, 	// RECIPROCAL_OF_X4_MINUS_X3
{ 0x356A, 0x0004, WORD_LEN, 0 }, 	// RECIPROCAL_OF_X5_MINUS_X4
{ 0x356C, 0x0004, WORD_LEN, 0 }, 	// RECIPROCAL_OF_X6_MINUS_X5
{ 0x356E, 0x0004, WORD_LEN, 0 }, 	// RECIPROCAL_OF_400_MINUS_X6
{ 0x098E, 0x3C4D, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_START_GAMMA_FTB]
{ 0x0990, 0x0DAC, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x3C4F, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_STOP_GAMMA_FTB]
{ 0x0990, 0x148A, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC911, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_STAT_LUMA_THRESH_HIGH]
{ 0x0990, 0x00C8, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC8F4, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_AWB_XSCALE]
{ 0x0990, 0x0004, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC8F5, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_AWB_YSCALE]
{ 0x0990, 0x0002, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48F6, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_AWB_WEIGHTS_0]
{ 0x0990, 0x3B4D, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48F8, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_AWB_WEIGHTS_1]
{ 0x0990, 0x6380, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48FA, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_AWB_WEIGHTS_2]
{ 0x0990, 0x9B18, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48FC, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_AWB_WEIGHTS_3]
{ 0x0990, 0x5D51, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48FE, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_AWB_WEIGHTS_4]
{ 0x0990, 0xEDE8, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4900, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_AWB_WEIGHTS_5]
{ 0x0990, 0xE515, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4902, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_AWB_WEIGHTS_6]
{ 0x0990, 0xBFF4, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4904, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_AWB_WEIGHTS_7]
{ 0x0990, 0x001E, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4906, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_AWB_XSHIFT_PRE_ADJ]
{ 0x0990, 0x0026, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x4908, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_AWB_YSHIFT_PRE_ADJ]
{ 0x0990, 0x0033, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xE84A, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_A_CONFIG_AWB_K_R_L]
{ 0x0990, 0x0083, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xE84D, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_A_CONFIG_AWB_K_R_R]
{ 0x0990, 0x0083, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xE84C, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_A_CONFIG_AWB_K_B_L]
{ 0x0990, 0x0080, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xE84F, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_A_CONFIG_AWB_K_B_R]
{ 0x0990, 0x0080, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x8400, WORD_LEN, 0 }, 	// MCU_ADDRESS [SEQ_CMD]
{ 0x0990, 0x0006, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48B0, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_0]
{ 0x0990, 0x0180, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48B2, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_1]
{ 0x0990, 0xFF7A, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48B4, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_2]
{ 0x0990, 0x0018, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48B6, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_3]
{ 0x0990, 0xFFCA, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48B8, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_4]
{ 0x0990, 0x017C, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48BA, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_5]
{ 0x0990, 0xFFCC, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48BC, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_6]
{ 0x0990, 0x000C, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48BE, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_7]
{ 0x0990, 0xFF1F, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48C0, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_8]
{ 0x0990, 0x01E8, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48C2, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_9]
{ 0x0990, 0x0020, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48C4, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_10]
{ 0x0990, 0x0044, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48C6, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_0]
{ 0x0990, 0x0079, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48C8, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_1]
{ 0x0990, 0xFFAD, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48CA, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_2]
{ 0x0990, 0xFFE2, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48CC, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_3]
{ 0x0990, 0x0033, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48CE, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_4]
{ 0x0990, 0x002A, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48D0, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_5]
{ 0x0990, 0xFFAA, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48D2, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_6]
{ 0x0990, 0x0017, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48D4, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_7]
{ 0x0990, 0x004B, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48D6, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_8]
{ 0x0990, 0xFFA5, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48D8, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_9]
{ 0x0990, 0x0015, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x48DA, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_10]
{ 0x0990, 0xFFE2, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x35A2, 0x0014, WORD_LEN, 0 }, 	// DARK_COLOR_KILL_CONTROLS
{ 0x098E, 0xC949, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_SYS_DARK_COLOR_KILL]
{ 0x0990, 0x0024, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x35A4, 0x0596, WORD_LEN, 0 }, 	// BRIGHT_COLOR_KILL_CONTROLS
{ 0x098E, 0xC94A, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_SYS_BRIGHT_COLORKILL]
{ 0x0990, 0x0062, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC948, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_SYS_UV_COLOR_BOOST]
{ 0x0990, 0x0006, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC914, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_START_DESATURATION]
{ 0x0990, 0x0000, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xC915, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_LL_END_DESATURATION]
{ 0x0990, 0x00FF, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xE86F, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_A_CONFIG_LL_START_SATURATION]
{ 0x0990, 0x0060, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xE870, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_A_CONFIG_LL_END_SATURATION]
{ 0x0990, 0x003C, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xEC6F, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_B_CONFIG_LL_START_SATURATION]
{ 0x0990, 0x0060, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xEC70, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_B_CONFIG_LL_END_SATURATION]
{ 0x0990, 0x003C, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xE883, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SELECT_FX]
{ 0x0990, 0x0000, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xEC83, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SELECT_FX]
{ 0x0990, 0x0000, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x8400, WORD_LEN, 0 }, 	// MCU_ADDRESS [SEQ_CMD]
{ 0x0990, 0x0006, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xE885, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SEPIA_CR]
{ 0x0990, 0x001E, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xE886, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SEPIA_CB]
{ 0x0990, 0x00D8, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xEC85, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SEPIA_CR]
{ 0x0990, 0x001E, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xEC86, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SEPIA_CB]
{ 0x0990, 0x00D8, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xE884, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SOLARIZATION_TH]
{ 0x0990, 0x005C, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xEC84, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SOLARIZATION_TH]
{ 0x0990, 0x005C, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x490A, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AS_INTEG_SCALE_FIRST_PASS]
{ 0x0990, 0x0666, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x490C, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AS_MIN_INT_TIME_FIRST_PASS]
{ 0x0990, 0x0140, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x6857, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_A_CONFIG_IS_FEATURE_THRESHOLD]
{ 0x0990, 0x0014, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x685C, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_A_CONFIG_IS_BLUR_INPUT_PARAMETER]
{ 0x0990, 0x0005, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x490E, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_AS_MAX_DIGITAL_GAIN_ALLOWED]
{ 0x0990, 0x00A4, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xB43D, WORD_LEN, 0 }, 	// MCU_ADDRESS [AS_START_ASVALUES_0]
{ 0x0990, 0x0031, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xB43E, WORD_LEN, 0 }, 	// MCU_ADDRESS [AS_START_ASVALUES_1]
{ 0x0990, 0x001B, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xB43F, WORD_LEN, 0 }, 	// MCU_ADDRESS [AS_START_ASVALUES_2]
{ 0x0990, 0x0028, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xB440, WORD_LEN, 0 }, 	// MCU_ADDRESS [AS_START_ASVALUES_3]
{ 0x0990, 0x0003, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xB441, WORD_LEN, 0 }, 	// MCU_ADDRESS [AS_STOP_ASVALUES_0]
{ 0x0990, 0x00CD, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xB442, WORD_LEN, 0 }, 	// MCU_ADDRESS [AS_STOP_ASVALUES_1]
{ 0x0990, 0x0064, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xB443, WORD_LEN, 0 }, 	// MCU_ADDRESS [AS_STOP_ASVALUES_2]
{ 0x0990, 0x000F, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xB444, WORD_LEN, 0 }, 	// MCU_ADDRESS [AS_STOP_ASVALUES_3]
{ 0x0990, 0x0007, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x300D, WORD_LEN, 0 }, 	// MCU_ADDRESS [AF_FILTERS]
{ 0x0990, 0x000F, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x3017, WORD_LEN, 0 }, 	// MCU_ADDRESS [AF_THRESHOLDS]
{ 0x0990, 0x0F0F, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x8400, WORD_LEN, 0 }, 	// MCU_ADDRESS [SEQ_CMD]
{ 0x0990, 0x0006, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xE81F, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_A_CONFIG_AE_RULE_BASE_TARGET]
{ 0x0990, 0x0020, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x68A0, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_A_CONFIG_JPEG_OB_TX_CONTROL_VAR]
{ 0x0990, 0x082E, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x6CA0, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_B_CONFIG_JPEG_OB_TX_CONTROL_VAR]
{ 0x0990, 0x082E, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x70A0, WORD_LEN, 0 }, 	// MCU_ADDRESS [SEC_A_CONFIG_JPEG_OB_TX_CONTROL_VAR]
{ 0x0990, 0x082E, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x74A0, WORD_LEN, 0 }, 	// MCU_ADDRESS [SEC_B_CONFIG_JPEG_OB_TX_CONTROL_VAR]
{ 0x0990, 0x082E, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x3C52, 0x082E, WORD_LEN, 0 }, 	// RESERVED_TX_SS_3C52
{ 0x098E, 0x488E, WORD_LEN, 0 }, 	// MCU_ADDRESS [CAM1_CTX_B_RX_FIFO_TRIGGER_MARK]
{ 0x0990, 0x0020, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0xECAC, WORD_LEN, 0 }, 	// MCU_ADDRESS [PRI_B_CONFIG_IO_OB_MANUAL_FLAG]
{ 0x0990, 0x0000, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x3084, 0x2409, WORD_LEN, 0 }, 	// RESERVED_CORE_3084
{ 0x3092, 0x0A49, WORD_LEN, 0 }, 	// RESERVED_CORE_3092
{ 0x3094, 0x4949, WORD_LEN, 0 }, 	// RESERVED_CORE_3094
{ 0x3096, 0x4950, WORD_LEN, 0 }, 	// RESERVED_CORE_3096
{ 0x0982, 0x0000, WORD_LEN, 0 }, 	// ACCESS_CTL_STAT
{ 0x098A, 0x0CFB, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x3C3C, WORD_LEN, 0 }, 
{ 0x0992, 0x3C3C, WORD_LEN, 0 }, 
{ 0x0994, 0x3C3C, WORD_LEN, 0 }, 
{ 0x0996, 0x5F4F, WORD_LEN, 0 }, 
{ 0x0998, 0x30ED, WORD_LEN, 0 }, 
{ 0x099A, 0x0AED, WORD_LEN, 0 }, 
{ 0x099C, 0x08BD, WORD_LEN, 0 }, 
{ 0x099E, 0x61D5, WORD_LEN, 0 }, 
{ 0x098A, 0x0D0B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xCE04, WORD_LEN, 0 }, 
{ 0x0992, 0xCD1F, WORD_LEN, 0 }, 
{ 0x0994, 0x1702, WORD_LEN, 0 }, 
{ 0x0996, 0x11CC, WORD_LEN, 0 }, 
{ 0x0998, 0x332E, WORD_LEN, 0 }, 
{ 0x099A, 0x30ED, WORD_LEN, 0 }, 
{ 0x099C, 0x02CC, WORD_LEN, 0 }, 
{ 0x099E, 0xFFFD, WORD_LEN, 0 }, 
{ 0x098A, 0x0D1B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xED00, WORD_LEN, 0 }, 
{ 0x0992, 0xCC00, WORD_LEN, 0 }, 
{ 0x0994, 0x02BD, WORD_LEN, 0 }, 
{ 0x0996, 0x706D, WORD_LEN, 0 }, 
{ 0x0998, 0x18DE, WORD_LEN, 0 }, 
{ 0x099A, 0x1F18, WORD_LEN, 0 }, 
{ 0x099C, 0x1F8E, WORD_LEN, 0 }, 
{ 0x099E, 0x0110, WORD_LEN, 0 }, 
{ 0x098A, 0x0D2B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xCC3C, WORD_LEN, 0 }, 
{ 0x0992, 0x5230, WORD_LEN, 0 }, 
{ 0x0994, 0xED00, WORD_LEN, 0 }, 
{ 0x0996, 0x18EC, WORD_LEN, 0 }, 
{ 0x0998, 0xA0C4, WORD_LEN, 0 }, 
{ 0x099A, 0xFDBD, WORD_LEN, 0 }, 
{ 0x099C, 0x7021, WORD_LEN, 0 }, 
{ 0x099E, 0x201E, WORD_LEN, 0 }, 
{ 0x098A, 0x0D3B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xCC3C, WORD_LEN, 0 }, 
{ 0x0992, 0x5230, WORD_LEN, 0 }, 
{ 0x0994, 0xED00, WORD_LEN, 0 }, 
{ 0x0996, 0xDE1F, WORD_LEN, 0 }, 
{ 0x0998, 0xECA0, WORD_LEN, 0 }, 
{ 0x099A, 0xBD70, WORD_LEN, 0 }, 
{ 0x099C, 0x21CC, WORD_LEN, 0 }, 
{ 0x099E, 0x3C52, WORD_LEN, 0 }, 
{ 0x098A, 0x0D4B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x30ED, WORD_LEN, 0 }, 
{ 0x0992, 0x02CC, WORD_LEN, 0 }, 
{ 0x0994, 0xFFFC, WORD_LEN, 0 }, 
{ 0x0996, 0xED00, WORD_LEN, 0 }, 
{ 0x0998, 0xCC00, WORD_LEN, 0 }, 
{ 0x099A, 0x02BD, WORD_LEN, 0 }, 
{ 0x099C, 0x706D, WORD_LEN, 0 }, 
{ 0x099E, 0xFC04, WORD_LEN, 0 }, 
{ 0x098A, 0x0D5B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xE11A, WORD_LEN, 0 }, 
{ 0x0992, 0x8300, WORD_LEN, 0 }, 
{ 0x0994, 0x0127, WORD_LEN, 0 }, 
{ 0x0996, 0x201A, WORD_LEN, 0 }, 
{ 0x0998, 0x8300, WORD_LEN, 0 }, 
{ 0x099A, 0x0427, WORD_LEN, 0 }, 
{ 0x099C, 0x221A, WORD_LEN, 0 }, 
{ 0x099E, 0x8300, WORD_LEN, 0 }, 
{ 0x098A, 0x0D6B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x0827, WORD_LEN, 0 }, 
{ 0x0992, 0x241A, WORD_LEN, 0 }, 
{ 0x0994, 0x8300, WORD_LEN, 0 }, 
{ 0x0996, 0x1027, WORD_LEN, 0 }, 
{ 0x0998, 0x261A, WORD_LEN, 0 }, 
{ 0x099A, 0x8300, WORD_LEN, 0 }, 
{ 0x099C, 0x2027, WORD_LEN, 0 }, 
{ 0x099E, 0x281A, WORD_LEN, 0 }, 
{ 0x098A, 0x0D7B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x8300, WORD_LEN, 0 }, 
{ 0x0992, 0x4027, WORD_LEN, 0 }, 
{ 0x0994, 0x2A20, WORD_LEN, 0 }, 
{ 0x0996, 0x2ECC, WORD_LEN, 0 }, 
{ 0x0998, 0x001E, WORD_LEN, 0 }, 
{ 0x099A, 0x30ED, WORD_LEN, 0 }, 
{ 0x099C, 0x0A20, WORD_LEN, 0 }, 
{ 0x099E, 0x26CC, WORD_LEN, 0 }, 
{ 0x098A, 0x0D8B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x0022, WORD_LEN, 0 }, 
{ 0x0992, 0x30ED, WORD_LEN, 0 }, 
{ 0x0994, 0x0A20, WORD_LEN, 0 }, 
{ 0x0996, 0x1ECC, WORD_LEN, 0 }, 
{ 0x0998, 0x0021, WORD_LEN, 0 }, 
{ 0x099A, 0x30ED, WORD_LEN, 0 }, 
{ 0x099C, 0x0A20, WORD_LEN, 0 }, 
{ 0x099E, 0x16CC, WORD_LEN, 0 }, 
{ 0x098A, 0x0D9B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x0020, WORD_LEN, 0 }, 
{ 0x0992, 0x30ED, WORD_LEN, 0 }, 
{ 0x0994, 0x0A20, WORD_LEN, 0 }, 
{ 0x0996, 0x0ECC, WORD_LEN, 0 }, 
{ 0x0998, 0x002A, WORD_LEN, 0 }, 
{ 0x099A, 0x30ED, WORD_LEN, 0 }, 
{ 0x099C, 0x0A20, WORD_LEN, 0 }, 
{ 0x099E, 0x06CC, WORD_LEN, 0 }, 
{ 0x098A, 0x0DAB, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x002B, WORD_LEN, 0 }, 
{ 0x0992, 0x30ED, WORD_LEN, 0 }, 
{ 0x0994, 0x0ACC, WORD_LEN, 0 }, 
{ 0x0996, 0x3400, WORD_LEN, 0 }, 
{ 0x0998, 0x30ED, WORD_LEN, 0 }, 
{ 0x099A, 0x0034, WORD_LEN, 0 }, 
{ 0x099C, 0xBD6F, WORD_LEN, 0 }, 
{ 0x099E, 0xD184, WORD_LEN, 0 }, 
{ 0x098A, 0x0DBB, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x0330, WORD_LEN, 0 }, 
{ 0x0992, 0xED07, WORD_LEN, 0 }, 
{ 0x0994, 0xA60C, WORD_LEN, 0 }, 
{ 0x0996, 0x4848, WORD_LEN, 0 }, 
{ 0x0998, 0x5FED, WORD_LEN, 0 }, 
{ 0x099A, 0x05EC, WORD_LEN, 0 }, 
{ 0x099C, 0x07EA, WORD_LEN, 0 }, 
{ 0x099E, 0x06AA, WORD_LEN, 0 }, 
{ 0x098A, 0x0DCB, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x0531, WORD_LEN, 0 }, 
{ 0x0992, 0xBD70, WORD_LEN, 0 }, 
{ 0x0994, 0x21DE, WORD_LEN, 0 }, 
{ 0x0996, 0x1F1F, WORD_LEN, 0 }, 
{ 0x0998, 0x8E01, WORD_LEN, 0 }, 
{ 0x099A, 0x08EC, WORD_LEN, 0 }, 
{ 0x099C, 0x9B05, WORD_LEN, 0 }, 
{ 0x099E, 0x30ED, WORD_LEN, 0 }, 
{ 0x098A, 0x0DDB, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x0820, WORD_LEN, 0 }, 
{ 0x0992, 0x3BDE, WORD_LEN, 0 }, 
{ 0x0994, 0x1FEC, WORD_LEN, 0 }, 
{ 0x0996, 0x0783, WORD_LEN, 0 }, 
{ 0x0998, 0x0040, WORD_LEN, 0 }, 
{ 0x099A, 0x2628, WORD_LEN, 0 }, 
{ 0x099C, 0x7F30, WORD_LEN, 0 }, 
{ 0x099E, 0xC4CC, WORD_LEN, 0 }, 
{ 0x098A, 0x0DEB, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x3C68, WORD_LEN, 0 }, 
{ 0x0992, 0xBD6F, WORD_LEN, 0 }, 
{ 0x0994, 0xD1FD, WORD_LEN, 0 }, 
{ 0x0996, 0x30C5, WORD_LEN, 0 }, 
{ 0x0998, 0xCC01, WORD_LEN, 0 }, 
{ 0x099A, 0xF4FD, WORD_LEN, 0 }, 
{ 0x099C, 0x30C7, WORD_LEN, 0 }, 
{ 0x099E, 0xC640, WORD_LEN, 0 }, 
{ 0x098A, 0x0DFB, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xF730, WORD_LEN, 0 }, 
{ 0x0992, 0xC4CC, WORD_LEN, 0 }, 
{ 0x0994, 0x0190, WORD_LEN, 0 }, 
{ 0x0996, 0xFD30, WORD_LEN, 0 }, 
{ 0x0998, 0xC501, WORD_LEN, 0 }, 
{ 0x099A, 0x0101, WORD_LEN, 0 }, 
{ 0x099C, 0xFC30, WORD_LEN, 0 }, 
{ 0x099E, 0xC230, WORD_LEN, 0 }, 
{ 0x098A, 0x0E0B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xED08, WORD_LEN, 0 }, 
{ 0x0992, 0x200A, WORD_LEN, 0 }, 
{ 0x0994, 0xCC3C, WORD_LEN, 0 }, 
{ 0x0996, 0x68BD, WORD_LEN, 0 }, 
{ 0x0998, 0x6FD1, WORD_LEN, 0 }, 
{ 0x099A, 0x0530, WORD_LEN, 0 }, 
{ 0x099C, 0xED08, WORD_LEN, 0 }, 
{ 0x099E, 0xCC34, WORD_LEN, 0 }, 
{ 0x098A, 0x0E1B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x08ED, WORD_LEN, 0 }, 
{ 0x0992, 0x00EC, WORD_LEN, 0 }, 
{ 0x0994, 0x08BD, WORD_LEN, 0 }, 
{ 0x0996, 0x7021, WORD_LEN, 0 }, 
{ 0x0998, 0x30C6, WORD_LEN, 0 }, 
{ 0x099A, 0x0C3A, WORD_LEN, 0 }, 
{ 0x099C, 0x3539, WORD_LEN, 0 }, 
{ 0x099E, 0x373C, WORD_LEN, 0 }, 
{ 0x098A, 0x0E2B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x3C3C, WORD_LEN, 0 }, 
{ 0x0992, 0x34DE, WORD_LEN, 0 }, 
{ 0x0994, 0x2FEE, WORD_LEN, 0 }, 
{ 0x0996, 0x0EAD, WORD_LEN, 0 }, 
{ 0x0998, 0x007D, WORD_LEN, 0 }, 
{ 0x099A, 0x13EF, WORD_LEN, 0 }, 
{ 0x099C, 0x277C, WORD_LEN, 0 }, 
{ 0x099E, 0xCE13, WORD_LEN, 0 }, 
{ 0x098A, 0x0E3B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xE01E, WORD_LEN, 0 }, 
{ 0x0992, 0x0510, WORD_LEN, 0 }, 
{ 0x0994, 0x60E6, WORD_LEN, 0 }, 
{ 0x0996, 0x0E4F, WORD_LEN, 0 }, 
{ 0x0998, 0xC313, WORD_LEN, 0 }, 
{ 0x099A, 0xF08F, WORD_LEN, 0 }, 
{ 0x099C, 0xE600, WORD_LEN, 0 }, 
{ 0x099E, 0x30E1, WORD_LEN, 0 }, 
{ 0x098A, 0x0E4B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x0722, WORD_LEN, 0 }, 
{ 0x0992, 0x16F6, WORD_LEN, 0 }, 
{ 0x0994, 0x13EE, WORD_LEN, 0 }, 
{ 0x0996, 0x4FC3, WORD_LEN, 0 }, 
{ 0x0998, 0x13F3, WORD_LEN, 0 }, 
{ 0x099A, 0x8FE6, WORD_LEN, 0 }, 
{ 0x099C, 0x0030, WORD_LEN, 0 }, 
{ 0x099E, 0xE107, WORD_LEN, 0 }, 
{ 0x098A, 0x0E5B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x2507, WORD_LEN, 0 }, 
{ 0x0992, 0xF613, WORD_LEN, 0 }, 
{ 0x0994, 0xEEC1, WORD_LEN, 0 }, 
{ 0x0996, 0x0325, WORD_LEN, 0 }, 
{ 0x0998, 0x3C7F, WORD_LEN, 0 }, 
{ 0x099A, 0x13EE, WORD_LEN, 0 }, 
{ 0x099C, 0xF613, WORD_LEN, 0 }, 
{ 0x099E, 0xEFE7, WORD_LEN, 0 }, 
{ 0x098A, 0x0E6B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x06CC, WORD_LEN, 0 }, 
{ 0x0992, 0x13F0, WORD_LEN, 0 }, 
{ 0x0994, 0xED04, WORD_LEN, 0 }, 
{ 0x0996, 0xCC13, WORD_LEN, 0 }, 
{ 0x0998, 0xF320, WORD_LEN, 0 }, 
{ 0x099A, 0x0F7C, WORD_LEN, 0 }, 
{ 0x099C, 0x13EE, WORD_LEN, 0 }, 
{ 0x099E, 0xEC04, WORD_LEN, 0 }, 
{ 0x098A, 0x0E7B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xC300, WORD_LEN, 0 }, 
{ 0x0992, 0x01ED, WORD_LEN, 0 }, 
{ 0x0994, 0x04EC, WORD_LEN, 0 }, 
{ 0x0996, 0x02C3, WORD_LEN, 0 }, 
{ 0x0998, 0x0001, WORD_LEN, 0 }, 
{ 0x099A, 0xED02, WORD_LEN, 0 }, 
{ 0x099C, 0xF613, WORD_LEN, 0 }, 
{ 0x099E, 0xEEE1, WORD_LEN, 0 }, 
{ 0x098A, 0x0E8B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x0624, WORD_LEN, 0 }, 
{ 0x0992, 0x12EE, WORD_LEN, 0 }, 
{ 0x0994, 0x04E6, WORD_LEN, 0 }, 
{ 0x0996, 0x0030, WORD_LEN, 0 }, 
{ 0x0998, 0xE107, WORD_LEN, 0 }, 
{ 0x099A, 0x22DF, WORD_LEN, 0 }, 
{ 0x099C, 0xEE02, WORD_LEN, 0 }, 
{ 0x099E, 0xE600, WORD_LEN, 0 }, 
{ 0x098A, 0x0E9B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x30E1, WORD_LEN, 0 }, 
{ 0x0992, 0x0725, WORD_LEN, 0 }, 
{ 0x0994, 0xD6DE, WORD_LEN, 0 }, 
{ 0x0996, 0x49EE, WORD_LEN, 0 }, 
{ 0x0998, 0x08AD, WORD_LEN, 0 }, 
{ 0x099A, 0x00CC, WORD_LEN, 0 }, 
{ 0x099C, 0x13F6, WORD_LEN, 0 }, 
{ 0x099E, 0x30ED, WORD_LEN, 0 }, 
{ 0x098A, 0x0EAB, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x00DE, WORD_LEN, 0 }, 
{ 0x0992, 0x2FEE, WORD_LEN, 0 }, 
{ 0x0994, 0x10CC, WORD_LEN, 0 }, 
{ 0x0996, 0x13FA, WORD_LEN, 0 }, 
{ 0x0998, 0xAD00, WORD_LEN, 0 }, 
{ 0x099A, 0x3838, WORD_LEN, 0 }, 
{ 0x099C, 0x3838, WORD_LEN, 0 }, 
{ 0x099E, 0x3937, WORD_LEN, 0 }, 
{ 0x098A, 0x0EBB, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x363C, WORD_LEN, 0 }, 
{ 0x0992, 0x3C3C, WORD_LEN, 0 }, 
{ 0x0994, 0x5F4F, WORD_LEN, 0 }, 
{ 0x0996, 0x30ED, WORD_LEN, 0 }, 
{ 0x0998, 0x04EC, WORD_LEN, 0 }, 
{ 0x099A, 0x06ED, WORD_LEN, 0 }, 
{ 0x099C, 0x008F, WORD_LEN, 0 }, 
{ 0x099E, 0xC300, WORD_LEN, 0 }, 
{ 0x098A, 0x0ECB, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x04BD, WORD_LEN, 0 }, 
{ 0x0992, 0x0F43, WORD_LEN, 0 }, 
{ 0x0994, 0x30EC, WORD_LEN, 0 }, 
{ 0x0996, 0x04BD, WORD_LEN, 0 }, 
{ 0x0998, 0x0F76, WORD_LEN, 0 }, 
{ 0x099A, 0x30ED, WORD_LEN, 0 }, 
{ 0x099C, 0x0238, WORD_LEN, 0 }, 
{ 0x099E, 0x3838, WORD_LEN, 0 }, 
{ 0x098A, 0x0EDB, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x3839, WORD_LEN, 0 }, 
{ 0x0992, 0x373C, WORD_LEN, 0 }, 
{ 0x0994, 0x3C3C, WORD_LEN, 0 }, 
{ 0x0996, 0x3C30, WORD_LEN, 0 }, 
{ 0x0998, 0xE608, WORD_LEN, 0 }, 
{ 0x099A, 0x2712, WORD_LEN, 0 }, 
{ 0x099C, 0xC101, WORD_LEN, 0 }, 
{ 0x099E, 0x2713, WORD_LEN, 0 }, 
{ 0x098A, 0x0EEB, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xC102, WORD_LEN, 0 }, 
{ 0x0992, 0x2714, WORD_LEN, 0 }, 
{ 0x0994, 0xC103, WORD_LEN, 0 }, 
{ 0x0996, 0x2715, WORD_LEN, 0 }, 
{ 0x0998, 0xC104, WORD_LEN, 0 }, 
{ 0x099A, 0x2716, WORD_LEN, 0 }, 
{ 0x099C, 0x2019, WORD_LEN, 0 }, 
{ 0x099E, 0xCC30, WORD_LEN, 0 }, 
{ 0x098A, 0x0EFB, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x5E20, WORD_LEN, 0 }, 
{ 0x0992, 0x12CC, WORD_LEN, 0 }, 
{ 0x0994, 0x305A, WORD_LEN, 0 }, 
{ 0x0996, 0x200D, WORD_LEN, 0 }, 
{ 0x0998, 0xCC30, WORD_LEN, 0 }, 
{ 0x099A, 0x5620, WORD_LEN, 0 }, 
{ 0x099C, 0x08CC, WORD_LEN, 0 }, 
{ 0x099E, 0x305C, WORD_LEN, 0 }, 
{ 0x098A, 0x0F0B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x2003, WORD_LEN, 0 }, 
{ 0x0992, 0xCC30, WORD_LEN, 0 }, 
{ 0x0994, 0x58ED, WORD_LEN, 0 }, 
{ 0x0996, 0x065F, WORD_LEN, 0 }, 
{ 0x0998, 0x4FED, WORD_LEN, 0 }, 
{ 0x099A, 0x04EC, WORD_LEN, 0 }, 
{ 0x099C, 0x0BED, WORD_LEN, 0 }, 
{ 0x099E, 0x008F, WORD_LEN, 0 }, 
{ 0x098A, 0x0F1B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xC300, WORD_LEN, 0 }, 
{ 0x0992, 0x04BD, WORD_LEN, 0 }, 
{ 0x0994, 0x0F43, WORD_LEN, 0 }, 
{ 0x0996, 0x30EC, WORD_LEN, 0 }, 
{ 0x0998, 0x048A, WORD_LEN, 0 }, 
{ 0x099A, 0x02ED, WORD_LEN, 0 }, 
{ 0x099C, 0x02EC, WORD_LEN, 0 }, 
{ 0x099E, 0x06ED, WORD_LEN, 0 }, 
{ 0x098A, 0x0F2B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x008F, WORD_LEN, 0 }, 
{ 0x0992, 0xC300, WORD_LEN, 0 }, 
{ 0x0994, 0x02DE, WORD_LEN, 0 }, 
{ 0x0996, 0x0EAD, WORD_LEN, 0 }, 
{ 0x0998, 0x0030, WORD_LEN, 0 }, 
{ 0x099A, 0xEC04, WORD_LEN, 0 }, 
{ 0x099C, 0xBD0F, WORD_LEN, 0 }, 
{ 0x099E, 0x7630, WORD_LEN, 0 }, 
{ 0x098A, 0x0F3B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xED02, WORD_LEN, 0 }, 
{ 0x0992, 0x3838, WORD_LEN, 0 }, 
{ 0x0994, 0x3838, WORD_LEN, 0 }, 
{ 0x0996, 0x3139, WORD_LEN, 0 }, 
{ 0x0998, 0x3736, WORD_LEN, 0 }, 
{ 0x099A, 0x30EC, WORD_LEN, 0 }, 
{ 0x099C, 0x041A, WORD_LEN, 0 }, 
{ 0x099E, 0x8300, WORD_LEN, 0 }, 
{ 0x098A, 0x0F4B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x4025, WORD_LEN, 0 }, 
{ 0x0992, 0x22EC, WORD_LEN, 0 }, 
{ 0x0994, 0x041A, WORD_LEN, 0 }, 
{ 0x0996, 0x8300, WORD_LEN, 0 }, 
{ 0x0998, 0x8024, WORD_LEN, 0 }, 
{ 0x099A, 0x0504, WORD_LEN, 0 }, 
{ 0x099C, 0xCA40, WORD_LEN, 0 }, 
{ 0x099E, 0x2015, WORD_LEN, 0 }, 
{ 0x098A, 0x0F5B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xEC04, WORD_LEN, 0 }, 
{ 0x0992, 0x1A83, WORD_LEN, 0 }, 
{ 0x0994, 0x0100, WORD_LEN, 0 }, 
{ 0x0996, 0x2406, WORD_LEN, 0 }, 
{ 0x0998, 0x0404, WORD_LEN, 0 }, 
{ 0x099A, 0xCA80, WORD_LEN, 0 }, 
{ 0x099C, 0x2007, WORD_LEN, 0 }, 
{ 0x099E, 0xEC04, WORD_LEN, 0 }, 
{ 0x098A, 0x0F6B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x0404, WORD_LEN, 0 }, 
{ 0x0992, 0x04CA, WORD_LEN, 0 }, 
{ 0x0994, 0xC0EE, WORD_LEN, 0 }, 
{ 0x0996, 0x00ED, WORD_LEN, 0 }, 
{ 0x0998, 0x0038, WORD_LEN, 0 }, 
{ 0x099A, 0x3937, WORD_LEN, 0 }, 
{ 0x099C, 0x363C, WORD_LEN, 0 }, 
{ 0x099E, 0x301F, WORD_LEN, 0 }, 
{ 0x098A, 0x0F7B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x0340, WORD_LEN, 0 }, 
{ 0x0992, 0x0E1F, WORD_LEN, 0 }, 
{ 0x0994, 0x0380, WORD_LEN, 0 }, 
{ 0x0996, 0x0AEC, WORD_LEN, 0 }, 
{ 0x0998, 0x02C4, WORD_LEN, 0 }, 
{ 0x099A, 0x3F4F, WORD_LEN, 0 }, 
{ 0x099C, 0x0505, WORD_LEN, 0 }, 
{ 0x099E, 0x0520, WORD_LEN, 0 }, 
{ 0x098A, 0x0F8B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x1B1F, WORD_LEN, 0 }, 
{ 0x0992, 0x0380, WORD_LEN, 0 }, 
{ 0x0994, 0x09EC, WORD_LEN, 0 }, 
{ 0x0996, 0x02C4, WORD_LEN, 0 }, 
{ 0x0998, 0x3F4F, WORD_LEN, 0 }, 
{ 0x099A, 0x0505, WORD_LEN, 0 }, 
{ 0x099C, 0x200E, WORD_LEN, 0 }, 
{ 0x099E, 0x1F03, WORD_LEN, 0 }, 
{ 0x098A, 0x0F9B, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x4008, WORD_LEN, 0 }, 
{ 0x0992, 0xEC02, WORD_LEN, 0 }, 
{ 0x0994, 0xC43F, WORD_LEN, 0 }, 
{ 0x0996, 0x4F05, WORD_LEN, 0 }, 
{ 0x0998, 0x2002, WORD_LEN, 0 }, 
{ 0x099A, 0xEC02, WORD_LEN, 0 }, 
{ 0x099C, 0xED00, WORD_LEN, 0 }, 
{ 0x099E, 0x3838, WORD_LEN, 0 }, 
{ 0x098A, 0x8FAB, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x0039, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098A, 0x1000, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xCC10, WORD_LEN, 0 }, 
{ 0x0992, 0x09BD, WORD_LEN, 0 }, 
{ 0x0994, 0x4224, WORD_LEN, 0 }, 
{ 0x0996, 0x7E10, WORD_LEN, 0 }, 
{ 0x0998, 0x09C6, WORD_LEN, 0 }, 
{ 0x099A, 0x01F7, WORD_LEN, 0 }, 
{ 0x099C, 0x018A, WORD_LEN, 0 }, 
{ 0x099E, 0xC609, WORD_LEN, 0 }, 
{ 0x098A, 0x1010, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xF701, WORD_LEN, 0 }, 
{ 0x0992, 0x8BDE, WORD_LEN, 0 }, 
{ 0x0994, 0x3F18, WORD_LEN, 0 }, 
{ 0x0996, 0xCE0B, WORD_LEN, 0 }, 
{ 0x0998, 0xF3CC, WORD_LEN, 0 }, 
{ 0x099A, 0x0011, WORD_LEN, 0 }, 
{ 0x099C, 0xBDD7, WORD_LEN, 0 }, 
{ 0x099E, 0x00CC, WORD_LEN, 0 }, 
{ 0x098A, 0x1020, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x0BF3, WORD_LEN, 0 }, 
{ 0x0992, 0xDD3F, WORD_LEN, 0 }, 
{ 0x0994, 0xDE35, WORD_LEN, 0 }, 
{ 0x0996, 0x18CE, WORD_LEN, 0 }, 
{ 0x0998, 0x0C05, WORD_LEN, 0 }, 
{ 0x099A, 0xCC00, WORD_LEN, 0 }, 
{ 0x099C, 0x3FBD, WORD_LEN, 0 }, 
{ 0x099E, 0xD700, WORD_LEN, 0 }, 
{ 0x098A, 0x1030, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xCC0C, WORD_LEN, 0 }, 
{ 0x0992, 0x05DD, WORD_LEN, 0 }, 
{ 0x0994, 0x35DE, WORD_LEN, 0 }, 
{ 0x0996, 0x4718, WORD_LEN, 0 }, 
{ 0x0998, 0xCE0C, WORD_LEN, 0 }, 
{ 0x099A, 0x45CC, WORD_LEN, 0 }, 
{ 0x099C, 0x0015, WORD_LEN, 0 }, 
{ 0x099E, 0xBDD7, WORD_LEN, 0 }, 
{ 0x098A, 0x1040, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x00CC, WORD_LEN, 0 }, 
{ 0x0992, 0x0C45, WORD_LEN, 0 }, 
{ 0x0994, 0xDD47, WORD_LEN, 0 }, 
{ 0x0996, 0xFE00, WORD_LEN, 0 }, 
{ 0x0998, 0x3318, WORD_LEN, 0 }, 
{ 0x099A, 0xCE0C, WORD_LEN, 0 }, 
{ 0x099C, 0x5BCC, WORD_LEN, 0 }, 
{ 0x099E, 0x0009, WORD_LEN, 0 }, 
{ 0x098A, 0x1050, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xBDD7, WORD_LEN, 0 }, 
{ 0x0992, 0x00CC, WORD_LEN, 0 }, 
{ 0x0994, 0x0C5B, WORD_LEN, 0 }, 
{ 0x0996, 0xFD00, WORD_LEN, 0 }, 
{ 0x0998, 0x33DE, WORD_LEN, 0 }, 
{ 0x099A, 0x3118, WORD_LEN, 0 }, 
{ 0x099C, 0xCE0C, WORD_LEN, 0 }, 
{ 0x099E, 0x65CC, WORD_LEN, 0 }, 
{ 0x098A, 0x1060, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x0029, WORD_LEN, 0 }, 
{ 0x0992, 0xBDD7, WORD_LEN, 0 }, 
{ 0x0994, 0x00CC, WORD_LEN, 0 }, 
{ 0x0996, 0x0C65, WORD_LEN, 0 }, 
{ 0x0998, 0xDD31, WORD_LEN, 0 }, 
{ 0x099A, 0xDE39, WORD_LEN, 0 }, 
{ 0x099C, 0x18CE, WORD_LEN, 0 }, 
{ 0x099E, 0x0C8F, WORD_LEN, 0 }, 
{ 0x098A, 0x1070, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xCC00, WORD_LEN, 0 }, 
{ 0x0992, 0x23BD, WORD_LEN, 0 }, 
{ 0x0994, 0xD700, WORD_LEN, 0 }, 
{ 0x0996, 0xCC0C, WORD_LEN, 0 }, 
{ 0x0998, 0x8FDD, WORD_LEN, 0 }, 
{ 0x099A, 0x39DE, WORD_LEN, 0 }, 
{ 0x099C, 0x4918, WORD_LEN, 0 }, 
{ 0x099E, 0xCE0C, WORD_LEN, 0 }, 
{ 0x098A, 0x1080, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xB3CC, WORD_LEN, 0 }, 
{ 0x0992, 0x000D, WORD_LEN, 0 }, 
{ 0x0994, 0xBDD7, WORD_LEN, 0 }, 
{ 0x0996, 0x00CC, WORD_LEN, 0 }, 
{ 0x0998, 0x0CB3, WORD_LEN, 0 }, 
{ 0x099A, 0xDD49, WORD_LEN, 0 }, 
{ 0x099C, 0xFC04, WORD_LEN, 0 }, 
{ 0x099E, 0xC2FD, WORD_LEN, 0 }, 
{ 0x098A, 0x1090, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x0BF1, WORD_LEN, 0 }, 
{ 0x0992, 0x18FE, WORD_LEN, 0 }, 
{ 0x0994, 0x0BF1, WORD_LEN, 0 }, 
{ 0x0996, 0xCDEE, WORD_LEN, 0 }, 
{ 0x0998, 0x1518, WORD_LEN, 0 }, 
{ 0x099A, 0xCE0C, WORD_LEN, 0 }, 
{ 0x099C, 0xC1CC, WORD_LEN, 0 }, 
{ 0x099E, 0x0029, WORD_LEN, 0 }, 
{ 0x098A, 0x10A0, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xBDD7, WORD_LEN, 0 }, 
{ 0x0992, 0x00FE, WORD_LEN, 0 }, 
{ 0x0994, 0x0BF1, WORD_LEN, 0 }, 
{ 0x0996, 0xCC0C, WORD_LEN, 0 }, 
{ 0x0998, 0xC1ED, WORD_LEN, 0 }, 
{ 0x099A, 0x15CC, WORD_LEN, 0 }, 
{ 0x099C, 0x11A5, WORD_LEN, 0 }, 
{ 0x099E, 0xFD0B, WORD_LEN, 0 }, 
{ 0x098A, 0x10B0, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xFFCC, WORD_LEN, 0 }, 
{ 0x0992, 0x0CFB, WORD_LEN, 0 }, 
{ 0x0994, 0xFD0C, WORD_LEN, 0 }, 
{ 0x0996, 0x21CC, WORD_LEN, 0 }, 
{ 0x0998, 0x128F, WORD_LEN, 0 }, 
{ 0x099A, 0xFD0C, WORD_LEN, 0 }, 
{ 0x099C, 0x53CC, WORD_LEN, 0 }, 
{ 0x099E, 0x114E, WORD_LEN, 0 }, 
{ 0x098A, 0x10C0, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xFD0C, WORD_LEN, 0 }, 
{ 0x0992, 0x5DCC, WORD_LEN, 0 }, 
{ 0x0994, 0x10E2, WORD_LEN, 0 }, 
{ 0x0996, 0xFD0C, WORD_LEN, 0 }, 
{ 0x0998, 0x6FCC, WORD_LEN, 0 }, 
{ 0x099A, 0x0EDD, WORD_LEN, 0 }, 
{ 0x099C, 0xFD0C, WORD_LEN, 0 }, 
{ 0x099E, 0xD7CC, WORD_LEN, 0 }, 
{ 0x098A, 0x10D0, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x0EBA, WORD_LEN, 0 }, 
{ 0x0992, 0xFD0C, WORD_LEN, 0 }, 
{ 0x0994, 0xE9CC, WORD_LEN, 0 }, 
{ 0x0996, 0x1350, WORD_LEN, 0 }, 
{ 0x0998, 0xFD0C, WORD_LEN, 0 }, 
{ 0x099A, 0x9BCC, WORD_LEN, 0 }, 
{ 0x099C, 0x0E29, WORD_LEN, 0 }, 
{ 0x099E, 0xFD0C, WORD_LEN, 0 }, 
{ 0x098A, 0x10E0, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xBF39, WORD_LEN, 0 }, 
{ 0x0992, 0x373C, WORD_LEN, 0 }, 
{ 0x0994, 0x3CDE, WORD_LEN, 0 }, 
{ 0x0996, 0x1DEC, WORD_LEN, 0 }, 
{ 0x0998, 0x0C5F, WORD_LEN, 0 }, 
{ 0x099A, 0x8402, WORD_LEN, 0 }, 
{ 0x099C, 0x4416, WORD_LEN, 0 }, 
{ 0x099E, 0x4FF7, WORD_LEN, 0 }, 
{ 0x098A, 0x10F0, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x0CEB, WORD_LEN, 0 }, 
{ 0x0992, 0xE60B, WORD_LEN, 0 }, 
{ 0x0994, 0xC407, WORD_LEN, 0 }, 
{ 0x0996, 0xF70C, WORD_LEN, 0 }, 
{ 0x0998, 0xEC7F, WORD_LEN, 0 }, 
{ 0x099A, 0x30C4, WORD_LEN, 0 }, 
{ 0x099C, 0xEC25, WORD_LEN, 0 }, 
{ 0x099E, 0xFD30, WORD_LEN, 0 }, 
{ 0x098A, 0x1100, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xC5FC, WORD_LEN, 0 }, 
{ 0x0992, 0x06D6, WORD_LEN, 0 }, 
{ 0x0994, 0xFD30, WORD_LEN, 0 }, 
{ 0x0996, 0xC701, WORD_LEN, 0 }, 
{ 0x0998, 0xFC30, WORD_LEN, 0 }, 
{ 0x099A, 0xC0FD, WORD_LEN, 0 }, 
{ 0x099C, 0x0BED, WORD_LEN, 0 }, 
{ 0x099E, 0xFC30, WORD_LEN, 0 }, 
{ 0x098A, 0x1110, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xC2FD, WORD_LEN, 0 }, 
{ 0x0992, 0x0BEF, WORD_LEN, 0 }, 
{ 0x0994, 0xFC04, WORD_LEN, 0 }, 
{ 0x0996, 0xC283, WORD_LEN, 0 }, 
{ 0x0998, 0xFFFF, WORD_LEN, 0 }, 
{ 0x099A, 0x2728, WORD_LEN, 0 }, 
{ 0x099C, 0xDE06, WORD_LEN, 0 }, 
{ 0x099E, 0xEC22, WORD_LEN, 0 }, 
{ 0x098A, 0x1120, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x8322, WORD_LEN, 0 }, 
{ 0x0992, 0x0026, WORD_LEN, 0 }, 
{ 0x0994, 0x1FCC, WORD_LEN, 0 }, 
{ 0x0996, 0x3064, WORD_LEN, 0 }, 
{ 0x0998, 0x30ED, WORD_LEN, 0 }, 
{ 0x099A, 0x008F, WORD_LEN, 0 }, 
{ 0x099C, 0xC300, WORD_LEN, 0 }, 
{ 0x099E, 0x02DE, WORD_LEN, 0 }, 
{ 0x098A, 0x1130, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x0CAD, WORD_LEN, 0 }, 
{ 0x0992, 0x0030, WORD_LEN, 0 }, 
{ 0x0994, 0x1D02, WORD_LEN, 0 },
{ 0x0996, 0x01CC, WORD_LEN, 0 }, 
{ 0x0998, 0x3064, WORD_LEN, 0 },
{ 0x099A, 0xED00, WORD_LEN, 0 }, 
{ 0x099C, 0x8FC3, WORD_LEN, 0 }, 
{ 0x099E, 0x0002, WORD_LEN, 0 }, 
{ 0x098A, 0x1140, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xDE0E, WORD_LEN, 0 }, 
{ 0x0992, 0xAD00, WORD_LEN, 0 }, 
{ 0x0994, 0x30E6, WORD_LEN, 0 }, 
{ 0x0996, 0x04BD, WORD_LEN, 0 }, 
{ 0x0998, 0x5203, WORD_LEN, 0 }, 
{ 0x099A, 0x3838, WORD_LEN, 0 }, 
{ 0x099C, 0x3139, WORD_LEN, 0 }, 
{ 0x099E, 0x3C3C, WORD_LEN, 0 }, 
{ 0x098A, 0x1150, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x3C21, WORD_LEN, 0 }, 
{ 0x0992, 0x01CC, WORD_LEN, 0 }, 
{ 0x0994, 0x0018, WORD_LEN, 0 }, 
{ 0x0996, 0xBD6F, WORD_LEN, 0 }, 
{ 0x0998, 0xD1C5, WORD_LEN, 0 }, 
{ 0x099A, 0x0426, WORD_LEN, 0 }, 
{ 0x099C, 0xF5DC, WORD_LEN, 0 }, 
{ 0x099E, 0x2530, WORD_LEN, 0 }, 
{ 0x098A, 0x1160, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xED04, WORD_LEN, 0 }, 
{ 0x0992, 0x2012, WORD_LEN, 0 }, 
{ 0x0994, 0xEE04, WORD_LEN, 0 }, 
{ 0x0996, 0x3C18, WORD_LEN, 0 }, 
{ 0x0998, 0x38E6, WORD_LEN, 0 }, 
{ 0x099A, 0x2118, WORD_LEN, 0 }, 
{ 0x099C, 0xE7BE, WORD_LEN, 0 }, 
{ 0x099E, 0x30EE, WORD_LEN, 0 }, 
{ 0x098A, 0x1170, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x04EC, WORD_LEN, 0 }, 
{ 0x0992, 0x1D30, WORD_LEN, 0 }, 
{ 0x0994, 0xED04, WORD_LEN, 0 }, 
{ 0x0996, 0xEC04, WORD_LEN, 0 }, 
{ 0x0998, 0x26EA, WORD_LEN, 0 }, 
{ 0x099A, 0xCC00, WORD_LEN, 0 }, 
{ 0x099C, 0x1AED, WORD_LEN, 0 }, 
{ 0x099E, 0x02CC, WORD_LEN, 0 }, 
{ 0x098A, 0x1180, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xFBFF, WORD_LEN, 0 }, 
{ 0x0992, 0xED00, WORD_LEN, 0 }, 
{ 0x0994, 0xCC04, WORD_LEN, 0 }, 
{ 0x0996, 0x00BD, WORD_LEN, 0 }, 
{ 0x0998, 0x706D, WORD_LEN, 0 }, 
{ 0x099A, 0xCC00, WORD_LEN, 0 }, 
{ 0x099C, 0x1A30, WORD_LEN, 0 }, 
{ 0x099E, 0xED02, WORD_LEN, 0 }, 
{ 0x098A, 0x1190, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xCCFB, WORD_LEN, 0 }, 
{ 0x0992, 0xFFED, WORD_LEN, 0 }, 
{ 0x0994, 0x005F, WORD_LEN, 0 }, 
{ 0x0996, 0x4FBD, WORD_LEN, 0 }, 
{ 0x0998, 0x706D, WORD_LEN, 0 }, 
{ 0x099A, 0x5FBD, WORD_LEN, 0 }, 
{ 0x099C, 0x5B17, WORD_LEN, 0 }, 
{ 0x099E, 0xBD55, WORD_LEN, 0 }, 
{ 0x098A, 0x11A0, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x8B38, WORD_LEN, 0 }, 
{ 0x0992, 0x3838, WORD_LEN, 0 }, 
{ 0x0994, 0x393C, WORD_LEN, 0 }, 
{ 0x0996, 0x3CC6, WORD_LEN, 0 }, 
{ 0x0998, 0x40F7, WORD_LEN, 0 }, 
{ 0x099A, 0x30C4, WORD_LEN, 0 }, 
{ 0x099C, 0xFC0B, WORD_LEN, 0 }, 
{ 0x099E, 0xEDFD, WORD_LEN, 0 }, 
{ 0x098A, 0x11B0, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x30C0, WORD_LEN, 0 }, 
{ 0x0992, 0xFC0B, WORD_LEN, 0 }, 
{ 0x0994, 0xEFFD, WORD_LEN, 0 }, 
{ 0x0996, 0x30C2, WORD_LEN, 0 }, 
{ 0x0998, 0xDE1D, WORD_LEN, 0 }, 
{ 0x099A, 0xEC25, WORD_LEN, 0 }, 
{ 0x099C, 0xFD30, WORD_LEN, 0 }, 
{ 0x099E, 0xC501, WORD_LEN, 0 }, 
{ 0x098A, 0x11C0, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x0101, WORD_LEN, 0 }, 
{ 0x0992, 0xFC30, WORD_LEN, 0 }, 
{ 0x0994, 0xC2FD, WORD_LEN, 0 }, 
{ 0x0996, 0x06D6, WORD_LEN, 0 }, 
{ 0x0998, 0xEC0C, WORD_LEN, 0 }, 
{ 0x099A, 0x5F84, WORD_LEN, 0 }, 
{ 0x099C, 0x0244, WORD_LEN, 0 }, 
{ 0x099E, 0x164F, WORD_LEN, 0 }, 
{ 0x098A, 0x11D0, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x30E7, WORD_LEN, 0 }, 
{ 0x0992, 0x03F1, WORD_LEN, 0 }, 
{ 0x0994, 0x0CEB, WORD_LEN, 0 }, 
{ 0x0996, 0x2715, WORD_LEN, 0 }, 
{ 0x0998, 0xF10C, WORD_LEN, 0 }, 
{ 0x099A, 0xEB23, WORD_LEN, 0 }, 
{ 0x099C, 0x09FC, WORD_LEN, 0 }, 
{ 0x099E, 0x06D6, WORD_LEN, 0 }, 
{ 0x098A, 0x11E0, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x04FD, WORD_LEN, 0 }, 
{ 0x0992, 0x06D6, WORD_LEN, 0 }, 
{ 0x0994, 0x2007, WORD_LEN, 0 }, 
{ 0x0996, 0xFC06, WORD_LEN, 0 }, 
{ 0x0998, 0xD605, WORD_LEN, 0 },
{ 0x099A, 0xFD06, WORD_LEN, 0 }, 
{ 0x099C, 0xD6DE, WORD_LEN, 0 }, 
{ 0x099E, 0x1DE6, WORD_LEN, 0 }, 
{ 0x098A, 0x11F0, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x0BC4, WORD_LEN, 0 }, 
{ 0x0992, 0x0730, WORD_LEN, 0 }, 
{ 0x0994, 0xE702, WORD_LEN, 0 }, 
{ 0x0996, 0xF10C, WORD_LEN, 0 }, 
{ 0x0998, 0xEC27, WORD_LEN, 0 }, 
{ 0x099A, 0x2C7D, WORD_LEN, 0 }, 
{ 0x099C, 0x0CEC, WORD_LEN, 0 }, 
{ 0x099E, 0x2727, WORD_LEN, 0 }, 
{ 0x098A, 0x1200, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x5D27, WORD_LEN, 0 }, 
{ 0x0992, 0x247F, WORD_LEN, 0 }, 
{ 0x0994, 0x30C4, WORD_LEN, 0 }, 
{ 0x0996, 0xFC06, WORD_LEN, 0 }, 
{ 0x0998, 0xD6FD, WORD_LEN, 0 }, 
{ 0x099A, 0x30C5, WORD_LEN, 0 }, 
{ 0x099C, 0xF60C, WORD_LEN, 0 }, 
{ 0x099E, 0xEC4F, WORD_LEN, 0 }, 
{ 0x098A, 0x1210, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xFD30, WORD_LEN, 0 }, 
{ 0x0992, 0xC7C6, WORD_LEN, 0 }, 
{ 0x0994, 0x40F7, WORD_LEN, 0 }, 
{ 0x0996, 0x30C4, WORD_LEN, 0 }, 
{ 0x0998, 0xE602, WORD_LEN, 0 }, 
{ 0x099A, 0x4FFD, WORD_LEN, 0 }, 
{ 0x099C, 0x30C5, WORD_LEN, 0 }, 
{ 0x099E, 0x0101, WORD_LEN, 0 }, 
{ 0x098A, 0x1220, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x01FC, WORD_LEN, 0 }, 
{ 0x0992, 0x30C2, WORD_LEN, 0 }, 
{ 0x0994, 0xFD06, WORD_LEN, 0 }, 
{ 0x0996, 0xD67D, WORD_LEN, 0 }, 
{ 0x0998, 0x06CB, WORD_LEN, 0 }, 
{ 0x099A, 0x272E, WORD_LEN, 0 }, 
{ 0x099C, 0xC640, WORD_LEN, 0 }, 
{ 0x099E, 0xF730, WORD_LEN, 0 }, 
{ 0x098A, 0x1230, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xC4FC, WORD_LEN, 0 }, 
{ 0x0992, 0x06C1, WORD_LEN, 0 }, 
{ 0x0994, 0x04F3, WORD_LEN, 0 }, 
{ 0x0996, 0x06D6, WORD_LEN, 0 }, 
{ 0x0998, 0xED00, WORD_LEN, 0 }, 
{ 0x099A, 0x5F6D, WORD_LEN, 0 }, 
{ 0x099C, 0x002A, WORD_LEN, 0 }, 
{ 0x099E, 0x0153, WORD_LEN, 0 }, 
{ 0x098A, 0x1240, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x17FD, WORD_LEN, 0 }, 
{ 0x0992, 0x30C0, WORD_LEN, 0 }, 
{ 0x0994, 0xEC00, WORD_LEN, 0 }, 
{ 0x0996, 0xFD30, WORD_LEN, 0 }, 
{ 0x0998, 0xC2FC, WORD_LEN, 0 }, 
{ 0x099A, 0x06C1, WORD_LEN, 0 }, 
{ 0x099C, 0xFD30, WORD_LEN, 0 }, 
{ 0x099E, 0xC501, WORD_LEN, 0 }, 
{ 0x098A, 0x1250, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x0101, WORD_LEN, 0 }, 
{ 0x0992, 0xFC30, WORD_LEN, 0 }, 
{ 0x0994, 0xC2FD, WORD_LEN, 0 }, 
{ 0x0996, 0x06C7, WORD_LEN, 0 }, 
{ 0x0998, 0x2022, WORD_LEN, 0 }, 
{ 0x099A, 0x7F30, WORD_LEN, 0 }, 
{ 0x099C, 0xC4DE, WORD_LEN, 0 }, 
{ 0x099E, 0x1DEC, WORD_LEN, 0 }, 
{ 0x098A, 0x1260, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x25FD, WORD_LEN, 0 }, 
{ 0x0992, 0x30C5, WORD_LEN, 0 }, 
{ 0x0994, 0xFC06, WORD_LEN, 0 }, 
{ 0x0996, 0xD6FD, WORD_LEN, 0 }, 
{ 0x0998, 0x30C7, WORD_LEN, 0 }, 
{ 0x099A, 0x01FC, WORD_LEN, 0 }, 
{ 0x099C, 0x30C0, WORD_LEN, 0 }, 
{ 0x099E, 0xFD06, WORD_LEN, 0 }, 
{ 0x098A, 0x1270, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xD0FC, WORD_LEN, 0 }, 
{ 0x0992, 0x30C2, WORD_LEN, 0 }, 
{ 0x0994, 0xFD06, WORD_LEN, 0 }, 
{ 0x0996, 0xD2EC, WORD_LEN, 0 }, 
{ 0x0998, 0x25FD, WORD_LEN, 0 }, 
{ 0x099A, 0x06C3, WORD_LEN, 0 }, 
{ 0x099C, 0xBD95, WORD_LEN, 0 }, 
{ 0x099E, 0x3CDE, WORD_LEN, 0 }, 
{ 0x098A, 0x1280, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x3FEE, WORD_LEN, 0 }, 
{ 0x0992, 0x10AD, WORD_LEN, 0 }, 
{ 0x0994, 0x00DE, WORD_LEN, 0 }, 
{ 0x0996, 0x1DFC, WORD_LEN, 0 }, 
{ 0x0998, 0x06CC, WORD_LEN, 0 }, 
{ 0x099A, 0xED3E, WORD_LEN, 0 }, 
{ 0x099C, 0x3838, WORD_LEN, 0 }, 
{ 0x099E, 0x3930, WORD_LEN, 0 }, 
{ 0x098A, 0x1290, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x8FC3, WORD_LEN, 0 }, 
{ 0x0992, 0xFFEC, WORD_LEN, 0 }, 
{ 0x0994, 0x8F35, WORD_LEN, 0 }, 
{ 0x0996, 0xBDAD, WORD_LEN, 0 }, 
{ 0x0998, 0x15DE, WORD_LEN, 0 }, 
{ 0x099A, 0x198F, WORD_LEN, 0 }, 
{ 0x099C, 0xC301, WORD_LEN, 0 }, 
{ 0x099E, 0x4B8F, WORD_LEN, 0 }, 
{ 0x098A, 0x12A0, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xEC00, WORD_LEN, 0 }, 
{ 0x0992, 0xFD05, WORD_LEN, 0 }, 
{ 0x0994, 0x0EEC, WORD_LEN, 0 }, 
{ 0x0996, 0x02FD, WORD_LEN, 0 }, 
{ 0x0998, 0x0510, WORD_LEN, 0 }, 
{ 0x099A, 0x8FC3, WORD_LEN, 0 }, 
{ 0x099C, 0xFFCB, WORD_LEN, 0 }, 
{ 0x099E, 0x8FE6, WORD_LEN, 0 }, 
{ 0x098A, 0x12B0, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x00F7, WORD_LEN, 0 }, 
{ 0x0992, 0x0514, WORD_LEN, 0 }, 
{ 0x0994, 0xE603, WORD_LEN, 0 }, 
{ 0x0996, 0xF705, WORD_LEN, 0 }, 
{ 0x0998, 0x15FC, WORD_LEN, 0 }, 
{ 0x099A, 0x055B, WORD_LEN, 0 }, 
{ 0x099C, 0xFD05, WORD_LEN, 0 }, 
{ 0x099E, 0x12DE, WORD_LEN, 0 }, 
{ 0x098A, 0x12C0, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x37EE, WORD_LEN, 0 }, 
{ 0x0992, 0x08AD, WORD_LEN, 0 }, 
{ 0x0994, 0x00F6, WORD_LEN, 0 }, 
{ 0x0996, 0x0516, WORD_LEN, 0 }, 
{ 0x0998, 0x4F30, WORD_LEN, 0 }, 
{ 0x099A, 0xED04, WORD_LEN, 0 }, 
{ 0x099C, 0xDE1F, WORD_LEN, 0 }, 
{ 0x099E, 0xEC6B, WORD_LEN, 0 }, 
{ 0x098A, 0x12D0, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xFD05, WORD_LEN, 0 }, 
{ 0x0992, 0x0EEC, WORD_LEN, 0 }, 
{ 0x0994, 0x6DFD, WORD_LEN, 0 }, 
{ 0x0996, 0x0510, WORD_LEN, 0 }, 
{ 0x0998, 0xDE19, WORD_LEN, 0 }, 
{ 0x099A, 0x8FC3, WORD_LEN, 0 }, 
{ 0x099C, 0x0117, WORD_LEN, 0 }, 
{ 0x099E, 0x8FE6, WORD_LEN, 0 }, 
{ 0x098A, 0x12E0, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x00F7, WORD_LEN, 0 }, 
{ 0x0992, 0x0514, WORD_LEN, 0 }, 
{ 0x0994, 0xE603, WORD_LEN, 0 }, 
{ 0x0996, 0xF705, WORD_LEN, 0 }, 
{ 0x0998, 0x15FC, WORD_LEN, 0 }, 
{ 0x099A, 0x0559, WORD_LEN, 0 }, 
{ 0x099C, 0xFD05, WORD_LEN, 0 }, 
{ 0x099E, 0x12DE, WORD_LEN, 0 }, 
{ 0x098A, 0x12F0, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x37EE, WORD_LEN, 0 }, 
{ 0x0992, 0x08AD, WORD_LEN, 0 }, 
{ 0x0994, 0x00F6, WORD_LEN, 0 }, 
{ 0x0996, 0x0516, WORD_LEN, 0 }, 
{ 0x0998, 0x4F30, WORD_LEN, 0 }, 
{ 0x099A, 0xED06, WORD_LEN, 0 }, 
{ 0x099C, 0xDE1F, WORD_LEN, 0 }, 
{ 0x099E, 0xEC6B, WORD_LEN, 0 }, 
{ 0x098A, 0x1300, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xFD05, WORD_LEN, 0 }, 
{ 0x0992, 0x0EEC, WORD_LEN, 0 }, 
{ 0x0994, 0x6DFD, WORD_LEN, 0 }, 
{ 0x0996, 0x0510, WORD_LEN, 0 }, 
{ 0x0998, 0xDE19, WORD_LEN, 0 }, 
{ 0x099A, 0x8FC3, WORD_LEN, 0 }, 
{ 0x099C, 0x0118, WORD_LEN, 0 }, 
{ 0x099E, 0x8FE6, WORD_LEN, 0 }, 
{ 0x098A, 0x1310, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x00F7, WORD_LEN, 0 }, 
{ 0x0992, 0x0514, WORD_LEN, 0 }, 
{ 0x0994, 0xE603, WORD_LEN, 0 }, 
{ 0x0996, 0xF705, WORD_LEN, 0 }, 
{ 0x0998, 0x15FC, WORD_LEN, 0 }, 
{ 0x099A, 0x0559, WORD_LEN, 0 }, 
{ 0x099C, 0xFD05, WORD_LEN, 0 }, 
{ 0x099E, 0x12DE, WORD_LEN, 0 }, 
{ 0x098A, 0x1320, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x37EE, WORD_LEN, 0 }, 
{ 0x0992, 0x08AD, WORD_LEN, 0 }, 
{ 0x0994, 0x00F6, WORD_LEN, 0 }, 
{ 0x0996, 0x0516, WORD_LEN, 0 }, 
{ 0x0998, 0x4F30, WORD_LEN, 0 }, 
{ 0x099A, 0xED08, WORD_LEN, 0 }, 
{ 0x099C, 0xCC32, WORD_LEN, 0 }, 
{ 0x099E, 0x8EED, WORD_LEN, 0 }, 
{ 0x098A, 0x1330, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x00EC, WORD_LEN, 0 }, 
{ 0x0992, 0x04BD, WORD_LEN, 0 }, 
{ 0x0994, 0x7021, WORD_LEN, 0 }, 
{ 0x0996, 0xCC32, WORD_LEN, 0 }, 
{ 0x0998, 0x6C30, WORD_LEN, 0 }, 
{ 0x099A, 0xED02, WORD_LEN, 0 }, 
{ 0x099C, 0xCCF8, WORD_LEN, 0 }, 
{ 0x099E, 0x00ED, WORD_LEN, 0 }, 
{ 0x098A, 0x1340, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x00A6, WORD_LEN, 0 }, 
{ 0x0992, 0x07E3, WORD_LEN, 0 }, 
{ 0x0994, 0x0884, WORD_LEN, 0 }, 
{ 0x0996, 0x07BD, WORD_LEN, 0 }, 
{ 0x0998, 0x706D, WORD_LEN, 0 }, 
{ 0x099A, 0x30C6, WORD_LEN, 0 }, 
{ 0x099C, 0x143A, WORD_LEN, 0 }, 
{ 0x099E, 0x3539, WORD_LEN, 0 }, 
{ 0x098A, 0x1350, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x3CBD, WORD_LEN, 0 }, 
{ 0x0992, 0x776D, WORD_LEN, 0 }, 
{ 0x0994, 0xCC32, WORD_LEN, 0 }, 
{ 0x0996, 0x5C30, WORD_LEN, 0 }, 
{ 0x0998, 0xED00, WORD_LEN, 0 }, 
{ 0x099A, 0xFC13, WORD_LEN, 0 }, 
{ 0x099C, 0x8683, WORD_LEN, 0 }, 
{ 0x099E, 0x0001, WORD_LEN, 0 }, 
{ 0x098A, 0x1360, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0xBD70, WORD_LEN, 0 }, 
{ 0x0992, 0x21CC, WORD_LEN, 0 }, 
{ 0x0994, 0x325E, WORD_LEN, 0 }, 
{ 0x0996, 0x30ED, WORD_LEN, 0 }, 
{ 0x0998, 0x00FC, WORD_LEN, 0 }, 
{ 0x099A, 0x1388, WORD_LEN, 0 }, 
{ 0x099C, 0x8300, WORD_LEN, 0 }, 
{ 0x099E, 0x01BD, WORD_LEN, 0 }, 
{ 0x098A, 0x1370, WORD_LEN, 0 }, 	// PHYSICAL_ADDR_ACCESS
{ 0x0990, 0x7021, WORD_LEN, 0 }, 
{ 0x0992, 0x3839, WORD_LEN, 0 }, 
{ 0x098E, 0x0010, WORD_LEN, 0 }, 	// MCU_ADDRESS [MON_ADDR]
{ 0x0990, 0x1000, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x0003, WORD_LEN, 0 }, 	// MCU_ADDRESS [MON_ALGO]
{ 0x0990, 0x0004, WORD_LEN, 0 }, 	// MCU_DATA_0
	
{ SEQUENCE_WAIT_MS,50, WORD_LEN, 0},

{ 0x098E, 0x4815, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0004, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x098E, 0x485D, WORD_LEN, 0 }, 	// MCU_ADDRESS
{ 0x0990, 0x0004, WORD_LEN, 0 }, 	// MCU_DATA_0
{ 0x0018, 0x0028, WORD_LEN, 0 }, 	// STANDBY_CONTROL_AND_STATUS

{ SEQUENCE_WAIT_MS,10, WORD_LEN, 0},

//awb	
{ 0x098E, 0xAC02, WORD_LEN, 0 },     // MCU_ADDRESS [AWB_MODE]                     
{ 0x0990, 0x000A, WORD_LEN, 0 },      // MCU_DATA_0                             
{ 0x098E, 0x2C03, WORD_LEN, 0 },      // MCU_ADDRESS                            
{ 0x0990, 0x01ff, WORD_LEN, 0 },      // MCU_DATA_0                             
{ 0x098E, 0x683F, WORD_LEN, 0 },      // MCU_ADDRESS [PRI_A_CONFIG_AWB_ALGO_RUN]
{ 0x0990, 0x01fF, WORD_LEN, 0 },      // MCU_DATA_0                             
{ 0x098E, 0x8400, WORD_LEN, 0 },      // MCU_ADDRESS [SEQ_CMD]                  
{ 0x0990, 0x0005, WORD_LEN, 0 },      // MCU_DATA_0    
    
{ SEQUENCE_WAIT_MS,10, WORD_LEN, 0},

//banding AUTO
{ 0x098E, 0x6811, WORD_LEN, 0 },             // MCU_ADDRESS [PRI_A_CONFIG_FD_ALGO_RUN]                         
{ 0x0990, 0x0003, WORD_LEN, 0 },             // MCU_DATA_0                            
{ 0x098E, 0x8400, WORD_LEN, 0 },             // MCU_ADDRESS [SEQ_CMD]                 
{ 0x0990, 0x0005, WORD_LEN, 0 },             // MCU_DATA_0   
	
{ SEQUENCE_WAIT_MS,10, WORD_LEN, 0},

//effect off
{ 0x098E, 0xE883, WORD_LEN, 0 }, 			 // MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SELECT_FX]    	
{ 0x0990, 0x0000, WORD_LEN, 0 }, 			 // MCU_DATA_0                                  	                         
{ 0x098E, 0xEC83, WORD_LEN, 0 }, 		 // MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SELECT_FX]
{ 0x0990, 0x0000, WORD_LEN, 0 }, 			 // MCU_DATA_0                                  
{ 0x098E, 0x8400, WORD_LEN, 0 }, 			 // MCU_ADDRESS [SEQ_CMD]                       
{ 0x0990, 0x0006, WORD_LEN, 0 }, 			 // MCU_DATA_0     

{ SEQUENCE_WAIT_MS,10, WORD_LEN, 0},

//contrast level=3
{ 0x098E, 0xBC0B, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_0]                              
{ 0x0990, 0x0000, WORD_LEN, 0 }, 	// MCU_DATA_0                              
{ 0x098E, 0xBC0C, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_1] 
{ 0x0990, 0x000A, WORD_LEN, 0 }, 	// MCU_DATA_0                              
{ 0x098E, 0xBC0D, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_2] 
{ 0x0990, 0x001B, WORD_LEN, 0 }, 	// MCU_DATA_0                              
{ 0x098E, 0xBC0E, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_3] 
{ 0x0990, 0x0031, WORD_LEN, 0 }, 	// MCU_DATA_0                              
{ 0x098E, 0xBC0F, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_4] 
{ 0x0990, 0x0052, WORD_LEN, 0 }, 	// MCU_DATA_0                              
{ 0x098E, 0xBC10, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_5] 
{ 0x0990, 0x006E, WORD_LEN, 0 }, 	// MCU_DATA_0                              
{ 0x098E, 0xBC11, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_6] 
{ 0x0990, 0x0089, WORD_LEN, 0 }, 	// MCU_DATA_0                              
{ 0x098E, 0xBC12, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_7] 
{ 0x0990, 0x009F, WORD_LEN, 0 }, 	// MCU_DATA_0                              
{ 0x098E, 0xBC13, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_8] 
{ 0x0990, 0x00B0, WORD_LEN, 0 }, 	// MCU_DATA_0                              
{ 0x098E, 0xBC14, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_9] 
{ 0x0990, 0x00BD, WORD_LEN, 0 }, 	// MCU_DATA_0                              
{ 0x098E, 0xBC15, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_10]
{ 0x0990, 0x00C9, WORD_LEN, 0 }, 	// MCU_DATA_0                              
{ 0x098E, 0xBC16, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_11]
{ 0x0990, 0x00D3, WORD_LEN, 0 }, 	// MCU_DATA_0                              
{ 0x098E, 0xBC17, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_12]
{ 0x0990, 0x00DC, WORD_LEN, 0 }, 	// MCU_DATA_0                              
{ 0x098E, 0xBC18, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_13]
{ 0x0990, 0x00E3, WORD_LEN, 0 }, 	// MCU_DATA_0                              
{ 0x098E, 0xBC19, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_14]
{ 0x0990, 0x00EA, WORD_LEN, 0 }, 	// MCU_DATA_0                              
{ 0x098E, 0xBC1A, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_15]
{ 0x0990, 0x00F0, WORD_LEN, 0 }, 	// MCU_DATA_0                              
{ 0x098E, 0xBC1B, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_16]
{ 0x0990, 0x00F5, WORD_LEN, 0 }, 	// MCU_DATA_0                              
{ 0x098E, 0xBC1C, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_17]
{ 0x0990, 0x00FA, WORD_LEN, 0 }, 	// MCU_DATA_0                              
{ 0x098E, 0xBC1D, WORD_LEN, 0 }, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_18]
{ 0x0990, 0x00FF, WORD_LEN, 0 }, 	// MCU_DATA_0 
{ 0x098E, 0x8400, WORD_LEN, 0 }, 	// MCU_ADDRESS [SEQ_CMD]                   
{ 0x0990, 0x0006, WORD_LEN, 0 }, 	// MCU_DATA_0

{ SEQUENCE_WAIT_MS,200, WORD_LEN, 0},
                             
{ 0x098E, 0x8400, WORD_LEN, 0 }, 	// MCU_ADDRESS [SEQ_CMD]                   
{ 0x0990, 0x0005, WORD_LEN, 0 }, 	// MCU_DATA_0  
     
#else
{0x001A, 0x0219, WORD_LEN, 0 },  	// RESET_AND_MISC_CONTROL
{0x001A, 0x0018, WORD_LEN, 0 },  	// RESET_AND_MISC_CONTROL
{0x0014, 0x2425, WORD_LEN, 0 },  	// PLL_CONTROL
{0x0014, 0x2425, WORD_LEN, 0 },  	// PLL_CONTROL
{0x0014, 0x2145, WORD_LEN, 0 },  	// PLL_CONTROL

{0x0010, 0x0110, WORD_LEN, 0 },  	// PLL_DIVIDERS//31E
{0x0012, 0x0070, WORD_LEN, 0 },  	// PLL_P_DIVIDERS//E0
{0x002A, 0x77BB, WORD_LEN, 0 },  	// PLL_P4_P5_P6_DIVIDERS//7EFF
{0x001A, 0x0218, WORD_LEN, 0 },  	// RESET_AND_MISC_CONTROL

{0x0014, 0x2545, WORD_LEN, 0 },  	// PLL_CONTROL
{0x0014, 0x2547, WORD_LEN, 0 },  	// PLL_CONTROL
{0x0014, 0x2447, WORD_LEN, 0 },  	// PLL_CONTROL
{0x0014, 0x2047, WORD_LEN, 0 },  	// PLL_CONTROL

{SEQUENCE_WAIT_MS,50, WORD_LEN, 0},
//  POLL  PLL_CONTROL::PLL_LOCK =>  0x01
{0x0014, 0x2046, WORD_LEN, 0 },  	// PLL_CONTROL
{0x0022, 0x01E0, WORD_LEN, 0 },  	// VDD_DIS_COUNTER//208
{0x001E, 0x0777, WORD_LEN, 0 },  	// PAD_SLEW_PAD_CONFIG
//{0x001E, 0x0700, WORD_LEN, 0 },  	// PAD_SLEW_PAD_CONFIG
{0x0016, 0x0400, WORD_LEN, 0 },  	// CLOCKS_CONTROL
{0x001E, 0x0777, WORD_LEN, 0 },  	// PAD_SLEW_PAD_CONFIG
//{0x001E, 0x0700, WORD_LEN, 0 },  	// PAD_SLEW_PAD_CONFIG
{0x0018, 0x402D, WORD_LEN, 0 },  	// STANDBY_CONTROL_AND_STATUS
{0x0018, 0x402C, WORD_LEN, 0 },  	// STANDBY_CONTROL_AND_STATUS

{0x001e,0x0006, WORD_LEN, 0 },	//adjust slew rate to minimize EMI
{SEQUENCE_WAIT_MS,100, WORD_LEN, 0},

//  POLL  STANDBY_CONTROL_AND_STATUS::STANDBY_DONE =>  0x00
//{0x098E, 0x6006, WORD_LEN, 0 },  	// MCU_ADDRESS
//{0x0990, 0x007A, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x6800, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0320, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x6802, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0258, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xE88E, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0000, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x68A0, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x082D, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4802, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0000, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4804, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0000, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4806, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x060D, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4808, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x080D, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x480A, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0111, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x480C, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x046C, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x480F, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x00CC, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4811, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0381, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4813, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x024F, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x481D, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x03BE, WORD_LEN, 0 },  	// MCU_DATA_0//35C
{0x098E, 0x481F, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x05D0, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4825, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x07AC, WORD_LEN, 0 },  	// MCU_DATA_0//85E
//{0x098E, 0x482B, WORD_LEN, 0 },  	// MCU_ADDRESS//
//{0x0990, 0x0408, WORD_LEN, 0 },  	// MCU_DATA_0//
//{0x098E, 0x482D, WORD_LEN, 0 },  	// MCU_ADDRESS//
//{0x0990, 0x0308, WORD_LEN, 0 },  	// MCU_DATA_0//
/*300w capture*/
{0x098E, 0x6C00, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0800, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x6C02, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0600, WORD_LEN, 0 },  	// MCU_DATA_0

{0x098E, 0xEC8E, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0000, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x6CA0, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x082D, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x484A, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0004, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x484C, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0004, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x484E, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x060B, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4850, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x080B, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4852, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0111, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4854, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0024, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4857, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x008C, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4859, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x01F1, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x485B, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x00FF, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4865, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x067C, WORD_LEN, 0 },  	// MCU_DATA_0//687
{0x098E, 0x4867, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0378, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x486D, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0BAC, WORD_LEN, 0 },  	// MCU_DATA_0//103B
{0x098E, 0x4873, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0808, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4875, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0608, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC8A5, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0021, WORD_LEN, 0 },  	// MCU_DATA_0//001E
{0x098E, 0xC8A6, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0023, WORD_LEN, 0 },  	// MCU_DATA_0//0020
{0x098E, 0xC8A7, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0027, WORD_LEN, 0 },  	// MCU_DATA_0//25
{0x098E, 0xC8A8, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0029, WORD_LEN, 0 },  	// MCU_DATA_0//27
{0x098E, 0xC844, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x00A3, WORD_LEN, 0 },  	// MCU_DATA_0//72
{0x098E, 0xC92F, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0000, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC845, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0088, WORD_LEN, 0 },  	// MCU_DATA_0//5F
{0x098E, 0xC92D, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0000, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC88C, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x006B, WORD_LEN, 0 },  	// MCU_DATA_0//3B
{0x098E, 0xC930, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0000, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC88D, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0059, WORD_LEN, 0 },  	// MCU_DATA_0//31
{0x098E, 0xC92E, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0000, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xB825, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0004, WORD_LEN, 0 },  	// MCU_DATA_0//0003
{0x098E, 0xA009, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0002, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xA00A, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0003, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xA00C, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x000A, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4846, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x68AA, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x021E, WORD_LEN, 0 },  	// MCU_DATA_0//24C
{0x098E, 0x6815, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0006, WORD_LEN, 0 },  	// MCU_DATA_0//0008
{0x098E, 0x6817, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0007, WORD_LEN, 0 },  	// MCU_DATA_0//0009
{0x098E, 0x682D, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0006, WORD_LEN, 0 },  	// MCU_DATA_0//0008
{0x098E, 0x488E, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x6CAA, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x016E, WORD_LEN, 0 },  	// MCU_DATA_0//0058
{0x098E, 0x8400, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0006, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x8400, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0005, WORD_LEN, 0 },  	// MCU_DATA_0
{0x3C20, 0x0000, WORD_LEN, 0 },  	// TX_SS_CONTROL
/*
{0x364A, 0x7D2F, WORD_LEN, 0 },  	// P_R_P0Q0
{0x364C, 0x79EB, WORD_LEN, 0 },  	// P_R_P0Q1
{0x364E, 0x18D2, WORD_LEN, 0 },  	// P_R_P0Q2
{0x3650, 0x9F8F, WORD_LEN, 0 },  	// P_R_P0Q3
{0x3652, 0xA7D2, WORD_LEN, 0 },  	// P_R_P0Q4
{0x368A, 0x460C, WORD_LEN, 0 },  	// P_R_P1Q0
{0x368C, 0x14F0, WORD_LEN, 0 },  	// P_R_P1Q1
{0x368E, 0x946F, WORD_LEN, 0 },  	// P_R_P1Q2
{0x3690, 0xC471, WORD_LEN, 0 },  	// P_R_P1Q3
{0x3692, 0x04B1, WORD_LEN, 0 },  	// P_R_P1Q4
{0x36CA, 0x0433, WORD_LEN, 0 },  	// P_R_P2Q0
{0x36CC, 0x680D, WORD_LEN, 0 },  	// P_R_P2Q1
{0x36CE, 0xEEF3, WORD_LEN, 0 },  	// P_R_P2Q2
{0x36D0, 0x4850, WORD_LEN, 0 },  	// P_R_P2Q3
{0x36D2, 0xF233, WORD_LEN, 0 },  	// P_R_P2Q4
{0x370A, 0xB2AF, WORD_LEN, 0 },  	// P_R_P3Q0
{0x370C, 0x2CF0, WORD_LEN, 0 },  	// P_R_P3Q1
{0x370E, 0x3F10, WORD_LEN, 0 },  	// P_R_P3Q2
{0x3710, 0xC673, WORD_LEN, 0 },  	// P_R_P3Q3
{0x3712, 0xA972, WORD_LEN, 0 },  	// P_R_P3Q4
{0x374A, 0x0590, WORD_LEN, 0 },  	// P_R_P4Q0
{0x374C, 0xAFB3, WORD_LEN, 0 },  	// P_R_P4Q1
{0x374E, 0x93D7, WORD_LEN, 0 },  	// P_R_P4Q2
{0x3750, 0x8D12, WORD_LEN, 0 },  	// P_R_P4Q3
{0x3752, 0x2539, WORD_LEN, 0 },  	// P_R_P4Q4
{0x3640, 0x0350, WORD_LEN, 0 },  	// P_G1_P0Q0
{0x3642, 0x322C, WORD_LEN, 0 },  	// P_G1_P0Q1
{0x3644, 0x77D1, WORD_LEN, 0 },  	// P_G1_P0Q2
{0x3646, 0xA26F, WORD_LEN, 0 },  	// P_G1_P0Q3
{0x3648, 0xC872, WORD_LEN, 0 },  	// P_G1_P0Q4
{0x3680, 0x0C4C, WORD_LEN, 0 },  	// P_G1_P1Q0
{0x3682, 0x9510, WORD_LEN, 0 },  	// P_G1_P1Q1
{0x3684, 0x110E, WORD_LEN, 0 },  	// P_G1_P1Q2
{0x3686, 0x4331, WORD_LEN, 0 },  	// P_G1_P1Q3
{0x3688, 0xC1CF, WORD_LEN, 0 },  	// P_G1_P1Q4
{0x36C0, 0x6152, WORD_LEN, 0 },  	// P_G1_P2Q0
{0x36C2, 0x038E, WORD_LEN, 0 },  	// P_G1_P2Q1
{0x36C4, 0x9AF4, WORD_LEN, 0 },  	// P_G1_P2Q2
{0x36C6, 0xE12F, WORD_LEN, 0 },  	// P_G1_P2Q3
{0x36C8, 0x09F3, WORD_LEN, 0 },  	// P_G1_P2Q4
{0x3700, 0xC5AF, WORD_LEN, 0 },  	// P_G1_P3Q0
{0x3702, 0xCA90, WORD_LEN, 0 },  	// P_G1_P3Q1
{0x3704, 0x5D0F, WORD_LEN, 0 },  	// P_G1_P3Q2
{0x3706, 0x3293, WORD_LEN, 0 },  	// P_G1_P3Q3
{0x3708, 0x2B92, WORD_LEN, 0 },  	// P_G1_P3Q4
{0x3740, 0xC590, WORD_LEN, 0 },  	// P_G1_P4Q0
{0x3742, 0x8133, WORD_LEN, 0 },  	// P_G1_P4Q1
{0x3744, 0xE0F6, WORD_LEN, 0 },  	// P_G1_P4Q2
{0x3746, 0x0254, WORD_LEN, 0 },  	// P_G1_P4Q3
{0x3748, 0x10B9, WORD_LEN, 0 },  	// P_G1_P4Q4
{0x3654, 0x7F8F, WORD_LEN, 0 },  	// P_B_P0Q0
{0x3656, 0x6F6C, WORD_LEN, 0 },  	// P_B_P0Q1
{0x3658, 0x5971, WORD_LEN, 0 },  	// P_B_P0Q2
{0x365A, 0x9A0F, WORD_LEN, 0 },  	// P_B_P0Q3
{0x365C, 0xA1B2, WORD_LEN, 0 },  	// P_B_P0Q4
{0x3694, 0xB00C, WORD_LEN, 0 },  	// P_B_P1Q0
{0x3696, 0xEBCF, WORD_LEN, 0 },  	// P_B_P1Q1
{0x3698, 0x06AD, WORD_LEN, 0 },  	// P_B_P1Q2
{0x369A, 0x4D31, WORD_LEN, 0 },  	// P_B_P1Q3
{0x369C, 0x2A4E, WORD_LEN, 0 },  	// P_B_P1Q4
{0x36D4, 0x4752, WORD_LEN, 0 },  	// P_B_P2Q0
{0x36D6, 0x724D, WORD_LEN, 0 },  	// P_B_P2Q1
{0x36D8, 0xAD34, WORD_LEN, 0 },  	// P_B_P2Q2
{0x36DA, 0x1350, WORD_LEN, 0 },  	// P_B_P2Q3
{0x36DC, 0x4E94, WORD_LEN, 0 },  	// P_B_P2Q4
{0x3714, 0xA06E, WORD_LEN, 0 },  	// P_B_P3Q0
{0x3716, 0x9152, WORD_LEN, 0 },  	// P_B_P3Q1
{0x3718, 0x1F53, WORD_LEN, 0 },  	// P_B_P3Q2
{0x371A, 0x3933, WORD_LEN, 0 },  	// P_B_P3Q3
{0x371C, 0xBA94, WORD_LEN, 0 },  	// P_B_P3Q4
{0x3754, 0x1233, WORD_LEN, 0 },  	// P_B_P4Q0
{0x3756, 0xA032, WORD_LEN, 0 },  	// P_B_P4Q1
{0x3758, 0xE936, WORD_LEN, 0 },  	// P_B_P4Q2
{0x375A, 0xBE34, WORD_LEN, 0 },  	// P_B_P4Q3
{0x375C, 0x02D9, WORD_LEN, 0 },  	// P_B_P4Q4
{0x365E, 0x7DEF, WORD_LEN, 0 },  	// P_G2_P0Q0
{0x3660, 0x434B, WORD_LEN, 0 },  	// P_G2_P0Q1
{0x3662, 0x69F1, WORD_LEN, 0 },  	// P_G2_P0Q2
{0x3664, 0x8A0F, WORD_LEN, 0 },  	// P_G2_P0Q3
{0x3666, 0xBDB2, WORD_LEN, 0 },  	// P_G2_P0Q4
{0x369E, 0x290D, WORD_LEN, 0 },  	// P_G2_P1Q0
{0x36A0, 0x42CF, WORD_LEN, 0 },  	// P_G2_P1Q1
{0x36A2, 0xDC6D, WORD_LEN, 0 },  	// P_G2_P1Q2
{0x36A4, 0x91B1, WORD_LEN, 0 },  	// P_G2_P1Q3
{0x36A6, 0x9DE9, WORD_LEN, 0 },  	// P_G2_P1Q4
{0x36DE, 0x70B2, WORD_LEN, 0 },  	// P_G2_P2Q0
{0x36E0, 0x02AC, WORD_LEN, 0 },  	// P_G2_P2Q1
{0x36E2, 0x9714, WORD_LEN, 0 },  	// P_G2_P2Q2
{0x36E4, 0xF3CF, WORD_LEN, 0 },  	// P_G2_P2Q3
{0x36E6, 0x6BD1, WORD_LEN, 0 },  	// P_G2_P2Q4
{0x371E, 0xE42E, WORD_LEN, 0 },  	// P_G2_P3Q0
{0x3720, 0x1D32, WORD_LEN, 0 },  	// P_G2_P3Q1
{0x3722, 0xCC31, WORD_LEN, 0 },  	// P_G2_P3Q2
{0x3724, 0xAE94, WORD_LEN, 0 },  	// P_G2_P3Q3
{0x3726, 0x6413, WORD_LEN, 0 },  	// P_G2_P3Q4
{0x375E, 0xE290, WORD_LEN, 0 },  	// P_G2_P4Q0
{0x3760, 0x8F53, WORD_LEN, 0 },  	// P_G2_P4Q1
{0x3762, 0xF936, WORD_LEN, 0 },  	// P_G2_P4Q2
{0x3764, 0x4614, WORD_LEN, 0 },  	// P_G2_P4Q3
{0x3766, 0x1B59, WORD_LEN, 0 },  	// P_G2_P4Q4
*/

{0x3784, 0x0404, WORD_LEN, 0 },  	// CENTER_COLUMN
{0x3782, 0x0304, WORD_LEN, 0 },  	// CENTER_ROW
{0x3210, 0x04B8, WORD_LEN, 0 },  	// COLOR_PIPELINE_CONTROL
{0x098E, 0xC913, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_STAT_BRIGHTNESS_METRIC_PREDIVIDER]
{0x0990, 0x000A, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x686B, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_LL_START_BRIGHTNESS]
{0x0990, 0x05DC, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x686D, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_LL_STOP_BRIGHTNESS]
{0x0990, 0x0BB8, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x6C6B, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_B_CONFIG_LL_START_BRIGHTNESS]
{0x0990, 0x05DC, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x6C6D, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_B_CONFIG_LL_STOP_BRIGHTNESS]
{0x0990, 0x0BB8, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x3439, WORD_LEN, 0 },  	// MCU_ADDRESS [AS_ASSTART_BRIGHTNESS]
{0x0990, 0x05DC, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x343B, WORD_LEN, 0 },  	// MCU_ADDRESS [AS_ASSTOP_BRIGHTNESS]
{0x0990, 0x0BB8, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4926, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_START_GAMMA_BM]
{0x0990, 0x0001, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4928, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_MID_GAMMA_BM]
{0x0990, 0x0002, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x492A, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_STOP_GAMMA_BM]
{0x0990, 0x0656, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4D26, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM2_LL_START_GAMMA_BM]
{0x0990, 0x0001, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4D28, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM2_LL_MID_GAMMA_BM]
{0x0990, 0x0002, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4D2A, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM2_LL_STOP_GAMMA_BM]
{0x0990, 0x0656, WORD_LEN, 0 },  	// MCU_DATA_0
{0x33F4, 0x040B, WORD_LEN, 0 },  	// KERNEL_CONFIG
{0x098E, 0xC916, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_LL_START_0]
{0x0990, 0x0014, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC919, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_LL_STOP_0]
{0x0990, 0x0028, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC917, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_LL_START_1]
{0x0990, 0x0004, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC918, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_LL_START_2]
{0x0990, 0x0000, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC91A, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_LL_STOP_1]
{0x0990, 0x0001, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC91B, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_LL_STOP_2]
{0x0990, 0x0009, WORD_LEN, 0 },  	// MCU_DATA_0
{0x326C, 0x0C00, WORD_LEN, 0 },  	// APERTURE_PARAMETERS_2D
{0x098E, 0x494B, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_EXT_START_GAIN_METRIC]
{0x0990, 0x0042, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x494D, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_EXT_STOP_GAIN_METRIC]
{0x0990, 0x012C, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC91E, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_NR_START_0]
{0x0990, 0x0012, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC91F, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_NR_START_1]
{0x0990, 0x000A, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC920, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_NR_START_2]
{0x0990, 0x0012, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC921, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_NR_START_3]
{0x0990, 0x000A, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC922, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_NR_STOP_0]
{0x0990, 0x0026, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC923, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_NR_STOP_1]
{0x0990, 0x001E, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC924, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_NR_STOP_2]
{0x0990, 0x0026, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC925, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_NR_STOP_3]
{0x0990, 0x0026, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC02, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_MODE]
{0x0990, 0x0003, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC05, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_CLUSTER_DC_TH]
{0x0990, 0x000E, WORD_LEN, 0 },  	// MCU_DATA_0
{0x316C, 0x350F, WORD_LEN, 0 },  	// DAC_TXLO
{0x098E, 0xC950, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_START_1]
{0x0990, 0x0064, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC94F, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_START_0]
{0x0990, 0x0038, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC952, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_START_3]
{0x0990, 0x0064, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC951, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_START_2]
{0x0990, 0x0051, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC954, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_START_5]
{0x0990, 0x0010, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC953, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_START_4]
{0x0990, 0x0020, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC956, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_START_7]
{0x0990, 0x0010, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC955, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_START_6]
{0x0990, 0x0020, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC958, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_STOP_1]
{0x0990, 0x0020, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC957, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_STOP_0]
{0x0990, 0x0014, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC95A, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_STOP_3]
{0x0990, 0x001D, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC959, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_STOP_2]
{0x0990, 0x0020, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC95C, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_STOP_5]
{0x0990, 0x000C, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC95B, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_STOP_4]
{0x0990, 0x0008, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC95E, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_STOP_7]
{0x0990, 0x000C, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC95D, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_STOP_6]
{0x0990, 0x0008, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC95F, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_EXT_GRB_WINDOW_PERCENT]
{0x0990, 0x0064, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48DC, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_LL_CCM_0]
{0x0990, 0x004D, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48DE, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_LL_CCM_1]
{0x0990, 0x0096, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48E0, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_LL_CCM_2]
{0x0990, 0x001D, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48E2, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_LL_CCM_3]
{0x0990, 0x004D, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48E4, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_LL_CCM_4]
{0x0990, 0x0096, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48E6, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_LL_CCM_5]
{0x0990, 0x001D, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48E8, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_LL_CCM_6]
{0x0990, 0x004D, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48EA, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_LL_CCM_7]
{0x0990, 0x0096, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48EC, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_LL_CCM_8]
{0x0990, 0x001D, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xDC2A, WORD_LEN, 0 },  	// MCU_ADDRESS [SYS_DELTA_GAIN]
{0x0990, 0x000B, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xDC2B, WORD_LEN, 0 },  	// MCU_ADDRESS [SYS_DELTA_THRESH]
{0x0990, 0x0017, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC0B, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_0]
{0x0990, 0x0000, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC0C, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_1]
{0x0990, 0x001B, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC0D, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_2]
{0x0990, 0x002A, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC0E, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_3]
{0x0990, 0x003E, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC0F, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_4]
{0x0990, 0x005A, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC10, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_5]
{0x0990, 0x0070, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC11, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_6]
{0x0990, 0x0081, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC12, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_7]
{0x0990, 0x0090, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC13, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_8]
{0x0990, 0x009E, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC14, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_9]
{0x0990, 0x00AB, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC15, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_10]
{0x0990, 0x00B6, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC16, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_11]
{0x0990, 0x00C1, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC17, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_12]
{0x0990, 0x00CB, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC18, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_13]
{0x0990, 0x00D5, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC19, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_14]
{0x0990, 0x00DE, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC1A, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_15]
{0x0990, 0x00E7, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC1B, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_16]
{0x0990, 0x00EF, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC1C, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_17]
{0x0990, 0x00F7, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC1D, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_18]
{0x0990, 0x00FF, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC1E, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_0]
{0x0990, 0x0000, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC1F, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_1]
{0x0990, 0x001B, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC20, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_2]
{0x0990, 0x002A, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC21, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_3]
{0x0990, 0x003E, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC22, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_4]
{0x0990, 0x005A, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC23, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_5]
{0x0990, 0x0070, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC24, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_6]
{0x0990, 0x0081, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC25, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_7]
{0x0990, 0x0090, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC26, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_8]
{0x0990, 0x009E, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC27, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_9]
{0x0990, 0x00AB, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC28, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_10]
{0x0990, 0x00B6, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC29, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_11]
{0x0990, 0x00C1, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC2A, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_12]
{0x0990, 0x00CB, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC2B, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_13]
{0x0990, 0x00D5, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC2C, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_14]
{0x0990, 0x00DE, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC2D, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_15]
{0x0990, 0x00E7, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC2E, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_16]
{0x0990, 0x00EF, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC2F, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_17]
{0x0990, 0x00F7, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC30, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_18]
{0x0990, 0x00FF, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC31, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NRCURVE_0]
{0x0990, 0x0000, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC32, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NRCURVE_1]
{0x0990, 0x000D, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC33, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NRCURVE_2]
{0x0990, 0x0019, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC34, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NRCURVE_3]
{0x0990, 0x0030, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC35, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NRCURVE_4]
{0x0990, 0x0056, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC36, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NRCURVE_5]
{0x0990, 0x0070, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC37, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NRCURVE_6]
{0x0990, 0x0081, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC38, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NRCURVE_7]
{0x0990, 0x0090, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC39, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NRCURVE_8]
{0x0990, 0x009E, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC3A, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NRCURVE_9]
{0x0990, 0x00AB, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC3B, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NRCURVE_10]
{0x0990, 0x00B6, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC3C, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NRCURVE_11]
{0x0990, 0x00C1, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC3D, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NRCURVE_12]
{0x0990, 0x00CB, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC3E, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NRCURVE_13]
{0x0990, 0x00D5, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC3F, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NRCURVE_14]
{0x0990, 0x00DE, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC40, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NRCURVE_15]
{0x0990, 0x00E7, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC41, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NRCURVE_16]
{0x0990, 0x00EF, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC42, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NRCURVE_17]
{0x0990, 0x00F7, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC43, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_NRCURVE_18]
{0x0990, 0x00FF, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x6865, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_LL_ALGO_ENTER]
{0x0990, 0x00E0, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x6867, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_LL_ALGO_RUN]
{0x0990, 0x00F4, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x8400, WORD_LEN, 0 },  	// MCU_ADDRESS [SEQ_CMD]
{0x0990, 0x0006, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC4A, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_TONAL_CURVE_HIGH]
{0x0990, 0x007F, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC4B, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_TONAL_CURVE_MED]
{0x0990, 0x007F, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xBC4C, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_TONAL_CURVE_LOW]
{0x0990, 0x007F, WORD_LEN, 0 },  	// MCU_DATA_0
{0x3542, 0x0010, WORD_LEN, 0 },  	// TONAL_X0
{0x3544, 0x0030, WORD_LEN, 0 },  	// TONAL_X1
{0x3546, 0x0040, WORD_LEN, 0 },  	// TONAL_X2
{0x3548, 0x0080, WORD_LEN, 0 },  	// TONAL_X3
{0x354A, 0x0100, WORD_LEN, 0 },  	// TONAL_X4
{0x354C, 0x0200, WORD_LEN, 0 },  	// TONAL_X5
{0x354E, 0x0300, WORD_LEN, 0 },  	// TONAL_X6
{0x3550, 0x0010, WORD_LEN, 0 },  	// TONAL_Y0
{0x3552, 0x0030, WORD_LEN, 0 },  	// TONAL_Y1
{0x3554, 0x0040, WORD_LEN, 0 },  	// TONAL_Y2
{0x3556, 0x0080, WORD_LEN, 0 },  	// TONAL_Y3
{0x3558, 0x012C, WORD_LEN, 0 },  	// TONAL_Y4
{0x355A, 0x0320, WORD_LEN, 0 },  	// TONAL_Y5
{0x355C, 0x03E8, WORD_LEN, 0 },  	// TONAL_Y6
{0x3560, 0x0040, WORD_LEN, 0 },  	// RECIPROCAL_OF_X0_MINUS_ZERO
{0x3562, 0x0020, WORD_LEN, 0 },  	// RECIPROCAL_OF_X1_MINUS_X0
{0x3564, 0x0040, WORD_LEN, 0 },  	// RECIPROCAL_OF_X2_MINUS_X1
{0x3566, 0x0010, WORD_LEN, 0 },  	// RECIPROCAL_OF_X3_MINUS_X2
{0x3568, 0x0008, WORD_LEN, 0 },  	// RECIPROCAL_OF_X4_MINUS_X3
{0x356A, 0x0004, WORD_LEN, 0 },  	// RECIPROCAL_OF_X5_MINUS_X4
{0x356C, 0x0004, WORD_LEN, 0 },  	// RECIPROCAL_OF_X6_MINUS_X5
{0x356E, 0x0004, WORD_LEN, 0 },  	// RECIPROCAL_OF_400_MINUS_X6
{0x098E, 0x3C4D, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_START_GAMMA_FTB]
{0x0990, 0x0DAC, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x3C4F, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_STOP_GAMMA_FTB]
{0x0990, 0x148A, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC911, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_STAT_LUMA_THRESH_HIGH]
{0x0990, 0x00C8, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC8F4, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_AWB_XSCALE]
{0x0990, 0x0004, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC8F5, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_AWB_YSCALE]
{0x0990, 0x0002, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48F6, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_AWB_WEIGHTS_0]
{0x0990, 0x3B4D, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48F8, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_AWB_WEIGHTS_1]
{0x0990, 0x6380, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48FA, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_AWB_WEIGHTS_2]
{0x0990, 0x9B18, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48FC, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_AWB_WEIGHTS_3]
{0x0990, 0x5D51, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48FE, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_AWB_WEIGHTS_4]
{0x0990, 0xEDE8, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4900, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_AWB_WEIGHTS_5]
{0x0990, 0xE515, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4902, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_AWB_WEIGHTS_6]
{0x0990, 0xBFF4, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4904, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_AWB_WEIGHTS_7]
{0x0990, 0x001E, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4906, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_AWB_XSHIFT_PRE_ADJ]
{0x0990, 0x0026, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4908, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_AWB_YSHIFT_PRE_ADJ]
{0x0990, 0x0033, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xE84A, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_AWB_K_R_L]
{0x0990, 0x0083, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xE84D, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_AWB_K_R_R]
{0x0990, 0x0083, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xE84C, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_AWB_K_B_L]
{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xE84F, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_AWB_K_B_R]
{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x8400, WORD_LEN, 0 },  	// MCU_ADDRESS [SEQ_CMD]
{0x0990, 0x0006, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48B0, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_0]
{0x0990, 0x0180, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48B2, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_1]
{0x0990, 0xFF7A, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48B4, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_2]
{0x0990, 0x0018, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48B6, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_3]
{0x0990, 0xFFCA, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48B8, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_4]
{0x0990, 0x017C, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48BA, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_5]
{0x0990, 0xFFCC, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48BC, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_6]
{0x0990, 0x000C, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48BE, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_7]
{0x0990, 0xFF1F, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48C0, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_8]
{0x0990, 0x01E8, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48C2, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_9]
{0x0990, 0x0020, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48C4, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_10]
{0x0990, 0x0044, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48C6, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_0]
{0x0990, 0x0079, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48C8, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_1]
{0x0990, 0xFFAD, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48CA, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_2]
{0x0990, 0xFFE2, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48CC, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_3]
{0x0990, 0x0033, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48CE, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_4]
{0x0990, 0x002A, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48D0, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_5]
{0x0990, 0xFFAA, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48D2, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_6]
{0x0990, 0x0017, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48D4, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_7]
{0x0990, 0x004B, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48D6, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_8]
{0x0990, 0xFFA5, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48D8, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_9]
{0x0990, 0x0015, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48DA, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_10]
{0x0990, 0xFFE2, WORD_LEN, 0 },  	// MCU_DATA_0
{0x35A2, 0x0014, WORD_LEN, 0 },  	// DARK_COLOR_KILL_CONTROLS
{0x098E, 0xC949, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_SYS_DARK_COLOR_KILL]
{0x0990, 0x0024, WORD_LEN, 0 },  	// MCU_DATA_0
{0x35A4, 0x0596, WORD_LEN, 0 },  	// BRIGHT_COLOR_KILL_CONTROLS
{0x098E, 0xC94A, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_SYS_BRIGHT_COLORKILL]
{0x0990, 0x0062, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC948, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_SYS_UV_COLOR_BOOST]
{0x0990, 0x0006, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC914, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_START_DESATURATION]
{0x0990, 0x0000, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xC915, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_LL_END_DESATURATION]
{0x0990, 0x00FF, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xE86F, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_LL_START_SATURATION]
{0x0990, 0x0060, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xE870, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_LL_END_SATURATION]
{0x0990, 0x003C, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xEC6F, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_B_CONFIG_LL_START_SATURATION]
{0x0990, 0x0060, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xEC70, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_B_CONFIG_LL_END_SATURATION]
{0x0990, 0x003C, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xE883, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SELECT_FX]
{0x0990, 0x0000, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xEC83, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SELECT_FX]
{0x0990, 0x0000, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x8400, WORD_LEN, 0 },  	// MCU_ADDRESS [SEQ_CMD]
{0x0990, 0x0006, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xE885, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SEPIA_CR]
{0x0990, 0x001E, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xE886, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SEPIA_CB]
{0x0990, 0x00D8, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xEC85, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SEPIA_CR]
{0x0990, 0x001E, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xEC86, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SEPIA_CB]
{0x0990, 0x00D8, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xE884, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SOLARIZATION_TH]
{0x0990, 0x005C, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xEC84, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SOLARIZATION_TH]
{0x0990, 0x005C, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x490A, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AS_INTEG_SCALE_FIRST_PASS]
{0x0990, 0x0666, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x490C, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AS_MIN_INT_TIME_FIRST_PASS]
{0x0990, 0x0140, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x6857, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_IS_FEATURE_THRESHOLD]
{0x0990, 0x0014, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x685C, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_IS_BLUR_INPUT_PARAMETER]
{0x0990, 0x0005, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x490E, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AS_MAX_DIGITAL_GAIN_ALLOWED]
{0x0990, 0x00A4, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xB43D, WORD_LEN, 0 },  	// MCU_ADDRESS [AS_START_ASVALUES_0]
{0x0990, 0x0031, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xB43E, WORD_LEN, 0 },  	// MCU_ADDRESS [AS_START_ASVALUES_1]
{0x0990, 0x001B, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xB43F, WORD_LEN, 0 },  	// MCU_ADDRESS [AS_START_ASVALUES_2]
{0x0990, 0x0028, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xB440, WORD_LEN, 0 },  	// MCU_ADDRESS [AS_START_ASVALUES_3]
{0x0990, 0x0003, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xB441, WORD_LEN, 0 },  	// MCU_ADDRESS [AS_STOP_ASVALUES_0]
{0x0990, 0x00CD, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xB442, WORD_LEN, 0 },  	// MCU_ADDRESS [AS_STOP_ASVALUES_1]
{0x0990, 0x0064, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xB443, WORD_LEN, 0 },  	// MCU_ADDRESS [AS_STOP_ASVALUES_2]
{0x0990, 0x000F, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xB444, WORD_LEN, 0 },  	// MCU_ADDRESS [AS_STOP_ASVALUES_3]
{0x0990, 0x0007, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x300D, WORD_LEN, 0 },  	// MCU_ADDRESS [AF_FILTERS]
{0x0990, 0x000F, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x3017, WORD_LEN, 0 },  	// MCU_ADDRESS [AF_THRESHOLDS]
{0x0990, 0x0F0F, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x8400, WORD_LEN, 0 },  	// MCU_ADDRESS [SEQ_CMD]
{0x0990, 0x0006, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xE81F, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_AE_RULE_BASE_TARGET]
{0x0990, 0x0020, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x68A0, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_JPEG_OB_TX_CONTROL_VAR]
{0x0990, 0x082E, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x6CA0, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_B_CONFIG_JPEG_OB_TX_CONTROL_VAR]
{0x0990, 0x082E, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x70A0, WORD_LEN, 0 },  	// MCU_ADDRESS [SEC_A_CONFIG_JPEG_OB_TX_CONTROL_VAR]
{0x0990, 0x082E, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x74A0, WORD_LEN, 0 },  	// MCU_ADDRESS [SEC_B_CONFIG_JPEG_OB_TX_CONTROL_VAR]
{0x0990, 0x082E, WORD_LEN, 0 },  	// MCU_DATA_0
{0x3C52, 0x002E, WORD_LEN, 0 },  	// RESERVED_TX_SS_3C52//02e
{0x098E, 0x488E, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_CTX_B_RX_FIFO_TRIGGER_MARK]
{0x0990, 0x0020, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xECAC, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_B_CONFIG_IO_OB_MANUAL_FLAG]
{0x0990, 0x0000, WORD_LEN, 0 },  	// MCU_DATA_0
{0x3084, 0x2409, WORD_LEN, 0 },  	// RESERVED_CORE_3084
{0x3092, 0x0A49, WORD_LEN, 0 },  	// RESERVED_CORE_3092
{0x3094, 0x4949, WORD_LEN, 0 },  	// RESERVED_CORE_3094
{0x3096, 0x4950, WORD_LEN, 0 },  	// RESERVED_CORE_3096

{0x0982, 0x0000, WORD_LEN, 0 },  	// ACCESS_CTL_STAT
{0x098A, 0x0CFB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x3C3C, WORD_LEN, 0 }, 
{0x0992, 0x3C3C, WORD_LEN, 0 }, 
{0x0994, 0x3C3C, WORD_LEN, 0 }, 
{0x0996, 0x5F4F, WORD_LEN, 0 }, 
{0x0998, 0x30ED, WORD_LEN, 0 }, 
{0x099A, 0x0AED, WORD_LEN, 0 }, 
{0x099C, 0x08BD, WORD_LEN, 0 }, 
{0x099E, 0x61D5, WORD_LEN, 0 }, 
{0x098A, 0x0D0B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xCE04, WORD_LEN, 0 }, 
{0x0992, 0xCD1F, WORD_LEN, 0 }, 
{0x0994, 0x1702, WORD_LEN, 0 }, 
{0x0996, 0x11CC, WORD_LEN, 0 }, 
{0x0998, 0x332E, WORD_LEN, 0 }, 
{0x099A, 0x30ED, WORD_LEN, 0 }, 
{0x099C, 0x02CC, WORD_LEN, 0 }, 
{0x099E, 0xFFFD, WORD_LEN, 0 }, 
{0x098A, 0x0D1B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xED00, WORD_LEN, 0 }, 
{0x0992, 0xCC00, WORD_LEN, 0 }, 
{0x0994, 0x02BD, WORD_LEN, 0 }, 
{0x0996, 0x706D, WORD_LEN, 0 }, 
{0x0998, 0x18DE, WORD_LEN, 0 }, 
{0x099A, 0x1F18, WORD_LEN, 0 }, 
{0x099C, 0x1F8E, WORD_LEN, 0 }, 
{0x099E, 0x0110, WORD_LEN, 0 }, 
{0x098A, 0x0D2B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xCC3C, WORD_LEN, 0 }, 
{0x0992, 0x5230, WORD_LEN, 0 }, 
{0x0994, 0xED00, WORD_LEN, 0 }, 
{0x0996, 0x18EC, WORD_LEN, 0 }, 
{0x0998, 0xA0C4, WORD_LEN, 0 }, 
{0x099A, 0xFDBD, WORD_LEN, 0 }, 
{0x099C, 0x7021, WORD_LEN, 0 }, 
{0x099E, 0x201E, WORD_LEN, 0 }, 
{0x098A, 0x0D3B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xCC3C, WORD_LEN, 0 }, 
{0x0992, 0x5230, WORD_LEN, 0 }, 
{0x0994, 0xED00, WORD_LEN, 0 }, 
{0x0996, 0xDE1F, WORD_LEN, 0 }, 
{0x0998, 0xECA0, WORD_LEN, 0 }, 
{0x099A, 0xBD70, WORD_LEN, 0 }, 
{0x099C, 0x21CC, WORD_LEN, 0 }, 
{0x099E, 0x3C52, WORD_LEN, 0 }, 
{0x098A, 0x0D4B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x30ED, WORD_LEN, 0 }, 
{0x0992, 0x02CC, WORD_LEN, 0 }, 
{0x0994, 0xFFFC, WORD_LEN, 0 }, 
{0x0996, 0xED00, WORD_LEN, 0 }, 
{0x0998, 0xCC00, WORD_LEN, 0 }, 
{0x099A, 0x02BD, WORD_LEN, 0 }, 
{0x099C, 0x706D, WORD_LEN, 0 }, 
{0x099E, 0xFC04, WORD_LEN, 0 }, 
{0x098A, 0x0D5B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xE11A, WORD_LEN, 0 }, 
{0x0992, 0x8300, WORD_LEN, 0 }, 
{0x0994, 0x0127, WORD_LEN, 0 }, 
{0x0996, 0x201A, WORD_LEN, 0 }, 
{0x0998, 0x8300, WORD_LEN, 0 }, 
{0x099A, 0x0427, WORD_LEN, 0 }, 
{0x099C, 0x221A, WORD_LEN, 0 }, 
{0x099E, 0x8300, WORD_LEN, 0 }, 
{0x098A, 0x0D6B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0827, WORD_LEN, 0 }, 
{0x0992, 0x241A, WORD_LEN, 0 }, 
{0x0994, 0x8300, WORD_LEN, 0 }, 
{0x0996, 0x1027, WORD_LEN, 0 }, 
{0x0998, 0x261A, WORD_LEN, 0 }, 
{0x099A, 0x8300, WORD_LEN, 0 }, 
{0x099C, 0x2027, WORD_LEN, 0 }, 
{0x099E, 0x281A, WORD_LEN, 0 }, 
{0x098A, 0x0D7B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x8300, WORD_LEN, 0 }, 
{0x0992, 0x4027, WORD_LEN, 0 }, 
{0x0994, 0x2A20, WORD_LEN, 0 }, 
{0x0996, 0x2ECC, WORD_LEN, 0 }, 
{0x0998, 0x001E, WORD_LEN, 0 }, 
{0x099A, 0x30ED, WORD_LEN, 0 }, 
{0x099C, 0x0A20, WORD_LEN, 0 }, 
{0x099E, 0x26CC, WORD_LEN, 0 }, 
{0x098A, 0x0D8B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0022, WORD_LEN, 0 }, 
{0x0992, 0x30ED, WORD_LEN, 0 }, 
{0x0994, 0x0A20, WORD_LEN, 0 }, 
{0x0996, 0x1ECC, WORD_LEN, 0 }, 
{0x0998, 0x0021, WORD_LEN, 0 }, 
{0x099A, 0x30ED, WORD_LEN, 0 }, 
{0x099C, 0x0A20, WORD_LEN, 0 }, 
{0x099E, 0x16CC, WORD_LEN, 0 }, 
{0x098A, 0x0D9B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0020, WORD_LEN, 0 }, 
{0x0992, 0x30ED, WORD_LEN, 0 }, 
{0x0994, 0x0A20, WORD_LEN, 0 }, 
{0x0996, 0x0ECC, WORD_LEN, 0 }, 
{0x0998, 0x002A, WORD_LEN, 0 }, 
{0x099A, 0x30ED, WORD_LEN, 0 }, 
{0x099C, 0x0A20, WORD_LEN, 0 }, 
{0x099E, 0x06CC, WORD_LEN, 0 }, 
{0x098A, 0x0DAB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x002B, WORD_LEN, 0 }, 
{0x0992, 0x30ED, WORD_LEN, 0 }, 
{0x0994, 0x0ACC, WORD_LEN, 0 }, 
{0x0996, 0x3400, WORD_LEN, 0 }, 
{0x0998, 0x30ED, WORD_LEN, 0 }, 
{0x099A, 0x0034, WORD_LEN, 0 }, 
{0x099C, 0xBD6F, WORD_LEN, 0 }, 
{0x099E, 0xD184, WORD_LEN, 0 }, 
{0x098A, 0x0DBB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0330, WORD_LEN, 0 }, 
{0x0992, 0xED07, WORD_LEN, 0 }, 
{0x0994, 0xA60C, WORD_LEN, 0 }, 
{0x0996, 0x4848, WORD_LEN, 0 }, 
{0x0998, 0x5FED, WORD_LEN, 0 }, 
{0x099A, 0x05EC, WORD_LEN, 0 }, 
{0x099C, 0x07EA, WORD_LEN, 0 }, 
{0x099E, 0x06AA, WORD_LEN, 0 }, 
{0x098A, 0x0DCB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0531, WORD_LEN, 0 }, 
{0x0992, 0xBD70, WORD_LEN, 0 }, 
{0x0994, 0x21DE, WORD_LEN, 0 }, 
{0x0996, 0x1F1F, WORD_LEN, 0 }, 
{0x0998, 0x8E01, WORD_LEN, 0 }, 
{0x099A, 0x08EC, WORD_LEN, 0 }, 
{0x099C, 0x9B05, WORD_LEN, 0 }, 
{0x099E, 0x30ED, WORD_LEN, 0 }, 
{0x098A, 0x0DDB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0820, WORD_LEN, 0 }, 
{0x0992, 0x3BDE, WORD_LEN, 0 }, 
{0x0994, 0x1FEC, WORD_LEN, 0 }, 
{0x0996, 0x0783, WORD_LEN, 0 }, 
{0x0998, 0x0040, WORD_LEN, 0 }, 
{0x099A, 0x2628, WORD_LEN, 0 }, 
{0x099C, 0x7F30, WORD_LEN, 0 }, 
{0x099E, 0xC4CC, WORD_LEN, 0 }, 
{0x098A, 0x0DEB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x3C68, WORD_LEN, 0 }, 
{0x0992, 0xBD6F, WORD_LEN, 0 }, 
{0x0994, 0xD1FD, WORD_LEN, 0 }, 
{0x0996, 0x30C5, WORD_LEN, 0 }, 
{0x0998, 0xCC01, WORD_LEN, 0 }, 
{0x099A, 0xF4FD, WORD_LEN, 0 }, 
{0x099C, 0x30C7, WORD_LEN, 0 }, 
{0x099E, 0xC640, WORD_LEN, 0 }, 
{0x098A, 0x0DFB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xF730, WORD_LEN, 0 }, 
{0x0992, 0xC4CC, WORD_LEN, 0 }, 
{0x0994, 0x0190, WORD_LEN, 0 }, 
{0x0996, 0xFD30, WORD_LEN, 0 }, 
{0x0998, 0xC501, WORD_LEN, 0 }, 
{0x099A, 0x0101, WORD_LEN, 0 }, 
{0x099C, 0xFC30, WORD_LEN, 0 }, 
{0x099E, 0xC230, WORD_LEN, 0 }, 
{0x098A, 0x0E0B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xED08, WORD_LEN, 0 }, 
{0x0992, 0x200A, WORD_LEN, 0 }, 
{0x0994, 0xCC3C, WORD_LEN, 0 }, 
{0x0996, 0x68BD, WORD_LEN, 0 }, 
{0x0998, 0x6FD1, WORD_LEN, 0 }, 
{0x099A, 0x0530, WORD_LEN, 0 }, 
{0x099C, 0xED08, WORD_LEN, 0 }, 
{0x099E, 0xCC34, WORD_LEN, 0 }, 
{0x098A, 0x0E1B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x08ED, WORD_LEN, 0 }, 
{0x0992, 0x00EC, WORD_LEN, 0 }, 
{0x0994, 0x08BD, WORD_LEN, 0 }, 
{0x0996, 0x7021, WORD_LEN, 0 }, 
{0x0998, 0x30C6, WORD_LEN, 0 }, 
{0x099A, 0x0C3A, WORD_LEN, 0 }, 
{0x099C, 0x3539, WORD_LEN, 0 }, 
{0x099E, 0x373C, WORD_LEN, 0 }, 
{0x098A, 0x0E2B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x3C3C, WORD_LEN, 0 }, 
{0x0992, 0x34DE, WORD_LEN, 0 }, 
{0x0994, 0x2FEE, WORD_LEN, 0 }, 
{0x0996, 0x0EAD, WORD_LEN, 0 }, 
{0x0998, 0x007D, WORD_LEN, 0 }, 
{0x099A, 0x13EF, WORD_LEN, 0 }, 
{0x099C, 0x277C, WORD_LEN, 0 }, 
{0x099E, 0xCE13, WORD_LEN, 0 }, 
{0x098A, 0x0E3B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xE01E, WORD_LEN, 0 }, 
{0x0992, 0x0510, WORD_LEN, 0 }, 
{0x0994, 0x60E6, WORD_LEN, 0 }, 
{0x0996, 0x0E4F, WORD_LEN, 0 }, 
{0x0998, 0xC313, WORD_LEN, 0 }, 
{0x099A, 0xF08F, WORD_LEN, 0 }, 
{0x099C, 0xE600, WORD_LEN, 0 }, 
{0x099E, 0x30E1, WORD_LEN, 0 }, 
{0x098A, 0x0E4B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0722, WORD_LEN, 0 }, 
{0x0992, 0x16F6, WORD_LEN, 0 }, 
{0x0994, 0x13EE, WORD_LEN, 0 }, 
{0x0996, 0x4FC3, WORD_LEN, 0 }, 
{0x0998, 0x13F3, WORD_LEN, 0 }, 
{0x099A, 0x8FE6, WORD_LEN, 0 }, 
{0x099C, 0x0030, WORD_LEN, 0 }, 
{0x099E, 0xE107, WORD_LEN, 0 }, 
{0x098A, 0x0E5B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x2507, WORD_LEN, 0 }, 
{0x0992, 0xF613, WORD_LEN, 0 }, 
{0x0994, 0xEEC1, WORD_LEN, 0 }, 
{0x0996, 0x0325, WORD_LEN, 0 }, 
{0x0998, 0x3C7F, WORD_LEN, 0 }, 
{0x099A, 0x13EE, WORD_LEN, 0 }, 
{0x099C, 0xF613, WORD_LEN, 0 }, 
{0x099E, 0xEFE7, WORD_LEN, 0 }, 
{0x098A, 0x0E6B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x06CC, WORD_LEN, 0 }, 
{0x0992, 0x13F0, WORD_LEN, 0 }, 
{0x0994, 0xED04, WORD_LEN, 0 }, 
{0x0996, 0xCC13, WORD_LEN, 0 }, 
{0x0998, 0xF320, WORD_LEN, 0 }, 
{0x099A, 0x0F7C, WORD_LEN, 0 }, 
{0x099C, 0x13EE, WORD_LEN, 0 }, 
{0x099E, 0xEC04, WORD_LEN, 0 }, 
{0x098A, 0x0E7B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xC300, WORD_LEN, 0 }, 
{0x0992, 0x01ED, WORD_LEN, 0 }, 
{0x0994, 0x04EC, WORD_LEN, 0 }, 
{0x0996, 0x02C3, WORD_LEN, 0 }, 
{0x0998, 0x0001, WORD_LEN, 0 }, 
{0x099A, 0xED02, WORD_LEN, 0 }, 
{0x099C, 0xF613, WORD_LEN, 0 }, 
{0x099E, 0xEEE1, WORD_LEN, 0 }, 
{0x098A, 0x0E8B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0624, WORD_LEN, 0 }, 
{0x0992, 0x12EE, WORD_LEN, 0 }, 
{0x0994, 0x04E6, WORD_LEN, 0 }, 
{0x0996, 0x0030, WORD_LEN, 0 }, 
{0x0998, 0xE107, WORD_LEN, 0 }, 
{0x099A, 0x22DF, WORD_LEN, 0 }, 
{0x099C, 0xEE02, WORD_LEN, 0 }, 
{0x099E, 0xE600, WORD_LEN, 0 }, 
{0x098A, 0x0E9B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x30E1, WORD_LEN, 0 }, 
{0x0992, 0x0725, WORD_LEN, 0 }, 
{0x0994, 0xD6DE, WORD_LEN, 0 }, 
{0x0996, 0x49EE, WORD_LEN, 0 }, 
{0x0998, 0x08AD, WORD_LEN, 0 }, 
{0x099A, 0x00CC, WORD_LEN, 0 }, 
{0x099C, 0x13F6, WORD_LEN, 0 }, 
{0x099E, 0x30ED, WORD_LEN, 0 }, 
{0x098A, 0x0EAB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x00DE, WORD_LEN, 0 }, 
{0x0992, 0x2FEE, WORD_LEN, 0 }, 
{0x0994, 0x10CC, WORD_LEN, 0 }, 
{0x0996, 0x13FA, WORD_LEN, 0 }, 
{0x0998, 0xAD00, WORD_LEN, 0 }, 
{0x099A, 0x3838, WORD_LEN, 0 }, 
{0x099C, 0x3838, WORD_LEN, 0 }, 
{0x099E, 0x3937, WORD_LEN, 0 }, 
{0x098A, 0x0EBB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x363C, WORD_LEN, 0 }, 
{0x0992, 0x3C3C, WORD_LEN, 0 }, 
{0x0994, 0x5F4F, WORD_LEN, 0 }, 
{0x0996, 0x30ED, WORD_LEN, 0 }, 
{0x0998, 0x04EC, WORD_LEN, 0 }, 
{0x099A, 0x06ED, WORD_LEN, 0 }, 
{0x099C, 0x008F, WORD_LEN, 0 }, 
{0x099E, 0xC300, WORD_LEN, 0 }, 
{0x098A, 0x0ECB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x04BD, WORD_LEN, 0 }, 
{0x0992, 0x0F43, WORD_LEN, 0 }, 
{0x0994, 0x30EC, WORD_LEN, 0 }, 
{0x0996, 0x04BD, WORD_LEN, 0 }, 
{0x0998, 0x0F76, WORD_LEN, 0 }, 
{0x099A, 0x30ED, WORD_LEN, 0 }, 
{0x099C, 0x0238, WORD_LEN, 0 }, 
{0x099E, 0x3838, WORD_LEN, 0 }, 
{0x098A, 0x0EDB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x3839, WORD_LEN, 0 }, 
{0x0992, 0x373C, WORD_LEN, 0 }, 
{0x0994, 0x3C3C, WORD_LEN, 0 }, 
{0x0996, 0x3C30, WORD_LEN, 0 }, 
{0x0998, 0xE608, WORD_LEN, 0 }, 
{0x099A, 0x2712, WORD_LEN, 0 }, 
{0x099C, 0xC101, WORD_LEN, 0 }, 
{0x099E, 0x2713, WORD_LEN, 0 }, 
{0x098A, 0x0EEB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xC102, WORD_LEN, 0 }, 
{0x0992, 0x2714, WORD_LEN, 0 }, 
{0x0994, 0xC103, WORD_LEN, 0 }, 
{0x0996, 0x2715, WORD_LEN, 0 }, 
{0x0998, 0xC104, WORD_LEN, 0 }, 
{0x099A, 0x2716, WORD_LEN, 0 }, 
{0x099C, 0x2019, WORD_LEN, 0 }, 
{0x099E, 0xCC30, WORD_LEN, 0 }, 
{0x098A, 0x0EFB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x5E20, WORD_LEN, 0 }, 
{0x0992, 0x12CC, WORD_LEN, 0 }, 
{0x0994, 0x305A, WORD_LEN, 0 }, 
{0x0996, 0x200D, WORD_LEN, 0 }, 
{0x0998, 0xCC30, WORD_LEN, 0 }, 
{0x099A, 0x5620, WORD_LEN, 0 }, 
{0x099C, 0x08CC, WORD_LEN, 0 }, 
{0x099E, 0x305C, WORD_LEN, 0 }, 
{0x098A, 0x0F0B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x2003, WORD_LEN, 0 }, 
{0x0992, 0xCC30, WORD_LEN, 0 }, 
{0x0994, 0x58ED, WORD_LEN, 0 }, 
{0x0996, 0x065F, WORD_LEN, 0 }, 
{0x0998, 0x4FED, WORD_LEN, 0 }, 
{0x099A, 0x04EC, WORD_LEN, 0 }, 
{0x099C, 0x0BED, WORD_LEN, 0 }, 
{0x099E, 0x008F, WORD_LEN, 0 }, 
{0x098A, 0x0F1B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xC300, WORD_LEN, 0 }, 
{0x0992, 0x04BD, WORD_LEN, 0 }, 
{0x0994, 0x0F43, WORD_LEN, 0 }, 
{0x0996, 0x30EC, WORD_LEN, 0 }, 
{0x0998, 0x048A, WORD_LEN, 0 }, 
{0x099A, 0x02ED, WORD_LEN, 0 }, 
{0x099C, 0x02EC, WORD_LEN, 0 }, 
{0x099E, 0x06ED, WORD_LEN, 0 }, 
{0x098A, 0x0F2B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x008F, WORD_LEN, 0 }, 
{0x0992, 0xC300, WORD_LEN, 0 }, 
{0x0994, 0x02DE, WORD_LEN, 0 }, 
{0x0996, 0x0EAD, WORD_LEN, 0 }, 
{0x0998, 0x0030, WORD_LEN, 0 }, 
{0x099A, 0xEC04, WORD_LEN, 0 }, 
{0x099C, 0xBD0F, WORD_LEN, 0 }, 
{0x099E, 0x7630, WORD_LEN, 0 }, 
{0x098A, 0x0F3B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xED02, WORD_LEN, 0 }, 
{0x0992, 0x3838, WORD_LEN, 0 }, 
{0x0994, 0x3838, WORD_LEN, 0 }, 
{0x0996, 0x3139, WORD_LEN, 0 }, 
{0x0998, 0x3736, WORD_LEN, 0 }, 
{0x099A, 0x30EC, WORD_LEN, 0 }, 
{0x099C, 0x041A, WORD_LEN, 0 }, 
{0x099E, 0x8300, WORD_LEN, 0 }, 
{0x098A, 0x0F4B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x4025, WORD_LEN, 0 }, 
{0x0992, 0x22EC, WORD_LEN, 0 }, 
{0x0994, 0x041A, WORD_LEN, 0 }, 
{0x0996, 0x8300, WORD_LEN, 0 }, 
{0x0998, 0x8024, WORD_LEN, 0 }, 
{0x099A, 0x0504, WORD_LEN, 0 }, 
{0x099C, 0xCA40, WORD_LEN, 0 }, 
{0x099E, 0x2015, WORD_LEN, 0 }, 
{0x098A, 0x0F5B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xEC04, WORD_LEN, 0 }, 
{0x0992, 0x1A83, WORD_LEN, 0 }, 
{0x0994, 0x0100, WORD_LEN, 0 }, 
{0x0996, 0x2406, WORD_LEN, 0 }, 
{0x0998, 0x0404, WORD_LEN, 0 }, 
{0x099A, 0xCA80, WORD_LEN, 0 }, 
{0x099C, 0x2007, WORD_LEN, 0 }, 
{0x099E, 0xEC04, WORD_LEN, 0 }, 
{0x098A, 0x0F6B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0404, WORD_LEN, 0 }, 
{0x0992, 0x04CA, WORD_LEN, 0 }, 
{0x0994, 0xC0EE, WORD_LEN, 0 }, 
{0x0996, 0x00ED, WORD_LEN, 0 }, 
{0x0998, 0x0038, WORD_LEN, 0 }, 
{0x099A, 0x3937, WORD_LEN, 0 }, 
{0x099C, 0x363C, WORD_LEN, 0 }, 
{0x099E, 0x301F, WORD_LEN, 0 }, 
{0x098A, 0x0F7B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0340, WORD_LEN, 0 }, 
{0x0992, 0x0E1F, WORD_LEN, 0 }, 
{0x0994, 0x0380, WORD_LEN, 0 }, 
{0x0996, 0x0AEC, WORD_LEN, 0 }, 
{0x0998, 0x02C4, WORD_LEN, 0 }, 
{0x099A, 0x3F4F, WORD_LEN, 0 }, 
{0x099C, 0x0505, WORD_LEN, 0 }, 
{0x099E, 0x0520, WORD_LEN, 0 }, 
{0x098A, 0x0F8B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x1B1F, WORD_LEN, 0 }, 
{0x0992, 0x0380, WORD_LEN, 0 }, 
{0x0994, 0x09EC, WORD_LEN, 0 }, 
{0x0996, 0x02C4, WORD_LEN, 0 }, 
{0x0998, 0x3F4F, WORD_LEN, 0 }, 
{0x099A, 0x0505, WORD_LEN, 0 }, 
{0x099C, 0x200E, WORD_LEN, 0 }, 
{0x099E, 0x1F03, WORD_LEN, 0 }, 
{0x098A, 0x0F9B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x4008, WORD_LEN, 0 }, 
{0x0992, 0xEC02, WORD_LEN, 0 }, 
{0x0994, 0xC43F, WORD_LEN, 0 }, 
{0x0996, 0x4F05, WORD_LEN, 0 }, 
{0x0998, 0x2002, WORD_LEN, 0 }, 
{0x099A, 0xEC02, WORD_LEN, 0 }, 
{0x099C, 0xED00, WORD_LEN, 0 }, 
{0x099E, 0x3838, WORD_LEN, 0 }, 
{0x098A, 0x8FAB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0039, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098A, 0x1000, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xCC10, WORD_LEN, 0 }, 
{0x0992, 0x09BD, WORD_LEN, 0 }, 
{0x0994, 0x4224, WORD_LEN, 0 }, 
{0x0996, 0x7E10, WORD_LEN, 0 }, 
{0x0998, 0x09C6, WORD_LEN, 0 }, 
{0x099A, 0x01F7, WORD_LEN, 0 }, 
{0x099C, 0x018A, WORD_LEN, 0 }, 
{0x099E, 0xC609, WORD_LEN, 0 }, 
{0x098A, 0x1010, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xF701, WORD_LEN, 0 }, 
{0x0992, 0x8BDE, WORD_LEN, 0 }, 
{0x0994, 0x3F18, WORD_LEN, 0 }, 
{0x0996, 0xCE0B, WORD_LEN, 0 }, 
{0x0998, 0xF3CC, WORD_LEN, 0 }, 
{0x099A, 0x0011, WORD_LEN, 0 }, 
{0x099C, 0xBDD7, WORD_LEN, 0 }, 
{0x099E, 0x00CC, WORD_LEN, 0 }, 
{0x098A, 0x1020, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0BF3, WORD_LEN, 0 }, 
{0x0992, 0xDD3F, WORD_LEN, 0 }, 
{0x0994, 0xDE35, WORD_LEN, 0 }, 
{0x0996, 0x18CE, WORD_LEN, 0 }, 
{0x0998, 0x0C05, WORD_LEN, 0 }, 
{0x099A, 0xCC00, WORD_LEN, 0 }, 
{0x099C, 0x3FBD, WORD_LEN, 0 }, 
{0x099E, 0xD700, WORD_LEN, 0 }, 
{0x098A, 0x1030, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xCC0C, WORD_LEN, 0 }, 
{0x0992, 0x05DD, WORD_LEN, 0 }, 
{0x0994, 0x35DE, WORD_LEN, 0 }, 
{0x0996, 0x4718, WORD_LEN, 0 }, 
{0x0998, 0xCE0C, WORD_LEN, 0 }, 
{0x099A, 0x45CC, WORD_LEN, 0 }, 
{0x099C, 0x0015, WORD_LEN, 0 }, 
{0x099E, 0xBDD7, WORD_LEN, 0 }, 
{0x098A, 0x1040, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x00CC, WORD_LEN, 0 }, 
{0x0992, 0x0C45, WORD_LEN, 0 }, 
{0x0994, 0xDD47, WORD_LEN, 0 }, 
{0x0996, 0xFE00, WORD_LEN, 0 }, 
{0x0998, 0x3318, WORD_LEN, 0 }, 
{0x099A, 0xCE0C, WORD_LEN, 0 }, 
{0x099C, 0x5BCC, WORD_LEN, 0 }, 
{0x099E, 0x0009, WORD_LEN, 0 }, 
{0x098A, 0x1050, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xBDD7, WORD_LEN, 0 }, 
{0x0992, 0x00CC, WORD_LEN, 0 }, 
{0x0994, 0x0C5B, WORD_LEN, 0 }, 
{0x0996, 0xFD00, WORD_LEN, 0 }, 
{0x0998, 0x33DE, WORD_LEN, 0 }, 
{0x099A, 0x3118, WORD_LEN, 0 }, 
{0x099C, 0xCE0C, WORD_LEN, 0 }, 
{0x099E, 0x65CC, WORD_LEN, 0 }, 
{0x098A, 0x1060, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0029, WORD_LEN, 0 }, 
{0x0992, 0xBDD7, WORD_LEN, 0 }, 
{0x0994, 0x00CC, WORD_LEN, 0 }, 
{0x0996, 0x0C65, WORD_LEN, 0 }, 
{0x0998, 0xDD31, WORD_LEN, 0 }, 
{0x099A, 0xDE39, WORD_LEN, 0 }, 
{0x099C, 0x18CE, WORD_LEN, 0 }, 
{0x099E, 0x0C8F, WORD_LEN, 0 }, 
{0x098A, 0x1070, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xCC00, WORD_LEN, 0 }, 
{0x0992, 0x23BD, WORD_LEN, 0 }, 
{0x0994, 0xD700, WORD_LEN, 0 }, 
{0x0996, 0xCC0C, WORD_LEN, 0 }, 
{0x0998, 0x8FDD, WORD_LEN, 0 }, 
{0x099A, 0x39DE, WORD_LEN, 0 }, 
{0x099C, 0x4918, WORD_LEN, 0 }, 
{0x099E, 0xCE0C, WORD_LEN, 0 }, 
{0x098A, 0x1080, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xB3CC, WORD_LEN, 0 }, 
{0x0992, 0x000D, WORD_LEN, 0 }, 
{0x0994, 0xBDD7, WORD_LEN, 0 }, 
{0x0996, 0x00CC, WORD_LEN, 0 }, 
{0x0998, 0x0CB3, WORD_LEN, 0 }, 
{0x099A, 0xDD49, WORD_LEN, 0 }, 
{0x099C, 0xFC04, WORD_LEN, 0 }, 
{0x099E, 0xC2FD, WORD_LEN, 0 }, 
{0x098A, 0x1090, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0BF1, WORD_LEN, 0 }, 
{0x0992, 0x18FE, WORD_LEN, 0 }, 
{0x0994, 0x0BF1, WORD_LEN, 0 }, 
{0x0996, 0xCDEE, WORD_LEN, 0 }, 
{0x0998, 0x1518, WORD_LEN, 0 }, 
{0x099A, 0xCE0C, WORD_LEN, 0 }, 
{0x099C, 0xC1CC, WORD_LEN, 0 }, 
{0x099E, 0x0029, WORD_LEN, 0 }, 
{0x098A, 0x10A0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xBDD7, WORD_LEN, 0 }, 
{0x0992, 0x00FE, WORD_LEN, 0 }, 
{0x0994, 0x0BF1, WORD_LEN, 0 }, 
{0x0996, 0xCC0C, WORD_LEN, 0 }, 
{0x0998, 0xC1ED, WORD_LEN, 0 }, 
{0x099A, 0x15CC, WORD_LEN, 0 }, 
{0x099C, 0x11A5, WORD_LEN, 0 }, 
{0x099E, 0xFD0B, WORD_LEN, 0 }, 
{0x098A, 0x10B0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xFFCC, WORD_LEN, 0 }, 
{0x0992, 0x0CFB, WORD_LEN, 0 }, 
{0x0994, 0xFD0C, WORD_LEN, 0 }, 
{0x0996, 0x21CC, WORD_LEN, 0 }, 
{0x0998, 0x128F, WORD_LEN, 0 }, 
{0x099A, 0xFD0C, WORD_LEN, 0 }, 
{0x099C, 0x53CC, WORD_LEN, 0 }, 
{0x099E, 0x114E, WORD_LEN, 0 }, 
{0x098A, 0x10C0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xFD0C, WORD_LEN, 0 }, 
{0x0992, 0x5DCC, WORD_LEN, 0 }, 
{0x0994, 0x10E2, WORD_LEN, 0 }, 
{0x0996, 0xFD0C, WORD_LEN, 0 }, 
{0x0998, 0x6FCC, WORD_LEN, 0 }, 
{0x099A, 0x0EDD, WORD_LEN, 0 }, 
{0x099C, 0xFD0C, WORD_LEN, 0 }, 
{0x099E, 0xD7CC, WORD_LEN, 0 }, 
{0x098A, 0x10D0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0EBA, WORD_LEN, 0 }, 
{0x0992, 0xFD0C, WORD_LEN, 0 }, 
{0x0994, 0xE9CC, WORD_LEN, 0 }, 
{0x0996, 0x1350, WORD_LEN, 0 }, 
{0x0998, 0xFD0C, WORD_LEN, 0 }, 
{0x099A, 0x9BCC, WORD_LEN, 0 }, 
{0x099C, 0x0E29, WORD_LEN, 0 }, 
{0x099E, 0xFD0C, WORD_LEN, 0 }, 
{0x098A, 0x10E0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xBF39, WORD_LEN, 0 }, 
{0x0992, 0x373C, WORD_LEN, 0 }, 
{0x0994, 0x3CDE, WORD_LEN, 0 }, 
{0x0996, 0x1DEC, WORD_LEN, 0 }, 
{0x0998, 0x0C5F, WORD_LEN, 0 }, 
{0x099A, 0x8402, WORD_LEN, 0 }, 
{0x099C, 0x4416, WORD_LEN, 0 }, 
{0x099E, 0x4FF7, WORD_LEN, 0 }, 
{0x098A, 0x10F0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0CEB, WORD_LEN, 0 }, 
{0x0992, 0xE60B, WORD_LEN, 0 }, 
{0x0994, 0xC407, WORD_LEN, 0 }, 
{0x0996, 0xF70C, WORD_LEN, 0 }, 
{0x0998, 0xEC7F, WORD_LEN, 0 }, 
{0x099A, 0x30C4, WORD_LEN, 0 }, 
{0x099C, 0xEC25, WORD_LEN, 0 }, 
{0x099E, 0xFD30, WORD_LEN, 0 }, 
{0x098A, 0x1100, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xC5FC, WORD_LEN, 0 }, 
{0x0992, 0x06D6, WORD_LEN, 0 }, 
{0x0994, 0xFD30, WORD_LEN, 0 }, 
{0x0996, 0xC701, WORD_LEN, 0 }, 
{0x0998, 0xFC30, WORD_LEN, 0 }, 
{0x099A, 0xC0FD, WORD_LEN, 0 }, 
{0x099C, 0x0BED, WORD_LEN, 0 }, 
{0x099E, 0xFC30, WORD_LEN, 0 }, 
{0x098A, 0x1110, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xC2FD, WORD_LEN, 0 }, 
{0x0992, 0x0BEF, WORD_LEN, 0 }, 
{0x0994, 0xFC04, WORD_LEN, 0 }, 
{0x0996, 0xC283, WORD_LEN, 0 }, 
{0x0998, 0xFFFF, WORD_LEN, 0 }, 
{0x099A, 0x2728, WORD_LEN, 0 }, 
{0x099C, 0xDE06, WORD_LEN, 0 }, 
{0x099E, 0xEC22, WORD_LEN, 0 }, 
{0x098A, 0x1120, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x8322, WORD_LEN, 0 }, 
{0x0992, 0x0026, WORD_LEN, 0 }, 
{0x0994, 0x1FCC, WORD_LEN, 0 }, 
{0x0996, 0x3064, WORD_LEN, 0 }, 
{0x0998, 0x30ED, WORD_LEN, 0 }, 
{0x099A, 0x008F, WORD_LEN, 0 }, 
{0x099C, 0xC300, WORD_LEN, 0 }, 
{0x099E, 0x02DE, WORD_LEN, 0 }, 
{0x098A, 0x1130, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0CAD, WORD_LEN, 0 }, 
{0x0992, 0x0030, WORD_LEN, 0 }, 
{0x0994, 0x1D02, WORD_LEN, 0 }, 
{0x0996, 0x01CC, WORD_LEN, 0 }, 
{0x0998, 0x3064, WORD_LEN, 0 }, 
{0x099A, 0xED00, WORD_LEN, 0 }, 
{0x099C, 0x8FC3, WORD_LEN, 0 }, 
{0x099E, 0x0002, WORD_LEN, 0 }, 
{0x098A, 0x1140, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xDE0E, WORD_LEN, 0 }, 
{0x0992, 0xAD00, WORD_LEN, 0 }, 
{0x0994, 0x30E6, WORD_LEN, 0 }, 
{0x0996, 0x04BD, WORD_LEN, 0 }, 
{0x0998, 0x5203, WORD_LEN, 0 }, 
{0x099A, 0x3838, WORD_LEN, 0 }, 
{0x099C, 0x3139, WORD_LEN, 0 }, 
{0x099E, 0x3C3C, WORD_LEN, 0 }, 
{0x098A, 0x1150, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x3C21, WORD_LEN, 0 }, 
{0x0992, 0x01CC, WORD_LEN, 0 }, 
{0x0994, 0x0018, WORD_LEN, 0 }, 
{0x0996, 0xBD6F, WORD_LEN, 0 }, 
{0x0998, 0xD1C5, WORD_LEN, 0 }, 
{0x099A, 0x0426, WORD_LEN, 0 }, 
{0x099C, 0xF5DC, WORD_LEN, 0 }, 
{0x099E, 0x2530, WORD_LEN, 0 }, 
{0x098A, 0x1160, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xED04, WORD_LEN, 0 }, 
{0x0992, 0x2012, WORD_LEN, 0 }, 
{0x0994, 0xEE04, WORD_LEN, 0 }, 
{0x0996, 0x3C18, WORD_LEN, 0 }, 
{0x0998, 0x38E6, WORD_LEN, 0 }, 
{0x099A, 0x2118, WORD_LEN, 0 }, 
{0x099C, 0xE7BE, WORD_LEN, 0 }, 
{0x099E, 0x30EE, WORD_LEN, 0 }, 
{0x098A, 0x1170, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x04EC, WORD_LEN, 0 }, 
{0x0992, 0x1D30, WORD_LEN, 0 }, 
{0x0994, 0xED04, WORD_LEN, 0 }, 
{0x0996, 0xEC04, WORD_LEN, 0 }, 
{0x0998, 0x26EA, WORD_LEN, 0 }, 
{0x099A, 0xCC00, WORD_LEN, 0 }, 
{0x099C, 0x1AED, WORD_LEN, 0 }, 
{0x099E, 0x02CC, WORD_LEN, 0 }, 
{0x098A, 0x1180, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xFBFF, WORD_LEN, 0 }, 
{0x0992, 0xED00, WORD_LEN, 0 }, 
{0x0994, 0xCC04, WORD_LEN, 0 }, 
{0x0996, 0x00BD, WORD_LEN, 0 }, 
{0x0998, 0x706D, WORD_LEN, 0 }, 
{0x099A, 0xCC00, WORD_LEN, 0 }, 
{0x099C, 0x1A30, WORD_LEN, 0 }, 
{0x099E, 0xED02, WORD_LEN, 0 }, 
{0x098A, 0x1190, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xCCFB, WORD_LEN, 0 }, 
{0x0992, 0xFFED, WORD_LEN, 0 }, 
{0x0994, 0x005F, WORD_LEN, 0 }, 
{0x0996, 0x4FBD, WORD_LEN, 0 }, 
{0x0998, 0x706D, WORD_LEN, 0 }, 
{0x099A, 0x5FBD, WORD_LEN, 0 }, 
{0x099C, 0x5B17, WORD_LEN, 0 }, 
{0x099E, 0xBD55, WORD_LEN, 0 }, 
{0x098A, 0x11A0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x8B38, WORD_LEN, 0 }, 
{0x0992, 0x3838, WORD_LEN, 0 }, 
{0x0994, 0x393C, WORD_LEN, 0 }, 
{0x0996, 0x3CC6, WORD_LEN, 0 }, 
{0x0998, 0x40F7, WORD_LEN, 0 }, 
{0x099A, 0x30C4, WORD_LEN, 0 }, 
{0x099C, 0xFC0B, WORD_LEN, 0 }, 
{0x099E, 0xEDFD, WORD_LEN, 0 }, 
{0x098A, 0x11B0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x30C0, WORD_LEN, 0 }, 
{0x0992, 0xFC0B, WORD_LEN, 0 }, 
{0x0994, 0xEFFD, WORD_LEN, 0 }, 
{0x0996, 0x30C2, WORD_LEN, 0 }, 
{0x0998, 0xDE1D, WORD_LEN, 0 }, 
{0x099A, 0xEC25, WORD_LEN, 0 }, 
{0x099C, 0xFD30, WORD_LEN, 0 }, 
{0x099E, 0xC501, WORD_LEN, 0 }, 
{0x098A, 0x11C0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0101, WORD_LEN, 0 }, 
{0x0992, 0xFC30, WORD_LEN, 0 }, 
{0x0994, 0xC2FD, WORD_LEN, 0 }, 
{0x0996, 0x06D6, WORD_LEN, 0 }, 
{0x0998, 0xEC0C, WORD_LEN, 0 }, 
{0x099A, 0x5F84, WORD_LEN, 0 }, 
{0x099C, 0x0244, WORD_LEN, 0 }, 
{0x099E, 0x164F, WORD_LEN, 0 }, 
{0x098A, 0x11D0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x30E7, WORD_LEN, 0 }, 
{0x0992, 0x03F1, WORD_LEN, 0 }, 
{0x0994, 0x0CEB, WORD_LEN, 0 }, 
{0x0996, 0x2715, WORD_LEN, 0 }, 
{0x0998, 0xF10C, WORD_LEN, 0 }, 
{0x099A, 0xEB23, WORD_LEN, 0 }, 
{0x099C, 0x09FC, WORD_LEN, 0 }, 
{0x099E, 0x06D6, WORD_LEN, 0 }, 
{0x098A, 0x11E0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x04FD, WORD_LEN, 0 }, 
{0x0992, 0x06D6, WORD_LEN, 0 }, 
{0x0994, 0x2007, WORD_LEN, 0 }, 
{0x0996, 0xFC06, WORD_LEN, 0 }, 
{0x0998, 0xD605, WORD_LEN, 0 }, 
{0x099A, 0xFD06, WORD_LEN, 0 }, 
{0x099C, 0xD6DE, WORD_LEN, 0 }, 
{0x099E, 0x1DE6, WORD_LEN, 0 }, 
{0x098A, 0x11F0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0BC4, WORD_LEN, 0 }, 
{0x0992, 0x0730, WORD_LEN, 0 }, 
{0x0994, 0xE702, WORD_LEN, 0 }, 
{0x0996, 0xF10C, WORD_LEN, 0 }, 
{0x0998, 0xEC27, WORD_LEN, 0 }, 
{0x099A, 0x2C7D, WORD_LEN, 0 }, 
{0x099C, 0x0CEC, WORD_LEN, 0 }, 
{0x099E, 0x2727, WORD_LEN, 0 }, 
{0x098A, 0x1200, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x5D27, WORD_LEN, 0 }, 
{0x0992, 0x247F, WORD_LEN, 0 }, 
{0x0994, 0x30C4, WORD_LEN, 0 }, 
{0x0996, 0xFC06, WORD_LEN, 0 }, 
{0x0998, 0xD6FD, WORD_LEN, 0 }, 
{0x099A, 0x30C5, WORD_LEN, 0 }, 
{0x099C, 0xF60C, WORD_LEN, 0 }, 
{0x099E, 0xEC4F, WORD_LEN, 0 }, 
{0x098A, 0x1210, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xFD30, WORD_LEN, 0 }, 
{0x0992, 0xC7C6, WORD_LEN, 0 }, 
{0x0994, 0x40F7, WORD_LEN, 0 }, 
{0x0996, 0x30C4, WORD_LEN, 0 }, 
{0x0998, 0xE602, WORD_LEN, 0 }, 
{0x099A, 0x4FFD, WORD_LEN, 0 }, 
{0x099C, 0x30C5, WORD_LEN, 0 }, 
{0x099E, 0x0101, WORD_LEN, 0 }, 
{0x098A, 0x1220, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x01FC, WORD_LEN, 0 }, 
{0x0992, 0x30C2, WORD_LEN, 0 }, 
{0x0994, 0xFD06, WORD_LEN, 0 }, 
{0x0996, 0xD67D, WORD_LEN, 0 }, 
{0x0998, 0x06CB, WORD_LEN, 0 }, 
{0x099A, 0x272E, WORD_LEN, 0 }, 
{0x099C, 0xC640, WORD_LEN, 0 }, 
{0x099E, 0xF730, WORD_LEN, 0 }, 
{0x098A, 0x1230, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xC4FC, WORD_LEN, 0 }, 
{0x0992, 0x06C1, WORD_LEN, 0 }, 
{0x0994, 0x04F3, WORD_LEN, 0 }, 
{0x0996, 0x06D6, WORD_LEN, 0 }, 
{0x0998, 0xED00, WORD_LEN, 0 }, 
{0x099A, 0x5F6D, WORD_LEN, 0 }, 
{0x099C, 0x002A, WORD_LEN, 0 }, 
{0x099E, 0x0153, WORD_LEN, 0 }, 
{0x098A, 0x1240, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x17FD, WORD_LEN, 0 }, 
{0x0992, 0x30C0, WORD_LEN, 0 }, 
{0x0994, 0xEC00, WORD_LEN, 0 }, 
{0x0996, 0xFD30, WORD_LEN, 0 }, 
{0x0998, 0xC2FC, WORD_LEN, 0 }, 
{0x099A, 0x06C1, WORD_LEN, 0 }, 
{0x099C, 0xFD30, WORD_LEN, 0 }, 
{0x099E, 0xC501, WORD_LEN, 0 }, 
{0x098A, 0x1250, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0101, WORD_LEN, 0 }, 
{0x0992, 0xFC30, WORD_LEN, 0 }, 
{0x0994, 0xC2FD, WORD_LEN, 0 }, 
{0x0996, 0x06C7, WORD_LEN, 0 }, 
{0x0998, 0x2022, WORD_LEN, 0 }, 
{0x099A, 0x7F30, WORD_LEN, 0 }, 
{0x099C, 0xC4DE, WORD_LEN, 0 }, 
{0x099E, 0x1DEC, WORD_LEN, 0 }, 
{0x098A, 0x1260, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x25FD, WORD_LEN, 0 }, 
{0x0992, 0x30C5, WORD_LEN, 0 }, 
{0x0994, 0xFC06, WORD_LEN, 0 }, 
{0x0996, 0xD6FD, WORD_LEN, 0 }, 
{0x0998, 0x30C7, WORD_LEN, 0 }, 
{0x099A, 0x01FC, WORD_LEN, 0 }, 
{0x099C, 0x30C0, WORD_LEN, 0 }, 
{0x099E, 0xFD06, WORD_LEN, 0 }, 
{0x098A, 0x1270, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xD0FC, WORD_LEN, 0 }, 
{0x0992, 0x30C2, WORD_LEN, 0 }, 
{0x0994, 0xFD06, WORD_LEN, 0 }, 
{0x0996, 0xD2EC, WORD_LEN, 0 }, 
{0x0998, 0x25FD, WORD_LEN, 0 }, 
{0x099A, 0x06C3, WORD_LEN, 0 }, 
{0x099C, 0xBD95, WORD_LEN, 0 }, 
{0x099E, 0x3CDE, WORD_LEN, 0 }, 
{0x098A, 0x1280, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x3FEE, WORD_LEN, 0 }, 
{0x0992, 0x10AD, WORD_LEN, 0 }, 
{0x0994, 0x00DE, WORD_LEN, 0 }, 
{0x0996, 0x1DFC, WORD_LEN, 0 }, 
{0x0998, 0x06CC, WORD_LEN, 0 }, 
{0x099A, 0xED3E, WORD_LEN, 0 }, 
{0x099C, 0x3838, WORD_LEN, 0 }, 
{0x099E, 0x3930, WORD_LEN, 0 }, 
{0x098A, 0x1290, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x8FC3, WORD_LEN, 0 }, 
{0x0992, 0xFFEC, WORD_LEN, 0 }, 
{0x0994, 0x8F35, WORD_LEN, 0 }, 
{0x0996, 0xBDAD, WORD_LEN, 0 }, 
{0x0998, 0x15DE, WORD_LEN, 0 }, 
{0x099A, 0x198F, WORD_LEN, 0 }, 
{0x099C, 0xC301, WORD_LEN, 0 }, 
{0x099E, 0x4B8F, WORD_LEN, 0 }, 
{0x098A, 0x12A0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xEC00, WORD_LEN, 0 }, 
{0x0992, 0xFD05, WORD_LEN, 0 }, 
{0x0994, 0x0EEC, WORD_LEN, 0 }, 
{0x0996, 0x02FD, WORD_LEN, 0 }, 
{0x0998, 0x0510, WORD_LEN, 0 }, 
{0x099A, 0x8FC3, WORD_LEN, 0 }, 
{0x099C, 0xFFCB, WORD_LEN, 0 }, 
{0x099E, 0x8FE6, WORD_LEN, 0 }, 
{0x098A, 0x12B0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x00F7, WORD_LEN, 0 }, 
{0x0992, 0x0514, WORD_LEN, 0 }, 
{0x0994, 0xE603, WORD_LEN, 0 }, 
{0x0996, 0xF705, WORD_LEN, 0 }, 
{0x0998, 0x15FC, WORD_LEN, 0 }, 
{0x099A, 0x055B, WORD_LEN, 0 }, 
{0x099C, 0xFD05, WORD_LEN, 0 }, 
{0x099E, 0x12DE, WORD_LEN, 0 }, 
{0x098A, 0x12C0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x37EE, WORD_LEN, 0 }, 
{0x0992, 0x08AD, WORD_LEN, 0 }, 
{0x0994, 0x00F6, WORD_LEN, 0 }, 
{0x0996, 0x0516, WORD_LEN, 0 }, 
{0x0998, 0x4F30, WORD_LEN, 0 }, 
{0x099A, 0xED04, WORD_LEN, 0 }, 
{0x099C, 0xDE1F, WORD_LEN, 0 }, 
{0x099E, 0xEC6B, WORD_LEN, 0 }, 
{0x098A, 0x12D0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xFD05, WORD_LEN, 0 }, 
{0x0992, 0x0EEC, WORD_LEN, 0 }, 
{0x0994, 0x6DFD, WORD_LEN, 0 }, 
{0x0996, 0x0510, WORD_LEN, 0 }, 
{0x0998, 0xDE19, WORD_LEN, 0 }, 
{0x099A, 0x8FC3, WORD_LEN, 0 }, 
{0x099C, 0x0117, WORD_LEN, 0 }, 
{0x099E, 0x8FE6, WORD_LEN, 0 }, 
{0x098A, 0x12E0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x00F7, WORD_LEN, 0 }, 
{0x0992, 0x0514, WORD_LEN, 0 }, 
{0x0994, 0xE603, WORD_LEN, 0 }, 
{0x0996, 0xF705, WORD_LEN, 0 }, 
{0x0998, 0x15FC, WORD_LEN, 0 }, 
{0x099A, 0x0559, WORD_LEN, 0 }, 
{0x099C, 0xFD05, WORD_LEN, 0 }, 
{0x099E, 0x12DE, WORD_LEN, 0 }, 
{0x098A, 0x12F0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x37EE, WORD_LEN, 0 }, 
{0x0992, 0x08AD, WORD_LEN, 0 }, 
{0x0994, 0x00F6, WORD_LEN, 0 }, 
{0x0996, 0x0516, WORD_LEN, 0 }, 
{0x0998, 0x4F30, WORD_LEN, 0 }, 
{0x099A, 0xED06, WORD_LEN, 0 }, 
{0x099C, 0xDE1F, WORD_LEN, 0 }, 
{0x099E, 0xEC6B, WORD_LEN, 0 }, 
{0x098A, 0x1300, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xFD05, WORD_LEN, 0 }, 
{0x0992, 0x0EEC, WORD_LEN, 0 }, 
{0x0994, 0x6DFD, WORD_LEN, 0 }, 
{0x0996, 0x0510, WORD_LEN, 0 }, 
{0x0998, 0xDE19, WORD_LEN, 0 }, 
{0x099A, 0x8FC3, WORD_LEN, 0 }, 
{0x099C, 0x0118, WORD_LEN, 0 }, 
{0x099E, 0x8FE6, WORD_LEN, 0 }, 
{0x098A, 0x1310, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x00F7, WORD_LEN, 0 }, 
{0x0992, 0x0514, WORD_LEN, 0 }, 
{0x0994, 0xE603, WORD_LEN, 0 }, 
{0x0996, 0xF705, WORD_LEN, 0 }, 
{0x0998, 0x15FC, WORD_LEN, 0 }, 
{0x099A, 0x0559, WORD_LEN, 0 }, 
{0x099C, 0xFD05, WORD_LEN, 0 }, 
{0x099E, 0x12DE, WORD_LEN, 0 }, 
{0x098A, 0x1320, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x37EE, WORD_LEN, 0 }, 
{0x0992, 0x08AD, WORD_LEN, 0 }, 
{0x0994, 0x00F6, WORD_LEN, 0 }, 
{0x0996, 0x0516, WORD_LEN, 0 }, 
{0x0998, 0x4F30, WORD_LEN, 0 }, 
{0x099A, 0xED08, WORD_LEN, 0 }, 
{0x099C, 0xCC32, WORD_LEN, 0 }, 
{0x099E, 0x8EED, WORD_LEN, 0 }, 
{0x098A, 0x1330, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x00EC, WORD_LEN, 0 }, 
{0x0992, 0x04BD, WORD_LEN, 0 }, 
{0x0994, 0x7021, WORD_LEN, 0 }, 
{0x0996, 0xCC32, WORD_LEN, 0 }, 
{0x0998, 0x6C30, WORD_LEN, 0 }, 
{0x099A, 0xED02, WORD_LEN, 0 }, 
{0x099C, 0xCCF8, WORD_LEN, 0 }, 
{0x099E, 0x00ED, WORD_LEN, 0 }, 
{0x098A, 0x1340, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x00A6, WORD_LEN, 0 }, 
{0x0992, 0x07E3, WORD_LEN, 0 }, 
{0x0994, 0x0884, WORD_LEN, 0 }, 
{0x0996, 0x07BD, WORD_LEN, 0 }, 
{0x0998, 0x706D, WORD_LEN, 0 }, 
{0x099A, 0x30C6, WORD_LEN, 0 }, 
{0x099C, 0x143A, WORD_LEN, 0 }, 
{0x099E, 0x3539, WORD_LEN, 0 }, 
{0x098A, 0x1350, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x3CBD, WORD_LEN, 0 }, 
{0x0992, 0x776D, WORD_LEN, 0 }, 
{0x0994, 0xCC32, WORD_LEN, 0 }, 
{0x0996, 0x5C30, WORD_LEN, 0 }, 
{0x0998, 0xED00, WORD_LEN, 0 }, 
{0x099A, 0xFC13, WORD_LEN, 0 }, 
{0x099C, 0x8683, WORD_LEN, 0 }, 
{0x099E, 0x0001, WORD_LEN, 0 }, 
{0x098A, 0x1360, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xBD70, WORD_LEN, 0 }, 
{0x0992, 0x21CC, WORD_LEN, 0 }, 
{0x0994, 0x325E, WORD_LEN, 0 }, 
{0x0996, 0x30ED, WORD_LEN, 0 }, 
{0x0998, 0x00FC, WORD_LEN, 0 }, 
{0x099A, 0x1388, WORD_LEN, 0 }, 
{0x099C, 0x8300, WORD_LEN, 0 }, 
{0x099E, 0x01BD, WORD_LEN, 0 }, 
{0x098A, 0x1370, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x7021, WORD_LEN, 0 }, 
{0x0992, 0x3839, WORD_LEN, 0 }, 
{0x098E, 0x0010, WORD_LEN, 0 },  	// MCU_ADDRESS [MON_ADDR]
{0x0990, 0x1000, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x0003, WORD_LEN, 0 },  	// MCU_ADDRESS [MON_ALGO]
{0x0990, 0x0004, WORD_LEN, 0 },  	// MCU_DATA_0
{ SEQUENCE_WAIT_MS,10, WORD_LEN, 0},
//  POLL  MON_PATCH_0 =>  0x01
{0x098E, 0x4815, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0004, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x485D, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0004, WORD_LEN, 0 },  	// MCU_DATA_0
{0x0018, 0x0028, WORD_LEN, 0 },  	// STANDBY_CONTROL_AND_STATUS
//  POLL  SEQ_STATE =>  0x01, 0x02, ..., 0x03 (11 reads)
{ SEQUENCE_WAIT_MS,10, WORD_LEN, 0},

//af

{0x098E, 0x4403, WORD_LEN, 0 }, 
{0x0990, 0x8001, WORD_LEN, 0 }, 
{0x098E, 0x440B, WORD_LEN, 0 }, 
{0x0990, 0x0032, WORD_LEN, 0 }, 
{0x098E, 0x440D, WORD_LEN, 0 }, 
{0x0990, 0x03B6, WORD_LEN, 0 }, 
{0x098E, 0x8400, WORD_LEN, 0 }, 
{0x0990, 0x0006, WORD_LEN, 0 }, 


//[Lens Correction 90% 05/09/11 15:36:26]
{0x3640, 0x0790, WORD_LEN, 0 },  	// P_G1_P0Q0
{0x3642, 0x078B, WORD_LEN, 0 },  	// P_G1_P0Q1
{0x3644, 0x3751, WORD_LEN, 0 },  	// P_G1_P0Q2
{0x3646, 0x66ED, WORD_LEN, 0 },  	// P_G1_P0Q3
{0x3648, 0xCB51, WORD_LEN, 0 },  	// P_G1_P0Q4
{0x364A, 0x00B0, WORD_LEN, 0 },  	// P_R_P0Q0
{0x364C, 0x2BCA, WORD_LEN, 0 },  	// P_R_P0Q1
{0x364E, 0x69D1, WORD_LEN, 0 },  	// P_R_P0Q2
{0x3650, 0x140E, WORD_LEN, 0 },  	// P_R_P0Q3
{0x3652, 0x98B1, WORD_LEN, 0 },  	// P_R_P0Q4
{0x3654, 0x00F0, WORD_LEN, 0 },  	// P_B_P0Q0
{0x3656, 0x47A9, WORD_LEN, 0 },  	// P_B_P0Q1
{0x3658, 0x7690, WORD_LEN, 0 },  	// P_B_P0Q2
{0x365A, 0x44CE, WORD_LEN, 0 },  	// P_B_P0Q3
{0x365C, 0x044C, WORD_LEN, 0 },  	// P_B_P0Q4
{0x365E, 0x0170, WORD_LEN, 0 },  	// P_G2_P0Q0
{0x3660, 0x3BAB, WORD_LEN, 0 },  	// P_G2_P0Q1
{0x3662, 0x2F31, WORD_LEN, 0 },  	// P_G2_P0Q2
{0x3664, 0x6A8C, WORD_LEN, 0 },  	// P_G2_P0Q3
{0x3666, 0xC811, WORD_LEN, 0 },  	// P_G2_P0Q4
{0x3680, 0xFD8A, WORD_LEN, 0 },  	// P_G1_P1Q0
{0x3682, 0xAC6F, WORD_LEN, 0 },  	// P_G1_P1Q1
{0x3684, 0x1EEE, WORD_LEN, 0 },  	// P_G1_P1Q2
{0x3686, 0x67B0, WORD_LEN, 0 },  	// P_G1_P1Q3
{0x3688, 0xF30F, WORD_LEN, 0 },  	// P_G1_P1Q4
{0x368A, 0x98CC, WORD_LEN, 0 },  	// P_R_P1Q0
{0x368C, 0x1AEF, WORD_LEN, 0 },  	// P_R_P1Q1
{0x368E, 0x01B0, WORD_LEN, 0 },  	// P_R_P1Q2
{0x3690, 0x3C8C, WORD_LEN, 0 },  	// P_R_P1Q3
{0x3692, 0x93F2, WORD_LEN, 0 },  	// P_R_P1Q4
{0x3694, 0x5808, WORD_LEN, 0 },  	// P_B_P1Q0
{0x3696, 0xA12F, WORD_LEN, 0 },  	// P_B_P1Q1
{0x3698, 0x1B8F, WORD_LEN, 0 },  	// P_B_P1Q2
{0x369A, 0x37D1, WORD_LEN, 0 },  	// P_B_P1Q3
{0x369C, 0xF931, WORD_LEN, 0 },  	// P_B_P1Q4
{0x369E, 0x128A, WORD_LEN, 0 },  	// P_G2_P1Q0
{0x36A0, 0x064F, WORD_LEN, 0 },  	// P_G2_P1Q1
{0x36A2, 0x2AAE, WORD_LEN, 0 },  	// P_G2_P1Q2
{0x36A4, 0xBE0F, WORD_LEN, 0 },  	// P_G2_P1Q3
{0x36A6, 0xEE90, WORD_LEN, 0 },  	// P_G2_P1Q4
{0x36C0, 0x1D12, WORD_LEN, 0 },  	// P_G1_P2Q0
{0x36C2, 0x95AB, WORD_LEN, 0 },  	// P_G1_P2Q1
{0x36C4, 0xDD8B, WORD_LEN, 0 },  	// P_G1_P2Q2
{0x36C6, 0x1EAC, WORD_LEN, 0 },  	// P_G1_P2Q3
{0x36C8, 0xC494, WORD_LEN, 0 },  	// P_G1_P2Q4
{0x36CA, 0x4A32, WORD_LEN, 0 },  	// P_R_P2Q0
{0x36CC, 0xB34E, WORD_LEN, 0 },  	// P_R_P2Q1
{0x36CE, 0x2691, WORD_LEN, 0 },  	// P_R_P2Q2
{0x36D0, 0x1BB1, WORD_LEN, 0 },  	// P_R_P2Q3
{0x36D2, 0xC7D5, WORD_LEN, 0 },  	// P_R_P2Q4
{0x36D4, 0x0EB2, WORD_LEN, 0 },  	// P_B_P2Q0
{0x36D6, 0xB42E, WORD_LEN, 0 },  	// P_B_P2Q1
{0x36D8, 0x0AB2, WORD_LEN, 0 },  	// P_B_P2Q2
{0x36DA, 0x08F1, WORD_LEN, 0 },  	// P_B_P2Q3
{0x36DC, 0xA295, WORD_LEN, 0 },  	// P_B_P2Q4
{0x36DE, 0x2112, WORD_LEN, 0 },  	// P_G2_P2Q0
{0x36E0, 0xBF2D, WORD_LEN, 0 },  	// P_G2_P2Q1
{0x36E2, 0x1E70, WORD_LEN, 0 },  	// P_G2_P2Q2
{0x36E4, 0xB36D, WORD_LEN, 0 },  	// P_G2_P2Q3
{0x36E6, 0x8275, WORD_LEN, 0 },  	// P_G2_P2Q4
{0x3700, 0xA86D, WORD_LEN, 0 },  	// P_G1_P3Q0
{0x3702, 0xF40E, WORD_LEN, 0 },  	// P_G1_P3Q1
{0x3704, 0xDE0F, WORD_LEN, 0 },  	// P_G1_P3Q2
{0x3706, 0x6790, WORD_LEN, 0 },  	// P_G1_P3Q3
{0x3708, 0x2A72, WORD_LEN, 0 },  	// P_G1_P3Q4
{0x370A, 0xE9CF, WORD_LEN, 0 },  	// P_R_P3Q0
{0x370C, 0x6C0F, WORD_LEN, 0 },  	// P_R_P3Q1
{0x370E, 0x2F30, WORD_LEN, 0 },  	// P_R_P3Q2
{0x3710, 0xDD33, WORD_LEN, 0 },  	// P_R_P3Q3
{0x3712, 0x64D1, WORD_LEN, 0 },  	// P_R_P3Q4
{0x3714, 0x974E, WORD_LEN, 0 },  	// P_B_P3Q0
{0x3716, 0x3A0E, WORD_LEN, 0 },  	// P_B_P3Q1
{0x3718, 0x580F, WORD_LEN, 0 },  	// P_B_P3Q2
{0x371A, 0xB0D0, WORD_LEN, 0 },  	// P_B_P3Q3
{0x371C, 0x17B3, WORD_LEN, 0 },  	// P_B_P3Q4
{0x371E, 0xA0CD, WORD_LEN, 0 },  	// P_G2_P3Q0
{0x3720, 0x1070, WORD_LEN, 0 },  	// P_G2_P3Q1
{0x3722, 0xD9D1, WORD_LEN, 0 },  	// P_G2_P3Q2
{0x3724, 0xC733, WORD_LEN, 0 },  	// P_G2_P3Q3
{0x3726, 0x7B93, WORD_LEN, 0 },  	// P_G2_P3Q4
{0x3740, 0xE870, WORD_LEN, 0 },  	// P_G1_P4Q0
{0x3742, 0x854A, WORD_LEN, 0 },  	// P_G1_P4Q1
{0x3744, 0xA936, WORD_LEN, 0 },  	// P_G1_P4Q2
{0x3746, 0xADF2, WORD_LEN, 0 },  	// P_G1_P4Q3
{0x3748, 0x2538, WORD_LEN, 0 },  	// P_G1_P4Q4
{0x374A, 0x9651, WORD_LEN, 0 },  	// P_R_P4Q0
{0x374C, 0x06D1, WORD_LEN, 0 },  	// P_R_P4Q1
{0x374E, 0xE676, WORD_LEN, 0 },  	// P_R_P4Q2
{0x3750, 0xC494, WORD_LEN, 0 },  	// P_R_P4Q3
{0x3752, 0x6318, WORD_LEN, 0 },  	// P_R_P4Q4
{0x3754, 0x0A0F, WORD_LEN, 0 },  	// P_B_P4Q0
{0x3756, 0x1DB2, WORD_LEN, 0 },  	// P_B_P4Q1
{0x3758, 0xBA36, WORD_LEN, 0 },  	// P_B_P4Q2
{0x375A, 0xC5D4, WORD_LEN, 0 },  	// P_B_P4Q3
{0x375C, 0x37B8, WORD_LEN, 0 },  	// P_B_P4Q4
{0x375E, 0x93B1, WORD_LEN, 0 },  	// P_G2_P4Q0
{0x3760, 0xBFAE, WORD_LEN, 0 },  	// P_G2_P4Q1
{0x3762, 0xC1B6, WORD_LEN, 0 },  	// P_G2_P4Q2
{0x3764, 0xB311, WORD_LEN, 0 },  	// P_G2_P4Q3
{0x3766, 0x3E98, WORD_LEN, 0 },  	// P_G2_P4Q4
{0x3782, 0x0304, WORD_LEN, 0 },  	// CENTER_ROW
{0x3784, 0x0404, WORD_LEN, 0 },  	// CENTER_COLUMN
{0x3210, 0x0008, WORD_LEN, 0 },  //PGA_ENABLE



//[PA Default]
{0x3C20, 0x0000, WORD_LEN, 0 },  	 // TX_SS_CONTROL
//[Brightness_Metric]
{0x3210, 0x01B8, WORD_LEN, 0 },  	 // COLOR_PIPELINE_CONTROL
{0x098E, 0xC913, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_STAT_BRIGHTNESS_METRIC_PREDIVIDER]
{0x0990, 0x000A, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x686B, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_A_CONFIG_LL_START_BRIGHTNESS]
{0x0990, 0x05DC, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x686D, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_A_CONFIG_LL_STOP_BRIGHTNESS]
{0x0990, 0x0BB8, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x6C6B, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_B_CONFIG_LL_START_BRIGHTNESS]
{0x0990, 0x05DC, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x6C6D, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_B_CONFIG_LL_STOP_BRIGHTNESS]
{0x0990, 0x0BB8, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x3439, WORD_LEN, 0 },  	 // MCU_ADDRESS [AS_ASSTART_BRIGHTNESS]
{0x0990, 0x05DC, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x343B, WORD_LEN, 0 },  	 // MCU_ADDRESS [AS_ASSTOP_BRIGHTNESS]
{0x0990, 0x0BB8, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x4926, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_START_GAMMA_BM]
{0x0990, 0x0001, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x4928, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_MID_GAMMA_BM]
{0x0990, 0x0002, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x492A, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_STOP_GAMMA_BM]
{0x0990, 0x0656, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x4D26, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM2_LL_START_GAMMA_BM]
{0x0990, 0x0001, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x4D28, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM2_LL_MID_GAMMA_BM]
{0x0990, 0x0002, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x4D2A, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM2_LL_STOP_GAMMA_BM]
{0x0990, 0x0656, WORD_LEN, 0 },  	 // MCU_DATA_0


//[FW kernel]
{0x33F4, 0x040B, WORD_LEN, 0 },  	 // KERNEL_CONFIG


//[Demosaic]
{0x098E, 0xC916, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_LL_START_0]
{0x0990, 0x0014, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xC919, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_LL_STOP_0]
{0x0990, 0x0028, WORD_LEN, 0 },  	 // MCU_DATA_0




//[Aperture]
{0x098E, 0xC917, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_LL_START_1]
{0x0990, 0x0004, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xC918, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_LL_START_2]
{0x0990, 0x0000, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xC91A, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_LL_STOP_1]
{0x0990, 0x0001, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xC91B, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_LL_STOP_2]
{0x0990, 0x0009, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x326C, 0x0C00, WORD_LEN, 0 },  	 // APERTURE_PARAMETERS_2D

{0x098E, 0x6865, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_A_CONFIG_LL_ALGO_ENTER]
{0x0990, 0x00E0, WORD_LEN, 0 },  	 // MCU_DATA_0
//{0x098E, 0x6C65, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_B_CONFIG_LL_ALGO_ENTER]
//{0x0990, 0x00E0, WORD_LEN, 0 },  	 // MCU_DATA_0



//Noise reduction RN compensation

{0x098E, 0x494B, WORD_LEN, 0 },      // MCU_ADDRESS [CAM1_LL_EXT_START_GAIN_METRIC]
{0x0990, 0x0042, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0x494D, WORD_LEN, 0 },      // MCU_ADDRESS [CAM1_LL_EXT_STOP_GAIN_METRIC]
{0x0990, 0x012C, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xC91E, WORD_LEN, 0 },      // MCU_ADDRESS [CAM1_LL_NR_START_0]
{0x0990, 0x0012, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xC91F, WORD_LEN, 0 },      // MCU_ADDRESS [CAM1_LL_NR_START_1]
{0x0990, 0x000A, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xC920, WORD_LEN, 0 },      // MCU_ADDRESS [CAM1_LL_NR_START_2]
{0x0990, 0x0012, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xC921, WORD_LEN, 0 },      // MCU_ADDRESS [CAM1_LL_NR_START_3]
{0x0990, 0x000A, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xC922, WORD_LEN, 0 },      // MCU_ADDRESS [CAM1_LL_NR_STOP_0]
{0x0990, 0x0026, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xC923, WORD_LEN, 0 },      // MCU_ADDRESS [CAM1_LL_NR_STOP_1]
{0x0990, 0x001E, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xC924, WORD_LEN, 0 },      // MCU_ADDRESS [CAM1_LL_NR_STOP_2]
{0x0990, 0x0026, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xC925, WORD_LEN, 0 },      // MCU_ADDRESS [CAM1_LL_NR_STOP_3]
{0x0990, 0x0026, WORD_LEN, 0 },      // MCU_DATA_0
{0x316C, 0x350F, WORD_LEN, 0 },      // DAC_TXLO
//Noise Reduction
{0x098E, 0xBC31, WORD_LEN, 0 },      // MCU_ADDRESS [LL_GAMMA_NRCURVE_0]
{0x0990, 0x0000, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xBC32, WORD_LEN, 0 },      // MCU_ADDRESS [LL_GAMMA_NRCURVE_1]
{0x0990, 0x000D, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xBC33, WORD_LEN, 0 },      // MCU_ADDRESS [LL_GAMMA_NRCURVE_2]
{0x0990, 0x0019, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xBC34, WORD_LEN, 0 },      // MCU_ADDRESS [LL_GAMMA_NRCURVE_3]
{0x0990, 0x0030, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xBC35, WORD_LEN, 0 },      // MCU_ADDRESS [LL_GAMMA_NRCURVE_4]
{0x0990, 0x0056, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xBC36, WORD_LEN, 0 },      // MCU_ADDRESS [LL_GAMMA_NRCURVE_5]
{0x0990, 0x0070, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xBC37, WORD_LEN, 0 },      // MCU_ADDRESS [LL_GAMMA_NRCURVE_6]
{0x0990, 0x0081, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xBC38, WORD_LEN, 0 },      // MCU_ADDRESS [LL_GAMMA_NRCURVE_7]
{0x0990, 0x0090, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xBC39, WORD_LEN, 0 },      // MCU_ADDRESS [LL_GAMMA_NRCURVE_8]
{0x0990, 0x009E, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xBC3A, WORD_LEN, 0 },      // MCU_ADDRESS [LL_GAMMA_NRCURVE_9]
{0x0990, 0x00AB, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xBC3B, WORD_LEN, 0 },      // MCU_ADDRESS [LL_GAMMA_NRCURVE_10]
{0x0990, 0x00B6, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xBC3C, WORD_LEN, 0 },      // MCU_ADDRESS [LL_GAMMA_NRCURVE_11]
{0x0990, 0x00C1, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xBC3D, WORD_LEN, 0 },      // MCU_ADDRESS [LL_GAMMA_NRCURVE_12]
{0x0990, 0x00CB, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xBC3E, WORD_LEN, 0 },      // MCU_ADDRESS [LL_GAMMA_NRCURVE_13]
{0x0990, 0x00D5, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xBC3F, WORD_LEN, 0 },      // MCU_ADDRESS [LL_GAMMA_NRCURVE_14]
{0x0990, 0x00DE, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xBC40, WORD_LEN, 0 },      // MCU_ADDRESS [LL_GAMMA_NRCURVE_15]
{0x0990, 0x00E7, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xBC41, WORD_LEN, 0 },      // MCU_ADDRESS [LL_GAMMA_NRCURVE_16]
{0x0990, 0x00EF, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xBC42, WORD_LEN, 0 },      // MCU_ADDRESS [LL_GAMMA_NRCURVE_17]
{0x0990, 0x00F7, WORD_LEN, 0 },      // MCU_DATA_0
{0x098E, 0xBC43, WORD_LEN, 0 },      // MCU_ADDRESS [LL_GAMMA_NRCURVE_18]
{0x0990, 0x00FF, WORD_LEN, 0 },      // MCU_DATA_0







//[Defect correction]


{0x098E, 0xBC02, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_MODE]
{0x0990, 0x0003, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x6867, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_A_CONFIG_LL_ALGO_RUN]
{0x0990, 0x00F4, WORD_LEN, 0 },  	 // MCU_DATA_0

{0x098E, 0xBC05, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_CLUSTER_DC_TH]
{0x0990, 0x000E, WORD_LEN, 0 },  	 // MCU_DATA_0

{0x098E, 0x8400, WORD_LEN, 0 }, 	 // MCU_ADDRESS [SEQ_CMD]
{0x0990, 0x0006, WORD_LEN, 0 }, 	 // MCU_DATA_0



//[Position dependent GRB]
{0x098E, 0xC950, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_START_1]
{0x0990, 0x0064, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xC94F, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_START_0]
{0x0990, 0x0038, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xC952, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_START_3]
{0x0990, 0x0064, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xC951, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_START_2]
{0x0990, 0x0051, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xC954, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_START_5]
{0x0990, 0x0010, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xC953, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_START_4]
{0x0990, 0x0020, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xC956, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_START_7]
{0x0990, 0x0010, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xC955, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_START_6]
{0x0990, 0x0020, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xC958, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_STOP_1]
{0x0990, 0x0020, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xC957, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_STOP_0]
{0x0990, 0x0014, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xC95A, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_STOP_3]
{0x0990, 0x001D, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xC959, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_STOP_2]
{0x0990, 0x0020, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xC95C, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_STOP_5]
{0x0990, 0x000C, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xC95B, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_STOP_4]
{0x0990, 0x0008, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xC95E, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_STOP_7]
{0x0990, 0x000C, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xC95D, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_EXT_GRB_THRESHOLDS_STOP_6]
{0x0990, 0x0008, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xC95F, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_EXT_GRB_WINDOW_PERCENT]
{0x0990, 0x0064, WORD_LEN, 0 },  	 // MCU_DATA_0


//[dark delta ccm settings]
//[grayscale unity]
{0x098E, 0x48DC, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_AWB_LL_CCM_0]
{0x0990, 0x004D, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x48DE, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_AWB_LL_CCM_1]
{0x0990, 0x0096, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x48E0, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_AWB_LL_CCM_2]
{0x0990, 0x001D, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x48E2, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_AWB_LL_CCM_3]
{0x0990, 0x004D, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x48E4, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_AWB_LL_CCM_4]
{0x0990, 0x0096, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x48E6, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_AWB_LL_CCM_5]
{0x0990, 0x001D, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x48E8, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_AWB_LL_CCM_6]
{0x0990, 0x004D, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x48EA, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_AWB_LL_CCM_7]
{0x0990, 0x0096, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x48EC, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_AWB_LL_CCM_8]
{0x0990, 0x001D, WORD_LEN, 0 },  	 // MCU_DATA_0


//[darkccm_range_rev3]
{0x098E, 0xDC2A, WORD_LEN, 0 },  	 // MCU_ADDRESS [SYS_DELTA_GAIN]
{0x0990, 0x000B, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xDC2B, WORD_LEN, 0 },  	 // MCU_ADDRESS [SYS_DELTA_THRESH]
{0x0990, 0x0017, WORD_LEN, 0 },  	 // MCU_DATA_0



//[Gamma Correction sRGB]
{0x098E, 0xBC0B, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_0]
{0x0990, 0x0000, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC0C, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_1]
{0x0990, 0x001B, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC0D, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_2]
{0x0990, 0x002A, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC0E, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_3]
{0x0990, 0x003E, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC0F, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_4]
{0x0990, 0x005A, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC10, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_5]
{0x0990, 0x0070, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC11, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_6]
{0x0990, 0x0081, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC12, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_7]
{0x0990, 0x0090, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC13, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_8]
{0x0990, 0x009E, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC14, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_9]
{0x0990, 0x00AB, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC15, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_10]
{0x0990, 0x00B6, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC16, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_11]
{0x0990, 0x00C1, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC17, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_12]
{0x0990, 0x00CB, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC18, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_13]
{0x0990, 0x00D5, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC19, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_14]
{0x0990, 0x00DE, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC1A, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_15]
{0x0990, 0x00E7, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC1B, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_16]
{0x0990, 0x00EF, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC1C, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_17]
{0x0990, 0x00F7, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC1D, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_18]
{0x0990, 0x00FF, WORD_LEN, 0 },  	 // MCU_DATA_0

{0x098E, 0xBC1E, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_0]
{0x0990, 0x0000, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC1F, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_1]
{0x0990, 0x001B, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC20, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_2]
{0x0990, 0x002A, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC21, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_3]
{0x0990, 0x003E, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC22, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_4]
{0x0990, 0x005A, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC23, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_5]
{0x0990, 0x0070, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC24, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_6]
{0x0990, 0x0081, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC25, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_7]
{0x0990, 0x0090, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC26, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_8]
{0x0990, 0x009E, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC27, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_9]
{0x0990, 0x00AB, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC28, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_10]
{0x0990, 0x00B6, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC29, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_11]
{0x0990, 0x00C1, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC2A, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_12]
{0x0990, 0x00CB, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC2B, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_13]
{0x0990, 0x00D5, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC2C, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_14]
{0x0990, 0x00DE, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC2D, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_15]
{0x0990, 0x00E7, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC2E, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_16]
{0x0990, 0x00EF, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC2F, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_17]
{0x0990, 0x00F7, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC30, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_18]
{0x0990, 0x00FF, WORD_LEN, 0 },  	 // MCU_DATA_0

{0x098E, 0xBC31, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NRCURVE_0]
{0x0990, 0x0000, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC32, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NRCURVE_1]
{0x0990, 0x000D, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC33, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NRCURVE_2]
{0x0990, 0x0019, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC34, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NRCURVE_3]
{0x0990, 0x0030, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC35, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NRCURVE_4]
{0x0990, 0x0056, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC36, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NRCURVE_5]
{0x0990, 0x0070, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC37, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NRCURVE_6]
{0x0990, 0x0081, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC38, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NRCURVE_7]
{0x0990, 0x0090, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC39, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NRCURVE_8]
{0x0990, 0x009E, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC3A, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NRCURVE_9]
{0x0990, 0x00AB, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC3B, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NRCURVE_10]
{0x0990, 0x00B6, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC3C, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NRCURVE_11]
{0x0990, 0x00C1, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC3D, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NRCURVE_12]
{0x0990, 0x00CB, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC3E, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NRCURVE_13]
{0x0990, 0x00D5, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC3F, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NRCURVE_14]
{0x0990, 0x00DE, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC40, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NRCURVE_15]
{0x0990, 0x00E7, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC41, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NRCURVE_16]
{0x0990, 0x00EF, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC42, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NRCURVE_17]
{0x0990, 0x00F7, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC43, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_GAMMA_NRCURVE_18]
{0x0990, 0x00FF, WORD_LEN, 0 },  	 // MCU_DATA_0



//[TC Initialize]
{0x098E, 0x6865, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_A_CONFIG_LL_ALGO_ENTER]
{0x0990, 0x00E0, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x6867, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_A_CONFIG_LL_ALGO_RUN]
{0x0990, 0x00F4, WORD_LEN, 0 },  	 // MCU_DATA_0

{0x098E, 0x8400, WORD_LEN, 0 }, 	 // MCU_ADDRESS [SEQ_CMD]
{0x0990, 0x0006, WORD_LEN, 0 }, 	 // MCU_DATA_0


{0x098E, 0xBC4A, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_TONAL_CURVE_HIGH]
{0x0990, 0x007F, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC4B, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_TONAL_CURVE_MED]
{0x0990, 0x007F, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xBC4C, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_TONAL_CURVE_LOW]
{0x0990, 0x007F, WORD_LEN, 0 },  	 // MCU_DATA_0


//[Total Curve]
{0x3542, 0x0010, WORD_LEN, 0 },  	// TONAL_X0
{0x3544, 0x0030, WORD_LEN, 0 },  	// TONAL_X1
{0x3546, 0x0040, WORD_LEN, 0 },  	// TONAL_X2
{0x3548, 0x0080, WORD_LEN, 0 },  	// TONAL_X3
{0x354A, 0x0100, WORD_LEN, 0 },  	// TONAL_X4
{0x354C, 0x0200, WORD_LEN, 0 },  	// TONAL_X5
{0x354E, 0x0300, WORD_LEN, 0 },  	// TONAL_X6
{0x3550, 0x0010, WORD_LEN, 0 },  	// TONAL_Y0
{0x3552, 0x0030, WORD_LEN, 0 },  	// TONAL_Y1
{0x3554, 0x0040, WORD_LEN, 0 },  	// TONAL_Y2
{0x3556, 0x0080, WORD_LEN, 0 },  	// TONAL_Y3
{0x3558, 0x0100, WORD_LEN, 0 },  	// TONAL_Y4
{0x355A, 0x0200, WORD_LEN, 0 },  	// TONAL_Y5
{0x355C, 0x0300, WORD_LEN, 0 },  	// TONAL_Y6
{0x3560, 0x0040, WORD_LEN, 0 },  	// RECIPROCAL_OF_X0_MINUS_ZERO
{0x3562, 0x0020, WORD_LEN, 0 },  	// RECIPROCAL_OF_X1_MINUS_X0
{0x3564, 0x0040, WORD_LEN, 0 },  	// RECIPROCAL_OF_X2_MINUS_X1
{0x3566, 0x0010, WORD_LEN, 0 },  	// RECIPROCAL_OF_X3_MINUS_X2
{0x3568, 0x0008, WORD_LEN, 0 },  	// RECIPROCAL_OF_X4_MINUS_X3
{0x356A, 0x0004, WORD_LEN, 0 },  	// RECIPROCAL_OF_X5_MINUS_X4
{0x356C, 0x0004, WORD_LEN, 0 },  	// RECIPROCAL_OF_X6_MINUS_X5
{0x356E, 0x0004, WORD_LEN, 0 },  	// RECIPROCAL_OF_400_MINUS_X6

//{0x3540, 0x0001, WORD_LEN, 0 },  	// ENABLE_TONAL_CURVE

{0x098E, 0xBC08, WORD_LEN, 0 },  	// MCU_ADDRESS [LL_GAMMA_SELECT]
{0x0990, 0x0001, WORD_LEN, 0 },  	// MCU_DATA_0 //0000


//[Fade To Black]
{0x098E, 0x3C4D, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_START_GAMMA_FTB]
{0x0990, 0x0DAC, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x3C4F, WORD_LEN, 0 },  	 // MCU_ADDRESS [LL_STOP_GAMMA_FTB]
{0x0990, 0x148A, WORD_LEN, 0 },  	 // MCU_DATA_0

//[awb_stat]
{0x098E, 0xC911, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_STAT_LUMA_THRESH_HIGH]
{0x0990, 0x00C8, WORD_LEN, 0 },  	 // MCU_DATA_0


//[K26A Rev3 Largan798a weight table]
{0x098E, 0xC8F4, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_AWB_AWB_XSCALE]
{0x0990, 0x0004, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xC8F5, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_AWB_AWB_YSCALE]
{0x0990, 0x0002, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x48F6, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_AWB_AWB_WEIGHTS_0]
{0x0990, 0x3B4D, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x48F8, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_AWB_AWB_WEIGHTS_1]
{0x0990, 0x6380, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x48FA, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_AWB_AWB_WEIGHTS_2]
{0x0990, 0x9B18, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x48FC, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_AWB_AWB_WEIGHTS_3]
{0x0990, 0x5D51, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x48FE, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_AWB_AWB_WEIGHTS_4]
{0x0990, 0xEDE8, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x4900, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_AWB_AWB_WEIGHTS_5]
{0x0990, 0xE515, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x4902, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_AWB_AWB_WEIGHTS_6]
{0x0990, 0xBFF4, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x4904, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_AWB_AWB_WEIGHTS_7]
{0x0990, 0x001E, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x4906, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_AWB_AWB_XSHIFT_PRE_ADJ]
{0x0990, 0x0026, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x4908, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_AWB_AWB_YSHIFT_PRE_ADJ]
{0x0990, 0x0033, WORD_LEN, 0 },  	 // MCU_DATA_0

//[AWB_CCM Natural]

{0x098E, 0x48B0, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_0]
{0x0990, 0x0180, WORD_LEN, 0 },  	// MCU_DATA_0 
{0x098E, 0x48B2, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_1]
{0x0990, 0xFF7A, WORD_LEN, 0 },  	// MCU_DATA_0 
{0x098E, 0x48B4, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_2]
{0x0990, 0x0018, WORD_LEN, 0 },  	// MCU_DATA_0 
{0x098E, 0x48B6, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_3]
{0x0990, 0xFFCA, WORD_LEN, 0 },  	// MCU_DATA_0 
{0x098E, 0x48B8, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_4]
{0x0990, 0x017C, WORD_LEN, 0 },  	// MCU_DATA_0 
{0x098E, 0x48BA, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_5]
{0x0990, 0xFFCC, WORD_LEN, 0 },  	// MCU_DATA_0 
{0x098E, 0x48BC, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_6]
{0x0990, 0x000C, WORD_LEN, 0 },  	// MCU_DATA_0 
{0x098E, 0x48BE, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_7]
{0x0990, 0xFF1F, WORD_LEN, 0 },  	// MCU_DATA_0 
{0x098E, 0x48C0, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_8]
{0x0990, 0x01E8, WORD_LEN, 0 },  	// MCU_DATA_0 
{0x098E, 0x48C2, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_9]
{0x0990, 0x0020, WORD_LEN, 0 },  	// MCU_DATA_0 
{0x098E, 0x48C4, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_10]
{0x0990, 0x0044, WORD_LEN, 0 },  	// MCU_DATA_0 
{0x098E, 0x48C6, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_0]
{0x0990, 0x0079, WORD_LEN, 0 },  	// MCU_DATA_0 
{0x098E, 0x48C8, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_1]
{0x0990, 0xFFAD, WORD_LEN, 0 },  	// MCU_DATA_0 
{0x098E, 0x48CA, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_2]
{0x0990, 0xFFE2, WORD_LEN, 0 },  	// MCU_DATA_0 
{0x098E, 0x48CC, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_3]
{0x0990, 0x0033, WORD_LEN, 0 },  	// MCU_DATA_0 
{0x098E, 0x48CE, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_4]
{0x0990, 0x002A, WORD_LEN, 0 },  	// MCU_DATA_0 
{0x098E, 0x48D0, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_5]
{0x0990, 0xFFAA, WORD_LEN, 0 },  	// MCU_DATA_0 
{0x098E, 0x48D2, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_6]
{0x0990, 0x0017, WORD_LEN, 0 },  	// MCU_DATA_0 
{0x098E, 0x48D4, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_7]
{0x0990, 0x004B, WORD_LEN, 0 },  	// MCU_DATA_0 
{0x098E, 0x48D6, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_8]
{0x0990, 0xFFA5, WORD_LEN, 0 },  	// MCU_DATA_0 
{0x098E, 0x48D8, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_9]
{0x0990, 0x0015, WORD_LEN, 0 },  	// MCU_DATA_0 
{0x098E, 0x48DA, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_10]
{0x0990, 0xFFE2, WORD_LEN, 0 },  	// MCU_DATA_0 

{0x098E, 0xE84A, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_AWB_K_R_L]
{0x0990, 0x0083, WORD_LEN, 0 },  	// MCU_DATA_0
//{0x098E, 0xE84B, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_AWB_K_G_L]
//{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xE84C, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_AWB_K_B_L]
{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xE84D, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_AWB_K_R_R]
{0x0990, 0x0083, WORD_LEN, 0 },  	// MCU_DATA_0
//{0x098E, 0xE84E, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_AWB_K_G_R]
//{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xE84F, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_AWB_K_B_R]
{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0

{0x098E, 0x8400, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_AWB_K_B_R]
{0x0990, 0x0006, WORD_LEN, 0 },  	// MCU_DATA_0

/*
{0x098E, 0x48B0, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_0]
{0x0990, 0x015F, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48B2, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_1]
{0x0990, 0xFFF8, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48B4, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_2]
{0x0990, 0x001A, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48B6, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_3]
{0x0990, 0xFFBA, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48B8, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_4]
{0x0990, 0x0171, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48BA, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_5]
{0x0990, 0xFFD0, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48BC, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_6]
{0x0990, 0x0023, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48BE, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_7]
{0x0990, 0xFF71, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48C0, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_8]
{0x0990, 0x0185, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48C2, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_9]
{0x0990, 0x0020, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48C4, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_L_10]
{0x0990, 0x0050, WORD_LEN, 0 },  	// MCU_DATA_0

{0x098E, 0x48C6, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_0]
{0x0990, 0xFEA1, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48C8, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_1]
{0x0990, 0x0008, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48CA, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_2]
{0x0990, 0xFFE6, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48CC, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_3]
{0x0990, 0x0046, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48CE, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_4]
{0x0990, 0xFE8F, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48D0, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_5]
{0x0990, 0x0030, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48D2, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_6]
{0x0990, 0xFFDD, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48D4, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_7]
{0x0990, 0x008F, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48D6, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_8]
{0x0990, 0xFE7B, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48D8, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_9]
{0x0990, 0xFFE0, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x48DA, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_CCM_RL_10]
{0x0990, 0xFFB0, WORD_LEN, 0 },  	// MCU_DATA_0


{0x098E, 0xE84A, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_AWB_K_R_L]
{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xE84B, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_AWB_K_G_L]
{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xE84C, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_AWB_K_B_L]
{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xE84D, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_AWB_K_R_R]
{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xE84E, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_AWB_K_G_R]
{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0xE84F, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_AWB_K_B_R]
{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0
*/
//{0x098E, 0xC8EE, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_DGAIN_MIN_R]
//{0x0990, 0x0064, WORD_LEN, 0 },  	// MCU_DATA_0
//{0x098E, 0xC8EF, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_DGAIN_MAX_R]
//{0x0990, 0x0096, WORD_LEN, 0 },  	// MCU_DATA_0
//{0x098E, 0xC8F0, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_DGAIN_MIN_B]
//{0x0990, 0x0064, WORD_LEN, 0 },  	// MCU_DATA_0
//{0x098E, 0xC8F1, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_AWB_DGAIN_MAX_B]
//{0x0990, 0x00DC, WORD_LEN, 0 },  	// MCU_DATA_0



//{0x098E, 0xEC4A, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_B_CONFIG_AWB_K_R_L]
//{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0
//{0x098E, 0xEC4B, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_B_CONFIG_AWB_K_G_L]
//{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0
//{0x098E, 0xEC4C, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_B_CONFIG_AWB_K_B_L]
//{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0
//{0x098E, 0xEC4D, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_B_CONFIG_AWB_K_R_R]
//{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0
//{0x098E, 0xEC4E, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_B_CONFIG_AWB_K_G_R]
//{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0
//{0x098E, 0xEC4F, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_B_CONFIG_AWB_K_B_R]
//{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0

//[Saturation]
{0x35A2, 0x0014, WORD_LEN, 0 },  	 // DARK_COLOR_KILL_CONTROLS
{0x098E, 0xC949, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_SYS_DARK_COLOR_KILL]
{0x0990, 0x0024, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x35A4, 0x0596, WORD_LEN, 0 },  	 // BRIGHT_COLOR_KILL_CONTROLS
{0x098E, 0xC94A, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_SYS_BRIGHT_COLORKILL]
{0x0990, 0x0062, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xC948, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_SYS_UV_COLOR_BOOST]
{0x0990, 0x0006, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xC914, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_START_DESATURATION]
{0x0990, 0x0000, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xC915, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_LL_END_DESATURATION]
{0x0990, 0x00FF, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xE86F, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_A_CONFIG_LL_START_SATURATION]
{0x0990, 0x0060, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xE870, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_A_CONFIG_LL_END_SATURATION]
{0x0990, 0x003C, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xEC6F, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_B_CONFIG_LL_START_SATURATION]
{0x0990, 0x0060, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xEC70, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_B_CONFIG_LL_END_SATURATION]
{0x0990, 0x003C, WORD_LEN, 0 },  	 // MCU_DATA_0

//[No Special Effects]
{0x098E, 0xE883, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SELECT_FX]
{0x0990, 0x0000, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xEC83, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SELECT_FX]
{0x0990, 0x0000, WORD_LEN, 0 },  	 // MCU_DATA_0

{0x098E, 0x8400, WORD_LEN, 0 }, 	 // MCU_ADDRESS [SEQ_CMD]
{0x0990, 0x0006, WORD_LEN, 0 }, 	 // MCU_DATA_0

{0x098E, 0xE885, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SEPIA_CR]
{0x0990, 0x001E, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xE886, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SEPIA_CB]
{0x0990, 0x00D8, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xEC85, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SEPIA_CR]
{0x0990, 0x001E, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xEC86, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SEPIA_CB]
{0x0990, 0x00D8, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xE884, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SOLARIZATION_TH]
{0x0990, 0x005C, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xEC84, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SOLARIZATION_TH]
{0x0990, 0x005C, WORD_LEN, 0 },  	 // MCU_DATA_0


//[AS Normal]
{0x098E, 0x490A, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_AS_INTEG_SCALE_FIRST_PASS]
{0x0990, 0x0666, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x490C, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_AS_MIN_INT_TIME_FIRST_PASS]
{0x0990, 0x0140, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x6857, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_A_CONFIG_IS_FEATURE_THRESHOLD]
{0x0990, 0x0014, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x685C, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_A_CONFIG_IS_BLUR_INPUT_PARAMETER]
{0x0990, 0x0005, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x490E, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_AS_MAX_DIGITAL_GAIN_ALLOWED]
{0x0990, 0x00A4, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xB43D, WORD_LEN, 0 },  	 // MCU_ADDRESS [AS_START_ASVALUES_0]
{0x0990, 0x0031, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xB43E, WORD_LEN, 0 },  	 // MCU_ADDRESS [AS_START_ASVALUES_1]
{0x0990, 0x001B, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xB43F, WORD_LEN, 0 },  	 // MCU_ADDRESS [AS_START_ASVALUES_2]
{0x0990, 0x0028, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xB440, WORD_LEN, 0 },  	 // MCU_ADDRESS [AS_START_ASVALUES_3]
{0x0990, 0x0003, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xB441, WORD_LEN, 0 },  	 // MCU_ADDRESS [AS_STOP_ASVALUES_0]
{0x0990, 0x00CD, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xB442, WORD_LEN, 0 },  	 // MCU_ADDRESS [AS_STOP_ASVALUES_1]
{0x0990, 0x0064, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xB443, WORD_LEN, 0 },  	 // MCU_ADDRESS [AS_STOP_ASVALUES_2]
{0x0990, 0x000F, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xB444, WORD_LEN, 0 },  	 // MCU_ADDRESS [AS_STOP_ASVALUES_3]
{0x0990, 0x0007, WORD_LEN, 0 },  	 // MCU_DATA_0


//[Auto focus settings]
/*{0x098E, 0x300D, WORD_LEN, 0 },  	 // MCU_ADDRESS [AF_FILTERS]
{0x0990, 0x000F, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x3017, WORD_LEN, 0 },  	 // MCU_ADDRESS [AF_THRESHOLDS]
{0x0990, 0x0F0F, WORD_LEN, 0 },  	 // MCU_DATA_0

{0x098E, 0x8400, WORD_LEN, 0 }, 	 // MCU_ADDRESS [SEQ_CMD]
{0x0990, 0x0006, WORD_LEN, 0 }, 	 // MCU_DATA_0

{0x098E, 0xE81F, WORD_LEN, 0 }, 	 // MCU_ADDRESS [PRI_A_CONFIG_AE_RULE_BASE_TARGET]
{0x0990, 0x0020, WORD_LEN, 0 }, 	 // MCU_DATA_0
*/

//[High Speed Overrides]
{0x098E, 0x68A0, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_A_CONFIG_JPEG_OB_TX_CONTROL_VAR]
{0x0990, 0x082E, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x6CA0, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_B_CONFIG_JPEG_OB_TX_CONTROL_VAR]
{0x0990, 0x082E, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x70A0, WORD_LEN, 0 },  	 // MCU_ADDRESS [SEC_A_CONFIG_JPEG_OB_TX_CONTROL_VAR]
{0x0990, 0x082E, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0x74A0, WORD_LEN, 0 },  	 // MCU_ADDRESS [SEC_B_CONFIG_JPEG_OB_TX_CONTROL_VAR]
{0x0990, 0x082E, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x3C52, 0x082E, WORD_LEN, 0 },  	 // RESERVED_TX_SS_3C52
{0x098E, 0x488E, WORD_LEN, 0 },  	 // MCU_ADDRESS [CAM1_CTX_B_RX_FIFO_TRIGGER_MARK]
{0x0990, 0x0020, WORD_LEN, 0 },  	 // MCU_DATA_0
{0x098E, 0xECAC, WORD_LEN, 0 },  	 // MCU_ADDRESS [PRI_B_CONFIG_IO_OB_MANUAL_FLAG]
{0x0990, 0x0000, WORD_LEN, 0 },  	 // MCU_DATA_0




//[VAA_LOW_POWER]
{0x3084, 0x2409, WORD_LEN, 0 },  	 // RESERVED_CORE_3084
{0x3092, 0x0A49, WORD_LEN, 0 },  	 // RESERVED_CORE_3092
{0x3094, 0x4949, WORD_LEN, 0 },  	 // RESERVED_CORE_3094
{0x3096, 0x4950, WORD_LEN, 0 },  	 // RESERVED_CORE_3096


//[Hot Pixels]
{0x316C, 0x350F, WORD_LEN, 0 },  	 // RESERVED_CORE_316C


//patch rev3
{0x0982, 0x0000, WORD_LEN, 0 },  	// ACCESS_CTL_STAT
{0x098A, 0x0CFB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x3C3C, WORD_LEN, 0 }, 
{0x0992, 0x3C3C, WORD_LEN, 0 }, 
{0x0994, 0x3C3C, WORD_LEN, 0 }, 
{0x0996, 0x5F4F, WORD_LEN, 0 }, 
{0x0998, 0x30ED, WORD_LEN, 0 }, 
{0x099A, 0x0AED, WORD_LEN, 0 }, 
{0x099C, 0x08BD, WORD_LEN, 0 }, 
{0x099E, 0x61D5, WORD_LEN, 0 }, 
{0x098A, 0x0D0B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xCE04, WORD_LEN, 0 }, 
{0x0992, 0xCD1F, WORD_LEN, 0 }, 
{0x0994, 0x1702, WORD_LEN, 0 }, 
{0x0996, 0x11CC, WORD_LEN, 0 }, 
{0x0998, 0x332E, WORD_LEN, 0 }, 
{0x099A, 0x30ED, WORD_LEN, 0 }, 
{0x099C, 0x02CC, WORD_LEN, 0 }, 
{0x099E, 0xFFFD, WORD_LEN, 0 }, 
{0x098A, 0x0D1B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xED00, WORD_LEN, 0 }, 
{0x0992, 0xCC00, WORD_LEN, 0 }, 
{0x0994, 0x02BD, WORD_LEN, 0 }, 
{0x0996, 0x706D, WORD_LEN, 0 }, 
{0x0998, 0x18DE, WORD_LEN, 0 }, 
{0x099A, 0x1F18, WORD_LEN, 0 }, 
{0x099C, 0x1F8E, WORD_LEN, 0 }, 
{0x099E, 0x0110, WORD_LEN, 0 }, 
{0x098A, 0x0D2B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xCC3C, WORD_LEN, 0 }, 
{0x0992, 0x5230, WORD_LEN, 0 }, 
{0x0994, 0xED00, WORD_LEN, 0 }, 
{0x0996, 0x18EC, WORD_LEN, 0 }, 
{0x0998, 0xA0C4, WORD_LEN, 0 }, 
{0x099A, 0xFDBD, WORD_LEN, 0 }, 
{0x099C, 0x7021, WORD_LEN, 0 }, 
{0x099E, 0x201E, WORD_LEN, 0 }, 
{0x098A, 0x0D3B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xCC3C, WORD_LEN, 0 }, 
{0x0992, 0x5230, WORD_LEN, 0 }, 
{0x0994, 0xED00, WORD_LEN, 0 }, 
{0x0996, 0xDE1F, WORD_LEN, 0 }, 
{0x0998, 0xECA0, WORD_LEN, 0 }, 
{0x099A, 0xBD70, WORD_LEN, 0 }, 
{0x099C, 0x21CC, WORD_LEN, 0 }, 
{0x099E, 0x3C52, WORD_LEN, 0 }, 
{0x098A, 0x0D4B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x30ED, WORD_LEN, 0 }, 
{0x0992, 0x02CC, WORD_LEN, 0 }, 
{0x0994, 0xFFFC, WORD_LEN, 0 }, 
{0x0996, 0xED00, WORD_LEN, 0 }, 
{0x0998, 0xCC00, WORD_LEN, 0 }, 
{0x099A, 0x02BD, WORD_LEN, 0 }, 
{0x099C, 0x706D, WORD_LEN, 0 }, 
{0x099E, 0xFC04, WORD_LEN, 0 }, 
{0x098A, 0x0D5B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xE11A, WORD_LEN, 0 }, 
{0x0992, 0x8300, WORD_LEN, 0 }, 
{0x0994, 0x0127, WORD_LEN, 0 }, 
{0x0996, 0x201A, WORD_LEN, 0 }, 
{0x0998, 0x8300, WORD_LEN, 0 }, 
{0x099A, 0x0427, WORD_LEN, 0 }, 
{0x099C, 0x221A, WORD_LEN, 0 }, 
{0x099E, 0x8300, WORD_LEN, 0 }, 
{0x098A, 0x0D6B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0827, WORD_LEN, 0 }, 
{0x0992, 0x241A, WORD_LEN, 0 }, 
{0x0994, 0x8300, WORD_LEN, 0 }, 
{0x0996, 0x1027, WORD_LEN, 0 }, 
{0x0998, 0x261A, WORD_LEN, 0 }, 
{0x099A, 0x8300, WORD_LEN, 0 }, 
{0x099C, 0x2027, WORD_LEN, 0 }, 
{0x099E, 0x281A, WORD_LEN, 0 }, 
{0x098A, 0x0D7B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x8300, WORD_LEN, 0 }, 
{0x0992, 0x4027, WORD_LEN, 0 }, 
{0x0994, 0x2A20, WORD_LEN, 0 }, 
{0x0996, 0x2ECC, WORD_LEN, 0 }, 
{0x0998, 0x001E, WORD_LEN, 0 }, 
{0x099A, 0x30ED, WORD_LEN, 0 }, 
{0x099C, 0x0A20, WORD_LEN, 0 }, 
{0x099E, 0x26CC, WORD_LEN, 0 }, 
{0x098A, 0x0D8B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0022, WORD_LEN, 0 }, 
{0x0992, 0x30ED, WORD_LEN, 0 }, 
{0x0994, 0x0A20, WORD_LEN, 0 }, 
{0x0996, 0x1ECC, WORD_LEN, 0 }, 
{0x0998, 0x0021, WORD_LEN, 0 }, 
{0x099A, 0x30ED, WORD_LEN, 0 }, 
{0x099C, 0x0A20, WORD_LEN, 0 }, 
{0x099E, 0x16CC, WORD_LEN, 0 }, 
{0x098A, 0x0D9B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0020, WORD_LEN, 0 }, 
{0x0992, 0x30ED, WORD_LEN, 0 }, 
{0x0994, 0x0A20, WORD_LEN, 0 }, 
{0x0996, 0x0ECC, WORD_LEN, 0 }, 
{0x0998, 0x002A, WORD_LEN, 0 }, 
{0x099A, 0x30ED, WORD_LEN, 0 }, 
{0x099C, 0x0A20, WORD_LEN, 0 }, 
{0x099E, 0x06CC, WORD_LEN, 0 }, 
{0x098A, 0x0DAB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x002B, WORD_LEN, 0 }, 
{0x0992, 0x30ED, WORD_LEN, 0 }, 
{0x0994, 0x0ACC, WORD_LEN, 0 }, 
{0x0996, 0x3400, WORD_LEN, 0 }, 
{0x0998, 0x30ED, WORD_LEN, 0 }, 
{0x099A, 0x0034, WORD_LEN, 0 }, 
{0x099C, 0xBD6F, WORD_LEN, 0 }, 
{0x099E, 0xD184, WORD_LEN, 0 }, 
{0x098A, 0x0DBB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0330, WORD_LEN, 0 }, 
{0x0992, 0xED07, WORD_LEN, 0 }, 
{0x0994, 0xA60C, WORD_LEN, 0 }, 
{0x0996, 0x4848, WORD_LEN, 0 }, 
{0x0998, 0x5FED, WORD_LEN, 0 }, 
{0x099A, 0x05EC, WORD_LEN, 0 }, 
{0x099C, 0x07EA, WORD_LEN, 0 }, 
{0x099E, 0x06AA, WORD_LEN, 0 }, 
{0x098A, 0x0DCB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0531, WORD_LEN, 0 }, 
{0x0992, 0xBD70, WORD_LEN, 0 }, 
{0x0994, 0x21DE, WORD_LEN, 0 }, 
{0x0996, 0x1F1F, WORD_LEN, 0 }, 
{0x0998, 0x8E01, WORD_LEN, 0 }, 
{0x099A, 0x08EC, WORD_LEN, 0 }, 
{0x099C, 0x9B05, WORD_LEN, 0 }, 
{0x099E, 0x30ED, WORD_LEN, 0 }, 
{0x098A, 0x0DDB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0820, WORD_LEN, 0 }, 
{0x0992, 0x3BDE, WORD_LEN, 0 }, 
{0x0994, 0x1FEC, WORD_LEN, 0 }, 
{0x0996, 0x0783, WORD_LEN, 0 }, 
{0x0998, 0x0040, WORD_LEN, 0 }, 
{0x099A, 0x2628, WORD_LEN, 0 }, 
{0x099C, 0x7F30, WORD_LEN, 0 }, 
{0x099E, 0xC4CC, WORD_LEN, 0 }, 
{0x098A, 0x0DEB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x3C68, WORD_LEN, 0 }, 
{0x0992, 0xBD6F, WORD_LEN, 0 }, 
{0x0994, 0xD1FD, WORD_LEN, 0 }, 
{0x0996, 0x30C5, WORD_LEN, 0 }, 
{0x0998, 0xCC01, WORD_LEN, 0 }, 
{0x099A, 0xF4FD, WORD_LEN, 0 }, 
{0x099C, 0x30C7, WORD_LEN, 0 }, 
{0x099E, 0xC640, WORD_LEN, 0 }, 
{0x098A, 0x0DFB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xF730, WORD_LEN, 0 }, 
{0x0992, 0xC4CC, WORD_LEN, 0 }, 
{0x0994, 0x0190, WORD_LEN, 0 }, 
{0x0996, 0xFD30, WORD_LEN, 0 }, 
{0x0998, 0xC501, WORD_LEN, 0 }, 
{0x099A, 0x0101, WORD_LEN, 0 }, 
{0x099C, 0xFC30, WORD_LEN, 0 }, 
{0x099E, 0xC230, WORD_LEN, 0 }, 
{0x098A, 0x0E0B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xED08, WORD_LEN, 0 }, 
{0x0992, 0x200A, WORD_LEN, 0 }, 
{0x0994, 0xCC3C, WORD_LEN, 0 }, 
{0x0996, 0x68BD, WORD_LEN, 0 }, 
{0x0998, 0x6FD1, WORD_LEN, 0 }, 
{0x099A, 0x0530, WORD_LEN, 0 }, 
{0x099C, 0xED08, WORD_LEN, 0 }, 
{0x099E, 0xCC34, WORD_LEN, 0 }, 
{0x098A, 0x0E1B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x08ED, WORD_LEN, 0 }, 
{0x0992, 0x00EC, WORD_LEN, 0 }, 
{0x0994, 0x08BD, WORD_LEN, 0 }, 
{0x0996, 0x7021, WORD_LEN, 0 }, 
{0x0998, 0x30C6, WORD_LEN, 0 }, 
{0x099A, 0x0C3A, WORD_LEN, 0 }, 
{0x099C, 0x3539, WORD_LEN, 0 }, 
{0x099E, 0x373C, WORD_LEN, 0 }, 
{0x098A, 0x0E2B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x3C3C, WORD_LEN, 0 }, 
{0x0992, 0x34DE, WORD_LEN, 0 }, 
{0x0994, 0x2FEE, WORD_LEN, 0 }, 
{0x0996, 0x0EAD, WORD_LEN, 0 }, 
{0x0998, 0x007D, WORD_LEN, 0 }, 
{0x099A, 0x13EF, WORD_LEN, 0 }, 
{0x099C, 0x277C, WORD_LEN, 0 }, 
{0x099E, 0xCE13, WORD_LEN, 0 }, 
{0x098A, 0x0E3B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xE01E, WORD_LEN, 0 }, 
{0x0992, 0x0510, WORD_LEN, 0 }, 
{0x0994, 0x60E6, WORD_LEN, 0 }, 
{0x0996, 0x0E4F, WORD_LEN, 0 }, 
{0x0998, 0xC313, WORD_LEN, 0 }, 
{0x099A, 0xF08F, WORD_LEN, 0 }, 
{0x099C, 0xE600, WORD_LEN, 0 }, 
{0x099E, 0x30E1, WORD_LEN, 0 }, 
{0x098A, 0x0E4B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0722, WORD_LEN, 0 }, 
{0x0992, 0x16F6, WORD_LEN, 0 }, 
{0x0994, 0x13EE, WORD_LEN, 0 }, 
{0x0996, 0x4FC3, WORD_LEN, 0 }, 
{0x0998, 0x13F3, WORD_LEN, 0 }, 
{0x099A, 0x8FE6, WORD_LEN, 0 }, 
{0x099C, 0x0030, WORD_LEN, 0 }, 
{0x099E, 0xE107, WORD_LEN, 0 }, 
{0x098A, 0x0E5B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x2507, WORD_LEN, 0 }, 
{0x0992, 0xF613, WORD_LEN, 0 }, 
{0x0994, 0xEEC1, WORD_LEN, 0 }, 
{0x0996, 0x0325, WORD_LEN, 0 }, 
{0x0998, 0x3C7F, WORD_LEN, 0 }, 
{0x099A, 0x13EE, WORD_LEN, 0 }, 
{0x099C, 0xF613, WORD_LEN, 0 }, 
{0x099E, 0xEFE7, WORD_LEN, 0 }, 
{0x098A, 0x0E6B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x06CC, WORD_LEN, 0 }, 
{0x0992, 0x13F0, WORD_LEN, 0 }, 
{0x0994, 0xED04, WORD_LEN, 0 }, 
{0x0996, 0xCC13, WORD_LEN, 0 }, 
{0x0998, 0xF320, WORD_LEN, 0 }, 
{0x099A, 0x0F7C, WORD_LEN, 0 }, 
{0x099C, 0x13EE, WORD_LEN, 0 }, 
{0x099E, 0xEC04, WORD_LEN, 0 }, 
{0x098A, 0x0E7B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xC300, WORD_LEN, 0 }, 
{0x0992, 0x01ED, WORD_LEN, 0 }, 
{0x0994, 0x04EC, WORD_LEN, 0 }, 
{0x0996, 0x02C3, WORD_LEN, 0 }, 
{0x0998, 0x0001, WORD_LEN, 0 }, 
{0x099A, 0xED02, WORD_LEN, 0 }, 
{0x099C, 0xF613, WORD_LEN, 0 }, 
{0x099E, 0xEEE1, WORD_LEN, 0 }, 
{0x098A, 0x0E8B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0624, WORD_LEN, 0 }, 
{0x0992, 0x12EE, WORD_LEN, 0 }, 
{0x0994, 0x04E6, WORD_LEN, 0 }, 
{0x0996, 0x0030, WORD_LEN, 0 }, 
{0x0998, 0xE107, WORD_LEN, 0 }, 
{0x099A, 0x22DF, WORD_LEN, 0 }, 
{0x099C, 0xEE02, WORD_LEN, 0 }, 
{0x099E, 0xE600, WORD_LEN, 0 }, 
{0x098A, 0x0E9B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x30E1, WORD_LEN, 0 }, 
{0x0992, 0x0725, WORD_LEN, 0 }, 
{0x0994, 0xD6DE, WORD_LEN, 0 }, 
{0x0996, 0x49EE, WORD_LEN, 0 }, 
{0x0998, 0x08AD, WORD_LEN, 0 }, 
{0x099A, 0x00CC, WORD_LEN, 0 }, 
{0x099C, 0x13F6, WORD_LEN, 0 }, 
{0x099E, 0x30ED, WORD_LEN, 0 }, 
{0x098A, 0x0EAB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x00DE, WORD_LEN, 0 }, 
{0x0992, 0x2FEE, WORD_LEN, 0 }, 
{0x0994, 0x10CC, WORD_LEN, 0 }, 
{0x0996, 0x13FA, WORD_LEN, 0 }, 
{0x0998, 0xAD00, WORD_LEN, 0 }, 
{0x099A, 0x3838, WORD_LEN, 0 }, 
{0x099C, 0x3838, WORD_LEN, 0 }, 
{0x099E, 0x3937, WORD_LEN, 0 }, 
{0x098A, 0x0EBB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x363C, WORD_LEN, 0 }, 
{0x0992, 0x3C3C, WORD_LEN, 0 }, 
{0x0994, 0x5F4F, WORD_LEN, 0 }, 
{0x0996, 0x30ED, WORD_LEN, 0 }, 
{0x0998, 0x04EC, WORD_LEN, 0 }, 
{0x099A, 0x06ED, WORD_LEN, 0 }, 
{0x099C, 0x008F, WORD_LEN, 0 }, 
{0x099E, 0xC300, WORD_LEN, 0 }, 
{0x098A, 0x0ECB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x04BD, WORD_LEN, 0 }, 
{0x0992, 0x0F43, WORD_LEN, 0 }, 
{0x0994, 0x30EC, WORD_LEN, 0 }, 
{0x0996, 0x04BD, WORD_LEN, 0 }, 
{0x0998, 0x0F76, WORD_LEN, 0 }, 
{0x099A, 0x30ED, WORD_LEN, 0 }, 
{0x099C, 0x0238, WORD_LEN, 0 }, 
{0x099E, 0x3838, WORD_LEN, 0 }, 
{0x098A, 0x0EDB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x3839, WORD_LEN, 0 }, 
{0x0992, 0x373C, WORD_LEN, 0 }, 
{0x0994, 0x3C3C, WORD_LEN, 0 }, 
{0x0996, 0x3C30, WORD_LEN, 0 }, 
{0x0998, 0xE608, WORD_LEN, 0 }, 
{0x099A, 0x2712, WORD_LEN, 0 }, 
{0x099C, 0xC101, WORD_LEN, 0 }, 
{0x099E, 0x2713, WORD_LEN, 0 }, 
{0x098A, 0x0EEB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xC102, WORD_LEN, 0 }, 
{0x0992, 0x2714, WORD_LEN, 0 }, 
{0x0994, 0xC103, WORD_LEN, 0 }, 
{0x0996, 0x2715, WORD_LEN, 0 }, 
{0x0998, 0xC104, WORD_LEN, 0 }, 
{0x099A, 0x2716, WORD_LEN, 0 }, 
{0x099C, 0x2019, WORD_LEN, 0 }, 
{0x099E, 0xCC30, WORD_LEN, 0 }, 
{0x098A, 0x0EFB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x5E20, WORD_LEN, 0 }, 
{0x0992, 0x12CC, WORD_LEN, 0 }, 
{0x0994, 0x305A, WORD_LEN, 0 }, 
{0x0996, 0x200D, WORD_LEN, 0 }, 
{0x0998, 0xCC30, WORD_LEN, 0 }, 
{0x099A, 0x5620, WORD_LEN, 0 }, 
{0x099C, 0x08CC, WORD_LEN, 0 }, 
{0x099E, 0x305C, WORD_LEN, 0 }, 
{0x098A, 0x0F0B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x2003, WORD_LEN, 0 }, 
{0x0992, 0xCC30, WORD_LEN, 0 }, 
{0x0994, 0x58ED, WORD_LEN, 0 }, 
{0x0996, 0x065F, WORD_LEN, 0 }, 
{0x0998, 0x4FED, WORD_LEN, 0 }, 
{0x099A, 0x04EC, WORD_LEN, 0 }, 
{0x099C, 0x0BED, WORD_LEN, 0 }, 
{0x099E, 0x008F, WORD_LEN, 0 }, 
{0x098A, 0x0F1B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xC300, WORD_LEN, 0 }, 
{0x0992, 0x04BD, WORD_LEN, 0 }, 
{0x0994, 0x0F43, WORD_LEN, 0 }, 
{0x0996, 0x30EC, WORD_LEN, 0 }, 
{0x0998, 0x048A, WORD_LEN, 0 }, 
{0x099A, 0x02ED, WORD_LEN, 0 }, 
{0x099C, 0x02EC, WORD_LEN, 0 }, 
{0x099E, 0x06ED, WORD_LEN, 0 }, 
{0x098A, 0x0F2B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x008F, WORD_LEN, 0 }, 
{0x0992, 0xC300, WORD_LEN, 0 }, 
{0x0994, 0x02DE, WORD_LEN, 0 }, 
{0x0996, 0x0EAD, WORD_LEN, 0 }, 
{0x0998, 0x0030, WORD_LEN, 0 }, 
{0x099A, 0xEC04, WORD_LEN, 0 }, 
{0x099C, 0xBD0F, WORD_LEN, 0 }, 
{0x099E, 0x7630, WORD_LEN, 0 }, 
{0x098A, 0x0F3B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xED02, WORD_LEN, 0 }, 
{0x0992, 0x3838, WORD_LEN, 0 }, 
{0x0994, 0x3838, WORD_LEN, 0 }, 
{0x0996, 0x3139, WORD_LEN, 0 }, 
{0x0998, 0x3736, WORD_LEN, 0 }, 
{0x099A, 0x30EC, WORD_LEN, 0 }, 
{0x099C, 0x041A, WORD_LEN, 0 }, 
{0x099E, 0x8300, WORD_LEN, 0 }, 
{0x098A, 0x0F4B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x4025, WORD_LEN, 0 }, 
{0x0992, 0x22EC, WORD_LEN, 0 }, 
{0x0994, 0x041A, WORD_LEN, 0 }, 
{0x0996, 0x8300, WORD_LEN, 0 }, 
{0x0998, 0x8024, WORD_LEN, 0 }, 
{0x099A, 0x0504, WORD_LEN, 0 }, 
{0x099C, 0xCA40, WORD_LEN, 0 }, 
{0x099E, 0x2015, WORD_LEN, 0 }, 
{0x098A, 0x0F5B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xEC04, WORD_LEN, 0 }, 
{0x0992, 0x1A83, WORD_LEN, 0 }, 
{0x0994, 0x0100, WORD_LEN, 0 }, 
{0x0996, 0x2406, WORD_LEN, 0 }, 
{0x0998, 0x0404, WORD_LEN, 0 }, 
{0x099A, 0xCA80, WORD_LEN, 0 }, 
{0x099C, 0x2007, WORD_LEN, 0 }, 
{0x099E, 0xEC04, WORD_LEN, 0 }, 
{0x098A, 0x0F6B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0404, WORD_LEN, 0 }, 
{0x0992, 0x04CA, WORD_LEN, 0 }, 
{0x0994, 0xC0EE, WORD_LEN, 0 }, 
{0x0996, 0x00ED, WORD_LEN, 0 }, 
{0x0998, 0x0038, WORD_LEN, 0 }, 
{0x099A, 0x3937, WORD_LEN, 0 }, 
{0x099C, 0x363C, WORD_LEN, 0 }, 
{0x099E, 0x301F, WORD_LEN, 0 }, 
{0x098A, 0x0F7B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0340, WORD_LEN, 0 }, 
{0x0992, 0x0E1F, WORD_LEN, 0 }, 
{0x0994, 0x0380, WORD_LEN, 0 }, 
{0x0996, 0x0AEC, WORD_LEN, 0 }, 
{0x0998, 0x02C4, WORD_LEN, 0 }, 
{0x099A, 0x3F4F, WORD_LEN, 0 }, 
{0x099C, 0x0505, WORD_LEN, 0 }, 
{0x099E, 0x0520, WORD_LEN, 0 }, 
{0x098A, 0x0F8B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x1B1F, WORD_LEN, 0 }, 
{0x0992, 0x0380, WORD_LEN, 0 }, 
{0x0994, 0x09EC, WORD_LEN, 0 }, 
{0x0996, 0x02C4, WORD_LEN, 0 }, 
{0x0998, 0x3F4F, WORD_LEN, 0 }, 
{0x099A, 0x0505, WORD_LEN, 0 }, 
{0x099C, 0x200E, WORD_LEN, 0 }, 
{0x099E, 0x1F03, WORD_LEN, 0 }, 
{0x098A, 0x0F9B, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x4008, WORD_LEN, 0 }, 
{0x0992, 0xEC02, WORD_LEN, 0 }, 
{0x0994, 0xC43F, WORD_LEN, 0 }, 
{0x0996, 0x4F05, WORD_LEN, 0 }, 
{0x0998, 0x2002, WORD_LEN, 0 }, 
{0x099A, 0xEC02, WORD_LEN, 0 }, 
{0x099C, 0xED00, WORD_LEN, 0 }, 
{0x099E, 0x3838, WORD_LEN, 0 }, 
{0x098A, 0x8FAB, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0039, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098A, 0x1000, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xCC10, WORD_LEN, 0 }, 
{0x0992, 0x09BD, WORD_LEN, 0 }, 
{0x0994, 0x4224, WORD_LEN, 0 }, 
{0x0996, 0x7E10, WORD_LEN, 0 }, 
{0x0998, 0x09C6, WORD_LEN, 0 }, 
{0x099A, 0x01F7, WORD_LEN, 0 }, 
{0x099C, 0x018A, WORD_LEN, 0 }, 
{0x099E, 0xC609, WORD_LEN, 0 }, 
{0x098A, 0x1010, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xF701, WORD_LEN, 0 }, 
{0x0992, 0x8BDE, WORD_LEN, 0 }, 
{0x0994, 0x3F18, WORD_LEN, 0 }, 
{0x0996, 0xCE0B, WORD_LEN, 0 }, 
{0x0998, 0xF3CC, WORD_LEN, 0 }, 
{0x099A, 0x0011, WORD_LEN, 0 }, 
{0x099C, 0xBDD7, WORD_LEN, 0 }, 
{0x099E, 0x00CC, WORD_LEN, 0 }, 
{0x098A, 0x1020, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0BF3, WORD_LEN, 0 }, 
{0x0992, 0xDD3F, WORD_LEN, 0 }, 
{0x0994, 0xDE35, WORD_LEN, 0 }, 
{0x0996, 0x18CE, WORD_LEN, 0 }, 
{0x0998, 0x0C05, WORD_LEN, 0 }, 
{0x099A, 0xCC00, WORD_LEN, 0 }, 
{0x099C, 0x3FBD, WORD_LEN, 0 }, 
{0x099E, 0xD700, WORD_LEN, 0 }, 
{0x098A, 0x1030, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xCC0C, WORD_LEN, 0 }, 
{0x0992, 0x05DD, WORD_LEN, 0 }, 
{0x0994, 0x35DE, WORD_LEN, 0 }, 
{0x0996, 0x4718, WORD_LEN, 0 }, 
{0x0998, 0xCE0C, WORD_LEN, 0 }, 
{0x099A, 0x45CC, WORD_LEN, 0 }, 
{0x099C, 0x0015, WORD_LEN, 0 }, 
{0x099E, 0xBDD7, WORD_LEN, 0 }, 
{0x098A, 0x1040, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x00CC, WORD_LEN, 0 }, 
{0x0992, 0x0C45, WORD_LEN, 0 }, 
{0x0994, 0xDD47, WORD_LEN, 0 }, 
{0x0996, 0xFE00, WORD_LEN, 0 }, 
{0x0998, 0x3318, WORD_LEN, 0 }, 
{0x099A, 0xCE0C, WORD_LEN, 0 }, 
{0x099C, 0x5BCC, WORD_LEN, 0 }, 
{0x099E, 0x0009, WORD_LEN, 0 }, 
{0x098A, 0x1050, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xBDD7, WORD_LEN, 0 }, 
{0x0992, 0x00CC, WORD_LEN, 0 }, 
{0x0994, 0x0C5B, WORD_LEN, 0 }, 
{0x0996, 0xFD00, WORD_LEN, 0 }, 
{0x0998, 0x33DE, WORD_LEN, 0 }, 
{0x099A, 0x3118, WORD_LEN, 0 }, 
{0x099C, 0xCE0C, WORD_LEN, 0 }, 
{0x099E, 0x65CC, WORD_LEN, 0 }, 
{0x098A, 0x1060, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0029, WORD_LEN, 0 }, 
{0x0992, 0xBDD7, WORD_LEN, 0 }, 
{0x0994, 0x00CC, WORD_LEN, 0 }, 
{0x0996, 0x0C65, WORD_LEN, 0 }, 
{0x0998, 0xDD31, WORD_LEN, 0 }, 
{0x099A, 0xDE39, WORD_LEN, 0 }, 
{0x099C, 0x18CE, WORD_LEN, 0 }, 
{0x099E, 0x0C8F, WORD_LEN, 0 }, 
{0x098A, 0x1070, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xCC00, WORD_LEN, 0 }, 
{0x0992, 0x23BD, WORD_LEN, 0 }, 
{0x0994, 0xD700, WORD_LEN, 0 }, 
{0x0996, 0xCC0C, WORD_LEN, 0 }, 
{0x0998, 0x8FDD, WORD_LEN, 0 }, 
{0x099A, 0x39DE, WORD_LEN, 0 }, 
{0x099C, 0x4918, WORD_LEN, 0 }, 
{0x099E, 0xCE0C, WORD_LEN, 0 }, 
{0x098A, 0x1080, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xB3CC, WORD_LEN, 0 }, 
{0x0992, 0x000D, WORD_LEN, 0 }, 
{0x0994, 0xBDD7, WORD_LEN, 0 }, 
{0x0996, 0x00CC, WORD_LEN, 0 }, 
{0x0998, 0x0CB3, WORD_LEN, 0 }, 
{0x099A, 0xDD49, WORD_LEN, 0 }, 
{0x099C, 0xFC04, WORD_LEN, 0 }, 
{0x099E, 0xC2FD, WORD_LEN, 0 }, 
{0x098A, 0x1090, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0BF1, WORD_LEN, 0 }, 
{0x0992, 0x18FE, WORD_LEN, 0 }, 
{0x0994, 0x0BF1, WORD_LEN, 0 }, 
{0x0996, 0xCDEE, WORD_LEN, 0 }, 
{0x0998, 0x1518, WORD_LEN, 0 }, 
{0x099A, 0xCE0C, WORD_LEN, 0 }, 
{0x099C, 0xC1CC, WORD_LEN, 0 }, 
{0x099E, 0x0029, WORD_LEN, 0 }, 
{0x098A, 0x10A0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xBDD7, WORD_LEN, 0 }, 
{0x0992, 0x00FE, WORD_LEN, 0 }, 
{0x0994, 0x0BF1, WORD_LEN, 0 }, 
{0x0996, 0xCC0C, WORD_LEN, 0 }, 
{0x0998, 0xC1ED, WORD_LEN, 0 }, 
{0x099A, 0x15CC, WORD_LEN, 0 }, 
{0x099C, 0x11A5, WORD_LEN, 0 }, 
{0x099E, 0xFD0B, WORD_LEN, 0 }, 
{0x098A, 0x10B0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xFFCC, WORD_LEN, 0 }, 
{0x0992, 0x0CFB, WORD_LEN, 0 }, 
{0x0994, 0xFD0C, WORD_LEN, 0 }, 
{0x0996, 0x21CC, WORD_LEN, 0 }, 
{0x0998, 0x128F, WORD_LEN, 0 }, 
{0x099A, 0xFD0C, WORD_LEN, 0 }, 
{0x099C, 0x53CC, WORD_LEN, 0 }, 
{0x099E, 0x114E, WORD_LEN, 0 }, 
{0x098A, 0x10C0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xFD0C, WORD_LEN, 0 }, 
{0x0992, 0x5DCC, WORD_LEN, 0 }, 
{0x0994, 0x10E2, WORD_LEN, 0 }, 
{0x0996, 0xFD0C, WORD_LEN, 0 }, 
{0x0998, 0x6FCC, WORD_LEN, 0 }, 
{0x099A, 0x0EDD, WORD_LEN, 0 }, 
{0x099C, 0xFD0C, WORD_LEN, 0 }, 
{0x099E, 0xD7CC, WORD_LEN, 0 }, 
{0x098A, 0x10D0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0EBA, WORD_LEN, 0 }, 
{0x0992, 0xFD0C, WORD_LEN, 0 }, 
{0x0994, 0xE9CC, WORD_LEN, 0 }, 
{0x0996, 0x1350, WORD_LEN, 0 }, 
{0x0998, 0xFD0C, WORD_LEN, 0 }, 
{0x099A, 0x9BCC, WORD_LEN, 0 }, 
{0x099C, 0x0E29, WORD_LEN, 0 }, 
{0x099E, 0xFD0C, WORD_LEN, 0 }, 
{0x098A, 0x10E0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xBF39, WORD_LEN, 0 }, 
{0x0992, 0x373C, WORD_LEN, 0 }, 
{0x0994, 0x3CDE, WORD_LEN, 0 }, 
{0x0996, 0x1DEC, WORD_LEN, 0 }, 
{0x0998, 0x0C5F, WORD_LEN, 0 }, 
{0x099A, 0x8402, WORD_LEN, 0 }, 
{0x099C, 0x4416, WORD_LEN, 0 }, 
{0x099E, 0x4FF7, WORD_LEN, 0 }, 
{0x098A, 0x10F0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0CEB, WORD_LEN, 0 }, 
{0x0992, 0xE60B, WORD_LEN, 0 }, 
{0x0994, 0xC407, WORD_LEN, 0 }, 
{0x0996, 0xF70C, WORD_LEN, 0 }, 
{0x0998, 0xEC7F, WORD_LEN, 0 }, 
{0x099A, 0x30C4, WORD_LEN, 0 }, 
{0x099C, 0xEC25, WORD_LEN, 0 }, 
{0x099E, 0xFD30, WORD_LEN, 0 }, 
{0x098A, 0x1100, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xC5FC, WORD_LEN, 0 }, 
{0x0992, 0x06D6, WORD_LEN, 0 }, 
{0x0994, 0xFD30, WORD_LEN, 0 }, 
{0x0996, 0xC701, WORD_LEN, 0 }, 
{0x0998, 0xFC30, WORD_LEN, 0 }, 
{0x099A, 0xC0FD, WORD_LEN, 0 }, 
{0x099C, 0x0BED, WORD_LEN, 0 }, 
{0x099E, 0xFC30, WORD_LEN, 0 }, 
{0x098A, 0x1110, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xC2FD, WORD_LEN, 0 }, 
{0x0992, 0x0BEF, WORD_LEN, 0 }, 
{0x0994, 0xFC04, WORD_LEN, 0 }, 
{0x0996, 0xC283, WORD_LEN, 0 }, 
{0x0998, 0xFFFF, WORD_LEN, 0 }, 
{0x099A, 0x2728, WORD_LEN, 0 }, 
{0x099C, 0xDE06, WORD_LEN, 0 }, 
{0x099E, 0xEC22, WORD_LEN, 0 }, 
{0x098A, 0x1120, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x8322, WORD_LEN, 0 }, 
{0x0992, 0x0026, WORD_LEN, 0 }, 
{0x0994, 0x1FCC, WORD_LEN, 0 }, 
{0x0996, 0x3064, WORD_LEN, 0 }, 
{0x0998, 0x30ED, WORD_LEN, 0 }, 
{0x099A, 0x008F, WORD_LEN, 0 }, 
{0x099C, 0xC300, WORD_LEN, 0 }, 
{0x099E, 0x02DE, WORD_LEN, 0 }, 
{0x098A, 0x1130, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0CAD, WORD_LEN, 0 }, 
{0x0992, 0x0030, WORD_LEN, 0 }, 
{0x0994, 0x1D02, WORD_LEN, 0 }, 
{0x0996, 0x01CC, WORD_LEN, 0 }, 
{0x0998, 0x3064, WORD_LEN, 0 }, 
{0x099A, 0xED00, WORD_LEN, 0 }, 
{0x099C, 0x8FC3, WORD_LEN, 0 }, 
{0x099E, 0x0002, WORD_LEN, 0 }, 
{0x098A, 0x1140, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xDE0E, WORD_LEN, 0 }, 
{0x0992, 0xAD00, WORD_LEN, 0 }, 
{0x0994, 0x30E6, WORD_LEN, 0 }, 
{0x0996, 0x04BD, WORD_LEN, 0 }, 
{0x0998, 0x5203, WORD_LEN, 0 }, 
{0x099A, 0x3838, WORD_LEN, 0 }, 
{0x099C, 0x3139, WORD_LEN, 0 }, 
{0x099E, 0x3C3C, WORD_LEN, 0 }, 
{0x098A, 0x1150, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x3C21, WORD_LEN, 0 }, 
{0x0992, 0x01CC, WORD_LEN, 0 }, 
{0x0994, 0x0018, WORD_LEN, 0 }, 
{0x0996, 0xBD6F, WORD_LEN, 0 }, 
{0x0998, 0xD1C5, WORD_LEN, 0 }, 
{0x099A, 0x0426, WORD_LEN, 0 }, 
{0x099C, 0xF5DC, WORD_LEN, 0 }, 
{0x099E, 0x2530, WORD_LEN, 0 }, 
{0x098A, 0x1160, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xED04, WORD_LEN, 0 }, 
{0x0992, 0x2012, WORD_LEN, 0 }, 
{0x0994, 0xEE04, WORD_LEN, 0 }, 
{0x0996, 0x3C18, WORD_LEN, 0 }, 
{0x0998, 0x38E6, WORD_LEN, 0 }, 
{0x099A, 0x2118, WORD_LEN, 0 }, 
{0x099C, 0xE7BE, WORD_LEN, 0 }, 
{0x099E, 0x30EE, WORD_LEN, 0 }, 
{0x098A, 0x1170, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x04EC, WORD_LEN, 0 }, 
{0x0992, 0x1D30, WORD_LEN, 0 }, 
{0x0994, 0xED04, WORD_LEN, 0 }, 
{0x0996, 0xEC04, WORD_LEN, 0 }, 
{0x0998, 0x26EA, WORD_LEN, 0 }, 
{0x099A, 0xCC00, WORD_LEN, 0 }, 
{0x099C, 0x1AED, WORD_LEN, 0 }, 
{0x099E, 0x02CC, WORD_LEN, 0 }, 
{0x098A, 0x1180, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xFBFF, WORD_LEN, 0 }, 
{0x0992, 0xED00, WORD_LEN, 0 }, 
{0x0994, 0xCC04, WORD_LEN, 0 }, 
{0x0996, 0x00BD, WORD_LEN, 0 }, 
{0x0998, 0x706D, WORD_LEN, 0 }, 
{0x099A, 0xCC00, WORD_LEN, 0 }, 
{0x099C, 0x1A30, WORD_LEN, 0 }, 
{0x099E, 0xED02, WORD_LEN, 0 }, 
{0x098A, 0x1190, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xCCFB, WORD_LEN, 0 }, 
{0x0992, 0xFFED, WORD_LEN, 0 }, 
{0x0994, 0x005F, WORD_LEN, 0 }, 
{0x0996, 0x4FBD, WORD_LEN, 0 }, 
{0x0998, 0x706D, WORD_LEN, 0 }, 
{0x099A, 0x5FBD, WORD_LEN, 0 }, 
{0x099C, 0x5B17, WORD_LEN, 0 }, 
{0x099E, 0xBD55, WORD_LEN, 0 }, 
{0x098A, 0x11A0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x8B38, WORD_LEN, 0 }, 
{0x0992, 0x3838, WORD_LEN, 0 }, 
{0x0994, 0x393C, WORD_LEN, 0 }, 
{0x0996, 0x3CC6, WORD_LEN, 0 }, 
{0x0998, 0x40F7, WORD_LEN, 0 }, 
{0x099A, 0x30C4, WORD_LEN, 0 }, 
{0x099C, 0xFC0B, WORD_LEN, 0 }, 
{0x099E, 0xEDFD, WORD_LEN, 0 }, 
{0x098A, 0x11B0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x30C0, WORD_LEN, 0 }, 
{0x0992, 0xFC0B, WORD_LEN, 0 }, 
{0x0994, 0xEFFD, WORD_LEN, 0 }, 
{0x0996, 0x30C2, WORD_LEN, 0 }, 
{0x0998, 0xDE1D, WORD_LEN, 0 }, 
{0x099A, 0xEC25, WORD_LEN, 0 }, 
{0x099C, 0xFD30, WORD_LEN, 0 }, 
{0x099E, 0xC501, WORD_LEN, 0 }, 
{0x098A, 0x11C0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0101, WORD_LEN, 0 }, 
{0x0992, 0xFC30, WORD_LEN, 0 }, 
{0x0994, 0xC2FD, WORD_LEN, 0 }, 
{0x0996, 0x06D6, WORD_LEN, 0 }, 
{0x0998, 0xEC0C, WORD_LEN, 0 }, 
{0x099A, 0x5F84, WORD_LEN, 0 }, 
{0x099C, 0x0244, WORD_LEN, 0 }, 
{0x099E, 0x164F, WORD_LEN, 0 }, 
{0x098A, 0x11D0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x30E7, WORD_LEN, 0 }, 
{0x0992, 0x03F1, WORD_LEN, 0 }, 
{0x0994, 0x0CEB, WORD_LEN, 0 }, 
{0x0996, 0x2715, WORD_LEN, 0 }, 
{0x0998, 0xF10C, WORD_LEN, 0 }, 
{0x099A, 0xEB23, WORD_LEN, 0 }, 
{0x099C, 0x09FC, WORD_LEN, 0 }, 
{0x099E, 0x06D6, WORD_LEN, 0 }, 
{0x098A, 0x11E0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x04FD, WORD_LEN, 0 }, 
{0x0992, 0x06D6, WORD_LEN, 0 }, 
{0x0994, 0x2007, WORD_LEN, 0 }, 
{0x0996, 0xFC06, WORD_LEN, 0 }, 
{0x0998, 0xD605, WORD_LEN, 0 }, 
{0x099A, 0xFD06, WORD_LEN, 0 }, 
{0x099C, 0xD6DE, WORD_LEN, 0 }, 
{0x099E, 0x1DE6, WORD_LEN, 0 }, 
{0x098A, 0x11F0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0BC4, WORD_LEN, 0 }, 
{0x0992, 0x0730, WORD_LEN, 0 }, 
{0x0994, 0xE702, WORD_LEN, 0 }, 
{0x0996, 0xF10C, WORD_LEN, 0 }, 
{0x0998, 0xEC27, WORD_LEN, 0 }, 
{0x099A, 0x2C7D, WORD_LEN, 0 }, 
{0x099C, 0x0CEC, WORD_LEN, 0 }, 
{0x099E, 0x2727, WORD_LEN, 0 }, 
{0x098A, 0x1200, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x5D27, WORD_LEN, 0 }, 
{0x0992, 0x247F, WORD_LEN, 0 }, 
{0x0994, 0x30C4, WORD_LEN, 0 }, 
{0x0996, 0xFC06, WORD_LEN, 0 }, 
{0x0998, 0xD6FD, WORD_LEN, 0 }, 
{0x099A, 0x30C5, WORD_LEN, 0 }, 
{0x099C, 0xF60C, WORD_LEN, 0 }, 
{0x099E, 0xEC4F, WORD_LEN, 0 }, 
{0x098A, 0x1210, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xFD30, WORD_LEN, 0 }, 
{0x0992, 0xC7C6, WORD_LEN, 0 }, 
{0x0994, 0x40F7, WORD_LEN, 0 }, 
{0x0996, 0x30C4, WORD_LEN, 0 }, 
{0x0998, 0xE602, WORD_LEN, 0 }, 
{0x099A, 0x4FFD, WORD_LEN, 0 }, 
{0x099C, 0x30C5, WORD_LEN, 0 }, 
{0x099E, 0x0101, WORD_LEN, 0 }, 
{0x098A, 0x1220, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x01FC, WORD_LEN, 0 }, 
{0x0992, 0x30C2, WORD_LEN, 0 }, 
{0x0994, 0xFD06, WORD_LEN, 0 }, 
{0x0996, 0xD67D, WORD_LEN, 0 }, 
{0x0998, 0x06CB, WORD_LEN, 0 }, 
{0x099A, 0x272E, WORD_LEN, 0 }, 
{0x099C, 0xC640, WORD_LEN, 0 }, 
{0x099E, 0xF730, WORD_LEN, 0 }, 
{0x098A, 0x1230, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xC4FC, WORD_LEN, 0 }, 
{0x0992, 0x06C1, WORD_LEN, 0 }, 
{0x0994, 0x04F3, WORD_LEN, 0 }, 
{0x0996, 0x06D6, WORD_LEN, 0 }, 
{0x0998, 0xED00, WORD_LEN, 0 }, 
{0x099A, 0x5F6D, WORD_LEN, 0 }, 
{0x099C, 0x002A, WORD_LEN, 0 }, 
{0x099E, 0x0153, WORD_LEN, 0 }, 
{0x098A, 0x1240, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x17FD, WORD_LEN, 0 }, 
{0x0992, 0x30C0, WORD_LEN, 0 }, 
{0x0994, 0xEC00, WORD_LEN, 0 }, 
{0x0996, 0xFD30, WORD_LEN, 0 }, 
{0x0998, 0xC2FC, WORD_LEN, 0 }, 
{0x099A, 0x06C1, WORD_LEN, 0 }, 
{0x099C, 0xFD30, WORD_LEN, 0 }, 
{0x099E, 0xC501, WORD_LEN, 0 }, 
{0x098A, 0x1250, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x0101, WORD_LEN, 0 }, 
{0x0992, 0xFC30, WORD_LEN, 0 }, 
{0x0994, 0xC2FD, WORD_LEN, 0 }, 
{0x0996, 0x06C7, WORD_LEN, 0 }, 
{0x0998, 0x2022, WORD_LEN, 0 }, 
{0x099A, 0x7F30, WORD_LEN, 0 }, 
{0x099C, 0xC4DE, WORD_LEN, 0 }, 
{0x099E, 0x1DEC, WORD_LEN, 0 }, 
{0x098A, 0x1260, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x25FD, WORD_LEN, 0 }, 
{0x0992, 0x30C5, WORD_LEN, 0 }, 
{0x0994, 0xFC06, WORD_LEN, 0 }, 
{0x0996, 0xD6FD, WORD_LEN, 0 }, 
{0x0998, 0x30C7, WORD_LEN, 0 }, 
{0x099A, 0x01FC, WORD_LEN, 0 }, 
{0x099C, 0x30C0, WORD_LEN, 0 }, 
{0x099E, 0xFD06, WORD_LEN, 0 }, 
{0x098A, 0x1270, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xD0FC, WORD_LEN, 0 }, 
{0x0992, 0x30C2, WORD_LEN, 0 }, 
{0x0994, 0xFD06, WORD_LEN, 0 }, 
{0x0996, 0xD2EC, WORD_LEN, 0 }, 
{0x0998, 0x25FD, WORD_LEN, 0 }, 
{0x099A, 0x06C3, WORD_LEN, 0 }, 
{0x099C, 0xBD95, WORD_LEN, 0 }, 
{0x099E, 0x3CDE, WORD_LEN, 0 }, 
{0x098A, 0x1280, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x3FEE, WORD_LEN, 0 }, 
{0x0992, 0x10AD, WORD_LEN, 0 }, 
{0x0994, 0x00DE, WORD_LEN, 0 }, 
{0x0996, 0x1DFC, WORD_LEN, 0 }, 
{0x0998, 0x06CC, WORD_LEN, 0 }, 
{0x099A, 0xED3E, WORD_LEN, 0 }, 
{0x099C, 0x3838, WORD_LEN, 0 }, 
{0x099E, 0x3930, WORD_LEN, 0 }, 
{0x098A, 0x1290, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x8FC3, WORD_LEN, 0 }, 
{0x0992, 0xFFEC, WORD_LEN, 0 }, 
{0x0994, 0x8F35, WORD_LEN, 0 }, 
{0x0996, 0xBDAD, WORD_LEN, 0 }, 
{0x0998, 0x15DE, WORD_LEN, 0 }, 
{0x099A, 0x198F, WORD_LEN, 0 }, 
{0x099C, 0xC301, WORD_LEN, 0 }, 
{0x099E, 0x4B8F, WORD_LEN, 0 }, 
{0x098A, 0x12A0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xEC00, WORD_LEN, 0 }, 
{0x0992, 0xFD05, WORD_LEN, 0 }, 
{0x0994, 0x0EEC, WORD_LEN, 0 }, 
{0x0996, 0x02FD, WORD_LEN, 0 }, 
{0x0998, 0x0510, WORD_LEN, 0 }, 
{0x099A, 0x8FC3, WORD_LEN, 0 }, 
{0x099C, 0xFFCB, WORD_LEN, 0 }, 
{0x099E, 0x8FE6, WORD_LEN, 0 }, 
{0x098A, 0x12B0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x00F7, WORD_LEN, 0 }, 
{0x0992, 0x0514, WORD_LEN, 0 }, 
{0x0994, 0xE603, WORD_LEN, 0 }, 
{0x0996, 0xF705, WORD_LEN, 0 }, 
{0x0998, 0x15FC, WORD_LEN, 0 }, 
{0x099A, 0x055B, WORD_LEN, 0 }, 
{0x099C, 0xFD05, WORD_LEN, 0 }, 
{0x099E, 0x12DE, WORD_LEN, 0 }, 
{0x098A, 0x12C0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x37EE, WORD_LEN, 0 }, 
{0x0992, 0x08AD, WORD_LEN, 0 }, 
{0x0994, 0x00F6, WORD_LEN, 0 }, 
{0x0996, 0x0516, WORD_LEN, 0 }, 
{0x0998, 0x4F30, WORD_LEN, 0 }, 
{0x099A, 0xED04, WORD_LEN, 0 }, 
{0x099C, 0xDE1F, WORD_LEN, 0 }, 
{0x099E, 0xEC6B, WORD_LEN, 0 }, 
{0x098A, 0x12D0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xFD05, WORD_LEN, 0 }, 
{0x0992, 0x0EEC, WORD_LEN, 0 }, 
{0x0994, 0x6DFD, WORD_LEN, 0 }, 
{0x0996, 0x0510, WORD_LEN, 0 }, 
{0x0998, 0xDE19, WORD_LEN, 0 }, 
{0x099A, 0x8FC3, WORD_LEN, 0 }, 
{0x099C, 0x0117, WORD_LEN, 0 }, 
{0x099E, 0x8FE6, WORD_LEN, 0 }, 
{0x098A, 0x12E0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x00F7, WORD_LEN, 0 }, 
{0x0992, 0x0514, WORD_LEN, 0 }, 
{0x0994, 0xE603, WORD_LEN, 0 }, 
{0x0996, 0xF705, WORD_LEN, 0 }, 
{0x0998, 0x15FC, WORD_LEN, 0 }, 
{0x099A, 0x0559, WORD_LEN, 0 }, 
{0x099C, 0xFD05, WORD_LEN, 0 }, 
{0x099E, 0x12DE, WORD_LEN, 0 }, 
{0x098A, 0x12F0, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x37EE, WORD_LEN, 0 }, 
{0x0992, 0x08AD, WORD_LEN, 0 }, 
{0x0994, 0x00F6, WORD_LEN, 0 }, 
{0x0996, 0x0516, WORD_LEN, 0 }, 
{0x0998, 0x4F30, WORD_LEN, 0 }, 
{0x099A, 0xED06, WORD_LEN, 0 }, 
{0x099C, 0xDE1F, WORD_LEN, 0 }, 
{0x099E, 0xEC6B, WORD_LEN, 0 }, 
{0x098A, 0x1300, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xFD05, WORD_LEN, 0 }, 
{0x0992, 0x0EEC, WORD_LEN, 0 }, 
{0x0994, 0x6DFD, WORD_LEN, 0 }, 
{0x0996, 0x0510, WORD_LEN, 0 }, 
{0x0998, 0xDE19, WORD_LEN, 0 }, 
{0x099A, 0x8FC3, WORD_LEN, 0 }, 
{0x099C, 0x0118, WORD_LEN, 0 }, 
{0x099E, 0x8FE6, WORD_LEN, 0 }, 
{0x098A, 0x1310, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x00F7, WORD_LEN, 0 }, 
{0x0992, 0x0514, WORD_LEN, 0 }, 
{0x0994, 0xE603, WORD_LEN, 0 }, 
{0x0996, 0xF705, WORD_LEN, 0 }, 
{0x0998, 0x15FC, WORD_LEN, 0 }, 
{0x099A, 0x0559, WORD_LEN, 0 }, 
{0x099C, 0xFD05, WORD_LEN, 0 }, 
{0x099E, 0x12DE, WORD_LEN, 0 }, 
{0x098A, 0x1320, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x37EE, WORD_LEN, 0 }, 
{0x0992, 0x08AD, WORD_LEN, 0 }, 
{0x0994, 0x00F6, WORD_LEN, 0 }, 
{0x0996, 0x0516, WORD_LEN, 0 }, 
{0x0998, 0x4F30, WORD_LEN, 0 }, 
{0x099A, 0xED08, WORD_LEN, 0 }, 
{0x099C, 0xCC32, WORD_LEN, 0 }, 
{0x099E, 0x8EED, WORD_LEN, 0 }, 
{0x098A, 0x1330, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x00EC, WORD_LEN, 0 }, 
{0x0992, 0x04BD, WORD_LEN, 0 }, 
{0x0994, 0x7021, WORD_LEN, 0 }, 
{0x0996, 0xCC32, WORD_LEN, 0 }, 
{0x0998, 0x6C30, WORD_LEN, 0 }, 
{0x099A, 0xED02, WORD_LEN, 0 }, 
{0x099C, 0xCCF8, WORD_LEN, 0 }, 
{0x099E, 0x00ED, WORD_LEN, 0 }, 
{0x098A, 0x1340, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x00A6, WORD_LEN, 0 }, 
{0x0992, 0x07E3, WORD_LEN, 0 }, 
{0x0994, 0x0884, WORD_LEN, 0 }, 
{0x0996, 0x07BD, WORD_LEN, 0 }, 
{0x0998, 0x706D, WORD_LEN, 0 }, 
{0x099A, 0x30C6, WORD_LEN, 0 }, 
{0x099C, 0x143A, WORD_LEN, 0 }, 
{0x099E, 0x3539, WORD_LEN, 0 }, 
{0x098A, 0x1350, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x3CBD, WORD_LEN, 0 }, 
{0x0992, 0x776D, WORD_LEN, 0 }, 
{0x0994, 0xCC32, WORD_LEN, 0 }, 
{0x0996, 0x5C30, WORD_LEN, 0 }, 
{0x0998, 0xED00, WORD_LEN, 0 }, 
{0x099A, 0xFC13, WORD_LEN, 0 }, 
{0x099C, 0x8683, WORD_LEN, 0 }, 
{0x099E, 0x0001, WORD_LEN, 0 }, 
{0x098A, 0x1360, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0xBD70, WORD_LEN, 0 }, 
{0x0992, 0x21CC, WORD_LEN, 0 }, 
{0x0994, 0x325E, WORD_LEN, 0 }, 
{0x0996, 0x30ED, WORD_LEN, 0 }, 
{0x0998, 0x00FC, WORD_LEN, 0 }, 
{0x099A, 0x1388, WORD_LEN, 0 }, 
{0x099C, 0x8300, WORD_LEN, 0 }, 
{0x099E, 0x01BD, WORD_LEN, 0 }, 
{0x098A, 0x1370, WORD_LEN, 0 },  	// PHYSICAL_ADDR_ACCESS
{0x0990, 0x7021, WORD_LEN, 0 }, 
{0x0992, 0x3839, WORD_LEN, 0 }, 

{0x098E, 0x0010, WORD_LEN, 0 },  	// MCU_ADDRESS [MON_ADDR]
{0x0990, 0x1000, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x0003, WORD_LEN, 0 },  	// MCU_ADDRESS [MON_ALGO]
{0x0990, 0x0004, WORD_LEN, 0 },  	// MCU_DATA_0
{ SEQUENCE_WAIT_MS,10, WORD_LEN, 0},
//  POLL  MON_PATCH_0 =>  0x01
{0x098E, 0x4815, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0004, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x485D, WORD_LEN, 0 },  	// MCU_ADDRESS
{0x0990, 0x0004, WORD_LEN, 0 },  	// MCU_DATA_0
{0x0018, 0x0028, WORD_LEN, 0 },  	// STANDBY_CONTROL_AND_STATUS
//  POLL  SEQ_STATE =>  0x01, 0x02, ..., 0x03 (11 reads)
{ SEQUENCE_WAIT_MS,10, WORD_LEN, 0},

//awb saturation
{0x098E, 0xAC31, WORD_LEN, 0 },  	
{0x0990, 0x00E8, WORD_LEN, 0 },  

// Digital Gain(5 times) / Analog Gain(14 times)

{0x098E, 0x682F, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_AE_MAX_VIRT_DGAIN]
{0x0990, 0x0040, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x6837, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_AE_MAX_VIRT_AGAIN]
{0x0990, 0x0040, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x6839, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_AE_MAX_VIRT_AGAIN]
{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0

{0x098E, 0x6835, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_AE_MAX_VIRT_DGAIN]
{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x6833, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_AE_MAX_VIRT_DGAIN]
{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0


{0x098E, 0x483E, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_CTX_A_DIGITAL_GAIN]
{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x4886, WORD_LEN, 0 },  	// MCU_ADDRESS [CAM1_CTX_B_DIGITAL_GAIN]
{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0

{0x098E, 0x6C35, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_B_CONFIG_AE_TRACK_AE_MAX_VIRT_DGAIN]
{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0
{0x098E, 0x6C39, WORD_LEN, 0 },  	// MCU_ADDRESS [PRI_B_CONFIG_AE_TRACK_AE_MAX_VIRT_AGAIN]
{0x0990, 0x0080, WORD_LEN, 0 },  	// MCU_DATA_0

{0x098E, 0xE823, WORD_LEN, 0 },  	
{0x0990, 0x0083, WORD_LEN, 0 },  

{0x098E, 0xE824, WORD_LEN, 0 },  
{0x0990, 0x007C, WORD_LEN, 0 },  	

/*{0x098E, 0x6811, WORD_LEN, 0 },  // MCU_ADDRESS [PRI_A_CONFIG_FD_ALGO_RUN]
{0x0990, 0x0002, WORD_LEN, 0 },  // MCU_DATA_0
{0x098E, 0xA005, WORD_LEN, 0 },  // MCU_ADDRESS [FD_FDPERIOD_SELECT]
{0x0990, 0x0001, WORD_LEN, 0 },  // MCU_DATA_0

{0x098E, 0x8400, WORD_LEN, 0 },  // MCU_ADDRESS [SEQ_CMD]
{0x0990, 0x0005, WORD_LEN, 0 },  // MCU_DATA_0
*/
#endif
{ SEQUENCE_END, 0x00, WORD_LEN, 0}
};

/* 720p 15fps @ 1280x720 */

static struct reginfo sensor_720p[]=
{

	{SEQUENCE_PROPERTY,SEQUENCE_CAPTURE},
	{SEQUENCE_END, 0x00}
};

/* 	1080p, 0x15fps, 0xyuv @1920x1080 */

static struct reginfo sensor_1080p[]=
{
	{SEQUENCE_PROPERTY,SEQUENCE_CAPTURE},
	{SEQUENCE_END, 0x00}
};


/* 2048*1536 QXGA */
static struct reginfo sensor_qxga[] =
{
	{SEQUENCE_PROPERTY,SEQUENCE_CAPTURE},
	{0x098E, 0x6C00, WORD_LEN, 0},       // MCU_ADDRESS [PRI_B_IMAGE_WIDTH]
	{0x0990, 0x0800, WORD_LEN, 0},       // MCU_DATA_0
	{0x098E, 0x6C02, WORD_LEN, 0},       // MCU_ADDRESS [PRI_B_IMAGE_HEIGHT]
	{0x0990, 0x0600, WORD_LEN, 0},       // MCU_DATA_0
	{SEQUENCE_WAIT_MS,100, WORD_LEN, 0},
	
	{SEQUENCE_END, 0x00}
};

/* 1600X1200 UXGA */
static struct reginfo sensor_uxga[] =
{
	{SEQUENCE_PROPERTY,SEQUENCE_CAPTURE},
	{0x098E, 0x6C00, WORD_LEN, 0},       // MCU_ADDRESS [PRI_B_IMAGE_WIDTH]
	{0x0990, 0x0640, WORD_LEN, 0},       // MCU_DATA_0
	{0x098E, 0x6C02, WORD_LEN, 0},       // MCU_ADDRESS [PRI_B_IMAGE_HEIGHT]
	{0x0990, 0x04B0, WORD_LEN, 0},       // MCU_DATA_0
	{SEQUENCE_WAIT_MS,100, WORD_LEN, 0},
	//{SEQUENCE_PROPERTY,SEQUENCE_CAPTURE},
	{SEQUENCE_END, 0x00}
};
/* 1280X1024 SXGA */
static struct reginfo sensor_sxga[] =
{
	{SEQUENCE_PROPERTY,SEQUENCE_CAPTURE},
	{SEQUENCE_END, 0x00}
};
/*  1024X768 XGA */
static struct reginfo sensor_xga[] =
{
	{SEQUENCE_PROPERTY,SEQUENCE_CAPTURE},
	{0x098E, 0x6C00, WORD_LEN, 0},       // MCU_ADDRESS [PRI_B_IMAGE_WIDTH]
	{0x0990, 0x0500, WORD_LEN, 0},       // MCU_DATA_0
	{0x098E, 0x6C02, WORD_LEN, 0},       // MCU_ADDRESS [PRI_B_IMAGE_HEIGHT]
	{0x0990, 0x03C0, WORD_LEN, 0},       // MCU_DATA_0
	{SEQUENCE_WAIT_MS,100, WORD_LEN, 0},
	//{SEQUENCE_PROPERTY,SEQUENCE_CAPTURE},
	{SEQUENCE_END, 0x00}
};

/* 800X600 SVGA*/
static struct reginfo sensor_svga[] =
{
	{SEQUENCE_PROPERTY,SEQUENCE_CAPTURE},
	{SEQUENCE_END, 0x00}
};

/* 640X480 VGA */
static struct reginfo sensor_vga[] =
{
	{0x098E, 0x6800, WORD_LEN, 0},       // MCU_ADDRESS [PRI_A_IMAGE_WIDTH]
	{0x0990, 0x0280, WORD_LEN, 0},       // MCU_DATA_0
	{0x098E, 0x6802, WORD_LEN, 0},       // MCU_ADDRESS [PRI_A_IMAGE_HEIGHT]
	{0x0990, 0x01E0, WORD_LEN, 0},       // MCU_DATA_0
	{0x098E, 0x8400, WORD_LEN, 0},       // MCU_ADDRESS [SEQ_CMD]
	{0x0990, 0x0006, WORD_LEN, 0},       // MCU_DATA_0
    	{SEQUENCE_WAIT_MS,100, WORD_LEN, 0},
    	{SEQUENCE_END, 0x00}
};

/* 352X288 CIF */
static struct reginfo sensor_cif[] =
{
	{SEQUENCE_END, 0x00}
};

/* 320*240 QVGA */
static  struct reginfo sensor_qvga[] =
{
	//{SEQUENCE_PROPERTY,SEQUENCE_CAPTURE},
	{SEQUENCE_END, 0x00}
};

/* 176X144 QCIF*/
static struct reginfo sensor_qcif[] =
{
	{SEQUENCE_END, 0x00}
};
#endif
static  struct reginfo sensor_Preview2Capture[]=
{
	//capture2preview
	{0x098E, 0xEC05, WORD_LEN, 0}, 
	{0x0990, 0x0000, WORD_LEN, 0}, 
	{0x098E, 0x8400, WORD_LEN, 0}, 
	{0x0990, 0x0002, WORD_LEN, 0}, 

	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Capture2Preview[]=
{
	//snap2preview
	{0x098E, 0xEC05, WORD_LEN, 0}, 
	{0x0990, 0x0005, WORD_LEN, 0}, 
	{0x098E, 0x8400, WORD_LEN, 0}, 
	{0x0990, 0x0001, WORD_LEN, 0}, 
	{0x098E, 0x8400, WORD_LEN, 0}, 
	{0x0990, 0x0006, WORD_LEN, 0}, 

	{SEQUENCE_WAIT_MS,50, WORD_LEN, 0},
	{SEQUENCE_END, 0x00}
};
static  struct reginfo sensor_ClrFmt_YUYV[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_ClrFmt_UYVY[]=
{
	{SEQUENCE_END, 0x00}
};


#if CONFIG_SENSOR_WhiteBalance
static  struct reginfo sensor_WhiteB_Auto[]=
{
	//Auto
	{0x098E, 0x2C03, WORD_LEN, 0},  	// MCU_ADDRESS [AWB_ALGO]
	{0x0990, 0x01FF, WORD_LEN, 0},  	// MCU_DATA_0

	{0x098E, 0xAC02, WORD_LEN, 0},  	// MCU_ADDRESS [AWB_MODE]
	{0x0990, 0x000A, WORD_LEN, 0},  	// MCU_DATA_0
	{0x098E, 0x683F, WORD_LEN, 0},  	// MCU_ADDRESS [PRI_A_CONFIG_AWB_ALGO_RUN]
	{0x0990, 0x01FF, WORD_LEN, 0},  	// MCU_DATA_0
                                       
	{0x098E, 0x8400, WORD_LEN, 0},  	// MCU_ADDRESS [SEQ_CMD]
	{0x0990, 0x0005, WORD_LEN, 0},  	// MCU_DATA_0
	
	{SEQUENCE_END, 0x00}
};
/* Cloudy Colour Temperature : 6500K - 8000K  */
static  struct reginfo sensor_WhiteB_Cloudy[]=
{
	//[V.       DL 7500]
	{0x098E, 0x48B0, WORD_LEN, 0}, 
    {0x0990, 0x01F9, WORD_LEN, 0}, 
    {0x098E, 0x48B2, WORD_LEN, 0}, 
    {0x0990, 0xFF27, WORD_LEN, 0}, 
    {0x098E, 0x48B4, WORD_LEN, 0}, 
    {0x0990, 0xFFFA, WORD_LEN, 0}, 
    {0x098E, 0x48B6, WORD_LEN, 0}, 
    {0x0990, 0xFFFD, WORD_LEN, 0}, 
    {0x098E, 0x48B8, WORD_LEN, 0}, 
    {0x0990, 0x01A6, WORD_LEN, 0}, 
    {0x098E, 0x48BA, WORD_LEN, 0}, 
    {0x0990, 0xFF76, WORD_LEN, 0}, 
    {0x098E, 0x48BC, WORD_LEN, 0}, 
    {0x0990, 0x0023, WORD_LEN, 0}, 
    {0x098E, 0x48BE, WORD_LEN, 0}, 
    {0x0990, 0xFF6A, WORD_LEN, 0}, 
    {0x098E, 0x48C0, WORD_LEN, 0}, 
    {0x0990, 0x018D, WORD_LEN, 0}, 
    {0x098E, 0x48C6, WORD_LEN, 0}, 
    {0x0990, 0x0000, WORD_LEN, 0}, 
    {0x098E, 0x48C8, WORD_LEN, 0}, 
    {0x0990, 0x0000, WORD_LEN, 0}, 
    {0x098E, 0x48CA, WORD_LEN, 0}, 
    {0x0990, 0x0000, WORD_LEN, 0}, 
    {0x098E, 0x48CC, WORD_LEN, 0}, 
    {0x0990, 0x0000, WORD_LEN, 0}, 
    {0x098E, 0x48CE, WORD_LEN, 0}, 
    {0x0990, 0x0000, WORD_LEN, 0}, 
    {0x098E, 0x48D0, WORD_LEN, 0}, 
    {0x0990, 0x0000, WORD_LEN, 0}, 
    {0x098E, 0x48D2, WORD_LEN, 0}, 
    {0x0990, 0x0000, WORD_LEN, 0}, 
    {0x098E, 0x48D4, WORD_LEN, 0}, 
    {0x0990, 0x0000, WORD_LEN, 0}, 
    {0x098E, 0x48D6, WORD_LEN, 0}, 
    {0x0990, 0x0000, WORD_LEN, 0}, 
    {0x098E, 0xAC02, WORD_LEN, 0}, 
    {0x0990, 0x0000, WORD_LEN, 0}, 
    {0x098E, 0x2C03, WORD_LEN, 0}, 
    {0x0990, 0x0000, WORD_LEN, 0}, 
    {0x098E, 0x683F, WORD_LEN, 0}, 
    {0x0990, 0x0000, WORD_LEN, 0}, 
    {0x098E, 0xAC3C, WORD_LEN, 0}, 
    {0x0990, 0x0035, WORD_LEN, 0}, 
    {0x098E, 0xAC3D, WORD_LEN, 0}, 
    {0x0990, 0x006E, WORD_LEN, 0}, 
    {0x098E, 0x8400, WORD_LEN, 0}, 
    {0x0990, 0x0005, WORD_LEN, 0}, 
	{SEQUENCE_END, 0x00}
};
/* ClearDay Colour Temperature : 5000K - 6500K  */
static  struct reginfo sensor_WhiteB_ClearDay[]=
{
	//[IV       Day Light]
	{0x098E, 0x48B0, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_0]
	{0x0990, 0x0131, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48B2, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_1]
	{0x0990, 0xFFFB, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48B4, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_2]
	{0x0990, 0x000E, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48B6, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_3]
	{0x0990, 0xFFD1, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48B8, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_4]
	{0x0990, 0x018B, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48BA, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_5]
	{0x0990, 0xFFE2, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48BC, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_6]
	{0x0990, 0x0014, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48BE, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_7]
	{0x0990, 0xFFA7, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48C0, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_8]
	{0x0990, 0x0180, WORD_LEN, 0}, 	// MCU_DATA_0

	{0x098E, 0x48C6, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_0]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48C8, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_1]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48CA, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_2]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48CC, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_3]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48CE, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_4]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48D0, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_5]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48D2, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_6]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48D4, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_7]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48D6, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_8]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0

	{0x098E, 0xAC02, WORD_LEN, 0}, 	// MCU_ADDRESS [AWB_MODE]
	{0x0990, 0x0010, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x2C03, WORD_LEN, 0}, 	// MCU_ADDRESS [AWB_ALGO]
	{0x0990, 0x0030, WORD_LEN, 0}, 	// MCU_DATA_0
                                       
	{0x098E, 0xAC3C, WORD_LEN, 0},
	{0x0990, 0x0035, WORD_LEN, 0},
	{0x098E, 0xAC3D, WORD_LEN, 0},
	{0x0990, 0x0068, WORD_LEN, 0},
	{0x098E, 0xAC33, WORD_LEN, 0},
	{0x0990, 0x004D, WORD_LEN, 0},
                                       
	{0x098E, 0x683F, WORD_LEN, 0}, 	// MCU_ADDRESS [PRI_A_CONFIG_AWB_ALGO_RUN]
	{0x0990, 0x0030, WORD_LEN, 0}, 	// MCU_DATA_0		

	{SEQUENCE_END, 0x00}
};
/* Office Colour Temperature : 3500K - 5000K  */
static  struct reginfo sensor_WhiteB_TungstenLamp1[]=
{
	//[III        Fluorescent]
	{0x098E, 0x48B0, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_0]
	{0x0990, 0x0119, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48B2, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_1]
	{0x0990, 0xFFFD, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48B4, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_2]
	{0x0990, 0x000F, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48B6, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_3]
	{0x0990, 0xFFCE, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48B8, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_4]
	{0x0990, 0x017A, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48BA, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_5]
	{0x0990, 0xFFDE, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48BC, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_6]
	{0x0990, 0x0017, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48BE, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_7]
	{0x0990, 0xFF9F, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48C0, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_8]
	{0x0990, 0x016F, WORD_LEN, 0}, 	// MCU_DATA_0

	{0x098E, 0x48C6, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_0]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48C8, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_1]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48CA, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_2]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48CC, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_3]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48CE, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_4]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48D0, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_5]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48D2, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_6]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48D4, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_7]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48D6, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_8]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
                                       
	{0x098E, 0xAC02, WORD_LEN, 0}, 	// MCU_ADDRESS [AWB_MODE]
	{0x0990, 0x0010, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x2C03, WORD_LEN, 0}, 	// MCU_ADDRESS [AWB_ALGO]
	{0x0990, 0x0030, WORD_LEN, 0}, 	// MCU_DATA_0
                                     
	{0x098E, 0xAC3C, WORD_LEN, 0},
	{0x0990, 0x004A, WORD_LEN, 0},
	{0x098E, 0xAC3D, WORD_LEN, 0},
	{0x0990, 0x0045, WORD_LEN, 0},
	{0x098E, 0xAC33, WORD_LEN, 0},
	{0x0990, 0x0034, WORD_LEN, 0},
                                       
	{0x098E, 0x683F, WORD_LEN, 0}, 	// MCU_ADDRESS [PRI_A_CONFIG_AWB_ALGO_RUN]
	{0x0990, 0x0030, WORD_LEN, 0}, 	// MCU_DATA_0
	{SEQUENCE_END, 0x00}
};
/* Home Colour Temperature : 2500K - 3500K  */
static  struct reginfo sensor_WhiteB_TungstenLamp2[]=
{
	//[II.        Incandescent]
	{0x098E, 0x48B0, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_0]
	{0x0990, 0x010F, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48B2, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_1]
	{0x0990, 0xFFFC, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48B4, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_2]
	{0x0990, 0x000F, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48B6, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_3]
	{0x0990, 0xFFCD, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48B8, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_4]
	{0x0990, 0x0172, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48BA, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_5]
	{0x0990, 0xFFDC, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48BC, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_6]
	{0x0990, 0x0018, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48BE, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_7]
	{0x0990, 0xFF9B, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48C0, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_8]
	{0x0990, 0x0167, WORD_LEN, 0}, 	// MCU_DATA_0

	{0x098E, 0x48C6, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_0]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48C8, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_1]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48CA, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_2]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48CC, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_3]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48CE, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_4]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48D0, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_5]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48D2, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_6]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48D4, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_7]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x48D6, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_8]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0

	{0x098E, 0xAC02, WORD_LEN, 0}, 	// MCU_ADDRESS [AWB_MODE]
	{0x0990, 0x0010, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0x2C03, WORD_LEN, 0}, 	// MCU_ADDRESS [AWB_ALGO]
	{0x0990, 0x0030, WORD_LEN, 0}, 	// MCU_DATA_0
                                       
	{0x098E, 0xAC3C, WORD_LEN, 0},
	{0x0990, 0x005A, WORD_LEN, 0},
	{0x098E, 0xAC3D, WORD_LEN, 0},
	{0x0990, 0x0037, WORD_LEN, 0},
	{0x098E, 0xAC33, WORD_LEN, 0},
	{0x0990, 0x0027, WORD_LEN, 0},
                                       
	{0x098E, 0x683F, WORD_LEN, 0}, 	// MCU_ADDRESS [PRI_A_CONFIG_AWB_ALGO_RUN]
	{0x0990, 0x0030, WORD_LEN, 0}, 	// MCU_DATA_0
	{SEQUENCE_END, 0x00}
};
static struct reginfo *sensor_WhiteBalanceSeqe[] = {sensor_WhiteB_Auto, sensor_WhiteB_TungstenLamp1,sensor_WhiteB_TungstenLamp2,
    sensor_WhiteB_ClearDay, sensor_WhiteB_Cloudy,NULL,
};
#endif

#if CONFIG_SENSOR_Brightness
static  struct reginfo sensor_Brightness0[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Brightness1[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Brightness2[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Brightness3[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Brightness4[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Brightness5[]=
{
	{SEQUENCE_END, 0x00}
};
static struct reginfo *sensor_BrightnessSeqe[] = {sensor_Brightness0, sensor_Brightness1, sensor_Brightness2, sensor_Brightness3,
    sensor_Brightness4, sensor_Brightness5,NULL,
};

#endif

#if CONFIG_SENSOR_Effect
static  struct reginfo sensor_Effect_Normal[] =
{
	{0x098E, 0xE883, WORD_LEN, 0}, 	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SELECT_FX]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0xEC83, WORD_LEN, 0}, 	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SELECT_FX]
	{0x0990, 0x0000, WORD_LEN, 0}, 	// MCU_DATA_0
                                        
	{0x098E, 0x8400, WORD_LEN, 0}, 	// MCU_ADDRESS [SEQ_CMD]
	{0x0990, 0x0006, WORD_LEN, 0}, 	// MCU_DATA_0
	{SEQUENCE_END, 0x00}
};

/*static  struct reginfo sensor_Effect_WandB[] =
{
	{SEQUENCE_END, 0x00}
};*/

static  struct reginfo sensor_Effect_Sepia[] =
{
	{0x098E, 0xE886, WORD_LEN, 0}, // MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SEPIA_CB]
	{0x0990, 0x00D9, WORD_LEN, 0}, // MCU_DATA_0
	{0x098E, 0xE885, WORD_LEN, 0}, // MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SEPIA_CR]
	{0x0990, 0x0018, WORD_LEN, 0}, // MCU_DATA_0
                                      
	{0x098E, 0xEC86, WORD_LEN, 0}, // MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SEPIA_CB]
	{0x0990, 0x00D9, WORD_LEN, 0}, // MCU_DATA_0
	{0x098E, 0xEC85, WORD_LEN, 0}, // MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SEPIA_CR]
	{0x0990, 0x0018, WORD_LEN, 0}, // MCU_DATA_0
                                       
	{0x098E, 0xE883, WORD_LEN, 0}, // MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SELECT_FX]
	{0x0990, 0x0002, WORD_LEN, 0}, // MCU_DATA_0
	{0x098E, 0xEC83, WORD_LEN, 0}, // MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SELECT_FX]
	{0x0990, 0x0002, WORD_LEN, 0}, // MCU_DATA_0
                                       
	{0x098E, 0x8400, WORD_LEN, 0}, // MCU_ADDRESS [SEQ_CMD]
	{0x0990, 0x0006, WORD_LEN, 0}, // MCU_DATA_0
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Effect_Negative[] =
{
	{0x098E, 0xE883, WORD_LEN, 0}, 	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SELECT_FX]
	{0x0990, 0x0003, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0xEC83, WORD_LEN, 0}, 	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SELECT_FX]
	{0x0990, 0x0003, WORD_LEN, 0}, 	// MCU_DATA_0
                                     
	{0x098E, 0x8400, WORD_LEN, 0}, 	// MCU_ADDRESS [SEQ_CMD]
	{0x0990, 0x0006, WORD_LEN, 0}, 	// MCU_DATA_0

	{SEQUENCE_END, 0x00}
};
static  struct reginfo sensor_Effect_Bluish[] =
{
	{0x098E, 0xE886, WORD_LEN, 0},	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SEPIA_CB]
	{0x0990, 0x0039, WORD_LEN, 0},	// MCU_DATA_0
	{0x098E, 0xE885, WORD_LEN, 0},	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SEPIA_CR]
	{0x0990, 0x00E8, WORD_LEN, 0},	// MCU_DATA_0                         
                                                                 
	{0x098E, 0xEC86, WORD_LEN, 0},	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SEPIA_CB]
	{0x0990, 0x0039, WORD_LEN, 0},	// MCU_DATA_0                         
	{0x098E, 0xEC85, WORD_LEN, 0},	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SEPIA_CR]
	{0x0990, 0x00E8, WORD_LEN, 0},	// MCU_DATA_0                         
                                                                
	{0x098E, 0xE883, WORD_LEN, 0},	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SELECT_FX]
	{0x0990, 0x0002, WORD_LEN, 0},	// MCU_DATA_0                         
	{0x098E, 0xEC83, WORD_LEN, 0},	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SELECT_FX]
	{0x0990, 0x0002, WORD_LEN, 0},	// MCU_DATA_0                         
                                                                
	{0x098E, 0x8400, WORD_LEN, 0},	// MCU_ADDRESS [SEQ_CMD]              
	{0x0990, 0x0006, WORD_LEN, 0},	// MCU_DATA_0  
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Effect_Green[] =
{
	{0x098E, 0xE886, WORD_LEN, 0},	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SEPIA_CB]
	{0x0990, 0x00D4, WORD_LEN, 0},	// MCU_DATA_0
	{0x098E, 0xE885, WORD_LEN, 0},	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SEPIA_CR]
	{0x0990, 0x00E8, WORD_LEN, 0},	// MCU_DATA_0
                                         
	{0x098E, 0xEC86, WORD_LEN, 0},	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SEPIA_CB]
	{0x0990, 0x00D4, WORD_LEN, 0},	// MCU_DATA_0
	{0x098E, 0xEC85, WORD_LEN, 0},	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SEPIA_CR]
	{0x0990, 0x00E8, WORD_LEN, 0},	// MCU_DATA_0
                                         
	{0x098E, 0xE883, WORD_LEN, 0},	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SELECT_FX]
	{0x0990, 0x0002, WORD_LEN, 0},	// MCU_DATA_0
	{0x098E, 0xEC83, WORD_LEN, 0},	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SELECT_FX]
	{0x0990, 0x0002, WORD_LEN, 0},	// MCU_DATA_0
                                         
	{0x098E, 0x8400, WORD_LEN, 0},	// MCU_ADDRESS [SEQ_CMD]
	{0x0990, 0x0006, WORD_LEN, 0},	// MCU_DATA_0
	{SEQUENCE_END, 0x00}
};

static struct reginfo sensor_Effect_Solarize[] =
{
	{0x098E, 0xE883, WORD_LEN, 0},	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SELECT_FX]
	{0x0990, 0x0004, WORD_LEN, 0},	// MCU_DATA_0
	{0x098E, 0xEC83, WORD_LEN, 0},	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SELECT_FX]
	{0x0990, 0x0004, WORD_LEN, 0},	// MCU_DATA_0
                                         
	{0x098E, 0x8400, WORD_LEN, 0},	// MCU_ADDRESS [SEQ_CMD]
	{0x0990, 0x0006, WORD_LEN, 0},	// MCU_DATA_0	
	{SEQUENCE_END, 0x00}
};


static struct reginfo sensor_Effect_Grayscale[] =
{
	{0x098E, 0xE883, WORD_LEN, 0}, 	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SELECT_FX]
	{0x0990, 0x0001, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0xEC83, WORD_LEN, 0}, 	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SELECT_FX]
	{0x0990, 0x0001, WORD_LEN, 0}, 	// MCU_DATA_0
                                        
	{0x098E, 0x8400, WORD_LEN, 0}, 	// MCU_ADDRESS [SEQ_CMD]
	{0x0990, 0x0006, WORD_LEN, 0}, 	// MCU_DATA_0
	{SEQUENCE_END, 0x00}
};


static struct reginfo *sensor_EffectSeqe[] = {sensor_Effect_Normal, sensor_Effect_Negative,sensor_Effect_Sepia,
    sensor_Effect_Solarize,sensor_Effect_Bluish,sensor_Effect_Green,sensor_Effect_Grayscale,NULL,
};
#endif
#if CONFIG_SENSOR_Exposure
static  struct reginfo sensor_Exposure0[]=
{
	{0x098E, 0xE81F, WORD_LEN, 0}, 	// MCU_ADDRESS [PRI_A_CONFIG_AE_RULE_BASE_TARGET]
	{0x0990, 0x000C, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0xEC1F, WORD_LEN, 0}, 	// MCU_ADDRESS [PRI_B_CONFIG_AE_RULE_BASE_TARGET]
	{0x0990, 0x000C, WORD_LEN, 0}, 	// MCU_DATA_0
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Exposure1[]=
{
	{0x098E, 0xE81F, WORD_LEN, 0},  	// MCU_ADDRESS [PRI_A_CONFIG_AE_RULE_BASE_TARGET]
	{0x0990, 0x0011, WORD_LEN, 0},  	// MCU_DATA_0
	{0x098E, 0xEC1F, WORD_LEN, 0},  	// MCU_ADDRESS [PRI_B_CONFIG_AE_RULE_BASE_TARGET]
	{0x0990, 0x0011, WORD_LEN, 0},  	// MCU_DATA_0 
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Exposure2[]=
{
	{0x098E, 0xE81F, WORD_LEN, 0},  	// MCU_ADDRESS [PRI_A_CONFIG_AE_RULE_BASE_TARGET]
	{0x0990, 0x0016, WORD_LEN, 0},  	// MCU_DATA_0
	{0x098E, 0xEC1F, WORD_LEN, 0},  	// MCU_ADDRESS [PRI_B_CONFIG_AE_RULE_BASE_TARGET]
	{0x0990, 0x0016, WORD_LEN, 0},  	// MCU_DATA_0 
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Exposure3[]=
{
	 {0x098E, 0xE81F, WORD_LEN, 0},  	// MCU_ADDRESS [PRI_A_CONFIG_AE_RULE_BASE_TARGET]
	{0x0990, 0x001B, WORD_LEN, 0},  	// MCU_DATA_0
	{0x098E, 0xEC1F, WORD_LEN, 0},  	// MCU_ADDRESS [PRI_B_CONFIG_AE_RULE_BASE_TARGET]
	{0x0990, 0x001B, WORD_LEN, 0},  	// MCU_DATA_0 
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Exposure4[]=
{
	{0x098E, 0xE81F, WORD_LEN, 0},  	// MCU_ADDRESS [PRI_A_CONFIG_AE_RULE_BASE_TARGET]
	{0x0990, 0x0020, WORD_LEN, 0},  	// MCU_DATA_0
	{0x098E, 0xEC1F, WORD_LEN, 0},  	// MCU_ADDRESS [PRI_B_CONFIG_AE_RULE_BASE_TARGET]
	{0x0990, 0x0020, WORD_LEN, 0},  	// MCU_DATA_0
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Exposure5[]=
{
	{0x098E, 0xE81F, WORD_LEN, 0},  	// MCU_ADDRESS [PRI_A_CONFIG_AE_RULE_BASE_TARGET]
	{0x0990, 0x0025, WORD_LEN, 0},  	// MCU_DATA_0
	{0x098E, 0xEC1F, WORD_LEN, 0},  	// MCU_ADDRESS [PRI_B_CONFIG_AE_RULE_BASE_TARGET]
	{0x0990, 0x0025, WORD_LEN, 0},  	// MCU_DATA_0 
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Exposure6[]=
{
	{0x098E, 0xE81F, WORD_LEN, 0},  	// MCU_ADDRESS [PRI_A_CONFIG_AE_RULE_BASE_TARGET]
	{0x0990, 0x002A, WORD_LEN, 0},  	// MCU_DATA_0
	{0x098E, 0xEC1F, WORD_LEN, 0},  	// MCU_ADDRESS [PRI_B_CONFIG_AE_RULE_BASE_TARGET]
	{0x0990, 0x002A, WORD_LEN, 0},  	// MCU_DATA_0 
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Exposure7[]=
{
	{0x098E, 0xE81F, WORD_LEN, 0},  // MCU_ADDRESS [PRI_A_CONFIG_AE_RULE_BASE_TARGET]
	{0x0990, 0x002F, WORD_LEN, 0},  // MCU_DATA_0
	{0x098E, 0xEC1F, WORD_LEN, 0},  // MCU_ADDRESS [PRI_B_CONFIG_AE_RULE_BASE_TARGET]
	{0x0990, 0x002F, WORD_LEN, 0},  // MCU_DATA_0 
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Exposure8[]=
{
	{0x098E, 0xE81F, WORD_LEN, 0}, 	// MCU_ADDRESS [PRI_A_CONFIG_AE_RULE_BASE_TARGET]
	{0x0990, 0x0034, WORD_LEN, 0}, 	// MCU_DATA_0
	{0x098E, 0xEC1F, WORD_LEN, 0}, 	// MCU_ADDRESS [PRI_B_CONFIG_AE_RULE_BASE_TARGET]
	{0x0990, 0x0034, WORD_LEN, 0}, 	// MCU_DATA_0 
	{SEQUENCE_END, 0x00}
};

static struct reginfo *sensor_ExposureSeqe[] = {sensor_Exposure0, sensor_Exposure1, sensor_Exposure2, sensor_Exposure3,
    sensor_Exposure4, sensor_Exposure5,sensor_Exposure6,sensor_Exposure7,sensor_Exposure8,NULL,
};
#endif
#if CONFIG_SENSOR_Saturation
static  struct reginfo sensor_Saturation0[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Saturation1[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Saturation2[]=
{
	{SEQUENCE_END, 0x00}
};
static struct reginfo *sensor_SaturationSeqe[] = {sensor_Saturation0, sensor_Saturation1, sensor_Saturation2, NULL,};

#endif
#if CONFIG_SENSOR_Contrast
static  struct reginfo sensor_Contrast0[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Contrast1[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Contrast2[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Contrast3[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Contrast4[]=
{
	{SEQUENCE_END, 0x00}
};


static  struct reginfo sensor_Contrast5[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Contrast6[]=
{
	{SEQUENCE_END, 0x00}
};
static struct reginfo *sensor_ContrastSeqe[] = {sensor_Contrast0, sensor_Contrast1, sensor_Contrast2, sensor_Contrast3,
    sensor_Contrast4, sensor_Contrast5, sensor_Contrast6, NULL,
};

#endif
#if CONFIG_SENSOR_Mirror
static  struct reginfo sensor_MirrorOn[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_MirrorOff[]=
{
	{SEQUENCE_END, 0x00}
};
static struct reginfo *sensor_MirrorSeqe[] = {sensor_MirrorOff, sensor_MirrorOn,NULL,};
#endif
#if CONFIG_SENSOR_Flip
static  struct reginfo sensor_FlipOn[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_FlipOff[]=
{
	{SEQUENCE_END, 0x00}
};
static struct reginfo *sensor_FlipSeqe[] = {sensor_FlipOff, sensor_FlipOn,NULL,};

#endif
#if CONFIG_SENSOR_Scene
static  struct reginfo sensor_SceneAuto[] =
{
	{0x098E, 0x483E, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_CTX_A_DIGITAL_GAIN]
	{0x0990, 0x0120, WORD_LEN, 0},	// MCU_DATA_0
	{0x098E, 0x8400, WORD_LEN, 0},	// MCU_ADDRESS [SEQ_CMD]
       	{0x0990, 0x0006, WORD_LEN, 0},	// MCU_DATA_0
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_SceneNight[] =
{
	{0x098E, 0x483E, WORD_LEN, 0}, 	// MCU_ADDRESS [CAM1_CTX_A_DIGITAL_GAIN]
	{0x0990, 0x0080, WORD_LEN, 0},	// MCU_DATA_0
	{0x098E, 0x8400, WORD_LEN, 0},	// MCU_ADDRESS [SEQ_CMD]
       	{0x0990, 0x0006, WORD_LEN, 0},	// MCU_DATA_0
	{SEQUENCE_END, 0x00}
};
static struct reginfo *sensor_SceneSeqe[] = {sensor_SceneAuto, sensor_SceneNight,NULL,};

#endif
#if CONFIG_SENSOR_DigitalZoom
static struct reginfo sensor_Zoom0[] =
{
	{SEQUENCE_END, 0x00}
};

static struct reginfo sensor_Zoom1[] =
{
	{SEQUENCE_END, 0x00}
};

static struct reginfo sensor_Zoom2[] =
{
	{SEQUENCE_END, 0x00}
};


static struct reginfo sensor_Zoom3[] =
{
	{SEQUENCE_END, 0x00}
};
static struct reginfo *sensor_ZoomSeqe[] = {sensor_Zoom0, sensor_Zoom1, sensor_Zoom2, sensor_Zoom3, NULL};
#endif
static struct v4l2_querymenu sensor_menus[] =
{
	#if CONFIG_SENSOR_WhiteBalance
    { .id = V4L2_CID_DO_WHITE_BALANCE,  .index = 0,  .name = "auto",  .reserved = 0, }, {  .id = V4L2_CID_DO_WHITE_BALANCE,  .index = 1, .name = "incandescent",  .reserved = 0,},
    { .id = V4L2_CID_DO_WHITE_BALANCE,  .index = 2,  .name = "fluorescent", .reserved = 0,}, {  .id = V4L2_CID_DO_WHITE_BALANCE, .index = 3,  .name = "daylight", .reserved = 0,},
    { .id = V4L2_CID_DO_WHITE_BALANCE,  .index = 4,  .name = "cloudy-daylight", .reserved = 0,},
    #endif

	#if CONFIG_SENSOR_Effect
    { .id = V4L2_CID_EFFECT,  .index = 0,  .name = "none",  .reserved = 0, }, {  .id = V4L2_CID_EFFECT,  .index = 1, .name = "negative",  .reserved = 0,},
    { .id = V4L2_CID_EFFECT,  .index = 2,  .name = "sepia", .reserved = 0,}, {  .id = V4L2_CID_EFFECT, .index = 3,  .name = "solarize", .reserved = 0,},
     { .id = V4L2_CID_EFFECT,  .index = 4,  .name = "bluish",  .reserved = 0, }, {  .id = V4L2_CID_EFFECT,  .index = 5, .name = "green",  .reserved = 0,},
    { .id = V4L2_CID_EFFECT,  .index = 6,  .name = "graycale", .reserved = 0,}, 
    #endif
#if CONFIG_SENSOR_Exposure
	{ .id = V4L2_CID_EXPOSURE,  .index = 0,  .name = "-4",  .reserved = 0, }, {  .id = V4L2_CID_EXPOSURE,  .index = 1, .name = "-3",  .reserved = 0,},
    	{ .id = V4L2_CID_EXPOSURE,  .index = 2,  .name = "-2", .reserved = 0,}, {  .id = V4L2_CID_EXPOSURE, .index = 3,  .name = "-1", .reserved = 0,},
     	{ .id = V4L2_CID_EXPOSURE,  .index = 4,  .name = "0",  .reserved = 0, }, {  .id = V4L2_CID_EXPOSURE,  .index = 5, .name = "+1",  .reserved = 0,},
	{ .id = V4L2_CID_EXPOSURE,  .index = 6,  .name = "+2",  .reserved = 0, }, {  .id = V4L2_CID_EXPOSURE,  .index = 7, .name = "+3",  .reserved = 0,},
	{ .id = V4L2_CID_EXPOSURE,  .index = 8,  .name = "+4",  .reserved = 0, }, 
#endif
	#if CONFIG_SENSOR_Scene
    { .id = V4L2_CID_SCENE,  .index = 0, .name = "auto", .reserved = 0,} ,{ .id = V4L2_CID_SCENE,  .index = 1,  .name = "night", .reserved = 0,},
    #endif

	#if CONFIG_SENSOR_Flash
	{ .id = V4L2_CID_FLASH,  .index = 0,  .name = "off",  .reserved = 0, }, {  .id = V4L2_CID_FLASH,  .index = 1, .name = "auto",  .reserved = 0,},
   	{ .id = V4L2_CID_FLASH,  .index = 2,  .name = "on", .reserved = 0,}, {  .id = V4L2_CID_FLASH, .index = 3,  .name = "torch", .reserved = 0,},
  
    //{ .id = V4L2_CID_FLASH,  .index = 0,  .name = "off",  .reserved = 0, }, {  .id = V4L2_CID_FLASH,  .index = 1, .name = "on",  .reserved = 0,},
    #endif
};

static  struct v4l2_queryctrl sensor_controls[] =
{
	#if CONFIG_SENSOR_WhiteBalance
    {
        .id		= V4L2_CID_DO_WHITE_BALANCE,
        .type		= V4L2_CTRL_TYPE_MENU,
        .name		= "White Balance Control",
        .minimum	= 0,
        .maximum	= 4,
        .step		= 1,
        .default_value = 0,
    },
    #endif

	#if CONFIG_SENSOR_Brightness
	{
        .id		= V4L2_CID_BRIGHTNESS,
        .type		= V4L2_CTRL_TYPE_INTEGER,
        .name		= "Brightness Control",
        .minimum	= -3,
        .maximum	= 2,
        .step		= 1,
        .default_value = 0,
    },
    #endif

	#if CONFIG_SENSOR_Effect
	{
        .id		= V4L2_CID_EFFECT,
        .type		= V4L2_CTRL_TYPE_MENU,
        .name		= "Effect Control",
        .minimum	= 0,
        .maximum	= 6,
        .step		= 1,
        .default_value = 0,
    },
	#endif

	#if CONFIG_SENSOR_Exposure
	{
        .id		= V4L2_CID_EXPOSURE,
        .type		= V4L2_CTRL_TYPE_INTEGER,
        .name		= "Exposure Control",
        .minimum	= 0,
        .maximum	= 8,
        .step		= 1,
        .default_value = 0,
    },
	#endif

	#if CONFIG_SENSOR_Saturation
	{
        .id		= V4L2_CID_SATURATION,
        .type		= V4L2_CTRL_TYPE_INTEGER,
        .name		= "Saturation Control",
        .minimum	= 0,
        .maximum	= 2,
        .step		= 1,
        .default_value = 0,
    },
    #endif

	#if CONFIG_SENSOR_Contrast
	{
        .id		= V4L2_CID_CONTRAST,
        .type		= V4L2_CTRL_TYPE_INTEGER,
        .name		= "Contrast Control",
        .minimum	= -3,
        .maximum	= 3,
        .step		= 1,
        .default_value = 0,
    },
	#endif

	#if CONFIG_SENSOR_Mirror
	{
        .id		= V4L2_CID_HFLIP,
        .type		= V4L2_CTRL_TYPE_BOOLEAN,
        .name		= "Mirror Control",
        .minimum	= 0,
        .maximum	= 1,
        .step		= 1,
        .default_value = 1,
    },
    #endif

	#if CONFIG_SENSOR_Flip
	{
        .id		= V4L2_CID_VFLIP,
        .type		= V4L2_CTRL_TYPE_BOOLEAN,
        .name		= "Flip Control",
        .minimum	= 0,
        .maximum	= 1,
        .step		= 1,
        .default_value = 1,
    },
    #endif

	#if CONFIG_SENSOR_Scene
    {
        .id		= V4L2_CID_SCENE,
        .type		= V4L2_CTRL_TYPE_MENU,
        .name		= "Scene Control",
        .minimum	= 0,
        .maximum	= 1,
        .step		= 1,
        .default_value = 0,
    },
    #endif

	#if CONFIG_SENSOR_DigitalZoom
    {
        .id		= V4L2_CID_ZOOM_RELATIVE,
        .type		= V4L2_CTRL_TYPE_INTEGER,
        .name		= "DigitalZoom Control",
        .minimum	= -1,
        .maximum	= 1,
        .step		= 1,
        .default_value = 0,
    }, {
        .id		= V4L2_CID_ZOOM_ABSOLUTE,
        .type		= V4L2_CTRL_TYPE_INTEGER,
        .name		= "DigitalZoom Control",
        .minimum	= 0,
        .maximum	= 3,
        .step		= 1,
        .default_value = 0,
    },
    #endif

	#if CONFIG_SENSOR_Focus
	/*{
        .id		= V4L2_CID_FOCUS_RELATIVE,
        .type		= V4L2_CTRL_TYPE_INTEGER,
        .name		= "Focus Control",
        .minimum	= -1,
        .maximum	= 1,
        .step		= 1,
        .default_value = 0,
    }, {
        .id		= V4L2_CID_FOCUS_ABSOLUTE,
        .type		= V4L2_CTRL_TYPE_INTEGER,
        .name		= "Focus Control",
        .minimum	= 0,
        .maximum	= 255,
        .step		= 1,
        .default_value = 125,
    },
	{
        .id		= V4L2_CID_FOCUS_AUTO,
        .type		= V4L2_CTRL_TYPE_BOOLEAN,
        .name		= "Focus Control",
        .minimum	= 0,
        .maximum	= 1,
        .step		= 1,
        .default_value = 0,
    },*/{
        .id		= V4L2_CID_FOCUS_CONTINUOUS,
        .type		= V4L2_CTRL_TYPE_BOOLEAN,
        .name		= "Focus Control",
        .minimum	= 0,
        .maximum	= 1,
        .step		= 1,
        .default_value = 0,
    },
    #endif

	#if CONFIG_SENSOR_Flash
	{
        .id		= V4L2_CID_FLASH,
        .type		= V4L2_CTRL_TYPE_MENU,
       // .type		= V4L2_CTRL_TYPE_BOOLEAN,
        .name		= "Flash Control",
        .minimum	= 0,
        .maximum	= 3,
         //.maximum	= 1,
        .step		= 1,
        .default_value = 0,
    },
	#endif
};

static int sensor_probe(struct i2c_client *client, const struct i2c_device_id *did);
static int sensor_video_probe(struct soc_camera_device *icd, struct i2c_client *client);
static int sensor_g_control(struct v4l2_subdev *sd, struct v4l2_control *ctrl);
static int sensor_s_control(struct v4l2_subdev *sd, struct v4l2_control *ctrl);
static int sensor_g_ext_controls(struct v4l2_subdev *sd,  struct v4l2_ext_controls *ext_ctrl);
static int sensor_s_ext_controls(struct v4l2_subdev *sd,  struct v4l2_ext_controls *ext_ctrl);
static int sensor_suspend(struct soc_camera_device *icd, pm_message_t pm_msg);
static int sensor_resume(struct soc_camera_device *icd);
static int sensor_set_bus_param(struct soc_camera_device *icd,unsigned long flags);
static unsigned long sensor_query_bus_param(struct soc_camera_device *icd);
static int sensor_set_effect(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value);
static int sensor_set_whiteBalance(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value);
static int sensor_deactivate(struct i2c_client *client);

static struct soc_camera_ops sensor_ops =
{
    .suspend                     = sensor_suspend,
    .resume                       = sensor_resume,
    .set_bus_param		= sensor_set_bus_param,
    .query_bus_param	= sensor_query_bus_param,
    .controls		= sensor_controls,
    .menus                         = sensor_menus,
    .num_controls		= ARRAY_SIZE(sensor_controls),
    .num_menus		= ARRAY_SIZE(sensor_menus),
};

/* only one fixed colorspace per pixelcode */
struct sensor_datafmt {
	enum v4l2_mbus_pixelcode code;
	enum v4l2_colorspace colorspace;
};

/* Find a data format by a pixel code in an array */
static const struct sensor_datafmt *sensor_find_datafmt(
	enum v4l2_mbus_pixelcode code, const struct sensor_datafmt *fmt,
	int n)
{
	int i;
	for (i = 0; i < n; i++)
		if (fmt[i].code == code)
			return fmt + i;

	return NULL;
}

static const struct sensor_datafmt sensor_colour_fmts[] = {
    {V4L2_MBUS_FMT_UYVY8_2X8, V4L2_COLORSPACE_JPEG},
    {V4L2_MBUS_FMT_YUYV8_2X8, V4L2_COLORSPACE_JPEG}	
};


enum sensor_work_state
{
	sensor_work_ready = 0,
	sensor_working,
};
struct sensor_work
{
	struct i2c_client *client;
	struct delayed_work dwork;
	enum sensor_work_state state;
};

typedef struct sensor_info_priv_s
{
    int whiteBalance;
    int brightness;
    int contrast;
    int saturation;
    int effect;
    int scene;
    int digitalzoom;
    int focus;
	int auto_focus;
	int affm_reinit;
    int flash;
    int exposure;
    unsigned char mirror;                                        /* HFLIP */
    unsigned char flip;                                          /* VFLIP */
	bool snap2preview;
	bool video2preview;
	int capture_w;
	int capture_h;
	int preview_w;
	int preview_h;
    struct reginfo *winseqe_cur_addr;
	struct sensor_datafmt fmt;
	unsigned int enable;
	unsigned int funmodule_state;
} sensor_info_priv_t;



struct sensor_parameter
{
	unsigned short int preview_maxlines;
	unsigned short int preview_exposure;
	unsigned short int preview_line_width;
	unsigned short int preview_gain;

	unsigned short int capture_framerate;
	unsigned short int preview_framerate;
};

struct sensor
{
    struct v4l2_subdev subdev;
    struct i2c_client *client;
    sensor_info_priv_t info_priv;
	struct sensor_parameter parameter;
	struct workqueue_struct *sensor_wq;
	struct sensor_work sensor_wk;
	struct mutex wq_lock;
    int model;	/* V4L2_IDENT_OV* codes from v4l2-chip-ident.h */
#if CONFIG_SENSOR_I2C_NOSCHED
	atomic_t tasklock_cnt;
#endif
	struct rk29camera_platform_data *sensor_io_request;
    struct rk29camera_gpio_res *sensor_gpio_res;
};

static struct sensor* to_sensor(const struct i2c_client *client)
{
    return container_of(i2c_get_clientdata(client), struct sensor, subdev);
}

static int sensor_task_lock(struct i2c_client *client, int lock)
{
#if CONFIG_SENSOR_I2C_NOSCHED
	int cnt = 3;
    struct sensor *sensor = to_sensor(client);

	if (lock) {
		if (atomic_read(&sensor->tasklock_cnt) == 0) {
			while ((atomic_read(&client->adapter->bus_lock.count) < 1) && (cnt>0)) {
				SENSOR_TR("\n %s will obtain i2c in atomic, but i2c bus is locked! Wait...\n",SENSOR_NAME_STRING());
				msleep(35);
				cnt--;
			}
			if ((atomic_read(&client->adapter->bus_lock.count) < 1) && (cnt<=0)) {
				SENSOR_TR("\n %s obtain i2c fail in atomic!!\n",SENSOR_NAME_STRING());
				goto sensor_task_lock_err;
			}
			preempt_disable();
		}

		atomic_add(1, &sensor->tasklock_cnt);
	} else {
		if (atomic_read(&sensor->tasklock_cnt) > 0) {
			atomic_sub(1, &sensor->tasklock_cnt);

			if (atomic_read(&sensor->tasklock_cnt) == 0)
				preempt_enable();
		}
	}
    
	return 0;
sensor_task_lock_err:
	return -1;    
#else
    return 0;
#endif
}

/* sensor register write */

#if CONFIG_SENSOR_WRITE_REGS
static int sensor_write_regs(struct i2c_client *client,  u8 *reg_info, int num)
{
	int err=0,cnt;
	struct i2c_msg msg[1];

	msg->len = num;	
	msg->addr = client->addr;	
	msg->flags = client->flags;	
	msg->buf = reg_info;	
	msg->scl_rate = CONFIG_SENSOR_I2C_SPEED;         /* ddl@rock-chips.com : 100kHz */	
	msg->read_type = 0;               /* fpga i2c:0==I2C_NORMAL : direct use number not enum for don't want include spi_fpga.h */	

	
	cnt= 3;	
	err = -EAGAIN;
	
	while ((cnt-- > 0) && (err < 0)) {                       /* ddl@rock-chips.com :  Transfer again if transent is failed   */		
		err = i2c_transfer(client->adapter, msg, 1);		
		if (err >= 0) {		            
			return 0;		
		} else {		            
			SENSOR_TR("\n %s write reg failed, try to write again!\n",	SENSOR_NAME_STRING());		            
			udelay(10);	
		}	
	}
	
	return err;

}

#endif

static int sensor_write(struct i2c_client *client, struct reginfo *reg_info)
{
    int err=0,cnt;
    u8 buf[4];
    struct i2c_msg msg[1];

	switch (reg_info->reg)
	{
		case SEQUENCE_WAIT_MS:
		{
			if (in_atomic())
				mdelay(reg_info->val);
			else
				msleep(reg_info->val);
			break;
		}

		case SEQUENCE_WAIT_US:
		{
			udelay(reg_info->val);
			break;
		}

		case SEQUENCE_PROPERTY:
		{
			break;
		}
		default:
		{
		    buf[0] = reg_info->reg >> 8;
		    buf[1] = reg_info->reg & 0xFF;
			if (reg_info->reg_len == WORD_LEN) {
				buf[2] = reg_info->val >> 8;
				buf[3] = reg_info->val & 0xFF;

				msg->len = 4;
			} else if (reg_info->reg_len == BYTE_LEN) {
				buf[2] = reg_info->val;
				msg->len = 3;
			}

		    msg->addr = client->addr;
		    msg->flags = client->flags;
		    msg->buf = buf;
		    msg->scl_rate = CONFIG_SENSOR_I2C_SPEED;         /* ddl@rock-chips.com : 100kHz */
		    msg->read_type = 0;               /* fpga i2c:0==I2C_NORMAL : direct use number not enum for don't want include spi_fpga.h */

		    cnt = 3;
		    err = -EAGAIN;

		    while ((cnt-- > 0) && (err < 0)) {                       /* ddl@rock-chips.com :  Transfer again if transent is failed   */
		        err = i2c_transfer(client->adapter, msg, 1);

		        if (err >= 0) {
		            return 0;
		        } else {
		            SENSOR_TR("\n %s write reg(0x%x, val:0x%x) failed, try to write again!\n",SENSOR_NAME_STRING(),reg_info->reg, reg_info->val);
		            udelay(10);
		        }
		    }
		}
	}
    return err;
}

/* sensor register read */
static int sensor_read(struct i2c_client *client, u16 reg, u16 *val)
{
    int err,cnt;
    u8 buf[2];
    u16 temp_val;
    struct i2c_msg msg[2];

    buf[0] = reg >> 8;
    buf[1] = reg & 0xFF;

    msg[0].addr = client->addr;
    msg[0].flags = client->flags;
    msg[0].buf = buf;
    msg[0].len = sizeof(buf);
    msg[0].scl_rate = CONFIG_SENSOR_I2C_SPEED;       /* ddl@rock-chips.com : 100kHz */
    msg[0].read_type = 2;   /* fpga i2c:0==I2C_NO_STOP : direct use number not enum for don't want include spi_fpga.h */

    msg[1].addr = client->addr;
    msg[1].flags = client->flags|I2C_M_RD;
    msg[1].buf = buf;
    msg[1].len = 2;
    msg[1].scl_rate = CONFIG_SENSOR_I2C_SPEED;                       /* ddl@rock-chips.com : 100kHz */
    msg[1].read_type = 2;                             /* fpga i2c:0==I2C_NO_STOP : direct use number not enum for don't want include spi_fpga.h */

    cnt = 3;
    err = -EAGAIN;
    while ((cnt-- > 0) && (err < 0)) {                       /* ddl@rock-chips.com :  Transfer again if transent is failed   */
        err = i2c_transfer(client->adapter, msg, 2);

        if (err >= 0) {
		temp_val = buf[0];
		temp_val = temp_val << 8;
		temp_val = temp_val |buf[1];
            	*val = temp_val;
            return 0;
        } else {
        	SENSOR_TR("\n %s read reg(0x%x val:0x%x) failed, try to read again! \n",SENSOR_NAME_STRING(),reg, *val);
            udelay(10);
        }
    }

    return err;
}

/* write a array of registers  */
static int sensor_write_array(struct i2c_client *client, struct reginfo *regarray)
{
    int err = 0, cnt;
    int i = 0;
#if CONFIG_SENSOR_WRITE_REGS	
	int j = 0, reg_num;
	u8 *ptemp, *phead;
	int reg_length = 2;
#endif

#if CONFIG_SENSOR_I2C_RDWRCHK
	char valchk;
#endif

	cnt = 0;
	if (sensor_task_lock(client, 1) < 0)
		goto sensor_write_array_end;
    while (regarray[i].reg != SEQUENCE_END) {
#if CONFIG_SENSOR_WRITE_REGS
		j = i;		
		reg_num = 1;	
		
		if(WORD_LEN == regarray[i].reg_len) {
			reg_length = 0x0002;
		} else if (BYTE_LEN == regarray[i].reg_len) {
			reg_length = 0x0001;
		}
				
		while((regarray[i].reg + reg_length) == regarray[i+1].reg) {			
			i++;			
			reg_num++;		
		}
		
		if(reg_num > 1) {
			int size_num;
			
			if(0x0002 == reg_length) {
				size_num = 2*(reg_num + 1);
			} else {
				size_num = reg_num + 1;
			}
			
			ptemp = phead = (u8*)kmalloc(size_num*sizeof(u8),GFP_KERNEL);
            if (phead == NULL) {
				SENSOR_TR("%s write registers allocate memory fail!!!\n",SENSOR_NAME_STRING());
                i = j;
                err = sensor_write(client, &regarray[i]);                
			} else {			
    			*phead = regarray[j].reg >> 8;			
    			*(ptemp+1) = regarray[j].reg & 0xFF;		    	
    						
    			ptemp += 2;			
    					
    			if(0x0002 == reg_length) {
    				int temp = 0;	
    				for( ; reg_num > 0; reg_num --, j++, temp ++) {
    					*(ptemp + 2*temp) =  regarray[j].val >> 8;				
    					*(ptemp + 2*temp + 1) =  regarray[j].val & 0xFF;	
    				}
    			} else {
    				for( ; reg_num > 0; reg_num --, j++)
    				{
    					*ptemp ++ = regarray[j].val;
    				}
    			}
    			
    			ptemp = phead;
    			err = sensor_write_regs(client, ptemp,size_num);			
    			kfree(phead);	
			}
		} else {		
			err = sensor_write(client, &regarray[i]);	
		}
#else
		err = sensor_write(client, &regarray[i]);
#endif
        if (err < 0) {
            if (cnt-- > 0) {
			    SENSOR_TR("%s..write failed current reg:0x%x, Write array again !\n", SENSOR_NAME_STRING(),regarray[i].reg);
				i = 0;
				continue;
            } else {
                SENSOR_TR("%s..write array failed!!!\n", SENSOR_NAME_STRING());
                err = -EPERM;
				goto sensor_write_array_end;
            }
        } else {
        #if CONFIG_SENSOR_I2C_RDWRCHK
			sensor_read(client, regarray[i].reg, &valchk);
			if (valchk != regarray[i].val)
				SENSOR_TR("%s Reg:0x%x write(0x%x, 0x%x) fail\n",SENSOR_NAME_STRING(), regarray[i].reg, regarray[i].val, valchk);
		#endif
        }

        i++;
    }

sensor_write_array_end:
	sensor_task_lock(client,0);
    return err;
}
#if CONFIG_SENSOR_I2C_RDWRCHK
static int sensor_readchk_array(struct i2c_client *client, struct reginfo *regarray)
{
    int cnt;
    int i = 0;
	char valchk;

	cnt = 0;
	valchk = 0;
    while (regarray[i].reg != SEQUENCE_END)
    {
		sensor_read(client, regarray[i].reg, &valchk);
		if (valchk != regarray[i].val)
			SENSOR_TR("%s Reg:0x%x read(0x%x, 0x%x) error\n",SENSOR_NAME_STRING(), regarray[i].reg, regarray[i].val, valchk);

        i++;
    }
    return 0;
}
#endif
#if CONFIG_SENSOR_Focus
static struct reginfo sensor_af_init0[] =
{
	{0x098E, 0x4403, WORD_LEN, 0}, 
	{0x0990, 0x8001, WORD_LEN, 0}, 
	{0x098E, 0x440B, WORD_LEN, 0}, 
	{0x0990, 0x0000, WORD_LEN, 0}, //032
	{0x098E, 0x440D, WORD_LEN, 0}, 
	{0x0990, 0x03B6, WORD_LEN, 0}, 
	{0x098E, 0x8400, WORD_LEN, 0}, 
	{0x0990, 0x0006, WORD_LEN, 0}, 


	{0x098E, 0x3003, WORD_LEN, 0}, 
	{0x0990, 0x0001, WORD_LEN, 0}, 
	{0x098E, 0xB024, WORD_LEN, 0}, 
	{0x0990, 0x0000, WORD_LEN, 0}, 
	{0x098E, 0x3003, WORD_LEN, 0}, 
	{0x0990, 0x0010, WORD_LEN, 0}, 
	{0x098E, 0xB019, WORD_LEN, 0}, 
	{0x0990, 0x0001, WORD_LEN, 0}, 
	{0x098E, 0xB019, WORD_LEN, 0}, 
	{0x0990, 0x0001, WORD_LEN, 0}, 
	{0x098E, 0xB019, WORD_LEN, 0}, 
	{0x0990, 0x0001, WORD_LEN, 0}, 
	{SEQUENCE_END, 0x00}
};


static struct reginfo sensor_af_trigger[] =
{
	{SEQUENCE_END, 0x00}
};
static int sensor_af_single(struct i2c_client *client)
{
	int ret = 0;

	ret = sensor_write_array(client, sensor_af_trigger);
	if (ret<0)
	{
		SENSOR_TR("%s sensor auto focus trigger fail!!\n",SENSOR_NAME_STRING());
		goto sensor_af_single_end;
	}else{
		SENSOR_DG("%s sensor auto focus trigger success!\n",SENSOR_NAME_STRING());
	}
sensor_af_single_end:
	return ret;
}

static int sensor_af_const(struct i2c_client *client)
{
	int ret = 0;

//sensor_af_const_end:
	return ret;
}
#if 0
static int sensor_af_zoneupdate(struct i2c_client *client)
{
	int ret = 0;

	return ret;
}
#endif
static int sensor_af_init(struct i2c_client *client)
{
	int ret = 0;

	ret = sensor_write_array(client, sensor_af_init0);
	if (ret<0) {
		SENSOR_TR("%s sensor auto focus init_0 fail!!",SENSOR_NAME_STRING());
	}

	return ret;
}
#endif

static int sensor_ioctrl(struct soc_camera_device *icd,enum rk29sensor_power_cmd cmd, int on)
{
	struct soc_camera_link *icl = to_soc_camera_link(icd);
	int ret = 0;

    SENSOR_DG("%s %s  cmd(%d) on(%d)\n",SENSOR_NAME_STRING(),__FUNCTION__,cmd,on);
	switch (cmd)
	{
		case Sensor_PowerDown:
		{
			if (icl->powerdown) {
				ret = icl->powerdown(icd->pdev, on);
				if (ret == RK29_CAM_IO_SUCCESS) {
					if (on == 0) {
						mdelay(2);
						if (icl->reset)
							icl->reset(icd->pdev);
					}
				} else if (ret == RK29_CAM_EIO_REQUESTFAIL) {
					ret = -ENODEV;
					goto sensor_power_end;
				}
			}
			break;
		}
		case Sensor_Flash:
		{
			struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));
    		struct sensor *sensor = to_sensor(client);

			if (sensor->sensor_io_request && sensor->sensor_io_request->sensor_ioctrl) {
				sensor->sensor_io_request->sensor_ioctrl(icd->pdev,Cam_Flash, on);
                if(on){
                    //flash off after 2 secs
            		hrtimer_cancel(&(flash_off_timer.timer));
            		hrtimer_start(&(flash_off_timer.timer),ktime_set(0, 800*1000*1000),HRTIMER_MODE_REL);
                    }
			}
			break;
		}
		default:
		{
			SENSOR_TR("%s %s cmd(0x%x) is unknown!",SENSOR_NAME_STRING(),__FUNCTION__,cmd);
			break;
		}
	}

sensor_power_end:
	return ret;
}


static enum hrtimer_restart flash_off_func(struct hrtimer *timer){
	struct flash_timer *fps_timer = container_of(timer, struct flash_timer, timer);
    sensor_ioctrl(fps_timer->icd,Sensor_Flash,0);
	SENSOR_DG("%s %s !!!!!!",SENSOR_NAME_STRING(),__FUNCTION__);
    return 0;
    
}

static int sensor_init(struct v4l2_subdev *sd, u32 val)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct soc_camera_device *icd = client->dev.platform_data;
    struct sensor *sensor = to_sensor(client);
	const struct v4l2_queryctrl *qctrl;
    const struct sensor_datafmt *fmt;
    int ret,pid = 0;
#if (SENSOR_RESET_REG != SEQUENCE_END)
    struct reginfo reg_info;
#endif

	if (sensor_ioctrl(icd, Sensor_PowerDown, 0) < 0) {
		ret = -ENODEV;
		goto sensor_INIT_ERR;
	}

    /* soft reset */
	if (sensor_task_lock(client,1)<0)
		goto sensor_INIT_ERR;

#if (SENSOR_RESET_REG != SEQUENCE_END)
	reg_info.reg = SENSOR_RESET_REG;
	reg_info.val = SENSOR_RESET_VAL;
	reg_info.reg_len = SENSOR_RESET_REG_LEN;
    ret = sensor_write(client, &reg_info);
    if (ret != 0) {
        SENSOR_TR("%s soft reset sensor failed\n",SENSOR_NAME_STRING());
        ret = -ENODEV;
		goto sensor_INIT_ERR;
    }

    mdelay(5);  //delay 5 microseconds
#endif
	/* check if it is an sensor sensor */
#if (SENSOR_ID_REG != SEQUENCE_END)
    ret = sensor_read(client, SENSOR_ID_REG, &pid);
    if (ret != 0) {
        SENSOR_TR("read chip id failed\n");
        ret = -ENODEV;
        goto sensor_INIT_ERR;
    }
	
    SENSOR_DG("\n %s  pid = 0x%x \n", SENSOR_NAME_STRING(), pid);
#else
	pid = SENSOR_ID;
#endif
    if (pid == SENSOR_ID) {
        sensor->model = SENSOR_V4L2_IDENT;
    } else {
        SENSOR_TR("error: %s mismatched   pid = 0x%x\n", SENSOR_NAME_STRING(), pid);
        ret = -ENODEV;
        goto sensor_INIT_ERR;
    }
	
    ret = sensor_write_array(client, sensor_init_data);
    if (ret != 0)
    {
        SENSOR_TR("error: %s initial failed\n",SENSOR_NAME_STRING());
        goto sensor_INIT_ERR;
    }	
	sensor_task_lock(client,0);
	
    sensor->info_priv.preview_w = SENSOR_INIT_WIDTH;
    sensor->info_priv.preview_h = SENSOR_INIT_HEIGHT;
    sensor->info_priv.capture_w = SENSOR_MAX_WIDTH;
    sensor->info_priv.capture_h = SENSOR_MAX_HEIGHT;
	sensor->info_priv.winseqe_cur_addr  = SENSOR_INIT_WINSEQADR;
    fmt = sensor_find_datafmt(SENSOR_INIT_PIXFMT,sensor_colour_fmts, ARRAY_SIZE(sensor_colour_fmts));
    if (!fmt) {
        SENSOR_TR("error: %s initial array colour fmts is not support!!",SENSOR_NAME_STRING());
        ret = -EINVAL;
        goto sensor_INIT_ERR;
    }
	sensor->info_priv.fmt = *fmt;
    /* sensor sensor information for initialization  */
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_DO_WHITE_BALANCE);
	if (qctrl)
    	sensor->info_priv.whiteBalance = qctrl->default_value;
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_BRIGHTNESS);
	if (qctrl)
    	sensor->info_priv.brightness = qctrl->default_value;
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_EFFECT);
	if (qctrl)
    	sensor->info_priv.effect = qctrl->default_value;
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_EXPOSURE);
	if (qctrl)
        sensor->info_priv.exposure = qctrl->default_value;

	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_SATURATION);
	if (qctrl)
        sensor->info_priv.saturation = qctrl->default_value;
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_CONTRAST);
	if (qctrl)
        sensor->info_priv.contrast = qctrl->default_value;
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_HFLIP);
	if (qctrl)
        sensor->info_priv.mirror = qctrl->default_value;
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_VFLIP);
	if (qctrl)
        sensor->info_priv.flip = qctrl->default_value;
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_SCENE);
	if (qctrl)
        sensor->info_priv.scene = qctrl->default_value;
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_ZOOM_ABSOLUTE);
	if (qctrl)
        sensor->info_priv.digitalzoom = qctrl->default_value;

    /* ddl@rock-chips.com : if sensor support auto focus and flash, programer must run focus and flash code  */
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_FOCUS_ABSOLUTE);
	if (qctrl)
        sensor->info_priv.focus = qctrl->default_value;
	#if CONFIG_SENSOR_Focus
	if (sensor_af_init(client) < 0) {
		sensor->info_priv.funmodule_state &= ~SENSOR_AF_IS_OK;
	} else {
		sensor->info_priv.funmodule_state |= SENSOR_AF_IS_OK;
	}
	#endif
	#if CONFIG_SENSOR_Flash
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_FLASH);
	if (qctrl)
	{
        	sensor->info_priv.flash = qctrl->default_value;
	}
    flash_off_timer.icd = icd;
	flash_off_timer.timer.function = flash_off_func;
    #endif
    SENSOR_DG("\n%s..%s.. icd->width = %d.. icd->height %d\n",SENSOR_NAME_STRING(),((val == 0)?__FUNCTION__:"sensor_reinit"),icd->user_width,icd->user_height);
 

    sensor->info_priv.funmodule_state |= SENSOR_INIT_IS_OK;
    return 0;
sensor_INIT_ERR:
    sensor->info_priv.funmodule_state &= ~SENSOR_INIT_IS_OK;
	sensor_task_lock(client,0);
	sensor_deactivate(client); 
    return ret;
}
static int sensor_deactivate(struct i2c_client *client)
{
	struct soc_camera_device *icd = client->dev.platform_data;
	u16 reg_val = 0;
    struct sensor *sensor = to_sensor(client);
    struct reginfo reg_info;
    
	SENSOR_DG("\n%s..%s.. Enter\n",SENSOR_NAME_STRING(),__FUNCTION__);

	/* ddl@rock-chips.com : all sensor output pin must change to input for other sensor */
    if (sensor->info_priv.funmodule_state & SENSOR_INIT_IS_OK) {
    	sensor_task_lock(client, 1);
    	
    	sensor_read( client, 0x001a, &reg_val);
    	reg_info.reg = 0x001a;
    	reg_info.val = reg_val & (~0x0200);//reg_val & (~0x02);
    	reg_info.reg_len = 0x04;
    	sensor_write(client, &reg_info);
    	
    	sensor_task_lock(client, 0);
    }
	sensor_ioctrl(icd, Sensor_PowerDown, 1);
	/* ddl@rock-chips.com : sensor config init width , because next open sensor quickly(soc_camera_open -> Try to configure with default parameters) */
	icd->user_width = SENSOR_INIT_WIDTH;
    icd->user_height = SENSOR_INIT_HEIGHT;
	msleep(100);
    sensor->info_priv.funmodule_state &= ~SENSOR_INIT_IS_OK;
	return 0;
}
static  struct reginfo sensor_power_down_sequence[]=
{
    {0x00,0x00}
};
static int sensor_suspend(struct soc_camera_device *icd, pm_message_t pm_msg)
{
    int ret;
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if (pm_msg.event == PM_EVENT_SUSPEND) {
        SENSOR_DG("\n %s Enter Suspend.. \n", SENSOR_NAME_STRING());
        ret = sensor_write_array(client, sensor_power_down_sequence) ;
        if (ret != 0) {
            SENSOR_TR("\n %s..%s WriteReg Fail.. \n", SENSOR_NAME_STRING(),__FUNCTION__);
            return ret;
        } else {
            ret = sensor_ioctrl(icd, Sensor_PowerDown, 1);
            if (ret < 0) {
			    SENSOR_TR("\n %s suspend fail for turn on power!\n", SENSOR_NAME_STRING());
                return -EINVAL;
            }
        }
    } else {
        SENSOR_TR("\n %s cann't suppout Suspend..\n",SENSOR_NAME_STRING());
        return -EINVAL;
    }

    return 0;
}

static int sensor_resume(struct soc_camera_device *icd)
{
	int ret;

    ret = sensor_ioctrl(icd, Sensor_PowerDown, 0);
    if (ret < 0) {
		SENSOR_TR("\n %s resume fail for turn on power!\n", SENSOR_NAME_STRING());
        return -EINVAL;
    }

	SENSOR_DG("\n %s Enter Resume.. \n", SENSOR_NAME_STRING());
	return 0;
}

static int sensor_set_bus_param(struct soc_camera_device *icd,
                                unsigned long flags)
{

    return 0;
}

static unsigned long sensor_query_bus_param(struct soc_camera_device *icd)
{
    struct soc_camera_link *icl = to_soc_camera_link(icd);
    unsigned long flags = SENSOR_BUS_PARAM;

    return soc_camera_apply_sensor_flags(icl, flags);
}

static int sensor_g_fmt(struct v4l2_subdev *sd, struct v4l2_mbus_framefmt *mf)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct soc_camera_device *icd = client->dev.platform_data;
    struct sensor *sensor = to_sensor(client);

    mf->width	= icd->user_width;
	mf->height	= icd->user_height;
	mf->code	= sensor->info_priv.fmt.code;
	mf->colorspace	= sensor->info_priv.fmt.colorspace;
	mf->field	= V4L2_FIELD_NONE;

    return 0;
}
#if 0
static bool sensor_fmt_capturechk(struct v4l2_subdev *sd, struct v4l2_mbus_framefmt *mf)
{
    bool ret = false;

	if ((mf->width == 1024) && (mf->height == 768)) {
		ret = true;
	} else if ((mf->width == 1280) && (mf->height == 1024)) {
		ret = true;
	} else if ((mf->width == 1600) && (mf->height == 1200)) {
		ret = true;
	} else if ((mf->width == 2048) && (mf->height == 1536)) {
		ret = true;
	} else if ((mf->width == 2592) && (mf->height == 1944)) {
		ret = true;
	}

	if (ret == true)
		SENSOR_DG("%s %dx%d is capture format\n", __FUNCTION__, mf->width, mf->height);
	return ret;
}

static bool sensor_fmt_videochk(struct v4l2_subdev *sd, struct v4l2_mbus_framefmt *mf)
{
    bool ret = false;
    /*
	if ((mf->width == 1280) && (mf->height == 720)) {
		ret = true;
	} else if ((mf->width == 1920) && (mf->height == 1080)) {
		ret = true;
	}
    */
	if (ret == true)
		SENSOR_DG("%s %dx%d is video format\n", __FUNCTION__, mf->width, mf->height);
	return ret;
}
#endif
static struct reginfo* sensor_fmt_catch(int set_w, int set_h, int *ret_w, int *ret_h)
{
	struct reginfo *winseqe_set_addr = NULL;

    if (set_w*240 == set_h*320) {   
        if (((set_w >= 320) && (set_h >= 240)) && (sensor_qvga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_qvga;
            *ret_w = 320;
            *ret_h = 240;
    	} 
        if (((set_w >= 640) && (set_h >= 480)) && (sensor_vga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_vga;
            *ret_w = 640;
            *ret_h = 480;
        } 
        if (((set_w >= 800) && (set_h >= 600)) && (sensor_svga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_svga;
            *ret_w = 800;
            *ret_h = 600;
        } 
        if (((set_w >= 1024) && (set_h >= 768)) && (sensor_xga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_xga;
            *ret_w = 1024;
            *ret_h = 768;
    	} 
        if (((set_w >= 1280) && (set_h >= 1024)) && (sensor_sxga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_sxga;
            *ret_w = 1280;
            *ret_h = 1024;
        } 
        if (((set_w >= 1600) && (set_h >= 1200)) && (sensor_uxga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_uxga;
            *ret_w = 1600;
            *ret_h = 1200;
    	} 
        if (((set_w >= 2048) && (set_h >= 1536)) && (sensor_qxga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_qxga;
            *ret_w = 2048;
            *ret_h = 1536;
        } 

        if (winseqe_set_addr == NULL) {
            if (((set_w <= 176) && (set_h <= 144)) && (sensor_qcif[0].reg!=SEQUENCE_END)) {
        		winseqe_set_addr = sensor_qcif;
                *ret_w = 176;
                *ret_h = 144;
        	} else if (((set_w <= 352) && (set_h<= 288)) && (sensor_cif[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_cif;
                *ret_w = 352;
                *ret_h = 288;
            }

	   if (((set_w <= 640) && (set_h <= 480)) && (sensor_vga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_vga;
                *ret_w = 640;
                *ret_h = 480;
            } else if (((set_w <= 1280) && (set_h <= 720)) && (sensor_720p[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_720p;
                *ret_w = 1280;
                *ret_h = 720;
            } else if (((set_w <= 1920) && (set_h <= 1080)) && (sensor_1080p[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_1080p;
                *ret_w = 1920;
                *ret_h = 1080;
            } 
        }

    } else if (set_w*288 == set_h*352) {
        if (((set_w >= 176) && (set_h >= 144)) && (sensor_qcif[0].reg!=SEQUENCE_END)) {
    		winseqe_set_addr = sensor_qcif;
            *ret_w = 176;
            *ret_h = 144;
    	} else if (((set_w >= 352) && (set_h >= 288)) && (sensor_cif[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_cif;
            *ret_w = 352;
            *ret_h = 288;
        }

        if (winseqe_set_addr == NULL) {
            if (((set_w <= 320) && (set_h <= 240)) && (sensor_qvga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_qvga;
                *ret_w = 320;
                *ret_h = 240;
        	} else if (((set_w <= 640) && (set_h <= 480)) && (sensor_vga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_vga;
                *ret_w = 640;
                *ret_h = 480;
            } else if (((set_w <= 800) && (set_h <= 600)) && (sensor_svga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_svga;
                *ret_w = 800;
                *ret_h = 600;
            } else if (((set_w <= 1024) && (set_h <= 768)) && (sensor_xga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_xga;
                *ret_w = 1024;
                *ret_h = 768;
        	} else if (((set_w <= 1280) && (set_h <= 1024)) && (sensor_sxga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_sxga;
                *ret_w = 1280;
                *ret_h = 1024;
            } else if (((set_w <= 1600) && (set_h <= 1200)) && (sensor_uxga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_uxga;
                *ret_w = 1600;
                *ret_h = 1200;
        	} else if (((set_w <= 2048) && (set_h <= 1536)) && (sensor_qxga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_qxga;
                *ret_w = 2048;
                *ret_h = 1536;
            }       


            if (((set_w <= 1280) && (set_h <= 720)) && (sensor_720p[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_720p;
                *ret_w = 1280;
                *ret_h = 720;
            } else if (((set_w <= 1920) && (set_h <= 1080)) && (sensor_1080p[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_1080p;
                *ret_w = 1920;
                *ret_h = 1080;
            }  
        }
    } else if (set_w*720 == set_h*1280) {
        if (((set_w >= 1280) && (set_h >= 720)) && (sensor_720p[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_720p;
            *ret_w = 1280;
            *ret_h = 720;
        } else if (((set_w >= 1920) && (set_h >= 1080)) && (sensor_1080p[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_1080p;
            *ret_w = 1920;
            *ret_h = 1080;
        }

        if (winseqe_set_addr == NULL) {
    
            if (((set_w <= 176) && (set_h <= 144)) && (sensor_qcif[0].reg!=SEQUENCE_END)) {
        		winseqe_set_addr = sensor_qcif;
                *ret_w = 176;
                *ret_h = 144;
        	} else if (((set_w <= 352) && (set_h<= 288)) && (sensor_cif[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_cif;
                *ret_w = 352;
                *ret_h = 288;
            }
        
            if (((set_w <= 320) && (set_h <= 240)) && (sensor_qvga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_qvga;
                *ret_w = 320;
                *ret_h = 240;
        	} else if (((set_w <= 640) && (set_h <= 480)) && (sensor_vga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_vga;
                *ret_w = 640;
                *ret_h = 480;
            } else if (((set_w <= 800) && (set_h <= 600)) && (sensor_svga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_svga;
                *ret_w = 800;
                *ret_h = 600;
            } else if (((set_w <= 1024) && (set_h <= 768)) && (sensor_xga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_xga;
                *ret_w = 1024;
                *ret_h = 768;
        	} else if (((set_w <= 1280) && (set_h <= 1024)) && (sensor_sxga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_sxga;
                *ret_w = 1280;
                *ret_h = 1024;
            } else if (((set_w <= 1600) && (set_h <= 1200)) && (sensor_uxga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_uxga;
                *ret_w = 1600;
                *ret_h = 1200;
        	} else if (((set_w <= 2048) && (set_h <= 1536)) && (sensor_qxga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_qxga;
                *ret_w = 2048;
                *ret_h = 1536;
            } 
        }
    } else {
        if (((set_w <= 176) && (set_h <= 144)) && (sensor_qcif[0].reg!=SEQUENCE_END)) {
    		winseqe_set_addr = sensor_qcif;
            *ret_w = 176;
            *ret_h = 144;
    	} else if (((set_w <= 320) && (set_h <= 240)) && (sensor_qvga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_qvga;
            *ret_w = 320;
            *ret_h = 240;
    	} else if (((set_w <= 352) && (set_h<= 288)) && (sensor_cif[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_cif;
            *ret_w = 352;
            *ret_h = 288;
        } else if (((set_w <= 640) && (set_h <= 480)) && (sensor_vga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_vga;
            *ret_w = 640;
            *ret_h = 480;
        } else if (((set_w <= 800) && (set_h <= 600)) && (sensor_svga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_svga;
            *ret_w = 800;
            *ret_h = 600;
        } else if (((set_w <= 1024) && (set_h <= 768)) && (sensor_xga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_xga;
            *ret_w = 1024;
            *ret_h = 768;
    	} else if (((set_w <= 1280) && (set_h <= 720)) && (sensor_720p[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_720p;
            *ret_w = 1280;
            *ret_h = 720;
        } else if (((set_w <= 1280) && (set_h <= 1024)) && (sensor_sxga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_sxga;
            *ret_w = 1280;
            *ret_h = 1024;
        } else if (((set_w <= 1600) && (set_h <= 1200)) && (sensor_uxga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_uxga;
            *ret_w = 1600;
            *ret_h = 1200;
    	} else if (((set_w <= 1920) && (set_h <= 1080)) && (sensor_1080p[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_1080p;
            *ret_w = 1920;
            *ret_h = 1080;
        } else if (((set_w <= 2048) && (set_h <= 1536)) && (sensor_qxga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_qxga;
            *ret_w = 2048;
            *ret_h = 1536;
        }       
    }
    
	return winseqe_set_addr;
}

static int sensor_s_fmt(struct v4l2_subdev *sd, struct v4l2_mbus_framefmt *mf)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);
    const struct sensor_datafmt *fmt;
    struct soc_camera_device *icd = client->dev.platform_data;
    struct sensor *sensor = to_sensor(client);
    struct reginfo *winseqe_set_addr=NULL;
    int ret = 0, set_w,set_h;
    //u16 seq_state=0;

    fmt = sensor_find_datafmt(mf->code, sensor_colour_fmts,
				   ARRAY_SIZE(sensor_colour_fmts));
	if (!fmt) {
        ret = -EINVAL;
        goto sensor_s_fmt_end;
    }

	if (sensor->info_priv.fmt.code != mf->code) {
		switch (mf->code)
		{
			case V4L2_MBUS_FMT_YUYV8_2X8:
			{
				winseqe_set_addr = sensor_ClrFmt_YUYV;
				break;
			}
			case V4L2_MBUS_FMT_UYVY8_2X8:
			{
				winseqe_set_addr = sensor_ClrFmt_UYVY;
				break;
			}
			default:
				break;
		}
		if (winseqe_set_addr != NULL) {
            sensor_write_array(client, winseqe_set_addr);
			sensor->info_priv.fmt.code = mf->code;
            sensor->info_priv.fmt.colorspace= mf->colorspace;            
			SENSOR_DG("%s v4l2_mbus_code:%d set success!\n", SENSOR_NAME_STRING(),mf->code);
		} else {
			SENSOR_TR("%s v4l2_mbus_code:%d is invalidate!\n", SENSOR_NAME_STRING(),mf->code);
		}
	}

    set_w = mf->width;
    set_h = mf->height;

	winseqe_set_addr = sensor_fmt_catch(set_w, set_h, &set_w, &set_h);

    if ((winseqe_set_addr  != sensor->info_priv.winseqe_cur_addr) && winseqe_set_addr) {
        ret |= sensor_write_array(client, winseqe_set_addr);
        if (ret != 0) {
            SENSOR_TR("%s set format capability failed\n", SENSOR_NAME_STRING());
            goto sensor_s_fmt_end;
        }
		
        sensor->info_priv.winseqe_cur_addr  = winseqe_set_addr;
		if ((winseqe_set_addr[0].reg==SEQUENCE_PROPERTY) && (winseqe_set_addr[0].val==SEQUENCE_CAPTURE)) {

        } else {
			sensor->info_priv.preview_w = mf->width;
			sensor->info_priv.preview_h = mf->height;
		}
    }
    	
	if (winseqe_set_addr && (winseqe_set_addr[0].reg==SEQUENCE_PROPERTY) && (winseqe_set_addr[0].val==SEQUENCE_CAPTURE)) {

	/*#if CONFIG_SENSOR_Flash
        	if( (sensor->info_priv.flash == 1)|| (sensor->info_priv.flash == 2)) {
           		sensor_ioctrl(icd, Sensor_Flash, Flash_On);
			 //sensor_ioctrl(icd, Sensor_Flash, Flash_Torch);
        	}
        #endif   */
		

		ret |= sensor_write_array(client, sensor_Preview2Capture);
		if (ret != 0) {
        	SENSOR_TR("%s Preview 2 Capture failed\n", SENSOR_NAME_STRING());
		    goto sensor_s_fmt_end;
    	}
        SENSOR_DG("%s Preview 2 Capture success!\n", SENSOR_NAME_STRING());

        #if CONFIG_SENSOR_Flash
        if( (sensor->info_priv.flash == 1)|| (sensor->info_priv.flash == 2)) {
           sensor_ioctrl(icd, Sensor_Flash, Flash_On);
			 //sensor_ioctrl(icd, Sensor_Flash, Flash_Torch);
            //SENSOR_DG("----flash-------%s    sensor->info_priv.flash = %d ,flash on in capture!\n", SENSOR_NAME_STRING(),sensor->info_priv.flash);
        }
        #endif 
       
		sensor->info_priv.capture_w = set_w;
		sensor->info_priv.capture_h = set_h;
		sensor->info_priv.snap2preview = true;
	} else if (sensor->info_priv.snap2preview == true) {
		if (winseqe_set_addr || ((sensor->info_priv.preview_w == mf->width) && (sensor->info_priv.preview_h == mf->height))) {
			#if CONFIG_SENSOR_Flash
            if ((sensor->info_priv.flash == 1) || (sensor->info_priv.flash == 2)) {
                sensor_ioctrl(icd, Sensor_Flash, Flash_Off);
            }
            #endif    
			ret |= sensor_write_array(client, sensor_Capture2Preview);
			if (ret != 0) {
	        	SENSOR_TR("%s Capture 2 Preview failed !!\n", SENSOR_NAME_STRING());
	        	goto sensor_s_fmt_end;
	    	}
            
	        mdelay(200);  //delay  microseconds to forbid invalidate data
			
            SENSOR_DG("%s Capture 2 Preview success\n", SENSOR_NAME_STRING());

           /* #if CONFIG_SENSOR_Flash
            if ((sensor->info_priv.flash == 1) || (sensor->info_priv.flash == 2)) {
                sensor_ioctrl(icd, Sensor_Flash, Flash_Off);
            }
            #endif     */   
    		sensor->info_priv.preview_w = mf->width;
    		sensor->info_priv.preview_h = mf->height;
    		sensor->info_priv.snap2preview = false;
		} else {
			SENSOR_TR("\n %s..%s Format is Invalidate. mf->width = %d.. mf->height = %d\n",SENSOR_NAME_STRING(),__FUNCTION__,mf->width,mf->height);
		}
	}

	mf->width = set_w;
	mf->height = set_h;
sensor_s_fmt_end:
    return ret;
}

static int sensor_try_fmt(struct v4l2_subdev *sd, struct v4l2_mbus_framefmt *mf)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct sensor *sensor = to_sensor(client);
    const struct sensor_datafmt *fmt;
    int ret = 0;
   
	fmt = sensor_find_datafmt(mf->code, sensor_colour_fmts,
				   ARRAY_SIZE(sensor_colour_fmts));
	if (fmt == NULL) {
		fmt = &sensor->info_priv.fmt;
        mf->code = fmt->code;
	} 

    if (mf->height > SENSOR_MAX_HEIGHT)
        mf->height = SENSOR_MAX_HEIGHT;
    else if (mf->height < SENSOR_MIN_HEIGHT)
        mf->height = SENSOR_MIN_HEIGHT;

    if (mf->width > SENSOR_MAX_WIDTH)
        mf->width = SENSOR_MAX_WIDTH;
    else if (mf->width < SENSOR_MIN_WIDTH)
        mf->width = SENSOR_MIN_WIDTH;
    mf->colorspace = fmt->colorspace;
	if (sensor_fmt_catch(mf->width, mf->height, &mf->width, &mf->height) == NULL) {
		mf->width = 0;
		mf->height = 0;
	}

    return ret;
}

 static int sensor_g_chip_ident(struct v4l2_subdev *sd, struct v4l2_dbg_chip_ident *id)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);

    if (id->match.type != V4L2_CHIP_MATCH_I2C_ADDR)
        return -EINVAL;

    if (id->match.addr != client->addr)
        return -ENODEV;

    id->ident = SENSOR_V4L2_IDENT;      /* ddl@rock-chips.com :  Return OV2655  identifier */
    id->revision = 0;

    return 0;
}
#if CONFIG_SENSOR_Brightness
static int sensor_set_brightness(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_BrightnessSeqe[value - qctrl->minimum] != NULL)
        {
            if (sensor_write_array(client, sensor_BrightnessSeqe[value - qctrl->minimum]) != 0)
            {
                SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                return -EINVAL;
            }
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
	SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Effect
static int sensor_set_effect(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_EffectSeqe[value - qctrl->minimum] != NULL)
        {
            if (sensor_write_array(client, sensor_EffectSeqe[value - qctrl->minimum]) != 0)
            {
                SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                return -EINVAL;
            }
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
	SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Exposure
static int sensor_set_exposure(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_ExposureSeqe[value - qctrl->minimum] != NULL)
        {
            if (sensor_write_array(client, sensor_ExposureSeqe[value - qctrl->minimum]) != 0)
            {
                SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                return -EINVAL;
            }
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
	SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Saturation
static int sensor_set_saturation(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_SaturationSeqe[value - qctrl->minimum] != NULL)
        {
            if (sensor_write_array(client, sensor_SaturationSeqe[value - qctrl->minimum]) != 0)
            {
                SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                return -EINVAL;
            }
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
    SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Contrast
static int sensor_set_contrast(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_ContrastSeqe[value - qctrl->minimum] != NULL)
        {
            if (sensor_write_array(client, sensor_ContrastSeqe[value - qctrl->minimum]) != 0)
            {
                SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                return -EINVAL;
            }
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
    SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Mirror
static int sensor_set_mirror(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_MirrorSeqe[value - qctrl->minimum] != NULL)
        {
            if (sensor_write_array(client, sensor_MirrorSeqe[value - qctrl->minimum]) != 0)
            {
                SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                return -EINVAL;
            }
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
    SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Flip
static int sensor_set_flip(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_FlipSeqe[value - qctrl->minimum] != NULL)
        {
            if (sensor_write_array(client, sensor_FlipSeqe[value - qctrl->minimum]) != 0)
            {
                SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                return -EINVAL;
            }
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
    SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Scene
static int sensor_set_scene(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_SceneSeqe[value - qctrl->minimum] != NULL)
        {
            if (sensor_write_array(client, sensor_SceneSeqe[value - qctrl->minimum]) != 0)
            {
                SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                return -EINVAL;
            }
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
    SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_WhiteBalance
static int sensor_set_whiteBalance(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_WhiteBalanceSeqe[value - qctrl->minimum] != NULL)
        {
            if (sensor_write_array(client, sensor_WhiteBalanceSeqe[value - qctrl->minimum]) != 0)
            {
                SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                return -EINVAL;
            }
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
	SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_DigitalZoom
static int sensor_set_digitalzoom(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int *value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));
    struct sensor *sensor = to_sensor(client);
	const struct v4l2_queryctrl *qctrl_info;
    int digitalzoom_cur, digitalzoom_total;

	qctrl_info = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_ZOOM_ABSOLUTE);
	if (qctrl_info)
		return -EINVAL;

    digitalzoom_cur = sensor->info_priv.digitalzoom;
    digitalzoom_total = qctrl_info->maximum;

    if ((*value > 0) && (digitalzoom_cur >= digitalzoom_total))
    {
        SENSOR_TR("%s digitalzoom is maximum - %x\n", SENSOR_NAME_STRING(), digitalzoom_cur);
        return -EINVAL;
    }

    if  ((*value < 0) && (digitalzoom_cur <= qctrl_info->minimum))
    {
        SENSOR_TR("%s digitalzoom is minimum - %x\n", SENSOR_NAME_STRING(), digitalzoom_cur);
        return -EINVAL;
    }

    if ((*value > 0) && ((digitalzoom_cur + *value) > digitalzoom_total))
    {
        *value = digitalzoom_total - digitalzoom_cur;
    }

    if ((*value < 0) && ((digitalzoom_cur + *value) < 0))
    {
        *value = 0 - digitalzoom_cur;
    }

    digitalzoom_cur += *value;

    if (sensor_ZoomSeqe[digitalzoom_cur] != NULL)
    {
        if (sensor_write_array(client, sensor_ZoomSeqe[digitalzoom_cur]) != 0)
        {
            SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
            return -EINVAL;
        }
        SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, *value);
        return 0;
    }

    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Flash
static int sensor_set_flash(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{	
    if ((value >= qctrl->minimum) && (value <= qctrl->maximum)) {
        if (value == 3) {       /* ddl@rock-chips.com: torch */
            sensor_ioctrl(icd, Sensor_Flash, Flash_Torch);   /* Flash On */
        } else {
            sensor_ioctrl(icd, Sensor_Flash, Flash_Off);
        }
        SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
        return 0;
    }
    
	SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Focus
static int sensor_set_focus_absolute(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
	struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));
    struct sensor *sensor = to_sensor(client);
	const struct v4l2_queryctrl *qctrl_info;
	int ret = 0;

	qctrl_info = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_FOCUS_ABSOLUTE);
	if (!qctrl_info)
	{
		return -EINVAL;
	}
	if ((sensor->info_priv.funmodule_state & SENSOR_AF_IS_OK) && (sensor->info_priv.affm_reinit == 0)) {
		if ((value >= qctrl_info->minimum) && (value <= qctrl_info->maximum)) {

			SENSOR_DG("%s..%s : %d  ret:0x%x\n",SENSOR_NAME_STRING(),__FUNCTION__, value,ret);
		} else {
			ret = -EINVAL;
			SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
			goto sensor_set_focus_absolute_end;
		}
	} else {
		ret = -EACCES;
		SENSOR_TR("\n %s..%s AF module state(0x%x, 0x%x) is error!\n",SENSOR_NAME_STRING(),__FUNCTION__,
			sensor->info_priv.funmodule_state,sensor->info_priv.affm_reinit);
	}

sensor_set_focus_absolute_end:
	return ret;
}
static int sensor_set_focus_relative(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
	struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));
	struct sensor *sensor = to_sensor(client);
	const struct v4l2_queryctrl *qctrl_info;
	int ret = 0;

	qctrl_info = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_FOCUS_RELATIVE);
	if (!qctrl_info)
	{
		ret = -EINVAL;
		goto sensor_set_focus_relative_end;
		//return -EINVAL;
	}
	if ((sensor->info_priv.funmodule_state & SENSOR_AF_IS_OK) && (sensor->info_priv.affm_reinit == 0)) {
		if ((value >= qctrl_info->minimum) && (value <= qctrl_info->maximum)) {

			SENSOR_DG("%s..%s : %d  ret:0x%x\n",SENSOR_NAME_STRING(),__FUNCTION__, value,ret);
		} else {
			ret = -EINVAL;
			SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
		}
	} else {
		ret = -EACCES;
		SENSOR_TR("\n %s..%s AF module state(0x%x, 0x%x) is error!\n",SENSOR_NAME_STRING(),__FUNCTION__,
			sensor->info_priv.funmodule_state,sensor->info_priv.affm_reinit);
	}
sensor_set_focus_relative_end:
	return ret;
}

static int sensor_set_focus_mode(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
	struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));
	struct sensor *sensor = to_sensor(client);
	int ret = 0;
	if ((sensor->info_priv.funmodule_state & SENSOR_AF_IS_OK)  && (sensor->info_priv.affm_reinit == 0)) {
		switch (value)
		{
			case SENSOR_AF_MODE_AUTO:
			{
				ret = sensor_af_single(client);
				break;
			}

			case SENSOR_AF_MODE_MACRO:
			{
				ret = sensor_set_focus_absolute(icd, qctrl, 0xff);
				break;
			}

			case SENSOR_AF_MODE_INFINITY:
			{
				ret = sensor_set_focus_absolute(icd, qctrl, 0x00);
				break;
			}

			case SENSOR_AF_MODE_CONTINUOUS:
			{
				ret = sensor_af_const(client);
				break;
			}
			default:
				SENSOR_TR("\n %s..%s AF value(0x%x) is error!\n",SENSOR_NAME_STRING(),__FUNCTION__,value);
				break;

		}

		SENSOR_DG("%s..%s : %d  ret:0x%x\n",SENSOR_NAME_STRING(),__FUNCTION__, value,ret);
	} else {
		ret = -EACCES;
		SENSOR_TR("\n %s..%s AF module state(0x%x, 0x%x) is error!\n",SENSOR_NAME_STRING(),__FUNCTION__,
			sensor->info_priv.funmodule_state,sensor->info_priv.affm_reinit);
	}

	return ret;
}
#endif
static int sensor_g_control(struct v4l2_subdev *sd, struct v4l2_control *ctrl)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct sensor *sensor = to_sensor(client);
    const struct v4l2_queryctrl *qctrl;
    SENSOR_DG("\n%s..%s.. \n",__FUNCTION__,SENSOR_NAME_STRING());

    qctrl = soc_camera_find_qctrl(&sensor_ops, ctrl->id);

    if (!qctrl)
    {
        SENSOR_TR("\n %s ioctrl id = 0x%x  is invalidate \n", SENSOR_NAME_STRING(), ctrl->id);
        return -EINVAL;
    }

    switch (ctrl->id)
    {
        case V4L2_CID_BRIGHTNESS:
            {
                ctrl->value = sensor->info_priv.brightness;
                break;
            }
        case V4L2_CID_SATURATION:
            {
                ctrl->value = sensor->info_priv.saturation;
                break;
            }
        case V4L2_CID_CONTRAST:
            {
                ctrl->value = sensor->info_priv.contrast;
                break;
            }
        case V4L2_CID_DO_WHITE_BALANCE:
            {
                ctrl->value = sensor->info_priv.whiteBalance;
                break;
            }
        case V4L2_CID_EXPOSURE:
            {
                ctrl->value = sensor->info_priv.exposure;
                break;
            }
        case V4L2_CID_HFLIP:
            {
                ctrl->value = sensor->info_priv.mirror;
                break;
            }
        case V4L2_CID_VFLIP:
            {
                ctrl->value = sensor->info_priv.flip;
                break;
            }
        default :
                break;
    }
    return 0;
}



static int sensor_s_control(struct v4l2_subdev *sd, struct v4l2_control *ctrl)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct sensor *sensor = to_sensor(client);
    struct soc_camera_device *icd = client->dev.platform_data;
    const struct v4l2_queryctrl *qctrl;
    SENSOR_DG("\n%s..%s.. \n",__FUNCTION__,SENSOR_NAME_STRING());


    qctrl = soc_camera_find_qctrl(&sensor_ops, ctrl->id);

    if (!qctrl)
    {
        SENSOR_TR("\n %s ioctrl id = 0x%x  is invalidate \n", SENSOR_NAME_STRING(), ctrl->id);
        return -EINVAL;
    }
	
    switch (ctrl->id)
    {
#if CONFIG_SENSOR_Brightness
        case V4L2_CID_BRIGHTNESS:
            {
                if (ctrl->value != sensor->info_priv.brightness)
                {
                    if (sensor_set_brightness(icd, qctrl,ctrl->value) != 0)
                    {
                        return -EINVAL;
                    }
                    sensor->info_priv.brightness = ctrl->value;
                }
                break;
            }
#endif
#if CONFIG_SENSOR_Exposure
        case V4L2_CID_EXPOSURE:
            {
                if (ctrl->value != sensor->info_priv.exposure)
                {
                    if (sensor_set_exposure(icd, qctrl,ctrl->value) != 0)
                    {
                        return -EINVAL;
                    }
                    sensor->info_priv.exposure = ctrl->value;
                }
                break;
            }
#endif
#if CONFIG_SENSOR_Saturation
        case V4L2_CID_SATURATION:
            {
                if (ctrl->value != sensor->info_priv.saturation)
                {
                    if (sensor_set_saturation(icd, qctrl,ctrl->value) != 0)
                    {
                        return -EINVAL;
                    }
                    sensor->info_priv.saturation = ctrl->value;
                }
                break;
            }
#endif
#if CONFIG_SENSOR_Contrast
        case V4L2_CID_CONTRAST:
            {
                if (ctrl->value != sensor->info_priv.contrast)
                {
                    if (sensor_set_contrast(icd, qctrl,ctrl->value) != 0)
                    {
                        return -EINVAL;
                    }
                    sensor->info_priv.contrast = ctrl->value;
                }
                break;
            }
#endif
#if CONFIG_SENSOR_WhiteBalance
        case V4L2_CID_DO_WHITE_BALANCE:
            {
                if (ctrl->value != sensor->info_priv.whiteBalance)
                {
                    if (sensor_set_whiteBalance(icd, qctrl,ctrl->value) != 0)
                    {
                        return -EINVAL;
                    }
                    sensor->info_priv.whiteBalance = ctrl->value;
                }
                break;
            }
#endif
#if CONFIG_SENSOR_Mirror
        case V4L2_CID_HFLIP:
            {
                if (ctrl->value != sensor->info_priv.mirror)
                {
                    if (sensor_set_mirror(icd, qctrl,ctrl->value) != 0)
                        return -EINVAL;
                    sensor->info_priv.mirror = ctrl->value;
                }
                break;
            }
#endif
#if CONFIG_SENSOR_Flip
        case V4L2_CID_VFLIP:
            {
                if (ctrl->value != sensor->info_priv.flip)
                {
                    if (sensor_set_flip(icd, qctrl,ctrl->value) != 0)
                        return -EINVAL;
                    sensor->info_priv.flip = ctrl->value;
                }
                break;
            }
#endif
        default:
            break;
    }

    return 0;
}
static int sensor_g_ext_control(struct soc_camera_device *icd , struct v4l2_ext_control *ext_ctrl)
{
    const struct v4l2_queryctrl *qctrl;
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));
    struct sensor *sensor = to_sensor(client);
    SENSOR_DG("\n%s..%s.. \n",__FUNCTION__,SENSOR_NAME_STRING());

    qctrl = soc_camera_find_qctrl(&sensor_ops, ext_ctrl->id);

    if (!qctrl)
    {
        SENSOR_TR("\n %s ioctrl id = 0x%x  is invalidate \n", SENSOR_NAME_STRING(), ext_ctrl->id);
        return -EINVAL;
    }

    switch (ext_ctrl->id)
    {
        case V4L2_CID_SCENE:
            {
                ext_ctrl->value = sensor->info_priv.scene;
                break;
            }
        case V4L2_CID_EFFECT:
            {
                ext_ctrl->value = sensor->info_priv.effect;
                break;
            }
        case V4L2_CID_ZOOM_ABSOLUTE:
            {
                ext_ctrl->value = sensor->info_priv.digitalzoom;
                break;
            }
        case V4L2_CID_ZOOM_RELATIVE:
            {
                return -EINVAL;
            }
        case V4L2_CID_FOCUS_ABSOLUTE:
            {
                return -EINVAL;
            }
        case V4L2_CID_FOCUS_RELATIVE:
            {
                return -EINVAL;
            }
        case V4L2_CID_FLASH:
            {
                ext_ctrl->value = sensor->info_priv.flash;
                break;
            }
        default :
            break;
    }
    return 0;
}
static int sensor_s_ext_control(struct soc_camera_device *icd, struct v4l2_ext_control *ext_ctrl)
{
    const struct v4l2_queryctrl *qctrl;
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));
    struct sensor *sensor = to_sensor(client);
    int val_offset;

    qctrl = soc_camera_find_qctrl(&sensor_ops, ext_ctrl->id);

    if (!qctrl)
    {
        SENSOR_TR("\n %s ioctrl id = 0x%x  is invalidate \n", SENSOR_NAME_STRING(), ext_ctrl->id);
        return -EINVAL;
    }

	val_offset = 0;
    switch (ext_ctrl->id)
    {
#if CONFIG_SENSOR_Scene
        case V4L2_CID_SCENE:
            {
                if (ext_ctrl->value != sensor->info_priv.scene)
                {
                    if (sensor_set_scene(icd, qctrl,ext_ctrl->value) != 0)
                        return -EINVAL;
                    sensor->info_priv.scene = ext_ctrl->value;
                }
                break;
            }
#endif
#if CONFIG_SENSOR_Effect
        case V4L2_CID_EFFECT:
            {
                if (ext_ctrl->value != sensor->info_priv.effect)
                {
                    if (sensor_set_effect(icd, qctrl,ext_ctrl->value) != 0)
                        return -EINVAL;
                    sensor->info_priv.effect= ext_ctrl->value;
                }
                break;
            }
#endif
#if CONFIG_SENSOR_DigitalZoom
        case V4L2_CID_ZOOM_ABSOLUTE:
            {
                if ((ext_ctrl->value < qctrl->minimum) || (ext_ctrl->value > qctrl->maximum))
                    return -EINVAL;

                if (ext_ctrl->value != sensor->info_priv.digitalzoom)
                {
                    val_offset = ext_ctrl->value -sensor->info_priv.digitalzoom;

                    if (sensor_set_digitalzoom(icd, qctrl,&val_offset) != 0)
                        return -EINVAL;
                    sensor->info_priv.digitalzoom += val_offset;

                    SENSOR_DG("%s digitalzoom is %x\n",SENSOR_NAME_STRING(),  sensor->info_priv.digitalzoom);
                }

                break;
            }
        case V4L2_CID_ZOOM_RELATIVE:
            {
                if (ext_ctrl->value)
                {
                    if (sensor_set_digitalzoom(icd, qctrl,&ext_ctrl->value) != 0)
                        return -EINVAL;
                    sensor->info_priv.digitalzoom += ext_ctrl->value;

                    SENSOR_DG("%s digitalzoom is %x\n", SENSOR_NAME_STRING(), sensor->info_priv.digitalzoom);
                }
                break;
            }
#endif
#if CONFIG_SENSOR_Focus
        case V4L2_CID_FOCUS_ABSOLUTE:
            {
                if ((ext_ctrl->value < qctrl->minimum) || (ext_ctrl->value > qctrl->maximum))
                    return -EINVAL;

				if (sensor_set_focus_absolute(icd, qctrl,ext_ctrl->value) == 0) {
					if (ext_ctrl->value == qctrl->minimum) {
						sensor->info_priv.auto_focus = SENSOR_AF_MODE_INFINITY;
					} else if (ext_ctrl->value == qctrl->maximum) {
						sensor->info_priv.auto_focus = SENSOR_AF_MODE_MACRO;
					} else {
						sensor->info_priv.auto_focus = SENSOR_AF_MODE_FIXED;
					}
				}

                break;
            }
        case V4L2_CID_FOCUS_RELATIVE:
            {
                if ((ext_ctrl->value < qctrl->minimum) || (ext_ctrl->value > qctrl->maximum))
                    return -EINVAL;

                sensor_set_focus_relative(icd, qctrl,ext_ctrl->value);
                break;
            }
		case V4L2_CID_FOCUS_AUTO:
			{
				if (ext_ctrl->value == 1) {
					if (sensor_set_focus_mode(icd, qctrl,SENSOR_AF_MODE_AUTO) != 0)
						return -EINVAL;
					sensor->info_priv.auto_focus = SENSOR_AF_MODE_AUTO;
				} else if (SENSOR_AF_MODE_AUTO == sensor->info_priv.auto_focus){
					if (ext_ctrl->value == 0)
						sensor->info_priv.auto_focus = SENSOR_AF_MODE_CLOSE;
				}
				break;
			}
		case V4L2_CID_FOCUS_CONTINUOUS:
			{
				if (SENSOR_AF_MODE_CONTINUOUS != sensor->info_priv.auto_focus) {
					if (ext_ctrl->value == 1) {
						if (sensor_set_focus_mode(icd, qctrl,SENSOR_AF_MODE_CONTINUOUS) != 0)
							return -EINVAL;
						sensor->info_priv.auto_focus = SENSOR_AF_MODE_CONTINUOUS;
					}
				} else {
					if (ext_ctrl->value == 0)
						sensor->info_priv.auto_focus = SENSOR_AF_MODE_CLOSE;
				}
				break;
			}
#endif
#if CONFIG_SENSOR_Flash
        case V4L2_CID_FLASH:
            {
                if (sensor_set_flash(icd, qctrl,ext_ctrl->value) != 0)
                    return -EINVAL;
                sensor->info_priv.flash = ext_ctrl->value;
                break;
            }
#endif
        default:
            break;
    }

    return 0;
}

static int sensor_g_ext_controls(struct v4l2_subdev *sd, struct v4l2_ext_controls *ext_ctrl)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct soc_camera_device *icd = client->dev.platform_data;
    int i, error_cnt=0, error_idx=-1;
    
    SENSOR_DG("\n%s..%s.. \n",__FUNCTION__,SENSOR_NAME_STRING());


    for (i=0; i<ext_ctrl->count; i++) {
        if (sensor_g_ext_control(icd, &ext_ctrl->controls[i]) != 0) {
            error_cnt++;
            error_idx = i;
        }
    }

    if (error_cnt > 1)
        error_idx = ext_ctrl->count;

    if (error_idx != -1) {
        ext_ctrl->error_idx = error_idx;
        return -EINVAL;
    } else {
        return 0;
    }
}

static int sensor_s_ext_controls(struct v4l2_subdev *sd, struct v4l2_ext_controls *ext_ctrl)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct soc_camera_device *icd = client->dev.platform_data;
    int i, error_cnt=0, error_idx=-1;    

    for (i=0; i<ext_ctrl->count; i++) {
        if (sensor_s_ext_control(icd, &ext_ctrl->controls[i]) != 0) {
            error_cnt++;
            error_idx = i;
        }
    }

    if (error_cnt > 1)
        error_idx = ext_ctrl->count;

    if (error_idx != -1) {
        ext_ctrl->error_idx = error_idx;
        return -EINVAL;
    } else {
        return 0;
    }
}

static int sensor_s_stream(struct v4l2_subdev *sd, int enable)
{
	struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct sensor *sensor = to_sensor(client);

	if (enable == 1) {
		sensor->info_priv.enable = 1;
	} else if (enable == 0) {
		sensor->info_priv.enable = 0;
	}

	return 0;
}

/* Interface active, can use i2c. If it fails, it can indeed mean, that
 * this wasn't our capture interface, so, we wait for the right one */
static int sensor_video_probe(struct soc_camera_device *icd,
			       struct i2c_client *client)
{
    int ret,pid = 0;
    struct sensor *sensor = to_sensor(client);
    #if (SENSOR_RESET_REG != SEQUENCE_END)
    struct reginfo reg_info;
    #endif
    
    /* We must have a parent by now. And it cannot be a wrong one.
     * So this entire test is completely redundant. */
    if (!icd->dev.parent ||
	    to_soc_camera_host(icd->dev.parent)->nr != icd->iface)
		return -ENODEV;

	if (sensor_ioctrl(icd, Sensor_PowerDown, 0) < 0) {
		ret = -ENODEV;
		goto sensor_video_probe_err;
	}
    /* soft reset */
#if (SENSOR_RESET_REG != SEQUENCE_END)
	reg_info.reg = SENSOR_RESET_REG;
	reg_info.val = SENSOR_RESET_VAL;
	reg_info.reg_len = SENSOR_RESET_REG_LEN;
    ret = sensor_write(client, &reg_info);
    if (ret != 0) {
        SENSOR_TR("%s soft reset sensor failed\n",SENSOR_NAME_STRING());
        ret = -ENODEV;
		goto sensor_video_probe_err;
    }
    mdelay(5);  //delay 5 microseconds
#endif

	/* check if it is an sensor sensor */
#if (SENSOR_ID_REG != SEQUENCE_END)
    ret = sensor_read(client, SENSOR_ID_REG, &pid);
    if (ret != 0) {
        SENSOR_TR("read chip id failed\n");
        ret = -ENODEV;
        goto sensor_video_probe_err;
    }

    SENSOR_DG("\n %s  pid = 0x%x \n", SENSOR_NAME_STRING(), pid);
#else
	pid = SENSOR_ID;
#endif
    if (pid == SENSOR_ID) {
        sensor->model = SENSOR_V4L2_IDENT;
    } else {
        SENSOR_TR("error: %s mismatched   pid = 0x%x\n", SENSOR_NAME_STRING(), pid);
        ret = -ENODEV;
        goto sensor_video_probe_err;
    }


    return 0;

sensor_video_probe_err:

    return ret;
}
static long sensor_ioctl(struct v4l2_subdev *sd, unsigned int cmd, void *arg)
{
	struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct soc_camera_device *icd = client->dev.platform_data;
    struct sensor *sensor = to_sensor(client);
    int ret = 0;
    #if CONFIG_SENSOR_Flash	
    int i;
    #endif
    
	SENSOR_DG("\n%s..%s..cmd:%x \n",SENSOR_NAME_STRING(),__FUNCTION__,cmd);
	switch (cmd)
	{
		case RK29_CAM_SUBDEV_DEACTIVATE:
		{
			sensor_deactivate(client);
			break;
		}
		case RK29_CAM_SUBDEV_IOREQUEST:
		{
			sensor->sensor_io_request = (struct rk29camera_platform_data*)arg;           
            if (sensor->sensor_io_request != NULL) { 
                sensor->sensor_gpio_res = NULL;
                for (i=0; i<RK29_CAM_SUPPORT_NUMS;i++) {
                    if (sensor->sensor_io_request->gpio_res[i].dev_name && 
                        (strcmp(sensor->sensor_io_request->gpio_res[i].dev_name, dev_name(icd->pdev)) == 0)) {
                        sensor->sensor_gpio_res = (struct rk29camera_gpio_res*)&sensor->sensor_io_request->gpio_res[i];
                    }
                }
                if (sensor->sensor_gpio_res == NULL) {
                    SENSOR_TR("%s %s obtain gpio resource failed when RK29_CAM_SUBDEV_IOREQUEST \n",SENSOR_NAME_STRING(),__FUNCTION__);
                    ret = -EINVAL;
                    goto sensor_ioctl_end;
                }
            } else {
                SENSOR_TR("%s %s RK29_CAM_SUBDEV_IOREQUEST fail\n",SENSOR_NAME_STRING(),__FUNCTION__);
                ret = -EINVAL;
                goto sensor_ioctl_end;
            }
            /* ddl@rock-chips.com : if gpio_flash havn't been set in board-xxx.c, sensor driver must notify is not support flash control 
               for this project */
            #if CONFIG_SENSOR_Flash	
        	if (sensor->sensor_gpio_res) {
                if (sensor->sensor_gpio_res->gpio_flash == INVALID_GPIO) {
                    for (i = 0; i < icd->ops->num_controls; i++) {
                		if (V4L2_CID_FLASH == icd->ops->controls[i].id) {
                			//memset((char*)&icd->ops->controls[i],0x00,sizeof(struct v4l2_queryctrl));  
                              sensor_controls[i].id=0xffff;         			
                		}
                    }
                    sensor->info_priv.flash = 0xff;
                }else{ //two cameras are the same,need to deal diffrently ,zyc
                    for (i = 0; i < icd->ops->num_controls; i++) {
                           if(0xffff == icd->ops->controls[i].id){
                              sensor_controls[i].id=V4L2_CID_FLASH;
                           }               
                    }
                }
        	}
            #endif
			break;
		}
		default:
		{
			SENSOR_TR("%s %s cmd(0x%x) is unknown !\n",SENSOR_NAME_STRING(),__FUNCTION__,cmd);
			break;
		}
	}
sensor_ioctl_end:
	return ret;

}
static int sensor_enum_fmt(struct v4l2_subdev *sd, unsigned int index,
			    enum v4l2_mbus_pixelcode *code)
{
	if (index >= ARRAY_SIZE(sensor_colour_fmts))
		return -EINVAL;

	*code = sensor_colour_fmts[index].code;
	return 0;
}
static struct v4l2_subdev_core_ops sensor_subdev_core_ops = {
	.init		= sensor_init,
	.g_ctrl		= sensor_g_control,
	.s_ctrl		= sensor_s_control,
	.g_ext_ctrls          = sensor_g_ext_controls,
	.s_ext_ctrls          = sensor_s_ext_controls,
	.g_chip_ident	= sensor_g_chip_ident,
	.ioctl = sensor_ioctl,
};
static struct v4l2_subdev_video_ops sensor_subdev_video_ops = {
	.s_mbus_fmt	= sensor_s_fmt,
	.g_mbus_fmt	= sensor_g_fmt,
	.try_mbus_fmt	= sensor_try_fmt,
	.enum_mbus_fmt	= sensor_enum_fmt,
	.s_stream   = sensor_s_stream,
};

static struct v4l2_subdev_ops sensor_subdev_ops = {
	.core	= &sensor_subdev_core_ops,
	.video = &sensor_subdev_video_ops,
};

static int sensor_probe(struct i2c_client *client,
			 const struct i2c_device_id *did)
{
    struct sensor *sensor;
    struct soc_camera_device *icd = client->dev.platform_data;
    struct i2c_adapter *adapter = to_i2c_adapter(client->dev.parent);
    struct soc_camera_link *icl;
    int ret;

    SENSOR_DG("\n%s..%s..%d..\n",__FUNCTION__,__FILE__,__LINE__);
    if (!icd) {
        dev_err(&client->dev, "%s: missing soc-camera data!\n",SENSOR_NAME_STRING());
        return -EINVAL;
    }

    icl = to_soc_camera_link(icd);
    if (!icl) {
        dev_err(&client->dev, "%s driver needs platform data\n", SENSOR_NAME_STRING());
        return -EINVAL;
    }

    if (!i2c_check_functionality(adapter, I2C_FUNC_I2C)) {
        dev_warn(&adapter->dev,
        	 "I2C-Adapter doesn't support I2C_FUNC_I2C\n");
        return -EIO;
    }

    sensor = kzalloc(sizeof(struct sensor), GFP_KERNEL);
    if (!sensor)
        return -ENOMEM;

    v4l2_i2c_subdev_init(&sensor->subdev, client, &sensor_subdev_ops);

    /* Second stage probe - when a capture adapter is there */
    icd->ops		= &sensor_ops;
    sensor->info_priv.fmt = sensor_colour_fmts[0];
	#if CONFIG_SENSOR_I2C_NOSCHED
	atomic_set(&sensor->tasklock_cnt,0);
	#endif

    ret = sensor_video_probe(icd, client);
    if (ret < 0) {
        icd->ops = NULL;
        i2c_set_clientdata(client, NULL);
        kfree(sensor);
		sensor = NULL;
    }
	hrtimer_init(&(flash_off_timer.timer), CLOCK_MONOTONIC, HRTIMER_MODE_REL);
    SENSOR_DG("\n%s..%s..%d  ret = %x \n",__FUNCTION__,__FILE__,__LINE__,ret);
    return ret;
}

static int sensor_remove(struct i2c_client *client)
{
    struct sensor *sensor = to_sensor(client);
    struct soc_camera_device *icd = client->dev.platform_data;

	#if CONFIG_SENSOR_Focus
	if (sensor->sensor_wq) {
		destroy_workqueue(sensor->sensor_wq);
		sensor->sensor_wq = NULL;
	}
	#endif

    icd->ops = NULL;
    i2c_set_clientdata(client, NULL);
    client->driver = NULL;
    kfree(sensor);
	sensor = NULL;
    return 0;
}

static const struct i2c_device_id sensor_id[] = {
	{SENSOR_NAME_STRING(), 0 },
	{ }
};
MODULE_DEVICE_TABLE(i2c, sensor_id);

static struct i2c_driver sensor_i2c_driver = {
	.driver = {
		.name = SENSOR_NAME_STRING(),
	},
	.probe		= sensor_probe,
	.remove		= sensor_remove,
	.id_table	= sensor_id,
};

static int __init sensor_mod_init(void)
{
    SENSOR_DG("\n%s..%s.. \n",__FUNCTION__,SENSOR_NAME_STRING());
    return i2c_add_driver(&sensor_i2c_driver);
}

static void __exit sensor_mod_exit(void)
{
    SENSOR_DG("\n%s..%s.. \n",__FUNCTION__,SENSOR_NAME_STRING());
    i2c_del_driver(&sensor_i2c_driver);
}

device_initcall_sync(sensor_mod_init);
module_exit(sensor_mod_exit);

MODULE_DESCRIPTION(SENSOR_NAME_STRING(Camera sensor driver));
MODULE_AUTHOR("ddl <kernel@rock-chips>");
MODULE_LICENSE("GPL");


