/*
 * drivers/media/video/mt9p111.c
 *
 * Copyright (C) ROCKCHIP, Inc.
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include "generic_sensor.h"
/*
*      Driver Version Note
*v0.0.1: this driver is compatible with generic_sensor
*v0.1.1:
*        add sensor_focus_af_const_pause_usr_cb;
*/
static int version = KERNEL_VERSION(0,1,1);
module_param(version, int, S_IRUGO);

static int debug;
module_param(debug, int, S_IRUGO|S_IWUSR);

#define dprintk(level, fmt, arg...) do {			\
	if (debug >= level) 					\
	printk(KERN_WARNING fmt , ## arg); } while (0)

/* Sensor Driver Configuration Begin */
#define SENSOR_NAME RK29_CAM_SENSOR_MT9P111
#define SENSOR_V4L2_IDENT V4L2_IDENT_MT9P111
#define SENSOR_ID 0x00
#define SENSOR_BUS_PARAM                     (V4L2_MBUS_MASTER |\
																 V4L2_MBUS_PCLK_SAMPLE_RISING|V4L2_MBUS_HSYNC_ACTIVE_HIGH| V4L2_MBUS_VSYNC_ACTIVE_HIGH|\
																 V4L2_MBUS_DATA_ACTIVE_HIGH  |SOCAM_MCLK_24MHZ)
#define SENSOR_PREVIEW_W                     576
#define SENSOR_PREVIEW_H                     432
#define SENSOR_PREVIEW_FPS                   15000     // 15fps 
#define SENSOR_FULLRES_L_FPS                 7500      // 7.5fps
#define SENSOR_FULLRES_H_FPS                 7500      // 7.5fps
#define SENSOR_720P_FPS                      30000
#define SENSOR_1080P_FPS                     0

#define SENSOR_REGISTER_LEN                  0         // sensor register address bytes
#define SENSOR_VALUE_LEN                     0         // sensor register value bytes
                                    
static unsigned int SensorConfiguration = CFG_Focus|CFG_FocusZone;
static unsigned int SensorChipID[] = {SENSOR_ID};
/* Sensor Driver Configuration End */


#define SENSOR_NAME_STRING(a) STR(CONS(SENSOR_NAME, a))
#define SENSOR_NAME_VARFUN(a) CONS(SENSOR_NAME, a)

#define SensorRegVal(a,b) CONS4(SensorReg,SENSOR_REGISTER_LEN,Val,SENSOR_VALUE_LEN)(a,b)
#define sensor_write(client,reg,v) CONS4(sensor_write_reg,SENSOR_REGISTER_LEN,val,SENSOR_VALUE_LEN)(client,(reg),(v))
#define sensor_read(client,reg,v) CONS4(sensor_read_reg,SENSOR_REGISTER_LEN,val,SENSOR_VALUE_LEN)(client,(reg),(v))
#define sensor_write_array generic_sensor_write_array

struct sensor_parameter
{

};

struct specific_sensor{
	struct generic_sensor common_sensor;
	//define user data below
	struct sensor_parameter parameter;

};

/*
*  The follow setting need been filled.
*  
*  Must Filled:
*  sensor_init_data :               Sensor initial setting;
*  sensor_fullres_lowfps_data :     Sensor full resolution setting with best auality, recommand for video;
*  sensor_preview_data :            Sensor preview resolution setting, recommand it is vga or svga;
*  sensor_softreset_data :          Sensor software reset register;
*  sensor_check_id_data :           Sensir chip id register;
*
*  Optional filled:
*  sensor_fullres_highfps_data:     Sensor full resolution setting with high framerate, recommand for video;
*  sensor_720p:                     Sensor 720p setting, it is for video;
*  sensor_1080p:                    Sensor 1080p setting, it is for video;
*
*  :::::WARNING:::::
*  The SensorEnd which is the setting end flag must be filled int the last of each setting;
*/

/* Sensor initial setting */
static struct rk_sensor_reg sensor_init_data[] = {     
{ 0x0010, 0x0340, 0xffff,0xffff },           


{ 0x0010, 0x0340, 0xffff,0xffff }, 	// PLL_DIVIDERS
{ 0x0012, 0x0080, 0xffff,0xffff }, 	// PLL_P_DIVIDERS
{ 0x0014, 0x2025, 0xffff,0xffff }, 	// PLL_CONTROL
{ 0x001E, 0x0565, 0xffff,0xffff }, 	// PAD_SLEW_PAD_CONFIG
{ 0x0022, 0x0030, 0xffff,0xffff }, 	// VDD_DIS_COUNTER
{ 0x002A, 0x7FFF, 0xffff,0xffff }, 	// PLL_P4_P5_P6_DIVIDERS
{ 0x002C, 0x0000, 0xffff,0xffff }, 	// PLL_P7_DIVIDER
{ 0x002E, 0x0000, 0xffff,0xffff }, 	// SENSOR_CLOCK_DIVIDER
{ 0x0018, 0x400c, 0xffff,0xffff }, 	// STANDBY_CONTROL_AND_STATUS
//delay = 100
SensorWaitMs(300),
{ 0x098E, 0x483A, 0xffff,0xffff }, 	// LOGICAL_ADDRESS_ACCESS
{ 0xC83A, 0x000C, 0xffff,0xffff }, 	// CAM_CORE_A_Y_ADDR_START
{ 0xC83C, 0x0018, 0xffff,0xffff }, 	// CAM_CORE_A_X_ADDR_START
{ 0xC83E, 0x07B1, 0xffff,0xffff }, 	// CAM_CORE_A_Y_ADDR_END
{ 0xC840, 0x0A45, 0xffff,0xffff }, 	// CAM_CORE_A_X_ADDR_END
{ 0xC842, 0x0001, 0xffff,0xffff }, 	// CAM_CORE_A_ROW_SPEED
{ 0xC844, 0x0103, 0xffff,0xffff }, 	// CAM_CORE_A_SKIP_X_CORE
{ 0xC846, 0x0103, 0xffff,0xffff }, 	// CAM_CORE_A_SKIP_Y_CORE
{ 0xC848, 0x0103, 0xffff,0xffff }, 	// CAM_CORE_A_SKIP_X_PIPE
{ 0xC84A, 0x0103, 0xffff,0xffff }, 	// CAM_CORE_A_SKIP_Y_PIPE
{ 0xC84C, 0x00F6, 0xffff,0xffff }, 	// CAM_CORE_A_POWER_MODE
{ 0xC84E, 0x0001, 0xffff,0xffff }, 	// CAM_CORE_A_BIN_MODE
{ 0xC850, 0x00, 0xffff,0xff}, 	// CAM_CORE_A_ORIENTATION
{ 0xC851, 0x00, 0xffff,0xff}, 	// CAM_CORE_A_PIXEL_ORDER
{ 0xC852, 0x019C, 0xffff,0xffff }, 	// CAM_CORE_A_FINE_CORRECTION
{ 0xC854, 0x0732, 0xffff,0xffff }, 	// CAM_CORE_A_FINE_ITMIN
{ 0xC858, 0x0000, 0xffff,0xffff }, 	// CAM_CORE_A_COARSE_ITMIN
{ 0xC85A, 0x0001, 0xffff,0xffff }, 	// CAM_CORE_A_COARSE_ITMAX_MARGIN
{ 0xC85C, 0x0423, 0xffff,0xffff }, 	// CAM_CORE_A_MIN_FRAME_LENGTH_LINES
{ 0xC85E, 0xFFFF, 0xffff,0xffff }, 	// CAM_CORE_A_MAX_FRAME_LENGTH_LINES
{ 0xC860, 0x0423, 0xffff,0xffff }, 	// CAM_CORE_A_BASE_FRAME_LENGTH_LINES
{ 0xC862, 0x1194, 0xffff,0xffff }, 	// CAM_CORE_A_MIN_LINE_LENGTH_PCLK
{ 0xC864, 0xFFFE, 0xffff,0xffff }, 	// CAM_CORE_A_MAX_LINE_LENGTH_PCLK
{ 0xC866, 0x7F7F, 0xffff,0xffff }, 	// CAM_CORE_A_P4_5_6_DIVIDER
{ 0xC868, 0x0423, 0xffff,0xffff }, 	// CAM_CORE_A_FRAME_LENGTH_LINES
{ 0xC86A, 0x1194, 0xffff,0xffff }, 	// CAM_CORE_A_LINE_LENGTH_PCK
{ 0xC86C, 0x0518, 0xffff,0xffff }, 	// CAM_CORE_A_OUTPUT_SIZE_WIDTH
{ 0xC86E, 0x03D4, 0xffff,0xffff }, 	// CAM_CORE_A_OUTPUT_SIZE_HEIGHT
{ 0xC870, 0x0014, 0xffff,0xffff }, 	// CAM_CORE_A_RX_FIFO_TRIGGER_MARK
{ 0xC858, 0x0003, 0xffff,0xffff }, 	// CAM_CORE_A_COARSE_ITMIN
{ 0xC8B8, 0x0004, 0xffff,0xffff }, 	// CAM_OUTPUT_0_JPEG_CONTROL
{ 0xC8AE, 0x0001, 0xffff,0xffff }, 	// CAM_OUTPUT_0_OUTPUT_FORMAT
{ 0xC8AA, 0x0280, 0xffff,0xffff }, 	// CAM_OUTPUT_0_IMAGE_WIDTH
{ 0xC8AC, 0x01E0, 0xffff,0xffff }, 	// CAM_OUTPUT_0_IMAGE_HEIGHT
{ 0xC872, 0x0010, 0xffff,0xffff }, 	// CAM_CORE_B_Y_ADDR_START
{ 0xC874, 0x001C, 0xffff,0xffff }, 	// CAM_CORE_B_X_ADDR_START
{ 0xC876, 0x07AF, 0xffff,0xffff }, 	// CAM_CORE_B_Y_ADDR_END
{ 0xC878, 0x0A43, 0xffff,0xffff }, 	// CAM_CORE_B_X_ADDR_END
{ 0xC87A, 0x0001, 0xffff,0xffff }, 	// CAM_CORE_B_ROW_SPEED
{ 0xC87C, 0x0101, 0xffff,0xffff }, 	// CAM_CORE_B_SKIP_X_CORE
{ 0xC87E, 0x0101, 0xffff,0xffff }, 	// CAM_CORE_B_SKIP_Y_CORE
{ 0xC880, 0x0101, 0xffff,0xffff }, 	// CAM_CORE_B_SKIP_X_PIPE
{ 0xC882, 0x0101, 0xffff,0xffff }, 	// CAM_CORE_B_SKIP_Y_PIPE
{ 0xC884, 0x00F2, 0xffff,0xffff }, 	// CAM_CORE_B_POWER_MODE
{ 0xC886, 0x0000, 0xffff,0xffff }, 	// CAM_CORE_B_BIN_MODE
{ 0xC888, 0x00, 0xffff,0xff}, 	// CAM_CORE_B_ORIENTATION
{ 0xC889, 0x00, 0xffff,0xff}, 	// CAM_CORE_B_PIXEL_ORDER
{ 0xC88A, 0x009C, 0xffff,0xffff }, 	// CAM_CORE_B_FINE_CORRECTION
{ 0xC88C, 0x034A, 0xffff,0xffff }, 	// CAM_CORE_B_FINE_ITMIN
{ 0xC890, 0x0000, 0xffff,0xffff }, 	// CAM_CORE_B_COARSE_ITMIN
{ 0xC892, 0x0001, 0xffff,0xffff }, 	// CAM_CORE_B_COARSE_ITMAX_MARGIN
{ 0xC894, 0x07EF, 0xffff,0xffff }, 	// CAM_CORE_B_MIN_FRAME_LENGTH_LINES
{ 0xC896, 0xFFFF, 0xffff,0xffff }, 	// CAM_CORE_B_MAX_FRAME_LENGTH_LINES
{ 0xC898, 0x082F, 0xffff,0xffff }, 	// CAM_CORE_B_BASE_FRAME_LENGTH_LINES
{ 0xC89A, 0x1964, 0xffff,0xffff }, 	// CAM_CORE_B_MIN_LINE_LENGTH_PCLK
{ 0xC89C, 0xFFFE, 0xffff,0xffff }, 	// CAM_CORE_B_MAX_LINE_LENGTH_PCLK
{ 0xC89E, 0x7F7F, 0xffff,0xffff }, 	// CAM_CORE_B_P4_5_6_DIVIDER
{ 0xC8A0, 0x07EF, 0xffff,0xffff }, 	// CAM_CORE_B_FRAME_LENGTH_LINES
{ 0xC8A2, 0x1964, 0xffff,0xffff }, 	// CAM_CORE_B_LINE_LENGTH_PCK
{ 0xC8A4, 0x0A28, 0xffff,0xffff }, 	// CAM_CORE_B_OUTPUT_SIZE_WIDTH
{ 0xC8A6, 0x07A0, 0xffff,0xffff }, 	// CAM_CORE_B_OUTPUT_SIZE_HEIGHT
{ 0xC8A8, 0x0124, 0xffff,0xffff }, 	// CAM_CORE_B_RX_FIFO_TRIGGER_MARK
{ 0xC890, 0x0003, 0xffff,0xffff }, 	// CAM_CORE_B_COARSE_ITMIN
{ 0xC8C0, 0x0A20, 0xffff,0xffff }, 	// CAM_OUTPUT_1_IMAGE_WIDTH
{ 0xC8C2, 0x0798, 0xffff,0xffff }, 	// CAM_OUTPUT_1_IMAGE_HEIGHT
{ 0xC89A, 0x1964, 0xffff,0xffff }, 	// CAM_CORE_B_MIN_LINE_LENGTH_PCLK
{ 0xC8A2, 0x1964, 0xffff,0xffff }, 	// CAM_CORE_B_LINE_LENGTH_PCK
{ 0xC8C4, 0x0001, 0xffff,0xffff }, 	// CAM_OUTPUT_1_OUTPUT_FORMAT
{ 0xC8C6, 0x0000, 0xffff,0xffff }, 	// CAM_OUTPUT_1_OUTPUT_FORMAT_ORDER
{ 0xC8CE, 0x0014, 0xffff,0xffff }, 	// CAM_OUTPUT_1_JPEG_CONTROL
{ 0xD822, 0x4610, 0xffff,0xffff }, 	// JPEG_JPSS_CTRL_VAR
{ 0x3330, 0x0000, 0xffff,0xffff }, 	// OUTPUT_FORMAT_TEST
{ 0x098E, 0xA00E, 0xffff,0xffff }, 	// LOGICAL_ADDRESS_ACCESS
{ 0xA00E, 0x32, 0xffff,0xff}, 	// FD_MAX_NUM_AUTOCOR_FUNC_VALUES_TO_CHECK
{ 0xA010, 0x00CC, 0xffff,0xffff }, 	// FD_MIN_EXPECTED50HZ_FLICKER_PERIOD
{ 0xA012, 0x00E0, 0xffff,0xffff }, 	// FD_MAX_EXPECTED50HZ_FLICKER_PERIOD
{ 0xA014, 0x00A8, 0xffff,0xffff }, 	// FD_MIN_EXPECTED60HZ_FLICKER_PERIOD
{ 0xA016, 0x00BC, 0xffff,0xffff }, 	// FD_MAX_EXPECTED60HZ_FLICKER_PERIOD
{ 0xA018, 0x00D6, 0xffff,0xffff }, 	// FD_EXPECTED50HZ_FLICKER_PERIOD_IN_CONTEXT_A
{ 0xA01A, 0x0075, 0xffff,0xffff }, 	// FD_EXPECTED50HZ_FLICKER_PERIOD_IN_CONTEXT_B
{ 0xA01C, 0x00B2, 0xffff,0xffff }, 	// FD_EXPECTED60HZ_FLICKER_PERIOD_IN_CONTEXT_A
{ 0xA01E, 0x0062, 0xffff,0xffff }, 	// FD_EXPECTED60HZ_FLICKER_PERIOD_IN_CONTEXT_B
{ 0xA000, 0x10, 0xffff,0xff}, 	// FD_STATUS
{ 0x8417, 0x02, 0xffff,0xff}, 	// SEQ_STATE_CFG_1_FD
//delay = 100
SensorWaitMs(100),

//[Step2-Fixups]                                  
// Default variable access mode is always logical.


{ 0x098E, 0x0000, 0xffff,0xffff}, 	// LOGICAL_ADDRESS_ACCESS
{ 0x301A, 0x0030, 0xffff,0xffff}, 	// RESET_REGISTER
{ 0x316C, 0xB430, 0xffff,0xffff}, 	// DAC_TXLO
{ 0x31E0, 0x0003, 0xffff,0xffff}, 	// PIX_DEF_ID
{ 0x3E2E, 0xF319, 0xffff,0xffff}, 	// SAMP_SPARE
{ 0x3EE6, 0xA7C1, 0xffff,0xffff}, 	// DAC_LD_26_27
{ 0x301E, 0x00A8, 0xffff,0xffff}, 	// DATA_PEDESTAL
{ 0xDC33, 0x2A, 0xffff,0xff}, 	// SYS_FIRST_BLACK_LEVEL
{ 0x3812, 0x212C, 0xffff,0xffff}, 	// OTPM_CFG
{ 0x0982, 0x0000, 0xffff,0xffff}, 	// ACCESS_CTL_STAT
{ 0x098A, 0x0000, 0xffff,0xffff}, 	// PHYSICAL_ADDRESS_ACCESS
{ 0x886C, 0xC0F1, 0xffff,0xffff},
{ 0x886E, 0xC5E1, 0xffff,0xffff},
{ 0x8870, 0x246A, 0xffff,0xffff},
{ 0x8872, 0x1280, 0xffff,0xffff},
{ 0x8874, 0xC4E1, 0xffff,0xffff},
{ 0x8876, 0xD20F, 0xffff,0xffff},
{ 0x8878, 0x2069, 0xffff,0xffff},
{ 0x887A, 0x0000, 0xffff,0xffff},
{ 0x887C, 0x6A62, 0xffff,0xffff},
{ 0x887E, 0x1303, 0xffff,0xffff},
{ 0x8880, 0x0084, 0xffff,0xffff},
{ 0x8882, 0x1734, 0xffff,0xffff},
{ 0x8884, 0x7005, 0xffff,0xffff},
{ 0x8886, 0xD801, 0xffff,0xffff},
{ 0x8888, 0x8A41, 0xffff,0xffff},
{ 0x888A, 0xD900, 0xffff,0xffff},
{ 0x888C, 0x0D5A, 0xffff,0xffff},
{ 0x888E, 0x0664, 0xffff,0xffff},
{ 0x8890, 0x8B61, 0xffff,0xffff},
{ 0x8892, 0xE80B, 0xffff,0xffff},
{ 0x8894, 0x000D, 0xffff,0xffff},
{ 0x8896, 0x0020, 0xffff,0xffff},
{ 0x8898, 0xD508, 0xffff,0xffff},
{ 0x889A, 0x1504, 0xffff,0xffff},
{ 0x889C, 0x1400, 0xffff,0xffff},
{ 0x889E, 0x7840, 0xffff,0xffff},
{ 0x88A0, 0xD007, 0xffff,0xffff},
{ 0x88A2, 0x0DFB, 0xffff,0xffff},
{ 0x88A4, 0x9004, 0xffff,0xffff},
{ 0x88A6, 0xC4C1, 0xffff,0xffff},
{ 0x88A8, 0x2029, 0xffff,0xffff},
{ 0x88AA, 0x0300, 0xffff,0xffff},
{ 0x88AC, 0x0219, 0xffff,0xffff},
{ 0x88AE, 0x06C4, 0xffff,0xffff},
{ 0x88B0, 0xFF80, 0xffff,0xffff},
{ 0x88B2, 0x08D4, 0xffff,0xffff},
{ 0x88B4, 0xFF80, 0xffff,0xffff},
{ 0x88B6, 0x086C, 0xffff,0xffff},
{ 0x88B8, 0xFF80, 0xffff,0xffff},
{ 0x88BA, 0x08C0, 0xffff,0xffff},
{ 0x88BC, 0xFF80, 0xffff,0xffff},
{ 0x88BE, 0x08D4, 0xffff,0xffff},
{ 0x88C0, 0xFF80, 0xffff,0xffff},
{ 0x88C2, 0x08DC, 0xffff,0xffff},
{ 0x88C4, 0xFF80, 0xffff,0xffff},
{ 0x88C6, 0x0F58, 0xffff,0xffff},
{ 0x88C8, 0xFF80, 0xffff,0xffff},
{ 0x88CA, 0x0920, 0xffff,0xffff},
{ 0x88CC, 0xFF80, 0xffff,0xffff},
{ 0x88CE, 0x1010, 0xffff,0xffff},
{ 0x88D0, 0xFF80, 0xffff,0xffff},
{ 0x88D2, 0x1030, 0xffff,0xffff},
{ 0x88D4, 0x0010, 0xffff,0xffff},
{ 0x88D6, 0x0008, 0xffff,0xffff},
{ 0x88D8, 0x0000, 0xffff,0xffff},
{ 0x88DA, 0x0000, 0xffff,0xffff},
{ 0x88DC, 0xD102, 0xffff,0xffff},
{ 0x88DE, 0xD003, 0xffff,0xffff},
{ 0x88E0, 0x7FE0, 0xffff,0xffff},
{ 0x88E2, 0xB035, 0xffff,0xffff},
{ 0x88E4, 0xFF80, 0xffff,0xffff},
{ 0x88E6, 0x10C8, 0xffff,0xffff},
{ 0x88E8, 0xFF80, 0xffff,0xffff},
{ 0x88EA, 0x0118, 0xffff,0xffff},
{ 0x88EC, 0xC0F1, 0xffff,0xffff},
{ 0x88EE, 0xC5E1, 0xffff,0xffff},
{ 0x88F0, 0xD5EC, 0xffff,0xffff},
{ 0x88F2, 0x8D04, 0xffff,0xffff},
{ 0x88F4, 0x8D25, 0xffff,0xffff},
{ 0x88F6, 0xB808, 0xffff,0xffff},
{ 0x88F8, 0x7825, 0xffff,0xffff},
{ 0x88FA, 0x0821, 0xffff,0xffff},
{ 0x88FC, 0x01DE, 0xffff,0xffff},
{ 0x88FE, 0xD0EA, 0xffff,0xffff},
{ 0x8900, 0x8000, 0xffff,0xffff},
{ 0x8902, 0x8008, 0xffff,0xffff},
{ 0x8904, 0x7840, 0xffff,0xffff},
{ 0x8906, 0x8D04, 0xffff,0xffff},
{ 0x8908, 0x8D25, 0xffff,0xffff},
{ 0x890A, 0xB808, 0xffff,0xffff},
{ 0x890C, 0x7825, 0xffff,0xffff},
{ 0x890E, 0xB8A7, 0xffff,0xffff},
{ 0x8910, 0x2841, 0xffff,0xffff},
{ 0x8912, 0x0201, 0xffff,0xffff},
{ 0x8914, 0xAD24, 0xffff,0xffff},
{ 0x8916, 0xAD05, 0xffff,0xffff},
{ 0x8918, 0x09A6, 0xffff,0xffff},
{ 0x891A, 0x0104, 0xffff,0xffff},
{ 0x891C, 0x01A9, 0xffff,0xffff},
{ 0x891E, 0x06C4, 0xffff,0xffff},
{ 0x8920, 0xC0F1, 0xffff,0xffff},
{ 0x8922, 0x0932, 0xffff,0xffff},
{ 0x8924, 0x06E4, 0xffff,0xffff},
{ 0x8926, 0xDA38, 0xffff,0xffff},
{ 0x8928, 0xD1E0, 0xffff,0xffff},
{ 0x892A, 0xD5E1, 0xffff,0xffff},
{ 0x892C, 0x76A9, 0xffff,0xffff},
{ 0x892E, 0x0EC6, 0xffff,0xffff},
{ 0x8930, 0x06A4, 0xffff,0xffff},
{ 0x8932, 0x70C9, 0xffff,0xffff},
{ 0x8934, 0xD0DF, 0xffff,0xffff},
{ 0x8936, 0xA501, 0xffff,0xffff},
{ 0x8938, 0xD0DF, 0xffff,0xffff},
{ 0x893A, 0xA503, 0xffff,0xffff},
{ 0x893C, 0xD0DF, 0xffff,0xffff},
{ 0x893E, 0xA506, 0xffff,0xffff},
{ 0x8940, 0xD0DF, 0xffff,0xffff},
{ 0x8942, 0xA509, 0xffff,0xffff},
{ 0x8944, 0xD0D8, 0xffff,0xffff},
{ 0x8946, 0xA0C0, 0xffff,0xffff},
{ 0x8948, 0xD0DE, 0xffff,0xffff},
{ 0x894A, 0x802E, 0xffff,0xffff},
{ 0x894C, 0x9117, 0xffff,0xffff},
{ 0x894E, 0x0171, 0xffff,0xffff},
{ 0x8950, 0x06E4, 0xffff,0xffff},
{ 0x8952, 0xB10E, 0xffff,0xffff},
{ 0x8954, 0xC0F1, 0xffff,0xffff},
{ 0x8956, 0xD0D3, 0xffff,0xffff},
{ 0x8958, 0x8806, 0xffff,0xffff},
{ 0x895A, 0x080F, 0xffff,0xffff},
{ 0x895C, 0x0051, 0xffff,0xffff},
{ 0x895E, 0xD0D2, 0xffff,0xffff},
{ 0x8960, 0x8000, 0xffff,0xffff},
{ 0x8962, 0x8008, 0xffff,0xffff},
{ 0x8964, 0x7840, 0xffff,0xffff},
{ 0x8966, 0x0A1E, 0xffff,0xffff},
{ 0x8968, 0x0104, 0xffff,0xffff},
{ 0x896A, 0xC0D1, 0xffff,0xffff},
{ 0x896C, 0x7EE0, 0xffff,0xffff},
{ 0x896E, 0x78E0, 0xffff,0xffff},
{ 0x8970, 0xC0F1, 0xffff,0xffff},
{ 0x8972, 0x08D6, 0xffff,0xffff},
{ 0x8974, 0x06C4, 0xffff,0xffff},
{ 0x8976, 0xD7CC, 0xffff,0xffff},
{ 0x8978, 0x8700, 0xffff,0xffff},
{ 0x897A, 0x8009, 0xffff,0xffff},
{ 0x897C, 0x7840, 0xffff,0xffff},
{ 0x897E, 0xE080, 0xffff,0xffff},
{ 0x8980, 0x0276, 0xffff,0xffff},
{ 0x8982, 0x0002, 0xffff,0xffff},
{ 0x8984, 0xD5C7, 0xffff,0xffff},
{ 0x8986, 0xD6D0, 0xffff,0xffff},
{ 0x8988, 0x1530, 0xffff,0xffff},
{ 0x898A, 0x1081, 0xffff,0xffff},
{ 0x898C, 0x1531, 0xffff,0xffff},
{ 0x898E, 0x1080, 0xffff,0xffff},
{ 0x8990, 0xB908, 0xffff,0xffff},
{ 0x8992, 0x7905, 0xffff,0xffff},
{ 0x8994, 0x2941, 0xffff,0xffff},
{ 0x8996, 0x0200, 0xffff,0xffff},
{ 0x8998, 0x1D32, 0xffff,0xffff},
{ 0x899A, 0x1002, 0xffff,0xffff},
{ 0x899C, 0x1D33, 0xffff,0xffff},
{ 0x899E, 0x1042, 0xffff,0xffff},
{ 0x89A0, 0x962D, 0xffff,0xffff},
{ 0x89A2, 0x2540, 0xffff,0xffff},
{ 0x89A4, 0x15D1, 0xffff,0xffff},
{ 0x89A6, 0x2941, 0xffff,0xffff},
{ 0x89A8, 0x0200, 0xffff,0xffff},
{ 0x89AA, 0x1D30, 0xffff,0xffff},
{ 0x89AC, 0x1002, 0xffff,0xffff},
{ 0x89AE, 0x8D06, 0xffff,0xffff},
{ 0x89B0, 0x2540, 0xffff,0xffff},
{ 0x89B2, 0x1610, 0xffff,0xffff},
{ 0x89B4, 0x1D31, 0xffff,0xffff},
{ 0x89B6, 0x1042, 0xffff,0xffff},
{ 0x89B8, 0x081B, 0xffff,0xffff},
{ 0x89BA, 0x0051, 0xffff,0xffff},
{ 0x89BC, 0x8700, 0xffff,0xffff},
{ 0x89BE, 0x8008, 0xffff,0xffff},
{ 0x89C0, 0x7840, 0xffff,0xffff},
{ 0x89C2, 0xD900, 0xffff,0xffff},
{ 0x89C4, 0x2941, 0xffff,0xffff},
{ 0x89C6, 0x0200, 0xffff,0xffff},
{ 0x89C8, 0xAD00, 0xffff,0xffff},
{ 0x89CA, 0xAD21, 0xffff,0xffff},
{ 0x89CC, 0xD801, 0xffff,0xffff},
{ 0x89CE, 0x1D4D, 0xffff,0xffff},
{ 0x89D0, 0x1002, 0xffff,0xffff},
{ 0x89D2, 0x154D, 0xffff,0xffff},
{ 0x89D4, 0x1080, 0xffff,0xffff},
{ 0x89D6, 0xB861, 0xffff,0xffff},
{ 0x89D8, 0xE085, 0xffff,0xffff},
{ 0x89DA, 0x0218, 0xffff,0xffff},
{ 0x89DC, 0x000D, 0xffff,0xffff},
{ 0x89DE, 0x2740, 0xffff,0xffff},
{ 0x89E0, 0x7381, 0xffff,0xffff},
{ 0x89E2, 0x2132, 0xffff,0xffff},
{ 0x89E4, 0x0000, 0xffff,0xffff},
{ 0x89E6, 0x7914, 0xffff,0xffff},
{ 0x89E8, 0x7900, 0xffff,0xffff},
{ 0x89EA, 0x0323, 0xffff,0xffff},
{ 0x89EC, 0x67BB, 0xffff,0xffff},
{ 0x89EE, 0xD62E, 0xffff,0xffff},
{ 0x89F0, 0x8D11, 0xffff,0xffff},
{ 0x89F2, 0xD1B6, 0xffff,0xffff},
{ 0x89F4, 0x8924, 0xffff,0xffff},
{ 0x89F6, 0x2032, 0xffff,0xffff},
{ 0x89F8, 0x2000, 0xffff,0xffff},
{ 0x89FA, 0xDE02, 0xffff,0xffff},
{ 0x89FC, 0x082B, 0xffff,0xffff},
{ 0x89FE, 0x0040, 0xffff,0xffff},
{ 0x8A00, 0x8D20, 0xffff,0xffff},
{ 0x8A02, 0x8D41, 0xffff,0xffff},
{ 0x8A04, 0xB908, 0xffff,0xffff},
{ 0x8A06, 0x7945, 0xffff,0xffff},
{ 0x8A08, 0xB983, 0xffff,0xffff},
{ 0x8A0A, 0x2941, 0xffff,0xffff},
{ 0x8A0C, 0x0202, 0xffff,0xffff},
{ 0x8A0E, 0xAD40, 0xffff,0xffff},
{ 0x8A10, 0xAD21, 0xffff,0xffff},
{ 0x8A12, 0xD1AF, 0xffff,0xffff},
{ 0x8A14, 0x8120, 0xffff,0xffff},
{ 0x8A16, 0x8121, 0xffff,0xffff},
{ 0x8A18, 0x7940, 0xffff,0xffff},
{ 0x8A1A, 0x8D06, 0xffff,0xffff},
{ 0x8A1C, 0xE001, 0xffff,0xffff},
{ 0x8A1E, 0xAD06, 0xffff,0xffff},
{ 0x8A20, 0x1D4D, 0xffff,0xffff},
{ 0x8A22, 0x1382, 0xffff,0xffff},
{ 0x8A24, 0xF0E9, 0xffff,0xffff},
{ 0x8A26, 0x8D06, 0xffff,0xffff},
{ 0x8A28, 0x1D4D, 0xffff,0xffff},
{ 0x8A2A, 0x1382, 0xffff,0xffff},
{ 0x8A2C, 0xE001, 0xffff,0xffff},
{ 0x8A2E, 0xAD06, 0xffff,0xffff},
{ 0x8A30, 0x8D00, 0xffff,0xffff},
{ 0x8A32, 0x8D21, 0xffff,0xffff},
{ 0x8A34, 0xB808, 0xffff,0xffff},
{ 0x8A36, 0x7825, 0xffff,0xffff},
{ 0x8A38, 0xB885, 0xffff,0xffff},
{ 0x8A3A, 0x2841, 0xffff,0xffff},
{ 0x8A3C, 0x0201, 0xffff,0xffff},
{ 0x8A3E, 0xAD20, 0xffff,0xffff},
{ 0x8A40, 0xAD01, 0xffff,0xffff},
{ 0x8A42, 0x8D31, 0xffff,0xffff},
{ 0x8A44, 0xF01A, 0xffff,0xffff},
{ 0x8A46, 0x8D31, 0xffff,0xffff},
{ 0x8A48, 0x8D12, 0xffff,0xffff},
{ 0x8A4A, 0x8D46, 0xffff,0xffff},
{ 0x8A4C, 0x7822, 0xffff,0xffff},
{ 0x8A4E, 0x0863, 0xffff,0xffff},
{ 0x8A50, 0x0082, 0xffff,0xffff},
{ 0x8A52, 0x1532, 0xffff,0xffff},
{ 0x8A54, 0x1080, 0xffff,0xffff},
{ 0x8A56, 0x1533, 0xffff,0xffff},
{ 0x8A58, 0x1081, 0xffff,0xffff},
{ 0x8A5A, 0x1531, 0xffff,0xffff},
{ 0x8A5C, 0x1082, 0xffff,0xffff},
{ 0x8A5E, 0xB808, 0xffff,0xffff},
{ 0x8A60, 0x7825, 0xffff,0xffff},
{ 0x8A62, 0x1530, 0xffff,0xffff},
{ 0x8A64, 0x1081, 0xffff,0xffff},
{ 0x8A66, 0xB908, 0xffff,0xffff},
{ 0x8A68, 0x7945, 0xffff,0xffff},
{ 0x8A6A, 0xD29A, 0xffff,0xffff},
{ 0x8A6C, 0x0992, 0xffff,0xffff},
{ 0x8A6E, 0x0020, 0xffff,0xffff},
{ 0x8A70, 0x8A40, 0xffff,0xffff},
{ 0x8A72, 0x8D31, 0xffff,0xffff},
{ 0x8A74, 0x081F, 0xffff,0xffff},
{ 0x8A76, 0x0051, 0xffff,0xffff},
{ 0x8A78, 0x8D06, 0xffff,0xffff},
{ 0x8A7A, 0x6038, 0xffff,0xffff},
{ 0x8A7C, 0xD194, 0xffff,0xffff},
{ 0x8A7E, 0x8120, 0xffff,0xffff},
{ 0x8A80, 0x8121, 0xffff,0xffff},
{ 0x8A82, 0x7960, 0xffff,0xffff},
{ 0x8A84, 0x2132, 0xffff,0xffff},
{ 0x8A86, 0x2000, 0xffff,0xffff},
{ 0x8A88, 0x8D06, 0xffff,0xffff},
{ 0x8A8A, 0xE001, 0xffff,0xffff},
{ 0x8A8C, 0xAD06, 0xffff,0xffff},
{ 0x8A8E, 0xD806, 0xffff,0xffff},
{ 0x8A90, 0xF0B1, 0xffff,0xffff},
{ 0x8A92, 0xE88F, 0xffff,0xffff},
{ 0x8A94, 0x8D66, 0xffff,0xffff},
{ 0x8A96, 0x633B, 0xffff,0xffff},
{ 0x8A98, 0x63BB, 0xffff,0xffff},
{ 0x8A9A, 0xD08D, 0xffff,0xffff},
{ 0x8A9C, 0x8000, 0xffff,0xffff},
{ 0x8A9E, 0x8021, 0xffff,0xffff},
{ 0x8AA0, 0x7960, 0xffff,0xffff},
{ 0x8AA2, 0x8B17, 0xffff,0xffff},
{ 0x8AA4, 0x8D06, 0xffff,0xffff},
{ 0x8AA6, 0xE001, 0xffff,0xffff},
{ 0x8AA8, 0xAD06, 0xffff,0xffff},
{ 0x8AAA, 0xD803, 0xffff,0xffff},
{ 0x8AAC, 0xF0A3, 0xffff,0xffff},
{ 0x8AAE, 0x2032, 0xffff,0xffff},
{ 0x8AB0, 0x2040, 0xffff,0xffff},
{ 0x8AB2, 0xAD07, 0xffff,0xffff},
{ 0x8AB4, 0xD804, 0xffff,0xffff},
{ 0x8AB6, 0xF09F, 0xffff,0xffff},
{ 0x8AB8, 0x1532, 0xffff,0xffff},
{ 0x8ABA, 0x1080, 0xffff,0xffff},
{ 0x8ABC, 0x1533, 0xffff,0xffff},
{ 0x8ABE, 0x1081, 0xffff,0xffff},
{ 0x8AC0, 0x1531, 0xffff,0xffff},
{ 0x8AC2, 0x1082, 0xffff,0xffff},
{ 0x8AC4, 0xB808, 0xffff,0xffff},
{ 0x8AC6, 0x7825, 0xffff,0xffff},
{ 0x8AC8, 0x1530, 0xffff,0xffff},
{ 0x8ACA, 0x1081, 0xffff,0xffff},
{ 0x8ACC, 0xB908, 0xffff,0xffff},
{ 0x8ACE, 0x7945, 0xffff,0xffff},
{ 0x8AD0, 0xD280, 0xffff,0xffff},
{ 0x8AD2, 0x092E, 0xffff,0xffff},
{ 0x8AD4, 0x0020, 0xffff,0xffff},
{ 0x8AD6, 0x8A41, 0xffff,0xffff},
{ 0x8AD8, 0x8D51, 0xffff,0xffff},
{ 0x8ADA, 0x8D32, 0xffff,0xffff},
{ 0x8ADC, 0x8DC6, 0xffff,0xffff},
{ 0x8ADE, 0x7942, 0xffff,0xffff},
{ 0x8AE0, 0x62DB, 0xffff,0xffff},
{ 0x8AE2, 0x091F, 0xffff,0xffff},
{ 0x8AE4, 0x03A2, 0xffff,0xffff},
{ 0x8AE6, 0x63BB, 0xffff,0xffff},
{ 0x8AE8, 0xE88B, 0xffff,0xffff},
{ 0x8AEA, 0x8D00, 0xffff,0xffff},
{ 0x8AEC, 0x8D21, 0xffff,0xffff},
{ 0x8AEE, 0xB808, 0xffff,0xffff},
{ 0x8AF0, 0x7825, 0xffff,0xffff},
{ 0x8AF2, 0xB885, 0xffff,0xffff},
{ 0x8AF4, 0x2841, 0xffff,0xffff},
{ 0x8AF6, 0x0201, 0xffff,0xffff},
{ 0x8AF8, 0xAD20, 0xffff,0xffff},
{ 0x8AFA, 0xAD01, 0xffff,0xffff},
{ 0x8AFC, 0xF1CF, 0xffff,0xffff},
{ 0x8AFE, 0xDF04, 0xffff,0xffff},
{ 0x8B00, 0x092B, 0xffff,0xffff},
{ 0x8B02, 0x03A3, 0xffff,0xffff},
{ 0x8B04, 0x1D4D, 0xffff,0xffff},
{ 0x8B06, 0x13C2, 0xffff,0xffff},
{ 0x8B08, 0x1530, 0xffff,0xffff},
{ 0x8B0A, 0x108E, 0xffff,0xffff},
{ 0x8B0C, 0x1531, 0xffff,0xffff},
{ 0x8B0E, 0x1081, 0xffff,0xffff},
{ 0x8B10, 0x1533, 0xffff,0xffff},
{ 0x8B12, 0x108F, 0xffff,0xffff},
{ 0x8B14, 0xBE08, 0xffff,0xffff},
{ 0x8B16, 0x7E25, 0xffff,0xffff},
{ 0x8B18, 0x1532, 0xffff,0xffff},
{ 0x8B1A, 0x1081, 0xffff,0xffff},
{ 0x8B1C, 0xB908, 0xffff,0xffff},
{ 0x8B1E, 0x79E5, 0xffff,0xffff},
{ 0x8B20, 0x0907, 0xffff,0xffff},
{ 0x8B22, 0x0382, 0xffff,0xffff},
{ 0x8B24, 0xE883, 0xffff,0xffff},
{ 0x8B26, 0x8B16, 0xffff,0xffff},
{ 0x8B28, 0xF002, 0xffff,0xffff},
{ 0x8B2A, 0x8B15, 0xffff,0xffff},
{ 0x8B2C, 0x8D22, 0xffff,0xffff},
{ 0x8B2E, 0xAD07, 0xffff,0xffff},
{ 0x8B30, 0x8D03, 0xffff,0xffff},
{ 0x8B32, 0xD367, 0xffff,0xffff},
{ 0x8B34, 0xB908, 0xffff,0xffff},
{ 0x8B36, 0x8DC1, 0xffff,0xffff},
{ 0x8B38, 0x7905, 0xffff,0xffff},
{ 0x8B3A, 0x8D00, 0xffff,0xffff},
{ 0x8B3C, 0xB808, 0xffff,0xffff},
{ 0x8B3E, 0x78C5, 0xffff,0xffff},
{ 0x8B40, 0x0921, 0xffff,0xffff},
{ 0x8B42, 0x011E, 0xffff,0xffff},
{ 0x8B44, 0xB883, 0xffff,0xffff},
{ 0x8B46, 0x2841, 0xffff,0xffff},
{ 0x8B48, 0x0201, 0xffff,0xffff},
{ 0x8B4A, 0xAD20, 0xffff,0xffff},
{ 0x8B4C, 0x8320, 0xffff,0xffff},
{ 0x8B4E, 0xAD01, 0xffff,0xffff},
{ 0x8B50, 0x8121, 0xffff,0xffff},
{ 0x8B52, 0x7960, 0xffff,0xffff},
{ 0x8B54, 0x2032, 0xffff,0xffff},
{ 0x8B56, 0x2080, 0xffff,0xffff},
{ 0x8B58, 0x8D06, 0xffff,0xffff},
{ 0x8B5A, 0xE001, 0xffff,0xffff},
{ 0x8B5C, 0xAD06, 0xffff,0xffff},
{ 0x8B5E, 0xF04D, 0xffff,0xffff},
{ 0x8B60, 0x8D00, 0xffff,0xffff},
{ 0x8B62, 0x8D21, 0xffff,0xffff},
{ 0x8B64, 0xB808, 0xffff,0xffff},
{ 0x8B66, 0x7825, 0xffff,0xffff},
{ 0x8B68, 0xB886, 0xffff,0xffff},
{ 0x8B6A, 0x2841, 0xffff,0xffff},
{ 0x8B6C, 0x0201, 0xffff,0xffff},
{ 0x8B6E, 0xAD20, 0xffff,0xffff},
{ 0x8B70, 0xAD01, 0xffff,0xffff},
{ 0x8B72, 0xD057, 0xffff,0xffff},
{ 0x8B74, 0x8000, 0xffff,0xffff},
{ 0x8B76, 0x8021, 0xffff,0xffff},
{ 0x8B78, 0x7960, 0xffff,0xffff},
{ 0x8B7A, 0x8D07, 0xffff,0xffff},
{ 0x8B7C, 0x1545, 0xffff,0xffff},
{ 0x8B7E, 0x1080, 0xffff,0xffff},
{ 0x8B80, 0x1546, 0xffff,0xffff},
{ 0x8B82, 0x1081, 0xffff,0xffff},
{ 0x8B84, 0xB808, 0xffff,0xffff},
{ 0x8B86, 0x7825, 0xffff,0xffff},
{ 0x8B88, 0x085D, 0xffff,0xffff},
{ 0x8B8A, 0x005E, 0xffff,0xffff},
{ 0x8B8C, 0x8D06, 0xffff,0xffff},
{ 0x8B8E, 0xE001, 0xffff,0xffff},
{ 0x8B90, 0xAD06, 0xffff,0xffff},
{ 0x8B92, 0xD805, 0xffff,0xffff},
{ 0x8B94, 0xF02F, 0xffff,0xffff},
{ 0x8B96, 0x1530, 0xffff,0xffff},
{ 0x8B98, 0x1082, 0xffff,0xffff},
{ 0x8B9A, 0x1531, 0xffff,0xffff},
{ 0x8B9C, 0x1080, 0xffff,0xffff},
{ 0x8B9E, 0xD14D, 0xffff,0xffff},
{ 0x8BA0, 0xBA08, 0xffff,0xffff},
{ 0x8BA2, 0x7A05, 0xffff,0xffff},
{ 0x8BA4, 0x8903, 0xffff,0xffff},
{ 0x8BA6, 0x080F, 0xffff,0xffff},
{ 0x8BA8, 0x0083, 0xffff,0xffff},
{ 0x8BAA, 0x8902, 0xffff,0xffff},
{ 0x8BAC, 0x8E44, 0xffff,0xffff},
{ 0x8BAE, 0x0839, 0xffff,0xffff},
{ 0x8BB0, 0x0082, 0xffff,0xffff},
{ 0x8BB2, 0x1545, 0xffff,0xffff},
{ 0x8BB4, 0x1082, 0xffff,0xffff},
{ 0x8BB6, 0x1546, 0xffff,0xffff},
{ 0x8BB8, 0x1080, 0xffff,0xffff},
{ 0x8BBA, 0xBA08, 0xffff,0xffff},
{ 0x8BBC, 0x7A05, 0xffff,0xffff},
{ 0x8BBE, 0x0A29, 0xffff,0xffff},
{ 0x8BC0, 0x005E, 0xffff,0xffff},
{ 0x8BC2, 0x8D00, 0xffff,0xffff},
{ 0x8BC4, 0x8D21, 0xffff,0xffff},
{ 0x8BC6, 0xB808, 0xffff,0xffff},
{ 0x8BC8, 0x7825, 0xffff,0xffff},
{ 0x8BCA, 0xB88D, 0xffff,0xffff},
{ 0x8BCC, 0x2841, 0xffff,0xffff},
{ 0x8BCE, 0x0201, 0xffff,0xffff},
{ 0x8BD0, 0xAD20, 0xffff,0xffff},
{ 0x8BD2, 0xAD01, 0xffff,0xffff},
{ 0x8BD4, 0x0A11, 0xffff,0xffff},
{ 0x8BD6, 0x009E, 0xffff,0xffff},
{ 0x8BD8, 0xD03D, 0xffff,0xffff},
{ 0x8BDA, 0x8000, 0xffff,0xffff},
{ 0x8BDC, 0x8021, 0xffff,0xffff},
{ 0x8BDE, 0x7960, 0xffff,0xffff},
{ 0x8BE0, 0x1550, 0xffff,0xffff},
{ 0x8BE2, 0x1080, 0xffff,0xffff},
{ 0x8BE4, 0xD800, 0xffff,0xffff},
{ 0x8BE6, 0x09AA, 0xffff,0xffff},
{ 0x8BE8, 0x0164, 0xffff,0xffff},
{ 0x8BEA, 0x1D4D, 0xffff,0xffff},
{ 0x8BEC, 0x1002, 0xffff,0xffff},
{ 0x8BEE, 0xF005, 0xffff,0xffff},
{ 0x8BF0, 0xD800, 0xffff,0xffff},
{ 0x8BF2, 0x1D4D, 0xffff,0xffff},
{ 0x8BF4, 0x1002, 0xffff,0xffff},
{ 0x8BF6, 0x06B1, 0xffff,0xffff},
{ 0x8BF8, 0x0684, 0xffff,0xffff},
{ 0x8BFA, 0x78E0, 0xffff,0xffff},
{ 0x8BFC, 0xC0F1, 0xffff,0xffff},
{ 0x8BFE, 0x0E4E, 0xffff,0xffff},
{ 0x8C00, 0x06A4, 0xffff,0xffff},
{ 0x8C02, 0x7308, 0xffff,0xffff},
{ 0x8C04, 0x0919, 0xffff,0xffff},
{ 0x8C06, 0x0023, 0xffff,0xffff},
{ 0x8C08, 0x721A, 0xffff,0xffff},
{ 0x8C0A, 0xD026, 0xffff,0xffff},
{ 0x8C0C, 0x1030, 0xffff,0xffff},
{ 0x8C0E, 0x0082, 0xffff,0xffff},
{ 0x8C10, 0x1031, 0xffff,0xffff},
{ 0x8C12, 0x0081, 0xffff,0xffff},
{ 0x8C14, 0xBA08, 0xffff,0xffff},
{ 0x8C16, 0x7A25, 0xffff,0xffff},
{ 0x8C18, 0xDD00, 0xffff,0xffff},
{ 0x8C1A, 0xF005, 0xffff,0xffff},
{ 0x8C1C, 0xDD01, 0xffff,0xffff},
{ 0x8C1E, 0x7268, 0xffff,0xffff},
{ 0x8C20, 0x7328, 0xffff,0xffff},
{ 0x8C22, 0x2302, 0xffff,0xffff},
{ 0x8C24, 0x0080, 0xffff,0xffff},
{ 0x8C26, 0x2885, 0xffff,0xffff},
{ 0x8C28, 0x0901, 0xffff,0xffff},
{ 0x8C2A, 0x702F, 0xffff,0xffff},
{ 0x8C2C, 0x0EFA, 0xffff,0xffff},
{ 0x8C2E, 0x06A4, 0xffff,0xffff},
{ 0x8C30, 0x7168, 0xffff,0xffff},
{ 0x8C32, 0xD31C, 0xffff,0xffff},
{ 0x8C34, 0x8BC6, 0xffff,0xffff},
{ 0x8C36, 0x8B31, 0xffff,0xffff},
{ 0x8C38, 0x780F, 0xffff,0xffff},
{ 0x8C3A, 0xD226, 0xffff,0xffff},
{ 0x8C3C, 0x663E, 0xffff,0xffff},
{ 0x8C3E, 0xD123, 0xffff,0xffff},
{ 0x8C40, 0xBE62, 0xffff,0xffff},
{ 0x8C42, 0x7ECF, 0xffff,0xffff},
{ 0x8C44, 0x89E4, 0xffff,0xffff},
{ 0x8C46, 0x2214, 0xffff,0xffff},
{ 0x8C48, 0x0381, 0xffff,0xffff},
{ 0x8C4A, 0xED07, 0xffff,0xffff},
{ 0x8C4C, 0x2840, 0xffff,0xffff},
{ 0x8C4E, 0x020E, 0xffff,0xffff},
{ 0x8C50, 0x7EE5, 0xffff,0xffff},
{ 0x8C52, 0xB1CC, 0xffff,0xffff},
{ 0x8C54, 0xF007, 0xffff,0xffff},
{ 0x8C56, 0x7E12, 0xffff,0xffff},
{ 0x8C58, 0xE601, 0xffff,0xffff},
{ 0x8C5A, 0x7ECF, 0xffff,0xffff},
{ 0x8C5C, 0xBE08, 0xffff,0xffff},
{ 0x8C5E, 0x7FC5, 0xffff,0xffff},
{ 0x8C60, 0xB1EC, 0xffff,0xffff},
{ 0x8C62, 0x080D, 0xffff,0xffff},
{ 0x8C64, 0x2003, 0xffff,0xffff},
{ 0x8C66, 0xED0D, 0xffff,0xffff},
{ 0x8C68, 0xD800, 0xffff,0xffff},
{ 0x8C6A, 0xF01A, 0xffff,0xffff},
{ 0x8C6C, 0x134D, 0xffff,0xffff},
{ 0x8C6E, 0x0080, 0xffff,0xffff},
{ 0x8C70, 0x080B, 0xffff,0xffff},
{ 0x8C72, 0x0190, 0xffff,0xffff},
{ 0x8C74, 0x8A0E, 0xffff,0xffff},
{ 0x8C76, 0x080B, 0xffff,0xffff},
{ 0x8C78, 0x0291, 0xffff,0xffff},
{ 0x8C7A, 0xD801, 0xffff,0xffff},
{ 0x8C7C, 0xF010, 0xffff,0xffff},
{ 0x8C7E, 0x1330, 0xffff,0xffff},
{ 0x8C80, 0x0081, 0xffff,0xffff},
{ 0x8C82, 0x1331, 0xffff,0xffff},
{ 0x8C84, 0x008D, 0xffff,0xffff},
{ 0x8C86, 0xD802, 0xffff,0xffff},
{ 0x8C88, 0xB908, 0xffff,0xffff},
{ 0x8C8A, 0x79A5, 0xffff,0xffff},
{ 0x8C8C, 0xB22A, 0xffff,0xffff},
{ 0x8C8E, 0x1332, 0xffff,0xffff},
{ 0x8C90, 0x0081, 0xffff,0xffff},
{ 0x8C92, 0x1333, 0xffff,0xffff},
{ 0x8C94, 0x008D, 0xffff,0xffff},
{ 0x8C96, 0xB908, 0xffff,0xffff},
{ 0x8C98, 0x79A5, 0xffff,0xffff},
{ 0x8C9A, 0xB22B, 0xffff,0xffff},
{ 0x8C9C, 0x0611, 0xffff,0xffff},
{ 0x8C9E, 0x0684, 0xffff,0xffff},
{ 0x8CA0, 0xFF80, 0xffff,0xffff},
{ 0x8CA2, 0x0290, 0xffff,0xffff},
{ 0x8CA4, 0x8000, 0xffff,0xffff},
{ 0x8CA6, 0x008C, 0xffff,0xffff},
{ 0x8CA8, 0x0000, 0xffff,0xffff},
{ 0x8CAA, 0xF3BC, 0xffff,0xffff},
{ 0x8CAC, 0xFF80, 0xffff,0xffff},
{ 0x8CAE, 0x1120, 0xffff,0xffff},
{ 0x8CB0, 0xFF80, 0xffff,0xffff},
{ 0x8CB2, 0x08EC, 0xffff,0xffff},
{ 0x8CB4, 0xFF80, 0xffff,0xffff},
{ 0x8CB6, 0x0954, 0xffff,0xffff},
{ 0x8CB8, 0xFF80, 0xffff,0xffff},
{ 0x8CBA, 0x0970, 0xffff,0xffff},
{ 0x8CBC, 0xFF80, 0xffff,0xffff},
{ 0x8CBE, 0x0CD4, 0xffff,0xffff},
{ 0x8CC0, 0xFF80, 0xffff,0xffff},
{ 0x8CC2, 0x06C8, 0xffff,0xffff},
{ 0x8CC4, 0xFF80, 0xffff,0xffff},
{ 0x8CC6, 0x050C, 0xffff,0xffff},
{ 0x8CC8, 0xFF80, 0xffff,0xffff},
{ 0x8CCA, 0x0158, 0xffff,0xffff},
{ 0x8CCC, 0x8000, 0xffff,0xffff},
{ 0x8CCE, 0x0008, 0xffff,0xffff},
{ 0x8CD0, 0xFF80, 0xffff,0xffff},
{ 0x8CD2, 0x10C8, 0xffff,0xffff},
{ 0x8CD4, 0xC0F1, 0xffff,0xffff},
{ 0x8CD6, 0x0D7E, 0xffff,0xffff},
{ 0x8CD8, 0x0684, 0xffff,0xffff},
{ 0x8CDA, 0x17C8, 0xffff,0xffff},
{ 0x8CDC, 0xF00D, 0xffff,0xffff},
{ 0x8CDE, 0x1545, 0xffff,0xffff},
{ 0x8CE0, 0x1080, 0xffff,0xffff},
{ 0x8CE2, 0x1546, 0xffff,0xffff},
{ 0x8CE4, 0x1081, 0xffff,0xffff},
{ 0x8CE6, 0xB808, 0xffff,0xffff},
{ 0x8CE8, 0x7825, 0xffff,0xffff},
{ 0x8CEA, 0xB8E0, 0xffff,0xffff},
{ 0x8CEC, 0xDE00, 0xffff,0xffff},
{ 0x8CEE, 0xF208, 0xffff,0xffff},
{ 0x8CF0, 0x8D00, 0xffff,0xffff},
{ 0x8CF2, 0x8D21, 0xffff,0xffff},
{ 0x8CF4, 0xB808, 0xffff,0xffff},
{ 0x8CF6, 0x7825, 0xffff,0xffff},
{ 0x8CF8, 0x2044, 0xffff,0xffff},
{ 0x8CFA, 0x020E, 0xffff,0xffff},
{ 0x8CFC, 0x8D00, 0xffff,0xffff},
{ 0x8CFE, 0x8D21, 0xffff,0xffff},
{ 0x8D00, 0xB808, 0xffff,0xffff},
{ 0x8D02, 0x7825, 0xffff,0xffff},
{ 0x8D04, 0x082F, 0xffff,0xffff},
{ 0x8D06, 0x00DE, 0xffff,0xffff},
{ 0x8D08, 0x7108, 0xffff,0xffff},
{ 0x8D0A, 0x2186, 0xffff,0xffff},
{ 0x8D0C, 0x0FFE, 0xffff,0xffff},
{ 0x8D0E, 0x262F, 0xffff,0xffff},
{ 0x8D10, 0xF04A, 0xffff,0xffff},
{ 0x8D12, 0xF211, 0xffff,0xffff},
{ 0x8D14, 0x17BC, 0xffff,0xffff},
{ 0x8D16, 0xF002, 0xffff,0xffff},
{ 0x8D18, 0x8A25, 0xffff,0xffff},
{ 0x8D1A, 0xE906, 0xffff,0xffff},
{ 0x8D1C, 0xB961, 0xffff,0xffff},
{ 0x8D1E, 0xAA25, 0xffff,0xffff},
{ 0x8D20, 0xD806, 0xffff,0xffff},
{ 0x8D22, 0xF01E, 0xffff,0xffff},
{ 0x8D24, 0x8A24, 0xffff,0xffff},
{ 0x8D26, 0xB8A3, 0xffff,0xffff},
{ 0x8D28, 0xAA25, 0xffff,0xffff},
{ 0x8D2A, 0x2841, 0xffff,0xffff},
{ 0x8D2C, 0x0201, 0xffff,0xffff},
{ 0x8D2E, 0xAD20, 0xffff,0xffff},
{ 0x8D30, 0xAD01, 0xffff,0xffff},
{ 0x8D32, 0x0D56, 0xffff,0xffff},
{ 0x8D34, 0x0144, 0xffff,0xffff},
{ 0x8D36, 0x1545, 0xffff,0xffff},
{ 0x8D38, 0x1081, 0xffff,0xffff},
{ 0x8D3A, 0x1546, 0xffff,0xffff},
{ 0x8D3C, 0x1082, 0xffff,0xffff},
{ 0x8D3E, 0xB908, 0xffff,0xffff},
{ 0x8D40, 0x7945, 0xffff,0xffff},
{ 0x8D42, 0xB9E0, 0xffff,0xffff},
{ 0x8D44, 0x26CC, 0xffff,0xffff},
{ 0x8D46, 0x9022, 0xffff,0xffff},
{ 0x8D48, 0xF20A, 0xffff,0xffff},
{ 0x8D4A, 0x8D20, 0xffff,0xffff},
{ 0x8D4C, 0x8D41, 0xffff,0xffff},
{ 0x8D4E, 0xB908, 0xffff,0xffff},
{ 0x8D50, 0x7945, 0xffff,0xffff},
{ 0x8D52, 0xB983, 0xffff,0xffff},
{ 0x8D54, 0x2941, 0xffff,0xffff},
{ 0x8D56, 0x0202, 0xffff,0xffff},
{ 0x8D58, 0xAD40, 0xffff,0xffff},
{ 0x8D5A, 0xAD21, 0xffff,0xffff},
{ 0x8D5C, 0x0561, 0xffff,0xffff},
{ 0x8D5E, 0x0684, 0xffff,0xffff},
{ 0x8D60, 0xC0F1, 0xffff,0xffff},
{ 0x8D62, 0x0CEE, 0xffff,0xffff},
{ 0x8D64, 0x06A4, 0xffff,0xffff},
{ 0x8D66, 0x7098, 0xffff,0xffff},
{ 0x8D68, 0xD284, 0xffff,0xffff},
{ 0x8D6A, 0x1206, 0xffff,0xffff},
{ 0x8D6C, 0x0086, 0xffff,0xffff},
{ 0x8D6E, 0x2240, 0xffff,0xffff},
{ 0x8D70, 0x0205, 0xffff,0xffff},
{ 0x8D72, 0x264C, 0xffff,0xffff},
{ 0x8D74, 0x8000, 0xffff,0xffff},
{ 0x8D76, 0x20CA, 0xffff,0xffff},
{ 0x8D78, 0x0101, 0xffff,0xffff},
{ 0x8D7A, 0xF237, 0xffff,0xffff},
{ 0x8D7C, 0x8AA7, 0xffff,0xffff},
{ 0x8D7E, 0x6D69, 0xffff,0xffff},
{ 0x8D80, 0x7B6D, 0xffff,0xffff},
{ 0x8D82, 0x0B3F, 0xffff,0xffff},
{ 0x8D84, 0x0012, 0xffff,0xffff},
{ 0x8D86, 0x7068, 0xffff,0xffff},
{ 0x8D88, 0x780D, 0xffff,0xffff},
{ 0x8D8A, 0x2040, 0xffff,0xffff},
{ 0x8D8C, 0x007C, 0xffff,0xffff},
{ 0x8D8E, 0x20A8, 0xffff,0xffff},
{ 0x8D90, 0x0640, 0xffff,0xffff},
{ 0x8D92, 0x71CF, 0xffff,0xffff},
{ 0x8D94, 0xFF80, 0xffff,0xffff},
{ 0x8D96, 0x0158, 0xffff,0xffff},
{ 0x8D98, 0x8924, 0xffff,0xffff},
{ 0x8D9A, 0x2532, 0xffff,0xffff},
{ 0x8D9C, 0x00C0, 0xffff,0xffff},
{ 0x8D9E, 0xBD61, 0xffff,0xffff},
{ 0x8DA0, 0x0819, 0xffff,0xffff},
{ 0x8DA2, 0x0063, 0xffff,0xffff},
{ 0x8DA4, 0x7DAF, 0xffff,0xffff},
{ 0x8DA6, 0x76CF, 0xffff,0xffff},
{ 0x8DA8, 0xFF80, 0xffff,0xffff},
{ 0x8DAA, 0x0290, 0xffff,0xffff},
{ 0x8DAC, 0x8EF1, 0xffff,0xffff},
{ 0x8DAE, 0x2640, 0xffff,0xffff},
{ 0x8DB0, 0x1601, 0xffff,0xffff},
{ 0x8DB2, 0x61E9, 0xffff,0xffff},
{ 0x8DB4, 0x090F, 0xffff,0xffff},
{ 0x8DB6, 0x0002, 0xffff,0xffff},
{ 0x8DB8, 0xAAA7, 0xffff,0xffff},
{ 0x8DBA, 0xBB61, 0xffff,0xffff},
{ 0x8DBC, 0x7B6D, 0xffff,0xffff},
{ 0x8DBE, 0x7088, 0xffff,0xffff},
{ 0x8DC0, 0xF005, 0xffff,0xffff},
{ 0x8DC2, 0x8E26, 0xffff,0xffff},
{ 0x8DC4, 0xAAA7, 0xffff,0xffff},
{ 0x8DC6, 0xB961, 0xffff,0xffff},
{ 0x8DC8, 0xAE26, 0xffff,0xffff},
{ 0x8DCA, 0x0B1F, 0xffff,0xffff},
{ 0x8DCC, 0x0013, 0xffff,0xffff},
{ 0x8DCE, 0x1A07, 0xffff,0xffff},
{ 0x8DD0, 0x0182, 0xffff,0xffff},
{ 0x8DD2, 0xD26B, 0xffff,0xffff},
{ 0x8DD4, 0x8A20, 0xffff,0xffff},
{ 0x8DD6, 0x8A61, 0xffff,0xffff},
{ 0x8DD8, 0xB908, 0xffff,0xffff},
{ 0x8DDA, 0x7965, 0xffff,0xffff},
{ 0x8DDC, 0xB9A3, 0xffff,0xffff},
{ 0x8DDE, 0x2941, 0xffff,0xffff},
{ 0x8DE0, 0x020C, 0xffff,0xffff},
{ 0x8DE2, 0xAA80, 0xffff,0xffff},
{ 0x8DE4, 0xAA21, 0xffff,0xffff},
{ 0x8DE6, 0x04D1, 0xffff,0xffff},
{ 0x8DE8, 0x0684, 0xffff,0xffff},
{ 0x8DEA, 0x78E0, 0xffff,0xffff},
{ 0x8DEC, 0xC0F1, 0xffff,0xffff},
{ 0x8DEE, 0xC5E1, 0xffff,0xffff},
{ 0x8DF0, 0xD363, 0xffff,0xffff},
{ 0x8DF2, 0x8B24, 0xffff,0xffff},
{ 0x8DF4, 0x8B45, 0xffff,0xffff},
{ 0x8DF6, 0xB908, 0xffff,0xffff},
{ 0x8DF8, 0x7945, 0xffff,0xffff},
{ 0x8DFA, 0xE188, 0xffff,0xffff},
{ 0x8DFC, 0x21CC, 0xffff,0xffff},
{ 0x8DFE, 0x8422, 0xffff,0xffff},
{ 0x8E00, 0xF41F, 0xffff,0xffff},
{ 0x8E02, 0x8B26, 0xffff,0xffff},
{ 0x8E04, 0x093B, 0xffff,0xffff},
{ 0x8E06, 0x0051, 0xffff,0xffff},
{ 0x8E08, 0xD15C, 0xffff,0xffff},
{ 0x8E0A, 0xD80A, 0xffff,0xffff},
{ 0x8E0C, 0xA90E, 0xffff,0xffff},
{ 0x8E0E, 0xD05D, 0xffff,0xffff},
{ 0x8E10, 0x8804, 0xffff,0xffff},
{ 0x8E12, 0x1330, 0xffff,0xffff},
{ 0x8E14, 0x0082, 0xffff,0xffff},
{ 0x8E16, 0x1331, 0xffff,0xffff},
{ 0x8E18, 0x008D, 0xffff,0xffff},
{ 0x8E1A, 0xBA08, 0xffff,0xffff},
{ 0x8E1C, 0x7AA5, 0xffff,0xffff},
{ 0x8E1E, 0xB148, 0xffff,0xffff},
{ 0x8E20, 0x8952, 0xffff,0xffff},
{ 0x8E22, 0xA90F, 0xffff,0xffff},
{ 0x8E24, 0x0813, 0xffff,0xffff},
{ 0x8E26, 0x00A2, 0xffff,0xffff},
{ 0x8E28, 0x132C, 0xffff,0xffff},
{ 0x8E2A, 0x0083, 0xffff,0xffff},
{ 0x8E2C, 0xDA00, 0xffff,0xffff},
{ 0x8E2E, 0xA953, 0xffff,0xffff},
{ 0x8E30, 0x7862, 0xffff,0xffff},
{ 0x8E32, 0x780F, 0xffff,0xffff},
{ 0x8E34, 0xF005, 0xffff,0xffff},
{ 0x8E36, 0xDA01, 0xffff,0xffff},
{ 0x8E38, 0xA953, 0xffff,0xffff},
{ 0x8E3A, 0x6078, 0xffff,0xffff},
{ 0x8E3C, 0x780F, 0xffff,0xffff},
{ 0x8E3E, 0x080E, 0xffff,0xffff},
{ 0x8E40, 0x0000, 0xffff,0xffff},
{ 0x8E42, 0x0485, 0xffff,0xffff},
{ 0x8E44, 0x0684, 0xffff,0xffff},
{ 0x8E46, 0x78E0, 0xffff,0xffff},
{ 0x8E48, 0xC0F1, 0xffff,0xffff},
{ 0x8E4A, 0x0BFE, 0xffff,0xffff},
{ 0x8E4C, 0x0684, 0xffff,0xffff},
{ 0x8E4E, 0xD64D, 0xffff,0xffff},
{ 0x8E50, 0x7508, 0xffff,0xffff},
{ 0x8E52, 0x8E01, 0xffff,0xffff},
{ 0x8E54, 0xD14A, 0xffff,0xffff},
{ 0x8E56, 0x2046, 0xffff,0xffff},
{ 0x8E58, 0x00C0, 0xffff,0xffff},
{ 0x8E5A, 0xAE01, 0xffff,0xffff},
{ 0x8E5C, 0x1145, 0xffff,0xffff},
{ 0x8E5E, 0x0080, 0xffff,0xffff},
{ 0x8E60, 0x1146, 0xffff,0xffff},
{ 0x8E62, 0x0082, 0xffff,0xffff},
{ 0x8E64, 0xB808, 0xffff,0xffff},
{ 0x8E66, 0x7845, 0xffff,0xffff},
{ 0x8E68, 0x0817, 0xffff,0xffff},
{ 0x8E6A, 0x001E, 0xffff,0xffff},
{ 0x8E6C, 0x8900, 0xffff,0xffff},
{ 0x8E6E, 0x8941, 0xffff,0xffff},
{ 0x8E70, 0xB808, 0xffff,0xffff},
{ 0x8E72, 0x7845, 0xffff,0xffff},
{ 0x8E74, 0x080B, 0xffff,0xffff},
{ 0x8E76, 0x00DE, 0xffff,0xffff},
{ 0x8E78, 0x70A9, 0xffff,0xffff},
{ 0x8E7A, 0xFFBA, 0xffff,0xffff},
{ 0x8E7C, 0x7508, 0xffff,0xffff},
{ 0x8E7E, 0x1604, 0xffff,0xffff},
{ 0x8E80, 0x1090, 0xffff,0xffff},
{ 0x8E82, 0x0D93, 0xffff,0xffff},
{ 0x8E84, 0x1400, 0xffff,0xffff},
{ 0x8E86, 0x8EEA, 0xffff,0xffff},
{ 0x8E88, 0x8E0B, 0xffff,0xffff},
{ 0x8E8A, 0x214A, 0xffff,0xffff},
{ 0x8E8C, 0x2040, 0xffff,0xffff},
{ 0x8E8E, 0x8E2D, 0xffff,0xffff},
{ 0x8E90, 0xBF08, 0xffff,0xffff},
{ 0x8E92, 0x7F05, 0xffff,0xffff},
{ 0x8E94, 0x8E0C, 0xffff,0xffff},
{ 0x8E96, 0xB808, 0xffff,0xffff},
{ 0x8E98, 0x7825, 0xffff,0xffff},
{ 0x8E9A, 0x7710, 0xffff,0xffff},
{ 0x8E9C, 0x21C2, 0xffff,0xffff},
{ 0x8E9E, 0x244C, 0xffff,0xffff},
{ 0x8EA0, 0x081D, 0xffff,0xffff},
{ 0x8EA2, 0x03E3, 0xffff,0xffff},
{ 0x8EA4, 0xD9FF, 0xffff,0xffff},
{ 0x8EA6, 0x2702, 0xffff,0xffff},
{ 0x8EA8, 0x1002, 0xffff,0xffff},
{ 0x8EAA, 0x2A05, 0xffff,0xffff},
{ 0x8EAC, 0x037E, 0xffff,0xffff},
{ 0x8EAE, 0x0C7A, 0xffff,0xffff},
{ 0x8EB0, 0x06A4, 0xffff,0xffff},
{ 0x8EB2, 0x702F, 0xffff,0xffff},
{ 0x8EB4, 0x7810, 0xffff,0xffff},
{ 0x8EB6, 0x7F02, 0xffff,0xffff},
{ 0x8EB8, 0x7FF0, 0xffff,0xffff},
{ 0x8EBA, 0xF00B, 0xffff,0xffff},
{ 0x8EBC, 0x78E2, 0xffff,0xffff},
{ 0x8EBE, 0x2805, 0xffff,0xffff},
{ 0x8EC0, 0x037E, 0xffff,0xffff},
{ 0x8EC2, 0x0C66, 0xffff,0xffff},
{ 0x8EC4, 0x06A4, 0xffff,0xffff},
{ 0x8EC6, 0x702F, 0xffff,0xffff},
{ 0x8EC8, 0x7810, 0xffff,0xffff},
{ 0x8ECA, 0x671F, 0xffff,0xffff},
{ 0x8ECC, 0x7FF0, 0xffff,0xffff},
{ 0x8ECE, 0x7FEF, 0xffff,0xffff},
{ 0x8ED0, 0x8E08, 0xffff,0xffff},
{ 0x8ED2, 0xBF06, 0xffff,0xffff},
{ 0x8ED4, 0xD12C, 0xffff,0xffff},
{ 0x8ED6, 0xB8C3, 0xffff,0xffff},
{ 0x8ED8, 0x78E5, 0xffff,0xffff},
{ 0x8EDA, 0xB88F, 0xffff,0xffff},
{ 0x8EDC, 0x1908, 0xffff,0xffff},
{ 0x8EDE, 0x0024, 0xffff,0xffff},
{ 0x8EE0, 0x2841, 0xffff,0xffff},
{ 0x8EE2, 0x0201, 0xffff,0xffff},
{ 0x8EE4, 0x1E26, 0xffff,0xffff},
{ 0x8EE6, 0x1042, 0xffff,0xffff},
{ 0x8EE8, 0x0D15, 0xffff,0xffff},
{ 0x8EEA, 0x1423, 0xffff,0xffff},
{ 0x8EEC, 0x1E27, 0xffff,0xffff},
{ 0x8EEE, 0x1002, 0xffff,0xffff},
{ 0x8EF0, 0x214C, 0xffff,0xffff},
{ 0x8EF2, 0xA000, 0xffff,0xffff},
{ 0x8EF4, 0x214A, 0xffff,0xffff},
{ 0x8EF6, 0x2040, 0xffff,0xffff},
{ 0x8EF8, 0x21C2, 0xffff,0xffff},
{ 0x8EFA, 0x2442, 0xffff,0xffff},
{ 0x8EFC, 0x8E21, 0xffff,0xffff},
{ 0x8EFE, 0x214F, 0xffff,0xffff},
{ 0x8F00, 0x0040, 0xffff,0xffff},
{ 0x8F02, 0x090F, 0xffff,0xffff},
{ 0x8F04, 0x2010, 0xffff,0xffff},
{ 0x8F06, 0x2145, 0xffff,0xffff},
{ 0x8F08, 0x0181, 0xffff,0xffff},
{ 0x8F0A, 0xAE21, 0xffff,0xffff},
{ 0x8F0C, 0xF003, 0xffff,0xffff},
{ 0x8F0E, 0xB8A2, 0xffff,0xffff},
{ 0x8F10, 0xAE01, 0xffff,0xffff},
{ 0x8F12, 0x0FFE, 0xffff,0xffff},
{ 0x8F14, 0xFFA3, 0xffff,0xffff},
{ 0x8F16, 0x70A9, 0xffff,0xffff},
{ 0x8F18, 0x038D, 0xffff,0xffff},
{ 0x8F1A, 0x0684, 0xffff,0xffff},
{ 0x8F1C, 0xC0F1, 0xffff,0xffff},
{ 0x8F1E, 0xC5E1, 0xffff,0xffff},
{ 0x8F20, 0xD518, 0xffff,0xffff},
{ 0x8F22, 0x8D00, 0xffff,0xffff},
{ 0x8F24, 0xB8E7, 0xffff,0xffff},
{ 0x8F26, 0x20D1, 0xffff,0xffff},
{ 0x8F28, 0x80E2, 0xffff,0xffff},
{ 0x8F2A, 0xF20D, 0xffff,0xffff},
{ 0x8F2C, 0xD117, 0xffff,0xffff},
{ 0x8F2E, 0xB8A7, 0xffff,0xffff},
{ 0x8F30, 0xAD00, 0xffff,0xffff},
{ 0x8F32, 0xD017, 0xffff,0xffff},
{ 0x8F34, 0x7228, 0xffff,0xffff},
{ 0x8F36, 0x8123, 0xffff,0xffff},
{ 0x8F38, 0xA040, 0xffff,0xffff},
{ 0x8F3A, 0x7960, 0xffff,0xffff},
{ 0x8F3C, 0xD801, 0xffff,0xffff},
{ 0x8F3E, 0xD800, 0xffff,0xffff},
{ 0x8F40, 0xAD05, 0xffff,0xffff},
{ 0x8F42, 0x0F56, 0xffff,0xffff},
{ 0x8F44, 0xFF83, 0xffff,0xffff},
{ 0x8F46, 0x0381, 0xffff,0xffff},
{ 0x8F48, 0x0684, 0xffff,0xffff},
{ 0x8F4A, 0x78E0, 0xffff,0xffff},
{ 0x8F4C, 0xD20D, 0xffff,0xffff},
{ 0x8F4E, 0x8A21, 0xffff,0xffff},
{ 0x8F50, 0xB9A1, 0xffff,0xffff},
{ 0x8F52, 0x782F, 0xffff,0xffff},
{ 0x8F54, 0x7FE0, 0xffff,0xffff},
{ 0x8F56, 0xAA21, 0xffff,0xffff},
{ 0x8F58, 0xD00E, 0xffff,0xffff},
{ 0x8F5A, 0xD10C, 0xffff,0xffff},
{ 0x8F5C, 0xA100, 0xffff,0xffff},
{ 0x8F5E, 0xD00E, 0xffff,0xffff},
{ 0x8F60, 0xA101, 0xffff,0xffff},
{ 0x8F62, 0xD00E, 0xffff,0xffff},
{ 0x8F64, 0xA102, 0xffff,0xffff},
{ 0x8F66, 0xD00E, 0xffff,0xffff},
{ 0x8F68, 0xA103, 0xffff,0xffff},
{ 0x8F6A, 0xD009, 0xffff,0xffff},
{ 0x8F6C, 0xA020, 0xffff,0xffff},
{ 0x8F6E, 0xD005, 0xffff,0xffff},
{ 0x8F70, 0xD988, 0xffff,0xffff},
{ 0x8F72, 0xA820, 0xffff,0xffff},
{ 0x8F74, 0xF1D4, 0xffff,0xffff},
{ 0x8F76, 0x78E0, 0xffff,0xffff},
{ 0x8F78, 0xFF80, 0xffff,0xffff},
{ 0x8F7A, 0x10C8, 0xffff,0xffff},
{ 0x8F7C, 0xFF80, 0xffff,0xffff},
{ 0x8F7E, 0x0290, 0xffff,0xffff},
{ 0x8F80, 0xFF80, 0xffff,0xffff},
{ 0x8F82, 0x0158, 0xffff,0xffff},
{ 0x8F84, 0xFF00, 0xffff,0xffff},
{ 0x8F86, 0x0618, 0xffff,0xffff},
{ 0x8F88, 0xFF80, 0xffff,0xffff},
{ 0x8F8A, 0x1158, 0xffff,0xffff},
{ 0x8F8C, 0x8000, 0xffff,0xffff},
{ 0x8F8E, 0x0008, 0xffff,0xffff},
{ 0x8F90, 0xFF80, 0xffff,0xffff},
{ 0x8F92, 0x0F1C, 0xffff,0xffff},
{ 0x8F94, 0xFF80, 0xffff,0xffff},
{ 0x8F96, 0x0DEC, 0xffff,0xffff},
{ 0x8F98, 0xFF80, 0xffff,0xffff},
{ 0x8F9A, 0x0F4C, 0xffff,0xffff},
{ 0x8F9C, 0x0000, 0xffff,0xffff},
{ 0x8F9E, 0x0998, 0xffff,0xffff},
{ 0x8FA0, 0xC0F1, 0xffff,0xffff},
{ 0x8FA2, 0xC5E1, 0xffff,0xffff},
{ 0x8FA4, 0xD02C, 0xffff,0xffff},
{ 0x8FA6, 0x0982, 0xffff,0xffff},
{ 0x8FA8, 0x0664, 0xffff,0xffff},
{ 0x8FAA, 0x88AE, 0xffff,0xffff},
{ 0x8FAC, 0x0D23, 0xffff,0xffff},
{ 0x8FAE, 0x1051, 0xffff,0xffff},
{ 0x8FB0, 0xD12A, 0xffff,0xffff},
{ 0x8FB2, 0x1145, 0xffff,0xffff},
{ 0x8FB4, 0x0080, 0xffff,0xffff},
{ 0x8FB6, 0x1146, 0xffff,0xffff},
{ 0x8FB8, 0x0082, 0xffff,0xffff},
{ 0x8FBA, 0xB808, 0xffff,0xffff},
{ 0x8FBC, 0x7845, 0xffff,0xffff},
{ 0x8FBE, 0x0813, 0xffff,0xffff},
{ 0x8FC0, 0x00DE, 0xffff,0xffff},
{ 0x8FC2, 0xD027, 0xffff,0xffff},
{ 0x8FC4, 0x8000, 0xffff,0xffff},
{ 0x8FC6, 0x8041, 0xffff,0xffff},
{ 0x8FC8, 0x7A60, 0xffff,0xffff},
{ 0x8FCA, 0x1150, 0xffff,0xffff},
{ 0x8FCC, 0x0080, 0xffff,0xffff},
{ 0x8FCE, 0x02F9, 0xffff,0xffff},
{ 0x8FD0, 0x0684, 0xffff,0xffff},
{ 0x8FD2, 0x78E0, 0xffff,0xffff},
{ 0x8FD4, 0xC0F1, 0xffff,0xffff},
{ 0x8FD6, 0x0A7E, 0xffff,0xffff},
{ 0x8FD8, 0x0684, 0xffff,0xffff},
{ 0x8FDA, 0xD622, 0xffff,0xffff},
{ 0x8FDC, 0x8EA9, 0xffff,0xffff},
{ 0x8FDE, 0x8E2A, 0xffff,0xffff},
{ 0x8FE0, 0xBD08, 0xffff,0xffff},
{ 0x8FE2, 0x7D25, 0xffff,0xffff},
{ 0x8FE4, 0x2550, 0xffff,0xffff},
{ 0x8FE6, 0x10C2, 0xffff,0xffff},
{ 0x8FE8, 0x2A41, 0xffff,0xffff},
{ 0x8FEA, 0x0201, 0xffff,0xffff},
{ 0x8FEC, 0xAE29, 0xffff,0xffff},
{ 0x8FEE, 0x0F9A, 0xffff,0xffff},
{ 0x8FF0, 0x05A4, 0xffff,0xffff},
{ 0x8FF2, 0xAE4A, 0xffff,0xffff},
{ 0x8FF4, 0x0D17, 0xffff,0xffff},
{ 0x8FF6, 0x10DE, 0xffff,0xffff},
{ 0x8FF8, 0x8E09, 0xffff,0xffff},
{ 0x8FFA, 0x8E2A, 0xffff,0xffff},
{ 0x8FFC, 0xB808, 0xffff,0xffff},
{ 0x8FFE, 0x7825, 0xffff,0xffff},
{ 0x9000, 0xB883, 0xffff,0xffff},
{ 0x9002, 0x2841, 0xffff,0xffff},
{ 0x9004, 0x0201, 0xffff,0xffff},
{ 0x9006, 0xAE29, 0xffff,0xffff},
{ 0x9008, 0xAE0A, 0xffff,0xffff},
{ 0x900A, 0x02B5, 0xffff,0xffff},
{ 0x900C, 0x0684, 0xffff,0xffff},
{ 0x900E, 0x78E0, 0xffff,0xffff},
{ 0x9010, 0xC0F1, 0xffff,0xffff},
{ 0x9012, 0x0A42, 0xffff,0xffff},
{ 0x9014, 0x06A4, 0xffff,0xffff},
{ 0x9016, 0xDA34, 0xffff,0xffff},
{ 0x9018, 0xD113, 0xffff,0xffff},
{ 0x901A, 0xD514, 0xffff,0xffff},
{ 0x901C, 0x76A9, 0xffff,0xffff},
{ 0x901E, 0x0FD6, 0xffff,0xffff},
{ 0x9020, 0x0664, 0xffff,0xffff},
{ 0x9022, 0x70C9, 0xffff,0xffff},
{ 0x9024, 0xD012, 0xffff,0xffff},
{ 0x9026, 0xA504, 0xffff,0xffff},
{ 0x9028, 0xD012, 0xffff,0xffff},
{ 0x902A, 0x0295, 0xffff,0xffff},
{ 0x902C, 0x06A4, 0xffff,0xffff},
{ 0x902E, 0xA0C0, 0xffff,0xffff},
{ 0x9030, 0xC0F1, 0xffff,0xffff},
{ 0x9032, 0xC5E1, 0xffff,0xffff},
{ 0x9034, 0xD50D, 0xffff,0xffff},
{ 0x9036, 0xD110, 0xffff,0xffff},
{ 0x9038, 0x2540, 0xffff,0xffff},
{ 0x903A, 0x1D00, 0xffff,0xffff},
{ 0x903C, 0x0FB6, 0xffff,0xffff},
{ 0x903E, 0x0664, 0xffff,0xffff},
{ 0x9040, 0xDA50, 0xffff,0xffff},
{ 0x9042, 0xD00E, 0xffff,0xffff},
{ 0x9044, 0x2540, 0xffff,0xffff},
{ 0x9046, 0x1D01, 0xffff,0xffff},
{ 0x9048, 0xA517, 0xffff,0xffff},
{ 0x904A, 0xD00D, 0xffff,0xffff},
{ 0x904C, 0x0279, 0xffff,0xffff},
{ 0x904E, 0x06A4, 0xffff,0xffff},
{ 0x9050, 0xA020, 0xffff,0xffff},
{ 0x9052, 0x78E0, 0xffff,0xffff},
{ 0x9054, 0xFF80, 0xffff,0xffff},
{ 0x9056, 0x07A8, 0xffff,0xffff},
{ 0x9058, 0xFF80, 0xffff,0xffff},
{ 0x905A, 0x0290, 0xffff,0xffff},
{ 0x905C, 0x8000, 0xffff,0xffff},
{ 0x905E, 0x0008, 0xffff,0xffff},
{ 0x9060, 0xFF80, 0xffff,0xffff},
{ 0x9062, 0x02CC, 0xffff,0xffff},
{ 0x9064, 0x0000, 0xffff,0xffff},
{ 0x9066, 0xFA88, 0xffff,0xffff},
{ 0x9068, 0xFF80, 0xffff,0xffff},
{ 0x906A, 0x1168, 0xffff,0xffff},
{ 0x906C, 0xFF80, 0xffff,0xffff},
{ 0x906E, 0x0FD4, 0xffff,0xffff},
{ 0x9070, 0x8000, 0xffff,0xffff},
{ 0x9072, 0x0194, 0xffff,0xffff},
{ 0x9074, 0x0000, 0xffff,0xffff},
{ 0x9076, 0xFB08, 0xffff,0xffff},
{ 0x9078, 0xFF80, 0xffff,0xffff},
{ 0x907A, 0x0FA0, 0xffff,0xffff},
{ 0x907C, 0x8000, 0xffff,0xffff},
{ 0x907E, 0x01A0, 0xffff,0xffff},
{ 0x9080, 0xE280, 0xffff,0xffff},
{ 0x9082, 0x24CA, 0xffff,0xffff},
{ 0x9084, 0x7082, 0xffff,0xffff},
{ 0x9086, 0x78E0, 0xffff,0xffff},
{ 0x9088, 0x20E8, 0xffff,0xffff},
{ 0x908A, 0x01A2, 0xffff,0xffff},
{ 0x908C, 0x1002, 0xffff,0xffff},
{ 0x908E, 0x0D02, 0xffff,0xffff},
{ 0x9090, 0x1902, 0xffff,0xffff},
{ 0x9092, 0x0094, 0xffff,0xffff},
{ 0x9094, 0x7FE0, 0xffff,0xffff},
{ 0x9096, 0x7028, 0xffff,0xffff},
{ 0x9098, 0x7308, 0xffff,0xffff},
{ 0x909A, 0x1000, 0xffff,0xffff},
{ 0x909C, 0x0900, 0xffff,0xffff},
{ 0x909E, 0x7904, 0xffff,0xffff},
{ 0x90A0, 0x7947, 0xffff,0xffff},
{ 0x90A2, 0x1B00, 0xffff,0xffff},
{ 0x90A4, 0x0064, 0xffff,0xffff},
{ 0x90A6, 0x7EE0, 0xffff,0xffff},
{ 0x90A8, 0xE280, 0xffff,0xffff},
{ 0x90AA, 0x24CA, 0xffff,0xffff},
{ 0x90AC, 0x7082, 0xffff,0xffff},
{ 0x90AE, 0x78E0, 0xffff,0xffff},
{ 0x90B0, 0x20E8, 0xffff,0xffff},
{ 0x90B2, 0x01A2, 0xffff,0xffff},
{ 0x90B4, 0x1102, 0xffff,0xffff},
{ 0x90B6, 0x0502, 0xffff,0xffff},
{ 0x90B8, 0x1802, 0xffff,0xffff},
{ 0x90BA, 0x00B4, 0xffff,0xffff},
{ 0x90BC, 0x7FE0, 0xffff,0xffff},
{ 0x90BE, 0x7028, 0xffff,0xffff},
{ 0x90C0, 0x0000, 0xffff,0xffff},
{ 0x90C2, 0x0000, 0xffff,0xffff},
{ 0x90C4, 0x0000, 0xffff,0xffff},
{ 0x90C6, 0x0000, 0xffff,0xffff},
{ 0x098E, 0x0000, 0xffff,0xffff}, 	// LOGICAL_ADDRESS_ACCESS
{ 0x8016, 0x086C, 0xffff,0xffff}, 	// MON_ADDRESS_LO
{ 0x8018, 0xFF80, 0xffff,0xffff}, 	// MON_ADDRESS_HI
{ 0x8002, 0x0001, 0xffff,0xffff}, 	// MON_CMD
//delay = 100
SensorWaitMs(100),
//[Lens Correction 90% 02/04/13 18:03:18]                           
//BITFIELD= 0x3210, 0x0008, 0 //PGA_ENABLE                          
{ 0x3210, 0x0008, 0xffff,0xffff},                                   
{ 0x3210, 0x49B0, 0xffff,0xffff},  	// COLOR_PIPELINE_CONTROL         
{ 0x3640, 0x0170, 0xffff,0xffff},  	// P_G1_P0Q0                      
{ 0x3642, 0x0BCC, 0xffff,0xffff},  	// P_G1_P0Q1                      
{ 0x3644, 0x7210, 0xffff,0xffff},  	// P_G1_P0Q2                      
{ 0x3646, 0x4C8D, 0xffff,0xffff},  	// P_G1_P0Q3                      
{ 0x3648, 0xF58D, 0xffff,0xffff},  	// P_G1_P0Q4                      
{ 0x364A, 0x0610, 0xffff,0xffff},  	// P_R_P0Q0                       
{ 0x364C, 0x8D6E, 0xffff,0xffff},  	// P_R_P0Q1                       
{ 0x364E, 0x6E90, 0xffff,0xffff},  	// P_R_P0Q2                       
{ 0x3650, 0x088F, 0xffff,0xffff},  	// P_R_P0Q3                       
{ 0x3652, 0xA890, 0xffff,0xffff},  	// P_R_P0Q4                       
{ 0x3654, 0x0550, 0xffff,0xffff},  	// P_B_P0Q0                       
{ 0x3656, 0x764C, 0xffff,0xffff},  	// P_B_P0Q1                       
{ 0x3658, 0x0FB0, 0xffff,0xffff},  	// P_B_P0Q2                       
{ 0x365A, 0x9A0D, 0xffff,0xffff},  	// P_B_P0Q3                       
{ 0x365C, 0xF4AD, 0xffff,0xffff},  	// P_B_P0Q4                       
{ 0x365E, 0x02F0, 0xffff,0xffff},  	// P_G2_P0Q0                      
{ 0x3660, 0x9A0E, 0xffff,0xffff},  	// P_G2_P0Q1                      
{ 0x3662, 0x77B0, 0xffff,0xffff},  	// P_G2_P0Q2                      
{ 0x3664, 0x416D, 0xffff,0xffff},  	// P_G2_P0Q3                      
{ 0x3666, 0xF24D, 0xffff,0xffff},  	// P_G2_P0Q4                      
{ 0x3680, 0x018A, 0xffff,0xffff},  	// P_G1_P1Q0                      
{ 0x3682, 0xD0AD, 0xffff,0xffff},  	// P_G1_P1Q1                      
{ 0x3684, 0xC62E, 0xffff,0xffff},  	// P_G1_P1Q2                      
{ 0x3686, 0x736D, 0xffff,0xffff},  	// P_G1_P1Q3                      
{ 0x3688, 0x0130, 0xffff,0xffff},  	// P_G1_P1Q4                      
{ 0x368A, 0x52ED, 0xffff,0xffff},  	// P_R_P1Q0                       
{ 0x368C, 0x682D, 0xffff,0xffff},  	// P_R_P1Q1                       
{ 0x368E, 0xF02B, 0xffff,0xffff},  	// P_R_P1Q2                       
{ 0x3690, 0xB68E, 0xffff,0xffff},  	// P_R_P1Q3                       
{ 0x3692, 0xF4AD, 0xffff,0xffff},  	// P_R_P1Q4                       
{ 0x3694, 0xC68D, 0xffff,0xffff},  	// P_B_P1Q0                       
{ 0x3696, 0x440D, 0xffff,0xffff},  	// P_B_P1Q1                       
{ 0x3698, 0x416E, 0xffff,0xffff},  	// P_B_P1Q2                       
{ 0x369A, 0xC0CE, 0xffff,0xffff},  	// P_B_P1Q3                       
{ 0x369C, 0xB46D, 0xffff,0xffff},  	// P_B_P1Q4                       
{ 0x369E, 0xD90A, 0xffff,0xffff},  	// P_G2_P1Q0                      
{ 0x36A0, 0xD76D, 0xffff,0xffff},  	// P_G2_P1Q1                      
{ 0x36A2, 0xFE0D, 0xffff,0xffff},  	// P_G2_P1Q2                      
{ 0x36A4, 0x0E0D, 0xffff,0xffff},  	// P_G2_P1Q3                      
{ 0x36A6, 0x0890, 0xffff,0xffff},  	// P_G2_P1Q4                      
{ 0x36C0, 0x70D0, 0xffff,0xffff},  	// P_G1_P2Q0                      
{ 0x36C2, 0x10CF, 0xffff,0xffff},  	// P_G1_P2Q1                      
{ 0x36C4, 0x4592, 0xffff,0xffff},  	// P_G1_P2Q2                      
{ 0x36C6, 0xB74D, 0xffff,0xffff},  	// P_G1_P2Q3                      
{ 0x36C8, 0xEEB3, 0xffff,0xffff},  	// P_G1_P2Q4                      
{ 0x36CA, 0x1991, 0xffff,0xffff},  	// P_R_P2Q0                       
{ 0x36CC, 0x9B8E, 0xffff,0xffff},  	// P_R_P2Q1                       
{ 0x36CE, 0x5DCD, 0xffff,0xffff},  	// P_R_P2Q2                       
{ 0x36D0, 0x1C8D, 0xffff,0xffff},  	// P_R_P2Q3                       
{ 0x36D2, 0x8C71, 0xffff,0xffff},  	// P_R_P2Q4                       
{ 0x36D4, 0x00F1, 0xffff,0xffff},  	// P_B_P2Q0                       
{ 0x36D6, 0x480F, 0xffff,0xffff},  	// P_B_P2Q1                       
{ 0x36D8, 0x26AF, 0xffff,0xffff},  	// P_B_P2Q2                       
{ 0x36DA, 0xC2EF, 0xffff,0xffff},  	// P_B_P2Q3                       
{ 0x36DC, 0xFC8F, 0xffff,0xffff},  	// P_B_P2Q4                       
{ 0x36DE, 0x0071, 0xffff,0xffff},  	// P_G2_P2Q0                      
{ 0x36E0, 0x8230, 0xffff,0xffff},  	// P_G2_P2Q1                      
{ 0x36E2, 0x60B2, 0xffff,0xffff},  	// P_G2_P2Q2                      
{ 0x36E4, 0x3E51, 0xffff,0xffff},  	// P_G2_P2Q3                      
{ 0x36E6, 0x8C74, 0xffff,0xffff},  	// P_G2_P2Q4                      
{ 0x3700, 0x492E, 0xffff,0xffff},  	// P_G1_P3Q0                      
{ 0x3702, 0x7FAD, 0xffff,0xffff},  	// P_G1_P3Q1                      
{ 0x3704, 0x93CE, 0xffff,0xffff},  	// P_G1_P3Q2                      
{ 0x3706, 0xC86F, 0xffff,0xffff},  	// P_G1_P3Q3                      
{ 0x3708, 0xC830, 0xffff,0xffff},  	// P_G1_P3Q4                      
{ 0x370A, 0x610E, 0xffff,0xffff},  	// P_R_P3Q0                       
{ 0x370C, 0x8EC8, 0xffff,0xffff},  	// P_R_P3Q1                       
{ 0x370E, 0xA930, 0xffff,0xffff},  	// P_R_P3Q2                       
{ 0x3710, 0xE88D, 0xffff,0xffff},  	// P_R_P3Q3                       
{ 0x3712, 0x2B51, 0xffff,0xffff},  	// P_R_P3Q4                       
{ 0x3714, 0xDECD, 0xffff,0xffff},  	// P_B_P3Q0                       
{ 0x3716, 0xBD8E, 0xffff,0xffff},  	// P_B_P3Q1                       
{ 0x3718, 0x2E50, 0xffff,0xffff},  	// P_B_P3Q2                       
{ 0x371A, 0x60AF, 0xffff,0xffff},  	// P_B_P3Q3                       
{ 0x371C, 0xBB11, 0xffff,0xffff},  	// P_B_P3Q4                       
{ 0x371E, 0x22CB, 0xffff,0xffff},  	// P_G2_P3Q0                      
{ 0x3720, 0xEEEC, 0xffff,0xffff},  	// P_G2_P3Q1                      
{ 0x3722, 0x0251, 0xffff,0xffff},  	// P_G2_P3Q2                      
{ 0x3724, 0x142D, 0xffff,0xffff},  	// P_G2_P3Q3                      
{ 0x3726, 0xE271, 0xffff,0xffff},  	// P_G2_P3Q4                      
{ 0x3740, 0x1D10, 0xffff,0xffff},  	// P_G1_P4Q0                      
{ 0x3742, 0xE94F, 0xffff,0xffff},  	// P_G1_P4Q1                      
{ 0x3744, 0x8735, 0xffff,0xffff},  	// P_G1_P4Q2                      
{ 0x3746, 0xC2CC, 0xffff,0xffff},  	// P_G1_P4Q3                      
{ 0x3748, 0x23F6, 0xffff,0xffff},  	// P_G1_P4Q4                      
{ 0x374A, 0xE90F, 0xffff,0xffff},  	// P_R_P4Q0                       
{ 0x374C, 0x1A30, 0xffff,0xffff},  	// P_R_P4Q1                       
{ 0x374E, 0xAEF3, 0xffff,0xffff},  	// P_R_P4Q2                       
{ 0x3750, 0xB2F2, 0xffff,0xffff},  	// P_R_P4Q3                       
{ 0x3752, 0x2195, 0xffff,0xffff},  	// P_R_P4Q4                       
{ 0x3754, 0xFFEE, 0xffff,0xffff},  	// P_B_P4Q0                       
{ 0x3756, 0xD8D0, 0xffff,0xffff},  	// P_B_P4Q1                       
{ 0x3758, 0xCC92, 0xffff,0xffff},  	// P_B_P4Q2                       
{ 0x375A, 0x0451, 0xffff,0xffff},  	// P_B_P4Q3                       
{ 0x375C, 0x5814, 0xffff,0xffff},  	// P_B_P4Q4                       
{ 0x375E, 0x2470, 0xffff,0xffff},  	// P_G2_P4Q0                      
{ 0x3760, 0x6151, 0xffff,0xffff},  	// P_G2_P4Q1                      
{ 0x3762, 0x9555, 0xffff,0xffff},  	// P_G2_P4Q2                      
{ 0x3764, 0xD5D3, 0xffff,0xffff},  	// P_G2_P4Q3                      
{ 0x3766, 0x3B56, 0xffff,0xffff},  	// P_G2_P4Q4                      
{ 0x3782, 0x03DC, 0xffff,0xffff},  	// CENTER_ROW                     
{ 0x3784, 0x04E0, 0xffff,0xffff},  	// CENTER_COLUMN                  
{ 0x3210, 0x49B8, 0xffff,0xffff},  	// COLOR_PIPELINE_CONTROL         
//BITFIELD= 0x3210, 0x0008, 1 //PGA_ENABLE                          
//{ 0x3210, 0x0008, 0xffff,0xffff},                 



//[*********Step6************] 
//[Step6-AWB_CCM]              
//[AWB_setup]                  

{ 0xAC01, 0xBB, 0xffff,0xff}, 	// AWB_MODE   
//[CCM]
{ 0xAC46, 0x0221, 0xffff,0xffff}, 	// AWB_LEFT_CCM_0
{ 0xAC48, 0xFEAE, 0xffff,0xffff}, 	// AWB_LEFT_CCM_1
{ 0xAC4A, 0x0032, 0xffff,0xffff}, 	// AWB_LEFT_CCM_2
{ 0xAC4C, 0xFFC5, 0xffff,0xffff}, 	// AWB_LEFT_CCM_3
{ 0xAC4E, 0x0154, 0xffff,0xffff}, 	// AWB_LEFT_CCM_4
{ 0xAC50, 0xFFE7, 0xffff,0xffff}, 	// AWB_LEFT_CCM_5
{ 0xAC52, 0xFFB1, 0xffff,0xffff}, 	// AWB_LEFT_CCM_6
{ 0xAC54, 0xFEC5, 0xffff,0xffff}, 	// AWB_LEFT_CCM_7
{ 0xAC56, 0x028A, 0xffff,0xffff}, 	// AWB_LEFT_CCM_8
{ 0xAC58, 0x00C6, 0xffff,0xffff}, 	// AWB_LEFT_CCM_R2BRATIO
{ 0xAC5C, 0x01CD, 0xffff,0xffff}, 	// AWB_RIGHT_CCM_0
{ 0xAC5E, 0xFF63, 0xffff,0xffff}, 	// AWB_RIGHT_CCM_1
{ 0xAC60, 0xFFD0, 0xffff,0xffff}, 	// AWB_RIGHT_CCM_2
{ 0xAC62, 0xFFCD, 0xffff,0xffff}, 	// AWB_RIGHT_CCM_3
{ 0xAC64, 0x013B, 0xffff,0xffff}, 	// AWB_RIGHT_CCM_4
{ 0xAC66, 0xFFF8, 0xffff,0xffff}, 	// AWB_RIGHT_CCM_5
{ 0xAC68, 0xFFFB, 0xffff,0xffff}, 	// AWB_RIGHT_CCM_6
{ 0xAC6A, 0xFF78, 0xffff,0xffff}, 	// AWB_RIGHT_CCM_7
{ 0xAC6C, 0x018D, 0xffff,0xffff}, 	// AWB_RIGHT_CCM_8
{ 0xAC6E, 0x0055, 0xffff,0xffff}, 	// AWB_RIGHT_CCM_R2BRATIO

//[AWB]
{ 0xB842, 0x0037, 0xffff,0xffff}, 	// STAT_AWB_GRAY_CHECKER_OFFSET_X
{ 0xB844, 0x0044, 0xffff,0xffff}, 	// STAT_AWB_GRAY_CHECKER_OFFSET_Y
{ 0x3240, 0x0024, 0xffff,0xffff}, 	// AWB_XY_SCALE
{ 0x3240, 0x0024, 0xffff,0xffff}, 	// AWB_XY_SCALE
{ 0x3242, 0x0000, 0xffff,0xffff}, 	// AWB_WEIGHT_R0
{ 0x3244, 0x0000, 0xffff,0xffff}, 	// AWB_WEIGHT_R1
{ 0x3246, 0x0000, 0xffff,0xffff}, 	// AWB_WEIGHT_R2
{ 0x3248, 0x7F00, 0xffff,0xffff}, 	// AWB_WEIGHT_R3
{ 0x324A, 0xA500, 0xffff,0xffff}, 	// AWB_WEIGHT_R4
{ 0x324C, 0x1540, 0xffff,0xffff}, 	// AWB_WEIGHT_R5
{ 0x324E, 0x01AC, 0xffff,0xffff}, 	// AWB_WEIGHT_R6
{ 0x3250, 0x003E, 0xffff,0xffff}, 	// AWB_WEIGHT_R7

//[Preawb_params]
{ 0xACB0, 0x32, 0xffff,0xff}, 	// AWB_RG_MIN
{ 0xACB1, 0x5A, 0xffff,0xff}, 	// AWB_RG_MAX
{ 0xACB2, 0x32, 0xffff,0xff}, 	// AWB_RG_MIN_BRIGHT
{ 0xACB3, 0x5A, 0xffff,0xff}, 	// AWB_RG_MAX_BRIGHT
{ 0xACB4, 0x23, 0xffff,0xff}, 	// AWB_BG_MIN
{ 0xACB5, 0x55, 0xffff,0xff}, 	// AWB_BG_MAX
{ 0xACB6, 0x49, 0xffff,0xff}, 	// AWB_BG_MIN_BRIGHT
{ 0xACB7, 0x55, 0xffff,0xff}, 	// AWB_BG_MAX_BRIGHT 

//[**********Step7*************] 
//[Step7-CPIPE_Calibration]      
                                 
//[jpeg_setup]                   

{ 0xD80F, 0x04, 0xffff,0xff}, 	// JPEG_QSCALE_0
{ 0xD810, 0x08, 0xffff,0xff}, 	// JPEG_QSCALE_1
{ 0xC8D2, 0x04, 0xffff,0xff}, 	// CAM_OUTPUT_1_JPEG_QSCALE_0
{ 0xC8D3, 0x08, 0xffff,0xff}, 	// CAM_OUTPUT_1_JPEG_QSCALE_1
{ 0xC8BC, 0x04, 0xffff,0xff}, 	// CAM_OUTPUT_0_JPEG_QSCALE_0
{ 0xC8BD, 0x08, 0xffff,0xff}, 	// CAM_OUTPUT_0_JPEG_QSCALE_1

//[Sys_Settings]
{ 0xDC35, 0x04, 0xffff,0xff}, 	// SYS_UV_COLOR_BOOST
{ 0x326E, 0x0006, 0xffff,0xffff}, 	// RESERVED_SOC1_326E
{ 0xDC37, 0x62, 0xffff,0xff}, 	// SYS_BRIGHT_COLORKILL
{ 0x35A4, 0x0596, 0xffff,0xffff}, 	// BRIGHT_COLOR_KILL_CONTROLS
{ 0x35A2, 0x0094, 0xffff,0xffff}, 	// DARK_COLOR_KILL_CONTROLS
{ 0xDC36, 0x23, 0xffff,0xff}, 	// SYS_DARK_COLOR_KILL

//[Gamma_Curves_REV3]
{ 0xBC18, 0x00, 0xffff,0xff}, 	// LL_GAMMA_CONTRAST_CURVE_0
{ 0xBC19, 0x11, 0xffff,0xff}, 	// LL_GAMMA_CONTRAST_CURVE_1
{ 0xBC1A, 0x23, 0xffff,0xff}, 	// LL_GAMMA_CONTRAST_CURVE_2
{ 0xBC1B, 0x3F, 0xffff,0xff}, 	// LL_GAMMA_CONTRAST_CURVE_3
{ 0xBC1C, 0x67, 0xffff,0xff}, 	// LL_GAMMA_CONTRAST_CURVE_4
{ 0xBC1D, 0x85, 0xffff,0xff}, 	// LL_GAMMA_CONTRAST_CURVE_5
{ 0xBC1E, 0x9B, 0xffff,0xff}, 	// LL_GAMMA_CONTRAST_CURVE_6
{ 0xBC1F, 0xAD, 0xffff,0xff}, 	// LL_GAMMA_CONTRAST_CURVE_7
{ 0xBC20, 0xBB, 0xffff,0xff}, 	// LL_GAMMA_CONTRAST_CURVE_8
{ 0xBC21, 0xC7, 0xffff,0xff}, 	// LL_GAMMA_CONTRAST_CURVE_9
{ 0xBC22, 0xD1, 0xffff,0xff}, 	// LL_GAMMA_CONTRAST_CURVE_10
{ 0xBC23, 0xDA, 0xffff,0xff}, 	// LL_GAMMA_CONTRAST_CURVE_11
{ 0xBC24, 0xE1, 0xffff,0xff}, 	// LL_GAMMA_CONTRAST_CURVE_12
{ 0xBC25, 0xE8, 0xffff,0xff}, 	// LL_GAMMA_CONTRAST_CURVE_13
{ 0xBC26, 0xEE, 0xffff,0xff}, 	// LL_GAMMA_CONTRAST_CURVE_14
{ 0xBC27, 0xF3, 0xffff,0xff}, 	// LL_GAMMA_CONTRAST_CURVE_15
{ 0xBC28, 0xF7, 0xffff,0xff}, 	// LL_GAMMA_CONTRAST_CURVE_16
{ 0xBC29, 0xFB, 0xffff,0xff}, 	// LL_GAMMA_CONTRAST_CURVE_17
{ 0xBC2A, 0xFF, 0xffff,0xff}, 	// LL_GAMMA_CONTRAST_CURVE_18
{ 0xBC2B, 0x00, 0xffff,0xff}, 	// LL_GAMMA_NEUTRAL_CURVE_0
{ 0xBC2C, 0x11, 0xffff,0xff}, 	// LL_GAMMA_NEUTRAL_CURVE_1
{ 0xBC2D, 0x23, 0xffff,0xff}, 	// LL_GAMMA_NEUTRAL_CURVE_2
{ 0xBC2E, 0x3F, 0xffff,0xff}, 	// LL_GAMMA_NEUTRAL_CURVE_3
{ 0xBC2F, 0x67, 0xffff,0xff}, 	// LL_GAMMA_NEUTRAL_CURVE_4
{ 0xBC30, 0x85, 0xffff,0xff}, 	// LL_GAMMA_NEUTRAL_CURVE_5
{ 0xBC31, 0x9B, 0xffff,0xff}, 	// LL_GAMMA_NEUTRAL_CURVE_6
{ 0xBC32, 0xAD, 0xffff,0xff}, 	// LL_GAMMA_NEUTRAL_CURVE_7
{ 0xBC33, 0xBB, 0xffff,0xff}, 	// LL_GAMMA_NEUTRAL_CURVE_8
{ 0xBC34, 0xC7, 0xffff,0xff}, 	// LL_GAMMA_NEUTRAL_CURVE_9
{ 0xBC35, 0xD1, 0xffff,0xff}, 	// LL_GAMMA_NEUTRAL_CURVE_10
{ 0xBC36, 0xDA, 0xffff,0xff}, 	// LL_GAMMA_NEUTRAL_CURVE_11
{ 0xBC37, 0xE1, 0xffff,0xff}, 	// LL_GAMMA_NEUTRAL_CURVE_12
{ 0xBC38, 0xE8, 0xffff,0xff}, 	// LL_GAMMA_NEUTRAL_CURVE_13
{ 0xBC39, 0xEE, 0xffff,0xff}, 	// LL_GAMMA_NEUTRAL_CURVE_14
{ 0xBC3A, 0xF3, 0xffff,0xff}, 	// LL_GAMMA_NEUTRAL_CURVE_15
{ 0xBC3B, 0xF7, 0xffff,0xff}, 	// LL_GAMMA_NEUTRAL_CURVE_16
{ 0xBC3C, 0xFB, 0xffff,0xff}, 	// LL_GAMMA_NEUTRAL_CURVE_17
{ 0xBC3D, 0xFF, 0xffff,0xff}, 	// LL_GAMMA_NEUTRAL_CURVE_18
{ 0xBC3E, 0x00, 0xffff,0xff}, 	// LL_GAMMA_NR_CURVE_0
{ 0xBC3F, 0x05, 0xffff,0xff}, 	// LL_GAMMA_NR_CURVE_1
{ 0xBC40, 0x0F, 0xffff,0xff}, 	// LL_GAMMA_NR_CURVE_2
{ 0xBC41, 0x21, 0xffff,0xff}, 	// LL_GAMMA_NR_CURVE_3
{ 0xBC42, 0x3C, 0xffff,0xff}, 	// LL_GAMMA_NR_CURVE_4
{ 0xBC43, 0x52, 0xffff,0xff}, 	// LL_GAMMA_NR_CURVE_5
{ 0xBC44, 0x67, 0xffff,0xff}, 	// LL_GAMMA_NR_CURVE_6
{ 0xBC45, 0x7B, 0xffff,0xff}, 	// LL_GAMMA_NR_CURVE_7
{ 0xBC46, 0x8D, 0xffff,0xff}, 	// LL_GAMMA_NR_CURVE_8
{ 0xBC47, 0x9E, 0xffff,0xff}, 	// LL_GAMMA_NR_CURVE_9
{ 0xBC48, 0xAD, 0xffff,0xff}, 	// LL_GAMMA_NR_CURVE_10
{ 0xBC49, 0xBA, 0xffff,0xff}, 	// LL_GAMMA_NR_CURVE_11
{ 0xBC4A, 0xC6, 0xffff,0xff}, 	// LL_GAMMA_NR_CURVE_12
{ 0xBC4B, 0xD1, 0xffff,0xff}, 	// LL_GAMMA_NR_CURVE_13
{ 0xBC4C, 0xDC, 0xffff,0xff}, 	// LL_GAMMA_NR_CURVE_14
{ 0xBC4D, 0xE5, 0xffff,0xff}, 	// LL_GAMMA_NR_CURVE_15
{ 0xBC4E, 0xEE, 0xffff,0xff}, 	// LL_GAMMA_NR_CURVE_16
{ 0xBC4F, 0xF7, 0xffff,0xff}, 	// LL_GAMMA_NR_CURVE_17
{ 0xBC50, 0xFF, 0xffff,0xff}, 	// LL_GAMMA_NR_CURVE_18

//[BM_Dampening]
{ 0xB801, 0xE0, 0xffff,0xff}, 	// STAT_MODE
{ 0xB862, 0x04, 0xffff,0xff}, 	// STAT_BMTRACKING_SPEED

//[AE]
{ 0xB829, 0x02, 0xffff,0xff}, 	// STAT_LL_BRIGHTNESS_METRIC_DIVISOR
{ 0xB863, 0x02, 0xffff,0xff}, 	// STAT_BM_MUL
{ 0xB827, 0x0F, 0xffff,0xff}, 	// STAT_AE_EV_SHIFT
{ 0xA409, 0x42, 0xffff,0xff}, 	// AE_RULE_BASE_TARGET

//[BM_GM_Start_Stop] 
{ 0xBC52, 0x00C8, 0xffff,0xffff}, 	// LL_START_BRIGHTNESS_METRIC
{ 0xBC54, 0x0A28, 0xffff,0xffff}, 	// LL_END_BRIGHTNESS_METRIC
{ 0xBC58, 0x00C8, 0xffff,0xffff}, 	// LL_START_GAIN_METRIC
{ 0xBC5A, 0x12C0, 0xffff,0xffff}, 	// LL_END_GAIN_METRIC
{ 0xBC5E, 0x00FA, 0xffff,0xffff}, 	// LL_START_APERTURE_GAIN_BM
{ 0xBC60, 0x0258, 0xffff,0xffff}, 	// LL_END_APERTURE_GAIN_BM
{ 0xBC66, 0x00FA, 0xffff,0xffff}, 	// LL_START_APERTURE_GM
{ 0xBC68, 0x0258, 0xffff,0xffff}, 	// LL_END_APERTURE_GM
{ 0xBC86, 0x00C8, 0xffff,0xffff}, 	// LL_START_FFNR_GM
{ 0xBC88, 0x0640, 0xffff,0xffff}, 	// LL_END_FFNR_GM
{ 0xBCBC, 0x0040, 0xffff,0xffff}, 	// LL_SFFB_START_GAIN
{ 0xBCBE, 0x01FC, 0xffff,0xffff}, 	// LL_SFFB_END_GAIN
{ 0xBCCC, 0x00C8, 0xffff,0xffff}, 	// LL_SFFB_START_MAX_GM
{ 0xBCCE, 0x0640, 0xffff,0xffff}, 	// LL_SFFB_END_MAX_GM
{ 0xBC90, 0x00C8, 0xffff,0xffff}, 	// LL_START_GRB_GM
{ 0xBC92, 0x0640, 0xffff,0xffff}, 	// LL_END_GRB_GM
{ 0xBC0E, 0x0001, 0xffff,0xffff}, 	// LL_GAMMA_CURVE_ADJ_START_POS
{ 0xBC10, 0x0002, 0xffff,0xffff}, 	// LL_GAMMA_CURVE_ADJ_MID_POS
{ 0xBC12, 0x02BC, 0xffff,0xffff}, 	// LL_GAMMA_CURVE_ADJ_END_POS
{ 0xBCAA, 0x044C, 0xffff,0xffff}, 	// LL_CDC_THR_ADJ_START_POS
{ 0xBCAC, 0x00AF, 0xffff,0xffff}, 	// LL_CDC_THR_ADJ_MID_POS
{ 0xBCAE, 0x0009, 0xffff,0xffff}, 	// LL_CDC_THR_ADJ_END_POS
{ 0xBCD8, 0x00C8, 0xffff,0xffff}, 	// LL_PCR_START_BM
{ 0xBCDA, 0x0A28, 0xffff,0xffff}, 	// LL_PCR_END_BM

//[Kernel]
{ 0x3380, 0x0504, 0xffff,0xffff}, 	// KERNEL_CONFIG

//[GRB]
{ 0xBC94, 0x0C, 0xffff,0xff}, 	// LL_GB_START_THRESHOLD_0
{ 0xBC95, 0x08, 0xffff,0xff}, 	// LL_GB_START_THRESHOLD_1
{ 0xBC9C, 0x3C, 0xffff,0xff}, 	// RESERVED_LL_9C
{ 0xBC9D, 0x28, 0xffff,0xff}, 	// RESERVED_LL_9D

//[Demosaic_REV3]
{ 0x33B0, 0x2A16, 0xffff,0xffff}, 	// FFNR_ALPHA_BETA
{ 0xBC8A, 0x02, 0xffff,0xff}, 	// LL_START_FF_MIX_THRESH_Y
{ 0xBC8B, 0x0F, 0xffff,0xff}, 	// LL_END_FF_MIX_THRESH_Y
{ 0xBC8C, 0xFF, 0xffff,0xff}, 	// LL_START_FF_MIX_THRESH_YGAIN
{ 0xBC8D, 0xFF, 0xffff,0xff}, 	// LL_END_FF_MIX_THRESH_YGAIN
{ 0xBC8E, 0xFF, 0xffff,0xff}, 	// LL_START_FF_MIX_THRESH_GAIN
{ 0xBC8F, 0x00, 0xffff,0xff}, 	// LL_END_FF_MIX_THRESH_GAIN

//[CDC]
{ 0xBCB2, 0x20, 0xffff,0xff}, 	// LL_CDC_DARK_CLUS_SLOPE
{ 0xBCB3, 0x3A, 0xffff,0xff}, 	// LL_CDC_DARK_CLUS_SATUR
{ 0xBCB4, 0x39, 0xffff,0xff}, 	// RESERVED_LL_B4
{ 0xBCB7, 0x39, 0xffff,0xff}, 	// RESERVED_LL_B7
{ 0xBCB5, 0x20, 0xffff,0xff}, 	// RESERVED_LL_B5
{ 0xBCB8, 0x3A, 0xffff,0xff}, 	// RESERVED_LL_B8
{ 0xBCB6, 0x80, 0xffff,0xff}, 	// RESERVED_LL_B6
{ 0xBCB9, 0x24, 0xffff,0xff}, 	// RESERVED_LL_B9
{ 0xBCAA, 0x03E8, 0xffff,0xffff}, 	// LL_CDC_THR_ADJ_START_POS
{ 0xBCAC, 0x012C, 0xffff,0xffff}, 	// LL_CDC_THR_ADJ_MID_POS
{ 0xBCAE, 0x0009, 0xffff,0xffff}, 	// LL_CDC_THR_ADJ_END_POS

//[Aperture_calib]
{ 0x33BA, 0x0084, 0xffff,0xffff}, 	// APEDGE_CONTROL
{ 0x33BE, 0x0000, 0xffff,0xffff}, 	// UA_KNEE_L
{ 0x33C2, 0x8800, 0xffff,0xffff}, 	// UA_WEIGHTS
{ 0xBC5E, 0x0154, 0xffff,0xffff}, 	// LL_START_APERTURE_GAIN_BM
{ 0xBC60, 0x0640, 0xffff,0xffff}, 	// LL_END_APERTURE_GAIN_BM
{ 0xBC62, 0x0E, 0xffff,0xff}, 	// LL_START_APERTURE_KPGAIN
{ 0xBC63, 0x14, 0xffff,0xff}, 	// LL_END_APERTURE_KPGAIN
{ 0xBC64, 0x0E, 0xffff,0xff}, 	// LL_START_APERTURE_KNGAIN
{ 0xBC65, 0x14, 0xffff,0xff}, 	// LL_END_APERTURE_KNGAIN
{ 0xBCE2, 0x0A, 0xffff,0xff}, 	// LL_START_POS_KNEE
{ 0xBCE3, 0x2B, 0xffff,0xff}, 	// LL_END_POS_KNEE
{ 0xBCE4, 0x0A, 0xffff,0xff}, 	// LL_START_NEG_KNEE
{ 0xBCE5, 0x2B, 0xffff,0xff}, 	// LL_END_NEG_KNEE
{ 0x3210, 0x49B8, 0xffff,0xffff}, 	// COLOR_PIPELINE_CONTROL

//[SFFB_REV3_noisemodel]
{ 0xBCC0, 0x1F, 0xffff,0xff}, 	// LL_SFFB_RAMP_START
{ 0xBCC1, 0x03, 0xffff,0xff}, 	// LL_SFFB_RAMP_STOP
{ 0xBCC2, 0x2C, 0xffff,0xff}, 	// LL_SFFB_SLOPE_START
{ 0xBCC3, 0x10, 0xffff,0xff}, 	// LL_SFFB_SLOPE_STOP
{ 0xBCC4, 0x07, 0xffff,0xff}, 	// LL_SFFB_THSTART
{ 0xBCC5, 0x0B, 0xffff,0xff}, 	// LL_SFFB_THSTOP
{ 0xBCBA, 0x0009, 0xffff,0xffff}, 	// LL_SFFB_CONFIG

//[**********Step8*************]  
//[FTB_Off]                       
{ 0xBC14, 0xFFFE, 0xffff,0xffff}, 	// LL_GAMMA_FADE_TO_BLACK_START_POS
{ 0xBC16, 0xFFFE, 0xffff,0xffff}, 	// LL_GAMMA_FADE_TO_BLACK_END_POS

//[Aperture_preference]
{ 0xBC66, 0x0154, 0xffff,0xffff}, 	// LL_START_APERTURE_GM
{ 0xBC68, 0x07D0, 0xffff,0xffff}, 	// LL_END_APERTURE_GM
{ 0xBC6A, 0x04, 0xffff,0xff}, 	// LL_START_APERTURE_INTEGER_GAIN
{ 0xBC6B, 0x00, 0xffff,0xff}, 	// LL_END_APERTURE_INTEGER_GAIN
{ 0xBC6C, 0x00, 0xffff,0xff}, 	// LL_START_APERTURE_EXP_GAIN
{ 0xBC6D, 0x00, 0xffff,0xff}, 	// LL_END_APERTURE_EXP_GAIN

//[Gain_max]
{ 0xA81C, 0x0040, 0xffff,0xffff}, 	// AE_TRACK_MIN_AGAIN
{ 0xA820, 0x012C, 0xffff,0xffff}, 	// AE_TRACK_MAX_AGAIN
{ 0xA822, 0x0060, 0xffff,0xffff}, 	// AE_TRACK_MIN_DGAIN
{ 0xA824, 0x00E5, 0xffff,0xffff}, 	// AE_TRACK_MAX_DGAIN

//[Saturation_REV3]
{ 0xBC56, 0x64, 0xffff,0xff}, 	// LL_START_CCM_SATURATION
{ 0xBC57, 0x1E, 0xffff,0xff}, 	// LL_END_CCM_SATURATION

//[DCCM_REV3]
{ 0xBCDE, 0x03, 0xffff,0xff}, 	// LL_START_SYS_THRESHOLD
{ 0xBCDF, 0x50, 0xffff,0xff}, 	// LL_STOP_SYS_THRESHOLD
{ 0xBCE0, 0x08, 0xffff,0xff}, 	// LL_START_SYS_GAIN
{ 0xBCE1, 0x03, 0xffff,0xff}, 	// LL_STOP_SYS_GAIN

//[Sobel_REV3]
{ 0xBCD0, 0x000A, 0xffff,0xffff}, 	// LL_SFFB_SOBEL_FLAT_START
{ 0xBCD2, 0x00FE, 0xffff,0xffff}, 	// LL_SFFB_SOBEL_FLAT_STOP
{ 0xBCD4, 0x001E, 0xffff,0xffff}, 	// LL_SFFB_SOBEL_SHARP_START
{ 0xBCD6, 0x00FF, 0xffff,0xffff}, 	// LL_SFFB_SOBEL_SHARP_STOP
{ 0xBCC6, 0x00, 0xffff,0xff}, 	// LL_SFFB_SHARPENING_START
{ 0xBCC7, 0x00, 0xffff,0xff}, 	// LL_SFFB_SHARPENING_STOP
{ 0xBCC8, 0x20, 0xffff,0xff}, 	// LL_SFFB_FLATNESS_START
{ 0xBCC9, 0x40, 0xffff,0xff}, 	// LL_SFFB_FLATNESS_STOP
{ 0xBCCA, 0x04, 0xffff,0xff}, 	// LL_SFFB_TRANSITION_START
{ 0xBCCB, 0x00, 0xffff,0xff}, 	// LL_SFFB_TRANSITION_STOP

//[SFFB_slope_zero_enable]
{ 0xBCE6, 0x03, 0xffff,0xff}, 	// LL_SFFB_ZERO_ENABLE
{ 0xBCE6, 0x03, 0xffff,0xff}, 	// LL_SFFB_ZERO_ENABLE


//[AE_preference]
{ 0xA410, 0x04, 0xffff,0xff}, 	// AE_RULE_TARGET_AE_6
{ 0xA411, 0x06, 0xffff,0xff}, 	// AE_RULE_TARGET_AE_7


//[**********Step9*************]         
//[JPEG Quantization]                    
//[Sepia effect]                                        
{ 0xDC3A, 0x23, 0xffff,0xff}, 	// SYS_SEPIA_CR
{ 0xDC3B, 0xB2, 0xffff,0xff}, 	// SYS_SEPIA_CB


//[Touch Focus + Fast Focus AF_AFM_INIT]
{ 0x8411, 0x00, 0xffff,0xff}, 	// SEQ_STATE_CFG_0_AF
{ 0x8419, 0x04, 0xffff,0xff}, 	// SEQ_STATE_CFG_1_AF

{ 0xB002, 0x0002, 0xffff,0xffff}, 	// AF_MODE
{ 0xC40A, 0x0030, 0xffff,0xffff}, 	// AFM_POS_MIN
{ 0xC40C, 0x00A0, 0xffff,0xffff}, 	// AFM_POS_MAX
{ 0xB045, 0x000C, 0xffff,0xffff}, 	// AF_MODE_EX


//AF Window size
{ 0xB854, 0x60, 0xffff,0xff}, 	// STAT_SM_WINDOW_POS_X
{ 0xB855, 0x60, 0xffff,0xff}, 	// STAT_SM_WINDOW_POS_Y
{ 0xB856, 0x40, 0xffff,0xff}, 	// STAT_SM_WINDOW_SIZE_X
{ 0xB857, 0x40, 0xffff,0xff}, 	// STAT_SM_WINDOW_SIZE_Y
{ 0xB012, 0x0A, 0xffff,0xff}, 	// AF_FS_NUM_STEPS
{ 0xB018, 0x00, 0xffff,0xff}, 	// AF_FS_POS_0
{ 0xB019, 0x30, 0xffff,0xff}, 	// AF_FS_POS_1
{ 0xB01A, 0x48, 0xffff,0xff}, 	// AF_FS_POS_2
{ 0xB01B, 0x60, 0xffff,0xff}, 	// AF_FS_POS_3
{ 0xB01C, 0x78, 0xffff,0xff}, 	// AF_FS_POS_4
{ 0xB01D, 0x90, 0xffff,0xff}, 	// AF_FS_POS_5
{ 0xB01E, 0xA8, 0xffff,0xff}, 	// AF_FS_POS_6
{ 0xB01F, 0xC0, 0xffff,0xff}, 	// AF_FS_POS_7
{ 0xB020, 0xE0, 0xffff,0xff}, 	// AF_FS_POS_8
{ 0xB021, 0xFF, 0xffff,0xff}, 	// AF_FS_POS_9
{ 0xB022, 0x00, 0xffff,0xff}, 	// AF_FS_POS_10
{ 0xB011, 0x00, 0xffff,0xff}, 	// AF_FS_INIT_POS  

//INIT PATCH PAGE used in FF 
{ 0x098E, 0xD40E, 0xffff,0xffff}, 	// LOGICAL_ADDRESS_ACCESS
{ 0xD40E, 0x0000, 0xffff,0xffff},
{ 0xD40F, 0x0000, 0xffff,0xffff},
{ 0xD410, 0x0000, 0xffff,0xffff},
{ 0xD411, 0x0000, 0xffff,0xffff},
{ 0xD412, 0x0000, 0xffff,0xffff},
{ 0xD413, 0x0000, 0xffff,0xffff},
{ 0xD414, 0x0000, 0xffff,0xffff},
{ 0xD415, 0x0000, 0xffff,0xffff},
{ 0xD416, 0x0000, 0xffff,0xffff},
{ 0xD417, 0x0000, 0xffff,0xffff},
{ 0xD418, 0x0000, 0xffff,0xffff},
{ 0xD418, 0x0000, 0xffff,0xffff},
{ 0xD419, 0x0000, 0xffff,0xffff},
{ 0xD41A, 0x0000, 0xffff,0xffff},
{ 0xD41B, 0x0000, 0xffff,0xffff},
{ 0xD41C, 0x0000, 0xffff,0xffff},
{ 0xD41D, 0x0000, 0xffff,0xffff},
{ 0xD41E, 0x0000, 0xffff,0xffff},
{ 0xD420, 0x0000, 0xffff,0xffff},
{ 0xD406, 0x0000, 0xffff,0xffff},
{ 0xD407, 0x0000, 0xffff,0xffff},
{ 0xD422, 0x0000, 0xffff,0xffff},
{ 0xD423, 0x0000, 0xffff,0xffff},
{ 0xD424, 0x0000, 0xffff,0xffff},
{ 0xD425, 0x0000, 0xffff,0xffff},
{ 0xD426, 0x0000, 0xffff,0xffff},
{ 0xD427, 0x0000, 0xffff,0xffff},
{ 0xD428, 0x0000, 0xffff,0xffff},
{ 0xD429, 0x0000, 0xffff,0xffff},
{ 0xD42A, 0x0000, 0xffff,0xffff},
{ 0xD42B, 0x0000, 0xffff,0xffff},
{ 0xD400, 0x0001, 0xffff,0xffff},
{ 0xD401, 0x0000, 0xffff,0xffff},
{ 0xD402, 0x0028, 0xffff,0xffff},
{ 0xD403, 0x0080, 0xffff,0xffff},
{ 0xD404, 0x0000, 0xffff,0xffff},
{ 0xD405, 0x0000, 0xffff,0xffff},
{ 0xD406, 0x0000, 0xffff,0xffff},
{ 0xD407, 0x0000, 0xffff,0xffff},
{ 0xD408, 0x0030, 0xffff,0xffff},
{ 0xD409, 0x0040, 0xffff,0xffff},
{ 0xD40A, 0x0050, 0xffff,0xffff},
{ 0xD40B, 0x0070, 0xffff,0xffff},
{ 0xD40C, 0x0080, 0xffff,0xffff},
{ 0xD40D, 0x0090, 0xffff,0xffff},

{ 0x0018, 0x2008, 0xffff,0xffff}, 	// STANDBY_CONTROL_AND_STATUS

SensorWaitMs(100),
SensorEnd

                                                                                                                                                                             

};
/* Senor full resolution setting: recommand for capture */
static struct rk_sensor_reg sensor_fullres_lowfps_data[] ={
     //capture2preview
	{0x098E, 0x843C, 0xffff, 0xffff}, 	// LOGICAL_ADDRESS_ACCESS [SEQ_STATE_CFG_5_MAX_FRAME_CNT]
	{0x843C, 0xFF, 0xffff, 0xff}, 	// SEQ_STATE_CFG_5_MAX_FRAME_CNT
	{0x8404, 0x02, 0xffff, 0xff},	// SEQ_CMD
	SensorWaitMs(200),
	SensorEnd
};
/* Senor full resolution setting: recommand for video */
static struct rk_sensor_reg sensor_fullres_highfps_data[] ={
	SensorEnd
};
/* Preview resolution setting*/
static struct rk_sensor_reg sensor_preview_data[] =
{
    // Set resolution vga
    {0xC83A, 0x000C, 0xffff,0xffff},    // CAM_CORE_A_Y_ADDR_START
    {0xC83C, 0x0018, 0xffff,0xffff},    // CAM_CORE_A_X_ADDR_START
    {0xC83E, 0x07B1, 0xffff,0xffff },    // CAM_CORE_A_Y_ADDR_END
    {0xC840, 0x0A45, 0xffff,0xffff},    // CAM_CORE_A_X_ADDR_END
    {0xC868, 0x0423, 0xffff,0xffff},    // CAM_CORE_A_FRAME_LENGTH_LINES
    {0xC86A, 0x1194, 0xffff,0xffff},    // CAM_CORE_A_LINE_LENGTH_PCK
    {0xC86C, 0x0518, 0xffff,0xffff},    // CAM_CORE_A_OUTPUT_SIZE_WIDTH
    {0xC86E, 0x03D4, 0xffff,0xffff},    // CAM_CORE_A_OUTPUT_SIZE_HEIGHT
    {0xC870, 0x0014, 0xffff,0xffff},    // CAM_CORE_A_RX_FIFO_TRIGGER_MARK
    {0xC858, 0x0003, 0xffff,0xffff},    // CAM_CORE_A_COARSE_ITMIN
    {0xC8A4, 0x0A28, 0xffff,0xffff},    // CAM_CORE_B_OUTPUT_SIZE_WIDTH
    {0xC8A6, 0x07A0, 0xffff,0xffff },    // CAM_CORE_B_OUTPUT_SIZE_HEIGHT
    {0xC8AA, 0x0280, 0xffff,0xffff },    // CAM_OUTPUT_0_IMAGE_WIDTH
    {0xC8AC, 0x01E0, 0xffff,0xffff },    // CAM_OUTPUT_0_IMAGE_HEIGHT
    {0xC8AE, 0x0001, 0xffff,0xffff },    // CAM_OUTPUT_0_OUTPUT_FORMAT
    {0x8404, 0x06, 0xffff,0xff },        // SEQ_CMD
    SensorWaitMs(100),

	//snap2preview
	{0x098E, 0x843C,0xffff, 0xffff}, 	// LOGICAL_ADDRESS_ACCESS [SEQ_STATE_CFG_5_MAX_FRAME_CNT]
	{0x843C, 0x01, 0xffff, 0xff}, 	// SEQ_STATE_CFG_5_MAX_FRAME_CNT
	{0x8404, 0x01, 0xffff, 0xff},	// SEQ_CMD
	{0x0016, 0x0447,0xffff, 0xffff},	// CLOCKS_CONTRO    
	SensorEnd
};
/* 1280x720 */
static struct rk_sensor_reg sensor_720p[]={

	{0x098E, 0x843C, 0xffff,0xffff},  // LOGICAL_ADDRESS_ACCESS [CAM_CORE_A_Y_ADDR_START]
	{0x843C, 0x01, 0xffff,0xff },     // SEQ_STATE_CFG_5_MAX_FRAME_CNT
	{0x8404, 0x01, 0xffff,0xff },     // SEQ_CMD
	{0x0016, 0x0447, 0xffff,0xffff},  // CLOCKS_CONTROL
	{0xC83A, 0x0106, 0xffff,0xffff},  // CAM_CORE_A_Y_ADDR_START
	{0xC83C, 0x0018, 0xffff,0xffff},  // CAM_CORE_A_X_ADDR_START
	{0xC83E, 0x06B7, 0xffff,0xffff},  // CAM_CORE_A_Y_ADDR_END
	{0xC840, 0x0A45, 0xffff,0xffff},  // CAM_CORE_A_X_ADDR_END
	{0xC86C, 0x0518, 0xffff,0xffff},  // CAM_CORE_A_OUTPUT_SIZE_WIDTH
	{0xC86E, 0x02D8, 0xffff,0xffff},  // CAM_CORE_A_OUTPUT_SIZE_HEIGHT
	{0xC870, 0x0014, 0xffff,0xffff},  // CAM_CORE_A_RX_FIFO_TRIGGER_MARK
	{0xC858, 0x0003, 0xffff,0xffff}, // CAM_CORE_A_COARSE_ITMIN
	{0xC8B8, 0x0004, 0xffff,0xffff},  // CAM_OUTPUT_0_JPEG_CONTROL
	{0xC8AA, 0x0500, 0xffff,0xffff},  // CAM_OUTPUT_0_IMAGE_WIDTH
	{0xC8AC, 0x02D1, 0xffff,0xffff},  // CAM_OUTPUT_0_IMAGE_HEIGHT
	{0xC8AE, 0x0001, 0xffff,0xffff},  // CAM_OUTPUT_0_OUTPUT_FORMAT
	{0x8404, 0x06, 0xffff,0xff },     // SEQ_CMD
	SensorWaitMs(100),

	SensorEnd
};

/* 1920x1080 */
static struct rk_sensor_reg sensor_1080p[]={
	SensorEnd
};


static struct rk_sensor_reg sensor_softreset_data[]={
    {0x0010,0x0115,0xffff,0xffff},
	SensorEnd
};

static struct rk_sensor_reg sensor_check_id_data[]={
	SensorEnd
};
/*
*  The following setting must been filled, if the function is turn on by CONFIG_SENSOR_xxxx
*/
static struct rk_sensor_reg sensor_WhiteB_Auto[]=
{
	SensorEnd
};
/* Cloudy Colour Temperature : 6500K - 8000K  */
static	struct rk_sensor_reg sensor_WhiteB_Cloudy[]=
{

	SensorEnd
};
/* ClearDay Colour Temperature : 5000K - 6500K	*/
static	struct rk_sensor_reg sensor_WhiteB_ClearDay[]=
{
	SensorEnd
};
/* Office Colour Temperature : 3500K - 5000K  */
static	struct rk_sensor_reg sensor_WhiteB_TungstenLamp1[]=
{
	SensorEnd

};
/* Home Colour Temperature : 2500K - 3500K	*/
static	struct rk_sensor_reg sensor_WhiteB_TungstenLamp2[]=
{
	SensorEnd
};
static struct rk_sensor_reg *sensor_WhiteBalanceSeqe[] = {sensor_WhiteB_Auto, sensor_WhiteB_TungstenLamp1,sensor_WhiteB_TungstenLamp2,
	sensor_WhiteB_ClearDay, sensor_WhiteB_Cloudy,NULL,
};

static	struct rk_sensor_reg sensor_Brightness0[]=
{
	// Brightness -2
	SensorEnd
};

static	struct rk_sensor_reg sensor_Brightness1[]=
{
	// Brightness -1

	SensorEnd
};

static	struct rk_sensor_reg sensor_Brightness2[]=
{
	//	Brightness 0

	SensorEnd
};

static	struct rk_sensor_reg sensor_Brightness3[]=
{
	// Brightness +1

	SensorEnd
};

static	struct rk_sensor_reg sensor_Brightness4[]=
{
	//	Brightness +2

	SensorEnd
};

static	struct rk_sensor_reg sensor_Brightness5[]=
{
	//	Brightness +3

	SensorEnd
};
static struct rk_sensor_reg *sensor_BrightnessSeqe[] = {sensor_Brightness0, sensor_Brightness1, sensor_Brightness2, sensor_Brightness3,
	sensor_Brightness4, sensor_Brightness5,NULL,
};

static	struct rk_sensor_reg sensor_Effect_Normal[] =
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Effect_WandB[] =
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Effect_Sepia[] =
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Effect_Negative[] =
{
	SensorEnd
};
static	struct rk_sensor_reg sensor_Effect_Bluish[] =
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Effect_Green[] =
{
	SensorEnd
};
static struct rk_sensor_reg *sensor_EffectSeqe[] = {sensor_Effect_Normal, sensor_Effect_WandB, sensor_Effect_Negative,sensor_Effect_Sepia,
	sensor_Effect_Bluish, sensor_Effect_Green,NULL,
};

static	struct rk_sensor_reg sensor_Exposure0[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Exposure1[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Exposure2[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Exposure3[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Exposure4[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Exposure5[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Exposure6[]=
{
	SensorEnd
};

static struct rk_sensor_reg *sensor_ExposureSeqe[] = {sensor_Exposure0, sensor_Exposure1, sensor_Exposure2, sensor_Exposure3,
	sensor_Exposure4, sensor_Exposure5,sensor_Exposure6,NULL,
};

static	struct rk_sensor_reg sensor_Saturation0[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Saturation1[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Saturation2[]=
{
	SensorEnd
};
static struct rk_sensor_reg *sensor_SaturationSeqe[] = {sensor_Saturation0, sensor_Saturation1, sensor_Saturation2, NULL,};

static	struct rk_sensor_reg sensor_Contrast0[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Contrast1[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Contrast2[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Contrast3[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Contrast4[]=
{
	SensorEnd
};


static	struct rk_sensor_reg sensor_Contrast5[]=
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_Contrast6[]=
{
	SensorEnd
};
static struct rk_sensor_reg *sensor_ContrastSeqe[] = {sensor_Contrast0, sensor_Contrast1, sensor_Contrast2, sensor_Contrast3,
	sensor_Contrast4, sensor_Contrast5, sensor_Contrast6, NULL,
};
static	struct rk_sensor_reg sensor_SceneAuto[] =
{
	SensorEnd
};

static	struct rk_sensor_reg sensor_SceneNight[] =
{
	SensorEnd
};
static struct rk_sensor_reg *sensor_SceneSeqe[] = {sensor_SceneAuto, sensor_SceneNight,NULL,};

static struct rk_sensor_reg sensor_Zoom0[] =
{
	SensorEnd
};

static struct rk_sensor_reg sensor_Zoom1[] =
{
	SensorEnd
};

static struct rk_sensor_reg sensor_Zoom2[] =
{
	SensorEnd
};


static struct rk_sensor_reg sensor_Zoom3[] =
{
	SensorEnd
};
static struct rk_sensor_reg *sensor_ZoomSeqe[] = {sensor_Zoom0, sensor_Zoom1, sensor_Zoom2, sensor_Zoom3, NULL,};

/*
* User could be add v4l2_querymenu in sensor_controls by new_usr_v4l2menu
*/
static struct v4l2_querymenu sensor_menus[] =
{
};
/*
* User could be add v4l2_queryctrl in sensor_controls by new_user_v4l2ctrl
*/
static struct sensor_v4l2ctrl_usr_s sensor_controls[] =
{
};

//MUST define the current used format as the first item   
static struct rk_sensor_datafmt sensor_colour_fmts[] = {
	{MEDIA_BUS_FMT_UYVY8_2X8, V4L2_COLORSPACE_JPEG},
	{MEDIA_BUS_FMT_YUYV8_2X8, V4L2_COLORSPACE_JPEG}
};
/*static struct soc_camera_ops sensor_ops;*/


/*
**********************************************************
* Following is local code:
* 
* Please codeing your program here 
**********************************************************
*/

/*
**********************************************************
* Following is callback
* If necessary, you could coding these callback
**********************************************************
*/
/*
* the function is called in open sensor  
*/
static int sensor_activate_cb(struct i2c_client *client)
{
    SENSOR_DG("%s",__FUNCTION__);
	return 0;
}
/*
* the function is called in close sensor
*/
static int sensor_deactivate_cb(struct i2c_client *client)
{
    SENSOR_DG("%s",__FUNCTION__);
	return 0;
}
/*
* the function is called before sensor register setting in VIDIOC_S_FMT  
*/
static int sensor_s_fmt_cb_th(struct i2c_client *client,struct v4l2_mbus_framefmt *mf, bool capture)
{

    return 0;
}
/*
* the function is called after sensor register setting finished in VIDIOC_S_FMT  
*/
static int sensor_s_fmt_cb_bh (struct i2c_client *client,struct v4l2_mbus_framefmt *mf, bool capture)
{
    int i,cnt,time,ret=0;
    char seq_state;

    if ((mf->width == 2592) && (mf->height == 1944)) {
    
       /*check state of register 0x8405 to make sure set is successful*/
       /*set sensor_Preview2Capture more times to make sure set go into effect */
        cnt = 0;
        time  =0;
        do{                      
            ret =  0;
            msleep(50);   
            ret = sensor_read_reg2val1(client,0x8405, &seq_state);
            if (ret<0) {
                SENSOR_TR("read register(0x8405) failed");
                goto sensor_s_fmt_cb_bh_end;
            }
            
            if(cnt++ > 9) {
                time++;
                cnt = 0;
        		ret = sensor_write_array(client, sensor_fullres_lowfps_data);      
        		if (ret != 0||time >2) {
                	SENSOR_TR("switch preview to capture failed 0x%x %d",ret,time);
                	goto sensor_s_fmt_cb_bh_end;
            	}
            }
         } while((seq_state != 0x07) && (time < 4));
    } else if ((mf->width == 1280) && (mf->height == 720)) {
        for (i=0;i<3;i++)
            generic_sensor_write_array(client, sensor_720p);        
    }

sensor_s_fmt_cb_bh_end:
    return ret;
}
static int sensor_try_fmt_cb_th(struct i2c_client *client,struct v4l2_mbus_framefmt *mf)
{
	return 0;
}
static int sensor_softrest_usr_cb(struct i2c_client *client,struct rk_sensor_reg *series)
{
	
	return 0;
}
static int sensor_check_id_usr_cb(struct i2c_client *client,struct rk_sensor_reg *series)
{
	return 0;
}

static int sensor_suspend(struct soc_camera_device *icd, pm_message_t pm_msg)
{
	//struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));
		
	if (pm_msg.event == PM_EVENT_SUSPEND) {
		SENSOR_DG("Suspend");
		
	} else {
		SENSOR_TR("pm_msg.event(0x%x) != PM_EVENT_SUSPEND\n",pm_msg.event);
		return -EINVAL;
	}
	return 0;
}

static int sensor_resume(struct soc_camera_device *icd)
{

	SENSOR_DG("Resume");

	return 0;

}
static int sensor_mirror_cb (struct i2c_client *client, int mirror)
{
    int err =0;
    SENSOR_DG("mirror: %d",mirror);


	return err;    
}
/*
* the function is v4l2 control V4L2_CID_HFLIP callback  
*/
static int sensor_v4l2ctrl_mirror_cb(struct soc_camera_device *icd, struct sensor_v4l2ctrl_info_s *ctrl_info, 
                                                     struct v4l2_ext_control *ext_ctrl)
{
	struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if (sensor_mirror_cb(client,ext_ctrl->value) != 0)
		SENSOR_TR("sensor_mirror failed, value:0x%x",ext_ctrl->value);
	
	SENSOR_DG("sensor_mirror success, value:0x%x",ext_ctrl->value);
	return 0;
}

static int sensor_flip_cb(struct i2c_client *client, int flip)
{	
    int err =0;
    SENSOR_DG("flip: %d",flip);

	return err;    
}
/*
* the function is v4l2 control V4L2_CID_VFLIP callback  
*/
static int sensor_v4l2ctrl_flip_cb(struct soc_camera_device *icd, struct sensor_v4l2ctrl_info_s *ctrl_info, 
                                                     struct v4l2_ext_control *ext_ctrl)
{
	struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if (sensor_flip_cb(client,ext_ctrl->value) != 0)
		SENSOR_TR("sensor_flip failed, value:0x%x",ext_ctrl->value);
	
	SENSOR_DG("sensor_flip success, value:0x%x",ext_ctrl->value);
	return 0;
}
/*
* the functions are focus callbacks
*/

static int sensor_focus_init_usr_cb(struct i2c_client *client) 
{  
	return 0;
}
static struct rk_sensor_reg sensor_af_trigger[] =
{
	{ 0xB854, 0x4040, 0xffff, 0xffff},	// STAT_SM_WINDOW_POS_X; POS_Y                                                                                                                                                                              
    { 0xB856, 0x4040, 0xffff, 0xffff}, 	// STAT_SM_WINDOW_SIZE_X; SIZE_Y                                                                                                                                                                          
    { 0xB006, 0x01, 0xffff, 0xff},       //run AF - af.progress 
    SensorEnd
};
static int sensor_focus_af_single_usr_cb(struct i2c_client *client){
	int ret = 0;
    char cnt=0;
    struct rk_sensor_reg reg;
    
	ret = sensor_write_array(client, sensor_af_trigger);
	if (ret<0) {
		SENSOR_TR("%s sensor auto focus trigger fail!!\n",SENSOR_NAME_STRING());
	} else {
        reg.reg = 0xb006;
        reg.val = 0x01;
        reg.reg_mask = 0xffff;
        reg.val_mask = 0xff;
        do {
            msleep(30);
            generic_sensor_read(client,&reg);
        } while ((reg.val != 0) && (cnt++ < 50));
        
		SENSOR_DG("%s sensor auto focus trigger(0x%x) success! state: %d, cnt: %d\n",SENSOR_NAME_STRING(),
          sensor_af_trigger[0].val,reg.val,cnt);
	}
//sensor_af_single_end:
	return ret;
}

static int sensor_focus_af_near_usr_cb(struct i2c_client *client){
	return 0;
}

static int sensor_focus_af_far_usr_cb(struct i2c_client *client){
	return 0;
}

static int sensor_focus_af_specialpos_usr_cb(struct i2c_client *client,int pos) {
	return 0;
}

static int sensor_focus_af_const_usr_cb(struct i2c_client *client){
	return 0;
}
static int sensor_focus_af_const_pause_usr_cb(struct i2c_client *client)
{
    return 0;
}
static int sensor_focus_af_close_usr_cb(struct i2c_client *client){
	return 0;
}

static int sensor_focus_af_zoneupdate_usr_cb(struct i2c_client *client,int *zone_tm_pos){
    int ret = 0;
    int zone_center_pos[2];

    zone_tm_pos[0] += 1000;
	zone_tm_pos[1] += 1000;
	zone_tm_pos[2] += 1000;
	zone_tm_pos[3] += 1000;
    zone_center_pos[0] = ((zone_tm_pos[0] + zone_tm_pos[2])>>1);
    zone_center_pos[1] = ((zone_tm_pos[1] + zone_tm_pos[3])>>1);
    
    zone_center_pos[0] = zone_center_pos[0]*0x100/2000;
    zone_center_pos[1] = zone_center_pos[1]*0x100/2000;

    zone_center_pos[0] = zone_center_pos[0]/0x40*0x40;
    zone_center_pos[1] = zone_center_pos[1]/0x40*0x40;

    sensor_af_trigger[0].val = (zone_center_pos[0]<<8)|zone_center_pos[1];
  
//sensor_af_zone_end:
    return ret;
}

/*
face defect call back
*/
static int 	sensor_face_detect_usr_cb(struct i2c_client *client,int on){
	return 0;
}

/*
*   The function can been run in sensor_init_parametres which run in sensor_probe, so user can do some
* initialization in the function. 
*/
static void sensor_init_parameters_user(struct specific_sensor* spsensor,struct soc_camera_device *icd)
{
    return;
}

/*
* :::::WARNING:::::
* It is not allowed to modify the following code
*/

sensor_init_parameters_default_code();

sensor_v4l2_struct_initialization();

sensor_probe_default_code();

sensor_remove_default_code();

sensor_driver_default_module_code();

