/*
 *************************************************************************
 * Rockchip driver for CIF ISP 1.0
 * (Based on Intel driver for sofiaxxx)
 *
 * Copyright (C) 2015 Intel Mobile Communications GmbH
 * Copyright (C) 2016 Fuzhou Rockchip Electronics Co., Ltd.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *************************************************************************
 */

#ifndef _RK_CIF_ISP10_REGS_H
#define _RK_CIF_ISP10_REGS_H

/* ISP_CTRL */
#define CIF_ISP_CTRL_ISP_ENABLE                BIT(0)
#define CIF_ISP_CTRL_ISP_MODE_RAW_PICT         (0 << 1)
#define CIF_ISP_CTRL_ISP_MODE_ITU656           BIT(1)
#define CIF_ISP_CTRL_ISP_MODE_ITU601           (2 << 1)
#define CIF_ISP_CTRL_ISP_MODE_BAYER_ITU601     (3 << 1)
#define CIF_ISP_CTRL_ISP_MODE_DATA_MODE        (4 << 1)
#define CIF_ISP_CTRL_ISP_MODE_BAYER_ITU656     (5 << 1)
#define CIF_ISP_CTRL_ISP_MODE_RAW_PICT_ITU656  (6 << 1)
#define CIF_ISP_CTRL_ISP_INFORM_ENABLE         BIT(4)
#define CIF_ISP_CTRL_ISP_GAMMA_IN_ENA          BIT(6)
#define CIF_ISP_CTRL_ISP_GAMMA_IN_DIS          (0 << 6)
#define CIF_ISP_CTRL_ISP_AWB_ENA               BIT(7)
#define CIF_ISP_CTRL_ISP_AWB_DIS               (0 << 7)
#define CIF_ISP_CTRL_ISP_CFG_UPD_PERMANENT     BIT(8)
#define CIF_ISP_CTRL_ISP_CFG_UPD               BIT(9)
#define CIF_ISP_CTRL_ISP_GEN_CFG_UPD           BIT(10)
#define CIF_ISP_CTRL_ISP_GAMMA_OUT_ENA         BIT(11)
#define CIF_ISP_CTRL_ISP_GAMMA_OUT_DIS         (0 << 11)
#define CIF_ISP_CTRL_ISP_FLASH_MODE_ENA        BIT(12)
#define CIF_ISP_CTRL_ISP_FLASH_MODE_DIS        (0 << 12)
#define CIF_ISP_CTRL_ISP_CSM_Y_FULL_ENA        BIT(13)
#define CIF_ISP_CTRL_ISP_CSM_C_FULL_ENA        BIT(14)

/* ISP_ACQ_PROP */
#define CIF_ISP_ACQ_PROP_NEG_EDGE              (0 << 0)
#define CIF_ISP_ACQ_PROP_POS_EDGE              BIT(0)
#define CIF_ISP_ACQ_PROP_HSYNC_HIGH            (0 << 1)
#define CIF_ISP_ACQ_PROP_HSYNC_LOW             BIT(1)
#define CIF_ISP_ACQ_PROP_VSYNC_HIGH            (0 << 2)
#define CIF_ISP_ACQ_PROP_VSYNC_LOW             BIT(2)
#define CIF_ISP_ACQ_PROP_BAYER_PAT_RGGB        (0 << 3)
#define CIF_ISP_ACQ_PROP_BAYER_PAT_GRBG        BIT(3)
#define CIF_ISP_ACQ_PROP_BAYER_PAT_GBRG        (2 << 3)
#define CIF_ISP_ACQ_PROP_BAYER_PAT_BGGR        (3 << 3)
#define CIF_ISP_ACQ_PROP_YCBYCR                (0 << 7)
#define CIF_ISP_ACQ_PROP_YCRYCB                BIT(7)
#define CIF_ISP_ACQ_PROP_CBYCRY                (2 << 7)
#define CIF_ISP_ACQ_PROP_CRYCBY                (3 << 7)
#define CIF_ISP_ACQ_PROP_FIELD_SEL_ALL         (0 << 9)
#define CIF_ISP_ACQ_PROP_FIELD_SEL_EVEN        BIT(9)
#define CIF_ISP_ACQ_PROP_FIELD_SEL_ODD         (2 << 9)
#define CIF_ISP_ACQ_PROP_IN_SEL_12B            (0 << 12)
#define CIF_ISP_ACQ_PROP_IN_SEL_10B_ZERO       BIT(12)
#define CIF_ISP_ACQ_PROP_IN_SEL_10B_MSB        (2 << 12)
#define CIF_ISP_ACQ_PROP_IN_SEL_8B_ZERO        (3 << 12)
#define CIF_ISP_ACQ_PROP_IN_SEL_8B_MSB         (4 << 12)

/* VI_DPCL */
#define CIF_VI_DPCL_DMA_JPEG               (0 << 0)
#define CIF_VI_DPCL_MP_MUX_MRSZ_MI         BIT(0)
#define CIF_VI_DPCL_MP_MUX_MRSZ_JPEG       (2 << 0)
#define CIF_VI_DPCL_CHAN_MODE_MP           BIT(2)
#define CIF_VI_DPCL_CHAN_MODE_SP           (2 << 2)
#define CIF_VI_DPCL_CHAN_MODE_MPSP         (3 << 2)
#define CIF_VI_DPCL_DMA_SW_SPMUX           (0 << 4)
#define CIF_VI_DPCL_DMA_SW_SI              BIT(4)
#define CIF_VI_DPCL_DMA_SW_IE              (2 << 4)
#define CIF_VI_DPCL_DMA_SW_JPEG            (3 << 4)
#define CIF_VI_DPCL_DMA_SW_ISP             (4 << 4)
#define CIF_VI_DPCL_IF_SEL_PARALLEL        (0 << 8)
#define CIF_VI_DPCL_IF_SEL_SMIA            BIT(8)
#define CIF_VI_DPCL_IF_SEL_MIPI            (2 << 8)
#define CIF_VI_DPCL_DMA_IE_MUX_CIF         (0 << 10)
#define CIF_VI_DPCL_DMA_IE_MUX_DMA         BIT(10)
#define CIF_VI_DPCL_DMA_SP_MUX_CIF         (0 << 11)
#define CIF_VI_DPCL_DMA_SP_MUX_DMA         BIT(11)

/* ISP_IMSC - ISP_MIS - ISP_RIS - ISP_ICR - ISP_ISR */
#define CIF_ISP_OFF                        BIT(0)
#define CIF_ISP_FRAME                      BIT(1)
#define CIF_ISP_DATA_LOSS                  BIT(2)
#define CIF_ISP_PIC_SIZE_ERROR             BIT(3)
#define CIF_ISP_AWB_DONE                   BIT(4)
#define CIF_ISP_FRAME_IN                   BIT(5)
#define CIF_ISP_V_START                    BIT(6)
#define CIF_ISP_H_START                    BIT(7)
#define CIF_ISP_FLASH_ON                   BIT(8)
#define CIF_ISP_FLASH_OFF                  BIT(9)
#define CIF_ISP_SHUTTER_ON                 BIT(10)
#define CIF_ISP_SHUTTER_OFF                BIT(11)
#define CIF_ISP_AFM_SUM_OF                 BIT(12)
#define CIF_ISP_AFM_LUM_OF                 BIT(13)
#define CIF_ISP_AFM_FIN                    BIT(14)
#define CIF_ISP_HIST_MEASURE_RDY           BIT(15)
#define CIF_ISP_FLASH_CAP                  BIT(17)
#define CIF_ISP_EXP_END                    BIT(18)
#define CIF_ISP_VSM_END                    BIT(19)

/* ISP_ERR */
#define CIF_ISP_ERR_INFORM_SIZE            BIT(0)
#define CIF_ISP_ERR_IS_SIZE                BIT(1)
#define CIF_ISP_ERR_OUTFORM_SIZE           BIT(2)

/* MI_CTRL */
#define CIF_MI_CTRL_MP_ENABLE_IN           BIT(0)
#define CIF_MI_CTRL_MP_ENABLE_OUT          BIT(16)
#define CIF_MI_CTRL_MP_DISABLE             (0 << 0)
#define CIF_MI_CTRL_SP_ENABLE              BIT(1)
#define CIF_MI_CTRL_SP_DISABLE             (0 << 1)
#define CIF_MI_CTRL_JPEG_ENABLE            BIT(2)
#define CIF_MI_CTRL_JPEG_DISABLE           (0 << 2)
#define CIF_MI_CTRL_RAW_ENABLE             BIT(3)
#define CIF_MI_CTRL_RAW_DISABLE            (0 << 3)
#define CIF_MI_CTRL_HFLIP                  BIT(4)
#define CIF_MI_CTRL_VFLIP                  BIT(5)
#define CIF_MI_CTRL_ROT                    BIT(6)
#define CIF_MI_BYTE_SWAP                   BIT(7)
#define CIF_MI_NO_BYTE_SWAP               (0 << 7)
#define CIF_MI_SP_Y_FULL_YUV2RGB           BIT(8)
#define CIF_MI_SP_Y_REDUCED_YUV2RGB        (0 << 8)
#define CIF_MI_SP_CBCR_FULL_YUV2RGB        BIT(9)
#define CIF_MI_SP_CBCR_REDUCED_YUV2RGB     (0 << 9)
#define CIF_MI_SP_422NONCOSITEED           BIT(10)
#define CIF_MI_MP_PINGPONG_ENABEL          BIT(11)
#define CIF_MI_MP_PINGPONG_DISABEL         (0 << 11)
#define CIF_MI_SP_PINGPONG_ENABEL          BIT(12)
#define CIF_MI_SP_PINGPONG_DISABEL         (0 << 12)
#define CIF_MI_MP_AUTOUPDATE_ENABLE        BIT(13)
#define CIF_MI_MP_AUTOUPDATE_DISABLE       (0 << 13)
#define CIF_MI_SP_AUTOUPDATE_ENABLE        BIT(14)
#define CIF_MI_SP_AUTOUPDATE_DISABLE       (0 << 14)
#define CIF_MI_LAST_PIXEL_SIG_ENABLE       BIT(15)
#define CIF_MI_LAST_PIXEL_SIG_DISABLE      (0 << 15)
#define CIF_MI_CTRL_BURST_LEN_LUM_4       (0 << 16)
#define CIF_MI_CTRL_BURST_LEN_LUM_8       BIT(16)
#define CIF_MI_CTRL_BURST_LEN_LUM_16      (2 << 16)
#define CIF_MI_CTRL_BURST_LEN_CHROM_4     (0 << 18)
#define CIF_MI_CTRL_BURST_LEN_CHROM_8     BIT(18)
#define CIF_MI_CTRL_BURST_LEN_CHROM_16    (2 << 18)
#define CIF_MI_CTRL_INIT_BASE_EN           BIT(20)
#define CIF_MI_CTRL_INIT_BASE_DIS          (0 << 20)
#define CIF_MI_CTRL_INIT_OFFSET_EN         BIT(21)
#define CIF_MI_CTRL_INIT_OFFSET_DIS        (0 << 21)
#define CIF_MI_CTRL_MP_WRITE_FMT(a)        ((a) << 22)
#define CIF_MI_CTRL_MP_WRITE_FMT_PLA       (0 << 22)
#define CIF_MI_CTRL_MP_WRITE_FMT_SPLA      BIT(22)
#define CIF_MI_CTRL_MP_WRITE_FMT_INT       (2 << 22)
#define CIF_MI_CTRL_SP_WRITE_FMT(a)        ((a) << 24)
#define CIF_MI_CTRL_SP_WRITE_FMT_PLA       (0 << 24)
#define CIF_MI_CTRL_SP_WRITE_FMT_SPLA      BIT(24)
#define CIF_MI_CTRL_SP_WRITE_FMT_INT       (2 << 24)
#define CIF_MI_CTRL_SP_INPUT_FMT_YUV400    (0 << 26)
#define CIF_MI_CTRL_SP_INPUT_FMT_YUV420    BIT(26)
#define CIF_MI_CTRL_SP_INPUT_FMT_YUV422    (2 << 26)
#define CIF_MI_CTRL_SP_INPUT_FMT_YUV444    (3 << 26)
#define CIF_MI_CTRL_SP_OUTPUT_FMT_YUV400   (0 << 28)
#define CIF_MI_CTRL_SP_OUTPUT_FMT_YUV420   BIT(28)
#define CIF_MI_CTRL_SP_OUTPUT_FMT_YUV422   (2 << 28)
#define CIF_MI_CTRL_SP_OUTPUT_FMT_YUV444   (3 << 28)
#define CIF_MI_CTRL_SP_OUTPUT_FMT_RGB565   (4 << 28)
#define CIF_MI_CTRL_SP_OUTPUT_FMT_RGB666   (5 << 28)
#define CIF_MI_CTRL_SP_OUTPUT_FMT_RGB888   (6 << 28)

#define CIF_MI_CTRL_HFLIP_SHIFT  4
#define CIF_MI_CTRL_VFLIP_SHIFT  5

/* MI_INIT */
#define CIF_MI_INIT_SKIP                  BIT(2)
#define CIF_MI_INIT_SOFT_UPD              BIT(4)

/* RSZ_CTRL */
#define CIF_RSZ_CTRL_SCALE_HY_ENABLE      BIT(0)
#define CIF_RSZ_CTRL_SCALE_HC_ENABLE      BIT(1)
#define CIF_RSZ_CTRL_SCALE_VY_ENABLE      BIT(2)
#define CIF_RSZ_CTRL_SCALE_VC_ENABLE      BIT(3)
#define CIF_RSZ_CTRL_SCALE_HY_UP          BIT(4)
#define CIF_RSZ_CTRL_SCALE_HC_UP          BIT(5)
#define CIF_RSZ_CTRL_SCALE_VY_UP          BIT(6)
#define CIF_RSZ_CTRL_SCALE_VC_UP          BIT(7)
#define CIF_RSZ_CTRL_CFG_UPD              BIT(8)
#define CIF_RSZ_CTRL_CFG_UPD_AUTO         BIT(9)
#define CIF_RSZ_SCALER_BYPASS             BIT(16)

/* MI_IMSC - MI_MIS - MI_RIS - MI_ICR - MI_ISR */
#define CIF_MI_NOTHING                     (0 << 0)
#define CIF_MI_MP_FRAME                    BIT(0)
#define CIF_MI_SP_FRAME                    BIT(1)
#define CIF_MI_MBLK_LINE                   BIT(2)
#define CIF_MI_FILL_MP_Y                   BIT(3)
#define CIF_MI_WRAP_MP_Y                   BIT(4)
#define CIF_MI_WRAP_MP_CB                  BIT(5)
#define CIF_MI_WRAP_MP_CR                  BIT(6)
#define CIF_MI_WRAP_SP_Y                   BIT(7)
#define CIF_MI_WRAP_SP_CB                  BIT(8)
#define CIF_MI_WRAP_SP_CR                  BIT(9)
#define CIF_MI_DMA_READY                   BIT(11)

/* MI_STATUS */
#define CIF_MI_STATUS_MP_Y_FIFO_FULL       BIT(0)
#define CIF_MI_STATUS_SP_Y_FIFO_FULL       BIT(4)

/* MI_DMA_CTRL */
#define CIF_MI_DMA_CTRL_BURST_LEN_LUM_16   (0 << 0)
#define CIF_MI_DMA_CTRL_BURST_LEN_LUM_32   BIT(0)
#define CIF_MI_DMA_CTRL_BURST_LEN_LUM_64   (2 << 0)
#define CIF_MI_DMA_CTRL_BURST_LEN_CHROM_16 (0 << 2)
#define CIF_MI_DMA_CTRL_BURST_LEN_CHROM_32 BIT(2)
#define CIF_MI_DMA_CTRL_BURST_LEN_CHROM_64 (2 << 2)
#define CIF_MI_DMA_CTRL_READ_FMT(a)        ((a) << 4)
#define CIF_MI_DMA_CTRL_READ_FMT_PLANAR    (0 << 4)
#define CIF_MI_DMA_CTRL_READ_FMT_SPLANAR   BIT(4)
#define CIF_MI_DMA_CTRL_READ_FMT_PACKED    (2 << 4)
#define CIF_MI_DMA_CTRL_FMT_YUV444         (3 << 6)
#define CIF_MI_DMA_CTRL_FMT_YUV422         (2 << 6)
#define CIF_MI_DMA_CTRL_FMT_YUV420         BIT(6)
#define CIF_MI_DMA_CTRL_FMT_YUV400         (0 << 6)
#define CIF_MI_DMA_CTRL_BYTE_SWAP          BIT(8)
#define CIF_MI_DMA_CTRL_NO_BYTE_SWAP       (0 << 8)
#define CIF_MI_DMA_CTRL_CONTINUOUS_ENA      BIT(9)
#define CIF_MI_DMA_CTRL_CONTINUOUS_DIS     (0 << 9)
#define CIF_MI_DMA_CTRL_RGB_BAYER_NO       (0 << 12)
#define CIF_MI_DMA_CTRL_RGB_BAYER_8BIT      BIT(12)
#define CIF_MI_DMA_CTRL_RGB_BAYER_16BIT    (2 << 12)
/* MI_DMA_START */
#define CIF_MI_DMA_START_ENABLE             BIT(0)
/* MI_XTD_FORMAT_CTRL  */
#define CIF_MI_XTD_FMT_CTRL_MP_CB_CR_SWAP   BIT(0)
#define CIF_MI_XTD_FMT_CTRL_SP_CB_CR_SWAP   BIT(1)
#define CIF_MI_XTD_FMT_CTRL_DMA_CB_CR_SWAP  BIT(2)

#define CIF_MI_ADDR_SIZE_ALIGN_MASK        0xfffffff8

/* CCL */
#define CIF_CCL_CIF_CLK_ENA                (0 << 2)
#define CIF_CCL_CIF_CLK_DIS                BIT(2)
/* ICCL */
#define CIF_ICCL_ISP_CLK                   BIT(0)
#define CIF_ICCL_CP_CLK                    BIT(1)
#define CIF_ICCL_RES_2                     BIT(2)
#define CIF_ICCL_MRSZ_CLK                  BIT(3)
#define CIF_ICCL_SRSZ_CLK                  BIT(4)
#define CIF_ICCL_JPEG_CLK                  BIT(5)
#define CIF_ICCL_MI_CLK                    BIT(6)
#define CIF_ICCL_RES_7                     BIT(7)
#define CIF_ICCL_IE_CLK                    BIT(8)
#define CIF_ICCL_SIMP_CLK                  BIT(9)
#define CIF_ICCL_SMIA_CLK                  BIT(10)
#define CIF_ICCL_MIPI_CLK                  BIT(11)
#define CIF_ICCL_ALL_CLK                   (-1)
#define CIF_ICCL_NO_CLK                    (0)
/* IRCL */
#define CIF_IRCL_ISP_SW_RST                BIT(0)
#define CIF_IRCL_CP_SW_RST                 BIT(1)
#define CIF_IRCL_YCS_SW_RST                BIT(2)
#define CIF_IRCL_MRSZ_SW_RST               BIT(3)
#define CIF_IRCL_SRSZ_SW_RST               BIT(4)
#define CIF_IRCL_JPEG_SW_RST               BIT(5)
#define CIF_IRCL_MI_SW_RST                 BIT(6)
#define CIF_IRCL_CIF_SW_RST                BIT(7)
#define CIF_IRCL_IE_SW_RST                 BIT(8)
#define CIF_IRCL_SI_SW_RST                 BIT(9)
#define CIF_IRCL_MIPI_SW_RST               BIT(11)

/* C_PROC_CTR */
#define CIF_C_PROC_CTR_ENABLE              BIT(0)
#define CIF_C_PROC_CTR_DIS                 (0 << 0)
#define CIF_C_PROC_YOUT_FULL               BIT(1)
#define CIF_C_PROC_YOUT_LIM                (0 << 1)
#define CIF_C_PROC_YIN_FULL                BIT(2)
#define CIF_C_PROC_YIN_LIM                 (0 << 2)
#define CIF_C_PROC_COUT_FULL               BIT(3)
#define CIF_C_PROC_COUT_LIM                (0 << 3)

/* DUAL_CROP_CTRL */
#define CIF_DUAL_CROP_MP_MODE_BYPASS      (0 << 0)
#define CIF_DUAL_CROP_MP_MODE_YUV         BIT(0)
#define CIF_DUAL_CROP_MP_MODE_RAW         (2 << 0)
#define CIF_DUAL_CROP_SP_MODE_BYPASS      (0 << 2)
#define CIF_DUAL_CROP_SP_MODE_YUV         BIT(2)
#define CIF_DUAL_CROP_SP_MODE_RAW         (2 << 2)
#define CIF_DUAL_CROP_CFG_UPD_PERMANENT   BIT(4)
#define CIF_DUAL_CROP_CFG_UPD             BIT(5)
#define CIF_DUAL_CROP_GEN_CFG_UPD         BIT(6)

/* IMG_EFF_CTRL */
#define CIF_IMG_EFF_CTRL_ENABLE           BIT(0)
#define CIF_IMG_EFF_CTRL_MODE_BLACKWHITE  (0 << 1)
#define CIF_IMG_EFF_CTRL_MODE_NEGATIVE    BIT(1)
#define CIF_IMG_EFF_CTRL_MODE_SEPIA      (2 << 1)
#define CIF_IMG_EFF_CTRL_MODE_COLOR_SEL  (3 << 1)
#define CIF_IMG_EFF_CTRL_MODE_EMBOSS     (4 << 1)
#define CIF_IMG_EFF_CTRL_MODE_SKETCH     (5 << 1)
#define CIF_IMG_EFF_CTRL_MODE_SHARPEN    (6 << 1)
#define CIF_IMG_EFF_CTRL_CFG_UPD         BIT(4)
#define CIF_IMG_EFF_CTRL_YCBCR_FULL      BIT(5)

#define CIF_IMG_EFF_CTRL_MODE_BLACKWHITE_SHIFT   (0)
#define CIF_IMG_EFF_CTRL_MODE_NEGATIVE_SHIFT     (1)
#define CIF_IMG_EFF_CTRL_MODE_SEPIA_SHIFT        (2)
#define CIF_IMG_EFF_CTRL_MODE_COLOR_SEL_SHIFT    (3)
#define CIF_IMG_EFF_CTRL_MODE_EMBOSS_SHIFT       (4)
#define CIF_IMG_EFF_CTRL_MODE_SKETCH_SHIFT       (5)
#define CIF_IMG_EFF_CTRL_MODE_SHARPEN_SHIFT      (6)

/* IMG_EFF_COLOR_SEL */
#define CIF_IMG_EFF_COLOR_RGB              (0 << 0)
#define CIF_IMG_EFF_COLOR_B                BIT(0)
#define CIF_IMG_EFF_COLOR_G                (2 << 0)
#define CIF_IMG_EFF_COLOR_GB               (3 << 0)
#define CIF_IMG_EFF_COLOR_R                (4 << 0)
#define CIF_IMG_EFF_COLOR_RB               (5 << 0)
#define CIF_IMG_EFF_COLOR_RG               (6 << 0)
#define CIF_IMG_EFF_COLOR_RGB2             (7 << 0)

/* JPE */
#define CIF_JPE_GEN_HEADER_ENABLE          BIT(0)
#define CIF_JPE_ENCODE_ENABLE              BIT(0)
#define CIF_JPE_INIT_ENABLE                BIT(0)
#define CIF_JPE_LUM_SCALE_ENABLE           BIT(0)
#define CIF_JPE_CHROM_SCALE_ENABLE         BIT(0)
#define CIF_JPE_PIC_FORMAT_YUV422          BIT(0)
#define CIF_JPE_PIC_FORMAT_YUV400          (4 << 0)

#define CIF_JPE_TQ_TAB3                    (3 << 0)
#define CIF_JPE_TQ_TAB2                    (2 << 0)
#define CIF_JPE_TQ_TAB1                    BIT(0)
#define CIF_JPE_TQ_TAB0                    (0 << 0)

#define CIF_TQ_Y_SELECT                    (3 << 0)
#define CIF_TQ_U_SELECT                    (3 << 0)
#define CIF_TQ_V_SELECT                    (3 << 0)
#define CIF_DC_V_TABLE                     (4 << 0)
#define CIF_DC_U_TABLE                     (2 << 0)
#define CIF_DC_Y_TABLE                     BIT(0)
#define CIF_AC_V_TABLE                     (4 << 0)
#define CIF_AC_U_TABLE                     (2 << 0)
#define CIF_AC_Y_TABLE                     BIT(0)

/* JPE_TAB_ID */
#define CIF_JPE_TAB_ID_HUFFAC1             (7 << 0)
#define CIF_JPE_TAB_ID_HUFFDC1             (6 << 0)
#define CIF_JPE_TAB_ID_HUFFAC0             (5 << 0)
#define CIF_JPE_TAB_ID_HUFFDC0             (4 << 0)
#define CIF_JPE_TAB_ID_QUANT3              (3 << 0)
#define CIF_JPE_TAB_ID_QUANT2              (2 << 0)
#define CIF_JPE_TAB_ID_QUANT1              BIT(0)
#define CIF_JPE_TAB_ID_QUANT0              (0 << 0)
/* JPE_ENCODER_BUSY */
#define CIF_ENCODER_BUSY                   BIT(0)
/* JPE_HEADER_MODE */
#define CIF_JPE_HEADER_MODE_NOAPPN         (0 << 0)
#define CIF_JPE_HEADER_MODE_NOAPPN1        BIT(0)
#define CIF_JPE_HEADER_MODE_JFIF           (2 << 0)
#define CIF_JPE_HEADER_MODE_JFIF1          (3 << 0)
/* JPE_ERROR_RIS */
#define CIF_JPE_VLC_SYMB_ERROR             BIT(4)
#define CIF_JPE_DCT_ERROR                  BIT(7)
#define CIF_JPE_R2B_IMG_SIZE_ERROR         BIT(9)
#define CIF_JPE_VLC_TAB_ERROR              BIT(10)
#define CIF_JPE_ERROR_MASK   (CIF_JPE_VLC_SYMB_ERROR |\
					CIF_JPE_DCT_ERROR |\
					CIF_JPE_R2B_IMG_SIZE_ERROR |\
					CIF_JPE_VLC_TAB_ERROR)
/* JPE_STATUS_RIS */
#define CIF_JPE_STATUS_ENCODE_DONE         BIT(4)
#define CIF_JPE_STATUS_GENHEADER_DONE      BIT(5)

/* MIPI */

/* MIPI_DPHY1 */

/* MIPI_DPHY2 */

/* MIPI_CTRL */
#define CIF_MIPI_CTRL_OUTPUT_ENA             BIT(0)
#define CIF_MIPI_CTRL_SHUTDOWNLANES(a)       ((a) << 8)
#define CIF_CSI_LANE_2                       BIT(1)
#define CIF_CSI_LANE_3                       BIT(2)
#define CIF_CSI_LANE_4                       BIT(3)
#define CIF_MIPI_CTRL_NUM_LANES(a)           ((a) << 12)
#define CIF_MIPI_CTRL_ERR_SOT_HS_ENA         (0 << 16)
#define CIF_MIPI_CTRL_ERR_SOT_HS_SKIP        BIT(16)
#define CIF_MIPI_CTRL_ERR_SOT_SYNC_HS_ENA    (0 << 17)
#define CIF_MIPI_CTRL_ERR_SOT_SYNC_HS_SKIP   BIT(17)
#define CIF_MIPI_CTRL_CLOCKLANE_ENA          BIT(18)

/* MIPI_DATA_SEL */
#define CIF_MIPI_DATA_SEL_VC(a)              ((a) << 6)
#define CIF_MIPI_DATA_SEL_DT(a)              ((a) << 0)

#define CIF_MIPI_INTERRUPT_ALL               (-1)

/* MIPI_IMSC, MIPI_RIS, MIPI_MIS, MIPI_ICR, MIPI_ISR */
#define CIF_MIPI_SYNC_FIFO_OVFLW(a)    ((a) << 0)
#define CIF_MIPI_ERR_SOT(a)            ((a) << 4)
#define CIF_MIPI_ERR_SOT_SYNC(a)       ((a) << 8)
#define CIF_MIPI_ERR_EOT_SYNC(a)       ((a) << 12)
#define CIF_MIPI_ERR_CTRL(a)           ((a) << 16)
#define CIF_MIPI_ERR_PROTOCOL          BIT(20)
#define CIF_MIPI_ERR_ECC1              BIT(21)
#define CIF_MIPI_ERR_ECC2              BIT(22)
#define CIF_MIPI_ERR_CS                BIT(23)
#define CIF_MIPI_FRAME_END             BIT(24)
#define CIF_MIPI_ADD_DATA_OVFLW        BIT(25)
#define CIF_MIPI_ADD_DATA_WATER_MARK   BIT(26)

#define CIF_MIPI_ERR_CSI  (CIF_MIPI_ERR_PROTOCOL | \
	CIF_MIPI_ERR_ECC1 | \
	CIF_MIPI_ERR_ECC2 | \
	CIF_MIPI_ERR_CS)

#define CIF_MIPI_ERR_DPHY  (CIF_MIPI_ERR_SOT(3) | \
	CIF_MIPI_ERR_SOT_SYNC(3) | \
	CIF_MIPI_ERR_EOT_SYNC(3) | \
	CIF_MIPI_ERR_CTRL(3))

/* SUPER_IMPOSE */
#define CIF_SUPER_IMP_CTRL_NORMAL_MODE BIT(0)
#define CIF_SUPER_IMP_CTRL_BYPASS_MODE (0 << 0)
#define CIF_SUPER_IMP_CTRL_REF_IMG_MEM BIT(1)
#define CIF_SUPER_IMP_CTRL_REF_IMG_IE  (0 << 1)
#define CIF_SUPER_IMP_CTRL_TRANSP_DIS  BIT(2)
#define CIF_SUPER_IMP_CTRL_TRANSP_ENA  (0 << 2)

/* ISP HISTOGRAM CALCULATION : ISP_HIST_PROP */
#define CIF_ISP_HIST_PROP_PDIV(a)    ((a) << 3)
#define CIF_ISP_HIST_PROP_MODE_DIS   (0 << 0)
#define CIF_ISP_HIST_PROP_MODE_RGB   BIT(0)
#define CIF_ISP_HIST_PROP_MODE_RED   (2 << 0)
#define CIF_ISP_HIST_PROP_MODE_GREEN (3 << 0)
#define CIF_ISP_HIST_PROP_MODE_BLUE  (4 << 0)
#define CIF_ISP_HIST_PROP_MODE_LUM   (5 << 0)

/* AUTO FOCUS MEASUREMENT:  ISP_AFM_CTRL */
#define ISP_AFM_CTRL_ENABLE   BIT(0)
#define ISP_AFM_CTRL_DISABLE  (0 << 0)

/* SHUTTER CONTROL */
#define CIF_ISP_SH_CTRL_SH_ENA      BIT(0)
#define CIF_ISP_SH_CTRL_SH_DIS      (0 << 0)
#define CIF_ISP_SH_CTRL_REP_EN      BIT(1)
#define CIF_ISP_SH_CTRL_REP_DIS     (0 << 1)
#define CIF_ISP_SH_CTRL_SRC_SH_TRIG BIT(2)
#define CIF_ISP_SH_CTRL_SRC_VSYNC  (0 << 2)
#define CIF_ISP_SH_CTRL_EDGE_POS    BIT(3)
#define CIF_ISP_SH_CTRL_EDGE_NEG   (0 << 3)
#define CIF_ISP_SH_CTRL_POL_LOW     BIT(4)
#define CIF_ISP_SH_CTRL_POL_HIGH   (0 << 4)

/* FLASH MODULE */
/* ISP_FLASH_CMD */
#define CIF_FLASH_CMD_PRELIGHT_ON   BIT(0)
#define CIF_FLASH_CMD_PRELIGHT_OFF  (0 << 0)
#define CIF_FLASH_CMD_FLASH_ON      BIT(1)
#define CIF_FLASH_CMD_FLASH_OFF     (0 << 1)
#define CIF_FLASH_CMD_PRE_FLASH_ON  BIT(2)
#define CIF_FLASH_CMD_PRE_FLASH_OFF (0 << 2)
/* ISP_FLASH_CONFIG */
#define CIF_FLASH_CONFIG_PRELIGHT_BEG   (0 << 1)
#define CIF_FLASH_CONFIG_PRELIGHT_END   BIT(0)
#define CIF_FLASH_CONFIG_VSYNC_NEG      (0 << 1)
#define CIF_FLASH_CONFIG_VSYNC_POS      BIT(1)
#define CIF_FLASH_CONFIG_PRELIGHT_HIGH  (0 << 2)
#define CIF_FLASH_CONFIG_PRELIGHT_LOW   BIT(2)
#define CIF_FLASH_CONFIG_SRC_VSYNC      (0 << 3)
#define CIF_FLASH_CONFIG_SRC_FL_TRIG    BIT(3)
#define CIF_FLASH_CONFIG_DELAY(a)      ((a) << 4)
/* ISP_FLAGS_SHD */
#define CIF_ISP_FLAGS_SHD_FIELD_INFO  BIT(2)
#define CIF_ISP_FLAGS_SHD_FIELD_BIT	2
#define FIELD_FLAGS_ODD		0
#define FIELD_FLAGS_EVEN	1

/* BAD PIXEL DETECTION */

/* =================================================================== */
/*                            CIF Registers                            */
/* =================================================================== */
#define CIF_CTRL_BASE               (0x00000000)
#define CIF_CCL                     ((CIF_CTRL_BASE + 0x00000000))
#define CIF_VI_ID                   ((CIF_CTRL_BASE + 0x00000008))
#define CIF_ICCL                    ((CIF_CTRL_BASE + 0x00000010))
#define CIF_IRCL                    ((CIF_CTRL_BASE + 0x00000014))
#define CIF_VI_DPCL                 ((CIF_CTRL_BASE + 0x00000018))

#define CIF_IMG_EFF_BASE            (0x00000200)
#define CIF_IMG_EFF_CTRL            ((CIF_IMG_EFF_BASE + 0x00000000))
#define CIF_IMG_EFF_COLOR_SEL       ((CIF_IMG_EFF_BASE + 0x00000004))
#define CIF_IMG_EFF_MAT_1           ((CIF_IMG_EFF_BASE + 0x00000008))
#define CIF_IMG_EFF_MAT_2           ((CIF_IMG_EFF_BASE + 0x0000000C))
#define CIF_IMG_EFF_MAT_3           ((CIF_IMG_EFF_BASE + 0x00000010))
#define CIF_IMG_EFF_MAT_4           ((CIF_IMG_EFF_BASE + 0x00000014))
#define CIF_IMG_EFF_MAT_5           ((CIF_IMG_EFF_BASE + 0x00000018))
#define CIF_IMG_EFF_TINT            ((CIF_IMG_EFF_BASE + 0x0000001C))
#define CIF_IMG_EFF_CTRL_SHD        ((CIF_IMG_EFF_BASE + 0x00000020))
#define CIF_IMG_EFF_SHARPEN         ((CIF_IMG_EFF_BASE + 0x00000024))

#define CIF_SUPER_IMP_BASE          (0x00000300)
#define CIF_SUPER_IMP_CTRL          ((CIF_SUPER_IMP_BASE + 0x00000000))
#define CIF_SUPER_IMP_OFFSET_X      ((CIF_SUPER_IMP_BASE + 0x00000004))
#define CIF_SUPER_IMP_OFFSET_Y      ((CIF_SUPER_IMP_BASE + 0x00000008))
#define CIF_SUPER_IMP_COLOR_Y       ((CIF_SUPER_IMP_BASE + 0x0000000C))
#define CIF_SUPER_IMP_COLOR_CB      ((CIF_SUPER_IMP_BASE + 0x00000010))
#define CIF_SUPER_IMP_COLOR_CR      ((CIF_SUPER_IMP_BASE + 0x00000014))

#define CIF_ISP_BASE                (0x00000400)
#define CIF_ISP_CTRL                ((CIF_ISP_BASE + 0x00000000))
#define CIF_ISP_ACQ_PROP            ((CIF_ISP_BASE + 0x00000004))
#define CIF_ISP_ACQ_H_OFFS          ((CIF_ISP_BASE + 0x00000008))
#define CIF_ISP_ACQ_V_OFFS          ((CIF_ISP_BASE + 0x0000000C))
#define CIF_ISP_ACQ_H_SIZE          ((CIF_ISP_BASE + 0x00000010))
#define CIF_ISP_ACQ_V_SIZE          ((CIF_ISP_BASE + 0x00000014))
#define CIF_ISP_ACQ_NR_FRAMES       ((CIF_ISP_BASE + 0x00000018))
#define CIF_ISP_GAMMA_DX_LO         ((CIF_ISP_BASE + 0x0000001C))
#define CIF_ISP_GAMMA_DX_HI         ((CIF_ISP_BASE + 0x00000020))
#define CIF_ISP_GAMMA_R_Y0          ((CIF_ISP_BASE + 0x00000024))
#define CIF_ISP_GAMMA_R_Y1          ((CIF_ISP_BASE + 0x00000028))
#define CIF_ISP_GAMMA_R_Y2          ((CIF_ISP_BASE + 0x0000002C))
#define CIF_ISP_GAMMA_R_Y3          ((CIF_ISP_BASE + 0x00000030))
#define CIF_ISP_GAMMA_R_Y4          ((CIF_ISP_BASE + 0x00000034))
#define CIF_ISP_GAMMA_R_Y5          ((CIF_ISP_BASE + 0x00000038))
#define CIF_ISP_GAMMA_R_Y6          ((CIF_ISP_BASE + 0x0000003C))
#define CIF_ISP_GAMMA_R_Y7          ((CIF_ISP_BASE + 0x00000040))
#define CIF_ISP_GAMMA_R_Y8          ((CIF_ISP_BASE + 0x00000044))
#define CIF_ISP_GAMMA_R_Y9          ((CIF_ISP_BASE + 0x00000048))
#define CIF_ISP_GAMMA_R_Y10         ((CIF_ISP_BASE + 0x0000004C))
#define CIF_ISP_GAMMA_R_Y11         ((CIF_ISP_BASE + 0x00000050))
#define CIF_ISP_GAMMA_R_Y12         ((CIF_ISP_BASE + 0x00000054))
#define CIF_ISP_GAMMA_R_Y13         ((CIF_ISP_BASE + 0x00000058))
#define CIF_ISP_GAMMA_R_Y14         ((CIF_ISP_BASE + 0x0000005C))
#define CIF_ISP_GAMMA_R_Y15         ((CIF_ISP_BASE + 0x00000060))
#define CIF_ISP_GAMMA_R_Y16         ((CIF_ISP_BASE + 0x00000064))
#define CIF_ISP_GAMMA_G_Y0          ((CIF_ISP_BASE + 0x00000068))
#define CIF_ISP_GAMMA_G_Y1          ((CIF_ISP_BASE + 0x0000006C))
#define CIF_ISP_GAMMA_G_Y2          ((CIF_ISP_BASE + 0x00000070))
#define CIF_ISP_GAMMA_G_Y3          ((CIF_ISP_BASE + 0x00000074))
#define CIF_ISP_GAMMA_G_Y4          ((CIF_ISP_BASE + 0x00000078))
#define CIF_ISP_GAMMA_G_Y5          ((CIF_ISP_BASE + 0x0000007C))
#define CIF_ISP_GAMMA_G_Y6          ((CIF_ISP_BASE + 0x00000080))
#define CIF_ISP_GAMMA_G_Y7          ((CIF_ISP_BASE + 0x00000084))
#define CIF_ISP_GAMMA_G_Y8          ((CIF_ISP_BASE + 0x00000088))
#define CIF_ISP_GAMMA_G_Y9          ((CIF_ISP_BASE + 0x0000008C))
#define CIF_ISP_GAMMA_G_Y10         ((CIF_ISP_BASE + 0x00000090))
#define CIF_ISP_GAMMA_G_Y11         ((CIF_ISP_BASE + 0x00000094))
#define CIF_ISP_GAMMA_G_Y12         ((CIF_ISP_BASE + 0x00000098))
#define CIF_ISP_GAMMA_G_Y13         ((CIF_ISP_BASE + 0x0000009C))
#define CIF_ISP_GAMMA_G_Y14         ((CIF_ISP_BASE + 0x000000A0))
#define CIF_ISP_GAMMA_G_Y15         ((CIF_ISP_BASE + 0x000000A4))
#define CIF_ISP_GAMMA_G_Y16         ((CIF_ISP_BASE + 0x000000A8))
#define CIF_ISP_GAMMA_B_Y0          ((CIF_ISP_BASE + 0x000000AC))
#define CIF_ISP_GAMMA_B_Y1          ((CIF_ISP_BASE + 0x000000B0))
#define CIF_ISP_GAMMA_B_Y2          ((CIF_ISP_BASE + 0x000000B4))
#define CIF_ISP_GAMMA_B_Y3          ((CIF_ISP_BASE + 0x000000B8))
#define CIF_ISP_GAMMA_B_Y4          ((CIF_ISP_BASE + 0x000000BC))
#define CIF_ISP_GAMMA_B_Y5          ((CIF_ISP_BASE + 0x000000C0))
#define CIF_ISP_GAMMA_B_Y6          ((CIF_ISP_BASE + 0x000000C4))
#define CIF_ISP_GAMMA_B_Y7          ((CIF_ISP_BASE + 0x000000C8))
#define CIF_ISP_GAMMA_B_Y8          ((CIF_ISP_BASE + 0x000000CC))
#define CIF_ISP_GAMMA_B_Y9          ((CIF_ISP_BASE + 0x000000D0))
#define CIF_ISP_GAMMA_B_Y10         ((CIF_ISP_BASE + 0x000000D4))
#define CIF_ISP_GAMMA_B_Y11         ((CIF_ISP_BASE + 0x000000D8))
#define CIF_ISP_GAMMA_B_Y12         ((CIF_ISP_BASE + 0x000000DC))
#define CIF_ISP_GAMMA_B_Y13         ((CIF_ISP_BASE + 0x000000E0))
#define CIF_ISP_GAMMA_B_Y14         ((CIF_ISP_BASE + 0x000000E4))
#define CIF_ISP_GAMMA_B_Y15         ((CIF_ISP_BASE + 0x000000E8))
#define CIF_ISP_GAMMA_B_Y16         ((CIF_ISP_BASE + 0x000000EC))
#define CIF_ISP_AWB_PROP            ((CIF_ISP_BASE + 0x00000110))
#define CIF_ISP_AWB_WND_H_OFFS      ((CIF_ISP_BASE + 0x00000114))
#define CIF_ISP_AWB_WND_V_OFFS      ((CIF_ISP_BASE + 0x00000118))
#define CIF_ISP_AWB_WND_H_SIZE      ((CIF_ISP_BASE + 0x0000011C))
#define CIF_ISP_AWB_WND_V_SIZE      ((CIF_ISP_BASE + 0x00000120))
#define CIF_ISP_AWB_FRAMES          ((CIF_ISP_BASE + 0x00000124))
#define CIF_ISP_AWB_REF             ((CIF_ISP_BASE + 0x00000128))
#define CIF_ISP_AWB_THRESH          ((CIF_ISP_BASE + 0x0000012C))
#define CIF_ISP_AWB_GAIN_G          ((CIF_ISP_BASE + 0x00000138))
#define CIF_ISP_AWB_GAIN_RB         ((CIF_ISP_BASE + 0x0000013C))
#define CIF_ISP_AWB_WHITE_CNT       ((CIF_ISP_BASE + 0x00000140))
#define CIF_ISP_AWB_MEAN            ((CIF_ISP_BASE + 0x00000144))
#define CIF_ISP_CC_COEFF_0          ((CIF_ISP_BASE + 0x00000170))
#define CIF_ISP_CC_COEFF_1          ((CIF_ISP_BASE + 0x00000174))
#define CIF_ISP_CC_COEFF_2          ((CIF_ISP_BASE + 0x00000178))
#define CIF_ISP_CC_COEFF_3          ((CIF_ISP_BASE + 0x0000017C))
#define CIF_ISP_CC_COEFF_4          ((CIF_ISP_BASE + 0x00000180))
#define CIF_ISP_CC_COEFF_5          ((CIF_ISP_BASE + 0x00000184))
#define CIF_ISP_CC_COEFF_6          ((CIF_ISP_BASE + 0x00000188))
#define CIF_ISP_CC_COEFF_7          ((CIF_ISP_BASE + 0x0000018C))
#define CIF_ISP_CC_COEFF_8          ((CIF_ISP_BASE + 0x00000190))
#define CIF_ISP_OUT_H_OFFS          ((CIF_ISP_BASE + 0x00000194))
#define CIF_ISP_OUT_V_OFFS          ((CIF_ISP_BASE + 0x00000198))
#define CIF_ISP_OUT_H_SIZE          ((CIF_ISP_BASE + 0x0000019C))
#define CIF_ISP_OUT_V_SIZE          ((CIF_ISP_BASE + 0x000001A0))
#define CIF_ISP_DEMOSAIC            ((CIF_ISP_BASE + 0x000001A4))
#define CIF_ISP_FLAGS_SHD           ((CIF_ISP_BASE + 0x000001A8))
#define CIF_ISP_OUT_H_OFFS_SHD      ((CIF_ISP_BASE + 0x000001AC))
#define CIF_ISP_OUT_V_OFFS_SHD      ((CIF_ISP_BASE + 0x000001B0))
#define CIF_ISP_OUT_H_SIZE_SHD      ((CIF_ISP_BASE + 0x000001B4))
#define CIF_ISP_OUT_V_SIZE_SHD      ((CIF_ISP_BASE + 0x000001B8))
#define CIF_ISP_IMSC                ((CIF_ISP_BASE + 0x000001BC))
#define CIF_ISP_RIS                 ((CIF_ISP_BASE + 0x000001C0))
#define CIF_ISP_MIS                 ((CIF_ISP_BASE + 0x000001C4))
#define CIF_ISP_ICR                 ((CIF_ISP_BASE + 0x000001C8))
#define CIF_ISP_ISR                 ((CIF_ISP_BASE + 0x000001CC))
#define CIF_ISP_CT_COEFF_0          ((CIF_ISP_BASE + 0x000001D0))
#define CIF_ISP_CT_COEFF_1          ((CIF_ISP_BASE + 0x000001D4))
#define CIF_ISP_CT_COEFF_2          ((CIF_ISP_BASE + 0x000001D8))
#define CIF_ISP_CT_COEFF_3          ((CIF_ISP_BASE + 0x000001DC))
#define CIF_ISP_CT_COEFF_4          ((CIF_ISP_BASE + 0x000001E0))
#define CIF_ISP_CT_COEFF_5          ((CIF_ISP_BASE + 0x000001E4))
#define CIF_ISP_CT_COEFF_6          ((CIF_ISP_BASE + 0x000001E8))
#define CIF_ISP_CT_COEFF_7          ((CIF_ISP_BASE + 0x000001EC))
#define CIF_ISP_CT_COEFF_8          ((CIF_ISP_BASE + 0x000001F0))
#define CIF_ISP_GAMMA_OUT_MODE      ((CIF_ISP_BASE + 0x000001F4))
#define CIF_ISP_GAMMA_OUT_Y_0       ((CIF_ISP_BASE + 0x000001F8))
#define CIF_ISP_GAMMA_OUT_Y_1       ((CIF_ISP_BASE + 0x000001FC))
#define CIF_ISP_GAMMA_OUT_Y_2       ((CIF_ISP_BASE + 0x00000200))
#define CIF_ISP_GAMMA_OUT_Y_3       ((CIF_ISP_BASE + 0x00000204))
#define CIF_ISP_GAMMA_OUT_Y_4       ((CIF_ISP_BASE + 0x00000208))
#define CIF_ISP_GAMMA_OUT_Y_5       ((CIF_ISP_BASE + 0x0000020C))
#define CIF_ISP_GAMMA_OUT_Y_6       ((CIF_ISP_BASE + 0x00000210))
#define CIF_ISP_GAMMA_OUT_Y_7       ((CIF_ISP_BASE + 0x00000214))
#define CIF_ISP_GAMMA_OUT_Y_8       ((CIF_ISP_BASE + 0x00000218))
#define CIF_ISP_GAMMA_OUT_Y_9       ((CIF_ISP_BASE + 0x0000021C))
#define CIF_ISP_GAMMA_OUT_Y_10      ((CIF_ISP_BASE + 0x00000220))
#define CIF_ISP_GAMMA_OUT_Y_11      ((CIF_ISP_BASE + 0x00000224))
#define CIF_ISP_GAMMA_OUT_Y_12      ((CIF_ISP_BASE + 0x00000228))
#define CIF_ISP_GAMMA_OUT_Y_13      ((CIF_ISP_BASE + 0x0000022C))
#define CIF_ISP_GAMMA_OUT_Y_14      ((CIF_ISP_BASE + 0x00000230))
#define CIF_ISP_GAMMA_OUT_Y_15      ((CIF_ISP_BASE + 0x00000234))
#define CIF_ISP_GAMMA_OUT_Y_16      ((CIF_ISP_BASE + 0x00000238))
#define CIF_ISP_ERR                 ((CIF_ISP_BASE + 0x0000023C))
#define CIF_ISP_ERR_CLR             ((CIF_ISP_BASE + 0x00000240))
#define CIF_ISP_FRAME_COUNT         ((CIF_ISP_BASE + 0x00000244))
#define CIF_ISP_CT_OFFSET_R         ((CIF_ISP_BASE + 0x00000248))
#define CIF_ISP_CT_OFFSET_G         ((CIF_ISP_BASE + 0x0000024C))
#define CIF_ISP_CT_OFFSET_B         ((CIF_ISP_BASE + 0x00000250))

#define CIF_ISP_FLASH_BASE          (0x00000660)
#define CIF_ISP_FLASH_CMD           ((CIF_ISP_FLASH_BASE + 0x00000000))
#define CIF_ISP_FLASH_CONFIG        ((CIF_ISP_FLASH_BASE + 0x00000004))
#define CIF_ISP_FLASH_PREDIV        ((CIF_ISP_FLASH_BASE + 0x00000008))
#define CIF_ISP_FLASH_DELAY         ((CIF_ISP_FLASH_BASE + 0x0000000C))
#define CIF_ISP_FLASH_TIME          ((CIF_ISP_FLASH_BASE + 0x00000010))
#define CIF_ISP_FLASH_MAXP          ((CIF_ISP_FLASH_BASE + 0x00000014))

#define CIF_ISP_SH_BASE             (0x00000680)
#define CIF_ISP_SH_CTRL             ((CIF_ISP_SH_BASE + 0x00000000))
#define CIF_ISP_SH_PREDIV           ((CIF_ISP_SH_BASE + 0x00000004))
#define CIF_ISP_SH_DELAY            ((CIF_ISP_SH_BASE + 0x00000008))
#define CIF_ISP_SH_TIME             ((CIF_ISP_SH_BASE + 0x0000000C))

#define CIF_C_PROC_BASE             (0x00000800)
#define CIF_C_PROC_CTRL             ((CIF_C_PROC_BASE + 0x00000000))
#define CIF_C_PROC_CONTRAST         ((CIF_C_PROC_BASE + 0x00000004))
#define CIF_C_PROC_BRIGHTNESS       ((CIF_C_PROC_BASE + 0x00000008))
#define CIF_C_PROC_SATURATION       ((CIF_C_PROC_BASE + 0x0000000C))
#define CIF_C_PROC_HUE              ((CIF_C_PROC_BASE + 0x00000010))

#define CIF_DUAL_CROP_BASE          (0x00000880)
#define CIF_DUAL_CROP_CTRL          (CIF_DUAL_CROP_BASE + 0x00000000)
#define CIF_DUAL_CROP_M_H_OFFS      (CIF_DUAL_CROP_BASE + 0x00000004)
#define CIF_DUAL_CROP_M_V_OFFS      (CIF_DUAL_CROP_BASE + 0x00000008)
#define CIF_DUAL_CROP_M_H_SIZE      (CIF_DUAL_CROP_BASE + 0x0000000C)
#define CIF_DUAL_CROP_M_V_SIZE      (CIF_DUAL_CROP_BASE + 0x00000010)
#define CIF_DUAL_CROP_S_H_OFFS      (CIF_DUAL_CROP_BASE + 0x00000014)
#define CIF_DUAL_CROP_S_V_OFFS      (CIF_DUAL_CROP_BASE + 0x00000018)
#define CIF_DUAL_CROP_S_H_SIZE      (CIF_DUAL_CROP_BASE + 0x0000001C)
#define CIF_DUAL_CROP_S_V_SIZE      (CIF_DUAL_CROP_BASE + 0x00000020)
#define CIF_DUAL_CROP_M_H_OFFS_SHD  (CIF_DUAL_CROP_BASE + 0x00000024)
#define CIF_DUAL_CROP_M_V_OFFS_SHD  (CIF_DUAL_CROP_BASE + 0x00000028)
#define CIF_DUAL_CROP_M_H_SIZE_SHD  (CIF_DUAL_CROP_BASE + 0x0000002C)
#define CIF_DUAL_CROP_M_V_SIZE_SHD  (CIF_DUAL_CROP_BASE + 0x00000030)
#define CIF_DUAL_CROP_S_H_OFFS_SHD  (CIF_DUAL_CROP_BASE + 0x00000034)
#define CIF_DUAL_CROP_S_V_OFFS_SHD  (CIF_DUAL_CROP_BASE + 0x00000038)
#define CIF_DUAL_CROP_S_H_SIZE_SHD  (CIF_DUAL_CROP_BASE + 0x0000003C)
#define CIF_DUAL_CROP_S_V_SIZE_SHD	\
	(CIF_DUAL_CROP_BASE + 0x00000040)

#define CIF_MRSZ_BASE               (0x00000C00)
#define CIF_MRSZ_CTRL               ((CIF_MRSZ_BASE + 0x00000000))
#define CIF_MRSZ_SCALE_HY           ((CIF_MRSZ_BASE + 0x00000004))
#define CIF_MRSZ_SCALE_HCB          ((CIF_MRSZ_BASE + 0x00000008))
#define CIF_MRSZ_SCALE_HCR          ((CIF_MRSZ_BASE + 0x0000000C))
#define CIF_MRSZ_SCALE_VY           ((CIF_MRSZ_BASE + 0x00000010))
#define CIF_MRSZ_SCALE_VC           ((CIF_MRSZ_BASE + 0x00000014))
#define CIF_MRSZ_PHASE_HY           ((CIF_MRSZ_BASE + 0x00000018))
#define CIF_MRSZ_PHASE_HC           ((CIF_MRSZ_BASE + 0x0000001C))
#define CIF_MRSZ_PHASE_VY           ((CIF_MRSZ_BASE + 0x00000020))
#define CIF_MRSZ_PHASE_VC           ((CIF_MRSZ_BASE + 0x00000024))
#define CIF_MRSZ_SCALE_LUT_ADDR     ((CIF_MRSZ_BASE + 0x00000028))
#define CIF_MRSZ_SCALE_LUT          ((CIF_MRSZ_BASE + 0x0000002C))
#define CIF_MRSZ_CTRL_SHD           ((CIF_MRSZ_BASE + 0x00000030))
#define CIF_MRSZ_SCALE_HY_SHD       ((CIF_MRSZ_BASE + 0x00000034))
#define CIF_MRSZ_SCALE_HCB_SHD      ((CIF_MRSZ_BASE + 0x00000038))
#define CIF_MRSZ_SCALE_HCR_SHD      ((CIF_MRSZ_BASE + 0x0000003C))
#define CIF_MRSZ_SCALE_VY_SHD       ((CIF_MRSZ_BASE + 0x00000040))
#define CIF_MRSZ_SCALE_VC_SHD       ((CIF_MRSZ_BASE + 0x00000044))
#define CIF_MRSZ_PHASE_HY_SHD       ((CIF_MRSZ_BASE + 0x00000048))
#define CIF_MRSZ_PHASE_HC_SHD       ((CIF_MRSZ_BASE + 0x0000004C))
#define CIF_MRSZ_PHASE_VY_SHD       ((CIF_MRSZ_BASE + 0x00000050))
#define CIF_MRSZ_PHASE_VC_SHD       ((CIF_MRSZ_BASE + 0x00000054))

#define CIF_SRSZ_BASE               (0x00001000)
#define CIF_SRSZ_CTRL               ((CIF_SRSZ_BASE + 0x00000000))
#define CIF_SRSZ_SCALE_HY           ((CIF_SRSZ_BASE + 0x00000004))
#define CIF_SRSZ_SCALE_HCB          ((CIF_SRSZ_BASE + 0x00000008))
#define CIF_SRSZ_SCALE_HCR          ((CIF_SRSZ_BASE + 0x0000000C))
#define CIF_SRSZ_SCALE_VY           ((CIF_SRSZ_BASE + 0x00000010))
#define CIF_SRSZ_SCALE_VC           ((CIF_SRSZ_BASE + 0x00000014))
#define CIF_SRSZ_PHASE_HY           ((CIF_SRSZ_BASE + 0x00000018))
#define CIF_SRSZ_PHASE_HC           ((CIF_SRSZ_BASE + 0x0000001C))
#define CIF_SRSZ_PHASE_VY           ((CIF_SRSZ_BASE + 0x00000020))
#define CIF_SRSZ_PHASE_VC           ((CIF_SRSZ_BASE + 0x00000024))
#define CIF_SRSZ_SCALE_LUT_ADDR     ((CIF_SRSZ_BASE + 0x00000028))
#define CIF_SRSZ_SCALE_LUT          ((CIF_SRSZ_BASE + 0x0000002C))
#define CIF_SRSZ_CTRL_SHD           ((CIF_SRSZ_BASE + 0x00000030))
#define CIF_SRSZ_SCALE_HY_SHD       ((CIF_SRSZ_BASE + 0x00000034))
#define CIF_SRSZ_SCALE_HCB_SHD      ((CIF_SRSZ_BASE + 0x00000038))
#define CIF_SRSZ_SCALE_HCR_SHD      ((CIF_SRSZ_BASE + 0x0000003C))
#define CIF_SRSZ_SCALE_VY_SHD       ((CIF_SRSZ_BASE + 0x00000040))
#define CIF_SRSZ_SCALE_VC_SHD       ((CIF_SRSZ_BASE + 0x00000044))
#define CIF_SRSZ_PHASE_HY_SHD       ((CIF_SRSZ_BASE + 0x00000048))
#define CIF_SRSZ_PHASE_HC_SHD       ((CIF_SRSZ_BASE + 0x0000004C))
#define CIF_SRSZ_PHASE_VY_SHD       ((CIF_SRSZ_BASE + 0x00000050))
#define CIF_SRSZ_PHASE_VC_SHD       ((CIF_SRSZ_BASE + 0x00000054))

#define CIF_MI_BASE                 (0x00001400)
#define CIF_MI_CTRL                 ((CIF_MI_BASE + 0x00000000))
#define CIF_MI_INIT                 ((CIF_MI_BASE + 0x00000004))
#define CIF_MI_MP_Y_BASE_AD_INIT    ((CIF_MI_BASE + 0x00000008))
#define CIF_MI_MP_Y_SIZE_INIT       ((CIF_MI_BASE + 0x0000000C))
#define CIF_MI_MP_Y_OFFS_CNT_INIT   ((CIF_MI_BASE + 0x00000010))
#define CIF_MI_MP_Y_OFFS_CNT_START  ((CIF_MI_BASE + 0x00000014))
#define CIF_MI_MP_Y_IRQ_OFFS_INIT   ((CIF_MI_BASE + 0x00000018))
#define CIF_MI_MP_CB_BASE_AD_INIT   ((CIF_MI_BASE + 0x0000001C))
#define CIF_MI_MP_CB_SIZE_INIT      ((CIF_MI_BASE + 0x00000020))
#define CIF_MI_MP_CB_OFFS_CNT_INIT  ((CIF_MI_BASE + 0x00000024))
#define CIF_MI_MP_CB_OFFS_CNT_START ((CIF_MI_BASE + 0x00000028))
#define CIF_MI_MP_CR_BASE_AD_INIT   ((CIF_MI_BASE + 0x0000002C))
#define CIF_MI_MP_CR_SIZE_INIT      ((CIF_MI_BASE + 0x00000030))
#define CIF_MI_MP_CR_OFFS_CNT_INIT  ((CIF_MI_BASE + 0x00000034))
#define CIF_MI_MP_CR_OFFS_CNT_START ((CIF_MI_BASE + 0x00000038))
#define CIF_MI_SP_Y_BASE_AD_INIT    ((CIF_MI_BASE + 0x0000003C))
#define CIF_MI_SP_Y_SIZE_INIT       ((CIF_MI_BASE + 0x00000040))
#define CIF_MI_SP_Y_OFFS_CNT_INIT   ((CIF_MI_BASE + 0x00000044))
#define CIF_MI_SP_Y_OFFS_CNT_START  ((CIF_MI_BASE + 0x00000048))
#define CIF_MI_SP_Y_LLENGTH         ((CIF_MI_BASE + 0x0000004C))
#define CIF_MI_SP_CB_BASE_AD_INIT   ((CIF_MI_BASE + 0x00000050))
#define CIF_MI_SP_CB_SIZE_INIT      ((CIF_MI_BASE + 0x00000054))
#define CIF_MI_SP_CB_OFFS_CNT_INIT  ((CIF_MI_BASE + 0x00000058))
#define CIF_MI_SP_CB_OFFS_CNT_START ((CIF_MI_BASE + 0x0000005C))
#define CIF_MI_SP_CR_BASE_AD_INIT   ((CIF_MI_BASE + 0x00000060))
#define CIF_MI_SP_CR_SIZE_INIT      ((CIF_MI_BASE + 0x00000064))
#define CIF_MI_SP_CR_OFFS_CNT_INIT  ((CIF_MI_BASE + 0x00000068))
#define CIF_MI_SP_CR_OFFS_CNT_START ((CIF_MI_BASE + 0x0000006C))
#define CIF_MI_BYTE_CNT             ((CIF_MI_BASE + 0x00000070))
#define CIF_MI_CTRL_SHD             ((CIF_MI_BASE + 0x00000074))
#define CIF_MI_MP_Y_BASE_AD_SHD     ((CIF_MI_BASE + 0x00000078))
#define CIF_MI_MP_Y_SIZE_SHD        ((CIF_MI_BASE + 0x0000007C))
#define CIF_MI_MP_Y_OFFS_CNT_SHD    ((CIF_MI_BASE + 0x00000080))
#define CIF_MI_MP_Y_IRQ_OFFS_SHD    ((CIF_MI_BASE + 0x00000084))
#define CIF_MI_MP_CB_BASE_AD_SHD    ((CIF_MI_BASE + 0x00000088))
#define CIF_MI_MP_CB_SIZE_SHD       ((CIF_MI_BASE + 0x0000008C))
#define CIF_MI_MP_CB_OFFS_CNT_SHD   ((CIF_MI_BASE + 0x00000090))
#define CIF_MI_MP_CR_BASE_AD_SHD    ((CIF_MI_BASE + 0x00000094))
#define CIF_MI_MP_CR_SIZE_SHD       ((CIF_MI_BASE + 0x00000098))
#define CIF_MI_MP_CR_OFFS_CNT_SHD   ((CIF_MI_BASE + 0x0000009C))
#define CIF_MI_SP_Y_BASE_AD_SHD     ((CIF_MI_BASE + 0x000000A0))
#define CIF_MI_SP_Y_SIZE_SHD        ((CIF_MI_BASE + 0x000000A4))
#define CIF_MI_SP_Y_OFFS_CNT_SHD    ((CIF_MI_BASE + 0x000000A8))
#define CIF_MI_SP_CB_BASE_AD_SHD    ((CIF_MI_BASE + 0x000000B0))
#define CIF_MI_SP_CB_SIZE_SHD       ((CIF_MI_BASE + 0x000000B4))
#define CIF_MI_SP_CB_OFFS_CNT_SHD   ((CIF_MI_BASE + 0x000000B8))
#define CIF_MI_SP_CR_BASE_AD_SHD    ((CIF_MI_BASE + 0x000000BC))
#define CIF_MI_SP_CR_SIZE_SHD       ((CIF_MI_BASE + 0x000000C0))
#define CIF_MI_SP_CR_OFFS_CNT_SHD   ((CIF_MI_BASE + 0x000000C4))
#define CIF_MI_DMA_Y_PIC_START_AD   ((CIF_MI_BASE + 0x000000C8))
#define CIF_MI_DMA_Y_PIC_WIDTH      ((CIF_MI_BASE + 0x000000CC))
#define CIF_MI_DMA_Y_LLENGTH        ((CIF_MI_BASE + 0x000000D0))
#define CIF_MI_DMA_Y_PIC_SIZE       ((CIF_MI_BASE + 0x000000D4))
#define CIF_MI_DMA_CB_PIC_START_AD  ((CIF_MI_BASE + 0x000000D8))
#define CIF_MI_DMA_CR_PIC_START_AD  ((CIF_MI_BASE + 0x000000E8))
#define CIF_MI_IMSC                 ((CIF_MI_BASE + 0x000000F8))
#define CIF_MI_RIS                  ((CIF_MI_BASE + 0x000000FC))
#define CIF_MI_MIS                  ((CIF_MI_BASE + 0x00000100))
#define CIF_MI_ICR                  ((CIF_MI_BASE + 0x00000104))
#define CIF_MI_ISR                  ((CIF_MI_BASE + 0x00000108))
#define CIF_MI_STATUS               ((CIF_MI_BASE + 0x0000010C))
#define CIF_MI_STATUS_CLR           ((CIF_MI_BASE + 0x00000110))
#define CIF_MI_SP_Y_PIC_WIDTH       ((CIF_MI_BASE + 0x00000114))
#define CIF_MI_SP_Y_PIC_HEIGHT      ((CIF_MI_BASE + 0x00000118))
#define CIF_MI_SP_Y_PIC_SIZE        ((CIF_MI_BASE + 0x0000011C))
#define CIF_MI_DMA_CTRL             ((CIF_MI_BASE + 0x00000120))
#define CIF_MI_DMA_START            ((CIF_MI_BASE + 0x00000124))
#define CIF_MI_DMA_STATUS           ((CIF_MI_BASE + 0x00000128))
#define CIF_MI_PIXEL_COUNT          ((CIF_MI_BASE + 0x0000012C))
#define CIF_MI_MP_Y_BASE_AD_INIT2   ((CIF_MI_BASE + 0x00000130))
#define CIF_MI_MP_CB_BASE_AD_INIT2  ((CIF_MI_BASE + 0x00000134))
#define CIF_MI_MP_CR_BASE_AD_INIT2  ((CIF_MI_BASE + 0x00000138))
#define CIF_MI_SP_Y_BASE_AD_INIT2   ((CIF_MI_BASE + 0x0000013C))
#define CIF_MI_SP_CB_BASE_AD_INIT2  ((CIF_MI_BASE + 0x00000140))
#define CIF_MI_SP_CR_BASE_AD_INIT2  ((CIF_MI_BASE + 0x00000144))
#define CIF_MI_XTD_FORMAT_CTRL      ((CIF_MI_BASE + 0x00000148))

#define CIF_JPE_BASE                (0x00001800)
#define CIF_JPE_GEN_HEADER          ((CIF_JPE_BASE + 0x00000000))
#define CIF_JPE_ENCODE              ((CIF_JPE_BASE + 0x00000004))
#define CIF_JPE_INIT                ((CIF_JPE_BASE + 0x00000008))
#define CIF_JPE_Y_SCALE_EN          ((CIF_JPE_BASE + 0x0000000C))
#define CIF_JPE_CBCR_SCALE_EN       ((CIF_JPE_BASE + 0x00000010))
#define CIF_JPE_TABLE_FLUSH         ((CIF_JPE_BASE + 0x00000014))
#define CIF_JPE_ENC_HSIZE           ((CIF_JPE_BASE + 0x00000018))
#define CIF_JPE_ENC_VSIZE           ((CIF_JPE_BASE + 0x0000001C))
#define CIF_JPE_PIC_FORMAT          ((CIF_JPE_BASE + 0x00000020))
#define CIF_JPE_RESTART_INTERVAL    ((CIF_JPE_BASE + 0x00000024))
#define CIF_JPE_TQ_Y_SELECT         ((CIF_JPE_BASE + 0x00000028))
#define CIF_JPE_TQ_U_SELECT         ((CIF_JPE_BASE + 0x0000002C))
#define CIF_JPE_TQ_V_SELECT         ((CIF_JPE_BASE + 0x00000030))
#define CIF_JPE_DC_TABLE_SELECT     ((CIF_JPE_BASE + 0x00000034))
#define CIF_JPE_AC_TABLE_SELECT     ((CIF_JPE_BASE + 0x00000038))
#define CIF_JPE_TABLE_DATA          ((CIF_JPE_BASE + 0x0000003C))
#define CIF_JPE_TABLE_ID            ((CIF_JPE_BASE + 0x00000040))
#define CIF_JPE_TAC0_LEN            ((CIF_JPE_BASE + 0x00000044))
#define CIF_JPE_TDC0_LEN            ((CIF_JPE_BASE + 0x00000048))
#define CIF_JPE_TAC1_LEN            ((CIF_JPE_BASE + 0x0000004C))
#define CIF_JPE_TDC1_LEN            ((CIF_JPE_BASE + 0x00000050))
#define CIF_JPE_ENCODER_BUSY        ((CIF_JPE_BASE + 0x00000058))
#define CIF_JPE_HEADER_MODE         ((CIF_JPE_BASE + 0x0000005C))
#define CIF_JPE_ENCODE_MODE         ((CIF_JPE_BASE + 0x00000060))
#define CIF_JPE_DEBUG               ((CIF_JPE_BASE + 0x00000064))
#define CIF_JPE_ERROR_IMSC          ((CIF_JPE_BASE + 0x00000068))
#define CIF_JPE_ERROR_RIS           ((CIF_JPE_BASE + 0x0000006C))
#define CIF_JPE_ERROR_MIS           ((CIF_JPE_BASE + 0x00000070))
#define CIF_JPE_ERROR_ICR           ((CIF_JPE_BASE + 0x00000074))
#define CIF_JPE_ERROR_ISR           ((CIF_JPE_BASE + 0x00000078))
#define CIF_JPE_STATUS_IMSC         ((CIF_JPE_BASE + 0x0000007C))
#define CIF_JPE_STATUS_RIS          ((CIF_JPE_BASE + 0x00000080))
#define CIF_JPE_STATUS_MIS          ((CIF_JPE_BASE + 0x00000084))
#define CIF_JPE_STATUS_ICR          ((CIF_JPE_BASE + 0x00000088))
#define CIF_JPE_STATUS_ISR          ((CIF_JPE_BASE + 0x0000008C))
#define CIF_JPE_CONFIG              ((CIF_JPE_BASE + 0x00000090))

#define CIF_SMIA_BASE               (0x00001A00)
#define CIF_SMIA_CTRL               ((CIF_SMIA_BASE + 0x00000000))
#define CIF_SMIA_STATUS             ((CIF_SMIA_BASE + 0x00000004))
#define CIF_SMIA_IMSC               ((CIF_SMIA_BASE + 0x00000008))
#define CIF_SMIA_RIS                ((CIF_SMIA_BASE + 0x0000000C))
#define CIF_SMIA_MIS                ((CIF_SMIA_BASE + 0x00000010))
#define CIF_SMIA_ICR                ((CIF_SMIA_BASE + 0x00000014))
#define CIF_SMIA_ISR                ((CIF_SMIA_BASE + 0x00000018))
#define CIF_SMIA_DATA_FORMAT_SEL    ((CIF_SMIA_BASE + 0x0000001C))
#define CIF_SMIA_SOF_EMB_DATA_LINES ((CIF_SMIA_BASE + 0x00000020))
#define CIF_SMIA_EMB_HSTART         ((CIF_SMIA_BASE + 0x00000024))
#define CIF_SMIA_EMB_HSIZE          ((CIF_SMIA_BASE + 0x00000028))
#define CIF_SMIA_EMB_VSTART         ((CIF_SMIA_BASE + 0x0000002c))
#define CIF_SMIA_NUM_LINES          ((CIF_SMIA_BASE + 0x00000030))
#define CIF_SMIA_EMB_DATA_FIFO      ((CIF_SMIA_BASE + 0x00000034))
#define CIF_SMIA_EMB_DATA_WATERMARK ((CIF_SMIA_BASE + 0x00000038))

#define CIF_MIPI_BASE               (0x00001C00)
#define CIF_MIPI_CTRL               ((CIF_MIPI_BASE + 0x00000000))
#define CIF_MIPI_STATUS             ((CIF_MIPI_BASE + 0x00000004))
#define CIF_MIPI_IMSC               ((CIF_MIPI_BASE + 0x00000008))
#define CIF_MIPI_RIS                ((CIF_MIPI_BASE + 0x0000000C))
#define CIF_MIPI_MIS                ((CIF_MIPI_BASE + 0x00000010))
#define CIF_MIPI_ICR                ((CIF_MIPI_BASE + 0x00000014))
#define CIF_MIPI_ISR                ((CIF_MIPI_BASE + 0x00000018))
#define CIF_MIPI_CUR_DATA_ID        ((CIF_MIPI_BASE + 0x0000001C))
#define CIF_MIPI_IMG_DATA_SEL       ((CIF_MIPI_BASE + 0x00000020))
#define CIF_MIPI_ADD_DATA_SEL_1     ((CIF_MIPI_BASE + 0x00000024))
#define CIF_MIPI_ADD_DATA_SEL_2     ((CIF_MIPI_BASE + 0x00000028))
#define CIF_MIPI_ADD_DATA_SEL_3     ((CIF_MIPI_BASE + 0x0000002C))
#define CIF_MIPI_ADD_DATA_SEL_4     ((CIF_MIPI_BASE + 0x00000030))
#define CIF_MIPI_ADD_DATA_FIFO      ((CIF_MIPI_BASE + 0x00000034))
#define CIF_MIPI_FIFO_FILL_LEVEL    ((CIF_MIPI_BASE + 0x00000038))
#define CIF_MIPI_COMPRESSED_MODE    ((CIF_MIPI_BASE + 0x0000003C))
#define CIF_MIPI_FRAME              ((CIF_MIPI_BASE + 0x00000040))
#define CIF_MIPI_GEN_SHORT_DT       ((CIF_MIPI_BASE + 0x00000044))
#define CIF_MIPI_GEN_SHORT_8_9      ((CIF_MIPI_BASE + 0x00000048))
#define CIF_MIPI_GEN_SHORT_A_B      ((CIF_MIPI_BASE + 0x0000004C))
#define CIF_MIPI_GEN_SHORT_C_D      ((CIF_MIPI_BASE + 0x00000050))
#define CIF_MIPI_GEN_SHORT_E_F      ((CIF_MIPI_BASE + 0x00000054))

#define CIF_ISP_AFM_BASE            (0x00002000)
#define CIF_ISP_AFM_CTRL            ((CIF_ISP_AFM_BASE + 0x00000000))
#define CIF_ISP_AFM_LT_A            ((CIF_ISP_AFM_BASE + 0x00000004))
#define CIF_ISP_AFM_RB_A            ((CIF_ISP_AFM_BASE + 0x00000008))
#define CIF_ISP_AFM_LT_B            ((CIF_ISP_AFM_BASE + 0x0000000C))
#define CIF_ISP_AFM_RB_B            ((CIF_ISP_AFM_BASE + 0x00000010))
#define CIF_ISP_AFM_LT_C            ((CIF_ISP_AFM_BASE + 0x00000014))
#define CIF_ISP_AFM_RB_C            ((CIF_ISP_AFM_BASE + 0x00000018))
#define CIF_ISP_AFM_THRES           ((CIF_ISP_AFM_BASE + 0x0000001C))
#define CIF_ISP_AFM_VAR_SHIFT       ((CIF_ISP_AFM_BASE + 0x00000020))
#define CIF_ISP_AFM_SUM_A           ((CIF_ISP_AFM_BASE + 0x00000024))
#define CIF_ISP_AFM_SUM_B           ((CIF_ISP_AFM_BASE + 0x00000028))
#define CIF_ISP_AFM_SUM_C           ((CIF_ISP_AFM_BASE + 0x0000002C))
#define CIF_ISP_AFM_LUM_A           ((CIF_ISP_AFM_BASE + 0x00000030))
#define CIF_ISP_AFM_LUM_B           ((CIF_ISP_AFM_BASE + 0x00000034))
#define CIF_ISP_AFM_LUM_C           ((CIF_ISP_AFM_BASE + 0x00000038))

#define CIF_ISP_LSC_BASE            (0x00002200)
#define CIF_ISP_LSC_CTRL            ((CIF_ISP_LSC_BASE + 0x00000000))
#define CIF_ISP_LSC_R_TABLE_ADDR    ((CIF_ISP_LSC_BASE + 0x00000004))
#define CIF_ISP_LSC_GR_TABLE_ADDR   ((CIF_ISP_LSC_BASE + 0x00000008))
#define CIF_ISP_LSC_B_TABLE_ADDR    ((CIF_ISP_LSC_BASE + 0x0000000C))
#define CIF_ISP_LSC_GB_TABLE_ADDR   ((CIF_ISP_LSC_BASE + 0x00000010))
#define CIF_ISP_LSC_R_TABLE_DATA    ((CIF_ISP_LSC_BASE + 0x00000014))
#define CIF_ISP_LSC_GR_TABLE_DATA   ((CIF_ISP_LSC_BASE + 0x00000018))
#define CIF_ISP_LSC_B_TABLE_DATA    ((CIF_ISP_LSC_BASE + 0x0000001C))
#define CIF_ISP_LSC_GB_TABLE_DATA   ((CIF_ISP_LSC_BASE + 0x00000020))
#define CIF_ISP_LSC_XGRAD_01        ((CIF_ISP_LSC_BASE + 0x00000024))
#define CIF_ISP_LSC_XGRAD_23        ((CIF_ISP_LSC_BASE + 0x00000028))
#define CIF_ISP_LSC_XGRAD_45        ((CIF_ISP_LSC_BASE + 0x0000002C))
#define CIF_ISP_LSC_XGRAD_67        ((CIF_ISP_LSC_BASE + 0x00000030))
#define CIF_ISP_LSC_YGRAD_01        ((CIF_ISP_LSC_BASE + 0x00000034))
#define CIF_ISP_LSC_YGRAD_23        ((CIF_ISP_LSC_BASE + 0x00000038))
#define CIF_ISP_LSC_YGRAD_45        ((CIF_ISP_LSC_BASE + 0x0000003C))
#define CIF_ISP_LSC_YGRAD_67        ((CIF_ISP_LSC_BASE + 0x00000040))
#define CIF_ISP_LSC_XSIZE_01        ((CIF_ISP_LSC_BASE + 0x00000044))
#define CIF_ISP_LSC_XSIZE_23        ((CIF_ISP_LSC_BASE + 0x00000048))
#define CIF_ISP_LSC_XSIZE_45        ((CIF_ISP_LSC_BASE + 0x0000004C))
#define CIF_ISP_LSC_XSIZE_67        ((CIF_ISP_LSC_BASE + 0x00000050))
#define CIF_ISP_LSC_YSIZE_01        ((CIF_ISP_LSC_BASE + 0x00000054))
#define CIF_ISP_LSC_YSIZE_23        ((CIF_ISP_LSC_BASE + 0x00000058))
#define CIF_ISP_LSC_YSIZE_45        ((CIF_ISP_LSC_BASE + 0x0000005C))
#define CIF_ISP_LSC_YSIZE_67        ((CIF_ISP_LSC_BASE + 0x00000060))
#define CIF_ISP_LSC_TABLE_SEL       ((CIF_ISP_LSC_BASE + 0x00000064))
#define CIF_ISP_LSC_STATUS          ((CIF_ISP_LSC_BASE + 0x00000068))

#define CIF_ISP_IS_BASE             (0x00002300)
#define CIF_ISP_IS_CTRL             ((CIF_ISP_IS_BASE + 0x00000000))
#define CIF_ISP_IS_RECENTER         ((CIF_ISP_IS_BASE + 0x00000004))
#define CIF_ISP_IS_H_OFFS           ((CIF_ISP_IS_BASE + 0x00000008))
#define CIF_ISP_IS_V_OFFS           ((CIF_ISP_IS_BASE + 0x0000000C))
#define CIF_ISP_IS_H_SIZE           ((CIF_ISP_IS_BASE + 0x00000010))
#define CIF_ISP_IS_V_SIZE           ((CIF_ISP_IS_BASE + 0x00000014))
#define CIF_ISP_IS_MAX_DX           ((CIF_ISP_IS_BASE + 0x00000018))
#define CIF_ISP_IS_MAX_DY           ((CIF_ISP_IS_BASE + 0x0000001C))
#define CIF_ISP_IS_DISPLACE         ((CIF_ISP_IS_BASE + 0x00000020))
#define CIF_ISP_IS_H_OFFS_SHD       ((CIF_ISP_IS_BASE + 0x00000024))
#define CIF_ISP_IS_V_OFFS_SHD       ((CIF_ISP_IS_BASE + 0x00000028))
#define CIF_ISP_IS_H_SIZE_SHD       ((CIF_ISP_IS_BASE + 0x0000002C))
#define CIF_ISP_IS_V_SIZE_SHD       ((CIF_ISP_IS_BASE + 0x00000030))

#define CIF_ISP_HIST_BASE           (0x00002400)

#define CIF_ISP_HIST_PROP           ((CIF_ISP_HIST_BASE + 0x00000000))
#define CIF_ISP_HIST_H_OFFS         ((CIF_ISP_HIST_BASE + 0x00000004))
#define CIF_ISP_HIST_V_OFFS         ((CIF_ISP_HIST_BASE + 0x00000008))
#define CIF_ISP_HIST_H_SIZE         ((CIF_ISP_HIST_BASE + 0x0000000C))
#define CIF_ISP_HIST_V_SIZE         ((CIF_ISP_HIST_BASE + 0x00000010))
#define CIF_ISP_HIST_BIN_0          ((CIF_ISP_HIST_BASE + 0x00000014))
#define CIF_ISP_HIST_BIN_1          ((CIF_ISP_HIST_BASE + 0x00000018))
#define CIF_ISP_HIST_BIN_2          ((CIF_ISP_HIST_BASE + 0x0000001C))
#define CIF_ISP_HIST_BIN_3          ((CIF_ISP_HIST_BASE + 0x00000020))
#define CIF_ISP_HIST_BIN_4          ((CIF_ISP_HIST_BASE + 0x00000024))
#define CIF_ISP_HIST_BIN_5          ((CIF_ISP_HIST_BASE + 0x00000028))
#define CIF_ISP_HIST_BIN_6          ((CIF_ISP_HIST_BASE + 0x0000002C))
#define CIF_ISP_HIST_BIN_7          ((CIF_ISP_HIST_BASE + 0x00000030))
#define CIF_ISP_HIST_BIN_8          ((CIF_ISP_HIST_BASE + 0x00000034))
#define CIF_ISP_HIST_BIN_9          ((CIF_ISP_HIST_BASE + 0x00000038))
#define CIF_ISP_HIST_BIN_10         ((CIF_ISP_HIST_BASE + 0x0000003C))
#define CIF_ISP_HIST_BIN_11         ((CIF_ISP_HIST_BASE + 0x00000040))
#define CIF_ISP_HIST_BIN_12         ((CIF_ISP_HIST_BASE + 0x00000044))
#define CIF_ISP_HIST_BIN_13         ((CIF_ISP_HIST_BASE + 0x00000048))
#define CIF_ISP_HIST_BIN_14         ((CIF_ISP_HIST_BASE + 0x0000004C))
#define CIF_ISP_HIST_BIN_15         ((CIF_ISP_HIST_BASE + 0x00000050))
#define CIF_ISP_HIST_WEIGHT_00TO30  ((CIF_ISP_HIST_BASE + 0x00000054))
#define CIF_ISP_HIST_WEIGHT_40TO21  ((CIF_ISP_HIST_BASE + 0x00000058))
#define CIF_ISP_HIST_WEIGHT_31TO12  ((CIF_ISP_HIST_BASE + 0x0000005C))
#define CIF_ISP_HIST_WEIGHT_22TO03  ((CIF_ISP_HIST_BASE + 0x00000060))
#define CIF_ISP_HIST_WEIGHT_13TO43  ((CIF_ISP_HIST_BASE + 0x00000064))
#define CIF_ISP_HIST_WEIGHT_04TO34  ((CIF_ISP_HIST_BASE + 0x00000068))
#define CIF_ISP_HIST_WEIGHT_44      ((CIF_ISP_HIST_BASE + 0x0000006C))

#define CIF_ISP_FILT_BASE           (0x00002500)
#define CIF_ISP_FILT_MODE           ((CIF_ISP_FILT_BASE + 0x00000000))
#define CIF_ISP_FILT_THRESH_BL0     ((CIF_ISP_FILT_BASE + 0x00000028))
#define CIF_ISP_FILT_THRESH_BL1     ((CIF_ISP_FILT_BASE + 0x0000002c))
#define CIF_ISP_FILT_THRESH_SH0     ((CIF_ISP_FILT_BASE + 0x00000030))
#define CIF_ISP_FILT_THRESH_SH1     ((CIF_ISP_FILT_BASE + 0x00000034))
#define CIF_ISP_FILT_LUM_WEIGHT     ((CIF_ISP_FILT_BASE + 0x00000038))
#define CIF_ISP_FILT_FAC_SH1        ((CIF_ISP_FILT_BASE + 0x0000003c))
#define CIF_ISP_FILT_FAC_SH0        ((CIF_ISP_FILT_BASE + 0x00000040))
#define CIF_ISP_FILT_FAC_MID        ((CIF_ISP_FILT_BASE + 0x00000044))
#define CIF_ISP_FILT_FAC_BL0        ((CIF_ISP_FILT_BASE + 0x00000048))
#define CIF_ISP_FILT_FAC_BL1        ((CIF_ISP_FILT_BASE + 0x0000004C))

#define CIF_ISP_CAC_BASE            (0x00002580)
#define CIF_ISP_CAC_CTRL            (CIF_ISP_CAC_BASE + 0x00000000)
#define CIF_ISP_CAC_COUNT_START     (CIF_ISP_CAC_BASE + 0x00000004)
#define CIF_ISP_CAC_A               (CIF_ISP_CAC_BASE + 0x00000008)
#define CIF_ISP_CAC_B               (CIF_ISP_CAC_BASE + 0x0000000C)
#define CIF_ISP_CAC_C               (CIF_ISP_CAC_BASE + 0x00000010)
#define CIF_ISP_X_NORM              (CIF_ISP_CAC_BASE + 0x00000014)
#define CIF_ISP_Y_NORM              (CIF_ISP_CAC_BASE + 0x00000018)

#define CIF_ISP_EXP_BASE            (0x00002600)
#define CIF_ISP_EXP_CTRL            ((CIF_ISP_EXP_BASE + 0x00000000))
#define CIF_ISP_EXP_H_OFFSET        ((CIF_ISP_EXP_BASE + 0x00000004))
#define CIF_ISP_EXP_V_OFFSET        ((CIF_ISP_EXP_BASE + 0x00000008))
#define CIF_ISP_EXP_H_SIZE          ((CIF_ISP_EXP_BASE + 0x0000000C))
#define CIF_ISP_EXP_V_SIZE          ((CIF_ISP_EXP_BASE + 0x00000010))
#define CIF_ISP_EXP_MEAN_00         ((CIF_ISP_EXP_BASE + 0x00000014))
#define CIF_ISP_EXP_MEAN_10         ((CIF_ISP_EXP_BASE + 0x00000018))
#define CIF_ISP_EXP_MEAN_20         ((CIF_ISP_EXP_BASE + 0x0000001c))
#define CIF_ISP_EXP_MEAN_30         ((CIF_ISP_EXP_BASE + 0x00000020))
#define CIF_ISP_EXP_MEAN_40         ((CIF_ISP_EXP_BASE + 0x00000024))
#define CIF_ISP_EXP_MEAN_01         ((CIF_ISP_EXP_BASE + 0x00000028))
#define CIF_ISP_EXP_MEAN_11         ((CIF_ISP_EXP_BASE + 0x0000002c))
#define CIF_ISP_EXP_MEAN_21         ((CIF_ISP_EXP_BASE + 0x00000030))
#define CIF_ISP_EXP_MEAN_31         ((CIF_ISP_EXP_BASE + 0x00000034))
#define CIF_ISP_EXP_MEAN_41         ((CIF_ISP_EXP_BASE + 0x00000038))
#define CIF_ISP_EXP_MEAN_02         ((CIF_ISP_EXP_BASE + 0x0000003c))
#define CIF_ISP_EXP_MEAN_12         ((CIF_ISP_EXP_BASE + 0x00000040))
#define CIF_ISP_EXP_MEAN_22         ((CIF_ISP_EXP_BASE + 0x00000044))
#define CIF_ISP_EXP_MEAN_32         ((CIF_ISP_EXP_BASE + 0x00000048))
#define CIF_ISP_EXP_MEAN_42         ((CIF_ISP_EXP_BASE + 0x0000004c))
#define CIF_ISP_EXP_MEAN_03         ((CIF_ISP_EXP_BASE + 0x00000050))
#define CIF_ISP_EXP_MEAN_13         ((CIF_ISP_EXP_BASE + 0x00000054))
#define CIF_ISP_EXP_MEAN_23         ((CIF_ISP_EXP_BASE + 0x00000058))
#define CIF_ISP_EXP_MEAN_33         ((CIF_ISP_EXP_BASE + 0x0000005c))
#define CIF_ISP_EXP_MEAN_43         ((CIF_ISP_EXP_BASE + 0x00000060))
#define CIF_ISP_EXP_MEAN_04         ((CIF_ISP_EXP_BASE + 0x00000064))
#define CIF_ISP_EXP_MEAN_14         ((CIF_ISP_EXP_BASE + 0x00000068))
#define CIF_ISP_EXP_MEAN_24         ((CIF_ISP_EXP_BASE + 0x0000006c))
#define CIF_ISP_EXP_MEAN_34         ((CIF_ISP_EXP_BASE + 0x00000070))
#define CIF_ISP_EXP_MEAN_44         ((CIF_ISP_EXP_BASE + 0x00000074))

#define CIF_ISP_BLS_BASE            (0x00002700)
#define CIF_ISP_BLS_CTRL            ((CIF_ISP_BLS_BASE + 0x00000000))
#define CIF_ISP_BLS_SAMPLES         ((CIF_ISP_BLS_BASE + 0x00000004))
#define CIF_ISP_BLS_H1_START        ((CIF_ISP_BLS_BASE + 0x00000008))
#define CIF_ISP_BLS_H1_STOP         ((CIF_ISP_BLS_BASE + 0x0000000c))
#define CIF_ISP_BLS_V1_START        ((CIF_ISP_BLS_BASE + 0x00000010))
#define CIF_ISP_BLS_V1_STOP         ((CIF_ISP_BLS_BASE + 0x00000014))
#define CIF_ISP_BLS_H2_START        ((CIF_ISP_BLS_BASE + 0x00000018))
#define CIF_ISP_BLS_H2_STOP         ((CIF_ISP_BLS_BASE + 0x0000001c))
#define CIF_ISP_BLS_V2_START        ((CIF_ISP_BLS_BASE + 0x00000020))
#define CIF_ISP_BLS_V2_STOP         ((CIF_ISP_BLS_BASE + 0x00000024))
#define CIF_ISP_BLS_A_FIXED         ((CIF_ISP_BLS_BASE + 0x00000028))
#define CIF_ISP_BLS_B_FIXED         ((CIF_ISP_BLS_BASE + 0x0000002c))
#define CIF_ISP_BLS_C_FIXED         ((CIF_ISP_BLS_BASE + 0x00000030))
#define CIF_ISP_BLS_D_FIXED         ((CIF_ISP_BLS_BASE + 0x00000034))
#define CIF_ISP_BLS_A_MEASURED      ((CIF_ISP_BLS_BASE + 0x00000038))
#define CIF_ISP_BLS_B_MEASURED      ((CIF_ISP_BLS_BASE + 0x0000003c))
#define CIF_ISP_BLS_C_MEASURED      ((CIF_ISP_BLS_BASE + 0x00000040))
#define CIF_ISP_BLS_D_MEASURED      ((CIF_ISP_BLS_BASE + 0x00000044))

#define CIF_ISP_DPF_BASE            (0x00002800)
#define CIF_ISP_DPF_MODE            (CIF_ISP_DPF_BASE + 0x00000000)
#define CIF_ISP_DPF_STRENGTH_R      (CIF_ISP_DPF_BASE + 0x00000004)
#define CIF_ISP_DPF_STRENGTH_G      (CIF_ISP_DPF_BASE + 0x00000008)
#define CIF_ISP_DPF_STRENGTH_B      (CIF_ISP_DPF_BASE + 0x0000000C)
#define CIF_ISP_DPF_S_WEIGHT_G_1_4  (CIF_ISP_DPF_BASE + 0x00000010)
#define CIF_ISP_DPF_S_WEIGHT_G_5_6  (CIF_ISP_DPF_BASE + 0x00000014)
#define CIF_ISP_DPF_S_WEIGHT_RB_1_4 (CIF_ISP_DPF_BASE + 0x00000018)
#define CIF_ISP_DPF_S_WEIGHT_RB_5_6 (CIF_ISP_DPF_BASE + 0x0000001C)
#define CIF_ISP_DPF_NULL_COEFF_0    (CIF_ISP_DPF_BASE + 0x00000020)
#define CIF_ISP_DPF_NULL_COEFF_1    (CIF_ISP_DPF_BASE + 0x00000024)
#define CIF_ISP_DPF_NULL_COEFF_2    (CIF_ISP_DPF_BASE + 0x00000028)
#define CIF_ISP_DPF_NULL_COEFF_3    (CIF_ISP_DPF_BASE + 0x0000002C)
#define CIF_ISP_DPF_NULL_COEFF_4    (CIF_ISP_DPF_BASE + 0x00000030)
#define CIF_ISP_DPF_NULL_COEFF_5    (CIF_ISP_DPF_BASE + 0x00000034)
#define CIF_ISP_DPF_NULL_COEFF_6    (CIF_ISP_DPF_BASE + 0x00000038)
#define CIF_ISP_DPF_NULL_COEFF_7    (CIF_ISP_DPF_BASE + 0x0000003C)
#define CIF_ISP_DPF_NULL_COEFF_8    (CIF_ISP_DPF_BASE + 0x00000040)
#define CIF_ISP_DPF_NULL_COEFF_9    (CIF_ISP_DPF_BASE + 0x00000044)
#define CIF_ISP_DPF_NULL_COEFF_10   (CIF_ISP_DPF_BASE + 0x00000048)
#define CIF_ISP_DPF_NULL_COEFF_11   (CIF_ISP_DPF_BASE + 0x0000004C)
#define CIF_ISP_DPF_NULL_COEFF_12   (CIF_ISP_DPF_BASE + 0x00000050)
#define CIF_ISP_DPF_NULL_COEFF_13   (CIF_ISP_DPF_BASE + 0x00000054)
#define CIF_ISP_DPF_NULL_COEFF_14   (CIF_ISP_DPF_BASE + 0x00000058)
#define CIF_ISP_DPF_NULL_COEFF_15   (CIF_ISP_DPF_BASE + 0x0000005C)
#define CIF_ISP_DPF_NULL_COEFF_16   (CIF_ISP_DPF_BASE + 0x00000060)
#define CIF_ISP_DPF_NF_GAIN_R       (CIF_ISP_DPF_BASE + 0x00000064)
#define CIF_ISP_DPF_NF_GAIN_GR      (CIF_ISP_DPF_BASE + 0x00000068)
#define CIF_ISP_DPF_NF_GAIN_GB      (CIF_ISP_DPF_BASE + 0x0000006C)
#define CIF_ISP_DPF_NF_GAIN_B       (CIF_ISP_DPF_BASE + 0x00000070)

#define CIF_ISP_DPCC_BASE           (0x00002900)
#define CIF_ISP_DPCC_MODE           (CIF_ISP_DPCC_BASE + 0x00000000)
#define CIF_ISP_DPCC_OUTPUT_MODE    (CIF_ISP_DPCC_BASE + 0x00000004)
#define CIF_ISP_DPCC_SET_USE        (CIF_ISP_DPCC_BASE + 0x00000008)
#define CIF_ISP_DPCC_METHODS_SET_1  (CIF_ISP_DPCC_BASE + 0x0000000C)
#define CIF_ISP_DPCC_METHODS_SET_2  (CIF_ISP_DPCC_BASE + 0x00000010)
#define CIF_ISP_DPCC_METHODS_SET_3  (CIF_ISP_DPCC_BASE + 0x00000014)
#define CIF_ISP_DPCC_LINE_THRESH_1  (CIF_ISP_DPCC_BASE + 0x00000018)
#define CIF_ISP_DPCC_LINE_MAD_FAC_1 (CIF_ISP_DPCC_BASE + 0x0000001C)
#define CIF_ISP_DPCC_PG_FAC_1       (CIF_ISP_DPCC_BASE + 0x00000020)
#define CIF_ISP_DPCC_RND_THRESH_1   (CIF_ISP_DPCC_BASE + 0x00000024)
#define CIF_ISP_DPCC_RG_FAC_1       (CIF_ISP_DPCC_BASE + 0x00000028)
#define CIF_ISP_DPCC_LINE_THRESH_2  (CIF_ISP_DPCC_BASE + 0x0000002C)
#define CIF_ISP_DPCC_LINE_MAD_FAC_2 (CIF_ISP_DPCC_BASE + 0x00000030)
#define CIF_ISP_DPCC_PG_FAC_2       (CIF_ISP_DPCC_BASE + 0x00000034)
#define CIF_ISP_DPCC_RND_THRESH_2   (CIF_ISP_DPCC_BASE + 0x00000038)
#define CIF_ISP_DPCC_RG_FAC_2       (CIF_ISP_DPCC_BASE + 0x0000003C)
#define CIF_ISP_DPCC_LINE_THRESH_3  (CIF_ISP_DPCC_BASE + 0x00000040)
#define CIF_ISP_DPCC_LINE_MAD_FAC_3 (CIF_ISP_DPCC_BASE + 0x00000044)
#define CIF_ISP_DPCC_PG_FAC_3       (CIF_ISP_DPCC_BASE + 0x00000048)
#define CIF_ISP_DPCC_RND_THRESH_3   (CIF_ISP_DPCC_BASE + 0x0000004C)
#define CIF_ISP_DPCC_RG_FAC_3       (CIF_ISP_DPCC_BASE + 0x00000050)
#define CIF_ISP_DPCC_RO_LIMITS      (CIF_ISP_DPCC_BASE + 0x00000054)
#define CIF_ISP_DPCC_RND_OFFS       (CIF_ISP_DPCC_BASE + 0x00000058)
#define CIF_ISP_DPCC_BPT_CTRL       (CIF_ISP_DPCC_BASE + 0x0000005C)
#define CIF_ISP_DPCC_BPT_NUMBER     (CIF_ISP_DPCC_BASE + 0x00000060)
#define CIF_ISP_DPCC_BPT_ADDR       (CIF_ISP_DPCC_BASE + 0x00000064)
#define CIF_ISP_DPCC_BPT_DATA       (CIF_ISP_DPCC_BASE + 0x00000068)

#define CIF_ISP_WDR_BASE           (0x00002A00)
#define CIF_ISP_WDR_CTRL           (CIF_ISP_WDR_BASE + 0x00000000)
#define CIF_ISP_WDR_TONECURVE_1    (CIF_ISP_WDR_BASE + 0x00000004)
#define CIF_ISP_WDR_TONECURVE_2    (CIF_ISP_WDR_BASE + 0x00000008)
#define CIF_ISP_WDR_TONECURVE_3    (CIF_ISP_WDR_BASE + 0x0000000C)
#define CIF_ISP_WDR_TONECURVE_4    (CIF_ISP_WDR_BASE + 0x00000010)
#define CIF_ISP_WDR_TONECURVE_YM_0 (CIF_ISP_WDR_BASE + 0x00000014)
#define CIF_ISP_WDR_TONECURVE_YM_1 (CIF_ISP_WDR_BASE + 0x00000018)
#define CIF_ISP_WDR_TONECURVE_YM_2 (CIF_ISP_WDR_BASE + 0x0000001C)
#define CIF_ISP_WDR_TONECURVE_YM_3 (CIF_ISP_WDR_BASE + 0x00000020)
#define CIF_ISP_WDR_TONECURVE_YM_4 (CIF_ISP_WDR_BASE + 0x00000024)
#define CIF_ISP_WDR_TONECURVE_YM_5 (CIF_ISP_WDR_BASE + 0x00000028)
#define CIF_ISP_WDR_TONECURVE_YM_6 (CIF_ISP_WDR_BASE + 0x0000002C)
#define CIF_ISP_WDR_TONECURVE_YM_7 (CIF_ISP_WDR_BASE + 0x00000030)
#define CIF_ISP_WDR_TONECURVE_YM_8 (CIF_ISP_WDR_BASE + 0x00000034)
#define CIF_ISP_WDR_TONECURVE_YM_9 (CIF_ISP_WDR_BASE + 0x00000038)
#define CIF_ISP_WDR_TONECURVE_YM_10 (CIF_ISP_WDR_BASE + 0x0000003C)
#define CIF_ISP_WDR_TONECURVE_YM_11 (CIF_ISP_WDR_BASE + 0x00000040)
#define CIF_ISP_WDR_TONECURVE_YM_12 (CIF_ISP_WDR_BASE + 0x00000044)
#define CIF_ISP_WDR_TONECURVE_YM_13 (CIF_ISP_WDR_BASE + 0x00000048)
#define CIF_ISP_WDR_TONECURVE_YM_14 (CIF_ISP_WDR_BASE + 0x0000004C)
#define CIF_ISP_WDR_TONECURVE_YM_15 (CIF_ISP_WDR_BASE + 0x00000050)
#define CIF_ISP_WDR_TONECURVE_YM_16 (CIF_ISP_WDR_BASE + 0x00000054)
#define CIF_ISP_WDR_TONECURVE_YM_17 (CIF_ISP_WDR_BASE + 0x00000058)
#define CIF_ISP_WDR_TONECURVE_YM_18 (CIF_ISP_WDR_BASE + 0x0000005C)
#define CIF_ISP_WDR_TONECURVE_YM_19 (CIF_ISP_WDR_BASE + 0x00000060)
#define CIF_ISP_WDR_TONECURVE_YM_20 (CIF_ISP_WDR_BASE + 0x00000064)
#define CIF_ISP_WDR_TONECURVE_YM_21 (CIF_ISP_WDR_BASE + 0x00000068)
#define CIF_ISP_WDR_TONECURVE_YM_22 (CIF_ISP_WDR_BASE + 0x0000006C)
#define CIF_ISP_WDR_TONECURVE_YM_23 (CIF_ISP_WDR_BASE + 0x00000070)
#define CIF_ISP_WDR_TONECURVE_YM_24 (CIF_ISP_WDR_BASE + 0x00000074)
#define CIF_ISP_WDR_TONECURVE_YM_25 (CIF_ISP_WDR_BASE + 0x00000078)
#define CIF_ISP_WDR_TONECURVE_YM_26 (CIF_ISP_WDR_BASE + 0x0000007C)
#define CIF_ISP_WDR_TONECURVE_YM_27 (CIF_ISP_WDR_BASE + 0x00000080)
#define CIF_ISP_WDR_TONECURVE_YM_28 (CIF_ISP_WDR_BASE + 0x00000084)
#define CIF_ISP_WDR_TONECURVE_YM_29 (CIF_ISP_WDR_BASE + 0x00000088)
#define CIF_ISP_WDR_TONECURVE_YM_30 (CIF_ISP_WDR_BASE + 0x0000008C)
#define CIF_ISP_WDR_TONECURVE_YM_31 (CIF_ISP_WDR_BASE + 0x00000090)
#define CIF_ISP_WDR_TONECURVE_YM_32 (CIF_ISP_WDR_BASE + 0x00000094)
#define CIF_ISP_WDR_OFFSET          (CIF_ISP_WDR_BASE + 0x00000098)
#define CIF_ISP_WDR_DELTAMIN        (CIF_ISP_WDR_BASE + 0x0000009C)
#define CIF_ISP_WDR_TONECURVE_1_SHD (CIF_ISP_WDR_BASE + 0x000000A0)
#define CIF_ISP_WDR_TONECURVE_2_SHD (CIF_ISP_WDR_BASE + 0x000000A4)
#define CIF_ISP_WDR_TONECURVE_3_SHD (CIF_ISP_WDR_BASE + 0x000000A8)
#define CIF_ISP_WDR_TONECURVE_4_SHD (CIF_ISP_WDR_BASE + 0x000000AC)
#define CIF_ISP_WDR_TONECURVE_YM_0_SHD (CIF_ISP_WDR_BASE + 0x000000B0)
#define CIF_ISP_WDR_TONECURVE_YM_1_SHD (CIF_ISP_WDR_BASE + 0x000000B4)
#define CIF_ISP_WDR_TONECURVE_YM_2_SHD (CIF_ISP_WDR_BASE + 0x000000B8)
#define CIF_ISP_WDR_TONECURVE_YM_3_SHD (CIF_ISP_WDR_BASE + 0x000000BC)
#define CIF_ISP_WDR_TONECURVE_YM_4_SHD (CIF_ISP_WDR_BASE + 0x000000C0)
#define CIF_ISP_WDR_TONECURVE_YM_5_SHD (CIF_ISP_WDR_BASE + 0x000000C4)
#define CIF_ISP_WDR_TONECURVE_YM_6_SHD (CIF_ISP_WDR_BASE + 0x000000C8)
#define CIF_ISP_WDR_TONECURVE_YM_7_SHD (CIF_ISP_WDR_BASE + 0x000000CC)
#define CIF_ISP_WDR_TONECURVE_YM_8_SHD (CIF_ISP_WDR_BASE + 0x000000D0)
#define CIF_ISP_WDR_TONECURVE_YM_9_SHD (CIF_ISP_WDR_BASE + 0x000000D4)
#define CIF_ISP_WDR_TONECURVE_YM_10_SHD (CIF_ISP_WDR_BASE + 0x000000D8)
#define CIF_ISP_WDR_TONECURVE_YM_11_SHD (CIF_ISP_WDR_BASE + 0x000000DC)
#define CIF_ISP_WDR_TONECURVE_YM_12_SHD (CIF_ISP_WDR_BASE + 0x000000E0)
#define CIF_ISP_WDR_TONECURVE_YM_13_SHD (CIF_ISP_WDR_BASE + 0x000000E4)
#define CIF_ISP_WDR_TONECURVE_YM_14_SHD (CIF_ISP_WDR_BASE + 0x000000E8)
#define CIF_ISP_WDR_TONECURVE_YM_15_SHD (CIF_ISP_WDR_BASE + 0x000000EC)
#define CIF_ISP_WDR_TONECURVE_YM_16_SHD (CIF_ISP_WDR_BASE + 0x000000F0)
#define CIF_ISP_WDR_TONECURVE_YM_17_SHD (CIF_ISP_WDR_BASE + 0x000000F4)
#define CIF_ISP_WDR_TONECURVE_YM_18_SHD (CIF_ISP_WDR_BASE + 0x000000F8)
#define CIF_ISP_WDR_TONECURVE_YM_19_SHD (CIF_ISP_WDR_BASE + 0x000000FC)
#define CIF_ISP_WDR_TONECURVE_YM_20_SHD (CIF_ISP_WDR_BASE + 0x00000100)
#define CIF_ISP_WDR_TONECURVE_YM_21_SHD (CIF_ISP_WDR_BASE + 0x00000104)
#define CIF_ISP_WDR_TONECURVE_YM_22_SHD (CIF_ISP_WDR_BASE + 0x00000108)
#define CIF_ISP_WDR_TONECURVE_YM_23_SHD (CIF_ISP_WDR_BASE + 0x0000010C)
#define CIF_ISP_WDR_TONECURVE_YM_24_SHD (CIF_ISP_WDR_BASE + 0x00000110)
#define CIF_ISP_WDR_TONECURVE_YM_25_SHD (CIF_ISP_WDR_BASE + 0x00000114)
#define CIF_ISP_WDR_TONECURVE_YM_26_SHD (CIF_ISP_WDR_BASE + 0x00000118)
#define CIF_ISP_WDR_TONECURVE_YM_27_SHD (CIF_ISP_WDR_BASE + 0x0000011C)
#define CIF_ISP_WDR_TONECURVE_YM_28_SHD (CIF_ISP_WDR_BASE + 0x00000120)
#define CIF_ISP_WDR_TONECURVE_YM_29_SHD (CIF_ISP_WDR_BASE + 0x00000124)
#define CIF_ISP_WDR_TONECURVE_YM_30_SHD (CIF_ISP_WDR_BASE + 0x00000128)
#define CIF_ISP_WDR_TONECURVE_YM_31_SHD (CIF_ISP_WDR_BASE + 0x0000012C)
#define CIF_ISP_WDR_TONECURVE_YM_32_SHD (CIF_ISP_WDR_BASE + 0x00000130)

#define CIF_ISP_VSM_BASE       (0x00002F00)
#define CIF_ISP_VSM_MODE       (CIF_ISP_VSM_BASE + 0x00000000)
#define CIF_ISP_VSM_H_OFFS     (CIF_ISP_VSM_BASE + 0x00000004)
#define CIF_ISP_VSM_V_OFFS     (CIF_ISP_VSM_BASE + 0x00000008)
#define CIF_ISP_VSM_H_SIZE     (CIF_ISP_VSM_BASE + 0x0000000C)
#define CIF_ISP_VSM_V_SIZE     (CIF_ISP_VSM_BASE + 0x00000010)
#define CIF_ISP_VSM_H_SEGMENTS (CIF_ISP_VSM_BASE + 0x00000014)
#define CIF_ISP_VSM_V_SEGMENTS (CIF_ISP_VSM_BASE + 0x00000018)
#define CIF_ISP_VSM_DELTA_H    (CIF_ISP_VSM_BASE + 0x0000001C)
#define CIF_ISP_VSM_DELTA_V    (CIF_ISP_VSM_BASE + 0x00000020)
#endif
