/*
 * drivers/media/i2c/soc_camera/xgold/ov8858.c
 *
 * ov8858 sensor driver
 *
 * Copyright (C) 2016 Fuzhou Rockchip Electronics Co., Ltd.
 *
 * Copyright (C) 2012-2014 Intel Mobile Communications GmbH
 *
 * Copyright (C) 2008 Texas Instruments.
 *
 * This file is licensed under the terms of the GNU General Public License
 * version 2. This program is licensed "as is" without any warranty of any
 * kind, whether express or implied.
 *
 * Note:
 *    07/01/2014: new implementation using v4l2-subdev
 *                        instead of v4l2-int-device.
 */

#include <linux/i2c.h>
#include <linux/io.h>
#include <linux/delay.h>
#include <linux/module.h>
#include <media/v4l2-subdev.h>
#include <media/videobuf-core.h>
#include <linux/slab.h>
#include "ov_camera_module.h"

#define ov8858_DRIVER_NAME "ov8858"

#define ov8858_FETCH_LSB_GAIN(VAL) ((VAL) & 0x00ff)
#define ov8858_FETCH_MSB_GAIN(VAL) (((VAL) >> 8) & 0xff)
#define ov8858_AEC_PK_LONG_GAIN_HIGH_REG 0x3508	/* Bit 6-13 */
#define ov8858_AEC_PK_LONG_GAIN_LOW_REG	 0x3509	/* Bits 0 -5 */

#define ov8858_AEC_PK_LONG_EXPO_3RD_REG 0x3500	/* Exposure Bits 16-19 */
#define ov8858_AEC_PK_LONG_EXPO_2ND_REG 0x3501	/* Exposure Bits 8-15 */
#define ov8858_AEC_PK_LONG_EXPO_1ST_REG 0x3502	/* Exposure Bits 0-7 */

#define ov8858_AEC_GROUP_UPDATE_ADDRESS 0x3208
#define ov8858_AEC_GROUP_UPDATE_START_DATA 0x00
#define ov8858_AEC_GROUP_UPDATE_END_DATA 0x10
#define ov8858_AEC_GROUP_UPDATE_END_LAUNCH 0xA0

#define ov8858_FETCH_3RD_BYTE_EXP(VAL) (((VAL) >> 16) & 0xF)	/* 4 Bits */
#define ov8858_FETCH_2ND_BYTE_EXP(VAL) (((VAL) >> 8) & 0xFF)	/* 8 Bits */
#define ov8858_FETCH_1ST_BYTE_EXP(VAL) ((VAL) & 0xFF)	/* 8 Bits */

#define ov8858_PIDH_ADDR     0x300B
#define ov8858_PIDL_ADDR     0x300C

#define ov8858_TIMING_VTS_HIGH_REG 0x380e
#define ov8858_TIMING_VTS_LOW_REG 0x380f
#define ov8858_TIMING_HTS_HIGH_REG 0x380c
#define ov8858_TIMING_HTS_LOW_REG 0x380d
#define ov8858_INTEGRATION_TIME_MARGIN 8
#define ov8858_FINE_INTG_TIME_MIN 0
#define ov8858_FINE_INTG_TIME_MAX_MARGIN 0
#define ov8858_COARSE_INTG_TIME_MIN 16
#define ov8858_COARSE_INTG_TIME_MAX_MARGIN 4
#define ov8858_TIMING_X_INC		0x3814
#define ov8858_TIMING_Y_INC		0x3815
#define ov8858_HORIZONTAL_START_HIGH_REG 0x3800
#define ov8858_HORIZONTAL_START_LOW_REG 0x3801
#define ov8858_VERTICAL_START_HIGH_REG 0x3802
#define ov8858_VERTICAL_START_LOW_REG 0x3803
#define ov8858_HORIZONTAL_END_HIGH_REG 0x3804
#define ov8858_HORIZONTAL_END_LOW_REG 0x3805
#define ov8858_VERTICAL_END_HIGH_REG 0x3806
#define ov8858_VERTICAL_END_LOW_REG 0x3807
#define ov8858_HORIZONTAL_OUTPUT_SIZE_HIGH_REG 0x3808
#define ov8858_HORIZONTAL_OUTPUT_SIZE_LOW_REG 0x3809
#define ov8858_VERTICAL_OUTPUT_SIZE_HIGH_REG 0x380a
#define ov8858_VERTICAL_OUTPUT_SIZE_LOW_REG 0x380b
#define ov8858_FLIP_REG                      0x3820
#define ov8858_MIRROR_REG                      0x3821

#define ov8858_EXT_CLK 26000000

#define ov8858_FULL_SIZE_RESOLUTION_WIDTH 3264
#define ov8858_BINING_SIZE_RESOLUTION_WIDTH 1632
#define ov8858_VIDEO_SIZE_RESOLUTION_WIDTH 3200

#define ov8858_EXP_VALID_FRAMES		4
/* High byte of product ID */
#define ov8858_PIDH_MAGIC 0x88
/* Low byte of product ID  */
#define ov8858_PIDL_MAGIC 0x58

bool is_R1A_module;

#define BG_RATIO_TYPICAL  0x129
#define RG_RATIO_TYPICAL  0x11f

#define OV8858_REG_TEST_PATTERN     0x5e00
#define OV8858_TEST_PATTERN_ENABLE  0x80
#define OV8858_TEST_PATTERN_DISABLE 0x0

struct ov8858_otp_struct {
	int otp_en;
	int flag;
	int module_integrator_id;
	int lens_id;
	int production_year;
	int production_month;
	int production_day;
	int rg_ratio;
	int bg_ratio;
	int lenc[240];
	int checksum;
	int VCM_start;
	int VCM_end;
	int VCM_dir;
	int R_gain;
	int G_gain;
	int B_gain;
};

static struct ov8858_otp_struct *otp_ptr;
static struct ov_camera_module ov8858;
static struct ov_camera_module_custom_config ov8858_custom_config;

/* ======================================================================== */
/* Base sensor configs */
/* ======================================================================== */

/* MCLK:26MHz  3264x2448  18fps   mipi 4lane   481Mbps/lane */
static struct ov_camera_module_reg
	ov8858_init_tab_3264_2448_18fps[] = {
	/* global setting */
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0103, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0100, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0300, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0301, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0302, 0x94},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0303, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0304, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0305, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0306, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x030a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x030b, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x030c, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x030e, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x030d, 0x6f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x030f, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0312, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x031e, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3033, 0x24},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3600, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3601, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3602, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3603, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3604, 0x22},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3605, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3606, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3607, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3608, 0x11},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3609, 0x28},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360b, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360c, 0xd4},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360d, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360e, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360f, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3610, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3611, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3612, 0x88},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3613, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3614, 0x58},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3615, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3616, 0x4a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3617, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3618, 0x5a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3619, 0x70},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x361a, 0x99},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x361b, 0x0a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x361c, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x361d, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x361e, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x361f, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3638, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3633, 0x0f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3634, 0x0f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3635, 0x0f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3636, 0x12},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3645, 0x13},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3646, 0x83},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x364a, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3015, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3018, 0x72},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3020, 0x93},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3022, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3031, 0x0a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3034, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3106, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3305, 0xf1},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3308, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3309, 0x28},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x330a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x330b, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x330c, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x330d, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x330e, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x330f, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3307, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3500, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3501, 0x4d},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3502, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3503, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3505, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3508, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3509, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350c, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350d, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3510, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3511, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3512, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3700, 0x30},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3701, 0x18},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3702, 0x50},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3703, 0x32},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3704, 0x28},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3705, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3706, 0x82},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3707, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3708, 0x48},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3709, 0x66},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370a, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370b, 0x82},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370c, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3718, 0x14},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3719, 0x31},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3712, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3714, 0x24},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x371e, 0x31},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x371f, 0x7f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3720, 0x0a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3721, 0x0a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3724, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3725, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3726, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3728, 0x0a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3729, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372a, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372b, 0xa6},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372c, 0xa6},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372d, 0xa6},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372e, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372f, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3730, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3731, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3732, 0x28},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3733, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3734, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3736, 0x30},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x373a, 0x0a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x373b, 0x0b},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x373c, 0x14},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x373e, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3750, 0x0a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3751, 0x0e},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3755, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3758, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3759, 0x4c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x375a, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x375b, 0x26},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x375c, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x375d, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x375e, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x375f, 0x28},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3768, 0x22},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3769, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x376a, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3761, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3762, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3763, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3766, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x376b, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3772, 0x46},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3773, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3774, 0x2c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3775, 0x13},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3776, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3777, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3778, 0x17},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a0, 0x88},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a1, 0x7a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a2, 0x7a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a3, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a4, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a5, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a6, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a7, 0x88},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a8, 0x98},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a9, 0x98},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3760, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x376f, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37aa, 0x88},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37ab, 0x5c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37ac, 0x5c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37ad, 0x55},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37ae, 0x19},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37af, 0x19},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b0, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b1, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b2, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b3, 0x84},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b4, 0x84},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b5, 0x60},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b6, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b7, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b8, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b9, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3800, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3801, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3802, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3803, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3804, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3805, 0xd3},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3806, 0x09},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3807, 0xa3},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3808, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3809, 0x60},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380a, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380b, 0xc8},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380c, 0x0b},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380d, 0x64},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380e, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380f, 0xdc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3810, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3811, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3813, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3814, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3815, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3820, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3821, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x382a, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x382b, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3830, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3836, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3837, 0x18},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3841, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3846, 0x48},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3d85, 0x16},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3d8c, 0x73},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3d8d, 0xde},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3f08, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3f0a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4000, 0xf1},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4001, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4005, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4002, 0x27},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4009, 0x81},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x400b, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4011, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401b, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401d, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4020, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4021, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4022, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4023, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4024, 0x0f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4025, 0x2a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4026, 0x0f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4027, 0x2b},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4028, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4029, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402a, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402b, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402c, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402d, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402e, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402f, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401f, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4034, 0x3f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x403d, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4300, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4301, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4302, 0x0f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4316, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4500, 0x58},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4503, 0x18},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4600, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4601, 0xcb},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x481f, 0x32},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4821, 0x5f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4837, 0x21},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4850, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4851, 0x32},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4b00, 0x2a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4b0d, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d00, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d01, 0x18},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d02, 0xc3},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d03, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d04, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d05, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5000, 0xfe},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5001, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5002, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5003, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5046, 0x12},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5780, 0x3e},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5781, 0x0f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5782, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5783, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5784, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5785, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5786, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5787, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5788, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5789, 0x0f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x578a, 0xfd},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x578b, 0xf5},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x578c, 0xf5},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x578d, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x578e, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x578f, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5790, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5791, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5792, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5793, 0x52},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5794, 0xa3},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5871, 0x0d},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5870, 0x18},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x586e, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x586f, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x58f8, 0x3d},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5901, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b00, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b01, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b02, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b03, 0xcf},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5b05, 0x6c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5e00, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5e01, 0x41},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x382d, 0x7f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4825, 0x3a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4826, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4808, 0x25},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3763, 0x18},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3768, 0xcc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x470b, 0x28},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4202, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x400d, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4040, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x403e, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4041, 0xc6},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3007, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x400a, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4500, 0x58},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3021, 0x23},
	/* @@ SIZE_3264X2448_15FPS_MIPI_4LANE based on R2A_EN_AM22 version db */
	/* ;;pll2_VCO= 721.5, SYSclk=144.3, Dac_clk =360.75 */
	/* ;;pll1_VCO= 962, pll_MIPIclk=481Mbps */
	/* mipi_Pclk =60.125, Sclk1=120.25 */
	/* ;;fps=15, 10bit,4lane, Vblanking=7.251ms */
	/* update on 2015/06/25.*/
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3808, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3809, 0xc0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380a, 0x09},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380b, 0x90},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380c, 0x0d},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380d, 0xa0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380e, 0x0a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380f, 0xbc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3814, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3821, 0x46},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x382a, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x382d, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3830, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3836, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3f0a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4001, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4022, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4023, 0x60},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4025, 0x36},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4027, 0x37},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402b, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402f, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4500, 0x58},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4600, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4601, 0x97}
};

static const struct ov_camera_module_reg
	ov8858_init_tab_1632_1224_30fps_R1A[] = {
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0103, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0100, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0100, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0100, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0100, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0302, 0x1e},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0303, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0304, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x030e, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x030f, 0x09},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0312, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x031e, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3600, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3601, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3602, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3603, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3604, 0x22},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3605, 0x30},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3606, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3607, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3608, 0x11},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3609, 0x28},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360b, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360c, 0xdc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360d, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360e, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360f, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3610, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3611, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3612, 0x88},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3613, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3614, 0x58},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3615, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3616, 0x4a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3617, 0xb0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3618, 0x56},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3619, 0x70},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x361a, 0x99},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x361b, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x361c, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x361d, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x361e, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x361f, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3638, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3633, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3634, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3635, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3636, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3645, 0x13},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3646, 0x83},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x364a, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3015, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3018, 0x32},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3020, 0x93},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3022, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3031, 0x0a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3034, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3106, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3305, 0xf1},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3308, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3309, 0x28},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x330a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x330b, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x330c, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x330d, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x330e, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x330f, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3307, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3500, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3501, 0x4d},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3502, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3503, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3505, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3508, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3509, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350c, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350d, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3510, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3511, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3512, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3700, 0x18},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3701, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3702, 0x28},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3703, 0x19},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3704, 0x14},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3705, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3706, 0x35},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3707, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3708, 0x24},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3709, 0x33},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370b, 0xb5},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370c, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3718, 0x12},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3719, 0x31},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3712, 0x42},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3714, 0x24},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x371e, 0x19},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x371f, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3720, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3721, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3724, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3725, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3726, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3728, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3729, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372a, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372b, 0x53},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372c, 0xa3},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372d, 0x53},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372e, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372f, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3730, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3731, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3732, 0x14},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3733, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3734, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3736, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x373a, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x373b, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x373c, 0x0a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x373e, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3755, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3758, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3759, 0x4c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x375a, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x375b, 0x13},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x375c, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x375d, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x375e, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x375f, 0x14},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3768, 0x22},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3769, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x376a, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3761, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3762, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3763, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3766, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x376b, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3772, 0x23},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3773, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3774, 0x16},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3775, 0x12},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3776, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3777, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3778, 0x1b},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a0, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a1, 0x3d},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a2, 0x3d},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a3, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a4, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a5, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a6, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a7, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a8, 0x4c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a9, 0x4c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3760, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x376f, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37aa, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37ab, 0x2e},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37ac, 0x2e},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37ad, 0x33},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37ae, 0x0d},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37af, 0x0d},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b0, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b1, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b2, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b3, 0x42},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b4, 0x42},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b5, 0x33},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b6, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b7, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b8, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b9, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3800, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3801, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3802, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3803, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3804, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3805, 0xd3},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3806, 0x09},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3807, 0xa3},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3808, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3809, 0x60},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380a, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380b, 0xc8},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380c, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380d, 0x88},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380e, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380f, 0xdc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3810, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3811, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3813, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3814, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3815, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3820, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3821, 0x67},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x382a, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x382b, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3830, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3836, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3837, 0x18},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3841, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3846, 0x48},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3d85, 0x14},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3f08, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3f0a, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4000, 0xf1},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4001, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4005, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4002, 0x27},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4009, 0x81},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x400b, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401b, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401d, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4020, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4021, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4022, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4023, 0xb9},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4024, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4025, 0x2a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4026, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4027, 0x2b},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4028, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4029, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402a, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402b, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402c, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402d, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402e, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402f, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401f, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4034, 0x3f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x403d, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4300, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4301, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4302, 0x0f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4316, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4500, 0x38},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4503, 0x18},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4600, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4601, 0xcb},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x481f, 0x32},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4837, 0x16},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4850, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4851, 0x32},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4b00, 0x2a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4b0d, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d00, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d01, 0x18},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d02, 0xc3},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d03, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d04, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d05, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5000, 0x7e},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5001, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5002, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5003, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5046, 0x12},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5901, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5e00, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5e01, 0x41},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x382d, 0x7f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4825, 0x3a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4826, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4808, 0x25},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x030e, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x030f, 0x09},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0312, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3015, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3501, 0x4d},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3502, 0x40},
	/* {OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3508, 0x04}, */
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3706, 0x35},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370b, 0xb5},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3778, 0x1b},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3808, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3809, 0x60},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380a, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380b, 0xc8},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380c, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380d, 0x88},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380e, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380f, 0xdc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3814, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3821, 0x67},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x382a, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3830, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3836, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3f0a, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4001, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4022, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4023, 0xb9},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4024, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4025, 0x2a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4026, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4027, 0x2b},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402b, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402e, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4500, 0x38},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4600, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4601, 0xcb},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x382d, 0x7f}
};

static const struct ov_camera_module_reg
	ov8858_init_tab_3264_2448_15fps_R1A[] =  {
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0103, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0100, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0100, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0100, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0100, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0302, 0x1e},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0303, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0304, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x030e, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x030f, 0x09},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0312, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x031e, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3600, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3601, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3602, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3603, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3604, 0x22},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3605, 0x30},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3606, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3607, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3608, 0x11},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3609, 0x28},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360b, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360c, 0xdc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360d, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360e, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x360f, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3610, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3611, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3612, 0x88},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3613, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3614, 0x58},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3615, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3616, 0x4a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3617, 0xb0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3618, 0x56},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3619, 0x70},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x361a, 0x99},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x361b, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x361c, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x361d, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x361e, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x361f, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3638, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3633, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3634, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3635, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3636, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3645, 0x13},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3646, 0x83},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x364a, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3015, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3018, 0x32},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3020, 0x93},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3022, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3031, 0x0a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3034, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3106, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3305, 0xf1},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3308, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3309, 0x28},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x330a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x330b, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x330c, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x330d, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x330e, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x330f, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3307, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3500, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3501, 0x4d},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3502, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3503, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3505, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3508, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3509, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350c, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x350d, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3510, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3511, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3512, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3700, 0x18},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3701, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3702, 0x28},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3703, 0x19},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3704, 0x14},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3705, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3706, 0x35},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3707, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3708, 0x24},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3709, 0x33},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370b, 0xb5},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370c, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3718, 0x12},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3719, 0x31},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3712, 0x42},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3714, 0x24},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x371e, 0x19},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x371f, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3720, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3721, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3724, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3725, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3726, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3728, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3729, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372a, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372b, 0x53},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372c, 0xa3},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372d, 0x53},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372e, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x372f, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3730, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3731, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3732, 0x14},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3733, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3734, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3736, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x373a, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x373b, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x373c, 0x0a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x373e, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3755, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3758, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3759, 0x4c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x375a, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x375b, 0x13},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x375c, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x375d, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x375e, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x375f, 0x14},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3768, 0x22},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3769, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x376a, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3761, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3762, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3763, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3766, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x376b, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3772, 0x23},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3773, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3774, 0x16},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3775, 0x12},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3776, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3777, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3778, 0x1b},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a0, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a1, 0x3d},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a2, 0x3d},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a3, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a4, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a5, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a6, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a7, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a8, 0x4c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37a9, 0x4c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3760, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x376f, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37aa, 0x44},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37ab, 0x2e},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37ac, 0x2e},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37ad, 0x33},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37ae, 0x0d},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37af, 0x0d},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b0, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b1, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b2, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b3, 0x42},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b4, 0x42},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b5, 0x33},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b6, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b7, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b8, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x37b9, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3800, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3801, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3802, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3803, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3804, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3805, 0xd3},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3806, 0x09},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3807, 0xa3},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3808, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3809, 0x60},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380a, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380b, 0xc8},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380c, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380d, 0x88},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380e, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380f, 0xdc},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3810, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3811, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3813, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3814, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3815, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3820, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3821, 0x67},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x382a, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x382b, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3830, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3836, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3837, 0x18},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3841, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3846, 0x48},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3d85, 0x14},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3f08, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3f0a, 0x80},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4000, 0xf1},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4001, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4005, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4002, 0x27},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4009, 0x81},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x400b, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401b, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401d, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4020, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4021, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4022, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4023, 0xb9},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4024, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4025, 0x2a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4026, 0x05},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4027, 0x2b},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4028, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4029, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402a, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402b, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402c, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402d, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402e, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402f, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x401f, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4034, 0x3f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x403d, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4300, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4301, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4302, 0x0f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4316, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4500, 0x38},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4503, 0x18},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4600, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4601, 0xcb},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x481f, 0x32},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4837, 0x16},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4850, 0x10},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4851, 0x32},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4b00, 0x2a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4b0d, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d00, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d01, 0x18},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d02, 0xc3},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d03, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d04, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4d05, 0xff},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5000, 0x7e},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5001, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5002, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5003, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5046, 0x12},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5901, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5e00, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x5e01, 0x41},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x382d, 0x7f},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4825, 0x3a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4826, 0x40},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4808, 0x25},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x030e, 0x02},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x030f, 0x04},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x0312, 0x03},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3015, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3501, 0x9a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3502, 0x20},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3706, 0x6a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370a, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x370b, 0x6a},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3778, 0x32},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3808, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3809, 0xc0},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380a, 0x09},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380b, 0x90},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380c, 0x07},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380d, 0x94},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380e, 0x09},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x380f, 0xaa},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3814, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3821, 0x46},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x382a, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3830, 0x06},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3836, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x3f0a, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4001, 0x00},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4022, 0x0b},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4023, 0xc3},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4024, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4025, 0x36},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4026, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4027, 0x37},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402b, 0x08},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x402e, 0x0c},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4500, 0x58},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4600, 0x01},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x4601, 0x97},
	{OV_CAMERA_MODULE_REG_TYPE_DATA, 0x382d, 0xff}
};

/* ======================================================================== */
static struct ov_camera_module_config ov8858_configs[] = {
{
		.name = "3264x2448_18fps",
		.frm_fmt = {
			.width = 3264,
			.height = 2448,
			.code = MEDIA_BUS_FMT_SBGGR10_1X10
		},
		.frm_intrvl = {
			.interval = {
				.numerator = 1,
				.denominator = 18
			}
		},
		.auto_exp_enabled = false,
		.auto_gain_enabled = false,
		.auto_wb_enabled = false,
		.reg_table = (void *)ov8858_init_tab_3264_2448_18fps,
		.reg_table_num_entries =
			sizeof(ov8858_init_tab_3264_2448_18fps) /
			sizeof(ov8858_init_tab_3264_2448_18fps[0]),
		.reg_diff_table = NULL,
		.reg_diff_table_num_entries = 0,
		.v_blanking_time_us = 7251,
		.max_exp_gain_h = 16,
		.max_exp_gain_l = 0,
		PLTFRM_CAM_ITF_MIPI_CFG(0, 4, 481, 24000000)
	}
};

static struct ov_camera_module_config ov8858_configs_R1A[] = {
	{
		.name = "1632x1224_30fps",
		.frm_fmt = {
			.width = 1632,
			.height = 1224,
			.code = MEDIA_BUS_FMT_SBGGR10_1X10
		},
		.frm_intrvl = {
			.interval = {
				.numerator = 1,
				.denominator = 30
			}
		},
		.auto_exp_enabled = false,
		.auto_gain_enabled = false,
		.auto_wb_enabled = false,
		.reg_table = (void *)ov8858_init_tab_1632_1224_30fps_R1A,
		.reg_table_num_entries =
			sizeof(ov8858_init_tab_1632_1224_30fps_R1A) /
			sizeof(ov8858_init_tab_1632_1224_30fps_R1A[0]),
		.v_blanking_time_us = 6579,
		.max_exp_gain_h = 16,
		.max_exp_gain_l = 0,
		PLTFRM_CAM_ITF_MIPI_CFG(0, 2, 720, 24000000)
	},
	{
		.name = "3264x2448_15fps",
		.frm_fmt = {
			.width = 3264,
			.height = 2448,
			.code = MEDIA_BUS_FMT_SBGGR10_1X10
		},
		.frm_intrvl = {
			.interval = {
				.numerator = 1,
				.denominator = 15
			}
		},
		.auto_exp_enabled = false,
		.auto_gain_enabled = false,
		.auto_wb_enabled = false,
		.reg_table = (void *)ov8858_init_tab_3264_2448_15fps_R1A,
		.reg_table_num_entries =
			sizeof(ov8858_init_tab_3264_2448_15fps_R1A) /
			sizeof(ov8858_init_tab_3264_2448_15fps_R1A[0]),
		.v_blanking_time_us = 6579,
		.max_exp_gain_h = 16,
		.max_exp_gain_l = 0,
		PLTFRM_CAM_ITF_MIPI_CFG(0, 2, 720, 24000000)
	}
};

/*--------------------------------------------------------------------------*/

static int ov8858_g_VTS(struct ov_camera_module *cam_mod, u32 *vts)
{
	u32 msb, lsb;
	int ret;

	ret = ov_camera_module_read_reg_table(
		cam_mod,
		ov8858_TIMING_VTS_HIGH_REG,
		&msb);
	if (IS_ERR_VALUE(ret))
		goto err;

	ret = ov_camera_module_read_reg_table(
		cam_mod,
		ov8858_TIMING_VTS_LOW_REG,
		&lsb);
	if (IS_ERR_VALUE(ret))
		goto err;

	*vts = (msb << 8) | lsb;
	cam_mod->vts_cur = *vts;

	return 0;
err:
	ov_camera_module_pr_err(cam_mod,
			"failed with error (%d)\n", ret);
	return ret;
}

/*--------------------------------------------------------------------------*/

static int ov8858_auto_adjust_fps(struct ov_camera_module *cam_mod,
	u32 exp_time)
{
	int ret;
	u32 vts;

	if ((exp_time + ov8858_COARSE_INTG_TIME_MAX_MARGIN)
		> cam_mod->vts_min)
		vts = exp_time + ov8858_COARSE_INTG_TIME_MAX_MARGIN;
	else
		vts = cam_mod->vts_min;
	ret = ov_camera_module_write_reg(cam_mod,
		ov8858_TIMING_VTS_LOW_REG,
		vts & 0xFF);
	ret |= ov_camera_module_write_reg(cam_mod,
		ov8858_TIMING_VTS_HIGH_REG,
		(vts >> 8) & 0xFF);

	if (IS_ERR_VALUE(ret)) {
		ov_camera_module_pr_err(cam_mod,
			"failed with error (%d)\n", ret);
	} else {
		ov_camera_module_pr_info(cam_mod,
			"updated vts = %d,vts_min=%d\n", vts, cam_mod->vts_min);
		cam_mod->vts_cur = vts;
	}

	return ret;
}

static int ov8858_set_vts(struct ov_camera_module *cam_mod,
	u32 vts)
{
	int ret = 0;

	if (vts < cam_mod->vts_min)
		return ret;

	if (vts > 0xfff)
		vts = 0xfff;

	ret = ov_camera_module_write_reg(cam_mod,
		ov8858_TIMING_VTS_LOW_REG,
		vts & 0xFF);
	ret |= ov_camera_module_write_reg(cam_mod,
		ov8858_TIMING_VTS_HIGH_REG,
		(vts >> 8) & 0xFF);

	if (IS_ERR_VALUE(ret)) {
		ov_camera_module_pr_err(cam_mod, "failed with error (%d)\n", ret);
	} else {
		ov_camera_module_pr_info(cam_mod, "updated vts=%d,vts_min=%d\n", vts, cam_mod->vts_min);
		cam_mod->vts_cur = vts;
	}
	return ret;
}

/*--------------------------------------------------------------------------*/
static int ov8858_write_aec(struct ov_camera_module *cam_mod)
{
	int ret = 0;

	ov_camera_module_pr_debug(cam_mod,
				  "exp_time = %d, gain = %d, flash_mode = %d\n",
				  cam_mod->exp_config.exp_time,
				  cam_mod->exp_config.gain,
				  cam_mod->exp_config.flash_mode);

	/*
	 * if the sensor is already streaming, write to shadow registers,
	 * if the sensor is in SW standby, write to active registers,
	 * if the sensor is off/registers are not writeable, do nothing
	 */
	if ((cam_mod->state == OV_CAMERA_MODULE_SW_STANDBY) ||
		(cam_mod->state == OV_CAMERA_MODULE_STREAMING)) {
		u32 a_gain = cam_mod->exp_config.gain;
		u32 exp_time;

		a_gain = a_gain > 0x7ff ? 0x7ff : a_gain;
		a_gain = a_gain * cam_mod->exp_config.gain_percent / 100;
		exp_time = cam_mod->exp_config.exp_time << 4;

		mutex_lock(&cam_mod->lock);
		if (cam_mod->state == OV_CAMERA_MODULE_STREAMING)
			ret = ov_camera_module_write_reg(cam_mod,
			ov8858_AEC_GROUP_UPDATE_ADDRESS,
			ov8858_AEC_GROUP_UPDATE_START_DATA);
		if (!IS_ERR_VALUE(ret) && cam_mod->auto_adjust_fps)
			ret = ov8858_auto_adjust_fps(cam_mod,
						cam_mod->exp_config.exp_time);
		ret |= ov_camera_module_write_reg(cam_mod,
			ov8858_AEC_PK_LONG_GAIN_HIGH_REG,
			ov8858_FETCH_MSB_GAIN(a_gain));
		ret |= ov_camera_module_write_reg(cam_mod,
			ov8858_AEC_PK_LONG_GAIN_LOW_REG,
			ov8858_FETCH_LSB_GAIN(a_gain));
		ret = ov_camera_module_write_reg(cam_mod,
			ov8858_AEC_PK_LONG_EXPO_3RD_REG,
			ov8858_FETCH_3RD_BYTE_EXP(exp_time));
		ret |= ov_camera_module_write_reg(cam_mod,
			ov8858_AEC_PK_LONG_EXPO_2ND_REG,
			ov8858_FETCH_2ND_BYTE_EXP(exp_time));
		ret |= ov_camera_module_write_reg(cam_mod,
			ov8858_AEC_PK_LONG_EXPO_1ST_REG,
			ov8858_FETCH_1ST_BYTE_EXP(exp_time));
		if (!cam_mod->auto_adjust_fps)
			ret |= ov8858_set_vts(cam_mod, cam_mod->exp_config.vts_value);
		if (cam_mod->state == OV_CAMERA_MODULE_STREAMING) {
			ret = ov_camera_module_write_reg(cam_mod,
				ov8858_AEC_GROUP_UPDATE_ADDRESS,
				ov8858_AEC_GROUP_UPDATE_END_DATA);
			ret = ov_camera_module_write_reg(cam_mod,
				ov8858_AEC_GROUP_UPDATE_ADDRESS,
				ov8858_AEC_GROUP_UPDATE_END_LAUNCH);
		}
		mutex_unlock(&cam_mod->lock);
	}

	if (IS_ERR_VALUE(ret))
		ov_camera_module_pr_err(cam_mod,
			"failed with error (%d)\n", ret);
	return ret;
}

/*--------------------------------------------------------------------------*/

static int ov8858_g_ctrl(struct ov_camera_module *cam_mod, u32 ctrl_id)
{
	int ret = 0;

	ov_camera_module_pr_debug(cam_mod, "\n");

	switch (ctrl_id) {
	case V4L2_CID_GAIN:
	case V4L2_CID_EXPOSURE:
	case V4L2_CID_FLASH_LED_MODE:
		/* nothing to be done here */
		break;
	default:
		ret = -EINVAL;
		break;
	}

	if (IS_ERR_VALUE(ret))
		ov_camera_module_pr_debug(cam_mod,
			"failed with error (%d)\n", ret);
	return ret;
}

/*--------------------------------------------------------------------------*/
static int ov8858_filltimings(struct ov_camera_module_custom_config *custom)
{
	int i, j;
	struct ov_camera_module_config *config;
	struct ov_camera_module_timings *timings;
	struct ov_camera_module_reg *reg_table;
	int reg_table_num_entries;

	for (i = 0; i < custom->num_configs; i++) {
		config = &custom->configs[i];
		reg_table = config->reg_table;
		reg_table_num_entries = config->reg_table_num_entries;
		timings = &config->timings;

		memset(timings, 0x00, sizeof(*timings));
		for (j = 0; j < reg_table_num_entries; j++) {
			switch (reg_table[j].reg) {
			case ov8858_TIMING_VTS_HIGH_REG:
				timings->frame_length_lines =
					((reg_table[j].val << 8) |
					(timings->frame_length_lines & 0xff));
				break;
			case ov8858_TIMING_VTS_LOW_REG:
				timings->frame_length_lines =
					(reg_table[j].val |
					(timings->frame_length_lines & 0xff00));
				break;
			case ov8858_TIMING_HTS_HIGH_REG:
				timings->line_length_pck =
					((reg_table[j].val << 8) |
					timings->line_length_pck);
				break;
			case ov8858_TIMING_HTS_LOW_REG:
				timings->line_length_pck =
					(reg_table[j].val |
					(timings->line_length_pck & 0xff00));
				break;
			case ov8858_TIMING_X_INC:
				timings->binning_factor_x =
				((reg_table[j].val >> 4) + 1) / 2;
				if (timings->binning_factor_x == 0)
					timings->binning_factor_x = 1;
				break;
			case ov8858_TIMING_Y_INC:
				timings->binning_factor_y =
				((reg_table[j].val >> 4) + 1) / 2;
				if (timings->binning_factor_y == 0)
					timings->binning_factor_y = 1;
				break;
			case ov8858_HORIZONTAL_START_HIGH_REG:
				timings->crop_horizontal_start =
					((reg_table[j].val << 8) |
					(timings->crop_horizontal_start &
					0xff));
				break;
			case ov8858_HORIZONTAL_START_LOW_REG:
				timings->crop_horizontal_start =
					(reg_table[j].val |
					(timings->crop_horizontal_start &
					0xff00));
				break;
			case ov8858_VERTICAL_START_HIGH_REG:
				timings->crop_vertical_start =
					((reg_table[j].val << 8) |
					(timings->crop_vertical_start & 0xff));
				break;
			case ov8858_VERTICAL_START_LOW_REG:
				timings->crop_vertical_start =
					((reg_table[j].val) |
					(timings->crop_vertical_start &
					0xff00));
				break;
			case ov8858_HORIZONTAL_END_HIGH_REG:
				timings->crop_horizontal_end =
					((reg_table[j].val << 8) |
					(timings->crop_horizontal_end & 0xff));
				break;
			case ov8858_HORIZONTAL_END_LOW_REG:
				timings->crop_horizontal_end =
					(reg_table[j].val |
					(timings->crop_horizontal_end &
					0xff00));
				break;
			case ov8858_VERTICAL_END_HIGH_REG:
				timings->crop_vertical_end =
					((reg_table[j].val << 8) |
					(timings->crop_vertical_end & 0xff));
				break;
			case ov8858_VERTICAL_END_LOW_REG:
				timings->crop_vertical_end =
					(reg_table[j].val |
					(timings->crop_vertical_end & 0xff00));
				break;
			case ov8858_HORIZONTAL_OUTPUT_SIZE_HIGH_REG:
				timings->sensor_output_width =
					((reg_table[j].val << 8) |
					(timings->sensor_output_width & 0xff));
				break;
			case ov8858_HORIZONTAL_OUTPUT_SIZE_LOW_REG:
				timings->sensor_output_width =
					(reg_table[j].val |
					(timings->sensor_output_width &
					0xff00));
				break;
			case ov8858_VERTICAL_OUTPUT_SIZE_HIGH_REG:
				timings->sensor_output_height =
					((reg_table[j].val << 8) |
					(timings->sensor_output_height & 0xff));
				break;
			case ov8858_VERTICAL_OUTPUT_SIZE_LOW_REG:
				timings->sensor_output_height =
					(reg_table[j].val |
					(timings->sensor_output_height &
					0xff00));
				break;
			case ov8858_AEC_PK_LONG_EXPO_1ST_REG:
				timings->exp_time =
					((reg_table[j].val) |
					(timings->exp_time & 0xffff00));
				break;
			case ov8858_AEC_PK_LONG_EXPO_2ND_REG:
				timings->exp_time =
					((reg_table[j].val << 8) |
					(timings->exp_time & 0x00ff00));
				break;
			case ov8858_AEC_PK_LONG_EXPO_3RD_REG:
				timings->exp_time =
					(((reg_table[j].val & 0x0f) << 16) |
					(timings->exp_time & 0xff0000));
				break;
			case ov8858_AEC_PK_LONG_GAIN_LOW_REG:
				timings->gain =
					(reg_table[j].val |
					(timings->gain & 0x0700));
				break;
			case ov8858_AEC_PK_LONG_GAIN_HIGH_REG:
				timings->gain =
					(((reg_table[j].val & 0x07) << 8) |
					(timings->gain & 0xff));
				break;
			}
		}

		timings->exp_time >>= 4;
		timings->vt_pix_clk_freq_hz =
			config->frm_intrvl.interval.denominator
			* timings->frame_length_lines
			* timings->line_length_pck;

		timings->coarse_integration_time_min =
			ov8858_COARSE_INTG_TIME_MIN;
		timings->coarse_integration_time_max_margin =
			ov8858_COARSE_INTG_TIME_MAX_MARGIN;

		/* OV Sensor do not use fine integration time. */
		timings->fine_integration_time_min =
			ov8858_FINE_INTG_TIME_MIN;
		timings->fine_integration_time_max_margin =
			ov8858_FINE_INTG_TIME_MAX_MARGIN;
	}

	return 0;
}

static int ov8858_g_timings(struct ov_camera_module *cam_mod,
	struct ov_camera_module_timings *timings)
{
	int ret = 0;
	unsigned int vts;

	if (IS_ERR_OR_NULL(cam_mod->active_config))
		goto err;

	*timings = cam_mod->active_config->timings;

	vts = (!cam_mod->vts_cur) ?
		timings->frame_length_lines :
		cam_mod->vts_cur;
	if (cam_mod->frm_intrvl_valid)
		timings->vt_pix_clk_freq_hz =
			cam_mod->frm_intrvl.interval.denominator *
			vts * timings->line_length_pck;
	else
		timings->vt_pix_clk_freq_hz =
		cam_mod->active_config->frm_intrvl.interval.denominator *
		vts * timings->line_length_pck;

	timings->frame_length_lines = vts;

	return ret;
err:
	ov_camera_module_pr_err(cam_mod,
			"failed with error (%d)\n", ret);
	return ret;
}

/*--------------------------------------------------------------------------*/

static int ov8858_s_ctrl(struct ov_camera_module *cam_mod, u32 ctrl_id)
{
	int ret = 0;

	ov_camera_module_pr_debug(cam_mod, "\n");

	switch (ctrl_id) {
	case V4L2_CID_GAIN:
	case V4L2_CID_EXPOSURE:
		ret = ov8858_write_aec(cam_mod);
		break;
	case V4L2_CID_FLASH_LED_MODE:
		/* nothing to be done here */
		break;
	default:
		ret = -EINVAL;
		break;
	}

	if (IS_ERR_VALUE(ret))
		ov_camera_module_pr_debug(cam_mod,
			"failed with error (%d) 0x%x\n", ret, ctrl_id);
	return ret;
}

/*--------------------------------------------------------------------------*/

static int ov8858_enable_test_pattern(struct ov_camera_module *cam_mod,
				      u32 pattern)
{
	u32 val;

	if (pattern)
		val = (pattern - 1) | OV8858_TEST_PATTERN_ENABLE;
	else
		val = OV8858_TEST_PATTERN_DISABLE;

	return ov_camera_module_write_reg(cam_mod,
					  OV8858_REG_TEST_PATTERN, val);
}

static int ov8858_s_ext_ctrls(struct ov_camera_module *cam_mod,
				 struct ov_camera_module_ext_ctrls *ctrls)
{
	int ret = 0;

	if ((ctrls->ctrls[0].id == V4L2_CID_GAIN ||
		ctrls->ctrls[0].id == V4L2_CID_EXPOSURE))
		ret = ov8858_write_aec(cam_mod);
	else
		ret = -EINVAL;

	if (ctrls->ctrls[0].id == V4L2_CID_TEST_PATTERN)
		ret = ov8858_enable_test_pattern(cam_mod,
						 ctrls->ctrls[0].value);

	if (IS_ERR_VALUE(ret))
		ov_camera_module_pr_debug(cam_mod,
			"failed with error (%d)\n", ret);
	return ret;
}

/*--------------------------------------------------------------------------*/
int update_awb_gain(struct ov_camera_module *cam_mod)
{
	int R_gain = otp_ptr->R_gain;
	int G_gain = otp_ptr->G_gain;
	int B_gain = otp_ptr->B_gain;
	int ret = 0;

	if (R_gain > 0x400) {
		ret |= ov_camera_module_write_reg(cam_mod, 0x5032,
							R_gain >> 8);
		ret |= ov_camera_module_write_reg(cam_mod, 0x5033,
							R_gain & 0x00ff);
	}
	if (G_gain > 0x400) {
		ret |= ov_camera_module_write_reg(cam_mod, 0x5034,
							G_gain >> 8);
		ret |= ov_camera_module_write_reg(cam_mod, 0x5035,
							G_gain & 0x00ff);
	}
	if (B_gain > 0x400) {
		ret |= ov_camera_module_write_reg(cam_mod, 0x5036,
							B_gain >> 8);
		ret |= ov_camera_module_write_reg(cam_mod, 0x5037,
							B_gain & 0x00ff);
	}

	if (IS_ERR_VALUE(ret))
		ov_camera_module_pr_err(cam_mod, "otp awb gain apply failed\n");
	else
		ov_camera_module_pr_debug(cam_mod,
					"ov8858_update:%s, rgain:%x ggain %x bgain %x\n",
					__func__, R_gain, G_gain, B_gain);

	return ret;
}

int update_lenc(struct ov_camera_module *cam_mod)
{
	int i, temp = 0, ret = 0;

	ret |= ov_camera_module_read_reg(cam_mod, 1, 0x5000, &temp);
	temp = 0x80 | temp;
	ret |= ov_camera_module_write_reg(cam_mod, 0x5000, temp);

	if (IS_ERR_VALUE(ret)) {
		ov_camera_module_pr_err(cam_mod,
					"otp lenc apply failed at beginning\n");
		return ret;
	}

	for (i = 0; i < 240; i++) {
		ret |= ov_camera_module_write_reg(cam_mod, (0x5800 + i),
						otp_ptr->lenc[i]);
		if (IS_ERR_VALUE(ret)) {
			ov_camera_module_pr_err(cam_mod,
						"otp lenc apply failed during procesing\n");
			break;
		}
	}

	return ret;
}

static int ov8858_start_streaming(struct ov_camera_module *cam_mod)
{
	int ret = 0;

	ov_camera_module_pr_debug(cam_mod,
		"active config=%s\n", cam_mod->active_config->name);

	if (otp_ptr && otp_ptr->otp_en == 1 &&
	cam_mod->update_config &&
	cam_mod->active_config->soft_reset) {
		ov_camera_module_pr_debug(cam_mod,
					"apply otp data for R2A module...\n");
		update_awb_gain(cam_mod);
		update_lenc(cam_mod);
	}
	ret = ov8858_g_VTS(cam_mod, &cam_mod->vts_min);
	if (IS_ERR_VALUE(ret))
		goto err;

	mutex_lock(&cam_mod->lock);
	ret = ov_camera_module_write_reg(cam_mod, 0x0100, 1);
	mutex_unlock(&cam_mod->lock);
	if (IS_ERR_VALUE(ret))
		goto err;

	msleep(25);

	return 0;
err:
	ov_camera_module_pr_err(cam_mod, "failed with error (%d)\n",
		ret);
	return ret;
}

/*--------------------------------------------------------------------------*/

static int ov8858_stop_streaming(struct ov_camera_module *cam_mod)
{
	int ret = 0;

	ov_camera_module_pr_debug(cam_mod, "\n");

	mutex_lock(&cam_mod->lock);
	ret = ov_camera_module_write_reg(cam_mod, 0x0100, 0);
	mutex_unlock(&cam_mod->lock);
	if (IS_ERR_VALUE(ret))
		goto err;

	msleep(25);

	return 0;
err:
	ov_camera_module_pr_err(cam_mod, "failed with error (%d)\n", ret);
	return ret;
}

/*--------------------------------------------------------------------------*/
/*
 * call this function after ov8858 initialization
 * return value: 0 update success
 * 1, no OTP
 */
int  __ov8858_read_otp_wb(struct ov_camera_module *cam_mod)
{
	int otp_flag = 0;
	int addr = 0;
	int ret = 0;
	int temp1 = 0, temp2 = 0;

	ret = ov_camera_module_read_reg(cam_mod, 1, 0x7010, &otp_flag);
	if (IS_ERR_VALUE(ret)) {
		ov_camera_module_pr_err(cam_mod,
			"otp wb flag read failed\n");
		return ret;
	}
	ov_camera_module_pr_debug(cam_mod, "otp wb flag is %0x\n", otp_flag);

	if ((otp_flag & 0xc0) == 0x40)
		addr = 0x7011; /* set addr to group 1 base */
	else if ((otp_flag & 0x30) == 0x10)
		addr = 0x7019; /* set addr to group 2 base */

	if (addr != 0) {
		ov_camera_module_pr_debug(cam_mod,
					"otp wb addr is %0x\n", addr);
		otp_ptr->flag = 0xc0;
		ret |= ov_camera_module_read_reg(cam_mod, 1, addr,
					&otp_ptr->module_integrator_id);
		ret |= ov_camera_module_read_reg(cam_mod, 1, (addr + 1),
					&otp_ptr->lens_id);
		ret |= ov_camera_module_read_reg(cam_mod, 1, (addr + 2),
					&otp_ptr->production_year);
		ret |= ov_camera_module_read_reg(cam_mod, 1, (addr + 3),
					&otp_ptr->production_month);
		ret |= ov_camera_module_read_reg(cam_mod, 1, (addr + 4),
					&otp_ptr->production_day);
		ret |= ov_camera_module_read_reg(cam_mod, 1,
					(addr + 5), &temp1);
		ret |= ov_camera_module_read_reg(cam_mod, 1,
					(addr + 7), &temp2);
		otp_ptr->rg_ratio = (temp1 << 2) + (temp2 >> 6 & 0x03);
		ret |= ov_camera_module_read_reg(cam_mod, 1,
					(addr + 6), &temp1);
		otp_ptr->bg_ratio = (temp1 << 2) + (temp2 >> 4 & 0x03);

		if (IS_ERR_VALUE(ret)) {
			ov_camera_module_pr_err(cam_mod,
				"otp wb data read failed\n");
			return 1;
		}

	} else {
		ov_camera_module_pr_debug(cam_mod,
			"no valid module info and awb data in otp\n");
		otp_ptr->flag = 0;
		otp_ptr->module_integrator_id = 0;
		otp_ptr->lens_id = 0;
		otp_ptr->production_year = 0;
		otp_ptr->production_month = 0;
		otp_ptr->production_day = 0;
		otp_ptr->rg_ratio = 0;
		otp_ptr->bg_ratio = 0;
		return 1;
	}

	otp_ptr->R_gain = (RG_RATIO_TYPICAL * 1000) / otp_ptr->rg_ratio;
	otp_ptr->B_gain = (BG_RATIO_TYPICAL * 1000) / otp_ptr->bg_ratio;
	otp_ptr->G_gain = 1000;

	if (otp_ptr->R_gain < 1000 || otp_ptr->B_gain < 1000) {
		if (otp_ptr->R_gain < otp_ptr->B_gain)
			temp1 = otp_ptr->R_gain;
		else
			temp1 = otp_ptr->B_gain;
	} else {
		temp1 = otp_ptr->G_gain;
	}

	otp_ptr->R_gain = 0x400 * otp_ptr->R_gain / temp1;
	otp_ptr->B_gain = 0x400 * otp_ptr->B_gain / temp1;
	otp_ptr->G_gain = 0x400 * otp_ptr->G_gain / temp1;

	return ret;
}

int  __ov8858_read_otp_vcm(struct ov_camera_module *cam_mod)
{
	int otp_flag = 0;
	int addr = 0;
	int ret = 0;
	int temp1 = 0, temp2 = 0;

	ret = ov_camera_module_read_reg(cam_mod, 1, 0x7021, &otp_flag);
	if (IS_ERR_VALUE(ret)) {
		ov_camera_module_pr_err(cam_mod,
			"otp vcm flag read failed\n");
		return ret;
	}
	ov_camera_module_pr_debug(cam_mod, "otp vcm flag is %0x\n", otp_flag);

	if ((otp_flag & 0xc0) == 0x40)
		addr = 0x7022; /* set addr to group 1 base */
	else if ((otp_flag & 0x30) == 0x10)
		addr = 0x7025; /* set addr to group 2 base */

	if (addr != 0) {
		ov_camera_module_pr_debug(cam_mod,
					"otp vcm addr is %0x\n", addr);
		otp_ptr->flag |= 0x20;
		ret |= ov_camera_module_read_reg(cam_mod, 1, addr, &temp1);
		ret |= ov_camera_module_read_reg(cam_mod, 1,
					(addr + 2), &temp2);
		otp_ptr->VCM_start = (temp1 << 2) | (temp1 >> 6 & 0x03);
		ret |= ov_camera_module_read_reg(cam_mod, 1,
					(addr + 1), &temp1);
		otp_ptr->VCM_end = (temp1 << 2) + (temp2 >> 4 & 0x03);
		otp_ptr->VCM_dir = (temp2 >> 2 & 0x03);

		if (IS_ERR_VALUE(ret))
			ov_camera_module_pr_err(cam_mod,
						"otp vcm read fail!\n");
	} else {
		ov_camera_module_pr_debug(cam_mod,
					"no valid vcm data in otp\n");
		otp_ptr->VCM_end = 0;
		otp_ptr->VCM_end = 0;
		otp_ptr->VCM_dir = 0;
		return 1;
	}

	return ret;
}

int  __ov8858_read_otp_lenc(struct ov_camera_module *cam_mod)
{
	int otp_flag = 0;
	int addr = 0;
	int ret = 0, i = 0;
	int checksum = 0;

	ret = ov_camera_module_read_reg(cam_mod, 1, 0x7028, &otp_flag);
	if (IS_ERR_VALUE(ret)) {
		ov_camera_module_pr_err(cam_mod,
			"otp lenc flag read failed\n");
		return ret;
	}

	ov_camera_module_pr_debug(cam_mod,
				"otp lenc flag is 0x%0x\n", otp_flag);

	if ((otp_flag & 0xc0) == 0x40)
		addr = 0x7029; /* set addr to group 1 base */
	else if ((otp_flag & 0x30) == 0x10)
		addr = 0x711a; /* set addr to group 2 base */

	if (addr != 0) {
		for (i = 0; i < 240; i++) {
			ret |= ov_camera_module_read_reg(cam_mod, 1, (addr + i),
							&otp_ptr->lenc[i]);
			if (IS_ERR_VALUE(ret)) {
				ov_camera_module_pr_err(cam_mod,
					"otp lenc data read failed\n");
					return ret;
			}
			checksum += otp_ptr->lenc[i];
		}

		checksum = (checksum) % 255 + 1;
		ret |= ov_camera_module_read_reg(cam_mod, 1, (addr + 240),
						&otp_ptr->checksum);
		if (IS_ERR_VALUE(ret)) {
			ov_camera_module_pr_err(cam_mod,
				"otp lenc checksum read failed\n");
				return ret;
		}

		if (otp_ptr->checksum == checksum) {
			otp_ptr->flag |= 0x10;
		} else {
			ov_camera_module_pr_err(cam_mod,
				"otp lenc checksum no match!\n");
			return 1;
		}
	} else {
		for (i = 0; i < 240; i++) {
			ov_camera_module_pr_debug(cam_mod,
				"no valid lenc data in otp\n");
			otp_ptr->lenc[i] = 0;
		}
		return 1;
	}

	return ret;
}

static int ov8858_otp_read(struct ov_camera_module *cam_mod)
{
	int ret = 0;
	int temp = 0;
	int reg = 0;
	int otp_ret = 0;
	struct i2c_client *client = v4l2_get_subdevdata(&cam_mod->sd);

	ov_camera_module_pr_debug(cam_mod, "\n");

	if (otp_ptr) {
		ov_camera_module_pr_debug(cam_mod, "OTP data loaded already\n");
		return 0;
	}

	otp_ptr = kzalloc(sizeof(*otp_ptr), GFP_KERNEL);
	if (!otp_ptr) {
		ov_camera_module_pr_err(cam_mod, "otp alloc fail!\n");
		return -ENOMEM;
	}

	ov_camera_module_write_reg(cam_mod, 0x0100, 1);

	/* set 0x5002[3] to "0" before ops */
	ret = ov_camera_module_read_reg(cam_mod, 1, 0x5002, &temp);
	if (IS_ERR_VALUE(ret)) {
		ov_camera_module_pr_err(cam_mod,
			"otp read failed at phase1\n");
		return ret;
	}

	ov_camera_module_pr_debug(cam_mod, "otp read phase1 pass\n");

	ret |= ov_camera_module_write_reg(cam_mod, 0x5002,
			((temp & (~0x08))));

	ret |= ov_camera_module_write_reg(cam_mod, 0x3d84, 0xc0);
	/* otp start addr */
	ret |= ov_camera_module_write_reg(cam_mod, 0x3d88, 0x70);
	ret |= ov_camera_module_write_reg(cam_mod, 0x3d89, 0x10);
	/* otp end addr */
	ret |= ov_camera_module_write_reg(cam_mod, 0x3d8A, 0x72);
	ret |= ov_camera_module_write_reg(cam_mod, 0x3d8B, 0x0a);
	/* load otp into buffer */
	ret |= ov_camera_module_write_reg(cam_mod, 0x3d81, 0x01);
	if (IS_ERR_VALUE(ret)) {
		ov_camera_module_pr_err(cam_mod,
			"otp read failed at phase2\n");
		return ret;
	}

	ov_camera_module_pr_debug(cam_mod, "otp read phase2 pass\n");

	usleep_range(10000, 15000);

	/* otp wb read */
	otp_ret = __ov8858_read_otp_wb(cam_mod);

	if (otp_ret)
		ov_camera_module_pr_err(cam_mod, "fail to read OTP wb!\n");
	else
		ov_camera_module_pr_debug(cam_mod, "read otp wb success\n");

	/* otp vcm read */
	otp_ret = __ov8858_read_otp_vcm(cam_mod);

	if (otp_ret)
		ov_camera_module_pr_err(cam_mod, "fail to read OTP vcm!\n");
	else
		ov_camera_module_pr_debug(cam_mod, "read otp vcm success\n");

	/* otp lenc read */
	otp_ret = __ov8858_read_otp_lenc(cam_mod);

	if (otp_ret) {
		ov_camera_module_pr_err(cam_mod, "fail to read OTP lenc!\n");
		goto readotperr;
	} else {
		ov_camera_module_pr_debug(cam_mod, "read otp lenc success\n");
	}
	/* clear data afer read */
	for (reg = 0x7010; reg <= 0x720a; reg++) {
		ret |= ov_camera_module_write_reg(cam_mod, reg, 0);
		if (IS_ERR_VALUE(ret)) {
			ov_camera_module_pr_err(cam_mod,
				"otp clear data failed at phase3\n");
			return ret;
		}
	}

readotperr:
	/* set 0x5002[3] to "1" after ops */
	ret = ov_camera_module_read_reg(cam_mod, 1, 0x5002, &temp);
	if (IS_ERR_VALUE(ret)) {
		ov_camera_module_pr_err(cam_mod,
			"otp exit failed at phase 4\n");
		return ret;
	}

	ov_camera_module_pr_debug(cam_mod, "0x5002 is 0x%0x\n", temp);

	ret |= ov_camera_module_write_reg(cam_mod, 0x5002,
					(0x08 | (temp & (~0x08))));
	ov_camera_module_write_reg(cam_mod, 0x0100, 0);
	if (otp_ret) {
		otp_ptr->otp_en = 0;
		ov_camera_module_pr_err(
		cam_mod,
		"get otp data failed\n");
	} else {
		otp_ptr->otp_en = 1;
		dev_info(&client->dev, "get otp data success\n");
	}
	return ret;
}

/*--------------------------------------------------------------------------*/

static int ov8858_check_camera_id(struct ov_camera_module *cam_mod)
{
	u32 pidh, pidl, vid = 0;
	int ret = 0;
	struct i2c_client *client;

	ov_camera_module_pr_debug(cam_mod, "\n");

	ret |= ov_camera_module_read_reg(cam_mod, 1, ov8858_PIDH_ADDR, &pidh);
	ret |= ov_camera_module_read_reg(cam_mod, 1, ov8858_PIDL_ADDR, &pidl);
	if (IS_ERR_VALUE(ret)) {
		ov_camera_module_pr_err(cam_mod,
			"register read failed, camera module powered off?\n");
		goto err;
	}

	if ((pidh == ov8858_PIDH_MAGIC) && (pidl == ov8858_PIDL_MAGIC))
		ov_camera_module_pr_debug(cam_mod,
			"successfully detected camera ID 0x%02x%02x\n",
			pidh, pidl);
	else {
		ov_camera_module_pr_err(cam_mod,
			"wrong camera ID, expected 0x%02x%02x, detected 0x%02x%02x\n",
			ov8858_PIDH_MAGIC, ov8858_PIDL_MAGIC, pidh, pidl);
		ret = -EINVAL;
		goto err;
	}

	ret |= ov_camera_module_read_reg(cam_mod, 1, 0x302a, &vid);
	if (IS_ERR_VALUE(ret)) {
		ov_camera_module_pr_err(cam_mod,
			"register read failed, camera module powered off?\n");
		goto err;
	} else
		ov_camera_module_pr_debug(cam_mod,
			"ov8858 chip version is 0x%2x\n", vid);

	client = v4l2_get_subdevdata(&cam_mod->sd);
	if ((vid == 0xb1) || (vid == 0xb0)) {
		ov8858_custom_config.configs = ov8858_configs_R1A;
		ov8858_custom_config.num_configs =
			sizeof(ov8858_configs_R1A)
			/ sizeof(ov8858_configs_R1A[0]);
		dev_info(&client->dev, "init setting for r1a\n");
	} else {
		dev_info(&client->dev, "init setting for r2a\n");
	}

	ov8858_filltimings(&ov8858_custom_config);
	cam_mod->custom = ov8858_custom_config;

	ov_camera_module_pr_debug(cam_mod,
		"ov8858 chip version is 0x%2x,module config no. is %d\n",
		vid,
		cam_mod->custom.num_configs);
	return 0;
err:
	ov_camera_module_pr_err(cam_mod, "failed with error (%d)\n", ret);
	return ret;
}

/* ======================================================================== */
/* This part is platform dependent */
/* ======================================================================== */

static struct v4l2_subdev_core_ops ov8858_camera_module_core_ops = {
	.g_ctrl = ov_camera_module_g_ctrl,
	.s_ctrl = ov_camera_module_s_ctrl,
	.s_ext_ctrls = ov_camera_module_s_ext_ctrls,
	.s_power = ov_camera_module_s_power,
	.ioctl = ov_camera_module_ioctl
};

static struct v4l2_subdev_video_ops ov8858_camera_module_video_ops = {
	.s_frame_interval = ov_camera_module_s_frame_interval,
	.g_frame_interval = ov_camera_module_g_frame_interval,
	.s_stream = ov_camera_module_s_stream
};

static struct v4l2_subdev_pad_ops ov8858_camera_module_pad_ops = {
	.enum_frame_interval = ov_camera_module_enum_frameintervals,
	.get_fmt = ov_camera_module_g_fmt,
	.set_fmt = ov_camera_module_s_fmt,
};

static struct v4l2_subdev_ops ov8858_camera_module_ops = {
	.core = &ov8858_camera_module_core_ops,
	.video = &ov8858_camera_module_video_ops,
	.pad = &ov8858_camera_module_pad_ops
};

static struct ov_camera_module_custom_config ov8858_custom_config = {
	.start_streaming = ov8858_start_streaming,
	.stop_streaming = ov8858_stop_streaming,
	.s_ctrl = ov8858_s_ctrl,
	.s_ext_ctrls = ov8858_s_ext_ctrls,
	.g_ctrl = ov8858_g_ctrl,
	.g_timings = ov8858_g_timings,
	.check_camera_id = ov8858_check_camera_id,
	.s_vts = ov8858_auto_adjust_fps,
	.read_otp = ov8858_otp_read,
	.configs = ov8858_configs,
	.num_configs = ARRAY_SIZE(ov8858_configs),
	.power_up_delays_ms = {5, 20, 0},
	/*
	*0: Exposure time valid fileds;
	*1: Exposure gain valid fileds;
	*(2 fileds == 1 frames)
	*/
	.exposure_valid_frame = {4, 4}
};

static int ov8858_probe(
	struct i2c_client *client,
	const struct i2c_device_id *id)
{
	dev_info(&client->dev, "probing...\n");
	ov8858_filltimings(&ov8858_custom_config);
	v4l2_i2c_subdev_init(&ov8858.sd, client, &ov8858_camera_module_ops);
	ov8858.sd.flags |= V4L2_SUBDEV_FL_HAS_DEVNODE;
	ov8858.custom = ov8858_custom_config;

	mutex_init(&ov8858.lock);
	dev_info(&client->dev, "probing successful\n");

	return 0;
}

static int ov8858_remove(struct i2c_client *client)
{
	struct ov_camera_module *cam_mod = i2c_get_clientdata(client);

	dev_info(&client->dev, "removing device...\n");

	if (!client->adapter)
		return -ENODEV;	/* our client isn't attached */

	mutex_destroy(&cam_mod->lock);
	ov_camera_module_release(cam_mod);

	kfree(otp_ptr);
	dev_info(&client->dev, "removed\n");
	return 0;
}

static const struct i2c_device_id ov8858_id[] = {
	{ ov8858_DRIVER_NAME, 0 },
	{ }
};

static const struct of_device_id ov8858_of_match[] = {
	{.compatible = "omnivision,ov8858-v4l2-i2c-subdev"},
	{},
};

MODULE_DEVICE_TABLE(i2c, ov8858_id);

static struct i2c_driver ov8858_i2c_driver = {
	.driver = {
		.name = ov8858_DRIVER_NAME,
		.owner = THIS_MODULE,
		.of_match_table = ov8858_of_match
	},
	.probe = ov8858_probe,
	.remove = ov8858_remove,
	.id_table = ov8858_id,
};

module_i2c_driver(ov8858_i2c_driver);

MODULE_DESCRIPTION("SoC Camera driver for ov8858");
MODULE_AUTHOR("George");
MODULE_LICENSE("GPL");
