/*
 * drivers/input/touchscreen/gslx680_d708/rockchip_gslX680_88v.h
 *
 * Copyright (c) 2017 rokchip
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 */

#ifndef _GSLX680_H_
#define _GSLX680_H_

#define SCREEN_MAX_X	800
#define SCREEN_MAX_Y	480

struct fw_data {
	u32 offset : 8;
	u32:0;
	u32 val;
};

#define GSL1680F_COMPATIBLE
#define	GSL1680F_NEWCOMMON

static unsigned int gsl_config_data_id_1680f[512] = {
	0x8dbd3c,
	0x200,
	0, 0,
	0,
	0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0xd7f66401,


	0x40000900, 0x5, 0xa000f, 0xa000f, 0x1e00320, 0, 0x5100, 0xdf00,
	0, 0x320014, 0, 0, 0, 0, 0, 0,
	0x4, 0x4000, 0x4000, 0x112b0014, 0x109f0007, 0, 0, 0x5050707,
	0x1b6db688, 0x240, 0x9a0019, 0x930023, 0x8d002d, 0x860037, 0x9a0019, 0x930023,
	0x8d002d, 0x860037, 0x93000a, 0x8d000f, 0x860014, 0x800019, 0x93000a, 0x8d000f,
	0x860014, 0x800019, 0x804000, 0x90040, 0x90001, 0, 0, 0,
	0, 0, 0, 0x14012c, 0xa003c, 0xa0078, 0x400, 0x1081,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,

	0,
	0x3200384, 0x64, 0x503e8,
	0, 0, 0,
	0, 0, 0,
	0, 0, 0,
	0, 0, 0,
	0, 0, 0,
	0, 0, 0,
	0, 0, 0,

	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,


	0x221,
	0, 0, 0, 0, 0, 0, 0, 0,
	0x1000000, 0x4030201, 0x8070606, 0xc0b0a09, 0xf0e0d0d, 0x13121110, 0x18171614, 0x1d1c1a19,
	0x2321201f, 0x28272624, 0x2d2c2a29, 0x31302f2e, 0x35343332, 0x39383736, 0x3d3c3b3a, 0x3f3f3e3e,
	0, 0x2010000, 0x5040303, 0x9080706, 0xc0b0a09, 0x100f0e0d, 0x15141312, 0x1c1a1817,
	0x23211f1d, 0x2a282625, 0x2f2e2d2b, 0x33323130, 0x36363534, 0x3a393837, 0x3d3c3b3b, 0x3f3f3e3e,

	0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c, 0x13121110, 0x17161514, 0x1b1a1918, 0x1f1e1d1c,
	0x23222120, 0x27262524, 0x2b2a2928, 0x2f2e2d2c, 0x33323130, 0x37363534, 0x3b3a3938, 0x3f3e3d3c,

	0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c, 0x13121110, 0x17161514, 0x1b1a1918, 0x1f1e1d1c,
	0x23222120, 0x27262524, 0x2b2a2928, 0x2f2e2d2c, 0x33323130, 0x37363534, 0x3b3a3938, 0x3f3e3d3c,

	0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c, 0x13121110, 0x17161514, 0x1b1a1918, 0x1f1e1d1c,
	0x23222120, 0x27262524, 0x2b2a2928, 0x2f2e2d2c, 0x33323130, 0x37363534, 0x3b3a3938, 0x3f3e3d3c,

	0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c, 0x13121110, 0x17161514, 0x1b1a1918, 0x1f1e1d1c,
	0x23222120, 0x27262524, 0x2b2a2928, 0x2f2e2d2c, 0x33323130, 0x37363534, 0x3b3a3938, 0x3f3e3d3c,

	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,


	0x3,
	0x101, 0, 0x100, 0,
	0x20, 0x10, 0x8, 0x4,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,

	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
};
static const struct fw_data GSL1680F_FW[] = {

{0xf0, 0x2},
{0x00, 0x00000000},
{0x04, 0x00000000},
{0x08, 0x00000000},
{0x0c, 0x00000000},
{0x10, 0x00000000},
{0x14, 0x00000000},
{0x18, 0x00000000},
{0x1c, 0x00000000},
{0x20, 0x00000000},
{0x24, 0x00000000},
{0x28, 0x00000000},
{0x2c, 0x00000000},
{0x30, 0x00000000},
{0x34, 0x00000000},
{0x38, 0x00000000},
{0x3c, 0x00000000},
{0x40, 0x00000000},
{0x44, 0x00000000},
{0x48, 0x00000000},
{0x4c, 0x00000000},
{0x50, 0x00000000},
{0x54, 0x00000000},
{0x58, 0x00000000},
{0x5c, 0x00000000},
{0x60, 0x00000000},
{0x64, 0x00000000},
{0x68, 0x00000000},
{0x6c, 0x00000000},
{0x70, 0x00000000},
{0x74, 0x00000000},
{0x78, 0x00000000},
{0x7c, 0x12378654},
{0xf0, 0x3},
{0x00, 0x60667442},
{0x04, 0x00000000},
{0x08, 0x00000000},
{0x0c, 0x00000000},
{0x10, 0x00000000},
{0x14, 0x00000000},
{0x18, 0x00000000},
{0x1c, 0x00000000},
{0x20, 0x00000000},
{0x24, 0x00005100},
{0x28, 0x0000df00},
{0x2c, 0x00000000},
{0x30, 0x00000000},
{0x34, 0x00000000},
{0x38, 0x00000000},
{0x3c, 0x00000000},
{0x40, 0x00000000},
{0x44, 0x00000000},
{0x48, 0x00000000},
{0x4c, 0x00000000},
{0x50, 0x00000000},
{0x54, 0x00000000},
{0x58, 0x00000000},
{0x5c, 0x00000014},
{0x60, 0x00000000},
{0x64, 0x1a0ac00a},
{0x68, 0x00000002},
{0x6c, 0x0000000f},
{0x70, 0x00000000},
{0x74, 0x00000000},
{0x78, 0xffffffec},
{0x7c, 0x00000000},
{0xf0, 0x4},
{0x00, 0x00000000},
{0x04, 0x00000000},
{0x08, 0x00000000},
{0x0c, 0x00000000},
{0x10, 0xfe0cff06},
{0x14, 0x00000000},
{0x18, 0x00000000},
{0x1c, 0x00000000},
{0x20, 0x00000000},
{0x24, 0x00000000},
{0x28, 0x00000000},
{0x2c, 0x00000000},
{0x30, 0x00010000},
{0x34, 0x00000000},
{0x38, 0x0000000a},
{0x3c, 0x00000258},
{0x40, 0x00000000},
{0x44, 0x04020a00},
{0x48, 0x0014012c},
{0x4c, 0x9a000000},
{0x50, 0x00000000},
{0x54, 0x00010203},
{0x58, 0x04050607},
{0x5c, 0x08090a0b},
{0x60, 0x0c0d0e0f},
{0x64, 0x10111213},
{0x68, 0x14151617},
{0x6c, 0x18191a1b},
{0x70, 0x1c1d1e1f},
{0x74, 0x0014000a},
{0x78, 0x80808080},
{0x7c, 0xcba981f4},
{0xf0, 0x5},
{0x00, 0x00000000},
{0x04, 0x00000005},
{0x08, 0x000000b4},
{0x0c, 0x66666666},
{0x10, 0x0000000a},
{0x14, 0x00000000},
{0x18, 0x00000fff},
{0x1c, 0x112b0014},
{0x20, 0x109f0007},
{0x24, 0x00000000},
{0x28, 0x00000000},
{0x2c, 0x00000000},
{0x30, 0x80808080},
{0x34, 0x80808080},
{0x38, 0x80808080},
{0x3c, 0x80808080},
{0x40, 0x80808080},
{0x44, 0x80808080},
{0x48, 0x80808080},
{0x4c, 0x80808000},
{0x50, 0xffffffff},
{0x54, 0x00000000},
{0x58, 0x00000000},
{0x5c, 0x00000000},
{0x60, 0x00000000},
{0x64, 0x00000000},
{0x68, 0x00000000},
{0x6c, 0x00000000},
{0x70, 0x00000000},
{0x74, 0x00000221},
{0x78, 0x0000000f},
{0x7c, 0x0000000a},
{0xf0, 0x6},
{0x00, 0x0000000f},
{0x04, 0x00000000},
{0x08, 0x0000000a},
{0x0c, 0x04040403},
{0x10, 0x00000032},
{0x14, 0x140a140a},
{0x18, 0x00000000},
{0x1c, 0x00000001},
{0x20, 0x00002904},
{0x24, 0x000001e0},
{0x28, 0x00000320},
{0x2c, 0xf8010014},
{0x30, 0xf8010014},
{0x34, 0x00000005},
{0x38, 0x00000003},
{0x3c, 0x00000fff},
{0x40, 0x80000000},
{0x44, 0x001e001e},
{0x48, 0x00000fff},
{0x4c, 0x04040403},
{0x50, 0x00020001},
{0x54, 0x00000240},
{0x58, 0x00004000},
{0x5c, 0x1b6db688},
{0x60, 0x20100804},
{0x64, 0x00000000},
{0x68, 0x00000000},
{0x6c, 0x00000000},
{0x70, 0x00000000},
{0x74, 0x000000e1},
{0x78, 0x000a003c},
{0x7c, 0x00000000},
{0xf0, 0x7},
{0x00, 0x01040007},
{0x04, 0x03060209},
{0x08, 0x0508040a},
{0x0c, 0x07110610},
{0x10, 0x09130812},
{0x14, 0x00123456},
{0x18, 0x00000000},
{0x1c, 0x000a0078},
{0x20, 0x00001081},
{0x24, 0xff080010},
{0x28, 0xff080120},
{0x2c, 0xff080140},
{0x30, 0xff080160},
{0x34, 0x00000104},
{0x38, 0x000000e1},
{0x3c, 0x000000be},
{0x40, 0x00000000},
{0x44, 0x00000000},
{0x48, 0x40000900},
{0x4c, 0x320f0f03},
{0x50, 0x00000000},
{0x54, 0x00000004},
{0x58, 0x00000000},
{0x5c, 0x00080001},
{0x60, 0x000d0009},
{0x64, 0x000e000e},
{0x68, 0x00000000},
{0x6c, 0x00050002},
{0x70, 0x00040002},
{0x74, 0x00000000},
{0x78, 0x00012345},
{0x7c, 0x006789ab},
{0xf0, 0x8},
{0x00, 0x026f228f},
{0x04, 0x22af22cf},
{0x08, 0x22ef230f},
{0x0c, 0x232f234f},
{0x10, 0x21f341f4},
{0x14, 0x41f541f6},
{0x18, 0x41f741f8},
{0x1c, 0x71f901fa},
{0x20, 0x01f401f5},
{0x24, 0x01f601f7},
{0x28, 0x01f801f9},
{0x2c, 0x01fa0000},
{0x30, 0x00000000},
{0x34, 0x00000000},
{0x38, 0x00000000},
{0x3c, 0x00000000},
{0x40, 0x01020304},
{0x44, 0x05060708},
{0x48, 0x090a0000},
{0x4c, 0x00000000},
{0x50, 0x00000000},
{0x54, 0x00000000},
{0x58, 0x00040003},
{0x5c, 0x00000008},
{0x60, 0x0000015e},
{0x64, 0x00040302},
{0x68, 0x00080804},
{0x6c, 0x0000009a},
{0x70, 0x000000cd},
{0x74, 0x00000079},
{0x78, 0x00000000},
{0x7c, 0x0000000a},
{0xf0, 0x9},
{0x00, 0xff080094},
{0x04, 0x00070011},
{0x08, 0xff080090},
{0x0c, 0x00040000},
{0x10, 0xff080068},
{0x14, 0x00030000},
{0x18, 0xff080064},
{0x1c, 0x01002582},
{0x20, 0xff080060},
{0x24, 0x00000000},
{0x28, 0xff08004c},
{0x2c, 0x00197fff},
{0x30, 0xfffffff0},
{0x34, 0x00000000},
{0x38, 0xfffffff0},
{0x3c, 0x00000000},
{0x40, 0xfffffff0},
{0x44, 0x00000000},
{0x48, 0xfffffff0},
{0x4c, 0x00000000},
{0x50, 0xfffffff0},
{0x54, 0x00000000},
{0x58, 0xfffffff0},
{0x5c, 0x00000000},
{0x60, 0xfffffff0},
{0x64, 0x00000000},
{0x68, 0xfffffff0},
{0x6c, 0x00000000},
{0x70, 0xfffffff0},
{0x74, 0x00000000},
{0x78, 0xfffffff0},
{0x7c, 0x00000000},
/*
{0xf0, 0xe0},
{0x00, 0x00030000},
{0x04, 0x00200012},
{0x08, 0x003d0031},
{0x0c, 0x003f003e},
{0x10, 0x0025003a},
{0x14, 0x002a0036},
{0x18, 0x0030003a},
{0x1c, 0x003c0030},
{0x20, 0x0034003a},
{0x24, 0x003a0037},
{0x28, 0x0036003f},
{0x2c, 0x00320036},
{0x30, 0x00480046},
{0x34, 0x00440040},
{0x38, 0x004b0049},
{0x3c, 0x0049005b},
{0x40, 0x006401f4},
{0x44, 0x00640064},
{0x48, 0x01900064},
{0x4c, 0x00500190},
{0x50, 0x00500050},
{0x54, 0x012c0050},
{0x58, 0x012c012c},
{0x5c, 0x0034012c},
{0x60, 0x00640000},
{0x64, 0x00640064},
{0x68, 0x00000032},
{0x6c, 0x00500000},
{0x70, 0x00000000},
{0x74, 0x00000000},
{0x78, 0x00000000},
{0x7c, 0x00000000},
{0xf0, 0xe1},
{0x00, 0x00000000},
{0x04, 0x00030000},
{0x08, 0x00220004},
{0x0c, 0x002b0025},
{0x10, 0x00250035},
{0x14, 0x002e0032},
{0x18, 0x00350032},
{0x1c, 0x00300038},
{0x20, 0x003f002c},
{0x24, 0x00420036},
{0x28, 0x003a003b},
{0x2c, 0x00480032},
{0x30, 0x00460048},
{0x34, 0x0052003e},
{0x38, 0x005e005c},
{0x3c, 0x0058005b},
{0x40, 0x00000000},
{0x44, 0x00000000},
{0x48, 0x00000000},
{0x4c, 0x00000000},
{0x50, 0x00000002},
{0x54, 0x00000000},
{0x58, 0x00000000},
{0x5c, 0x00000000},
{0x60, 0x00000000},
{0x64, 0x00000000},
{0x68, 0x00000000},
{0x6c, 0x00000000},
{0x70, 0x00000000},
{0x74, 0x00000000},
{0x78, 0x00000000},
{0x7c, 0x00000000},
{0xf0, 0xe2},
{0x00, 0x00450053},
{0x04, 0x00520059},
{0x08, 0x0051004a},
{0x0c, 0x0048004f},
{0x10, 0x00520035},
{0x14, 0x0051003d},
{0x18, 0x0039003d},
{0x1c, 0x003f0033},
{0x20, 0x0037003b},
{0x24, 0x003a003b},
{0x28, 0x003b003c},
{0x2c, 0x00370031},
{0x30, 0x002d0031},
{0x34, 0x00370037},
{0x38, 0x002a0037},
{0x3c, 0x0001000b},
{0x40, 0x005f006f},
{0x44, 0x0073006b},
{0x48, 0x00740060},
{0x4c, 0x005a0057},
{0x50, 0x004a0058},
{0x54, 0x003c004c},
{0x58, 0x003d0036},
{0x5c, 0x002f0035},
{0x60, 0x00380034},
{0x64, 0x00260031},
{0x68, 0x00300030},
{0x6c, 0x00320033},
{0x70, 0x002e0028},
{0x74, 0x002e0029},
{0x78, 0x001d002d},
{0x7c, 0x00040018},
{0xf0, 0xe3},
{0x00, 0x00000000},
{0x04, 0x00000000},
{0x08, 0x00000000},
{0x0c, 0x00000000},
{0x10, 0x00000000},
{0x14, 0x00000000},
{0x18, 0x00000000},
{0x1c, 0x00000000},
{0x20, 0x00000000},
{0x24, 0x00000000},
{0x28, 0x00000000},
{0x2c, 0x00000000},
{0x30, 0x00000000},
{0x34, 0x00000000},
{0x38, 0x00000000},
{0x3c, 0x00000000},
{0x40, 0x00000000},
{0x44, 0x00000000},
{0x48, 0x00000000},
{0x4c, 0x00000000},
{0x50, 0x00000000},
{0x54, 0x00000000},
{0x58, 0x00000000},
{0x5c, 0x00000000},
{0x60, 0x00000000},
{0x64, 0x00000000},
{0x68, 0x00000000},
{0x6c, 0x00000000},
{0x70, 0x00000000},
{0x74, 0x00000000},
{0x78, 0x00000000},
{0x7c, 0x00000000},
{0xf0, 0xe4},
{0x00, 0x00000000},
{0x04, 0x00000000},
{0x08, 0x00000000},
{0x0c, 0x00000000},
{0x10, 0x00000000},
{0x14, 0x00000000},
{0x18, 0x00000000},
{0x1c, 0x00000000},
{0x20, 0x00000000},
{0x24, 0x00000000},
{0x28, 0x00000000},
{0x2c, 0x00000000},
{0x30, 0x00000000},
{0x34, 0x00000000},
{0x38, 0x00000000},
{0x3c, 0x00000000},
{0x40, 0x00000000},
{0x44, 0x00000000},
{0x48, 0x00000000},
{0x4c, 0x00000000},
{0x50, 0x00000000},
{0x54, 0x00000000},
{0x58, 0x00000000},
{0x5c, 0x00000000},
{0x60, 0x00000000},
{0x64, 0x00000000},
{0x68, 0x00000000},
{0x6c, 0x00000000},
{0x70, 0x00000000},
{0x74, 0x00000000},
{0x78, 0x00000000},
{0x7c, 0x00000000},
{0xf0, 0xe5},
{0x00, 0x00000000},
{0x04, 0x00000000},
{0x08, 0x00000000},
{0x0c, 0x00000000},
{0x10, 0x00000000},
{0x14, 0x00000000},
{0x18, 0x00000000},
{0x1c, 0x00000000},
{0x20, 0x00000000},
{0x24, 0x00000000},
{0x28, 0x00000000},
{0x2c, 0x00000000},
{0x30, 0x00000000},
{0x34, 0x00000000},
{0x38, 0x00000000},
{0x3c, 0x00000000},
{0x40, 0x00000000},
{0x44, 0x00000000},
{0x48, 0x00000000},
{0x4c, 0x00000000},
{0x50, 0x00000000},
{0x54, 0x00000000},
{0x58, 0x00000000},
{0x5c, 0x00000000},
{0x60, 0x00000000},
{0x64, 0x00000000},
{0x68, 0x00000000},
{0x6c, 0x00000000},
{0x70, 0x00000000},
{0x74, 0x00000000},
{0x78, 0x00000000},
{0x7c, 0x00000000},
{0xf0, 0xe6},
{0x00, 0x00000000},
{0x04, 0x00000000},
{0x08, 0x00000000},
{0x0c, 0x00000000},
{0x10, 0x00000000},
{0x14, 0x00000000},
{0x18, 0x00000000},
{0x1c, 0x00000000},
{0x20, 0x00000000},
{0x24, 0x00000000},
{0x28, 0x00000000},
{0x2c, 0x00000000},
{0x30, 0x00000000},
{0x34, 0x00000000},
{0x38, 0x00000000},
{0x3c, 0x00000000},
{0x40, 0x00000000},
{0x44, 0x00000000},
{0x48, 0x00000000},
{0x4c, 0x00000000},
{0x50, 0x00000000},
{0x54, 0x00000000},
{0x58, 0x00000000},
{0x5c, 0x00000000},
{0x60, 0x00000000},
{0x64, 0x00000000},
{0x68, 0x00000000},
{0x6c, 0x00000000},
{0x70, 0x00000000},
{0x74, 0x00000000},
{0x78, 0x00000000},
{0x7c, 0x00000000},
*/



{0xf0, 0x1e},
{0x00, 0x5a5a0f00},
{0x04, 0x00002b9c},
{0x08, 0x00002c04},
{0x0c, 0x00002c7c},
{0x10, 0x00002dac},
{0x14, 0x00002e98},
{0x18, 0x0000306c},
{0x1c, 0x00003208},
{0x20, 0x0000337c},
{0x24, 0x00003544},
{0x28, 0x00003764},
{0x2c, 0x000039d8},
{0x30, 0x00003b4c},
{0x34, 0x00003bfc},
{0x38, 0x00003d28},
{0x3c, 0x0000407c},
{0x40, 0x00004120},
{0x44, 0x00004224},
{0x48, 0x00004408},
{0x4c, 0x00004528},
{0x50, 0x000045e4},
{0x54, 0x000047dc},
{0x58, 0x00004ac0},
{0x5c, 0x00004e5c},
{0x60, 0x00004f40},
{0x64, 0x00004f80},
{0x68, 0x0000509c},
{0x6c, 0x00000000},
{0x70, 0x00000000},
{0x74, 0x00000000},
{0x78, 0x00000000},
{0x7c, 0x00000000},
{0xf0, 0x1f},
{0x00, 0x00000000},
{0x04, 0x00000000},
{0x08, 0x00000000},
{0x0c, 0x00000000},
{0x10, 0x00000000},
{0x14, 0x00000000},
{0x18, 0x00000000},
{0x1c, 0x00000000},
{0x20, 0x00000000},
{0x24, 0x00000000},
{0x28, 0x00000000},
{0x2c, 0x00000000},
{0x30, 0x00000000},
{0x34, 0x00000000},
{0x38, 0x00000000},
{0x3c, 0x00000000},
{0x40, 0x00000000},
{0x44, 0x00000000},
{0x48, 0x00000000},
{0x4c, 0x00002644},
{0x50, 0x000026f4},
{0x54, 0x00000000},
{0x58, 0x000027a4},
{0x5c, 0x00000000},
{0x60, 0x00000000},
{0x64, 0x000028c0},
{0x68, 0x00000000},
{0x6c, 0x00002984},
{0x70, 0x00002afc},
{0x74, 0x00000000},
{0x78, 0x00005128},
{0x7c, 0x5a5a0ffc},
{0xf0, 0x0},
{0x00, 0x01000000},
{0x04, 0x01000000},
{0x08, 0x01000000},
{0x0c, 0x233fc0c0},
{0x10, 0xa2146004},
{0x14, 0xa4102000},
{0x18, 0xe4244000},
{0x1c, 0x233fc0c0},
{0x20, 0xa2146010},
{0x24, 0x2500003f},
{0x28, 0xa414a3ff},
{0x2c, 0xe4244000},
{0x30, 0x01000000},
{0x34, 0x821020e0},
{0x38, 0x81880001},
{0x3c, 0x01000000},
{0x40, 0x01000000},
{0x44, 0xa410200f},
{0x48, 0xe4a00040},
{0x4c, 0x01000000},
{0x50, 0xa0100000},
{0x54, 0xa2100000},
{0x58, 0xa4100000},
{0x5c, 0xa6100000},
{0x60, 0xa8100000},
{0x64, 0xaa100000},
{0x68, 0xac100000},
{0x6c, 0xae100000},
{0x70, 0x90100000},
{0x74, 0x92100000},
{0x78, 0x94100000},
{0x7c, 0x96100000},
{0xf0, 0x1},
{0x00, 0x98100000},
{0x04, 0x9a100000},
{0x08, 0x9c100000},
{0x0c, 0x9e100000},
{0x10, 0x84100000},
{0x14, 0x01000000},
{0x18, 0x01000000},
{0x1c, 0x82100000},
{0x20, 0x81900001},
{0x24, 0x82100000},
{0x28, 0x81980001},
{0x2c, 0x81800000},
{0x30, 0x01000000},
{0x34, 0x01000000},
{0x38, 0x01000000},
{0x3c, 0xbc102cf8},
{0x40, 0x9c102c78},
{0x44, 0x01000000},
{0x48, 0x01000000},
{0x4c, 0x27001040},
{0x50, 0xa614e00f},
{0x54, 0xe6a00040},
{0x58, 0x01000000},
{0x5c, 0x40000309},
{0x60, 0x01000000},
{0x64, 0x01000000},
{0x68, 0x10bfffff},
{0x6c, 0x01000000},
{0x70, 0x03169684},
{0x74, 0x82106050},
{0x78, 0x03296945},
{0x7c, 0x82106288},
{0xf0, 0x1a},
{0x00, 0x9de3bf98},
{0x04, 0x40000010},
{0x08, 0x01000000},
{0x0c, 0x40000007},
{0x10, 0x01000000},
{0x14, 0x400002ff},
{0x18, 0x01000000},
{0x1c, 0x40000015},
{0x20, 0x01000000},
{0x24, 0x30bffffe},
{0x28, 0x82102001},
{0x2c, 0x81904000},
{0x30, 0x01000000},
{0x34, 0x01000000},
{0x38, 0x01000000},
{0x3c, 0x81c3e008},
{0x40, 0x01000000},
{0x44, 0x03000008},
{0x48, 0x82106342},
{0x4c, 0xa3804000},
{0x50, 0x03000004},
{0x54, 0x82106000},
{0x58, 0x81984000},
{0x5c, 0x01000000},
{0x60, 0x01000000},
{0x64, 0x01000000},
{0x68, 0x81c3e008},
{0x6c, 0x01000000},
{0x70, 0x01000000},
{0x74, 0x01000000},
{0x78, 0x01000000},
{0x7c, 0xa7800000},
{0xf0, 0x1b},
{0x00, 0x01000000},
{0x04, 0x01000000},
{0x08, 0x01000000},
{0x0c, 0x81c3e008},
{0x10, 0x01000000},
{0x14, 0x80a22000},
{0x18, 0x02800006},
{0x1c, 0x01000000},
{0x20, 0x01000000},
{0x24, 0x90823fff},
{0x28, 0x12bffffe},
{0x2c, 0x01000000},
{0x30, 0x81c3e008},
{0x34, 0x01000000},
{0x38, 0x01000000},
{0x3c, 0x05001040},
{0x40, 0x8410a00f},
{0x44, 0xc4a00040},
{0x48, 0x01000000},
{0x4c, 0x81c3e008},
{0x50, 0x01000000},
{0x54, 0x9de3bf18},
{0x58, 0xb2067fff},
{0x5c, 0x96100018},
{0x60, 0xf227bf7c},
{0x64, 0xc027bf78},
{0x68, 0x98102000},
{0x6c, 0xb007bff8},
{0x70, 0xd4063f80},
{0x74, 0xda063f84},
{0x78, 0xb810000a},
{0x7c, 0x98033fff},
{0xf0, 0x1c},
{0x00, 0xb0063ff8},
{0x04, 0x80a2800d},
{0x08, 0x16800031},
{0x0c, 0xb610000d},
{0x10, 0xbb2aa002},
{0x14, 0x832b6002},
{0x18, 0xb207400b},
{0x1c, 0xb400400b},
{0x20, 0xde02c01d},
{0x24, 0x80a7001b},
{0x28, 0x1680001c},
{0x2c, 0x01000000},
{0x30, 0xc2068000},
{0x34, 0x80a0400f},
{0x38, 0x04800005},
{0x3c, 0x80a7001b},
{0x40, 0xb606ffff},
{0x44, 0x10bffff8},
{0x48, 0xb406bffc},
{0x4c, 0x16800013},
{0x50, 0x80a7001b},
{0x54, 0xc2068000},
{0x58, 0xc2264000},
{0x5c, 0xb8072001},
{0x60, 0x80a7001b},
{0x64, 0x1680000d},
{0x68, 0xb2066004},
{0x6c, 0xc2064000},
{0x70, 0x80a0400f},
{0x74, 0x26bffffb},
{0x78, 0xb8072001},
{0x7c, 0x80a7001b},
{0xf0, 0x1d},
{0x00, 0x16800006},
{0x04, 0x01000000},
{0x08, 0xc2268000},
{0x0c, 0xb606ffff},
{0x10, 0xb406bffc},
{0x14, 0x80a7001b},
{0x18, 0x12bfffe4},
{0x1c, 0x80a7001b},
{0x20, 0xb0062008},
{0x24, 0x82073fff},
{0x28, 0xc2263f84},
{0x2c, 0xd4263f80},
{0x30, 0x832f2002},
{0x34, 0xb0062008},
{0x38, 0xde22c001},
{0x3c, 0xba072001},
{0x40, 0xfa263f80},
{0x44, 0xda263f84},
{0x48, 0x98032002},
{0x4c, 0x80a33fff},
{0x50, 0x34bfffc9},
{0x54, 0xd4063f80},
{0x58, 0x81c7e008},
{0x5c, 0x81e80000},
{0x60, 0x00000000},
{0x64, 0x00000000},
{0x68, 0x00000000},
{0x6c, 0x00000000},
{0x70, 0x00000000},
{0x74, 0x00000000},
{0x78, 0x00000000},
{0x7c, 0x00000000},
{0xf0, 0x20},
{0x00, 0x83580000},
{0x04, 0x82086ff0},
{0x08, 0x83306004},
{0x0c, 0x80a06005},
{0x10, 0x02800024},
{0x14, 0x01000000},
{0x18, 0x80a06006},
{0x1c, 0x02800039},
{0x20, 0x01000000},
{0x24, 0x80a06015},
{0x28, 0x02800051},
{0x2c, 0x01000000},
{0x30, 0x80a0602a},
{0x34, 0x02800085},
{0x38, 0x01000000},
{0x3c, 0x073fc180},
{0x40, 0x8610e03c},
{0x44, 0x05169680},
{0x48, 0x84004002},
{0x4c, 0xc420c000},
{0x50, 0x073fc000},
{0x54, 0x8610e020},
{0x58, 0x84102001},
{0x5c, 0xc420c000},
{0x60, 0x0500000c},
{0x64, 0x01000000},
{0x68, 0x01000000},
{0x6c, 0x8480bfff},
{0x70, 0x12bffffe},
{0x74, 0x01000000},
{0x78, 0x01000000},
{0x7c, 0x073fc000},
{0xf0, 0x21},
{0x00, 0x8610e020},
{0x04, 0x84102000},
{0x08, 0xc420c000},
{0x0c, 0x01000000},
{0x10, 0x01000000},
{0x14, 0x81c44000},
{0x18, 0x81cc8000},
{0x1c, 0x01000000},
{0x20, 0xa7500000},
{0x24, 0xa92ce002},
{0x28, 0xa734e001},
{0x2c, 0xa614c014},
{0x30, 0xa60ce007},
{0x34, 0x81900000},
{0x38, 0x01000000},
{0x3c, 0x01000000},
{0x40, 0x81e00000},
{0x44, 0xe03ba000},
{0x48, 0xe43ba008},
{0x4c, 0xe83ba010},
{0x50, 0xec3ba018},
{0x54, 0xf03ba020},
{0x58, 0xf43ba028},
{0x5c, 0xf83ba030},
{0x60, 0xfc3ba038},
{0x64, 0x81e80000},
{0x68, 0x8194c000},
{0x6c, 0x01000000},
{0x70, 0x01000000},
{0x74, 0x81c44000},
{0x78, 0x81cc8000},
{0x7c, 0x01000000},
{0xf0, 0x22},
{0x00, 0xa7500000},
{0x04, 0xa934e002},
{0x08, 0xa72ce001},
{0x0c, 0xa614c014},
{0x10, 0xa60ce007},
{0x14, 0x81900000},
{0x18, 0x01000000},
{0x1c, 0x01000000},
{0x20, 0x81e80000},
{0x24, 0x81e80000},
{0x28, 0xe01ba000},
{0x2c, 0xe41ba008},
{0x30, 0xe81ba010},
{0x34, 0xec1ba018},
{0x38, 0xf01ba020},
{0x3c, 0xf41ba028},
{0x40, 0xf81ba030},
{0x44, 0xfc1ba038},
{0x48, 0x81e00000},
{0x4c, 0x81e00000},
{0x50, 0x8194c000},
{0x54, 0x01000000},
{0x58, 0x01000000},
{0x5c, 0x81c44000},
{0x60, 0x81cc8000},
{0x64, 0x01000000},
{0x68, 0x01000000},
{0x6c, 0x82102010},
{0x70, 0x273fc0c0},
{0x74, 0xa614e010},
{0x78, 0xc224c000},
{0x7c, 0x01000000},
{0xf0, 0x23},
{0x00, 0x033fc0c0},
{0x04, 0x82106004},
{0x08, 0xa6102000},
{0x0c, 0xe6204000},
{0x10, 0x01000000},
{0x14, 0x01000000},
{0x18, 0x01000000},
{0x1c, 0xa6102020},
{0x20, 0x83480000},
{0x24, 0x82104013},
{0x28, 0x81884000},
{0x2c, 0x01000000},
{0x30, 0x400004ad},
{0x34, 0x01000000},
{0x38, 0x01000000},
{0x3c, 0x01000000},
{0x40, 0xa7500000},
{0x44, 0xa934e002},
{0x48, 0xa72ce001},
{0x4c, 0xa614c014},
{0x50, 0xa60ce007},
{0x54, 0x81900000},
{0x58, 0x01000000},
{0x5c, 0x81e80000},
{0x60, 0xe01ba000},
{0x64, 0xe41ba008},
{0x68, 0xe81ba010},
{0x6c, 0xec1ba018},
{0x70, 0xf01ba020},
{0x74, 0xf41ba028},
{0x78, 0xf81ba030},
{0x7c, 0xfc1ba038},
{0xf0, 0x24},
{0x00, 0x81e00000},
{0x04, 0x8194c000},
{0x08, 0x01000000},
{0x0c, 0xa6102020},
{0x10, 0x83480000},
{0x14, 0x82284013},
{0x18, 0x81884000},
{0x1c, 0x01000000},
{0x20, 0x033fc0c0},
{0x24, 0x82106004},
{0x28, 0xa6103fff},
{0x2c, 0xe6204000},
{0x30, 0x01000000},
{0x34, 0x01000000},
{0x38, 0x01000000},
{0x3c, 0x81c44000},
{0x40, 0x81cc8000},
{0x44, 0x01000000},
{0x48, 0x81c48000},
{0x4c, 0x81cca004},
{0x50, 0x01000000},
{0x54, 0x033fc140},
{0x58, 0x82106048},
{0x5c, 0xda004000},
{0x60, 0x03000040},
{0x64, 0x808b4001},
{0x68, 0x03000017},
{0x6c, 0x12800004},
{0x70, 0x90106380},
{0x74, 0x82006400},
{0x78, 0x901060c0},
{0x7c, 0x81c3e008},
{0xf0, 0x25},
{0x00, 0x01000000},
{0x04, 0x94102000},
{0x08, 0x96102000},
{0x0c, 0x832ae002},
{0x10, 0xd20063a4},
{0x14, 0x98102000},
{0x18, 0x832b2002},
{0x1c, 0x9b2aa002},
{0x20, 0xda02000d},
{0x24, 0x98032001},
{0x28, 0xda224001},
{0x2c, 0x80a32005},
{0x30, 0x04bffffa},
{0x34, 0x9402a001},
{0x38, 0x9602e001},
{0x3c, 0x80a2e003},
{0x40, 0x04bffff4},
{0x44, 0x832ae002},
{0x48, 0x81c3e008},
{0x4c, 0x01000000},
{0x50, 0x033fc200},
{0x54, 0x961060a0},
{0x58, 0x98102000},
{0x5c, 0x832b2002},
{0x60, 0x9a03000c},
{0x64, 0xda136400},
{0x68, 0x98032001},
{0x6c, 0x80a3200f},
{0x70, 0x04bffffb},
{0x74, 0xda20400b},
{0x78, 0x81c3e008},
{0x7c, 0x01000000},
{0xf0, 0x26},
{0x00, 0x82020008},
{0x04, 0x82004008},
{0x08, 0x9b326002},
{0x0c, 0x82004001},
{0x10, 0x8200400d},
{0x14, 0x83286002},
{0x18, 0x920a6003},
{0x1c, 0x932a6003},
{0x20, 0xd00065b0},
{0x24, 0x91320009},
{0x28, 0x81c3e008},
{0x2c, 0x900a20ff},
{0x30, 0x9a020008},
{0x34, 0x9a034008},
{0x38, 0x97326002},
{0x3c, 0x9a03400d},
{0x40, 0x9a03400b},
{0x44, 0x920a6003},
{0x48, 0x9b2b6002},
{0x4c, 0x932a6003},
{0x50, 0x821020ff},
{0x54, 0xd80365b0},
{0x58, 0x83284009},
{0x5c, 0x822b0001},
{0x60, 0x952a8009},
{0x64, 0x8210400a},
{0x68, 0xc22365b0},
{0x6c, 0x912a2002},
{0x70, 0xda0223a4},
{0x74, 0x972ae002},
{0x78, 0x81c3e008},
{0x7c, 0xc223400b},
{0xf0, 0x27},
{0x00, 0x82102005},
{0x04, 0x1b3fc200},
{0x08, 0x82204008},
{0x0c, 0x9a136008},
{0x10, 0x83286002},
{0x14, 0xd0034000},
{0x18, 0x91320001},
{0x1c, 0x81c3e008},
{0x20, 0x900a200f},
{0x24, 0x9de3bf58},
{0x28, 0xa12e2002},
{0x2c, 0xda1423da},
{0x30, 0xd61423d8},
{0x34, 0xc200247c},
{0x38, 0xb022c00d},
{0x3c, 0x825b4001},
{0x40, 0xb21e6001},
{0x44, 0x92862001},
{0x48, 0x0280000c},
{0x4c, 0x9a004019},
{0x50, 0xb0100009},
{0x54, 0x9807bfb8},
{0x58, 0x8203400d},
{0x5c, 0xc2168001},
{0x60, 0xc2230000},
{0x64, 0xc200247c},
{0x68, 0x9a034001},
{0x6c, 0xb0863fff},
{0x70, 0x12bffffa},
{0x74, 0x98032004},
{0x78, 0x7ffffe77},
{0x7c, 0x9007bfb8},
{0xf0, 0x28},
{0x00, 0xda1423ea},
{0x04, 0xd61423e8},
{0x08, 0x80a3400b},
{0x0c, 0x92102000},
{0x10, 0x1880000b},
{0x14, 0xb010000d},
{0x18, 0x832b6002},
{0x1c, 0x8200401e},
{0x20, 0x98007fb8},
{0x24, 0xc2030000},
{0x28, 0xb0062001},
{0x2c, 0x92024001},
{0x30, 0x80a6000b},
{0x34, 0x08bffffc},
{0x38, 0x98032004},
{0x3c, 0xb022c00d},
{0x40, 0xb0062001},
{0x44, 0x81800000},
{0x48, 0x01000000},
{0x4c, 0x01000000},
{0x50, 0x01000000},
{0x54, 0xb0724018},
{0x58, 0x81c7e008},
{0x5c, 0x81e80000},
{0x60, 0x9de3bf98},
{0x64, 0xc200247c},
{0x68, 0x83306001},
{0x6c, 0x80a60001},
{0x70, 0x1a800006},
{0x74, 0x90100018},
{0x78, 0x7fffffc2},
{0x7c, 0x01000000},
{0xf0, 0x29},
{0x00, 0x10800006},
{0x04, 0xb0020008},
{0x08, 0x7fffffbe},
{0x0c, 0x90260001},
{0x10, 0x90020008},
{0x14, 0xb0022001},
{0x18, 0x81c7e008},
{0x1c, 0x81e80000},
{0x20, 0x9de3bf98},
{0x24, 0xa8102000},
{0x28, 0xc20023d4},
{0x2c, 0x80a50001},
{0x30, 0x1a800057},
{0x34, 0xe2002348},
{0x38, 0xa4102000},
{0x3c, 0xc200247c},
{0x40, 0x80a48001},
{0x44, 0x3a80004e},
{0x48, 0xa8052001},
{0x4c, 0x7fffffe5},
{0x50, 0x90100012},
{0x54, 0xaa100008},
{0x58, 0x90100014},
{0x5c, 0x7fffff89},
{0x60, 0x92100015},
{0x64, 0x80a62000},
{0x68, 0x12800004},
{0x6c, 0xa0100008},
{0x70, 0x10800016},
{0x74, 0xa0102000},
{0x78, 0x80a62009},
{0x7c, 0x18800011},
{0xf0, 0x2a},
{0x00, 0x80a62007},
{0x04, 0x7fffff54},
{0x08, 0x01000000},
{0x0c, 0x94100008},
{0x10, 0x90100014},
{0x14, 0x7fffffa4},
{0x18, 0x92100012},
{0x1c, 0x80a20011},
{0x20, 0x04800007},
{0x24, 0xa6100008},
{0x28, 0x9a102008},
{0x2c, 0x9a234018},
{0x30, 0x82102001},
{0x34, 0x8328400d},
{0x38, 0xa02c0001},
{0x3c, 0x80a62007},
{0x40, 0x18800008},
{0x44, 0x80a62008},
{0x48, 0x9a102007},
{0x4c, 0x9a234018},
{0x50, 0x82102001},
{0x54, 0x8328400d},
{0x58, 0x10800023},
{0x5c, 0xa0140001},
{0x60, 0x1280000a},
{0x64, 0x821e2009},
{0x68, 0x80a420fe},
{0x6c, 0x24800002},
{0x70, 0xa0042001},
{0x74, 0x03000019},
{0x78, 0x9b2ca002},
{0x7c, 0x82106080},
{0xf0, 0x2b},
{0x00, 0x10800019},
{0x04, 0xe6234001},
{0x08, 0x80a00001},
{0x0c, 0x9a603fff},
{0x10, 0x80a420fe},
{0x14, 0x04800003},
{0x18, 0x82102001},
{0x1c, 0x82102000},
{0x20, 0x808b4001},
{0x24, 0x02800011},
{0x28, 0x92100015},
{0x2c, 0x03000019},
{0x30, 0x9b2ca002},
{0x34, 0x82106080},
{0x38, 0xc2034001},
{0x3c, 0x80a04011},
{0x40, 0x18800003},
{0x44, 0x9a204011},
{0x48, 0x9a244001},
{0x4c, 0x80a4c011},
{0x50, 0x14800003},
{0x54, 0x8224c011},
{0x58, 0x82244013},
{0x5c, 0x80a34001},
{0x60, 0xa0642000},
{0x64, 0x92100015},
{0x68, 0x94100010},
{0x6c, 0x7fffff51},
{0x70, 0x90100014},
{0x74, 0x10bfffb2},
{0x78, 0xa404a001},
{0x7c, 0xc20023d4},
{0xf0, 0x2c},
{0x00, 0x80a50001},
{0x04, 0x0abfffae},
{0x08, 0xa4102000},
{0x0c, 0x81c7e008},
{0x10, 0x81e80000},
{0x14, 0x98102000},
{0x18, 0x9610201e},
{0x1c, 0x80a22000},
{0x20, 0x12800003},
{0x24, 0x8210000c},
{0x28, 0x8222c00c},
{0x2c, 0x83286002},
{0x30, 0xda006480},
{0x34, 0x80a37ff0},
{0x38, 0x02800006},
{0x3c, 0x98032002},
{0x40, 0xc2006484},
{0x44, 0x80a3201f},
{0x48, 0x04bffff5},
{0x4c, 0xc2234000},
{0x50, 0x81c3e008},
{0x54, 0x01000000},
{0x58, 0x9de3bf98},
{0x5c, 0xd8002660},
{0x60, 0xc200254c},
{0x64, 0x98130001},
{0x68, 0xda002508},
{0x6c, 0x033fc000},
{0x70, 0x9a0b4001},
{0x74, 0x153fc180},
{0x78, 0x03202020},
{0x7c, 0x82106080},
{0xf0, 0x2d},
{0x00, 0x9612a038},
{0x04, 0xc222c000},
{0x08, 0x03168000},
{0x0c, 0xd8202660},
{0x10, 0x80a34001},
{0x14, 0xc0228000},
{0x18, 0xa4102000},
{0x1c, 0x1280000b},
{0x20, 0xa8102000},
{0x24, 0x0300003f},
{0x28, 0xda002548},
{0x2c, 0x821063ff},
{0x30, 0x9a0b4001},
{0x34, 0xd8002508},
{0x38, 0x033fffc0},
{0x3c, 0x980b0001},
{0x40, 0x9a13400c},
{0x44, 0xda202548},
{0x48, 0x80a62000},
{0x4c, 0x16800027},
{0x50, 0x1b296956},
{0x54, 0x1b3fc040},
{0x58, 0xc2002548},
{0x5c, 0x8208400d},
{0x60, 0x1b168040},
{0x64, 0x80a0400d},
{0x68, 0x22800002},
{0x6c, 0xa4102001},
{0x70, 0xda002664},
{0x74, 0xc20021dc},
{0x78, 0x80a34001},
{0x7c, 0x1a80001b},
{0xf0, 0x2e},
{0x00, 0x1b296956},
{0x04, 0x031696a9},
{0x08, 0xda00250c},
{0x0c, 0x821061a5},
{0x10, 0x80a34001},
{0x14, 0x02800006},
{0x18, 0x03296956},
{0x1c, 0x8210625a},
{0x20, 0x80a34001},
{0x24, 0x12800011},
{0x28, 0x1b296956},
{0x2c, 0x11000018},
{0x30, 0x92122340},
{0x34, 0x40000179},
{0x38, 0x90122200},
{0x3c, 0x03000019},
{0x40, 0x96106240},
{0x44, 0xa8102001},
{0x48, 0x98102000},
{0x4c, 0x9b2b2002},
{0x50, 0x98032001},
{0x54, 0xc20365b0},
{0x58, 0x80a3201b},
{0x5c, 0x08bffffc},
{0x60, 0xc223400b},
{0x64, 0x1b296956},
{0x68, 0x80a00012},
{0x6c, 0x82380018},
{0x70, 0xa613625a},
{0x74, 0x90402000},
{0x78, 0x8330601f},
{0x7c, 0x1b1696a9},
{0xf0, 0x2f},
{0x00, 0xa21361a5},
{0x04, 0x9e104008},
{0x08, 0xd200254c},
{0x0c, 0xe0002548},
{0x10, 0x98102500},
{0x14, 0x80a32670},
{0x18, 0x0280001a},
{0x1c, 0x96033a50},
{0x20, 0xc200250c},
{0x24, 0x941b250c},
{0x28, 0x80a04013},
{0x2c, 0x02800007},
{0x30, 0x9a184011},
{0x34, 0x80a0000d},
{0x38, 0x82603fff},
{0x3c, 0x80904008},
{0x40, 0x0280000a},
{0x44, 0x80a3e000},
{0x48, 0x80a2e0f0},
{0x4c, 0x9a402000},
{0x50, 0x80a0000a},
{0x54, 0x82603fff},
{0x58, 0x80934001},
{0x5c, 0x3280000a},
{0x60, 0x98032004},
{0x64, 0x80a3e000},
{0x68, 0x02800005},
{0x6c, 0x82033960},
{0x70, 0x80a0603f},
{0x74, 0x28800004},
{0x78, 0x98032004},
{0x7c, 0xc0230000},
{0xf0, 0x30},
{0x00, 0x98032004},
{0x04, 0x80a32837},
{0x08, 0x08bfffe4},
{0x0c, 0x80a32670},
{0x10, 0x80a62000},
{0x14, 0x06800006},
{0x18, 0x0300003f},
{0x1c, 0x821063ff},
{0x20, 0x820a4001},
{0x24, 0x10800005},
{0x28, 0xc220254c},
{0x2c, 0xc21022d4},
{0x30, 0x83286010},
{0x34, 0xc22026a0},
{0x38, 0xc2002548},
{0x3c, 0xda0023c8},
{0x40, 0x90087dff},
{0x44, 0xd4002334},
{0x48, 0x9b336012},
{0x4c, 0x9402a001},
{0x50, 0xd800254c},
{0x54, 0x9a0b6200},
{0x58, 0x033fc200},
{0x5c, 0x9012000d},
{0x60, 0x92050014},
{0x64, 0x980b3ffd},
{0x68, 0x9732a001},
{0x6c, 0x82106030},
{0x70, 0xc2004000},
{0x74, 0x98130009},
{0x78, 0x9602800b},
{0x7c, 0x9b342018},
{0xf0, 0x31},
{0x00, 0xd820254c},
{0x04, 0xd620258c},
{0x08, 0xc220257c},
{0x0c, 0x80a3605a},
{0x10, 0xd4202554},
{0x14, 0xd4202588},
{0x18, 0x12800009},
{0x1c, 0xd0202548},
{0x20, 0x0300003f},
{0x24, 0x821063ff},
{0x28, 0x1b3fffc0},
{0x2c, 0x820a0001},
{0x30, 0x9a0c000d},
{0x34, 0x8210400d},
{0x38, 0xc2202548},
{0x3c, 0x80a4a001},
{0x40, 0x0280000c},
{0x44, 0x82102027},
{0x48, 0x03296956},
{0x4c, 0xda00250c},
{0x50, 0x8210625a},
{0x54, 0x80a34001},
{0x58, 0x1280000b},
{0x5c, 0x01000000},
{0x60, 0xc200254c},
{0x64, 0x80886002},
{0x68, 0x12800007},
{0x6c, 0x82102015},
{0x70, 0xc2202500},
{0x74, 0x7ffffe64},
{0x78, 0x901025b0},
{0x7c, 0x7ffffe75},
{0xf0, 0x32},
{0x00, 0x81e80000},
{0x04, 0x01000000},
{0x08, 0x81c7e008},
{0x0c, 0x81e80000},
{0x10, 0x9de3bf98},
{0x14, 0x033fc0c0},
{0x18, 0xb6106004},
{0x1c, 0x35200040},
{0x20, 0x2f3fc200},
{0x24, 0x8216a101},
{0x28, 0xc225c000},
{0x2c, 0xc026c000},
{0x30, 0x400002b0},
{0x34, 0x90102000},
{0x38, 0x2b3fc140},
{0x3c, 0xda00247c},
{0x40, 0x98156040},
{0x44, 0xe8030000},
{0x48, 0xc20022f8},
{0x4c, 0x9b336001},
{0x50, 0x825b4001},
{0x54, 0xa80d3800},
{0x58, 0xa8150001},
{0x5c, 0xe8230000},
{0x60, 0x82156004},
{0x64, 0xe8004000},
{0x68, 0xa80d3fe0},
{0x6c, 0xa815000d},
{0x70, 0xe8204000},
{0x74, 0xa615e080},
{0x78, 0xe804c000},
{0x7c, 0xb815e054},
{0xf0, 0x33},
{0x00, 0xc2070000},
{0x04, 0xa80d3fe0},
{0x08, 0xa815000d},
{0x0c, 0xba0861ff},
{0x10, 0xec002344},
{0x14, 0xc2002298},
{0x18, 0x9a15e070},
{0x1c, 0xc2234000},
{0x20, 0x033fc000},
{0x24, 0xda002338},
{0x28, 0x82106030},
{0x2c, 0xda204000},
{0x30, 0xc2002330},
{0x34, 0x9015e074},
{0x38, 0xc2220000},
{0x3c, 0x0300003f},
{0x40, 0x17000017},
{0x44, 0x9e156058},
{0x48, 0x821063ff},
{0x4c, 0xc223c000},
{0x50, 0x9612e380},
{0x54, 0x19000018},
{0x58, 0x94156088},
{0x5c, 0xd6228000},
{0x60, 0x981320c0},
{0x64, 0x9215608c},
{0x68, 0xd8224000},
{0x6c, 0xe824c000},
{0x70, 0xa015605c},
{0x74, 0xc0240000},
{0x78, 0xa2156080},
{0x7c, 0xd6244000},
{0xf0, 0x34},
{0x00, 0xa4156084},
{0x04, 0xd8248000},
{0x08, 0xec202670},
{0x0c, 0x80a76114},
{0x10, 0x1280000c},
{0x14, 0xe6002374},
{0x18, 0x820da0ff},
{0x1c, 0x8258605a},
{0x20, 0x82006040},
{0x24, 0x83306007},
{0x28, 0x9b286010},
{0x2c, 0x9a034001},
{0x30, 0x825ce349},
{0x34, 0xfa270000},
{0x38, 0xda202670},
{0x3c, 0xa730600a},
{0x40, 0xda0023f8},
{0x44, 0x8215e008},
{0x48, 0xda204000},
{0x4c, 0x9815e00c},
{0x50, 0x7ffffe20},
{0x54, 0xda230000},
{0x58, 0x9a15e07c},
{0x5c, 0xe8034000},
{0x60, 0x033ff000},
{0x64, 0xa82d0001},
{0x68, 0xe8234000},
{0x6c, 0x033fc1c0},
{0x70, 0xda002340},
{0x74, 0x82106064},
{0x78, 0xda204000},
{0x7c, 0x0300007f},
{0xf0, 0x35},
{0x00, 0x96156010},
{0x04, 0x821063ff},
{0x08, 0x1907ffc0},
{0x0c, 0xc222c000},
{0x10, 0x92156030},
{0x14, 0x94156014},
{0x18, 0xd8224000},
{0x1c, 0x80a4e000},
{0x20, 0x0280000f},
{0x24, 0xd8228000},
{0x28, 0x932ce010},
{0x2c, 0x8204e001},
{0x30, 0x9b2ce004},
{0x34, 0x83286010},
{0x38, 0x9a02400d},
{0x3c, 0x9815e084},
{0x40, 0xda230000},
{0x44, 0x82004013},
{0x48, 0x9615e088},
{0x4c, 0x82006002},
{0x50, 0x9415e08c},
{0x54, 0xd222c000},
{0x58, 0xc2228000},
{0x5c, 0x8215e030},
{0x60, 0xda002670},
{0x64, 0xda204000},
{0x68, 0x7ffffedc},
{0x6c, 0x90103fff},
{0x70, 0x7ffffec9},
{0x74, 0x90102001},
{0x78, 0x82103fff},
{0x7c, 0xc226c000},
{0xf0, 0x36},
{0x00, 0xf425c000},
{0x04, 0x81c7e008},
{0x08, 0x81e80000},
{0x0c, 0x9de3bf98},
{0x10, 0xc2002508},
{0x14, 0x808860ff},
{0x18, 0x02800015},
{0x1c, 0x1b3fc180},
{0x20, 0x82102001},
{0x24, 0x9a13603c},
{0x28, 0xc2234000},
{0x2c, 0xc2002508},
{0x30, 0x820860ff},
{0x34, 0x80a04018},
{0x38, 0x1280000b},
{0x3c, 0x033fc180},
{0x40, 0x7ffffc9e},
{0x44, 0x01000000},
{0x48, 0xda002508},
{0x4c, 0x033fc040},
{0x50, 0x9a0b60ff},
{0x54, 0x8210600c},
{0x58, 0xc0204000},
{0x5c, 0x10bffff7},
{0x60, 0x80a34018},
{0x64, 0x8210603c},
{0x68, 0xc0204000},
{0x6c, 0x81c7e008},
{0x70, 0x81e80000},
{0x74, 0x9de3bf98},
{0x78, 0x9e100018},
{0x7c, 0x031fffdf},
{0xf0, 0x37},
{0x00, 0xb010001a},
{0x04, 0xb41063ff},
{0x08, 0x82102000},
{0x0c, 0xbb286002},
{0x10, 0x80a62009},
{0x14, 0xb6006001},
{0x18, 0x12800006},
{0x1c, 0xb810001d},
{0x20, 0xc206401d},
{0x24, 0x83306001},
{0x28, 0x8208401a},
{0x2c, 0xc226401d},
{0x30, 0x80a62008},
{0x34, 0x08800006},
{0x38, 0xc206401c},
{0x3c, 0xfa03c01c},
{0x40, 0xbb376001},
{0x44, 0x10800003},
{0x48, 0xba0f401a},
{0x4c, 0xfa03c01c},
{0x50, 0x8200401d},
{0x54, 0xc226401c},
{0x58, 0x80a6e04f},
{0x5c, 0x08bfffec},
{0x60, 0x8210001b},
{0x64, 0x81c7e008},
{0x68, 0x81e80000},
{0x6c, 0x9a102000},
{0x70, 0x832b6002},
{0x74, 0x9a036001},
{0x78, 0x80a3604f},
{0x7c, 0x08bffffd},
{0xf0, 0x38},
{0x00, 0xc0220001},
{0x04, 0x81c3e008},
{0x08, 0x01000000},
{0x0c, 0xc20022f8},
{0x10, 0xda00247c},
{0x14, 0x8258400d},
{0x18, 0x83306001},
{0x1c, 0x96102000},
{0x20, 0x80a2c001},
{0x24, 0x1a80003b},
{0x28, 0x0300003f},
{0x2c, 0x941063ff},
{0x30, 0x98102000},
{0x34, 0x80a26001},
{0x38, 0x0280002e},
{0x3c, 0x80a26004},
{0x40, 0x12800008},
{0x44, 0x80a26008},
{0x48, 0xc2030008},
{0x4c, 0x9a08400a},
{0x50, 0x83306012},
{0x54, 0x83286010},
{0x58, 0x10800014},
{0x5c, 0x9b336002},
{0x60, 0x28800015},
{0x64, 0xda02000c},
{0x68, 0xda030008},
{0x6c, 0x83336010},
{0x70, 0x82004001},
{0x74, 0x9a0b400a},
{0x78, 0x81800000},
{0x7c, 0x01000000},
{0xf0, 0x39},
{0x00, 0x01000000},
{0x04, 0x01000000},
{0x08, 0x82704009},
{0x0c, 0x9a03400d},
{0x10, 0x83286010},
{0x14, 0x81800000},
{0x18, 0x01000000},
{0x1c, 0x01000000},
{0x20, 0x01000000},
{0x24, 0x9a734009},
{0x28, 0x8200400d},
{0x2c, 0x10800011},
{0x30, 0xc2230008},
{0x34, 0x83336010},
{0x38, 0x81800000},
{0x3c, 0x01000000},
{0x40, 0x01000000},
{0x44, 0x01000000},
{0x48, 0x82704009},
{0x4c, 0x9a0b400a},
{0x50, 0x83286010},
{0x54, 0x81800000},
{0x58, 0x01000000},
{0x5c, 0x01000000},
{0x60, 0x01000000},
{0x64, 0x9a734009},
{0x68, 0x8200400d},
{0x6c, 0xc222000c},
{0x70, 0xc20022f8},
{0x74, 0xda00247c},
{0x78, 0x8258400d},
{0x7c, 0x9602e001},
{0xf0, 0x3a},
{0x00, 0x83306001},
{0x04, 0x80a2c001},
{0x08, 0x0abfffcb},
{0x0c, 0x98032004},
{0x10, 0x81c3e008},
{0x14, 0x01000000},
{0x18, 0x98102000},
{0x1c, 0x9b2b2002},
{0x20, 0x98032001},
{0x24, 0xc202000d},
{0x28, 0x80a3204f},
{0x2c, 0x04bffffc},
{0x30, 0xc222400d},
{0x34, 0x81c3e008},
{0x38, 0x01000000},
{0x3c, 0xd6020000},
{0x40, 0xd8024000},
{0x44, 0x9132e010},
{0x48, 0x95332010},
{0x4c, 0x900a2fff},
{0x50, 0x940aafff},
{0x54, 0x03000007},
{0x58, 0x9a22000a},
{0x5c, 0x821063ff},
{0x60, 0x940b0001},
{0x64, 0x900ac001},
{0x68, 0x9022000a},
{0x6c, 0x9a5b400d},
{0x70, 0x905a0008},
{0x74, 0x81c3e008},
{0x78, 0x90034008},
{0x7c, 0x9de3bf98},
{0xf0, 0x3b},
{0x00, 0x82064019},
{0x04, 0x82004019},
{0x08, 0x83286002},
{0x0c, 0x82004018},
{0x10, 0x3b000019},
{0x14, 0x83286002},
{0x18, 0xba176080},
{0x1c, 0x9a066001},
{0x20, 0xde00401d},
{0x24, 0xb2067fff},
{0x28, 0xc2002478},
{0x2c, 0x9823c001},
{0x30, 0x80a6400d},
{0x34, 0xb4062001},
{0x38, 0x1480002a},
{0x3c, 0x96102000},
{0x40, 0x82064019},
{0x44, 0x82004019},
{0x48, 0x9410001d},
{0x4c, 0xb9286002},
{0x50, 0xb006bffe},
{0x54, 0x833e601f},
{0x58, 0xba070018},
{0x5c, 0x82204019},
{0x60, 0xbb2f6002},
{0x64, 0xb730601f},
{0x68, 0xba07400a},
{0x6c, 0x80a62000},
{0x70, 0x24800015},
{0x74, 0xb0062001},
{0x78, 0xc2002308},
{0x7c, 0x80a04018},
{0xf0, 0x3c},
{0x00, 0x82603fff},
{0x04, 0x8088401b},
{0x08, 0x2280000f},
{0x0c, 0xb0062001},
{0x10, 0xc2002300},
{0x14, 0x80a64001},
{0x18, 0x3880000b},
{0x1c, 0xb0062001},
{0x20, 0xc2074000},
{0x24, 0x80a0400f},
{0x28, 0x04800004},
{0x2c, 0x80a0400c},
{0x30, 0x1080000d},
{0x34, 0xb0102000},
{0x38, 0x24800002},
{0x3c, 0x96102001},
{0x40, 0xb0062001},
{0x44, 0x80a6001a},
{0x48, 0x04bfffe9},
{0x4c, 0xba076004},
{0x50, 0xb2066001},
{0x54, 0x80a6400d},
{0x58, 0x04bfffde},
{0x5c, 0xb807200c},
{0x60, 0xb010000b},
{0x64, 0x81c7e008},
{0x68, 0x81e80000},
{0x6c, 0xc2002548},
{0x70, 0x82087fbf},
{0x74, 0xc2202548},
{0x78, 0xc0202540},
{0x7c, 0xc0202514},
{0xf0, 0x3d},
{0x00, 0x9a102000},
{0x04, 0x832b6002},
{0x08, 0x9a036001},
{0x0c, 0xc0206708},
{0x10, 0x80a36009},
{0x14, 0x04bffffc},
{0x18, 0xc02066e0},
{0x1c, 0x81c3e008},
{0x20, 0x01000000},
{0x24, 0x9de3bf88},
{0x28, 0x82063fff},
{0x2c, 0xb8067fff},
{0x30, 0x82160001},
{0x34, 0xba16401c},
{0x38, 0x80974001},
{0x3c, 0xa610001a},
{0x40, 0x0680006c},
{0x44, 0xa410001b},
{0x48, 0xc2002308},
{0x4c, 0x80a60001},
{0x50, 0x38800069},
{0x54, 0xb0102000},
{0x58, 0xc2002300},
{0x5c, 0x80a64001},
{0x60, 0x38800065},
{0x64, 0xb0102000},
{0x68, 0x94062001},
{0x6c, 0x96066001},
{0x70, 0xa207bff8},
{0x74, 0x8207bfe8},
{0x78, 0xb0102003},
{0x7c, 0xc0204000},
{0xf0, 0x3e},
{0x00, 0xb0863fff},
{0x04, 0x1cbffffe},
{0x08, 0x82006004},
{0x0c, 0x80a7000b},
{0x10, 0x14800031},
{0x14, 0xb210001c},
{0x18, 0x8207001c},
{0x1c, 0xba02c00b},
{0x20, 0x8200401c},
{0x24, 0xba07400b},
{0x28, 0xba20401d},
{0x2c, 0x39000019},
{0x30, 0xa0172080},
{0x34, 0x9827400a},
{0x38, 0x9b286002},
{0x3c, 0xb002bffe},
{0x40, 0x82034018},
{0x44, 0x83286002},
{0x48, 0xba06000c},
{0x4c, 0xb4004010},
{0x50, 0xb6076008},
{0x54, 0x90102001},
{0x58, 0x932a001b},
{0x5c, 0x9e102000},
{0x60, 0xb92be002},
{0x64, 0xfa072520},
{0x68, 0xba5f4012},
{0x6c, 0x833f601f},
{0x70, 0x83306018},
{0x74, 0xba074001},
{0x78, 0xc2068000},
{0x7c, 0x82204013},
{0xf0, 0x3f},
{0x00, 0xbb3f6008},
{0x04, 0x9e03e001},
{0x08, 0x80a0401d},
{0x0c, 0x04800005},
{0x10, 0xb8070011},
{0x14, 0xc2073ff0},
{0x18, 0x82104009},
{0x1c, 0xc2273ff0},
{0x20, 0x80a3e003},
{0x24, 0x08bffff0},
{0x28, 0xb92be002},
{0x2c, 0xb0062001},
{0x30, 0xb606e001},
{0x34, 0x80a6000a},
{0x38, 0x04bfffe8},
{0x3c, 0xb406a004},
{0x40, 0xb2066001},
{0x44, 0x9a03600c},
{0x48, 0x80a6400b},
{0x4c, 0x04bfffdc},
{0x50, 0x98032003},
{0x54, 0xc207bfe8},
{0x58, 0x80886010},
{0x5c, 0x0280000a},
{0x60, 0xfa07bfec},
{0x64, 0xc207bff4},
{0x68, 0x80886082},
{0x6c, 0x02800007},
{0x70, 0x808f6010},
{0x74, 0x80886028},
{0x78, 0x1280001f},
{0x7c, 0xb0102003},
{0xf0, 0x40},
{0x00, 0xfa07bfec},
{0x04, 0x808f6010},
{0x08, 0x02800012},
{0x0c, 0xc207bff0},
{0x10, 0x808f6082},
{0x14, 0x02800007},
{0x18, 0x808f6028},
{0x1c, 0xc207bff4},
{0x20, 0x80886028},
{0x24, 0x32800014},
{0x28, 0xb0102002},
{0x2c, 0x808f6028},
{0x30, 0x02800008},
{0x34, 0xc207bff0},
{0x38, 0xc207bff4},
{0x3c, 0x80886082},
{0x40, 0x02800004},
{0x44, 0xc207bff0},
{0x48, 0x1080000b},
{0x4c, 0xb0102002},
{0x50, 0x80886010},
{0x54, 0x02800008},
{0x58, 0xb0102000},
{0x5c, 0x80886082},
{0x60, 0x02800005},
{0x64, 0x80886028},
{0x68, 0x12800003},
{0x6c, 0xb0102001},
{0x70, 0xb0102000},
{0x74, 0x81c7e008},
{0x78, 0x81e80000},
{0x7c, 0x9de3bf98},
{0xf0, 0x41},
{0x00, 0xb12e2002},
{0x04, 0xf80626e0},
{0x08, 0x9e0f2fff},
{0x0c, 0xba03c00f},
{0x10, 0xba07400f},
{0x14, 0xb1372010},
{0x18, 0xb00e2fff},
{0x1c, 0xbb2f6002},
{0x20, 0xba074018},
{0x24, 0x03000019},
{0x28, 0x82106080},
{0x2c, 0xbb2f6002},
{0x30, 0xfa074001},
{0x34, 0xc20821e4},
{0x38, 0xba5f4001},
{0x3c, 0x833f601f},
{0x40, 0x83306019},
{0x44, 0xba074001},
{0x48, 0xbb3f6007},
{0x4c, 0xb937200c},
{0x50, 0xc20821e5},
{0x54, 0xa0100019},
{0x58, 0x9410001a},
{0x5c, 0xa8074001},
{0x60, 0x808f2001},
{0x64, 0xb006001a},
{0x68, 0x0280000c},
{0x6c, 0x9e03c019},
{0x70, 0xc20023c8},
{0x74, 0x80886200},
{0x78, 0x32800002},
{0x7c, 0xb006001a},
{0xf0, 0x42},
{0x00, 0xc200237c},
{0x04, 0x80a06000},
{0x08, 0x2280005e},
{0x0c, 0x9e03e001},
{0x10, 0x1080005c},
{0x14, 0xb0062001},
{0x18, 0xc20023c8},
{0x1c, 0x83306014},
{0x20, 0x82086001},
{0x24, 0x80a00001},
{0x28, 0xa2603fff},
{0x2c, 0x9e03c010},
{0x30, 0x8333e01f},
{0x34, 0x80944001},
{0x38, 0x12800052},
{0x3c, 0xb006000a},
{0x40, 0x80a62000},
{0x44, 0x06800050},
{0x48, 0x80a2a000},
{0x4c, 0xc2002300},
{0x50, 0x82006001},
{0x54, 0x80a3c001},
{0x58, 0x1880004b},
{0x5c, 0x80a2a000},
{0x60, 0xc2002308},
{0x64, 0x82006001},
{0x68, 0x80a60001},
{0x6c, 0x18800045},
{0x70, 0xa4102000},
{0x74, 0x27000019},
{0x78, 0x96103fff},
{0x7c, 0xaa14e080},
{0xf0, 0x43},
{0x00, 0x9214e080},
{0x04, 0x80a2a000},
{0x08, 0x9a03c00b},
{0x0c, 0x12800004},
{0x10, 0x98100018},
{0x14, 0x9806000b},
{0x18, 0x9a10000f},
{0x1c, 0xba234010},
{0x20, 0x8207401d},
{0x24, 0x8200401d},
{0x28, 0xba23000a},
{0x2c, 0x83286002},
{0x30, 0x8200401d},
{0x34, 0x83286002},
{0x38, 0xfa004009},
{0x3c, 0xc20821e6},
{0x40, 0xba5f4001},
{0x44, 0xb803400b},
{0x48, 0x833f601f},
{0x4c, 0x9003400d},
{0x50, 0xb202000d},
{0x54, 0x83306019},
{0x58, 0xb407001c},
{0x5c, 0xb72e6002},
{0x60, 0xba074001},
{0x64, 0xb406801c},
{0x68, 0xbb3f6007},
{0x6c, 0xb606c00c},
{0x70, 0xf80821e7},
{0x74, 0xb807401c},
{0x78, 0xb72ee002},
{0x7c, 0xfa06c009},
{0xf0, 0x44},
{0x00, 0xb32e6004},
{0x04, 0x8203000b},
{0x08, 0x83286002},
{0x0c, 0xb2064009},
{0x10, 0x80a7401c},
{0x14, 0xba064001},
{0x18, 0xb52ea004},
{0x1c, 0x14800019},
{0x20, 0x832b2002},
{0x24, 0x80a2a000},
{0x28, 0x22800005},
{0x2c, 0x8202000d},
{0x30, 0xb2068009},
{0x34, 0xba064001},
{0x38, 0x8202000d},
{0x3c, 0x83286002},
{0x40, 0x8200400c},
{0x44, 0xb3286002},
{0x48, 0xc2074000},
{0x4c, 0x80a0401c},
{0x50, 0x1480000c},
{0x54, 0x9602e001},
{0x58, 0xc2064015},
{0x5c, 0x80a04014},
{0x60, 0x36800002},
{0x64, 0xa4102001},
{0x68, 0x80a2e001},
{0x6c, 0x04bfffc6},
{0x70, 0x9214e080},
{0x74, 0x80a4a000},
{0x78, 0x32bfffae},
{0x7c, 0x9e03c010},
{0xf0, 0x45},
{0x00, 0x80a2a000},
{0x04, 0x12800003},
{0x08, 0xb026000a},
{0x0c, 0xb023c010},
{0x10, 0x81c7e008},
{0x14, 0x81e80000},
{0x18, 0x94102000},
{0x1c, 0xc2002514},
{0x20, 0x80a28001},
{0x24, 0x96102000},
{0x28, 0x1a80000e},
{0x2c, 0x9b2ae002},
{0x30, 0xc20366e0},
{0x34, 0x9602e001},
{0x38, 0x80a06000},
{0x3c, 0x02800006},
{0x40, 0x992aa002},
{0x44, 0xc22326e0},
{0x48, 0xc2036708},
{0x4c, 0x9402a001},
{0x50, 0xc2232708},
{0x54, 0xc2002514},
{0x58, 0x10bffff4},
{0x5c, 0x80a2c001},
{0x60, 0x81c3e008},
{0x64, 0xd4202514},
{0x68, 0xd4020000},
{0x6c, 0x03000018},
{0x70, 0x9802800a},
{0x74, 0x82106200},
{0x78, 0xda130001},
{0x7c, 0xc2002590},
{0xf0, 0x46},
{0x00, 0xc250400c},
{0x04, 0x96a0400d},
{0x08, 0x02800016},
{0x0c, 0x03000018},
{0x10, 0x80a2e000},
{0x14, 0x04800009},
{0x18, 0x82102001},
{0x1c, 0xda022004},
{0x20, 0x8328400d},
{0x24, 0x80a2c001},
{0x28, 0x3480000d},
{0x2c, 0x973ac00d},
{0x30, 0x1080000b},
{0x34, 0x96102001},
{0x38, 0x1680000a},
{0x3c, 0x03000018},
{0x40, 0xda022008},
{0x44, 0x82103fff},
{0x48, 0x8328400d},
{0x4c, 0x80a2c001},
{0x50, 0x36800003},
{0x54, 0x96103fff},
{0x58, 0x973ac00d},
{0x5c, 0x03000018},
{0x60, 0x92106200},
{0x64, 0x8202800a},
{0x68, 0xc2104009},
{0x6c, 0x9602c001},
{0x70, 0x808aa001},
{0x74, 0x0280000f},
{0x78, 0x9b3aa01f},
{0x7c, 0x9b33601f},
{0xf0, 0x47},
{0x00, 0x9a02800d},
{0x04, 0x9b3b6001},
{0x08, 0x9b2b6002},
{0x0c, 0xd8034009},
{0x10, 0x033fffc0},
{0x14, 0x980b0001},
{0x18, 0x0300003f},
{0x1c, 0x821063ff},
{0x20, 0x820ac001},
{0x24, 0x98030001},
{0x28, 0x1080000d},
{0x2c, 0xd8234009},
{0x30, 0x9b33601f},
{0x34, 0x9a02800d},
{0x38, 0x9b3b6001},
{0x3c, 0x9b2b6002},
{0x40, 0x0300003f},
{0x44, 0xd8034009},
{0x48, 0x821063ff},
{0x4c, 0x980b0001},
{0x50, 0x832ae010},
{0x54, 0x8200400c},
{0x58, 0xc2234009},
{0x5c, 0xc2020000},
{0x60, 0xda00247c},
{0x64, 0x8200400d},
{0x68, 0x81c3e008},
{0x6c, 0xc2220000},
{0x70, 0x9de3bf98},
{0x74, 0x833e201f},
{0x78, 0xd0002320},
{0x7c, 0x82204018},
{0xf0, 0x48},
{0x00, 0x80a22000},
{0x04, 0x02800016},
{0x08, 0x9b30601f},
{0x0c, 0x033fc000},
{0x10, 0xa0106020},
{0x14, 0xc200231c},
{0x18, 0x80a00001},
{0x1c, 0x82402000},
{0x20, 0x8088400d},
{0x24, 0xda002318},
{0x28, 0x821e000d},
{0x2c, 0x02800009},
{0x30, 0xb0086001},
{0x34, 0x80a0000d},
{0x38, 0x82603fff},
{0x3c, 0x7ffffa56},
{0x40, 0xc2240000},
{0x44, 0xc2002318},
{0x48, 0x10800005},
{0x4c, 0xc2240000},
{0x50, 0x033fc000},
{0x54, 0x82106020},
{0x58, 0xf0204000},
{0x5c, 0x81c7e008},
{0x60, 0x81e80000},
{0x64, 0x9de3bf98},
{0x68, 0x7ffffa54},
{0x6c, 0x01000000},
{0x70, 0x033fc040},
{0x74, 0xe0002500},
{0x78, 0x8210600c},
{0x7c, 0x80a42026},
{0xf0, 0x49},
{0x00, 0x0880001e},
{0x04, 0xc0204000},
{0x08, 0x19169683},
{0x0c, 0x9a132300},
{0x10, 0xc2002f00},
{0x14, 0x80a0400d},
{0x18, 0x3280005b},
{0x1c, 0xc2002500},
{0x20, 0x9a1323fc},
{0x24, 0xc2002ffc},
{0x28, 0x80a0400d},
{0x2c, 0x32800056},
{0x30, 0xc2002500},
{0x34, 0xc0202584},
{0x38, 0xa2102000},
{0x3c, 0x832c6002},
{0x40, 0xc2006f04},
{0x44, 0x80a06000},
{0x48, 0x0280004e},
{0x4c, 0xa2046001},
{0x50, 0x9fc04000},
{0x54, 0x01000000},
{0x58, 0xc2002584},
{0x5c, 0x80a06000},
{0x60, 0x12800048},
{0x64, 0x80a4603b},
{0x68, 0x24bffff6},
{0x6c, 0x832c6002},
{0x70, 0x10800045},
{0x74, 0xc2002500},
{0x78, 0x80a42000},
{0x7c, 0x1280000c},
{0xf0, 0x4a},
{0x00, 0x80a42014},
{0x04, 0x7ffffc55},
{0x08, 0x90102000},
{0x0c, 0x1b3fc200},
{0x10, 0xc2002330},
{0x14, 0x9a136074},
{0x18, 0xc2234000},
{0x1c, 0x7ffffc3e},
{0x20, 0x90102001},
{0x24, 0x10800035},
{0x28, 0xc2002fcc},
{0x2c, 0x1880000c},
{0x30, 0x80a42015},
{0x34, 0x808c2001},
{0x38, 0x32800033},
{0x3c, 0xc2002500},
{0x40, 0x90043ffe},
{0x44, 0x7ffffbd7},
{0x48, 0x91322001},
{0x4c, 0x7ffffb61},
{0x50, 0x01000000},
{0x54, 0x1080002c},
{0x58, 0xc2002500},
{0x5c, 0x18800013},
{0x60, 0x80a42016},
{0x64, 0x11000018},
{0x68, 0x7ffffda1},
{0x6c, 0x90122200},
{0x70, 0x033fc180},
{0x74, 0xda0025b0},
{0x78, 0x82106038},
{0x7c, 0xda204000},
{0xf0, 0x4b},
{0x00, 0x033fc200},
{0x04, 0x82106074},
{0x08, 0xda00232c},
{0x0c, 0xda204000},
{0x10, 0x7ffffc21},
{0x14, 0x90102000},
{0x18, 0xc200266c},
{0x1c, 0xc2202510},
{0x20, 0x10800016},
{0x24, 0xc2002fcc},
{0x28, 0x28800017},
{0x2c, 0xc2002500},
{0x30, 0x80a42026},
{0x34, 0x38800014},
{0x38, 0xc2002500},
{0x3c, 0x7ffffb26},
{0x40, 0x23000018},
{0x44, 0x92146200},
{0x48, 0x7ffffd6b},
{0x4c, 0x94043fea},
{0x50, 0x80a42026},
{0x54, 0x3280000c},
{0x58, 0xc2002500},
{0x5c, 0x90146200},
{0x60, 0x7ffffd8b},
{0x64, 0x92102008},
{0x68, 0xc2002fd8},
{0x6c, 0x80a06000},
{0x70, 0x22800005},
{0x74, 0xc2002500},
{0x78, 0x9fc04000},
{0x7c, 0x01000000},
{0xf0, 0x4c},
{0x00, 0xc2002500},
{0x04, 0x80a40001},
{0x08, 0x1280000b},
{0x0c, 0x031fffff},
{0x10, 0x821063f0},
{0x14, 0x80a40001},
{0x18, 0x38800003},
{0x1c, 0x21040000},
{0x20, 0xa0042001},
{0x24, 0x033fc180},
{0x28, 0x82106034},
{0x2c, 0xe0204000},
{0x30, 0xe0202500},
{0x34, 0x81c7e008},
{0x38, 0x81e80000},
{0x3c, 0x81c3e008},
{0x40, 0x01000000},
{0x44, 0x03169696},
{0x48, 0xda002180},
{0x4c, 0x8210625a},
{0x50, 0x80a34001},
{0x54, 0x94102000},
{0x58, 0x12800006},
{0x5c, 0x96102000},
{0x60, 0x033fc180},
{0x64, 0x82106030},
{0x68, 0x10800020},
{0x6c, 0xda204000},
{0x70, 0xc202c000},
{0x74, 0x9602e004},
{0x78, 0x80a2e4ff},
{0x7c, 0x08bffffd},
{0xf0, 0x4d},
{0x00, 0x94028001},
{0x04, 0x96102d00},
{0x08, 0xd2002ff8},
{0x0c, 0x03000019},
{0x10, 0x80a2c009},
{0x14, 0x1a80000b},
{0x18, 0x901063ff},
{0x1c, 0xd802c000},
{0x20, 0x9602e004},
{0x24, 0x80a2c009},
{0x28, 0x9a402000},
{0x2c, 0x80a2000b},
{0x30, 0x82603fff},
{0x34, 0x808b4001},
{0x38, 0x12bffff9},
{0x3c, 0x9402800c},
{0x40, 0x03169696},
{0x44, 0x8210625a},
{0x48, 0x80a28001},
{0x4c, 0x033fc180},
{0x50, 0x82106030},
{0x54, 0x02800005},
{0x58, 0xd4204000},
{0x5c, 0x03000008},
{0x60, 0x81c063f0},
{0x64, 0x90102001},
{0x68, 0x01000000},
{0x6c, 0x81c3e008},
{0x70, 0x01000000},
{0x74, 0x9de3bf98},
{0x78, 0x9e100018},
{0x7c, 0x03000019},
{0xf0, 0x4e},
{0x00, 0xb0100019},
{0x04, 0xba106080},
{0x08, 0xb6102000},
{0x0c, 0x832ee002},
{0x10, 0xb606e001},
{0x14, 0x80a6e0d7},
{0x18, 0x08bffffd},
{0x1c, 0xc020401d},
{0x20, 0xb6102000},
{0x24, 0xc20022fc},
{0x28, 0x80a6c001},
{0x2c, 0x1a80001c},
{0x30, 0x03000019},
{0x34, 0xb21060b4},
{0x38, 0xb4102000},
{0x3c, 0xc20022f8},
{0x40, 0x80a68001},
{0x44, 0x1a800011},
{0x48, 0x832ee002},
{0x4c, 0xb8004019},
{0x50, 0xc200247c},
{0x54, 0xfa0ee380},
{0x58, 0x825e8001},
{0x5c, 0x8200401d},
{0x60, 0x82004001},
{0x64, 0xfa160001},
{0x68, 0xc213c001},
{0x6c, 0x8220401d},
{0x70, 0xc2270000},
{0x74, 0xb406a001},
{0x78, 0xc20022f8},
{0x7c, 0x80a68001},
{0xf0, 0x4f},
{0x00, 0x0abffff4},
{0x04, 0xb8072030},
{0x08, 0xb606e001},
{0x0c, 0xc20022fc},
{0x10, 0x80a6c001},
{0x14, 0x0abfffea},
{0x18, 0xb4102000},
{0x1c, 0x81c7e008},
{0x20, 0x81e80000},
{0x24, 0x9de3bf98},
{0x28, 0x21000018},
{0x2c, 0xc2002fe4},
{0x30, 0x9fc04000},
{0x34, 0x90142200},
{0x38, 0xc200254c},
{0x3c, 0xda00259c},
{0x40, 0x90142340},
{0x44, 0x98087ffd},
{0x48, 0x80886002},
{0x4c, 0x0280002c},
{0x50, 0xda202550},
{0x54, 0xc2002664},
{0x58, 0x9a004001},
{0x5c, 0x9a034001},
{0x60, 0xc200259c},
{0x64, 0xb2006140},
{0x68, 0x9a03400d},
{0x6c, 0x82102061},
{0x70, 0x8220400d},
{0x74, 0x9b2e6007},
{0x78, 0x973b601f},
{0x7c, 0x8182e000},
{0xf0, 0x50},
{0x00, 0x01000000},
{0x04, 0x01000000},
{0x08, 0x01000000},
{0x0c, 0xb27b4001},
{0x10, 0xd820254c},
{0x14, 0xc2002fe4},
{0x18, 0x9fc04000},
{0x1c, 0x01000000},
{0x20, 0x11000017},
{0x24, 0x90122240},
{0x28, 0xe000259c},
{0x2c, 0xc2002fe4},
{0x30, 0x9fc04000},
{0x34, 0x01000000},
{0x38, 0x80a64010},
{0x3c, 0x9a603fff},
{0x40, 0xc200259c},
{0x44, 0x80a64001},
{0x48, 0x11000019},
{0x4c, 0x82603fff},
{0x50, 0x80934001},
{0x54, 0x02800009},
{0x58, 0x90122240},
{0x5c, 0x7ffffa8a},
{0x60, 0x01000000},
{0x64, 0x7ffffa9b},
{0x68, 0x01000000},
{0x6c, 0x82102015},
{0x70, 0x10800011},
{0x74, 0xc2202500},
{0x78, 0xc020250c},
{0x7c, 0x31000018},
{0xf0, 0x51},
{0x00, 0x33000017},
{0x04, 0xc200250c},
{0x08, 0xb0162200},
{0x0c, 0x80a06000},
{0x10, 0x12800009},
{0x14, 0xb2166240},
{0x18, 0x031696a9},
{0x1c, 0x821061a5},
{0x20, 0xc220250c},
{0x24, 0xc0202668},
{0x28, 0xc0202664},
{0x2c, 0x7ffffd1b},
{0x30, 0x81e80000},
{0x34, 0x01000000},
{0x38, 0x81c7e008},
{0x3c, 0x81e80000},
{0x40, 0x9de3bf58},
{0x44, 0x94100018},
{0x48, 0x9a102000},
{0x4c, 0x96102000},
{0x50, 0x98102000},
{0x54, 0x9e102000},
{0x58, 0x8203000f},
{0x5c, 0xf6086441},
{0x60, 0x80a6e000},
{0x64, 0x02800021},
{0x68, 0xf4086440},
{0x6c, 0xf40ea37f},
{0x70, 0xf60ee37f},
{0x74, 0xb2102000},
{0x78, 0xb007bff8},
{0x7c, 0xc200247c},
{0xf0, 0x52},
{0x00, 0x82584019},
{0x04, 0xba06c001},
{0x08, 0x82068001},
{0x0c, 0x82004001},
{0x10, 0xf8528001},
{0x14, 0xba07401d},
{0x18, 0xc252801d},
{0x1c, 0xb8270001},
{0x20, 0x80a66000},
{0x24, 0x02800007},
{0x28, 0xf8263fc0},
{0x2c, 0xc2063fbc},
{0x30, 0x82a70001},
{0x34, 0x2c800003},
{0x38, 0x9a234001},
{0x3c, 0x9a034001},
{0x40, 0xc2002300},
{0x44, 0xb2066001},
{0x48, 0x82007fff},
{0x4c, 0x80a64001},
{0x50, 0x08bfffeb},
{0x54, 0xb0062004},
{0x58, 0x9e03e001},
{0x5c, 0x80a3e00a},
{0x60, 0x04bfffdf},
{0x64, 0x8203000f},
{0x68, 0x9602e001},
{0x6c, 0x80a2e001},
{0x70, 0x04bfffd9},
{0x74, 0x9803200c},
{0x78, 0xda20259c},
{0x7c, 0x81c7e008},
{0xf0, 0x53},
{0x00, 0x81e80000},
{0x04, 0x9de3bf98},
{0x08, 0xc20021cc},
{0x0c, 0x80a06000},
{0x10, 0x22800025},
{0x14, 0xc2002568},
{0x18, 0x82064019},
{0x1c, 0x82004019},
{0x20, 0x83286002},
{0x24, 0x82004018},
{0x28, 0x9f286002},
{0x2c, 0xb92e2010},
{0x30, 0x3b003fc0},
{0x34, 0x03000019},
{0x38, 0x9a1760ff},
{0x3c, 0xb8070019},
{0x40, 0x98106080},
{0x44, 0xb4102007},
{0x48, 0xbb2ea002},
{0x4c, 0xc20761b0},
{0x50, 0x80a06000},
{0x54, 0x02800030},
{0x58, 0xb608400d},
{0x5c, 0x80a6c01c},
{0x60, 0x3280000e},
{0x64, 0xb486bfff},
{0x68, 0xfa0f61b0},
{0x6c, 0x80a76000},
{0x70, 0x2280000d},
{0x74, 0xc2002568},
{0x78, 0xc203c00c},
{0x7c, 0x8258401d},
{0xf0, 0x54},
{0x00, 0xbb38601f},
{0x04, 0xbb376019},
{0x08, 0x8200401d},
{0x0c, 0x83386007},
{0x10, 0x10800004},
{0x14, 0xc223c00c},
{0x18, 0x1cbfffed},
{0x1c, 0xbb2ea002},
{0x20, 0xc2002568},
{0x24, 0x80a06000},
{0x28, 0x12800033},
{0x2c, 0xb6064019},
{0x30, 0x8206c019},
{0x34, 0x83286002},
{0x38, 0x82004018},
{0x3c, 0x3b000019},
{0x40, 0x83286002},
{0x44, 0xba176080},
{0x48, 0xf800401d},
{0x4c, 0xc200251c},
{0x50, 0x80a70001},
{0x54, 0x04800028},
{0x58, 0x01000000},
{0x5c, 0xfa002540},
{0x60, 0x80a76000},
{0x64, 0x02800015},
{0x68, 0x832e2010},
{0x6c, 0xc20023c8},
{0x70, 0x80886100},
{0x74, 0x02800011},
{0x78, 0x832e2010},
{0x7c, 0x80a7001d},
{0xf0, 0x55},
{0x00, 0x0880001d},
{0x04, 0x82004019},
{0x08, 0x82207000},
{0x0c, 0x10800012},
{0x10, 0xc22026e0},
{0x14, 0x82064019},
{0x18, 0x82004019},
{0x1c, 0x83286002},
{0x20, 0x82004018},
{0x24, 0x3b000019},
{0x28, 0x83286002},
{0x2c, 0xba176080},
{0x30, 0x10bfffdc},
{0x34, 0xc020401d},
{0x38, 0xfa002514},
{0x3c, 0x82004019},
{0x40, 0xb92f6002},
{0x44, 0x82207000},
{0x48, 0xc22726e0},
{0x4c, 0xba076001},
{0x50, 0xfa202514},
{0x54, 0x8206c019},
{0x58, 0x83286002},
{0x5c, 0x82004018},
{0x60, 0x3b000019},
{0x64, 0x83286002},
{0x68, 0xba176080},
{0x6c, 0xc200401d},
{0x70, 0xc2202540},
{0x74, 0x81c7e008},
{0x78, 0x81e80000},
{0x7c, 0x9de3bf98},
{0xf0, 0x56},
{0x00, 0xc2002304},
{0x04, 0x80a06000},
{0x08, 0x02800022},
{0x0c, 0x01000000},
{0x10, 0xf80021d8},
{0x14, 0x80a72000},
{0x18, 0x0280001e},
{0x1c, 0x82064019},
{0x20, 0x82004019},
{0x24, 0x83286002},
{0x28, 0x82004018},
{0x2c, 0xb1286002},
{0x30, 0x3b000019},
{0x34, 0xc2002300},
{0x38, 0xb61760dc},
{0x3c, 0xb41760e0},
{0x40, 0x9e1760e4},
{0x44, 0x80a64001},
{0x48, 0x12800012},
{0x4c, 0x9a176080},
{0x50, 0xc206001a},
{0x54, 0xfa06001b},
{0x58, 0xba074001},
{0x5c, 0xc206000f},
{0x60, 0xba074001},
{0x64, 0xba5f401c},
{0x68, 0x833f601f},
{0x6c, 0x83306019},
{0x70, 0xba074001},
{0x74, 0xc206000d},
{0x78, 0xbb3f6007},
{0x7c, 0x80a0401d},
{0xf0, 0x57},
{0x00, 0x16800004},
{0x04, 0x82102001},
{0x08, 0xc220259c},
{0x0c, 0x30800002},
{0x10, 0xc020259c},
{0x14, 0x81c7e008},
{0x18, 0x81e80000},
{0x1c, 0x9de3bf98},
{0x20, 0xc2002588},
{0x24, 0x80a06000},
{0x28, 0x02800014},
{0x2c, 0x11000018},
{0x30, 0xc2002594},
{0x34, 0x80a06000},
{0x38, 0x12800004},
{0x3c, 0x90122340},
{0x40, 0x7ffffc0b},
{0x44, 0x01000000},
{0x48, 0xc2002588},
{0x4c, 0xda002594},
{0x50, 0x82007fff},
{0x54, 0x9a036001},
{0x58, 0xc2202588},
{0x5c, 0x7ffff99e},
{0x60, 0xda202594},
{0x64, 0x33000018},
{0x68, 0xb2166340},
{0x6c, 0xf4002594},
{0x70, 0x7ffffbe1},
{0x74, 0x91e80008},
{0x78, 0x01000000},
{0x7c, 0x81c7e008},
{0xf0, 0x58},
{0x00, 0x81e80000},
{0x04, 0xc2002460},
{0x08, 0x80a06000},
{0x0c, 0x12800018},
{0x10, 0xda002298},
{0x14, 0xc2002588},
{0x18, 0x80a06001},
{0x1c, 0x12800015},
{0x20, 0x033fc200},
{0x24, 0xc2002208},
{0x28, 0x80a06000},
{0x2c, 0x22800007},
{0x30, 0xc2102548},
{0x34, 0xc2002558},
{0x38, 0x80a06000},
{0x3c, 0x22800007},
{0x40, 0xc0202598},
{0x44, 0xc2102548},
{0x48, 0x80886001},
{0x4c, 0x22800005},
{0x50, 0xc2002598},
{0x54, 0xc0202598},
{0x58, 0x10800005},
{0x5c, 0xda002234},
{0x60, 0x80a06000},
{0x64, 0x22800002},
{0x68, 0xda00233c},
{0x6c, 0x033fc200},
{0x70, 0x82106070},
{0x74, 0x81c3e008},
{0x78, 0xda204000},
{0x7c, 0x9de3bf98},
{0xf0, 0x59},
{0x00, 0xc2002588},
{0x04, 0x80a06000},
{0x08, 0x0280000f},
{0x0c, 0x11000018},
{0x10, 0xc2102548},
{0x14, 0x80886001},
{0x18, 0x22800010},
{0x1c, 0xc200258c},
{0x20, 0xc2002558},
{0x24, 0x80a06000},
{0x28, 0x3280000c},
{0x2c, 0xc200258c},
{0x30, 0xc2002594},
{0x34, 0x80a06001},
{0x38, 0x32800008},
{0x3c, 0xc200258c},
{0x40, 0x11000018},
{0x44, 0x90122340},
{0x48, 0xd0202590},
{0x4c, 0xc0202588},
{0x50, 0x10800014},
{0x54, 0xd2002594},
{0x58, 0x80a06000},
{0x5c, 0x1280000f},
{0x60, 0x82102001},
{0x64, 0xd2002598},
{0x68, 0xc2002554},
{0x6c, 0x80a24001},
{0x70, 0x1a800007},
{0x74, 0x11000017},
{0x78, 0xc220258c},
{0x7c, 0x82102001},
{0xf0, 0x5a},
{0x00, 0xc2202584},
{0x04, 0x10800028},
{0x08, 0xc0202598},
{0x0c, 0x90122100},
{0x10, 0x10800004},
{0x14, 0xd0202590},
{0x18, 0x10800023},
{0x1c, 0xc2202584},
{0x20, 0x7ffffbbb},
{0x24, 0x01000000},
{0x28, 0x13000018},
{0x2c, 0xc2002fd0},
{0x30, 0x92126200},
{0x34, 0x9fc04000},
{0x38, 0xd0002590},
{0x3c, 0xc20026a0},
{0x40, 0x82087dff},
{0x44, 0xda08254e},
{0x48, 0x80a36000},
{0x4c, 0x12800006},
{0x50, 0xc22026a0},
{0x54, 0xc200218c},
{0x58, 0x80a06000},
{0x5c, 0x32800004},
{0x60, 0xc220256c},
{0x64, 0x82102080},
{0x68, 0xc220256c},
{0x6c, 0x033fc200},
{0x70, 0x82106030},
{0x74, 0xda004000},
{0x78, 0xc2002670},
{0x7c, 0x80a34001},
{0xf0, 0x5b},
{0x00, 0x32800007},
{0x04, 0xc2002548},
{0x08, 0xc2002200},
{0x0c, 0x80a06000},
{0x10, 0x02800005},
{0x14, 0x01000000},
{0x18, 0xc2002548},
{0x1c, 0x82106001},
{0x20, 0xc2202548},
{0x24, 0x81c7e008},
{0x28, 0x81e80000},
{0x2c, 0x1500003f},
{0x30, 0xd8002508},
{0x34, 0x8212a300},
{0x38, 0x9a0b0001},
{0x3c, 0x808b3f00},
{0x40, 0x02800015},
{0x44, 0x901020a5},
{0x48, 0xc200254c},
{0x4c, 0x8210400d},
{0x50, 0xc220254c},
{0x54, 0x1b3fc000},
{0x58, 0xc2002500},
{0x5c, 0x960b000d},
{0x60, 0x80a06026},
{0x64, 0xc0202508},
{0x68, 0x0880000b},
{0x6c, 0x033fffc0},
{0x70, 0x9a0b0001},
{0x74, 0x03168000},
{0x78, 0x80a2c001},
{0x7c, 0x12800006},
{0xf0, 0x5c},
{0x00, 0x9412a3ff},
{0x04, 0xc2002548},
{0x08, 0x8208400a},
{0x0c, 0x8210400d},
{0x10, 0xc2202548},
{0x14, 0x03000006},
{0x18, 0x81c0630c},
{0x1c, 0x01000000},
{0x20, 0x01000000},
{0x24, 0xda00247c},
{0x28, 0xc20022f8},
{0x2c, 0x8258400d},
{0x30, 0x83306001},
{0x34, 0x9a102000},
{0x38, 0x80a34001},
{0x3c, 0x1a800015},
{0x40, 0x031fffdf},
{0x44, 0x961063ff},
{0x48, 0x98036001},
{0x4c, 0x80a26008},
{0x50, 0x04800006},
{0x54, 0x9b2b6002},
{0x58, 0xc202000d},
{0x5c, 0x83306001},
{0x60, 0x10800003},
{0x64, 0x8208400b},
{0x68, 0xc202000d},
{0x6c, 0x82584009},
{0x70, 0xc222000d},
{0x74, 0xda00247c},
{0x78, 0xc20022f8},
{0x7c, 0x8258400d},
{0xf0, 0x5d},
{0x00, 0x83306001},
{0x04, 0x80a30001},
{0x08, 0x0abffff0},
{0x0c, 0x9a10000c},
{0x10, 0x81c3e008},
{0x14, 0x01000000},
{0x18, 0x9de3bf98},
{0x1c, 0xe6002460},
{0x20, 0x80a4e000},
{0x24, 0x02800070},
{0x28, 0x01000000},
{0x2c, 0xc2002594},
{0x30, 0xee002588},
{0x34, 0x9805c001},
{0x38, 0xc2002554},
{0x3c, 0x80a30001},
{0x40, 0x12800069},
{0x44, 0x01000000},
{0x48, 0xda002598},
{0x4c, 0xc200258c},
{0x50, 0x8200400d},
{0x54, 0x80a0400c},
{0x58, 0x02800004},
{0x5c, 0x80a36000},
{0x60, 0x12800061},
{0x64, 0x01000000},
{0x68, 0x96102001},
{0x6c, 0xe20022fc},
{0x70, 0x80a2c011},
{0x74, 0x1880002d},
{0x78, 0x9e102000},
{0x7c, 0xe40022f8},
{0xf0, 0x5e},
{0x00, 0x13000019},
{0x04, 0x94102001},
{0x08, 0x80a28012},
{0x0c, 0x18800020},
{0x10, 0xa0102000},
{0x14, 0x832ae002},
{0x18, 0x98006030},
{0x1c, 0xac126080},
{0x20, 0xaa126050},
{0x24, 0xa81260b0},
{0x28, 0xd00022f8},
{0x2c, 0xda030016},
{0x30, 0x80a34013},
{0x34, 0x26800013},
{0x38, 0x9402a001},
{0x3c, 0x80a2a001},
{0x40, 0x22800007},
{0x44, 0xc20022f8},
{0x48, 0xc2030015},
{0x4c, 0x80a34001},
{0x50, 0x2480000c},
{0x54, 0x9402a001},
{0x58, 0xc20022f8},
{0x5c, 0x80a28001},
{0x60, 0x22800007},
{0x64, 0xa0042001},
{0x68, 0xc2030014},
{0x6c, 0x80a34001},
{0x70, 0x26800004},
{0x74, 0x9402a001},
{0x78, 0xa0042001},
{0x7c, 0x9402a001},
{0xf0, 0x5f},
{0x00, 0x80a28008},
{0x04, 0x08bfffea},
{0x08, 0x98032030},
{0x0c, 0x80a4000f},
{0x10, 0x34800002},
{0x14, 0x9e100010},
{0x18, 0x9602e001},
{0x1c, 0x80a2c011},
{0x20, 0x28bfffda},
{0x24, 0x94102001},
{0x28, 0x96102000},
{0x2c, 0xc20ae464},
{0x30, 0x80a06000},
{0x34, 0x22800006},
{0x38, 0x9602e001},
{0x3c, 0x80a3c001},
{0x40, 0x34800007},
{0x44, 0xc20ae278},
{0x48, 0x9602e001},
{0x4c, 0x80a2e003},
{0x50, 0x24bffff8},
{0x54, 0xc20ae464},
{0x58, 0x30800023},
{0x5c, 0xda00256c},
{0x60, 0x8258400d},
{0x64, 0x83306007},
{0x68, 0xc220256c},
{0x6c, 0xe00ae468},
{0x70, 0x80a42000},
{0x74, 0x0280001c},
{0x78, 0x80a5e000},
{0x7c, 0x32800007},
{0xf0, 0x60},
{0x00, 0xc200258c},
{0x04, 0x11000018},
{0x08, 0x90122340},
{0x0c, 0x7fffff86},
{0x10, 0xd2002594},
{0x14, 0xc200258c},
{0x18, 0x80a06000},
{0x1c, 0x32800007},
{0x20, 0xc2002588},
{0x24, 0x11000017},
{0x28, 0x90122100},
{0x2c, 0x7fffff7e},
{0x30, 0xd2002598},
{0x34, 0xc2002588},
{0x38, 0x82004010},
{0x3c, 0xc2202588},
{0x40, 0xda00258c},
{0x44, 0xc2002554},
{0x48, 0x80a34001},
{0x4c, 0x18800005},
{0x50, 0x82102001},
{0x54, 0x82034010},
{0x58, 0xc220258c},
{0x5c, 0x82102001},
{0x60, 0xc2202584},
{0x64, 0x81c7e008},
{0x68, 0x81e80000},
{0x6c, 0x9de3bf98},
{0x70, 0xc20025a8},
{0x74, 0x82006001},
{0x78, 0xda002310},
{0x7c, 0x80a0400d},
{0xf0, 0x61},
{0x00, 0x0a800060},
{0x04, 0xc22025a8},
{0x08, 0xd800227c},
{0x0c, 0x80a32000},
{0x10, 0x02800038},
{0x14, 0xc02025a8},
{0x18, 0x1b000007},
{0x1c, 0x9a1363ff},
{0x20, 0x8333200d},
{0x24, 0x9208400d},
{0x28, 0xc200258c},
{0x2c, 0x80a06000},
{0x30, 0x03000017},
{0x34, 0xa4106100},
{0x38, 0x900b000d},
{0x3c, 0xa2102000},
{0x40, 0x02800004},
{0x44, 0x94102000},
{0x48, 0x82006400},
{0x4c, 0xa4106340},
{0x50, 0xda0022f8},
{0x54, 0xc200247c},
{0x58, 0x9a5b4001},
{0x5c, 0xa0102000},
{0x60, 0x80a4000d},
{0x64, 0x1a800013},
{0x68, 0x03000018},
{0x6c, 0x9e106200},
{0x70, 0x9610000d},
{0x74, 0x9a040010},
{0x78, 0xc214800d},
{0x7c, 0x80a24001},
{0xf0, 0x62},
{0x00, 0xa2400011},
{0x04, 0xc213400f},
{0x08, 0x80a04008},
{0x0c, 0x0a800005},
{0x10, 0xa0042001},
{0x14, 0x80a04009},
{0x18, 0x08800004},
{0x1c, 0x80a4000b},
{0x20, 0x9402a001},
{0x24, 0x80a4000b},
{0x28, 0x0abffff4},
{0x2c, 0x9a040010},
{0x30, 0xa133201a},
{0x34, 0x80a44010},
{0x38, 0x14800003},
{0x3c, 0x9a102001},
{0x40, 0x9a102000},
{0x44, 0x80a28010},
{0x48, 0x14800003},
{0x4c, 0x82102001},
{0x50, 0x82102000},
{0x54, 0x80934001},
{0x58, 0x22800007},
{0x5c, 0xc2002274},
{0x60, 0x033fc180},
{0x64, 0x1b008000},
{0x68, 0x8210603c},
{0x6c, 0xda204000},
{0x70, 0xc2002274},
{0x74, 0x80a06000},
{0x78, 0x02800022},
{0x7c, 0xa2102000},
{0xf0, 0x63},
{0x00, 0xc20023d4},
{0x04, 0x80a44001},
{0x08, 0xa4102000},
{0x0c, 0x1a800016},
{0x10, 0xa0102000},
{0x14, 0xc200247c},
{0x18, 0x80a40001},
{0x1c, 0x3a80000f},
{0x20, 0xa404a001},
{0x24, 0x7ffff8af},
{0x28, 0x90100010},
{0x2c, 0x92100008},
{0x30, 0x7ffff854},
{0x34, 0x90100012},
{0x38, 0x0300003f},
{0x3c, 0xda002274},
{0x40, 0x821063ff},
{0x44, 0x9a0b4001},
{0x48, 0x80a2000d},
{0x4c, 0xa2400011},
{0x50, 0x10bffff1},
{0x54, 0xa0042001},
{0x58, 0xc20023d4},
{0x5c, 0x10bfffec},
{0x60, 0x80a48001},
{0x64, 0xc2102274},
{0x68, 0x80a44001},
{0x6c, 0x08800005},
{0x70, 0x033fc180},
{0x74, 0x1b004000},
{0x78, 0x8210603c},
{0x7c, 0xda204000},
{0xf0, 0x64},
{0x00, 0x81c7e008},
{0x04, 0x81e80000},
{0x08, 0x9de3bf98},
{0x0c, 0xda002310},
{0x10, 0x80a36000},
{0x14, 0x02800058},
{0x18, 0x01000000},
{0x1c, 0xc200254c},
{0x20, 0x80886100},
{0x24, 0x12800054},
{0x28, 0x01000000},
{0x2c, 0xc2002578},
{0x30, 0x82006001},
{0x34, 0x80a0400d},
{0x38, 0x0a80004f},
{0x3c, 0xc2202578},
{0x40, 0xa4102000},
{0x44, 0xc20023d4},
{0x48, 0x80a48001},
{0x4c, 0xc0202578},
{0x50, 0xa2102000},
{0x54, 0x1a80002c},
{0x58, 0xa72c6002},
{0x5c, 0xc204e364},
{0x60, 0x80a06000},
{0x64, 0x02800024},
{0x68, 0xa0102000},
{0x6c, 0xc20022fc},
{0x70, 0x80a40001},
{0x74, 0x1a800020},
{0x78, 0x15000018},
{0x7c, 0xc2002548},
{0xf0, 0x65},
{0x00, 0x80886020},
{0x04, 0x03000017},
{0x08, 0x9a106100},
{0x0c, 0xc20c2380},
{0x10, 0x90100011},
{0x14, 0x9412a200},
{0x18, 0x02800009},
{0x1c, 0x920860ff},
{0x20, 0xc200258c},
{0x24, 0x80a06000},
{0x28, 0x22800005},
{0x2c, 0x9410000d},
{0x30, 0x03000018},
{0x34, 0x9a106340},
{0x38, 0x9410000d},
{0x3c, 0x7ffff83a},
{0x40, 0xa0042001},
{0x44, 0xc204e364},
{0x48, 0xda002348},
{0x4c, 0x98020001},
{0x50, 0x82034001},
{0x54, 0x80a20001},
{0x58, 0x38bfffe5},
{0x5c, 0xa404a001},
{0x60, 0x80a3000d},
{0x64, 0x3abfffe3},
{0x68, 0xc20022fc},
{0x6c, 0x10bfffe0},
{0x70, 0xa404a001},
{0x74, 0xa2046001},
{0x78, 0xc20023d4},
{0x7c, 0x10bfffd6},
{0xf0, 0x66},
{0x00, 0x80a44001},
{0x04, 0xd8002574},
{0x08, 0x80a0000c},
{0x0c, 0x9a603fff},
{0x10, 0x80a00012},
{0x14, 0x82603fff},
{0x18, 0x808b4001},
{0x1c, 0x0280000a},
{0x20, 0x80a4a000},
{0x24, 0xda002548},
{0x28, 0x83336005},
{0x2c, 0x82086001},
{0x30, 0x82186001},
{0x34, 0x83286005},
{0x38, 0x9a0b7fdf},
{0x3c, 0x9a134001},
{0x40, 0xda202548},
{0x44, 0x12800004},
{0x48, 0x82032001},
{0x4c, 0x10800003},
{0x50, 0xc0202574},
{0x54, 0xc2202574},
{0x58, 0xc2002574},
{0x5c, 0x80a06002},
{0x60, 0x08800005},
{0x64, 0x1b000040},
{0x68, 0xc200254c},
{0x6c, 0x8210400d},
{0x70, 0xc220254c},
{0x74, 0x81c7e008},
{0x78, 0x81e80000},
{0x7c, 0x9de3bf58},
{0xf0, 0x67},
{0x00, 0xc2002548},
{0x04, 0x80886001},
{0x08, 0x1280006d},
{0x0c, 0x01000000},
{0x10, 0xfa002500},
{0x14, 0xc20021f4},
{0x18, 0x80a74001},
{0x1c, 0x18800068},
{0x20, 0x01000000},
{0x24, 0xc200254c},
{0x28, 0x8330600b},
{0x2c, 0x82086001},
{0x30, 0x80a00001},
{0x34, 0x9a603fff},
{0x38, 0x9403400d},
{0x3c, 0xc252a210},
{0x40, 0x80a06000},
{0x44, 0x0280005e},
{0x48, 0x8207bfb8},
{0x4c, 0xb810200f},
{0x50, 0xc0204000},
{0x54, 0xb8873fff},
{0x58, 0x1cbffffe},
{0x5c, 0x82006004},
{0x60, 0xb0102001},
{0x64, 0xc2002300},
{0x68, 0x80a60001},
{0x6c, 0x1880003b},
{0x70, 0x03000019},
{0x74, 0x82106080},
{0x78, 0x96006030},
{0x7c, 0xb4102001},
{0xf0, 0x68},
{0x00, 0xc2002308},
{0x04, 0x80a68001},
{0x08, 0x38800030},
{0x0c, 0xb0062001},
{0x10, 0xb202e004},
{0x14, 0xfa52a210},
{0x18, 0xc2064000},
{0x1c, 0x80a0401d},
{0x20, 0x36800025},
{0x24, 0xb406a001},
{0x28, 0x832ea018},
{0x2c, 0xbb2e2010},
{0x30, 0x8200401d},
{0x34, 0x9e006001},
{0x38, 0xb8102000},
{0x3c, 0x98102001},
{0x40, 0xb607bfb8},
{0x44, 0xbb2f2002},
{0x48, 0xc20f67f8},
{0x4c, 0x80a68001},
{0x50, 0x1280000f},
{0x54, 0xb8072001},
{0x58, 0xc20f67f9},
{0x5c, 0x80a60001},
{0x60, 0x3280000c},
{0x64, 0xc21767f8},
{0x68, 0xd826c000},
{0x6c, 0xc21767fa},
{0x70, 0x80a061fe},
{0x74, 0x38800010},
{0x78, 0xb406a001},
{0x7c, 0xc20767f8},
{0xf0, 0x69},
{0x00, 0x82006001},
{0x04, 0x1080000b},
{0x08, 0xc22767f8},
{0x0c, 0xc21767f8},
{0x10, 0x80a06000},
{0x14, 0x12800005},
{0x18, 0x80a7200f},
{0x1c, 0xd826c000},
{0x20, 0x10800004},
{0x24, 0xde2767f8},
{0x28, 0x08bfffe7},
{0x2c, 0xb606e004},
{0x30, 0xb406a001},
{0x34, 0xc2002308},
{0x38, 0x80a68001},
{0x3c, 0x08bfffd6},
{0x40, 0xb2066004},
{0x44, 0xb0062001},
{0x48, 0xc2002300},
{0x4c, 0x80a60001},
{0x50, 0x08bfffcb},
{0x54, 0x9602e030},
{0x58, 0xb4102000},
{0x5c, 0xb8102000},
{0x60, 0xb607bff8},
{0x64, 0xbb2f2002},
{0x68, 0x8207401b},
{0x6c, 0xc2007fc0},
{0x70, 0x80a06000},
{0x74, 0x32800004},
{0x78, 0xfa1767fa},
{0x7c, 0x10800005},
{0xf0, 0x6a},
{0x00, 0xc02767f8},
{0x04, 0xc20b63cc},
{0x08, 0x80a74001},
{0x0c, 0xb466bfff},
{0x10, 0xb8072001},
{0x14, 0x80a7200f},
{0x18, 0x08bffff4},
{0x1c, 0xbb2f2002},
{0x20, 0xc20b63ce},
{0x24, 0x80a68001},
{0x28, 0x08800005},
{0x2c, 0x3b000200},
{0x30, 0xc200254c},
{0x34, 0x8210401d},
{0x38, 0xc220254c},
{0x3c, 0x81c7e008},
{0x40, 0x81e80000},
{0x44, 0x9de3bf90},
{0x48, 0xc2002200},
{0x4c, 0x80a06000},
{0x50, 0x1280000a},
{0x54, 0xba102000},
{0x58, 0xc2002548},
{0x5c, 0x82087ffb},
{0x60, 0xc2202548},
{0x64, 0x033fc180},
{0x68, 0x8210602c},
{0x6c, 0xc0204000},
{0x70, 0x1080007b},
{0x74, 0xc020253c},
{0x78, 0x9a102001},
{0x7c, 0xd6102238},
{0xf0, 0x6b},
{0x00, 0x1080002e},
{0x04, 0x9810200c},
{0x08, 0x92106080},
{0x0c, 0x9e102000},
{0x10, 0xb407bff8},
{0x14, 0xb0102000},
{0x18, 0x15000004},
{0x1c, 0xd426bff8},
{0x20, 0xb2102000},
{0x24, 0x82060019},
{0x28, 0xf8086440},
{0x2c, 0x8203001c},
{0x30, 0x80a72000},
{0x34, 0x02800010},
{0x38, 0x83286002},
{0x3c, 0xf8004009},
{0x40, 0xc206bff8},
{0x44, 0x80a70001},
{0x48, 0x16800003},
{0x4c, 0xb2066001},
{0x50, 0xf826bff8},
{0x54, 0xc210223a},
{0x58, 0x80a70001},
{0x5c, 0x04800003},
{0x60, 0xb6270001},
{0x64, 0xba07401b},
{0x68, 0x80a6600b},
{0x6c, 0x28bfffef},
{0x70, 0x82060019},
{0x74, 0x80a66000},
{0x78, 0x2280000a},
{0x7c, 0x9e03e001},
{0xf0, 0x6c},
{0x00, 0xf810223a},
{0x04, 0xc206bff8},
{0x08, 0x80a0401c},
{0x0c, 0x26800004},
{0x10, 0xf826bff8},
{0x14, 0x82584019},
{0x18, 0xba274001},
{0x1c, 0x9e03e001},
{0x20, 0xb006200c},
{0x24, 0x80a3e001},
{0x28, 0x08bfffdd},
{0x2c, 0xb406a004},
{0x30, 0x9a036001},
{0x34, 0x9803200c},
{0x38, 0x80a2e000},
{0x3c, 0x32800004},
{0x40, 0x80a3400b},
{0x44, 0xc2002200},
{0x48, 0x80a34001},
{0x4c, 0x08bfffcf},
{0x50, 0x03000019},
{0x54, 0x80a76000},
{0x58, 0x04800015},
{0x5c, 0xc207bff0},
{0x60, 0xf807bff4},
{0x64, 0xba5f4001},
{0x68, 0x82070001},
{0x6c, 0xbb2f6002},
{0x70, 0x9b3f601f},
{0x74, 0x81836000},
{0x78, 0x01000000},
{0x7c, 0x01000000},
{0xf0, 0x6d},
{0x00, 0x01000000},
{0x04, 0xba7f4001},
{0x08, 0xba5f401c},
{0x0c, 0x9b3f601f},
{0x10, 0x81836000},
{0x14, 0x01000000},
{0x18, 0x01000000},
{0x1c, 0x01000000},
{0x20, 0xba7f4001},
{0x24, 0x10800003},
{0x28, 0xfa202504},
{0x2c, 0xc0202504},
{0x30, 0xfa10223e},
{0x34, 0xc2002504},
{0x38, 0x80a0401d},
{0x3c, 0x3480000a},
{0x40, 0xc2002548},
{0x44, 0xfa10223c},
{0x48, 0x80a76000},
{0x4c, 0x2280000b},
{0x50, 0xc2002548},
{0x54, 0xc2082517},
{0x58, 0x80a0401d},
{0x5c, 0x0a800007},
{0x60, 0xc2002548},
{0x64, 0x80886008},
{0x68, 0x22800008},
{0x6c, 0xc200253c},
{0x70, 0x10800008},
{0x74, 0xc020253c},
{0x78, 0x80886008},
{0x7c, 0x22800005},
{0xf0, 0x6e},
{0x00, 0xc020253c},
{0x04, 0xc200253c},
{0x08, 0x82006001},
{0x0c, 0xc220253c},
{0x10, 0xfa00253c},
{0x14, 0xc2002290},
{0x18, 0x80a74001},
{0x1c, 0x0880000b},
{0x20, 0xfa002548},
{0x24, 0x83376003},
{0x28, 0x82086001},
{0x2c, 0x82186001},
{0x30, 0x83286002},
{0x34, 0xba0f7ffb},
{0x38, 0xba174001},
{0x3c, 0xfa202548},
{0x40, 0xc020253c},
{0x44, 0xfa002548},
{0x48, 0xbb376002},
{0x4c, 0x033fc180},
{0x50, 0xba0f6001},
{0x54, 0x8210602c},
{0x58, 0xfa204000},
{0x5c, 0x81c7e008},
{0x60, 0x81e80000},
{0x64, 0x9de3bf70},
{0x68, 0xc2002548},
{0x6c, 0x80886400},
{0x70, 0x12800098},
{0x74, 0x1b00003f},
{0x78, 0xc2002350},
{0x7c, 0x9a1363ff},
{0xf0, 0x6f},
{0x00, 0xba08400d},
{0x04, 0xa4102001},
{0x08, 0xda002300},
{0x0c, 0x80a4800d},
{0x10, 0x18800055},
{0x14, 0xa3306010},
{0x18, 0xae10200c},
{0x1c, 0xac10200c},
{0x20, 0xaa102000},
{0x24, 0xa8102000},
{0x28, 0xa6102000},
{0x2c, 0x80a46000},
{0x30, 0x0280002c},
{0x34, 0xa0102000},
{0x38, 0x03000019},
{0x3c, 0x96106080},
{0x40, 0x92102000},
{0x44, 0x9807bfd0},
{0x48, 0x8204c009},
{0x4c, 0xda086440},
{0x50, 0x8205800d},
{0x54, 0x80a36000},
{0x58, 0x02800008},
{0x5c, 0x83286002},
{0x60, 0xc200400b},
{0x64, 0xc2230000},
{0x68, 0x92026001},
{0x6c, 0x80a2600b},
{0x70, 0x04bffff6},
{0x74, 0x98032004},
{0x78, 0x7ffff577},
{0x7c, 0x9007bfd0},
{0xf0, 0x70},
{0x00, 0x80a74011},
{0x04, 0x1480000b},
{0x08, 0x9210001d},
{0x0c, 0x832f6002},
{0x10, 0x8200401e},
{0x14, 0x9a007fd0},
{0x18, 0xc2034000},
{0x1c, 0x92026001},
{0x20, 0xa0040001},
{0x24, 0x80a24011},
{0x28, 0x04bffffc},
{0x2c, 0x9a036004},
{0x30, 0x8224401d},
{0x34, 0x82006001},
{0x38, 0x9b3c201f},
{0x3c, 0x81836000},
{0x40, 0x01000000},
{0x44, 0x01000000},
{0x48, 0x01000000},
{0x4c, 0xa07c0001},
{0x50, 0xc25021ae},
{0x54, 0x80a40001},
{0x58, 0x26800002},
{0x5c, 0xa0100001},
{0x60, 0x92102000},
{0x64, 0x15000019},
{0x68, 0x82050009},
{0x6c, 0xda086440},
{0x70, 0x8205c00d},
{0x74, 0x92026001},
{0x78, 0x9612a080},
{0x7c, 0x80a36000},
{0xf0, 0x71},
{0x00, 0x0280000e},
{0x04, 0x99286002},
{0x08, 0xc20023c8},
{0x0c, 0x83306011},
{0x10, 0xda03000b},
{0x14, 0x80886001},
{0x18, 0x02800005},
{0x1c, 0x9a234010},
{0x20, 0xc20ca2af},
{0x24, 0x825b4001},
{0x28, 0x9b386007},
{0x2c, 0x80a2600b},
{0x30, 0x04bfffee},
{0x34, 0xda23000b},
{0x38, 0xaa056001},
{0x3c, 0xa604e00c},
{0x40, 0x80a56001},
{0x44, 0x04bfffba},
{0x48, 0xa805200c},
{0x4c, 0xa404a001},
{0x50, 0xc2002300},
{0x54, 0x80a48001},
{0x58, 0xac05a00c},
{0x5c, 0x08bfffb1},
{0x60, 0xae05e00c},
{0x64, 0xc2082247},
{0x68, 0x80a06000},
{0x6c, 0x02800039},
{0x70, 0x01000000},
{0x74, 0xc20022f8},
{0x78, 0x80a48001},
{0x7c, 0x18800035},
{0xf0, 0x72},
{0x00, 0x82048012},
{0x04, 0x82004012},
{0x08, 0xa1286004},
{0x0c, 0xa2100010},
{0x10, 0x92102001},
{0x14, 0xc20022fc},
{0x18, 0x80a24001},
{0x1c, 0x1880000e},
{0x20, 0x03000019},
{0x24, 0x82106080},
{0x28, 0x82044001},
{0x2c, 0x9a006004},
{0x30, 0x9807bfd0},
{0x34, 0xc2034000},
{0x38, 0xc2230000},
{0x3c, 0x92026001},
{0x40, 0xc20022fc},
{0x44, 0x80a24001},
{0x48, 0x9a036004},
{0x4c, 0x08bffffa},
{0x50, 0x98032004},
{0x54, 0x9007bfd0},
{0x58, 0x7ffff51f},
{0x5c, 0xd20022fc},
{0x60, 0xc2082247},
{0x64, 0x83286002},
{0x68, 0x8200401e},
{0x6c, 0xda007fd0},
{0x70, 0x80a36000},
{0x74, 0x26800012},
{0x78, 0xa404a001},
{0x7c, 0x92102001},
{0xf0, 0x73},
{0x00, 0xc20022fc},
{0x04, 0x80a24001},
{0x08, 0x1880000c},
{0x0c, 0x03000019},
{0x10, 0x96106080},
{0x14, 0x98042004},
{0x18, 0xc203000b},
{0x1c, 0x8220400d},
{0x20, 0xc223000b},
{0x24, 0x92026001},
{0x28, 0xc20022fc},
{0x2c, 0x80a24001},
{0x30, 0x08bffffa},
{0x34, 0x98032004},
{0x38, 0xa404a001},
{0x3c, 0xc20022f8},
{0x40, 0x80a48001},
{0x44, 0xa2046030},
{0x48, 0x08bfffd2},
{0x4c, 0xa0042030},
{0x50, 0x81c7e008},
{0x54, 0x81e80000},
{0x58, 0x9de3bf58},
{0x5c, 0xe2502458},
{0x60, 0x80a46000},
{0x64, 0x02800058},
{0x68, 0x01000000},
{0x6c, 0xc20022f8},
{0x70, 0x80a44001},
{0x74, 0x1a800054},
{0x78, 0xa0102001},
{0x7c, 0xc20022fc},
{0xf0, 0x74},
{0x00, 0x80a40001},
{0x04, 0x18800050},
{0x08, 0xe450245a},
{0x0c, 0x96102001},
{0x10, 0xc20022f8},
{0x14, 0x80a2c001},
{0x18, 0x1880000f},
{0x1c, 0x03000019},
{0x20, 0x9b2c2002},
{0x24, 0x82106080},
{0x28, 0x9a034001},
{0x2c, 0x9a036030},
{0x30, 0x9807bfb8},
{0x34, 0xc2034000},
{0x38, 0xc2230000},
{0x3c, 0x9602e001},
{0x40, 0xc20022f8},
{0x44, 0x80a2c001},
{0x48, 0x9a036030},
{0x4c, 0x08bffffa},
{0x50, 0x98032004},
{0x54, 0x9007bfb8},
{0x58, 0x7ffff4df},
{0x5c, 0xd20022f8},
{0x60, 0x96100012},
{0x64, 0x80a48011},
{0x68, 0x1480000b},
{0x6c, 0x94102000},
{0x70, 0x832ca002},
{0x74, 0x8200401e},
{0x78, 0x9a007fb8},
{0x7c, 0xc2034000},
{0xf0, 0x75},
{0x00, 0x9602e001},
{0x04, 0x94028001},
{0x08, 0x80a2c011},
{0x0c, 0x04bffffc},
{0x10, 0x9a036004},
{0x14, 0x82244012},
{0x18, 0x82006001},
{0x1c, 0x9b3aa01f},
{0x20, 0x81836000},
{0x24, 0x01000000},
{0x28, 0x01000000},
{0x2c, 0x01000000},
{0x30, 0x947a8001},
{0x34, 0xc25021ac},
{0x38, 0x80a28001},
{0x3c, 0x26800002},
{0x40, 0x94100001},
{0x44, 0x96102001},
{0x48, 0xc20022f8},
{0x4c, 0x80a2c001},
{0x50, 0x18800018},
{0x54, 0x9b2c2002},
{0x58, 0x03000019},
{0x5c, 0x92106080},
{0x60, 0x98036030},
{0x64, 0xc2030009},
{0x68, 0x9a20400a},
{0x6c, 0xda230009},
{0x70, 0xc20023c8},
{0x74, 0x83306012},
{0x78, 0x80886001},
{0x7c, 0x02800009},
{0xf0, 0x76},
{0x00, 0x9602e001},
{0x04, 0xc20c22af},
{0x08, 0x825b4001},
{0x0c, 0x9b38601f},
{0x10, 0x9b336019},
{0x14, 0x8200400d},
{0x18, 0x83386007},
{0x1c, 0xc2230009},
{0x20, 0xc20022f8},
{0x24, 0x80a2c001},
{0x28, 0x08bfffef},
{0x2c, 0x98032030},
{0x30, 0xa0042001},
{0x34, 0xc20022fc},
{0x38, 0x80a40001},
{0x3c, 0x08bfffb5},
{0x40, 0x96102001},
{0x44, 0x81c7e008},
{0x48, 0x81e80000},
{0x4c, 0xc2082673},
{0x50, 0xda00256c},
{0x54, 0x82006001},
{0x58, 0xd808257f},
{0x5c, 0x9a5b4001},
{0x60, 0x98032001},
{0x64, 0x81800000},
{0x68, 0x01000000},
{0x6c, 0x01000000},
{0x70, 0x01000000},
{0x74, 0x9a73400c},
{0x78, 0xda20256c},
{0x7c, 0x96102000},
{0xf0, 0x77},
{0x00, 0x832ae002},
{0x04, 0xd800256c},
{0x08, 0xda1063b6},
{0x0c, 0x9a5b400c},
{0x10, 0x9b336007},
{0x14, 0x9602e001},
{0x18, 0x80a2e003},
{0x1c, 0x04bffff9},
{0x20, 0xda206520},
{0x24, 0xc20023c0},
{0x28, 0x80a06000},
{0x2c, 0x02800007},
{0x30, 0x82103001},
{0x34, 0xc2002200},
{0x38, 0x80a06000},
{0x3c, 0x22800005},
{0x40, 0xc2002540},
{0x44, 0x82103001},
{0x48, 0xc220252c},
{0x4c, 0xc2002540},
{0x50, 0x80a06000},
{0x54, 0x02800005},
{0x58, 0xc2002288},
{0x5c, 0x9b306001},
{0x60, 0x83306002},
{0x64, 0x8200400d},
{0x68, 0xc220251c},
{0x6c, 0x03000007},
{0x70, 0x81c0626c},
{0x74, 0x01000000},
{0x78, 0x01000000},
{0x7c, 0x9de3bf98},
{0xf0, 0x78},
{0x00, 0xc2002308},
{0x04, 0x82006001},
{0x08, 0xe00022fc},
{0x0c, 0x80a40001},
{0x10, 0x0a80001e},
{0x14, 0xa4102001},
{0x18, 0xc20022f8},
{0x1c, 0x80a48001},
{0x20, 0x38800017},
{0x24, 0xc2002308},
{0x28, 0x832c2002},
{0x2c, 0xa2006030},
{0x30, 0xc2002fec},
{0x34, 0x92100012},
{0x38, 0x80a06000},
{0x3c, 0xa404a001},
{0x40, 0x02800004},
{0x44, 0x90100010},
{0x48, 0x9fc04000},
{0x4c, 0x01000000},
{0x50, 0x03000019},
{0x54, 0x98106080},
{0x58, 0xda04400c},
{0x5c, 0x82106084},
{0x60, 0xda244001},
{0x64, 0xc024400c},
{0x68, 0xc20022f8},
{0x6c, 0x80a48001},
{0x70, 0x08bffff0},
{0x74, 0xa2046030},
{0x78, 0xc2002308},
{0x7c, 0xa0043fff},
{0xf0, 0x79},
{0x00, 0x10bfffe3},
{0x04, 0x82006001},
{0x08, 0xc2002300},
{0x0c, 0x82006001},
{0x10, 0xe40022f8},
{0x14, 0x80a48001},
{0x18, 0x0a800022},
{0x1c, 0x82048012},
{0x20, 0x82004012},
{0x24, 0xa7286002},
{0x28, 0xa0102001},
{0x2c, 0xc2002308},
{0x30, 0x80a40001},
{0x34, 0x18800015},
{0x38, 0x832ce002},
{0x3c, 0xa2006004},
{0x40, 0xc2002fec},
{0x44, 0x90100010},
{0x48, 0x80a06000},
{0x4c, 0xa0042001},
{0x50, 0x02800004},
{0x54, 0x92100012},
{0x58, 0x9fc04000},
{0x5c, 0x01000000},
{0x60, 0x03000019},
{0x64, 0x98106080},
{0x68, 0xda04400c},
{0x6c, 0x821060b0},
{0x70, 0xda244001},
{0x74, 0xc024400c},
{0x78, 0xc2002308},
{0x7c, 0x80a40001},
{0xf0, 0x7a},
{0x00, 0x08bffff0},
{0x04, 0xa2046004},
{0x08, 0xc2002300},
{0x0c, 0xa404bfff},
{0x10, 0x82006001},
{0x14, 0x80a48001},
{0x18, 0x1abfffe4},
{0x1c, 0xa604fff4},
{0x20, 0x81c7e008},
{0x24, 0x81e80000},
{0x28, 0x9de3bf98},
{0x2c, 0xc2002548},
{0x30, 0x80886100},
{0x34, 0xac102000},
{0x38, 0x128000cf},
{0x3c, 0xa6102000},
{0x40, 0xc2002568},
{0x44, 0x80a06000},
{0x48, 0x02800004},
{0x4c, 0xa2102001},
{0x50, 0x82007fff},
{0x54, 0xc2202568},
{0x58, 0xc2002300},
{0x5c, 0x80a44001},
{0x60, 0x388000a9},
{0x64, 0xda002530},
{0x68, 0xae10200c},
{0x6c, 0xa4102001},
{0x70, 0xc2002308},
{0x74, 0x80a48001},
{0x78, 0x18800092},
{0x7c, 0x9b2de002},
{0xf0, 0x7b},
{0x00, 0x03000050},
{0x04, 0xaa044001},
{0x08, 0xa8036004},
{0x0c, 0xc2002514},
{0x10, 0x80a06009},
{0x14, 0x1880009b},
{0x18, 0x03000019},
{0x1c, 0x82106080},
{0x20, 0xda050001},
{0x24, 0xc2002474},
{0x28, 0x80a34001},
{0x2c, 0x0680007f},
{0x30, 0x03000040},
{0x34, 0x90100012},
{0x38, 0x7ffff7f1},
{0x3c, 0x92100011},
{0x40, 0x80a22000},
{0x44, 0x02800079},
{0x48, 0x03000040},
{0x4c, 0xc2002ff0},
{0x50, 0x80a06000},
{0x54, 0x2280000a},
{0x58, 0xc2002fe0},
{0x5c, 0x90100012},
{0x60, 0x9fc04000},
{0x64, 0x92100011},
{0x68, 0xc200259c},
{0x6c, 0x80a06000},
{0x70, 0x1280006e},
{0x74, 0x03000040},
{0x78, 0xc2002fe0},
{0x7c, 0x80a06000},
{0xf0, 0x7c},
{0x00, 0x2280000b},
{0x04, 0xc2002ff4},
{0x08, 0x90100012},
{0x0c, 0x92100011},
{0x10, 0x9fc04000},
{0x14, 0xd4002470},
{0x18, 0xc200259c},
{0x1c, 0x80a06000},
{0x20, 0x12800062},
{0x24, 0x03000040},
{0x28, 0xc2002ff4},
{0x2c, 0x80a06000},
{0x30, 0x02800006},
{0x34, 0xa0102000},
{0x38, 0x90100012},
{0x3c, 0x9fc04000},
{0x40, 0x92100011},
{0x44, 0xe000259c},
{0x48, 0x90100012},
{0x4c, 0x92100011},
{0x50, 0x94100010},
{0x54, 0x7ffff814},
{0x58, 0xd6002470},
{0x5c, 0x80a22000},
{0x60, 0x02800052},
{0x64, 0x03000040},
{0x68, 0xc2002fe0},
{0x6c, 0x80a06000},
{0x70, 0x02800007},
{0x74, 0x90100012},
{0x78, 0x92100011},
{0x7c, 0x9fc04000},
{0xf0, 0x7d},
{0x00, 0x94102100},
{0x04, 0x10800004},
{0x08, 0x94100010},
{0x0c, 0xc020259c},
{0x10, 0x94100010},
{0x14, 0x90100012},
{0x18, 0x92100011},
{0x1c, 0x7ffff802},
{0x20, 0x96102100},
{0x24, 0x80a22000},
{0x28, 0x22800011},
{0x2c, 0xc2002514},
{0x30, 0xc200259c},
{0x34, 0x80a06000},
{0x38, 0x3280000d},
{0x3c, 0xc2002514},
{0x40, 0xc2002280},
{0x44, 0xd8002514},
{0x48, 0xc2202568},
{0x4c, 0x9b2ca010},
{0x50, 0x832b2002},
{0x54, 0x9a034011},
{0x58, 0xda2066e0},
{0x5c, 0x98032001},
{0x60, 0xd8202514},
{0x64, 0x10800006},
{0x68, 0xac05a001},
{0x6c, 0x9b286002},
{0x70, 0xea2366e0},
{0x74, 0x82006001},
{0x78, 0xc2202514},
{0x7c, 0xc2002514},
{0xf0, 0x7e},
{0x00, 0x80a0600a},
{0x04, 0x12800029},
{0x08, 0x03000040},
{0x0c, 0x03000019},
{0x10, 0x9e106080},
{0x14, 0xe60026e0},
{0x18, 0x90102001},
{0x1c, 0x932a2002},
{0x20, 0xd40266e0},
{0x24, 0x980aafff},
{0x28, 0x960cefff},
{0x2c, 0x8203000c},
{0x30, 0x9a02c00b},
{0x34, 0x8200400c},
{0x38, 0x9a03400b},
{0x3c, 0x9932a010},
{0x40, 0x980b2fff},
{0x44, 0x9734e010},
{0x48, 0x83286002},
{0x4c, 0x8200400c},
{0x50, 0x960aefff},
{0x54, 0x9b2b6002},
{0x58, 0x83286002},
{0x5c, 0x9a03400b},
{0x60, 0xd800400f},
{0x64, 0x9b2b6002},
{0x68, 0xc203400f},
{0x6c, 0x80a30001},
{0x70, 0x36800004},
{0x74, 0xd42266dc},
{0x78, 0xe62266dc},
{0x7c, 0xa610000a},
{0xf0, 0x7f},
{0x00, 0x90022001},
{0x04, 0xda002514},
{0x08, 0x80a2000d},
{0x0c, 0x2abfffe5},
{0x10, 0x932a2002},
{0x14, 0x832b6002},
{0x18, 0xc02066e0},
{0x1c, 0x82037fff},
{0x20, 0xc2202514},
{0x24, 0x03000040},
{0x28, 0xaa054001},
{0x2c, 0xa404a001},
{0x30, 0xc2002308},
{0x34, 0x80a48001},
{0x38, 0x08bfff75},
{0x3c, 0xa8052004},
{0x40, 0xa2046001},
{0x44, 0xc2002300},
{0x48, 0x80a44001},
{0x4c, 0x08bfff68},
{0x50, 0xae05e00c},
{0x54, 0x80a4e000},
{0x58, 0x2280000b},
{0x5c, 0xda002530},
{0x60, 0xda002514},
{0x64, 0x80a36009},
{0x68, 0x38800007},
{0x6c, 0xda002530},
{0x70, 0x832b6002},
{0x74, 0xe62066e0},
{0x78, 0x82036001},
{0x7c, 0xc2202514},
{0xf0, 0x80},
{0x00, 0xda002530},
{0x04, 0x80a5800d},
{0x08, 0x14800006},
{0x0c, 0x82100016},
{0x10, 0xc2002514},
{0x14, 0x80a34001},
{0x18, 0x28800002},
{0x1c, 0x8210000d},
{0x20, 0x80a5a000},
{0x24, 0x02800004},
{0x28, 0xc2202530},
{0x2c, 0x1080000a},
{0x30, 0xc20021f8},
{0x34, 0x80a06000},
{0x38, 0x22800009},
{0x3c, 0xc2002530},
{0x40, 0xc20025ac},
{0x44, 0x80a06000},
{0x48, 0x22800004},
{0x4c, 0xc0202530},
{0x50, 0x82006001},
{0x54, 0xc22025ac},
{0x58, 0xc2002530},
{0x5c, 0x80a06000},
{0x60, 0x02800005},
{0x64, 0x01000000},
{0x68, 0xc2002548},
{0x6c, 0x82106040},
{0x70, 0xc2202548},
{0x74, 0x81c7e008},
{0x78, 0x81e80000},
{0x7c, 0xd2002208},
{0xf0, 0x81},
{0x00, 0x80a26000},
{0x04, 0x0280001a},
{0x08, 0x01000000},
{0x0c, 0xc2102548},
{0x10, 0x80886001},
{0x14, 0x12800016},
{0x18, 0x01000000},
{0x1c, 0xc2002514},
{0x20, 0x80a06000},
{0x24, 0x12800007},
{0x28, 0xc2002558},
{0x2c, 0x80a06000},
{0x30, 0x0280000f},
{0x34, 0x9a007fff},
{0x38, 0x1080000d},
{0x3c, 0xda202558},
{0x40, 0x15200040},
{0x44, 0x1b3fc200},
{0x48, 0x9812a001},
{0x4c, 0x80a06000},
{0x50, 0x12800006},
{0x54, 0x96136070},
{0x58, 0xd8234000},
{0x5c, 0xc2002298},
{0x60, 0xc222c000},
{0x64, 0xd4234000},
{0x68, 0xd2202558},
{0x6c, 0x81c3e008},
{0x70, 0x01000000},
{0x74, 0x82220009},
{0x78, 0x9a58400a},
{0x7c, 0x833b601f},
{0xf0, 0x82},
{0x00, 0x80a20009},
{0x04, 0x83306019},
{0x08, 0x04800004},
{0x0c, 0x90102000},
{0x10, 0x82034001},
{0x14, 0x91386007},
{0x18, 0x81c3e008},
{0x1c, 0x01000000},
{0x20, 0x9de3bf98},
{0x24, 0xc20022f8},
{0x28, 0x80a07fff},
{0x2c, 0x0280001d},
{0x30, 0xa8102001},
{0x34, 0xa6102003},
{0x38, 0x23000019},
{0x3c, 0xa12ce004},
{0x40, 0x82146088},
{0x44, 0xa4146084},
{0x48, 0xd2040001},
{0x4c, 0xd408228c},
{0x50, 0x7fffffe9},
{0x54, 0xd0040012},
{0x58, 0x9a146080},
{0x5c, 0xd024000d},
{0x60, 0xc2002308},
{0x64, 0xa12ce002},
{0x68, 0xa0040001},
{0x6c, 0xa12c2002},
{0x70, 0xa214607c},
{0x74, 0xd004000d},
{0x78, 0xd2040011},
{0x7c, 0x7fffffde},
{0xf0, 0x83},
{0x00, 0xd408228d},
{0x04, 0xd0240012},
{0x08, 0xc20022f8},
{0x0c, 0xa8052001},
{0x10, 0x82006001},
{0x14, 0x80a50001},
{0x18, 0x08bfffe8},
{0x1c, 0xa604e003},
{0x20, 0xa6102001},
{0x24, 0xc2002308},
{0x28, 0x80a4c001},
{0x2c, 0x1880001c},
{0x30, 0x23000019},
{0x34, 0xa12ce002},
{0x38, 0x821460e0},
{0x3c, 0xa41460b0},
{0x40, 0xd2040001},
{0x44, 0xd408228e},
{0x48, 0x7fffffcb},
{0x4c, 0xd0040012},
{0x50, 0x9a146080},
{0x54, 0xd024000d},
{0x58, 0xc2002300},
{0x5c, 0xa0004001},
{0x60, 0xa0040001},
{0x64, 0xa12c2002},
{0x68, 0xa0040013},
{0x6c, 0xa12c2002},
{0x70, 0xa2146050},
{0x74, 0xd004000d},
{0x78, 0xd2040011},
{0x7c, 0x7fffffbe},
{0xf0, 0x84},
{0x00, 0xd408228f},
{0x04, 0xd0240012},
{0x08, 0xa604e001},
{0x0c, 0xc2002308},
{0x10, 0x80a4c001},
{0x14, 0x08bfffe8},
{0x18, 0x23000019},
{0x1c, 0x81c7e008},
{0x20, 0x81e80000},
{0x24, 0x9de3bf88},
{0x28, 0xc2002fe4},
{0x2c, 0x9fc04000},
{0x30, 0xd0002590},
{0x34, 0xda002550},
{0x38, 0x832b6004},
{0x3c, 0x8220400d},
{0x40, 0xe000259c},
{0x44, 0x82040001},
{0x48, 0x83306004},
{0x4c, 0xc2202550},
{0x50, 0x11000018},
{0x54, 0xc2002fe4},
{0x58, 0x9fc04000},
{0x5c, 0x90122200},
{0x60, 0xc2002308},
{0x64, 0xda002300},
{0x68, 0x9a5b4001},
{0x6c, 0xc200259c},
{0x70, 0x8200400d},
{0x74, 0xc220259c},
{0x78, 0xda00259c},
{0x7c, 0xc2002550},
{0xf0, 0x85},
{0x00, 0x80a34001},
{0x04, 0x28800011},
{0x08, 0xc2002548},
{0x0c, 0xc200259c},
{0x10, 0x80a04010},
{0x14, 0x0880000d},
{0x18, 0xc2002548},
{0x1c, 0x80a42000},
{0x20, 0x0280000a},
{0x24, 0x01000000},
{0x28, 0x82087f7f},
{0x2c, 0xc2202548},
{0x30, 0xc2002668},
{0x34, 0x80a06000},
{0x38, 0x26800006},
{0x3c, 0xc0202668},
{0x40, 0x10800005},
{0x44, 0xc208254e},
{0x48, 0x82106080},
{0x4c, 0xc2202548},
{0x50, 0xc208254e},
{0x54, 0x80a00001},
{0x58, 0x82602000},
{0x5c, 0xa0087ffe},
{0x60, 0xd8002548},
{0x64, 0x83332010},
{0x68, 0x80886001},
{0x6c, 0x02800004},
{0x70, 0xa0042003},
{0x74, 0x1080001d},
{0x78, 0xa0102000},
{0x7c, 0x808b2001},
{0xf0, 0x86},
{0x00, 0x1280003f},
{0x04, 0x03000007},
{0x08, 0xda0026a0},
{0x0c, 0x808b4001},
{0x10, 0x3280003c},
{0x14, 0xc0202538},
{0x18, 0xda002664},
{0x1c, 0xc20021dc},
{0x20, 0x80a34001},
{0x24, 0x2a800008},
{0x28, 0xc2002514},
{0x2c, 0xc200254c},
{0x30, 0x8330600e},
{0x34, 0x80886001},
{0x38, 0x1280000a},
{0x3c, 0x808b2040},
{0x40, 0xc2002514},
{0x44, 0x80a06000},
{0x48, 0x22800009},
{0x4c, 0xc20c2314},
{0x50, 0x808b2080},
{0x54, 0x22800006},
{0x58, 0xc20c2314},
{0x5c, 0x808b2040},
{0x60, 0x32800028},
{0x64, 0xc0202538},
{0x68, 0xc20c2314},
{0x6c, 0x80a06000},
{0x70, 0x22800024},
{0x74, 0xc0202538},
{0x78, 0xc2002538},
{0x7c, 0x82006001},
{0xf0, 0x87},
{0x00, 0xc2202538},
{0x04, 0xda0c2314},
{0x08, 0x80a0400d},
{0x0c, 0x0680001d},
{0x10, 0x01000000},
{0x14, 0xc0202538},
{0x18, 0xc20c234c},
{0x1c, 0xc227bfec},
{0x20, 0xc20c230c},
{0x24, 0xc227bff0},
{0x28, 0xa0102000},
{0x2c, 0xc2002308},
{0x30, 0x80a40001},
{0x34, 0x1a800013},
{0x38, 0x01000000},
{0x3c, 0xc20c2380},
{0x40, 0xc227bfe8},
{0x44, 0xa2102000},
{0x48, 0xc2002300},
{0x4c, 0x80a44001},
{0x50, 0x3a800006},
{0x54, 0xa0042001},
{0x58, 0x7ffff7c4},
{0x5c, 0x9007bfe8},
{0x60, 0x10bffffa},
{0x64, 0xa2046001},
{0x68, 0xc2002308},
{0x6c, 0x80a40001},
{0x70, 0x2abffff4},
{0x74, 0xc20c2380},
{0x78, 0x30800002},
{0x7c, 0xc0202538},
{0xf0, 0x88},
{0x00, 0x81c7e008},
{0x04, 0x81e80000},
{0x08, 0x9de3bf88},
{0x0c, 0xd8082246},
{0x10, 0x80a32000},
{0x14, 0x22800043},
{0x18, 0xc020255c},
{0x1c, 0xda00254c},
{0x20, 0x83336018},
{0x24, 0x80886001},
{0x28, 0x12800007},
{0x2c, 0x03004000},
{0x30, 0xc2002568},
{0x34, 0x80a06000},
{0x38, 0x22800008},
{0x3c, 0xc2002540},
{0x40, 0x03004000},
{0x44, 0x822b4001},
{0x48, 0xc220254c},
{0x4c, 0xc027bfec},
{0x50, 0x1080000e},
{0x54, 0xc027bff0},
{0x58, 0x80a06000},
{0x5c, 0x32800031},
{0x60, 0xc020255c},
{0x64, 0xc200255c},
{0x68, 0x82006001},
{0x6c, 0x80a0400c},
{0x70, 0x0a80002c},
{0x74, 0xc220255c},
{0x78, 0xc2082244},
{0x7c, 0xc227bfec},
{0xf0, 0x89},
{0x00, 0xc2082245},
{0x04, 0xc227bff0},
{0x08, 0xc2002308},
{0x0c, 0xa0006001},
{0x10, 0xc20022fc},
{0x14, 0x80a40001},
{0x18, 0x1880000c},
{0x1c, 0xa2102001},
{0x20, 0xc20c237f},
{0x24, 0xc227bfe8},
{0x28, 0xc20022f8},
{0x2c, 0x80a44001},
{0x30, 0x38bffff8},
{0x34, 0xa0042001},
{0x38, 0x7ffff78c},
{0x3c, 0x9007bfe8},
{0x40, 0x10bffffa},
{0x44, 0xa2046001},
{0x48, 0xa0102001},
{0x4c, 0xc2002308},
{0x50, 0x80a40001},
{0x54, 0x38800013},
{0x58, 0xc020255c},
{0x5c, 0xd80c237f},
{0x60, 0xd827bfe8},
{0x64, 0xc200247c},
{0x68, 0xda002300},
{0x6c, 0x8258400d},
{0x70, 0x98030001},
{0x74, 0xd827bfe8},
{0x78, 0xc2002300},
{0x7c, 0xa2006001},
{0xf0, 0x8a},
{0x00, 0xc20022f8},
{0x04, 0x80a44001},
{0x08, 0x38bffff1},
{0x0c, 0xa0042001},
{0x10, 0x7ffff776},
{0x14, 0x9007bfe8},
{0x18, 0x10bffffa},
{0x1c, 0xa2046001},
{0x20, 0x81c7e008},
{0x24, 0x81e80000},
{0x28, 0x9de3bf80},
{0x2c, 0x03003fc0},
{0x30, 0x82106001},
{0x34, 0xc227bff4},
{0x38, 0xc227bff0},
{0x3c, 0xa4102000},
{0x40, 0xc2002514},
{0x44, 0x80a48001},
{0x48, 0x1a800025},
{0x4c, 0xa2102000},
{0x50, 0x8207bff8},
{0x54, 0x9a044001},
{0x58, 0xa12c6002},
{0x5c, 0xa0040001},
{0x60, 0xd44b7ff9},
{0x64, 0x90100012},
{0x68, 0x7ffff6c5},
{0x6c, 0xd24b7ff8},
{0x70, 0xa2046001},
{0x74, 0x80a46003},
{0x78, 0x04bffff6},
{0x7c, 0xd0243fe8},
{0xf0, 0x8b},
{0x00, 0xc2002fe8},
{0x04, 0x80a06000},
{0x08, 0x02800005},
{0x0c, 0xda07bfe4},
{0x10, 0x9fc04000},
{0x14, 0x9007bfe0},
{0x18, 0xda07bfe4},
{0x1c, 0xc207bfec},
{0x20, 0x83286010},
{0x24, 0x9b2b6018},
{0x28, 0x9a034001},
{0x2c, 0xc207bfe0},
{0x30, 0x83286008},
{0x34, 0x9a034001},
{0x38, 0xc207bfe8},
{0x3c, 0x9a034001},
{0x40, 0x832ca002},
{0x44, 0xda206708},
{0x48, 0xa404a001},
{0x4c, 0xc2002514},
{0x50, 0x80a48001},
{0x54, 0x0abfffdf},
{0x58, 0xa2102000},
{0x5c, 0x81c7e008},
{0x60, 0x81e80000},
{0x64, 0x9de3bf98},
{0x68, 0x90102000},
{0x6c, 0xc2002514},
{0x70, 0x80a20001},
{0x74, 0x1a800077},
{0x78, 0x92102000},
{0x7c, 0xb72a2002},
{0xf0, 0x8c},
{0x00, 0xf20ee708},
{0x04, 0xc20ee709},
{0x08, 0x80a64001},
{0x0c, 0x9e102000},
{0x10, 0x9a102000},
{0x14, 0x14800024},
{0x18, 0x98102000},
{0x1c, 0x82064019},
{0x20, 0x82004019},
{0x24, 0x3b000019},
{0x28, 0xa0176080},
{0x2c, 0xb9286002},
{0x30, 0xc20ee70b},
{0x34, 0xf40ee70a},
{0x38, 0x80a68001},
{0x3c, 0x14800014},
{0x40, 0x8207001a},
{0x44, 0x83286002},
{0x48, 0xb0004010},
{0x4c, 0x94066001},
{0x50, 0xd60a670b},
{0x54, 0xf6060000},
{0x58, 0x8206a001},
{0x5c, 0xb4100001},
{0x60, 0xba5ec001},
{0x64, 0xb0062004},
{0x68, 0x80a6e000},
{0x6c, 0x04800005},
{0x70, 0x825ec00a},
{0x74, 0x9a034001},
{0x78, 0x9803001d},
{0x7c, 0x9e03c01b},
{0xf0, 0x8d},
{0x00, 0x80a6800b},
{0x04, 0x24bffff5},
{0x08, 0xf6060000},
{0x0c, 0xb72a2002},
{0x10, 0xb2066001},
{0x14, 0xc20ee709},
{0x18, 0x80a64001},
{0x1c, 0x04bfffe5},
{0x20, 0xb807200c},
{0x24, 0x832b6006},
{0x28, 0xb92b2006},
{0x2c, 0x9b38601f},
{0x30, 0x81836000},
{0x34, 0x01000000},
{0x38, 0x01000000},
{0x3c, 0x01000000},
{0x40, 0xb678400f},
{0x44, 0xfa0266e0},
{0x48, 0x833f201f},
{0x4c, 0x81806000},
{0x50, 0x01000000},
{0x54, 0x01000000},
{0x58, 0x01000000},
{0x5c, 0xb87f000f},
{0x60, 0xbb37600c},
{0x64, 0x808f6001},
{0x68, 0x9a06ffa0},
{0x6c, 0x02800007},
{0x70, 0x98073fa0},
{0x74, 0xc200237c},
{0x78, 0x80a06000},
{0x7c, 0x22800003},
{0xf0, 0x8e},
{0x00, 0x9a06ff60},
{0x04, 0x98073f60},
{0x08, 0x80a36000},
{0x0c, 0x24800002},
{0x10, 0x9a102001},
{0x14, 0x80a32000},
{0x18, 0x24800002},
{0x1c, 0x98102001},
{0x20, 0xfa0022f8},
{0x24, 0x832f6006},
{0x28, 0x80a34001},
{0x2c, 0x3a800002},
{0x30, 0x9a007fff},
{0x34, 0xc20022fc},
{0x38, 0x83286006},
{0x3c, 0x80a30001},
{0x40, 0x3a800002},
{0x44, 0x98007fff},
{0x48, 0xc20021e0},
{0x4c, 0x80a06000},
{0x50, 0x22800012},
{0x54, 0x9e102000},
{0x58, 0x80a76040},
{0x5c, 0x3880000f},
{0x60, 0x9e102000},
{0x64, 0x81800000},
{0x68, 0x01000000},
{0x6c, 0x01000000},
{0x70, 0x01000000},
{0x74, 0x9ef3c001},
{0x78, 0x12800004},
{0x7c, 0x80a3e00f},
{0xf0, 0x8f},
{0x00, 0x10800006},
{0x04, 0x9e102001},
{0x08, 0x34800004},
{0x0c, 0x9e10200f},
{0x10, 0x10800003},
{0x14, 0x832b6010},
{0x18, 0x832b6010},
{0x1c, 0x8200400c},
{0x20, 0xbb2be01c},
{0x24, 0xba074001},
{0x28, 0xf80266e0},
{0x2c, 0x0300003c},
{0x30, 0xb80f0001},
{0x34, 0xba07401c},
{0x38, 0xfa2266e0},
{0x3c, 0x90022001},
{0x40, 0xc2002514},
{0x44, 0x80a20001},
{0x48, 0x0abfff8d},
{0x4c, 0x92026004},
{0x50, 0x7ffff4cf},
{0x54, 0x91e8205a},
{0x58, 0x01000000},
{0x5c, 0x9de3bf98},
{0x60, 0xd8002548},
{0x64, 0x808b2001},
{0x68, 0x12800081},
{0x6c, 0x01000000},
{0x70, 0xc208254d},
{0x74, 0x80a06000},
{0x78, 0x1280007d},
{0x7c, 0x01000000},
{0xf0, 0x90},
{0x00, 0xc208254e},
{0x04, 0x80a06000},
{0x08, 0x02800079},
{0x0c, 0x01000000},
{0x10, 0xc2002554},
{0x14, 0x825860fa},
{0x18, 0xda002500},
{0x1c, 0x80a34001},
{0x20, 0x0a800073},
{0x24, 0x01000000},
{0x28, 0xd6002668},
{0x2c, 0x80a2e000},
{0x30, 0x1480001c},
{0x34, 0x8202ffff},
{0x38, 0xc2002514},
{0x3c, 0x80a06001},
{0x40, 0x3280006b},
{0x44, 0xc0202668},
{0x48, 0xc20026e0},
{0x4c, 0x80a06000},
{0x50, 0x12800004},
{0x54, 0x808b2040},
{0x58, 0x10800065},
{0x5c, 0xc0202668},
{0x60, 0x32800006},
{0x64, 0xd800239c},
{0x68, 0x80a2e000},
{0x6c, 0x0680000d},
{0x70, 0x8202e001},
{0x74, 0xd800239c},
{0x78, 0x0300003f},
{0x7c, 0x9b332010},
{0xf0, 0x91},
{0x00, 0x821063ff},
{0x04, 0x980b0001},
{0x08, 0x9a38000d},
{0x0c, 0x9a23400c},
{0x10, 0x80a2c00d},
{0x14, 0x06800005},
{0x18, 0x03296956},
{0x1c, 0x8202ffff},
{0x20, 0x10800053},
{0x24, 0xc2202668},
{0x28, 0x9a10625a},
{0x2c, 0xc200250c},
{0x30, 0x80a0400d},
{0x34, 0x02800004},
{0x38, 0xa0102000},
{0x3c, 0xda20250c},
{0x40, 0xc0202664},
{0x44, 0x832c2002},
{0x48, 0x92006620},
{0x4c, 0xc2006620},
{0x50, 0x901026e0},
{0x54, 0x80a06000},
{0x58, 0x0280000d},
{0x5c, 0xa0042001},
{0x60, 0x7ffff517},
{0x64, 0x01000000},
{0x68, 0xc2002300},
{0x6c, 0xda002308},
{0x70, 0x82584001},
{0x74, 0x9a5b400d},
{0x78, 0x8200400d},
{0x7c, 0x83286006},
{0xf0, 0x92},
{0x00, 0x80a20001},
{0x04, 0x0a80003a},
{0x08, 0x01000000},
{0x0c, 0x80a4200f},
{0x10, 0x08bfffee},
{0x14, 0x832c2002},
{0x18, 0x030041eb},
{0x1c, 0xc2202668},
{0x20, 0xa010200f},
{0x24, 0x9b2c2002},
{0x28, 0xc203661c},
{0x2c, 0xa0843fff},
{0x30, 0x12bffffd},
{0x34, 0xc2236620},
{0x38, 0xda002664},
{0x3c, 0xc20026e0},
{0x40, 0xc2202620},
{0x44, 0x80a3600f},
{0x48, 0x14800003},
{0x4c, 0x9010200f},
{0x50, 0x9010000d},
{0x54, 0x03000017},
{0x58, 0x9e106240},
{0x5c, 0x82006400},
{0x60, 0xa2106200},
{0x64, 0x0300003f},
{0x68, 0xa61063ff},
{0x6c, 0x92022001},
{0x70, 0xa0102000},
{0x74, 0xa410000f},
{0x78, 0x972c2002},
{0x7c, 0x8203c00b},
{0xf0, 0x93},
{0x00, 0xda106002},
{0x04, 0x9804400b},
{0x08, 0xd4132002},
{0x0c, 0xc213c00b},
{0x10, 0xd814400b},
{0x14, 0x82584008},
{0x18, 0x9a5b4008},
{0x1c, 0x8200400c},
{0x20, 0x9a03400a},
{0x24, 0x81800000},
{0x28, 0x01000000},
{0x2c, 0x01000000},
{0x30, 0x01000000},
{0x34, 0x82704009},
{0x38, 0x81800000},
{0x3c, 0x01000000},
{0x40, 0x01000000},
{0x44, 0x01000000},
{0x48, 0x9a734009},
{0x4c, 0x83286010},
{0x50, 0x9a0b4013},
{0x54, 0x8200400d},
{0x58, 0xa0042001},
{0x5c, 0x80a4204f},
{0x60, 0x08bfffe6},
{0x64, 0xc222c012},
{0x68, 0xd2202664},
{0x6c, 0x81c7e008},
{0x70, 0x81e80000},
{0x74, 0x9de3bf98},
{0x78, 0xa2102000},
{0x7c, 0xc2002514},
{0xf0, 0x94},
{0x00, 0x80a44001},
{0x04, 0xa0102000},
{0x08, 0x1a800012},
{0x0c, 0x832c2002},
{0x10, 0x920066e0},
{0x14, 0xc20066e0},
{0x18, 0x80a06000},
{0x1c, 0x02800009},
{0x20, 0x90100018},
{0x24, 0x7ffff4c6},
{0x28, 0x01000000},
{0x2c, 0x82102001},
{0x30, 0x80a20019},
{0x34, 0x1a800003},
{0x38, 0x83284010},
{0x3c, 0xa2144001},
{0x40, 0xa0042001},
{0x44, 0xc2002514},
{0x48, 0x10bffff0},
{0x4c, 0x80a40001},
{0x50, 0x81c7e008},
{0x54, 0x91e80011},
{0x58, 0x9de3bf90},
{0x5c, 0x03003fc0},
{0x60, 0x82106001},
{0x64, 0xc227bff0},
{0x68, 0xc027bff4},
{0x6c, 0xa0102000},
{0x70, 0x8207bff8},
{0x74, 0x82040001},
{0x78, 0xd2487ff9},
{0x7c, 0xd0487ff8},
{0xf0, 0x95},
{0x00, 0x90060008},
{0x04, 0x92064009},
{0x08, 0x94102000},
{0x0c, 0x7ffff506},
{0x10, 0x9610001a},
{0x14, 0x80a22000},
{0x18, 0x02800004},
{0x1c, 0xa0042001},
{0x20, 0x10800006},
{0x24, 0xb0102001},
{0x28, 0x80a42004},
{0x2c, 0x04bffff2},
{0x30, 0x8207bff8},
{0x34, 0xb0102000},
{0x38, 0x81c7e008},
{0x3c, 0x81e80000},
{0x40, 0x9de3bf90},
{0x44, 0x03003fc0},
{0x48, 0x82106001},
{0x4c, 0xc227bff0},
{0x50, 0xc027bff4},
{0x54, 0xda002500},
{0x58, 0xc20022d0},
{0x5c, 0x80a34001},
{0x60, 0xb8102000},
{0x64, 0xba102000},
{0x68, 0x18800006},
{0x6c, 0xae102000},
{0x70, 0xc2002548},
{0x74, 0x80886001},
{0x78, 0x22800004},
{0x7c, 0xc200254c},
{0xf0, 0x96},
{0x00, 0xba102001},
{0x04, 0xc200254c},
{0x08, 0x80886200},
{0x0c, 0x32800010},
{0x10, 0xc20026a0},
{0x14, 0x03296956},
{0x18, 0xda00250c},
{0x1c, 0x8210625a},
{0x20, 0x80a34001},
{0x24, 0x12800006},
{0x28, 0xc20023c8},
{0x2c, 0x80886800},
{0x30, 0x32800007},
{0x34, 0xc20026a0},
{0x38, 0xc20023c8},
{0x3c, 0x80886400},
{0x40, 0x22800014},
{0x44, 0xec0022ac},
{0x48, 0xc20026a0},
{0x4c, 0x80886200},
{0x50, 0x1280000a},
{0x54, 0xb8102001},
{0x58, 0x13000017},
{0x5c, 0xc2002fd0},
{0x60, 0x92126240},
{0x64, 0x9fc04000},
{0x68, 0xd0002590},
{0x6c, 0xc20026a0},
{0x70, 0x82106200},
{0x74, 0xc22026a0},
{0x78, 0x10800006},
{0x7c, 0xec0023a0},
{0xf0, 0x97},
{0x00, 0x03000080},
{0x04, 0x82134001},
{0x08, 0x1080007d},
{0x0c, 0xc220254c},
{0x10, 0x7ffff3df},
{0x14, 0x901020aa},
{0x18, 0xaa102000},
{0x1c, 0xa12d6003},
{0x20, 0xc2042730},
{0x24, 0x80a06000},
{0x28, 0x22800072},
{0x2c, 0xaa056001},
{0x30, 0x80a56000},
{0x34, 0x12800008},
{0x38, 0x80a76000},
{0x3c, 0xc2002540},
{0x40, 0x80a06000},
{0x44, 0x1280000c},
{0x48, 0x29200000},
{0x4c, 0x1080000a},
{0x50, 0xa8102000},
{0x54, 0x02800005},
{0x58, 0x90042730},
{0x5c, 0xc0242734},
{0x60, 0x10800063},
{0x64, 0xc0242730},
{0x68, 0x7fffff83},
{0x6c, 0x92100016},
{0x70, 0xa8100008},
{0x74, 0x80a52000},
{0x78, 0x1280000b},
{0x7c, 0xae15c014},
{0xf0, 0x98},
{0x00, 0xc2142734},
{0x04, 0x80a06000},
{0x08, 0x22800058},
{0x0c, 0xc0242734},
{0x10, 0xc2042734},
{0x14, 0x1b3fffc0},
{0x18, 0x8200400d},
{0x1c, 0x10800054},
{0x20, 0xc2242734},
{0x24, 0xc2142736},
{0x28, 0x80a06000},
{0x2c, 0x0280000a},
{0x30, 0x80a56000},
{0x34, 0xc2042734},
{0x38, 0x82007fff},
{0x3c, 0xc2242734},
{0x40, 0xc2142736},
{0x44, 0x80a06000},
{0x48, 0x3280004a},
{0x4c, 0xaa056001},
{0x50, 0x80a56000},
{0x54, 0x1280000c},
{0x58, 0x1b004000},
{0x5c, 0xc200254c},
{0x60, 0x8210400d},
{0x64, 0x10800042},
{0x68, 0xc220254c},
{0x6c, 0xc200254c},
{0x70, 0x1b000080},
{0x74, 0x8210400d},
{0x78, 0xc220254c},
{0x7c, 0x10800037},
{0xf0, 0x99},
{0x00, 0xc0202570},
{0x04, 0xda00254c},
{0x08, 0x83336019},
{0x0c, 0x80886001},
{0x10, 0x12bfffbc},
{0x14, 0x80a72000},
{0x18, 0x02bfffba},
{0x1c, 0xa2102000},
{0x20, 0xc2002514},
{0x24, 0x80a44001},
{0x28, 0x1a80002c},
{0x2c, 0x83350011},
{0x30, 0x80886001},
{0x34, 0x02800027},
{0x38, 0x9b2c6002},
{0x3c, 0xc20366e0},
{0x40, 0x9b306016},
{0x44, 0x82086fff},
{0x48, 0x83386006},
{0x4c, 0x9a0b603f},
{0x50, 0xa4006001},
{0x54, 0xa6036001},
{0x58, 0x92100013},
{0x5c, 0xd410246e},
{0x60, 0x7fffff5e},
{0x64, 0x90100012},
{0x68, 0x80a22000},
{0x6c, 0x12800011},
{0x70, 0x82102001},
{0x74, 0xd410246c},
{0x78, 0x80a2a000},
{0x7c, 0x22800011},
{0xf0, 0x9a},
{0x00, 0xc2002570},
{0x04, 0xc2002548},
{0x08, 0x90100012},
{0x0c, 0x80886080},
{0x10, 0x0280000b},
{0x14, 0x92100013},
{0x18, 0x7fffff50},
{0x1c, 0x01000000},
{0x20, 0x80a22000},
{0x24, 0x22800007},
{0x28, 0xc2002570},
{0x2c, 0x82102001},
{0x30, 0x83284011},
{0x34, 0x10800007},
{0x38, 0xa82d0001},
{0x3c, 0xc2002570},
{0x40, 0x82006001},
{0x44, 0x80a06004},
{0x48, 0x18bfffc9},
{0x4c, 0xc2202570},
{0x50, 0x10bfffd4},
{0x54, 0xa2046001},
{0x58, 0x80a52000},
{0x5c, 0x32800005},
{0x60, 0xaa056001},
{0x64, 0xc0242734},
{0x68, 0xc0242730},
{0x6c, 0xaa056001},
{0x70, 0x80a56013},
{0x74, 0x04bfff8b},
{0x78, 0xa12d6003},
{0x7c, 0x80a5e000},
{0xf0, 0x9b},
{0x00, 0x22800002},
{0x04, 0xc0202570},
{0x08, 0xc2002540},
{0x0c, 0x80a06000},
{0x10, 0x0280000a},
{0x14, 0x80a76000},
{0x18, 0xc2002730},
{0x1c, 0x80a06000},
{0x20, 0x12800006},
{0x24, 0x80a76000},
{0x28, 0x03000004},
{0x2c, 0xc2202730},
{0x30, 0xc2002248},
{0x34, 0xc2202734},
{0x38, 0x12800027},
{0x3c, 0xaa102000},
{0x40, 0xc2002514},
{0x44, 0x80a54001},
{0x48, 0x1a800023},
{0x4c, 0x96102001},
{0x50, 0x992d6002},
{0x54, 0xc20326e0},
{0x58, 0x8330600c},
{0x5c, 0x80886001},
{0x60, 0x32800019},
{0x64, 0xaa056001},
{0x68, 0x832ac015},
{0x6c, 0x808dc001},
{0x70, 0x32800015},
{0x74, 0xaa056001},
{0x78, 0xa2102001},
{0x7c, 0x9b2c6003},
{0xf0, 0x9c},
{0x00, 0xc2036730},
{0x04, 0x80a06000},
{0x08, 0x1280000b},
{0x0c, 0xa2046001},
{0x10, 0xc20326e0},
{0x14, 0x80a72000},
{0x18, 0x02800004},
{0x1c, 0xc2236730},
{0x20, 0x10800003},
{0x24, 0xc200239c},
{0x28, 0xc2002378},
{0x2c, 0x10800005},
{0x30, 0xc2236734},
{0x34, 0x80a46013},
{0x38, 0x04bffff2},
{0x3c, 0x9b2c6003},
{0x40, 0xaa056001},
{0x44, 0xc2002514},
{0x48, 0x80a54001},
{0x4c, 0x0abfffe2},
{0x50, 0x992d6002},
{0x54, 0x81c7e008},
{0x58, 0x81e80000},
{0x5c, 0x9de3bf98},
{0x60, 0xc2002510},
{0x64, 0x80a06000},
{0x68, 0x2280000b},
{0x6c, 0xc208254d},
{0x70, 0x82007fff},
{0x74, 0x80a06000},
{0x78, 0x12800006},
{0x7c, 0xc2202510},
{0xf0, 0x9d},
{0x00, 0xc200254c},
{0x04, 0x1b002000},
{0x08, 0x8210400d},
{0x0c, 0xc220254c},
{0x10, 0xc208254d},
{0x14, 0x80a06000},
{0x18, 0x1280000d},
{0x1c, 0x033fc180},
{0x20, 0x033fc200},
{0x24, 0x82106030},
{0x28, 0xda004000},
{0x2c, 0xc200257c},
{0x30, 0x80a34001},
{0x34, 0x02800021},
{0x38, 0x01000000},
{0x3c, 0xc210223e},
{0x40, 0x80a06000},
{0x44, 0x0280001d},
{0x48, 0x033fc180},
{0x4c, 0xc0204000},
{0x50, 0xa0102002},
{0x54, 0x11000099},
{0x58, 0x7fffefaf},
{0x5c, 0x9012233c},
{0x60, 0x7ffff544},
{0x64, 0x90102002},
{0x68, 0xa0843fff},
{0x6c, 0x3cbffffb},
{0x70, 0x11000099},
{0x74, 0xda00254c},
{0x78, 0x83336010},
{0x7c, 0x80886001},
{0xf0, 0x9e},
{0x00, 0x32800002},
{0x04, 0xc020250c},
{0x08, 0x83336017},
{0x0c, 0x80886001},
{0x10, 0x32800005},
{0x14, 0xc2002510},
{0x18, 0xc2002188},
{0x1c, 0xc2202510},
{0x20, 0xc2002510},
{0x24, 0xc220266c},
{0x28, 0x7ffff1cc},
{0x2c, 0x90102015},
{0x30, 0x82102001},
{0x34, 0xc2202584},
{0x38, 0x81c7e008},
{0x3c, 0x81e80000},
{0x40, 0xc2002588},
{0x44, 0x80a06000},
{0x48, 0x32800006},
{0x4c, 0xc200258c},
{0x50, 0xc2002554},
{0x54, 0xc2202588},
{0x58, 0xc0202594},
{0x5c, 0xc200258c},
{0x60, 0x80a06000},
{0x64, 0x12800005},
{0x68, 0x01000000},
{0x6c, 0xc2002554},
{0x70, 0xc220258c},
{0x74, 0xc0202598},
{0x78, 0x81c3e008},
{0x7c, 0x01000000},
{0xf0, 0x9f},
{0x00, 0x98102000},
{0x04, 0xc2002514},
{0x08, 0x80a30001},
{0x0c, 0x1a80000b},
{0x10, 0x033fc180},
{0x14, 0x96106004},
{0x18, 0x832b2002},
{0x1c, 0xda0066e0},
{0x20, 0xda20400b},
{0x24, 0x98032001},
{0x28, 0xc2002514},
{0x2c, 0x80a30001},
{0x30, 0x0abffffb},
{0x34, 0x832b2002},
{0x38, 0xda00254c},
{0x3c, 0x808b6001},
{0x40, 0x32800008},
{0x44, 0xc208254e},
{0x48, 0xc2002514},
{0x4c, 0x9a136001},
{0x50, 0x82106100},
{0x54, 0xda20254c},
{0x58, 0xc2202514},
{0x5c, 0xc208254e},
{0x60, 0x80a06000},
{0x64, 0x3280000b},
{0x68, 0xc2082517},
{0x6c, 0xc20023c8},
{0x70, 0x83306016},
{0x74, 0x80886001},
{0x78, 0x22800006},
{0x7c, 0xc2082517},
{0xf0, 0xa0},
{0x00, 0xc2002514},
{0x04, 0x82106200},
{0x08, 0xc2202514},
{0x0c, 0xc2082517},
{0x10, 0x80a06000},
{0x14, 0x32800007},
{0x18, 0xda002500},
{0x1c, 0xc2002560},
{0x20, 0x80a06000},
{0x24, 0x22800008},
{0x28, 0xc2082517},
{0x2c, 0xda002500},
{0x30, 0xc2002514},
{0x34, 0x9b2b6010},
{0x38, 0x8210400d},
{0x3c, 0xc2202514},
{0x40, 0xc2082517},
{0x44, 0x80a06000},
{0x48, 0x22800012},
{0x4c, 0xda002514},
{0x50, 0xc2002548},
{0x54, 0x80886800},
{0x58, 0x22800006},
{0x5c, 0xc20023c8},
{0x60, 0xc2002514},
{0x64, 0x82106400},
{0x68, 0xc2202514},
{0x6c, 0xc20023c8},
{0x70, 0x80a06000},
{0x74, 0x36800007},
{0x78, 0xda002514},
{0x7c, 0xc2002514},
{0xf0, 0xa1},
{0x00, 0x1b000004},
{0x04, 0x8210400d},
{0x08, 0xc2202514},
{0x0c, 0xda002514},
{0x10, 0x033fc180},
{0x14, 0x81c3e008},
{0x18, 0xda204000},
{0x1c, 0x9de3bf98},
{0x20, 0xc2102516},
{0x24, 0x80a06000},
{0x28, 0x02800006},
{0x2c, 0x90102001},
{0x30, 0xc2002548},
{0x34, 0x80886004},
{0x38, 0x0280000a},
{0x3c, 0x82102005},
{0x40, 0xc2002548},
{0x44, 0x9b306003},
{0x48, 0x83306002},
{0x4c, 0x82086001},
{0x50, 0x9a0b6001},
{0x54, 0x80a0400d},
{0x58, 0x02800004},
{0x5c, 0x82102005},
{0x60, 0x10800008},
{0x64, 0xc2202560},
{0x68, 0xc2002560},
{0x6c, 0x9a007fff},
{0x70, 0x80a06000},
{0x74, 0x02800005},
{0x78, 0x90102002},
{0x7c, 0xda202560},
{0xf0, 0xa2},
{0x00, 0x7ffff4bc},
{0x04, 0x01000000},
{0x08, 0xc2002548},
{0x0c, 0x9a004001},
{0x10, 0x9a0b6008},
{0x14, 0x82087ff7},
{0x18, 0x8210400d},
{0x1c, 0xc2202548},
{0x20, 0x81c7e008},
{0x24, 0x81e80000},
{0x28, 0x00000000},
{0x2c, 0x00000000},
{0x30, 0x00000000},
{0x34, 0x00000000},
{0x38, 0x00000000},
{0x3c, 0x00000000},
{0x40, 0x00000000},
{0x44, 0x00000000},
{0x48, 0x00000000},
{0x4c, 0x00000000},
{0x50, 0x00000000},
{0x54, 0x00000000},
{0x58, 0x00000000},
{0x5c, 0x00000000},
{0x60, 0x00000000},
{0x64, 0x00000000},
{0x68, 0x00000000},
{0x6c, 0x00000000},
{0x70, 0x00000000},
{0x74, 0x00000000},
{0x78, 0x00000000},
{0x7c, 0x00000000},
{0xf0, 0xa3},
{0x00, 0x00001688},
{0x04, 0xa5010500},
{0x08, 0xa5000000},
{0x0c, 0x00000000},
{0x10, 0x4c494348},
{0x14, 0x49444449},
{0x18, 0x88ecbdae},
{0x1c, 0x39cf8648},
{0x20, 0xa980c96f},
{0x24, 0xbe719243},
{0x28, 0xc641c654},
{0x2c, 0xcc5380cb},
{0x30, 0x80d1cce5},
{0x34, 0xa898c9e5},
{0x38, 0xc400c643},
{0x3c, 0xbd130000},
{0x40, 0x00000000},
{0x44, 0x00000000},
{0x48, 0x00000000},
{0x4c, 0x00000000},
{0x50, 0x00000000},
{0x54, 0x00000000},
{0x58, 0x00000000},
{0x5c, 0x00000000},
{0x60, 0x00000000},
{0x64, 0x00000000},
{0x68, 0x4a756e20},
{0x6c, 0x32362032},
{0x70, 0x30313400},
{0x74, 0x00000000},
{0x78, 0x31343a35},
{0x7c, 0x313a3337},


};

#endif



