/*************************************************************************/ /*!
@Title          Hardware definition file rgx_cr_defs_km.h
@Copyright      Copyright (c) Imagination Technologies Ltd. All Rights Reserved
@License        Dual MIT/GPLv2

The contents of this file are subject to the MIT license as set out below.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

Alternatively, the contents of this file may be used under the terms of
the GNU General Public License Version 2 ("GPL") in which case the provisions
of GPL are applicable instead of those above.

If you wish to allow use of your version of this file only under the terms of
GPL, and not to allow others to use your version of this file under the terms
of the MIT license, indicate your decision by deleting the provisions above
and replace them with the notice and other provisions required by GPL as set
out in the file called "GPL-COPYING" included in this distribution. If you do
not delete the provisions above, a recipient may use your version of this file
under the terms of either the MIT license or GPL.

This License is also included in this distribution in the file called
"MIT-COPYING".

EXCEPT AS OTHERWISE STATED IN A NEGOTIATED AGREEMENT: (A) THE SOFTWARE IS
PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT; AND (B) IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/ /**************************************************************************/

/*               ****   Autogenerated C -- do not edit    ****               */

/*
 * Generated by regconv version MAIN@2782796
 *   from files:
 */

#if !defined(__IMG_EXPLICIT_INCLUDE_HWDEFS)
#error This file may only be included if explicitly defined
#endif

#ifndef _RGX_CR_DEFS_KM_H_
#define _RGX_CR_DEFS_KM_H_

#include "img_types.h"

#if defined(RGX_FEATURE_S7_TOP_INFRASTRUCTURE)
/*

	Core Module Clock Control Modes.


	Allows individual domain clocks to be forced off, forced on or operate under automatic pipeline activity based clock gating. This register is generally controlled by the GPU firmware and should be set to AUTO. Clock gating reduces the power consumed by the device.

*/
/*
    Register RGX_CR_CLK_CTRL
*/
#define RGX_CR_CLK_CTRL                                   (0x0000U)
#define RGX_CR_CLK_CTRL_MASKFULL                          (IMG_UINT64_C(0xFFFFC3003F3F3F0F))
#if defined(RGX_FEATURE_CLUSTER_GROUPING)
/* BIF_TEXAS default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_BIF_TEXAS_SHIFT                   (62U)
#define RGX_CR_CLK_CTRL_BIF_TEXAS_CLRMSK                  (IMG_UINT64_C(0X3FFFFFFFFFFFFFFF))
#define RGX_CR_CLK_CTRL_BIF_TEXAS_OFF                     (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_BIF_TEXAS_ON                      (IMG_UINT64_C(0x4000000000000000))
#define RGX_CR_CLK_CTRL_BIF_TEXAS_AUTO                    (IMG_UINT64_C(0x8000000000000000))
/* IPP default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_IPP_SHIFT                         (60U)
#define RGX_CR_CLK_CTRL_IPP_CLRMSK                        (IMG_UINT64_C(0XCFFFFFFFFFFFFFFF))
#define RGX_CR_CLK_CTRL_IPP_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_IPP_ON                            (IMG_UINT64_C(0x1000000000000000))
#define RGX_CR_CLK_CTRL_IPP_AUTO                          (IMG_UINT64_C(0x2000000000000000))
#endif /* RGX_FEATURE_CLUSTER_GROUPING */

/* FBC default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_FBC_SHIFT                         (58U)
#define RGX_CR_CLK_CTRL_FBC_CLRMSK                        (IMG_UINT64_C(0XF3FFFFFFFFFFFFFF))
#define RGX_CR_CLK_CTRL_FBC_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_FBC_ON                            (IMG_UINT64_C(0x0400000000000000))
#define RGX_CR_CLK_CTRL_FBC_AUTO                          (IMG_UINT64_C(0x0800000000000000))
/* FBDC default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_FBDC_SHIFT                        (56U)
#define RGX_CR_CLK_CTRL_FBDC_CLRMSK                       (IMG_UINT64_C(0XFCFFFFFFFFFFFFFF))
#define RGX_CR_CLK_CTRL_FBDC_OFF                          (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_FBDC_ON                           (IMG_UINT64_C(0x0100000000000000))
#define RGX_CR_CLK_CTRL_FBDC_AUTO                         (IMG_UINT64_C(0x0200000000000000))
/* FB_TLCACHE default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_FB_TLCACHE_SHIFT                  (54U)
#define RGX_CR_CLK_CTRL_FB_TLCACHE_CLRMSK                 (IMG_UINT64_C(0XFF3FFFFFFFFFFFFF))
#define RGX_CR_CLK_CTRL_FB_TLCACHE_OFF                    (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_FB_TLCACHE_ON                     (IMG_UINT64_C(0x0040000000000000))
#define RGX_CR_CLK_CTRL_FB_TLCACHE_AUTO                   (IMG_UINT64_C(0x0080000000000000))
/* USCS default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_USCS_SHIFT                        (52U)
#define RGX_CR_CLK_CTRL_USCS_CLRMSK                       (IMG_UINT64_C(0XFFCFFFFFFFFFFFFF))
#define RGX_CR_CLK_CTRL_USCS_OFF                          (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_USCS_ON                           (IMG_UINT64_C(0x0010000000000000))
#define RGX_CR_CLK_CTRL_USCS_AUTO                         (IMG_UINT64_C(0x0020000000000000))
/* PBE default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_PBE_SHIFT                         (50U)
#define RGX_CR_CLK_CTRL_PBE_CLRMSK                        (IMG_UINT64_C(0XFFF3FFFFFFFFFFFF))
#define RGX_CR_CLK_CTRL_PBE_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_PBE_ON                            (IMG_UINT64_C(0x0004000000000000))
#define RGX_CR_CLK_CTRL_PBE_AUTO                          (IMG_UINT64_C(0x0008000000000000))
/* MCU_l1 default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_MCU_L1_SHIFT                      (48U)
#define RGX_CR_CLK_CTRL_MCU_L1_CLRMSK                     (IMG_UINT64_C(0XFFFCFFFFFFFFFFFF))
#define RGX_CR_CLK_CTRL_MCU_L1_OFF                        (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_MCU_L1_ON                         (IMG_UINT64_C(0x0001000000000000))
#define RGX_CR_CLK_CTRL_MCU_L1_AUTO                       (IMG_UINT64_C(0x0002000000000000))
/* CDM default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_CDM_SHIFT                         (46U)
#define RGX_CR_CLK_CTRL_CDM_CLRMSK                        (IMG_UINT64_C(0XFFFF3FFFFFFFFFFF))
#define RGX_CR_CLK_CTRL_CDM_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_CDM_ON                            (IMG_UINT64_C(0x0000400000000000))
#define RGX_CR_CLK_CTRL_CDM_AUTO                          (IMG_UINT64_C(0x0000800000000000))
/* BIF default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_BIF_SHIFT                         (40U)
#define RGX_CR_CLK_CTRL_BIF_CLRMSK                        (IMG_UINT64_C(0XFFFFFCFFFFFFFFFF))
#define RGX_CR_CLK_CTRL_BIF_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_BIF_ON                            (IMG_UINT64_C(0x0000010000000000))
#define RGX_CR_CLK_CTRL_BIF_AUTO                          (IMG_UINT64_C(0x0000020000000000))
/* TPU_MCU_DEMUX default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_TPU_MCU_DEMUX_SHIFT               (28U)
#define RGX_CR_CLK_CTRL_TPU_MCU_DEMUX_CLRMSK              (IMG_UINT64_C(0XFFFFFFFFCFFFFFFF))
#define RGX_CR_CLK_CTRL_TPU_MCU_DEMUX_OFF                 (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_TPU_MCU_DEMUX_ON                  (IMG_UINT64_C(0x0000000010000000))
#define RGX_CR_CLK_CTRL_TPU_MCU_DEMUX_AUTO                (IMG_UINT64_C(0x0000000020000000))
/* MCU_L0 default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_MCU_L0_SHIFT                      (26U)
#define RGX_CR_CLK_CTRL_MCU_L0_CLRMSK                     (IMG_UINT64_C(0XFFFFFFFFF3FFFFFF))
#define RGX_CR_CLK_CTRL_MCU_L0_OFF                        (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_MCU_L0_ON                         (IMG_UINT64_C(0x0000000004000000))
#define RGX_CR_CLK_CTRL_MCU_L0_AUTO                       (IMG_UINT64_C(0x0000000008000000))
/* TPU default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_TPU_SHIFT                         (24U)
#define RGX_CR_CLK_CTRL_TPU_CLRMSK                        (IMG_UINT64_C(0XFFFFFFFFFCFFFFFF))
#define RGX_CR_CLK_CTRL_TPU_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_TPU_ON                            (IMG_UINT64_C(0x0000000001000000))
#define RGX_CR_CLK_CTRL_TPU_AUTO                          (IMG_UINT64_C(0x0000000002000000))
/* USC default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_USC_SHIFT                         (20U)
#define RGX_CR_CLK_CTRL_USC_CLRMSK                        (IMG_UINT64_C(0XFFFFFFFFFFCFFFFF))
#define RGX_CR_CLK_CTRL_USC_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_USC_ON                            (IMG_UINT64_C(0x0000000000100000))
#define RGX_CR_CLK_CTRL_USC_AUTO                          (IMG_UINT64_C(0x0000000000200000))
/* TLA default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_TLA_SHIFT                         (18U)
#define RGX_CR_CLK_CTRL_TLA_CLRMSK                        (IMG_UINT64_C(0XFFFFFFFFFFF3FFFF))
#define RGX_CR_CLK_CTRL_TLA_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_TLA_ON                            (IMG_UINT64_C(0x0000000000040000))
#define RGX_CR_CLK_CTRL_TLA_AUTO                          (IMG_UINT64_C(0x0000000000080000))
/* SLC default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_SLC_SHIFT                         (16U)
#define RGX_CR_CLK_CTRL_SLC_CLRMSK                        (IMG_UINT64_C(0XFFFFFFFFFFFCFFFF))
#define RGX_CR_CLK_CTRL_SLC_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_SLC_ON                            (IMG_UINT64_C(0x0000000000010000))
#define RGX_CR_CLK_CTRL_SLC_AUTO                          (IMG_UINT64_C(0x0000000000020000))
/* PDS default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_PDS_SHIFT                         (12U)
#define RGX_CR_CLK_CTRL_PDS_CLRMSK                        (IMG_UINT64_C(0XFFFFFFFFFFFFCFFF))
#define RGX_CR_CLK_CTRL_PDS_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_PDS_ON                            (IMG_UINT64_C(0x0000000000001000))
#define RGX_CR_CLK_CTRL_PDS_AUTO                          (IMG_UINT64_C(0x0000000000002000))
/* VDM default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_VDM_SHIFT                         (10U)
#define RGX_CR_CLK_CTRL_VDM_CLRMSK                        (IMG_UINT64_C(0XFFFFFFFFFFFFF3FF))
#define RGX_CR_CLK_CTRL_VDM_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_VDM_ON                            (IMG_UINT64_C(0x0000000000000400))
#define RGX_CR_CLK_CTRL_VDM_AUTO                          (IMG_UINT64_C(0x0000000000000800))
/* PM default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_PM_SHIFT                          (8U)
#define RGX_CR_CLK_CTRL_PM_CLRMSK                         (IMG_UINT64_C(0XFFFFFFFFFFFFFCFF))
#define RGX_CR_CLK_CTRL_PM_OFF                            (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_PM_ON                             (IMG_UINT64_C(0x0000000000000100))
#define RGX_CR_CLK_CTRL_PM_AUTO                           (IMG_UINT64_C(0x0000000000000200))
/* TSP default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_TSP_SHIFT                         (2U)
#define RGX_CR_CLK_CTRL_TSP_CLRMSK                        (IMG_UINT64_C(0XFFFFFFFFFFFFFFF3))
#define RGX_CR_CLK_CTRL_TSP_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_TSP_ON                            (IMG_UINT64_C(0x0000000000000004))
#define RGX_CR_CLK_CTRL_TSP_AUTO                          (IMG_UINT64_C(0x0000000000000008))
/* ISP default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_ISP_SHIFT                         (0U)
#define RGX_CR_CLK_CTRL_ISP_CLRMSK                        (IMG_UINT64_C(0XFFFFFFFFFFFFFFFC))
#define RGX_CR_CLK_CTRL_ISP_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_ISP_ON                            (IMG_UINT64_C(0x0000000000000001))
#define RGX_CR_CLK_CTRL_ISP_AUTO                          (IMG_UINT64_C(0x0000000000000002))
#endif /* RGX_FEATURE_S7_TOP_INFRASTRUCTURE */ 


#if !defined(RGX_FEATURE_S7_TOP_INFRASTRUCTURE)
/*

	Core Module Clock Control Modes.


	Allows individual domain clocks to be forced off, forced on or operate under automatic pipeline activity based clock gating. This register is generally controlled by the GPU firmware and should be set to AUTO. Clock gating reduces the power consumed by the device.

*/
/*
    Register RGX_CR_CLK_CTRL
*/
#define RGX_CR_CLK_CTRL                                   (0x0000U)
#define RGX_CR_CLK_CTRL_MASKFULL                          (IMG_UINT64_C(0xFFFFFF003F3FFFFF))
#if defined(RGX_FEATURE_CLUSTER_GROUPING)
/* BIF_TEXAS default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_BIF_TEXAS_SHIFT                   (62U)
#define RGX_CR_CLK_CTRL_BIF_TEXAS_CLRMSK                  (IMG_UINT64_C(0X3FFFFFFFFFFFFFFF))
#define RGX_CR_CLK_CTRL_BIF_TEXAS_OFF                     (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_BIF_TEXAS_ON                      (IMG_UINT64_C(0x4000000000000000))
#define RGX_CR_CLK_CTRL_BIF_TEXAS_AUTO                    (IMG_UINT64_C(0x8000000000000000))
/* IPP default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_IPP_SHIFT                         (60U)
#define RGX_CR_CLK_CTRL_IPP_CLRMSK                        (IMG_UINT64_C(0XCFFFFFFFFFFFFFFF))
#define RGX_CR_CLK_CTRL_IPP_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_IPP_ON                            (IMG_UINT64_C(0x1000000000000000))
#define RGX_CR_CLK_CTRL_IPP_AUTO                          (IMG_UINT64_C(0x2000000000000000))
#endif /* RGX_FEATURE_CLUSTER_GROUPING */

/* FBC default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_FBC_SHIFT                         (58U)
#define RGX_CR_CLK_CTRL_FBC_CLRMSK                        (IMG_UINT64_C(0XF3FFFFFFFFFFFFFF))
#define RGX_CR_CLK_CTRL_FBC_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_FBC_ON                            (IMG_UINT64_C(0x0400000000000000))
#define RGX_CR_CLK_CTRL_FBC_AUTO                          (IMG_UINT64_C(0x0800000000000000))
/* FBDC default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_FBDC_SHIFT                        (56U)
#define RGX_CR_CLK_CTRL_FBDC_CLRMSK                       (IMG_UINT64_C(0XFCFFFFFFFFFFFFFF))
#define RGX_CR_CLK_CTRL_FBDC_OFF                          (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_FBDC_ON                           (IMG_UINT64_C(0x0100000000000000))
#define RGX_CR_CLK_CTRL_FBDC_AUTO                         (IMG_UINT64_C(0x0200000000000000))
/* FB_TLCACHE default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_FB_TLCACHE_SHIFT                  (54U)
#define RGX_CR_CLK_CTRL_FB_TLCACHE_CLRMSK                 (IMG_UINT64_C(0XFF3FFFFFFFFFFFFF))
#define RGX_CR_CLK_CTRL_FB_TLCACHE_OFF                    (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_FB_TLCACHE_ON                     (IMG_UINT64_C(0x0040000000000000))
#define RGX_CR_CLK_CTRL_FB_TLCACHE_AUTO                   (IMG_UINT64_C(0x0080000000000000))
/* USCS default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_USCS_SHIFT                        (52U)
#define RGX_CR_CLK_CTRL_USCS_CLRMSK                       (IMG_UINT64_C(0XFFCFFFFFFFFFFFFF))
#define RGX_CR_CLK_CTRL_USCS_OFF                          (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_USCS_ON                           (IMG_UINT64_C(0x0010000000000000))
#define RGX_CR_CLK_CTRL_USCS_AUTO                         (IMG_UINT64_C(0x0020000000000000))
/* PBE default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_PBE_SHIFT                         (50U)
#define RGX_CR_CLK_CTRL_PBE_CLRMSK                        (IMG_UINT64_C(0XFFF3FFFFFFFFFFFF))
#define RGX_CR_CLK_CTRL_PBE_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_PBE_ON                            (IMG_UINT64_C(0x0004000000000000))
#define RGX_CR_CLK_CTRL_PBE_AUTO                          (IMG_UINT64_C(0x0008000000000000))
/* MCU_l1 default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_MCU_L1_SHIFT                      (48U)
#define RGX_CR_CLK_CTRL_MCU_L1_CLRMSK                     (IMG_UINT64_C(0XFFFCFFFFFFFFFFFF))
#define RGX_CR_CLK_CTRL_MCU_L1_OFF                        (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_MCU_L1_ON                         (IMG_UINT64_C(0x0001000000000000))
#define RGX_CR_CLK_CTRL_MCU_L1_AUTO                       (IMG_UINT64_C(0x0002000000000000))
/* CDM default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_CDM_SHIFT                         (46U)
#define RGX_CR_CLK_CTRL_CDM_CLRMSK                        (IMG_UINT64_C(0XFFFF3FFFFFFFFFFF))
#define RGX_CR_CLK_CTRL_CDM_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_CDM_ON                            (IMG_UINT64_C(0x0000400000000000))
#define RGX_CR_CLK_CTRL_CDM_AUTO                          (IMG_UINT64_C(0x0000800000000000))
/* SIDEKICK default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_SIDEKICK_SHIFT                    (44U)
#define RGX_CR_CLK_CTRL_SIDEKICK_CLRMSK                   (IMG_UINT64_C(0XFFFFCFFFFFFFFFFF))
#define RGX_CR_CLK_CTRL_SIDEKICK_OFF                      (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_SIDEKICK_ON                       (IMG_UINT64_C(0x0000100000000000))
#define RGX_CR_CLK_CTRL_SIDEKICK_AUTO                     (IMG_UINT64_C(0x0000200000000000))
/* BIF_SIDEKICK default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_BIF_SIDEKICK_SHIFT                (42U)
#define RGX_CR_CLK_CTRL_BIF_SIDEKICK_CLRMSK               (IMG_UINT64_C(0XFFFFF3FFFFFFFFFF))
#define RGX_CR_CLK_CTRL_BIF_SIDEKICK_OFF                  (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_BIF_SIDEKICK_ON                   (IMG_UINT64_C(0x0000040000000000))
#define RGX_CR_CLK_CTRL_BIF_SIDEKICK_AUTO                 (IMG_UINT64_C(0x0000080000000000))
/* BIF default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_BIF_SHIFT                         (40U)
#define RGX_CR_CLK_CTRL_BIF_CLRMSK                        (IMG_UINT64_C(0XFFFFFCFFFFFFFFFF))
#define RGX_CR_CLK_CTRL_BIF_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_BIF_ON                            (IMG_UINT64_C(0x0000010000000000))
#define RGX_CR_CLK_CTRL_BIF_AUTO                          (IMG_UINT64_C(0x0000020000000000))
/* TPU_MCU_DEMUX default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_TPU_MCU_DEMUX_SHIFT               (28U)
#define RGX_CR_CLK_CTRL_TPU_MCU_DEMUX_CLRMSK              (IMG_UINT64_C(0XFFFFFFFFCFFFFFFF))
#define RGX_CR_CLK_CTRL_TPU_MCU_DEMUX_OFF                 (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_TPU_MCU_DEMUX_ON                  (IMG_UINT64_C(0x0000000010000000))
#define RGX_CR_CLK_CTRL_TPU_MCU_DEMUX_AUTO                (IMG_UINT64_C(0x0000000020000000))
/* MCU_L0 default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_MCU_L0_SHIFT                      (26U)
#define RGX_CR_CLK_CTRL_MCU_L0_CLRMSK                     (IMG_UINT64_C(0XFFFFFFFFF3FFFFFF))
#define RGX_CR_CLK_CTRL_MCU_L0_OFF                        (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_MCU_L0_ON                         (IMG_UINT64_C(0x0000000004000000))
#define RGX_CR_CLK_CTRL_MCU_L0_AUTO                       (IMG_UINT64_C(0x0000000008000000))
/* TPU default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_TPU_SHIFT                         (24U)
#define RGX_CR_CLK_CTRL_TPU_CLRMSK                        (IMG_UINT64_C(0XFFFFFFFFFCFFFFFF))
#define RGX_CR_CLK_CTRL_TPU_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_TPU_ON                            (IMG_UINT64_C(0x0000000001000000))
#define RGX_CR_CLK_CTRL_TPU_AUTO                          (IMG_UINT64_C(0x0000000002000000))
/* USC default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_USC_SHIFT                         (20U)
#define RGX_CR_CLK_CTRL_USC_CLRMSK                        (IMG_UINT64_C(0XFFFFFFFFFFCFFFFF))
#define RGX_CR_CLK_CTRL_USC_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_USC_ON                            (IMG_UINT64_C(0x0000000000100000))
#define RGX_CR_CLK_CTRL_USC_AUTO                          (IMG_UINT64_C(0x0000000000200000))
/* TLA default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_TLA_SHIFT                         (18U)
#define RGX_CR_CLK_CTRL_TLA_CLRMSK                        (IMG_UINT64_C(0XFFFFFFFFFFF3FFFF))
#define RGX_CR_CLK_CTRL_TLA_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_TLA_ON                            (IMG_UINT64_C(0x0000000000040000))
#define RGX_CR_CLK_CTRL_TLA_AUTO                          (IMG_UINT64_C(0x0000000000080000))
/* SLC default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_SLC_SHIFT                         (16U)
#define RGX_CR_CLK_CTRL_SLC_CLRMSK                        (IMG_UINT64_C(0XFFFFFFFFFFFCFFFF))
#define RGX_CR_CLK_CTRL_SLC_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_SLC_ON                            (IMG_UINT64_C(0x0000000000010000))
#define RGX_CR_CLK_CTRL_SLC_AUTO                          (IMG_UINT64_C(0x0000000000020000))
/* UVS default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_UVS_SHIFT                         (14U)
#define RGX_CR_CLK_CTRL_UVS_CLRMSK                        (IMG_UINT64_C(0XFFFFFFFFFFFF3FFF))
#define RGX_CR_CLK_CTRL_UVS_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_UVS_ON                            (IMG_UINT64_C(0x0000000000004000))
#define RGX_CR_CLK_CTRL_UVS_AUTO                          (IMG_UINT64_C(0x0000000000008000))
/* PDS default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_PDS_SHIFT                         (12U)
#define RGX_CR_CLK_CTRL_PDS_CLRMSK                        (IMG_UINT64_C(0XFFFFFFFFFFFFCFFF))
#define RGX_CR_CLK_CTRL_PDS_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_PDS_ON                            (IMG_UINT64_C(0x0000000000001000))
#define RGX_CR_CLK_CTRL_PDS_AUTO                          (IMG_UINT64_C(0x0000000000002000))
/* VDM default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_VDM_SHIFT                         (10U)
#define RGX_CR_CLK_CTRL_VDM_CLRMSK                        (IMG_UINT64_C(0XFFFFFFFFFFFFF3FF))
#define RGX_CR_CLK_CTRL_VDM_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_VDM_ON                            (IMG_UINT64_C(0x0000000000000400))
#define RGX_CR_CLK_CTRL_VDM_AUTO                          (IMG_UINT64_C(0x0000000000000800))
/* PM default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_PM_SHIFT                          (8U)
#define RGX_CR_CLK_CTRL_PM_CLRMSK                         (IMG_UINT64_C(0XFFFFFFFFFFFFFCFF))
#define RGX_CR_CLK_CTRL_PM_OFF                            (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_PM_ON                             (IMG_UINT64_C(0x0000000000000100))
#define RGX_CR_CLK_CTRL_PM_AUTO                           (IMG_UINT64_C(0x0000000000000200))
/* GPP default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_GPP_SHIFT                         (6U)
#define RGX_CR_CLK_CTRL_GPP_CLRMSK                        (IMG_UINT64_C(0XFFFFFFFFFFFFFF3F))
#define RGX_CR_CLK_CTRL_GPP_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_GPP_ON                            (IMG_UINT64_C(0x0000000000000040))
#define RGX_CR_CLK_CTRL_GPP_AUTO                          (IMG_UINT64_C(0x0000000000000080))
/* TE default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_TE_SHIFT                          (4U)
#define RGX_CR_CLK_CTRL_TE_CLRMSK                         (IMG_UINT64_C(0XFFFFFFFFFFFFFFCF))
#define RGX_CR_CLK_CTRL_TE_OFF                            (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_TE_ON                             (IMG_UINT64_C(0x0000000000000010))
#define RGX_CR_CLK_CTRL_TE_AUTO                           (IMG_UINT64_C(0x0000000000000020))
/* TSP default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_TSP_SHIFT                         (2U)
#define RGX_CR_CLK_CTRL_TSP_CLRMSK                        (IMG_UINT64_C(0XFFFFFFFFFFFFFFF3))
#define RGX_CR_CLK_CTRL_TSP_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_TSP_ON                            (IMG_UINT64_C(0x0000000000000004))
#define RGX_CR_CLK_CTRL_TSP_AUTO                          (IMG_UINT64_C(0x0000000000000008))
/* ISP default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL_ISP_SHIFT                         (0U)
#define RGX_CR_CLK_CTRL_ISP_CLRMSK                        (IMG_UINT64_C(0XFFFFFFFFFFFFFFFC))
#define RGX_CR_CLK_CTRL_ISP_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL_ISP_ON                            (IMG_UINT64_C(0x0000000000000001))
#define RGX_CR_CLK_CTRL_ISP_AUTO                          (IMG_UINT64_C(0x0000000000000002))
#endif /* !defined(RGX_FEATURE_S7_TOP_INFRASTRUCTURE) */


#if defined(RGX_FEATURE_S7_TOP_INFRASTRUCTURE)
/*

	Reports the current module clock status


	Clock gating state reflects the condition of the clock for each module

*/
/*
    Register RGX_CR_CLK_STATUS
*/
#define RGX_CR_CLK_STATUS                                 (0x0008U)
#define RGX_CR_CLK_STATUS_MASKFULL                        (IMG_UINT64_C(0x00000001FF907773))
/* MCU_FBTC default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_MCU_FBTC_SHIFT                  (32U)
#define RGX_CR_CLK_STATUS_MCU_FBTC_CLRMSK                 (IMG_UINT64_C(0XFFFFFFFEFFFFFFFF))
#define RGX_CR_CLK_STATUS_MCU_FBTC_GATED                  (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_MCU_FBTC_RUNNING                (IMG_UINT64_C(0x0000000100000000))
#if defined(RGX_FEATURE_CLUSTER_GROUPING)
/* BIF_TEXAS default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_BIF_TEXAS_SHIFT                 (31U)
#define RGX_CR_CLK_STATUS_BIF_TEXAS_CLRMSK                (IMG_UINT64_C(0XFFFFFFFF7FFFFFFF))
#define RGX_CR_CLK_STATUS_BIF_TEXAS_GATED                 (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_BIF_TEXAS_RUNNING               (IMG_UINT64_C(0x0000000080000000))
/* IPP default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_IPP_SHIFT                       (30U)
#define RGX_CR_CLK_STATUS_IPP_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFBFFFFFFF))
#define RGX_CR_CLK_STATUS_IPP_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_IPP_RUNNING                     (IMG_UINT64_C(0x0000000040000000))
#endif /* RGX_FEATURE_CLUSTER_GROUPING */

/* FBC default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_FBC_SHIFT                       (29U)
#define RGX_CR_CLK_STATUS_FBC_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFDFFFFFFF))
#define RGX_CR_CLK_STATUS_FBC_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_FBC_RUNNING                     (IMG_UINT64_C(0x0000000020000000))
/* FBDC default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_FBDC_SHIFT                      (28U)
#define RGX_CR_CLK_STATUS_FBDC_CLRMSK                     (IMG_UINT64_C(0XFFFFFFFFEFFFFFFF))
#define RGX_CR_CLK_STATUS_FBDC_GATED                      (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_FBDC_RUNNING                    (IMG_UINT64_C(0x0000000010000000))
/* FB_TLCACHE default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_FB_TLCACHE_SHIFT                (27U)
#define RGX_CR_CLK_STATUS_FB_TLCACHE_CLRMSK               (IMG_UINT64_C(0XFFFFFFFFF7FFFFFF))
#define RGX_CR_CLK_STATUS_FB_TLCACHE_GATED                (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_FB_TLCACHE_RUNNING              (IMG_UINT64_C(0x0000000008000000))
/* USCS default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_USCS_SHIFT                      (26U)
#define RGX_CR_CLK_STATUS_USCS_CLRMSK                     (IMG_UINT64_C(0XFFFFFFFFFBFFFFFF))
#define RGX_CR_CLK_STATUS_USCS_GATED                      (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_USCS_RUNNING                    (IMG_UINT64_C(0x0000000004000000))
/* PBE default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_PBE_SHIFT                       (25U)
#define RGX_CR_CLK_STATUS_PBE_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFDFFFFFF))
#define RGX_CR_CLK_STATUS_PBE_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_PBE_RUNNING                     (IMG_UINT64_C(0x0000000002000000))
/* MCU_L1 default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_MCU_L1_SHIFT                    (24U)
#define RGX_CR_CLK_STATUS_MCU_L1_CLRMSK                   (IMG_UINT64_C(0XFFFFFFFFFEFFFFFF))
#define RGX_CR_CLK_STATUS_MCU_L1_GATED                    (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_MCU_L1_RUNNING                  (IMG_UINT64_C(0x0000000001000000))
/* CDM default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_CDM_SHIFT                       (23U)
#define RGX_CR_CLK_STATUS_CDM_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFF7FFFFF))
#define RGX_CR_CLK_STATUS_CDM_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_CDM_RUNNING                     (IMG_UINT64_C(0x0000000000800000))
/* BIF default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_BIF_SHIFT                       (20U)
#define RGX_CR_CLK_STATUS_BIF_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFEFFFFF))
#define RGX_CR_CLK_STATUS_BIF_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_BIF_RUNNING                     (IMG_UINT64_C(0x0000000000100000))
/* TPU_MCU_DEMUX default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_TPU_MCU_DEMUX_SHIFT             (14U)
#define RGX_CR_CLK_STATUS_TPU_MCU_DEMUX_CLRMSK            (IMG_UINT64_C(0XFFFFFFFFFFFFBFFF))
#define RGX_CR_CLK_STATUS_TPU_MCU_DEMUX_GATED             (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_TPU_MCU_DEMUX_RUNNING           (IMG_UINT64_C(0x0000000000004000))
/* MCU_L0 default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_MCU_L0_SHIFT                    (13U)
#define RGX_CR_CLK_STATUS_MCU_L0_CLRMSK                   (IMG_UINT64_C(0XFFFFFFFFFFFFDFFF))
#define RGX_CR_CLK_STATUS_MCU_L0_GATED                    (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_MCU_L0_RUNNING                  (IMG_UINT64_C(0x0000000000002000))
/* TPU default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_TPU_SHIFT                       (12U)
#define RGX_CR_CLK_STATUS_TPU_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFEFFF))
#define RGX_CR_CLK_STATUS_TPU_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_TPU_RUNNING                     (IMG_UINT64_C(0x0000000000001000))
/* USC default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_USC_SHIFT                       (10U)
#define RGX_CR_CLK_STATUS_USC_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFFBFF))
#define RGX_CR_CLK_STATUS_USC_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_USC_RUNNING                     (IMG_UINT64_C(0x0000000000000400))
/* TLA default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_TLA_SHIFT                       (9U)
#define RGX_CR_CLK_STATUS_TLA_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFFDFF))
#define RGX_CR_CLK_STATUS_TLA_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_TLA_RUNNING                     (IMG_UINT64_C(0x0000000000000200))
/* SLC default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_SLC_SHIFT                       (8U)
#define RGX_CR_CLK_STATUS_SLC_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFFEFF))
#define RGX_CR_CLK_STATUS_SLC_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_SLC_RUNNING                     (IMG_UINT64_C(0x0000000000000100))
/* PDS default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_PDS_SHIFT                       (6U)
#define RGX_CR_CLK_STATUS_PDS_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFFFBF))
#define RGX_CR_CLK_STATUS_PDS_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_PDS_RUNNING                     (IMG_UINT64_C(0x0000000000000040))
/* VDM default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_VDM_SHIFT                       (5U)
#define RGX_CR_CLK_STATUS_VDM_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFFFDF))
#define RGX_CR_CLK_STATUS_VDM_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_VDM_RUNNING                     (IMG_UINT64_C(0x0000000000000020))
/* PM default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_PM_SHIFT                        (4U)
#define RGX_CR_CLK_STATUS_PM_CLRMSK                       (IMG_UINT64_C(0XFFFFFFFFFFFFFFEF))
#define RGX_CR_CLK_STATUS_PM_GATED                        (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_PM_RUNNING                      (IMG_UINT64_C(0x0000000000000010))
/* TSP default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_TSP_SHIFT                       (1U)
#define RGX_CR_CLK_STATUS_TSP_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFFFFD))
#define RGX_CR_CLK_STATUS_TSP_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_TSP_RUNNING                     (IMG_UINT64_C(0x0000000000000002))
/* ISP default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_ISP_SHIFT                       (0U)
#define RGX_CR_CLK_STATUS_ISP_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFFFFE))
#define RGX_CR_CLK_STATUS_ISP_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_ISP_RUNNING                     (IMG_UINT64_C(0x0000000000000001))
#endif /* RGX_FEATURE_S7_TOP_INFRASTRUCTURE */ 


#if !defined(RGX_FEATURE_S7_TOP_INFRASTRUCTURE)
/*

	Reports the current module clock status


	Clock gating state reflects the condition of the clock for each module

*/
/*
    Register RGX_CR_CLK_STATUS
*/
#define RGX_CR_CLK_STATUS                                 (0x0008U)
#define RGX_CR_CLK_STATUS_MASKFULL                        (IMG_UINT64_C(0x00000001FFF077FF))
/* MCU_FBTC default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_MCU_FBTC_SHIFT                  (32U)
#define RGX_CR_CLK_STATUS_MCU_FBTC_CLRMSK                 (IMG_UINT64_C(0XFFFFFFFEFFFFFFFF))
#define RGX_CR_CLK_STATUS_MCU_FBTC_GATED                  (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_MCU_FBTC_RUNNING                (IMG_UINT64_C(0x0000000100000000))
#if defined(RGX_FEATURE_CLUSTER_GROUPING)
/* BIF_TEXAS default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_BIF_TEXAS_SHIFT                 (31U)
#define RGX_CR_CLK_STATUS_BIF_TEXAS_CLRMSK                (IMG_UINT64_C(0XFFFFFFFF7FFFFFFF))
#define RGX_CR_CLK_STATUS_BIF_TEXAS_GATED                 (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_BIF_TEXAS_RUNNING               (IMG_UINT64_C(0x0000000080000000))
/* IPP default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_IPP_SHIFT                       (30U)
#define RGX_CR_CLK_STATUS_IPP_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFBFFFFFFF))
#define RGX_CR_CLK_STATUS_IPP_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_IPP_RUNNING                     (IMG_UINT64_C(0x0000000040000000))
#endif /* RGX_FEATURE_CLUSTER_GROUPING */

/* FBC default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_FBC_SHIFT                       (29U)
#define RGX_CR_CLK_STATUS_FBC_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFDFFFFFFF))
#define RGX_CR_CLK_STATUS_FBC_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_FBC_RUNNING                     (IMG_UINT64_C(0x0000000020000000))
/* FBDC default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_FBDC_SHIFT                      (28U)
#define RGX_CR_CLK_STATUS_FBDC_CLRMSK                     (IMG_UINT64_C(0XFFFFFFFFEFFFFFFF))
#define RGX_CR_CLK_STATUS_FBDC_GATED                      (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_FBDC_RUNNING                    (IMG_UINT64_C(0x0000000010000000))
/* FB_TLCACHE default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_FB_TLCACHE_SHIFT                (27U)
#define RGX_CR_CLK_STATUS_FB_TLCACHE_CLRMSK               (IMG_UINT64_C(0XFFFFFFFFF7FFFFFF))
#define RGX_CR_CLK_STATUS_FB_TLCACHE_GATED                (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_FB_TLCACHE_RUNNING              (IMG_UINT64_C(0x0000000008000000))
/* USCS default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_USCS_SHIFT                      (26U)
#define RGX_CR_CLK_STATUS_USCS_CLRMSK                     (IMG_UINT64_C(0XFFFFFFFFFBFFFFFF))
#define RGX_CR_CLK_STATUS_USCS_GATED                      (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_USCS_RUNNING                    (IMG_UINT64_C(0x0000000004000000))
/* PBE default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_PBE_SHIFT                       (25U)
#define RGX_CR_CLK_STATUS_PBE_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFDFFFFFF))
#define RGX_CR_CLK_STATUS_PBE_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_PBE_RUNNING                     (IMG_UINT64_C(0x0000000002000000))
/* MCU_L1 default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_MCU_L1_SHIFT                    (24U)
#define RGX_CR_CLK_STATUS_MCU_L1_CLRMSK                   (IMG_UINT64_C(0XFFFFFFFFFEFFFFFF))
#define RGX_CR_CLK_STATUS_MCU_L1_GATED                    (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_MCU_L1_RUNNING                  (IMG_UINT64_C(0x0000000001000000))
/* CDM default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_CDM_SHIFT                       (23U)
#define RGX_CR_CLK_STATUS_CDM_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFF7FFFFF))
#define RGX_CR_CLK_STATUS_CDM_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_CDM_RUNNING                     (IMG_UINT64_C(0x0000000000800000))
/* SIDEKICK default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_SIDEKICK_SHIFT                  (22U)
#define RGX_CR_CLK_STATUS_SIDEKICK_CLRMSK                 (IMG_UINT64_C(0XFFFFFFFFFFBFFFFF))
#define RGX_CR_CLK_STATUS_SIDEKICK_GATED                  (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_SIDEKICK_RUNNING                (IMG_UINT64_C(0x0000000000400000))
/* BIF_SIDEKICK default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_BIF_SIDEKICK_SHIFT              (21U)
#define RGX_CR_CLK_STATUS_BIF_SIDEKICK_CLRMSK             (IMG_UINT64_C(0XFFFFFFFFFFDFFFFF))
#define RGX_CR_CLK_STATUS_BIF_SIDEKICK_GATED              (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_BIF_SIDEKICK_RUNNING            (IMG_UINT64_C(0x0000000000200000))
/* BIF default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_BIF_SHIFT                       (20U)
#define RGX_CR_CLK_STATUS_BIF_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFEFFFFF))
#define RGX_CR_CLK_STATUS_BIF_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_BIF_RUNNING                     (IMG_UINT64_C(0x0000000000100000))
/* TPU_MCU_DEMUX default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_TPU_MCU_DEMUX_SHIFT             (14U)
#define RGX_CR_CLK_STATUS_TPU_MCU_DEMUX_CLRMSK            (IMG_UINT64_C(0XFFFFFFFFFFFFBFFF))
#define RGX_CR_CLK_STATUS_TPU_MCU_DEMUX_GATED             (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_TPU_MCU_DEMUX_RUNNING           (IMG_UINT64_C(0x0000000000004000))
/* MCU_L0 default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_MCU_L0_SHIFT                    (13U)
#define RGX_CR_CLK_STATUS_MCU_L0_CLRMSK                   (IMG_UINT64_C(0XFFFFFFFFFFFFDFFF))
#define RGX_CR_CLK_STATUS_MCU_L0_GATED                    (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_MCU_L0_RUNNING                  (IMG_UINT64_C(0x0000000000002000))
/* TPU default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_TPU_SHIFT                       (12U)
#define RGX_CR_CLK_STATUS_TPU_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFEFFF))
#define RGX_CR_CLK_STATUS_TPU_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_TPU_RUNNING                     (IMG_UINT64_C(0x0000000000001000))
/* USC default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_USC_SHIFT                       (10U)
#define RGX_CR_CLK_STATUS_USC_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFFBFF))
#define RGX_CR_CLK_STATUS_USC_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_USC_RUNNING                     (IMG_UINT64_C(0x0000000000000400))
/* TLA default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_TLA_SHIFT                       (9U)
#define RGX_CR_CLK_STATUS_TLA_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFFDFF))
#define RGX_CR_CLK_STATUS_TLA_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_TLA_RUNNING                     (IMG_UINT64_C(0x0000000000000200))
/* SLC default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_SLC_SHIFT                       (8U)
#define RGX_CR_CLK_STATUS_SLC_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFFEFF))
#define RGX_CR_CLK_STATUS_SLC_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_SLC_RUNNING                     (IMG_UINT64_C(0x0000000000000100))
/* UVS default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_UVS_SHIFT                       (7U)
#define RGX_CR_CLK_STATUS_UVS_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFFF7F))
#define RGX_CR_CLK_STATUS_UVS_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_UVS_RUNNING                     (IMG_UINT64_C(0x0000000000000080))
/* PDS default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_PDS_SHIFT                       (6U)
#define RGX_CR_CLK_STATUS_PDS_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFFFBF))
#define RGX_CR_CLK_STATUS_PDS_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_PDS_RUNNING                     (IMG_UINT64_C(0x0000000000000040))
/* VDM default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_VDM_SHIFT                       (5U)
#define RGX_CR_CLK_STATUS_VDM_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFFFDF))
#define RGX_CR_CLK_STATUS_VDM_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_VDM_RUNNING                     (IMG_UINT64_C(0x0000000000000020))
/* PM default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_PM_SHIFT                        (4U)
#define RGX_CR_CLK_STATUS_PM_CLRMSK                       (IMG_UINT64_C(0XFFFFFFFFFFFFFFEF))
#define RGX_CR_CLK_STATUS_PM_GATED                        (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_PM_RUNNING                      (IMG_UINT64_C(0x0000000000000010))
/* GPP default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_GPP_SHIFT                       (3U)
#define RGX_CR_CLK_STATUS_GPP_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFFFF7))
#define RGX_CR_CLK_STATUS_GPP_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_GPP_RUNNING                     (IMG_UINT64_C(0x0000000000000008))
/* TE default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_TE_SHIFT                        (2U)
#define RGX_CR_CLK_STATUS_TE_CLRMSK                       (IMG_UINT64_C(0XFFFFFFFFFFFFFFFB))
#define RGX_CR_CLK_STATUS_TE_GATED                        (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_TE_RUNNING                      (IMG_UINT64_C(0x0000000000000004))
/* TSP default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_TSP_SHIFT                       (1U)
#define RGX_CR_CLK_STATUS_TSP_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFFFFD))
#define RGX_CR_CLK_STATUS_TSP_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_TSP_RUNNING                     (IMG_UINT64_C(0x0000000000000002))
/* ISP default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS_ISP_SHIFT                       (0U)
#define RGX_CR_CLK_STATUS_ISP_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFFFFE))
#define RGX_CR_CLK_STATUS_ISP_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS_ISP_RUNNING                     (IMG_UINT64_C(0x0000000000000001))
#endif /* !defined(RGX_FEATURE_S7_TOP_INFRASTRUCTURE) */


/*

	Reports the core ID


	Core ID Register

*/
/*
    Register RGX_CR_CORE_ID
*/
#define RGX_CR_CORE_ID                                    (0x0018U)
#define RGX_CR_CORE_ID_MASKFULL                           (IMG_UINT64_C(0x00000000FFFFFFFF))
/* ID
 Core ID 
*/
#define RGX_CR_CORE_ID_ID_SHIFT                           (16U)
#define RGX_CR_CORE_ID_ID_CLRMSK                          (0X0000FFFFU)
/* CONFIG
 Core Configuration 
*/
#define RGX_CR_CORE_ID_CONFIG_SHIFT                       (0U)
#define RGX_CR_CORE_ID_CONFIG_CLRMSK                      (0XFFFF0000U)


/*

	Reports the core revision


	Core Revision Register identifies the specific core revision.
	This is updated to reflect the formal release status of the core.

*/
/*
    Register RGX_CR_CORE_REVISION
*/
#define RGX_CR_CORE_REVISION                              (0x0020U)
#define RGX_CR_CORE_REVISION_MASKFULL                     (IMG_UINT64_C(0x00000000FFFFFFFF))
/* DESIGNER
 Designer Field 
*/
#define RGX_CR_CORE_REVISION_DESIGNER_SHIFT               (24U)
#define RGX_CR_CORE_REVISION_DESIGNER_CLRMSK              (0X00FFFFFFU)
/* MAJOR default: 0x00000001
 Major Revision 
*/
#define RGX_CR_CORE_REVISION_MAJOR_SHIFT                  (16U)
#define RGX_CR_CORE_REVISION_MAJOR_CLRMSK                 (0XFF00FFFFU)
/* MINOR
 Minor Revision 
*/
#define RGX_CR_CORE_REVISION_MINOR_SHIFT                  (8U)
#define RGX_CR_CORE_REVISION_MINOR_CLRMSK                 (0XFFFF00FFU)
/* MAINTENANCE
 Maintenance Revision 
*/
#define RGX_CR_CORE_REVISION_MAINTENANCE_SHIFT            (0U)
#define RGX_CR_CORE_REVISION_MAINTENANCE_CLRMSK           (0XFFFFFF00U)


/*

	SOC Specific reporting register.


	Designer Revision Field
	The SOC designer can use this register for their own revision control

*/
/*
    Register RGX_CR_DESIGNER_REV_FIELD1
*/
#define RGX_CR_DESIGNER_REV_FIELD1                        (0x0028U)
#define RGX_CR_DESIGNER_REV_FIELD1_MASKFULL               (IMG_UINT64_C(0x00000000FFFFFFFF))
/* DESIGNER_REV_FIELD1
 Designer field 
*/
#define RGX_CR_DESIGNER_REV_FIELD1_DESIGNER_REV_FIELD1_SHIFT (0U)
#define RGX_CR_DESIGNER_REV_FIELD1_DESIGNER_REV_FIELD1_CLRMSK (00000000U)


/*

	SOC Specific reporting register.


	Designer Revision Field
	The SOC designer can use this register for their own revision control is required

*/
/*
    Register RGX_CR_DESIGNER_REV_FIELD2
*/
#define RGX_CR_DESIGNER_REV_FIELD2                        (0x0030U)
#define RGX_CR_DESIGNER_REV_FIELD2_MASKFULL               (IMG_UINT64_C(0x00000000FFFFFFFF))
/* DESIGNER_REV_FIELD2
 Designer field 
*/
#define RGX_CR_DESIGNER_REV_FIELD2_DESIGNER_REV_FIELD2_SHIFT (0U)
#define RGX_CR_DESIGNER_REV_FIELD2_DESIGNER_REV_FIELD2_CLRMSK (00000000U)


/*

	Core Module Clock Control Modes.


	Allows individual domain clocks to be forced off, forced on or operate under automatic pipeline activity based clock gating. This register is generally controlled by the GPU firmware and should be set to AUTO. Clock gating reduces the power consumed by the device.

*/
/*
    Register RGX_CR_CLK_XTPLUS_CTRL
*/
#define RGX_CR_CLK_XTPLUS_CTRL                            (0x0080U)
#define RGX_CR_CLK_XTPLUS_CTRL_MASKFULL                   (IMG_UINT64_C(0x00000003FFFFFFFF))
/* IPF default: AUTO (0x00000002) */
#define RGX_CR_CLK_XTPLUS_CTRL_IPF_SHIFT                  (32U)
#define RGX_CR_CLK_XTPLUS_CTRL_IPF_CLRMSK                 (IMG_UINT64_C(0XFFFFFFFCFFFFFFFF))
#define RGX_CR_CLK_XTPLUS_CTRL_IPF_OFF                    (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_XTPLUS_CTRL_IPF_ON                     (IMG_UINT64_C(0x0000000100000000))
#define RGX_CR_CLK_XTPLUS_CTRL_IPF_AUTO                   (IMG_UINT64_C(0x0000000200000000))
/* COMPUTE default: AUTO (0x00000002) */
#define RGX_CR_CLK_XTPLUS_CTRL_COMPUTE_SHIFT              (30U)
#define RGX_CR_CLK_XTPLUS_CTRL_COMPUTE_CLRMSK             (IMG_UINT64_C(0XFFFFFFFF3FFFFFFF))
#define RGX_CR_CLK_XTPLUS_CTRL_COMPUTE_OFF                (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_XTPLUS_CTRL_COMPUTE_ON                 (IMG_UINT64_C(0x0000000040000000))
#define RGX_CR_CLK_XTPLUS_CTRL_COMPUTE_AUTO               (IMG_UINT64_C(0x0000000080000000))
/* PIXEL default: AUTO (0x00000002) */
#define RGX_CR_CLK_XTPLUS_CTRL_PIXEL_SHIFT                (28U)
#define RGX_CR_CLK_XTPLUS_CTRL_PIXEL_CLRMSK               (IMG_UINT64_C(0XFFFFFFFFCFFFFFFF))
#define RGX_CR_CLK_XTPLUS_CTRL_PIXEL_OFF                  (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_XTPLUS_CTRL_PIXEL_ON                   (IMG_UINT64_C(0x0000000010000000))
#define RGX_CR_CLK_XTPLUS_CTRL_PIXEL_AUTO                 (IMG_UINT64_C(0x0000000020000000))
/* VERTEX default: AUTO (0x00000002) */
#define RGX_CR_CLK_XTPLUS_CTRL_VERTEX_SHIFT               (26U)
#define RGX_CR_CLK_XTPLUS_CTRL_VERTEX_CLRMSK              (IMG_UINT64_C(0XFFFFFFFFF3FFFFFF))
#define RGX_CR_CLK_XTPLUS_CTRL_VERTEX_OFF                 (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_XTPLUS_CTRL_VERTEX_ON                  (IMG_UINT64_C(0x0000000004000000))
#define RGX_CR_CLK_XTPLUS_CTRL_VERTEX_AUTO                (IMG_UINT64_C(0x0000000008000000))
/* USCPS default: AUTO (0x00000002) */
#define RGX_CR_CLK_XTPLUS_CTRL_USCPS_SHIFT                (24U)
#define RGX_CR_CLK_XTPLUS_CTRL_USCPS_CLRMSK               (IMG_UINT64_C(0XFFFFFFFFFCFFFFFF))
#define RGX_CR_CLK_XTPLUS_CTRL_USCPS_OFF                  (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_XTPLUS_CTRL_USCPS_ON                   (IMG_UINT64_C(0x0000000001000000))
#define RGX_CR_CLK_XTPLUS_CTRL_USCPS_AUTO                 (IMG_UINT64_C(0x0000000002000000))
/* PDS_SHARED default: AUTO (0x00000002) */
#define RGX_CR_CLK_XTPLUS_CTRL_PDS_SHARED_SHIFT           (22U)
#define RGX_CR_CLK_XTPLUS_CTRL_PDS_SHARED_CLRMSK          (IMG_UINT64_C(0XFFFFFFFFFF3FFFFF))
#define RGX_CR_CLK_XTPLUS_CTRL_PDS_SHARED_OFF             (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_XTPLUS_CTRL_PDS_SHARED_ON              (IMG_UINT64_C(0x0000000000400000))
#define RGX_CR_CLK_XTPLUS_CTRL_PDS_SHARED_AUTO            (IMG_UINT64_C(0x0000000000800000))
/* BIF_BLACKPEARL default: AUTO (0x00000002) */
#define RGX_CR_CLK_XTPLUS_CTRL_BIF_BLACKPEARL_SHIFT       (20U)
#define RGX_CR_CLK_XTPLUS_CTRL_BIF_BLACKPEARL_CLRMSK      (IMG_UINT64_C(0XFFFFFFFFFFCFFFFF))
#define RGX_CR_CLK_XTPLUS_CTRL_BIF_BLACKPEARL_OFF         (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_XTPLUS_CTRL_BIF_BLACKPEARL_ON          (IMG_UINT64_C(0x0000000000100000))
#define RGX_CR_CLK_XTPLUS_CTRL_BIF_BLACKPEARL_AUTO        (IMG_UINT64_C(0x0000000000200000))
/* USC_SHARED default: AUTO (0x00000002) */
#define RGX_CR_CLK_XTPLUS_CTRL_USC_SHARED_SHIFT           (18U)
#define RGX_CR_CLK_XTPLUS_CTRL_USC_SHARED_CLRMSK          (IMG_UINT64_C(0XFFFFFFFFFFF3FFFF))
#define RGX_CR_CLK_XTPLUS_CTRL_USC_SHARED_OFF             (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_XTPLUS_CTRL_USC_SHARED_ON              (IMG_UINT64_C(0x0000000000040000))
#define RGX_CR_CLK_XTPLUS_CTRL_USC_SHARED_AUTO            (IMG_UINT64_C(0x0000000000080000))
/* GEOMETRY default: AUTO (0x00000002) */
#define RGX_CR_CLK_XTPLUS_CTRL_GEOMETRY_SHIFT             (16U)
#define RGX_CR_CLK_XTPLUS_CTRL_GEOMETRY_CLRMSK            (IMG_UINT64_C(0XFFFFFFFFFFFCFFFF))
#define RGX_CR_CLK_XTPLUS_CTRL_GEOMETRY_OFF               (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_XTPLUS_CTRL_GEOMETRY_ON                (IMG_UINT64_C(0x0000000000010000))
#define RGX_CR_CLK_XTPLUS_CTRL_GEOMETRY_AUTO              (IMG_UINT64_C(0x0000000000020000))
/* RAST default: AUTO (0x00000002) */
#define RGX_CR_CLK_XTPLUS_CTRL_RAST_SHIFT                 (14U)
#define RGX_CR_CLK_XTPLUS_CTRL_RAST_CLRMSK                (IMG_UINT64_C(0XFFFFFFFFFFFF3FFF))
#define RGX_CR_CLK_XTPLUS_CTRL_RAST_OFF                   (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_XTPLUS_CTRL_RAST_ON                    (IMG_UINT64_C(0x0000000000004000))
#define RGX_CR_CLK_XTPLUS_CTRL_RAST_AUTO                  (IMG_UINT64_C(0x0000000000008000))
/* UVB default: AUTO (0x00000002) */
#define RGX_CR_CLK_XTPLUS_CTRL_UVB_SHIFT                  (12U)
#define RGX_CR_CLK_XTPLUS_CTRL_UVB_CLRMSK                 (IMG_UINT64_C(0XFFFFFFFFFFFFCFFF))
#define RGX_CR_CLK_XTPLUS_CTRL_UVB_OFF                    (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_XTPLUS_CTRL_UVB_ON                     (IMG_UINT64_C(0x0000000000001000))
#define RGX_CR_CLK_XTPLUS_CTRL_UVB_AUTO                   (IMG_UINT64_C(0x0000000000002000))
/* GPP default: AUTO (0x00000002) */
#define RGX_CR_CLK_XTPLUS_CTRL_GPP_SHIFT                  (10U)
#define RGX_CR_CLK_XTPLUS_CTRL_GPP_CLRMSK                 (IMG_UINT64_C(0XFFFFFFFFFFFFF3FF))
#define RGX_CR_CLK_XTPLUS_CTRL_GPP_OFF                    (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_XTPLUS_CTRL_GPP_ON                     (IMG_UINT64_C(0x0000000000000400))
#define RGX_CR_CLK_XTPLUS_CTRL_GPP_AUTO                   (IMG_UINT64_C(0x0000000000000800))
/* VDM_PIPE default: AUTO (0x00000002) */
#define RGX_CR_CLK_XTPLUS_CTRL_VDM_PIPE_SHIFT             (8U)
#define RGX_CR_CLK_XTPLUS_CTRL_VDM_PIPE_CLRMSK            (IMG_UINT64_C(0XFFFFFFFFFFFFFCFF))
#define RGX_CR_CLK_XTPLUS_CTRL_VDM_PIPE_OFF               (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_XTPLUS_CTRL_VDM_PIPE_ON                (IMG_UINT64_C(0x0000000000000100))
#define RGX_CR_CLK_XTPLUS_CTRL_VDM_PIPE_AUTO              (IMG_UINT64_C(0x0000000000000200))
/* VDM default: AUTO (0x00000002) */
#define RGX_CR_CLK_XTPLUS_CTRL_VDM_SHIFT                  (6U)
#define RGX_CR_CLK_XTPLUS_CTRL_VDM_CLRMSK                 (IMG_UINT64_C(0XFFFFFFFFFFFFFF3F))
#define RGX_CR_CLK_XTPLUS_CTRL_VDM_OFF                    (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_XTPLUS_CTRL_VDM_ON                     (IMG_UINT64_C(0x0000000000000040))
#define RGX_CR_CLK_XTPLUS_CTRL_VDM_AUTO                   (IMG_UINT64_C(0x0000000000000080))
/* TE3 default: AUTO (0x00000002) */
#define RGX_CR_CLK_XTPLUS_CTRL_TE3_SHIFT                  (4U)
#define RGX_CR_CLK_XTPLUS_CTRL_TE3_CLRMSK                 (IMG_UINT64_C(0XFFFFFFFFFFFFFFCF))
#define RGX_CR_CLK_XTPLUS_CTRL_TE3_OFF                    (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_XTPLUS_CTRL_TE3_ON                     (IMG_UINT64_C(0x0000000000000010))
#define RGX_CR_CLK_XTPLUS_CTRL_TE3_AUTO                   (IMG_UINT64_C(0x0000000000000020))
/* VCE default: AUTO (0x00000002) */
#define RGX_CR_CLK_XTPLUS_CTRL_VCE_SHIFT                  (2U)
#define RGX_CR_CLK_XTPLUS_CTRL_VCE_CLRMSK                 (IMG_UINT64_C(0XFFFFFFFFFFFFFFF3))
#define RGX_CR_CLK_XTPLUS_CTRL_VCE_OFF                    (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_XTPLUS_CTRL_VCE_ON                     (IMG_UINT64_C(0x0000000000000004))
#define RGX_CR_CLK_XTPLUS_CTRL_VCE_AUTO                   (IMG_UINT64_C(0x0000000000000008))
/* VBS default: AUTO (0x00000002) */
#define RGX_CR_CLK_XTPLUS_CTRL_VBS_SHIFT                  (0U)
#define RGX_CR_CLK_XTPLUS_CTRL_VBS_CLRMSK                 (IMG_UINT64_C(0XFFFFFFFFFFFFFFFC))
#define RGX_CR_CLK_XTPLUS_CTRL_VBS_OFF                    (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_XTPLUS_CTRL_VBS_ON                     (IMG_UINT64_C(0x0000000000000001))
#define RGX_CR_CLK_XTPLUS_CTRL_VBS_AUTO                   (IMG_UINT64_C(0x0000000000000002))


/*

	Reports the current module clock status


	Clock gating state reflects the condition of the clock for each module

*/
/*
    Register RGX_CR_CLK_XTPLUS_STATUS
*/
#define RGX_CR_CLK_XTPLUS_STATUS                          (0x0088U)
#define RGX_CR_CLK_XTPLUS_STATUS_MASKFULL                 (IMG_UINT64_C(0x000000000000007F))
/* UVB default: GATED (0x00000000) */
#define RGX_CR_CLK_XTPLUS_STATUS_UVB_SHIFT                (6U)
#define RGX_CR_CLK_XTPLUS_STATUS_UVB_CLRMSK               (IMG_UINT64_C(0XFFFFFFFFFFFFFFBF))
#define RGX_CR_CLK_XTPLUS_STATUS_UVB_GATED                (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_XTPLUS_STATUS_UVB_RUNNING              (IMG_UINT64_C(0x0000000000000040))
/* GPP default: GATED (0x00000000) */
#define RGX_CR_CLK_XTPLUS_STATUS_GPP_SHIFT                (5U)
#define RGX_CR_CLK_XTPLUS_STATUS_GPP_CLRMSK               (IMG_UINT64_C(0XFFFFFFFFFFFFFFDF))
#define RGX_CR_CLK_XTPLUS_STATUS_GPP_GATED                (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_XTPLUS_STATUS_GPP_RUNNING              (IMG_UINT64_C(0x0000000000000020))
/* VDM_PIPE default: GATED (0x00000000) */
#define RGX_CR_CLK_XTPLUS_STATUS_VDM_PIPE_SHIFT           (4U)
#define RGX_CR_CLK_XTPLUS_STATUS_VDM_PIPE_CLRMSK          (IMG_UINT64_C(0XFFFFFFFFFFFFFFEF))
#define RGX_CR_CLK_XTPLUS_STATUS_VDM_PIPE_GATED           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_XTPLUS_STATUS_VDM_PIPE_RUNNING         (IMG_UINT64_C(0x0000000000000010))
/* VDM default: GATED (0x00000000) */
#define RGX_CR_CLK_XTPLUS_STATUS_VDM_SHIFT                (3U)
#define RGX_CR_CLK_XTPLUS_STATUS_VDM_CLRMSK               (IMG_UINT64_C(0XFFFFFFFFFFFFFFF7))
#define RGX_CR_CLK_XTPLUS_STATUS_VDM_GATED                (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_XTPLUS_STATUS_VDM_RUNNING              (IMG_UINT64_C(0x0000000000000008))
/* TE3 default: GATED (0x00000000) */
#define RGX_CR_CLK_XTPLUS_STATUS_TE3_SHIFT                (2U)
#define RGX_CR_CLK_XTPLUS_STATUS_TE3_CLRMSK               (IMG_UINT64_C(0XFFFFFFFFFFFFFFFB))
#define RGX_CR_CLK_XTPLUS_STATUS_TE3_GATED                (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_XTPLUS_STATUS_TE3_RUNNING              (IMG_UINT64_C(0x0000000000000004))
/* VCE default: GATED (0x00000000) */
#define RGX_CR_CLK_XTPLUS_STATUS_VCE_SHIFT                (1U)
#define RGX_CR_CLK_XTPLUS_STATUS_VCE_CLRMSK               (IMG_UINT64_C(0XFFFFFFFFFFFFFFFD))
#define RGX_CR_CLK_XTPLUS_STATUS_VCE_GATED                (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_XTPLUS_STATUS_VCE_RUNNING              (IMG_UINT64_C(0x0000000000000002))
/* VBS default: GATED (0x00000000) */
#define RGX_CR_CLK_XTPLUS_STATUS_VBS_SHIFT                (0U)
#define RGX_CR_CLK_XTPLUS_STATUS_VBS_CLRMSK               (IMG_UINT64_C(0XFFFFFFFFFFFFFFFE))
#define RGX_CR_CLK_XTPLUS_STATUS_VBS_GATED                (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_XTPLUS_STATUS_VBS_RUNNING              (IMG_UINT64_C(0x0000000000000001))


/*

  Core soft reset control register.


	Write a '1' to reset and a '0' to clear
	See the soft reset section in the TRM to understand how to use the soft reset register.

*/
/*
    Register RGX_CR_SOFT_RESET
*/
#define RGX_CR_SOFT_RESET                                 (0x0100U)
#define RGX_CR_SOFT_RESET_MASKFULL                        (IMG_UINT64_C(0xFFE7FFFFFFFFFC1D))
#if defined(RGX_FEATURE_CLUSTER_GROUPING)
/* PHANTOM3_CORE*/
#define RGX_CR_SOFT_RESET_PHANTOM3_CORE_SHIFT             (63U)
#define RGX_CR_SOFT_RESET_PHANTOM3_CORE_CLRMSK            (IMG_UINT64_C(0X7FFFFFFFFFFFFFFF))
#define RGX_CR_SOFT_RESET_PHANTOM3_CORE_EN                (IMG_UINT64_C(0X8000000000000000))
/* PHANTOM2_CORE*/
#define RGX_CR_SOFT_RESET_PHANTOM2_CORE_SHIFT             (62U)
#define RGX_CR_SOFT_RESET_PHANTOM2_CORE_CLRMSK            (IMG_UINT64_C(0XBFFFFFFFFFFFFFFF))
#define RGX_CR_SOFT_RESET_PHANTOM2_CORE_EN                (IMG_UINT64_C(0X4000000000000000))
/* BERNADO2_CORE*/
#define RGX_CR_SOFT_RESET_BERNADO2_CORE_SHIFT             (61U)
#define RGX_CR_SOFT_RESET_BERNADO2_CORE_CLRMSK            (IMG_UINT64_C(0XDFFFFFFFFFFFFFFF))
#define RGX_CR_SOFT_RESET_BERNADO2_CORE_EN                (IMG_UINT64_C(0X2000000000000000))
#endif /* RGX_FEATURE_CLUSTER_GROUPING */

/* JONES_CORE*/
#define RGX_CR_SOFT_RESET_JONES_CORE_SHIFT                (60U)
#define RGX_CR_SOFT_RESET_JONES_CORE_CLRMSK               (IMG_UINT64_C(0XEFFFFFFFFFFFFFFF))
#define RGX_CR_SOFT_RESET_JONES_CORE_EN                   (IMG_UINT64_C(0X1000000000000000))
/* TILING_CORE*/
#define RGX_CR_SOFT_RESET_TILING_CORE_SHIFT               (59U)
#define RGX_CR_SOFT_RESET_TILING_CORE_CLRMSK              (IMG_UINT64_C(0XF7FFFFFFFFFFFFFF))
#define RGX_CR_SOFT_RESET_TILING_CORE_EN                  (IMG_UINT64_C(0X0800000000000000))
/* TE3*/
#define RGX_CR_SOFT_RESET_TE3_SHIFT                       (58U)
#define RGX_CR_SOFT_RESET_TE3_CLRMSK                      (IMG_UINT64_C(0XFBFFFFFFFFFFFFFF))
#define RGX_CR_SOFT_RESET_TE3_EN                          (IMG_UINT64_C(0X0400000000000000))
/* VCE*/
#define RGX_CR_SOFT_RESET_VCE_SHIFT                       (57U)
#define RGX_CR_SOFT_RESET_VCE_CLRMSK                      (IMG_UINT64_C(0XFDFFFFFFFFFFFFFF))
#define RGX_CR_SOFT_RESET_VCE_EN                          (IMG_UINT64_C(0X0200000000000000))
/* VBS*/
#define RGX_CR_SOFT_RESET_VBS_SHIFT                       (56U)
#define RGX_CR_SOFT_RESET_VBS_CLRMSK                      (IMG_UINT64_C(0XFEFFFFFFFFFFFFFF))
#define RGX_CR_SOFT_RESET_VBS_EN                          (IMG_UINT64_C(0X0100000000000000))
#if defined(RGX_FEATURE_RAY_TRACING)
/* DPX1_CORE*/
#define RGX_CR_SOFT_RESET_DPX1_CORE_SHIFT                 (55U)
#define RGX_CR_SOFT_RESET_DPX1_CORE_CLRMSK                (IMG_UINT64_C(0XFF7FFFFFFFFFFFFF))
#define RGX_CR_SOFT_RESET_DPX1_CORE_EN                    (IMG_UINT64_C(0X0080000000000000))
/* DPX0_CORE*/
#define RGX_CR_SOFT_RESET_DPX0_CORE_SHIFT                 (54U)
#define RGX_CR_SOFT_RESET_DPX0_CORE_CLRMSK                (IMG_UINT64_C(0XFFBFFFFFFFFFFFFF))
#define RGX_CR_SOFT_RESET_DPX0_CORE_EN                    (IMG_UINT64_C(0X0040000000000000))
/* FBA*/
#define RGX_CR_SOFT_RESET_FBA_SHIFT                       (53U)
#define RGX_CR_SOFT_RESET_FBA_CLRMSK                      (IMG_UINT64_C(0XFFDFFFFFFFFFFFFF))
#define RGX_CR_SOFT_RESET_FBA_EN                          (IMG_UINT64_C(0X0020000000000000))
/* SH*/
#define RGX_CR_SOFT_RESET_SH_SHIFT                        (50U)
#define RGX_CR_SOFT_RESET_SH_CLRMSK                       (IMG_UINT64_C(0XFFFBFFFFFFFFFFFF))
#define RGX_CR_SOFT_RESET_SH_EN                           (IMG_UINT64_C(0X0004000000000000))
/* VRDM*/
#define RGX_CR_SOFT_RESET_VRDM_SHIFT                      (49U)
#define RGX_CR_SOFT_RESET_VRDM_CLRMSK                     (IMG_UINT64_C(0XFFFDFFFFFFFFFFFF))
#define RGX_CR_SOFT_RESET_VRDM_EN                         (IMG_UINT64_C(0X0002000000000000))
#endif /* RGX_FEATURE_RAY_TRACING */

/* MCU_FBTC*/
#define RGX_CR_SOFT_RESET_MCU_FBTC_SHIFT                  (48U)
#define RGX_CR_SOFT_RESET_MCU_FBTC_CLRMSK                 (IMG_UINT64_C(0XFFFEFFFFFFFFFFFF))
#define RGX_CR_SOFT_RESET_MCU_FBTC_EN                     (IMG_UINT64_C(0X0001000000000000))
#if defined(RGX_FEATURE_CLUSTER_GROUPING)
/* PHANTOM1_CORE*/
#define RGX_CR_SOFT_RESET_PHANTOM1_CORE_SHIFT             (47U)
#define RGX_CR_SOFT_RESET_PHANTOM1_CORE_CLRMSK            (IMG_UINT64_C(0XFFFF7FFFFFFFFFFF))
#define RGX_CR_SOFT_RESET_PHANTOM1_CORE_EN                (IMG_UINT64_C(0X0000800000000000))
/* PHANTOM0_CORE*/
#define RGX_CR_SOFT_RESET_PHANTOM0_CORE_SHIFT             (46U)
#define RGX_CR_SOFT_RESET_PHANTOM0_CORE_CLRMSK            (IMG_UINT64_C(0XFFFFBFFFFFFFFFFF))
#define RGX_CR_SOFT_RESET_PHANTOM0_CORE_EN                (IMG_UINT64_C(0X0000400000000000))
/* BERNADO1_CORE*/
#define RGX_CR_SOFT_RESET_BERNADO1_CORE_SHIFT             (45U)
#define RGX_CR_SOFT_RESET_BERNADO1_CORE_CLRMSK            (IMG_UINT64_C(0XFFFFDFFFFFFFFFFF))
#define RGX_CR_SOFT_RESET_BERNADO1_CORE_EN                (IMG_UINT64_C(0X0000200000000000))
/* BERNADO0_CORE*/
#define RGX_CR_SOFT_RESET_BERNADO0_CORE_SHIFT             (44U)
#define RGX_CR_SOFT_RESET_BERNADO0_CORE_CLRMSK            (IMG_UINT64_C(0XFFFFEFFFFFFFFFFF))
#define RGX_CR_SOFT_RESET_BERNADO0_CORE_EN                (IMG_UINT64_C(0X0000100000000000))
/* IPP*/
#define RGX_CR_SOFT_RESET_IPP_SHIFT                       (43U)
#define RGX_CR_SOFT_RESET_IPP_CLRMSK                      (IMG_UINT64_C(0XFFFFF7FFFFFFFFFF))
#define RGX_CR_SOFT_RESET_IPP_EN                          (IMG_UINT64_C(0X0000080000000000))
/* BIF_TEXAS*/
#define RGX_CR_SOFT_RESET_BIF_TEXAS_SHIFT                 (42U)
#define RGX_CR_SOFT_RESET_BIF_TEXAS_CLRMSK                (IMG_UINT64_C(0XFFFFFBFFFFFFFFFF))
#define RGX_CR_SOFT_RESET_BIF_TEXAS_EN                    (IMG_UINT64_C(0X0000040000000000))
/* TORNADO_CORE*/
#define RGX_CR_SOFT_RESET_TORNADO_CORE_SHIFT              (41U)
#define RGX_CR_SOFT_RESET_TORNADO_CORE_CLRMSK             (IMG_UINT64_C(0XFFFFFDFFFFFFFFFF))
#define RGX_CR_SOFT_RESET_TORNADO_CORE_EN                 (IMG_UINT64_C(0X0000020000000000))
#endif /* RGX_FEATURE_CLUSTER_GROUPING */

/* DUST_H_CORE*/
#define RGX_CR_SOFT_RESET_DUST_H_CORE_SHIFT               (40U)
#define RGX_CR_SOFT_RESET_DUST_H_CORE_CLRMSK              (IMG_UINT64_C(0XFFFFFEFFFFFFFFFF))
#define RGX_CR_SOFT_RESET_DUST_H_CORE_EN                  (IMG_UINT64_C(0X0000010000000000))
/* DUST_G_CORE*/
#define RGX_CR_SOFT_RESET_DUST_G_CORE_SHIFT               (39U)
#define RGX_CR_SOFT_RESET_DUST_G_CORE_CLRMSK              (IMG_UINT64_C(0XFFFFFF7FFFFFFFFF))
#define RGX_CR_SOFT_RESET_DUST_G_CORE_EN                  (IMG_UINT64_C(0X0000008000000000))
/* DUST_F_CORE*/
#define RGX_CR_SOFT_RESET_DUST_F_CORE_SHIFT               (38U)
#define RGX_CR_SOFT_RESET_DUST_F_CORE_CLRMSK              (IMG_UINT64_C(0XFFFFFFBFFFFFFFFF))
#define RGX_CR_SOFT_RESET_DUST_F_CORE_EN                  (IMG_UINT64_C(0X0000004000000000))
/* DUST_E_CORE*/
#define RGX_CR_SOFT_RESET_DUST_E_CORE_SHIFT               (37U)
#define RGX_CR_SOFT_RESET_DUST_E_CORE_CLRMSK              (IMG_UINT64_C(0XFFFFFFDFFFFFFFFF))
#define RGX_CR_SOFT_RESET_DUST_E_CORE_EN                  (IMG_UINT64_C(0X0000002000000000))
/* DUST_D_CORE*/
#define RGX_CR_SOFT_RESET_DUST_D_CORE_SHIFT               (36U)
#define RGX_CR_SOFT_RESET_DUST_D_CORE_CLRMSK              (IMG_UINT64_C(0XFFFFFFEFFFFFFFFF))
#define RGX_CR_SOFT_RESET_DUST_D_CORE_EN                  (IMG_UINT64_C(0X0000001000000000))
/* DUST_C_CORE*/
#define RGX_CR_SOFT_RESET_DUST_C_CORE_SHIFT               (35U)
#define RGX_CR_SOFT_RESET_DUST_C_CORE_CLRMSK              (IMG_UINT64_C(0XFFFFFFF7FFFFFFFF))
#define RGX_CR_SOFT_RESET_DUST_C_CORE_EN                  (IMG_UINT64_C(0X0000000800000000))
/* MMU*/
#define RGX_CR_SOFT_RESET_MMU_SHIFT                       (34U)
#define RGX_CR_SOFT_RESET_MMU_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFBFFFFFFFF))
#define RGX_CR_SOFT_RESET_MMU_EN                          (IMG_UINT64_C(0X0000000400000000))
/* BIF1
Sidekick BIF
*/
#define RGX_CR_SOFT_RESET_BIF1_SHIFT                      (33U)
#define RGX_CR_SOFT_RESET_BIF1_CLRMSK                     (IMG_UINT64_C(0XFFFFFFFDFFFFFFFF))
#define RGX_CR_SOFT_RESET_BIF1_EN                         (IMG_UINT64_C(0X0000000200000000))
/* GARTEN
Includes MTS and META
*/
#define RGX_CR_SOFT_RESET_GARTEN_SHIFT                    (32U)
#define RGX_CR_SOFT_RESET_GARTEN_CLRMSK                   (IMG_UINT64_C(0XFFFFFFFEFFFFFFFF))
#define RGX_CR_SOFT_RESET_GARTEN_EN                       (IMG_UINT64_C(0X0000000100000000))
/* RASCAL_CORE
Note that the RASL_CORE bit affects logic related to the reading and writing of registers. This soft reset should therefore be used with caution. Upon power down events it is necessary to reset every register, so this bit should be used, but it must be release before any other resets, or beofre anyu other registers are programmed
*/
#define RGX_CR_SOFT_RESET_RASCAL_CORE_SHIFT               (31U)
#define RGX_CR_SOFT_RESET_RASCAL_CORE_CLRMSK              (IMG_UINT64_C(0XFFFFFFFF7FFFFFFF))
#define RGX_CR_SOFT_RESET_RASCAL_CORE_EN                  (IMG_UINT64_C(0X0000000080000000))
/* DUST_B_CORE*/
#define RGX_CR_SOFT_RESET_DUST_B_CORE_SHIFT               (30U)
#define RGX_CR_SOFT_RESET_DUST_B_CORE_CLRMSK              (IMG_UINT64_C(0XFFFFFFFFBFFFFFFF))
#define RGX_CR_SOFT_RESET_DUST_B_CORE_EN                  (IMG_UINT64_C(0X0000000040000000))
/* DUST_A_CORE*/
#define RGX_CR_SOFT_RESET_DUST_A_CORE_SHIFT               (29U)
#define RGX_CR_SOFT_RESET_DUST_A_CORE_CLRMSK              (IMG_UINT64_C(0XFFFFFFFFDFFFFFFF))
#define RGX_CR_SOFT_RESET_DUST_A_CORE_EN                  (IMG_UINT64_C(0X0000000020000000))
/* FB_TLCACHE*/
#define RGX_CR_SOFT_RESET_FB_TLCACHE_SHIFT                (28U)
#define RGX_CR_SOFT_RESET_FB_TLCACHE_CLRMSK               (IMG_UINT64_C(0XFFFFFFFFEFFFFFFF))
#define RGX_CR_SOFT_RESET_FB_TLCACHE_EN                   (IMG_UINT64_C(0X0000000010000000))
/* SLC*/
#define RGX_CR_SOFT_RESET_SLC_SHIFT                       (27U)
#define RGX_CR_SOFT_RESET_SLC_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFF7FFFFFF))
#define RGX_CR_SOFT_RESET_SLC_EN                          (IMG_UINT64_C(0X0000000008000000))
/* TLA*/
#define RGX_CR_SOFT_RESET_TLA_SHIFT                       (26U)
#define RGX_CR_SOFT_RESET_TLA_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFBFFFFFF))
#define RGX_CR_SOFT_RESET_TLA_EN                          (IMG_UINT64_C(0X0000000004000000))
/* UVS*/
#define RGX_CR_SOFT_RESET_UVS_SHIFT                       (25U)
#define RGX_CR_SOFT_RESET_UVS_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFDFFFFFF))
#define RGX_CR_SOFT_RESET_UVS_EN                          (IMG_UINT64_C(0X0000000002000000))
/* TE*/
#define RGX_CR_SOFT_RESET_TE_SHIFT                        (24U)
#define RGX_CR_SOFT_RESET_TE_CLRMSK                       (IMG_UINT64_C(0XFFFFFFFFFEFFFFFF))
#define RGX_CR_SOFT_RESET_TE_EN                           (IMG_UINT64_C(0X0000000001000000))
/* GPP*/
#define RGX_CR_SOFT_RESET_GPP_SHIFT                       (23U)
#define RGX_CR_SOFT_RESET_GPP_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFF7FFFFF))
#define RGX_CR_SOFT_RESET_GPP_EN                          (IMG_UINT64_C(0X0000000000800000))
/* FBDC*/
#define RGX_CR_SOFT_RESET_FBDC_SHIFT                      (22U)
#define RGX_CR_SOFT_RESET_FBDC_CLRMSK                     (IMG_UINT64_C(0XFFFFFFFFFFBFFFFF))
#define RGX_CR_SOFT_RESET_FBDC_EN                         (IMG_UINT64_C(0X0000000000400000))
/* FBC*/
#define RGX_CR_SOFT_RESET_FBC_SHIFT                       (21U)
#define RGX_CR_SOFT_RESET_FBC_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFDFFFFF))
#define RGX_CR_SOFT_RESET_FBC_EN                          (IMG_UINT64_C(0X0000000000200000))
/* PM*/
#define RGX_CR_SOFT_RESET_PM_SHIFT                        (20U)
#define RGX_CR_SOFT_RESET_PM_CLRMSK                       (IMG_UINT64_C(0XFFFFFFFFFFEFFFFF))
#define RGX_CR_SOFT_RESET_PM_EN                           (IMG_UINT64_C(0X0000000000100000))
/* PBE*/
#define RGX_CR_SOFT_RESET_PBE_SHIFT                       (19U)
#define RGX_CR_SOFT_RESET_PBE_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFF7FFFF))
#define RGX_CR_SOFT_RESET_PBE_EN                          (IMG_UINT64_C(0X0000000000080000))
/* USC_SHARED*/
#define RGX_CR_SOFT_RESET_USC_SHARED_SHIFT                (18U)
#define RGX_CR_SOFT_RESET_USC_SHARED_CLRMSK               (IMG_UINT64_C(0XFFFFFFFFFFFBFFFF))
#define RGX_CR_SOFT_RESET_USC_SHARED_EN                   (IMG_UINT64_C(0X0000000000040000))
/* MCU_L1*/
#define RGX_CR_SOFT_RESET_MCU_L1_SHIFT                    (17U)
#define RGX_CR_SOFT_RESET_MCU_L1_CLRMSK                   (IMG_UINT64_C(0XFFFFFFFFFFFDFFFF))
#define RGX_CR_SOFT_RESET_MCU_L1_EN                       (IMG_UINT64_C(0X0000000000020000))
/* BIF
Bifpmcache BIF
*/
#define RGX_CR_SOFT_RESET_BIF_SHIFT                       (16U)
#define RGX_CR_SOFT_RESET_BIF_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFEFFFF))
#define RGX_CR_SOFT_RESET_BIF_EN                          (IMG_UINT64_C(0X0000000000010000))
/* CDM*/
#define RGX_CR_SOFT_RESET_CDM_SHIFT                       (15U)
#define RGX_CR_SOFT_RESET_CDM_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFF7FFF))
#define RGX_CR_SOFT_RESET_CDM_EN                          (IMG_UINT64_C(0X0000000000008000))
/* VDM*/
#define RGX_CR_SOFT_RESET_VDM_SHIFT                       (14U)
#define RGX_CR_SOFT_RESET_VDM_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFBFFF))
#define RGX_CR_SOFT_RESET_VDM_EN                          (IMG_UINT64_C(0X0000000000004000))
/* TESS*/
#define RGX_CR_SOFT_RESET_TESS_SHIFT                      (13U)
#define RGX_CR_SOFT_RESET_TESS_CLRMSK                     (IMG_UINT64_C(0XFFFFFFFFFFFFDFFF))
#define RGX_CR_SOFT_RESET_TESS_EN                         (IMG_UINT64_C(0X0000000000002000))
/* PDS*/
#define RGX_CR_SOFT_RESET_PDS_SHIFT                       (12U)
#define RGX_CR_SOFT_RESET_PDS_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFEFFF))
#define RGX_CR_SOFT_RESET_PDS_EN                          (IMG_UINT64_C(0X0000000000001000))
/* ISP*/
#define RGX_CR_SOFT_RESET_ISP_SHIFT                       (11U)
#define RGX_CR_SOFT_RESET_ISP_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFF7FF))
#define RGX_CR_SOFT_RESET_ISP_EN                          (IMG_UINT64_C(0X0000000000000800))
/* TSP*/
#define RGX_CR_SOFT_RESET_TSP_SHIFT                       (10U)
#define RGX_CR_SOFT_RESET_TSP_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFFBFF))
#define RGX_CR_SOFT_RESET_TSP_EN                          (IMG_UINT64_C(0X0000000000000400))
/* TPU_MCU_DEMUX*/
#define RGX_CR_SOFT_RESET_TPU_MCU_DEMUX_SHIFT             (4U)
#define RGX_CR_SOFT_RESET_TPU_MCU_DEMUX_CLRMSK            (IMG_UINT64_C(0XFFFFFFFFFFFFFFEF))
#define RGX_CR_SOFT_RESET_TPU_MCU_DEMUX_EN                (IMG_UINT64_C(0X0000000000000010))
/* MCU_L0*/
#define RGX_CR_SOFT_RESET_MCU_L0_SHIFT                    (3U)
#define RGX_CR_SOFT_RESET_MCU_L0_CLRMSK                   (IMG_UINT64_C(0XFFFFFFFFFFFFFFF7))
#define RGX_CR_SOFT_RESET_MCU_L0_EN                       (IMG_UINT64_C(0X0000000000000008))
/* TPU*/
#define RGX_CR_SOFT_RESET_TPU_SHIFT                       (2U)
#define RGX_CR_SOFT_RESET_TPU_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFFFFB))
#define RGX_CR_SOFT_RESET_TPU_EN                          (IMG_UINT64_C(0X0000000000000004))
/* USC*/
#define RGX_CR_SOFT_RESET_USC_SHIFT                       (0U)
#define RGX_CR_SOFT_RESET_USC_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFFFFE))
#define RGX_CR_SOFT_RESET_USC_EN                          (IMG_UINT64_C(0X0000000000000001))


/*

  Core soft reset control register.


  Write a '1' to reset and a '0' to clear
  See the soft reset section in the TRM to understand how to use the soft reset register.

*/
/*
    Register RGX_CR_SOFT_RESET2
*/
#define RGX_CR_SOFT_RESET2                                (0x0108U)
#define RGX_CR_SOFT_RESET2_MASKFULL                       (IMG_UINT64_C(0x00000000000001FF))
/* USCPS*/
#define RGX_CR_SOFT_RESET2_USCPS_SHIFT                    (8U)
#define RGX_CR_SOFT_RESET2_USCPS_CLRMSK                   (0XFFFFFEFFU)
#define RGX_CR_SOFT_RESET2_USCPS_EN                       (0X00000100U)
/* IPF*/
#define RGX_CR_SOFT_RESET2_IPF_SHIFT                      (7U)
#define RGX_CR_SOFT_RESET2_IPF_CLRMSK                     (0XFFFFFF7FU)
#define RGX_CR_SOFT_RESET2_IPF_EN                         (0X00000080U)
/* GEOMETRY*/
#define RGX_CR_SOFT_RESET2_GEOMETRY_SHIFT                 (6U)
#define RGX_CR_SOFT_RESET2_GEOMETRY_CLRMSK                (0XFFFFFFBFU)
#define RGX_CR_SOFT_RESET2_GEOMETRY_EN                    (0X00000040U)
/* USC_SHARED*/
#define RGX_CR_SOFT_RESET2_USC_SHARED_SHIFT               (5U)
#define RGX_CR_SOFT_RESET2_USC_SHARED_CLRMSK              (0XFFFFFFDFU)
#define RGX_CR_SOFT_RESET2_USC_SHARED_EN                  (0X00000020U)
/* PDS_SHARED*/
#define RGX_CR_SOFT_RESET2_PDS_SHARED_SHIFT               (4U)
#define RGX_CR_SOFT_RESET2_PDS_SHARED_CLRMSK              (0XFFFFFFEFU)
#define RGX_CR_SOFT_RESET2_PDS_SHARED_EN                  (0X00000010U)
/* BIF_BLACKPEARL*/
#define RGX_CR_SOFT_RESET2_BIF_BLACKPEARL_SHIFT           (3U)
#define RGX_CR_SOFT_RESET2_BIF_BLACKPEARL_CLRMSK          (0XFFFFFFF7U)
#define RGX_CR_SOFT_RESET2_BIF_BLACKPEARL_EN              (0X00000008U)
/* PIXEL*/
#define RGX_CR_SOFT_RESET2_PIXEL_SHIFT                    (2U)
#define RGX_CR_SOFT_RESET2_PIXEL_CLRMSK                   (0XFFFFFFFBU)
#define RGX_CR_SOFT_RESET2_PIXEL_EN                       (0X00000004U)
/* COMPUTE*/
#define RGX_CR_SOFT_RESET2_COMPUTE_SHIFT                  (1U)
#define RGX_CR_SOFT_RESET2_COMPUTE_CLRMSK                 (0XFFFFFFFDU)
#define RGX_CR_SOFT_RESET2_COMPUTE_EN                     (0X00000002U)
/* VERTEX*/
#define RGX_CR_SOFT_RESET2_VERTEX_SHIFT                   (0U)
#define RGX_CR_SOFT_RESET2_VERTEX_CLRMSK                  (0XFFFFFFFEU)
#define RGX_CR_SOFT_RESET2_VERTEX_EN                      (0X00000001U)


/*

	The event status register indicate the source of an interrupt generated by PowerVR RGX
	These events only schedule an interrupt context thread to run on META when the appropriate enables are set in RGX_CR_DMn_INTERRUPT_ENABLE

*/
/*
    Register RGX_CR_EVENT_STATUS
*/
#define RGX_CR_EVENT_STATUS                               (0x0130U)
#define RGX_CR_EVENT_STATUS_MASKFULL                      (IMG_UINT64_C(0x000000001FFEFFFF))
#if defined(RGX_FEATURE_RAY_TRACING)
/* DPX_OUT_OF_MEMORY
 The Doppler overflow FIFO in memory is full 
*/
#define RGX_CR_EVENT_STATUS_DPX_OUT_OF_MEMORY_SHIFT       (28U)
#define RGX_CR_EVENT_STATUS_DPX_OUT_OF_MEMORY_CLRMSK      (0XEFFFFFFFU)
#define RGX_CR_EVENT_STATUS_DPX_OUT_OF_MEMORY_EN          (0X10000000U)
/* DPX_MMU_PAGE_FAULT
 A Doppler MMU page fault has occurred 
*/
#define RGX_CR_EVENT_STATUS_DPX_MMU_PAGE_FAULT_SHIFT      (27U)
#define RGX_CR_EVENT_STATUS_DPX_MMU_PAGE_FAULT_CLRMSK     (0XF7FFFFFFU)
#define RGX_CR_EVENT_STATUS_DPX_MMU_PAGE_FAULT_EN         (0X08000000U)
/* RPM_OUT_OF_MEMORY
 The Ray Page Manager has run out of free pages 
*/
#define RGX_CR_EVENT_STATUS_RPM_OUT_OF_MEMORY_SHIFT       (26U)
#define RGX_CR_EVENT_STATUS_RPM_OUT_OF_MEMORY_CLRMSK      (0XFBFFFFFFU)
#define RGX_CR_EVENT_STATUS_RPM_OUT_OF_MEMORY_EN          (0X04000000U)
/* FBA_FC3_FINISHED
 All records for every attachment point of frame context 3 have been written out to memory 
*/
#define RGX_CR_EVENT_STATUS_FBA_FC3_FINISHED_SHIFT        (25U)
#define RGX_CR_EVENT_STATUS_FBA_FC3_FINISHED_CLRMSK       (0XFDFFFFFFU)
#define RGX_CR_EVENT_STATUS_FBA_FC3_FINISHED_EN           (0X02000000U)
/* FBA_FC2_FINISHED
 All records for every attachment point of frame context 2 have been written out to memory 
*/
#define RGX_CR_EVENT_STATUS_FBA_FC2_FINISHED_SHIFT        (24U)
#define RGX_CR_EVENT_STATUS_FBA_FC2_FINISHED_CLRMSK       (0XFEFFFFFFU)
#define RGX_CR_EVENT_STATUS_FBA_FC2_FINISHED_EN           (0X01000000U)
/* FBA_FC1_FINISHED
 All records for every attachment point of frame context 1 have been written out to memory 
*/
#define RGX_CR_EVENT_STATUS_FBA_FC1_FINISHED_SHIFT        (23U)
#define RGX_CR_EVENT_STATUS_FBA_FC1_FINISHED_CLRMSK       (0XFF7FFFFFU)
#define RGX_CR_EVENT_STATUS_FBA_FC1_FINISHED_EN           (0X00800000U)
/* FBA_FC0_FINISHED
 All records for every attachment point of frame context 0 have been written out to memory 
*/
#define RGX_CR_EVENT_STATUS_FBA_FC0_FINISHED_SHIFT        (22U)
#define RGX_CR_EVENT_STATUS_FBA_FC0_FINISHED_CLRMSK       (0XFFBFFFFFU)
#define RGX_CR_EVENT_STATUS_FBA_FC0_FINISHED_EN           (0X00400000U)
/* RDM_FC3_FINISHED
 All rays in frame context 3 have finished i.e RDM has encountered an interrupt command in the RT control stream 
*/
#define RGX_CR_EVENT_STATUS_RDM_FC3_FINISHED_SHIFT        (21U)
#define RGX_CR_EVENT_STATUS_RDM_FC3_FINISHED_CLRMSK       (0XFFDFFFFFU)
#define RGX_CR_EVENT_STATUS_RDM_FC3_FINISHED_EN           (0X00200000U)
/* RDM_FC2_FINISHED
 All rays in frame context 2 have finished i.e RDM has encountered an interrupt command in the RT control stream 
*/
#define RGX_CR_EVENT_STATUS_RDM_FC2_FINISHED_SHIFT        (20U)
#define RGX_CR_EVENT_STATUS_RDM_FC2_FINISHED_CLRMSK       (0XFFEFFFFFU)
#define RGX_CR_EVENT_STATUS_RDM_FC2_FINISHED_EN           (0X00100000U)
/* RDM_FC1_FINISHED
 All rays in frame context 1 have finished i.e RDM has encountered an interrupt command in the RT control stream 
*/
#define RGX_CR_EVENT_STATUS_RDM_FC1_FINISHED_SHIFT        (19U)
#define RGX_CR_EVENT_STATUS_RDM_FC1_FINISHED_CLRMSK       (0XFFF7FFFFU)
#define RGX_CR_EVENT_STATUS_RDM_FC1_FINISHED_EN           (0X00080000U)
/* RDM_FC0_FINISHED
 All rays in frame context 0 have finished i.e RDM has encountered an interrupt command in the RT control stream 
*/
#define RGX_CR_EVENT_STATUS_RDM_FC0_FINISHED_SHIFT        (18U)
#define RGX_CR_EVENT_STATUS_RDM_FC0_FINISHED_CLRMSK       (0XFFFBFFFFU)
#define RGX_CR_EVENT_STATUS_RDM_FC0_FINISHED_EN           (0X00040000U)
/* SHG_FINISHED
 SHG has completed the hierarchical voxelisation process and memory has been written 
*/
#define RGX_CR_EVENT_STATUS_SHG_FINISHED_SHIFT            (17U)
#define RGX_CR_EVENT_STATUS_SHG_FINISHED_CLRMSK           (0XFFFDFFFFU)
#define RGX_CR_EVENT_STATUS_SHG_FINISHED_EN               (0X00020000U)
#endif /* RGX_FEATURE_RAY_TRACING */

/* USC_TRIGGER
 One or more USC has executed a nop.trigger instruction 
*/
#define RGX_CR_EVENT_STATUS_USC_TRIGGER_SHIFT             (15U)
#define RGX_CR_EVENT_STATUS_USC_TRIGGER_CLRMSK            (0XFFFF7FFFU)
#define RGX_CR_EVENT_STATUS_USC_TRIGGER_EN                (0X00008000U)
/* ZLS_FINISHED
 ZLS has finished all tiles in a Render 
*/
#define RGX_CR_EVENT_STATUS_ZLS_FINISHED_SHIFT            (14U)
#define RGX_CR_EVENT_STATUS_ZLS_FINISHED_CLRMSK           (0XFFFFBFFFU)
#define RGX_CR_EVENT_STATUS_ZLS_FINISHED_EN               (0X00004000U)
/* GPIO_ACK
 General Purpose ouput acknowledgement 
*/
#define RGX_CR_EVENT_STATUS_GPIO_ACK_SHIFT                (13U)
#define RGX_CR_EVENT_STATUS_GPIO_ACK_CLRMSK               (0XFFFFDFFFU)
#define RGX_CR_EVENT_STATUS_GPIO_ACK_EN                   (0X00002000U)
/* GPIO_REQ
 General Purpose input request 
*/
#define RGX_CR_EVENT_STATUS_GPIO_REQ_SHIFT                (12U)
#define RGX_CR_EVENT_STATUS_GPIO_REQ_CLRMSK               (0XFFFFEFFFU)
#define RGX_CR_EVENT_STATUS_GPIO_REQ_EN                   (0X00001000U)
/* POWER_ABORT
 The requested power operation has been denied.
*/
#define RGX_CR_EVENT_STATUS_POWER_ABORT_SHIFT             (11U)
#define RGX_CR_EVENT_STATUS_POWER_ABORT_CLRMSK            (0XFFFFF7FFU)
#define RGX_CR_EVENT_STATUS_POWER_ABORT_EN                (0X00000800U)
/* POWER_COMPLETE
 The requested power operation has completed 
*/
#define RGX_CR_EVENT_STATUS_POWER_COMPLETE_SHIFT          (10U)
#define RGX_CR_EVENT_STATUS_POWER_COMPLETE_CLRMSK         (0XFFFFFBFFU)
#define RGX_CR_EVENT_STATUS_POWER_COMPLETE_EN             (0X00000400U)
/* MMU_PAGE_FAULT
 An MMU page fault has occurred 
*/
#define RGX_CR_EVENT_STATUS_MMU_PAGE_FAULT_SHIFT          (9U)
#define RGX_CR_EVENT_STATUS_MMU_PAGE_FAULT_CLRMSK         (0XFFFFFDFFU)
#define RGX_CR_EVENT_STATUS_MMU_PAGE_FAULT_EN             (0X00000200U)
/* PM_3D_MEM_FREE
 PM memory allocation completed for the current render 
*/
#define RGX_CR_EVENT_STATUS_PM_3D_MEM_FREE_SHIFT          (8U)
#define RGX_CR_EVENT_STATUS_PM_3D_MEM_FREE_CLRMSK         (0XFFFFFEFFU)
#define RGX_CR_EVENT_STATUS_PM_3D_MEM_FREE_EN             (0X00000100U)
/* PM_OUT_OF_MEMORY
 PM memory allocation failed for a macro-tile 
*/
#define RGX_CR_EVENT_STATUS_PM_OUT_OF_MEMORY_SHIFT        (7U)
#define RGX_CR_EVENT_STATUS_PM_OUT_OF_MEMORY_CLRMSK       (0XFFFFFF7FU)
#define RGX_CR_EVENT_STATUS_PM_OUT_OF_MEMORY_EN           (0X00000080U)
/* TA_TERMINATE
 The TE has aborted a macro tile after a failted PM allocation request 
*/
#define RGX_CR_EVENT_STATUS_TA_TERMINATE_SHIFT            (6U)
#define RGX_CR_EVENT_STATUS_TA_TERMINATE_CLRMSK           (0XFFFFFFBFU)
#define RGX_CR_EVENT_STATUS_TA_TERMINATE_EN               (0X00000040U)
/* TA_FINISHED
 The TA phase has completed 
*/
#define RGX_CR_EVENT_STATUS_TA_FINISHED_SHIFT             (5U)
#define RGX_CR_EVENT_STATUS_TA_FINISHED_CLRMSK            (0XFFFFFFDFU)
#define RGX_CR_EVENT_STATUS_TA_FINISHED_EN                (0X00000020U)
/* ISP_END_MACROTILE
 ISP End-of-Macrotile 
*/
#define RGX_CR_EVENT_STATUS_ISP_END_MACROTILE_SHIFT       (4U)
#define RGX_CR_EVENT_STATUS_ISP_END_MACROTILE_CLRMSK      (0XFFFFFFEFU)
#define RGX_CR_EVENT_STATUS_ISP_END_MACROTILE_EN          (0X00000010U)
/* PIXELBE_END_RENDER
 The 3D phase has completed 
*/
#define RGX_CR_EVENT_STATUS_PIXELBE_END_RENDER_SHIFT      (3U)
#define RGX_CR_EVENT_STATUS_PIXELBE_END_RENDER_CLRMSK     (0XFFFFFFF7U)
#define RGX_CR_EVENT_STATUS_PIXELBE_END_RENDER_EN         (0X00000008U)
/* COMPUTE_FINISHED
 The compute phase has completed 
*/
#define RGX_CR_EVENT_STATUS_COMPUTE_FINISHED_SHIFT        (2U)
#define RGX_CR_EVENT_STATUS_COMPUTE_FINISHED_CLRMSK       (0XFFFFFFFBU)
#define RGX_CR_EVENT_STATUS_COMPUTE_FINISHED_EN           (0X00000004U)
/* KERNEL_FINISHED
 A compute kernel has completed and updated the associated event object in external memory 
*/
#define RGX_CR_EVENT_STATUS_KERNEL_FINISHED_SHIFT         (1U)
#define RGX_CR_EVENT_STATUS_KERNEL_FINISHED_CLRMSK        (0XFFFFFFFDU)
#define RGX_CR_EVENT_STATUS_KERNEL_FINISHED_EN            (0X00000002U)
/* TLA_COMPLETE
 The 2D core has completed writing out all data to memory and it has received a complete signal from the memory interface 
*/
#define RGX_CR_EVENT_STATUS_TLA_COMPLETE_SHIFT            (0U)
#define RGX_CR_EVENT_STATUS_TLA_COMPLETE_CLRMSK           (0XFFFFFFFEU)
#define RGX_CR_EVENT_STATUS_TLA_COMPLETE_EN               (0X00000001U)


/*

	This register contains the value of a 48-bit internal timer.
	The timer runs continuously, and wraps at the top end.
	It counts 256 cycles at the core clock frequency.


	This means that at 100 MHz:
	1 count value = 1/100MHz = 256 * 10 * 10^-9 seconds = 2.56 us

	In order to avoid having to issue three 32-bit reads to detect the lower 32-bits wrapping, the MSB of the low 32-bit word is duplicated in the MSB of the high 32-bit word.

*/
/*
    Register RGX_CR_TIMER
*/
#define RGX_CR_TIMER                                      (0x0160U)
#define RGX_CR_TIMER_MASKFULL                             (IMG_UINT64_C(0x8000FFFFFFFFFFFF))
/* BIT31*/
#define RGX_CR_TIMER_BIT31_SHIFT                          (63U)
#define RGX_CR_TIMER_BIT31_CLRMSK                         (IMG_UINT64_C(0X7FFFFFFFFFFFFFFF))
#define RGX_CR_TIMER_BIT31_EN                             (IMG_UINT64_C(0X8000000000000000))
/* VALUE*/
#define RGX_CR_TIMER_VALUE_SHIFT                          (0U)
#define RGX_CR_TIMER_VALUE_CLRMSK                         (IMG_UINT64_C(0XFFFF000000000000))


/*
    Register RGX_CR_META_SP_MSLVDATAX
*/
#define RGX_CR_META_SP_MSLVDATAX                          (0x0A00U)
#define RGX_CR_META_SP_MSLVDATAX_MASKFULL                 (IMG_UINT64_C(0x00000000FFFFFFFF))
/* MSLVDATAX
This register holds the last data value read or written by the slave port
*/
#define RGX_CR_META_SP_MSLVDATAX_MSLVDATAX_SHIFT          (0U)
#define RGX_CR_META_SP_MSLVDATAX_MSLVDATAX_CLRMSK         (00000000U)


/*
    Register RGX_CR_META_SP_MSLVDATAT
*/
#define RGX_CR_META_SP_MSLVDATAT                          (0x0A08U)
#define RGX_CR_META_SP_MSLVDATAT_MASKFULL                 (IMG_UINT64_C(0x00000000FFFFFFFF))
/* MSLVDATAT
This register updates or returns the same value as MSLVDATAX. However each read/write transaction on this register also starts the corresponding transfer within the META Core
*/
#define RGX_CR_META_SP_MSLVDATAT_MSLVDATAT_SHIFT          (0U)
#define RGX_CR_META_SP_MSLVDATAT_MSLVDATAT_CLRMSK         (00000000U)


/*
    Register RGX_CR_META_SP_MSLVCTRL0
*/
#define RGX_CR_META_SP_MSLVCTRL0                          (0x0A10U)
#define RGX_CR_META_SP_MSLVCTRL0_MASKFULL                 (IMG_UINT64_C(0x00000000FFFFFFFF))
/* ADDR
32-bit byte address specifying the address at which the next read or write access should be made within the META core memory map.
*/
#define RGX_CR_META_SP_MSLVCTRL0_ADDR_SHIFT               (2U)
#define RGX_CR_META_SP_MSLVCTRL0_ADDR_CLRMSK              (0X00000003U)
/* AUTOINCR
Selects auto-increment addressing mode when set to 1. The address specified in ADDR (bits 31-2) will be incremented after each transaction is transmitted by the slave port.
*/
#define RGX_CR_META_SP_MSLVCTRL0_AUTOINCR_SHIFT           (1U)
#define RGX_CR_META_SP_MSLVCTRL0_AUTOINCR_CLRMSK          (0XFFFFFFFDU)
#define RGX_CR_META_SP_MSLVCTRL0_AUTOINCR_EN              (0X00000002U)
/* RD
If written with the value 1 a read to the address specified (see below) will be issued and this bit will clear back to zero once the read transaction is transmitted by the slave port.
*/
#define RGX_CR_META_SP_MSLVCTRL0_RD_SHIFT                 (0U)
#define RGX_CR_META_SP_MSLVCTRL0_RD_CLRMSK                (0XFFFFFFFEU)
#define RGX_CR_META_SP_MSLVCTRL0_RD_EN                    (0X00000001U)


/*
    Register RGX_CR_META_SP_MSLVCTRL1
*/
#define RGX_CR_META_SP_MSLVCTRL1                          (0x0A18U)
#define RGX_CR_META_SP_MSLVCTRL1_MASKFULL                 (IMG_UINT64_C(0x00000000F7F4003F))
/* DEFERRTHREAD
Deferred bus error thread ID. (Read only)
*/
#define RGX_CR_META_SP_MSLVCTRL1_DEFERRTHREAD_SHIFT       (30U)
#define RGX_CR_META_SP_MSLVCTRL1_DEFERRTHREAD_CLRMSK      (0X3FFFFFFFU)
/* LOCK2_INTERLOCK
Slave interface LOCK2 interlock active (Read only)
*/
#define RGX_CR_META_SP_MSLVCTRL1_LOCK2_INTERLOCK_SHIFT    (29U)
#define RGX_CR_META_SP_MSLVCTRL1_LOCK2_INTERLOCK_CLRMSK   (0XDFFFFFFFU)
#define RGX_CR_META_SP_MSLVCTRL1_LOCK2_INTERLOCK_EN       (0X20000000U)
/* ATOMIC_INTERLOCK
Atomic inter-lock active in MMU arbiter (Read only)
*/
#define RGX_CR_META_SP_MSLVCTRL1_ATOMIC_INTERLOCK_SHIFT   (28U)
#define RGX_CR_META_SP_MSLVCTRL1_ATOMIC_INTERLOCK_CLRMSK  (0XEFFFFFFFU)
#define RGX_CR_META_SP_MSLVCTRL1_ATOMIC_INTERLOCK_EN      (0X10000000U)
/* GBLPORT_IDLE
Global internal register access port idle (Read only)
*/
#define RGX_CR_META_SP_MSLVCTRL1_GBLPORT_IDLE_SHIFT       (26U)
#define RGX_CR_META_SP_MSLVCTRL1_GBLPORT_IDLE_CLRMSK      (0XFBFFFFFFU)
#define RGX_CR_META_SP_MSLVCTRL1_GBLPORT_IDLE_EN          (0X04000000U)
/* COREMEM_IDLE
Core memory update register idle (Read only)
*/
#define RGX_CR_META_SP_MSLVCTRL1_COREMEM_IDLE_SHIFT       (25U)
#define RGX_CR_META_SP_MSLVCTRL1_COREMEM_IDLE_CLRMSK      (0XFDFFFFFFU)
#define RGX_CR_META_SP_MSLVCTRL1_COREMEM_IDLE_EN          (0X02000000U)
/* READY
Slave port ready to issue a further read or write request (Read only)
*/
#define RGX_CR_META_SP_MSLVCTRL1_READY_SHIFT              (24U)
#define RGX_CR_META_SP_MSLVCTRL1_READY_CLRMSK             (0XFEFFFFFFU)
#define RGX_CR_META_SP_MSLVCTRL1_READY_EN                 (0X01000000U)
/* DEFERRID
Deferred bus error code (Read only)
*/
#define RGX_CR_META_SP_MSLVCTRL1_DEFERRID_SHIFT           (21U)
#define RGX_CR_META_SP_MSLVCTRL1_DEFERRID_CLRMSK          (0XFF1FFFFFU)
/* DEFERR
This bit is set to '1' when a slave access generated a deferred bus error. Writing '0' to this bit clears this flag. Once this flag is set to '1', further bus errors would be ignored until it is cleared.
*/
#define RGX_CR_META_SP_MSLVCTRL1_DEFERR_SHIFT             (20U)
#define RGX_CR_META_SP_MSLVCTRL1_DEFERR_CLRMSK            (0XFFEFFFFFU)
#define RGX_CR_META_SP_MSLVCTRL1_DEFERR_EN                (0X00100000U)
/* WR_ACTIVE
If set means that a write is still in progress within the META core, else zero if write(s) have completed (Read only)
*/
#define RGX_CR_META_SP_MSLVCTRL1_WR_ACTIVE_SHIFT          (18U)
#define RGX_CR_META_SP_MSLVCTRL1_WR_ACTIVE_CLRMSK         (0XFFFBFFFFU)
#define RGX_CR_META_SP_MSLVCTRL1_WR_ACTIVE_EN             (0X00040000U)
/* THREAD
Specifies the thread identifier to be issued on read or write transactions within the META core.
*/
#define RGX_CR_META_SP_MSLVCTRL1_THREAD_SHIFT             (4U)
#define RGX_CR_META_SP_MSLVCTRL1_THREAD_CLRMSK            (0XFFFFFFCFU)
/* TRANS_SIZE
Selects the transaction size (number of byte lanes) generated within the META core for writes or reads. The following sizes are currently supported, 0 - 32-bit, 1 - 16-bit, and 2 - 8-bit.
*/
#define RGX_CR_META_SP_MSLVCTRL1_TRANS_SIZE_SHIFT         (2U)
#define RGX_CR_META_SP_MSLVCTRL1_TRANS_SIZE_CLRMSK        (0XFFFFFFF3U)
/* BYTE_ROUND
Byte routing/shift to be applied to data transfers performed on the MSLVDATAX and MSLVDATAT registers. Data will be duplicated in either direction so that 8-bit or 16-bit read or write operations can be performed using the lower part of the slave interface data bus.
*/
#define RGX_CR_META_SP_MSLVCTRL1_BYTE_ROUND_SHIFT         (0U)
#define RGX_CR_META_SP_MSLVCTRL1_BYTE_ROUND_CLRMSK        (0XFFFFFFFCU)


/*
    Register RGX_CR_META_SP_MSLVHANDSHKE
*/
#define RGX_CR_META_SP_MSLVHANDSHKE                       (0x0A50U)
#define RGX_CR_META_SP_MSLVHANDSHKE_MASKFULL              (IMG_UINT64_C(0x000000000000000F))
/* INPUT
JTAG GPIO Input. Used for S/W handshake with the JTAG port.
*/
#define RGX_CR_META_SP_MSLVHANDSHKE_INPUT_SHIFT           (2U)
#define RGX_CR_META_SP_MSLVHANDSHKE_INPUT_CLRMSK          (0XFFFFFFF3U)
/* OUTPUT
JTAG GPIO Output. Used for S/W handshake with the JTAG port.
*/
#define RGX_CR_META_SP_MSLVHANDSHKE_OUTPUT_SHIFT          (0U)
#define RGX_CR_META_SP_MSLVHANDSHKE_OUTPUT_CLRMSK         (0XFFFFFFFCU)


/*
    Register RGX_CR_META_SP_MSLVT0KICK
*/
#define RGX_CR_META_SP_MSLVT0KICK                         (0x0A80U)
#define RGX_CR_META_SP_MSLVT0KICK_MASKFULL                (IMG_UINT64_C(0x000000000000FFFF))
/* MSLVT0KICK
Writing the unsigned integer value n to the bottom 16-bits of this register will cause n kicks to be accumulated by thread 0's 16-bit background kick accumulator. For read these bits are always read as '0' as this register is merely a conduit and has no associated store.
*/
#define RGX_CR_META_SP_MSLVT0KICK_MSLVT0KICK_SHIFT        (0U)
#define RGX_CR_META_SP_MSLVT0KICK_MSLVT0KICK_CLRMSK       (0XFFFF0000U)


/*
    Register RGX_CR_META_SP_MSLVT0KICKI
*/
#define RGX_CR_META_SP_MSLVT0KICKI                        (0x0A88U)
#define RGX_CR_META_SP_MSLVT0KICKI_MASKFULL               (IMG_UINT64_C(0x000000000000FFFF))
/* MSLVT0KICKI
Writing the unsigned integer value n to the bottom 16-bits of this register will cause n kicks to be accumulated by thread 0's 16-bit interrupt kick accumulator. For read these bits are always read as '0' as this register is merely a conduit and has no associated store.
*/
#define RGX_CR_META_SP_MSLVT0KICKI_MSLVT0KICKI_SHIFT      (0U)
#define RGX_CR_META_SP_MSLVT0KICKI_MSLVT0KICKI_CLRMSK     (0XFFFF0000U)


/*
    Register RGX_CR_META_SP_MSLVT1KICK
*/
#define RGX_CR_META_SP_MSLVT1KICK                         (0x0A90U)
#define RGX_CR_META_SP_MSLVT1KICK_MASKFULL                (IMG_UINT64_C(0x000000000000FFFF))
/* MSLVT1KICK
same behavior as MSLVT0KICK, but for thread1
*/
#define RGX_CR_META_SP_MSLVT1KICK_MSLVT1KICK_SHIFT        (0U)
#define RGX_CR_META_SP_MSLVT1KICK_MSLVT1KICK_CLRMSK       (0XFFFF0000U)


/*
    Register RGX_CR_META_SP_MSLVT1KICKI
*/
#define RGX_CR_META_SP_MSLVT1KICKI                        (0x0A98U)
#define RGX_CR_META_SP_MSLVT1KICKI_MASKFULL               (IMG_UINT64_C(0x000000000000FFFF))
/* MSLVT1KICKI
same behavior as MSLVT0KICKI, but for thread1
*/
#define RGX_CR_META_SP_MSLVT1KICKI_MSLVT1KICKI_SHIFT      (0U)
#define RGX_CR_META_SP_MSLVT1KICKI_MSLVT1KICKI_CLRMSK     (0XFFFF0000U)


/*
    Register RGX_CR_META_SP_MSLVT2KICK
*/
#define RGX_CR_META_SP_MSLVT2KICK                         (0x0AA0U)
#define RGX_CR_META_SP_MSLVT2KICK_MASKFULL                (IMG_UINT64_C(0x000000000000FFFF))
/* MSLVT2KICK
same behavior as MSLVT0KICK, but for thread2
*/
#define RGX_CR_META_SP_MSLVT2KICK_MSLVT2KICK_SHIFT        (0U)
#define RGX_CR_META_SP_MSLVT2KICK_MSLVT2KICK_CLRMSK       (0XFFFF0000U)


/*
    Register RGX_CR_META_SP_MSLVT2KICKI
*/
#define RGX_CR_META_SP_MSLVT2KICKI                        (0x0AA8U)
#define RGX_CR_META_SP_MSLVT2KICKI_MASKFULL               (IMG_UINT64_C(0x000000000000FFFF))
/* MSLVT2KICKI
same behavior as MSLVT0KICKI, but for thread2
*/
#define RGX_CR_META_SP_MSLVT2KICKI_MSLVT2KICKI_SHIFT      (0U)
#define RGX_CR_META_SP_MSLVT2KICKI_MSLVT2KICKI_CLRMSK     (0XFFFF0000U)


/*
    Register RGX_CR_META_SP_MSLVT3KICK
*/
#define RGX_CR_META_SP_MSLVT3KICK                         (0x0AB0U)
#define RGX_CR_META_SP_MSLVT3KICK_MASKFULL                (IMG_UINT64_C(0x000000000000FFFF))
/* MSLVT3KICK
same behavior as MSLVT0KICK, but for thread3
*/
#define RGX_CR_META_SP_MSLVT3KICK_MSLVT3KICK_SHIFT        (0U)
#define RGX_CR_META_SP_MSLVT3KICK_MSLVT3KICK_CLRMSK       (0XFFFF0000U)


/*
    Register RGX_CR_META_SP_MSLVT3KICKI
*/
#define RGX_CR_META_SP_MSLVT3KICKI                        (0x0AB8U)
#define RGX_CR_META_SP_MSLVT3KICKI_MASKFULL               (IMG_UINT64_C(0x000000000000FFFF))
/* MSLVT3KICKI
same behavior as MSLVT0KICKI, but for thread3
*/
#define RGX_CR_META_SP_MSLVT3KICKI_MSLVT3KICKI_SHIFT      (0U)
#define RGX_CR_META_SP_MSLVT3KICKI_MSLVT3KICKI_CLRMSK     (0XFFFF0000U)


/*
    Register RGX_CR_META_SP_MSLVRST
*/
#define RGX_CR_META_SP_MSLVRST                            (0x0AC0U)
#define RGX_CR_META_SP_MSLVRST_MASKFULL                   (IMG_UINT64_C(0x0000000000000001))
/* SOFTRESET
This write only bit may be used to soft reset the core.  If a value of '1' is written to bit 0 the core will be held in reset.  The register must subsequently be cleared again to take the core out of reset. To ensure correct operation the core must be held in reset for at least 16 core clock cycles.
*/
#define RGX_CR_META_SP_MSLVRST_SOFTRESET_SHIFT            (0U)
#define RGX_CR_META_SP_MSLVRST_SOFTRESET_CLRMSK           (0XFFFFFFFEU)
#define RGX_CR_META_SP_MSLVRST_SOFTRESET_EN               (0X00000001U)


/*
    Register RGX_CR_META_SP_MSLVIRQSTATUS
*/
#define RGX_CR_META_SP_MSLVIRQSTATUS                      (0x0AC8U)
#define RGX_CR_META_SP_MSLVIRQSTATUS_MASKFULL             (IMG_UINT64_C(0x000000000000000C))
/* TRIGVECT3
IRQ event occurred due to vectoring to an event inside META core to the host (set trigger vector to 3). This status bit can be written with '0' to clear the IRQ event
*/
#define RGX_CR_META_SP_MSLVIRQSTATUS_TRIGVECT3_SHIFT      (3U)
#define RGX_CR_META_SP_MSLVIRQSTATUS_TRIGVECT3_CLRMSK     (0XFFFFFFF7U)
#define RGX_CR_META_SP_MSLVIRQSTATUS_TRIGVECT3_EN         (0X00000008U)
/* TRIGVECT2
IRQ event occurred due to vectoring to an event inside META core to the host (set trigger vector to 2). This status bit can be written with '0' to clear the IRQ event.
*/
#define RGX_CR_META_SP_MSLVIRQSTATUS_TRIGVECT2_SHIFT      (2U)
#define RGX_CR_META_SP_MSLVIRQSTATUS_TRIGVECT2_CLRMSK     (0XFFFFFFFBU)
#define RGX_CR_META_SP_MSLVIRQSTATUS_TRIGVECT2_EN         (0X00000004U)


/*
    Register RGX_CR_META_SP_MSLVIRQENABLE
*/
#define RGX_CR_META_SP_MSLVIRQENABLE                      (0x0AD0U)
#define RGX_CR_META_SP_MSLVIRQENABLE_MASKFULL             (IMG_UINT64_C(0x000000000000000C))
/* EVENT1
Enable Slave interrupt event 1 to raise an output interrupt.
*/
#define RGX_CR_META_SP_MSLVIRQENABLE_EVENT1_SHIFT         (3U)
#define RGX_CR_META_SP_MSLVIRQENABLE_EVENT1_CLRMSK        (0XFFFFFFF7U)
#define RGX_CR_META_SP_MSLVIRQENABLE_EVENT1_EN            (0X00000008U)
/* EVENT0
Enable Slave interrupt event 0 to raise an output interrupt.
*/
#define RGX_CR_META_SP_MSLVIRQENABLE_EVENT0_SHIFT         (2U)
#define RGX_CR_META_SP_MSLVIRQENABLE_EVENT0_CLRMSK        (0XFFFFFFFBU)
#define RGX_CR_META_SP_MSLVIRQENABLE_EVENT0_EN            (0X00000004U)


/*
    Register RGX_CR_META_SP_MSLVIRQLEVEL
*/
#define RGX_CR_META_SP_MSLVIRQLEVEL                       (0x0AD8U)
#define RGX_CR_META_SP_MSLVIRQLEVEL_MASKFULL              (IMG_UINT64_C(0x0000000000000001))
/* MODE
Level or edge mode for the META core output triggers.
*/
#define RGX_CR_META_SP_MSLVIRQLEVEL_MODE_SHIFT            (0U)
#define RGX_CR_META_SP_MSLVIRQLEVEL_MODE_CLRMSK           (0XFFFFFFFEU)
#define RGX_CR_META_SP_MSLVIRQLEVEL_MODE_EN               (0X00000001U)


/*

   This register allows firmware tasks to be scheduled on the META (Garten) core.

*/
/*
    Register RGX_CR_MTS_SCHEDULE
*/
#define RGX_CR_MTS_SCHEDULE                               (0x0B00U)
#define RGX_CR_MTS_SCHEDULE_MASKFULL                      (IMG_UINT64_C(0x00000000000001FF))
/* HOST
Host Interrupte kick
*/
#define RGX_CR_MTS_SCHEDULE_HOST_SHIFT                    (8U)
#define RGX_CR_MTS_SCHEDULE_HOST_CLRMSK                   (0XFFFFFEFFU)
#define RGX_CR_MTS_SCHEDULE_HOST_BG_TIMER                 (00000000U)
#define RGX_CR_MTS_SCHEDULE_HOST_HOST                     (0X00000100U)
/* PRIORITY
DataMaster Priority
*/
#define RGX_CR_MTS_SCHEDULE_PRIORITY_SHIFT                (6U)
#define RGX_CR_MTS_SCHEDULE_PRIORITY_CLRMSK               (0XFFFFFF3FU)
#define RGX_CR_MTS_SCHEDULE_PRIORITY_PRT0                 (00000000U)
#define RGX_CR_MTS_SCHEDULE_PRIORITY_PRT1                 (0X00000040U)
#define RGX_CR_MTS_SCHEDULE_PRIORITY_PRT2                 (0X00000080U)
#define RGX_CR_MTS_SCHEDULE_PRIORITY_PRT3                 (0X000000C0U)
/* CONTEXT default: BGCTX (0x00000000) */
#define RGX_CR_MTS_SCHEDULE_CONTEXT_SHIFT                 (5U)
#define RGX_CR_MTS_SCHEDULE_CONTEXT_CLRMSK                (0XFFFFFFDFU)
#define RGX_CR_MTS_SCHEDULE_CONTEXT_BGCTX                 (00000000U)
#define RGX_CR_MTS_SCHEDULE_CONTEXT_INTCTX                (0X00000020U)
/* TASK default: NON_COUNTED (0x00000000) */
#define RGX_CR_MTS_SCHEDULE_TASK_SHIFT                    (4U)
#define RGX_CR_MTS_SCHEDULE_TASK_CLRMSK                   (0XFFFFFFEFU)
#define RGX_CR_MTS_SCHEDULE_TASK_NON_COUNTED              (00000000U)
#define RGX_CR_MTS_SCHEDULE_TASK_COUNTED                  (0X00000010U)
/* DM
DataMaster Type
*/
#define RGX_CR_MTS_SCHEDULE_DM_SHIFT                      (0U)
#define RGX_CR_MTS_SCHEDULE_DM_CLRMSK                     (0XFFFFFFF0U)
#define RGX_CR_MTS_SCHEDULE_DM_DM0                        (00000000U)
#define RGX_CR_MTS_SCHEDULE_DM_DM1                        (0X00000001U)
#define RGX_CR_MTS_SCHEDULE_DM_DM2                        (0X00000002U)
#define RGX_CR_MTS_SCHEDULE_DM_DM3                        (0X00000003U)
#define RGX_CR_MTS_SCHEDULE_DM_DM4                        (0X00000004U)
#define RGX_CR_MTS_SCHEDULE_DM_DM5                        (0X00000005U)
#define RGX_CR_MTS_SCHEDULE_DM_DM6                        (0X00000006U)
#define RGX_CR_MTS_SCHEDULE_DM_DM7                        (0X00000007U)
#define RGX_CR_MTS_SCHEDULE_DM_DM_ALL                     (0X0000000FU)


/*

   This register allows firmware tasks to be scheduled on the META (Garten) core.

*/
/*
    Register RGX_CR_MTS_SCHEDULE1
*/
#define RGX_CR_MTS_SCHEDULE1                              (0x10B00U)
#define RGX_CR_MTS_SCHEDULE1_MASKFULL                     (IMG_UINT64_C(0x00000000000001FF))
/* HOST
Host Interrupte kick
*/
#define RGX_CR_MTS_SCHEDULE1_HOST_SHIFT                   (8U)
#define RGX_CR_MTS_SCHEDULE1_HOST_CLRMSK                  (0XFFFFFEFFU)
#define RGX_CR_MTS_SCHEDULE1_HOST_BG_TIMER                (00000000U)
#define RGX_CR_MTS_SCHEDULE1_HOST_HOST                    (0X00000100U)
/* PRIORITY
DataMaster Priority
*/
#define RGX_CR_MTS_SCHEDULE1_PRIORITY_SHIFT               (6U)
#define RGX_CR_MTS_SCHEDULE1_PRIORITY_CLRMSK              (0XFFFFFF3FU)
#define RGX_CR_MTS_SCHEDULE1_PRIORITY_PRT0                (00000000U)
#define RGX_CR_MTS_SCHEDULE1_PRIORITY_PRT1                (0X00000040U)
#define RGX_CR_MTS_SCHEDULE1_PRIORITY_PRT2                (0X00000080U)
#define RGX_CR_MTS_SCHEDULE1_PRIORITY_PRT3                (0X000000C0U)
/* CONTEXT default: BGCTX (0x00000000) */
#define RGX_CR_MTS_SCHEDULE1_CONTEXT_SHIFT                (5U)
#define RGX_CR_MTS_SCHEDULE1_CONTEXT_CLRMSK               (0XFFFFFFDFU)
#define RGX_CR_MTS_SCHEDULE1_CONTEXT_BGCTX                (00000000U)
#define RGX_CR_MTS_SCHEDULE1_CONTEXT_INTCTX               (0X00000020U)
/* TASK default: NON_COUNTED (0x00000000) */
#define RGX_CR_MTS_SCHEDULE1_TASK_SHIFT                   (4U)
#define RGX_CR_MTS_SCHEDULE1_TASK_CLRMSK                  (0XFFFFFFEFU)
#define RGX_CR_MTS_SCHEDULE1_TASK_NON_COUNTED             (00000000U)
#define RGX_CR_MTS_SCHEDULE1_TASK_COUNTED                 (0X00000010U)
/* DM
DataMaster Type
*/
#define RGX_CR_MTS_SCHEDULE1_DM_SHIFT                     (0U)
#define RGX_CR_MTS_SCHEDULE1_DM_CLRMSK                    (0XFFFFFFF0U)
#define RGX_CR_MTS_SCHEDULE1_DM_DM0                       (00000000U)
#define RGX_CR_MTS_SCHEDULE1_DM_DM1                       (0X00000001U)
#define RGX_CR_MTS_SCHEDULE1_DM_DM2                       (0X00000002U)
#define RGX_CR_MTS_SCHEDULE1_DM_DM3                       (0X00000003U)
#define RGX_CR_MTS_SCHEDULE1_DM_DM4                       (0X00000004U)
#define RGX_CR_MTS_SCHEDULE1_DM_DM5                       (0X00000005U)
#define RGX_CR_MTS_SCHEDULE1_DM_DM6                       (0X00000006U)
#define RGX_CR_MTS_SCHEDULE1_DM_DM7                       (0X00000007U)
#define RGX_CR_MTS_SCHEDULE1_DM_DM_ALL                    (0X0000000FU)


/*

   This register allows firmware tasks to be scheduled on the META (Garten) core.

*/
/*
    Register RGX_CR_MTS_SCHEDULE2
*/
#define RGX_CR_MTS_SCHEDULE2                              (0x20B00U)
#define RGX_CR_MTS_SCHEDULE2_MASKFULL                     (IMG_UINT64_C(0x00000000000001FF))
/* HOST
Host Interrupte kick
*/
#define RGX_CR_MTS_SCHEDULE2_HOST_SHIFT                   (8U)
#define RGX_CR_MTS_SCHEDULE2_HOST_CLRMSK                  (0XFFFFFEFFU)
#define RGX_CR_MTS_SCHEDULE2_HOST_BG_TIMER                (00000000U)
#define RGX_CR_MTS_SCHEDULE2_HOST_HOST                    (0X00000100U)
/* PRIORITY
DataMaster Priority
*/
#define RGX_CR_MTS_SCHEDULE2_PRIORITY_SHIFT               (6U)
#define RGX_CR_MTS_SCHEDULE2_PRIORITY_CLRMSK              (0XFFFFFF3FU)
#define RGX_CR_MTS_SCHEDULE2_PRIORITY_PRT0                (00000000U)
#define RGX_CR_MTS_SCHEDULE2_PRIORITY_PRT1                (0X00000040U)
#define RGX_CR_MTS_SCHEDULE2_PRIORITY_PRT2                (0X00000080U)
#define RGX_CR_MTS_SCHEDULE2_PRIORITY_PRT3                (0X000000C0U)
/* CONTEXT default: BGCTX (0x00000000) */
#define RGX_CR_MTS_SCHEDULE2_CONTEXT_SHIFT                (5U)
#define RGX_CR_MTS_SCHEDULE2_CONTEXT_CLRMSK               (0XFFFFFFDFU)
#define RGX_CR_MTS_SCHEDULE2_CONTEXT_BGCTX                (00000000U)
#define RGX_CR_MTS_SCHEDULE2_CONTEXT_INTCTX               (0X00000020U)
/* TASK default: NON_COUNTED (0x00000000) */
#define RGX_CR_MTS_SCHEDULE2_TASK_SHIFT                   (4U)
#define RGX_CR_MTS_SCHEDULE2_TASK_CLRMSK                  (0XFFFFFFEFU)
#define RGX_CR_MTS_SCHEDULE2_TASK_NON_COUNTED             (00000000U)
#define RGX_CR_MTS_SCHEDULE2_TASK_COUNTED                 (0X00000010U)
/* DM
DataMaster Type
*/
#define RGX_CR_MTS_SCHEDULE2_DM_SHIFT                     (0U)
#define RGX_CR_MTS_SCHEDULE2_DM_CLRMSK                    (0XFFFFFFF0U)
#define RGX_CR_MTS_SCHEDULE2_DM_DM0                       (00000000U)
#define RGX_CR_MTS_SCHEDULE2_DM_DM1                       (0X00000001U)
#define RGX_CR_MTS_SCHEDULE2_DM_DM2                       (0X00000002U)
#define RGX_CR_MTS_SCHEDULE2_DM_DM3                       (0X00000003U)
#define RGX_CR_MTS_SCHEDULE2_DM_DM4                       (0X00000004U)
#define RGX_CR_MTS_SCHEDULE2_DM_DM5                       (0X00000005U)
#define RGX_CR_MTS_SCHEDULE2_DM_DM6                       (0X00000006U)
#define RGX_CR_MTS_SCHEDULE2_DM_DM7                       (0X00000007U)
#define RGX_CR_MTS_SCHEDULE2_DM_DM_ALL                    (0X0000000FU)


/*

   This register allows firmware tasks to be scheduled on the META (Garten) core.

*/
/*
    Register RGX_CR_MTS_SCHEDULE3
*/
#define RGX_CR_MTS_SCHEDULE3                              (0x30B00U)
#define RGX_CR_MTS_SCHEDULE3_MASKFULL                     (IMG_UINT64_C(0x00000000000001FF))
/* HOST
Host Interrupte kick
*/
#define RGX_CR_MTS_SCHEDULE3_HOST_SHIFT                   (8U)
#define RGX_CR_MTS_SCHEDULE3_HOST_CLRMSK                  (0XFFFFFEFFU)
#define RGX_CR_MTS_SCHEDULE3_HOST_BG_TIMER                (00000000U)
#define RGX_CR_MTS_SCHEDULE3_HOST_HOST                    (0X00000100U)
/* PRIORITY
DataMaster Priority
*/
#define RGX_CR_MTS_SCHEDULE3_PRIORITY_SHIFT               (6U)
#define RGX_CR_MTS_SCHEDULE3_PRIORITY_CLRMSK              (0XFFFFFF3FU)
#define RGX_CR_MTS_SCHEDULE3_PRIORITY_PRT0                (00000000U)
#define RGX_CR_MTS_SCHEDULE3_PRIORITY_PRT1                (0X00000040U)
#define RGX_CR_MTS_SCHEDULE3_PRIORITY_PRT2                (0X00000080U)
#define RGX_CR_MTS_SCHEDULE3_PRIORITY_PRT3                (0X000000C0U)
/* CONTEXT default: BGCTX (0x00000000) */
#define RGX_CR_MTS_SCHEDULE3_CONTEXT_SHIFT                (5U)
#define RGX_CR_MTS_SCHEDULE3_CONTEXT_CLRMSK               (0XFFFFFFDFU)
#define RGX_CR_MTS_SCHEDULE3_CONTEXT_BGCTX                (00000000U)
#define RGX_CR_MTS_SCHEDULE3_CONTEXT_INTCTX               (0X00000020U)
/* TASK default: NON_COUNTED (0x00000000) */
#define RGX_CR_MTS_SCHEDULE3_TASK_SHIFT                   (4U)
#define RGX_CR_MTS_SCHEDULE3_TASK_CLRMSK                  (0XFFFFFFEFU)
#define RGX_CR_MTS_SCHEDULE3_TASK_NON_COUNTED             (00000000U)
#define RGX_CR_MTS_SCHEDULE3_TASK_COUNTED                 (0X00000010U)
/* DM
DataMaster Type
*/
#define RGX_CR_MTS_SCHEDULE3_DM_SHIFT                     (0U)
#define RGX_CR_MTS_SCHEDULE3_DM_CLRMSK                    (0XFFFFFFF0U)
#define RGX_CR_MTS_SCHEDULE3_DM_DM0                       (00000000U)
#define RGX_CR_MTS_SCHEDULE3_DM_DM1                       (0X00000001U)
#define RGX_CR_MTS_SCHEDULE3_DM_DM2                       (0X00000002U)
#define RGX_CR_MTS_SCHEDULE3_DM_DM3                       (0X00000003U)
#define RGX_CR_MTS_SCHEDULE3_DM_DM4                       (0X00000004U)
#define RGX_CR_MTS_SCHEDULE3_DM_DM5                       (0X00000005U)
#define RGX_CR_MTS_SCHEDULE3_DM_DM6                       (0X00000006U)
#define RGX_CR_MTS_SCHEDULE3_DM_DM7                       (0X00000007U)
#define RGX_CR_MTS_SCHEDULE3_DM_DM_ALL                    (0X0000000FU)


/*

   This register allows firmware tasks to be scheduled on the META (Garten) core.

*/
/*
    Register RGX_CR_MTS_SCHEDULE4
*/
#define RGX_CR_MTS_SCHEDULE4                              (0x40B00U)
#define RGX_CR_MTS_SCHEDULE4_MASKFULL                     (IMG_UINT64_C(0x00000000000001FF))
/* HOST
Host Interrupte kick
*/
#define RGX_CR_MTS_SCHEDULE4_HOST_SHIFT                   (8U)
#define RGX_CR_MTS_SCHEDULE4_HOST_CLRMSK                  (0XFFFFFEFFU)
#define RGX_CR_MTS_SCHEDULE4_HOST_BG_TIMER                (00000000U)
#define RGX_CR_MTS_SCHEDULE4_HOST_HOST                    (0X00000100U)
/* PRIORITY
DataMaster Priority
*/
#define RGX_CR_MTS_SCHEDULE4_PRIORITY_SHIFT               (6U)
#define RGX_CR_MTS_SCHEDULE4_PRIORITY_CLRMSK              (0XFFFFFF3FU)
#define RGX_CR_MTS_SCHEDULE4_PRIORITY_PRT0                (00000000U)
#define RGX_CR_MTS_SCHEDULE4_PRIORITY_PRT1                (0X00000040U)
#define RGX_CR_MTS_SCHEDULE4_PRIORITY_PRT2                (0X00000080U)
#define RGX_CR_MTS_SCHEDULE4_PRIORITY_PRT3                (0X000000C0U)
/* CONTEXT default: BGCTX (0x00000000) */
#define RGX_CR_MTS_SCHEDULE4_CONTEXT_SHIFT                (5U)
#define RGX_CR_MTS_SCHEDULE4_CONTEXT_CLRMSK               (0XFFFFFFDFU)
#define RGX_CR_MTS_SCHEDULE4_CONTEXT_BGCTX                (00000000U)
#define RGX_CR_MTS_SCHEDULE4_CONTEXT_INTCTX               (0X00000020U)
/* TASK default: NON_COUNTED (0x00000000) */
#define RGX_CR_MTS_SCHEDULE4_TASK_SHIFT                   (4U)
#define RGX_CR_MTS_SCHEDULE4_TASK_CLRMSK                  (0XFFFFFFEFU)
#define RGX_CR_MTS_SCHEDULE4_TASK_NON_COUNTED             (00000000U)
#define RGX_CR_MTS_SCHEDULE4_TASK_COUNTED                 (0X00000010U)
/* DM
DataMaster Type
*/
#define RGX_CR_MTS_SCHEDULE4_DM_SHIFT                     (0U)
#define RGX_CR_MTS_SCHEDULE4_DM_CLRMSK                    (0XFFFFFFF0U)
#define RGX_CR_MTS_SCHEDULE4_DM_DM0                       (00000000U)
#define RGX_CR_MTS_SCHEDULE4_DM_DM1                       (0X00000001U)
#define RGX_CR_MTS_SCHEDULE4_DM_DM2                       (0X00000002U)
#define RGX_CR_MTS_SCHEDULE4_DM_DM3                       (0X00000003U)
#define RGX_CR_MTS_SCHEDULE4_DM_DM4                       (0X00000004U)
#define RGX_CR_MTS_SCHEDULE4_DM_DM5                       (0X00000005U)
#define RGX_CR_MTS_SCHEDULE4_DM_DM6                       (0X00000006U)
#define RGX_CR_MTS_SCHEDULE4_DM_DM7                       (0X00000007U)
#define RGX_CR_MTS_SCHEDULE4_DM_DM_ALL                    (0X0000000FU)


/*

   This register allows firmware tasks to be scheduled on the META (Garten) core.

*/
/*
    Register RGX_CR_MTS_SCHEDULE5
*/
#define RGX_CR_MTS_SCHEDULE5                              (0x50B00U)
#define RGX_CR_MTS_SCHEDULE5_MASKFULL                     (IMG_UINT64_C(0x00000000000001FF))
/* HOST
Host Interrupte kick
*/
#define RGX_CR_MTS_SCHEDULE5_HOST_SHIFT                   (8U)
#define RGX_CR_MTS_SCHEDULE5_HOST_CLRMSK                  (0XFFFFFEFFU)
#define RGX_CR_MTS_SCHEDULE5_HOST_BG_TIMER                (00000000U)
#define RGX_CR_MTS_SCHEDULE5_HOST_HOST                    (0X00000100U)
/* PRIORITY
DataMaster Priority
*/
#define RGX_CR_MTS_SCHEDULE5_PRIORITY_SHIFT               (6U)
#define RGX_CR_MTS_SCHEDULE5_PRIORITY_CLRMSK              (0XFFFFFF3FU)
#define RGX_CR_MTS_SCHEDULE5_PRIORITY_PRT0                (00000000U)
#define RGX_CR_MTS_SCHEDULE5_PRIORITY_PRT1                (0X00000040U)
#define RGX_CR_MTS_SCHEDULE5_PRIORITY_PRT2                (0X00000080U)
#define RGX_CR_MTS_SCHEDULE5_PRIORITY_PRT3                (0X000000C0U)
/* CONTEXT default: BGCTX (0x00000000) */
#define RGX_CR_MTS_SCHEDULE5_CONTEXT_SHIFT                (5U)
#define RGX_CR_MTS_SCHEDULE5_CONTEXT_CLRMSK               (0XFFFFFFDFU)
#define RGX_CR_MTS_SCHEDULE5_CONTEXT_BGCTX                (00000000U)
#define RGX_CR_MTS_SCHEDULE5_CONTEXT_INTCTX               (0X00000020U)
/* TASK default: NON_COUNTED (0x00000000) */
#define RGX_CR_MTS_SCHEDULE5_TASK_SHIFT                   (4U)
#define RGX_CR_MTS_SCHEDULE5_TASK_CLRMSK                  (0XFFFFFFEFU)
#define RGX_CR_MTS_SCHEDULE5_TASK_NON_COUNTED             (00000000U)
#define RGX_CR_MTS_SCHEDULE5_TASK_COUNTED                 (0X00000010U)
/* DM
DataMaster Type
*/
#define RGX_CR_MTS_SCHEDULE5_DM_SHIFT                     (0U)
#define RGX_CR_MTS_SCHEDULE5_DM_CLRMSK                    (0XFFFFFFF0U)
#define RGX_CR_MTS_SCHEDULE5_DM_DM0                       (00000000U)
#define RGX_CR_MTS_SCHEDULE5_DM_DM1                       (0X00000001U)
#define RGX_CR_MTS_SCHEDULE5_DM_DM2                       (0X00000002U)
#define RGX_CR_MTS_SCHEDULE5_DM_DM3                       (0X00000003U)
#define RGX_CR_MTS_SCHEDULE5_DM_DM4                       (0X00000004U)
#define RGX_CR_MTS_SCHEDULE5_DM_DM5                       (0X00000005U)
#define RGX_CR_MTS_SCHEDULE5_DM_DM6                       (0X00000006U)
#define RGX_CR_MTS_SCHEDULE5_DM_DM7                       (0X00000007U)
#define RGX_CR_MTS_SCHEDULE5_DM_DM_ALL                    (0X0000000FU)


/*

   This register allows firmware tasks to be scheduled on the META (Garten) core.

*/
/*
    Register RGX_CR_MTS_SCHEDULE6
*/
#define RGX_CR_MTS_SCHEDULE6                              (0x60B00U)
#define RGX_CR_MTS_SCHEDULE6_MASKFULL                     (IMG_UINT64_C(0x00000000000001FF))
/* HOST
Host Interrupte kick
*/
#define RGX_CR_MTS_SCHEDULE6_HOST_SHIFT                   (8U)
#define RGX_CR_MTS_SCHEDULE6_HOST_CLRMSK                  (0XFFFFFEFFU)
#define RGX_CR_MTS_SCHEDULE6_HOST_BG_TIMER                (00000000U)
#define RGX_CR_MTS_SCHEDULE6_HOST_HOST                    (0X00000100U)
/* PRIORITY
DataMaster Priority
*/
#define RGX_CR_MTS_SCHEDULE6_PRIORITY_SHIFT               (6U)
#define RGX_CR_MTS_SCHEDULE6_PRIORITY_CLRMSK              (0XFFFFFF3FU)
#define RGX_CR_MTS_SCHEDULE6_PRIORITY_PRT0                (00000000U)
#define RGX_CR_MTS_SCHEDULE6_PRIORITY_PRT1                (0X00000040U)
#define RGX_CR_MTS_SCHEDULE6_PRIORITY_PRT2                (0X00000080U)
#define RGX_CR_MTS_SCHEDULE6_PRIORITY_PRT3                (0X000000C0U)
/* CONTEXT default: BGCTX (0x00000000) */
#define RGX_CR_MTS_SCHEDULE6_CONTEXT_SHIFT                (5U)
#define RGX_CR_MTS_SCHEDULE6_CONTEXT_CLRMSK               (0XFFFFFFDFU)
#define RGX_CR_MTS_SCHEDULE6_CONTEXT_BGCTX                (00000000U)
#define RGX_CR_MTS_SCHEDULE6_CONTEXT_INTCTX               (0X00000020U)
/* TASK default: NON_COUNTED (0x00000000) */
#define RGX_CR_MTS_SCHEDULE6_TASK_SHIFT                   (4U)
#define RGX_CR_MTS_SCHEDULE6_TASK_CLRMSK                  (0XFFFFFFEFU)
#define RGX_CR_MTS_SCHEDULE6_TASK_NON_COUNTED             (00000000U)
#define RGX_CR_MTS_SCHEDULE6_TASK_COUNTED                 (0X00000010U)
/* DM
DataMaster Type
*/
#define RGX_CR_MTS_SCHEDULE6_DM_SHIFT                     (0U)
#define RGX_CR_MTS_SCHEDULE6_DM_CLRMSK                    (0XFFFFFFF0U)
#define RGX_CR_MTS_SCHEDULE6_DM_DM0                       (00000000U)
#define RGX_CR_MTS_SCHEDULE6_DM_DM1                       (0X00000001U)
#define RGX_CR_MTS_SCHEDULE6_DM_DM2                       (0X00000002U)
#define RGX_CR_MTS_SCHEDULE6_DM_DM3                       (0X00000003U)
#define RGX_CR_MTS_SCHEDULE6_DM_DM4                       (0X00000004U)
#define RGX_CR_MTS_SCHEDULE6_DM_DM5                       (0X00000005U)
#define RGX_CR_MTS_SCHEDULE6_DM_DM6                       (0X00000006U)
#define RGX_CR_MTS_SCHEDULE6_DM_DM7                       (0X00000007U)
#define RGX_CR_MTS_SCHEDULE6_DM_DM_ALL                    (0X0000000FU)


/*

   This register allows firmware tasks to be scheduled on the META (Garten) core.

*/
/*
    Register RGX_CR_MTS_SCHEDULE7
*/
#define RGX_CR_MTS_SCHEDULE7                              (0x70B00U)
#define RGX_CR_MTS_SCHEDULE7_MASKFULL                     (IMG_UINT64_C(0x00000000000001FF))
/* HOST
Host Interrupte kick
*/
#define RGX_CR_MTS_SCHEDULE7_HOST_SHIFT                   (8U)
#define RGX_CR_MTS_SCHEDULE7_HOST_CLRMSK                  (0XFFFFFEFFU)
#define RGX_CR_MTS_SCHEDULE7_HOST_BG_TIMER                (00000000U)
#define RGX_CR_MTS_SCHEDULE7_HOST_HOST                    (0X00000100U)
/* PRIORITY
DataMaster Priority
*/
#define RGX_CR_MTS_SCHEDULE7_PRIORITY_SHIFT               (6U)
#define RGX_CR_MTS_SCHEDULE7_PRIORITY_CLRMSK              (0XFFFFFF3FU)
#define RGX_CR_MTS_SCHEDULE7_PRIORITY_PRT0                (00000000U)
#define RGX_CR_MTS_SCHEDULE7_PRIORITY_PRT1                (0X00000040U)
#define RGX_CR_MTS_SCHEDULE7_PRIORITY_PRT2                (0X00000080U)
#define RGX_CR_MTS_SCHEDULE7_PRIORITY_PRT3                (0X000000C0U)
/* CONTEXT default: BGCTX (0x00000000) */
#define RGX_CR_MTS_SCHEDULE7_CONTEXT_SHIFT                (5U)
#define RGX_CR_MTS_SCHEDULE7_CONTEXT_CLRMSK               (0XFFFFFFDFU)
#define RGX_CR_MTS_SCHEDULE7_CONTEXT_BGCTX                (00000000U)
#define RGX_CR_MTS_SCHEDULE7_CONTEXT_INTCTX               (0X00000020U)
/* TASK default: NON_COUNTED (0x00000000) */
#define RGX_CR_MTS_SCHEDULE7_TASK_SHIFT                   (4U)
#define RGX_CR_MTS_SCHEDULE7_TASK_CLRMSK                  (0XFFFFFFEFU)
#define RGX_CR_MTS_SCHEDULE7_TASK_NON_COUNTED             (00000000U)
#define RGX_CR_MTS_SCHEDULE7_TASK_COUNTED                 (0X00000010U)
/* DM
DataMaster Type
*/
#define RGX_CR_MTS_SCHEDULE7_DM_SHIFT                     (0U)
#define RGX_CR_MTS_SCHEDULE7_DM_CLRMSK                    (0XFFFFFFF0U)
#define RGX_CR_MTS_SCHEDULE7_DM_DM0                       (00000000U)
#define RGX_CR_MTS_SCHEDULE7_DM_DM1                       (0X00000001U)
#define RGX_CR_MTS_SCHEDULE7_DM_DM2                       (0X00000002U)
#define RGX_CR_MTS_SCHEDULE7_DM_DM3                       (0X00000003U)
#define RGX_CR_MTS_SCHEDULE7_DM_DM4                       (0X00000004U)
#define RGX_CR_MTS_SCHEDULE7_DM_DM5                       (0X00000005U)
#define RGX_CR_MTS_SCHEDULE7_DM_DM6                       (0X00000006U)
#define RGX_CR_MTS_SCHEDULE7_DM_DM7                       (0X00000007U)
#define RGX_CR_MTS_SCHEDULE7_DM_DM_ALL                    (0X0000000FU)


#if defined(RGX_FEATURE_S7_TOP_INFRASTRUCTURE)
/*

   This register contains the configuration options for the Garten wrapper.

*/
/*
    Register RGX_CR_MTS_GARTEN_WRAPPER_CONFIG
*/
#define RGX_CR_MTS_GARTEN_WRAPPER_CONFIG                  (0x0B50U)
#define RGX_CR_MTS_GARTEN_WRAPPER_CONFIG_MASKFULL         (IMG_UINT64_C(0x000FF0FFFFFFF001))
/* FENCE_PC_BASE
Page Catalogue base address number to be used for fence requests
*/
#define RGX_CR_MTS_GARTEN_WRAPPER_CONFIG_FENCE_PC_BASE_SHIFT (44U)
#define RGX_CR_MTS_GARTEN_WRAPPER_CONFIG_FENCE_PC_BASE_CLRMSK (IMG_UINT64_C(0XFFF00FFFFFFFFFFF))
/* FENCE_ADDR
4k page address to be used for fence requests
*/
#define RGX_CR_MTS_GARTEN_WRAPPER_CONFIG_FENCE_ADDR_SHIFT (12U)
#define RGX_CR_MTS_GARTEN_WRAPPER_CONFIG_FENCE_ADDR_CLRMSK (IMG_UINT64_C(0XFFFFFF0000000FFF))
/* IDLE_CTRL default: MTS (0x00000001) */
#define RGX_CR_MTS_GARTEN_WRAPPER_CONFIG_IDLE_CTRL_SHIFT  (0U)
#define RGX_CR_MTS_GARTEN_WRAPPER_CONFIG_IDLE_CTRL_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFFFFFE))
#define RGX_CR_MTS_GARTEN_WRAPPER_CONFIG_IDLE_CTRL_META   (IMG_UINT64_C(0000000000000000))
#define RGX_CR_MTS_GARTEN_WRAPPER_CONFIG_IDLE_CTRL_MTS    (IMG_UINT64_C(0x0000000000000001))
#endif /* RGX_FEATURE_S7_TOP_INFRASTRUCTURE */ 


#if !defined(RGX_FEATURE_S7_TOP_INFRASTRUCTURE)
/*

   This register contains the configuration options for the Garten wrapper.

*/
/*
    Register RGX_CR_MTS_GARTEN_WRAPPER_CONFIG
*/
#define RGX_CR_MTS_GARTEN_WRAPPER_CONFIG                  (0x0B50U)
#define RGX_CR_MTS_GARTEN_WRAPPER_CONFIG_MASKFULL         (IMG_UINT64_C(0x0000FFFFFFFFF001))
/* FENCE_PC_BASE
Page Catalogue base address number to be used for fence requests
*/
#define RGX_CR_MTS_GARTEN_WRAPPER_CONFIG_FENCE_PC_BASE_SHIFT (44U)
#define RGX_CR_MTS_GARTEN_WRAPPER_CONFIG_FENCE_PC_BASE_CLRMSK (IMG_UINT64_C(0XFFFF0FFFFFFFFFFF))
/* FENCE_DM
Data master value to be used for fence requests
*/
#define RGX_CR_MTS_GARTEN_WRAPPER_CONFIG_FENCE_DM_SHIFT   (40U)
#define RGX_CR_MTS_GARTEN_WRAPPER_CONFIG_FENCE_DM_CLRMSK  (IMG_UINT64_C(0XFFFFF0FFFFFFFFFF))
/* FENCE_ADDR
4k page address to be used for fence requests
*/
#define RGX_CR_MTS_GARTEN_WRAPPER_CONFIG_FENCE_ADDR_SHIFT (12U)
#define RGX_CR_MTS_GARTEN_WRAPPER_CONFIG_FENCE_ADDR_CLRMSK (IMG_UINT64_C(0XFFFFFF0000000FFF))
/* IDLE_CTRL default: MTS (0x00000001) */
#define RGX_CR_MTS_GARTEN_WRAPPER_CONFIG_IDLE_CTRL_SHIFT  (0U)
#define RGX_CR_MTS_GARTEN_WRAPPER_CONFIG_IDLE_CTRL_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFFFFFE))
#define RGX_CR_MTS_GARTEN_WRAPPER_CONFIG_IDLE_CTRL_META   (IMG_UINT64_C(0000000000000000))
#define RGX_CR_MTS_GARTEN_WRAPPER_CONFIG_IDLE_CTRL_MTS    (IMG_UINT64_C(0x0000000000000001))
#endif /* !defined(RGX_FEATURE_S7_TOP_INFRASTRUCTURE) */


/*
    Register RGX_CR_META_BOOT
*/
#define RGX_CR_META_BOOT                                  (0x0BF8U)
#define RGX_CR_META_BOOT_MASKFULL                         (IMG_UINT64_C(0x0000000000000001))
/* MODE
 0 = Don't boot, 1 = Boot
*/
#define RGX_CR_META_BOOT_MODE_SHIFT                       (0U)
#define RGX_CR_META_BOOT_MODE_CLRMSK                      (0XFFFFFFFEU)
#define RGX_CR_META_BOOT_MODE_EN                          (0X00000001U)


/*
    Register RGX_CR_GARTEN_SLC
*/
#define RGX_CR_GARTEN_SLC                                 (0x0BB8U)
#define RGX_CR_GARTEN_SLC_MASKFULL                        (IMG_UINT64_C(0x0000000000000001))
/* FORCE_COHERENCY default: 0x00000001
 0 = SLC control, 1 = SLC Coherency Forced
*/
#define RGX_CR_GARTEN_SLC_FORCE_COHERENCY_SHIFT           (0U)
#define RGX_CR_GARTEN_SLC_FORCE_COHERENCY_CLRMSK          (0XFFFFFFFEU)
#define RGX_CR_GARTEN_SLC_FORCE_COHERENCY_EN              (0X00000001U)

/*
    Register RGX_CR_BIF_MMU_ENTRY_STATUS
*/
#define RGX_CR_BIF_MMU_ENTRY_STATUS                       (0x1288U)
#define RGX_CR_BIF_MMU_ENTRY_STATUS_MASKFULL              (IMG_UINT64_C(0x000000FFFFFFF0F3))

#define RGX_CR_BIF_MMU_ENTRY_STATUS_ADDRESS_SHIFT         (12U)
#define RGX_CR_BIF_MMU_ENTRY_STATUS_ADDRESS_CLRMSK        (IMG_UINT64_C(0XFFFFFF0000000FFF))

#define RGX_CR_BIF_MMU_ENTRY_STATUS_CAT_BASE_SHIFT        (4U)
#define RGX_CR_BIF_MMU_ENTRY_STATUS_CAT_BASE_CLRMSK       (IMG_UINT64_C(0XFFFFFFFFFFFFFF0F))

#define RGX_CR_BIF_MMU_ENTRY_STATUS_DATA_TYPE_SHIFT       (0U)
#define RGX_CR_BIF_MMU_ENTRY_STATUS_DATA_TYPE_CLRMSK      (IMG_UINT64_C(0XFFFFFFFFFFFFFFFC))

/*
    Register RGX_CR_BIF_MMU_ENTRY
*/
#define RGX_CR_BIF_MMU_ENTRY                              (0x1290U)
#define RGX_CR_BIF_MMU_ENTRY_MASKFULL                     (IMG_UINT64_C(0x0000000000000003))

#define RGX_CR_BIF_MMU_ENTRY_ENABLE_SHIFT                 (1U)
#define RGX_CR_BIF_MMU_ENTRY_ENABLE_CLRMSK                (0XFFFFFFFDU)
#define RGX_CR_BIF_MMU_ENTRY_ENABLE_EN                    (0X00000002U)

#define RGX_CR_BIF_MMU_ENTRY_PENDING_SHIFT                (0U)
#define RGX_CR_BIF_MMU_ENTRY_PENDING_CLRMSK               (0XFFFFFFFEU)
#define RGX_CR_BIF_MMU_ENTRY_PENDING_EN                   (0X00000001U)

/*
 Index registers per data master. Byte aligned fields to allow byte-masked access 
*/
/*
    Register RGX_CR_BIF_CAT_BASE_INDEX
*/
#define RGX_CR_BIF_CAT_BASE_INDEX                         (0x1240U)
#define RGX_CR_BIF_CAT_BASE_INDEX_MASKFULL                (IMG_UINT64_C(0x0007070707070707))
#if defined(RGX_FEATURE_RAY_TRACING)
/* RVTX
Catalogue base address for VRDM, SHF, SHG and RPM
*/
#define RGX_CR_BIF_CAT_BASE_INDEX_RVTX_SHIFT              (48U)
#define RGX_CR_BIF_CAT_BASE_INDEX_RVTX_CLRMSK             (IMG_UINT64_C(0XFFF8FFFFFFFFFFFF))
/* RAY
Catalogue base address for RDM and FBA
*/
#define RGX_CR_BIF_CAT_BASE_INDEX_RAY_SHIFT               (40U)
#define RGX_CR_BIF_CAT_BASE_INDEX_RAY_CLRMSK              (IMG_UINT64_C(0XFFFFF8FFFFFFFFFF))
#endif /* RGX_FEATURE_RAY_TRACING */

/* HOST
Catalogue Base number for HOST data master
*/
#define RGX_CR_BIF_CAT_BASE_INDEX_HOST_SHIFT              (32U)
#define RGX_CR_BIF_CAT_BASE_INDEX_HOST_CLRMSK             (IMG_UINT64_C(0XFFFFFFF8FFFFFFFF))
/* TLA
Catalogue Base number for TLA data master
*/
#define RGX_CR_BIF_CAT_BASE_INDEX_TLA_SHIFT               (24U)
#define RGX_CR_BIF_CAT_BASE_INDEX_TLA_CLRMSK              (IMG_UINT64_C(0XFFFFFFFFF8FFFFFF))
/* CDM
Catalogue Base number for CDM data master
*/
#define RGX_CR_BIF_CAT_BASE_INDEX_CDM_SHIFT               (16U)
#define RGX_CR_BIF_CAT_BASE_INDEX_CDM_CLRMSK              (IMG_UINT64_C(0XFFFFFFFFFFF8FFFF))
/* PIXEL
Catalogue Base number for PIXEL data master
*/
#define RGX_CR_BIF_CAT_BASE_INDEX_PIXEL_SHIFT             (8U)
#define RGX_CR_BIF_CAT_BASE_INDEX_PIXEL_CLRMSK            (IMG_UINT64_C(0XFFFFFFFFFFFFF8FF))
/* TA
Catalogue Base number for TA data master
*/
#define RGX_CR_BIF_CAT_BASE_INDEX_TA_SHIFT                (0U)
#define RGX_CR_BIF_CAT_BASE_INDEX_TA_CLRMSK               (IMG_UINT64_C(0XFFFFFFFFFFFFFFF8))


/*

Indicates a fault has occurred on bank 0 and provides details of fault

*/
/*
    Register RGX_CR_BIF_FAULT_BANK0_MMU_STATUS
*/
#define RGX_CR_BIF_FAULT_BANK0_MMU_STATUS                 (0x12B0U)
#define RGX_CR_BIF_FAULT_BANK0_MMU_STATUS_MASKFULL        (IMG_UINT64_C(0x000000000000F775))
/* CAT_BASE
Catalogue base address number
*/
#define RGX_CR_BIF_FAULT_BANK0_MMU_STATUS_CAT_BASE_SHIFT  (12U)
#define RGX_CR_BIF_FAULT_BANK0_MMU_STATUS_CAT_BASE_CLRMSK (0XFFFF0FFFU)
/* PAGE_SIZE
Page size
*/
#define RGX_CR_BIF_FAULT_BANK0_MMU_STATUS_PAGE_SIZE_SHIFT (8U)
#define RGX_CR_BIF_FAULT_BANK0_MMU_STATUS_PAGE_SIZE_CLRMSK (0XFFFFF8FFU)
/* DATA_TYPE
MMU data type that was invalid (on valid fault)
*/
#define RGX_CR_BIF_FAULT_BANK0_MMU_STATUS_DATA_TYPE_SHIFT (5U)
#define RGX_CR_BIF_FAULT_BANK0_MMU_STATUS_DATA_TYPE_CLRMSK (0XFFFFFF9FU)
/* FAULT_RO
Indicates read-only fault('1') or valid fault('0')
*/
#define RGX_CR_BIF_FAULT_BANK0_MMU_STATUS_FAULT_RO_SHIFT  (4U)
#define RGX_CR_BIF_FAULT_BANK0_MMU_STATUS_FAULT_RO_CLRMSK (0XFFFFFFEFU)
#define RGX_CR_BIF_FAULT_BANK0_MMU_STATUS_FAULT_RO_EN     (0X00000010U)
/* FAULT_PM_META_RO
Indicates pm/meta protected region fault
*/
#define RGX_CR_BIF_FAULT_BANK0_MMU_STATUS_FAULT_PM_META_RO_SHIFT (2U)
#define RGX_CR_BIF_FAULT_BANK0_MMU_STATUS_FAULT_PM_META_RO_CLRMSK (0XFFFFFFFBU)
#define RGX_CR_BIF_FAULT_BANK0_MMU_STATUS_FAULT_PM_META_RO_EN (0X00000004U)
/* FAULT
Indicates a fault has occured
*/
#define RGX_CR_BIF_FAULT_BANK0_MMU_STATUS_FAULT_SHIFT     (0U)
#define RGX_CR_BIF_FAULT_BANK0_MMU_STATUS_FAULT_CLRMSK    (0XFFFFFFFEU)
#define RGX_CR_BIF_FAULT_BANK0_MMU_STATUS_FAULT_EN        (0X00000001U)


/*

Provides details of the request that faulted on bank 0

*/
/*
    Register RGX_CR_BIF_FAULT_BANK0_REQ_STATUS
*/
#define RGX_CR_BIF_FAULT_BANK0_REQ_STATUS                 (0x12B8U)
#define RGX_CR_BIF_FAULT_BANK0_REQ_STATUS_MASKFULL        (IMG_UINT64_C(0x0007FFFFFFFFFFF0))
/* RNW*/
#define RGX_CR_BIF_FAULT_BANK0_REQ_STATUS_RNW_SHIFT       (50U)
#define RGX_CR_BIF_FAULT_BANK0_REQ_STATUS_RNW_CLRMSK      (IMG_UINT64_C(0XFFFBFFFFFFFFFFFF))
#define RGX_CR_BIF_FAULT_BANK0_REQ_STATUS_RNW_EN          (IMG_UINT64_C(0X0004000000000000))
/* TAG_SB*/
#define RGX_CR_BIF_FAULT_BANK0_REQ_STATUS_TAG_SB_SHIFT    (44U)
#define RGX_CR_BIF_FAULT_BANK0_REQ_STATUS_TAG_SB_CLRMSK   (IMG_UINT64_C(0XFFFC0FFFFFFFFFFF))
/* TAG_ID*/
#define RGX_CR_BIF_FAULT_BANK0_REQ_STATUS_TAG_ID_SHIFT    (40U)
#define RGX_CR_BIF_FAULT_BANK0_REQ_STATUS_TAG_ID_CLRMSK   (IMG_UINT64_C(0XFFFFF0FFFFFFFFFF))
/* ADDRESS*/
#define RGX_CR_BIF_FAULT_BANK0_REQ_STATUS_ADDRESS_SHIFT   (4U)
#define RGX_CR_BIF_FAULT_BANK0_REQ_STATUS_ADDRESS_CLRMSK  (IMG_UINT64_C(0XFFFFFF000000000F))
#define RGX_CR_BIF_FAULT_BANK0_REQ_STATUS_ADDRESS_ALIGNSHIFT (4U)
#define RGX_CR_BIF_FAULT_BANK0_REQ_STATUS_ADDRESS_ALIGNSIZE (16U)


/*

Indicates a fault has occurred on bank 1 and provides details of fault

*/
/*
    Register RGX_CR_BIF_FAULT_BANK1_MMU_STATUS
*/
#define RGX_CR_BIF_FAULT_BANK1_MMU_STATUS                 (0x12C0U)
#define RGX_CR_BIF_FAULT_BANK1_MMU_STATUS_MASKFULL        (IMG_UINT64_C(0x000000000000F775))
/* CAT_BASE
Catalogue base address number
*/
#define RGX_CR_BIF_FAULT_BANK1_MMU_STATUS_CAT_BASE_SHIFT  (12U)
#define RGX_CR_BIF_FAULT_BANK1_MMU_STATUS_CAT_BASE_CLRMSK (0XFFFF0FFFU)
/* PAGE_SIZE
Page size
*/
#define RGX_CR_BIF_FAULT_BANK1_MMU_STATUS_PAGE_SIZE_SHIFT (8U)
#define RGX_CR_BIF_FAULT_BANK1_MMU_STATUS_PAGE_SIZE_CLRMSK (0XFFFFF8FFU)
/* DATA_TYPE
MMU data type that was invalid (on valid fault)
*/
#define RGX_CR_BIF_FAULT_BANK1_MMU_STATUS_DATA_TYPE_SHIFT (5U)
#define RGX_CR_BIF_FAULT_BANK1_MMU_STATUS_DATA_TYPE_CLRMSK (0XFFFFFF9FU)
/* FAULT_RO
Indicates read-only fault('1') of valid fault('0')
*/
#define RGX_CR_BIF_FAULT_BANK1_MMU_STATUS_FAULT_RO_SHIFT  (4U)
#define RGX_CR_BIF_FAULT_BANK1_MMU_STATUS_FAULT_RO_CLRMSK (0XFFFFFFEFU)
#define RGX_CR_BIF_FAULT_BANK1_MMU_STATUS_FAULT_RO_EN     (0X00000010U)
/* FAULT_PM_META_RO
Indicates pm/meta protected region fault
*/
#define RGX_CR_BIF_FAULT_BANK1_MMU_STATUS_FAULT_PM_META_RO_SHIFT (2U)
#define RGX_CR_BIF_FAULT_BANK1_MMU_STATUS_FAULT_PM_META_RO_CLRMSK (0XFFFFFFFBU)
#define RGX_CR_BIF_FAULT_BANK1_MMU_STATUS_FAULT_PM_META_RO_EN (0X00000004U)
/* FAULT
Indicates a fault has occured
*/
#define RGX_CR_BIF_FAULT_BANK1_MMU_STATUS_FAULT_SHIFT     (0U)
#define RGX_CR_BIF_FAULT_BANK1_MMU_STATUS_FAULT_CLRMSK    (0XFFFFFFFEU)
#define RGX_CR_BIF_FAULT_BANK1_MMU_STATUS_FAULT_EN        (0X00000001U)


/*

Provides details of the request that faulted on bank 1

*/
/*
    Register RGX_CR_BIF_FAULT_BANK1_REQ_STATUS
*/
#define RGX_CR_BIF_FAULT_BANK1_REQ_STATUS                 (0x12C8U)
#define RGX_CR_BIF_FAULT_BANK1_REQ_STATUS_MASKFULL        (IMG_UINT64_C(0x0007FFFFFFFFFFF0))
/* RNW*/
#define RGX_CR_BIF_FAULT_BANK1_REQ_STATUS_RNW_SHIFT       (50U)
#define RGX_CR_BIF_FAULT_BANK1_REQ_STATUS_RNW_CLRMSK      (IMG_UINT64_C(0XFFFBFFFFFFFFFFFF))
#define RGX_CR_BIF_FAULT_BANK1_REQ_STATUS_RNW_EN          (IMG_UINT64_C(0X0004000000000000))
/* TAG_SB*/
#define RGX_CR_BIF_FAULT_BANK1_REQ_STATUS_TAG_SB_SHIFT    (44U)
#define RGX_CR_BIF_FAULT_BANK1_REQ_STATUS_TAG_SB_CLRMSK   (IMG_UINT64_C(0XFFFC0FFFFFFFFFFF))
/* TAG_ID*/
#define RGX_CR_BIF_FAULT_BANK1_REQ_STATUS_TAG_ID_SHIFT    (40U)
#define RGX_CR_BIF_FAULT_BANK1_REQ_STATUS_TAG_ID_CLRMSK   (IMG_UINT64_C(0XFFFFF0FFFFFFFFFF))
/* ADDRESS*/
#define RGX_CR_BIF_FAULT_BANK1_REQ_STATUS_ADDRESS_SHIFT   (4U)
#define RGX_CR_BIF_FAULT_BANK1_REQ_STATUS_ADDRESS_CLRMSK  (IMG_UINT64_C(0XFFFFFF000000000F))
#define RGX_CR_BIF_FAULT_BANK1_REQ_STATUS_ADDRESS_ALIGNSHIFT (4U)
#define RGX_CR_BIF_FAULT_BANK1_REQ_STATUS_ADDRESS_ALIGNSIZE (16U)


/*

Specifies physical address to read from in the event of a faulting read request from BIF1

*/
/*
    Register RGX_CR_BIF_FAULT_READ
*/
#define RGX_CR_BIF_FAULT_READ                             (0x13E0U)
#define RGX_CR_BIF_FAULT_READ_MASKFULL                    (IMG_UINT64_C(0x000000FFFFFFFFF0))
/* ADDRESS*/
#define RGX_CR_BIF_FAULT_READ_ADDRESS_SHIFT               (4U)
#define RGX_CR_BIF_FAULT_READ_ADDRESS_CLRMSK              (IMG_UINT64_C(0XFFFFFF000000000F))
#define RGX_CR_BIF_FAULT_READ_ADDRESS_ALIGNSHIFT          (4U)
#define RGX_CR_BIF_FAULT_READ_ADDRESS_ALIGNSIZE           (16U)


/*

Indicates a fault has occurred on bank 0 and provides details of fault

*/
/*
    Register RGX_CR_TEXAS_BIF_FAULT_BANK0_MMU_STATUS
*/
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_MMU_STATUS           (0x1430U)
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_MMU_STATUS_MASKFULL  (IMG_UINT64_C(0x000000000000F775))
/* CAT_BASE
Catalogue base address number
*/
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_MMU_STATUS_CAT_BASE_SHIFT (12U)
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_MMU_STATUS_CAT_BASE_CLRMSK (0XFFFF0FFFU)
/* PAGE_SIZE
Page size
*/
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_MMU_STATUS_PAGE_SIZE_SHIFT (8U)
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_MMU_STATUS_PAGE_SIZE_CLRMSK (0XFFFFF8FFU)
/* DATA_TYPE
MMU data type that was invalid (on valid fault)
*/
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_MMU_STATUS_DATA_TYPE_SHIFT (5U)
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_MMU_STATUS_DATA_TYPE_CLRMSK (0XFFFFFF9FU)
/* FAULT_RO
Indicates read-only fault('1') or valid fault('0')
*/
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_MMU_STATUS_FAULT_RO_SHIFT (4U)
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_MMU_STATUS_FAULT_RO_CLRMSK (0XFFFFFFEFU)
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_MMU_STATUS_FAULT_RO_EN (0X00000010U)
/* FAULT_PM_META_RO
Indicates pm/meta protected region fault
*/
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_MMU_STATUS_FAULT_PM_META_RO_SHIFT (2U)
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_MMU_STATUS_FAULT_PM_META_RO_CLRMSK (0XFFFFFFFBU)
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_MMU_STATUS_FAULT_PM_META_RO_EN (0X00000004U)
/* FAULT
Indicates a fault has occured
*/
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_MMU_STATUS_FAULT_SHIFT (0U)
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_MMU_STATUS_FAULT_CLRMSK (0XFFFFFFFEU)
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_MMU_STATUS_FAULT_EN  (0X00000001U)


/*

Provides details of the request that faulted on bank 0

*/
/*
    Register RGX_CR_TEXAS_BIF_FAULT_BANK0_REQ_STATUS
*/
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_REQ_STATUS           (0x1438U)
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_REQ_STATUS_MASKFULL  (IMG_UINT64_C(0x0007FFFFFFFFFFF0))
/* RNW*/
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_REQ_STATUS_RNW_SHIFT (50U)
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_REQ_STATUS_RNW_CLRMSK (IMG_UINT64_C(0XFFFBFFFFFFFFFFFF))
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_REQ_STATUS_RNW_EN    (IMG_UINT64_C(0X0004000000000000))
/* TAG_SB*/
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_REQ_STATUS_TAG_SB_SHIFT (44U)
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_REQ_STATUS_TAG_SB_CLRMSK (IMG_UINT64_C(0XFFFC0FFFFFFFFFFF))
/* TAG_ID*/
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_REQ_STATUS_TAG_ID_SHIFT (40U)
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_REQ_STATUS_TAG_ID_CLRMSK (IMG_UINT64_C(0XFFFFF0FFFFFFFFFF))
/* ADDRESS*/
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_REQ_STATUS_ADDRESS_SHIFT (4U)
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_REQ_STATUS_ADDRESS_CLRMSK (IMG_UINT64_C(0XFFFFFF000000000F))
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_REQ_STATUS_ADDRESS_ALIGNSHIFT (4U)
#define RGX_CR_TEXAS_BIF_FAULT_BANK0_REQ_STATUS_ADDRESS_ALIGNSIZE (16U)


/*

	SLC control registers

*/
/*
    Register RGX_CR_SLC_CTRL_MISC
*/
#define RGX_CR_SLC_CTRL_MISC                              (0x3800U)
#define RGX_CR_SLC_CTRL_MISC_MASKFULL                     (IMG_UINT64_C(0xFFFFFFFF00FF0105))
/* SCRAMBLE_BITS
 Pattern of bits used to determine the Cache Bank in Address Decode mode 0x21. The actual Cache Bank to use is determined by indexing into the 32 Scramble Bits using the 5 LSB's of the Hash result and then XORing this with Bit 6 of the incoming address to give a single bit result 
*/
#define RGX_CR_SLC_CTRL_MISC_SCRAMBLE_BITS_SHIFT          (32U)
#define RGX_CR_SLC_CTRL_MISC_SCRAMBLE_BITS_CLRMSK         (IMG_UINT64_C(0X00000000FFFFFFFF))
/* ADDR_DECODE_MODE default: INTERLEAVED_64_BYTE (0x00000000)
(null)
*/
#define RGX_CR_SLC_CTRL_MISC_ADDR_DECODE_MODE_SHIFT       (16U)
#define RGX_CR_SLC_CTRL_MISC_ADDR_DECODE_MODE_CLRMSK      (IMG_UINT64_C(0XFFFFFFFFFF00FFFF))
#define RGX_CR_SLC_CTRL_MISC_ADDR_DECODE_MODE_INTERLEAVED_64_BYTE (IMG_UINT64_C(0000000000000000))
#define RGX_CR_SLC_CTRL_MISC_ADDR_DECODE_MODE_INTERLEAVED_128_BYTE (IMG_UINT64_C(0x0000000000010000))
#define RGX_CR_SLC_CTRL_MISC_ADDR_DECODE_MODE_SIMPLE_HASH1 (IMG_UINT64_C(0x0000000000100000))
#define RGX_CR_SLC_CTRL_MISC_ADDR_DECODE_MODE_SIMPLE_HASH2 (IMG_UINT64_C(0x0000000000110000))
#define RGX_CR_SLC_CTRL_MISC_ADDR_DECODE_MODE_PVR_HASH1   (IMG_UINT64_C(0x0000000000200000))
#define RGX_CR_SLC_CTRL_MISC_ADDR_DECODE_MODE_PVR_HASH2_SCRAMBLE (IMG_UINT64_C(0x0000000000210000))
/* PAUSE
 Pause the SLC 
*/
#define RGX_CR_SLC_CTRL_MISC_PAUSE_SHIFT                  (8U)
#define RGX_CR_SLC_CTRL_MISC_PAUSE_CLRMSK                 (IMG_UINT64_C(0XFFFFFFFFFFFFFEFF))
#define RGX_CR_SLC_CTRL_MISC_PAUSE_EN                     (IMG_UINT64_C(0X0000000000000100))
/* ENABLE_LINE_USE_LIMIT
 Enable the use of cache line limits 
*/
#define RGX_CR_SLC_CTRL_MISC_ENABLE_LINE_USE_LIMIT_SHIFT  (2U)
#define RGX_CR_SLC_CTRL_MISC_ENABLE_LINE_USE_LIMIT_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFFFFFB))
#define RGX_CR_SLC_CTRL_MISC_ENABLE_LINE_USE_LIMIT_EN     (IMG_UINT64_C(0X0000000000000004))
/* BYPASS_BURST_COMBINER default: 0x00000001
 Disable the burst combiner on the external memory interface 
*/
#define RGX_CR_SLC_CTRL_MISC_BYPASS_BURST_COMBINER_SHIFT  (0U)
#define RGX_CR_SLC_CTRL_MISC_BYPASS_BURST_COMBINER_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFFFFFE))
#define RGX_CR_SLC_CTRL_MISC_BYPASS_BURST_COMBINER_EN     (IMG_UINT64_C(0X0000000000000001))


/*

	SLC Flush & Invalidate control.
	Note that per Data Master operations will flush any cache lines that have been made dirty by any writes from the specified Data Master.	Combined Invalidate operation then only invalidates entries that have been referenced solely by the specified Data Master, any cache lines referenced by multiple Data Masters will not be affected by a per Data Master invalidate operation and will remain valid.

*/
/*
    Register RGX_CR_SLC_CTRL_FLUSH_INVAL
*/
#define RGX_CR_SLC_CTRL_FLUSH_INVAL                       (0x3818U)
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_MASKFULL              (IMG_UINT64_C(0x00000000800007FF))
/* LAZY
 Advanced mode of operation whereby other requestors are not blocked whilst the Flush Invalidate is in progress
*/
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_LAZY_SHIFT            (31U)
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_LAZY_CLRMSK           (0X7FFFFFFFU)
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_LAZY_EN               (0X80000000U)
#if defined(RGX_FEATURE_RAY_TRACING)
/* DM_RAY_VERTEX
 When set, flush all SLC entries made dirty by the ray tracing VERTEX_RAY data master, then invalidate all SLC entries referenced solely by the ray tracing VERTEX_RAY
*/
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_RAY_VERTEX_SHIFT   (10U)
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_RAY_VERTEX_CLRMSK  (0XFFFFFBFFU)
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_RAY_VERTEX_EN      (0X00000400U)
/* DM_RAY
 When set, flush all SLC entries made dirty by the ray tracing RAY data master, then invalidate all SLC entries referenced solely by the ray tracing RAY
*/
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_RAY_SHIFT          (9U)
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_RAY_CLRMSK         (0XFFFFFDFFU)
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_RAY_EN             (0X00000200U)
#endif /* RGX_FEATURE_RAY_TRACING */

/* DM_FRC
 When set, flush all SLC entries made dirty by the FRC Video Core, then invalidate all SLC entries referenced solely by the FRC Video Core (Optional feature)
*/
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_FRC_SHIFT          (8U)
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_FRC_CLRMSK         (0XFFFFFEFFU)
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_FRC_EN             (0X00000100U)
/* DM_VXE
 When set, flush all SLC entries made dirty by the VXE Video Core, then invalidate all SLC entries referenced solely by the VXE Video Core (Optional feature)
*/
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_VXE_SHIFT          (7U)
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_VXE_CLRMSK         (0XFFFFFF7FU)
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_VXE_EN             (0X00000080U)
/* DM_VXD
 When set, flush all SLC entries made dirty by the VXD Video Core, then invalidate all SLC entries referenced solely by the VXD Video Core (Optional feature)
*/
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_VXD_SHIFT          (6U)
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_VXD_CLRMSK         (0XFFFFFFBFU)
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_VXD_EN             (0X00000040U)
/* DM_HOST_META
 When set, flush all SLC entries made dirty by the HOST or META, then invalidate all SLC entries referenced solely by the HOST or META 
*/
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_HOST_META_SHIFT    (5U)
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_HOST_META_CLRMSK   (0XFFFFFFDFU)
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_HOST_META_EN       (0X00000020U)
/* DM_MMU
 When set, flush all SLC entries made dirty by the MMU, then invalidate all SLC entries referenced solely by the MMU 
*/
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_MMU_SHIFT          (4U)
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_MMU_CLRMSK         (0XFFFFFFEFU)
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_MMU_EN             (0X00000010U)
/* DM_COMPUTE
 When set, flush all SLC entries made dirty by the COMPUTE data master, then invalidate all SLC entries referenced solely by the COMPUTE data master 
*/
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_COMPUTE_SHIFT      (3U)
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_COMPUTE_CLRMSK     (0XFFFFFFF7U)
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_COMPUTE_EN         (0X00000008U)
/* DM_PIXEL
 When set, flush all SLC entries made dirty by the PIXEL data master, then invalidate all SLC entries referenced solely by the PIXEL data master 
*/
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_PIXEL_SHIFT        (2U)
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_PIXEL_CLRMSK       (0XFFFFFFFBU)
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_PIXEL_EN           (0X00000004U)
/* DM_TA
 When set, flush all SLC entries made dirty by the TA group which includes VERTEX, TESSELLATOR & STREAM_OUT data masters, then invalidate all SLC entries referenced solely by the TA group which includes VERTEX, TESSELLATOR & STREAM_OUT data masters 
*/
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_TA_SHIFT           (1U)
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_TA_CLRMSK          (0XFFFFFFFDU)
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_DM_TA_EN              (0X00000002U)
/* ALL
 When set, flush all SLC entries, then invalidate all SLC entries 
*/
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_ALL_SHIFT             (0U)
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_ALL_CLRMSK            (0XFFFFFFFEU)
#define RGX_CR_SLC_CTRL_FLUSH_INVAL_ALL_EN                (0X00000001U)


/*

	Current status of Flush / Invalidate operations within the SLC

*/
/*
    Register RGX_CR_SLC_STATUS0
*/
#define RGX_CR_SLC_STATUS0                                (0x3820U)
#define RGX_CR_SLC_STATUS0_MASKFULL                       (IMG_UINT64_C(0x0000000000000007))
/* FLUSH_INVAL_PENDING
1 indicates there is a pending request to perform a combined Flush Invalidate on the SLC
*/
#define RGX_CR_SLC_STATUS0_FLUSH_INVAL_PENDING_SHIFT      (2U)
#define RGX_CR_SLC_STATUS0_FLUSH_INVAL_PENDING_CLRMSK     (0XFFFFFFFBU)
#define RGX_CR_SLC_STATUS0_FLUSH_INVAL_PENDING_EN         (0X00000004U)
/* INVAL_PENDING
1 indicates there is a pending request to Invalidate the SLC
*/
#define RGX_CR_SLC_STATUS0_INVAL_PENDING_SHIFT            (1U)
#define RGX_CR_SLC_STATUS0_INVAL_PENDING_CLRMSK           (0XFFFFFFFDU)
#define RGX_CR_SLC_STATUS0_INVAL_PENDING_EN               (0X00000002U)
/* FLUSH_PENDING
1 indicates there is a pending request to Flush the SLC
*/
#define RGX_CR_SLC_STATUS0_FLUSH_PENDING_SHIFT            (0U)
#define RGX_CR_SLC_STATUS0_FLUSH_PENDING_CLRMSK           (0XFFFFFFFEU)
#define RGX_CR_SLC_STATUS0_FLUSH_PENDING_EN               (0X00000001U)


/*

	SLC Bypass control

*/
/*
    Register RGX_CR_SLC_CTRL_BYPASS
*/
#define RGX_CR_SLC_CTRL_BYPASS                            (0x3828U)
#define RGX_CR_SLC_CTRL_BYPASS_MASKFULL                   (IMG_UINT64_C(0x000000000FFFFFFF))
#if defined(RGX_FEATURE_RAY_TRACING)
/* DM_RAY_VERTEX
 Bypass SLC for ray tracing VERTEX_RAY (CPF) requestor 
*/
#define RGX_CR_SLC_CTRL_BYPASS_DM_RAY_VERTEX_SHIFT        (27U)
#define RGX_CR_SLC_CTRL_BYPASS_DM_RAY_VERTEX_CLRMSK       (0XF7FFFFFFU)
#define RGX_CR_SLC_CTRL_BYPASS_DM_RAY_VERTEX_EN           (0X08000000U)
/* DM_RAY
 Bypass SLC for ray tracing RAY requestor 
*/
#define RGX_CR_SLC_CTRL_BYPASS_DM_RAY_SHIFT               (26U)
#define RGX_CR_SLC_CTRL_BYPASS_DM_RAY_CLRMSK              (0XFBFFFFFFU)
#define RGX_CR_SLC_CTRL_BYPASS_DM_RAY_EN                  (0X04000000U)
#endif /* RGX_FEATURE_RAY_TRACING */

/* REQ_IPF_CPF
 Bypass SLC for IPF (CPF) requestor 
*/
#define RGX_CR_SLC_CTRL_BYPASS_REQ_IPF_CPF_SHIFT          (25U)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_IPF_CPF_CLRMSK         (0XFDFFFFFFU)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_IPF_CPF_EN             (0X02000000U)
/* REQ_TPU
 Bypass SLC for TPU requests coming from the MCU requestor 
*/
#define RGX_CR_SLC_CTRL_BYPASS_REQ_TPU_SHIFT              (24U)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_TPU_CLRMSK             (0XFEFFFFFFU)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_TPU_EN                 (0X01000000U)
/* REQ_FBDC
 Bypass SLC for the FBDC requestor 
*/
#define RGX_CR_SLC_CTRL_BYPASS_REQ_FBDC_SHIFT             (23U)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_FBDC_CLRMSK            (0XFF7FFFFFU)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_FBDC_EN                (0X00800000U)
/* REQ_TLA
 Bypass SLC for the TLA requestor 
*/
#define RGX_CR_SLC_CTRL_BYPASS_REQ_TLA_SHIFT              (22U)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_TLA_CLRMSK             (0XFFBFFFFFU)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_TLA_EN                 (0X00400000U)
/* BYP_CC_N
 Bypass SLC when Cache Coherency bit is not set 
*/
#define RGX_CR_SLC_CTRL_BYPASS_BYP_CC_N_SHIFT             (21U)
#define RGX_CR_SLC_CTRL_BYPASS_BYP_CC_N_CLRMSK            (0XFFDFFFFFU)
#define RGX_CR_SLC_CTRL_BYPASS_BYP_CC_N_EN                (0X00200000U)
/* BYP_CC
 Bypass SLC when Cache Coherency bit is set 
*/
#define RGX_CR_SLC_CTRL_BYPASS_BYP_CC_SHIFT               (20U)
#define RGX_CR_SLC_CTRL_BYPASS_BYP_CC_CLRMSK              (0XFFEFFFFFU)
#define RGX_CR_SLC_CTRL_BYPASS_BYP_CC_EN                  (0X00100000U)
/* REQ_MCU
 Bypass SLC for the MCU requestor 
*/
#define RGX_CR_SLC_CTRL_BYPASS_REQ_MCU_SHIFT              (19U)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_MCU_CLRMSK             (0XFFF7FFFFU)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_MCU_EN                 (0X00080000U)
/* REQ_PDS
 Bypass SLC for the PDS requestor 
*/
#define RGX_CR_SLC_CTRL_BYPASS_REQ_PDS_SHIFT              (18U)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_PDS_CLRMSK             (0XFFFBFFFFU)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_PDS_EN                 (0X00040000U)
/* REQ_TPF
 Bypass SLC for the TPF requestor 
*/
#define RGX_CR_SLC_CTRL_BYPASS_REQ_TPF_SHIFT              (17U)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_TPF_CLRMSK             (0XFFFDFFFFU)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_TPF_EN                 (0X00020000U)
/* REQ_TA_TPC
 Bypass SLC for the TA (Tail Pointer Cache data) requestor 
*/
#define RGX_CR_SLC_CTRL_BYPASS_REQ_TA_TPC_SHIFT           (16U)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_TA_TPC_CLRMSK          (0XFFFEFFFFU)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_TA_TPC_EN              (0X00010000U)
/* REQ_IPF_OBJ
 Bypass SLC for the IPF (Object data) requestor 
*/
#define RGX_CR_SLC_CTRL_BYPASS_REQ_IPF_OBJ_SHIFT          (15U)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_IPF_OBJ_CLRMSK         (0XFFFF7FFFU)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_IPF_OBJ_EN             (0X00008000U)
/* REQ_USC
 Bypass SLC for the USC requestor 
*/
#define RGX_CR_SLC_CTRL_BYPASS_REQ_USC_SHIFT              (14U)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_USC_CLRMSK             (0XFFFFBFFFU)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_USC_EN                 (0X00004000U)
/* REQ_META
 Bypass SLC for the META requestor 
*/
#define RGX_CR_SLC_CTRL_BYPASS_REQ_META_SHIFT             (13U)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_META_CLRMSK            (0XFFFFDFFFU)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_META_EN                (0X00002000U)
/* REQ_HOST
 Bypass SLC for the Host requestor 
*/
#define RGX_CR_SLC_CTRL_BYPASS_REQ_HOST_SHIFT             (12U)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_HOST_CLRMSK            (0XFFFFEFFFU)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_HOST_EN                (0X00001000U)
/* REQ_MMU_PT
 Bypass SLC for the MMU requestor (Page Table data) 
*/
#define RGX_CR_SLC_CTRL_BYPASS_REQ_MMU_PT_SHIFT           (11U)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_MMU_PT_CLRMSK          (0XFFFFF7FFU)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_MMU_PT_EN              (0X00000800U)
/* REQ_MMU_PD
 Bypass SLC for the MMU requestor (Page Directory data) 
*/
#define RGX_CR_SLC_CTRL_BYPASS_REQ_MMU_PD_SHIFT           (10U)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_MMU_PD_CLRMSK          (0XFFFFFBFFU)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_MMU_PD_EN              (0X00000400U)
/* REQ_MMU_PC
 Bypass SLC for the MMU requestor (Page Catalogue data) 
*/
#define RGX_CR_SLC_CTRL_BYPASS_REQ_MMU_PC_SHIFT           (9U)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_MMU_PC_CLRMSK          (0XFFFFFDFFU)
#define RGX_CR_SLC_CTRL_BYPASS_REQ_MMU_PC_EN              (0X00000200U)
/* DM_FRC
 Bypass SLC for the FRC Video Core (Optional feature)
*/
#define RGX_CR_SLC_CTRL_BYPASS_DM_FRC_SHIFT               (8U)
#define RGX_CR_SLC_CTRL_BYPASS_DM_FRC_CLRMSK              (0XFFFFFEFFU)
#define RGX_CR_SLC_CTRL_BYPASS_DM_FRC_EN                  (0X00000100U)
/* DM_VXE
 Bypass SLC for the VXE Video Core (Optional feature)
*/
#define RGX_CR_SLC_CTRL_BYPASS_DM_VXE_SHIFT               (7U)
#define RGX_CR_SLC_CTRL_BYPASS_DM_VXE_CLRMSK              (0XFFFFFF7FU)
#define RGX_CR_SLC_CTRL_BYPASS_DM_VXE_EN                  (0X00000080U)
/* DM_VXD
 Bypass SLC for the VXD Video Core (Optional feature)
*/
#define RGX_CR_SLC_CTRL_BYPASS_DM_VXD_SHIFT               (6U)
#define RGX_CR_SLC_CTRL_BYPASS_DM_VXD_CLRMSK              (0XFFFFFFBFU)
#define RGX_CR_SLC_CTRL_BYPASS_DM_VXD_EN                  (0X00000040U)
/* DM_HOST_META
 Bypass SLC the HOST/META data master 
*/
#define RGX_CR_SLC_CTRL_BYPASS_DM_HOST_META_SHIFT         (5U)
#define RGX_CR_SLC_CTRL_BYPASS_DM_HOST_META_CLRMSK        (0XFFFFFFDFU)
#define RGX_CR_SLC_CTRL_BYPASS_DM_HOST_META_EN            (0X00000020U)
/* DM_MMU
 Bypass SLC the MMU data master 
*/
#define RGX_CR_SLC_CTRL_BYPASS_DM_MMU_SHIFT               (4U)
#define RGX_CR_SLC_CTRL_BYPASS_DM_MMU_CLRMSK              (0XFFFFFFEFU)
#define RGX_CR_SLC_CTRL_BYPASS_DM_MMU_EN                  (0X00000010U)
/* DM_COMPUTE
 Bypass SLC the COMPUTE data master 
*/
#define RGX_CR_SLC_CTRL_BYPASS_DM_COMPUTE_SHIFT           (3U)
#define RGX_CR_SLC_CTRL_BYPASS_DM_COMPUTE_CLRMSK          (0XFFFFFFF7U)
#define RGX_CR_SLC_CTRL_BYPASS_DM_COMPUTE_EN              (0X00000008U)
/* DM_PIXEL
 Bypass SLC for the PIXEL data master 
*/
#define RGX_CR_SLC_CTRL_BYPASS_DM_PIXEL_SHIFT             (2U)
#define RGX_CR_SLC_CTRL_BYPASS_DM_PIXEL_CLRMSK            (0XFFFFFFFBU)
#define RGX_CR_SLC_CTRL_BYPASS_DM_PIXEL_EN                (0X00000004U)
/* DM_TA
 Bypass SLC for the TA group which includes VERTEX, TESSELLATOR & STREAM_OUT data masters 
*/
#define RGX_CR_SLC_CTRL_BYPASS_DM_TA_SHIFT                (1U)
#define RGX_CR_SLC_CTRL_BYPASS_DM_TA_CLRMSK               (0XFFFFFFFDU)
#define RGX_CR_SLC_CTRL_BYPASS_DM_TA_EN                   (0X00000002U)
/* ALL
 Bypass SLC for all requesters 
*/
#define RGX_CR_SLC_CTRL_BYPASS_ALL_SHIFT                  (0U)
#define RGX_CR_SLC_CTRL_BYPASS_ALL_CLRMSK                 (0XFFFFFFFEU)
#define RGX_CR_SLC_CTRL_BYPASS_ALL_EN                     (0X00000001U)


/*

	AXI ACE-LITE configuration registers

*/
/*
    Register RGX_CR_AXI_ACE_LITE_CONFIGURATION
*/
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION                 (0x38C0U)
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_MASKFULL        (IMG_UINT64_C(0x0000001FFFFFFFFF))
/* DISABLE_COHERENT_WRITELINEUNIQUE
SET to 1 to disable coherent write line uniques
*/
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_DISABLE_COHERENT_WRITELINEUNIQUE_SHIFT (36U)
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_DISABLE_COHERENT_WRITELINEUNIQUE_CLRMSK (IMG_UINT64_C(0XFFFFFFEFFFFFFFFF))
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_DISABLE_COHERENT_WRITELINEUNIQUE_EN (IMG_UINT64_C(0X0000001000000000))
/* DISABLE_COHERENT_WRITE
SET to 1 to disable coherent writes
*/
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_DISABLE_COHERENT_WRITE_SHIFT (35U)
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_DISABLE_COHERENT_WRITE_CLRMSK (IMG_UINT64_C(0XFFFFFFF7FFFFFFFF))
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_DISABLE_COHERENT_WRITE_EN (IMG_UINT64_C(0X0000000800000000))
/* DISABLE_COHERENT_READ
SET to 1 to disable coherent reads
*/
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_DISABLE_COHERENT_READ_SHIFT (34U)
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_DISABLE_COHERENT_READ_CLRMSK (IMG_UINT64_C(0XFFFFFFFBFFFFFFFF))
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_DISABLE_COHERENT_READ_EN (IMG_UINT64_C(0X0000000400000000))
/* ARCACHE_CACHE_MAINTENANCE default: 0x00000002
Read cache policy for cache maintenance transactions - bit[1] should be set to 1
*/
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_ARCACHE_CACHE_MAINTENANCE_SHIFT (30U)
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_ARCACHE_CACHE_MAINTENANCE_CLRMSK (IMG_UINT64_C(0XFFFFFFFC3FFFFFFF))
/* ARCACHE_COHERENT default: 0x00000002
Read cache policy for coherent transactions - bit[1] should be set to 1
*/
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_ARCACHE_COHERENT_SHIFT (26U)
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_ARCACHE_COHERENT_CLRMSK (IMG_UINT64_C(0XFFFFFFFFC3FFFFFF))
/* AWCACHE_COHERENT default: 0x00000002
Write cache policy for coherent transactions - bit[1] should be set to 1
*/
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_AWCACHE_COHERENT_SHIFT (22U)
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_AWCACHE_COHERENT_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFC3FFFFF))
/* ARDOMAIN_BARRIER
Read shareability domain for barrier transactions
								      00 = Non-Shareable
								      01 = Inner Shareable
								      10 = Outer Shareable
								      11 = System
*/
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_ARDOMAIN_BARRIER_SHIFT (20U)
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_ARDOMAIN_BARRIER_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFCFFFFF))
/* AWDOMAIN_BARRIER
Write shareability domain for barrier transactions
								      00 = Non-Shareable
								      01 = Inner Shareable
								      10 = Outer Shareable
								      11 = System
*/
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_AWDOMAIN_BARRIER_SHIFT (18U)
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_AWDOMAIN_BARRIER_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFF3FFFF))
/* ARDOMAIN_CACHE_MAINTENANCE
Read shareability domain for cache maintenance transactions
										00 = Non-Shareable
										01 = Inner Shareable
										10 = Outer Shareable
*/
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_ARDOMAIN_CACHE_MAINTENANCE_SHIFT (16U)
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_ARDOMAIN_CACHE_MAINTENANCE_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFCFFFF))
/* AWDOMAIN_COHERENT default: 0x00000001
Write shareability domain for coherant transactions
								       01 = Inner Shareable
								       10 = Outer Shareable
*/
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_AWDOMAIN_COHERENT_SHIFT (14U)
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_AWDOMAIN_COHERENT_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFF3FFF))
/* ARDOMAIN_COHERENT default: 0x00000001
Read shareability domain for coherant transactions
								       01 = Inner Shareable
								       10 = Outer Shareable
*/
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_ARDOMAIN_COHERENT_SHIFT (12U)
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_ARDOMAIN_COHERENT_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFFCFFF))
/* ARDOMAIN_NON_SNOOPING
Read shareability domain for non-snooping transactions
									  00 = Non-Shareable
									  11 = System
*/
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_ARDOMAIN_NON_SNOOPING_SHIFT (10U)
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_ARDOMAIN_NON_SNOOPING_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFFF3FF))
/* AWDOMAIN_NON_SNOOPING
Write shareability domain for non-snooping transactions
									 00 = Non-Shareable
									 11 = System
*/
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_AWDOMAIN_NON_SNOOPING_SHIFT (8U)
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_AWDOMAIN_NON_SNOOPING_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFFFCFF))
/* ARCACHE_NON_SNOOPING
Read cache policy for non-snooping transactions
*/
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_ARCACHE_NON_SNOOPING_SHIFT (4U)
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_ARCACHE_NON_SNOOPING_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFFFF0F))
/* AWCACHE_NON_SNOOPING
Write cache policy for non-snooping transactions
*/
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_AWCACHE_NON_SNOOPING_SHIFT (0U)
#define RGX_CR_AXI_ACE_LITE_CONFIGURATION_AWCACHE_NON_SNOOPING_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFFFFF0))


/*

	SLC control registers

*/
/*
    Register RGX_CR_SLC_CTRL_MISC2
*/
#define RGX_CR_SLC_CTRL_MISC2                             (0x3930U)
#define RGX_CR_SLC_CTRL_MISC2_MASKFULL                    (IMG_UINT64_C(0x00000000FFFFFFFF))
/* SCRAMBLE_BITS
 Pattern of bits used to determine the MSB of the Cache Bank in 4 Bank configurations in Address Decode mode 0x21. The actual Cache Bank to use is determined by indexing into the 32 Scramble Bits using the 5 LSB's of the Hash result and then XORing this with Bit 6 of the incoming address to give a single bit result 
*/
#define RGX_CR_SLC_CTRL_MISC2_SCRAMBLE_BITS_SHIFT         (0U)
#define RGX_CR_SLC_CTRL_MISC2_SCRAMBLE_BITS_CLRMSK        (00000000U)


/*
    Register RGX_CR_SLC_CROSSBAR_LOAD_BALANCE
*/
#define RGX_CR_SLC_CROSSBAR_LOAD_BALANCE                  (0x3938U)
#define RGX_CR_SLC_CROSSBAR_LOAD_BALANCE_MASKFULL         (IMG_UINT64_C(0x0000000000000001))
/* BYPASS
 control register bit to bypass load balancing in SLC crossbar. In this case, the requests from
 img-memif0 will go directly to ocp-memif0 and so on 
*/
#define RGX_CR_SLC_CROSSBAR_LOAD_BALANCE_BYPASS_SHIFT     (0U)
#define RGX_CR_SLC_CROSSBAR_LOAD_BALANCE_BYPASS_CLRMSK    (0XFFFFFFFEU)
#define RGX_CR_SLC_CROSSBAR_LOAD_BALANCE_BYPASS_EN        (0X00000001U)


/*
    Register RGX_CR_PERF_TA_PHASE
*/
#define RGX_CR_PERF_TA_PHASE                              (0x6008U)
#define RGX_CR_PERF_TA_PHASE_MASKFULL                     (IMG_UINT64_C(0x00000000FFFFFFFF))
/* COUNT
The number of TA phases completed
*/
#define RGX_CR_PERF_TA_PHASE_COUNT_SHIFT                  (0U)
#define RGX_CR_PERF_TA_PHASE_COUNT_CLRMSK                 (00000000U)


/*
    Register RGX_CR_PERF_3D_PHASE
*/
#define RGX_CR_PERF_3D_PHASE                              (0x6010U)
#define RGX_CR_PERF_3D_PHASE_MASKFULL                     (IMG_UINT64_C(0x00000000FFFFFFFF))
/* COUNT
The number of 3D phases completed
*/
#define RGX_CR_PERF_3D_PHASE_COUNT_SHIFT                  (0U)
#define RGX_CR_PERF_3D_PHASE_COUNT_CLRMSK                 (00000000U)


/*
    Register RGX_CR_PERF_COMPUTE_PHASE
*/
#define RGX_CR_PERF_COMPUTE_PHASE                         (0x6018U)
#define RGX_CR_PERF_COMPUTE_PHASE_MASKFULL                (IMG_UINT64_C(0x00000000FFFFFFFF))
/* COUNT
The number of Compute phases completed
*/
#define RGX_CR_PERF_COMPUTE_PHASE_COUNT_SHIFT             (0U)
#define RGX_CR_PERF_COMPUTE_PHASE_COUNT_CLRMSK            (00000000U)


/*
    Register RGX_CR_PERF_TA_CYCLE
*/
#define RGX_CR_PERF_TA_CYCLE                              (0x6020U)
#define RGX_CR_PERF_TA_CYCLE_MASKFULL                     (IMG_UINT64_C(0x00000000FFFFFFFF))
/* COUNT
The number of cycles spent in TA phases
*/
#define RGX_CR_PERF_TA_CYCLE_COUNT_SHIFT                  (0U)
#define RGX_CR_PERF_TA_CYCLE_COUNT_CLRMSK                 (00000000U)


/*
    Register RGX_CR_PERF_3D_CYCLE
*/
#define RGX_CR_PERF_3D_CYCLE                              (0x6028U)
#define RGX_CR_PERF_3D_CYCLE_MASKFULL                     (IMG_UINT64_C(0x00000000FFFFFFFF))
/* COUNT
The number of cycles spent in 3D phases
*/
#define RGX_CR_PERF_3D_CYCLE_COUNT_SHIFT                  (0U)
#define RGX_CR_PERF_3D_CYCLE_COUNT_CLRMSK                 (00000000U)


/*
    Register RGX_CR_PERF_COMPUTE_CYCLE
*/
#define RGX_CR_PERF_COMPUTE_CYCLE                         (0x6030U)
#define RGX_CR_PERF_COMPUTE_CYCLE_MASKFULL                (IMG_UINT64_C(0x00000000FFFFFFFF))
/* COUNT
The number of cycles spent in Compute phases
*/
#define RGX_CR_PERF_COMPUTE_CYCLE_COUNT_SHIFT             (0U)
#define RGX_CR_PERF_COMPUTE_CYCLE_COUNT_CLRMSK            (00000000U)


/*
    Register RGX_CR_PERF_3D_SPINUP
*/
#define RGX_CR_PERF_3D_SPINUP                             (0x6220U)
#define RGX_CR_PERF_3D_SPINUP_MASKFULL                    (IMG_UINT64_C(0x00000000FFFFFFFF))
/* CYCLES
The number of cycles it takes the 3D pipeline to spin-up
*/
#define RGX_CR_PERF_3D_SPINUP_CYCLES_SHIFT                (0U)
#define RGX_CR_PERF_3D_SPINUP_CYCLES_CLRMSK               (00000000U)


/*

   This defines the core revision and bus widths of the core. See IPG spec for more details.

*/
/*
    Register RGX_CR_OCP_REVINFO
*/
#define RGX_CR_OCP_REVINFO                                (0x9000U)
#define RGX_CR_OCP_REVINFO_MASKFULL                       (IMG_UINT64_C(0x00000007FFFFFFFF))
/* HWINFO_SYSBUS default: 0x00000001
System data bus width, 0: 32 bits, 1: 64 bits, 2: 128 bits
*/
#define RGX_CR_OCP_REVINFO_HWINFO_SYSBUS_SHIFT            (33U)
#define RGX_CR_OCP_REVINFO_HWINFO_SYSBUS_CLRMSK           (IMG_UINT64_C(0XFFFFFFF9FFFFFFFF))
/* HWINFO_MEMBUS
Memory data bus width, 0: 128 bis, 1: 256 bits
*/
#define RGX_CR_OCP_REVINFO_HWINFO_MEMBUS_SHIFT            (32U)
#define RGX_CR_OCP_REVINFO_HWINFO_MEMBUS_CLRMSK           (IMG_UINT64_C(0XFFFFFFFEFFFFFFFF))
#define RGX_CR_OCP_REVINFO_HWINFO_MEMBUS_EN               (IMG_UINT64_C(0X0000000100000000))
/* REVISION default: 0x40000000
Core revision
*/
#define RGX_CR_OCP_REVINFO_REVISION_SHIFT                 (0U)
#define RGX_CR_OCP_REVINFO_REVISION_CLRMSK                (IMG_UINT64_C(0XFFFFFFFF00000000))


/*

   This defines the OCP Idle mode and OCP Standby mode for various power domains. See OCP-IPGeneric spec for more details.

*/
/*
    Register RGX_CR_OCP_SYSCONFIG
*/
#define RGX_CR_OCP_SYSCONFIG                              (0x9010U)
#define RGX_CR_OCP_SYSCONFIG_MASKFULL                     (IMG_UINT64_C(0x0000000000000FFF))
/* DUST2_STANDBY_MODE default: 0x00000002
Standby Mode for Dust2, 0: Force-Standby, 1: No-Standby, 2: Smart-Standby
*/
#define RGX_CR_OCP_SYSCONFIG_DUST2_STANDBY_MODE_SHIFT     (10U)
#define RGX_CR_OCP_SYSCONFIG_DUST2_STANDBY_MODE_CLRMSK    (0XFFFFF3FFU)
/* DUST1_STANDBY_MODE default: 0x00000002
Standby Mode for Dust1, 0: Force-Standby, 1: No-Standby, 2: Smart-Standby
*/
#define RGX_CR_OCP_SYSCONFIG_DUST1_STANDBY_MODE_SHIFT     (8U)
#define RGX_CR_OCP_SYSCONFIG_DUST1_STANDBY_MODE_CLRMSK    (0XFFFFFCFFU)
/* DUST0_STANDBY_MODE default: 0x00000002
Standby Mode for Dust0, 0: Force-Standby, 1: No-Standby, 2: Smart-Standby
*/
#define RGX_CR_OCP_SYSCONFIG_DUST0_STANDBY_MODE_SHIFT     (6U)
#define RGX_CR_OCP_SYSCONFIG_DUST0_STANDBY_MODE_CLRMSK    (0XFFFFFF3FU)
/* RASCAL_STANDBYMODE default: 0x00000002
Standby Mode for Rascal, 0: Force-Standby, 1: No-Standby, 2: Smart-Standby
*/
#define RGX_CR_OCP_SYSCONFIG_RASCAL_STANDBYMODE_SHIFT     (4U)
#define RGX_CR_OCP_SYSCONFIG_RASCAL_STANDBYMODE_CLRMSK    (0XFFFFFFCFU)
/* STANDBY_MODE default: 0x00000002
Standby Mode for SLC and Sidekick OCP Master, 0: Force-Standby, 1: No-Standby, 2: Smart-Standby
*/
#define RGX_CR_OCP_SYSCONFIG_STANDBY_MODE_SHIFT           (2U)
#define RGX_CR_OCP_SYSCONFIG_STANDBY_MODE_CLRMSK          (0XFFFFFFF3U)
/* IDLE_MODE default: 0x00000002
Idle Mode for OCP slaves, 0: Force-Idle, 1: No-Idle, 2: Smart-Idle
*/
#define RGX_CR_OCP_SYSCONFIG_IDLE_MODE_SHIFT              (0U)
#define RGX_CR_OCP_SYSCONFIG_IDLE_MODE_CLRMSK             (0XFFFFFFFCU)


/*
    Register RGX_CR_OCP_IRQSTATUS_RAW_0
*/
#define RGX_CR_OCP_IRQSTATUS_RAW_0                        (0x9020U)
#define RGX_CR_OCP_IRQSTATUS_RAW_0_MASKFULL               (IMG_UINT64_C(0x0000000000000001))
/* Init_MInterrupt_raw
Interrupt raw event for OCP Master Interfaces, W 0 : No action, W 1 - Set event, R 0 - No event pending, R 1 - Event pending
*/
#define RGX_CR_OCP_IRQSTATUS_RAW_0_INIT_MINTERRUPT_RAW_SHIFT (0U)
#define RGX_CR_OCP_IRQSTATUS_RAW_0_INIT_MINTERRUPT_RAW_CLRMSK (0XFFFFFFFEU)
#define RGX_CR_OCP_IRQSTATUS_RAW_0_INIT_MINTERRUPT_RAW_EN (0X00000001U)


/*
    Register RGX_CR_OCP_IRQSTATUS_RAW_1
*/
#define RGX_CR_OCP_IRQSTATUS_RAW_1                        (0x9028U)
#define RGX_CR_OCP_IRQSTATUS_RAW_1_MASKFULL               (IMG_UINT64_C(0x0000000000000001))
/* Target_SInterrupt_raw
Interrupt raw event for OCP Slave Interfaces, W 0 : No action, W 1 - Set event, R 0 - No event pending, R 1 - Event pending
*/
#define RGX_CR_OCP_IRQSTATUS_RAW_1_TARGET_SINTERRUPT_RAW_SHIFT (0U)
#define RGX_CR_OCP_IRQSTATUS_RAW_1_TARGET_SINTERRUPT_RAW_CLRMSK (0XFFFFFFFEU)
#define RGX_CR_OCP_IRQSTATUS_RAW_1_TARGET_SINTERRUPT_RAW_EN (0X00000001U)


/*
    Register RGX_CR_OCP_IRQSTATUS_RAW_2
*/
#define RGX_CR_OCP_IRQSTATUS_RAW_2                        (0x9030U)
#define RGX_CR_OCP_IRQSTATUS_RAW_2_MASKFULL               (IMG_UINT64_C(0x0000000000000001))
/* rgx_irq_raw
Interrupt raw event for core, W 0 : No action, W 1 - Set event, R 0 - No event pending, R 1 - Event pending
*/
#define RGX_CR_OCP_IRQSTATUS_RAW_2_RGX_IRQ_RAW_SHIFT      (0U)
#define RGX_CR_OCP_IRQSTATUS_RAW_2_RGX_IRQ_RAW_CLRMSK     (0XFFFFFFFEU)
#define RGX_CR_OCP_IRQSTATUS_RAW_2_RGX_IRQ_RAW_EN         (0X00000001U)


/*
    Register RGX_CR_OCP_IRQSTATUS_0
*/
#define RGX_CR_OCP_IRQSTATUS_0                            (0x9038U)
#define RGX_CR_OCP_IRQSTATUS_0_MASKFULL                   (IMG_UINT64_C(0x0000000000000001))
/* Init_MInterrupt_status
Interrupt status event for OCP Master Interfaces, W 0 : No action, W 1 - Clear event, R 0 - No event pending, R 1 - Event pending and interrupt enabled
*/
#define RGX_CR_OCP_IRQSTATUS_0_INIT_MINTERRUPT_STATUS_SHIFT (0U)
#define RGX_CR_OCP_IRQSTATUS_0_INIT_MINTERRUPT_STATUS_CLRMSK (0XFFFFFFFEU)
#define RGX_CR_OCP_IRQSTATUS_0_INIT_MINTERRUPT_STATUS_EN  (0X00000001U)


/*
    Register RGX_CR_OCP_IRQSTATUS_1
*/
#define RGX_CR_OCP_IRQSTATUS_1                            (0x9040U)
#define RGX_CR_OCP_IRQSTATUS_1_MASKFULL                   (IMG_UINT64_C(0x0000000000000001))
/* target_SInterrupt_status
Interrupt status event for OCP Slave Interfaces, W 0 : No action, W 1 - Clear event, R 0 - No event pending, R 1 - Event pending and interrupt enabled
*/
#define RGX_CR_OCP_IRQSTATUS_1_TARGET_SINTERRUPT_STATUS_SHIFT (0U)
#define RGX_CR_OCP_IRQSTATUS_1_TARGET_SINTERRUPT_STATUS_CLRMSK (0XFFFFFFFEU)
#define RGX_CR_OCP_IRQSTATUS_1_TARGET_SINTERRUPT_STATUS_EN (0X00000001U)


/*
    Register RGX_CR_OCP_IRQSTATUS_2
*/
#define RGX_CR_OCP_IRQSTATUS_2                            (0x9048U)
#define RGX_CR_OCP_IRQSTATUS_2_MASKFULL                   (IMG_UINT64_C(0x0000000000000001))
/* rgx_irq_status
Interrupt status event for core, W 0 : No action, W 1 - Clear event, R 0 - No event pending, R 1 - Event pending and interrupt enabled
*/
#define RGX_CR_OCP_IRQSTATUS_2_RGX_IRQ_STATUS_SHIFT       (0U)
#define RGX_CR_OCP_IRQSTATUS_2_RGX_IRQ_STATUS_CLRMSK      (0XFFFFFFFEU)
#define RGX_CR_OCP_IRQSTATUS_2_RGX_IRQ_STATUS_EN          (0X00000001U)


/*
    Register RGX_CR_OCP_IRQENABLE_SET_0
*/
#define RGX_CR_OCP_IRQENABLE_SET_0                        (0x9050U)
#define RGX_CR_OCP_IRQENABLE_SET_0_MASKFULL               (IMG_UINT64_C(0x0000000000000001))
/* Init_MInterrupt_enable
Interrupt enable for OCP Master Interfaces, W 0 : No action, W 1 - Enable Interrupt, R 0 - Interrupt is disabled, R 1 - Interrupt is enabled
*/
#define RGX_CR_OCP_IRQENABLE_SET_0_INIT_MINTERRUPT_ENABLE_SHIFT (0U)
#define RGX_CR_OCP_IRQENABLE_SET_0_INIT_MINTERRUPT_ENABLE_CLRMSK (0XFFFFFFFEU)
#define RGX_CR_OCP_IRQENABLE_SET_0_INIT_MINTERRUPT_ENABLE_EN (0X00000001U)


/*
    Register RGX_CR_OCP_IRQENABLE_SET_1
*/
#define RGX_CR_OCP_IRQENABLE_SET_1                        (0x9058U)
#define RGX_CR_OCP_IRQENABLE_SET_1_MASKFULL               (IMG_UINT64_C(0x0000000000000001))
/* Target_SInterrupt_enable
Interrupt enable for OCP Slave Interfaces, W 0 : No action, W 1 - Enable Interrupt, R 0 - Interrupt is disabled, R 1 - Interrupt is enabled
*/
#define RGX_CR_OCP_IRQENABLE_SET_1_TARGET_SINTERRUPT_ENABLE_SHIFT (0U)
#define RGX_CR_OCP_IRQENABLE_SET_1_TARGET_SINTERRUPT_ENABLE_CLRMSK (0XFFFFFFFEU)
#define RGX_CR_OCP_IRQENABLE_SET_1_TARGET_SINTERRUPT_ENABLE_EN (0X00000001U)


/*
    Register RGX_CR_OCP_IRQENABLE_SET_2
*/
#define RGX_CR_OCP_IRQENABLE_SET_2                        (0x9060U)
#define RGX_CR_OCP_IRQENABLE_SET_2_MASKFULL               (IMG_UINT64_C(0x0000000000000001))
/* rgx_irq_enable
Interrupt enable for core, W 0 : No action, W 1 - Enable Interrupt, R 0 - Interrupt is disabled, R 1 - Interrupt is enabled
*/
#define RGX_CR_OCP_IRQENABLE_SET_2_RGX_IRQ_ENABLE_SHIFT   (0U)
#define RGX_CR_OCP_IRQENABLE_SET_2_RGX_IRQ_ENABLE_CLRMSK  (0XFFFFFFFEU)
#define RGX_CR_OCP_IRQENABLE_SET_2_RGX_IRQ_ENABLE_EN      (0X00000001U)


/*
    Register RGX_CR_OCP_IRQENABLE_CLR_0
*/
#define RGX_CR_OCP_IRQENABLE_CLR_0                        (0x9068U)
#define RGX_CR_OCP_IRQENABLE_CLR_0_MASKFULL               (IMG_UINT64_C(0x0000000000000001))
/* Init_MInterrupt_disable
Interrupt disable for OCP Master Interfaces, W 0 : No action, W 1 - Disable Interrupt, R 0 - Interrupt is disabled, R 1 - Interrupt is enabled
*/
#define RGX_CR_OCP_IRQENABLE_CLR_0_INIT_MINTERRUPT_DISABLE_SHIFT (0U)
#define RGX_CR_OCP_IRQENABLE_CLR_0_INIT_MINTERRUPT_DISABLE_CLRMSK (0XFFFFFFFEU)
#define RGX_CR_OCP_IRQENABLE_CLR_0_INIT_MINTERRUPT_DISABLE_EN (0X00000001U)


/*
    Register RGX_CR_OCP_IRQENABLE_CLR_1
*/
#define RGX_CR_OCP_IRQENABLE_CLR_1                        (0x9070U)
#define RGX_CR_OCP_IRQENABLE_CLR_1_MASKFULL               (IMG_UINT64_C(0x0000000000000001))
/* Target_SInterrupt_disable
Interrupt disable for OCP Slave Interfaces, W 0 : No action, W 1 - Disable Interrupt, R 0 - Interrupt is disabled, R 1 - Interrupt is enabled
*/
#define RGX_CR_OCP_IRQENABLE_CLR_1_TARGET_SINTERRUPT_DISABLE_SHIFT (0U)
#define RGX_CR_OCP_IRQENABLE_CLR_1_TARGET_SINTERRUPT_DISABLE_CLRMSK (0XFFFFFFFEU)
#define RGX_CR_OCP_IRQENABLE_CLR_1_TARGET_SINTERRUPT_DISABLE_EN (0X00000001U)


/*
    Register RGX_CR_OCP_IRQENABLE_CLR_2
*/
#define RGX_CR_OCP_IRQENABLE_CLR_2                        (0x9078U)
#define RGX_CR_OCP_IRQENABLE_CLR_2_MASKFULL               (IMG_UINT64_C(0x0000000000000001))
/* rgx_irq_disable
Interrupt disable for core, W 0 : No action, W 1 - Disable Interrupt, R 0 - Interrupt is disabled, R 1 - Interrupt is enabled
*/
#define RGX_CR_OCP_IRQENABLE_CLR_2_RGX_IRQ_DISABLE_SHIFT  (0U)
#define RGX_CR_OCP_IRQENABLE_CLR_2_RGX_IRQ_DISABLE_CLRMSK (0XFFFFFFFEU)
#define RGX_CR_OCP_IRQENABLE_CLR_2_RGX_IRQ_DISABLE_EN     (0X00000001U)


/*

   This defines the interrupt disable for Core.

*/
/*
    Register RGX_CR_OCP_IRQ_EVENT
*/
#define RGX_CR_OCP_IRQ_EVENT                              (0x9080U)
#define RGX_CR_OCP_IRQ_EVENT_MASKFULL                     (IMG_UINT64_C(0x00000000000FFFFF))
/* TARGETH_RCVD_UNEXPECTED_RDATA
interrupt events from OCP host if - received unexpeted rdata from IMG if
*/
#define RGX_CR_OCP_IRQ_EVENT_TARGETH_RCVD_UNEXPECTED_RDATA_SHIFT (19U)
#define RGX_CR_OCP_IRQ_EVENT_TARGETH_RCVD_UNEXPECTED_RDATA_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFF7FFFF))
#define RGX_CR_OCP_IRQ_EVENT_TARGETH_RCVD_UNEXPECTED_RDATA_EN (IMG_UINT64_C(0X0000000000080000))
/* TARGETH_RCVD_UNSUPPORTED_MCMD
interrupt events from OCP host if - received unsupported MCmd
*/
#define RGX_CR_OCP_IRQ_EVENT_TARGETH_RCVD_UNSUPPORTED_MCMD_SHIFT (18U)
#define RGX_CR_OCP_IRQ_EVENT_TARGETH_RCVD_UNSUPPORTED_MCMD_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFBFFFF))
#define RGX_CR_OCP_IRQ_EVENT_TARGETH_RCVD_UNSUPPORTED_MCMD_EN (IMG_UINT64_C(0X0000000000040000))
/* TARGETS_RCVD_UNEXPECTED_RDATA
interrupt events from OCP system if - received unexpeted rdata from IMG if
*/
#define RGX_CR_OCP_IRQ_EVENT_TARGETS_RCVD_UNEXPECTED_RDATA_SHIFT (17U)
#define RGX_CR_OCP_IRQ_EVENT_TARGETS_RCVD_UNEXPECTED_RDATA_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFDFFFF))
#define RGX_CR_OCP_IRQ_EVENT_TARGETS_RCVD_UNEXPECTED_RDATA_EN (IMG_UINT64_C(0X0000000000020000))
/* TARGETS_RCVD_UNSUPPORTED_MCMD
interrupt events from OCP system if - received unsupported MCmd
*/
#define RGX_CR_OCP_IRQ_EVENT_TARGETS_RCVD_UNSUPPORTED_MCMD_SHIFT (16U)
#define RGX_CR_OCP_IRQ_EVENT_TARGETS_RCVD_UNSUPPORTED_MCMD_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFEFFFF))
#define RGX_CR_OCP_IRQ_EVENT_TARGETS_RCVD_UNSUPPORTED_MCMD_EN (IMG_UINT64_C(0X0000000000010000))
/* INIT3_IMG_PAGE_BOUNDARY_CROSS
interrupt events from Init3 - burst request from IMG cross 4k page boundary
*/
#define RGX_CR_OCP_IRQ_EVENT_INIT3_IMG_PAGE_BOUNDARY_CROSS_SHIFT (15U)
#define RGX_CR_OCP_IRQ_EVENT_INIT3_IMG_PAGE_BOUNDARY_CROSS_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFF7FFF))
#define RGX_CR_OCP_IRQ_EVENT_INIT3_IMG_PAGE_BOUNDARY_CROSS_EN (IMG_UINT64_C(0X0000000000008000))
/* INIT3_RCVD_RESP_ERR_FAIL
interrupt events from Init3 - received RESP_ERR or RESP_FAIL from SoC
*/
#define RGX_CR_OCP_IRQ_EVENT_INIT3_RCVD_RESP_ERR_FAIL_SHIFT (14U)
#define RGX_CR_OCP_IRQ_EVENT_INIT3_RCVD_RESP_ERR_FAIL_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFFBFFF))
#define RGX_CR_OCP_IRQ_EVENT_INIT3_RCVD_RESP_ERR_FAIL_EN  (IMG_UINT64_C(0X0000000000004000))
/* INIT3_RCVD_UNUSED_TAGID
interrupt events from Init3 - received unused ocp tag id from SoC
*/
#define RGX_CR_OCP_IRQ_EVENT_INIT3_RCVD_UNUSED_TAGID_SHIFT (13U)
#define RGX_CR_OCP_IRQ_EVENT_INIT3_RCVD_UNUSED_TAGID_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFFDFFF))
#define RGX_CR_OCP_IRQ_EVENT_INIT3_RCVD_UNUSED_TAGID_EN   (IMG_UINT64_C(0X0000000000002000))
/* INIT3_RDATA_FIFO_OVERFILL
interrupt events from Init3 - return data fifo overfill
*/
#define RGX_CR_OCP_IRQ_EVENT_INIT3_RDATA_FIFO_OVERFILL_SHIFT (12U)
#define RGX_CR_OCP_IRQ_EVENT_INIT3_RDATA_FIFO_OVERFILL_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFFEFFF))
#define RGX_CR_OCP_IRQ_EVENT_INIT3_RDATA_FIFO_OVERFILL_EN (IMG_UINT64_C(0X0000000000001000))
/* INIT2_IMG_PAGE_BOUNDARY_CROSS
interrupt events from Init2 - burst request from IMG cross 4k page boundary
*/
#define RGX_CR_OCP_IRQ_EVENT_INIT2_IMG_PAGE_BOUNDARY_CROSS_SHIFT (11U)
#define RGX_CR_OCP_IRQ_EVENT_INIT2_IMG_PAGE_BOUNDARY_CROSS_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFFF7FF))
#define RGX_CR_OCP_IRQ_EVENT_INIT2_IMG_PAGE_BOUNDARY_CROSS_EN (IMG_UINT64_C(0X0000000000000800))
/* INIT2_RCVD_RESP_ERR_FAIL
interrupt events from Init2 - received RESP_ERR or RESP_FAIL from SoC
*/
#define RGX_CR_OCP_IRQ_EVENT_INIT2_RCVD_RESP_ERR_FAIL_SHIFT (10U)
#define RGX_CR_OCP_IRQ_EVENT_INIT2_RCVD_RESP_ERR_FAIL_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFFFBFF))
#define RGX_CR_OCP_IRQ_EVENT_INIT2_RCVD_RESP_ERR_FAIL_EN  (IMG_UINT64_C(0X0000000000000400))
/* INIT2_RCVD_UNUSED_TAGID
interrupt events from Init2 - received unused ocp tag id from SoC
*/
#define RGX_CR_OCP_IRQ_EVENT_INIT2_RCVD_UNUSED_TAGID_SHIFT (9U)
#define RGX_CR_OCP_IRQ_EVENT_INIT2_RCVD_UNUSED_TAGID_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFFFDFF))
#define RGX_CR_OCP_IRQ_EVENT_INIT2_RCVD_UNUSED_TAGID_EN   (IMG_UINT64_C(0X0000000000000200))
/* INIT2_RDATA_FIFO_OVERFILL
interrupt events from Init2 - return data fifo overfill
*/
#define RGX_CR_OCP_IRQ_EVENT_INIT2_RDATA_FIFO_OVERFILL_SHIFT (8U)
#define RGX_CR_OCP_IRQ_EVENT_INIT2_RDATA_FIFO_OVERFILL_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFFFEFF))
#define RGX_CR_OCP_IRQ_EVENT_INIT2_RDATA_FIFO_OVERFILL_EN (IMG_UINT64_C(0X0000000000000100))
/* INIT1_IMG_PAGE_BOUNDARY_CROSS
interrupt events from Init1 - burst request from IMG cross 4k page boundary
*/
#define RGX_CR_OCP_IRQ_EVENT_INIT1_IMG_PAGE_BOUNDARY_CROSS_SHIFT (7U)
#define RGX_CR_OCP_IRQ_EVENT_INIT1_IMG_PAGE_BOUNDARY_CROSS_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFFFF7F))
#define RGX_CR_OCP_IRQ_EVENT_INIT1_IMG_PAGE_BOUNDARY_CROSS_EN (IMG_UINT64_C(0X0000000000000080))
/* INIT1_RCVD_RESP_ERR_FAIL
interrupt events from Init1 - received RESP_ERR or RESP_FAIL from SoC
*/
#define RGX_CR_OCP_IRQ_EVENT_INIT1_RCVD_RESP_ERR_FAIL_SHIFT (6U)
#define RGX_CR_OCP_IRQ_EVENT_INIT1_RCVD_RESP_ERR_FAIL_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFFFFBF))
#define RGX_CR_OCP_IRQ_EVENT_INIT1_RCVD_RESP_ERR_FAIL_EN  (IMG_UINT64_C(0X0000000000000040))
/* INIT1_RCVD_UNUSED_TAGID
interrupt events from Init1 - received unused ocp tag id from SoC
*/
#define RGX_CR_OCP_IRQ_EVENT_INIT1_RCVD_UNUSED_TAGID_SHIFT (5U)
#define RGX_CR_OCP_IRQ_EVENT_INIT1_RCVD_UNUSED_TAGID_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFFFFDF))
#define RGX_CR_OCP_IRQ_EVENT_INIT1_RCVD_UNUSED_TAGID_EN   (IMG_UINT64_C(0X0000000000000020))
/* INIT1_RDATA_FIFO_OVERFILL
interrupt events from Init1 - return data fifo overfill
*/
#define RGX_CR_OCP_IRQ_EVENT_INIT1_RDATA_FIFO_OVERFILL_SHIFT (4U)
#define RGX_CR_OCP_IRQ_EVENT_INIT1_RDATA_FIFO_OVERFILL_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFFFFEF))
#define RGX_CR_OCP_IRQ_EVENT_INIT1_RDATA_FIFO_OVERFILL_EN (IMG_UINT64_C(0X0000000000000010))
/* INIT0_IMG_PAGE_BOUNDARY_CROSS
interrupt events from Init0 - burst request from IMG cross 4k page boundary
*/
#define RGX_CR_OCP_IRQ_EVENT_INIT0_IMG_PAGE_BOUNDARY_CROSS_SHIFT (3U)
#define RGX_CR_OCP_IRQ_EVENT_INIT0_IMG_PAGE_BOUNDARY_CROSS_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFFFFF7))
#define RGX_CR_OCP_IRQ_EVENT_INIT0_IMG_PAGE_BOUNDARY_CROSS_EN (IMG_UINT64_C(0X0000000000000008))
/* INIT0_RCVD_RESP_ERR_FAIL
interrupt events from Init0 - received RESP_ERR or RESP_FAIL from SoC
*/
#define RGX_CR_OCP_IRQ_EVENT_INIT0_RCVD_RESP_ERR_FAIL_SHIFT (2U)
#define RGX_CR_OCP_IRQ_EVENT_INIT0_RCVD_RESP_ERR_FAIL_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFFFFFB))
#define RGX_CR_OCP_IRQ_EVENT_INIT0_RCVD_RESP_ERR_FAIL_EN  (IMG_UINT64_C(0X0000000000000004))
/* INIT0_RCVD_UNUSED_TAGID
interrupt events from Init0 - received unused ocp tag id from SoC
*/
#define RGX_CR_OCP_IRQ_EVENT_INIT0_RCVD_UNUSED_TAGID_SHIFT (1U)
#define RGX_CR_OCP_IRQ_EVENT_INIT0_RCVD_UNUSED_TAGID_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFFFFFD))
#define RGX_CR_OCP_IRQ_EVENT_INIT0_RCVD_UNUSED_TAGID_EN   (IMG_UINT64_C(0X0000000000000002))
/* INIT0_RDATA_FIFO_OVERFILL
interrupt events from Init0 - return data fifo overfill
*/
#define RGX_CR_OCP_IRQ_EVENT_INIT0_RDATA_FIFO_OVERFILL_SHIFT (0U)
#define RGX_CR_OCP_IRQ_EVENT_INIT0_RDATA_FIFO_OVERFILL_CLRMSK (IMG_UINT64_C(0XFFFFFFFFFFFFFFFE))
#define RGX_CR_OCP_IRQ_EVENT_INIT0_RDATA_FIFO_OVERFILL_EN (IMG_UINT64_C(0X0000000000000001))


/*
    Register RGX_CR_OCP_DEBUG_CONFIG
*/
#define RGX_CR_OCP_DEBUG_CONFIG                           (0x9088U)
#define RGX_CR_OCP_DEBUG_CONFIG_MASKFULL                  (IMG_UINT64_C(0x0000000000000001))
/* REG
bypass rgx_irq from OCP wrapper and do not use OCP specific irq enable/disable
*/
#define RGX_CR_OCP_DEBUG_CONFIG_REG_SHIFT                 (0U)
#define RGX_CR_OCP_DEBUG_CONFIG_REG_CLRMSK                (0XFFFFFFFEU)
#define RGX_CR_OCP_DEBUG_CONFIG_REG_EN                    (0X00000001U)


/*

   This defines the debug status of the OCP internal registers

*/
/*
    Register RGX_CR_OCP_DEBUG_STATUS
*/
#define RGX_CR_OCP_DEBUG_STATUS                           (0x9090U)
#define RGX_CR_OCP_DEBUG_STATUS_MASKFULL                  (IMG_UINT64_C(0x001F1F77FFFFFFFF))
/* TARGETH_SDISCACK default: 0x00000003
debug status from OCP host interface - acknowledge to Idle protocol
*/
#define RGX_CR_OCP_DEBUG_STATUS_TARGETH_SDISCACK_SHIFT    (51U)
#define RGX_CR_OCP_DEBUG_STATUS_TARGETH_SDISCACK_CLRMSK   (IMG_UINT64_C(0XFFE7FFFFFFFFFFFF))
/* TARGETH_SCONNECT
debug status from OCP host interface - Target SConnect state
*/
#define RGX_CR_OCP_DEBUG_STATUS_TARGETH_SCONNECT_SHIFT    (50U)
#define RGX_CR_OCP_DEBUG_STATUS_TARGETH_SCONNECT_CLRMSK   (IMG_UINT64_C(0XFFFBFFFFFFFFFFFF))
#define RGX_CR_OCP_DEBUG_STATUS_TARGETH_SCONNECT_EN       (IMG_UINT64_C(0X0004000000000000))
/* TARGETH_MCONNECT
debug status from OCP host interface - taget MConnect state
*/
#define RGX_CR_OCP_DEBUG_STATUS_TARGETH_MCONNECT_SHIFT    (48U)
#define RGX_CR_OCP_DEBUG_STATUS_TARGETH_MCONNECT_CLRMSK   (IMG_UINT64_C(0XFFFCFFFFFFFFFFFF))
/* TARGETS_SDISCACK default: 0x00000003
debug status from OCP system interface - acknowledge to Idle protocol
*/
#define RGX_CR_OCP_DEBUG_STATUS_TARGETS_SDISCACK_SHIFT    (43U)
#define RGX_CR_OCP_DEBUG_STATUS_TARGETS_SDISCACK_CLRMSK   (IMG_UINT64_C(0XFFFFE7FFFFFFFFFF))
/* TARGETS_SCONNECT
debug status from OCP system interface - Target SConnect state
*/
#define RGX_CR_OCP_DEBUG_STATUS_TARGETS_SCONNECT_SHIFT    (42U)
#define RGX_CR_OCP_DEBUG_STATUS_TARGETS_SCONNECT_CLRMSK   (IMG_UINT64_C(0XFFFFFBFFFFFFFFFF))
#define RGX_CR_OCP_DEBUG_STATUS_TARGETS_SCONNECT_EN       (IMG_UINT64_C(0X0000040000000000))
/* TARGETS_MCONNECT
debug status from OCP system interface - taget MConnect state
*/
#define RGX_CR_OCP_DEBUG_STATUS_TARGETS_MCONNECT_SHIFT    (40U)
#define RGX_CR_OCP_DEBUG_STATUS_TARGETS_MCONNECT_CLRMSK   (IMG_UINT64_C(0XFFFFFCFFFFFFFFFF))
/* TARGETH_BUSY
debug status from OCP host interface - ocp slave interface is busy
*/
#define RGX_CR_OCP_DEBUG_STATUS_TARGETH_BUSY_SHIFT        (38U)
#define RGX_CR_OCP_DEBUG_STATUS_TARGETH_BUSY_CLRMSK       (IMG_UINT64_C(0XFFFFFFBFFFFFFFFF))
#define RGX_CR_OCP_DEBUG_STATUS_TARGETH_BUSY_EN           (IMG_UINT64_C(0X0000004000000000))
/* TARGETH_CMD_FIFO_FULL
debug status from OCP host interface - command fifo full
*/
#define RGX_CR_OCP_DEBUG_STATUS_TARGETH_CMD_FIFO_FULL_SHIFT (37U)
#define RGX_CR_OCP_DEBUG_STATUS_TARGETH_CMD_FIFO_FULL_CLRMSK (IMG_UINT64_C(0XFFFFFFDFFFFFFFFF))
#define RGX_CR_OCP_DEBUG_STATUS_TARGETH_CMD_FIFO_FULL_EN  (IMG_UINT64_C(0X0000002000000000))
/* TARGETH_SRESP_ERROR
debug status from OCP host interface - error response due to non-supporting command
*/
#define RGX_CR_OCP_DEBUG_STATUS_TARGETH_SRESP_ERROR_SHIFT (36U)
#define RGX_CR_OCP_DEBUG_STATUS_TARGETH_SRESP_ERROR_CLRMSK (IMG_UINT64_C(0XFFFFFFEFFFFFFFFF))
#define RGX_CR_OCP_DEBUG_STATUS_TARGETH_SRESP_ERROR_EN    (IMG_UINT64_C(0X0000001000000000))
/* TARGETS_BUSY
debug status from OCP system interface - ocp slave interface is busy
*/
#define RGX_CR_OCP_DEBUG_STATUS_TARGETS_BUSY_SHIFT        (34U)
#define RGX_CR_OCP_DEBUG_STATUS_TARGETS_BUSY_CLRMSK       (IMG_UINT64_C(0XFFFFFFFBFFFFFFFF))
#define RGX_CR_OCP_DEBUG_STATUS_TARGETS_BUSY_EN           (IMG_UINT64_C(0X0000000400000000))
/* TARGETS_CMD_FIFO_FULL
debug status from OCP system interface - command fifo full
*/
#define RGX_CR_OCP_DEBUG_STATUS_TARGETS_CMD_FIFO_FULL_SHIFT (33U)
#define RGX_CR_OCP_DEBUG_STATUS_TARGETS_CMD_FIFO_FULL_CLRMSK (IMG_UINT64_C(0XFFFFFFFDFFFFFFFF))
#define RGX_CR_OCP_DEBUG_STATUS_TARGETS_CMD_FIFO_FULL_EN  (IMG_UINT64_C(0X0000000200000000))
/* TARGETS_SRESP_ERROR
debug status from OCP system interface - error response due to non-supporting command
*/
#define RGX_CR_OCP_DEBUG_STATUS_TARGETS_SRESP_ERROR_SHIFT (32U)
#define RGX_CR_OCP_DEBUG_STATUS_TARGETS_SRESP_ERROR_CLRMSK (IMG_UINT64_C(0XFFFFFFFEFFFFFFFF))
#define RGX_CR_OCP_DEBUG_STATUS_TARGETS_SRESP_ERROR_EN    (IMG_UINT64_C(0X0000000100000000))
/* INIT3_RESERVED
debug status from init3 - reserved
*/
#define RGX_CR_OCP_DEBUG_STATUS_INIT3_RESERVED_SHIFT      (31U)
#define RGX_CR_OCP_DEBUG_STATUS_INIT3_RESERVED_CLRMSK     (IMG_UINT64_C(0XFFFFFFFF7FFFFFFF))
#define RGX_CR_OCP_DEBUG_STATUS_INIT3_RESERVED_EN         (IMG_UINT64_C(0X0000000080000000))
/* INIT3_SWAIT
debug status from init3 - defines whether to wait in M_WAIT state for MConnect
*/
#define RGX_CR_OCP_DEBUG_STATUS_INIT3_SWAIT_SHIFT         (30U)
#define RGX_CR_OCP_DEBUG_STATUS_INIT3_SWAIT_CLRMSK        (IMG_UINT64_C(0XFFFFFFFFBFFFFFFF))
#define RGX_CR_OCP_DEBUG_STATUS_INIT3_SWAIT_EN            (IMG_UINT64_C(0X0000000040000000))
/* INIT3_MDISCREQ default: 0x00000001
debug status from init3 - request to disconnect from standby protocol
*/
#define RGX_CR_OCP_DEBUG_STATUS_INIT3_MDISCREQ_SHIFT      (29U)
#define RGX_CR_OCP_DEBUG_STATUS_INIT3_MDISCREQ_CLRMSK     (IMG_UINT64_C(0XFFFFFFFFDFFFFFFF))
#define RGX_CR_OCP_DEBUG_STATUS_INIT3_MDISCREQ_EN         (IMG_UINT64_C(0X0000000020000000))
/* INIT3_MDISCACK default: 0x00000003
debug status from init3 - ack to MDiscReq from standby protocol
*/
#define RGX_CR_OCP_DEBUG_STATUS_INIT3_MDISCACK_SHIFT      (27U)
#define RGX_CR_OCP_DEBUG_STATUS_INIT3_MDISCACK_CLRMSK     (IMG_UINT64_C(0XFFFFFFFFE7FFFFFF))
/* INIT3_SCONNECT
debug status from init3 - disconnect state from slave
*/
#define RGX_CR_OCP_DEBUG_STATUS_INIT3_SCONNECT_SHIFT      (26U)
#define RGX_CR_OCP_DEBUG_STATUS_INIT3_SCONNECT_CLRMSK     (IMG_UINT64_C(0XFFFFFFFFFBFFFFFF))
#define RGX_CR_OCP_DEBUG_STATUS_INIT3_SCONNECT_EN         (IMG_UINT64_C(0X0000000004000000))
/* INIT3_MCONNECT
debug status from init3 - initiator mconnect state
*/
#define RGX_CR_OCP_DEBUG_STATUS_INIT3_MCONNECT_SHIFT      (24U)
#define RGX_CR_OCP_DEBUG_STATUS_INIT3_MCONNECT_CLRMSK     (IMG_UINT64_C(0XFFFFFFFFFCFFFFFF))
/* INIT2_RESERVED
debug status from init2 - reserved
*/
#define RGX_CR_OCP_DEBUG_STATUS_INIT2_RESERVED_SHIFT      (23U)
#define RGX_CR_OCP_DEBUG_STATUS_INIT2_RESERVED_CLRMSK     (IMG_UINT64_C(0XFFFFFFFFFF7FFFFF))
#define RGX_CR_OCP_DEBUG_STATUS_INIT2_RESERVED_EN         (IMG_UINT64_C(0X0000000000800000))
/* INIT2_SWAIT
debug status from init2 - defines whether to wait in M_WAIT state for MConnect
*/
#define RGX_CR_OCP_DEBUG_STATUS_INIT2_SWAIT_SHIFT         (22U)
#define RGX_CR_OCP_DEBUG_STATUS_INIT2_SWAIT_CLRMSK        (IMG_UINT64_C(0XFFFFFFFFFFBFFFFF))
#define RGX_CR_OCP_DEBUG_STATUS_INIT2_SWAIT_EN            (IMG_UINT64_C(0X0000000000400000))
/* INIT2_MDISCREQ default: 0x00000001
debug status from init2 - request to disconnect from standby protocol
*/
#define RGX_CR_OCP_DEBUG_STATUS_INIT2_MDISCREQ_SHIFT      (21U)
#define RGX_CR_OCP_DEBUG_STATUS_INIT2_MDISCREQ_CLRMSK     (IMG_UINT64_C(0XFFFFFFFFFFDFFFFF))
#define RGX_CR_OCP_DEBUG_STATUS_INIT2_MDISCREQ_EN         (IMG_UINT64_C(0X0000000000200000))
/* INIT2_MDISCACK default: 0x00000003
debug status from init2 - ack to MDiscReq from standby protocol
*/
#define RGX_CR_OCP_DEBUG_STATUS_INIT2_MDISCACK_SHIFT      (19U)
#define RGX_CR_OCP_DEBUG_STATUS_INIT2_MDISCACK_CLRMSK     (IMG_UINT64_C(0XFFFFFFFFFFE7FFFF))
/* INIT2_SCONNECT
debug status from init2 - disconnect state from slave
*/
#define RGX_CR_OCP_DEBUG_STATUS_INIT2_SCONNECT_SHIFT      (18U)
#define RGX_CR_OCP_DEBUG_STATUS_INIT2_SCONNECT_CLRMSK     (IMG_UINT64_C(0XFFFFFFFFFFFBFFFF))
#define RGX_CR_OCP_DEBUG_STATUS_INIT2_SCONNECT_EN         (IMG_UINT64_C(0X0000000000040000))
/* INIT2_MCONNECT
debug status from init2 - initiator mconnect state
*/
#define RGX_CR_OCP_DEBUG_STATUS_INIT2_MCONNECT_SHIFT      (16U)
#define RGX_CR_OCP_DEBUG_STATUS_INIT2_MCONNECT_CLRMSK     (IMG_UINT64_C(0XFFFFFFFFFFFCFFFF))
/* INIT1_RESERVED
debug status from init1 - reserved
*/
#define RGX_CR_OCP_DEBUG_STATUS_INIT1_RESERVED_SHIFT      (15U)
#define RGX_CR_OCP_DEBUG_STATUS_INIT1_RESERVED_CLRMSK     (IMG_UINT64_C(0XFFFFFFFFFFFF7FFF))
#define RGX_CR_OCP_DEBUG_STATUS_INIT1_RESERVED_EN         (IMG_UINT64_C(0X0000000000008000))
/* INIT1_SWAIT
debug status from init1 - defines whether to wait in M_WAIT state for MConnect
*/
#define RGX_CR_OCP_DEBUG_STATUS_INIT1_SWAIT_SHIFT         (14U)
#define RGX_CR_OCP_DEBUG_STATUS_INIT1_SWAIT_CLRMSK        (IMG_UINT64_C(0XFFFFFFFFFFFFBFFF))
#define RGX_CR_OCP_DEBUG_STATUS_INIT1_SWAIT_EN            (IMG_UINT64_C(0X0000000000004000))
/* INIT1_MDISCREQ default: 0x00000001
debug status from init1 - request to disconnect from standby protocol
*/
#define RGX_CR_OCP_DEBUG_STATUS_INIT1_MDISCREQ_SHIFT      (13U)
#define RGX_CR_OCP_DEBUG_STATUS_INIT1_MDISCREQ_CLRMSK     (IMG_UINT64_C(0XFFFFFFFFFFFFDFFF))
#define RGX_CR_OCP_DEBUG_STATUS_INIT1_MDISCREQ_EN         (IMG_UINT64_C(0X0000000000002000))
/* INIT1_MDISCACK default: 0x00000003
debug status from init1 - ack to MDiscReq from standby protocol
*/
#define RGX_CR_OCP_DEBUG_STATUS_INIT1_MDISCACK_SHIFT      (11U)
#define RGX_CR_OCP_DEBUG_STATUS_INIT1_MDISCACK_CLRMSK     (IMG_UINT64_C(0XFFFFFFFFFFFFE7FF))
/* INIT1_SCONNECT
debug status from init1 - disconnect state from slave
*/
#define RGX_CR_OCP_DEBUG_STATUS_INIT1_SCONNECT_SHIFT      (10U)
#define RGX_CR_OCP_DEBUG_STATUS_INIT1_SCONNECT_CLRMSK     (IMG_UINT64_C(0XFFFFFFFFFFFFFBFF))
#define RGX_CR_OCP_DEBUG_STATUS_INIT1_SCONNECT_EN         (IMG_UINT64_C(0X0000000000000400))
/* INIT1_MCONNECT
debug status from init1 - initiator mconnect state
*/
#define RGX_CR_OCP_DEBUG_STATUS_INIT1_MCONNECT_SHIFT      (8U)
#define RGX_CR_OCP_DEBUG_STATUS_INIT1_MCONNECT_CLRMSK     (IMG_UINT64_C(0XFFFFFFFFFFFFFCFF))
/* INIT0_RESERVED
debug status from init0 - reserved
*/
#define RGX_CR_OCP_DEBUG_STATUS_INIT0_RESERVED_SHIFT      (7U)
#define RGX_CR_OCP_DEBUG_STATUS_INIT0_RESERVED_CLRMSK     (IMG_UINT64_C(0XFFFFFFFFFFFFFF7F))
#define RGX_CR_OCP_DEBUG_STATUS_INIT0_RESERVED_EN         (IMG_UINT64_C(0X0000000000000080))
/* INIT0_SWAIT
debug status from init0 - defines whether to wait in M_WAIT state for MConnect
*/
#define RGX_CR_OCP_DEBUG_STATUS_INIT0_SWAIT_SHIFT         (6U)
#define RGX_CR_OCP_DEBUG_STATUS_INIT0_SWAIT_CLRMSK        (IMG_UINT64_C(0XFFFFFFFFFFFFFFBF))
#define RGX_CR_OCP_DEBUG_STATUS_INIT0_SWAIT_EN            (IMG_UINT64_C(0X0000000000000040))
/* INIT0_MDISCREQ default: 0x00000001
debug status from init0 - request to disconnect from standby protocol
*/
#define RGX_CR_OCP_DEBUG_STATUS_INIT0_MDISCREQ_SHIFT      (5U)
#define RGX_CR_OCP_DEBUG_STATUS_INIT0_MDISCREQ_CLRMSK     (IMG_UINT64_C(0XFFFFFFFFFFFFFFDF))
#define RGX_CR_OCP_DEBUG_STATUS_INIT0_MDISCREQ_EN         (IMG_UINT64_C(0X0000000000000020))
/* INIT0_MDISCACK default: 0x00000003
debug status from init0 - ack to MDiscReq from standby protocol
*/
#define RGX_CR_OCP_DEBUG_STATUS_INIT0_MDISCACK_SHIFT      (3U)
#define RGX_CR_OCP_DEBUG_STATUS_INIT0_MDISCACK_CLRMSK     (IMG_UINT64_C(0XFFFFFFFFFFFFFFE7))
/* INIT0_SCONNECT
debug status from init0 - disconnect state from slave
*/
#define RGX_CR_OCP_DEBUG_STATUS_INIT0_SCONNECT_SHIFT      (2U)
#define RGX_CR_OCP_DEBUG_STATUS_INIT0_SCONNECT_CLRMSK     (IMG_UINT64_C(0XFFFFFFFFFFFFFFFB))
#define RGX_CR_OCP_DEBUG_STATUS_INIT0_SCONNECT_EN         (IMG_UINT64_C(0X0000000000000004))
/* INIT0_MCONNECT
debug status from init0 - initiator mconnect state
*/
#define RGX_CR_OCP_DEBUG_STATUS_INIT0_MCONNECT_SHIFT      (0U)
#define RGX_CR_OCP_DEBUG_STATUS_INIT0_MCONNECT_CLRMSK     (IMG_UINT64_C(0XFFFFFFFFFFFFFFFC))


/* PM_ALIST*/
#define RGX_CR_BIF_TRUST_DM_TYPE_PM_ALIST_SHIFT           (6U)
#define RGX_CR_BIF_TRUST_DM_TYPE_PM_ALIST_CLRMSK          (0XFFFFFFBFU)
#define RGX_CR_BIF_TRUST_DM_TYPE_PM_ALIST_EN              (0X00000040U)
/* HOST*/
#define RGX_CR_BIF_TRUST_DM_TYPE_HOST_SHIFT               (5U)
#define RGX_CR_BIF_TRUST_DM_TYPE_HOST_CLRMSK              (0XFFFFFFDFU)
#define RGX_CR_BIF_TRUST_DM_TYPE_HOST_EN                  (0X00000020U)
/* META*/
#define RGX_CR_BIF_TRUST_DM_TYPE_META_SHIFT               (4U)
#define RGX_CR_BIF_TRUST_DM_TYPE_META_CLRMSK              (0XFFFFFFEFU)
#define RGX_CR_BIF_TRUST_DM_TYPE_META_EN                  (0X00000010U)
/* PB_ZLS*/
#define RGX_CR_BIF_TRUST_DM_TYPE_PB_ZLS_SHIFT             (3U)
#define RGX_CR_BIF_TRUST_DM_TYPE_PB_ZLS_CLRMSK            (0XFFFFFFF7U)
#define RGX_CR_BIF_TRUST_DM_TYPE_PB_ZLS_EN                (0X00000008U)
/* PB_TE*/
#define RGX_CR_BIF_TRUST_DM_TYPE_PB_TE_SHIFT              (2U)
#define RGX_CR_BIF_TRUST_DM_TYPE_PB_TE_CLRMSK             (0XFFFFFFFBU)
#define RGX_CR_BIF_TRUST_DM_TYPE_PB_TE_EN                 (0X00000004U)
/* PB_VCE*/
#define RGX_CR_BIF_TRUST_DM_TYPE_PB_VCE_SHIFT             (1U)
#define RGX_CR_BIF_TRUST_DM_TYPE_PB_VCE_CLRMSK            (0XFFFFFFFDU)
#define RGX_CR_BIF_TRUST_DM_TYPE_PB_VCE_EN                (0X00000002U)
/* TLA*/
#define RGX_CR_BIF_TRUST_DM_TYPE_TLA_SHIFT                (0U)
#define RGX_CR_BIF_TRUST_DM_TYPE_TLA_CLRMSK               (0XFFFFFFFEU)
#define RGX_CR_BIF_TRUST_DM_TYPE_TLA_EN                   (0X00000001U)


#define RGX_CR_BIF_TRUST_DM_MASK                          (0x0000007FU)


/*
 Define Requestors/Data Masters which are Trusted/Untrusted and enable/disbale the Memory Bus Security feature within the Core 

  When enabled the GPU modifies the top 2 bits of the external memory address to indicate:
  - Address[39] Trusted DM Access (according to the DM Trusted setup)
  - Address[38] META Code Access

  Setting this bit effectively reduces the external physical address range from 1TB to 256 GB, and should only be used where the SOC implementation has a corresponding trust implementation.

*/
/*
    Register RGX_CR_BIF_TRUST
*/
#define RGX_CR_BIF_TRUST                                  (0xA000U)
#define RGX_CR_BIF_TRUST_MASKFULL                         (IMG_UINT64_C(0x000000000001FFFF))
/* ENABLE
Enable Security feature: 0x1 = Enabled, 0x0 = Disabled
*/
#define RGX_CR_BIF_TRUST_ENABLE_SHIFT                     (16U)
#define RGX_CR_BIF_TRUST_ENABLE_CLRMSK                    (0XFFFEFFFFU)
#define RGX_CR_BIF_TRUST_ENABLE_EN                        (0X00010000U)
/* DM_TRUSTED
Mask of bits which defines which of the remaining Data Masters are trusted: 0x1 = Trusted, 0x0 = Untrusted
*/
#define RGX_CR_BIF_TRUST_DM_TRUSTED_SHIFT                 (9U)
#define RGX_CR_BIF_TRUST_DM_TRUSTED_CLRMSK                (0XFFFF01FFU)
/* OTHER_COMPUTE_DM_TRUSTED
Defines whether other accesses with the Compute DM are trusted: 0x1 = Trusted, 0x0 = Untrusted
*/
#define RGX_CR_BIF_TRUST_OTHER_COMPUTE_DM_TRUSTED_SHIFT   (8U)
#define RGX_CR_BIF_TRUST_OTHER_COMPUTE_DM_TRUSTED_CLRMSK  (0XFFFFFEFFU)
#define RGX_CR_BIF_TRUST_OTHER_COMPUTE_DM_TRUSTED_EN      (0X00000100U)
/* MCU_COMPUTE_DM_TRUSTED
Defines whether MCU accesses with the Compute DM are trusted: 0x1 = Trusted, 0x0 = Untrusted
*/
#define RGX_CR_BIF_TRUST_MCU_COMPUTE_DM_TRUSTED_SHIFT     (7U)
#define RGX_CR_BIF_TRUST_MCU_COMPUTE_DM_TRUSTED_CLRMSK    (0XFFFFFF7FU)
#define RGX_CR_BIF_TRUST_MCU_COMPUTE_DM_TRUSTED_EN        (0X00000080U)
/* PBE_COMPUTE_DM_TRUSTED
Defines whether PBE accesses with the Compute DM are trusted: 0x1 = Trusted, 0x0 = Untrusted
*/
#define RGX_CR_BIF_TRUST_PBE_COMPUTE_DM_TRUSTED_SHIFT     (6U)
#define RGX_CR_BIF_TRUST_PBE_COMPUTE_DM_TRUSTED_CLRMSK    (0XFFFFFFBFU)
#define RGX_CR_BIF_TRUST_PBE_COMPUTE_DM_TRUSTED_EN        (0X00000040U)
/* OTHER_PIXEL_DM_TRUSTED
Defines whether other accesses with the Pixel DM are trusted: 0x1 = Trusted, 0x0 = Untrusted
*/
#define RGX_CR_BIF_TRUST_OTHER_PIXEL_DM_TRUSTED_SHIFT     (5U)
#define RGX_CR_BIF_TRUST_OTHER_PIXEL_DM_TRUSTED_CLRMSK    (0XFFFFFFDFU)
#define RGX_CR_BIF_TRUST_OTHER_PIXEL_DM_TRUSTED_EN        (0X00000020U)
/* MCU_PIXEL_DM_TRUSTED
Defines whether MCU accesses with the Pixel DM are trusted: 0x1 = Trusted, 0x0 = Untrusted
*/
#define RGX_CR_BIF_TRUST_MCU_PIXEL_DM_TRUSTED_SHIFT       (4U)
#define RGX_CR_BIF_TRUST_MCU_PIXEL_DM_TRUSTED_CLRMSK      (0XFFFFFFEFU)
#define RGX_CR_BIF_TRUST_MCU_PIXEL_DM_TRUSTED_EN          (0X00000010U)
/* PBE_PIXEL_DM_TRUSTED
Defines whether PBE accesses with the Pixel DM are trusted: 0x1 = Trusted, 0x0 = Untrusted
*/
#define RGX_CR_BIF_TRUST_PBE_PIXEL_DM_TRUSTED_SHIFT       (3U)
#define RGX_CR_BIF_TRUST_PBE_PIXEL_DM_TRUSTED_CLRMSK      (0XFFFFFFF7U)
#define RGX_CR_BIF_TRUST_PBE_PIXEL_DM_TRUSTED_EN          (0X00000008U)
/* OTHER_VERTEX_DM_TRUSTED
Defines whether other accesses with the Vertex DM are trusted: 0x1 = Trusted, 0x0 = Untrusted
*/
#define RGX_CR_BIF_TRUST_OTHER_VERTEX_DM_TRUSTED_SHIFT    (2U)
#define RGX_CR_BIF_TRUST_OTHER_VERTEX_DM_TRUSTED_CLRMSK   (0XFFFFFFFBU)
#define RGX_CR_BIF_TRUST_OTHER_VERTEX_DM_TRUSTED_EN       (0X00000004U)
/* MCU_VERTEX_DM_TRUSTED
Defines whether MCU accesses with the Vertex DM are trusted: 0x1 = Trusted, 0x0 = Untrusted
*/
#define RGX_CR_BIF_TRUST_MCU_VERTEX_DM_TRUSTED_SHIFT      (1U)
#define RGX_CR_BIF_TRUST_MCU_VERTEX_DM_TRUSTED_CLRMSK     (0XFFFFFFFDU)
#define RGX_CR_BIF_TRUST_MCU_VERTEX_DM_TRUSTED_EN         (0X00000002U)
/* PBE_VERTEX_DM_TRUSTED
Defines whether PBE accesses with the Vertex DM are trusted: 0x1 = Trusted, 0x0 = Untrusted
*/
#define RGX_CR_BIF_TRUST_PBE_VERTEX_DM_TRUSTED_SHIFT      (0U)
#define RGX_CR_BIF_TRUST_PBE_VERTEX_DM_TRUSTED_CLRMSK     (0XFFFFFFFEU)
#define RGX_CR_BIF_TRUST_PBE_VERTEX_DM_TRUSTED_EN         (0X00000001U)


/*
    Register RGX_CR_SYS_BUS_SECURE
*/
#define RGX_CR_SYS_BUS_SECURE                             (0xA100U)
#define RGX_CR_SYS_BUS_SECURE_MASKFULL                    (IMG_UINT64_C(0x0000000000000001))
/* Enable
0 = No System Bus Security1 = System Bus Restricted
*/
#define RGX_CR_SYS_BUS_SECURE_ENABLE_SHIFT                (0U)
#define RGX_CR_SYS_BUS_SECURE_ENABLE_CLRMSK               (0XFFFFFFFEU)
#define RGX_CR_SYS_BUS_SECURE_ENABLE_EN                   (0X00000001U)


/*

	Core Module Clock Control Modes.


	Allows individual domain clocks to be forced off, forced on or operate under automatic pipeline activity based clock gating. This register is generally controlled by the GPU firmware and should be set to AUTO. Clock gating reduces the power consumed by the device.

*/
/*
    Register RGX_CR_CLK_CTRL2
*/
#define RGX_CR_CLK_CTRL2                                  (0xD200U)
#define RGX_CR_CLK_CTRL2_MASKFULL                         (IMG_UINT64_C(0x0000000000000F33))
/* MCU_FBTC default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL2_MCU_FBTC_SHIFT                   (10U)
#define RGX_CR_CLK_CTRL2_MCU_FBTC_CLRMSK                  (IMG_UINT64_C(0XFFFFFFFFFFFFF3FF))
#define RGX_CR_CLK_CTRL2_MCU_FBTC_OFF                     (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL2_MCU_FBTC_ON                      (IMG_UINT64_C(0x0000000000000400))
#define RGX_CR_CLK_CTRL2_MCU_FBTC_AUTO                    (IMG_UINT64_C(0x0000000000000800))
#if defined(RGX_FEATURE_RAY_TRACING)
/* VRDM default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL2_VRDM_SHIFT                       (8U)
#define RGX_CR_CLK_CTRL2_VRDM_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFFCFF))
#define RGX_CR_CLK_CTRL2_VRDM_OFF                         (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL2_VRDM_ON                          (IMG_UINT64_C(0x0000000000000100))
#define RGX_CR_CLK_CTRL2_VRDM_AUTO                        (IMG_UINT64_C(0x0000000000000200))
/* SH default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL2_SH_SHIFT                         (4U)
#define RGX_CR_CLK_CTRL2_SH_CLRMSK                        (IMG_UINT64_C(0XFFFFFFFFFFFFFFCF))
#define RGX_CR_CLK_CTRL2_SH_OFF                           (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL2_SH_ON                            (IMG_UINT64_C(0x0000000000000010))
#define RGX_CR_CLK_CTRL2_SH_AUTO                          (IMG_UINT64_C(0x0000000000000020))
/* FBA default: AUTO (0x00000002) */
#define RGX_CR_CLK_CTRL2_FBA_SHIFT                        (0U)
#define RGX_CR_CLK_CTRL2_FBA_CLRMSK                       (IMG_UINT64_C(0XFFFFFFFFFFFFFFFC))
#define RGX_CR_CLK_CTRL2_FBA_OFF                          (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_CTRL2_FBA_ON                           (IMG_UINT64_C(0x0000000000000001))
#define RGX_CR_CLK_CTRL2_FBA_AUTO                         (IMG_UINT64_C(0x0000000000000002))


#endif /* RGX_FEATURE_RAY_TRACING */

/*

	Reports the current module clock status


	Clock gating state reflects the condition of the clock for each module

*/
/*
    Register RGX_CR_CLK_STATUS2
*/
#define RGX_CR_CLK_STATUS2                                (0xD208U)
#define RGX_CR_CLK_STATUS2_MASKFULL                       (IMG_UINT64_C(0x0000000000000015))
#if defined(RGX_FEATURE_RAY_TRACING)
/* VRDM default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS2_VRDM_SHIFT                     (4U)
#define RGX_CR_CLK_STATUS2_VRDM_CLRMSK                    (IMG_UINT64_C(0XFFFFFFFFFFFFFFEF))
#define RGX_CR_CLK_STATUS2_VRDM_GATED                     (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS2_VRDM_RUNNING                   (IMG_UINT64_C(0x0000000000000010))
/* SH default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS2_SH_SHIFT                       (2U)
#define RGX_CR_CLK_STATUS2_SH_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFFFFB))
#define RGX_CR_CLK_STATUS2_SH_GATED                       (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS2_SH_RUNNING                     (IMG_UINT64_C(0x0000000000000004))
/* FBA default: GATED (0x00000000) */
#define RGX_CR_CLK_STATUS2_FBA_SHIFT                      (0U)
#define RGX_CR_CLK_STATUS2_FBA_CLRMSK                     (IMG_UINT64_C(0XFFFFFFFFFFFFFFFE))
#define RGX_CR_CLK_STATUS2_FBA_GATED                      (IMG_UINT64_C(0000000000000000))
#define RGX_CR_CLK_STATUS2_FBA_RUNNING                    (IMG_UINT64_C(0x0000000000000001))


#endif /* RGX_FEATURE_RAY_TRACING */

/*

   Indicates a page fault has occurred due to a non-Meta request and gives details of faulting request. Any write to this register will clear the contents and allow a subsequent fault to be reported

*/
/*
    Register RGX_CR_MMU_FAULT_STATUS
*/
#define RGX_CR_MMU_FAULT_STATUS                           (0xE150U)
#define RGX_CR_MMU_FAULT_STATUS_MASKFULL                  (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/* ADDRESS
Virtual address
*/
#define RGX_CR_MMU_FAULT_STATUS_ADDRESS_SHIFT             (28U)
#define RGX_CR_MMU_FAULT_STATUS_ADDRESS_CLRMSK            (IMG_UINT64_C(0X000000000FFFFFFF))
/* CONTEXT
Context
*/
#define RGX_CR_MMU_FAULT_STATUS_CONTEXT_SHIFT             (20U)
#define RGX_CR_MMU_FAULT_STATUS_CONTEXT_CLRMSK            (IMG_UINT64_C(0XFFFFFFFFF00FFFFF))
/* TAG_SB
Sideband tag
*/
#define RGX_CR_MMU_FAULT_STATUS_TAG_SB_SHIFT              (12U)
#define RGX_CR_MMU_FAULT_STATUS_TAG_SB_CLRMSK             (IMG_UINT64_C(0XFFFFFFFFFFF00FFF))
/* REQ_ID
Requester ID - see rgx_bif3_pack/documentation for encoding
*/
#define RGX_CR_MMU_FAULT_STATUS_REQ_ID_SHIFT              (6U)
#define RGX_CR_MMU_FAULT_STATUS_REQ_ID_CLRMSK             (IMG_UINT64_C(0XFFFFFFFFFFFFF03F))
/* LEVEL
MMU level that faulted: "00"=PT "01"=PD "10"=PC "11"=PC Base
*/
#define RGX_CR_MMU_FAULT_STATUS_LEVEL_SHIFT               (4U)
#define RGX_CR_MMU_FAULT_STATUS_LEVEL_CLRMSK              (IMG_UINT64_C(0XFFFFFFFFFFFFFFCF))
/* RNW
Indicates whether fault was caused by a read(1) or write(0) request
*/
#define RGX_CR_MMU_FAULT_STATUS_RNW_SHIFT                 (3U)
#define RGX_CR_MMU_FAULT_STATUS_RNW_CLRMSK                (IMG_UINT64_C(0XFFFFFFFFFFFFFFF7))
#define RGX_CR_MMU_FAULT_STATUS_RNW_EN                    (IMG_UINT64_C(0X0000000000000008))
/* TYPE
Type of fault: "00"=valid "10"=read-only "11"=pm/meta protected
*/
#define RGX_CR_MMU_FAULT_STATUS_TYPE_SHIFT                (1U)
#define RGX_CR_MMU_FAULT_STATUS_TYPE_CLRMSK               (IMG_UINT64_C(0XFFFFFFFFFFFFFFF9))
/* FAULT
Indicates a fault has occured
*/
#define RGX_CR_MMU_FAULT_STATUS_FAULT_SHIFT               (0U)
#define RGX_CR_MMU_FAULT_STATUS_FAULT_CLRMSK              (IMG_UINT64_C(0XFFFFFFFFFFFFFFFE))
#define RGX_CR_MMU_FAULT_STATUS_FAULT_EN                  (IMG_UINT64_C(0X0000000000000001))


/*

   Indicates a page fault has occurred due to a Meta request and gives details of faulting request. Any write to this register will clear the contents and allow a subsequent fault to be reported

*/
/*
    Register RGX_CR_MMU_FAULT_STATUS_META
*/
#define RGX_CR_MMU_FAULT_STATUS_META                      (0xE158U)
#define RGX_CR_MMU_FAULT_STATUS_META_MASKFULL             (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/* ADDRESS
Virtual address
*/
#define RGX_CR_MMU_FAULT_STATUS_META_ADDRESS_SHIFT        (28U)
#define RGX_CR_MMU_FAULT_STATUS_META_ADDRESS_CLRMSK       (IMG_UINT64_C(0X000000000FFFFFFF))
/* CONTEXT
Context
*/
#define RGX_CR_MMU_FAULT_STATUS_META_CONTEXT_SHIFT        (20U)
#define RGX_CR_MMU_FAULT_STATUS_META_CONTEXT_CLRMSK       (IMG_UINT64_C(0XFFFFFFFFF00FFFFF))
/* TAG_SB
Sideband tag
*/
#define RGX_CR_MMU_FAULT_STATUS_META_TAG_SB_SHIFT         (12U)
#define RGX_CR_MMU_FAULT_STATUS_META_TAG_SB_CLRMSK        (IMG_UINT64_C(0XFFFFFFFFFFF00FFF))
/* REQ_ID
Requester ID - see rgx_bif3_pack/documentation for encoding
*/
#define RGX_CR_MMU_FAULT_STATUS_META_REQ_ID_SHIFT         (6U)
#define RGX_CR_MMU_FAULT_STATUS_META_REQ_ID_CLRMSK        (IMG_UINT64_C(0XFFFFFFFFFFFFF03F))
/* LEVEL
MMU level that faulted: "00"=PT "01"=PD "10"=PC "11"=PC Base
*/
#define RGX_CR_MMU_FAULT_STATUS_META_LEVEL_SHIFT          (4U)
#define RGX_CR_MMU_FAULT_STATUS_META_LEVEL_CLRMSK         (IMG_UINT64_C(0XFFFFFFFFFFFFFFCF))
/* RNW
Indicates whether fault was caused by a read(1) or write(0) request
*/
#define RGX_CR_MMU_FAULT_STATUS_META_RNW_SHIFT            (3U)
#define RGX_CR_MMU_FAULT_STATUS_META_RNW_CLRMSK           (IMG_UINT64_C(0XFFFFFFFFFFFFFFF7))
#define RGX_CR_MMU_FAULT_STATUS_META_RNW_EN               (IMG_UINT64_C(0X0000000000000008))
/* TYPE
Type of fault: "00"=valid "10"=read-only "11"=pm/meta protected
*/
#define RGX_CR_MMU_FAULT_STATUS_META_TYPE_SHIFT           (1U)
#define RGX_CR_MMU_FAULT_STATUS_META_TYPE_CLRMSK          (IMG_UINT64_C(0XFFFFFFFFFFFFFFF9))
/* FAULT
Indicates a fault has occured
*/
#define RGX_CR_MMU_FAULT_STATUS_META_FAULT_SHIFT          (0U)
#define RGX_CR_MMU_FAULT_STATUS_META_FAULT_CLRMSK         (IMG_UINT64_C(0XFFFFFFFFFFFFFFFE))
#define RGX_CR_MMU_FAULT_STATUS_META_FAULT_EN             (IMG_UINT64_C(0X0000000000000001))


/*

	SLC Control registers

*/
/*
    Register RGX_CR_SLC3_CTRL_MISC
*/
#define RGX_CR_SLC3_CTRL_MISC                             (0xE200U)
#define RGX_CR_SLC3_CTRL_MISC_MASKFULL                    (IMG_UINT64_C(0x0000000000000003))
/* ADDR_DECODE_MODE default: LINEAR (0x00000000)
(null)
*/
#define RGX_CR_SLC3_CTRL_MISC_ADDR_DECODE_MODE_SHIFT      (0U)
#define RGX_CR_SLC3_CTRL_MISC_ADDR_DECODE_MODE_CLRMSK     (0XFFFFFFFCU)
#define RGX_CR_SLC3_CTRL_MISC_ADDR_DECODE_MODE_LINEAR     (00000000U)
#define RGX_CR_SLC3_CTRL_MISC_ADDR_DECODE_MODE_IN_PAGE_HASH (0X00000001U)
#define RGX_CR_SLC3_CTRL_MISC_ADDR_DECODE_MODE_FIXED_PVR_HASH (0X00000002U)
#define RGX_CR_SLC3_CTRL_MISC_ADDR_DECODE_MODE_SCRAMBLE_PVR_HASH (0X00000003U)


/*

	SLC Control registers

*/
/*
    Register RGX_CR_SLC3_SCRAMBLE
*/
#define RGX_CR_SLC3_SCRAMBLE                              (0xE208U)
#define RGX_CR_SLC3_SCRAMBLE_MASKFULL                     (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/* BITS
 Pattern of bits used to determine the Cache Bank in Address Decode mode 0x3. The actual Cache Bank to use is determined by indexing into the Scramble Bits, see the SLC HW specification for more details 
*/
#define RGX_CR_SLC3_SCRAMBLE_BITS_SHIFT                   (0U)
#define RGX_CR_SLC3_SCRAMBLE_BITS_CLRMSK                  (IMG_UINT64_C(0000000000000000))


/*

	SLC Control registers

*/
/*
    Register RGX_CR_SLC3_SCRAMBLE2
*/
#define RGX_CR_SLC3_SCRAMBLE2                             (0xE210U)
#define RGX_CR_SLC3_SCRAMBLE2_MASKFULL                    (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/* BITS
 Pattern of bits used to determine the Cache Bank in Address Decode mode 0x3. The actual Cache Bank to use is determined by indexing into the Scramble Bits, see the SLC HW specification for more details 
*/
#define RGX_CR_SLC3_SCRAMBLE2_BITS_SHIFT                  (0U)
#define RGX_CR_SLC3_SCRAMBLE2_BITS_CLRMSK                 (IMG_UINT64_C(0000000000000000))


#endif /* _RGX_CR_DEFS_KM_H_ */

/*****************************************************************************
 End of file (rgx_cr_defs_km.h)
*****************************************************************************/

