INSTALL_DESTDIR := ${SW_STAGING_DIR}
CC 	:= ${.CROSS}gcc

SDL_GFX_PATH :=${SOC_PATH}/sw/libraries/LGPL/sdl_gfx/v1/SDL_gfx-2.0.22

SDL_GFX_INC := -I${SOC_PATH}/sw/libraries/LGPL/sdl/v2/sdllib/include/SDL	\
	       -I${SOC_PATH}/sw/libraries/PW/UNJ_Library_API/include/		\
	       -I${SOC_PATH}/sw/libraries/GPL/sdl_gfx/v1/SDL_gfx-2.0.22/

ifeq ($(TARGET_TOOL_CHAIN),thumb-uclibc)
SDL_GFX_INC += -mthumb
endif

SDL_GFX_OBJS := SDL_framerate.o SDL_gfxBlitFunc.o SDL_gfxPrimitives.o SDL_imageFilter.o SDL_rotozoom.o

sw_all: image install

image : .SDL_GFX_image.timestamp

.SDL_GFX_image.timestamp:
	${CC} ${SDL_GFX_INC}  -fPIC -c ${SDL_GFX_PATH}/SDL_framerate.c
	${CC} ${SDL_GFX_INC}  -fPIC -c ${SDL_GFX_PATH}/SDL_gfxBlitFunc.c
	${CC} ${SDL_GFX_INC}  -fPIC -c ${SDL_GFX_PATH}/SDL_gfxPrimitives.c
	${CC} ${SDL_GFX_INC}  -fPIC -c ${SDL_GFX_PATH}/SDL_imageFilter.c
	${CC} ${SDL_GFX_INC}  -fPIC -c ${SDL_GFX_PATH}/SDL_rotozoom.c

	${CC} -shared -Wl,-soname,libSDL_GFX.so.1 -o libSDL_GFX.so.1.0.1	\
		${SDL_GFX_INC} ${SDL_GFX_OBJS}
	pwd
	ln -sf libSDL_GFX.so.1.0.1 libSDL_GFX.so
	ln -sf libSDL_GFX.so.1.0.1 libSDL_GFX.so.1
	${RM} -f *.o
	mkdir -p ${SOC_PATH}/sw/libraries/LGPL/sdl_gfx/v1/sdl_gfxlib
	cp -P *.so* ${SOC_PATH}/sw/libraries/LGPL/sdl_gfx/v1/sdl_gfxlib
	${CP} -P ${SOC_PATH}/sw/libraries/LGPL/sdl_gfx/v1/sdl_gfxlib/*   ${INSTALL_DESTDIR}/lib/.
	@touch $@

install: .install.timestamp
.install.timestamp:
	$(call sw_package_install)
	@touch $@

sw_veryclean sw_clean:
	${RM} .*.timestamp
	${RM} *.so*
	${RM} *.o
	${RM} -rf ${SOC_PATH}/sw/libraries/LGPL/sdl_gfx/v1/sdl_gfxlib

