#linux v7
KERNEL_ARCH  := arm
KERNEL_CROSS := ${.CROSS}
 
KDIR    := linux

MODULE_INST_PATH 	:= ${SW_STAGING_DIR}
APPPATH             := ${SW_OS_PATH}/linux_fs/${LINUX_FS_VARIANT}/rootfs/app

# copy the source tarball into the release package
include ./filelist.mk
ifeq (1,$(RELEASE))
prepview: copy_vendor_src
	cp include/pwirq.h ${SW_COMMON_INSTALL_DEST}
	cp include/pwgpio.h ${SW_COMMON_INSTALL_DEST}
	cp include/pwwdog.h ${SW_COMMON_INSTALL_DEST}
	cp include/pw2wireslave.h ${SW_COMMON_INSTALL_DEST}
	cp include/pw2wire.h ${SW_COMMON_INSTALL_DEST}
else
prepview:
	cp include/pwirq.h ${SW_COMMON_INSTALL_DEST}
	cp include/pwgpio.h ${SW_COMMON_INSTALL_DEST}
	cp include/pwwdog.h ${SW_COMMON_INSTALL_DEST}
	cp include/pw2wireslave.h ${SW_COMMON_INSTALL_DEST}
	cp include/pw2wire.h ${SW_COMMON_INSTALL_DEST}
endif

RAL_NATIVE_PATH := $(SW_LIBRARIES_PATH)/PW/ral/le32bit/

PACKAGE_EVAR := MKIMAGE_BIN='${MKIMAGE}'
PACKAGE_OPTS := ARCH='${KERNEL_ARCH}' CROSS_COMPILE='${KERNEL_CROSS}' \
                INSTALL_MOD_PATH='${MODULE_INST_PATH}' INSTALL_MOD_STRIP=1 DEPMOD=: \
                KALLSYMS_EXTRA_PASS=1 \
                SW_COMMON_INSTALL_DEST=${SW_COMMON_INSTALL_DEST} \
                SW_LIB_PATH=${SW_LIB_PATH} \
		RAL_NATIVE_PATH=$(RAL_NATIVE_PATH)
PACKAGE_BASE := ${KDIR}

.PHONY: unpack menuconfig image _image usbtest clean realclean veryclean

sw_build              : sw_bin
sw_bin                : image sw_install
sw_clean sw_cleanhere : clean
sw_veryclean	      : clean realclean

ifeq ($(wildcard ${KDIR}/.git),)
unpack: .unpack
.unpack:
	$(call sw_package_unpack,${KERNEL_TAR},,${KDIR})
	$(call sw-say-and-do,APPLY,$(SHELL) apply-patch-series.sh ${KDIR} patches)
	$(call sw-say-and-do,APPLY,$(SHELL) apply-patch-series.sh ${KDIR} config)
	#$(shell $(FIND) src -type f -o -name .svn -prune -false)
	$(call sw_package_build,${KERNEL_CONFIG})
	$(call sw_package_build,scripts/dtc/)
	touch $@

apply:
	@$(call sw-say-and-do,APPLY,$(SHELL) apply-patch-series.sh ${KDIR} patches)
	@$(call sw-say-and-do,APPLY,$(SHELL) apply-patch-series.sh ${KDIR} config)

unapply:
	@$(call sw-say-and-do,UNAPPLY,$(SHELL) unapply-patch-series.sh ${KDIR} config)
	@$(call sw-say-and-do,UNAPPLY,$(SHELL) unapply-patch-series.sh ${KDIR} patches)
else
$(info Using git tree)
unpack: .unpack
.unpack:
	touch ${KDIR}/.scmversion
	$(call sw_package_build,${KERNEL_CONFIG})
	$(call sw_package_build,scripts/dtc/)
	touch $@
endif

menuconfig: .unpack
	$(call sw_package_build,menuconfig)

# this allows calling arbitrary kernel make targets,
# e.g. "make L T=lib/string.s"
L:
	$(call sw_package_build,$(T))

image: .image
.image: .unpack
	$(call sw_package_build,-j4 zImage)
	# fix non-executable
	chmod a+x ${KDIR}/scripts/sysmap2dts
	$(call sw_package_build,dtbs)

ifeq (${TARGET_PLATFORM},eval-1)
	${CAT} ${KDIR}/arch/arm/boot/zImage ${KDIR}/arch/arm/boot/dts/pixelworks-topazeh-eval.dtb > ${KDIR}/dtbImage
else
	${CAT} ${KDIR}/arch/arm/boot/zImage ${KDIR}/arch/arm/boot/pixelworks-topazeh-fpga.dtb > ${KDIR}/dtbImage
endif

	$(call sw_package_build,-j4 modules)
	$(call sw_package_build,modules_install)
	@echo "Linux kernel zImage and modules ready"
ifeq ($(wildcard ${KDIR}/.git),)
	touch $@
endif
$(call sw_install,${KDIR}/arch/arm/mach-pixelworks/include/pxlw/pwirq.h,${SW_COMMON_INSTALL_DEST})
$(call sw_install,${KDIR}/arch/arm/mach-pixelworks/include/pxlw/pwgpio.h,${SW_COMMON_INSTALL_DEST})
$(call sw_install,${KDIR}/arch/arm/mach-pixelworks/include/pxlw/pwwdog.h,${SW_COMMON_INSTALL_DEST})
$(call sw_install,${KDIR}/arch/arm/mach-pixelworks/include/pxlw/pw2wireslave.h,${SW_COMMON_INSTALL_DEST})
$(call sw_install,${KDIR}/arch/arm/mach-pixelworks/include/pxlw/pw2wire.h,${SW_COMMON_INSTALL_DEST})
$(call sw_install,${KDIR}/dtbImage,${SW_INSTALL_IMG_DEST})
$(call sw_install,${KDIR}/arch/arm/boot/zImage,${SW_INSTALL_IMG_DEST})
$(call sw_install,${KDIR}/System.map,${SW_INSTALL_IMG_DEST})

usbtest:
	$(call sw_package_build,tools/usb)
	cp ${KDIR}/tools/usb/testusb ${APPPATH}
	cp ${KDIR}/tools/usb/ffs-test ${APPPATH}

clean:
	$(call sw_package_build,clean)
	rm -f .image

realclean veryclean:
	rm -f .image .unpack
ifeq ($(wildcard ${KDIR}/.git),)
	rm -rf ${KDIR}
endif
