/*
 * Copyright (C) 2013 Pixelworks, Inc.
 * based on linux-3.6.3 clk-fixed-factor.c:
 * Copyright (C) 2011 Sascha Hauer, Pengutronix <s.hauer@pengutronix.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * Standard functionality for the common clock API.
 */

#include <linux/clk-provider.h>

/**
 * struct clk_fixed_divider - fixed divider clock
 *
 * @hw:                handle between common and hardware-specific interfaces
 * @div:       divider
 *
 * Clock with a fixed divider. The output frequency is the
 * parent clock rate divided by div.
 * Implements .recalc_rate, .set_rate and .round_rate
 */

struct clk_fixed_divider {
       struct clk_hw   hw;
       unsigned int    div;
       char            *parent[1];
};

extern struct clk_ops clk_fixed_divider_ops;
struct clk *clk_register_fixed_divider(struct device *dev, const char *name,
               const char *parent_name, unsigned long flags,
               unsigned int div);

