/*
 * Copyright (C) 2013 Pixelworks, Inc.
 * based on clk-provider.h:
 *  Copyright (c) 2010-2011 Jeremy Kerr <jeremy.kerr@canonical.com>
 *  Copyright (C) 2011-2012 Linaro Ltd <mturquette@linaro.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/clk-provider.h>

/**
 * struct clk_divider_en - adjustable divider clock with update enable
 *
 * @hw:                handle between common and hardware-specific interfaces
 * @reg:       register containing the divider
 * @shift:     shift to the divider bit field
 * @width:     width of the divider bit field
 * @regen:     register containing the update enable bit
 * @bit_idx:   single bit controlling update enable
 * @lock:      register lock
 *
 * Clock with an adjustable divider affecting its output frequency.  Implements
 * .recalc_rate, .set_rate and .round_rate.
 *
 * Flags:
 * CLK_DIVIDER_ONE_BASED - by default the divisor is the value read from the
 *     register plus one.  If CLK_DIVIDER_ONE_BASED is set then the divider is
 *     the raw value read from the register, with the value of zero considered
 *     invalid
 * CLK_DIVIDER_POWER_OF_TWO - clock divisor is 2 raised to the value read from
 *     the hardware register
 */
struct clk_divider_en {
       struct clk_hw   hw;
       void __iomem    *reg;
       u8              shift;
       u8              width;
       void __iomem    *regen;
       u8              bit_idx;
       u8              flags;
       spinlock_t      *lock;
       char            *parent[1];
};

#define CLK_DIVIDER_ONE_BASED          BIT(0)
#define CLK_DIVIDER_POWER_OF_TWO       BIT(1)

extern struct clk_ops clk_divider_en_ops;

struct clk *clk_register_divider_en(struct device *dev, const char *name,
               const char *parent_name, unsigned long flags,
               void __iomem *reg, u8 shift, u8 width,
               void __iomem *regen, u8 bit_idx,
               u8 clk_divider_flags, spinlock_t *lock);

