/*
 *  Copyright (C) 2007-2012 Pixelworks, Inc.
 *  Copyright (C) 1999 - 2003 ARM Limited
 *  Copyright (C) 2000 Deep Blue Solutions Ltd
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <linux/init.h>
#include <linux/clk.h>
#include <linux/device.h>
#include <linux/dma-mapping.h>
#include <linux/interrupt.h>
#include <linux/of.h>
#include <linux/of_address.h>
#include <linux/of_irq.h>
#include <linux/of_platform.h>
#include <linux/stmmac.h>
#include <linux/amba/pl061.h>

#include <asm/barrier.h>
#include <asm/compiler.h>
#include <asm/cmpxchg.h>
#include <asm/exec.h>
#include <asm/switch_to.h>
#include <asm/system_info.h>
#include <asm/system_misc.h>

#include <asm/sizes.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/hardware/cache-l2x0.h>
#include <asm/mach-types.h>
#include <asm/mach/arch.h>
#include <asm/mach/irq.h>
#include <asm/mach/time.h>
#include <asm/mach/map.h>

#include <mach/hardware.h>
#include <mach/pwgpio.h>
#include <mach/ipc_wdog.h>
#include <mach/irqs.h>


/* the STATIC_REGS are preserved across watchdog reset, the value is
 * used by the boot loader to decide whether to reboot or go into
 * low power sleep
 */
static void topazeh_enter_low_power_sleep(void)
{
	// force enable the wdog clock
	writel(0, __io_address(SYS_BASE + 0x00c));

	writel(0x4c4f5750 /* "LOWP" */, __io_address(STATIC_REGS_BASE));
	writel(IPC_WDOG_UNLOCK, __io_address(WATCHDOG_BASE + IPC_WDOG_LOCK));
	writel(1, __io_address(WATCHDOG_BASE + IPC_WDOG_LOAD));
	writel(IPC_WDOG_CONTROL_ENABLE|IPC_WDOG_CONTROL_RESEN, __io_address(WATCHDOG_BASE + IPC_WDOG_CONTROL));
}

void topazeh_restart(enum reboot_mode mode, const char *cmd)
{
	// force enable the wdog clock
	writel(0, __io_address(SYS_BASE + 0x00c));

	/* perform reset using watchdog */
	writel(0x52454254 /* "REBT" */, __io_address(STATIC_REGS_BASE));
	writel(IPC_WDOG_UNLOCK, __io_address(WATCHDOG_BASE + IPC_WDOG_LOCK));
	writel(1, __io_address(WATCHDOG_BASE + IPC_WDOG_LOAD));
	writel(IPC_WDOG_CONTROL_ENABLE|IPC_WDOG_CONTROL_RESEN, __io_address(WATCHDOG_BASE + IPC_WDOG_CONTROL));
}


static void topazeh_fix_mac_speed(void *priv, unsigned int speed)
{
	// TODO
}

static struct stmmac_dma_cfg topezeh_eth_dma_cfg = {
        .pbl            = 32,
};
static struct stmmac_mdio_bus_data stmmacemdio_pdata;
static struct plat_stmmacenet_data stmmacenet_pdata = {
	.phy_addr = -1,	/* use first PHY found */
	.fix_mac_speed = topazeh_fix_mac_speed,
	.has_gmac = 1,
	.pmt = 1,
	.dma_cfg = &topezeh_eth_dma_cfg,
#ifdef MACH_PIXELWORKS_TOPAZEH_FPGA
	.clk_csr = 2, /* 20...35MHz */
#else
	.clk_csr = 5, /* 250-300MHz */
#endif
	.mdio_bus_data = &stmmacemdio_pdata,
};

/*
#define TOPAZEH_GPIO(n) \
static struct pl061_platform_data topazeh_gpio ## n ## _pdata = { \
	.gpio_base = n * 8, \
	.irq_base = GPIO_IRQ_BASE + n * 8, \
}

TOPAZEH_GPIO(0);
TOPAZEH_GPIO(1);
TOPAZEH_GPIO(2);
TOPAZEH_GPIO(3);
TOPAZEH_GPIO(4);
TOPAZEH_GPIO(5);
TOPAZEH_GPIO(6);
TOPAZEH_GPIO(7);
TOPAZEH_GPIO(8);
TOPAZEH_GPIO(9);
TOPAZEH_GPIO(10);
TOPAZEH_GPIO(11);
TOPAZEH_GPIO(12);
TOPAZEH_GPIO(13);
TOPAZEH_GPIO(14);
TOPAZEH_GPIO(15);

#define OF_TOPAZEH_GPIO(n) \
	OF_DEV_AUXDATA("pixelworks,pwgpio_v2", GPIO ## n ## _BASE, "gpio" #n, &topazeh_gpio ## n ##_pdata)
*/

static struct resource topazeh_adc8ch_resources[]={
        [0] = {
                .start  = ADC8CH_V3_BASE,
                .end    = ADC8CH_V3_BASE + 0x20000 - 1,
                .flags  = IORESOURCE_MEM
        },
        [1] = {
                .start  = -1,
                .end    = -1,
                .flags  = IORESOURCE_IRQ
        }

}; 

static struct platform_device topazeh_adc8ch_device = {
        .name           = "pwadc8ch",
        .id             = 0,
        .num_resources  = ARRAY_SIZE(topazeh_adc8ch_resources),
        .resource       = topazeh_adc8ch_resources
};

static struct of_dev_auxdata topazeh_dt_auxdata_lookup[] __initdata = {
	/* assign a sane names to UARTs etc. which is used to look up the clock */
	OF_DEV_AUXDATA("arm,pl011", UART0_BASE, "uart0", NULL),
	OF_DEV_AUXDATA("arm,pl011", UART1_BASE, "uart1", NULL),
	OF_DEV_AUXDATA("arm,pl011", UART2_BASE, "uart2", NULL),
	OF_DEV_AUXDATA("arm,pl011", UART3_BASE, "uart3", NULL),
	OF_DEV_AUXDATA("evatronix,sdio-host", SDIO_HOST0_V1_BASE, "sdhci0", NULL),
	OF_DEV_AUXDATA("evatronix,sdio-host", SDIO_HOST1_V1_BASE, "sdhci1", NULL),
	OF_DEV_AUXDATA("evatronix,nand-des-6h", NAND_FLASH_V1_BASE, "nand0", NULL),
	OF_DEV_AUXDATA("pixelworks,two_wire_v1", TWO_WIRE0_V1_BASE, "i2c0", NULL),
	OF_DEV_AUXDATA("pixelworks,two_wire_v1", TWO_WIRE1_V1_BASE, "i2c1", NULL),
	OF_DEV_AUXDATA("pixelworks,two_wire_v1", TWO_WIRE2_V1_BASE, "i2c2", NULL),
        //OF_DEV_AUXDATA("pixelworks,i2c-gpio",GPIO1_V2_BASE, "i2c3", NULL),
	OF_DEV_AUXDATA("pixelworks,i2s_delay_v2", I2SDLY_V2_BASE, "i2s0", NULL),
	OF_DEV_AUXDATA("st,spear600-gmac", ETH0_BASE, "eth0", &stmmacenet_pdata),
	OF_DEV_AUXDATA("arm,pl080", DMA8CH0_BASE, "dma8ch0", NULL),
	OF_DEV_AUXDATA("aurora,au-g0603", SPI0_BASE, "spi0", NULL),
	OF_DEV_AUXDATA("aurora,au-g0603", SPI1_BASE, "spi1", NULL),
	/*OF_TOPAZEH_GPIO(0),
	OF_TOPAZEH_GPIO(1),
	OF_TOPAZEH_GPIO(2),
	OF_TOPAZEH_GPIO(3),
	OF_TOPAZEH_GPIO(4),
	OF_TOPAZEH_GPIO(5),
	OF_TOPAZEH_GPIO(6),
	OF_TOPAZEH_GPIO(7),
	OF_TOPAZEH_GPIO(8),
	OF_TOPAZEH_GPIO(9),
	OF_TOPAZEH_GPIO(10),
	OF_TOPAZEH_GPIO(11),
	OF_TOPAZEH_GPIO(12),
	OF_TOPAZEH_GPIO(13),
	OF_TOPAZEH_GPIO(14),
	OF_TOPAZEH_GPIO(15), */
	{ }
};

/* for backwards compatibility we have one platform GPIO device
 * per real GPIO device to handle the ioctl API
 */
/*
#define TOPAZEH_GPIO_PDEV(n) \
static struct pwgpio_pdata topazeh_gpio ## n ## _pdevdata = { \
	.id = n, .gpio_base = GPIO ## n ## _BASE, .num_gpio = 8 }; \
static struct platform_device topazeh_gpio ## n ## _pdev = { \
	.name = "pwgpio", \
	.id = n, \
	.dev = { \
		.platform_data = &topazeh_gpio ## n ## _pdevdata, \
	} \
}
*/

#define _TOPAZEH_PDEV(_name, _id, _base, _size, _irq) \
static struct resource topazeh_## _name ## _id ## _resources[] = { \
        [0] = { .start = _base, .end = _base + _size - 1, .flags = IORESOURCE_MEM }, \
        [1] = { .start = _irq, .end = _irq, .flags = IORESOURCE_IRQ } }; \
static struct platform_device topazeh_ ## _name ## _id ## _pdev = { \
        .name = #_name, \
        .id = _id, \
        .num_resources  = ARRAY_SIZE(topazeh_ ## _name ## _id ## _resources), \
        .resource       = topazeh_ ## _name ## _id ## _resources, \
        .dev =
#define _TOPAZEH_PDEV_END }

#define TOPAZEH_PDEV(_name, _id, _base, _size, _irq, _pdata) \
        _TOPAZEH_PDEV(_name, _id, _base, _size, _irq) \
                { .platform_data = _pdata } \
        _TOPAZEH_PDEV_END

#define TOPAZEH_GPIO_PDEV(n, irq, pdata) \
        TOPAZEH_PDEV(pwgpio, n, GPIO ## n ## _BASE, 0x424, irq, pdata)

TOPAZEH_GPIO_PDEV(0,  IRQ_GPIO0_GPIO1, 0x00);
TOPAZEH_GPIO_PDEV(1,  IRQ_GPIO0_GPIO1, 0x00);
TOPAZEH_GPIO_PDEV(2,  IRQ_GPIO2_GPIO3, 0x00);
TOPAZEH_GPIO_PDEV(3,  IRQ_GPIO2_GPIO3, 0x00);
TOPAZEH_GPIO_PDEV(4,  IRQ_GPIO4_GPIO7, 0x00);
TOPAZEH_GPIO_PDEV(5,  IRQ_GPIO4_GPIO7, 0x00);
TOPAZEH_GPIO_PDEV(6,  IRQ_GPIO4_GPIO7, 0x00);
TOPAZEH_GPIO_PDEV(7,  IRQ_GPIO4_GPIO7, 0x00);
TOPAZEH_GPIO_PDEV(8,  IRQ_GPIO8_GPIO11, 0x00);
TOPAZEH_GPIO_PDEV(9,  IRQ_GPIO8_GPIO11, 0x00);
TOPAZEH_GPIO_PDEV(10,  IRQ_GPIO8_GPIO11, 0x00);
TOPAZEH_GPIO_PDEV(11,  IRQ_GPIO8_GPIO11, 0x00);
TOPAZEH_GPIO_PDEV(12,  IRQ_GPIO12_GPIO15, 0x00);
TOPAZEH_GPIO_PDEV(13,  IRQ_GPIO12_GPIO15, 0x00);
TOPAZEH_GPIO_PDEV(14,  IRQ_GPIO12_GPIO15, 0x00);
TOPAZEH_GPIO_PDEV(15,  IRQ_GPIO12_GPIO15, 0x00);

static void topazeh_gpio_init(void)
{
	platform_device_register(&topazeh_pwgpio0_pdev);
	platform_device_register(&topazeh_pwgpio1_pdev);
	platform_device_register(&topazeh_pwgpio2_pdev);
	platform_device_register(&topazeh_pwgpio3_pdev);
	platform_device_register(&topazeh_pwgpio4_pdev);
	platform_device_register(&topazeh_pwgpio5_pdev);
	platform_device_register(&topazeh_pwgpio6_pdev);
	platform_device_register(&topazeh_pwgpio7_pdev);
	platform_device_register(&topazeh_pwgpio8_pdev);
	platform_device_register(&topazeh_pwgpio9_pdev);        
        platform_device_register(&topazeh_pwgpio10_pdev);
        platform_device_register(&topazeh_pwgpio11_pdev);
        platform_device_register(&topazeh_pwgpio12_pdev);
        platform_device_register(&topazeh_pwgpio13_pdev);
        platform_device_register(&topazeh_pwgpio14_pdev);
        platform_device_register(&topazeh_pwgpio15_pdev);
}

static void __init topazeh_debug_uart_init(void)
{
#ifdef CONFIG_DEBUG_LL_UART_PL01X
	struct device_node *np = of_find_node_by_path("debug_ll_clk");
	struct of_phandle_args clkspec = {
		.np = np,
		.args_count = 0,
	};
	struct clk *clk = of_clk_get_from_provider(&clkspec);
	int rc;

	pr_err("%s:%d\n", __func__, __LINE__);
	if (IS_ERR(clk))
		pr_err("topazeh_init_late: can't find debug_ll_clk alias\n");
	else if ((rc = clk_prepare_enable(clk)))
		pr_err("topazeh_init_late: can't enable debug_ll_clk %s\n",
		       np ? np->name : "<NULL>");
#endif
}

/*
#define TOPAZEH_GPIOPORT(prt, bit)       ((prt) * 8 + (bit))

#if IS_ENABLED(CONFIG_I2C_GPIO)
#define SW_I2C_SDA0  TOPAZEH_GPIOPORT(1, 5)
#define SW_I2C_SCL0  TOPAZEH_GPIOPORT(1, 4)
#include <linux/i2c-gpio.h>
static struct i2c_gpio_platform_data i2c_gpio_data = {
        .sda_pin                = SW_I2C_SDA0,
        .scl_pin                = SW_I2C_SCL0,
        .udelay                 = 10,
};

static struct platform_device i2c_gpio_device = {
        .name           = "i2c-gpio",
        .id             = 3,
        .dev            = {
                .platform_data  = &i2c_gpio_data,
        },
};
#endif  */

static struct resource topazeh_sw2wire0_resources[] = {
        [0] = {
                .start  = GPIO1_V2_BASE,
                .end    = GPIO1_V2_BASE + 0x424 - 1,
                .flags  = IORESOURCE_MEM
        },
        [1] = {
                .start  = -1,
                .end    = -1,
                .flags  = IORESOURCE_IRQ
        }
};

static struct platform_device topazeh_sw2wire0_device = {
        .name           = "pwsw2wire",
        .id             = 0,
        .num_resources  = ARRAY_SIZE(topazeh_sw2wire0_resources),
        .resource       = topazeh_sw2wire0_resources,
        .dev            ={
                  .platform_data = 0x3,                //i2c-3
        },
};

void __init topazeh_init(void)
{
	pm_power_off = topazeh_enter_low_power_sleep;
	of_platform_populate(NULL, of_default_bus_match_table,
			     topazeh_dt_auxdata_lookup, NULL);
	l2x0_of_init(0, ~0);
	topazeh_gpio_init();
	topazeh_debug_uart_init();
#if IS_ENABLED(CONFIG_I2C_GPIO)
         platform_device_register(&i2c_gpio_device);
#endif
         platform_device_register(&topazeh_sw2wire0_device);
         platform_device_register(&topazeh_adc8ch_device);
}


/*
 * system peripherals mapped early during boot
 */
#define IO_DESC(base, size) { .virtual = IO_ADDRESS(base), \
        .pfn = __phys_to_pfn(base), \
        .length = size, \
        .type = MT_DEVICE }

static struct map_desc topazeh_io_desc[] __initdata = {
	IO_DESC(0xfd000000, SZ_32M), // map all IO
};

void __init topazeh_map_io(void)
{
	iotable_init(topazeh_io_desc, ARRAY_SIZE(topazeh_io_desc));
}

static const char *topazeh_dt_match[] = {
	"pixelworks,topazeh-fpga",
	"pixelworks,topazeh-eval",
	NULL,
};

DT_MACHINE_START(PIXELWORKS, "Pixelworks Topazeh")
	.atag_offset	= 0x100,
	.map_io		= topazeh_map_io,
	.init_machine	= topazeh_init,
	.dt_compat	= topazeh_dt_match,
	.restart	= topazeh_restart,
MACHINE_END
