/*
 *  Copyright (C) 2013 Pixelworks, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <linux/linkage.h>
#include <mach/hardware.h>

// sysmap.h has UL postfix, not usable in asm code
#define DDR2_DDR3_V4_BASE_ADDR 0xfec80000

/* register usage */
tmp	.req r4
ptr	.req r5
resume	.req r11


	.pushsection    .idmap.text, "ax"
ENTRY(topazeh_suspend_fn)
	// save resume function address
	mov	resume, r0

	// load ITCM jump address
	ldr	ptr, =topazeh_suspend_itcm_phys
	ldr	ptr, [ptr]

	/* turn off MMU */
	mrc	p15, 0, r0, c1, c0, 0		@ ctrl register
	bic	r0, r0, #0x0001			@ ...............m
	mcr	p15, 0, r0, c1, c0, 0		@ disable caches

	// jump to ITCM
	mov	pc, ptr
	.ltorg
ENDPROC(topazeh_suspend_fn);
	.popsection

#define S2RAM

/* void topazeh_s2ram(void) */
ENTRY(topazeh_s2ram)
	/* drain write buffer */
	mov	tmp, #0
	mcr	p15, 0, tmp, c7, c10, 4

#ifdef S2RAM
	/* enter self-refresh mode */
	ldr	ptr, =DDR2_DDR3_V4_BASE_ADDR
	// set R_SELF_REFRESH_EN
	ldr	tmp, [ptr, #0x004]
	orr	tmp, #0x00000010
	str	tmp, [ptr, #0x004]
	// Polling SELF_REFRESH_PERIOD until it becomes to 1...
1:	ldr	tmp, [ptr, #0x06c]
	ands	tmp, #(1 << 29)
	beq	1b
	// Clear R_SELF_REFRESH_EN
	ldr	tmp, [ptr, #0x004]
	and	tmp, #~0x00000010
	str	tmp, [ptr, #0x004]
#ifdef CASE_2
	// set R_SET_DFI_INIT_START
	ldr	tmp, [ptr, #0x000]
	orr	tmp, #0x00000010
	str	tmp, [ptr, #0x000]
	// Polling DFI_INIT_COMPLETE until it becomes to 0...
1:	ldr	tmp, [ptr, #0x06c]
	ands	tmp, #(1 << 31)
	bne	1b
#endif

	/* slow or gate clocks */
	//TODO
#endif

	/* wait for interrupt */
	mov	tmp, #0
	mcr	p15, 0, tmp, c7, c0, 4

#ifdef S2RAM
	/* restore clocks */
	//TODO

	/* exit self-refresh */
	ldr	ptr, =DDR2_DDR3_V4_BASE_ADDR
#ifdef CASE_2
	// clear R_SET_DFI_INIT_START
	ldr	tmp, [ptr, #0x000]
	and	tmp, #~0x00000010
	str	tmp, [ptr, #0x000]
	// set R_CLR_DFI_INIT_START
	orr	tmp, #0x00000020
	str	tmp, [ptr, #0x000]
	// Polling DFI_INIT_COMPLETE until it becomes to 1...
1:	ldr	tmp, [ptr, #0x06c]
	ands	tmp, #(1 << 31)
	beq	1b
	// clear R_CLR_DFI_INIT_START
	ldr	tmp, [ptr, #0x000]
	and	tmp, #~0x00000020
	str	tmp, [ptr, #0x000]
	// set R_SPDCHG_IN_SELFREF
	orr	tmp, #0x08
	str	tmp, [ptr, #0x000]
#endif
	// set R_SELF_REFRESH_DIS
	ldr	tmp, [ptr, #0x004]
	orr	tmp, #0x00000020
	str	tmp, [ptr, #0x004]
	// Polling AUTO_MRS_DONE until it becomes to 1...
1:	ldr	tmp, [ptr, #0x06c]
	ands	tmp, #(1 << 30)
	beq	1b
#ifdef CASE_2
	// clear R_SPDCHG_IN_SELFREF
	ldr	tmp, [ptr, #0x000]
	and	tmp, #~0x00000008
	str	tmp, [ptr, #0x000]
#endif
	// clear R_SELF_REFRESH_DIS
	ldr	tmp, [ptr, #0x004]
	and	tmp, #~0x00000020
	str	tmp, [ptr, #0x004]
#endif

	mov	pc, resume
	.ltorg
ENDPROC(topazeh_s2ram)

ENTRY(topazeh_s2ram_size)
	.word . - topazeh_s2ram
