/* -------------------------------------------------------------------------- *\
 * pwi2s.h -- Pixelworks I2S driver for ALSA -- hwdep ioctl definitions

   Copyright 2010 Pixelworks Inc.

   This file is licensed under version 2 of GPL only when included in
   Linux kernel driver files.
   In all other cases it is licensed under the terms of a separate,
   written license fromPixelworks, Inc..

   See below for more details.
\* -------------------------------------------------------------------------- */

/* -------------------------------------------------------------------------- *\
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\* -------------------------------------------------------------------------- */

// ---------------------------------------------------------------------------
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// ---------------------------------------------------------------------------
// Copyright 2006-2010 (c) Pixelworks Inc.
//
// Pixelworks owns the sole copyright to this software. Under international
// copyright laws you (1) may not make a copy of this software except for
// the purposes of maintaining a single archive copy, (2) may not derive
// works herefrom, (3) may not distribute this work to others. These rights
// are provided for information clarification, other restrictions of rights
// may apply as well.
//
// This is an unpublished work.
// ---------------------------------------------------------------------------
// >>>>>>>>>>>>>>>>>>>>>>>>>>>> WARRANTEE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// ---------------------------------------------------------------------------
// Pixelworks Inc. MAKES NO WARRANTY OF ANY KIND WITH REGARD TO THE USE OF
// THIS SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO,
// THE IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
// PURPOSE.
// ---------------------------------------------------------------------------


#include <linux/types.h>
#include <linux/ioctl.h>

struct pwi2s_buffer_config {
	__u32 ap_line_size;	// audio proc memory line size in 256bit units
	__u32 buf_addr;		// physical address of audio buffer
	__u32 buf_size;		// number of bytes
};

struct pwi2s_delay_config {
	int enable_delay;	// 0: ALSA, 1:delay
	__u32 audio_input_src;	// I2S0, I2S1, HDMI0...3
	__u32 time_slice;	// number of I2S clock cycles
	__u32 delay;		// number of time slices
};

struct pwi2s_pointer_config {
	int set_pointer_to_end;
};

struct pwi2s_gpio_config {
	int enable_gpio;
};

// set buffer address and size so that ALSA driver can use them
#define PWI2S_SET_BUFFER_CONFIG _IOW('p', 180, struct pwi2s_buffer_config)

// switch between delay mode and ALSA access
#define PWI2S_SET_DELAY_MODE _IOW('p', 181, struct pwi2s_delay_config)

// set pcm pointer position
#define PWI2S_SET_POINTER_MODE _IOW('p', 182, struct pwi2s_pointer_config)

// set pcm pointer position
#define PWI2S_SET_GPIO_MODE _IOW('p', 183, struct pwi2s_gpio_config)

// get bypass mode status
#define PWI2S_GET_BYPASS_MODE _IO('p', 184)

// set/clear bypass mode
#define PWI2S_SET_BYPASS_MODE _IOW('p', 185, unsigned int)

// get pol out status
#define PWI2S_GET_POLOUT_MODE _IO('p', 186)

// set/clear pol out mode
#define PWI2S_SET_POLOUT_MODE _IOW('p', 187, unsigned int)
